/*
 * SymReaderView.java Patrick Meng 2008
 */

package symreader;

import java.awt.Color;
import java.awt.event.KeyEvent;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.TaskMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSpinner;

import javax.swing.DefaultListModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JFileChooser;
import java.text.NumberFormat;


//import java.util.concurrent.Executor;
import java.lang.Thread;
/**
 * The application's main frame.
 */
public class SymReaderView extends FrameView {

    public SymReaderView(SingleFrameApplication app) {
        super(app);

        initComponents();
        

        // status bar initialization - message timeout, idle icon and busy animation, etc
        ResourceMap resourceMap = getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        messageTimer = new Timer(messageTimeout, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                statusMessageLabel.setText("");
            }
        });
        messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < busyIcons.length; i++) {
            busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
                statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
            }
        });
        idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        statusAnimationLabel.setIcon(idleIcon);
        progressBar.setVisible(false);

        // connecting action tasks to status bar via TaskMonitor
        TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!busyIconTimer.isRunning()) {
                        statusAnimationLabel.setIcon(busyIcons[0]);
                        busyIconIndex = 0;
                        busyIconTimer.start();
                    }
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    busyIconTimer.stop();
                    statusAnimationLabel.setIcon(idleIcon);
                    progressBar.setVisible(false);
                    progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)(evt.getNewValue());
                    statusMessageLabel.setText((text == null) ? "" : text);
                    messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)(evt.getNewValue());
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(false);
                    progressBar.setValue(value);
                }
            }
        });
        initMyComponents();
    }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = SymReaderApp.getApplication().getMainFrame();
            aboutBox = new SymReaderAboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        SymReaderApp.getApplication().show(aboutBox);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        mainPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        SymLoad = new javax.swing.JButton();
        MenuBar = new javax.swing.JToolBar();
        playSongButton = new javax.swing.JButton();
        stopSongButton = new javax.swing.JButton();
        playPatternButton = new javax.swing.JButton();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        loadModMenuItem = new javax.swing.JMenuItem();
        loadSampleMenuItem = new javax.swing.JMenuItem();
        newSongMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
        statusPanel = new javax.swing.JPanel();
        javax.swing.JSeparator statusPanelSeparator = new javax.swing.JSeparator();
        statusMessageLabel = new javax.swing.JLabel();
        statusAnimationLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();
        frmInstrList = new javax.swing.JFrame();
        jScrollPane2 = new javax.swing.JScrollPane();
        InstrList = new javax.swing.JList();
        FrmInstrDetails = new javax.swing.JFrame();
        InstrDetNr = new javax.swing.JSpinner();
        lblInstrNr = new javax.swing.JLabel();
        lblVolume = new javax.swing.JLabel();
        InstrDetVolume = new javax.swing.JSpinner();
        lblTune = new javax.swing.JLabel();
        InstrDetTune = new javax.swing.JSpinner();
        lblFineTune = new javax.swing.JLabel();
        InstrDetFineTune = new javax.swing.JSpinner();
        InstrDetTxt = new javax.swing.JTextField();
        jToolBar1 = new javax.swing.JToolBar();
        InstrDetLoadSample = new javax.swing.JButton();
        InstrDetExportRawSample = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        InstrDetSampleView = new javax.swing.JLayeredPane();
        InstrDetNoDsp = new javax.swing.JCheckBox();
        InstrDetStereoType = new javax.swing.JComboBox();
        InstrNoDetune = new javax.swing.JCheckBox();
        InstrDetSyncPlay = new javax.swing.JCheckBox();
        InstrDetFormat = new javax.swing.JTextField();
        InstrDetSampleResolution = new javax.swing.JTextField();
        InstrDetViewFormat = new javax.swing.JComboBox();
        InstrDetLoopText = new javax.swing.JLabel();
        frmSystem = new javax.swing.JFrame();
        SysTab = new javax.swing.JTabbedPane();
        SystemPanel = new javax.swing.JPanel();
        SysInterpolationType = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        SysMasterVolume = new javax.swing.JSlider();
        SysMasterTune = new javax.swing.JSlider();
        SysMasterMixRate = new javax.swing.JTextField();
        SysMasterVoices = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        SysDitheringCombox = new javax.swing.JComboBox();
        SysMasterBPMAdj = new javax.swing.JSlider();
        SysDeclicking = new javax.swing.JCheckBox();
        SysMasterBPM = new javax.swing.JTextField();
        jLabel17 = new javax.swing.JLabel();
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();
        jLabel8 = new javax.swing.JLabel();
        SysDeclickingLenSlider = new javax.swing.JSlider();
        jLabel10 = new javax.swing.JLabel();
        SysDSPPanel = new javax.swing.JPanel();
        SysDspMixVolumeSlider = new javax.swing.JSlider();
        SysDspFxTypeCombox = new javax.swing.JComboBox();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        SysDspFeedback = new javax.swing.JSlider();
        jLabel14 = new javax.swing.JLabel();
        SysDspLength = new javax.swing.JSlider();
        SysDspLPFilter = new javax.swing.JCheckBox();
        SysDspPreDelay = new javax.swing.JSlider();
        jLabel15 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        SysSyncToBeat = new javax.swing.JCheckBox();
        jLabel18 = new javax.swing.JLabel();
        SysUpdatePanel = new javax.swing.JPanel();
        SysUpdateSamplePos = new javax.swing.JCheckBox();
        SysUpdatePatternNr = new javax.swing.JCheckBox();
        SysUpdateCrsr = new javax.swing.JCheckBox();
        SysLoadingPanel = new javax.swing.JPanel();
        SysLoadModDeactivateDsp = new javax.swing.JCheckBox();
        SysStatusLabel = new javax.swing.JLabel();
        PosListjFrame = new javax.swing.JFrame();
        PosListPane = new javax.swing.JScrollPane();
        PosListJList = new javax.swing.JList();

        mainPanel.setName("mainPanel"); // NOI18N
        mainPanel.setPreferredSize(new java.awt.Dimension(320, 512));

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel1.setName("jPanel1"); // NOI18N

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        jList1.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { ">>> Load a Song Module (*.SymMod)" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jList1.setName("jList1"); // NOI18N
        jScrollPane1.setViewportView(jList1);

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(symreader.SymReaderApp.class).getContext().getResourceMap(SymReaderView.class);
        SymLoad.setText(resourceMap.getString("SymLoad.text")); // NOI18N
        SymLoad.setName("SymLoad"); // NOI18N
        SymLoad.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SymLoadActionPerformed(evt);
            }
        });

        MenuBar.setFloatable(false);
        MenuBar.setRollover(true);
        MenuBar.setName("MenuBar"); // NOI18N

        playSongButton.setFont(resourceMap.getFont("playSongButton.font")); // NOI18N
        playSongButton.setText(resourceMap.getString("playSongButton.text")); // NOI18N
        playSongButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        playSongButton.setFocusable(false);
        playSongButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        playSongButton.setName("playSongButton"); // NOI18N
        playSongButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        playSongButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playSongButtonActionPerformed(evt);
            }
        });
        MenuBar.add(playSongButton);

        stopSongButton.setText(resourceMap.getString("stopSongButton.text")); // NOI18N
        stopSongButton.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        stopSongButton.setFocusable(false);
        stopSongButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        stopSongButton.setName("stopSongButton"); // NOI18N
        stopSongButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        stopSongButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopSongButtonActionPerformed(evt);
            }
        });
        MenuBar.add(stopSongButton);

        playPatternButton.setText(resourceMap.getString("playPatternButton.text")); // NOI18N
        playPatternButton.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        playPatternButton.setFocusable(false);
        playPatternButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        playPatternButton.setName("playPatternButton"); // NOI18N
        playPatternButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        playPatternButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playPatternButtonActionPerformed(evt);
            }
        });
        MenuBar.add(playPatternButton);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(MenuBar, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 291, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 281, Short.MAX_VALUE)
                            .addComponent(SymLoad, javax.swing.GroupLayout.DEFAULT_SIZE, 281, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addComponent(MenuBar, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 262, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SymLoad)
                .addContainerGap())
        );

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        menuBar.setName("menuBar"); // NOI18N

        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        loadModMenuItem.setText(resourceMap.getString("loadModMenuItem.text")); // NOI18N
        loadModMenuItem.setName("loadModMenuItem"); // NOI18N
        fileMenu.add(loadModMenuItem);

        loadSampleMenuItem.setText(resourceMap.getString("loadSampleMenuItem.text")); // NOI18N
        loadSampleMenuItem.setName("loadSampleMenuItem"); // NOI18N
        loadSampleMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadSampleMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(loadSampleMenuItem);

        newSongMenuItem.setText(resourceMap.getString("newSongMenuItem.text")); // NOI18N
        newSongMenuItem.setName("newSongMenuItem"); // NOI18N
        newSongMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newSongMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(newSongMenuItem);

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(symreader.SymReaderApp.class).getContext().getActionMap(SymReaderView.class, this);
        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setText(resourceMap.getString("exitMenuItem.text")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setName("aboutMenuItem"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        statusPanel.setName("statusPanel"); // NOI18N

        statusPanelSeparator.setName("statusPanelSeparator"); // NOI18N

        statusMessageLabel.setName("statusMessageLabel"); // NOI18N

        statusAnimationLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        statusAnimationLabel.setName("statusAnimationLabel"); // NOI18N

        progressBar.setName("progressBar"); // NOI18N

        javax.swing.GroupLayout statusPanelLayout = new javax.swing.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(statusPanelSeparator, javax.swing.GroupLayout.DEFAULT_SIZE, 305, Short.MAX_VALUE)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(statusMessageLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 135, Short.MAX_VALUE)
                .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(statusAnimationLabel)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addComponent(statusPanelSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 2, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(statusMessageLabel)
                    .addComponent(statusAnimationLabel)
                    .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(3, 3, 3))
        );

        frmInstrList.setTitle(resourceMap.getString("frmInstrList.title")); // NOI18N
        frmInstrList.setBounds(new java.awt.Rectangle(0, 0, 320, 320));
        frmInstrList.setName("frmInstrList"); // NOI18N

        jScrollPane2.setName("jScrollPane2"); // NOI18N

        InstrList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        InstrList.setName("InstrList"); // NOI18N
        InstrList.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                InstrListMouseClicked(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                InstrListMouseReleased(evt);
            }
        });
        InstrList.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                InstrListKeyTyped(evt);
            }
        });
        jScrollPane2.setViewportView(InstrList);

        javax.swing.GroupLayout frmInstrListLayout = new javax.swing.GroupLayout(frmInstrList.getContentPane());
        frmInstrList.getContentPane().setLayout(frmInstrListLayout);
        frmInstrListLayout.setHorizontalGroup(
            frmInstrListLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(frmInstrListLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 189, Short.MAX_VALUE)
                .addContainerGap())
        );
        frmInstrListLayout.setVerticalGroup(
            frmInstrListLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(frmInstrListLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 425, Short.MAX_VALUE)
                .addContainerGap())
        );

        frmInstrList.getAccessibleContext().setAccessibleParent(menuBar);

        FrmInstrDetails.setTitle(resourceMap.getString("FrmInstrDetails.title")); // NOI18N
        FrmInstrDetails.setBounds(new java.awt.Rectangle(0, 320, 320, 400));
        FrmInstrDetails.setName("FrmInstrDetails"); // NOI18N
        FrmInstrDetails.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                FrmInstrDetailsComponentResized(evt);
            }
        });
        FrmInstrDetails.addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener() {
            public void ancestorMoved(java.awt.event.HierarchyEvent evt) {
            }
            public void ancestorResized(java.awt.event.HierarchyEvent evt) {
                FrmInstrDetailsAncestorResized(evt);
            }
        });

        InstrDetNr.setName("InstrDetNr"); // NOI18N
        InstrDetNr.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                InstrDetNrStateChanged(evt);
            }
        });

        lblInstrNr.setText(resourceMap.getString("lblInstrNr.text")); // NOI18N
        lblInstrNr.setName("lblInstrNr"); // NOI18N

        lblVolume.setText(resourceMap.getString("lblVolume.text")); // NOI18N
        lblVolume.setName("lblVolume"); // NOI18N

        InstrDetVolume.setName("InstrDetVolume"); // NOI18N
        InstrDetVolume.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                InstrDetVolumeStateChanged(evt);
            }
        });

        lblTune.setText(resourceMap.getString("lblTune.text")); // NOI18N
        lblTune.setName("lblTune"); // NOI18N

        InstrDetTune.setName("InstrDetTune"); // NOI18N
        InstrDetTune.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                InstrDetTuneStateChanged(evt);
            }
        });

        lblFineTune.setText(resourceMap.getString("lblFineTune.text")); // NOI18N
        lblFineTune.setName("lblFineTune"); // NOI18N

        InstrDetFineTune.setName("InstrDetFineTune"); // NOI18N

        InstrDetTxt.setEditable(false);
        InstrDetTxt.setFont(resourceMap.getFont("InstrDetTxt.font")); // NOI18N
        InstrDetTxt.setName("InstrDetTxt"); // NOI18N

        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);
        jToolBar1.setName("jToolBar1"); // NOI18N

        InstrDetLoadSample.setFont(resourceMap.getFont("InstrDetLoadSample.font")); // NOI18N
        InstrDetLoadSample.setText(resourceMap.getString("InstrDetLoadSample.text")); // NOI18N
        InstrDetLoadSample.setFocusable(false);
        InstrDetLoadSample.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        InstrDetLoadSample.setName("InstrDetLoadSample"); // NOI18N
        InstrDetLoadSample.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        InstrDetLoadSample.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                InstrDetLoadSampleActionPerformed(evt);
            }
        });
        jToolBar1.add(InstrDetLoadSample);

        InstrDetExportRawSample.setFont(resourceMap.getFont("InstrDetExportRawSample.font")); // NOI18N
        InstrDetExportRawSample.setText(resourceMap.getString("InstrDetExportRawSample.text")); // NOI18N
        InstrDetExportRawSample.setFocusable(false);
        InstrDetExportRawSample.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        InstrDetExportRawSample.setName("InstrDetExportRawSample"); // NOI18N
        InstrDetExportRawSample.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        InstrDetExportRawSample.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                InstrDetExportRawSampleActionPerformed(evt);
            }
        });
        jToolBar1.add(InstrDetExportRawSample);

        jButton1.setFont(resourceMap.getFont("jButton1.font")); // NOI18N
        jButton1.setText(resourceMap.getString("jButton1.text")); // NOI18N
        jButton1.setEnabled(false);
        jButton1.setFocusable(false);
        jButton1.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton1.setName("jButton1"); // NOI18N
        jButton1.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar1.add(jButton1);

        jButton2.setText(resourceMap.getString("jButton2.text")); // NOI18N
        jButton2.setFocusable(false);
        jButton2.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton2.setName("jButton2"); // NOI18N
        jButton2.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton2);

        InstrDetSampleView.setBackground(resourceMap.getColor("InstrDetSampleView.background")); // NOI18N
        InstrDetSampleView.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        InstrDetSampleView.setDoubleBuffered(true);
        InstrDetSampleView.setName("InstrDetSampleView"); // NOI18N

        InstrDetNoDsp.setText(resourceMap.getString("InstrDetNoDsp.text")); // NOI18N
        InstrDetNoDsp.setName("InstrDetNoDsp"); // NOI18N
        InstrDetNoDsp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                InstrDetNoDspActionPerformed(evt);
            }
        });

        InstrDetStereoType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Mono", "Stereo L", "Stereo R", "Virtual Mix" }));
        InstrDetStereoType.setName("InstrDetStereoType"); // NOI18N

        InstrNoDetune.setText(resourceMap.getString("InstrNoDetune.text")); // NOI18N
        InstrNoDetune.setName("InstrNoDetune"); // NOI18N

        InstrDetSyncPlay.setText(resourceMap.getString("InstrDetSyncPlay.text")); // NOI18N
        InstrDetSyncPlay.setName("InstrDetSyncPlay"); // NOI18N

        InstrDetFormat.setEditable(false);
        InstrDetFormat.setText(resourceMap.getString("InstrDetFormat.text")); // NOI18N
        InstrDetFormat.setName("InstrDetFormat"); // NOI18N

        InstrDetSampleResolution.setEditable(false);
        InstrDetSampleResolution.setText(resourceMap.getString("InstrDetSampleResolution.text")); // NOI18N
        InstrDetSampleResolution.setName("InstrDetSampleResolution"); // NOI18N

        InstrDetViewFormat.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Lines", "Pixel", "Pixel Fast", "Filled" }));
        InstrDetViewFormat.setName("InstrDetViewFormat"); // NOI18N
        InstrDetViewFormat.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                InstrDetViewFormatItemStateChanged(evt);
            }
        });

        InstrDetLoopText.setText(resourceMap.getString("InstrDetLoopText.text")); // NOI18N
        InstrDetLoopText.setName("InstrDetLoopText"); // NOI18N

        javax.swing.GroupLayout FrmInstrDetailsLayout = new javax.swing.GroupLayout(FrmInstrDetails.getContentPane());
        FrmInstrDetails.getContentPane().setLayout(FrmInstrDetailsLayout);
        FrmInstrDetailsLayout.setHorizontalGroup(
            FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(InstrDetSampleView, javax.swing.GroupLayout.DEFAULT_SIZE, 488, Short.MAX_VALUE)
                    .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                        .addComponent(InstrDetNoDsp)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(InstrDetSyncPlay)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(InstrNoDetune, javax.swing.GroupLayout.PREFERRED_SIZE, 121, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 156, Short.MAX_VALUE)
                        .addComponent(InstrDetViewFormat, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                        .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jToolBar1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 488, Short.MAX_VALUE)
                            .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                                .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(lblInstrNr)
                                    .addComponent(lblVolume)
                                    .addComponent(lblTune))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                                        .addComponent(InstrDetNr, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addGap(18, 18, 18)
                                        .addComponent(InstrDetTxt, javax.swing.GroupLayout.DEFAULT_SIZE, 344, Short.MAX_VALUE))
                                    .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                                        .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(InstrDetTune, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(InstrDetVolume, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addGap(20, 20, 20)
                                        .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                                                .addComponent(InstrDetStereoType, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(InstrDetSampleResolution, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(InstrDetFormat, javax.swing.GroupLayout.DEFAULT_SIZE, 226, Short.MAX_VALUE))
                                            .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                                                .addComponent(lblFineTune)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(InstrDetFineTune, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 239, Short.MAX_VALUE)))))))
                        .addContainerGap())
                    .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                        .addComponent(InstrDetLoopText, javax.swing.GroupLayout.DEFAULT_SIZE, 478, Short.MAX_VALUE)
                        .addContainerGap())))
        );
        FrmInstrDetailsLayout.setVerticalGroup(
            FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 37, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                        .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(lblInstrNr)
                            .addComponent(InstrDetNr, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(InstrDetTxt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(lblVolume)
                            .addComponent(InstrDetVolume, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(lblTune))
                    .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                        .addGap(26, 26, 26)
                        .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                                .addComponent(InstrDetTune, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(20, 20, 20))
                            .addGroup(FrmInstrDetailsLayout.createSequentialGroup()
                                .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(InstrDetStereoType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(InstrDetSampleResolution, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(InstrDetFormat, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(lblFineTune)
                                    .addComponent(InstrDetFineTune, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(20, 20, 20)))))
                .addGap(18, 18, 18)
                .addGroup(FrmInstrDetailsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(InstrDetNoDsp)
                    .addComponent(InstrDetSyncPlay)
                    .addComponent(InstrDetViewFormat, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(InstrNoDetune))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(InstrDetSampleView, javax.swing.GroupLayout.DEFAULT_SIZE, 233, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(InstrDetLoopText, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        frmSystem.setTitle(resourceMap.getString("frmSystem.title")); // NOI18N
        frmSystem.setBounds(new java.awt.Rectangle(320, 320, 320, 320));
        frmSystem.setName("frmSystem"); // NOI18N

        SysTab.setName("SysTab"); // NOI18N

        SystemPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        SystemPanel.setName("Audio"); // NOI18N
        SystemPanel.setPreferredSize(new java.awt.Dimension(320, 400));
        SystemPanel.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                SystemPanelKeyPressed(evt);
            }
            public void keyTyped(java.awt.event.KeyEvent evt) {
                SystemPanelKeyTyped(evt);
            }
        });

        SysInterpolationType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Off", "Linear" }));
        SysInterpolationType.setSelectedIndex(1);
        SysInterpolationType.setName("SysInterpolationType"); // NOI18N
        SysInterpolationType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysInterpolationTypeActionPerformed(evt);
            }
        });

        jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
        jLabel4.setName("jLabel4"); // NOI18N

        jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
        jLabel5.setName("jLabel5"); // NOI18N

        jLabel6.setText(resourceMap.getString("jLabel6.text")); // NOI18N
        jLabel6.setName("jLabel6"); // NOI18N

        jLabel7.setText(resourceMap.getString("jLabel7.text")); // NOI18N
        jLabel7.setName("jLabel7"); // NOI18N

        SysMasterVolume.setMajorTickSpacing(10);
        SysMasterVolume.setMinorTickSpacing(5);
        SysMasterVolume.setPaintLabels(true);
        SysMasterVolume.setPaintTicks(true);
        SysMasterVolume.setValue(100);
        SysMasterVolume.setName("SysMasterVolume"); // NOI18N
        SysMasterVolume.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysMasterVolumeStateChanged(evt);
            }
        });

        SysMasterTune.setMajorTickSpacing(2);
        SysMasterTune.setMaximum(10);
        SysMasterTune.setMinimum(-10);
        SysMasterTune.setMinorTickSpacing(1);
        SysMasterTune.setPaintLabels(true);
        SysMasterTune.setPaintTicks(true);
        SysMasterTune.setValue(0);
        SysMasterTune.setName("SysMasterTune"); // NOI18N
        SysMasterTune.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysMasterTuneStateChanged(evt);
            }
        });

        SysMasterMixRate.setEditable(false);
        SysMasterMixRate.setText(resourceMap.getString("SysMasterMixRate.text")); // NOI18N
        SysMasterMixRate.setName("SysMasterMixRate"); // NOI18N

        SysMasterVoices.setEditable(false);
        SysMasterVoices.setText(resourceMap.getString("SysMasterVoices.text")); // NOI18N
        SysMasterVoices.setName("SysMasterVoices"); // NOI18N

        jLabel9.setText(resourceMap.getString("jLabel9.text")); // NOI18N
        jLabel9.setName("jLabel9"); // NOI18N

        SysDitheringCombox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Off", "Random" }));
        SysDitheringCombox.setName("SysDitheringCombox"); // NOI18N
        SysDitheringCombox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysDitheringComboxActionPerformed(evt);
            }
        });

        SysMasterBPMAdj.setMajorTickSpacing(10);
        SysMasterBPMAdj.setMaximum(150);
        SysMasterBPMAdj.setMinimum(50);
        SysMasterBPMAdj.setMinorTickSpacing(5);
        SysMasterBPMAdj.setPaintLabels(true);
        SysMasterBPMAdj.setPaintTicks(true);
        SysMasterBPMAdj.setValue(100);
        SysMasterBPMAdj.setName("SysMasterBPMAdj"); // NOI18N
        SysMasterBPMAdj.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysMasterBPMAdjStateChanged(evt);
            }
        });

        SysDeclicking.setSelected(true);
        SysDeclicking.setText(resourceMap.getString("SysDeclicking.text")); // NOI18N
        SysDeclicking.setName("SysDeclicking"); // NOI18N
        SysDeclicking.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysDeclickingActionPerformed(evt);
            }
        });

        SysMasterBPM.setEditable(false);
        SysMasterBPM.setText(resourceMap.getString("SysMasterBPM.text")); // NOI18N
        SysMasterBPM.setName("SysMasterBPM"); // NOI18N

        jLabel17.setText(resourceMap.getString("jLabel17.text")); // NOI18N
        jLabel17.setName("jLabel17"); // NOI18N

        jButton3.setText(resourceMap.getString("jButton3.text")); // NOI18N
        jButton3.setName("jButton3"); // NOI18N
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jButton4.setText(resourceMap.getString("jButton4.text")); // NOI18N
        jButton4.setName("jButton4"); // NOI18N
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        jLabel8.setText(resourceMap.getString("jLabel8.text")); // NOI18N
        jLabel8.setName("jLabel8"); // NOI18N

        SysDeclickingLenSlider.setMajorTickSpacing(100);
        SysDeclickingLenSlider.setMaximum(500);
        SysDeclickingLenSlider.setMinorTickSpacing(50);
        SysDeclickingLenSlider.setPaintLabels(true);
        SysDeclickingLenSlider.setPaintTicks(true);
        SysDeclickingLenSlider.setValue(25);
        SysDeclickingLenSlider.setName("SysDeclickingLenSlider"); // NOI18N
        SysDeclickingLenSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysDeclickingLenSliderStateChanged(evt);
            }
        });

        jLabel10.setName("jLabel10"); // NOI18N

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, SysDeclickingLenSlider, org.jdesktop.beansbinding.ELProperty.create("${value}"), jLabel10, org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        javax.swing.GroupLayout SystemPanelLayout = new javax.swing.GroupLayout(SystemPanel);
        SystemPanel.setLayout(SystemPanelLayout);
        SystemPanelLayout.setHorizontalGroup(
            SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SystemPanelLayout.createSequentialGroup()
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SystemPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(SystemPanelLayout.createSequentialGroup()
                                .addComponent(jLabel7)
                                .addGap(29, 29, 29))
                            .addGroup(SystemPanelLayout.createSequentialGroup()
                                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(jButton4)
                                    .addComponent(jButton3))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                        .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(SysMasterVolume, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 302, Short.MAX_VALUE)
                            .addComponent(SysMasterTune, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 302, Short.MAX_VALUE)
                            .addGroup(SystemPanelLayout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(SysMasterBPMAdj, javax.swing.GroupLayout.DEFAULT_SIZE, 302, Short.MAX_VALUE))))
                    .addGroup(SystemPanelLayout.createSequentialGroup()
                        .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(SystemPanelLayout.createSequentialGroup()
                                .addGap(54, 54, 54)
                                .addComponent(SysMasterVoices, javax.swing.GroupLayout.PREFERRED_SIZE, 64, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jLabel6))
                        .addGap(18, 18, 18)
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysMasterMixRate, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jLabel17)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysMasterBPM, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(SystemPanelLayout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysInterpolationType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(38, 38, 38)
                        .addComponent(jLabel9)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysDitheringCombox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(50, 50, 50))
                    .addGroup(SystemPanelLayout.createSequentialGroup()
                        .addComponent(jLabel8)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysDeclicking)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel10)
                        .addGap(16, 16, 16)
                        .addComponent(SysDeclickingLenSlider, javax.swing.GroupLayout.DEFAULT_SIZE, 302, Short.MAX_VALUE)))
                .addContainerGap())
        );
        SystemPanelLayout.setVerticalGroup(
            SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SystemPanelLayout.createSequentialGroup()
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(SysMasterVoices, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5)
                    .addComponent(SysMasterMixRate, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel17)
                    .addComponent(SysMasterBPM, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(28, 28, 28)
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel7)
                    .addComponent(SysMasterVolume, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButton3)
                    .addComponent(SysMasterTune, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(14, 14, 14)
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(SysMasterBPMAdj, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton4))
                .addGap(18, 18, 18)
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel4)
                        .addComponent(SysInterpolationType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel9)
                        .addComponent(SysDitheringCombox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(6, 6, 6)
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel10)
                    .addComponent(SysDeclicking)
                    .addComponent(jLabel8)
                    .addComponent(SysDeclickingLenSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(47, Short.MAX_VALUE))
        );

        SysTab.addTab(resourceMap.getString("Audio.TabConstraints.tabTitle"), SystemPanel); // NOI18N

        SysDSPPanel.setName("SysDSPPanel"); // NOI18N

        SysDspMixVolumeSlider.setMajorTickSpacing(10);
        SysDspMixVolumeSlider.setMinorTickSpacing(5);
        SysDspMixVolumeSlider.setPaintLabels(true);
        SysDspMixVolumeSlider.setPaintTicks(true);
        SysDspMixVolumeSlider.setValue(75);
        SysDspMixVolumeSlider.setName("SysDspMixVolumeSlider"); // NOI18N
        SysDspMixVolumeSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysDspMixVolumeSliderStateChanged(evt);
            }
        });

        SysDspFxTypeCombox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Off", "Echo", "CrossEcho", "Delay", "CrossDelay" }));
        SysDspFxTypeCombox.setName("SysDspFxTypeCombox"); // NOI18N
        SysDspFxTypeCombox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysDspFxTypeComboxActionPerformed(evt);
            }
        });

        jLabel11.setText(resourceMap.getString("jLabel11.text")); // NOI18N
        jLabel11.setName("jLabel11"); // NOI18N

        jLabel12.setText(resourceMap.getString("jLabel12.text")); // NOI18N
        jLabel12.setName("jLabel12"); // NOI18N

        jLabel13.setText(resourceMap.getString("jLabel13.text")); // NOI18N
        jLabel13.setName("jLabel13"); // NOI18N

        SysDspFeedback.setBackground(resourceMap.getColor("SysDspFeedback.background")); // NOI18N
        SysDspFeedback.setMajorTickSpacing(10);
        SysDspFeedback.setMaximum(99);
        SysDspFeedback.setMinorTickSpacing(5);
        SysDspFeedback.setPaintLabels(true);
        SysDspFeedback.setPaintTicks(true);
        SysDspFeedback.setName("SysDspFeedback"); // NOI18N
        SysDspFeedback.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysDspFeedbackStateChanged(evt);
            }
        });

        jLabel14.setText(resourceMap.getString("jLabel14.text")); // NOI18N
        jLabel14.setName("jLabel14"); // NOI18N

        SysDspLength.setMajorTickSpacing(10);
        SysDspLength.setMinimum(10);
        SysDspLength.setMinorTickSpacing(5);
        SysDspLength.setPaintLabels(true);
        SysDspLength.setPaintTicks(true);
        SysDspLength.setValue(100);
        SysDspLength.setName("SysDspLength"); // NOI18N
        SysDspLength.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysDspLengthStateChanged(evt);
            }
        });

        SysDspLPFilter.setText(resourceMap.getString("SysDspLPFilter.text")); // NOI18N
        SysDspLPFilter.setEnabled(false);
        SysDspLPFilter.setName("SysDspLPFilter"); // NOI18N

        SysDspPreDelay.setMajorTickSpacing(10);
        SysDspPreDelay.setMinorTickSpacing(5);
        SysDspPreDelay.setPaintLabels(true);
        SysDspPreDelay.setPaintTicks(true);
        SysDspPreDelay.setValue(99);
        SysDspPreDelay.setName("SysDspPreDelay"); // NOI18N
        SysDspPreDelay.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysDspPreDelayStateChanged(evt);
            }
        });

        jLabel15.setText(resourceMap.getString("jLabel15.text")); // NOI18N
        jLabel15.setName("jLabel15"); // NOI18N

        jLabel16.setForeground(resourceMap.getColor("jLabel16.foreground")); // NOI18N
        jLabel16.setText(resourceMap.getString("jLabel16.text")); // NOI18N
        jLabel16.setName("jLabel16"); // NOI18N

        SysSyncToBeat.setText(resourceMap.getString("SysSyncToBeat.text")); // NOI18N
        SysSyncToBeat.setName("SysSyncToBeat"); // NOI18N
        SysSyncToBeat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysSyncToBeatActionPerformed(evt);
            }
        });

        jLabel18.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jLabel18.setName("jLabel18"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, SysDspLength, org.jdesktop.beansbinding.ELProperty.create("${value}"), jLabel18, org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        javax.swing.GroupLayout SysDSPPanelLayout = new javax.swing.GroupLayout(SysDSPPanel);
        SysDSPPanel.setLayout(SysDSPPanelLayout);
        SysDSPPanelLayout.setHorizontalGroup(
            SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysDSPPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel12)
                    .addComponent(jLabel11)
                    .addComponent(jLabel14)
                    .addComponent(jLabel13)
                    .addComponent(jLabel15))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(SysDspPreDelay, javax.swing.GroupLayout.DEFAULT_SIZE, 330, Short.MAX_VALUE)
                    .addComponent(SysDspFeedback, javax.swing.GroupLayout.DEFAULT_SIZE, 330, Short.MAX_VALUE)
                    .addComponent(SysDspMixVolumeSlider, javax.swing.GroupLayout.DEFAULT_SIZE, 330, Short.MAX_VALUE)
                    .addGroup(SysDSPPanelLayout.createSequentialGroup()
                        .addComponent(jLabel18, javax.swing.GroupLayout.PREFERRED_SIZE, 35, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysDspLength, javax.swing.GroupLayout.DEFAULT_SIZE, 291, Short.MAX_VALUE)))
                .addGap(20, 20, 20))
            .addGroup(SysDSPPanelLayout.createSequentialGroup()
                .addGap(85, 85, 85)
                .addComponent(SysDspFxTypeCombox, javax.swing.GroupLayout.PREFERRED_SIZE, 106, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 84, Short.MAX_VALUE)
                .addComponent(jLabel16))
            .addGroup(SysDSPPanelLayout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addComponent(SysDspLPFilter)
                .addGap(18, 18, 18)
                .addComponent(SysSyncToBeat)
                .addContainerGap(245, Short.MAX_VALUE))
        );
        SysDSPPanelLayout.setVerticalGroup(
            SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysDSPPanelLayout.createSequentialGroup()
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SysDSPPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel11)
                            .addComponent(SysDspFxTypeCombox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jLabel16))
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SysDSPPanelLayout.createSequentialGroup()
                        .addGap(9, 9, 9)
                        .addComponent(jLabel12))
                    .addGroup(SysDSPPanelLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysDspMixVolumeSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel13)
                    .addComponent(SysDspFeedback, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(19, 19, 19)
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel14)
                        .addComponent(jLabel18, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(SysDspLength, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel15)
                    .addComponent(SysDspPreDelay, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(SysDspLPFilter)
                    .addComponent(SysSyncToBeat))
                .addGap(95, 95, 95))
        );

        SysTab.addTab(resourceMap.getString("SysDSPPanel.TabConstraints.tabTitle"), SysDSPPanel); // NOI18N

        SysUpdatePanel.setName("SysUpdatePanel"); // NOI18N

        SysUpdateSamplePos.setSelected(true);
        SysUpdateSamplePos.setText(resourceMap.getString("SysUpdateSamplePos.text")); // NOI18N
        SysUpdateSamplePos.setName("SysUpdateSamplePos"); // NOI18N

        SysUpdatePatternNr.setSelected(true);
        SysUpdatePatternNr.setText(resourceMap.getString("SysUpdatePatternNr.text")); // NOI18N
        SysUpdatePatternNr.setName("SysUpdatePatternNr"); // NOI18N

        SysUpdateCrsr.setSelected(true);
        SysUpdateCrsr.setText(resourceMap.getString("SysUpdateCrsr.text")); // NOI18N
        SysUpdateCrsr.setName("SysUpdateCrsr"); // NOI18N

        javax.swing.GroupLayout SysUpdatePanelLayout = new javax.swing.GroupLayout(SysUpdatePanel);
        SysUpdatePanel.setLayout(SysUpdatePanelLayout);
        SysUpdatePanelLayout.setHorizontalGroup(
            SysUpdatePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysUpdatePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(SysUpdatePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(SysUpdateSamplePos)
                    .addComponent(SysUpdatePatternNr)
                    .addComponent(SysUpdateCrsr))
                .addContainerGap(256, Short.MAX_VALUE))
        );
        SysUpdatePanelLayout.setVerticalGroup(
            SysUpdatePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysUpdatePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(SysUpdateSamplePos)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SysUpdatePatternNr)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SysUpdateCrsr)
                .addContainerGap(287, Short.MAX_VALUE))
        );

        SysTab.addTab(resourceMap.getString("SysUpdatePanel.TabConstraints.tabTitle"), SysUpdatePanel); // NOI18N

        SysLoadingPanel.setName("SysLoadingPanel"); // NOI18N

        SysLoadModDeactivateDsp.setText(resourceMap.getString("SysLoadModDeactivateDsp.text")); // NOI18N
        SysLoadModDeactivateDsp.setName("SysLoadModDeactivateDsp"); // NOI18N
        SysLoadModDeactivateDsp.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysLoadModDeactivateDspStateChanged(evt);
            }
        });

        javax.swing.GroupLayout SysLoadingPanelLayout = new javax.swing.GroupLayout(SysLoadingPanel);
        SysLoadingPanel.setLayout(SysLoadingPanelLayout);
        SysLoadingPanelLayout.setHorizontalGroup(
            SysLoadingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysLoadingPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(SysLoadModDeactivateDsp)
                .addContainerGap(190, Short.MAX_VALUE))
        );
        SysLoadingPanelLayout.setVerticalGroup(
            SysLoadingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysLoadingPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(SysLoadModDeactivateDsp)
                .addContainerGap(333, Short.MAX_VALUE))
        );

        SysTab.addTab(resourceMap.getString("SysLoadingPanel.TabConstraints.tabTitle"), SysLoadingPanel); // NOI18N

        SysStatusLabel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        SysStatusLabel.setName("SysStatusLabel"); // NOI18N

        javax.swing.GroupLayout frmSystemLayout = new javax.swing.GroupLayout(frmSystem.getContentPane());
        frmSystem.getContentPane().setLayout(frmSystemLayout);
        frmSystemLayout.setHorizontalGroup(
            frmSystemLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(SysStatusLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 428, Short.MAX_VALUE)
            .addComponent(SysTab, javax.swing.GroupLayout.DEFAULT_SIZE, 428, Short.MAX_VALUE)
        );
        frmSystemLayout.setVerticalGroup(
            frmSystemLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, frmSystemLayout.createSequentialGroup()
                .addComponent(SysTab, javax.swing.GroupLayout.DEFAULT_SIZE, 391, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SysStatusLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        SysTab.getAccessibleContext().setAccessibleName(resourceMap.getString("SysTab.AccessibleContext.accessibleName")); // NOI18N

        PosListjFrame.setTitle(resourceMap.getString("PosListjFrame.title")); // NOI18N
        PosListjFrame.setMinimumSize(new java.awt.Dimension(50, 50));
        PosListjFrame.setName("PosListjFrame"); // NOI18N

        PosListPane.setName("PosListPane"); // NOI18N

        PosListJList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        PosListJList.setMinimumSize(new java.awt.Dimension(320, 320));
        PosListJList.setName("PosListJList"); // NOI18N
        PosListJList.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                PosListJListMouseClicked(evt);
            }
        });
        PosListPane.setViewportView(PosListJList);

        javax.swing.GroupLayout PosListjFrameLayout = new javax.swing.GroupLayout(PosListjFrame.getContentPane());
        PosListjFrame.getContentPane().setLayout(PosListjFrameLayout);
        PosListjFrameLayout.setHorizontalGroup(
            PosListjFrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PosListjFrameLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(PosListPane, javax.swing.GroupLayout.DEFAULT_SIZE, 202, Short.MAX_VALUE)
                .addContainerGap())
        );
        PosListjFrameLayout.setVerticalGroup(
            PosListjFrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PosListjFrameLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(PosListPane, javax.swing.GroupLayout.DEFAULT_SIZE, 260, Short.MAX_VALUE)
                .addContainerGap())
        );

        setComponent(mainPanel);
        setMenuBar(menuBar);
        setStatusBar(statusPanel);

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents

        private void initMyComponents() {
            //SystemPanel.addKeyListener(mykeylistener);
            startUIRealTimeUpdate();
            ShowAllWindows();
            InitDefaultSong8Voices();
            readPreferences();
        }
    
   DefaultListModel listModel = new DefaultListModel(); 
   DefaultListModel InstrListModel = new DefaultListModel();
   DefaultListModel PosListModel = new DefaultListModel();
   
   UIManager SymphManager = new UIManager();
   VoiceExpander MyVoiceExpander = new VoiceExpander();
   ImportSongSymphonie ImportSymph; 
   
        // //SystemPanel.addKeyListener(mykeylistener);
//        java.awt.event.KeyListener mykeylistener = new java.awt.event.KeyListener() {

        
/* Print Info to Infopanel
*/
private void PrintToInfoWindow (String s){
    listModel.addElement(s);
}

private void PrintToInfoWindow (String s, int i){
    s = s + i;
    PrintToInfoWindow(s);
}

/*
void PrintLogList() {
    int len = MyVoiceExpander.LogList.size();
    String s;
    for(int i=0;i<len;i++) {
        s = MyVoiceExpander.LogList.get(i).toString();
        PrintToInfoWindow(s);
    }
}
*/

private void ExportInstrumentSampleRaw() {
    File f;
    FileOutputStream fo;
    int i;
    i = SymphManager.getActualInstrumentIndex();
    
    if((SymphManager.SymSong.getInstrument(i).SampleDataLoaded==true) && (i >= 0))  {
        JFileChooser jFc = new JFileChooser();
        PrintToInfoWindow("Exporting Sample Raw...");

        jFc.showSaveDialog(jFc);
        f = jFc.getSelectedFile();
        try { 
            if( f.createNewFile() == true) {
              fo = new FileOutputStream(f);
              fo.write(SymphManager.SymSong.getInstrument(i).ImportSample.RawSample);
              PrintToInfoWindow("Sample Export Done.");
            }
        } catch (java.io.IOException e) {
            PrintToInfoWindow("Error:File already exists. Aborted");
        }
        PrintToInfoWindow(f.toString());
    }
}

    private void UpdateActualInstrDetails() {
        UpdateInstrDetails(SymphManager.getActualInstrumentIndex());
    }
    
    private void UpdateInstrDetails(int ActualInstrNr) {
        
        SymphManager.setActualInstrumentIndex(ActualInstrNr);
        SymphonieInstrument si = SymphManager.SymSong.getInstrument(ActualInstrNr);
        if((si != null)&&  (si.checkReady()) ) {
            InstrDetTxt.setText(si.Name);
            InstrDetVolume.setValue(si.Volume);
            InstrDetTune.setValue(si.Tune);
            InstrDetFineTune.setValue(si.FineTune);
            InstrNoDetune.setSelected(si.AllowPosDetune);
            InstrDetNoDsp.setSelected(si.NoDsp);
            InstrDetStereoType.setSelectedIndex(si.MultiChannel);
            InstrDetSampleResolution.setText("" + si.ImportSample.SampleResolutionBit);
            InstrDetFormat.setText(si.ImportSample.FormatString);
            UpdateInstrDetailsSampleView(ActualInstrNr);
            if(si.sp.hasLoop()==true) {
                InstrDetLoopText.setText( "Loop:" + si.sp.getLoopStart() + " Length:" + si.sp.getLoopLen()  );
            } else {
                InstrDetLoopText.setText("");
            }
        } else {
            ClearInstrDetailsSampleView();
            //InstrDetTxt.setText("* Unused *");
            InstrDetSampleResolution.setText("n/a");
            InstrDetFormat.setText("n/a");
        }
    }

class UIManager {
    private int ActualInstrumentIndex = 0; // Selected Instrument on Instrument List
    private int ActualPatternNr = 0;
    byte SymphoniePatternData[];
    Song SymSong = new Song();
    frmPatternEditor PED = new frmPatternEditor();
    
    Color LoopColor = new Color(128,128,255);
    Color WarnColorDsp1 = new Color(255,128,128);
    private VoiceExpander MyVoiceExpander = null;
    
    private String SamplePath;
    private String ModPath;
    
    UIManager() {
        PED.initPED(SymSong);
        PED.initUIManager(this);
        PED.setDefaultEditValues();
        
    }
    
    void registerModPath(String s){ModPath = s;}
    void registerSamplePath(String s){SamplePath = s;}
    String getModPath(){return(ModPath);}
    String getSamplePath(){return(SamplePath);}
    
    
    void setVoiceExpander(VoiceExpander theVoiceExpander) {
        MyVoiceExpander = theVoiceExpander;
    }
    VoiceExpander getVoiceExpander() {
        return(MyVoiceExpander);
    }
    
    void stopAllStopSong() {
        if(SymSong != null) SymSong.StopSong();
        if(MyVoiceExpander != null) MyVoiceExpander.stopAll();
    }
    
    
    void setActualInstrumentIndex(int i) {ActualInstrumentIndex = i;};
    int getActualInstrumentIndex() {return(ActualInstrumentIndex);};
    SymphonieInstrument getActualInstrument() {
          return(SymSong.getInstrument(ActualInstrumentIndex));
    }
    
    void setActualPatternNr(int i) {ActualPatternNr = i;};
    int getActualPatternNr() {return(ActualPatternNr);};
    
    // UI Tools
    
    int checkSpinnerLimits(JSpinner Component,int MinValue, int MaxValue) {
        int Value;                                       
        Number n;
        NumberFormat nf = NumberFormat.getInstance();
        String s;
        
        s = Component.getModel().getValue().toString();
        try{
            n = nf.parse(s);
            Value = n.intValue();
            if(Value < MinValue) {
                Value = MinValue;
                Component.setValue(Value);
            }
            if(Value >= MaxValue ) {
                Value = MaxValue;
            }
        
        } catch (java.text.ParseException e) {
            Value = MinValue;
        }
        Component.setValue(Value);
        return(Value);
    }
    
    int getSpinnerValue(JSpinner Component) {
        int Value;                                       
        Number n;
        NumberFormat nf = NumberFormat.getInstance();
        String s;
        
        s = Component.getModel().getValue().toString();
        try{
            n = nf.parse(s);
            Value = n.intValue();

        
        } catch (java.text.ParseException e) {
            Value = 0;
        }
        return(Value);
    }
    
    
    
    void MoveInstrNext() {
        MoveToInstr(this.getActualInstrumentIndex() + 1);
    }
    
    void MoveInstrPrev() {
        MoveToInstr(this.getActualInstrumentIndex() - 1);
    }
    
    void MoveToInstr(int i) {
        InstrDetNr.setValue(i);
        PED.SyncInstrumentNr(i);
    }
    
    void KeyboardPlayChar(char c, int Tune) {
        SymphonieInstrument si;
        si = SymphManager.SymSong.getInstrument(SymphManager.getActualInstrumentIndex());        
        
        String s = "<aysxcfvgbhnmk,l.-ä";
        String s2 = "q2w3er5t6z7ui9o0pü";
        
        int pos = -1;
        for(int i=0;i<s.length();i++) {
            if(c == s.charAt(i)) pos = i;
        }
        
        for(int i=0;i<s2.length();i++) {
            if(c == s2.charAt(i)) pos = (i+12);
        }
        
        
        if((pos!=-1) && (si.SampleDataLoaded == true) && (si!=null)  ) {
            startAudioSystem();
            MyVoiceExpander.PlayInstrumentNote(si, pos+Tune, 100.0f);
            
        }
    }
    
        int getKeyboardCharToPitch(char c, int Tune) {
        SymphonieInstrument si;
        si = SymphManager.SymSong.getInstrument(SymphManager.getActualInstrumentIndex());        
        
        String s = "<aysxcfvgbhnmk,l.-ä";
        String s2 = "q2w3er5t6z7ui9o0pü";
        
        int pos = -1;
        for(int i=0;i<s.length();i++) {
            if(c == s.charAt(i)) pos = i;
        }
        
        for(int i=0;i<s2.length();i++) {
            if(c == s2.charAt(i)) pos = (i+12);
        }
        
        
        if((pos!=-1) && (si.SampleDataLoaded == true)) {

        }
        return(pos);
    }
    
    
    
    
    void KeyboardPlayChar(char c) {
        KeyboardPlayChar(c, 0);
    }
 }

    void InitDefaultSong8Voices() {
         // Init Lists
        listModel.clear();
        jList1.setModel(listModel );
       
        // Empty Lists
        InstrListModel.clear();
        InstrList.setModel(InstrListModel );

        PosListModel.clear();
        PosListJList.setModel(PosListModel );

        SymphManager.SymSong.setNumbOfVoices(8);
        SymphManager.SymSong.setNumbOfSequences(1);
        SymphManager.SymSong.setBPM(125.0f);
        SymphManager.SymSong.setNumbOfRows(64);
        SymphManager.SymSong.setNumbOfPatterns(64);
        SymphManager.SymSong.setNumbOfPositions(128);
        SymphManager.SymSong.setNumbOfInstruments(100);       
        SymphManager.SymSong.allocResources();
        SymphManager.SymSong.getPattern(0).init(8);
        PrintToInfoWindow("New Song intitalized.");
        ShowAllWindows();
    }

    void loadSymMod() {
        File f;
        JFileChooser jFc = new JFileChooser();
        
        // Init Lists
        listModel.clear();
        jList1.setModel(listModel );
       
        // Empty Lists
        InstrListModel.clear();
        InstrList.setModel(InstrListModel );
        
        PosListModel.clear();
        PosListJList.setModel(PosListModel );
        
        // get new Song Import Object
        ImportSymph = new ImportSongSymphonie();
        ImportSymph.initImport(listModel, InstrListModel, PosListModel, SymphManager.SymSong);
        
        f = new File(SymphManager.getModPath());
        jFc.setCurrentDirectory(f);
        
        jFc.showOpenDialog(jFc);
        f = jFc.getSelectedFile();
        ImportSymph.runImport(f);
        
        SymphManager.registerModPath(jFc.getCurrentDirectory().getAbsolutePath());
        ShowAllWindows();        
    }

    private void SymLoadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SymLoadActionPerformed
        
        // TODO add your handling code here:
        
        // DSP off
        if(SysLoadModDeactivateDsp.isSelected() ) MyVoiceExpander.setDSPFxIndex(0);
        SysDspFxTypeCombox.setSelectedIndex(0);
        
        //Stop playing Song
        SymphManager.SymSong.StopSong();
        MyVoiceExpander.stopAll();
        loadSymMod();
        SymphManager.MoveToInstr(0);
        SymphManager.setActualPatternNr(0);
        SymphManager.PED.DrawAll(true);
        UpdateActualInstrDetails();
        SysMasterBPM.setText(""+SymphManager.SymSong.getBPM());
        
        
        
        

    }//GEN-LAST:event_SymLoadActionPerformed

    
    
    
    
    
    void writePreferences() {
        java.util.prefs.AbstractPreferences.userRoot().put("Symphonie.Path.Module", SymphManager.getModPath() );        
        java.util.prefs.AbstractPreferences.userRoot().put("Symphonie.Path.Samples", SymphManager.getSamplePath() );        

        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmSystem.x", frmSystem.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmSystem.y", frmSystem.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmSystem.width", frmSystem.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmSystem.height", frmSystem.getBounds().height);        

        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrDetails.x", FrmInstrDetails.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrDetails.y", FrmInstrDetails.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrDetails.width", FrmInstrDetails.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrDetails.height", FrmInstrDetails.getBounds().height);        
        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmMainPanel.x", mainPanel.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmMainPanel.y", mainPanel.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmMainPanel.width", mainPanel.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmMainPanel.height", mainPanel.getBounds().height);        
   
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPosList.x", PosListjFrame.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPosList.y", PosListjFrame.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPosList.width", PosListjFrame.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPosList.height", PosListjFrame.getBounds().height);        

        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrList.x", frmInstrList.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrList.y", frmInstrList.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrList.width", frmInstrList.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrList.height", frmInstrList.getBounds().height);        
        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPED.x", SymphManager.PED.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPED.y", SymphManager.PED.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPED.width", SymphManager.PED.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPED.height", SymphManager.PED.getBounds().height);        

}
    
    void readPreferences() {
        int x,y,w,h;
        SymphManager.registerModPath(java.util.prefs.AbstractPreferences.userRoot().get("Symphonie.Path.Module", ""));
        SymphManager.registerSamplePath(java.util.prefs.AbstractPreferences.userRoot().get("Symphonie.Path.Samples", ""));

        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmSystem.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmSystem.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmSystem.width", 50);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmSystem.height", 50);
        frmSystem.setBounds(x, y, w, h);
        
        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrDetails.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrDetails.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrDetails.width", 50);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrDetails.height", 50);
        FrmInstrDetails.setBounds(x, y, w, h);

        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmMainPanel.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmMainPanel.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmMainPanel.width", 50);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmMainPanel.height", 50);
        mainPanel.setBounds(x, y, w, h);

        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPosList.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPosList.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPosList.width", 50);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPosList.height", 50);
        PosListjFrame.setBounds(x, y, w, h);
    
        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrList.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrList.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrList.width", 50);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrList.height", 50);
        frmInstrList.setBounds(x, y, w, h);
        
        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPED.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPED.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPED.width", 50);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPED.height", 50);
        SymphManager.PED.setBounds(x, y, w, h);
    }
    
    
    private void InstrListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_InstrListMouseClicked
        ActionInstrListElement();
        // TODO add your handling code here:
    }//GEN-LAST:event_InstrListMouseClicked

    private void InstrDetExportRawSampleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_InstrDetExportRawSampleActionPerformed
        ExportInstrumentSampleRaw();
        // TODO add your handling code here:
    }//GEN-LAST:event_InstrDetExportRawSampleActionPerformed

    private void InstrListMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_InstrListMouseReleased
        ActionInstrListElement();
        // TODO add your handling code here:
    }//GEN-LAST:event_InstrListMouseReleased

    private void InstrListKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_InstrListKeyTyped
        SymphManager.KeyboardPlayChar(evt.getKeyChar());
        // TODO add your handling code here:
    }//GEN-LAST:event_InstrListKeyTyped

    private void FrmInstrDetailsAncestorResized(java.awt.event.HierarchyEvent evt) {//GEN-FIRST:event_FrmInstrDetailsAncestorResized
        // TODO add your handling code here:
    }//GEN-LAST:event_FrmInstrDetailsAncestorResized

    private void FrmInstrDetailsComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_FrmInstrDetailsComponentResized
        UpdateActualInstrDetails();
        // TODO add your handling code here:
    }//GEN-LAST:event_FrmInstrDetailsComponentResized

    private void InstrDetNrStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_InstrDetNrStateChanged

        // TODO add your handling code here:
        int Value;//GEN-LAST:event_InstrDetNrStateChanged
        UpdateInstrDetails(SymphManager.checkSpinnerLimits(InstrDetNr, 0, 128)); 
    }

    private void InstrDetViewFormatItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_InstrDetViewFormatItemStateChanged
        UpdateActualInstrDetails();
        // TODO add your handling code here:
    }//GEN-LAST:event_InstrDetViewFormatItemStateChanged

    int MixSampleCalcSampleLen(int OrigSampleLen, float freqfactor) {
        int NewSampleLen = 0;
        
        if(freqfactor == 1.0f) {
            return(OrigSampleLen);
        } else {
            freqfactor = OrigSampleLen / freqfactor;
            NewSampleLen = (int) freqfactor;
            return(NewSampleLen);
        }
    }
    
    void MixSample(SymphonieInstrument si, byte[] SampleBuffer, float freqfactor) {
        int DestIndex = 0;
        int Sample, hi, lo;
        int NumbOfSamples = si.sp.getNumbOfSamples();
        
        // Check if Buffer is Large enough
        if(SampleBuffer.length < (NumbOfSamples*2 )) {
            NumbOfSamples = SampleBuffer.length*2;
        }
        
        // Convert Sample from float to Format defined
        for(int i=0;i<NumbOfSamples;i++) {
            Sample = (int) (si.sp.Samples[i] * 32767);
            hi = Sample /256;
            lo = Sample - (hi * 256);
            SampleBuffer[DestIndex++] = (byte) hi;
            SampleBuffer[DestIndex++] = (byte) lo;
        }   
    }
/*
    void MixSample2(SymphonieInstrument si, byte[] SampleBuffer, float freqfactor) {
        int DestIndex = 0;
        int Sample, hi, lo;
        int NumbOfSamples = si.sp.getNumbOfSamples();
        
        // Check if Buffer is Large enough
        if(SampleBuffer.length < (NumbOfSamples*2 )) {
            NumbOfSamples = SampleBuffer.length*2;
        }
        
        int ActualInstrNr;
        ActualInstrNr = SymphManager.getActualInstrumentIndex();
        if(si.SampleDataLoaded == true) {
            MyVoiceExpander.PlayInstrument(si, 440.0f, 100.0f);
            MyVoiceExpander.PlayInstrument(si, 441.0f, 100.0f);
            MyVoiceExpander.PlayInstrument(si, 442.0f, 100.0f);
        }
        
        // Convert Sample from float to Format defined
        for(int i=0;i<NumbOfSamples;i++) {
            Sample = (int) (MyVoiceExpander.getNextMixSample() * 32767/3);
            hi = Sample /256;
            lo = Sample - (hi * 256);
            SampleBuffer[DestIndex++] = (byte) hi;
            SampleBuffer[DestIndex++] = (byte) lo;
        }   
    }
  */
    
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
       //StartPlayAsync();
        // TODO add your handling code here:
    }//GEN-LAST:event_jButton2ActionPerformed

    private void InstrDetTuneStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_InstrDetTuneStateChanged
        // TODO add your handling code here:
        int Value;                                       
        String s;
        Number n;
        NumberFormat nf = NumberFormat.getInstance();
        
        s = InstrDetTune.getModel().getValue().toString();
        try{
            n = nf.parse(s);
            Value = n.intValue();
            if(Value < -24) Value = -24;
            if(Value >= 48 ) Value = 48;
            SymphManager.SymSong.getInstrument(SymphManager.getActualInstrumentIndex()).Tune = Value;
            UpdateActualInstrDetails(); 
        } catch (java.text.ParseException e) {
        }
    }//GEN-LAST:event_InstrDetTuneStateChanged

   SymphonieInstrument  LoadNewInstrumentSample(File f, FileInputStream fi) {
    int len = (int) f.length();
    byte[] src;
    SymphonieInstrument si = null;
    try{
        int numberread;

        si = SymphManager.SymSong.getFreeInstrument();
        src = new byte[(int) len];
        numberread = fi.read(src,0,(int) len);
        si.ImportSample.Analyse(src, len);
        si.Name = f.getAbsoluteFile() + " (manually)";
        si.SampleDataLoaded = true;
        si.isInUse = true;
        
        // Make Stereo Sample if needet
        PostProcessMultiSample(si, si.ImportSample);
        
        // Visual Update
        InstrList.setModel(InstrListModel );
    }
    catch (java.io.IOException e) {
        PrintToInfoWindow("ERROR:While reading Samplefile " + f.getAbsoluteFile());
    }
    return(si);
} 
   
    // Split Instrument if it is a Stereo one
    void PostProcessMultiSample(SymphonieInstrument siLeft, ImportSample myImportSample ) {
        if(myImportSample.getNumbOfChannels() == 2) {
            SymphonieInstrument siRight;
            siLeft.sp = myImportSample.getSamplePool(0);
            siLeft.MultiChannel = 1;
            siRight = SymphManager.SymSong.getFreeInstrument();
            siRight.sp = myImportSample.getSamplePool(1);
            siRight.SampleDataLoaded = true;
            siRight.isInUse = true;
            siLeft.MultiChannel = 1;
            siRight.MultiChannel = 2;
            siRight.Name = siLeft.Name + " R";
            siLeft.Name = siLeft.Name + " L";
            InstrListModel.addElement(siLeft.Name);
            InstrListModel.addElement(siRight.Name);
        } else {
            siLeft.sp = myImportSample.getSamplePool(0);
            siLeft.MultiChannel = 0;            
            InstrListModel.addElement(siLeft.Name);    
        }
    }
   
    
    void ShowAllWindows() {
        frmInstrList.setVisible(true);
        FrmInstrDetails.setVisible(true);
        SymphManager.PED.setVisible(true);
        SymphManager.PED.DrawAll(false);
        PosListjFrame.setVisible(true);
        frmSystem.setVisible(true);
        frmSystem.toFront();
    }
    
    void LoadNewSample() {
        File f;
        FileInputStream fi;
        long FileLength = 0;
        SymphonieInstrument si;
        
        JFileChooser jFc = new JFileChooser();
        ShowAllWindows();
        
        f = new File(SymphManager.getSamplePath());
        
        jFc.setCurrentDirectory(f);
        jFc.showOpenDialog(jFc);
        
        PrintToInfoWindow("Loading New Sample...");
        
        f = jFc.getSelectedFile();

        SymphManager.registerSamplePath(jFc.getCurrentDirectory().getAbsolutePath());
        
        PrintToInfoWindow(f.getPath());
        try {
            fi = new FileInputStream(f);
            FileLength = f.length();
            PrintToInfoWindow(">> Filelength in Byte:", (int) FileLength);
            si = LoadNewInstrumentSample(f, fi);
        } catch (java.io.FileNotFoundException e) {
            PrintToInfoWindow("Error:File not Found.");
        }
        
        frmInstrList.setVisible(true);
        FrmInstrDetails.setVisible(true);
        
        UpdateActualInstrDetails();
    }
    
    
    private void InstrDetLoadSampleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_InstrDetLoadSampleActionPerformed
        // TODO add your handling code here:
       LoadNewSample(); 
    }//GEN-LAST:event_InstrDetLoadSampleActionPerformed

    private void SysInterpolationTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysInterpolationTypeActionPerformed
        // TODO add your handling code here:
        MyVoiceExpander.InterpolationType = SysInterpolationType.getSelectedIndex();
    }//GEN-LAST:event_SysInterpolationTypeActionPerformed

    private void SysMasterTuneStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysMasterTuneStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.MasterTune = SysMasterTune.getValue();
    }//GEN-LAST:event_SysMasterTuneStateChanged

    private void SysMasterVolumeStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysMasterVolumeStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.MasterVolume = SysMasterVolume.getValue();
    }//GEN-LAST:event_SysMasterVolumeStateChanged

    private void SystemPanelKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_SystemPanelKeyPressed
        // TODO add your handling code here:
        SymphManager.KeyboardPlayChar(evt.getKeyChar());

}//GEN-LAST:event_SystemPanelKeyPressed

    private void SystemPanelKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_SystemPanelKeyTyped
        // TODO add your handling code here:
        //SymphManager.KeyboardPlayChar(evt.getKeyChar());
        
    }//GEN-LAST:event_SystemPanelKeyTyped

    private void SysDitheringComboxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDitheringComboxActionPerformed
        // TODO add your handling code here:
        MyVoiceExpander.Dithering = SysDitheringCombox.getSelectedIndex();
}//GEN-LAST:event_SysDitheringComboxActionPerformed

    private void InstrDetNoDspActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_InstrDetNoDspActionPerformed
        // TODO add your handling code here:
        SymphManager.getActualInstrument().NoDsp = InstrDetNoDsp.isSelected();
    }//GEN-LAST:event_InstrDetNoDspActionPerformed

    private void newSongMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newSongMenuItemActionPerformed
        // TODO add your handling code here:
        InitDefaultSong8Voices();
    }//GEN-LAST:event_newSongMenuItemActionPerformed

    private void playPatternButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playPatternButtonActionPerformed
        // TODO add your handling code here:
        SymphManager.SymSong.StopSong();
        MyVoiceExpander.stopAll();
        MyVoiceExpander.setSong(SymphManager.SymSong);
        SymphManager.SymSong.PlayingPatternNr = SymphManager.PED.getActualPatternNr();
        startAudioSystem();
        SymphManager.SymSong.PlaySong();
}//GEN-LAST:event_playPatternButtonActionPerformed

    private void stopSongButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopSongButtonActionPerformed
        // TODO add your handling code here:
        SymphManager.SymSong.StopSong();
        MyVoiceExpander.stopAll();
}//GEN-LAST:event_stopSongButtonActionPerformed

    private void SysMasterBPMAdjStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysMasterBPMAdjStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setBPMTune(SysMasterBPMAdj.getValue());
}//GEN-LAST:event_SysMasterBPMAdjStateChanged

    private void PosListJListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_PosListJListMouseClicked
        // TODO add your handling code here:
        int PositionIndex = PosListJList.getMinSelectionIndex();
        SymphManager.SymSong.StopSong();
        MyVoiceExpander.stopAll();
        SymphManager.SymSong.PlayPosition(PositionIndex);
        MyVoiceExpander.setSongSpeed(SymphManager.SymSong.getBPM(), SymphManager.SymSong.getPositionSpeed());
        startAudioSystem();
        MyVoiceExpander.setSong(SymphManager.SymSong);
    }//GEN-LAST:event_PosListJListMouseClicked

    private void playSongButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playSongButtonActionPerformed
        // TODO add your handling code here:
        //        int PositionIndex = PosListJList.getMinSelectionIndex();
        
        SymphManager.SymSong.StopSong();
        MyVoiceExpander.stopAll();
        MyVoiceExpander.setSong(SymphManager.SymSong);
        
        startAudioSystem();
        MyVoiceExpander.setSongSpeed(SymphManager.SymSong.getBPM(), SymphManager.SymSong.getPositionSpeed());
        SymphManager.SymSong.PlayFromFirstSequence();
        MyVoiceExpander.setSongSpeed(SymphManager.SymSong.getBPM(), SymphManager.SymSong.getPositionSpeed());
    }//GEN-LAST:event_playSongButtonActionPerformed

    private void InstrDetVolumeStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_InstrDetVolumeStateChanged
        // TODO add your handling code here:
       //InstrDetVolume.setValue(lblTune)
        
        SymphonieInstrument si = SymphManager.getActualInstrument();
        if(si != null) {
            si.Volume = SymphManager.checkSpinnerLimits(InstrDetVolume, 0, 300);
            InstrDetVolume.setValue( SymphManager.checkSpinnerLimits(InstrDetVolume, 0, 300));
        }
    }//GEN-LAST:event_InstrDetVolumeStateChanged

    private void SysDspFxTypeComboxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDspFxTypeComboxActionPerformed
        // TODO add your handling code here:
        MyVoiceExpander.setDSPFxIndex(SysDspFxTypeCombox.getSelectedIndex());
}//GEN-LAST:event_SysDspFxTypeComboxActionPerformed

    private void SysDspMixVolumeSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDspMixVolumeSliderStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setWetMixVolume(SysDspMixVolumeSlider.getValue());
}//GEN-LAST:event_SysDspMixVolumeSliderStateChanged

    private void SysDeclickingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDeclickingActionPerformed
        // TODO add your handling code here:
        MyVoiceExpander.setDeclicking(SysDeclicking.isSelected());
    }//GEN-LAST:event_SysDeclickingActionPerformed

    private void SysDspFeedbackStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDspFeedbackStateChanged
        // TODO add your handling code here:
        
        int FeedbackValue = SysDspFeedback.getValue();
        MyVoiceExpander.setDSPFeedback(FeedbackValue);
        if(FeedbackValue > 75) {
            SysDspFeedback.setBackground(SymphManager.WarnColorDsp1);
        } else {
            
            SysDspFeedback.setBackground(SysDspMixVolumeSlider.getBackground()); 
        }

}//GEN-LAST:event_SysDspFeedbackStateChanged

    private void SysDspLengthStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDspLengthStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setDSPLength(SysDspLength.getValue());
}//GEN-LAST:event_SysDspLengthStateChanged

    private void SysDspPreDelayStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDspPreDelayStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setDSPPreDelay(SysDspPreDelay.getValue());
}//GEN-LAST:event_SysDspPreDelayStateChanged

    private void SysSyncToBeatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysSyncToBeatActionPerformed
        // TODO add your handling code here:
        MyVoiceExpander.DSP.setSyncToBeat(SysSyncToBeat.isSelected());
        if(SysSyncToBeat.isSelected()) {
            int i;
            i = MyVoiceExpander.DSP.getMaxBeatsDspLen();
            SysDspLength.setMajorTickSpacing(1);
            SysDspLength.setMinorTickSpacing(1);
            SysDspLength.setValue(i);
            SysDspLength.setSnapToTicks(true);
            SysDspLength.setMinimum(1);
            SysDspLength.setMaximum(i);
        } else {
            SysDspLength.setSnapToTicks(false);
            SysDspLength.setMajorTickSpacing(8);
            SysDspLength.setMinorTickSpacing(2);
            SysDspLength.setMinimum(1);
            SysDspLength.setMaximum(100);
        }
        
}//GEN-LAST:event_SysSyncToBeatActionPerformed

    private void SysLoadModDeactivateDspStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysLoadModDeactivateDspStateChanged
        // TODO add your handling code here:
        
        
}//GEN-LAST:event_SysLoadModDeactivateDspStateChanged

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        // TODO add your handling code here:
        SysMasterTune.setValue(0);
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        // TODO add your handling code here:
        SysMasterBPMAdj.setValue(100);
    }//GEN-LAST:event_jButton4ActionPerformed

    private void SysDeclickingLenSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDeclickingLenSliderStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setVoiceSmoothingLen(SysDeclickingLenSlider.getValue());
    }//GEN-LAST:event_SysDeclickingLenSliderStateChanged

    private void loadSampleMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadSampleMenuItemActionPerformed
        // TODO add your handling code here:
        LoadNewSample(); 
    }//GEN-LAST:event_loadSampleMenuItemActionPerformed

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
        // TODO add your handling code here:
        writePreferences();
    }//GEN-LAST:event_exitMenuItemActionPerformed
    
    // GUI Realtime Update ------------------------------
    boolean UpdateRealtimeUISwitch = false;
    void UpdateRealtimeUIInfos() {
        if(VoiceExpanderStarted == true) {
            UpdateRealtimeUISwitch = !UpdateRealtimeUISwitch;
            SampleViewDrawPlayPositions();
            RTDrawPEDVolumes();
            if(UpdateRealtimeUISwitch) {
                int PosPlayingIndex = 0;
                SysMasterVoices.setText(MyVoiceExpander.getNumbOfVoicesPlaying() +" / " +MyVoiceExpander.NumbOfVoices);
                PosPlayingIndex = SymphManager.SymSong.getPositionIndexPlaying();
                if(PosPlayingIndex >= 0) {
                    PosListJList.setSelectedIndex(PosPlayingIndex);
                    RTDrawPEDPosition(SymphManager.SymSong.getPosition(PosPlayingIndex).PatternNumbers[0]);
                }
            }
        }
    }
    
    void RTDrawPEDVolumes() {
        for(int i=0;i<MyVoiceExpander.NumbOfVoices;i++) {
            Voice v = MyVoiceExpander.getVoiceNr(i);
            if( (v.inUse) && (!v.isPausing) ) {
                SymphManager.PED.DrawVoiceVolumeBar(i, v.ChannelVolume);
            } else {
                SymphManager.PED.DrawVoiceVolumeBar(i, 0);
            }
        }
    }
    
    int OldPatternNr = -1;
    int PlayingRowNr = 0;
    void RTDrawPEDPosition(int NewPatternNr) {
        if(NewPatternNr!=OldPatternNr) {
            OldPatternNr = NewPatternNr;
            SymphManager.PED.setActualPatternNr(NewPatternNr);
            SymphManager.PED.DrawAll(true);
        }
        SymphManager.PED.moveEditCrsrToRowNr((int) SymphManager.SymSong.getPlayingLineNr());
    }
 
    boolean UIUpdateThreadStarted = false;
    void startUIRealTimeUpdate() {
        if(UIUpdateThreadStarted==false) {
            myUIUpdateThread.setCoalesce(true);
            myUIUpdateThread.setInitialDelay(5000);
            myUIUpdateThread.start();
            UIUpdateThreadStarted = true;
        } else {
        }
    }    

    ActionListener taskPerformer = new ActionListener() {
        public void actionPerformed(ActionEvent evt) {
            UpdateRealtimeUIInfos();
        }
    };
    Timer myUIUpdateThread = new Timer(125, taskPerformer);
    
    // Audio System Management -------------------------
    boolean VoiceExpanderStarted = false;
    void startAudioSystem() {
        if(VoiceExpanderStarted==false) {
            MyVoiceExpander.OpenMixSystem();
            VoiceExpanderTask.setName("Symphonie Voice Expander Task v1.0");
            VoiceExpanderTask.start();
            SymphManager.setVoiceExpander(MyVoiceExpander);
            VoiceExpanderStarted = true;
            SysStatusLabel.setText(MyVoiceExpander.ErrorString);
        }
        //writePreferences();
    }

    
    // Task Voiceexpander
    class VoiceExpanderThread extends Thread {
        VoiceExpanderThread() {
        }
        @Override
        public void run() {
            while(true) {
                MyVoiceExpander.PlayActualMixThread();
                VoiceExpanderThread.yield();
            }
        }
    }
    VoiceExpanderThread VoiceExpanderTask = new VoiceExpanderThread(); 
    
    private void ActionInstrListElement() {
        int i;
        i = InstrList.getMinSelectionIndex();
        InstrDetNr.setValue(i);
    }
    
    private float getActInstrSample(int i){
        float Sample = 0;
        if(SymphManager.getActualInstrument().SampleDataLoaded == true) {
            if(i < SymphManager.getActualInstrument().sp.getNumbOfSamples() ) {
                Sample = SymphManager.getActualInstrument().sp.Samples[i];
            }
        }
        return(Sample);
    }
    
     private int getActInstrSamplePercent(long i, long maxi, int h){
        float Sample = 0;
        int NumbOfSamples;
        long temp;
        
        if(SymphManager.getActualInstrument().SampleDataLoaded == true) {
            NumbOfSamples = SymphManager.getActualInstrument().sp.getNumbOfSamples();
            temp = i * NumbOfSamples;
            Sample = getActInstrSample( (int) (temp / maxi) ) ;
        }            
        Sample = Sample * h / 2; // -1 to +1
        return((int) Sample);
    }
    
    private void ClearInstrDetailsSampleView() {
        java.awt.Graphics g;
        int w,h,x,y,i, Oldy = 0;
        SampleViewMarkersCount = 0;
        w = InstrDetSampleView.getBounds().width;
        h = InstrDetSampleView.getBounds().height;
        g = InstrDetSampleView.getGraphics();
        g.clearRect(0, 0, w, h);
        SampleViewDrawLoop();
    }  
    
    int GetSamplePositionOnSampleView(SymphonieInstrument si, float SamplePtr) {
        if(si.checkReady()) {
            float x = (SamplePtr / si.sp.getNumbOfSamples()) * InstrDetSampleView.getBounds().width;
            return((int) (x+InstrDetSampleView.getBounds().x));
        } else {
            return(0);
        }
    }

    void SampleViewDrawVMarker(int x) {
        java.awt.Graphics g;
        g = InstrDetSampleView.getGraphics();
        g.setXORMode(Color.YELLOW);
        g.drawLine(x,  0, x, InstrDetSampleView.getBounds().height);          
//        g.drawLine(x+1,0, x+1, InstrDetSampleView.getBounds().height);          
    }
    
    int[] SampleViewMarkers = new int[256];
    int SampleViewMarkersCount = 0;
    
    void SampleViewClearPlayPositions() {
        if(SampleViewMarkersCount>0) {
            for(int i = 0;i<SampleViewMarkersCount;i++) {
                if(SampleViewMarkersCount>0) SampleViewDrawVMarker(SampleViewMarkers[i]);
            }
        }
    }

    void SampleViewDrawPlayPositions() {
        int x;
        SymphonieInstrument si = SymphManager.getActualInstrument();
        SampleViewClearPlayPositions();
        SampleViewMarkersCount = 0;
        for(int i = 0;i<MyVoiceExpander.getNumbOfVoicesPlaying();i++) {
            if((si != null) && (MyVoiceExpander.Voices[i] != null) ) {
                if((MyVoiceExpander.Voices[i].si == si) && (MyVoiceExpander.isVoicePlaying(i))) {
                    x = GetSamplePositionOnSampleView(si, MyVoiceExpander.Voices[i].SamplePtr);
                    SampleViewDrawVMarker(x);
                    SampleViewMarkers[SampleViewMarkersCount] = x;
                    SampleViewMarkersCount++;
                }
            } 
        }
    }
    
    void SampleViewDrawLoop() {
        SymphonieInstrument si = SymphManager.getActualInstrument();
        if(si != null) {
            if(si.checkReady()) {
                if((si.sp.hasLoop()) ) { // && (si.sp.getNumbOfLoops()>0)
                    java.awt.Graphics g;
                    int w,h,x;
                    w = InstrDetSampleView.getBounds().width;
                    h = InstrDetSampleView.getBounds().height;
                    g = InstrDetSampleView.getGraphics();
                    g.setColor(SymphManager.LoopColor);
                    x = GetSamplePositionOnSampleView(si, si.sp.getLoopStart() );
                    w = GetSamplePositionOnSampleView(si, si.sp.getLoopLen() );
                    g.fillRect(x, 0, w, h);
                }
            }
                
        }
    }
    
    
    private void UpdateInstrDetailsSampleView(int ActualInstrNr) {
        java.awt.Graphics g;
        int w,h,x,y,i, Oldy = 0;
        int Resolution;
        
        w = InstrDetSampleView.getBounds().width;
        h = InstrDetSampleView.getBounds().height;
        g = InstrDetSampleView.getGraphics();
        ClearInstrDetailsSampleView();
        g.drawLine(0, (h/2), w, (h/2));  
        Oldy = 0;
        
        switch(InstrDetViewFormat.getSelectedIndex()) {
            case 0: 
                for(i=0;i<w;i++) {
                    y = getActInstrSamplePercent(i,w,h) ;
                    g.drawLine(i, Oldy+(h/2), i+1, y+(h/2));   
                    Oldy = y;    
                }
                break;
            case 1: 
                Resolution = (w/10)+1;
                for(i=0;i<w*Resolution;i++) {
                    y = getActInstrSamplePercent(i,w*Resolution,h) ;
                    g.drawLine((i/Resolution)+1, y+(h/2), (i/Resolution)+1, y+(h/2));  
                }
                break;
            case 2: 
                Resolution = (w/60)+1;
                for(i=0;i<w*Resolution;i++) {
                    y = getActInstrSamplePercent(i,w*Resolution,h) ;
                    g.drawLine((i/Resolution)+1, y+(h/2), (i/Resolution)+1, y+(h/2));  
                }
                break;            
            case 3: 
                Resolution = 2;
                for(i=0;i<w*Resolution;i++) {
                    y = getActInstrSamplePercent(i+1,w*Resolution,h) ;
                    g.drawLine((i/Resolution)+1, (h/2), (i/Resolution)+1, y+(h/2));  
                }
                break;
        }

    }  
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JFrame FrmInstrDetails;
    private javax.swing.JButton InstrDetExportRawSample;
    private javax.swing.JSpinner InstrDetFineTune;
    private javax.swing.JTextField InstrDetFormat;
    private javax.swing.JButton InstrDetLoadSample;
    private javax.swing.JLabel InstrDetLoopText;
    private javax.swing.JCheckBox InstrDetNoDsp;
    private javax.swing.JSpinner InstrDetNr;
    private javax.swing.JTextField InstrDetSampleResolution;
    private javax.swing.JLayeredPane InstrDetSampleView;
    private javax.swing.JComboBox InstrDetStereoType;
    private javax.swing.JCheckBox InstrDetSyncPlay;
    private javax.swing.JSpinner InstrDetTune;
    private javax.swing.JTextField InstrDetTxt;
    private javax.swing.JComboBox InstrDetViewFormat;
    private javax.swing.JSpinner InstrDetVolume;
    private javax.swing.JList InstrList;
    private javax.swing.JCheckBox InstrNoDetune;
    private javax.swing.JToolBar MenuBar;
    private javax.swing.JList PosListJList;
    private javax.swing.JScrollPane PosListPane;
    private javax.swing.JFrame PosListjFrame;
    private javax.swing.JButton SymLoad;
    private javax.swing.JPanel SysDSPPanel;
    private javax.swing.JCheckBox SysDeclicking;
    private javax.swing.JSlider SysDeclickingLenSlider;
    private javax.swing.JComboBox SysDitheringCombox;
    private javax.swing.JSlider SysDspFeedback;
    private javax.swing.JComboBox SysDspFxTypeCombox;
    private javax.swing.JCheckBox SysDspLPFilter;
    private javax.swing.JSlider SysDspLength;
    private javax.swing.JSlider SysDspMixVolumeSlider;
    private javax.swing.JSlider SysDspPreDelay;
    private javax.swing.JComboBox SysInterpolationType;
    private javax.swing.JCheckBox SysLoadModDeactivateDsp;
    private javax.swing.JPanel SysLoadingPanel;
    private javax.swing.JTextField SysMasterBPM;
    private javax.swing.JSlider SysMasterBPMAdj;
    private javax.swing.JTextField SysMasterMixRate;
    private javax.swing.JSlider SysMasterTune;
    private javax.swing.JTextField SysMasterVoices;
    private javax.swing.JSlider SysMasterVolume;
    private javax.swing.JLabel SysStatusLabel;
    private javax.swing.JCheckBox SysSyncToBeat;
    private javax.swing.JTabbedPane SysTab;
    private javax.swing.JCheckBox SysUpdateCrsr;
    private javax.swing.JPanel SysUpdatePanel;
    private javax.swing.JCheckBox SysUpdatePatternNr;
    private javax.swing.JCheckBox SysUpdateSamplePos;
    private javax.swing.JPanel SystemPanel;
    private javax.swing.JFrame frmInstrList;
    private javax.swing.JFrame frmSystem;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JLabel lblFineTune;
    private javax.swing.JLabel lblInstrNr;
    private javax.swing.JLabel lblTune;
    private javax.swing.JLabel lblVolume;
    private javax.swing.JMenuItem loadModMenuItem;
    private javax.swing.JMenuItem loadSampleMenuItem;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenuItem newSongMenuItem;
    private javax.swing.JButton playPatternButton;
    private javax.swing.JButton playSongButton;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JLabel statusAnimationLabel;
    private javax.swing.JLabel statusMessageLabel;
    private javax.swing.JPanel statusPanel;
    private javax.swing.JButton stopSongButton;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;

    private JDialog aboutBox;
}


