/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import symreader.PatternVoice;
import symreader.Song;
import symreader.SongEvent;
import symreader.SongEventPool;
import symreader.SongPattern;
import symreader.SymReaderApp;
import symreader.SymReaderView;

public class frmPatternEditor
extends JFrame {
    private JTextField PEDContent;
    private JSpinner PEDEditStepLen;
    private JSpinner PEDEditVol;
    private JLabel PEDInfoLabel;
    private JSpinner PEDInstrNrSpinner;
    private JSpinner PEDKbdTunejSpinner;
    private JScrollPane PEDPane;
    private JSpinner PEDPatternNrjSpinner;
    private JCheckBox PEDRecording;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JToolBar jToolBar1;
    private Song SongLinked = null;
    private int ActualPatternNr = 0;
    private float ViewX;
    private float ViewY;
    private float ViewW;
    private float ViewH;
    private float TitleX;
    private float TitleY;
    private float TitleH = 16.0f;
    private float TitleW;
    private float VoiceFrameX;
    private float VoiceFrameY;
    private float VoiceFrameW;
    private float VoiceFrameH;
    private float dVoiceFrameToBorders = 2.0f;
    private float VoiceX;
    private float VoiceY;
    private float VoiceW;
    private float VoiceH;
    private float dVoiceX = 2.0f;
    private float CellW;
    private float CellH;
    private SymReaderView.UIManager SymphManager;
    Color ColorGeneral = new Color(200, 200, 200);
    Color ColorVol = new Color(200, 200, 255);
    Color ColorPitch = new Color(180, 255, 180);
    Color ColorSample = new Color(180, 180, 180);
    Color ColorSpeed = new Color(160, 255, 160);
    Color ColorDSP = new Color(255, 160, 160);
    PEDEditCrsr EditCrsr = new PEDEditCrsr(0, 255, 0);
    PEDEditCrsr MouseCrsr = new PEDEditCrsr(255, 255, 255);
    private int KbdTune = 0;
    String[] SymphonieTonleiter = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "H"};

    public frmPatternEditor() {
        this.initComponents();
    }

    private void initComponents() {
        this.PEDInfoLabel = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.PEDRecording = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.PEDPatternNrjSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.PEDInstrNrSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.PEDKbdTunejSpinner = new JSpinner();
        this.jLabel4 = new JLabel();
        this.PEDEditVol = new JSpinner();
        this.jLabel5 = new JLabel();
        this.PEDEditStepLen = new JSpinner();
        this.PEDPane = new JScrollPane();
        this.PEDContent = new JTextField();
        this.setDefaultCloseOperation(3);
        ResourceMap resourceMap = Application.getInstance(SymReaderApp.class).getContext().getResourceMap(frmPatternEditor.class);
        this.setTitle(resourceMap.getString("Pattern Designer.title", new Object[0]));
        this.setName("Pattern Designer");
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent evt) {
                frmPatternEditor.this.formWindowGainedFocus(evt);
            }

            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                frmPatternEditor.this.formComponentResized(evt);
            }

            public void componentShown(ComponentEvent evt) {
                frmPatternEditor.this.formComponentShown(evt);
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            public void ancestorMoved(HierarchyEvent evt) {
            }

            public void ancestorResized(HierarchyEvent evt) {
                frmPatternEditor.this.formAncestorResized(evt);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                frmPatternEditor.this.formFocusGained(evt);
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent evt) {
                frmPatternEditor.this.formWindowStateChanged(evt);
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent evt) {
                frmPatternEditor.this.formHierarchyChanged(evt);
            }
        });
        this.PEDInfoLabel.setText(resourceMap.getString("PEDInfoLabel.text", new Object[0]));
        this.PEDInfoLabel.setName("PEDInfoLabel");
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setName("jToolBar1");
        this.PEDRecording.setText(resourceMap.getString("PEDRecording.text", new Object[0]));
        this.PEDRecording.setBorder(new SoftBevelBorder(0));
        this.PEDRecording.setBorderPainted(true);
        this.PEDRecording.setFocusable(false);
        this.PEDRecording.setHorizontalTextPosition(4);
        this.PEDRecording.setName("PEDRecording");
        this.PEDRecording.setVerticalTextPosition(3);
        this.jToolBar1.add(this.PEDRecording);
        this.jLabel1.setLabelFor(this.PEDPatternNrjSpinner);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.jLabel1.setName("jLabel1");
        this.jToolBar1.add(this.jLabel1);
        this.PEDPatternNrjSpinner.setName("PEDPatternNrjSpinner");
        this.PEDPatternNrjSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmPatternEditor.this.PEDPatternNrjSpinnerStateChanged(evt);
            }
        });
        this.PEDPatternNrjSpinner.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                frmPatternEditor.this.PEDPatternNrjSpinnerKeyPressed(evt);
            }
        });
        this.jToolBar1.add(this.PEDPatternNrjSpinner);
        this.jLabel2.setLabelFor(this.PEDInstrNrSpinner);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.jLabel2.setName("jLabel2");
        this.jToolBar1.add(this.jLabel2);
        this.PEDInstrNrSpinner.setName("PEDInstrNrSpinner");
        this.jToolBar1.add(this.PEDInstrNrSpinner);
        this.jLabel3.setLabelFor(this.PEDKbdTunejSpinner);
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.jLabel3.setName("jLabel3");
        this.jToolBar1.add(this.jLabel3);
        this.PEDKbdTunejSpinner.setName("PEDKbdTunejSpinner");
        this.PEDKbdTunejSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmPatternEditor.this.PEDKbdTunejSpinnerStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.PEDKbdTunejSpinner);
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jToolBar1.add(this.jLabel4);
        this.PEDEditVol.setName("PEDEditVol");
        this.PEDEditVol.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmPatternEditor.this.PEDEditVolStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.PEDEditVol);
        this.jLabel5.setLabelFor(this.PEDKbdTunejSpinner);
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.jLabel5.setName("jLabel5");
        this.jToolBar1.add(this.jLabel5);
        this.PEDEditStepLen.setName("PEDEditStepLen");
        this.PEDEditStepLen.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmPatternEditor.this.PEDEditStepLenStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.PEDEditStepLen);
        this.PEDPane.setBorder(BorderFactory.createEtchedBorder());
        this.PEDPane.setHorizontalScrollBarPolicy(32);
        this.PEDPane.setVerticalScrollBarPolicy(22);
        this.PEDPane.setFocusable(false);
        this.PEDPane.setName("PEDPane");
        this.PEDPane.setRequestFocusEnabled(false);
        this.PEDPane.setVerifyInputWhenFocusTarget(false);
        this.PEDContent.setEditable(false);
        this.PEDContent.setText(resourceMap.getString("PEDContent.text", new Object[0]));
        this.PEDContent.setName("PEDContent");
        this.PEDContent.setOpaque(false);
        this.PEDContent.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                frmPatternEditor.this.PEDContentComponentResized(evt);
            }
        });
        this.PEDContent.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                frmPatternEditor.this.PEDContentMouseMoved(evt);
            }
        });
        this.PEDContent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmPatternEditor.this.PEDContentActionPerformed(evt);
            }
        });
        this.PEDContent.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            public void ancestorMoved(HierarchyEvent evt) {
                frmPatternEditor.this.PEDContentAncestorMoved(evt);
            }

            public void ancestorResized(HierarchyEvent evt) {
            }
        });
        this.PEDContent.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                frmPatternEditor.this.PEDContentFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                frmPatternEditor.this.PEDContentFocusLost(evt);
            }
        });
        this.PEDContent.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                frmPatternEditor.this.PEDContentKeyPressed(evt);
            }

            public void keyTyped(KeyEvent evt) {
                frmPatternEditor.this.PEDContentKeyTyped(evt);
            }
        });
        this.PEDPane.setViewportView(this.PEDContent);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 546, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.PEDInfoLabel, -1, 251, Short.MAX_VALUE).addGap(285, 285, 285)).addComponent(this.PEDPane, -1, 546, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addGap(12, 12, 12).addComponent(this.PEDInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PEDPane, -1, 390, Short.MAX_VALUE)));
        this.pack();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.DrawAll(false);
    }

    private void formComponentShown(ComponentEvent evt) {
        this.DrawAll(true);
    }

    private void formWindowStateChanged(WindowEvent evt) {
        this.DrawAll(true);
    }

    private void formAncestorResized(HierarchyEvent evt) {
    }

    private void PEDPatternNrjSpinnerStateChanged(ChangeEvent evt) {
        int Value = this.SymphManager.checkSpinnerLimits(this.PEDPatternNrjSpinner, 0, this.SongLinked.getNumbOfPatterns() - 1);
        SongPattern Pat = this.SymphManager.SymSong.getPattern(Value);
        if (Pat.getNumbOfVoices() == 0) {
            Pat.init(8);
        }
        this.ActualPatternNr = Value;
        this.DrawAll(true);
    }

    private void formWindowGainedFocus(WindowEvent evt) {
    }

    private void formFocusGained(FocusEvent evt) {
        this.DrawAll(true);
    }

    private void formHierarchyChanged(HierarchyEvent evt) {
    }

    private void PEDPatternNrjSpinnerKeyPressed(KeyEvent evt) {
    }

    private void PEDContentKeyPressed(KeyEvent evt) {
        this.ProcessKeyboardEvents(evt);
    }

    private void PEDContentFocusGained(FocusEvent evt) {
        this.DrawAll(true);
    }

    private void PEDContentKeyTyped(KeyEvent evt) {
    }

    private void PEDContentComponentResized(ComponentEvent evt) {
        this.DrawAll(true);
    }

    private void PEDContentMouseMoved(MouseEvent evt) {
        this.DrawMouseCrsr(evt);
    }

    private void PEDContentFocusLost(FocusEvent evt) {
        this.DrawAll(true);
    }

    private void PEDKbdTunejSpinnerStateChanged(ChangeEvent evt) {
        this.setKbdTune(this.SymphManager.checkSpinnerLimits(this.PEDKbdTunejSpinner, -36, 36));
    }

    private void PEDContentAncestorMoved(HierarchyEvent evt) {
    }

    private void PEDContentActionPerformed(ActionEvent evt) {
    }

    private void PEDEditVolStateChanged(ChangeEvent evt) {
        int Value = this.SymphManager.checkSpinnerLimits(this.PEDEditVol, 0, 100);
    }

    private void PEDEditStepLenStateChanged(ChangeEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new frmPatternEditor().setVisible(true);
            }
        });
    }

    public void setDefaultEditValues() {
        this.PEDRecording.getModel().setSelected(false);
        this.PEDEditVol.getModel().setValue(100);
        this.PEDEditStepLen.getModel().setValue(4);
    }

    void SyncInstrumentNr(int i) {
        this.PEDInstrNrSpinner.setValue(i);
    }

    int getKbdTune() {
        return this.KbdTune;
    }

    void setKbdTune(int i) {
        this.KbdTune = i;
    }

    int getActualPatternNr() {
        return this.ActualPatternNr;
    }

    void setActualPatternNr(int NewActualPatternNr) {
        this.ActualPatternNr = NewActualPatternNr;
    }

    void initUIManager(SymReaderView.UIManager mySymphManager) {
        this.SymphManager = mySymphManager;
    }

    int getNumbOfRows() {
        if (this.SongLinked != null && this.SongLinked.hasContent()) {
            return this.SongLinked.getNumbOfRows();
        }
        return 1;
    }

    float getCellX(int VoiceIndex) {
        return (float)VoiceIndex * (this.VoiceW + this.dVoiceX) + 4.0f;
    }

    float getCellY(int RowNr) {
        return this.VoiceY + (float)RowNr * this.VoiceH;
    }

    float getCellY(float TimePosition) {
        return this.VoiceY + TimePosition / (float)this.getNumbOfRows() * this.VoiceH;
    }

    int getVoiceNrAtX(float x) {
        int VoiceNr = (int)((x - 4.0f) / (this.VoiceW + this.dVoiceX));
        if (VoiceNr < 0) {
            VoiceNr = 0;
        }
        if (VoiceNr > this.getNumbOfVoices() - 1) {
            VoiceNr = this.getNumbOfVoices() - 1;
        }
        return VoiceNr;
    }

    int getRowNrAtY(float y) {
        int RowNr = (int)((y - this.VoiceY) / this.CellH);
        if (RowNr < 0) {
            RowNr = 0;
        }
        if (RowNr > this.getNumbOfRows() - 1) {
            RowNr = this.getNumbOfRows() - 1;
        }
        return RowNr;
    }

    int getNumbOfVoices() {
        if (this.SongLinked != null && this.SongLinked.hasContent()) {
            return this.SongLinked.getNumbOfVoices();
        }
        return 0;
    }

    public void initPED(Song mySongLinked) {
        this.SongLinked = mySongLinked;
        assert (this.SongLinked == null);
        this.EditCrsr.setPos(0, 0);
    }

    public void moveEditCrsrToRowNr(int RowNr) {
        assert (this.SongLinked == null);
        Graphics g = this.PEDContent.getGraphics();
        this.EditCrsr.drawAtNewPos(g, this.EditCrsr.getX(), RowNr);
    }

    void CalcLayout(Graphics g, float x, float y, float w, float h) {
        this.TitleX = x + this.dVoiceFrameToBorders;
        this.TitleY = y;
        this.VoiceFrameX = x + this.dVoiceFrameToBorders;
        this.VoiceFrameW = w - (2.0f * this.dVoiceFrameToBorders + this.TitleH);
        this.VoiceFrameY = y + this.TitleH + this.dVoiceFrameToBorders;
        this.VoiceFrameH = h - (2.0f * this.dVoiceFrameToBorders + this.TitleH);
        if (this.VoiceFrameW < 1.0f) {
            this.VoiceFrameW = 1.0f;
        }
        if (this.VoiceFrameH < 1.0f) {
            this.VoiceFrameH = 1.0f;
        }
        this.VoiceX = this.VoiceFrameX;
        this.VoiceY = this.VoiceFrameY + 1.0f;
        this.TitleW = this.VoiceW = (w - this.dVoiceX * (float)this.getNumbOfVoices()) / (float)this.getNumbOfVoices();
        this.VoiceH = this.VoiceFrameH - 2.0f;
        this.CellW = this.VoiceW - 2.0f;
        this.CellH = this.VoiceH / (float)this.getNumbOfRows();
        if (this.VoiceW < 1.0f) {
            this.VoiceW = 1.0f;
        }
        this.EditCrsr.setMaxXY(this.getNumbOfVoices() - 1, this.getNumbOfRows() - 1);
        this.MouseCrsr.setMaxXY(this.getNumbOfVoices() - 1, this.getNumbOfRows() - 1);
    }

    public void DrawAll(boolean ClearBackground) {
        this.PEDContent.getBounds();
        this.ViewW = this.PEDContent.getBounds().width - 3;
        this.ViewH = this.PEDContent.getBounds().height - 4;
        this.ViewX = 1.0f;
        this.ViewY = 2.0f;
        if (this.SongLinked != null && this.SongLinked.hasContent()) {
            Graphics g = this.PEDContent.getGraphics();
            this.CalcLayout(g, this.ViewX, this.ViewY, this.ViewW, this.ViewH);
            if (ClearBackground) {
                this.ClearPatternBackground(g, this.ViewX, this.ViewY, this.ViewW, this.ViewH);
            }
            this.drawPatternBackground(g);
            this.drawAllEvents(g);
            this.drawPatternTitles(g);
            this.MouseCrsr.invalidateCrsrPos();
            this.EditCrsr.invalidateCrsrPos();
            this.MouseCrsr.draw(g);
            this.EditCrsr.draw(g);
        }
    }

    public void DrawVoiceVolumeBar(int VoiceNr, float Value) {
        float x = this.getCellX(VoiceNr);
        float w = this.CellW * Value / 100.0f;
        Graphics g = this.PEDContent.getGraphics();
        g.setColor(Color.BLACK);
        g.fillRect((int)x, (int)this.TitleY - 2, (int)this.CellW, 3);
        g.setColor(Color.WHITE);
        g.fillRect((int)x, (int)this.TitleY - 2, (int)w, 3);
    }

    public void DrawMouseCrsr(MouseEvent evt) {
        if (this.SongLinked != null && this.SongLinked.hasContent()) {
            Graphics g = this.PEDContent.getGraphics();
            float x = evt.getX();
            float y = evt.getY();
            int RowNr = this.getRowNrAtY(y);
            int VoiceNr = this.getVoiceNrAtX(x);
            this.MouseCrsr.drawAtNewPos(g, VoiceNr, RowNr);
            this.PEDInfoLabel.setText("Crsr:" + VoiceNr + "/" + RowNr);
        }
    }

    void ClearPatternBackground(Graphics g, float x, float y, float w, float h) {
        g.clearRect((int)x, (int)y, (int)w, (int)h);
    }

    void drawPatternTitles(Graphics g) {
        float x = this.TitleX;
        g.setColor(Color.BLACK);
        for (int i = 0; i < this.getNumbOfVoices(); ++i) {
            g.drawRect((int)x, (int)this.TitleY, (int)this.TitleW, (int)this.TitleH);
            g.drawString("Voc " + i, (int)x, (int)(this.TitleY + this.TitleH - 2.0f));
            x += this.TitleW + this.dVoiceX;
        }
    }

    void drawPatternBackground(Graphics g) {
        float x = this.VoiceX;
        g.setColor(Color.BLACK);
        for (int i = 0; i < this.getNumbOfVoices(); ++i) {
            g.drawRect((int)x, (int)this.VoiceY, (int)this.VoiceW, (int)this.VoiceH);
            x += this.VoiceW + this.dVoiceX;
        }
    }

    void drawAllEvents(Graphics g) {
        float x = this.VoiceX;
        for (int i = 0; i < this.getNumbOfVoices(); ++i) {
            this.drawVoiceEvents(g, i);
            x += this.VoiceW + this.dVoiceX;
        }
    }

    void drawVoiceEvents(Graphics g, int VoiceIndex) {
        SongPattern Pat = this.SongLinked.getPattern(this.ActualPatternNr);
        PatternVoice PatVoc = Pat.PatternVoices[VoiceIndex];
        for (int i = 0; i < Pat.getNumbOfRows(); ++i) {
            SongEventPool sep = PatVoc.getSongEventPool(i);
            if (sep == null) continue;
            for (int j = 0; j < sep.getNumberOfSongEvents(); ++j) {
                this.drawSongEvent(g, PatVoc, sep, sep.getSongEvent(j), VoiceIndex, null);
            }
        }
    }

    boolean checkPositionValid(int VoiceIndex, int RowNr) {
        if (this.SongLinked == null) {
            return false;
        }
        if (!this.SongLinked.hasContent()) {
            return false;
        }
        SongPattern Pat = this.SongLinked.getPattern(this.ActualPatternNr);
        if (Pat == null) {
            return false;
        }
        if (VoiceIndex > Pat.getNumbOfVoices()) {
            return false;
        }
        PatternVoice PatVoc = Pat.PatternVoices[VoiceIndex];
        if (PatVoc == null) {
            return false;
        }
        SongEventPool sep = PatVoc.getSongEventPool(RowNr);
        if (sep == null) {
            return false;
        }
        return sep.getNumberOfSongEvents() != 0;
    }

    void drawVoiceEventsAtCell(Graphics g, int VoiceIndex, int RowNr, PEDEditCrsr PEDCrsr) {
        if (this.checkPositionValid(VoiceIndex, RowNr)) {
            SongPattern Pat = this.SongLinked.getPattern(this.ActualPatternNr);
            PatternVoice PatVoc = Pat.PatternVoices[VoiceIndex];
            SongEventPool sep = PatVoc.getSongEventPool(RowNr);
            if (sep != null) {
                if (sep.getNumberOfSongEvents() > 0) {
                    for (int j = 0; j < sep.getNumberOfSongEvents(); ++j) {
                        if (sep.getSongEvent((int)j).SongFXType != 0) {
                            this.drawSongEvent(g, PatVoc, sep, sep.getSongEvent(j), VoiceIndex, PEDCrsr);
                            continue;
                        }
                        this.drawNullEvent(g, sep.TimePosition, VoiceIndex, PEDCrsr);
                    }
                } else {
                    this.drawNullEvent(g, RowNr, VoiceIndex, PEDCrsr);
                }
            } else {
                this.drawNullEvent(g, RowNr, VoiceIndex, PEDCrsr);
            }
        }
    }

    void drawSongEvent(Graphics g, PatternVoice PatVoc, SongEventPool sep, SongEvent se, int VoiceIndex, PEDEditCrsr PEDCrsr) {
        float x = this.getCellX(VoiceIndex);
        float y = this.getCellY(sep.TimePosition);
        if (se.SongFXType != 0) {
            switch (se.FXClass) {
                case 0: {
                    g.setColor(this.ColorGeneral);
                    break;
                }
                case 1: {
                    g.setColor(this.ColorVol);
                    break;
                }
                case 2: {
                    g.setColor(this.ColorPitch);
                    break;
                }
                case 3: {
                    g.setColor(this.ColorSample);
                    break;
                }
                case 4: {
                    g.setColor(this.ColorSpeed);
                    break;
                }
                case 5: {
                    g.setColor(this.ColorDSP);
                }
            }
            if (PEDCrsr != null) {
                g.setColor(PEDCrsr.CrsrColor);
            }
            g.fillRect((int)x, (int)y, (int)this.CellW, (int)this.CellH);
            g.setColor(Color.BLACK);
            g.drawString(this.getSongEventString(se), (int)x, (int)(y + this.CellH) - 2);
        } else if (PEDCrsr != null) {
            // empty if block
        }
    }

    void drawNullEvent(Graphics g, float TimePosition, int VoiceIndex, PEDEditCrsr PEDCrsr) {
        float x = this.getCellX(VoiceIndex);
        float y = this.getCellY(TimePosition);
        if (PEDCrsr != null) {
            g.setColor(PEDCrsr.CrsrColor);
            g.fillRect((int)x, (int)y, (int)this.CellW, (int)this.CellH);
        } else {
            this.ClearPatternBackground(g, x, y, this.CellW, this.CellH);
        }
    }

    String getSongEventString(SongEvent se) {
        return this.BuildEventString(se);
    }

    String BuildEventString(SongEvent e) {
        String AsString = "";
        String ShortString = "";
        switch (e.SongFXType) {
            case 1: {
                AsString = "KeyOn:" + this.PitchToString(e.B) + " Instr:" + e.A + " Volume:" + e.C;
                ShortString = this.PitchToString(e.B) + " I" + e.A + " " + e.C;
                break;
            }
            case 4: {
                AsString = "KeyOff()";
                ShortString = "KeyOff";
                break;
            }
            case 1008: {
                AsString = "Start Sample()";
                ShortString = "Start";
                break;
            }
            case 1007: {
                AsString = "Continue Sample()";
                ShortString = "On";
                break;
            }
            case 1006: {
                AsString = "Stop Sample()";
                ShortString = "Off";
                break;
            }
            case 4001: {
                AsString = "Slower()";
                ShortString = "Slower";
                break;
            }
            case 4002: {
                AsString = "Faster()";
                ShortString = "Faster";
                break;
            }
            case 2008: {
                AsString = "PitchDown()";
                ShortString = "PDwn";
                break;
            }
            case 2010: {
                AsString = "PitchDown2()";
                ShortString = "PDwn2";
                break;
            }
            case 2012: {
                AsString = "PitchDown3()";
                ShortString = "PDwn3";
                break;
            }
            case 2007: {
                AsString = "PitchDown()";
                ShortString = "PDwn";
                break;
            }
            case 2009: {
                AsString = "PitchDown2()";
                ShortString = "PDwn2";
                break;
            }
            case 2011: {
                AsString = "PitchDown3()";
                ShortString = "PDwn3";
                break;
            }
            case 2013: {
                AsString = "Set Pitch()";
                ShortString = "Set Pitch:" + this.PitchToString(e.B);
                break;
            }
            case 1002: {
                AsString = "AddVolume()";
                ShortString = "AddV";
                break;
            }
            case 1004: {
                AsString = "Set Channel Volume()";
                ShortString = "CV " + e.C;
                break;
            }
            case 1005: {
                AsString = "Add Channel Volume()";
                ShortString = "+CV";
                break;
            }
            case 1003: {
                AsString = "Vibrato()";
                ShortString = "VIBR";
                break;
            }
            case 1001: {
                AsString = "Volume Slide Down()";
                ShortString = "VSliD " + e.C;
                break;
            }
            case 1000: {
                AsString = "Volume Slide Up()";
                ShortString = "VSliU " + e.C;
                break;
            }
            case 1009: {
                AsString = "Set Volume()";
                ShortString = "Vol=" + e.C;
                break;
            }
            case 2003: {
                AsString = "AddPitch()";
                ShortString = "AddP";
                break;
            }
            case 2006: {
                AsString = "AddHalveTone()";
                ShortString = "+HT";
                break;
            }
            case 2002: {
                AsString = "Pitch Slide Down()";
                ShortString = "PSliD " + e.C;
                break;
            }
            case 2001: {
                AsString = "Pitch Slide Up()";
                ShortString = "PSliU " + e.C;
                break;
            }
            case 2005: {
                AsString = "Pitch Slide To()";
                ShortString = "PTo";
                break;
            }
            case 2004: {
                AsString = "Tremolo()";
                ShortString = "TREM";
                break;
            }
            case 5003: {
                AsString = "DSP Chorus Experimental()";
                ShortString = "CHOR";
                break;
            }
            case 5002: {
                AsString = "DSP Delay()";
                ShortString = "DELY";
                break;
            }
            case 5001: {
                AsString = "DSP Echo()";
                ShortString = "ECHO";
                break;
            }
            case 3: {
                AsString = "Key Emphasis()";
                ShortString = "EMPH";
                break;
            }
            case 5000: {
                AsString = "Resonant Filter()";
                ShortString = "FILT";
                break;
            }
            case 4000: {
                AsString = "Set Speed()";
                ShortString = "SPD";
                break;
            }
            case 3003: {
                AsString = "Sample Pointer Add()";
                ShortString = "+FRM";
                break;
            }
            case 3001: {
                AsString = "Sample Pointer Set & Pitch() ";
                ShortString = "FR&P ";
                String tempPitch = this.PitchToString(e.B);
                AsString = AsString + tempPitch + " Instr:" + e.A + " " + (int)((double)e.C / 2.55) + "%";
                ShortString = ShortString + tempPitch + " I" + e.A + " " + (int)((double)e.C / 2.55) + "%";
                break;
            }
            case 3000: {
                AsString = "Sample Pointer Set()";
                ShortString = "FROM " + (int)((double)e.C / 2.55) + "%";
                break;
            }
            case 2: {
                AsString = "Retrigger()";
                ShortString = "RETR";
                break;
            }
            case 3004: {
                AsString = "Samplepos Vibrato()";
                ShortString = "VIBR";
                break;
            }
            case 3002: {
                AsString = "FX_SETFROMADD()";
                ShortString = "+FRM";
            }
        }
        return ShortString;
    }

    String PitchToString(float fPitch) {
        int Octave;
        String s = "";
        int Pitch = (int)fPitch;
        if ((Pitch -= (Octave = Pitch / 12) * 12) < this.SymphonieTonleiter.length && Pitch > 0) {
            s = this.SymphonieTonleiter[Pitch];
            s = s + Octave;
        }
        return s;
    }

    void ProcessKeyboardEvents(KeyEvent evt) {
        int KeyCode = evt.getKeyCode();
        Graphics g = this.PEDContent.getGraphics();
        switch (KeyCode) {
            case 33: {
                this.SymphManager.MoveInstrNext();
                break;
            }
            case 34: {
                this.SymphManager.MoveInstrPrev();
                break;
            }
            case 27: {
                this.SymphManager.stopAllStopSong();
                break;
            }
            case 40: {
                this.EditCrsr.moveDown(g);
                break;
            }
            case 37: {
                this.EditCrsr.moveLeft(g);
                break;
            }
            case 39: {
                this.EditCrsr.moveRight(g);
                break;
            }
            case 38: {
                this.EditCrsr.moveUp(g);
                break;
            }
            case 32: {
                this.setNoneEvent();
                this.moveEditCrsrDownSteps();
            }
        }
        this.SymphManager.KeyboardPlayChar(evt.getKeyChar(), this.getKbdTune());
        int EditPitch = this.SymphManager.getKeyboardCharToPitch(evt.getKeyChar(), this.getKbdTune());
        if (this.PEDRecording.isSelected() && EditPitch != -1) {
            int Vol = this.SymphManager.getSpinnerValue(this.PEDEditVol);
            this.addKeyOnEvent(this.SymphManager.getActualInstrumentIndex(), EditPitch, Vol);
            this.moveEditCrsrDownSteps();
        }
    }

    private void moveEditCrsrDownSteps() {
        Graphics g = this.PEDContent.getGraphics();
        for (int i = 0; i < this.SymphManager.getSpinnerValue(this.PEDEditStepLen); ++i) {
            this.EditCrsr.moveDown(g);
        }
    }

    void addKeyOnEvent(int InstrIndex, int Pitch, int Vol) {
        this.SymphManager.SymSong.addKeyOnEvent(this.SymphManager.PED.getActualPatternNr(), this.EditCrsr.getX(), this.EditCrsr.getY(), InstrIndex, Pitch, Vol);
    }

    void setNoneEvent() {
        this.SymphManager.SymSong.clrEvent(this.SymphManager.PED.getActualPatternNr(), this.EditCrsr.getX(), this.EditCrsr.getY());
    }

    private class PEDEditCrsr {
        private int x;
        private int y;
        private int MaxX;
        private int MaxY;
        private boolean valid = false;
        Color CrsrColor;

        PEDEditCrsr(int r, int g, int b) {
            this.CrsrColor = new Color(r, g, b);
            this.valid = false;
        }

        void setMaxXY(int NewMaxX, int NewMaxY) {
            this.MaxX = NewMaxX;
            this.MaxY = NewMaxY;
        }

        void setPos(int xpos, int ypos) {
            this.x = xpos;
            this.y = ypos;
            this.valid = true;
        }

        boolean isValid() {
            return this.valid;
        }

        void invalidateCrsrPos() {
            this.valid = false;
        }

        int getX() {
            return this.x;
        }

        int getY() {
            return this.y;
        }

        public void moveUp(Graphics g) {
            this.undraw(g);
            --this.y;
            this.checkXYValid();
            this.drawAtNewPos(g);
        }

        public void moveDown(Graphics g) {
            this.undraw(g);
            ++this.y;
            if (this.y > this.MaxY) {
                this.y = 0;
            }
            this.checkXYValid();
            this.drawAtNewPos(g);
        }

        public void moveRight(Graphics g) {
            this.undraw(g);
            ++this.x;
            this.checkXYValid();
            this.drawAtNewPos(g);
        }

        public void moveLeft(Graphics g) {
            this.undraw(g);
            --this.x;
            this.checkXYValid();
            this.drawAtNewPos(g);
        }

        void checkXYValid() {
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.x > this.MaxX) {
                this.x = this.MaxX;
            }
            if (this.y > this.MaxY) {
                this.y = this.MaxY;
            }
        }

        private void undraw(Graphics g) {
            if (this.isValid()) {
                frmPatternEditor.this.drawVoiceEventsAtCell(g, this.getX(), this.getY(), null);
            }
        }

        public void drawAtNewPos(Graphics g) {
            frmPatternEditor.this.drawVoiceEventsAtCell(g, this.getX(), this.getY(), this);
        }

        public void drawAtNewPos(Graphics g, int newx, int newy) {
            this.undraw(g);
            this.setPos(newx, newy);
            frmPatternEditor.this.drawVoiceEventsAtCell(g, this.getX(), this.getY(), this);
        }

        void draw(Graphics g) {
            this.undraw(g);
            frmPatternEditor.this.drawVoiceEventsAtCell(g, this.getX(), this.getY(), this);
            this.valid = true;
        }
    }
}

