/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import symreader.PatternVoice;
import symreader.Position;
import symreader.Sequence;
import symreader.SongEvent;
import symreader.SongEventPool;
import symreader.SongPattern;
import symreader.SymphonieInstrument;
import symreader.VoiceExpander;

public class Song {
    String Name = "Unnamed";
    float Volume = 100.0f;
    private float BPM = 125.0f;
    float MixFrequency = 44100.0f;
    private int NumbOfSequences = 64;
    private int NumbOfPositions = 1024;
    private int NumbOfInstruments = 256;
    private int NumbOfVoices = 16;
    private int NumbOfRows = 64;
    private int NumbOfPatterns = 100;
    private int PatternSize;
    private boolean ResourcesAllocated = false;
    private boolean InstrumentsAllocated = false;
    private Sequence[] Sequences;
    private Position[] Positions;
    private SongPattern[] Patterns;
    private SymphonieInstrument[] Instruments;
    private VoiceExpander LinkedVoiceExpander = null;
    boolean SongPlaying = false;
    int PlayingPatternNr = 0;
    boolean isPositionPlaying = false;
    int PlayPositionIndex = 0;
    int PosNumbOfLoops = 0;
    int PosStart = 0;
    int PosLen = 0;
    int PosSpeed = 0;
    int PosTuneOffset = 0;
    private float PlayLinePos = 0.0f;

    float getPlayingLineNr() {
        return this.PlayLinePos;
    }

    int getPlayingPatternNr() {
        return this.PlayingPatternNr;
    }

    int getPositionSpeed() {
        return this.PosSpeed;
    }

    float getSongBPM() {
        return this.BPM;
    }

    int getPositionIndexPlaying() {
        if (this.isPositionPlaying && this.SongPlaying) {
            return this.PlayPositionIndex;
        }
        return -1;
    }

    private void MoveToNextPosition() {
        ++this.PlayPositionIndex;
        if (this.PlayPositionIndex >= this.getNumbOfPositions()) {
            this.StopSong();
        } else {
            this.PlayPositionInit();
        }
    }

    private void PlayPositionInit() {
        if (this.Positions != null && this.Positions[this.PlayPositionIndex] != null) {
            this.PosTuneOffset = this.Positions[this.PlayPositionIndex].Tune;
            this.PosNumbOfLoops = this.Positions[this.PlayPositionIndex].NumbOfLoops;
            this.PosStart = this.Positions[this.PlayPositionIndex].StartRow;
            this.PosLen = this.Positions[this.PlayPositionIndex].RowLength;
            this.PosSpeed = this.Positions[this.PlayPositionIndex].Speed_Cycl;
            this.PlayingPatternNr = this.Positions[this.PlayPositionIndex].PatternNumbers[0];
            this.PlayLinePos = this.PosStart;
            this.isPositionPlaying = true;
        }
    }

    void PlayPosition(int PosIndex) {
        this.SongPlaying = false;
        this.PlayPositionIndex = PosIndex;
        this.PlayPositionInit();
        this.SongPlaying = true;
    }

    void PlaySong() {
        this.PlayLinePos = 0.0f;
        this.SongPlaying = true;
    }

    void PlayFromFirstSequence() {
        if (this.Sequences[0] != null) {
            if (this.Sequences[0].Action == 0) {
                this.PlayPosition(this.Sequences[0].StartPosition);
            } else {
                this.PlayPosition(0);
            }
        } else {
            this.PlayPosition(0);
        }
    }

    void StopSong() {
        this.isPositionPlaying = false;
        this.SongPlaying = false;
    }

    void initResources(int NumbSeq, int NumbPos, int NumbPattern, int Instr) {
        this.Sequences = new Sequence[NumbSeq];
        this.Positions = new Position[NumbPos];
        this.Patterns = new SongPattern[NumbPattern];
        if (!this.InstrumentsAllocated) {
            this.Instruments = new SymphonieInstrument[Instr];
        }
        this.InstrumentsAllocated = true;
        this.ResourcesAllocated = true;
    }

    public boolean hasContent() {
        return this.ResourcesAllocated;
    }

    void allocDefaultNumbInstruments() {
        if (!this.InstrumentsAllocated) {
            this.allocNumbInstruments(256);
        }
    }

    void allocNumbOfPositions(int i) {
        this.Positions = new Position[i];
        this.setNumbOfPositions(i);
    }

    void allocNumbOfSequences(int i) {
        this.Sequences = new Sequence[i];
        this.setNumbOfSequences(i);
    }

    void allocNumbInstruments(int i) {
        this.Instruments = new SymphonieInstrument[i];
        this.InstrumentsAllocated = true;
        this.setNumbOfInstruments(i);
    }

    int getNumbInstrumentsAllocated() {
        if (this.InstrumentsAllocated) {
            return this.getNumbOfInstruments();
        }
        return 0;
    }

    void allocResources() {
        if (!this.ResourcesAllocated) {
            this.initResources(this.getNumbOfSequences(), this.getNumbOfPositions(), this.getNumbOfPatterns(), this.getNumbOfInstruments());
        }
    }

    void updatePatternSize() {
        this.PatternSize = this.NumbOfVoices * this.NumbOfRows;
    }

    int getPatternSize() {
        return this.PatternSize;
    }

    void setNumbOfPatterns(int i) {
        this.Patterns = new SongPattern[i];
        this.NumbOfPatterns = i;
    }

    int getNumbOfPatterns() {
        return this.NumbOfPatterns;
    }

    void setNumbOfSequences(int i) {
        this.NumbOfSequences = i;
    }

    int getNumbOfSequences() {
        return this.NumbOfSequences;
    }

    void setNumbOfPositions(int i) {
        this.NumbOfPositions = i;
    }

    int getNumbOfPositions() {
        return this.NumbOfPositions;
    }

    void setNumbOfVoices(int i) {
        this.NumbOfVoices = i;
        this.updatePatternSize();
    }

    int getNumbOfVoices() {
        return this.NumbOfVoices;
    }

    void setNumbOfRows(int i) {
        this.NumbOfRows = i;
        this.updatePatternSize();
    }

    int getNumbOfRows() {
        return this.NumbOfRows;
    }

    void setNumbOfInstruments(int i) {
        this.NumbOfInstruments = i;
    }

    int getNumbOfInstruments() {
        return this.NumbOfInstruments;
    }

    void setBPM(float i) {
        this.BPM = i;
    }

    float getBPM() {
        return this.BPM;
    }

    Sequence getSequence(int i) {
        if (i < this.getNumbOfSequences()) {
            if (this.Sequences[i] == null) {
                this.Sequences[i] = new Sequence();
            }
            this.Sequences[i].ParentSong = this;
            return this.Sequences[i];
        }
        return null;
    }

    Position getPosition(int i) {
        if (i < this.getNumbOfPositions()) {
            if (this.Positions[i] == null) {
                this.Positions[i] = new Position();
            }
            this.Positions[i].ParentSong = this;
            return this.Positions[i];
        }
        return null;
    }

    SongPattern getPattern(int i) {
        if (i < this.getNumbOfPatterns()) {
            if (this.Patterns[i] == null) {
                this.Patterns[i] = new SongPattern();
            }
            this.Patterns[i].ParentSong = this;
            return this.Patterns[i];
        }
        return null;
    }

    SymphonieInstrument getInstrument(int i) {
        this.allocDefaultNumbInstruments();
        if (i < this.getNumbOfInstruments()) {
            if (this.Instruments[i] == null) {
                this.Instruments[i] = new SymphonieInstrument();
            }
            return this.Instruments[i];
        }
        return null;
    }

    SymphonieInstrument getInstrumentExisting(int i) {
        this.allocDefaultNumbInstruments();
        if (i < this.getNumbOfInstruments()) {
            if (this.Instruments[i] != null) {
                return this.Instruments[i];
            }
        } else {
            return null;
        }
        return null;
    }

    SymphonieInstrument getFreeInstrument() {
        for (int i = 0; i < this.getNumbOfInstruments(); ++i) {
            if (this.getInstrument((int)i).isInUse) continue;
            return this.Instruments[i];
        }
        return null;
    }

    int PlaySongEvent(VoiceExpander vx) {
        this.LinkedVoiceExpander = vx;
        if (this.isPositionPlaying) {
            this.PlayEventsAtPos(vx, this.PlayLinePos);
            this.PlayLinePos += 1.0f;
            if (this.PlayLinePos >= (float)(this.PosStart + this.PosLen)) {
                --this.PosNumbOfLoops;
                if (this.PosNumbOfLoops <= 0) {
                    this.MoveToNextPosition();
                    vx.setSongSpeed(this.BPM, this.PosSpeed);
                } else {
                    this.PlayLinePos = this.PosStart;
                }
            }
        } else {
            this.PlayEventsAtPos(vx, this.PlayLinePos);
            this.PlayLinePos += 1.0f;
            if (this.PlayLinePos >= (float)this.NumbOfRows) {
                this.PlayLinePos = 0.0f;
                this.SongPlaying = false;
            }
        }
        return 0;
    }

    void PlayEventsAtPos(VoiceExpander vx, float PlayLinePos) {
        for (int VoiceNr = 0; VoiceNr < this.getNumbOfVoices(); ++VoiceNr) {
            this.PlayEventsOfVoiceAtPos(vx, PlayLinePos, VoiceNr);
        }
    }

    void PlayEventsOfVoiceAtPos(VoiceExpander vx, float PlayLinePos, int VoiceNr) {
        SongPattern Pat = this.getPattern(this.PlayingPatternNr);
        PatternVoice pv = Pat.PatternVoices[VoiceNr];
        SongEventPool sep = pv.getSongEventPool(PlayLinePos);
        for (int i = 0; i < sep.getNumberOfSongEvents(); ++i) {
            SongEvent mySongEvent = sep.getSongEvent(i);
            if (mySongEvent == null) continue;
            this.PlaySongEvent(vx, VoiceNr, mySongEvent);
        }
    }

    SongEventPool getSongEventPool(int PatNr, int VoiceNr, float TimePosition) {
        SongPattern Pat = this.getPattern(PatNr);
        PatternVoice pv = Pat.PatternVoices[VoiceNr];
        return pv.getSongEventPool(TimePosition);
    }

    int ConvertSymphInstrToNewInstrIndex(int SymphInstr) {
        for (int i = 0; i < this.getNumbOfInstruments(); ++i) {
            SymphonieInstrument si = this.getInstrumentExisting(i);
            if (si == null || si.OrigInstrumentNr != SymphInstr) continue;
            return i;
        }
        return -1;
    }

    boolean checkIsLeftStereoChannel(int ChannelIndex) {
        return (ChannelIndex & 1) == 0;
    }

    void addKeyOnEvent(int PatNr, int x, int y, int InstrNr, int Pitch, int Vol) {
        SongEventPool se = this.getSongEventPool(PatNr, x, y);
        SongEvent MySongEvent = se.getSongEvent(0);
        if (MySongEvent != null) {
            MySongEvent.setKeyOn(InstrNr, Pitch, Vol);
        }
    }

    void clrEvent(int PatNr, int x, int y) {
        SongEventPool se = this.getSongEventPool(PatNr, x, y);
        SongEvent MySongEvent = se.getSongEvent(0);
        if (MySongEvent != null) {
            MySongEvent.clear();
        }
    }

    void PlaySongEvent(VoiceExpander vx, int VoiceNr, SongEvent e) {
        int tempPitch = (int)e.B;
        int tempInstrNr = (int)e.A;
        switch (e.SongFXType) {
            case 1: {
                SymphonieInstrument si;
                float tempVolume = e.C;
                if (!(tempVolume <= 100.0f) || (si = this.getInstrumentExisting(tempInstrNr)) == null || !si.checkReady()) break;
                vx.SongEventKeyOn(si, VoiceNr, tempPitch, tempVolume);
                if (si.MultiChannel != 1 || !this.checkIsLeftStereoChannel(VoiceNr) || !(si = this.getInstrumentExisting(tempInstrNr + 1)).checkReady()) break;
                vx.SongEventKeyOn(si, VoiceNr + 1, tempPitch, tempVolume);
                break;
            }
            case 2013: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.SongEventSetPitch(si, VoiceNr, tempPitch);
                break;
            }
            case 1000: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.SongEventVSlide(VoiceNr, e.C);
                break;
            }
            case 1001: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.SongEventVSlide(VoiceNr, -e.C);
                break;
            }
            case 1002: {
                vx.SongEventAddVolume(VoiceNr, e.C / 8.0f);
                break;
            }
            case 1009: {
                vx.SongEventSetVolume(VoiceNr, e.C);
                break;
            }
            case 1006: {
                vx.SongEventPausePlaying(VoiceNr);
                break;
            }
            case 1007: {
                vx.SongEventContinue(VoiceNr, true);
                break;
            }
            case 3001: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.SongEventKeyOnSamplePos(si, VoiceNr, tempPitch, e.C);
            }
        }
    }
}

