/*
 * Decompiled with CFR 0.152.
 */
package symreader;

class SamplePool {
    float[] Samples = null;
    private int NumbOfSamples = 0;
    private boolean HasLoop = false;
    private boolean EndlessLoop = false;
    private int NumbOfLoops = 0;
    private int LoopStartSampleIndex = 0;
    private int LoopLengthSamples = 0;
    private int LoopEndSampleIndex = 0;

    SamplePool() {
    }

    int getNumbOfSamples() {
        if (this.Samples == null) {
            this.NumbOfSamples = 0;
        }
        return this.NumbOfSamples;
    }

    void setNumbOfSamples(int i) {
        this.NumbOfSamples = i;
        if (this.NumbOfSamples == 0) {
            this.Samples = null;
        }
    }

    boolean hasLoop() {
        return this.HasLoop;
    }

    int getNumbOfLoops() {
        if (this.HasLoop) {
            return this.NumbOfLoops;
        }
        return 0;
    }

    int getLoopStart() {
        return this.LoopStartSampleIndex;
    }

    int getLoopLen() {
        return this.LoopLengthSamples;
    }

    int getLoopEndSampleIndex() {
        return this.LoopEndSampleIndex;
    }

    boolean getEndlessLoop() {
        return this.EndlessLoop;
    }

    void initLoopDateSymphonieFormat(boolean InstrHasLoop, float Start, float Len, int newNumbOfLoops) {
        this.HasLoop = false;
        this.EndlessLoop = false;
        if (this.NumbOfSamples > 0 && Len > 0.0f && InstrHasLoop) {
            this.LoopStartSampleIndex = (int)(Start * (float)this.NumbOfSamples / 6553600.0f);
            this.LoopLengthSamples = (int)(Len * (float)this.NumbOfSamples / 6553600.0f);
            this.LoopEndSampleIndex = this.LoopStartSampleIndex + this.LoopLengthSamples;
            if (this.LoopEndSampleIndex >= this.NumbOfSamples) {
                this.LoopEndSampleIndex = this.NumbOfSamples - 1;
                this.LoopLengthSamples = this.LoopEndSampleIndex - this.LoopStartSampleIndex;
            }
            this.EndlessLoop = false;
            if (newNumbOfLoops == 0) {
                this.EndlessLoop = true;
            }
            this.NumbOfLoops = newNumbOfLoops;
            assert (this.LoopStartSampleIndex >= 0);
            assert (this.LoopLengthSamples >= 0);
            assert (this.LoopEndSampleIndex >= 0);
            this.HasLoop = true;
        }
    }
}

