*****************************************************************************
**                                                                         **
** Engine: Stereoscope                                                     **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


	;*********************************************
	;**    Eagleplayer Stereoscope Color V1.0   **
	;**            1994 Henryk Richter         **
	;** Stand: 28.1.96                          **
	;*********************************************
	;
	incdir	include:
	include	exec/exec_lib.i
	include	exec/libraries.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	dos/dos_lib.i
	include	libraries/dos.i
	include	graphics/graphics_lib.i
	include	misc/Eagleplayer.i
	include	misc/EagleplayerEngine.i
	include	misc/buggsmacros.i
	;
ver		macro
		dc.b	"1.03"
		endm
StructVer	macro
		dc.w	1,03
		endm
date		macro
		dc.b	"05-Apr-97"
		endm
StructDate	macro
		dc.b	05,04
		dc.w	1997
		endm


Test = 0	;auf 0 lassen zur Nutzung mit dem Eagleplayer
		;zu Testzwecken meldet sich der Analyzer sonst selbst ab ,
		;interne Testfunktion
Debug = 0
Flacker = 0
;===========================================================================
	section	0,code
;===========================================================================
an_num = 32			;Anzahl der Balken (nicht ndern)
an_zeilen = 64			;Anzahl der Zeilen (nicht ndern)
win_breite = (an_num+8)*8+4-1
;===========================================================================
BEGIN
	bra.w	fangan
	EUSN_Identifier
	dc.l	0		;eus_next
	ifne	debug
	dc.w	-2
	else
	dc.w	0		;eus_Usernr
	endc
	dc.l	0;patt2		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0;$224534		;eus_unused
	dc.l	0;$101010		;eus_unused
	dc.l	0		;eus_unused3
	dc.l	Tagliste	;eus_unused4
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_Zipwin!USMB_ChangeConfig!USMB_ChangeInterrupt;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	myinfo
	dc.w	39		;eus_Kickstart
	dc.l	EAGLEVERSION	;eus_EPVersion
	structver		;eus_version,revision
	dc.l	MyUsername	;eus_username
	dc.w	269		;eus_winx
	dc.w	106		;eus_winy
	dc.w	EUSB_openwin	;window opened
	dc.l	0		;EUS_Special
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	structdate		;EUS_Creatordate
	dc.b	-5		;EUS_Priority
	dc.b	EUTY_Scope
	dc.w	0
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

		ifne	(*-begin)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	`$VER: Eagleplayer Stereoscope Color V`
		ver
		dc.b	` (`
		date
		dc.b	`)`,0
		even

Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Stereoscope
		dc.l	0

Fangan
	move.l	4,a6

	lea	datas,a5
	move.l	a5,a0
	move.w	#dataslen-1,d0
.clr	move.b	#0,(a0)+
	dbf	d0,.clr

	move.w	#2,slowid(A5)

	lea	fulls(a5),a0
	moveq	#an_zeilen/16-1,d0
.loop1
	moveq	#15-1,d1
.loop2
	rept	an_num/4
	move.w	#-1,(a0)+
	endr
	dbf	d1,.loop2
	rept	an_num/4
	move.w	#-1,(a0)+
	endr
	dbf	d0,.loop1

	lea	Gitter(a5),a0
	moveq	#an_zeilen/16-1,d0
.loop12
	moveq	#15-1,d1
.loop22
	rept	an_num/4
	move.w	#1,(a0)+
	endr
	dbf	d1,.loop22
	rept	an_num/4
	move.w	#-1,(a0)+
	endr
	dbf	d0,.loop12

	lea	NotGitter(a5),a0
	moveq	#an_zeilen/16-1,d0
.loop13
	moveq	#15-1,d1
.loop23
	rept	an_num/4
	move.w	#~1,(a0)+
	endr
	dbf	d1,.loop23
	rept	an_num/4
	move.w	#0,(a0)+
	endr
	dbf	d0,.loop13

	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;Signal allokieren
	tst.l	d0
	blt	NoSignal
	move.l	d0,mysignal(a5)

	move.l	#-1,mypen1(A5)
	move.l	#-1,mypen2(A5)

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)
	move.l	d0,mytask(a5)

	lea	dos(pc),a1
	moveq	#33,d0			;Brauchen DOS V1.2,fr Message,falls
	jsr	_LVOopenlibrary(a6)	;Start von 1.2/1.3 aus
	move.l	d0,_dos(a5)
	beq	NODOS

	cmp.w	#39,LIB_Version(a6)	;EXEC V37 ?
	bge.s	.Dos_ok		;ja->Weiter

	move.l	_DOS(a5),a6
	lea	confile(pc),a0
	move.l	a0,d1
	move.l	#mode_oldfile,d2
	jsr	_LVOopen(a6)
	tst.l	d0
	beq.s	.Blossraus	;Nicht einmal AUSGABE auf CON: funtioniert
	move.l	d0,d6
	move.l	d0,d1

	lea	conout(pc),a0
	move.l	a0,d2
	moveq	#conlen,d3
	jsr	_LVOwrite(a6)	;Ausgabe "Needs Amiga OS2.04 or higher"

	move.l	#250,d1		;~5 Sekunden warten
	jsr	_LVOdelay(a6)

	move.l	d6,d1		;Con schlieen
	jsr	_LVOclose(a6)
.blossraus
	bra	NoPort
.dos_ok
	move.l	4,a6
	jsr	_LVOcreatemsgport(a6)	;Messageport auf die schnelle Art
	move.l	d0,MSGport(a5)
	beq	NoPort

	lea	int(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,intsave(a5)
	beq	NOINT

	lea	graf(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,grafsave(a5)
	beq	NOGRAF

	lea	gad(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,gadsave(a5)
	beq	nogadto

	moveq	#0,d7

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse haben mchte
	blt	endme	;Fehler aufgetreten

	bsr	HandleActions		;Auf Usereingaben reagieren
endme
	move.l	d7,-(sp)
	bsr	closewin
	move.l	(sp)+,d7		;Error oder Exit-Message vom Player
	blt.s	Error
	bsr	Sendlastmessage
Error
	move.l	mypen1(A5),d0
	blt.s	.nopen
	move.l	mycmap(A5),a0
	move.l	grafsave(A5),a6
	jsr	_LVOreleasepen(A6)
	move.l	#-1,mypen1(A5)
.nopen
	move.l	mypen2(A5),d0
	blt.s	.nopen2
	move.l	mycmap(A5),a0
	move.l	grafsave(A5),a6
	jsr	_LVOreleasepen(A6)
	move.l	#-1,mypen2(A5)
.nopen2
	move.l	mypubscreen(a5),d0
	beq.s	.ok
	move.l	d0,a1
	suba.l	a0,a0
	move.l	intsave(A5),a6
	jsr	_LVOunlockpubscreen(a6)
.ok
	move.l	gadsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(A6)
nogadto
	move.l	grafsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(a6)
NoGraf
	move.l	intsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(a6)
noint
	move.l	4,a6
	move.l	MSGport(a5),a0
	jsr	_LVOdeletemsgport(a6)
NoPort
	move.l	4,a6
	move.l	_dos(a5),a1
	jsr	_LVOcloselibrary(a6)
nodos
	move.l	mysignal(a5),d0
	move.l	4,a6
	jsr	_LVOfreesignal(a6)
NoSignal
	moveq	#0,d0
	rts
************************************************************************
*                   Fenster ffnen                                     *
************************************************************************
Openwin
	tst.l	winhandle(a5)
	bne.w	.Error2

	move.l	intsave(a5),a6

	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep
	move.l	d0,a0
	move.l	EPG_Pubscreen(a0),d0
.noep
	move.l	d0,a0

	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	bne.s	.pubs

	suba.l	a0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	beq	.Error2			;sollte nicht auftreten
.pubs
	move.l	d0,mypubscreen(a5);fr UnLockpubscreen()
	move.l	d0,a1
	move.b	sc_wborleft(a1),d0
	ext.w	d0
	move.w	d0,offx(a5)

	move.l	sc_font(a1),a0
	move.l	a0,fontatt(a5)

	move.w	ta_ysize(a0),d0		;Hhe des Screenfonts
	move.w	d0,d1
	move.w	d0,fonth(a5)
	move.b	sc_wbortop(a1),d0
	ext.w	d0
	add.w	d0,d1			;Berechnen der Gre fr ZIPwindow()
	move.w	d1,myhoehe1(a5)		;und eintragen
	
	move.w	#win_breite,winwidth(a5)
	movem.l	d0-d6/a0-a6,-(sp)
	bsr	makemenus		;Mens basteln
	movem.l	(sp)+,d0-d6/a0-a6
	tst.l	d7
	blt.w	.Error

	move.l	sc_viewport+vp_colormap(a1),a0	;Viewport->Colormap
	move.l	a0,mycmap(A5)
	moveq	#-1,d0			;Number
	moveq	#0,d1			;Red
	move.l	#84<<24,d2		;Green
	moveq	#0,d3			;Blue
;	move.l	#1<<PEN_Exclusive,d4	;Flags
	moveq	#0,d4
	move.l	grafsave(A5),a6
	jsr	_LVOObtainPen(A6)
	move.l	d0,mypen1(A5)
	cmp.l	#255,d0
	blo.s	.penok1
	bra.s	.fail2
.penfail
	move.l	mycmap(A5),a0
	jsr	_LVOreleasepen(A6)
	move.l	#-1,mypen2(A5)
.fail2
	move.l	mypen1(a5),d0
	move.l	mycmap(A5),a0
	jsr	_LVOreleasepen(A6)
	move.l	#-1,mypen1(A5)

	lea	NoPenMessage(pc),a0
	bsr	Merror
	bra	.Error
.penok1
	move.l	mypubscreen(a5),a0
	lea	sc_viewport(a0),a0
	move.l	mypen1(a5),d0
	move.l	#0,d1			;Red
	move.l	#84<<24,d2		;Green
	move.l	#0<<24,d3		;Blue
	jsr	_LVOsetrgb32(A6)

	move.l	mycmap(A5),a0
	moveq	#-1,d0			;Number
	moveq	#0,d1			;Red
	move.l	#255<<24,d2		;Green
	moveq	#0,d3			;Blue
;	move.l	#1<<PEN_Exclusive,d4	;Flags
	moveq	#0,d4
	move.l	grafsave(A5),a6
	jsr	_LVOObtainPen(A6)
	move.l	d0,mypen2(A5)
	cmp.l	#255,d0
	bhi.s	.penfail

	move.l	mypubscreen(a5),a0
	lea	sc_viewport(a0),a0
	move.l	mypen2(a5),d0
	move.l	#0,d1			;Red
	move.l	#255<<24,d2		;Green
	move.l	#0<<24,d3		;Blue
	jsr	_LVOsetrgb32(A6)

	lea	mytags(a5),a1		;WINDOW INIT

	move.l	#WA_Pubscreen,(a1)+
	move.l	mypubscreen(A5),(a1)+

	move.l	#wa_newlookmenus,(A1)+
	move.l	#1,(A1)+

	move.l	#wa_Pubscreenfallback,(A1)+
	move.l	#1,(a1)+

	lea	begin(pc),a0
	moveq	#0,d0
	move.l	#wa_top,(a1)+
	move.w	eus_winy(a0),d0
	move.l	d0,(a1)+
	move.l	#wa_left,(a1)+
	move.w	eus_winx(a0),d0
	move.l	d0,(a1)+
	move.l	#wa_innerwidth,(a1)+	;Breite
	move.l	#win_breite-6,(a1)+	;20Spalten+15*8Pixel fr Gadgets+Rand
	move.l	#wa_innerheight,(a1)+	;Hhe
	move.l	#AN_zeilen+12+11,(a1)+
	move.l	#wa_flags,(a1)+
	move.l	#Windowdrag!Windowdepth!Windowclose,(a1)+
	move.l	#WA_TITLE,(a1)+
	lea	mywinname(pc),a0
	move.l	a0,(a1)+
	move.l	#wa_zoom,(a1)+
	lea	myzoom(a5),a0
	move.w	#0,(a0)
	move.w	#79,2(a0)
	move.w	#168,4(a0)		;Breite des Zip-Windows im SMALL-MODE
	move.w	myhoehe1(a5),myhoehe2(a5)
	move.l	a0,(a1)+
	move.l	#wa_idcmp,(a1)+
 move.l	#closewindow!vanillakey!menupick!refreshwindow,(a1)+
	move.l	#wa_autoadjust,(a1)+
	move.l	#1,(a1)+

	move.l	#WA_ScreenTitle,(a1)+
	move.l	#Project0STitle,(a1)+

	move.l	#TAG_DONE,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)
	move.l	d0,Winhandle(a5)
	tst.l	d0
	bne.s	.winopened

	lea	mytags(a5),a1		;Fehler,nochmal auf Position 0/0
	move.l	#wa_top,(a1)+		;zu ffnen versuchen
	move.l	#0,(a1)+
	move.l	#wa_left,(a1)+
	move.l	#0,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;wirst DU wohl aufgehen !
	move.l	d0,Winhandle(a5)
	tst.l	d0
	beq.w	.Error
.winopened

	move.l	d0,a0
	move.l	wd_userport(a0),a0	;User Port
	move.l	a0,port(a5)

	lea	my_bitmap(a5),a3
	bsr	makebitmap
	blt	.Error
	bsr	makegitterbuf

	bsr	refresh

	bsr	addmenus		;Men darstellen
	move.l	intsave(a5),a6
	suba.l	a0,a0
	move.l	mypubscreen(a5),d0
	beq.s	.nopub
	move.l	d0,a1
	clr.l	mypubscreen(a5)
	jmp	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.nopub	
.error2
	rts
.error
	move.l	intsave(a5),a6
	suba.l	a0,a0
	move.l	mypubscreen(a5),d0
	beq.s	.nopub
	move.l	d0,a1
	clr.l	mypubscreen(a5)
	jmp	_LVOunlockpubscreen(a6)	;PUBscreen freigeben

	bsr	FreetheMenus
	bra	closewin
*******************************************************************
*                   Window schlieen                              *
*******************************************************************
Closewin
	tst.l	winhandle(a5)
	beq.s	.nowin

	move.l	grafsave(A5),a6
	move.l	mypen1(A5),d0
	blt.s	.nopen
	move.l	mycmap(A5),a0
	jsr	_LVOreleasepen(A6)
	move.l	#-1,mypen1(A5)
.nopen
	move.l	mypen2(A5),d0
	blt.s	.nopen2
	move.l	mycmap(A5),a0
	jsr	_LVOreleasepen(A6)
	move.l	#-1,mypen2(A5)
.nopen2

	bsr	freebitmap
	bsr	freemenus
	
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	clr.l	Winhandle(a5)
	clr.l	port(a5)
	move.w	myhoehe1(a5),d0
	cmp.w	wd_height(a0),d0
	beq.s	.noxy
	lea	begin(pc),a1
	move.w	wd_leftedge(a0),eus_winx(a1)
	move.w	wd_topedge(a0),eus_winy(a1)
.noxy
	jsr	_LVOclosewindow(a6)
.nowin	rts
********************************************************************
*                  Gitterpuffer lschen                            *
********************************************************************
makegitterbuf
	movem.l	d0-a6,-(sp)

	lea.l	my_bitmap(a5),a0
	moveq	#0,d2
	move.w	(a0),d2			;Bytes per Row
	moveq	#0,d0
	move.b	bm_depth(a0),d0
	subq.w	#1,d0			;Anzahl der Bitplanes
	move.l	mypen1(a5),d1

	lea	gitterbuff(A5),a1
	move.l	a1,a0

	moveq	#an_zeilen-1,d4

	lea	NotGitter(a5),a3
	asr.l	#1,d1
	bcc.s	.loesch2
	lea	Fulls(a5),a3

	bra.s	.loesch2
.loesch1
	move.l	a1,a0

	moveq	#an_zeilen-1,d4

	lea	nulls(A5),a3
	asr.l	#1,d1
	bcc.s	.loesch2
	lea	gitter(a5),a3
.loesch2
	move.l	(a3)+,(a0)+			;1 Zeile
	move.l	(a3)+,(a0)+
	move.l	(a3)+,(a0)+
	move.l	(a3)+,(a0)+
	dbf	d4,.loesch2

	lea	an_num/2*an_zeilen(a1),a1		;nchste Bitplane
	dbf	d0,.loesch1

	movem.l	(sp)+,d0-a6
	rts
********************************************************************
*                  Init Message Struktur                           *
********************************************************************
Sendfirstmessage
	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	bne.s	.ok
	bsr	openwin
	lea	NoportMessage(pc),a0
	lea	my_easystruct(a5),a1
	move.l	a0,es_textformat(a1)
	lea	my_easygadget2(pc),a0
	move.l	a0,es_gadgetformat(a1)
	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),d0	;*Window
	beq.w	.error	;kann kein Window ffnen
	move.l	d0,a0
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	tst.l	d0
	beq.s	.error
	bra	SendFirstmessage
.ok
	move.l	d0,a0			;Portadresse

	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	mysignal(a5),d5
	move.w	#USclass_Newuserprg,d6

	ifne	debug

	bsr	allocmsg
	beq.s	.error
	move.l	d0,a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2
	move.l	a2,um_result(a1)
	move.w	#-2,UM_UserNr(a1)
	move.l	#USM_Userprg,UM_Type(a1)


	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jsr	_LVOputmsg(a6)

	else
	bsr	sendmess
	endc

	move.b	#1,messagesent(a5)

	moveq	#0,d7
	rts
.error
	moveq	#-1,d7
	rts
*****************************************************************
allocmsg
	movem.l	d1-a6,-(sp)
	move.l	4,a6
	moveq	#UM_Sizeof,d0
	move.l	#$10001,d1
	jsr	_LVOallocmem(A6)
	movem.l	(sp)+,d1-a6
	tst.l	d0
	rts
*****************************************************************
freemsg
	moveq	#UM_sizeof,d0
	move.l	4,a6
	jsr	_LVOfreemem(A6)
	rts
******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
Sendlastmessage:
	move.l	4,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	moveq	#0,d4
	moveq	#0,d5
	move.w	#USclass_exit,d6

	bsr	sendmess
.wait
	move.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	move.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
*******************************************************************************
sendmess:
	bsr	allocmsg
	bne.s	.ok
	rts
.ok
	move.l	d0,a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc
	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jmp	_LVOputmsg(a6)
*******************************************************************************
*                        Mens erstellen                                      *
*******************************************************************************
MakeMenus
	move.l	gadsave(a5),A6

	move.l	mypubscreen(a5),a0
	suba.l	a1,a1
	jsr	_LVOgetvisualinfoa(a6)	;Visual Info vom Screen anfordern
	move.l	d0,vi(a5)
	tst.l	d0
	beq	.nomen

	lea	mymenus(A5),a0
	move.b	#nm_title,gnm_type(a0)
	lea	mylabel1(pc),a1
	move.l	a1,gnm_Label(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof(a0)
	lea	mylabel4(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof(a0)
	move.w	#CHECKIT!Menutoggle,gnm_flags+gnm_sizeof(a0)
	move.w	#2,slowid(a5)
	lea	begin(pc),a2
	move.w	eus_special(A2),d0
	cmp.w	#2,d0
	beq.s	.nomode0
	cmp.w	#3,d0
	bne.s	.nomode0
	move.w	d0,slowid(a5)
	move.w	#Checked!Menutoggle!CHECKIT,gnm_flags+gnm_sizeof(a0)
.nomode0

	move.b	#nm_item,gnm_type+gnm_sizeof*2(a0)
	lea	mylabel2(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*2(a0)
	lea	mylabel21(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*2(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*3(a0)
	lea	myhide(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*3(a0)
	lea	myhide1(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*3(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*4(a0)
	lea	mylabel3(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*4(a0)
	lea	mylabel31(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*4(a0)

	move.b	#nm_end,gnm_type+gnm_sizeof*5(a0)

	move.l	gadsave(a5),a6
	lea	mytags(a5),a1
	move.l	#gtmn_fullmenu,(a1)+
	move.l	#1,(a1)+
	move.l	#GTMN_Newlookmenus,(A1)+
	move.l	#1,(A1)+
	move.l	#tag_done,(a1)
	lea	mytags(a5),a1

	jsr	_LVOcreatemenusA(a6)
	move.l	d0,menuadr(a5)
	tst.l	d0
	beq.s	.nomen
	move.l	d0,a0
	move.l	vi(a5),a1
	lea	mytags(a5),a2
	move.l	#GTMN_Newlookmenus,(A2)+
	move.l	#1,(A2)+
	move.l	#tag_done,(a2)
	lea	mytags(a5),a2
	jsr	_LVOLayoutMenusA(a6)
	tst.l	d0
	beq.s	.free
	
	moveq	#0,d7
	rts
.free
	move.l	menuadr(a5),a0
	jsr	_LVOfreemenus(a6)
.nomen
	moveq	#-1,d7
	rts
********************* Visual Info Freigeben ***********************************
Freevi:
	move.l	vi(a5),a0
	jmp	_LVOfreevisualinfo(a6)
*********************** Men wechschmeisen ************************************
Freemenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	jsr	_LVOclearmenustrip(A6)
FreetheMenus
	move.l	gadsave(a5),a6
	move.l	Menuadr(a5),d0
	beq.s	.end
	clr.l	menuadr(A5)
	move.l	d0,a0
	jmp	_LVOfreemenus(a6)
.end
	bsr	Freevi	;Visual Info Wegschmeien
	rts
********************* Men anhngen *************************
Addmenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	move.l	Menuadr(a5),a1
	jmp	_LVOsetmenustrip(a6)
*************************************************************
*     2. Bitmap erzeugen fr direkten Zugriff auf Bild      *
*       (per Blitter wird kopiert,Tiefe = 1)                *
*************************************************************
makebitmap
	move.l	4,a6

	move.w	#an_num/2,(a3)		;bm_BytesPerRow
	move.w	#an_zeilen,bm_rows(a3)	;90 Zeilen

	move.l	mypen1(a5),d0
	moveq	#0,d1
.ok
	addq.w	#1,d1
	asr.l	#1,d0
	bne.s	.ok

	move.b	d1,bm_depth(a3)		;auf 1 lassen

	move.l	#[an_num+4]*8*[an_Zeilen+2]/2,d0	;AN_Num/2 = 1 Kasten
	move.l	#$10002,d1		;#memf_chip,d1
	jsr	_LVOallocmem(a6)
	tst.l	d0
	beq.s	.norast
	move.l	d0,memadr(A5)

	add.l	#an_num*2,d0		;2 Zeilen zur Sicherheit tiefer
	lea	bm_planes(A3),a1
	moveq	#7,d1
.bpl	
	move.l	d0,(a1)+		 ;hier
	add.l	#[an_num/2]*an_zeilen,d0 ;alle 8 Bitplanes eintragen
	dbf	d1,.bpl

	moveq	#0,d7
	rts
.norast
	moveq	#-1,d7
	rts
**************************************************************
*                   Bitplane(s) freigeben                    *
**************************************************************
freebitmap
	move.l	4,a6
	move.l	memadr(A5),d0
	beq.s	.no1
	clr.l	memadr(A5)
	move.l	d0,a1
	move.l	#[an_num+4]*8*an_zeilen/2,d0
	jsr	_LVOfreemem(a6)	
.no1
	lea	my_bitmap(a5),a1
	clr.l	bm_planes(a1)	;Planeptr[1] lschen
RET	rts
*************************************************************
*           Windowrefresh und Detaildarstellung             *
*************************************************************
Refresh:
	move.l	winhandle(a5),d0
	beq.s	RET
	move.l	d0,a0

	move.w	myhoehe1(a5),d1		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d1
	beq.s	RET			;ja,kein Refresh

	move.l	grafsave(a5),a6
	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0
	jsr	_LVOsetapen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	move.b	#1,rp_areaptsz(a1)
	lea	patt1(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	offx(a5),d0		;x1
	move.w	myhoehe1(A5),d1		;y1
	move.w	#win_breite-6,d2	;x2
	add.w	d0,d2
	move.w	#AN_zeilen+15-3+10,d3	;y2
	add.w	d1,d3
	movem.l	d4-d5,-(sp)
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	lea	patt2(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	offx(a5),d0
	add.w	#9,d0			;Left
	move.w	myhoehe1(a5),d1		;Top
	add.w	#4,d1
	move.w	#[an_num+4]*4,d2
	move.w	#an_zeilen+4+10,d3
	add.w	d0,d2
	add.w	d1,d3
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	move.w	offx(a5),d0
	add.w	#9+[an_num+6]*4,d0 ;Left
	move.w	myhoehe1(a5),d1	;Top
	add.w	#4,d1
	move.w	#[an_num+4]*4,d2
	move.w	#an_zeilen+4+10,d3
	add.w	d0,d2
	add.w	d1,d3
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	move.w	#3+8,d0
	move.w	myhoehe1(A5),d1		;y1
	addq.w	#4,d1
	jsr	_LVOmove(A6)

	movem.l	(Sp)+,d4-d5

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	move.b	d4,rp_areaptsz(a1)
	move.l	d5,rp_areaptrn(a1)

	move.l	gadsave(a5),a6

	move.l	winhandle(a5),a0
	move.l	wd_rport(a0),a0
	lea	mytags(a5),a3
	move.l	#GT_Visualinfo,(a3)+
	move.l	vi(a5),(a3)+
	move.l	#GTBB_recessed,(a3)+
	move.l	#1,(a3)+
	move.l	#tag_done,(a3)+
	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
	move.l	a3,a1
	move.w	offx(a5),d0
	add.w	#9,d0 ;Left
	move.w	myhoehe1(a5),d1	;Top
	add.w	#4,d1
	move.w	#[an_num+4]*4,d2
	move.w	#an_zeilen+4+10,d3
	jsr	_LVOdrawbevelboxa(a6)

	move.l	winhandle(a5),a0
	move.l	wd_rport(a0),a0
	lea	mytags(a5),a3
	move.l	#GT_Visualinfo,(a3)+
	move.l	vi(a5),(a3)+
	move.l	#GTBB_recessed,(a3)+
	move.l	#1,(a3)+
	move.l	#tag_done,(a3)+
	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
	move.l	a3,a1
	move.w	offx(a5),d0
	add.w	#9+[an_num+6]*4,d0 ;Left
	move.w	myhoehe1(a5),d1	;Top
	add.w	#4,d1
	move.w	#[an_num+4]*4,d2
	move.w	#an_zeilen+4+10,d3
	jsr	_LVOdrawbevelboxa(a6)

	move.l	winhandle(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOrefreshwindowframe(A6)

	bsr	clear
	bsr	intowindow
	bsr	intowindow2
	rts
***************************************************************
* ANALYZER , berechnet Positionen,zeichnet ein und stellt dar *
* 1. Variante,(von unten nach oben wachsend)                  *
***************************************************************
;====================== Bereich lschen ===================================
Clear:
	movem.l	d0-a6,-(Sp)
;============== Normale Lschroutine ===========================
	move.l	my_Bitmap+bm_planes(A5),a1
	lea	gitterbuff(A5),a0
	moveq	#0,d0
	move.b	my_Bitmap+bm_depth(A5),d0
	subq.w	#1,d0
	moveq	#32,d1
.clear
	rept	an_zeilen/2			;ein Befehl lscht 1 Zeile
	movem.l	(a0)+,d2-d7/a2-a3
	movem.l	d2-d7/a2-a3,(a1)
	add.l	d1,a1
	endr
	dbf	d0,.clear

	movem.l	(Sp)+,d0-a6
	rts
Analyze1
;=============== Kanle auswerten ============================================
	ifne	flacker
	move.w	#$0,$dff180
	endc

	addq.w	#1,dowait(A5)
	move.w	dowait(A5),d0
	cmp.w	slowid(A5),d0
	bne.s	.no3
	clr.w	dowait(A5)
.no3


	lea	AN_Struct(a5),a4;Analyzer Struktur
	moveq	#-1,d2				;Alle Kanle
	move.w	ups_flags(a4),d1
	and.w	#UPSB_Dmacon,d1			;Flag ob Kanle an/aus ?
	beq.s	.nodmacon
	move.w	UPS_Dmacon(a4),d2	;Ja,ranholen
.nodmacon

	lea	permerk(a5),a3	;SamplePeriod merken und Spielzeit der Samples
				;in 1/50 Sekunden
Scope1:
	btst	#0,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,A1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a1
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4

;Anzahl der Bytes,die in 1/50 Sekunde vom DMA gelesen werden
;Bytes = 74074/Sampleperiod [ (1/(2.79*10-7)*50)/Sampleperiod ]
;Abwandlung : statt 74074: 65535

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	lsr.l	#1,d0
	divu	(a3),d0		;durch Sampleperiod
	and.l	#$ffff,d0
	lsl.l	#1,d0
	cmp.l	d4,d0		;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a1
	subq.w	#1,2(a3)
	clr.w	(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.divu
	moveq	#0,d0
	clr.w	2(a3)
	bra.s	.cbm_ok
.divu
	divu	d4,d0
	swap	d0
	clr.w	2(a3)
	and.l	#$ffff,d0
.cbm_ok
	add.l	d0,a1
	sub.l	d0,d4
	addq.w	#1,2(a3)
.no
	addq.l	#4,a3
	lea	AN_Struct+UPS_Modulo*3(a5),a4 ;Analyzer Struktur 4.Stimme
Scope2:
	btst	#3,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,a2
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a2
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	lsr.l	#1,d0
	divu	(a3),d0		;durch Sampleperiod
	and.l	#$ffff,d0
	lsl.l	#1,d0
	cmp.l	d4,d0		;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a1
	subq.w	#1,2(a3)
	clr.w	(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.divu
	moveq	#0,d0
	clr.w	2(a3)
	bra.s	.cbm_ok
.divu
	divu	d4,d0
	swap	d0
	clr.w	2(a3)
	and.l	#$ffff,d0
.cbm_ok
	add.l	d0,a2
	sub.l	d0,d4
	addq.w	#1,2(a3)
.no
	moveq	#0,d3
	move.w	dowait(A5),d0
	cmp.w	#1,d0
	bne.s	.noset
	bsr	clear
	bsr	copybitmap
	bsr	intowindow
.noset
	addq.l	#4,a3
Scope3:
	lea	AN_Struct+UPS_Modulo(a5),a4 ;Analyzer Struktur 2.Stimme
	btst	#1,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,A1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a1
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4
	
	move.w	2(a3),d0
	swap	d0		;=d0*65535
	lsr.l	#1,d0
	divu	(a3),d0		;durch Sampleperiod
	and.l	#$ffff,d0
	lsl.l	#1,d0
	cmp.l	d4,d0		;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a1
	subq.w	#1,2(a3)
	clr.w	(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.divu
	moveq	#0,d0
	clr.w	2(a3)
	bra.s	.cbm_ok
.divu
	divu	d4,d0
	swap	d0
	clr.w	2(a3)
	and.l	#$ffff,d0
.cbm_ok
	add.w	d0,a1
	addq.w	#1,2(a3)
.no
	addq.l	#4,a3

	lea	AN_Struct+UPS_Modulo*2(a5),a4 ;Analyzer Struktur 3.Stimme
Scope4:
	btst	#2,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,a2
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a2
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	lsr.l	#1,d0
	divu	(a3),d0		;durch Sampleperiod
	and.l	#$ffff,d0
	lsl.l	#1,d0
	cmp.l	d4,d0		;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a1
	subq.w	#1,2(a3)
	clr.w	(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.divu
	moveq	#0,d0
	clr.w	2(a3)
	bra.s	.cbm_ok
.divu
	divu	d4,d0
	swap	d0
	clr.w	2(a3)
	and.l	#$ffff,d0
.cbm_ok
	add.l	d0,a2
	addq.w	#1,2(a3)
.no
	move.w	dowait(A5),d0
	bne.s	hierrts
	bsr	clear
	bsr	copybitmap
; ========= In das Window (dessen Rastport) kopieren =====================
; ============== ZielPosition X2 in D2 bergeben =========================
intowindow2
	movem.l	d0-a6,-(sp)
	move.w	offx(A5),d2
	add.w	#an_num*8/2+24+20-3,d2	;X2->Position im Fenster
	move.w	myhoehe1(a5),d3		;Y2
	add.w	#6+5,d3
	bra	intowin2
intowindow
	movem.l	d0-a6,-(sp)
	move.w	offx(a5),d2
	add.w	#17,d2			;X2->Position im Fenster
	move.w	myhoehe1(a5),d3		;Y2
	add.w	#6+5,d3
Intowin2
	move.l	grafsave(a5),a6
	move.l	winhandle(a5),a1
	move.l	wd_rport(a1),a1		;Rastport (Ziel)

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	#an_num/2*8,d4		;Breite
	move.w	#an_zeilen,d5		;Hhe	
		
	move.b	#$c0,d6		;Miniterm

	ifne	flacker
	move.w	#$0f,$dff180
	endc
	jsr	_LVObltbitmaprastport(a6)
	movem.l	(sp)+,d0-a6
	ifne	flacker
	move.w	#$f0f,$dff180
	endc
hierrts
	rts
;============ Kopieren des Samples in die Bitmap =======================
copybitmap
	movem.l	d0-a6,-(sp)
	
	lea.l	my_bitmap(a5),a0
	move.w	(a0),d0			;bm_bytesperrow

	move.w	#an_num*2-1,d7		;Schleifenzhler Balkenanzahl
	moveq	#0,d6
	move.w	#an_zeilen/2*an_num/2,d3
	moveq	#7,d5
	lea	my_bitmap+bm_planes(a5),a4
.mainloop
	move.l	d7,-(sp)

	move.b	(a1)+,d6
	ext.w	d6
	move.b	(a2)+,d4
	ext.w	d4
	add.w	d4,d6

	move.b	(a1),d2
	ext.w	d2
	move.b	(a2),d4
	ext.w	d4
	add.w	d4,d2

	move.w	d6,d7
	sub.w	d2,d7
	add.w	d6,d6
	and.w	#~31,d6
	add.w	d3,d6

	moveq	#an_num/2,d0
	tst.w	d7
	bge.s	.oks2
	neg.w	d7
	moveq	#-1*[an_num/2],d0
.oks2
	moveq	#0,d2
	lsr.w	#4,d7
	addx.w	d7,d2
.points1
	move.l	A4,a0
	move.l	mypen2(a5),d1		;hier pen2
	moveq	#0,d4
	move.b	my_bitmap+bm_depth(a5),d4
	subq.w	#1,d4
.set12
	move.l	(a0)+,a3
	bclr	d5,(A3,d6.w)
	lsr.w	#1,d1
	bcc.s	.noset12
	bset	d5,(a3,d6.w)
.noset12
	dbf	d4,.set12

	sub.w	d0,d6
	dbf	d7,.points1

	subq.w	#1,d5
	bge.s	.nozw3
	moveq	#7,d5
	addq.w	#1,d3
.nozw3
	add.w	d0,d6
.points2
	move.l	A4,a0
	move.l	mypen2(a5),d1		;hier pen2
	moveq	#0,d4
	move.b	my_bitmap+bm_depth(a5),d4
	subq.w	#1,d4
.set12W
	move.l	(a0)+,a3
	bclr	d5,(A3,d6.w)
	lsr.w	#1,d1
	bcc.s	.noset12W
	bset	d5,(a3,d6.w)
.noset12W
	dbf	d4,.set12W

	sub.w	d0,d6
	dbf	d2,.points2

	subq.w	#1,d5
	bge.s	.nozw4
	moveq	#7,d5
	addq.w	#1,d3
.nozw4
.no
	move.l	(sp)+,d7
	dbf	d7,.mainloop

	movem.l	(sp)+,d0-a6
	rts
*******************************************************************
*    berprfen,ob Analyzerstruktur schon bergeben wurde und     *
* und ob der aktuelle Player Lautstrke und Sampleperiod bergibt *
*******************************************************************
AN_test
	move.l	winhandle(a5),d0	;Window berhaupt offen ?
	beq.w	.noanalyze
	move.l	d0,a0

	move.w	myhoehe1(a5),d0
	cmp.w	wd_height(a0),d0	;Window im ZIP-Modus ?
	beq.w	.noanalyze

	move.l	an_structadr(a5),d0	;Strukturadresse vorhanden ?
	beq.w	.Noanalyze
	move.l	d0,a0

	tst.w	UPS_enabled(a0)		;Zugriff erlaubt ?
	bne.w	.noanalyze

	move.w	UPS_Flags(a0),d0	;alle bentigten Werte bergeben ?
	and.w	#UPSB_Per!UPSB_len!UPSB_adr,d0
	cmp.w	#UPSB_Per!UPSB_len!UPSB_adr,d0
	bne.s	.noanalyze

	lea.l	an_struct(a5),a1

	move.w	UPS_Flags(a0),UPS_Flags(a1)
	move.w	UPS_Dmacon(a0),UPS_Dmacon(a1)
	move.w	UPS_Voice1per(a0),UPS_Voice1per(a1)
	move.w	UPS_Voice2per(a0),UPS_Voice2per(a1)
	move.w	UPS_Voice3per(a0),UPS_Voice3per(a1)
	move.w	UPS_Voice4per(a0),UPS_Voice4per(a1)
	move.w	UPS_Voice1len(a0),UPS_Voice1len(a1)
	move.w	UPS_Voice2len(a0),UPS_Voice2len(a1)
	move.w	UPS_Voice3len(a0),UPS_Voice3len(a1)
	move.w	UPS_Voice4len(a0),UPS_Voice4len(a1)
	move.l	UPS_Voice1Adr(a0),UPS_Voice1adr(a1)
	move.l	UPS_Voice2Adr(a0),UPS_Voice2adr(a1)
	move.l	UPS_Voice3Adr(a0),UPS_Voice3adr(a1)
	move.l	UPS_Voice4Adr(a0),UPS_Voice4adr(a1)
	move.w	UPS_Voice1Repeat(a0),UPS_Voice1repeat(a1)
	move.w	UPS_Voice2Repeat(a0),UPS_Voice2repeat(a1)
	move.w	UPS_Voice3Repeat(a0),UPS_Voice3repeat(a1)
	move.w	UPS_Voice4Repeat(a0),UPS_Voice4repeat(a1)

	bra	Analyze1
.noanalyze
	rts
*************************************************************
*           Nachrichtenbearbeitung                          *
*************************************************************
HandleActions
	bra.s	.ma
.ma2
	btst	d3,d0
	beq.s	.ma
	bsr.w	an_test
.ma
	move.l	4,a6
	move.l	port(a5),d0
	beq.s	.nowinport
	move.l	d0,a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.msg
.nowinport
	move.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.AN_msg
	
	moveq	#0,d0

	move.l	4,a6
	move.l	port(a5),d2
	beq.s	.maul
	move.l	d2,a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
.maul
	move.l	msgport(a5),a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
	move.l	mysignal(a5),d3
	tst.l	an_structadr(a5)
	beq.s	.nowaitsig
	bset	d3,d0
.nowaitsig
	jsr	_LVOwait(a6)
	bra	.ma2
.AN_msg
	move.l	d0,a1

	move.l	MSGPort(a5),UM_Userport(a1)
	lea	begin(pc),a2

	ifne	debug
	move.w	um_usernr(a1),saveusernr(A5)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc
	move.l	mytask(a5),UM_TaskAdr(a1)
	move.l	mysignal(a5),d1
	move.l	d1,UM_Signal(a1)

	move.w	UM_class(a1),d3		<-
	move.l	UM_Type(a1),d7
	move.w	UM_Signal(a1),d5 	<-
	move.l	UM_structadr(a1),d6 	<-

	clr.w	UM_class(A1)

	cmp.w	#USclass_exit,d3
	bne.s	.noexi
	clr.l	UM_Signal(a1)
	clr.l	UM_Taskadr(a1)
.noexi
	cmp.w	#USclass_getconfig,d3		;when this command comes,set
						;the actual preferences into
						;the Eagleuser-Structure
						;(EUS_-structure at the be-
						;ginning of the program)
	bne	.noprev

	moveq	#0,d0
	move.l	winhandle(A5),d1		;Window
	beq.s	.prnowin			;no Window opened,no change
						;of preferences
	or.w	#eusb_openwin,d0		;set Flag: window is open

	move.l	d1,a0				;Window
	move.w	myhoehe1(a5),d1			;Window in ZIP-Mode ?
	cmp.w	wd_height(a0),d1		;compare real height with
						;calculated height
	bne.s	.getxy				;ino ZIP-Mode
	or.w	#eusb_zipwin,d0			;set FLAG: ZIP-Mode
	bra.s	.prnowin			;If ZIP-Mode,don`t set
						;new x and y - Position
.getxy
	move.w	wd_leftedge(a0),eus_winx(a2)	;Save Windowpostion
	move.w	wd_topedge(a0),eus_winy(a2)
.prnowin
	move.w	d0,eus_flags(a2)		;Save Flags
.noprev
	cmp.w	#USclass_Show,d3
	beq.s	.win
	cmp.w	#USclass_Activate,d3
	bne.w	.nowin
.win
	move.l	Begin+EUS_EPBase(pc),a0
	move.l	EPG_SomePrefs(a0),d0
	btst	#EGPRF_Iconify,d0
	bne.w	.noShow

	push	all
	bsr	Openwin
	pop	all
	tst.l	Winhandle(A5)
	beq.s	.noshow
	move	d3,UM_Class(a1)
.noshow
.nowin
	cmp	#USclass_Hide,d3
	beq.s	.closewin
	cmp.w	#USclass_DeActivate,d3
	bne.s	.noclosewin
.closewin
	push	all
	bsr	Closewin
	pop	all
.noclosewin

	move.l	d6,an_structadr(a5)	;Analyzerstrukturadresse merken
	bne.s	.noclr
	tst.l	winhandle(a5)
	beq.s	.noclr

	push	all
		bsr	clear
		bsr	intowindow
		bsr	intowindow2
	pop	all
.noclr


	move.l	mn_replyport(a1),d0
	cmp.l	MSGport(a5),d0		 ;eine von uns abgeschickte Message ?
	beq.s	.noreply
	jsr	_LVOreplymsg(a6)
.noreply
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	beq	.mess

	bsr	freemsg
.mess

;	lea	begin(pc),a0
;	move.l	eus_epbase(a0),a0
;	move.b	EPG_Wordreserved7(a0),d0
;	beq	.endme

	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq.w	.ma			;adresse bekommen
	cmp.w	#USclass_zipwin,d3
	bne.s	.nozip
.setzip

	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.w	.ma		;Window schon klein
.zip
	move.w	d0,-(sp)

	move.l	intsave(a5),a6
	jsr	_LVOzipwindow(a6)

	move.w	(sp)+,d4

	move.l	winhandle(a5),a2
.Zipwait:
	moveq	#1,d1
	move.l	_Dos(a5),a6
	jsr	_LVODelay(a6)

	cmp.w	wd_height(a2),d4
	beq.s	.zipwait

	bra	.ma
.nozip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nounzip

.clearzip
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.s	.zip
	bra	.ma
.nounzip
	cmp.w	#USclass_exit,d3
	beq	.exit

	cmp.w	#USclass_NewConfig,d3	;is there a new config
	bne.w	.nonewcon		;no

	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.w	eus_flags(a0),d0	;get Flags
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin			;open it
	bra.s	.weio
.nowino
	bsr	closewin		;else close it
.weio
	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.l	winhandle(a5),d0	;windowaddress
	beq.s	.nothingtomove		;no Window , no movement

	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;new X-position
	move.w	d0,d1			;save
	blt.s	.oldx			;less than 0 -> stop

	add.w	wd_width(a1),d1		;new position + Window-width
	cmp.w	sc_width(a2),d1		;bigger than Screenwidth ?
	bhi.s	.oldx			;then old X-position (Delta = 0)

	sub.w	wd_leftedge(a1),d0	;new - old X-position = Delta X
	bra.s	.gety
.oldx
	moveq	#0,d0			;Delta X = 0
.gety
	move.w	eus_winy(a0),d1		;new Y-position

	move.w	d1,d2			;save
	blt.s	.oldy			;less than 0 -> stop and take old

	add.w	wd_height(a1),d2	;new position + window-height
	cmp.w	sc_height(a2),d2	;bigger than Screenheight ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;new - old Y-position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1

.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove
	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	btst	#eusf_zipwin,d0		;Zipwindow ?
	bne	.setzip			;yes
	bra	.clearzip		;no
.nonewcon
	bra	.ma
.noeagle
	bra	.ma
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<-
	move.l	im_Iaddress(a1),d6 	<-
	jsr	_LVOreplymsg(a6)

	cmp.l	#refreshwindow,d7
	bne.s	.testgads
	bsr	refresh
	bra	.ma
.testgads
	cmp.l	#CloseWindow,d7
	bne	.noclo
.Closewinny
	if	Test=0

	bsr	closewin
	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.w	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	mysignal(a5),d5
	move.w	#USclass_DeActivate,d6
	bsr	sendmess
	bra	.ma
	else
	bra	.endme
	endc
.noclo
	cmp.l	#menupick,d7
	bne.s	.nomenu
	move.w	d5,d0
	cmp.w	#menunull,d0
	beq	.ma
	and.w	#$7e0,d0
	tst.w	d0
	bne.s	.noslo

	move.l	intsave(A5),a6
	move.l	menuadr(a5),a0
	jsr	_LVOitemaddress(a6)
	tst.l	d0
	beq	.ma
	move.l	d0,a1

	moveq	#2,d1
	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	beq.s	.nome3
	moveq	#3,d1
.nome3
	move.w	d1,slowid(a5)
	move.b	d1,begin+eus_special
	bra	.ma
.noslo
	cmp.w	#64,d0		;3. Item ? (Hide)
	beq	.Closewinny
	cmp.w	#96,d0
	beq	.endme
	lea	Aboutmessage(pc),a0
	bsr	Merror
.nomenu
	cmp.l	#Vanillakey,d7
	bne	.ma
	cmp.b	#`1`,d5
	bne.w	.nostart
.nostart
	bra	.ma
.endme
	moveq	#0,d7
	RTS
.exit	moveq	#-1,d7
	rts
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0-a6,-(sp)
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	lea	my_easygadget(pc),a0
	move.l	a0,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	movem.l	(sp)+,d0-a6	
	rts
;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************

int:	dc.b	`intuition.library`,0
gad:	dc.b	`gadtools.library`,0
graf:	dc.b	`graphics.library`,0
dos:	dc.b	`dos.library`,0
portname:	dc.b	`EAGLEPLAYERPORT`,0
Project0STitle: dc.b	'Stereoscope (Eagleplayer),  DEFECT Softworks',0

MyWinName:	dc.b	`Stereoscope`,0
my_easygadget:	dc.b	`   OK   `,0
my_easytitle:	dc.b	`Stereoscope Message`,0
my_easygadget2:	dc.b	` Retry | Cancel `,0
MyAnalyzername:	dc.b	`EStereoscopeColor.1`,0
MyUsername:	dc.b	`StereoscopeColor`,0

Aboutmessage:	dc.b	`       EaglePlayer Stereoscope Color `
		ver
		dc.b	$0a
		dc.b	`        1993-1996 Henryk "BUGGS" Richter`,$0a
		dc.b	`for use in 1:1 Pixel Modes like 640*480 or such,`,10
		dc.b	"don't complain about high cpu usage, in cunky",10
		dc.b	`it wouldn't be faster (at least on my Cybervision)`,0
NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0

NoPenMessage	dc.b	`Cannot allocate free pen !`,10
		dc.b	`Please open a screen with more colors !`,0

Confile:	dc.b	`CON:10/10/250/40/StereoscopeColor`,0
Conout:	dc.b	`Needs Amiga OS3.0 or higher to run`,0
Conlen = *-Conout
Mylabel1:	dc.b	`Project`,0
Mylabel2:	dc.b	`About`,0
MyLabel3:	dc.b	`Quit`,0
myhide		dc.b	`Hide`,0
Mylabel21:	dc.b	`A`,0
myhide1		dc.b	`H`,0
MyLabel31:	dc.b	`Q`,0
MyLabel4	dc.b	`Slow Mode`,0

mybuggsname	dc.b	`Buggs of DEFECT`,0;,0
myinfo 	dc.b	`shows the samples of the left and right channel separated`,0
	even
patt1	dc.w	%1010101010101010
	dc.w	%0101010101010101
patt2	dc.w	0,0

************ Leertabellen (spter im BSS-Hunk) ***********************
		section	1,BSS
datas:
slowid		rs.w	1
memadr		rs.l	1
dowait		rs.w	1
mycmap		rs.l	1
mypen1		rs.l	1
mypen2		rs.l	1
intsave:	rs.l	1
gadsave:	rs.l	1
grafsave:	rs.l	1
_dos		rs.l	1
WinHandle:	rs.l	1
Port:		rs.l	1
		rs.l	1
MSGPort:	rs.l	1
		rs.l	1
Handle:		rs.l	1
Menuadr:	rs.l	1
Mysignal	rs.l	1
Mytask		rs.l	1
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
fontatt:	rs.l	1	;Fontattr Strukturadresse (entweder die des
				;Screens oder die eigene,wenn Screenfont zu
				;gro)
vi:		rs.l	1	;Visualinfo

mytags:		rs.l	20*2
myzoom:		rs.w	3
myhoehe2:	rs.w	1
myhoehe1:	rs.w	1
winwidth:	rs.w	1

MY_Easystruct:	rs.l	1	;EASY-Request
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1
MY_Bitmap:	rs.b	8
		rs.l	8
lastrow:	rs.l	1
Mymenus:	rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.w	1
Nulls:		rs.w	an_num/4*an_zeilen
Permerk:	rs.l	4
Fulls:		rs.w	an_zeilen*an_num/4
Gitter:		rs.w	an_zeilen*an_num/4
NotGitter:	rs.w	an_zeilen*an_num/4
Gitterbuff	rs.w	an_zeilen*an_num/4*8

AN_Structadr:	rs.l	1
offx		rs.w	1
AN_Struct:	rs.b	UPS_sizeof
Messagesent:	rs.b	1
		rs.b	1	;Frei

	ifne	debug
saveusernr	rs.w	1
	endc
DatasLen:	rs.w	0
		ds.b	DatasLen
	end
