*****************************************************************************
**                                                                         **
** Samplesaver: AIFF                                                       **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


*-----------------------------------------------------------------------------*
*			Samplesaver for AIFF-Samples			      *
*-----------------------------------------------------------------------------*

			incdir	include:
			include	exec/exec_lib.i
			include	dos/dos.i
			include	dos/dos_lib.i
			include	misc/eagleplayersamplesaver.i
			include	misc/BuggsMacros.i


 structure	AIFF_COMM,0
	ulong	COMM_ID
	ulong	COMM_Size
	word	COMM_numChannels
	ulong	COMM_numSampleFrames		;wieviele Sampleeinheiten enthlt das AIFF File
						;Sampleeinheit = alle Kanle, die zu einem
						;Zeitpunkt abgespielt werden
	word	COMM_sampleSize			;wieviele Bits enthlt das Sample
	double	COMM_sampleRate			;Abspielrate

	Label	COMM_Sizeof

			
	SAMPLESAVERHEADER	TAGS8

	dc.b	"AIFF 8Bit /16 Bit - Mono Samplesaver V1.0",10
	dc.b	"done by Buggs/DFT 02.04.97",0
	even

AllMore:	dc.l	SS_Version,1<<16!0
		dc.l	SS_Creator,Creator
		dc.l	SS_Flags,SSF_FrequencyVariable
		dc.l	0

Tags8:		dc.l	Tag_More,AllMore
		dc.l	SS_Formatname,Formatname8
		dc.l	SS_RAWFlags,USIB_8Bit
		dc.l	SS_DefFreqPtr,FreqPtr8
		dc.l	SS_DescriptionLNr,43
		dc.l	SS_SaveSample,SaveSample8

		dc.l	SS_NextSampleSaver,Tags16
		dc.l	0

Tags16:		dc.l	Tag_More,AllMore
		dc.l	SS_Formatname,Formatname16
		dc.l	SS_RAWFlags,USIB_16Bit
		dc.l	SS_DefFreqPtr,FreqPtr16
		dc.l	SS_SaveSample,SaveSample16

		dc.l	0

FreqPtr8:	dc.l	22000
FreqPtr16:	dc.l	22000

Creator:	dc.b	"Apple/Amiga AIFF Samples, saver by DEFECT",0

Formatname8:	dc.b	"AIFF 8Bit-Mono",0
Formatname16:	dc.b	"AIFF 16Bit-Mono ",0

dos		dc.b	`dos.library`,0
		even

*-----------------------------------------------------------------------------*
* Input: a0=Adr der EP_SampleTabelle
*	 a1=Pfad
*	 a2=Jump to Saveroutine
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
SaveSample16:	moveq	#1,d5
		bra.s	SaveSample

SaveSample8:	moveq	#0,d5

SaveSample:	move.l	a1,a2

		moveq	#EPR_ErrorInArguments,d7
		move.l	a0,a4
		moveq	#0,d6
		move.l	EPS_Adr(a4),d0
		beq.w	.Return
		move.l	d0,a3

		move.w	EPS_Type(a4),d0		;nur RAW als Input
		bne.w	.Return			;

		move.l	EPS_Length(a4),d4
		beq.w	.Return

		move.l	FreqPtr8(pc),d1
		move	d1,PlayRate		;0....65535, mehr geht im Moment nicht

		move.l	d4,RawSize
		move.l	d4,d1
		move.l	d4,d0
		add.l	#HeaderEnd-AIFFHeader-8,d0
		move.l	d0,OverAllSize

		moveq	#8,d2
		tst.b	d5
		beq	.Sample8
		lsr.l	#1,d1
		moveq	#16,d2
.Sample8
		move	d2,SampleType
		move.l	d1,SampleFrames

	*------------------- File ffnen und abspeichern ----------------*
		move.l	4.w,a6
		lea	dos(pc),a1
		moveq	#33,d0
		jsr	_LVOopenlibrary(A6)	;Open DOS
		tst.l	d0
		beq	.error
		move.l	d0,a6

		move.l	a2,d1
		move.l	#1006,d2		;MODE_NEWFILE
		jsr	_LVOopen(A6)
		move.l	d0,d6
		beq.s	.nolock

		move.l	d0,d1				;Handle
		lea	AIFFHeader(pc),a1
		move.l	a1,d2				;Adr
		move.l	#HeaderEnd-AIFFHeader,d3	;len
		jsr	_LVOwrite(a6)
		tst.l	d0
		bmi.s	.fail

		move.l	d6,d1
		move.l	a3,d2
		move.l	d4,d3
		jsr	_LVOWrite(a6)
		tst.l	d0
		bmi.s	.fail

		bsr.s	.fail

		moveq	#0,d7
.Return:	move.l	d7,d0
		tst.l	d0
		rts
.fail
		move.l	d6,d1
		jsr	_LVOclose(a6)
.nolock
		move.l	a6,a1
		move.l	4.w,a6
		jsr	_LVOcloselibrary(A6)

.error		moveq	#EPR_SaveError,d0
		rts

AIFFHeader:
		dc.l	`FORM`
OverallSize:	dc.l	0
		dc.l	`AIFF`

		dc.l	`COMM`
		dc.l	$12
		dc.w	1
SampleFrames:	dc.l	0			;Length oder Length/2
SampleType:	dc.w	0			;8/16

		dc.w	$400e			;Abspielrate im FFP Format, Exponent hingeschustert,
PlayRate:	dc.w	0			;so da Rate im Klartext eingetragen werden kann
		dc.l	0
		dc.w	0

		dc.l	`ANNO`
		dc.l	EndText-Text
Text
		dc.b	`written by Eagleplayer Samplesaver 1997 Defect Softworks`,0,0,0
EndText

		dc.l	`SSND`
RawSize		dc.l	0
HeaderEnd:
