*****************************************************************************
**                                                                         **
** Engine: Samplesaver                                                     **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


*---------------------------------------------------------------------------*
*				Samplesaver V1.0			    *
*---------------------------------------------------------------------------*
Executable	= 1
Test		= 0
Debugger	= 0
BackPicture	= 1

ver		macro
		dc.b	"1.01"
		endm
StructVer	macro			!!! Im Catalog auch ndern !!!
		dc.w	1,01
		endm
date		macro
		dc.b	"29-Sep-97"
		endm
StructDate	macro
		dc.b	29,09
		dc.w	1997
		endm

my_Redrawlist	macro
		dc.l	\1
		dc.w	\2
		ENDM
ListviewBorder		= 4		*Hhe des ListviewRandes (oben+unten)

	incdir	include:
	include	exec/exec_lib.i
	include	dos/dos_lib.i
	include	dos/dos.i
	include	dos/exall.i
	include	exec/libraries.i
	include	exec/interrupts.i
	include	exec/lists.i
	include	libraries/diskfont_lib.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	misc/BuggsMacros.i
	include	misc/Eagleplayer.i
	include	misc/Eagleplayersamplesaver.i
	include	misc/Eagleplayerengine.i
	include	libraries/asl_lib.i
	include	libraries/asl.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	libraries/locale_lib.i

	include "intuition/icclass.i"
	include "intuition/classes.i"
        include "intuition/classusr.i"
        include "intuition/imageclass.i"
	include	libraries/utility_lib.i

	include	libraries/datatypes_lib.i
	include	datatypes/datatypes.i
	include	datatypes/pictureclass.i

	include	libraries/reqtools.i
	include	libraries/reqtools_lib.i

;===========================================================================
;		Definitionen & Vereinbarungen 
;===========================================================================
Defheight		= 200	;def. Innerheight
Defwidth		= 350	;def. Innerwidth
ZoomWidth		= 180
StringGadgetOffset	= 8		* Zur Fonthhe fr Stringgadgetheight
GadgetAnz		= 7
TitlePufferSize		= 200
PathPufferSize		= MaxDirectorynameSize+MaxFilenameSize
TextPufferSize		= PathPufferSize+200

MinFreq			= 1000
MaxFreq			= 58000
FreqStep		= 10

BevelHohe		= 1
BevelBreite		= 2
MinListViewWidth	= 40		*Min Width der Listviews
MinGadgetWidth		= 15		*Min. Breite von Gadgets
MinTextGadgetXOffset	= 2		*Abstand des Textes im Gadget vom
					*Bevelrand
MinTextGadgetYOffset	= 2		*Abstand des Textes im Gadget vom
					*Bevelrand
GadgetXAbstand		= 4		*Abstand der Gadgets untereinander
					*sowie vom linken Rand
GadgetYAbstand		= 4		*Abstand der Gadgets untereinander
					*sowie vom oberen & unteren Rand
AboveAbstand		= 7		*Abstand, wenn Text berm ListView
*MinWinWidth		= 50
*MinWinHeight		= 40


		rsreset
			rs.b	1
EPENr_FirstNummer	rs.b	0
EPENr_FormatList	rs.b	1
EPENr_Samplelist	rs.b	1
EPENr_Slider		rs.b	1
EPENr_TextGadget	rs.b	1
EPENr_Play		rs.b	1
EPENr_Infolist		rs.b	1
EPENr_Eigenlist		rs.b	1
EPENr_About		rs.b	1
EPENr_Quit		rs.b	1
EPENr_Hide		rs.b	1
EPENr_SelectBackPic	rs.b	1
EPENr_BackPic		rs.b	1
EPENr_ViewUp		rs.b	1	*Selectbalken im Listview setzen
EPENr_ViewDown		rs.b	1
EPENr_ViewPageUp	rs.b	1
EPENr_ViewPageDown	rs.b	1
EPENr_ViewTop		rs.b	1
EPENr_ViewBotom		rs.b	1
EPENr_ViewLeft		rs.b	1	*Selectbalken im Listview setzen
EPENr_ViewRight		rs.b	1
EPENr_ViewPageLeft	rs.b	1
EPENr_ViewPageRight	rs.b	1
EPENr_ViewLeftMarge	rs.b	1
EPENr_ViewRightMarge	rs.b	1
EPENr_NimmSaver		rs.b	1
EPENr_LoadConfig	rs.b	1
EPENr_SaveConfig	rs.b	1
EPENr_ToggleListview	rs.b	1
EPENr_TogglePlayMode	rs.b	1
EPENr_Stop		rs.b	1
EPENr_LastNr		rs.b	0


			rsreset
			rs.b	1
LENr_WindowTitle	rs.b	1
LENr_Project		rs.b	1
LENr_Settings		rs.b	1
LENr_About		rs.b	1
LENr_Hide		rs.b	1
LENr_Quit		rs.b	1
LENr_BackPic		rs.b	1
LENr_SelectBackPic	rs.b	1
LENr_SaveConfig		rs.b	1
LENr_AboutText		rs.b	1
LENr_Ok			rs.b	1
LENr_RequestTitle	rs.b	1
LENr_EPNotFound		rs.b	1
LENr_SoundDatei		rs.b	1
LENr_Frequence		rs.b	1
LENr_Available		rs.b	1
LENr_Von		rs.b	1
LENr_Samplelist		rs.b	1
LENr_Play		rs.b	1
LENr_PlayMenu		rs.b	1
LENr_PlayKey		rs.b	1
LENr_Stop		rs.b	1		;nur Menu
LENr_StopKey		rs.b	1
LENr_Informationen	rs.b	1
LENr_Eigenschaften	rs.b	1
LENr_Version		rs.b	1
LENr_Length		rs.b	1
LENr_Type		rs.b	1
LENr_Aufnahme		rs.b	1
LENr_RAW		rs.b	1
LENr_IFF		rs.b	1
LENr_SynthFM		rs.b	1
LENr_SynthAM		rs.b	1
LENr_Unknown		rs.b	1
LENr_8Bit		rs.b	1
LENr_16Bit		rs.b	1
LENr_Interleaved	rs.b	1
LENr_Intel		rs.b	1
LENr_Unsigned		rs.b	1
LENr_Bytes		rs.b	1
LENr_Unknownname	rs.b	1
LENr_SomeSamplesfailures rs.b	1
LENr_RAW8Bit		rs.b	1
LENr_RAW16BitUI		rs.b	1
LENr_LastExternal	rs.b	0


		rsreset
GadgetMerkPuffer	rs.l	GadgetAnz+2
MyTags			rs.l	20*2
LocalePuffer		rs.w	LENr_LastExternal
TitlePuffer		rs.b	TitlePufferSize
TextPuffer		rs.b	TextPufferSize
FrequencePuffer		rs.b	10
TextRequestArgs		rs.l	3
BufNewGad		rs.b	gng_sizeof	*Buffer fr Gadgetcreieren
MyFont			rs.l	2
MY_Easystruct		rs.l	5	;EASY-Request
Formatlist		rs.b	lh_size
Infolist		rs.b	lh_size
Eigenlist		rs.b	lh_size
Samplelist		rs.b	lh_size
*FirstSampleSaver	rs.l	1
CurrentSeconds		rs.l	1
CurrentMicros		rs.l	1
SampleInfoLocked	rs.l	1
SA_StartSeconds		rs.l	1
SA_StartMicros		rs.l	1
FR_StartSeconds		rs.l	1
FR_StartMicros		rs.l	1
MyTaskAdr		rs.l	1
GadgetListadr		rs.l	1
MenuAdr			rs.l	1
VisualInfo		rs.l	1
MyPubScreen		rs.l	1
WinHandle		rs.l	1
WindowPort		rs.l	1
MyRastPort		rs.l	1
OldMenuAdr		rs.l	1
MyCatalog		rs.l	1
SelectedEntry		rs.l	1
SelectedSampleEntry	rs.l	1
*MyMessage		rs.b	UM_SizeOf
*ENA_Args1		rs.b	ENA_String+34
*ENA_Args2		rs.b	ENA_String+34
SampleStructure		rs.b	EPS_SizeOF
MerkUserNr		rs.w	1
MsgUnterwegs		rs.l	1
ExitNow			rs.w	1
Qualifier		rs.w	1
MaxEntries		rs.l	1
MaxSampleEntries	rs.l	1
MsgPort			rs.l	1
*UPrg_Struct		rs.l	1
Signal			rs.l	1
SignalBits		rs.l	1
OldDirLock		rs.l	1
Font			rs.l	1
FontX			rs.w	1
FontY			rs.w	1
OffX			rs.w	1
OffY			rs.w	1
WinPosX			rs.w	1
WinPosY			rs.w	1
WinHeight		rs.w	1
WinWidth		rs.w	1
TmpHeight		rs.w	1
TmpWidth		rs.w	1
ZoomPosX		rs.w	1
ZoomPosY		rs.w	1
InfoWidth		rs.w	1
InfoWidth2		rs.w	1
SliderWidth		rs.w	1
IntBase			rs.l	1
GFXBase			rs.l	1
DosBase			rs.l	1
GadBase			rs.l	1
LocaleBase		rs.l	1
MyReqToolsBase		rs.l	1
RealNumGadgets		rs.l	1
WindowDisabled		rs.w	1
Kick3On			rs.w	1
Formatsloaded		rs.w	1
NoWait			rs.w	1
SomeSamplesFailures	rs.w	1
Result			rs.l	1		*Result bei GetGadgetattr

			*-- BackPic --*
;----------------------- Daten fr Datatypes-Bild ----------------------------------------
DatatypesBase		rs.l	1
DT_PicObject		rs.l	1
DT_MyBitMapheader	rs.l	1
DT_MyBitMap		rs.l	1
DT_Breit2:		rs.l	1
DT_Hoehe2:		rs.l	1
DT_XPos2:		rs.l	1
DT_YPos2:		rs.l	1
Mycmap			rs.l	1
MyPen			rs.l	1
PathPuffer		rs.b	PathPufferSize
DT_Picture		rs.b	300
ConfigDatas		rs.b	0			\  wird als eigene
DT_Picturedir		rs.b	200			 \ Prefs abgespeichert
DT_Picturename		rs.b	108			 /
Dirpuffer		rs.b	200
Filepuffer		rs.b	108			 /
PlayFrequence		rs.l	1
ConfigDatasEND		rs.b	0			/



ZoomState		rs.b	1
ListeDa			rs.b	1
InfoListeDa		rs.b	1
EigenListeDa		rs.b	1
SamplelisteDa		rs.b	1
WelchesListview		rs.b	1

PufferEnd		rs.b	0


NextMenu	EQU	1
NextItem	EQU	1<<5
NextSubItem	EQU	1<<11
NoSubMenu	EQU	$f800
SubMenu		EQU	$800

			rsreset
Menu1			rs.b	1
Menu2			rs.b	1

			rsreset
			rs.b	Menu1!NoSubMenu
MNr_Play		rs.b	NextItem
MNr_Stop		rs.b	NextItem
			rs.b	NextItem
MNr_About		rs.b	NextItem
MNr_Hide		rs.b	NextItem
			rs.b	NextItem		;Barlabel
MNr_Quit		rs.b	NextItem

			rsreset
			rs.b	Menu2!NoSubMenu
MNr_BackPic		rs.b	NextItem
MNr_SelectBackPic	rs.b	NextItem
			rs.b	NextItem		;Barlabel
MNr_SaveConfig		rs.b	NextItem





	*----------------- Einstellungen der Prefs --------------*
PFF_BackPic		EQU	2
PFB_BackPic		EQU	1<<PFF_BackPic
		

EB	macro
	if	test
	move.l	4,a6
	else
	move.l	4.w,a6
	endc
	ENDM


		STRUCTURE	MY_SaverStruct,0
		ULONG		ESS_Dummy
		STRUCT		ESS_Node,LN_Size
		ULONG		ESS_StructSize
		APTR		ESS_Segment
		APTR		ESS_Tags
		LABEL		ESS_SizeOf

		STRUCTURE	MY_SampleStruct,0
		APTR		ESA_SampleStruct
		STRUCT		ESA_Node,LN_Size
		ULONG		ESA_StructSize
		LABEL		ESA_SizeOf

		STRUCTURE	MY_ListStruct,0
		STRUCT		ML_Node,LN_Size
		ULONG		ML_Size
		LABEL		ML_Chars


;===========================================================================
	section	0,code
;===========================================================================

		if	test
Start
		bra	FirstInit
	illegal

FirstEagleInit:	lea	EaglePuffer,a5
		move.l	a5,EUS_EPBase+EUS_Structure

		lea	MyIntuiname,a1
		EB
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Intuitionbase(a5)

		lea	MyGFXname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GFXbase(a5)

		lea	MyGadToolsname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GadToolsbase(a5)

		lea	MyLocalename,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,EPG_Localebase(a5)

		lea	MyDosname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Dosbase(a5)

		lea	Sample1(pc),a4
		move.l	a4,EPG_SampleInfoStructure(a5)
		move.l	#Samplename1,EPS_SampleName(a4)
		move.l	#40000,EPS_Adr(a4)
		move.l	#4000,EPS_Length(a4)

		lea	Sample2(pc),a4
		move.l	a4,EPS_NextSample-EPS_Sizeof(a4)
		move.l	#Samplename2,EPS_SampleName(a4)
		move.l	#40000,EPS_Adr(a4)
		move.l	#4000,EPS_Length(a4)

		lea	Sample3(pc),a4
		move.l	a4,EPS_NextSample-EPS_Sizeof(a4)
		move.l	#Samplename3,EPS_SampleName(a4)
		move.l	#40000,EPS_Adr(a4)
		move.l	#4000,EPS_Length(a4)

		lea	Puffer,a5
		rts

MyIntuiname:	dc.b	"intuition.library",0
MyGFXname:	dc.b	"graphics.library",0
MyGadtoolsname:	dc.b	"gadtools.library",0
MyLocalename:	dc.b	"locale.library",0
MyDosname:	dc.b	"dos.library",0

		even
EaglePuffer	ds.b	EPG_SizeOf

Sample1		ds.b	40
Sample2		ds.b	40
Sample3		ds.b	40
Samplename1:	dc.b	"Bassdrum",0
Samplename2:	dc.b	"Hihat",0
Samplename3:	dc.b	"Snare",0
		even


		endc
*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
EUS_Structure:	bra.w	FirstInit			;EUS_Jump
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
EPBase		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	0				;EUS_TickFlags
		dc.l	USMB_NewPreference!USMB_NewSong!USMB_KillModule!USMB_NewModule!USMB_WaitPointer!USMB_Zipwin!USMB_ChangeConfig
		dc.l	MyProzessName			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	37				;EUS_Kickstart
		dc.l	EAGLEVERSION			;EUS_EPVersion
		structver				;EUS_Version,EUS_Revision
		dc.l	MyProzessName			;EUS_Username
		dc.w	200				;EUS_WinX
		dc.w	$62 14				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
EUS_Width	dc.w	DefWidth		;EUS_Special  -> InnerWidth
EUS_Height	dc.w	Defheight		;EUS_Special+2 -> InnerHeigth
		dc.l	0				;EUS_Special2
ZoomX		equ	EUS_Special2
ZoomY		equ	EUS_Special2+2
ZoomONOFF	equ	EUS_Special3
PrefsFlags	equ	EUS_Special3+2
		dc.w	0				;EUS_Special3
		if	Test!Debugger
		dc.w	PFB_BackPic			;PrefsFlags
		else
		dc.w	0				;PrefsFlags
		endc

		structdate				;EUS_Creatordate
		dc.b	0				;EUS_Prioritt
		dc.b	EUTY_Samplesaver		;EUS_Type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6
		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	`$VER: Eagleplayer-Samplesaver V`
		ver
		dc.b	` (`
		date
		dc.b	`)`,0
		even

TagListe:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Samplesaver
		dc.l	0


*----------------------------------------------------------------------------*
FirstInit:	lea	Puffer,a5		;BSS lschen
		EB
		cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
		blo	Exit			;nein,raus
		bsr	ClrPuffer

		EB
		cmp.w	#39,Lib_Version(a6)
		blo.s	.NoKick3
		not.w	Kick3On(a5)
.NoKick3:	move.l	EUS_Structure+EUS_EPBase(pc),d0
		beq.w	Exit

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	DTG_Intuitionbase(a4),Intbase(a5)
		move.l	DTG_GFXBase(a4),GFXBase(a5)
		move.l	EPG_LocaleBase(a4),LocaleBase(a5)
		move.l	DTG_GadtoolsBase(a4),GadBase(a5)
		move.l	DTG_Dosbase(a4),DosBase(a5)
		
		move.l	#-1,mypen(A5)	;Halfshine Farbe fr Gadgets, zur Sicherheit -1 gesetzt

		lea	EUS_Structure(pc),a0
		move.b	ZoomOnOff(a0),ZoomState(a5)
		move	Eus_Winx(a0),WinPosX(a5)
		move	Eus_Winy(a0),WinPosY(a5)
		move	ZoomX(a0),ZoomPosX(a5)
		move	ZoomY(a0),ZoomPosY(a5)

		move.l	#22000,PlayFrequence(a5)

		bsr	InitLists
		bsr	FirstLocaleInit

		sub.l	a1,a1
		EB
		jsr	_LVOFindTask(a6)
		move.l	d0,MyTaskAdr(a5)

		bsr	LoadFormats
		bsr	LoadConfig

*-------------------------- Mesage an Eagleplayer schicken -----------------*
*---- Input:	;d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
	if Executable+Debugger
		if debugger
		move.l	#EUS_Structure,d5
		else
		moveq	#0,d5
		endc
		moveq	#0,d1
		moveq	#USClass_NewUserPrg,d2
		moveq	#0,d3
		moveq	#0,d4
		if	debugger
		move.w	#-2,MerkUserNr(a5)
		endc
		bsr	SendeOneMessage
		tst.l	d0
	else
		bsr.w	OpenWin
	endc
		beq.s	ExitEngine

	*------------ Hauptprogramm ablaufen lassen ------------*
		bsr	LockSampleInfo
		tst.l	MaxEntries(a5)
		beq.s	.NoSel
		clr.l	SelectedEntry(a5)
		moveq	#1,d0
		bsr	SetModulesEntry
.NoSel:		tst.l	MaxSampleEntries(a5)
		beq.s	.NoSel2
		clr.l	SelectedSampleEntry(a5)
		moveq	#1,d0
		bsr	SetSampleEntry
.NoSel2:	bsr.w	Warten



*-----------------------------------------------------------------------------*
ExitEngine:	lea	Puffer,a5
		bsr	WaitUserMessages
		bsr	CloseWin
		bsr	FreeFormatList
		bsr	FreeSampleList
		bsr	RemoveMsgPort

		move.l	DatatypesBase(a5),d0
		beq.s	.nodt
		move.l	d0,a1
		EB
		jsr	_LVOCloselibrary(a6)
		clr.l	DatatypesBase(a5)
.nodt

		move.l	MyReqToolsBase(a5),d0
		beq.s	.noReqTools
		move.l	d0,a1
		EB
		jsr	_LVOCloselibrary(a6)
		clr.l	MyReqToolsBase(a5)
.NoReqTools:


Exit:		moveq	#EPR_ErrorAddUserPrg,d0
		ifeq	Executable
		illegal
		else
		rts
		endc
*-----------------------------------------------------------------------------*
InitLists:	lea	Formatlist(a5),a0
		Newlist	a0
		lea	Samplelist(a5),a0
		Newlist	a0
		lea	Infolist(a5),a0
		Newlist	a0
		lea	Eigenlist(a5),a0
		Newlist	a0
		rts

*-----------------------------------------------------------------------------*
InsertSampleStruct:
		movem.l	d0-a6,-(a7)

		clr.w	SomeSamplesFailures(a5)

*		bsr	FreeSamplelist
*
*		bsr	LockSampleInfo
*		bne.s	.DasWars

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		tst.l	EPG_SampleInfoStructure(a4)
		beq.w	.Return
		lea	EPG_SampleInfoStructure(a4),a4
		sub.l	a2,a2
		moveq	#0,d3
		moveq	#0,d4
.NextSample:	addq.l	#1,d3
		move.l	(a4),d0
		beq.s	.DasWars
		move.l	d0,a4

		tst.l	EPS_Adr(a4)
		beq.s	.NextSample
		tst.l	EPS_Length(a4)
		beq.s	.NextSample

		addq.l	#1,d4
		moveq	#ESA_SizeOF,d0
		move.l	4,a6
		move.l	#$10000,d1
		jsr	_LVOAllocMem(a6)
		move.l	d0,a3
		tst.l	d0
		beq.w	.DasWars
		move.l	#ESA_SizeOF,ESA_StructSize(a3)
		move.l	EPS_Samplename(a4),d0
		beq.s	.NoName
		move.l	d0,a0
		tst.b	(a0)
		bne.s	.NameOk
.NoName:	moveq	#LENr_Unknownname,d0
		bsr	GetLocaleString
.NameOk:	move.l	d0,ESA_Node+LN_Name(a3)
		move.l	a4,ESA_SampleStruct(a3)
		lea	Samplelist(a5),a0
		lea	ESA_Node(a3),a1
		bsr	InsertInList
		move.l	a1,a2
		addq.l	#1,MaxSampleEntries(a5)
		bra.s	.NextSample


.DasWars:	cmp.l	d3,d4
		beq.w	.NoHinweis
		move.w	#1,SomeSamplesFailures(a5)
.NoHinweis:	bsr	RemoveSampleList
		bsr	ReaddSampleList

		tst.l	MaxSampleEntries(a5)
		beq.s	.NoSel2
		clr.l	SelectedSampleEntry(a5)
		moveq	#1,d0
		bsr	SetSampleEntry
.NoSel2:	bsr	MakeEigenlist

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Ldt die externen Samplesaver hinein.
*-----------------------------------------------------------------------------*
LoadFormats:	movem.l	d0-a6,-(a7)
		tst.w	Formatsloaded(a5)
		bne.w	.NoEngineDir

	if	Executable
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_EngineDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Enginedir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

		*--- Samplesaverdir setzen ---*
.NoConfigDir:	move.l	d1,-(a7)
		lea	FormatsDir(pc),a0
		move.l	a0,d1
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d6
		beq.s	.FreeEngineDir
		move.l	d6,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,-(a7)

		moveq	#DOS_FIB,d1
		moveq	#0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOAllocDosObject(a6)
		move.l	d0,a4
		tst.l	d0
		beq.w	.FreeNoiseDir

		bsr	LadeNunSaver

		moveq	#DOS_FIB,d1
		move.l	a4,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOFreeDosObject(a6)


.FreeNoiseDir:	move.l	(a7)+,d1
		beq.s	.NoNoiseDLock
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
.NoNoiseDLock:	move.l	d6,d1
		beq.s	.FreeEngineDir
		move.l	Dosbase(a5),a6
		jsr	_LVOUnLock(a6)

.FreeEngineDir:	move.l	(a7)+,d1
		tst.l	d1
		beq.s	.NoEngineDir
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)

.NoEngineDir:	move.w	#1,Formatsloaded(a5)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a4=FIB
*	 d6=Handle
LadeNunSaver:
		movem.l	d0-a6,-(a7)

		move.l	a4,d2
		move.l	d6,d1			;Error beim Lock holen
		move.l	Dosbase(a5),a6
		jsr	_LVOExamine(a6)
		tst.l	d0
		beq.w	.Return


.ExNext:	move.l	d6,d1			*Handle
		move.l	a4,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOExNext(a6)
		tst.l	d0
		beq.w	.Return

		moveq	#ESS_SizeOF,d0
		move.l	4,a6
		move.l	#$10000,d1
		jsr	_LVOAllocMem(a6)
		move.l	d0,a3
		tst.l	d0
		beq.w	.Error
		move.l	#ESS_SizeOF,ESS_StructSize(a3)

		*--- Namen kopieren ---*
		lea	fib_filename(a4),a0
		move.l	a0,d1
		move.l	Dosbase(a5),a6
		jsr	_LVOLoadSeg(a6)
		move.l	d0,ESS_Segment(a3)
		tst.l	d0
		beq.w	.Error

		*---- Testen, ob Segment erlaube ist --*
		addq.l	#1,d0
		asl.l	#2,d0
		move.l	d0,a0

		*--- Eagleplayerformat check ---*
* CHECK

		cmp.l	#$70ff4e75,(a0)
		bne.w	.Error
		cmp.l	#"EP_S",8(a0)
		bne.w	.Error
		cmp.l	#"AMPL",12(a0)
		bne.w	.Error
		cmp.l	#"ESAV",16(a0)
		bne.w	.Error
		cmp.l	#"ER"<<16,20(a0)
		bne.s	.Error

		move.l	4(a0),ESS_Tags(a3)
		move.l	ESS_Tags(a3),a6
		move.l	#SS_RequestSamplesaver,d0
		bsr	FindTag
		move.l	a6,d1
		cmp.l	#SamplesaverVersion,d1
		bhi.s	.FreeSegment

.RetryNext:	bsr	InitESSStruct

		move.l	ESS_Tags(a3),a6
		move.l	#SS_NextSamplesaver,d0
		bsr	FindTag
		beq.w	.ExNext

		*--- Untersamplesaver ---*
		moveq	#ESS_SizeOF,d0
		move.l	4,a6
		move.l	#$10000,d1
		jsr	_LVOAllocMem(a6)
		move.l	d0,a3
		tst.l	d0
		beq.w	.ExNext
		move.l	#ESS_SizeOF,ESS_StructSize(a3)
		move.l	d2,ESS_Tags(a3)
		bra.s	.RetryNext


.FreeSegment:	move.l	ESS_Segment(a3),d1
		beq.s	.Error
		move.l	Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)
		clr.l	ESS_Segment(a3)
.Error:		move.l	a3,a1
		move.l	ESS_StructSize(a3),d0
		beq.s	.NoFree
		move.l	4,a6
		jsr	_LVOFreeMem(a6)
.NoFree		bra.w	.ExNext

.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* ESS_Tags mssen schon gesetzt sein
* Input: a3=ESS_Struct
*-----------------------------------------------------------------------------*
InitESSStruct:	movem.l	d0-a6,-(a7)
		move.l	ESS_Tags(a3),a6
		move.l	#SS_Formatname,d0
		bsr	FindTag
		move.l	a6,ESS_Node+LN_Name(a3)

		move.l	ESS_Tags(a3),a6
		move.l	#EP_Eaglebase,d0
		bsr	FindTag
		tst.l	d2
		beq.s	.NoEagleBase
		move.l	EUS_Structure+EUS_EPBase(pc),(a6)

.NoEagleBase:	move.l	ESS_Tags(a3),a6
		move.l	#SS_Eaglebase,d0
		bsr	FindTag
		tst.l	d2
		beq.s	.NoEagle2Base
		move.l	EUS_Structure+EUS_EPBase(pc),(a6)

		*-- in Liste einfgen --*
.NoEagle2base:	bsr	InsertItInList
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Alphabetisch richtig einsortieren!
* Input: a3=Neue ESS_Structure
*
InsertItInList:	movem.l	d0-a6,-(a7)
		sub.l	a2,a2
		lea	Formatlist(a5),a4
.Nochmal:	move.l	(a4),a4
		move.l	(a4),d0
		beq.s	.NoMore
		move.l	LN_Name(a4),a0
		move.l	ESS_Node+LN_Name(a3),a1
		bsr	StrCMP
		bgt.s	.NoMore
		move.l	a4,a2
		bra.s	.Nochmal
.NoMore:	lea	ESS_Node(a3),a1
		lea	Formatlist(a5),a0
		bsr	InsertInList

		addq.l	#1,MaxEntries(a5)
		movem.l	(a7)+,d0-a6
		rts


*---------------------- Inserte einen Eintrag in eine Liste ------------------*
* Input: a0=Liste							      *
*	 a1=Neue Node							      *
*	 a2=Node, die davorsteht oder NULL fr erste			      *
*-----------------------------------------------------------------------------*
InsertInList:	movem.l	d0/a0/a3,-(a7)

		*-- Erster Eintrag --*
		move.l	a2,d0
		bne.s	.NoFirst
		ADDHEAD
		bra.s	.Return

		*-- Letzter Eintrag --*
.NoFirst:	cmp.l	LH_TailPred(a0),a2
		bne.s	.NoLast
		ADDTAIL
		bra.s	.Return

.NoLast:	move.l	LN_Succ(a2),d0			;Vorgnger in a2
		beq.s	.Return
		move.l	d0,a3				;Nachfolger in a3

		move.l	a1,LN_Succ(a2)			;Verk. zum Vorgnger
		move.l	a1,LN_Pred(a3)			;Verk. zum Nachfolger

		move.l	a2,LN_Pred(a1)
		move.l	a3,LN_Succ(a1)

.Return:	movem.l	(a7)+,d0/a0/a3
		rts


*-----------------------------------------------------------------------------*
FindTag:
FindTag2:	move.l	d3,-(a7)
		move.l	a7,d3

	*--------- Recursive FindTag-Routine ----------*
FindTag3:	moveq	#0,d2
		cmp.l	a6,d2
		beq.s	.Empty
		move.l	(a6)+,d2			;Tag rauslesen
		bne.s	.NoEmpty
.Empty:		cmp.l	d3,a7				;ak. Stack vergleichen
		beq.s	.TagNoFound
		move.l	(a7)+,a6
		bra.b	.NoMore
.NoEmpty:	cmp.l	d2,d0
		beq.s	.TagFound

	*----- Tag-Skip gefunden ???? -----*
		cmp.l	#Tag_Skip,d2
		bne.s	.NoSkip
		addq.l	#8,a6				;Diesen und nchsten
		addq.l	#4,a6				;Tag berspringen
		bra.s	.NoMore

	*------ Tag-More gefunden ???? -----*
.NoSkip:	cmp.l	#Tag_More,d2
		bne.s	.NoMore

		move.l	a6,-(a7)		;Adr der Tagliste sichern
		move.l	(a6),a6			;Neue Tagliste setzen
		bra.b	FindTag3
.NoMore:	addq.l	#4,a6
		bra.s	FindTag3
.TagFound:	move.l	(a6),a6
		move.l	a6,d2
.TagNoFound:	move.l	d3,a7
		move.l	(a7)+,d3
		tst.l	d2
		bne.s	.NoNull
		sub.l	a6,a6
.NoNull:	tst.l	d2
		rts




*-----------------------------------------------------------------------------*
SaveConfig:	movem.l	d1-a6,-(a7)

	ifeq	test
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Configdir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		lea	ConfigName(pc),a1
		move.l	a1,d1
		move.l	#1006,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Return

	*----------- Nun Config Schritt fr Schritt speichern ---------*
		lea	ConfigDatas(a5),a0
		move.l	#ConfigDatasEnd-ConfigDatas,d3
		move.l	d6,d1
		move.l	a0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOWrite(a6)

		*--- Datei Closen ---*
		move.l	d6,d1
		beq.s	.AllesOk
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
LoadConfig:	movem.l	d1-a6,-(a7)

	ifeq	test
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Configdir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		lea	ConfigName(pc),a1
		move.l	a1,d1
		move.l	#1005,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Return

	*----------- Nun Config Schritt fr Schritt speichern ---------*
		lea	ConfigDatas(a5),a0
		move.l	#ConfigDatasEnd-ConfigDatas,d3
		move.l	d6,d1
		move.l	a0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)

		*--- Datei Closen ---*
		move.l	d6,d1
		beq.s	.AllesOk
		move.l	d0,-(a7)
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)
		move.l	(a7)+,d1
		moveq	#EPR_ErrorInFile,d0
		cmp.l	d0,d3
		bne.s	.Return

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Output: d0+a6 = Librarybase
*-----------------------------------------------------------------------------*
GetReqToolsBase:movem.l	d1-a5,-(a7)
		move.l	MyReqToolsBase(a5),d0
		bne.s	.Return
		lea	MyReqToolsName(pc),a1
		EB
		moveq	#38,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,MyReqToolsBase(a5)
.Return:	move.l	d0,a6
		movem.l	(a7)+,d1-a5
		rts


*-----------------------------------------------------------------------------*
SendeOneMessage:
		movem.l	d1-a6,-(a7)
	if	executable+debugger
		bsr	CreateMsgPort
		beq.w	.Fehler
		bsr	WaitUserMessages

	*	tst	Exitnow(a5)
	*	bne	.fehler

		bsr	AllocMsg
		beq	.fehler
		move.l	d0,a1
		move.l	d0,a4
		*lea	MyMessage(a5),a1

	*------------ Exec-Message initialisieren -----------*
		move.w	#UM_Sizeof-20,MN_Length(a1)
		move.b	#NT_Message,LN_Type(a1)
		move.l	MsgPort(a5),MN_ReplyPort(a1)

	*------------ User-Message initialisieren -----------*
		if	debugger
		move.w	MerkUserNr(a5),UM_UserNr(a1)
		else
		move.w	EUS_Structure+EUS_UserNr(pc),UM_UserNr(a1)
		endc
		move.l	MyTaskAdr(a5),UM_TaskAdr(a1)
		move.l	Signal(a5),UM_Signal(a1)
		move.l	MsgPort(a5),UM_UserPort(a1)
		move.l	#USM_Userprg,UM_Type(a1)
		move.w	d1,UM_Enabled(a1)
		move.w	d2,UM_Class(a1)			;Kennung setzen
		move.l	d3,UM_Command(a1)
		move.l	d4,UM_ArgString(a1)
		move.l	d5,UM_Result(a1)

		*move.l	a1,ThisMessage(A5)

	*------------ Message senden -------------*
.RetryFindPort:	lea	EPUserPortName(pc),a1
		EB
		jsr	_LVOFindPort(a6)
		move.l	d0,a0
		tst.l	d0
		bne.s	.PortDa

	*----- Eagleplayer-Port nicht gefunden ----*
		moveq	#LENr_EPNotFound,d0
		moveq	#LENr_Ok,d1
		bsr	TextRequest
		moveq	#0,d0
		bra.s	.Fehler
		*beq.s	.Fehler
		*bra.s	.RetryFindPort

.PortDa:	movem.l	d0/a0,-(a7)
		*move.l	ThisMessage(A5),a1
		*lea	MyMessage(a5),a1
		move.l	a4,a1

		move.l	UM_TaskAdr(a1),d0
		beq.s	.NoTask
		move.l	d0,a1
		moveq	#0,d0
		jsr	_LVOSetTaskPri(a6)	
.NoTask:	movem.l	(a7)+,d0/a0
		*move.l	ThisMessage(A5),a1
		*lea	MyMessage(a5),a1
		move.l	a4,a1
		jsr	_LVOPutMsg(a6)

		addq.l	#1,MsgUnterwegs(a5)

	*---------- Alles klar, Ende ----------*
.NoPort:	bsr	WaitUserMessages
	endc
		moveq	#-1,d0
.Fehler:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Output: d0=Adr
Allocmsg:	movem.l	d1-a6,-(sp)
		EB
		moveq	#UM_Sizeof,d0
		move.l	#$10001,d1
		jsr	_LVOAllocMem(A6)
		movem.l	(sp)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a1=Msg
Freemsg:	movem.l	d0-a6,-(a7)
		moveq	#0,d0
		move.w	mn_length(a1),d0
		beq.s	.Error
		add.l	#20,d0
		EB
		jsr	_LVOFreemem(A6)
.Error:		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
CreateMsgPort:	movem.l	d1-d7/a1-a6,-(a7)
		move.l	MsgPort(a5),d0
		bne.s	.PortOk
		EB
		jsr	_LVOCreateMsgPort(a6)	;Messageport auf die schnelle Art
		move.l	d0,MSGport(a5)
		tst.l	d0
		beq.s	.PortOk
		move.l	d0,a1
		move.l	#MyMsgPortName,LN_Name(a1)
		jsr	_LVOAddPort(a6)


	*----------- SignalBits setzen ------------*
		move.l	MsgPort(a5),a0
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)

.PortOk:	movem.l	(a7)+,d1-d7/a1-a6
		move.l	MsgPort(a5),d0
		move.l	d0,a0
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
RemoveMsgPort:	movem.l	d0-a6,-(a7)

	*----------- SignalBits sperren ------------*
		move.l	MSGport(a5),d0
		beq.s	.PortOk
		move.l	d0,a1
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)
		EB
		jsr	_LVORemPort(a6)

		move.l	MsgPort(a5),a0
		jsr	_LVODeleteMsgPort(a6)	;Messageport auf die schnelle Art
		clr.l	MsgPort(a5)
.PortOk:	movem.l	(a7)+,d0-a6
		rts

*----------------------- Gibt die Return-Structure frei -------------------*
* Input: a1=Message
*
FreeCommandStruct:
		movem.l d0-a6,-(a7)
		move.l	a1,a3
		move.l	a1,d0
		beq.s	.Error
		*move.l	UPrg_Struct(a5),a4
		move.l	UM_ArgString(a1),a4
.NextStruct:	moveq	#0,d0
		cmp.l	a4,d0
		beq.w	.Return
		move.l	a4,a1
		move.l	(a1),a4
		move.l	EPT_StringSize(a1),d0
		beq.s	.StructFree
		EB
		jsr	_LVOFreeMem(a6)
.StructFree:	bra.b	.NextStruct
.Return:
		*clr.l	UPrg_Struct(a5)
		clr.l	UM_Argstring(a3)


.Error:		movem.l	(a7)+,d0-a6
		rts

*---------------------------------------------------------------------------*
*----- Wartet, bis alle Messages von den Userprogrammen wieder da sind -----*
*---------------------------------------------------------------------------*
*---------------------------------------------------------------------------*
WaitUserMessages:movem.l d0-a6,-(a7)

	if debugger
		bsr.w	CopyEPBase
	endc

		tst.w	NoWait(a5)
		bne.s	.Return

.WaitNochmal:
		tst.l	MsgUnterwegs(a5)
		beq.w	.Return
		move.l	4,a6
		bsr	CreateMsgPort
		beq.s	.Return
		move.l	a0,a3
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		bne.s	.MSG

		tst.w	ExitNow(a5)
		bne.w	.Return

		move.l	a3,a0
		jsr	_LVOWaitPort(a6)
		bra.s	.WaitNochmal
.MSG
		move.l	d0,a1
		bsr	UserMessage

		tst.w	ExitNow(a5)
		beq.w	.WaitNochmal
.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
ClrPuffer:	if	Test
		bsr	FirstEagleInit
		endc

		move.l	a5,a0
		move.w	#PufferEnd-1,d0
.clr		clr.b	(a0)+
		dbf	d0,.clr
		rts

		if	Debugger!Test
CopyEPBase:
*		move.l	EUS_Structure+EUS_EPBase(pc),d0
*		beq.s	.Fertig
*		move.l	d0,a0
*		*move.l	a0,EPBase(a5)
*		move.w	#EPG_SizeOf/2-1,d0
*		move.l	a5,a1
*.CopyEP:	move.w	(a0)+,(a1)+
*		dbf	d0,.CopyEP
.Fertig:	rts
		endc

*-----------------------------------------------------------------------------*
* Sendet dem Eagleplayer, falls dieser im Helpmode ist, eine HelpNode
*-----------------------------------------------------------------------------*
* Input: a0=Nodename
* Output:d0=0  --> Node geschickt
SendHelp:	movem.l	d1-a6,-(a7)
		move.l	EPBase(pc),a4
		move.l	EPG_SomePrefs(a4),d1
		btst	#EGPRF_Help,d1
		beq.s	.NoHelp

		move.l	a0,a3
		bsr	BerechStringSize

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.NoHelp
		move.l	d7,d4
		move.l	d7,a1

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.NoHelp
		move.l	d7,a2

		*--- Args setzen ---*

		move.l	a3,ENA_Arg1(a2)
		move.l	d0,ENA_Arg2(a2)

		move.l	#EPNr_FirstEngine,d0
		add.w	EUS_Structure+EUS_UserNr(pc),d0
		move.l	d0,ENA_Arg1(a1)
		move.l	a2,ENA_Next(a1)

		*--- Kommando an EP schicken ---*
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_HelpLink,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage


		moveq	#1,d0
.NoHelp:	seq	d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Eine Message wird an den Eagleplayer gesendet.
* Input: d0=Wert fr Arg1 = Nummer
*	 d1=Wert fr Arg2
*	 d3=EPNr_Nummer
SendMess:	movem.l	d0-a6,-(a7)

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Error
		move.l	d0,ENA_Arg1(a0)
		move.l	d1,ENA_Arg2(a0)
		move.l	a0,d4			-> Args
		moveq	#0,d1
		moveq	#USClass_Command,d2
		moveq	#0,d5
		bsr	SendeOneMessage
.Error:		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: d7=Size nach ENA_Size
* Output:d7=a0=Adr
AllocArg:	movem.l	d0-d6/a1-a6,-(a7)
		move.l	#ENA_Size+4,d0
		add.l	d7,d0
		EB
		move.l	#$10001,d1
		jsr	_LVOAllocMem(a6)
		move.l	d0,a0
		move.l	#ENA_Size+4,ENA_Size(a0)
		add.l	d7,ENA_Size(a0)
		move.l	d0,d7
		movem.l	(a7)+,d0-d6/a1-a6
		tst.l	d7
		rts

*-----------------------------------------------------------------------------*
* Eine Message wird ohne Args an den Eagleplayer gesendet.
* Input: d3=EPNr_Nummer
SendOhneMess:	movem.l	d0-a6,-(a7)
		moveq	#0,d4
		moveq	#0,d1
		moveq	#USClass_Command,d2
		moveq	#0,d5
		bsr	SendeOneMessage
		movem.l	(a7)+,d0-a6
		rts

*---------------------------------------------------------------------------*
*------------ Hier befindet sich nun die Schleife die Aktionen -------------*
*---------------------------------------------------------------------------*
Warten:		move.l	MsgPort(a5),d0
		beq.s	WartenWinPort
		move.l	d0,a0
		EB
		jsr	_LVOGetmsg(a6)
		tst.l	d0			;Scrollen erlaubt
		beq.w	WartenWinPort
		bsr.w	UserMessage
		bra.w	Warten

SendExit:	moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
Return:		rts

WartenWinPort:	tst.w	ExitNow(a5)
		bne.w	Return

		move.l	WindowPort(a5),d0
		beq.s	Wait
		move.l	d0,a0
		move.l	GadBase(a5),a6
		jsr	_LVOGT_GetIMsg(a6)
		tst.l	d0
		beq.s	Wait
		move.l	d0,a1
		bsr.w	GetMsg

		cmp.w	#EPNr_Engine,d0
		bne.s	Warten
		rts

*----------------------------------------------------------------------------*
*------------- Hier wait, bis einer der Message-Ports ->>> Message ----------*
*----------------------------------------------------------------------------*
Wait:		move.l	SignalBits(a5),d0
		or.w	#$1000,d0		;Break-Signal
		EB
		jsr	_LVOWait(a6)

	*------- War es ein Break Signal -----*
		btst	#12,d0			;Break-Signal
		bne.w	SendExit

	*------- War es ein UserMessage ------*
		move.l	MsgPort(a5),d2
		beq.s	.NoPort
		move.l	d2,a0
		moveq	#0,d1
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	Warten			;EaglePort

	*----- war es eine Window-Message ----*
.NoPort:	move.l	WindowPort(a5),d2		;Testen ob Window-Port
		beq.s	.NoMain
		move.l	d2,a0
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenWinPort
.NoMain:	bra.w	Wait





*-----------------------------------------------------------------------------*
GetMsg:		lea	Puffer,a5
		*move.l	WindowPort(a5),d0
		*beq.w	.Return
		*move.l	d0,a0
		*move.l	GadBase(a5),a6
		*jsr	_LVOGT_getimsg(a6)
		*tst.l	d0
		*beq	.Return
		*move.l	d0,a1
		move.l	im_class(a1),d7
		moveq	#0,d5
		move.l	IM_Seconds(a1),CurrentSeconds(a5)
		move.l	IM_Micros(a1),CurrentMicros(a5)
		move.w	im_code(a1),d5 		<- Fr Tastatur / Selnummer Listview
		move.l	im_Iaddress(a1),d6 	<- Fr Gadgetabfrage
		move.l	im_seconds(a1),d2	<- fr Doppelclick
		move.l	im_micros(a1),d3	<- auch f. Doppelclick
		move.w	im_Qualifier(a1),Qualifier(a5)
		jsr	_LVOGT_ReplyIMsg(a6)

	*---------------- MSG auswerten -------------*
		cmp.l	#IDCMP_Changewindow,d7	;Refresh
		bne.s	.TestNewSize
		move.l	Winhandle(a5),a0
		move	OffY(A5),d0
		cmp	wd_height(a0),d0
		bne.s	.setposun
		move.w	wd_leftedge(a0),ZoomPosX(a5)
		move.w	wd_topedge(a0),ZoomPosY(a5)
		st	ZoomState(a5)
		bra.w	.Return
.Setposun:	move.w	wd_leftedge(a0),WinPosX(a5)
		move.w	wd_topedge(a0),WinPosY(a5)
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)
		sf	ZoomState(a5)
		bra.w	.Return

*---------------------------------------------------*
* das war die alte Refreshroutine
******************************************
*.TestNewSize:	cmp.l	#NewSize,d7
*		bne.s	.TestRefreshWindow
*
*		move.l	Winhandle(a5),a0
*		move	OffY(A5),d0
*		cmp	WD_Height(a0),d0
*		beq.s	.SizeNoMerk
*		move.w	wd_Width(a0),WinWidth(a5)
*		move.w	wd_Height(a0),WinHeight(a5)
*.SizeNoMerk:	move.l	GadgetListAdr(a5),d0
*		beq.s	.TestRefreshWindow
*		move.l	d0,a1
*		moveq	#0,d0
*		move.w	RealNumGadgets(a5),d0
*		move.l	Winhandle(a5),a0
*		move.l	Intbase(a5),a6
*		jsr	_LVORemoveGList(a6)
*		bsr	FreeGadgets
*		bsr	Clearwindow
*		bsr	InitGadgets
*		bne.w	.Return
*		bsr	AddGads
*		*bne	.Return
*		bsr	EinTragNeu
*		bra.w	.Return
*
*.TestRefreshWindow:
*
*		cmp.l	#Refreshwindow,d7	;Refresh
*		bne.s	.TestGadgetUp
*
*.Refresh:
*
*	move.l	IntBase(a5),a6
*	move.l	WinHandle(a5),a0
*	jsr	_LVORefreshWindowFrame(a6)
*	bra.w	.return
*---------------------------------------------------*

.TestNewSize:	cmp.l	#NewSize,d7
		bne.s	.TestRefreshWindow

	move.l	Winhandle(a5),a0
	;	move	OffY(A5),d0
	;	cmp	WD_Height(a0),d0
	;	beq.w	.Return
	move.w	wd_width(a0),d0
	cmp.w	TmpWidth(a5),d0
	bne.s	.NewSizeReal
	move.w	wd_height(a0),d0
	cmp.w	TmpHeight(a5),d0
	beq.w	.Return
.NewSizeReal:
	move.w	wd_Width(a0),TmpWidth(a5)
	move.w	wd_Height(a0),TmpHeight(a5)
	bsr	ResizeWindow
	bra.w	.Return

.TestRefreshWindow:

;		cmp.l	#Refreshwindow,d7	;Refresh
;		bne.s	.TestGadgetUp
;		bsr	ResizeWindow
;		bra.w	.Return

*		bsr	Clearwindow
*	*	move.l	Gadbase(a5),a6
*	*	move.l	Winhandle(a5),a0	;*Window
*	*	jsr	_LVOGT_beginrefresh(a6)
*
*	*	move.l	Winhandle(a5),a0	;*Window
*	*	moveq	#1,d0
*	*	jsr	_LVOGT_Endrefresh(a6)
*
*		move.l	GadgetListAdr(a5),a0
*		move.l	Winhandle(a5),a1
*		suba.l	a2,a2
*		moveq	#-1,d0
*		move.l	IntBase(a5),a6
*		jsr	_LVOrefreshglist(a6)
*
*		move.l	GadBase(a5),a6
*		move.l	Winhandle(a5),a0
*		sub.l	a1,a1
*		jsr	_LVOGT_RefreshWindow(a6)
*
*
*		bra.w	.Return

.TestGadgetUp:	cmp.l	#Gadgetup,d7
		bne.w	.TestgadgetDown
		move.l	d6,a1
		move.w	GG_Gadgetid(a1),d0	;Nr des Gadgets
		bsr	JumpTo
		bra.w	.Return

.TestGadgetDown:cmp.l	#MouseMove,d7
		bne.w	.TestMenu
		move.l	d6,a1
		move.w	GG_Gadgetid(a1),d0	;Nr des Gadgets
		cmp.w	#EPENr_Slider,d0
		bne.w	.Return
		bsr	JumpTo
		bra.w	.Return


.MenuLoop:	move.l	OldMenuAdr(a5),a1
		move.w	MI_NextSelect(A1),d5
		bra.s	.MenuNext
.TestMenu:	cmp.l	#MenuPick,d7
		bne.w	.TestRawKey
.MenuNext:	move.w	d5,d0
		cmp.w	#menunull,d0
		beq	.Return
		move.l	MenuAdr(a5),a0
		move.l	IntBase(a5),a6
		jsr	_LVOItemAddress(a6)
		move.l	d0,a1
		tst.l	d0
		beq	.Return
		move.l	d0,OldMenuAdr(a5)

		lea	.Menutabelle(pc),a0
.NextItem:	move.w	(a0)+,d1
		beq.w	.Return
		move.w	(a0)+,d0
		cmp.w	d5,d1
		bne.s	.NextItem
.JumpTo:	moveq	#0,d2		;d5 mit durchschleifen fr Show by
		sub.l	a2,a2
		bsr	JumpTo
		bra.w	.Return

.MenuTabelle:	dc.w	MNr_Play,EPENr_Play
		dc.w	MNr_Stop,EPENr_Stop
		dc.w	MNr_About,EPENr_About
		dc.w	MNr_Hide,EPENr_Hide
		dc.w	MNr_Quit,EPENr_Quit
		dc.w	MNr_BackPic,EPENr_BackPic
		dc.w	MNr_SelectBackPic,EPENr_SelectBackPic
		dc.w	MNr_SaveConfig,EPENr_SaveConfig
		dc.w	0



.TestRawkey:	cmp.l	#rawkey,d7
		bne	.TestVanillaKey
		
		move.w	Qualifier(a5),d2
		btst	#3,d2
		bne.s	.Control
		btst	#0,d2
		bne.s	.Shift
		btst	#1,d2
		bne.s	.Shift

		moveq	#EPENr_ViewUp,d0
		cmp.b	#$4c,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewDown,d0
		cmp.b	#$4d,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewLeft,d0
		cmp.b	#$4f,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewRight,d0
		cmp.b	#$4e,d5
		beq.w	.JumpTo

		*cmp.b	#$45,d5			;ESC
		*beq.w	.HideWindow
		*cmp.b	#$4d,d5
		*beq.s	.EinenRunter
		*cmp.b	#$4c,d5
		*beq.s	.EinenRauf
		*cmp.b	#$44,d5
		*beq.s	.ToggleZustand
		*cmp.b	#$40,d5
		*beq.s	.ToggleZustand
		cmp.b	#$5f,d5
		beq.s	.ToggleHelpMode
		bra.w	.Return


.Control:	moveq	#EPENr_ViewTop,d0
		cmp.b	#$4c,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewBotom,d0
		cmp.b	#$4d,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewLeftMarge,d0
		cmp.b	#$4f,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewRightMarge,d0
		cmp.b	#$4e,d5
		beq.w	.JumpTo

		bra.w	.Return

.Shift:		moveq	#EPENr_ViewPageUp,d0
		cmp.b	#$4c,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewPageDown,d0
		cmp.b	#$4d,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewPageLeft,d0
		cmp.b	#$4f,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewPageRight,d0
		cmp.b	#$4e,d5
		beq.w	.JumpTo

		bra.w	.Return


*
*.EinenRunter:	move.l	SelectedEntry(a5),d0
*		cmp.l	MaxEntries(a5),d0
*		beq.w	.Return
*		addq.l	#1,d0
*		bsr	SetModulesEntry
*		bra.w	.Return
*
*.EinenRauf:	move.l	SelectedEntry(a5),d0
*		cmp.l	#2,d0
*		blt.w	.Return
*		subq.l	#1,d0
*		bsr	SetModulesEntry
*		bra.w	.Return
*



*.Help:		move.l	#EPNr_HelpLink,d3		*EP-Kommando
*		move.l	SelectedEntry(a5),d0		*Playernummer
*		add.w	#EPNr_FirstPlayer,d0
*		cmp.b	#Mode_Player,Mode(a5)
*		beq.s	.Hlp_Player
*		bsr	GetEngineNr
*		add.w	#EPNr_FirstEngine-1,d0
*.Hlp_Player:	moveq	#0,d1
*		bsr	SendMess
*		bra.w	.Return

.ToggleHelpMode:moveq	#EPNr_Help,d3
		moveq	#-1,d0				;Toggle
		moveq	#0,d1
		bsr	SendMess
		bsr	ErlaubeGadgets
		bra.w	.Return

.TestVanillaKey:cmp.l	#vanillakey,d7
		bne	.TestCloseWindow

		*cmp.b	#32,d5				;Leertaste
		*beq.s	.ToggleZustand
		cmp.b	#$1b,d5
		beq.w	.HideWindow

		bclr	#5,d5
		lea	.Tastaturtabelle(pc),a1
.TesteTasten:	moveq	#0,d0
		move.b	(a1)+,d1
		beq.w	.Return
		move.b	(a1)+,d0
		bne.s	.StandardKuerzel
		move.l	d1,d0
		bsr	GetLocaleString
		move.l	d0,a0
		moveq	#0,d4
		move.b	(a0),d0
.StandardKuerzel:moveq	#0,d4
		move.b	(a1)+,d4
		bclr	#5,d0
		cmp.b	d0,d5
		bne.w	.TesteTasten
		move.l	d4,d0
		bsr	JumpTo
		bra.w	.Return

.Tastaturtabelle:
		dc.b	1,"Q",EPENr_Quit
		dc.b	1,"H",EPENr_Hide
		dc.b	1,"A",EPENr_About
		dc.b	1," ",EPENr_Play
		dc.b	1,13,EPENr_NimmSaver
		dc.b	1,9,EPENr_ToggleListview
		dc.b	LENr_PlayKey,0,EPENr_Play
		dc.b	LENr_StopKey,0,EPENr_Stop
		dc.b	0
		even

.TestCloseWindow:cmp.l	#CloseWindow,d7
		bne	.Return

.HideWindow:	lea	Helpnode_Hide(pc),a0
		bsr	SendHelp
		beq.w	.Return

		moveq	#EPENr_Hide,d0
		bsr	JumpTo
		if	Debugger!Executable
		bra.s	.Return
		endc

.CloseWindow:	moveq	#EPENr_Quit,d0
		bsr	JumpTo

		moveq	#EPNr_Engine,d0
		ifeq	executable+debugger
		bra.w	.Return
		else
		bra.w	.Return2
		endc


.Return:	moveq	#0,d0
.Return2:	tst.l	d0
		rts

PJM	MACRO
	dc.w	\1-.JumpToTabelle,\2-.JumpToTabelle
	ENDM

*-----------------------------------------------------------------------------*
* d0=EPNr_Nummer
* d5=MenuItemNr
JumpTo:		movem.l	d1-a6,-(a7)
		lea	.JumpToTabelle(pc),a0
		cmp.w	#EPENr_LastNr,d0
		bhi.s	.Return
		move.l	d0,d1
		add.w	d0,d0
		add.w	d0,d0

		move.l	EPBase(pc),a4
		btst	#EGPRF_Help-8,EPG_SomePrefs+2(a4)
		beq.s	.NoHelp
		tst.w	-2(a0,d0.w)
		beq.s	.NoHelp

		move.w	-2(a0,d0.w),d0
		lea	(a0,d0.w),a0
		bsr	SendHelp
		cmp.w	#EPENr_Slider,d1
		bne.s	.Return
		move.l	PlayFrequence(a5),d5
		bsr	SetSlider
		bra.s	.Return

.NoHelp:	move.w	-4(a0,d0.w),d0
		lea	(a0,d0.w),a0
		jsr	(a0)
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.JumpToTabelle:
.EPENr_Listview		PJM	Listview,HelpNode_Formatlist
.EPENr_Samplelist	PJM	ListViewSamplelist,HelpNode_Samplelist
.EPENr_Slider		PJM	Slider,Helpnode_Slider
.EPENr_TextGadget	PJM	TextGadget,Helpnode_Slider
.EPENr_Play		PJM	Play,Helpnode_Play
.EPENr_Infos		PJM	Return,Helpnode_Informationen
.EPENr_Eigen		PJM	Return,Helpnode_Eigenschaften
.EPENr_About		PJM	About,HelpNode_About
.EPENr_Quit		PJM	Quit,Helpnode_Quit
.EPENr_Hide		PJM	Hide,HelpNode_Hide
.EPENr_SelectBackPic	PJM	SelectBackPic,Helpnode_BackPic
.EPENr_BackPic		PJM	BackPic,Helpnode_BackPic
.EPENr_ViewUp		PJM	ViewUp,.JumpToTabelle
.EPENr_ViewDown		PJM	ViewDown,.JumpToTabelle
.EPENr_ViewPageUp	PJM	ViewPageUp,.JumpToTabelle
.EPENr_ViewPageDown	PJM	ViewPageDown,.JumpToTabelle
.EPENr_ViewTop		PJM	ViewTop,.JumpToTabelle
.EPENr_ViewBotom	PJM	ViewBotom,.JumpToTabelle

.EPENr_ViewLeft		PJM	ViewLeft,.JumpToTabelle
.EPENr_ViewRight	PJM	ViewRight,.JumpToTabelle
.EPENr_ViewPageLeft	PJM	ViewPageLeft,.JumpToTabelle
.EPENr_ViewPageRight	PJM	ViewPageRight,.JumpToTabelle
.EPENr_ViewLeftMarge	PJM	ViewLeftMarge,.JumpToTabelle
.EPENr_ViewRightMarge	PJM	ViewRightMarge,.JumpToTabelle

.EPENr_NimmSaver	PJM	NimmSaver,.JumpToTabelle
.EPENr_LoadConfig	PJM	LoadConfig,.JumpToTabelle
.EPENr_SaveConfig	PJM	SaveConfig,HelpNode_SaveConfig
.EPENr_ToggleListview	PJM	ToggleListview,HelpNode_SaveConfig
.EPENr_TogglePlayMode	PJM	TogglePlayMode,HelpNode_Play
.EPENr_Stop		PJM	Stop,HelpNode_Stop

			ifne	(EPENr_LastNr-1)*4-(*-.JumpToTabelle)
			HUHU
			endc

*-----------------------------------------------------------------------------*
Play:		movem.l	d1-a6,-(a7)
		move.l	EPBase(pc),a4

		bsr	GetSelectedSampleStruct
		bne.s	.Error
		move.l	ESA_Samplestruct(a0),a3

		bsr	GetSelectedFormatStruct
		bne.s	.Error
		move.l	ESS_Tags(a0),a4

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Error
		move.l	d7,d4
		move.l	d7,a1

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Error
		move.l	d7,a2

		*--- Args setzen ---*
		move.l	a3,ENA_Arg1(a1)
		move.l	a4,ENA_Arg1(a2)
		move.l	a2,ENA_Next(a1)

		*--- Kommando an EP schicken ---*
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_PlaySample,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage

.Error:		moveq	#0,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
Stop:		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_PlayerTaglist(a4),a6
		move.l	#EP_SamplePlayer,d0
		bsr	FindTag
		beq.s	.Return

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Return
		move.l	d7,d4
		move.l	d7,a1
		move.l	#0,ENA_Arg1(a1)

		*--- Kommando an EP schicken ---*
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_Play,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
ToggleplayMode:	move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_PlayerTaglist(a4),a6
		move.l	#EP_SamplePlayer,d0
		bsr	FindTag
		beq.w	Play
		bra.w	Stop


*-----------------------------------------------------------------------------*
* Input: a0=Adr des Mem
*	 a1=Pfad
*	 d0=Size der Datei
*-----------------------------------------------------------------------------*
SaveMem:	movem.l	d1-a6,-(a7)

		move.l	a1,a4
		move.l	a0,a3
		move.l	d0,d3
		lea	Puffer,a5
		move.l	#1006,d2
		move.l	a1,d1
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	d0,d5
		tst.l	d0
		beq.s	.Error

		move.l	d5,d1
		move.l	a3,d2
		jsr	_LVOWrite(a6)
		move.l	d0,-(a7)
		move.l	d5,d1
		jsr	_LVOClose(a6)
		move.l	(a7)+,d0
		cmp.l	d0,d3
		beq.s	.Ok

		move.l	a4,d1
		jsr	_LVODeleteFile(a6)
.Error:		moveq	#EPR_WriteError,d0
		bra.s	.Return

.Ok:		moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts












*-----------------------------------------------------------------------------*
Slider:		mulu	#FreqStep,d5
		cmp.l	PlayFrequence(a5),d5
		beq.w	.Return
		move.l	d5,PlayFrequence(a5)
		lea	FrequencePuffer(a5),a1
		move.l	d5,d0
		bsr	Hexdez


		bsr	GetSelectedFormatStruct
		bne.s	.NoDef

		*-- Die jetzt eingestelte Freq in die Tags setzen --*
		*-- aber nur, wenn variabel --*
		move.l	ESS_Tags(a0),a6
		move.l	#SS_Flags,d0
		bsr	Findtag
		beq.s	.NoDef
		move.l	a6,d2
		btst	#SSB_FrequencyVariable,d2
		beq.s	.NoDef

		move.l	ESS_Tags(a0),a6
		move.l	#SS_DefFreqPtr,d0
		bsr	FindTag
		beq.s	.NoDef
		move.l	PlayFrequence(a5),(a6)

		*--- Nun Frequenz im spielenden Player setzen --*
		*-- aber nur, wenn der selectierte auch dem   --*
		*-- spielendem entspricht! --*
.NoDef:		bsr	GetSelectedFormatStruct
		bne.s	.NoChange
	*	move.l	ESS_Node+LN_Name(a0),a0
		move.l	EUS_Structure+EUS_EPBase(pc),a4
	*	move.l	EPG_SoundSystemname(a4),a1
	*	bsr	StrCMP
	*	bne.s	.NoChange
		move.l	EPG_PlayerTaglist(a4),a6
		move.l	#EP_SetPlayFrequency,d0
		bsr	FindTag
		beq.s	.NoChange
		move.l	d5,d0
		movem.l	d0-a6,-(a7)
		move.l	EUS_Structure+EUS_EPBase(pc),a5
		jsr	(a6)
		movem.l	(a7)+,d0-a6

		*--- Textgadget updaten ---*
.NoChange:	lea	TextGadgetTags(pc),a3
		moveq	#EPENr_TextGadget,d0
		bsr	GetGadgetAdr
		*lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.Return:	moveq	#0,d0
		rts


*----------------------------------------------------------------------------*
TextGadget:	moveq	#-1,d0
		rts


*-----------------------------------------------------------------------------*
NimmSaver:
		bsr	GetSelectedSampleStruct
		bne.w	.Error
		move.l	ESA_Node+LN_Name(a0),a0
		move.l	a0,a1
.NextB:		move.b	(a1)+,d0
		beq.s	.NameOhne
		cmp.b	#":",d0
		bne.s	.NextB
		move.l	a1,a0

.NameOhne:	lea	FilePuffer(a5),a1
		moveq	#MaxFilenameSize,d1
		bsr	StringCopy

		lea	DirPuffer(a5),a0
		lea	FilePuffer(a5),a1
		move.w	#LENr_SoundDatei,d0
		bsr	DT_Filerequest
		beq	.Error

		lea	DirPuffer(a5),a0
		lea	PathPuffer(a5),a1
		move.w	#PathPufferSize-3,d1
		bsr	StringCopy
		lea	PathPuffer(a5),a0
		bsr	MakeCorrectDir
		lea	PathPuffer(a5),a0
		bsr	BerechStringSize
		lea	(a0,d0.w),a1
		lea	FilePuffer(a5),a0
		bsr	StringCopy		

		bsr	GetSelectedFormatStruct
		bne.w	.Error
		move.l	a0,a3				;A3=SAVER

		move.l	ESS_Tags(a3),a6
		move.l	#SS_SaveSample,d0
		bsr	FindTag
		beq.w	.Error

		move.l	ESS_Tags(a3),a6
		move.l	#SS_RAWFlags,d0
		bsr	FindTag
		beq.w	.Error
		and.w	#~(USIB_Playable!USIB_Saveable),d2

		bsr	GetSelectedSampleStruct		;A4=Sample
		bne.w	.Error
		move.l	a0,a4

		move.l	ESA_SampleStruct(a4),d0
		beq.w	.Error
		move.l	d0,a0
		tst.w	EPS_Type(a0)
		bne.w	.UnknownType

		clr.l	SampleStructure+EPS_Adr(a5)
		move.w	EPS_Flags(a0),d0
		and.w	#~(USIB_Playable!USIB_Saveable),d0
		*and.w	d0,d2
		cmp.w	d0,d2
		beq.w	.Jetzt

		*--- Lnge des Mem ausrechen ---*
		move.l	EPS_Length(a0),d1
		btst	#USIF_8Bit,d2			;verlangt
		bne.s	.Bit8
		btst	#USIF_16Bit,d2			;verlangt
		bne.s	.Bit16
		bra.w	.Error

		*-- 8Bit Daten verlangt --*
.Bit16:		btst	#USIF_16Bit,d0
		bne.s	.SizeOk
		btst	#USIF_8Bit,d0
		beq.w	.Error
		add.l	d1,d1
		bra.s	.Sizeok

		*-- 8Bit Daten verlangt --*
.Bit8:		btst	#USIF_8Bit,d0
		bne.s	.SizeOk
		btst	#USIF_16Bit,d0
		bne.s	.SizeOk
		bra.w	.Error
.Halbieren:	lsr.l	#1,d1
.SizeOk:	move.l	#$10001,d0
		exg	d0,d1
		move.l	d0,d6
		move.l	4,a6
		jsr	_LVOAllocMem(a6)
		move.l	d0,a2
		tst.l	d0
		beq.w	.Error
		
		*- Originalsample jetzt in verlangtes Format konvertieren -*
		move.l	ESA_SampleStruct(a4),a0
		move.w	EPS_Flags(a0),d3
		move.l	EPS_Length(a0),d1
		move.l	EPS_Adr(a0),a0
		move.l	a2,a1

	*-- d1=sourcelen
	*-- d2=Verlangtflags
	*-- d3=sourceflags
.Next16:	move.b	(a0)+,d0		;Source Byte/Word auf
		moveq	#0,d4			;16Bit Motorola/Signed setzen
		btst	#USIF_16Bit,d3
		beq.s	.NoSource16
		move.b	(a0)+,d4
		subq.l	#1,d1
.NoSource16:	btst	#USIF_Intel,d3
		beq.s	.NoSourceIntel
		exg	d0,d4
.NoSourceIntel:	btst	#USIF_Unsigned,d3
		beq.s	.NoSourceUnsigned
		add.b	#$80,d0
.NoSourceUnsigned:


		btst	#USIF_Unsigned,d2
		beq.s	.NoDestUnsigned
		add.b	#$80,d0
.NoDestUnsigned:btst	#USIF_Intel,d2
		beq.s	.NoDestIntel
		exg	d0,d4
.NoDestIntel:	move.b	d0,(a1)+
		btst	#USIF_16Bit,d2
		beq.s	.NoDest16
		move.b	d4,(a1)+
.NoDest16:	subq.l	#1,d1
		bhi.s	.Next16



		*-- Zeiger auf falsche Structure setzen --*
		lea	SampleStructure(a5),a0
		move.l	a2,EPS_Adr(a0)
		move.w	d2,EPS_Flags(a0)
		clr.w	EPS_Type(a0)
		move.l	d6,EPS_Length(a0)

		move.l	ESA_SampleStruct(a4),a1
		move.l	EPS_SampleName(a1),EPS_SampleName(a0)
		move.l	EPS_Repeat(a1),EPS_Repeat(a0)
		move.l	EPS_Replen(a1),EPS_Replen(a0)
		move.l	EPS_Period(a1),EPS_Period(a0)
		move.l	EPS_Volume(a1),EPS_Volume(a0)
		move.w	EPS_Finetune(a1),EPS_Finetune(a0)
		move.w	EPS_MaxNameLen(a1),EPS_MaxNameLen(a0)
		bra.s	.Sampleok


		*--- Saver aufrufen ---*
.Jetzt:		moveq	#0,d6
		move.l	ESA_SampleStruct(a4),a0
.SampleOk:	move.l	ESS_Tags(a3),a6
		move.l	#SS_SaveSample,d0
		bsr	FindTag
		beq.w	.Error
		lea	SaveMem(pc),a2
		lea	PathPuffer(a5),a1

		*- Input:
		*- a0=EPS_SampleStruct
		*- a1=Pfad
		*- a2=Savememroutine
		*- Output:
		*- d0=Error oder NULL
		movem.l	d1-a6,-(a7)
		jsr	(a6)
		movem.l	(a7)+,d1-a6

		move.l	d0,-(a7)
		move.l	d6,d0
		beq.s	.NoMem
		move.l	4,a6
		lea	SampleStructure(a5),a0
		move.l	EPS_Adr(a0),a1
		move.l	a1,d1
		beq.s	.NoMem
		jsr	_LVOFreeMem(a6)
		clr.l	SampleStructure+EPS_Adr(a5)
.NoMem:		move.l	(a7)+,d0
		tst.l	d0
		rts

.UnknownType
.Error:		moveq	#-1,d0
		rts

*------------ verndere die Einstellungen des Listviewgadgets ---------------*
ViewTop:	moveq	#1,d5
		bra.w	SetListView

ViewBotom:	move.l	MaxEntries(a5),d5
		tst.b	Welcheslistview(a5)
		beq.s	.NimmThis
		move.l	MaxSampleEntries(a5),d5
.NimmThis:	*subq.l	#1,d5
		bra.w	SetListView

ViewUp:		moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		tst.b	Welcheslistview(a5)
		beq.s	.NimmThis
		move.l	SelectedSampleEntry(a5),d5
.NimmThis:	cmp.l	#1,d5
		ble.w	Return
		subq.l	#1,d5
		bra.s	SetListView

ViewDown:	moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		move.l	MaxEntries(a5),d4
		tst.b	Welcheslistview(a5)
		beq.s	.NimmThis
		move.l	SelectedSampleEntry(a5),d5
		move.l	MaxSampleEntries(a5),d4
.NimmThis:	*tst.l	d4
		*beq.w	Return
		addq.l	#1,d5
		*cmp.l	#1,d5
		*beq.s	SetListView
		cmp.l	d4,d5
		bhi.w	Return
		bra.s	SetListView

ViewPageUp:	bsr.w	BerechGadAnz
		moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		tst.b	Welcheslistview(a5)
		beq.s	.NimmThis
		move.l	SelectedSampleEntry(a5),d5
.NimmThis:	sub.w	d0,d5
		bhi.s	.IO
		moveq	#1,d5
.Io:		bra.s	SetListView

ViewPageDown:	bsr.w	BerechGadAnz
		moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		move.l	MaxEntries(a5),d4
		tst.b	Welcheslistview(a5)
		beq.s	.NimmThis
		move.l	SelectedSampleEntry(a5),d5
		move.l	MaxSampleEntries(a5),d4
.NimmThis:	tst.l	d4
		beq	Return
		add.w	d0,d5
		cmp.l	d4,d5
		blo.s	.IO
		move.l	d4,d5
.Io:		bra.w	SetListView


SetListView:	move.l	d5,d0
		tst.b	Welcheslistview(a5)
		beq.w	SetModulesEntry
		bra.w	SetSampleEntry


*-----------------------------------------------------------------------------*
ToggleListview:	eor.b	#255,WelchesListview(a5)
		move.l	SelectedEntry(a5),d5
		lea	Formatlist(a5),a4
		moveq	#EPENr_Formatlist,d3
		tst.b	Welcheslistview(a5)
		beq.s	.NimmThis
		lea	Samplelist(a5),a4
		move.l	SelectedSampleEntry(a5),d5
		moveq	#EPENr_Samplelist,d3

		*--- Listview mal flaggern lassen ---*
.NimmThis:	moveq	#3,d4
		subq.l	#1,d5
.Retry:		lea	MyTags(a5),a3
		move.l	#GTLV_Selected,(a3)+
		move.l	#-1,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	d5,(a3)+
		clr.l	(a3)
		move.l	d3,d0
		bsr	GetGadgetAdr
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
		bsr	Delay

		lea	MyTags(a5),a3
		move.l	#GTLV_Selected,(a3)+
		move.l	d5,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	d5,(a3)+
		clr.l	(a3)
		move.l	d3,d0
		bsr	GetGadgetAdr
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
		bsr	Delay
		dbf	d4,.Retry

		rts

*-----------------------------------------------------------------------------*
Delay:		movem.l	d0-a6,-(a7)
		move.l	Dosbase(a5),a6
		moveq	#1,d1
		jsr	_LVODelay(a6)
		movem.l	(a7)+,d0-a6
		rts



*---------------- verndere die Einstellungen des Sliders ------------------*
ViewLeftMarge:	move.l	#MinFreq,d5
		bra.s	SetSlider
ViewRightMarge:	move.l	#MaxFreq,d5
		bra.s	SetSlider

ViewLeft:	move.l	PlayFrequence(a5),d5
		sub.l	#FreqStep,d5
		cmp.l	#MinFreq,d5
		bhi.s	.ok
		move.l	#MinFreq,d5
.Ok:		bra.s	SetSlider

ViewRight:	move.l	PlayFrequence(a5),d5
		add.l	#FreqStep,d5
		cmp.l	#MaxFreq,d5
		blt.s	.ok
		move.l	#MaxFreq,d5
.Ok:		bra.s	SetSlider


ViewPageLeft:	move.l	PlayFrequence(a5),d5
		sub.l	#FreqStep*50,d5
		cmp.l	#MinFreq,d5
		bhi.s	.ok
		move.l	#MinFreq,d5
.Ok:		bra.s	SetSlider

ViewPageRight:	move.l	PlayFrequence(a5),d5
		add.l	#FreqStep*50,d5
		cmp.l	#MaxFreq,d5
		blt.s	.ok
		move.l	#MaxFreq,d5
.Ok:		bra.w	SetSlider

		*--- Slider updaten ---*
SetSlider:	lea	SliderPos(pc),a3
		divu	#FreqStep,d5
		move.l	d5,4(a3)
		moveq	#EPENr_Slider,d0
		bsr	GetGadgetAdr
		*lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		bra.w	Slider



*-------------- Anzahl der angezeigten Items im Listview berechnen -----------*
BerechGadAnz:	moveq	#EPENr_Formatlist,d0
		movem.l	d1/a0/a1,-(a7)
		bsr	GetGadgetAdr		*NotFound ?
		bne.s	.Return
		move.l	WinHandle(a5),d0
		move.l	d0,a1
		move.l	50(a1),a1		*Rastport
		move.l	52(a1),a1		*Font
		moveq	#0,d0
		move.w	20(a1),d0		*FontHhe
		moveq	#0,d1
		move.w	10(a0),d1		*Gadgethhe
		divu	d0,d1
		moveq	#0,d0
		move.w	d1,d0
.Return:	movem.l	(a7)+,d1/a0/a1
		rts


*-----------------------------------------------------------------------------*
* Input: d0=Nummer
*	 a1=Adr des Items !!!!!!!!!!!!!!
*-----------------------------------------------------------------------------*
BackPic:	move.b	MI_Flags(a1),d0
		and	#1,d0

		move.w	PrefsFlags+EUS_Structure(pc),d1
		and.b	#~[PFB_BackPic],d1
		lsl.l	#PFF_BackPic,d0
		or.b	d0,d1
		move.w	d1,PrefsFlags+EUS_Structure

		tst.b	d0
		beq.s	.SetPic
		tst.b	DT_Picturename(A5)			;Test, ob schon Name vorliegt
		bne.s	.SetPic
		lea	DT_PictureDir(a5),a0
		lea	DT_Picturename(a5),a1
		move.w	#LENr_SelectBackPic,d0
		bsr	DT_Filerequest
		bne	.SetPic


		move.l	Winhandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		move.l	a1,-(a7)
		move.l	IntBase(a5),a6
		jsr	_LVOClearMenuStrip(a6)
		move.l	(a7)+,a1
		move	mi_Flags(a1),d0
		and	#~CHECKED,d0
		move	d0,mi_Flags(a1)				;bser,bser Hack...

		move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	_LVOSetMenuStrip(a6)

		moveq	#0,d2
		bra	BackPic

.SetPic:	bsr	LoadNewPicture
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
SelectBackPic:	lea	DT_PictureDir(a5),a0
		lea	DT_Picturename(a5),a1
		move.w	#LENr_SelectBackPic,d0
		bsr	DT_Filerequest
		beq	.Return

		move.w	PrefsFlags+EUS_Structure(pc),d0
		and.b	#PFB_BackPic,d0
		beq	.Return
		bsr	LoadNewPicture
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
About:		moveq	#LENr_AboutText,d0
		moveq	#LENr_Ok,d1
		bsr	TextRequest		;Infotext ausgeben (Requester)
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
Hide:		ifeq	executable+debugger
		move.w	#1,ExitNow(a5)
		moveq	#EPNr_Engine,d0
		bra.w	.Return
		else
		moveq	#0,d1
		moveq	#USClass_Deactivate,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
		endc
.Return:	rts

*-----------------------------------------------------------------------------*
Quit:		*bsr	SaveListBeforeQuitFirst
		move.w	#1,ExitNow(a5)
		bsr	MerkWindowSize
		moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
		rts


******************************************************************************
*---------------- Auswertung einer UserProgram-Message ----------------------*
******************************************************************************
*
*	Achtung 2. Ausgang der Routine bei Exit !!!!!!!!!!!!
*	Achtung 3. Ausgang der Routine bei UserQuitEagle !!!!!!!!!!!!
*
UserMessage:
		if Executable+Debugger
	;	lea	TextPuffer(a5),a0		;Sicherheitshalber
		move.l	d0,a1
		cmp.l	#USM_UserPrg,UM_Type(a1) ;Test auf Analyzer-MSG
		beq.w	.Auswertung
		cmp.l	#USM_Eagleplayer,UM_Type(a1) ;Test auf Analyzer-MSG
		*bne.w	.ReplyIt3
		bne.w	.ReplyIt

	*--------------- Es ist ein Message angekommen ------------*
.Auswertung:	moveq	#0,d0
		move.w	UM_UserNr(a1),d0

		if	debugger
		move.w	UM_UserNr(a1),MerkUserNr(a5)
		endc

		*move.l	UM_ArgString(a1),UPrg_Struct(a5)
		moveq	#0,d0
		moveq	#0,d7
		move.w	UM_Class(a1),d7
		beq.w	.ReplyIt
		cmp.w	#USClass_NewUserPrg,d7
		beq.w	.NewConfig			;.NewUserPrg
		cmp.w	#USClass_Activate,d7
		beq.w	.Activate
		cmp.w	#USClass_Show,d7
		beq.w	.OpenWindow
		cmp.w	#USClass_DeActivate,d7
		beq.w	.DeActivate
		cmp.w	#USClass_Hide,d7
		beq.w	.CloseWindow
		cmp.w	#USClass_ZipWin,d7
		beq.w	.ZipWindow
		cmp.w	#USClass_UnZipWin,d7
		beq.w	.UnZipWindow
		cmp.w	#USClass_NewConfig,d7
		beq.w	.NewConfig
		cmp.w	#USClass_GetConfig,d7
		beq.w	.GetConfig
		cmp.w	#USClass_Exit,d7
		beq.w	.Exit
		cmp.w	#USClass_SetWaitPointer,d7
		beq.w	.WaitPointer
		cmp.w	#USClass_ClearWaitPointer,d7
		beq.w	.ClearPointer
		cmp.w	#USClass_NewPreference,d7
		beq.w	.NewPreference
		cmp.w	#USClass_SaveConfig,d7
		beq.w	.SaveConfig
		cmp.w	#USClass_NewModule,d7
		beq.w	.NewModule
		cmp.w	#USClass_KillModule,d7
		beq.w	.KillModule
		cmp.w	#USClass_Answer,d7
		beq.w	.Answer
		cmp.w	#USClass_EngineCommand,d7
		beq.w	.EngineCommand
		move.l	d7,d0
		bra.w	.ReplyIt

		*--- Das Sample aus dem Moduleinfo wird gesetzt ---*
.EngineCommand:	movem.l	d7/a1,-(a7)
		move.l	MSgPort(a5),a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.EN_ReplyIt

		cmp.l	#EPENr_Samplelist,UM_Command(a1)
		bne.s	.EN_ReplyIt
		move.l	UM_ArgString(a1),d0
		beq.s	.EN_ReplyIt
		move.l	d0,a2			;EPS_Samplestruct
		move.l	ENA_Arg1(a2),a2

		move.l	MaxSampleEntries(a5),d0
		beq.s	.EN_ReplyIt
		subq.l	#1,d0
		lea	Samplelist(a5),a0
		moveq	#0,d2
.EN_GiveStruct:	addq.l	#1,d2
		move.l	(a0),d1
		beq.s	.EN_ReplyIt
		move.l	d1,a0
		cmp.l	ESA_SampleStruct-ESA_Node(a0),a2
		beq.s	.EN_Found
		dbf	d0,.EN_GiveStruct
		bra.s	.EN_ReplyIt

.EN_Found:	move.l	d2,d0
		bsr	SetSampleEntry
		*move.b	#255,WelchesListview(a5)
		bsr	ToggleListview
		
.EN_ReplyIt:	movem.l	(a7)+,d0/a1
		bra.w	.ReplyIt

.Answer:	move.l	d7,-(a7)
		cmp.w	#EPNr_GetSampleInfo,UM_Command+2(a1)
		bne.s	.NoSampleinfo
		bsr	InsertSampleStruct
		bsr	TitleAufbau
.NoSampleinfo:	move.l	(a7)+,d0
		bra.w	.ReplyIt		;Message replyen


.KillModule:	clr.l	SampleInfoLocked(a5)
		bsr	FreeSampleList
		bsr	DeleteEigenList
		bsr	MakeEigenList
		move.l	d7,d0
		bra.w	.ReplyIt

.NewModule:	move.l	d7,-(a7)
	move.w	#1,NoWait(a5)
		bsr	LockSampleInfo
	clr.w	NoWait(a5)
		bsr	DeleteEigenList
		bsr	MakeEigenList
		move.l	(a7)+,d0
		bra.w	.ReplyIt		;Message replyen

	*------- Ankommende Message sagt : "EXIT" -------*
.Exit:		move.w	#1,ExitNow(a5)
		bra.w	.ReplyIt		;Message replyen

	*----- Es wurde ein neue Config eingestellt -----*
.NewConfig:	move.w	EUS_Structure+EUS_Flags(pc),d0
		btst	#EUSF_Activate,d0
		beq.s	.Deactivate
		btst	#EUSF_Show,d0
		beq.s	.Iconify
		btst	#EUSF_ZipWin,d0
		bne.s	.ZipWindow
		bra.s	.OpenWindow

.Iconify:	bsr	CloseWin
		moveq	#USClass_Hide,d0
		bra.s	.ReplyIt

	*- Der Eagleplayer mchte gerne die Config haben -*
.GetConfig:	bsr	MerkWindowSize
		moveq	#USClass_GetConfig,d0
		bra.s	.ReplyIt



	*------ Ankommende Message sagt : "CLOSE MY WINDOW" -----*
.DeActivate:	moveq	#USClass_DeActivate,d7
.CloseWindow:	move.l	d7,-(a7)
		bsr	CloseWin
		move.l	(a7)+,d0
		bra.s	.ReplyIt

	*------ Angekommende Message sagt : "OPEN MY WINDOW" -----*
.Activate:
.OpenWindow:	move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Iconify,d0
		bne.s	.CloseWindow

		*move.w	EUS_Structure+EUS_Flags(pc),d0
		*btst	#EUSF_Show,d0
		*beq.s	.Activated
		bsr.w	OpenWin
		tst.l	d0
		beq.s	.CloseWindow
.Activated:	moveq	#USClass_Activate,d0
		bra.w	.ReplyIt

		*--- Im Eagleplayer "Help" gedrckt" ----*
.NewPreference:	cmp.l	#EPNr_Help,UM_Command(a1)
		bne.s	.ReplyIt
		bsr	ErlaubeGadgets
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "Zip my Window" -------*
.SaveConfig:	move.l	d7,-(a7)
		bsr	SaveConfig
		move.l	(a7)+,d0
		bra.s	.ReplyIt


.WaitPointer:	bsr	WaitPointer
		move.l	d7,d0
		bra.w	.ReplyIt

.ClearPointer:	bsr	ClearPointer
		move.l	d7,d0
		bra.w	.ReplyIt


	*------ Ankommende Message sagt : "Zip my Window" -------*
.ZipWindow:	*bsr.w	ZipMyWindow
		moveq	#USClass_ZipWin,d0
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "UnZip my Window" -----*
.UnZipWindow:	*bsr.w	UnZipMyWindow
		moveq	#USClass_UnZipWin,d0


	*------- Message frs Replyen vorbereiten ------*
	*----------------- Class setzen ----------------*
.ReplyIt:	bsr	ReplayIt
	endc
		rts


*-----------------------------------------------------------------------------*
* Die angegebene Msg wird replayed (auer wenn a1=0)
* Input: a1=Message oder NULL
*	 d0=Userclass
ReplayIt:	movem.l	d0-d7/a0/a2-a6,-(a7)
		bsr.w	FreeCommandStruct
		move.l	a1,d1
		beq.s	.NoMSG
		clr.l	UM_Argstring(A1)
		move.l	a1,a0
		*move.l	UM_StructAdr(a1),StructAdr(a5)
		move.w	d0,UM_Class(a1)			;Dummy setzen
.ReplyIt3:	move.l	a1,d0
		beq.s	.NoMSG
		move.l	MSgPort(a5),a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.ClearMerk
		EB
		jsr	_LVOReplymsg(a6)
.NoMSG:		bra.s	.Return

.ClearMerk:	subq.l	#1,MsgUnterwegs(a5)
		bsr	Freemsg			;meine Message, also freigeben

.Return:	movem.l	(a7)+,d0-d7/a0/a2-a6
		sub.l	a1,a1
		rts

*-----------------------------------------------------------------------------*
MerkWindowSize:	movem.l	d0-a6,-(a7)
		lea	EUS_Structure(pc),a2
		move.w	EUS_Flags(a2),d0
		bclr	#EUSF_OpenWin,d0		*Flags
		move.l	WinHandle(a5),d1
		beq.s	.GetNoWindow
		or.w	#EUSB_OpenWin,d0

		move.w	WinPosX(a5),eus_winx(a2)	;Save Windowpostion
		move.w	WinPosY(a5),eus_winy(a2)
		move.w	WinWidth(a5),EUS_Special(a2)	;Save Windowpostion
		move.w	WinHeight(a5),EUS_Special+2(a2)
		move.w	ZoomposX(a5),Zoomx(a2)
		move.w	ZoomposY(A5),Zoomy(a2)
		move.b	Zoomstate(a5),ZoomONOFF(a2)
		*move.b	Onsysfont(A5),Sysfontonoff(a2)

.GetNoWindow:	move.w	d0,EUS_Flags(a2)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
WaitPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return
		tst.w	WindowDisabled(a5)
		bne.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	MenuAdr(a5),a1
		if	Executable!Debugger
		jsr	ENPP_SetWaitPointer(a4)
		endc

		move.w	#1,WindowDisabled(a5)

.Return:	movem.l	(sp)+,a0/a1/a4/d0
		rts


*-----------------------------------------------------------------------------*
ClearPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.w	WindowDisabled(a5)
		beq.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	MenuAdr(a5),a1
		if	Executable!Debugger
		jsr	ENPP_ClearWaitPointer(a4)
		endc

.Return:	clr.w	WindowDisabled(a5)
		movem.l	(sp)+,a0/a1/a4/d0
		rts





*------------------------------- TextRequest ---------------------------------*
* Input: d0=LocaleNummer						      *
*	 d1=GadgetLocaleNr
* Output:d0=GadgetNr							      *
*-----------------------------------------------------------------------------*
TextRequest:	movem.l	d1-a6,-(a7)
		bsr	GetLocaleString
		move.l	d0,a1				*Text

		bsr	GetReqToolsBase
		beq.s	.Return


		move.l	d1,d0
		bsr	GetLocaleString
		move.l	d0,a2				*Gadgets

		moveq	#LENr_RequestTitle,d0
		bsr	GetLocaleString

		lea	MyTags(a5),a0
		move.l	#_RT_Window,(a0)+
		move.l	WinHandle(a5),(a0)+
		move.l	#_RT_UnderScore,(a0)+
		move.l	#"_",(a0)+
		move.l	#RTEZ_ReqTitle,(a0)+
		move.l	d0,(a0)+
		clr.l	(a0)

		lea	MyTags(a5),a0			;Tags fr Textrequest
		lea	TextRequestArgs(a5),a4			;APTR to Arglist
		sub.l	a3,a3				;Reqtoolsinfo
		move.l	MyReqToolsBase(a5),a6
	*ifeq	Test
		jsr	_LVOrtEZRequestA(a6)		;ersetzen
	*else
	*	moveq	#0,d0
	*endc
.Return:	movem.l	(sp)+,d1-a6	
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Nummer
* Output:d0=Error oder NULL
*	 a0=Structure oder NULL
*-----------------------------------------------------------------------------*
GetSelectedFormatStruct:
		movem.l	d1-d7/a1-a6,-(a7)
		move.l	SelectedEntry(a5),d0
		beq.s	.Error
		subq.l	#1,d0
		lea	Formatlist(a5),a0
.GiveStruct:	move.l	(a0),d1
		beq.s	.Error
		move.l	d1,a0
		dbf	d0,.GiveStruct
		lea	-ESS_Node(a0),a0
		moveq	#0,d0
.Return:	movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

.Error:		moveq	#-1,d0
		sub.l	a0,a0
		bra.s	.Return

*-----------------------------------------------------------------------------*
GetSelectedSampleStruct:
		movem.l	d1-d7/a1-a6,-(a7)
		move.l	SelectedSampleEntry(a5),d0
		beq.s	.Error
		subq.l	#1,d0
		lea	Samplelist(a5),a0
.GiveStruct:	move.l	(a0),d1
		beq.s	.Error
		move.l	d1,a0
		dbf	d0,.GiveStruct
		lea	-ESA_Node(a0),a0
		moveq	#0,d0
.Return:	movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

.Error:		moveq	#-1,d0
		sub.l	a0,a0
		bra.s	.Return



*----------------------- Listview-Gadget wurde gedrckt ----------------------*
Listview:	move.l	FR_StartSeconds(a5),d0
		move.l	FR_StartMicros(a5),d1
		move.l	CurrentSeconds(a5),d2
		move.l	CurrentMicros(a5),d3
		move.l	d2,FR_StartSeconds(a5)
		move.l	d3,FR_StartMicros(a5)
		move.l	SelectedEntry(a5),d4
		addq.l	#1,d5
		*move.l	d5,SelectedEntry(a5)


		*--- Wenn Eagleplayer im Helpmode ---*
		*--- Kommando an EP schicken fr  ---*
		*--- Helpnode                     ---*
		cmp.w	d4,d5
		bne.w	.EinfacherKlick
		move.l	IntBase(a5),a6
		jsr	_LVODoubleClick(a6)

	*------ Listviews & Stringgadgets refreshen ------*
		cmp.l	#1,d0			--> Einfacher Klick
		bne.w	.Return
		clr.l	FR_StartSeconds(a5)
		clr.l	FR_StartMicros(a5)

		bsr	NimmSaver
		bra.s	.Return

.EinfacherKlick:move.l	d5,d0			--> Nummer
		bsr.w	SetModulesEntry
.Return:	rts


*-----------------------------------------------------------------------------*
ListviewSamplelist:
		move.l	SA_StartSeconds(a5),d0
		move.l	SA_StartMicros(a5),d1
		move.l	CurrentSeconds(a5),d2
		move.l	CurrentMicros(a5),d3
		move.l	d2,SA_StartSeconds(a5)
		move.l	d3,SA_StartMicros(a5)
		move.l	SelectedSampleEntry(a5),d4
		addq.l	#1,d5
		*move.l	d5,SelectedSampleEntry(a5)


		*--- Wenn Eagleplayer im Helpmode ---*
		*--- Kommando an EP schicken fr  ---*
		*--- Helpnode                     ---*
		cmp.w	d4,d5
		bne.w	.EinfacherKlick
		move.l	IntBase(a5),a6
		jsr	_LVODoubleClick(a6)

	*------ Listviews & Stringgadgets refreshen ------*
		cmp.l	#1,d0			--> Einfacher Klick
		bne.w	.Return
		clr.l	SA_StartSeconds(a5)
		clr.l	SA_StartMicros(a5)

		bsr	NimmSaver
		bra.s	.Return

.EinfacherKlick:move.l	d5,d0			--> Nummer
		bsr.w	SetSampleEntry
.Return:	rts




*-----------------------------------------------------------------------------*
* Es wurde ein neuer Eintrag angewhlt.
* Input: d0=Neue Nummer (des angewhlten Labels)
SetModulesEntry:movem.l	d1-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.w	.Return

		cmp.l	SelectedEntry(a5),d0
		beq.w	.Return
		move.l	d0,SelectedEntry(a5)


		*--- Gadgets sperren oder erlauben ---*
		*--- Anderen Anzeigelistviews fllen ---*
		subq.l	#1,d0
		lea	MyTags(a5),a3
		move.l	#GTLV_Selected,(a3)+
		move.l	d0,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	d0,(a3)+
		clr.l	(a3)
		moveq	#EPENr_Formatlist,d0
		bsr	GetGadgetAdr
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		bsr	DeleteInfoList
		bsr	MakeInfoList

		bsr	ErlaubeGadgets


		*--- def. Frequenz im Slider setzen ---*
		bsr	GetSelectedFormatStruct
		bne.s	.NoDef
		move.l	ESS_Tags(a0),a6
		move.l	#SS_DefFreqPtr,d0
		bsr	FindTag
		beq.s	.NoDef
		move.l	(a6),PlayFrequence(a5)

		lea	FrequencePuffer(a5),a1
		move.l	(a6),d0
		bsr	Hexdez

		*--- Slider updaten ---*
		lea	SliderPos(pc),a3
		move.l	(a6),d5
		divu	#FreqStep,d5
		move.l	d5,4(a3)
		moveq	#EPENr_Slider,d0
		bsr	GetGadgetAdr
		*lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)



		lea	TextGadgetTags(pc),a3
		moveq	#EPENr_TextGadget,d0
		bsr	GetGadgetAdr
		*lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.NoDef:
.Return:	clr.b	WelchesListView(a5)
		movem.l	(a7)+,d1-a6
		rts


*-------------------------- Entferne List vom Listview -----------------------*
* Input: D0=EPENr_Nummer						      *
*-----------------------------------------------------------------------------*
Remlist:	movem.l	d0-a6,-(sp)
		tst.l	Winhandle(a5)
		beq.s	.Return
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	Mytags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		move.l	#-1,(a3)+
		clr.l	(a3)+
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.Return:	movem.l	(sp)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
DeleteInfoList:
		movem.l	d0-a6,-(a7)
		tst.b	InfoListeDa(a5)
		beq.s	.Return
		moveq	#EPENr_InfoList,d0
		bsr	Remlist
		lea	InfoList(a5),a0
		bsr	DeleteAlist

.Return:	clr.b	InfoListeDa(a5)

		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
DeleteEigenlist:movem.l	d0-a6,-(a7)
		tst.b	EigenlisteDa(A5)
		beq.s	.Return
		moveq	#EPENr_EigenList,d0
		bsr	Remlist
		lea	EigenList(a5),a0
		bsr	DeleteAlist
.Return:	clr.b	EigenListeDa(a5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Input: a0=List
*-----------------------------------------------------------------------------*
DeleteAList:	movem.l	d0-a6,-(a7)
		move.l	a0,d4

.NextNode:	move.l	d4,a0
	;Macro remhead aus exec/lists.i 	A0-list A1-(destroyed) D0=node
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)

		move.l	d0,a1
		move.l	ML_Size(a1),d0
		beq.s	.NextNode
		EB
		jsr	_LVOFreemem(a6)
		bra.s	.NextNode
.empty:		movem.l	(sp)+,d0-a6
		rts


*----------------------------------------------------------------------------*
* Speicher fr Node-Struktur + String anfordern, an Liste anhngen und init  *
*									     *
* Input: a0=StringAdr							     *
*	 a4=Liste							     *
* Output:d0=NUll=Error	L						     *
*----------------------------------------------------------------------------*
AllocTheNode:	movem.l	d1-a6,-(sp)
		move.l	a0,a2
		bsr	BerechStringSize
		EB
		move.l	#$10000,d1
		add.l	#ML_Chars+10,d0
		move.l	d0,d3
		jsr	_LVOAllocmem(a6)
		tst.l	d0
		beq.s	.Error

		move.l	d0,a3
		move.l	a4,a0
		move.l	d0,a1			;(erspart Arbeit)
		addtail
		lea	ML_Chars(a3),a1
		move.l	a1,LN_Name(a3)
		move.l	d3,ML_Size(a3)

		move.w	d3,d1
		sub.w	#ML_Chars+10+1,d1
		move.l	a2,a0
		bsr	StringCopy

		move.l	a3,d0

.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*---------------------------- Node freigeben --------------------------------*
* Input: a0=Node
Freenode:	movem.l	d0-a6,-(sp)
		EB
		move.l	a0,d0
		beq.s	.Return
		move.l	ML_Size(a0),d0
		beq.s	.Return
		jsr	_LVOFreemem(a6)
.Return:	movem.l	(sp)+,d0-a6
		rts


*-------------------- Make Infolist for Samplesaver --------------------------*
* Die Liste mu leer sein !!!
* Input: --
* Output:d0=Error oder NULL
MakeInfoList:	movem.l	d0-a6,-(a7)
		tst.b	InfoListeDa(a5)
		bne.w	.Return

		lea	Infolist(a5),a0
		newlist	a0

		bsr	GetSelectedFormatStruct
		bne.w	.DasWars
		move.l	a0,a3

		lea	InfoList(a5),a4
		move.l	ESS_Tags(a3),a6
		move.l	#SS_Creator,d0
		bsr	FindTag
		beq.s	.NoCreator
		move.l	a6,a0
		lea	InfoList(a5),a1
		*bsr	AllocTheNode
		bsr	TextToNodes

.NoCreator:	lea	Zero(pc),a0
		lea	InfoList(a5),a4
		bsr	AllocTheNode

		move.l	ESS_Tags(a3),a6
		move.l	#SS_Version,d0
		bsr	FindTag
		beq.s	.NoVersion
		lea	TextPuffer(a5),a1
		moveq	#LENr_Version,d0
		bsr	GetLocaleString
		move.l	d0,a0
		move.w	#TextPufferSize-2,d1
		bsr	StringCopy
		move.l	a6,d0
		swap	d0
		and.l	#$ffff,d0
		bsr	Hexdez
		move.b	#".",(a1)+
		move.l	a6,d0
		and.l	#$ffff,d0
		bsr	Hexdez
		
		lea	TextPuffer(a5),a0
		lea	InfoList(a5),a4
		bsr	AllocTheNode
.NoVersion:
		move.l	ESS_Tags(a3),a6
		move.l	#SS_DescriptionLNr,d0
		bsr	FindTag
		beq.s	.NoDescriptionLNr
		move.l	a6,d0
		bsr	GetLocaleString
		move.l	d0,a0
		bra.s	.SetDescription
.NoDescriptionLNr:
		move.l	ESS_Tags(a3),a6
		move.l	#SS_Description,d0
		bsr	FindTag
		beq.s	.NoDescription
		move.l	a6,a0
.SetDescription:lea	TextPuffer(a5),a1
		lea	InfoList(a5),a1
		bsr	TextToNodes

.NoDescription:
.DasWars:	moveq	#EPENr_Infolist,d0
		lea	InfoList(a5),a0
		bsr	ReAddlist
		move.b	#1,InfoListeDa(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts

*----------------------- Make Eigenlist fr Samples --------------------------*
* Die Liste mu leer sein !!!
* Input: --
* Output:d0=Error oder NULL
MakeEigenList:	movem.l	d0-a6,-(a7)
		tst.b	EigenListeDa(a5)
		bne.w	.Return

		lea	Eigenlist(a5),a0
		newlist	a0

		bsr	GetSelectedSampleStruct
		bne.w	.DasWars
		move.l	a0,a3

		*--- Typ setzen ---*
		move.l	ESA_SampleStruct(a3),a2
		moveq	#LENR_Type,d0
		bsr	GetLocaleString
		move.l	d0,a0
		lea	TextPuffer(a5),a1
		move.w	#TextPufferSize-2,d1
		bsr	StringCopy
		moveq	#LENr_RAW,d0
		move.w	EPS_Type(a2),d2
		beq.s	.TypeDa
		moveq	#LENr_IFF,d0
		subq.l	#1,d2
		beq.s	.TypeDa
		moveq	#LENr_SynthFM,d0
		subq.l	#1,d2
		beq.s	.TypeDa
		moveq	#LENr_SynthAM,d0
		subq.l	#1,d2
		beq.s	.TypeDa
		moveq	#LENr_Unknown,d0
.TypeDa:	bsr	GetLocaleString
		move.l	d0,a0
		bsr	Stringcopy

		move.w	EPS_Flags(a2),d2
		btst	#USIF_Unsigned,d2
		beq.s	.NoUnsigned
		moveq	#LENr_Unsigned,d0
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	Stringcopy
.NoUnsigned:	btst	#USIF_Intel,d2
		beq.s	.NoIntel
		moveq	#LENr_Intel,d0
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	Stringcopy

.NoIntel:	lea	TextPuffer(a5),a0
		lea	Eigenlist(a5),a4
		bsr	AllocTheNode

		*--- Aufnahme setzen ---*
		move.l	ESA_SampleStruct(a3),a2
		moveq	#LENR_Aufnahme,d0
		bsr	GetLocaleString
		move.l	d0,a0
		lea	TextPuffer(a5),a1
		move.w	#TextPufferSize-2,d1
		bsr	StringCopy
		moveq	#LENr_8Bit,d0
		move.w	EPS_Flags(a2),d2
		btst	#USIF_8Bit,d2
		bne.s	.AufDa
		moveq	#LENr_16Bit,d0
		btst	#USIF_16Bit,d2
		bne.s	.AufDa
		moveq	#LENr_Unknown,d0
.AufDa:		bsr	GetLocaleString
		move.l	d0,a0
		bsr	StringCopy
		lea	TextPuffer(a5),a0
		lea	Eigenlist(a5),a4
		bsr	AllocTheNode

		*--- Length setzen ---*
		move.l	ESA_SampleStruct(a3),a2
		moveq	#LENR_Length,d0
		bsr	GetLocaleString
		move.l	d0,a0
		lea	TextPuffer(a5),a1
		move.w	#TextPufferSize-2,d1
		bsr	StringCopy
		move.l	EPS_Length(a2),d0
		bsr	Hexdez
		moveq	#LENr_Bytes,d0
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	StringCopy
		lea	TextPuffer(a5),a0
		lea	Eigenlist(a5),a4
		bsr	AllocTheNode



		tst.w	SomeSamplesFailures(a5)
		beq.s	.KeinHinweis
		moveq	#LENr_SomeSamplesFailures,d0
		bsr	GetLocaleString
		move.l	d0,a0
		lea	Eigenlist(a5),a1
		bsr	TextToNodes

.KeinHinweis:
.DasWars:	moveq	#EPENr_Eigenlist,d0
		lea	EigenList(a5),a0
		bsr	ReAddlist
		move.b	#1,EigenListeDa(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts


*----------------------- Liste wieder an Gadget anhngen ---------------------*
* Input: d0=EPENr_Nummer						      *
*	 a0=List							      *
*-----------------------------------------------------------------------------*
Readdlist:	movem.l	d0-a6,-(sp)
		move.l	a0,a2
		tst.l	Winhandle(a5)
		beq.s	.Return

		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	MyTags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		move.l	a2,(a3)+
		clr.l	(a3)
		lea	MyTags(a5),a3

		move.l	WinHandle(a5),a1
		sub.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	movem.l	(sp)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
* a0=Text
* a1=Liste
* Output: d0=Error oder NULL
*-----------------------------------------------------------------------------*
TextToNodes:	movem.l	d1-a6,-(a7)
		move.l	a0,a4
		move.l	a1,d6



	*----------- Width des Listview rausfinden -----------*
	* Kleiner Trick, Gadget im ArchiveInfo ist immer das -*
	* grte					      *
	*-----------------------------------------------------*
		move.l	WinHandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		moveq	#0,d0
		move.w	WD_Width(a0),d0
		moveq	#0,d1
		move.b	WD_BorderLeft(a0),d1
		sub.w	d1,d0
		move.b	WD_BorderRight(a0),d1
		sub.w	d1,d0
		lsr.w	#1,d0
		sub.w	#GadgetXAbstand*5,d0
		
		lea	WD_FirstGadget(a0),a2
		move.l	d0,d1
.FindIt:	move.l	(a2),d2
		beq.w	.AllesFound
		move.l	d2,a2
		move.w	GG_GadgetType(a2),d2		*GadgetID
		btst	#15,d2				*Systemgadget ?
		bne.s	.FindIt
		move.w	GG_Width(a2),d2
		beq.s	.FindIt
		cmp.w	d2,d1
		blo.s	.FindIt
		move.w	d2,d1
		bra.s	.FindIt

.AllesFound:	sub.w	d1,d0
		sub.w	d1,d0
*		sub.w	#5,d0			*move.w	InfoWidth(a5),d0
		move.w	d0,InfoWidth2(a5)




	*---- Text nach Leerzeichen durchsuchen und dann Width testen ----*
.TextSchleife:	move.l	a4,a3
		moveq	#-1,d1
		moveq	#0,d3
.NextB:		addq.l	#1,d1
		move.b	(a3)+,d2
		beq.s	.Zeilenende
		*cmp.b	#"-",d2
		*beq.s	.TestTrennung
		*cmp.b	#",",d2
		*beq.s	.TestTrennung
		cmp.b	#" ",d2
		beq.s	.TestTrennung

		cmp.b	#10,d2
		bne.s	.NextB
.ZeilenEnde:	tst.l	d1
		blt.s	.DasWars
		bsr	.TesteString
		beq.s	.NimmThisString
		bra.s	.EinKurzer

.TestTrennung:	*subq.l	#1,d1
		*blt.s	.DasWars
		*subq.l	#1,a3
		bsr	.TesteString
		beq.s	.NextB		
		*---- String zu lang 1 Word krzer ----*
.EinKurzer:	move.l	d1,d3
		subq.l	#1,a3
.EinKurzer_2:	subq.l	#1,d1
		blt.s	.NimmThisString2
		move.b	-(a3),d2
		*cmp.b	#"-",d2
		*beq.s	.NimmThisString
		*cmp.b	#",",d2
		*beq.s	.NimmThisString
		cmp.b	#" ",d2
		bne.s	.EinKurzer_2
		bra.s	.NimmThisString

		*--- a4=Textstart d1=Size ---*
.NimmThisString2:move.l	d3,d1
.NimmThisString:bsr.s	.ThisStringToNode
		beq.s	.Return				*No Mem
		tst.b	(a4,d1.w)
		beq.s	.DasWars
		lea	1(a4,d1.w),a4
		bra.s	.TextSchleife


.DasWars:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*---------- Pat der String in a4 mit Size in d1 ins Listview ----------------*
.TesteString:	movem.l	d1-a6,-(a7)
		moveq	#EPR_ErrorInArguments,d0
		tst.l	d1
		blt.s	.TesteString_2
		move.b	(a4,d1.w),d2
		move.l	d2,-(a7)
		clr.b	(a4,d1.w)
		move.l	a4,a0
		bsr	GetTextlength
		move.l	(a7)+,d2
		move.b	d2,(a4,d1.w)
		move.l	d0,d1
		moveq	#0,d0
		cmp.w	InfoWidth2(a5),d1
		blt.s	.TesteString_2
		moveq	#EPR_ErrorInString,d0
.TesteString_2:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*------- der String ab a3 wird mit der Lnge von D1 in die Node gehngt ------*
.ThisStringToNode:
		movem.l	d1-a6,-(a7)
		moveq	#0,d0
		tst.l	d1
		blt.s	.ThisError
		move.b	(a4,d1.w),d2
		move.l	d2,-(a7)
		clr.b	(a4,d1.w)
		move.l	a4,a0
		move.l	a4,-(a7)
		move.l	d6,a4
		bsr	AllocTheNode
		move.l	(a7)+,a4
		move.l	(a7)+,d2
		move.b	d2,(a4,d1.w)
.ThisError:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Es wurde ein neuer Eintrag angewhlt.
* Input: d0=Neue Nummer (des angewhlten Labels)
SetSampleEntry:	movem.l	d1-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.w	.Return

		cmp.l	SelectedSampleEntry(a5),d0
		beq.w	.Return
		move.l	d0,SelectedSampleEntry(a5)

		bsr	DeleteEigenList
		bsr	MakeEigenList


		*--- Gadgets sperren oder erlauben ---*
		*--- Anderen Anzeigelistviews fllen ---*
		subq.l	#1,d0
		lea	MyTags(a5),a3
		move.l	#GTLV_Selected,(a3)+
		move.l	d0,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	d0,(a3)+
		clr.l	(a3)
		moveq	#EPENr_Samplelist,d0
		bsr	GetGadgetAdr
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	move.b	#255,WelchesListView(a5)
		moveq	#0,d0
		movem.l	(a7)+,d1-a6
		rts


*-----------------------------------------------------------------------------*
Titleaufbau:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		moveq	#LENr_Windowtitle,d0
		bsr	GetLocaleString
		move.l	d0,a0
		move.w	#TitlePufferSize-2,d1
		lea	TitlePuffer(a5),a1
		bsr	StringCopy

		cmp.l	#10,d1
		blo.s	.Set
		move.l	SelectedEntry(a5),d0
		bsr	Hexdez
		
		moveq	#LENr_Von,d0
		bsr	GetLocaleString
		move.l	d0,a0

		bsr	StringCopy

		cmp.l	#10,d1
		blo.s	.Set
		move.l	MaxEntries(a5),d0
		bsr	Hexdez

.Set:		*moveq	#LENr_ScreenTitle,d0
		*bsr	GetLocaleString
		*move.l	d0,a2
		move.l	EPBase(pc),a2
		move.l	EPG_TitlePuffer(a2),a2

		lea	TitlePuffer(a5),a1
		move.l	WinHandle(a5),a0
		move.l	INtBase(a5),a6
		jsr	_LVOSetWindowTitles(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Zahl
*	 a1=OutputPuffer
* Output:a1=Ende des Outputpuffers
*-----------------------------------------------------------------------------*
Hexdez:		tst.l	d0
		beq.s	.TypeNull
		movem.l	d0-d4/a0,-(a7)
		lea	hexdeztab(pc),a0
		moveq	#0,d4
		moveq	#9,d3
.HexDez1:	move.l	(a0)+,d1
		moveq	#0,d2
.HexDez2:	addq.l	#1,d2
		sub.l	d1,d0
		bcc.s	.Hexdez2
		add.l	d1,d0
		add.b	#$2f,d2
		cmp.b	#$30,d2
		bne.s	.Printealle
		tst.b	d4
		beq.s	.PrinteNoZiffer
.Printealle:	moveq	#1,d4
		move.b	d2,(a1)+
.PrinteNoZiffer:dbf	d3,.Hexdez1
		clr.b	(a1)
		movem.l	(a7)+,d0-d4/a0
		rts
.TypeNull	move.b	#$30,(a1)+
		clr.b	(a1)
		rts

	*-------- Hilfstabelle fr Hex-Dez-Umwandelung --------*
Hexdeztab:	dc.l	1000000000,100000000,10000000,1000000,100000,10000
		dc.l	1000,100,10,1

*-----------------------------------------------------------------------------*
ErlaubeGadgets:	movem.l	d0-a6,-(a7)
		move.l	WinHandle(a5),d0
		beq.s	.Return

		move.l	d0,a0
		move.l	IntBase(a5),a6
		jsr	_LVOClearMenuStrip(a6)

		*-- Gadgets setzen --*
		lea	.GG-6(pc),a3
.NextGadget:	lea	6(a3),a3
		tst.w	(a3)
		beq.s	.SetMenus
		lea	.GG(pc),a1
		move.w	2(a3),d0
		lea	(a1,d0.w),a1			*d1=Zustand der Nr.

		moveq	#0,d1
		move.l	EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Help,d0
		bne.s	.Help
		jsr	(a1)
.Help:		move.w	(a3),d0
		bsr	SetzeGadget
		move.w	4(a3),d0
		beq.s	.NextGadget
		bsr	.SetItem
		bra.s	.NextGadget

.SetMenus:	move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		move.l	IntBase(a5),a6
		jsr	_LVOSetMenuStrip(a6)

.Return:	bsr	Titleaufbau
		movem.l	(a7)+,d0-a6
		rts

	*------------ Menus setzen -------------*
	* Input d0=MenuNr
	*	d1=Zustand 1=Sperren 0=Enablen
.SetItem:	move.w	d0,d2
		and.w	#$1f,d2
		*subq.w	#1,d2
		lea	MenuAdr(a5),a0
.NextMenu:	move.l	(a0),d3
		beq.s	.Ret
		move.l	d3,a0
		dbf	d2,.NextMenu

		move.l	d0,d2
		and.l	#$7e0,d2
		lsr.l	#5,d2
		lea	MU_FirstItem(a0),a0
.NextItem:	move.l	(a0),d3
		beq.s	.Ret
		move.l	d3,a0
		dbf	d2,.NextItem

		move.l	d0,d2
		and.l	#$f800,d2
		cmp.l	#$f800,d2
		beq.s	.NoSubMenu
		lsr.l	#8,d2
		lsr.l	#3,d2
		lea	MI_SubItem(a0),a0
.NextSubItem:	move.l	(a0),d3
		beq.s	.Ret
		move.l	d3,a0
		dbf	d2,.NextSubItem

.NoSubMenu:	move	mi_Flags(a0),d0
		and	#~ITEMENABLED,d0
		tst.w	d1
		bne.s	.Off
		or	#ITEMENABLED,d0
.Off:		move	d0,mi_Flags(a0)
.Ret:		rts

* d1=0 -> on
.GG:
		dc.w	EPENr_Slider,GGZS_NurSamples-.GG,0
		dc.w	EPENr_Play,GGZS_Play-.GG,0
		dc.w	0


GGZS_NurSamples:
		moveq	#1,d1
		bsr	GetSelectedFormatStruct
		bne.s	.Return
		move.l	ESS_Tags(a0),a6
		move.l	#SS_Flags,d0
		bsr	Findtag
		beq.s	.Return
		move.l	a6,d2
		btst	#SSB_FrequencyVariable,d2
		beq.s	.Return
		moveq	#0,d1
.Return:	rts


GGZS_Play:	moveq	#1,d1
		bsr	GetSelectedSampleStruct
		bne.s	.Return
		move.l	ESA_Samplestruct(a0),a0
		move.w	EPS_Flags(a0),d0
		btst	#USIF_Playable,d0
		beq.s	.Return
		moveq	#0,d1
.Return		rts


*---------------------------- Setze dieses Gadget ----------------------------*
* Input: d0=Nummer des Gadgets
*	 d1=Zustand 0=on 1=off
*-----------------------------------------------------------------------------*
SetzeGadget:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		bsr	GetGadgetAdr			*a0=Gadgetadr
		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)+
		move.l	d1,(a3)+
		clr.l	(a3)
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
		
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
UpdateMenus:	movem.l	d0-a6,-(a7)
		move.w	EUS_Structure+PrefsFlags(pc),d0


		move.w	#CHECKIT!Menutoggle,d1
		btst	#PFF_BackPic,d0
		beq.s	.NoBackPic
		or.w	#CHECKED,d1
.NoBackPic:	move.w	d1,BackPicFlags


		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
OpenWin:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5
		tst.l	WinHandle(a5)
		beq.s	.Oeffnen

		move.l	WinHandle(a5),a0
		move.l	IntBase(a5),a6
		jsr	_LVOWindowToFront(a6)
		move.l	WinHandle(a5),a0
		jsr	_LVOActivateWindow(a6)
		bra.s	.WindowDa

.Oeffnen:	bsr	UpdateMenus

		move.l	Intbase(a5),a6
		bsr	LockPubscreen		;Public Screen holen
		bne	.Error
		bsr	SetUpWin		;Fenster ffnen
		tst.l	d0
		bne.w	.Error


.Error:	
.WindowDa	move.l	WinHandle(a5),d0
		movem.l	(a7)+,d1-a6
		rts


*-----------------------------------------------------------------------------*
* Fenster ffnen, mit Menu & Gadgets sowie Sizeanpassung		      *
* Input: --								      *
* Output: d0=Error oder NULL						      *
*-----------------------------------------------------------------------------*
SetUpWin:	movem.l d1-a6,-(sp)
		clr	tmpwidth(A5)
		clr	tmpheight(A5)

		bsr	InitLocale


		move.l	MyPubscreen(a5),d0
		beq.w	.Error
		move.l	d0,a0
		move.l	SC_Font(a0),a1
		move.w	TA_YSize(a1),d3
		addq.w	#1,d3
		move.b	sc_WBorTop(a0),d0
		ext.w	d0
		add.w	d3,d0
		move.w	d0,OffY(a5)

		move.b  SC_WBorLeft(a0),d0
		ext.w   d0
		move.w	d0,Offx(a5)

		move.l	sc_RastPort+rp_Font(a0),a0
		lea	MyFont(a5),a1
		move.l	a1,Font(a5)
		move.l  LN_Name(a0),ta_Name(a1)
		move.w  tf_YSize(a0),ta_YSize(a1)
		move.w  tf_XSize(a0),FontX(a5)
		move.w  tf_YSize(a0),FontY(a5)
		clr.w	6(a1)


		bsr	BerechMinWindowSize


	*--------------- Gre des Fensters festlegen --------------*
		moveq	#0,d2
		moveq	#0,d3
		move.w	EUS_Structure+EUS_Special(pc),d2
		move.w	EUS_Structure+EUS_Special+2(pc),d3
		bne.s	.NimmDiese

		moveq	#0,d0			*Keine Eintragung
		move.w	FontY(a5),d0		*--> Fonthhe *6
		mulu	#6,d0
		add.w	d0,d3
		move.l	#200,d2

		*----- Ist diese Gre erlaubt ? -----*
.NimmDiese:	cmp.w	Win_MinHeight+2(pc),d3
		bhi.s	.HeightOk
		move.l	Win_MinHeight(pc),d3
.HeightOk:	cmp.w	Win_MinWidth+2(pc),d2
		bhi.s	.WidthOk
		move.l	Win_MinWidth(pc),d2
.WidthOk:	move.l	mypubscreen(A5),a0
		move.l	d2,ahawidth
		move.l	d3,ahaheight

		*--- Pat Window in Screen ---*
		move.l	d2,d0
		move.l	d0,d4
		moveq	#0,d2
		add.w	d2,d0
		add.w	OffX(a5),d0
		move.b	sc_WBorRight(a0),d1
		ext.w	d1
		add.w	d1,d0
		cmp.w	sc_Width(a0),d0
		bls.s	.WinWidthOk
		move.w	sc_Width(a0),d0
		sub.w	d4,d0
		move.w	d0,d2			*-> nein, jetzt
.WinWidthOk:	move.l	d3,d0
		move.l	d0,d4

		*-- Menus creieren ---*
		move.l	GadBase(a5),a6
		lea	Menus(pc),a0
		lea	MenuTags(pc),a1
		jsr	_LVOCreateMenusA(a6)
		move.l	d0,MenuAdr(a5)
		tst.l	d0
		beq	.Error
		move.l	d0,a0
		move.l	VisualInfo(a5),a1
		lea	MenuTags(pc),a2
		jsr	_LVOLayoutMenusA(a6)

		moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		moveq	#0,d7
		move	WinPosX(a5),d0
		move	WinPosY(a5),d1
		move	ZoomPosX(a5),d2
		move	ZoomPosY(a5),d3
		move.l	ahawidth(pc),d4
		move.l	ahaheight(pc),d5
		*move.l	#ZoomWidth,d6

		move.l	mypubscreen(A5),a0
		lea	sc_RastPort(a0),a0
		move.l	rp_Font(a0),a0
		move.w  tf_XSize(a0),d6
		mulu	#ZoomWidth,d6
		addq	#4,d6
		lsr	#3,d6
		move	OffY(a5),d7
		tst.b	ZoomState(a5)
		beq.s	.Normal
		exg.l	d0,d2
		exg.l	d1,d3
		exg.l	d4,d6
		exg.l	d5,d7
.normal:	lea	WindowTags(pc),a1
		move.l	d0,Win_LeftPos-WindowTags(A1)
		move.l	d1,Win_TopPos-WindowTags(A1)
		move.l	d4,Win_Width-WindowTags(A1)
		move.l	d5,Win_Height-WindowTags(A1)
		move.w	d2,ZoomStruct-WindowTags(A1)
		move.w	d3,ZoomStruct+2-WindowTags(A1)
		move	d6,ZoomStruct+4-WindowTags(A1)
		move	d7,ZoomStruct+6-WindowTags(A1)

		move.l	IntBase(A5),a6
		move.l	MyPubScreen(a5),Pubadr-WindowTags(a1)
		suba.l	a0,a0
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,Winhandle(a5)
		tst.l	d0
		beq	.OpenWindowError

		move.l	WinHandle(a5),a0
		move.w	wd_leftedge(a0),WinPosX(a5)
		move.w	wd_topedge(a0),WinPosY(a5)
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)

		move.l	d0,a0
		move.l	WD_RPort(a0),a0
		move.l	a0,MyRastPort(a5)

		bsr	InitBackdrop


		if	BackPicture
		bsr	ClearWindow
		endc

		bsr	InitGadgets
		bne	.GadgetError

		bsr	RedrawGadgets
		
		bsr	AddGads
		bne	.GadgetError

		bsr	ErlaubeGadgets


		move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	_LVOSetMenuStrip(a6)

		move.l	Winhandle(a5),a0
		move.l	WD_Userport(a0),a0	;User Port
		move.l	a0,WindowPort(a5)
		moveq	#0,d0

	*--------------- SignalBits setzen ---------------*
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)
		moveq	#0,d0


.SetUpReturn:	movem.l	(sp)+,d1-a6
		tst.l	d0
		rts

.GadgetError	bsr	Closedownwindow
.OpenWindowError:bsr	FreeMenus
.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.SetUpReturn



*----------------------------- Window lschen --------------------------------*
ClearWindow:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.w	.Return
		tst.l	MyRastPort(a5)
		beq.w	.Return

		tst.l	DT_PicObject(a5)
		bne	.DT_CopyTiledBitMap

		move.l	winhandle(A5),a1
		move.w	wd_width(A1),d2		;x2
		moveq	#0,d0
		move.b	wd_borderright(a1),d0
		sub.w	d0,d2

		move.w	wd_height(a1),d3
		moveq	#0,d0
		move.b	wd_borderbottom(a1),d0
		sub.w	d0,d3

		move.w	Offx(a5),d0		;x1
		move.w	Offy(A5),d1		;y1

		bsr	ClearRectangle
		bra.s	.Refresh

.DT_CopyTiledBitMap:
		bsr	FillWithBackPic
.Refresh:
		move.l	winhandle(A5),a0
		move.l	IntBase(a5),a6
		jsr	_LVORefreshwindowframe(A6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*--------------- lscht den angegebenen Bereich --------------------*
* Input: D0 = Leftedge
*        D1 = Topedge
*        D2 = Width
*        D3 = Height
ClearRectangle:
		push	all
		move.l	GFXBase(a5),a6

		move.l	Winhandle(a5),d4
		beq	.fail
		move.l	d4,a1

		push	d0-d3

		move.l	wd_rport(a1),a1
		move.l	a1,a3
		moveq	#0,d0
		jsr	_LVOsetapen(a6)

		move.l	a3,a1
		moveq	#0,d0
		jsr	_LVOsetbpen(A6)

		move.l	a3,a1
		moveq	#1,d0			;RP_Jam2
		jsr	_LVOsetdrmd(a6)

		pop	d0-d3
		add	d0,d2
		add	d1,d3
		move.l	a3,a1
		jsr	_LVOrectfill(a6)
.fail
		pop	all
		rts

*-----------------------------------------------------------------------------*
*        Alle Gadgets, die Text enthalten lschen wg. Hintergrundbild         *
*        die Positionen werden aus den NewGadget-Strukturen gezogen           *
*-----------------------------------------------------------------------------*
RedrawGadgets:
		push	all
		lea	Refreshed_Gads(pc),a4
.loop
		move.l	(a4)+,d0		;Adresse Gadget
		beq	.return
		move.l	d0,a0

		move.w	(a4)+,d1		;Flagbit holen, Indikator ob an oder aus
		move	d1,d2
		and	#$7fff,d1
		beq.s	.doit			;Fehler
		and	PrefsFlags+EUS_Structure(pc),d1
		beq	.loop			;Gadget ist aus...
.doit
		move.w	gng_LeftEdge(a0),d0

		move.w	gng_TopEdge(a0),d1
		add.w	OffY(a5),d1
		addq.w	#GadgetYAbstand,d1

		add.w	OffX(a5),d0
		addq.w	#GadgetXAbstand,d0

		moveq	#0,d3
		move.w	gng_Height(a0),d3
		and	#$8000,d2
		beq.s	.nolist
		sub	#ListviewBorder,d3
		move.l	font(a5),a1
		move	ta_ysize(a1),d2
		divu	d2,d3
		mulu	d2,d3
		add	#ListviewBorder,d3
.nolist
		move.w	gng_Width(a0),d2
		bsr	ClearRectangle

		bra	.loop
.return
		pop	all
		rts
*-----------------------------------------------------------------------------*
* Init Backdrop (fr OpenWindow)
*-----------------------------------------------------------------------------*
InitBackdrop:	movem.l	d0-a6,-(a7)

	*-------- Halfshine Pen fr Hintergrund anfordern oder Pic Init ----------------*
		move.l	#-1,mypen(A5)

		move.w	PrefsFlags+EUS_Structure(pc),d0
		and.b	#PFB_BackPic,d0		;Bit 1 = Back Pic
		beq.s	.pen

		bsr	DT_OpenPicture		;Bild ffnen
		bne.s	.Return			;bei Fehler dann doch Pen
.pen
		move.l	GFXBase(A5),a6
		cmp.w	#39,lib_version(A6)
		blo	.Return

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		move.l	a0,mycmap(A5)
		moveq	#-1,d0			;Number
		move.l	#123<<24,d1		;Red
		move.l	#123<<24,d2		;Green
		move.l	#123<<24,d3		;Blue

		lea	Mytags(A5),a1
		move.l	#OBP_Precision,(a1)
		move.l	#PRECISION_GUI,4(a1)
		clr.l	8(A1)
		jsr	_LVOObtainBestPenA(A6)
		move.l	d0,MyPen(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FillWithBackPic:
*		tst.l	DT_PicObject(a5)
*		bne	.DT_CopyTiledBitMap
*		movem.l	d0-a6,-(a7)
*		move.l	WinHandle(a5),a4
*		move.l	WD_RPort(a4),a1
*
*		move.l	myPen(a5),d0
*		bpl.s	.yup
*		moveq	#0,d0
*.yup
*		move.l	GFXBase(a5),a6
*		jsr	_LVOSetAPen(a6)			; set the pen
*
*		*move.l	winhandle(A5),a1
*		*move.l	wd_rport(a1),a1
*		*moveq	#1,d0
*		*jsr	_LVOsetbpen(A6)
*
*
*		move.l	wd_rPort(a4),a1
*		move.b	wd_borderleft(a4),d0
*		ext.w	d0
*		move.b	wd_bordertop(a4),d1
*		ext.w	d1
*		move.b	wd_borderright(a4),d2
*		ext.w	d2
*		neg.w	d2
*		move.b	wd_borderbottom(a4),d3
*		ext.w	d3
*		neg.w	d3
*		subq	#1,d2
*		subq	#1,d3
*		add.w	wd_width(a4),d2
*		add.w	wd_height(a4),d3
*
*		move.l	GFXBase(a5),a6
*		jsr	_LVOrectfill(a6)		;Hintergrund killen
*
*		movem.l	(a7)+,d0-a6
*		rts


;void CopyTiledBitMap(void)
;Slow but Mem-Saving routine
.DT_CopyTiledBitMap:
		push	d1-d7/a1/a3/a4/a6
		move.l	GFXBase(a5),a6

		move.l	Winhandle(A5),a0
		moveq	#0,d0
		moveq	#0,d1
		move.w	wd_width(a0),d0
		move.b	wd_borderleft(A0),d1
		add.b	wd_borderRight(A0),d1
		sub.l	d1,d0
		move.l	d0,DT_Breit2(A5)
		
		move.w	wd_height(a0),d0
		move.b	wd_bordertop(A0),d1
		add.b	wd_borderbottom(A0),d1
		sub.l	d1,d0
		move.l	d0,DT_Hoehe2(A5)

		moveq	#0,d0
		move.b	wd_borderleft(a0),d0
		move.l	d0,DT_XPos2(a5)

		move.b	wd_borderTop(a0),d0
		move.l	d0,DT_YPos2(a5)

		move.l	DT_MyBitMapheader(a5),a0
		moveq	#0,d0
		move.w	(a0)+,d0
		move.l	d0,a4			; SrcSizeX
		move.w	(a0),d0
		move.l	d0,a3			; SrcSizeY

		moveq	#256-$c0,d6
		neg.b	d6

		move.l	Winhandle(A5),a1
		move.l	WD_Rport(a1),a1
		move.l	a1,-(sp)

		moveq	#0,d2				; dest x
		moveq	#0,d3				; dest y
.MainLoop
		move.l	a4,d4				; SrcSizeX

		move.l	d2,d7				; dest x
		cmp.l	DT_Breit2(A5),d7		; Row copied ?
		blt.s	.Xweit
		add.l	a3,d3				; Yup, next Row
		moveq	#0,d2				; dest x
		moveq	#0,d7
.XWeit
		add.l	d4,d7				; pos x + SrcSizeX
		cmp.l	DT_Breit2(a5),d7		; dest x (left) < DestX+SrcSizeX ?
		blt.s	.skip1
		move.l	DT_Breit2(A5),d4		; DestSizeX
		sub.l	d2,d4				; - Dest X = Dest Left
.skip1		
		move.l	a3,d5
		move.l	d3,d7
		cmp.l	DT_Hoehe2(A5),d7
		bge.s	.YReady
		add.l	d5,d7				; pos y + SrcSizeY
		cmp.l	DT_Hoehe2(a5),d7		; dest y (left) < DestY+SrcSizeY ?
		blt.s	.skip2
		move.l	DT_Hoehe2(A5),d5		; DestSizeY
		sub.l	d3,d5				; - Dest Y = Dest Left
.skip2
		add.l	DT_XPos2(A5),d2			; Xpos + Winborder
		add.l	DT_YPos2(A5),d3			; YPos + Winborder
		move.l	(sp),a1
		move.l	DT_MyBitMap(a5),a0		; Source
		moveq	#0,d0
		moveq	#0,d1
		jsr	_LVOBltBitMapRastport(a6)
		sub.l	DT_XPos2(A5),d2			; del Border
		sub.l	DT_YPos2(A5),d3			; del Border
		add.l	a4,d2
		bra.s	.Mainloop

.YReady:	addq.l	#4,sp
		pop	d1-d7/a1/a3/a4/a6
		rts


*-----------------------------------------------------------------------------*
LoadNewPicture:	movem.l	d0-a6,-(a7)

	*-------- Bild freigeben (wenn vorhanden) -----------------------*
.RetryPic:	bsr	DT_FreePicture

	*-------- Halfshine Pen fr Gadgets freigeben -------------------*
		move.l	GFXBase(a5),a6
		cmp.w	#39,lib_version(A6)
		blo	.kick20
		move.l	mypen(A5),d0
		move.l	mycmap(A5),a0
		jsr	_LVOReleasepen(A6)

	*-------- Halfshine Pen fr Hintergrund anfordern oder Pic Init ----------------*
.Kick20		move.l	#-1,mypen(A5)

		move.w	EUS_Structure+PrefsFlags(pc),d0
		and.w	#PFB_BackPic,d0		;Bit 1 = Back Pic
		beq.s	.pen

		bsr	DT_OpenPicture		;Bild ffnen
		bne.s	.kick2			;bei Fehler dann doch Pen
.pen
		move.l	GFXBase(a5),a6
		cmp.w	#39,lib_version(a6)
		blo	.kick2

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		move.l	a0,mycmap(a5)
		moveq	#-1,d0			;Number
		move.l	#123<<24,d1		;Red
		move.l	#123<<24,d2		;Green
		move.l	#123<<24,d3		;Blue

		lea	mytags(A5),a1
		move.l	#OBP_Precision,(a1)
		move.l	#PRECISION_GUI,4(a1)
		clr.l	8(A1)
		jsr	_LVOObtainBestPenA(A6)
		move.l	d0,mypen(A5)
.Kick2		bsr	Resizewindow
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Gibt des Backpic frei
DT_FreePicture:	movem.l	d0-a6,-(a7)

		move.l	DT_PicObject(A5),d0
		beq.s	.fail
		move.l	DatatypesBase(a5),a6
		move.l	d0,a0
		jsr	_LVODisposeDTObject(a6)
		clr.l	DT_PicObject(A5)
		clr.l	DT_MyBitMapheader(a5)
		clr.l	DT_MyBitMap(a5)
.fail		moveq	#0,d0
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input:	d0=LocaleNr fr Title des Requesters
*		a0=Dir
*		a1=Filename
* Output:d0=Null=Error d0<>0 ok (MultiSelectZeiger)
*-----------------------------------------------------------------------------*
DT_MultiFileRequest2:
		movem.l	d1-a6,-(a7)
		move.l	#FREQF_MULTISELECT,d6
		bra.s	DT_FileReq2

DT_MultiFileRequest:
		movem.l	d1-a6,-(a7)
		move.l	#FREQF_MULTISELECT!FREQF_SELECTDIRS,d6
		bra.s	DT_FileReq2

DT_Filerequest:	movem.l	d1-a6,-(a7)
		moveq	#0,d6
DT_FileReq2:

	move.l	a0,a3
	move.l	a1,a2
	move.l	d0,d4
		bsr	GetReqToolsBase
		beq.s	.Return

		sub.l	a0,a0
		moveq	#0,d0				;Struktur-Type
		jsr	_LVORTAllocRequestA(a6)
		move.l	d0,d7
		beq.s	.fail

		lea	mytags(A5),a0
		move.l	#_RTFI_Dir,(A0)+
		move.l	a3,(a0)+
		clr.l	(A0)	
		lea	mytags(A5),a0
		move.l	d7,a1
		jsr	_LVORTchangereqattrA(A6)

		move.l	d4,d0
		bsr	GetLocaleString
		move.l	a3,-(a7)
		move.l	d0,a3
		lea	mytags(A5),a0
		move.l	#_RT_Window,(a0)+
		move.l	winhandle(a5),(a0)+
		tst.l	d6
		beq.s	.NoFlags
		move.l	#_RTFI_Flags,(a0)+
		move.l	d6,(a0)+
.NoFlags:
	;	move.l	#_RT_LockWindow,(a0)+
	;	move.l	#1,(a0)+
		clr.l	(A0)
		lea	mytags(A5),a0
		move.l	d7,a1
		jsr	_LVORTFilerequestA(A6)
		move.l	(a7)+,a3
		move.l	d0,d6

		move.l	d7,a0
		move.l	rtfi_Dir(a0),a0
		lea	(a3),a1
		move.w	#200-1,d1
		bsr	StringCopy

		move.l	d7,a1
		jsr	_LVORTFreerequest(A6)
		move.l	d6,d0

.Fail:
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
DT_OpenPicture:	movem.l	d1-a6,-(a7)

		moveq	#0,d0
		move.l	DT_PicObject(a5),d1
		bne.w	.fail
		move.l	winhandle(a5),d0
		beq.w	.fail

		move.l	DatatypesBase(a5),d0
		bne.w	.Ok
		lea	Datatypesname(pc),a1
		moveq	#39,d0
		EB
		jsr	_LVOopenlibrary(a6)
		move.l	d0,DatatypesBase(a5)
		tst.l	d0
		beq.w	.Fail
.Ok:


		lea	DT_Picture(a5),a0
		lea	DT_Picturedir(a5),a1
.copy		move.b	(a1)+,(a0)+
		bne.s	.copy
		subq.l	#1,a1

		lea	DT_Picture(a5),a0
		move.l	a0,d1
		lea	DT_Picturename(a5),a0
		move.l	a0,d2
		move.l	#300,d3
		move.l	DosBase(a5),a6
		jsr	_LVOAddPart(A6)

		move.l	DatatypesBase(a5),a6
		lea	mytags(A5),a0
		move.l	#DTA_Sourcetype,(a0)+
		move.l	#DTST_File,(a0)+
		move.l	#DTA_GroupID,(a0)+
		move.l	#GID_Picture,(a0)+
		move.l	#PDTA_Remap,(a0)+
		move.l	#1,(a0)+
		move.l	#PDTA_Screen,(a0)+
		move.l	winhandle(A5),a1
		move.l	wd_WScreen(a1),(a0)+
		move.l	#PDTA_FreeSourceBitMap,(a0)+
		move.l	#1,(a0)+
		move.l	#OBP_Precision,(a0)+
		move.l	#Precision_IMAGE,(A0)+
		clr.l	(a0)+
		lea	mytags(A5),a0

		*ifne	test
		*lea	DT_PicName(pc),a1
		*else
		lea	DT_Picture(a5),a1
		*endc
		move.l	a1,d0
		jsr	_LVONewDTObjectA(A6)
		move.l	d0,DT_PicObject(A5)
		beq.w	.fail

		move.l	#1,-(a7)		;Taglist ??
		move.l	#0,-(a7)		;
		move.l	#DTM_ProcLayout,-(a7)	;
		push	d0
		bsr	_DoMethod	
		add	#4*4,sp
		tst.l	d0
		beq	DT_FreePicture

		lea	mytags(A5),a2
		move.l	#PDTA_BitMapHeader,(a2)+
		lea	DT_MyBitMapheader(a5),a0
		move.l	a0,(a2)+
		move.l	#PDTA_DestBitMap,(a2)+
		lea	DT_MyBitMap(a5),a0
		move.l	a0,(A2)+
		clr.l	(A2)
		lea	mytags(A5),a2
		move.l	DT_PicObject(A5),a0
		move.l	DatatypesBase(a5),a6
		jsr	_LVOGetDTAttrsA(A6)
		cmp.l	#1,d0
		blt	DT_FreePicture
		tst.l	DT_MyBitMap(A5)
		bne.s	.attrok

		lea	mytags(A5),a2
		move.l	#PDTA_BitMap,(a2)+
		lea	DT_MyBitMap(a5),a0
		move.l	a0,(A2)+
		clr.l	(A2)
		lea	mytags(A5),a2
		move.l	DT_PicObject(A5),a0
		jsr	_LVOGetDTAttrsA(A6)
		tst.l	DT_MyBitMap(A5)
		beq	DT_FreePicture
.attrok:	moveq	#1,d0
.fail		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

;ULONG DoMethod( Object *obj, unsigned long MethodID, ... ); from Amiga.lib
_DoMethod:	move.l	a2,-(sp)
		movea.l	8(sp),a2		;*obj
		move.l	a2,d0
		beq.s	.cmnullreturn
		lea	12(sp),a1		;methodid, ...
		movea.l	-4(a2),a0
		pea	.cmreturn(pc)
		move.l	8(a0),-(sp)
		rts
.cmnullreturn:	moveq	#0,d0
.cmreturn:	movea.l	(sp)+,a2
		rts


*-----------------------------------------------------------------------------*
ResizeWindow:	movem.l	d0-a6,-(a7)
		move.l	IntBase(a5),a6
		move.l	WinHandle(a5),a0
		jsr	_LVORefreshWindowFrame(a6)

		move.l	GadgetListAdr(a5),d0
		beq.s	.NoGadgets
		move.l	d0,a1
		moveq	#0,d0
		move.w	RealNumGadgets(a5),d0
		move.l	Winhandle(a5),a0
		move.l	Intbase(a5),a6
		jsr	_LVORemoveGList(a6)
.NoGadgets:	bsr	FreeGadgets
		bsr	Clearwindow
		bsr	InitGadgets
		bne.w	.Return

		bsr	RedrawGadgets

		bsr	AddGads

		bsr	ErlaubeGadgets
		*bne	.Return
		*bsr	EinTragNeu

		move.l	Gadbase(a5),a6
		move.l	Winhandle(a5),a0	;*Window
		jsr	_LVOGT_beginrefresh(a6)

		move.l	Winhandle(a5),a0	;*Window
		moveq	#1,d0
		jsr	_LVOGT_Endrefresh(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
Closewin:	movem.l	d0-a6,-(a7)
		lea	Puffer,a5
		tst.l	WinHandle(a5)
		beq.s	.KeinWindow
		bsr	MerkWindowSize
		bsr	Closedownwindow
.KeinWindow:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
Closedownwindow:movem.l d0-a6,-(a7)

		move.l	WinHandle(a5),d0
		beq.s	.Return
		move.l	d0,a0
		move.l	86(a0),a1			;MsgPort des Windows
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)

		bsr	DeleteInfoList
		bsr	DeleteEigenList

		move.l	IntBase(a5),a6
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOCloseWindow(a6)
.NoWindow:	clr.l	Winhandle(a5)
		clr.l	WindowPort(a5)
		clr.l	MyRastPort(a5)
		clr.w	WindowDisabled(a5)

		bsr	FreeMenus
		bsr	FreeGadgets
		bsr	FreeLocale

		bsr	UnlockPubScreen
.Return:	bsr	DT_FreePicture
		movem.l (sp)+,d0-a6
		rts


*--------------------------- Gadgets freigeben -------------------------------*
FreeGadgets:	movem.l	d0-a6,-(a7)

		bsr	DeleteInfoList
		bsr	DeleteEigenList

		move.l	GadBase(a5),a6
		move.l	GadgetListAdr(a5),d0
		move.l	d0,a0
		beq	.NoGadgets
		jsr	_LVOFreeGadgets(a6)
.NoGadgets:	clr.l	GadgetListAdr(a5)

		lea	GadgetMerkPuffer(a5),a0
		move.l	#GadgetAnz-1,d1
.ClrPuffer:	clr.l	(a0)+
		dbf	d0,.ClrPuffer
		movem.l	(a7)+,d0-a6

		clr.b	ListeDa(a5)
		clr.b	SampleListeDa(a5)
		clr.b	EigenListeDa(a5)
		clr.b	InfoListeDa(a5)
		rts

*-----------------------------------------------------------------------------*
FreeMenus:	movem.l	d0-a6,-(a7)
		move.l	IntBase(a5),a6
		move.l	MenuAdr(a5),d0
		move.l	d0,a0
		beq	.NoMenu
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOClearMenuStrip(a6)
.NoWindow:	move.l	GadBase(a5),a6
		move.l	MenuAdr(a5),d0
		beq.s	.NoMenu
		move.l	d0,a0
		jsr	_LVOFreeMenus(a6)
.NoMenu:	clr.l	MenuAdr(a5)
		movem.l	(a7)+,d0-a6
		rts

*----------------------------- Lock PubScreen --------------------------------*
LockPubScreen:	movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	IntBase(a5),a6
		lea	EUS_Structure(pc),a0
		move.l	EUS_EPBase(a0),d0
		beq.s	.KeinEP
		move.l	d0,a0
		move.l	EPG_Pubscreen(a0),d0
		*move.w	EPG_Wordreserved7(a0),word7(a5)
.KeinEp:	move.l	d0,a0
		jsr	_LVOLockPubScreen(a6)
		move.l	d0,MyPubscreen(a5)
		tst.l	d0
		beq.s	.Return

		move.l	Mypubscreen(a5),a0
		move.l	GadBase(a5),a6
		suba.l	a1,a1
		jsr	_LVOGetVisualInfoA(a6)
		move.l	d0,VisualInfo(a5)
		tst.l	d0
		beq.s	.Return
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

*------------------------------ Unlock PubScreen -----------------------------*
UnlockPubScreen:movem.l	d0-a6,-(a7)
		move.l	GadBase(a5),a6
		move.l	VisualInfo(a5),d0
		beq.s	.NoVisualInfo
		move.l	d0,a0
		jsr	_LVOFreeVisualInfo(a6)
		clr.l	VisualInfo(a5)
.NoVisualInfo:	move.l	IntBase(a5),a6
		suba.l	a0,a0
		move.l	Mypubscreen(a5),d0
		beq.s	.NoPublicScreen
		move.l	d0,a1
		jsr	_LVOUnlockPubScreen(a6)
.NoPublicScreen:clr.l	Mypubscreen(A5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Berechnet aus den Gadgets die min Height und Width und setzt diese in die   *
* Tagliste.
*-----------------------------------------------------------------------------*
BerechMinWindowSize:
		movem.l	d0-a6,-(a7)

	*-- Berechnungsgrundlage --*
	*-- min Width = min Cyclestringlen+25

**-----------------------------------*
* (C) Players		Infomation   *
* Available		Eigenschaften*
*------------------------------------*
* add del Config load save activate deactivate *


		*--- Breite der Gadgetleiste berechnen ---*
		moveq	#0,d7
		moveq	#0,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Frequence,d0	;Frequence
		bsr	NimmBiggerSize		;Hexdezpuffer
		add.l	d1,d2
		moveq	#0,d1
		lea	HD(pc),a0
		moveq	#MinGadgetWidth,d1
		bsr	NimmBiggerSize2
		add.l	d1,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Play,d0		;Play-Gadget
		bsr	NimmBiggerSize		;Hexdezpuffer
		add.l	d1,d2
		add.l	#GadgetXAbstand*4,d2

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Available,d0
		bsr	NimmBiggerSize
		moveq	#LENr_Samplelist,d0
		bsr	NimmBiggerSize
		moveq	#LENr_Informationen,d0
		bsr	NimmBiggerSize
		moveq	#LENr_Eigenschaften,d0
		bsr	NimmBiggerSize
		add.l	d1,d1

		cmp.l	d1,d2
		bhi.s	.XBleibtSo
		move.l	d1,d2
.XBleibtSo:	 add.l	#BevelBreite*2+MinTextGadgetXOffset*2+GadgetXAbstand*2,d2
					*Abstand vom Bevelrand links & rechts
					*sowie Abstand zum nchsten Gadget
					*Breite aller Bevelboxen
					*dazuaddieren 5 Gadgets*2Rnder = 14

		move.l	d2,d6

		add.l	#GadgetXAbstand*2,d6	*Abstand vom Rand links&Rechts

		move.l	MyPubScreen(a5),a0
		move.b	Sc_WBorLeft(a0),d0
		ext.w	d0
		add.w	d0,d6
		move.b	Sc_WBorRight(a0),d0
		add.w	d0,d6
		move.l	d6,Win_MinWidth


	*----- So, nun wird die Y-Ausdehnung des Window berechnet -----*
		moveq	#0,d0
		move.w	FontY(a5),d0
		add.w	#MinTextGadgetYOffset*2+BevelHohe*2,d0
		*mulu	#8,d0	* 4,weil 1+1 Cyglegadget, 2+1 fr Listview
		*		*        1 fr Gadgetreihe 1 fr Listviewtext
		*		*	 und 1 als Reserve

		mulu	#14,d0	* 2+2 fr Listview, 1 fr Slider, 1 fr Text
				* und 1 als Reserve

		add.w	Offy(a5),d0
		move.l	d0,Win_MinHeight


		movem.l	(a7)+,d0-a6
		rts
	
*-----------------------------------------------------------------------------*
* In der Windowstruktur sind die aktuellen Werte der Gre!		      *
* Jetzt
* Input: --
*-----------------------------------------------------------------------------*
InitGadgets:	movem.l	d1-a6,-(a7)


		move.l	PlayFrequence(a5),d0
		divu	#FreqStep,d0
		move.l	d0,SliderPos+4
		move.l	PlayFrequence(a5),d0
		lea	FrequencePuffer(a5),a1
		bsr	Hexdez

		*----- Zur Verfgung stehende Ausmae berechnen ------*
		move.l	WinHandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		moveq	#0,d6
		moveq	#0,d7
		move.w	WD_Width(a0),d6
		move.w	WD_Height(a0),d7
		moveq	#0,d0
		move.b	WD_BorderBottom(a0),d0
		sub.w	d0,d7				*InnerHeight
		sub.w	OffY(a5),d7
		sub.l	#GadgetYAbstand*2,d7
		move.b	WD_BorderLeft(a0),d0
		sub.w	d0,d6
		move.b	WD_BorderRight(a0),d0
		sub.w	d0,d6				*InnerWidth
		sub.l	#GadgetXAbstand*2,d6


		sub.l	#GadgetYAbstand*2,d7
		moveq	#0,d0
		move.w	FontY(a5),d0
		add.w	#MinTextGadgetYOffset+BevelHohe*2,d0
		sub.l	d0,d7



		*-- Postionen der Gadgets lschen --*
		lea	GD_Formatlist(pc),a4
		moveq	#GadgetAnz-1,d1
		move.l	a4,a3
.GadgetClr:	move.w	#GadgetXAbstand,gng_leftedge(a3)
		clr.w	2(a3)				*Gren lschen
		clr.l	4(a3)
		lea	GNG_SizeOf(a3),a3		*Positionen und
		dbf	d1,.GadgetClr



	*-- Die Breiten der Gadgetleisten wird berechnet --*
	*-- Als erstes wird die Stringbreite berechnet und gemerkt --*
	*-- dann wird calibriert
		move.l	d6,d0
		lsr.l	#1,d0
		subq.w	#GadgetXAbstand*2,d0
		move.w	d0,gng_width(a4)
		move.w	d0,gng_width+gng_sizeof(a4)
		move.w	d0,gng_width+gng_sizeof*5(a4)
		move.w	d0,gng_width+gng_sizeof*6(a4)
		add.w	d0,gng_leftedge+gng_sizeof(a4)
		add.w	d0,gng_leftedge+gng_sizeof*6(a4)
		add.w	#GadgetXAbstand*2,gng_leftedge+gng_sizeof(a4)
		add.w	#GadgetXAbstand*2,gng_leftedge+gng_sizeof*6(a4)

		move.w	d0,InfoWidth(a5)

		move.w	d6,gng_width+gng_sizeof*2(a4)
*		sub.w	#GadgetXAbstand*3,gng_width(a4)
*		sub.w	#GadgetXAbstand*3,gng_width+gng_sizeof*2(a4)
*		sub.w	#GadgetXAbstand*2,gng_width(a4)
		sub.w	#GadgetXAbstand*2,gng_width+gng_sizeof*2(a4)


	move.w	gng_width+gng_sizeof*2(a4),sliderwidth(a5)

		moveq	#LENr_Play,d0
		bsr	GetTextlength2
		add.w	#MinTextGadgetXOffset*2+Bevelbreite*2,d0
		move.w	d0,gng_width+gng_sizeof*4(a4)
		sub.w	d0,d6
		subq.w	#GadgetXabstand,d6
		move.w	d6,gng_leftedge+gng_sizeof*4(a4)
		subq.w	#GadgetXabstand,d6


		moveq	#LENr_Frequence,d0
		bsr	GetTextlength2
		move.w	d6,gng_width+gng_sizeof*3(a4)
		sub.w	d0,gng_width+gng_sizeof*3(a4)
		sub.w	#GadgetXAbstand*4,gng_width+gng_sizeof*3(a4)
	sub.w	#GadgetXAbstand,d0
		add.w	d0,gng_leftedge+gng_sizeof*3(a4)
		add.w	#GadgetXAbstand*3,gng_leftedge+gng_sizeof*3(a4)


		*-- Jetzt die Y-Koordinaten --*



		move.w	FontY(a5),d4
		*sub.w	d4,d7
		*sub.w	#GadgetYAbstand,d7
		move.w	d7,gng_topedge+gng_sizeof*3(a4)
		move.w	d7,gng_topedge+gng_sizeof*4(a4)
		move.w	d4,gng_height+gng_sizeof*3(a4)
		move.w	d4,gng_height+gng_sizeof*4(a4)
		add.w	#BevelHohe*4,gng_height+gng_sizeof*3(a4)
		add.w	#BevelHohe*4,gng_height+gng_sizeof*4(a4)

	*	sub.w	#GadgetYAbstand*3,d7
		sub.w	#GadgetYAbstand*2,d7
		sub.w	d4,d7
		move.w	d7,gng_topedge+gng_sizeof*2(a4)
		move.w	d4,gng_height+gng_sizeof*2(a4)

*----*
		sub.w	#GadgetYAbstand*6,d7
		sub.w	d4,d7
		sub.w	d4,d7
	move.l	d7,d0
	divu	#3,d0
		move.w	d0,gng_height(a4)
		move.w	d0,gng_height+gng_sizeof(a4)
		move.w	d0,gng_height+gng_sizeof*5(a4)
		move.w	d0,gng_height+gng_sizeof*6(a4)
		add.w	d0,gng_height(a4)
		add.w	d0,gng_height+gng_sizeof(a4)
		move.w	d4,gng_topedge(a4)
		move.w	d4,gng_topedge+gng_sizeof(a4)
		add.w	#GadgetYAbstand*2,gng_topedge(a4)
		add.w	#GadgetYAbstand*2,gng_topedge+gng_sizeof(a4)

	add.w	d4,d4
	add.w	d0,d4
	add.w	d0,d4
		move.w	d4,gng_topedge+gng_sizeof*5(a4)
		move.w	d4,gng_topedge+gng_sizeof*6(a4)
		add.w	#GadgetYAbstand*4,gng_topedge+gng_sizeof*5(a4)
		add.w	#GadgetYAbstand*4,gng_topedge+gng_sizeof*6(a4)


*	*	sub.w	#GadgetYAbstand*4,d7
*		sub.w	#GadgetYAbstand*6,d7
*		sub.w	d4,d7
*		sub.w	d4,d7
*	lsr.l	#1,d7
*		move.w	d7,gng_height(a4)
*		move.w	d7,gng_height+gng_sizeof(a4)
*		move.w	d7,gng_height+gng_sizeof*5(a4)
*		move.w	d7,gng_height+gng_sizeof*6(a4)
*
*		move.w	d4,gng_topedge(a4)
*		move.w	d4,gng_topedge+gng_sizeof(a4)
*		add.w	#GadgetYAbstand*2,gng_topedge(a4)
*		add.w	#GadgetYAbstand*2,gng_topedge+gng_sizeof(a4)
*
*	add.w	d4,d4
*	add.w	d7,d4
*		move.w	d4,gng_topedge+gng_sizeof*5(a4)
*		move.w	d4,gng_topedge+gng_sizeof*6(a4)
*		add.w	#GadgetYAbstand*4,gng_topedge+gng_sizeof*5(a4)
*		add.w	#GadgetYAbstand*4,gng_topedge+gng_sizeof*6(a4)
*

		bsr	CreateGadgets				*d0=Return

.Return:	movem.l	(a7)+,d1-a6
		rts


.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.Return




*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Error oder Null
*-----------------------------------------------------------------------------*
CreateGadgets:	movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	GadBase(A5),a6
		lea	GadgetListadr(a5),a0
		jsr	_LVOCreateContext(a6)
		move.l	d0,a3
		tst.l	d0
		beq.w	.Error

		moveq	#0,d3
		lea.l	GadgetTags(pc),a4
.NextGadget:	EB
		lea	Gadgets(pc),a0
		move.l	d3,d0
		mulu	#GNG_SIZEOF,d0		* +2 wegen Locale !
		add.l	d0,a0
		lea.l	BufNewGad(a5),a1
		moveq	#GNG_SizeOf,d0
		jsr	_LVOCopyMem(a6)
		lea.l	BufNewGad(a5),a0
		move.l	VisualInfo(a5),GNG_VisualInfo(a0)
		move.l	Font(a5),GNG_TextAttr(a0)

		move.w	GNG_TopEdge(a0),d0
		add.w	OffY(a5),d0
		addq.w	#GadgetYAbstand,d0
		move.w	d0,GNG_TopEdge(a0)

		move.w	GNG_LeftEdge(a0),d0
		add.w	OffX(a5),d0
		add.w	#GadgetXAbstand,d0
		move.w	d0,GNG_LeftEdge(a0)

		move.l	GadBase(a5),a6
		lea	GadgetTypes(pc),a0
		moveq	#0,d0
		move.l	d3,d1
		asl.l	#1,d1
		add.l	d1,a0
		move.w	(a0),d0
		move.l	a3,a0
		lea	BufNewGad(a5),a1
		move.l	a4,a2
		jsr	_LVOCreateGadgetA(a6)
		tst.l	d0
		beq.s	.Error

		*------- Gadgetadr im Puffer merken --------*
		move.l	d0,a3
		move.l	d3,d0
		asl.l	#2,d0
		lea.l	GadgetMerkPuffer(a5),a0
		add.l	d0,a0
		move.l	a3,(a0)

		*--- Start der nchsten Tagliste finden ----*
.FindTags:	tst.l	(a4)
		beq.s	.NochEinGadget
		addq.w	#8,a4
		bra.s	.FindTags

.NochEinGadget:	addq.w	#4,a4
		addq.w	#1,d3
		cmp.w	#GadgetAnz,d3
		bmi	.NextGadget
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

.Error:		bsr.w	FreeGadgets
		bra.s	.Return

*-----------------------------------------------------------------------------*
AddGads:	movem.l	d0-a6,-(sp)
		tst.l	WinHandle(a5)
		beq.w	.Return
		move.l	GadgetListAdr(a5),d0
		beq.s	.Return
		move.l	d0,a1

		moveq	#0,d1
.count:		move.l	d0,a0
		addq.l	#1,d1
		move.l	(A0),d0
		bne.s	.count
		move.w	d1,RealNumGadgets(a5)

		move.l	IntBase(a5),a6
		move.l	Winhandle(a5),a0
		moveq	#-1,d0
		moveq	#-1,d1
		sub.l	a2,a2
		jsr	_LVOAddGList(a6)


		bsr	ReaddFormatList
		bsr	ReaddSampleList

		bsr	MakeInfoList
		bsr	MakeEigenList

*		bsr	MakeList
*
*		lea	MyTags(a5),a3
*		move.l	#GTLV_Selected,(a3)+
*		move.l	SelectedEntry(a5),(a3)
*		subq.l	#1,(a3)+
*		clr.l	(a3)
*		moveq	#EPENr_ModulesList,d0
*		bsr	GetGadgetAdr
*		lea	MyTags(a5),a3
*		move.l	Winhandle(a5),a1
*		suba.l	a2,a2
*		move.l	GadBase(a5),a6
*		jsr	_LVOGT_SetGadgetAttrsa(a6)
*		move.b	#1,ListeDa(a5)


		move.l	GadgetListAdr(a5),a0
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		moveq	#-1,d0
		move.l	IntBase(a5),a6
		jsr	_LVOrefreshglist(a6)

		move.l	GadBase(a5),a6
		move.l	Winhandle(a5),a0
		sub.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)



.Return:	movem.l	(sp)+,d0-a6
		rts



*----------------------- Liste wieder an Gadget anhngen ---------------------*
* Input: --
*-----------------------------------------------------------------------------*
ReaddFormatlist:movem.l	d0-a6,-(sp)
		tst.l	Winhandle(a5)
		beq.s	.Return

		tst.b	ListeDa(a5)
		bne.s	.Return

		tst.l	MaxEntries(a5)
		beq.s	.NoSel
		tst.l	SelectedEntry(a5)
		bne.s	.NoSel
		addq.l	#1,SelectedEntry(a5)

.NoSel:		moveq	#EPENr_Formatlist,d0
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	MyTags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		lea	Formatlist(a5),a2
		move.l	a2,(a3)+
		move.l	#GTLV_Selected,(a3)+
		move.l	SelectedEntry(a5),(a3)
		subq.l	#1,(a3)+
		move.l	#GTLV_ShowSelected,(a3)+
		move.l	#1,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	SelectedEntry(a5),(a3)
		subq.l	#1,(a3)+
		clr.l	(a3)

*		tst.b	Clicked(a5)
*		beq.s	.nose
*		move.l	#GTLV_Selected,(a3)+
*		moveq	#0,d0
*		move.w	Num_Selected(a5),d0
*		move.l	d0,(a3)+
*		clr.l	(a3)
.nose:		lea	MyTags(a5),a3

		move.l	WinHandle(a5),a1
		sub.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		move.b	#1,ListeDa(a5)
		bsr	ErlaubeGadgets

.Return:	movem.l	(sp)+,d0-a6
		rts

*----------------------- Liste wieder an Gadget anhngen ---------------------*
* Input: --
*-----------------------------------------------------------------------------*
ReaddSamplelist:movem.l	d0-a6,-(sp)
		tst.l	Winhandle(a5)
		beq.s	.Return

		tst.b	SampleListeDa(a5)
		bne.s	.Return

		tst.l	MaxSampleEntries(a5)
		beq.s	.NoSel
		tst.l	SelectedSampleEntry(a5)
		bne.s	.NoSel
		addq.l	#1,SelectedSampleentry(a5)

.NoSel:		moveq	#EPENr_Samplelist,d0
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	MyTags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		lea	Samplelist(a5),a2
		move.l	a2,(a3)+
		move.l	#GTLV_Selected,(a3)+
		move.l	SelectedSampleEntry(a5),(a3)
		subq.l	#1,(a3)+
		move.l	#GTLV_ShowSelected,(a3)+
		move.l	#1,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	SelectedSampleEntry(a5),(a3)
		subq.l	#1,(a3)+
		clr.l	(a3)

*		tst.b	Clicked(a5)
*		beq.s	.nose
*		move.l	#GTLV_Selected,(a3)+
*		moveq	#0,d0
*		move.w	Num_Selected(a5),d0
*		move.l	d0,(a3)+
*		clr.l	(a3)
.nose:		lea	MyTags(a5),a3

		move.l	WinHandle(a5),a1
		sub.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		move.b	#1,SamplelisteDa(a5)
		bsr	ErlaubeGadgets

.Return:	movem.l	(sp)+,d0-a6
		rts



******************************************************************************
* Die Liste wird removed
******************************************************************************
RemoveFormatList:
		movem.l	d0-a6,-(a7)
		moveq	#EPENr_FormatList,d0
		tst.b	ListeDa(a5)
		beq.s	.Return

		tst.l	Winhandle(a5)
		beq.s	.Return
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	Mytags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		move.l	#-1,(a3)+
		clr.l	(a3)+
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	clr.b	ListeDa(a5)
		movem.l	(a7)+,d0-a6
		rts

******************************************************************************
* Die Sampleliste wird removed
******************************************************************************
RemoveSampleList:
		movem.l	d0-a6,-(a7)
		moveq	#EPENr_SampleList,d0
		tst.b	SamplelisteDa(a5)
		beq.s	.Return

		tst.l	Winhandle(a5)
		beq.s	.Return
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	Mytags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		move.l	#-1,(a3)+
		clr.l	(a3)+
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	clr.b	SamplelisteDa(a5)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeFormatList:	movem.l	d0-a6,-(a7)
		bsr	RemoveFormatList
		bsr	DeleteFormatList
		bsr	ReAddFormatList
		clr.l	SelectedEntry(a5)
		clr.l	MaxEntries(a5)
		bsr	ErlaubeGadgets
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeSamplelist:	movem.l	d0-a6,-(a7)
		bsr	RemoveSampleList
		bsr	DeleteSampleList
		bsr	ReAddSampleList
		clr.l	SelectedSampleEntry(a5)
		clr.l	MaxSampleentries(a5)
		bsr	ErlaubeGadgets

		bsr	UnLockSampleInfo

		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Output: d0=Error oder NULL
LockSampleInfo:	movem.l	d1-a6,-(a7)
		moveq	#EPR_FunctionAborted,d7
		tst.l	SampleInfoLocked(a5)
		beq.s	.Nein
		bsr	UnLockSampleInfo
.Nein		moveq	#EPNr_GetSampleInfo,d3
		bsr	SendOhneMess
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		tst.l	EPG_SampleInfoStructure(a4)
		beq.s	.Error
		addq.l	#1,SampleinfoLocked(a5)
		moveq	#0,d7
.Error:		move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
UnLockSampleinfo:
		movem.l	d0-a6,-(a7)
*.Retry:		tst.l	SampleInfoLocked(a5)
*		beq.s	.NoLock
*		moveq	#EPNr_FreeSampleInfo,d3
*		bsr	SendOhneMess
*		subq.l	#1,SampleInfoLocked(a5)
*		bra.s	.Retry

.NoLock:	movem.l	(a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
* Input: a0=List
*-----------------------------------------------------------------------------*
DeleteFormatList:
		movem.l	d0-a6,-(a7)
		lea	Formatlist(a5),a0
		move.l	a0,d4

.NextNode:	move.l	d4,a0
	;Macro remhead aus exec/lists.i 	A0-list A1-(destroyed) D0=node
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)

		move.l	d0,a1
		lea	-ESS_Node(a1),a3
		bsr	FreeThisFormatNode
		bra.s	.NextNode

.empty:		movem.l	(sp)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=List
*-----------------------------------------------------------------------------*
DeleteSampleList:
		movem.l	d0-a6,-(a7)
		lea	Samplelist(a5),a0
		move.l	a0,d4

.NextNode:	move.l	d4,a0
	;Macro remhead aus exec/lists.i 	A0-list A1-(destroyed) D0=node
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)

		move.l	d0,a1
		lea	-ESA_Node(a1),a3
		bsr	FreeThisSampleNode
		bra.s	.NextNode

.empty:		movem.l	(sp)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a3=ESS_Struct (bereits removed)
*-----------------------------------------------------------------------------*
FreeThisFormatNode:	movem.l	d0-d2/a0-a2/a6,-(a7)

		move.l	ESS_Segment(a3),d1
		beq.s	.NoSegment
		move.l	Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)

.NoSegment:	clr.l	ESS_Segment(a3)

		move.l	ESS_StructSize(a3),d0
		beq.s	.NextNode
		move.l	a3,a1
		EB
		jsr	_LVOFreemem(a6)

.NextNode:	movem.l	(a7)+,d0-d2/a0-a2/a6
		rts

*-----------------------------------------------------------------------------*
* Input: a3=ESA_Struct (bereits removed)
*-----------------------------------------------------------------------------*
FreeThisSampleNode:
		movem.l	d0-d2/a0-a2/a6,-(a7)

		move.l	ESA_StructSize(a3),d0
		beq.s	.NextNode
		move.l	a3,a1
		EB
		jsr	_LVOFreemem(a6)

.NextNode:	movem.l	(a7)+,d0-d2/a0-a2/a6
		rts


*------------------------------- Get GadgetAdr -------------------------------*
* d0=0, wenn ok
GetGadgetAdr:	sub.l	a0,a0
		cmp.w	#GadgetAnz,d0
		bhi.s	.Error
		tst.l	GadgetListAdr(a5)
		beq.s	.Error
		lea	GadgetMerkPuffer(a5),a0
		subq.l	#EPENr_FirstNummer,d0
		asl.l	#2,d0
		tst.l	(a0,d0)
		beq.s	.Error
		move.l	(a0,d0),a0
		moveq	#0,d0
.Error:		tst.l	d0
		rts




*--------------------------- normaler Stringvergleich ------------------------*
* Input: a0=String1
*	 a1=String2
* Output:d0=0 Strings gleich
*	 d0<0 String 1 vor String 2
*	 d0>0 String 2 vor String 1
*-----------------------------------------------------------------------------*
StrCmp:		movem.l	d1/a0/a1,-(a7)
		move.l	a0,d0
		beq.s	.Kleiner
		move.l	a1,d0
		beq.s	.Kleiner
.Repeat:	move.b	(a0)+,d1
		beq.s	.Ende1
		cmp.b	#`A`,d1		;Kommando in Grobuchstaben
		blo.s	.NoD1Set	;umwandeln
		cmp.b	#`Z`,d1
		bhi.s	.NoD1Set
		bset	#5,d1		;bis auf Bit 5 alle bernehmen -> fertig
.NoD1Set:	move.b	(a1)+,d0	;Wert holen
		beq.s	.Grosser
		cmp.b	#`A`,d0		;Kommando in Grobuchstaben
		blo.s	.NoBSet		;umwandeln
		cmp.b	#`Z`,d0
		bhi.s	.NoBSet
		bset	#5,d0		;bis auf Bit 5 alle bernehmen -> fertig
.NoBSet:	cmp.b	d1,d0
		beq.s	.Repeat
		bhi.s	.Kleiner
.Grosser:	moveq	#1,d0
		bra.s	.Return
.Kleiner:	moveq	#-1,d0
.Return:	movem.l	(a7)+,d1/a0/a1
		tst.l	d0
		rts			;---> Error in String !!!!

.Ende1:		tst.b	(a1)
		bne.s	.Kleiner
		moveq	#0,d0
		bra.s	.Return

*---------------------------- Make Correct-Dir ------------------------------*
*----- Corrigiert den Dirnamen so, da Filenamen nur rankopiert werden ------*
*----- Input: a0=Diradresse						-----*
*----------------------------------------------------------------------------*
MakeCorrectDir:	move.l	a0,-(a7)
		tst.b	(a0)
		beq.s	.NoSchraeg
.NextB:		tst.b	(a0)+
		bne.s	.NextB
		subq.l	#2,a0
		cmp.b	#":",(a0)
		beq.s	.NoSchraeg
		cmp.b	#"/",(a0)+
		beq.s	.NoSchraeg
		move.b	#"/",(a0)+
		clr.b	(a0)
.NoSchraeg:	move.l	(a7)+,a0
		rts


*---------------- Berechnet die Gre des Strings in a0 ---------------------*
*------- >= a0=String							-----*
*------- => d0=Stringsize						-----*
*----------------------------------------------------------------------------*
BerechStringSize:move.l a0,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest
		moveq	#-1,d0
.NextB:		addq.l	#1,d0
		tst.b	(a0)+
		bne.s	.NextB
.NoTest:	move.l	(a7)+,a0
		tst.l	d0
		rts


*----------------------------------------------------------------------------*
StringCopy:	moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
InitLocale:	movem.l	d0-a6,-(a7)

		*--- Catalog ffnen ---*
		if	Executable!Debugger
		tst.l	MyCatalog(a5)
		bne.s	.NoCatalog
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	Catalogname(pc),a1
		jsr	ENPP_OpenCatalog(a4)		;_LVOopencatalogA
		move.l	d0,MyCatalog(a5)

		else

		*--- Catalog ffnen ---*
		tst.l	MyCatalog(a5)
		bne.s	.NoCatalog
		move.l	LocaleBase(a5),d0
		beq.s	.NoCatalog
		move.l	d0,a6
		suba.l	a0,a0
		suba.l	a2,a2
		lea	Catalogname(pc),a1
		jsr	_LVOOpenCatalogA(a6)		;_LVOopencatalogA
		move.l	d0,MyCatalog(a5)
		endc

.NoCatalog:	moveq	#5,d0
		lea	LocaleTabelle-4(pc),a0
		lea	LocaleTabelle(pc),a1
.NextOne:	lea	4(a0),a0
		move.w	(a0),d0
		beq.s	.DasWars
		move.w	2(a0),d1
		lea	(a1,d1.w),a2
		bsr	GetLocaleString
		move.l	d0,(a2)
		bra.s	.NextOne
.DasWars:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeLocale:	movem.l	d0-a6,-(a7)
		*tst.l	MyCatalog(a5)
		*beq.s	.NoCatalog

		if	executable!Debugger
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	MyCatalog(a5),d0
		jsr	ENPP_CloseCatalog(a4)
		else
		move.l	LocaleBase(a5),d0
		beq.s	.NoCatalog
		move.l	d0,a6
		move.l	MyCatalog(a5),d0
		jsr	_LVOCloseCatalog(a6)
		endc
.NoCatalog:	clr.l	MyCatalog(a5)
		movem.l	(a7)+,d0-a6
		rts

*---------------------------- Erstmal ignorieren -----------------------------*
*-----------------------------------------------------------------------------*
FirstLocaleInit:movem.l	d0-a6,-(a7)
		lea	LocalePuffer+2(a5),a4
		lea	ExternalStrings,a3
		move.w	#LENr_LastExternal,d1
		move.l	a3,a0
.NextString2:	move.l	a0,d0
		sub.l	a3,d0
		move.w	d0,(a4)+
.FindZero2:	tst.b	(a0)+
		bne.s	.FindZero2
	*	tst.b	(a0)
	*	beq.s	.SetAbsStrings
		subq.w	#1,d1
		bne.s	.NextString2
.Ok:		movem.l	(a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
* Input:  D0.w = LocaleNr						      *
* Output: D0.l = StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleString:
		movem.l	d1/d2/a0/a1/a6,-(a7)

	*------- LocaleString aus internem Catalog suchen ------*
		move.l	d0,d2
		sub.l	a0,a0
		lea	ExternalStrings,a1
		cmp.w	#LENr_LastExternal,d0
		bhi.s	.Error
		lea	LocalePuffer(a5),a0
		ext.l	d0
		add.l	d0,d0
		move.w	(a0,d0.l),d0			;kein ext.l weil immer
		lea	(a1,d0.w),a0
.Error:		move.l	a0,d0

	*---------- Nun LocaleString aus Catalog suchen ---------*
		move.l	LocaleBase(a5),d1
		beq.s	.Return
		move.l	d1,a6
		move.l	MyCatalog(a5),d1
		beq.s	.Return
		move.l	d1,a0
		move.l	d0,a1
		move.l	d2,d0				* Stringnummer
		subq.l	#1,d0
		ext.l	d0
		jsr	_LVOGetCatalogStr(a6)		*--> d0=valid String

.Return:	movem.l	(a7)+,d1/d2/a0/a1/a6
		rts

*-----------------------------------------------------------------------------*
* Input: *a0=TextAdr (Font)						      *
*	 a0=Text							      *
* Output:d0=Size							      *
*-----------------------------------------------------------------------------*
GetTextlength2:	movem.l	d1-a6,-(a7)
		bsr	GetLocaleString
		move.l	d0,a0
		bra.s	getTextlength3
GetTextlength:	movem.l	d1-a6,-(a7)
GetTextlength3:	lea	MyIntuiText(pc),a2
		move.l	Font(a5),8(a2)
		move.l	a0,12(a2)
		move.l	a2,a0
		move.l	IntBase(a5),a6
		jsr	_LVOIntuiTextLength(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Diese Routine berechnet die Size vom String in d0 und setzt falls diese gr  *
* ist d1 neu.								      *
* Input: d0=Localenr							      *
*	 d1=bisherige Width						      *
* Output:d1=Neuer Wert							      *
*-----------------------------------------------------------------------------*
NimmBiggerSize:	movem.l	d2-a6,-(a7)			*Input: d0=Nummer
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	GetTextlength
		cmp.w	d0,d1
		bhi.s	.D1IstBigger
		move.l	d0,d1
		ext.l	d1
.D1IstBigger:	movem.l	(a7)+,d2-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Text
NimmBiggerSize2:movem.l	d2-a6,-(a7)			*Input: d0=Nummer
		bsr	GetTextlength
		cmp.w	d0,d1
		bhi.s	.D1IstBigger
		move.l	d0,d1
		ext.l	d1
.D1IstBigger:	movem.l	(a7)+,d2-a6
		rts



*-----------------------------------------------------------------------------*

		*------------------ Window ---------------*
WindowTags:	dc.l	WA_MinWidth
Win_MinWidth:	dc.l	0
		dc.l	WA_MinHeight
Win_MinHeight:	dc.l	0
		dc.l	WA_MaxWidth,$8000
		dc.l	WA_MaxHeight,$8000

		dc.l	WA_Left
Win_LeftPos:	dc.l	0
		dc.l	WA_Top
Win_TopPos:	dc.l	0
		dc.l	WA_Width
Win_Width:	dc.l	0
		dc.l	WA_Height
Win_Height:	dc.l	0
		dc.l	WA_IDCMP,IDCMP_VanillaKey!IDCMP_Changewindow!IDCMP_RawKey!IDCMP_Menupick!LISTVIEWIDCMP!IDCMP_NEWSIZE!BUTTONIDCMP!IDCMP_CLOSEWINDOW!IDCMP_REFRESHWINDOW
		dc.l	WA_Flags,Sizebbottom!WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_SMART_REFRESH!WFLG_SIZEGADGET
		dc.l	WA_Title
LL_WindowTitle:	dc.l	0
		*dc.l	WA_ScreenTitle
		*dc.l	0
		dc.l	WA_NewLookMenus,1
		dc.l	WA_AutoAdjust,1
		dc.l	WA_Pubscreen
Pubadr:		dc.l	0
		*dc.l	WA_Zoom
		*dc.l	ZoomStruct
		dc.l	TAG_DONE
ZoomStruct:	dc.w	0,0,150,0
Ahawidth:	dc.l	399
Ahaheight:	dc.l	80

	*-------------- Gadgetvereinbarungen ----------------*
	* 1<<15 ($8000) - Flag fr Listviews, um gelschte Hhe an Font anzupassen
Refreshed_Gads:
	my_Redrawlist	GD_Formatlist,$8000
	my_Redrawlist	GD_Samplelist,$8000
	my_Redrawlist	GD_Slider,0
	my_Redrawlist	GD_Text,0
	my_Redrawlist	GD_Play,0
	my_Redrawlist	GD_Infolist,$8000
	my_Redrawlist	GD_Eigenlist,$8000
	my_Redrawlist	0,0

	*-------------- Gadgetvereinbarungen ----------------*
GadgetTypes:	dc.w	Listview_Kind
		dc.w	Listview_Kind
		dc.w	Slider_Kind
		dc.w	Text_Kind
		dc.w	Button_Kind			*Execute
		dc.w	Listview_Kind
		dc.w	Listview_Kind

GadgetTags:	dc.l	GTLV_ShowSelected,0		*Formatliste
		dc.l	0

		dc.l	GTLV_ShowSelected,0		*Samplelist
		dc.l	0

		dc.l	GTSL_Min,MinFreq/FreqStep	*Slider
		dc.l	GTSL_Max,MaxFreq/FreqStep	*Slider
		dc.l	PGA_Freedom,LORIENT_HORIZ
		dc.l	GA_RelVerify,1
SliderPos:	dc.l	GTSL_Level,2200
		dc.l	0

		dc.l	GTTX_Border,1
TextGadgetTags:	dc.l	GTTX_Text,Puffer+FrequencePuffer *Text
		dc.l	0

		dc.l	GT_Underscore,'_'		*Play
		dc.l	Tag_Done

		dc.l	0				*Informationen

		dc.l	0				*Eigenschaften

Gadgets:
GD_Formatlist:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Available:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_FormatList	;GadgetNr
		dc.l	Placetext_Above,0,0	;Flags,VisualInfo,Userdata

GD_Samplelist:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Samplelist:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_SampleList	;GadgetNr
		dc.l	Placetext_Above,0,0	;Flags,VisualInfo,Userdata

GD_Slider:	dc.w	0,0,0,0			;Left,Top,Width,Height
		dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Slider		;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

GD_Text:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Frequence:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_TextGadget	;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

GD_Play:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Play:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_TogglePlayMode	;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

GD_Infolist:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Infolist:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_InfoList		;GadgetNr
		dc.l	Placetext_Above,0,0	;Flags,VisualInfo,Userdata

GD_Eigenlist:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Eigenlist:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_EigenList		;GadgetNr
		dc.l	Placetext_Above,0,0	;Flags,VisualInfo,Userdata


MyIntuiText:	dc.w	0,0
		dc.w	0,0
		dc.l	0			*Font
		dc.l	0			*Text
		dc.l	0			*Next



	*------------------------- Menus -----------------------*
Menus:		dc.b	NM_Title,0
LLM_Project:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Play:	dc.l	0
LLM_PlayKey:	dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Stop:	dc.l	0
LLM_StopKey:	dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_About:	dc.l	0
LLM_AboutKey:	dc.l	AboutKey
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Hide:	dc.l	0
LLM_HideKey:	dc.l	HideKey
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Quit:	dc.l	0
		dc.l	QuitKey
		dc.w	0
		dc.l	0,0


		*---- Prefs ----*
		dc.b	NM_Title,0
LLM_Settings:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0


		dc.b	NM_ITEM,0
LLM_Backpic:	dc.l	0
		dc.l	0
BackPicFlags:	dc.w	CHECKIT!Menutoggle
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_ChooseBackpic:dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_SaveConfig:dc.l	0
LLM_SaveConfigKey:dc.l	0
		dc.w	0
		dc.l	0,0


		dc.b	NM_END,0
		dc.l	0,0
		dc.w	0
		dc.l	0,0


MenuTags:	dc.l	GTMN_Newlookmenus,1
		dc.l	TAG_DONE


*----------------------------------------------------------------------------*
LocaleTabelle:
		dc.w	LENr_Quit,LLM_Quit-LocaleTabelle
		dc.w	LENr_Hide,LLM_Hide-LocaleTabelle
		dc.w	LENr_About,LLM_About-LocaleTabelle
		dc.w	LENr_SelectBackPic,LLM_ChooseBackPic-LocaleTabelle
		dc.w	LENr_BackPic,LLM_BackPic-LocaleTabelle
		dc.w	LENr_Available,LLG_Available-LocaleTabelle
		dc.w	LENr_SampleList,LLG_Samplelist-LocaleTabelle
		dc.w	LENr_Play,LLG_Play-LocaleTabelle
		dc.w	LENr_Eigenschaften,LLG_Eigenlist-LocaleTabelle
		dc.w	LENr_Informationen,LLG_Infolist-LocaleTabelle
		dc.w	LENr_Frequence,LLG_Frequence-LocaleTabelle
		dc.w	LENr_WindowTitle,LL_WindowTitle-LocaleTabelle
		dc.w	LENr_Project,LLM_Project-LocaleTabelle
		dc.w	LENr_Settings,LLM_Settings-LocaleTabelle
		dc.w	LENr_SaveConfig,LLM_SaveConfig-LocaleTabelle

		dc.w	LENr_Stop,LLM_Stop-LocaleTabelle
		dc.w	LENr_StopKey,LLM_StopKey-LocaleTabelle
		dc.w	LENr_PlayMenu,LLM_Play-LocaleTabelle
		dc.w	LENr_PlayKey,LLM_PlayKey-LocaleTabelle
		dc.w	0




*----------------------------------------------------------------------------*
InternalStrings:
MyProzessName		dc.b	"EP_Samplesaver.1",0
MyCreatorname:		dc.b	"Eagleeye of DEFECT",0
MySpecialInfo:		dc.b	"Save sample in different formats",0
EPUserPortName:		dc.b	"EAGLEPLAYERPORT",0
MyMsgPortName:		dc.b	"EP_Samplesaver.Port",0
FormatsDir:		dc.b	"Samplesavers",0


Helpnode_SaveConfig:	dc.b	"Save Config",0
Helpnode_Samplelist:	dc.b	"Samplesaver_Samplelist",0
HelpNode_BackPic:	dc.b	"BackPic",0
HelpNode_SelectPackPic:	dc.b	"SelectBackPic",0
HelpNode_Formatlist:	dc.b	"SampleSaver_Formatlist",0
HelpNode_Hide:		dc.b	"Hide",0
HelpNode_Quit:		dc.b	"Quit",0
HelpNode_About:		dc.b	"About",0
HelpNode_Slider:	dc.b	"SampleSaver_Slider",0
HelpNode_Play:		dc.b	"SampleSaver_Play",0
HelpNode_Stop:		dc.b	"SampleSaver_Stop",0
HelpNode_Informationen:	dc.b	"SampleSaver_Informationen",0
HelpNode_Eigenschaften:	dc.b	"SampleSaver_Eigenschaften",0

			if	test
DT_PicName:		dc.b	`SYS:prefs/patterns/misc`,0
Configdir:		dc.b	"EP:configs/",0
Enginedir:		dc.b	"EP:Engines/",0
			endc


QuitKey:		dc.b	"Q",0
HideKey:		dc.b	"H",0
AboutKey:		dc.b	"A",0
Fragezeichen:		dc.b	"?",0
ConfigName:		dc.b	"Samplesaver.config",0
Catalogname:		dc.b	"EP_Samplesaver.catalog",0
MyReqToolsname:		dc.b	"reqtools.library",0
Datatypesname:		dc.b	"datatypes.library",0
HD:			dc.b	"999999",0
Zero:			dc.b	0

ExternalStrings:
*-------------------------- Locale fr MakeCat -------------------------------*
LOCALE_START
*CATALOG	EP_Samplesaver
*VERSION	38.2
*DATE		28.02.97


MSG_SS_WindowTitle	dc.b	"Samplesaver ",0
*D				'Samplesaver ',0
MSG_SS_Project		dc.b	"Project",0
*D				'Project',0
MSG_SS_Settings		dc.b	"Settings",0
*D				'Konfiguration',0
MSG_SS_About		dc.b	"About",0
*D				'ber',0
MSG_SS_Hide		dc.b	"Hide",0
*D				'Verstecken',0
MSG_SS_Quit		dc.b	"Quit",0
*D				'Quit',0
MSG_SS_BackPic		dc.b	"BackPic",0
*D				'Hintergrundbild',0
MSG_SS_SelectBackPic	dc.b	"Select BackPicture",0
*D				'Whle Hintergrundbild',0
MSG_SS_SaveConfig	dc.b	"Save Config",0
*D				'Speichere Konfiguration',0
MSG_SS_AboutText	dc.b	'Samplesaver V1.01'
			dc.b	' by',10,10
			dc.b	"Jan Blumenthal",10
			dc.b	"Erich-Mhsam-Str. 34",10
			dc.b	"18069 Rostock",10
			dc.b	"Tel.: +49 (0)381/83979",10,10
			dc.b	"This engine can save samples from modules",10
			dc.b	"in different formats.",0
*D				'Samplesaver V1.01 von',10,10
*D				'Jan Blumenthal',10
*D				'Erich-Mhsam-Str. 34',10
*D				'18069 Rostock',10
*D				'Tel.: +49 (0)381/83979',10,10
*D				'Dieses Engine kann Instrumente aus',10
*D				'Modulen in verschiedenen Formaten',10
*D				'speichern.',0
MSG_SS_Ok		dc.b	"_Ok",0
*D				'_Ok',0
MSG_SS_RequestTitle	dc.b	"Samplesaver_Requester",0
*D				'Samplesaver_Requester',0
MSG_SS_EPNotFound	dc.b	"Eagleplayer-Port not found!",0
*D				'Konnte den Eagleplayerport nicht finden',0
MSG_SS_SoundDatei	dc.b	"Please choose your sound!",0
*D				'Bitte whlen Sie die Sounddatei!',0
MSG_SS_Frequence	dc.b	"Frequency",0
*D				'Frequenz',0
MSG_SS_Available	dc.b	"Savers",0
*D				'Speicherformate',0
MSG_SS_Von		dc.b	" of ",0
*D				' von ',0
MSG_SS_Sampleliste	dc.b	"Samplelist",0
*D				'Instrumentenliste',0
MSG_SS_Play		dc.b	"_Play",0
*D				'_Spielen',0
MSG_SS_PlayMenu		dc.b	"Play",0
*D				'Spielen',0
MSG_SS_PlayKey		dc.b	"P",0
*D				'P',0
MSG_SS_Stop		dc.b	"Stop",0
*D				'Stopp',0
MSG_SS_StopKey		dc.b	"S",0
*D				'S',0
MSG_SS_Informationen	dc.b	"Informations",0
*D				'Informationen',0
MSG_SS_Eigenschaften	dc.b	"Qualities",0
*D				'Eigenschaften',0
MSG_SS_Version		dc.b	"Version: ",0
*D				'Version: ',0
MSG_SS_Length		dc.b	"Length: ",0
*D				'Lnge: ',0
MSG_SS_Type		dc.b	"Type: ",0
*D				'Typ: ',0
MSG_SS_Aufnahme		dc.b	"Record: ",0
*D				'Aufnahme: ',0
MSG_SS_RAW		dc.b	"RAW",0
*D				'RAW',0
MSG_SS_IFF		dc.b	"IFF",0
*D				'IFF',0
MSG_SS_SynthFM		dc.b	"FM-Synth",0
*D				'FM-Synthetisch',0
MSG_SS_SynthAM		dc.b	"AM-Synth",0
*D				'AM-Synthetisch',0
MSG_SS_Unknown		dc.b	"Unknown",0
*D				'Unbekannt',0
MSG_SS_8Bit		dc.b	"8 Bit",0
*D				'8 Bit',0
MSG_SS_16Bit		dc.b	"16 Bit",0
*D				'16 Bit',0
MSG_SS_Interleaved	dc.b	"Interleaved",0
*D				'verschachtelt',0
MSG_SS_Intel		dc.b	" Intel",0
*D				' Intel',0
MSG_SS_Unsigned		dc.b	" Unsigned",0
*D				' ohne Vorzeichen',0
MSG_SS_Bytes		dc.b	" Bytes",0
*D				' Bytes',0
MSG_SS_Unknownname	dc.b	"Unknown name",0
*D				'Unbekannter Name',0
MSG_SS_SomeSamplesFailures dc.b	10,"Some samples are't taking up in the "
			dc.b	"samplelist because the address in memory or "
			dc.b	"size of the sample is unknown.",0
*D				10,'Einige Instrumente wurden nicht mit in die '
*D				'Liste aufgenommen, da Informationen ber '
*D				'die Lage im Speicher bzw. die Gre des '
*D				'Instruments nicht vorlagen.',0
MSG_SS_RAW8Bit 	dc.b	10,"8Bit RAW are used in nearly all musicprograms on "
		dc.b	"Amiga for instance in Protracker or Startrekker. "
		dc.b	"These samples are signed.",0
*D		10,'8Bit RAW Instrumente werden in fast allen Musikprogrammen '
*D		'auf dem Amiga, z.B. in Protracker oder Startrekker, benutzt. '
*D		'Diese Instrumente sind vorzeichenbehaftet.',0

MSG_SS_RAW16BitUI
		dc.b	10,"16Bit RAW-Samples unsigned/intel are used in nearly "
		dc.b	"all musicprograms on "
		dc.b	"PC for instance in Screamtracker III or Multitracker.",10,10
		dc.b	"These samples are unsigned und swapped.",0
*D		10,'16Bit RAW Instrumente (nicht vorzeichenbehaftet/Intel) '
*D		'werden in fast allen Musikprogrammen auf dem PC, z.B. in '
*D		'Screamttracker III oder Multitracker, benutzt.',10,10
*D		'Die hheren und tieferen Bytes sind vertauscht.',0

LOCALE_END
			dc.b	0		* <-- Kennung fr Ende




*-----------------------------------------------------------------------------*
		SECTION	BSSMErkPuffer,BSS
Puffer		ds.b	PufferEnd

	


