*****************************************************************************
**                                                                         **
** Engine: Quadrascope                                                     **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


	;*********************************************
	;**       Eagleplayer QuadrascopeII V1.00   **
	;**         1993,1994 Henryk Richter       **
	;*********************************************
	;
	; strzt nach 5 Minuten ab, wenn der Eagleplayer modifiziert ist !!
	; (zersgt DOS.library "_LVOOpen" und _"LVOInfo")
	;
	incdir	include:
	include	exec/exec_lib.i
	include	exec/libraries.i
	include	exec/interrupts.i
	include	exec/execbase.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	dos/dos_lib.i
	include	libraries/dos.i
	include	graphics/graphics_lib.i
	include	misc/Eagleplayer.i
	include	misc/EagleplayerEngine.i
	include	misc/BuggsMacros.i
	;
ver		macro
		dc.b	"1.06"
		endm
StructVer	macro
		dc.w	1,06
		endm
date		macro
		dc.b	"05-Apr-97"
		endm
StructDate	macro
		dc.b	05,04
		dc.w	1997
		endm

Test = 0	;auf 0 Setzen zur Nutzung mit dem Eagleplayer
		;zu Testzwecken meldet sich der Analyzer sonst selbst ab !
debug = 0
;===========================================================================
	section	0,code
;===========================================================================
an_num = 24			;Anzahl der Balken (nicht ndern)
an_zeilen = 32			;Anzahl der Zeilen (nicht ndern)
win_breite = (an_num+8)*8

RandAbstandH	=	4	;4 Pixel vom linken u. rechten Rand zu Boxen
RandAbstandV	=	6	;6 Pixel vom oberen u. unteren Rand zu Boxen
ZwischenRaum	=	4	;4 Pixel zwischen den Bevelboxen
BoxInnenAbstandH =	3	;3 Pixel zwischen Bevelbox und Anzeige
BoxInnenAbstandV =	2	;2 Pixel zwischen Bevelbox und Anzeige
;===========================================================================
BEGIN
	bra.w	fangan
	EUSN_Identifier
	dc.l	0		;eus_next
	ifne	debug
	dc.w	-2
	else
	dc.w	0		;eus_Usernr
	endc
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;eus_unused3
	dc.l	Tagliste	;eus_unused4
	dc.w	0		;eus_ticks

	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_Zipwin!USMB_ChangeConfig!USMB_ChangeInterrupt;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	myinfo
	dc.w	37		;eus_Kickstart
	dc.l	EAGLEVERSION	;eus_EPVersion
	structver		;eus_version
	dc.l	MyUsername	;eus_username

	dc.w	268		;eus_winx
	dc.w	167		;eus_winy
	dc.w	EUSB_openwin
	dc.l	0		;EUS_Special
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	structdate		;EUS_Creatordate
	dc.b	-5		;EUS_Priority
	dc.b	EUTY_Scope
	dc.w	0
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

		ifne	(*-begin)-EUS_SizeOF
		Aber Hallo
		endc

	dc.b	`$VER: Eagleplayer QuadrascopeII `
	ver
	dc.b	` (`
	date
	dc.b	`)`,0
	even


Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Quadrascope
		dc.l	0


fangan
	move.l	4.w,a6

	lea	datas,a5
	move.l	a5,a0
	move.w	#dataslen-1,d0
.clr	move.b	#0,(a0)+
	dbf	d0,.clr

	lea	Fulls(A5),a0
	moveq	#7,d0
	moveq	#-1,d1
.clr1
	move.l	d1,(a0)+
	dbf	d0,.clr1

	lea	begin(pc),a0
	move.l	EUS_EPBase(a0),a0
	lea	EPG_someprefs(a0),a0
	move.l	a0,flagsadr(A5)

	move.w	attnflags(A6),d0
	and.w	#AFF_68020,d0
	sne	MC68020on(A5)

	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;Signal allokieren
	tst.l	d0
	blt	NoSignal
	move.l	d0,mysignal(a5)

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)
	move.l	d0,mytask(a5)

	lea	dos(pc),a1
	moveq	#33,d0			;Brauchen DOS V1.2,fr Message,falls
	jsr	_LVOopenlibrary(a6)	;Start von 1.2/1.3 aus
	tst.l	d0
	beq	NODOS
	move.l	d0,_dos(a5)
	cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
	bge.s	.Dos_ok		;ja->Weiter

	move.l	_DOS(a5),a6
	lea	confile(pc),a0
	move.l	a0,d1
	move.l	#mode_oldfile,d2
	jsr	_LVOopen(a6)
	tst.l	d0
	beq.s	.Blossraus	;Nicht einmal AUSGABE auf CON: funtioniert
	move.l	d0,d6
	move.l	d0,d1

	lea	conout(pc),a0
	move.l	a0,d2
	moveq	#conlen,d3
	jsr	_LVOwrite(a6)	;Ausgabe "Needs Amiga OS2.04 or higher"

	move.l	#250,d1		;~5 Sekunden warten
	jsr	_LVOdelay(a6)

	move.l	d6,d1		;Con schlieen
	jsr	_LVOclose(a6)
.blossraus
	bra	NoPort
.dos_ok
	move.l	4.w,a6
	jsr	_LVOcreatemsgport(a6)	;Messageport auf die schnelle Art
	tst.l	d0
	beq	NoPort
	move.l	d0,MSGport(a5)

	lea	int(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	tst.l	d0
	beq	NOINT
	move.l	d0,intsave(a5)

	lea	graf(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	tst.l	d0
	beq	NOGRAF
	move.l	d0,grafsave(a5)

	lea	gad(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	tst.l	d0
	beq	nogadto
	move.l	d0,gadsave(a5)

	moveq	#0,d7

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse haben mchte
	blt	endme	;Fehler aufgetreten

	bsr	setint
	bsr	HandleActions		;Auf Usereingaben reagieren
	bsr	remint
endme
	move.l	d7,-(sp)
	bsr	closewin
	move.l	(sp)+,d7		;Error oder Exit-Message vom Player
	blt.s	Error
	bsr	Sendlastmessage
Error
	move.l	mypubscreen(a5),d0
	beq.s	.ok
	move.l	d0,a1
	suba.l	a0,a0
	jsr	_LVOunlockpubscreen(a6)
.ok
	move.l	gadsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(A6)
nogadto
	move.l	grafsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
NoGraf
	move.l	intsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
noint
	move.l	4.w,a6

	move.l	MSGport(a5),a0
	jsr	_LVOdeletemsgport(a6)
NoPort
	move.l	4.w,a6
	move.l	_dos(a5),a1
	jsr	_LVOcloselibrary(a6)
nodos
	move.l	mysignal(a5),d0
	move.l	4.w,a6
	jsr	_LVOfreesignal(a6)
NoSignal
	moveq	#0,d0
	rts
************************************************************************
*                   Fenster ffnen                                     *
************************************************************************
Openwin:
	tst.l	winhandle(a5)
	bne.w	.Error2

	move.l	intsave(a5),a6

	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep
	move.l	d0,a0
	move.w	EPG_Wordreserved8(A0),word8(A5)
	move.l	EPG_Pubscreen(a0),d0
.noep
	move.l	d0,a0

	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	bne.s	.pbs

	suba.l	a0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	beq	.Error2		;sollte nicht auftreten
.pbs
	moveq	#0,d5		;Minbreite
	moveq	#0,d6		;Minhhe

	move.l	d0,mypubscreen(a5);fr UnLockpubscreen()
	move.l	d0,a1
	move.l	sc_font(a1),a0
	move.l	a0,fontatt(a5)

	move.b	sc_wborleft(a1),d0
	ext.w	d0
	move.w	d0,offx(a5)
	add.b	sc_wborright(a1),d0
	move.w	d0,d5		;RandBreite
	add.w	#RandAbstandH*2+ZwischenRaum*3+BoxInnenAbstandH*4+8*4+16,d5

	add.w	#Win_breite-6,d0
	move.l	d0,winwidth(a5)

	move.w	ta_ysize(a0),d0		;Hhe des Screenfonts
	move.w	d0,d1
	move.w	d0,fonth(a5)
	move.b	sc_wbortop(a1),d0
	ext.w	d0
	add.w	d0,d1			;Berechnen der Gre fr ZIPwindow()
	move.w	d1,myhoehe1(a5)		;und eintragen
	move.b	sc_WBorbottom(a1),d0
	ext.w	d0
	add.w	d0,d1
	move.w	d1,d6
	add.w	#RandAbstandV*2+BoxInnenAbstandV*2+15,d6

	add.w	#AN_zeilen+13,d1	;64 Zeilen + Rand
					;+ Rand
					;in D1 Windowhhe


	movem.l	d0-d6/a0-a6,-(sp)
	bsr	makemenus		;Mens basteln
	movem.l	(sp)+,d0-d6/a0-a6
	tst.l	d7
	blt.w	.Error

	lea	mytags(a5),a1		;WINDOW INIT

	move.l	#WA_Pubscreen,(a1)+
	move.l	mypubscreen(A5),(a1)+

	move.l	#WA_Newlookmenus,(a1)+
	move.l	#1,(a1)+

	move.l	#wa_Pubscreenfallback,(A1)+
	move.l	#1,(a1)+

	lea	begin(pc),a0
	moveq	#0,d0
	move.l	#wa_top,(a1)+
	move.w	eus_winy(a0),d0
	move.l	d0,(a1)+
	move.l	#wa_left,(a1)+
	move.w	eus_winx(a0),d0
	move.l	d0,(a1)+

	move.l	#wa_innerwidth,(a1)+		;Breite
	move.w	eus_special(a0),d0
	and.w	#$fff,d0
	cmp.w	#RandAbstandH*2+ZwischenRaum*3+BoxInnenAbstandH*4+8*4,d0
	bge.s	.hi1
	move.l	winwidth(A5),d0
.hi1
	cmp.w	#1280,d0
	blt.s	.lo1
	move.l	winwidth(a5),d0
.lo1
	move.l	d0,(a1)+	;20Spalten+15*8Pixel fr Gadgets+Rand

	move.l	#wa_innerheight,(a1)+	;Hhe
	move.w	eus_special+2(a0),d0
	and.w	#$fff,d0
	cmp.w	#RandAbstandV*2+BoxInnenAbstandV*2+14,d0
	bge.s	.hi2
	move.l	d1,d0
.hi2
	cmp.w	#1024,d0
	blt.s	.lo2
	move.l	d1,d0
.lo2
	move.l	d0,(a1)+	;20Spalten+15*8Pixel fr Gadgets+Rand

	move.l	#wa_minwidth,(a1)+
	move.l	d5,(a1)+
	move.l	#wa_minheight,(a1)+
	move.l	d6,(a1)+
	move.l	#wa_maxwidth,(a1)+
	move.l	#1280,(a1)+
	move.l	#wa_maxheight,(a1)+
	move.l	#1024,(a1)+
	move.l	#wa_flags,(a1)+
	move.l	#Windowsizing!Windowdrag!Windowdepth!Windowclose,(a1)+
	move.l	#WA_TITLE,(a1)+
	lea	mywinname(pc),a0
	move.l	a0,(a1)+
	move.l	#wa_idcmp,(a1)+
 move.l	#IDCMP_NEWSIZE!closewindow!menupick!refreshwindow,(a1)+
	move.l	#wa_autoadjust,(a1)+
	move.l	#1,(a1)+

	move.l	#WA_ScreenTitle,(a1)+
	move.l	#Project0STitle,(a1)+

	move.l	#TAG_DONE,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)
	move.l	d0,Winhandle(a5)
	bne.s	.winopened

	lea	mytags(a5),a1		;Fehler,nochmal auf Position 0/0
	move.l	#wa_top,(a1)+		;zu ffnen versuchen
	move.l	#0,(a1)+
	move.l	#wa_left,(a1)+
	move.l	#0,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;wirst DU wohl aufgehen !
	move.l	d0,Winhandle(a5)
	beq.w	.Error
.winopened

	move.l	d0,a0
	move.l	wd_userport(a0),a0	;User Port
	move.l	a0,port(a5)

	bsr	addmenus		;Men darstellen

	bsr	calccoordinates		;Koordinaten und Gre der Fensterchen
					;berechnen

	bsr	refresh
	bsr	MakeBitmapII
	bne	.Error
	bsr	MakeTables		;Tabellen fr die Darstellung berechnen

	move.l	intsave(a5),a6
	suba.l	a0,a0
	move.l	mypubscreen(a5),d0
	beq.s	.nopub
	move.l	d0,a1
	clr.l	mypubscreen(a5)
	jsr	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.nopub	
.error2
	rts
.error
;	bra	closewin ;!!
*******************************************************************
*                   Window schlieen                              *
*******************************************************************
Closewin:
	push	all

	tst.l	winhandle(a5)
	beq.s	.nowin

	bsr	freebitmapII
	bsr	freemenus
	
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	clr.l	Winhandle(a5)
	clr.l	port(a5)
	lea	begin(pc),a1

	move.w	myhoehe1(a5),d0		;Zipwindow ?
	cmp.w	wd_height(a0),d0
	beq.s	.noxy

	move.w	wd_leftedge(a0),eus_winx(a1)
	move.w	wd_topedge(a0),eus_winy(a1)

	move.w	eus_special(a1),d1
	and.w	#$E000,d1
	move.w	wd_width(A0),d0
	moveq	#0,d2
	move.b	wd_BorderLeft(a0),d2
	add.b	wd_BorderRight(a0),d2
	ext.w	d2
	sub	d2,d0
	or.w	d0,d1
	move.w	d1,eus_special(a1)

	move.w	eus_special+2(a1),d1
	and.w	#$C000,d1
	move.w	wd_height(A0),d0
	moveq	#0,d2
	move.b	wd_BorderTop(a0),d2
	add.b	wd_BorderBottom(a0),d2
	ext.w	d2
	sub	d2,d0
	or.w	d0,d1
	move.w	d1,eus_special+2(a1)
.noxy
	jsr	_LVOclosewindow(a6)
.nowin
	pop	all
	rts
********************************************************************
*                  Init Message Struktur                           *
********************************************************************
Sendfirstmessage
	move.l	4.w,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	bne.s	.ok
	bsr	openwin
	lea	NoportMessage(pc),a0
	lea	my_easystruct(a5),a1
	move.l	a0,es_textformat(a1)
	lea	my_easygadget2(pc),a0
	move.l	a0,es_gadgetformat(a1)
	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),d0	;*Window
	beq.s	.error	;kann kein Window ffnen
	move.l	d0,a0
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	tst.l	d0
	beq.s	.error
	bra	SendFirstmessage
.ok
	move.l	d0,a0			;Portadresse

	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	mysignal(a5),d5
	move.w	#USclass_Newuserprg,d6

	ifne	debug

	bsr	allocmsg
	beq.s	.error
	move.l	d0,a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2
	move.l	a2,um_result(a1)
	move.w	#-2,UM_UserNr(a1)
	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jsr	_LVOputmsg(a6)

	else
	bsr	sendmess
	endc

	moveq	#0,d7
	rts
.error
	moveq	#-1,d7
	rts
******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
Sendlastmessage:
	move.l	4.w,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	moveq	#0,d4
	moveq	#0,d5
	move.w	#USclass_exit,d6

	bsr	sendmess
.wait
	move.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	move.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
*******************************************************************************
sendmess:
	bsr	allocmsg
	bne.s	.ok
	rts
.ok
	move.l	d0,a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	clr.l	UM_Command(a1)
	clr.l	UM_Result(A1)
	clr.l	UM_ArgString(A1)

	move.l	4.w,a6
	jmp	_LVOputmsg(a6)
*******************************************************************************
*                        Mens erstellen                                      *
*******************************************************************************
MakeMenus
	move.l	gadsave(a5),A6

	move.l	mypubscreen(a5),a0
	suba.l	a1,a1
	jsr	_LVOgetvisualinfoa(a6)	;Visual Info vom Screen anfordern
	move.l	d0,vi(a5)
	beq	.nomen

	move.w	#CheckIT,d1

	lea	Item1(pc),a0
	move.w	d1,gnm_Flags(A0)
	move.w	d1,gnm_Flags+gnm_sizeof(A0)
	move.w	d1,gnm_Flags+gnm_sizeof*2(A0)
	move.w	d1,gnm_Flags+gnm_sizeof*3(A0)

	lea	begin(pc),a2
	move.b	eus_special(A2),d0
	lsr.b	#6,d0
	move.b	d0,modeid(a5)		;0..3
	beq.s	.set
.lo
	lea	gnm_sizeof(a0),a0
	subq.b	#1,d0
	bne.s	.lo
.set
	move.w	#Checked!Checkit,gnm_flags(A0)

	lea	Item2(pc),a0
	move.w	d1,gnm_Flags(A0)
	move.w	d1,gnm_Flags+gnm_sizeof(A0)
	move.w	d1,gnm_Flags+gnm_sizeof*2(A0)
	move.w	d1,gnm_Flags+gnm_sizeof*3(A0)

	lea	begin(pc),a2
	move.b	eus_special+2(A2),d0
	lsr.b	#6,d0
	move.b	d0,mode2id(A5)		;0..3
	beq.s	.set2
.lo2
	lea	gnm_sizeof(a0),a0
	subq.b	#1,d0
	bne.s	.lo2
.set2
	move.w	#Checked!Checkit,gnm_flags(A0)

	lea	SlowItem(pc),a0
	move.w	#checkit!menutoggle,gnm_Flags(A0)
	move.b	eus_special(A2),d0
	lsr.b	#5,d0
	and.b	#1,d0
	move.b	d0,OnSlowMode(A5)	;0..1
	beq.s	.clr1
	move.w	#menutoggle!Checked!Checkit,gnm_flags(A0)
.clr1

	move.l	Gadsave(A5),a6
	lea.l	Project0NewMenu0(pc),a0
	lea.l	MTags0(pc),a1
	jsr	_LVOCreateMenusA(a6)
	move.l	d0,menuadr(a5)
	beq.s	.nomen
	move.l	d0,a0
	move.l	Vi(A5),a1
	lea.l	mtags0(pc),a2
	jsr	_LVOLayoutMenusA(a6)

	moveq	#0,d7
	rts
.free
	move.l	menuadr(a5),a0
	jsr	_LVOfreemenus(a6)
.nomen
	moveq	#-1,d7
	rts
********************* Visual Info Freigeben ***********************************
Freevi:
	move.l	vi(a5),a0
	jmp	_LVOfreevisualinfo(a6)
*********************** Men wechschmeisen ************************************
Freemenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	jsr	_LVOclearmenustrip(A6)
	
	move.l	gadsave(a5),a6
	move.l	Menuadr(a5),d0
	beq.s	.end
	move.l	d0,a0
	jmp	_LVOfreemenus(a6)
.end
	bsr	Freevi	;Visual Info Wegschmeien
	rts
********************* Men anhngen *************************
Addmenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	move.l	Menuadr(a5),a1
	jmp	_LVOsetmenustrip(a6)
*************************************************************
*     2. Bitmap erzeugen fr direkten Zugriff auf Bild      *
*       (per Blitter wird kopiert,Tiefe = 1)                *
*************************************************************
makebitmapII:
	moveq	#-1,d7			;Fehler
	move.w	BoxBreite(A5),d1
	move.w	BoxHoehe(A5),d2
	moveq	#1,d0
	lea	my_bitmapII(a5),a0
	clr.l	(a0)
	clr.l	4(a0)
	move.l	grafsave(a5),a6
	jsr	_LVOinitbitmap(a6)

	move.w	BoxBreite(A5),d0
	move.w	BoxHoehe(A5),d1
	move.w	d0,d2			;Anz Breite
	mulu	d1,d2			;mal Hhe = Anz Pixel
	lsr.l	#3,d2			;durch 8 = Anz Bytes
	add.l	#31,d2
	and.l	#~31,d2
.moreloop1
	addq.w	#1,d1
	move.w	d0,d3			;Anz Breite
	mulu	d1,d3			;mal Hhe = Anz Pixel
	lsr.l	#3,d3			;durch 8 = Anz Bytes
	cmp.l	d3,d2
	bgt.s	.moreloop1

	move.w	d0,pixhori(a5)
	move.w	d1,pixverti(a5)
	jsr	_LVOallocraster(a6)	
	move.l	d0,bm_planes+my_bitmapII(a5)
	beq.s	.norast

	lea	my_bitmapII(a5),a0
	move.w	(a0),d0			;Bytes pro Zeile
	mulu	bm_rows(a0),d0		;Mal Zeilen
	cmp.l	#32,d0
	bhi.s	.gt
	moveq	#32,d0			;zur Sicherheit (hinten ist auf 
					;jeden Fall Platz)
.gt
	add.l	bm_planes(a0),d0
	move.l	d0,Lastrow(A5)

	move.w	(a0),d0			;Bytes pro Zeile
	mulu	bm_rows(a0),d0		;Mal Zeilen
	lsr.l	#5,d0			;durch 32 (8 Register * 4 Bytes)
	beq.s	.aha1			;<-AHA! NUR EIN Duchlauf
	subq.l	#1,d0
.aha1
	move.w	d0,dbfcount(a5)		;Anzahl der Langworte zu lschen

	moveq	#0,d7			;kein Fehler
.norast
	tst.l	d7			;set Flags
	rts
**************************************************************
*                   Bitplane(s) freigeben                    *
**************************************************************
FreeBitmapII
	move.l	bm_planes+my_bitmapII(a5),d0
	beq.s	.norast
	clr.l	bm_planes+my_bitmapII(a5)
	move.l	d0,a0
	move.w	pixhori(a5),d0
	move.w	pixverti(a5),d1
	move.l	grafsave(a5),a6
	jsr	_LVOfreeraster(a6)
.norast
	rts
*************************************************************
*	Tabellen fr die Darstellung berechnen		    *
*************************************************************
MakeTables:
	move.w	my_bitmapII+bm_bytesperrow(a5),d7

						;Vertikaltabelle erstellen
						
	move.w	BoxHoehe(A5),d2			;Hhe der Box
	lsr.w	#1,d2
	move.w	d2,d3
	mulu	d7,d3				;Zeile in der Mitte
	move.w	d3,middlePos(A5)
	subq.w	#2,d2				;Amplitude begrenzen

	lea	VertiTab(A5),a0
	move.w	#128-1,d0
	moveq	#-128,d1
.part1
	move.w	d2,d4			;max. Auslenkung Y (Boxhhe/2)
	muls	d1,d4			;mal Wert (-128...127)
	divs	#128,d4			;durch Maxwert der Sampleamplitude
	muls	d7,d4			;Mal Bytes pro Zeile
	add.w	d3,d4			;in Mitte zentrieren
	move.w	d4,(a0)+		;abspeichern
	addq.w	#2,d1
	dbf	d0,.part1

	lea	VertiTabMI(A5),a0
	move.w	#128-1,d0
	moveq	#-128,d1
.part12
	move.w	d2,d4			;max. Auslenkung Y (Boxhhe/2)
	muls	d1,d4			;mal Wert (-128...127)
	divs	#128,d4			;durch Maxwert der Sampleamplitude
	bgt.s	.lo12
	neg.w	d4			;nur nach oben!
.lo12
	muls	d7,d4			;Mal Bytes pro Zeile
;	add.w	d3,d4			;in Mitte zentrieren
	move.w	d4,(a0)+		;abspeichern
	addq.w	#2,d1
	dbf	d0,.part12

	lea	VertiTabHalve(A5),a0
	move.w	#128-1,d0
	moveq	#-128,d1

	subq.w	#2,d2
	add.w	d2,d2
.part123
	move.w	d2,d4			;max. Auslenkung Y (Boxhhe/2)
	muls	d1,d4			;mal Wert (-128...127)
	divs	#128,d4			;durch Maxwert der Sampleamplitude
	blt.s	.lo1
	neg.w	d4
.lo1
	muls	d7,d4			;Mal Bytes pro Zeile
	add.w	d3,d4			;in Mitte zentrieren
	add.w	d3,d4			;nach unten setzen
	sub.w	d7,d4			;eine Zeile hoch
	move.w	d4,(a0)+		;abspeichern
	addq.w	#2,d1
	dbf	d0,.part123

	moveq	#0,d5
	move.w	BoxBreite(A5),d5		;Breite der Box in Pixeln
	lsr.w	#1,d5				;durch 2 mal 8

	move.w	BoxBreite(A5),d4		;Breite der Box in Pixeln
	move.w	#256-1,d0
	lea	HoriTAB(a5),a0
	moveq	#-128,d1
.hori1
	move.w	d1,d6
	addq.w	#1,d1
	muls	d4,d6
	asr.l	#8,d6

	add.l	d5,d6			;auf Mitte
	move.l	d6,d2
	
	lsr.w	#3,d2			;Hori Bytes
	move.b	d2,(A0)+		;Hori Bytes
	and.b	#7,d6
	moveq	#7,d2
	sub.b	d6,d2
	move.b	d2,(a0)+		;Hori Pixels
	dbf	d0,.hori1

RET	rts
*****************************************************************
allocmsg
	movem.l	d1-a6,-(sp)
	move.l	4.w,a6
	moveq	#UM_Sizeof,d0
	move.l	#$10001,d1
	jsr	_LVOallocmem(A6)
	movem.l	(sp)+,d1-a6
	tst.l	d0
	rts
*****************************************************************
freemsg
	moveq	#UM_sizeof,d0
	move.l	4.w,a6
	jsr	_LVOfreemem(A6)
	rts
*************************************************************
*           Windowrefresh und Detaildarstellung             *
*************************************************************
Refresh:
	move.l	winhandle(a5),d0
	beq.w	RET
	move.l	d0,a2

	move.w	myhoehe1(a5),d1		;Window im ZIP-Modus ?
	cmp.w	wd_height(a2),d1
	beq	RET			;ja,kein Refresh

	move.l	grafsave(a5),a6
	move.l	wd_rport(a2),a1
	moveq	#1,d0
	jsr	_LVOsetapen(A6)

	move.l	wd_rport(a2),a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	wd_rport(a2),a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5

	move.b	WD_Borderleft(a2),d7
	ext.w	d7
	move.l	wd_rport(a2),a1

	move.b	#1,rp_areaptsz(a1)
	lea	patt1(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	d7,d0			;x1
	move.w	myhoehe1(A5),d1		;y1

	move.w	wd_width(a2),d2
	move.b	WD_Borderright(a2),d3
	ext.w	d3
	sub.w	d3,d2
	move.w	wd_height(a2),d3
	move.b	WD_Borderbottom(a2),d6
	ext.w	d6
	sub.w	d6,d3

	movem.l	d4-d5,-(sp)
	jsr	_LVOrectfill(a6)

	move.l	wd_rport(a2),a1
	lea	patt2(pc),a0
	move.l	a0,rp_areaptrn(a1)

	addq.w	#RandabstandH,d7
	move.w	d7,d6
	moveq	#3,d5
.lo1
	move.w	d6,d0			;Left
	move.w	myhoehe1(a5),d1		;Top
	addq.w	#RandAbstandV,d1
	move.w	RoomPerBoxH(a5),d2
	move.w	RoomPerBoxV(A5),d3
	add.w	d0,d2
	add.w	d1,d3
	move.l	wd_rport(a2),a1
	jsr	_LVOrectfill(a6)
	addq.w	#ZwischenRaum,d6
	add.w	RoomPerBoxH(a5),d6
	dbf	d5,.lo1

	move.l	wd_rport(a2),a1
	move.w	d7,d0
	addq.w	#8,d0
	move.w	myhoehe1(A5),d1		;y1
	addq.w	#4,d1
	jsr	_LVOmove(A6)

	movem.l	(Sp)+,d4-d5

	move.l	wd_rport(a2),a1
	move.b	d4,rp_areaptsz(a1)
	move.l	d5,rp_areaptrn(a1)

	move.l	gadsave(a5),a6
	moveq	#3,d5
.lo2
	move.w	d7,d0
	move.l	wd_rport(a2),a0
	lea	mytags(a5),a3
	move.l	#GT_Visualinfo,(a3)+
	move.l	vi(a5),(a3)+
	move.l	#GTBB_recessed,(a3)+
	move.l	#0,(a3)+
	move.l	#tag_done,(a3)+
	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
	move.l	a3,a1
	move.w	myhoehe1(a5),d1	;Top
	add.w	#RandabstandV,d1
	move.w	RoomPerBoxH(a5),d2
	move.w	RoomPerBoxV(A5),d3
	jsr	_LVOdrawbevelboxa(a6)
	addq.w	#zwischenraum,d7
	add.w	RoomPerBoxH(a5),d7
	dbf	d5,.lo2

	move.l	winhandle(A5),a0
	move.l	intsave(a5),a6
	jmp	_LVOrefreshwindowframe(A6)
****************************************************************************
Clear:
	lea.l	my_bitmapII(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes pro Zeile
	mulu	bm_rows(a0),d0		;Mal Zeilen
	move.l	bm_planes(a0),d1
	beq.s	.skip
	move.l	d1,a0			;1.Bitplane
	lsr.w	#2,d0			;durch 4 (wegen LW lsch)
	subq.l	#1,d0

	moveq	#-1,d3
	move.b	modeid(A5),d1
	cmp.b	#3,d1
	beq.s	.black
.clr
	clr.l	(a0)+
	dbf	d0,.clr
	bra.s	.skip
.black
	move.l	d3,(a0)+
	dbf	d0,.black
.skip
	rts
**********************************************************************
* ScopeMainRoutine, berechnet Positionen,zeichnet ein und stellt dar *
**********************************************************************
Analyze1
	addq.w	#1,counter(A5)
;=============== Kanle auswerten ============================================

;	move.w	word8(a5),d0		;irgendwas mit`m Eagleplayer nicht in
;					;Ordnung ?
;	beq.s	.ok			;alles klar
;	move.w	counter(A5),d0
;	cmp.w	#50*50*5,d0		;1sek*60*5 = 5 Minuten	
;	blo.s	.ok
;
;	move.l	_dos(a5),a0
;	clr.l	-30+2(A0)		;LVOOpen
;	addq.l	#1,-114+2+3(A0)		;fies aber gut (_LVOInfo)
;.ok

	lea	AN_Struct(a5),a4;Analyzer Struktur
	moveq	#-1,d2				;Alle Kanle
	move.w	ups_flags(a4),d1
	and.w	#UPSB_Dmacon,d1			;Flag ob Kanle an/aus ?
	beq.s	.nodmacon
	move.w	UPS_Dmacon(a4),d2	;Ja,zugehrige Werte ranholen
.nodmacon
	and.w	voicesmerk(A5),d2

	lea	vol64(pc),a2

	ifne	debug
	lea	begin(pc),a4
	move.l	EUS_EPBase(a4),a4
	lea	EPG_someprefs(a4),a4
	else
	move.l	flagsadr(A5),a4
	endc

	move.l	(a4),d6
	and.l	#EGPRB_MasterVolume,d6
	beq.s	.NoMaster

	lea	begin(pc),a2
	move.l	EUS_EPBase(a2),a2
	lea	EPG_Voice1vol(a2),a2
.nomaster
	lea	permerk(a5),a3	;SamplePeriod merken und Spielzeit der Samples
				;in 1/50 Sekunden

	move.b	Slowcnt(A5),d7
	addq.b	#1,d7
	and.b	OnSlowMode(A5),d7
	move.b	d7,Slowcnt(A5)

	moveq	#0,d4
	lea	AN_Struct(a5),a4;Analyzer Struktur
	bsr	Scope1
	moveq	#0,d0
	bsr	IntoWindowII

	addq.l	#4,a3
	lea	AN_Struct+UPS_Voice2Adr(a5),a4 ;Analyzer Struktur 2.Stimme
	bsr	Scope1
	moveq	#1,d0
	bsr	IntoWindowII

	addq.l	#4,a3
	lea	AN_Struct+UPS_Voice3Adr(a5),a4 ;Analyzer Struktur 2.Stimme
	bsr	Scope1
	moveq	#2,d0
	bsr	IntoWindowII

	addq.l	#4,a3
	lea	AN_Struct+UPS_Voice4Adr(a5),a4 ;Analyzer Struktur 2.Stimme
	bsr	Scope1
	moveq	#3,d0
	bsr	IntoWindowII
	rts
;****************** Auswerten der UPS Struktur ****************************
Scope1:
;====================== Bereich lschen ===================================
	tst.b	Slowcnt(A5)
	bne.s	.letitbe

	movem.l	d0-a6,-(sp)

	move.w	dbfcount(a5),d0		;Anzahl der Langworte/32 zu lschen

	move.b	modeid(A5),d1
	cmp.b	#3,d1
	beq.s	.black
	movem.l	nulls(a5),d1-d7/a1
	bra.s	.white
.black
	movem.l	fulls(a5),d1-d7/a1
.white
	move.l	my_bitmapII+bm_planes(a5),a0	;1.Bitplane
	movem.l	d1-d7,(a0)
	
	move.l	lastrow(A5),a0
.clr
	movem.l	d1-d7/a1,-(a0)
	dbf	d0,.clr
	movem.l	(sp)+,d0-a6
.letitbe
;============================================================================
	move.w	#$80,d5

	lsr.w	#1,d2
	bcc.s	.no
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,A1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a1
	lea.l	my_bitmapII(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row
	move.l	bm_planes(a0),a0	;1.Bitplane
	move.w	#700,d4

	movem.l	d0-a6,-(sp)
	bsr	copybitmapII2
	movem.l	(sp)+,d0-a6
	addq.w	#1,2(a3)
	bra.s	.no
.copyto
	move.w	UPS_Voice1len(a4),d4
	movem.l	d0-a6,-(sp)
	bsr	copybitmapII
	movem.l	(sp)+,d0-a6
	addq.w	#1,2(a3)
.no
	rts
;============ Kopieren des Samples in die Bitmap =======================
copybitmapII
	lea.l	my_bitmapII(a5),a0
	move.l	bm_planes(a0),a0	;1.Bitplane

;Anzahl der Bytes,die in 1/50 Sekunde vom DMA gelesen werden
;Bytes = 74074/Sampleperiod [ (1/(2.79*10-7)*50)/Sampleperiod ]
;Abwandlung : statt 74074: 65535

	and.l	#$ffff,d4
	add.l	d4,d4		;Samplelnge Words -> Samplelnge Bytes

	moveq	#0,d0
	move.w	2(a3),d0
	cmp.w	#$180,d0	;nur zur Sicherheit
	blo.s	.hi1
	clr.w	2(A3)
	clr.w	d0
.hi1
	swap	d0		;=d0*65535
	lsr.l	#2,d0
	divu	(a3),d0		;durch Sampleperiod
	and.l	#$ffff,d0
	lsl.l	#2,d0
	cmp.l	d4,d0		;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a1
	subq.w	#1,2(a3)
	clr.w	(a3)
	moveq	#0,d0
	move.w	#700,d4
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.divu
	moveq	#0,d0
	clr.w	2(a3)
	move.w	#700,d4
	bra.s	.cbm_ok
.divu
	divu	d4,d0
	swap	d0
;	clr.w	2(a3)			;bloss raus lassen, dann sieht es
					;nochmal so gut aus !!
	and.l	#$ffff,d0
.cbm_ok
	move.l	a1,samadr(a5)		;temporr
	add.l	d0,a1
	move.l	d4,d6			;Samplelnge
	move.l	d6,samlen(A5)
	sub.l	d0,d4			;Rest im Sample
	move.l	d4,samrest(A5)
CopybitmapII2				;2. Einsprung
	tst.b	Slowcnt(A5)
	beq.s	.show
	rts
.show
	move	BoxBreite(A5),d7	;Schleifenzhler Balkenanzahl
	subq.w	#1,d7

	move.b	modeid(A5),d1
	cmp.b	#3,d1
	beq	.main4

	move.b	mode2id(A5),d3
	cmp.b	#1,d3
	beq	DoVertical
	cmp.b	#3,d3
	beq	DoMirror

	lea	Vertitab+128(a5),a3
	cmp.b	#2,d3
	bne.s	.skipHAL
	lea	VertitabHALVE+128(a5),a3
.skipHAL
	tst.b	MC68020on(A5)
	bne	Opti020Routines

	tst.b	d1
	bne.s	.main2

	move.w	UPS_Voice1vol(a4),d1
	cmp.w	#63,d1
	blo.s	.ok
	move.w	#63,d1
.ok
	mulu	(A2)+,d1		;Mastervolume
					;normal: lsr#6 und dann lsl#9
					;-> dadurch statt lsr#6 unten einfach
	lsl.w	#3,d1			;swap
	and.w	#~511,d1
.mainloop
	move.b	(a1)+,d2
	ext.w	d2			;Volume handling
	muls	d1,d2			;statt lsr#6 einfach
	swap	d2			;swap
	add.w	d2,d2
	move.w	(a3,d2.w),d2		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	or.b	d5,(a0,d2.w)

	subq.l	#1,d4
	bge.s	.hi
	move.l	d6,d4			;Samplelnge
	move.l	samadr(A5),a1
.hi
	ror.b	d5
	bcc.s	.no
	addq.l	#1,a0
.no
	dbf	d7,.mainloop
	rts
.main2
	;----------------------- Solid Mode --------------------------------
	subq.b	#1,d1
	bne.w	.main3

	move.w	MY_BitmapII+BM_Bytesperrow(A5),d0

	move.w	UPS_Voice1vol(a4),d1
	cmp.w	#63,d1
	blo.s	.ok1
	move.w	#63,d1
.ok1	mulu	(A2)+,d1
	lsl.w	#3,d1
	and.w	#~511,d1

	moveq	#0,d6

	cmp.b	#2,d3
	beq.s	.solidHalve

	move.w	middlepos(a5),d3
.mainloop2
	move.w	d3,d2				;Wanderpunkt
	move.b	(a1)+,d6
	beq.s	.end2
	ext.w	d6
 	muls	d1,d6
	swap	d6
	add.w	d6,d6
	blt.s	.2nd
	move.w	(a3,d6.w),d6			;<- da wolln wir hin!
.doagain
	or.b	d5,(a0,d2.w)
	add.w	d0,d2				;einen runter
	cmp.w	d6,d2
	ble.s	.doagain
	bra.s	.end2nd
.2nd
	move.w	(a3,d6.w),d6			;<- da wolln wir hin!
.doagain2
	or.b	d5,(a0,d2.w)
	sub.w	d0,d2				;einen runter
	cmp.w	d6,d2
	bge.s	.doagain2
	bra.s	.end2nd
.end2
	or.b	d5,(a0,d2.w)
.end2nd
	subq.l	#1,d4
	bge.s	.hi12
	move.l	samlen(A5),d4
	move.l	samadr(A5),a1
.hi12
	ror.b	d5
	bcc.s	.no2
	addq.l	#1,a0
.no2
	dbf	d7,.mainloop2
	rts
	;------------------------ Solid Mode halbiert ----------------------
.solidHalve
	move.w	middlepos(a5),d3
	add.w	d3,d3
	sub.w	d0,d3
.mainloop2_2
	move.w	d3,d2				;Wanderpunkt
	move.b	(a1)+,d6
	beq.s	.end2_2
	ext.w	d6
	muls	d1,d6
	swap	d6
	add.w	d6,d6
	blt.s	.2nd_2
	neg.w	d6
.2nd_2
	move.w	(a3,d6.w),d6			;<- da wolln wir hin!
.doagain2_2
	or.b	d5,(a0,d2.w)
	sub.w	d0,d2				;einen hoch
	cmp.w	d6,d2
	bge.s	.doagain2_2
	bra.s	.end2nd_2
.end2_2
	or.b	d5,(a0,d2.w)
.end2nd_2
	subq.l	#1,d4
	bge.s	.hi12_2
	move.l	samlen(A5),d4
	move.l	samadr(A5),a1
.hi12_2
	ror.b	d5
	bcc.s	.no2_2
	addq.l	#1,a0
.no2_2
	dbf	d7,.mainloop2_2
	rts

.main3:
	;------------------------ Line Mode ---------------------------------
	subq.b	#1,d1
	bne.w	.main4

	move.w	UPS_Voice1vol(a4),d4
	cmp.w	#63,d4
	blo.s	.ok2
	move.w	#63,d4
.ok2
	mulu	(A2)+,d4		;Mastervolume
	lsl.w	#3,d4
	and.w	#~511,d4

	subq.w	#1,d7
	
.mainloop3
	move.w	MY_BitmapII+bm_bytesperrow(A5),d0
	move.b	(a1)+,d6
	move.b	(a1),d1
	ext.w	d6
	muls	d4,d6
	swap	d6
	ext.w	d1
	muls	d4,d1
	swap	d1
	add.w	d6,d6
	add.w	d1,d1

	move.w	(a3,d1.w),d1		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.w	(a3,d6.w),d6		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.w	d6,d2
	sub.w	d1,d2
	ext.l	d2
	divs	d0,d2			;Durch Bytes pro Zeile
	beq.s	.set
	bgt.s	.oks2
	neg.w	d2		;erstmal
	neg.w	d0
.oks2
	moveq	#0,d3
	lsr.w	d2
	addx.w	d2,d3
.points1
	or.b	d5,(a0,d6.w)
	sub.w	d0,d6
	dbf	d2,.points1

	subq.w	#1,d3
	blt.s	.set2

	ror.b	d5
	bcc.s	.nozw3
	addq.l	#1,a0
.nozw3
	or.b	d5,(a0,d1.w)
	add.w	d0,d1
	dbf	d3,.nozw3
	bra.s	.wei4
.set
	or.b	d5,(a0,d6.w)
.set2
	ror.b	#1,d5
	bcc.s	.no3
	addq.l	#1,a0
.no3
	or.b	d5,(a0,d1.w)
.wei4
	subq.l	#1,samrest(a5)	
	bne.s	.wei5
	move.l	samlen(A5),samrest(a5)		;Samplelnge
	move.l	samadr(A5),a1
.wei5
	dbf	d7,.mainloop3
	rts
	;------------------------ Space Mode --------------------------
.main4
	move	RoomPerBoxH(A5),d7	;Schleifenzhler Pixelanzahl
	add	RoomPerBoxV(A5),d7	;Schleifenzhler Pixelanzahl

	move.w	UPS_Voice1vol(a4),d1
	cmp.w	#63,d1
	blo.w	.ok12
	move.w	#63,d1
.ok12
	mulu	(A2)+,d1		;Mastervolume
	lsl.w	#3,d1
	and.w	#~511,d1

	lea	nulls(A5),a2
	cmp.l	a1,a2
	beq.s	.red

	lea	20(a1),a2	;abstimmen auf bestmgliches Ergebnis
	moveq	#0,d3

	lea	VertiTab+128(a5),a3
	lea	HORItab+256(a5),a4

	tst.b	MC68020on(A5)
	bne.s	.main4020
.mainloop4
	move.b	(a1)+,d6
	ext.w	d6
	muls	d1,d6
	swap	d6
	add.w	d6,d6
	move.w	(a3,d6.w),d6		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.b	(a2)+,d3
	ext.w	d3
	add.w	d3,d3
	muls	d1,d3
	swap	d3
	add.w	d3,d3
	move.b	1(a4,d3.w),d2
	move.b	(a4,d3.w),d3
	ext.w	d3
	add.w	d3,d6
	bclr	d2,(a0,d6.w)

	subq.l	#1,d4
	bge.s	.hi13
	move.l	samlen(A5),d4
	move.l	samadr(A5),a1
.hi13
	dbf	d7,.mainloop4
.red
	rts
.main4020
	move.b	(a1)+,d6
	ext.w	d6
	muls	d1,d6
	swap	d6
	move.w	(a3,d6.w*2),d6		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.b	(a2)+,d3
	ext.w	d3
	add.w	d3,d3
	muls	d1,d3
	swap	d3
	move.b	1(a4,d3.w*2),d2
	move.b	(a4,d3.w*2),d3
	ext.w	d3
	add.w	d3,d6
	bclr	d2,(a0,d6.w)

	subq.l	#1,d4
	bge.s	.hi13_20
	move.l	samlen(A5),d4
	move.l	samadr(A5),a1
.hi13_20
	dbf	d7,.main4020
	rts
	;******************** Vertikaler Modus **************************
DoVertical:
	move.w	MY_BitmapII+BM_Bytesperrow(A5),d0

	move.w	BoxHoehe(a5),d7
	subq.w	#1,d7

	move.b	modeid(A5),d1
	bne.s	.main2
	;---------------------- Standardmodus vertikal -----------------------

	move.w	UPS_Voice1vol(a4),d1
	cmp.w	#63,d1
	blo.s	.ok
	move.w	#63,d1
.ok
	mulu	(A2)+,d1		;Mastervolume
					;normal: lsr#6 und dann lsl#9
					;-> dadurch statt lsr#6 unten einfach
	lsl.w	#3,d1			;swap
	and.w	#~511,d1
	lea	HORItab+256(a5),a3
.mainloop
	move.b	(a1)+,d3
	ext.w	d3
	add.w	d3,d3
	muls	d1,d3
	swap	d3
	add.w	d3,d3
	move.b	1(a3,d3.w),d2
	move.b	(a3,d3.w),d3
	ext.w	d3
	bset	d2,(a0,d3.w)

	subq.l	#1,d4
	bge.s	.hi
	move.l	d6,d4			;Samplelnge
	move.l	samadr(A5),a1
.hi
	add.w	d0,a0			;eine Zeile tiefer
	dbf	d7,.mainloop
	rts
	;--------------------- Solid Vertikal -----------------------------
.main2
	subq.b	#1,d1
	bne.s	.main3

	move.w	UPS_Voice1vol(a4),d1
	cmp.w	#63,d1
	blo.s	.ok2
	move.w	#63,d1
.ok2
	mulu	(A2)+,d1		;Mastervolume
					;normal: lsr#6 und dann lsl#9
					;-> dadurch statt lsr#6 unten einfach
	lsl.w	#3,d1			;swap
	and.w	#~511,d1

	lea	dummy(a5),a3
	move.b	HORItab+256(a5),d3
	ext.w	d3
	move.w	d3,(A3)

	moveq	#0,d2
	moveq	#0,d3
	move.b	HORItab+256+1(a5),d3
	bset	d3,d2
	move.b	d2,2(a3)

	move.w	BoxBreite(A5),d6
	lsr.w	#1,d6			;max. Auslenkung in eine Richtung
.mainloop2
	move.w	(a3),d3
	move.b	2(a3),d2

	move.b	(a1)+,d5
	ext.w	d5
	muls	d1,d5			;Vol Handling
	swap	d5			;max. +-64
	muls	d6,d5
	asr.w	#6,d5
	blt.s	.left
.lo
	or.b	d2,(a0,d3.w)
	ror.b	d2
	bcc.s	.nozw1
	addq.w	#1,d3
.nozw1
	dbf	d5,.lo
	bra.s	.lo2
.left
	neg.w	d5
.left2
	or.b	d2,(a0,d3.w)
	rol.b	d2
	bcc.s	.nozw2
	subq.w	#1,d3
.nozw2
	dbf	d5,.left2
.lo2
	subq.l	#1,d4
	bge.s	.hi2
	move.l	samlen(A5),d4		;Samplelnge
	move.l	samadr(A5),a1
.hi2
	add.w	d0,a0			;eine Zeile tiefer
	dbf	d7,.mainloop2
	rts
.main3
	;----------------------- Line-modus vertikal -------------------------
	;-- sieht ziemlich lausig aus und is obendrein noch tierisch langsam --
	subq.w	#1,d7
	
	move.w	UPS_Voice1vol(a4),d1
	cmp.w	#63,d1
	blo.s	.ok3
	move.w	#63,d1
.ok3
	mulu	(A2)+,d1		;Mastervolume
					;normal: lsr#6 und dann lsl#9
					;-> dadurch statt lsr#6 unten einfach
	lsl.w	#3,d1			;swap
	and.w	#~511,d1

	move.w	BoxBreite(A5),d6
	lsr.w	#1,d6			;max. Auslenkung in eine Richtung

	lea	HORItab+256(a5),a3
.mainloop3
	move.b	(a1)+,d3
	ext.w	d3
	add.w	d3,d3
	muls	d1,d3
	swap	d3
	move.w	d3,d5
	add.w	d3,d3
	move.b	1(a3,d3.w),d2
	move.b	(a3,d3.w),d3
	ext.w	d3
	bset	d2,(a0,d3.w)
	asr.w	d5
	moveq	#0,d4
	bset	d2,d4
	move.b	(a1),d2
	ext.w	d2
	muls	d1,d2			;Vol Handling
	swap	d2			;max. +-64
	sub.w	d5,d2			;stop-start
	muls	d6,d2
	asr.w	#7,d2
	beq.s	.next
	bgt.s	.hihi
	neg.w	d2
	subq.w	#1,d2
	beq.s	.next
	move	d2,d5
.loh
	or.b	d4,(a0,d3.w)
	rol.b	d4
	bcc.s	.nozw2_23l
	subq.w	#1,d3
.nozw2_23l
	dbf	d2,.loh

	add.w	d0,a0			;eine Zeile tiefer
.loh2
	or.b	d4,(a0,d3.w)
	rol.b	d4
	bcc.s	.nozw2_24l
	subq.w	#1,d3
.nozw2_24l
	dbf	d5,.loh2

	bra.s	.skipnext
.hihi
	subq.w	#1,d2
	beq.s	.next
	move	d2,d5
.hih
	ror.b	d4
	bcc.s	.nozw2_231
	addq.w	#1,d3
.nozw2_231
	or.b	d4,(a0,d3.w)
	dbf	d2,.hih

	add.w	d0,a0			;eine Zeile tiefer
.hih2
	ror.b	d4
	bcc.s	.nozw2_24
	addq.w	#1,d3
.nozw2_24
	or.b	d4,(a0,d3.w)
	dbf	d5,.hih2
	bra.s	.skipnext
.next
	add.w	d0,a0			;eine Zeile tiefer
.skipnext
	subq.l	#1,samrest(a5)	
	bge.s	.hi2_3
	move.l	samlen(A5),samrest(a5)		;Samplelnge
	move.l	samadr(A5),a1
.hi2_3
	dbf	d7,.mainloop3
	rts
	;****************** Modus: spiegele an der Mittelachse ***************
DoMirror:
	lea	VertitabMI+128(a5),a3

	tst.b	d1
	bne.s	.main2

	move.w	UPS_Voice1vol(a4),d1
	cmp.w	#63,d1
	blo.s	.ok
	move.w	#63,d1
.ok
	mulu	(A2)+,d1		;Mastervolume
					;normal: lsr#6 und dann lsl#9
					;-> dadurch statt lsr#6 unten einfach
	lsl.w	#3,d1			;swap
	and.w	#~511,d1
	move.w	middlePos(A5),d3
.mainloop
	move.b	(a1)+,d2
	ext.w	d2			;Volume handling
	muls	d1,d2			;statt lsr#6 einfach
	swap	d2			;swap
	add.w	d2,d2
	move.w	(a3,d2.w),d2		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.w	d2,d0
	add.w	d3,d2
	or.b	d5,(a0,d2.w)
	neg.w	d0
	add.w	d3,d0
	or.b	d5,(a0,d0.w)

	subq.l	#1,d4
	bge.s	.hi
	move.l	d6,d4			;Samplelnge
	move.l	samadr(A5),a1
.hi
	ror.b	#1,d5
	bcc.s	.no
	addq.l	#1,a0
.no
	dbf	d7,.mainloop
	rts
.main2
	lea	Vertitab+128(a5),a3

	sub.b	#1,d1
	bne.s	.main3

	move.w	MY_BitmapII+BM_Bytesperrow(A5),d0

	move.w	UPS_Voice1vol(a4),d1
	cmp.w	#63,d1
	blo.s	.ok1
	move.w	#63,d1
.ok1	mulu	(A2)+,d1
	lsl.w	#3,d1
	and.w	#~511,d1

	moveq	#0,d6
.mainloop2
	move.w	middlepos(a5),d3
	move.w	d3,d2				;Wanderpunkt
	move.b	(a1)+,d6
	beq.s	.end2
	ext.w	d6
 	muls	d1,d6
	swap	d6
	add.w	d6,d6
	blt.s	.2nd
	move.w	(a3,d6.w),d6			;<- da wolln wir hin!
.doagain
	or.b	d5,(a0,d2.w)
	add.w	d0,d2				;einen runter
	or.b	d5,(a0,d3.w)
	sub.w	d0,d3
	cmp.w	d6,d2
	ble.s	.doagain
	bra.s	.end2nd
.2nd
	move.w	(a3,d6.w),d6			;<- da wolln wir hin!
.doagain2
	or.b	d5,(a0,d2.w)
	sub.w	d0,d2				;einen runter
	or.b	d5,(a0,d3.w)
	add.w	d0,d3				;einen runter
	cmp.w	d6,d2
	bge.s	.doagain2
	bra.s	.end2nd
.end2
	or.b	d5,(a0,d2.w)
.end2nd
	subq.l	#1,d4
	bge.s	.hi12
	move.l	samlen(A5),d4
	move.l	samadr(A5),a1
.hi12
	ror.b	#1,d5
	bcc.s	.no2
	addq.l	#1,a0
.no2
	dbf	d7,.mainloop2
	rts
.main3
	;------------------------ Line Mode ---------------------------------

	move.w	UPS_Voice1vol(a4),d4
	cmp.w	#63,d4
	blo.s	.ok2
	move.w	#63,d4
.ok2
	mulu	(A2)+,d4		;Mastervolume
	lsl.w	#3,d4
	and.w	#~511,d4

	subq.w	#1,d7

	moveq	#0,d3
	move.w	middlepos(a5),d3
	add.w	d3,d3
	move.w	d3,a6	
.mainloop3
	move.w	d7,a4
	move.w	MY_BitmapII+bm_bytesperrow(A5),d0
	move.b	(a1)+,d6
	move.b	(a1),d1
	ext.w	d6
	muls	d4,d6
	swap	d6
	ext.w	d1
	muls	d4,d1
	swap	d1
	add.w	d6,d6
	add.w	d1,d1

	move.w	(a3,d1.w),d1		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.w	(a3,d6.w),d6		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.w	d6,d2
	sub.w	d1,d2
	ext.l	d2
	divs	d0,d2			;Durch Bytes pro Zeile
	beq.s	.set
	bgt.s	.oks2
	neg.w	d2		;erstmal
	neg.w	d0
.oks2
	move.w	d6,d7
	neg.w	d7
	add.w	a6,d7

	moveq	#0,d3
	lsr.w	d2
	addx.w	d2,d3
.points1
	or.b	d5,(a0,d6.w)
	sub.w	d0,d6
	or.b	d5,(a0,d7.w)
	add.w	d0,d7
	dbf	d2,.points1

	subq.w	#1,d3
	blt.s	.set2

	move.w	d1,d7
	neg.w	d7
	add.w	a6,d7

	ror.b	#1,d5
	bcc.s	.nozw3
	addq.l	#1,a0
.nozw3
	or.b	d5,(a0,d1.w)
	add.w	d0,d1
	or.b	d5,(a0,d7.w)
	sub.w	d0,d7
	dbf	d3,.nozw3
	bra.s	.wei4
.set
	or.b	d5,(a0,d6.w)
.set2
	ror.b	#1,d5
	bcc.s	.no3
	addq.l	#1,a0
.no3
	or.b	d5,(a0,d1.w)
.wei4
	subq.l	#1,samrest(a5)	
	bne.s	.wei5
	move.l	samlen(A5),samrest(a5)		;Samplelnge
	move.l	samadr(A5),a1
.wei5
	move.w	a4,d7
	dbf	d7,.mainloop3
	rts
	;****************** 020 Optimierte Standardroutinen ***************
Opti020Routines
	tst.b	d1
	bne.s	.main2

	move.w	UPS_Voice1vol(a4),d1
	cmp.w	#63,d1
	blo.s	.ok
	move.w	#63,d1
.ok
	mulu	(A2)+,d1		;Mastervolume
					;normal: lsr#6 und dann lsl#9
					;-> dadurch statt lsr#6 unten einfach
	lsl.w	#3,d1			;swap
	and.w	#~511,d1
.mainloop
	move.b	(a1)+,d2
	ext.w	d2			;Volume handling
	muls	d1,d2			;statt lsr#6 einfach
	swap	d2			;swap
	move.w	(a3,d2.w*2),d2		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	or.b	d5,(a0,d2.w)

	subq.l	#1,d4
	bge.s	.hi
	move.l	d6,d4			;Samplelnge
	move.l	samadr(A5),a1
.hi
	ror.b	#1,d5
	bcc.s	.no
	addq.l	#1,a0
.no
	dbf	d7,.mainloop
	rts
.main2
	;----------------------- Solid Mode --------------------------------
	subq.b	#1,d1
	bne.w	.main3

	move.w	MY_BitmapII+BM_Bytesperrow(A5),d0

	move.w	UPS_Voice1vol(a4),d1
	cmp.w	#63,d1
	blo.s	.ok1
	move.w	#63,d1
.ok1	mulu	(A2)+,d1
	lsl.w	#3,d1
	and.w	#~511,d1

	moveq	#0,d6

	cmp.b	#2,d3
	beq.s	.solidHalve

	move.w	middlepos(a5),d3
.mainloop2
	move.w	d3,d2				;Wanderpunkt
	move.b	(a1)+,d6
	beq.s	.end2
	ext.w	d6
	blt.s	.2nd
 	muls	d1,d6
	swap	d6
	move.w	(a3,d6.w*2),d6			;<- da wolln wir hin!
.doagain
	or.b	d5,(a0,d2.w)
	add.w	d0,d2				;einen runter
	cmp.w	d6,d2
	ble.s	.doagain
	bra.s	.end2nd
.2nd
 	muls	d1,d6
	swap	d6
	move.w	(a3,d6.w*2),d6			;<- da wolln wir hin!
.doagain2
	or.b	d5,(a0,d2.w)
	sub.w	d0,d2				;einen runter
	cmp.w	d6,d2
	bge.s	.doagain2
	bra.s	.end2nd
.end2
	or.b	d5,(a0,d2.w)
.end2nd
	subq.l	#1,d4
	bge.s	.hi12
	move.l	samlen(A5),d4
	move.l	samadr(A5),a1
.hi12
	ror.b	#1,d5
	bcc.s	.no2
	addq.l	#1,a0
.no2
	dbf	d7,.mainloop2
	rts
	;------------------------ Solid Mode halbiert ----------------------
.solidHalve
	move.w	middlepos(a5),d3
	add.w	d3,d3
	sub.w	d0,d3
.mainloop2_2
	move.w	d3,d2				;Wanderpunkt
	move.b	(a1)+,d6
	beq.s	.end2_2
	ext.w	d6
	blt.s	.2nd_2
	neg.w	d6
.2nd_2
	muls	d1,d6
	swap	d6
	move.w	(a3,d6.w*2),d6			;<- da wolln wir hin!
.doagain2_2
	or.b	d5,(a0,d2.w)
	sub.w	d0,d2				;einen hoch
	cmp.w	d6,d2
	bge.s	.doagain2_2
	bra.s	.end2nd_2
.end2_2
	or.b	d5,(a0,d2.w)
.end2nd_2
	subq.l	#1,d4
	bge.s	.hi12_2
	move.l	samlen(A5),d4
	move.l	samadr(A5),a1
.hi12_2
	ror.b	#1,d5
	bcc.s	.no2_2
	addq.l	#1,a0
.no2_2
	dbf	d7,.mainloop2_2
	rts

.main3:
	;------------------------ Line Mode ---------------------------------
	move.w	UPS_Voice1vol(a4),d4
	cmp.w	#63,d4
	blo.s	.ok2
	move.w	#63,d4
.ok2
	mulu	(A2)+,d4		;Mastervolume
	lsl.w	#3,d4
	and.w	#~511,d4

	subq.w	#1,d7
	
 	move.b	(a1)+,d6
	ext.w	d6
	muls	d4,d6
	swap	d6
	move.w	(a3,d6.w*2),d6		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.w	d6,a2
.mainloop3
	move.w	MY_BitmapII+bm_bytesperrow(A5),d0
	move.w	a2,d6			;letzten Punkt holen (zum Vergleich
					;wo wir hinmssen)
	move.b	(a1)+,d1
	ext.w	d1
	muls	d4,d1
	swap	d1
	move.w	(a3,d1.w*2),d1		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.w	d1,a2			;Punkt sichern
	
	move.w	d6,d2
	sub.w	d1,d2
	ext.l	d2
	divs	d0,d2			;Durch Bytes pro Zeile
	beq.s	.set
	bgt.s	.oks2
	neg.w	d2		;erstmal
	neg.w	d0
.oks2
	moveq	#0,d3
	lsr.w	d2
	addx.w	d2,d3
.points1
	or.b	d5,(a0,d6.w)
	sub.w	d0,d6
	dbf	d2,.points1

	subq.w	#1,d3
	blt.s	.set2

	ror.b	d5
	bcc.s	.nozw3
	addq.l	#1,a0
.nozw3
	or.b	d5,(a0,d1.w)
	add.w	d0,d1
	dbf	d3,.nozw3
	bra.s	.wei4
.set
	or.b	d5,(a0,d6.w)
.set2
	ror.b	d5
	bcc.s	.no3
	addq.l	#1,a0
.no3
	or.b	d5,(a0,d1.w)
.wei4
	subq.l	#1,samrest(a5)
	bne.s	.wei5
	move.l	samlen(A5),samrest(a5)		;Samplelnge
	move.l	samadr(A5),a1
.wei5
	dbf	d7,.mainloop3
	rts
; ========= In das Window (dessen Rastport) kopieren =====================
; ============== ZielPosition X2 in D2 bergeben =========================
intowindowII:
	movem.l	d0-a6,-(Sp)
	tst.b	Slowcnt(A5)
	bne.s	.noe

	move.l	grafsave(a5),a6
	move.l	winhandle(a5),a1
	move.l	wd_rport(a1),a1		;Rastport (Ziel)

	moveq	#Zwischenraum,d2	;Platz zwischen den Fensterchen
	add.w	RoomPerBoxH(A5),d2	;Breite eines Fensterchens
	mulu	d0,d2
	add.w	offx(a5),d2
	add.w	#RandAbstandH+BoxInnenAbstandH,d2	;Position X2
	move.w	myhoehe1(a5),d3				;Y2
	add.w	#RandAbstandV+BoxInnenAbstandV,d3

	lea	my_bitmapII(a5),a0	;Bitmap (Quelle)
	tst.l	bm_planes(a0)
	beq.s	.noe
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	BoxBreite(A5),d4	;Breite 
	move.w	BoxHoehe(a5),d5		;Hhe
	
	move.b	#$c0,d6		;Miniterm

	jsr	_LVObltbitmaprastport(a6)
.noe
	movem.l	(sp)+,d0-a6
	rts
*******************************************************************
*    berprfen,ob Analyzerstruktur schon bergeben wurde und     *
* und ob der aktuelle Player Lautstrke und Sampleperiod bergibt *
*******************************************************************
AN_test
	move.l	winhandle(a5),d0	;Window berhaupt offen ?
	beq.w	.noanalyze
	move.l	d0,a0
	move.w	myhoehe1(a5),d0
	cmp.w	wd_height(a0),d0	;Window im ZIP-Modus ?
	beq.w	.noanalyze

	move.l	an_structadr(a5),d0	;Strukturadresse vorhanden ?
	beq.w	.Noanalyze
	move.l	d0,a0

	tst.w	UPS_enabled(a0)		;Zugriff erlaubt ?
	bne.w	.noanalyze

	move.w	UPS_Flags(a0),d0	;alle bentigten Werte bergeben ?
	and.w	#UPSB_Per!UPSB_len!UPSB_adr,d0
	cmp.w	#UPSB_Per!UPSB_len!UPSB_adr,d0
	bne.s	.noanalyze

	lea.l	an_struct(a5),a1
	move.w	#UPS_Sizeof>>1-1,d0
.copystruct
	move.w	(a0)+,(a1)+
	dbf	d0,.copystruct

	bra	Analyze1
.noanalyze
	rts
**************************************************************
*       Check, welche Stimmen erlaubt, welche nicht          *
**************************************************************
checkvoicez
	lea	begin(pc),a4
	move.l	EUS_EPBase(a4),a4
	move.w	EPG_Voices(a4),d0
	cmp.w	Voicesmerk(A5),d0	;alles OK ??
	beq.w	.wei1			;keine nderung, weiter
	move.w	d0,voicesmerk(A5)
.wei1
	rts
*************************************************************
*                  VBLANK Interrupt                         *
*************************************************************
INT_Prog
	movem.l	d0-a6,-(sp)
	lea	begin(pc),a4
	move.l	EUS_EPBase(a4),a4

	move.w	EPG_Voices(a4),d0
	cmp.w	Voicesmerk+datas,d0	;alles OK ??
	beq.s	.wei1

	move.l	4.w,a6
	move.l	datas+mytask,a1
	move.l	datas+mysignal,d1
	moveq	#0,d0
	bset	d1,d0
	jsr	_LVOsignal(a6)
.wei1
	movem.l	(sp)+,d0-a6
	moveq	#0,d0
	rts
*************************************************************
*       Setzt Interrupt fr Scroller (VBlank)               *
*************************************************************
Setint	
	tst.w	intset(a5)	;Interrupt schon gesetzt ?
	bne.s	.no		;ja->raus

	move.l	4.w,a6
	lea	inter(a5),a1
	lea	INT_Prog(pc),a0
	move.l	a0,IS_code(a1)
	move.b	#nt_interrupt,ln_type(a1)
	move.b	#0,ln_pri(a1)
	moveq	#5,d0
	jsr	_LVOaddintserver(a6)

	move.w	#1,intset(a5)
.no
	rts
*************************************************************
*         entfernt Scroller-Interrupt                       *
*************************************************************
Remint:
	tst.w	intset(a5)
	beq.s	.no

	move.l	4.w,a6
	moveq	#5,d0
	clr.w	intset(a5)
	lea	inter(a5),a1
	jsr	_LVOremintserver(a6)
.no	rts
***************************************************************
* Koordinaten und Gre der Fensterchen berechnen und ablegen *
***************************************************************
CalcCoordinates
	move.l	winhandle(a5),d0
	beq.s	.nowin
	move.l	d0,a0

	move.w	wd_width(a0),d0		;aktuelle Breite des Fensters

	move.b	WD_Borderleft(a0),d1	;Rahmen links
	ext.w	d1
	sub.w	d1,d0			;subtrahieren
	move.b	WD_Borderright(a0),d1	;Rahmen rechts
	ext.w	d1
	sub.w	d1,d0			;subtrahieren

	sub.w	#RandabstandH*2+ZwischenRaum*3,d0 ;minus Extra-Raum
	lsr.w	#2,d0			;durch 4
	move.w	d0,RoomPerBoxH(a5)	;gleich Platz pro Box horizontal
	sub.w	#BoxInnenAbstandH*2,d0 ;minus Boxinnenabstnde=Platz in der Box
	move.w	d0,BoxBreite(A5)
	
	move.w	wd_height(a0),d0	;aktuelle Hhe des Fensters
	move.b	WD_Bordertop(a0),d1	;Rahmen oben
	ext.w	d1
	sub.w	d1,d0			;subtrahieren
	move.b	WD_Borderbottom(a0),d1	;Rahmen unten
	ext.w	d1
	sub.w	d1,d0			;subtrahieren

	sub.w	#RandabstandV*2,d0	;minus Extra-Raum
	move.w	d0,RoomPerBoxV(a5)	;gleich Platz pro Box vertikal
	sub.w	#BoxInnenAbstandV*2,d0	;minus Boxinnenabstnde=Platz in der Box
	move.w	d0,BoxHoehe(A5)

	st 	d0
.nowin
	rts
*************************************************************
*           Nachrichtenbearbeitung                          *
*************************************************************
HandleActions
	bra.s	.ma2
.ma
	btst	d3,d0
	beq.s	.ma2

	bsr	checkvoicez

	movem.l	d0/d3,-(sp)
	bsr.w	an_test
	movem.l	(sp)+,d0/d3
	bclr	d3,d0
	tst.l	d0
	beq	.waitsig
.ma2
	move.l	4.w,a6
	move.l	port(a5),d0
	beq.s	.nowinport
	move.l	d0,a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.msg
.nowinport
	move.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.AN_msg
.waitsig
	move.l	4.w,a6
	moveq	#0,d0
	move.l	port(a5),d1
	beq.s	.noport
	move.l	d1,a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
.noport
	move.l	msgport(a5),a0

	move.b	mp_sigbit(a0),d1
	bset	d1,d0
	move.l	mysignal(a5),d3

	tst.l	an_structadr(A5)
	beq.s	.nowaitsig

	bset	d3,d0
.nowaitsig
	jsr	_LVOwait(a6)
	bra	.ma
.AN_msg
	move.l	d0,a1

	move.l	MSGPort(a5),UM_Userport(a1)

	ifne	debug
	move.w	um_usernr(a1),saveusernr(A5)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc
	move.l	mytask(a5),UM_TaskAdr(a1)
	move.l	mysignal(a5),d1
	move.l	d1,UM_Signal(a1)

	move.w	UM_class(a1),d3		<-
	move.l	UM_Type(a1),d7
	move.w	UM_Signal(a1),d5 	<-
	move.l	UM_structadr(a1),d6 	<-

	cmp.w	#USclass_exit,d3
	bne.s	.noexi
	clr.l	UM_Signal(a1)
	clr.l	UM_Taskadr(a1)
.noexi
	cmp.w	#USclass_getconfig,d3		;when this command comes,set
						;the actual preferences into
						;the Eagleuser-Structure
						;(EUS_-structure at the be-
						;ginning of the program)
	bne	.noprev

	moveq	#0,d0
	move.l	winhandle(A5),d1		;Window
	beq.s	.prnowin			;no Window opened,no change
						;of preferences
	or.w	#eusb_openwin,d0		;set Flag: window is open

	move.l	d1,a0				;Window
	move.w	myhoehe1(a5),d1			;Window in ZIP-Mode ?
	cmp.w	wd_height(a0),d1		;compare real height with
						;calculated height
	bne.s	.getxy				;ino ZIP-Mode
	or.w	#eusb_zipwin,d0			;set FLAG: ZIP-Mode
	bra.s	.prnowin			;If ZIP-Mode,don`t set
						;new x and y - Position
.getxy
	push	d3
	
	move.w	wd_leftedge(a0),eus_winx(a2)	;Save Windowpostion
	move.w	wd_topedge(a0),eus_winy(a2)

	move.w	eus_special(a2),d1
	and.w	#$E000,d1
	move.w	wd_width(A0),d2
	moveq	#0,d3
	move.b	wd_BorderLeft(a0),d3
	add.b	wd_BorderRight(a0),d3
	ext.w	d3
	sub	d3,d2
	or.w	d2,d1
	move.w	d1,eus_special(a2)

	move.w	eus_special+2(a2),d1
	and.w	#$C000,d1
	move.w	wd_height(A0),d2
	moveq	#0,d3
	move.b	wd_BorderTop(a0),d3
	add.b	wd_BorderBottom(a0),d3
	ext.w	d3
	sub	d3,d2
	or.w	d2,d1
	move.w	d1,eus_special+2(a2)

	pop	d3
.prnowin
	move.w	d0,eus_flags(a2)		;Save Flags
.noprev
	move.w	#USClass_Dummy,UM_Class(A1)

	cmp.w	#USclass_Show,d3
	beq.s	.win
	cmp.w	#USclass_Activate,d3
	bne.w	.nowin
.win
	move.l	Begin+EUS_EPBase(pc),a0
	move.l	EPG_SomePrefs(a0),d0
	btst	#EGPRF_Iconify,d0
	bne.w	.noShow

	push	all
	bsr	Openwin
	pop	all
	tst.l	Winhandle(A5)
	beq.s	.noshow
	move	d3,UM_Class(a1)
.noshow

.nowin
	cmp.w	#USclass_Hide,d3
	beq.s	.closewin

	cmp.w	#USclass_DeActivate,d3
	bne.s	.noclosewin
.closewin
	bsr	Closewin
.noclosewin
	move.l	d6,an_structadr(a5)	;Analyzerstrukturadresse merken
	tst.l	d6
	bne.s	.noclr
	move.l	winhandle(a5),d0
	beq.s	.noclr
	move.l	d0,a0
	move.w	myhoehe1(a5),d0
	cmp.w	wd_height(a0),d0	;Window im ZIP-Modus ?
	beq.w	.noclr

	push	all
		bsr	clear
		moveq	#0,d0
		bsr	IntoWindowII
		moveq	#1,d0
		bsr	IntoWindowII
		moveq	#2,d0
		bsr	IntoWindowII
		moveq	#3,d0
		bsr	IntoWindowII
	pop	all
.noclr

	cmp.w	#USClass_Answer,d3
	bne.s	.notanswered

	move.l	UM_Command(a1),SaveCommand(A5)
	move.l	UM_Result(a1),SaveResult(A5)

	move.l	UM_ArgString(A1),d0
	beq.s	.notanswered
	clr.l	UM_Argstring(a1)
	move.l	d0,Savestring(A5)
.notanswered
	move.l	mn_replyport(a1),d0
	cmp.l	MSGport(a5),d0		 ;eine von uns abgeschickte Message ?
	beq.s	.noreply
	jsr	_LVOreplymsg(a6)
.noreply
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	beq	.mess

	bsr	freemsg

.mess
	move.l	savestring(a5),d0
	beq.s	.nostring
	movem.l	d0-a6,-(sp)

	clr.l	savestring(A5)
	move.l	d0,d6
	move.l	4.w,a6
.clrnext
	move.l	d6,a3
	move.l	EPT_Stringsize(A3),d0
	move.l	a3,a1
	move.l	EPT_Next(A3),d6
	jsr	_LVOfreemem(A6)
	tst.l	d6
	bne.s	.clrnext

	movem.l	(sp)+,d0-a6
.nostring
	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq	.ma2			;adresse bekommen

	cmp.w	#USclass_zipwin,d3
	bne.s	.nozip
.setzip

	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.w	.ma		;Window schon klein
.zip
	move.w	d0,-(sp)

	move.l	intsave(a5),a6
	jsr	_LVOzipwindow(a6)

	move.w	(sp)+,d4

	move.l	winhandle(a5),a2
.Zipwait:
	moveq	#1,d1
	move.l	_Dos(a5),a6
	jsr	_LVODelay(a6)

	cmp.w	wd_height(a2),d4
	beq.s	.zipwait

	bra	.ma
.nozip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nounzip

.clearzip
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.s	.zip
	bra	.ma
.nounzip

	cmp.w	#USclass_exit,d3
	beq	.exit

	cmp.w	#USclass_NewConfig,d3	;is there a new config
	bne.w	.nonewcon		;no

	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.w	eus_flags(a0),d0	;get Flags
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin			;open it
	bra.s	.weio
.nowino
	bsr	closewin		;else close it
.weio
	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.l	winhandle(a5),d0	;windowaddress
	beq.s	.nothingtomove		;no Window , no movement

	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;new X-position
	move.w	d0,d1			;save
	blt.s	.oldx			;less than 0 -> stop

	add.w	#win_breite,d1		;new position + Window-width
	cmp.w	sc_width(a2),d1		;bigger than Screenwidth ?
	bhi.s	.oldx			;then old X-position (Delta = 0)

	sub.w	wd_leftedge(a1),d0	;new - old X-position = Delta X
	bra.s	.gety
.oldx
	moveq	#0,d0			;Delta X = 0
.gety
	move.w	eus_winy(a0),d1		;new Y-position

	move.w	d1,d2			;save
	blt.s	.oldy			;less than 0 -> stop and take old

	add.w	wd_height(a1),d2	;new position + window-height
	cmp.w	sc_height(a2),d2	;bigger than Screenheight ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;new - old Y-position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1

.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove
	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	btst	#eusf_zipwin,d0		;Zipwindow ?
	bne	.setzip			;yes
	bra	.clearzip		;no
.nonewcon
	bra	.ma
.noeagle
	bra	.ma2
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<-
	move.l	im_Iaddress(a1),d6 	<-
	jsr	_LVOreplymsg(a6)

	cmp.l	#IDCMP_NEWSIZE,d7
	bne.w	.standard

	bsr	FreeBitmapII
	bsr	calccoordinates		;Koordinaten und Gre der Fensterchen
					;berechnen
	bsr	MakeBitmapII
	bsr	MakeTables		;Tabellen fr die Darstellung berechnen

	bra	.ma
.standard
	cmp.l	#refreshwindow,d7
	bne.s	.noref
	bsr	refresh
	bra	.ma2
.noref
.testgads
	cmp.l	#CloseWindow,d7
	bne	.noclo
.closewinny
	if	Test=0
	bsr	closewin
	move.l	4.w,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.w	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	mysignal(a5),d5
	move.w	#USclass_DeActivate,d6
	bsr	sendmess
	bra	.ma2
	else
	bra.s	.endme
	endc
.noclo
	cmp.l	#menupick,d7
	bne.w	.nomenu

	cmp.w	#menunull,d5
	beq	.ma2
	bra.s	.nextme
.next
	move.w	mi_nextselect(a1),d5
	cmp.w	#menunull,d5
	beq	.ma2
.nextme
	move.w	d5,d0
	move.l	intsave(A5),a6
	move.l	menuadr(a5),a0
	jsr	_LVOitemaddress(a6)
	tst.l	d0
	beq	.ma2
	move.l	d0,a1

	move.w	d5,d0
	and.w	#$7e0,d0
	bne.s	.nomodeit1
	moveq	#0,d1
.mode					;1.Men 1.Eintrag "Standard Mode"
	move.b	d1,Modeid(a5)
	lea	begin(pc),a2
	lsl.b	#6,d1
	move.b	eus_special(a2),d2
	and.b	#~$C0,d2
	or.b	d1,d2
	move.b	d2,eus_special(a2)
	bra	.next
.nomodeit1
	cmp.w	#32,d0
	bne.s	.nomode2
	moveq	#1,d1			;1. Men 2. Eintrag "Solid Mode"
	bra.s	.mode
.nomode2
	cmp.w	#64,d0
	bne.s	.nomode3
	moveq	#2,d1			;1. Men 3. Eintrag "Line Mode"
	bra.s	.mode
.nomode3
	cmp.w	#96,d0
	bne.s	.nomode4
	moveq	#3,d1			;1. Men 4. Eintrag "Space Mode"
	bra.s	.mode
.nomode4
	cmp.w	#160,d0			;6. Item Horizontal
	bne.s	.nohori
	moveq	#0,d1
.mode2
	move.b	d1,mode2id(a5)
	lea	begin(pc),a2
	lsl.b	#6,d1
	move.b	eus_special+2(a2),d2
	and.b	#~$C0,d2
	or.b	d1,d2
	move.b	d2,eus_special+2(a2)
	bra	.next	
.nohori
	cmp.w	#192,d0			;7. Item Vertical
	bne.s	.noverti
	moveq	#1,d1
	bra.s	.mode2
.noverti
	cmp.w	#224,d0			;8. Item Halve
	bne.s	.nohalve
	moveq	#2,d1
	bra.s	.mode2
.nohalve
	cmp.w	#256,d0			;9. Item Mirror
	bne.s	.nomirror
	moveq	#3,d1
	bra.s	.mode2
.nomirror
	cmp.w	#320,d0
	bne.s	.noslow
	
	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	lsr.w	#1,d0
	rol.b	#1,d0
	move.b	d0,OnSlowMode(A5)

	lea	begin(pc),a2
	lsl.b	#5,d0
	move.b	eus_special(a2),d2
	and.b	#~$20,d2
	or.b	d0,d2
	move.b	d2,eus_special(a2)
	bra	.next

	bra	.next
.noslow
	cmp.w	#416,d0			;12. Item (Hide)
	beq.w	.closewinny
	cmp.w	#448,d0			;13. Item (Quit)
	beq.s	.endme

	lea	Aboutmessage(pc),a0
	bsr	Merror
	bra	.next
.nomenu
	bra	.ma2
.endme
	moveq	#0,d7
	RTS
.exit	moveq	#-1,d7
	rts
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0-a6,-(sp)
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	lea	my_easygadget(pc),a0
	move.l	a0,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	movem.l	(sp)+,d0-a6	
	rts
;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************

int:	dc.b	`intuition.library`,0
gad:	dc.b	`gadtools.library`,0
graf:	dc.b	`graphics.library`,0
dos:	dc.b	`dos.library`,0
portname:	dc.b	`EAGLEPLAYERPORT`,0

MyWinName:	dc.b	`QuadrascopeII`,0
my_easygadget:	dc.b	`   OK   `,0
my_easytitle:	dc.b	`Quadrascope Message`,0
my_easygadget2:	dc.b	` Retry | Cancel `,0
MyAnalyzername:	dc.b	`EQuadrascopeII.1`,0
MyUsername:	dc.b	`Quadrascope II`,0

Aboutmessage:	dc.b	`     EaglePlayer QuadrascopeII V`
		ver	
		dc.b	$0a
		dc.b	`   1993-1995 Henryk "BUGGS" Richter`,$0
NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0

Confile:	dc.b	`CON:10/10/250/40/Quadrascope`,0
Conout:	dc.b	`Needs Amiga OS2.04 or higher to run`,0
Conlen = *-Conout
mybuggsname	dc.b	`Buggs of DEFECT`,0
myinfo	dc.b	`Shows the Samples of all 4 Voices in different ways`,0

	even
vol64	dc.w	64,64,64,64

patt1	dc.w	%1010101010101010
	dc.w	%0101010101010101
patt2	dc.w	0,0
MTags0:
	DC.L	GTMN_Newlookmenus,1
	dc.l	TAG_DONE

Project0NewMenu0:
	DC.B	NM_TITLE,0
	DC.L	Project0MName0
	DC.L	0
	DC.W	0
	DC.L	0,0
Item1
	DC.B	NM_ITEM,0
	DC.L	MyCheck1
	DC.L	Mycomm0
	DC.W	CheckIT
	DC.L	%1110,0

	DC.B	NM_ITEM,0
	DC.L	MyCheck2
	DC.L	Mycomm1
	DC.W	CheckIT
	DC.L	%1101,0

	DC.B	NM_ITEM,0
	DC.L	MyCheck3
	DC.L	Mycomm2
	DC.W	CheckIT
	DC.L	%1011,0

	DC.B	NM_ITEM,0
	DC.L	MyCheck4
	DC.L	Mycomm3
	DC.W	CHECKIT
	DC.L	%0111,0

	DC.B	NM_ITEM,0
	DC.L	NM_BARLABEL,0
	DC.W	0
	DC.L	0,0
Item2
	DC.B	NM_ITEM,0
	DC.L	MyHori
	DC.L	Mycomm4
	DC.W	CHECKIT
	DC.L	%111000000,0

	DC.B	NM_ITEM,0
	DC.L	MyVertical
	DC.L	Mycomm5
	DC.W	CHECKIT
	DC.L	%110100000,0

	DC.B	NM_ITEM,0
	DC.L	MyHalve
	DC.L	Mycomm6
	DC.W	CHECKIT
	DC.L	%101100000,0

	DC.B	NM_ITEM,0
	DC.L	MyMirror
	DC.L	Mycomm7
	DC.W	CHECKIT
	DC.L	%011100000,0

	DC.B	NM_ITEM,0
	DC.L	NM_BARLABEL,0
	DC.W	0
	DC.L	0,0
SlowItem
	DC.B	NM_ITEM,0
	DC.L	MySlow
	DC.L	SlowComm
	DC.W	CheckIT!Menutoggle
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	NM_BARLABEL,0
	DC.W	0
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	MyLabel2
	DC.L	AboutComm
	DC.W	0
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	HideName
	DC.L	Hidenamecomm
	DC.W	0
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	QuitName
	DC.L	Quitnamecomm
	DC.W	0
	DC.L	0,0

	DC.B	NM_END,0
	DC.L	0,0
	DC.W	0
	DC.L	0,0
TD:
    DC.L    TAG_DONE

Project0MName0	dc.b	`Project`,0
Mylabel2	DC.B    'About',0
Aboutcomm	dc.b	`A`,0
HideName	dc.b	`Hide`,0
Hidenamecomm	dc.b	`H`,0
QuitName	dc.b	`Quit`,0
QuitNameComm	dc.b	`Q`,0
MySlow		dc.b	`Slow Mode`,0
SlowComm	dc.b	`S`,0

Project0STitle: dc.b	'Quadrascope (Eagleplayer),  DEFECT Softworks',0
	even

mycheck1	dc.b	`Standard Mode`,0
mycheck2	dc.b	`Solid Mode`,0
mycheck3	dc.b	`Line Mode`,0
mycheck4	dc.b	`Space Mode`,0
MyHori		dc.b	`Horizontal`,0
MyVertical	dc.b	`Vertical`,0
MyHalve		dc.b	`Halve`,0
MyMirror	dc.b	`Mirror`,0
Mycomm0		dc.b	`1`,0
Mycomm1		dc.b	`2`,0
Mycomm2		dc.b	`3`,0
Mycomm3		dc.b	`4`,0
Mycomm4		dc.b	`5`,0
Mycomm5		dc.b	`6`,0
Mycomm6		dc.b	`7`,0
Mycomm7		dc.b	`8`,0
;*********** Leertabellen (spter im BSS-Hunk) ***********************
		section	1,BSS
datas:
intsave:	rs.l	1
gadsave:	rs.l	1
grafsave:	rs.l	1
_dos		rs.l	1
WinHandle:	rs.l	1
Port:		rs.l	1
MSGPort:	rs.l	1
Handle:		rs.l	1
Menuadr:	rs.l	1
Mysignal	rs.l	1
Mytask		rs.l	1
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
fontatt:	rs.l	1	;Fontattr Strukturadresse (entweder die des
				;Screens oder die eigene,wenn Screenfont zu
				;gro)
vi:		rs.l	1	;Visualinfo

mytags:		rs.l	20*2
myhoehe1:	rs.w	1

Intset	rs.w	1
inter:	rs.l	2
	rs.b	1	;2
	rs.b	1	;127
	rs.l	3

MY_Easystruct:	rs.l	1	;EASY-Request
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1

MY_BitmapII:	rs.b	8
		rs.l	8
Permerk:	rs.l	4		;4 Kanle,je 2 Wrter
SaveCommand	rs.l	1
SaveResult	rs.l	1
Savestring	rs.l	1
winwidth	rs.l	1
offx		rs.w	1

AN_Structadr:	rs.l	1
AN_Struct:	rs.b	UPS_sizeof
flagsadr	rs.l	1
Modeid		rs.b	1	;Frei
Mode2id		rs.b	1
Voicesmerk	rs.w	1
word8		rs.w	1	;Wort fr Absturz bei Modifikation
counter		rs.w	1
immernull	rs.l	1

RoomPerBoxH	rs.w	1
RoomPerBoxV	rs.w	1
BoxBreite	rs.w	1
BoxHoehe	rs.w	1
pixhori		rs.w	1
pixverti	rs.w	1
Lastrow		rs.l	1
dbfcount	rs.w	1

samlen		rs.l	1		;temporr
samadr		rs.l	1		;temporr
samrest		rs.l	1		;temporr
middlePos	rs.w	1	;Position der Mitte des Feldes

Fulls		rs.l	8

HoriTAB		rs.w	580	;Tabelle fr horizontale Werte

Nulls:		rs.b	700		;max. Anzahl der Punkte horizontal
		rs.w	8	;zur Sicherheit
VertiTab	rs.w	128	;Tabelle fr Multiplikation mit
				;Breite der Bitplane
VertiTabHalve	rs.w	128	;Tabelle fr Multiplikation mit
				;Breite der Bitplane fr Halve-Modus
VertiTabMI	rs.w	128	;nun fr Mirror Modus
Dummy		rs.w	8	;zur Sicherheit
OnSlowMode	rs.b	1
Slowcnt		rs.b	1
MC68020on	rs.b	1
		rs.b	1

	ifne	debug
saveusernr	rs.w	1
	endc
DatasLen:	rs.w	0
		ds.b	DatasLen
	end
