*****************************************************************************
**                                                                         **
** Engine: Pysion                                                          **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

*---------------------------------------------------------------------------*
*		PYSION (Die Listenverwaltung fr den EP)		    *
*---------------------------------------------------------------------------*
Executable	= 1
Test		= 0
Debugger	= 0
BackPicture	= 1
Betarelease	= 1

	incdir	include:
	include	exec/exec_lib.i
	include	dos/dos_lib.i
	include	dos/dos.i
	include	dos/exall.i
	include	exec/libraries.i
	include	exec/interrupts.i
	include	exec/lists.i
	include	libraries/diskfont_lib.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	misc/BuggsMacros.i
	include	misc/EagleplayerEngine.i
	include	libraries/asl_lib.i
	include	libraries/asl.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	libraries/locale_lib.i

	include "intuition/icclass.i"
	include "intuition/classes.i"
        include "intuition/classusr.i"
        include "intuition/imageclass.i"
	include	libraries/utility_lib.i

	include	libraries/datatypes_lib.i
	include	datatypes/datatypes.i
	include	datatypes/pictureclass.i

	include	libraries/reqtools.i
	include	libraries/reqtools_lib.i

;===========================================================================
;		Definitionen & Vereinbarungen 
;===========================================================================
Defheight	=	398	;def. Innerheight
Defwidth	=	560	;def. Innerwidth
ZoomWidth	= 180
StringGadgetOffset	= 8		* Zur Fonthhe fr Stringgadgetheight

FileReqWidth	= 20
CycleWidth	= 15


PrefsSecurity	= 2
ARC_Size	= 500
*TextPufferSize	= 500
PathPufferSize	EQU	300
TitlePufferSize	EQU	200
MemDazu		EQU	100
WritePufferSize	EQU	15000

	*----------------- Einstellungen der Prefs --------------*
PFF_Synchron		EQU	0
PFF_ShowName		EQU	1		; ohne Prefix
PFF_BackPic		EQU	2
PFF_HideAll		EQU	3
PFF_LoadAtStart		EQU	4
PFF_AutoLearnAuthors	EQU	5
PFF_ShowPath		EQU	6
PFF_Overwrite		EQU	7

PFB_Synchron		EQU	1<<PFF_Synchron
PFB_ShowName		EQU	1<<PFF_ShowName		;ohne Prefix !!!!
PFB_BackPic		EQU	1<<PFF_BackPic
PFB_HideAll		EQU	1<<PFF_HideAll
PFB_LoadAtStart		EQU	1<<PFF_LoadAtStart
PFB_AutoLearnAuthors	EQU	1<<PFF_AutoLearnAuthors
PFB_ShowPath		EQU	1<<PFF_ShowPath
PFB_Overwrite		EQU	1<<PFF_Overwrite

	*----------- Listetypen ---------*
LTY_Eagleplayer	EQU	1
LTY_Delitracker	EQU	2
LTY_APlayer	EQU	3
LTY_BananaPlay	EQU	4
LTY_Hippoplayer	EQU	5
LTY_Empy	EQU	6			= Multiplayer
LTY_Smartplay	EQU	7
LTY_Archive	EQU	8
LTY_Melgu	EQU	9
LTY_DASMod	EQU	10

*-----------------------------------------------------------------------------*


*-----------------------------------------------------------------------------*
BevelHohe		= 1
BevelBreite		= 2
MinListViewWidth	= 40		*Min Width der Listviews
MinGadgetWidth		= 15		*Min. Breite von Gadgets
MinTextGadgetXOffset	= 2		*Abstand des Textes im Gadget vom
					*Bevelrand
MinTextGadgetYOffset	= 2		*Abstand des Textes im Gadget vom
					*Bevelrand
GadgetXAbstand		= 4		*Abstand der Gadgets untereinander
					*sowie vom linken Rand
GadgetYAbstand		= 4		*Abstand der Gadgets untereinander
					*sowie vom oberen & unteren Rand
AboveAbstand		= 7		*Abstand, wenn Text berm ListView

TextCycleAbstand	= 4
TextStringAbstand	= 4
StringMinWidth		= 35

			rsreset
			rs.b	1
EPENr_FirstNummer	rs.b	0
EPENr_ModulesList	rs.b	1

EPENr_Add		rs.b	1
EPENr_Up		rs.b	1
EPENr_Top		rs.b	1	*Zum Tauschen der Eintrge
EPENr_ModulesPrefs	rs.b	1
EPENr_SaveList		rs.b	1

EPENr_Delete		rs.b	1
EPENr_Down		rs.b	1
EPENr_Botom		rs.b	1
EPENr_ClearModulesPrefs	rs.b	1
EPENr_Execute		rs.b	1

EPENr_New		rs.b	1
EPENr_InsertList	rs.b	1
EPENr_SortByPath	rs.b	1
EPENr_SortByFName	rs.b	1
EPENr_SortByName	rs.b	1
EPENr_About		rs.b	1
EPENr_Hide		rs.b	1
EPENr_Quit		rs.b	1
EPENr_SaveConfig	rs.b	1
EPENr_LoadAtStart	rs.b	1
EPENr_HideAll		rs.b	1
EPENr_Synchron		rs.b	1
EPENr_BackPic		rs.b	1
EPENr_SelectBackPic	rs.b	1

EPENr_ViewUp		rs.b	1	*Selectbalken im Listview setzen
EPENr_ViewDown		rs.b	1
EPENr_ViewPageUp	rs.b	1
EPENr_ViewPageDown	rs.b	1
EPENr_ViewTop		rs.b	1
EPENr_ViewBotom		rs.b	1
EPENr_PlayModule	rs.b	1

EPENr_LoadList		rs.b	1
EPENr_Gruppenliste	rs.b	1
EPENr_Autorliste	rs.b	1

EPENr_ShowByName	rs.b	1
EPENr_ShowByFName	rs.b	1
EPENr_ShowByPath	rs.b	1
EPENr_AutoLearnAuthors	rs.b	1
EPENr_FindDouble	rs.b	1
EPENr_Overwrite		rs.b	1

		*--- Autorwindow ---*
EPENrA_Autorlist	rs.b	1
EPENrA_Add		rs.b	1
EPENrA_Delete		rs.b	1
EPENrA_New		rs.b	1
EPENrA_Prefs		rs.b	1
EPENrA_ClrPrefs		rs.b	1
EPENrA_ViewUp		rs.b	1	*Selectbalken im Listview setzen
EPENrA_ViewDown		rs.b	1
EPENrA_ViewPageUp	rs.b	1
EPENrA_ViewPageDown	rs.b	1
EPENrA_ViewTop		rs.b	1
EPENrA_ViewBotom	rs.b	1
EPENrA_Close		rs.b	1

		*--- Gruppenwindow ---*
EPENrG_Gruppenlist	rs.b	1
EPENrG_Add		rs.b	1
EPENrG_Delete		rs.b	1
EPENrG_New		rs.b	1
EPENrG_Prefs		rs.b	1
EPENrG_ClrPrefs		rs.b	1
EPENrG_ViewUp		rs.b	1	*Selectbalken im Listview setzen
EPENrG_ViewDown		rs.b	1
EPENrG_ViewPageUp	rs.b	1
EPENrG_ViewPageDown	rs.b	1
EPENrG_ViewTop		rs.b	1
EPENrG_ViewBotom	rs.b	1
EPENrG_Close		rs.b	1

		*######## Prefswindow ########*
			*-- Engineliste --*
EPENrPE_Enginelist	rs.b	1
EPENrPE_Add		rs.b	1
EPENrPE_Delete		rs.b	1
EPENrPE_Clear		rs.b	1

			*-- Gruppenliste --*
EPENrPG_Gruppenlist	rs.b	1
EPENrPG_Add		rs.b	1
EPENrPG_Delete		rs.b	1
EPENrPG_Clear		rs.b	1

			*-- linke Seite --*
EPENrP_Filter		rs.b	1
EPENrP_FadeIn		rs.b	1
EPENrP_FadeOut		rs.b	1
EPENrP_Songend		rs.b	1
EPENrP_AutoSubSong	rs.b	1
EPENrP_RandomSong	rs.b	1
EPENrP_LoadBefore	rs.b	1
EPENrP_LoadFast		rs.b	1
EPENrP_ProgrammMode	rs.b	1

			*-- rechte Seite --*
EPENrP_Volume		rs.b	1
EPENrP_StartSong	rs.b	1
EPENrP_Timeout		rs.b	1
EPENrP_MinTimeout	rs.b	1
EPENrP_Passwort		rs.b	1
EPENrP_Songname		rs.b	1
EPENrP_Specialinfo	rs.b	1
EPENrP_Autor		rs.b	1
EPENrP_SelectAutor	rs.b	1
EPENrP_Player		rs.b	1
EPENrP_SelectPlayer	rs.b	1



EPENr_Lastnr		rs.b	0


NextMenu	EQU	1
NextItem	EQU	1<<5
NextSubItem	EQU	1<<11
NoSubMenu	EQU	$f800
SubMenu		EQU	$800

			rsreset
Menu1			rs.b	1
Menu2			rs.b	1
Menu3			rs.b	1



			rsreset
			rs.b	Menu1!NoSubMenu
MNr_New			rs.b	NextItem
MNr_LoadList		rs.b	NextItem
MNr_InsertList		rs.b	NextItem
MNr_SaveList		rs.b	NextItem
			rs.b	NextItem		;Barlabel
MNr_About		rs.b	NextItem
			rs.b	NextItem		;Barlabel
MNr_Hide		rs.b	NextItem
MNr_Quit		rs.b	NextItem

			rsreset
			rs.b	Menu2!NoSubMenu
MNr_Gruppenliste	rs.b	NextItem
MNr_Autorliste		rs.b	NextItem
			rs.b	NextItem		;Barlabel
MNr_FindDouble		rs.b	NextItem
MNr_Sortieren		rs.b	NextItem

			rsreset
			rs.b	MNr_Sortieren-$f800
MNr_SortByName		rs.b	NextSubItem
MNr_SortByFName		rs.b	NextSubItem
MNr_SortByPath		rs.b	NextSubItem

			rsreset
			rs.b	Menu3!NoSubMenu
MNr_Show		rs.b	NextItem
			rs.b	NextItem
MNr_AutoLearnAuthors	rs.b	NextItem
MNr_Synchron		rs.b	NextItem
MNr_Overwrite		rs.b	NextItem
MNr_HideAll		rs.b	NextItem
MNr_LoadAtStart		rs.b	NextItem
MNr_BackPic		rs.b	NextItem
MNr_SelectBackPic	rs.b	NextItem
			rs.b	NextItem		;Barlabel
MNr_SaveConfig		rs.b	NextItem

			rsreset
			rs.b	MNr_Show-$f800
MNr_ShowByName		rs.b	NextSubItem
MNr_ShowByFName		rs.b	NextSubItem
MNr_ShowByPath		rs.b	NextSubItem


		rsreset		*Aufbau der MPPrefsTabelle
MPTS_EPNr	rs.w	1
MPTS_EPPyNr	rs.w	1	*Die Nummer im Pysion
MPTS_Flags	rs.w	1
MPTS_Prg	rs.w	1
MPTS_SizeOf	rs.b	0

MPF_Status	= 0
MPF_String	= 1
MPF_Zahl	= 2
MPF_MultiArgs	= 3

MPB_Status	= 1<<MPF_Status
MPB_String	= 1<<MPF_String
MPB_Zahl	= 1<<MPF_Zahl
MPB_MultiArgs	= 1<<MPF_MultiArgs



			rsreset
			rs.b	1
LENr_WindowTitle	rs.b	1
LENr_ScreenTitle	rs.b	1
LENr_Project		rs.b	1
LENr_Kommando		rs.b	1
LENr_Settings		rs.b	1
LENr_Von		rs.b	1
LENr_Add		rs.b	1
LENr_AddKey		rs.b	1
LENr_Delete		rs.b	1
LENr_DeleteKey		rs.b	1
LENr_New		rs.b	1
LENr_NewKey		rs.b	1
LENr_LoadList		rs.b	1
LENr_LoadListKey	rs.b	1
LENr_InsertList		rs.b	1
LENr_InsertListKey	rs.b	1
LENr_GDSaveList		rs.b	1
LENr_SaveList		rs.b	1
LENr_SaveListKey	rs.b	1
LENr_ModulesPrefs	rs.b	1
LENr_ModulesPrefsKey	rs.b	1
LENr_ClearPrefs		rs.b	1
LENr_ClearPrefsKey	rs.b	1
LENr_Execute		rs.b	1
LENr_ExecuteKey		rs.b	1
LENr_SaveConfig		rs.b	1
LENr_SaveConfigKey	rs.b	1
LENr_PlayModule		rs.b	1
LENr_PlayModuleKey	rs.b	1
LENr_About		rs.b	1
LENr_Hide		rs.b	1
LENr_Quit		rs.b	1
LENr_Top		rs.b	1
LENr_TopKey		rs.b	1
LENr_Botom		rs.b	1
LENr_BotomKey		rs.b	1
LENr_Up			rs.b	1
LENr_UpKey		rs.b	1
LENr_Down		rs.b	1
LENr_DownKey		rs.b	1
LENr_Synchron		rs.b	1
LENr_LoadAtStart	rs.b	1
LENr_AutoLearnAuthors	rs.b	1
LENr_Show		rs.b	1
LENr_ShowByName		rs.b	1
LENr_ShowByFName	rs.b	1
LENr_ShowByPath		rs.b	1
LENr_Hideall		rs.b	1
LENr_BackPic		rs.b	1
LENr_SelectBackPic	rs.b	1
LENr_SelectAList	rs.b	1
LENr_SelectFiles	rs.b	1
LENr_SortByName		rs.b	1
LENr_SortByFName	rs.b	1
LENr_SortByPfad		rs.b	1
LENr_Gruppenliste	rs.b	1
LENr_Autorliste		rs.b	1
LENr_Sortieren		rs.b	1

LENr_AboutText		rs.b	1
LENr_SaveBeforeQuit	rs.b	1
LENr_SaveAutorsBeforeQuit rs.b	1
LENr_RealyNew		rs.b	1
LENr_OverwriteIt	rs.b	1
LENr_UnknownListFormat	rs.b	1
LENr_ErrorInList	rs.b	1
LENr_ErrorWhileAdding	rs.b	1
LENr_CouldListNotLoad	rs.b	1
LENr_CouldListNotSave	rs.b	1
LENr_Ok			rs.b	1
LENr_SaveGadgets	rs.b	1
LENr_YesNo		rs.b	1
LENr_ReallyGadgets	rs.b	1
LENr_RequestTitle	rs.b	1
LENr_EPNotFound		rs.b	1

LENr_FindDouble		rs.b	1
LENr_DoubleFound	rs.b	1
LENr_DoubleGadgets	rs.b	1
LENr_DeleteFrom		rs.b	1
LENr_DoubleGadgets2	rs.b	1

LENr_NoDouble		rs.b	1
LENr_NoMoreDouble	rs.b	1
LENr_Overwrite		rs.b	1

LENr_AutorWindowtitle	rs.b	1
LENr_SelectAutor 	rs.b	1
LENr_GruppenWindowtitle	rs.b	1
LENr_SelectGruppe 	rs.b	1
LENr_AddAutor		rs.b	1
LENr_AddGruppe		rs.b	1

LENr_P_Enginelist	rs.b	1
LENr_P_Gruppenlist	rs.b	1

LENr_P_Add		rs.b	1
LENr_P_Delete		rs.b	1
LENr_P_Clear		rs.b	1

LENr_P_Filter		rs.b	1
LENr_P_FadeIn		rs.b	1
LENr_P_FadeOut		rs.b	1
LENr_P_Songend		rs.b	1
LENr_P_AutoSubSong	rs.b	1
LENr_P_RandomSong	rs.b	1
LENr_P_LoadBefore	rs.b	1
LENr_P_LoadFast		rs.b	1
LENr_P_ProgrammMode	rs.b	1

LENr_P_Volume		rs.b	1
LENr_P_StartSong	rs.b	1
LENr_P_Timeout		rs.b	1
LENr_P_MinTimeout	rs.b	1
LENr_P_Passwort		rs.b	1
LENr_P_Songname		rs.b	1
LENr_P_Specialinfo	rs.b	1
LENr_P_Autor		rs.b	1
LENr_P_Player		rs.b	1

LENr_L_NotChanged	rs.b	1
LENr_L_Yes		rs.b	1
LENr_L_No		rs.b	1

LENr_LM_NoNewModule	rs.b	1
LENr_LM_NextModule	rs.b	1
LENr_LM_PrevModule	rs.b	1
LENr_LM_RandomModule	rs.b	1

LENr_Module		rs.b	1
LENr_Gruppe		rs.b	1
LENr_Autor		rs.b	1
LENr_ModulesPrefsFor	rs.b	1
LENr_GetFile		rs.b	1
LENr_SelectEngine	rs.b	1
LENr_SelectPlayer	rs.b	1

LENr_LastExternal	rs.b	0

GadgetAnz		= 11
AutorGadgetAnz		= 6
GruppenGadgetAnz	= 6
PrefsGadgetAnz		= 28


	*--- Windowstruktur, damit viele Windows mit einer Routine
	*--- geffnet werden knnen

			rsreset
WS_Next			rs.l	1	; nur fr Prefswindows
WS_Winhandle		rs.l	1
WS_Rastport		rs.l	1
WS_WindowPort		rs.l	1
WS_PubScreen		rs.l	1
WS_MenuAdr		rs.l	1
WS_GadgetlistAdr	rs.l	1
WS_GadgetAnz		rs.l	1	; Anz der Gadgets
WS_Gadgets		rs.l	1	; Ptr to Gadgetstructure before create
WS_GadgetMerkPuffer	rs.l	1	; Ptr to an Gadgetmerkpuffer
WS_GadgetTags		rs.l	1	; Tags of Gadgets
WS_Gadgettypes		rs.l	1	; Types of Gadgets
WS_VisualInfo		rs.l	1
WS_OffX			rs.w	1
WS_OffY			rs.w	1
WS_Font			rs.l	1
WS_FontY		rs.w	1
WS_FontX		rs.w	1
WS_Defwidth		rs.w	1		; \ Hhe und Breite vorm
WS_Defheight		rs.w	1		; / Windowffnen
WS_WinWidth		rs.w	1		; \ Hhe und Breite vorm
WS_WinHeight		rs.w	1		; / Windowffnen
WS_MinWidth		rs.w	1		; \ Hhe und Breite vorm
WS_MinHeight		rs.w	1		; / Windowffnen
WS_WinPosX		rs.w	1
WS_WinPosY		rs.w	1
WS_WindowDisabled	rs.w	1
WS_RealNumGadgets	rs.w	1

		*-- Vereinbarungen fr Openwindow --*
WS_Tags			rs.l	18*2		; 17Tags + 1 Reserve
WS_WindowTitle		rs.l	1
WS_WindowTitleSize	rs.l	1
WS_ScreenTitle		rs.l	1
WS_RawKeyTabelle	rs.l	1
WS_VanillaKeyTabelle	rs.l	1
WS_MenuTabelle		rs.l	1
WS_MenuItems		rs.l	1		; for InitMenus
WS_UpdateMenus		rs.l	1
WS_BerechMinWindowsize	rs.l	1		; Ptr to Routine
WS_InitGadgets		rs.l	1		; Ptr to Init-Routine
WS_AddGadgets		rs.l	1		; Ptr to Add-Routine
WS_FreeGadgets		rs.l	1
WS_CloseWindow		rs.l	1
WS_Creategadget		rs.l	1

WS_ZoomStruct		rs.w	4
WS_ZoomPosX		rs.w	1
WS_ZoomPosY		rs.w	1
WS_ZoomState		rs.w	1

WS_SizeOf		rs.b	0


	*--- Struktur, in der die Modulesprefs + Eigenschaften steht ---*
	STRUCTURE	MPE_MEStruct,0
	APTR		MPE_ModulesPrefs		;eigener MemBlock
	ULONG		MPE_ModulesPrefsSize	;(nullterminiert)
	APTR		MPE_Eigenschaften	;eigener MemBlock
	ULONG		MPE_EigenschaftenSize	;(nullterminiert)
	LABEL		MPE_SizeOf

	*-- Structur, in der die Module zusammengefat sind -*
	STRUCTURE	MY_ListStruct,0
	ULONG		PL_Dummy
	STRUCT		PL_Node,LN_Size
	ULONG		PL_StructSize
	APTR		PL_Name			;ohne Prefix
	APTR		PL_Filename		;(im Pfad) nullterminiert
	APTR		PL_Pfad			;nullterminiert
	STRUCT		PL_MEStruct,MPE_SizeOf
	*APTR		PL_ModulesPrefs		;eigener MemBlock
	*ULONG		PL_ModulesPrefsSize	;(nullterminiert)
	*APTR		PL_Eigenschaften	;eigener MemBlock
	*ULONG		PL_EigenschaftenSize	;(nullterminiert)
	LABEL		PL_Chars


	*-- Structur, in der normale Nodes wie Autoren/Gruppen/Engines
	*-- zusammengefat sind -*
	STRUCTURE	AGS_Entry,0
	STRUCT		AGS_Node,LN_Size
	STRUCT		AGS_MEStruct,MPE_SizeOf	-> nur fr Autoren/Gruppenwindow
	ULONG		AGS_StructSize		-> ACHTUNG: Engines haben eigens
	ULONG		AGS_Flags		  Prefsformat:
*	WORD		AGS_Type	;Type (Autor,Engine,Gruppe,PrefsGruppe
	LABEL		AGS_Chars


	*-- Structur, die beim inserten von Archiven bentigt wird
	STRUCTURE	MY_Archive,0
	APTR		ARC_ExtractorStruct	*Extractorstruct
	ULONG		ARC_EngineNr		*EngineNr
	ULONG		ARC_StructSize		*Size (normal=ASC_Size)
	APTR		ARC_EntryFilePtr	*Adr, ab der Entry kopiert wird
	ULONG		ARC_RestFileSize	*Size fr Entry
	LABEL		ARC_PathPuffer		*kompletter Pfad


	*-- Liststruktur, damit viele Routinen unterschiedliche Listen
	*-- verwalten knnen (Autoren/Gruppen/Engines)
	*-- Die Nodes sind in AGS_Struct definiert)
	STRUCTURE AGL_LISTE,0
	STRUCT	AGL_List,lh_size
	LONG	AGL_MaxEntries
	LONG	AGL_SelectedEntry
	WORD	AGL_GadgetID
	APTR	AGL_WindowStruct
	APTR	AGL_Doppelklick			;Jump to Prg
	APTR	AGL_DeleteEntry			;Jump to Prg
	APTR	AGL_New				;Jump to Prg
	BYTE	AGL_ListeDa
	BYTE	AGL_ListeChanged
	LABEL	AGL_Sizeof


		STRUCTURE MP_ModulePrefsstruct,0
		APTR	MP_Next
		LONG	MP_StructSize
		STRUCT	MP_Window,WS_SizeOF
		STRUCT	MP_Enginelist,AGL_SizeOf
		STRUCT	MP_Gruppenlist,AGL_SizeOf
		APTR	MP_MEStruct
		LONG	MP_Modulenr		;Nummer in Modulesliste
		WORD	MP_Type
		LABEL	MP_Sizeof

		STRUCTURE AGW_Struct,0
		STRUCT	AGW_Window,WS_SizeOF
		APTR	AGW_MPStruct
		LABEL	AGW_SizeOf


*ACHTUNG (Typen fr Modulenr):
MPMNR_Module	= 1
MPMNR_Autor	= 2
MPMNR_Gruppe	= 3
MPMNR_Global	= 4

*ACHTUNG (TAG fr CreateGadgets bei Prefswindow)
MPT_UpdateTags	= "EPPY"

			rsreset
InfoBlock		rs.b	260
TitlePuffer		rs.b	TitlePufferSize
PathPuffer		rs.b	PathPufferSize
*TextPuffer		rs.b	TextPufferSize
StringPuffer		rs.b	Namenlange+2
LocalePuffer		rs.w	LENr_LastExternal
GadgetMerkPuffer	rs.l	GadgetAnz+2
MyTags			rs.l	20*2
TextRequestArgs		rs.l	3
BufNewGad		rs.b	gng_sizeof	*Buffer fr Gadgetcreieren
MyFont			rs.l	2
MY_Easystruct		rs.l	5	;EASY-Request

		*--- Hauptwindowlisten ---*
Moduleslist		rs.b	lh_size
MaxEntries		rs.l	1
SelectedEntry		rs.l	1

Sortierlist		rs.b	lh_size
EmptyList		rs.b	lh_size



		*--- Autorenvereinbarungen ---*
Autorlist		rs.b	AGL_Sizeof
Autorwindowstruct	rs.b	AGW_SizeOf

		*--- Gruppenvereinbarungen ---*
Gruppenlist		rs.b	AGL_Sizeof
Gruppenwindowstruct	rs.b	AGW_SizeOf


CurrentSeconds		rs.l	1
CurrentMicros		rs.l	1
StartSeconds		rs.l	1
StartMicros		rs.l	1
MyCatalog		rs.l	1
MyTaskAdr		rs.l	1
GadgetListadr		rs.l	1
MenuAdr			rs.l	1
VisualInfo		rs.l	1
MyPubScreen		rs.l	1
WinHandle		rs.l	1
WindowPort		rs.l	1
MyRastPort		rs.l	1
OldMenuAdr		rs.l	1
MyMessage		rs.b	UM_SizeOf
ENA_Args1		rs.b	ENA_String+34
ENA_Args2		rs.b	ENA_String+34
MerkUserNr		rs.w	1
MsgUnterwegs		rs.l	1
ExitNow			rs.w	1
Qualifier		rs.w	1
GlobalPrefs		rs.l	1		;Future Prefs fr ganze Liste
MsgPort			rs.l	1
UPrg_Struct		rs.l	1
Signal			rs.l	1
SignalBits		rs.l	1
OldDirLock		rs.l	1
Font			rs.l	1
FontX			rs.w	1
FontY			rs.w	1
OffX			rs.w	1
OffY			rs.w	1
WinPosX			rs.w	1
WinPosY			rs.w	1
WinHeight		rs.w	1
WinWidth		rs.w	1
ZoomPosX		rs.w	1
ZoomPosY		rs.w	1
InfoWidth		rs.w	1
InfoWidth2		rs.w	1
KillAllOnDisk		rs.w	1
PW_UL1			rs.w	1
PW_UR2			rs.w	1
PW_UL2			rs.w	1
PW_UR1			rs.w	1
PW_LTL			rs.w	1
Prefs_LastLeftEdge	rs.w	1
Prefs_LastTopEdge	rs.w	1
Prefs_LastWidth		rs.w	1
Prefs_LastHeight	rs.w	1
LastWidth		rs.w	1		;Opaque-Sizing Workaround
LastHeight		rs.w	1

FirstPrefsWindowstruct	rs.l	1
IntBase			rs.l	1
GFXBase			rs.l	1
DosBase			rs.l	1
GadBase			rs.l	1
LocaleBase		rs.l	1
MyReqToolsBase		rs.l	1
RealNumGadgets		rs.l	1
WindowDisabled		rs.w	1
Kick3On			rs.w	1
Result			rs.l	1		*Result bei GetGadgetattr

BNS_ModPrefs		rs.l	1
BNS_ModPrefsSize	rs.l	1
BNS_Counter		rs.l	1

			*-- BackPic --*
;----------------------- Daten fr Datatypes-Bild ----------------------------------------
DatatypesBase		rs.l	1
DT_PicObject		rs.l	1
DT_MyBitMapheader	rs.l	1
DT_MyBitMap		rs.l	1
DT_Breit2:		rs.l	1
DT_Hoehe2:		rs.l	1
DT_XPos2:		rs.l	1
DT_YPos2:		rs.l	1
Mycmap			rs.l	1
MyPen			rs.l	1
DT_Picture		rs.b	300
ConfigDatas		rs.b	0			\  wird als eigene
DT_Picturedir		rs.b	200			 \ Prefs abgespeichert
DT_Picturename		rs.b	108			 /
ListDir			rs.b	200			 \ Prefs abgespeichert
ListName		rs.b	108			 /
SelectDir		rs.b	200			 \ Prefs abgespeichert
SelectName		rs.b	108			 /
ConfigDatasEND		rs.b	0			/



ZoomState		rs.b	1
ListeDa			rs.b	1
ListeChanged		rs.b	1

PufferEnd		rs.b	0




	*------------------------------------------------------------------*
	* Die ist die vorlufige interne Struktur zum Verwalten der Listen *
	* Ab PL_Chars beginnen hintereinander die Strings in Reihenfolge,  *
	* wie sie in der Struktur auftauchen!
	*------------------------------------------------------------------*
Sicherheitsbytes	EQU	1
PL_Strings		EQU	1	;Anzahl der Strings ab Chars, ntig
					;zur ausreichenden Allokierung von
					;Speicher (0 Bytes)



	*--------- Flags fr Textrequester & Stringrequest ---------*
EPTRF_Zahl		EQU	0		* only Stringrequest
EPTRF_String		EQU	1		* only Stringrequest
EPTRF_Center		EQU	2
EPTRF_TestTimout	EQU	3
EPTRF_Invisible		EQU	4		* only Stringrequest

EPTRB_Zahl		EQU	1<<EPTRF_Zahl
EPTRB_String		EQU	1<<EPTRF_String
EPTRB_Center		EQU	1<<EPTRF_Center
EPTRB_TestTimout	EQU	1<<EPTRF_TestTimout
EPTRB_Invisible		EQU	1<<EPTRF_Invisible


EB	macro
	if	test
	move.l	4,a6
	else
	move.l	4.w,a6
	endc
	ENDM

;===========================================================================
	section	0,code
;===========================================================================

		if	test
Start
	*lea	args,a0
	*moveq	#EPNr_Filter,d0
	*bsr	FindMPArg
*args:
* dc.b	"147='Moduleinfo'=01=EP='140,45,43';'Analyzer',64=1,116=64",0
		bra	FirstInit
	illegal

FirstEagleInit:	lea	EaglePuffer,a5
		move.l	a5,EUS_EPBase+EUS_Structure

		lea	MyIntuiname,a1
		EB
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Intuitionbase(a5)

		lea	MyGFXname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GFXbase(a5)

		lea	MyGadToolsname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GadToolsbase(a5)

		lea	MyLocalename,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,EPG_Localebase(a5)

		lea	MyDosname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Dosbase(a5)

		lea	EP_List1,a0
		move.l	a0,EPG_ModulesList(a5)

		newlist a0
		lea	EP_List1,a0
		lea	EP_Entry1,a1
		move.l	#Name1,LN_Name(a1)
		addtail	a0,a1

		lea	EP_List1,a0
		lea	EP_Entry2,a1
		move.l	#Name2,LN_Name(a1)
		addtail	a0,a1

		lea	EP_List1,a0
		lea	EP_Entry3,a1
		move.l	#Name3,LN_Name(a1)
		addtail	a0,a1

		lea	Puffer,a5
		rts

MyIntuiname:	dc.b	"intuition.library",0
MyGFXname:	dc.b	"graphics.library",0
MyGadtoolsname:	dc.b	"gadtools.library",0
MyLocalename:	dc.b	"locale.library",0
MyDosname:	dc.b	"dos.library",0
Name1:		dc.b	"Module1",0
Name2:		dc.b	"Module2",0
Name3:		dc.b	"Module3",0

Autor1:		dc.b	"Ravebusters",0
Autor2:		dc.b	"Moby",0
Autor3:		dc.b	"Jam & Spoon",0

Gruppe1:	dc.b	"Jazz",0
Gruppe2:	dc.b	"Tekkno",0
Gruppe3:	dc.b	"Ani/Latte/SN",0

TestList:	dc.b	"MODLIST",10
		dc.b	"Modules:Agnostica",10
		dc.b	"'EP:Test' MP:01=1,02='8-Bit Amplifier',03='Animal'",10
		dc.b	'":Test3"'
TestListSize	= *-Testlist

		even
EaglePuffer	ds.b	EPG_SizeOf

EP_List1	ds.b	LH_Size
EP_Entry1	ds.b	LN_Size
EP_Entry2	ds.b	LN_Size
EP_Entry3	ds.b	LN_Size

Autor_Entry1	ds.b	AGS_Chars+6
Autor_Entry2	ds.b	AGS_Chars+6

		endc
*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
EUS_Structure:	bra.w	FirstInit			;EUS_Jump
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
EPBase		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	0				;EUS_TickFlags
		dc.l	USMB_KillModule!USMB_NewModule!USMB_WaitPointer!USMB_Zipwin!USMB_ChangeConfig!USMB_NewPreference
		dc.l	MyProzessName			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	37				;EUS_Kickstart
		dc.l	11				;EUS_EPVersion
		dc.w	1				;EUS_Version
		dc.w	5				;EUS_Revision
		dc.l	MyProzessName			;EUS_Username
		dc.w	200				;EUS_WinX
		dc.w	$62 14				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
EUS_Width	dc.w	DefWidth		;EUS_Special  -> InnerWidth
EUS_Height	dc.w	Defheight		;EUS_Special+2 -> InnerHeigth
		dc.l	0				;EUS_Special2
ZoomX		equ	EUS_Special2
ZoomY		equ	EUS_Special2+2
ZoomONOFF	equ	EUS_Special3
PrefsFlags	equ	EUS_Special3+2
		dc.w	0				;EUS_Special3
		if	Test!Debugger
		dc.w	PFB_LoadAtStart!PFB_BackPic!PFB_Synchron!PFB_HideAll			;PrefsFlags
		else
		dc.w	PFB_Synchron!PFB_HideAll	;PrefsFlags
		endc

		dc.b	28,02
		dc.w	1997				;EUS_Creatordate
		dc.b	0				;EUS_Prioritt
		dc.b	EUTY_Listadministration		;EUS_Type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6
		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	"$VER: Eagleplayer-Pysion V0.99 (28 Feb 1997)",0
		even

TagListe:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Pysion
		dc.l	0


*----------------------------------------------------------------------------*
FirstInit:	lea	Puffer,a5		;BSS lschen
		EB
		cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
		blo	Exit			;nein,raus
		bsr	ClrPuffer

		EB
		cmp.w	#39,Lib_Version(a6)
		blo.s	.NoKick3
		not.w	Kick3On(a5)
.NoKick3:	move.l	EUS_Structure+EUS_EPBase(pc),d0
		beq.w	Exit

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	DTG_Intuitionbase(a4),Intbase(a5)
		move.l	DTG_GFXBase(a4),GFXBase(a5)
		move.l	EPG_LocaleBase(a4),LocaleBase(a5)
		move.l	DTG_GadtoolsBase(a4),GadBase(a5)
		move.l	DTG_Dosbase(a4),DosBase(a5)
		
		move.l	#-1,mypen(A5)	;Halfshine Farbe fr Gadgets, zur Sicherheit -1 gesetzt

		lea	EUS_Structure(pc),a0
		move.b	ZoomOnOff(a0),ZoomState(a5)
		move	Eus_Winx(a0),WinPosX(a5)
		move	Eus_Winy(a0),WinPosY(a5)
		move	ZoomX(a0),ZoomPosX(a5)
		move	ZoomY(a0),ZoomPosY(a5)

		*move.l	#1,SelectedEntry(a5)

		bsr	InitLists
		bsr	FirstLocaleInit
		bsr	SetDefaultPaths

		sub.l	a1,a1
		EB
		jsr	_LVOFindTask(a6)
		move.l	d0,MyTaskAdr(a5)

		bsr	LoadPysionConfig


*-------------------------- Mesage an Eagleplayer schicken -----------------*
*---- Input:	;d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
	if Executable+Debugger
		if debugger
		move.l	#EUS_Structure,d5
		else
		moveq	#0,d5
		endc
		moveq	#0,d1
		moveq	#USClass_NewUserPrg,d2
		moveq	#0,d3
		moveq	#0,d4
		if	debugger
		move.w	#-2,MerkUserNr(a5)
		move.w	#-2,EUS_Structure+EUS_EngineNr
		endc
		bsr	SendeOneMessage
		if	debugger
		move.w	MyMessage+UM_UserNr(a5),MerkUserNr(a5)
		tst.l	d0
		endc
	else
		bsr.w	OpenWin
	endc
		beq.s	ExitEngine

		*--- Liste laden ---*
		move.w	EUS_Structure+PrefsFlags(pc),d0
		btst	#PFF_LoadAtStart,d0
		beq.s	.NoLoad
		bsr	LoadStartList
		clr.b	ListeChanged(a5)
.NoLoad		btst	#PFF_AutoLearnAuthors,d0
		beq.s	.NoLoadAut
		bsr	LoadAuthors
.NoLoadAut:
	*------------ Hauptprogramm ablaufen lassen ------------*
	*bsr	A_Autorliste
	*bsr	A_Prefs

*	bsr	M_ModulesPrefs
*	move.l	FirstPrefsWindowStruct(a5),a3
*	bsr	UpdateModulesPrefs

		bsr.w	Warten



*-----------------------------------------------------------------------------*
ExitEngine:	lea	Puffer,a5

		bsr	WaitUserMessages
		bsr	CloseWin
		bsr	FreeLocale
		bsr	FreeList

		bsr	DeleteAllAGLLists

		bsr	RemoveMsgPort

		move.l	DatatypesBase(a5),d0
		beq.s	.nodt
		move.l	d0,a1
		EB
		jsr	_LVOCloselibrary(a6)
		clr.l	DatatypesBase(a5)
.nodt

		move.l	MyReqToolsBase(a5),d0
		beq.s	.noReqTools
		move.l	d0,a1
		EB
		jsr	_LVOCloselibrary(a6)
		clr.l	MyReqToolsBase(a5)
.NoReqTools:


Exit:		bsr	ClearDefaultPaths
		moveq	#EPR_ErrorAddUserPrg,d0
		ifeq	Executable
		illegal
		else
		rts
		endc
*-----------------------------------------------------------------------------*
InitLists:	lea	Moduleslist(a5),a0
		Newlist	a0

		*-- AGL-Structs --*
		lea	AutorWindowStruct(a5),a1
		lea	Autorlist+AGL_List(a5),a0
		move.l	a1,AGL_Windowstruct-AGL_List(a0)
		move.w	#EPENrA_Autorlist,AGL_GadgetID(a0)
		lea	A_NimmAutor(pc),a1
		move.l	a1,AGL_Doppelklick-AGL_List(a0)
		lea	A_DeleteAutor(pc),a1
		move.l	a1,AGL_DeleteEntry-AGL_List(a0)
		lea	A_NewAutors(pc),a1
		move.l	a1,AGL_New-AGL_List(a0)
		Newlist	a0

*		if	Test
*		lea	Autor1(pc),a0
*		lea	Autorlist(a5),a4
*		bsr	AG_InsertItem
*		lea	Autor2(pc),a0
*		lea	Autorlist(a5),a4
*		bsr	AG_InsertItem
*		lea	Autorlist(a5),a4
*		lea	Autor3(pc),a0
*		bsr	AG_InsertItem
*		endc

		move.w	#-1,Prefs_LastLeftEdge(a5)
		move.w	#-1,Prefs_LastTopEdge(a5)
		move.w	#-1,Prefs_LastWidth(a5)
		move.w	#-1,Prefs_LastHeight(a5)
		


		lea	GruppenWindowStruct(a5),a1
		lea	Gruppenlist+AGL_List(a5),a0
		move.l	a1,AGL_Windowstruct-AGL_List(a0)
		move.w	#EPENrG_Gruppenlist,AGL_GadgetID(a0)
		lea	G_NimmGruppe(pc),a1
		move.l	a1,AGL_Doppelklick-AGL_List(a0)
		lea	G_DeleteGruppe(pc),a1
		move.l	a1,AGL_DeleteEntry-AGL_List(a0)
		lea	G_NewGruppe(pc),a1
		move.l	a1,AGL_New-AGL_List(a0)
		Newlist	a0

*		if	Test
*		lea	Gruppe1(pc),a0
*		lea	Gruppenlist(a5),a4
*		bsr	AG_InsertItem
*		lea	Gruppe2(pc),a0
*		lea	Gruppenlist(a5),a4
*		bsr	AG_InsertItem
*		lea	Gruppenlist(a5),a4
*		lea	Gruppe3(pc),a0
*		bsr	AG_InsertItem
*		endc



		lea	Sortierlist(a5),a0
		Newlist	a0
		lea	Emptylist(a5),a0
		Newlist	a0

		move.w	#-1,AutorWindowStruct+WS_WinPosX(a5)
		move.w	#-1,AutorWindowStruct+WS_WinPosY(a5)
		move.w	#-1,GruppenWindowStruct+WS_WinPosX(a5)
		move.w	#-1,GruppenWindowStruct+WS_WinPosY(a5)
		rts

*-----------------------------------------------------------------------------*
DeleteAllAGLLists:
		lea	Autorlist(a5),a4
		bsr	DeleteAGList
		lea	Gruppenlist(a5),a4
		bsr	DeleteAGList
		rts

*-----------------------------------------------------------------------------*
SetDefaultPaths:movem.l	d1-a6,-(a7)

		lea	DefaultDir(pc),a0
		lea	ListDir(a5),a1
		move.w	#30,d1
		bsr	StringCopy

		lea	DefaultFile(pc),a0
		lea	Listname(a5),a1
		moveq	#30,d1
		bsr	StringCopy

	ifeq	test
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Configdir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
.NoConfigDir:	move.l	d0,OldDirLock(a5)

		movem.l	(a7)+,d1-a6
		rts

*-----------------------------------------------------------------------------*
ClearDefaultPaths:
		movem.l	d0-a6,-(a7)
		move.l	OldDirLock(a5),d1
		beq.s	.NoOldDir
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoOldDir:	clr.l	OldDirLock(a5)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Output: d0+a6 = Librarybase
*-----------------------------------------------------------------------------*
GetReqToolsBase:movem.l	d1-a5,-(a7)
		move.l	MyReqToolsBase(a5),d0
		bne.s	.Return
		lea	MyReqToolsName(pc),a1
		EB
		moveq	#38,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,MyReqToolsBase(a5)
.Return:	move.l	d0,a6
		movem.l	(a7)+,d1-a5
		rts


*-----------------------------------------------------------------------------*
SendeOneMessage:
		movem.l	d1-a6,-(a7)
	if	executable+debugger
		bsr	CreateMsgPort
		beq.w	.Fehler
		bsr	WaitUserMessages

		*bsr	AllocMsg
		*beq	.fehler
		*move.l	d0,a1
		lea	MyMessage(a5),a1

	*------------ Exec-Message initialisieren -----------*
		move.w	#UM_Sizeof-20,MN_Length(a1)
		move.b	#NT_Message,LN_Type(a1)
		move.l	MsgPort(a5),MN_ReplyPort(a1)

	*------------ User-Message initialisieren -----------*
		if	debugger
		move.w	MerkUserNr(a5),UM_UserNr(a1)
		else
		move.w	EUS_Structure+EUS_UserNr(pc),UM_UserNr(a1)
		endc
		move.l	MyTaskAdr(a5),UM_TaskAdr(a1)
		move.l	Signal(a5),UM_Signal(a1)
		move.l	MsgPort(a5),UM_UserPort(a1)
		move.l	#USM_Userprg,UM_Type(a1)
		move.w	d1,UM_Enabled(a1)
		move.w	d2,UM_Class(a1)			;Kennung setzen
		move.l	d3,UM_Command(a1)
		move.l	d4,UM_ArgString(a1)
		move.l	d5,UM_Result(a1)

		*move.l	a1,ThisMessage(A5)

	*------------ Message senden -------------*
.RetryFindPort:	lea	EPUserPortName(pc),a1
		EB
		jsr	_LVOFindPort(a6)
		move.l	d0,a0
		tst.l	d0
		bne.s	.PortDa

	*----- Eagleplayer-Port nicht gefunden ----*
		moveq	#LENr_EPNotFound,d0
		moveq	#LENr_Ok,d1
		bsr	TextRequest
		moveq	#0,d0
		bra.s	.Fehler
		*beq.s	.Fehler
		*bra.s	.RetryFindPort

.PortDa:	movem.l	d0/a0,-(a7)
		*move.l	ThisMessage(A5),a1
		lea	MyMessage(a5),a1

		move.l	UM_TaskAdr(a1),d0
		beq.s	.NoTask
		move.l	d0,a1
		moveq	#0,d0
		jsr	_LVOSetTaskPri(a6)	
.NoTask:	movem.l	(a7)+,d0/a0
		*move.l	ThisMessage(A5),a1
		lea	MyMessage(a5),a1
		jsr	_LVOPutMsg(a6)

		addq.l	#1,MsgUnterwegs(a5)

	*---------- Alles klar, Ende ----------*
.NoPort:	bsr	WaitUserMessages
	endc
		moveq	#-1,d0
.Fehler:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
CreateMsgPort:	movem.l	d1-d7/a1-a6,-(a7)
		move.l	MsgPort(a5),d0
		bne.s	.PortOk
		EB
		jsr	_LVOCreateMsgPort(a6)	;Messageport auf die schnelle Art
		move.l	d0,MSGport(a5)
		tst.l	d0
		beq.s	.PortOk
		move.l	d0,a1
		move.l	#MyMsgPortName,LN_Name(a1)
		jsr	_LVOAddPort(a6)


	*----------- SignalBits setzen ------------*
		move.l	MsgPort(a5),a0
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)

.PortOk:	movem.l	(a7)+,d1-d7/a1-a6
		move.l	MsgPort(a5),d0
		move.l	d0,a0
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
RemoveMsgPort:	movem.l	d0-a6,-(a7)

	*----------- SignalBits sperren ------------*
		move.l	MSGport(a5),d0
		beq.s	.PortOk
		move.l	d0,a1
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)
		EB
		jsr	_LVORemPort(a6)

		move.l	MsgPort(a5),a0
		jsr	_LVODeleteMsgPort(a6)	;Messageport auf die schnelle Art
		clr.l	MsgPort(a5)
.PortOk:	movem.l	(a7)+,d0-a6
		rts

*----------------------- Gibt die Return-Structure frei -------------------*
* Input: a0=Adr der Argliste
FreeCommandStruct:
		movem.l d0/d1/a0/a1/a4/a6,-(a7)
		move.l	a0,a4
.NextStruct:	moveq	#0,d0
		cmp.l	a4,d0
		beq.w	.Return
		move.l	a4,a1
		move.l	(a1),a4
		move.l	EPT_StringSize(a1),d0
		beq.s	.StructFree
		EB
		jsr	_LVOFreeMem(a6)
.StructFree:	bra.b	.NextStruct
.Return:
		*clr.l	UPrg_Struct(a5)
		movem.l	(a7)+,d0/d1/a0/a1/a4/a6
		rts

*---------------------------------------------------------------------------*
*----- Wartet, bis alle Messages von den Userprogrammen wieder da sind -----*
*---------------------------------------------------------------------------*
WaitUserMessages:movem.l d0-a6,-(a7)

	if debugger
		bsr.w	CopyEPBase
	endc

.WaitNochmal:	tst.l	MsgUnterwegs(a5)
		beq.w	.Return
		move.l	4,a6
		bsr	CreateMsgPort
		beq.s	.Return
		move.l	a0,a3
		jsr	_LVOWaitPort(a6)
		move.l	a3,a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.s	.WaitNochmal
		move.l	d0,a1
		bsr	UserMessage
		bra.s	.WaitNochmal
.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
ClrPuffer:	if	Test
		bsr	FirstEagleInit
		endc

		move.l	a5,a0
		move.w	#PufferEnd-1,d0
.clr		clr.b	(a0)+
		dbf	d0,.clr
		rts

		if	Debugger!Test
CopyEPBase:	move.l	EUS_Structure+EUS_EPBase(pc),d0
		beq.s	.Fertig
		move.l	d0,EPBase
		
*		move.w	#EPG_SizeOf/2-1,d0
*		move.l	a5,a1
*.CopyEP:	move.w	(a0)+,(a1)+
*		dbf	d0,.CopyEP
.Fertig:	rts
		endc

*-----------------------------------------------------------------------------*
* Sendet dem Eagleplayer, falls dieser im Helpmode ist, eine HelpNode
*-----------------------------------------------------------------------------*
* Input: a0=Nodename
* Output:d0=0  --> Node geschickt
SendHelp:	movem.l	d1-a6,-(a7)
		move.l	EPBase(pc),a4
		move.l	EPG_SomePrefs(a4),d1
		btst	#EGPRF_Help,d1
		beq.s	.NoHelp

		*--- Args setzen ---*
		bsr	BerechStringSize
		move.l	d0,ENA_Args2+ENA_Arg1(a5)
		lea	ENA_Args2+ENA_String(a5),a1
		moveq	#32,d1
		bsr	StringCopy
		move.l	#EPNr_FirstEngine,d0
		add.w	EUS_Structure+EUS_UserNr(pc),d0
		move.l	d0,ENA_Args1+ENA_Arg1(a5)

		*--- Kommando an EP schicken ---*
		lea	ENA_Args2(a5),a1
		lea	ENA_Args1(a5),a0
		move.l	a1,(a0)
		move.l	a0,d4
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_HelpLink,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage
		clr.l	ENA_Args1(a5)

		moveq	#1,d0
.NoHelp:	seq	d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Eine Message wird an den Eagleplayer gesendet.
* Input: d0=Wert fr Arg1 = Nummer
*	 d1=Wert fr Arg2
*	 d3=EPNr_Nummer
SendMess:	movem.l	d0-a6,-(a7)
		lea	ENA_Args1(a5),a0
		move.l	d0,ENA_Arg1(a0)
		clr.l	ENA_Size(a0)
		move.l	d1,ENA_Arg2(a0)
		clr.l	ENA_Next(a0)
		move.l	a0,d4			-> Args
		moveq	#0,d1
		moveq	#USClass_Command,d2
		moveq	#0,d5
		bsr	SendeOneMessage
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Eine Message wird ohne Args an den Eagleplayer gesendet.
* Input: d3=EPNr_Nummer
SendOhneMess:	movem.l	d0-a6,-(a7)
		moveq	#0,d4
		moveq	#0,d1
		moveq	#USClass_Command,d2
		moveq	#0,d5
		bsr	SendeOneMessage
		movem.l	(a7)+,d0-a6
		rts

*---------------------------------------------------------------------------*
*------------ Hier befindet sich nun die Schleife die Aktionen -------------*
*---------------------------------------------------------------------------*
Warten:		move.l	MsgPort(a5),d0
		beq.s	WartenWinPort
		move.l	d0,a0
		EB
		jsr	_LVOGetmsg(a6)
		tst.l	d0			;Scrollen erlaubt
		beq.w	WartenWinPort
		bsr.w	UserMessage
		bra.w	Warten

SendExit:	moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
Return:		rts

WartenWinPort:	tst.w	ExitNow(a5)
		bne.w	Return

		move.l	WindowPort(a5),d0
		beq.s	WartenAWinPort
		move.l	d0,a0
		move.l	GadBase(a5),a6
		jsr	_LVOGT_GetIMsg(a6)
		tst.l	d0
		beq.s	WartenAWinPort
		move.l	d0,a1
		bsr.w	GetMsg

		cmp.w	#EPNr_Engine,d0
		bne.s	Warten
		rts

WartenAWinPort:	lea	AutorWindowstruct(a5),a4
		move.l	WS_WindowPort(a4),d0
		beq.s	WartenGWinPort
		move.l	d0,a0
		move.l	GadBase(a5),a6
		jsr	_LVOGT_GetIMsg(a6)
		tst.l	d0
		beq.s	WartenGWinPort
		move.l	d0,a1
		bsr.w	AG_GetMsg
		bra.w	Warten


WartenGWinPort:	lea	GruppenWindowstruct(a5),a4
		move.l	WS_WindowPort(a4),d0
		beq.s	WartenPWinPort
		move.l	d0,a0
		move.l	GadBase(a5),a6
		jsr	_LVOGT_GetIMsg(a6)
		tst.l	d0
		beq.s	WartenPWinPort
		move.l	d0,a1
		bsr.w	AG_GetMsg
		bra.w	Warten

WartenPWinPort:	lea	FirstPrefsWindowstruct-MP_Next(a5),a3
.NextPrefs:	move.l	MP_Next(a3),d0
		beq.s	Wait
		move.l	d0,a3
		lea	MP_Window(a3),a4
		move.l	WS_WindowPort(a4),d0
		beq.s	.NextPrefs
		move.l	d0,a0
		move.l	GadBase(a5),a6
		jsr	_LVOGT_GetIMsg(a6)
		tst.l	d0
		beq.s	.NextPrefs
		move.l	d0,a1
		bsr.w	AG_GetMsg
		bra.w	Warten


*----------------------------------------------------------------------------*
*------------- Hier wait, bis einer der Message-Ports ->>> Message ----------*
*----------------------------------------------------------------------------*
Wait:		move.l	SignalBits(a5),d0
		or.w	#$1000,d0		;Break-Signal
		EB
		jsr	_LVOWait(a6)

	*------- War es ein Break Signal -----*
		btst	#12,d0			;Break-Signal
		bne.w	SendExit

	*------- War es ein EngineMessage ------*
		move.l	MsgPort(a5),d2
		beq.s	.NoPort
		move.l	d2,a0
		moveq	#0,d1
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	Warten			;EaglePort

	*----- war es eine Window-Message ----*
.NoPort:	move.l	WindowPort(a5),d2		;Testen ob Window-Port
		beq.s	.NoMain
		move.l	d2,a0
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenWinPort

	*----- war es eine Window-Message (Autorwindow) ----*
.NoMain:	lea	AutorWindowstruct(a5),a4
		move.l	WS_WindowPort(a4),d2		;Testen ob Window-Port
		beq.s	.NoAutor
		move.l	d2,a0
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenAWinPort

	*----- war es eine Window-Message (Gruppenwindow) ----*
.NoAutor:	lea	GruppenWindowstruct(a5),a4
		move.l	WS_WindowPort(a4),d2		;Testen ob Window-Port
		beq.s	.NoGruppe
		move.l	d2,a0
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenGWinPort

	*----- war es eine Window-Message (Prefswindows) ----*
.NoGruppe:	lea	FirstPrefsWindowstruct-MP_Next(a5),a3
.NextWindow:	move.l	MP_Next(a3),d2
		beq.s	Wait
		move.l	d2,a3
		lea	MP_Window(a3),a4
		move.l	WS_WindowPort(a4),d2		;Testen ob Window-Port
		beq.s	.NoAutor
		move.l	d2,a0
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenPWinPort
		bra.w	.NextWindow





*-----------------------------------------------------------------------------*
GetMsg:		lea	Puffer,a5
		*move.l	WindowPort(a5),d0
		*beq.w	.Return
		*move.l	d0,a0
		*move.l	GadBase(a5),a6
		*jsr	_LVOGT_getimsg(a6)
		*tst.l	d0
		*beq	.Return
		*move.l	d0,a1
		move.l	im_class(a1),d7
		moveq	#0,d5
		move.l	IM_Seconds(a1),CurrentSeconds(a5)
		move.l	IM_Micros(a1),CurrentMicros(a5)
		move.w	im_code(a1),d5 		<- Fr Tastatur / Selnummer Listview
		move.l	im_Iaddress(a1),d6 	<- Fr Gadgetabfrage
		move.l	im_seconds(a1),d2	<- fr Doppelclick
		move.l	im_micros(a1),d3	<- auch f. Doppelclick
		move.w	im_Qualifier(a1),Qualifier(a5)
		jsr	_LVOGT_ReplyIMsg(a6)

	*---------------- MSG auswerten -------------*
		cmp.l	#IDCMP_Changewindow,d7	;Refresh
		bne.s	.TestNewSize
		move.l	Winhandle(a5),a0
		move	OffY(A5),d0
		cmp	wd_height(a0),d0
		bne.s	.setposun
		move.w	wd_leftedge(a0),ZoomPosX(a5)
		move.w	wd_topedge(a0),ZoomPosY(a5)
		st	ZoomState(a5)
		bra.w	.Return
.Setposun:	move.w	wd_leftedge(a0),WinPosX(a5)
		move.w	wd_topedge(a0),WinPosY(a5)
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)
		sf	ZoomState(a5)
		bra.w	.Return

*---------------------------------------------------*
* das war die alte Refreshroutine
******************************************
*.TestNewSize:	cmp.l	#NewSize,d7
*		bne.s	.TestRefreshWindow
*
*		move.l	Winhandle(a5),a0
*		move	OffY(A5),d0
*		cmp	WD_Height(a0),d0
*		beq.s	.SizeNoMerk
*		move.w	wd_Width(a0),WinWidth(a5)
*		move.w	wd_Height(a0),WinHeight(a5)
*.SizeNoMerk:	move.l	GadgetListAdr(a5),d0
*		beq.s	.TestRefreshWindow
*		move.l	d0,a1
*		moveq	#0,d0
*		move.w	RealNumGadgets(a5),d0
*		move.l	Winhandle(a5),a0
*		move.l	Intbase(a5),a6
*		jsr	_LVORemoveGList(a6)
*		bsr	FreeGadgets
*		bsr	Clearwindow
*		bsr	InitGadgets
*		bne.w	.Return
*		bsr	AddGads
*		*bne	.Return
*		bsr	EinTragNeu
*		bra.w	.Return
*
*.TestRefreshWindow:
*
*		cmp.l	#Refreshwindow,d7	;Refresh
*		bne.s	.TestGadgetUp
*
*.Refresh:
*
*	move.l	IntBase(a5),a6
*	move.l	WinHandle(a5),a0
*	jsr	_LVORefreshWindowFrame(a6)
*	bra.w	.return
*---------------------------------------------------*

.TestNewSize:	cmp.l	#NewSize,d7
		bne.s	.TestRefreshWindow

		move.l	Winhandle(a5),a0

		move.w	wd_width(a0),d0
		move.w	wd_height(a0),d1

		cmp.w	LastWidth(a5),d0
		bne.s	.NewSizeReal
		cmp.w	LastHeight(a5),d1
		beq.w	.Return
.NewSizeReal:
		move.w	d0,LastWidth(a5)
		move.w	d1,LastHeight(a5)

		bsr	ResizeWindow
		bra.w	.Return

*.TestNewSize:	cmp.l	#NewSize,d7
*		bne.s	.TestRefreshWindow
*
*		move.l	Winhandle(a5),a0
*		move	OffY(A5),d0
*		cmp	WD_Height(a0),d0
*		beq.w	.Return
*	*move.w	wd_width(a0),d0
*	*cmp.w	WinWidth(a5),d0
*	*bne.s	.NewSizeReal
*	*move.w	wd_height(a0),d0
*	*cmp.w	WinHeight(a5),d0
*	*beq.w	.Return
*.NewSizeReal:
*		move.w	wd_Width(a0),WinWidth(a5)
*		move.w	wd_Height(a0),WinHeight(a5)
*	*	bsr	ResizeWindow
*		bra.w	.Return
*

.TestRefreshWindow:

		cmp.l	#Refreshwindow,d7	;Refresh
		bne.s	.TestGadgetUp
*		bsr	ResizeWindow
		bra.w	.Return



*		bsr	Clearwindow
*	*	move.l	Gadbase(a5),a6
*	*	move.l	Winhandle(a5),a0	;*Window
*	*	jsr	_LVOGT_beginrefresh(a6)
*
*	*	move.l	Winhandle(a5),a0	;*Window
*	*	moveq	#1,d0
*	*	jsr	_LVOGT_Endrefresh(a6)
*
*		move.l	GadgetListAdr(a5),a0
*		move.l	Winhandle(a5),a1
*		suba.l	a2,a2
*		moveq	#-1,d0
*		move.l	IntBase(a5),a6
*		jsr	_LVOrefreshglist(a6)
*
*		move.l	GadBase(a5),a6
*		move.l	Winhandle(a5),a0
*		sub.l	a1,a1
*		jsr	_LVOGT_RefreshWindow(a6)
*
*
*		bra.w	.Return

.TestGadgetUp:	cmp.l	#Gadgetup,d7
		bne.w	.TestMenu
		move.l	d6,a1
		move.w	GG_Gadgetid(a1),d0	;Nr des Gadgets
		bsr	JumpTo
		bra.w	.Return


.MenuLoop:	move.l	OldMenuAdr(a5),a1
		move.w	MI_NextSelect(A1),d5
		bra.s	.MenuNext
.TestMenu:	cmp.l	#MenuPick,d7
		bne.w	.TestRawKey
.MenuNext:	move.w	d5,d0
		cmp.w	#menunull,d0
		beq	.Return
		move.l	MenuAdr(a5),a0
		move.l	IntBase(a5),a6
		jsr	_LVOItemAddress(a6)
		move.l	d0,a1
		tst.l	d0
		beq	.Return
		move.l	d0,OldMenuAdr(a5)

		lea	Menutabelle(pc),a0
.NextItem:	move.w	(a0)+,d1
		beq.w	.Return
		move.w	(a0)+,d0
		cmp.w	d5,d1
		bne.s	.NextItem
.JumpToNow:	moveq	#0,d2		;d5 mit durchschleifen fr Show by
		sub.l	a2,a2
		bsr	JumpTo
		bra.w	.Return



.TestRawkey:	cmp.l	#rawkey,d7
		bne	.TestVanillaKey
		

		lea	RawKeytabelle(pc),a0

		move.w	Qualifier(a5),d2
		moveq	#3,d3
		btst	#3,d2
		bne.s	.MenuQOk
		moveq	#2,d3
		btst	#0,d2
		bne.s	.MenuQOk
		btst	#1,d2
		bne.s	.MenuQOk
		moveq	#1,d3
.MenuQOk:	moveq	#0,d2
		move.b	(a0)+,d0
		move.b	(a0)+,d1
		move.b	(a0)+,d2
		tst.b	d0
		beq.w	.Return
		cmp.b	d0,d3
		bne.s	.MenuQOk
		cmp.b	d1,d5
		bne.s	.MenuQOk
		move.l	d2,d0
		cmp.b	#-1,d0
		beq.s	.ToggleHelpMode
		cmp.b	#-2,d0
		beq.s	.HideWindow
		bsr	JumpTo
		bra.w	.Return


.ToggleHelpMode:moveq	#EPNr_Help,d3
		moveq	#-1,d0				;Toggle
		moveq	#0,d1
		bsr	SendMess
		bsr	ErlaubeGadgets
		bra.w	.Return

.TestVanillaKey:cmp.l	#vanillakey,d7
		bne	.TestCloseWindow

		*cmp.b	#13,d5				;Tab
		*beq.s	.ToggleZustand
		*cmp.b	#32,d5				;Leertaste
		*beq.s	.ToggleZustand
		cmp.b	#$1b,d5
		beq.w	.HideWindow

		bclr	#5,d5
		lea	VanillaKeyTabelle(pc),a1
.TesteTasten:	moveq	#0,d0
		move.b	(a1)+,d1
		beq.w	.Return
		move.b	(a1)+,d0
		bne.s	.StandardKuerzel
		move.l	d1,d0
		bsr	GetLocaleString
		move.l	d0,a0
		moveq	#0,d4
		move.b	(a0),d0
.StandardKuerzel:moveq	#0,d4
		move.b	(a1)+,d4
		bclr	#5,d0
		cmp.b	d0,d5
		bne.w	.TesteTasten
		move.l	d4,d0
		moveq	#0,d2
		bsr	JumpTo
		bra.w	.Return


.TestCloseWindow:cmp.l	#CloseWindow,d7
		bne	.Return

.HideWindow:	lea	Helpnode_Hide(pc),a0
		bsr	SendHelp
		beq.w	.Return


		moveq	#EPENr_Hide,d0
		bsr	JumpTo
		if	Debugger!Executable
		bra.s	.Return
		endc

		ifeq	Executable
		bsr	SaveListBeforeQuitFirst
		endc

		moveq	#EPENr_Quit,d0
		bsr	JumpTo

		moveq	#EPNr_Engine,d0
		ifeq	executable+debugger
		bra.w	.Return
		else
		bra.w	.Return2
		endc


.Return:	moveq	#0,d0
.Return2:	tst.l	d0
		rts




*-----------------------------------------------------------------------------*
* Input: a4=WS_Windowstruct
*	 a3=MP_Struct !!!!!!!!!!!!!!!!!!!
AG_GetMsg:	lea	Puffer,a5
		*move.l	WindowPort(a5),d0
		*beq.w	.Return
		*move.l	d0,a0
		*move.l	GadBase(a5),a6
		*jsr	_LVOGT_getimsg(a6)
		*tst.l	d0
		*beq	.Return
		*move.l	d0,a1
		move.l	im_class(a1),d7
		moveq	#0,d5
		move.l	IM_Seconds(a1),CurrentSeconds(a5)
		move.l	IM_Micros(a1),CurrentMicros(a5)
		move.w	im_code(a1),d5 		<- Fr Tastatur / Selnummer Listview
		move.l	im_Iaddress(a1),d6 	<- Fr Gadgetabfrage
		move.l	im_seconds(a1),d2	<- fr Doppelclick
		move.l	im_micros(a1),d3	<- auch f. Doppelclick
		move.w	im_Qualifier(a1),Qualifier(a5)
		jsr	_LVOGT_ReplyIMsg(a6)

	*---------------- MSG auswerten -------------*
		cmp.l	#IDCMP_Changewindow,d7	;Refresh
		bne.s	.TestNewSize
		move.l	WS_Winhandle(a4),a0
		move	WS_OffY(A4),d0
		cmp	wd_height(a0),d0
		bne.s	.setposun
		move.w	wd_leftedge(a0),WS_ZoomPosX(a4)
		move.w	wd_topedge(a0),WS_ZoomPosY(a4)
		st	WS_ZoomState(a4)
		bra.w	.Return
.Setposun:	move.w	wd_leftedge(a0),WS_WinPosX(a4)
		move.w	wd_topedge(a0),WS_WinPosY(a4)
		move.w	wd_Width(a0),WS_WinWidth(a4)
		move.w	wd_Height(a0),WS_WinHeight(a4)
		sf	WS_ZoomState(a4)
		bra.w	.Return


.TestNewSize:	cmp.l	#NewSize,d7
		bne.s	.TestRefreshWindow

		move.l	WS_Winhandle(a4),a0
		move	WS_OffY(A4),d0
		cmp	WD_Height(a0),d0
		beq.w	.Return
	*move.w	wd_width(a0),d0
	*cmp.w	WS_WinWidth(a4),d0
	*bne.s	.NewSizeReal
	*move.w	wd_height(a0),d0
	*cmp.w	WS_WinHeight(a4),d0
	*beq.w	.Return
.NewSizeReal:
		move.w	wd_Width(a0),WS_WinWidth(a4)
		move.w	wd_Height(a0),WS_WinHeight(a4)
	*	bsr	AG_ResizeWindow
		bra.w	.Return

.TestRefreshWindow:

		cmp.l	#Refreshwindow,d7	;Refresh
		bne.s	.TestGadgetUp
		bsr	AG_ResizeWindow
		bra.w	.Return




.TestGadgetUp:	cmp.l	#Gadgetup,d7
		bne.w	.TestMenu
		move.l	d6,a1
		move.w	GG_Gadgetid(a1),d0	;Nr des Gadgets
		bsr	JumpTo
		bra.w	.Return


.MenuLoop:	move.l	OldMenuAdr(a5),a1
		move.w	MI_NextSelect(A1),d5
		bra.s	.MenuNext
.TestMenu:	cmp.l	#MenuPick,d7
		bne.w	.TestRawKey
.MenuNext:	move.w	d5,d0
		cmp.w	#menunull,d0
		beq	.Return
		move.l	WS_MenuAdr(a4),a0
		move.l	IntBase(a5),a6
		jsr	_LVOItemAddress(a6)
		move.l	d0,a1
		tst.l	d0
		beq	.Return
		move.l	d0,OldMenuAdr(a5)

		move.l	WS_Menutabelle(a4),d0
		beq.w	.Return
		move.l	d0,a0
.NextItem:	move.w	(a0)+,d1
		beq.w	.Return
		move.w	(a0)+,d0
		cmp.w	d5,d1
		bne.s	.NextItem
.JumpToNow:	moveq	#0,d2		;d5 mit durchschleifen fr Show by
		sub.l	a2,a2
		bsr	JumpTo
		bra.w	.Return




.TestRawkey:	cmp.l	#rawkey,d7
		bne	.TestVanillaKey
		
		move.l	WS_RawKeytabelle(a4),d0
		beq.w	.Return
		move.l	d0,a0

		move.w	Qualifier(a5),d2
		moveq	#3,d3
		btst	#3,d2
		bne.s	.MenuQOk
		moveq	#2,d3
		btst	#0,d2
		bne.s	.MenuQOk
		btst	#1,d2
		bne.s	.MenuQOk
		moveq	#1,d3
.MenuQOk:	moveq	#0,d2
		move.b	(a0)+,d0
		move.b	(a0)+,d1
		move.b	(a0)+,d2
		tst.b	d0
		beq.w	.Return
		cmp.b	d0,d3
		bne.s	.MenuQOk
		cmp.b	d1,d5
		bne.s	.MenuQOk
		move.l	d2,d0
		cmp.w	#-1,d0
		beq.s	.ToggleHelpMode
		bsr	JumpTo
		bra.w	.Return


*	* 3=Control 2=Shift 1=normal *
*RawKeyTabelle:	dc.b	3,$4c,0			;ViewTop
*		dc.b	3,$4d,0			;ViewBotom
*		dc.b	2,$4c,0			;PageUp
*		dc.b	2,$4d,0			;PageDown
*		dc.b	0,$4c,0			;Up
*		dc.b	0,$4d,0			;Down
*		dc.b	0,$45,0			;ESC
*		dc.b	0,$5f,-1		;HelpModus
*		dc.b	0

.ToggleHelpMode:moveq	#EPNr_Help,d3
		moveq	#-1,d0				;Toggle
		moveq	#0,d1
		bsr	SendMess
		bsr	ErlaubeGadgets
		bra.w	.Return

.TestVanillaKey:cmp.l	#vanillakey,d7
		bne	.TestCloseWindow

		*cmp.b	#13,d5				;Tab
		*beq.s	.ToggleZustand
		*cmp.b	#32,d5				;Leertaste
		*beq.s	.ToggleZustand
		cmp.b	#$1b,d5
		beq.w	.HideWindow

		bclr	#5,d5

		move.l	WS_VanillaKeyTabelle(a4),d0
		beq.s	.Return
		move.l	d0,a1
.TesteTasten:	moveq	#0,d0
		move.b	(a1)+,d1
		beq.w	.Return
		move.b	(a1)+,d0
		bne.s	.StandardKuerzel
		move.l	d1,d0
		bsr	GetLocaleString
		move.l	d0,a0
		moveq	#0,d4
		move.b	(a0),d0
.StandardKuerzel:moveq	#0,d4
		move.b	(a1)+,d4
		bclr	#5,d0
		cmp.b	d0,d5
		bne.w	.TesteTasten
		move.l	d4,d0
		bsr	JumpTo
		bra.w	.Return


.TestCloseWindow:cmp.l	#CloseWindow,d7
		bne	.Return

.HideWindow:	lea	AG_CloseWindow(pc),a0
		move.l	WS_CLoseWindow(a4),d0
		beq.s	.JumpNormal
		move.l	d0,a0
.JumpNormal	jsr	(a0)


.Return:	moveq	#0,d0
.Return2:	tst.l	d0
		rts




PJM	MACRO
	dc.w	\1-.JumpToTabelle,\2-.JumpToTabelle
	ENDM

*-----------------------------------------------------------------------------*
* d0=EPNr_Nummer
* d5=MenuItemNr
* a3=MP_Struct
* a4=WS_Struct
JumpTo:		movem.l	d1-a6,-(a7)
		lea	.JumpToTabelle(pc),a0
		cmp.w	#EPENr_LastNr,d0
		bhi.s	.Return
		add.w	d0,d0
		add.w	d0,d0

		move.l	EPBase(pc),a2
		btst	#EGPRF_Help-8,EPG_SomePrefs+2(a2)
		beq.s	.NoHelp

	if	Betarelease
		lea	Helpnode_Pysion(pc),a0
	else
		tst.w	-2(a0,d0.w)
		beq.s	.NoHelp
		move.w	-2(a0,d0.w),d0
		lea	(a0,d0.w),a0
	endc
		bsr	SendHelp
		bra.s	.Return

.NoHelp:	move.w	-4(a0,d0.w),d0
		lea	(a0,d0.w),a0
		jsr	(a0)
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.JumpToTabelle:
.EPENr_ModulesList	PJM	ListView,.JumpToTabelle
.EPENr_Add		PJM	AddEntries,HelpNode_Add
.EPENr_Up		PJM	Up,HelpNode_Up
.EPENr_Top		PJM	Top,HelpNode_Top
.EPENr_ModulesPrefs	PJM	M_ModulesPrefs,HelpNode_ModulesPrefs
.EPENr_SaveList		PJM	SaveList,HelpNode_SaveList
.EPENr_Delete		PJM	DeleteEntry,HelpNode_Delete
.EPENr_Down		PJM	Down,HelpNode_Down
.EPENr_Botom		PJM	Botom,HelpNode_Botom
.EPENr_ClearModulesPrefs PJM	M_ClearPrefs,HelpNode_ClrPrefs
.EPENr_Execute		PJM	Execute,HelpNode_Execute
.EPENr_New		PJM	MakeNewList,HelpNode_New
.EPENr_InsertList	PJM	InsertList,HelpNode_InsertList
.EPENr_SortByPath	PJM	SortByPath,HelpNode_SortByPath
.EPENr_SortByFName	PJM	SortByFName,HelpNode_SortByFName
.EPENr_SortByName	PJM	SortByName,HelpNode_SortByName
.EPENr_About		PJM	About,.JumpToTabelle
.EPENr_Hide		PJM	Hide,HelpNode_Hide
.EPENr_Quit		PJM	Quit,.JumpToTabelle
.EPENr_SaveConfig	PJM	SavePysionConfig,HelpNode_SaveConfig
.EPENr_LoadAtStart	PJM	LoadAtStart,HelpNode_LoadAtStart
.EPENr_HideAll		PJM	HideAll,HelpNode_HideAll
.EPENr_Synchron		PJM	Synchron,HelpNode_Synchron
.EPENr_BackPic		PJM	BackPic,HelpNode_BackPic
.EPENr_SelectBackPic	PJM	SelectBackPic,HelpNode_SelectPackPic
.EPENr_ViewUp		PJM	ViewUp,.JumpToTabelle
.EPENr_ViewDown		PJM	ViewDown,.JumpToTabelle
.EPENr_ViewPageUp	PJM	ViewPageUp,.JumpToTabelle
.EPENr_ViewPageDown	PJM	ViewPageDown,.JumpToTabelle
.EPENr_ViewTop		PJM	ViewTop,.JumpToTabelle
.EPENr_ViewBotom	PJM	ViewBotom,.JumpToTabelle
.EPENr_PlayModule	PJM	PlayModule,HelpNode_PlayModule
.EPENr_LoadList		PJM	LoadList,HelpNode_LoadList
.EPENr_Gruppenliste	PJM	G_Gruppenliste,HelpNode_Gruppenliste
.EPENr_Autorliste	PJM	A_Autorliste,HelpNode_Autorliste

.EPENr_ShowbyName	PJM	ShowByName,HelpNode_ShowbyName
.EPENr_ShowbyFName	PJM	ShowByFName,HelpNode_ShowbyName
.EPENr_ShowbyPath	PJM	ShowByPath,HelpNode_ShowByPath
.EPENr_AutoLearnAuthors	PJM	AutoLearnAuthors,HelpNode_ShowByPath
.EPENr_FindDouble	PJM	FindDouble,HelpNode_FindDouble
.EPENr_Overwrite	PJM	Overwrite,HelpNode_Overwrite



		*--- Autorwindow ---*
.EPENrA_Autorlist	PJM	A_Listview,HelpNode_A_Listview
.EPENrA_Add		PJM	A_Add,HelpNode_Add
.EPENrA_Delete		PJM	A_Delete,HelpNode_Delete
.EPENrA_New		PJM	A_New,HelpNode_New
.EPENrA_Prefs		PJM	A_Prefs,HelpNode_ModulesPrefs
.EPENrA_ClrPrefs	PJM	A_ClearPrefs,HelpNode_ClrPrefs
.EPENrA_ViewUp		PJM	A_ViewUp,.JumpToTabelle
.EPENrA_ViewDown	PJM	A_ViewDown,.JumpToTabelle
.EPENrA_ViewPageUp	PJM	A_ViewPageUp,.JumpToTabelle
.EPENrA_ViewPageDown	PJM	A_ViewPageDown,.JumpToTabelle
.EPENrA_ViewTop		PJM	A_ViewTop,.JumpToTabelle
.EPENrA_ViewBotom	PJM	A_ViewBotom,.JumpToTabelle
.EPENrA_Close		PJM	A_Close,.JumpToTabelle


		*--- Gruppenwindow ---*
.EPENrG_Gruppenlist	PJM	G_Listview,HelpNode_G_Listview
.EPENrG_Add		PJM	G_Add,HelpNode_Add
.EPENrG_Delete		PJM	G_Delete,HelpNode_Delete
.EPENrG_New		PJM	G_New,HelpNode_New
.EPENrG_Prefs		PJM	G_Prefs,HelpNode_ModulesPrefs
.EPENrG_ClrPrefs	PJM	G_ClearPrefs,HelpNode_ClrPrefs
.EPENrG_ViewUp		PJM	G_ViewUp,.JumpToTabelle
.EPENrG_ViewDown	PJM	G_ViewDown,.JumpToTabelle
.EPENrG_ViewPageUp	PJM	G_ViewPageUp,.JumpToTabelle
.EPENrG_ViewPageDown	PJM	G_ViewPageDown,.JumpToTabelle
.EPENrG_ViewTop		PJM	G_ViewTop,.JumpToTabelle
.EPENrG_ViewBotom	PJM	G_ViewBotom,.JumpToTabelle
.EPENrG_Close		PJM	G_Close,.JumpToTabelle

		*--- Prefswindow ---*
.EPENrPE_Enginelist	PJM	PE_Listview,Helpnode_PE_Enginelist
.EPENrPE_Add		PJM	PE_Add,Helpnode_PE_Add
.EPENrPE_Delete		PJM	PE_Delete,Helpnode_PE_Delete
.EPENrPE_Clear		PJM	PE_Clear,Helpnode_PE_Clear

.EPENrPG_Gruppenlist	PJM	PG_Listview,Helpnode_PG_Gruppenlist
.EPENrPG_Add		PJM	PG_Add,Helpnode_PG_Add
.EPENrPG_Delete		PJM	PG_Delete,Helpnode_PG_Delete
.EPENrPG_Clear		PJM	PG_Clear,Helpnode_PG_Clear

.EPENrP_Filter		PJM	P_Filter,Helpnode_P_Filter
.EPENrP_FadeIn		PJM	P_FadeIn,Helpnode_P_FadeIn
.EPENrP_FadeOut		PJM	P_FadeOut,Helpnode_P_FadeOut
.EPENrP_Songend		PJM	P_Songend,Helpnode_P_Songend
.EPENrP_AutoSubSong	PJM	P_AutoSubSong,Helpnode_P_AutoSubSong
.EPENrP_RandomSong	PJM	P_RandomSong,Helpnode_P_RandomSong
.EPENrP_LoadBefore	PJM	P_LoadBefore,Helpnode_P_LoadBefore
.EPENrP_LoadFast	PJM	P_LoadFast,Helpnode_P_LoadFast
.EPENrP_ProgrammMode	PJM	P_ProgrammMode,Helpnode_P_ProgrammMode

.EPENrP_Volume		PJM	P_Volume,Helpnode_P_Volume
.EPENrP_StartSong	PJM	P_StartSong,Helpnode_P_StartSong
.EPENrP_Timeout		PJM	P_Timeout,Helpnode_P_Timeout	
.EPENrP_MinTimeout	PJM	P_MinTimeout,Helpnode_P_MinTimeout
.EPENrP_Passwort	PJM	P_Passwort,Helpnode_P_Passwort
.EPENrP_Songname	PJM	P_Songname,Helpnode_P_Songname
.EPENrP_Specialinfo	PJM	P_Specialinfo,Helpnode_P_Specialinfo
.EPENrP_Autor		PJM	P_Autor,Helpnode_P_Autor
.EPENrP_SelectAutor	PJM	P_SelectAutor,Helpnode_P_SelectAutor
.EPENrP_Player		PJM	P_Player,Helpnode_P_Player
.EPENrP_SelectPlayer	PJM	P_SelectPlayer,Helpnode_P_SelectPlayer


			ifne	(EPENr_LastNr-1)*4-(*-.JumpToTabelle)
			HUHU
			endc



*-----------------------------------------------------------------------------*
* Input: a3=MP_Struct
PG_Add:		bsr	OpenGruppenwindow
		moveq	#0,d0
		rts

P_SelectAutor:	bsr	OpenAutorwindow
		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
* Die Modulesprefs wird neu geschrieben!!!!
* Input: a3=MP_Struct
* Output:d0=Error oder NULL (z.B. bei Out of mem)
P_Autor:	moveq	#EPENrP_Autor,d0
		move.l	a3,a2
		lea	MP_Window(a3),a3
		bsr	GetGadgetAdr2
		bne.s	.Return
		move.l	gg_specialinfo(a0),a0
		move.l	(a0),d0
		beq.s	.Return
		move.l	d0,a0
		bsr	Berechstringsize
		beq.s	.Update
		lea	Autorlist+AGL_List(a5),a4
		bsr	AG_InsertItem
.Update:	move.l	a2,a3
		bsr	UpdateModulesPrefs
.Return:	rts

*-----------------------------------------------------------------------------*
* Die Modulesprefs wird neu geschrieben!!!!
* Input: a3=MP_Struct
* Output:d0=Error oder NULL (z.B. bei Out of mem)

		


P_Filter
P_FadeIn
P_FadeOut
P_Songend
P_AutoSubSong
P_RandomSong
P_LoadBefore
P_LoadFast
P_ProgrammMode
P_Volume
P_StartSong
P_Timeout
P_MinTimeout
P_Passwort
P_Songname
P_Specialinfo
P_Player
UpdateModulesPrefs:
		move.b	#1,ListeChanged(a5)
		movem.l	d1-a6,-(a7)
		move.l	a3,d1
		beq.w	.Return

		move.l	MP_MEStruct(a3),d1
		beq.w	.Return
		move.l	d1,a1

		lea	MPPrefsTabelle-MPTS_SizeOF(pc),a4
		clr.l	BNS_ModPrefs(a5)
		clr.l	BNS_Counter(a5)
		bsr	BerechNeededSize
		bne.s	.ModPrefs
		bsr	FreeModulesPrefs
		bra.s	.NoModPrefs

.ModPrefs:	addq.l	#PrefsSecurity,d0	;Abschlussbyte und 1 Reserve
		cmp.l	MPE_ModulesPrefsSize(a1),d0
		blo.s	.ModPrefsOk
		bsr	FreeModulesPrefs
		move.l	d0,d3
		bsr	AllocMem2
		move.l	d0,MPE_ModulesPrefs(a1)
		move.l	d3,MPE_ModulesPrefsSize(a1)
.ModPrefsOk:	move.l	MPE_ModulesPrefs(a1),a0
		move.l	MPE_ModulesPrefsSize(a1),d0
		clr.b	(a0)
		move.l	a0,BNS_ModPrefs(a5)
		move.l	d0,BNS_ModPrefsSize(a5)
		lea	MPPrefsTabelle-MPTS_SizeOF(pc),a4
		clr.l	BNS_Counter(a5)
		bsr	BerechNeededSize


		*--- Eigenschaften ---*
.NoModPrefs:	lea	MPEigenTabelle-MPTS_SizeOF(pc),a4
		clr.l	BNS_ModPrefs(a5)
		clr.l	BNS_Counter(a5)
		bsr	BerechNeededSize
		bne.s	.EigenPrefs
		bsr	FreeEigenPrefs
		bra.s	.NoEigenPrefs

.EigenPrefs:	addq.l	#PrefsSecurity,d0	;Abschlussbyte und 1 Reserve
		cmp.l	MPE_EigenschaftenSize(a1),d0
		blo.s	.ModEigenOk
		bsr	FreeEigenPrefs
		move.l	d0,d3
		bsr	AllocMem2
		move.l	d0,MPE_Eigenschaften(a1)
		move.l	d3,MPE_EigenschaftenSize(a1)
.ModEigenOk:	move.l	MPE_Eigenschaften(a1),a0
		move.l	MPE_EigenschaftenSize(a1),d0
		clr.b	(a0)
		move.l	a0,BNS_ModPrefs(a5)
		move.l	d0,BNS_ModPrefsSize(a5)
		clr.l	BNS_Counter(a5)
		lea	MPEigenTabelle-MPTS_SizeOF(pc),a4
		bsr	BerechNeededSize

.NoEigenPrefs:
.Return:
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a3=MP_Struct
* Output:d0=Size
BerechNeededSize:
		movem.l	d1-a6,-(a7)
		lea	-4(a7),a7
		move.l	a7,d6

		lea	MP_Window(a3),a3
.Next:		move.l	BNS_Counter(a5),d5
		lea	MPTS_SizeOF(a4),a4
		tst.w	MPTS_EPNr(a4)
		beq.w	.Return
		move.w	MPTS_EPPyNr(a4),d0
		beq.w	.Return
		bsr	GetGadgetadr2
		bne.s	.Next

		move.l	d6,a1
		clr.l	(a1)

		move.l	a0,-(a7)
		lea	InfoBlock(a5),a1
		moveq	#0,d0
		move.w	MPTS_EPNr(a4),d0
		bsr	Hexdez
		lea	InfoBlock(a5),a0
		bsr	AddToPuffer
		lea	Gleichzeichen(pc),a0
		bsr	AddToPuffer
		move.l	(a7)+,a0

		lea	MyTags(a5),a2
		move.w	MPTS_Flags(a4),d2
		btst	#MPF_Status,d2
		bne.s	.MPT_Status
		btst	#MPF_String,d2
		bne.s	.MPT_String
		btst	#MPF_Zahl,d2
		bne.s	.MPT_Zahl
		btst	#MPF_MultiArgs,d2
		bne.w	.MPT_MultiArgs
.KillNr:	move.l	d5,BNS_Counter(a5)
		move.l	BNS_ModPrefs(a5),d0
		beq.s	.Next
		move.l	d0,a0
		clr.b	(a0,d5.l)	
		bra.s	.Next

.MPT_Zahl:	cmp.w	#EPNr_ProgramMode,MPTS_EPNr(a4)
		beq.s	.MPT_Status

		move.l	gg_specialinfo(a0),a0
		move.l	28(a0),d0
		beq.w	.KillNr
		lea	InfoBlock(a5),a1
		bsr	Hexdez
		lea	InfoBlock(a5),a0
		bsr	AddToPuffer
		bra.w	.KommandoDone


.MPT_Status:	move.l	gg_specialinfo(a0),a0
		moveq	#0,d0
		move.w	28(a0),d0			0=not changed
		subq.l	#1,d0
		blt.w	.KillNr

*		cmp.w	#EPNr_ProgrammMode,MPTS_EPNr(a4)
*		beq.s	.ProgrammArgs
*		moveq	#0,d1
*		cmp.w	#1,
*		addq.l	#1,d6
*		move.l	d1,d0
*.ProgrammArgs:	
		lea	Infoblock(a5),a1
		bsr	Hexdez
		lea	Infoblock(a5),a0
		bsr	AddToPuffer
		bra.w	.KommandoDone

.MPT_String:	move.l	gg_specialinfo(a0),a0
		move.l	(a0),a0
		bsr	BerechStringSize
		beq.w	.KillNr

		move.l	a0,-(a7)
		lea	Hochkommazeichen(pc),a0
		bsr	AddToPuffer
		move.l	(a7)+,a0
		bsr	AddToPuffer
		lea	Hochkommazeichen(pc),a0
		bsr	AddToPuffer
		bra.w	.KommandoDone

.MPT_MultiArgs:	cmp.w	#EPNr_AscEngine,MPTS_EPNr(a4)
		beq.s	.EngineArgs
		move.l	a3,-(a7)
		lea	MP_GruppenList-MP_Window+AGL_List(a3),a3
		bra.s	.EngineStart

*	147='Moduleinfo'=0='Engineprefs';
.EngineArgs:	move.l	a3,-(a7)
		lea	MP_Enginelist-MP_Window+AGL_List(a3),a3
.EngineStart:	move.l	(a3),a3
		move.l	(a3),d0
		beq.w	.EngineKillNr

.EngineNext:	lea	HochKommaZeichen(pc),a0
		bsr	AddToPuffer

		move.l	AGS_Node+LN_Name(a3),a0
		bsr	AddToPuffer

		lea	HochKommaZeichen(pc),a0
		bsr	AddToPuffer

		cmp.w	#EPNr_AscEngine,MPTS_EPNr(a4)
		bne.s	.EngineNoPrefs

		lea	GleichZeichen(pc),a0
		bsr	AddToPuffer

		move.l	AGS_Flags(a3),d0
		lea	InfoBlock(a5),a1
		bsr	Hexdez
		lea	InfoBlock(a5),a0
		bsr	AddToPuffer

		move.l	AGS_MEStruct+MPE_ModulesPrefs(a3),a0
		bsr	BerechStringSize
		beq.s	.EngineNoPrefs
		move.l	a0,-(a7)
		lea	Hochkommazeichen(pc),a0
		bsr	AddToPuffer
		move.l	(a7)+,a0
		bsr	AddToPuffer
		lea	Hochkommazeichen(pc),a0
		bsr	AddToPuffer

.EngineNoPrefs:	move.l	(a3),a3
		tst.l	(a3)
		beq.s	.KommandoDone2
		lea	Semikolonzeichen(pc),a0
		bsr	AddToPuffer		;Semikolon
		bra.s	.EngineNext

.EngineKillNr:	move.l	(a7)+,a3
		bra.w	.KillNr

.KommandoDone2:	move.l	(a7)+,a3
.KommandoDone:	lea	Kommazeichen(pc),a0
		bsr	AddToPuffer		*Komma
		bra.w	.Next



.Return:	*-- Letzte komma killen --*
		move.l	BNS_ModPrefs(a5),d0
		beq.s	.NoKomma
		move.l	d0,a0
		move.l	BNS_Counter(a5),d0
		cmp.b	#",",-1(a0,d0.l)
		bne.s	.NoKomma
		clr.b	-1(a0,d0.l)
		subq.l	#1,BNS_Counter(a5)

.NoKomma:	move.l	BNS_Counter(a5),d0
		lea	4(a7),a7
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Stringadr
* Output:d7=Size added
AddToPuffer:	movem.l	d0/d1/a0/a1,-(a7)
		move.l	BNS_ModPrefs(a5),d0
		beq.s	.NurAdd
		move.l	d0,a1
		move.l	BNS_Counter(a5),d0
		move.l	BNS_ModPrefsSize(a5),d1
		cmp.l	d1,d0
		bhs.s	.NurAdd
		add.l	d0,a1
		sub.l	d0,d1
		subq.l	#PrefsSecurity+1,d1
		bsr	StringCopy
		sub.l	BNS_ModPrefs(a5),a1
		move.l	a1,BNS_Counter(a5)
		bra.s	.Return

.NurAdd:	bsr	BerechStringSize
		add.l	d0,BNS_Counter(a5)
.Return:	movem.l	(a7)+,d0/d1/a0/a1
		rts




*-----------------------------------------------------------------------------*
P_SelectPlayer:move.l	#300+108,d0
		move.l	#$10001,d1
		EB
		jsr	_LVOAllocMem(a6)
		tst.l	d0
		beq.w	.Return
		move.l	d0,a2


	if	Executable
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_EagleplayerDirArrayPtr(a4),d1
		beq.s	.NoPlayerDir
	else
		move.l	#EPDir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoEPPlayerDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
.NoEPPlayerDir:	move.l	d1,-(a7)

	if	Executable
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_PlayerDirArrayPtr(a4),d1
		beq.s	.NoPlayerDir
	else
		move.l	#Playerdir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoPlayerDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

		*--- Playerdir setzen ---*
.NoPlayerDir:	move.l	d1,-(a7)

		*d0=LocaleNr fr Title des Requesters
		*a0=Dir
		*a1=Filename
		moveq	#LENr_SelectPlayer,d0
		move.l	a2,a0
		lea	300(a2),a1
		bsr	DT_FileRequest
		beq.s	.FreePlayerDir
		lea	300(a2),a0
		move.l	a3,a4
		lea	MP_Window(a3),a3
		moveq	#EPENrP_Player,d0
		bsr	AG_SetzeStringGadget
		move.l	a4,a3
		bsr	UpdateModulesPrefs

.FreePlayerDir:	move.l	(a7)+,d1
		tst.l	d1
		beq.s	.FreeEPPlayerDir
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)

.FreeEPPlayerDir:move.l	(a7)+,d1
		tst.l	d1
		beq.s	.NoEPPlayerDir2
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)

.NoEPPlayerDir2:move.l	a2,a1
		move.l	#300+108,d0
		EB
		jsr	_LVOFreeMem(a6)

.Return		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
PE_Add:		move.l	#300+108,d0
		move.l	#$10001,d1
		EB
		jsr	_LVOAllocMem(a6)
		tst.l	d0
		beq.w	.Return
		move.l	d0,a2

	if	Executable
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_EagleplayerDirArrayPtr(a4),d1
		beq.s	.NoPlayerDir
	else
		move.l	#EPDir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoPlayerDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoPlayerDir:	move.l	d1,-(a7)

	if	Executable
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_EngineDirArrayPtr(a4),d1
		beq.s	.NoEngineDir
	else
		move.l	#Enginedir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoEngineDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

		*--- Enginedir setzen ---*
.NoEngineDir:	move.l	d1,-(a7)

		*d0=LocaleNr fr Title des Requesters
		*a0=Dir
		*a1=Filename
		moveq	#LENr_SelectEngine,d0
		move.l	a2,a0
		lea	300(a2),a1
		bsr	DT_FileRequest
		beq.s	.FreeEngineDir
		lea	300(a2),a0
		lea	MP_Enginelist(a3),a4
		bsr	RemoveAGLlist
		moveq	#0,d1
		bsr	InsertMPEntry
		bsr	ReAddAGLlist
		bsr	UpdateModulesPrefs
.FreeEngineDir:	move.l	(a7)+,d1
		tst.l	d1
		beq.s	.FreePlayerDir
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)

.FreePlayerDir:	move.l	(a7)+,d1
		tst.l	d1
		beq.s	.NoEngineDir2
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)

.NoEngineDir2:	move.l	a2,a1
		move.l	#300+108,d0
		EB
		jsr	_LVOFreeMem(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=String
*	 a4=Liste
* Output:d0/a0=Nodeadr
*-----------------------------------------------------------------------------*
InsertMPEntry:	move.l	d1,-(a7)
		bsr	InsertItInList
		beq.s	.EngineError
		move.l	d1,AGS_Flags(a0)
.EngineError:	move.l	(a7)+,d1
		tst.l	d0
		rts









		*--- Autorwindow ---*
A_Close:	lea	AutorWindowStruct(a5),a4
		bsr	AG_CloseWindow
		rts

		*--- Gruppenwindow ---*
G_Close:	lea	GruppenWindowStruct(a5),a4
		bsr	AG_CloseWindow
		rts

*-----------------------------------------------------------------------------*
A_Add:		lea	Autorlist(a5),a4
		moveq	#LENr_AddAutor,d0
		bra.s	AG_Add

G_Add:		lea	Gruppenlist(a5),a4
		moveq	#LENr_AddGruppe,d0

		*-- StringGadget aufrufen --*
AG_Add:		bsr	GetLocaleString
		move.l	d0,a1

		lea	StringPuffer(a5),a0	;Puffer fr Text
		clr.b	(a0)
		moveq	#EPTRB_String,d0	;Text
		moveq	#0,d1			;MinValue
		moveq	#32,d2			;MaxLength
		sub.l	a2,a2			;Args
		move.l	a4,-(a7)
		move.l	AGL_Windowstruct(a4),a4
		bsr	StringGadget
		move.l	(a7)+,a4
		tst.l	d0
		bne.w	.Error

		*--- Nun in Liste einfgen ---*
		lea	StringPuffer(a5),a0	;Puffer fr Text
		bsr	AG_InsertItem

.Error:		rts

*-----------------------------------------------------------------------------*
* Input: a0=Stringpuffer
*	 a4=AGL_List
*-----------------------------------------------------------------------------*
AG_InsertItem:	bsr	RemoveAGLlist
		bsr	InsertItInList
		*beq.s	.Error
		bsr	ReAddAGLlist
		rts

*------------ verndere die Einstellungen des Listviewgadgets ---------------*
G_ViewTop:	lea	Gruppenlist(a5),a4
		bra.s	AG_ViewTop
A_ViewTop:	lea	Autorlist(a5),a4
AG_ViewTop:	moveq	#1,d5
		bra.w	AG_SetListView

G_ViewBotom:	lea	Gruppenlist(a5),a4
		bra.s	AG_ViewBotom
A_ViewBotom:	lea	Autorlist(a5),a4
AG_ViewBotom:	move.l	AGL_MaxEntries(a4),d5
		bra.s	AG_SetListView

G_ViewUp:	lea	Gruppenlist(a5),a4
		bra.s	AG_ViewUp
A_ViewUp:	lea	Autorlist(a5),a4
AG_ViewUp:	moveq	#0,d5
		move.l	AGL_SelectedEntry(a4),d5
		cmp.l	#1,d5
		ble.w	Return
		subq.l	#1,d5
		bra.s	AG_SetListView

G_ViewDown:	lea	Gruppenlist(a5),a4
		bra.s	AG_ViewDown
A_ViewDown:	lea	Autorlist(a5),a4
AG_ViewDown:	moveq	#0,d5
		move.l	AGL_SelectedEntry(a4),d5
		addq.l	#1,d5
		cmp.l	AGL_MaxEntries(a4),d5
		bhi.w	Return
		bra.s	AG_SetListView

G_ViewPageUp:	lea	Gruppenlist(a5),a4
		bra.s	AG_ViewPageUp
A_ViewPageUp:	lea	Autorlist(a5),a4
AG_ViewPageUp:	bsr.w	BerechWSGadAnz
		moveq	#0,d5
		move.l	AGL_SelectedEntry(a4),d5
		sub.w	d0,d5
		bhi.s	.IO
		moveq	#1,d5
.Io:		bra.s	AG_SetListView

G_ViewPageDown:	lea	Gruppenlist(a5),a4
		bra.s	AG_ViewPageDown
A_ViewPageDown:	lea	Autorlist(a5),a4
AG_ViewPageDown:bsr.w	BerechWSGadAnz
		moveq	#0,d5
		move.l	AGL_SelectedEntry(a4),d5
		add.w	d0,d5
		cmp.l	AGL_MaxEntries(a4),d5
		blo.s	.IO
		move.l	AGL_MaxEntries(a4),d5
.Io:		*bra.w	AG_SetListView


AG_SetListView:	move.l	d5,d0

*-----------------------------------------------------------------------------*
* Es wurde ein neuer Eintrag angewhlt.
* Input: d0=Neue Nummer (des angewhlten Labels)
*	 a4=AGL_Struct
AG_SetEntry:	movem.l	d1-a6,-(a7)
		move.l	AGL_WindowStruct(a4),d1
		beq.s	.Return
		move.l	d1,a3
		tst.l	WS_WinHandle(a3)
		beq.s	.Return

		cmp.l	AGL_SelectedEntry(a4),d0
		beq.s	.Return
		move.l	d0,AGL_SelectedEntry(a4)


		*--- Gadgets sperren oder erlauben ---*
		*--- Anderen Anzeigelistviews fllen ---*
		subq.l	#1,d0
		lea	MyTags(a5),a2
		move.l	#GTLV_Selected,(a2)+
		move.l	d0,(a2)+
		move.l	#GTLV_MakeVisible,(a2)+
		move.l	d0,(a2)+
		clr.l	(a2)
		move.w	AGL_GadgetID(a4),d0
		bsr	GetGadgetAdr2

		move.l	WS_Winhandle(a3),a1
		lea	MyTags(a5),a3
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		bsr	ErlaubeGadgets

.Return:	movem.l	(a7)+,d1-a6
		rts

*----------------------- Listview-Gadget wurde gedrckt ----------------------*
* Input: a4=AGL_Struct (Liste)
PE_Listview:	lea	MP_Enginelist(a3),a4
		bra.s	AG_ListView
PG_Listview:	lea	MP_Gruppenlist(a3),a4
		bra.s	AG_ListView

G_Listview:	lea	Gruppenlist(a5),a4
		bra.s	AG_ListView
A_Listview:	lea	Autorlist(a5),a4
AG_Listview:	move.l	StartSeconds(a5),d0
		move.l	StartMicros(a5),d1
		move.l	CurrentSeconds(a5),d2
		move.l	CurrentMicros(a5),d3
		move.l	d2,StartSeconds(a5)
		move.l	d3,StartMicros(a5)
		move.l	AGL_SelectedEntry(a4),d4
		addq.l	#1,d5
		*move.l	d5,AGL_SelectedEntry(a4)


		*--- Wenn Eagleplayer im Helpmode ---*
		*--- Kommando an EP schicken fr  ---*
		*--- Helpnode                     ---*
		cmp.w	d4,d5
		bne.w	.EinfacherKlick
		move.l	IntBase(a5),a6
		jsr	_LVODoubleClick(a6)

	*------ Listviews & Stringgadgets refreshen ------*
		cmp.l	#1,d0			--> Einfacher Klick
		bne.w	.Return
		clr.l	StartSeconds(a5)
		clr.l	StartMicros(a5)

		move.l	AGL_Doppelklick(a4),d0
		beq.s	.Return
		move.l	d0,a0
		jsr	(a0)
		bra.s	.Return

.EinfacherKlick:move.l	d5,d0			--> Nummer
		bsr.w	AG_SetEntry
.Return:	rts

*-----------------------------------------------------------------------------*
PE_Delete:	lea	MP_EngineList(a3),a4
		bra.s	AG_Delete

*-----------------------------------------------------------------------------*
PG_Delete:	lea	MP_GruppenList(a3),a4
		bra.s	AG_Delete

A_Delete:	lea	Autorlist(a5),a4
		bra.s	AG_Delete
G_Delete:	lea	Gruppenlist(a5),a4
AG_Delete:	bsr	RemoveAGLlist

		*-- Reinhpfen und schauen, ob lschen erlaubt ist --*
		move.l	AGL_DeleteEntry(a4),d0
		beq.s	.NoJump
		move.l	d0,a0
		movem.l	d1-a6,-(a7)
		jsr	(a0)
		movem.l	(a7)+,d1-a6
		bne.s	.NoDelete
.NoJump:	bsr	DeleteAGEntry
.NoDelete:	bsr	ReAddAGLList
		rts

PE_Clear:	lea	MP_EngineList(a3),a4
		bra.s	AGL_NewNow
PG_Clear:	lea	MP_GruppenList(a3),a4
		bra.s	AGL_NewNow

*-----------------------------------------------------------------------------*
A_New:		lea	Autorlist(a5),a4
		bra.s	AG_New
G_New:		lea	Gruppenlist(a5),a4

		*--- Wirklich lschen ? ---*
AG_New:		tst.b	AGL_ListeChanged(a4)
		beq.s	AGL_NewNow
		moveq	#LENr_RealyNew,d0
		moveq	#LENr_ReallyGadgets,d1
		bsr	TextRequest
		tst.l	d0
		beq.s	.Return
		cmp.l	#2,d0
		bne.s	AGL_NewNow
		bsr	SaveList
		bne.w	.Return
.Return		moveq	#0,d0
		rts


AGL_NewNow:	bsr	RemoveAGLlist

		*-- Reinhpfen und schauen, ob lschen erlaubt ist --*
		move.l	AGL_DeleteEntry(a4),d0
		beq.s	.NoJump
		move.l	d0,a0
		movem.l	d1-a6,-(a7)
		jsr	(a0)
		movem.l	(a7)+,d1-a6
		bne.s	.NoDelete
.NoJump:	bsr	DeleteAGList
.NoDelete:	bsr	ReAddAGLList
		rts

*-----------------------------------------------------------------------------*
* Doppelklick auf Eintrag in Liste der Gruppen im Moduleinfo
MPG_NimmGruppe:	bsr	GetSelectedAGStruct
		bne.s	.Return
		move.l	AGS_Node+LN_Name(a0),a0

		*-- Diesen Eintrag in Gruppenliste suchen --*
		lea	Gruppenlist(a5),a4
		moveq	#0,d4
.Next:		addq.l	#1,d4
		move.l	(a4),a4
		tst.l	(a4)
		beq.s	.Return
		move.l	LN_Name(a4),a1
		bsr	Strcmp
		bne.s	.next
		move.l	a4,a2

		lea	Gruppenlist(a5),a4
		moveq	#LENr_Gruppe,d0
		bsr	GetLocaleString
		move.l	d0,a0
		lea	InfoBlock(a5),a1
		move.w	#260-1,d1
		bsr	StringCopy
		move.l	a2,a0
		lea	AGS_MEStruct(a0),a2
		move.l	AGS_Node+LN_Name(a0),a0
		bsr	StringCopy
		
		moveq	#MPMNR_Gruppe,d1
		move.l	d4,d0			;Nummer
		lea	InfoBlock(a5),a0
		move.l	a2,a1
		bsr	P_OpenPrefsWindow
.Return:	rts


		

		bra.s	AG_Prefs
A_Prefs:	moveq	#MPMNR_Autor,d5
		moveq	#LENr_Autor,d0
		lea	Autorlist(a5),a4
		bra.s	AG_Prefs
G_Prefs:	moveq	#MPMNR_Gruppe,d5
		moveq	#LENr_Gruppe,d0
		lea	Gruppenlist(a5),a4

	*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	* ACHTUNG: Auch MPG_NimmGruppe ndern !!!
	*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
AG_Prefs:	bsr	GetLocaleString
		move.l	d0,a0
		lea	InfoBlock(a5),a1
		move.w	#260-1,d1
		bsr	StringCopy
		bsr	GetSelectedAGStruct
		bne.s	.Return
		lea	AGS_MEStruct(a0),a2
		move.l	AGS_Node+LN_Name(a0),a0
		bsr	StringCopy
		
		
		move.l	d5,d1
		move.l	AGL_SelectedEntry(a4),d0
		lea	InfoBlock(a5),a0
		move.l	a2,a1
		bsr	P_OpenPrefsWindow
.Return:	rts

*-----------------------------------------------------------------------------*
M_ModulesPrefs:	moveq	#LENr_Module,d0
		bsr	GetLocaleString
		move.l	d0,a0
		lea	InfoBlock(a5),a1
		move.w	#260-1,d1
		bsr	StringCopy
		bsr	GetSelectedStruct
		bne.s	.Return
		lea	PL_MEStruct(a0),a2
		move.l	PL_Node+LN_Name(a0),a0
		bsr	StringCopy
		
		move.l	SelectedEntry(a5),d0
		lea	InfoBlock(a5),a0
		move.l	a2,a1
		moveq	#MPMNR_Module,d1
		bsr	P_OpenPrefsWindow
.Return:	rts


*-----------------------------------------------------------------------------*
M_ClearPrefs:	bsr	GetSelectedStruct
		bne.s	.Return
		lea	PL_MEStruct(a0),a2
		move.l	SelectedEntry(a5),d0
		moveq	#MPMNR_Module,d1
		bsr	FindPrefsStruct
		bsr	ClearPrefs
.Return:	rts


G_ClearPrefs:	lea	Gruppenlist(a5),a4
		moveq	#MPMNR_Gruppe,d1
		bra.s	AG_ClearPrefs
A_ClearPrefs:	lea	Autorlist(a5),a4
		moveq	#MPMNR_Autor,d1
AG_ClearPrefs:	bsr	GetSelectedAGStruct
		bne.s	.Return
		lea	AGS_MEStruct(a0),a2
		move.l	AGL_SelectedEntry(a4),d0
		bsr	FindPrefsStruct
		bsr	ClearPrefs
.Return:	rts



*-----------------------------------------------------------------------------*
* Input: a3=MP_Struct oder NULL
*	 a2=MPE_Struct oder NULL
ClearPrefs:	move.l	a2,d0
		beq.s	.NoPrefs

		*-- Modulesprefs lschen --*
		move.l	MPE_ModulesPrefs(a2),d0
		beq.s	.NoModPrefs
		move.l	d0,a1
		move.l	MPE_ModulesPrefsSize(a2),d0
		beq.s	.NoModPrefs
		EB
		jsr	_LVOFreemem(a6)
.NoModPrefs:	clr.l	MPE_ModulesPrefs(a2)
		clr.l	MPE_ModulesPrefsSize(a2)

		*-- Moduleseigenschaften lschen --*
		move.l	MPE_Eigenschaften(a2),d0
		beq.s	.NoModEigen
		move.l	d0,a1
		move.l	MPE_EigenschaftenSize(a2),d0
		beq.s	.NoModEigen
		EB
		jsr	_LVOFreemem(a6)
.NoModEigen:	clr.l	MPE_Eigenschaften(a2)
		clr.l	MPE_EigenschaftenSize(a2)

		*-- Jetzt Window closen --*
.NoPrefs:	move.l	a3,d0
		beq.s	.Return
		bsr	P_ClosePrefswindow
		bne.w	.Return
.Return:	bsr	ErlaubeGadgets
		rts


*-----------------------------------------------------------------------------*
* Mal schauen, ob solch eine Structur schon existiert!
* Input: d0=ModuleNr
*	 d1=Type
* Output:d0=Error oder NULL
*	 a3=MP_Structur
*-----------------------------------------------------------------------------*
FindPrefsStruct:movem.l	d1-d7/a0-a2/a4-a6,-(a7)
		moveq	#EPR_ErrorInArguments,d7
		lea	FirstPrefsWindowStruct-MP_Next(a5),a2
.Next		move.l	MP_Next(a2),d3
		beq.s	.Return
		move.l	d3,a2
		cmp.w	MP_Type(a2),d1
		bne.s	.Next
		cmp.l	MP_ModuleNr(a2),d0
		bne.s	.Next
		moveq	#0,d7
.Return:	move.l	d7,d0
		move.l	d3,a3		
		movem.l	(a7)+,d1-d7/a0-a2/a4-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
ClosePrefsWindows:
		movem.l	d0-a6,-(a7)
		*-- Alle Prefswindows schlieen --*
		move.l	FirstPrefsWindowStruct(a5),d0
.NextPrefsWin:	tst.l	d0
		beq.s	.Return
		move.l	d0,a3
		move.l	(a3),d0
		bsr	P_ClosePrefsWindow
		bra.s	.NextPrefsWin
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Module/AutorGruppenNr (auch Autor und Gruppe)
*	 d1=Prefstype (Autor/Gruppe/Module)
*	 a0=Titletext
*	 a1=ModulesPrefsStruct
* Output:d0=MP_Struct oder NULL
P_OpenPrefsWindow:
		movem.l	d0-a6,-(a7)
		move.l	d0,d4
		move.l	a0,d6
		move.l	a1,a2

		bsr	FindPrefsStruct
		bne.s	.NichtOffen
		lea	MP_Window(a3),a4
		bra.w	.OpenWindow

*		*-- Testen, ob Fenster schon auf ist --*
*		lea	FirstPrefsWindowStruct-MP_Next(a5),a3
*.Next		move.l	MP_Next(a3),d3
*		beq.s	.NichtOffen
*		move.l	d3,a3
*		cmp.w	MP_Type(a3),d1
*		bne.s	.Next
*		cmp.l	MP_ModuleNr(a3),d0
*		bne.s	.Next
*		lea	MP_Window(a3),a4
*		bra.w	.OpenWindow		;ist schon da
*

		*-- Mem fr Structure besorgen --*
.NichtOffen:	move.l	#MP_SizeOf,d0
		bsr	AllocMem2
		beq.w	.Error
		move.l	d0,a3
		move.w	d1,MP_Type(a3)
		move.l	d4,MP_ModuleNr(a3)
		move.l	a2,MP_MEStruct(a3)

		move.w	Prefs_LastLeftEdge(a5),MP_Window+WS_WinPosX(a3)
		move.w	Prefs_LastTopEdge(a5),MP_Window+WS_WinPosY(a3)
		move.w	Prefs_LastWidth(a5),MP_Window+WS_WinWidth(a3)
		move.w	Prefs_LastHeight(a5),MP_Window+WS_WinHeight(a3)

		*-- Mem fr Titlepuffer besorgen --*
		moveq	#LENr_ModulesPrefsFor,d0
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	BerechStringSize
		move.l	d0,d1
		move.l	d6,a0
		bsr	BerechStringSize
		add.l	d1,d0
		addq.l	#4,d0
		move.l	d0,d3
		bsr	AllocMem2
		move.l	d0,MP_Window+WS_WindowTitle(a3)
		beq.w	.FreeStruct
		move.l	d3,MP_Window+WS_WindowTitleSize(a3)
		move.l	d0,a1

		moveq	#LENr_ModulesPrefsFor,d0
		bsr	GetLocaleString
		move.l	d0,a0
		move.l	d3,d1
		subq.l	#5,d1
		bsr	StringCopy
		move.l	d6,a0
		bsr	StringCopy

		bsr	InitPrefsWindow

		*--- Tags vorbereiten ---*
		move.l	#Tag_Ignore,d0
		lea	TD_G_Listview(pc),a0
		move.l	d0,(a0)
		move.l	d0,TD_G_Add-TD_G_Listview(a0)
		move.l	d0,TD_G_Delete-TD_G_Listview(a0)
		move.l	d0,TD_G_Clear-TD_G_Listview(a0)
		move.l	d0,TD_Autor-TD_G_Listview(a0)
		move.l	d0,TD_SelectAutor-TD_G_Listview(a0)
		cmp.w	#MPMNR_Autor,MP_Type(a3)
		bne.s	.Win_NoAutor
		move.l	#GA_Disabled,TD_Autor-TD_G_Listview(a0)
		move.l	#GA_Disabled,TD_SelectAutor-TD_G_Listview(a0)
		move.l	#GA_Disabled,TD_G_Listview-TD_G_Listview(a0)
		move.l	#GA_Disabled,TD_G_Add-TD_G_Listview(a0)
		move.l	#GA_Disabled,TD_G_Delete-TD_G_Listview(a0)
		move.l	#GA_Disabled,TD_G_Clear-TD_G_Listview(a0)
.Win_NoAutor:	cmp.w	#MPMNR_Gruppe,MP_Type(a3)
		bne.s	.Win_NoGruppe
		move.l	#GA_Disabled,TD_G_Listview-TD_G_Listview(a0)
		move.l	#GA_Disabled,TD_G_Add-TD_G_Listview(a0)
		move.l	#GA_Disabled,TD_G_Delete-TD_G_Listview(a0)
		move.l	#GA_Disabled,TD_G_Clear-TD_G_Listview(a0)

		*------ Window ffnen ------*
.Win_NoGruppe:	lea	MP_Window(a3),a4
		move.w	WS_WinPosX(a4),d0
		move.l	d0,-(a7)
		move.w	WS_WinPosY(a4),d0
		move.l	d0,-(a7)
		move.w	WS_WinWidth(a4),d0
		move.l	d0,-(a7)
		move.w	WS_WinHeight(a4),d0
		move.l	d0,-(a7)
		move.l	WS_WindowTitle(a4),d0
		move.l	d0,-(a7)

		bsr	ClrWinStruct

		move.l	(a7)+,d0
		move.l	d0,WS_WindowTitle(a4)
		move.l	(a7)+,d0
		move.w	d0,WS_WinHeight(a4)
		move.w	d0,WS_DefHeight(a4)
		move.l	(a7)+,d0
		move.w	d0,WS_DefWidth(a4)
		move.w	d0,WS_WinWidth(a4)
		move.l	(a7)+,d0
		move.w	d0,WS_WinPosY(a4)
		move.l	(a7)+,d0
		move.w	d0,WS_WinPosX(a4)

		moveq	#LENr_Screentitle,d0
		bsr	GetLocaleString
		move.l	d0,WS_Screentitle(a4)

		*--- Def Routinen setzen ---*
		lea	P_BerechMinSize(pc),a0
		move.l	a0,WS_BerechMinWindowSize(a4)
		lea	P_InitGadgets(pc),a0
		move.l	a0,WS_InitGadgets(a4)
		lea	P_AddGadgets(pc),a0
		move.l	a0,WS_AddGadgets(a4)
		lea	P_FreeGadgets(pc),a0
		move.l	a0,WS_FreeGadgets(a4)
		lea	Prefs_Gadgets(pc),a0
		move.l	a0,WS_Gadgets(a4)
		lea	P_Gadgettypes(pc),a0
		move.l	a0,WS_Gadgettypes(a4)
		lea	P_GadgetTags(pc),a0
		move.l	a0,WS_GadgetTags(a4)
		lea	P_RawKeyTabelle(pc),a0
		move.l	a0,WS_RawKeyTabelle(a4)
		lea	P_VanillaKeyTabelle(pc),a0
		move.l	a0,WS_VanillaKeyTabelle(a4)
		lea	MenuTabelle(pc),a0
		move.l	a0,WS_MenuTabelle(a4)
		lea	P_ClosePrefsWindow(pc),a0
		move.l	a0,WS_CloseWindow(a4)
		lea	P_CreateGadget(pc),a0
		move.l	a0,WS_CreateGadget(a4)


		*--- Positionen setzen ---*
		moveq	#-1,d0
		move.l	#PrefsGadgetAnz,WS_GadgetAnz(a4)
		cmp.w	WS_WinPosX(a4),d0
		bne.s	.XOk
		move.w	WinPosx(a5),WS_WinPosX(a4)
.XOk:		cmp.w	WS_WinPosY(a4),d0
		bne.s	.YOk
		move.w	WinPosY(a5),WS_WinPosY(a4)
.YOk:		cmp.w	WS_WinWidth(a4),d0
		bne.s	.WidthOk
		move.w	WinWidth(a5),WS_WinWidth(a4)
		move.w	WinWidth(a5),WS_DefWidth(a4)
.WidthOk:	cmp.w	WS_WinHeight(a4),d0
		bne.s	.HeightOk
		move.w	WinHeight(a5),WS_Winheight(a4)
		move.w	WinHeight(a5),WS_Defheight(a4)
.HeightOk:

.OpenWindow:	bsr.w	AG_OpenWin
		tst.l	d0
		beq.s	.CloseWindow

		move.l	a3,d0
.Return:	movem.l	(a7)+,d0-a6
		tst.l	d0
		rts

		*--- Es ist ein fehler aufgetreten ---*
.CloseWindow:	*lea	MP_Window(a3),a4
		*bsr	AG_CloseWindow
.FreeTitlePuffer:*bsr	MP_FreeTitlePuffer
.FreeStruct:	*bsr	MP_FreeStruct
.Error:	
		bsr	P_ClosePrefsWindow
		moveq	#0,d0
		bra.s	.Return

*-----------------------------------------------------------------------------*
* Input: a3=MP_Struct
InitPrefsWindow:movem.l	d0-a6,-(a7)
		move.l	#MP_Sizeof,MP_StructSize(a3)

		*--- Window einfgen ---*
		lea	FirstPrefsWindowstruct-MP_Next(a5),a0
		move.l	MP_Next(a0),d0
		move.l	a3,MP_Next(a0)
		move.l	d0,MP_Next(a3)

		*--- Engineliste einfgen ---*
		lea	MP_Enginelist+AGL_list(a3),a4
		newlist	a4

		move.l	MP_MEStruct(a3),d0
		beq.s	.NoEnginePrefs
		move.l	d0,a0
		move.l	MPE_ModulesPrefs(a0),d0
		beq.s	.NoEnginePrefs
		move.l	d0,a0
		move.w	#EPNr_AscEngine,d0
		bsr	FindMPArg
		bne.s	.NoEnginePrefs

.NextEngine:	lea	MP_Enginelist(a3),a4
		bsr	GetMultiArgName
		beq.s	.NoEnginePrefs

		move.l	a1,-(a7)
		lea	InfoBlock(a5),a1
		move.w	d0,d1
		subq.w	#1,d1
		bsr	StringCopy
		move.l	(a7)+,a0
		bsr	ReadZahl

		lea	InfoBlock(a5),a0
		bsr	InsertMPEntry
		move.l	a2,a0
		bra.s	.NextEngine




		*--- Gruppenliste einfgen ---*
.NoEnginePrefs:	lea	MP_Gruppenlist+AGL_list(a3),a4
		newlist	a4
		lea	MPG_NimmGruppe(pc),a0
		move.l	a0,AGL_Doppelklick(a4)

		move.l	MP_MEStruct(a3),d0
		beq.s	.NoGroupsPrefs
		move.l	d0,a0
		move.l	MPE_Eigenschaften(a0),d0
		beq.s	.NoGroupsPrefs
		move.l	d0,a0
		move.w	#EPMENr_Group,d0
		bsr	FindMEArg
		bne.w	.NoGroupsPrefs

.NextGroup:	lea	MP_Gruppenlist(a3),a4
		bsr	GetMultiArgName
		beq.s	.NoGroupsPrefs

		lea	InfoBlock(a5),a1
		move.w	d0,d1
		subq.w	#1,d1
		bsr	StringCopy

		lea	InfoBlock(a5),a0
		bsr	InsertItInList
		move.l	a2,a0
		bra.s	.NextGroup




.NoGroupsPrefs:	movem.l	(a7)+,d0-a6
		rts


*147='Moduleinfo'=01=EP='140,45,43';'Analyzer',64=1

*-----------------------------------------------------------------------------*
* Input: a3=MP_Struct
P_ClosePrefsWindow:
		movem.l	d0-a6,-(a7)

		*-- Die Prefs in die Structuren schreiben --*
		*bsr	MP_InsertNewPrefs

		tst.l	MP_Window+WS_WinHandle(a3)
		beq.s	.NoMerkPos
		move.w	MP_Window+WS_WinPosX(a3),Prefs_LastLeftEdge(a5)
		move.w	MP_Window+WS_WinPosY(a3),Prefs_LastTopEdge(a5)
		move.l	MP_Window+WS_WinHandle(a3),a0
		move.w	WD_Width(a0),Prefs_LastWidth(a5)
		move.w	WD_Height(a0),Prefs_LastHeight(a5)

		*--- Aus Verkettung nehmen ---*
.NoMerkPos:	lea	FirstPrefsWindowstruct-MP_Next(a5),a0
.TestNext:	move.l	MP_Next(a0),d0
		beq.s	.Nicht
		cmp.l	d0,a3
		beq.s	.Ja
		move.l	d0,a0
		bra.s	.TestNext

.Ja:		move.l	MP_Next(a3),d0
		move.l	d0,MP_Next(a0)

		*-- Window schlieen --*
.Nicht:		lea	MP_Window(a3),a4
		bsr	AG_CloseWindow

		lea	MP_Enginelist(a3),a4
		bsr	DeleteAGList
		lea	MP_Gruppenlist(a3),a4
		bsr	DeleteAGList

		bsr	MP_FreeStruct

		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Diese Routine wird aufgerufen bevor ein neues Gadget creaiert wird.
* Sinn ist das Gadget zu konfigurieren.
* Wenn in der bergebenen Tagliste am Anfang ein -1/-2 steht, ist dies ein zu
* konfigurierendes Gadget:
* Input: a2=Tags
*	 a4=WS_Windowstruct
* Output:a2=neue Tags
P_CreateGadget:	move.l	a2,a3
		lea	-MP_Window(a4),a4	;HUHUHUH !!!!!!!!!!!
		move.l	MP_MEStruct(a4),d0
		beq.w	.Return
		move.l	d0,a0

		lea	FindMPArg(pc),a1
		move.l	MPE_ModulesPrefs(a0),d2
		move.l	(a3)+,d0
		cmp.l	#-1,d0
		beq.s	.MPArg
		lea	FindMEArg(pc),a1
		cmp.l	#-2,d0
		bne.s	.Return			;nicht konfigurieren
		move.l	MPE_Eigenschaften(a0),d2
.MPArg:		tst.l	d2
		beq.s	.Return
		move.l	d2,a0
		move.l	(a2)+,d0
		move.l	(a2)+,d0
		jsr	(a1)
		bne.s	.Return

		*-- So, mu konfiguriert werden --*
		lea	MyTags(a5),a6
		cmp.l	#PM_Tags,a2
		beq.s	.MPT_ProgrammMode

		btst	#MPF_Status,d2
		bne.s	.MPT_Status
		btst	#MPF_String,d2
		bne.s	.MPT_String
		btst	#MPF_Zahl,d2
		bne.s	.MPT_Zahl
		*btst	#MPF_MultiArgs,d2
		*bne.s	.MPT_MultiArgs
		bra.s	.Return

.MPT_String:	lea	Infoblock(a5),a1
		subq.w	#1,d1
		cmp.w	#260-2,d1
		blt.s	.MPT_SizeOk
		move.w	#260-2,d1
.MPT_SizeOk:	bsr	StringCopy
		lea	Infoblock(a5),a1
		move.l	a1,d1
		bra.s	.MPT_Zahl

.MPT_ProgrammMode:
		addq.l	#1,d1
		bra.s	.MPT_Zahl

.MPT_Status:	move.l	d1,d2
		moveq	#1,d1
		tst.l	d2
		beq.s	.MPT_Zahl
		moveq	#2,d1
.MPT_Zahl:	move.l	(a2)+,(a6)+		;Cycle oder Stringgadget
		move.l	d1,(a6)+
		bra.w	.CopyRestTags

.CopyRestTags:	addq.l	#4,a2
.CopyTags2:	tst.l	(a2)
		beq.s	.TagsOk
		move.l	(a2)+,(a6)+		
		bra.s	.CopyTags2
.TagsOk:	clr.l	(a6)
		lea	MyTags(a5),a2
.Return:	rts


*-----------------------------------------------------------------------------*
* Input: a3=MP_Struct
MP_FreeStruct:	movem.l	d0-a6,-(a7)
		move.l	a3,a1
		move.l	MP_StructSize(a3),d0
		beq.s	.Return
		EB
		jsr	_LVOFreeMem(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
P_BerechMinSize:
		*--- Breite der Gadgetleiste berechnen ---*
		moveq	#0,d7

		*-- Breite der linken Seite --*
		bsr	P_BerechUL1			;ganz linken Texte
		move.l	d1,d2
		bsr	P_BerechUL2			;Cyclegadgets
		add.l	d1,d2

		bsr	P_BerechM
		cmp.l	d1,d2
		bhi.s	.LD21Ok
		move.l	d1,d2
.LD21Ok:	bsr	P_BerechOL
		cmp.l	d1,d2
		bhi.s	.LD22Ok
		move.l	d1,d2
.LD22Ok:

		*-- Breite der rechten Seite --*
		bsr	P_BerechUR1			;StringGadgets
		move.l	d1,d3
		bsr	P_BerechUR2			;ganz rechten Texte
		add.l	d1,d3
		bsr	P_BerechM
		cmp.l	d1,d3
		bhi.s	.RD21Ok
		move.l	d1,d3
.RD21Ok:	bsr	P_BerechOR
		cmp.l	d1,d3
		bhi.s	.RD22Ok
		move.l	d1,d3
.RD22Ok:	move.l	d3,d6

		cmp.l	d2,d6
		bhi.s	.D3Gr
		move.l	d2,d6
.d3Gr:		add.w	d6,d6
		add.l	#BevelBreite*6*2+MinTextGadgetXOffset*6*2+GadgetXAbstand*7,d6

		move.l	WS_PubScreen(a4),a0
		move.b	Sc_WBorLeft(a0),d0
		ext.w	d0
		add.w	d0,d6
		move.b	Sc_WBorRight(a0),d0
		add.w	d0,d6
		move.w	d6,WS_MinWidth(a4)


	*----- So, nun wird die Y-Ausdehnung des Window berechnet -----*
		moveq	#0,d0
		move.w	WS_FontY(a4),d0
	*	add.w	#MinTextGadgetYOffset*2+BevelHohe*2,d0
		add.w	#MinTextGadgetYOffset*2+BevelHohe*2+GadgetYAbstand/2,d0
		mulu	#14,d0	* 1 fr Listviewberschrift
				* 2+1 fr Listview
				* 1 fr Gadgetreihe 
				* 8 fr Cyclegadgets bzw. Stringgadgets
				* 1 als Reserve

		add.w	WS_Offy(a4),d0
		move.w	d0,WS_MinHeight(a4)
		rts




*-------------------- Berechnet die Texte am linken Rand ---------------------*
P_BerechUL1:	move.l	d0,-(a7)
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_P_Filter,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_FadeIn,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_FadeOut,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_Songend,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_AutoSubSong,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_RandomSong,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_LoadBefore,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_LoadFast,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_ProgrammMode,d0
		bsr	NimmBiggerSize
	add.w	#TextCycleAbstand,d1
	move.w	d1,PW_UL1(a5)
		move.l	(a7)+,d0
		rts

*-------------------- Berechnet die Texte der Cyclegadgets -------------------*
P_BerechUL2:	move.l	d0,-(a7)
		moveq	#MinGadgetWidth+CycleWidth,d1	 ;15 Breite der Cycleimages

		moveq	#LENr_L_NotChanged,d0
		bsr	NimmBiggerSize
		moveq	#LENr_L_Yes,d0
		bsr	NimmBiggerSize
		moveq	#LENr_L_No,d0
		bsr	NimmBiggerSize
		moveq	#LENr_LM_NoNewModule,d0
		bsr	NimmBiggerSize
		moveq	#LENr_LM_NextModule,d0
		bsr	NimmBiggerSize
		moveq	#LENr_LM_PrevModule,d0
		bsr	NimmBiggerSize
		moveq	#LENr_LM_RandomModule,d0
		bsr	NimmBiggerSize
	move.w	d1,PW_UL2(a5)
		move.l	(a7)+,d0
		rts

*------------------ Berechnet die Texte bei der rechten Mitte ----------------*
P_BerechUR2:	move.l	d0,-(a7)
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_P_Volume,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_StartSong,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_Timeout,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_MinTimeout,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_Passwort,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_Songname,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_Specialinfo,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_Autor,d0
		bsr	NimmBiggerSize
		moveq	#LENr_P_Player,d0
		bsr	NimmBiggerSize
	add.w	#TextStringAbstand,d1
	move.w	d1,PW_UR2(a5)
		move.l	(a7)+,d0
		rts


*------------------ Berechnet die Texte bei der rechten Mitte ----------------*
P_BerechUR1:	move.l	d0,-(a7)
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_GetFile,d0
		bsr	NimmBiggerSize
		add.w	#StringMinWidth,d1
	move.w	d1,PW_UR1(a5)
		move.l	(a7)+,d0
		rts

*------------------ Berechnet die Texte unter den Listviews ------------------*
P_BerechM:	movem.l	d0/d2,-(a7)
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_P_Add,d0
		bsr	NimmBiggerSize
		move.l	d1,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_P_Delete,d0
		bsr	NimmBiggerSize
		add.l	d1,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_P_Clear,d0
		bsr	NimmBiggerSize
		add.l	d1,d2
	move.w	d2,PW_LTL(a5)
		movem.l	(a7)+,d0/d2
		rts

*------------------ Berechnet die Texte ber dem Listview --------------------*
P_BerechOL:	move.l	d0,-(a7)
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_P_Enginelist,d0
		bsr	NimmBiggerSize
		move.l	(a7)+,d0
		rts

*------------------ Berechnet die Texte ber dem Listview --------------------*
P_BerechOR:	move.l	d0,-(a7)
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_P_Gruppenlist,d0
		bsr	NimmBiggerSize
		move.l	(a7)+,d0
		rts


*-----------------------------------------------------------------------------*
* d6=Innerwidth
* d7=Innerheight
P_InitGadgets:	move.l	d6,d5
		lsr.l	#1,d5

		sub.w	#GadgetXAbstand/2,d5

		*-- Width und Leftpos der linken Gadgets setzen --*
		move.l	d5,d0
		move.w	PW_UL1(a5),d1
		add.w	#TextCycleAbstand,d1
		sub.w	d1,d0
		move.l	WS_Gadgets(a4),a3
		move.l	#9-1,d4
		lea	gng_sizeof*8(a3),a3
.SetWidthL:	add.w	d1,gng_leftedge(a3)
		move.w	d0,gng_width(a3)
		lea	gng_sizeof(a3),a3
		dbf	d4,.SetWidthL

		*-- Width und Leftpos der rechten Gadgets setzen --*
		move.l	d5,d0
		move.w	PW_UR2(a5),d1
		add.w	#TextStringAbstand+GadgetXAbstand,d1
		sub.w	d1,d0
		add.w	d5,d1
		add.w	#GadgetXAbstand,d1
		move.l	WS_Gadgets(a4),a3
		lea	gng_sizeof*17(a3),a3		;Volume
		move.l	#11-1,d4
.SetWidthR:	add.w	d1,gng_leftedge(a3)
		move.w	d0,gng_width(a3)
		lea	gng_sizeof(a3),a3
		dbf	d4,.SetWidthR


		moveq	#MinGadgetWidth,d1
		moveq	#LENr_GetFile,d0
		bsr	NimmBiggerSize
		move.l	d1,d0
		add.w	#GadgetXAbstand,d0


		move.l	WS_Gadgets(a4),a3
	*	move.w	#FileReqWidth,d0
		move.w	gng_width+gng_sizeof*26(a3),d1 ;Width vom Player
		sub.w	d0,d1
		move.w	d1,gng_width+gng_sizeof*26(a3) ;neue Width vom Player
		add.w	d1,gng_leftedge+gng_sizeof*27(a3) ;FileReq
		move.w	d0,gng_width+gng_sizeof*27(a3) ;neue Width vom PlFileReq

		move.w	gng_width+gng_sizeof*24(a3),d1 ;Autor
		sub.w	d0,d1
		move.w	d1,gng_width+gng_sizeof*24(a3) ;neue Width vom Autor
		add.w	d1,gng_leftedge+gng_sizeof*25(a3) ;FileReq
		move.w	d0,gng_width+gng_sizeof*25(a3) ;neue Width vom AuFileReq


		*-- LeftPos aller rechten Gadgets setzen --*
		moveq	#0,d2
		move.w	PW_LTL(a5),d2



	*-- Die Breiten der Gadgetleisten wird berechnet --*
	*-- Als erstes wird die Stringbreite berechnet und gemerkt --*
	*-- dann wird calibriert

	*-- Die Breiten der Gadgetleisten wird berechnet --*
	*-- Als erstes wird die Stringbreite berechnet und gemerkt --*
	*-- dann wird calibriert
		moveq	#0,d3
		moveq	#3-1,d4
		lea	GNG_SizeOf(a3),a3
		move.l	d6,-(a7)
		move.l	d5,d6
		sub.w	#GadgetXAbstand*2,d6
.LWT_GadgetWidth:
		moveq	#MinGadgetWidth,d1
		move.l	GNG_GadgetText(a3),a0
		bsr	NimmBiggerSize2
*		add.w	#BevelBreite*2+MinTextGadgetXOffset*2,d1 ;Neu V5

		mulu	d6,d1				*mal max. nutz Ausdehn.
		divu	d2,d1				*durch GesamtStringlen
*		addq.l	#1,d1
		move.w	d1,GNG_Width(a3)
		move.w	d1,GNG_Width+gng_Sizeof*4(a3)

		add.w	d3,GNG_LeftEdge(a3)
		add.w	d5,GNG_LeftEdge+gng_SizeOf*4(a3)
		add.w	d3,GNG_LeftEdge+gng_SizeOf*4(a3)
		add.w	#GadgetXAbstand,GNG_LeftEdge+gng_SizeOf*4(a3)
		add.w	d1,d3
		add.w	#GadgetXAbstand,d3

		lea	GNG_SizeOf(a3),a3
		dbf	d4,.LWT_GadgetWidth
		move.l	(a7)+,d6


		*--- Width und LeftPos der Listviews setzen ---*
		move.l	WS_Gadgets(a4),a3
		add.w	d5,gng_leftedge+gng_sizeof*4(a3) ;Gruppenlistview
		add.w	#GadgetXAbstand,GNG_LeftEdge+gng_SizeOf*4(a3)
		move.w	d5,gng_width+gng_sizeof*0(a3)	;Engine Listview
		move.w	d5,gng_width+gng_sizeof*4(a3)	;Gruppen Listview





		*-- TopPos/Height aller Gadgets setzen --*
		moveq	#0,d4				*Hhe der Gadgets
		move.w	WS_FontY(a4),d4
		add.w	#MinTextGadgetYOffset*2+BevelHohe*2,d4
		move.l	WS_Gadgets(a4),a3
		move.l	WS_GadgetAnz(a4),d0
		subq.l	#1,d0
.SetHeight:	move.w	d4,gng_Height(a3)
		lea	gng_sizeof(a3),a3
		dbf	d0,.SetHeight

		add.w	#GadgetYAbstand/2,d4

		move.l	WS_Gadgets(a4),a3
		move.w	d7,gng_topedge+gng_sizeof*27(a3) ;FileReq
		move.w	d7,gng_topedge+gng_sizeof*26(a3) ;Player
		move.w	d7,gng_topedge+gng_sizeof*16(a3) ;ProgrammMode
		sub.w	d4,d7

		move.w	d7,gng_topedge+gng_sizeof*25(a3) ;FileReq
		move.w	d7,gng_topedge+gng_sizeof*24(a3) ;Autor
		move.w	d7,gng_topedge+gng_sizeof*15(a3) ;LoadFast
		sub.w	d4,d7

		lea	gng_sizeof*23(a3),a3
		moveq	#6,d0
.SetTopPos:	move.w	d7,gng_topedge(a3)
		move.w	d7,gng_topedge-gng_sizeof*9(a3)
		sub.w	d4,d7
		lea	-gng_sizeof(a3),a3
		dbf	d0,.SetTopPos


		sub.w	#GadgetYAbstand,d7

		move.l	WS_Gadgets(a4),a3
		move.w	d7,gng_topedge+gng_sizeof*1(a3) ;Engine Add
		move.w	d7,gng_topedge+gng_sizeof*2(a3) ;Engine Delete
		move.w	d7,gng_topedge+gng_sizeof*3(a3) ;Engine Clear
		move.w	d7,gng_topedge+gng_sizeof*5(a3) ;Gruppe Add
		move.w	d7,gng_topedge+gng_sizeof*6(a3) ;Gruppe Delete
		move.w	d7,gng_topedge+gng_sizeof*7(a3) ;Gruppe Clear

		sub.w	d4,d7
		move.w	d4,gng_topedge(a3) 		;Engine Listview
		move.w	d4,gng_topedge+gng_sizeof*4(a3) ;Gruppenlistview
		move.w	d7,gng_Height(a3)		;Engine Height
		move.w	d7,gng_Height+gng_sizeof*4(a3)	;Gruppe Height


		moveq	#0,d0
		rts


*PW_UL1			rs.w	1
*PW_UR2			rs.w	1
*PW_UL2			rs.w	1
*PW_UR1			rs.w	1


*-----------------------------------------------------------------------------*
* Input: a4=Windowstructure								      *
P_AddGadgets:	move.l	a4,a2
		lea	-MP_Window(a4),a3
		move.l	a2,MP_Enginelist+AGL_Windowstruct(a3)
		move.w	#EPENrPE_Enginelist,MP_Enginelist+AGL_GadgetID(a3)
		move.l	a4,-(a7)
		lea	MP_Enginelist(a3),a4
		bsr	ReAddAGLlist
		move.l	(a7)+,a4

		lea	-MP_Window(a4),a3
		move.l	a2,MP_Gruppenlist+AGL_Windowstruct(a3)
		move.w	#EPENrPG_Gruppenlist,MP_Gruppenlist+AGL_GadgetID(a3)
		lea	MP_Gruppenlist(a3),a4
		bsr	ReAddAGLlist

		rts


*-----------------------------------------------------------------------------*
* Input: a4=Windowstructure								      *
P_FreeGadgets:	lea	-MP_Window(a4),a3
		clr.b	MP_Enginelist+AGL_ListeDa(a3)
		clr.b	MP_Gruppenlist+AGL_ListeDa(a3)
		rts



A_DeleteAutor:	bsr	A_ClearPrefs
		rts

G_DeleteGruppe:	bsr	G_ClearPrefs
		rts








*--- alle Autoren werden gelscht! Alle Entries durchgehen und die Autoren
*--- lschen
A_NewAutors:	moveq	#0,d0
		rts


* Input: d0=Module/AutorGruppenNr (auch Autor und Gruppe)
*	 d1=Prefstype (Autor/Gruppe/Module)
*	 a0=Titletext
*	 a1=ModulesPrefsStruct


*-----------------------------------------------------------------------------*
* Doppelklick im Listview des Autorenwindows
* Input: a4=AGL_Liste
*	 d5=Nummer in Autorenliste
A_NimmAutor:	move.l	AGL_WindowStruct(a4),d0
		beq.s	.Return
		move.l	d0,a3
		move.l	a3,d4

		lea	AGL_List(a4),a4
		subq.w	#1,d5
		blt.s	.Return
.Next:		move.l	(a4),a4
		move.l	(a4),d0
		beq.s	.Return
		move.l	LN_Name(a4),a0
		dbf	d5,.Next

		move.l	AGW_MPStruct(a3),d0
		beq.s	.Return
		move.l	d0,a4
		move.l	d0,a3
		lea	MP_Window(a3),a3

		*--- Text setzen ---*
		lea	MyTags(a5),a2
		move.l	#GTST_String,(a2)+
		move.l	a0,(a2)+
		clr.l	(a2)
		moveq	#EPENrP_Autor,d0
		bsr	GetGadgetAdr2
		bne.s	.Return

		move.l	WS_Winhandle(a3),a1
		lea	MyTags(a5),a3
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		move.l	a4,a3
		bsr	UpdateModulesPrefs

		move.l	d4,a4
		bsr	AG_CloseWindow

.Return:	moveq	#0,d0
		rts



		*--- Gruppenwindow ---*
		*--- Autorwindow ---*
G_NewGruppe:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Doppelklick im Listview des Gruppenwindows
* Input: a4=AGL_Liste
*	 d5=Nummer in Gruppenliste
G_NimmGruppe:	move.l	AGL_WindowStruct(a4),d0
		beq.s	.Return
		move.l	d0,a3
		move.l	a3,a2

		lea	AGL_List(a4),a4
		subq.w	#1,d5
		blt.s	.Return
.Next:		move.l	(a4),a4
		move.l	(a4),d0
		beq.s	.Return
		move.l	LN_Name(a4),a0
		dbf	d5,.Next

		move.l	AGW_MPStruct(a3),d0
		beq.s	.Return
		move.l	d0,a3
		lea	MP_Gruppenlist(a3),a4
		bsr	RemoveAGLlist
		bsr	InsertMPEntry
		bsr	ReAddAGLlist
		bsr	UpdateModulesPrefs


		move.l	a2,a4
		bsr	AG_CloseWindow

.Return:	moveq	#0,d0
		rts



*-----------------------------------------------------------------------------*
* Input: a4=Windowstruct
ClrWinStruct:	movem.l	d0/a0,-(a7)
		move.l	a4,d0
		beq.s	.Return
		move.l	#WS_SizeOf-1,d0
		move.l	a4,a0
.Clr:		clr.b	(a0)+
		dbf	d0,.Clr
.Return:	movem.l	(a7)+,d0/a0
		rts

*-----------------------------------------------------------------------------*
* ffne oder schliee Autorenfenster
*-----------------------------------------------------------------------------*
A_Autorliste:	lea	Autorwindowstruct(a5),a4
		tst.l	WS_WinHandle(a4)
		beq.s	.Open
		bsr	AG_CloseWindow
		bra.s	.Return

.Open:		sub.l	a3,a3
		bsr	OpenAutorwindow
.Return:	rts

*-----------------------------------------------------------------------------*
* ffne oder schliee Autorenfenster (Aufruf aus dem Menu!!!!!)
*-----------------------------------------------------------------------------*
G_Gruppenliste:	lea	Gruppenwindowstruct(a5),a4
		tst.l	WS_WinHandle(a4)
		beq.s	.Open
		bsr	AG_CloseWindow
		bra.s	.Return
.Open:		sub.l	a3,a3
		bsr	OpenGruppenwindow
.Return:	rts


*-----------------------------------------------------------------------------*
* Input: a0=Windowtitle oder NULL
*	 a3=MP_Struct oder NULL
* Output:0=Error
OpenAutorWindow:movem.l	d1-a6,-(a7)
		lea	Autorwindowstruct(a5),a4
		move.l	a3,AGW_MPStruct(a4)

		tst.l	WS_WinHandle(a4)
		beq.w	.Oeffnen
		moveq	#LENr_AutorWindowtitle,d1
		bsr	AG_SetWindowTitle

		move.l	WS_Winhandle(a4),a0
		move.l	IntBase(a5),a6
		jsr	_LVOWindowToFront(a6)
		move.l	WS_Winhandle(a4),a0
		jsr	_LVOActivateWindow(a6)

		move.l	WS_WinHandle(a4),d0
		bra.w	.Return

.Oeffnen:

		move.w	WS_WinPosX(a4),d0
		move.w	WS_WinPosY(a4),d1
		move.w	WS_WinWidth(a4),d2
		move.w	WS_WinHeight(a4),d3
		
		bsr	ClrWinStruct

		move.w	d0,WS_WinPosX(a4)
		move.w	d1,WS_WinPosY(a4)
		move.w	d2,WS_DefWidth(a4)
		move.w	d3,WS_DefHeight(a4)
		move.w	d2,WS_WinWidth(a4)
		move.w	d3,WS_WinHeight(a4)

		moveq	#LENr_AutorWindowtitle,d1
		bsr	AG_SetWindowTitle

		*--- Def Routinen setzen ---*
		lea	A_BerechMinSize(pc),a0
		move.l	a0,WS_BerechMinWindowSize(a4)
		lea	A_InitGadgets(pc),a0
		move.l	a0,WS_InitGadgets(a4)
		lea	A_AddGadgets(pc),a0
		move.l	a0,WS_AddGadgets(a4)
		lea	A_FreeGadgets(pc),a0
		move.l	a0,WS_FreeGadgets(a4)
		lea	Autor_Gadgets(pc),a0
		move.l	a0,WS_Gadgets(a4)
		lea	AG_Gadgettypes(pc),a0
		move.l	a0,WS_Gadgettypes(a4)
		lea	AG_GadgetTags(pc),a0
		move.l	a0,WS_GadgetTags(a4)
		lea	A_RawKeyTabelle(pc),a0
		move.l	a0,WS_RawKeyTabelle(a4)
		lea	A_VanillaKeyTabelle(pc),a0
		move.l	a0,WS_VanillaKeyTabelle(a4)
		lea	MenuTabelle(pc),a0
		move.l	a0,WS_MenuTabelle(a4)

		*--- Positionen setzen ---*
		move.l	#AutorGadgetAnz,WS_GadgetAnz(a4)
		cmp.w	#-1,WS_WinPosX(a4)
		bne.s	.XOk
		move.w	WinPosx(a5),WS_WinPosX(a4)
.XOk:		cmp.w	#-1,WS_WinPosY(a4)
		bne.s	.YOk
		move.w	WinPosY(a5),WS_WinPosY(a4)
	move.w	WinHeight(a5),WS_DefHeight(a4)
	move.w	WinWidth(a5),WS_DefWidth(a4)

.YOk:		bsr.w	AG_OpenWin
.Return:	movem.l	(a7)+,d1-a6
		rts


*-----------------------------------------------------------------------------*
* Input: a0=Windowtitle oder NULL
*	 a3=MP_Struct oder NULL
* Output:0=Error
OpenGruppenWindow:		
		movem.l	d1-a6,-(a7)
		lea	Gruppenwindowstruct(a5),a4
		move.l	a3,AGW_MPStruct(a4)
		tst.l	WS_WinHandle(a4)
		beq.w	.Oeffnen
		moveq	#LENr_GruppenWindowtitle,d1
		bsr	AG_SetWindowTitle

		move.l	WS_Winhandle(a4),a0
		move.l	IntBase(a5),a6
		jsr	_LVOWindowToFront(a6)
		move.l	WS_Winhandle(a4),a0
		jsr	_LVOActivateWindow(a6)

		move.l	WS_WinHandle(a4),d0
		bra.w	.Return

.Oeffnen:	move.w	WS_WinPosX(a4),d0
		move.w	WS_WinPosY(a4),d1
		move.w	WS_WinWidth(a4),d2
		move.w	WS_WinHeight(a4),d3
		
		bsr	ClrWinStruct

		move.w	d0,WS_WinPosX(a4)
		move.w	d1,WS_WinPosY(a4)
		move.w	d2,WS_DefWidth(a4)
		move.w	d3,WS_DefHeight(a4)
		move.w	d2,WS_WinWidth(a4)
		move.w	d3,WS_WinHeight(a4)

		moveq	#LENr_GruppenWindowtitle,d1
		bsr	AG_SetWindowTitle

		*--- Def Routinen setzen ---*
		lea	A_BerechMinSize(pc),a0
		move.l	a0,WS_BerechMinWindowSize(a4)
		lea	A_InitGadgets(pc),a0
		move.l	a0,WS_InitGadgets(a4)
		lea	G_AddGadgets(pc),a0
		move.l	a0,WS_AddGadgets(a4)
		lea	G_FreeGadgets(pc),a0
		move.l	a0,WS_FreeGadgets(a4)
		lea	Gruppen_Gadgets(pc),a0
		move.l	a0,WS_Gadgets(a4)
		lea	AG_Gadgettypes(pc),a0
		move.l	a0,WS_Gadgettypes(a4)
		lea	AG_GadgetTags(pc),a0
		move.l	a0,WS_GadgetTags(a4)
		lea	G_RawKeyTabelle(pc),a0
		move.l	a0,WS_RawKeyTabelle(a4)
		lea	G_VanillaKeyTabelle(pc),a0
		move.l	a0,WS_VanillaKeyTabelle(a4)
		lea	MenuTabelle(pc),a0
		move.l	a0,WS_MenuTabelle(a4)

		*--- Positionen setzen ---*
		move.l	#GruppenGadgetAnz,WS_GadgetAnz(a4)
		cmp.w	#-1,WS_WinPosX(a4)
		bne.s	.XOk
		move.w	WinPosx(a5),WS_WinPosX(a4)
.XOk:		cmp.w	#-1,WS_WinPosY(a4)
		bne.s	.YOk
		move.w	WinPosY(a5),WS_WinPosY(a4)
	move.w	WinHeight(a5),WS_DefHeight(a4)
	move.w	WinWidth(a5),WS_DefWidth(a4)

.YOk:		bsr.w	AG_OpenWin
.Return:	movem.l	(a7)+,d1-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a3=MP_Struct oder NULL
*	 d1=LocaleString
* Output:d0=Adr oder NULL
AG_SetWindowTitle:
		movem.l	d1-a6,-(a7)
		move.l	a3,d0
		move.l	d0,a2
		beq.s	.Default

		moveq	#LENr_ModulesPrefsFor,d0
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	BerechStringSize
		move.l	MP_Window+WS_WindowTitle(a3),a0
		add.l	d0,a0
		move.l	a0,a2

		*moveq	#LENr_GruppenWindowtitle,d1
		bsr	BerechStringSize
		beq.s	.Default
		*moveq	#LENr_SelectGruppe,d1
		addq.l	#1,d1
.Default:	move.l	d0,d2
		move.l	d1,d0
		move.l	d1,d4
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	BerechStringSize
		add.l	d2,d0

		*--- Mem besorgen ---*
		move.l	a4,a3
		bsr	AG_FreeWindowTitle
		addq.l	#4,d0
		move.l	d0,d3
		bsr	AllocMem2
		move.l	d0,WS_WindowTitle(a3)
		beq.w	.Return
		move.l	d3,WS_WindowTitleSize(a3)
		move.l	d0,a1

		move.l	d4,d0
		bsr	GetLocaleString
		move.l	d0,a0
		move.l	d3,d1
		subq.l	#5,d1
		bsr	StringCopy
		move.l	a2,a0
		bsr	StringCopy

		move.l	WS_WinHandle(a3),d0
		beq.s	.NoWindow
		move.l	d0,a0
		move.l	IntBase(a5),a6
		move.l	WS_WindowTitle(a3),a1

		if	Debugger!Executable
		move.l	EPBase(pc),a2
		move.l	EPG_TitlePuffer(a2),a2
		else
		moveq	#LENr_ScreenTitle,d0
		bsr	GetLocaleString
		move.l	d0,a2
		endc
		jsr	_LVOSetWindowTitles(a6)
.NoWindow:
.Return:
		move.l	WS_WindowTitle(a3),d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*

*-----------------------------------------------------------------------------*
* Input: a4=Windowstructure								      *
* Output:
A_BerechMinSize:
		movem.l	d0-a6,-(a7)

		*--- Breite der Gadgetleiste berechnen ---*
		moveq	#0,d7
		moveq	#0,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Add,d0
		bsr	NimmBiggerSize
		add.l	d1,d2

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Delete,d0
		bsr	NimmBiggerSize
		add.l	d1,d2

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_New,d0
		bsr	NimmBiggerSize
		add.l	d1,d2

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_ModulesPrefs,d0
		bsr	NimmBiggerSize
		add.l	d1,d2

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_ClearPrefs,d0
		bsr	NimmBiggerSize
		add.l	d1,d2


 add.l	#BevelBreite*5*2+MinTextGadgetXOffset*5*2+GadgetXAbstand*4,d2
					*Abstand vom Bevelrand links & rechts
					*sowie Abstand zum nchsten Gadget
					*Breite aller Bevelboxen
					*dazuaddieren 5 Gadgets*2Rnder = 14

		move.l	d2,d6

		add.l	#GadgetXAbstand*2,d6	*Abstand vom Rand links&Rechts


		move.l	WS_PubScreen(a4),a0
		move.b	Sc_WBorLeft(a0),d0
		ext.w	d0
		add.w	d0,d6
		move.b	Sc_WBorRight(a0),d0
		add.w	d0,d6
		move.w	d6,WS_MinWidth(a4)


	*----- So, nun wird die Y-Ausdehnung des Window berechnet -----*
		moveq	#0,d0
		move.w	WS_FontY(a4),d0
		add.w	#MinTextGadgetYOffset*2+BevelHohe*2,d0
		mulu	#5,d0	* 2+1 fr Listview
				*        1 fr Gadgetreihe 
				*	 und 1 als Reserve

		add.w	WS_Offy(a4),d0
		move.w	d0,WS_MinHeight(a4)


		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Input: a4=Windowstructure								      *
*	 d6=Offs vom linken Windowrand
*	 d7=Offs vom oberen Windowrand
A_InitGadgets:

	*-- Die Breiten der Gadgetleisten wird berechnet --*
	*-- Als erstes wird die Stringbreite berechnet und gemerkt --*
	*-- dann wird calibriert
		move.l	WS_Gadgets(a4),a3
		moveq	#0,d2
		move.l	WS_GadgetAnz(a4),d4
		subq.l	#2,d4
		lea	GNG_SizeOf(a3),a3		;auf Add zeigen

.GadgetWidth:	moveq	#MinGadgetWidth,d1
		move.l	GNG_GadgetText(a3),a0
		bsr	NimmBiggerSize2
		add.w	#BevelBreite*2+MinTextGadgetXOffset*2,d1 ;Neu V5
		move.w	d1,GNG_Width(a3)
		add.l	d1,d2
		lea	GNG_SizeOf(a3),a3
		dbf	d4,.GadgetWidth


	*-- jetzt befindet sich in d2 die Width aller Gadgetstrings sowie --*
	*-- der Bevelboxen 						  --*
	*-- jetzt die Width der Gadgets in Verhltnis der Gesammtwidth    --*
	*-- setzen.
		moveq	#0,d4				*Hhe der Gadgets
		move.w	WS_FontY(a4),d4
		add.w	#MinTextGadgetYOffset*2+BevelHohe*2,d4

		move.l	d6,d5
		sub.w	#GadgetXAbstand*5,d5
		ext.l	d5


		moveq	#0,d3
		move.l	WS_GadgetAnz(a4),d1
		subq.l	#2,d1
		move.l	WS_Gadgets(a4),a3
		lea	GNG_Sizeof(a3),a3
.GadgetWidth2:	moveq	#0,d0
		move.w	GNG_Width(a3),d0		*Stringwidth
		mulu	d5,d0				*mal max. nutz Ausdehn.
		divu	d2,d0				*durch GesamtStringlen
*		swap	d0
*		btst	#0,d0
*		beq.s	.GGNoAdd
*		add.l	#$10000,d0
*.GGNoAdd:	swap	d0
		move.w	d7,GNG_TopEdge(a3)
		*sub.w	d4,GNG_TopEdge(a3)
		move.w	d4,GNG_Height(a3)
	addq.l	#1,d0
		move.w	d0,GNG_Width(a3)
		move.w	d3,GNG_LeftEdge(a3)

		add.w	d0,d3
		add.w	#GadgetXAbstand,d3
		lea	GNG_SizeOf(a3),a3
		dbf	d1,.GadgetWidth2

		*--- Listview noch setzen ---*
		move.l	WS_Gadgets(a4),a0

		sub.w	#GadgetYAbstand*2,d7
		*sub.w	WS_FontY(a4),d7

	* fr Listview:
	* in d6 ist jetzt die InnerWidth
	* in d7 ist jetzt die InnerHeight
		move.w	d6,GNG_Width(a0)
		move.w	d7,GNG_Height(a0)

		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
* Input: a4=Windowstructure								      *
A_AddGadgets:	lea	Autorlist(a5),a4
		bsr	ReAddAGLlist
		rts


*-----------------------------------------------------------------------------*
* Input: a4=Windowstructure								      *
A_FreeGadgets:	lea	Autorlist(a5),a4
		clr.b	AGL_ListeDa(a4)
		rts

*-----------------------------------------------------------------------------*
* Input: a4=Windowstructure								      *
G_AddGadgets:	lea	Gruppenlist(a5),a4
		bsr	ReAddAGLlist
		rts

*-----------------------------------------------------------------------------*
* Input: a4=Windowstructure								      *
G_FreeGadgets:	lea	Gruppenlist(a5),a4
		clr.b	AGL_ListeDa(a4)
		rts









*-----------------------------------------------------------------------------*
* Input: a4=Windowstruct
AG_OpenWin:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5

		move.l	WS_Winhandle(a4),d0
		beq.s	.OpenIt
		move.l	d0,a0
		move.l	IntBase(a5),a6
		jsr	_LVOWindowToFront(a6)
		move.l	WS_Winhandle(a4),a0
		jsr	_LVOActivateWindow(a6)
		bra.s	.Windowda
		
.OpenIt:	move.l	WS_UpdateMenus(a4),d0
		beq.s	.NoUpdateMenus
		move.l	d0,a0
		jsr	(a0)

.NoUpdateMenus:	move.l	Intbase(a5),a6
		bsr	AG_LockPubscreen		;Public Screen holen
		bne	.Error
		bsr	AG_SetUpWin		;Fenster ffnen
		tst.l	d0
		bne.w	.Error

.Error:	
.WindowDa	move.l	WS_WinHandle(a4),d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Fenster ffnen, mit Menu & Gadgets sowie Sizeanpassung		      *
* Input: a4=Windowstructure								      *
* Output: d0=Error oder NULL						      *
*-----------------------------------------------------------------------------*
AG_SetUpWin:	movem.l d1-a6,-(sp)


		move.l	WS_Pubscreen(a4),d0
		beq.w	.Error
		move.l	d0,a0
		move.l	SC_Font(a0),a1
		move.w	TA_YSize(a1),d3
		addq.w	#1,d3
		move.b	sc_WBorTop(a0),d0
		ext.w	d0
		add.w	d3,d0
		move.w	d0,WS_OffY(a4)

		move.b  SC_WBorLeft(a0),d0
		ext.w   d0
		move.w	d0,WS_Offx(a4)

		move.l	sc_RastPort+rp_Font(a0),a0
		lea	MyFont(a5),a1
		move.l	a1,WS_Font(a4)
		move.l  LN_Name(a0),ta_Name(a1)
		move.w  tf_YSize(a0),ta_YSize(a1)
		move.w  tf_XSize(a0),WS_FontX(a4)
		move.w  tf_YSize(a0),WS_FontY(a4)
		clr.w	6(a1)

		*-- Minsize berechnen ----------------*
		* WS_MinHeight und WS_MinWidth setzen *
		*-------------------------------------*
		move.l	WS_BerechMinWindowSize(a4),d0
		beq.w	.Error
		move.l	d0,a0
		movem.l	d1-a6,-(a7)
		jsr	(a0)
		movem.l	(a7)+,d1-a6


		*---- Gre des Fensters festlegen ----*
		moveq	#0,d2
		moveq	#0,d3
	*	move.w	EUS_Structure+EUS_Special(pc),d2	;Width
	*	move.w	EUS_Structure+EUS_Special+2(pc),d3	;Height
		move.w	WS_Defwidth(a4),d2			;Width
		move.w	WS_Defheight(a4),d3			;Height
		bne.s	.NimmDiese

		*--- Defaultgren setzen ---*
		moveq	#0,d0			*Keine Eintragung
		move.w	WS_FontY(a4),d0		*--> Fonthhe *6
		mulu	#6,d0
		add.w	d0,d3
		move.l	#200,d2

		*----- Ist diese Gre erlaubt ? -----*
.NimmDiese:	cmp.w	WS_MinHeight(a4),d3
		bhi.s	.HeightOk
		move.w	WS_MinHeight(a4),d3
.HeightOk:	cmp.w	WS_MinWidth(a4),d2
		bhi.s	.WidthOk
		move.w	WS_MinWidth(a4),d2
.WidthOk:	move.l	WS_Pubscreen(A4),a0
		move.w	d2,WS_Defwidth(a4)
		move.w	d3,WS_Defheight(a4)

		*--- Pat Window in Screen ---*
		move.l	d2,d0
		move.l	d0,d4
		moveq	#0,d2
		add.w	d2,d0
		add.w	WS_OffX(a4),d0
		move.b	sc_WBorRight(a0),d1
		ext.w	d1
		add.w	d1,d0
		cmp.w	sc_Width(a0),d0
		bls.s	.WinWidthOk
		move.w	sc_Width(a0),d0
		sub.w	d4,d0
		move.w	d0,d2			*-> nein, jetzt
.WinWidthOk:	move.l	d3,d0
		move.l	d0,d4

		*-- Menus creieren ---*
		move.l	GadBase(a5),a6
		move.l	WS_MenuItems(a4),d0
		beq.s	.NoMenus_1
		move.l	d0,a0
		lea	MenuTags(pc),a1
		jsr	_LVOCreateMenusA(a6)
		move.l	d0,WS_MenuAdr(a4)
		tst.l	d0
		beq	.Error
		move.l	d0,a0
		move.l	WS_VisualInfo(a4),a1
		move.l	WS_Tags(a4),a2
		move.l	#GTMN_Newlookmenus,(a2)
		move.l	#1,4(a2)
		clr.l	8(a2)
		jsr	_LVOLayoutMenusA(a6)

.NoMenus_1:	moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		moveq	#0,d7
		move	WS_WinPosX(a4),d0
		move	WS_WinPosY(a4),d1
		move	WS_ZoomPosX(a4),d2
		move	WS_ZoomPosY(a4),d3
		moveq	#0,d4
		moveq	#0,d5
		move.w	WS_Defwidth(a4),d4
		move.w	WS_Defheight(a4),d5
		*move.l	#ZoomWidth,d6

		move.l	WS_Pubscreen(a4),a0
		lea	sc_RastPort(a0),a0
		move.l	rp_Font(a0),a0
		move.w  tf_XSize(a0),d6
		mulu	#ZoomWidth,d6
		addq	#4,d6
		lsr	#3,d6
		move	WS_OffY(a4),d7
		tst.w	WS_ZoomState(a4)
		beq.s	.Normal
		exg.l	d0,d2
		exg.l	d1,d3
		exg.l	d4,d6
		exg.l	d5,d7

.normal:	lea	WS_ZoomStruct(a4),a2
		move.w	d2,(a2)
		move.w	d3,2(a2)
		move	d6,4(a2)
		move	d7,6(a2)

		lea	WS_Tags(a4),a1
		move.l	#WA_Left,(a1)+
		move.l	d0,(a1)+
		move.l	#WA_Top,(a1)+
		move.l	d1,(a1)+
		move.l	#WA_Width,(a1)+
		move.l	d4,(a1)+
		move.l	#WA_Height,(a1)+
		move.l	d5,(a1)+

		*move.l	#WA_Zoomstruct,(a1)+
		*move.l	a2,(a1)+

		move.l	#WA_MinWidth,(a1)+
		moveq	#0,d0
		move.w	WS_MinWidth(a4),d0
		move.l	d0,(a1)+

		move.l	#WA_MinHeight,(a1)+
		moveq	#0,d0
		move.w	WS_MinHeight(a4),d0
		move.l	d0,(a1)+

		move.l	#WA_MaxWidth,(a1)+
		move.l	#$8000,(a1)+

		move.l	#WA_MaxHeight,(a1)+
		move.l	#$8000,(a1)+


		move.l	#WA_IDCMP,(a1)+
		move.l	#IDCMP_VanillaKey!IDCMP_Changewindow!IDCMP_RawKey!IDCMP_Menupick!LISTVIEWIDCMP!IDCMP_NEWSIZE!BUTTONIDCMP!IDCMP_CLOSEWINDOW!IDCMP_REFRESHWINDOW,d0
		tst.l	WS_MenuAdr(a4)
		bne.s	.MenuDa_1
		and.l	#~IDCMP_Menupick,d0
.MenuDa_1:	move.l	d0,(a1)+

		move.l	#WA_Flags,(a1)+
		move.l	#Sizebbottom!WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_SMART_REFRESH!WFLG_SIZEGADGET,d0
		tst.l	WS_MenuAdr(a4)
		bne.w	.MenuDa_2
		*and.l	#~WFLG_MENUSTATE,d0
.MenuDa_2:	move.l	d0,(a1)+


		move.l	#WA_Title,(a1)+
		move.l	WS_WindowTitle(a4),(a1)+

		move.l	#WA_ScreenTitle,(a1)+
		move.l	WS_ScreenTitle(a4),(a1)+

		move.l	#WA_NewLookMenus,(a1)+
		move.l	#1,(a1)+

		move.l	#WA_AutoAdjust,(a1)+
		move.l	#1,(a1)

		move.l	#WA_Pubscreen,(a1)+
		move.l	WS_PubScreen(a4),(a1)+

		clr.l	(a1)


		*--- Nun Window ffnen ---*
		move.l	IntBase(a5),a6
		sub.l	a0,a0
		lea	WS_Tags(a4),a1
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,WS_Winhandle(a4)
		tst.l	d0
		beq	.OpenWindowError


		move.l	WS_WinHandle(a4),a0
		move.w	wd_leftedge(a0),WS_WinPosX(a4)
		move.w	wd_topedge(a0),WS_WinPosY(a4)
		move.w	wd_Width(a0),WS_WinWidth(a4)
		move.w	wd_Height(a0),WS_WinHeight(a4)

		move.l	d0,a0
		move.l	WD_RPort(a0),a0
		move.l	a0,WS_RastPort(a4)

		bsr	InitBackdrop


		if	BackPicture
		bsr	AG_ClearWindow
		endc

		bsr	AG_InitGadgets
		bne.s	.GadgetError
		bsr	AG_AddGads
		bne	.GadgetError

		bsr	ErlaubeGadgets


		move.l	WS_Winhandle(a4),a0
		move.l	WS_MenuAdr(a4),d0
		beq.s	.NoMenus_2
		move.l	d0,a1
		move.l	IntBase(a5),a6
		jsr	_LVOSetMenuStrip(a6)
		*bra.w	.MenusOk
.NoMenus_2:	*move.l	WinHandle(a5),d0
		*beq.s	.MenusOk
		*move.l	d0,a0
		*move.l	WS_WinHandle(a4),a1
		*move.l	IntBase(a5),a6
		*jsr	_LVOLendMenus(a6)

.MenusOk:	move.l	WS_Winhandle(a4),a0
		move.l	WD_Userport(a0),a0	;User Port
		move.l	a0,WS_WindowPort(a4)
		moveq	#0,d0

	*--------------- SignalBits setzen ---------------*
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)
		moveq	#0,d0


.SetUpReturn:	movem.l	(sp)+,d1-a6
		tst.l	d0
		rts

.GadgetError	bsr	AG_CloseWindow
.OpenWindowError:bsr	AG_FreeMenus
.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.SetUpReturn


*----------------------------- Lock PubScreen --------------------------------*
* Input: a4=Windowstruct
AG_LockPubScreen:
		movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	IntBase(a5),a6
		lea	EUS_Structure(pc),a0
		move.l	EUS_EPBase(a0),d0
		beq.s	.KeinEP
		move.l	d0,a0
		move.l	EPG_Pubscreen(a0),d0
		*move.w	EPG_Wordreserved7(a0),word7(a5)
.KeinEp:	move.l	d0,a0
		jsr	_LVOLockPubScreen(a6)
		move.l	d0,WS_Pubscreen(a4)
		tst.l	d0
		beq.s	.Return

		move.l	WS_Pubscreen(a4),a0
		move.l	GadBase(a5),a6
		suba.l	a1,a1
		jsr	_LVOGetVisualInfoA(a6)
		move.l	d0,WS_VisualInfo(a4)
		tst.l	d0
		beq.s	.Return
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

*------------------------------ Unlock PubScreen -----------------------------*
* Input: a4=Windowstruct
AG_UnlockPubScreen:
		movem.l	d0-a6,-(a7)
		move.l	GadBase(a5),a6
		move.l	WS_VisualInfo(a4),d0
		beq.s	.NoVisualInfo
		move.l	d0,a0
		jsr	_LVOFreeVisualInfo(a6)
		clr.l	WS_VisualInfo(a4)
.NoVisualInfo:	move.l	IntBase(a5),a6
		suba.l	a0,a0
		move.l	WS_Pubscreen(a4),d0
		beq.s	.NoPublicScreen
		move.l	d0,a1
		jsr	_LVOUnlockPubScreen(a6)
.NoPublicScreen:clr.l	WS_Pubscreen(A4)
		movem.l	(a7)+,d0-a6
		rts

*----------------------------- Window lschen --------------------------------*
* Input: a4=Windowstruct
AG_ClearWindow:	movem.l	d0-a6,-(a7)
		tst.l	WS_WinHandle(a4)
		beq.w	.Return
		tst.l	WS_RastPort(a4)
		beq.w	.Return

		tst.l	DT_PicObject(a5)
		bne	.DT_CopyTiledBitMap

		move.l	GFXBase(a5),a6
		move.l	WS_Winhandle(a4),a1
		move.l	wd_rport(a1),a1
		moveq	#0,d0
		jsr	_LVOsetapen(a6)

		move.l	WS_Winhandle(a4),a1
		move.l	wd_rport(a1),a1
		moveq	#0,d0
		jsr	_LVOsetbpen(A6)

		move.l	WS_Winhandle(a4),a1
		move.l	wd_rport(a1),a1
		moveq	#1,d0			;RP_Jam2
		jsr	_LVOsetdrmd(a6)

		move.b	rp_areaptsz(a1),d4
		move.l	rp_areaptrn(a1),d5

		move.l	WS_Winhandle(A4),a1
		move.w	wd_width(A1),d2		;x2
		moveq	#0,d0
		move.b	wd_borderright(a1),d0
		sub.w	d0,d2

		move.w	wd_height(a1),d3
		moveq	#0,d0
		move.b	wd_borderbottom(a1),d0
		sub.w	d0,d3

		move.l	wd_rport(a1),a1

		move.w	WS_Offx(a4),d0		;x1
		move.w	WS_Offy(a4),d1		;y1
		jsr	_LVOrectfill(a6)
		bra.s	.Refresh

.DT_CopyTiledBitMap:
		move.l	WS_Winhandle(a4),a2
		bsr	FillWithBackPic2

.Refresh:	move.l	WS_Winhandle(a4),a0
		move.l	IntBase(a5),a6
		jsr	_LVORefreshwindowFrame(A6)


.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a4=Windowstruct
AG_CloseWindow:	movem.l d0-a6,-(a7)

		move.l	WS_WinHandle(a4),d0
		beq.s	.Return
		move.l	d0,a0
		move.l	86(a0),a1			;MsgPort des Windows
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)

		move.w	wd_leftedge(a0),WS_WinPosX(a4)
		move.w	wd_topedge(a0),WS_WinPosY(a4)
		move.w	wd_Width(a0),WS_WinWidth(a4)
		move.w	wd_Height(a0),WS_WinHeight(a4)



		move.l	IntBase(a5),a6
		move.l	WS_Winhandle(a4),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOCloseWindow(a6)
.NoWindow:	clr.l	WS_Winhandle(a4)
		clr.l	WS_WindowPort(a4)
		clr.l	WS_RastPort(a4)
		clr.w	WS_WindowDisabled(a4)

		bsr	AG_FreeWindowTitle
		bsr	AG_FreeMenus
		bsr	AG_FreeGadgets
		*bsr	AG_FreeLocale			;nur Hauptwindow

		bsr	AG_UnlockPubScreen
.Return:	*bsr	DT_FreePicture			;nur Hauptwindow
		bsr	ErlaubeGadgets
		movem.l (sp)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a4=Windowstructure								      *
AG_FreeWindowTitle:
		movem.l	d0-a6,-(a7)
		move.l	WS_WindowTitle(a4),d0
		beq.s	.Return
		move.l	d0,a1
		move.l	WS_WindowTitleSize(a4),d0
		EB
		jsr	_LVOFreeMem(a6)
.Return:	clr.l	WS_Windowtitle(a4)
		clr.l	WS_WindowTitleSize(a4)
		movem.l	(a7)+,d0-a6
		rts


*------------------------- Gadgets initialisieren ----------------------------*
* Input: a4=Windowstruct
AG_InitGadgets:	movem.l	d1-a6,-(a7)

		*--- Mem fr Gadgetmerkpuffer allikieren ---*
		tst.l	WS_GadgetMerkPuffer(a4)
		bne.s	.NoGadgets
		move.l	WS_GadgetAnz(a4),d0
		beq.s	.NoGadgets
		lsl.l	#2,d0
		bsr	AllocMem2
		move.l	d0,WS_GadgetMerkPuffer(a4)
		tst.l	d0
		beq.w	.Error

		*----- Zur Verfgung stehende Ausmae berechnen ------*
.NoGadgets:	move.l	WS_WinHandle(a4),d0
		beq.w	.Return
		move.l	d0,a0
		moveq	#0,d6
		moveq	#0,d7
		move.w	WD_Width(a0),d6
		move.w	WD_Height(a0),d7
		moveq	#0,d0
		move.b	WD_BorderBottom(a0),d0
		sub.w	d0,d7				*InnerHeight
		sub.w	WS_OffY(a4),d7
*		sub.l	#GadgetYAbstand*2,d7
		sub.l	#GadgetYAbstand,d7

		move.b	WD_BorderLeft(a0),d0
		sub.w	d0,d6
		move.b	WD_BorderRight(a0),d0
		sub.w	d0,d6				*InnerWidth
		sub.l	#GadgetXAbstand*2,d6


		sub.l	#GadgetYAbstand*2,d7
		moveq	#0,d0
		move.w	WS_FontY(a4),d0
		add.w	#MinTextGadgetYOffset+BevelHohe*2,d0
		sub.l	d0,d7

		*--- GadgetOffsets lschen ---*
		move.l	WS_Gadgets(a4),d0
		beq.s	.Error
		move.l	d0,a0
		move.l	WS_GadgetAnz(a4),d1
		subq.l	#1,d1
		blt.s	.Error
.GadgetClr:	clr.l	(a0)				*Gren lschen
		clr.l	4(a0)
		lea	GNG_SizeOf(a0),a0		*Positionen und
		dbf	d1,.GadgetClr

		*-- Nun ist in d6= MaxWidth und d7=MaxHeight --*
		move.l	WS_InitGadgets(a4),d0
		beq.s	.Error
		move.l	d0,a0
		movem.l	d1-a6,-(a7)
		jsr	(a0)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		bne	.Error

		bsr	AG_CreateGadgets		*d0=Return

.Return:	movem.l	(a7)+,d1-a6
		rts


.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.Return

*-----------------------------------------------------------------------------*
* Input: a4=Windowstruct
* Output:d0=Error oder Null
*-----------------------------------------------------------------------------*
AG_CreateGadgets:
		movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	GadBase(A5),a6
		lea	WS_GadgetListadr(a4),a0
		jsr	_LVOCreateContext(a6)
		move.l	d0,a3
		tst.l	d0
		beq.w	.Error

		moveq	#0,d3
		move.l	WS_GadgetTags(a4),d0
		beq.w	.Error
		move.l	d0,a6
.NextGadget:	move.l	WS_Gadgets(a4),a0
		move.l	d3,d0
		mulu	#GNG_SIZEOF,d0		* +2 wegen Locale !
		add.l	d0,a0
		lea	BufNewGad(a5),a1
		moveq	#GNG_SizeOf,d0
		move.l	a6,-(a7)
		EB
		jsr	_LVOCopyMem(a6)
		move.l	(a7)+,a6
		lea	BufNewGad(a5),a0
		move.l	WS_VisualInfo(a4),GNG_VisualInfo(a0)
		move.l	WS_Font(a4),GNG_TextAttr(a0)

		move.w	GNG_TopEdge(a0),d0
		add.w	WS_OffY(a4),d0
		addq.w	#GadgetYAbstand,d0
		move.w	d0,GNG_TopEdge(a0)

		move.w	GNG_LeftEdge(a0),d0
		add.w	WS_OffX(a4),d0
		add.w	#GadgetXAbstand,d0
		move.w	d0,GNG_LeftEdge(a0)

		move.l	WS_Gadgettypes(a4),d0
		beq.w	.Error
		move.l	d0,a0
		moveq	#0,d0
		move.l	d3,d1
		asl.l	#1,d1
		add.l	d1,a0
		move.w	(a0),d0
		move.l	a3,a0
		move.l	a6,a2

		move.l	WS_CreateGadget(a4),d1
		beq.s	.NoCreate
		move.l	d1,a1
		movem.l	d0-a1/a3-a6,-(a7)
		jsr	(a1)
		movem.l	(a7)+,d0-a1/a3-a6

.NoCreate:	lea	BufNewGad(a5),a1
		move.l	a6,-(a7)
		move.l	GadBase(a5),a6
		jsr	_LVOCreateGadgetA(a6)
		move.l	(a7)+,a6
		tst.l	d0
		beq.s	.Error

		*------- Gadgetadr im Puffer merken --------*
		move.l	d0,a3
		move.l	d3,d0
		asl.l	#2,d0
		move.l	WS_GadgetMerkPuffer(a4),a0
		add.l	d0,a0
		move.l	a3,(a0)

		**--- Gadgetflags bei GetFile setzen ---*
		*move.l	a3,a0
		*move.l	d3,d0
		*asl.l	#1,d0
		*move.l	WS_Gadgettypes(a4),a1
		*add.l	d0,a1
		*cmp.w	#Generic_Kind,(a1)
		*bne.s	.FindTags
		*or.w	#GFLG_GADGIMAGE!GFLG_GADGHIMAGE,gg_Flags(a0)
		*or.w	#GACT_RELVERIFY,gg_Activation(a0)
		*move.l	WS_GetFileObject(a4),gg_GadgetRender(a0)
		*move.l	WS_GetFileObject(a4),gg_SelectRender(a0)


		*--- Start der nchsten Tagliste finden ----*
.FindTags:	tst.l	(a6)
		beq.s	.NochEinGadget
		addq.l	#8,a6
		bra.s	.FindTags

.NochEinGadget:	addq.l	#4,a6
		addq.w	#1,d3
	*cmp.w	#24,d3
	*blo.s	.No
	*nop
.No		cmp.w	WS_GadgetAnz+2(a4),d3
		bmi	.NextGadget
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

.Error:		bsr.w	AG_FreeGadgets
		bra.s	.Return





*-----------------------------------------------------------------------------*
* Input: a4=Windowstruct
AG_AddGads:	movem.l	d0-a6,-(sp)
		tst.l	WS_WinHandle(a4)
		beq.w	.Return
		move.l	WS_GadgetListAdr(a4),d0
		beq.s	.Return
		move.l	d0,a1

		moveq	#0,d1
.count:		move.l	d0,a0
		addq.l	#1,d1
		move.l	(A0),d0
		bne.s	.count
		move.w	d1,WS_RealNumGadgets(a4)

		move.l	IntBase(a5),a6
		move.l	WS_Winhandle(a4),a0
		moveq	#-1,d0
		moveq	#-1,d1
		sub.l	a2,a2
		jsr	_LVOAddGList(a6)


		move.l	WS_AddGadgets(a4),d0
		beq.s	.NoAdd
		move.l	d0,a0
		movem.l	d1-a6,-(a7)
		jsr	(a0)
		movem.l	(a7)+,d1-a6

.NoAdd:		move.l	WS_GadgetListAdr(a4),a0
		move.l	WS_Winhandle(a4),a1
		suba.l	a2,a2
		moveq	#-1,d0
		move.l	IntBase(a5),a6
		jsr	_LVOrefreshglist(a6)

		move.l	GadBase(a5),a6
		move.l	WS_Winhandle(a4),a0
		sub.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)


.Return:	movem.l	(sp)+,d0-a6
		rts





*--------------------------- Gadgets freigeben -------------------------------*
* Input: a4=Windowstruct
AG_FreeGadgets:	movem.l	d0-a6,-(a7)

		move.l	GadBase(a5),a6
		move.l	WS_GadgetListAdr(a4),d0
		move.l	d0,a0
		beq	.NoGadgets
		jsr	_LVOFreeGadgets(a6)
.NoGadgets:	clr.l	WS_GadgetListAdr(a4)


		move.l	WS_FreeGadgets(a4),d0
		beq.s	.NoFree
		move.l	d0,a0
		movem.l	d1-a6,-(a7)
		jsr	(a0)
		movem.l	(a7)+,d1-a6
.NoFree:

		*--- Mem fr Gadgetmerkpuffer freigeben ---*
		move.l	WS_GadgetAnz(a4),d0
		beq.s	.Return
		lsl.l	#2,d0
		move.l	WS_GadgetMerkPuffer(a4),a1
		bsr	FreeMem2
		clr.l	WS_GadgetMerkPuffer(a4)
.Return:
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a4=Windowstruct
AG_FreeMenus:	movem.l	d0-a6,-(a7)
		move.l	IntBase(a5),a6
		move.l	WS_MenuAdr(a4),d0
		move.l	d0,a0
		beq	.NoMenu
		move.l	WS_Winhandle(a4),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOClearMenuStrip(a6)
.NoWindow:	move.l	GadBase(a5),a6
		move.l	WS_MenuAdr(a4),d0
		beq.s	.NoMenu
		move.l	d0,a0
		jsr	_LVOFreeMenus(a6)
.NoMenu:	clr.l	WS_MenuAdr(a4)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a4=Windowstruct
AG_ResizeWindow:movem.l	d0-a6,-(a7)
		move.l	IntBase(a5),a6
		move.l	WS_WinHandle(a4),a0
		jsr	_LVORefreshWindowFrame(a6)

		move.l	WS_GadgetListAdr(a4),d0
		beq.s	.NoGadgets
		move.l	d0,a1
		moveq	#0,d0
		move.w	WS_RealNumGadgets(a4),d0
		move.l	WS_Winhandle(a4),a0
		move.l	Intbase(a5),a6
		jsr	_LVORemoveGList(a6)

.NoGadgets:	bsr	AG_FreeGadgets
		bsr	AG_Clearwindow

		bsr	AG_InitGadgets
		bne.w	.Return

		bsr	AG_AddGads
		bne	.Return

		bsr	ErlaubeGadgets

.Return:	movem.l	(a7)+,d0-a6
		rts














































*------------ verndere die Einstellungen des Listviewgadgets ---------------*
ViewTop:	moveq	#1,d5
		bra.s	SetListView
ViewBotom:	move.l	MaxEntries(a5),d5
		*subq.l	#1,d5
		bra.s	SetListView
ViewUp:		moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		cmp.l	#1,d5
		ble.w	Return
		subq.l	#1,d5
		bra.s	SetListView
ViewDown:	moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		addq.l	#1,d5
		*cmp.l	#1,d5
		*beq.s	SetListView
		cmp.l	MaxEntries(a5),d5
		bhi.w	Return
		bra.s	SetListView

ViewPageUp:	bsr.s	BerechGadAnz
		moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		sub.w	d0,d5
		bhi.s	.IO
		moveq	#1,d5
.Io:		bra.s	SetListView

ViewPageDown:	bsr.w	BerechGadAnz
		moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		add.w	d0,d5
		cmp.l	MaxEntries(a5),d5
		blo.s	.IO
		move.l	MaxEntries(a5),d5
.Io:		bra.w	SetListView


SetListView:	move.l	d5,d0
		bra.w	SetModulesEntry


*-------------- Anzahl der angezeigten Items im Listview berechnen -----------*
BerechGadAnz:	moveq	#EPENr_Moduleslist,d0
		movem.l	d1/a0/a1,-(a7)
		bsr	GetGadgetAdr		*NotFound ?
		bne.s	.Return
		move.l	WinHandle(a5),d0
		move.l	d0,a1
		move.l	50(a1),a1		*Rastport
		move.l	52(a1),a1		*Font
		moveq	#0,d0
		move.w	20(a1),d0		*FontHhe
		moveq	#0,d1
		move.w	10(a0),d1		*Gadgethhe
		divu	d0,d1
		moveq	#0,d0
		move.w	d1,d0
.Return:	movem.l	(a7)+,d1/a0/a1
		rts

*-------------- Anzahl der angezeigten Items im Listview berechnen -----------*
* Input: a4=AGL_Struct
* Output d0=Anz der Items oder NULL
BerechWSGadAnz:	movem.l	d1/a0/a1,-(a7)
		move.l	AGL_Windowstruct(a4),d0
		beq.s	.Return
		move.l	d0,a3
		bsr	GetGadgetAdr2		*NotFound ?
		bne.s	.Return
		move.l	WS_WinHandle(a3),d0
		move.l	d0,a1
		move.l	50(a1),a1		*Rastport
		move.l	52(a1),a1		*Font
		moveq	#0,d0
		move.w	20(a1),d0		*FontHhe
		moveq	#0,d1
		move.w	10(a0),d1		*Gadgethhe
		divu	d0,d1
		moveq	#0,d0
		move.w	d1,d0
.Return:	movem.l	(a7)+,d1/a0/a1
		rts

*-----------------------------------------------------------------------------*
MakeNewList:	move.l	MaxEntries(a5),d0
		beq.s	.Return
		tst.b	ListeChanged(a5)
		beq.s	.New

		moveq	#LENr_RealyNew,d0
		moveq	#LENr_ReallyGadgets,d1
		bsr	TextRequest
		tst.l	d0
		beq.s	.Return
		cmp.l	#2,d0
		bne.s	.New
		bsr	SaveList
		bne.s	.Return
.New:		bsr	FreeList
.Return		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Nummer
*	 a1=Adr des Items !!!!!!!!!!!!!!
*-----------------------------------------------------------------------------*
BackPic:	move.b	MI_Flags(a1),d0
		and	#1,d0

		move.w	PrefsFlags+EUS_Structure(pc),d1
		and.b	#~[PFB_BackPic],d1
		lsl.l	#PFF_BackPic,d0
		or.b	d0,d1
		move.w	d1,PrefsFlags+EUS_Structure

		tst.b	d0
		beq.s	.SetPic
		tst.b	DT_Picturename(A5)			;Test, ob schon Name vorliegt
		bne.s	.SetPic
		lea	DT_PictureDir(a5),a0
		lea	DT_Picturename(a5),a1
		move.w	#LENr_SelectBackPic,d0
		bsr	DT_Filerequest
		bne	.SetPic


		move.l	Winhandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		move.l	a1,-(a7)
		move.l	IntBase(a5),a6
		jsr	_LVOClearMenuStrip(a6)
		move.l	(a7)+,a1
		move	mi_Flags(a1),d0
		and	#~CHECKED,d0
		move	d0,mi_Flags(a1)				;bser,bser Hack...

		move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	_LVOSetMenuStrip(a6)

		moveq	#0,d2
		bra	BackPic

.SetPic:	bsr	LoadNewPicture
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
SelectBackPic:	lea	DT_PictureDir(a5),a0
		lea	DT_Picturename(a5),a1
		move.w	#LENr_SelectBackPic,d0
		bsr	DT_Filerequest
		beq	.Return

		move.w	PrefsFlags+EUS_Structure(pc),d0
		and.b	#PFB_BackPic,d0
		beq	.Return
		bsr	LoadNewPicture
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
About:		moveq	#LENr_AboutText,d0
		moveq	#LENr_Ok,d1
		bsr	TextRequest		;Infotext ausgeben (Requester)
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
Hide:		ifeq	executable+debugger
		move.w	#1,ExitNow(a5)
		moveq	#EPNr_Engine,d0
		bra.w	.Return
		else
		moveq	#0,d1
		moveq	#USClass_Deactivate,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
		endc
.Return:	rts

*-----------------------------------------------------------------------------*
Quit:		*bsr	SaveListBeforeQuitFirst
		move.w	#1,ExitNow(a5)
		bsr	MerkWindowSize
		moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
		rts


*-----------------------------------------------------------------------------*
SaveListBeforeQuitFirst:
		move.l	MaxEntries(a5),d0
		beq.s	.NoEntries

		tst.b	ListeChanged(a5)
		beq.s	.NoEntries

		moveq	#LENr_SaveBeforeQuit,d0
		moveq	#LENr_SaveGadgets,d1
		bsr	TextRequest

	tst.l	d0
	bne.s	.NoEntries
*		tst.l	d0
*		beq.s	.NoEntries
*		cmp.l	#2,d0
*		bne.s	.New
		bsr	SaveList
.New:		bsr	FreeList

		*--- Autorenliste speichern ---*

.NoEntries:	*tst.l	MaxAutors(a5)
		*beq.s	.NoAutors
		*tst.b	ListeChanged(a5)
		*beq.s	.NoAutors
		*moveq	#LENr_SaveAutorsBeforeQuit,d0
		*moveq	#LENr_SaveGadgets,d1
		*bsr	TextRequest
		*tst.l	d0
		*beq.s	.Return
		*cmp.l	#2,d0
		*bne.s	.New_2
		*bsr	SaveAuthors
.New_2:		*bsr	FreeList

.Return:	moveq	#0,d0
		rts


******************************************************************************
*---------------- Auswertung einer UserProgram-Message ----------------------*
******************************************************************************
*
*	Achtung 2. Ausgang der Routine bei Exit !!!!!!!!!!!!
*	Achtung 3. Ausgang der Routine bei UserQuitEagle !!!!!!!!!!!!
*
UserMessage:
		if Executable+Debugger
	;	lea	TextPuffer(a5),a0		;Sicherheitshalber
		move.l	d0,a1
		cmp.l	#USM_UserPrg,UM_Type(a1) ;Test auf Analyzer-MSG
		beq.w	.Auswertung
		cmp.l	#USM_Eagleplayer,UM_Type(a1) ;Test auf Analyzer-MSG
		bne.w	.ReplyIt3

	*--------------- Es ist ein Message angekommen ------------*
.Auswertung:	moveq	#0,d0
		move.w	UM_UserNr(a1),d0

 if debugger
		move.w	UM_UserNr(a1),EUS_Structure+EUS_UserNr
 endc
		move.l	UM_ArgString(a1),UPrg_Struct(a5)
		moveq	#0,d0
		moveq	#0,d7
		move.w	UM_Class(a1),d7
		beq.w	.ReplyIt
		cmp.w	#USClass_NewUserPrg,d7
		beq.w	.NewConfig			;.NewUserPrg
		cmp.w	#USClass_Activate,d7
		beq.w	.Activate
		cmp.w	#USClass_Show,d7
		beq.w	.OpenWindow
		cmp.w	#USClass_DeActivate,d7
		beq.w	.DeActivate
		cmp.w	#USClass_Hide,d7
		beq.w	.CloseWindow
		cmp.w	#USClass_ZipWin,d7
		beq.w	.ZipWindow
		cmp.w	#USClass_UnZipWin,d7
		beq.w	.UnZipWindow
		cmp.w	#USClass_NewConfig,d7
		beq.w	.NewConfig
		cmp.w	#USClass_GetConfig,d7
		beq.w	.GetConfig
		cmp.w	#USClass_Exit,d7
		beq.w	.Exit
		cmp.w	#USClass_SetWaitPointer,d7
		beq.w	.WaitPointer
		cmp.w	#USClass_ClearWaitPointer,d7
		beq.w	.ClearPointer
		cmp.w	#USClass_NewPreference,d7
		beq.w	.NewPreference
		cmp.w	#USClass_NewModule,d7
		beq.w	.NewModule
		cmp.w	#USClass_KillModule,d7
		beq.w	.KillModule
		cmp.w	#USClass_SaveConfig,d7
		beq.w	.SaveConfig
		moveq	#0,d0
		bra.w	.ReplyIt

.KillModule:	move.l	d7,-(a7)
		bsr	TitleAufbau
		move.l	(a7)+,d0
		bra.w	.ReplyIt		;Message replyen

.NewModule:	move.l	d7,-(a7)
		bsr	TitleAufbau

		move.w	EUS_Structure+PrefsFlags(pc),d0
		btst	#PFF_AutoLearnAuthors,d0
		beq.s	.New_Noautor

		move.l	EPBase(pc),a4
		move.l	EPG_Author(a4),d0
		beq.s	.New_NoAutor
		move.l	d0,a0
		tst.b	(a0)
		beq.s	.New_NoAutor
		lea	Autorlist(a5),a4
		bsr	AG_InsertItem
.New_NoAutor:	move.l	(a7)+,d0
		bra.w	.ReplyIt		;Message replyen


	*------- Ankommende Message sagt : "EXIT" -------*
.Exit:		bsr	SaveListBeforeQuitFirst
		move.w	#1,ExitNow(a5)
		move.l	d7,d0
		bra.w	.ReplyIt		;Message replyen

	*----- Es wurde ein neue Config eingestellt -----*
.NewConfig:	move.w	EUS_Structure+EUS_Flags(pc),d0
		btst	#EUSF_Activate,d0
		beq.s	.Deactivate
		btst	#EUSF_Show,d0
		beq.s	.Iconify
		btst	#EUSF_ZipWin,d0
		bne.s	.ZipWindow
		bra.s	.OpenWindow

.Iconify:	bsr	CloseWin
		moveq	#USClass_Hide,d0
		bra.s	.ReplyIt

	*- Der Eagleplayer mchte gerne die Config haben -*
.GetConfig:	bsr	MerkWindowSize
		moveq	#USClass_GetConfig,d0
		bra.s	.ReplyIt



	*------ Ankommende Message sagt : "CLOSE MY WINDOW" -----*
.DeActivate:	moveq	#USClass_DeActivate,d7
.CloseWindow:	move.l	d7,-(a7)
		bsr	CloseWin
		move.l	(a7)+,d0
		bra.s	.ReplyIt

	*------ Angekommende Message sagt : "OPEN MY WINDOW" -----*
.Activate:
.OpenWindow:	move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Iconify,d0
		bne.s	.CloseWindow

		*move.w	EUS_Structure+EUS_Flags(pc),d0
		*btst	#EUSF_Show,d0
		*beq.s	.Activated
		bsr.w	OpenWin
		tst.l	d0
		beq.s	.CloseWindow
.Activated:	moveq	#USClass_Activate,d0
		bra.w	.ReplyIt

		*--- Im Eagleplayer "Help" gedrckt" ----*
.NewPreference:	cmp.l	#EPNr_Help,UM_Command(a1)
		bne.s	.ReplyIt
		bsr	ErlaubeGadgets
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "Zip my Window" -------*
.SaveConfig:	move.l	d7,-(a7)
		bsr	SavePysionConfig
		move.l	(a7)+,d0
		bra.s	.ReplyIt


.WaitPointer:	bsr	WaitPointer
		bra.w	.ReplyIt

.ClearPointer:	bsr	ClearPointer
		bra.w	.ReplyIt


	*------ Ankommende Message sagt : "Zip my Window" -------*
.ZipWindow:	*bsr.w	ZipMyWindow
		moveq	#USClass_ZipWin,d0
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "UnZip my Window" -----*
.UnZipWindow:	*bsr.w	UnZipMyWindow
		moveq	#USClass_UnZipWin,d0


	*------- Message frs Replyen vorbereiten ------*
	*----------------- Class setzen ----------------*
.ReplyIt:	move.l	UPrg_Struct(a5),a0
		bsr.w	FreeCommandStruct
		clr.l	UPrg_Struct(a5)


		move.l	a1,d1
		beq.s	.NoMSG
		clr.l	UM_Argstring(A1)
		move.l	a1,a0
		*move.l	UM_StructAdr(a1),StructAdr(a5)
		move.w	d0,UM_Class(a1)			;Dummy setzen
.ReplyIt3:	move.l	a1,d0
		beq.s	.NoMSG
		move.l	MSgPort(a5),a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.ClearMerk
		EB
		jsr	_LVOReplymsg(a6)
.NoMSG:		rts

.ClearMerk:	subq.l	#1,MsgUnterwegs(a5)
		*bsr	freemsg			;meine Message, also freigeben
	endc
		rts

*-----------------------------------------------------------------------------*
MerkWindowSize:	movem.l	d0-a6,-(a7)
		lea	EUS_Structure(pc),a2
		move.w	EUS_Flags(a2),d0
		bclr	#EUSF_OpenWin,d0		*Flags
		move.l	WinHandle(a5),d1
		beq.s	.GetNoWindow
		or.w	#EUSB_OpenWin,d0

		move.w	WinPosX(a5),eus_winx(a2)	;Save Windowpostion
		move.w	WinPosY(a5),eus_winy(a2)
		move.w	WinWidth(a5),EUS_Special(a2)	;Save Windowpostion
		move.w	WinHeight(a5),EUS_Special+2(a2)
		move.w	ZoomposX(a5),Zoomx(a2)
		move.w	ZoomposY(A5),Zoomy(a2)
		move.b	Zoomstate(a5),ZoomONOFF(a2)
		*move.b	Onsysfont(A5),Sysfontonoff(a2)

.GetNoWindow:	move.w	d0,EUS_Flags(a2)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
WaitPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return
		tst.w	WindowDisabled(a5)
		bne.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	MenuAdr(a5),a1
		if	Executable!Debugger
		jsr	ENPP_SetWaitPointer(a4)
		endc

		move.w	#1,WindowDisabled(a5)

.Return:	movem.l	(sp)+,a0/a1/a4/d0
		rts


*-----------------------------------------------------------------------------*
ClearPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.w	WindowDisabled(a5)
		beq.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	MenuAdr(a5),a1
		if	Executable!Debugger
		jsr	ENPP_ClearWaitPointer(a4)
		endc

.Return:	clr.w	WindowDisabled(a5)
		movem.l	(sp)+,a0/a1/a4/d0
		rts





*------------------------------- TextRequest ---------------------------------*
* Input: d0=LocaleNummer						      *
*	 d1=GadgetLocaleNr
* Output:d0=GadgetNr							      *
*-----------------------------------------------------------------------------*
TextRequest:	movem.l	d1-a6,-(a7)
		bsr	GetLocaleString
		move.l	d0,a1				*Text

		bsr	GetReqToolsBase
		beq.s	.Return


		move.l	d1,d0
		bsr	GetLocaleString
		move.l	d0,a2				*Gadgets

		moveq	#LENr_RequestTitle,d0
		bsr	GetLocaleString

		lea	MyTags(a5),a0
		move.l	#_RT_Window,(a0)+
		move.l	WinHandle(a5),(a0)+
		move.l	#_RT_UnderScore,(a0)+
		move.l	#"_",(a0)+
		move.l	#RTEZ_ReqTitle,(a0)+
		move.l	d0,(a0)+
		clr.l	(a0)

		lea	MyTags(a5),a0			;Tags fr Textrequest
		lea	TextRequestArgs(a5),a4			;APTR to Arglist
		sub.l	a3,a3				;Reqtoolsinfo
		move.l	MyReqToolsBase(a5),a6
	*ifeq	Test
		jsr	_LVOrtEZRequestA(a6)		;ersetzen
	*else
	*	moveq	#0,d0
	*endc
.Return:	movem.l	(sp)+,d1-a6	
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Nummer
* Output:d0=Error oder NULL
*	 a0=Structure oder NULL
*-----------------------------------------------------------------------------*
GetSelectedStruct:
		movem.l	d1-d7/a1-a6,-(a7)
		move.l	SelectedEntry(a5),d0
		beq.s	.Error
		subq.l	#1,d0
		lea	Moduleslist(a5),a0
.GiveStruct:	move.l	(a0),d1
		beq.s	.Error
		move.l	d1,a0
		dbf	d0,.GiveStruct
		lea	-PL_Node(a0),a0
		moveq	#0,d0
.Return:	movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

.Error:		moveq	#-1,d0
		sub.l	a0,a0
		bra.s	.Return

*-----------------------------------------------------------------------------*
* Input: a4=AG_Liste
* Output:d0=Error oder NULL
*	 a0=Structure oder NULL
*-----------------------------------------------------------------------------*
GetSelectedAGStruct:
		movem.l	d1-d7/a1-a6,-(a7)
		move.l	AGL_SelectedEntry(a4),d0
		beq.s	.Error
		subq.l	#1,d0
		lea	AGL_List(a4),a0
.GiveStruct:	move.l	(a0),d1
		beq.s	.Error
		move.l	d1,a0
		dbf	d0,.GiveStruct
		lea	-AGS_Node(a0),a0
		moveq	#0,d0
.Return:	movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

.Error:		moveq	#-1,d0
		sub.l	a0,a0
		bra.s	.Return



*----------------------- Listview-Gadget wurde gedrckt ----------------------*
Listview:	move.l	StartSeconds(a5),d0
		move.l	StartMicros(a5),d1
		move.l	CurrentSeconds(a5),d2
		move.l	CurrentMicros(a5),d3
		move.l	d2,StartSeconds(a5)
		move.l	d3,StartMicros(a5)
		move.l	SelectedEntry(a5),d4
		addq.l	#1,d5
		*move.l	d5,SelectedEntry(a5)


		*--- Wenn Eagleplayer im Helpmode ---*
		*--- Kommando an EP schicken fr  ---*
		*--- Helpnode                     ---*
		cmp.w	d4,d5
		bne.w	.EinfacherKlick
		move.l	IntBase(a5),a6
		jsr	_LVODoubleClick(a6)

	*------ Listviews & Stringgadgets refreshen ------*
		cmp.l	#1,d0			--> Einfacher Klick
		bne.w	.Return
		clr.l	StartSeconds(a5)
		clr.l	StartMicros(a5)

		bsr	PlayModule
		bra.s	.Return

.EinfacherKlick:move.l	d5,d0			--> Nummer
		bsr.w	SetModulesEntry
.Return:	rts




*-----------------------------------------------------------------------------*
* Es wurde ein neuer Eintrag angewhlt.
* Input: d0=Neue Nummer (des angewhlten Labels)
SetModulesEntry:movem.l	d1-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		cmp.l	SelectedEntry(a5),d0
		beq.s	.Return
		move.l	d0,SelectedEntry(a5)


		*--- Gadgets sperren oder erlauben ---*
		*--- Anderen Anzeigelistviews fllen ---*
		subq.l	#1,d0
		lea	MyTags(a5),a3
		move.l	#GTLV_Selected,(a3)+
		move.l	d0,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	d0,(a3)+
		clr.l	(a3)
		moveq	#EPENr_ModulesList,d0
		bsr	GetGadgetAdr
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		bsr	ErlaubeGadgets

.Return:	movem.l	(a7)+,d1-a6
		rts

*-----------------------------------------------------------------------------*
Titleaufbau:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		moveq	#LENr_Windowtitle,d0
		bsr	GetLocaleString
		move.l	d0,a0
		move.w	#TitlePufferSize-2,d1
		lea	TitlePuffer(a5),a1
		bsr	StringCopy

		cmp.l	#10,d1
		blo.s	.Set
		move.l	SelectedEntry(a5),d0
		bsr	Hexdez
		
		moveq	#LENr_Von,d0
		bsr	GetLocaleString
		move.l	d0,a0

		bsr	StringCopy

		cmp.l	#10,d1
		blo.s	.Set
		move.l	MaxEntries(a5),d0
		bsr	Hexdez

.Set:		if	Debugger!Executable
		move.l	EPBase(pc),a2
		move.l	EPG_TitlePuffer(a2),a2
		else
		moveq	#LENr_ScreenTitle,d0
		bsr	GetLocaleString
		move.l	d0,a2
		endc

		lea	TitlePuffer(a5),a1
		move.l	WinHandle(a5),a0
		move.l	INtBase(a5),a6
		jsr	_LVOSetWindowTitles(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Zahl
*	 a1=OutputPuffer
* Output:a1=Ende des Outputpuffers
*-----------------------------------------------------------------------------*
Hexdez:		tst.l	d0
		beq.s	.TypeNull
		movem.l	d0-d4/a0,-(a7)
		lea	hexdeztab(pc),a0
		moveq	#0,d4
		moveq	#9,d3
.HexDez1:	move.l	(a0)+,d1
		moveq	#0,d2
.HexDez2:	addq.l	#1,d2
		sub.l	d1,d0
		bcc.s	.Hexdez2
		add.l	d1,d0
		add.b	#$2f,d2
		cmp.b	#$30,d2
		bne.s	.Printealle
		tst.b	d4
		beq.s	.PrinteNoZiffer
.Printealle:	moveq	#1,d4
		move.b	d2,(a1)+
.PrinteNoZiffer:dbf	d3,.Hexdez1
		clr.b	(a1)
		movem.l	(a7)+,d0-d4/a0
		rts
.TypeNull	move.b	#$30,(a1)+
		clr.b	(a1)
		rts

	*-------- Hilfstabelle fr Hex-Dez-Umwandelung --------*
Hexdeztab:	dc.l	1000000000,100000000,10000000,1000000,100000,10000
		dc.l	1000,100,10,1

*-----------------------------------------------------------------------------*
ErlaubeGadgets:	movem.l	d0-a6,-(a7)
		move.l	WinHandle(a5),d0
		beq.w	.Return

		move.l	d0,a0
		move.l	IntBase(a5),a6
		jsr	_LVOClearMenuStrip(a6)

		*-- Gadgets setzen --*
		lea	.GG-6(pc),a3
.NextGadget:	lea	6(a3),a3
		tst.w	(a3)
		beq.s	.AG_Gadgets
		lea	.GG(pc),a1
		move.w	2(a3),d0
		lea	(a1,d0.w),a1			*d1=Zustand der Nr.

		moveq	#0,d1
		move.l	EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Help,d0
		bne.s	.Help
		move.l	a3,-(a7)
		sub.l	a4,a4
		jsr	(a1)
		move.l	(a7)+,a3
.Help:		move.w	(a3),d0
		bsr	SetzeGadget
		move.w	4(a3),d0
		beq.s	.NextGadget
		bsr	.SetItem
		bra.s	.NextGadget


		*-- Gadgets in AutorGruppenPrefswindow setzen --*
.AG_Gadgets:	lea	Autorwindowstruct(a5),a3
		sub.l	a4,a4
		bsr	.AG_Erlaube
		lea	Gruppenwindowstruct(a5),a3
		sub.l	a4,a4
		bsr	.AG_Erlaube
		lea	FirstPrefswindowstruct-MP_Next(a5),a4
.AG_NextMP:	move.l	MP_Next(a4),d0
		beq.s	.SetMenus
		move.l	d0,a4
		lea	MP_Window(a4),a3
		move.l	a4,-(a7)
		bsr	.AG_Erlaube
		move.l	(a7)+,a4
		bra.s	.AG_NextMP
		

		*--- Menus setzen ---*
.SetMenus:	move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		move.l	IntBase(a5),a6
		jsr	_LVOSetMenuStrip(a6)

.Return:	bsr	Titleaufbau
		movem.l	(a7)+,d0-a6
		rts

	*------------ Menus setzen -------------*
	* Input d0=MenuNr
	*	d1=Zustand 1=Sperren 0=Enablen
.SetItem:	move.w	d0,d2
		and.w	#$1f,d2
		*subq.w	#1,d2
		lea	MenuAdr(a5),a0
.NextMenu:	move.l	(a0),d3
		beq.s	.Ret
		move.l	d3,a0
		dbf	d2,.NextMenu

		move.l	d0,d2
		and.l	#$7e0,d2
		lsr.l	#5,d2
		lea	MU_FirstItem(a0),a0
.NextItem:	move.l	(a0),d3
		beq.s	.Ret
		move.l	d3,a0
		dbf	d2,.NextItem

		move.l	d0,d2
		and.l	#$f800,d2
		cmp.l	#$f800,d2
		beq.s	.NoSubMenu
		lsr.l	#8,d2
		lsr.l	#3,d2
		lea	MI_SubItem(a0),a0
.NextSubItem:	move.l	(a0),d3
		beq.s	.Ret
		move.l	d3,a0
		dbf	d2,.NextSubItem

.NoSubMenu:	move	mi_Flags(a0),d0
		and	#~ITEMENABLED,d0
		tst.w	d1
		bne.s	.Off
		or	#ITEMENABLED,d0
.Off:		move	d0,mi_Flags(a0)				;bser,bser Hack...
.Ret:		rts


* Input: a3=WS_Windowstruct
*	 a4=MP_Struct oder NULL
.AG_Erlaube:	lea	.GG-6(pc),a2
.AG_NextGadget:	lea	6(a2),a2
		tst.w	(a2)
		beq.s	.Ret
		lea	.GG(pc),a1
		move.w	2(a2),d0
		lea	(a1,d0.w),a1			*d1=Zustand der Nr.

		moveq	#0,d1
		move.l	EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Help,d0
		bne.s	.AG_Help
		movem.l	a2-a4,-(a7)
		jsr	(a1)
		movem.l	(a7)+,a2-a4
.AG_Help:	move.w	(a2),d0
		bsr	AG_SetzeGadget
		move.w	4(a2),d0
		beq.s	.AG_NextGadget
		bsr	.SetItem
		bra.s	.AG_NextGadget

* d1=0 -> on
.GG:

	if BetaRelease

		dc.w	EPENr_Autorliste,GGZS_GarNicht-.GG,MNr_Autorliste
		dc.w	EPENr_Synchron,GGZS_GarNicht-.GG,MNr_Synchron
		dc.w	EPENr_AutoLearnAuthors,GGZS_GarNicht-.GG,MNr_AutoLearnAuthors
		dc.w	EPENr_ModulesPrefs,GGZS_GarNicht-.GG,0
		dc.w	EPENr_Gruppenliste,GGZS_GarNicht-.GG,MNr_Gruppenliste
		dc.w	EPENr_ClearModulesPrefs,GGZS_GarNicht-.GG,0
	endc


		dc.w	EPENr_Execute,GGZS_NurMitEntries-.GG,0

		dc.w	EPENr_Delete,GGZS_NurSelectiert-.GG,0
		dc.w	EPENr_New,GGZS_NurMitEntries-.GG,MNr_New
		dc.w	EPENr_SaveList,GGZS_NurMitEntries-.GG,0

	ifeq BetaRelease
		dc.w	EPENr_ClearModulesPrefs,GGZS_ClearPrefs-.GG,0
	endc

	ifeq BetaRelease
		dc.w	EPENr_ModulesPrefs,GGZS_NurSelectiert-.GG,0
	endc
		dc.w	EPENr_Up,GGZS_Up-.GG,0
		dc.w	EPENr_Down,GGZS_Down-.GG,0
		dc.w	EPENr_Top,GGZS_Up-.GG,0
		dc.w	EPENr_Botom,GGZS_Down-.GG,0
		dc.w	EPENr_SaveList,GGZS_NurMitEntries-.GG,MNr_SaveList
		dc.w	EPENr_InsertList,GGZS_NurMitEntries-.GG,MNr_InsertList

	ifeq BetaRelease
		dc.w	EPENr_Gruppenliste,GGZS_NurMitEntries-.GG,MNr_Gruppenliste
	endc
		dc.w	EPENr_FindDouble,GGZS_NurMitEntries-.GG,MNr_FindDouble
		dc.w	EPENr_SortByName,GGZS_NurMitEntries-.GG,MNr_SortByName
		dc.w	EPENr_SortByFName,GGZS_NurMitEntries-.GG,MNr_SortByFName
		dc.w	EPENr_SortByPath,GGZS_NurMitEntries-.GG,MNr_SortByPath
		dc.w	-1,GGZS_NurMitEntries-.GG,MNr_Sortieren

		dc.w	EPENrA_ClrPrefs,GGZS_A_ClearPrefs-.GG,0
		dc.w	EPENrA_Prefs,GGZS_A_Prefs-.GG,0
		dc.w	EPENrA_Delete,GGZS_A_Delete-.GG,0
		dc.w	EPENrA_New,GGZS_A_New-.GG,0

		dc.w	EPENrG_ClrPrefs,GGZS_G_ClearPrefs-.GG,0
		dc.w	EPENrG_Prefs,GGZS_G_Prefs-.GG,0
		dc.w	EPENrG_Delete,GGZS_G_Delete-.GG,0
		dc.w	EPENrG_New,GGZS_G_New-.GG,0


		dc.w	EPENrPE_Delete,GGZS_PE_Delete-.GG,0
		dc.w	EPENrPE_Clear,GGZS_PE_Clear-.GG,0
		dc.w	EPENrPG_Delete,GGZS_PG_Delete-.GG,0
		dc.w	EPENrPG_Clear,GGZS_PG_Clear-.GG,0
		dc.w	0

	if	betarelease
GGZS_GarNicht:
		moveq	#1,d1			*aus
		rts
	endc


GGZS_NurMitEntries:
		moveq	#1,d1			*aus
		move.l	MaxEntries(a5),d0
		beq.s	.Return
		moveq	#0,d1
.Return:	rts

GGZS_NurSelectiert:
		moveq	#1,d1			*aus
		move.l	MaxEntries(a5),d0
		beq.s	.Return
		tst.l	SelectedEntry(a5)
		beq.s	.Return
		moveq	#0,d1
.Return:	rts

GGZS_Up:	moveq	#1,d1
		move.l	MaxEntries(a5),d0
		beq.s	.Return
		tst.l	SelectedEntry(a5)
		beq.s	.Return
		cmp.l	#1,SelectedEntry(a5)
		beq.s	.Return
		moveq	#0,d1
.Return:	rts

GGZS_Down:	moveq	#1,d1
		move.l	MaxEntries(a5),d0
		beq.s	.Return
		tst.l	SelectedEntry(a5)
		beq.s	.Return
		cmp.l	SelectedEntry(a5),d0
		beq.s	.Return
		moveq	#0,d1
.Return:	rts


GGZS_ClearPrefs:
		moveq	#1,d1			*aus
		bsr	GetSelectedStruct
		bne.s	.Return

		move.l	SelectedEntry(a5),d0
		moveq	#MPMNR_Module,d1
		bsr	FindPrefsStruct
		tst.l	d0
		beq.s	.Loeschen

		moveq	#1,d1

		tst.l	PL_MEStruct+MPE_ModulesPrefs(a0)
		beq.s	.Return
.Loeschen:	moveq	#0,d1
.Return:	rts


GGZS_A_ClearPrefs:
		moveq	#1,d1			*aus

		move.l	Autorlist+AGL_SelectedEntry(a5),d0
		moveq	#MPMNR_Autor,d1
		bsr	FindPrefsStruct
		tst.l	d0
		beq.s	.Loeschen

		moveq	#1,d1			*aus
		lea	Autorlist+AGL_List(a5),a4
		bsr	GetSelectedAGStruct
		bne.s	.Return

		lea	AGS_MEStruct(a0),a0
		tst.l	MPE_ModulesPrefs(a0)
		bne.s	.Loeschen
		tst.l	MPE_Eigenschaften(a0)
		beq.s	.Return
.Loeschen:	moveq	#0,d1
.Return:	rts

GGZS_A_Prefs:
GGZS_A_Delete:	moveq	#1,d1
		tst.l	Autorlist+AGL_SelectedEntry(a5)
		beq.s	.Return
		moveq	#0,d1
.Return:	rts

GGZS_A_New:	moveq	#1,d1
		tst.l	Autorlist+AGL_MaxEntries(a5)
		beq.s	.Return
		moveq	#0,d1
.Return:	rts


GGZS_G_ClearPrefs:
		moveq	#1,d1			*aus

		move.l	Gruppenlist+AGL_SelectedEntry(a5),d0
		moveq	#MPMNR_Gruppe,d1
		bsr	FindPrefsStruct
		tst.l	d0
		beq.s	.Loeschen

		moveq	#1,d1			*aus
		lea	Gruppenlist+AGL_List(a5),a4
		bsr	GetSelectedAGStruct
		bne.s	.Return

		lea	AGS_MEStruct(a0),a0
		tst.l	MPE_ModulesPrefs(a0)
		bne.s	.Loeschen
		tst.l	MPE_Eigenschaften(a0)
		beq.s	.Return
.Loeschen:	moveq	#0,d1
.Return:	rts

GGZS_G_Prefs:
GGZS_G_Delete:	moveq	#1,d1
		tst.l	Gruppenlist+AGL_SelectedEntry(a5)
		beq.s	.Return
		moveq	#0,d1
.Return:	rts

GGZS_G_New:	moveq	#1,d1
		tst.l	Gruppenlist+AGL_MaxEntries(a5)
		beq.s	.Return
		moveq	#0,d1
.Return:	rts


GGZS_PE_Delete:	moveq	#1,d1
		move.l	a4,d0
		beq.s	.Return
		tst.l	MP_Enginelist+AGL_SelectedEntry(a4)
		beq.s	.Return
		moveq	#0,d1
.Return:	rts

GGZS_PG_Delete:	moveq	#1,d1
		move.l	a4,d0
		beq.s	.Return
		tst.l	MP_Gruppenlist+AGL_SelectedEntry(a4)
		beq.s	.Return
		cmp.w	#MPMNR_Gruppe,MP_Type(a4)
		beq.s	.Return
		moveq	#0,d1
.Return:	rts

GGZS_PE_Clear:	moveq	#1,d1
		move.l	a4,d0
		beq.s	.Return
		tst.l	MP_Enginelist+AGL_MaxEntries(a4)
		beq.s	.Return
		moveq	#0,d1
.Return:	rts

GGZS_PG_Clear:	moveq	#1,d1
		move.l	a4,d0
		beq.s	.Return
		tst.l	MP_Gruppenlist+AGL_MaxEntries(a4)
		beq.s	.Return
		cmp.w	#MPMNR_Gruppe,MP_Type(a4)
		beq.s	.Return
		moveq	#0,d1
.Return:	rts


*---------------------------- Setze dieses Gadget ----------------------------*
* Input: d0=Nummer des Gadgets
*	 d1=Zustand 0=on 1=off
*-----------------------------------------------------------------------------*
SetzeGadget:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		bsr	GetGadgetAdr			*a0=Gadgetadr
		bne.s	.Return

		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)+
		move.l	d1,(a3)+
		clr.l	(a3)
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
		
.Return:	movem.l	(a7)+,d0-a6
		rts

*---------------------------- Setze dieses Gadget ----------------------------*
* Input: d0=EPNr_Nummer des Gadgets
*	 d1=Zustand 0=on 1=off
*	 a3=WS_WindowStruct
*-----------------------------------------------------------------------------*
AG_SetzeGadget:	movem.l	d0-a6,-(a7)
		tst.l	WS_WinHandle(a3)
		beq.s	.Return

		bsr	GetGadgetAdr2			*a0=Gadgetadr
		bne.s	.Return

		lea	MyTags(a5),a2
		move.l	#GA_Disabled,(a2)+
		move.l	d1,(a2)+
		clr.l	(a2)
		move.l	WS_Winhandle(a3),a1
		lea	MyTags(a5),a3
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*---------------------------- Setze dieses Gadget ----------------------------*
* Input: d0=EPNr_Nummer des Gadgets
*	 a0=String
*	 a3=WS_WindowStruct
*-----------------------------------------------------------------------------*
AG_SetzeStringGadget:
		movem.l	d0-a6,-(a7)
		tst.l	WS_WinHandle(a3)
		beq.s	.Return
		move.l	a0,d1

		bsr	GetGadgetAdr2			*a0=Gadgetadr
		bne.s	.Return

		lea	MyTags(a5),a2
		move.l	#GTST_String,(a2)+
		move.l	d1,(a2)+
		clr.l	(a2)
		move.l	WS_Winhandle(a3),a1
		lea	MyTags(a5),a3
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
UpdateMenus:	movem.l	d0-a6,-(a7)
		move.w	EUS_Structure+PrefsFlags(pc),d0

		move.w	#CHECKIT!Menutoggle,d1
		btst	#PFF_Synchron,d0
		beq.s	.NoSynchron
		or.w	#CHECKED,d1
.NoSynchron:	move.w	d1,SynchronFlags

		move.w	#CHECKIT!Menutoggle,d1
		btst	#PFF_Overwrite,d0
		beq.s	.NoOverwrite
		or.w	#CHECKED,d1
.NoOverwrite:	move.w	d1,SynchronFlags

		move.w	#CHECKIT!Menutoggle,d1
		btst	#PFF_BackPic,d0
		beq.s	.NoBackPic
		or.w	#CHECKED,d1
.NoBackPic:	move.w	d1,BackPicFlags

		move.w	#CHECKIT!Menutoggle,d1
		btst	#PFF_LoadAtStart,d0
		beq.s	.NoLoadAtStart
		or.w	#CHECKED,d1
.NoLoadAtStart:	move.w	d1,LoadAtStartFlags

		move.w	#CHECKIT!Menutoggle,d1
		btst	#PFF_HideAll,d0
		beq.s	.NoHideAll
		or.w	#CHECKED,d1
.NoHideAll:	move.w	d1,HideAllFlags

		move.w	#CHECKIT!Menutoggle,d1
		btst	#PFF_AutoLearnAuthors,d0
		beq.s	.NoLearnAuthors
		or.w	#CHECKED,d1
.NoLearnAuthors:move.w	d1,AutoLearnAuthorsFlags

		move.w	#CHECKIT!CHECKED,d1
		move.w	#CHECKIT,d2
		move.w	#CHECKIT,d3
		btst	#PFF_ShowPath,d0
		beq.s	.NoShowPath
		and.w	#~CHECKED,d1
		or.w	#CHECKED,d3
.NoShowPath:	btst	#PFF_ShowName,d0
		beq.s	.NoName
		and.w	#~CHECKED,d1
		and.w	#~CHECKED,d3
		or.w	#CHECKED,d2
.NoName:	move.w	d1,ShowByFNameFlags
		move.w	d2,ShowByNameFlags
		move.w	d3,ShowByPathFlags


		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
OpenWin:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5
		tst.l	WinHandle(a5)
		bne.s	.WindowDa

		st	LastWidth(a5)
		st	LastHeight(a5)

		bsr	UpdateMenus

		move.l	Intbase(a5),a6
		bsr	LockPubscreen		;Public Screen holen
		bne	.Error
		bsr	SetUpWin		;Fenster ffnen
		tst.l	d0
		bne.w	.Error

		*bsr	DeletelistNodes
		*bsr	MakeList

.Error:	
.WindowDa	move.l	WinHandle(a5),d0
		movem.l	(a7)+,d1-a6
		rts


*-----------------------------------------------------------------------------*
* Fenster ffnen, mit Menu & Gadgets sowie Sizeanpassung		      *
* Input: --								      *
* Output: d0=Error oder NULL						      *
*-----------------------------------------------------------------------------*
SetUpWin:	movem.l d1-a6,-(sp)

		bsr	InitLocale


		move.l	MyPubscreen(a5),d0
		beq.w	.Error
		move.l	d0,a0
		move.l	SC_Font(a0),a1
		move.w	TA_YSize(a1),d3
		addq.w	#1,d3
		move.b	sc_WBorTop(a0),d0
		ext.w	d0
		add.w	d3,d0
		move.w	d0,OffY(a5)

		move.b  SC_WBorLeft(a0),d0
		ext.w   d0
		move.w	d0,Offx(a5)

		move.l	sc_RastPort+rp_Font(a0),a0
		lea	MyFont(a5),a1
		move.l	a1,Font(a5)
		move.l  LN_Name(a0),ta_Name(a1)
		move.w  tf_YSize(a0),ta_YSize(a1)
		move.w  tf_XSize(a0),FontX(a5)
		move.w  tf_YSize(a0),FontY(a5)
		clr.w	6(a1)


		bsr	BerechMinWindowSize


	*--------------- Gre des Fensters festlegen --------------*
		moveq	#0,d2
		moveq	#0,d3
		move.w	EUS_Structure+EUS_Special(pc),d2
		move.w	EUS_Structure+EUS_Special+2(pc),d3
		bne.s	.NimmDiese

		moveq	#0,d0			*Keine Eintragung
		move.w	FontY(a5),d0		*--> Fonthhe *6
		mulu	#6,d0
		add.w	d0,d3
		move.l	#200,d2

		*----- Ist diese Gre erlaubt ? -----*
.NimmDiese:	cmp.w	Win_MinHeight+2(pc),d3
		bhi.s	.HeightOk
		move.l	Win_MinHeight(pc),d3
.HeightOk:	cmp.w	Win_MinWidth+2(pc),d2
		bhi.s	.WidthOk
		move.l	Win_MinWidth(pc),d2
.WidthOk:	move.l	mypubscreen(A5),a0
		move.l	d2,ahawidth
		move.l	d3,ahaheight

		*--- Pat Window in Screen ---*
		move.l	d2,d0
		move.l	d0,d4
		moveq	#0,d2
		add.w	d2,d0
		add.w	OffX(a5),d0
		move.b	sc_WBorRight(a0),d1
		ext.w	d1
		add.w	d1,d0
		cmp.w	sc_Width(a0),d0
		bls.s	.WinWidthOk
		move.w	sc_Width(a0),d0
		sub.w	d4,d0
		move.w	d0,d2			*-> nein, jetzt
.WinWidthOk:	move.l	d3,d0
		move.l	d0,d4

		*-- Menus creieren ---*
		move.l	GadBase(a5),a6
		lea	Menus(pc),a0
		lea	MenuTags(pc),a1
		jsr	_LVOCreateMenusA(a6)
		move.l	d0,MenuAdr(a5)
		tst.l	d0
		beq	.Error
		move.l	d0,a0
		move.l	VisualInfo(a5),a1
		lea	MenuTags(pc),a2
		jsr	_LVOLayoutMenusA(a6)

		moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		moveq	#0,d7
		move	WinPosX(a5),d0
		move	WinPosY(a5),d1
		move	ZoomPosX(a5),d2
		move	ZoomPosY(a5),d3
		move.l	ahawidth(pc),d4
		move.l	ahaheight(pc),d5
		*move.l	#ZoomWidth,d6

		move.l	mypubscreen(A5),a0
		lea	sc_RastPort(a0),a0
		move.l	rp_Font(a0),a0
		move.w  tf_XSize(a0),d6
		mulu	#ZoomWidth,d6
		addq	#4,d6
		lsr	#3,d6
		move	OffY(a5),d7
		tst.b	ZoomState(a5)
		beq.s	.Normal
		exg.l	d0,d2
		exg.l	d1,d3
		exg.l	d4,d6
		exg.l	d5,d7
.normal:	lea	WindowTags(pc),a1
		move.l	d0,Win_LeftPos-WindowTags(A1)
		move.l	d1,Win_TopPos-WindowTags(A1)
		move.l	d4,Win_Width-WindowTags(A1)
		move.l	d5,Win_Height-WindowTags(A1)
		move.w	d2,ZoomStruct-WindowTags(A1)
		move.w	d3,ZoomStruct+2-WindowTags(A1)
		move	d6,ZoomStruct+4-WindowTags(A1)
		move	d7,ZoomStruct+6-WindowTags(A1)

		move.l	IntBase(A5),a6
		move.l	MyPubScreen(a5),Pubadr-WindowTags(a1)
		suba.l	a0,a0
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,Winhandle(a5)
		tst.l	d0
		beq	.OpenWindowError

		move.l	WinHandle(a5),a0
		move.w	wd_leftedge(a0),WinPosX(a5)
		move.w	wd_topedge(a0),WinPosY(a5)
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)

		move.l	d0,a0
		move.l	WD_RPort(a0),a0
		move.l	a0,MyRastPort(a5)

		bsr	InitBackdrop


		if	BackPicture
		bsr	ClearWindow
		endc

		bsr	InitGadgets
		bne	.GadgetError
		bsr	AddGads
		bne	.GadgetError

		bsr	ErlaubeGadgets


		move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	_LVOSetMenuStrip(a6)

		move.l	Winhandle(a5),a0
		move.l	WD_Userport(a0),a0	;User Port
		move.l	a0,WindowPort(a5)
		moveq	#0,d0

	*--------------- SignalBits setzen ---------------*
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)
		moveq	#0,d0


.SetUpReturn:	movem.l	(sp)+,d1-a6
		tst.l	d0
		rts

.GadgetError	bsr	Closedownwindow
.OpenWindowError:bsr	FreeMenus
.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.SetUpReturn




*----------------------------- Window lschen --------------------------------*
ClearWindow:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.w	.Return
		tst.l	MyRastPort(a5)
		beq.w	.Return

		tst.l	DT_PicObject(a5)
		bne	.DT_CopyTiledBitMap

		move.l	GFXBase(a5),a6
		move.l	Winhandle(a5),a1
		move.l	wd_rport(a1),a1
		moveq	#0,d0
		jsr	_LVOsetapen(a6)

		move.l	winhandle(A5),a1
		move.l	wd_rport(a1),a1
		moveq	#0,d0
		jsr	_LVOsetbpen(A6)

		move.l	winhandle(A5),a1
		move.l	wd_rport(a1),a1
		moveq	#1,d0			;RP_Jam2
		jsr	_LVOsetdrmd(a6)

		move.b	rp_areaptsz(a1),d4
		move.l	rp_areaptrn(a1),d5

		move.l	winhandle(A5),a1
		move.w	wd_width(A1),d2		;x2
		moveq	#0,d0
		move.b	wd_borderright(a1),d0
		sub.w	d0,d2

		move.w	wd_height(a1),d3
		moveq	#0,d0
		move.b	wd_borderbottom(a1),d0
		sub.w	d0,d3

		move.l	wd_rport(a1),a1

		move.w	Offx(a5),d0		;x1
		move.w	Offy(A5),d1		;y1
		jsr	_LVOrectfill(a6)
		bra.s	.Refresh

.DT_CopyTiledBitMap:
		bsr	FillWithBackPic

.Refresh:		move.l	winhandle(A5),a0
		move.l	IntBase(a5),a6
		jsr	_LVORefreshwindowframe(A6)



.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
SavePysionConfig:
		movem.l	d1-a6,-(a7)

	ifeq	test
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Configdir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		lea	ConfigName(pc),a1
		move.l	a1,d1
		move.l	#1006,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Return

	*----------- Nun Config Schritt fr Schritt speichern ---------*
		lea	ConfigDatas(a5),a0
		move.l	#ConfigDatasEnd-ConfigDatas,d3
		move.l	d6,d1
		move.l	a0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOWrite(a6)

		*--- Datei Closen ---*
		move.l	d6,d1
		beq.s	.AllesOk
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
LoadPysionConfig:
		movem.l	d1-a6,-(a7)

	ifeq	test
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Configdir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		lea	ConfigName(pc),a1
		move.l	a1,d1
		move.l	#1005,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Return

	*----------- Nun Config laden ---------*
		lea	ConfigDatas(a5),a0
		move.l	#ConfigDatasEnd-ConfigDatas,d3
		move.l	d6,d1
		move.l	a0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)

		*--- Datei Closen ---*
		move.l	d6,d1
		beq.s	.AllesOk
		move.l	d0,-(a7)
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)
		move.l	(a7)+,d1
		moveq	#EPR_ErrorInFile,d0
		cmp.l	d0,d3
		bne.s	.Return

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Init Backdrop (fr OpenWindow)
*-----------------------------------------------------------------------------*
InitBackdrop:	movem.l	d0-a6,-(a7)

	*-------- Halfshine Pen fr Hintergrund anfordern oder Pic Init ----------------*
		move.l	#-1,mypen(A5)

		move.w	PrefsFlags+EUS_Structure(pc),d0
		and.b	#PFB_BackPic,d0		;Bit 1 = Back Pic
		beq.s	.pen

		bsr	DT_OpenPicture		;Bild ffnen
		bne.s	.Return			;bei Fehler dann doch Pen
.pen
		move.l	GFXBase(A5),a6
		cmp.w	#39,lib_version(A6)
		blo	.Return

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		move.l	a0,mycmap(A5)
		moveq	#-1,d0			;Number
		move.l	#123<<24,d1		;Red
		move.l	#123<<24,d2		;Green
		move.l	#123<<24,d3		;Blue

		lea	Mytags(A5),a1
		move.l	#OBP_Precision,(a1)
		move.l	#PRECISION_GUI,4(a1)
		clr.l	8(A1)
		jsr	_LVOObtainBestPenA(A6)
		move.l	d0,MyPen(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a2=WinHandle
FillWithBackPic:move.l	Winhandle(a5),a2
FillWithBackPic2:
;void CopyTiledBitMap(void)
;Slow but Mem-Saving routine
.DT_CopyTiledBitMap:
		push	d1-d7/a1/a3/a4/a6
		move.l	GFXBase(a5),a6

		*move.l	Winhandle(A5),a0
		move.l	a2,a0

		moveq	#0,d0
		moveq	#0,d1
		move.w	wd_width(a0),d0
		move.b	wd_borderleft(A0),d1
		add.b	wd_borderRight(A0),d1
		sub.l	d1,d0
		move.l	d0,DT_Breit2(A5)
		
		move.w	wd_height(a0),d0
		move.b	wd_bordertop(A0),d1
		add.b	wd_borderbottom(A0),d1
		sub.l	d1,d0
		move.l	d0,DT_Hoehe2(A5)

		moveq	#0,d0
		move.b	wd_borderleft(a0),d0
		move.l	d0,DT_XPos2(a5)

		move.b	wd_borderTop(a0),d0
		move.l	d0,DT_YPos2(a5)

		move.l	DT_MyBitMapheader(a5),a0
		moveq	#0,d0
		move.w	(a0)+,d0
		move.l	d0,a4			; SrcSizeX
		move.w	(a0),d0
		move.l	d0,a3			; SrcSizeY

		moveq	#256-$c0,d6
		neg.b	d6

	*	move.l	Winhandle(A5),a1
	move.l	a2,a1
		move.l	WD_Rport(a1),a1
		move.l	a1,-(sp)

		moveq	#0,d2				; dest x
		moveq	#0,d3				; dest y
.MainLoop
		move.l	a4,d4				; SrcSizeX

		move.l	d2,d7				; dest x
		cmp.l	DT_Breit2(A5),d7		; Row copied ?
		blt.s	.Xweit
		add.l	a3,d3				; Yup, next Row
		moveq	#0,d2				; dest x
		moveq	#0,d7
.XWeit
		add.l	d4,d7				; pos x + SrcSizeX
		cmp.l	DT_Breit2(a5),d7		; dest x (left) < DestX+SrcSizeX ?
		blt.s	.skip1
		move.l	DT_Breit2(A5),d4		; DestSizeX
		sub.l	d2,d4				; - Dest X = Dest Left
.skip1		
		move.l	a3,d5
		move.l	d3,d7
		cmp.l	DT_Hoehe2(A5),d7
		bge.s	.YReady
		add.l	d5,d7				; pos y + SrcSizeY
		cmp.l	DT_Hoehe2(a5),d7		; dest y (left) < DestY+SrcSizeY ?
		blt.s	.skip2
		move.l	DT_Hoehe2(A5),d5		; DestSizeY
		sub.l	d3,d5				; - Dest Y = Dest Left
.skip2
		add.l	DT_XPos2(A5),d2			; Xpos + Winborder
		add.l	DT_YPos2(A5),d3			; YPos + Winborder
		move.l	(sp),a1
		move.l	DT_MyBitMap(a5),a0		; Source
		moveq	#0,d0
		moveq	#0,d1
		jsr	_LVOBltBitMapRastport(a6)
		sub.l	DT_XPos2(A5),d2			; del Border
		sub.l	DT_YPos2(A5),d3			; del Border
		add.l	a4,d2
		bra.s	.Mainloop

.YReady:	addq.l	#4,sp
		pop	d1-d7/a1/a3/a4/a6
		rts


*-----------------------------------------------------------------------------*
LoadNewPicture:	movem.l	d0-a6,-(a7)

	*-------- Bild freigeben (wenn vorhanden) -----------------------*
.RetryPic:	bsr	DT_FreePicture

	*-------- Halfshine Pen fr Gadgets freigeben -------------------*
		move.l	GFXBase(a5),a6
		cmp.w	#39,lib_version(A6)
		blo	.kick20
		move.l	mypen(A5),d0
		move.l	mycmap(A5),a0
		jsr	_LVOReleasepen(A6)

	*-------- Halfshine Pen fr Hintergrund anfordern oder Pic Init ----------------*
.Kick20		move.l	#-1,mypen(A5)

		move.w	EUS_Structure+PrefsFlags(pc),d0
		and.w	#PFB_BackPic,d0		;Bit 1 = Back Pic
		beq.s	.pen

		bsr	DT_OpenPicture		;Bild ffnen
		bne.s	.kick2			;bei Fehler dann doch Pen
.pen
		move.l	GFXBase(a5),a6
		cmp.w	#39,lib_version(a6)
		blo	.kick2

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		move.l	a0,mycmap(a5)
		moveq	#-1,d0			;Number
		move.l	#123<<24,d1		;Red
		move.l	#123<<24,d2		;Green
		move.l	#123<<24,d3		;Blue

		lea	mytags(A5),a1
		move.l	#OBP_Precision,(a1)
		move.l	#PRECISION_GUI,4(a1)
		clr.l	8(A1)
		jsr	_LVOObtainBestPenA(A6)
		move.l	d0,MyPen(A5)
.Kick2		bsr	Resizewindow
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Gibt des Backpic frei
DT_FreePicture:	movem.l	d0-a6,-(a7)

		move.l	DT_PicObject(A5),d0
		beq.s	.fail
		move.l	DatatypesBase(a5),a6
		move.l	d0,a0
		jsr	_LVODisposeDTObject(a6)
		clr.l	DT_PicObject(A5)
		clr.l	DT_MyBitMapheader(a5)
		clr.l	DT_MyBitMap(a5)
.fail		moveq	#0,d0
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input:	d0=LocaleNr fr Title des Requesters
*		a0=Dir
*		a1=Filename
* Output:d0=Null=Error d0<>0 ok (MultiSelectZeiger)
*-----------------------------------------------------------------------------*
DT_MultiFileRequest2:
		movem.l	d1-a6,-(a7)
		move.l	#FREQF_MULTISELECT,d6
		bra.s	DT_FileReq2

DT_MultiFileRequest:
		movem.l	d1-a6,-(a7)
		move.l	#FREQF_MULTISELECT!FREQF_SELECTDIRS,d6
		bra.s	DT_FileReq2

DT_Filerequest:	movem.l	d1-a6,-(a7)
		moveq	#0,d6
DT_FileReq2:

	move.l	a0,a3
	move.l	a1,a2
	move.l	d0,d4
		bsr	GetReqToolsBase
		beq.s	.Return

		sub.l	a0,a0
		moveq	#0,d0				;Struktur-Type
		jsr	_LVORTAllocRequestA(a6)
		move.l	d0,d7
		beq.s	.fail

		lea	mytags(A5),a0
		move.l	#_RTFI_Dir,(A0)+
		move.l	a3,(a0)+
		clr.l	(A0)	
		lea	mytags(A5),a0
		move.l	d7,a1
		jsr	_LVORTchangereqattrA(A6)

		move.l	d4,d0
		bsr	GetLocaleString
		move.l	a3,-(a7)
		move.l	d0,a3
		lea	mytags(A5),a0
		move.l	#_RT_Window,(a0)+
		move.l	winhandle(a5),(a0)+
		tst.l	d6
		beq.s	.NoFlags
		move.l	#_RTFI_Flags,(a0)+
		move.l	d6,(a0)+
.NoFlags:
	;	move.l	#_RT_LockWindow,(a0)+
	;	move.l	#1,(a0)+
		clr.l	(A0)
		lea	mytags(A5),a0
		move.l	d7,a1
		jsr	_LVORTFilerequestA(A6)
		move.l	(a7)+,a3
		move.l	d0,d6

		move.l	d7,a0
		move.l	rtfi_Dir(a0),a0
		lea	(a3),a1
		move.w	#200-1,d1
		bsr	StringCopy

		move.l	d7,a1
		jsr	_LVORTFreerequest(A6)
		move.l	d6,d0

.Fail:
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Filelist
*-----------------------------------------------------------------------------*
FreeFileList:	movem.l	d0-a6,-(a7)
		move.l	a0,d0
		beq.s	.Return
		bsr	GetReqToolsbase
		beq.s	.return
		jsr	_LVORTFreeFileList(a6)
.Return:	movem.l	(a7)+,d0-a6
		rts


*------------------------- Stringgadget fr Mainwindow ----------------------*
*-----	d0 = Flags 0=Ziffern 1=Text !2=Invisible			-----*
*-----  d1 = MinValue (bei Ziffern)					-----*
*-----	d2 = max. Lnge des Strings oder MaxValue			-----*
*-----	a0 = Puffer fr Text oder ZellenAdr				-----*
*-----	a1 = TextFmT							-----*
*-----  a2 = TextFmtArgs						-----*
*-----	a3 = Requestertitle						-----*
*-----  a4 = WS_Windowstruct
*----- Output:								-----*
*-----	d0 = Ergebnis 0=Ok, sonst Error					-----*
*-----  d1 = Anzahl der eingebenen Zeichen oder Value			-----*
*----------------------------------------------------------------------------*
StringGadget:	movem.l	d2-a6,-(a7)
		move.l	d0,d3
		move.l	d1,d4
		moveq	#0,d0
		moveq	#0,d1

		move.l	d2,d5
		move.l	a0,d7
		move.l	a1,d6
		*move.l	#EUT_StringGadget,d0
		*jsr	A5UserCallUp3(a5)
		*bne.w	.Ok

		bsr	GetReqToolsBase
		bne.s	.LibOk
		moveq	#EPR_CantFindReqTools,d0
		bra.w	.Ok


	*--------- internes StringGadget ----------*
.LibOk:		move.l	a3,d0
		bne.s	.TitleOk
		moveq	#LENr_RequestTitle,d0
		bsr	GetLocaleString
		move.l	d0,a3

.Titleok:	lea	MyTags(a5),a0
		move.l	#$80000001,(a0)+		;_RT_Window

		move.l	WinHandle(a5),d0
		tst.l	WS_WinHandle(a4)
		beq.s	.WinHandleOk
		move.l	WS_WinHandle(a4),d0
.WinHandleOk:	move.l	d0,(a0)+
		move.l	#$80000026,(a0)+		*TextFmt
		move.l	d6,(a0)+
		move.l	#$80000027,(a0)+		*TextFmtArgs
		move.l	a2,(a0)+
		move.l	#$80000050,(a0)+		*AllowEmpty
		move.l	#1,(a0)+
		btst	#EPTRF_Invisible,d3
		beq.s	.NoInvisible
		move.l	#$80000024,(a0)+		*Invisible
		move.l	#1,(a0)+
.NoInvisible:	btst	#EPTRF_Center,d3
		beq.s	.NoCenter
		move.l	#$80000064,(a0)+		*CenterText
		move.l	#1,(a0)+
.NoCenter:	move.l	#$8000000B,(a0)+		*Underscore
		move.l	#"_",(a0)+
		btst	#0,d3
		bne.s	.NoZahl
		tst.l	d5
		beq.s	.NoZahl
		move.l	#$8000001e,(a0)+		*MinLong
		move.l	d4,(a0)+
		move.l	#$8000001f,(a0)+		*MaxLong
		move.l	d5,(a0)+
.NoZahl:	clr.l	(a0)

	bsr	WaitPointer

		move.l	d7,a1				*Puffer
		move.l	d5,d0				*MaxChars
		move.l	a3,a2				*Title
		sub.l	a3,a3				*Reqtoolsinfo
		lea	MyTags(a5),a0
		btst	#EPTRF_Zahl,d3
		bne.s	.Long
		jsr	_LVOrtgetstringA(a6)	;d0=1 --> ok
		bra.s	.ReqOk
.Long:		jsr	_LVOrtgetlongA(a6)	;d0=1 --> ok
.ReqOk:
	bsr	ClearPointer

		tst.l	d0
		beq.s	.Error
		moveq	#0,d0
		move.l	(a4),d1
		bra.s	.Ok

.Error:		moveq	#EPR_FileReqCancelled,d0
		bra.s	.Ok

.NoGui:		moveq	#EPR_CantAddGadget,d0
.Ok:		movem.l	(a7)+,d2-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
DT_OpenPicture:	movem.l	d1-a6,-(a7)

		moveq	#0,d0
		move.l	winhandle(a5),d0
		beq.w	.fail

		move.l	DT_PicObject(a5),d1
		bne.w	.Attrok


		move.l	DatatypesBase(a5),d0
		bne.w	.Ok
		lea	Datatypesname(pc),a1
		moveq	#39,d0
		EB
		jsr	_LVOopenlibrary(a6)
		move.l	d0,DatatypesBase(a5)
		tst.l	d0
		beq.w	.Fail
.Ok:


		lea	DT_Picture(a5),a0
		lea	DT_Picturedir(a5),a1
.copy		move.b	(a1)+,(a0)+
		bne.s	.copy
		subq.l	#1,a1

		lea	DT_Picture(a5),a0
		move.l	a0,d1
		lea	DT_Picturename(a5),a0
		move.l	a0,d2
		move.l	#300,d3
		move.l	DosBase(a5),a6
		jsr	_LVOAddPart(A6)

		move.l	DatatypesBase(a5),a6
		lea	mytags(A5),a0
		move.l	#DTA_Sourcetype,(a0)+
		move.l	#DTST_File,(a0)+
		move.l	#DTA_GroupID,(a0)+
		move.l	#GID_Picture,(a0)+
		move.l	#PDTA_Remap,(a0)+
		move.l	#1,(a0)+
		move.l	#PDTA_Screen,(a0)+
		move.l	winhandle(A5),a1
		move.l	wd_WScreen(a1),(a0)+
		move.l	#PDTA_FreeSourceBitMap,(a0)+
		move.l	#1,(a0)+
		move.l	#OBP_Precision,(a0)+
		move.l	#Precision_IMAGE,(A0)+
		clr.l	(a0)+
		lea	mytags(A5),a0

		*ifne	test
		*lea	DT_PicName(pc),a1
		*else
		lea	DT_Picture(a5),a1
		*endc
		move.l	a1,d0
		jsr	_LVONewDTObjectA(A6)
		move.l	d0,DT_PicObject(A5)
		beq.w	.fail

		move.l	#1,-(a7)		;Taglist ??
		move.l	#0,-(a7)		;
		move.l	#DTM_ProcLayout,-(a7)	;
		push	d0
		bsr	_DoMethod	
		add	#4*4,sp
		tst.l	d0
		beq	DT_FreePicture

		lea	mytags(A5),a2
		move.l	#PDTA_BitMapHeader,(a2)+
		lea	DT_MyBitMapheader(a5),a0
		move.l	a0,(a2)+
		move.l	#PDTA_DestBitMap,(a2)+
		lea	DT_MyBitMap(a5),a0
		move.l	a0,(A2)+
		clr.l	(A2)
		lea	mytags(A5),a2
		move.l	DT_PicObject(A5),a0
		move.l	DatatypesBase(a5),a6
		jsr	_LVOGetDTAttrsA(A6)
		cmp.l	#1,d0
		blt	DT_FreePicture
		tst.l	DT_MyBitMap(A5)
		bne.s	.attrok

		lea	mytags(A5),a2
		move.l	#PDTA_BitMap,(a2)+
		lea	DT_MyBitMap(a5),a0
		move.l	a0,(A2)+
		clr.l	(A2)
		lea	mytags(A5),a2
		move.l	DT_PicObject(A5),a0
		jsr	_LVOGetDTAttrsA(A6)
		tst.l	DT_MyBitMap(A5)
		beq	DT_FreePicture
.attrok:	moveq	#1,d0
.fail		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

;ULONG DoMethod( Object *obj, unsigned long MethodID, ... ); from Amiga.lib
_DoMethod:	move.l	a2,-(sp)
		movea.l	8(sp),a2		;*obj
		move.l	a2,d0
		beq.s	.cmnullreturn
		lea	12(sp),a1		;methodid, ...
		movea.l	-4(a2),a0
		pea	.cmreturn(pc)
		move.l	8(a0),-(sp)
		rts
.cmnullreturn:	moveq	#0,d0
.cmreturn:	movea.l	(sp)+,a2
		rts


*-----------------------------------------------------------------------------*
ResizeWindow:	movem.l	d0-a6,-(a7)
		move.l	IntBase(a5),a6
		move.l	WinHandle(a5),a0
		jsr	_LVORefreshWindowFrame(a6)

		move.l	GadgetListAdr(a5),d0
		beq.s	.NoGadgets
		move.l	d0,a1
		moveq	#0,d0
		move.w	RealNumGadgets(a5),d0
		move.l	Winhandle(a5),a0
		move.l	Intbase(a5),a6
		jsr	_LVORemoveGList(a6)
.NoGadgets:	bsr	FreeGadgets
		bsr	Clearwindow
		bsr	InitGadgets
		bne.w	.Return
		bsr	AddGads
		bsr	ErlaubeGadgets
		*bne	.Return
		*bsr	EinTragNeu
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
Closewin:	movem.l	d0-a6,-(a7)
		lea	Puffer,a5
		tst.l	WinHandle(a5)
		beq.s	.KeinWindow
		bsr	MerkWindowSize
		bsr	Closedownwindow
.KeinWindow:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
Closedownwindow:movem.l d0-a6,-(a7)

		*-- Gruppenwindow schlieen --*
		lea	Gruppenwindowstruct(a5),a4
		bsr	AG_CloseWindow

		*-- Autorenwindow schlieen --*
		lea	Autorwindowstruct(a5),a4
		bsr	AG_CloseWindow

		bsr	ClosePrefsWindows

		*--- Jetzt Hauptwindow schlieen ---*
		move.l	WinHandle(a5),d0
		beq.s	.Return
		move.l	d0,a0
		move.l	86(a0),a1			;MsgPort des Windows
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)

		move.l	IntBase(a5),a6
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOCloseWindow(a6)
.NoWindow:	clr.l	Winhandle(a5)
		clr.l	WindowPort(a5)
		clr.l	MyRastPort(a5)
		clr.w	WindowDisabled(a5)

		bsr	FreeMenus
		bsr	FreeGadgets

		bsr	UnlockPubScreen
.Return:	bsr	DT_FreePicture
		movem.l (sp)+,d0-a6
		rts


*--------------------------- Gadgets freigeben -------------------------------*
FreeGadgets:	movem.l	d0-a6,-(a7)

		move.l	GadBase(a5),a6
		move.l	GadgetListAdr(a5),d0
		move.l	d0,a0
		beq	.NoGadgets
		jsr	_LVOFreeGadgets(a6)
.NoGadgets:	clr.l	GadgetListAdr(a5)

		lea	GadgetMerkPuffer(a5),a0
		move.l	#GadgetAnz-1,d1
.ClrPuffer:	clr.l	(a0)+
		dbf	d0,.ClrPuffer
		movem.l	(a7)+,d0-a6

		clr.b	ListeDa(a5)
		rts

*-----------------------------------------------------------------------------*
FreeMenus:	movem.l	d0-a6,-(a7)
		move.l	IntBase(a5),a6
		move.l	MenuAdr(a5),d0
		move.l	d0,a0
		beq	.NoMenu
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOClearMenuStrip(a6)
.NoWindow:	move.l	GadBase(a5),a6
		move.l	MenuAdr(a5),d0
		beq.s	.NoMenu
		move.l	d0,a0
		jsr	_LVOFreeMenus(a6)
.NoMenu:	clr.l	MenuAdr(a5)
		movem.l	(a7)+,d0-a6
		rts

*----------------------------- Lock PubScreen --------------------------------*
LockPubScreen:	movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	IntBase(a5),a6
		lea	EUS_Structure(pc),a0
		move.l	EUS_EPBase(a0),d0
		beq.s	.KeinEP
		move.l	d0,a0
		move.l	EPG_Pubscreen(a0),d0
		*move.w	EPG_Wordreserved7(a0),word7(a5)
.KeinEp:	move.l	d0,a0
		jsr	_LVOLockPubScreen(a6)
		move.l	d0,MyPubscreen(a5)
		tst.l	d0
		beq.s	.Return

		move.l	Mypubscreen(a5),a0
		move.l	GadBase(a5),a6
		suba.l	a1,a1
		jsr	_LVOGetVisualInfoA(a6)
		move.l	d0,VisualInfo(a5)
		tst.l	d0
		beq.s	.Return
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

*------------------------------ Unlock PubScreen -----------------------------*
UnlockPubScreen:movem.l	d0-a6,-(a7)
		move.l	GadBase(a5),a6
		move.l	VisualInfo(a5),d0
		beq.s	.NoVisualInfo
		move.l	d0,a0
		jsr	_LVOFreeVisualInfo(a6)
		clr.l	VisualInfo(a5)
.NoVisualInfo:	move.l	IntBase(a5),a6
		suba.l	a0,a0
		move.l	Mypubscreen(a5),d0
		beq.s	.NoPublicScreen
		move.l	d0,a1
		jsr	_LVOUnlockPubScreen(a6)
.NoPublicScreen:clr.l	Mypubscreen(A5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Berechnet aus den Gadgets die min Height und Width und setzt diese in die   *
* Tagliste.
*-----------------------------------------------------------------------------*
BerechMinWindowSize:
		movem.l	d0-a6,-(a7)

	*-- Berechnungsgrundlage --*
	*-- min Width = min Cyclestringlen+25

**-----------------------------------*
* (C) Players		Infomation   *
* Available		Eigenschaften*
*------------------------------------*
* add del Config load save activate deactivate *


		*--- Breite der Gadgetleiste berechnen ---*
		moveq	#0,d7
		moveq	#0,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Add,d0
		bsr	NimmBiggerSize
		moveq	#LENr_Delete,d0
		bsr	NimmBiggerSize
		add.l	d1,d2

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Up,d0
		bsr	NimmBiggerSize
		moveq	#LENr_Down,d0
		bsr	NimmBiggerSize
		add.l	d1,d2

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Top,d0
		bsr	NimmBiggerSize
		moveq	#LENr_Botom,d0
		bsr	NimmBiggerSize
		add.l	d1,d2

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_ModulesPrefs,d0
		bsr	NimmBiggerSize
		moveq	#LENr_ClearPrefs,d0
		bsr	NimmBiggerSize
		add.l	d1,d2

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_SaveList,d0
		bsr	NimmBiggerSize
		moveq	#LENr_Execute,d0
		bsr	NimmBiggerSize
		add.l	d1,d2



 add.l	#BevelBreite*5*2+MinTextGadgetXOffset*5*2+GadgetXAbstand*4,d2
					*Abstand vom Bevelrand links & rechts
					*sowie Abstand zum nchsten Gadget
					*Breite aller Bevelboxen
					*dazuaddieren 5 Gadgets*2Rnder = 14

		move.l	d2,d6

		add.l	#GadgetXAbstand*2,d6	*Abstand vom Rand links&Rechts

		move.l	MyPubScreen(a5),a0
		move.b	Sc_WBorLeft(a0),d0
		ext.w	d0
		add.w	d0,d6
		move.b	Sc_WBorRight(a0),d0
		add.w	d0,d6
		move.l	d6,Win_MinWidth


	*----- So, nun wird die Y-Ausdehnung des Window berechnet -----*
		moveq	#0,d0
		move.w	FontY(a5),d0
		add.w	#MinTextGadgetYOffset*2+BevelHohe*2,d0
		*mulu	#8,d0	* 4,weil 1+1 Cyglegadget, 2+1 fr Listview
		*		*        1 fr Gadgetreihe 1 fr Listviewtext
		*		*	 und 1 als Reserve

		mulu	#7,d0	* 2+2 fr Listview, 2 fr Gadgetreihe
				* und 1 als Reserve

		add.w	Offy(a5),d0
		move.l	d0,Win_MinHeight


		movem.l	(a7)+,d0-a6
		rts
	
*-----------------------------------------------------------------------------*
* In der Windowstruktur sind die aktuellen Werte der Gre!		      *
* Jetzt
* Input: --
*-----------------------------------------------------------------------------*
InitGadgets:	movem.l	d1-a6,-(a7)

		*----- Zur Verfgung stehende Ausmae berechnen ------*
		move.l	WinHandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		moveq	#0,d6
		moveq	#0,d7
		move.w	WD_Width(a0),d6
		move.w	WD_Height(a0),d7
		moveq	#0,d0
		move.b	WD_BorderBottom(a0),d0
		sub.w	d0,d7				*InnerHeight
		sub.w	OffY(a5),d7
		sub.l	#GadgetYAbstand*2,d7
		move.b	WD_BorderLeft(a0),d0
		sub.w	d0,d6
		move.b	WD_BorderRight(a0),d0
		sub.w	d0,d6				*InnerWidth
		sub.l	#GadgetXAbstand*2,d6


		sub.l	#GadgetYAbstand*2,d7
		moveq	#0,d0
		move.w	FontY(a5),d0
		add.w	#MinTextGadgetYOffset+BevelHohe*2,d0
		sub.l	d0,d7
		lea	GD_Add(pc),a4
		bsr	SetGadgetReihe

		lea	Gadgets(pc),a4
		sub.l	#GadgetYAbstand*2,d7
		sub.l	d0,d7

	* fr Listview:
	* in d6 ist jetzt die InnerWidth
	* in d7 ist jetzt die InnerHeight
		move.w	d6,GNG_Width+GD_ModulesList-Gadgets(a4)
		move.w	d7,GNG_Height+GD_ModulesList-Gadgets(a4)
*		
*
*	sub.w	#GadgetXAbstand,d3	*Neue Max. Breite, damit alle Gadgets
*	ext.l	d3			*rechts untereinander sein
*	move.l	d3,d6
*
*	*------------------------------------------------------------*
*	*-- Jetzt haben wir die uns zur Verfgung stehenden Gren --*
*	*-- Alle Gadgets beginnen links und werden bei AddGads um  --*
*	*-- GadgetXAbstand & GadgetYAbstand verschoben             --*
*	*------------------------------------------------------------*
*		*-- LeftPos & Breite der Listviews & des CygleGadgets ---*
*		*-- festlegen --*
*		move.l	d6,d0
*		sub.w	#GadgetXAbstand,d0	*Ein Abstand untereinander
*		lsr.l	#1,d0			*--> Breite der Listviews
*		move.w	d0,GNG_Width+ToggleModeGD-Gadgets(a4)
*		move.w	d0,GNG_Width+ListGD-Gadgets(a4)
*		move.w	d0,GNG_Width+ModuleslistGD-Gadgets(a4)
*		move.w	d0,GNG_Width+EigenschaftenListGD-Gadgets(a4)
*		move.w	d0,InfoWidth(a5)
*
*		*-- LeftPos der rechten Listviews --*
*		add.w	#GadgetXAbstand,d0	*Ein Abstand untereinander
*		move.w	d0,GNG_LeftEdge+ModuleslistGD-Gadgets(a4)
*		move.w	d0,GNG_LeftEdge+EigenschaftenListGD-Gadgets(a4)
*
*
*		*--- Height des CycleGadgets ---*
*		move.w	FontY(a5),d0
*		move.l	d0,d1
*		add.w	#MinTextGadgetYOffset+BevelHohe*2,d0 *einmal reicht
*		move.w	d0,GNG_Height+ToggleModeGd-Gadgets(a4)
*
*		add.w	#MinTextGadgetYOffset*2,d1
*		move.w	d1,GNG_TopEdge+ToggleModeGd-Gadgets(a4)
*		move.w	d1,GNG_TopEdge+ModuleslistGD-Gadgets(a4)
*
*		*--- TopPosition des linken Listviews ---*
** Die .l Zeilen schieben das ListView links nach unten
*		add.w	#GadgetYAbstand+AboveAbstand,d1
*		add.w	d0,d1
*		add.w	FontY(a5),d1			*Max Pos
*.l10		move.w	d1,GNG_TopEdge+ListGd-Gadgets(a4)
*
*		move.l	d7,d0
*		sub.w	d1,d0
*		sub.w	d4,d0
*		sub.w	#GadgetYAbstand,d0
*
*.l1		ext.l	d0
*.l2		divu	FontY(a5),d0
*.l3		ext.l	d0
*.l4		mulu	FontY(a5),d0
*.l11		add.w	#BevelHohe*2+2,d0
*		move.w	d0,GNG_Height+ListGd-Gadgets(a4)
*
*.l5		move.w	d7,d2
*.l6		sub.w	d0,d2
*.l7		sub.w	d4,d2
*.l8		sub.w	#GadgetYAbstand,d2
*.l9		move.w	d2,GNG_TopEdge+ListGd-Gadgets(a4)
*
*
*
*
*
*
*		add.w	d0,d1					*MaxPos
*		sub.w	GNG_TopEdge+ModuleslistGd-Gadgets(a4),d1
*		sub.w	#AboveAbstand+GadgetYAbstand,d1
*		sub.w	FontY(a5),d1
*		ext.l	d1
*		lsr.l	#1,d1
*		move.w	d1,GNG_Height+ModuleslistGd-Gadgets(a4)
*
*		move.l	d1,d2
*.l12		ext.l	d2
*.l13		divu	FontY(a5),d2
*.l14		ext.l	d2
*.l15		mulu	FontY(a5),d2
*.l16		add.w	#BevelHohe*2+2,d2
*
*
*		move.w	d2,GNG_Height+EigenschaftenListGd-Gadgets(a4)
*
*
*		move.l	d7,d0
*		sub.w	d2,d0
*		sub.w	d4,d0
*		sub.w	#GadgetYAbstand,d0
*
**		add.w	#AboveAbstand+GadgetYAbstand,d1
**		add.w	FontY(a5),d1
**		add.w	GNG_TopEdge+ModuleslistGd-Gadgets(a4),d1
**		move.w	d1,GNG_TopEdge+EigenschaftenListGd-Gadgets(a4)
*	move.w	d0,GNG_TopEdge+EigenschaftenListGd-Gadgets(a4)
*
		bsr	CreateGadgets				*d0=Return

.Return:	movem.l	(a7)+,d1-a6
		rts


.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.Return


*-----------------------------------------------------------------------------*
* Input: a4=GadgetreiheAnfang
*	 d7=Offs vom oberen Windowrand
* Output:
*-----------------------------------------------------------------------------*
SetGadgetReihe:	movem.l	d0-a6,-(a7)
		moveq	#10-1,d1
		move.l	a4,a3
.GadgetClr:	clr.l	(a3)				*Gren lschen
		clr.l	4(a3)
		lea	GNG_SizeOf(a3),a3		*Positionen und
		dbf	d1,.GadgetClr


	*-- Die Breiten der Gadgetleisten wird berechnet --*
	*-- Als erstes wird die Stringbreite berechnet und gemerkt --*
	*-- dann wird calibriert
		moveq	#0,d2
		moveq	#5-1,d4
		move.l	a4,a3
.GadgetWidth:	moveq	#MinGadgetWidth,d1
		move.l	GNG_GadgetText(a3),a0
		bsr	NimmBiggerSize2
		move.l	GNG_SizeOf*5+GNG_GadgetText(a3),a0
		bsr	NimmBiggerSize2
		add.w	#BevelBreite*2+MinTextGadgetXOffset*2,d1 ;Neu V5
		move.w	d1,GNG_Width(a3)
		add.l	d1,d2
		lea	GNG_SizeOf(a3),a3
		dbf	d4,.GadgetWidth



	*-- jetzt befindet sich in d2 die Width aller Gadgetstrings sowie --*
	*-- der Bevelboxen 						  --*
	*-- jetzt die Width der Gadgets in Verhltnis der Gesammtwidth    --*
	*-- setzen.
		moveq	#0,d4				*Hhe der Gadgets
		move.w	FontY(a5),d4
		add.w	#MinTextGadgetYOffset*2+BevelHohe*2,d4

		move.l	d6,d5
		sub.w	#GadgetXAbstand*5,d5
		ext.l	d5


		moveq	#0,d3
		moveq	#5-1,d1
		move.l	a4,a3
.GadgetWidth2:	moveq	#0,d0
		move.w	GNG_Width(a3),d0		*Stringwidth
		mulu	d5,d0				*mal max. nutz Ausdehn.
		divu	d2,d0				*durch GesamtStringlen
*		swap	d0
*		btst	#0,d0
*		beq.s	.GGNoAdd
*		add.l	#$10000,d0
*.GGNoAdd:	swap	d0
		move.w	d7,GNG_TopEdge(a3)
		sub.w	d4,GNG_TopEdge(a3)
		move.w	d4,GNG_Height(a3)
	addq.l	#1,d0
		move.w	d0,GNG_Width(a3)
		move.w	d3,GNG_LeftEdge(a3)

		*-- 2. Reihe --*
		move.w	d7,GNG_SizeOf*5+GNG_TopEdge(a3)
		*add.w	d4,GNG_SizeOf*5+GNG_TopEdge(a3)
		*add.w	d4,GNG_SizeOf*5+GNG_TopEdge(a3)
		add.w	#GadgetYAbstand,GNG_SizeOf*5+GNG_TopEdge(a3)

		move.w	d4,GNG_SizeOf*5+GNG_Height(a3)
		move.w	d0,GNG_SizeOf*5+GNG_Width(a3)
		move.w	d3,GNG_SizeOf*5+GNG_LeftEdge(a3)

		add.w	d0,d3
		add.w	#GadgetXAbstand,d3
		lea	GNG_SizeOf(a3),a3
		dbf	d1,.GadgetWidth2

		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Error oder Null
*-----------------------------------------------------------------------------*
CreateGadgets:	movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	GadBase(A5),a6
		lea	GadgetListadr(a5),a0
		jsr	_LVOCreateContext(a6)
		move.l	d0,a3
		tst.l	d0
		beq.w	.Error

		moveq	#0,d3
		lea.l	GadgetTags(pc),a4
.NextGadget:	EB
		lea	Gadgets(pc),a0
		move.l	d3,d0
		mulu	#GNG_SIZEOF,d0		* +2 wegen Locale !
		add.l	d0,a0
		lea.l	BufNewGad(a5),a1
		moveq	#GNG_SizeOf,d0
		jsr	_LVOCopyMem(a6)
		lea.l	BufNewGad(a5),a0
		move.l	VisualInfo(a5),GNG_VisualInfo(a0)
		move.l	Font(a5),GNG_TextAttr(a0)

		move.w	GNG_TopEdge(a0),d0
		add.w	OffY(a5),d0
		addq.w	#GadgetYAbstand,d0
		move.w	d0,GNG_TopEdge(a0)

		move.w	GNG_LeftEdge(a0),d0
		add.w	OffX(a5),d0
		add.w	#GadgetXAbstand,d0
		move.w	d0,GNG_LeftEdge(a0)

		move.l	GadBase(a5),a6
		lea	GadgetTypes(pc),a0
		moveq	#0,d0
		move.l	d3,d1
		asl.l	#1,d1
		add.l	d1,a0
		move.w	(a0),d0
		move.l	a3,a0
		lea	BufNewGad(a5),a1
		move.l	a4,a2
		jsr	_LVOCreateGadgetA(a6)
		tst.l	d0
		beq.s	.Error

		*------- Gadgetadr im Puffer merken --------*
		move.l	d0,a3
		move.l	d3,d0
		asl.l	#2,d0
		lea.l	GadgetMerkPuffer(a5),a0
		add.l	d0,a0
		move.l	a3,(a0)

		*--- Start der nchsten Tagliste finden ----*
.FindTags:	tst.l	(a4)
		beq.s	.NochEinGadget
		addq.w	#8,a4
		bra.s	.FindTags

.NochEinGadget:	addq.w	#4,a4
		addq.w	#1,d3
		cmp.w	#GadgetAnz,d3
		bmi	.NextGadget
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

.Error:		bsr.w	FreeGadgets
		bra.s	.Return

*-----------------------------------------------------------------------------*
AddGads:	movem.l	d0-a6,-(sp)
		tst.l	WinHandle(a5)
		beq.w	.Return
		move.l	GadgetListAdr(a5),d0
		beq.s	.Return
		move.l	d0,a1

		moveq	#0,d1
.count:		move.l	d0,a0
		addq.l	#1,d1
		move.l	(A0),d0
		bne.s	.count
		move.w	d1,RealNumGadgets(a5)

		move.l	IntBase(a5),a6
		move.l	Winhandle(a5),a0
		moveq	#-1,d0
		moveq	#-1,d1
		sub.l	a2,a2
		jsr	_LVOAddGList(a6)


		bsr	ReaddList


*		bsr	MakeList
*
*		lea	MyTags(a5),a3
*		move.l	#GTLV_Selected,(a3)+
*		move.l	SelectedEntry(a5),(a3)
*		subq.l	#1,(a3)+
*		clr.l	(a3)
*		moveq	#EPENr_ModulesList,d0
*		bsr	GetGadgetAdr
*		lea	MyTags(a5),a3
*		move.l	Winhandle(a5),a1
*		suba.l	a2,a2
*		move.l	GadBase(a5),a6
*		jsr	_LVOGT_SetGadgetAttrsa(a6)
*		move.b	#1,ListeDa(a5)


		move.l	GadgetListAdr(a5),a0
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		moveq	#-1,d0
		move.l	IntBase(a5),a6
		jsr	_LVOrefreshglist(a6)

		move.l	GadBase(a5),a6
		move.l	Winhandle(a5),a0
		sub.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)



.Return:	movem.l	(sp)+,d0-a6
		rts



*----------------------- Liste wieder an Gadget anhngen ---------------------*
* Input: --
*-----------------------------------------------------------------------------*
Readdlist:	movem.l	d0-a6,-(sp)
		tst.l	Winhandle(a5)
		beq.s	.Return

		tst.b	ListeDa(a5)
		bne.s	.Return

		tst.l	MaxEntries(a5)
		beq.s	.NoSel
		tst.l	SelectedEntry(a5)
		bne.s	.NoSel
		addq.l	#1,SelectedEntry(a5)

.NoSel:		moveq	#EPENr_ModulesList,d0
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	MyTags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		lea	ModulesList(a5),a2
		move.l	a2,(a3)+
		move.l	#GTLV_Selected,(a3)+
		move.l	SelectedEntry(a5),(a3)
		subq.l	#1,(a3)+
		move.l	#GTLV_ShowSelected,(a3)+
		move.l	#1,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	SelectedEntry(a5),(a3)
		subq.l	#1,(a3)+
		clr.l	(a3)

*		tst.b	Clicked(a5)
*		beq.s	.nose
*		move.l	#GTLV_Selected,(a3)+
*		moveq	#0,d0
*		move.w	Num_Selected(a5),d0
*		move.l	d0,(a3)+
*		clr.l	(a3)
.nose:		lea	MyTags(a5),a3

		move.l	WinHandle(a5),a1
		sub.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		move.b	#1,ListeDa(a5)
		bsr	ErlaubeGadgets

.Return:	movem.l	(sp)+,d0-a6
		rts



******************************************************************************
* Die Liste wird removed
******************************************************************************
RemoveList:	movem.l	d0-a6,-(a7)
		moveq	#EPENr_ModulesList,d0
		tst.b	ListeDa(a5)
		beq.s	.Return

		tst.l	Winhandle(a5)
		beq.s	.Return
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	Mytags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		move.l	#-1,(a3)+
		clr.l	(a3)+
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	clr.b	ListeDa(a5)
		movem.l	(a7)+,d0-a6
		rts

******************************************************************************
* Die Liste wird removed
* Input: a4=AGL_Struct (Liste)
RemoveAGLList:	movem.l	d0-a6,-(a7)

		tst.b	AGL_ListeDa(a4)
		beq.s	.Return

		move.l	AGL_Windowstruct(a4),d0
		beq.s	.Return
		move.l	d0,a3

		tst.l	WS_Winhandle(a3)
		beq.s	.Return
		move.w	AGL_GadgetID(a4),d0
		bsr	GetGadgetAdr2			;Gadgetadresse in A0
		bne.s	.Return

		lea	Mytags(a5),a2
		move.l	#GTLV_Labels,(a2)+
		move.l	#-1,(a2)+
		clr.l	(a2)+

		move.l	WS_Winhandle(a3),a1
		lea	MyTags(a5),a3
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	clr.b	AGL_ListeDa(a4)
		movem.l	(a7)+,d0-a6
		rts

*----------------------- Liste wieder an Gadget anhngen ---------------------*
* Input: a4=AGL_Struct (Liste)
*-----------------------------------------------------------------------------*
ReaddAGLlist:	movem.l	d0-a6,-(sp)
		move.l	AGL_Windowstruct(A4),d0
		beq.s	.Return
		move.l	d0,a3

		tst.l	WS_Winhandle(a3)
		beq.s	.Return
		tst.b	AGL_ListeDa(a4)
		bne.s	.Return

		tst.l	AGL_MaxEntries(a4)
		beq.s	.NoSel
		tst.l	AGL_SelectedEntry(a4)
		bne.s	.NoSel
		addq.l	#1,AGL_SelectedEntry(a4)

.NoSel:		move.w	AGL_GadgetID(a4),d0
		bsr	GetGadgetAdr2			;Gadgetadresse in A0
		bne.s	.Return

		lea	MyTags(a5),a2
		move.l	#GTLV_Labels,(a2)+
		lea	AGL_List(a4),a1
		move.l	a1,(a2)+
		move.l	#GTLV_Selected,(a2)+
		move.l	AGL_SelectedEntry(a4),(a2)
		subq.l	#1,(a2)+
		move.l	#GTLV_ShowSelected,(a2)+
		move.l	#1,(a2)+
		move.l	#GTLV_MakeVisible,(a2)+
		move.l	AGL_SelectedEntry(a4),(a2)
		subq.l	#1,(a2)+
		clr.l	(a2)

		move.l	WS_WinHandle(a3),a1
		lea	MyTags(a5),a3
		sub.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		move.b	#1,AGL_ListeDa(a4)
		bsr	ErlaubeGadgets

.Return:	movem.l	(sp)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeList:	movem.l	d0-a6,-(a7)
		bsr	ClosePrefsWindows
		bsr	RemoveList
		lea	Moduleslist(a5),a0
		bsr	DeleteAList
		bsr	ReAddList
		clr.l	SelectedEntry(a5)
		clr.l	MaxEntries(a5)
		clr.b	ListeChanged(a5)
		bsr	ErlaubeGadgets
		movem.l	(a7)+,d0-a6
		rts

		*--- Leere Liste setzen ----*
*-----------------------------------------------------------------------------*
LeereListe:	movem.l	d0-a6,-(a7)
		moveq	#EPENr_ModulesList,d0
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.NoAdr
		lea	MyTags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		lea	EmptyList(a5),a2
		move.l	a2,(a3)+
		clr.l	(a3)
		move.l	WinHandle(a5),d0
		beq.s	.NoAdr
		move.l	d0,a1
		sub.l	a2,a2
		lea	MyTags(a5),a3
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.NoAdr:		movem.l	(a7)+,d0-a6
		rts

**----------------------------------------------------------------------------*
** Die Liste wird removed und freigegeben *
*DeleteListen:	movem.l	d0-a6,-(a7)
*		moveq	#EPENr_Moduleslist,d0
*		bsr	RemoveList
*		lea	Moduleslist(a5),a0
*		bsr	DeleteAlist
*
*		movem.l	(a7)+,d0-a6
*		rts


*-----------------------------------------------------------------------------*
* Input: a0=List
*-----------------------------------------------------------------------------*
DeleteAList:	movem.l	d0-a6,-(a7)
		move.l	a0,d4

.NextNode:	move.l	d4,a0
	;Macro remhead aus exec/lists.i 	A0-list A1-(destroyed) D0=node
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)

		move.l	d0,a1
		lea	-PL_Node(a1),a1
		bsr	FreeThisNode
		bra.s	.NextNode

.empty:		movem.l	(sp)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Input: a4=AGL_Struct (Liste)
*-----------------------------------------------------------------------------*
DeleteAGList:	movem.l	d0-a6,-(a7)
		lea	AGL_List(a4),a4
		move.l	a4,d4

.NextNode:	move.l	d4,a0
	;Macro remhead aus exec/lists.i 	A0-list A1-(destroyed) D0=node
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)

		move.l	d0,a1
		lea	-AGS_Node(a1),a1
		bsr	FreeAGSStruct
		bra.s	.NextNode

.empty:		move.l	d4,a4
		clr.l	AGL_SelectedEntry(a4)
		clr.l	AGL_MaxEntries(a4)
		movem.l	(sp)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a1=PL_Struct (bereits removed)
*-----------------------------------------------------------------------------*
FreeThisNode:	movem.l	d0-d2/a0-a2/a6,-(a7)
		bsr	FreeNodeMems

		move.l	PL_StructSize(a1),d0
		beq.s	.NextNode
		EB
		jsr	_LVOFreemem(a6)

.NextNode:	movem.l	(a7)+,d0-d2/a0-a2/a6
		rts

*-----------------------------------------------------------------------------*
* Input: a1=PL_Structure (bereits removed)
* Output:--
*-----------------------------------------------------------------------------*
FreeNodeMems:	movem.l	d0-d2/a0-a3/a6,-(a7)
		EB
		move.l	a1,a3

		lea	PL_MEStruct(a3),a1
		bsr	FreeModulesPrefs

		lea	PL_MEStruct(a3),a1
		bsr	FreeEigenPrefs

		movem.l	(a7)+,d0-d2/a0-a3/a6
		rts

*-----------------------------------------------------------------------------*
* a1=MPE_ModulesPrefs
FreeModulesPrefs:movem.l d0-d2/a0-a3/a6,-(a7)
		move.l	a1,d0
		beq.s	.Return
		move.l	a1,a3
		EB
		move.l	MPE_ModulesPrefs(a3),d0
		beq.s	.NoModulePrefs
		move.l	d0,a1
		move.l	MPE_ModulesPrefsSize(a3),d0
		beq.s	.NoModulePrefs
		jsr	_LVOFreeMem(a6)
.NoModulePrefs:	clr.l	MPE_ModulesPrefs(a3)
		clr.l	MPE_ModulesPrefsSize(a3)
.Return:	movem.l	(a7)+,d0-d2/a0-a3/a6
		rts

*-----------------------------------------------------------------------------*
* a1=MPE_ModulesPrefs
FreeEigenPrefs:	movem.l d0-d2/a0-a3/a6,-(a7)
		move.l	a1,d0
		beq.s	.Return
		move.l	a1,a3
		EB
		move.l	MPE_Eigenschaften(a3),d0
		beq.s	.NoEigen
		move.l	d0,a1
		move.l	MPE_EigenschaftenSize(a3),d0
		beq.s	.NoEigen
		jsr	_LVOFreeMem(a6)
.NoEigen:	clr.l	MPE_Eigenschaften(a3)
		clr.l	MPE_EigenschaftenSize(a3)
.Return:	movem.l	(a7)+,d0-d2/a0-a3/a6
		rts

*-----------------------------------------------------------------------------*
* Speicher fr Node-Struktur + String anfordern, an Liste anhngen und init  *
* Alphabetisch richtig einsortieren!
* Input: a0=StringAdr							     *
*	 a4=AGL_Struct (Liste)						     *
* Output:d0=NUll=Error							     *
*	 a0=Adr der Node
InsertItInList:	movem.l	d1-d7/a1-a6,-(a7)
		lea	AGL_List(a4),a4
		move.l	a4,d4

		*--- Node allokieren ---*
		move.l	a0,a2
		bsr	BerechStringSize
		beq.w	.Error
		EB
		move.l	#$10000,d1
		add.l	#AGS_Chars+10,d0
		move.l	d0,d3
		jsr	_LVOAllocmem(a6)
		tst.l	d0
		beq.s	.Error
		move.l	d0,a3

		lea	AGS_Chars(a3),a1
		move.l	a1,AGS_Node+LN_Name(a3)
		move.l	d3,AGS_StructSize(a3)

		move.w	d3,d1
		sub.w	#AGS_Chars+10+1,d1
		move.l	a2,a0
.Nochmal2:	move.b	(a0),d0
		beq.s	.GibtsSchon
		cmp.b	#32,d0
		bhi.s	.StartOk
		addq.l	#1,a0
		bra.s	.Nochmal2
.StartOk:	cmp.b	#`a`,d0		;Kommando in Grobuchstaben
		blo.s	.NoD1Set	;umwandeln
		cmp.b	#`z`,d0
		bhi.s	.NoD1Set
		bclr	#5,d0		;bis auf Bit 5 alle bernehmen -> fertig
.NoD1Set:	move.b	d0,(a0)
		bsr	StringCopy


		*--- Jetzt einsortieren ---*
		sub.l	a2,a2
.Nochmal:	move.l	(a4),a4
		move.l	(a4),d0
		beq.s	.NoMore
		move.l	LN_Name(a4),a0
		move.l	AGS_Node+LN_Name(a3),a1
		bsr	StrCMP
		beq.s	.GibtsSchon
		bgt.s	.NoMore
		move.l	a4,a2
		bra.s	.Nochmal
.NoMore:	lea	AGS_Node(a3),a1
		move.l	d4,a0			*lea	Formatlist(a5),a0
		bsr	InsertInList

		
		addq.l	#1,AGL_MaxEntries-AGL_List(a0)
		move.b	#1,AGL_ListeChanged-AGL_List(a0)

		moveq	#1,d0
.Return:	move.l	a3,a0
		movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

.GibtsSchon:	move.l	a3,a1
		bsr	FreeAGSStruct
.Error:		moveq	#0,d0
		sub.l	a3,a3
		bra.s	.Return


*-----------------------------------------------------------------------------*
* Lscht den selectierten Eintrag des Listviews
* Input: a4=Liste
* Output:--
*-----------------------------------------------------------------------------*
DeleteAGEntry:	movem.l	d0-a6,-(a7)

		bsr	GetSelectedAGStruct
		bne.s	.Return

		subq.l	#1,AGL_MaxEntries(a4)
		move.b	#1,AGL_ListeChanged(a4)

		move.l	a0,a2
		lea	AGS_Node(a0),a1

		cmp.l	#1,AGL_SelectedEntry(a4)
		bne.s	.FromMitte

		*Remhead
		lea	AGL_List(a4),a0
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)
.Empty:		tst.l	AGL_MaxEntries(a4)
		bne.s	.DEL_Ok
		clr.l	AGL_SelectedEntry(a4)
		bra.s	.DEL_OK

.FromMitte	REMOVE
		move.l	AGL_MaxEntries(a4),d0
		cmp.l	AGL_SelectedEntry(a4),d0
		bhs.s	.Del_Ok
		move.l	d0,AGL_SelectedEntry(A4)

.Del_Ok:	move.l	a2,a1
		bsr	FreeAGSStruct

.Return:	movem.l	(a7)+,d0-a6
		rts

**----------------------------------------------------------------------------*
** Speicher fr Node-Struktur + String anfordern, an Liste anhngen und init  *
**									     *
** Input: a0=StringAdr							     *
**	 a4=Liste							     *
** Output:d0=NUll=Error	L						     *
**----------------------------------------------------------------------------*
*AllocTheNode:	movem.l	d1-a6,-(sp)
*		move.l	a0,a2
*		bsr	BerechStringSize
*		EB
*		move.l	#$10000,d1
*		add.l	#AGS_Chars+10,d0
*		move.l	d0,d3
*		jsr	_LVOAllocmem(a6)
*		tst.l	d0
*		beq.s	.Error
*
*		move.l	d0,a3
*		move.l	a4,a0
*		move.l	d0,a1			;(erspart Arbeit)
*		addtail
*		lea	AGS_Chars(a3),a1
*		move.l	a1,LN_Name(a3)
*		move.l	d3,AGS_StructSize(a3)
*
*		move.w	d3,d1
*		sub.w	#AGS_Chars+10+1,d1
*		move.l	a2,a0
*		bsr	StringCopy
*
*		move.l	a3,d0
*
*.Error:		movem.l	(a7)+,d1-a6
*		tst.l	d0
*		rts
*

*---------------------------- Node freigeben --------------------------------*
* Input: a1=AGS_Struct
FreeAGSStruct:	movem.l	d0-a6,-(sp)
		EB
		move.l	a1,d0
		beq.s	.Return
		move.l	AGS_Structsize(a1),d0
		beq.s	.Return
		jsr	_LVOFreemem(a6)
.Return:	movem.l	(sp)+,d0-a6
		rts




*------------------------------ Make Archivelist ----------------------------*
* Die Liste mu leer sein !!!
* Input: --
* Output:d0=Error oder NULL
MakeList:	rts
*		movem.l	d1-a6,-(a7)
*		moveq	#0,d0
*
*		tst.b	ListeDa(a5)
*		bne.s	.Return
*
*		move.l	EUS_Structure+EUS_EPBase(pc),a4
*		lea	EPG_FirstPlayerStruct(a4),a3
*		move.l	EPG_PlayerList(a4),a0
*		cmp.b	#Mode_Player,Mode(a5)
*		beq.s	.JaPlayer
*		move.l	EPG_EngineList(a4),a0
*		lea	EPG_FirstUserStruct(a4),a3
*.JaPlayer:	moveq	#EPENr_List,d0
*		move.l	a0,ListAdr(a5)
*		bsr	ReAddlist
*
*		moveq	#0,d1
*.FindAnz:	move.l	(a3),d0
*		beq.s	.DasWars
*		move.l	d0,a3
*		addq.l	#1,d1
*		bra.s	.FindAnz
*
*.DasWars:	move.l	d1,MaxEntries(a5)
*		move.b	#1,ListeDa(a5)
*
*.Return:	movem.l	(a7)+,d1-a6
*		tst.l	d0
*		rts
*
*.Error:		moveq	#EPR_UnknownError,d0
*		bra.s	.Return
*


		

*------------------------------- Get GadgetAdr -------------------------------*
* d0=0, wenn ok
GetGadgetAdr:	sub.l	a0,a0
		cmp.w	#GadgetAnz,d0
		bhi.s	.Error
		tst.l	GadgetListAdr(a5)
		beq.s	.Error
		lea	GadgetMerkPuffer(a5),a0
		subq.l	#EPENr_FirstNummer,d0
		asl.l	#2,d0
		tst.l	(a0,d0)
		beq.s	.Error
		move.l	(a0,d0),a0
		moveq	#0,d0
.Error:		tst.l	d0
		rts

*------------------------------- Get GadgetAdr -------------------------------*
* Input: a3=WS_Windowstruct
*	 d0=EPNrE_Nr
* d0=0, wenn ok
GetGadgetAdr2:	sub.l	a0,a0
		move.l	a1,-(a7)
		move.l	WS_Gadgets(a3),a1
		ext.l	d0
		sub.w	16(a1),d0		;Nummer subben
		move.l	(a7)+,a1
		tst.w	d0
		blt.s	.Error
		cmp.l	WS_GadgetAnz(a3),d0
		bhi.s	.Error
		tst.l	WS_GadgetListAdr(a3)
		beq.s	.Error
		move.l	WS_GadgetMerkPuffer(a3),a0
		*subq.l	#EPENr_FirstNummer,d0
		asl.l	#2,d0
		tst.l	(a0,d0)
		beq.s	.Error
		move.l	(a0,d0),a0
		moveq	#0,d0
.Error:		tst.l	d0
		rts


*---------------------------- Make Correct-Dir ------------------------------*
*----- Corrigiert den Dirnamen so, da Filenamen nur rankopiert werden ------*
*----- Input: a0=Diradresse						-----*
*----------------------------------------------------------------------------*
MakeCorrectDir:	move.l	a0,-(a7)
		tst.b	(a0)
		beq.s	.NoSchraeg
.NextB:		tst.b	(a0)+
		bne.s	.NextB
		subq.l	#2,a0
		cmp.b	#":",(a0)
		beq.s	.NoSchraeg
		cmp.b	#"/",(a0)+
		beq.s	.NoSchraeg
		move.b	#"/",(a0)+
		clr.b	(a0)
.NoSchraeg:	move.l	(a7)+,a0
		rts


*--------------------------- normaler Stringvergleich ------------------------*
* Input: a0=String1
*	 a1=String2
* Output:d0=0 Strings gleich
*	 d0<0 String 1 vor String 2
*	 d0>0 String 2 vor String 1
*-----------------------------------------------------------------------------*
StrCmp:		movem.l	d1/a0/a1,-(a7)
		move.l	a0,d0
		beq.s	.Kleiner
		move.l	a1,d0
		beq.s	.Kleiner
.Repeat:	move.b	(a0)+,d1
		beq.s	.Ende1
		cmp.b	#`A`,d1		;Kommando in Grobuchstaben
		blo.s	.NoD1Set	;umwandeln
		cmp.b	#`Z`,d1
		bhi.s	.NoD1Set
		bset	#5,d1		;bis auf Bit 5 alle bernehmen -> fertig
.NoD1Set:	move.b	(a1)+,d0	;Wert holen
		beq.s	.Grosser
		cmp.b	#`A`,d0		;Kommando in Grobuchstaben
		blo.s	.NoBSet		;umwandeln
		cmp.b	#`Z`,d0
		bhi.s	.NoBSet
		bset	#5,d0		;bis auf Bit 5 alle bernehmen -> fertig
.NoBSet:	cmp.b	d1,d0
		beq.s	.Repeat
		bhi.s	.Kleiner
.Grosser:	moveq	#1,d0
		bra.s	.Return
.Kleiner:	moveq	#-1,d0
.Return:	movem.l	(a7)+,d1/a0/a1
		tst.l	d0
		rts			;---> Error in String !!!!

.Ende1:		tst.b	(a1)
		bne.s	.Kleiner
		moveq	#0,d0
		bra.s	.Return


*---------------- Berechnet die Gre des Strings in a0 ---------------------*
*------- >= a0=String							-----*
*------- => d0=Stringsize						-----*
*----------------------------------------------------------------------------*
BerechStringSize:move.l a0,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest
		moveq	#-1,d0
.NextB:		addq.l	#1,d0
		tst.b	(a0)+
		bne.s	.NextB
.NoTest:	move.l	(a7)+,a0
		tst.l	d0
		rts

*----------------------------------------------------------------------------*
* Berechnet die Stringlnge und setzt den Anfang korrect.
* Sucht bis Zeichen kommen <20 oder bis die Ganse, die am Anfang stehen mssen
* zuende sind.
* Input: a0=Stringanfang
* Output:d0=StringSize oder NULL
*	 a0=neue Startadresse des Strings
*----------------------------------------------------------------------------*
BerechStringSize2:movem.l a0/d1/d2,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest

		moveq	#-1,d0
		moveq	#'"',d1
		cmp.b	(a0),d1
		beq.s	.ja
		moveq	#"'",d1
		cmp.b	(a0),d1
		beq.s	.ja
		moveq	#"`",d1
		cmp.b	(a0),d1
		beq.s	.ja
		moveq	#0,d1
		bra.s	.NextB
.Ja:		addq.l	#1,a0
.NextB:		addq.l	#1,d0
		move.b	(a0)+,d2
		beq.s	.NoTest
		cmp.b	d2,d1
		beq.s	.GanseTest
		cmp.b	#32,d2
		bhs.s	.NextB
.NoTest:	movem.l	(a7)+,d1/d2/a0
		tst.l	d0
		rts

.GanseTest:	movem.l	(a7)+,d1/d2/a0
		addq.l	#1,a0
		tst.l	d0
		rts

*----------------------------------------------------------------------------*
* Berechnet die Stringlnge und setzt den Anfang korrect.
* Sucht Ende dieses Strings Ganse drfen auch innerhalb auftreten.
* Input: a0=Stringanfang
* Output:d0=StringSize oder NULL "L"=1 l=1
*	 d1=Size des Strings "L"=3 l=1
*	 a0=neue Startadresse des Strings
*----------------------------------------------------------------------------*
BerechStringSize3:
		movem.l a0/d2-d3,-(a7)
		moveq	#-1,d1
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.Return

		moveq	#-1,d0
		moveq	#'"',d3
		cmp.b	(a0),d3
		beq.s	.Ganse
		moveq	#"'",d3
		cmp.b	(a0),d3
		beq.s	.Ganse
		moveq	#"`",d3
		cmp.b	(a0),d3
		beq.s	.Ganse
		moveq	#0,d3
		bra.s	.NoGanse
.Ganse:		addq.l	#1,a0
		addq.l	#1,d1
.NoGanse:	bsr	.Berech

		tst.b	d3
		beq.s	.Return

		movem.l	(a7)+,d2-d3/a0
		addq.l	#1,a0
		addq.l	#1,d1
		tst.l	d0
		rts

.Return:	movem.l	(a7)+,d2-d3/a0
		tst.l	d0
		rts

* Input: d0=Zhler
*	 d3=Gansekenn
.Berech:	addq.l	#1,d0
		addq.l	#1,d1
		move.b	(a0)+,d2
		beq.s	.NoTest
		cmp.b	d2,d3
		beq.s	.NoTest		;GanseTest

		cmp.b	#'"',d2
		beq.s	.ja
		cmp.b	#"'",d2
		beq.s	.ja
		cmp.b	#"`",d2
		beq.s	.Ja
		tst.b	d3
		bne.s	.Berech
		cmp.b	#32,d2
		bhi.s	.Berech
		bra.s	.Notest

.Ja:		move.l	d3,-(a7)
		move.l	d2,d3
		bsr	.Berech
		move.l	(a7)+,d3
		*tst.b	d3
		*beq.s	.NoTest
		bra.s	.Berech
		*tst.b	d2
		*beq.s	.Error		?

.NoTest		tst.l	d0
		rts



*----------------------------------------------------------------------------*
StringCopy:	moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
InitLocale:	movem.l	d0-a6,-(a7)

		*--- Catalog ffnen ---*
		if	Executable!Debugger
		tst.l	MyCatalog(a5)
		bne.s	.NoCatalog
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	Catalogname(pc),a1
		jsr	ENPP_OpenCatalog(a4)		;_LVOopencatalogA
		move.l	d0,MyCatalog(a5)

		else

		*--- Catalog ffnen ---*
		tst.l	MyCatalog(a5)
		bne.s	.NoCatalog
		move.l	LocaleBase(a5),d0
		beq.s	.NoCatalog
		move.l	d0,a6
		suba.l	a0,a0
		suba.l	a2,a2
		lea	Catalogname(pc),a1
		jsr	_LVOOpenCatalogA(a6)		;_LVOopencatalogA
		move.l	d0,MyCatalog(a5)
		endc

.NoCatalog:	moveq	#5,d0
		lea	LocaleTabelle-4(pc),a0
		lea	LocaleTabelle(pc),a1
.NextOne:	lea	4(a0),a0
		move.w	(a0),d0
		beq.s	.DasWars
		move.w	2(a0),d1
		lea	(a1,d1.w),a2
		bsr	GetLocaleString
		move.l	d0,(a2)
		bra.s	.NextOne
.DasWars:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeLocale:	movem.l	d0-a6,-(a7)
		*tst.l	MyCatalog(a5)
		*beq.s	.NoCatalog

		if	executable!Debugger
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	MyCatalog(a5),d0
		jsr	ENPP_CloseCatalog(a4)
		else
		move.l	LocaleBase(a5),d0
		beq.s	.NoCatalog
		move.l	d0,a6
		move.l	MyCatalog(a5),d0
		jsr	_LVOCloseCatalog(a6)
		endc
.NoCatalog:	clr.l	MyCatalog(a5)
		movem.l	(a7)+,d0-a6
		rts

*---------------------------- Erstmal ignorieren -----------------------------*
*-----------------------------------------------------------------------------*
FirstLocaleInit:movem.l	d0-a6,-(a7)
		lea	LocalePuffer+2(a5),a4
		lea	ExternalStrings,a3
		move.w	#LENr_LastExternal,d1
		move.l	a3,a0
.NextString2:	move.l	a0,d0
		sub.l	a3,d0
		move.w	d0,(a4)+
.FindZero2:	tst.b	(a0)+
		bne.s	.FindZero2
	*	tst.b	(a0)
	*	beq.s	.SetAbsStrings
		subq.w	#1,d1
		bne.s	.NextString2
.Ok:		movem.l	(a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
* Input:  D0.w = LocaleNr						      *
* Output: D0.l = StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleString:
		movem.l	d1/d2/a0/a1/a6,-(a7)

	*------- LocaleString aus internem Catalog suchen ------*
		move.l	d0,d2
		sub.l	a0,a0
		lea	ExternalStrings,a1
		cmp.w	#LENr_LastExternal,d0
		bhi.s	.Error
		lea	LocalePuffer(a5),a0
		ext.l	d0
		add.l	d0,d0
		move.w	(a0,d0.l),d0			;kein ext.l weil immer
		lea	(a1,d0.w),a0
.Error:		move.l	a0,d0

	*---------- Nun LocaleString aus Catalog suchen ---------*
		move.l	LocaleBase(a5),d1
		beq.s	.Return
		move.l	d1,a6
		move.l	MyCatalog(a5),d1
		beq.s	.Return
		move.l	d1,a0
		move.l	d0,a1
		move.l	d2,d0				* Stringnummer
		subq.l	#1,d0
		ext.l	d0
		jsr	_LVOGetCatalogStr(a6)		*--> d0=valid String

.Return:	movem.l	(a7)+,d1/d2/a0/a1/a6
		rts

*-----------------------------------------------------------------------------*
* Input: *a0=TextAdr (Font)						      *
*	 a0=Text							      *
* Output:d0=Size							      *
*-----------------------------------------------------------------------------*
GetTextlength2:	movem.l	d1-a6,-(a7)
		bsr	GetLocaleString
		move.l	d0,a0
		bra.s	getTextlength3
GetTextlength:	movem.l	d1-a6,-(a7)
GetTextlength3:	lea	MyIntuiText(pc),a2
		move.l	Font(a5),8(a2)
		move.l	a0,12(a2)
		move.l	a2,a0
		move.l	IntBase(a5),a6
		jsr	_LVOIntuiTextLength(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Diese Routine berechnet die Size vom String in d0 und setzt falls diese gr  *
* ist d1 neu.								      *
* Input: d0=Localenr							      *
*	 d1=bisherige Width						      *
* Output:d1=Neuer Wert							      *
*-----------------------------------------------------------------------------*
NimmBiggerSize:	movem.l	d2-a6,-(a7)			*Input: d0=Nummer
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	GetTextlength
		cmp.w	d0,d1
		bhi.s	.D1IstBigger
		move.l	d0,d1
		ext.l	d1
.D1IstBigger:	movem.l	(a7)+,d2-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Text
NimmBiggerSize2:movem.l	d2-a6,-(a7)			*Input: d0=Nummer
		bsr	GetTextlength
		cmp.w	d0,d1
		bhi.s	.D1IstBigger
		move.l	d0,d1
		ext.l	d1
.D1IstBigger:	movem.l	(a7)+,d2-a6
		rts

*;;
*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
AddEntries:	movem.l	d1-a6,-(a7)
		moveq	#-1,d7

		*-- Muss Requester ausgefhrt werden --*
		lea	SelectName(a5),a1
		lea	SelectDir(a5),a0
		move.w	#LENr_SelectFiles,d0
		bsr	DT_MultiFileRequest	*a0=MultiSelectZeiger
		beq.w	.Return
		move.l	d0,a4
		move.l	d0,-(a7)

		lea	PathPuffer(a5),a1
		lea	SelectDir(a5),a0
		move.w	#PathPufferSize-2,d1
		bsr	StringCopy
		move.l	d1,d5

		lea	PathPuffer(a5),a0
		bsr	MakeCorrectDir
		bsr	BerechStringSize
		lea	(a0,d0.w),a1

		sub.l	a2,a2
		bsr	GetSelectedStruct
		bne.s	.First
		move.l	a0,a2
.First:		bsr	RemoveList
		lea	Moduleslist(a5),a0
		move.l	a1,a3
.NextEntry:	move.l	a3,a1
		move.l	MaxEntries(a5),d4
		move.l	rtfl_name(a4),d0
		beq.s	.Next
		move.l	d0,a0
		move.l	rtfl_Strlen(a4),d1
		cmp.l	d5,d1
		blo.s	.NimmD1
		move.l	d5,d1
.Nimmd1:	bsr	StringCopy
		cmp.l	#-1,rtfl_Strlen(a4)
		bne.s	.File
		bsr	SubDirs
		bne.s	.Error
		bra.s	.SubDirs2

.File:		movem.l	a1/a3/a4,-(a7)
		lea	PathPuffer(a5),a1
		sub.l	a3,a3
		sub.l	a4,a4
		bsr	InsertItem
		movem.l	(a7)+,a1/a3/a4
		clr.b	(a1)
		bne.s	.Error
.Next:		move.b	#1,ListeChanged(a5)
		cmp.l	MaxEntries(a5),d4
		beq.s	.SubDirs2
		addq.l	#1,SelectedEntry(a5)
.SubDirs2:	move.l	(a4),d0
		beq.s	.AllesOk
		move.l	d0,a4
		bra.s	.NextEntry

.Error:		moveq	#LENr_ErrorWhileAdding,d0
		moveq	#LENr_Ok,d1
		bsr	TextRequest
		bra.s	.ErrorRet

.AllesOk:	moveq	#0,d7
.ErrorRet:	bsr	ReAddList

		move.l	(a7)+,a0
		bsr	FreeFileList

.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* a1=Adresse fr Filenamen (davor korrigiertes Dir)
* a2=PL_Struct, die davorsteht
* d5=Restsize des Puffers
SubDirs:	movem.l	d1-a1/a3-a6,-(a7)
		moveq	#-1,d7			* Error

		moveq	#DOS_FIB,d1
		moveq	#0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOAllocDosObject(a6)
		move.l	d0,a4
		tst.l	d0
		beq.w	.Return

		lea	PathPuffer(a5),a0
		bsr	HoleReadLock
		tst.l	d0
		beq.w	.FreeDosObject
		move.l	d0,d6

		move.l	a4,d2
		move.l	d6,d1
		move.l	Dosbase(a5),a6
		jsr	_LVOExamine(a6)
		tst.l	d0
		beq.s	.FreeLock2

		lea	PathPuffer(a5),a0
		bsr	MakeCorrectDir
		bsr	BerechStringSize
		lea	(a0,d0.w),a3

		*-- Schleife fr Dirs --*
.SNextEntry:	move.l	MaxEntries(a5),d3
		move.l	d6,d1			*Handle
		move.l	a4,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOExNext(a6)
		tst.l	d0
		beq.s	.FreeLock

		*--- Namen kopieren ---*
		lea	fib_filename(a4),a0
		move.l	a3,a1
		move.l	d5,d1
		bsr	StringCopy

		tst.l	fib_direntrytype(a4)
		blt.s	.Filename
		movem.l	a1/d5,-(a7)
		bsr	SubDirs
		movem.l	(a7)+,d5/a1
		tst.l	d0
		bne.s	.FreeLock2
		bra.s	.SNextEntry

.Filename:	lea	PathPuffer(a5),a1
		lea	ModulesList(a5),a0
		movem.l	a3/a4,-(a7)
		sub.l	a3,a3
		sub.l	a4,a4
		bsr	InsertItem
		movem.l	(a7)+,a3/a4
		tst.l	d0
		bne.s	.FreeLock2
		move.b	#1,ListeChanged(a5)
		cmp.l	MaxEntries(a5),d3
		beq.s	.SNextEntry
		addq.l	#1,SelectedEntry(a5)
		bra.s	.SNextEntry

.FreeLock:	moveq	#0,d7
.FreeLock2:	move.l	d6,d1
		beq.s	.FreeDosObject
		bsr	FreeFileLock

.FreeDosObject:	moveq	#DOS_FIB,d1
		move.l	a4,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOFreeDosObject(a6)

.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a1/a3-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Input: a0=Pfad
*	 a3=Modulesprefs
* Output:d0=Error oder NULL
*	 a2=Diese Node
*-----------------------------------------------------------------------------*
AddEntry:	movem.l	d1-a6,-(a7)
		move.l	a0,a1

		sub.l	a2,a2
		bsr	GetSelectedStruct
		bne.s	.First
		move.l	a0,a2
.First:		lea	ModulesList(a5),a0

	*---------------------- Inserte einen Eintrag in eine Liste ------------------*
	* Input: a0=Liste							      *
	*	 a1=Pfad des Eintrages (0-terminiert)				      *
	*	 a2=Node, die davorsteht oder NULL fr erste			      *
	*	 a3=ModulesPrefs (0-terminiert)					      *
	* Output:d0=Error oder NULL						      *
	*	 a2=Diese Node damit nchsten Eintrag hinter diesem eingeordnet wird  *
	*-----------------------------------------------------------------------------*
		bsr	InsertItem
		bne.s	.Not
		addq.l	#1,SelectedEntry(a5)
		move.b	#1,ListeChanged(a5)
.Not:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
DeleteEntry:	bsr	GetSelectedStruct
		bne.w	Del_Return

		bsr	M_ClearPrefs

		move.b	#1,ListeChanged(a5)

		moveq	#0,d1
		move.b	ListeDa(a5),d1
		move.l	d1,-(a7)
		bsr	RemoveList

		subq.l	#1,MaxEntries(a5)

		move.l	a0,-(a7)
		lea	PL_Node(a0),a1
		cmp.l	#1,SelectedEntry(a5)
		bne.s	.FromMitte

		*Remhead
		lea	Moduleslist(a5),a0
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)
.Empty:

		tst.l	MaxEntries(a5)
		bne.s	.DEL_Ok
		clr.l	SelectedEntry(a5)
		bra.s	.DEL_OK
.FromMitte	REMOVE
		move.l	MaxEntries(a5),d0
		cmp.l	SelectedEntry(a5),d0
		bhs.s	.Del_Ok
		move.l	d0,SelectedEntry(a5)
.Del_Ok:	move.l	(a7)+,a1
		bsr	FreeThisNode

		move.b	#1,ListeChanged(a5)
		move.l	(a7)+,d1
		tst.l	d1
		beq.s	Del_Return
		bsr	ReAddList		
Del_Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*

*-----------------------------------------------------------------------------*
Top:		cmp.l	#1,SelectedEntry(a5)
		ble.s	.Return

		bsr	GetSelectedStruct
		bne.s	.Return
		move.b	#1,ListeChanged(a5)

		bsr	RemoveList

		lea	PL_Node(a0),a1
		move.l	a1,-(a7)
		REMOVE
		move.l	(a7)+,a1
		lea	Moduleslist(a5),a0
		ADDHEAD

		move.l	MaxEntries(a5),d0

		move.b	#1,ListeChanged(a5)
		move.l	#1,SelectedEntry(a5)
		bsr	ReAddList
		bsr	ErlaubeGadgets
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
Botom:		move.l	MaxEntries(a5),d0
		cmp.l	SelectedEntry(a5),d0
		beq.s	.Return

		bsr	GetSelectedStruct
		bne.s	.Return
		move.b	#1,ListeChanged(a5)

		bsr	RemoveList

		lea	PL_Node(a0),a0
		move.l	a0,a1
		move.l	a0,-(a7)

		cmp.l	#1,SelectedEntry(a5)
		bne.s	.NoFirst
		*Remhead
		lea	Moduleslist(a5),a0
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)
.empty:		bra.s	.removed

.NoFirst:	REMOVE
.removed:	move.l	(a7)+,a1
		lea	Moduleslist(a5),a0
		ADDTAIL

		move.l	MaxEntries(a5),d0

		move.b	#1,ListeChanged(a5)
		move.l	MaxEntries(a5),SelectedEntry(a5)
		bsr	ReAddList
		bsr	ErlaubeGadgets
.Return:	moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
Up:		cmp.l	#1,SelectedEntry(a5)
		ble.s	.Return

		bsr	GetSelectedStruct
		bne.s	.Return
		move.b	#1,ListeChanged(a5)

		bsr	RemoveList

		lea	PL_Node(a0),a1
		move.l	a1,-(a7)
		REMOVE
		move.l	(a7)+,a1
		lea	Moduleslist(a5),a0
		move.l	LN_Pred(a1),d0
		beq.s	.A2NUll
		move.l	d0,a2
		move.l	LN_Pred(a2),d0
.A2Null:	move.l	d0,a2

	*---------------------- Inserte einen Eintrag in eine Liste ------------------*
	* Input: a0=Liste							      *
	*	 a1=Neue Node							      *
	*	 a2=Node, die davorsteht oder NULL fr erste			      *
	*-----------------------------------------------------------------------------*
		bsr	InsertInList

		move.b	#1,ListeChanged(a5)
		subq.l	#1,SelectedEntry(a5)
		bsr	ReAddList
		bsr	ErlaubeGadgets
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
Down:		move.l	MaxEntries(a5),d0
		cmp.l	SelectedEntry(a5),d0
		beq.s	.Return

		bsr	GetSelectedStruct
		bne.s	.Return
		move.b	#1,ListeChanged(a5)

		bsr	RemoveList

		lea	PL_Node(a0),a0
		move.l	a0,a1
		move.l	a0,-(a7)

		cmp.l	#1,SelectedEntry(a5)
		bne.s	.NoFirst
		*Remhead
		lea	Moduleslist(a5),a0
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)
.empty:		bra.s	.removed

.NoFirst:	REMOVE
.removed:	move.l	(a7)+,a1

	*---------------------- Inserte einen Eintrag in eine Liste ------------------*
	* Input: a0=Liste							      *
	*	 a1=Neue Node							      *
	*	 a2=Node, die davorsteht oder NULL fr erste			      *
	*-----------------------------------------------------------------------------*
		lea	Moduleslist(a5),a0
		move.l	LN_Succ(a1),a2
		bsr	InsertInList

		move.b	#1,ListeChanged(a5)
		addq.l	#1,SelectedEntry(a5)
		bsr	ReAddList
		bsr	ErlaubeGadgets
.Return:	moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
* Beim Start wird eine defaulte Liste geladen.
*-----------------------------------------------------------------------------*
LoadStartList:	movem.l	d0-a6,-(a7)
		move.w	EUS_Structure+PrefsFlags(pc),d0
		btst	#PFF_Synchron,d0
		beq.s	.NoLoad
		lea	ListName(a5),a0
		move.l	a0,d2
		lea	ListDir(a5),a1
		sub.l	a2,a2
		bsr	InsertList
		bra.w	.Ok

.NoLoad:	;Get List from EP
.ok:		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
LoadList:	bsr	MakeNewList
		moveq	#0,d0
		tst.l	MaxEntries(a5)
		bne.w	Return
		moveq	#0,d2
		sub.l	a1,a1
		sub.l	a2,a2

*-----------------------------------------------------------------------------*
* Input: d2=0 oder Ptr zu Filename
*	 a1=Ptr zum Dir oder NULL
*	 a2=Node, die davorsteht oder NULL fr erste (nur bei d2<>0)
InsertList:	movem.l	d1-a6,-(a7)

		*-- Muss Requester ausgefhrt werden --*
		tst.l	d2
		beq.s	.FileReq
		move.l	d2,a0
		tst.b	(a0)
		bne.s	.FilenameDa

.FileReq:	lea	Listname(a5),a1
		lea	ListDir(a5),a0
		move.w	#LENr_SelectAList,d0
		bsr	DT_MultiFileRequest2
		beq.w	.AllesOk
		move.l	d0,a4

		sub.l	a2,a2
		bsr	GetSelectedStruct
		bne.s	.NoFirst
		move.l	a0,a2
.NoFirst:	moveq	#108,d5
.NextEntry:	move.l	MaxEntries(a5),d4
		move.l	rtfl_name(a4),d0
		beq.s	.Next
		move.l	d0,a0
		move.l	rtfl_Strlen(a4),d1
		cmp.l	d5,d1
		blo.s	.NimmD1
		move.l	d5,d1
.Nimmd1:	lea	ListName(a5),a1
		bsr	StringCopy

		lea	ListDir(a5),a1
		lea	ListName(a5),a0
		move.l	a4,-(a7)
		bsr	InsertThisList
		move.l	(a7)+,a4
.Next:		move.l	(a4),d0
		beq.s	.AllesOk
		move.l	d0,a4
		bra.s	.NextEntry

.FilenameDa:	bsr	InsertThisList
.AllesOk:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Input: a0=Filename
*	 a1=Dir
*	 a2=Structur
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
InsertThisList:	move.l	a0,TextRequestArgs(a5)
		bsr	OpenArchive
		bne.s	.Archive
		bsr	LoadADatei
		beq.s	.Return

		*--- Listentyp testen ---*
		clr.b	PathPuffer(a5)		* fr Default Dir (APlayer)
		bsr	CheckListType
		beq.s	.FreeList
		move.b	#1,ListeChanged(a5)
.Archive:	cmp.l	#0,a2			* wenn nicht insertet wird,
		bne.s	.NoFree			* dann alte Liste freigeben
		bsr	FreeList
	*---------------------------------------------------------*
	* Hier beginnt jetzt die Schleife, in der die einzelnen   *
	* Items eingeordnet werden.				  *
	* d0=Listensize						  *
	* d1=Listentyp						  *
	* d2=Position in Datei					  *
	* a0=Listenadr						  *
	* a1=Pfad des Entries					  *
	* a2=Struct, die davorsteht oder NULL			  *
	* a3=ModulesPrefs					  *
	* a4=Moduleseigenschaften				  *
	*---------------------------------------------------------*
.NoFree:	bsr	RemoveList
		movem.l	d0/a0,-(a7)
		move.l	d0,d4


		move.w	EUS_Structure+PrefsFlags(pc),d0
		move.l	d0,-(a7)
		cmp.w	#LTY_Archive,d1		;Nei Archiven nach Einstellung
		beq.s	.NextEntry
		bclr	#PFF_HideAll,d0
		move.w	d0,EUS_Structure+PrefsFlags


		*- Hole nchsten Eintrag aus Liste -*
.NextEntry:	move.l	d4,d0
		bsr	GetNextItemFromList
		bne.s	.ItsAll

		bsr	InsertItem
		beq.s	.NextEntry

		*-- Liste freigeben
.ItsAll:	cmp.l	#1,d0
		bls.s	.Ok
		moveq	#LENr_ErrorInList,d0
		moveq	#LENr_Ok,d1
		bsr	TextRequest
.Ok:		move.l	(a7)+,d0
		move.w	d0,EUS_Structure+PrefsFlags
		movem.l	(a7)+,d0/a0		* Memdaten der Liste
.FreeList:	bsr	FreeDateiMem
		bsr	ReAddList
.Return:	rts


*-----------------------------------------------------------------------------*
*---------------------- Inserte einen Eintrag in eine Liste ------------------*
* Input: a0=Liste							      *
*	 a1=Pfad des Eintrages (0-terminiert)				      *
*	 a2=PL_Struct, die davorsteht oder NULL fr erste			      *
*	 a3=ModulesPrefs (0-terminiert)					      *
*	 a4=Moduleseigenschaften (0-terminiert)
* Output:d0=Error oder NULL						      *
*	 a2=Diese Node damit nchsten Eintrag hinter diesem eingeordnet wird  *
*-----------------------------------------------------------------------------*
InsertItem:	movem.l	d1-a1/a3-a6,-(a7)

		bsr	TestAufHide
		beq.w	.Ret

		move.b	ListeDa(a5),d1
		move.l	d1,-(a7)
		bsr	RemoveList

		*--- Jetzt einfgen ---*
		move.l	a0,d7
		move.l	a1,a0
		bsr	BerechStringSize
		move.l	#$10000,d1
		EB
		add.l	#PL_Chars+PL_Strings+Sicherheitsbytes,d0
		move.l	d0,d3
		move.l	a1,-(a7)
		jsr	_LVOAllocmem(a6)
		move.l	(a7)+,a1
		tst.l	d0
		beq.w	.Error

		*---- Jetzt Strings kopieren -----*
		move.l	d0,a6
		lea	PL_Chars(a6),a0
		move.l	a0,PL_Pfad(a6)
		move.l	d3,PL_StructSize(a6)
		move.l	a1,a0
		lea	PL_Chars(a6),a1
		move.w	d3,d1
		sub.w	#PL_Chars+PL_Strings+Sicherheitsbytes+1,d1
		bsr	StringCopy

		lea	PL_MEStruct(a6),a6
		bsr	InsertModulesPrefs
		lea	-PL_MEStruct(a6),a6
		tst.l	d0
		bne.s	.Error3


		*--- Jetzt in Node einfgen ----*
		*d7=Liste
		*a2=Node davor
.NoEigen:	addq.l	#1,MaxEntries(a5)
*		lea	Pl_Chars(a6),a0
*.FWP:		move.b	(a0)+,d1
*		beq.s	.NoArc
*		cmp.b	#"\",d1
*		bne.s	.FWP
*		move.l	a0,PL_Filename(a6)
*
*		lea	Pl_Chars(a6),a1
*		bsr	GetFileName		*sind im Grundverzeichnis
*		cmp.l	a0,a1
*		beq.s	.NoArc
*
*		*--- Bei Archiven ist Show without Prefix sinnlos ---*
*		move.l	PL_Pfad(a6),a0
*		btst	#PFF_ShowPath,d0
*		beq.s	.NoShowPath
*		move.l	a0,PL_Node+LN_Name(a6)
*.NoShowPath:	cmp.l	a0,a1
*		bne.s	.NoArc
*		bra.s	.NoMore

.NoArc:		lea	Pl_Chars(a6),a1
		bsr	GetFileName
		move.l	a1,PL_Filename(a6)
		move.w	EUS_Structure+PrefsFlags(pc),d0
		btst	#PFF_ShowName,d0
		bne.s	.NoShowName
		move.l	a1,PL_Node+LN_Name(a6)
.NoShowName:	move.l	a1,a0
.NextB:		move.b	(a1)+,d1
		beq.s	.NoMore
		cmp.b	#".",d1
		bne.s	.NextB
		tst.b	(a1)
		beq.s	.NoMore
		move.l	a1,a0
.NoMore:	btst	#PFF_ShowPath,d0
		bne.s	.ShowPath
		btst	#PFF_ShowName,d0
		beq.s	.NoShowPre
		move.l	a0,PL_Node+LN_Name(a6)
		bra.s	.NoShowPre
.ShowPath:	move.l	PL_Pfad(a6),PL_Node+LN_Name(a6)
.NoShowPre:	move.l	a0,PL_Name(a6)
		lea	PL_Node(a6),a1
		lea	Moduleslist(a5),a0
		cmp.l	#0,a2
		beq.s	.NoAdd
		lea	PL_Node(a2),a2
.NoAdd:		bsr	InsertInList
		move.l	a6,a2				;PL_Struct
		moveq	#0,d0
		bra.s	.Return

		*--- Error ---*
.Error3:	move.l	PL_MEStruct+MPE_ModulesPrefs(a6),d0
		beq.s	.Error
		move.l	d0,a1
		move.l	PL_MEStruct+MPE_ModulesPrefsSize(a6),d0
		EB
		jsr	_LVOFreeMem(a6)
.Error2:	move.l	a6,d0
		beq.s	.Error
		move.l	d0,a1
		move.l	PL_StructSize(a6),d0
		beq.s	.Error
		EB
		jsr	_LVOFreeMem(a6)
.Error:		moveq	#-1,d0				;Fehler
.Return:	move.l	(a7)+,d1
		tst.b	d1
		beq.s	.Ret
		bsr	ReAddList

.Ret:		movem.l	(a7)+,d1-a1/a3-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a3=Modulesprefs oder NULL
*	 a4=Moduleseigenschaften
*	 a6=MEStruct
* Output:d0=0=ok
InsertModulesPrefs
		movem.l	d1-a6,-(a7)
		move.l	a3,a0
		bsr	BerechStringSize
		beq.s	.NoModulePrefs
		move.l	#$10000,d1
		addq.l	#Sicherheitsbytes,d0
		move.l	d0,d3
		move.l	a6,-(a7)
		EB
		jsr	_LVOAllocmem(a6)
		move.l	(a7)+,a6
		tst.l	d0
		beq.w	.Error

		move.l	d0,MPE_ModulesPrefs(a6)
		move.l	d3,MPE_ModulesPrefsSize(a6)
		move.l	d0,a1
		move.l	a3,a0
		move.l	d3,d1
		sub.l	#Sicherheitsbytes-1,d1
		bsr	StringCopy

.NoModulePrefs:	move.l	a4,a0
		bsr	BerechStringSize
		beq.s	.NoEigen
		move.l	#$10000,d1
		addq.l	#Sicherheitsbytes,d0
		move.l	d0,d3
		move.l	a6,-(a7)
		EB
		jsr	_LVOAllocmem(a6)
		move.l	(a7)+,a6
		tst.l	d0
		beq.w	.Error2

		move.l	d0,MPE_Eigenschaften(a6)
		move.l	d3,MPE_EigenschaftenSize(a6)
		move.l	d0,a1
		move.l	a4,a0
		move.l	d3,d1
		sub.l	#Sicherheitsbytes-1,d1
		bsr	StringCopy
.NoEigen:	moveq	#0,d0
		bra.s	.Return

.Error2:	move.l	MPE_ModulesPrefs(a6),d0
		beq.s	.Error
		move.l	d0,a1
		move.l	MPE_ModulesPrefsSize(a6),d0
		EB
		jsr	_LVOFreeMem(a6)
.Error:		moveq	#-1,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
TestAufHide:	movem.l	d1-a6,-(a7)
		moveq	#1,d0
		move.w	EUS_Structure+PrefsFlags(pc),d1
		btst	#PFF_HideAll,d1
		beq.s	.NoTest
		move.l	EPBase(pc),a4
		move.l	a1,a0
		if	Debugger!Executable
		jsr	ENPP_TestAufHide(a4)
		endc
.NoTest:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a1=Pfad des Engines
* output:a1=start des filenamens
GetFilename:	movem.l	a0/d0,-(a7)
		move.l	a1,a0
		sub.l	a1,a1
		bsr	BerechStringSize
		*subq.l	#1,d0
		beq.s	.No
		lea	(a0,d0.w),a0
.NextB:		move.b	-(a0),d1
		beq.s	.No
		cmp.b	#"/",d1
		beq.s	.Yes
		cmp.b	#":",d1
		beq.s	.Yes
		subq.l	#1,d0
		bne.s	.NextB
		subq.l	#1,a0
.Yes:		lea	1(a0),a1
.No:		movem.l	(a7)+,a0/d0
		rts



*---------------------- Inserte einen Eintrag in eine Liste ------------------*
* Input: a0=Liste							      *
*	 a1=Neue Node							      *
*	 a2=Node, die davorsteht oder NULL fr erste			      *
*-----------------------------------------------------------------------------*
InsertInList:	movem.l	d0/a0/a3,-(a7)

		*-- Erster Eintrag --*
		move.l	a2,d0
		bne.s	.NoFirst
		ADDHEAD
		bra.s	.Return

		*-- Letzter Eintrag --*
.NoFirst:	cmp.l	LH_TailPred(a0),a2
		bne.s	.NoLast
		ADDTAIL
		bra.s	.Return

.NoLast:	move.l	LN_Succ(a2),d0			;Vorgnger in a2
		beq.s	.Return
		move.l	d0,a3				;Nachfolger in a3

		move.l	a1,LN_Succ(a2)			;Verk. zum Vorgnger
		move.l	a1,LN_Pred(a3)			;Verk. zum Nachfolger

		move.l	a2,LN_Pred(a1)
		move.l	a3,LN_Succ(a1)

.Return:	movem.l	(a7)+,d0/a0/a3
		rts

*-----------------------------------------------------------------------------*

*-----------------------------------------------------------------------------*
* Routinen, die alle Engines anhpft, die vom angegebenen Type sind active    *
* sind und den entsprechenden Tag haben.				      *
*-----------------------------------------------------------------------------*
* Input: d0/d1/d2/a0/a1/a2=Args						      *
*	 d3=Enginetype							      *
*	 d4=FirstEngineNr (bei der das Suchen beginnt)			      *
*	 d5=Tag								      *
* Output:d0/d1/d2/a0/a1/a2=Args						      *
*	 d3=Error oder NULL						      *
*	 d4=EngineNr							      *
*-----------------------------------------------------------------------------*
* Input: a0=Filename
*	 a1=Dirname
* Output:d0=ArchiveNummer oder NULL
*	 d1=Type (LTY_Archive)
*	 a0=ArchiveStructur oder FILENAME (bei d0=0) !!!!!!!!!!!
*-----------------------------------------------------------------------------*
OpenArchive:	movem.l	d2-d7/a1-a6,-(a7)

		move.l	a0,a4
		move.l	a1,a3
		move.l	a1,d1
		move.l	#-2,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoDir1
		jsr	_LVOCurrentDir(a6)
.NoDir1:	move.l	d0,-(a7)
		bsr	CheckArc
		move.l	d0,d4
		move.l	(a7)+,d1
		tst.l	d1
		beq.s	.NoDir
		movem.l	d4/a0,-(a7)
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
		movem.l	(a7)+,d4/a0
.NoDir:		move.l	d4,d0
		tst.l	d0
		beq.w	.Error

		*--- Pfad des Archives in den PathPuffer kopieren ---*
		movem.l	d0/a0,-(a7)
		move.l	#Arc_Size+MemDazu,d0	;wird bei FreeListMem raufkopiert
		move.l	#$10001,d1
		EB
		jsr	_LVOAllocMem(a6)
		movem.l	(a7)+,d1/a0
		move.l	d0,a2
		tst.l	d0
		beq.s	.CloseArchive
		move.l	d1,ARC_EngineNr(a2)
		move.l	a0,ARC_ExtractorStruct(a2)
		move.l	#Arc_Size,ARC_StructSize(a2)

		move.l	a3,a0
		lea	ARC_PathPuffer(a2),a1
		move.l	#Arc_Size-ARC_PathPuffer-4,d1	;fr 0,/
		bsr	StringCopy
		lea	Arc_PathPuffer(a2),a0
		bsr	MakeCorrectDir
		lea	Arc_PathPuffer(a2),a0
		bsr	BerechStringSize
		lea	(a0,d0.w),a1
		move.l	a4,a0
		bsr	StringCopy
	*	move.b	#"\",(a1)+
		move.b	#"/",(a1)+
		clr.b	(a1)
		move.l	a1,ARC_EntryFilePtr(a2)
		lea	ARC_PathPuffer(a2),a0
		bsr	BerechStringSize
		move.l	#Arc_Size-ARC_PathPuffer-2,d1
		sub.l	d0,d1
		move.l	d1,ARC_RestFileSize(a2)

		move.l	a2,a0
		move.l	ARC_StructSize(a0),d0
		moveq	#LTY_Archive,d1
		bra.s	.Return

.CloseArchive:	move.l	d1,d4
		bsr	CloseArchive

.Error:		*moveq	#LENr_CouldListNotload,d0
		*moveq	#LENR_Ok,d1
		*bsr	TextRequest
		moveq	#0,d0
		move.l	a4,a0
.Return:	movem.l	(a7)+,d2-d7/a1-a6
		tst.l	d0
		rts

		*--- Nun Archive ffnen ---*
CheckArc:	movem.l	d1-d2/d5-d7/a1-a6,-(a7)
		moveq	#0,d4				*FirstSearchEngineNr
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_OpenArchive,d5		*Tag
		lea	(a4),a0				*Filename
		move.l	EUS_Structure+EUS_EPBase(pc),a6
		if	Executable!Debugger
		jsr	ENPP_UserCallup5(a6)
		else
		moveq	#-1,d0
		endc
		subq.w	#1,d4
		movem.l	(a7)+,d1-d2/d5-d7/a1-a6
		tst.l	d3
		bne.s	.NoArchive
		tst.l	d0
		bne.w	.NoArchive
		move.l	d4,d0
		moveq	#LTY_Archive,d1
		bra.s	.Ret

.NoArchive:	moveq	#0,d0
		sub.l	a0,a0
.Ret:		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: a0=ExtractorStructure
*	 d4=EngineNr
* Output:
*-----------------------------------------------------------------------------*
CloseArchive:	movem.l	d0-a6,-(a7)
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_CloseArchive,d5		*Tag
		move.l	EUS_Structure+EUS_EPBase(pc),a6
		if	Executable!Debugger
		jsr	ENPP_UserCallUp5(a6)
		endc
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0/d0=Liste im Speicher
* Output:d1=Listtype oder NULL
*	 d2=Position in der Liste
*-----------------------------------------------------------------------------*
CheckListType:	movem.l	d0/d3-a6,-(a7)
		moveq	#0,d2
		tst.l	d0
		beq.w	.Return
		cmp.l	#8,d0			;Size zu klein
		blt.w	.Return
		move.l	a0,d0
		beq.w	.Return

		*--- Auf Eagleplayerliste testen --*
		cmp.l	#"EP-L",(a0)
		bne.s	.NoEPList
		cmp.l	#"IST"<<8!10,4(a0)
		bne.s	.NoEPList
		moveq	#8,d2
		moveq	#LTY_Eagleplayer,d1
		*clr.b	EPInsertEntryType(a5)
		bra.w	.Return

		*--- Auf Delitrackerliste testen --*
.NoEPList:	cmp.l	#"MODL",(a0)
		bne.s	.NoDTList
		cmp.l	#"IST"<<8!10,4(a0)
		bne.s	.NoDTList
		moveq	#8,d2
		moveq	#LTY_Delitracker,d1
		bra.w	.Return

		*---- AccessiblePlayer ----*
.NoDTList:	cmp.l	#"@*Ap",(a0)
		bne.s	.NoAPlayer
		cmp.l	#"ML*@",4(a0)
		bne.s	.NoAPlayer
		moveq	#8,d2
.APlayerNext:	addq.l	#1,d2
		move.b	(a0,d2.w),d0
		beq.w	.UnknownType
		cmp.b	#"@",d0
		bne.s	.APlayerNext
		moveq	#LTY_APlayer,d1
		bra.w	.Return

		*--- Bananaplay ----*
.NoAPlayer:	cmp.l	#"BP20",(a0)
		bne.s	.NoBananaPlayer
		cmp.l	#"LIST",4(a0)
		bne.s	.NoBananaPlayer
		move.l	#$74,d2
		moveq	#LTY_BananaPlay,d1
		bra.w	.Return

		*--- Hippoplayer ----*
.NoBananaPlayer:cmp.l	#"HIPP",(a0)
		bne.s	.NoHippoplayer
	*	cmp.w	#$524f,4(a0)
	*	bne.s	.NoHippoplayer
		tst.b	8(a0)
		bne.s	.NoHippoplayer
		move.l	#$9,d2
		moveq	#LTY_Hippoplayer,d1
		bra.s	.Return

		*--- Empy + Multiplayer ---*
.NoHippoplayer:	cmp.l	#"PROG",(a0)
		bne.s	.NoEmpy
		cmp.l	#"RAM"<<8!10,4(a0)
		bne.s	.NoEmpy
		move.l	#$8,d2
		moveq	#LTY_Empy,d1
		bra.s	.Return

		*--- Smartplay ---*
.NoEmpy:	cmp.l	#"SPP2",(a0)
		bne.s	.NoSSP
		cmp.w	#$2000,4(a0)
		bne.s	.NoSSP
		move.l	#$6,d2
		moveq	#LTY_Smartplay,d1
		bra.s	.Return

		*--- MELGU ---*
.NoSSP:		cmp.l	#"EPLS",(a0)
		bne.s	.NoMELGU
		moveq	#8,d2
		moveq	#LTY_MELGU,d1
		bra.s	.Return

		*--- DASMod ---*
.NoMELGU:	cmp.l	#"DASP",(a0)
		bne.s	.NoDasM
		cmp.l	#"MODL",4(a0)
		bne.s	.NoDasM
		moveq	#$C,d2
		moveq	#LTY_DASMod,d1
		bra.s	.Return

		*--- Unknown List ---*
.NoDasM:

.UnknownType:	moveq	#LENr_UnknownListFormat,d0
		moveq	#LENr_Ok,d1
		bsr	TextRequest
		moveq	#0,d1

.Return:	movem.l	(a7)+,d0/d3-a6
		tst.l	d1
		rts

*-----------------------------------------------------------------------------*
* Input: d0/a0=Memdaten der Liste
*	 d1=Type der Liste
*	 d2=Position
* Output:d0=Error(-1) oder NULL Ende=1
*	 d2=neue Position
*	 a1=Pfad des Eintrages
*	 a3=ModulesPrefs oder NULL
*-----------------------------------------------------------------------------*
GetNextItemFromList:
		movem.l	d1/d3-d7/a0/a2/a5-a6,-(a7)
		sub.l	a1,a1
		sub.l	a3,a3
		sub.l	a4,a4
		cmp.l	#LTY_Eagleplayer,d1
		beq.w	.Eagleplayer
		cmp.l	#LTY_DeliTracker,d1
		beq.w	.DeliTracker
		cmp.l	#LTY_APlayer,d1
		beq.w	.APlayer
		cmp.l	#LTY_BananaPlay,d1
		beq.w	.BananaPlay
		cmp.l	#LTY_Hippoplayer,d1
		beq.w	.Hippoplayer
		cmp.l	#LTY_Empy,d1
		beq.w	.Empy
		cmp.l	#LTY_Smartplay,d1
		beq.w	.Smartplay
		cmp.l	#LTY_Archive,d1
		beq.s	.Archive
		cmp.l	#LTY_MELGU,d1
		beq.w	.MELGU
		cmp.l	#LTY_DASMod,d1
		beq.s	.DasMod
		moveq	#-1,d0
		bra.w	.Return

		* a0=Adresse der ARC_Structure
		* d0=Size der Structure
.Archive:	move.l	ARC_EngineNr(a0),d4
		movem.l d1-a6,-(a7)
		move.l	ARC_EntryFilePtr(a0),a1
		clr.b	(a1)
		move.l	ARC_RestFileSize(a0),d1
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_ArchiveExNext,d5		*Tag
		move.l	EUS_Structure+EUS_EPBase(pc),a6
		move.l	ARC_ExtractorStruct(a0),a0
		if	Executable!Debugger
		jsr	ENPP_UserCallUp5(a6)
		else
		moveq	#-1,d0
		endc
		movem.l	(a7)+,d1-a6
		tst.l	d0
		bne.s	.Arc_CloseArchive
		lea	ARC_PathPuffer(a0),a1
		sub.l	a3,a3
		sub.l	a4,a4
		moveq	#0,d0
		bra.w	.KeineModPrefs

.Arc_CloseArchive:
		move.l	ARC_ExtractorStruct(a0),d1
		clr.l	ARC_ExtractorStruct(a0)
		move.l	d1,a0
		bsr	CloseArchive
		cmp.w	#EPR_NoMoreEntries,d0
		bne.w	.Error
		bra.w	.Ende

*-----------------------------------------------------------*


		*----- DASMod -----*
.DASMod:	cmp.l	d0,d2
		bhs.w	.Ende
		lea	(a0,d2.l),a0		*Anfang der Structure
		lea	$70(a0),a1
		move.l	a0,-(a7)
		lea	Unknown(pc),a0
		bsr	StrCMP
		beq.s	.DASKeinAuthor
		lea	-3(a1),a3
		move.b	#"9",-3(a3)
		move.b	#"6",-2(a3)
		move.b	#"=",-1(a3)
.DASKeinAuthor:	move.l	(a7)+,a0
		lea	$82(a0),a1
		bsr	ReadLong
		add.l	d0,d2
		add.l	#$86,d2
		lea	4(a1),a1		*Pfad
		moveq	#0,d0
		bra.w	.KeineModPrefs


		*---- MELGU -----*
.MELGU:		cmp.l	d0,d2
		bhs.w	.Ende

		moveq	#0,d0
		lea	6(a0,d2.l),a0
		move.l	a0,a1
		bsr	BerechStringSize
		add.l	d0,d2
		addq.l	#8,d2
		clr.b	(a1,d0.l)
		lea	1(a0,d0.w),a0
		bsr	BerechStringSize
		add.l	d0,d2			*Lnge des Commentars
		moveq	#0,d0
		bra.w	.KeineModPrefs



		*--------- Smartplay --------*
.Smartplay:	cmp.l	d0,d2
		bhs.w	.Ende
		lea	(a0,d2.l),a1
		add.l	#$ca,d2
		sub.l	a3,a3
		bra.w	.KeineModPrefs


		*---------- Empy ------------*
.Empy:		cmp.l	d0,d2
		bhs.w	.Ende
		lea	(a0,d2.l),a1
		cmp.b	#9,(a1)
		bne.s	.No9
		addq.l	#3,d2
		bra.s	.Empy
.No9:		bsr	ReadLong
		cmp.l	#"DIR ",d0
		bne.s	.NoDir
		addq.l	#4,d2
		move.l	a0,a3
		lea	(a0,d2.l),a0
		bsr	BerechStringSize2
		tst.l	d0
		beq.w	.Error
		move.l	d0,d1
		add.l	d0,d2
		addq.l	#1,d2				*Enter
		subq.l	#1,d1
		lea	PathPuffer(a5),a1
		bsr	StringCopy
		lea	PathPuffer(a5),a0
		bsr	MakeCorrectDir
		move.l	a3,a0

.NoDir:		lea	(a0,d2.l),a0
		lea	PathPuffer(a5),a1
		bsr	GetFileName
		clr.b	(a1)
		bsr	BerechStringsize2
		beq.w	.Error
		move.l	d0,d1
		add.l	d0,d2
		addq.l	#1,d2				*Enter
		subq.l	#1,d1
		bsr	StringCopy
		sub.l	a3,a3
		lea	PathPuffer(a5),a1
		bra.w	.KeineModPrefs

		*-------- Hippoplayer -------*
.Hippoplayer:	cmp.l	d0,d2
		bhs.w	.Ende
		lea	(a0,d2.l),a1
		moveq	#0,d1
		move.b	(a1)+,d1
		beq.w	.Error
		add.l	d1,d2
		addq.l	#2,d2
		sub.l	a3,a3
		bra.w	.KeineModPrefs


		*------- Bananaplay --------*
.BananaPlay:	lea	(a0,d2.l),a0
		bsr	BerechStringSize2
		beq.w	.Ende
		move.l	a0,a1
		sub.l	a3,a3
		add.l	d0,d2
		add.l	#(9*4)+2,d2		; 9*4 Infos 1=Leerkennung
		bclr	#0,d2			; + 1 zum gerademachen
		bra.w	.KeineModPrefs


		*-------- APlayer --------*
.APlayer:	subq.l	#1,d2
.APlayerNext:	addq.l	#1,d2
		move.b	(a0,d2.l),d0
		beq.w	.Ende
		cmp.b	#"@",d0
		beq.s	.a_NewPath
		cmp.b	#10,d0
		beq.s	.APlayerNext
		bra.w	.NormalName

.A_NewPath:	lea	(a0,d2.l),a1
		bsr	ReadLong
		cmp.l	#"@*Pa",d0
		bne.s	.A_NoNewPath
		addq.l	#4,a1
		bsr	ReadLong
		cmp.l	#"th*@",d0
		bne.s	.A_NoNewPath

		*-- neuer Pfad --*
		cmp.b	#10,4(a1)
		bne.w	.Error
		add.l	#9,d2

		move.l	a0,-(a7)
		lea	(a0,d2.l),a0
		bsr	BerechStringSize2
		move.l	(a7)+,a0
		tst.l	d0
		beq.w	.Error
		move.l	d0,d1
		subq.l	#1,d1
		movem.l	d0/a0,-(a7)
		lea	PathPuffer(a5),a1
		lea	(a0,d2.l),a0
		bsr	StringCopy		
		lea	PathPuffer(a5),a0
		bsr	MakeCorrectDir
		movem.l	(a7)+,d0/a0
		add.l	d0,d2
		bra.s	.APlayerNext

.A_NoNewPath:	lea	(a0,d2.l),a1
		bsr	ReadLong
		cmp.l	#"@*Na",d0
		bne.s	.NormalName
		addq.l	#4,a1
		bsr	ReadLong
		cmp.l	#"mes*",d0
		bne.s	.NormalName
		cmp.b	#"@",4(a1)
		bne.w	.Error
		cmp.b	#10,5(a1)
		bne.w	.Error
		add.l	#10,d2
		bra.s	.Normal2

.NormalName:	lea	PathPuffer(a5),a1
		bsr	GetFileName
		clr.b	(a1)
.Normal2:	lea	(a0,d2.l),a0
		bsr	BerechStringSize2
		beq.w	.Error
		movem.l	d0/a0,-(a7)
		lea	PathPuffer(a5),a0
		bsr	BerechStringSize
		lea	(a0,d0.l),a1
		movem.l	(a7)+,d0/a0
		add.l	d0,d2
		move.l	d0,d1
		subq.l	#1,d1
		bsr	StringCopy

		lea	PathPuffer(a5),a1
		sub.l	a3,a3
		bra.w	.KeineModPrefs

		*--- Eagleplayerprogram geladen ---*
.Eagleplayer:	*--- Delitrackerprogram geladen ---*
.Delitracker:	cmp.l	d0,d2
		bhs.w	.Ende
		move.l	d0,d4
		cmp.l	#0,a0
		beq.w	.Ende
		add.l	d2,a0
.EP_EineZeile2:	cmp.b	#10,(a0)
		beq.s	.EP_EineZeile
		bsr	BerechStringSize2
		beq.w	.Error

	*--- Auf Gruppen/Autorenprefs achten ---*
		cmp.l	#4,d0
		blo.w	.EP_NoAG
		move.l	a0,a1
		move.l	d0,d1
		bsr	ReadLong
		exg	d0,d1
		cmp.l	#"@GRO",d1
		beq.w	.EP_Gruppen
		cmp.l	#"@AUT",d1
		bne.w	.EP_NoAG
		lea	Autorlist+AGL_List(a5),a4
		bra.s	.EP_AG

.EP_EineZeile:	addq.l	#1,a0
		addq.l	#1,d2
		bra.s	.EP_EineZeile2

	*- Input:a0=Zeilenstart
	*-	 d0=Lnge des Strings
	*Output: d0=Error(-1) oder NULL Ende=1
	*	 d2=neue Position
	*	 a1=Pfad des Eintrages
	*	 a3=ModulesPrefs oder NULL
.EP_Gruppen:	lea	Gruppenlist+AGL_List(a5),a4
.EP_AG:		sub.l	d2,a0			;Start
		add.l	d0,d2
		addq.l	#1,d2			;enter nach @GROUPS

.EP_OtherNext:	move.l	a0,-(a7)
		cmp.l	d4,d2
		bhs.w	.EP_AGEnd
		cmp.l	#0,a0
		beq.w	.EP_AGEnd
		lea	(a0,d2.l),a1
		bsr	ReadLong
		cmp.l	#"@END",d0
		beq.s	.EP_AGEnd
		lea	(a0,d2.l),a0
		bsr	BerechStringSize2
		beq.w	.EP_AGEnd2
		move.l	a4,-(a7)
		bsr	EPNextEntry
		move.l	a4,d1
		move.l	(a7)+,a4
		move.l	d0,-(a7)
		bne.s	.EPG_Next
		move.l	a1,a0
		bsr	AG_InsertItem
		tst.l	d0
		beq.s	.EPG_Next
		lea	AGS_MEStruct(a0),a6
		move.l	a4,-(a7)
		move.l	d1,a4
		bsr	InsertModulesPrefs
		move.l	(a7)+,a4
.EPG_Next:	move.l	(a7)+,d0
		move.l	(a7)+,a0
		tst.l	d0
		bne.s	.Ende2
		bra.s	.EP_OtherNext

.EP_AGEnd:	lea	(a0,d2.l),a0
		addq.l	#1,d2			;Enter nach @END
.EP_AGEnd2:	bsr	BerechStringSize2
		add.l	d0,d2
		move.l	d4,d0
		move.l	(a7)+,a0
		bra.w	.Eagleplayer


	*a0=Adr des Stings
	*d0=Lnge des Strings
.EP_NoAG:	bsr	EPNextEntry
		bra.s	.return

.KeineModPrefs:	moveq	#0,d0
		bra.s	.Return

.Error:		moveq	#-1,d0
		bra.s	.Ende2

		*--- keine weiteren Eintrge ---*
.Ende:		moveq	#1,d0
.Ende2:		sub.l	a1,a1
		sub.l	a3,a3

.Return:	movem.l	(a7)+,d1/d3-d7/a0/a2/a5-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Start der Zeile
*	 d0=Lnge des Strings (Entry/Gruppe/Autor)
* Output:d0=Error(-1) oder NULL Ende=1
*	 d2=neue Position
*	 a1=Pfad des Eintrages
*	 a3=ModulesPrefs oder NULL
*	 a4=Moduleseigenschaften
*-----------------------------------------------------------------------------*
EPNextEntry:	movem.l	d1/d3-d7/a0/a2/a5-a6,-(a7)
		sub.l	a4,a4
		sub.l	a3,a3

		move.b	(a0,d0.w),d3
		clr.b	(a0,d0.w)
		add.l	d0,d2
		addq.l	#1,d2
		move.l	a0,a1

		cmp.b	#10,d3				*Kennung kein ModPrefs
		beq.w	.KeineModPrefs

		cmp.b	#"'",d3
		beq.s	.Ja
		cmp.b	#'"',d3
		beq.s	.Ja
		cmp.b	#"`",d3
		bne.s	.Normal
.Ja:		addq.l	#1,d2				*Ganse adden
		addq.l	#1,a0

		*-- Ist noch soviel Platz in der Datei ?
.Normal:	move.l	d2,d3
		addq.l	#4,d3
		cmp.l	d4,d3
		bhs.s	.KeineModPrefs

		addq.l	#1,d2				*Leerzeichen
		lea	1(a0,d0.l),a0			*Start of Prefs
		cmp.b	#"M",(a0)
		bne.s	.CheckEigen
		cmp.b	#"P",1(a0)
		bne.s	.CheckEigen
		cmp.b	#":",2(a0)
		bne.s	.CheckEigen
		addq.l	#3,a0
		move.l	a0,-(a7)
		bsr	BerechStringSize3
		clr.b	(a0,d0.l)
		move.l	a0,a3
		move.l	(a7)+,a0
		add.l	d1,d2
		addq.l	#4,d2			;Leerzeichen,MP:


		move.l	d2,d3
		addq.l	#4,d3
		cmp.l	d4,d3
		bhs.s	.KeineModPrefs

		lea	1(a0,d1.l),a0			*Start of Prefs
.CheckEigen:	cmp.b	#"M",(a0)
		bne.s	.KeineModPrefs
		cmp.b	#"E",1(a0)
		bne.s	.KeineModPrefs
		cmp.b	#":",2(a0)
		bne.s	.KeineModPrefs

		addq.l	#3,a0
		bsr	BerechStringSize3
		clr.b	(a0,d0.l)
		move.l	a0,a4
		add.l	d1,d2			;Size mit Ganse
		addq.l	#4,d2			;Leerzeichen,MP
.KeineModPrefs:	moveq	#0,d0
		movem.l	(a7)+,d1/d3-d7/a0/a2/a5-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: a1=Adresse
* Output:d0=Longinhalt ab a1
*-----------------------------------------------------------------------------*
ReadLong:	move.b	(a1),d0
		lsl.l	#8,d0
		move.b	1(a1),d0
		lsl.l	#8,d0
		move.b	2(a1),d0
		lsl.l	#8,d0
		move.b	3(a1),d0
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Ladt eine Datei ins Mem. Das Dir muss gesetzt sein.
* Input: a0=Filename
*	 a1=Dirname
* Output:d0=Filesize oder NULL
*	 a0=Adr
*-----------------------------------------------------------------------------*
LoadADatei:	movem.l	d1-d7/a1-a6,-(a7)
	*ifeq	Executable!Debugger
	*	lea	Testlist,a0
	*	move.l	#Testlistsize,d0
	*else
		move.l	a0,a4
		move.l	a1,d1
		move.l	#-2,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoDir1
		jsr	_LVOCurrentDir(a6)
.NoDir1:	move.l	d0,-(a7)
		bsr	LoadOneDatei
		move.l	d0,d4
		move.l	(a7)+,d1
		tst.l	d1
		beq.s	.NoDir
		movem.l	d4/a0,-(a7)
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
		movem.l	(a7)+,d4/a0
.NoDir:		move.l	d4,d0
		tst.l	d0
		bne.s	.Return
.Error:		moveq	#LENr_CouldListNotload,d0
		moveq	#LENR_Ok,d1
		bsr	TextRequest
		moveq	#0,d0
		sub.l	a0,a0
	*endc
.Return:	movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Dir sollte gesetzt sein
* Input: a4=Filename
* Output:d0=Filesize oder NULL
*	 a0=Adr
LoadOneDatei:	movem.l	d1-d7/a1-a6,-(a7)
		sub.l	a3,a3

		*--- FileInfoBlock holen ---*
		move.l	a4,d1
		moveq	#-2,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d6
		beq.w	.Return
		move.l	d0,d1
		bsr	GetExamine
		move.l	d0,-(a7)
		move.l	d6,d1
		jsr	_LVOUnlock(a6)
		move.l	(a7)+,d0
		tst.l	d0
		beq.w	.Error

		*---- Speicher holen ----*
		move.l	InfoBlock+124(a5),d0
		add.l	#MemDazu,d0
		EB
		move.l	#$10000,d1
		jsr	_LVOAllocMem(a6)
		move.l	d0,a3
		tst.l	d0
		beq.s	.Error


		*----- File reinladen -----*
		move.l	a4,d1
		move.l	#1005,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	d0,d7
		beq.w	.Error2
		move.l	InfoBlock+124(a5),d3
		move.l	a3,d2
		move.l	d7,d1
		jsr	_LVORead(a6)
		move.l	d0,-(a7)
		move.l	d7,d1
		jsr	_LVOClose(a6)
		move.l	(a7)+,d0
		cmp.l	d0,d3
		bne.s	.Error2
		move.l	InfoBlock+124(a5),d0
		move.l	a3,a0
		bra.s	.Return


		*------- Error ------*
.Error2:	move.l	a3,d0
		beq.s	.Error
		move.l	d0,a1
		move.l	InfoBlock+124(a5),d0
		add.l	#MemDazu,d0
		EB
		jsr	_LVOFreeMem(a6)
		move.l	d0,a3
.Error:		moveq	#0,d0
		move.l	d0,a0
.Return:	movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Input: d0=Size des Mems
*	 a0=Adr des Mems
FreeDateiMem:	movem.l	d0-a6,-(a7)
		tst.l	d0
		beq.s	.Return
		move.l	a0,d1
		beq.s	.Return
		move.l	a0,a1
		EB
	*if	Executable!Debugger
		add.l	#MemDazu,d0
		jsr	_LVOFreemem(a6)
	*endc
.Return:	movem.l	(a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
* Input: d2=0 oder Ptr zu Filename
*	 a1=Ptr zum Dir oder NULL
*	 a2=Node, die davorsteht oder NULL fr erste			      *
*-----------------------------------------------------------------------------*
SaveList:	moveq	#0,d2
		moveq	#-1,d7

		movem.l	d1-a6,-(a7)
		*move.l	a2,a4

		*-- Muss Requester ausgefhrt werden --*
		tst.l	d2
		beq.s	.FileReq
		move.l	d2,a0
		tst.b	(a0)
		bne.s	.FilenameDa

.FileReq:	lea	Listname(a5),a1
		lea	ListDir(a5),a0
		move.w	#LENr_SelectAList,d0
		bsr	DT_FileRequest
		beq.w	.Return
		lea	Listname(a5),a0
		lea	ListDir(a5),a1

		*--- Dir setzen und overwrite abfragen ---*
.FileNameDa:	move.l	a0,a3
		bsr	SetDir
		move.l	d0,-(a7)
		bsr	HoleReadLock
		beq.s	.NoOverWrite
		move.l	d0,d1
		bsr	FreeFileLock

		*--- Overwrite ? ---*
		move.w	EUS_Structure+PrefsFlags(pc),d0
		btst	#PFF_Overwrite,d0
		bne.s	.NoOverwrite

		move.l	a0,TextRequestArgs(a5)
		moveq	#LENr_OverwriteIt,d0
		moveq	#LENr_YesNo,d1
		bsr	TextRequest		1=yes
		beq.s	.FreeDir

		*-- Safe Handle ffnen ---*
.NoOverWrite:	lea	SafeSaveName(pc),a0
		bsr	HoleWriteHandle
		beq.s	.Error2
		move.l	d0,d1
		movem.l	a1/a2/a3,-(a7)
		lea	SaveListHeaderHook(pc),a3
		*lea	ModulesList(a5),a2
		*move.l	MaxEntries(a5),d2
		bsr	SaveListNow
		bsr	FreeHandle
		movem.l	(a7)+,a1/a2/a3
		tst.l	d0			*Error von SaveListNow
		bne.s	.Error

		move.l	a3,d1
		move.l	Dosbase(a5),a6
		jsr	_LVODeleteFile(a6)
		*tst.l	d0
		*beq.s	.Error
		lea	SafeSaveName(pc),a0
		move.l	a0,d1
		move.l	a3,d2
		jsr	_LVORename(a6)
		tst.l	d0
		beq.s	.Error
		moveq	#0,d7
		clr.b	ListeChanged(a5)
		bra.s	.FreeDir

		*--- Fehler ---*
.Error:		lea	SafeSaveName(pc),a0
		move.l	a0,d1
		move.l	Dosbase(a5),a6
		jsr	_LVODeleteFile(a6)

		*--- Overwrite ? ---*
.Error2:	move.l	a3,TextRequestArgs(a5)
		moveq	#LENr_CouldListNotSave,d0
		moveq	#LENr_Ok,d1
		bsr	TextRequest

.FreeDir:	move.l	(a7)+,d1
		bsr	FreeDir

.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Bei der Allokation werden Memdazu Bytes dazuaddiert!!!!!!!!!!!!!
* Input: d0=Size
* Output:d0=Adr oder NULL
AllocMem:	movem.l	d1-a6,-(a7)
		EB
		move.l	#$10000,d1
		add.l	#Memdazu,d0
		jsr	_LVOAllocMem(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Bei der Allokation werden Memdazu Bytes dazuaddiert!!!!!!!!!!!!!
* Input: d0=Size
* Output:d0=Adr oder NULL
AllocMem2:	movem.l	d1-d2/a0/a1/a6,-(a7)
		EB
		move.l	#$10000,d1
		jsr	_LVOAllocMem(a6)
		movem.l	(a7)+,d1-d2/a0/a1/a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a1=Adr
*	 d0=Size
*
FreeMem:	movem.l	d0-a6,-(a7)
		move.l	a1,d1
		beq.s	.Return
		EB
		add.l	#Memdazu,d0
		jsr	_LVOFreeMem(a6)
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a1=Adr
*	 d0=Size
FreeMem2:	movem.l	d0-d2/a0/a1/a6,-(a7)
		move.l	a1,d1
		beq.s	.Return
		EB
		jsr	_LVOFreeMem(a6)
.Return:	movem.l	(a7)+,d0-d2/a0/a1/a6
		rts


*-----------------------------------------------------------------------------*
* Input: a2=Derzeitige Adr der Node
*	 d2=Nummer der Node
* Output:d0=Filesize oder 0       -1=Error -2=Ende
*	 a0=Adr
*	 a3=neuer Hook
*-----------------------------------------------------------------------------*
SaveListHeaderHook:
		lea	PysionHeader(pc),a0
		moveq	#PysionHeaderSize,d0
		tst.l	GlobalPrefs(a5)
		beq.s	.NoPrefs
		moveq	#PysionHeaderSize+4,d0
.NoPrefs:	lea	SLGlobalPrefs(pc),a3
		rts

	*--- @GLOBAL wird geschrieben, falls ntig und dann wird der Hook
	*--- auf SLG_Kennung gesetzt ---*
SLGlobalPrefs:	lea	SLG_Kennung(pc),a3
		move.l	GlobalPrefs(a5),d0
		beq.s	.Return

		lea	GlobalKennung(pc),a0
		bsr	BerechStringSize

		lea	SLGlobalEnd(pc),a3
		move.l	a3,d2
		lea	SLMP_ModPrefsKennung(pc),a3
.Return:	rts

	*--- @END wird geschrieben ---*
SLGlobalEnd:	lea	SLG_Kennung(pc),a3
		lea	EndKennung(pc),a0
		moveq	#5,d0
		rts


	*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*
	* Ab hier werden die einzelnen Gruppeneintrge geschrieben !!!! *
	*--- Gansefsschen schreiben, wenn Moduleprefs/Eigen ---*
	*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*
SLG_Kennung:	lea	Gruppenlist(a5),a2
		move.l	(a2),a2
		tst.l	(a2)
		beq.s	.KeineGruppen
		lea	Gruppenlist(a5),a2
		lea	Gruppenkennung(pc),a0
		bsr	BerechStringSize
		lea	SLG_GruppenExNext(pc),a3
		rts

.KeineGruppen:	lea	SLA_Kennung(pc),a3
		moveq	#0,d0
		rts

SLG_GruppenExNext:
		lea	SLG_Name(pc),a3
		move.l	(a2),a2
		moveq	#0,d0
		tst.l	(a2)
		beq.s	.ItsAll
		tst.l	-AGS_Node+AGS_MEStruct+MPE_ModulesPrefs(a2)	;keine Gnse wenn ohne Config
		bne.s	.Ganse
		tst.l	-AGS_Node+AGS_MEStruct+MPE_Eigenschaften(a2)	;keine Gnse wenn ohne Config
		beq.s	.Ret
.Ganse:		lea	GanseZeichen(pc),a0
		moveq	#1,d0
.Ret		rts


.ItsAll:	lea	SLG_End(pc),a3
.Return:	moveq	#0,d1
		sub.l	a0,a0
		rts

		*--- Gruppenname schreiben ---*
SLG_Name:	move.l	LN_Name(a2),a0
		bsr	BerechStringSize
		lea	SLG_Ganse(pc),a3
		rts

		*--- Ganse fr AutorNamen schreiben ---*
SLG_Ganse:	lea	SLG_GruppenExNext(pc),a3
		move.l	a3,d2
		lea	SLMP_ModPrefsKennung(pc),a3
		lea	-AGS_Node+AGS_MeStruct(a2),a1
		lea	GanseZeichen(pc),a0
		moveq	#0,d0
		tst.l	MPE_ModulesPrefs(a1)	;keine Gnse wenn ohne Config
		bne.s	.Ganse
		tst.l	MPE_Eigenschaften(a1)	;keine Gnse wenn ohne Config
		beq.s	.Ret
.Ganse:		moveq	#1,d0
.Ret		rts

	*--- @END wird geschrieben ---*
SLG_End:	lea	SLA_Kennung(pc),a3
		lea	EndKennung(pc),a0
		moveq	#5,d0
		rts

	*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*
	* Ab hier werden die einzelnen Autoreneintrge geschrieben !!!! *
	*--- Gansefsschen schreiben, wenn Moduleprefs/Eigen ---*
	*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*
SLA_Kennung:	lea	Autorlist(a5),a2
		move.l	(a2),a2
		tst.l	(a2)
		beq.s	.KeineAutoren
		lea	Autorlist(a5),a2
		lea	Autorkennung(pc),a0
		bsr	BerechStringSize
		lea	SLA_AutorExNext(pc),a3
		rts

.KeineAutoren:	lea	SLM_Kennung(pc),a3
		moveq	#0,d0
		rts

SLA_AutorExNext:lea	SLA_Name(pc),a3
		move.l	(a2),a2
		moveq	#0,d0
		tst.l	(a2)
		beq.s	.ItsAll
		tst.l	-AGS_Node+AGS_MEStruct+MPE_ModulesPrefs(a2)	;keine Gnse wenn ohne Config
		bne.s	.Ganse
		tst.l	-AGS_Node+AGS_MEStruct+MPE_Eigenschaften(a2)	;keine Gnse wenn ohne Config
		beq.s	.Ret
.Ganse:		lea	GanseZeichen(pc),a0
		moveq	#1,d0
.Ret		rts

.ItsAll:	lea	SLA_End(pc),a3
.Return:	moveq	#0,d1
		sub.l	a0,a0
		rts

		*--- Autorenname schreiben ---*
SLA_Name:	move.l	LN_Name(a2),a0
		bsr	BerechStringSize
		lea	SLA_Ganse(pc),a3
		rts

		*--- Ganse fr AutorNamen schreiben ---*
SLA_Ganse:	lea	SLA_AutorExNext(pc),a3
		move.l	a3,d2
		lea	SLMP_ModPrefsKennung(pc),a3
		lea	-AGS_Node+AGS_MeStruct(a2),a1
		lea	GanseZeichen(pc),a0
		moveq	#0,d0
		tst.l	MPE_ModulesPrefs(a1)	;keine Gnse wenn ohne Config
		bne.s	.Ganse
		tst.l	MPE_Eigenschaften(a1)	;keine Gnse wenn ohne Config
		beq.s	.Ret
.Ganse:		moveq	#1,d0
.Ret		rts

	*--- @END wird geschrieben ---*
SLA_End:	lea	SLM_Kennung(pc),a3
		lea	EndKennung(pc),a0
		moveq	#5,d0
		rts








	*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*
	* Ab hier werden die einzelnen Moduleeintrge geschrieben !!!! *
	*--- Gansefsschen schreiben, wenn Moduleprefs/Eigen ---*
	*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*
SLM_Kennung:	lea	Moduleslist(a5),a2
		move.l	MaxEntries(a5),d3
		lea	SLM_ModuleEXNext(pc),a3
		lea	Enterzeichen(pc),a0
		moveq	#1,d0
		rts

SLM_ModuleExNext:
		lea	SLM_Name(pc),a3
		subq.l	#1,d3
		blt.s	.ItsAll
		move.l	(a2),d0
		beq.s	.ItsAll
		*beq.s	.Error
		move.l	d0,a2

		moveq	#0,d0
		tst.l	-PL_Node+PL_MEStruct+MPE_ModulesPrefs(a2)	;keine Gnse wenn ohne Config
		bne.s	.Ganse
		tst.l	-PL_Node+PL_MEStruct+MPE_Eigenschaften(a2)	;keine Gnse wenn ohne Config
		beq.s	.Ret
.Ganse:		lea	GanseZeichen(pc),a0
		moveq	#1,d0
.Ret		rts

.Error:		moveq	#1,d0
		rts

.ItsAll:	moveq	#-2,d0
.Return:	moveq	#0,d1
		sub.l	a0,a0
		rts

		*---- Namen schreiben ----*
SLM_Name:	move.l	-PL_Node+PL_Pfad(a2),a0
		bsr	BerechStringSize
		lea	SLM_Ganse(pc),a3
		rts

		*--- Ganse fr Namen schreiben ---*
SLM_Ganse:	lea	SLM_ModuleExNext(pc),a3
		move.l	a3,d2
		lea	SLMP_ModPrefsKennung(pc),a3
		lea	-PL_Node+PL_MeStruct(a2),a1
		lea	GanseZeichen(pc),a0
		moveq	#0,d0
		tst.l	MPE_ModulesPrefs(a1)	;keine Gnse wenn ohne Config
		bne.s	.Ganse
		tst.l	MPE_Eigenschaften(a1)	;keine Gnse wenn ohne Config
		beq.s	.Ret
.Ganse:		moveq	#1,d0
.Ret		rts



	*-- Moduleprefshook --*
	*-- a2=MEStruct
	*-- d2=Hook nach MEStruct schreiben


		*---- Kennung fr Moduleprefs ----*
		*--- Gansefsse fr Module + Leerzeichen
SLMP_ModPrefsKennung:
		lea	SLMP_ModPrefs(pc),a3
		move.l	MPE_ModulesPrefs(a1),d0
		beq.s	.Return
		lea	Kenn_ModulesPrefs(pc),a0
		moveq	#5,d0
.Return:	rts

		*---- Moduleprefs schreiben ---*
SLMP_ModPrefs:	move.l	MPE_ModulesPrefs(a1),d0
		beq.s	.Return
		move.l	d0,a0
		bsr	BerechStringSize
.Return:	lea	SLMP_ModPrefsGanse(pc),a3
		rts

		*--- Gansefsse fr Modulesprefs ---*
SLMP_ModPrefsGanse:
		lea	SLMP_ModEigenkennung(pc),a3
		move.l	MPE_ModulesPrefs(a1),d0
		beq.s	.Return
		lea	GanseZeichen(pc),a0
		moveq	#1,d0
.Return:	rts

		*---- Kennung fr Eigen ---*
SLMP_ModEigenKennung:
		lea	SLMP_ModEigen(pc),a3
		move.l	MPE_Eigenschaften(a1),d0
		beq.s	.Return
		lea	SpaceZeichen(pc),a0	;Kenn_ModulesEigen
		moveq	#5,d0
.Return:	rts


		*---- Eigenschaften schreiben ---*
SLMP_ModEigen:	move.l	MPE_Eigenschaften(a1),d0
		beq.s	.Return
		move.l	d0,a0
		bsr	BerechStringSize
.Return:	lea	SLMP_ModEigenGanse(pc),a3
		rts

		*---- Gansefsschen fr Eigenschaften ---*
SLMP_ModEigenganse:
		lea	SLMP_Enter(pc),a3
		move.l	MPE_Eigenschaften(a1),d0
		beq.s	.Return
		lea	Gansezeichen(pc),a0
		moveq	#1,d0
.Return:	rts

SLMP_Enter:	lea	EnterZeichen(pc),a0
		moveq	#1,d0
		move.l	d2,a3
		rts


*-----------------------------------------------------------------------------*
* Input: d0=Filehandle
*	 a3=Hook
*	 a2=Parameter fr Hook
*	 d2=Parameter fr Hook
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
SaveListNow:	movem.l	d1-a6,-(a7)
		move.l	d0,d6			* Filehandle
		moveq	#-1,d7

		*-- Schreibmem besorgen --*
		move.l	#WritePufferSize,d0
		bsr	AllocMem
		move.l	d0,a4
		beq.s	.Error
		moveq	#0,d5			* Position im Writepuffer

		*--- Einsprung in die Hook-Routine ---*
		* Input: a3=Hook
		*	 d3=Parameter innerhalb der Hooks
		*	 a1=Parameter innerhalb der Hooks
		*	 a2=Parameter
		*	 d2=Parameter
		* Output:d0=WriteSize oder NULL -1=Error -2=Ende
		*	 a0=Memadr
		*	 a3=neuer Hook
.NextHook:	jsr	(a3)
		tst.l	d0
		blt.s	.ItsAll
		beq.s	.NextHook

		*---- Jetzt Schreiben ----*
		move.l	d0,d4
		bsr	WriteInPuffer
		beq.s	.NextHook
		bra.s	.Error

		*-- Restlichen Bytes aus dem Puffer schreiben ---*
.ItsAll:	cmp.l	#-2,d0
		bne.s	.Error
		move.l	d5,d3
		bsr	WritePuffer

		*-- Schreibmem freigeben --*
		moveq	#0,d7
.Error:		move.l	a4,a1
		move.l	#WritePufferSize,d0
		bsr	FreeMem

		move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d4=Writesize
*	 d5=Position in Puffer
*	 d6=FileHandle
*	 a0=Memadr
*	 a4=WritePufferstart
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
WriteInPuffer:	movem.l	d1-d4/d6-a6,-(a7)
.Retry:		move.l	#WritePufferSize,d1
		sub.l	d5,d1				*Size die noch zur Verf
		cmp.l	d1,d4				*gung steht
		bhi.s	.WriteInD1
		move.l	d4,d1
.WriteInD1:	lea	(a4,d5.w),a1
		add.l	d1,d5
		bsr	CopyText

		cmp.l	d1,d4				*gung steht
		bls.s	.Ok
		move.l	#WritePufferSize,d3
		bsr	WritePuffer
		bne.s	.Error
		moveq	#0,d5
		sub.w	d1,d4
		bra.s	.Retry

.Ok:		moveq	#0,d0
		bra.s	.Return


.Error:		moveq	#-1,d0
.Return:	movem.l	(a7)+,d1-d4/d6-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: d6=Handle
*	 a4=Puffer
*	 d3=Size
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
WritePuffer:	movem.l	d1-a6,-(a7)
		move.l	d6,d1
		move.l	a4,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOWrite(a6)
		cmp.l	d0,d3
		bne.s	.Error
		moveq	#0,d0
.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
CopyText:	move.l	d1,-(a7)
		subq.l	#1,d1
		blt.s	.Error
.NextB:		move.b	(a0)+,(a1)+
		dbf	d1,.NextB
.Error:		move.l	(a7)+,d1
		rts

*-----------------------------------------------------------------------------*
* Input: a1=Dirname
* Output:d0=Old Dirlock
SetDir:		movem.l	d1-a6,-(a7)
		move.l	a1,d1
		move.l	#-2,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOLock(a6)
		tst.l	d0
		beq.s	.NoDirLock
		move.l	d0,d1
		jsr	_LVOCurrentDir(a6)
.NoDirLock:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d1=Dirname
* Output:--
FreeDir:	movem.l	d0-a6,-(a7)
		tst.l	d1
		beq.s	.NoDirLock
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnLock(a6)
.NoDirLock:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=File
* Outout:d0=FileLock
*-----------------------------------------------------------------------------*
HoleReadLock:	movem.l	d1-a6,-(a7)
		move.l	a0,d1
		move.l	#-2,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOLock(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d1=FileLock
* Outout:--
*-----------------------------------------------------------------------------*
FreeFileLock:	movem.l	d0-a6,-(a7)
		move.l	Dosbase(a5),a6
		jsr	_LVOUnLock(a6)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=File
* Outout:d0=FileHandle
*-----------------------------------------------------------------------------*
HoleWriteHandle:movem.l	d1-a6,-(a7)
		move.l	a0,d1
		move.l	#1006,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d1=FileHandle
* Outout:--
*-----------------------------------------------------------------------------*
FreeHandle:	movem.l	d0-a6,-(a7)
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: d1=Lock
*	 a0=InfoBlock
* Output:d0=0 Error
*-----------------------------------------------------------------------------*
GetExamine:	movem.l	d1-a6,-(a7)
		lea	InfoBlock(a5),a0
		move.l	a0,d2
		move.w	#259,d3
.ClrInfo:	clr.b	(a0)+
		dbf	d3,.ClrInfo
		jsr	_LVOExamine(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
PlayModule:	movem.l	d0-a6,-(a7)
		bsr	GetSelectedStruct
		bne.s	.Return
		move.l	PL_Pfad(a0),a0
		bsr	BerechStringSize
		move.l	d0,d1
		move.l	a0,d0
		moveq	#EPNr_LoadModule,d3
		bsr	SendMess
.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
LoadAtStart:	move.b	MI_Flags(a1),d0
		and	#1,d0				*Zustand jetzt in d0

		move.w	PrefsFlags+EUS_Structure(pc),d1
		and.b	#~[PFB_LoadAtStart],d1
		lsl.l	#PFF_LoadAtStart,d0
		or.b	d0,d1
		move.w	d1,PrefsFlags+EUS_Structure
		tst.b	d0
		beq.s	.Return
		tst.l	MaxEntries(a5)
		bne.s	.Return
		bsr	LoadStartList
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
HideAll:	move.b	MI_Flags(a1),d0
		and	#1,d0				*Zustand jetzt in d0

		move.w	PrefsFlags+EUS_Structure(pc),d1
		and.b	#~[PFB_HideAll],d1
		lsl.l	#PFF_HideAll,d0
		or.b	d0,d1
		move.w	d1,PrefsFlags+EUS_Structure
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
Synchron:	move.b	MI_Flags(a1),d0
		and	#1,d0				*Zustand jetzt in d0

		move.w	PrefsFlags+EUS_Structure(pc),d1
		and.b	#~[PFB_Synchron],d1
		*lsl.l	#PFF_Synchron,d0
		or.b	d0,d1
		move.w	d1,PrefsFlags+EUS_Structure
		*tst.b	d0
		*beq.s	.Return
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
Overwrite:	move.b	MI_Flags(a1),d0
		and	#1,d0				*Zustand jetzt in d0

		move.w	PrefsFlags+EUS_Structure(pc),d1
		and.b	#~[PFB_Overwrite],d1
		lsl.l	#PFF_Overwrite,d0
		or.b	d0,d1
		move.w	d1,PrefsFlags+EUS_Structure
		*tst.b	d0
		*beq.s	.Return
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
AutoLearnAuthors:move.b	MI_Flags(a1),d0
		and	#1,d0				*Zustand jetzt in d0

		move.w	PrefsFlags+EUS_Structure(pc),d1
		and.b	#~[PFB_AutoLearnAuthors],d1
		lsl.l	#PFF_AutoLearnAuthors,d0
		or.b	d0,d1
		move.w	d1,PrefsFlags+EUS_Structure
		tst.b	d0
		beq.s	.Return
		bsr	LoadAuthors
.Return:	moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
ShowbyName:	moveq	#PL_Name,d6
		moveq	#PFB_ShowName,d1
		bra.s	Show
ShowbyFName:	moveq	#PL_Filename,d6
		moveq	#0,d1
		bra.s	Show
ShowbyPath:	moveq	#PL_Pfad,d6
		moveq	#PFB_ShowPath,d1
Show:		move.w	PrefsFlags+EUS_Structure(pc),d0
		move.l	d0,d2
		and.w	#~[PFB_ShowPath!PFB_ShowName],d0
		or.w	d1,d0
		move.w	d0,PrefsFlags+EUS_Structure

		cmp.l	d2,d0
		beq.s	.Return

.Filename:	bsr	RemoveList
		move.l	MaxEntries(a5),d5
		lea	ModulesList(a5),a4
.Next:		subq.l	#1,d5
		blt.s	.ReAdd
		move.l	(a4),d0
		beq.s	.ReAdd
		move.l	d0,a4
		move.l	-PL_Node(a4,d6.w),a0
		move.l	a0,LN_Name(a4)
		bra.s	.Next

.ReAdd:		bsr	ReAddlist
.Return:	rts

*-----------------------------------------------------------------------------*
SortByFName:	moveq	#PL_Filename-PL_Node,d6
		bra.s	Sortieren
SortByName:	moveq	#PL_Name-PL_Node,d6
		bra.s	Sortieren
SortByPath:	moveq	#PL_Pfad-PL_Node,d6
Sortieren:	bsr	Removelist
		bsr	WaitPointer
		bsr	LeereListe

		lea	Moduleslist(a5),a4
		bsr	SortiereEineListe
		move.b	#1,ListeChanged(a5)
		bsr	ReAddList
		bsr	ClearPointer
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Input: a4=Liste
*	 d6=Offset ab Nodenstart wo Adr des Strings steht
*-----------------------------------------------------------------------------*
SortiereeineListe
		movem.l	d0-a6,-(a7)
		lea	Sortierlist(a5),a6		;Target
		clr.l	(a6)
		clr.l	4(a6)
		clr.l	8(a6)
		newlist	a6

.next:		move.l	lh_tail+ln_pred(a4),a1	;letzten Eintrag der Liste holen
		move.l	ln_Pred(a1),d0
		beq.w	.fertig			;keiner mehr -> fertig

		move.l	d0,lh_tail+ln_pred(a4)	;korrekt rauswerfen
		exg.l	d0,a1
		move.l	a4,(a1)
		addq.l	#4,(a1)
		move.l	d0,a1
						;Eintrag in 2. Liste einsortieren
		lea	(a6),a2
		cmp.l	lh_tail+ln_pred(a6),a6	;Liste leer ?
		beq.s	.addend			;-> hinten ran
.nexttarget:	move.l	(a2),a2			;1. Eintrag holen
		move.l	(a2),d0
		beq.s	.addend

		*move.l	ln_name(a2),a3	;Name old
		*move.l	ln_name(a1),a0	;Name new
		move.l	(a2,d6.w),a3	;Name old
		move.l	(a1,d6.w),a0	;Name new
		*move.w	TYPE_Display+Datas,d0
.cmp		move.b	(A0)+,d1
		beq.s	.add		;Ende des Namens und bisher beide gleich->
				;davor sortieren
		move.b	(a3)+,d2
		beq.s	.nexttarget	;nchsten Vergleich

		cmp.b	#`a`,d1
		blo.s	.nokld1	
		cmp.b	#`z`,d1
		bhi.s	.nokld1
		and.b	#~32,d1	
.nokld1:	cmp.b	#`a`,d2
		blo.s	.nokld2	
		cmp.b	#`z`,d2
		bhi.s	.nokld2
		and.b	#~32,d2	
.nokld2:	cmp.b	d2,d1
		blo.s	.add
		bhi.s	.nexttarget
		*dbf	d0,.cmp
		bra.s	.cmp
		*bra.s	.nexttarget

.add:		move.l	ln_pred(A2),a2
		move.l	(A2),d0
		beq.s	.addhead

		move.l	a2,ln_pred(a1)	;Vorgnger (alte Node) setzen
		move.l	(a2),(a1)	;Nachfolger der alten Node auf diese Node
		move.l	a1,(a2)		;diese node Nachfolger der alten Node
		move.l	(a1),a2		;Nachfolger dieser Node
		move.l	a1,ln_pred(a2)	;diese Node Vorgnger der nachfolgenden
		bra.s	.next

.addhead:	lea	(A6),a0
		addhead	
		bra.w	.next

.addend:	lea	lh_tail(a6),a0
		move.l	ln_pred(A0),d0
		move.l	a1,ln_pred(a0)
		move.l	a0,(a1)
		move.l	d0,ln_pred(a1)
		move.l	d0,a0
		move.l	a1,(a0)
		bra.w	.next
.fertig:	move.l	(A6),(a4)		;lh_Head (=Successor)
		move.l	lh_tailpred(A6),a0	;lh_Tailpred
		move.l	a0,lh_tailpred(a4)

		lea	lh_tail(a4),a1
		move.l	a1,(a0)		;Lh_Tail

		move.l	(A6),a0		;Lh_head -> Nachfolger
		move.l	a4,ln_pred(a0)	;Vorgnger dieser Node auf LH_Head

		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Doppelte Eintrge finden und lschen
*-----------------------------------------------------------------------------*
		rsreset
FDG_Abort	rs.b	1
FDG_Delete1	rs.b	1
FDG_Delete2	rs.b	1
FDG_KillAll1	rs.b	1
FDG_KillAll2	rs.b	1
FDG_Skip	rs.b	1

FindDouble:	cmp.l	#1,MaxEntries(a5)
		ble.s	.Return
		bsr	Removelist
		bsr	WaitPointer
		bsr	LeereListe
		clr.w	KillAllOnDisk(a5)
		move.l	#2,SelectedEntry(a5)

		lea	Moduleslist(a5),a4
		bsr	FindDoubleInList
		move.l	#1,SelectedEntry(a5)
		bsr	ReAddList
		bsr	ClearPointer
.Return:	moveq	#0,d0
		rts

FindDoubleInList:
		lea	(a4),a6			;Source
.setpri0:	move.l	(A6),a6
		tst.l	(A6)
		beq.s	.readypri
		clr.b	ln_pri(A6)
		bra.s	.setpri0

.readypri	lea	(a4),a6			;Source
		moveq	#0,d6
		moveq	#0,d7			;Kennung Kill all 1=1. 2=2.
.next:		move.l	(a6),a6
.next2:		move.l	(a6),d0
		beq.w	.fertig			;keiner mehr -> fertig
		tst.b	ln_pri(A6)		;schon behandelt ?
		bne.s	.next			;ja, nchsten
		move.b	#1,ln_pri(A6)

		lea	(a4),a2			;Source
.nexttarget:	move.l	(a2),a2			;1. Eintrag holen
.nexttarget2:	move.l	(a2),d0
		beq.s	.next			;keiner mehr -> nicht doppelt

		tst.b	ln_pri(A2)
		bne.s	.nexttarget

		cmp.l	a6,a2
		beq.s	.nexttarget		;gleicher Eintrag, also nicht werten

		move.l	-PL_Node+PL_Filename(a2),a3		;Name old
		move.l	-PL_Node+PL_Filename(a6),a0		;Name new
		*move.w	TYPE_Display+Datas,d0	;Anzahl der zu vergl. Zeichen
.cmp:		move.b	(A0)+,d1
		bne.s	.add
		cmp.b	#0,(A3)
		bne.s	.nexttarget	;kommt nicht hin-> nchsten Eintrag vergleichen
		bra.s	.output	

.add:		move.b	(a3)+,d2
		beq.s	.nexttarget	;nchsten Vergleich

		cmp.b	#`a`,d1
		blo.s	.nokld1	
		cmp.b	#`z`,d1
		bhi.s	.nokld1
		and.b	#~32,d1	
.nokld1:	cmp.b	#`a`,d2
		blo.s	.nokld2	
		cmp.b	#`z`,d2
		bhi.s	.nokld2
		and.b	#~32,d2	
.nokld2:	cmp.b	d2,d1
		bne.s	.nexttarget
		*dbf	d0,.cmp
		bra.s	.cmp

.output:	moveq	#1,d6
		cmp.b	#FDG_KillAll1,d7
		beq.s	.kill1
		cmp.b	#FDG_KillAll2,d7
		beq.s	.kill2
		movem.l	d1-a6,-(Sp)
		lea	TextRequestArgs(a5),a3
		move.l	PL_Pfad-PL_Node(a6),a0	;Name old
		move.l	a0,(a3)
		move.l	PL_Pfad-PL_Node(a2),a0	;Name new
		move.l	a0,4(a3)
		moveq	#LENr_DoubleFound,d0
		moveq	#LENr_DoubleGadgets,d1
		bsr	TextRequest
		movem.l	(sp)+,d1-a6
		cmp.w	#FDG_Skip,d0
		beq.w	.Skip
		cmp.w	#FDG_Delete1,d0
		beq.s	.Kill1
		cmp.w	#FDG_Delete2,d0
		beq.s	.Kill2
		cmp.w	#FDG_KillAll1,d0
		beq.s	.DeleteAll1
		cmp.w	#FDG_KillAll2,d0
		beq.s	.DeleteAll2
	*cmp.w	#FDG_Abort,d0
	*beq.s	.Fertig
		bra.s	.Return			-> Kein Requester


.Kill1:		move.l	a6,a1
		bsr	DeleteFromDisk
		remove
		lea	-PL_Node(a6),a1
		move.l	(a6),a6
		bsr	FreeThisNode
		bra.w	.Nexttarget2

.Kill2:		move.l	a2,a1
		bsr	DeleteFromDisk
		remove
		lea	-PL_Node(a2),a1
		move.l	(a2),a2
		bsr	FreeThisNode
		bra.w	.Next2


.DeleteAll1:	moveq	#FDG_KillAll1,d7
		bra.s	.Kill1

.DeleteAll2:	moveq	#FDG_KillAll2,d7
		bra.s	.Kill2

.Skip:		move.b	#1,ln_pri(A2)	;wenn "ABORT", dann sowieso egal, ob gesetzt
		bra.w	.NextTarget

.Fertig:	moveq	#LENr_Ok,d1
		moveq	#LENr_NoDouble,d0
		tst.w	d6
		beq.s	.Notfound
		moveq	#LENr_NoMoreDouble,d0
		move.b	#1,ListeChanged(a5)
.NotFound:	bsr	TextRequest
.Return:	rts


*-----------------------------------------------------------------------------*
* Input: a1=PL_Node
DeleteFromDisk:	movem.l	d0-a6,-(a7)
		move.l	a1,a4

		tst.w	KillAllOnDisk(a5)
		blt.s	.Return
		bne.s	.KillIt

		lea	TextRequestArgs(a5),a3
		move.l	-PL_Node+PL_Pfad(a1),a0
		move.l	a0,(a3)
		moveq	#LENr_DeleteFrom,d0
		moveq	#LENr_DoubleGadgets2,d1
		bsr	TextRequest
		cmp.l	#0,d0
		beq.s	.Return
		cmp.l	#1,d0
		beq.s	.Return
		cmp.l	#2,d0
		beq.s	.KillIt
		cmp.l	#3,d0
		beq.s	.KillAll
		cmp.l	#4,d0
		bne.s	.Return
		move.w	#-1,KillAllOnDisk(a5)
		bra.s	.Return

		*--- File deprotecten ----*
.KillAll:	move.w	#1,KillAllOnDisk(a5)
.KillIt:	move.l	-PL_Node+PL_Pfad(a4),d1
		move.l	Dosbase(a5),a6
		moveq	#0,d2
		jsr	_LVOSetProtection(a6)

		*--- von Disk lschen ---*
		move.l	-PL_Node+PL_Pfad(a4),d1
		move.l	Dosbase(a5),a6
		jsr	_LVODeleteFile(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
* Input: a0=Args
*	 d0=Nummer
* Output:d0=Error oder NULL
*	 d1=Zustand,Zahl,Stringsize
*	 d2=Ergebnistyp (MPB_Status,ZAHL,...)
*	 a0=Adr des Strings (falls String)
*-----------------------------------------------------------------------------*
FindMEArg:	movem.l	d3-d7/a1-a6,-(a7)
		lea	MPEigenTabelle-MPTS_SizeOF(pc),a3
		bra.s	FindAMPArg

FindMPArg:	movem.l	d3-d7/a1-a6,-(a7)
		lea	MPPrefsTabelle-MPTS_SizeOF(pc),a3
FindAMPArg:	move.l	a3,a4
		move.l	d0,d4
		move.l	a0,d1
		beq.w	.Error

		move.b	(a0),d0
		cmp.b	#'"',d0
		bne.s	.Normalstart
		addq.l	#1,a0
.Normalstart:	move.b	(a0),d0
		cmp.b	#',',d0
		bne.s	.KeinKomma
		addq.l	#1,a0
.KeinKomma:	bsr	ReadZahl
		bne.w	.ErrorDa
		move.l	a1,a0
		cmp.w	d1,d4
		bne.w	.NextArgSuchen
		move.b	(a0)+,d0
		beq.w	.Error
		cmp.b	#"=",d0
		bne.w	.Error

		*-- In Prefstabelle schauen, welcher ArgTyp --*
		move.l	a4,a3
.MPT_NextArg:	lea	MPTS_Sizeof(a3),a3
		move.w	MPTS_EPNr(a3),d0
		beq.s	.Error
		cmp.w	d0,d4
		bne.s	.MPT_NextArg
		moveq	#0,d2
		move.w	MPTS_Flags(a3),d2
		btst	#MPF_Status,d2
		bne.s	.MPT_Status
		btst	#MPF_String,d2
		bne.s	.MPT_String
		btst	#MPF_Zahl,d2
		bne.s	.MPT_Zahl
		btst	#MPF_MultiArgs,d2
		bne.s	.MPT_MultiArgs
		bra.s	.Error

.MPT_MultiArgs:	moveq	#0,d3
		move.l	a0,-(a7)
.MPT_Next:	bsr	BerechArgLen
		beq.s	.Error
		add.l	d1,d3
		lea	(a0,d1.l),a0
		move.b	(a0),d0
		cmp.b	#"=",d0
		bne.s	.MPT_ArgsReturn
		addq.l	#1,d3
		addq.l	#1,a0
		bra.s	.MPT_Next
.MPT_ArgsReturn:move.l	(a7)+,a0
		move.l	d3,d1
		bra.s	.AllesOk

.MPT_String:	bsr	BerechArgLen
		beq.s	.Error
		cmp.b	#"'",(a0)
		bne.s	.AllesOk
		cmp.b	#"'",-1(a0,d1.l)
		bne.s	.Error
		subq.l	#2,d1
		addq.l	#1,a0
		bra.s	.AllesOk

.MPT_Status:
.MPT_Zahl:	bsr	ReadZahl
		bne.s	.Error
		bra.s	.AllesOk


.NextArgSuchen:	bsr	FindNextArg
		beq.s	.Error
		bra.w	.NormalStart

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d3-d7/a1-a6
		tst.l	d0
		rts

.Error:		moveq	#EPR_ErrorInArguments,d0
.ErrorDa:	sub.l	a0,a0
		moveq	#0,d1
		moveq	#0,d2
		bra.s	.Return

*-----------------------------------------------------------------------------*
* Input: a0=Text
* Output:d0=0=Fehler <>0=ok (falls Text zu Ende)
*	 a0=Text
FindNextArg:	move.l	a0,d0
		beq.s	.Error
.Next:		move.b	(a0)+,d0
		beq.s	.Error
		cmp.b	#10,d0
		beq.s	.Error
		cmp.b	#",",d0
		beq.s	.Ok
		cmp.b	#"'",d0
		bne.s	.Next

.FindEndeOfKomma:
		move.b	(a0)+,d0
		beq.s	.Error
		cmp.b	#10,d0
		beq.s	.Error
		cmp.b	#"'",d0
		bne.s	.FindEndeOfKomma
		bra.s	.Next
.Error:		sub.l	a0,a0
		moveq	#0,d0
.Ok:		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Zeiger auf Zeichenkette
* Output:d0=Error oder NULL
*	 d1=Zahl
*	 a1=Zeichen nach der Zahl
*-----------------------------------------------------------------------------*
ReadZahl:	movem.l	d2-d5/a0,-(a7)
		move.l	a0,d0
		beq.s	.DezFehler
		bsr	BerechArgLen
		beq.s	.DezFehler
		moveq	#0,d5
		move.b	(a0),d0
		cmp.b	#"-",d0
		bne.s	.NoNeg
		addq.l	#1,a0
		subq.l	#1,d1
		ble.s	.DezFehler
		moveq	#-1,d5
.NoNeg:		moveq	#10,d4
		sub.l	d1,d4
		add.l	d4,d4
		add.l	d4,d4
		lea	Hexdeztab(pc),a1	;Hilfstabelle-Adresse nach a0
		add.l	d4,a1
		move.l	d1,d3			;10 Stellen
		subq.l	#1,d3
		blt.s	.DezFehler
		moveq	#0,d4			;Vorsichtshalber lschen
		moveq	#0,d1			;Vorsichtshalber lschen
.DezHex2:	moveq	#0,d4
		move.b	(a0)+,d4		;Wert rauslesen
		beq.s	.DezHex7
		cmp.b	#$39,d4
		bgt.s	.DezFehler
		sub.b	#$30,d4			;Ascii-Offset wegaddieren
		bvs.s	.DezFehler

		moveq	#0,d2
		subq.l	#1,d4
		blt.s	.NoAdd
.MuluSimu:	add.l	(a1),d2		;Wert aus der Tabelle laden
	;	mulu	d4,d2			;multiplizieren
		dbf	d4,.MuluSimu


.NoAdd:		add.l	d2,d1			;zu d1 addieren
		addq.l	#4,a1
		dbf	d3,.Dezhex2
.DezHex7:	moveq	#0,d0
		tst.l	d5
		beq.s	.DezEnd
		neg.l	d1
.DezEnd:	move.l	a0,a1
		movem.l	(a7)+,d2-d5/a0
		tst.l	d0
		rts
.DezFehler:	moveq	#EPR_ErrorinArguments,d0
		moveq	#0,d1
		bra.s	.DezEnd


*-----------------------------------------------------------------------------*
* Input: a0=ArgKette
* Output:d1=Len
BerechArgLen:	movem.l	a0/d0,-(a7)
		move.l	a0,d1
		beq.s	.Return
		moveq	#-1,d1
.NextB		addq.l	#1,d1
		move.b	(a0)+,d0
		beq.s	.Return
		cmp.b	#10,d0
		beq.s	.Return
		cmp.b	#"=",d0
		beq.s	.Return
		cmp.b	#'"',d0
		beq.s	.Return
		cmp.b	#",",d0
		beq.s	.Return
		cmp.b	#"'",d0
		bne.s	.NextB

		*--- String erwischt ---*
.NextB2		addq.l	#1,d1
		move.b	(a0)+,d0
		beq.s	.Return
		cmp.b	#10,d0
		beq.s	.return
		cmp.b	#"'",d0
		bne.s	.NextB2
		bra.s	.NextB
		
.Return:	movem.l	(a7)+,a0/d0
		tst.l	d1
		rts


*-----------------------------------------------------------------------------*
* Gibt bei 'Moduleinfo'=6546=EP='878373282';'Analyzer' Start von Moduleinfo
* Size von Moduleinfo sowie Start von 'Ana zurck
* Input:a0=Args
* Output:d0=Size oder NULL
*	 a0=Start of Name
*	 a1=Start of Args fr diesen Eintrag (mit Ganse!!!)
*	 a2=Start of next MultiArgName
GetMultiArgName:movem.l	d1-d7/a3-a6,-(a7)
		move.l	a0,d0
		beq.s	.Error

		move.b	(a0),d7
		cmp.b	#"=",d7
		bne.s	.NoGleich
		addq.l	#1,a0
.NoGleich:	move.b	(a0),d7
		cmp.b	#"'",d7
		bne.s	.Error
		addq.l	#1,a0
		move.l	a0,a4			;Start of Name
		moveq	#-1,d6
.Next:		addq.l	#1,d6
		move.b	(a0)+,d7
		beq.s	.Error
		cmp.b	#10,d7
		beq.s	.Error
		cmp.b	#"'",d7
		bne.s	.Next

		*-- Start of next finden --*
		sub.l	a2,a2
		sub.l	a1,a1
		move.b	(a0),d7
		cmp.b	#"=",d7
		bne.s	.NextB_2
		addq.l	#1,a0
		move.l	a0,a1


.NextB_2:	move.b	(a0)+,d7
		beq.s	.NoNextArg
		cmp.b	#10,d7
		beq.s	.NoNextArg
		cmp.b	#";",d7
		beq.s	.NextArg
		cmp.b	#",",d7
		beq.s	.NextArg
		cmp.b	#"'",d7
		bne.s	.NextB_2

.NextB_3:	move.b	(a0)+,d7
		beq.s	.NoNextArg
		cmp.b	#10,d7
		beq.s	.NoNextArg
		cmp.b	#"'",d7
		bne.s	.NextB_3
		bra.s	.NextB_2

.NoNextArg:	sub.l	a0,a0
.NextArg:	move.l	a0,a2
		move.l	a4,a0
		move.l	d6,d0
.Return:	movem.l	(a7)+,d1-d7/a3-a6
		tst.l	d0
		rts

.Error:		moveq	#0,d0
		sub.l	a0,a0
		sub.l	a1,a1
		sub.l	a2,a2
		bra.s	.Return






*-----------------------------------------------------------------------------*
* in dieser Tabelle sind die Kommandos zusammengefat, die konfiguriert werden
* knnen.
*-----------------------------------------------------------------------------*
MPPrefsTabelle:	dc.w	EPNr_Filter,EPENrP_Filter,MPB_Status,0
		dc.w	EPNr_FadeIn,EPENrP_FadeIn,MPB_Status,0
		dc.w	EPNr_FadeOut,EPENrP_FadeOut,MPB_Status,0
		dc.w	EPNr_Songend,EPENrP_Songend,MPB_Status,0
		dc.w	EPNr_AutoSubSong,EPENrP_AutoSubSong,MPB_Status,0
		dc.w	EPNr_RandomSong,EPENrP_RandomSong,MPB_Status,0
		dc.w	EPNr_LoadBefore,EPENrP_LoadBefore,MPB_Status,0
		dc.w	EPNr_LoadFast,EPENrP_LoadFast,MPB_Status,0
		dc.w	EPNr_ProgramMode,EPENrP_ProgrammMode,MPB_Zahl,0

		dc.w	EPNr_Volume,EPENrP_Volume,MPB_Zahl,0
		dc.w	EPNr_SubSong,EPENrP_StartSong,MPB_Zahl,0
		dc.w	EPNr_PlayTime,EPENrP_Timeout,MPB_Zahl,0
		dc.w	EPNr_MinPlayTime,EPENrP_MinTimeout,MPB_Zahl,0
		dc.w	EPNr_Password,EPENrP_Passwort,MPB_String,0
		dc.w	EPNr_SetAuthor,EPENrP_Autor,MPB_String,0
		dc.w	EPNr_Player,EPENrP_Player,MPB_String,0

		dc.w	EPNr_AscEngine,EPENrPE_Enginelist,MPB_MultiArgs,0
		dc.w	0

MPEigenTabelle:	dc.w	EPMENr_Songname,EPENrP_Songname,MPB_String,0
		dc.w	EPMENr_Specialinfo,EPENrP_Specialinfo,MPB_String,0
		dc.w	EPMENr_Group,EPENrPG_Gruppenlist,MPB_MultiArgs,0
		dc.w	0,0

*-----------------------------------------------------------------------------*
* Input: d0=Size nach ENA_Size
* Output:d0=a0=Adr
AllocArg:	movem.l	d1-d7/a1-a6,-(a7)
		add.l	#ENA_String,d0
		move.l	d0,d7
		EB
		move.l	#$10001,d1
		jsr	_LVOAllocMem(a6)
		move.l	d0,a0
		move.l	d7,ENA_Size(a0)
		move.l	d7,d0
		movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Die Werte mssen alle kopiert werden!
* Arg1=Adr des Listdirs
* Arg2=Adr des Listfiles
* Arg3=Adr der Modulesliste (je nach Gruppe)
* Arg4=Adr der Autorenliste (Autorenprefs)
* Arg5=Adr der Gruppenliste (Gruppenprefs)
Execute:
	*-- Arg 1 --*
		moveq	#0,d0
		sub.l	a4,a4
		bsr	AllocArg
		beq.s	.FreeArgs
		move.l	a0,a3
		move.l	a0,a4
		lea	ListDir(a5),a0
		move.l	a0,ENA_Arg1(a3)

	*-- Arg 2 --*
		moveq	#0,d0
		bsr	AllocArg
		beq.s	.FreeArgs
		move.l	a0,(a3)
		move.l	a0,a3
		lea	Listname(a5),a0
		move.l	a0,ENA_Arg1(a3)

	*-- Arg 3 --*
		moveq	#0,d0
		bsr	AllocArg
		beq.s	.FreeArgs
		move.l	a0,(a3)
		move.l	a0,a3
		lea	Moduleslist(a5),a0
		move.l	a0,ENA_Arg1(a3)

	*-- Arg 4 --*
		moveq	#0,d0
		bsr	AllocArg
		beq.s	.FreeArgs
		move.l	a0,(a3)
		move.l	a0,a3
		lea	Autorlist(a5),a0
		move.l	a0,ENA_Arg1(a3)

	*-- Arg 5 --*
		moveq	#0,d0
		bsr	AllocArg
		beq.s	.FreeArgs
		move.l	a0,(a3)
		move.l	a0,a3
		lea	Gruppenlist(a5),a0
		move.l	a0,ENA_Arg1(a3)


	*-- Message absenden --*
		move.l	a4,d4			-> Args
		moveq	#0,d1
		moveq	#USClass_Command,d2
		moveq	#0,d5
		move.w	#EPNr_InsertPysionList,d3
		bsr	SendeOneMessage

		moveq	#0,d0
		rts


.FreeArgs:	move.l	a4,a0
		bsr	FreeCommandStruct
		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
LoadAuthors:	nop
SaveAuthors:	nop
SetGlobalPrefs:	nop
		moveq	#-1,d0
		rts

ClrPrefs:
		move.b	#1,ListeChanged(a5)
		moveq	#-1,d0
		rts




*-----------------------------------------------------------------------------*

		*------------------ Window ---------------*
WindowTags:	dc.l	WA_MinWidth
Win_MinWidth:	dc.l	0
		dc.l	WA_MinHeight
Win_MinHeight:	dc.l	0
		dc.l	WA_MaxWidth,$8000
		dc.l	WA_MaxHeight,$8000

		dc.l	WA_Left
Win_LeftPos:	dc.l	0
		dc.l	WA_Top
Win_TopPos:	dc.l	0
		dc.l	WA_Width
Win_Width:	dc.l	0
		dc.l	WA_Height
Win_Height:	dc.l	0
		dc.l	WA_IDCMP,IDCMP_VanillaKey!IDCMP_Changewindow!IDCMP_RawKey!IDCMP_Menupick!LISTVIEWIDCMP!IDCMP_NEWSIZE!BUTTONIDCMP!IDCMP_CLOSEWINDOW!IDCMP_REFRESHWINDOW
		dc.l	WA_Flags,Sizebbottom!WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_SMART_REFRESH!WFLG_SIZEGADGET
		dc.l	WA_Title
LL_WindowTitle:	dc.l	0
		dc.l	WA_ScreenTitle
LL_ScreenTitle	dc.l	0
		dc.l	WA_NewLookMenus,1
		dc.l	WA_AutoAdjust,1
		dc.l	WA_Pubscreen
Pubadr:		dc.l	0
		*dc.l	WA_Zoom
		*dc.l	ZoomStruct
		dc.l	TAG_DONE
ZoomStruct:	dc.w	0,0,150,0
Ahawidth:	dc.l	399
Ahaheight:	dc.l	80


	*-------------- Gadgetvereinbarungen ----------------*
GadgetTypes:	dc.w	Listview_Kind
		*-- 1. Zeile --*
		dc.w	Button_Kind			*Add
		dc.w	Button_Kind			*Up
		dc.w	Button_Kind			*Top
		dc.w	Button_Kind			*Prefs
		dc.w	Button_Kind			*Save

		*-- 2. Zeile --*
		dc.w	Button_Kind			*Del
		dc.w	Button_Kind			*Down
		dc.w	Button_Kind			*Botom
		dc.w	Button_Kind			*ClrPrefs
		dc.w	Button_Kind			*Execute

GadgetTags:	dc.l	GTLV_ShowSelected,0		*Modulesliste
		dc.l	Tag_Done

		*-- 1. Zeile --*
		dc.l	GT_Underscore,'_'		*Add
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Up
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Top
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Prefs
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Save
		dc.l	Tag_Done

		*-- 2. Zeile --*
		dc.l	GT_Underscore,'_'		*Del
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Down
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Botom
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*ClrPrefs
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Execute
		dc.l	Tag_Done

Gadgets:

GD_Moduleslist:	dc.w	0,0,0,0			;Left,Top,Width,Height
		dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_ModulesList	;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

		*-- 1. Zeile --*
GD_Add:		dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Add:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Add		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

GD_Up:		dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Up:		dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Up		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

GD_Top:		dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Top:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Top		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

GD_ModulesPrefs:dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_ModulesPrefs:dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_ModulesPrefs		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

GD_SaveList:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_SaveList:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_SaveList		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

		*-- 2. Zeile --*
GD_Delete:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Delete:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Delete		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

GD_Down:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Down:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Down		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

GD_Botom:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Botom:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Botom		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

GD_ClrPrefs:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_ClearPrefs:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_ClearModulesPrefs	;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

GD_Execute:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Execute:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Execute		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata


MyIntuiText:	dc.w	0,0
		dc.w	0,0
		dc.l	0			*Font
		dc.l	0			*Text
		dc.l	0			*Next

	*------------------------- Menus -----------------------*
Menus:		dc.b	NM_Title,0
LLM_Project:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_NewList:	dc.l	0
LLM_NewListKey:	dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_LoadList:	dc.l	0
LLM_LoadListKey:dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_InsertList:	dc.l	0
LLM_InsertListKey:dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_SaveList:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_About:	dc.l	0
LLM_AboutKey:	dc.l	AboutKey
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Hide:	dc.l	0
LLM_HideKey:	dc.l	HideKey
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Quit:	dc.l	0
		dc.l	QuitKey
		dc.w	0
		dc.l	0,0


		*---- Aktion Menu ----*
		dc.b	NM_Title,0
LLM_Kommando:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Gruppenliste:dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Autorliste:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_Item,0
LLM_FindDouble:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_Item,0
LLM_Sortieren:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_Sub,0
LLM_SortByName:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_Sub,0
LLM_SortByFName:dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_Sub,0
LLM_SortByPath:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		*--- Settings-Menu ---*
		dc.b	NM_Title,0
LLM_Settings:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_Item,0
LLM_Show:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_Sub,0
LLM_ShowbyName:	dc.l	0
		dc.l	0
ShowByNameFlags:dc.w	CHECKIT
		dc.l	~1,0

		dc.b	NM_Sub,0
LLM_ShowbyFName:dc.l	0
		dc.l	0
ShowByFNameFlags:dc.w	CHECKIT
		dc.l	~2,0

		dc.b	NM_Sub,0
LLM_ShowbyPath:	dc.l	0
		dc.l	0
ShowByPathFlags:dc.w	CHECKIT
		dc.l	~4,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_AutoLearnAuthors:	dc.l	0
		dc.l	0
AutoLearnAuthorsFlags: dc.w	CHECKIT!Menutoggle
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Synchron:	dc.l	0
		dc.l	0
SynchronFlags:	dc.w	CHECKIT!Menutoggle
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Overwrite:	dc.l	0
		dc.l	0
OverwriteFlags:	dc.w	CHECKIT!Menutoggle
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_HideAll:	dc.l	0
		dc.l	0
HideAllFlags:	dc.w	CHECKIT!Menutoggle
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_LoadAtStart:dc.l	0
		dc.l	0
LoadAtStartFlags:dc.w	CHECKIT!Menutoggle
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Backpic:	dc.l	0
		dc.l	0
BackPicFlags:	dc.w	CHECKIT!Menutoggle
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_ChooseBackpic:dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_SavePysionConfig:dc.l	0
LLM_SavePysionConfigKey:dc.l 0			SaveConfigKey
		dc.w	0
		dc.l	0,0


		dc.b	NM_END,0
		dc.l	0,0
		dc.w	0
		dc.l	0,0


MenuTags:	dc.l	GTMN_Newlookmenus,1
		dc.l	TAG_DONE


	*-------------- Gadgetvereinbarungen ----------------*
	*------- fr das Autorenwindow/Gruppenwindow --------*
AG_GadgetTypes:	dc.w	Listview_Kind
		dc.w	Button_Kind			*Add
		dc.w	Button_Kind			*Delete
		dc.w	Button_Kind			*New
		dc.w	Button_Kind			*Prefs
		dc.w	Button_Kind			*Clr Prefs

Autor_Gadgets:	dc.w	0,0,0,0			;Left,Top,Width,Height
		dc.l	0,0			;GadgetText,Font
		dc.w	EPENrA_Autorlist	;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

		dc.w	0,0,0,0			;Left,Top,Width,Height
LLGA_Add:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrA_Add		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

		dc.w	0,0,0,0			;Left,Top,Width,Height
LLGA_Delete:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrA_Delete		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

		dc.w	0,0,0,0			;Left,Top,Width,Height
LLGA_New:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrA_New		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

		dc.w	0,0,0,0			;Left,Top,Width,Height
LLGA_Prefs:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrA_Prefs		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

		dc.w	0,0,0,0			;Left,Top,Width,Height
LLGA_ClrPrefs:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrA_ClrPrefs		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

Gruppen_Gadgets:dc.w	0,0,0,0			;Left,Top,Width,Height
		dc.l	0,0			;GadgetText,Font
		dc.w	EPENrG_Gruppenlist	;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

		dc.w	0,0,0,0			;Left,Top,Width,Height
LLGG_Add:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrG_Add		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

		dc.w	0,0,0,0			;Left,Top,Width,Height
LLGG_Delete:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrG_Delete		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

		dc.w	0,0,0,0			;Left,Top,Width,Height
LLGG_New:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrG_New		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

		dc.w	0,0,0,0			;Left,Top,Width,Height
LLGG_Prefs:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrG_Prefs		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

		dc.w	0,0,0,0			;Left,Top,Width,Height
LLGG_ClrPrefs:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrG_ClrPrefs		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

AG_GadgetTags:	dc.l	GTLV_ShowSelected,0	*Liste der Autoren/Gruppen
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'	*Add
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'	*Delete
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'	*New
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'	*Prefs
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'	*Clr Prefs
		dc.l	Tag_Done


		*---- Engineliste ---*
Prefs_Gadgets:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLPE_Enginelist:dc.l	0,0			;GadgetText,Font
		dc.w	EPENrPE_Enginelist	;GadgetNr
		dc.l	Placetext_Above,0,0	;Flags,VisualInfo,Userdata

.AddEngine:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLPE_Add:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrPE_Add		;GadgetNr
		dc.l	Placetext_In,0,0	;Flags,VisualInfo,Userdata

.DelEngine:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLPE_Delete:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrPE_Delete		;GadgetNr
		dc.l	Placetext_In,0,0	;Flags,VisualInfo,Userdata

.ClearEngines:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLPE_Clear:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrPE_Clear		;GadgetNr
		dc.l	Placetext_In,0,0	;Flags,VisualInfo,Userdata

		*---- Gruppenliste ---*
.Gruppenlist:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLPG_Gruppenlist:dc.l	0,0			;GadgetText,Font
		dc.w	EPENrPG_Gruppenlist	;GadgetNr
		dc.l	Placetext_above,0,0	;Flags,VisualInfo,Userdata

.AddGroup:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLPG_Add:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrPG_Add		;GadgetNr
		dc.l	Placetext_In,0,0	;Flags,VisualInfo,Userdata

.DelGroup:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLPG_Delete:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrPG_Delete		;GadgetNr
		dc.l	Placetext_In,0,0	;Flags,VisualInfo,Userdata

.ClearGruppen:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLPG_Clear:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrPG_Clear		;GadgetNr
		dc.l	Placetext_In,0,0	;Flags,VisualInfo,Userdata

		*--- Linke Windowseite ---*
.Filter:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Filter:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Filter		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.Fadein:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Fadein:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_FadeIn		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.FadeOut:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Fadeout:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Fadeout		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.Songend:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Songend:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Songend		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.AutoSubSong:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_AutoSubsong:dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_AutoSubSong	;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.Randomsong:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Randomsong:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Randomsong	;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.LoadBefore:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_LoadBefore:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_LoadBefore	;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.LoadFast:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_LoadFast:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_LoadFast		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.ProgrammMode:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_ProgrammMode:dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_ProgrammMode	;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

		*--- rechte Windowseite ---*
.Volume:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Volume:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Volume		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.StartSong:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_StartSong:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_StartSong	;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.Timeout:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Timeout:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Timeout		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.MinTimeout:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_MinTimeout:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_MinTimeout	;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.Passwort:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Passwort:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Passwort		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.Songname:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Songname:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Songname		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.Specialinfo:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Specialinfo:dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Specialinfo	;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.Autor		dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Autor:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Autor		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.SelectAutor:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_SelectAutor:dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_SelectAutor	;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

.Player		dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_Player:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_Player		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

.SelectPlayer:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLP_SelectPlayer:dc.l	0,0			;GadgetText,Font
		dc.w	EPENrP_SelectPlayer	;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata


	*-------------- Gadgetvereinbarungen ----------------*
	*------- fr das Autorenwindow/Gruppenwindow --------*
P_GadgetTypes:	dc.w	Listview_Kind			*Enginelist
.1		dc.w	Button_Kind			*Add
.2		dc.w	Button_Kind			*Delete
.3		dc.w	Button_Kind			*Clear

.4		dc.w	Listview_Kind			*Gruppenlist
.5		dc.w	Button_Kind			*Add
.6		dc.w	Button_Kind			*Delete
.7		dc.w	Button_Kind			*Clear

		*-- linke Seite des Listviews --*
.8		dc.w	Cycle_Kind			*Filter
.9		dc.w	Cycle_Kind			*Fadein
.10		dc.w	Cycle_Kind			*Fadeout
.11		dc.w	Cycle_Kind			*Songend
.12		dc.w	Cycle_Kind			*AutoSubSong
.13		dc.w	Cycle_Kind			*RandomSong
.14		dc.w	Cycle_Kind			*LoadBefore
.15		dc.w	Cycle_Kind			*LoadFast
.16		dc.w	Cycle_Kind			*ProgrammMode

		*-- rechte Seite des Listviews --*
.17		dc.w	Integer_Kind			*Volume
.18		dc.w	Integer_Kind			*Startsong
.19		dc.w	Integer_Kind			*Timeout
.20		dc.w	Integer_Kind			*MinTimeout
.21		dc.w	String_Kind			*Passwort
.22		dc.w	String_Kind			*Songname
.23		dc.w	String_Kind			*Specialinfo
.24		dc.w	String_Kind			*Autor
.25		dc.w	Button_Kind			*Autorwindow
.26		dc.w	String_Kind			*Player
.27		dc.w	Button_Kind			*Select Player


		*--- Engineslistview ---*
P_GadgetTags:	dc.l	GTLV_ShowSelected,0		*Liste der Engines
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Add
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Delete
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Clear
		dc.l	Tag_Done

		*--- Gruppenlistview ---*
		dc.l	GTLV_ShowSelected,0		*Liste der Gruppen
TD_G_Listview:	dc.l	Tag_Ignore,1
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Add
TD_G_Add:	dc.l	Tag_Ignore,1
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Delete
TD_G_Delete:	dc.l	Tag_Ignore,1
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Clear
TD_G_Clear:	dc.l	Tag_Ignore,1
		dc.l	Tag_Done

		*--- Linke Seite des Windows ---*
		dc.l	-1,EPNr_Filter			*Filter
		dc.l	GTCY_Active,0		
		dc.l	GTCY_Labels,YesNoNotLabels
		dc.l	GT_Underscore,'_'
		dc.l	Tag_Done

		dc.l	-1,EPNr_FadeIn			*FadeIn
		dc.l	GTCY_Active,0
		dc.l	GTCY_Labels,YesNoNotLabels
		dc.l	GT_Underscore,'_'
		dc.l	Tag_Done

		dc.l	-1,EPNr_FadeOut			*Fadeout
		dc.l	GTCY_Active,0
		dc.l	GTCY_Labels,YesNoNotLabels
		dc.l	GT_Underscore,'_'
		dc.l	Tag_Done

		dc.l	-1,EPNr_Songend			*Songend
		dc.l	GTCY_Active,0
		dc.l	GTCY_Labels,YesNoNotLabels
		dc.l	GT_Underscore,'_'
		dc.l	Tag_Done

		dc.l	-1,EPNr_AutoSubSong		*AutoSubSong
		dc.l	GTCY_Active,0
		dc.l	GTCY_Labels,YesNoNotLabels
		dc.l	GT_Underscore,'_'
		dc.l	Tag_Done

		dc.l	-1,EPNr_RandomSong		*RandomSong
		dc.l	GTCY_Active,0
		dc.l	GTCY_Labels,YesNoNotLabels
		dc.l	GT_Underscore,'_'
		dc.l	Tag_Done

		dc.l	-1,EPNr_LoadBefore		*LoadBefore
		dc.l	GTCY_Active,0
		dc.l	GTCY_Labels,YesNoNotLabels
		dc.l	GT_Underscore,'_'
		dc.l	Tag_Done

		dc.l	-1,EPNr_LoadFast		*LoadFast
		dc.l	GTCY_Active,0
		dc.l	GTCY_Labels,YesNoNotLabels
		dc.l	GT_Underscore,'_'
		dc.l	Tag_Done

		dc.l	-1,EPNr_ProgramMode		*ProgrammMode
PM_Tags:	dc.l	GTCY_Active,0
		dc.l	GTCY_Labels,ProgrammModeLabels
		dc.l	GT_Underscore,'_'
		dc.l	Tag_Done


		*--- Rechte Seite des Windows ---*
		dc.l	-1,EPNr_Volume			*Volume
		dc.l	GTIN_Number,0
		dc.l	GTIN_MaxChars,4
		dc.l	GT_Underscore,'_'
		dc.l	0

		dc.l	-1,EPNr_SubSong			*Startsong
		dc.l	GTIN_Number,0
		dc.l	GTIN_MaxChars,4
		dc.l	GT_Underscore,'_'
		dc.l	0

		dc.l	-1,EPNr_Playtime		*Timeout
		dc.l	GTIN_Number,0
		dc.l	GT_Underscore,'_'
		dc.l	0

		dc.l	-1,EPNr_MinPlayTime		*Min. Timeout
		dc.l	GTIN_Number,0
		dc.l	GT_Underscore,'_'
		dc.l	0

		dc.l	-1,EPNr_Password		*Passwort
		dc.l	GTST_String,0			*Def. Passwort
		dc.l	GT_Underscore,'_'		
		dc.l	GTST_MaxChars,32
		dc.l	0

		dc.l	-2,EPMENr_Songname		*Songname
		dc.l	GTST_String,0
		dc.l	GT_Underscore,'_'		
		dc.l	GTST_MaxChars,32
		dc.l	0

		dc.l	-2,EPMENr_Specialinfo		*Specialinfo
		dc.l	GTST_String,0			*Def. Specialinfo
		dc.l	GT_Underscore,'_'		
		dc.l	GTST_MaxChars,255
		dc.l	0

		dc.l	-1,EPNr_SetAuthor		*Autor
		dc.l	GTST_String,0			*Def. Autor
TD_Autor:	dc.l	Tag_Ignore,1
		dc.l	GT_Underscore,'_'
		dc.l	GTST_MaxChars,32
		dc.l	0

TD_SelectAutor:	dc.l	Tag_Ignore,1
		dc.l	0				*Select Autor

		dc.l	-1,EPNr_Player			*Player
		dc.l	GTST_String,0			*Def. Player
		dc.l	GT_Underscore,'_'
		dc.l	GTST_MaxChars,32
		dc.l	0

		dc.l	0				*Select Player


YesNoNotLabels:						*fr Yes/no/Notchanged
LLL_NotChanged:	dc.l	0				*Cyclegadgets
LLL_No:		dc.l	0
LLL_Yes:	dc.l	0
		dc.l	0

ProgrammModeLabels:					*fr LoadNext/Prev
LLLM_NotChanged:dc.l	0				*(ProgrammMode)
LLLM_NoNewModule:dc.l	0
LLLM_NextModule:dc.l	0
LLLM_PrevModule:dc.l	0
LLLM_Randommodule:dc.l	0
		dc.l	0




*EPENrPE_Enginelist
*EPENrPE_Add
*EPENrPE_Delete
*EPENrPE_Clear
*
*EPENrPG_Gruppenlist
*EPENrPG_Add
*EPENrPG_Delete
*EPENrPG_Clear
*
*EPENrP_Filter
*EPENrP_FadeIn
*EPENrP_FadeOut
*EPENrP_Songend
*EPENrP_AutoSubSong
*EPENrP_RandomSong
*EPENrP_LoadBefore
*EPENrP_LoadFast
*EPENrP_ProgrammMode
*
*EPENrP_Volume
*EPENrP_StartSong
*EPENrP_Timeout
*EPENrP_MinTimeout
*EPENrP_Passwort
*EPENrP_Songname
*EPENrP_Specialinfo
*EPENrP_Autor
*EPENrP_SelectAutor
*EPENrP_Player
*EPENrP_SelectPlayer
*
*LLPE_Enginelist
*LLPE_Add				;ohne Key !!!
*LLPE_Delete				;ohne Key !!!
*LLPE_Clear				;ohne Key !!!
*
*LLPG_Gruppenlist
*LLPG_Add				;ohne Key !!!
*LLPG_Delete				;ohne Key !!!
*LLPG_Clear				;ohne Key !!!
*
*LLP_Filter
*LLP_FadeIn
*LLP_FadeOut
*LLP_Songend
*LLP_AutoSubSong
*LLP_RandomSong
*LLP_LoadBefore
*LLP_LoadFast
*LLP_ProgrammMode
*
*LLP_Volume
*LLP_StartSong
*LLP_Timeout
*LLP_MinTimeout
*LLP_Passwort
*LLP_Songname
*LLP_Specialinfo
*LLP_Autor
*LLP_Player
*
*LLL_NotChanged
*LLL_Yes
*LLL_No
*
*LLLM_NotChanged
*LLLM_NoNewModule
*LLLM_Yes
*LLLM_No
*


VanillaKeyTabelle:
		dc.b	LENr_NewKey,0,EPENr_New
		dc.b	LENr_AddKey,0,EPENr_Add
		dc.b	LENr_DeleteKey,0,EPENr_Delete

		dc.b	LENr_TopKey,0,EPENr_Top
		dc.b	LENr_BotomKey,0,EPENr_Botom
		dc.b	LENr_UpKey,0,EPENr_Up
		dc.b	LENr_DownKey,0,EPENr_Down

		dc.b	LENr_LoadListKey,0,EPENr_LoadList
		dc.b	LENr_InsertListKey,0,EPENr_InsertList
		dc.b	LENr_SaveListKey,0,EPENr_SaveList
		dc.b	LENr_SaveConfigKey,0,EPENr_SaveConfig
		dc.b	LENr_PlayModuleKey,0,EPENr_PlayModule
		dc.b	LENr_ModulesPrefsKey,0,EPENr_ModulesPrefs
		dc.b	LENr_ClearPrefsKey,0,EPENr_ClearModulesPrefs
		dc.b	LENr_ExecuteKey,0,EPENr_Execute
		dc.b	1,"Q",EPENr_Quit
		dc.b	1,"H",EPENr_Hide
		*dc.b	1,"A",EPENr_About
		dc.b	1,13,EPENr_PlayModule
		dc.b	1,"5",EPENr_PlayModule
		dc.b	1,"8",EPENr_ViewUp
		dc.b	1,"2",EPENr_ViewDown
		dc.b	1,"7",EPENr_ViewTop
		dc.b	1,"1",EPENr_ViewBotom
		dc.b	1,"9",EPENr_ViewPageUp
		dc.b	1,"3",EPENr_ViewPageDown
		dc.b	0

A_VanillaKeyTabelle:
		dc.b	LENr_NewKey,0,EPENrA_New
		dc.b	LENr_AddKey,0,EPENrA_Add
		dc.b	LENr_DeleteKey,0,EPENrA_Delete
		dc.b	LENr_ModulesPrefsKey,0,EPENrA_Prefs
		dc.b	LENr_ClearPrefsKey,0,EPENrA_ClrPrefs
		*dc.b	1,13,EPENr_PlayModule
		dc.b	1,"8",EPENrA_ViewUp
		dc.b	1,"2",EPENrA_ViewDown
		dc.b	1,"7",EPENrA_ViewTop
		dc.b	1,"1",EPENrA_ViewBotom
		dc.b	1,"9",EPENrA_ViewPageUp
		dc.b	1,"3",EPENrA_ViewPageDown
		dc.b	0

G_VanillaKeyTabelle:
		dc.b	LENr_NewKey,0,EPENrG_New
		dc.b	LENr_AddKey,0,EPENrG_Add
		dc.b	LENr_DeleteKey,0,EPENrG_Delete
		dc.b	LENr_ModulesPrefsKey,0,EPENrG_Prefs
		dc.b	LENr_ClearPrefsKey,0,EPENrG_ClrPrefs
		*dc.b	1,13,EPENr_PlayModule
		dc.b	1,"8",EPENrG_ViewUp
		dc.b	1,"2",EPENrG_ViewDown
		dc.b	1,"7",EPENrG_ViewTop
		dc.b	1,"1",EPENrG_ViewBotom
		dc.b	1,"9",EPENrG_ViewPageUp
		dc.b	1,"3",EPENrG_ViewPageDown
		dc.b	0

P_VanillaKeyTabelle:
		dc.b	0
		even

MenuTabelle:	dc.w	MNr_New,EPENr_New
		dc.w	MNr_LoadList,EPENr_LoadList
		dc.w	MNr_InsertList,EPENr_InsertList
		dc.w	MNr_SaveList,EPENr_SaveList
		dc.w	MNr_About,EPENr_About
		dc.w	MNr_Hide,EPENr_Hide
		dc.w	MNr_Quit,EPENr_Quit
		dc.w	MNr_Gruppenliste,EPENr_Gruppenliste
		dc.w	MNr_Autorliste,EPENr_Autorliste
		dc.w	MNr_SortByName,EPENr_SortByName
		dc.w	MNr_SortByFName,EPENr_SortByFName
		dc.w	MNr_SortByPath,EPENr_SortByPath
		dc.w	MNr_Synchron,EPENr_Synchron
		dc.w	MNr_HideAll,EPENr_HideAll
		dc.w	MNr_LoadAtStart,EPENr_LoadAtStart
		dc.w	MNr_BackPic,EPENr_BackPic
		dc.w	MNr_SelectBackPic,EPENr_SelectBackPic
		dc.w	MNr_SaveConfig,EPENr_SaveConfig
		dc.w	MNr_ShowbyName,EPENr_ShowbyName
		dc.w	MNr_ShowbyFName,EPENr_ShowbyFName
		dc.w	MNr_ShowbyPath,EPENr_ShowByPath
		dc.w	MNr_AutoLearnAuthors,EPENr_AutoLearnAuthors
		dc.w	MNr_FindDouble,EPENr_FindDouble
		dc.w	MNr_Overwrite,EPENr_Overwrite
		dc.w	0

	* 3=Control 2=Shift 1=normal *
RawKeyTabelle:	dc.b	3,$4c,EPENr_ViewTop		;ViewTop
		dc.b	3,$4d,EPENr_ViewBotom		;ViewBotom
		dc.b	2,$4c,EPENr_ViewPageUp		;PageUp
		dc.b	2,$4d,EPENr_ViewPageDown	;PageDown
		dc.b	1,$4c,EPENr_ViewUp		;Up
		dc.b	1,$4d,EPENr_ViewDown		;Down
		dc.b	1,$45,-2			;ESC
		dc.b	1,$5f,-1			;HelpModus
		dc.b	0

	* 3=Control 2=Shift 1=normal *
A_RawKeyTabelle:dc.b	3,$4c,EPENrA_ViewTop		;ViewTop
		dc.b	3,$4d,EPENrA_ViewBotom		;ViewBotom
		dc.b	2,$4c,EPENrA_ViewPageUp		;PageUp
		dc.b	2,$4d,EPENrA_ViewPageDown	;PageDown
		dc.b	1,$4c,EPENrA_ViewUp		;Up
		dc.b	1,$4d,EPENrA_ViewDown		;Down
		dc.b	1,$45,EPENrA_Close		;ESC
		dc.b	1,$5f,-1			;HelpModus
		dc.b	0

	* 3=Control 2=Shift 1=normal *
G_RawKeyTabelle:dc.b	3,$4c,EPENrG_ViewTop		;ViewTop
		dc.b	3,$4d,EPENrG_ViewBotom		;ViewBotom
		dc.b	2,$4c,EPENrG_ViewPageUp		;PageUp
		dc.b	2,$4d,EPENrG_ViewPageDown	;PageDown
		dc.b	1,$4c,EPENrG_ViewUp		;Up
		dc.b	1,$4d,EPENrG_ViewDown		;Down
		dc.b	1,$45,EPENrG_Close		;ESC
		dc.b	1,$5f,-1			;HelpModus
		dc.b	0

	* 3=Control 2=Shift 1=normal *
P_RawKeyTabelle:dc.b	1,$5f,-1			;HelpModus
		dc.b	1,$45,EPENrG_Close		;ESC
		dc.b	0
		even

*----------------------------------------------------------------------------*
LocaleTabelle:
		dc.w	LENr_Add,LLG_Add-LocaleTabelle
		dc.w	LENr_Up,LLG_Up-LocaleTabelle
		dc.w	LENr_Top,LLG_Top-LocaleTabelle
		dc.w	LENr_ModulesPrefs,LLG_ModulesPrefs-LocaleTabelle
		dc.w	LENr_GDSaveList,LLG_SaveList-LocaleTabelle

		dc.w	LENr_Delete,LLG_Delete-LocaleTabelle
		dc.w	LENr_Down,LLG_Down-LocaleTabelle
		dc.w	LENr_Botom,LLG_Botom-LocaleTabelle
		dc.w	LENr_ClearPrefs,LLG_ClearPrefs-LocaleTabelle
		dc.w	LENr_Execute,LLG_Execute-LocaleTabelle

		dc.w	LENr_New,LLM_NewList-LocaleTabelle
		dc.w	LENr_NewKey,LLM_NewListKey-LocaleTabelle
		dc.w	LENr_Project,LLM_Project-LocaleTabelle
		dc.w	LENr_Settings,LLM_Settings-LocaleTabelle
		dc.w	LENr_About,LLM_About-LocaleTabelle
		dc.w	LENr_Hide,LLM_Hide-LocaleTabelle
		dc.w	LENr_Quit,LLM_Quit-LocaleTabelle
		dc.w	LENr_WindowTitle,LL_WindowTitle-LocaleTabelle
		dc.w	LENr_ScreenTitle,LL_ScreenTitle-LocaleTabelle

		dc.w	LENr_Synchron,LLM_Synchron-LocaleTabelle
		dc.w	LENr_LoadAtStart,LLM_LoadAtStart-LocaleTabelle
		dc.w	LENr_HideAll,LLM_HideAll-LocaleTabelle
		dc.w	LENr_BackPic,LLM_BackPic-LocaleTabelle
		dc.w	LENr_SelectBackPic,LLM_ChooseBackPic-LocaleTabelle
		dc.w	LENr_SaveConfig,LLM_SavePysionConfig-LocaleTabelle
		dc.w	LENr_SaveConfigKey,LLM_SavePysionConfigKey-LocaleTabelle

		dc.w	LENr_LoadList,LLM_LoadList-LocaleTabelle
		dc.w	LENr_LoadListKey,LLM_LoadListKey-LocaleTabelle
		dc.w	LENr_InsertList,LLM_InsertList-LocaleTabelle
		dc.w	LENr_InsertListKey,LLM_InsertListKey-LocaleTabelle
		dc.w	LENr_SaveList,LLM_SaveList-LocaleTabelle

		dc.w	LENr_Kommando,LLM_Kommando-LocaleTabelle
		dc.w	LENr_Gruppenliste,LLM_Gruppenliste-LocaleTabelle
		dc.w	LENr_Autorliste,LLM_Autorliste-LocaleTabelle
		dc.w	LENr_Sortieren,LLM_Sortieren-LocaleTabelle
		dc.w	LENr_SortbyName,LLM_SortByName-LocaleTabelle
		dc.w	LENr_SortbyFName,LLM_SortByFName-LocaleTabelle
		dc.w	LENr_SortbyPfad,LLM_SortByPath-LocaleTabelle
		dc.w	LENr_FindDouble,LLM_FindDouble-LocaleTabelle

		dc.w	LENr_Show,LLM_Show-LocaleTabelle
		dc.w	LENr_ShowByName,LLM_ShowbyName-LocaleTabelle
		dc.w	LENr_ShowByFName,LLM_ShowbyFName-LocaleTabelle
		dc.w	LENr_ShowbyPath,LLM_Showbypath-LocaleTabelle
		dc.w	LENr_AutoLearnAuthors,LLM_AutoLearnAuthors-LocaleTabelle
		dc.w	LENr_Overwrite,LLM_Overwrite-LocaleTabelle

		*--- Autorwindow ---*
		dc.w	LENr_Add,LLGG_Add-Localetabelle
		dc.w	LENr_Delete,LLGG_Delete-Localetabelle
		dc.w	LENr_New,LLGG_New-Localetabelle
		dc.w	LENr_ModulesPrefs,LLGG_Prefs-Localetabelle
		dc.w	LENr_ClearPrefs,LLGG_ClrPrefs-Localetabelle

		*--- Gruppenwindow ---*
		dc.w	LENr_Add,LLGA_Add-Localetabelle
		dc.w	LENr_Delete,LLGA_Delete-Localetabelle
		dc.w	LENr_New,LLGA_New-Localetabelle
		dc.w	LENr_ModulesPrefs,LLGA_Prefs-Localetabelle
		dc.w	LENr_ClearPrefs,LLGA_ClrPrefs-Localetabelle

		dc.w	LENr_P_Enginelist,LLPE_Enginelist-LocaleTabelle
		dc.w	LENr_P_Add,LLPE_Add-LocaleTabelle
		dc.w	LENr_P_Delete,LLPE_Delete-LocaleTabelle
		dc.w	LENr_P_Clear,LLPE_Clear-LocaleTabelle

		dc.w	LENr_P_Gruppenlist,LLPG_Gruppenlist-LocaleTabelle
		dc.w	LENr_P_Add,LLPG_Add-LocaleTabelle
		dc.w	LENr_P_Delete,LLPG_Delete-LocaleTabelle
		dc.w	LENr_P_Clear,LLPG_Clear-LocaleTabelle

		dc.w	LENr_P_Filter,LLP_Filter-LocaleTabelle
		dc.w	LENr_P_FadeIn,LLP_FadeIn-LocaleTabelle
		dc.w	LENr_P_FadeOut,LLP_FadeOut-LocaleTabelle
		dc.w	LENr_P_Songend,LLP_Songend-LocaleTabelle
		dc.w	LENr_P_AutoSubSong,LLP_AutoSubSong-LocaleTabelle
		dc.w	LENr_P_RandomSong,LLP_RandomSong-LocaleTabelle
		dc.w	LENr_P_LoadBefore,LLP_LoadBefore-LocaleTabelle
		dc.w	LENr_P_LoadFast,LLP_LoadFast-LocaleTabelle
		dc.w	LENr_P_ProgrammMode,LLP_ProgrammMode-LocaleTabelle

		dc.w	LENr_P_Volume,LLP_Volume-LocaleTabelle
		dc.w	LENr_P_StartSong,LLP_StartSong-LocaleTabelle
		dc.w	LENr_P_Timeout,LLP_Timeout-LocaleTabelle
		dc.w	LENr_P_MinTimeout,LLP_MinTimeout-LocaleTabelle
		dc.w	LENr_P_Passwort,LLP_Passwort-LocaleTabelle
		dc.w	LENr_P_Songname,LLP_Songname-LocaleTabelle
		dc.w	LENr_P_Specialinfo,LLP_Specialinfo-LocaleTabelle
		dc.w	LENr_P_Autor,LLP_Autor-LocaleTabelle
		dc.w	LENr_P_Player,LLP_Player-LocaleTabelle

		dc.w	LENr_L_NotChanged,LLL_NotChanged-LocaleTabelle
		dc.w	LENr_L_Yes,LLL_Yes-LocaleTabelle
		dc.w	LENr_L_No,LLL_No-LocaleTabelle

		dc.w	LENr_L_NotChanged,LLLM_NotChanged-LocaleTabelle
		dc.w	LENr_LM_NoNewModule,LLLM_NoNewModule-LocaleTabelle
		dc.w	LENr_LM_NextModule,LLLM_NextModule-LocaleTabelle
		dc.w	LENr_LM_PrevModule,LLLM_PrevModule-LocaleTabelle
		dc.w	LENr_LM_RandomModule,LLLM_RandomModule-LocaleTabelle


		dc.w	LENr_GetFile,LLP_SelectAutor-LocaleTabelle
		dc.w	LENr_GetFile,LLP_SelectPlayer-LocaleTabelle




		dc.w	0




*----------------------------------------------------------------------------*
InternalStrings:
MyProzessName		dc.b	"EP_Pysion.1",0
MyCreatorname:		dc.b	"Eagleeye of DEFECT",0
MySpecialInfo:		dc.b	"Administering & configurating from modules",0
EPUserPortName:		dc.b	"EAGLEPLAYERPORT",0
MyMsgPortName:		dc.b	"EP_Pysion.Port",0
Catalogname:		dc.b	"EP_Pysion.catalog",0
DefaultDir:		dc.b	"Lists/",0
DefaultFile:		dc.b	"Eagleplayerprogram.pysion",0
SafeSavename:		dc.b	"Pysion_Safesavefile",0
NullZeichen:		EQU	*-1


PysionHeader:		dc.b	"EP-LIST",10
PysionHeaderSize	= *-PysionHeader
EnterZeichen:		dc.b	10
Kenn_ModulesPrefs:	dc.b	' MP:"'
GanseZeichen:		dc.b	'"'		\ nicht ndern
SpaceZeichen:		dc.b	" "		/
Kenn_ModulesEigen:	dc.b	'ME:"'		/
GleichZeichen:		dc.b	"=",0
HochKommazeichen:	dc.b	"'",0
Kommazeichen:		dc.b	",",0
Semikolonzeichen:	dc.b	";",0


GlobalKennung:		dc.b	10,"@GLOBAL",10,0
GruppenKennung:		dc.b	10,"@GROUPS",10,0
AutorKennung:		dc.b	10,"@AUTHORS",10,0
EndKennung:		dc.b	"@END",10,0

Unknown			dc.b	"Unknown",0

		if	Betarelease
Helpnode_Pysion:	dc.b	"Pysion",0
		endc
Helpnode_Add:		dc.b	"Pysion_Add",0
Helpnode_Delete:	dc.b	"Pysion_Delete",0
Helpnode_New:		dc.b	"Pysion_New",0
Helpnode_Config:	dc.b	"Pysion_Config",0
Helpnode_SaveConfig:	dc.b	"Save Config",0
Helpnode_Hide:		dc.b	"Hide",0
HelpNode_LoadList:	dc.b	"Pysion_LoadList",0
HelpNode_InsertList:	dc.b	"Pysion_InsertList",0
HelpNode_SaveList:	dc.b	"Pysion_SaveList",0
HelpNode_Execute:	dc.b	"Pysion_Execute",0
HelpNode_SortByPath:	dc.b	"Pysion_SortByPath",0
HelpNode_SortByFName:	dc.b	"Pysion_SortByFName",0
HelpNode_SortByName:	dc.b	"Pysion_SortByName",0
HelpNode_Top:		dc.b	"Pysion_Top",0
HelpNode_Botom:		dc.b	"Pysion_Botom",0
HelpNode_Up:		dc.b	"Pysion_Up",0
HelpNode_Down:		dc.b	"Pysion_Down",0
HelpNode_LoadAtStart:	dc.b	"Pysion_LoadAtStart",0
HelpNode_HideAll:	dc.b	"Pysion_HideAll",0
HelpNode_Synchron:	dc.b	"Pysion_Synchron",0
HelpNode_CutAffix:	dc.b	"Pysion_CutAffix",0
HelpNode_BackPic:	dc.b	"BackPic",0
HelpNode_SelectPackPic:	dc.b	"SelectBackPic",0
HelpNode_ModulesPrefs:	dc.b	"Pysion_ModulesPrefs",0
HelpNode_ClrPrefs:	dc.b	"Pysion_ClrPrefs",0
HelpNode_PlayModule:	dc.b	"Pysion_PlayModule",0
HelpNode_Gruppenliste:	dc.b	"Pysion_Grouplist",0
HelpNode_Autorliste:	dc.b	"Pysion_Authorlist",0
HelpNode_ShowByPath:	dc.b	"Pysion_ShowByPath",0
HelpNode_ShowByName:	dc.b	"Pysion_ShowByName",0
HelpNode_AutoLearnAuthors:dc.b	"Pysion_AutoLearnAuthors",0
HelpNode_FindDouble:	dc.b	"Pysion_FindDouble",0
HelpNode_Overwrite:	dc.b	"Pysion_Overwrite",0
HelpNode_A_Listview:	dc.b	"Pysion_Autorlistview",0
HelpNode_G_Listview:	dc.b	"Pysion_Gruppenlistview",0

Helpnode_PE_Enginelist	dc.b	"Pysion_PE_Enginelist",0
Helpnode_PE_Add		dc.b	"Pysion_PE_Add",0
Helpnode_PE_Delete	dc.b	"Pysion_PE_Delete",0
Helpnode_PE_Clear	dc.b	"Pysion_PE_Clear",0

Helpnode_PG_Gruppenlist	dc.b	"Pysion_PG_Gruppenliste",0
Helpnode_PG_Add		dc.b	"Pysion_PG_Add",0
Helpnode_PG_Delete	dc.b	"Pysion_PG_Delete",0
Helpnode_PG_Clear	dc.b	"Pysion_PG_Clear",0

Helpnode_P_Filter	dc.b	"Pysion_P_Filter",0
Helpnode_P_FadeIn	dc.b	"Pysion_P_FadeIn",0
Helpnode_P_FadeOut	dc.b	"Pysion_P_FadeOut",0
Helpnode_P_Songend	dc.b	"Pysion_P_Songend",0
Helpnode_P_AutoSubSong	dc.b	"Pysion_P_Autosubsong",0
Helpnode_P_RandomSong	dc.b	"Pysion_P_Randomsong",0
Helpnode_P_LoadBefore	dc.b	"Pysion_P_Loadbefore",0
Helpnode_P_LoadFast	dc.b	"Pysion_P_Loadfast",0
Helpnode_P_ProgrammMode	dc.b	"Pysion_P_Programmmode",0

Helpnode_P_Volume	dc.b	"Pysion_P_Volume",0
Helpnode_P_StartSong	dc.b	"Pysion_P_StartSong",0
Helpnode_P_Timeout	dc.b	"Pysion_P_MinTimeOut",0
Helpnode_P_MinTimeout	dc.b	"Pysion_P_MinTimeout",0
Helpnode_P_Passwort	dc.b	"Pysion_P_Passwort",0
Helpnode_P_Songname	dc.b	"Pysion_P_Songname",0
Helpnode_P_Specialinfo	dc.b	"Pysion_P_Specialinfo",0
Helpnode_P_Autor	dc.b	"Pysion_P_Autor",0
Helpnode_P_SelectAutor	dc.b	"Pysion_P_SelectAutor",0
Helpnode_P_Player	dc.b	"Pysion_P_Player",0
Helpnode_P_SelectPlayer	dc.b	"Pysion_P_SelectPlayer",0



			if	test
DT_PicName:		dc.b	`SYS:prefs/patterns/misc`,0
Configdir:		dc.b	"EP:configs/",0
Enginedir:		dc.b	"Engines/",0
Playerdir:		dc.b	"Eagleplayers/",0
EPDir:			dc.b	"EP:",0
			endc


QuitKey:		dc.b	"Q",0
HideKey:		dc.b	"H",0
AboutKey:		dc.b	"A",0
Fragezeichen:		dc.b	"?",0
ConfigName:		dc.b	"Pysion.config",0
MyReqToolsname:		dc.b	"reqtools.library",0
Datatypesname:		dc.b	"datatypes.library",0

ExternalStrings:
*-------------------------- Locale fr MakeCat -------------------------------*
LOCALE_START
*CATALOG	EP_Pysion
*VERSION	38.2
*DATE		28.02.97


MSG_PY_WindowTitle	dc.b	"Pysion, Module: ",0
*D				'Pysion, Modul: ',0
MSG_PY_ScreenTitle	dc.b	"Pysion (Eagleplayer),  DEFECT Softworks",0
*D				'Pysion (Eagleplayer),  DEFECT Softworks',0
MSG_PY_Project		dc.b	"Project",0
*D				'Project',0
MSG_PY_Kommandos	dc.b	"Action",0
*D				'Aktion',0
MSG_PY_Settings		dc.b	"Settings",0
*D				'Konfiguration',0
MSG_PY_Von		dc.b	" of ",0
*D				' von ',0
MSG_PY_Add		dc.b	"_Add",0
*D				'_Einfgen',0
MSG_PY_AddKey		dc.b	"a",0
*D				'e',0
MSG_PY_Delete		dc.b	"_Delete",0
*D				'_Lschen',0
MSG_PY_DeleteKey	dc.b	"d",0
*D				'l',0
MSG_PY_New		dc.b	"New",0
*D				'Neu',0
MSG_PY_NewKey		dc.b	"N",0
*D				'N',0
MSG_PY_LoadList		dc.b	"Load list",0
*D				'Liste laden',0
MSG_PY_LoadListKey	dc.b	"l",0
*D				'h',0
MSG_PY_InsertList	dc.b	"Insert list",0
*D				'Liste hinzuladen',0
MSG_PY_InsertListKey	dc.b	"i",0
*D				'i',0
MSG_PY_GDSaveList	dc.b	"_Save List",0
*D				'_Speichere Liste',0
MSG_PY_SaveList		dc.b	"Save List",0
*D				'Speichere Liste',0
MSG_PY_SaveListKey	dc.b	"S",0
*D				'S',0
MSG_PY_ModulesPrefs	dc.b	"_Modulesprefs",0
*D				'_Moduleprefs',0
MSG_PY_ModulesPrefsKey	dc.b	"M",0
*D				'M',0
MSG_PY_ClearPrefs	dc.b	"_Clear Prefs",0
*D				'Ls_che Prefs',0
MSG_PY_ClearPrefsKey	dc.b	"C",0
*D				'L',0
MSG_PY_Execute		dc.b	"_Execute",0
*D				'_Ausfhren',0
MSG_PY_ExecuteKey	dc.b	"E",0
*D				'A',0
MSG_PY_SaveConfig	dc.b	"Save Config",0
*D				'Speichere Konfiguration',0
MSG_PY_SaveConfigKey	dc.b	"C",0
*D				'K',0
MSG_PY_PlayModule	dc.b	"Play Module",0
*D				'Spiele Module',0
MSG_PY_PlayModuleKey	dc.b	"P",0
*D				'P',0
MSG_PY_About		dc.b	"About",0
*D				'ber',0
MSG_PY_Hide		dc.b	"Hide",0
*D				'Verstecken',0
MSG_PY_Quit		dc.b	"Quit",0
*D				'Beenden',0
MSG_PY_Top		dc.b	"_Top",0
*D				'An_fang',0
MSG_PY_TopKey		dc.b	"t",0
*D				'f',0
MSG_PY_Botom		dc.b	"_Botom",0
*D				'En_de',0
MSG_PY_BotomKey		dc.b	"B",0
*D				'D',0
MSG_PY_Up		dc.b	"_Up",0
*D				'_Oben',0
MSG_PY_UpKey		dc.b	"u",0
*D				'o',0
MSG_PY_Down		dc.b	"D_own",0
*D				'_Unten',0
MSG_PY_DownKey		dc.b	"o",0
*D				'u',0
MSG_PY_Synchron		dc.b	"Synchron",0
*D				'Synchron',0
MSG_PY_LoadAtStart	dc.b	"Load at start",0
*D				'Startliste laden',0
MSG_PY_AutoLearnAuthors	dc.b	"Learn authors",0
*D				'Autoren lernen',0
MSG_PY_Show		dc.b	"Show",0
*D				'Zeigen',0
MSG_PY_ShowByName	dc.b	"Without prefix",0
*D				'Ohne Prfix',0
MSG_PY_ShowByFName	dc.b	"By name",0
*D				'Name',0
MSG_PY_ShowByPath	dc.b	"By path",0
*D				'Pfad',0
MSG_PY_Hideall		dc.b	"Hideall",0
*D				'Aussondern',0
MSG_PY_BackPic		dc.b	"BackPic",0
*D				'Hintergrundbild',0
MSG_PY_SelectBackPic	dc.b	"Select BackPicture",0
*D				'Whle Hintergrundbild',0
MSG_PY_SelectAList	dc.b	"Select a list!",0
*D				'Whle eine Liste!',0
MSG_PY_SelectFiles	dc.b	"Select file(s)!",0
*D				'Whle die Datei(en)!',0
MSG_PY_SortByName	dc.b	"Without prefix",0
*D				'Ohne Prfix',0
MSG_PY_SortByFName	dc.b	"By filename",0
*D				'Nach Filename',0
MSG_PY_SortByPfad	dc.b	"By path",0
*D				'Nach Pfad',0
MSG_PY_Gruppenliste	dc.b	"Grouplist",0
*D				'Gruppenliste',0
MSG_PY_Autorliste	dc.b	"Authorlist",0
*D				'Autorenliste',0
MSG_PY_Sortieren		dc.b	"Sorting",0
*D				'Sortieren',0

MSG_PY_AboutText	dc.b	"Pysion V0.9 by",10,10
			dc.b	"Jan Blumenthal",10
			dc.b	"Erich-Mhsam-Str. 34",10
			dc.b	"18069 Rostock",10,10
			dc.b	"Tel.: +49 (0)381/83979",10
			dc.b	"Mail: jan.blumenthal@stud.uni-rostock.de",10
			dc.b	"IRC : Eagleeye on #amigager",10,10
			dc.b	"Highlights:",10
			dc.b	"* loads different listformats",10
			dc.b	"* all modules can be configurated",10
			dc.b	"* author learnmode",10
			dc.b	"* very userfriendly",10
			dc.b	"* sizeable and fontsensitiv",10
			dc.b	"* Background picture",10,10
			dc.b	"... and much more",0
*D				'Pysion V0.9 von',10,10
*D				'Jan Blumenthal',10
*D				'Erich-Mhsam-Str. 34',10
*D				'18069 Rostock',10,10
*D				'Tel.: +49 (0)381/83979',10
*D				'Mail: jan.blumenthal@stud.uni-rostock.de',10
*D				'IRC : Eagleeye on #amigager',10,10
*D				'Die Highlights:',10
*D				'* kann verschiedene Listformate lesen',10
*D				'* alle Module knnen konfiguriert werden',10
*D				'* Autorlernmodus',10
*D				'* sehr benutzerfreundlich',10
*D				'* grenvernderbar und fontsensitiv',10
*D				'* Hintergrundbild',10,10
*D				'... und vieles mehr',0
MSG_PY_SaveBeforeQuit	dc.b	"Do you want to save the list",10
			dc.b	"before quitting?",0
*D				'Wollen Sie die Liste vor dem',10
*D				'Beenden sichern?',0
MSG_PY_SaveAutorsBeforeQuit dc.b	"The list of authors is changed. Do you want",10
			dc.b	"to save it before quitting?",0
*D				'Die Autorenliste wurde gendert! Wollen Sie',10
*D				'vor dem Beenden sichern?',0
MSG_PY_RealyNew		dc.b	"The old list will be removed!",10
			dc.b	"Do you want to continue?",0
*D				'Die im Speicher befindliche Liste',10
*D				'wird gelscht. Wollen Sie wirklich',10
*D				'fortfahren?',0
MSG_PY_OverwriteIt	dc.b	"The file %s already exists.",10
			dc.b	"Do you want to overwrite it?",0
*D				'Die Datei %s existiert bereits.',10
*D				'Wollen Sie diese berschreiben',0
MSG_PY_UnknownListFormat	dc.b	"Unknown listformat in file:",10,10
			dc.b	"%s",0
*D				'Unbekanntes Listenformat in Datei:',10,10
*D				'%s',0
MSG_PY_ErrorInList	dc.b	"Error in list:",10,10
			dc.b	"%s",0
*D				'Fehler in der Liste:',10,10
*D				'%s',0
MSG_PY_ErrorWhileAdding	dc.b	"Error while adding item(s)!",0
*D				'Fehler whrend des Einfgens in',10
*D				'die Liste!',0
MSG_PY_CouldListNotLoad	dc.b	"The List could not be loaded!",0
*D				'Die Liste konnte nicht geladen werden!',0
MSG_PY_CouldListNotSave	dc.b	"The List could not be saved!",0
*D				'Die Liste konnte nicht gespeichert!',0
MSG_PY_Ok		dc.b	"_Ok",0
*D				'_Ok',0
MSG_PY_SaveGadgets	dc.b	"_Quit|_Save first",0
*D				'_Beenden|Erst _Speichern',0
MSG_PY_YesNo		dc.b	"_Yes|_No",0
*D				'_Ja|_Nein',0
MSG_PY_ReallyGadgets	dc.b	"_Yes|_Save First|_Cancel",0
*D				'_Ja|Erst _Speichern|_Abbrechen',0
MSG_PY_RequestTitle	dc.b	"Pysion_Requester",0
*D				'Pysion_Requester',0
MSG_PY_EPNotFound	dc.b	"Eagleplayer-Port not found!",0
*D				'Konnte den Eagleplayerport nicht finden',0
MSG_PY_FindDouble	dc.b	"Find double entries",0
*D				'Doppelte Eintrge suchen',0
MSG_PY_DoubleFound	dc.b	"Double Entry found:",10,10
			dc.b	"%s",10
			dc.b	"%s",10,10
			dc.b	"What are you doing?",0
*D				'Es wurde ein doppelter Eintrag gefunden!',10
*D				'%s',10
*D				'%s',10
*D				'Was wollen Sie tun?',0
MSG_PY_DoubleGadgets	dc.b	"_Delete 1|D_elete 2|All _1|All _2|_Skip|_Abort",0
*D				'1. _Lschen|2. Lschen|berspringen|_Abbrechen',0
MSG_PY_DeleteFrom	dc.b	"Should the file",10,10
			dc.b	"%s",10,10
			dc.b	"also be deleted from the device?",0
*D				'Soll die Datei',10
*D				'%s',10
*D				'auch von dem Gert gelscht werden?',0
MSG_PY_DoubleGadgets2	dc.b	"From _list|From _disk|_All|_Never|_Skip",0
*D				'von _Liste|von _Disk|_Alle|N_ie|_Nicht lschen',0
MSG_PY_NoDouble		dc.b	"No double entries found!",0
*D				'Keine doppelten Eintrge gefunden!',0
MSG_PY_NoMoreDouble	dc.b	"No more double entries found!",0
*D				'Keine weiteren Eintrge gefunden!',0
MSG_PY_Overwrite	dc.b	"Overwrite",0
*D				'berschreiben',0
MSG_PY_AutorWindowtitle	dc.b	"Pysion Authorlist",0
*D				'Pysion Autorliste',0
MSG_PY_SelectAutor	dc.b	"Select author for ",0
*D				'Whle den Autor fr ',0
MSG_PY_GruppenWindowtitle dc.b	"Pysion Grouplist",0
*D				'Pysion Gruppenliste ',0
MSG_PY_SelectGruppe	dc.b	"Select Group for ",0
*D				'Whle Gruppe fr ',0
MSG_PY_AddAutor		dc.b	"Please enter the name of",10
			dc.b	"the author!",0
*D				'Bitte geben Sie den Namen des',10
*D				'Autoren ein!',0
MSG_PY_AddGruppe		dc.b	"Please enter the name of",10
			dc.b	"the group!",0
*D				'Bitte geben Sie den Namen der',10
*D				'Gruppe ein!',0

MSG_PY_P_Enginelist	dc.b	"Enginelist",0
*D				'Engineliste',0
MSG_PY_P_Gruppenlist	dc.b	"Grouplist",0
*D				'Gruppenliste',0
MSG_PY_P_Add		dc.b	"Add",0
*D				'Hinzu',0
MSG_PY_P_Delete		dc.b	"Delete",0
*D				'Lschen',0
MSG_PY_P_Clear		dc.b	"Clear",0
*D				'Neu',0
MSG_PY_P_Filter		dc.b	"Filter",0
*D				'Filter',0
MSG_PY_P_FadeIn		dc.b	"Fade in",0
*D				'Einblenden',0
MSG_PY_P_FadeOut	dc.b	"Fade out",0
*D				'Ausblenden',0
MSG_PY_P_Songend	dc.b	"Songend",0
*D				'Songend',0
MSG_PY_P_AutoSubSong	dc.b	"Auto subsong",0
*D				'autom. Songs',0
MSG_PY_P_RandomSong	dc.b	"Random song",0
*D				'Zufllige Songs',0
MSG_PY_P_LoadBefore	dc.b	"Load before",0
*D				'Vorher laden',0
MSG_PY_P_LoadFast	dc.b	"Load Fast",0
*D				'Lade in FAST',0
MSG_PY_P_ProgrammMode	dc.b	"ProgramMode",0
*D				'Programmierung',0
MSG_PY_P_Volume		dc.b	"Volume",0
*D				'Lautstrke',0
MSG_PY_P_StartSong	dc.b	"Startsong",0
*D				'Startsong',0
MSG_PY_P_Timeout	dc.b	"Timeout",0
*D				'Spielzeit',0
MSG_PY_P_MinTimeout	dc.b	"Min. Timeout",0
*D				'Min. Spielzeit',0
MSG_PY_P_Passwort	dc.b	"Password",0
*D				'Pawort',0
MSG_PY_P_Songname	dc.b	"Songname",0
*D				'Songname',0
MSG_PY_P_Specialinfo	dc.b	"Description",0
*D				'Beschreibung',0
MSG_PY_P_Autor		dc.b	"Author",0
*D				'Autor',0
MSG_PY_P_Player		dc.b	"Player",0
*D				'Abspieler',0
MSG_PY_L_NotChanged	dc.b	"No change",0
*D				'Nicht ndern',0
MSG_PY_L_Yes		dc.b	"Enabled",0
*D				'An',0
MSG_PY_L_No		dc.b	"Disabled",0
*D				'Aus',0
MSG_PY_LM_NoNewModule	dc.b	"No new module",0
*D				'kein neues',0
MSG_PY_LM_NextModule	dc.b	"Next module",0
*D				'Nchstes',0
MSG_PY_LM_PrevModule	dc.b	"Prev module",0
*D				'Vorheriges',0
MSG_PY_LM_RandomModule	dc.b	"Random module",0
*D				'Zufllig',0
MSG_PY_Module		dc.b	"Module: ",0
*D				'Modul: ',0
MSG_PY_Gruppe		dc.b	"Group: ",0
*D				'Gruppe: ',0
MSG_PY_Autor		dc.b	"Author: ",0
*D				'Autor: ',0
MSG_PY_ModulePrefsFor	dc.b	"Prefs for ",0
*D				'Einstellungen fr ',0
MSG_PY_GetFile		dc.b	"?",0
*D				'?',0
MSG_PY_SelectEngine	dc.b	"Please select an engine!",0
*D				'Bitte whle ein Engine!',0
MSG_PY_SelectPlayer	dc.b	"Please select a player!",0
*D				'Bitte whle einen Player!',0

LOCALE_END
			dc.b	0		* <-- Kennung fr Ende


*-----------------------------------------------------------------------------*
		SECTION	BSSMErkPuffer,BSS
Puffer		ds.b	PufferEnd

	


 END


*#############################################################################*
Aufbau des Prefsfiles:
----------------------

EP-LIST
@GLOBALPREFS
MP:"...." ME::"..:"
@END

@GROUPS
Ani MP:"..:"
Tekkno MP:"..." ME:"...."
@END

@AUTHORS
Ravebusters MP:"..." ME:"..."
@END

... Modules





Aufbau des Prefseintrages:


"Modulename" MP:"..." ME:"..."

Inhalt von Moduleprefs:
-----------------------
EPNummer=Zustand oder Zahl oder String

BSP:	67=1		;67=Fadein-EPNummer 1=an
	116=64		;116=Volume-EPNummer 64=Lautstrke
	147='Moduleinfo';'Analyzer'


* Modulenamen sind immer von Gnsefsschen eingechlossen, wenn ModPrefs
  oder ModEigenschaften vorliegen
* String in ModPrefs/Eigen werden immer durch '' eingeschlossen
* Die einzelnen Nummer sind durch Kommata voneinander getrennt!
* mehrere Argumente bei einer EP-Nr werden durch ; getrennt
* innerhalt von ModPrefs/ModEigen darf kein Gnsefsschen auftauchen !!!!
* 

Gesamtbeispiel 1:
-----------------

"Mod.Condom" MP:"116=64,67=1,147='Moduleinfo'=01=EP='140,45,43';'Analyzer'"

116=Volume
67=FadeIn
147=AscEngine
	Moduleinfo wird konfiguriert
		01=Pysionflags -> wird enabled/disabled ...
		EP='140,45,43' sind jetzt interne Konfigurationsdaten fr
		   Moduleinfo (Learnmodus). Ist dem Pysion egal
	Analyzer wird konfiguriert
		keine Argumente-> wird aktiviert


Gesamtbeispiel 2:
-----------------
"Mod.Condom" MP:"'8-Bit Amplifier'" ME:"01='Tekkno,Jazz,Ani'"

01 ist hier die Bezeichnung fr Gruppeneinteilung. Rest drfte klar sein.










Menu2:
	Entryinfo	(Pfad, Lock holen, (Decrunch)Size anzeigen)
			Module noch da?, Authoren
	~~~~~~~~~~~~~~~~
	Save Authors
	~~~~~~~~~~~~~~~~
	Sortieren nach	-> Name
			-> Pfad
			-> Random ? Die Liste durcheinanderwrfeln

Menu3:
	SecurityMode	(immer Sicherheitsrequester)
	Anzeigen	-> Name
			-> Pfad
			-> Author ?



* Extractordir !!!!





	lea	Text1,a0
	lea	Text2,a0
	lea	Text3,a0
	lea	Text4,a0
	lea	Text5,a0
	jsr	BerechStringsize3
	clr.b	(a0,d0.w)
	illegal

Text1:	dc.b	34
	dc.b	"Hallo,'Hallo','Test',9"
	dc.b	34,0
	dc.b	"AAAA"
Text2:	dc.b	"Hallo",0
	dc.b	"AAAA"
Text3:	dc.b	"Hallo,'Hallo'",0
Text4:	dc.b	34,"Neuer Name,'Hallo'",34,0
Text5:	dc.b	'"l"',0
	even


		dc.b	NM_ITEM,0
LLM_SaveAuthors:dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0
MNr_SaveAuthors		rs.b	NextItem
			rs.b	NextItem		;Barlabel
		dc.w	LENr_SaveAuthors,LLM_SaveAuthors-LocaleTabelle
EPENr_SaveAuthors	rs.b	1
LENr_SaveAuthors	rs.b	1
.EPENr_SaveAuthors	PJM	SaveAuthors,HelpNode_SaveAuthors
		dc.w	MNr_SaveAuthors,EPENr_SaveAuthors
MSG_PY_SaveAuthors	dc.b	"Save Authors",0
*D				'Autorenliste speichern',0



ACHTUNG: CLearMenuStrip msste noch berarbeitet werden!
