*****************************************************************************
**                                                                         **
** Engine: Playerloader                                                    **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


*******************************************************************************
******									*******
******			Engine by Eagleeye & Buggs of DEFECT		*******
******									*******
******                                                                  *******
****** History:                                                         *******
******    possible Enforcer hits fixed, MED check fixed                 *******
*----- JCBroke eingebaut
* TME, MusicMaker,HIPPEL
*
*20.7.96: Jason Page eingebaut
* 21.7.96: THX, Follinplayer -> Tim Follin II
*	   Sidmon2.0 Check 
*	   Digibooster
*	   Rob Hubbard 2
* 22.09.96 ActivisionPro erweitert
*
* 30.09.96 AIFF Support
* 01.11.96 Profiteam fixed
* 14.11.96 Gluemon added
* 	   Mark Cooksey added
* 08.12.96 RIFF WAVE added, 8SVX moved to Check1List
* 10.12.96 Check3-Players in die erste Liste mit aufgenommen
* 13.12.96 "Soundtracker Pro II" added
* 14.12.96 TronicTracker/Musicline/PSA added
* 20.12.96 PlayAY,ActivisionPro disabled
* 14.01.97 Scumm added
* 20.01.97 Benn Daglish,DavidHanney,Sean Connolly added
* 24.02.97 MTH disabled
* 16.03.97 Magnetic Fields,JasonPage (New/Old) added (Marleys Jason disabled)
* 20.03.97 Soundcontrol
* 03.04.97 Protracker 4
* 11.04.97 Digibooster fix (a0)+, Bugreport von Alexis Nasr
* 16.04.97 Gluemaster added
* 31.05.97 A.M.Composer/SunTronic/Sean Conran added
* 02.08.97 MPEG erweitert (notdrftig)
* 11.08.97 Scott Johnston
* 14.08.97 Laxity_Check/Gluemaster_Check/Pumatracker_Check Update
*	   ActivisionPro readded
* 16.08.97 Jesper Olsen added
* 20.08.97 ActivisionPro/SeanConolly update
* 25.08.97 THX2
* 25.08.97 JesperOlsen update
* 11.09.97 THX2 removed, THX update
* 18.09.97 Activision Pro eingeschrnkt, erkennt momentan nur die Module,
*	   die wir auch haben...
* 31.10.97 Symphonie added
* 20.01.98 Art&Magic, Tiny Williams, DigiboosterPro added
* 16.03.98 MPEGAPLAYER -> "MPEG AUDIO"
* 05.04.98 Mark II Old added
* 11.04.98 Impulsetracker,DMF, Stonetracker,Composer669, Polytracker added
* 16.04.98 MPEG Audio Check abgendert, sollte jetzt alle normalen MPEGs erkennen
*******************************************************************************
* Wenn TaskAdr = NUll --> kein Prozess, nur Proggy
*                     --> MsgFlags ohne Bedeutung
* Bei SendeOneMsg werden, falls gefunden, die Tags aufgerufen
*
*******************************************************************************
Executable		= 1

ver		macro
		dc.b	"2.06"
		endm
StructVer	macro
		dc.w	2,06
		endm
date		macro
		dc.b	"16-Apr-98"
		endm
StructDate	macro
		dc.b	16,04
		dc.w	1998
		endm

*-----------------------------------------------------------------------------*

		incdir	include:
		include	"misc/eagleplayer.i"
		include	"misc/eagleplayerengine.i"
	
		incdir	"include:"
;		include	"intuition/intuition.i"
;		include	"intuition/intuition_lib.i"
		include	"exec/exec_lib.i"
;		include	"dos/dos_lib.i"
;		include	"graphics/graphics_lib.i"
;		include	"libraries/gadtools_lib.i"
;		include	"libraries/gadtools.i"
;		include	"misc/MyUserMacros.i"

	ifeq	executable
		lea	data,a0
		move.l	#1500,d0
		move.l	#Datasize,d1
		lea	Testname,a1
		lea	Playerlist,a2
		bsr	CheckForPlayer
		tst.l	d0
		beq.s	.Ille
		lea	data,a0
		move.l	#DataSize,d0
		move.l	#DataSize,d1
		lea	Testname,a1
		lea	Playerlist,a2
		bsr	CheckForPlayer
.Ille:		illegal
	endc

*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
;UserStartPrg
EUS_Structure:	moveq	#-1,d0				;EUS_Jump
		rts
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0			;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	0				;EUS_TickFlags
		dc.l	0				;EUS_MsgFlags
		dc.l	MyCreatorname			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	33				;EUS_Kickstart
		dc.l	10				;EUS_EPVersion
		StructVer				;EUS_Version,EUS_Revision
		dc.l	MyMenuName			;EUS_Username
		dc.w	0				;EUS_WinX
		dc.w	0				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
		dc.w	0				;EUS_Special
		dc.w	0				;EUS_Special+2
		dc.l	0				;EUS_Special2
		dc.l	0				;EUS_Special3
		StructDate				;EUS_Creatordate
		dc.b	0				;EUS_Priority
		dc.b	EUTY_PlayerLoader		;EUS_type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6

		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

	dc.b	"$VER: Eagleplayer-Playerloader "
	ver
	dc.b	" ("
	date
	dc.b	")",0
	even

TagListe:	dc.l	EUT_CheckForPlayer,CheckForPlayer
		dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Playerloader
;		dc.l	EUT_InitUserPrg,Farbe
		dc.l	0
		


EPT_TextStruct:	dc.l	0


farbe:		moveq	#-1,d0
.C		move.w	d0,$dff180
		dbf	d0,.C
		moveq	#0,d0
		rts

******************************************************************************
*INPUT : d0=Size des Speicherbereichs
*        d1=Size des Files
*        a0=Adresse des Files
*	 a1=Name des Files
*	 a2=PlayerList
*OUTPUT: d0=Error oder NULL
*        a0=EPT-Textstucture
******************************************************************************
* --- Unterroutinen ----*
* Input: d0=Size des Speichers
*        d1=Filesize
*        a0=Adresse des Files
* Output:d0=Null oder Fehler
CheckForPlayer:	clr.l	EPT_TextStruct
		lea	TestPlayerListe1-8(pc),a4
		cmp.l	d0,d1
		bne.s	.Check1
		lea	TestPlayerListe2-8(pc),a4
.Check1:	move.l	a2,d3
		move.l	a1,d4
		move.l	a0,d5
		move.l	d0,d6
		move.l	d1,d7
		sub.l	a6,a6			;EPT_Structure

.NextPlayer:	addq.l	#8,a4
		move.l	(a4),d0
		beq.w	.NoMore
		move.l	d0,a3

		move.l	d5,a0			;Adr des Files
		move.l	d6,d0			;geladene Bytes des Files
		move.l	d7,d1			;gesammte FileSize

		movem.l	d2-a6,-(a7)
		tst.l	d0
		jsr	(a3)			;Check-Routine aufrufen
		movem.l	(a7)+,d2-a6
		tst.l	d0
		bne.s	.NextPlayer


	*---------- Playernamen durchtesten ------------*
		move.l	4(a4),a1		;UserPrg-Playername
		move.l	d3,a2			;Adr der Playerliste
		tst.l	d3			;Keine Player
		beq.s	.ListNoPlayer

		* Player in Tagliste suchen *
		*--> EPP_Find-Tag
		* Input: a0 = Tagliste						-----*
		*        d0 = Tag							-----*
		*Output: d0 = TagWert
		*        d1 = Ergebnis (0=nein 1=ja)
.ListNextP:	move.l	a2,a0
		move.l	EPPl_TagList(a0),a0
		move.l	#DTP_PlayerName,d0
	if	executable
		jsr	ENPP_FindTag(a5)
	else
		bsr	FindTag
	endc
		tst.l	d1
		beq.s	.ListNoName
		move.l	d0,a0
	if	executable
		jsr	ENPP_StringCMP(a5)		;Player ist da 
	else
		bsr	StrCMP
	endc
		tst.l	d0			;dieser Player existiert !!!
		beq.s	.NextPlayer		;Nchster Player
.ListNoName:	move.l	(a2),d0			
		beq.s	.ListNoPlayer
		move.l	d0,a2
		bra.s	.ListNextP

	*---------- Player jetzt an Ladeliste hngen -----------*
.ListNoPlayer:	moveq	#EPT_String+MaxFilenameSize,d0
		move.l	d0,d2
		movem.l	a1/a6,-(a7)
		move.l	4,a6
		move.l	#$10001,d1
		jsr	_LVOAllocMem(a6)
		movem.l	(a7)+,a6/a0
		tst.l	d0
		beq.s	.OutOfMem
		move.l	d0,a1
		move.l	d2,EPT_StringSize(a1)

		move.l	a6,d0
		bne.s	.NoA6
		move.l	a1,EPT_TextStruct
		bra.s	.A6IsZero
.NoA6:		move.l	a1,(a6)
.A6IsZero:	move.l	a1,a6

		lea	EPT_String(a1),a1
		moveq	#MaxFilenamesize-1,d1
;	if	executable
		jsr	ENPP_StringCopy(a5)
;	else
;		bsr.w	StringCopy
;	endc
		bra.w	.NextPlayer

	*----------------- Ende der Suchroutinen ----------------*
.OutOfMem:	moveq	#EPR_NotEnoughMem,d0
		sub.l	a0,a0
		bra.s	.NotFound
.NoMore:	sub.l	a0,a0
		moveq	#EPR_UnknownFormat,d0
		move.l	EPT_TextStruct(pc),d1
		beq.s	.NotFound
		move.l	d1,a0
		moveq	#0,d0
.NotFound:	rts
		



*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
TestPlayerListe1:
			dc.l	ADPCM_Check,ADPCM_Name			;Check3
			dc.l	AIFF_Check,AIFF_Name
			dc.l	ArtOfNoise_Check,ArtOfNoise_Name	;Check3
			dc.l	IFF8SVX_Check,IFF8SVX_Name
			dc.l	IFFSMUS_Check,IFFSMUS_Name
			dc.l	MaxTrax_Check,MaxTrax_Name
			dc.l	MPEG_Check,MPEG_Name
			dc.l	Stonetracker_Check,Stonetracker_Name
			dc.l	WAVE_Check,WAVE_Name
			dc.l	0


TestPlayerListe2:
			dc.l	ActionAmics_Check,ActionAmics_Name
			dc.l	ActivisionPro_Check,ActivisionPro_Name
			dc.l	AMComposer_Check,AMComposer_Name
			dc.l	ADPCM_Check,ADPCM_Name
			dc.l	APS_Check,APS_Name
			dc.l	ArtOfNoise_Check,ArtOfNoise_Name
			dc.l	ArtMagic_Check,ArtMagic_Name
			dc.l	BennDaglish_Check,BennDaglish_Name
			dc.l	ChipTracker_Check,ChipTracker_Name
			dc.l	C669_Check,C669_Name
			dc.l	DavidWhittaker_Check,DavidWhittaker_Name
			dc.l	DavidHanney_Check,DavidHanney_Name
			dc.l	DeltaMusic10_Check,DeltaMusic10_Name
			dc.l	DeltaMusic20_Check,DeltaMusic20_Name
			dc.l	DigiBooster_Check,DigiBooster_Name
			dc.l	DigiBoosterPro_Check,DigiBoosterPro_Name
			dc.l	DigitalMugician_Check,DigitalMugician_Name
			dc.l	DMF_Check,DMF_Name
			dc.l	DSS_Check,DSS_Name
			dc.l	EMS_Check,EMS_Name
			dc.l	FaceTheMusic_Check,FaceTheMusic_Name
			dc.l	FastTrackerII_Check,FastTrackerII_Name
			dc.l	Fred_Check,Fred_Name
			dc.l	FutureComposer1.3_Check,FutureComposer1.3_Name
			dc.l	FutureComposer1.4_Check,FutureComposer1.4_Name
			dc.l	GMOD_Check,GMOD_Name
			dc.l	GlueMaster_Check,GlueMaster_Name
			dc.l	GlueMon_Check,GlueMon_Name
			dc.l	Hippel_Check,Hippel_Name
			dc.l	HippelCOSO_Check,HippelCOSO_Name
			dc.l	Hippel7V_Check,Hippel7V_Name
			dc.l	IFFEMOD_Check,IFFEMOD_Name
			dc.l	Impulse_Check,Impulse_Name
			dc.l	InStereo1.0_Check,InStereo1.0_Name
			dc.l	InStereo2.0_Check,InStereo2.0_Name
			dc.l	JCBroke_Check,JCBroke_Name
			dc.l	JamCracker_Check,JamCracker_Name
			*dc.l	JasonPage_Check,JasonPage_Name
			dc.l	JasonPageNew_Check,JasonPageNew_Name
			dc.l	JasonPageOld_Check,JasonPageOld_Name
			dc.l	JesperOlsen_Check,JesperOlsen_Name
			dc.l	LaxityPlayer_Check,LaxityPlayer_Name
			dc.l	LME_Check,LME_Name
			dc.l	MagneticFields_Check,MF_Name
			dc.l	MarkII_Check,MarkII_Name
			dc.l	MarkIIOld_Check,MarkIIOld_Name
			dc.l	MarkCooksey_Check,MarkCooksey_Name
			dc.l	MGrouleff_Check,MGrouleff_Name
			dc.l	MON_Check,MON_Name
			dc.l	MajorTom_Check,MajorTom_Name
			dc.l	MCMD_Check,MCMD_Name
			dc.l	MED_Check,MED_Name
			*dc.l	MTH_Check,MTH_Name
			dc.l	Musicline_Check,Musicline_Name
			dc.l	MusicAssembler_Check,MusicAssembler_Name
			dc.l	MusicMaker4_Check,MusicMaker4_Name
			dc.l	MusicMaker8_Check,MusicMaker8_Name
			dc.l	OctaMED_Check,OctaMED_Name
			dc.l	Oktalyzer_Check,Oktalyzer_Name
			dc.l	PlayAY_Check,PlayAY_Name
			dc.l	PlaySID_Check,PlaySID_Name
			dc.l	Polytracker_Check,Polytracker_Name
			dc.l	ProfiteamSoundfactory_Check,ProfiteamSoundfactory_Name
			dc.l	Promizer01_Check,Promizer01_Name
			dc.l	Promizer1x_Check,Promizer1x_Name
			dc.l	Promizer40_Check,Promizer40_Name
			dc.l	Protracker4_Check,Protracker4_Name
			dc.l	PSA_Check,PSA_Name
			dc.l	PS3M_Check,PS3M_Name
			dc.l	PumaTracker10_Check,PumaTracker10_Name
			dc.l	RobHubbard_Check,RobHubbard_Name
			dc.l	RobHubbard2_Check,RobHubbard2_Name
			dc.l	RonKlaren_Check,RonKlaren_Name
			dc.l	ScottJohnston_Check,ScottJohnston_Name
			dc.l	SeanConnolly_Check,SeanConnolly_Name
			dc.l	SeanConran_Check,SeanConran_Name
			dc.l	SIDMon10_Check,SIDMon10_Name
			dc.l	SIDMon20_Check,SIDMon20_Name
			dc.l	Scumm_Check,Scumm_Name
			dc.l	SonicArranger_Check,SonicArranger_Name
			dc.l	SoundControl_Check,SoundControl_Name
			dc.l	SoundFX13_Check,SoundFX13_Name
			dc.l	SoundFX20_Check,SoundFX20_Name
			dc.l	SoundMaster_Check,SoundMaster_Name
			dc.l	SoundMon_Check,SoundMon_Name
			dc.l	SoundMon22_Check,SoundMon22_Name
			dc.l	SoundTracker26_Check,SoundTracker26_Name
			dc.l	SoundtrackerPro_Check,SoundtrackerPro_Name
			dc.l	Suntronic_Check,Suntronic_Name
			dc.l	Symphonie_Check,Symphonie_Name
			dc.l	Synth40_Check,Synth40_Name
			dc.l	Syntracker_Check,Syntracker_Name
			dc.l	TFMX15_Check,TFMX15_Name
			dc.l	TFMX7V_Check,TFMX7V_Name
			dc.l	TFMXPro_Check,TFMXPro_Name
			dc.l	TF_Check,TF_Name
			dc.l	THX_Check,THX_Name
			dc.l	TinyWilliams_Check,TinyWilliams_Name
			dc.l	TME_Check,TME_Name
			dc.l	Tronic_Check,Tronic_Name
			dc.l	VectorDean_Check,VectorDean_Name
			dc.l	VSS_Check,VSS_Name
			*dc.l	WizardOfSound_Check,WizardOfSound_Name
			dc.l	XMOD_Check,XMOD_Name
			dc.l	0

*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
*---------------------------  DIE PLAYERNAMEN -------------------------------*
*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
ActionAmics_Name:	dc.b	"Action Amics",0		;ok
ActivisionPro_Name:	dc.b	"Activision Pro",0
AMComposer_Name:	dc.b	"A.M.Composer 1.2",0
ADPCM_Name:		dc.b	"ADPCM",0
AIFF_Name:		dc.b	"AIFF",0
APS_Name:		dc.b	"AProSys",0			;ok
ArtOfNoise_Name:	dc.b	"Art of Noise",0
ArtMagic_Name:		dc.b	"Art&Magic",0
BennDaglish_Name:	dc.b	"Benn Daglish",0
ChipTracker_Name:	dc.b	"ChipTracker",0
C669_Name:		dc.b	"669",0
DavidWhittaker_Name:	dc.b	"David Whittaker",0
DavidHanney_Name:	dc.b	"David Hanney",0
DeltaMusic10_Name:	dc.b	"DeltaMusic 1.0",0		;ok
DeltaMusic20_Name:	dc.b	"DeltaMusic 2.0",0		;ok
DigiBooster_Name:	dc.b	"DigiBooster",0
DigiBoosterPro_Name:	dc.b	"DigiBoosterPro",0
DigitalMugician_Name:	dc.b	"Digital Mugician",0
DMF_Name:		dc.b	"DMF",0
DSS_Name:		dc.b	"DSS",0
EMS_Name:		dc.b	"EMS",0
FaceTheMusic_Name:	dc.b	"Face the Music",0
FastTrackerII_Name:	dc.b	"FastTracker II",0
Fred_Name:		dc.b	"Fred",0
FutureComposer1.3_Name:	dc.b	"Future Composer 1.3",0
FutureComposer1.4_Name:	dc.b	"Future Composer 1.4",0
GMOD_Name:		dc.b	"GMOD",0
GlueMaster_Name:	dc.b	"GlueMaster",0
GlueMon_Name:		dc.b	"GlueMon",0
Hippel_Name:		dc.b	"Hippel",0
HippelCOSO_Name:	dc.b	"Hippel-COSO",0
Hippel7V_Name:		dc.b	"Hippel_7V",0
IFFEMOD_Name:		dc.b	"IFF EMOD",0
IFF8SVX_Name:		dc.b	"IFF 8SVX",0
IFFSMUS_Name:		dc.b	"IFF-SMUS",0
Impulse_Name:		dc.b	"Impulsetracker",0
InStereo1.0_Name:	dc.b	"In Stereo 1.0",0
InStereo2.0_Name:	dc.b	"In Stereo 2.0",0
JCBroke_Name:		dc.b	"J.C.Brooke",0
JamCracker_Name:	dc.b	"JamCracker",0
*JasonPage_Name:	dc.b	"Jason Page",0
JasonPageNew_Name:	dc.b	"Jason Page New",0
JasonPageOld_Name:	dc.b	"Jason Page Old",0
JesperOlsen_Name:	dc.b	"Jesper Olsen",0
LaxityPlayer_Name:	dc.b	"Laxity-Player",0
LME_Name:		dc.b	"LME",0
MF_Name:		dc.b	"Magnetic Fields",0
MGrouleff_Name:		dc.b	"M. Grouleff",0
MON_Name:		dc.b	"M.O.N.",0
MajorTom_Name:		dc.b	"Major Tom 2.01",0
MarkII_Name:		dc.b	"Mark II",0
MarkIIOld_Name:		dc.b	"Mark II Old",0
MarkCooksey_Name:	dc.b	"Mark Cooksey",0
MaxTrax_Name:		dc.b	"MaxTrax",0
MCMD_Name:		dc.b	"MCMD",0
MED_Name:		dc.b	"MED",0
MPEG_Name:		dc.b	"MPEG Audio",0
*MTH_Name:		dc.b	"MTH",0
MusicAssembler_Name:	dc.b	"Music Assembler",0
MusicMaker4_Name:	dc.b	"MusicMaker4",0
MusicMaker8_Name:	dc.b	"MusicMaker8",0
Musicline_Name:		dc.b	"Musicline",0
OctaMED_Name:		dc.b	"OctaMED",0
Oktalyzer_Name:		dc.b	"Oktalyzer",0
PlayAY_Name:		dc.b	"PlayAY",0
PlaySID_Name:		dc.b	"PlaySID",0
Polytracker_Name:	dc.b	"Polytracker",0
ProfiteamSoundfactory_Name:dc.b	"Profiteam-Soundfactory",0
Promizer01_Name:	dc.b	"Promizer 0.1",0
Promizer1x_Name:	dc.b	"Promizer 1.x",0
Promizer40_Name:	dc.b	"Promizer 4.0",0
Protracker4_Name:	dc.b	"Protracker4",0
PSA_Name:		dc.b	"PSA",0
PS3M_Name:		dc.b	"PS3M",0
PumaTracker10_Name:	dc.b	"PumaTracker 1.0",0
WAVE_Name:		dc.b	`RIFF WAVE`,0
RobHubbard_Name:	dc.b	"Rob Hubbard",0
RobHubbard2_Name:	dc.b	"Rob Hubbard 2",0
RonKlaren_Name:		dc.b	"Ron Klaren",0
ScottJohnston_Name:	dc.b	"Scott Johnston",0
SeanConnolly_Name:	dc.b	"Sean Connolly",0
SeanConran_Name:	dc.b	"Sean Conran",0
SIDMon10_Name:		dc.b	"SIDMon 1.0",0
SIDMon20_Name:		dc.b	"SIDMon 2.0",0
Scumm_Name:		dc.b	"Scumm",0
SonicArranger_Name:	dc.b	"SonicArranger",0
SoundControl_Name:	dc.b	"SoundControl",0
SoundFX13_Name:		dc.b	"SoundFX 1.3",0
SoundFX20_Name:		dc.b	"SoundFX 2.0",0
SoundMaster_Name:	dc.b	"SoundMaster",0
SoundMon_Name:		dc.b	"SoundMon",0
SoundMon22_Name:	dc.b	"SoundMon 2.2",0
SoundTracker26_Name:	dc.b	"SoundTracker 2.6",0
SoundTrackerPro_Name:	dc.b	"SoundTracker Pro II",0
SoundTrackerPro30_Name:	dc.b	"SoundTrackerPro 3.0",0
Stonetracker_Name:	dc.b	"Stontracker",0
Suntronic_Name:		dc.b	"SUNTronic",0
Symphonie_Name:		dc.b	"Symphonie Pro",0
Synth40_Name:		dc.b	"Synth 4.0",0
Syntracker_Name:	dc.b	"SynTracker",0
TFMX15_Name:		dc.b	"TFMX_1.5",0
TFMX7V_Name:		dc.b	"TFMX_7V",0
TFMXPro_Name:		dc.b	"TFMX_Pro",0
TF_Name:		dc.b	"Tim Follin II",0
TinyWilliams_Name:	dc.b	"Tiny Williams",0
THX_Name:		dc.b	"THX",0
TME_Name:		dc.b	"TME",0
Tronic_Name:		dc.b	"Tronic",0
VectorDean_Name:	dc.b	"VectorDean",0
VSS_Name:		dc.b	"VSS",0
*WizardOfSound_Name:	dc.b	"Wizard of Sound",0
XMOD_Name:		dc.b	"XMOD",0
			even


*---------------- Amiga-Actions-SoundTool Check-Routine ----------------*
ActionAmics_Check:lea	62(a0),a0
		lea	AA_TestData(pc),a1
		moveq	#0,d0
.NextB		move.b	(a1)+,d0
		beq.s	.Found
		cmp.b	(a0)+,d0
		beq.s	.NextB
.Found:		rts
AA_TestData:	dc.b	"ACTIONAMICS SOUND TOOL",0
		even

*---------------------------------------------------------------------------*
ActivisionPro_Check:				;d1=CheckSize
		move.l	a0,a4
		cmp.w	#$6000,(a0)
		beq	.checkwei
		cmp.w	#$48e7,(a0)
		beq	.checkwei
		cmp.w	#$2F08,(a0)
		beq	.checkwei
		moveq	#-1,d0
		rts
.checkwei
		move.l	d0,d4
		move.l	d0,d2
		move.l	a0,a2
		lea	.CheckData1(pc),a1
		move.l	#.CheckData1Size/2-1,d1
		bsr	.FindBytes
		bne.s	.Test2
	*	move.l	a0,Load_InitAdr

		lea	.CheckData2(pc),a1
		move.l	#.CheckData2Size/2-1,d1
		bsr	.FindBytes
		bne.w	.Return
	*	move.l	a0,Load_MusicAdr
		moveq	#0,d1
		cmp.w	#$4e75,40(a2)
		bne.s	.Normal
		moveq	#2,d1
.Normal:
	*	move.l	d1,Load_FirstSong
		moveq	#0,d0
		bra.w	.Return

.Test2:		move.l	a4,a0
		move.l	d4,d2

		lea	.CheckData3(pc),a1
		move.l	#.CheckData3Size/2-1,d1
		bsr	.FindBytes
		bne.s	.Test3
	*	move.l	a0,Load_InitAdr

		lea	.CheckData4(pc),a1
		move.l	#.CheckData4Size/2-1,d1
		bsr	.FindBytes
		bne.w	.Return
	*	move.l	a0,Load_MusicAdr
	*	move.l	#2,Load_FirstSong
		moveq	#0,d0
		bra.w	.Return

.Test3:		move.l	a4,a0
		move.l	d4,d2

		cmp.w	#$6000,(a0)
		bne.w	.Error
		cmp.w	#$6000,4(a0)
		bne.s	.Error
		cmp.w	#$6000,8(a0)
		bne.s	.Error
		cmp.w	#$6000,12(a0)
		bne.s	.Error
		cmp.w	#$6000,16(a0)
		bne.s	.Error
		cmp.w	#$6000,20(a0)
		bne.s	.Error
		cmp.w	#$6000,24(a0)
		bne.w	.Error
		cmp.w	#$6000,28(a0)
		bne.w	.Error
		cmp.w	#$6000,32(a0)
		bne.w	.Error
		cmp.w	#$6000,32(a0)
		bne.w	.Error
		move.w	5*4+2(a0),d0
		lea	5*4+2(a0,d0.w),a1
		*cmp.w	#$7000,(a1)
		*beq.s	.Error
		cmp.l	#$2f0841fa,(a1)
		bne.s	.Error
	*	move.l	a1,Load_InitAdr
		move.w	6*4+2(a0),d0
		lea	6*4+2(a0,d0.w),a1
	*	move.l	a1,Load_MusicAdr
	*	move.l	#2,Load_FirstSong
		moveq	#0,d0
		bra.s	.Return

.Error:		moveq	#-1,d0
.Return:	rts

	*-------------------------------------------------*
	* a0=Adr
	* d2=Size
.FindBytes:	move.l	d1,d3
		bsr	.CheckString
		beq.s	.Gefunden
		addq.l	#2,a0
		subq.l	#2,d2
		bgt.s	.FindBytes
		moveq	#-1,d0
		rts

.Gefunden:	moveq	#0,d0
		rts


	*-------------------------------------------------------------------*
	* Input: a0=Adr 1
	*	 a1=Adr 2
	*	 d1=Size
	* Output:d0=Error oder NULL
	*-------------------------------------------------------------------*
.CheckString:	movem.l	a0/a1/d1/d3,-(a7)
		moveq	#-1,d0
.CheckIt:	move.w	(a1)+,d1
		cmp.w	#-1,d1
		beq.s	.DiesNicht
		cmp.w	(a0),d1
		bne.s	.NE
.DiesNicht:	addq.l	#2,a0
		dbf	d3,.CheckIt
		moveq	#0,d0
.Ne:		movem.l	(a7)+,a0/a1/d1/d3
		rts


	*-----------------------------------------------------------------------------*
.CheckData1:	movem.l	d0-d5/a0-a6,-(sp)
		asl.w	#4,d1
		moveq	#0,d0
.CheckData1Size	= *-.CheckData1

*-----------------------------------------------------------------------------*
.CheckData2:	movem.l	d0-d5/a0-a6,-(sp)
		dc.w	$41fa,-1	;lea	lbL000874(pc),a0
		dc.w	$43fa,-1	;lea	lbL0008F2(pc),a1
		dc.w	$47fa,-1	;lea	lbW000976(pc),a3
		dc.w	$4bfa,-1	;lea	lbW000C22(pc),a5
		movea.l	#$DFF0A0,a6
.CheckData2Size	= *-.CheckData2

*-----------------------------------------------------------------------------*
.CheckData3:	movem.l	a0/a1,-(a7)
		dc.w	$41fa,-1	;lea	lbL000874(pc),a0
		dc.w	$43fa,-1	;lea	lbL0008F2(pc),a1
		andi.l	#$000000ff,d0
		asl.w	#2,d0
.CheckData3Size	= *-.CheckData3

*-----------------------------------------------------------------------------*
.CheckData4:	movem.l	d0-d5/a0-a6,-(sp)
		dc.w	$41fa,-1	;lea	lbL000874(pc),a0
		dc.w	$43fa,-1	;lea	lbL0008F2(pc),a1
		dc.w	$4bfa,-1	;lea	lbW000976(pc),a3
		movea.l	#$DFF0A0,a6
.CheckData4Size	= *-.CheckData4


******************
* OLD DONES


*		rts

*		move.l	$438(a0),d1
*		cmp.l	#"M.K.",d1
*		beq.s	.Return
*		cmp.l	#"FLT4",d1
*		beq.s	.Return
*		cmp.l	#"FLT8",d1
*		beq.s	.Return
*		cmp.l	#"8CHN",d1
*		beq.s	.Return
*		cmp.l	#"UNIC",d1
*		beq.s	.Return
*
*
*		cmpi.l	#$60000026,(a0)
*		bne.s	.NoNormal
*		cmpi.l	#$60000024,4(a0)
*		bne.s	.NoNormal
*		cmpi.l	#$60000022,8(a0)
*		bne.s	.NoNormal
*		cmpi.w	#$6000,12(a0)
*		bne.s	.NoNormal
*
*.SearchJump:	lea	-2(a0),a1
*		move.l	a0,a2
*		lea	$3E8(a2),a2
*.Search1:	suba.l	a3,a3
*		addq.l	#4,a1
*		cmpa.l	a2,a1
*		bgt.s	.NoNormal
*		move.w	(a1),a3
*		adda.l	a1,a3
*		cmpi.w	#$4E75,(a3)
*		beq.s	.Search1
*.ModFound:	moveq	#0,d0
*.Return:	rts
*
*	*-- Turbo's/Infect   Suchroutine nach angeblichem ActivisionPro ---*
*.NoNormal:	cmp.l	#4000,d1	; msste reichen, um tab zu finden
*		blt.s	.Kleiner
*		move.l	#4000,d1
*.KLeiner:	lsr.l	#1,d7			; wegen Wortgre
*		move.l	a0,a1			; countreg
*		move.w	.Searchwords(pc),d2
*	
*.ChkLoop 	cmp.w	(a0),d2				; ersten Tabwert suchen
*		beq.s	.ModFound
*.NextChk	addq.l	#2,a0
*		dbf	d7,.ChkLoop
*		rts
*
*.TabFound:	lea	.Searchwords(pc),a2		; Tabellenwerte zum checken
*		moveq	#.tablen,d6			; parsen, ob die komplette
*		move.l	a0,a3
*.Tabloop	cmpm.w	(a3)+,(a2)+			; tab da ist
*		bne.s	.NextChk
*		dbf	d6,.Tabloop
*		bra.s	.ModFound
*
*.Searchwords	dc.w	$069F,$0640,$05E1,$0592,$0543,$04F4,$04A5,$0465
*		dc.w	$0426,$03EE,$03B7,$037F
*.TabLen		EQU (*-.Searchwords)/2-1			;zu faul zum zhlen :-)
*	
*

*----------------------------------------------------------------------------*
AMComposer_Check:
		*movea.l	$24(a5),a0
		*moveq	#-1,d0
		cmpi.l	#$414D4320,(a0)
		bne.s	.lbC000140
		cmpi.l	#$56312E32,4(a0)
		bne.s	.lbC000140
		cmpi.l	#$20524550,8(a0)
		bne.s	.lbC000140
		cmpi.l	#$4C415921,12(a0)
		bne.s	.lbC000140
		moveq	#0,d0
.lbC000140:	rts

*----------------------------------------------------------------------------*
ADPCM_Check	move.l	(a0),d0
		sub.l	#`ADPC`,d0		;sollte reichen, sonst
		rts				;noch cmp.w #`M2` und #`M3`

*---------------------------------------------------------------------------*
AIFF_Check:	cmp.l	#"FORM",(a0)
		bne.s	.Return
		cmp.l	#"AIFF",8(a0)
		bne.s	.Return
		moveq	#0,d0
.Return:	rts
*----------------------------------------------------------------------------*
ArtOfNoise_Check:move.l	(a0),d0
		lsr.l	#8,d0
		sub.l	#"AON",d0
		rts

*----------------------------------------------------------------------------*
Artmagic_Check:	cmp.l	#"EXIT",26(a0)
		bne.s	.Done
	*	move.l	dtg_ChkSize(a5),d1
	*	add.l	d1,a0
	*	cmp.l	#"EXIT",-4(a0)
	*	bne.s	.Done
		moveq	#0,d0
.Done:		rts

*----------------------- Testet auf DeltaMusic1.0-Modul ---------------------*
APS_Check:	cmp.l	#"ADRV",(a0)
		bne.s	.Error
		cmp.l	#"PACK",4(a0)
		bne.s	.Error
		moveq	#0,d0
.Error:		rts



*----------------------------------------------------------------------------*
BennDaglish_Check:
		cmpi.w	#$6000,(a0)+
		bne.s	.Return
		cmpi.w	#$6000,2(a0)
		bne.s	.Return
		cmpi.w	#$6000,8(a0)
		bne.s	.Return
		adda.w	(a0),a0
		cmpi.l	#$3F006100,(a0)
		bne.s	.Return
		cmpi.w	#$3D7C,6(a0)
		bne.s	.Return
		cmpi.w	#$41FA,12(a0)
		bne.s	.Return
		moveq	#0,d0
.Return:	rts


*----------------------------------------------------------------------------*
ChipTracker_Check:
		move.l	$3b8(a0),d0
		sub.l	#`KRIS`,d0
		rts


*-----------------------------------------------------------------------------*
C669_Check:	moveq	#-1,d0
		move.w	(a0),d1
		cmp.w	#"if",d1
		beq.s	.ja
		cmp.w	#"JN",d1
		bne.s	.nein
.ja:		moveq	#0,d0
.Nein:		rts

*----------------------------------------------------------------------------*
DavidHanney_Check:
		*movea.l	$24(a5),a0
		*moveq	#-1,d0
		cmpi.l	#$44534E47,(a0)+
		bne.s	.Return
		cmpi.l	#$53455155,(a0)+
		bne.s	.Return
	*	adda.l	(a0),a0
	move.l	(a0),d1
	btst	#0,d1
	bne.s	.Return
	add.l	d1,a0

		addq.l	#4,a0
		cmpi.l	#$494E464F,(a0)+
		bne.s	.Return
	*	adda.l	(a0),a0
	move.l	(a0),d1
	btst	#0,d1
	bne.s	.Return
	add.l	d1,a0
		addq.l	#4,a0
		move.l	(a0)+,d1
		and.l	#$ffffff00,d1
		cmp.l	#"INS"<<8,d1
		beq.s	.Ja1
		cmpi.l	#$424C4B00,d1
		bne.s	.Return
.Ja1:	*adda.l	(a0),a0
	move.l	(a0),d1
	btst	#0,d1
	bne.s	.Return
	add.l	d1,a0
		addq.l	#4,a0
		move.l	(a0)+,d1
		and.l	#$ffffff00,d1
		cmp.l	#"INS"<<8,d1
		beq.s	.Ja2
		cmpi.l	#$424C4B00,d1
		bne.s	.Return
.Ja2:		moveq	#0,d0
.Return:	rts

*---------------------------------------------------------------------------*
DavidWhittaker_Check:
		move.l	#$2A0A,d1
		cmp.l	d0,d1
		bls.s	.lbC000260
		move.l	d1,d0
.lbC000260:	subi.w	#10,d0
		lsr.w	#1,d0
.lbC00026A:	cmpi.l	#$33FC00FF,(a0)
		beq.s	.lbC000280
		addq.w	#2,a0
		dbra	d0,.lbC00026A
.UnknownFormat:	moveq	#-1,d0
		rts

.lbC000280:	cmpi.l	#$DFF09E,4(a0)
		bne.s	.UnknownFormat
		lea	-4(a0),a1
		move.l	#$DFF096,d1
		moveq	#$11,d0
.lbC000296:	cmp.l	(a1),d1
		beq.s	.ModFound
		subq.l	#2,a1
		dbra	d0,.lbC000296
		lea	12(a0),a1
		moveq	#$11,d0
.lbC0002A6:	cmp.l	(a1),d1
		beq.s	.ModFound
		addq.l	#2,a1
		dbra	d0,.lbC0002A6
		moveq	#EPR_UnknownFormat,d0
		rts
.ModFound:	moveq	#0,d0
		rts

*---------------------- Testet auf DeltaMusic1.0-Modul ----------------------*
DeltaMusic10_Check:
		move.l	(a0),d0
		sub.l	#"ALL ",d0
		rts


*---------------------- Testet auf DeltaMusic2.0-Modul ----------------------*
DeltaMusic20_Check:
		cmp.l	#$bc6,d0
		blo.s	.Error
		move.l	$bc6(a0),d0
		sub.l	#".FNL",d0
.Error		rts



*----------------------------------------------------------------------------*
DigiBooster_Check:
		cmp.l	#"DIGI",(a0)+
		bne.s	.Nein
		cmp.l	#" Boo",(a0)
		bne.s	.Nein
		moveq	#0,d0
.Nein:		rts

*----------------------------------------------------------------------------*
DigiBoosterPro_Check:
		move.l	(a0),d0
		sub.l	#"DBM0",d0
		rts

*----------------------------------------------------------------------------*
DigitalMugician_Check:
		lea	.DMText(pc),a1
.ChkLoop:	cmpm.b	(a0)+,(a1)+
		bne.s	.Chk2
		tst.b	(a1)
		bne.s	.ChkLoop
		bra.s	.Ok
.Chk2:		lea	.DMText2(pc),a1
.ChkLoop2:	cmpm.b	(a0)+,(a1)+
		bne.s	.ChkEnd
		tst.b	(a1)
		bne.s	.ChkLoop2

.Ok		moveq	#0,d0				; Modul erkannt
.ChkEnd		rts

.DMText		dc.b	' MUGICIAN/SOFTEYES 1990 ',0
.DMText2	dc.b	' MUGICIAN2/SOFTEYES 1990',0
		even


*----------------------------------------------------------------------------*
DMF_Check:	move.l	(a0),d0
		sub.l	#"DDMF",d0
		rts


*--------------------------- Testet auf Modul -------------------------------*
DSS_Check:	move.l	(a0),d0
		sub.l	#"MMU2",d0
		rts


*	lea	sng_Len(a0),a1			; Yes, the the next question
*	move.w	(a1)+,d0			; is: is this just a DSS song
*	subq.w	#1,d0				; or really a playable module?
*	moveq	#0,d1				; The only difference between
*	move.l	d1,d2				; a DSS module and a DSS song
*Chk_Loop					; is that the module includes
*	move.b	(a1)+,d1			; the samples at the end of the
*	cmp.b	d1,d2				; songdata. So we calculate the
*	bhi.s	Chk_NotLast			; end of the songdata and check
*	move.b	d1,d2				; if it is not the end of the
*Chk_NotLast					; loaded file! if so the file
*	dbra	d0,Chk_Loop			; includes the samples and is
*	addq.w	#1,d2				; playable.
*	moveq	#10,d0
*	lsl.l	d0,d2				; size * 1024 (blocksize)
*	add.l	#sng_Data,d2			; first sample
*
*					;Added by Buggs
*	sub.l	dtg_ChkSize(a5),d2	;Get Filesize
*	bge.s	Chkfail			;Error, Songsize >= loaded Filesize !
*
*;	sub.l	dtg_ChkSize(a5),d2		; test size of file
*
*;	cmpi.l	#-64,d2				; - 64 Bytes
*;	blt.s	ChkFail				; too small
*;	cmpi.l	#+64,d2				; + 64 Bytes
*;	bgt.s	ChkFail				; too big
*
*	moveq	#0,d0				; Modul erkannt
*	bra.s	ChkEnd
*ChkFail
*	moveq	#-1,d0				; Modul nicht erkannt
*ChkEnd
*	rts


*---------------------------------------------------------------------------*
EMS_Check:	*move.l	dtg_ChkData(a5),a0
		move.w	4(a0),d2			; #pattern
		beq.s	.ChkFail

		moveq	#127,d3
		lea	6(a0),a1
.loop:		cmp.b	(a1)+,d2
		blt.s	.ChkFail
		dbf	d3,.loop

		mulu	#1024,d2
		add.l	#$538,d2

		lea	134(a0),a0
		moveq	#14,d0

.ChkLoop:	moveq	#0,d3
		move.w	4(a0),d3
		add.l	d3,d3
		add.l	d3,d2
		lea	12(a0),a0
		dbra	d0,.ChkLoop

	*	sub.l	dtg_ChkSize(a5),d2		; test size of module
		sub.l	d1,d2
		cmpi.l	#-64,d2				; - 64 Bytes
		blt.s	.ChkFail				; too small
		cmpi.l	#+64,d2				; + 64 Bytes
		bgt.s	.ChkFail				; too big
		moveq	#0,d0				; Modul erkannt
		bra.s	.ChkEnd

.ChkFail:	moveq	#-1,d0				; Modul nicht erkannt
.ChkEnd:	rts



*---------------------------------------------------------------------------*
FaceTheMusic_Check:move.l (a0),d0
		lsr.l	#8,d0
		sub.l	#"FTM",d0		;Kennung "FTM",0 da ?
		rts


*---------------------------------------------------------------------------*
FastTrackerII_Check:
		cmp.l	#"Exte",(a0)
		bne.s	.NoFastII
		cmp.l	#" Mod",8(a0)
		bne.s	.NoFastII
		moveq	#0,d0
.NoFastII:	rts


*---------------------------------------------------------------------------*
Fred_Check:	*move.l	dtg_ChkData(a5),a0
		cmp.w	#$4efa,$0(a0)
		bne.s	.ChkEnd
		cmp.w	#$4efa,$4(a0)
		bne.s	.ChkEnd
		cmp.w	#$4efa,$8(a0)
		bne.s	.ChkEnd
		cmp.w	#$4efa,$c(a0)
		bne.s	.ChkEnd

	*----- Test auf Sonic-Arranger -----*
		cmp.w	#$4efa,$10(a0)
		beq.s	.ChkEnd
		moveq	#0,d0
.ChkEnd		rts



*---------------------------------------------------------------------------*
FutureComposer1.3_Check:
		move.l (a0),d0
		sub.l	#"SMOD",d0		;Kennung "FTM",0 da ?
		rts


*---------------------------------------------------------------------------*
FutureComposer1.4_Check:
		move.l	(a0),d0
		sub.l	#"FC14",d0
		rts

*---------------------------------------------------------------------------*
GMOD_Check:	move.l	(a0),d0
		sub.l	#"GMOD",d0
		rts


*-----------------------------------------------------------------------------*
; Check if it's a GlueMaster module (rather bad algo).

Gluemaster_check:

		*-- ordentlicher Songname ? --*
		moveq	#7,d1
		move.l	a0,a1
.NextB:		move.b	(a1)+,d2
		beq.s	.null
		cmp.b	#32,d2
		blt.s	.Return
.null:		dbf	d1,.NextB

		move.l	$10(a0),d1
		and.l	#$ffffff,d1
		cmp.l	#"DRM",d1	; uses drum/noise
		beq.s	.ok

		moveq	#64,d1
		cmp.b	8(a0),d1	; vol A <= 64
		blo.s	.Return
		cmp.b	11(a0),d1	; vol B
		blo.s	.Return
		cmp.b	14(a0),d1	; vol C
		blo.s	.Return
		cmp.b	17(a0),d1	; vol D
		blo.s	.Return
		tst.b	8(a0)		; vol A
		beq.s	.Return
		tst.b	11(a0)		; vol B
		beq.s	.Return
		tst.b	14(a0)		; vol C
		beq.s	.Return
		tst.b	17(a0)		; vol D
		beq.s	.Return
		cmp.b	10(a0),d1	; min vol A
		blo.s	.Return
		cmp.b	13(a0),d1	; min vol B
		blo.s	.Return
		cmp.b	16(a0),d1	; min vol C
		blo.s	.Return
		cmp.b	19(a0),d1	; min vol D
		blo.s	.return

.ok		moveq	#0,d0
.Return:	tst.l	d0
		rts

*-----------------------------------------------------------------------------*
GlueMon_Check:	cmp.l	#$474C5545,(a0)		; "GLUE"
		bne.s	.ChkEnd
		cmp.l	#~$474C5545,4(a0)	; ~"GLUE"
		bne.s	.ChkEnd
		moveq	#0,d0			; module recognised
.ChkEnd		rts




*---------------------------------------------------------------------------*
* Kein COSO-Check (dauert zu lange)
Hippel_Check:	sub.l	a1,a1
		moveq	#0,d4
		moveq	#$60,d0
		move.w	#$48e7,d1
		moveq	#2,d3
		moveq	#0,d5

		cmp.b	(a0),d0				;2 bra.s + movem.l
		bne.s	.HCheck2
		cmp.b	2(a0),d0
		bne.s	.HCheck2

		cmp.w	4(a0),d1
		beq.s	.HippelFound

		cmp.w	$10(a0),d1			;2 bra.s + movem.l
		bne.s	.HCheck2
		cmp.w	$1e(a0),d1
		beq.s	.HippelFound

		
.HCheck2:	cmp.b	(a0),d0
		bne.s	.HCheck3
		cmp.b	2(a0),d0
		bne.s	.HCheck3
		cmp.w	#$41fa,4(a0)
		beq.w	.HippelFound		;Check3 ????

.HCheck3:	moveq	#4,d3
		moveq	#1,d2
		bsr.w	.CheckHSys
		cmp.l	a1,d5				;a1=0
		beq.s	.HCheck4
		cmp.w	(a1),d1
		beq.s	.HippelFound

.HCheck4:	moveq	#3,d2
		bsr.w	.CheckHSys
		cmp.l	a1,d5
		beq.s	.HCheck5			;a1=0
		cmp.w	(a1),d1
		beq.s	.HippelFound

.HCheck5:	moveq	#8,d2
		moveq	#1,d4
		bsr.s	.CheckHSys
		bne.w	.NoHippelFound

.NoHippelFound:	moveq	#1,d0				;kennung No Found
		rts

.HippelFound:	moveq	#0,d0
		rts					;Found		


	;**** Unterprogramm fr Check-Hippel ****
.CheckHSys:	move.l	a0,-(a7)
.CheckHSys2:	cmp.w	#$6000,(a0)+
		bne.s	.CheckNein
		addq.l	#2,a0
		dbf	d2,.CheckHSys2
		move.l	a0,a1
		moveq	#0,d0
.CheckNein	move.l	(a7)+,a0
HReturn		rts



*---------------------------------------------------------------------------*
Hippel7V_Check:	*move.l	dtg_ChkSize(a5),d0
		move.w	#$7F,d1
.lbC0001A0:	cmpi.w	#$41FA,(a0)+
		bne.s	.lbC0001C0
		move.w	(a0),d2
		bmi.s	.lbC0001C0
		btst	#0,d2
		bne.s	.lbC0001C0
		cmpi.w	#$4000,d2
		bcs.s	.lbC0001C0
		cmpi.l	#$54464D58,0(a0,d2.w)
		beq.s	.lbC0001CA
.lbC0001C0:	subq.l	#2,d0
		dbmi	d1,.lbC0001A0
.lbC0001C6:	moveq	#-1,d0
		bra.s	.lbC000200

.lbC0001CA:	adda.w	d2,a0
		lea	$20(a0),a1
		move.w	4(a0),d0
		addq.w	#1,d0
		asl.w	#6,d0
		adda.w	d0,a1
		move.w	6(a0),d0
		addq.w	#1,d0
		asl.w	#6,d0
		adda.w	d0,a1
		moveq	#0,d0
		moveq	#0,d1
		move.w	8(a0),d0
		move.w	12(a0),d1
		addq.w	#1,d0
		mulu.w	d1,d0
		adda.w	d0,a1
		cmpi.b	#$FF,3(a1)
		bne.s	.lbC0001C6
		moveq	#0,d0
.lbC000200:	rts

*---------------------------------------------------------------------------*
HippelCOSO_Check:cmp.l	#"COSO",(a0)
		bne.s	.Check_Return
		cmp.l	#"TFMX",$20(a0)
		bne.s	.Check_Return
		moveq	#0,d0
.Check_Return:	rts

*---------------------------------------------------------------------------*
IFFEMOD_Check:	cmp.l	#"FORM",(a0)
		bne.s	.Fehler
		cmp.l	#"EMOD",8(a0)
		bne.s	.Fehler
		*cmp.l	#"EMIC",12(a0)
		*bne.s	.Fehler
		*cmp.w	#1,20(a0)		;Version of EMIC Chunk
		*bne.s	.Fehler
		*move.l	16(a0),d1
		*addq.l	#8,d1
		*addq.l	#8,d1
		*addq.l	#4,d1
		*add.l	d1,a0
		*cmp.l	#`PATT`,(a0)
		*bne.s	.Fehler
		moveq	#0,d0
.Fehler		rts

*---------------------------------------------------------------------------*
IFF8SVX_Check:	cmp.l	#"FORM",(a0)
		bne.s	.Return
		cmp.l	#"8SVX",8(a0)
		bne.s	.Return
		moveq	#0,d0
.Return:	rts

*---------------------------------------------------------------------------*
IFFSMUS_Check:	cmp.l	#"FORM",(a0)
		bne.s	.Return
		cmp.l	#"SMUS",8(a0)
		bne.s	.Return
		moveq	#0,d0
.Return:	rts

*---------------------------------------------------------------------------*
Impulse_Check:	move.l	(a0),d0
		sub.l	#"IMPM",d0
		rts

*---------------------------------------------------------------------------*
InStereo1.0_Check:cmp.l	#"ISM!",(a0)
		bne.w	.NoInStereo
		cmp.l	#"V1.2",4(a0)
		bne.w	.NoInStereo
		moveq	#0,d0
.NoInStereo:	rts


*---------------------------------------------------------------------------*
InStereo2.0_Check:
		cmp.l	#"IS20",(a0)
		bne.b	.NoInStereo
		cmp.l	#"DF10",4(a0)
		bne.b	.NoInStereo
		cmp.l	#"STBL",8(a0)
		bne.b	.NoInStereo
		moveq	#0,d0
.NoInStereo:	rts


*---------------------------------------------------------------------------*
JamCracker_Check:move.l (a0),d0
		sub.l	#"BeEp",d0		;Kennung "BeEp" da ?
		rts

*---------------------------------------------------------------------------*
*JasonPage_Check:
* Marley-Check
*		moveq	#-1,d0
*		cmpi.w	#2,(a0)
*		beq.s	.lbC00013E
*		cmpi.w	#$8002,(a0)
*		bne.s	.NoJPN
*.lbC00013E:	btst	#0,3(a0)
*		bne.s	.NoJPN
*		move.w	4(a0),d1
*		btst	#0,d1
*		bne.s	.NoJPN
*		tst.w	0(a0,d1.w)
*		bne.s	.NoJPN
*		move.w	$30(a0),d0
*		lea	2(a0),a1
*		moveq	#$16,d1
*.lbC000160:	tst.w	(a1)
*		beq.s	.NoJPN
*		btst	#0,1(a1)
*		bne.s	.NoJPN
*		cmp.w	(a1)+,d0
*		ble.s	.NoJPN
*		dbra	d1,.lbC000160
*		moveq	#0,d0
*.NoJPN:		rts
*

*---------------------------------------------------------------------------*
JasonPageNew_Check:
		move.l	d0,d2
		moveq	#0,d1
		move.l	a0,a3
		add.l	d2,a3

		move.l	a0,a2
		cmpi.w	#2,(A0)
		beq.s	.lbC00013E
		cmpi.w	#$8002,(A0)
		bne.s	.CheckAnother
.lbC00013E:	btst	#0,3(A0)
		bne.s	.CheckAnother
		move.w	4(A0),D1
	cmp.l	d0,d1
	bhi.s	.return

		btst	#0,D1
		bne.s	.CheckAnother
		tst.w	0(A0,D1.W)
		bne.s	.CheckAnother
		move.w	$30(A0),D0
		lea	2(A0),A1
		moveq	#$16,D1
.lbC000160:	tst.w	(A1)
		beq.s	.CheckAnother
		btst	#0,1(A1)
		bne.s	.CheckAnother
		cmp.w	(A1)+,D0
		ble.s	.CheckAnother
		dbra	D1,.lbC000160

		moveq	#0,d0
		move.w	$2E(a0),d0
	btst	#0,d0
	bne.s	.CheckAnother
		add.l	d0,a0
		move.w	(a0),d0
		and.w	#$0f00,d0
		cmp.w	#$0f00,d0
		*bne.b	.NewFormat
		*move.b	#1,Format
		*bra.b	OldFormat
.NewFormat:	*move.b	#2,Format
.OldFormat:	moveq	#0,D0
		rts

.CheckAnother:	moveq	#-1,D0
		move.l	a2,a0

	move.l	$84(a2),d1
	btst	#0,d1
	bne.s	.Return

		add.l	$84(a2),a0
		cmp.l	a3,a0			;Noch im Bereich
		bhi.s	.Return
		cmp.l	a2,a0
		blt.s	.Return


		cmp.l	#$309be,-(a2)
		bne.b	.Return
		cmp.l	#$308be,-(a2)
		bne.b	.Return
		*move.b	#3,Format
		moveq	#0,d0
.Return:	rts



*---------------------------------------------------------------------------*
JasonPageOld_Check:
		cmpi.w	#$2B7C,(A0)
		bne.s	.Return
		cmpi.w	#$2B7C,8(A0)
		bne.s	.Return
		cmpi.w	#$2B7C,$10(A0)
		bne.s	.Return
		cmpi.w	#$2B7C,$18(A0)
		bne.s	.Return
		cmpi.l	#$303C00FF,$20(A0)
		bne.s	.Return
		cmpi.l	#$32004EB9,$24(A0)
		bne.s	.Return
		cmpi.w	#$4E75,$2C(A0)
		bne.s	.Return
		moveq	#0,D0
.Return:	rts


*---------------------------------------------------------------------------*
JesperOlsen_Check:
		cmp.w	#$6000,(a0)
		bne.s	.Return
		cmp.w	#$6000,4(a0)
		bne.s	.Return
		cmp.w	#$6000,8(a0)
		bne.s	.Return
		cmp.w	#$6000,12(a0)
		bne.s	.Return

		moveq	#0,d2
		move.w	2(a0),d2			;Offset negativ ?
		blt.s	.Return
		cmp.l	d0,d2
		bhi.s	.Return
		lea	2(a0,d2.w),a1
		cmp.l	#$2f0841fa,(a1)
		bne.s	.Return

		moveq	#0,d2
		move.w	6(a0),d2			;Offset negativ ?
		blt.s	.Return
		cmp.l	d0,d2
		bhi.s	.Return
		lea	6(a0,d2.w),a1
		cmp.l	#$48e7fffe,(a1)
		bne.s	.Return
		cmp.w	#$7400,4(a1)
		beq.s	.Ok
		cmp.w	#$43fa,4(a1)
		bne.s	.Return

.Ok:		moveq	#0,d0
.Return:	rts

*---------------------------------------------------------------------------*
* stark verkrzt (drfte zum Laden reichen)
JCBroke_Check:	cmp.l	#$800,d1
		blo.s	.Fehler
		move.w	#$800,d1

.NextWord:	cmpi.w	#$48E7,(a0)+
		beq.s	.Weiter1
.NochmalVonVorne:
		subq.w	#4,d1
		ble.l	.Fehler
		bra.s	.NextWord

.Weiter1:	cmpi.l	#$8F90001,2(a0)
		bne.s	.NochmalVonVorne
		cmpi.l	#$BFE001,6(a0)
		bne.s	.NochmalVonVorne
		cmpi.l	#$33FC0780,10(a0)
		bne.s	.NochmalVonVorne
		cmpi.l	#$DFF09A,14(a0)
		bne.s	.NochmalVonVorne
		cmpi.w	#$47FA,$12(a0)
		bne.s	.NochmalVonVorne
		moveq	#0,d0
.Fehler:	rts

*------------------------ Test auf KefrensPlayer ---------------------------*
LaxityPlayer_Check:
		lea	CheckText(pc),a1

		cmp.b	#$ff,$1f(a0)
		bne.s	.Return
		cmp.b	#$ff,$37(a0)
		bne.s	.Return

		*-- Test auf Kefrens 2 --*
		cmp.l	#$00820048,(a0)
		bne.s	.NoMod1
		cmp.l	#$00010008,$30(a0)
		bne.s	.NoMod1
		cmp.l	#$001800ff,$34(a0)
		beq.s	.Found1

		*-- Name gelscht ? --*
.NoMod1:	addq.l	#8,a0
		move.l	a0,a2
.Testzero:	tst.b	(a2)+
		bne.s	.Nein
		dbf	d1,.testZero
		bra.s	.Found1

		*-- Kennung --*
.Nein:		moveq	#15,d1
.Test		cmpm.b	(a0)+,(a1)+
		bne.s	.Return
		dbf	d1,.Test
.Found1		moveq	#0,d0
.Return		rts

CheckText:	dc.b	"YET ANOTHER COOL"
		even

*---------------------------------------------------------------------------*
LME_Check:	move.l	#$4c4d4500,d0
		sub.l	(a0),d0
		rts

*---------------------------------------------------------------------------*
MGrouleff_Check:cmpi.w	#$6000,(a0)
		bne.s	.Error
		cmpi.w	#$6000,4(a0)
		bne.s	.Error
		moveq	#0,d1
		move.w	6(a0),d1
		addq.l	#6,d1
		adda.l	d1,a0
		cmp.w	#$4DFA,(a0)
		bne.s	.Error
		cmp.w	#$42E,4(a0)
		bne.s	.Error
		moveq	#0,d0
.Error:		rts

*---------------------------------------------------------------------------*
MON_Check:	*move.l	DTG_ChkData(a5),a0
		move.l	DTG_ChkSize(a5),d1

		*moveq	#-1,d0			; Modul nicht erkannt (default)

		cmpi.w	#$4efa,$00(a0)
		bne.s	.Unknown
		cmpi.w	#$4efa,$04(a0)
		bne.s	.Unknown
		cmpi.w	#$4efa,$08(a0)
		bne.s	.Unknown
		cmpi.w	#$4efa,$0c(a0)
		beq.s	.Unknown

.Check1:	cmpi.w	#$4BFA,$00(a0)
		bne.s	.Check2
		cmpi.w	#$0280,$04(a0)
		bne.s	.Check2
		cmpi.l	#$000000FF,$06(a0)
		bne.s	.Check2
		cmpi.l	#$5300B02D,$14(a0)
		beq.s	.FindLastSong
.Check2		addq.l	#2,a0
		subq.l	#2,d1
		bpl.s	.Check1
		bra.s	.Unknown

.FindLastSong	move.w	2(a0),d1
		lea	(a0,d1.w),a1
		move.w	$18(a0),d1
		lea	(a1,d1.w),a1
		*moveq	#0,d0
		*move.b	2(a1),d0
		*move.w	d0,MON_MaxSong2

		moveq	#0,d0				; Modul erkannt
.Unknown	rts


*---------------------------------------------------------------------------*
MajorTom_Check:	move.l	(a0),d0
		sub.l	#'ARP.',d0
		rts

*-----------------------------------------------------------------------------*
MarkCooksey_Check:
		cmp.l	#$d040d040,(a0)
		bne.s	.Return
		cmp.w	#$4efb,4(a0)
		move.w	6(a0),d1
		cmp.w	#1000,d1
		bhi.s	.Return
		cmp.w	#$6000,6(a0,d1.w)
		bne.s	.Return
		moveq	#0,d0
.Return:	rts



*---------------------------------------------------------------------------*
MagneticFields_Check:
		cmp.b	#$7F,$F9(A0)
		bne.b	.Return

		move.b	$F8(A0),D1
		move.b	$17B(A0),D2
		cmp.b	D1,D2
		bne.b	.Return
		move.b	$17D(A0),D2
		cmp.b	D1,D2
		bne.b	.Return
		moveq	#0,d0
.Return:	rts

*---------------------------------------------------------------------------*
MarkII_Check:	move.l	#".ZAD",d1
		move.l	#"S89.",d2

		cmp.l	$348(a0),d1		; MII.Subway
		bne.s	.Check2
		cmp.l	$34C(a0),d2
		beq.s	.Found

.Check2:	cmp.l	$2a0(a0),d1		; MII.Acrush
		bne.s	.Check3
		cmp.l	$2a4(a0),d2
		beq.s	.Found

.Check3:	cmp.l	$33c(a0),d1		; MII.Surpreme
		bne.s	.ChkEnd
		cmp.l	$340(a0),d2
		bne.s	.ChkEnd

.Found:		moveq	#0,d0				; Modul erkannt
.ChkEnd		rts

*---------------------------------------------------------------------------*
MarkIIOld_Check:

	*------- globaler Test ------*
		*moveq	#EPR_UnknownFormat,d0
		cmpi.l	#$48E700F0,(a0)
		bne.l	.Return
		cmpi.l	#$4CD80600,8(a0)
		bne.l	.Return
		move.w	#$120,d6
		movea.l	a0,a1
.Findkennung:	cmpi.l	#$700033FC,(a1)
		bne.s	.nextword
		cmpi.l	#$F00DF,4(a1)
		bne.s	.nextword
		cmpi.l	#$F09641FA,8(a1)
		beq.s	.found
.Nextword:	addq.w	#2,a1
		dbra	d6,.findkennung
.return:	rts
.found:		moveq	#0,d0
		rts



*---------------------------------------------------------------------------*
MaxTrax_Check:	move.l	(a0),d0
		sub.l	#"MXTX",d0
		rts

*---------------------------------------------------------------------------*
MCMD_Check:	move.l	(a0),d0
		sub.l	#"MCMD",d0
		rts

*---------------------------------------------------------------------------*
OctaMED_Check:
MED_Check:	move.l	(a0),d1
		lsr.l	#8,d1
		cmp.l	#"MMD",d1
		beq.s	.Found
		cmp.l	#"MED",d1
		bne.s	.Error
.Found:		moveq	#0,d0
.Error:		rts

*---------------------------------------------------------------------------*
MPEG_Check:	move.l	(a0),d1
		AND.L	#$FFE00000,D1		;sync
		CMPI.L	#$FFE00000,D1
		bne.s	.rts
		move.l	(a0),d1
		ANDI.L	#$60000,D1
		beq.s	.rts
		move.l	(a0),d1
		AND.L	#$F000,D1
		CMPI.L	#$F000,D1
		BEQ.s	.rts
		tst.l	d1
		BEQ.s	.rts

;		cmp.l	#$FFFBB200,d1
;		beq.s	.Ja
;		cmp.l	#$FFFB8044,d1		;MPEG3
;		beq.s	.Ja
;		lsr.l	#8,d1
;		lsr.l	#8,d1
;		cmp.w	#$FFFD,d1		;MPEG1
;		bne.s	.Rts

.ja:		moveq	#0,d0
.rts:		rts

*---------------------------------------------------------------------------*
*!!!!!!!!!!!!!!!!!!!! Auf *.SDATA achten !!
* a1=Name des Files
MusicMaker4_Check:
MusicMaker8_Check:
		cmp.w	#`SE`,(A0)	;Kennung => LAME ,was ,wenn
					;ein Soundtrackersong "SEGEL"
					;heisst ??
		bne	.Return
		cmp.b	#$ff,$16(a0)	;MM 8 - Song ?
		beq	.Return

		moveq	#0,d0
.Return:	rts

**---------------------------------------------------------------------------*
*MTH_Check:	cmp.l	d0,d1			; nur vollstndiger Check
*		bne.s	.Ret
*
*		cmp.w	#$6000,(a0)+
*		bne.s	.Ret
*		cmp.w	#$6000,2(a0)
*		bne.s	.Ret
*
*		moveq	#0,d1
*		add.w	(a0),d1
*		add.l	d1,a0
*		cmp.l	#$3f006100,(a0)
*		bne.s	.Ret
*		cmp.w	#$3d7c,6(a0)
*		bne.s	.Ret
*		cmp.w	#$41Fa,12(a0)
*		bne.s	.Ret
*		moveq	#0,d0
*.Ret		rts
*

*---------------------------------------------------------------------------*
MusicAssembler_Check:
		cmpi.w	#$6000,(a0)			; bra - Instruction
		bne.s	.ChkEnd
		cmpi.w	#$6000,$4(a0)			; bra - Instruction
		bne.s	.ChkEnd
		cmpi.w	#$6000,$8(a0)			; bra - Instruction
		bne.s	.ChkEnd
		cmpi.w	#$48e7,$c(a0)			; movem - Instruction
		bne.s	.ChkEnd
		moveq	#0,d0				; Modul erkannt
.ChkEnd		rts


*---------------------------------------------------------------------------*
Musicline_Check:
		cmpi.l	#"MLED",(a0)			; bra - Instruction
		bne.s	.ChkEnd
		cmpi.l	#"MODL",4(a0)			; bra - Instruction
		bne.s	.ChkEnd
		moveq	#0,d0				; Modul erkannt
.ChkEnd		rts


*---------------------------------------------------------------------------*
Oktalyzer_Check:cmp.l	#"OKTA",(a0)+
		bne.s	.Err
		cmp.l	#"SONG",(a0)+
		bne.s	.Err
		moveq	#0,d0
.Err		rts


*---------------------------------------------------------------------------*
PlayAY_Check:	move.l	(a0),d0
		sub.l	#"ZXAY",d0
		rts

*---------------------------------------------------------------------------*
PlaySID_Check:	move.l	(a0),d0
		sub.l	#"PSID",d0
		rts

*---------------------------------------------------------------------------*
Polytracker_Check:
		move.l	$2c(a0),d0
		sub.l	#"PTMF",d0
		rts

*---------------------------------------------------------------------------*
ProfiteamSoundfactory_Check:

		cmp.l	d0,d1			; nur vollstndiger Check
		bne.s	.PSF_Return

		*cmp.l	#"Spik",$26(a0)
		*beq.s	.PSF_Return
		cmp.l	#$3f3,(a0)
		beq.s	.PSF_Return


		moveq	#$45,d4
		lsl.w	#2,d4
		*moveq	#-1,d0
		*move.l	DTG_ChkData(a5),a0
		cmp.l	(a0),d0
		ble.s	.PSF_Return
		move.w	(a0,d4.w),d1
		rol.w	#4,d1
		andi.w	#15,d1
		subq.b	#8,d1
		bne.s	.PSF_Return
		lea	$14(a0),a1
		moveq	#$3f,d1
.PSF_1:		cmp.l	(a1)+,d4
		beq.s	.PSF_2
		dbra	d1,.PSF_1
.PSF_2:		lea	$14(a0),a1
		moveq	#0,d1
		moveq	#15,d2
		moveq	#0,d3
.PSF_3:		tst.b	-(a1)
		beq.s	.PSF_4
		bset	d2,d1
		addq.w	#1,d3
.PSF_4:		dbra	d2,.PSF_3
		tst.w	d3
		beq.s	.PSF_Return
		*move.w	d3,lbw000196
		*subq.w	#1,d3
		*move.w	d3,lbw000324
		*move.w	d1,lbw000326
		*move.l	(a0),lbl000184
		moveq	#0,d0
.PSF_Return:	rts


*--------------------------- OLD-Promizer Check ----------------------------*
Promizer01_Check:
		*move.l	DTG_ChkData(a5),a0	; ptr to module
		move.l	a0,a3
		add.l	d1,a3
		move.l	d1,-(sp)

		*add.l	DTG_ChkSize(a5),a3
		moveq	#0,d2
		move.w	#762,d2
		moveq	#-1,d0			; Modul nicht erkannt (default)
		move.l	(a0,d2.w),d3		; get patternlenght
		beq.s	.ChkEnd
		addi.l	d2,d3			; add pattern offset
		moveq	#30,d2			; #instr
.ChkSamp:	cmp.l	a3,a0
		bhi.s	.ChkEnd
		moveq	#0,d1
		move.w	(a0),d1			; samplelength in words
		add.l	d1,d1			; samplelength in bytes
		add.l	d1,d3			; add length of sample
		addq.l	#8,a0			; next sample info
		dbf	d2,.ChkSamp

;		sub.l	DTG_ChkSize(a5),d3
		sub.l	(sp),d3			; test size of module

		cmpi.l	#-64,d3			; - 64 Bytes
		blt.s	.ChkEnd			; too small
		cmpi.l	#+64,d3			; + 64 Bytes
		bgt.s	.ChkEnd			; too big
		moveq	#0,d0			; Modul erkannt
.ChkEnd:	move.l	(sp)+,d1
		rts

*---------------------------------------------------------------------------*
Promizer1x_Check:cmp.b	#$60,(a0)
		bne.s	.Error
		cmp.w	#$6000,6(a0)
		bne.s	.Error
		cmp.w	#$6000,10(a0)
		bne.s	.Error
		moveq	#0,d0
.Error:		rts

*---------------------------------------------------------------------------*
Promizer40_Check:move.l	(a0),d0
		sub.l	#"PM40",d0
		rts

*---------------------------------------------------------------------------*
Protracker4_Check:
		cmp.l	#`FORM`,(a0)
		bne	.return
		cmp.l	#`MODL`,8(a0)
		bne	.return
		moveq	#0,d0
.return		rts

*---------------------------------------------------------------------------*
PSA_Check:	cmp.l	#"PSA"<<8,(a0)
		bne.s	.return
		moveq	#0,d0
.Return		rts

*---------------------------------------------------------------------------*
PS3M_Check:	cmp.l	#`SCRM`,44(a0)
		beq	.found

		move.l	(a0),d0
		lsr.l	#8,d0
		cmp.l	#`MTM`,d0
		beq	.found

		move.l	1080(a0),d0
		cmp.l	#`OCTA`,d0
		beq	.found

		cmp.l	#`FLT8`,d0
		beq	.found

	;	cmp.l	#`M.K.`,d0
	;	beq	.found
	;	cmp.l	#`M!K!`,d0
	;	beq	.found

		move.l	d0,d1
	and.l	#$ffffff,d1
	cmp.l	#`CHN`,d1
	beq.b	.found

	and.l	#$ffff,d1
	cmp.l	#`CH`,d1
	beq.b	.found

	move.l	d0,d1
	and.l	#$ffffff00,d1
	cmp.l	#`TDZ<<8`,d1
	beq.b	.found

	moveq	#-1,d0
	rts
.found	moveq	#0,d0
	rts


*---------------------------------------------------------------------------*
PumaTracker10_Check:
		*move.l	DTG_Chksize(a5),d1
		cmp.l	#$3f3,(a0)
		beq.s	.Return

		move.l	#`patt`,d2
.SuchLoop:	cmp.l	(a0),d2
		beq.s	.foundpatt
.NextPatt:	lea	2(a0),a0
		subq.l	#2,d1
		bpl.s	.suchloop
.Return:	rts

.FoundPatt:	cmp.l	#`inst`,4(a0)
		bne.s	.nextpatt
		moveq	#0,d0
		rts

*---------------------------------------------------------------------------*
RobHubbard_Check:move.w	#$6000,d1
		cmp.w	(a0),d1
		bne.s	.Return
		cmp.w	4(a0),d1
		bne.s	.Return
		cmp.w	8(a0),d1
		bne.s	.Return
		cmp.w	12(a0),d1
		bne.s	.Return
		cmp.w	#$41fa,16(a0)
		beq.s	.OkFound
		cmp.w	16(a0),d1
		bne.s	.Return
		cmp.w	#$41fa,20(a0)
		bne.s	.Return
.OkFound:	moveq	#0,d0
.Return:	rts					;Found		


*---------------------------------------------------------------------------*
RobHubbard2_Check:				* d0=Memsize
		move.l	d0,d7
		sub.w	$10(a0),d7
		subq.l	#2,d7
		bne.s	.Return
		move.w	(a0),d5
		lea	0(a0,d5.w),a0
		tst.w	(a0)
		bmi.s	.Return
		moveq	#0,d5
		moveq	#0,d1
		move.w	2(a0),d1
		move.w	12(a0),d2
		move.w	6(a0),d3
		moveq	#$10,d4
.Next:		move.w	0(a0,d4.w),d5
		cmp.w	d1,d5
		bgt.s	.Return
		cmp.w	d2,d5
		blt.s	.Return
		addq.w	#2,d4
		cmp.w	d4,d3
		blt.s	.Next
		moveq	#0,d0
.Return:	rts




*---------------------------------------------------------------------------*
RonKlaren_Check:cmp.l	#$70ff4e75,$20(a0)		;moveq #-1,d0/rts
		bne.s	.Return
		lea	$28(a0),a0
		lea	.RK_ChkData(pc),a1
.NextB:		move.b	(a1)+,d0
		beq.s	.Ok
		cmp.b	(a0)+,d0
		beq.s	.NextB
		bra.s	.Return
.Ok:		moveq	#0,d0				;kennung No Found
.Return:	rts
.RK_ChkData:	dc.b	"RON_KLAREN_SOUNDMODULE!",0
		even

*-----------------------------------------------------------------------------*
ScottJohnston_Check:
		cmp.l	#"Scot",(a0)
		bne.s	.Return
		cmp.l	#"t Jo",4(a0)
		bne.s	.Return
		cmp.l	#"hnst",8(a0)
		bne.s	.Return
		cmp.l	#"on 1",12(a0)
		bne.s	.Return
		moveq	#0,d0
.Return:	rts


*---------------------------------------------------------------------------*
SeanConnolly_Check:
		*move.l	$24(a5),a0
		*moveq	#-1,d0
		cmpi.w	#$6000,(a0)+
		bne.s	.Return
		cmpi.w	#$6000,2(a0)
		bne.s	.Return
		cmpi.w	#$6000,6(a0)
		bne.s	.Return
		cmpi.w	#$6000,10(a0)
		bne.s	.Return
		adda.w	(a0),a0
		cmpi.w	#$48E7,(a0)
		bne.s	.Return
		cmp.w	#$3f00,4(a0)
		bne.s	.Return
		moveq	#0,d0
.Return:	rts


*---------------------------------------------------------------------------*
SeanConran_Check:
		*movea.l	DTG_ChkData(a5),a0
		*moveq	#-1,d0
		move.l	a0,a3
		cmp.w	#$300,d1
		blo.w	.Return

		lea	$100(a0),a0
		move.w	#$100,d1
.lbC000118:	tst.w	(a0)+
		beq.s	.lbC000124
		dbra	d1,.lbC000118
		bra.l	.Return

.lbC000124:	movea.l	a0,a2
		moveq	#14,d2
		lea	.lbW0001BC(pc),a1
.lbC00012C:	cmpm.w	(a2)+,(a1)+
		bne.l	.Return
		dbra	d2,.lbC00012C

		*movea.l DTG_ChkData(a5),a0
		move.l	a3,a0
		lea	$100(a0),a0
		move.w	#$100,d0
.lbC000142:	cmpi.w	#$45FA,(a0)+
		beq.s	.lbC000150
		dbra	d0,.lbC000142
		bra.l	.Return

.lbC000150:	cmpi.w	#$7200,2(a0)
		bne.s	.lbC000142
		move.w	#$100,d0
.lbC00015C:	cmpi.w	#$43FA,(a0)
		beq.s	.lbC000172
		cmpi.w	#$43EA,(a0)
		beq.s	.lbC000172
		addq.l	#2,a0
		dbra	d0,.lbC00015C
		bra.l	.Return

.lbC000172:	move.w	#$100,d0
.lbC000176:	cmpi.b	#$7E,(a0)+
		beq.s	.lbC000186
		addq.l	#1,a0
		dbra	d0,.lbC000176
		bra.l	.Return

.lbC000186:	addq.l	#1,a0
		cmpi.l	#$67D47C00,(a0)
		bne.s	.lbC000176
		cmpi.l	#$7A80780F,4(a0)
		bne.s	.lbC000176
		cmpi.l	#$7608740C,8(a0)
		bne.s	.lbC000176
		cmpi.l	#$700047F9,12(a0)
		bne.s	.lbC000176
		cmpi.l	#$DFF096,$10(a0)
		bne.s	.lbC000176
		moveq	#0,d0
.Return:	rts

.lbW0001BC:	dc.w	1,3,4,5,6,8,10,13,$10,$14,$1A,$20,$29,$33,$40


*---------------------------------------------------------------------------*
SIDMon10_Check:	move.l	a0,a2
		*move.l	DTG_ChkData(a5),a0
		*move.l	DTG_ChkSize(a5),d1
		sub.l	#44,d1

		lea	42(a0),a0
.NextTest:	subq.l	#2,d1
		blo.s	.TestMode2
		addq.l	#2,a0
		cmp.l	#" SID",(a0)
		bne.s	.NextTest
		move.l	a0,a2
		moveq	#(TestStringSize/2)-1,d2
		lea	TestString(pc),a1
.TestIt:	cmpm.w	(a2)+,(a1)+
		bne.s	.NextTest
		dbf	d2,.TestIt
		bra.s	.Found

.TestMode2:	*move.l	DTG_ChkData(a5),a0
		move.l	a2,a0


		move.w	#100,d1
.Suche:		subq.w	#2,d1
		blo.s	.End
		cmp.w	#$41fa,(a0)+
		bne.s	.Suche
		move.l	a0,a2
		move.w	(a2)+,d2
		cmp.l	#$d1e8ffd4,(a2)+
		bne.s	.Suche
		cmp.w	#$43fa,(a2)
		bne.s	.Suche
		addq.l	#4,a2
		cmp.w	#$2288,(a2)
		bne.s	.Suche
		lea	(a0,d2.w),a0
.Found:		*move.l	a0,SID_Data2
		moveq	#0,d0
.End:		rts

TestString:	dc.b	' SID-MON BY R.v.VLIET  (c) 1988 ',0,0
TestStringSize	= *-TestString


*---------------------------------------------------------------------------*
SIDMon20_Check:	lea	58(a0),a0
		lea	.ChkText(pc),a1
		moveq	#.chklen,d1
.Loop:		cmpm.b	(a0)+,(a1)+
		bne.s	.fail
		dbf	d1,.loop
		moveq	#0,d0
.fail		rts

.ChkText:	dc.b	'SIDMON II - THE MIDI VERSION'
.chklen		= *-.chktext-1



*---------------------------------------------------------------------------*
Scumm_Check:	cmpi.w	#$6000,4(a0)
		bne.s	.NoBra
		move.w	6(a0),d1
		lea	2(a0,d1.w),a0
.NoBra:		cmpi.l	#$48E77FFE,4(a0)
		bne.s	.Return
		cmpi.l	#$244B2A4B,8(a0)
		beq.s	.Found
		cmpi.l	#$8800004,8(a0)
		bne.s	.Return
.Found:		moveq	#0,d0
.Return:	rts


*---------------------------------------------------------------------------*
SonicArranger_Check:
		*move.l	DTG_ChkData(a5),a0
		*lea	SA_LModKennung(pc),a1

	*------------- SonicArranger-Song ohne PlayRoutine -------------*
		*moveq	#-1,d0
		moveq	#0,d2
		cmp.l	#"SOAR",(a0)
		bne.w	.SA_Module
		cmp.l	#"V1.0",4(a0)
		beq.w	.Found

	*------------- SonicArranger-Module ohne PlayRoutine ------------*
.SA_Module:	moveq	#1,d2
		tst.w	(a0)
		bne.w	.SA_WithPlay
		tst.w	4(a0)
		bne.w	.SA_WithPlay
		tst.b	8(a0)
		bne.w	.SA_WithPlay
		tst.b	12(a0)
		bne.w	.SA_WithPlay
		tst.b	16(a0)
		bne.w	.SA_WithPlay
		tst.b	20(a0)
		bne.s	.SA_WithPlay

		moveq	#1,d0
		move.l	(a0),d1			;OverTable in Ordnung ???
		beq.s	.SA_WithPlay
		move.l	d1,d4
		and.b	#$f8,d4
		cmp.l	d1,d4
		bne.s	.SA_WithPlay

		move.l	4(a0),d1
		beq.s	.SA_WithPlay
		sub.l	d4,d1
		move.l	d1,d3
		and.b	#$c,d3
		cmp.l	d3,d1
		bne.s	.SA_WithPlay
		divu	#12,d1
		cmp.l	#32,d1			;Subsong grer als 32
		bhi.s	.SA_WithPlay

		move.l	4(a0),d1		;OverTable
		beq.s	.SA_WithPlay
		cmp.l	(a0),d1
		blo.s	.SA_WithPlay

		move.l	8(a0),d4		;NotenTable
		beq.s	.SA_WithPlay
		cmp.l	d4,d1
		bhi.s	.SA_WithPlay
		sub.l	d1,d4
		move.l	d4,d3
		and.b	#$f0,d4
		cmp.l	d4,d3
		bne.s	.SA_WithPlay

		move.l	12(a0),d1		;Instrumente
		beq.s	.SA_WithPlay
		cmp.l	8(a0),d1
		blo.s	.SA_WithPlay

		move.l	$10(a0),d4
		beq.s	.SA_WithPlay
		cmp.l	d4,d1
		bhi.s	.SA_WithPlay

		move.l	$14(a0),d1
		beq.s	.SA_WithPlay
		cmp.l	d1,d4
		bhi.s	.SA_WithPlay

		move.l	$18(a0),d4
		beq.s	.SA_WithPlay
		cmp.l	d4,d1
		blo.s	.Found


	*------------- SonicArranger-Module mit PlayRoutine -------------*
.SA_WithPlay:	moveq	#5,d1
.Next_Jump:	cmp.w	#$4efa,(a0)+
		bne.s	.No_Sa
		addq.l	#2,a0
		dbf	d1,.Next_Jump
		moveq	#2,d2
.Found:		*move.w	d2,(a1)
		moveq	#0,d0
.No_Sa:		rts




*---------------------------------------------------------------------------*
SoundControl_Check:
		*move.l	DTG_ChkData(a5),a0
		*move.l	DTG_ChkSize(a5),d0
		*lea	(a0,d0.l),a1			;Max Adr
		move.l	a0,a2

		lea	(a0,d1.l),a1			;Max Adr
		lea	$240(a0),a0
		*moveq	#-1,d0				;Error

		moveq	#0,d4				;SampleAnz



.NextSample:	moveq	#15,d1				;16-1
		bsr.w	.TestString
		bne.s	.Ret
		moveq	#100,d5				;mte reichen
.NextNote:	subq.l	#1,d5
		beq.s	.Ret

		cmp.l	a1,a0				;Size testen
		bhi.s	.Ret

		moveq	#0,d1
		bsr.w	.TestString
		addq.l	#3,a0
		tst.l	d2
		beq.s	.NextNote
		tst.b	d3
		beq.s	.NextNote
		cmp.b	#$ff,(a0)
		bne.s	.NoSc40
		cmp.b	#$ff,1(a0)
		bne.s	.Ret
		addq.l	#4,a0
		bra.s	.zehn
.Nosc40:	cmp.b	#$ff,d3				;kennung Next Sample
		bne.s	.Ret
		cmp.b	#$ff,-3(a0)
		bne.s	.Ret
.Zehn:

		subq.l	#2,a0
		addq.l	#1,d4				;Ein Sample mehr
		tst.w	(a0)				;Letzte Sample ????
		bne.s	.NextSample			;Nein

		moveq	#0,d0				:Module Ok
.Ret:		tst.l	d0
		rts

	*---- Mal schauen ob Ascii-String auf dieser Addi ok ist ----*
.TestString:	moveq	#-1,d2
.NextB:		move.b	(a0)+,d3
		cmp.b	#" ",d3
		blo.s	.TestRet
		cmp.b	#"z",d3
		bhi.s	.TestRet
.TestOk		dbf	d1,.NextB
		moveq	#0,d2
.TestRet:	tst.l	d2
		rts

***********
* Die alte Checkroutine
*
*		lea	(a0,d1.l),a1			;Max Adr
*		lea	$240(a0),a0
*
*		*moveq	#-1,d0				;Error
*
*		moveq	#0,d4				;SampleAnz
*
*
*
*.NextSample:	moveq	#15,d1				;16-1
*		bsr.w	.TestString
*		bne.s	.Ret
*
*		moveq	#100,d5				;mte reichen
*.NextNote:	subq.l	#1,d5
*		beq.s	.Ret
*
*		cmp.l	a1,a0				;Size testen
*		bhi.s	.Ret
*
*		moveq	#0,d1
*		bsr.w	.TestString
*		addq.l	#3,a0
*		tst.l	d2
*		beq.s	.NextNote
*		tst.b	d3
*		beq.s	.NextNote
*		cmp.b	#$ff,d3				;kennung Next Sample
*		bne.s	.Ret
*		cmp.b	#$ff,-3(a0)
*		bne.s	.Ret
*
*
*		subq.l	#2,a0
*		addq.l	#1,d4				;Ein Sample mehr
*		tst.w	(a0)				;Letzte Sample ????
*		bne.s	.NextSample			;Nein
*
*
*		moveq	#0,d0				:Module Ok
*.Ret:		rts
*
*	*---- Mal schauen ob Ascii-String auf dieser Addi ok ist ----*
*.TestString:	moveq	#-1,d2
*.NextB:		move.b	(a0)+,d3
*		cmp.b	#" ",d3
*		blo.s	.TestRet
*		cmp.b	#"z",d3
*		bhi.s	.TestRet
*.TestOk		dbf	d1,.NextB
*		moveq	#0,d2
*.TestRet:	tst.l	d2
*		rts



*---------------------------------------------------------------------------*
SoundFX13_Check:move.l	60(a0),d0
		sub.l	#"SONG",d0
		rts

*---------------------------------------------------------------------------*
SoundFX20_Check:move.l	124(a0),d0
		sub.l	#'SO31',d0
		rts

*---------------------------------------------------------------------------*
SoundMaster_Check:
		cmpi.w	#$6000,$0(a0)			; bra - Instruction
		bne.s	.ChkEnd
		cmpi.w	#$6000,$4(a0)			; bra - Instruction
		bne.s	.ChkEnd
		cmpi.w	#$6000,$8(a0)			; bra - Instruction
		bne.s	.ChkEnd
		cmpi.w	#$4df9,$c(a0)			; movem - Instruction
		bne.s	.ChkEnd
		cmpi.w	#$47fa,$12(a0)
		moveq	#0,d0				; Modul erkannt
.ChkEnd		rts


*---------------------------------------------------------------------------*
SoundMon_Check:	move.l	$1a(a0),d1
		lsr.l	#8,d1
		cmp.l	#"V.2",d1
		beq.s	.OK
		cmp.l	#"BPS",d1
		bne.s	.NoOK
.OK		moveq	#0,d0
.NoOk:		rts

*---------------------------------------------------------------------------*
SoundMon22_Check:
		move.l	$1a(a0),d0
		lsr.l	#8,d0
		sub.l	#"V.3",d0
		rts

*---------------------------------------------------------------------------*
SoundTracker26_Check:
		move.l	$5b8(a0),d0
		and.l	#$ffffff00,d0
		sub.l	#`MTN`*256,d0
		beq.s	.rts
		move.l	$5b8(a0),d0
		sub.l	#`IT10`,d0
.rts:		rts

*---------------------------------------------------------------------------*
SoundTrackerPro_Check:
		moveq	#-1,d0
		cmp.l	#`STP3`,(a0)
		bne.s	.rts
		cmp	#2,4(a0)
		bne.s	.rts
		moveq	#0,d0
.rts:		rts

*---------------------------------------------------------------------------*
Stonetracker_Check:
		move.l	(a0),d0
		and.l	#$ffffff00,d0
		sub.l	#"SPM"<<8,d0
		rts

*---------------------------------------------------------------------------*
SUNTronic_Check:
		*movea.l $24(a5),a0
		*moveq	#-1,d0
		cmpi.l	#$48E7FFFE,(a0)
		bne.s	.lbC000112
		cmpi.w	#$4DFA,4(a0)
		bne.s	.lbC000112
		cmpi.l	#$4A2E0018,8(a0)
		beq.s	.lbC000110
		cmpi.l	#$4A2E0010,8(a0)
		bne.s	.lbC000112
.lbC000110:	moveq	#0,d0
.lbC000112:	rts

*---------------------------------------------------------------------------*
Symphonie_Check:
		move.l	(a0),d0
		sub.l	#"SymM",d0
		rts

*---------------------------------------------------------------------------*
Synth40_Check:	cmp.l	#"Synt",(a0)
		bne.s	.Error
		move.l	4(a0),d0
		lsr.l	#8,d0
		cmp.l	#"h4.",d0
		beq.s	.Ok
		cmp.l	#"h.Pc",4(a0)
		bne.s	.Error


	*----- Reihenweise testen -----*
		moveq	#100,d0
.TestBytes:	cmp.l	#$d1fc0000,(a0)
		bne.s	.Next
		cmp.l	#$00cc22c8,4(a0)
		bne.s	.Next
		cmp.l	#$7200123a,8(a0)
		beq.s	.Found
.Next:		addq.l	#4,a0
		dbf	d0,.TestBytes
		rts

.Found:		moveq	#-1,d0
		subq.l	#4,a0
		cmp.w	#$41fa,(a0)+
		bne.s	.Error
		moveq	#0,d1
		move.w	(a0),d1
		add.l	d1,a0
.Ok:		*lea	SN_Data2(pc),a1
		*move.l	a0,(a1)
		*move.l	a0,d2
		*sub.l	DTG_ChkData(a5),d2		;Lnge der Playroutine
		*move.l	d2,SN_Offs2-SN_Data2(a1)
		moveq	#0,d0
.Error:		rts


*---------------------------------------------------------------------------*
Syntracker_Check:lea	.Chkdata(pc),a1
		moveq	#-1,d0
		moveq	#15,d1
.ChkIt:		cmpm.b	(a1)+,(a0)+
		bne.s	.Return
		dbf	d1,.ChkIt
		moveq	#0,d0
.Return:	rts
.ChkData:	dc.b	"SYNTRACKER-SONG:",0
		even

*---------------------------------------------------------------------------*
TFMX15_Check:	
TFMX7V_Check:
TFMXPro_Check:
		cmp.l	#"TFMX",(a0)
		beq.s	.OK
		cmp.l	#"TFHD",(a0)
		bne.s	.Ret
.OK:		moveq	#0,d0
.Ret:		rts

*---------------------------------------------------------------------------*
TF_Check:	move.w	#$4ef9,d1
		cmp.w	(a0),d1
		bne.s	.tf_check_2
		cmp.w	6(a0),d1
		bne.s	.return_fail
		cmp.w	12(a0),d1
		bne.s	.return_fail
		cmp.w	$12(a0),d1
		bne.s	.return_fail
		cmp.w	$18(a0),d1
		bne.s	.return_fail
		cmp.w	$1e(a0),d1
		bne.s	.return_fail
		move.l	$2c(a0),d1
		sub.l	2(a0),d1
		cmp.w	#$a0,d1
		moveq	#0,d0
.return_fail:	rts
.tf_check_2:	cmpi.w	#$601a,(a0)
		bne.s	.skip
		lea	$1c(a0),a0
.skip:		cmpi.w	#$1010,(a0)
		beq.s	.skip2
		cmpi.w	#$1012,(a0)
		bne.s	.return_fail
.skip2:		addq.l	#2,a0
		move.l	4(a0),d1
		cmp.l	8(a0),d1
		bne.s	.return_fail
		cmp.l	12(a0),d1
		bne.s	.return_fail
		cmp.l	$10(a0),d1
		bne.s	.return_fail
		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
THX_Check:	move.l	(a0),d0
		clr.b	d0
		sub.l	#`THX`<<8,d0
		rts

*-----------------------------------------------------------------------------*

Tiny_C6:	addq.l	#2,a0
		dbra	d7,Tiny_DE
		*movem.l	(sp)+,d1-d7/a0-a6
		moveq	#-1,d0
		rts

TinyWilliams_Check:
Tiny_D4:	*movem.l	d1-d7/a0-a6,-(sp)
		*movea.l	$24(a5),a0
		moveq	#$64,d7
Tiny_DE:	cmpi.w	#$6000,(a0)
		bne.s	Tiny_C6
		cmpi.w	#$86,2(a0)
		beq.s	.Tiny_FC
		cmpi.w	#$76,2(a0)
		beq.s	.Tiny_FC
		cmpi.w	#$9A,2(a0)
		bne.s	Tiny_C6
.Tiny_FC:	cmpi.l	#$48E7C086,$1C(a0)
		beq.s	.Tiny_110
		cmpi.l	#$48E78086,$1A(a0)
		bne.s	Tiny_C6
.Tiny_110:	*lea	Tiny_Merk(pc),a1
		*move.l	a0,(a1)
		move.w	#$500,d1
.Tiny_11A:	cmpi.l	#$4E75B03C,(a0)
		beq.s	.Tiny_13C
		cmpi.l	#$6766B03C,(a0)
		beq.s	.Tiny_13C
		lea	2(a0),a0
		dbra	d1,.Tiny_11A
		*move.w	#1,lbW0001B8
		bra.w	.Tiny_144

.Tiny_13C:	*move.w	4(a0),lbW0001B8
.Tiny_144:	*movem.l	(sp)+,d1-d7/a0-a6
		moveq	#0,d0
		rts

*-------------------- Testet auf The_Musical_Enlightenment-Modul--------------*
TME_Check:	move.l	#6826,d2
		move.w	6788(a0),d3
		mulu.w	#12,d3
		add.l	d3,d2
		move.w	6790(a0),d3
		mulu.w	#6,d3
		add.l	d3,d2

		move.w	#256-1,d1
.Chk_inloop:	add.l	#4,d2
		*cmp.l	dtg_ChkSize(a5),d2
		cmp.l	d0,d2
		bgt.s	.Chk_fail
		tst.b	-4(a0,d2.l)
		bne.s	.Chk_inloop
		dbra	d1,.CHK_inloop

		move.w	#32-1,d1
		lea	68(a0),a0
.Chk_instl:	tst.b	24(a0)
		beq.s	.Chk_nextin
		add.l	4(a0),d2
.Chk_nextin:	lea	128(a0),a0
		dbra	d1,.Chk_instl

		*move.l	dtg_ChkSize(a5),d3		; size of module
		move.l	d0,d3

		move.l	d3,d1
		sub.l	#$40,d3				; - 64 Bytes
		add.l	#$40,d1				; + 64 Bytes
		cmp.l	d3,d2
		blt.s	.Chk_fail			; too small
		cmp.l	d1,d2
		bgt.s	.Chk_fail			; too big

		moveq	#0,d0				; Modul erkannt
		bra.s	.ChkEnd

.Chk_fail:	moveq	#-1,d0				; Modul nicht erkannt
.ChkEnd:	rts

*---------------------------------------------------------------------------*
Tronic_Check:
		movem.l	(a0)+,d1-d4
		add.w	d1,a0
		add.w	d2,a0
		add.w	d3,a0
		add.w	d4,a0
		move.l	a0,d1
		btst	#0,d1
		bne.s	.fail
		add.w	(a0),d1
		btst	#0,d1
		bne.s	.fail
		move.l	d1,a0
		cmp.l	#$5800b0,4(a0)
		bne.s	.fail
		moveq	#0,d0
.Fail:		rts

*---------------------------------------------------------------------------*
VectorDean_Check:
		*lea	VD_FileTwoAddi(pc),a1
		*clr.l	(a1)
		moveq	#0,d2			;Addi
		move.l	a0,a1


.Retry		move.l	(a1,d2.w),d3
		clr.b	d3
		cmpi.l	#$524A5000,d3		;RJP
		beq.s	.RJPFound
		tst.l	d2
		bne.s	.NotFound
		moveq	#4,d2
		bra.s	.Retry

.RJPFound:	move.l	4(a0,d2.w),d3
		cmp.l	#"SMOD",d3
		beq.s	.Found
		cmp.l	#"MODS",d3
		bne.s	.NotFound
.Found:
		*move.l	DTG_CHkData(a5),a0
		addq.l	#2,a0
		*move.l	DTG_ChkSize(a5),d1	;ist drin

		add.l	d2,a0
		lsr.l	#1,d1
		subq.l	#3,d1
		sub.l	d2,d1
		blt.s	.Found2
.TestRJP1:	cmp.l	#"RJP1",(a0)
		beq.s	.YesRJP1
		addq.l	#2,a0
		dbf	d1,.TestRJP1
		bra.w	.Found2

.YesRJP1:	;tst.l	4(a0)
		;bne.s	.Found2
		;moveq	#EPR_ErrorLoadingInstruments,d0
		;cmp.l	#"P1IN",8(a0)
		;beq.s	.NotFound		;falsche Sample (Songloading
		*move.l	a0,(a1)
.Found2:	*move.l	d2,4(a1)
		moveq	#0,d0			:Mod erkannt
.NotFound	rts

*---------------------------------------------------------------------------*
VSS_Check:	addq.l	#1,d0
		and.l	#$fffffffe,d0			;Error removed by Buggs
		add.l	d0,a0
		moveq	#-1,d0
		sub.w	#64,a0
		moveq	#31,D2
.Suchloop:	cmp.l	#`VSS0`,(a0)
		beq	.Found
		addq.l	#2,a0
		dbra	d2,.Suchloop
		rts

.Found:		cmp.l	#$100,4(a0)
		bcc	.rts
		moveq	#0,d0
.rts:		rts


*---------------------------------------------------------------------------*
WAVE_Check:	cmp.l	#"RIFF",(a0)
		bne.s	.Return
		cmp.l	#"WAVE",8(a0)
		bne.s	.Return
		moveq	#0,d0
.Return:	rts

*---------------------------------------------------------------------------*
*WizardOfSound_Check:
*		sub.l	#9000,d1	;jedes WOS1.0 Modul 9k lang
*		bne.s	.Return		;nein->Fehler
*					;einzige Mglichkeit des Tests ist 
*					;meiner Meinung nach Abfrage, ob etwas
*					;auftritt was weder Kommando noch Note
*					;ist
*		move.w	#8000-1,d2
*.loop:		move.b	(a0)+,d1
*		cmp.b	#127,d1			;hchste Notennummer
*		bls.s	.no
*		cmp.b	#229,d1			;kleinste Kommandonummer
*		blo.s	.Return
*.no:		dbf	d2,.loop
*		moveq	#0,d0
*.Return:	rts


*---------------------------------------------------------------------------*
XMOD_Check:	cmp.l	#"XMOD",(a0)
		bne.s	.No
		cmp.w	#$6000,4(a0)
		bne.s	.No
		cmp.w	#$6000,8(a0)
		bne.s	.No
		cmp.w	#$6000,12(a0)
		bne.s	.No
		moveq	#0,d0
.No:		rts









*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*

	*----------------- Informationstexte ---------------------*
MyMenuName:	dc.b	"Playerloader",0
MyCreatorname:	dc.b	"Eagleeye of DEFECT",0
MySpecialInfo:	dc.b	"For intelligent playerloading !",0





	ifeq	executable
		even
	*-----------------------------------------------------*
FindTag:	moveq	#1,d1		;Found
		move.l	#Testname,d0
		rts
StrCMP:		moveq	#0,d0
		rts
StringCopy:	rts

	*-----------------------------------------------------*
PlayerList:	dc.l	.Player2,0,0,.Tags1
.Tags1:		dc.l	DTP_PlayerName,Deltamusic20_Name,0

.Player2:	dc.l	.Player3,0,0,.Tags2
.Tags2:		dc.l	DTP_PlayerName,Deltamusic20_Name,0

.Player3:	dc.l	0,0,0,.Tags3
.Tags3:		dc.l	DTP_PlayerName,DeltaMusic20_Name+1,0

		
	*-----------------------------------------------------*
Testname:	dc.b	"DT.Hallo",0
	even
data:	
		incdir	"Modules:Hippel/"
		incbin	"hp.level4"

		*incdir	"Modules:"
		*incdir	"Modules:__ Eingang/Problem-Modules/"
		*incdir	"Backup:Eingang/MyDF2/MrLamer/"
		*incbin	"intro08_Pumatracker"

		*incbin	"WORLDOFP.S3M_68000_Playerbug"

		*WORLDOFP.S3M_68000_Playerbug  


		*incbin	"MOd.Agnostica"
datasize	= *-data
	endc

