*****************************************************************************
**                                                                         **
** Engine: Patternscroll                                                   **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


*****************************************************************************
**  (C) Henryk "Buggs" Richter ,all copyright notices have to stay intact  **
**                    Last Change: 27 Sept 1994, 17:56                     **
*****************************************************************************
	;
	;
	incdir	include:
	include	exec/exec_lib.i
	include	exec/libraries.i
	include	exec/lists.i
	include	exec/types.i
 	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	intuition/classusr.i
	include	intuition/imageclass.i
	include	intuition/gadgetclass.i
	include	graphics/displayinfo.i
	include	graphics/gfxbase.i
	include	graphics/graphics_lib.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	libraries/reqtools.i
	include	libraries/reqtools_lib.i
	include	libraries/xpk.i
	include	misc/eagleplayerengine.i
	include	misc/buggsmacros.i
	;
	;
	section	0,code
	;
ver		macro
		dc.b	"1.39"
		endm
StructVer	macro
		dc.w	1,39
		endm
date		macro
		dc.b	"20-Apr-97"
		endm
StructDate	macro
		dc.b	20,04
		dc.w	1997
		endm

userprogram = 1
test = 0
debug = 0

Project0Width = 320-6			;Windowbreite, nicht ndern !!
Project0Height = 131
Project0MinHeight = 62
an_zeilen = 13

GD_Size		EQU	0
GD_Pos		EQU	1
GD_BPM		EQU	2
GD_Speed	EQU	3
Project0_CNT	EQU	4

begin
****************** Workbench Startup **********************************
	bra.w	fang
	EUSN_Identifier
	dc.l	0		;eus_next

	ifne	debug
	dc.w	-2
	else
	dc.w	0		;eus_Usernr
	endc
MyEPBase
	dc.l	0		;eus_EPBase , DTBASE,use it,but not change it
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;eus_unused3
	dc.l	Tagliste	;eus_unused4
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_Zipwin!USMB_ChangeConfig!USMB_Newsong!USMB_NewModule!USMB_ChangeInterrupt;eus_msgflags

	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	myinfo
	dc.w	37		;eus_Kickstart
	dc.l	8		;eus_EPVersion
	structver		;eus_version,revision
	dc.l	MyUsername	;eus_username
	dc.w	0		;eus_winx
	dc.w	80		;eus_winy
	dc.w	EUSB_openwin	;window opened
	dc.l	0		;EUS_Special
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	structdate		;EUS_Creatordate
	dc.b	-5		;EUS_Priority
	dc.b	EUTY_Patternscroll
	dc.w	0
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

	dc.b	`$VER: Eagleplayer Patternscroller `
	ver
	dc.b	` (`
	date
	dc.b	`)`,0
	even


Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_PatternScroll
		dc.l	0

Fang
	move.l	4.w,a6

	lea	datas,a5
	move.l	a5,a0
	move.w	#dataslen-1,d0
.clr	move.b	#0,(a0)+
	dbf	d0,.clr

	move.w	lib_version(a6),d0
	cmp	#39,d0
	blo.s	kick2$
	st	Kick30on(A5)
kick2$
	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;Signal allokieren
	tst.l	d0
	blt	NoSignal
	move.l	d0,mysignal(a5)

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)
	move.l	d0,mytask(a5)

	lea	MsgPort1(a5),a4		;MSG Port Struktur initialisieren
	bsr	MakeMsgPort
	tst.l	d0
	blt	NoPort
	move.l	a4,MsgPort(A5)

	lea	int(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,intsave(a5)
	beq	NOINT

	lea	graf(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,grafsave(a5)
	beq	NOGraf

	lea	gad(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,gadsave(a5)
	beq	NoGadTo

	moveq	#0,d7

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse haben mchte
	blt	endme	;Fehler aufgetreten

	bsr	setint
	bsr	HandleActions		;Auf Usereingaben reagieren
	bsr	remint

	tst.l	d7
	blt.s	endme
	bsr	sendlastmessage
endme
	bsr	closewin
nopubscreen
Nogadgets
nowin
	move.l	gadsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(A6)
nogadto
	move.l	grafsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
NoGraf
	move.l	intsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
noint
	move.l	4.w,a6
	lea	msgport1(a5),a2
	move.b	mp_sigbit(a2),d0
	ext.w	d0
	ext.l	d0
	jsr	_LVOfreesignal(a6)
NoPort
Endprog
	move.l	mysignal(a5),d0
	move.l	4.w,a6
	jsr	_LVOfreesignal(a6)
NoSignal
	moveq	#0,d0
	rts
MakeMsgPort
					;Message Port initialisieren
	move.l	4.w,a6
	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;MSG Signal zuweisen lassen
	tst.l	d0
	blt	.nosignal2		;Fehler

	move.b	#nt_msgport,ln_type(a4)
	move.b	#0,ln_pri(a4)
	move.b	#pa_signal,mp_flags(a4)
	move.b	d0,mp_sigbit(a4)

	move.l	mytask(a5),mp_sigtask(a4);mp_SigTask

	lea	mp_msglist(a4),a1
	Newlist	a1			;macro in Lists.i

	moveq	#0,d0
.nosignal2				;Fehler
	rts
********************************************************************
*                  Init & Open Window                              *
********************************************************************
Openwin:
	tst.l	winhandle(A5)
	bne.w	.endme

	clr.l	port(A5)

	move.l	intsave(a5),a6
	bsr	Setupscreen		;Public Screen holen
	bne	.Endme
	bsr	SetUpWin		;Fenster ffnen
	tst.l	d0
	bne	.Endme

	move.l	Winhandle(a5),a0
	move.l	wd_userport(a0),a0	;User Port
	move.l	a0,port(a5)

	move.l	GadSave(a5),a6
	move.l	Winhandle(a5),a0
	suba.l	a1,a1
	jsr	_LVOGT_RefreshWindow(a6)

	move.l	winhandle(a5),a0
	move.w	wd_width(A0),d2
	sub.w	Offx(A5),d2
	move.l	mypubscreen(A5),a1
	move.b	sc_WBorRight(a1),d1
	ext.w	d1
	sub.w	d1,d2
	sub.w	#16,d2
	move.w	d2,Anzeigebreite(A5)

	move.w	wd_height(a0),d1
	move.w	myhoehe1(a5),d3		;Y2
	add.w	#32+5,d3		;oberer Rand + unterer Rand
	move.b	wd_borderbottom(A0),d2
	ext.w	d2
	add.w	d2,d3
	sub.w	d3,d1			;briger Rest
	lsr.w	#3,d1			;durch 8
	move.w	d1,numzeilen(A5)
	st	 refresh(A5)

;	tst.b	Kick30on(a5)
;	beq.s	kick2style$

;	bsr	AllocBitmap

;kick2style$
	lea	my_bitmap(a5),a3
;	move.l	a3,MY_Bitmapadr(A5)

	bsr	makebitmap
	bge	.wei

	bsr	closewin
	
	move.l	4.w,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
;	move.l	mysignal(a5),d5
	move.l	#-1,d5
	move.w	#USclass_DeActivate,d6
	bsr	sendmess
.wei
	bsr	DoFills
	bsr	UpdateList
.endme
	rts
*************** Window & Screen freigeben *************************
Closewin
	bsr	freebitmap

	move.l	winhandle(a5),d0
	beq.s	.noxy 

	move.l	d0,a0

	lea	begin(pc),a1
	move.w	wd_leftedge(a0),eus_winx(a1)
	move.w	wd_topedge(a0),eus_winy(a1)

	move.w	eus_special(a1),d1
	and.w	#$E000,d1
	move.w	wd_width(A0),d0
	or.w	d0,d1

	move.b	wd_borderleft(a0),d0
	ext.w	d0
	sub.w	d0,d1
	move.b	wd_borderright(a0),d0
	ext.w	d0
	sub.w	d0,d1
	move.w	d1,eus_special(a1)

	move.w	wd_height(a0),d0
	move.b	wd_bordertop(a0),d1
	ext.w	d1
	sub.w	d1,d0
	move.b	wd_borderbottom(a0),d1
	ext.w	d1
	sub.w	d1,d0
	move.w	d0,eus_special+2(a1)
.noxy
	bsr	closedownwin
	bra	closedownscreen
********************************************************************
*                  Init Message Struktur                           *
********************************************************************
Sendfirstmessage
	move.l	4.w,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.Error
.ok
	move.l	d0,a0			;Portadresse

	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	#-1,d5
	move.w	#USclass_Newuserprg,d6

	ifne	debug

	lea	Mymessage(a5),a1	;Messageadresse
	moveq	#um_sizeof>>1-1,d0
.clr
	clr.w	(a1)+
	dbf	d0,.clr

	lea	Mymessage(a5),a1	;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2
	move.l	a2,um_result(a1)
	move.w	#-2,UM_UserNr(a1)
	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4.w,a6
	jsr	_LVOputmsg(a6)

	else
	bsr	sendmess
	endc

	move.b	#1,messagesent(a5)

	moveq	#0,d7
	rts
.error
	moveq	#-1,d7
	rts
*******************************************************************************
sendmess:
	lea	Mymessage(a5),a1	;Messageadresse
	moveq	#um_sizeof>>1-1,d0
.clr
	clr.w	(a1)+
	dbf	d0,.clr

	lea	Mymessage(a5),a1	;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)		;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4.w,a6
	jmp	_LVOputmsg(a6)
******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
Sendlastmessage:
	move.l	4.w,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.w	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3

	lea	Mymessage(a5),a1	;Messageadresse
	moveq	#um_sizeof>>1-1,d0
.clr
	clr.w	(a1)+
	dbf	d0,.clr

	lea	Mymessage(a5),a1		;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)	;Lnge
	move.b	#nt_message,ln_type(a1) 	;Typ: Message
	clr.l	ln_pred(A1)
	clr.l	ln_succ(A1)

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)	;Typ der Message

	move.l	d3,mn_replyport(a1)		;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)		;Portadresse fr EaglePlayer
	clr.l	UM_TaskAdr(a1)		;Taskadresse
	clr.l	UM_Signal(a1)		;Signalnummer
	move.w	#Usclass_exit,UM_class(a1)	;Messageinhalt
				;z.B. USClass_Closewin,USclass_Newuserprg

	move.b	#1,messagesent(a5)		;merken,da Nachricht gesendet

	move.l	4.w,a6
	jsr	_LVOputmsg(a6)		;Nachricht losschicken
.wait					;auf Rckmeldung warten
	move.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	move.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
*************************************************************
*     2. Bitmap erzeugen fr direkten Zugriff auf Bild      *
*       (per Blitter wird kopiert,Tiefe = 1)                *
*************************************************************
; ----- neuer Stil, ab Kick 3.0 aufwrts -----
AllocBitmap:
	rts
makebitmap
	move.l	grafsave(a5),a6

	move.w	#1280/8,(a3)				;bm_BytesPerRow
	move.w	numzeilen(a5),d1			;Anzahl der Zeilen
	lsl.w	#3,d1					;mal 8
	move.w	d1,bm_rows(a3)
	move.b	#2,bm_depth(a3)

	move.w	#1280,d0				;Pixel hori
	addq.w	#8,d1
	move.w	d1,d6
	jsr	_LVOallocraster(a6)
	move.l	d0,bm_planes(a3)
	beq.w	.norast2

	move.l	d0,a0			;komplett lschen
	move.w	d6,d0
	mulu	#1280/8/4,d0
	subq.w	#1,d0
.clr1
	clr.l	(a0)+
	dbf	d0,.clr1

	move.w	#1280,d0		;Pixel hori
	move.w	d6,d1			;8 Extra Zeilen
	jsr	_LVOallocraster(a6)
	move.l	d0,bm_planes+4(a3)	;Planeptr[2]
	beq.w	.norast

	move.l	d0,a1			;komplett lschen
	move.w	d6,d1
	mulu	#1280/8/4,d1
	subq.w	#1,d1
.clr2
	clr.l	(a1)+
	dbf	d1,.clr2

	bsr	DrawStriche		;bergabe der Bitmap in a3
	bsr	ClearBitmap		;bergabe der Bitmap in a3

	moveq	#0,d7
	rts
.norast
	move.l	grafsave(a5),a6
	lea	my_bitmap(a5),a1
	move.l	bm_planes(a1),a0	;Planeptr[1]
	clr.l	bm_planes(a1)
	move.w	#1280,d0			;Pixel hori
	move.w	numzeilen(a5),d1		;Anzahl der Zeilen
	lsl.w	#3,d1				;mal 8
	addq.w	#8,d1				;8 Zeilen zur Sicherheit
	jsr	_LVOfreeraster(a6)		
	clr.l	bm_planes(a3)
.norast2
	moveq	#-1,d7
	rts
;----------------------- Senkrechte Striche einzeichnen -----------------------
DrawStriche
	move.l	bm_planes+4(a3),d0		;Planeptr[2]

	tst.b	modeid(a5)
	bne.w	.domode1
	;--------------------- fr Normalmodus -------------------------------

	move.l	bm_planes(a3),a1
	move.l	d0,a0
	move.w	numzeilen(A5),d1
	mulu	#1280/8*8/4,d1
	add.w	#1280/8/4,d1
.clr31
	clr.l	(a0)+
	clr.l	(a1)+
	dbf	d1,.clr31

	move.l	d0,a0				;senkrechte Striche ziehen

	move.w	numzeilen(a5),d1			;Anzahl der Zeilen
	lsl.w	#3,d1					;mal 8
	subq.w	#1,d1
.striche
	move.b	#$80,(a0)
	move.b	#$1,2(a0)

	lea	(A0),a1
	addq.l	#3,a1
	moveq	#15,d2
.voi
	move.b	#1,(a1)
	move.b	#1,3(a1)
	move.b	#1,5(a1)
	move.b	#1,8(a1)
	add.w	#9,a1
	dbf	d2,.voi

	lea	1280/8(a0),a0
	dbf	d1,.striche

	move.l	d0,a0			;Balken in der Mitte setzen
	move.w	numzeilen(a5),d1	;Anzahl der Zeilen
	lsr.w	#1,d1			;durch 2
	mulu	#1280/8*8,d1
	add.l	#1280/8,d1
	add.l	d1,a0

	move.w	#1280/8*8/4-1,d1
	moveq	#-1,d2
.mitte
	move.l	d2,(a0)+
	dbf	d1,.mitte

	move.l	d0,a0
	move.w	#1280/8/4-1,d1
.oben
	move.l	d2,(a0)+
	dbf	d1,.oben

	bra.s	.end
	;-------------------- fr invertierten Modus -----------------
.domode1
	move.l	d0,a0				;senkrechte Striche ziehen

	move.w	numzeilen(a5),d1			;Anzahl der Zeilen
	lsl.w	#3,d1					;mal 8
	subq.w	#1,d1
.striche2
	move.b	#$1,2(a0)

	lea	(A0),a1
	addq.l	#3,a1
	moveq	#15,d2
.voi2
	move.b	#1,8(a1)
	add.w	#9,a1
	dbf	d2,.voi2
	lea	1280/8(a0),a0
	dbf	d1,.striche2

	move.l	d0,a0			;Balken in der Mitte setzen
	move.w	numzeilen(a5),d1	;Anzahl der Zeilen
	lsr.w	#1,d1			;durch 2
	mulu	#1280/8*8,d1
	add.l	d1,a0

	move.l	bm_planes(a3),a1		;Planeptr[2]
	add.l	#1280/8*8,d1			;eine Zeile tiefer
	add.l	d1,a1

	move.w	#1280/8*1/4-1,d1
	moveq	#-1,d2
.mitte2
	move.l	d2,(a0)+
	move.l	d2,(a1)+
	dbf	d1,.mitte2
.end
	rts
;------------------ Bitmap lschen/fr Beschreibung vorbereiten ---------------
ClearBitmap					;bergabe der Bitmap in a3
	tst.b	modeid(a5)
	bne.s	.domode1

	movem.l	d0-a6,-(sp)

	move.l	bm_planes(a3),a1	;Planeptr[2]
	add.l	#1280/8,a1		;1 Zeile frei

	move.w	numzeilen(a5),d7
	mulu	#1280/8*8/4/4,d7
	subq.w	#1,d7
.clr1
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	dbf	d7,.clr1

	movem.l	(sp)+,d0-a6
	rts
.domode1
	movem.l	d0-a6,-(sp)

	move	#1280/8/4-1,d0
	move.l	bm_planes(a3),a0	;Planeptr[1]
	move.l	bm_planes+4(a3),a1	;Planeptr[2]

	move.w	numzeilen(a5),d7
	lsl.w	#3,d7			;*8

	move.l	#$ffffff81,d0
	move.l	#$ffff81ff,d1
	move.l	#$ff81ffff,d2
	move.l	#$81ffffff,d3

	move.l	#$00000040,a6
	move.l	#$00004000,a2
	move.l	#$00400000,a3
	move.l	#$40000000,a4

	moveq	#-1,d5
	moveq	#0,d6
.clr2
	move.l	d0,(a0)+		;Bpl0	<- Zeilennummer
	move.l	a6,(a1)+		;Bpl1

	moveq	#3,d4
.clr21
	move.l	d5,(a0)+
	move.l	d6,(a1)+
	move.l	d5,(a0)+
	move.l	d6,(a1)+

	move.l	d3,(a0)+
	move.l	a4,(a1)+
	move.l	d5,(a0)+
	move.l	d6,(a1)+

	move.l	d2,(a0)+
	move.l	a3,(a1)+
	move.l	d5,(a0)+
	move.l	d6,(a1)+

	move.l	d1,(a0)+
	move.l	a2,(a1)+
	move.l	d5,(a0)+
	move.l	d6,(a1)+
	
	move.l	d0,(a0)+
	move.l	a6,(a1)+
	dbf	d4,.clr21

	add.l	#12,a0
	add.l	#12,a1
	dbf	d7,.clr2

	movem.l	(sp)+,d0-a6
	rts
**************************************************************
*                   Bitplane(s) freigeben                    *
**************************************************************
freebitmap
	move.l	grafsave(a5),a6
	lea	my_bitmap(a5),a1
	move.l	bm_planes(a1),d0	;Planeptr[1]
	beq.s	.no1
	move.l	d0,a0
	move.w	#1280,d0			;Pixel hori
	move.w	numzeilen(a5),d1		;Anzahl der Zeilen
	lsl.w	#3,d1				;mal 8
	addq.w	#8,d1				;8 Zeilen zur Sicherheit
	jsr	_LVOfreeraster(a6)		
	lea	my_bitmap(a5),a1
	clr.l	bm_planes(a1)
.no1
	lea	my_bitmap(a5),a1
	move.l	bm_planes+4(a1),d0	;Planeptr[2]
	beq.s	.no2
	move.l	d0,a0
	move.w	#1280,d0				;Pixel hori
	move.w	numzeilen(a5),d1		;Anzahl der Zeilen
	lsl.w	#3,d1				;mal 8
	addq.w	#8,d1				;8 Zeilen zur Sicherheit
	jsr	_LVOfreeraster(a6)
	lea	my_bitmap(a5),a1
	clr.l	bm_planes+4(a1)
.no2
	rts
*******************************************************************
*      Public Screen ranholen und Visual Info anfordern           *
*******************************************************************
SetupScreen
	move.l	Intsave(a5),a6
	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep
	move.l	d0,a0
	move.l	EPG_Pubscreen(A0),d0
.noep
	move.l	d0,a0
	jsr	_LVOLockPubScreen(a6)
	move.l	d0,MyPubscreen(A5)
	beq.s	.error

	move.l	d0,a0
	move.l	Gadsave(A5),a6
	suba.l	a1,a1
	jsr	_LVOGetVisualInfoA(a6)
	move.l	d0,Vi(A5)
	beq.s	.error 
	moveq	#0,d0
	rts
.error
	moveq	#-1,d0
	rts
*******************************************************************
*      Public Screen ranholen und Visual Info anfordern           *
*******************************************************************
CloseDownScreen:
	move.l	Gadsave(a5),a6
	move.l	Vi(A5),d0
	beq.s	.novi
	move.l	d0,a0
	jsr	_LVOFreeVisualInfo(a6)
	clr.l	Vi(A5)
.novi
	move.l	Intsave(A5),a6
	suba.l	a0,a0
	move.l	Mypubscreen(A5),d0
	beq.s	.nopub
	move.l	d0,a1
	jsr	_LVOUnlockPubScreen(a6)
	clr.l	Mypubscreen(A5)
.nopub
	rts
ComputeFont:
	lea.l	Attr(a5),a0
	move.l	a0,Font(A5)
	move.l	Font(A5),a0
	move.l	#TopazName,ta_Name(a0)
	move.w	#8,FontY(A5)
	move.w	#8,FontX(a5)
	move.w	#8,ta_YSize(a0)
	rts
*************************************************************************
*            Fenster ffnen, Gadgets und Mens init                     *
*************************************************************************
SetUpWin:
	movem.l d1-d4/a0-a4/a6,-(sp)

	move.w	#CHECKIT!MENUTOGGLE,d1
	move.w	begin+eus_special(pc),d0
	and.w	#$8000,d0
	seq	OnAutoSizing(A5)
	bne.s	.clrbit
	move.w	#CHECKED!CHECKIT!MENUTOGGLE,d1
.clrbit
	move.w	d1,newitem

	move.w	#CHECKIT!MENUTOGGLE,d1
	move.w	begin+eus_special(pc),d0
	and.w	#$4000,d0
	sne	OnBlankzero(A5)
	beq.s	.clrbit2
	move.w	#CHECKED!CHECKIT!MENUTOGGLE,d1
.clrbit2
	move.w	d1,newitem2

	move.w	#CHECKIT!MENUTOGGLE,d1
	move.w	begin+eus_special(pc),d0
	and.w	#$2000,d0
	sne	Modeid(A5)
	beq.s	.clrbit3
	move.w	#CHECKED!CHECKIT!MENUTOGGLE,d1
.clrbit3
	move.w	d1,newitem3

	move.l	mypubscreen(a5),a0
	move.l  sc_Font(a0),a1
	move.w  ta_YSize(a1),d3
	addq.w  #1,d3
	move.b  sc_WBorTop(a0),d0
	ext.w   d0
	add.w	d3,d0
	move.w	d0,offy(a5)

	move.b  sc_WBorLeft(a0),d0
	ext.w   d0
	move.w	d0,offx(a5)

	moveq	#0,d3
	moveq	#0,d2

	lea	begin+eus_special(pc),a0
	move.w	(A0),d2				;move.w	begin+eus_special(pc),d2
	move.w	d2,d3
	and.w	#$1fff,d2
	cmp.w	#800,d2
	blt.s	.lo1
.take
	move.w	#Project0Width+8,d2
	add.w	offx(A5),d2
.lo1
	cmp.w	#Project0Width,d2
	blt.s	.take

	and.w	#$E000,d3
	or.w	d2,d3
	move.w	d3,(a0)				;begin+eus_special

	move.w	2(a0),d3			;begin+eus_special+2(pc),d3
	cmp.w	#800,d3
	ble.s	.lo2
.take2
	move.w	#Project0Height+8,d3
	add.w	offy(a5),d3
.lo2
	cmp.w	#Project0MinHeight,d3
	blt.s	.take2
	move.w	d3,2(a0)			;begin+eus_special+2

	bsr	ComputeFont
	move.l	mypubscreen(A5),a0
	move.l	d2,d0
	move.l	d0,d4

	moveq	#0,d2
	add.w	d2,d0
	add.w	OffX(a5),d0
	move.b	sc_WBorRight(a0),d1
	ext.w	d1
	add.w	d1,d0
	cmp.w	sc_Width(a0),d0
	bls.s	.Project0WOk
	move.w	sc_Width(a0),d0
	sub.w	d4,d0
	move.w	d0,d2
.Project0WOk:
	move.l	d3,d0
	move.l	d0,d4

	lea	begin(pc),a1
	move.w	eus_winy(a1),d3
	add.w	d3,d0

	add.w	OffY(A5),d0
	move.b	sc_WBorBottom(a0),d1
	ext.w	d1
	add.w	d1,d0
	cmp.w	sc_Height(a0),d0
	bls.s	Project0HOk
	move.w	sc_Height(a0),d0
	sub.w	d4,d0
	move.w	d0,d3
Project0HOk:
	move.l	Gadsave(A5),a6

	lea.l	Project0GList(a5),a0
	jsr	_LVOCreateContext(a6)
	move.l	d0,a3
	tst.l	d0
	beq	Project0CError

	movem.w d2-d3,-(sp)
	moveq	#0,d3
	lea.l	Project0GTags(pc),a4
Project0GL:
	move.l	4.w,a6

	lea.l	Project0NGads(pc),a0
	move.l	d3,d0
	mulu	#gng_SIZEOF,d0
	add.l	d0,a0
	lea.l	BufNewGad(a5),a1
	moveq	#gng_SIZEOF,d0
	jsr	_LVOCopyMem(a6)
	lea.l	BufNewGad(a5),a0
	move.l	Vi(a5),gng_VisualInfo(a0)
	move.l	Font(a5),gng_TextAttr(a0)
	move.w	gng_LeftEdge(a0),d0
	add.w	OffX(a5),d0
	move.w	d0,gng_LeftEdge(a0)
	move.w	gng_TopEdge(a0),d0
	add.w	OffY(a5),d0
	move.w	d0,gng_TopEdge(a0)
	move.w	gng_Width(a0),d0
	move.w	d0,gng_Width(a0)
	move.w	gng_Height(a0),d0
	move.w	d0,gng_Height(a0)
	move.l	Gadsave(a5),a6
	lea.l	Project0GTypes(pc),a0
	moveq	#0,d0
	move.l	d3,d1
	asl.l	#1,d1
	add.l	d1,a0
	move.w	(a0),d0
	move.l	a3,a0
	lea.l	BufNewGad(a5),a1
	move.l	a4,a2
	jsr	_LVOCreateGadgetA(a6)
	tst.l	d0
	bne.s	Project0COK
	movem.w (sp)+,d2-d3
	bra	Project0GError
Project0COK:
	move.l	d0,a3
	move.l	d3,d0
	asl.l	#2,d0
	lea.l	Project0Gadgets(a5),a0
	add.l	d0,a0
	move.l	a3,(a0)
Project0TL:
	tst.l	(a4)
	beq.s	Project0DN
	addq.w	#8,a4
	bra.s	Project0TL
Project0DN:
	addq.w	#4,a4
	addq.w	#1,d3
	cmp.w	#Project0_CNT,d3
	bmi	Project0GL

	movem.w (sp)+,d2-d3

	move.l	Project0GList(a5),Project0WG+4

	move.l	Gadsave(A5),a6
	lea.l	Project0NewMenu0(pc),a0
	lea.l	MTags0(pc),a1
	jsr	_LVOCreateMenusA(a6)
	move.l	d0,Project0Menus(A5)
	beq	Project0MError

	move.l	d0,a0
	move.l	Vi(A5),a1
	lea.l	mtags0(pc),a2
	jsr	_LVOLayoutMenusA(a6)

	moveq	#0,d2
	moveq	#0,d3
	
	lea	begin(pc),a1
	move.w	eus_winy(a1),d3
	move.w	eus_winx(a1),d2

	move.l	d2,Project0L+4
	move.l	d3,Project0T+4

	move.l	mypubscreen(A5),a0
	move.w	begin+eus_special(pc),d0
	and.w	#$1fff,d0
	move.l	d0,Project0W+4

	move.w	#164+8+9*8/2*28,d0
	add.w	Offx(A5),d0
	move.b	sc_WBorRight(a0),d1
	ext.w	d1
	add.w	d1,d0
	move.l	d0,MaxBreite

	move.w	#Project0Width,d0
	add.w	Offx(A5),d0
	move.b	sc_WBorRight(a0),d1
	ext.w	d1
	add.w	d1,d0
	move.l	d0,MinBreite

	move.w	#Project0MinHeight,d0
	add.w	Offy(A5),d0
	move.l	d0,Minhoehe

	moveq	#0,d0
	move.w	begin+eus_special+2(pc),d0
	move.l	d0,Project0H+4

	lea	begin(pc),a1
	move.w	offy(a5),d0
	move.w	d0,myhoehe1(a5)

	move.l	Intsave(A5),a6
	lea.l	Project0WindowTags(pc),a1
	move.l	mypubscreen(a5),Pubadr-Project0WindowTags(a1)
	suba.l	a0,a0
	jsr	_LVOOpenWindowTagList(a6)
	move.l	d0,Winhandle(a5)
	beq	Project0WError
.open13
	move.l	d0,a0
	move.b	wd_bordertop(a0),d0
	ext.w	d0
	move.b	wd_borderbottom(a0),d1
	ext.w	d1
	add.w	d0,d1
	add.w	#Project0MinHeight,d1
	moveq	#0,d0
	moveq	#0,d2
	moveq	#0,d3
	jsr	_LVOWindowLimits(a6)

	move.l	Winhandle(a5),a0
	move.l	Project0Menus(A5),a1
	jsr	_LVOSetMenuStrip(a6)

	moveq	#0,d0
Project0Done:
	movem.l	(sp)+,d1-d4/a0-a4/a6
	rts
Project0CError:
	moveq	#1,d0
	bra.s	Project0Done
Project0GError:
	moveq	#2,d0
	bra.s	Project0Done
Project0MError:
	moveq	#3,d0
	bra.s	Project0Done
Project0WError:
	moveq	#4,d0
	bra.s	Project0Done
*************************************************************************
*            Fenster schlieen, Gadgets und Mens free                  *
************************************************************************
Closedownwin:
	movem.l d0-d1/a0-a2/a6,-(sp)
	move.l	Intsave(A5),a6
	move.l	Project0Menus(A5),d0
	beq.s	.Project0NMenu
	move.l	Winhandle(a5),d0
	beq.s	.Project0NMenu
	move.l	d0,a0
	jsr	_LVOClearMenuStrip(a6)
	move.l	GadSave(a5),a6
	move.l	Project0Menus(A5),a0
	jsr	_LVOFreeMenus(a6)
	clr.l	Project0Menus(A5)
.Project0NMenu:
	move.l	Intsave(A5),a6
	move.l	Winhandle(a5),d0
	beq.s	.nowin
	move.l	d0,a0
	jsr	_LVOCloseWindow(a6)
	clr.l	Winhandle(a5)
	clr.l	port(a5)
.nowin
	move.l	GadSave(a5),a6
	move.l	Project0GList(A5),d0
	beq.s	.nogad
	move.l	d0,a0
	jsr	_LVOFreeGadgets(a6)
	clr.l	Project0GList(A5)
.nogad
	movem.l (sp)+,d0-d1/a0-a2/a6
	rts
************************ REFRESH ********************************************
DoFills:
	move.l	winhandle(a5),d0
	beq	.gad
	move.l	d0,a1

	move.l	grafsave(a5),a6
	move.l	wd_rport(a1),a4
	move.l	a4,a1
	moveq	#1,d0
	jsr	_LVOsetapen(A6)

	move.l	a4,a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	a4,a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.l	winhandle(A5),a1
	move.w	wd_width(a1),d2
	subq.w	#5,d2
	move.b	wd_borderbottom(A1),d3
	ext.w	d3
	neg.w	d3
	add.w	wd_height(a1),d3
	subq.w	#1,d3

	move.l	a4,a1

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5
	move.b	#1,rp_areaptsz(a1)
	lea	patt2(a5),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	#4,d0			;x1
	move.w	myhoehe1(A5),d1		;y1
	add.w	#29,d1
	jsr	_LVOrectfill(a6)

	move.b	d4,rp_areaptsz(a4)
	move.l	d5,rp_areaptrn(a4)

	move.l	gadsave(A5),a6
	move.l	winhandle(A5),a0
	move.w	wd_width(A0),d2
	moveq	#0,d0
	move.b	WD_Borderright(a0),d0
	sub.w	d0,d2
	move.l	a4,a0

	lea.l   IR(pc),a1
	tst.b	modeid(a5)
	beq.s	.loa
	lea.l   IR2(pc),a1
.loa
	move.l  Vi(a5),4(a1)
	move.w  #2,d0
	add.w   offx(A5),d0
	move.w  #29,d1
	add.w   offy(a5),d1
	sub.w	d0,d2
	sub.w	#3,d2
	move.w	numzeilen(A5),d3
	lsl.w	#3,d3
	addq.w	#7,d3
	jsr     _LVODrawBevelBoxA(a6)

	move.l	winhandle(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOrefreshwindowframe(A6)
.gad
	rts
*************************************************************
*    Gadgetadresse ausrechnen                               *
* Input D0 - Gadgetnummer (0 < X < MAX)                     *
*************************************************************
_Gadr
	lea	Gadgetadrs(a5),a0
	asl.l	#2,d0
	move.l	(a0,d0),a0
	rts
*************************************************************
*       Setzt Interrupt fr Scroller (VBlank)               *
*************************************************************
Setint	
	tst.b	intset(a5)	;Interrupt schon gesetzt ?
	bne.s	.no		;ja->raus

	move.l	4.w,a6
	lea	inter(a5),a1
	lea	INT_Prog(pc),a0
	move.l	a0,IS_code(a1)
	move.b	#nt_interrupt,ln_type(a1)
	move.b	#0,ln_pri(a1)
	moveq	#5,d0
	jsr	_LVOaddintserver(a6)

	st	intset(a5)
.no
	rts
*************************************************************
*         entfernt Scroller-Interrupt                       *
*************************************************************
Remint
	tst.b	intset(a5)
	beq.s	.no

	sf	intset(a5)

	move.l	4.w,a6
	moveq	#5,d0
	lea	inter(a5),a1
	jsr	_LVOremintserver(a6)
.no	rts
*************************************************************
*                  VBLANK Interrupt                         *
*************************************************************
INT_Prog
	movem.l	d0-a6,-(sp)
	lea	Datas,a5
	tst.l	winhandle(A5)
	beq.s	.ret

	move.l	myPatterninfo(a5),d0
	beq.s	.ret
	move.l	d0,a0
	move.w	PI_Pattpos(a0),d0

	cmp.w	posmerk(a5),d0
	beq.s	.ret

	move.b	counter(a5),d0		;1/50 sek warten
	addq.b	#1,d0
	move.b	d0,counter(A5)
	cmp.b	#3,d0
	blo.s	.ret
	clr.b	counter(A5)

	move.l	4.w,a6
	move.l	mytask(A5),a1
	move.l	mysignal(A5),d1
	moveq	#0,d0
	bset	d1,d0
	jsr	_LVOsignal(a6)
.ret
	movem.l	(sp)+,d0-a6
	moveq	#0,d0
RET
	rts
*************************************************************
*     Stellt aktuelle Patternposition dar                   *
*************************************************************
DisplayPatt
	tst.l	winhandle(A5)
	beq.s	ret
	tst.l	my_bitmap+bm_planes(A5)
	beq.s	ret

	move.l	myepbase(pc),a0
	move.l	myplayertaglist(a5),d0
	cmp.l	EPG_playertaglist(A0),d0
	bne.s	RET

	move.l	myPatterninfo(a5),d0
	beq.w	.ret
	move.l	d0,a0

	move.w	pi_numpatts(a0),d0
	cmp.w	oldnumpatts(a5),d0
	beq.s	.oldpa
	bsr	newsetpatt
	move.w	#-1,pattmerk(A5)
.oldpa
	move.w	pi_maxsongpos(a0),d0
	cmp.w	oldsonglen(a5),d0
	beq.s	.oldso
	bsr	NewSetSongpos
	move.w	#-1,pattmerk(A5)
.oldso
	move.w	PI_Songpos(a0),d0

	cmp.w	pattmerk(a5),d0
	beq.s	.ret

	move.w	d0,Pattmerk(A5)		;Neuer "alter" Wert

	bsr	updatesongpos

	lea	PattsString(A5),a2

	move.w	PI_Pattern(a0),d0
	bge.s	.hi1
	move.b	#`-`,(a2)
	move.b	#`-`,1(a2)
	move.b	#`-`,2(a2)
	bra.s	.lo1
.hi1
	and.l	#$ff,d0

	movem.l	d0-a6,-(Sp)
	moveq	#2,d1
	lea	dectable4(pc),a0
.loop
	moveq	#-1,d3
	move.l	-(a0),d2
.loop2
	addq.b	#1,d3
	sub.l	d2,d0
	bcc.s	.loop2
	add.l	d2,d0
	add.b	#`0`,d3
	move.b	d3,(a2)+
	dbf	d1,.loop
	movem.l	(sp)+,d0-a6
.lo1
	move.l	a2,a1
	moveq	#GD_pos,d0
	bsr	ShowText
.ret
	move.l	myPatterninfo(a5),d0
	beq.s	.ret2
	move.l	d0,a0
	move.w	PI_BPM(a0),d0

	cmp.w	BPMmerk(a5),d0
	beq.s	.testSPD

	move.w	d0,BPMmerk(A5)		;Neuer "alter" Wert

	bsr	UpdateBPM
.testSPD
	move.l	myPatterninfo(a5),a0

	move.w	PI_Speed(a0),d0

	cmp.w	Speedmerk(a5),d0
	beq.s	.ret2

	move.w	d0,Speedmerk(A5)	;Neuer "alter" Wert

	bsr	UpdateSpeed
.ret2
;================== Patternscroller =========================
	move.l	myPatterninfo(a5),d0
	beq	ret
	move.l	d0,a0

	tst.l	PI_Convert(A0)
	beq	ret

	move.w	PI_Pattpos(a0),d0
	cmp.w	posmerk(a5),d0
	beq.w	ret
	move.w	d0,posmerk(a5)

	move.l	map1(a5),a4		;Bitplane
	add.l	#1280/8,a4		;1 Zeile frei

	lea	MY_Bitmap(A5),a3
	bsr	ClearBitmap

	move.w	numzeilen(a5),d7	;darzustellende Zeilen
	move.w	d7,d3			;Position +13 Zeilen
	move.w	d7,d1
	lsr.w	#1,d1
	subq.w	#1,d7

	;--------- Test ob Teil am Anfang der Bitmap frei bleibt ---------
	sub.w	d1,d0
	bge.s	.hi
	add.w	d0,d7			;minus Anfang
	add.w	d0,d3

	neg.w	d0
	mulu	#1280/8*8,d0	;8 Zeilen pro Zeichen
	lea	(A4,d0.l),a4

	moveq	#0,d0
.hi
	add.w	d0,d3
	sub.w	PI_Pattlength(a0),d3	;Summe grer Patternlnge
	ble.s	.lower
	sub.w	d3,d7
	bge.s	.clearend
	moveq	#0,d7
.clearend
.lower
	;------- Offset fr Patternstreifen berechnen --------------
	moveq	#0,d5
	move	d0,d5
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d6
	move.l	PI_Modulo(a0),d3

	tst.b	Modeid(a5)
	bne	DoInvertedPatt

	subq.w	#1,d5
	blt.s	.lo
.add
	add.l	d3,d6

	addq.w	#8,d0
	cmp.w	#8*9,d0
	bls.s	.nolod1
	moveq	#0,d0

	addq.w	#8,d1
	cmp.w	#8*9,d1
	bls.s	.nolod1
	moveq	#0,d1

	addq.w	#8,d2
	cmp.w	#8*9,d2
	bls.s	.nolod1
	moveq	#0,d2
.nolod1
	dbf	d5,.add
.lo
	lea	(a0),a2

	move.w	d7,d3
	lea	(A4),a0
.numbers
	clr.w	horipos(A5)
	lea	(A0),a1

	lea	MyTextFont(pc),a3
	add.w	d2,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	MyTextFont(pc),a3
	add.w	d1,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	MyTextFont(pc),a3
	add.w	d0,a3
	bsr	Displaychar

	addq.w	#8,d0
	cmp.w	#8*9,d0
	bls.s	.nolod0
	moveq	#0,d0

	addq.w	#8,d1
	cmp.w	#8*9,d1
	bls.s	.nolod0
	moveq	#0,d1

	addq.w	#8,d2
	cmp.w	#8*9,d2
	bls.s	.nolod0
	moveq	#0,d2
.nolod0
	lea	1280/8*8(a0),a0
	dbf	d3,.numbers
	move.w	#4,horipos2(A5)

	moveq	#0,d5
	move.w	pi_voices(a2),d3
	subq.w	#1,d3

	tst.b	OnBlankzero(a5)
	bne.s	.voicez_2
.voicez
	move.l	pi_stripes(a2,d5.w),d0
	beq.s	.nostripe
	move.l	d0,a3
	movem.l	d3/d5-d7/a4,-(sp)
	bsr	.donote
	bra.s	.skipclear
.nostripe
	movem.l	d3/d5-d7/a4,-(sp)
	bsr	.cleardisp
.skipclear
	movem.l	(sp)+,d3/d5-d7/a4

	add.w	#9,horipos2(A5)
	addq.w	#4,d5
	dbf	d3,.voicez
.endvoic
	bra.w	intowindow
.rts	rts
;------------------ Mainroutine bei Blankzero ------------------------
.voicez_2
	move.l	pi_stripes(a2,d5.w),d0
	beq.s	.nostripe_2
	move.l	d0,a3
	movem.l	d3/d5-d7/a4,-(sp)
	bsr	.donote_BZ
	bra.s	.skipclear_2
.nostripe_2
	movem.l	d3/d5-d7/a4,-(sp)
	bsr	.cleardisp_BZ
.skipclear_2
	movem.l	(sp)+,d3/d5-d7/a4

	add.w	#9,horipos2(A5)
	addq.w	#4,d5
	dbf	d3,.voicez_2
	bra.s	.endvoic

.cleardisp
	move.w	horipos2(a5),horipos(A5)
	lea	(a4),a1

	lea	NoteTable+2(pc),a3
	move.w	(a3)+,d0		;"A"
	move.w	2(a3),d4		;"3"
	swap	d4
	move.w	(a3),d4			;"-"

	lea	MyTextFont(pc),a3
	add.w	d0,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)
	
	swap	d4
	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)
	
	lea	MyTextFont(pc),a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	MyTextFont(pc),a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	MyTextFont(pc),a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	MyTextFont(pc),a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	MyTextFont(pc),a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	1280/8*8(a4),a4
	dbf	d7,.cleardisp
	rts
;------------ leeren Streifen bei Blankzero anzeigen ------------------
.cleardisp_BZ
	move.w	horipos2(a5),horipos(A5)
	lea	(a4),a1

	lea	NoteTable+2(pc),a3
	move.w	(a3)+,d0		;"A"
	move.w	2(a3),d4		;"3"
	swap	d4
	move.w	(a3),d4			;"-"

	lea	MyTextFont(pc),a3
	add.w	d0,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)
	
	swap	d4
	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#2,horipos(A5)

	lea	MyTextFont+["Z"+3-"0"-7]*8(pc),a3
	bsr	Displaychar
	addq.w	#2,horipos(A5)

	lea	MyTextFont+["Z"+5-"0"-7]*8(pc),a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

;	lea	MyTextFont(pc),a3
;	bsr	Displaychar
;	addq.w	#1,horipos(A5)

	lea	1280/8*8(a4),a4
	dbf	d7,.cleardisp_BZ
	rts
.donote
.disploop
	move.w	horipos2(a5),horipos(A5)
	lea	(a4),a1
	lea	(A3,d6.w),a0
	add.l	pi_modulo(a2),d6	;next note
	movem.l	d4-a6,-(sp)
	move.l	Pi_convert(A2),d0
	beq.s	.nocon			;nur noch mal zur Sicherheit
	move.l	d0,a1
	jsr	(A1)		;to Period (D0),Samplenumber (D1),
				;Commando (D2) and Argument (D3)
.nocon
	movem.l	(sp)+,d4-a6
	move.l	a3,-(sp)

	lea	NoteTable(pc),a3
	moveq	#37+24-1,d4
.findnote
	cmp.w	(A3)+,d0
	beq.s	.foundnote
	addq.l	#3*2,a3	
	dbf	d4,.findnote
	addq.l	#2,a3
.foundnote
	move.w	(a3)+,d0		;"A"
	move.w	2(a3),d4		;"3"
	swap	d4
	move.w	(a3),d4			;"-"

	lea	MyTextFont(pc),a3
	add.w	d0,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)
	
	swap	d4
	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)
	
	move.w	d1,d4
	and.w	#$f0,d4
	lsr.w	#1,d4
	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	move.w	d1,d4
	and.w	#$f,d4
	lsl.w	#3,d4
	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	and.w	#$3f,d2
	lsl.w	#3,d2
	lea	MyTextFont(pc),a3
	add.w	d2,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	move.w	d3,d4
	and.w	#$f0,d4
	lsr.w	#1,d4
	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	and.w	#$f,d3
	lsl.w	#3,d3
	lea	MyTextFont(pc),a3
	add.w	d3,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	move.l	(sp)+,a3
	lea	1280/8*8(a4),a4
	dbf	d7,.disploop
	rts
;--------------- Patternstreifen bei Blankzero anzeigen ---------------------
.donote_BZ
.disploop_BZ
	move.w	horipos2(a5),horipos(A5)
	lea	(a4),a1
	lea	(A3,d6.w),a0
	add.l	pi_modulo(a2),d6	;next note
	movem.l	d4-a6,-(sp)
	move.l	Pi_convert(A2),d0
	beq.s	.nocon_BZ			;nur noch mal zur Sicherheit
	move.l	d0,a1
	jsr	(A1)		;to Period (D0),Samplenumber (D1),
				;Commando (D2) and Argument (D3)
.nocon_BZ
	movem.l	(sp)+,d4-a6
	move.l	a3,-(sp)

	lea	NoteTable(pc),a3
	moveq	#37+24-1,d4
.findnote_BZ
	cmp.w	(A3)+,d0
	beq.s	.foundnote_BZ
	addq.l	#3*2,a3	
	dbf	d4,.findnote_BZ
	addq.l	#2,a3
.foundnote_BZ
	move.w	(a3)+,d0		;"A"
	move.w	2(a3),d4		;"3"
	swap	d4
	move.w	(a3),d4			;"-"

;---- Note anzeigen ----
	lea	MyTextFont(pc),a3
	add.w	d0,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)
	
	swap	d4
	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

;---------- Samplenummer anzeigen -------------

	tst.w	d1
	beq.s	.blankSam

	move.w	d1,d4
	and.w	#$f0,d4
	lsr.w	#1,d4
	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	move.w	d1,d4
	and.w	#$f,d4
	lsl.w	#3,d4
	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)
	bra.s	.skipblanksam
.blankSam
	addq.w	#1,horipos(A5)

	lea	MyTextFont+["Z"+3-"0"-7]*8(pc),a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)
.skipblanksam
;---------- Kommando/Argument anzeigen ---------
	move.w	d2,d1
	or.w	d3,d1
	beq.s	.blankcmd

	and.w	#$3f,d2
	lsl.w	#3,d2
	lea	MyTextFont(pc),a3
	add.w	d2,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	move.w	d3,d4
	and.w	#$f0,d4
	lsr.w	#1,d4
	lea	MyTextFont(pc),a3
	add.w	d4,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)

	and.w	#$f,d3
	lsl.w	#3,d3
	lea	MyTextFont(pc),a3
	add.w	d3,a3
	bsr	Displaychar
	addq.w	#1,horipos(A5)
	bra.s	.skipblankcmd
.blankcmd
	addq.w	#1,horipos(a5)
	
	lea	MyTextFont+["Z"+5-"0"-7]*8(pc),a3
	bsr	Displaychar
.skipblankcmd
	move.l	(sp)+,a3
	lea	1280/8*8(a4),a4
	dbf	d7,.disploop_BZ
	rts

;----------------------------------------------------------------------------
;---------------------- Patternscroller Inverted Modus ----------------------
;----------------------------------------------------------------------------
DoInvertedPatt:
	subq.w	#1,d5
	blt.s	.lo
.add
	add.l	d3,d6

	add.w	#16,d0
	cmp.w	#16*9,d0
	bls.s	.nolod1
	moveq	#0,d0

	add.w	#16,d1
	cmp.w	#16*9,d1
	bls.s	.nolod1
	moveq	#0,d1

	add.w	#16,d2
	cmp.w	#16*9,d2
	bls.s	.nolod1
	moveq	#0,d2
.nolod1
	dbf	d5,.add
.lo
	sub.l	map1(a5),a4		;1.BitplaneAdr -> Offset

	move.l	a0,-(sp)

	move.w	d7,d3
	lea	(A4),a0
.numbers
	clr.w	horipos(A5)
	lea	(A0),a1
	lea	(A0),a2
	add.l	map1(a5),a1
	add.l	map2(a5),a2

	lea	MyTextFontINV(pc),a3
	add.w	d2,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV(pc),a3
	add.w	d1,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV(pc),a3
	add.w	d0,a3
	bsr	DisplaycharINV

	add.w	#16,d0
	cmp.w	#16*9,d0
	bls.s	.nolod0
	moveq	#0,d0

	add.w	#16,d1
	cmp.w	#16*9,d1
	bls.s	.nolod0
	moveq	#0,d1

	add.w	#16,d2
	cmp.w	#16*9,d2
	bls.s	.nolod0
	moveq	#0,d2
.nolod0
	lea	1280/8*8(a0),a0
	dbf	d3,.numbers
	move.w	#4,horipos2(A5)

	move.l	(sp)+,a2

	moveq	#0,d5
	move.w	pi_voices(a2),d3
	subq.w	#1,d3

	tst.b	OnBlankzero(a5)
	bne.s	.voicez_2
.voicez
	move.l	pi_stripes(a2,d5.w),d0
	beq.s	.nostripe
	move.l	d0,a3
	movem.l	d3/d5-d7/a4,-(sp)
	bsr	.donote
	bra.s	.skipclear
.nostripe
	movem.l	d3/d5-d7/a4,-(sp)
	bsr	.cleardisp
.skipclear
	movem.l	(sp)+,d3/d5-d7/a4

	add.w	#9,horipos2(A5)
	addq.w	#4,d5
	dbf	d3,.voicez
.endvoic
	bsr	Setbalken
	bra.w	intowindow
.rts	rts
;------------------ Mainroutine bei Blankzero ------------------------
.voicez_2
	move.l	pi_stripes(a2,d5.w),d0
	beq.s	.nostripe_2
	move.l	d0,a3
	movem.l	d3/d5-d7/a4,-(sp)
	bsr	.donote_BZ
	bra.s	.skipclear_2
.nostripe_2
	movem.l	d3/d5-d7/a4,-(sp)
	bsr	.cleardisp_BZ
.skipclear_2
	movem.l	(sp)+,d3/d5-d7/a4

	add.w	#9,horipos2(A5)
	addq.w	#4,d5
	dbf	d3,.voicez_2
	bra.s	.endvoic
.cleardisp
	move.l	a2,-(Sp)
.clearit
	move.w	horipos2(a5),horipos(A5)
	lea	(a4),a1
	lea	(a4),a2
	add.l	map1(a5),a1
	add.l	map2(a5),a2

	lea	NoteTableINV+2(pc),a3
	move.w	(a3)+,d0		;"A"
	move.w	2(a3),d4		;"3"
	swap	d4
	move.w	(a3),d4			;"-"

	lea	MyTextFontINV(pc),a3
	add.w	d0,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)
	
	swap	d4
	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)
	
	lea	MyTextFontINV(pc),a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV(pc),a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV(pc),a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV(pc),a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV(pc),a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	1280/8*8(a4),a4
	dbf	d7,.clearit

	move.l	(sp)+,a2
	rts
;------------ leeren Streifen bei Blankzero anzeigen ------------------
.cleardisp_BZ
	move.l	a2,-(Sp)
.clearit_bz
	move.w	horipos2(a5),horipos(A5)
	lea	(a4),a1
	lea	(a4),a2
	add.l	map1(a5),a1
	add.l	map2(a5),a2

	lea	NoteTableINV+2(pc),a3
	move.w	(a3)+,d0		;"A"
	move.w	2(a3),d4		;"3"
	swap	d4
	move.w	(a3),d4			;"-"

	lea	MyTextFontINV(pc),a3
	add.w	d0,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)
	
	swap	d4
	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#2,horipos(A5)

	lea	MyTextFontINV+["Z"+3-"0"-7]*16(pc),a3
	bsr	DisplaycharINV
	addq.w	#2,horipos(A5)

	lea	MyTextFontINV+["Z"+5-"0"-7]*16(pc),a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	1280/8*8(a4),a4
	dbf	d7,.clearit_bz

	move.l	(sp)+,a2
	rts
.donote
.disploop
	move.w	horipos2(a5),horipos(A5)
	lea	(A3,d6.w),a0
	add.l	pi_modulo(a2),d6	;next note
	movem.l	d4-a6,-(sp)
	move.l	Pi_convert(A2),d0
	beq.s	.nocon			;nur noch mal zur Sicherheit
	move.l	d0,a1
	jsr	(A1)		;to Period (D0),Samplenumber (D1),
				;Commando (D2) and Argument (D3)
.nocon
	movem.l	(sp)+,d4-a6
	movem.l	a2/a3,-(sp)

	lea	(a4),a1
	lea	(a4),a2
	add.l	map1(A5),a1
	add.l	map2(A5),a2

	lea	NoteTableINV(pc),a3
	moveq	#37+24-1,d4
.findnote
	cmp.w	(A3)+,d0
	beq.s	.foundnote
	addq.l	#3*2,a3	
	dbf	d4,.findnote
	addq.l	#2,a3
.foundnote
	move.w	(a3)+,d0		;"A"
	move.w	2(a3),d4		;"3"
	swap	d4
	move.w	(a3),d4			;"-"

	lea	MyTextFontINV(pc),a3
	add.w	d0,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)
	
	swap	d4
	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)
	
	move.w	d1,d4
	and.w	#$f0,d4
;	lsr.w	#1,d4
	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	move.w	d1,d4
	and.w	#$f,d4
	lsl.w	#4,d4
	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	and.w	#$3f,d2
	lsl.w	#4,d2
	lea	MyTextFontINV(pc),a3
	add.w	d2,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	move.w	d3,d4
	and.w	#$f0,d4
	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	and.w	#$f,d3
	lsl.w	#4,d3
	lea	MyTextFontINV(pc),a3
	add.w	d3,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	movem.l	(sp)+,a2/a3
	lea	1280/8*8(a4),a4
	dbf	d7,.disploop
	rts
;--------------- Patternstreifen bei Blankzero anzeigen ---------------------
.donote_BZ
.disploop_BZ
	move.w	horipos2(a5),horipos(A5)
	lea	(A3,d6.w),a0
	add.l	pi_modulo(a2),d6	;next note
	movem.l	d4-a6,-(sp)
	move.l	Pi_convert(A2),d0
	beq.s	.nocon_BZ			;nur noch mal zur Sicherheit
	move.l	d0,a1
	jsr	(A1)		;to Period (D0),Samplenumber (D1),
				;Commando (D2) and Argument (D3)
.nocon_BZ
	movem.l	(sp)+,d4-a6
	movem.l	a2/a3,-(sp)

	lea	(a4),a1
	lea	(a4),a2
	add.l	map1(A5),a1
	add.l	map2(A5),a2

	lea	NoteTableINV(pc),a3
	moveq	#37+24-1,d4
.findnote_BZ
	cmp.w	(A3)+,d0
	beq.s	.foundnote_BZ
	addq.l	#3*2,a3	
	dbf	d4,.findnote_BZ
	addq.l	#2,a3
.foundnote_BZ
	move.w	(a3)+,d0		;"A"
	move.w	2(a3),d4		;"3"
	swap	d4
	move.w	(a3),d4			;"-"

;---- Note anzeigen ----
	lea	MyTextFontINV(pc),a3
	add.w	d0,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)
	
	swap	d4
	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

;---------- Samplenummer anzeigen -------------

	tst.w	d1
	beq.s	.blankSam

	move.w	d1,d4
	and.w	#$f0,d4
	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	move.w	d1,d4
	and.w	#$f,d4
	lsl.w	#4,d4
	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)
	bra.s	.skipblanksam
.blankSam
	addq.w	#1,horipos(A5)

	lea	MyTextFontINV+["Z"+3-"0"-7]*16(pc),a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)
.skipblanksam
;---------- Kommando/Argument anzeigen ---------
	move.w	d2,d1
	or.w	d3,d1
	beq.s	.blankcmd

	and.w	#$3f,d2
	lsl.w	#4,d2
	lea	MyTextFontINV(pc),a3
	add.w	d2,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	move.w	d3,d4
	and.w	#$f0,d4
	lea	MyTextFontINV(pc),a3
	add.w	d4,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)

	and.w	#$f,d3
	lsl.w	#4,d3
	lea	MyTextFontINV(pc),a3
	add.w	d3,a3
	bsr	DisplaycharINV
	addq.w	#1,horipos(A5)
	bra.s	.skipblankcmd
.blankcmd
	addq.w	#1,horipos(a5)
	
	lea	MyTextFontINV+["Z"+5-"0"-7]*16(pc),a3
	bsr	DisplaycharINV
.skipblankcmd
	movem.l	(sp)+,a2/a3
	lea	1280/8*8(a4),a4
	dbf	d7,.disploop_BZ
	rts
DisplayCharINV:
	movem.l	d0/a1/a2,-(sp)
	move.w	horipos(A5),d0
	add.w	d0,a1
	add.w	d0,a2

	move.b	(A3)+,(a1)
	move.b	(a3)+,1280/8(a1)
	move.b	(a3)+,1280/8*2(a1)
	move.b	(a3)+,1280/8*3(a1)
	move.b	(a3)+,1280/8*4(a1)
	move.b	(a3)+,1280/8*5(a1)
	move.b	(a3)+,1280/8*6(a1)
	move.b	(a3)+,1280/8*7(a1)

	move.b	(A3)+,(a2)
	move.b	(a3)+,1280/8(a2)
	move.b	(a3)+,1280/8*2(a2)
	move.b	(a3)+,1280/8*3(a2)
	move.b	(a3)+,1280/8*4(a2)
	move.b	(a3)+,1280/8*5(a2)
	move.b	(a3)+,1280/8*6(a2)
	move.b	(a3)+,1280/8*7(a2)

	movem.l	(sp)+,d0/a1/a2
	rts
DisplayChar:
	movem.l	d0/a1,-(sp)
	move.w	horipos(A5),d0
	add.w	d0,a1
	move.b	(A3)+,(a1)
	move.b	(a3)+,1280/8(a1)
	move.b	(a3)+,1280/8*2(a1)
	move.b	(a3)+,1280/8*3(a1)
	move.b	(a3)+,1280/8*4(a1)
	move.b	(a3)+,1280/8*5(a1)
	move.b	(a3)+,1280/8*6(a1)
	move.b	(a3)+,1280/8*7(a1)
	movem.l	(sp)+,d0/a1
	rts
Intowindow:
	move.l	grafsave(a5),a6
	move.l	winhandle(a5),a1
	move.l	wd_rport(a1),a1		;Rastport (Ziel)
	move.w	offx(a5),d2
	addq.w	#7,d2			;X2
	move.w	myhoehe1(a5),d3		;Y2
	add.w	#32,d3

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)

	tst.b	modeid(a5)
	bne.s	.set2

	tst.b	refresh(A5)
	beq.s	.set1
	sf	refresh(A5)
.set2
	move.b	#2,bm_depth(a0)
	bra.s	.noset
.set1
	move.b	#1,bm_depth(A0)
.noset
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	Anzeigebreite(a5),d4
	move.w	numzeilen(a5),d5
	lsl.w	#3,d5
	addq.w	#1,d5			;Hhe	
		
	move.b	#$c0,d6			;Miniterm
	jmp	_LVObltbitmaprastport(a6)
********* Balken in der Mitte fr Invertierten Modus setzen *******
SetBalken
	move.l	map2(a5),a0
	move.l	map1(a5),a1
					;Balken in der Mitte setzen
	move.w	numzeilen(a5),d1	;Anzahl der Zeilen
	lsr.w	#1,d1			;durch 2
	mulu	#1280/8*8,d1
	add.l	d1,a0
	add.l	d1,a1

	moveq	#1280/8/4-1,d0
	moveq	#-1,d1
.clr1
	clr.l	(a1)+
	move.l	d1,(a0)+
	dbf	d0,.clr1

	move.w	#1280/8/4*7-1,d0
.clr2
	clr.l	(a0)+
	dbf	d0,.clr2

	moveq	#7-1,d0
.balken
	move.l	(a1),d1
	not.l	d1
	move.b	#0,d1
	move.l	d1,(a1)+		;Vorblock (Zeilennummer)

	moveq	#3,d4
.clr21
	move.l	(a1),d1
	not.l	d1
	move.l	d1,(a1)+		;Vorblock (Zeilennummer)

	move.l	(a1),d1
	not.l	d1
	move.l	d1,(a1)+		;Vorblock (Zeilennummer)

	move.l	(a1),d1
	not.l	d1
	and.l	#$00ffffff,d1
	move.l	d1,(a1)+

	move.l	(a1),d1
	not.l	d1
	move.l	d1,(a1)+

	move.l	(a1),d1
	not.l	d1
	and.l	#$ff00ffff,d1
	move.l	d1,(a1)+

	move.l	(a1),d1
	not.l	d1
	move.l	d1,(a1)+

	move.l	(a1),d1
	not.l	d1
	and.w	#$00ff,d1
	move.l	d1,(a1)+

	move.l	(a1),d1
	not.l	d1
	move.l	d1,(a1)+

	move.l	(a1),d1
	not.l	d1
	move.b	#0,d1
	move.l	d1,(a1)+		;Vorblock (Zeilennummer)

	dbf	d4,.clr21

	add.l	#12,a1

	dbf	d0,.balken

	moveq	#1280/8/4-1,d0
	moveq	#-1,d1
.clr3
	move.l	d1,(a1)+
	dbf	d0,.clr3
	rts
*************************************************************
*           Nachrichtenbearbeitung                          *
*************************************************************
HandleActions
.ma
	btst	d3,d0
	beq.s	.nodis
	bsr	DisplayPatt
.nodis
	move.l	port(a5),d0
	beq.s	.nowinny
	move.l	d0,a0
	move.l	gadsave(a5),a6
	jsr	_LVOGT_getimsg(a6)
	tst.l	d0
	bne	.msg
.nowinny
	move.l	4.w,a6
	move.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.AN_msg

	moveq	#0,d0

	ifne	userprogram
	move.l	msgport(a5),a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
	endc

	move.l	Port(a5),d2
	beq.s	.nomain
	move.l	d2,a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
.nomain
	move.l	mysignal(a5),d3	;Signal fr Patternscroller
	bset	d3,d0		;Signalbit fr Abarbeitung des Patternscrollers
	jsr	_LVOwait(a6)
	bra	.ma
;======================= Message an Hauptwindow ============================
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<- Fr Tastatur / Selnummer Listview
	move.l	im_Iaddress(a1),d6 	<- Fr Gadgetabfrage
	move.l	im_seconds(a1),d2	<- fr Doppelclick
	move.l	im_micros(a1),d3	<- auch f. Doppelclick
	jsr	_LVOGT_replyimsg(a6)

;	cmp.l	#IDCMP_Changewindow,d7
	cmp.l	#IDCMP_NewSize,d7
	bne.s	.nochange

	move.l	winhandle(a5),a0
	move	wd_width(a0),d0
	move	wd_height(a0),d1

	cmp	tmpwidth(a5),d0
	bne.s	.change
	cmp	tmpheight(a5),d1
	beq.s	.nochange
.change
	move	d0,tmpwidth(A5)
	move	d1,tmpheight(A5)

	bsr	freebitmap

	move.l	winhandle(a5),a0
	move.w	wd_width(A0),d2
	sub.w	Offx(A5),d2
	move.l	mypubscreen(A5),a1
	move.b	sc_WBorRight(a1),d1
	ext.w	d1
	sub.w	d1,d2
	sub.w	#16,d2
	move.w	d2,Anzeigebreite(A5)

	move.w	wd_height(a0),d1
	move.w	myhoehe1(a5),d3		;Y2
	add.w	#32+5,d3		;oberer Rand + unterer Rand
	move.b	wd_borderbottom(A0),d2
	ext.w	d2
	add.w	d2,d3
	sub.w	d3,d1			;briger Rest
	lsr.w	#3,d1			;durch 8
	move.w	d1,numzeilen(A5)

	lea	my_bitmap(a5),a3
	bsr	makebitmap
	bra.s	.refresh
.nochange
	bra	.noref
;	cmp.l	#refreshwindow,d7	;Refresh
;	bne.w	.noref
.refresh
	st	refresh(A5)

	move.l	gadsave(a5),a6
	move.l	winhandle(a5),a0	;*Window
	jsr	_LVOGT_beginrefresh(A6)

	move.l	gadsave(a5),a6
	move.l	winhandle(a5),a0	;*Window
	moveq	#1,d0
	jsr	_LVOGT_Endrefresh(A6)	

	bsr	dofills
	bsr	Intowindow
	bra.w	.ma

	;------------------ Gadgets abfragen ------------------------
.noref
	cmp.l	#Gadgetup,d7
	bne.w	.notgad

	move.l	d6,a1

	move.w	gg_gadgetid(A1),d4	;ID Fr Gadgets
	bra	.ma
	;------------------------- Mens abfragen ----------------------------
.menuloop
	move.l	temp(A5),a1
	move.w	mi_nextselect(A1),d5
	bra.s	.menuwei
.notgad:
	cmp.l	#menupick,d7
	bne.w	.nomenu
.menuwei
	move.w	d5,d0
	cmp.w	#menunull,d0
	beq	.ma

	move.l	Project0Menus(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOitemaddress(a6)
	move.l	d0,a1
	move.l	d0,temp(A5)
	beq	.ma

	move.w	d5,d0
	and.w	#$7e0,d0
	bne.s	.notogglesize

	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	lsr.w	#1,d0
	move.b	d0,OnAutoSizing(A5)
	bchg	#7,d0
	move.b	begin+eus_special(pc),d1
	and.b	#~128,d1
	or.b	d0,d1
	move.b	d1,begin+eus_special
	bra	.menuloop
.notogglesize
	cmp.w	#32,d0
	bne.s	.noBlankzero

	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	lsr.w	#2,d0
	move.b	d0,OnBlankzero(A5)

	move.b	begin+eus_special(pc),d1
	and.b	#~64,d1
	or.b	d0,d1
	move.b	d1,begin+eus_special

	bra	.menuloop
.noBlankzero
	cmp.w	#64,d0
	bne.s	.nochangemode

	moveq	#0,d1

	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	lsr.w	#3,d0
	move.b	d0,Modeid(A5)

	move.b	begin+eus_special(pc),d1
	and.b	#~32,d1
	or.b	d0,d1
	move.b	d1,begin+eus_special

	movem.l	d0-a6,-(sp)
	lea	my_bitmap(a5),a3
	bsr	DrawStriche		;bergabe der Bitmap in a3
	bsr	ClearBitmap		;bergabe der Bitmap in a3
	st 	refresh(A5)

	bsr	dofills
	bsr	intowindow
	movem.l	(sp)+,d0-a6
	bra	.menuloop
.nochangemode
	cmp.w	#96,d0
	bne.s	.noResize

	move.l	mypatterninfo(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	pi_voices(a0),d0
	subq.w	#4,d0
	move.l	winhandle(A5),a0
	mulu	#9*8,d0
	move.w	d0,d2
	move.l	mypubscreen(A5),a1
	add.w	#Project0Width+6,d2
	add.w	Offx(A5),d2
	move.b	sc_WBorRight(a1),d1
	ext.w	d1
	add.w	d1,d2
	addq.w	#8,d2
	cmp.w	wd_width(a0),d2
	beq.w	.ma

	move.l	intsave(a5),a6
	move.l	winhandle(A5),a0
	move.w	wd_height(a0),d3
	move.w	wd_leftedge(A0),d0
	move.w	wd_topedge(A0),d1
	move.w	d2,newwidth(A5)
	jsr	_LVOchangewindowbox(a6)
	bra	.ma
.noResize
	cmp.w	#128,d0
	bne.s	.noabout	;1. Item (About) ?
	lea	Aboutmessage(pc),a0
	bsr	Merror
	bra	.menuloop
.noabout
	cmp.w	#160,d0		;2. Item (Hide)
	beq.s	.quitit
	cmp.w	#192,d0		;3. Item (Quit)
	beq	.killit
	bra	.menuloop
.nomenu
	cmp.l	#rawkey,d7
	bne	.nokey

	cmp.b	#$45,d5			;ESC
	beq	.quitit

	bra	.ma
.nokey
	cmp.l	#CloseWindow,d7
	bne	.ma
.quitit
	ifne	userprogram

	bsr	closewin

	move.l	4.w,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	#-1,d5
	move.w	#USclass_DeActivate,d6
	bsr	sendmess
	bra	.ma

	endc
.endme
	moveq	#-1,d7
	rts
.killit
	moveq	#0,d7
	RTS
;===================== Message an Userprogramm Port =====================
	ifne	userprogram
.AN_msg
	move.l	d0,a1

	move.l	MSGPort(a5),UM_Userport(a1)

	lea	begin(pc),a2

	ifne	debug
	move.w	um_usernr(a1),saveusernr(A5)
	else
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	mytask(a5),UM_TaskAdr(a1)
	moveq	#-1,d1
	move.l	d1,UM_Signal(a1)

	move.w	UM_class(a1),d3		<-
	cmp.w	#USclass_exit,d3
	bne.s	.noex1

	clr.l	um_signal(a1)
	clr.l	um_taskadr(a1)
	clr.l	um_userport(a1)
.noex1
	move.l	UM_Type(a1),d7
	move.l	UM_structadr(a1),d6 	<-
	clr.w	UM_class(A1)

	cmp.w	#USclass_getconfig,d3		;when this command comes,set
						;the actual preferences into
						;the Eagleuser-Structure
						;(EUS_-structure at the be-
						;ginning of the program)
	bne	.noprev

	moveq	#0,d0
	move.l	winhandle(A5),d1		;Window
	beq.s	.prnowin			;no Window opened,no change
						;of preferences
	or.w	#eusb_openwin,d0		;set Flag: window is open

	move.l	d1,a0				;Window
	move.w	wd_leftedge(a0),eus_winx(a2)	;Save Windowpostion
	move.w	wd_topedge(a0),eus_winy(a2)

	move.w	eus_special(a2),d1
	and.w	#$E000,d1
	move.w	wd_width(A0),d2
	or.w	d2,d1
	move.b	wd_borderleft(a0),d2
	ext.w	d2
	sub.w	d2,d1
	move.b	wd_borderright(a0),d2
	ext.w	d2
	sub.w	d2,d1
	move.w	d1,eus_special(a2)

	move.w	wd_height(a0),d2
	move.b	wd_bordertop(a0),d1
	ext.w	d1
	sub.w	d1,d2
	move.b	wd_borderbottom(a0),d1
	ext.w	d1
	sub.w	d1,d2
	move.w	d2,eus_special+2(a2)
.prnowin
	move.w	d0,eus_flags(a2)		;Save Flags
.noprev
	cmp.w	#USclass_Show,d3
	beq.s	.win
	cmp.w	#USclass_Activate,d3
	bne.w	.nowin
.win
		move.l	Begin+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Iconify,d0
		bne.w	.noshow

	push	all
	bsr	Openwin
	pop	all
	tst.l	Winhandle(A5)
	beq.s	.noshow
	move	d3,UM_Class(a1)
.noshow
.nowin
	cmp.w	#USclass_Hide,d3
	beq.s	.closewin
	cmp.w	#USclass_DeActivate,d3
	bne.s	.noclosewin
.closewin
	push	all
	bsr	Closewin
	pop	all
.noclosewin

	move.l	d6,an_structadr(a5)
	tst.l	winhandle(a5)
	beq.s	.norefre

	push	all
	bsr	UpdateList
	pop	all
.norefre
	move.l	mn_replyport(a1),d0
	cmp.l	MSGport(a5),d0		 ;eine von uns abgeschickte Message ?
	beq.s	.noreply
	jsr	_LVOreplymsg(a6)
.noreply
	cmp.l	#USM_Userprg,d7	;Message zurckbekommen ?
	bne.s	.nomy

	move.b	#0,messagesent(a5)	;merken,da Message-Struktur frei
	bra.s	.mess		;eventl. Message vom Esagle auswerten
.nomy
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	bne.w	.noeagle		;n
.mess
	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq.w	.ma			;adresse bekommen
	cmp.w	#USclass_zipwin,d3
	beq.s	.setzip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nozip
.setzip
	move.l	4.w,a6
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.l	intsave(a5),a6
	jsr	_LVOzipwindow(a6)
	bra	.ma
.nozip
	cmp.w	#USclass_exit,d3
	beq	.endme

	cmp.w	#USclass_NewConfig,d3	;is there a new config
	bne.w	.nonewcon		;no

	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.w	eus_flags(a0),d0	;get Flags
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin			;open it
	bra.s	.weio
.nowino
	bsr	closewin		;else close it
.weio
	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.l	winhandle(a5),d0	;windowaddress
	beq.s	.nothingtomove		;no Window , no movement

	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;new X-position
	move.w	d0,d1			;save
	blt.s	.oldx			;less than 0 -> stop

	add.w	wd_width(a1),d1		;new position + Window-width
	cmp.w	sc_width(a2),d1		;bigger than Screenwidth ?
	bhi.s	.oldx			;then old X-position (Delta = 0)

	sub.w	wd_leftedge(a1),d0	;new - old X-position = Delta X
	bra.s	.gety
.oldx
	moveq	#0,d0			;Delta X = 0
.gety
	move.w	eus_winy(a0),d1		;new Y-position

	move.w	d1,d2			;save
	blt.s	.oldy			;less than 0 -> stop and take old

	add.w	wd_height(a1),d2	;new position + window-height
	cmp.w	sc_height(a2),d2	;bigger than Screenheight ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;new - old Y-position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1

.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove
.nonewcon
	bra	.ma
.noeagle
	bra	.ma
	endc
*****************************************************************************
*          Einsprung, was alles up to Date gebracht werden mu              *
*****************************************************************************
UpdateList
	tst.l	winhandle(A5)
	beq.s	Rtsit

	move.l	myepbase(pc),a0
	move.l	EPG_someprefs(a0),d1
	btst	#EGPRF_NowPlay,d1
	bne.s	.ok
	btst	#EGPRF_PausePlay,d1
	bne.s	RTSIT
.ok
	bsr	GetPatterninfoTList	;Tagliste fr Patterninfo suchen

	bsr	NewSetSongpos
	bsr	UpdateSongpos		;Anzeige der Songposition vorbereiten
	bsr	NewSetPatt		;Testen ob Patternanzeige oder nicht
					;und und setzen Max. Songlen
	move.b	#-1,Posmerk(a5)
rtsit
	rts
******************************************************************************
*                Patterninfo Tagliste suchen und absaven                     *
******************************************************************************
GetPatterninfoTList
	move.l	a5,-(sp)

	clr.l	myPatterninfo(a5)

	move.l	myepbase(pc),d0
	beq.w	.fatal

	move.l	d0,a5
	move.l	EPG_someprefs(a0),d1
	btst	#EGPRF_NowPlay,d1
	beq.w	.fatal2

;	tst.l	an_structadr(a5)
;	beq	.fatal2

	move.l	d0,a5
	move.l	dtg_getlistdata(a5),a0		;Module geladen ??
	moveq	#0,d0
	jsr	(a0)
 	tst.l	d0
	beq.w	.fatal

	move.l	epg_playertaglist(a5),d1	;Tagliste ??
	beq.w	.fatal
	move.l	d1,d6
	move.l	d1,a0
	move.l	#EP_Patterninit,d0		;EP_Patterninit suchen
	move.l	EPG_FindTag(a5),a1
	jsr	(a1)
	tst.l	d1
	beq.w	.fatal2

	move.l	d0,a0				;Pointer auf Routine zum
						;erstellen der Patterninfo
						;Liste
	movem.l	d1-a6,-(sp)
	jsr	(a0)				;Jump in
	move.l	a0,d0
	movem.l	(sp)+,d1-a6

	move.l	(sp)+,a5
	move.l	d6,myplayertaglist(A5)

	move.l	d0,myPatterninfo(a5)
	move.l	d0,a0
	move.w	PI_voices(a0),d0
	sub.w	#4,d0
	bge.s	.ok
.raus_2
	clr.l	myplayertaglist(a5)
	clr.l	mypatterninfo(a5)	;weniger als 4 Stimmen, raus
	bra.s	.raus
.ok
	cmp.w	#12,d0			;mehr als 4+12 Stimmen, auch raus
	bhi.s	.raus_2

	move.l	winhandle(A5),a0
	mulu	#9*8,d0
	move.w	d0,d2
	move.l	mypubscreen(A5),a1
	add.w	#Project0Width+6,d2
	add.w	Offx(A5),d2
	move.b	sc_WBorRight(a1),d1
	ext.w	d1
	add.w	d1,d2
	addq.w	#8,d2
	cmp.w	wd_width(a0),d2
	beq.s	.raus

	tst.b	OnAutoSizing(A5)
	beq.s	.raus

	move.l	intsave(a5),a6
	move.l	winhandle(A5),a0
	move.w	wd_height(a0),d3
	move.w	wd_leftedge(A0),d0
	move.w	wd_topedge(A0),d1
	move.w	d2,newwidth(A5)
	jsr	_LVOchangewindowbox(a6)
.weiter
.raus
	rts
						;Wenn Window gezoomed
						;einfach Struct ndern
.fatal
	move.l	(sp)+,a5
	clr.l	myplayertaglist(a5)
	rts
.fatal2
	move.l	(sp)+,a5
	tst.l	winhandle(A5)
	beq.s	.ret

	lea	MY_Bitmap(A5),a3
	bsr	ClearBitmap
	bsr	intowindow
.ret
	rts
******************************************************************************
*                Initialisiert Pattern Umschaltungsanzeige                   *
******************************************************************************
NewSetPatt
	lea	PattsString(A5),a2
	move.l	#`---/`,(a2)
	move.l	#`---`<<8,4(a2)

	move.l	myPatterninfo(a5),d0
	beq.s	.nopatts
	move.l	d0,a0
	moveq	#0,d0
	move.w	pi_numpatts(a0),d0
	cmp.w	#255,d0
	bhi.s	.nopatts

	move.w	d0,oldnumpatts(A5)
	st	Pattmerk(a5)
	bra.s	todez
.noPatts
	lea	PattsString(A5),a1
	moveq	#GD_Pos,d0
	bra	ShowText		;(bsr ...; rts)
ToDEZ
	lea	4(a2),a2
ToDez2
	movem.l	d0-a6,-(Sp)
	moveq	#2,d1
	lea	dectable4(pc),a0
.loop
	moveq	#-1,d3
	move.l	-(a0),d2
.loop2
	addq.b	#1,d3
	sub.l	d2,d0
	bcc.s	.loop2
	add.l	d2,d0
	add.b	#`0`,d3
	move.b	d3,(a2)+
	dbf	d1,.loop
	movem.l	(sp)+,d0-a6
	rts
******************************************************************************
*                      Init Songposanzeige                                   *
******************************************************************************
NewSetSongpos
	lea	firstnum(pc),a2
	move.l	#`---/`,(a2)
	move.l	#`---`<<8,4(a2)

	move.l	myPatterninfo(a5),d0
	beq.s	.nosong
	move.l	d0,a0
	moveq	#0,d0
	move.w	pi_maxsongpos(a0),d0
	cmp.w	#255,d0
	bhi.s	.nosong
	move.w	d0,oldsonglen(A5)
	bra	todez
.nosong
	lea	firstnum(pc),a1
	moveq	#GD_Size,d0
	bra	ShowText
******************************************************************************
*                          Position im Song                                  *
******************************************************************************
UpdateSongpos
	lea	firstnum(pc),a2

	move.l	myPatterninfo(a5),d0
	beq.s	.nosize

	move.l	d0,a0
	moveq	#0,d0
	move.w	pi_songpos(a0),d0
	cmp.w	#255,d0
	bhi.s	.nosize

	bsr	todez2

	move.l	a2,a1
	bra.s	.fettich
.nosize
	moveq	#2,d1
	move.l	a2,a1
.strich
	move.b	#`-`,(a2)+
	dbf	d1,.strich
.fettich
	moveq	#GD_Size,d0
	bsr	ShowText
.fatal
	rts
******************************************************************************
*                          Beats per Minute                                  *
******************************************************************************
UpdateBPM
	lea	bpmstring,a2

	move.l	myPatterninfo(a5),d0
	beq.s	.nosize

	move.l	d0,a0
	moveq	#0,d0
	move.w	pi_bpm(a0),d0
	cmp.w	#999,d0
	bhi.s	.nosize
	move.w	d0,BPMmerk(A5)

	bsr	todez2
	move.l	a2,a1
	bra.s	.fettich
.nosize
	moveq	#2,d1
	move.l	a2,a1
.strich
	move.b	#`-`,(a2)+
	dbf	d1,.strich
.fettich
	moveq	#GD_BPM,d0
	bsr	ShowText
.fatal
	rts
******************************************************************************
*                          Speed                                             *
******************************************************************************
UpdateSpeed
	lea	spdstring,a2

	move.l	myPatterninfo(a5),d0
	beq.s	.nosize

	move.l	d0,a0
	moveq	#0,d0
	move.w	pi_speed(a0),d0
	cmp.w	#255,d0
	bhi.s	.nosize
	move.w	d0,speedmerk(A5)

	bsr	todez2
	move.l	a2,a1
	bra.s	.fettich
.nosize
	moveq	#2,d1
	move.l	a2,a1
.strich
	move.b	#`-`,(a2)+
	dbf	d1,.strich
.fettich
	moveq	#GD_Speed,d0
	bsr	ShowText
.fatal
	rts
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0/a2-a3,-(sp)
	suba.l	a3,a3			;*Arguments
	lea	my_easygadget(pc),a2
	bsr	Errorout
	movem.l	(sp)+,d0/a2-a3
	rts
Errorout
	movem.l	d1-a6,-(sp)
	move.l	Intsave(a5),a6
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	move.l	a2,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	jsr	_LVOeasyrequestargs(a6)			;!! durch Reqtools
							;ersetzen
	movem.l	(sp)+,d1-a6	
	rts
******************************************************************************
*                    Text eines Text-Gadgets ndern                          *
* Input: d0: Gadget ID, A1: Text                                             *
******************************************************************************
ShowText:
	movem.l	d0-a6,-(sp)
	tst.l	winhandle(A5)
	beq.s	.nowin

	bsr	_GADR			;Gadgetadresse in A0

	lea	mytags(a5),a3
	move.l	#GTTX_Text,(a3)+
	move.l	a1,(a3)+
	clr.l	(A3)+
	lea	mytags(a5),a3
	move.l	winhandle(A5),a1
	suba.l	a2,a2
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)
.nowin
	movem.l	(sp)+,d0-a6
	rts
;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************
dectable2:
	dc.l	1,10,100
Dectable4
	dc.l	1000
;dectable3
;	dc.l	10000
;dectable5
;	dc.l	100000,1000000,10000000,100000000
;dectable:

int:	dc.b	`intuition.library`,0
gad:	dc.b	`gadtools.library`,0
graf	dc.b	`graphics.library`,0

Aboutmessage:	dc.b	`          Eagleplayer Patternscroll `
		ver
		dc.b	10
		dc.b	`         1993-1995 Buggs of DEFECT`,10
		dc.b	`         Supports up to 16 Voices !`,10
		dc.b	`Contact Me At :`,10
		dc.b	`                  Henryk Richter`,10
		dc.b	`             Stephan-Jantzen-Ring  47`,10
		dc.b	`                  18106  Rostock`,10
		dc.b	`                     Germany`,10,10
		dc.b	`             Phone:  +49-0381-1208867`,10
		dc.b	`  EMAIL: buggs@baltic.e-technik.uni-rostock.de`,10,10,0

MyAnalyzername:	dc.b	`EPatternscroll.1`,0
MyUsername:	dc.b	`Patternscroll`,0
mybuggsname	dc.b	`Buggs of DEFECT`,0
myinfo		dc.b	`Shows up a Protracker Like Patternscroller,`,10
		dc.b	`Up to 16 Voices are supported`,0
NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0
portname:	dc.b	`EAGLEPLAYERPORT`,0
my_easygadget:	dc.b	`   OK   `,0
my_easygadget2	dc.b	`Retry|Cancel`,0
my_easytitle:	dc.b	`Patternscroll+ Message`,0
TopazName:
	DC.B	'topaz.font',0
firstnum
	DC.B	'---/---',0
PosString:
	DC.B	'---/---',0
BPMString
	dc.b	`---`,0
SpdString
	dc.b	`---`,0
BPMText
	dc.b	`BPM`,0
SPdText	dc.b	`Speed`,0
SizeText:
	DC.B	'Position',0
PosText:
	DC.B	'Pattern',0
Project0WTitle:
    DC.B    'Patternscroll',0
Project0STitle:
    DC.B    'Patternscroll (Eagleplayer),  DEFECT Softworks',0
Project0MName0	DC.B    'Project',0

Project0MName10	dc.b	`Autosizing`,0
Project0MName11	dc.b	`Blankzero`,0
Project0MName13	dc.b	`Inverted Mode`,0

Project0MComm10	dc.b	`S`,0
Project0MComm11	dc.b	`B`,0
Project0MComm13	dc.b	`I`,0

Project0MName1	DC.B    'About',0
Aboutcomm	dc.b	`A`,0

HideName	dc.b	`Hide`,0
Hidenamecomm	dc.b	`H`,0

QuitName	dc.b	`Quit`,0
QuitNameComm	dc.b	`Q`,0

Project0MName12		dc.b	`ReSize Width`,0
Project0MName12comm	dc.b	`R`,0

	even
MTags0:
	DC.L	GTMN_Newlookmenus,1
	dc.l	TAG_DONE

Project0GTypes:
    DC.W    TEXT_KIND
    DC.W    TEXT_KIND
    DC.W    TEXT_KIND
    DC.W    TEXT_KIND
    DC.W    TEXT_KIND
    DC.W    TEXT_KIND
    DC.W    TEXT_KIND

Project0NGads:
    DC.W	9,13,64,14
    DC.L	SizeText,0
    DC.W	GD_Size
    DC.L	PLACETEXT_ABOVE,0,0
    DC.W	90,13,64,14
    DC.L	PosText,0
    DC.W	GD_Pos
    DC.L	PLACETEXT_ABOVE,0,0
    DC.W	195,13,32,14
    DC.L	BPMText,0
    DC.W	GD_BPM
    DC.L	PLACETEXT_ABOVE,0,0
    DC.W	269,13,32,14
    DC.L	SpdText,0
    DC.W	GD_Speed
    DC.L	PLACETEXT_ABOVE,0,0

Project0GTags:
	dc.l	GTTX_Justification,GTJ_Right
	DC.L    GTTX_Text,Firstnum
	DC.L    GTTX_Border,1
	DC.L    TAG_DONE
	DC.L    GTTX_Text,PosString
	DC.L    GTTX_Border,1
	DC.L    TAG_DONE
	DC.L    GTTX_Text,BPMString
	DC.L    GTTX_Border,1
	DC.L    TAG_DONE
	dc.l	GTTX_Justification,GTJ_Right
	DC.L    GTTX_Text,SpdString
	DC.L    GTTX_Border,1
	DC.L    TAG_DONE

Project0WindowTags:
Project0L:
    DC.L    WA_Left,0
Project0T:
    DC.L    WA_Top,0
Project0W:
    DC.L    WA_InnerWidth,0
Project0H:
    DC.L    WA_InnerHeight,0
    DC.L    WA_IDCMP,IDCMP_NewSize!IDCMP_Changewindow!IDCMP_RawKey!IDCMP_Menupick!TEXTIDCMP!NUMBERIDCMP!LISTVIEWIDCMP!IDCMP_CLOSEWINDOW
    DC.L    WA_Flags,WFLG_NOCAREREFRESH!WFLG_SizebBottom!WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_Sizegadget
Project0WG:
    DC.L    WA_Gadgets,0
    DC.L    WA_Title,Project0WTitle
    DC.L    WA_ScreenTitle,Project0STitle

	dc.l	WA_Maxwidth
MaxBreite:
	dc.l	0
	dc.l	WA_Maxheight
	dc.l	800				;wer braucht mehr ??
	dc.l	WA_Minheight
Minhoehe
	dc.l	0
	dc.l	WA_MinWidth
MinBreite
	dc.l	0


	dc.l	wa_newlookmenus,1
	dc.l	wa_pubscreen
Pubadr
	dc.l	0

	move.l	wa_autoadjust,1
	DC.L	TAG_DONE
IR:
	DC.L	GT_VisualInfo,$00000000
	dc.l	GTBB_FrameType,BBFT_ICONDROPBOX
	dc.l	TAG_DONE
IR2:
	DC.L	GT_VisualInfo,$00000000
	dc.l	TAG_DONE

Project0NewMenu0:
	DC.B	NM_TITLE,0
	DC.L	Project0MName0
	DC.L	0
	DC.W	0
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	Project0MName10
	DC.L	Project0MComm10
NewItem
	DC.W	CHECKIT!CHECKED!MENUTOGGLE
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	Project0MName11
	DC.L	Project0MComm11
NewItem2
	DC.W	CHECKIT!CHECKED!MENUTOGGLE
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	Project0MName13
	DC.L	Project0MComm13
NewItem3
	DC.W	CHECKIT!CHECKED!MENUTOGGLE;!NM_Itemdisabled
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	Project0MName12
	DC.L	Project0MName12comm
	DC.W	0
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	Project0MName1
	DC.L	AboutComm
	DC.W	0
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	HideName
	DC.L	Hidenamecomm
	DC.W	0
	DC.L	0,0

	DC.B	NM_ITEM,0
	DC.L	QuitName
	DC.L	Quitnamecomm
	DC.W	0
	DC.L	0,0

	DC.B	NM_END,0
	DC.L	0,0
	DC.W	0
	DC.L	0,0
TD:
    DC.L    TAG_DONE
MyTextFont
	dc.b	$3C,$66,$6E,$7E,$76,$66,$3C,$00	;"0"
	dc.b	$18,$38,$78,$18,$18,$18,$18,$00	;"1"
	dc.b	$3C,$66,$06,$0C,$18,$30,$7E,$00	;"2"
	dc.b	$3C,$66,$06,$1C,$06,$66,$3C,$00	;"3"
	dc.b	$1C,$3C,$6C,$CC,$FE,$0C,$0C,$00	;"4"
	dc.b	$7E,$60,$7C,$06,$06,$66,$3C,$00	;"5"
	dc.b	$1C,$30,$60,$7C,$66,$66,$3C,$00	;"6"
	dc.b	$7E,$06,$06,$0C,$18,$18,$18,$00	;"7"
	dc.b	$3C,$66,$66,$3C,$66,$66,$3C,$00	;"8"
	dc.b	$3C,$66,$66,$3E,$06,$0C,$38,$00	;"9"
	dc.b	$3C,$66,$66,$7E,$66,$66,$66,$00	;"A"
	dc.b	$7C,$66,$66,$7C,$66,$66,$7C,$00	;"B"
	dc.b	$1E,$30,$60,$60,$60,$30,$1E,$00	;"C"
	dc.b	$78,$6C,$66,$66,$66,$6C,$78,$00	;"D"
	dc.b	$7E,$60,$60,$78,$60,$60,$7E,$00	;"E"
	dc.b	$7E,$60,$60,$78,$60,$60,$60,$00	;"F"
	dc.b	$3C,$66,$60,$6E,$66,$66,$3E,$00	;"G"
	dc.b	$66,$66,$66,$7E,$66,$66,$66,$00	;"H"
	dc.b	$3C,$18,$18,$18,$18,$18,$3C,$00	;"I"
	dc.b	$06,$06,$06,$06,$06,$66,$3C,$00	;"J"
	dc.b	$C6,$CC,$D8,$F0,$D8,$CC,$C6,$00	;"K"
	dc.b	$60,$60,$60,$60,$60,$60,$7E,$00	;"L"
	dc.b	$C6,$EE,$FE,$D6,$C6,$C6,$C6,$00	;"M"
	dc.b	$C6,$E6,$F6,$DE,$CE,$C6,$C6,$00	;"N"
	dc.b	$3C,$66,$66,$66,$66,$66,$3C,$00	;"O"
	dc.b	$7C,$66,$66,$7C,$60,$60,$60,$00	;"P"
	dc.b	$78,$CC,$CC,$CC,$CC,$DC,$7E,$00	;"Q"
	dc.b	$7C,$66,$66,$7C,$6C,$66,$66,$00	;"R"
	dc.b	$3C,$66,$70,$3C,$0E,$66,$3C,$00	;"S"
	dc.b	$7E,$18,$18,$18,$18,$18,$18,$00	;"T"
	dc.b	$66,$66,$66,$66,$66,$66,$3C,$00	;"U"
	dc.b	$66,$66,$66,$66,$3C,$3C,$18,$00	;"V"
	dc.b	$C6,$C6,$C6,$D6,$FE,$EE,$C6,$00	;"W"
	dc.b	$C3,$66,$3C,$18,$3C,$66,$C3,$00	;"X"
	dc.b	$C3,$66,$3C,$18,$18,$18,$18,$00	;"Y"
	dc.b	$FE,$0C,$18,$30,$60,$C0,$FE,$00	;"Z"
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00	;" "
	dc.b	$6C,$6C,$FE,$6C,$FE,$6C,$6C,$00	;"#"
	dc.b	$00,$00,$00,$7E,$00,$00,$00,$00	;"-"

	dc.b	%00111100			;"?"
	dc.b	%01100110
	dc.b	%00000110
	dc.b	%00001100
	dc.b	%00011000
	dc.b	%00000000
	dc.b	%00011000
	dc.b	%00000000

	dc.b	%00000000			;"."
	dc.b	%00000000
	dc.b	%00000000
	dc.b	%00000000
	dc.b	%00000000
	dc.b	%00011000
	dc.b	%00011000
	dc.b	%00000000
NoteTable:
	dc.w	0000,["Z"+1-"0"-7]*8,["Z"+3-"0"-7]*8,["Z"+1-"0"-7]*8 ;" - "
	dc.w	$358,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	$328,["C"-"0"-7]*8,["Z"+2-"0"-7]*8,["1"-"0"]*8;C#1
	dc.w	$2fa,["D"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;D-1
	dc.w	$2d0,["D"-"0"-7]*8,["Z"+2-"0"-7]*8,["1"-"0"]*8;D#1
	dc.w	$2a6,["E"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;E-1
	dc.w	$280,["F"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;F-1
	dc.w	$25c,["F"-"0"-7]*8,["Z"+2-"0"-7]*8,["1"-"0"]*8;F#1
	dc.w	$23a,["G"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;G-1
	dc.w	$21a,["G"-"0"-7]*8,["Z"+2-"0"-7]*8,["1"-"0"]*8;G#1
	dc.w	$1fc,["A"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;A-1
	dc.w	$1e0,["A"-"0"-7]*8,["Z"+2-"0"-7]*8,["1"-"0"]*8;A#1
	dc.w	$1c5,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;B-1
	dc.w	$1ac,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["2"-"0"]*8;C-2
	dc.w	$194,["C"-"0"-7]*8,["Z"+2-"0"-7]*8,["2"-"0"]*8;C#2
	dc.w	$17d,["D"-"0"-7]*8,["Z"+3-"0"-7]*8,["2"-"0"]*8;D-2
	dc.w	$168,["D"-"0"-7]*8,["Z"+2-"0"-7]*8,["2"-"0"]*8;D#2
	dc.w	$153,["E"-"0"-7]*8,["Z"+3-"0"-7]*8,["2"-"0"]*8;E-2
	dc.w	$140,["F"-"0"-7]*8,["Z"+3-"0"-7]*8,["2"-"0"]*8;F-2
	dc.w	$12e,["F"-"0"-7]*8,["Z"+2-"0"-7]*8,["2"-"0"]*8;F#2
	dc.w	$11d,["G"-"0"-7]*8,["Z"+3-"0"-7]*8,["2"-"0"]*8;G-2
	dc.w	$10d,["G"-"0"-7]*8,["Z"+2-"0"-7]*8,["2"-"0"]*8;G#2
	dc.w	$0fe,["A"-"0"-7]*8,["Z"+3-"0"-7]*8,["2"-"0"]*8;A-2
	dc.w	$0f0,["A"-"0"-7]*8,["Z"+2-"0"-7]*8,["2"-"0"]*8;A#2
	dc.w	$0e2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["2"-"0"]*8;B-2
	dc.w	$0d6,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;C-3
	dc.w	$0ca,["C"-"0"-7]*8,["Z"+2-"0"-7]*8,["3"-"0"]*8;C#3
	dc.w	$0be,["D"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;D-3
	dc.w	$0b4,["D"-"0"-7]*8,["Z"+2-"0"-7]*8,["3"-"0"]*8;D#3
	dc.w	$0aa,["E"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;E-3
	dc.w	$0a0,["F"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;F-3
	dc.w	$097,["F"-"0"-7]*8,["Z"+2-"0"-7]*8,["3"-"0"]*8;F#3
	dc.w	$08f,["G"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;G-3
	dc.w	$087,["G"-"0"-7]*8,["Z"+2-"0"-7]*8,["3"-"0"]*8;G#3
	dc.w	$07f,["A"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;A-3
	dc.w	$078,["A"-"0"-7]*8,["Z"+2-"0"-7]*8,["3"-"0"]*8;A#3
	dc.w	$071,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	808*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	762*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	720*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	678*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	640*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	604*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	570*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	538*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	508*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	480*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	453*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	640*2,["C"-"0"-7]*8,["Z"+3-"0"-7]*8,["1"-"0"]*8;C-1
	dc.w	214/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	202/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	190/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	180/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	170/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	160/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	151/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	143/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	135/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	127/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	120/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	113/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	135/2,["B"-"0"-7]*8,["Z"+3-"0"-7]*8,["3"-"0"]*8;B-3
	dc.w	00,["Z"+4-"0"-7]*8,["Z"+4-"0"-7]*8,["Z"+4-"0"-7]*8;???

MyTextFontINV
	dc.b	~$3C,~$66,~$6E,~$7E,~$76,~$66,~$3c,~$00	;"0"
	dc.b	$3C,$66,$6E,$7E,$76,$66,$3c,$00	;"0"
	dc.b	~$18,~$38,~$78,~$18,~$18,~$18,~$18,~$00	;"1"
	dc.b	$18,$38,$78,$18,$18,$18,$18,$00	;"1"
	dc.b	~$3C,~$66,~$06,~$0C,~$18,~$30,~$7E,~$00	;"2"
	dc.b	$3C,$66,$06,$0C,$18,$30,$7E,$00	;"2"
	dc.b	~$3C,~$66,~$06,~$1C,~$06,~$66,~$3C,~$00	;"3"
	dc.b	$3C,$66,$06,$1C,$06,$66,$3C,$00	;"3"
	dc.b	~$1C,~$3C,~$6C,~$CC,~$FE,~$0C,~$0C,~$00	;"4"
	dc.b	$1C,$3C,$6C,$CC,$FE,$0C,$0C,$00	;"4"
	dc.b	~$7E,~$60,~$7C,~$06,~$06,~$66,~$3C,~$00	;"5"
	dc.b	$7E,$60,$7C,$06,$06,$66,$3C,$00	;"5"
	dc.b	~$1C,~$30,~$60,~$7C,~$66,~$66,~$3C,~$00	;"6"
	dc.b	$1C,$30,$60,$7C,$66,$66,$3C,$00	;"6"
	dc.b	~$7E,~$06,~$06,~$0C,~$18,~$18,~$18,~$00	;"7"
	dc.b	$7E,$06,$06,$0C,$18,$18,$18,$00	;"7"
	dc.b	~$3C,~$66,~$66,~$3C,~$66,~$66,~$3C,~$00	;"8"
	dc.b	$3C,$66,$66,$3C,$66,$66,$3C,$00	;"8"
	dc.b	~$3C,~$66,~$66,~$3E,~$06,~$0C,~$38,~$00	;"9"
	dc.b	$3C,$66,$66,$3E,$06,$0C,$38,$00	;"9"
	dc.b	~$3C,~$66,~$66,~$7E,~$66,~$66,~$66,~$00	;"A"
	dc.b	$3C,$66,$66,$7E,$66,$66,$66,$00	;"A"
	dc.b	~$7C,~$66,~$66,~$7C,~$66,~$66,~$7C,~$00	;"B"
	dc.b	$7C,$66,$66,$7C,$66,$66,$7C,$00	;"B"
	dc.b	~$1E,~$30,~$60,~$60,~$60,~$30,~$1E,~$00	;"C"
	dc.b	$1E,$30,$60,$60,$60,$30,$1E,$00	;"C"
	dc.b	~$78,~$6C,~$66,~$66,~$66,~$6C,~$78,~$00	;"D"
	dc.b	$78,$6C,$66,$66,$66,$6C,$78,$00	;"D"
	dc.b	~$7E,~$60,~$60,~$78,~$60,~$60,~$7E,~$00	;"E"
	dc.b	$7E,$60,$60,$78,$60,$60,$7E,$00	;"E"
	dc.b	~$7E,~$60,~$60,~$78,~$60,~$60,~$60,~$00	;"F"
	dc.b	$7E,$60,$60,$78,$60,$60,$60,$00	;"F"
	dc.b	~$3C,~$66,~$60,~$6E,~$66,~$66,~$3E,~$00	;"G"
	dc.b	$3C,$66,$60,$6E,$66,$66,$3E,$00	;"G"
	dc.b	~$66,~$66,~$66,~$7E,~$66,~$66,~$66,~$00	;"H"
	dc.b	$66,$66,$66,$7E,$66,$66,$66,$00	;"H"
	dc.b	~$3C,~$18,~$18,~$18,~$18,~$18,~$3C,~$00	;"I"
	dc.b	$3C,$18,$18,$18,$18,$18,$3C,$00	;"I"
	dc.b	~$06,~$06,~$06,~$06,~$06,~$66,~$3C,~$00	;"J"
	dc.b	$06,$06,$06,$06,$06,$66,$3C,$00	;"J"
	dc.b	~$C6,~$CC,~$D8,~$F0,~$D8,~$CC,~$C6,~$00	;"K"
	dc.b	$C6,$CC,$D8,$F0,$D8,$CC,$C6,$00	;"K"
	dc.b	~$60,~$60,~$60,~$60,~$60,~$60,~$7E,~$00	;"L"
	dc.b	$60,$60,$60,$60,$60,$60,$7E,$00	;"L"
	dc.b	~$C6,~$EE,~$FE,~$D6,~$C6,~$C6,~$C6,~$00	;"M"
	dc.b	$C6,$EE,$FE,$D6,$C6,$C6,$C6,$00	;"M"
	dc.b	~$C6,~$E6,~$F6,~$DE,~$CE,~$C6,~$C6,~$00	;"N"
	dc.b	$C6,$E6,$F6,$DE,$CE,$C6,$C6,$00	;"N"
	dc.b	~$3C,~$66,~$66,~$66,~$66,~$66,~$3C,~$00	;"O"
	dc.b	$3C,$66,$66,$66,$66,$66,$3C,$00	;"O"
	dc.b	~$7C,~$66,~$66,~$7C,~$60,~$60,~$60,~$00	;"P"
	dc.b	$7C,$66,$66,$7C,$60,$60,$60,$00	;"P"
	dc.b	~$78,~$CC,~$CC,~$CC,~$CC,~$DC,~$7E,~$00	;"Q"
	dc.b	$78,$CC,$CC,$CC,$CC,$DC,$7E,$00	;"Q"
	dc.b	~$7C,~$66,~$66,~$7C,~$6C,~$66,~$66,~$00	;"R"
	dc.b	$7C,$66,$66,$7C,$6C,$66,$66,$00	;"R"
	dc.b	~$3C,~$66,~$70,~$3C,~$0E,~$66,~$3C,~$00	;"S"
	dc.b	$3C,$66,$70,$3C,$0E,$66,$3C,$00	;"S"
	dc.b	~$7E,~$18,~$18,~$18,~$18,~$18,~$18,~$00	;"T"
	dc.b	$7E,$18,$18,$18,$18,$18,$18,$00	;"T"
	dc.b	~$66,~$66,~$66,~$66,~$66,~$66,~$3C,~$00	;"U"
	dc.b	$66,$66,$66,$66,$66,$66,$3C,$00	;"U"
	dc.b	~$66,~$66,~$66,~$66,~$3C,~$3C,~$18,~$00	;"V"
	dc.b	$66,$66,$66,$66,$3C,$3C,$18,$00	;"V"
	dc.b	~$C6,~$C6,~$C6,~$D6,~$FE,~$EE,~$C6,~$00	;"W"
	dc.b	$C6,$C6,$C6,$D6,$FE,$EE,$C6,$00	;"W"
	dc.b	~$C3,~$66,~$3C,~$18,~$3C,~$66,~$C3,~$00	;"X"
	dc.b	$C3,$66,$3C,$18,$3C,$66,$C3,$00	;"X"
	dc.b	~$C3,~$66,~$3C,~$18,~$18,~$18,~$18,~$00	;"Y"
	dc.b	$C3,$66,$3C,$18,$18,$18,$18,$00	;"Y"
	dc.b	~$FE,~$0C,~$18,~$30,~$60,~$C0,~$FE,~$00	;"Z"
	dc.b	$FE,$0C,$18,$30,$60,$C0,$FE,$00	;"Z"
	dc.b	~$00,~$00,~$00,~$00,~$00,~$00,~$00,~$00	;" "
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00	;" "
	dc.b	~$6C,~$6C,~$FE,~$6C,~$FE,~$6C,~$6C,~$00	;"#"
	dc.b	$6C,$6C,$FE,$6C,$FE,$6C,$6C,$00	;"#"
	dc.b	~$00,~$00,~$00,~$7E,~$00,~$00,~$00,~$00	;"-"
	dc.b	$00,$00,$00,$7E,$00,$00,$00,$00	;"-"

	dc.b	%11000011			;"?"
	dc.b	%10011001
	dc.b	%11111001
	dc.b	%11110011
	dc.b	%11100111
	dc.b	%11111111
	dc.b	%11100111
	dc.b	%11111111

	dc.b	%00111100			;"?"
	dc.b	%01100110
	dc.b	%00000110
	dc.b	%00001100
	dc.b	%00011000
	dc.b	%00000000
	dc.b	%00011000
	dc.b	%00000000

	dc.b	-1,-1,-1,-1,-1
	dc.b	%11100111,%11100111,-1
	dc.b	%00000000			;"."
	dc.b	%00000000
	dc.b	%00000000
	dc.b	%00000000
	dc.b	%00000000
	dc.b	%00011000
	dc.b	%00011000
	dc.b	%00000000

	dc.b	%11000011			;"?"
	dc.b	%10011001
	dc.b	%11111001
	dc.b	%11110011
	dc.b	%11100111
	dc.b	%11111111
	dc.b	%11100111
	dc.b	%11111111

	dc.b	%00111100			;"?"
	dc.b	%01100110
	dc.b	%00000110
	dc.b	%00001100
	dc.b	%00011000
	dc.b	%00000000
	dc.b	%00011000
	dc.b	%00000000
NoteTableINV
	dc.w	0000,["Z"+1-"0"-7]*16,["Z"+3-"0"-7]*16,["Z"+1-"0"-7]*16 ;" - "
	dc.w	$358,["C"-"0"-7]*16,["Z"+3-"0"-7]*16,["1"-"0"]*16;C-1
	dc.w	$328,["C"-"0"-7]*16,["Z"+2-"0"-7]*16,["1"-"0"]*16;C#1
	dc.w	$2fa,["D"-"0"-7]*16,["Z"+3-"0"-7]*16,["1"-"0"]*16;D-1
	dc.w	$2d0,["D"-"0"-7]*16,["Z"+2-"0"-7]*16,["1"-"0"]*16;D#1
	dc.w	$2a6,["E"-"0"-7]*16,["Z"+3-"0"-7]*16,["1"-"0"]*16;E-1
	dc.w	$280,["F"-"0"-7]*16,["Z"+3-"0"-7]*16,["1"-"0"]*16;F-1
	dc.w	$25c,["F"-"0"-7]*16,["Z"+2-"0"-7]*16,["1"-"0"]*16;F#1
	dc.w	$23a,["G"-"0"-7]*16,["Z"+3-"0"-7]*16,["1"-"0"]*16;G-1
	dc.w	$21a,["G"-"0"-7]*16,["Z"+2-"0"-7]*16,["1"-"0"]*16;G#1
	dc.w	$1fc,["A"-"0"-7]*16,["Z"+3-"0"-7]*16,["1"-"0"]*16;A-1
	dc.w	$1e0,["A"-"0"-7]*16,["Z"+2-"0"-7]*16,["1"-"0"]*16;A#1
	dc.w	$1c5,["B"-"0"-7]*16,["Z"+3-"0"-7]*16,["1"-"0"]*16;B-1
	dc.w	$1ac,["C"-"0"-7]*16,["Z"+3-"0"-7]*16,["2"-"0"]*16;C-2
	dc.w	$194,["C"-"0"-7]*16,["Z"+2-"0"-7]*16,["2"-"0"]*16;C#2
	dc.w	$17d,["D"-"0"-7]*16,["Z"+3-"0"-7]*16,["2"-"0"]*16;D-2
	dc.w	$168,["D"-"0"-7]*16,["Z"+2-"0"-7]*16,["2"-"0"]*16;D#2
	dc.w	$153,["E"-"0"-7]*16,["Z"+3-"0"-7]*16,["2"-"0"]*16;E-2
	dc.w	$140,["F"-"0"-7]*16,["Z"+3-"0"-7]*16,["2"-"0"]*16;F-2
	dc.w	$12e,["F"-"0"-7]*16,["Z"+2-"0"-7]*16,["2"-"0"]*16;F#2
	dc.w	$11d,["G"-"0"-7]*16,["Z"+3-"0"-7]*16,["2"-"0"]*16;G-2
	dc.w	$10d,["G"-"0"-7]*16,["Z"+2-"0"-7]*16,["2"-"0"]*16;G#2
	dc.w	$0fe,["A"-"0"-7]*16,["Z"+3-"0"-7]*16,["2"-"0"]*16;A-2
	dc.w	$0f0,["A"-"0"-7]*16,["Z"+2-"0"-7]*16,["2"-"0"]*16;A#2
	dc.w	$0e2,["B"-"0"-7]*16,["Z"+3-"0"-7]*16,["2"-"0"]*16;B-2
	dc.w	$0d6,["C"-"0"-7]*16,["Z"+3-"0"-7]*16,["3"-"0"]*16;C-3
	dc.w	$0ca,["C"-"0"-7]*16,["Z"+2-"0"-7]*16,["3"-"0"]*16;C#3
	dc.w	$0be,["D"-"0"-7]*16,["Z"+3-"0"-7]*16,["3"-"0"]*16;D-3
	dc.w	$0b4,["D"-"0"-7]*16,["Z"+2-"0"-7]*16,["3"-"0"]*16;D#3
	dc.w	$0aa,["E"-"0"-7]*16,["Z"+3-"0"-7]*16,["3"-"0"]*16;E-3
	dc.w	$0a0,["F"-"0"-7]*16,["Z"+3-"0"-7]*16,["3"-"0"]*16;F-3
	dc.w	$097,["F"-"0"-7]*16,["Z"+2-"0"-7]*16,["3"-"0"]*16;F#3
	dc.w	$08f,["G"-"0"-7]*16,["Z"+3-"0"-7]*16,["3"-"0"]*16;G-3
	dc.w	$087,["G"-"0"-7]*16,["Z"+2-"0"-7]*16,["3"-"0"]*16;G#3
	dc.w	$07f,["A"-"0"-7]*16,["Z"+3-"0"-7]*16,["3"-"0"]*16;A-3
	dc.w	$078,["A"-"0"-7]*16,["Z"+2-"0"-7]*16,["3"-"0"]*16;A#3
	dc.w	$071,["B"-"0"-7]*16,["Z"+3-"0"-7]*16,["3"-"0"]*16;B-3

	dc.w	$06B0,["C"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;C-1
	dc.w	$0650,["C"-"0"-7]*16,["Z"+2-"0"-7]*16,["0"-"0"]*16;C#1
	dc.w	$05F4,["D"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;D-1
	dc.w	$05A0,["D"-"0"-7]*16,["Z"+2-"0"-7]*16,["0"-"0"]*16;D#1
	dc.w	$054C,["E"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;E-1
	dc.w	$0500,["F"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;F-1
	dc.w	$04B8,["F"-"0"-7]*16,["Z"+2-"0"-7]*16,["0"-"0"]*16;F#1
	dc.w	$0474,["G"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;G-1
	dc.w	$0434,["G"-"0"-7]*16,["Z"+2-"0"-7]*16,["0"-"0"]*16;G#1
	dc.w	$03F8,["A"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;A-1
	dc.w	$03C0,["A"-"0"-7]*16,["Z"+2-"0"-7]*16,["0"-"0"]*16;A#1
	dc.w	$038B,["B"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;B-1

	dc.w	$006B,["C"-"0"-7]*16,["Z"+3-"0"-7]*16,["4"-"0"]*16;C-4
	dc.w	$0065,["C"-"0"-7]*16,["Z"+2-"0"-7]*16,["4"-"0"]*16;C#4
	dc.w	$005F,["D"-"0"-7]*16,["Z"+3-"0"-7]*16,["4"-"0"]*16;D-4
	dc.w	$005A,["D"-"0"-7]*16,["Z"+2-"0"-7]*16,["4"-"0"]*16;D#4
	dc.w	$0054,["E"-"0"-7]*16,["Z"+3-"0"-7]*16,["4"-"0"]*16;E-4
	dc.w	$0050,["F"-"0"-7]*16,["Z"+3-"0"-7]*16,["4"-"0"]*16;F-4
	dc.w	$004B,["F"-"0"-7]*16,["Z"+2-"0"-7]*16,["4"-"0"]*16;F#4
	dc.w	$0047,["G"-"0"-7]*16,["Z"+3-"0"-7]*16,["4"-"0"]*16;G-4
	dc.w	$0043,["G"-"0"-7]*16,["Z"+2-"0"-7]*16,["4"-"0"]*16;G#4
	dc.w	$003F,["A"-"0"-7]*16,["Z"+3-"0"-7]*16,["4"-"0"]*16;A-4
	dc.w	$003C,["A"-"0"-7]*16,["Z"+2-"0"-7]*16,["4"-"0"]*16;A#4
	dc.w	$0038,["B"-"0"-7]*16,["Z"+3-"0"-7]*16,["4"-"0"]*16;B-4

	dc.w	$0035,["B"-"0"-7]*16,["Z"+3-"0"-7]*16,["5"-"0"]*16;C-5
	dc.w	$0032,["A"-"0"-7]*16,["Z"+2-"0"-7]*16,["5"-"0"]*16;C#5
	dc.w	$002F,["A"-"0"-7]*16,["Z"+3-"0"-7]*16,["5"-"0"]*16;D-5
	dc.w	$002D,["G"-"0"-7]*16,["Z"+2-"0"-7]*16,["5"-"0"]*16;D#5
	dc.w	$002A,["G"-"0"-7]*16,["Z"+3-"0"-7]*16,["5"-"0"]*16;E-5
	dc.w	$0028,["F"-"0"-7]*16,["Z"+3-"0"-7]*16,["5"-"0"]*16;F-5
	dc.w	$0025,["F"-"0"-7]*16,["Z"+2-"0"-7]*16,["5"-"0"]*16;F#5
	dc.w	$0023,["E"-"0"-7]*16,["Z"+3-"0"-7]*16,["5"-"0"]*16;G-5
	dc.w	$0021,["D"-"0"-7]*16,["Z"+2-"0"-7]*16,["5"-"0"]*16;G#5
	dc.w	$001F,["D"-"0"-7]*16,["Z"+3-"0"-7]*16,["5"-"0"]*16;A-5
	dc.w	$001E,["C"-"0"-7]*16,["Z"+2-"0"-7]*16,["5"-"0"]*16;A#5
	dc.w	$001C,["C"-"0"-7]*16,["Z"+3-"0"-7]*16,["5"-"0"]*16;B-5

;	dc.w	$0D60,["C"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;C-0
;	dc.w	$0CA0,["C"-"0"-7]*16,["Z"+2-"0"-7]*16,["0"-"0"]*16;C#0
;	dc.w	$0BE8,["D"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;D-0
;	dc.w	$0B40,["D"-"0"-7]*16,["Z"+2-"0"-7]*16,["0"-"0"]*16;D#0
;	dc.w	$0A98,["E"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;E-0
;	dc.w	$0A00,["F"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;F-0
;	dc.w	$0970,["F"-"0"-7]*16,["Z"+2-"0"-7]*16,["0"-"0"]*16;F#0
;	dc.w	$08E8,["G"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;G-0
;	dc.w	$0868,["G"-"0"-7]*16,["Z"+2-"0"-7]*16,["0"-"0"]*16;G#0
;	dc.w	$07F0,["A"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;A-0
;	dc.w	$0780,["A"-"0"-7]*16,["Z"+2-"0"-7]*16,["0"-"0"]*16;A#0
;	dc.w	$0716,["B"-"0"-7]*16,["Z"+3-"0"-7]*16,["0"-"0"]*16;B-0

	dc.w	00,["Z"+6-"0"-7]*16,["Z"+6-"0"-7]*16,["Z"+6-"0"-7]*16;???
;*********** Leertabellen (spter im BSS-Hunk) ***********************
		section	1,BSS
		rsreset
datas:
tmpwidth	rs.w	1
tmpheight	rs.w	1
patt2		rs.w	2
Attr:		rs.l	2
msgport		rs.l	1
intsave:	rs.l	1
grafsave	rs.l	1
gadsave:	rs.l	1
Port:		rs.l	1
Menuadr:	rs.l	1
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
;fontatt:	rs.l	1	;Fontattr Strukturadresse (entweder die des
				;Screens oder die eigene,wenn Screenfont zu
				;gro)
vi:		rs.l	1	;Visualinfo

;Mymess:		rs.b	UM_Sizeof
Mymessage:	rs.b	UM_sizeof	;Intuimessagestruktur

mytags:		rs.l	10*2
mycontextgad:	rs.b	gg_sizeof	;CreateContext() braucht Zeiger auf
					;leere Gadgetstruktur !?

mygad:		rs.b	gng_sizeof	;Platz fr New Gadget Struktur


Project0Gadgets:	rs.l	21
Gadgetadrs=Project0Gadgets

BufNewGad:		rs.w	4
			rs.l	2
			rs.w	1
			rs.l	3

myhoehe1:	rs.w	1
winwidth:	rs.w	1

Project0GList:	rs.l	1
Project0Menus:	rs.l	1
Winhandle	rs.l	1
Font:		rs.l	1
FontX:		rs.w	1
FontY:		rs.w	1
OffX:		rs.w	1
OffY:		rs.w	1
		rs.w	2

MY_Easystruct:	rs.l	1	;EASY-Request
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1
bpmmerk		rs.w	1
Speedmerk	rs.w	1
posmerk		rs.w	1
Pattmerk	rs.w	1
PattsString	rs.b	10
temp:		rs.l	1
Intset		rs.b	1
counter		rs.b	1		;Frei
inter:	rs.l	2
	rs.b	1	;2
	rs.b	1	;127
	rs.l	3
an_structadr	rs.l	1
Modulesize	rs.l	1
MyPatterninfo	rs.l	1
myplayertaglist	rs.l	1	;zum Vergleich mit der des EP
MySaminfo	rs.l	1
Mytask		rs.l	1
MySignal	rs.l	1
Anzeigebreite	rs.w	1
;MY_Bitmapadr:	rs.l	1
MY_Bitmap:	rs.b	8
map1:		rs.l	1
map2:		rs.l	1
		rs.l	6
messagesent	rs.b	1
		rs.b	1
counter2	rs.w	1
MsgPort1:	rs.b	mp_size	;extra Messageport
numzeilen	rs.w	1
HoriPos		rs.w	1
HoriPos2	rs.w	1
newwidth	rs.w	1
oldnumpatts	rs.w	1
oldsonglen	rs.w	1

OnAutoSizing	rs.b	1
Refresh		rs.b	1
OnBlankzero	rs.b	1
Modeid		rs.b	1
Nulls1		rs.l	40
Kick30on	rs.b	1
		rs.b	1

	ifne	debug
saveusernr	rs.w	1
	endc
DatasLen:	rs.w	0
		ds.b	DatasLen
	end
;;
