*****************************************************************************
**                                                                         **
** Engine: Manager                                                         **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Author : Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

Executable	= 1
Test		= 0
Debugger	= 0
UseFillWindow	= 0
BackPic		= 1

ver		macro
		dc.b	"1.5"
		endm
StructVer	macro			!!! in Catalog eintragen !!!
		dc.w	1,5
		endm
date		macro
		dc.b	"27-Aug-97"
		endm
StructDate	macro
		dc.b	27,08
		dc.w	1997
		endm

	incdir	include:
	include	exec/exec_lib.i
	include	dos/dos_lib.i
	include	exec/libraries.i
	include	exec/interrupts.i
	include	libraries/diskfont_lib.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	misc/BuggsMacros.i
	include	misc/EagleplayerEngine.i
	include	libraries/asl_lib.i
	include	libraries/asl.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	libraries/locale_lib.i

	include "intuition/icclass.i"
	include "intuition/classes.i"
        include "intuition/classusr.i"
        include "intuition/imageclass.i"
	include	libraries/utility_lib.i

	include	libraries/datatypes_lib.i
	include	datatypes/datatypes.i
	include	datatypes/pictureclass.i

	include	libraries/reqtools.i
	include	libraries/reqtools_lib.i

;===========================================================================
;		Definitionen & Vereinbarungen 
;===========================================================================
Defheight	=	398	;def. Innerheight
Defwidth	=	560	;def. Innerwidth
ZoomWidth = 180
*YOffset			= 8		* fr TopPos
StringGadgetOffset	= 8		* Zur Fonthhe fr Stringgadgetheight

TitlePufferSize		EQU	MaxDirectorynameSize
TextPufferSize		EQU	500


Mode_Player		= 1
Mode_Engines		= 2
Mode_MaxID		= 2

*-----------------------------------------------------------------------------*
BevelHohe		= 1
BevelBreite		= 2
MinListViewWidth	= 40		*Min Width der Listviews
ListviewBorder		= 4		*Hhe des ListviewRandes (oben+unten)
MinGadgetWidth		= 15		*Min. Breite von Gadgets
MinTextGadgetXOffset	= 2		*Abstand des Textes im Gadget vom
					*Bevelrand
MinTextGadgetYOffset	= 2		*Abstand des Textes im Gadget vom
					*Bevelrand
GadgetXAbstand		= 4		*Abstand der Gadgets untereinander
					*sowie vom linken Rand
GadgetYAbstand		= 4		*Abstand der Gadgets untereinander
					*sowie vom oberen & unteren Rand
AboveAbstand		= 7		*Abstand, wenn Text berm ListView

			rsreset
			rs.b	1
EPENr_FirstNummer	rs.b	0
EPENr_Mode		rs.b	1
EPENr_List		rs.b	1
EPENr_InfoList		rs.b	1
EPENr_Eigenschaftenlist	rs.b	1
EPENr_Add		rs.b	1
EPENr_Delete		rs.b	1
EPENr_Config		rs.b	1
EPENr_LoadConfig	rs.b	1
EPENr_SaveConfig	rs.b	1
EPENr_Toggle		rs.b	1
EPENr_NextMode		rs.b	1
EPENr_DeleteAll		rs.b	1
EPENr_LastNr		rs.b	0

			rsreset
			rs.b	1
LENr_WindowTitle	rs.b	1
LENr_ScreenTitle	rs.b	1
LENr_Players		rs.b	1
LENr_Engines		rs.b	1
LENr_Add		rs.b	1
LENr_AddKey		rs.b	1
LENr_Delete		rs.b	1
LENr_DeleteKey		rs.b	1
LENr_DeleteAll		rs.b	1
LENr_DeleteAllKey	rs.b	1
LENr_Config		rs.b	1
LENr_ConfigKey		rs.b	1
LENr_LoadConfig		rs.b	1
LENr_LoadConfigKey	rs.b	1
LENr_SaveConfig		rs.b	1
LENr_SaveConfigKey	rs.b	1
LENr_Mode		rs.b	1
LENr_ModeKey		rs.b	1
LENr_Verfugbar		rs.b	1
LENr_Info		rs.b	1
LENr_Eigenschaften	rs.b	1
LENr_Project		rs.b	1
LENr_About		rs.b	1
LENr_AboutKey		rs.b	1
LENr_Hide		rs.b	1
LENr_HideKey		rs.b	1
LENr_Quit		rs.b	1
*LENr_QuitKey		rs.b	1
LENr_Ok			rs.b	1
LENr_RequestTitle	rs.b	1
LENr_AboutText		rs.b	1
LENr_EPNotFound		rs.b	1
LENr_EngineNotLoaded	rs.b	1
LENr_PlayerNotLoaded	rs.b	1

LENr_Yes		rs.b	1
LENr_No			rs.b	1

LENr_Type_Unknown		rs.b	1
LENr_Type_Manager		rs.b	1
LENr_Type_Sampleinfo		rs.b	1
LENr_Type_Engineinfo		rs.b	1
LENr_Type_Playerinfo		rs.b	1
LENr_Type_Decruncher		rs.b	1
LENr_Type_Ripper		rs.b	1
LENr_Type_Mainwindow		rs.b	1
LENr_Type_Screenmanager		rs.b	1
LENr_Type_DirViewer		rs.b	1
LENr_Type_Analyzer		rs.b	1
LENr_Type_Amplifier		rs.b	1
LENr_Type_Patternscroll		rs.b	1
LENr_Type_Messagewindow		rs.b	1
LENr_Type_Listadministration	rs.b	1
LENr_Type_Amplifiermanager	rs.b	1
LENr_Type_PlayerLoader		rs.b	1
LENr_Type_Extractor		rs.b	1
LENr_Type_Scope			rs.b	1
LENr_Type_Moduleinfo		rs.b	1

LENr_PlI_Prefix		rs.b	1			*fr Playerinfo/support
LENr_Pls_Volume		rs.b	1
LENr_Pls_Balance	rs.b	1			*fr Playerinfo/support
LENr_Pls_Voices		rs.b	1
LENr_Pls_Speed		rs.b	1
LENr_Pls_PatternJump	rs.b	1
LENr_Pls_PatternScroll	rs.b	1
LENr_Pls_PositionNr	rs.b	1
LENr_Pls_SubSongs	rs.b	1

LENr_Pls_Songend	rs.b	1
LENr_Pls_Amplifier	rs.b	1
LENr_Pls_Scopes		rs.b	1
LENr_Pls_CalcDuration	rs.b	1
LENr_Pls_Check		rs.b	1
LENr_Pls_MultiFiles	rs.b	1
LENr_Pls_Autorerkennung	rs.b	1
LENr_Pls_ModuleInfo	rs.b	1
LENr_Pls_SampleInfo	rs.b	1
LENr_Pls_ModuleChange	rs.b	1
LENr_Pls_SaveModule	rs.b	1
LENr_Pls_SaveAsProTracker rs.b	1
LENr_Pls_LoadFast	rs.b	1

LENr_Pls_Maxlength	rs.b	1
LENr_Pls_MaxSamples	rs.b	1
LENr_Pls_MaxSynthSamples rs.b	1
LENr_Pls_MaxPattern	rs.b	1
LENr_Pls_MaxSubSongs	rs.b	1
LENr_Pls_UnpackedSystem	rs.b	1

LENr_US_OldSoundTracker	rs.b	1
LENr_US_SoundTracker	rs.b	1
LENr_US_NoiseTracker	rs.b	1
LENr_US_ProTracker	rs.b	1

LENr_EnI_Name		rs.b	1
LENr_EnI_Creator	rs.b	1
LENr_EnI_Date		rs.b	1
LENr_EnI_Version	rs.b	1
LENr_EnI_EPVersion	rs.b	1
LENr_EnI_Kickstart	rs.b	1
LENr_EnI_CPU		rs.b	1
LENr_EnI_FPU		rs.b	1
LENr_EnI_NotNeeded	rs.b	1
LENr_EnI_About		rs.b	1
LENr_EnI_Type		rs.b	1

LENr_SelectBackPic	rs.b	1
LENr_BackPic		rs.b	1
LENr_ManConfig		rs.b	1
LENr_ManSaveConfig	rs.b	1
LENr_Von		rs.b	1
LENr_TitlePlayers	rs.b	1
LENr_TitleEngines	rs.b	1

LENr_LastExternal	rs.b	0

GadgetAnz	= 9

*win_breite	=	DefWidth

			rsreset
TextPuffer		rs.b	TextPufferSize
TitlePuffer		rs.b	TitlePufferSize
LocalePuffer		rs.w	LENr_LastExternal
GadgetMerkPuffer	rs.l	GadgetAnz+2
MyTags			rs.l	10*2
BufNewGad		rs.b	gng_sizeof	*Buffer fr Gadgetcreieren
MyFont			rs.l	2
MY_Easystruct		rs.l	5	;EASY-Request
ListAdr			rs.l	1		*Adr der Liste im EP
InfoList		rs.b	lh_size
EigenschaftenList	rs.b	lh_size
CurrentSeconds		rs.l	1
CurrentMicros		rs.l	1
StartSeconds		rs.l	1
StartMicros		rs.l	1
MyCatalog		rs.l	1
MyTaskAdr		rs.l	1
GadgetListadr		rs.l	1
MenuAdr			rs.l	1
VisualInfo		rs.l	1
MyPubScreen		rs.l	1
WinHandle		rs.l	1
WindowPort		rs.l	1
MyRastPort		rs.l	1
OldMenuAdr		rs.l	1
SelectedEntry		rs.l	1
MyMessage		rs.b	UM_SizeOf
ENA_Args1		rs.b	ENA_String+MaxFilenameSize
ENA_Args2		rs.b	ENA_String+MaxFilenameSize
MerkUserNr		rs.w	1
MsgUnterwegs		rs.l	1
ExitNow			rs.w	1
MaxEntries		rs.l	1
MsgPort			rs.l	1
UPrg_Struct		rs.l	1
Signal			rs.l	1
SignalBits		rs.l	1
Font			rs.l	1
FontX			rs.w	1
FontY			rs.w	1
OffX			rs.w	1
OffY			rs.w	1
WinPosX			rs.w	1
WinPosY			rs.w	1
WinHeight		rs.w	1
WinWidth		rs.w	1
TmpWidth		rs.w	1
TmpHeight		rs.w	1
ZoomPosX		rs.w	1
ZoomPosY		rs.w	1
InfoWidth		rs.w	1
InfoWidth2		rs.w	1
IntBase			rs.l	1
GFXBase			rs.l	1
DosBase			rs.l	1
GadBase			rs.l	1
LocaleBase		rs.l	1
RealNumGadgets		rs.l	1
WindowDisabled		rs.w	1
Kick3On			rs.w	1
Result			rs.l	1		*Result bei GetGadgetattr

			*-- BackPic --*
;----------------------- Daten fr Datatypes-Bild ----------------------------------------
DTBase			rs.l	1
DT_PicObject		rs.l	1
DT_MyBitMapheader	rs.l	1
DT_MyBitMap		rs.l	1
DT_Breit2:		rs.l	1
DT_Hoehe2:		rs.l	1
DT_XPos2:		rs.l	1
DT_YPos2:		rs.l	1
Mycmap			rs.l	1
MyPen			rs.l	1
DT_Picture		rs.b	300
ConfigDatas		rs.b	0			\  wird als eigene
DT_Picturedir		rs.b	200			 \ Prefs abgespeichert
DT_Picturename		rs.b	108			 /
ConfigDatasEND		rs.b	0			/



ZoomState		rs.b	1
ListeDa			rs.b	1
ListenDa		rs.b	1
Mode			rs.b	1
KillWS			rs.b	1
PufferEnd		rs.b	0


my_Redrawlist	macro
		dc.l	\1
		dc.w	\2
		ENDM


		STRUCTURE	MY_ListStruct,0
		STRUCT		ML_Node,LN_Size
		ULONG		ML_Size
		LABEL		ML_Chars


EB	macro
	if	test
	move.l	4,a6
	else
	move.l	4.w,a6
	endc
	ENDM

;===========================================================================
	section	0,code
;===========================================================================

		if	test
Start		bsr	FirstEagleInit
		bsr	FirstInit
	illegal

FirstEagleInit:	lea	EaglePuffer,a5
		move.l	a5,EUS_EPBase+EUS_Structure

		lea	MyIntuiname,a1
		EB
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Intuitionbase(a5)

		lea	MyGFXname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GFXbase(a5)

		lea	MyGadToolsname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GadToolsbase(a5)

		lea	MyLocalename,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,EPG_Localebase(a5)

		lea	MyDosname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Dosbase(a5)

		lea	EP_List1,a0
		move.l	a0,EPG_PlayerList(a5)
		newlist a0
		lea	EP_List1,a0
		lea	EP_Entry1,a1
		move.l	#Name1,LN_Name(a1)
		addtail	a0,a1

		lea	EP_List1,a0
		lea	EP_Entry2,a1
		move.l	#Name2,LN_Name(a1)
		addtail	a0,a1

		lea	EP_List1,a0
		lea	EP_Entry3,a1
		move.l	#Name3,LN_Name(a1)
		addtail	a0,a1


		lea	EP_List2,a0
		move.l	a0,EPG_EngineList(a5)
		newlist a0
		lea	EP_List2,a0
		lea	EP_Entry1_1,a1
		move.l	#Name1_1,LN_Name(a1)
		addtail	a0,a1

		lea	EP_List2,a0
		lea	EP_Entry2_2,a1
		move.l	#Name2_2,LN_Name(a1)
		addtail	a0,a1

		lea	EP_List2,a0
		lea	EP_Entry3_3,a1
		move.l	#Name3_3,LN_Name(a1)
		addtail	a0,a1




		rts
MyIntuiname:	dc.b	"intuition.library",0
MyGFXname:	dc.b	"graphics.library",0
MyGadtoolsname:	dc.b	"gadtools.library",0
MyLocalename:	dc.b	"locale.library",0
MyDosname:	dc.b	"dos.library",0
Name1:		dc.b	"Aprosys",0
Name2:		dc.b	"ProTracker",0
Name3:		dc.b	"Whittaker",0

Name1_1:	dc.b	"Amplifier",0
Name2_2:	dc.b	"Dirlistviewer",0
Name3_3:	dc.b	"Spacescope",0

		even
EaglePuffer	ds.b	EPG_SizeOf

EP_List1	ds.b	LH_Size
EP_Entry1	ds.b	LN_Size
EP_Entry2	ds.b	LN_Size
EP_Entry3	ds.b	LN_Size


EP_List2	ds.b	LH_Size
EP_Entry1_1	ds.b	LN_Size
EP_Entry2_2	ds.b	LN_Size
EP_Entry3_3	ds.b	LN_Size


		endc
*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
EUS_Structure:	bra.w	FirstInit			;EUS_Jump
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
EPBase		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	0				;EUS_TickFlags
		dc.l	USMB_KillModule!USMB_NewPreference!USMB_WaitPointer!USMB_NewEngineLoaded!USMB_NewModule!USMB_NewPlayer!USMB_Zipwin!USMB_ChangeConfig!USMB_RemPlayerList!USMB_RemEnginesList
		dc.l	MyProzessName			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	37				;EUS_Kickstart
		dc.l	11 ;EAGLEVERSION			;EUS_EPVersion
		structver				;EUS_Version,EUS_Revision
		dc.l	MyProzessName			;EUS_Username
		dc.w	200				;EUS_WinX
		dc.w	$62 14				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
EUS_Width	dc.w	DefWidth		;EUS_Special  -> InnerWidth
EUS_Height	dc.w	Defheight		;EUS_Special+2 -> InnerHeigth
		dc.l	0				;EUS_Special2
ZoomX		equ	EUS_Special2
ZoomY		equ	EUS_Special2+2
ZoomONOFF	equ	EUS_Special3
EUSMode		equ	EUS_Special3+2
BackPicFlags	equ	EUS_Special3+3
*Sysfontonoff	equ	EUS_Special+1

		dc.w	0				;EUS_Special3
		dc.b	Mode_Player
		dc.b	1				*BackPic-Flag

		structdate				;EUS_Creatordate
		dc.b	0				;EUS_Prioritt
		dc.b	EUTY_Playerinfo			;EUS_Type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6
		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	`$VER: Eagleplayer-Manager V`
		ver
		dc.b	` (`
		date
		dc.b	`)`,0
		even

TagListe:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Manager
		dc.l	0


*----------------------------------------------------------------------------*
FirstInit:	lea	Puffer,a5		;BSS lschen
		EB
		cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
		blo	Exit			;nein,raus
		bsr	ClrPuffer

		EB
		cmp.w	#39,Lib_Version(a6)
		blo.s	.NoKick3
		not.w	Kick3On(a5)
.NoKick3:	move.l	EUS_Structure+EUS_EPBase(pc),d0
		beq.w	Exit

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	DTG_Intuitionbase(a4),Intbase(a5)
		move.l	DTG_GFXBase(a4),GFXBase(a5)
		move.l	EPG_LocaleBase(a4),LocaleBase(a5)
		move.l	DTG_GadtoolsBase(a4),GadBase(a5)
		move.l	DTG_Dosbase(a4),DosBase(a5)

		
		move.l	#-1,mypen(A5)	;Halfshine Farbe fr Gadgets, zur Sicherheit -1 gesetzt

		lea	EUS_Structure(pc),a0
		move.b	ZoomOnOff(a0),ZoomState(a5)
		move	Eus_Winx(a0),WinPosX(a5)
		move	Eus_Winy(a0),WinPosY(a5)
		move	ZoomX(a0),ZoomPosX(a5)
		move	ZoomY(a0),ZoomPosY(a5)
		move.b	EUSMode(a0),d0
		bne.s	.ModeOk
		moveq	#Mode_Player,d0
.ModeOk:	move.b	d0,Mode(a5)

		move.l	#1,SelectedEntry(a5)
		lea	InfoList(a5),a0
		Newlist	a0
		lea	EigenschaftenList(a5),a0
		Newlist	a0

		bsr	FirstLocaleInit

		sub.l	a1,a1
		EB
		jsr	_LVOFindTask(a6)
		move.l	d0,MyTaskAdr(a5)

		bsr	LoadConfig


*-------------------------- Mesage an Eagleplayer schicken -----------------*
*---- Input:	;d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
	if Executable+Debugger
		if debugger
		move.l	#EUS_Structure,d5
		else
		moveq	#0,d5
		endc
		moveq	#0,d1
		moveq	#USClass_NewUserPrg,d2
		moveq	#0,d3
		moveq	#0,d4
		if	debugger
		move.w	#-2,MerkUserNr(a5)
		endc
		bsr	SendeOneMessage
		if	debugger
		move.w	MyMessage+UM_UserNr(a5),MerkUserNr(a5)
		tst.l	d0
		endc
	else
		bsr.w	OpenWin
	endc
		beq.s	ExitEngine
	
	*------------ Hauptprogramm ablaufen lassen ------------*
		bsr.w	Warten



*-----------------------------------------------------------------------------*
ExitEngine:	lea	Puffer,a5

		bsr	WaitUserMessages
		bsr	CloseWin
		bsr	RemoveMsgPort

		move.l	DTBase(a5),d0
		beq.s	.nodt
		move.l	d0,a1
		EB
		jsr	_LVOCloselibrary(a6)
		clr.l	DTBase(a5)
.nodt


Exit:		moveq	#EPR_ErrorAddUserPrg,d0
		rts



SendeOneMessage:
		movem.l	d1-a6,-(a7)
	if	executable+debugger
		bsr	CreateMsgPort
		beq.w	.Fehler
		bsr	WaitUserMessages

		*bsr	AllocMsg
		*beq	.fehler
		*move.l	d0,a1
		lea	MyMessage(a5),a1

	*------------ Exec-Message initialisieren -----------*
		move.w	#UM_Sizeof-20,MN_Length(a1)
		move.b	#NT_Message,LN_Type(a1)
		move.l	MsgPort(a5),MN_ReplyPort(a1)

	*------------ User-Message initialisieren -----------*
		if	debugger
		move.w	MerkUserNr(a5),UM_UserNr(a1)
		else
		move.w	EUS_Structure+EUS_UserNr(pc),UM_UserNr(a1)
		endc
		move.l	MyTaskAdr(a5),UM_TaskAdr(a1)
		move.l	Signal(a5),UM_Signal(a1)
		move.l	MsgPort(a5),UM_UserPort(a1)
		move.l	#USM_Userprg,UM_Type(a1)
		move.w	d1,UM_Enabled(a1)
		move.w	d2,UM_Class(a1)			;Kennung setzen
		move.l	d3,UM_Command(a1)
		move.l	d4,UM_ArgString(a1)
		move.l	d5,UM_Result(a1)

		*move.l	a1,ThisMessage(A5)

	*------------ Message senden -------------*
.RetryFindPort:	lea	EPUserPortName(pc),a1
		EB
		jsr	_LVOFindPort(a6)
		move.l	d0,a0
		tst.l	d0
		bne.s	.PortDa

	*----- Eagleplayer-Port nicht gefunden ----*
		moveq	#LENr_EPNotFound,d0
		bsr	TextRequest
		moveq	#0,d0
		bra.s	.Fehler
		*beq.s	.Fehler
		*bra.s	.RetryFindPort

.PortDa:	movem.l	d0/a0,-(a7)
		*move.l	ThisMessage(A5),a1
		lea	MyMessage(a5),a1

		move.l	UM_TaskAdr(a1),d0
		beq.s	.NoTask
		move.l	d0,a1
		moveq	#0,d0
		jsr	_LVOSetTaskPri(a6)	
.NoTask:	movem.l	(a7)+,d0/a0
		*move.l	ThisMessage(A5),a1
		lea	MyMessage(a5),a1
		jsr	_LVOPutMsg(a6)

		addq.l	#1,MsgUnterwegs(a5)

	*---------- Alles klar, Ende ----------*
.NoPort:	bsr	WaitUserMessages
		endc
		moveq	#-1,d0
.Fehler:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
CreateMsgPort:	movem.l	d1-d7/a1-a6,-(a7)
		move.l	MsgPort(a5),d0
		bne.s	.PortOk
		EB
		jsr	_LVOCreateMsgPort(a6)	;Messageport auf die schnelle Art
		move.l	d0,MSGport(a5)
		tst.l	d0
		beq.s	.PortOk
		move.l	d0,a1
		move.l	#MyMsgPortName,LN_Name(a1)
		jsr	_LVOAddPort(a6)


	*----------- SignalBits setzen ------------*
		move.l	MsgPort(a5),a0
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)

.PortOk:	movem.l	(a7)+,d1-d7/a1-a6
		move.l	MsgPort(a5),d0
		move.l	d0,a0
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
RemoveMsgPort:	movem.l	d0-a6,-(a7)

	*----------- SignalBits sperren ------------*
		move.l	MSGport(a5),d0
		beq.s	.PortOk
		move.l	d0,a1
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)
		EB
		jsr	_LVORemPort(a6)

		move.l	MsgPort(a5),a0
		jsr	_LVODeleteMsgPort(a6)	;Messageport auf die schnelle Art
		clr.l	MsgPort(a5)
.PortOk:	movem.l	(a7)+,d0-a6
		rts

*----------------------- Gibt die Return-Structure frei -------------------*
FreeCommandStruct:
		movem.l d0/d1/a0/a1/a4/a6,-(a7)
		move.l	UPrg_Struct(a5),a4
.NextStruct:	moveq	#0,d0
		cmp.l	a4,d0
		beq.w	.Return
		move.l	a4,a1
		move.l	(a1),a4
		move.l	EPT_StringSize(a1),d0
		beq.s	.StructFree
		EB
		jsr	_LVOFreeMem(a6)
.StructFree:	bra.b	.NextStruct
.Return:
		clr.l	UPrg_Struct(a5)
		movem.l	(a7)+,d0/d1/a0/a1/a4/a6
		rts

*---------------------------------------------------------------------------*
*----- Wartet, bis alle Messages von den Userprogrammen wieder da sind -----*
*---------------------------------------------------------------------------*
WaitUserMessages:movem.l d0-a6,-(a7)

	if debugger
		bsr.w	CopyEPBase
	endc

.WaitNochmal:	tst.l	MsgUnterwegs(a5)
		beq.w	.Return
		move.l	4,a6
		bsr	CreateMsgPort
		beq.s	.Return
		move.l	a0,a3
		jsr	_LVOWaitPort(a6)
		move.l	a3,a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.s	.WaitNochmal
		move.l	d0,a1
		bsr	UserMessage
		bra.s	.WaitNochmal
.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
ClrPuffer:	move.l	a5,a0
		move.w	#PufferEnd-1,d0
.clr		clr.b	(a0)+
		dbf	d0,.clr
		rts

	if	Test!Debugger
CopyEPBase:	move.l	EUS_Structure+EUS_EPBase(pc),d0
		beq.s	.Fertig
		move.l	d0,a0
		*move.l	a0,EPBase(a5)
		move.w	#EPG_SizeOf/2-1,d0
		move.l	a5,a1
.CopyEP:	move.w	(a0)+,(a1)+
		dbf	d0,.CopyEP
.Fertig:	rts
	endc



*---------------------------------------------------------------------------*
*------------ Hier befindet sich nun die Schleife die Aktionen -------------*
*---------------------------------------------------------------------------*
Warten:		tst.w	ExitNow(a5)
		bne.w	Return

		move.l	MsgPort(a5),d0
		beq.s	WartenWinPort
		move.l	d0,a0
		EB
		jsr	_LVOGetmsg(a6)
		tst.l	d0			;Scrollen erlaubt
		beq.w	WartenWinPort
		bsr.w	UserMessage
		bra.w	Warten

SendExit:	moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
Return:		rts

WartenWinPort:	move.l	WindowPort(a5),d0
		beq.s	Wait
		move.l	d0,a0
		move.l	GadBase(a5),a6
		jsr	_LVOGT_GetIMsg(a6)
		tst.l	d0
		beq.s	Wait
		move.l	d0,a1
		bsr.w	GetMsg

		cmp.w	#EPNr_Engine,d0
		bne.s	Warten
		rts

*----------------------------------------------------------------------------*
*------------- Hier wait, bis einer der Message-Ports ->>> Message ----------*
*----------------------------------------------------------------------------*
Wait:		move.l	SignalBits(a5),d0
		or.w	#$1000,d0		;Break-Signal
		EB
		jsr	_LVOWait(a6)

	*------- War es ein Break Signal -----*
		btst	#12,d0			;Break-Signal
		bne.w	SendExit

	*------- War es ein UserMessage ------*
		move.l	MsgPort(a5),d2
		beq.s	.NoPort
		move.l	d2,a0
		moveq	#0,d1
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	Warten			;EaglePort

	*----- war es eine Window-Message ----*
.NoPort:	move.l	WindowPort(a5),d2		;Testen ob Window-Port
		beq.s	.NoMain
		move.l	d2,a0
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenWinPort
.NoMain:	bra.w	Wait





*-----------------------------------------------------------------------------*
GetMsg:		lea	Puffer,a5
		*move.l	WindowPort(a5),d0
		*beq.w	.Return
		*move.l	d0,a0
		*move.l	GadBase(a5),a6
		*jsr	_LVOGT_getimsg(a6)
		*tst.l	d0
		*beq	.Return
		*move.l	d0,a1
		move.l	im_class(a1),d7
		moveq	#0,d5
		move.l	IM_Seconds(a1),CurrentSeconds(a5)
		move.l	IM_Micros(a1),CurrentMicros(a5)
		move.w	im_code(a1),d5 		<- Fr Tastatur / Selnummer Listview
		move.l	im_Iaddress(a1),d6 	<- Fr Gadgetabfrage
		move.l	im_seconds(a1),d2	<- fr Doppelclick
		move.l	im_micros(a1),d3	<- auch f. Doppelclick
		jsr	_LVOGT_ReplyIMsg(a6)

	*---------------- MSG auswerten -------------*
		cmp.l	#IDCMP_Changewindow,d7	;Refresh
		bne.s	.TestNewSize
		move.l	Winhandle(a5),a0
		move	OffY(A5),d0
		cmp	wd_height(a0),d0
		bne.s	.setposun
		move.w	wd_leftedge(a0),ZoomPosX(a5)
		move.w	wd_topedge(a0),ZoomPosY(a5)
		st	ZoomState(a5)
		bra.w	.Return
.Setposun:	move.w	wd_leftedge(a0),WinPosX(a5)
		move.w	wd_topedge(a0),WinPosY(a5)
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)
		sf	ZoomState(a5)
		bra.w	.Return

*---------------------------------------------------*
* das war die alte Refreshroutine
******************************************
*.TestNewSize:	cmp.l	#NewSize,d7
*		bne.s	.TestRefreshWindow
*
*		move.l	Winhandle(a5),a0
*		move	OffY(A5),d0
*		cmp	WD_Height(a0),d0
*		beq.s	.SizeNoMerk
*		move.w	wd_Width(a0),WinWidth(a5)
*		move.w	wd_Height(a0),WinHeight(a5)
*.SizeNoMerk:	move.l	GadgetListAdr(a5),d0
*		beq.s	.TestRefreshWindow
*		move.l	d0,a1
*		moveq	#0,d0
*		move.w	RealNumGadgets(a5),d0
*		move.l	Winhandle(a5),a0
*		move.l	Intbase(a5),a6
*		jsr	_LVORemoveGList(a6)
*		bsr	FreeGadgets
*		bsr	Clearwindow
*		bsr	InitGadgets
*		bne.w	.Return
*		bsr	AddGads
*		*bne	.Return
*		bsr	EinTragNeu
*		bra.w	.Return
*
*.TestRefreshWindow:
*
*		cmp.l	#Refreshwindow,d7	;Refresh
*		bne.s	.TestGadgetUp
*
*.Refresh:
*
*	move.l	IntBase(a5),a6
*	move.l	WinHandle(a5),a0
*	jsr	_LVORefreshWindowFrame(a6)
*	bra.w	.return
*---------------------------------------------------*

.TestNewSize:	cmp.l	#NewSize,d7
		bne.s	.TestRefreshWindow

		move.l	Winhandle(a5),a0
;		move	OffY(A5),d0
;		cmp	WD_Height(a0),d0
;		beq.w	.Return

		move.w	wd_width(a0),d0
		cmp.w	TmpWidth(a5),d0
		bne.s	.NewSizeReal
		move.w	wd_height(a0),d0
		cmp.w	TmpHeight(a5),d0
		beq.w	.Return
.NewSizeReal:
		move.w	wd_Width(a0),TmpWidth(a5)
		move.w	wd_Height(a0),TmpHeight(a5)
		bsr	ResizeWindow
		bra.w	.Return

.TestRefreshWindow:
		* Kann raus, da Smartrefresh
		*cmp.l	#Refreshwindow,d7	;Refresh
		*bne.s	.TestGadgetUp
		*bsr	ResizeWindow
		*bra.w	.Return



*		bsr	Clearwindow
*	*	move.l	Gadbase(a5),a6
*	*	move.l	Winhandle(a5),a0	;*Window
*	*	jsr	_LVOGT_beginrefresh(a6)
*
*	*	move.l	Winhandle(a5),a0	;*Window
*	*	moveq	#1,d0
*	*	jsr	_LVOGT_Endrefresh(a6)
*
*		move.l	GadgetListAdr(a5),a0
*		move.l	Winhandle(a5),a1
*		suba.l	a2,a2
*		moveq	#-1,d0
*		move.l	IntBase(a5),a6
*		jsr	_LVOrefreshglist(a6)
*
*		move.l	GadBase(a5),a6
*		move.l	Winhandle(a5),a0
*		sub.l	a1,a1
*		jsr	_LVOGT_RefreshWindow(a6)
*
*
*		bra.w	.Return

.TestGadgetUp:	cmp.l	#Gadgetup,d7
		bne.w	.TestMenu
		move.l	d6,a1
		move.w	GG_Gadgetid(a1),d4	;Nr des Gadgets
		bsr	GadgetAuswertung
		bra.w	.Return


.MenuLoop:	move.l	OldMenuAdr(a5),a1
		move.w	MI_NextSelect(A1),d5
		bra.s	.MenuNext
.TestMenu:	cmp.l	#MenuPick,d7
		bne.w	.TestRawKey
.MenuNext:	move.w	d5,d0
		cmp.w	#menunull,d0
		beq	.Return

		move.l	MenuAdr(a5),a0
		move.l	IntBase(a5),a6
		jsr	_LVOItemAddress(a6)
		move.l	d0,a1
		tst.l	d0
		beq	.Return
		move.l	d0,OldMenuAdr(a5)

		move.w	d5,d0
		move.w	d5,d1
		and.w	#$7e0,d0
		lsr.w	#5,d0
		and.w	#$1f,d5
		bne.s	.2ndmenu


		tst.w	d0
		*cmp.w	#1,d0
		beq.w	.DeleteAll
		cmp.w	#2,d0
		beq.w	.About
		cmp.w	#4,d0
		beq.w	.HideWindow
		cmp.w	#5,d0
		beq.w	.QuitManager
		bra	.Return

.2ndMenu:	tst.w	d0
		beq.s	.ToggleBackPic
		cmp.w	#1,d0
		beq.s	.SelectBackPic
		cmp.w	#3,d0
		beq.w	.SaveManConfig
		bra	.Return

.SaveManConfig:	bsr	SaveManConfig
		bra.w	.Return


.ToggleBackPic:	move.b	MI_Flags(a1),d0
		and	#1,d0

		move.b	BackPicFlags+EUS_Structure(pc),d1
		and.b	#~[1],d1
		or.b	d0,d1
		move.b	d1,BackPicFlags+EUS_Structure

		tst.b	d0
		beq.s	.SetPic
		tst.b	DT_Picturename(A5)			;Test, ob schon Name vorliegt
		bne.s	.SetPic
		bsr	DT_Filerequest
		bne	.SetPic


		move.l	Winhandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		move.l	a1,-(a7)
		move.l	IntBase(a5),a6
		jsr	_LVOClearMenuStrip(a6)
		move.l	(a7)+,a1
		move	mi_Flags(a1),d0
		and	#~CHECKED,d0
		move	d0,mi_Flags(a1)				;bser,bser Hack...

		move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	_LVOSetMenuStrip(a6)

		moveq	#0,d2
		bra	.ToggleBackPic

.SetPic:	bsr	LoadNewPicture
		bra.w	.Return

.SelectBackPic:	bsr	DT_Filerequest
		beq	.Return

		move.b	BackPicFlags+EUS_Structure(pc),d0
		and.b	#1,d0		;Bit 3 = Back Pic
		beq	.Return
		bra	.Setpic



.About:		moveq	#LENr_AboutText,d0
		bsr	TextRequest		;Infotext ausgeben (Requester)
		bra	.Return

.DeleteAll:	bsr	GG_DeleteAll
		bra	.Return



.TestRawkey:	cmp.l	#rawkey,d7
		bne	.TestVanillaKey
		
		*cmp.b	#$45,d5			;ESC
		*beq.w	.HideWindow
		cmp.b	#$4d,d5
		beq.s	.EinenRunter
		cmp.b	#$4c,d5
		beq.s	.EinenRauf
		*cmp.b	#$44,d5
		*beq.s	.ToggleZustand
		*cmp.b	#$40,d5
		*beq.s	.ToggleZustand

		cmp.b	#$5f,d5
		beq.s	.ToggleHelpMode
		bra.w	.Return


.EinenRunter:	move.l	SelectedEntry(a5),d0
		cmp.l	MaxEntries(a5),d0
		beq.w	.Return
		addq.l	#1,d0
		bsr	ChangeNowListViews
		bra.w	.Return

.EinenRauf:	move.l	SelectedEntry(a5),d0
		cmp.l	#2,d0
		blt.w	.Return
		subq.l	#1,d0
		bsr	ChangeNowListViews
		bra.w	.Return

.ToggleZustand:	move.l	SelectedEntry(a5),d0
		*cmp.l	#1,d0
		blt.w	.Return

		move.l	EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d1
		btst	#EGPRF_Help,d1
		bne.s	.Help
		bsr	GG_TogglePlayer
		bra.w	.Return


.Help:		move.l	#EPNr_HelpLink,d3		*EP-Kommando
		move.l	SelectedEntry(a5),d0		*Playernummer
		add.w	#EPNr_FirstPlayer,d0
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Hlp_Player
		bsr	GetEngineNr
		add.w	#EPNr_FirstEngine-1,d0
.Hlp_Player:	moveq	#0,d1
		bsr	SendMess
		bra.w	.Return

.ToggleHelpMode:moveq	#EPNr_Help,d3
		moveq	#-1,d0				;Toggle
		moveq	#0,d1
		bsr	SendMess
		bra.w	.Return

.TestVanillaKey:cmp.l	#vanillakey,d7
		bne	.TestCloseWindow

		cmp.b	#13,d5
		beq.s	.ToggleZustand
		cmp.b	#32,d5
		beq.s	.ToggleZustand
		cmp.b	#$1b,d5
		beq.s	.HideWindow
		cmp.b	#9,d5
		beq.s	.NextMode

		bclr	#5,d5
		lea	.Tastaturtabelle(pc),a1
.TesteTasten:	moveq	#0,d0
		move.b	(a1)+,d0
		beq.w	.Return
		bsr	GetLocaleString
		move.l	d0,a0
		moveq	#0,d4
		move.b	(a1)+,d4
		move.b	(a0),d0
		bclr	#5,d0
		cmp.b	d0,d5
		bne.w	.TesteTasten
		bsr	GadgetAuswertung
		bra.w	.Return

.Tastaturtabelle:
		dc.b	LENr_DeleteAllKey,EPENr_DeleteAll
		dc.b	LENr_DeleteKey,EPENr_Delete
		dc.b	LENr_AddKey,EPENr_Add
		dc.b	LENr_ConfigKey,EPENr_Config
		dc.b	LENr_LoadConfigKey,EPENr_LoadConfig
		dc.b	LENr_SaveConfigKey,EPENr_SaveConfig
		dc.b	LENr_ModeKey,EPENr_NextMode
		dc.b	0
		even

.NextMode:	bsr	GG_NextMode
		bra.s	.Return

.TestCloseWindow:cmp.l	#CloseWindow,d7
		bne	.Return

.HideWindow:

		lea	Helpnode_Hide(pc),a0
		bsr	SendHelp
		beq.w	.Return

		ifeq	executable+debugger
		move.w	#1,ExitNow(a5)
		moveq	#EPNr_Engine,d0
		bra.w	.Return
		else
		moveq	#0,d1
		moveq	#USClass_Deactivate,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
		endc
		bra.w	.Return

.QuitManager:	move.w	#1,ExitNow(a5)
		ifeq	executable+debugger
		moveq	#EPNr_Engine,d0
		bra.s	.Return
		else
		bsr	MerkWindowSize
		moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
		endc
		moveq	#EPNr_Engine,d0
		bra.w	.Return2


.Return:	moveq	#0,d0
.Return2:	tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* d4=EPNr_Nummer
GadgetAuswertung:
		lea	.GadgetAuswertTab(pc),a0
		moveq	#0,d0
		cmp.w	#EPENr_LastNr,d4
		bhi.s	.Return
		add.w	d4,d4
		move.w	-2(a0,d4.w),d1
		lea	(a0,d1.w),a0
		jsr	(a0)

.Return:	rts

.GadgetAusWertTab:
		dc.w	GG_Mode-.GadgetAusWertTab		*Mode
		dc.w	GG_List-.GadgetAusWertTab		*ListView
		dc.w	.Return-.GadgetAusWertTab		*InfoList
		dc.w	.Return-.GadgetAusWertTab		*Eigenschaften
		dc.w	GG_AddWas-.GadgetAusWertTab		*Add
		dc.w	GG_DelWas-.GadgetAusWertTab		*Delete
		dc.w	GG_Config-.GadgetAusWertTab		*Config
		dc.w	GG_LoadConfig-.GadgetAusWertTab		*LoadConfig
		dc.w	GG_SaveConfig-.GadgetAusWertTab		*SaveConfig
		dc.w	GG_TogglePlayer-.GadgetAusWertTab	*Toggle
		dc.w	GG_NextMode-.GadgetAusWertTab		*NextMode
		dc.w	GG_DeleteAll-.GadgetAusWertTab		*DeleteAll


*-----------------------------------------------------------------------------*
GG_Mode:	addq.l	#1,d5
		move.b	d5,Mode(a5)
		bsr	DeletelistNodes
		bsr	DeleteListen
		bsr	MakeList
		bsr	MakeListen
		bsr	ErlaubeGadgets
		rts

*-----------------------------------------------------------------------------*
GG_NextMode:	move.b	Mode(a5),d5
		cmp.b	#Mode_MaxId,d5
		bne.s	.NormalInc
		moveq	#0,d5
.NormalInc:	addq.w	#1,d5
		move.b	d5,Mode(a5)
		bsr	DeletelistNodes
		bsr	DeleteListen

		lea	MyTags(a5),a3
		move.l	#GTCY_Active,(a3)+
		subq.l	#1,d5
		move.l	d5,(a3)+
		clr.l	(a3)
		moveq	#EPENr_Mode,d0
		bsr	GetGadgetAdr
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		bsr	MakeList
		bsr	MakeListen
		rts


*-----------------------------------------------------------------------------*
* d5=Nummer
GG_List:	bsr	ListView
		rts
*-----------------------------------------------------------------------------*
* Sendet dem Eagleplayer, falls dieser im Helpmode ist, eine HelpNode
*-----------------------------------------------------------------------------*
* Input: a0=Nodename
* Output:d0=0  --> Node geschickt
SendHelp:	movem.l	d1-a6,-(a7)
		move.l	EPBase(pc),a4
		move.l	EPG_SomePrefs(a4),d1
		btst	#EGPRF_Help,d1
		beq.s	.NoHelp

		*--- Args setzen ---*
		bsr	BerechStringSize
		move.l	d0,ENA_Args2+ENA_Arg1(a5)
		lea	ENA_Args2+ENA_String(a5),a1
		moveq	#32,d1
		bsr	StringCopy
		move.l	#EPNr_FirstEngine,d0
		add.w	EUS_Structure+EUS_UserNr(pc),d0
		move.l	d0,ENA_Args1+ENA_Arg1(a5)

		*--- Kommando an EP schicken ---*
		lea	ENA_Args1(a5),a0
		move.l	a0,d4
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_HelpLink,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage

		moveq	#1,d0
.NoHelp:	seq	d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
GG_AddWas:	lea	Helpnode_Add(pc),a0
		bsr	SendHelp
		beq.s	.Return

		moveq	#EPNr_LoadPlayer,d3
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Player
		moveq	#EPNr_LoadEngine,d3
.Player:	bsr	SendOhneMess
.Return:	rts


*-----------------------------------------------------------------------------*
GG_DelWas:	lea	Helpnode_DelWas(pc),a0
		bsr	SendHelp
		beq.s	.Return

		move.l	SelectedEntry(a5),d0
		moveq	#EPNr_DeletePlayer,d3
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Player
		moveq	#EPNr_DeleteEngine,d3
		bsr	GetEngineNr
.Player:	moveq	#0,d1
		bsr	SendMess
		bsr	EinTragNeu
.Return:	rts

*-----------------------------------------------------------------------------*
GG_DeleteAll:	lea	Helpnode_DeleteAll(pc),a0
		bsr	SendHelp
		beq.s	.Return

		moveq	#EPNr_DeleteAllPlayer,d3
		cmp.b	#Mode_Player,Mode(a5)
		*beq.s	.Player
		*moveq	#EPNr_DeleteAllEngines,d3
		bne.s	.Return
.Player:	bsr	SendOhneMess
		bsr	EintragNeu
.Return:	rts

*-----------------------------------------------------------------------------*
GG_Config:	lea	Helpnode_Config(pc),a0
		bsr	SendHelp
		beq.s	.Return

		move.l	SelectedEntry(a5),d0
		moveq	#EPNr_PlayerConfig,d3
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Player


		bsr	GetEngineNr
		move.l	d0,d4

		bsr	GetEUSStruct
		bne.s	.TaskUser
		move.l	#EPNr_EngineConfig,d3
		move.l	EUS_TagList(a1),a0
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	#EUT_Config,d0
		jsr	ENPP_FindTag(a4)
		bne.s	.TagUser
.TaskUser:	move.l	#EPNr_EngineShowState,d3
.TagUser:	move.l	d4,d0
.Player:	moveq	#-1,d1
		bsr	SendMess
.Return:	rts


*-----------------------------------------------------------------------------*
GG_LoadConfig:	lea	Helpnode_LoadConfig(pc),a0
		bsr	SendHelp
		beq.s	.Return

		move.l	SelectedEntry(a5),d0
		moveq	#EPNr_LoadPlayerConfig,d3
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Player
		moveq	#EPNr_LoadEngineConfig,d3
		bsr	GetEngineNr
.Player:	moveq	#0,d1
		bsr	SendMess
.Return:	rts

*-----------------------------------------------------------------------------*
GG_SaveConfig:	lea	Helpnode_SaveConfig(pc),a0
		bsr	SendHelp
		beq.s	.Return

		move.l	SelectedEntry(a5),d0
		moveq	#EPNr_SavePlayerConfig,d3
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Player
		moveq	#EPNr_SaveEngineConfig,d3
		bsr	GetEngineNr
.Player:	moveq	#0,d1
		bsr	SendMess
.Return:	rts

**-----------------------------------------------------------------------------*
*GG_Activate:	cmp.b	#Mode_Engines,Mode(a5)
*		bne.s	.Return
*		bsr	GetEngineNr
*		moveq	#1,d1
*		moveq	#EPNr_Engine,d3
*		bsr	SendMess
*.Return:	rts
*
**-----------------------------------------------------------------------------*
*GG_DeActivate:	cmp.b	#Mode_Engines,Mode(a5)
*		bne.s	.Return
*		bsr	GetEngineNr
*		moveq	#0,d1
*		moveq	#EPNr_Engine,d3
*		bsr	SendMess
*.Return:	rts
*

*-----------------------------------------------------------------------------*
GG_TogglePlayer:move.l	SelectedEntry(a5),d0
		moveq	#EPNr_PlayerState,d3
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Ja
		moveq	#EPNr_Engine,d3
		bsr	GetEngineNr
.Ja:		moveq	#-1,d1
		bsr	SendMess
		bsr	DeletelistNodes
		bsr	DeleteListen
		bsr	ErlaubeGadgets
		bsr	MakeList
		bsr	MakeListen
.Return:	rts



*-----------------------------------------------------------------------------*
* Der Eintrag mu refresht werden.
EinTragNeu:	bsr	ErlaubeGadgets
		bsr	DeleteListen
		bsr	MakeListen
		rts


*-----------------------------------------------------------------------------*
* Eine Message wird an den Eagleplayer gesendet.
* Input: d0=Wert fr Arg1 = Nummer
*	 d1=Wert fr Arg2
*	 d3=EPNr_Nummer
SendMess:	movem.l	d0-a6,-(a7)
		lea	ENA_Args1(a5),a0
		move.l	d0,ENA_Arg1(a0)
		clr.l	ENA_Size(a0)
		lea	ENA_Args2(a5),a1
		move.l	d1,ENA_Arg1(a1)
		clr.l	ENA_Size(a1)
		move.l	a1,(a0)
		move.l	a0,d4			-> Args
		moveq	#0,d1
		moveq	#USClass_Command,d2
		moveq	#0,d5
		bsr	SendeOneMessage
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Eine Message wird ohne Args an den Eagleplayer gesendet.
* Input: d3=EPNr_Nummer
SendOhneMess:	movem.l	d0-a6,-(a7)
		moveq	#0,d4
		moveq	#0,d1
		moveq	#USClass_Command,d2
		moveq	#0,d5
		bsr	SendeOneMessage
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
GetEngineNr:	movem.l	d1/a0,-(a7)
		move.l	SelectedEntry(a5),d0
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		lea	EPG_FirstUserStruct(a0),a0
		subq.l	#1,d0
		blt.s	.Error
.NextEngine:	move.l	(a0),d1
		beq.s	.Error
		move.l	d1,a0
		dbf	d0,.NextEngine
		move.l	UPRgS_EngineNr(a0),d0	
		bra.s	.Return
.Error:		moveq	#0,d0
.Return:	movem.l	(a7)+,d1/a0
		rts

******************************************************************************
*---------------- Auswertung einer UserProgram-Message ----------------------*
******************************************************************************
*
*	Achtung 2. Ausgang der Routine bei Exit !!!!!!!!!!!!
*	Achtung 3. Ausgang der Routine bei UserQuitEagle !!!!!!!!!!!!
*
UserMessage:
		if Executable+Debugger
	;	lea	TextPuffer(a5),a0		;Sicherheitshalber
		move.l	d0,a1
		cmp.l	#USM_UserPrg,UM_Type(a1) ;Test auf Analyzer-MSG
		beq.w	.Auswertung
		cmp.l	#USM_Eagleplayer,UM_Type(a1) ;Test auf Analyzer-MSG
		bne.w	.ReplyIt3

	*--------------- Es ist ein Message angekommen ------------*
.Auswertung:	moveq	#0,d0
		move.w	UM_UserNr(a1),d0

		move.l	UM_ArgString(a1),UPrg_Struct(a5)
		moveq	#0,d0
		moveq	#0,d7
		move.w	UM_Class(a1),d7
		beq.w	.ReplyIt
		cmp.w	#USClass_NewUserPrg,d7
		beq.w	.NewConfig			;.NewUserPrg
		cmp.w	#USClass_Activate,d7
		beq.w	.Activate
		cmp.w	#USClass_Show,d7
		beq.w	.OpenWindow
		cmp.w	#USClass_DeActivate,d7
		beq.w	.DeActivate
		cmp.w	#USClass_Hide,d7
		beq.w	.CloseWindow
		cmp.w	#USClass_ZipWin,d7
		beq.w	.ZipWindow
		cmp.w	#USClass_UnZipWin,d7
		beq.w	.UnZipWindow
		cmp.w	#USClass_NewConfig,d7
		beq.w	.NewConfig
		cmp.w	#USClass_GetConfig,d7
		beq.w	.GetConfig
		cmp.w	#USClass_Exit,d7
		beq.w	.Exit
		cmp.w	#USClass_RemPlayerList,d7
		beq.w	.RemList
		cmp.w	#USClass_RemEnginesList,d7
		beq.w	.RemList
		cmp.w	#USClass_NewPlayer,d7
		beq.w	.AddList
		cmp.w	#USClass_NewEngineLoaded,d7
		beq.s	.AddList
		cmp.w	#USClass_SetWaitPointer,d7
		beq.w	.WaitPointer
		cmp.w	#USClass_ClearWaitPointer,d7
		beq.w	.ClearPointer
		cmp.w	#USClass_NewPreference,d7
		beq.w	.NewPreference
		cmp.w	#USClass_SaveConfig,d7
		beq.w	.SaveConfig
		cmp.w	#USClass_NewModule,d7
		beq.w	.NewModule
		cmp.w	#USClass_KillModule,d7
		beq.w	.KillModule
		moveq	#0,d0
		bra.w	.ReplyIt

.KillModule:	move.b	#1,KillWS(a5)
.NewModule:	movem.l	d7/a1,-(a7)
		moveq	#EPENr_List,d0
		bsr	RemList

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	EPG_FirstPlayerStruct(a4),a3
		move.l	EPG_PlayerList(a4),a0
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.NM_Player
		move.l	EPG_EngineList(a4),a0
		lea	EPG_FirstUserStruct(a4),a3
.NM_Player:	moveq	#EPENr_List,d0
		bsr	ReAddlist
		clr.b	KillWS(a5)
		movem.l	(a7)+,d0/a1
		bra.w	.ReplyIt


.Remlist:	bsr	DeletelistNodes
		bra.w	.ReplyIt		;Message replyen

.AddList:	*move.l	bsr	ChangeNowListViews
		bsr	EinTragNeu
		*bsr	DeletelistNodes
		bsr	MakeList
		bra.w	.ReplyIt		;Message replyen
		

	*------- Ankommende Message sagt : "EXIT" -------*
.Exit:		move.w	#1,ExitNow(a5)
		bra.w	.ReplyIt		;Message replyen

	*----- Es wurde ein neue Config eingestellt -----*
.NewConfig:	move.w	EUS_Structure+EUS_Flags(pc),d0
		btst	#EUSF_Activate,d0
		beq.s	.Deactivate
		btst	#EUSF_Show,d0
		beq.s	.Iconify
		btst	#EUSF_ZipWin,d0
		bne.s	.ZipWindow
		bra.s	.OpenWindow

.Iconify:	bsr	CloseWin
		moveq	#USClass_Hide,d0
		bra.s	.ReplyIt

	*- Der Eagleplayer mchte gerne die Config haben -*
.GetConfig:	bsr	MerkWindowSize
		moveq	#USClass_GetConfig,d0
		bra.s	.ReplyIt



	*------ Ankommende Message sagt : "CLOSE MY WINDOW" -----*
.DeActivate:	moveq	#USClass_DeActivate,d7
.CloseWindow:	move.l	d7,-(a7)
		bsr	CloseWin
		move.l	(a7)+,d0
		bra.s	.ReplyIt
				
	*------ Angekommende Message sagt : "OPEN MY WINDOW" -----*
.Activate:
.OpenWindow:	move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Iconify,d0
		bne.s	.CloseWindow

		*move.w	EUS_Structure+EUS_Flags(pc),d0
		*btst	#EUSF_Show,d0
		*beq.s	.Activated
		bsr.w	OpenWin
		tst.l	d0
		beq.s	.CloseWindow
.Activated:	moveq	#USClass_Activate,d0
		bra.w	.ReplyIt

		*--- Im Eagleplayer "Help" gedrckt" ----*
.NewPreference:	cmp.l	#EPNr_Help,UM_Command(a1)
		bne.s	.ReplyIt
		bsr	ErlaubeGadgets
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "Zip my Window" -------*
.SaveConfig:	move.l	d7,-(a7)
		bsr	SaveManConfig
		move.l	(a7)+,d0
		bra.s	.ReplyIt


.WaitPointer:	bsr	WaitPointer
		bra.w	.ReplyIt

.ClearPointer:	bsr	ClearPointer
		bra.w	.ReplyIt


	*------ Ankommende Message sagt : "Zip my Window" -------*
.ZipWindow:	*bsr.w	ZipMyWindow
		moveq	#USClass_ZipWin,d0
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "UnZip my Window" -----*
.UnZipWindow:	*bsr.w	UnZipMyWindow
		moveq	#USClass_UnZipWin,d0


	*------- Message frs Replyen vorbereiten ------*
	*----------------- Class setzen ----------------*
.ReplyIt:	bsr.w	FreeCommandStruct
		move.l	a1,d1
		beq.s	.NoMSG
		clr.l	UM_Argstring(A1)
		move.l	a1,a0
		*move.l	UM_StructAdr(a1),StructAdr(a5)
		move.w	d0,UM_Class(a1)			;Dummy setzen
.ReplyIt3:	move.l	a1,d0
		beq.s	.NoMSG
		move.l	MSgPort(a5),a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.ClearMerk
		EB
		jsr	_LVOReplymsg(a6)
.NoMSG:		rts

.ClearMerk:	subq.l	#1,MsgUnterwegs(a5)
		*bsr	freemsg			;meine Message, also freigeben
	endc
		rts

*-----------------------------------------------------------------------------*
MerkWindowSize:	movem.l	d0-a6,-(a7)
		lea	EUS_Structure(pc),a2
		move.w	EUS_Flags(a2),d0
		bclr	#EUSF_OpenWin,d0		*Flags
		move.l	WinHandle(a5),d1
		beq.s	.GetNoWindow
		or.w	#EUSB_OpenWin,d0

		move.w	WinPosX(a5),eus_winx(a2)	;Save Windowpostion
		move.w	WinPosY(a5),eus_winy(a2)
		move.w	WinWidth(a5),EUS_Special(a2)	;Save Windowpostion
		move.w	WinHeight(a5),EUS_Special+2(a2)
		move.w	ZoomposX(a5),Zoomx(a2)
		move.w	ZoomposY(A5),Zoomy(a2)
		move.b	Zoomstate(a5),ZoomONOFF(a2)
		*move.b	Onsysfont(A5),Sysfontonoff(a2)
		move.b	Mode(a5),EUSMode(a2)

.GetNoWindow:	move.w	d0,EUS_Flags(a2)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
WaitPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return
		tst.w	WindowDisabled(a5)
		bne.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	ENPP_SetWaitPointer(a4)

		move.w	#1,WindowDisabled(a5)

.Return:	movem.l	(sp)+,a0/a1/a4/d0
		rts


*-----------------------------------------------------------------------------*
ClearPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.w	WindowDisabled(a5)
		beq.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	ENPP_ClearWaitPointer(a4)


.Return:	clr.w	WindowDisabled(a5)
		movem.l	(sp)+,a0/a1/a4/d0
		rts





*------------------------------- TextRequest ---------------------------------*
* Input: d0=LocaleNummer						      *
*-----------------------------------------------------------------------------*
TextRequest:	movem.l	d0-a6,-(a7)
		bsr	GetLocaleString
		sub.l	a3,a3					*Arguments

		move.l	IntBase(a5),a6
		lea	My_Easystruct(a5),a1
		move.l	d0,es_textformat(a1)

		moveq	#LENr_Ok,d0
		bsr	GetLocaleString
		move.l	d0,ES_GadgetFormat(a1)
		moveq	#LENr_RequestTitle,d0
		bsr	GetLocaleString
		move.l	d0,es_Title(a1)
		move.l	Winhandle(a5),a0		;*Window
		suba.l	a2,a2				;*IDCMP_ptr
		jsr	_LVOEasyRequestArgs(a6)		;!! durch Reqtools
							;ersetzen
		movem.l	(sp)+,d0-a6	
		rts



*----------------------- Listview-Gadget wurde gedrckt ----------------------*
ListView:	

		move.l	StartSeconds(a5),d0
		move.l	StartMicros(a5),d1
		move.l	CurrentSeconds(a5),d2
		move.l	CurrentMicros(a5),d3
		move.l	d2,StartSeconds(a5)
		move.l	d3,StartMicros(a5)
		move.l	SelectedEntry(a5),d4
		addq.l	#1,d5
		*move.l	d5,SelectedEntry(a5)


		*--- Wenn Eagleplayer im Helpmode ---*
		*--- Kommando an EP schicken fr  ---*
		*--- Helpnode                     ---*
		move.l	EPBase(pc),a4
		move.l	EPG_SomePrefs(a4),d6
		btst	#EGPRF_Help,d6
		bne.s	.Help


		cmp.w	d4,d5
		bne.w	.EinfacherKlick
		move.l	IntBase(a5),a6
		jsr	_LVODoubleClick(a6)

	*------ Listviews & Stringgadgets refreshen ------*
		cmp.l	#1,d0			--> Einfacher Klick
		bne.w	.Return
		clr.l	StartSeconds(a5)
		clr.l	StartMicros(a5)

		bsr	GG_TogglePlayer
		bra.s	.Return


		*-----------------------------------------------
		* Eine Message wird an den Eagleplayer gesendet.
		* Input: d0=Wert fr Arg1 = Nummer
		*	 d1=Wert fr Arg2
		*	 d3=EPNr_Nummer
.Help:		bsr.s	.EinfacherKlick
		move.l	#EPNr_HelpLink,d3		*EP-Kommando
		move.l	SelectedEntry(a5),d0		*Playernummer
		add.w	#EPNr_FirstPlayer,d0
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Hlp_Player
		bsr	GetEngineNr
		add.w	#EPNr_FirstEngine-1,d0
.Hlp_Player:	moveq	#0,d1
		bsr	SendMess
		bra.s	.Return




.EinfacherKlick:move.l	d5,d0			--> Nummer
		bsr.w	ChangeNowListViews
.Return:	rts




*-----------------------------------------------------------------------------*
* d0=Neue Nummer (des angewhlten Labels)
ChangeNowListViews:
		movem.l	d1-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		cmp.l	SelectedEntry(a5),d0
		beq.s	.Return
		move.l	d0,SelectedEntry(a5)

		bsr	DeleteListen

		bsr	ErlaubeGadgets


		*--- Gadgets sperren oder erlauben ---*
		*--- Anderen Anzeigelistviews fllen ---*
		subq.l	#1,d0
		lea	MyTags(a5),a3
		move.l	#GTLV_Selected,(a3)+
		move.l	d0,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	d0,(a3)+
		clr.l	(a3)
		moveq	#EPENr_List,d0
		bsr	GetGadgetAdr
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		bsr.w	MakeListen

.Return:	movem.l	(a7)+,d1-a6
		rts


*-----------------------------------------------------------------------------*
ErlaubeGadgets:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		lea	.GG-((Mode_MaxId+1)*2)(pc),a3
.NextGadget:	lea	((Mode_MaxId+1)*2)(a3),a3
		tst.w	(a3)
		beq.s	.Return
		lea	.GG(pc),a1
		move.w	2(a3),d0
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Player
		move.w	4(a3),d0
.Player:	lea	(a1,d0.w),a1			*d1=Zustand der Nr.

		moveq	#0,d1
		move.l	EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Help,d0
		bne.s	.Help
		jsr	(a1)
.Help:		move.w	(a3),d0
		bsr	SetzeGadget
		bra.s	.NextGadget


.Return:	movem.l	(a7)+,d0-a6
		rts

.GG:		dc.w	EPENr_Delete,EPG_Delete-.GG,EEG_Delete-.GG
		dc.w	EPENr_LoadConfig,EPG_LoadConfig-.GG,EEG_LoadConfig-.GG
		dc.w	EPENr_SaveConfig,EPG_SaveConfig-.GG,EEG_SaveConfig-.GG
		dc.w	EPENr_Config,EPG_Config-.GG,EEG_Config-.GG
		dc.w	0


EPG_Delete:	moveq	#1,d1
		bsr	GetPlayerTagList
		bne.s	.Dummy
		move.l	#DTP_InternalPlayer,d0
		bsr	FindTag
		beq.s	.Error
.Dummy		moveq	#0,d1
.Error:		rts


EEG_Delete:	*moveq	#1,d1
		*bsr	GetEUSStruct
		*bne.s	.Error
		moveq	#0,d1
.Error:		rts

EPG_LoadConfig:	moveq	#1,d1
		bsr	GetPlayerTagList
		bne.s	.Error
		move.l	#EP_LoadPlConfig,d0
		bsr	FindTag
		bne.s	.Error
		moveq	#0,d1
.Error:		rts

EEG_LoadConfig:	moveq	#1,d1
		bsr	GetEUSStruct
		bne.s	.Error
		move.l	EUS_MsgFlags(a1),d0
		btst	#USMF_LoadConfig,d0
		beq.s	.Error
		moveq	#0,d1
.Error:		rts


EPG_SaveConfig:	moveq	#1,d1
		bsr	GetPlayerTagList
		bne.s	.Error
		move.l	#EP_SavePlConfig,d0
		bsr	FindTag
		bne.s	.Error
		moveq	#0,d1
.Error:		rts

EEG_SaveConfig:	moveq	#1,d1
		bsr	GetEUSStruct
		bne.s	.Error
		move.l	EUS_MsgFlags(a1),d0
		btst	#USMF_SaveConfig,d0
		beq.s	.Error
		moveq	#0,d1
.Error:		rts

EPG_Config:	moveq	#1,d1
		bsr	GetPlayerTagList
		bne.s	.Error
		move.l	#DTP_UserConfig,d0
		bsr	FindTag
		bne.s	.Error
		moveq	#0,d1
.Error:		rts

EEG_Config:	moveq	#1,d1
		bsr	GetEUSStruct
		bne.s	.Error
		move.l	EUS_MsgFlags(a1),d0
		btst	#USMF_Configuration,d0
		bne.s	.Ok

		move.l	EUS_TagList(a1),a0
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	#EUT_Config,d0
		jsr	ENPP_FindTag(a4)
		moveq	#1,d1
		tst.l	d0
		beq.s	.Error

.Ok		moveq	#0,d1
.Error:		rts


*---------------------------- Setze dieses Gadget ----------------------------*
* Input: d0=Nummer des Gadgets
*	 d1=Zustand
*-----------------------------------------------------------------------------*
SetzeGadget:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		bsr	GetGadgetAdr			*a0=Gadgetadr
		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)+
		move.l	d1,(a3)+
		clr.l	(a3)
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
		
.Return:	movem.l	(a7)+,d0-a6
		rts




*-----------------------------------------------------------------------------*
OpenWin:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5
		tst.l	WinHandle(a5)
		bne.s	.WindowDa

		lea	BackPicItemFlags(pc),a0
		move.b	EUS_Structure+BackPicFlags(pc),d0
		btst	#0,d0
		beq.s	.NoHaken
		or.w	#CHECKED,(a0)
.NoHaken:


		move.l	Intbase(a5),a6
		bsr	LockPubscreen		;Public Screen holen
		bne	.Error
		bsr	SetUpWin		;Fenster ffnen
		tst.l	d0
		bne.s	.Error

		bsr	DeletelistNodes
		bsr	EinTragNeu
		bsr	MakeList

		*moveq	#EPENr_List,d0
		*bsr	remlist
		*moveq	#EPENr_List,d0
		*bsr	readdlist
		*bsr	UpdateInfoGadget
.Error:	
.WindowDa	move.l	WinHandle(a5),d0
		movem.l	(a7)+,d1-a6
		rts


UpdateInfoGadget
		rts

*-----------------------------------------------------------------------------*
* Fenster ffnen, mit Menu & Gadgets sowie Sizeanpassung		      *
* Input: --								      *
* Output: d0=Error oder NULL						      *
*-----------------------------------------------------------------------------*
SetUpWin:	movem.l d1-a6,-(sp)
		clr	TmpWidth(a5)
		clr	TmpHeight(a5)

		bsr	InitLocale


		moveq	#0,d0
		move.b	Mode(a5),d0
		subq.w	#1,d0
		move.w	d0,Mode_Tag+6

		move.l	MyPubscreen(a5),d0
		beq.w	.Error
		move.l	d0,a0
		move.l	SC_Font(a0),a1
		move.w	TA_YSize(a1),d3
		addq.w	#1,d3
		move.b	sc_WBorTop(a0),d0
		ext.w	d0
		add.w	d3,d0
		move.w	d0,OffY(a5)

		move.b  SC_WBorLeft(a0),d0
		ext.w   d0
		move.w	d0,Offx(a5)

		move.l	sc_RastPort+rp_Font(a0),a0
		lea	MyFont(a5),a1
		move.l	a1,Font(a5)
		move.l  LN_Name(a0),ta_Name(a1)
		move.w  tf_YSize(a0),ta_YSize(a1)
		move.w  tf_XSize(a0),FontX(a5)
		move.w  tf_YSize(a0),FontY(a5)
		clr.w	6(a1)


		bsr	BerechMinWindowSize


	*--------------- Gre des Fensters festlegen --------------*
		moveq	#0,d2
		moveq	#0,d3
		move.w	EUS_Structure+EUS_Special(pc),d2
		move.w	EUS_Structure+EUS_Special+2(pc),d3
		bne.s	.NimmDiese

		moveq	#0,d0			*Keine Eintragung
		move.w	FontY(a5),d0		*--> Fonthhe *6
		mulu	#6,d0
		add.w	d0,d3
		move.l	#200,d2

		*----- Ist diese Gre erlaubt ? -----*
.NimmDiese:	cmp.w	Win_MinHeight+2(pc),d3
		bhi.s	.HeightOk
		move.l	Win_MinHeight(pc),d3
.HeightOk:	cmp.w	Win_MinWidth+2(pc),d2
		bhi.s	.WidthOk
		move.l	Win_MinWidth(pc),d2
.WidthOk:	move.l	mypubscreen(A5),a0
		move.l	d2,ahawidth
		move.l	d3,ahaheight

		*--- Pat Window in Screen ---*
		move.l	d2,d0
		move.l	d0,d4
		moveq	#0,d2
		add.w	d2,d0
		add.w	OffX(a5),d0
		move.b	sc_WBorRight(a0),d1
		ext.w	d1
		add.w	d1,d0
		cmp.w	sc_Width(a0),d0
		bls.s	.WinWidthOk
		move.w	sc_Width(a0),d0
		sub.w	d4,d0
		move.w	d0,d2			*-> nein, jetzt
.WinWidthOk:	move.l	d3,d0
		move.l	d0,d4

		*-- Menus creieren ---*
		move.l	GadBase(a5),a6
		lea	Menus(pc),a0
		lea	MenuTags(pc),a1
		jsr	_LVOCreateMenusA(a6)
		move.l	d0,MenuAdr(a5)
		tst.l	d0
		beq	.Error
		move.l	d0,a0
		move.l	VisualInfo(a5),a1
		lea	MenuTags(pc),a2
		jsr	_LVOLayoutMenusA(a6)

		moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		moveq	#0,d7
		move	WinPosX(a5),d0
		move	WinPosY(a5),d1
		move	ZoomPosX(a5),d2
		move	ZoomPosY(a5),d3
		move.l	ahawidth(pc),d4
		move.l	ahaheight(pc),d5
		*move.l	#ZoomWidth,d6

		move.l	mypubscreen(A5),a0
		lea	sc_RastPort(a0),a0
		move.l	rp_Font(a0),a0
		move.w  tf_XSize(a0),d6
		mulu	#ZoomWidth,d6
		addq	#4,d6
		lsr	#3,d6
		move	OffY(a5),d7
		tst.b	ZoomState(a5)
		beq.s	.Normal
		exg.l	d0,d2
		exg.l	d1,d3
		exg.l	d4,d6
		exg.l	d5,d7
.normal:	lea	WindowTags(pc),a1
		move.l	d0,Win_LeftPos-WindowTags(A1)
		move.l	d1,Win_TopPos-WindowTags(A1)
		move.l	d4,Win_Width-WindowTags(A1)
		move.l	d5,Win_Height-WindowTags(A1)
		move.w	d2,ZoomStruct-WindowTags(A1)
		move.w	d3,ZoomStruct+2-WindowTags(A1)
		move	d6,ZoomStruct+4-WindowTags(A1)
		move	d7,ZoomStruct+6-WindowTags(A1)

		move.l	IntBase(A5),a6
		move.l	MyPubScreen(a5),Pubadr-WindowTags(a1)
		suba.l	a0,a0
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,Winhandle(a5)
		tst.l	d0
		beq	.OpenWindowError

		move.l	WinHandle(a5),a0
		move.w	wd_leftedge(a0),WinPosX(a5)
		move.w	wd_topedge(a0),WinPosY(a5)
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)

		move.l	d0,a0
		move.l	WD_RPort(a0),a0
		move.l	a0,MyRastPort(a5)

		bsr	InitBackdrop

		if	Usefillwindow+BackPic
		bsr	ClearWindow
		endc

		bsr	InitGadgets
		bne	.GadgetError

		bsr	RedrawGadgets

		bsr	AddGads
		bne	.GadgetError

		bsr	ErlaubeGadgets

		move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	_LVOSetMenuStrip(a6)

		move.l	Winhandle(a5),a0
		move.l	WD_Userport(a0),a0	;User Port
		move.l	a0,WindowPort(a5)
		moveq	#0,d0

	*--------------- SignalBits setzen ---------------*
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)
		moveq	#0,d0


.SetUpReturn:	movem.l	(sp)+,d1-a6
		tst.l	d0
		rts

.GadgetError	bsr	Closedownwindow
.OpenWindowError:bsr	FreeMenus
.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.SetUpReturn




*----------------------------- Window lschen --------------------------------*
ClearWindow:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.w	.Return
		tst.l	MyRastPort(a5)
		beq.w	.Return

		tst.l	DT_PicObject(a5)
		bne	.DT_CopyTiledBitMap

		move.l	winhandle(A5),a1
		move.w	wd_width(A1),d2		;x2
		moveq	#0,d0
		move.b	wd_borderright(a1),d0
		sub.w	d0,d2

		move.w	wd_height(a1),d3
		moveq	#0,d0
		move.b	wd_borderbottom(a1),d0
		sub.w	d0,d3

		move.w	Offx(a5),d0		;x1
		move.w	Offy(A5),d1		;y1

		bsr	ClearRectangle
		bra.s	.Refresh

.DT_CopyTiledBitMap:
		bsr	BackFill
.Refresh:
		move.l	winhandle(A5),a0
		move.l	IntBase(a5),a6
		jsr	_LVORefreshwindowframe(A6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*--------------- lscht den angegebenen Bereich --------------------*
* Input: D0 = Leftedge
*        D1 = Topedge
*        D2 = Width
*        D3 = Height
ClearRectangle:
		push	all
		move.l	GFXBase(a5),a6

		move.l	Winhandle(a5),d4
		beq	.fail
		move.l	d4,a1

		push	d0-d3

		move.l	wd_rport(a1),a1
		move.l	a1,a3
		moveq	#0,d0
		jsr	_LVOsetapen(a6)

		move.l	a3,a1
		moveq	#0,d0
		jsr	_LVOsetbpen(A6)

		move.l	a3,a1
		moveq	#1,d0			;RP_Jam2
		jsr	_LVOsetdrmd(a6)

		pop	d0-d3
		add	d0,d2
		add	d1,d3
		move.l	a3,a1
		jsr	_LVOrectfill(a6)
.fail
		pop	all
		rts

*-----------------------------------------------------------------------------*
*        Alle Gadgets, die Text enthalten lschen wg. Hintergrundbild         *
*        die Positionen werden aus den NewGadget-Strukturen gezogen           *
*-----------------------------------------------------------------------------*
RedrawGadgets:
		push	all
		lea	Refreshed_Gads(pc),a4
.loop
		move.l	(a4)+,d0		;Adresse Gadget
		beq	.return
		move.l	d0,a0

		move.w	(a4)+,d1		;Flagbit holen, Indikator ob an oder aus
		move	d1,d2

		move.w	gng_LeftEdge(a0),d0

		move.w	gng_TopEdge(a0),d1
		add.w	OffY(a5),d1
		addq.w	#GadgetYAbstand,d1

		add.w	OffX(a5),d0
		addq.w	#GadgetXAbstand,d0

		moveq	#0,d3
		move.w	gng_Height(a0),d3
		and	#$8000,d2
		beq.s	.nolist
		sub	#ListviewBorder,d3
		move.l	font(a5),a1
		move	ta_ysize(a1),d2
		divu	d2,d3
		mulu	d2,d3
		add	#ListviewBorder,d3
.nolist
		move.w	gng_Width(a0),d2
		bsr	ClearRectangle

		bra	.loop
.return
		pop	all
		rts
;*----------------------------- Window lschen --------------------------------*
;ClearWindow:	movem.l	d0-a6,-(a7)
;		tst.l	WinHandle(a5)
;		beq.w	.Return
;		tst.l	MyRastPort(a5)
;		beq.w	.Return
;
;		tst.l	DT_PicObject(a5)
;		bne	.DT_CopyTiledBitMap
;
;		move.l	GFXBase(a5),a6
;		move.l	Winhandle(a5),a1
;		move.l	wd_rport(a1),a1
;		moveq	#0,d0
;		jsr	_LVOsetapen(a6)
;
;		move.l	winhandle(A5),a1
;		move.l	wd_rport(a1),a1
;		moveq	#0,d0
;		jsr	_LVOsetbpen(A6)
;
;		move.l	winhandle(A5),a1
;		move.l	wd_rport(a1),a1
;		moveq	#1,d0			;RP_Jam2
;		jsr	_LVOsetdrmd(a6)
;
;		move.b	rp_areaptsz(a1),d4
;		move.l	rp_areaptrn(a1),d5
;
;		move.l	winhandle(A5),a1
;		move.w	wd_width(A1),d2		;x2
;		moveq	#0,d0
;		move.b	wd_borderright(a1),d0
;		sub.w	d0,d2
;
;		move.w	wd_height(a1),d3
;		moveq	#0,d0
;		move.b	wd_borderbottom(a1),d0
;		sub.w	d0,d3
;
;		move.l	wd_rport(a1),a1
;
;		move.w	Offx(a5),d0		;x1
;		move.w	Offy(A5),d1		;y1
;		jsr	_LVOrectfill(a6)
;		bra.s	.Refresh
;
;.DT_CopyTiledBitMap
;		bsr	BackFill
;.Refresh
;		move.l	winhandle(A5),a0
;		move.l	IntBase(a5),a6
;		jsr	_LVORefreshwindowframe(A6)
;
;.Return:	movem.l	(a7)+,d0-a6
;		rts
;
*-----------------------------------------------------------------------------*
SaveManConfig:	movem.l	d1-a6,-(a7)

	*ifeq	test
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	*else
	*	move.l	#Configdir,d1
	*endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		lea	ConfigName(pc),a1
		move.l	a1,d1
		move.l	#1006,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Return

	*----------- Nun Config Schritt fr Schritt speichern ---------*
		lea	ConfigDatas(a5),a0
		move.l	#ConfigDatasEnd-ConfigDatas,d3
		move.l	d6,d1
		move.l	a0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOWrite(a6)

		*--- Datei Closen ---*
		move.l	d6,d1
		beq.s	.AllesOk
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
LoadConfig:	movem.l	d1-a6,-(a7)

	ifeq	test
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Configdir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		lea	ConfigName(pc),a1
		move.l	a1,d1
		move.l	#1005,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Return

	*----------- Nun Config Schritt fr Schritt speichern ---------*
		lea	ConfigDatas(a5),a0
		move.l	#ConfigDatasEnd-ConfigDatas,d3
		move.l	d6,d1
		move.l	a0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)

		*--- Datei Closen ---*
		move.l	d6,d1
		beq.s	.AllesOk
		move.l	d0,-(a7)
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)
		move.l	(a7)+,d1
		moveq	#EPR_ErrorInFile,d0
		cmp.l	d0,d3
		bne.s	.Return

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Init Backdrop (fr OpenWindow)
*-----------------------------------------------------------------------------*
InitBackdrop:	movem.l	d0-a6,-(a7)

	*-------- Halfshine Pen fr Hintergrund anfordern oder Pic Init ----------------*
		move.l	#-1,mypen(A5)

		move.b	BackPicFlags+EUS_Structure(pc),d0
		and.b	#1,d0			;Bit 1 = Back Pic
		beq.s	.pen

		bsr	DT_OpenPicture		;Bild ffnen
		bne.s	.Return			;bei Fehler dann doch Pen
.pen
		move.l	GFXBase(A5),a6
		cmp.w	#39,lib_version(A6)
		blo	.Return

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		move.l	a0,mycmap(A5)
		moveq	#-1,d0			;Number
		move.l	#123<<24,d1		;Red
		move.l	#123<<24,d2		;Green
		move.l	#123<<24,d3		;Blue

		lea	Mytags(A5),a1
		move.l	#OBP_Precision,(a1)
		move.l	#PRECISION_GUI,4(a1)
		clr.l	8(A1)
		jsr	_LVOObtainBestPenA(A6)
		move.l	d0,MyPen(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
BackFill:
*		tst.l	DT_PicObject(a5)
*		bne	.DT_CopyTiledBitMap
*
*		movem.l	d0-a6,-(a7)
*		move.l	WinHandle(a5),a4
*		move.l	WD_RPort(a4),a1
*
*		move.l	myPen(a5),d0
*		bpl.s	.yup
*		moveq	#0,d0
*.yup
*		move.l	GFXBase(a5),a6
*		jsr	_LVOSetAPen(a6)			; set the pen
*
*		*move.l	winhandle(A5),a1
*		*move.l	wd_rport(a1),a1
*		*moveq	#1,d0
*		*jsr	_LVOsetbpen(A6)
*
*
*		move.l	wd_rPort(a4),a1
*		move.b	wd_borderleft(a4),d0
*		ext.w	d0
*		move.b	wd_bordertop(a4),d1
*		ext.w	d1
*		move.b	wd_borderright(a4),d2
*		ext.w	d2
*		neg.w	d2
*		move.b	wd_borderbottom(a4),d3
*		ext.w	d3
*		neg.w	d3
*		subq	#1,d2
*		subq	#1,d3
*		add.w	wd_width(a4),d2
*		add.w	wd_height(a4),d3
*
*		move.l	GFXBase(a5),a6
*		jsr	_LVOrectfill(a6)		;Hintergrund killen
*
*		movem.l	(a7)+,d0-a6
*		rts

;void CopyTiledBitMap(void)
;Slow but Mem-Saving routine
.DT_CopyTiledBitMap:
		push	d1-d7/a1/a3/a4/a6
		move.l	GFXBase(a5),a6

		move.l	Winhandle(A5),a0
		moveq	#0,d0
		moveq	#0,d1
		move.w	wd_width(a0),d0
		move.b	wd_borderleft(A0),d1
		add.b	wd_borderRight(A0),d1
		sub.l	d1,d0
		move.l	d0,DT_Breit2(A5)
		
		move.w	wd_height(a0),d0
		move.b	wd_bordertop(A0),d1
		add.b	wd_borderbottom(A0),d1
		sub.l	d1,d0
		move.l	d0,DT_Hoehe2(A5)

		moveq	#0,d0
		move.b	wd_borderleft(a0),d0
		move.l	d0,DT_XPos2(a5)

		move.b	wd_borderTop(a0),d0
		move.l	d0,DT_YPos2(a5)

		move.l	DT_MyBitMapheader(a5),a0
		moveq	#0,d0
		move.w	(a0)+,d0
		move.l	d0,a4			; SrcSizeX
		move.w	(a0),d0
		move.l	d0,a3			; SrcSizeY

		moveq	#256-$c0,d6
		neg.b	d6

		move.l	Winhandle(A5),a1
		move.l	WD_Rport(a1),a1
		move.l	a1,-(sp)

		moveq	#0,d2				; dest x
		moveq	#0,d3				; dest y
.MainLoop
		move.l	a4,d4				; SrcSizeX

		move.l	d2,d7				; dest x
		cmp.l	DT_Breit2(A5),d7		; Row copied ?
		blt.s	.Xweit
		add.l	a3,d3				; Yup, next Row
		moveq	#0,d2				; dest x
		moveq	#0,d7
.XWeit
		add.l	d4,d7				; pos x + SrcSizeX
		cmp.l	DT_Breit2(a5),d7		; dest x (left) < DestX+SrcSizeX ?
		blt.s	.skip1
		move.l	DT_Breit2(A5),d4		; DestSizeX
		sub.l	d2,d4				; - Dest X = Dest Left
.skip1		
		move.l	a3,d5
		move.l	d3,d7
		cmp.l	DT_Hoehe2(A5),d7
		bge.s	.YReady
		add.l	d5,d7				; pos y + SrcSizeY
		cmp.l	DT_Hoehe2(a5),d7		; dest y (left) < DestY+SrcSizeY ?
		blt.s	.skip2
		move.l	DT_Hoehe2(A5),d5		; DestSizeY
		sub.l	d3,d5				; - Dest Y = Dest Left
.skip2
		add.l	DT_XPos2(A5),d2			; Xpos + Winborder
		add.l	DT_YPos2(A5),d3			; YPos + Winborder
		move.l	(sp),a1
		move.l	DT_MyBitMap(a5),a0		; Source
		moveq	#0,d0
		moveq	#0,d1
		jsr	_LVOBltBitMapRastport(a6)
		sub.l	DT_XPos2(A5),d2			; del Border
		sub.l	DT_YPos2(A5),d3			; del Border
		add.l	a4,d2
		bra.s	.Mainloop

.YReady:	addq.l	#4,sp
		pop	d1-d7/a1/a3/a4/a6
		rts


*-----------------------------------------------------------------------------*
LoadNewPicture:	movem.l	d0-a6,-(a7)

	*-------- Bild freigeben (wenn vorhanden) -----------------------*
.RetryPic:	bsr	DT_FreePicture

	*-------- Halfshine Pen fr Gadgets freigeben -------------------*
		move.l	GFXBase(a5),a6
		cmp.w	#39,lib_version(A6)
		blo	.kick20
		move.l	mypen(A5),d0
		move.l	mycmap(A5),a0
		jsr	_LVOReleasepen(A6)

	*-------- Halfshine Pen fr Hintergrund anfordern oder Pic Init ----------------*
.Kick20		move.l	#-1,mypen(A5)

		move.b	EUS_Structure+BackPicFlags(pc),d0
		and.b	#1,d0			;Bit 1 = Back Pic
		beq.s	.pen

		bsr	DT_OpenPicture		;Bild ffnen
		bne.s	.kick2			;bei Fehler dann doch Pen
.pen
		move.l	GFXBase(a5),a6
		cmp.w	#39,lib_version(a6)
		blo	.kick2

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		move.l	a0,mycmap(a5)
		moveq	#-1,d0			;Number
		move.l	#123<<24,d1		;Red
		move.l	#123<<24,d2		;Green
		move.l	#123<<24,d3		;Blue

		lea	mytags(A5),a1
		move.l	#OBP_Precision,(a1)
		move.l	#PRECISION_GUI,4(a1)
		clr.l	8(A1)
		jsr	_LVOObtainBestPenA(A6)
		move.l	d0,mypen(A5)
.Kick2		bsr	Resizewindow
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Gibt des Backpic frei
DT_FreePicture:	movem.l	d0-a6,-(a7)

		move.l	DT_PicObject(A5),d0
		beq.s	.fail
		move.l	DTBase(a5),a6
		move.l	d0,a0
		jsr	_LVODisposeDTObject(a6)
		clr.l	DT_PicObject(A5)
		clr.l	DT_MyBitMapheader(a5)
		clr.l	DT_MyBitMap(a5)
.fail		moveq	#0,d0
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input:
* Output:d0=Null=Error d0<>0 ok
*-----------------------------------------------------------------------------*
DT_Filerequest:	movem.l	d1-a6,-(a7)

		lea	MyReqToolsname(pc),a1
		EB
		moveq	#38,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,a6
		tst.l	d0
		beq.w	.Return

		sub.l	a0,a0
		moveq	#0,d0				;Struktur-Type
		jsr	_LVORTAllocRequestA(a6)
		move.l	d0,d7
		beq.s	.fail

		lea	mytags(A5),a0
		move.l	#_RTFI_Dir,(A0)+
		lea	DT_Picturedir(a5),a2
		move.l	a2,(a0)+
		clr.l	(A0)	
		lea	mytags(A5),a0
		move.l	d7,a1
		jsr	_LVORTchangereqattrA(A6)

		move.w	#LENr_SelectBackPic,d0
		bsr	GetLocaleString
		move.l	d0,a3
		lea	DT_Picturename(a5),a2
		lea	mytags(A5),a0
		move.l	#_RT_Window,(a0)+
		move.l	winhandle(a5),(a0)+
	;	move.l	#_RT_LockWindow,(a0)+
	;	move.l	#1,(a0)+
		clr.l	(A0)
		lea	mytags(A5),a0
		move.l	d7,a1
		jsr	_LVORTFilerequestA(A6)
		move.l	d0,d6

		move.l	d7,a1
		move.l	rtfi_Dir(a1),a1
		lea	DT_Picturedir(a5),a0
.copy2		move.b	(a1)+,(a0)+
		bne.s	.copy2

		move.l	d7,a1
		jsr	_LVORTFreerequest(A6)
		move.l	d6,d0

.Fail:		move.l	d0,-(a7)
		move.l	a6,a1
		EB
		jsr	_LVOCloseLibrary(a6)
		move.l	(a7)+,d0
.Return:	pop	d1-a6
		tst.l	d0
		rts

*DT_Backgroundpic:dc.b	`Background picture`,0
*DT_Choosepic	dc.b	`Select Background Picture`,0
		if	test
DT_PicName:	dc.b	`SYS:prefs/patterns/misc`,0
Configdir:	dc.b	"EP:configs/",0
		endc
		even

*-----------------------------------------------------------------------------*
DT_OpenPicture:	movem.l	d1-a6,-(a7)

		moveq	#0,d0
		move.l	DT_PicObject(a5),d1
		bne.w	.fail
		move.l	winhandle(a5),d0
		beq.w	.fail

		move.l	DTBase(a5),d0
		bne.w	.Ok
		lea	Datatypesname(pc),a1
		moveq	#39,d0
		EB
		jsr	_LVOopenlibrary(a6)
		move.l	d0,DTBase(a5)
		tst.l	d0
		beq.w	.Fail
.Ok:


		lea	DT_Picture(a5),a0
		lea	DT_Picturedir(a5),a1
.copy		move.b	(a1)+,(a0)+
		bne.s	.copy
		subq.l	#1,a1

		lea	DT_Picture(a5),a0
		move.l	a0,d1
		lea	DT_Picturename(a5),a0
		move.l	a0,d2
		move.l	#300,d3
		move.l	DosBase(a5),a6
		jsr	_LVOAddPart(A6)

		move.l	DTBase(a5),a6
		lea	mytags(A5),a0
		move.l	#DTA_Sourcetype,(a0)+
		move.l	#DTST_File,(a0)+
		move.l	#DTA_GroupID,(a0)+
		move.l	#GID_Picture,(a0)+
		move.l	#PDTA_Remap,(a0)+
		move.l	#1,(a0)+
		move.l	#PDTA_Screen,(a0)+
		move.l	winhandle(A5),a1
		move.l	wd_WScreen(a1),(a0)+
		move.l	#PDTA_FreeSourceBitMap,(a0)+
		move.l	#1,(a0)+
		move.l	#OBP_Precision,(a0)+
		move.l	#Precision_IMAGE,(A0)+
		clr.l	(a0)+
		lea	mytags(A5),a0

		*ifne	test
		*lea	DT_PicName(pc),a1
		*else
		lea	DT_Picture(a5),a1
		*endc
		move.l	a1,d0
		jsr	_LVONewDTObjectA(A6)
		move.l	d0,DT_PicObject(A5)
		beq.w	.fail

		move.l	#1,-(a7)		;Taglist ??
		move.l	#0,-(a7)		;
		move.l	#DTM_ProcLayout,-(a7)	;
		push	d0
		bsr	_DoMethod	
		add	#4*4,sp
		tst.l	d0
		beq	DT_FreePicture

		lea	mytags(A5),a2
		move.l	#PDTA_BitMapHeader,(a2)+
		lea	DT_MyBitMapheader(a5),a0
		move.l	a0,(a2)+
		move.l	#PDTA_DestBitMap,(a2)+
		lea	DT_MyBitMap(a5),a0
		move.l	a0,(A2)+
		clr.l	(A2)
		lea	mytags(A5),a2
		move.l	DT_PicObject(A5),a0
		move.l	DTBase(a5),a6
		jsr	_LVOGetDTAttrsA(A6)
		cmp.l	#1,d0
		blt	DT_FreePicture
		tst.l	DT_MyBitMap(A5)
		bne.s	.attrok

		lea	mytags(A5),a2
		move.l	#PDTA_BitMap,(a2)+
		lea	DT_MyBitMap(a5),a0
		move.l	a0,(A2)+
		clr.l	(A2)
		lea	mytags(A5),a2
		move.l	DT_PicObject(A5),a0
		jsr	_LVOGetDTAttrsA(A6)
		tst.l	DT_MyBitMap(A5)
		beq	DT_FreePicture
.attrok:	moveq	#1,d0
.fail		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

;ULONG DoMethod( Object *obj, unsigned long MethodID, ... ); from Amiga.lib
_DoMethod:	move.l	a2,-(sp)
		movea.l	8(sp),a2		;*obj
		move.l	a2,d0
		beq.s	.cmnullreturn
		lea	12(sp),a1		;methodid, ...
		movea.l	-4(a2),a0
		pea	.cmreturn(pc)
		move.l	8(a0),-(sp)
		rts
.cmnullreturn:	moveq	#0,d0
.cmreturn:	movea.l	(sp)+,a2
		rts


*-----------------------------------------------------------------------------*
ResizeWindow:	movem.l	d0-a6,-(a7)
		move.l	IntBase(a5),a6
		move.l	WinHandle(a5),a0
		jsr	_LVORefreshWindowFrame(a6)

		move.l	GadgetListAdr(a5),d0
		beq.s	.Return
		move.l	d0,a1
		moveq	#0,d0
		move.w	RealNumGadgets(a5),d0
		move.l	Winhandle(a5),a0
		move.l	Intbase(a5),a6
		jsr	_LVORemoveGList(a6)

		bsr	FreeGadgets
		bsr	Clearwindow
		bsr	InitGadgets
		bne.w	.Return

		bsr	RedrawGadgets

		bsr	AddGads
		*bne	.Return
		bsr	EinTragNeu

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
Closewin:	movem.l	d0-a6,-(a7)
		lea	Puffer,a5
		tst.l	WinHandle(a5)
		beq.s	.KeinWindow
		bsr	MerkWindowSize
		bsr	Closedownwindow
.KeinWindow:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
Closedownwindow:movem.l d0-a6,-(a7)

		move.l	WinHandle(a5),d0
		beq.s	.Return
		move.l	d0,a0
		move.l	86(a0),a1			;MsgPort des Windows
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)

		bsr	DeleteListNodes
		bsr	DeleteListen

		move.l	IntBase(a5),a6
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOCloseWindow(a6)
.NoWindow:	clr.l	Winhandle(a5)
		clr.l	WindowPort(a5)
		clr.l	MyRastPort(a5)
		clr.w	WindowDisabled(a5)

		bsr	FreeMenus
		bsr	FreeGadgets
		bsr	FreeLocale

		bsr	UnlockPubScreen
.Return:	bsr	DT_FreePicture
		movem.l (sp)+,d0-a6
		rts


*--------------------------- Gadgets freigeben -------------------------------*
FreeGadgets:	movem.l	d0-a6,-(a7)

		bsr	DeleteListNodes
		bsr	DeleteListen

		move.l	GadBase(a5),a6
		move.l	GadgetListAdr(a5),d0
		move.l	d0,a0
		beq	.NoGadgets
		jsr	_LVOFreeGadgets(a6)
.NoGadgets:	clr.l	GadgetListAdr(a5)

		lea	GadgetMerkPuffer(a5),a0
		move.l	#GadgetAnz-1,d1
.ClrPuffer:	clr.l	(a0)+
		dbf	d0,.ClrPuffer
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeMenus:	movem.l	d0-a6,-(a7)
		move.l	IntBase(a5),a6
		move.l	MenuAdr(a5),d0
		move.l	d0,a0
		beq	.NoMenu
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOClearMenuStrip(a6)
.NoWindow:	move.l	GadBase(a5),a6
		move.l	MenuAdr(a5),d0
		beq.s	.NoMenu
		move.l	d0,a0
		jsr	_LVOFreeMenus(a6)
.NoMenu:	clr.l	MenuAdr(a5)
		movem.l	(a7)+,d0-a6
		rts

*----------------------------- Lock PubScreen --------------------------------*
LockPubScreen:	movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	IntBase(a5),a6
		lea	EUS_Structure(pc),a0
		move.l	EUS_EPBase(a0),d0
		beq.s	.KeinEP
		move.l	d0,a0
		move.l	EPG_Pubscreen(a0),d0
		*move.w	EPG_Wordreserved7(a0),word7(a5)
.KeinEp:	move.l	d0,a0
		jsr	_LVOLockPubScreen(a6)
		move.l	d0,MyPubscreen(a5)
		tst.l	d0
		beq.s	.Return

		move.l	Mypubscreen(a5),a0
		move.l	GadBase(a5),a6
		suba.l	a1,a1
		jsr	_LVOGetVisualInfoA(a6)
		move.l	d0,VisualInfo(a5)
		tst.l	d0
		beq.s	.Return
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

*------------------------------ Unlock PubScreen -----------------------------*
UnlockPubScreen:movem.l	d0-a6,-(a7)
		move.l	GadBase(a5),a6
		move.l	VisualInfo(a5),d0
		beq.s	.NoVisualInfo
		move.l	d0,a0
		jsr	_LVOFreeVisualInfo(a6)
		clr.l	VisualInfo(a5)
.NoVisualInfo:	move.l	IntBase(a5),a6
		suba.l	a0,a0
		move.l	Mypubscreen(a5),d0
		beq.s	.NoPublicScreen
		move.l	d0,a1
		jsr	_LVOUnlockPubScreen(a6)
.NoPublicScreen:clr.l	Mypubscreen(A5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Berechnet aus den Gadgets die min Height und Width und setzt diese in die   *
* Tagliste.
*-----------------------------------------------------------------------------*
BerechMinWindowSize:
		movem.l	d0-a6,-(a7)

	*-- Berechnungsgrundlage --*
	*-- min Width = min Cyclestringlen+25

**-----------------------------------*
* (C) Players		Infomation   *
* Available		Eigenschaften*
*------------------------------------*
* add del Config load save activate deactivate *


		*--- Breite von (Players/Engines) bzw. Available ---*
		moveq	#MinListViewWidth,d1		*Defaultsize
		moveq	#LENr_Engines,d0
		bsr	NimmBiggerSize
		moveq	#LENr_Players,d0
		bsr	NimmBiggerSize
		add.l	#15,d1				*Breite der Cycleimages
		moveq	#LENr_Verfugbar,d0
		bsr	NimmBiggerSize
		add.l	#BevelBreite*2,d1		*Rahmen der Bevelboxes
		move.l	d1,d6

		*--- Breite von Information/Eigenschaften ---*
		moveq	#MinListViewWidth,d1		*Defaultsize
		moveq	#LENr_Info,d0
		bsr	NimmBiggerSize
		moveq	#LENr_Eigenschaften,d0
		bsr	NimmBiggerSize
		add.l	#BevelBreite*2,d1		*Rahmen der Bevelboxes
		add.l	d1,d6				*Breite des oberen
							*Windows

		*--- Breite der Gadgetleiste berechnen ---*
		moveq	#0,d7
		moveq	#0,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Add,d0
		bsr	NimmBiggerSize
		add.l	d1,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Delete,d0
		bsr	NimmBiggerSize
		add.l	d1,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Config,d0
		bsr	NimmBiggerSize
		add.l	d1,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_LoadConfig,d0
		bsr	NimmBiggerSize
		add.l	d1,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_SaveConfig,d0
		bsr	NimmBiggerSize
		add.l	d2,d1
 add.l	#BevelBreite*5*2+MinTextGadgetXOffset*5*2+GadgetXAbstand*4,d1
					*Abstand vom Bevelrand links & rechts
					*sowie Abstand zum nchsten Gadget
					*Breite aller Bevelboxen
					*dazuaddieren 5 Gadgets*2Rnder = 14

	*---------------------------------------------------*
	* Jetzt ist in d6 die min X-Size des oberen Windows *
	* und in d1 die X-Size des unteren Windows	    *
	*---------------------------------------------------*
		cmp.l	d1,d6
		bhi.s	.WidthInD6
		move.l	d1,d6
.WidthInD6:	add.l	#GadgetXAbstand*2,d6	*Abstand vom Rand links&Rechts

		move.l	MyPubScreen(a5),a0
		move.b	Sc_WBorLeft(a0),d0
		ext.w	d0
		add.w	d0,d6
		move.b	Sc_WBorRight(a0),d0
		add.w	d0,d6
		move.l	d6,Win_MinWidth


	*----- So, nun wird die Y-Ausdehnung des Window berechnet -----*
		moveq	#0,d0
		move.w	FontY(a5),d0
		add.w	#MinTextGadgetYOffset*2+BevelHohe*2,d0
		mulu	#8,d0	* 4,weil 1+1 Cyglegadget, 2+1 fr Listview
				*        1 fr Gadgetreihe 1 fr Listviewtext
				*	 und 1 als Reserve

		add.w	Offy(a5),d0
		move.l	d0,Win_MinHeight

 

		movem.l	(a7)+,d0-a6
		rts
		
*-----------------------------------------------------------------------------*
* In der Windowstruktur sind die aktuellen Werte der Gre!		      *
* Jetzt
* Input: --
*-----------------------------------------------------------------------------*
InitGadgets:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5

		*----- Zur Verfgung stehende Ausmae berechnen ------*
		move.l	WinHandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		moveq	#0,d6
		moveq	#0,d7
		move.w	WD_Width(a0),d6
		move.w	WD_Height(a0),d7
		moveq	#0,d0
		move.b	WD_BorderBottom(a0),d0
		sub.w	d0,d7				*InnerHeight
		sub.w	OffY(a5),d7
		sub.l	#GadgetYAbstand*2,d7
		move.b	WD_BorderLeft(a0),d0
		sub.w	d0,d6
		move.b	WD_BorderRight(a0),d0
		sub.w	d0,d6				*InnerWidth
		sub.l	#GadgetXAbstand*2,d6

		lea	Gadgets(pc),a4
		moveq	#GadgetAnz-1,d1
		lea	AddGD-Gadgets-GNG_SizeOf(a4),a3
.GadgetClr:	lea	GNG_SizeOf(a3),a3		*Positionen und
		clr.l	(a3)				*Gren lschen
		clr.l	4(a3)
		dbf	d1,.GadgetClr


	*-- Die Breiten der Gadgetleisten wird berechnet --*
	*-- Als erstes wird die Stringbreite berechnet und gemerkt --*
	*-- dann wird calibriert
		moveq	#0,d2
		moveq	#5-1,d1
		lea	AddGD-Gadgets-GNG_SizeOf(a4),a3
.GadgetWidth:	lea	GNG_SizeOf(a3),a3
		move.l	GNG_GadgetText(a3),a0
		bsr	GetTextlength
		add.w	#BevelBreite*2+MinTextGadgetXOffset*2,d0	;Neu V5
		move.w	d0,GNG_Width(a3)
		add.l	d0,d2
		dbf	d1,.GadgetWidth

	*-- jetzt befindet sich in d2 die Width aller Gadgetstrings sowie --*
	*-- der Bevelboxen 						  --*
	*-- jetzt die Width der Gadgets in Verhltnis der Gesammtwidth    --*
	*-- setzen.
		moveq	#0,d4				*Hhe der Gadgets
		move.w	FontY(a5),d4
		add.w	#MinTextGadgetYOffset*2+BevelHohe*2,d4

		move.l	d6,d5
		sub.w	#GadgetXAbstand*5,d5
		ext.l	d5

		moveq	#0,d3
		moveq	#5-1,d1
		lea	AddGD-Gadgets-GNG_SizeOf(a4),a3
.GadgetWidth2:	lea	GNG_SizeOf(a3),a3
		moveq	#0,d0
		move.w	GNG_Width(a3),d0		*Stringwidth
		mulu	d5,d0				*mal max. nutz Ausdehn.
		divu	d2,d0				*durch GesamtStringlen
*		swap	d0
*		btst	#0,d0
*		beq.s	.GGNoAdd
*		add.l	#$10000,d0
*.GGNoAdd:	swap	d0
		move.w	d7,GNG_TopEdge(a3)
		sub.w	d4,GNG_TopEdge(a3)
		move.w	d4,GNG_Height(a3)
		move.w	d0,GNG_Width(a3)
		move.w	d3,GNG_LeftEdge(a3)
		add.w	d0,d3
		add.w	#GadgetXAbstand,d3
		dbf	d1,.GadgetWidth2

	sub.w	#GadgetXAbstand,d3	*Neue Max. Breite, damit alle Gadgets
	ext.l	d3			*rechts untereinander sein
	move.l	d3,d6

	*------------------------------------------------------------*
	*-- Jetzt haben wir die uns zur Verfgung stehenden Gren --*
	*-- Alle Gadgets beginnen links und werden bei AddGads um  --*
	*-- GadgetXAbstand & GadgetYAbstand verschoben             --*
	*------------------------------------------------------------*
		*-- LeftPos & Breite der Listviews & des CygleGadgets ---*
		*-- festlegen --*
		move.l	d6,d0
		sub.w	#GadgetXAbstand,d0	*Ein Abstand untereinander
		lsr.l	#1,d0			*--> Breite der Listviews
		move.w	d0,GNG_Width+ToggleModeGD-Gadgets(a4)
		move.w	d0,GNG_Width+ListGD-Gadgets(a4)
		move.w	d0,GNG_Width+InfoListGD-Gadgets(a4)
		move.w	d0,GNG_Width+EigenschaftenListGD-Gadgets(a4)
		move.w	d0,InfoWidth(a5)

		*-- LeftPos der rechten Listviews --*
		add.w	#GadgetXAbstand,d0	*Ein Abstand untereinander
		move.w	d0,GNG_LeftEdge+InfoListGD-Gadgets(a4)
		move.w	d0,GNG_LeftEdge+EigenschaftenListGD-Gadgets(a4)


		*--- Height des CycleGadgets ---*
		move.w	FontY(a5),d0
		move.l	d0,d1
		add.w	#MinTextGadgetYOffset+BevelHohe*2,d0 *einmal reicht
		move.w	d0,GNG_Height+ToggleModeGd-Gadgets(a4)

		add.w	#MinTextGadgetYOffset*2,d1
		move.w	d1,GNG_TopEdge+ToggleModeGd-Gadgets(a4)
		move.w	d1,GNG_TopEdge+InfoListGD-Gadgets(a4)

		*--- TopPosition des linken Listviews ---*
* Die .l Zeilen schieben das ListView links nach unten
		add.w	#GadgetYAbstand+AboveAbstand,d1
		add.w	d0,d1
		add.w	FontY(a5),d1			*Max Pos
.l10		move.w	d1,GNG_TopEdge+ListGd-Gadgets(a4)

		move.l	d7,d0
		sub.w	d1,d0
		sub.w	d4,d0
		sub.w	#GadgetYAbstand,d0

.l1		ext.l	d0
.l2		divu	FontY(a5),d0
.l3		ext.l	d0
.l4		mulu	FontY(a5),d0
.l11		add.w	#BevelHohe*2+2,d0
		move.w	d0,GNG_Height+ListGd-Gadgets(a4)

.l5		move.w	d7,d2
.l6		sub.w	d0,d2
.l7		sub.w	d4,d2
.l8		sub.w	#GadgetYAbstand,d2
.l9		move.w	d2,GNG_TopEdge+ListGd-Gadgets(a4)






		add.w	d0,d1					*MaxPos
		sub.w	GNG_TopEdge+InfoListGd-Gadgets(a4),d1
		sub.w	#AboveAbstand+GadgetYAbstand,d1
		sub.w	FontY(a5),d1
		ext.l	d1
		lsr.l	#1,d1
		move.w	d1,GNG_Height+InfoListGd-Gadgets(a4)

		move.l	d1,d2
.l12		ext.l	d2
.l13		divu	FontY(a5),d2
.l14		ext.l	d2
.l15		mulu	FontY(a5),d2
.l16		add.w	#BevelHohe*2+2,d2


		move.w	d2,GNG_Height+EigenschaftenListGd-Gadgets(a4)


		move.l	d7,d0
		sub.w	d2,d0
		sub.w	d4,d0
		sub.w	#GadgetYAbstand,d0

*		add.w	#AboveAbstand+GadgetYAbstand,d1
*		add.w	FontY(a5),d1
*		add.w	GNG_TopEdge+InfoListGd-Gadgets(a4),d1
*		move.w	d1,GNG_TopEdge+EigenschaftenListGd-Gadgets(a4)
	move.w	d0,GNG_TopEdge+EigenschaftenListGd-Gadgets(a4)

		bsr	CreateGadgets				*d0=Return

.Return:	movem.l	(a7)+,d1-a6
		rts


.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.Return

*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Error oder Null
*-----------------------------------------------------------------------------*
CreateGadgets:	movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	GadBase(A5),a6
		lea	GadgetListadr(a5),a0
		jsr	_LVOCreateContext(a6)
		move.l	d0,a3
		tst.l	d0
		beq.w	.Error

		moveq	#0,d3
		lea.l	GadgetTags(pc),a4
.NextGadget:	EB
		lea	Gadgets(pc),a0
		move.l	d3,d0
		mulu	#GNG_SIZEOF,d0		* +2 wegen Locale !
		add.l	d0,a0
		lea.l	BufNewGad(a5),a1
		moveq	#GNG_SizeOf,d0
		jsr	_LVOCopyMem(a6)
		lea.l	BufNewGad(a5),a0
		move.l	VisualInfo(a5),GNG_VisualInfo(a0)
		move.l	Font(a5),GNG_TextAttr(a0)

		move.w	GNG_TopEdge(a0),d0
		add.w	OffY(a5),d0
		addq.w	#GadgetYAbstand,d0
		move.w	d0,GNG_TopEdge(a0)

		move.w	GNG_LeftEdge(a0),d0
		add.w	OffX(a5),d0
		add.w	#GadgetXAbstand,d0
		move.w	d0,GNG_LeftEdge(a0)

		move.l	GadBase(a5),a6
		lea	GadgetTypes(pc),a0
		moveq	#0,d0
		move.l	d3,d1
		asl.l	#1,d1
		add.l	d1,a0
		move.w	(a0),d0
		move.l	a3,a0
		lea	BufNewGad(a5),a1
		move.l	a4,a2
		jsr	_LVOCreateGadgetA(a6)
		tst.l	d0
		beq.s	.Error

		*------- Gadgetadr im Puffer merken --------*
		move.l	d0,a3
		move.l	d3,d0
		asl.l	#2,d0
		lea.l	GadgetMerkPuffer(a5),a0
		add.l	d0,a0
		move.l	a3,(a0)

		*--- Start der nchsten Tagliste finden ----*
.FindTags:	tst.l	(a4)
		beq.s	.NochEinGadget
		addq.w	#8,a4
		bra.s	.FindTags

.NochEinGadget:	addq.w	#4,a4
		addq.w	#1,d3
		cmp.w	#GadgetAnz,d3
		bmi	.NextGadget
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

.Error:		bsr.w	FreeGadgets
		bra.s	.Return

*-----------------------------------------------------------------------------*
AddGads:	movem.l	d0-a6,-(sp)
		tst.l	WinHandle(a5)
		beq.w	.Return
		move.l	GadgetListAdr(a5),d0
		beq.s	.Return
		move.l	d0,a1

		moveq	#0,d1
.count:		move.l	d0,a0
		addq.l	#1,d1
		move.l	(A0),d0
		bne.s	.count
		move.w	d1,RealNumGadgets(a5)

		move.l	IntBase(a5),a6
		move.l	Winhandle(a5),a0
		moveq	#-1,d0
		moveq	#-1,d1
		sub.l	a2,a2
		jsr	_LVOAddGList(a6)

		bsr	MakeList
		bsr	MakeListen

		lea	MyTags(a5),a3
		move.l	#GTLV_Selected,(a3)+
		move.l	SelectedEntry(a5),(a3)
		subq.l	#1,(a3)+
		clr.l	(a3)
		moveq	#EPENr_List,d0
		bsr	GetGadgetAdr
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		move.l	GadgetListAdr(a5),a0
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		moveq	#-1,d0
		move.l	IntBase(a5),a6
		jsr	_LVOrefreshglist(a6)

		move.l	GadBase(a5),a6
		move.l	Winhandle(a5),a0
		sub.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)


.Return:	movem.l	(sp)+,d0-a6
		rts


*--------- Hookfunktion, um aktuellen Amplifier  farblich hervorzuheben ------*
*---------------- derzeit noch kein Support fr "disabled"-Gadgets -----------*
*benutzte Globals:
* - grafsave+datas = Graphics Base
*
*Erkennung, ob Zeile hervorzuheben oder nicht:
* - EPG_ActiveAmplifier heranziehen und EUS_Creator vergleichen
*
* Input:a0:Hook
*	a1:Message
*	a2:Node
* Output:?
*-----------------------------------------------------------------------------*
Listview_Hook:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5

	move.l	lvdm_MethodID(a1),d1
	cmp.l	#LV_Draw,d1
	bne.w	.Error
	move.l	a1,a4
	move.l	lvdm_RastPort(a4),d7
	beq.w	.Error

	move.l	lvdm_DrawInfo(A4),d0
	beq.w	.Error
	move.l	d0,a1
	move.l	dri_Pens(a1),a1

	move.l	ln_name(A2),a3
.textpen

		movem.l	a0/a3/a4,-(a7)
		move.l	a3,d5
		move	textpen*2(a1),d6		;SW
	if	Debugger!Executable
		tst.b	KillWS(a5)
		bne.w	.SW
		move.l	EPBase(pc),a4
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Player

		move.l	EPG_ActiveAmplifier(a4),d0
		beq.w	.SW
		move.l	d0,a0
		lea	EPG_FirstuserStruct(a4),a3
.NextEngine:	move.l	(a3),d0
		beq.w	.SW
		move.l	d0,a3
		cmp.l	UPrgS_EUSAdr(a3),a0
		bne.s	.NextEngine
		cmp.l	UprgS_Node+LN_Name(a3),d5
		bne.s	.SW
		bra.s	.WS

.Player:	move.l	EPG_PlayerTaglist(a4),d0
		beq.s	.SW
		move.l	d0,a0
		lea	EPG_FirstPlayerStruct(a4),a3
.NextPlayer:	move.l	(a3),d0
		beq.s	.TestCustom
		move.l	d0,a3
		cmp.l	EPPl_Taglist(a3),a0
		bne.s	.NextPlayer
		cmp.l	EPPL_Node+LN_name(a3),d5
		bne.s	.SW
.WS:		move	highlighttextpen*2(a1),d6	;Weiss
		bra.s	.SW


.TestCustom:	move.l	a1,d2
		move.l	EPG_PlayerTaglist(a4),a1
		move.l	#DTP_Customplayer,d0
		bsr	FindTag
		tst.l	d0
		bne.s	.SW2
		move.l	EPPl_Taglist-EPPL_Node(a2),d0
		beq.s	.SW2
		move.l	d0,a1
		move.l	#DTP_Playername,d0
		bsr	FindTag
	*move.l	a1,$1fe624
		tst.l	d0
		bne.s	.SW2
		move.l	#CU_Name,a0
	*move.l	#4,$1fe620
		jsr	ENPP_StringCMP(a4)
		tst.l	d0
		bne.s	.SW2
		move.l	d2,a1
		move	highlighttextpen*2(a1),d6	;Weiss
.sw2:		move.l	d2,a1
.SW:
	endc
		movem.l	(a7)+,a0/a3/a4


 move.l d6,d0
*	move	textpen*2(a1),d0		;SW
	*move	highlighttextpen*2(a1),d0	;Weiss


.high
	move	backgroundpen*2(a1),d6

	cmp.l	#LVR_SELECTED,lvdm_State(a4)
	bne.s	.normalBG

	move	FILLPEN*2(a1),d6
;	move	Filltextpen*2(a1),d0
.normalBG
	move	d6,d1
	moveq	#RP_Jam1,d2
	move.l	d7,a1
	move.l	GFXBase(a5),a6			;Graphics Base
	jsr	_LVOsetabpendrmd(A6)

	move.w	lvdm_bounds+ra_minx(a4),d0
	move.w	lvdm_bounds+ra_miny(a4),d1
	move.l	d7,a1
	add	rp_TxBaseline(a1),d1
	jsr	_LVOMove(A6)

	move.l	d7,a1
	moveq	#RP_Jam2,d0
	jsr	_LVOsetdrmd(A6)

	move.w	lvdm_bounds+ra_maxx(a4),d5		;Begrenzung des Textes
	sub	lvdm_bounds+ra_minx(a4),d5		;auf Breite des
	blt	.Error					;Listviews, solange

	move.l	a3,a0					;Text
	moveq	#-1,d3					;bis der Text passt
.lop1
	addq	#1,d3
	tst.b	(a0)+
	bne.s	.lop1
.charloop
	move.l	d7,a1
	move.l	a3,a0					;Text
	move.w	d3,d0
	jsr	_LVOtextlength(A6)
	cmp.w	d5,d0
	blt.s	.ok
	subq.w	#1,d3
	bra.s	.charloop
.ok
	move	d0,d4
	move.w	d3,d0
	move.l	a3,a0					;Text
	move.l	d7,a1
	jsr	_LVOtext(A6)

	move.l	d7,a1
	move	d6,d0
	move	d6,d1
	moveq	#0,d2
	jsr	_LVOsetabpendrmd(A6)

	move	lvdm_bounds+ra_minx(a4),d0
	add	d4,d0
	move	lvdm_bounds+ra_miny(a4),d1
	move	lvdm_bounds+ra_maxx(a4),d2
	move	lvdm_bounds+ra_maxy(a4),d3
	move.l	d7,a1
	jsr	_LVORectfill(a6)	;freien Platz nach dem Text lschen

		movem.l	(a7)+,d1-a6
		moveq	#LVCB_OK,d0
		rts

.Error:		movem.l	(a7)+,d1-a6
		moveq	#LVCB_Unknown,d0
		rts


*-------------------------- Entferne List vom Listview -----------------------*
* Input: D0=EPENr_Nummer						      *
*-----------------------------------------------------------------------------*
Remlist:	movem.l	d0-a6,-(sp)
		tst.l	Winhandle(a5)
		beq.s	.Return
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	Mytags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		move.l	#-1,(a3)+
		clr.l	(a3)+
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.Return:	movem.l	(sp)+,d0-a6
		rts

*----------------------- Liste wieder an Gadget anhngen ---------------------*
* Input: d0=EPENr_Nummer						      *
*	 a0=List							      *
*-----------------------------------------------------------------------------*
Readdlist:	movem.l	d0-a6,-(sp)
		move.l	a0,a2
		tst.l	Winhandle(a5)
		beq.s	.Return

		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	MyTags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		move.l	a2,(a3)+
		clr.l	(a3)

*		tst.b	Clicked(a5)
*		beq.s	.nose
*		move.l	#GTLV_Selected,(a3)+
*		moveq	#0,d0
*		move.w	Num_Selected(a5),d0
*		move.l	d0,(a3)+
*		clr.l	(a3)
.nose:		lea	MyTags(a5),a3

		move.l	WinHandle(a5),a1
		sub.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	movem.l	(sp)+,d0-a6
		rts


******************************************************************************
*                     aktuelle Liste killen                                  *
******************************************************************************
DeletelistNodes:movem.l	d0-a6,-(a7)
		moveq	#EPENr_List,d0
		bsr	Remlist
		clr.b	ListeDa(a5)
		clr.l	MaxEntries(a5)
		movem.l	(a7)+,d0-a6
		rts

DeleteListen:	movem.l	d0-a6,-(a7)
		moveq	#EPENr_InfoList,d0
		bsr	Remlist
		lea	InfoList(a5),a0
		bsr	DeleteAlist

		moveq	#EPENr_EigenschaftenList,d0
		bsr	Remlist
		lea	EigenschaftenList(a5),a0
		bsr	DeleteAlist
		clr.b	ListenDa(a5)

		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=List
*-----------------------------------------------------------------------------*
DeleteAList:	movem.l	d0-a6,-(a7)
		move.l	a0,d4

.NextNode:	move.l	d4,a0
	;Macro remhead aus exec/lists.i 	A0-list A1-(destroyed) D0=node
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)

		move.l	d0,a1
		move.l	ML_Size(a1),d0
		beq.s	.NextNode
		EB
		jsr	_LVOFreemem(a6)
		bra.s	.NextNode
.empty:		movem.l	(sp)+,d0-a6
		rts


*----------------------------------------------------------------------------*
* Speicher fr Node-Struktur + String anfordern, an Liste anhngen und init  *
*									     *
* Input: a0=StringAdr							     *
*	 a4=Liste							     *
* Output:d0=NUll=Error	L						     *
*----------------------------------------------------------------------------*
AllocTheNode:	movem.l	d1-a6,-(sp)
		move.l	a0,a2
		bsr	BerechStringSize
		EB
		move.l	#$10000,d1
		add.l	#ML_Chars+10,d0
		move.l	d0,d3
		jsr	_LVOAllocmem(a6)
		tst.l	d0
		beq.s	.Error

		move.l	d0,a3
		move.l	a4,a0
		move.l	d0,a1			;(erspart Arbeit)
		addtail
		lea	ML_Chars(a3),a1
		move.l	a1,LN_Name(a3)
		move.l	d3,ML_Size(a3)

		move.w	d3,d1
		sub.w	#ML_Chars+10+1,d1
		move.l	a2,a0
		bsr	StringCopy

		move.l	a3,d0

.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*---------------------------- Node freigeben --------------------------------*
* Input: a0=Node
Freenode:	movem.l	d0-a6,-(sp)
		EB
		move.l	a0,d0
		beq.s	.Return
		move.l	ML_Size(a0),d0
		beq.s	.Return
		jsr	_LVOFreemem(a6)
.Return:	movem.l	(sp)+,d0-a6
		rts


*------------------------------ Make Archivelist ----------------------------*
* Die Liste mu leer sein !!!
* Input: --
* Output:d0=Error oder NULL
MakeList:	movem.l	d1-a6,-(a7)
		moveq	#0,d0

		tst.b	ListeDa(a5)
		bne.s	.Return

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	EPG_FirstPlayerStruct(a4),a3
		move.l	EPG_PlayerList(a4),a0
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.JaPlayer
		move.l	EPG_EngineList(a4),a0
		lea	EPG_FirstUserStruct(a4),a3
.JaPlayer:	moveq	#EPENr_List,d0
		move.l	a0,ListAdr(a5)
		bsr	ReAddlist

		moveq	#0,d1
.FindAnz:	move.l	(a3),d0
		beq.s	.DasWars
		move.l	d0,a3
		addq.l	#1,d1
		bra.s	.FindAnz

.DasWars:	move.l	d1,MaxEntries(a5)
		move.l	SelectedEntry(a5),d0
		cmp.l	d0,d1
		bhi.s	.NrOk
		move.l	d1,SelectedEntry(a5)
.NrOk:		move.b	#1,ListeDa(a5)
		bsr	TitleAufbau
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.Return



*-----------------------------------------------------------------------------*
* a0=Text
* a1=Liste
* Output: d0=Error oder NULL
*-----------------------------------------------------------------------------*
TextToNodes:	movem.l	d1-a6,-(a7)
		move.l	a0,a4
		move.l	a1,d6



	*----------- Width des Listview rausfinden -----------*
	* Kleiner Trick, Gadget im ArchiveInfo ist immer das -*
	* grte					      *
	*-----------------------------------------------------*
		move.l	WinHandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		lea	WD_FirstGadget(a0),a2
		moveq	#0,d1
.FindIt:	move.l	(a2),d0
		beq.w	.AllesFound
		move.l	d0,a2
		move.w	GG_GadgetType(a2),d0		*GadgetID
		btst	#15,d0				*Systemgadget ?
		bne.s	.FindIt
		move.w	GG_Width(a2),d2
		cmp.w	d2,d1
		bhi.s	.FindIt
		cmp.w	InfoWidth(a5),d2
		beq.s	.FindIt
		move.w	GG_Width(a2),d1
		bra.s	.FindIt

.AllesFound:	sub.w	#5,d1			*move.w	InfoWidth(a5),d0
		move.w	d1,InfoWidth2(a5)




	*---- Text nach Leerzeichen durchsuchen und dann Width testen ----*
.TextSchleife:	move.l	a4,a3
		moveq	#-1,d1
		moveq	#0,d3
.NextB:		addq.l	#1,d1
		move.b	(a3)+,d2
		beq.s	.Zeilenende
		*cmp.b	#"-",d2
		*beq.s	.TestTrennung
		*cmp.b	#",",d2
		*beq.s	.TestTrennung
		cmp.b	#" ",d2
		beq.s	.TestTrennung

		cmp.b	#10,d2
		bne.s	.NextB
.ZeilenEnde:	tst.l	d1
		blt.s	.DasWars
		bsr	.TesteString
		beq.s	.NimmThisString
		bra.s	.EinKurzer

.TestTrennung:	*subq.l	#1,d1
		*blt.s	.DasWars
		*subq.l	#1,a3
		bsr	.TesteString
		beq.s	.NextB		
		*---- String zu lang 1 Word krzer ----*
.EinKurzer:	move.l	d1,d3
		subq.l	#1,a3
.EinKurzer_2:	subq.l	#1,d1
		blt.s	.NimmThisString2
		move.b	-(a3),d2
		*cmp.b	#"-",d2
		*beq.s	.NimmThisString
		*cmp.b	#",",d2
		*beq.s	.NimmThisString
		cmp.b	#" ",d2
		bne.s	.EinKurzer_2
		bra.s	.NimmThisString

		*--- a4=Textstart d1=Size ---*
.NimmThisString2:move.l	d3,d1
.NimmThisString:bsr.s	.ThisStringToNode
		beq.s	.Return				*No Mem
		tst.b	(a4,d1.w)
		beq.s	.DasWars
		lea	1(a4,d1.w),a4
		bra.s	.TextSchleife


.DasWars:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*---------- Pat der String in a4 mit Size in d1 ins Listview ----------------*
.TesteString:	movem.l	d1-a6,-(a7)
		moveq	#EPR_ErrorInArguments,d0
		tst.l	d1
		blt.s	.TesteString_2
		move.b	(a4,d1.w),d2
		move.l	d2,-(a7)
		clr.b	(a4,d1.w)
		move.l	a4,a0
		bsr	GetTextlength
		move.l	(a7)+,d2
		move.b	d2,(a4,d1.w)
		move.l	d0,d1
		moveq	#0,d0
		cmp.w	InfoWidth2(a5),d1
		blt.s	.TesteString_2
		moveq	#EPR_ErrorInString,d0
.TesteString_2:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*------- der String ab a3 wird mit der Lnge von D1 in die Node gehngt ------*
.ThisStringToNode:
		movem.l	d1-a6,-(a7)
		moveq	#0,d0
		tst.l	d1
		blt.s	.ThisError
		move.b	(a4,d1.w),d2
		move.l	d2,-(a7)
		clr.b	(a4,d1.w)
		move.l	a4,a0
		move.l	a4,-(a7)
		move.l	d6,a4
		bsr	AllocTheNode
		move.l	(a7)+,a4
		move.l	(a7)+,d2
		move.b	d2,(a4,d1.w)
.ThisError:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


		

*------------------------------- Get GadgetAdr -------------------------------*
* d0=0, wenn ok
GetGadgetAdr:	sub.l	a0,a0
		cmp.w	#GadgetAnz,d0
		bhi.s	.Error
		tst.l	GadgetListAdr(a5)
		beq.s	.Error
		lea	GadgetMerkPuffer(a5),a0
		subq.l	#EPENr_FirstNummer,d0
		asl.l	#2,d0
		tst.l	(a0,d0)
		beq.s	.Error
		move.l	(a0,d0),a0
		moveq	#0,d0
.Error:		tst.l	d0
		rts

*---------------- Berechnet die Gre des Strings in a0 ---------------------*
*------- >= a0=String							-----*
*------- => d0=Stringsize						-----*
*----------------------------------------------------------------------------*
BerechStringSize:move.l a0,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest
		moveq	#-1,d0
.NextB:		addq.l	#1,d0
		tst.b	(a0)+
		bne.s	.NextB
.NoTest:	move.l	(a7)+,a0
		tst.l	d0
		rts

*----------------------------------------------------------------------------*
StringCopy:	moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return		moveq	#0,d0
STR_Return:	rts


*-----------------------------------------------------------------------------*
InitLocale:	movem.l	d0-a6,-(a7)

		*--- Catalog ffnen ---*
	if	Debugger!Executable
		tst.l	MyCatalog(a5)
		bne.s	.NoCatalog
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	Catalogname(pc),a1
		jsr	ENPP_OpenCatalog(a4)		;_LVOopencatalogA
		move.l	d0,MyCatalog(a5)

	else
		*--- Catalog ffnen ---*
		tst.l	MyCatalog(a5)
		bne.s	.NoCatalog
		move.l	LocaleBase(a5),d0
		beq.s	.NoCatalog
		move.l	d0,a6
		suba.l	a0,a0
		suba.l	a2,a2
		lea	Catalogname(pc),a1
		jsr	_LVOOpenCatalogA(a6)		;_LVOopencatalogA
		move.l	d0,MyCatalog(a5)
	endc

*		*--- Catalog ffnen ---*
*		tst.l	MyCatalog(a5)
*		bne.s	.NoCatalog
*		move.l	LocaleBase(a5),d0
*		beq.s	.NoCatalog
*		move.l	d0,a6
*		suba.l	a0,a0
*		suba.l	a2,a2
*		lea	Catalogname(pc),a1
*		jsr	_LVOOpenCatalogA(a6)		;_LVOopencatalogA
*		move.l	d0,MyCatalog(a5)

.NoCatalog:	moveq	#5,d0
		lea	LocaleTabelle-4(pc),a0
		lea	LocaleTabelle(pc),a1
.NextOne:	lea	4(a0),a0
		move.w	(a0),d0
		beq.s	.DasWars
		move.w	2(a0),d1
		lea	(a1,d1.w),a2
		bsr	GetLocaleString
		move.l	d0,(a2)
		bra.s	.NextOne
.DasWars:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeLocale:	movem.l	d0-a6,-(a7)
		*tst.l	MyCatalog(a5)
		*beq.s	.NoCatalog

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	MyCatalog(a5),d0
		jsr	ENPP_CloseCatalog(a4)


		*move.l	LocaleBase(a5),d0
		*beq.s	.NoCatalog
		*move.l	d0,a6
		*move.l	MyCatalog(a5),d0
		*jsr	_LVOCloseCatalog(a6)
.NoCatalog:	clr.l	MyCatalog(a5)
		movem.l	(a7)+,d0-a6
		rts

*---------------------------- Erstmal ignorieren -----------------------------*
*-----------------------------------------------------------------------------*
FirstLocaleInit:movem.l	d0-a6,-(a7)
		lea	LocalePuffer+2(a5),a4
		lea	ExternalStrings,a3
		move.w	#LENr_LastExternal,d1
		move.l	a3,a0
.NextString2:	move.l	a0,d0
		sub.l	a3,d0
		move.w	d0,(a4)+
.FindZero2:	tst.b	(a0)+
		bne.s	.FindZero2
	*	tst.b	(a0)
	*	beq.s	.SetAbsStrings
		subq.w	#1,d1
		bne.s	.NextString2
.Ok:		movem.l	(a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
* Input:  D0.w = LocaleNr						      *
* Output: D0.l = StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleString:
		movem.l	d1/d2/a0/a1/a6,-(a7)

	*------- LocaleString aus internem Catalog suchen ------*
		move.l	d0,d2
		sub.l	a0,a0
		lea	ExternalStrings,a1
		cmp.w	#LENr_LastExternal,d0
		bhi.s	.Error
		lea	LocalePuffer(a5),a0
		ext.l	d0
		add.l	d0,d0
		move.w	(a0,d0.l),d0			;kein ext.l weil immer
		lea	(a1,d0.w),a0
.Error:		move.l	a0,d0

	*---------- Nun LocaleString aus Catalog suchen ---------*
		move.l	LocaleBase(a5),d1
		beq.s	.Return
		move.l	d1,a6
		move.l	MyCatalog(a5),d1
		beq.s	.Return
		move.l	d1,a0
		move.l	d0,a1
		move.l	d2,d0				* Stringnummer
		subq.l	#1,d0
		ext.l	d0
		jsr	_LVOGetCatalogStr(a6)		*--> d0=valid String

.Return:	movem.l	(a7)+,d1/d2/a0/a1/a6
		rts

*-----------------------------------------------------------------------------*
* Input: *a0=TextAdr (Font)						      *
*	 a0=Text							      *
* Output:d0=Size							      *
*-----------------------------------------------------------------------------*
GetTextlength2:	movem.l	d1-a6,-(a7)
		bsr	GetLocaleString
		move.l	d0,a0
		bra.s	getTextlength3
GetTextlength:	movem.l	d1-a6,-(a7)
GetTextlength3:	lea	MyIntuiText(pc),a2
		move.l	Font(a5),8(a2)
		move.l	a0,12(a2)
		move.l	a2,a0
		move.l	IntBase(a5),a6
		jsr	_LVOIntuiTextLength(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Diese Routine berechnet die Size vom String in d0 und setzt falls diese gr  *
* ist d1 neu.								      *
* Input: d0=Localenr							      *
*	 d1=bisherige Width						      *
* Output:d1=Neuer Wert							      *
*-----------------------------------------------------------------------------*
NimmBiggerSize:	movem.l	d2-a6,-(a7)			*Input: d0=Nummer
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	GetTextlength
		cmp.w	d0,d1
		bhi.s	.D1IstBigger
		move.l	d0,d1
		ext.l	d1
.D1IstBigger:	movem.l	(a7)+,d2-a6
		rts



*-----------------------------------------------------------------------------*

		*------------------ Window ---------------*
WindowTags:	dc.l	WA_MinWidth
Win_MinWidth:	dc.l	0
		dc.l	WA_MinHeight
Win_MinHeight:	dc.l	0
		dc.l	WA_MaxWidth,$8000
		dc.l	WA_MaxHeight,$8000

		dc.l	WA_Left
Win_LeftPos:	dc.l	0
		dc.l	WA_Top
Win_TopPos:	dc.l	0
		dc.l	WA_Width
Win_Width:	dc.l	0
		dc.l	WA_Height
Win_Height:	dc.l	0
		dc.l	WA_IDCMP,IDCMP_VanillaKey!IDCMP_Changewindow!IDCMP_RawKey!IDCMP_Menupick!LISTVIEWIDCMP!IDCMP_NEWSIZE!BUTTONIDCMP!IDCMP_CLOSEWINDOW!IDCMP_REFRESHWINDOW
		dc.l	WA_Flags,Sizebbottom!WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_SMART_REFRESH!WFLG_SIZEGADGET
		dc.l	WA_Title
LL_WindowTitle:	dc.l	0
		dc.l	WA_ScreenTitle
LL_ScreenTitle	dc.l	0
		dc.l	WA_NewLookMenus,1
		dc.l	WA_AutoAdjust,1
		dc.l	WA_Pubscreen
Pubadr:		dc.l	0
		*dc.l	WA_Zoom
		*dc.l	ZoomStruct
		dc.l	TAG_DONE
ZoomStruct:	dc.w	0,0,150,0
Ahawidth:	dc.l	399
Ahaheight:	dc.l	80


	*-------------- Gadgetvereinbarungen ----------------*
	* 1<<15 ($8000) - Flag fr Listviews, um gelschte Hhe an Font anzupassen
Refreshed_Gads:
	my_Redrawlist	ToggleModeGD,0
	my_Redrawlist	ListGD,$8000
	my_Redrawlist	InfoListGD,$8000
	my_Redrawlist	EigenschaftenListGD,$8000
	my_Redrawlist	AddGD,0
	my_Redrawlist	DelGD,0
	my_Redrawlist	ConfigGD,0
	my_Redrawlist	LoadGD,0
	my_Redrawlist	SaveGD,0
	my_Redrawlist	0,0

	*-------------- Gadgetvereinbarungen ----------------*
GadgetTypes:	dc.w	Cycle_Kind
		dc.w	Listview_Kind
		dc.w	Listview_Kind
		dc.w	Listview_Kind
		dc.w	Button_Kind			*Add
		dc.w	Button_Kind			*del
		dc.w	Button_Kind			*Load
		dc.w	Button_Kind			*Save
		dc.w	Button_Kind			*Config

GadgetTags:	dc.l	GTCY_Labels,ToggleLabels
Mode_Tag:	dc.l	GTCY_Active,1
		dc.l	GT_Underscore,'_'
		dc.l	Tag_Done
		dc.l	GTLV_ShowSelected,0		*Player/Enginelist
		dc.l	GTLV_CallBack,Listviewhook
		dc.l	Tag_Done
		dc.l	Tag_Done			*InfoList
		dc.l	Tag_Done			*Eigenschaftenlist
		dc.l	GT_Underscore,'_'		*Add
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Del
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Load
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Save
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Config
		dc.l	Tag_Done

		*---------- Eintrge fr Cyclegadget -------*
ToggleLabels:
LL_Players:	dc.l	0
LL_Engines:	dc.l	0
		dc.l	0

Listviewhook:	dcb.b	MLN_Size,0
		dc.l	Listview_hook
		dc.l	0
		dc.l	0


Gadgets:
ToggleModeGD:	dc.w	0,0,0,0			;Left,Top,Width,Height
LL_ToggleMode:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Mode		;GadgetNr
		dc.l	PLACETEXT_ABOVE,0,0	;Flags,VisualInfo,Userdata

ListGD:		dc.w	0,0,0,0			;Left,Top,Width,Height
LL_Verfugbar:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_List		;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

InfoListGD:	dc.w	0,0,0,0			;Left,Top,Width,Height
LL_InfoList:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_InfoList		;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

EigenschaftenListGD:dc.w 0,0,0,0			;Left,Top,Width,Height
LL_EigList:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_EigenschaftenList	;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

AddGD:		dc.w	0,0,0,0			;Left,Top,Width,Height
LL_Add:		dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Add		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

DelGD:		dc.w	0,0,0,0			;Left,Top,Width,Height
LL_Delete:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Delete		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

ConfigGD:	dc.w	0,0,0,0			;Left,Top,Width,Height
LL_Config:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Config		;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata

LoadGD:		dc.w	0,0,0,0			;Left,Top,Width,Height
LL_LoadConfig:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_LoadConfig	;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata
SaveGD:		dc.w	0,0,0,0			;Left,Top,Width,Height
LL_SaveConfig:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_SaveConfig	;GadgetNr
		dc.l	PLACETEXT_IN,0,0	;Flags,VisualInfo,Userdata
MyIntuiText:	dc.w	0,0
		dc.w	0,0
		dc.l	0			*Font
		dc.l	0			*Text
		dc.l	0			*Next

	*------------------------- Menus -----------------------*
Menus:		dc.b	NM_Title,0
LL_Project:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_DeleteAll:	dc.l	0
LL_DeleteAllKey:dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_About:	dc.l	0
LL_AboutKey:	dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_Hide:	dc.l	0
LL_HideKey:	dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_Quit:	dc.l	0
LL_QuitKey:	dc.l	QuitKey
		dc.w	0
		dc.l	0,0


		*--- Settings-Menu ---*
		dc.b	NM_Title,0
LL_Settings:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_Backpic:	dc.l	0 DT_Backgroundpic
LL_BackpicKey:	dc.l	0			BackPicKey
BackPicItemFlags:dc.w	CHECKIT!Menutoggle
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_ChooseBackpic:dc.l	0 DT_Choosepic
LL_ChooseBackpicKey:dc.l 0			SelectBackPicKey
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_SaveManConfig:dc.l	0
LL_SaveManConfigKey:dc.l 0			SaveConfigKey
		dc.w	0
		dc.l	0,0



		dc.b	NM_END,0
		dc.l	0,0
		dc.w	0
		dc.l	0,0


MenuTags:	dc.l	GTMN_Newlookmenus,1
		dc.l	TAG_DONE


*----------------------------------------------------------------------------*
LocaleTabelle:
		dc.w	LENr_Mode,LL_ToggleMode-LocaleTabelle
		dc.w	LENr_Players,LL_Players-LocaleTabelle
		dc.w	LENr_Engines,LL_Engines-LocaleTabelle
		dc.w	LENr_Verfugbar,LL_Verfugbar-LocaleTabelle
		dc.w	LENr_Info,LL_Infolist-LocaleTabelle
		dc.w	LENr_Eigenschaften,LL_EigList-LocaleTabelle
		dc.w	LENr_Add,LL_Add-LocaleTabelle
		dc.w	LENr_Delete,LL_Delete-LocaleTabelle
		dc.w	LENr_DeleteAll,LL_DeleteAll-LocaleTabelle
		dc.w	LENr_DeleteAllKey,LL_DeleteAllKey-LocaleTabelle
		dc.w	LENr_Config,LL_Config-LocaleTabelle
		dc.w	LENr_LoadConfig,LL_LoadConfig-LocaleTabelle
		dc.w	LENr_SaveConfig,LL_SaveConfig-LocaleTabelle
		dc.w	LENr_Project,LL_Project-LocaleTabelle
		dc.w	LENr_About,LL_About-LocaleTabelle
		dc.w	LENr_AboutKey,LL_AboutKey-LocaleTabelle
		dc.w	LENr_Hide,LL_Hide-LocaleTabelle
		dc.w	LENr_HideKey,LL_HideKey-LocaleTabelle
		dc.w	LENr_Quit,LL_Quit-LocaleTabelle
	*	dc.w	LENr_QuitKey,LL_QuitKey-LocaleTabelle
		dc.w	LENr_WindowTitle,LL_WindowTitle-LocaleTabelle
		dc.w	LENr_ScreenTitle,LL_ScreenTitle-LocaleTabelle

		dc.w	LENr_ManConfig,LL_Settings-LocaleTabelle
		dc.w	LENr_BackPic,LL_BackPic-LocaleTabelle
		dc.w	LENr_SelectBackPic,LL_ChooseBackPic-LocaleTabelle
		dc.w	LENr_ManSaveConfig,LL_SaveManConfig-LocaleTabelle
		dc.w	0



EPMIF_Text		EQU	1
EPMIF_Zustand		EQU	2
EPMIF_MultiText		EQU	3		*z.B.  "Creator : Jan"
EPMIF_Zahl		EQU	4		*z.B.  "Creator : Jan"
EPMIF_MultiText2	EQU	5		*z.B.  "Creator : Jan", mit Zeilenumbruch

EPMIB_Text		EQU	1<<EPMIF_Text
EPMIB_ZuStand		EQU	1<<EPMIF_Zustand
EPMIB_MultiText		EQU	1<<EPMIF_MultiText
EPMIB_Zahl		EQU	1<<EPMIF_Zahl
EPMIB_MultiText2	EQU	1<<EPMIF_MultiText2


*-----------------------------------------------------------------------------*
ModeTabellen:	dc.w	PlayerInfoTabelle-ModeTabellen
		dc.w	EngineInfoTabelle-ModeTabellen

PlayerInfoTabelle:
		*--- Info-Listview ---*
		dc.w	PlI_Creator-MakeListen,0,EPMIB_Text
		dc.w	LeerZeile-MakeListen,0,0
		dc.w	PlI_About-MakeListen,0,EPMIB_Text
		*dc.w	PlI_SpecialInfo-MakeListen,0,EPMIB_Text
		dc.w	PlI_Info-MakeListen,0,EPMIB_Text
		*dc.w	LeerZeile-MakeListen,0,0
		dc.w	PlI_Prefix-MakeListen,LENr_PlI_Prefix,EPMIB_MultiText
		dc.w	PlI_Version-MakeListen,LENr_EnI_Version,EPMIB_MultiText
		dc.w	LeerZeile-MakeListen,0,0
		dc.w	PlI_EPVersion-MakeListen,LENr_EnI_EPVersion,EPMIB_Zahl!EPMIB_MultiText
		dc.w	PlI_KickStart-MakeListen,LENr_EnI_KickStart,EPMIB_Zahl!EPMIB_MultiText
		dc.w	PlI_CPU-MakeListen,LENr_EnI_CPU,EPMIB_MultiText
		dc.w	PlI_FPU-MakeListen,LENr_EnI_FPU,EPMIB_MultiText
		dc.w	0					*Last One

		*--- Eigenschaften-Listview ---*
		dc.w	PlS_Balance-MakeListen,LENr_Pls_Balance,EPMIB_ZuStand
		dc.w	PlS_Speed-MakeListen,LENr_Pls_Speed,EPMIB_ZuStand
		dc.w	PlS_Volume-MakeListen,LENr_Pls_Volume,EPMIB_ZuStand
		dc.w	PlS_Voices-MakeListen,LENr_Pls_Voices,EPMIB_ZuStand
		dc.w	PlS_PatternJump-MakeListen,LENr_Pls_PatternJump,EPMIB_ZuStand
		dc.w	PlS_SubSongs-MakeListen,LENr_Pls_SubSongs,EPMIB_ZuStand
		dc.w	PlS_SaveModule-MakeListen,LENr_Pls_SaveModule,EPMIB_ZuStand
		dc.w	PlS_SaveAsProTracker-MakeListen,LENr_Pls_SaveAsProtracker,EPMIB_ZuStand
		dc.w	LeerZeile-MakeListen,0,0
		dc.w	PlS_Amplifier-MakeListen,LENr_Pls_Amplifier,EPMIB_ZuStand
		dc.w	PlS_PatternScroll-MakeListen,LENr_Pls_PatternScroll,EPMIB_ZuStand
		dc.w	PlS_PositionNr-MakeListen,LENr_Pls_PositionNr,EPMIB_ZuStand
		dc.w	PlS_Scopes-MakeListen,LENr_Pls_Scopes,EPMIB_ZuStand
		dc.w	PlS_Autorerkennung-MakeListen,LENr_Pls_Autorerkennung,EPMIB_Zustand
		dc.w	PlS_Songend-MakeListen,LENr_Pls_Songend,EPMIB_ZuStand
		dc.w	PlS_CalcDuration-MakeListen,LENr_Pls_CalcDuration,EPMIB_ZuStand
		dc.w	PlS_Check-MakeListen,LENr_Pls_Check,EPMIB_ZuStand
		dc.w	PlS_MultiFiles-MakeListen,LENr_Pls_MultiFiles,EPMIB_ZuStand
		dc.w	PlS_ModuleInfo-MakeListen,LENr_Pls_ModuleInfo,EPMIB_ZuStand
		dc.w	PlS_SampleInfo-MakeListen,LENr_Pls_SampleInfo,EPMIB_ZuStand
		dc.w	PlS_ModuleChange-MakeListen,LENr_Pls_ModuleChange,EPMIB_ZuStand
		dc.w	PlS_LoadFast-MakeListen,LENr_Pls_LoadFast,EPMIB_ZuStand

		dc.w	PlS_LeerZeile-MakeListen,0,0
		dc.w	PlS_Maxlength-MakeListen,LENr_PlS_Maxlength,EPMIB_Zahl!EPMIB_MultiText
		dc.w	PlS_MaxSamples-MakeListen,LENr_PlS_MaxSamples,EPMIB_Zahl!EPMIB_MultiText
		dc.w	PlS_MaxSynthSamples-MakeListen,LENr_PlS_MaxSynthSamples,EPMIB_Zahl!EPMIB_MultiText
		dc.w	PlS_MaxPattern-MakeListen,LENr_PlS_MaxPattern,EPMIB_Zahl!EPMIB_MultiText
		dc.w	PlS_MaxSubSongs-MakeListen,LENr_PlS_MaxSubSongs,EPMIB_Zahl!EPMIB_MultiText
		dc.w	PlS_UnpackedSystem-MakeListen,LENr_Pls_UnpackedSystem,EPMIB_MultiText


		dc.w	0


EngineInfoTabelle:
		*--- Info-Listview ---*
		dc.w	EnI_Notloaded-MakeListen,0,0
		*dc.w	EnI_Name-MakeListen,LENr_EnI_Name,EPMIB_MultiText
		dc.w	EnI_Creator-MakeListen,LENr_EnI_Creator,EPMIB_MultiText2
		dc.w	LeerZeile-MakeListen,0,0
		dc.w	EnI_Type-MakeListen,LENr_EnI_Type,EPMIB_MultiText
		dc.w	EnI_Version-MakeListen,LENr_EnI_Version,EPMIB_MultiText
		dc.w	EnI_Date-MakeListen,LENr_EnI_Date,EPMIB_MultiText
		dc.w	LeerZeile-MakeListen,0,0
		dc.w	EnI_EPVersion-MakeListen,LENr_EnI_EPVersion,EPMIB_Zahl!EPMIB_MultiText
		dc.w	EnI_KickStart-MakeListen,LENr_EnI_KickStart,EPMIB_Zahl!EPMIB_MultiText
		dc.w	EnI_CPU-MakeListen,LENr_EnI_CPU,EPMIB_MultiText
		dc.w	EnI_FPU-MakeListen,LENr_EnI_FPU,EPMIB_MultiText
		dc.w	0

		*--- Eigenschaften-Listview ---*
		*dc.w	LeerZeile-MakeListen,0,0
		dc.w	EnI_About-MakeListen,LENr_EnI_About,EPMIB_Text
		dc.w	0


PlI_Creator:	moveq	#LENr_PlayerNotLoaded,d0
		bsr	GetLocaleString
		move.l	d0,a0

		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.No
		move.l	#DTP_Creator,d0
		bsr	FindTag
		bne.w	.No
		move.l	a1,a0
.No:		moveq	#0,d0
		rts

PlI_About:	bsr	GetModuleInfoTagList		*a1=TagList
		bne.s	.No
		move.l	#MI_About,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,a0
.No:		rts

*PlI_SpecialInfo:bsr	GetModuleInfoTagList		*a1=TagList
*		bne.s	.No
*		move.l	#MI_SpecialInfo,d0
*		bsr	FindTag
*		bne.s	.No
*		move.l	a1,a0
*.No:		rts

PlI_Info:	bsr	GetModuleInfoTagList		*a1=TagList
		bne.s	.No
		move.l	#MI_ExtraInfo,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,a0
.No:		rts

PlI_Prefix:	bsr	GetModuleInfoTagList		*a1=TagList
		bne.s	.No
		move.l	#MI_Prefix,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,a0
.No:		rts


PlI_Version:	bsr	GetPlayerTagList		*a1=TagList
		bne.s	.No
		move.l	#DTP_PlayerVersion,d0
		bsr	FindTag
		bne.s	.No

		*- Input:d0=Hexzahl
		*-	 d1=Flags Bit 0: 1=Hidezero
		*-		  Bit 1: 1=use negativ
		*-	 a0=OutputPuffer

	move.l	EUS_Structure+EUS_EPBase(pc),a2

	lea	TextPuffer+TextPufferSize-20(a5),a0
	move.l	a1,d0
	swap	d0
	and.l	#$ffff,d0
	moveq	#2,d1
	jsr	ENPP_HexDez(a2)
	addq.l	#1,a0
	move.b	#".",(a0)+
	move.l	a1,d0
	and.l	#$ffff,d0
	moveq	#2,d1
	jsr	ENPP_HexDez(a2)
	lea	TextPuffer+TextPufferSize-20(a5),a0
		*move.l	a1,d1
		*ext.l	d1
		moveq	#0,d0
.No:		rts

PlI_EPVersion:	bsr	GetPlayerTagList		*a1=TagList
		bne.s	.No
		move.l	#EP_PlayerVersion,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d1
		moveq	#0,d0
.No:		rts

PlI_KickStart:	bsr	GetPlayerTagList		*a1=TagList
		bne.s	.No
		moveq	#37,d1
		move.l	#EP_KickVersion,d0
		bsr	FindTag
		bne.s	.KeinTag
		move.l	a1,d1
.KeinTag:	moveq	#0,d0
.No:		rts


PlI_CPU:	bsr	GetPlayerTagList
		bne.s	.Return

		moveq	#0,d4
		lea	CPU_68000(pc),a0

		move.l	#EP_AttnFlags,d0
		bsr	FindTag
		bne.s	.Error
		bsr	GetCPUText
		move.l	d0,d4
.Error:		move.l	d4,d0
.Return:	rts

PlI_FPU:	bsr	GetPlayerTaglist
		bne.s	.Return

		moveq	#0,d4
		moveq	#LENr_EnI_NotNeeded,d0
		bsr	GetLocaleString
		move.l	d0,a0

		move.l	#EP_AttnFlags,d0
		bsr	FindTag
		bne.s	.Error
		bsr	GetFPUText
		move.l	d0,d4
.Error:		move.l	d4,d0
.Return:	rts

	*----------------- Zweite Playertabelle -----------------*
PlS_Balance:	moveq	#1,d1				*Yes
		bsr	GetPlayerTagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#DTP_Balance,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	a3,a1
		move.l	#EP_InitAmplifier,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	a3,a1
		move.l	#EP_Flags,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d0
		btst	#EPF_Balance,d0
		bne.s	.Yes
		btst	#EPF_VolBalVoi,d0
		bne.s	.Yes
.No:		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error:		rts

PlS_Speed:	moveq	#1,d1				*Yes
		bsr	GetPlayerTagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#DTP_Faster,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	a3,a1
		move.l	#EP_SetSpeed,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	a3,a1
		move.l	#DTP_Interrupt,d0
		bsr	FindTag
		beq.s	.Yes
		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error:		rts

PlS_Volume:	moveq	#1,d1				*Yes
		bsr	GetPlayerTagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#DTP_Volume,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	a3,a1
		move.l	#EP_InitAmplifier,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	a3,a1
		move.l	#EP_Flags,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d0
		btst	#EPF_Volume,d0
		bne.s	.Yes
		btst	#EPF_VolBalVoi,d0
		bne.s	.Yes
		btst	#EPF_VolVoices,d0
		bne.s	.Yes
.No:		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error:		rts


PlS_Songend:	moveq	#1,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	#EP_Flags,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d0
		btst	#EPF_Songend,d0
		bne.s	.Yes
.No:		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error		rts

PlS_Amplifier:	moveq	#1,d1				*Yes
		bsr	GetPlayerTagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#EP_InitAmplifier,d0
		bsr	FindTag
		beq.s	.Yes
		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error:		rts

PlS_Check:	moveq	#1,d1				*Yes
		bsr	GetPlayerTagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#EP_CheckModule,d0
		bsr	FindTag
		beq.s	.Yes
		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error:		rts

PlS_Voices:	moveq	#1,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#EP_Voices,d0
		bsr	FindTag
		beq.s	.Yes

		move.l	a3,a1
		move.l	#EP_InitAmplifier,d0
		bsr	FindTag
		beq.s	.Yes

		move.l	a3,a1
		move.l	#EP_Flags,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d0
		btst	#EPF_Voices,d0
		bne.s	.Yes
		btst	#EPF_VolBalVoi,d0
		bne.s	.Yes
.No:		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error:		rts

PlS_Scopes:	moveq	#1,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#EP_StructInit,d0
		bsr	FindTag
		beq.s	.Yes

		move.l	a3,a1
		move.l	#EP_InitAmplifier,d0
		bsr	FindTag
		beq.s	.Yes

		move.l	a3,a1
		move.l	#EP_Flags,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d0
		btst	#EPF_Analyzer,d0
		bne.s	.Yes
.No:		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error:		rts

PlS_CalcDuration:
		moveq	#1,d1				*Yes
		bsr	GetPlayerTagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#EP_CheckModule,d0
		bsr	FindTag
		beq.s	.Yes
		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error:		rts

PlS_ModuleInfo:	moveq	#0,d1
		bsr	GetModuleInfoTagList		*a1=TagList
		bne.s	.Error
		moveq	#1,d1
.no:		moveq	#0,d0
.Error:		rts

PlS_Autorerkennung:
		moveq	#0,d1
		bsr	GetModuleInfoTagList
		bne.s	.Error
		move.l	#MI_Authorname,d0
		bsr	FindTag				*a1=TagList
		bne.s	.Error
		moveq	#1,d1
.no:		moveq	#0,d0
.Error:		rts

PlS_MultiFiles:	moveq	#0,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	#DTP_ExtLoad,d0
		bsr	FindTag
		bne.s	.No
		moveq	#1,d1
.no:		moveq	#0,d0
.Error		rts

Pls_SampleInfo:	moveq	#0,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	#EP_SampleInit,d0
		bsr	FindTag
		bne.s	.No
		moveq	#1,d1
.No:		moveq	#0,d0
.Error:		rts

PlS_ModuleChange:moveq	#0,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	#EP_ModuleChange,d0
		bsr	FindTag
		beq.s	.Yes
		bsr	GetModuleInfoTagList
		bne.s	.No
		move.l	#MI_InfoFlags,d0
		bsr	FindTag
		bne.s	.No
		btst	#MIF_ReplayinModule,d0
		bne.s	.No
.Yes:		moveq	#1,d1
.No:		moveq	#0,d0
.Error:		rts

PlS_SaveModule:	moveq	#0,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#EP_Save,d0
		bsr	FindTag
		beq.s	.Yes

		move.l	a3,a1
		move.l	#EP_Flags,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d0
		btst	#EPF_Save,d0
		beq.s	.No
.Yes:		moveq	#1,d1
.No:		moveq	#0,d0
.Error:		rts

PlS_SaveAsProTracker
		moveq	#0,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	#EP_SaveAsPT,d0
		bsr	FindTag
		bne.s	.No
		moveq	#1,d1
.No:		moveq	#0,d0
.Error:		rts

PlS_LoadFast:	moveq	#1,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#EP_InitAmplifier,d0
		bsr	FindTag
		beq.s	.Yes

		move.l	a3,a1
		move.l	#EP_Check3,d0
		bsr	FindTag
		beq.s	.Yes

		move.l	a3,a1
		move.l	#EP_Check5,d0
		bsr	FindTag
		beq.s	.Yes

		move.l	a3,a1
		move.l	#EP_Flags,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d0
		btst	#EPF_LoadFast,d0
		bne.s	.Yes
.No:		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error:		rts

PlS_PatternJump:moveq	#1,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#DTP_NextPatt,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	a3,a1
		move.l	#EP_Flags,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d0
		btst	#EPF_NextPatt,d0
		bne.s	.Yes
.No:		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error:		rts

PlS_PatternScroll:
		moveq	#0,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	#EP_PatternInit,d0
		bsr	FindTag
		bne.s	.No
		moveq	#1,d1
.No:		moveq	#0,d0
.Error		rts

PlS_PositionNr:	moveq	#0,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	#EP_GetPositionNr,d0
		bsr	FindTag
		bne.s	.No
		moveq	#1,d1
.No:		moveq	#0,d0
.Error		rts

PlS_SubSongs:	moveq	#1,d1
		bsr	GetPlayerTagList		*a1=TagList
		bne.s	.Error
		move.l	a1,a3
		move.l	#DTP_NextSong,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	a3,a1
		move.l	#DTP_SubSongRange,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	a3,a1
		move.l	#EP_Flags,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d0
		btst	#EPF_NextSong,d0
		bne.s	.Yes
.No:		moveq	#0,d1
.Yes:		moveq	#0,d0
.Error		rts


PlS_LeerZeile:	bsr	GetModuleInfoTagList
		bne.s	.No
		move.l	a1,a3
		move.l	#MI_MaxLength,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	#MI_MaxSamples,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	#MI_MaxSynthSamples,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	#MI_MaxSubSongs,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	#MI_MaxPattern,d0
		bsr	FindTag
		beq.s	.Yes
		move.l	#MI_Unpackedsystem,d0
		bsr	FindTag
		bne.s	.No
.Yes:		lea	LeerZeichen(pc),a0
		moveq	#0,d0
.No		rts




PlS_MaxPattern:	bsr	GetModuleInfoTagList		*a1=TagList
		bne.s	.No
		move.l	#MI_MaxPattern,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d1
		moveq	#0,d0
.No:		rts

PlS_Maxlength:	bsr	GetModuleInfoTagList		*a1=TagList
		bne.s	.No
		move.l	#MI_MaxLength,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d1
		moveq	#0,d0
.No:		rts

PlS_MaxSamples:	bsr	GetModuleInfoTagList		*a1=TagList
		bne.s	.No
		move.l	#MI_MaxSamples,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d1
		moveq	#0,d0
.No:		rts

PlS_MaxSynthSamples:
		bsr	GetModuleInfoTagList		*a1=TagList
		bne.s	.No
		move.l	#MI_MaxSynthSamples,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d1
		moveq	#0,d0
.No:		rts

PlS_MaxSubSongs:bsr	GetModuleInfoTagList		*a1=TagList
		bne.s	.No
		move.l	#MI_MaxSubSongs,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,d1
		moveq	#0,d0
.No:		rts



PlS_UnpackedSystem:
		bsr	GetModuleInfoTagList		*a1=TagList
		bne.s	.No
		move.l	#MI_UnPackedSystem,d0
		bsr	FindTag
		bne.s	.No
		move.l	a1,a0
		cmp.w	#MIUS_SizeOF,a1
		bhi.s	.Yes

		move.l	a1,d0
		add.w	#LENr_US_OldSoundTracker-1,d0
		bsr	GetLocaleString
		move.l	d0,a0
.Yes:		moveq	#0,d0
.No:		rts

		move.l	d0,a0
		moveq	#0,d0
.Error:		rts


*-----------------------------------------------------------------------------*
EnI_Notloaded:	bsr	GetEUSStruct
		beq.s	.Error
		moveq	#LENr_EngineNotLoaded,d0
		bsr	GetLocaleString
		move.l	d0,a0
		moveq	#0,d0
		rts

.Error:		moveq	#1,d0
		rts



*EnI_Name:	bsr	GetEUSStruct
*		bne.s	.Error
*		move.l	EUS_Creator(a1),a0
*.Error:		rts
*

EnI_Creator:	bsr	GetEUSStruct
		bne.s	.Error
		move.l	EUS_Creator(a1),a0
.Error:		rts


EnI_About:	bsr	GetEUSStruct
		bne.s	.Error
		move.l	a1,a3

		move.l	EUS_Taglist(a3),a1
		move.l	#EUT_SpecialinfoLNr,d0
		bsr	FindTag
		bne.s	.KeineTags
		move.l	a1,d0
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		jsr	ENPP_GetLocaleString(a4)
		move.l	d0,a0
		tst.l	d0
		beq.s	.KeineTags
		move.l	EUS_Taglist(a3),a1
		move.l	#EUT_SpecialinfoArgs,d0
		bsr	FindTag
		bne.s	.Ok

		*--- Text zusammensetzen ---*
		lea	TextPuffer(a5),a2
		move.w	#TextPufferSize-2,d0
		jsr	ENPP_RawToFormat(a4)
		lea	TextPuffer(a5),a0
		tst.l	d0
		beq.s	.Ok

.KeineTags:	move.l	EUS_AboutUPrg(a3),a0
.OK:		moveq	#0,d0
.Error:		rts

EnI_Version:	bsr	GetEUSStruct
		bne.s	.Error

		move.l	EUS_Structure+EUS_EPBase(pc),a2
		lea	TextPuffer+TextPufferSize-20(a5),a0
		moveq	#0,d0
		move.w	EUS_Version(a1),d0
		moveq	#2,d1
		jsr	ENPP_HexDez(a2)
		addq.l	#1,a0
		move.b	#".",(a0)+
		moveq	#0,d0
		move.w	EUS_Revision(a1),d0
		moveq	#2,d1
		jsr	ENPP_HexDez(a2)
		lea	TextPuffer+TextPufferSize-20(a5),a0
		moveq	#0,d0

.Error:		rts



EnI_Date:	bsr	GetEUSStruct
		bne.s	.Error

		move.l	EUS_Structure+EUS_EPBase(pc),a2
		lea	TextPuffer+TextPufferSize-20(a5),a0
		moveq	#0,d0
		move.b	EUS_Creatordate(a1),d0
		moveq	#2,d1
		jsr	ENPP_HexDez(a2)
		bsr	BerechStringSize
		lea	(a0,d0.w),a0
		move.b	#".",(a0)+
		move.b	EUS_Creatordate+1(a1),d0
		moveq	#2,d1
		jsr	ENPP_HexDez(a2)
		bsr	BerechStringSize
		lea	(a0,d0.w),a0
		move.b	#".",(a0)+

		move.w	EUS_Creatordate+2(a1),d0
		moveq	#2,d1
		jsr	ENPP_HexDez(a2)
		bsr	BerechStringSize
		lea	(a0,d0.w),a0
		lea	TextPuffer+TextPufferSize-20(a5),a0
		moveq	#0,d0

.Error:		rts

ENI_CPU:	bsr	GetEUSStruct
		bne.s	.Return

		moveq	#0,d4
		lea	CPU_68000(pc),a0

		move.l	EUS_Taglist(a1),d0
		beq.s	.Error
		move.l	d0,a1
		move.l	#EUT_AttnFlags,d0
		bsr	FindTag
		bne.s	.Error
		bsr	GetCPUText
		move.l	d0,d4
.Error:		move.l	d4,d0
.Return:	rts

ENI_FPU:	bsr	GetEUSStruct
		bne.s	.Return

		moveq	#0,d4
		moveq	#LENr_EnI_NotNeeded,d0
		bsr	GetLocaleString
		move.l	d0,a0


		move.l	EUS_Taglist(a1),d0
		beq.s	.Error
		move.l	d0,a1
		move.l	#EUT_AttnFlags,d0
		bsr	FindTag
		bne.s	.Error
		bsr	GetFPUText
		move.l	d0,d4
.Error:		move.l	d4,d0
.Return:	rts




EnI_EPVersion:	bsr	GetEUSStruct
		bne.s	.Error
		moveq	#0,d1
		move.l	EUS_EPVersion(a1),d1
.Error:		rts

EnI_KickStart:	bsr	GetEUSStruct
		bne.s	.Error
		moveq	#0,d1
		move.w	EUS_KickStart(a1),d1
.Error:		rts


EnI_Type:	bsr	GetEUSStruct
		bne.s	.Error
		moveq	#0,d0
		move.b	EUS_Type(a1),d0
		add.w	#LENr_Type_Unknown,d0
		bsr	GetLocaleString
		move.l	d0,a0
		moveq	#0,d0
.Error:		rts



LeerZeile:	lea	Leerzeichen(pc),a0
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Input: a1=Flags
* Output:d0=NULL
*	 a0=Text des Prozessors oder Fragezeichen
*-----------------------------------------------------------------------------*
		*--- Unbekannte CPU/FPU-Flags ? ----*
GetCPUText:	move.l	a1,d0
		and.w	#$ff00,d0		;wenn d0 ungleich 0, dann ist
		tst.w	d0			;ein unbekannter CPU angeben
		bne.s	.Frage

		move.l	a1,d0
		and.l	#$ffffff8f,d0			;FPU-Flags lschen
		lea	CPU_68010(pc),a0
		bclr	#0,d0
		bne.s	.Yes
		lea	CPU_68020(pc),a0
		bclr	#1,d0
		bne.s	.Yes
		lea	CPU_68030(pc),a0
		bclr	#2,d0
		bne.s	.Yes
		lea	CPU_68040(pc),a0
		bclr	#3,d0
		bne.s	.Yes
		lea	CPU_68060(pc),a0
		bclr	#7,d0
		bne.s	.Yes
		tst.l	d0				;unbekannte Flags ??
		beq.s	.68000
.Frage:		lea	Fragezeichen(pc),a0
		bra.s	.Yes
.68000		lea	CPU_68000(pc),a0
.Yes:		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
* Input: a1=Flags
* Output:d0=NULL
*	 a0=Text des Prozessors oder Fragezeichen
*-----------------------------------------------------------------------------*
GetFPUText:	*--- Unbekannte CPU/FPU-Flags ? ----*
		move.l	a1,d0
		and.w	#$ff00,d0		;wenn d0 ungleich 0, dann ist
		tst.w	d0			;ein unbekannter CPU angeben
		bne.s	.Frage

		move.l	a1,d0
		and.l	#$ffffff70,d0			;Alle bekannten
		lea	FPU_68881(pc),a0		;CPUFlags weg
		bclr	#4,d0
		bne.s	.Yes
		lea	FPU_68882(pc),a0
		bclr	#5,d0
		bne.s	.Yes
		lea	FPU_FPU40(pc),a0
		bclr	#6,d0
		bne.s	.Yes
		tst.l	d0				;unbekannte Flags ??
		beq.s	.NoFPU
.Frage:		lea	Fragezeichen(pc),a0
		bra.s	.Yes
.NoFPU:		moveq	#LENr_EnI_NotNeeded,d0
		bsr	GetLocaleString
		move.l	d0,a0
.Yes:		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Error oder NULL
*	 a1=EUS_Struct
*-----------------------------------------------------------------------------*
GetEUSStruct:
		movem.l	d1/d2/a0,-(a7)
		moveq	#-1,d0
		move.l	EUS_Structure+EUS_EPBase(pc),a1
		lea	EPG_FirstUserStruct(a1),a1
		move.l	SelectedEntry(a5),d1
		subq.l	#1,d1
		blt.s	.Error
.NextEngine:	move.l	(a1),d2
		beq.s	.Error
		move.l	d2,a1
		dbf	d1,.NextEngine
		move.l	UPrgS_EUSAdr(a1),d1
		beq.s	.Error
		move.l	d1,a1
		moveq	#0,d0
.Error:		movem.l	(a7)+,d1/d2/a0
		tst.l	d0
		rts


**-----------------------------------------------------------------------------*
** Input: --
** Output:d0=Error oder NULL
**	 a1=UPrgS_Struct
**-----------------------------------------------------------------------------*
*GetEngineStruct:
*		movem.l	d1/d2,-(a7)
*		moveq	#-1,d0
*		move.l	EUS_Structure+EUS_EPBase(pc),a1
*		move.l	EPG_FirstUserStruct(a1),a1
*		move.l	SelectedEntry(a5),d1
*		subq.l	#2,d1
*		blt.s	.Error
*.NextEngine:	move.l	(a1),d2
*		beq.s	.Error
*		move.l	d2,a1
*		dbf	d1,.NextEngine
*		moveq	#0,d0
*.Error:		movem.l	(a7)+,d1/d2
*		rts
*


*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Error oder NULL
*	 a1=TagList
*-----------------------------------------------------------------------------*
GetPlayerTagList:
		movem.l	d1/d2,-(a7)
		moveq	#-1,d0
		move.l	EUS_Structure+EUS_EPBase(pc),a1
		lea	EPG_FirstPlayerStruct(a1),a1
		move.l	SelectedEntry(a5),d1
		subq.l	#1,d1
		blt.s	.Error
.NextPlayer:	move.l	(a1),d2
		beq.s	.Error
		move.l	d2,a1
		dbf	d1,.NextPlayer
		move.l	EPPl_TagList(a1),d1
		beq.s	.Error
		move.l	d1,a1
		moveq	#0,d0
.Error:		movem.l	(a7)+,d1/d2
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Error oder NULL
*	 a1=TagList
*-----------------------------------------------------------------------------*
GetModuleInfoTagList:
		move.l	d1,-(a7)
		bsr	GetPlayerTagList
		bne.s	.Error

		move.l	a1,-(a7)
		move.l	#EP_Get_ModuleInfo,d0
		bsr	Callup
		move.l	(a7)+,a1
		beq.s	.ListeIna0

		move.l	#EP_NewModuleInfo,d0
		bsr	FindTag
		bne.s	.Error
		move.l	a1,a0

.ListeInA0:	move.l	a0,a1
.Error:		move.l	(a7)+,d1
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: d0=Tag
*	 a1=TagListe
* Output:d0=Error oder NULL
*	 a1=Wert des Tags
*-----------------------------------------------------------------------------*
FindTag:	movem.l	d1/a0/a2/a6,-(a7)
		move.l	a1,a0
		move.l	EUS_Structure+EUS_EPBase(pc),a2

		*--- Input: a0 = Tagliste
		*---	    d0 = Tag
		*--- Output:d0 = TagWert
		*---	    d1 = Ergebnis (0=nein 1=ja)
		jsr	ENPP_FindTag(a2)
		sub.l	a1,a1
		tst.l	d1
		beq.s	.KeinTag
		move.l	d0,a1
		moveq	#1,d1
.KeinTag:	seq	d1
		moveq	#0,d0
		move.b	d1,d0
		movem.l	(a7)+,d1/a0/a2/a6
		rts		

*-----------------------------------------------------------------------------*
* Rckgabewert der Routine steht in d2 !!!!
* Input: d0=Tag
*	 a1=TagListe
* Output:d0=Error oder NULL
*	 a1=Wert des Tags
*-----------------------------------------------------------------------------*
Callup:		movem.l	d3-d7/a3-a6,-(a7)
		bsr	FindTag
		bne.s	.Error
		move.l	EUS_Structure+EUS_EPBase(pc),a5	; da einige Player a5
		jsr	(a1)				; nutzen
		move.l	d0,d2
		moveq	#0,d0
.Error:		movem.l	(a7)+,d3-d7/a3-a6
		tst.l	d0
		rts





*-----------------------------------------------------------------------------*

*-----------------------------------------------------------------------------*
* Das Programm kehrt mit einem String zurck. Der wird an den von LocaleNummer*
* angehngt.								      *
*-----------------------------------------------------------------------------*
* Input: -
* Output:a0=Text
*	 d0=Flags
*	1=keine Zeilenumbruch
MakeListen:	movem.l	d0-a6,-(a7)

		tst.b	ListenDa(a5)
		bne.w	.DasWars

		lea	ModeTabellen(pc),a3
		move.b	Mode(a5),d0
		subq.l	#1,d0
		add.w	d0,d0
		move.w	(a3,d0.w),d0
		lea	-6(a3,d0.w),a3			*Start der Tabelle fr
		lea	InfoList(a5),a4
		moveq	#1,d7				*2 Listen

	*------ nchster Eintrag in der Liste -----*
.NextEinTrag:	lea	6(a3),a3
		move.w	(a3),d0
		beq.w	.DbfSchleife
		lea	MakeListen(pc),a1
		lea	(a1,d0.w),a1
		moveq	#0,d0
		sub.l	a0,a0				*Def String
		movem.l	d2-d7/a1-a6,-(a7)
		*-----------------------------*
		* Input:  -
		* Output: d0=Error oder Null
		*	  d1=Zustand
		* oder	  a0=String
		*-----------------------------*
		jsr	(a1)
		movem.l	(a7)+,d2-d7/a1-a6
		tst.l	d0
		bne.s	.NextEinTrag
		move.w	4(a3),d2

		btst	#EPMIF_MultiText2,d2
		beq.s	.normaltext

		move.l	d1,d3
		move.l	a0,-(a7)			*in Tabelle angegebenen
		move.w	2(a3),d0			*String Kopieren
		bsr	GetLocaleString
		move.l	d0,a0
		lea	TextPuffer(a5),a1
		move.w	#TextPufferSize-2,d1
		bsr	StringCopy
		move.l	(a7)+,a0
		bsr	StringCopy
		move.l	a4,a1
		lea	TextPuffer(a5),a0
		bsr	TextToNodes
		bne.w	.Error
		bra.s	.NextEintrag

.normaltext:
		btst	#EPMIF_Text,d2
		beq.s	.OnlyOneLine
		move.l	a4,a1				*mit Zeilenumbruch
		bsr	TextToNodes
		bne.s	.Error
		bra.s	.NextEintrag


.OnlyOneLine:	btst	#EPMIF_MultiText,d2
		bne.s	.MultiText
		btst	#EPMIF_Zustand,d2
		beq.s	.TextOk
.MultiText:	move.l	d1,d3
		move.l	a0,-(a7)			*in Tabelle angegebenen
		move.w	2(a3),d0			*String Kopieren
		bsr	GetLocaleString
		move.l	d0,a0
		lea	TextPuffer(a5),a1
		move.w	#TextPufferSize-2,d1
		bsr	StringCopy
		move.l	(a7)+,a0

		*- Input:d0=Hexzahl
		*-	 d1=Flags Bit 0: 1=Hidezero
		*-		  Bit 1: 1=use negativ
		*-	 a0=OutputPuffer
		btst	#EPMIF_Zahl,d2
		beq.s	.NoZahl
		move.l	d3,d0
		move.l	EUS_Structure+EUS_EPBase(pc),a2
		moveq	#2,d1
		move.l	a1,a0
		jsr	ENPP_HexDez(a2)
		bra.s	.NimmTextPuffer

.NoZahl:	btst	#EPMIF_ZuStand,d2
		beq.s	.CopyString
		moveq	#LENr_Yes,d0
		bsr	GetLocaleString
		tst.l	d3
		bne.s	.CopyString2
		moveq	#LENr_No,d0
		bsr	GetLocaleString
.CopyString2:	move.l	d0,a0
.CopyString:	bsr	StringCopy
.NimmTextPuffer:lea	TextPuffer(a5),a0
.TextOk:	move.l	a0,d0
		beq.w	.NextEintrag			*falls a0=0
		bsr	AllocTheNode
		beq.s	.Error
		bra.w	.NextEinTrag

.DbfSchleife:	subq.l	#4,a3
		lea	EigenschaftenList(a5),a4
		dbf	d7,.NextEinTrag


		*-- listen anfgen --*
.Error:		moveq	#EPENr_InfoList,d0
		lea	InfoList(a5),a0
		bsr	ReAddlist
		moveq	#EPENr_EigenschaftenList,d0
		lea	EigenschaftenList(a5),a0
		bsr	ReAddlist


.DasWars:	bsr	TitleAufbau
		move.b	#1,ListenDa(a5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
Titleaufbau:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		moveq	#LENr_Windowtitle,d0
		bsr	GetLocaleString
		move.l	d0,a0
		move.w	#TitlePufferSize-2,d1
		lea	TitlePuffer(a5),a1
		bsr	StringCopy

		moveq	#LENR_TitlePlayers,d0
		cmp.b	#Mode_Player,Mode(a5)
		beq.s	.Players
		moveq	#LENR_TitleEngines,d0
.Players:	bsr	GetLocaleString
		move.l	d0,a0
		bsr	StringCopy

		cmp.l	#10,d1
		blo.s	.Set
		move.l	SelectedEntry(a5),d0
		bsr	Hexdez
		
		moveq	#LENr_Von,d0
		bsr	GetLocaleString
		move.l	d0,a0

		bsr	StringCopy

		cmp.l	#10,d1
		blo.s	.Set
		move.l	MaxEntries(a5),d0
		bsr	Hexdez

.Set:		moveq	#LENr_ScreenTitle,d0
		bsr	GetLocaleString
		move.l	d0,a2

		lea	TitlePuffer(a5),a1
		move.l	WinHandle(a5),a0
		move.l	INtBase(a5),a6
		jsr	_LVOSetWindowTitles(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Input: d0=Zahl
*	 a1=OutputPuffer
* Output:a1=Ende des Outputpuffers
*-----------------------------------------------------------------------------*
Hexdez:		tst.l	d0
		beq.s	.TypeNull
		movem.l	d0-d4/a0,-(a7)
		lea	hexdeztab(pc),a0
		moveq	#0,d4
		moveq	#9,d3
.HexDez1:	move.l	(a0)+,d1
		moveq	#0,d2
.HexDez2:	addq.l	#1,d2
		sub.l	d1,d0
		bcc.s	.Hexdez2
		add.l	d1,d0
		add.b	#$2f,d2
		cmp.b	#$30,d2
		bne.s	.Printealle
		tst.b	d4
		beq.s	.PrinteNoZiffer
.Printealle:	moveq	#1,d4
		move.b	d2,(a1)+
.PrinteNoZiffer:dbf	d3,.Hexdez1
		clr.b	(a1)
		movem.l	(a7)+,d0-d4/a0
		rts
.TypeNull	move.b	#$30,(a1)+
		clr.b	(a1)
		rts

	*-------- Hilfstabelle fr Hex-Dez-Umwandelung --------*
Hexdeztab:	dc.l	1000000000,100000000,10000000,1000000,100000,10000
		dc.l	1000,100,10,1

















*----------------------------------------------------------------------------*
InternalStrings:
MyProzessName		dc.b	"EP_Manager.1",0
MyCreatorname:		dc.b	"Eagleeye of DEFECT",0
MySpecialInfo:		dc.b	"Administering & configurating of players "
			dc.b	"and engines.",0
EPUserPortName:		dc.b	"EAGLEPLAYERPORT",0
MyReqToolsname:		dc.b	"reqtools.library",0
Datatypesname:		dc.b	"datatypes.library",0
MyMsgPortName:		dc.b	"EP_Manager.Port",0
Catalogname:		dc.b	"EP_Manager.catalog",0
LeerZeichen:		EQU	*-1

CU_Name:		dc.b	"CustomPlay",0
Helpnode_Add:		dc.b	"Manager_Add",0
Helpnode_DelWas:	dc.b	"Manager_Delete",0
Helpnode_DeleteAll:	dc.b	"Manager_DeleteAll",0
Helpnode_Config:	dc.b	"Manager_Config",0
Helpnode_LoadConfig:	dc.b	"Manager_LoadConfig",0
Helpnode_SaveConfig:	dc.b	"Manager_SaveConfig",0
Helpnode_Hide:		dc.b	"Hide",0

CPU_68000:		dc.b	'MC 68000',0
CPU_68010:		dc.b	'MC 68010',0
CPU_68020:		dc.b	'MC 68020',0
CPU_68030:		dc.b	'MC 68030',0
CPU_68040:		dc.b	'MC 68040',0
CPU_68060:		dc.b	'MC 68060',0
FPU_68881:		dc.b	'68881',0
FPU_68882:		dc.b	'68882',0
FPU_FPU40:		dc.b	'FPU40',0

QuitKey:		dc.b	"Q",0
Fragezeichen:		dc.b	"?",0
ConfigName:		dc.b	"Manager.config",0

ExternalStrings:
*-------------------------- Locale fr MakeCat -------------------------------*
LOCALE_START
*CATALOG	EP_Manager
*VERSION	38.2
*DATE		05.03.96

MSG_MA_WindowTitle	dc.b	"Manager, ",0
*D				'Manager, ',0
MSG_MA_ScreenTitle	dc.b	"Manager (Eagleplayer),  DEFECT Softworks",0
*D				'Manager (Eagleplayer),  DEFECT Softworks',0
MSG_MA_Players		dc.b	"Players",0	;fr MakeCat das Leerzeichen
*D				'Player ',0
MSG_MA_Engines		dc.b	"Engines",0
*D				'Engines',0
MSG_MA_Add		dc.b	"_Add",0
*D				'_Hinzu',0
MSG_MA_AddKey		dc.b	"A",0
*D				'H',0
MSG_MA_Del		dc.b	"_Delete",0
*D				'_Lschen',0
MSG_MA_DelKey		dc.b	"D",0
*D				'L',0
MSG_MA_DeleteAll	dc.b	"Delete All",0
*D				'Alle lschen',0
MSG_MA_DeleteAllKey	dc.b	"T",0
*D				'E',0
MSG_MA_Config		dc.b	"_Config",0
*D				'_Konfiguration',0
MSG_MA_ConfigKey	dc.b	"C",0
*D				'K',0
MSG_MA_LoadConfig	dc.b	"_Load",0
*D				'_Laden',0
MSG_MA_LoadConfigKey	dc.b	"L",0
*D				'L',0
MSG_MA_SaveConfig	dc.b	"_Save",0
*D				'_Speichern',0
MSG_MA_SaveConfigKey	dc.b	"S",0
*D				'S',0
MSG_MA_Mode		dc.b	"_Mode",0
*D				'_Modus',0
MSG_MA_ModeKey		dc.b	"M",0
*D				'M',0
MSG_MA_Verfugbar	dc.b	"Available",0
*D				'Verfgbar',0
MSG_MA_InfoName		dc.b	"Informations",0
*D				'Informationen',0
MSG_MA_Eigenschaften	dc.b	"Qualities",0
*D				'Eigenschaften',0
MSG_MA_Project		dc.b	"Project",0
*D				'Projekt',0
MSG_MA_About		dc.b	"About",0
*D				'ber',0
MSG_MA_AboutKey		dc.b	"A",0
*D				'',0
MSG_MA_Hide		dc.b	"Hide",0
*D				'Verstecken',0
MSG_MA_HideKey		dc.b	"H",0
*D				'V',0
MSG_MA_Quit		dc.b	"Quit",0
*D				'Ende',0
MSG_MA_Ok		dc.b	"Ok",0
*D				'Ok',0
MSG_MA_RequestTitle	dc.b	"Manager-Message",0
*D				'Managernachricht',0
MSG_MA_AboutText	dc.b	"Manager 1.5"
			dc.b	" by",10,10
			dc.b	"Jan Blumenthal",10
			dc.b	"Erich-Mhsam-Str. 34",10
			dc.b	"18069 Rostock",10
			dc.b	"Tel.: +49 (0)381/83979",10,0
*D				'Manager V1.5 von',10,10
*D				'Jan Blumenthal',10
*D				'Erich-Mhsam-Str. 34',10
*D				'18069 Rostock',10
*D				'Tel.: +49 (0)381/83979',10,0

MSG_MA_EPNotFound	dc.b	"Cannot find EaglePlayer Port",0
*D				'Eagleplayer nicht gefunden!',0
MSG_MA_EngineNotLoaded	dc.b	"Engine not loaded!",0
*D				'Das Engine wurde noch nicht geladen!',0
MSG_MA_PlayerNotLoaded	dc.b	"Player not loaded!",0
*D				'Der Player wurde noch nicht geladen!',0

MSG_MA_Yes		dc.b	"Yes",0
*D				'Ja',0
MSG_MA_No		dc.b	"No",0
*D				'Nein',0

MSG_MA_Type_Unknown	dc.b	"Unknown enginetype",0
*D				'Unbekannter Enginetyp',0
MSG_MA_Type_Manager	dc.b	"Manager",0
*D				'Manager',0
MSG_MA_Type_SampleInfo	dc.b	"Sampleinfo",0
*D				'Sampleinfo',0
MSG_MA_Type_Engineinfo	dc.b	"Engineinfo",0
*D				'Engineinfo',0
MSG_MA_Type_Playerinfo	dc.b	"Playerinfo",0
*D				'Playerinfo',0
MSG_MA_Type_Decruncher	dc.b	"Decruncher",0
*D				'Decruncher',0
MSG_MA_Type_Ripper	dc.b	"Ripper",0
*D				'Ripper',0
MSG_MA_Type_Mainwindow	dc.b	"Mainwindow",0
*D				'Mainwindow',0
MSG_MA_Type_Screenmanager dc.b	"Screenmanager",0
*D				'Screenmanager',0
MSG_MA_Type_DirViewer	dc.b	"Directoryviewer",0
*D				'Directoryviewer',0
MSG_MA_Type_Analyzer	dc.b	"Analyzer",0
*D				'Analyzer',0
MSG_MA_Type_Amplifier	dc.b	"Amplifier",0
*D				'Amplifier',0
MSG_MA_Type_Patternscroll dc.b	"Patternscroll",0
*D				'Patternscroll',0
MSG_MA_Type_Messagewindow dc.b	"Messagewindow",0
*D				'Messagewindow',0
MSG_MA_Type_Listadministration dc.b	"Listadministration",0
*D				'Listadministration',0
MSG_MA_Type_Amplifiermanager	dc.b	"Amplifiermanager",0
*D				'Amplifiermanager',0
MSG_MA_Type_PlayerLoader dc.b	"Playerloader",0
*D				'Playerloader',0
MSG_MA_Type_Extractor	dc.b	"Extractor",0
*D				'Extraktor',0
MSG_MA_Type_Scope	dc.b	"Scope",0
*D				'Scope',0
MSG_MA_Type_Moduleinfo	dc.b	"Moduleinfo",0
*D				'Moduleinfo',0



MSG_MA_Pls_Prefix	dc.b	"Prefix: ",0
*D				'Prefix: ',0
MSG_MA_Pls_Volume	dc.b	"Volume: ",0
*D				'Lautstrke: ',0
MSG_MA_Pls_Balance	dc.b	"Balance: ",0
*D				'Balance: ',0
MSG_MA_Pls_Voices	dc.b	"Voices: ",0
*D				'Stimmen: ',0
MSG_MA_Pls_Speed	dc.b	"Speed: ",0
*D				'Geschwindigkeit: ',0
MSG_MA_Pls_Patternjump	dc.b	"Patternjump: ",0
*D				'Patternsprung: ',0
MSG_MA_Pls_PatternScroll dc.b	"Patternscroll: ",0
*D				'Patternscroller: ',0
MSG_MA_Pls_PositionNr	dc.b	"Positionnr: ",0
*D				'Positionsnr: ',0
MSG_MA_Pls_SubSongs	dc.b	"Subsongs: ",0
*D				'Mehrere Songs im Module: ',0
MSG_MA_Pls_SongEnd	dc.b	"Songend: ",0
*D				'Songenderkennung: ',0
MSG_MA_Pls_Amplifier	dc.b	"Amplifier: ",0
*D				'Amplifier: ',0
MSG_MA_Pls_Scopes	dc.b	"Scopes: ",0
*D				'Grafische Anzeige: ',0
MSG_MA_Pls_CalcDuration	dc.b	"Calc duration: ",0
*D				'Spielzeit berechnen: ',0
MSG_MA_Pls_Check	dc.b	"Check module: ",0
*D				'Modulecheck: ',0
MSG_MA_Pls_Multifiles	dc.b	"Multifiles: ",0
*D				'Mehrere Files: ',0
MSG_MA_Pls_Autorerkennung dc.b	"Search authorname: ",0
*D				'Autorerkennung: ',0
MSG_MA_Pls_ModuleInfo	dc.b	"Moduleinfo: ",0
*D				'Moduleinfo: ',0
MSG_MA_Pls_SampleInfo	dc.b	"Sampleinfo: ",0
*D				'Sampleinfo: ',0
MSG_MA_Pls_ModuleChange	dc.b	"Replay in module: ",0
*D				'Abspieler im Module: ',0
MSG_MA_Pls_SaveModule	dc.b	"Save module: ",0
*D				'Module speichern: ',0
MSG_MA_Pls_SaveAsProTracker dc.b "Save as Protracker: ",0
*D				'Speichern als Protracker: ',0
MSG_MA_Pls_LoadFast	dc.b	"Load Fastram: ",0
*D				'Spielen im FastRAM: ',0
MSG_MA_Pls_Maxlength	dc.b	"Max. songlength: ",0
*D				'Max. Songlnge: ',0
MSG_MA_Pls_MaxSamples	dc.b	"Max. samples: ",0
*D				'Max. Instrumente: ',0
MSG_MA_Pls_MaxSynthSamples dc.b	"Max. synthsamples: ",0
*D				'Max. Synthtische Instrumente: ',0
MSG_MA_Pls_MaxPattern	dc.b	"Max. pattern: ",0
*D				'Max. Pattern: ',0
MSG_MA_Pls_MaxSubSongs	dc.b	"Max. subsongs: ",0
*D				'Max. Songs im Module: ',0

MSG_MA_Pls_UnpackedSystem dc.b	"Unpacked system: ",0
*D				'Entpacktes Soundsystem: ',0
MSG_MA_OldSoundTracker	dc.b	"OldSoundtracker",0
*D				'OldSoundtracker',0
MSG_MA_SoundTracker	dc.b	"Soundtracker",0
*D				'Soundtracker',0
MSG_MA_NoiseTracker	dc.b	"Noisetracker",0
*D				'Noisetracker',0
MSG_MA_Protracker	dc.b	"Protracker",0
*D				'Protracker',0

MSG_MA_EnI_Name		dc.b	"Name: ",0
*D				'Name: ',0
MSG_MA_EnI_Creator	dc.b	"Creator: ",0
*D				'Programmiert von: ',0
MSG_MA_EnI_Date		dc.b	"Date: ",0
*D				'Datum: ',0
MSG_MA_EnI_Version	dc.b	"Version: ",0
*D				'Version: ',0
MSG_MA_EnI_EPVersion	dc.b	"Min. Eagleplayerversion: ",0
*D				'Min. Eagleplayerversion: ',0
MSG_MA_EnI_KickStart	dc.b	"Min. Kickstart: ",0
*D				'Min. Kickstart: ',0
MSG_MA_EnI_CPU		dc.b	"Required CPU: ",0
*D				'Bentigte CPU: ',0
MSG_MA_EnI_FPU		dc.b	"Required FPU: ",0
*D				'Bentigte FPU: ',0
MSG_MA_EnI_Notneeded	dc.b	"not needed",0
*D				'nicht erforderlich',0
MSG_MA_EnI_About	dc.b	"About engine: ",0
*D				'ber das Engine : ',0
MSG_MA_EnI_Type		dc.b	"Enginetype: ",0
*D				'Enginetyp: ',0
MSG_MA_SelectBackPic	dc.b	'Select Background picture',0
*D				'Whle Hintergrundbild',0
MSG_MA_BackPic		dc.b	'Background picture',0
*D				'Hintergrundbild',0
MSG_MA_ManConfig	dc.b	'Config',0
*D				'Konfiguration',0
MSG_MA_ManSaveConfig	dc.b	'Save Config',0
*D				'Speichere Konfiguration',0
MSG_MA_LENr_Von		dc.b	' of ',0
*D				' von ',0
MSG_MA_LENr_Players	dc.b	"Player: ",0
*D				'Player: ',0
MSG_MA_LENr_Engines	dc.b	"Engine: ",0
*D				'Engine: ',0
LOCALE_END
			dc.b	0		* <-- Kennung fr Ende




		SECTION	BSSMErkPuffer,BSS
Puffer		ds.b	PufferEnd

