*****************************************************************************
**                                                                         **
** Engine: Levelmeter                                                      **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


;**********************************************************************
;**            Eagleplayer Levelmeter Color V1.0                     **
;**               1993 Henryk "BUGGS" Richter                       **
;**              geschrieben auf ASM-ONE V1.02                       **
;**********************************************************************
	;
	incdir	include:
	include	exec/exec_lib.i
	include	exec/libraries.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	misc/Eagleplayerengine.i
	include	dos/dos_lib.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	misc/buggsmacros.i

ver		macro
		dc.b	"1.13"
		endm
StructVer	macro
		dc.w	1,13
		endm
date		macro
		dc.b	"05-Apr-97"
		endm
StructDate	macro
		dc.b	05,04
		dc.w	1997
		endm


Test = 0	;auf 0 lassen zur Nutzung mit dem Eagleplayer !!!!!
		;(zu Testzwecken meldet sich sonst der Analyzer selbst ab !)
debug = 0
;===========================================================================
	section	0,code
;===========================================================================
an_num = 64			;Anzahl der Balken (bloss nicht ndern)
an_zeilen = 8			;Keine nderung zulssig,siehe oben,siehe auch
				;GURU-LISTE
win_breite = (an_num+5+2)*8
peek_time = 50			;1 Sekunde warten (Spitzenpegelanzeige)
;===========================================================================
BEGIN
	bra.w	fangan
	EUSN_Identifier
	dc.l	0		;eus_next
	ifne	debug
	dc.w	-2
	else
	dc.w	0		;eus_Usernr
	endc
MyEPBase
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;eus_unused3
	dc.l	Tagliste	;eus_unused4
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_Zipwin!USMB_ChangeConfig!USMB_ChangeInterrupt;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname	;eus_Cname
	dc.l	myinfo
	dc.w	39		;eus_Kickstart
	dc.l	8		;eus_EPVersion
	structver		;eus_version,revision
	dc.l	MyUsername	;eus_username
	dc.w	0		;eus_winx
	dc.w	220		;eus_winy
	dc.w	EUSB_openwin	;EUS_Flags, Window offen

	dc.l	0		;EUS_Special
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	structdate		;EUS_Creatordate
	dc.b	-5		;EUS_Priority
	dc.b	EUTY_Scope
	dc.w	0
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

		ifne	(*-begin)-EUS_SizeOF
		Aber Hallo
		endc

	dc.b	`$VER: LevelMeter Color `
	ver
	dc.b	`, (`
	date
	dc.b	`)`,0
	even

Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Levelmeter
		*dc.l	EUT_AttnFlags,1<<6!1<<3
		dc.l	0

fangan
	move.l	4.w,a6			;Execbase laden

	lea	datas,a5		;allumfassendes Basisregister
	move.l	a5,a0
	move.w	#dataslen-1,d0		;BSS-Sektion vollstndig lschen
.clr	move.b	#0,(a0)+
	dbf	d0,.clr

	lea	fulls(a5),a0
	moveq	#7,d0
.w1
	move.l	#-1,(a0)+
	dbf	d0,.w1

	move.l	#-1,mypen1(a5)
	move.l	#-1,mypen2(a5)


	bsr	SetupLibsPorts
	tst.l	d7
	blt	ende

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse usw. haben mchte
	blt	endme	;Fehler aufgetreten (Register D7 < 0),Programm beenden

	bsr	HandleActions		;Auf Usereingaben und Eagleplayer-
					;signale reagieren (Hauptprogramm
;========= Programmende =====================================================
endme
	move.l	d7,-(sp)
	bsr	closewin	;Fenster zu !
	move.l	(sp)+,d7
				;Error oder Exit-Message vom Player ?

	blt.s	Ende	;kein Fehler,sondern Aufruf zum frhlichen ENDE
			;vom Eagleplayer erhalten

	bsr	Sendlastmessage	;einige letzte Worte,falls eigenmchtige Ver-
				;abschiedung (darf aber nicht auftreten
Ende
	bsr	DelLibsPorts
	rts
********************* SetUproutine ******************************************
SetupLibsPorts
	moveq	#-1,d7
	lea	begin(pc),a0
	move.l	EUS_EPBase(a0),a0
	lea	EPG_someprefs(a0),a0
	move.l	a0,flagsadr(A5)

	moveq	#-1,d0			;irgendein Signal
	jsr	_LVOallocsignal(a6)	;allokieren
	move.l	d0,mysignal(a5)		;merken
	tst.l	d0
	blt	NoSignal

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)	;Task finden
	move.l	d0,mytask(a5)
					;Message Port initialisieren
	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;MSG Signal zuweisen lassen
	move.l	d0,mysignal2(a5)		;merken
	tst.l	d0
	blt	nosignal2		;Fehler

	lea	MsgPort(a5),a4		;MSG Port Struktur initialisieren

	move.b	#nt_msgport,ln_type(a4)
	move.b	#0,ln_pri(a4)
	move.b	#pa_signal,mp_flags(a4)
	move.b	d0,mp_sigbit(a4)

	move.l	mytask(a5),mp_sigtask(a4);mp_SigTask

	lea	mp_msglist(a4),a1
	Newlist	a1			;macro in Lists.i

	lea	int(pc),a1
	moveq	#39,d0
	jsr	_LVOopenlibrary(a6)	;INTUITION V1.2
	tst.l	d0
	beq	NOINT
	move.l	d0,intsave(a5)

	lea	graf(pc),a1
	moveq	#39,d0
	jsr	_LVOopenlibrary(a6)	;GRAPHICS V1.2
	tst.l	d0
	beq	NOGRAF
	move.l	d0,grafsave(a5)

	lea	gad(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,gadsave(a5)
	beq	nogadto

	moveq	#0,d7			;Rckgabewert
	rts
******************** Libraries , Signale und Ports killen ********************
DelLibsPorts
	move.l	mypubscreen(a5),d0	;Public Screen loslassen,falls nicht
	beq.s	.ok			;schon getan
	move.l	d0,a1
	suba.l	a0,a0
	move.l	intsave(A5),a6
	jsr	_LVOunlockpubscreen(a6)
.ok
	move.l	gadsave(a5),d0
	beq.s	NOGADTO
	move.l	d0,a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(A6)
NOGADTO
	move.l	grafsave(a5),d0
	beq.s	Nograf
	move.l	d0,a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
NoGraf
	move.l	intsave(a5),d0
	beq.s	Noint
	move.l	d0,a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
noint
	move.l	4.w,a6			;eigenen Port wieder entfernen
	move.l	mysignal2(a5),d0
	cmp.l	#-1,d0
	beq.s	NoSignal2
	jsr	_LVOfreesignal(a6)
NoSignal2
	move.l	mysignal(a5),d0
	cmp.l	#-1,d0
	beq.s	NoSignal
	move.l	4.w,a6
	jsr	_LVOfreesignal(a6)
NoSignal
	moveq	#0,d0			;Returncode
	rts
************************************************************************
*                   Fenster ffnen                                     *
************************************************************************
Openwin
	tst.l	winhandle(a5)	;haben wir denn schon ein Fensterle ??
	bne.w	.Error

	move.l	intsave(a5),a6
	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep2
	move.l	d0,a0
	move.l	EPG_Pubscreen(a0),d0
.noep2
	clr.l	mypubscreen(A5)		;sicher gehen
	move.l	d0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	bne.s	.pubs

	suba.l	a0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	beq	.Error			;sollte nicht auftreten (warum auch ?)
.pubs
	move.l	d0,mypubscreen(a5)	;fr UnLockpubscreen() merken
	move.l	d0,a1
	move.l	sc_font(a1),a0
	move.l	a0,fontatt(a5)		;fr Fonthhenberechnung sichern

	bsr	getwinheight		;in D1 Windowhhe abholen 
					;(welch Service)

	movem.l	d0-d6/a0-a6,-(sp)
	bsr	makemenus		;Mens basteln
	movem.l	(sp)+,d0-d6/a0-a6
	tst.l	d7
	blt.w	.Error

	move.l	mypubscreen(a5),a1
	bsr	AllocPens		;2 Pens alloc
	tst.l	d7
	bne	.error_2
					;WINDOW INIT
	lea	mytags(a5),a1		;Zeiger auf Tagliste

	move.l	#WA_Pubscreen,(a1)+
	move.l	mypubscreen(a5),a2
	move.l	a2,(a1)+

	move.l	#wa_newlookmenus,(a1)+
	move.l	#1,(A1)+
	
	move.l	#wa_Pubscreenfallback,(A1)+
	move.l	#1,(a1)+

	lea	begin(pc),a0		;Zeiger auf Struktur am Programmanfang
	moveq	#0,d0
	move.l	#wa_top,(a1)+		;Y-Position des Fensters

	move.w	eus_winy(a0),d0		;holen und eintragen
	move.l	d0,(a1)+

	move.l	#wa_left,(a1)+		;X-Position
	move.w	eus_winx(a0),d0
	move.l	d0,(a1)+

	move.l	#wa_innerwidth,(a1)+	;Breite
	move.l	#win_breite-6,(a1)+

	move.l	#wa_height,(a1)+	;Hhe
	move.l	d1,(a1)+
	move.w	d1,win_hoehe(A5)

	move.l	#wa_flags,(a1)+
	move.l	#Windowdrag!Windowdepth!Windowclose,(a1)+ ;das soll er knnen

	move.l	#WA_TITLE,(a1)+		;Windowname
	lea	mywinname(pc),a0
	move.l	a0,(a1)+
	move.l	#wa_zoom,(a1)+
	lea	myzoom(a5),a0
	move.w	#0,(a0)		;X-Position im ZIP-Mode
	move.w	#101,2(a0)	;Y-Position im ZIP-Mode
	move.w	#168,4(a0)		;Breite des Zip-Windows im SMALL-MODE
	move.w	myhoehe1(a5),myhoehe2(a5)
	move.l	a0,(a1)+
	move.l	#wa_idcmp,(a1)+
	move.l	#closewindow!menupick!refreshwindow,(a1)+ ;das wolln wir wissen
	move.l	#wa_autoadjust,(a1)+	;Gre notfalls einschrnken
	move.l	#1,(a1)+

	move.l	#WA_ScreenTitle,(a1)+
	move.l	#Project0STitle,(a1)+
	
	move.l	#TAG_DONE,(a1)+		;das war alles

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;alloah Window !
	move.l	d0,Winhandle(a5)
	tst.l	d0
	bne.s	.winopened

	lea	mytags(a5),a1		;Fehler,nochmal auf Position 0/0
	move.l	#wa_top,(a1)+		;zu ffnen versuchen
	move.l	#0,(a1)+
	move.l	#wa_left,(a1)+
	move.l	#0,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;wirst DU wohl aufgehen !
	move.l	d0,Winhandle(a5)
	tst.l	d0
	beq	.Error
.winopened
	move.l	d0,a0
	move.l	wd_userport(a0),a0	;User Port holen
	move.l	a0,port(a5)		;und sichern

	lea	my_bitmap(a5),a3
	bsr	makebitmap		;EXTRA Bitmap erzeugen
	bge.s	.gotit			;ist erzeugt

	move.l	intsave(a5),a6		;wenn nicht mal die paar Bytes fr
	move.l	winhandle(a5),a0	;unsere 2.Bitmap da sind,Fenster wieder
	clr.l	Winhandle(a5)		;schlieen
	clr.l	port(a5)
	jsr	_LVOclosewindow(a6)

	bra.s	.Error			;Fehler
.gotit
	bsr	makegadget		;Gadget erstellen

	bsr	addmenus		;Men darstellen
	bsr	refresh			;Rahmen zeichnen
.error
	move.l	intsave(a5),a6
	suba.l	a0,a0
	move.l	mypubscreen(a5),d0
	beq.s	.nopub
	move.l	d0,a1
	move.l	#0,mypubscreen(a5)
	jmp	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.nopub	rts
.error_2
	bsr	freemenus
	bra.s	.error
*******************************************************************************
*                        Mens erstellen                                      *
*******************************************************************************
MakeMenus
	move.l	gadsave(a5),A6

	move.l	mypubscreen(a5),a0
	suba.l	a1,a1
	jsr	_LVOgetvisualinfoa(a6)	;Visual Info vom Screen anfordern
	move.l	d0,vi(a5)
	tst.l	d0
	beq	.nomen

	lea	mymenus(A5),a0
	move.b	#nm_title,gnm_type(a0)
	lea	mylabel1(pc),a1
	move.l	a1,gnm_Label(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*1(a0)
	lea	mylabel2(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*1(a0)
	lea	mylabel21(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*1(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*2(a0)
	lea	mylabel3(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*2(a0)
	lea	mylabel31(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*2(a0)
	
	move.b	#nm_item,gnm_type+gnm_sizeof*3(a0)
	lea	mylabel4(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*3(a0)
	lea	mylabel41(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*3(a0)
	
	move.b	#nm_end,gnm_type+gnm_sizeof*4(a0)

	move.l	gadsave(a5),a6
	lea	mytags(a5),a1
	move.l	#gtmn_fullmenu,(a1)+
	move.l	#1,(a1)+
	move.l	#GTMN_Newlookmenus,(a1)+
	move.l	#1,(A1)+
	move.l	#tag_done,(a1)+
	lea	mytags(a5),a1

	jsr	_LVOcreatemenusA(a6)
	move.l	d0,menuadr(a5)
	tst.l	d0
	beq.s	.nomen
	move.l	d0,a0
	move.l	vi(a5),a1

	lea	mytags(a5),a2
	move.l	#GTMN_Newlookmenus,(a2)+
	move.l	#1,(A2)+
	move.l	#tag_done,(a2)+
	lea	mytags(a5),a2

	jsr	_LVOLayoutMenusA(a6)
	tst.l	d0
	beq.s	.free
	
	moveq	#0,d7
	rts
.free
	move.l	menuadr(a5),a0
	jsr	_LVOfreemenus(a6)
.nomen
	moveq	#-1,d7
	rts
********************* Visual Info Freigeben ***********************************
Freevi:
	move.l	vi(a5),a0
	jmp	_LVOfreevisualinfo(a6)
*********************** Men wechschmeisen ************************************
Freemenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	jsr	_LVOclearmenustrip(A6)
	
	move.l	gadsave(a5),a6
	move.l	Menuadr(a5),d0
	beq.s	.end
	move.l	d0,a0
	jmp	_LVOfreemenus(a6)
.end
	bsr	Freevi	;Visual Info Wegschmeien
RET	rts
********************* Men anhngen *************************
Addmenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	move.l	Menuadr(a5),a1
	jmp	_LVOsetmenustrip(a6)
***************************************************************************
*              2 Pens von dem aktuellen Screen allokieren                 *
*                           A1: PubScreen                                 *
*      wenn einer oder beide nicht verfgbar, sofort freigegeben          *
***************************************************************************
AllocPens
	movem.l	d0-d6/a0-a6,-(sp)

	moveq	#-1,d7
	move.l	sc_viewport+vp_colormap(a1),a0	;Viewport->Colormap
	move.l	a0,mycmap(A5)
	moveq	#-1,d0			;Number
	move.l	#212<<24,d1		;Red
	move.l	#212<<24,d2		;Green
	move.l	#240<<24,d3		;Blue

	lea	mytags(A5),a1
	move.l	#OBP_Precision,(a1)
	move.l	#PRECISION_EXACT,4(a1)
	move.l	#OBP_FailifBad,8(A1)
	move.l	#0,12(a1)
	move.l	#0,16(a1)
	move.l	grafsave(A5),a6
	jsr	_LVOObtainBestPenA(A6)
	move.l	d0,mypen1(A5)
	cmp.l	#255,d0
	blo.s	.penok1
	bra.s	.fail2
.penfail
	move.l	mycmap(A5),a0
	jsr	_LVOreleasepen(A6)
	move.l	#-1,mypen2(A5)
.fail2
	move.l	mypen1(a5),d0
	move.l	mycmap(A5),a0
	jsr	_LVOreleasepen(A6)
	move.l	#-1,mypen1(A5)

	lea	NoPenMessage(pc),a0
	bsr	Merror
	bra	.Error
.penok1
	move.l	mycmap(A5),a0
	moveq	#-1,d0			;Number
	move.l	#255<<24,d1		;Red
	moveq	#0,d2			;Green
	move.l	#38<<24,d3		;Blue
	moveq	#0,d4			;Flags
	move.l	grafsave(A5),a6
	jsr	_LVOobtainpen(A6)
	move.l	d0,mypen2(A5)
	cmp.l	#255,d0
	bls.s	.penok

	move.l	mycmap(A5),a0
	moveq	#-1,d0			;Number
	move.l	#255<<24,d1		;Red
	move.l	#99<<24,d2		;Green
	move.l	#111<<24,d3		;Blue
	lea	mytags(A5),a1
	move.l	#OBP_Precision,(a1)
	move.l	#PRECISION_EXACT,4(a1)
	move.l	#OBP_FailifBad,8(A1)
	move.l	#0,12(a1)
	move.l	#0,16(a1)
	move.l	grafsave(A5),a6
	jsr	_LVOObtainBestPenA(A6)
	move.l	d0,mypen2(A5)
	cmp.l	#255,d0
	bhi.w	.penfail
.penok
	moveq	#0,d7
.error
	movem.l	(sp)+,d0-d6/a0-a6
	rts
************************ 2 Pens wieder freigeben *******************
Freepens
	movem.l	d0-a6,-(sp)
	move.l	mypen1(A5),d0
	blt.s	.nopen
	move.l	mycmap(A5),a0
	move.l	grafsave(A5),a6
	jsr	_LVOreleasepen(A6)
	move.l	#-1,mypen1(A5)
.nopen
	move.l	mypen2(A5),d0
	blt.s	.nopen2
	move.l	mycmap(A5),a0
	move.l	grafsave(A5),a6
	jsr	_LVOreleasepen(A6)
	move.l	#-1,mypen2(A5)
.nopen2
	movem.l	(sp)+,d0-a6
	rts
*******************************************************************
*           Gadget umbauen und einbinden                          *
*******************************************************************
MakeGadget
	move.l	mypen1(a5),d1			;Pen
	move.l	mypen2(a5),d2
	cmp.l	d1,d2
	bgt.s	.d2
	move.l	d1,d2
.d2
	moveq	#0,d3
.ok
	addq.w	#1,d3
	asr.l	#1,d2
	bne.s	.ok
	move.w	d3,Mode1Depth

	lea	gadplane,a1
	bsr.s	.doweiss

	move.l	mypen2(a5),d1			;Pen
	bsr	dorot

	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	lea	gadpic,a1
	clr.l	(a1)
	moveq	#0,d0
	jsr	_LVOaddgadget(A6)
	rts
.doweiss
	moveq	#-1,d0				;fr 1. Bitplane
	lea	Weiss.Raw(pc),a0		;wenn unterstes Bit nicht
						;gesetzt, die Grafik rauskillen
	lsr.w	#1,d1
	bcc.s	.clr1
	lea	nulls(a5),a0
.clr1
	move.w	#528/8*20/4-1,d7
.copyplane10
	move.l	(a0)+,d2
	eor.l	d0,d2
	move.l	d2,(a1)+
	dbf	d7,.copyplane10

	moveq	#7-1,d7
.copyplanes1
	lea	Weiss.Raw(pc),a0
	lsr.w	#1,d1
	bcs.s	.noclr
	lea	nulls(a5),a0
.noclr
	move.w	#528/8*20/4-1,d6
.copyplane.11
	move.l	(a0)+,(a1)+
	dbf	d6,.copyplane.11

	dbf	d7,.copyplanes1
	rts
dorot
	lea	gadplane+272/8,a1

	moveq	#-1,d0				;fr 1. Bitplane
	lea	Rot.Raw(pc),a0			;wenn unterstes Bit nicht
						;gesetzt, die Grafik rauskillen
	lsr.w	#1,d1
	bcc.s	.clr1
	lea	nulls(a5),a0
.clr1
	moveq	#14-1,d6
.copy101
	move.w	#[528-272]/8/4-1,d7
.copyplane10
	move.l	(a0)+,d2
	eor.l	d0,d2
	move.l	d2,(a1)+
	dbf	d7,.copyplane10
	add.w	#272/8,a1
	dbf	d6,.copy101


	move.l	#272/8+528/8*20,d4

	moveq	#7-1,d7
.copyplanes1
	lea	gadplane,a1
	add.l	d4,a1

	lea	rot.Raw(pc),a0
	lsr.w	#1,d1
	bcs.s	.noclr
	lea	nulls(a5),a0
.noclr
	moveq	#14-1,d5
.copy102
	move.w	#[528-272]/8/4-1,d6
.copyplane.11
	move.l	(a0)+,(a1)+
	dbf	d6,.copyplane.11
	add.w	#272/8,a1
	dbf	d5,.copy102

	add.l	#528/8*20,d4

	dbf	d7,.copyplanes1
	rts

*******************************************************************
*                   Window schlieen                              *
*******************************************************************
Closewin
	tst.l	winhandle(a5)	;Window gar nicht auf ?
	beq.s	.nowin	;nein,raus

	bsr	freepens

	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	lea	gadpic(pc),a1
	jsr	_LVOremovegadget(A6)

	bsr	freebitmap	;Extra Bitmap freigeben
	bsr	freemenus	;Mens freigeben
	
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq.s	.nosetxy		;ja; X,Y-Position nicht merken
	lea	begin(pc),a1
	move.w	wd_topedge(a0),eus_winy(a1)
	move.w	wd_leftedge(a0),eus_winx(a1)
.nosetxy
	clr.l	Winhandle(a5)
	clr.l	port(a5)
	jsr	_LVOclosewindow(a6) ;Window schlieen
.nowin	rts
********************************************************************
*    Init Message Struktur,Willkommensnachricht an Eagleplayer     *
********************************************************************
Sendfirstmessage
	move.l	4.w,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)	;Eagleplayers Port finden
	tst.l	d0
	bne.s	.ok
					;Wenn dieser nicht gefunden werden
					;konnte,
	bsr	 openwin		;Fenster ffnen

					;und Requester erstellen,der mitteilt,
					;da kein Eagleplayer weit und breit
					;zu finden ist
	lea	NoportMessage(pc),a0
	lea	my_easystruct(a5),a1
	move.l	a0,es_textformat(a1)
	lea	my_easygadget2(pc),a0
	move.l	a0,es_gadgetformat(a1)
	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),d0	;*Window
	beq.w	.error	;kann kein Window ffnen
	move.l	d0,a0
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	tst.l	d0
	beq.s	.error

	bra	SendFirstmessage	;nochmal versuchen
.ok
	move.l	d0,a0			;Portadresse

	
	lea.l	msgport(a5),a1
	move.l	a1,d3			;Msgportadresse
	move.l	mytask(a5),d4		;Taskadresse
	move.l	mysignal(a5),d5		;Signalnummer
	move.w	#USclass_Newuserprg,d6	;Meldung,da ein neues Userprogramm an-
					;kommt
	ifne	debug

	lea	Mymessage(a5),a1	;Messageadresse
	moveq	#um_sizeof>>1-1,d0
.clr
	clr.w	(a1)+
	dbf	d0,.clr

	lea	Mymessage(a5),a1	;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2
	move.l	a2,um_result(a1)
	move.w	#-2,UM_UserNr(a1)
	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jsr	_LVOputmsg(a6)

	else
	bsr	sendmess
	endc

	moveq	#0,d7			;alles klar
	rts				;Rcksprung
.error
	moveq	#-1,d7			;Fatal Error
	rts				;Ende

******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
;NUR ZU TESTZWECKEN,KEIN USERPROGRAMM SOLLTE SICH EIGENMCHTIG VERABSCHIEDEN,
;DA DER PLAYER SONST VERGEBLICH AUF DAS RCKSENDEN DER NACHRICHTEN WARTET
Sendlastmessage:
	move.l	4.w,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	lea.l	msgport(a5),a1
	move.l	a1,d3			;Messageport
	moveq	#0,d4			;Taskadresse
	moveq	#0,d5			;Signal
	move.w	#USclass_exit,d6	;Ruf:Ende

	bsr	sendmess	;senden
.wait					;auf Rckmeldung warten
	lea.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	lea.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
*******************************************************************************
sendmess:
	lea	Mymessage(a5),a1		;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)	;Lnge
	move.b	#nt_message,ln_type(a1) 	;Typ: Message

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)	;Typ der Message

	move.l	d3,mn_replyport(a1)		;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)		;Portadresse fr EaglePlayer
	move.l	d4,UM_TaskAdr(a1)		;Taskadresse
	move.l	d5,UM_Signal(a1)		;Signalnummer
	move.w	d6,UM_class(a1)			;Messageinhalt
				;z.B. USClass_Closewin,USclass_Newuserprg

	move.b	#1,messagesent(a5)		;merken,da Nachricht gesendet

	move.l	4.w,a6
	jmp	_LVOputmsg(a6)		;Nachricht losschicken
*****************************************************************************
* Hhe des Hauptfensters berechnen unter Anpassung an den eingestellten Font*
*                  A0=Fontatt,A1=PubScreen                                  *
*****************************************************************************
getwinheight:
	move.w	ta_ysize(a0),d0		;Hhe des Screenfonts
	move.w	d0,d1
	move.w	d0,fonth(a5)
	add.w	#3,d1			;Berechnen der Gre fr ZIPwindow()
	move.w	d1,myhoehe1(a5)		;und eintragen
	
	lea	GadPic,a0
	move.w	d1,gg_topedge(a0)	;Gadget (Grafik) der Titelzeilen-
					;hhe anpassen (wegen Screenfont)
	addq.w	#5,gg_topedge(a0)	;1 tiefer setzen

	move.b	SC_Wborleft(a1),d0
	ext.w	d0
	move.w	d0,offx(a5)
	move.w	d0,gg_leftedge(a0)
	add.w	#17,gg_leftedge(a0)

	move.b	SC_Wborbottom(a1),d0
	ext.w	d0
	add.w	d0,d1
	add.w	#AN_zeilen+18+9,d1	;6 Y-Stufen des Analyzers + Rand
	rts
*************************************************************
*     2. Bitmap erzeugen fr direkten Zugriff auf Bild      *
*       (per Blitter wird kopiert,Tiefe = 2)                *
* Adresse auf leere Struktur in A3 bergeben                *
*************************************************************
makebitmap
	move.w	#an_num,(a3)		;bm_BytesPerRow
	move.w	#an_zeilen,bm_rows(a3)	;64 Zeilen

	move.l	mypen1(a5),d0
	moveq	#0,d1
.ok
	addq.w	#1,d1
	asr.l	#1,d0
	bne.s	.ok

	move.b	d1,bm_depth(a3)		;auf 1 lassen

	move.l	#[an_num+4]*8*an_Zeilen,d0
	move.l	#$10002,d1		;#memf_chip,d1
	move.l	4.w,a6
	jsr	_LVOallocmem(a6)
	tst.l	d0
	beq.s	.norast

	lea	bm_planes(A3),a1
	moveq	#7,d1
.bpl	
	move.l	d0,(a1)+		 ;hier
	add.l	#[an_num]*an_zeilen,d0 ;alle 8 Bitplanes eintragen
	dbf	d1,.bpl

	moveq	#0,d7			;alles klar
	rts
.norast
	moveq	#-1,d7			;fatal Error
	rts
**************************************************************
*                   Bitplane(s) freigeben                    *
**************************************************************
freebitmap
	move.l	4,a6
	lea	my_bitmap(a5),a1
	move.l	bm_planes(a1),d0	;Planeptr[1]
	beq.s	.no1
	move.l	d0,a1
	move.l	#[an_num+4]*8*an_zeilen,d0
	jsr	_LVOfreemem(a6)	
.no1
	lea	my_bitmap(a5),a1
	clr.l	bm_planes(a1)	;Planeptr[1] lschen
	rts
*************************************************************
*                   Rahmen zeichnen                         *
*************************************************************
Refresh:
	move.l	winhandle(a5),d0
	beq.w	RET
	move.l	d0,a0

	move.w	myhoehe1(a5),d1		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d1
	beq.w	RET			;ja,kein Refresh

	move.l	grafsave(a5),a6
	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0
	jsr	_LVOsetapen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	move.b	#1,rp_areaptsz(a1)
	lea	patt1(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	offx(A5),d0		;x1
	move.w	myhoehe1(A5),d1		;y1
	move.w	#win_breite-6,d2	;x2
	add.w	d0,d2
	move.w	#AN_zeilen+15-3+15,d3	;y2
	add.w	d1,d3
	movem.l	d4-d5,-(sp)
	jsr	_LVOrectfill(a6)
	movem.l	(sp)+,d4-d5

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	move.b	d4,rp_areaptsz(a1)
	move.l	d5,rp_areaptrn(a1)

	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	jsr	_LVOrefreshwindowframe(a6)	;Fenster-Rahmen und Gadgets
						;in Ordnung bringen
	move.l	#-1,mytime(A5)
	bra	showtime
***************************************************************
* ANALYZER , berechnet Positionen,zeichnet ein und stellt dar *
* 1. Variante,(von unten nach oben wachsend)                  *
***************************************************************
Analyze1:
;=============== Kanle auswerten ============================================
	lea.l	my_bitmap(a5),a0
	move.l	bm_planes(a0),a4	;1.Bitplane
	moveq	#0,d0
	move.b	bm_depth(A0),d0
	move.w	d0,d1
	mulu	#an_zeilen*an_num,d1	;letzte Zeile
	add.l	d1,a4
Clear:
;=============== Schnelle Lschroutine ==============================
;
;
	subq.w	#2,d0
	blt.s	.fullz

	lea	Nulls(a5),a0
	movem.l	(a0),d1-d7/a1	;sehr schnelle Registerlschroutine (hahaha)
.nullz
	rept	an_zeilen*2	;fr 2.-8.Bitplane
	movem.l	d1-d7/a1,-(a4)	;1 Befehl lscht 1/2 Zeile a` 64 Bytes
	endr			
	dbf	d0,.nullz
.fullz
	lea	Fulls(a5),a0
	movem.l	(a0),d0-d7	;sehr schnelle Registerlschroutine (hahaha)

	rept	an_zeilen*2	;fr 1.Bitplane
	movem.l	d0-d7,-(a4)	;1 Befehl lscht 1/2 Zeile a` 64 Bytes
	endr			
	;*****************************************************************
	;*         neue Analyzing Routine, samplegesteuert               *
	;*****************************************************************

	;=============== Kanle auswerten =================================

	lea	AN_Struct(a5),a4;Analyzer Struktur
	moveq	#-1,d2				;Alle Kanle
	move.w	ups_flags(a4),d1
	and.w	#UPSB_Dmacon,d1			;Flag ob Kanle an/aus ?
	beq.s	.nodmacon
	move.w	UPS_Dmacon(a4),d2	;Ja,ranholen
.nodmacon

	lea	permerk(a5),a3	;SamplePeriod merken und Spielzeit der Samples
				;in 1/50 Sekunden

	;************************ 1. Stimme ********************************
Scope1:
	btst	#0,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,A1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a1
	clr.w	(A3)
	clr.w	2(A3)
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4

;Anzahl der Bytes,die in 1/50 Sekunde vom DMA gelesen werden
;Bytes = 74074/Sampleperiod [ (1/(2.79*10-7)*50)/Sampleperiod ]
;Abwandlung : statt 74074: 65535

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	lsr.l	#1,d0
	divu	(a3),d0		;durch Sampleperiod
	and.l	#$ffff,d0
	lsl.l	#1,d0
	cmp.l	d4,d0		;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a1
	subq.w	#1,2(a3)
	clr.w	(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.divu
	moveq	#0,d0
	clr.w	2(a3)
	bra.s	.cbm_ok
.divu
	divu	d4,d0
	swap	d0
	clr.w	2(a3)
	and.l	#$ffff,d0
.cbm_ok
	add.l	d0,a1
	sub.l	d0,d4
	addq.w	#1,2(a3)
.no
	addq.l	#4,a3

	;************************ 4. Stimme ********************************

	lea	AN_Struct+UPS_Modulo*3(a5),a4 ;Analyzer Struktur 4.Stimme
Scope4:
	btst	#3,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,A2
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a2
	clr.w	(A3)
	clr.w	2(A3)
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4

;Anzahl der Bytes,die in 1/50 Sekunde vom DMA gelesen werden
;Bytes = 74074/Sampleperiod [ (1/(2.79*10-7)*50)/Sampleperiod ]
;Abwandlung : statt 74074: 65535

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	lsr.l	#1,d0
	divu	(a3),d0		;durch Sampleperiod
	and.l	#$ffff,d0
	lsl.l	#1,d0
	cmp.l	d4,d0		;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a2
	subq.w	#1,2(a3)
	clr.w	(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.divu
	moveq	#0,d0
	clr.w	2(a3)
	bra.s	.cbm_ok
.divu
	divu	d4,d0
	swap	d0
	clr.w	2(a3)
	and.l	#$ffff,d0
.cbm_ok
	add.l	d0,a2
	sub.l	d0,d4
	addq.w	#1,2(a3)
.no
	bsr	copybitmap

	move.w	d0,d1

	move.l	flagsadr(A5),a4
	move.l	(a4),d6
	and.l	#EGPRB_MasterVolume,d6
	beq.s	.NoMaster

	lea	begin(pc),a0
	move.l	EUS_EPBase(a0),a0
	lea	EPG_Voice1vol(a0),a0

	mulu	(a0),d0
	lsr.w	#6,d0
	mulu	6(a0),d1
	lsr.w	#6,d1
.nomaster
	move.w	d0,anmerk(a5)		;1.Kanal
	move.w	d1,anmerk+6(a5)		;4.Kanal

	addq.l	#4,a3

	;************************ 2. Stimme ********************************

	lea	AN_Struct+UPS_Modulo(a5),a4 ;Analyzer Struktur 2.Stimme
scope2
	btst	#1,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,A1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a1
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4

;Anzahl der Bytes,die in 1/50 Sekunde vom DMA gelesen werden
;Bytes = 74074/Sampleperiod [ (1/(2.79*10-7)*50)/Sampleperiod ]
;Abwandlung : statt 74074: 65535

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	lsr.l	#1,d0
	divu	(a3),d0		;durch Sampleperiod
	and.l	#$ffff,d0
	lsl.l	#1,d0
	cmp.l	d4,d0		;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a1
	subq.w	#1,2(a3)
	clr.w	(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.divu
	moveq	#0,d0
	clr.w	2(a3)
	bra.s	.cbm_ok
.divu
	divu	d4,d0
	swap	d0
	clr.w	2(a3)
	and.l	#$ffff,d0
.cbm_ok
	add.l	d0,a1
	sub.l	d0,d4
	addq.w	#1,2(a3)
.no
	addq.l	#4,a3

	;************************ 3. Stimme ********************************
scope3
	lea	AN_Struct+UPS_Modulo*2(a5),a4 ;Analyzer Struktur 3.Stimme

	btst	#2,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,A2
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a2
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4

;Anzahl der Bytes,die in 1/50 Sekunde vom DMA gelesen werden
;Bytes = 74074/Sampleperiod [ (1/(2.79*10-7)*50)/Sampleperiod ]
;Abwandlung : statt 74074: 65535

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	lsr.l	#1,d0
	divu	(a3),d0		;durch Sampleperiod
	and.l	#$ffff,d0
	lsl.l	#1,d0
	cmp.l	d4,d0		;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a2
	subq.w	#1,2(a3)
	clr.w	(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.divu
	moveq	#0,d0
	clr.w	2(a3)
	bra.s	.cbm_ok
.divu
	divu	d4,d0
	swap	d0
	clr.w	2(a3)
	and.l	#$ffff,d0
.cbm_ok
	add.l	d0,a2
	sub.l	d0,d4
	addq.w	#1,2(a3)
.no
	bsr	copybitmap

	move.w	d0,d1

	move.l	flagsadr(A5),a4
	move.l	(a4),d6
	and.l	#EGPRB_MasterVolume,d6
	beq.s	.NoMaster

	lea	begin(pc),a0
	move.l	EUS_EPBase(a0),a0
	lea	EPG_Voice1vol(a0),a0

	mulu	(a0),d0
	lsr.w	#6,d0
	mulu	6(a0),d1
	lsr.w	#6,d1
.nomaster
	add.w	d1,d0
	lsr.w	#1,d0
	move.w	d0,anmerk+2(a5)		;2.Kanal
	move.w	d1,anmerk+4(a5)		;3.Kanal

	addq.w	#1,wait(A5)
	cmp.w	#3,wait(a5)
	beq.s	stelldar
	rts
;====== Berechnen des durchschnittlichen Lautstrkepegels des Samples ======
copybitmap
	moveq	#10*4-1,d7		;Schleifenzhler Balkenanzahl
	moveq	#0,d4
	moveq	#0,d6
	moveq	#0,d0
.mainloop
	move.b	(a1)+,d6
	ext.w	d6
	bgt.s	.ok
	neg.w	d6
.ok
	move.b	(a2)+,d4
	ext.w	d4
	bgt.s	.ok2
	neg.w	d4
.ok2
	add.w	d4,d6

	add.l	d6,d0

	dbf	d7,.mainloop

	lsr.l	#7,d0

	cmp.w	#63,d0
	bls.s	.rts
	moveq	#63,d0
.rts
	rts
stelldar
	clr.w	wait(a5)
;============ Darstellen der Analyzerwerte =================================
	lea.l	my_bitmap(a5),a0
	move.l	bm_planes(a0),D4	;1.Bitplane

	lea	anmerk(a5),a3		;Analyzer-Werte
	move.w	(a3),d3			;1.Kanal
	add.w	6(a3),d3		;4.Kanal

	cmp.w	peek1(a5),d3		;mit altem Spitzenpegel vergleichen
	blt.s	.nopeek1		;kein neuer
	move.w	d3,peek1(a5)		;neuen Spitzenpegel sichern
	move.w	#peek_time,peek1time(a5);Zeit,die der Pegel gehalten wird
.nopeek1
 	subq.w	#1,peek1time(A5)	;runterzhlen
	bne.s	.nok1			;<>0 -> weiter
	move.w	d3,peek1(a5)		;aktuellen Stand als neue Bestmarke
	move.w	#peek_time,peek1time(a5);Zeit,die der Pegel gehalten wird
.nok1

	lsr.w	#2,d3			;durch 4 (32 Schritte,aber 128
					;mgl. Werte)

	subq.w	#1,d3			;minus 1 (dbf-Schleife)
	bgt.s	.okokok			;muss grer null sein
	moveq	#0,d3			;gleich null
.okokok
	cmp.w	#31,d3			;grer 31 ?
	blo.s	.okok			;nein,weiter
	moveq	#31,d3			;also gleich 31
.okok
	move.l	d4,a0			;Zieladresse in der Bitmap

	move.w	#an_num*an_zeilen,d7
	moveq	#0,d5
	move.b	my_bitmap+bm_depth(a5),d5
	subq.w	#2,d5
	bge.s	.hi
	moveq	#0,d5
.hi
	move.w	#$7f7f,d6
.loop1
	move.l	mypen1(a5),d1
	lsr.w	#1,d1
	bcs.s	.nopl0
	move.w	#$8080,(a0)		;Muster Bitplane 0 lschen
	move.w	#$8080,an_num(a0)	;Muster in nchster Zeile lschen
.nopl0
	lea	(a0,d7.w),a1
	move.w	d5,d2
.pixloop1
	moveq	#0,d0
	lsr.w	#1,d1
	bcc.s	.nopl1
	move.w	d6,d0
.nopl1
	move.w	d0,(a1)
	move.w	d0,an_num(a1)
	add.w	d7,a1
	dbf	d2,.pixloop1

	addq.w	#2,a0			;ein Wort nach rechts
	dbf	d3,.loop1

	move.w	2(a3),d3		;2.Kanal
	add.w	4(a3),d3		;3.Kanal

	cmp.w	peek2(a5),d3
	blt.s	.nopeek2
	move.w	d3,peek2(a5)
	move.w	#peek_time,peek2time(a5)
.nopeek2
 	subq.w	#1,peek2time(A5)
	bne.s	.nok2
	move.w	d3,peek2(a5)
	move.w	#peek_time,peek2time(a5)
.nok2

	lsr.w	#2,d3			;durch 4 (32 Schritte,aber 128
					;mgl. Werte)
	subq.w	#1,d3
	bge.s	.okokok2
	moveq	#0,d3
.okokok2
	cmp.w	#31,d3
	blo.s	.okok2
	moveq	#31,d3
.okok2
	move.l	d4,a0
	add.l	#an_num*4,a0

.loop2
	move.l	mypen1(a5),d1
	lsr.w	#1,d1
	bcs.s	.nopl20
	move.w	#$8080,(a0)		;Muster Bitplane 0 lschen
	move.w	#$8080,an_num(a0)	;Muster in nchster Zeile lschen
.nopl20
	lea	(a0,d7.w),a1
	move.w	d5,d2
.pixloop21
	moveq	#0,d0
	lsr.w	#1,d1
	bcc.s	.nopl21
	move.w	d6,d0
.nopl21
	move.w	d0,(a1)
	move.w	d0,an_num(a1)
	add.w	d7,a1
	dbf	d2,.pixloop21

	addq.w	#2,a0			;ein Wort nach rechts
	dbf	d3,.loop2

	move.l	d4,a0			;Spitzenpegel printen
	move.w	peek1(a5),d0
	lsr.w	#1,d0
	and.w	#~1,d0
	lea	(a0,d0.w),a1

	move.w	d5,d2
	move.l	mypen1(a5),d1
	lsr.w	#1,d1
	bcs.s	.nopl30
	move.w	#$8080,(a1)		;Muster Bitplane 0 lschen
	move.w	#$8080,an_num(a1)	;Muster in nchster Zeile lschen
.nopl30
	lea	(a1,d7.w),a1
.pixloop31
	moveq	#0,d0
	lsr.w	#1,d1
	bcc.s	.nopl31
	move.w	d6,d0
.nopl31
	move.w	d0,(a1)
	move.w	d0,an_num(a1)
	add.w	d7,a1
	dbf	d2,.pixloop31
	add.l	#an_num*4,a0
	move.w	peek2(a5),d0
	lsr.w	#1,d0
	and.w	#~1,d0
	lea	(a0,d0.w),a1

	move.w	d5,d2
	move.l	mypen1(a5),d1
	lsr.w	#1,d1
	bcs.s	.nopl40
	move.w	#$8080,(a1)		;Muster Bitplane 0 lschen
	move.w	#$8080,an_num(a1)	;Muster in nchster Zeile lschen
.nopl40
	lea	(a1,d7.w),a1
.pixloop41
	moveq	#0,d0
	lsr.w	#1,d1
	bcc.s	.nopl41
	move.w	d6,d0
.nopl41
	move.w	d0,(a1)
	move.w	d0,an_num(a1)
	add.w	d7,a1
	dbf	d2,.pixloop41

; ========= In das Window (dessen Rastport) kopieren =====================
.nopeek
	move.l	grafsave(a5),a6		;Graphics Library
	move.l	winhandle(a5),a1	;Fensteradresse

	move.l	wd_rport(a1),a1		;Rastport (Ziel)
	move.w	offx(A5),d2
	add.w	#23,d2			;X2
	move.w	myhoehe1(a5),d3		;Y2
	add.w	#7+4,d3			;ein kleines Stck tiefer

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	#an_num*8,d4		;Breite
	move.w	#6,d5			;Hhe -> an_zeilen-2 !!
		
	move.b	#$c0,d6		;Miniterm = nur kopieren , keine Verknpfung

	jsr	_LVObltbitmaprastport(a6)
	rts
*******************************************************************
*                 Anzeige der Spielzeit                           *
*                                                                 *
*******************************************************************
ShowTime
	move.l	myepbase(pc),a0		;Eagleplayer Basisadresse
	move.l	EPG_CurrentTime(a0),d6
	cmp.l	mytime(a5),d6
	beq.w	.nowrite
	move.l	d6,mytime(A5)

	moveq	#0,d0			;Sekunden einer
	moveq	#0,d1			;Sekunden zehner
	moveq	#0,d2			;Minuten einer
	moveq	#0,d3			;Minuten zehner
	move.l	#$ffff,d7

	divu	#60,d6			;durch Minuten
	move.l	d6,d5
	swap	d5			;Sekunden.w
	and.l	d7,d6		;ausmaskieren (Rest=Sekunden lschen)
	bge.s	.noset0
	moveq	#0,d6			;irgendwas lief schief,Minuten 0 setzen
.noset0
	cmp.w	#60,d6			;schon mehr als 60 Minuten um ?
	blo.s	.nohours
	divu	#60,d6			;durch Stunden
	swap	d6			;brigbleibende Minuten
.nohours
	and.l	d7,d6		;d6.w Minuten
	and.l	d7,d5		;d5.w Sekunden

					;Dezimalumwandlung
	divu	#10,d6
	move.w	d6,d3			;Minuten zehner
	swap	d6
	move.w	d6,d2			;Minuten einer

	divu	#10,d5
	move.w	d5,d1			;Sekunden zehner
	swap	d5
	move.w	d5,d0			;Sekunden einer

.timezero
	moveq	#7,d4		;Lnge einer Ziffer (7Zeilen*1Byte=7Bytes)

	mulu	d4,d0		;Offsets fr die einzelnen Ziffern berechnen
	mulu	d4,d1
	mulu	d4,d2
	mulu	d4,d3

	lea	Time.raw(pc),a1	;Ziffernbasisadresse
	add.l	a1,d0		;+Offset
	add.l	a1,d1
	add.l	a1,d2

	tst.l	d3
	bne.s	.add
	lea	nulls(A5),a4
	bra.s	.no
.add
	add.l	a1,d3
	move.l	d3,a4
.no
	move.l	d0,a1		;in Register sichern
	move.l	d1,a2
	move.l	d2,a3
	lea	Point.raw(pc),a6

	lea.l	my_bitmap(a5),a0
	move.l	bm_planes(a0),d7
	
	moveq	#0,d5
	move.b	my_bitmap+bm_depth(a5),d5
	subq.w	#2,d5
	bge.s	.hi
	moveq	#0,d5
.hi
	moveq	#7,d0		;7 Zeilen
.copy
	move.l	d7,a0

	move.l	mypen1(a5),d1
	lsr.w	#1,d1
	bcs.s	.nopl40

	move.b	(a4),d4
	eor.b	#$ff,d4
	move.b	d4,(a0)+	;Minuten Zehner

	move.b	(a3),d4
	eor.b	#$ff,d4
	move.b	d4,(a0)+	;Minuten Einer

	move.b	(a6),d4
	eor.b	#$ff,d4
	move.b	d4,(a0)+	;Doppelpunkt

	move.b	(a2),d4
	eor.b	#$ff,d4
	move.b	d4,(a0)+	;Sekunden Zehner

	move.b	(a1),d4
	eor.b	#$ff,d4
	move.b	d4,(a0)+	;Sekunden Einer
	bra.s	.pl40
.nopl40
	move.b	#-1,(a0)+
	move.b	#-1,(a0)+
	move.b	#-1,(a0)+
	move.b	#-1,(a0)+
	move.b	#-1,(a0)+
.pl40
	lea	an_num*an_zeilen-5(a0),a0
	move.w	d5,d2
.pixloop41
	lsr.w	#1,d1
	bcc.s	.nopl41

	move.b	(a4),(A0)+
	move.b	(a3),(A0)+
	move.b	(a6),(A0)+
	move.b	(a2),(A0)+
	move.b	(a1),(A0)+
	bra.s	.pl41
.nopl41
	clr.b	(a0)+
	clr.b	(a0)+
	clr.b	(a0)+
	clr.b	(a0)+
	clr.b	(a0)+
.pl41
	add.w	#an_num*an_zeilen-5,a0
	dbf	d2,.pixloop41

	addq.w	#1,a4
	addq.w	#1,a3
	addq.w	#1,a6
	addq.w	#1,a2
	addq.w	#1,a1
	add.l	#an_num,d7
	dbf	d0,.copy

	move.l	grafsave(a5),a6		;Graphics Library
	move.l	winhandle(a5),a1	;Fensteradresse

	move.l	wd_rport(a1),a1		;Rastport (Ziel)
	move.w	offx(a5),d2
	add.w	#21,d2			;X2
	move.w	myhoehe1(a5),d3		;Y2
	add.w	#22,d3			;ein kleines Stck tiefer

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	#38,d4			;Breite
	move.w	#an_zeilen-1,d5		;Hhe
		
	move.b	#$c0,d6		;Miniterm = nur kopieren , keine Verknpfung

	jsr	_LVObltbitmaprastport(a6)
.nowrite
	rts
*******************************************************************
*    berprfen,ob Analyzerstruktur schon bergeben wurde und     *
* und ob der aktuelle Player Lautstrke und Sampleperiod bergibt *
*******************************************************************
AN_test
	move.l	winhandle(a5),d0	;Window berhaupt offen ?
	beq.w	.noanalyze
	move.l	d0,a0

	move.w	myhoehe1(a5),d0
	cmp.w	wd_height(a0),d0	;Window im ZIP-Modus ?
	beq.w	.noanalyze

	move.l	an_structadr(a5),d0	;Strukturadresse vorhanden ?
	beq.w	.Noanalyze
	move.l	d0,a0

	tst.w	UPS_enabled(a0)		;Zugriff erlaubt ?
	bne.w	.noanalyze

	move.w	UPS_Flags(a0),d0	;alle bentigten Werte bergeben ?
	and.w	#UPSB_Per!UPSB_len!UPSB_adr,d0
	cmp.w	#UPSB_Per!UPSB_len!UPSB_adr,d0
	bne.s	.noanalyze

	lea.l	an_struct(a5),a1

	move.w	UPS_Flags(a0),UPS_Flags(a1)
	move.w	UPS_Dmacon(a0),UPS_Dmacon(a1)
	move.w	UPS_Voice1per(a0),UPS_Voice1per(a1)
	move.w	UPS_Voice2per(a0),UPS_Voice2per(a1)
	move.w	UPS_Voice3per(a0),UPS_Voice3per(a1)
	move.w	UPS_Voice4per(a0),UPS_Voice4per(a1)
	move.w	UPS_Voice1len(a0),UPS_Voice1len(a1)
	move.w	UPS_Voice2len(a0),UPS_Voice2len(a1)
	move.w	UPS_Voice3len(a0),UPS_Voice3len(a1)
	move.w	UPS_Voice4len(a0),UPS_Voice4len(a1)
	move.l	UPS_Voice1Adr(a0),UPS_Voice1adr(a1)
	move.l	UPS_Voice2Adr(a0),UPS_Voice2adr(a1)
	move.l	UPS_Voice3Adr(a0),UPS_Voice3adr(a1)
	move.l	UPS_Voice4Adr(a0),UPS_Voice4adr(a1)
	move.w	UPS_Voice1Repeat(a0),UPS_Voice1repeat(a1)
	move.w	UPS_Voice2Repeat(a0),UPS_Voice2repeat(a1)
	move.w	UPS_Voice3Repeat(a0),UPS_Voice3repeat(a1)
	move.w	UPS_Voice4Repeat(a0),UPS_Voice4repeat(a1)
	bsr	Analyze1		;auswerten

	bsr	ShowTime
.noanalyze
	rts
***************************************************************************
*           Nachrichtenbearbeitung ,Hauptprogramm                         *
***************************************************************************
HandleActions
	bra.s	.ma

.ma2

	btst	d3,d0		;Signal: Analyzer ???
	beq.s	.ma		;nein
	bsr.w	An_test		;Analyzer nimmt Arbeit auf !

.ma

	move.l	4.w,a6
	move.l	port(a5),d0	;Fenster offen ?
	beq.s	.nowinport	;nein 
	move.l	d0,a0
	jsr	_LVOgetmsg(a6)	;Fenstermeldung abholen
	tst.l	d0		;Meldung bekommen ?
	bne	.msg		;ja,auswerten
.nowinport
	lea.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)	;Message vom Eagleplayer bekommen (oder eigene
	tst.l	d0		;abgeschickte zurck ?)
	bne	.AN_msg		;ja,auswerten
	
;--------- Signalmaske erstellen ,auf die gewartet wird ---------------

	moveq	#0,d0
	move.l	4.w,a6
	move.l	port(a5),d1	;Windowport
	beq.s	.no		;kein Fenster offen
	move.l	d1,a0
	move.b	mp_sigbit(a0),d1;Signalbit aus Messageport holen
	bset	d1,d0		;in Maske einfgen
.no
	lea.l	msgport(a5),a0	;2.Messageport
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
	move.l	mysignal(a5),d3	;Signal fr Analyzer
	tst.l	an_structadr(a5);wenn keine Struktur vorhanden,wird auch nicht
	beq.s	.nowaitsig	;gewartet
	bset	d3,d0		;Signalbit fr Abarbeitung des Analyzers selbst
				;(Auswertungsroutine namens "ANALYZE1")
.nowaitsig
	jsr	_LVOwait(a6)	;auf Signale warten
	bra	.ma2
;================ Message an Analyzerport bekommen ===========================
.AN_msg

	move.l	d0,a1
				;persnliche Daten bekanntgeben
				;(ja,ja der Datenschutz...)

	move.l	a5,UM_Userport(a1)		;Trick:erst Basisadresse
						;sichern,dann Offset addieren
	add.l	#msgport,UM_UserPort(a1)	;wohin soll der Eagleplayer
						;senden ?-> an unseren MSGPORT!

	lea	begin(pc),a2			;Usernummer,nicht ndern,wird
	ifne	debug
	move.w	um_usernr(a1),saveusernr(A5)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	mytask(a5),UM_TaskAdr(a1)	;unsere Taskadresse

	move.l	mysignal(a5),d1			;Signal,auf das wir sehnschtig
	move.l	d1,UM_Signal(a1)		;warten

	move.l	UM_Type(a1),d7			;Wem gehrt die Message ?
	move.l	UM_structadr(a1),d6 	<-	;Strukturadresse
	move.w	UM_class(a1),d3		<-	;Kommando

	cmp.w	#USclass_exit,d3
	bne.s	.noexi
	clr.l	UM_Signal(a1)
	clr.l	UM_Taskadr(a1)
.noexi
	cmp.w	#USclass_getconfig,d3		;wenn dieses Kommando,sofort
						;auswerten,bevor die Message
						;zurckgesendet wird
	bne	.noprev
	moveq	#0,d0
	move.l	winhandle(A5),d1		;Fenster
	beq.s	.prnowin			;kein Fenster,keine nderung
						;der Voreinstellungen
	or.w	#eusb_openwin,d0		;Flag: Fenster offen

	move.l	d1,a0				;Fenster
	move.w	myhoehe1(a5),d1			;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d1		;Reale Hhe mit brechneter fr
						;ZIP-Modus vergleichen
	bne.s	.getxy				;kein ZIP-Mode
	or.w	#eusb_zipwin,d0			;FLAG: ZIP-Modus
	bra.s	.prnowin			;Windowposition nicht auswerten
.getxy
	move.w	wd_leftedge(a0),eus_winx(a2)	;Fensterposition merken
	move.w	wd_topedge(a0),eus_winy(a2)
.prnowin
	move.w	d0,eus_flags(a2)		;Flags bergeben
.noprev
	cmp.w	#USclass_Show,d3
	beq.s	.win
	cmp.w	#USclass_Activate,d3
	bne.w	.nowin
.win

	move.l	Begin+EUS_EPBase(pc),a0
	move.l	EPG_SomePrefs(a0),d0
	btst	#EGPRF_Iconify,d0
	bne.w	.noShow

	push	all
	bsr	Openwin
	pop	all
	tst.l	Winhandle(A5)
	beq.s	.noshow
	move	d3,UM_Class(a1)
.noshow
.nowin
	cmp.w	#USclass_Hide,d3	;Fenster schlieen
	beq.s	.closewin
	cmp.w	#USclass_DeActivate,d3	;Fenster schlieen
	bne.s	.noclosewin
.closewin
	push	all
	bsr	Closewin		;Window zu machen
	pop	all
.noclosewin


	lea	msgport(a5),a0
	move.l	mn_replyport(a1),d0
	cmp.l	a0,d0		;eine von uns abgeschickte Message ?
	beq.s	.noreply	;ja,keinesfalls nochmal auf den Weg schicken
	jsr	_LVOreplymsg(a6)
.noreply
	cmp.l	#USM_Userprg,d7	;Message zurckbekommen ?
	bne.s	.nomy
	move.b	#0,messagesent(a5)	;merken,da Message-Struktur frei
	bra	.mess			;eventl. Message vom Esagle auswerten
.nomy
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	bne	.noeagle		;n
.mess
;	lea	begin(pc),a0
;	move.l	eus_epbase(a0),a0
;	move.b	EPG_Wordreserved7(a0),d0
;	beq	.endme

	move.l	d6,an_structadr(a5)	;Analyzerstrukturadresse merken
	tst.l	d6
	bne.s	.noclr
	bsr	.ClearPic		;Wenn Adresse 0 -> Fenster lschen
.noclr
	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq.w	.ma			;adresse bekommen

	cmp.w	#USclass_zipwin,d3
	bne.s	.nozip
.setzip

	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.w	.ma		;Window schon klein
.zip
	move.w	d0,d4

	move.l	intsave(a5),a6
	cmp.w	#37,lib_version(a6)
	blt	.ma
	jsr	_LVOzipwindow(a6)

	move.l	winhandle(a5),a2
.Zipwait:
	moveq	#1,d1
	lea	begin(pc),a6
	move.l	eus_epbase(A6),a6
	move.l	dtg_dosbase(a6),a6
	jsr	_LVODelay(a6)

	cmp.w	wd_height(a2),d4
	beq.s	.zipwait

	bra	.ma
.nozip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nounzip

.clearzip
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.s	.zip
	bra	.ma
.nounzip

	cmp.w	#USclass_exit,d3	;Meldung,das Programm zu beenden
	beq	.exit			;alles dicht machen und verschwinden

	cmp.w	#USclass_NewConfig,d3	;Neu angekommene Config setzen ?
	bne.w	.nonewcon		;n

	lea	begin(pc),a0		;Anfang des Programms (EUS_-Struktur)
	move.w	eus_flags(a0),d0	;Flags holen
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin			;ffnen
	bra.s	.weio
.nowino
	bsr	closewin		;schlieen
.weio
	lea	begin(pc),a0		;Anfang des Programms (EUS_-Struktur)
	move.l	winhandle(a5),d0	;Fensteradresse
	beq.s	.nothingtomove		;kein Window , keine Windowbewegung

	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;neue X-Position
	move.w	d0,d1			;sichern
	blt.s	.oldx			;kleiner 0 -> sofort aufhren

	add.w	wd_width(a1),d1		;neue Position + Windowbreite
	cmp.w	sc_width(a2),d1		;grer als Screenbreite ?
	bhi.s	.oldx			;dann alte X-Position (Delta = 0)

	sub.w	wd_leftedge(a1),d0	;neue - alte X-Position = Delta X
	bra.s	.gety
.oldx
	moveq	#0,d0			;Delta X = 0
.gety
	move.w	eus_winy(a0),d1		;neue Y-Position
	move.w	d1,d2			;sichern
	blt.s	.oldy		;kleiner 0 -> sofort aufhren

	add.w	win_hoehe(a5),d2	;neue Position + Windowhhe
	cmp.w	sc_height(a2),d2	;grer als Screenhhe ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;neue - alte Y-Position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1
.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove
	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	btst	#eusf_zipwin,d0		;Zipwindow ?
	bne	.setzip			;yes
	bra	.clearzip		;no
.nonewcon
	bra	.ma
.noeagle
	bra	.ma
;======================== Meldung an IDCMP-Port ==========================
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<-
	move.l	im_Iaddress(a1),d6 	<-
	jsr	_LVOreplymsg(a6)

	cmp.l	#refreshwindow,d7	;Fensterinhalt neu aufbauen ?
	bne.s	.testgads
	bsr	refresh			;Rahmen neu !
	bra	.ma
.testgads
	cmp.l	#menupick,d7		;Men aufgerufen ??
	bne.s	.nomenu
	move.w	d5,d0
	cmp.w	#menunull,d0		;kein Menpunkt ??
	beq	.ma

	and.w	#$7e0,d0
	cmp.w	#32,d0		;2. Item ? (Hide)
	beq	.closewinny	;Window schlieen und dies an Eagleplayer
				;signalisieren
	cmp.w	#64,d0		;3. Item (Quit)
	beq	.endme

	lea	aboutmessage(pc),a0
	bsr	Merror			;Infotext ausgeben (Requester)
	bra	.ma
.nomenu
	cmp.l	#CloseWindow,d7		;Fenster schlieen ?
	bne	.ma
.closewinny
	if	Test=0

	tst.b	messagesent(a5)		;Message zurck ?? (normalerweise ja)
	bne	.ma			;nein,weiter warten,bis Message zurck
					;ist und wieder genutzt werden kann

	bsr	closewin		;Fenster schlieen
	move.l	4.w,a6			;an Eagleplayer signalisieren
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)	;Eagleplayer finden
	tst.l	d0
	beq.s	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse

	lea.l	msgport(a5),a1
	move.l	a1,d3			;Messageport
	move.l	mytask(a5),d4		;Task
	move.l	mysignal(a5),d5		;Signal
	move.w	#USclass_DeActivate,d6	;Kommando
	bsr	sendmess		;senden
	bra	.ma

	else

	bra.w	.endme		;nur fr Testvarianten

	endc
.endme
	moveq	#0,d7		;Ende des Hauptprogrammes,darf nicht aufgerufen
	RTS			;werden
.exit	moveq	#-1,d7		;Exit-Message vom Eagleplayer erhalten,alles
	rts			;dichtmachen
	
;=== Ganze Bitmap lschen,hier ganz einfach: das Gadget liegt genau in dem ===
;=== Bereich,wo hineinkopiert wird,also Gadget refreshen->alles sauber     ===
.Clearpic
	tst.l	winhandle(a5)		;Fenster offen ?
	beq.s	.rts

	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq.s	.rts

	movem.l	d0-a6,-(sp)
	bsr	refresh
	movem.l	(sp)+,d0-a6			;lschen
.rts
	rts
;===========================================================================
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0-a6,-(sp)
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	lea	my_easygadget(pc),a0
	move.l	a0,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	movem.l	(sp)+,d0-a6	
	rts
;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************

int:	dc.b	`intuition.library`,0
graf:	dc.b	`graphics.library`,0
gad:	dc.b	`gadtools.library`,0

portname:	dc.b	`EAGLEPLAYERPORT`,0
MyWinName:	dc.b	`Levelmeter Color`,0
MyAnalyzername:	dc.b	`ELevelmeterColor.1`,0
MyUsername:	dc.b	`Levelmeter Color`,0
my_easygadget:	dc.b	`   OK   `,0
my_easytitle:	dc.b	`Levelmeter Color Message`,0
my_easygadget2:	dc.b	` Retry | Cancel `,0
Project0STitle:	dc.b	'Levelmeter (Eagleplayer),  DEFECT Softworks',0


Aboutmessage:	dc.b	`     EaglePlayer Levelmeter Color `
		ver	
		dc.b	$0a
		dc.b	` 1993 Henryk "BUGGS" Richter, Shareware`,$0a,10
		dc.b	`  Idea: Buggs of Defect`,10
		dc.b	`  Code: Buggs of Defect`,10
		dc.b	`  GFX : Sony (TC-K 870)`,10,10
		dc.b	`Looks best on a screen with 2 free pens`,10
		dc.b	`    (e.g. Workbench in 16 Colors)`,0
	
NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0

NoPenMessage	dc.b	`Cannot allocate free pen !`,10
		dc.b	`Please open a screen with more colors !`,0

mybuggsname	dc.b	`Buggs of DEFECT`,0

myinfo		dc.b	`This engine shows the current Volume level of the audio output `
		dc.b	`as a simulated LED-Line. The idea for the graphics comes from `
		dc.b	`my Sony TC-K 870es Tapedeck.`,0
	even
myfontatt:
	dc.l	myfontname
	dc.w	8
	dc.w	0
myfontname:	dc.b	`topaz.font`,0
	even

Mylabel1:	dc.b	`Project`,0
Mylabel2:	dc.b	`About`,0
MyLabel3:	dc.b	`Hide`,0
MyLabel4:	dc.b	`Quit`,0
Mylabel21:	dc.b	`A`,0
MyLabel31:	dc.b	`H`,0
MyLabel41:	dc.b	`Q`,0

GadPic:
	dc.l	0
	dc.w	20,0
	dc.w	520,20
	dc.w	Gadgimage!gadghnone
	dc.w	0
	dc.w	boolgadget
	dc.l	Mode1Image
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0
Mode1Image
	dc.w	0,0
	dc.w	528,20
Mode1Depth
	dc.w	2
	dc.l	GadPlane
	dc.b	$ff,00
	dc.l	0
patt1	dc.w	-1;%1010101010101010
	dc.w	-1;%0101010101010101

;------------ ImageDaten, die in die Bss-Sektion kopiert werden ---------------

	;528 mal 20 Pixel, fr weisse Flchen, Farbe: 212,212,240
Weiss.Raw:
	DC.L	0,$210,0,$1880000,$C4,0,$240000,$100,0,0,0,0,0,0,0,0,$77,0,$2A80000,$54,0,$2A0000,$2A,0,$1400000,0,0,0,0,0,0,0,0,$EDD8000,$3BA8,0,$1C940000,$E4A,0,$3AA0000,$39C0,0,0,0,0,0,0,0,0,$77,0,$A80000,$54,0,$8A0000,$2A,0,$400000,0,0,0,0,0,0,0,0,0,$90,0,$1880000,$E4,0,$240000,$40,0,0,0,0,0,0,0,0,$8000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$81FDFC00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$E1FD,$FC000000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$C000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$A1FDFC00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$C1FD,$FC000000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$A0000000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$7C007C0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$12A81EF0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$2AA8,$16D00000,0,0,0,0,0,0,$361966,$DC000000,0,0,0,0,0,0,0,$2AA81290,0,0,0,0,0,0,$45,$15568800,0,0,0,0,0,0,0,$2BA8,$16D00000,0,0,0,0,0,0,$451564,$88000000,0,0,0,0,0,0,0,$11181EF0,0,0,0,0,0,0,$36,$1956C800

	;256 mal 14 Pixel  Xpos: 272; Farbe: 255;0;38
Rot.Raw:
	DC.L	$40000000,$C000,0,$40000000,$1800,0,$4000000,$4800,$A0000000,$42000,$2,$50000000,$12000,0,$4A000000,$4D400,$A0000000,$E4000,$7,$70000000,$3B000,0,$E4000000,$E5400,$A0000000,$48000,$2,$10000000,$12800,0,$4A000000,$45400,$40000000,$E000,0,$10000000,$1000,0,$4000000,$4800,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$CCCCCC,$CCCCCCCC,$CCCCCCCC,$CCCCCCCC,$CCCCCCCC,$CCCCCCCC,$CCCCCC00

;---------------- Daten fr die Zeitanzeige -----------------------------------

Time.raw:
	dc.b	%01111000
	dc.b	%10000100
	dc.b	%10000100
	dc.b	%00000000
	dc.b	%10000100
	dc.b	%10000100
	dc.b	%01111000

	dc.b	%00000000
	dc.b	%00000100
	dc.b	%00000100
	dc.b	%00000000
	dc.b	%00000100
	dc.b	%00000100
	dc.b	%00000000

	dc.b	%01111000
	dc.b	%00000100
	dc.b	%00000100
	dc.b	%01111000
	dc.b	%10000000
	dc.b	%10000000
	dc.b	%01111000

	dc.b	%01111000
	dc.b	%00000100
	dc.b	%00000100
	dc.b	%01111000
	dc.b	%00000100
	dc.b	%00000100
	dc.b	%01111000

	dc.b	%00000000
	dc.b	%10000100
	dc.b	%10000100
	dc.b	%01111000
	dc.b	%00000100
	dc.b	%00000100
	dc.b	%00000000

	dc.b	%01111000
	dc.b	%10000000
	dc.b	%10000000
	dc.b	%01111000
	dc.b	%00000100
	dc.b	%00000100
	dc.b	%01111000

	dc.b	%01111000
	dc.b	%10000000
	dc.b	%10000000
	dc.b	%01111000
	dc.b	%10000100
	dc.b	%10000100
	dc.b	%01111000

	dc.b	%01111000
	dc.b	%00000100
	dc.b	%00000100
	dc.b	%00000000
	dc.b	%00000100
	dc.b	%00000100
	dc.b	%00000000

	dc.b	%01111000
	dc.b	%10000100
	dc.b	%10000100
	dc.b	%01111000
	dc.b	%10000100
	dc.b	%10000100
	dc.b	%01111000

	dc.b	%01111000
	dc.b	%10000100
	dc.b	%10000100
	dc.b	%01111000
	dc.b	%00000100
	dc.b	%00000100
	dc.b	%01111000
Point.raw:
	dc.b	%00000000
	dc.b	%00000000
	dc.b	%00011000
	dc.b	%00000000
	dc.b	%00011000
	dc.b	%00000000
	dc.b	%00000000

;*** Leertabellen (spter im BSS-Hunk) ,Diskettenplatzsparend untergebracht***
		section	1,BSS
datas:
mycmap		rs.l	1
mypen1		rs.l	1
mypen2		rs.l	1
mytime		rs.l	1
flagsadr	rs.l	1
gadsave		rs.l	1
intsave:	rs.l	1	;Intuition
grafsave:	rs.l	1	;Graphics
WinHandle:	rs.l	1	;Fenster
Port:		rs.l	1	;Fenster IDCMP-Port
MsgPort:	rs.b	mp_size	;extra Messageport
Mysignal	rs.l	1	;Signalnummer
Mysignal2	rs.l	1	;Signalnummer
Mytask		rs.l	1	;Taskadresse
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
fontatt:	rs.l	1	;Fontattr Strukturadresse
Win_hoehe:	rs.w	1

Menuadr:	rs.l	1
vi:		rs.l	1	;Visualinfo
mytags:		rs.l	20*2
myzoom:		rs.w	3	;left,top,width,height
myhoehe2:	rs.w	1
myhoehe1:	rs.w	1
winwidth:	rs.w	1	;Breite des Fensters

MY_Easystruct:	rs.l	1	;EASY-Request Struktur
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1

MY_Bitmap:	rs.b	8	;Bitmap Struktur
		rs.l	1
		rs.l	1
		rs.l	6
wait		rs.w	1
Anmerk:		rs.w	4		;4 Kanle = 4*Lautstrke
Peek1		rs.w	1
Peek2		rs.w	1
Peek1time	rs.w	1
Peek2time	rs.w	1
permerk		rs.l	4
Goto:		rs.w	4		;4*Lautstrke,wo hinzuwandern ist
offx		rs.w	1

Mymenus:	rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.w	1

Mymessage:	rs.b	UM_sizeof	;Intuimessagestruktur
AN_Structadr:	rs.l	1		;vom Eagleplayer erhaltene Struktur
AN_Struct:	rs.b	UPS_sizeof	;Lnge der eigenen Struktur
	ifne	debug
saveusernr	rs.w	1
	endc
Messagesent:	rs.b	1		;Flag,ob Message losgeschickt
		rs.b	1		;Frei
Fulls		rs.l	8
Nulls:		rs.b	528/8*20	;Reservieren: 1 Plane
DatasLen:	rs.w	0		;Lnge des BSS-Blocks

		ds.b	DatasLen
;====== Daten fr die Grafik,die als Gadget ins Window eingebunden wird ====
	section	3,bss_c
GadPlane:
	ds.b	528/8*20*8		;Reservieren: Gre mal 8 Planes
	end
