*****************************************************************************
**                                                                         **
** Engine: Eagleexotic to control the external ExoticRipper                **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


*-----------------------------------------------------------------------------*
*			Exotic-Ansteuerung fr den Eagleplayer		      *
*-----------------------------------------------------------------------------*
Executable	= 1
NoOwnTask	= 0

ExoticSize	= 47128
Exotic020Size	= 46812

		incdir	include:
		include	"exec/exec.i"
		include	"exec/exec_lib.i"
		include	"dos/dos_lib.i"
		include	"dos/dos.i"
		include	"dos/dostags.i"
	include	misc/eagleplayer.i
	include	misc/eagleplayerengine.i
	include	misc/eagleplayerripper.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i


		rsreset
ExaminePuffer	rs.b	fib_sizeof
RipperStruct	rs.b	ERPSS_SizeOf
My_Easystruct	rs.l	5
*TaskAdr	rs.l	1
Dosbase		rs.l	1
Intbase		rs.l	1
SignalWeg	rs.w	1		*0=Exotic bereit
BreakOn		rs.w	1
Found		rs.w	1
ExoticGuiDa	rs.w	1
ExoticConDa	rs.w	1
*ModuleStart	rs.l	1
*ModuleSize	rs.l	1
*ModulePrefix	rs.l	1
OutputAdr	rs.l	1
OutputSize	rs.w	1
LastInternal	rs.w	1
*ExoticGuiProcessErg rs.l 1
*ExoticSegment	rs.l	1

		*--- Nur fr das "ExoticGui" ----*
GuiTaskAdr	rs.l	1
Segment		rs.l	1
*Bits		rs.l	1			;SignalBits
ExoticError	rs.w	1

PufferEnd	rs.b	0

DisplayGen	= 50				*DisplayGenauigkeit
Outputpuffersize = 200
ExoticPathSize	= 200

EPNr_Ex_SelectExoticPath EQU	EPNr_FirstExternal
EPNr_Ex_SaveConfig	EQU	EPNr_FirstExternal+1
*Execbase	MACRO
*		if	executable
*		move.l	4.w,a6
*		else
*		move.l	4,a6
*		endc
*		ENDM

		Section	Start,Code
FirstSegment
	
Start:		ifeq	Executable


		bsr	FirstInit
		bne.s	.Error

		if	NoOwnTask
		jsr	ExoticGuiStart
		else
		*moveq	#50,d1
		*move.l	Dosbase(a5),a6
		*jsr	_LVODelay(a6)

		*lea	EXK_ReadFile,a0
		*jsr	SendeSignalToExotic

		*lea	EXK_RangeFast,a0
		*jsr	SendeSignalToExotic
	move.w	#1,Found(a5)

		lea	MyModule,a0
		move.l	#MyModuleSize,d0
		bsr	Ripp
	move.w	Found(a5),d0

		move.l	a1,a0
		bsr	RippExt
		*bsr	RippCont


		endc
		bsr	ExitEngine

.Error:	
		moveq	#0,d0
		rts

		endc



*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
EUS_Structure:	moveq	#-1,d0
		rts
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
EPBase		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	0				;EUS_TickFlags
		dc.l	USMB_Configuration!USMB_SaveConfig	;EUS_MsgFlags
		dc.l	0				;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	37				;EUS_Kickstart
		dc.l	11				;EUS_EPVersion
		dc.w	1				;EUS_Version
		dc.w	0				;EUS_Revision
		dc.l	MyUserName			;EUS_Username
		dc.w	0				;EUS_WinX
		dc.w	0				;EUS_WinY
		dc.w	EUSB_Activate			;EUS_Flags
EUS_Width	dc.w	0 DefWidth		;EUS_Special  -> InnerWidth
EUS_Height	dc.w	0 Defheight		;EUS_Special+2 -> InnerHeigth
		dc.l	0				;EUS_Special2
ZoomX		equ	EUS_Special2
ZoomY		equ	EUS_Special2+2
ZoomONOFF	equ	EUS_Special3
*Sysfontonoff	equ	EUS_Special+1

		dc.l	0				;EUS_Special3
		dc.b	30,09
		dc.w	1996				;EUS_Creatordate
		dc.b	0				;EUS_Prioritt
		dc.b	EUTY_Ripper			;EUS_Type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6

		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	"$VER: Eagleplayer-Eagleexotic V1.0 (30 Sep 1996)",0
		even
TagListe:
		dc.l	EUT_InitEngine,FirstInit
		dc.l	EUT_ExitEngine,ExitEngine
		dc.l	EUT_Ripp,Ripp
		*dc.l	EUT_RippSegment,RippSegment
		dc.l	EUT_RippCont,RippCont
		*dc.l	EUT_RippExt,RippExt
		dc.l	EUT_SaveConfig,SaveConfig
		dc.l	EUT_EPSubItems,EP_Menu
		dc.l	EUT_Command,Commando
		dc.l	EUT_LocaleTable,LocaleTable
		dc.l	EUT_Config,Config
		dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Eagleexotic
		dc.l	EUT_SpecialinfoArgs,SpecialTags
		dc.l	0

SpecialTags:	dc.l	OutputPuffer

*----------------------------------------------------------------------------*
FirstInit:	lea	Puffer,a5		;BSS lschen
	if	executable
		move.l	4,a6
		moveq	#EPR_NeedHigherKickstart,d0
		cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
		blo	Exit			;nein,raus
		move.l	EUS_Structure+EUS_EPBase(pc),d0
		beq.w	Exit			*Test Auf CliStart
	endc

		bsr	ClrPuffer
	if	executable
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	DTG_Dosbase(a4),DosBase(a5)
		move.l	DTG_IntuitionBase(a4),IntBase(a5)
	else
		lea	MyDosname,a1
		move.l	4,a6
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,Dosbase(a5)
		tst.l	d0
		beq.s	NoExoticStart

		lea	MyIntname,a1
		move.l	4,a6
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,Intbase(a5)
		tst.l	d0
		beq.s	NoExoticStart
	endc

	if	Executable
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.w	#LNrE_ExoticKeinKey,d0
		jsr	ENPP_GetLocaleString(a4)
		tst.l	d0
		beq.s	.KeinString
		move.l	a0,SpecialTags
	endc
.KeinString:	bsr	LoadConfig


.Ok		moveq	#0,d0
Exit:		rts


*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
ExitEngine:	lea	Puffer,a5

	ifeq	NoOwnTask
		tst.w	ExoticGuiDa(a5)
		beq.s	NoExoticStart
		move.w	#200,d4
.RetryIt:	lea	ExoticName,a1
		move.l	4,a6
		jsr	_LVOFindTask(a6)
		tst.l	d0
		beq.s	NoExoticStart

		move.l	d0,a1
		move.l	#$1000,d0
		move.l	4,a6
		jsr	_LVOSignal(a6)

		moveq	#1,d1
		move.l	Dosbase(a5),a6
		jsr	_LVODelay(a6)

		subq.w	#1,d4
		bne.s	.RetryIt

		move.l	LA_CantQuitEagleExotic(pc),a0
		bsr	TextRequest
	endc
.NoTask:	clr.w	ExoticGuiDa(a5)
NoExoticStart:	
		ifeq	Executable
		move.l	Dosbase(a5),d0
		beq.s	.NoDos
		move.l	d0,a1
		move.l	4,a6
		jsr	_LVOCloseLibrary(a6)
		clr.l	Dosbase(a5)
.NoDos:		move.l	IntBase(a5),d0
		beq.s	.NoInt
		move.l	d0,a1
		move.l	4,a6
		jsr	_LVOCloseLibrary(a6)
		clr.l	Intbase(a5)
		endc

.NoInt:		moveq	#-1,d0
		rts

*-----------------------------------------------------------------------------*
* Vom Eagleplayer wird ein Kommando geschickt.
* wahrscheinlich select ExoticPath
*-----------------------------------------------------------------------------*
* Input: d0=EPNr_Nummer
*	 Rest = Parameter
* Output:d0=Error oder NULL
Commando:	lea	Puffer,a5

		cmp.w	#EPNr_EngineItemCommand,d0
		bne.s	.Return
		

		cmp.w	#EPNr_EX_SaveConfig,d2
		bne.s	.NoSaveConfig
		bsr	SaveConfig
		bra.s	.Return

.NoSaveConfig:	cmp.w	#EPNr_Ex_SelectExoticPath,d2
		bne.s	.Return
		bsr	Config
		bra.s	.Ret

.Return:	moveq	#0,d0
.Ret:		rts


		*--------- Der Exoticpath soll eingestellt werden ------------*
Config:		*Input:	Arg1 = Filerequester Titlename
		*	Arg2 = Directory Path
		*	Arg3 = Filename
		*	Arg4 = Window
		*	Arg5 = Filerequestertype (1=Fileselekt 0=Dirselekt)
		*	Arg6 = OutPut-Text fr Eagleplayer-Statuswindow
		*	ArgN = 6
		*Output:Arg1 = Ergebnis (0=Cancel oder Systemfehler, sonst 1)
		*-------------------------------------------------------------*
.Nochmal:	move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	LA_SelectExoticPathTitle(pc),a0
		move.l	a0,EPG_Arg1(a4)
		lea	ExoticPath,a0
		move.l	a0,EPG_Arg2(a4)
		clr.l	EPG_Arg3(a4)
		clr.l	EPG_Arg4(a4)
		moveq	#0,d0
		move.l	d0,EPG_Arg5(a4)
		move.l	LA_SelectingExoticPath(pc),a0
		move.l	a0,EPG_Arg6(a4)
		moveq	#6,d0
		move.l	d0,EPG_ArgN(a4)
		jsr	ENPP_FileReq(a4)
		tst.l	d0
		bne.s	.ItsOk

		move.l	#ExoticPath,d1
		move.l	#-2,d2
		move.l	DosBase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d6
		beq.w	.ItsOk
		move.l	d6,d1
		lea	ExaminePuffer(a5),a0
		move.l	a0,d2
		jsr	_LVOExamine(a6)
		move.l	d0,-(a7)
		move.l	d6,d1
		jsr	_LVOUnlock(a6)
		move.l	(a7)+,d0
		tst.l	d0
		beq.s	.ItsOk

		cmp.l	#ExoticSize,fib_size+ExaminePuffer(a5)
		beq.s	.ItsOk
		cmp.l	#Exotic020Size,fib_size+ExaminePuffer(a5)
		beq.s	.ItsOk

		*-- Testrequest --*
		move.l	LA_ExoticError,a0
		jsr	TextRequest
		bra.w	.Nochmal
.ItsOk:		moveq	#0,d0
		rts



*------------------------------ File Laden -----------------------------------*
LoadConfig:	movem.l	d1-a6,-(a7)

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir

		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		move.l	#ConfigName,d1
		move.l	#1005,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Error

		move.l	d6,d1
		move.l	#ExoticPath,d2
		move.l	#ExoticPathSize-2,d3
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		*cmp.l	d0,d3
		*beq.s	.FreeHandle

		move.l	d6,d1
		beq.s	.Error
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)

.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Die Config wird gespeichert.
SaveConfig:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir

		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		lea	ConfigName(pc),a1
		move.l	a1,d1
		move.l	#1006,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Return

		*---- Path speichern ----*
		move.l	d6,d1
		move.l	#ExoticPath,d2
		move.l	#ExoticPathSize-2,d3
		move.l	Dosbase(a5),a6
		jsr	_LVOWrite(a6)


		*--- Datei Closen ---*
		move.l	d6,d1
		beq.s	.AllesOk
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: a0=StartMemAdr
*	 d0=MemSize
* Output:d0=Error oder NULL
*	 a0=ModuleStart
*	 d1=ModuleSize
*	 a1=RipperStruct		(only Read)
*-----------------------------------------------------------------------------*
Ripp:		lea	Puffer,a5

	ifeq	NoOwnTask
		move.l	d0,d1
		bsr	StarteExoticGui
		bne.w	RippReturn
		move.l	d1,d0
	endc

		bsr	ClearRipperStruct
		move.l	a0,RipperStruct+ERPSS_MemStart(a5)
		move.l	a0,RipperStruct+ERPSS_Position(a5)
		move.l	d0,RipperStruct+ERPSS_MemSize(a5)

		move.l	a0,a1
		add.l	d0,a1
		bsr	SetRange
		bne.w	RippReturn

		lea	EXK_Hunt,a0
RippCont2:	clr.l	RipperStruct+ERPSS_FilePtr(a5)
		clr.l	RipperStruct+ERPSS_FileSize(a5)
		clr.w	Found(a5)
		jsr	WaitSendeSignalToExotic
		bne.s	RippReturn

	*--- Crunchanzeige initialisieren ---*
		sub.l	a1,a1
		if	executable
		lea	Ripping,a0
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		jsr	ENPP_InitDisplay(a4)
		endc


		moveq	#100,d3
.WaitHuntSignal:moveq	#EPR_FunctionAborted,d0
		tst.w	Found(a5)
		bne.s	.Retry
		tst.w	SignalWeg(a5)
		beq.s	RippReturn
		moveq	#1,d1
		move.l	Dosbase(a5),a6
		jsr	_LVODelay(a6)
		dbf	d3,.WaitHuntSignal


		*---- Nun Crunchdisplay updaten ----*
.Retry:		bsr	RefreshDisplay
		bne.s	RippReturn

		tst.l	RipperStruct+ERPSS_FileSize(a5)
		bne.s	.ModFound

		moveq	#EPR_UnknownFormat,d0
		cmp.w	#1,Found(a5)
		bne.s	RippReturn

		moveq	#1,d1
		move.l	Dosbase(a5),a6
		jsr	_LVODelay(a6)
		bra.s	.Retry

		*--- Crunchanzeige beenden ---*
.ModFound:	lea	RipperStruct(a5),a1
		move.l	ERPSS_FilePtr(a1),a0
		move.l	ERPSS_FileSize(a1),d1


		move.l	GuiTaskAdr(a5),a2	;Der Exotic soll das
		move.l	TC_Userdata(a2),a2
		move.w	10(a2),d0
		lea	(a2,d0.w),a2


		*move.l	#1,ERPSS_FileNr(a1)
		*move.l	ModulePrefix(a5),ERPSS_Prefix(a1)
		*move.l	ModuleName(a5),ERPSS_FormatName(a1)
		**move.l	CommentName(a5),ERPSS_CommentName(a1)
		moveq	#0,d0
RippReturn:	if	executable
		movem.l	d0/d1/a0,-(a7)
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		jsr	ENPP_RemoveDisplay(a0)
		movem.l	(a7)+,d0/d1/a0
		endc
		lea	RipperStruct(a5),a1
		tst.l	d0
		rts


RippCont:	lea	Puffer,a5
		lea	EXK_Cont,a0
		bra.w	RippCont2

*-----------------------------------------------------------------------------*
* Input: a0=RipperStruct
* Output:d0=Error oder NULL
*	 a0=ModuleStart
*	 d1=ModuleSize
*	 a1=RipperStruct		(only Read)
*-----------------------------------------------------------------------------*
RippExt:	lea	Puffer,a5
		lea	EXK_Smpl,a3
		move.l	ERPSS_FormatId(a0),d0		*Formatnr
		lea	6(a3),a1
		bsr	Hexstring
		lea	EXK_Smpl,a0
		bra.w	RippCont2

*-----------------------------------------------------------------------------*
ClearRipperStruct:
		movem.l	a0/d0,-(a7)
		lea	RipperStruct(a5),a0
		moveq	#ERPSS_SizeOf-1,d0
.Clr:		clr.b	(a0)+
		dbf	d0,.Clr
		movem.l	(a7)+,a0/d0
		rts

*------------------------ Mach mal n' Anzeige --------------------------------*
RefreshDisplay:	move.l	GuiTaskAdr(a5),a2	;Der Exotic soll das
		move.l	TC_Userdata(a2),a2
		moveq	#0,d0
		move.l	$AE(a2),d1		;Current ?
		blt.s	.Return
		sub.l	$A6(a2),d1		;StartMem
		move.l	$AA(a2),d0		;EndMem
		sub.l	$A6(a2),d0		;StartMem


		swap	d0
		swap	d1
.NextBit:	btst	#15,d0
		bne.s	.LastOne
		rol.l	#1,d0
		rol.l	#1,d1
		bra.s	.NextBit

.LastOne:	and.l	#$ffff,d0
		and.l	#$ffff,d1
		*ext.l	d0
		*ext.l	d1
		mulu	#1000,d1
		divu	d0,d1



		if	executable
		move.l	d1,d0
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		jsr	ENPP_FillDisplay(a0)
		else
		moveq	#0,d0
		btst	#7,$bfe001
		bne.s	.NotPressed
		moveq	#1,d0
.NotPressed:	endc
		tst.l	d0
		beq.s	.Return

		moveq	#EPR_UnknownFormat,d0
		moveq	#0,d1
		sub.l	a0,a0
.Return:	tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: a0=Start
*	 a1=End
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
SetRange:	lea	Puffer,a5
		lea	EXK_Range,a3
		move.l	a1,d0
		lea	13(a3),a1
		bsr	Hexstring

		lea	4(a3),a1
		move.l	a0,d0
		bsr	Hexstring

		move.l	a3,a0
		jsr	WaitSendeSignalToExotic
		rts


*-----------------------------------------------------------------------------*
* Input: a0=Kommando
* Output:d0=Error oder NULL
WaitSendeSignalToExotic:
		tst.w	ExoticGuiDa(a5)
		beq.s	.Error

		bsr	WaitAufSignals
		bne.s	.Error

		jsr	SendeSignalToExotic
		tst.l	d0
		beq.s	.Error
		moveq	#0,d0
		rts

.Error:		moveq	#EPR_Functionaborted,d0
		rts

*-----------------------------------------------------------------------------*
* Wartet, bis das letzte Signal, das an den Exotic gesendet wurde, wieder an- *
* gekommen ist.								      *
*-----------------------------------------------------------------------------*
WaitAufSignals:	moveq	#100,d0
.RetryWait	tst.w	SignalWeg(a5)
		beq.s	.rts
		subq.l	#1,d0
		beq.s	.Error
		movem.l	d0/a0,-(a7)
		moveq	#1,d1
		move.l	Dosbase(a5),a6
		jsr	_LVODelay(a6)
		movem.l	(a7)+,d0/a0
		bra.w	.RetryWait
.Rts		moveq	#0,d0
		rts
.Error:		moveq	#EPR_Functionaborted,d0
		rts



*-----------------------------------------------------------------------------*
* kein Hidezero kein Null ranhngen
* Input: d0=Hexzahl
*	 a1=Ziel
* Output:--
Hexstring:	movem.l	d0/d1,-(a7)
		moveq	#7,d1
.NextZiffer:	rol.l	#4,d0
		move.b	d0,(a1)
		and.b	#$f,(a1)
		cmp.b	#9,(a1)
		ble.s	.NoHigher
		add.b	#$7,(a1)
.NoHigher:	add.b	#$30,(a1)+
		dbf	d1,.NextZiffer
		movem.l	(a7)+,d0/d1
		rts



*-----------------------------------------------------------------------------*
ClrPuffer:	move.l	a5,a0
		move.w	#PufferEnd-1,d0
.clr		clr.b	(a0)+
		dbf	d0,.clr
		rts


*-----------------------------------------------------------------------------*
StarteExoticGui:movem.l	d1-a6,-(a7)
		moveq	#0,d0
		tst.w	ExoticGuiDa(a5)
		bne.w	.Return2

		moveq	#EPR_NoMoreEntries,d7
		move.l	4,a6
		lea	ExoticName,a1
		jsr	_LVOFindTask(a6)
		tst.l	d0
		bne.w	.Return

		move.l	4,a6
		lea	ExoticCon,a1
		jsr	_LVOFindTask(a6)
		tst.l	d0
		bne.w	.Return


		clr.w	ExoticError(a5)

		lea	ProcessTags(pc),a1
		move.l	a1,d1
		move.l	Dosbase(a5),a6
		jsr	_LVOCreateNewProc(a6)

		tst.l	d0
		beq.s	.Return

		*moveq	#4,d1
		*move.l	Dosbase(a5),a6
		*jsr	_LVODelay(a6)

.WaitBisWait:	tst.w	ExoticError(a5)
		bne.s	.Return

		moveq	#1,d1
		move.l	Dosbase(a5),a6
		jsr	_LVODelay(a6)

		lea	ExoticCon(pc),a1
		move.l	4,a6
		jsr	_LVOFindTask(a6)
		tst.l	d0
		beq.s	.WaitBisWait
		move.l	d0,a0
		move.b	TC_STATE(a0),d0
		cmp.b	#TS_RUN,d0
		beq.s	.WaitBisWait

		moveq	#10,d1
		move.l	Dosbase(a5),a6
		jsr	_LVODelay(a6)

		moveq	#0,d7				*Kein Fehler
		move.w	#1,ExoticGuiDa(a5)		*Kennung Gui da
		bsr	WaitAufSignals			*Warten auf ExoticCon

.Return:	move.l	d7,d0
		beq.s	.Return2

		move.l	LA_CantLoadExoticRipper(pc),a0	;Exotic not found
		bsr	TextRequest

.Return2:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


ProcessTags:	dc.l	NP_Entry,ExoticGuiStart
		dc.l	NP_Name,ExoticName
		dc.l	0



*------------------------------- TextRequest ---------------------------------*
* Input: a0=String						      *
*-----------------------------------------------------------------------------*
TextRequest:	movem.l	d0-a6,-(a7)
		sub.l	a3,a3					*Arguments

		move.l	IntBase(a5),a6
		lea	My_Easystruct(a5),a1
		move.l	a0,es_textformat(a1)

		move.l	LA_Ok(pc),a0
		move.l	a0,ES_GadgetFormat(a1)
		lea	RequestTitle.MSG(pc),a0
		move.l	a0,es_Title(a1)
		sub.l	a0,a0
		*move.l	Winhandle(a5),a0		;*Window
		suba.l	a2,a2				;*IDCMP_ptr
		jsr	_LVOEasyRequestArgs(a6)		;!! durch Reqtools
							;ersetzen
		movem.l	(sp)+,d0-a6	
		rts

**-----------------------------------------------------------------------------*
*UnLoadExotic:	moveq	#20,d4
*.RetryFindTask:	lea	EP_ExoticRipper(pc),a1		*Name
*		move.l	4,a6
*		jsr	_LVOFindTask(a6)
*		beq.s	.UnLoadIt
*		moveq	#5,d1
*		move.l	Dosbase(a5),a6
*		jsr	_LVODelay(a6)
*		subq.l	#1,d4
*		bne.s	.RetryFindTask
*		bra.s	.Cantremove
*
*.UnLoadIt:	move.l	ExoticSegment(a5),d1
*		beq.s	.CantRemove
*		move.l	Dosbase(a5),a6
*		jsr	_LVOUnLoadSeg(a6)
*.CantRemove:	clr.l	ExoticSegment(a5)
*		rts
*

**-----------------------------------------------------------------------------*
** Input: a0=String1
**	 a1=MemStart
**	 d1=MemSize
** Output:d0=Error oder NULL
**	 a1=Start of String
**-----------------------------------------------------------------------------*
*FindText:	move.b	(a1)+,d0
*		cmp.b	(a0),d0
*		beq.s	.FirstFound
*		subq.l	#1,d1
*		bgt.s	FindText
*		moveq	#-1,d0
*		rts
*
*.FirstFound:	movem.l	d1/a0/a1,-(a7)
*		addq.l	#1,a0
*.TesteNextB:	move.b	(a1)+,d0
*		cmp.b	(a0)+,d0
*		bne.s	.DochNicht
*		tst.b	d0
*		beq.s	.AllFound
*		subq.l	#1,d1
*		bgt.s	.TesteNextB
*
*.DochNicht:	movem.l	(a7)+,d1/a0/a1
*		bra.s	FindText
*
*
*.AllFound:	movem.l	(a7)+,d1/a0/a1
*		subq.l	#1,a1
*		moveq	#0,d0
*		rts
*

*----------------------------------------------------------------------------*
StringCopy:	move.l	d0,-(a7)
		moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return:	move.l	(a7)+,d0
		rts



	*------- Activate ------*
EP_Menu:	dc.l	EPM_SelectExotic	;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$5B
		dc.l	0
		dc.l	.ActivateIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ActivateIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	0			*Active.MSG (filled by EP)
		dc.l	0
		dc.w	EPNr_MainWindow	*EPNr_Engine
		dc.w	LNr_Active

	*------- Select EP-Path ------*
EPM_SelectExotic:dc.l	EPM_BarLabel		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$52
		dc.l	0
		dc.l	.ConfigIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ConfigIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	SelectExoticPath	*locale by EP
		dc.l	0
		dc.w	EPNr_Ex_SelectExoticPath
		dc.w	LNrE_SelectExoticPath

	*------- Barlabel ------*
EPM_Barlabel:	dc.l	EPM_SaveConfig		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	6			;Hight-Size
		dc.w	$c0
		dc.l	0
		dc.l	.BarlabelImage
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.BarlabelImage:	dc.b	0,2			*FronPen/BackPen
		dc.w	2,0			*DrawMode/KludgeFill // LeftEdge
		dc.w	2			*TopEdge
		dc.l	0			*Font
		dc.l	1			*ITIText
		dc.l	0			*NextText
		dc.w	0			*EPNr
		dc.w	0			*LocaleNr

	*------- Save EP-Path ------*
EPM_SaveConfig	dc.l	0			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$52
		dc.l	0
		dc.l	.SConfigIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.SConfigIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0
		dc.l	0			*set by EP
		dc.l	0
		dc.w	EPNr_Ex_SaveConfig
		dc.w	LNr_PM_SaveConfig

*-----------------------------------------------------------------------------*
LocaleTable:		dc.w	LNrE_SelectExoticPath
			dc.l	SelectExoticPath
LA_SelectExoticPath:	dc.l	0

			dc.w	LNrE_SelectingExoticPath
			dc.l	SelectingExoticPath
LA_SelectingExoticPath:	dc.l	0

			dc.w	LNrE_SelectExoticPathTitle
			dc.l	SelectExoticPathTitle
LA_SelectExoticPathTitle:dc.l	0

			dc.w	LNrE_CantRunSecondExoticGui
			dc.l	CantRunaSecondExoticGui
LA_CantRunASecondGui:	dc.l	0

			dc.w	LNrE_CantQuitEagleexotic
			dc.l	CantQuitEagleExotic
LA_CantQuitEagleExotic:	dc.l	0

			dc.w	LNrE_CantQuitExoticripper
			dc.l	CantQuitExoticRipper
LA_CantQuitExoticRipper:dc.l	0

			dc.w	LNrE_CantLoadExoticripper
			dc.l	CantLoadExoticRipper
LA_CantLoadExoticRipper:dc.l	0

*			dc.w	LNrE_ExoticSpecialInfo
*			dc.l	0
*LA_ExoticSpecialInfo:	dc.l	0

			dc.w	LNr_Ok
			dc.l	0
LA_Ok			dc.l	0

			dc.w	LNrE_ExoticError
			dc.l	ExoticError.MSG
LA_ExoticError:		dc.l	0

			dc.w	0


*-----------------------------------------------------------------------------*
SystemTags:		dc.l	0
			ifeq	Executable
MyDosname:		dc.b	"dos.library",0
MyIntname:		dc.b	"intuition.library",0
			endc

RequestTitle.MSG	dc.b	"Eagleexotic",0
CantLoadExoticRipper:	dc.b	"Can't load Exoticripper !",0
CantRunaSecondExoticGui:dc.b	"Can't run a second Exotic.GUI !",0
CantQuitExoticRipper:	dc.b	"Can't quit Exoticripper !",0
CantQuitEagleExotic:	dc.b	"Can't quit Eagleexotic !",0
SelectingExoticPath:	dc.b	"Selecting Exoticpath!",0
SelectExoticPathTitle:	dc.b	"Select your Exoticpath!",0
SelectExoticPath:	dc.b	"Select Exoticpath",0
Ripping:		dc.b	"Ripping %s",0

ConfigName:		dc.b	"Eagleexotic.config",0
ExoticName:		dc.b	"Exotic GUI",0
ExoticCon:		dc.b	"Exotic CON",0
MyUserName		dc.b	"Eagleexotic",0
MyCreatorname:		dc.b	"Eagleeye of DEFECT",0

MySpecialinfo:	dc.b	"This engine searchs modules in files. It uses the "
		dc.b	"Exoticripper V2.0+ to do it. The path of the ripper "
		dc.b	"must be set correctly. "
		dc.b	"The Exoticripper is  by Marley & Turbo (IFT). "
		dc.b	"Please register, it is the best ripper I know. "
		dc.b	"Thanks.",10,10
OutPutPuffer:	dc.b	"Currently the Exoticripper isn't loaded. It can't be "
		dc.b	"get information about the user of it."
		ds.b	OutPutPufferSize-(*-OutputPuffer)
		dc.b	0

ExoticError.MSG:dc.b	"This isn't the correct exoticripper",10
		dc.b	"Please check the version of it. You",10
		dc.b	"need V2.31 (29-Dec-95) or newer."
		dc.b	"The filesize is:",10
		dc.b	"Exoticripper        47812 Bytes or",10
		dc.b	"Exoticripper.020    46012 Bytes",10,10
		dc.b	"You can find it at the Aminet:",10
		dc.b	"mus/misc/ExoticRip32.lha",0

ExoticPath:	if	Executable
		dc.b	"ExoticRipper.020"
		else
		*dc.b	"Work:Music/Ripper/Exotic/Exoticripper",0
		dc.b	"Work:Music/Ripper/Exotic/ExoticripperV3.2.020",0
		endc
		ds.b	ExoticPathsize-(*-ExoticPath)
		dc.b	0

		*dc.b	"Work:Music/Ripper/Exotic/ExoticRipperV3.2.020",0



		cnop	0,4

*-----------------------------------------------------------------------------*
*		Section	MyPuffer,bss
Puffer		ds.b	PufferEnd
		ifeq	Executable
		dc.l	0,0
		endc

*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
* Das ExoticGui wird hier simuliert.
*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
		Section	ExoticGui,Code
ExoticGuiStart:	lea	Puffer,a5
		move.w	#1,SignalWeg(a5)
		move.l	#OutPutPuffer,OutPutAdr(a5)
		move.l	#OutputPuffer,SpecialTags
		move.w	#OutputPufferSize-2,OutputSize(a5)
		clr.w	LasTinternal(a5)
		clr.w	ExoticError(a5)

		move.l	4,a6
		moveq	#$10,d0				*definiertes Signal zum
		jsr	_LVOAllocSignal(a6)		*Exotic
		addq.b	#1,d0
		beq.l	.Ende

		moveq	#$11,d0				*definiertes Signal zum
		jsr	_LVOAllocSignal(a6)		*Exotic
		addq.b	#1,d0
		beq.l	.FreeSignal1

		moveq	#$12,d0				*definiertes Signal zum
		jsr	_LVOAllocSignal(a6)		*Exotic
		addq.b	#1,d0
		beq.l	.FreeSignal2

		moveq	#$13,d0				*definiertes Signal zum
		jsr	_LVOAllocSignal(a6)		*Exotic
		addq.b	#1,d0
		beq.l	.FreeSignal3

		moveq	#$14,d0				*definiertes Signal zum
		jsr	_LVOAllocSignal(a6)		*Exotic
		addq.b	#1,d0
		beq.l	.FreeSignal4

		moveq	#$15,d0				*definiertes Signal zum
		jsr	_LVOAllocSignal(a6)		*Exotic
		addq.b	#1,d0
		beq.l	.FreeSignal5

		sub.l	a1,a1
		jsr	_LVOFindTask(a6)
		move.l	d0,GuiTaskAdr(a5)
		move.l	d0,a1
		move.l	LN_Name(a1),d0
		move.l	#ExoticName,LN_Name(a1)


		bsr	StarteExotic
		bne.w	.FreeSignal6

		*move.l	#20,d1
		*move.l	Dosbase(a5),a6
		*jsr	_LVODelay(a6)

		bsr	SendeSignal			*Ich bin da

		*move.l	#20,d1
		*move.l	Dosbase(a5),a6
		*jsr	_LVODelay(a6)

		*lea	EXK_ReadFile,a0
		*jsr	SendeSignalToExotic

		*lea	EXK_RangeFast,a0		
		*jsr	SendeSignalToExotic





	*-------------- Nun auf die Signal vom Exotic warten ----------*
.RealWait:	move.l	#$2f1000,d0			*Break + Exotic
		move.l	4,a6
		jsr	_LVOWait(a6)
		move.l	d0,d5
.Wait:		bclr	#12,d5				;Break-Signal
		bne.w	.SendeExit
		bclr	#$10,d5				;Exotic bereit !
		bne.s	.Bereit
		bclr	#$11,d5
		bne.w	.OutPutSignal
		bclr	#$12,d5
		bne.w	.ModFound
		bclr	#$13,d5
		bne.s	.HuntBereit
		bclr	#$14,d5
		bne.s	.Bereit2
		bclr	#$15,d5				;AntwortSignal auf
		bne.w	.KommandoAntwort		;Kommando
		bra.s	.RealWait

.Bereit:	clr.w	SignalWeg(a5)
		move.w	#1,LastInternal(a5)
		*or.l	d0,Bits(a5)
.Bereit2:	bra.s	.Wait


*		lea	MyModule,a0
*		move.l	#MyModuleSize,d0
*		move.l	a0,a1
*		add.l	d0,a1
*		jsr	SetRange
*		bra.w	.Wait
*
*
*		lea	EXK_RangeFast,a0		
*		jsr	SendeSignalToExotic
*		bra.w	.Wait
*
*		lea	EXK_Hunt,a0		
*		jsr	SendeSignalToExotic
*		move.l	GuiTaskAdr(a5),a2	;Der Exotic soll das
*		move.l	TC_Userdata(a2),a2
*		move.l	$A6(a2),a0
*		move.l	$AA(a2),a0
*		move.l	$AE(a2),a0
*		bra.w	.Wait
*
		*--- Hunt wird gestartet ---*
.HuntBereit:	*bsr	InitDisplay
		clr.l	RipperStruct+ERPSS_FilePtr(a5)
		clr.l	RipperStruct+ERPSS_FileSize(a5)
		*clr.l	ModulePrefix(a5)
		move.w	#1,Found(a5)
		bsr	SendeSignal
		clr.w	BreakOn(a5)
.HuntWait:	move.l	#$161000,d0			*Break + Exotic
		move.l	4,a6
		jsr	_LVOWait(a6)
		move.l	d0,d4
.HuntRetry:	bclr	#12,d4				;Break-Signal
		bne.w	.SendeExit
		bclr	#$12,d4			*Anzeigerefresh
		bne.s	.HuntRefresh
		bclr	#$11,d4
		bne.s	.HuntFound
		bclr	#$14,d4			*RTHandler-Break
		bne.s	.HuntBreak
		bra.s	.HuntWait

.HuntRefresh:	*bsr	UpdateDisplay		;wird vorne gemacht
		bra.s	.HuntRetry

.HuntFound:	*move.l	GuiTaskAdr(a5),a2	;Der Exotic soll das
*		move.l	TC_Userdata(a2),a2
*		move.l	$A6(a2),a0		;StartMem
*		move.l	$AA(a2),a0		;EndMem
*		move.l	$AE(a2),a0		;Current ?
*		move.l	$8A(a2),a0		;Current ?
*		move.l	$26(a2),a2
	*bsr	Farbe
	bsr	WaitMal
		bsr	SendeSignal
		bra.w	.Wait

.HuntBreak:	tst.w	BreakOn(a5)
		beq.s	.HuntRetry
		move.l	GuiTaskAdr(a5),a2	;Der Exotic soll das
		move.l	TC_Userdata(a2),a2
		clr.w	$b4(a2)			*StopWord		
		clr.w	BreakOn(a5)
		*bsr	RemoveDisplay
		bra.w	.Wait

	*--- Im original Exotic werden jetzt die Adressen fr ---*
	*--- die Searchrange neu angezeigt ---*
.KommandoAntwort:
		*move.l	GuiTaskAdr(a5),a2	;Der Exotic soll das
		*move.l	TC_Userdata(a2),a2
		*move.l	$A6(a2),a0		;StartMem
		*move.l	$AA(a2),a0		;EndMem
		*move.l	$AE(a2),a0		;Current ?
		*move.l	$8A(a2),a0		;Current ?
		bsr	SendeSignal		;Antwort bereit !
		bra.w	.Wait

.ModFound:	move.l	GuiTaskAdr(a5),a2	;Der Exotic soll das
		move.l	TC_Userdata(a2),a2
		move.l	$16(a2),RipperStruct+ERPSS_FilePtr(a5)
		move.l	$1e(a2),RipperStruct+ERPSS_FileSize(a5)
		move.l	$e(a2),RipperStruct+ERPSS_FormatName(a5)
		move.w	6(a2),RipperStruct+ERPSS_FormatId+2(a5)

	addq.l	#1,RipperStruct+ERPSS_FileNr(a5)

		cmp.l	#1,RipperStruct+ERPSS_FileNr(a5)
		bne.s	.NoNewPr
		move.w	10(a2),d0
		lea	(a2,d0.w),a0
		move.l	a0,RipperStruct+ERPSS_ModuleName(a5)
.NoNewPr:	move.w	#2,Found(a5)
.Da:		bra.w	.Wait


	*--- Im original ExoticGui wird jetzt ein Text ausgegeben ---*
.OutPutSignal:	move.l	GuiTaskAdr(a5),a2	;Der Exotic soll das
		move.l	TC_Userdata(a2),a2
		move.l	$26(a2),a0
		cmp.b	#$9b,(a0)
		beq.s	.OutputNone
		tst.w	LastInternal(a5)
		bne.s	.OutPutNone
		move.l	OutPutAdr(a5),a1
		move.w	OutputSize(a5),d1
		jsr	StringCopy
		move.l	a1,OutPutAdr(a5)
		clr.w	OutputSize(a5)
		tst.l	d1
		blt.s	.OutputNone
		move.w	d1,OutPutSize(a5)
.OutPutNone:	bsr	SendeSignal
		bra.w	.Wait


	*---------------- Und Tsch ------------*
.SendeExit:	tst.w	ExoticConda(a5)
		beq.s	.FreeSignal6
		move.l	#200,d4
.RetryWait:	lea	EXOTICCon,a1
		move.l	4,a6
		jsr	_LVOFindTask(a6)
		tst.l	d0
		beq.s	.FreeSignal6

		lea	EXK_Exit(pc),a0
		bsr	SendeSignalToExotic

		moveq	#1,d1
		move.l	Dosbase(a5),a6
		jsr	_LVODelay(a6)

		subq.l	#1,d4
		bne.s	.RetryWait

		move.l	LA_CantQuitExoticRipper,a0
		jsr	TextRequest



.FreeSignal6:	moveq	#$15,d0
		move.l	4,a6
		jsr	_LVOFreeSignal(a6)

.FreeSignal5:	moveq	#$14,d0
		move.l	4,a6
		jsr	_LVOFreeSignal(a6)

.FreeSignal4:	moveq	#$13,d0
		move.l	4,a6
		jsr	_LVOFreeSignal(a6)

.FreeSignal3:	moveq	#$12,d0
		move.l	4,a6
		jsr	_LVOFreeSignal(a6)

.FreeSignal2:	moveq	#$11,d0
		move.l	4,a6
		jsr	_LVOFreeSignal(a6)

.FreeSignal1:	moveq	#$10,d0
		move.l	4,a6
		jsr	_LVOFreeSignal(a6)



.Ende:		clr.w	ExoticConda(a5)
		clr.w	ExoticGuiDa(a5)			*da es beendet wird.
		move.l	Dosbase(a5),a6
		ifeq executable
		 moveq	#0,d0
		 rts
		else
		 move.l	Segment(a5),d1
		 jmp	_LVOUnLoadSeg(a6)
		endc

*Farbe:	move.l	d0,-(a7)
*	moveq	#-1,d0
*.Farbe:	move.w	d0,$dff180
*	dbf	d0,.Farbe
*	move.l	(a7)+,d0
*	rts
*


*-----------------------------------------------------------------------------*
* Sende das Signal zum Exotic und setze das Kommando in die Exotic-Globals    *
* Input: a0=Kommandostring
*-----------------------------------------------------------------------------*
SendeSignalToExotic:
		lea	EXOTICCon,a1
		move.l	4,a6
		move.l	a0,-(a7)
		jsr	_LVOFindTask(a6)
		move.l	(a7)+,a0
		tst.l	d0
		beq.s	.Error

		move.l	GuiTaskAdr(a5),a2	;Der Exotic soll das
		move.l	TC_Userdata(a2),d0
		beq.s	.Error
		move.l	d0,a2			;angegebene Signal
		move.l	$2A(a2),a1		;ausfuehren
		move.w	(a0)+,d0
		move.w	d0,$24(a2)		*Kommandoanz kopieren 
		addq.w	#6,d0
		move.w	$22(a2),d1
		lea	(a2,d1.w),a2
.CopyKommando:	move.b	(a0)+,(a2)+
		dbra	d0,.CopyKommando
		move.l	#$10000,d0
		move.l	4,a6
	move.w	#1,SignalWeg(a5)
		jsr	_LVOSignal(a6)
		moveq	#1,d0
.Error:		rts


WaitMal:	moveq	#5,d1			*sicherheitshalber ein bischen
		move.l	Dosbase(a5),a6		*warten, gibt sonst Probleme
		jsr	_LVODelay(a6)
		rts

*-----------------------------------------------------------------------------*
SendeSignal:	lea	EXOTICCon,a1
		move.l	4,a6
		jsr	_LVOFindTask(a6)
		tst.l	d0
		beq.s	.Error

		move.l	GuiTaskAdr(a5),a2	;Der Exotic soll das
		move.l	TC_Userdata(a2),d0
		beq.s	.Error
		move.l	d0,a2			;angegebene Signal
		move.l	$2A(a2),a1		;ausfuehren
		move.l	#$10000,d0
		move.l	4,a6
		jsr	_LVOSignal(a6)
.Error:		rts

*-----------------------------------------------------------------------------*
* exotic wird gestartet und es wird getestet, ob der Exotic die richtige Mel- *
* dung zurckgibt							      *
* Input: --								      *
* Output:d0=Error oder NULL						      *
*-----------------------------------------------------------------------------*
StarteExotic:	lea	ExoticCon,a1
		move.l	4,a6
		jsr	_LVOFindTask(a6)
		tst.l	d0
		bne.w	.Error

		move.l	#ExoticPath,d1
		move.l	#-2,d2
		move.l	DosBase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d6
		beq.w	.Error
		move.l	d6,d1
		lea	ExaminePuffer(a5),a0
		move.l	a0,d2
		jsr	_LVOExamine(a6)
		move.l	d0,-(a7)
		move.l	d6,d1
		jsr	_LVOUnlock(a6)
		move.l	(a7)+,d0
		tst.l	d0
		beq.s	.Error

		cmp.l	#ExoticSize,fib_size+ExaminePuffer(a5)
		beq.s	.ItsOk
		cmp.l	#Exotic020Size,fib_size+ExaminePuffer(a5)
		beq.s	.ItsOk

		*-- Testrequest --*
		move.l	LA_ExoticError,a0
		jsr	TextRequest
		bra.s	.Error2
.ItsOk:

		movea.l	Dosbase(a5),a6
		*move.l	ProgrammDirDupLock,d1
		*jsr	_LVOCurrentDir(a6)
		*move.l	d0,d5
		move.l	#ExoticPath,d1
		move.l	#SystemTags,d2
		jsr	_LVOSystemTagList(a6)
		*move.l	d0,-(sp)
		*move.l	d5,d1
		*jsr	_LVOCurrentDir(a6)
		*tst.l	(sp)+
		tst.l	d0
		bne.s	.Error

		move.l	GuiTaskAdr(a5),a4
		move.l	Dosbase(a5),a6
		move.w	#200,d4
.WaitExotic:	moveq	#1,d1
		jsr	_LVODelay(a6)
		move.l	$58(a4),d0
		dbne	d4,.WaitExotic
		beq.l	.Error
		move.l	d0,a0
		cmp.l	#"2.29",(a0)
		bne.l	.Error


	*	moveq	#5,d1
	*	move.l	Dosbase(a5),a6
	*	jsr	_LVODelay(a6)

		*move.l	GuiTaskAdr(a5),a1
		*move.l	$58(a1),a1
		*move.l	$2a(a1),a1
		*move.l	#-1,$58(a1)

		move.w	#1,ExoticConDa(a5)
		moveq	#0,d0
		rts

.Error:		move.l	LA_CantLoadExoticRipper,a0
		jsr	TextRequest
.Error2:	moveq	#-1,d0
		move.w	d0,ExoticError(a5)
		rts

*-----------------------------------------------------------------------------*
EXKM		MACRO
		dc.w	\1+1
		dc.b	\2,10
		even
		ENDM

	*------------ Exotic-Kommandos ------------*
EXK_Smpl:	EXKM	6,"smp 00000000"
EXK_Cont:	EXKM	1,"c"
EXK_Exit:	EXKM	1,"x"
EXK_ReadFile:	EXKM	1,"r"
EXK_Hunt:	EXKM	3,"h 0"
EXK_Range:	EXKM	19,"a 00000000 00000000"
EXK_RangeChip:	EXKM	3,"a c"
EXK_RangeFast:	EXKM	3,"a f"
		dc.b	0
		even
		

		ifeq	executable
		Section	TestModule,data
myModule	blk.b	1000,255
		incdir	Modules:
		*incbin	"mod.agnostica"
		*incbin	"ripptestmem"
		*incbin	"ripptestsidmon.agnostica.mem"
		*incbin	"music.amaze"
		incbin	"tfmxRipptest.mem"
MyModuleSize	= *-MyModule
