*****************************************************************************
**                                                                         **
** Engine: EagleAMPGui                                                     **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

*********************************************************************************************
*                           EagleAMPGui                                                     *
*                                                                                           *
*     Interface Layout System, basierend auf nachladbaren Custom-Images des WinAMP          *
*                                                                                           *
* Basis: EMPYGui24                                                                          *
*                                                                                           *
* Notes: Impmementierung von Hanning-Fenster                                                *
*        FPU FFT, basierend auf Langwort-FFT Algo                                           *
*                                                                                           *
*********************************************************************************************
;Todo:
;      -Slider fr Position mit Integration in EP
;
;Done:
;      -Implementation von selektierbaren Verzeichnissen fr Images
;      -Einladen aller Bilder vor Berechnung der Grafiken, wenn Grafik nicht gefunden,
;       Default aus "base" laden, bevor Fehlermeldung
;      -Ausschneiden der notwendigen GFX aus Quellgrafiken
;      -Slider fr Volume/Balance/Position/Gfx, mglichst basierend auf einer einzigen Klasse (hor/vert),
;       Grafiken fr Hintergrund wenn mgl. aus verketteter Liste schpfen und prozentual whlen,
;       Reaktion lediglich auf momentane Position der Maus
;      -Textparser fr Farbgebung von Analyzer und Monoscope
;      -Levelmeter mit whlbarer Farbpalette fr Minimized Modus
;      -Monoscope
;      -Error Requester
;
Eagleplayer	=	1	;1 setzen fr Betrieb als Engine (auch wenn 0, werden
				;Eagleplayer Includes verlangt)
Inttest		=	0	;1 setzen, wenn Interrupttester laufen soll

FXTask		=	0	;1 setzen, wenn fr FX eigener Task verwendet werden soll
Semaphore	=	1	;1 =  Semaphore fr Zugriff auf "Showimage"-Funktion anlegen

ggfxdefaults	=	1	;1 setzen, wenn fr Dithermodus, Autodither, Autodither-Schwelle
				;und Histogrammtyp Guigfx-Defaults verwendet werden sollen
PrefsVersion	EQU	1	;min. Version des Prefsfiles

USEFPU		EQU	0	;FPU benutzen (1) oder nicht (0)
		;
ver		macro
		dc.b	"0.58"
		endm
structver	macro
		dc.w	0,58
		endm
date		macro
		dc.b	"10-Aug-98"
		endm
structdate	macro
		dc.b	10,8
		dc.w	1998
		endm
		;

;--------------- Typdefinitionen -----------
	rsreset
GLA_Dummy	rs.b	1	;als Trger von umzurechnenden Images verwendbar, z.B. Fonts usw.
GLA_Image	rs.b	1	;z.B. Fonts, Background Image, Bilder, die bei Initialisierung ins Fenster zu zeichnen sind
GLA_Button	rs.b	1	;Gadgets allgemein
GLA_WinDrag	rs.b	1	;Gadget zum Bewegen des Fensters, wird auch ber BOOPSI erzeugt
GLA_WinDepth	rs.b	1	;Gadget zum nach vorn/hinten Klicken des Fensters, wird auch ber BOOPSI erzeugt
GLA_WinClose	rs.b	1	;Gadget zum Fensterschlieen, wird auch ber BOOPSI erzeugt, kann 
				;durch normalen Button mit "EPNr_Quit" genauso gehandhabt werden
GLA_TextField	rs.b	1	;Textfield Objekt mit angehngtem TempImage und 
				;FontObjekt in MOL_UserData
GLA_Moused	rs.b	1	;Regler (Volume/Balance/Speed) mit angehngter REG_ Struktur
				;in MOL_UserData

;-------------- Fenster-Liste -----------------
;Vorsicht: es wird (noch) auf die Struktur direkt ohne Rcksicht auf diese
;          Definitionen zugegriffen bei "Openwin:"
	rsreset
WNL_Window	rs.l	1	;Pointer auf Fensterstruktur oder 0 fr Ende der Liste
WNL_Prefsflag	rs.l	1	;welches gesetzte Flag fr welche Fensterstruktur verwendet wird

;-------------- Fenster-Struktur -----------------
	rsreset
WIL_LeftEdge	rs.w	1	;Linker Rand, wird beim Schlieen neu gesetzt (n/a yet)
WIL_TopEdge	rs.w	1	;Oberer Rand, wird beim Schlieen neu gesetzt
WIL_Width	rs.w	1	;Breite
WIL_Height	rs.w	1	;Hhe
WIL_Flags	rs.l	1	;Window-Flags
WIL_IDCMP	rs.l	1	;Window-IDCMPFlags
WIL_Objects	rs.l	1	;Gadgets, Images usw.

;-------------- ObjektStruktur -----------------
	rsreset
MOL_Next	rs.l	1	;nchstes Objekt in der Liste
MOL_Type	rs.w	1	;Typ: GLA_Button, GLA_Image usw.
MOL_ID		rs.w	1	;ID Nummer, anhand dieser kann das Objekt wiedergefunden werden
MOL_Initialized	rs.l	1	;Gadget Struktur im Fenster (n/a yet)
MOL_Left	rs.w	1	;Leftedge bei Gadgets und Backdrop Images, sonst ignoriert
MOL_Top		rs.w	1	;Topedge
MOL_Width	rs.w	1	;Breite an sich nur bei Gadgets und Dummy-Objekten benutzt
MOL_Height	rs.w	1	;Hhe
MOL_Images	rs.l	1	;einfach verkettete Liste von Images (bei Buttons = 2)
MOL_Flags	rs.l	1	;Flags
				;GACT_TOGGLESELECT	;funktioniert (noch?) nicht
				;GACT_IMMEDIATE
				;GACT_RELVERIFY
				;GACT_FOLLOWMOUSE
				;GFLG_Disabled<<16
				;MFLG_Repeat==GFLG_LABELIMAGE<<16, bei GACT_IMMEDIATE nach kurzer Wartezeit Kommando wiederholen

MOL_React	rs.l	1	;Gadgets: Routine zur Abarbeitung des Events bei Anwahl
MOL_Command	rs.l	1	;bei simplen buttons: EPNr des Kommandos
MOL_CMDArg1	rs.l	1	;1. Argument zur EPNr (Sonderbedeutung bei GLA_Image)
MOL_CMDArg2	rs.l	1	;2. Argument zur EPNr (Sonderbedeutung bei GLA_Image)
MOL_UserData	rs.l	1	;undefiniert, i.d.R. frei verwendbar, wird aber nicht auf GG_Userdata bertragen !
				;verwendet z.B. fr Fontadresse bei Textdisplay-Objekten, Fontbreite bei Fonts,
				;REG_ Struktur fr Regler
;-------------- ImageStruktur -----------------
	rsreset
IML_Next	rs.l	1	;nchstes Objekt in der Liste
IML_Rendered	rs.l	1	;Bitmap Struktur mit umgerechnetem Image (somit flexibel bis zum Abwinken, z.B. Chunky oder 24 Bit Bitmaps durchaus mglich)
IML_Width	rs.w	1	;Breite
IML_Height	rs.w	1	;Hhe
IML_Type	rs.w	1	;Typ: momentan 	4 = 32 Bit 0RGB Chunky
				;               0 = 8 Bit Chunky
				;		5 = 32 Bit 0RGB Chunky, nicht in Bitmap umrechnen
				;		6 = Ausschnitt aus Datatype Bild, dafr ID des Bilds,
				;		    sowie Quellkoordinaten verlangt
				;               7 = Dummy Image, nur Farbpalette, fr guigfx Berechnungen
				;
				;restliche Typen: (nicht mehr untersttzt)
				;	       1 = 4 Bit Chunky
				;              2 = 8 Bit Chunky, remapped in eine 8 Bit Chunky Bitmap, durch 16 teilbar !!!
				;              3 = 4 Bit Chunky, remapped in eine 8 Bit Chunky Bitmap, durch 16 teilbar !!!

IML_ColourMap	rs.l	1	;Farbtabelle (oder 0 fr default)
				;Aufbau: 1.Wort:   Anzahl der Farben
				;        2.-n. LW: 0RGB
				;
				;fr Typ5 (32 Bit 0RGB) wird hier das DirectDrawHandle eingetragen

IML_Data	rs.l	1	;Pointer auf Imagerohdaten

IML_SourceX		rs.w	1	;Position im Quellbild
IML_SourceY		rs.w	1	;Position im Quellbild
IML_SourceWidth		rs.w	1	;Breite im Quellbild
IML_SourceHeight	rs.w	1	;Hhe im Quellbild
IML_SourcePic		rs.w	1	;ID des Quellbildes, damit IML_ColourMap, IML_Data obsolet
IML_Flags		rs.w	1	;Flags, momentan lediglich "IMF_Inactive" definiert

IML_Sizeof	rs.b	0

;------ Struktur fr Bilder, aus denen dann die Grafiken ausgeschnitten werden ---------
		rsreset
GPIC_Next	rs.l	1	;Pointer zum nchsten Bild oder Null
GPIC_ID		rs.w	1	;ID des Bildes
GPIC_MinSizeX	rs.w	1	;min. Breite des Bildes (grere Werte werden ignoriert)
				;bzw. max. Dateilnge bei "LoadFile"
GPIC_MinSizeY	rs.w	1	;min. Hhe des Bildes (grere Werte werden ignoriert)
GPIC_Name	rs.l	1	;Dateiname
GPIC_Picture	rs.l	1	;ber guigfx geladenes Bild bzw. Mem Adresse, wohin zu laden bei "Loadfile"
GPIC_Sizeof	rs.b	0

;----- Struktur fr Popupmens -----
		rsreset
PUD_ID		rs.l	1	;ID
PUD_Text	rs.l	1	;Name
PUD_PFlag	rs.l	1	;wenn !NULL angegeben, Item in Checkselect umwandeln und anhand Prefsflag agieren
PUD_Callup	rs.l	1	;FPTR -> bei Anwahl Funktionsaufruf
PUD_Allocated	rs.l	1	;ber Popupmen allozierter Item, fr Free
PUD_Size	rs.b	0

;------------- Struktur fr Regler ------------

	rsreset
REG_Type	rs.w	1	;Typ (siehe unten)
REG_Enable	rs.w	1	;wenn <>0, dann Zugriff erlaubt (Test, ob Klick innerhalb des Radius erfolgte)
REG_XCenter	rs.w	1	;X-Position der Mitte des Reglers (bzw. beim Anklicken fr Horizontalregler)
REG_YCenter	rs.w	1	;Y-Position der Mitte des Reglers (bzw. beim Anklicken fr Vertikalregler)
REG_MinRadius	rs.w	1	;Minimaler Radius, in dem ein Klick akzeptiert wird bzw. min. Offset im Regler des Knopfes fr hori/verti Regler
REG_MaxRadius	rs.w	1	;Maximaler Radius, in dem ein Klick akzeptiert wird min. Offset im Regler des Knopfes fr hori/verti Regler
REG_KnobRadius	rs.w	1	;Radius fr den Knopf (nur kreisfrmige Regler)
REG_PhiMin	rs.w	1	;Bezugswinkel fr Bezugswert 0 (max. 360, Angabe in Grad) (nur kreisfrmige Regler)
REG_PhiTotal	rs.w	1	;maximaler ffnungswinkel (max. 360, Angabe in Grad) (nur kreisfrmige Regler)
REG_Minvalue	rs.w	1	;minimaler Ausgabewert
REG_Maxvalue	rs.w	1	;maximaler Ausgabewert

REG_PhiStore	rs.l	1	;Winkel, der besteht beim Anklicken (FFP) (nur kreisfrmige Regler)

REG_Value	rs.w	1	;aktueller Wert des Reglers

REGTYPE_Circle	EQU	0	;Lautstrkeregler im EMPY
REGTYPE_Hori	EQU	1	;Horizontal
REGTYPE_Verti	EQU	2	;Vertikal

;--------------------------------------------------------------------------------------
MFLG_Repeat	EQU	$2000<<16

;--------------------------------------------------------------------------------------

FFT_Gamma	=	7		;N = 2^Gamma
FFT_N		=	2^FFT_Gamma	;Anzahl zu transformierender Punkte
FFT_Sinbase 	=	8		;auf 256 bezogen (statt -1...1) wegen Integer-rechnung
DownSpeed	=	2
TimeOut		=	60
FFT_ShowLess	=	75	;Begrenzen der Berechnung des Power-Spektrums auf diese Lnge (0 fr default-Wert)
FFT_Analyzertabsize	=	16384

FFT_FallOffSpeed = 2

FFT_Width	=	76
FFT_Height	=	15
FFT_Displayentries	=	75
AnalyzerBackColour = $000D100C


MixingFrequency	=	16384*149
;16384*81		;44.1 kHz-> max. 22.05 kHz, angezeigt 13 kHz
;16384*162	;22.05 kHz -> max. 11 kHz, angezeigt 6.5 kHz
;16384*112	;32 kHz = 16 kHz max., angezeigt 9.3 kHz
;16384*149	;24 kHz = 12 kHz max., angezeigt 7 kHz
;16384*224	;15980 Hz =  8 kHz max.
;------------------------- Macrodefinitionen ------------------------------------------
EB	macro
	move.l	Exec_base(a5),a6
	endm
IB	macro
	move.l	Int_base(a5),a6
	endm
DB	macro
	move.l	Dos_base(a5),a6
	endm
UB	macro
	move.l	Util_base(a5),a6
	endm
GB	macro
	move.l	Gfx_base(a5),a6
	endm
CallSys	macro
	jsr	_LVO\1(a6)
	endm

MO_Object	macro
		dc.l	\1
		dc.w	\2,\3
		dc.l	\4
		dc.w	\5,\6,\7,\8
		dc.l	\9,\10,\11,\12,\13,\14,\15
		endm

IM_Object	macro
		dc.l	\1,\2
		dc.w	\3,\4,\5
		dc.l	\6,\7
		dc.w	\8,\9,\10,\11,\12
		dc.w	\13
		endm

REG_Object	macro
		dc.w	\1,\2,\3,\4,\5,\6,\7,\8,\9,\10,\11
		dc.l	\12
		dc.w	\13
		endm

PIC_Object	macro
		dc.l	\1
		dc.w	\2,\3,\4
		dc.l	\5,\6
		endm

;--------------------------- Includes laden -------------------------------------------
	incdir	include:
	include	exec/exec_lib.i
	include	exec/execbase.i
	include	dos/dos_lib.i
	include	dos/dostags.i
	include	dos/dos.i

	include	exec/libraries.i
	include	exec/interrupts.i

	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	graphics/view.i

	include	misc/BuggsMacros.i
	include	misc/EagleplayerEngine.i

	include	libraries/gadtools.i
	include	libraries/locale_lib.i

	include "intuition/icclass.i"
	include "intuition/classes.i"
        include "intuition/classusr.i"
        include "intuition/imageclass.i"
	include	libraries/utility_lib.i

	include	libraries/mathffp_lib.i
	include	libraries/mathtrans_lib.i

	include	guigfx/guigfx_lib.i
	include	guigfx/guigfx.i
	include	render/render.i

	include	libraries/asl.i
	include	libraries/asl_lib.i

	include	libraries/pm.i
	include	libraries/popupmenu_lib.i
;-------------------------------------------------------------------------------
;Flags fr Image Strukturen
	BITDEF	IM,Inactive,0	;Image nicht aktiv, berspringen bei der Darstellung und nchstes aktives heraussuchen

;Private EP Nummern
MI_Precisionselect	equ	EPNr_FirstExternal+8
MI_SetSkin		equ	EPNr_FirstExternal+9
MI_SetDouble		equ	EPNr_FirstExternal+10
MI_SetShade		equ	EPNr_FirstExternal+11

PID_Bar			equ	EPNr_FirstExternal+12
PID_Skin		equ	EPNr_FirstExternal+13
PID_Repeat		equ	EPNr_FirstExternal+14
PID_Shuffle		equ	EPNr_FirstExternal+15
PID_TimeRemain		equ	EPNr_FirstExternal+16
PID_Double		equ	EPNr_FirstExternal+17
PID_Winshade		equ	EPNr_FirstExternal+18
PID_Clutterbar		equ	EPNr_FirstExternal+19


	section	0,code

	basereg	Datas,a5

	ifne	Eagleplayer
*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
EUS_Structure:	moveq	#-1,d0				;EUS_Jump
		rts
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
myEPBase	dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	EUIB_OnlyActive			;EUS_TickFlags
		dc.l	USMB_NewModule!USMB_NewSong	;EUS_MsgFlags
		dc.l	MyProzessName			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	39				;EUS_Kickstart (V3.0)
		dc.l	13	;EAGLEVERSION		;EUS_EPVersion (V2.02)
		structver				;EUS_Version,EUS_Revision
		dc.l	MyMenuName			;EUS_Username
		dc.w	0				;EUS_WinX
		dc.w	14				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
Prefsflags:	dc.l	PFlag_AnalyzerPower!PFlag_Analyzer	;EUS_Special, Prefs flags

		dc.w	0				;EUS_Special2
		dc.w	0				;EUS_Special2

		dc.l	0				;EUS_Special3
		structdate				;EUS_Creatordate
		dc.b	0				;EUS_Prioritt
		dc.b	EUTY_MainWindow			;EUS_Type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6
		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	"$VER: Eagleplayer-EagleAMPGui V"
		ver
		dc.b	` (`
		date
		dc.b	`)`,0
		even

	endc
;--------------------------- Strings -----------------------------------
	ifeq	Eagleplayer
	bra	Start
	endc
MyMenuName:	dc.b	"EagleAMPGui24",0
MyProzessName:dc.b	"EagleAMPGui24.1",0
MyCreatorname:dc.b	`code by Henryk "Buggs" Richter, graphics system originally from Win95/NT music player WinAMP`,0

MySpecialInfo:	dc.b	`EagleAMPGui is the answer to WinAMP, one of the first Windows(TM) `
		dc.b	`applications supporting customized user interfaces. You may easily `
		dc.b	`create your own look by grabbing the graphics from the "EagleAMP-Skins" `
		dc.b	`directory and drawing your own buttons, sliders or whatever. `
		dc.b	`WinAMP can be downloaded from www.winamp.com and is copyrighted by `
		dc.b	`Nullsoft.`
		dc.b	0
SubItem.MSG:	dc.b	"EagleAMPGui-Prefs",0
SubItem1.MSG	dc.b	"greedy colour allocation",0
SubItem2.MSG	dc.b	"select Skin",0
SubItem3.MSG	dc.b	"Double Size Mode",0
SubItem4.MSG	dc.b	"Windowshade Mode",0
SelectText:	dc.b	`Select Skin for EagleAMPGui`,0
VolumeText:	dc.b	`Volume:   `,0
BalanceText:	dc.b	`Balance:    `,0
Defaultname:	dc.b	`EagleAMP: no file`,0

int_name:	dc.b	`intuition.library`,0
dos_name:	dc.b	`dos.library`,0
gfx_name:	dc.b	`graphics.library`,0
util_name:	dc.b	`utility.library`,0
mathffp_s:	dc.b	`mathffp.library`,0
mathtrans_s:	dc.b	`mathtrans.library`,0
guigfx_s:	dc.b	`guigfx.library`,0
asl_name:	dc.b	`asl.library`,0
popupmenu_s:	dc.b	`popupmenu.library`,0

butclass:	dc.b	`buttongclass`,0
frbutclass:	dc.b	`frbuttonclass`,0
imgclass	dc.b	`imageclass`,0

Help_ActiveAmplifier:	dc.b "BifatGui_ActiveAmplifier",0
DLViewername:		dc.b "Dirlistviewer",0
Managername:		dc.b "Manager",0
AmpManagername:		dc.b "Amplifiermanager",0
Moduleinfoname:		dc.b "Moduleinfo",0
Formatloadername:	dc.b "Formatloader",0
Patternname:		dc.b `Pattern: `,0
Subsongname:		dc.b `Subsong: `,0

Optionstext:		dc.b	`Options Menu`,0
Preferencestext:	dc.b	`Player/Engines Manager`,0
Infotext:		dc.b	`ModuleInfo`,0
Doubletext:		dc.b	`toggle Doublesize mode`,0
Vtext:			dc.b	`Amplifiermanager`,0

Remaining.msg:		dc.b	`Remaining Time`,0
Repeat.msg:		dc.b	`Repeat`,0
Shuffle.msg:		dc.b	`Shuffle`,0
Clutterbar.msg:		dc.b	`always show Clutterbar`,0

savename:		dc.b	`EagleAMPGui.cfg`,0

FXTask_Name:		dc.b `EagleAMPGui FX`,0


txt_nomathffp:		dc.b	`mathffp.library not found!`,0
txt_nomathtrans:	dc.b	`mathtrans.library not found!`,0
txt_noggfx:		dc.b	`guigfx.library V11 not found!`,0
txt_nomem:		dc.b	`Error converting graphics!`,10,10
			dc.b	`Please make sure to have enough memory free.`,0
txt_nofiles:		dc.b	`Error loading graphics!`,10,10
			dc.b	`Pleae make sure to have EagleAMPGui correctly`,10
			dc.b	`installed, have installed the required datatypes`,10
			dc.b	`for your graphics and enough memory free.`,10

my_easytitle:	dc.b	`EagleAMPGui Message`,0
my_easygadget:	dc.b	`  OK  `,0

	cnop	0,4
;----------------------------- Daten ------------------------------------
	ifeq	Eagleplayer	;fr Testroutinen liegen die Flags hier, sonst in EUS Struktur
aha		dc.b	` 0123456789 !ABCDEFGHIJKLMNOPQRSTUVWXYZDies ist ein sehr sehr langer Text ! 01234567890`,0
aha2		dc.b	`Sound-Drecker !`,0
	cnop	0,4
Prefsflags:	dc.l	PFlag_AnalyzerPower!PFlag_Analyzer	;EUS_Special, Prefs flags
	endc


		cnop	0,4

	ifne	Eagleplayer
*----------------------------------------------------------------------------*
TagListe:
		ifne	UseFPU
			dc.l	EUT_AttnFlags,AFF_68020!AFF_68881
		else
			dc.l	EUT_AttnFlags,AFF_68020
		endc
		
		dc.l	EUT_InitEngine,Inits
		dc.l	EUT_ExitEngine,CloseLibs	;Libs und eventl. Fenster schlieen
		dc.l	EUT_OpenAWindow,OpenAWindow
		dc.l	EUT_CloseAWindow,CloseAWindow
		dc.l	EUT_DeActivate,CloseAWindow
;*		dc.l	EUT_SetMenuStrip,SetMenuStrip
;*		dc.l	EUT_ClearMenuStrip,ClearMenuStrip
		dc.l	EUT_GetMsg,HandleWindowEvents

		dc.l	EUT_GetWaitMask,GetWaitMask

;		dc.l	EUT_EnableAll,EnableAll
;		dc.l	EUT_DisableAll,DisableAll

		dc.l	EUT_GetConfig,GetConfig
;		dc.l	EUT_Saveconfig,Saveconfig
;		dc.l	EUT_NewConfig,NewConfig

	ifeq	FXTask
		dc.l	EUT_Interrupt,myIntserver
	endc
		dc.l	EUT_NewModule,NewModuleEvent
		dc.l	EUT_KillModule,KillModuleEvent
		dc.l	EUT_NewSong,NewModuleEvent	;sicherheitshalber alles updaten
		dc.l	EUT_Startint,UpdateUPS
		dc.l	EUT_Stopint,UpdateUPS

;		dc.l	EUT_SignalReceived,SignalReceived
		dc.l	EUT_GetWindowHandle,GetWindowHandle
		dc.l	EUT_GetInterruptMask,GetInterruptMask

;		dc.l	EUT_NewScrollText,NewScrollText
;		dc.l	EUT_PrintText,PrintText
;		dc.l	EUT_ClearTextWindow,ClearTextWindow

		dc.l	EUT_GetAbortMsg,GetAbortMsg
		dc.l	EUT_ChangeGui,ChangeGui		;nur Zustnde
		dc.l	EUT_ChangePrefs,ChangePrefs	;Zustnde,Slider
							;mit Refresh
;		dc.l	EUT_GetPrefs,GetPrefs

		dc.l	EUT_GetGuiMenuStrip,GetMenuStrip
;		*dc.l	EUT_FreeGuiMenuStrip,FreeMenuStrip

		dc.l	EUT_InitDisplay,InitCrunchDisplay	;diese 3
		dc.l	EUT_FillDisplay,CrunchDisplay		;fhren direkt
		dc.l	EUT_RemoveDisplay,EndCrunchDisplay	;auf Bearbeitungsroutine...

;		dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_BifatGui

		dc.l	0
	else

Start:
	lea	Datas,a5
	bsr	Inits				;Libs ffnen, Data Area lschen usw.
	bmi	error$

;	move.l	#$3c8efa35,d0
;	move.l	mathtrans(a5),a6
;	jsr	_LVOSPFieee(a6)

;	move.l	mathffp(a5),a6
;	jsr	_LVOSPFix(a6)

;	bsr	SelectSkin

	bsr	OpenWin				;Fenster ffnen, Images umrechnen usw.
	bmi	error$

;	bsr	HandleOptions

	ifeq	Eagleplayer			;Test fr Printtext
	lea	aha,a0
	move.l	#ID_Textname1,d0
	bsr	PrintText
	endc

	move.l	#ID_Play,d0
	bsr	Findgadget
	tst.l	d0
	beq	no$

		move.l	d0,a0

;		move.w	GG_Flags(a0),d0
;		and.l	#GFLG_ImageDisable,d0

		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)
		move.l	#0,4(A3)
		clr.l	8(A3)
		suba.l	a2,a2
		move.l	WinHandle(A5),a1
		IB
		jsr	_LVOSetGadgetAttrsa(A6)
no$

	bsr	HandleActions

	bsr	CloseWin

	bsr	CloseLibs

	moveq	#0,d0				;Programm ordnungsgem beendet
	rts
error$
	bsr	CloseWin

	bsr	CloseLibs

	moveq	#-1,d0				;Programm wegen Fehler abgebrochen
	rts

	endc


******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	Push	All

	lea	datas,a5
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	lea	my_easygadget(pc),a0
	move.l	a0,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	IB
	CallSys	EasyRequestArgs

	Pop	All
	rts

	ifne	Eagleplayer

*-----------------------------------------------------------------------------*
* Testet, ob ESC gedrckt wurde.
* Alle anderen Messages werden erstmal ignoriert.
GetAbortMsg:	lea	Datas,a5
		moveq	#0,d0
		moveq	#0,d1
		rts

		*--- Msg holen ---*
		EB
;		move.l	Port(a5),d0
		beq.w	.NoOne
		move.l	d0,a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq	.NoOne

		*--------- Daten aus Message holen --------*
		move.l	d0,a1
		move.l	im_Class(a1),d7
		move.w	im_Code(a1),d5 		;<-
		move.l	im_IAddress(a1),d6 	;<-
		move.w	im_Qualifier(a1),d4
		EB
		jsr	_LVOReplyMsg(a6)

		cmp.l	#RAWKEY,d7			*VANILLAKEY
		bne	.NoOne
		cmp.w	#$63,d5
		bne.s	.NoOne
		moveq	#EPNr_Abort,d1
		bra.s	.Ok

.NoOne:		moveq	#0,d1
.Ok:		moveq	#0,d0
		rts
*-----------------------------------------------------------------------------*
* Input: d0.w=Type des windows
*	 a0  =WindowName
*	 a1  =ScreenName
* Output:d0 = Error oder NULL
*-----------------------------------------------------------------------------*
OpenAWindow:	lea	Datas,a5
		cmp.w	#EPST_MainWindow,d0
		bne.s	NoMainWindow
;		move.l	a0,Eaglename(a5)	;Window Name interessiert nicht
		move.l	a1,myScreentitle(a5)

		lea	EUS_Structure(pc),a4

		tst.l	WinHandle(a5)
		bne.s	Ok$

		bsr.w	AllocSignal
		cmp.l	#-1,d0
		beq	NoSignal$

		bsr.w	OpenWin
		tst.l	WinHandle(a5)
		beq.s	FreeSignal$
Ok$:		moveq	#0,d0
		rts

FreeSignal$:	bsr.w	FreeSignal
NoSignal$:	moveq	#EPR_CantOpenWin,d0
		rts

NoMainWindow:	moveq	#EPR_ErrorInArguments,d0
		rts

NoMem:		moveq	#EPR_NotEnoughMem,d0
		rts

*-----------------------------------------------------------------------------*
GetWindowHandle:
		move.l WinHandle,d0
		rts

*-----------------------------------------------------------------------------*
GetMenuStrip:
		lea	GuiMenu,a0
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
AllocSignal:
		move.l	ScrollSignal(a5),d0
		bge.s	SignalDa$
		moveq	#-1,d0
		EB
		CallSys	AllocSignal		;2. Signal allokieren (fr Interrupt)
		move.l	d0,ScrollSignal(a5)
SignalDa$:	tst.l	d0
		rts

*-----------------------------------------------------------------------------*
FreeSignal:	move.l	ScrollSignal(a5),d0
		cmp.l	#-1,d0
		beq.s	NoSignal$
		EB
		CallSys	FreeSignal
NoSignal$:
		move.l	#-1,ScrollSignal(a5)
		rts
		
*-----------------------------------------------------------------------------*
* Input: d0 = Type des Windows
* Output: --
*-----------------------------------------------------------------------------*
CloseAWindow:	lea	Datas,a5
		cmp.w	#EPST_MainWindow,d0
		bne.s	NoMainWindow

		tst.l	WinHandle(a5)
		beq.s	NoWindow$
;		bsr.w	GetConfig
		bsr.w	CloseWin
		bsr.w	FreeSignal
		clr.l	LastMenu(A5)		;Men nicht mehr valid !
NoWindow$:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Input:  --
* Output: d0 = SignalMask (ohne InterruptMask)
*-----------------------------------------------------------------------------*
GetWaitMask:	moveq	#0,d0
		lea	Datas,a5

		move.l	WinHandle(a5),d1
		beq.s	NoPort$
		move.l	d1,a0
		move.l	wd_UserPort(a0),d1
		beq	NoPort$
		move.l	d1,a0
		move.b	MP_SIGBIT(a0),d1
		bset	d1,d0
NoPort$:	rts

*-----------------------------------------------------------------------------*
* Input: --
* Output:d0 = Signalmask (ohne WaitMask)
*-----------------------------------------------------------------------------*
GetInterruptMask:
		moveq	#0,d0
		lea	Datas,a5
		move.l	ScrollSignal(a5),d3	;fr Interrupt
		bset	d3,d0
		rts

*-----------------------------------------------------------------------------*
* Input:	d0 = SignaleSet
* Output:	d0 = ActionNr oder Null
*-----------------------------------------------------------------------------*
SignalReceived:	lea	Datas,a5
		move.l	ScrollSignal(a5),d3	;fr Interrupt
		btst	d3,d0
		beq.w	.Return

		bsr	myIntserver
.Return:	rts				;GetMsg wird trotzdem

*-----------------------------------------------------------------------------*

	endc

 ifeq	Eagleplayer

;*************************************************************************************
;*       Mainloop, Abfrage der Intuition-Messages, Verteiler fr Events aller Art    *
;*************************************************************************************

;------------------------------ Testroutine ------------------------------------------
;Input:  -
;Output: -
HandleActions:
	Push	All
MainLoop$
	bsr	HandleWindowEvents
	cmp	#EPNr_Quit,d0
	beq	End$
	tst	d0
	bne	MainLoop$

	move.l	WinHandle(A5),d0
	beq	nowin$
	move.l	d0,a0
	move.l	wd_UserPort(a0),d0
	move.l	d0,a0
	moveq	#0,d0
	move.b	MP_SIGBIT(a0),d1
	bset	d1,d0

	ifne	Inttest
	moveq	#1,d1
	DB
	CallSys	Delay
	bsr	myIntserver
	else
	EB
	CallSys	Wait
	endc
nowin$
	bra	MainLoop$
End$
	Pop	All
	rts

 endc
****************************************************************************************
*                           VBI-Messageverteiler                                       *
****************************************************************************************
;Input:  -
;Output: -
myIntserver:
		Push	All
		lea	Datas,a5

		addq.w	#1,Ticks(a5)

		lea	Interrupttable(pc),a0
next$
		move.l	(a0)+,d0
		beq	end$
		move.l	(a0)+,d1
		beq	doit$

		moveq	#0,d2
		move	Ticks(A5),d2
		divu	d1,d2
		and.l	#$ffff0000,d2
		bne	next$			;ok, mehr Ticks abwarten
doit$
		bsr	FindObject		;Gadget Objekt in Liste finden
		beq	next$

		Push	a0

		move.l	d0,a0
		move.l	MOL_React(a0),d0	;Einsprung holen
		beq	skip$
		move.l	d0,a1
		jsr	(a1)
skip$
		Pop	a0
		bra	next$
end$
		Pop	All
		moveq	#1,d0
		rts
;***************************************************************************************
;* bei "NewModule" Message alle Infos update, z.B. Modulname, Soundsystemname,         *
;* Tracknummer, Pattern, Subsongs usw.                                                 *
;***************************************************************************************
NewModuleEvent:
		Push	All
		bsr	DisableFXTask

		lea	Datas,a5

		lea	NewModuletable,a0
next$
		move.l	(a0)+,d0
		beq	end$
		bsr	FindObject		;Objekt in Liste finden
		beq	next$

		Push	a0

		move.l	d0,a0
		move.l	MOL_React(a0),d0	;Einsprung holen fr Abarbeitungsroutine
		beq	skip$
		move.l	d0,a1

		moveq	#0,d0
		jsr	(a1)
skip$
		Pop	a0
		bra	next$
end$
		bsr	EnableFXTask
		Pop	All
		rts
KillModuleEvent:
		Push	All
		bsr	DisableFXTask

		lea	Datas,a5
		clr.l	FFT_StructAdr(a5)	;

		lea	NewModuletable,a0
next$
		move.l	(a0)+,d0
		beq	end$
		bsr	FindObject		;Objekt in Liste finden
		beq	next$

		Push	a0

		move.l	d0,a0
		move.l	MOL_React(a0),d0	;Einsprung holen fr Abarbeitungsroutine
		beq	skip$
		move.l	d0,a1

		moveq	#1,d0
		jsr	(a1)
skip$
		Pop	a0
		bra	next$
end$
		bsr	EnableFXTask
		Pop	All
		rts

;***************************************************************************************
;*          bei "ChangePrefs" Message alle Infos update, z.B. Songend, Fadein/out      *
;***************************************************************************************
;Input:  D0 - EPNr oder 0, wird vom Eagleplayer durchgereicht
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
;Output: -
ChangePrefs:
		Push	All
		lea	Datas,a5

		lea	NewPrefstable,a0
next$
		movem.l	(a0)+,d4/d5
		tst.l	d4
		beq.s	end$
		cmp.l	d0,d4
		bne.s	next$

		Push	All
		move.l	d5,a0
		moveq	#0,d0
		jsr	(a0)
		Pop	All
		bra	next$
end$
		Pop	All
		rts
;****************************************************************************************
;*          bei "ChangeGui" Message alle Gadgets update, z.B. NextMod/NextSong/NextPatt *
;****************************************************************************************
;Input:  D0 - EPNr oder 0, wird vom Eagleplayer durchgereicht
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
;Output: -
ChangeGui:
		Push	All
		lea	Datas,a5
		and.l	#1,d1			;nur 0/1 erlaubt

		lea	NewGuitable-3*4,a0
next$
		lea	3*4(a0),a0
		movem.l	(a0),d4/d5/d6
		tst.l	d4
		beq.s	end$
		cmp.w	d0,d4
		bne.s	next$

		move.l	d1,2*4(a0)

		Push	All
		move.l	d5,d0
		bsr	Findgadget
		move.l	d0,d7
		beq	no2$

		move.l	d0,a0
		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)
		move.l	d1,4(A3)
		clr.l	8(A3)
		suba.l	a2,a2
		move.l	WinHandle(A5),a1
		IB
		CallSys	SetGadgetAttrsA
		
		move.l	d7,a0
		move.l	WinHandle(A5),a1
		suba.l	a2,a2
		moveq	#1,d0
		IB
		CallSys	RefreshGList
no2$
		Pop	All
		bra	next$
end$
		Pop	All
		rts
;****************************************************************************************
;*          letzte "ChangeGui" Message auf nderungen des UI anwenden                   *
;****************************************************************************************
;Input:  -
;Output: -
SimChangeGui:
		Push	All
		lea	Datas,a5

		lea	NewGuitable-3*4,a0
next$
		lea	3*4(a0),a0
		movem.l	(a0),d4/d5/d6
		tst.l	d4
		beq.s	end$

		move.l	d6,d1

		Push	All
		move.l	d5,d0
		bsr	Findgadget
		move.l	d0,d7
		beq	no2$

		move.l	d0,a0
		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)
		move.l	d1,4(A3)
		clr.l	8(A3)
		suba.l	a2,a2
		move.l	WinHandle(A5),a1
		IB
		CallSys	SetGadgetAttrsA
		
		move.l	d7,a0
		move.l	WinHandle(A5),a1
		suba.l	a2,a2
		moveq	#1,d0
		IB
		CallSys	RefreshGList
no2$
		Pop	All
		bra	next$
end$
		Pop	All
		rts
;***************************************************************************************
;* "ChangePrefs" Message simulieren zum Update der Einstellungen bei ffnen des        *
;* Fensters und Statusnderungen                                                       *
;***************************************************************************************
;Input:  -
;Output: -
UpdatePrefs:
		Push	All

		lea	NewPrefstable,a0
next$
		movem.l	(a0)+,d4/d5
		tst.l	d4
		beq.s	end$

		Push	a0
		move.l	d5,a0
		suba.l	a1,a1
		moveq	#0,d0
		jsr	(a0)
		Pop	a0
		bra	next$
end$
		Pop	All
		rts
;============= Save Player Config Routine ===========================
SaveConfig:
	movem.l	d0-a6,-(sp)

	ifne	Eagleplayer

	DB

	move.l	EUS_Structure+EUS_EPBase(pc),a0
	move.l	EPG_ConfigDirArrayPtr(a0),d1
	moveq	#-2,d2			;access_read
	jsr	_LVOlock(a6)
	tst.l	d0
	beq	.nolock			;Path not found
	move.l	d0,d1
	jsr	_LVOcurrentdir(A6)
	move.l	d0,d7

	lea	savename(pc),a1
	move.l	a1,d1
	move.l	#1006,d2		;MODE_NEWFILE
	jsr	_LVOopen(A6)
	move.l	d0,d6
	beq.s	.fail

	move.l	d0,d1				;Handle
	move.l	#ConfigDatas,d2			;Adr
	move.l	#ConfigDatasLen,d3		;len
	jsr	_LVOwrite(a6)

	move.l	d6,d1
	jsr	_LVOclose(a6)
.fail
	move.l	d7,d1
	jsr	_LVOCurrentdir(A6)
	move.l	d0,d1
	jsr	_LVOUnlock(A6)
.nolock
error$
	endc
	
	movem.l	(Sp)+,d0-a6
	rts
;============= Load Player Config Routine ===========================
Loadconfig:
	movem.l	d0-a6,-(sp)
	bsr	InitPrefs

	DB

	ifeq	Eagleplayer
		move.l	#testpath,d1
	else
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_ConfigDirArrayPtr(a0),d1
	endc

	moveq	#-2,d2			;access_read
	jsr	_LVOlock(a6)
	tst.l	d0
	beq	.nolock			;Path not found
	move.l	d0,d1
	jsr	_LVOcurrentdir(A6)
	move.l	d0,d7

	lea	savename(pc),a1
	move.l	a1,d1
	move.l	#MODE_Oldfile,d2		;MODE_NEWFILE
	jsr	_LVOopen(A6)
	move.l	d0,d6
	beq.s	.fail

	move.l	d0,d1				;Handle
	move.l	#ConfigDatas,d2			;Adr
	move.l	#ConfigDatasLen,d3		;len
	jsr	_LVOread(a6)

	move.l	d6,d1
	jsr	_LVOclose(a6)

	move.l	EAMP_ID(A5),d0
	cmp.l	#"EAMP",d0
	bne.s	def$
	move.l	EAMP_ID+4(A5),d0
	cmp.l	#PrefsVersion,d0
	beq.s	ok$
def$
	bsr	InitPrefs
ok$

.fail
	move.l	d7,d1
	jsr	_LVOCurrentdir(A6)
	move.l	d0,d1
	jsr	_LVOUnlock(A6)
.nolock
error$
	movem.l	(sp)+,d0-a6
	rts

	ifeq	Eagleplayer
testpath	dc.b	`EP:Configs`,0
	endc
	cnop	0,4
InitPrefs:
	Push	All
	move.l	#`EAMP`,EAMP_ID(A5)		;ID
	move.l	#PrefsVersion,EAMP_ID+4(a5)	;Version

	clr.b	picturepath(a5)

	Pop	All
	rts
;--------------------------------------------------------------------------------------
;-                    Abfragen an das Fenster beantworten                             -
;--------------------------------------------------------------------------------------
;Input:  -
;Output: D0 - EPNr oder 0, wird an Eagleplayer durchgereicht
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleWindowEvents:
		Push	d4-a6
GetMsg:
		lea	Datas,a5
		suba.l	a1,a1
		move.l	NextSelect(a5),d0	;Multiselect bei PDMenus
		bne.s	NextSelect$

		move.l	WinHandle(A5),d0
		beq	nowin$
		move.l	d0,a0
		move.l	wd_UserPort(a0),d0
		move.l	d0,a0
		EB
		CallSys	GetMsg			;wird von der Handlingroutine replied
		tst.l	d0
		beq	nowin$
		move.l	d0,a1			*IntuiMessage

	*----------- Auswertung der Window-Message -----------*

	*----- Teste EP-Messages --------*
	* Die Message wird nicht replyed *
	* Closewindow,Vanillakey,Menupick*
	* werden abgefragt.		 *
	*--------------------------------*
	* Input: a0=Nextselect or NULL
	* 	 a1=Message oder NULL
	* Output:d0=EPNr oder NULL
	*	 d1=NextSelect
	*	 a1=Message oder NULL
	*	 d2/a2=Arg1
	*	 d3/a3=Arg2
	*-------------------------------*
	moveq	#0,d0
NextSelect$:
	move.l	d0,a0

	ifne	Eagleplayer
		move.l	myEPBase(pc),a4
		jsr	ENPP_GetEPNrfromMessage(a4)	* In: a1=Message
	else
		moveq	#0,d0
		moveq	#0,d1
	endc
		move.l	d1,NextSelect(a5)
	
		move.l	a1,d4
		beq	nomsg$

		lea	tmpIMsg(a5),a0		;Intuimsg kopieren
		lea	(a1),a2
		move.w	#im_SIZEOF-1,d4
copy$		move.b	(a2)+,(a0)+
		dbf	d4,copy$

		move.l	im_Class(a1),d7		;IDCMP-Class Tabelle 1 (vor Reply der MSG abgearbeitet wichtig bei z.B. IDCMP_Newsize)
		lea	IDCMPtable1(pc),a3
classloop1$
		movem.l	(a3)+,d4/a0
		tst.l	d4
		beq.s	notfound1$
		cmp	d7,d4
		bne	classloop1$
		moveq	#0,d0			;solche Msgs wie Menupick usw. werden ignoriert, ansonsten neue Kommandos
		Push	d4-a6			;<-
		jsr	(A0)			;Einsprung in Routine
		Pop	d4-a6			;<-
notfound1$
		Push	All
		EB
		CallSys	ReplyMsg		;Message Reply
		Pop	All

		tst.l	d0
		beq.w	msg$

		cmp.w	#EPNr_FirstExternal,d0	;externe Kommandos, also Kommandos, die nur
		blo.w	rts$			;das GUI und nicht den EP betreffen, aus-
		cmp.w	#EPNr_LastExternal,d0	;maskieren und gesondert behandeln
		bhi.w	rts$			;

;
		bsr	MenueAuswertung		;falls Custom-GUIPrefs Men
		bra	GetMsg
msg$
		lea	tmpIMsg(a5),a1
		move.l	im_Class(a1),d7		;IDCMP-Class Tabelle 2
		lea	IDCMPtable2(pc),a3
classloop3$
		movem.l	(a3)+,d4/a0
		tst.l	d4
		beq.s	notfound3$
		cmp.l	d7,d4
		bne	classloop3$
		moveq	#0,d0			;solche Msgs wie Menupick usw. werden ignoriert, ansonsten neue Kommandos zurckgegeben
		Push	d4-a6			;
		jsr	(A0)			;Einsprung in Routine
		Pop	d4-a6			;
notfound3$

		cmp.w	#EPNr_FirstExternal,d0	;interne Manahmen erfolgt ?
		blo.w	weiter$			;
		cmp.w	#EPNr_LastExternal,d0	;
		bls.w	GetMsg			;ja -> nochmal Message zu holen versuchen, sonst
						;ruft der EP bei Rckwert von `0` oder 
						;"Out of Range" die Routine erst
						;wieder bei einer neu eintreffenden MSG auf
weiter$
		
nomsg$
nowin$
rts$
		Pop	d4-a6
		move.l	d2,a2			;fix fr EP Bug
		rts
;*************************************************************************************
;*                               Gadget-Aktionen                                     *
;*************************************************************************************
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleWinClose:
	move.l	#EPNr_Quit,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	rts

;*************************************************************************************
;*       fr Spezialflle, Direktabfrage, ob Mausklick innerhalb z.B. der Regler     *
;*************************************************************************************
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleGadgets3:
	moveq	#0,d0
	
	move.l	im_IAddress(a1),d4	;leider hat Intuition da einen Bug, hier steht die Windowadresse drin :-(
	beq	Error$
	move.l	d4,a0			;also aktives Gadget selbst suchen...
	move.l	wd_FirstGadget(a0),d4
loop$
	beq	Error$
	move.l	d4,a0
	btst    #6,gg_Activation(a0)	; GACT_ACTIVEGADGET
	bne	this$
	move.l	gg_NextGadget(a0),d4
	bra	loop$
this$
	move.w	gg_GadgetID(a0),d0
	bsr	FindObject		;Gadget Objekt in Liste finden
	beq	Error$
	move.l	d0,a0

	bsr	InitRegler

	move.l	d0,a0
	move.l	MOL_React(a0),d0	;Custom Routine zur Reaktion auf Kommando ?
	beq	noRoutine$
	move.l	d0,a2
	jsr	(a2)			;Inputs: a0 = Objekt, a1=Kopie der Intuimsg
	bra	End$
noRoutine$
					;Standard-Befehlsabarbeitung
	move.l	MOL_Command(a0),d0
	moveq	#0,d1
	move.l	MOL_CMDArg1(a0),d2
	move.l	MOL_CMDArg2(a0),d3
End$
Error$
	rts
;*************************************************************************************
;*                               Gadget-Aktionen                                     *
;*************************************************************************************
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleGadgets:
	moveq	#0,d0
	
	move.l	im_IAddress(a1),d4
	beq	Error$
	move.l	d4,a0
	move.w	gg_GadgetID(a0),d0
	bsr	FindObject		;Gadget Objekt in Liste finden
	beq	Error$
	move.l	d0,a0

	cmp.w	#GLA_Moused,MOL_Type(a0)	;Regler ?
	bne.s	noregler$
	move.l	MOL_UserData(a0),d0
	beq	noregler$			;wie jetzt ?
	move.l	d0,a2
	clr.w	REG_Enable(a2)			;schon initialisiert ?
noregler$

	move.l	MOL_React(a0),d0	;Custom Routine zur Reaktion auf Kommando ?
	beq	noRoutine$
	move.l	d0,a2
	jsr	(a2)			;Inputs: a0 = Objekt, a1=Kopie der Intuimsg
	bra	End$
noRoutine$
					;Standard-Befehlsabarbeitung
	move.l	MOL_Command(a0),d0
	moveq	#0,d1
	move.l	MOL_CMDArg1(a0),d2
	move.l	MOL_CMDArg2(a0),d3
End$
Error$
	rts
***************************************************************************************
*                         Regler Struktur beim ersten Klick update                    *
***************************************************************************************
;Inputs: A0 - Objekt
;        A1 - Kopie der Intuimsg
InitRegler:
	push	all
	cmp.w	#GLA_Moused,MOL_Type(a0)	;Regler ?
	bne.s	noregler$
	move.l	MOL_UserData(a0),d0
	beq	noregler$			;wie jetzt ?
	move.l	d0,a2
	tst.w	REG_Enable(a2)			;schon initialisiert ?
	bne	noenable$

	clr.w	REG_Enable(a2)

	cmp.w	#REGTYPE_Circle,REG_Type(a2)
	bne.s	nocircle$

	move	im_MouseX(a1),d0		;aktuelle Koordinaten der Maus holen
	sub	REG_XCenter(a2),d0		;zentrieren
	ext.l	d0				;wg. 060
	move	im_MouseY(a1),d1
	sub	REG_YCenter(a2),d1		;zentrieren
	ext.l	d1				;wg. 060
	bsr	ToPolar				;Radius, Winkel bestimmen

	move.l	d1,REG_PhiStore(a2)		;Winkel sichern

	cmp	REG_MinRadius(a2),d0
	blt.s	noenable$
	cmp	REG_MaxRadius(a2),d0
	bgt.s	noenable$
	
	move	#1,REG_Enable(a2)

	bra	noenable$
nocircle$
;	move	im_MouseX(a1),REG_XCenter(a2)	;initiale X-Position merken
;	move	REG_Value(a2),REG_PhiStore(a2)	;initialen Wert merken

	move	#1,REG_Enable(a2)
noenable$

noregler$
	pop	all
	rts
;------------------------ Aufruf bei "IDCMPUpdate" fr GACT_IMMEDIATE -----------------------
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleGadgets2:
	move	PattTime(a5),d4		;Delay Schleife
	addq	#1,d4
	cmp	#2,d4
	blt.s	no3$
	moveq	#0,d4
no3$	move	d4,PattTime(A5)
	bne	rts$

	UB
	move.l	#GA_ID,d0
	move.l	im_Iaddress(a1),a0	; taglist to a0
	move.l	a1,d7
	jsr	_LVOFindTagItem(A6)	; look for the tag
	move.l	d7,a1
	tst.l	d0
	beq	Error$
	move.l	d0,a0
	move.l	4(a0),d0		; Gadget ID holen aus Tagliste

	bsr	FindObject		; Gadget Objekt in Liste finden
	beq	Error$
	move.l	d0,a0
	move.l	MOL_React(a0),d0	;Custom Routine zur Reaktion auf Kommando ?
	beq	noRoutine$
	move.l	d0,a2
	jsr	(a2)			;Inputs: a0 = Objekt, a1=Kopie der Intuimsg

	move	d4,PattTime(A5)
	bra	End$
noRoutine$
					;Standard-Befehlsabarbeitung
	move.l	MOL_Command(a0),d0
	moveq	#0,d1
	move.l	MOL_CMDArg1(a0),d2
	move.l	MOL_CMDArg2(a0),d3
End$
Error$
	rts
rts$
	move.l	#EPNr_FirstExternal,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	rts
;*******************************************************************************************
;*                         Routinen zur Behandlung der Regler                              *
;*******************************************************************************************
;Input:  a0 - Objekt
;        a1 - Kopie der IntuiMsg
;Output: -
HandleMoused:
	push	all

	move.l	a1,d0				;Intuimsg ?
	beq	noregler$			;nein->weiter

	move.l	MOL_UserData(a0),d0
	beq.w	noregler$
	move.l	d0,a2				;REG_Struktur

	cmp	#REGTYPE_Circle,REG_Type(a2)
	bne.w	nocircle$

	; delta phi berechnen aus neuem Winkel minus altem Winkel
	
	move	im_MouseX(a1),d0		;aktuelle Koordinaten der Maus holen
	sub	REG_XCenter(a2),d0		;zentrieren
	ext.l	d0				;wg. 060

	move	im_MouseY(a1),d1
	sub	REG_YCenter(a2),d1		;zentrieren
	ext.l	d1				;wg. 060
	bsr	ToPolar				;Radius(= d0), Winkel(= d1) bestimmen
	move.l	d1,d5

	move.l	REG_PhiStore(a2),d6		;alten Winkel holen

	move.l	mathffp(a5),a6
	move.l	d1,d0
	move.l	d6,d1
	jsr	_LVOSPSub(a6)			;d0 = (d0-d1)
	move.l	d0,d7				;delta phi

	move.l	d7,d1
	jsr	_LVOSPTst(A6)
	tst.l	d0
	beq	noregler$			;delta phi = 0 -> raus, keine nderung

	; Test auf berschreitung der Grenze zwischen 0 und 359
	; ggfalls Umrechnung des Drehwinkels

	move.l	d7,d1
	move.l	#$96CBE443,d0			;4.71238898 in FFP
	move.l	mathffp(a5),a6
	jsr	_LVOSPCmp(a6)
	tst.l	d0
	bmi	nobig$				;delta phi > 270 (3/2) ?

	move.l	#$C90FDB43,d1			;
	move.l	d7,d0
	move.l	mathffp(a5),a6
	jsr	_LVOSPSub(a6)			;delta phi = delta phi - 360 (2)
	move.l	d0,d7
nobig$
	move.l	d7,d1
	move.l	#$96CBE4C3,d0			;-4.71238898 in FFP
	move.l	mathffp(a5),a6
	jsr	_LVOSPCmp(a6)
	tst.l	d0
	bpl	nosmall$			;delta phi < -270 (-3/2) ?

	move.l	#$C90FDB43,d1			;
	move.l	d7,d0
	move.l	mathffp(a5),a6
	jsr	_LVOSPAdd(a6)			;delta phi = delta phi + 360 (2)
	move.l	d0,d7
nosmall$

	; Winkel umrechnen auf nderung des eingetragenen Wertes
;	move.l	d7,d0
;	move.l	mathtrans(a5),a6
;	jsr	_LVOSPTieee(A6)
;	move.l	d0,aha1
;	fmove.s	aha1,fp0

	move.w	REG_Maxvalue(a2),d0
	sub.w	REG_Minvalue(a2),d0		;Anzahl der Stufen aus Max-Min
	ext.l	d0
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(A6)			;in FFP

	move.l	d7,d1
	jsr	_LVOSPMul(A6)			;delta phi * NumValues
	move.l	d0,d7

	move.w	REG_PhiTotal(a2),d0
	beq.w	noregler$			;nur als Schussligkeitsschutz :-)
	ext.l	d0
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(A6)			;in FFP

	move.l	#$8efa353b,d1			;*/180, Umrechnung in Bogenma
	move.l	mathffp(a5),a6		
	jsr	_LVOSPMul(a6)
	move.l	d0,d1

	move.l	d7,d0
	jsr	_LVOSPDiv(a6)			;delta phi * NumValues / ffnungswinkel
	jsr	_LVOSPFix(a6)			;= Wertnderung
	tst.l	d0
	beq	no$
	move.l	d5,REG_PhiStore(a2)		;neuen Winkel sichern fr nchsten Durchlauf
no$
	add.w	REG_Value(a2),d0		;+ alter Wert = neuer Wert

minmax$
	cmp.w	REG_Minvalue(a2),d0		;min/max austesten und begrenzen
	bge.s	minok$
	move	REG_Minvalue(a2),d0
minok$

	cmp.w	REG_Maxvalue(a2),d0
	ble.s	maxok$
	move	REG_Maxvalue(a2),d0
maxok$
	move	d0,REG_Value(a2)
	bra.w	noregler$
nocircle$
	cmp	#REGTYPE_Verti,REG_Type(a2)
	bne.w	novertical$
			;Vertikaler Regler, Ausgabewert immer direkt relativ zur Mausposition
	move	im_MouseX(a1),d0
	sub	REG_XCenter(a2),d0		;min. X-Wert unterschritten ?
	bmi.s	novalue$
	cmp	REG_PhiMin(A2),d0		;max. X-Wert berschritten ?
	bgt.s	novalue$

	move	im_MouseY(a1),d0		;neuer Y-Wert
	sub	REG_YCenter(a2),d0		;minus Y-Position des Reglers
	sub	REG_Minradius(a2),d0

	move	REG_Maxvalue(a2),d1
	sub	REG_Minvalue(a2),d1		;max. Anzahl Schritte

	muls	d1,d0

	move	REG_Maxradius(a2),d1
	sub	REG_Minradius(a2),d1		;max. Breite des Reglerbereiches

	divs	d1,d0				;delta Value
	
	cmp.w	REG_Minvalue(a2),d0		;min/max austesten und begrenzen
	bge.s	minok12$

;	move	REG_Minvalue(a2),d0		;normal: minWert
	moveq	#-1,d0				;hier: auerhalb des erlaubten Bereiches
	bra.s	maxok12$
minok12$
	cmp.w	REG_Maxvalue(a2),d0
	ble.s	maxok12$
novalue$
;	move	REG_Maxvalue(a2),d0		;normal: maxWert
	moveq	#-1,d0				;hier: auerhalb des erlaubten Bereiches
maxok12$
	move	d0,REG_Value(a2)
	bra	noregler$
novertical$
			;Hori Regler, Ausgabewert immer direkt relativ zur Mausposition
	move	im_MouseX(a1),d0		;neuer X-Wert
	sub	REG_XCenter(a2),d0		;minus alter X-Wert = delta x
;	sub	REG_Minradius(a2),d0

	move	REG_Maxvalue(a2),d1
	sub	REG_Minvalue(a2),d1		;max. Anzahl Schritte

	muls	d1,d0

	move	REG_Maxradius(a2),d1
	sub	REG_Minradius(a2),d1		;max. Breite des Reglerbereiches

	divs	d1,d0				;delta Value
	
	cmp.w	REG_Minvalue(a2),d0		;min/max austesten und begrenzen
	bge.s	minok2$

	move	REG_Minvalue(a2),d0
minok2$
	cmp.w	REG_Maxvalue(a2),d0
	ble.s	maxok2$

	move	REG_Maxvalue(a2),d0
maxok2$
	move	d0,REG_Value(a2)
noregler$
	pop	all
	rts
;*******************************************************************************************
;* nderung in das Layout betreffenden Flags, diese ndern und ntigenfalls Refresh-Aktion *
;* Register brauchen nicht gesichert werden                                                *
;*******************************************************************************************
;Input:  (a1 - Kopie der IntuiMsg) - nicht verwendet
;        a0 - Objekt oder d0 - Flags, ob Refresh oder nicht
;Output: -
HandleToggles:
	move.l	a0,d1
	beq	nogad$

	move.l	MOL_CMDArg1(a0),d0		;zu alternierende Flags

	move.l	Prefsflags(pc),d1
	eor.l	d0,d1
	move.l	d1,Prefsflags

	move.l	MOL_CMDArg2(a0),d0

	bsr	InitMenuItems			;Bei Aufruf von Gadgets Menitems mit Update
nogad$
	btst	#TOGGB_Winrefresh,d0
	beq.w	nowinrefresh$

	and.l	#TOGGF_ChangeImages,d0

	bsr	DisableFXTask
;	bsr	CloseWin
;------------------ komplette Closewin: Routine ---------------------------
	bsr	RemoveGads		;Gadgets entfernen

	bsr	FreeGadgets		;und freigeben

;	bsr	ClosemyWindow		;dann Fenster dichtmachen

	tst.l	d0
	beq	none$
	bsr	FreeImages		;dann Images freigeben (nicht ntig, dadurch schnellerer Refresh)

	bsr	FreePictures
;
;	lea	Colourmap,a1
;	bsr	FreeColourmap		;allozierte Farben zurckgeben

	bsr	FreePenShareMap		;GGFX Pensharemap freigeben 
none$


;	bsr	UnlockPubScreen		;Screen freigeben

	clr.l	mywindowlist(a5)
;-------------------------------------------------------------------------
 ;	bsr	OpenWin


		lea	Windowlist,a0
nextlist$
		move.l	(a0)+,d0
		beq	takefirst$
		move.l	(a0)+,d1		;Flags holen
		beq	thisWindowList$		;keine Flags -> also immer brauchbar
		move.l	d1,d2			;sichern

		and.l	Prefsflags(pc),d2	;mit Prefsflags ausmaskieren
		cmp.l	d1,d2			;alle Prefsflags richtig ?
		beq.l	thisWindowList$		;ja, nehmen

		bra	nextlist$
takefirst$				;nix gefunden, erstbeste Liste

		lea	Windowlist,a0		;
		move.l	(a0)+,d0		;
		beq	Error$			;
thisWindowList$
		move.l	d0,mywindowlist(A5)

		bsr	LoadPictures
		beq	Error$

		bsr	LoadVisColor
		
		bsr	MakePenShareMap		;Drawhandle etc.
		bne	Error$

		move.l	mywindowlist(a5),a0
		bsr	CreateImages		;alle verwendeten Images umrechnen
		bne	Error$

		move.l	mywindowlist(a5),a0
		move	WIL_Width(a0),d2	
		move	WIL_Height(a0),d3

		move.l	WinHandle(A5),a0
		move.w	wd_LeftEdge(A0),d0
		move.w	wd_TopEdge(A0),d1

		cmp	wd_Width(a0),d2
		bne	change$
		cmp	wd_Height(a0),d3
		beq	direct$
change$
		IB
		CallSys	ChangeWindowBox

		move.l	mywindowlist(a5),a0
		bsr	CreateGadgets		;Gadgets erzeugen
		bne	Error$

		bsr	InitPrinttextRastport	;fr Printtext Rastport vorbereiten
		bsr	InitRemoteVolRastport

		bsr	InitAnalyzerBuffer	;fr Analyzer Hintergrund lschen
		bne	Error$

		bsr	EnableFXTask
Nowinrefresh$
		move.l	#myNR_ToggleFlag,d0
Error$
	rts
direct$
		move.l	mywindowlist(a5),a0
		bsr	CreateGadgets		;Gadgets erzeugen
		bne	Error$

		bsr	InitPrinttextRastport	;fr Printtext Rastport vorbereiten
		bsr	InitRemoteVolRastport

		bsr	HandleWinRefresh

		bsr	EnableFXTask
		bra	nowinrefresh$
;********************************************************************************
;* Images neu berechnen, Gadgets erstellen und eintragen bei Vernderung der    *
;* Windowlist, notwendig da ChangeWindowBox() nicht Realtime arbeitet           *
;********************************************************************************
HandleChangewin:
		move.l	WinHandle(a5),d0
		beq	end$
		move.l	d0,a0
	ifne	Eagleplayer
		move.w	wd_LeftEdge(a0),EUS_Structure+EUS_WinX
		move.w	wd_TopEdge(a0),EUS_Structure+EUS_WinY
	endc
;		move.l	mywindowlist(a5),a0
;		bsr	ShowBackdrops		;Hintergrundbilder einzeichnen
;		bsr	NewModuleEvent		;Namen eintragen, Subsonganzahl usw.
;		bsr	UpdatePrefs		;Prefs wie Songend/Filter usw. darstellen
;		bsr	AddGads			;Gadgets reinlinken
end$
		move.l	#EPNr_FirstExternal,d0	;damit Rcksprung in Mainloop mglich
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		rts
;********************************************************************************
;*                   Getconfig Callup                                           *
;********************************************************************************
GetConfig:
		lea	datas,a5
		move.l	WinHandle(a5),d0
		beq	end$
		move.l	d0,a0
	ifne	Eagleplayer
		move.w	wd_LeftEdge(a0),EUS_Structure+EUS_WinX
		move.w	wd_TopEdge(a0),EUS_Structure+EUS_WinY
	endc
end$
		moveq	#0,d0
		rts
;********************************************************************************
;* Images neu berechnen, Gadgets erstellen und eintragen bei Vernderung der    *
;* Windowlist, notwendig da ChangeWindowBox() nicht Realtime arbeitet           *
;********************************************************************************
HandleWinRefresh:
		move.l	WinHandle(a5),d0
		beq	end$
		move.l	d0,a0

		move.l	mywindowlist(a5),a0
		bsr	ShowBackdrops		;Hintergrundbilder einzeichnen

		bsr	HandleActiveWindow

		bsr	NewModuleEvent		;Namen eintragen, Subsonganzahl usw.

		bsr	AddGads			;Gadgets reinlinken bzw. refresh

		bsr	SimChangeGui		;einzelne Gadgets ein/aus

		bsr	UpdatePrefs		;Prefs wie Songend/Filter usw. darstellen
end$
		move.l	#EPNr_FirstExternal,d0	;damit Rcksprung in Mainloop mglich
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		rts
******************************************************************************************
*                   Aktive Titelzeile darstellen                                         *
******************************************************************************************
HandleActiveWindow:
		move.l	WinHandle(a5),d0
		beq	end$

		moveq	#ID_ActiveWindow,d0
		bsr	FindObject		;entsprechendes Objekt finden
		beq	end$
		move.l	d0,a0
		move.l	MOL_Images(a0),d2	;Image vorhanden ?
		beq	end$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
end$
		move.l	#EPNr_FirstExternal,d0	;damit Rcksprung in Mainloop mglich
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		rts
******************************************************************************************
*                   Inaktive Titelzeile darstellen                                       *
******************************************************************************************
HandleInActiveWindow:
		move.l	WinHandle(a5),d0
		beq	end$
		move.l	d0,a0

		moveq	#ID_InActiveWindow,d0
		bsr	FindObject		;entsprechendes Objekt finden
		beq	end$
		move.l	d0,a0
		move.l	MOL_Images(a0),d2	;Image vorhanden ?
		beq	end$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
end$
		move.l	#EPNr_FirstExternal,d0	;damit Rcksprung in Mainloop mglich
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		rts
;****************************************************************************************
;*                          Auswertung der GUIMen-Aktionen                             *
;****************************************************************************************
;Input: D0 - EPNr
;       D2 - Zustand, wenn ToggleCheck
MenueAuswertung:
	push	d4-a6

	cmp	#MI_Precisionselect,d0
	bne.s	nopalette$

	move.l	#PFlag_PaletteMode,d0
	not.l	d0
	move.l	Prefsflags(pc),d1
	and.l	d0,d1
	not.l	d0

	tst	d2
	beq	not$
	or.l	d0,d1
not$
	move.l	d1,Prefsflags

	suba.l	a0,a0
	move.l	#TOGGF_WinRefresh!TOGGF_ChangeImages,d0
	bsr	HandleToggles
	bra	end$
nopalette$

	cmp	#MI_SetSkin,d0
	bne	noskin$

	bsr	Skinselect
	bra	end$
noskin$

	cmp	#MI_SetDouble,d0
	bne	nodouble$

	bsr	SetDoubleMode
	bra	end$
nodouble$
	cmp	#MI_SetShade,d0
	bne	noshade$

	move.l	#PFlag_TitleOnly,d0
	not.l	d0
	move.l	Prefsflags(pc),d1
	and.l	d0,d1
	not.l	d0

	tst	d2
	beq	not3$
	or.l	d0,d1
not3$
	move.l	d1,Prefsflags

	suba.l	a0,a0
	move.l	#TOGGF_WinRefresh,d0
	bsr	HandleToggles
	bra	end$
noshade$

end$
	pop	d4-a6
	rts

InitMenuItems:
	;---------------------- Menitems init ---------------------------------
	Push	All
	lea	SubItem1,a0
	move	mi_Flags(a0),d0
	and	#~CHECKED,d0
	move.l	Prefsflags(pc),d1
	and.l	#PFlag_PaletteMode,d1
	beq.s	nocheck1$
	or	#CHECKED,d0
nocheck1$
	move	d0,mi_Flags(a0)	

	lea	EPM_SetDouble,a0
	move	mi_Flags(a0),d0
	and	#~CHECKED,d0
	move.l	Prefsflags(pc),d1
	and.l	#PFlag_Double,d1
	beq.s	nocheck2$
	or	#CHECKED,d0
nocheck2$
	move	d0,mi_Flags(a0)	

	lea	EPM_SetShade,a0
	move	mi_Flags(a0),d0
	and	#~CHECKED,d0
	move.l	Prefsflags(pc),d1
	and.l	#PFlag_TitleOnly,d1
	beq.s	nocheck3$
	or	#CHECKED,d0
nocheck3$
	move	d0,mi_Flags(a0)	

	Pop	All
	rts

SetDoubleMode:
	Push	All

	move.l	#PFlag_Double,d0
	not.l	d0
	move.l	Prefsflags(pc),d1
	and.l	d0,d1
	not.l	d0

	tst	d2
	beq	not2$
	or.l	d0,d1
not2$
	move.l	d1,Prefsflags

	suba.l	a0,a0
	move.l	#TOGGF_WinRefresh,d0
	bsr	HandleToggles

	Pop	All
	rts
ToggleDoubleMode:
	Push	All

	move.l	Prefsflags(pc),d1
	eor.l	#PFlag_Double,d1
	move.l	d1,Prefsflags

	suba.l	a0,a0
	move.l	#TOGGF_WinRefresh,d0
	bsr	HandleToggles

	bsr	InitMenuItems			;Menitems update
	Pop	All
	move.l	#EPNr_FirstExternal,d0
	rts
ToggleClutterbar:
	Push	All

	move.l	Prefsflags(pc),d1
	eor.l	#PFlag_Clutterbar,d1
	move.l	d1,Prefsflags

	suba.l	a0,a0
	move.l	#0,d0
	bsr	HandleToggles

	bsr	HandleClutterbar

	bsr	InitMenuItems			;Menitems update
	Pop	All
	move.l	#EPNr_FirstExternal,d0
	rts
ToggleWinshadeMode:
	Push	All

	move.l	Prefsflags(pc),d1
	eor.l	#PFlag_TitleOnly,d1
	move.l	d1,Prefsflags

	suba.l	a0,a0
	move.l	#TOGGF_WinRefresh,d0
	bsr	HandleToggles

	bsr	InitMenuItems			;Menitems update
	Pop	All
	move.l	#EPNr_FirstExternal,d0
	rts
Skinselect:
	Push	All

	bsr	SelectSkin
	tst.l	d0
	beq	noskin$

	bsr	SaveConfig

	suba.l	a0,a0
	move.l	#TOGGF_WinRefresh!TOGGF_ChangeImages,d0
	bsr	HandleToggles
noskin$
	Pop	All
	move.l	#EPNr_FirstExternal,d0
	rts
*****************************************************************************************
*          ber Popupmenu.library Options Men anzeigen                                 *
*****************************************************************************************
HandleOptions:
	move.l	#EPNr_FirstExternal,d6		;def. Return
	moveq	#0,d7				;def. Handle

	move.l	popupmenulib(a5),d0
	beq	fail$
	move.l	d0,a6				;Lib Pointer

	moveq	#ID_OptionsMenu,d0
	bsr	FindObject
	beq	fail$
	move.l	d0,a3
	tst.l	MOL_UserData(a3)
	beq	fail$

	;--------- Menitems erzeugen ----------
	move.l	MOL_UserData(a3),a4
createloop$
	move.l	PUD_ID(a4),d0
	beq	allitems$

	lea	mytags(a5),a1
	cmp.l	#PID_Bar,d0
	bne.w	nobar$

	move.l	#PM_TitleBar,(a1)+
	move.l	#1,(a1)+
	move.l	#TAG_Done,(a1)+
makeitem$
	lea	mytags(a5),a1
	CallSys	PM_ItemA
	move.l	d0,PUD_Allocated(a4)
	beq	freeall$

	lea	PUD_Size(a4),a4
	bra	createloop$
nobar$
	lea	mytags(a5),a1
	move.l	#PM_Title,(a1)+
	move.l	PUD_Text(A4),(a1)+
	move.l	#PM_ID,(a1)+
	move.l	PUD_ID(a4),(a1)+
	move.l	#PM_UserData,(a1)+
	move.l	PUD_ID(a4),(a1)+

	move.l	PUD_PFlag(a4),d0
	beq	enditem$
	move.l	#PM_Checkit,(a1)+
	move.l	#1,(a1)+
	move.l	#PM_Checked,(a1)+
	and.l	Prefsflags(pc),d0
	move.l	d0,(a1)+
enditem$
	move.l	#TAG_Done,(A1)+
	bra	makeitem$
allitems$
	;-------- Men erzeugen -----------------
	move.l	MOL_UserData(a3),a4
	lea	mytags(a5),a1
createloop2$
	move.l	PUD_ID(a4),d0
	beq	allitems2$

	move.l	#PM_Item,(a1)+
	move.l	PUD_Allocated(a4),(a1)+
	move.l	#TAG_DONE,(A1)

	lea	PUD_Size(A4),a4
	bra	createloop2$
allitems2$
	lea	mytags(a5),a1
	CallSys	PM_MenuA
	move.l	d0,d7
	beq	freeall$
	;-------- Men anzeigen -----------------

	lea	MyTags(A5),a2
	move.l	#PM_Menu,(a2)+
	move.l	d7,(a2)+
	move.l	#PM_Left,(a2)+
	move.w	#0,(a2)+
	move	MOL_Left(a3),(a2)+
	move.l	#PM_Top,(a2)+
	move.w	#0,(a2)+
	move	MOL_Top(a3),(a2)+
	move.l	#TAG_DONE,(A2)
	lea	MyTags(A5),a2
	move.l	Winhandle(a5),a1
	CallSys	PM_OpenPopupMenuA
	tst.l	d0			;nichts selektiert ?
	beq	freeall$		;ok, raus
	;-------- Aktion durchfhren ------------
	move.l	MOL_UserData(a3),a4
such$
	tst.l	PUD_ID(a4)
	beq	freeall$
	cmp.l	PUD_ID(A4),d0
	beq.s	this$
	lea	PUD_Size(A4),a4
	bra	such$
this$
	move.l	PUD_Callup(a4),d0
	beq	freeall$

	Push	d4-a6
	bsr	FindObject
	beq	nojump$
	move.l	d0,a0
	move.l	MOL_React(a0),d0	;Einsprung holen
	beq	skip$
	move.l	d0,a1
	jsr	(a1)
skip$
nojump$
	Pop	d4-a6
	move.l	d0,d6
	;-------- alles freigeben ---------------
freeall$
	Push	All
	move.l	d7,a1
	tst.l	d7
	beq	nomenu$
	move.l	popupmenulib(a5),a6
	CallSys	PM_FreePopupMenu
nomenu$
	Pop	All
fail$
	move.l	d6,d0
	rts
;****************************************************************************************
;* Text ausgeben, dazu in TempObjekt schreiben und danach dieses ins Fenster bertragen *
;****************************************************************************************
;Input:  D0 - ID des Objektes in welches der Text geprintet werden soll
;        A0 - UBYTE *OutputString , nullterminiert
;Output: D0 = 0, ok <-> sonst Fehler
PrintText:
	Push	d1-a6
	move.l	d0,d7			;Objektnummer sichern
	move.l	a0,a4			;Textadresse sichern

	bsr	FindObject		;entsprechendes Objekt finden
	beq	error$
	move.l	d0,a1

	moveq	#0,d6
	move	MOL_Width(a1),d6	;Breite ber alles
	
textloop$
	move.l	d7,d0			;Objektnummer sichern
	bsr	TextLength
	cmp	d6,d0			;Breite des Textes <= max. Breite ?
	ble	ok$			;ok, weiter
	lea	(a0),a2
loop0$
	tst.b	(a2)+
	bne	loop0$
	clr.b	-2(a2)			;Text um 1 Zeichen krzen
	bra	textloop$
ok$
	move	d0,d5			;Breite sichern (momentan nicht weiter verwendet)

	;--------------- Textfeld komplett lschen ----------------

	lea	mytags(a5),a0
	move.b	#` `,(a0)
	clr.b	1(a0)
	move.l	d7,d0			;Objektnummer holen
	bsr	TextLength
	tst	d0
	beq	error$			;Space darf nicht 0 Pixel breit sein

	divu	d0,d6			;Anzahl der hineinpassenden Chars rausfinden

	move	MOL_Width(a1),d1	;Breite ber alles
	move	d6,d2
	mulu	d0,d2			;Breite der ermittelten Anzahl von Spaces
	sub	d2,d1			;Offset
Clrloop$
	move.b	#` `,d0
	bsr	PrintChar		;D0 = ASCII-Char, D1=Xpos, A1=Zielobjekt
	add	d0,d1
	
	subq	#1,d6
	bne	Clrloop$

	move.b	#` `,d0
	moveq	#0,d1			;sicherheitshalber am Anfang 1. Zeichen auch lschen
	bsr	PrintChar		;D0 = ASCII-Char, D1=Xpos, A1=Zielobjekt

	;----------------------------------------------------------

	moveq	#0,d1			;Xpos von 0 an (linksorientiert)
loop$
	move.b	(a4)+,d0
	beq	end$
	bsr	PrintChar		;D0 = ASCII-Char, D1=Xpos, A1=Zielobjekt
	add	d0,d1
	bra	loop$
end$
	move.l	d7,d0			;Objektnummer holen
	bsr	FindObject		;entsprechendes Objekt finden
	beq	error$
	move.l	d0,a0
	move.l	MOL_Images(a0),d2	;Image vorhanden ?
	beq	error$
	move	MOL_Left(a0),d0		;Xpos
	move	MOL_Top(a0),d1		;Ypos
	move.l	d2,a0			;Image
	suba.l	a1,a1			;def. Rastport
	bsr	ShowImage

	Pop	d1-a6
	moveq	#0,d0
	rts
error$
	Pop	d1-a6
	moveq	#-1,d0
	rts
;*************************************************************************************
;*                      Textlnge in Pixels berechnen                                *
;*************************************************************************************
;Input:  D0 - ID des Objektes in welches der Text geprintet werden soll
;        A0 - UBYTE *OutputString , nullterminiert
;Output: D0 = 0 -> Fehler (oder leerer Text), sonst Breite
TextLength:
	Push	d1-a6

	bsr	FindObject		;entsprechendes Objekt finden
	beq	Error$
	move.l	d0,a1

	move.l	MOL_UserData(a1),d0	;Font eingetragen ?
	beq	Error$
	move.l	d0,a1			;Fontobjekt

	moveq	#0,d1
	move.w	MOL_UserData+2(a1),d1	;nominale Breite von fixedfonts

	move.l	MOL_CMDArg1(a1),d0	;Propinfo ?
	beq	nonprop$
	move.l	d0,a2			;Byteweise Breiten der einzelnen Zeichen

	moveq	#0,d2
	move	MOL_Width(a1),d2
	divu	d1,d2			;Anzahl der Zeichen

	moveq	#0,d0			;resultierende Breite
loop$
	moveq	#0,d1
	move.b	(a0)+,d1
	beq	end$
	sub	#32,d1			;Zeichen <32 werden als Space dargestellt
	bpl	hi$
	moveq	#0,d1	
hi$	cmp	d2,d1
	blt	ok$
	moveq	#0,d1			;nicht im Font enthaltene Zeichen als Space dargestellt
ok$
	moveq	#0,d3
	move.b	(a2,d1.w),d3
	add	d3,d0
	bra	loop$

nonprop$
	moveq	#-1,d0
add$
	addq	#1,d0
	tst.b	(a0)+
	bne	add$
	
	mulu	d1,d0
end$
Error$
	Pop	d1-a6
	rts
;*************************************************************************************
;*                               Objekt suchen                                       *
;*************************************************************************************
;Input:  D0 - ID des Objektes
;Output: D0 = 0 -> Fehler, sonst Adresse
FindObject:
	Push	d1-a6
	move.l	mywindowlist(A5),d1
	beq	Error$
	move.l	d1,a0
	move.l	WIL_Objects(a0),d1
Loop$
	beq	Error$
	move.l	d1,a0

	cmp	MOL_ID(a0),d0
	beq	Found$
	move.l	MOL_Next(a0),d1
	bra	Loop$
Error$
	suba.l	a0,a0
Found$
	move.l	a0,d0
	Pop	d1-a6
	tst.l	d0
	rts
;*************************************************************************************
;*                         Gadget im aktuellen Fenster suchen                        *
;*************************************************************************************
;Input:  D0 - ID des Gadgets
;Output: D0 = 0 -> Fehler, sonst Adresse
Findgadget:
	Push	d1-a6
	move	d0,d1

	lea	Datas,a5		; Data Pointer
	move.l	Winhandle(a5),d0
	beq	Error$
	move.l	d0,a0			;also aktives Gadget selbst suchen...
	move.l	wd_FirstGadget(a0),d0
loop$
	beq	Error$
	move.l	d0,a0
	cmp.w	gg_GadgetID(a0),d1
	beq	this$
	move.l	gg_NextGadget(a0),d0
	bra	loop$
this$
Error$
	Pop	d1-a6
	tst.l	d0
	rts
;*************************************************************************************
;* Fenster ffnen mit entsprechenden Settings, Images erzeugen und einzeichnen,      *
;* Gadgets erzeugen und einbinden                                                    *
;*************************************************************************************
;Input:  -
;Output: D0 = 0->ok, sonst Error
OpenWin:
	Push	All

;	ifne	Eagleplayer

		lea	Windowlist,a0
nextlist$
		move.l	(a0)+,d0
		beq	takefirst$
		move.l	(a0)+,d1		;Flags holen
		beq	thisWindowList$		;keine Flags -> also immer brauchbar
		move.l	d1,d2			;sichern

		and.l	Prefsflags(pc),d2	;mit Prefsflags ausmaskieren
		cmp.l	d1,d2			;alle Prefsflags richtig ?
		beq.l	thisWindowList$		;ja, nehmen

		bra	nextlist$
takefirst$				;nix gefunden, erstbeste Liste

;	endc
	
		lea	Windowlist,a0		;
		move.l	(a0)+,d0		;
		beq	error$			;
thisWindowList$
		move.l	d0,mywindowlist(A5)


		bsr	LockPubScreen		;Pubscreen holen
		bne	error$

;		lea	GlobalColoursNorm(pc),a0
;		move.l	Prefsflags(pc),d1
;		and.l	#PFlag_PaletteMode,d1
;		beq.s	norm$
;		lea	GlobalColoursGrey(pc),a0
;norm$
;		lea	Colourmap,a1
;		bsr	CreateColourmap		;Pens allozieren

		move.l	mywindowlist(a5),a0
		bsr	OpenWindow		;Fenster ffnen
		bne	error$

		bsr	LoadPictures		;Bilder laden
		tst.l	d0
		beq	error$

		bsr	LoadVisColor
		
		bsr	MakePenShareMap		;GGFX Pensharemap erzeugen und mit allen Images initialisieren
		tst.l	d0
		bne	error$

		move.l	mywindowlist(a5),a0
		bsr	CreateImages		;alle verwendeten Images umrechnen
		tst.l	d0
		bne	error$

		bsr	CreateGadgets		;Gadgets erzeugen
		tst.l	d0
		bne	error$

		bsr	InitPrinttextRastport	;fr Printtext Rastport vorbereiten
		bsr	InitRemoteVolRastport

		move.l	LastMenu(A5),d0
		beq	nomenu$
		move.l	d0,a1
		move.l	WinHandle(a5),a0
		IB
		CallSys	SetMenuStrip
nomenu$
		bsr	ShowBackdrops		;Hintergrundbilder einzeichnen

		bsr	HandleActiveWindow

		bsr	NewModuleEvent		;Namen eintragen, Subsonganzahl usw.

		bsr	AddGads			;Gadgets reinlinken

		bsr	UpdatePrefs		;Prefs wie Songend/Filter usw. darstellen

		bsr	InitAnalyzerBuffer	;f. Analyzer Hintergrund lschen
		bne	error$
		bsr	InitAnalyzer

		bsr	UpdateUPS

		bsr	EnableFXTask
	Pop	All
	moveq	#0,d0
	rts
error$
	bsr	CloseWin		;Cleanup im Fehlerfall
	Pop	All
	moveq	#-1,d0
	rts

*****************************************************************************
*                Rastport vorbereiten fr Printtext-Routine                 *
*****************************************************************************
InitPrinttextRastport:
	Push	All
	;----------------- Rastport Init, Mem Allozierung --------
	lea.l	TempRastport3(a5),a0
	move	#rp_SIZEOF-1,d0
clrRP$
	clr.b	(a0)+
	dbf	d0,clrRP$

	lea.l	TempRastport3(a5),a1
	GB
	CallSys	InitRastPort		;Rastport Init
	Pop	All
	rts
*****************************************************************************
*                Rastport vorbereiten fr Remotemodus Volume                *
*****************************************************************************
InitRemoteVolRastport:
	Push	All
	;----------------- Rastport Init, Mem Allozierung --------
	lea.l	TempRastport4(a5),a0
	move	#rp_SIZEOF-1,d0
clrRP$
	clr.b	(a0)+
	dbf	d0,clrRP$

	lea.l	TempRastport4(a5),a1
	GB
	CallSys	InitRastPort		;Rastport Init
	Pop	All
	rts
*****************************************************************************
*   Rastport vorbereiten fr Analyzer, Bitmap fr ECS/AGA allozieren        *
*****************************************************************************
;Input: -
;Output: D0 = 0 -> ok
InitAnalyzerBuffer:
	Push	d1-a6

	lea	FFT_TrueBuffer,a0
	move.l	#FFT_Width*FFT_Height,d0
clear$
	move.l	#AnalyzerBackColour,(a0)+
	subq.l	#1,d0
	bne	clear$
	Pop	d1-a6
	moveq	#0,d0
	rts
*****************************************************************************
* Alle Gadgets, die bisher fr das Hauptfenster erstellt wurden, einbinden  *
*****************************************************************************
AddGads:
		Push	All
		tst.b	GD_GadgetsIn(a5)
		bne.s	None$

		move.l	WinHandle(a5),d0
		beq.s	None$
		move.l	d0,a0
		move.l	GD_FirstGadget(a5),a1
		move.w	GD_Count(a5),d1
		beq.s	None$
		moveq	#-1,d0
		suba.l	a2,a2
		IB
		CallSys	AddGList

		st	GD_GadgetsIn(a5)
None$
		move.l	WinHandle(A5),a0
		IB
		CallSys	RefreshWindowFrame
		Pop	All
		rts
*****************************************************************************
*             Alle Gadgets, aus dem Hauptfenster entfernen                  *
*****************************************************************************
RemoveGads:
		Push	All
		tst.b	GD_GadgetsIn(a5)
		beq.s	None$

		move.l	WinHandle(a5),d0
		beq.s	None$
		move.l	d0,a0
		move.l	GD_FirstGadget(a5),a1
		move.w	GD_Count(a5),d0
		beq.s	None$

		IB
		CallSys	RemoveGList
None$
		sf	GD_GadgetsIn(a5)
		Pop	All
		rts
*****************************************************************************
* Alle Gadgets, die bisher fr das Hauptfenster erstellt wurden, freigeben *
****************************************************************************
FreeGadgets:
		Push	d0-a6

		move	GD_Count(a5),d6
		subq.w	#1,d6
		blt.s	end$
		move.l	GD_FirstGadget(a5),d0
loop$:		beq.s	end$
		move.l	d0,a0
		move.l	(a0),d4				;next 

		move.l	gg_UserData(a0),d2		;Image Objekt
		IB
		CallSys	DisposeObject			;Gadget freigeben

		tst.l	d2
		beq.s	noI$
		move.l	d2,a0
		CallSys	DisposeObject			;zugehriges Image freigeben

noI$:		move.l	GD_MyClass(A5),d0
		beq.s	noC$
		move.l	d0,a0
		jsr	_LVOFreeClass(a6)		;Klasse lschen
		tst.l	d0				;noch in Benutzung ?
		beq.s	noC$				;yup, weiter
		clr.l	GD_MyClass(A5)		;Klasse lschen
noC$:		move.l	d4,d0
		dbf	d6,loop$

end$:		clr	GD_Count(A5)
		clr.l	GD_FirstGadget(A5)
		clr.l	GD_PreviousGad(a5)
		Pop	d0-a6
		rts


*************************************************************************
*          Boopsi Gadgets fr das HauptFenster erstellen                *
*************************************************************************
;Input:  a0 = Windowliste
;Output: d0 = 0->ok, sonst error
CreateGadgets:
		Push	d1-a6
		clr.l	GD_FirstGadget(A5)
		clr	GD_Count(A5)
		clr.l	GD_PreviousGad(a5)

		move.l	WinHandle(A5),d0	;Fenster offen ?
		beq	ErrorinGads$

		move.l	WIL_Objects(a0),d0
		beq	ErrorinGads$

nextobject$
		move.l	d0,a0			;1. Objekt

		move	MOL_Type(a0),d1
		cmp	#GLA_Button,d1
		beq	button$
		cmp	#GLA_WinDrag,d1
		beq	button$
		cmp	#GLA_WinClose,d1
		beq	button$
		cmp	#GLA_Moused,d1
		beq	button$
		cmp	#GLA_WinDepth,d1
		bne	noButton$
	nop
button$
		bsr	MakeButton$
noButton$
		;--- hier nchste Types abarbeiten ---

		move.l	MOL_Next(a0),d0
		bne	nextobject$

		Pop	d1-a6
		moveq	#0,d0
		rts
ErrorinGads$
		bsr	FreeGadgets		;im Fehlerfall alles allozierte freigeben

		Pop	d1-a6
		moveq	#-1,d0
		rts

;--------------------------------------------------------------------------------
;Input:  A0 = Objekt
;Output: d0 = 0->ok, sonst Fehler
MakeButton$
		Push	d1-a6
		move	MOL_Left(a0),d1
		move	MOL_Top(a0),d2
		move	MOL_Width(a0),d3
		move	MOL_Height(a0),d4
		moveq	#0,d5
		move.w	MOL_ID(a0),d5		;GA_ID
		move.w	MOL_Type(a0),d6		;Typ des Gadgets (Button, WDRAG usw.)
		move.l	MOL_Flags(a0),d7	;Flags
		move.l	MOL_Images(a0),a3	;Image(s)

		bsr	GetGadget$
		beq.s	error$

		tst.w	GD_Count(A5)		;Gadget verketten
		bne.s	notfirst$
		move.l	d0,GD_FirstGadget(A5)
notfirst$
		addq	#1,GD_Count(A5)
		move.l	d0,GD_PreviousGad(A5)	;GA_Previous

		Pop	d1-a6
		moveq	#0,d0
		rts
error$		Pop	d1-a6
		moveq	#-1,d0
		rts

GetGadget$	Push	d1-a6

		lea	mytags(a5),a2
		move.l	a3,d0
		beq	noimage$

		move.l	GD_MyClass(A5),d0
		bne.s	gotit$

		lea	ClassDispatcher$(pc),a1		; pointer to dispatcher
		bsr	Initmyclass
		move.l	d0,GD_MyClass(A5)
		beq	err2$
gotit$:
		move.l	d0,a0
		lea	mytags(a5),a2

		move.l	#IA_Width,(a2)+
		clr.w	(a2)+
;		move	IML_Width(a3),d0
		move	d3,(a2)+

		move.l	#IA_Height,(a2)+
		clr.w	(a2)+
;		move	IML_Height(a3),d0
		move	d4,(a2)+

		move.l	#IA_Data,(a2)+
		move.l	a3,(A2)+

;		move.l	#SYSIA_Which,(a2)+		;Hier: 0=enabled,1=disabled
;		move.l	d7,d0
;		and.b	#1,d0
;		move.l	d0,(A2)+

		move.l	#TAG_DONE,(A2)
		lea	mytags(a5),a2
		suba.l	a1,a1
		IB
		Push	d1-d5				;just to be sure...
		jsr	_LVONewObjectA(a6)
		Pop	d1-d5
		move.l	d0,GD_LastImage(A5)	;Image sichern, falls Button nicht alloziert werden kann
		beq	err2$

		lea	mytags(a5),a2
		move.l	#GA_UserData,(A2)+
		move.l	d0,(A2)+		;zum Freigeben Imageobjekt sichern
		move.l	#GA_Image,(a2)+
		move.l	d0,(A2)+	;Image, wird zum Draw ber eigene Klasse aufgerufen
noimage$
		move.l	#GA_Left,(A2)+
		ext.l	d1
		move.l	d1,(A2)+
		move.l	#GA_Top,(A2)+
		ext.l	d2
		move.l	d2,(A2)+
		move.l	#GA_Width,(A2)+
		ext.l	d3
		move.l	d3,(A2)+
		move.l	#GA_Height,(A2)+
		ext.l	d4
		move.l	d4,(A2)+
		move.l	#GA_ID,(a2)+
		move.l	d5,(A2)+

		move.l	GD_PreviousGad(A5),d0		;erstes Gadget ?
		beq.s	skipprev$			;ja, berspringen
		move.l	#GA_Previous,(A2)+
		move.l	d0,(a2)+
skipprev$

		move.l	#GA_ToggleSelect,(A2)+		;funktioniert (noch?) nicht
		move.l	d7,d0
		and.l	#GACT_TOGGLESELECT,d0
		sne	d0
		and.l	#~1,d0
		move.l	d0,(a2)+

		move.l	#GA_Immediate,(A2)+		;Flags.3
		move.l	d7,d0
		and.l	#GACT_IMMEDIATE,d0
		sne	d0
		and.l	#~1,d0
		move.l	d0,(a2)+

		move.l	d7,d0
		and.l	#MFLG_Repeat,d0
		beq.s	.noIDCMPUpdate

		move.l	#ICA_TARGET,(a2)+
		move.l	#ICTARGET_IDCMP,(A2)+

;		move.l	#ICA_Map,(a2)+
;		move.l	#Map,(a2)+

;		move.l	#ICSPECIAL_CODE,(a2)+		;bergabe der ObjektID fr
;		move.l	#-1,(a2)+			;Abfrage des aktiven Gadgets
.noIDCMPUpdate

		move.l	#GA_RelVerify,(A2)+		;Flags.2
		move.l	d7,d0
		and.l	#GACT_RELVERIFY,d0
		sne	d0
		and.l	#~1,d0
		move.l	d0,(a2)+

		move.l	#GA_FollowMouse,(a2)+
		move.l	d7,d0
		and.l	#GACT_FOLLOWMOUSE,d0
		sne	d0
		and.l	#1,d0
		move.l	d0,(a2)+

		move.l	#GA_Disabled,(A2)+		;Flags.1
		move.l	d7,d0
		and.l	#GFLG_Disabled<<16,d0
		sne	d0
		and.l	#1,d0
		move.l	d0,(A2)+

		cmp	#GLA_WinDrag,d6
		bne	nodrag$
		move.l	#GA_SysGType,(a2)+
		move.l	#GTYP_WDRAGGING,(a2)+
nodrag$

		cmp	#GLA_WinDepth,d6
		bne	nodepth$
		move.l	#GA_SysGType,(a2)+
		move.l	#GTYP_WDEPTH,(a2)+
nodepth$

		cmp	#GLA_WinClose,d6
		bne	noclose$
		move.l	#GA_SysGType,(a2)+
		move.l	#GTYP_CLOSE,(a2)+
noclose$

		move.l	#TAG_DONE,(A2)

;		lea	frbutclass(pc),a1		;ButtonClass
		lea	butclass(pc),a1
		suba.l	a0,a0				;Privclass keine
		lea	mytags(a5),a2			;Tags
		IB
		jsr	_LVONewObjectA(a6)
		tst.l	d0				;Objekt bekommen -> OK
		bne.s	reddy$				;OK, Sprung zurck

;.... Fehlerfall

		tst.l	GD_LastImage(a5)		;Image bekommen ? (JA !, sonst landen wir nicht hier)
		beq.s	noI$
		move.l	GD_LastImage(a5),a0
		IB
		jsr	_LVODisposeObject(a6)
noI$:
		move.l	GD_MyClass(A5),d0
		beq.s	noC$
		move.l	d0,a0
		IB
		jsr	_LVOFreeClass(a6)		;Klasse freigeben (Versuch)
		tst.l	d0
		beq.s	noC$				;Klasse in Benutzung->weiter
		clr.l	GD_MyClass(A5)
noC$:		moveq	#0,d0				;Fehler !

;......
reddy$
		clr.l	GD_LastImage(a5)		;zur Sicherheit lschen
err2$:
		Pop	d1-a6
		tst.l	d0
		rts

ClassDispatcher$:
		Push	d2-d7/a2-a6		; save registers
		move.l	a0,a4			; class to a4
		move.l	a1,a3			; msg to a3
		lea	Datas,a5		; Data Pointer

		moveq	#8,d4			; Minwidth
		moveq	#8,d5			; Minheight

		cmp.l	#OM_DISPOSE,(a3)	; delete an Object ?
		bne.s	noDis$

		clr.l	ig_ImageData(a2)
		bra	default$
noDis$:
		cmp.l	#OM_GET,(a3)
		bne.s	noGet$

		cmp.l	#IA_SupportsDisable,opg_AttrID(a3)	;own Disabling routines ?
		bne	default$		;default: call SuperClass

		move.l	opg_Storage(a3),d0
		beq	default$
		move.l	d0,a0

		moveq	#1,d0			; return TRUE
		move.l	d0,(a0)
		bra	Done$
noGet$
		cmp.l	#OM_NEW,(a3)		; user want a new object ?
		bne.s	noNew$
		bsr	MakeNew
		bra	Done$
noNew$:
		cmp.l	#IM_DRAW,(A3)		;IM_DRAW,(a3)		; must we draw  ?
		bne	default$		; no!

		move.l	ig_ImageData(a2),d0	; Image vorhanden ?
		beq	Done$
		move.l	d0,a0

		moveq	#0,d0			; left = 0
		moveq	#0,d1			; top = 0
		move.w	impd_OffsetX(a3),d0	; left = x offset
		move.w	impd_OffsetY(a3),d1	; top = y offset

		GB
		move.l	impd_RPort(a3),a1	; rPort to a1

					;wenn die ersten Images inaktiv sind, diese berspringen
lo$
		move	IML_Flags(a0),d2
		and	#IMF_Inactive,d2
		beq.s	this$
		move.l	IML_Next(a0),d3
		beq	NoImg$
		move.l	d3,a0
		bra	lo$
this$
		cmp.l	#IDS_DISABLED,impd_State(a3)
		bne	nondisabled$

		tst.l	IML_Next(a0)		;is there a selected Image ?
		beq.s	NoImg$			;-> NO, out
		move.l	IML_Next(a0),a0

		tst.l	IML_Next(a0)		;is there a "disabled" Image ?
		beq.s	NoImg$			;-> NO, out
		move.l	IML_Next(a0),a0

		bra	DoUnSEL$		;show "disabled"-Image
nondisabled$
		cmp.l	#IDS_SELECTED,impd_State(a3) ; selected Image ?
		bne	DoUnSEL$		;-> unselected Image

		tst.l	IML_Next(a0)		;is there a selected Image ?
		beq.s	DoUnSEL$		;-> NO
		move.l	IML_Next(a0),a0

DoUnSEL$:
		bsr	ShowImage		;Image-Struktur und Position erforderlich, 
						;sowie Rastport oder 0 in A1
NoImg$
		moveq	#1,d0			; return TRUE
		bra.s	Done$

default$:	move.l	a4,a0			; class to a0
		move.l	a3,a1			; msg to a1
		bsr	CallSuper		; call superclass
Done$:		Pop	d2-d7/a2-a6		; restore registers
		rts

*-----------------------------------------------------------------------------*
MakeNew:	
		UB
		move.l	#IA_Data,d0		; the tag we want
		moveq	#0,d1			; default = NULL
		move.l	ops_AttrList(a3),a0	; tags to a0
		jsr	_LVOGetTagData(A6)	; look for the tag
		move.l	d0,d5			; Image or Null

		move.l	#IA_Width,d0		; the tag we want
		moveq	#0,d1			; default = NULL
		move.l	ops_AttrList(a3),a0	; tags to a0
		jsr	_LVOGetTagData(A6)	; look for the tag
		move.l	d0,d6			; Image or Null

		move.l	#IA_Height,d0		; the tag we want
		moveq	#0,d1			; default = NULL
		move.l	ops_AttrList(a3),a0	; tags to a0
		jsr	_LVOGetTagData(A6)	; look for the tag
		move	d0,d7

;		move.l	#SYSIA_Which,d0		;Tag to be found
;		moveq	#0,d1			;default Return value
;		move.l	ops_AttrList(a3),a0	;Taglist
;		jsr	_LVOGetTagData(A6)	;Utility-LibCall
;		move	d0,d5

		move.l	a4,a0			;class to a0
		move.l	a3,a1			;msg to a1
		Push	d5-d7
		bsr	CallSuper		;call the superclass
		Pop	d5-d7
		move.l	d0,a0			;put object in a0
		tst.l	d0
		beq.s	.newErrorO		;failed!!!
		move.l	d5,ig_ImageData(a0)	;set Image(s)

		move.w	d6,ig_Width(a0)		;set width
		move.w	d7,ig_Height(a0)	;set height
;		move.b	d5,ig_PlanePick(A0)	;set Type
		bra	Done$			;return Object
.newErrorO:	moveq	#0,d0			; 0 for error
Done$:		rts
;		Pop	d2-d7/a2-a6		; restore registers
;		rts

*--------------------- Call Superclass ---------------------------------*
CallSuper:	Push	a2			; save a2
		move.l	cl_Super(a0),a0		; get superclass in a0
		pea.l	ourRet			; Push return address
		move.l	h_Entry(a0),-(sp)	; Push superclass dispatcher
		rts				; jump to super dispatcher
ourRet:		Pop	a2			; restore a2
		rts

*----------------------------------------------------------------------------*
* --- Initialize our private class. It set's up a class
* --- with "imageclass" as superclass.
Initmyclass:	Push	d1-d6/a0/a1/a2/a6	; save registers
		move.l	a1,d6

		IB
		suba.l	a0,a0			; class ID
		lea	imgclass(pc),a1		; points to "imageclass"
		suba.l	a2,a2			; no superclass pointer
		moveq	#0,d0			; 12 bytes instance data (MCP&UHack Sysipatches)
		moveq	#0,d1			; no flags
		CallSys	MakeClass		; make the class
		move.l	d0,a0			; put class in a0
		tst.l	d0
		beq.s	.noClass		; failed!!!
		move.l	d6,h_Entry(a0)		; set our dispatcher
.noClass:	Pop	d1-d6/a0/a1/a2/a6	; restore registers
		rts
;*************************************************************************************
;*                   Fenster schlieen, alles freigeben                              *
;*************************************************************************************
;Input:  -
;Output: -
CloseWin:
	bsr	GetConfig
	bsr	DisableFXTask

	bsr	RemoveGads		;Gadgets entfernen

	bsr	FreeGadgets		;und freigeben

	bsr	ClosemyWindow		;dann Fenster dichtmachen

	bsr	FreeImages		;dann Images freigeben

	bsr	FreePictures

	bsr	FreePenShareMap		;GGFX Pensharemap freigeben 

;	lea	Colourmap,a1
;	bsr	FreeColourmap		;allozierte Farben zurckgeben

	bsr	UnlockPubScreen		;Screen freigeben

	clr.l	mywindowlist(a5)
	rts

;--------------------------- Bilder einzeichnen ----------------------------------
;Input: d0 = XPos.w
;       d1 = YPos.w
;       a0 = ImageStruktur (IML_...)
;	a1 = Rastport (Ziel) oder 0, dann default (vom Fenster verwendet)
;Output: - (im Fehlerfall, z.B. kein Fenster offen, falsches Bitmapformat, wird Aufruf ignoriert)
ShowImage:
	Push	All

	ifne	FXTask

	ifne	Semaphore
	Push	d0/d1/a0/a1
	lea	Image_Semaphore(a5),a0
	EB
	CallSys	ObtainSemaphore
	Pop	d0/d1/a0/a1
	endc

	endc

	move.l	a1,d2
	bne.s	set$

	move.l	WinHandle(A5),d2
	beq	error$
	move.l	d2,a1
	move.l	wd_RPort(a1),a1			;Rastport (Ziel)
set$
	cmp	#5,IML_Type(a0)			;24 Bit Chunky-Images mit ggfx, dann IML_ColourMap
						;== DDrawHandle
	beq	Chunky24$

	cmp	#2,IML_Type(a0)			;8 Bit Chunky-Images mit WPA8
	beq	Chunky$
	cmp	#3,IML_Type(a0)			;8 Bit Chunky-Images mit WPA8
	beq	Chunky$

	;-------------------- Bitmap kopieren ------------------------------
	move.l	IML_Rendered(a0),d7
	beq	error$

	move	d0,d2				;Leftedge
	move	d1,d3				;Topedge

	moveq	#0,d0				;XPos in Quelle
	moveq	#0,d1				;YPos in Quelle

	move	IML_Width(a0),d4		;Breite
	move	IML_Height(a0),d5		;Hhe

	move.l	d7,a0

	move.b	#$c0,d6		;Miniterm

	GB
	CallSys	BltBitMapRastPort
	bra	ok$
Chunky$
	;-------------------- 8 Bit Chunky kopieren --------------------------

	move.l	IML_Rendered(a0),d7
	beq	error$
	move.l	d7,a2				;Array

;	move	IML_Width(a0),d2
;	move	IML_Height(a0),d3
;	add	d0,d2				;Xstart+Width=XStop
;	add	d1,d3				;Ystart+Height=YStop
;	subq	#1,d2
;	subq	#1,d3

;	move.l	a1,a0				;Rastport (Ziel)
;	lea.l	TempRastport5(a5),a1		;TempRP
;	GB
;	CallSys	WritePixelArray8
	bra	ok$
Chunky24$
	;---------------- 24 Bit 0RGB Chunky kopieren ----------------------
	ifne	FXTask
	ifeq	Semaphore
		Push	All
		EB
		CallSys	Forbid
		Pop	All
	endc
	endc

		move.l	guigfx(a5),a6
		move.l	IML_ColourMap(a0),d7	;ddh fr Truecolour Images
		beq	ok$
		move.l	IML_Data(a0),a1		;Buffer
		move.l	d7,a0			;ddh
		suba.l	a2,a2
		CallSys	DirectDrawTrueColorA	;DirectDrawTrueColorA(ddh,array,x,y,tags)(a0,a1,d0,d1,a2)

	ifne	FXTask
	ifeq	Semaphore
		Push	All
		EB
		CallSys	Permit
		Pop	All
	endc
	endc
ok$
error$

	ifne	FXTask
	ifne	Semaphore
		lea	Image_Semaphore(a5),a0
		EB
		CallSys	ReleaseSemaphore
	endc
	endc

	Pop	All
	rts
;*************************************************************************************
;*                      genau 1 Zeichen printen                                      *
;*************************************************************************************
;Input:  D0 - Char
;        D1 - XPosition
;        A1 - struct *Objekt
;Output: D0 = 0 -> Fehler, sonst Breite des Zeichens
PrintChar:
	Push	d1-a6
	move.l	MOL_Images(a1),d2
	beq	error$
	move.l	d2,a0
	move.l	IML_Rendered(a0),d2
	beq	error$
	move.l	d2,TempRastport3+rp_BitMap(a5)


	move.l	MOL_UserData(a1),d3	;Font eingetragen ?
	beq	error$
	move.l	d3,a1			;Fontobjekt

	moveq	#0,d6			;YPos
	
	move.l	MOL_CMDArg2(a1),d7	;nominale Breite von fixedfonts
	beq.s	noextratab$
	move.l	d7,a2			;Positionen der einzelnen Zeichen

	move	MOL_UserData+2(a1),d7	;Breite pro Zeichen

	and	#$ff,d0
	sub	#32,d0			;Zeichen <32 werden als Space dargestellt
	bpl	hi$
	moveq	#0,d0
hi$
	lsl	#2,d0			;2 Worte pro Char

	move	(a2,d0.w),d4		;XPos Quelle
	move	2(a2,d0.w),d6		;YPos Quelle

	move.l	MOL_CMDArg1(a1),d3	;Propinfo ?
	beq	nonprop2$
	move.l	d3,a2			;Byteweise Breiten der einzelnen Zeichen

	move.b	(a2,d0.w),d7		;Propinfo->Char
nonprop2$
	bra	nonprop$
noextratab$
	move	MOL_UserData+2(a1),d7	;Breite pro Zeichen
	moveq	#0,d2
	move	MOL_Width(a1),d2
	divu	d7,d2			;Anzahl der Zeichen

	and	#$ff,d0
	sub	#32,d0			;Zeichen <32 werden als Space dargestellt
	bpl	hi1$
	moveq	#0,d0
hi1$	cmp	d2,d0
	blt	ok$
	moveq	#0,d0			;nicht im Font enthaltene Zeichen als Space dargestellt
ok$
	move	d0,d4			;Zeichen nummer im Font
	mulu	d7,d4			;mal nominale Breite = XPos in Quelle

	move.l	MOL_CMDArg1(a1),d3	;Propinfo ?
	beq	nonprop$
	move.l	d3,a2			;Byteweise Breiten der einzelnen Zeichen

	move.b	(a2,d0.w),d7		;Propinfo->Char
nonprop$
	move.l	MOL_Images(a1),d2
	beq	error$
	move.l	d2,a1

	btst	#0,d1			;ungerade X-Position ?
	beq	noimpair$
					;ja, also alternatives Image fr diesen Fall suchen,
					;wegen Rasteranpassung

	tst.l	IML_Next(a1)		;kein alternatives Image angeboten -> normal weiter
	beq	noimpair$
	move.l	IML_Next(a1),a1
noimpair$
	move.l	IML_Rendered(a1),d2
	beq	error$
	move	IML_Height(a0),d5		;Hhe Zielmap (sollte IMMER = Hhe Quellmap sein)

	move.l	d2,a0				;Bitmap (Quelle)

	move	d4,d0				;Xpos in Quelle
	move	d1,d2				;XPos in Ziel

	move.w	d6,d1				;YPos in Quelle
	moveq	#0,d3				;YPos in Ziel

	move	d7,d4				;Breite dieses Zeichens
;	move	IML_Height(a1),d5		;Hhe

	lea	TempRastport3(a5),a1		;Rastport (Ziel)
	move.b	#$c0,d6				;Miniterm

	GB
	CallSys	BltBitMapRastPort

	moveq	#0,d0
	move	d7,d0
	Pop	d1-a6
	rts
error$
	moveq	#0,d0
	Pop	d1-a6
	rts


;--------------------- Hintergrundbilder einzeichnen -------------------------------
;Input:  a0 = Windowliste
;Output: -
ShowBackdrops:
	Push	All
	move.l	WIL_Objects(a0),d0
	beq	error$

nextobject$
	move.l	d0,a3			;Objekt

	cmp	#ID_Backdrop,MOL_ID(a3)
	bne	nobackdrop$

	move.l	MOL_Images(a3),d2
	beq	nobackdrop$
	move.l	d2,a0

	move	MOL_Left(a3),d0
	move	MOL_Top(a3),d1
	suba.l	a1,a1
	bsr	ShowImage		;Image-Struktur und Position erforderlich

nobackdrop$
	move.l	MOL_Next(A3),d0
	bne	nextobject$

error$
	Pop	All
	rts
;
;----------------------- Fenster ffnen --------------------------------------------
;Input:  a0 = Windowliste
;Output: d0 = 0->ok, sonst error
;
OpenWindow:
	Push	d1-a6
	move.l	a0,a4

	lea	mytags(a5),a1

	;definierte Werte
	ifeq	Eagleplayer
		move.l	#WA_Left,(a1)+
		moveq	#0,d0
		move	WIL_LeftEdge(a4),d0
		move.l	d0,(a1)+

		move.l	#WA_Top,(a1)+
		move	WIL_TopEdge(a4),d0
		move.l	d0,(a1)+
	else
		move.l	#WA_Left,(a1)+
		moveq	#0,d0
		move	EUS_Structure+EUS_WinX(pc),d0
		move.l	d0,(a1)+

		move.l	#WA_Top,(a1)+
		move	EUS_Structure+EUS_WinY(pc),d0
		move.l	d0,(a1)+
	endc

	move.l	#WA_InnerWidth,(a1)+
	move	WIL_Width(a4),d0
	move.l	d0,(a1)+

	move.l	#WA_InnerHeight,(a1)+
	move	WIL_Height(a4),d0
	move.l	d0,(a1)+

	move.l	#WA_Flags,(a1)+
	move.l	WIL_Flags(A4),(a1)+

	move.l	#WA_IDCMP,(a1)+
	move.l	WIL_IDCMP(A4),(a1)+

	;misc
	move.l	#WA_PubScreen,(a1)+	;der Pubscreen sollte garantiert keinen Fehler
	move.l	mypubscreen(a5),(a1)+	;erzeugen, da der Lock noch besteht
	
	move.l	#WA_NewLookMenus,(a1)+
	move.l	#1,(a1)+

	move.l	#WA_AutoAdjust,(a1)+	;wegen der automatischen Positionsverschiebung
	move.l	#1,(a1)+

	move.l	myScreentitle(a5),d0
	beq.s	notitle$
	move.l	#WA_ScreenTitle,(a1)+
	move.l	d0,(a1)+		;wird ausgehend vom EP neu gesetzt
notitle$

	;WA_Title gibts nicht wegen Borderless

	clr.l	(a1)
	lea	mytags(A5),a1

	suba.l	a0,a0
	IB
	CallSys	OpenWindowTagList
	move.l	d0,WinHandle(a5)
	beq	error$

	Pop	d1-a6
	moveq	#0,d0
	rts
error$
	Pop	d1-a6
	moveq	#-1,d0
	rts
;
;--------------------- Fenster schlieen -------------------------------------------
;Input:  -
;Output: -
;
ClosemyWindow:
	Push	All
	move.l	WinHandle(A5),d0
	beq	ok$

	move.l	d0,a0

	move.l	wd_MenuStrip(A0),LastMenu(A5)

	IB
	CallSys	ClearMenuStrip

	move.l	WinHandle(A5),a0
	CallSys	CloseWindow

	clr.l	WinHandle(A5)
ok$
	Pop	All
	rts
;-------------------------- Viscolor.txt laden und Farben in Liste eintragen -----------------
LoadVisColor:
	Push	All

	lea	Viscolorfile,a0
	bsr	LoadFile
	tst.l	d0
	beq	fail$
	move.l	GPIC_Picture(a0),a0			;Adresse

	lea	FFT_Colours,a1
	moveq	#23-1,d1				;Anzahl Eintrge
all$
	clr.b	(a1)+
	bsr	getcolours
	beq	fail$

	dbf	d1,all$
fail$
	Pop	All
	rts
;RGB auslesen
getcolours:
	Push	d1-d7/a2-a6

	bsr	getnumber
	beq	fail$
	move.b	d3,(a1)+
	bsr	getnumber
	beq	fail$
	move.b	d3,(a1)+
	bsr	getnumber
	beq	fail$
	move.b	d3,(a1)+
	bsr	newline
	beq	fail$

	Pop	d1-d7/a2-a6
	moveq	#1,d2
	rts
fail$
	Pop	d1-d7/a2-a6
	moveq	#0,d2
	rts


getnumber:
next$
	moveq	#0,d2
	move.b	(a0)+,d2				;Zeichen holen
	subq	#1,d0
	ble	failget$

	cmp.b	#` `,d2
	beq	next$
	cmp.b	#`,`,d2
	beq	next$

	sub	#`0`,d2
	bmi	failget$				;1. Zeichen sollte schon eine Zahl sein, wenn nicht->weitersuchen
	cmp	#9,d2
	bhi	failget$

	move.w	d2,d3

	move.b	(a0)+,d2				;2. Zeichen holen
	subq	#1,d0
	ble	failget$

	sub	#`0`,d2
	bmi	end1$
	cmp	#9,d2
	bhi	end1$

	mulu	#10,d3
	add.w	d2,d3

	move.b	(a0)+,d2				;3. Zeichen holen
	subq	#1,d0
	ble	failget$

	sub	#`0`,d2
	bmi	end1$
	cmp	#9,d2
	bhi	end1$

	mulu	#10,d3
	add.w	d2,d3
end1$
	rts
failget$
	moveq	#0,d3
	rts

newline:					;sucht nach $0a = Newline
such$
	move.b	(a0)+,d2
	subq	#1,d0
	ble	fail$

	cmp.b	#10,d2
	bne	such$

	moveq	#1,d2
	rts
fail$
	moveq	#0,d2
	rts

;eingestellten und default Pfad nach Bildern durchsuchen
LoadFile:
	Push	d1-a6

	;1. im eingestellten Pfad suchen
		lea	picturepath(a5),a1
		bsr	setFilepath			;Pfad setzen und Bild laden
		tst.l	d0
		bne	ok$

	;2. im default-Pfad suchen

	ifne	Eagleplayer				;Engines-Dir an Pfad anhngen
		move.l	EUS_Structure+EUS_EPBase(pc),a1
		move.l	EPG_EngineDirArrayPtr(a1),d1
		beq.s	NoConfigDir$			;Fehler
		move.l	d1,a1
	else
		lea	Enginedir,a1
	endc
		lea	defaultpath(a5),a2
copy1$		move.b	(a1)+,(a2)+
		bne.s	copy1$
		subq.l	#1,a2
		cmp.b	#`/`,-1(a2)
		beq.s	noback$
		move.b	#`/`,(a2)+
noback$
		lea	picdefaultdir,a1		;skins/base an Pfad anhngen
copy2$
		move.b	(a1)+,(a2)+
		bne.s	copy2$

		lea	defaultpath(a5),a1
		bsr	setFilepath			;Pfad setzen und Bild laden
		bne	ok$
NoConfigDir$
		moveq	#0,d0
ok$
		Pop	d1-a6
		tst.l	d0
		rts
;Dir Lock
setFilepath:
		Push	d1-a6
		move.l	a0,a4				;a0 sichern

		move.l	a1,d1
		moveq	#ACCESS_READ,d2
		DB
		CallSys	Lock
		move.l	d0,d7
		beq	faillock$
		move.l	d0,d1
		CallSys	CurrentDir
		move.l	d0,d6

;		lea	picextensions(pc),a3		;wird modifiziert
loadloop$
		move.l	GPIC_Name(a4),a0
		bsr	openFile
		move.l	d0,d5
		bne.w	gotpic$

;		tst.b	(a3)				;Ende der extensions Liste
;		bne.s	loadloop$			;
gotpic$
		move.l	d6,d1
		DB
		CallSys	CurrentDir
		move.l	d7,d1
		CallSys	UnLock

		move.l	d5,d0
faillock$
		Pop	d1-a6
		tst.l	d0
		rts
;Datei laden
openFile:
		Push	d1-a2/a4-a6
		lea	Picturename(a5),a1
		move.l	a1,d1
copy1$
		move.b	(a0)+,(a1)+
		bne	copy1$

;		subq.l	#1,a1				;mehrere Extensions probieren
;copy2$
;		move.b	(a3)+,(a1)+
;		bne.s	copy2$

		move.l	#MODE_Oldfile,d2		;MODE_NEWFILE
		DB
		CallSys	Open
		move.l	d0,d6
		beq.s	fail$

		move.l	d0,d1				;Handle
		move.l	GPIC_Picture(a4),d2		;Adr
		moveq	#0,d3
		move.w	GPIC_Minsizex(a4),d3		;max. len
		jsr	_LVOread(a6)
		move.l	d0,d7

		move.l	d6,d1
		jsr	_LVOclose(a6)

		move.l	d7,d0
fail$
		Pop	d1-a2/a4-a6
		tst.l	d0
		rts
;--------------------------- alle Bilder freigeben ---------------------------------------
FreePictures:
	Push	All

	lea	PictureList,a4
	move.l	a4,d0
loop$
	move.l	d0,a4
	
	move.l	GPIC_Picture(a4),d0
	beq	none$
	clr.l	GPIC_Picture(a4)

	move.l	d0,a0
	move.l	guigfx(A5),a6
	CallSys	DeletePicture
none$
	move.l	GPIC_Next(a4),d0
	bne	loop$

	Pop	All
	rts
;------------------------------ alle Bilder laden ----------------------------------------
;Input: -
;Output: D0 = 0 -> Fehler
;        D0 = 1 -> ok
LoadPictures:
	Push	d1-a6
	
	lea	PictureList,a0
	move.l	a0,d0
loop$
	move.l	d0,a0
	tst.l	GPIC_Picture(a0)		;Bild bereits geladen ?
	bne.s	next$				;ja, weiter

	bsr	LoadPicture			;Bild laden
	move.l	d0,GPIC_Picture(a0)		;und abspeichern
	beq	fail$				;Fehler -> raus
next$
	move.l	GPIC_Next(a0),d0		;nchstes Bild
	bne	loop$

	Pop	d1-a6
	moveq	#1,d0				;ok
	rts
fail$
	lea	txt_nofiles(pc),a0
	bsr	MERROR

	Pop	d1-a6
	moveq	#0,d0				;ok
	rts


;eingestellten und default Pfad nach Bildern durchsuchen
LoadPicture:
	Push	d1-a6

	;1. im eingestellten Pfad suchen
		lea	picturepath(a5),a1
		bsr	setloadpath			;Pfad setzen und Bild laden
		tst.l	d0
		bne	ok$

	;2. im default-Pfad suchen

	ifne	Eagleplayer				;Engines-Dir an Pfad anhngen
		move.l	EUS_Structure+EUS_EPBase(pc),a1
		move.l	EPG_EngineDirArrayPtr(a1),d1
		beq.s	NoConfigDir$			;Fehler
		move.l	d1,a1
	else
		lea	Enginedir,a1
	endc
		lea	defaultpath(a5),a2
copy1$		move.b	(a1)+,(a2)+
		bne.s	copy1$
		subq.l	#1,a2
		cmp.b	#`/`,-1(a2)
		beq.s	noback$
		move.b	#`/`,(a2)+
noback$
		lea	picdefaultdir,a1		;skins/base an Pfad anhngen
copy2$
		move.b	(a1)+,(a2)+
		bne.s	copy2$

		lea	defaultpath(a5),a1
		bsr	setloadpath			;Pfad setzen und Bild laden
		bne	ok$
NoConfigDir$
		moveq	#0,d0
ok$
		Pop	d1-a6
		tst.l	d0
		rts

;Dir Lock
setloadpath:
		Push	d1-a6
		move.l	a0,a4				;a0 sichern

		move.l	a1,d1
		moveq	#ACCESS_READ,d2
		DB
		CallSys	Lock
		move.l	d0,d7
		beq	faillock$
		move.l	d0,d1
		CallSys	CurrentDir
		move.l	d0,d6

		lea	picextensions,a3		;wird modifiziert
loadloop$
		move.l	GPIC_Name(a4),a0
		bsr	openpic
		move.l	d0,d5
		bne.s	gotpic$

		tst.b	(a3)				;Ende der extensions Liste
		bne.s	loadloop$
gotpic$
		move.l	d6,d1
		DB
		CallSys	CurrentDir
		move.l	d7,d1
		CallSys	UnLock

		move.l	d5,d0
faillock$
		Pop	d1-a6
		tst.l	d0
		rts
;Bild laden
openpic:
		Push	d1-a2/a4-a6
		lea	Picturename(a5),a1
copy1$
		move.b	(a0)+,(a1)+
		bne	copy1$
		subq.l	#1,a1
copy2$
		move.b	(a3)+,(a1)+
		bne.s	copy2$

		lea	Picturename(a5),a0
		lea	MyTags(A5),a1
		clr.l	(a1)
		move.l	guigfx(A5),a6
		CallSys	LoadPictureA
		Pop	d1-a2/a4-a6
		tst.l	d0
		rts
;--- Guigfx Pensharemap und Drawhandle erzeugen und mit allen Images initialisieren -----
;Input:  Bereich von START_IMAGES bis END_IMAGES, siehe auch dort
;Output: D0 = 0->ok, sonst error
MakePenShareMap:
	push	d1-a6
	move.l	winhandle(a5),d0		;Fenster geffnet ?
	beq	error$
	tst.l	drawhandle(a5)			;DrawHandle bereits vorhanden ?
	bne	ok$

	move.l	guigfx(A5),a6

	lea	mytags(a5),a0

	ifne	ggfxdefaults
		move.l	#GGFX_HSType,(a0)+
		move.l	#HSTYPE_12BIT_TURBO,(a0)+
	endc

	move.l	#TAG_DONE,(a0)+
	lea	mytags(a5),a0
	CallSys	CreatePenShareMapA		;PenShareMap erzeugen
	move.l	d0,psm(a5)			;
	beq	error$

	;Pensharemap init mit eventuell noch vorhandenen internen Images
	lea	START_IMAGES,a4
PSM_Loop$
	cmp	#4,IML_Type(a4)
	bne	noRGB32$

	move.l	IML_Data(A4),a1		;Array
	move	IML_Width(A4),d0	;Breite
	move	IML_Height(a4),d1	;Hhe

	lea	mytags(A5),a2
	move.l	#GGFX_PixelFormat,(a2)+
	move.l	#PIXFMT_0RGB_32,(a2)+
	move.l	#TAG_DONE,(A2)+
	lea	mytags(A5),a2

	move.l	psm(a5),a0
	CallSys	AddPixelArrayA
	bra	next$
noRGB32$
	cmp	#0,IML_Type(A4)		;Chunky 8 Bit ?
	bne	noChunky$
	move.l	IML_ColourMap(a4),d0	;Farbtabelle ?
	beq	noChunky$
	move.l	d0,a1

	lea	mytags(A5),a2
	move.l	#GGFX_PixelFormat,(a2)+
	move.l	#PIXFMT_CHUNKY_CLUT,(a2)+
	move.l	#GGFX_NumColors,(a2)+
	moveq	#0,d0
	move	(a1)+,d0
	move.l	d0,(a2)+
	move.l	#GGFX_Palette,(a2)+
	move.l	a1,(a2)+
	move.l	#TAG_DONE,(A2)+
	lea	mytags(A5),a2

	move.l	IML_Data(A4),a1		;Array
	move	IML_Width(A4),d0	;Breite
	move	IML_Height(a4),d1	;Hhe
	move.l	psm(a5),a0
	CallSys	AddPixelArrayA
noChunky$
	cmp	#7,IML_Type(a4)		;lediglich Palette ?
	bne	nopalette$

	move.l	IML_ColourMap(a4),d0	;Farbtabelle ?
	beq	nopalette$
	move.l	d0,a1

	lea	mytags(A5),a2
	move.l	#GGFX_NumColors,(a2)+
	moveq	#0,d0
	move	(a1)+,d0		;1. Wort = Anzahl Farben
	move.l	d0,(a2)+
	move.l	#TAG_DONE,(A2)+
	lea	mytags(A5),a2

	move.l	psm(a5),a0
	CallSys	AddPaletteA
nopalette$
next$
	add.l	#IML_Sizeof,a4
	cmpa.l	#END_IMAGES,a4
	blt	PSM_Loop$

	;Pensharemap init mit geladenen Bildern
	lea	PictureList,a4
	move.l	a4,d0
picloop$
	move.l	d0,a4
	tst.l	GPIC_Picture(a4)		;Bild bereits geladen ?
	beq.s	nextpic$			;ja, weiter

	lea	mytags(A5),a2
	move.l	#TAG_DONE,(A2)

	move.l	GPIC_Picture(a4),a1
	move.l	psm(a5),a0
	CallSys	AddPictureA
nextpic$
	move.l	GPIC_Next(a4),d0		;nchstes Bild
	bne	picloop$

	;Drawhandle allozieren
	
	move.l	mypubscreen(a5),a0
	lea.l	sc_ViewPort(a0),a0		;Viewport->Colormap
	move.l	Gfx_base(a5),a6
	CallSys	GetVPModeID

	move.l	psm(a5),a0				;Pensharemap
	move.l	mypubscreen(a5),a1
	move.l	sc_ViewPort+vp_ColorMap(a1),a2	;Viewport->Colormap

	move.l	winhandle(a5),a1
	move.l	wd_RPort(a1),a1			;Rastport des Screens

	lea	mytags(a5),a3
	move.l	#GGFX_ModeID,(a3)+
	move.l	d0,(a3)+

	ifeq	ggfxdefaults
		move.l	#GGFX_DitherThreshold,(a3)+
		move.l	#60,(a3)+
		move.l	#GGFX_DitherMode,(A3)+
		move.l	#DITHERMODE_EDD,(a3)+
	endc

	move.l	Prefsflags(pc),d1
	and.l	#PFlag_PaletteMode,d1
	beq.s	norm$
	move.l	#OBP_Precision,(a3)+
	move.l	#PRECISION_EXACT,(a3)+
norm$
	move.l	#TAG_DONE,(a3)+
	lea	mytags(a5),a3

	move.l	guigfx(A5),a6
	CallSys	ObtainDrawHandleA
	move.l	d0,drawhandle(a5)
	beq	error$
ok$
	pop	d1-a6
	moveq	#0,d0
	rts
error$
	pop	d1-a6
	lea	txt_nomem(pc),a0
	bsr	MERROR

	moveq	#-1,d0
	rts

;-------------------------- Guigfx Pensharemap freigeben ---------------------------
FreePenShareMap:
	push	d1-a6
	move.l	guigfx(A5),a6

	move.l	drawhandle(A5),d0
	beq	nodraw$
	move.l	d0,a0
	CallSys	ReleaseDrawHandle
nodraw$

	move.l	psm(a5),d0
	beq	nopsm$
	move.l	d0,a0
	CallSys	DeletePenShareMap
nopsm$
	clr.l	drawhandle(A5)
	clr.l	psm(a5)
	pop	d1-a6
	tst.l	d0
	rts
;
;----------------------- Images umrechnen --------------------------------------
;Input:  a0 = Windowliste
;Output: d0 = 0->ok, sonst error
;
CreateImages:
	Push	d1-a6
	move.l	guigfx(A5),a6

	move.l	drawhandle(A5),d0
	beq	error$

	move.l	WIL_Objects(a0),d0
	beq	error$
	move.l	A0,CI_UsedWindowList(A5)

nextobject$
	move.l	d0,a3			;Objekt
	move.l	MOL_Images(a3),d0	;Image Struktur vorhanden ?
	beq	noimage$		;nein, nchstes Objekt

nextimage$
	move.l	d0,a0			;1. Image Struktur
	bsr	MakeImage		;Image umrechnen
	bne	error$
	move.l	IML_Next(a0),d0		;weitere Images ?
	bne	nextimage$		;ja, auch diese bearbeiten

noimage$
	move.l	MOL_Next(A3),d0
	bne	nextobject$

	Pop	d1-a6
	moveq	#0,d0
	rts
error$
	bsr	FreeImages

	lea	txt_nomem(pc),a0
	bsr	MERROR

	Pop	d1-a6
	moveq	#-1,d0
	rts
;
;----------------------- berechnete Images freigeben ----------------------------
;Input:  -
;Output: -
;
FreeImages:
	Push	All

	lea	Windowlist(pc),a0	;alle Windows durchgehen, um Images freizugeben
loop$
	move.l	(a0),d0
	beq	error$
	Push	a0
	move.l	d0,a0
	bsr	freelist$
	Pop	a0
	addq.l	#8,a0
	bra	loop$
error$
	clr.l	CI_UsedWindowList(a5)
	Pop	All
	rts

freelist$
	move.l	WIL_Objects(a0),d0
	beq	end$

nextobject$
	move.l	d0,a3			;Objekt
	move.l	MOL_Images(a3),d0	;Image Struktur vorhanden ?
	beq	noimage$		;nein, nchstes Objekt

nextimage$
	move.l	d0,a0			;1. Image Struktur
	bsr	FreeImage$		;Image umrechnen

	move.l	IML_Next(a0),d0		;weitere Images ?
	bne	nextimage$		;ja, auch diese bearbeiten

noimage$
	move.l	MOL_Next(A3),d0
	bne	nextobject$
end$
	rts

FreeImage$
	Push	All
	cmp	#5,IML_Type(a0)
	beq	Chunky24$

	move.l	IML_Rendered(A0),d0
	beq	norender$
	clr.l	IML_Rendered(A0)

	cmp	#2,IML_Type(a0)
	beq	Chunky$
	cmp	#3,IML_Type(a0)
	beq	Chunky$

	move.l	d0,a0
	GB
	CallSys	FreeBitMap
	bra.s	norender$
Chunky$
	move.l	d0,a1

	move	IML_Width(a0),d0
	mulu	IML_Height(a0),d0
	EB
	CallSys	FreeMem
	bra.s	norender$
Chunky24$
	move.l	IML_ColourMap(a0),d0
	beq	norender$
	clr.l	IML_ColourMap(a0)
	move.l	d0,a0
	move.l	guigfx(a5),a6
	CallSys	DeleteDirectDrawHandle
norender$
	Pop	All
	rts
;
;--------------------------- ein Image berechnen -------------------------------
;Input:  a0 = Image-Struktur
;Output: d0 = 0->ok, sonst error
;
MakeImage:
	Push	d1-a6
	tst.l	IML_Rendered(a0)	;Image bereits gerendert ?
	bne	ok$			;ok -> raus
	move.l	a0,a4		;sichern


	cmp	#6,IML_Type(a4)		;Image aus geladenem Bild ausschneiden ?
	bne	nocutpic$

	;1. Bild suchen
	move	IML_SourcePic(a4),d0
	lea	Picturelist(pc),a0
	move.l	a0,d1
picsuchloop$
	move.l	d1,a0

	cmp	GPIC_ID(a0),d0
	beq	thispic$
	move.l	GPIC_Next(a0),d1
	bne	picsuchloop$
	bra	fail$
thispic$
	move.l	GPIC_Picture(a0),d0	;Bild geladen
	beq	fail$
	move.l	d0,a1			;Picture
	
	move.l	guigfx(A5),a6
	move.l	drawhandle(a5),a0	;drawhandle

	lea	mytags(A5),a2		;tags
	moveq	#0,d0
	move.l	#GGFX_DestWidth,(A2)+
	move	IML_Width(a4),d0
	move.l	d0,(a2)+
	move.l	#GGFX_Destheight,(A2)+
	move	IML_Height(a4),d0
	move.l	d0,(a2)+
	move.l	#GGFX_SourceX,(a2)+
	move	IML_SourceX(a4),d0
	move.l	d0,(a2)+
	move.l	#GGFX_SourceY,(a2)+
	move	IML_SourceY(a4),d0
	move.l	d0,(a2)+
	move.l	#GGFX_SourceWidth,(a2)+
	move.w	IML_SourceWidth(a4),d0
	move.l	d0,(a2)+
	move.l	#GGFX_SourceHeight,(a2)+
	move.w	IML_SourceHeight(a4),d0
	move.l	d0,(a2)+
	move.l	#TAG_DONE,(a2)
	lea	mytags(A5),a2		;tags

	CallSys	CreatePictureBitMapA
	move.l	d0,IML_Rendered(a4)
	bra	converted$
nocutpic$
	cmp	#5,IML_Type(a4)
	bne	notruedirect$

	tst.l	IML_ColourMap(a4)	;ddrawhandle vorhanden ?
	bne	ok$			;ok -> raus

	move.l	drawhandle(a5),a0	;drawhandle
	suba.l	a1,a1			;Tags
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	IML_SourceWidth(A4),d0	;Source Width
	move.w	IML_SourceHeight(A4),d1	;Source Height
	move.w	IML_Width(A4),d2
	move.w	IML_Height(A4),d3

	move.l	guigfx(A5),a6
	CallSys	CreateDirectDrawHandleA
	move.l	d0,IML_ColourMap(a4)
	beq	fail$
	bra	ok$
notruedirect$
	cmp	#4,IML_Type(a4)
	bne	noTrue$

	move.l	IML_Data(A4),a0		;Array
	move	IML_Width(A4),d0	;Breite
	move	IML_Height(A4),d1	;Hhe

	lea	mytags(A5),a1
	move.l	#GGFX_PixelFormat,(a1)+
	move.l	#PIXFMT_0RGB_32,(a1)+
	move.l	#TAG_DONE,(a1)+
	lea	mytags(A5),a1

	move.l	guigfx(A5),a6
	CallSys	MakePictureA
	move.l	d0,d7
	beq	fail$
	bra	makepic$
noTrue$
	cmp	#0,IML_Type(A4)
	bne	ok$

	lea	mytags(A5),a2
	move.l	#GGFX_PixelFormat,(a2)+
	move.l	#PIXFMT_CHUNKY_CLUT,(a2)+

	move.l	IML_ColourMap(a4),d0	;Farbtabelle ?
	beq	no$
	move.l	d0,a1

	move.l	#GGFX_NumColors,(a2)+
	moveq	#0,d0
	move	(a1)+,d0
	move.l	d0,(a2)+
	move.l	#GGFX_Palette,(a2)+
	move.l	a1,(a2)+
no$
	move.l	#TAG_DONE,(A2)+
	lea	mytags(A5),a1

	move.l	IML_Data(A4),a0		;Array
	move	IML_Width(A4),d0	;Breite
	move	IML_Height(A4),d1	;Hhe

	move.l	guigfx(A5),a6
	CallSys	MakePictureA
	move.l	d0,d7
	beq	fail$
makepic$
	move.l	drawhandle(a5),a0	;drawhandle
	move.l	d7,a1			;picture
	lea	mytags(A5),a2		;tags
	move.l	#TAG_DONE,(a2)

	CallSys	CreatePictureBitMapA
	move.l	d0,IML_Rendered(a4)

	move.l	d7,a0
	CallSys	DeletePicture

converted$
	tst.l	IML_Rendered(a4)
	beq	fail$
ok$
	Pop	d1-a6
	moveq	#0,d0
	rts
fail$
	Pop	d1-a6
	moveq	#-1,d0
	rts

;----------------------- Pubscreen besorgen -----------------------------------
;Input:  -
;Output: D0 = 0->ok, sonst Fehler
LockPubScreen:
		Push	d1-a6
		bsr	UnlockPubScreen

	ifne	Eagleplayer
		move.l	myEPBase(pc),d0		;Abfrage fr den Fall, da sich die Engine im Debug-Modus befindet,
						;normalerweise immer gesetzt
		beq.s	.noep
		move.l	d0,a0
		move.l	EPG_PubScreen(a0),d0
.noep
		move.l	d0,a0
	else
		suba.l	a0,a0
	endc

		IB
		CallSys	LockPubScreen		;aktuellen Publicscreen rauskriegen
		move.l	d0,mypubscreen(a5)	;fr UnLockpubscreen()
		beq	error$

		Pop	d1-a6	
		moveq	#0,d0
		rts
error$
		Pop	d1-a6	
		moveq	#-1,d0
		rts
;----------------------- Pubscreen freigeben -----------------------------------
;Input:  -
;Output: -
UnlockPubScreen:
		Push	All

		move.l	mypubscreen(a5),d0
		beq	none$

		IB

		move.l	d0,a1
		suba.l	a0,a0
		CallSys	UnlockPubScreen
		clr.l	mypubscreen(a5)
none$
		Pop	All
		rts
;------------------------------ FX Task starten ---------------------------------
	ifne	FXTask
InitFXTask:
		Push	all

		lea	mytags(A5),a0			;FX Proze starten
		move.l	a0,d1				;
		move.l	#NP_Entry,(a0)+			;
		move.l	#FXProcess,(a0)+		;
		move.l	#NP_Name,(A0)+			;
		move.l	#FXTask_Name,(A0)+		;
		move.l	#NP_Priority,(a0)+		;
		moveq	#-5,d0				;
		move.l	d0,(a0)+			;
		clr.l	(a0)				;
		DB
		CallSys	CreateNewProc			;
		tst.l	d0
		beq.s	fail$				;

		Pop	all
		moveq	#0,d0
		rts
fail$
		Pop	all
		moveq	#-1,d0
		rts
	endc
;------------------------------ FX Task beenden ---------------------------------
	ifne	FXTask
EndFXTask:
		Push	all
		st	FX_Quit(a5)

		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;

		move.l	d0,a1
		EB
		moveq	#0,d0
		CallSys	SetTaskPri
wait$
		st	FX_Quit(a5)
		
		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;

		moveq	#2,d1
		DB
		CallSys	Delay
		bra	wait$
ende$
		Pop	all				;
		rts					;
	endc
;------------------------ FX Task ---------------------------------------------
	ifne	FXTask
FXProcess:
		lea	Datas,a5
loop$
		tst.b	FX_Quit(a5)
;		moveq	#0,d0
;		move.l	#SIGBREAKF_CTRL_D,d1	;clear Signal after processing
;		EB
;		CallSys	SetSignal		;neue Kommandos ?
;		tst.l	d0
		bne	end$

		moveq	#1,d1
		DB
		CallSys	Delay

		tst.b	FX_Disable(a5)
		bne	disabled$
		st	FX_Enabled(a5)

	ifeq	Inttest
		bsr	myIntServer
	endc
		bra	loop$
disabled$
		sf	FX_Enabled(a5)
		bra	loop$
end$
		rts
	endc
;------------------------ FX Task enable --------------------------------------
EnableFXTask:
	ifne	FXTask
		Push	all
		lea	Datas,a5
		subq.b	#1,FX_Disable(a5)
		bgt	raus$
ena$
		sf	FX_Disable(a5)

		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;

		move.l	d0,a1
		EB
		moveq	#0,d0
		CallSys	SetTaskPri
		move.l	d0,d7
wait$
		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;
		
		tst.b	FX_Enabled(a5)
		bne	ende$
			
		moveq	#2,d1
		DB
		CallSys	Delay
		bra	wait$
ende$
		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	raus$				;

		move.l	d0,a1
		EB
		move.l	d7,d0
		CallSys	SetTaskPri
raus$
		Pop	all
		rts
	else
		rts
	endc
;------------------------ FX Task disable -------------------------------------
DisableFXTask:
	ifne	FXTask
		Push	all
		lea	Datas,a5
		addq.b	#1,FX_Disable(a5)

		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;

		move.l	d0,a1
		EB
		moveq	#0,d0
		CallSys	SetTaskPri
		move.l	d0,d7
wait$
		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;
		
		tst.b	FX_Enabled(a5)
		beq	ende$
			
		moveq	#2,d1
		DB
		CallSys	Delay
		bra	wait$
ende$
		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	raus$				;

		move.l	d0,a1
		EB
		move.l	d7,d0
		CallSys	SetTaskPri
raus$
		Pop	all
		rts
	else
		rts
	endc
;----------------------- Libs ffnen, etc. ------------------------------------
;Input:  -
;Output: D0 = 0->ok, sonst Error
Inits:	
	Push	d1-a6
	lea	Datas,a5

	lea	(a5),a0
	move.w	#datasize-1,d0
clrdatas$
	clr.b	(a0)+
	dbf	d0,clrdatas$

	lea	Colourmap(A5),a0
	move.w	#Colourmapsize-1,d0
clrcoltable$
	move.b	#-1,(a0)+
	dbf	d0,clrcoltable$

	move.l	#-1,ScrollSignal(a5)

	move.l	4.w,a6
	move.l	a6,Exec_base(a5)

;	EB
	lea	int_name,a1
	moveq	#39,d0
	CallSys	OpenLibrary
	move.l	d0,Int_base(a5)
	beq	error$

	lea	gfx_name,a1
	moveq	#39,d0
	CallSys	OpenLibrary
	move.l	d0,Gfx_base(a5)
	beq	error$

	lea	dos_name,a1
	moveq	#39,d0
	CallSys	OpenLibrary
	move.l	d0,Dos_base(a5)
	beq	error$

	lea	util_name,a1
	moveq	#39,d0
	CallSys	OpenLibrary
	move.l	d0,Util_base(a5)
	beq	error$

	lea	asl_name,a1
	moveq	#39,d0
	CallSys	OpenLibrary
	move.l	d0,asl_base(a5)
	beq	error$

	lea	mathffp_s(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,mathffp(a5)
	bne.s	okmathffp$
	lea	txt_nomathffp(pc),a0
	bsr	MERROR
	bra.s	error$
okmathffp$

	lea	mathtrans_s(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,mathtrans(a5)
	bne.s	okmathtrans$
	lea	txt_nomathtrans(pc),a0
	bsr	MERROR
	bra	error$
okmathtrans$

	lea	guigfx_s(pc),a1
	moveq	#11,d0
	CallSys	OpenLibrary
	move.l	d0,guigfx(a5)
	bne	okggfx$
	lea	txt_noggfx(pc),a0
	bsr	MERROR
	bra	error$
okggfx$

	lea	popupmenu_s(pc),a1
	moveq	#7,d0
	CallSys	OpenLibrary
	move.l	d0,popupmenulib(a5)

	bsr	InitMenuItems
	bsr	Loadconfig		;ext. Konfiguration laden

	;---------------------- Semaphore fr ShowImage ------------------------
	ifne	FXTask
	ifne	Semaphore
		lea	Image_Semaphore(a5),a0
		move.b	#NT_SIGNALSEM,LN_TYPE(a0)
		EB
		CallSys	InitSemaphore
	endc
	endc
	;---------------------- FX Task Init -----------------------------------
	ifne	FXTask
		bsr	InitFXTask
		bmi	error$
	endc

	Pop	d1-a6
	moveq	#0,d0
	rts
error$
	Pop	d1-a6
	moveq	#-1,d0
	rts

;--------------------------- Libs schlieen ---------------------------------------
;Input:  -
;Output: -
CloseLibs:
	Push	All
	lea	Datas,a5

	ifne	FXTask
		bsr	EndFXTask
	endc

	bsr	CloseWin		;Fenster sicherheitshalber nochmal zu schlieen versuchen

	EB

	move.l	Int_base(a5),d0
	beq.s	noint$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	Int_base(a5)
noint$

	move.l	Dos_base(a5),d0
	beq.s	nodos$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	Dos_base(a5)
nodos$

	move.l	guigfx(A5),d0
	beq	noggfx$
	move.l	d0,a1
	CallSys	CloseLibrary
noggfx$

	move.l	mathtrans(a5),d0
	beq	nomatht$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	mathtrans(a5)
nomatht$

	move.l	mathffp(a5),d0
	beq	nomathf$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	mathffp(a5)
nomathf$

	move.l	Gfx_base(a5),d0
	beq.s	nogfx$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	Gfx_base(a5)
nogfx$

	move.l	asl_base(a5),d0
	beq	noasl$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	asl_base(a5)
noasl$

	move.l	Util_base(a5),d0
	beq.s	noutil$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	Util_base(a5)
noutil$

	move.l	popupmenulib(a5),d0
	beq	nopop$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	popupmenulib(a5)
nopop$
	Pop	All
	rts

;------------------------------------------------------------------------------------
;--   Umwandlung kartesischer Koordinaten in Polarkoordinaten, MathLib Variante    --
;--       (c) 1997 Henryk Richter                                                  --
;------------------------------------------------------------------------------------
;Inputs:  D0 - X-Koordinate (Int)
;         D1 - Y-Koordinate (Int)
;         A5 - Basisregister
;Outputs: D0 - Radius (Int)
;         D1 - Winkel (FFP)
ToPolar:
	Push	d2-a6
	ext.l	d0
	ext.l	d1
	move.l	d0,d6		;x
	move.l	d1,d7		;y

	muls	d0,d0		;x
	muls	d1,d1		;y
	add.l	d1,d0		;x+y

	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(A6)		;in FFP
	move.l	mathtrans(a5),a6
	jsr	_LVOSPSqrt(a6)		;Wurzel
	move.l	d0,d4			;Radius in Float
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFix(A6)		;in Integer
	move.l	d0,d5			;Radius
	beq	ToPolar_1		;= 0 -> Phi = 0

	move.l	d7,d0			;y
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(a6)
;	move.l	d0,d1

	move.l	d4,d1			;Radius
	move.l	mathffp(a5),a6
	jsr	_LVOSPDiv(a6)		;R/y
	move.l	mathtrans(a5),a6		
	jsr	_LVOSPAsin(a6)		;phi = arcsin (R/Y)
	move.l	d0,d4			;Phi

	tst	d6			;x<0 ? (test if 2. and 3. quadrant)
	bgt.s	ToPolar_3

	move.l	d4,d0
	move.l	mathffp(a5),a6		
	jsr	_LVOSPNeg(A6)		;-phi

	move.l	#$C90FDB42,d1		;Pi in FFP
	move.l	mathffp(a5),a6		
	jsr	_LVOSPAdd(A6)
	move.l	d0,d4			;phi =  + phi (or  - phi for 2. quadrant with y > 0)
ToPolar_3:
	move.l	d4,d1
	move.l	mathffp(a5),a6		
	jsr	_LVOSPTst(a6)
	tst.l	d0			;phi < 0 ? (last step, case x<0 , y<0, 4. quadrant)
	bgt.s	ToPolar_2		

	move.l	#$C90FDB42,d1		;Pi in FFP
	move.l	d4,d0
	move.l	mathffp(a5),a6		
	jsr	_LVOSPAdd(A6)

	move.l	#$C90FDB42,d1		;Pi in FFP
	jsr	_LVOSPAdd(A6)
					;phi < 0 -> phi = 2* + phi
	move.l	d0,d4
ToPolar_2:
;	move.l	d4,d0
;	move.l	mathtrans(a5),a6
;	jsr	_LVOSPTieee(A6)
;	move.l	d0,aha1
;	fmove.s	aha1,fp0

	move.l	d4,d1			;Winkel (FFP)
	move.l	d5,d0			;Radius (LongInt)
	Pop	d2-a6
	rts

ToPolar_1:
	moveq	#0,d0			;Winkel 0
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(a6)		;in Float
	move.l	d0,d1

	move.l	d5,d0
	Pop	d2-a6
	rts

aha1	dc.l	0

;------------------------------------------------------------------------------------
;--       Umwandlung von Polarkoordinaten in kartesische Koordinaten (Math Libs)   --
;--       (c) 1997 Henryk Richter                                                  --
;------------------------------------------------------------------------------------
;Input:
;       D0 = radius (Int)
;       D1 = angle (FFP)
;       A5 = base register
;Output:
;       d0 = X-coordinate (int)
;       d1 = Y-coordinate (int)
ToKartesisch:
	Push	d2-a6
	move.l	d0,d6
	move.l	d1,d7
	
	move.l	d7,d0
	move.l	mathtrans(a5),a6
	jsr	_LVOSPSin(a6)
	move.l	d0,d4			;sin phi

	move.l	d6,d0			;Radius
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(a6)		;in Float

	move.l	d4,d1
	move.l	mathffp(a5),a6		
	jsr	_LVOSPMul(A6)		;R * sin phi = Y
	jsr	_LVOSPFix(A6)
	move.l	d0,d5			;Y

	move.l	d7,d0
	move.l	mathtrans(a5),a6
	jsr	_LVOSPCos(a6)
	move.l	d0,d4			;cos phi

	move.l	d6,d0			;Radius
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(a6)		;in Float

	move.l	d4,d1
	move.l	mathffp(a5),a6		
	jsr	_LVOSPMul(A6)		;R * cos phi = X
	jsr	_LVOSPFix(A6)		;

	move.l	d5,d1
	Pop	d2-a6
	rts

;***********************************************************************************************
;********** selektiertes Gadget herausfinden und Testergebnis zurckgeben      *****************
;***********************************************************************************************
;Input: D0 - ID
TestActiveGadget:
		push	d1-a6
		move.l	WinHandle(a5),d1
		beq	notfound$
		move.l	d1,a0
		move.l	wd_FirstGadget(a0),d1
		beq	notfound$
nextgad$
		move.l	d1,a0
		cmp	gg_GadgetID(a0),d0
		beq	found$
		move.l	gg_NextGadget(a0),d1
		bne.s	nextgad$
notfound$
		pop	d1-a6
		moveq	#0,d0
		rts
found$
		move.w	gg_Flags(a0),d0
		and	#GFLG_SELECTED,d0
		beq	notfound$

		pop	d1-a6
		moveq	#1,d0
		rts
;***********************************************************************************************
;-----------------------------------------------------------------------------------------------
;-                                                                                             -
;- oberflchenspezifische Custom-Routinen wie Scopes, blinkende Anzeigen, Spezialgadgets usw.  -
;-                                                                                             -
;-----------------------------------------------------------------------------------------------
;***********************************************************************************************

;------------------------ Skin auswhlen und verwenden -----------------------
;Output: D0 = 1 -> ok
;        D0 = 0 -> Cancel
SelectSkin:
	Push	d1-a6
	moveq	#0,d6

	move.l	asl_base(a5),a6
	moveq	#ASL_FileRequest,d0
	lea	MyTags(a5),a0
	move.l	#TAG_Done,(a0)
	CallSys	AllocASLRequest
	move.l	d0,d7
	beq	fail$

		lea	defaultpath(a5),a2
		clr.b	(a2)
	ifne	Eagleplayer				;Engines-Dir an Pfad anhngen
		move.l	EUS_Structure+EUS_EPBase(pc),a1
		move.l	EPG_EngineDirArrayPtr(a1),d1
		beq.s	NoConfigDir$			;Fehler
		move.l	d1,a1
	else
		lea	Enginedir(pc),a1
	endc
copy1$		move.b	(a1)+,(a2)+
		bne.s	copy1$
		subq.l	#1,a2
		cmp.b	#`/`,-1(a2)
		beq.s	noback$
		move.b	#`/`,(a2)+
noback$
		lea	picbasedir(pc),a1
copy2$		move.b	(a1)+,(a2)+
		bne.s	copy2$
NoConfigDir$

	lea	MyTags(a5),a1
	move.l	#ASLFR_Window,(a1)+
	move.l	Winhandle(A5),(a1)+
	move.l	#ASLFR_Titletext,(A1)+
	move.l	#SelectText,(a1)+
	move.l	#ASLFR_InitialDrawer,(A1)+
	lea	defaultpath(a5),a2
	move.l	a2,(a1)+
	move.l	#ASLFR_DrawersOnly,(a1)+
	move.l	#1,(a1)+
	move.l	#TAG_DONE,(a1)+
	lea	MyTags(A5),a1
	move.l	d7,a0
	CallSys	ASLRequest
	move.l	d0,d6
	beq	cancel$

	move.l	d7,a0
	move.l	fr_Drawer(a0),a0
	lea	picturepath(a5),a1
copy$
	move.b	(a0)+,(a1)+
	bne	copy$
cancel$
	move.l	d7,a0
	CallSys	FreeASLRequest
fail$
	move.l	d6,d0
	Pop	d1-a6
	rts
;----------------------------------------------------------------------------------------------
;-------------------- nchste/vorherige Position --------------- ------------------------------
;----------------------------------------------------------------------------------------------
HandleNextPattern:
HandlePrevPattern:
		Push	d4-a6

		Push	All
		bsr	PatternDisp
		Pop	All

		move.w	#-10,PattTime(a5)

		move.l	MOL_Command(a0),d0
		moveq	#0,d1
		move.l	MOL_CMDArg1(a0),d2
		move.l	MOL_CMDArg2(a0),d3

		Pop	d4-a6
		rts
;----------------------------------------------------------------------------------------------
;-------------------- Schublade ffnen und EPNR_LoadModule an EP ------------------------------
;----------------------------------------------------------------------------------------------
HandleLoadModule:
		moveq	#EPNr_LoadModule,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		rts
;-------------------------------- Dirlistviewer show/hide -------------------------------------
HandleDLViewer:
		lea	DLViewername(pc),a0
		bra	SetEngine

;------------------------------- Manager show/hide ----------------------------------------
HandleManager:
		lea	Managername(pc),a0
		bra	SetEngine

;----------------------------- Amplifiermanager show/hide ----------------------------------
HandleAmpManager:
		lea	AmpManagername(pc),a0
		bra	SetEngine
HandleModuleinfo:
		lea	Moduleinfoname(pc),a0
		bra	SetEngine
HandleFormatloader:
		lea	Formatloadername(pc),a0
		bra	SetEngine

;----------------------- angegebene Engine an/aus ----------------------------------------
SetEngine:
	ifne	Eagleplayer
		
		*-- a0=Enginename
.SetEngine:	move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	EPG_FirstUserStruct(a4),a3
.NextEngine:	move.l	(a3),d0
		beq.s	.LoadIt
		move.l	d0,a3
		move.l	UPrgS_Name(a3),a1
		jsr	ENPP_StringCmp(a4)
		beq.s	.Enable
		bra.s	.NextEngine

.Enable:	moveq	#EPNr_Engine,d0
		move.l	UPrgS_EngineNr(a3),d2
		moveq	#-1,d3
		bra.s	.rts

.LoadIt:	move.l	a0,a2
		jsr	ENPP_CalcStringSize(a4)
		move.l	d0,d2
		moveq	#0,d3
		moveq	#EPNr_LoadEngine,d0
.rts		rts
	else
		moveq	#0,d0
		rts
	endc

;---------------------------- Aktiven Amplifier show/hide -------------------------------------
HandleActiveAmplifier:
	ifne 	Eagleplayer
		move.l	#EPNR_HelpLink,d0
		move.l	#EPNr_FirstEngine,d2
		lea	Help_ActiveAmplifier(pc),a0
		move.l	a0,d3
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d1
		btst	#EGPRF_Help,d1
		bne.w	rts$

		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_ActiveAmplifier(a0),d0
		beq.w	fail$
		move.l	d0,a0
		moveq	#0,d2
		move.w	EUS_UserNr(a0),d2
		beq.w	fail$
		moveq	#-1,d3
		move.l	#EPNr_EngineShowState,d0
rts$
		rts
	endc
fail$
		move.l	#EPNr_LastExternal,d0
		rts
;----------------------------------------------------------------------------------------------
;-------------------------- Lautstrkeknopf bei Muting blinken lassen -------------------------
;----------------------------------------------------------------------------------------------
HandleMuting:
		tst.b	MuteID(A5)
		beq.w	end$

		moveq	#ID_Volumeknob,d2
		move.b	MuteTMP(a5),d0
		eor.b	#1,d0
		move.b	d0,MuteTMP(a5)
		beq.s	number1$

		moveq	#ID_Volumeknob2,d2
number1$
		moveq	#ID_Volume,d0
		moveq	#0,d1
		bsr	ShowVolume
end$
		rts

;----------------------------------------------------------------------------------------------
;-------------------------------- Balanceregler -----------------------------------------------
;----------------------------------------------------------------------------------------------
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleBalance:
		bsr	HandleMoused


		move.l	MOL_UserData(a0),d0
		beq.w	error$				;sollte nicht passieren
		move.l	d0,a2				;REG_Struktur

		moveq	#ID_Balanceknob,d2
		tst	REG_Enable(a2)
		beq	noena$
		moveq	#ID_Balanceknob2,d2

		lea	BalanceText+9(pc),a0
		moveq	#`+`,d4
		move	REG_Value(a2),d3
		move	REG_Maxvalue(a2),d5
		lsr	#1,d5
		sub	d5,d3			;nun -32...32
		bpl	hi$
		neg	d3
		moveq	#`-`,d4
hi$
		ext.l	d3
		move.b	d4,(a0)+
		divu	#10,d3
		add.b	#`0`,d3
		move.b	d3,(a0)+
		swap	d3
		add.b	#`0`,d3
		move.b	d3,(a0)+

		lea	BalanceText(pc),a0
		move.l	#ID_Textname1,d0
		bsr	PrintText
		bra.s	show$
noena$
		moveq	#0,d0
		bsr	HandleModName
show$
		moveq	#ID_Balance,d0
		moveq	#ID_Balanceanim,d1
		bsr	ShowVolume
		
		moveq	#ID_Balance,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a1

		move.l	#EPNr_Balance,d0
		moveq	#0,d1
		moveq	#0,d2
		move	REG_Value(a1),d2
		move	REG_Maxvalue(a1),d3
		lsr	#1,d3
		sub	d3,d2			;nun -32...32
		lsl	#3,d2			;wg. -255...255

		cmp	#EP_MaxVolume,d2
		ble.s	no1$
		move	#EP_MaxVolume,d2
no1$
		cmp	#-EP_MaxVolume,d2	;fix fr Bereichsangabe bei Balance
		bge.s	no$
		move	#-EP_MaxVolume,d2
no$
		ext.l	d2
		
		moveq	#0,d3
error$
		rts
NewBalance:
		push	all
		moveq	#ID_Balance,d0
		bsr	TestActiveGadget
		bne	error$

		moveq	#ID_Balance,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a0

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.w	EPG_Balance(a1),d1
		add	#255,d1
		lsr.w	#3,d1
	else
		moveq	#20,d1
	endc
		move.w	d1,REG_Value(a0)

		moveq	#ID_Balance,d0
		moveq	#ID_Balanceanim,d1
		moveq	#ID_Balanceknob,d2
		bsr	ShowVolume
error$
		pop	all
		rts

;----------------------------------------------------------------------------------------------
;-------------------------------- Volume/Balanceregler anzeigen -------------------------------
;----------------------------------------------------------------------------------------------
;Input:
; D0 - ID fr Basisobjekt (Gadget)
; D1 - ID fr Hintergrundimages (2) oder 0, wenn Neuzeichnen nicht erwnscht
; D2 - ID fr Knopfimage (1)
ShowVolume:
		push	d1-a6

		move.l	d1,d6
		move.l	d2,d7

		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a1

		move.l	d6,d0
		beq	nobody$

		bsr	FindObject
		beq	error$
		move.l	d0,a2
		move.l	MOL_Images(a2),d0
		beq	error$
		move.l	d0,a3			;1. Image von x

		moveq	#1,d1			;Images zhlen
		move.l	a3,a4
count$		move.l	IML_Next(a4),d0		;
		beq.s	donecount$		;
		addq.w	#1,d1			;
		move.l	d0,a4			;
		bra	count$			;
donecount$
		mulu.w	REG_Value(a1),d1	;Anzahl der Images * Current
		move.w	REG_Maxvalue(a1),d0	;durch Gesamtanzahl
		sub.w	REG_Minvalue(a1),d0	;
		divu.w	d0,d1

		tst.l	d1
		ble.s	first$
such$
		move.l	IML_Next(a3),d0
		beq	first$
		move.l	d0,a3
		subq	#1,d1
		bgt.s	such$
first$
		move	MOL_Left(a2),d0		;Xpos
		move	MOL_Top(a2),d1		;Ypos
		push	a0/a1
		move.l	a3,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
		pop	a0/a1
nobody$
		move.w	REG_Value(a1),d2	;aktueller Wert

		move	REG_MaxRadius(a1),d1	;
		sub	REG_MinRadius(a1),d1
		mulu	d1,d2			;MaxBreite * Wert
		move	REG_Maxvalue(a1),d1
		sub	REG_Minvalue(a1),d1
		divu	d1,d2			;durch Anzahl Werte
		add	REG_MinRadius(a1),d2

		sub	REG_KnobRadius(a1),d2
		cmp	REG_MinRadius(a1),d2
		bge.s	ok$
		move	REG_MinRadius(a1),d2
ok$
		move.l	d7,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0

		move	REG_MaxRadius(a1),d3
		sub	MOL_Width(a0),d3
		cmp	d3,d2
		ble.s	ok2$
		move	d3,d2
ok2$
		move.w	MOL_Left(a0),d0
		add	d2,d0
		move.w	MOL_Top(a0),d1

		move.l	MOL_Images(a0),d2	;
		beq	error$			;
		move.l	d2,a0			;Image

		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
error$
		pop	d1-a6
		rts

;----------------------------------------------------------------------------------------------
;-------------------------------- Volumeregler ------------------------------------------------
;----------------------------------------------------------------------------------------------
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleVolume:
		bsr	HandleMoused

		move.l	MOL_UserData(a0),d0
		beq.w	error$				;sollte nicht passieren
		move.l	d0,a2				;REG_Struktur

		moveq	#ID_Volumeknob,d2
		tst	REG_Enable(a2)
		beq	noena$
		moveq	#ID_Volumeknob2,d2

		lea	VolumeText+8(pc),a0
		move	REG_Value(a2),d3
		ext.l	d3
		divu	#10,d3
		add.b	#`0`,d3
		move.b	d3,(a0)+
		swap	d3
		add.b	#`0`,d3
		move.b	d3,(a0)+

		lea	VolumeText(pc),a0
		move.l	#ID_Textname1,d0
		bsr	PrintText
		bra.s	show$
noena$
		moveq	#0,d0
		bsr	HandleModName
show$
		moveq	#ID_Volume,d0
		moveq	#ID_Volumeanim,d1
		bsr	ShowVolume			;d2: s.o.
		
		moveq	#ID_Volume,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a1

		move.l	#EPNr_Volume,d0
		moveq	#0,d1
		moveq	#0,d2

		tst.b	MuteID(a5)
		bne.s	Vol0$
		move	REG_Value(a1),d2
		lsl	#2,d2			;wg. 0...255
		cmp	#255,d2
		bls.s	Vol0$
		move	#255,d2
Vol0$
		moveq	#0,d3
error$
		rts

;------------------------ Prefs-Update fr Lautstrke ---------------------------------
NewVolume:
		push	all

		moveq	#ID_Volume,d0
		bsr	TestActiveGadget
		bne	error$

		moveq	#ID_Volume,d0		;Normal
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a0

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
;		move.w	EPG_Volume(a1),d1
		move.w	dtg_SndVol(a1),d1
	else
		moveq	#20,d1
	endc
		tst.b	MuteID(A5)		;Abfrage, ob Muting an ist, wenn
						;ja und bergebene Lautstrke = 0,
						;dann Regler nicht ndern
		beq.s	setvol$
		tst.w	d1
		beq.s	novol$
setvol$
		move.w	d1,REG_Value(a0)
novol$
		moveq	#ID_Volume,d0
		moveq	#ID_Volumeanim,d1
		moveq	#ID_Volumeknob,d2
		bsr	ShowVolume
error$
		pop	all
		rts

;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleClutterbar:
		moveq	#ID_Clutterbar,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0

		bsr	HandleMoused

		move.l	MOL_UserData(a0),d0
		beq.w	error$				;sollte nicht passieren
		move.l	d0,a2				;REG_Struktur

		tst	REG_Enable(a2)
		beq	noena$
		move	REG_Value(a2),d3
		bmi	noena$

		moveq	#ID_Clutterbaranim,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a3
		move.w	MOL_Left(a0),d0
		move.w	MOL_Top(a0),d1
		move.l	MOL_Images(a0),d2
		beq	error$
		
		mulu	#3*4,d3
		lea	(a3,d3.w),a3
		move.l	(a3)+,d3		;Image Nummer
loop$
		move.l	d2,a0			;1. Image
		move.l	IML_Next(a0),d2
		beq	show$
		subq	#1,d3
		bge	loop$
show$
		suba.l	a1,a1
		bsr	ShowImage

		move.l	(a3)+,d0
		beq	error$
		move.l	d0,a0			;Text zur Anzeige
		move.l	#ID_Textname1,d0
		bsr	PrintText
		bra.s	error$
noena$
	;Maus losgelassen->
	;Modnamen wieder eintragen
		moveq	#0,d0
		bsr	HandleModname
	;Image fr geschlossene Clutterbar anzeigen
		moveq	#ID_Clutterbaranim,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),a3
		move.l	MOL_Images(a0),d2
		beq	error$
		move.w	MOL_Left(a0),d0
		move.w	MOL_Top(a0),d1

		move.l	d2,a0

		move.l	Prefsflags(pc),d3
		and.l	#PFlag_Clutterbar,d3
		beq.s	first$
		move.l	IML_Next(a0),d2
		beq	first$
		move.l	d2,a0
first$
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage		

		tst.l	a3
		beq	error$
		move	REG_Value(a2),d3
		bmi	error$
		move	#-1,REG_Value(a2)

		mulu	#3*4,d3
		lea	(a3,d3.w),a3
		move.l	8(a3),d0
		beq	error$
		move.l	d0,a0
		jmp	(a0)
error$
		move.l	#EPNr_FirstExternal,d0
		rts
*-----------------------------------------------------------------------------*
* Input: d0=Tag
*	 d0=Ergebnis
*-----------------------------------------------------------------------------*
FindPlTag:	Push	d1-a6			;Suche Tag im aktuellen Player
	ifne	Eagleplayer
		move.l	EUS_Structure+EUS_EPBase(pc),a6
		move.l	EPG_PlayerTagList(a6),d2
		beq	notfound$
		move.l	d2,a6
		bsr	FindTag
		move.l	a6,d0
	else	
		moveq	#0,d0
	endc
		Pop	d1-a6
		tst.l	d0
		rts
notfound$
		Pop	d1-a6
		moveq	#0,d0
		rts

FindMITag:	Push	d1-a6			;Suche Tag im aktuellen Moduleinfo
	ifne	Eagleplayer
		move.l	EUS_Structure+EUS_EPBase(pc),a6
		move.l	EPG_ModuleInfoTagList(a6),d2
		beq	notfound$
		move.l	d2,a6
		bsr	FindTag
		move.l	a6,d0
	else
		moveq	#10,d0
	endc
		Pop	d1-a6
		tst.l	d0
		rts
notfound$
		Pop	d1-a6
		moveq	#0,d0
		rts
FindTag:
FindTag2:	move.l	d3,-(a7)
		move.l	a7,d3

	*--------- Rekursive FindTag-Routine aus Eagleplayer Sourcecode ----------*
FindTag3:	moveq	#0,d2
		cmp.l	a6,d2
		beq.s	.Empty
		move.l	(a6)+,d2			;Tag rauslesen
		bne.s	.NoEmpty
.Empty:		cmp.l	d3,a7				;ak. Stack vergleichen
		beq.s	.TagNoFound
		move.l	(a7)+,a6
		bra.b	.NoMore
.NoEmpty:	cmp.l	d2,d0
		beq.s	.TagFound

	*----- Tag-Skip gefunden ???? -----*
		cmp.l	#TAG_SKIP,d2
		bne.s	.NoSkip
		addq.l	#8,a6				;Diesen und nchsten
		addq.l	#4,a6				;Tag berspringen
		bra.s	.NoMore

	*------ Tag-More gefunden ???? -----*
.NoSkip:	cmp.l	#TAG_MORE,d2
		bne.s	.NoMore

		move.l	a6,-(a7)		;Adr der Tagliste sichern
		move.l	(a6),a6			;Neue Tagliste setzen
		bra.b	FindTag3
.NoMore:	addq.l	#4,a6
		bra.s	FindTag3
.TagFound:	move.l	(a6),a6
		move.l	a6,d2
.TagNoFound:	move.l	d3,a7
		move.l	(a7)+,d3
		tst.l	d2
		bne.s	.NoNull
		sub.l	a6,a6
.NoNull:	tst.l	d2
		rts

;****************************************************************************************
;*     LED Zeile fr Aussteuerungsanzeige, Abwicklung ber Eagleplayer UPS Struktur     *
;****************************************************************************************
;Achtung: in dieser Routine wird momentan angenommen, dass beide LED Zeilen um 2 Punkte
;         in der Vertikalen versetzt liegen, falls dies nicht erwnscht ist, bitte Objekt
;         fr 2. Zeile anlegen...
;---------------------- Input: A0 - Pointer auf Objekt ----------------------------------
DoLevelmeter:
	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d6
		btst	#EGPRF_NowPlay,d6
		beq	error$

;		move.l	EPG_UPS_Structure(a1),d0	;spielt ein Modul ?
;		beq	error$				;nein, Fehler
;		move.l	d0,a4
;		move.l	d0,AN_StructAdr(a5)

		move.l	AN_StructAdr(a5),d0
		beq	error$
		move.l	d0,a4

		moveq	#-1,d2			;Alle Kanle, wenn DMAon/off nicht unterstzt vom
						;Replay
		move.w	UPS_Flags(a4),d1
		and.w	#UPSB_DMACon,d1		;Kanle an/aus untersttzt ?
		beq.s	nodmacon$
		move.w	UPS_DMACon(a4),d2	;Ja,zugehrige Werte ranholen

			;Bitabfolge ndern wegen anderer Abfragereihenfolge der Kanle in dieser
			;Engine (Stimmen 1,4,2,3 wg. 1&4 = links, 2&3=rechts)
		move	d2,d0
		move	d2,d1
		and	#1,d2		;Bit 0 -> Bit 0

		lsr	#2,d0
		and	#2,d0
		or	d0,d2		;Bit 3 -> Bit 1

		and	#%0110,d1
		lsl	#1,d1
		or	d1,d2		;(Bit 1 und 2) << 1
nodmacon$

		lea	vol64(pc),a2		;fr den Fall, da "Mastervolume" ausgeschaltet

		move.l	EPG_SomePrefs(a1),d6
		and.l	#EGPRB_Mastervolume,d6 ;Mastervolume switch im EP an ?
		beq.s	.NoMaster

		lea	EPG_Voice1Vol(a1),a2	;ok, Lautstrkewerte der einzelnen Stimmen verwenden
.NoMaster

		lea	PermerkLevelmeter(a5),a3;SamplePeriod merken und Spielzeit der Samples in 1/50 Sekunden
						;je 32 Bit = 1LW pro Kanal

	;--------------------- linke Kanle bearbeiten ----------------------
		move.l	AN_StructAdr(a5),a4	;Analyzer Struktur
		bsr	GetADRLENVOLandPER	;Daten Channel 1 holen

		move.l	a0,a1			;Adresse    fr Channel 1
		move.l	d0,d4			;Restlnge  ---- "" -----
		move	d3,d5			;Period     ---- "" -----
		move.w	d1,d6			;Lautstrke ---- "" -----

		addq.l	#4,a3
		move.l	AN_StructAdr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*3(a4),a4	;4. Stimme
		bsr	GetADRLENVOLandPER	;Daten Channel 2 holen

		move.b	SlowIDLevel(a5),d3
		eor.b	#1,d3
		move.b	d3,SlowIDLevel(a5)
		bne	skip1$

		moveq	#0,d7
		bsr	ShowLevel
skip1$
	;--------------------- rechte Kanle bearbeiten ----------------------

		addq.l	#4,a3
		move.l	AN_StructAdr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*1(a4),a4	;2. Stimme
		bsr	GetADRLENVOLandPER

		move.l	a0,a1			;Adresse    fr Channel 2
		move.l	d0,d4			;Restlnge  ---- "" -----
		move	d3,d5			;Period     ---- "" -----
		move.w	d1,d6			;Lautstrke ---- "" -----

		addq.l	#4,a3
		move.l	AN_StructAdr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*2(a4),a4	;3. Stimme
		bsr	GetADRLENVOLandPER

		tst.b	SlowIDLevel(a5)		;jedes Frame jeweils abwechselnd
		beq	skip2$			;eine der beiden Zeilen darstellen


		moveq	#6,d7			;um 6 Zeilen nach unten verschieben
		move.l	Prefsflags(pc),d2
		and.l	#PFlag_Double,d2
		bne	doub$
		moveq	#3,d7			;um 3 Zeilen nach unten verschieben
doub$
		bsr	ShowLevel
skip2$

error$
	else
;----------- Testroutine, Zeile bis Maximum und wieder von vorn darstellen -----------------
		move.l	MOL_Images(a0),d0
		beq	error$
		move.l	d0,a1

		move.l	MOL_UserData(a0),d0
		addq.l	#1,d0
		cmp.l	#8,d0
		ble	use$
		moveq	#0,d0
use$
		move.l	d0,MOL_UserData(a0)

		move	d0,d2
		bsr	DrawLevel

		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos

		move.l	a1,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage

		addq	#3,d1
		bsr	ShowImage
error$
	endc
		rts
;----------------------------------------------------------------------------------------
;                        Ausschlag berechnen und anzeigen
;
;Formel zur Ermittlung der Signalleistung in dB:

;          (      n          )
;          (      _          )
;          ( 1    \  |x[]| )
;          ( -    /          )
;          ( n              )
;          (     =0         )
;          (                 )
;    10 lg ( --------------- )
;          (                 )
;          (                 )
;          (      Ydef       )
;          (                 )
;          (                 )
;
;Input:  a1 - Adresse Kanal1
;        d4 - Lnge   Kanal1 (ignoriert, da eh nur 64 Bytes aufgerechnet)
;        d5 - Period  Kanal1 (ignoriert)
;        d6 - Volume  Kanal1
;
;        a0 - Adresse Kanal2
;        d0 - Lnge   Kanal2 (ignoriert, da eh nur 64 Bytes aufgerechnet)
;        d3 - Period  Kanal2 (ignoriert) 
;        d1 - Volume  Kanal2
;
;        d7 - Offset in Y-Richtung fr Graphik
;Output: -
ShowLevel:
	Push	All

	move.l	d7,-(sp)
	moveq	#7,d7

	move	#128-1,d3	;128 Bytes aufrechnen

	moveq	#0,d2		;Zhler 2. Kanal

	move.l	a1,d0
	bne	a1ok$
	moveq	#8,d7
	move.l	a0,a1
	move.l	a0,d0
	beq	zero$
a1ok$
	move.l	a0,d0
	bne	a0ok$
	move.l	a1,a0
	moveq	#8,d7
a0ok$

	moveq	#0,d0		;Zhler 1. Kanal
addloop$
	move.b	(a1)+,d5
	ext.w	d5
	muls	d5,d5
	add.l	d5,d0

	move.b	(a0)+,d5
	ext.w	d5
	muls	d5,d5
	add.l	d5,d2

	dbf	d3,addloop$

				;max. Amplitude: $200000 = 128 * 128
	lsr.l	#5,d0
	lsr.l	#5,d2		;max. Amplitude: 65536 = +3dB
	
	mulu	d6,d0		;Volume Kanal1
	mulu	d1,d2		;Volume Kanal1
	add.l	d2,d0
	lsr.l	d7,d0
				;Amplitude: 0....32768
	moveq	#0,d2

	lea	LevelmeterTab(pc),a0
	moveq	#16-1,d1
loop$
	cmp	(a0)+,d0	;aktueller Wert kleiner als Schwellwert fr entsprechenden Dezibelwert ?
	blt.s	found$
	addq	#1,d2
	dbf	d1,loop$
found$

zero$	
	move.l	(sp)+,d7

		moveq	#ID_Levelmeter,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		
		move.l	MOL_Images(a0),d0
		beq	error$
		move.l	d0,a1			;

		bsr	DrawLevel

		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		add	d7,d1

		move.l	a1,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
error$
	Pop	All
	rts
*****************************************************************************************
* Pegel anhand der Farben aus Tabelle einzeichnen
;Input: D2 - Pegel
;       A1 - Zielmap
DrawLevel:
		Push	All
		move.l	IML_Data(A1),d0
		beq	fail$
		move.l	d0,a0

		moveq	#0,d0
		move.w	IML_Sourcewidth(a1),d0	;Breite Zielmap
		lsl	#2,d0			;Breite * 4 (32 Bit 0RGB), Breite einer Zeile in Bytes
		lea	(a0,d0.w),a1

		lea	Levelmetercoltab(pc),a2
		mulu	#38*2,d2
		lea	(a2,d2.l),a2

		lea	FFT_Colours(pc),a3
		moveq	#38-1,d0
dloop$
		move	(a2)+,d1
		move.l	(a3,d1.w*4),d2
		move.l	d2,(a0)+
		move.l	d2,(a1)+
		dbf	d0,dloop$
fail$
		Pop	All
		rts
;****************************************************************************************
;*                           FFT Spektrum Analyzer                                      *
;****************************************************************************************
;Achtung: momentan wird mit statischen Feldern gearbeitet, bei FFT-Lngen >128 Datentabellen
;         anpassen !
;;!!
UpdateUPS:
		push	all
	ifne	Eagleplayer
		lea	Datas,a5
		sf	SpecialUPS(A5)
		sf	FFT_Stopanalyzer(a5)
		clr.l	FFT_Structadr(A5)
		
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d6
		btst	#EGPRF_NowPlay,d6
		beq	stop$

		move.l	EPG_UPS_Structure(a1),d0	;spielt ein Modul ?
		beq	no1$				;nein, Fehler
		move.l	d0,AN_StructAdr(a5)
		move.l	d0,FFT_StructAdr(a5)
no1$
		move.l	EPG_ActiveAmplifier(a1),d0	;
		beq.w	ret$				;
		move.l	d0,a0				;

		cmp.l	#`4CHN`,EUS_AMIDNr(a0)		;FastRamAmplifier aktiv ?
		beq.w	set2$				;ok, take it
		
		cmp.l	#`14BT`,EUS_AMIDNr(a0)		;14 Bit Amplifier aktiv ?
		beq.s	set$				;ok, take it

		cmp.l	#`TOCC`,EUS_AMIDNr(a0)		;14 Bit Amplifier aktiv ?
		beq.s	set$				;ok, take it

		cmp.l	#`8BIT`,EUS_AMIDNr(a0)		;8 Bit Amplifier aktiv ?
		bne.s	ret$				;noe, das andere tuts also auch
set$
		move.l	EUS_AMUPSStruct(a0),d0
		beq.s	ret$
		move.l	d0,FFT_Structadr(a5)
		move.l	d0,AN_Structadr(a5)
		st	SpecialUPS(A5)
		bra	ret$
stop$
		moveq	#0,d0
		move.l	d0,FFT_Structadr(a5)
		move.l	d0,AN_Structadr(a5)

		st	FFT_Stopanalyzer(a5)
		move.b	#80,FFT_Stoptime(A5)

		moveq	#ID_Levelmeter,d0
		bsr	FindObject
		beq	ret$
		move.l	d0,a0
		
		move.l	MOL_Images(a0),d0
		beq	ret$
		move.l	d0,a1

		moveq	#0,d2
		bsr	DrawLevel

		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos

		move.l	a1,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage

		addq	#3,d1			;um 6 Zeilen nach unten verschieben
		move.l	Prefsflags(pc),d2
		and.l	#PFlag_Double,d2
		beq	ndoub$
		addq	#3,d1			;um 3 Zeilen nach unten verschieben
ndoub$
		bsr	ShowImage
	endc
ret$
		pop	all
		rts
set2$:
		move.l	EUS_AMUPSStruct(a0),d0
		beq.s	ret$
		move.l	d0,FFT_Structadr(a5)
		bra.s	ret$
InitAnalyzer:
		Push	all
		move.l	#MixingFrequency,FFT_Mixfrequency(a5)

		sf	FFT_slowid(a5)			;

	ifeq	FXTask
		move.b	#2,FFT_slowcount(a5)		;nur jedes 2. Frame was tun
	else
		move.b	#1,FFT_slowcount(a5)		;jedes Frame was tun
	endc	

		clr.l	FFT_Permerk(A5)
		clr.l	FFT_Permerk+4(A5)
		clr.l	FFT_Permerk+8(A5)
		clr.l	FFT_Permerk+12(A5)
		sf	SpecialUPS(A5)
		move	#256,FFT_Current_Num(a5)	;Lnge der berechneten FFT

		move	#FFT_Displayentries,FFT_NumDisplay(a5)	;Anzahl der angezeigten Balken

		tst.l	FFT_CurrentMode(a5)
		bne.w	set$

set$
		bsr	MakeBitreversetabs		;
	ifeq	USEFPU
		bsr	MakeSinCostabs			;sin/cos mit eingerechneter Bitspiegelung
	else
		bsr	MakeSinCostabsInt
		bsr	MakeSinCostabsFP
	endc
		bsr	MakeSinCostabs2			;
		bsr	MakeAnalyzertab			;logarithmische Umrechnungstabelle erzeugen

		Pop	all
		rts
HandleAnalyzer:
		Push	all
		lea	Datas,a5

		tst.b	FFT_Stopanalyzer(a5)
		bne.w	Stop$

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d6
		btst	#EGPRF_NowPlay,d6
		beq	error$

		move.l	Prefsflags(pc),d6
		and.l	#PFlag_Analyzer!PFlag_Monoscope,d6
		beq	error$

		tst.l	FFT_Structadr(a5)
;		bne.s	ok$
;		move.l	AN_Structadr(A5),FFT_Structadr(a5)
		beq	error$
;ok$
	endc
;		bsr	InitAnalyzer

		;	Zielmap
		moveq	#ID_AnalyzerMap,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a4			;
		move.l	MOL_Images(a4),d0
		beq	error$
		move.l	d0,a0

		;	Grafik der einzelnen Zustnde
;		moveq	#ID_Analyzerstates,d0
;		bsr	FindObject		;Objekt in Liste finden
;		beq	error$		
;		move.l	d0,a1			;
;		move.l	MOL_Images(a1),d0
;		beq	error$

		lea.l	FFT_Colours,a1		;Farben fr Zustnde

		bsr	FFT_MixVoices

		tst.b	FFT_slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	nofft1$

		move.l	Prefsflags(pc),d6
		and.l	#PFlag_Analyzer,d6
		beq.s	monoscope$

		bsr	FFT_Main

		lea	FFT_FinalTable(a5),a2
		move	FFT_NumDisplay(a5),d0	;Anzahl der angezeigten Balken

		bsr	Mode01Scope

		move	MOL_Left(a4),d0
		move	MOL_Top(a4),d1
		suba.l	a1,a1
		move.l	MOL_Images(a4),a0
		bsr	ShowImage

		bra.w	nofft1$
monoscope$
		lea	FFT_Realtab(a5),a2	;128 Werte bei Mixfrequency/2, max. Amplitude 2048
		move	FFT_NumDisplay(a5),d0	;Anzahl der angezeigten Balken
		bsr	Mode02Scope

		move	MOL_Left(a4),d0
		move	MOL_Top(a4),d1
		suba.l	a1,a1
		move.l	MOL_Images(a4),a0
		bsr	ShowImage
nofft1$
error$
		Pop	all
		rts
stop$
		move.l	Prefsflags(pc),d6
		and.l	#PFlag_AnalyzerPower,d6
		beq	nofft1$

		move.b	FFT_Stoptime(a5),d0
		ble.s	nofft1$
		subq.b	#1,d0
		move.b	d0,FFT_Stoptime(a5)
		beq	KillDisplay$

		move.b	FFT_slowid(A5),d0		;nur jedes 2. oder 3. Frame etwas ausgeben ?
		addq.b	#1,d0
		cmp.b	FFT_slowcount(a5),d0	;<- wird erst beim ffnen des Fensters gesetzt
						;   auf momentan 1-3
		blt.s	lo$

		moveq	#0,d0
lo$		move.b	d0,FFT_slowid(a5)
		bne	nofft1$

		;	Zielmap
		moveq	#ID_AnalyzerMap,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a4			;
		move.l	MOL_Images(a4),d0
		beq	error$
		move.l	d0,a0

		;	Grafik der einzelnen Zustnde
		moveq	#ID_Analyzerstates,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a1			;
		move.l	MOL_Images(a1),d0
		beq	error$
		move.l	d0,a1

		lea	FFT_OutTable(a5),a2	;Datenfeld
		move	FFT_NumDisplay(a5),d0	;Anzahl der angezeigten Balken
		move	d0,d1
		subq	#1,d1
		move.l	a2,a3
clr$
		clr.w	(a3)+
		dbf	d1,clr$

		move.l	FFT_CurrentMode(a5),d1
		beq	error$
		move.l	d1,a3
		jsr	(a3)

		move	MOL_Left(a4),d0
		move	MOL_Top(a4),d1
		suba.l	a1,a1
		move.l	MOL_Images(a4),a0
		bsr	ShowImage

		bra	nofft1$
KillDisplay$
		bra	nofft1$

;---------- Darstellung Modus 1 (normal) ------------
;Inputs: d0 - Anzahl der Balken
;        a0 - Image-Struct Zielgrafik
;        a1 - Image-Struct Quellgrafik (einzelne Zustnde)
;        a2 - Datenfeld
Mode01Scope:
		push	all
		bsr	ClearArea

		moveq	#0,d2
		move.w	IML_Sourcewidth(a0),d2	;Breite Zielmap
		lsl	#2,d2			;Breite * 4 (32 Bit 0RGB), Breite einer Zeile in Bytes
		move	IML_Sourceheight(a0),d3
		move	d3,d1
		subq	#1,d1
		mulu	d2,d1			;Offset letzte Zeile
	
		move.l	IML_Data(a0),a0
		add.l	d1,a0			;A0 auf letzter Zeile

		subq	#1,d0
show$
		move.w	(a2)+,d4		;Wert holen
		move.l	a0,a4
		lea.l	(a1,d4.w*4),a3

		subq.w	#1,d4
		bmi.s	next$
show1$
		move.l	-(a3),(a4)
		sub.l	d2,a4			;vorherige Zeile
		dbf	d4,show1$
next$
		addq.l	#4,a0
		dbf	d0,show$
		pop	all

;		bsr	PrepareMaxDisplay
;		moveq	#0,d1
;		lea	FFT_MaxDisplaytab(a5),a2
;		bsr	MaxDisplay1

		rts
;---------- Darstellung Modus 1 (normal) ------------
;Inputs: d0 - Anzahl der Balken
;        a0 - Image-Struct Zielgrafik
;        a2 - Datenfeld
Mode02Scope:
		push	all
		bsr	ClearArea

		moveq	#0,d2
		move.w	IML_Sourcewidth(a0),d2	;Breite Zielmap
		lsl	#2,d2			;Breite * 4 (32 Bit 0RGB), Breite einer Zeile in Bytes
		move	IML_Sourceheight(a0),d3
		move	d3,d1
		lsr	#1,d1			;
		mulu	d2,d1			;Offset: Zeile in der Mitte
	
		move.l	IML_Data(a0),a0
		add.l	d1,a0			;A0 auf Zeile in der Mitte

		subq	#1,d0
		move.l	FFT_Colours+18*4(pc),d3	;Farbe aus Tabelle
showloop$
		move.l	(a2)+,d4		;Wert holen (Amplitude: 2048)
		asr	#8,d4			;auf +-8
		bpl	hi$
		cmp	#-8,d4
		bgt.s	show$
		moveq	#-7,d4
		bra.s	show$
hi$
		cmp	#8,d4
		blt.s	show$
		moveq	#7,d4
		bra.w	show$
show$
		muls	d2,d4
		move.l	d3,(a0,d4.l)

		addq.l	#4,a0
		dbf	d0,showloop$

		pop	all
		rts
;------------------------- Anzeigebereich lschen ---------------------------
;Input: A1 - Pointer auf Farbtabelle
;       A0 - Image fr Map
;
ClearArea:
		Push	d0-a0/a2-a6

		move.l	IML_Data(a0),a0
		move.l	(a1)+,d1		;Farbe fr Background
		move.l	(a1)+,d0		;Farbe fr Background #2 (Punkte)
		move.l	d0,d2
		move.l	d1,d3
		move.l	d0,d4
		move.l	d1,d5
		move.l	d1,d6
		move.l	d1,d7

	if	[FFT_Width=75]

	REPT	FFT_Height/2
		REPT	15			;1. Zeile nur mit Hintergrundfarbe
			movem.l	d1/d3/d5/d6/d7,(a0)	;15*5 = 75 -> eine Zeile
			add.l	#5*4,a0
		ENDR

		REPT	12			;12*6 = 72
			movem.l	d0-d5,(a0)
			add.l	#6*4,a0
		ENDR
			movem.l	d0-d2,(a0)	;+3 = 75 -> eine Zeile
			add.l	#3*4,a0
	ENDR
		ifne	[FFT_Height-FFT_Height/2*2]	;falls Anzahl der Zeilen ungerade -> letzte Zeile lschen
		REPT	15			;1. Zeile nur mit Hintergrundfarbe
			movem.l	d1/d3/d5/d6/d7,(a0)	;15*5 = 75 -> eine Zeile
			add.l	#5*4,a0
		ENDR
		endc
	else


	if	[FFT_Width=76]

	REPT	FFT_Height/2
		REPT	14			;1. Zeile nur mit Hintergrundfarbe
			movem.l	d1/d3/d5/d6/d7,(a0)	;14*5 = 70
			add.l	#5*4,a0
		ENDR
			movem.l	d1/d3/d5/d6/d7,(a0)	;+5 = 75
			move.l	d1,5*4(a0)		;+1 = 76
			add.l	#6*4,a0

		REPT	12			;12*6 = 72
			movem.l	d0-d5,(a0)
			add.l	#6*4,a0
		ENDR
			movem.l	d0-d4,(a0)	;+4 = 76 -> eine Zeile
			add.l	#4*4,a0
	ENDR
		ifne	[FFT_Height-FFT_Height/2*2]	;falls Anzahl der Zeilen ungerade -> letzte Zeile lschen

		REPT	14			;1. Zeile nur mit Hintergrundfarbe
			movem.l	d1/d3/d5/d6/d7,(a0)	;14*5 = 70
			add.l	#5*4,a0
		ENDR
			movem.l	d1/d3/d5/d6/d7,(a0)	;+5 = 75
			move.l	d1,5*4(a0)		;+1 = 76
			add.l	#6*4,a0
		endc
	else
		Printt	""
		Printt	"He Du ! Denk an ClearArea:"
	endc

	endc
		Pop	d0-a0/a2-a6
		rts

;---------- Darstellung Spitzenwertanzeige ------------
;Inputs: d0 - Anzahl der Balken
;        d1 - Richtung: 0=nach oben 1=nach unten
;        a0 - Image-Struct Zielgrafik
;        a1 - Image-Struct Quellgrafik (einzelne Zustnde)
;        a2 - Datenfeld
MaxDisplay1:
		push	all

		moveq	#0,d2
		move.w	IML_Width(a0),d2	;Breite Zeilmap
		lsl	#2,d2
		move	IML_Height(a0),d5
;		subq	#1,d5
		mulu	d2,d5			;Offset letzte Zeile
		add	d2,d2			;jede 2. Zeile berspringen

		tst	d1
		beq	ok1$
		neg	d2
ok1$
		move.w	IML_Width(a1),d3	;Zeilenbreite Quellmap
		lsl	#2,d3
		move	IML_Height(a1),d4
;		subq	#1,d4			;Nummer letzte Zeile
		mulu	d3,d4			;mal Breite
;		sub.l	#16,d4

		move.l	IML_Data(a0),a0
		tst	d1
		bne	ok2$
		add.l	d5,a0			;letzte Zeile Zielmap
ok2$
		move.l	IML_Data(a1),a1
		add.l	d4,a1			;letzte Zeile ist Adresse der Ausgangsdaten

		subq	#1,d0
show$
		move	(a2)+,d1
		beq.s	next$
		neg.w	d1
		cmp.w	#-20,d1
		bgt.s	lo$
		moveq	#-19,d1
lo$
		move	d2,d4
		muls	d1,d4
		asl	#4,d1			;jeder Eintrag in Quellmap ist 4 Punkte a 32 bit breit
		lea.l	(a1,d1.w),a3		;
		movem.l	(a3),d5-d7/a6

		lea	(a0,d4.l),a4
		movem.l	d5-d7/a6,(a4)
next$
		addq.l	#2,a2
		adda.l	#16,a0
		dbf	d0,show$
		pop	all
		rts
;-------------------------------------------------------------------------------------
;                Funktion: Spitzenwertanzeige fr einen Kanal vorbereiten,
;                          Vergleich mit neuen Werten und Update der Tab
;
;Input:  A2 - neue Wertetab fr diesen Ausgabestream
;Output: -
;
; Aufbau der Tabelle: 1. Wort aktuelle Amplitude
;                     2. Wort Zeit, die diese Amplitude besteht
;
PrepareMaxDisplay:
		push	all
		move.l	a2,a0
		lea	FFT_MaxDisplaytab,a1

		moveq	#TimeOut,d4
		moveq	#0,d5
		move.b	FFT_slowcount(a5),d5
		divu	d5,d4

		move	FFT_NumDisplay(a5),d0
		subq	#1,d0
loop$
		move	(a0)+,d1	;neuer Wert
		move	(a1)+,d2	;alter Wert
		cmp	d1,d2
		ble.s	new$
				;alter Wert grer
		move	(a1),d3		;Timeout
		subq	#1,d3
		bge.s	old$		;Timeout zhlen

		subq	#DownSpeed,d2	;Ausschlag verringern
		blt.s	skip$		;0 erreicht
		move	d2,-2(a1)	;Ausschlag abspeichern
		addq.l	#2,a1
		bra.s	next$
skip$		move.w	#0,-2(a1)	;Ausschlag 0 erreicht
		addq.l	#2,a1
		bra.s	next$

old$		move	d3,(a1)+	;Timeout noch nicht erreicht
		bra.s	next$
new$
		move	d1,-2(a1)
		move	d4,(a1)+
next$
		dbf	d0,loop$
		pop	all
		rts
;----------------------------------------------------------------------------------------------
;
; FFT-Routine: 128 Punkt Integer FFT rckgefhrt auf 64 Punkt FFT reellwertiger Eingangswerte
;
; Algorithmus: N/4 * ld N/2 komplexe Operationen = 192 <> N*ld N Operationen bei Radix 2 = 896
; (Routine selbst unoptimiert, knapp 50% der Multiplikationen redundant...)
;
	IFEQ	USEFPU
FFT_Main:
		Push	all
		
		lea	FFT_Realtab,a0
		lea	FFT_Imgtab,a1
;------------------------------- InitWerte ------------------------------------------------------
		move	#FFT_N/2*2,d1	;N2=N/2 (*2 wg. wortweisem Speicherzugriff)
		move.l	#FFT_Gamma-1-2,d2	;NU1=Gamma-1

;----------------------------------------------------------------------------------------------
;                                      optimierter Loop 1
;----------------------------------------------------------------------------------------------
;1. Optimierung: beim 1. Durchlauf lediglich sin=0, cos=1 fr alle W^P, somit multiplikationslos
opt1_Outerloop$
		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		lea	(a2,d1.w*2),a5	;&realk+N2
		lea	(a4,d1.w*2),a6	;&imagk+N2

		lsr	#1,d1
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		subq	#1,d7		;Schleife fr I bis N2
opt1_trivial1loop$			;Trivialflle, sin = 0, cos = 1
		move.l	(a5),d0
		move.l	(a2),d4
		move.l	(a6),d6
		move.l	(a4),d5
		move.l	d4,d3
		add.l	d0,d4
		sub.l	d0,d3
		move.l	d5,d0
		add.l	d6,d5
		move.l	d4,(a2)+
		move.l	d3,(a5)+
		sub.l	d6,d0
		move.l	d5,(a4)+
		move.l	d0,(a6)+
		dbf	d7,opt1_trivial1loop$

;----------------------------------------------------------------------------------------------
;                                      optimierter Loop 2
;----------------------------------------------------------------------------------------------
;1. Optimierung: beim 2. Durchlauf erste Hlfte sin=0, cos=1, 2. Hlfte sin=1, cos=0
;
opt2_Outerloop$
		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lea	(a2,d1.w*2),a5	;&realk+N2
		lsr	#1,d7
		lea	(a4,d1.w*2),a6	;&imagk+N2
		subq	#1,d7		;Schleife fr I bis N2
opt2_trivial1loop$			;Trivialflle, sin = 0, cos = 1
		move.l	(a5),d0
		move.l	(a2),d4
		move.l	(a6),d6
		move.l	(a4),d5
		move.l	d4,d3
		add.l	d0,d4
		sub.l	d0,d3
		move.l	d5,d0
		add.l	d6,d5
		move.l	d4,(a2)+
		move.l	d3,(a5)+
		sub.l	d6,d0
		move.l	d5,(a4)+
		move.l	d0,(a6)+
		dbf	d7,opt2_trivial1loop$

		;---------------------- 2. Trivialloop --------------------

		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

		lsr	#1,d1
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		subq	#1,d7		;Schleife fr I bis N2
opt2_trivial2loop$			;Trivialflle, sin = 1, cos = 0
		move.l	(a6),d0
		move.l	(a2),d4
		move.l	(a5),d6
		move.l	(a4),d5
		move.l	d4,d3
		add.l	d0,d4		;resreal = *realk + treal;
		sub.l	d0,d3
		move.l	d5,d0
		sub.l	d6,d5		;resimag = *imagk - timag;
		move.l	d4,(a2)+	;*realk++ = resreal;
		move.l	d3,(a5)+	;*realkN2++ = resreal - treal - treal;
		add.l	d6,d0
		move.l	d5,(a4)+	;*imagk++ = resimag;
		move.l	d0,(a6)+	;*imagkN2++ = resimag + timag + timag;
		dbf	d7,opt2_trivial2loop$

;-----------------------------------------------------------------------------------------------
;                                       Hauptschleife
;-----------------------------------------------------------------------------------------------
;
;89 Instruktionen
;
Outerloop$
		move.w	d2,d7
		swap	d7
		move	d1,d3
		lea	SinCostab+8*2,a3 ;Sinus- und Cosinustabelle fr N Werte, auf 256 bezogen, die Eintrge der ersten 2 Trivialschleifen abgezogen

		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		lea	(a2,d1.w*2),a5	;&realk+N2
		lea	(a4,d1.w*2),a6	;&imagk+N2

		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7
		subq	#1,d7		;Schleife fr I bis N2
trivial1loop$				;Trivialflle, sin = 0, cos = 1
		move.l	(a5),d0		;treal = *realkN2
		move.l	(a6),d6		;timag = *imagkN2
		move.l	(a2),d4		;*realk
		move.l	(a4),d5		;*imagk
		add.l	d0,d4		;resreal = *realk + treal;
		add.l	d6,d5		;resimag = *imagk + timag;
		move.l	d4,(a2)+	;*realk++ = resreal;
		sub.l	d0,d4
		move.l	d5,(a4)+	;*imagk++ = resimag;
		sub.l	d6,d5
		sub.l	d0,d4
		sub.l	d6,d5
		move.l	d4,(a5)+	;*realkN2++ = resreal - treal - treal;
		move.l	d5,(a6)+	;*imagkN2++ = resimag - timag - timag;
		dbf	d7,trivial1loop$

		;---------------------- 2. Trivialloop --------------------

		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7
		subq	#1,d7		;Schleife fr I bis N2
trivial2loop$				;Trivialflle, sin = 1, cos = 0
		move.l	(a6),d0		;treal = *imagkN2
		move.l	(a5),d6		;timag = *realkN2
		move.l	(a2),d4		;*realk
		move.l	(a4),d5		;*imagk
		add.l	d0,d4		;resreal = *realk + treal;
		sub.l	d6,d5		;resimag = *imagk - timag;
		move.l	d4,(a2)+	;*realk++ = resreal;
		sub.l	d0,d4
		move.l	d5,(a4)+	;*imagk++ = resimag;
		add.l	d6,d5
		sub.l	d0,d4
		add.l	d6,d5
		move.l	d4,(a5)+	;*realkN2++ = resreal - treal - treal;
		move.l	d5,(a6)+	;*imagkN2++ = resimag + timag + timag;
		dbf	d7,trivial2loop$

		lsl	#2,d3
		;----------- langsamer Teil der Hauptschleife ------------------
;		 // outerloop 2, 1 bis N/4 mal durchlaufen
slow_outerloop$
		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

;		 // innerloop, N/2 bis 1 mal durchlaufen
					;for( i = 0; i < N2; i++)
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7		;
		subq	#1,d7		;Schleife fr I bis N2

;		move.l	(a3)+,d5	;sin<<16 + cos
slowloop$				;Standardfall mit variablen sin/cos-Werten
		move.l	(a5),d0		;*realkN2
		move.l	(a6),d6		;*imagkN2
		move.l	d0,d4
		muls.l	4(a3),d0	;*realkN2 * cos
		move.l	d6,d2
		muls.l	4(a3),d6	;*imagkN2 * cos
;		swap	d5		;cos<<16 + sin
		muls.l	(a3),d4		;*realkN2 * sin
		muls.l	(a3),d2		;*imagkN2 * sin

		add.l	d2,d0		;treal = (*realkN2 * *cos1 + *imagkN2 * *sin1);
		sub.l	d4,d6		;timag = *imagkN2 * *cos1 - *realkN2 * *sin1;
		move.l	(a4),d2		;*imagk
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		move.l	(a2),d4		;*realk
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben

		add.l	d0,d4		;resreal = *realk + treal;
		move.l	d4,(a2)+	;*realk++ = resreal;
		sub.l	d0,d4
		add.l	d6,d2		;resimag = *imagk + timag
		sub.l	d0,d4
		move.l	d2,(a4)+	;*imagk++ = resimag;
		move.l	d4,(a5)+	;*realkN2++ = resreal - treal - treal;
		sub.l	d6,d2
;		swap	d5		;sin<<16 + cos
		sub.l	d6,d2
		move.l	d2,(a6)+	;*imagkN2++ = resimag - timag - timag;

		dbf	d7,slowloop$

		addq.l	#8,a3

		add	d1,d3		;k+= N2<<1;
		add	d1,d3		;

		cmp	#FFT_N*2-1,d3	;while( k < N )
		blt.s	slow_outerloop$

		swap	d7
		move.w	d7,d2
		lsr	#1,d1		;N2 >>= 1;
		dbf	d2,Outerloop$	;NU1=NU1-1 -> bis NU1 = 0,umlaufen, bei <0 fertig

;-------------- Folge 1 und Folge 2 trennen, Bitreverse bercksichtigen  ---------------------
;hllisch langsam, wird aber in diesem Programm nur 32 mal durchlaufen...

		lea	FFT_Realtab,a0
		lea	FFT_Imgtab,a1
		lea	FFT_OutTable,a2
		lea	FFT_OutTableI,a4

		lea	SinTab2,a3
		lea	CosTab2,a5

		moveq	#1,d0
		move	#FFT_N-1,d1

		move.l	(a0),d2
		add.l	(a1),d2
		move	d2,(a2)+		;Gleichanteil
		clr	(a4)+			;=Real(0)+Imag(0)

		lea	Bitreversetab,a6	;Tabellen fr IBR(M)
trennen$
		move	(a6,d0.w*2),d6
		move	(a6,d1.w*2),d7

		move.l	(a0,d6.w*4),d2		;Xreal(n)
		move.l	(a0,d7.w*4),d3		;Xreal(N-n)

		move.l	(a1,d6.w*4),d4		;Ximag(n)
		move.l	(a1,d7.w*4),d5		;Ximag(N-n)

		asr.l	#5,d2			;alle durch
		asr.l	#5,d3			; 2 dividieren, hier noch
		asr.l	#5,d4			; ein paar bit mehr wg. 
		asr.l	#5,d5			; Genauigkeitserweiterung

		add	d3,d2			;R(n)+R(N-n)
		move.w	d2,(a2)
		sub	d3,d2
		sub	d3,d2			;R(n)-R(N-n)
		move	d2,d3			;R(n)-R(N-n)

		ext.l	d2
		ext.l	d3
		muls.l	(a3,d0.w*4),d2		;sin n/N * ( R(n)-R(N-n) )
		muls.l	(a5,d0.w*4),d3		;cos n/N * ( R(n)-R(N-n) )
		asr.l	#FFT_Sinbase/2,d2
		asr.l	#FFT_Sinbase/2,d2
		asr.l	#FFT_Sinbase/2,d3
		asr.l	#FFT_Sinbase/2,d3
		sub	d2,(a2)

		clr	(a4)
		sub	d3,(a4)			;-[ cos n/N * ( R(n)-R(N-n) ) ]

		sub.l	d5,d4			;I(n)-I(N-n)
		add	d4,(a4)			;+I(n)-I(N-n)
		add.l	d5,d4
		add.l	d5,d4			;I(n)+I(N-n)
		move.l	d4,d5

		ext.l	d4
		ext.l	d5
		muls.l	(a3,d0.w*4),d4		;sin n/N * ( I(n)+I(N-n) )
		muls.l	(a5,d0.w*4),d5		;cos n/N * ( I(n)+I(N-n) )
		asr.l	#FFT_Sinbase/2,d4
		asr.l	#FFT_Sinbase/2,d4
		asr.l	#FFT_Sinbase/2,d5
		asr.l	#FFT_Sinbase/2,d5
		sub	d4,(a4)+		;-[ sin n/N * ( I(n)+I(N-n) ) ]

		add	d5,(a2)+		;+[ cos n/N * ( I(n)+I(N-n) ) ]

		subq	#1,d1
		addq	#1,d0

		ifne	FFT_ShowLess
		cmp	#FFT_ShowLess+2,d0
		else
		cmp	#FFT_N,d0
		endc
		blt.w	trennen$

;		move	(a0),d2			;Xr(0)
;		move	(a1),d4			;Xi(0)
;		sub	d4,d2			;Xr(0)-Xi(0)
;		lea	OutTab1R(pc),a0		;Xr(0)+Xi(0)
;		sub	(a0),d2			;Xr(0)-Xi(0)-(Xr(0)+Xi(0))

		move.l	(a1),d4
		add	d4,d4
		neg	d4
		move	d4,(a2)+
		clr	(a4)+
;		clr	(a2)+
	ELSE
		endb	a5
FFT_Main:
		Push	all
		lea	FFT_Realtab,a0		;Adresse der Eingangstabelle REAL
		lea	FFT_Imgtab,a1		;Adresse der Eingangstabelle IMAGINR

		move.l	a0,FFT_RealTabAdr
		move.l	a1,FFT_ImgTabAdr

;------------------------------- InitWerte ------------------------------------------------------
		move	#FFT_N/2*2,d1	;N2=N/2 (*2 wg. wortweisem Speicherzugriff)

;----------------------------------------------------------------------------------------------
;                                      optimierter Loop 1
;----------------------------------------------------------------------------------------------
;1. Optimierung: beim 1. Durchlauf lediglich sin=0, cos=1 fr alle W^P, somit multiplikationslos
;
;untere Hlfte der Werte als FP abgespeichert
opt1_Outerloop$									;dummy
		;---------------------- 1. Trivialloop --------------------

		move.l	FFT_RealTabAdr,a2	;&realk
		move.l	FFT_ImgTabAdr,a4	;&imagk
		lea	(a2,d1.w*2),a5		;&realk+N2
		lea	(a4,d1.w*2),a6		;&imagk+N2

		lsr	#1,d1
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		subq	#1,d7		;Schleife fr I bis N2
opt1_trivial1loop$			;Trivialflle, sin = 0, cos = 1
		move.l	(a5),d0
		move.l	(a6),d6
		move.l	(a2),d4
		move.l	(a4),d5
	fmove.l	d0,fp0
	fmove.l	d4,fp4
		move.l	d4,d3
	fmove.l	d6,fp6
	fadd.x	fp0,fp4
		sub.l	d0,d3
	fmove.l	d5,fp5
		move.l	d5,d0
	fmove.s	fp4,(a2)+
		move.l	d3,(a5)+
	fadd.x	fp6,fp5
		sub.l	d6,d0
	fmove.s	fp5,(a4)+
		move.l	d0,(a6)+
		dbf	d7,opt1_trivial1loop$

;----------------------------------------------------------------------------------------------
;                                      optimierter Loop 2
;----------------------------------------------------------------------------------------------
;2. Optimierung: beim 2. Durchlauf erste Hlfte sin=0, cos=1 (FP), 2. Hlfte sin=1, cos=0 (INT)
;
;
opt2_Outerloop$									;dummy
		move.l	FFT_RealTabAdr,a2	;&realk
		move.l	FFT_ImgTabAdr,a4	;&imagk

		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lea	(a2,d1.w*2),a5	;&realk+N2
		lsr	#1,d7
		lea	(a4,d1.w*2),a6	;&imagk+N2
		subq	#1,d7		;Schleife fr I bis N2
		lea	FFT_N/2*4(a2),a0
		lea	FFT_N/2*4(a4),a1
opt2_trivial1loop$				;Trivialflle, sin = 0, cos = 1
	fmove.s	(a5),fp0
		move.l	FFT_N/2*4(a6),d0
	fmove.s	(a2),fp4
		move.l	(a0),d4
	fmove.s	(a6),fp6
		move.l	FFT_N/2*4(a5),d6
	fmove.s	(a4),fp5
		move.l	(a1),d5
	fmove.x	fp4,fp3
		move.l	d4,d3
	fadd.x	fp0,fp4
		add.l	d0,d4			;resreal = *realk + treal;
	fsub.x	fp0,fp3
		sub.l	d0,d3
	fmove.x	fp5,fp0
		move.l	d5,d0
	fadd.x	fp6,fp5
		sub.l	d6,d5			;resimag = *imagk - timag;
		move.l	d4,(a0)+		;*realk++ = resreal;
		move.l	d3,FFT_N/2*4(a5)	;*realkN2++ = resreal - treal - treal;
	fsub.x	fp6,fp0
		add.l	d6,d0
	fmove.s	fp4,(a2)+
		move.l	d5,(a1)+		;*imagk++ = resimag;
	fmove.s	fp3,(a5)+
		move.l	d0,FFT_N/2*4(a6)	;*imagkN2++ = resimag + timag + timag;
	fmove.s	fp5,(a4)+
	fmove.s	fp0,(a6)+
		dbf	d7,opt2_trivial1loop$

		lsr	#1,d1

;-----------------------------------------------------------------------------------------------
;                3. Loop, nur die ersten beiden Durchlufe relevant
;
;FP:  optimierte Durchlufe erste Hlfte sin=0, cos=1, 2. Hlfte sin=1, cos=0 (INT)
;INT: sin und cos aus Tabelle
;
		lea	SinCostabINT,a0 ;Sinus- und Cosinustabelle fr Integer Operationen

opt3_Outerloop$										;dummy
		;1. Trivialloop fr FP, Integer normal

		move.l	FFT_RealTabAdr,a2	;&realk
		move.l	FFT_ImgTabAdr,a4	;&imagk
		lea	(a2,d1.w*2),a5	;&realk+N2
		lea	(a4,d1.w*2),a6	;&imagk+N2

		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7
		subq	#1,d7		;Schleife fr I bis N2

opt3_trivial1loop$
		move.l	FFT_N/2*4(a5),d0		;*realkN2
	fmove.s	(a5),fp0	;treal = *realkN2
		move.l	FFT_N/2*4(a6),d6		;*imagkN2
		move.l	d0,d4
	fmove.s	(a6),fp6	;timag = *imagkN2
		muls.l	4(a0),d0			;*realkN2 * cos
		move.l	d6,d2
		muls.l	4(a0),d6			;*imagkN2 * cos
	fmove.s	(a2),fp4	;*realk
		muls.l	(a0),d4				;*realkN2 * sin
	fmove.s	(a4),fp5	;*imagk
		muls.l	(a0),d2				;*imagkN2 * sin
	fadd.x	fp0,fp4		;resreal = *realk + treal;
	fadd.x	fp6,fp5		;resimag = *imagk + timag;
		add.l	d2,d0			;treal = (*realkN2 * *cos1 + *imagkN2 * *sin1);
		sub.l	d4,d6			;timag = *imagkN2 * *cos1 - *realkN2 * *sin1;
		move.l	FFT_N/2*4(a4),d2	;*imagk
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		move.l	FFT_N/2*4(a2),d4	;*realk
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben

		add.l	d0,d4			;resreal = *realk + treal;
		move.l	d4,FFT_N/2*4(a2)	;*realk++ = resreal;
		sub.l	d0,d4
	fmove.s	fp4,(a2)+	;*realk++ = resreal;
		add.l	d6,d2			;resimag = *imagk + timag
	fsub.x	fp0,fp4
		sub.l	d0,d4
		move.l	d2,FFT_N/2*4(a4)	;*imagk++ = resimag;
	fmove.s	fp5,(a4)+	;*imagk++ = resimag;
		move.l	d4,FFT_N/2*4(a5)	;*realkN2++ = resreal - treal - treal;
	fsub.x	fp6,fp5
		sub.l	d6,d2
	fsub.x	fp0,fp4
		sub.l	d6,d2
	fsub.x	fp6,fp5
		move.l	d2,FFT_N/2*4(a6)	;*imagkN2++ = resimag - timag - timag;

	fmove.s	fp4,(a5)+	;*realkN2++ = resreal - treal - treal;
	fmove.s	fp5,(a6)+	;*imagkN2++ = resimag - timag - timag;

		dbf	d7,opt3_trivial1loop$


		addq.l	#8,a0		;nchstes Sin/Cos Paar fr Integer
		;2. Trivialloop fr FP, Integer normal

		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

		lsr	#1,d1
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		subq	#1,d7		;Schleife fr I bis N2
opt3_trivial2loop$			
		move.l	FFT_N/2*4(a5),d0		;*realkN2
		move.l	FFT_N/2*4(a6),d6		;*imagkN2
	fmove.s	(a6),fp0	;treal = *imagkN2
	fmove.s	(a5),fp6	;timag = *realkN2
	fmove.s	(a2),fp4	;*realk
		move.l	d0,d4
		muls.l	4(a0),d0			;*realkN2 * cos
		move.l	d6,d2
		muls.l	4(a0),d6			;*imagkN2 * cos
		muls.l	(a0),d4				;*realkN2 * sin
	fmove.s	(a4),fp5	;*imagk
		muls.l	(a0),d2				;*imagkN2 * sin

		add.l	d2,d0			;treal = (*realkN2 * *cos1 + *imagkN2 * *sin1);
		sub.l	d4,d6			;timag = *imagkN2 * *cos1 - *realkN2 * *sin1;
		move.l	FFT_N/2*4(a4),d2	;*imagk
	fadd.x	fp0,fp4		;resreal = *realk + treal;
	fsub.x	fp6,fp5		;resimag = *imagk - timag;
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben
		move.l	FFT_N/2*4(a2),d4	;*realk
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben

		add.l	d0,d4			;resreal = *realk + treal;
		move.l	d4,FFT_N/2*4(a2)	;*realk++ = resreal;
		sub.l	d0,d4
	fmove.s	fp4,(a2)+	;*realk++ = resreal;

		add.l	d6,d2			;resimag = *imagk + timag
	fsub.x	fp0,fp4
		sub.l	d0,d4
		move.l	d2,FFT_N/2*4(a4)	;*imagk++ = resimag;
	fmove.s	fp5,(a4)+	;*imagk++ = resimag;
		move.l	d4,FFT_N/2*4(a5)	;*realkN2++ = resreal - treal - treal;
		sub.l	d6,d2
	fadd.x	fp6,fp5
	fsub.x	fp0,fp4
		sub.l	d6,d2
	fadd.x	fp6,fp5
		move.l	d2,FFT_N/2*4(a6)	;*imagkN2++ = resimag - timag - timag;

	fmove.s	fp4,(a5)+	;*realkN2++ = resreal - treal - treal;

	fmove.s	fp5,(a6)+	;*imagkN2++ = resimag + timag + timag;

		dbf	d7,opt3_trivial2loop$

		addq.l	#8,a0		;nchstes Sin/Cos Paar fr Integer
;-----------------------------------------------------------------------------------------------
;              Hauptschleife, Gamma-4 mal durchlaufen
;-----------------------------------------------------------------------------------------------
;
;
		move.l	#FFT_Gamma-1-3-1,d2	;NU1=Gamma-1 (-3 schon abgearbeitete runs; -1 run, der FP Register wieder in Integer umsetzt)
Outerloop$
		move.w	d2,d7
		swap	d7

		lea	SinCostabFP,a3 ;Sinus- und Cosinustabelle fr N Werte, auf 256 bezogen, die Eintrge der ersten 2 Trivialschleifen abgezogen

		;---------------------- 1. Trivialloop --------------------

		move.l	FFT_RealTabAdr,a2	;&realk
		move.l	FFT_ImgTabAdr,a4	;&imagk
		lea	(a2,d1.w*2),a5		;&realk+N2
		lea	(a4,d1.w*2),a6		;&imagk+N2

		moveq	#0,d3
		;----------- langsamer Teil der Hauptschleife ------------------
;		 // outerloop 2, 1 bis N/4 mal durchlaufen
slow_outerloop$
;		 // innerloop, N/2 bis 1 mal durchlaufen
					;for( i = 0; i < N2; i++)
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7		;
		subq	#1,d7		;Schleife fr I bis N2


slowloop$				;Standardfall mit variablen sin/cos-Werten
	fmove.s	(a5),fp0	;*realkN2
		move.l	FFT_N/2*4(a5),d0	;*realkN2
		move.l	FFT_N/2*4(a6),d6	;*imagkN2
	fmove.s	(a6),fp6	;*imagkN2
		move.l	d0,d4
		muls.l	4(a0),d0	;*realkN2 * cos
	fmove.x	fp0,fp4
		move.l	d6,d2
		muls.l	4(a0),d6	;*imagkN2 * cos
	fmul.s	4(a3),fp0	;*realkN2 * cos

		muls.l	(a0),d4		;*realkN2 * sin
	fmove.x	fp6,fp2
		muls.l	(a0),d2		;*imagkN2 * sin
	fmul.s	4(a3),fp6	;*imagkN2 * cos

		add.l	d2,d0		;treal = (*realkN2 * *cos1 + *imagkN2 * *sin1);
	fmul.s	(a3),fp4	;*realkN2 * sin
		sub.l	d4,d6		;timag = *imagkN2 * *cos1 - *realkN2 * *sin1;
		move.l	FFT_N/2*4(a4),d2	;*imagk
	fmul.s	(a3),fp2	;*imagkN2 * sin
	fsub.x	fp4,fp6		;timag = *imagkN2 * *cos1 - *realkN2 * *sin1;
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
	fadd.x	fp2,fp0		;treal = (*realkN2 * *cos1 + *imagkN2 * *sin1);
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		move.l	FFT_N/2*4(a2),d4	;*realk
	fmove.s	(a4),fp2	;*imagk
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben
	fmove.s	(a2),fp4		;*realk
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben

		add.l	d0,d4			;resreal = *realk + treal;
	fadd.x	fp0,fp4		;resreal = *realk + treal;
		move.l	d4,FFT_N/2*4(a2)	;*realk++ = resreal;
		sub.l	d0,d4
	fmove.s	fp4,(a2)+	;*realk++ = resreal;
		add.l	d6,d2			;resimag = *imagk + timag
	fsub.x	fp0,fp4
	fadd.x	fp6,fp2		;resimag = *imagk + timag
		sub.l	d0,d4
		move.l	d2,FFT_N/2*4(a4)	;*imagk++ = resimag;
	fsub.x	fp0,fp4
	fmove.s	fp2,(a4)+	;*imagk++ = resimag;
		move.l	d4,FFT_N/2*4(a5)	;*realkN2++ = resreal - treal - treal;
		sub.l	d6,d2
	fsub.x	fp6,fp2
	fmove.s	fp4,(a5)+	;*realkN2++ = resreal - treal - treal;
		sub.l	d6,d2
		move.l	d2,FFT_N/2*4(a6)	;*imagkN2++ = resimag - timag - timag;
	fsub.x	fp6,fp2
	fmove.s	fp2,(a6)+	;*imagkN2++ = resimag - timag - timag;

		dbf	d7,slowloop$

		addq.l	#8,a3

		add	d1,d3		;k+= N2<<1;
		add	d1,d3		;

		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

		addq.l	#8,a0		;nchstes Sin/Cos Paar fr Integer

		cmp	#FFT_N-1,d3	;while( k < N )
		blt.w	slow_outerloop$

		swap	d7
		move.w	d7,d2
		lsr	#1,d1		;N2 >>= 1;
		dbf	d2,Outerloop$	;NU1=NU1-1 -> bis NU1 = 0,umlaufen, bei <0 fertig


;-----------------------------------------------------------------------------------------------
;      letzter Durchlauf, Umsetzung FP->Integer, sonst wie normale Hauptschleife
;-----------------------------------------------------------------------------------------------
;
;
last_Outerloop$									;dummy

		lea	SinCostabFP,a3 ;Sinus- und Cosinustabelle fr N Werte, auf 256 bezogen, die Eintrge der ersten 2 Trivialschleifen abgezogen

		;---------------------- 1. Trivialloop --------------------

		move.l	FFT_RealTabAdr,a2	;&realk
		move.l	FFT_ImgTabAdr,a4	;&imagk
		lea	(a2,d1.w*2),a5		;&realk+N2
		lea	(a4,d1.w*2),a6		;&imagk+N2

		moveq	#0,d3
		;----------- langsamer Teil der Hauptschleife ------------------
;		 // outerloop 2, 1 bis N/4 mal durchlaufen
last_slow_outerloop$
;		 // innerloop, N/2 bis 1 mal durchlaufen
					;for( i = 0; i < N2; i++)
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7		;
		subq	#1,d7		;Schleife fr I bis N2


last_slowloop$				;Standardfall mit variablen sin/cos-Werten
		move.l	FFT_N/2*4(a5),d0	;*realkN2
	fmove.s	(a5),fp0	;*realkN2
		move.l	FFT_N/2*4(a6),d6	;*imagkN2
	fmove.s	(a6),fp6	;*imagkN2
		move.l	d0,d4
		muls.l	4(a0),d0	;*realkN2 * cos
	fmove.x	fp0,fp4
		move.l	d6,d2
	fmul.s	4(a3),fp0	;*realkN2 * cos
		muls.l	4(a0),d6	;*imagkN2 * cos

		muls.l	(a0),d4		;*realkN2 * sin
	fmove.x	fp6,fp2
		muls.l	(a0),d2		;*imagkN2 * sin
	fmul.s	4(a3),fp6	;*imagkN2 * cos

		add.l	d2,d0		;treal = (*realkN2 * *cos1 + *imagkN2 * *sin1);
	fmul.s	(a3),fp4	;*realkN2 * sin
		sub.l	d4,d6		;timag = *imagkN2 * *cos1 - *realkN2 * *sin1;
	fmul.s	(a3),fp2	;*imagkN2 * sin
		move.l	FFT_N/2*4(a4),d2	;*imagk
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
	fadd.x	fp2,fp0		;treal = (*realkN2 * *cos1 + *imagkN2 * *sin1);
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		move.l	FFT_N/2*4(a2),d4	;*realk
	fsub.x	fp4,fp6		;timag = *imagkN2 * *cos1 - *realkN2 * *sin1;
	fmove.s	(a4),fp2	;*imagk
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben

		add.l	d0,d4			;resreal = *realk + treal;
	fmove.s	(a2),fp4		;*realk
		move.l	d4,FFT_N/2*4(a2)	;*realk++ = resreal;
		sub.l	d0,d4
	fadd.x	fp0,fp4		;resreal = *realk + treal;
		add.l	d6,d2			;resimag = *imagk + timag
		sub.l	d0,d4
	fmove.l	fp4,d5
		move.l	d2,FFT_N/2*4(a4)	;*imagk++ = resimag;
	move.l	d5,(a2)+
	fsub.x	fp0,fp4
		move.l	d4,FFT_N/2*4(a5)	;*realkN2++ = resreal - treal - treal;
	fadd.x	fp6,fp2		;resimag = *imagk + timag
		sub.l	d6,d2
	fsub.x	fp0,fp4
		sub.l	d6,d2
	fmove.l	fp2,d5
		move.l	d2,FFT_N/2*4(a6)	;*imagkN2++ = resimag - timag - timag;
	move.l	d5,(a4)+

	fmove.l	fp4,d5
	move.l	d5,(a5)+

	fsub.x	fp6,fp2
	fsub.x	fp6,fp2

	fmove.l	fp2,d5
	move.l	d5,(a6)+

		dbf	d7,last_slowloop$

		addq.l	#8,a3		;nchstes Sin/Cos Paar fr FPU

		add	d1,d3		;k+= N2<<1;
		add	d1,d3		;

		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

		addq.l	#8,a0		;nchstes Sin/Cos Paar fr Integer

		cmp	#FFT_N-1,d3	;while( k < N )
		blt.w	last_slow_outerloop$

;-------------- Folge 1 und Folge 2 trennen, Bitreverse bercksichtigen  ---------------------
;hllisch langsam, wird aber in diesem Programm nur 32 mal durchlaufen...

		move.l	FFT_RealTabAdr,a0	;&realk
		move.l	FFT_ImgTabAdr,a1	;&imagk
		lea	FFT_OutTable,a2
		lea	FFT_OutTableI,a4

		lea	SinTab2,a3
		lea	CosTab2,a5

		moveq	#1,d0
		move	#FFT_N-1,d1

		move.l	(a0),d2
		add.l	(a1),d2
		move	d2,(a2)+		;Gleichanteil
		clr	(a4)+			;=Real(0)+Imag(0)

		lea	Bitreversetab,a6	;Tabellen fr IBR(M)
trennen$
		move	(a6,d0.w*2),d6
		move	(a6,d1.w*2),d7

		move.l	(a0,d6.w*4),d2		;Xreal(n)
		move.l	(a0,d7.w*4),d3		;Xreal(N-n)

		move.l	(a1,d6.w*4),d4		;Ximag(n)
		move.l	(a1,d7.w*4),d5		;Ximag(N-n)

		asr.l	#5,d2			;alle durch
		asr.l	#5,d3			; 2 dividieren, hier noch
		asr.l	#5,d4			; ein paar bit mehr wg. 
		asr.l	#5,d5			; Genauigkeitserweiterung
;		asr	#2,d2			;alle durch
;		asr	#2,d3			; 2 dividieren, hier noch
;		asr	#2,d4			; ein paar bit mehr wg. 
;		asr	#2,d5			; Genauigkeitserweiterung

		add	d3,d2			;R(n)+R(N-n)
		move.w	d2,(a2)
		sub	d3,d2
		sub	d3,d2			;R(n)-R(N-n)
		move	d2,d3			;R(n)-R(N-n)

		ext.l	d2
		ext.l	d3
		muls.l	(a3,d0.w*4),d2		;sin n/N * ( R(n)-R(N-n) )
		muls.l	(a5,d0.w*4),d3		;cos n/N * ( R(n)-R(N-n) )
		asr.l	#FFT_Sinbase/2,d2
		asr.l	#FFT_Sinbase/2,d2
		asr.l	#FFT_Sinbase/2,d3
		asr.l	#FFT_Sinbase/2,d3
		sub	d2,(a2)

		clr	(a4)
		sub	d3,(a4)			;-[ cos n/N * ( R(n)-R(N-n) ) ]

		sub.l	d5,d4			;I(n)-I(N-n)
		add	d4,(a4)			;+I(n)-I(N-n)
		add.l	d5,d4
		add.l	d5,d4			;I(n)+I(N-n)
		move.l	d4,d5

		ext.l	d4
		ext.l	d5
		muls.l	(a3,d0.w*4),d4		;sin n/N * ( I(n)+I(N-n) )
		muls.l	(a5,d0.w*4),d5		;cos n/N * ( I(n)+I(N-n) )
		asr.l	#FFT_Sinbase/2,d4
		asr.l	#FFT_Sinbase/2,d4
		asr.l	#FFT_Sinbase/2,d5
		asr.l	#FFT_Sinbase/2,d5
		sub	d4,(a4)+		;-[ sin n/N * ( I(n)+I(N-n) ) ]

		add	d5,(a2)+		;+[ cos n/N * ( I(n)+I(N-n) ) ]

		subq	#1,d1
		addq	#1,d0

		ifne	FFT_ShowLess
		cmp	#FFT_ShowLess+2,d0
		else
		cmp	#FFT_N,d0
		endc
		blt.w	trennen$

;		move	(a0),d2			;Xr(0)
;		move	(a1),d4			;Xi(0)
;		sub	d4,d2			;Xr(0)-Xi(0)
;		lea	OutTab1R(pc),a0		;Xr(0)+Xi(0)
;		sub	(a0),d2			;Xr(0)-Xi(0)-(Xr(0)+Xi(0))

		move.l	(a1),d4
		add	d4,d4
		neg	d4
		move	d4,(a2)+
		clr	(a4)+
;		clr	(a2)+

	basereg	Datas,a5
	ENDC
;------------------------------ Power-Spektrum bilden ---------------------------------------

		lea	FFT_OutTable+4,a0		;die ersten beiden Spektralwerte ignorieren
		lea	FFT_OutTableI+4,a1		;
		lea	FFT_Analyzertab,a2
		lea	FFT_FinalTable,a3

		ifne	FFT_ShowLess
		moveq	#FFT_ShowLess-1,d0
		else
		move	#FFT_N+1-1,d0
		endc
		clr	d3
power$
		move	(a0)+,d1
		tst.w	d1
		bge.s	.hi
		neg	d1
.hi

;		muls	d1,d1

		move	(a1)+,d2
		tst.w	d2
		bge.s	.hi2
		neg	d2
.hi2

;		muls	d2,d2

		add.l	d1,d2
;		lsr.l	#8,d2

;		fmove.l	d2,fp0
;		fsqrt	fp0
;		fmove.l	fp0,d2

;		swap	d2

		moveq	#16,d3
		cmp	#FFT_Analyzertabsize,d2
		bhs.s	set$

		move.b	(a2,d2.w),d3
set$
		move	(a3),d2
		subq	#FFT_FallOffSpeed,d2
		bmi	new$
		cmp	d2,d3		;Falloff simulation
		blt.w	old$
new$
		move.w	d3,(a3)+
		dbf	d0,power$
		bra.s	end$
old$
		move	d2,(a3)+
		dbf	d0,power$
End$
		Pop	all
		rts
;--------- UPS-Struktur auswerten, Stimmen mixen und auf Real/Imgtabelle aufteilen  -----------
FFT_MixVoices:
		Push	all
	ifne	Eagleplayer			;fr Tests beim "Eagleplayer" Flag aus

		move.b	FFT_slowid(A5),d0		;nur jedes 2. oder 3. Frame etwas ausgeben ?
		addq.b	#1,d0
		cmp.b	FFT_slowcount(a5),d0	;<- wird erst beim ffnen des Fensters gesetzt
						;   auf momentan 1-3
		blt.s	lo$
	endc
		moveq	#0,d0
lo$		move.b	d0,FFT_slowid(a5)

	ifne	Eagleplayer

		beq.s	lo1$			;ausfhren der Darstellung, ansonsten ggfalls UPSDaten auswerten
		
		tst.b	SpecialUPS(A5)		;UPS vom Amplifier ?
		bne	skipmix$		;ja, also brauchen wir nix tun
lo1$
		move.l	FFT_Structadr(a5),a4	;Analyzer Struktur

		moveq	#%0101,d2		;wenn schon gemixte Daten vom Amplifier vorliegen
		tst.b	SpecialUPS(A5)		;dann werden diese beiden Kanle benutzt anstelle
		bne.s	nodmacon$		;da vorher noch die 4 Kanle der UPS Struktur
						;zusammengemixed werden mssen, spart Zeit

		moveq	#-1,d2			;Alle Kanle, wenn DMAon/off nicht unterstzt vom
						;Replay
		move.w	ups_flags(a4),d1
		and.w	#UPSB_Dmacon,d1		;Kanle an/aus untersttzt ?
		beq.s	nodmacon$

		move.w	UPS_Dmacon(a4),d2	;Ja,zugehrige Werte ranholen

			;Bitabfolge ndern wegen anderer Abfragereihenfolge der Kanle in dieser
			;Engine (Stimmen 1,4,2,3 wg. 1&4 = links, 2&3=rechts)
		move	d2,d0
		move	d2,d1
		and	#1,d2		;Bit 0 -> Bit 0

		lsr	#2,d0
		and	#2,d0
		or	d0,d2		;Bit 3 -> Bit 1

		and	#%0110,d1
		lsl	#1,d1
		or	d1,d2		;(Bit 1 und 2) << 1
nodmacon$
		lea	FFT_vol64(pc),a2		;fr den Fall, da "Mastervolume" ausgeschaltet

		move.l	myEPBase(pc),a4
		lea	EPG_someprefs(a4),a4
		move.l	(a4),d6
		and.l	#EGPRB_MasterVolume,d6 ;Mastervolume switch im EP an ?
		beq.s	.NoMaster

		move.l	myEPBase(pc),a2
		lea	EPG_Voice1vol(a2),a2	;ok, Lautstrkewerte der einzelnen Stimmen verwenden
.NoMaster

		lea	FFT_Permerk(a5),a3	;SamplePeriod merken und Spielzeit der Samples in 1/50 Sekunden
					;je 32 Bit = 1LW pro Kanal

		move.l	FFT_Structadr(a5),a4	;Analyzer Struktur
		bsr	GetADRLENVOLandPER	;Daten Channel 1 holen

		tst.b	FFT_slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	nomix1$
		lea	FFT_Realtab,a6		;Zieladresse = Eingangswerte der FFT,
						;Reihe 1
		bsr	FFT_ClearArea
		bsr	FFT_Mixit			;Mixen von Channel 1 und 2 bzw. nur Zoom wenn 
						;lediglich ein Channel
nomix1$

		addq.l	#4,a3
		move.l	FFT_Structadr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*3(a4),a4	;4. Stimme
		bsr	GetADRLENVOLandPER	;Daten Channel 2 holen

		tst.b	FFT_slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	nomix2$
		lea	FFT_Realtab,a6		;Zieladresse = Eingangswerte der FFT,
						;Reihe 1
		bsr	FFT_Mixit			;Mixen von Channel 1 und 2 bzw. nur Zoom wenn 
						;lediglich ein Channel
nomix2$

skiphim1$

		addq.l	#4,a3
		move.l	FFT_Structadr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*1(a4),a4	;2. Stimme
		bsr	GetADRLENVOLandPER

		tst.b	FFT_slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	nomix3$
		bsr	FFT_Mixit			;Mixen von Channel 1 und 2 bzw. nur Zoom wenn 
						;lediglich ein Channel
nomix3$
		addq.l	#4,a3
		move.l	FFT_Structadr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*2(a4),a4	;3. Stimme
		bsr	GetADRLENVOLandPER

		tst.b	FFT_slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	nomix4$
		bsr	FFT_Mixit			;Mixen von Channel 1 und 2 bzw. nur Zoom wenn 
						;lediglich ein Channel

		lea	FFT_Imgtab,a4

		tst.b	SpecialUPS(A5)		;dann werden diese beiden Kanle benutzt anstelle
		bne.s	scale2$			;da vorher noch die 4 Kanle der UPS Struktur

		bsr	FFT_ScaleInputs		;Zum Schlu Werte*64 um 6 Bit nach rechts shiften 
						;und in FFT_Realtab und FFT_Imgtab aufteilen fr N/2 FFT
						;reeller Eingangswerte
		bra.s	weiter$
scale2$
		bsr	FFT_ScaleInputs2
weiter$
nomix4$
skipmix$
	else
;--------------------------------- Testroutine -------------------------------------------
		bsr	MakeIntab		;Beispielwerte erzeugen

		lea	Testtab1,a0		;Adresse Daten Kanal 1
		move	#256,d0			;Lnge Kanal 1 (derzeit noch nicht ausgewertet)
		move	#112,d3			;Period Kanal 1
		move	#64,d1			;Lautstrke Kanal 1

		lea	FFT_Realtab,a6		;Zieladresse
		bsr	FFT_ClearArea
		bsr	FFT_Mixit			;2 aus einen zusammenmixen

		lea	Testtab1,a0		;Adresse Daten Kanal 1
		move	#256,d0			;Lnge Kanal 1 (derzeit noch nicht ausgewertet)
		move	#20,d3			;Period Kanal 1
		move	#64,d1			;Lautstrke Kanal 1

		lea	FFT_Realtab,a6		;Zieladresse
		bsr	FFT_Mixit			;2 aus einen zusammenmixen

		lea	Testtab2,a0
		move	#256,d0
		move	#112,d3
		move	#64,d1
		bsr	FFT_Mixit			;2 aus einen zusammenmixen

		lea	Testtab2,a0
		move	#256,d0
		move	#224,d3
		move	#64,d1			;
		bsr	FFT_Mixit
		lea	FFT_Imgtab,a4

		tst.b	SpecialUPS(A5)		;dann werden diese beiden Kanle benutzt anstelle
		bne.s	scale2$			;da vorher noch die 4 Kanle der UPS Struktur
		bsr	FFT_ScaleInputs
		bra.s	weiter$
scale2$
		bsr	FFT_ScaleInputs2
weiter$
	endc
		Pop	all
		rts
;------------------------------------------------------------------------------------------------
;----                                Mixt 2 Stimmen zusammen                                 ----
;------------------------------------------------------------------------------------------------
;Input:
; a0 - Stimme 1 aktuelle Adresse
; d0 - Stimme 1 Restlnge (momentan ignoriert)
; d3 - Stimme 1 Period
; d1 - Stimme 1 Lautstrke (0..64)
; a6 - Zieladresse
; Vtab           - Lautstrketabelle
; Mixfrequency.l - 16384*Per
; Current_Num    - Anzahl der auszugebenden Samplewerte
FFT_Mixit:
		push	all
		move.l	a0,d2
		beq.s	none$

		move.l	FFT_Mixfrequency(a5),d7	;16384*Sampleper (Achtung: erst bei offenem Fenster richtig gesetzt!)
		move.l	d7,d2
		divu 	d3,d2			;Period Kanal 2
		moveq	#0,d3
		move.w	d2,d3
		add.l	d3,d3
		add.l	d3,d3
		swap	d3			;gebrochene Zahl fr die Skalierung beim Mixen

;------------------------ Skalieren (Samplerate+Lautstrke) von 1 Kanal  ---------------------------
		lea	FFT_Windowtable,a1
		move.l	Prefsflags(pc),d6
		and.l	#PFlag_Monoscope,d6
		beq	ok$
		lea	FFT_NonWindow,a1
ok$
		moveq	#0,d6
		moveq	#0,d5			;Zhler fr Offset
		moveq	#0,d2			;Dummy fr addx Befehl
						;D0-Lnge Kanal 2
						;D3-Skalierung Kanal 2
						;A3-Voltab 1
;		move	#N/2-1,d7
		move	FFT_Current_Num(a5),d7	;N
		lsr	#1,d7			;/2
		subq	#1,d7			;-1

		move	d1,d0
FFT_Mixit2$
		move	(a1)+,d1
		move.b	(a0,d5.w),d6
		mulu	d0,d1
		add.l	d3,d5
		ext.w	d6
		swap	d1
		addx	d2,d5
		muls	d1,d6			;Wert mal Lautstrke
		add	d6,(a6)+

		move	(a1)+,d1
		move.b	(a0,d5.w),d6
		add.l	d3,d5
		mulu	d0,d1
		ext.w	d6
		swap	d1
		addx	d2,d5
		muls	d1,d6			;Wert mal Lautstrke
		add	d6,(a6)+
		dbf	d7,FFT_Mixit2$
none$
		pop	all
		rts
;Input:
; A6          - Adresse
; Current_Num - Lnge
FFT_ClearArea:
		push	d7/a6
		move	FFT_Current_Num(a5),d7	;N (Anzahl der Wrter)
		lsr	#1,d7			;/2
		subq	#1,d7			;-1
clr$		clr.l	(a6)+
		dbf	d7,clr$
		pop	d7/a6
		rts
;
;gemixte Werte skalieren und in FFT-Eingangstabellen fr Real-und Imaginrteil aufsplitten
;bei 4 Kanlen wird auf Werte von max. -2048 bis 2048 skaliert
; 
;Input:
; A6          - Adresse FFT_Realtab
; A4          - Adresse FFT_Imgtab
; Current_Num - Lnge
FFT_ScaleInputs:				;Zum Schlu Werte*64 um 7 Bit nach rechts shiften
		push	all
		move	FFT_Current_Num(a5),d7	;N (Anzahl der Wrter)
		lsr	#2,d7			;durch 4
		subq	#1,d7

		lea	(A6),a0
loop$
		movem.w	(a6)+,d0-d3
		asr.l	#3,d0
		asr.l	#3,d2
		asr.l	#3,d1
		asr.l	#3,d3
		movem.l	d0/d2,(a0)		;1./3. Wort
		movem.l	d1/d3,(a4)		;2./4. Wort

		addq.l	#8,a0			;2 LWrter berspringen
		addq.l	#8,a4			;2 LWrter berspringen
		dbf	d7,loop$
		pop	all
		rts
;2 Kanle auf -2048...2048 skalieren
FFT_ScaleInputs2:				;Zum Schlu Werte*64 um 6 Bit nach rechts shiften
		push	all
		move	FFT_Current_Num(a5),d7	;N (Anzahl der Wrter)
		lsr	#2,d7			;durch 4
		subq	#1,d7

		lea	(A6),a0
loop$
		movem.w	(a6)+,d0-d3
		asr.l	#2,d0
		asr.l	#2,d2
		asr.l	#2,d1
		asr.l	#2,d3
		movem.l	d0/d2,(a0)		;1./3. Wort
		movem.l	d1/d3,(a4)		;2./4. Wort

		addq.l	#8,a0			;2 LWrter berspringen
		addq.l	#8,a4			;2 LWrter berspringen
		dbf	d7,loop$
		pop	all
		rts
;-------------- Erzeugen der logarithmischen Umrechnungstsabelle -----------------------
MakeAnalyzertab:
		push	all
		lea	AnalyzerTab2,a0
		lea	FFT_Analyzertab,a1

		move	#FFT_Analyzertabsize-1,d0
		moveq	#0,d2
		moveq	#0,d1
loop$
		cmp.w	(a0),d1
		blt.s	noadd$
		addq	#1,d2
		addq.l	#2,a0
noadd$
		addq	#1,d1
		move.b	d2,(a1)+
		dbf	d0,loop$

		pop	all
		rts
;----------------------- Erzeugen der Bitspiegelungstabelle ----------------------------
MakeBitreversetabs:
		lea	Bitreversetab,a0
		move	#FFT_N-1,d5
		moveq	#FFT_Gamma,d6		;Anzahl der Bits
		moveq	#0,d1
Innerloop1$
		moveq	#0,d3
		move	d1,d2
		move	d6,d7
		subq	#1,d7
Innerloop2$
		roxr	#1,d2
		roxl	#1,d3
		dbf	d7,Innerloop2$
		move	d3,(a0)+

		addq	#1,d1
		dbf	d5,Innerloop1$
		rts
;----------------------- Erzeugen der Sinus-und Cosinustabelle ----------------------------------
;-- die Werte werden gleich bitgespiegelt berechnet, so da die Bitspiegelung zur Adressierung --
;-- der Sinus-bzw. Cosinustabelle entfllt                                                     --
;-- Formel: SINBASE*sin(2*P/GAMMA); P=Bitspiegelung(I); 0<I<N                                 --
;------------------------------------------------------------------------------------------------
;Input:  d1 = Tiefe der FFT: (8 = 256 Punkt, 9 = 512 Punkt usw.)
;        Bitreversetab = Butterflytab (Bitspiegelungstabelle)
;Output: SinCostab = kombinierte Sinus/Cosinustabelle, jedem Wort der Sinuswerte folgt
;                    das Cos-Pendant
;        Berechnung lediglich mit halber Lnge, da jeder 2. Wert ohnehin redundant
	ifeq	USEFPU
MakeSinCostabs:
		push	d0-d7/a0-a6
		moveq	#FFT_Gamma,d1

		moveq	#1,d7			;1
		lsl	d1,d7			;2^Gamma
		move.l	d7,d6			;=N
		lsr	#1,d7
		subq	#1,d7			;N-1 wg. dbf

		lea	SinCostab,a1
		lea	Bitreversetab-SinCostab(a1),a2

		move.l	mathtrans(a5),a3
		move.l	mathffp(a5),a4

		move.l	a4,a6
		move.l	#6283185,d0		;2**10^6
		jsr	_LVOSPFlt(a6)
		move.l	d0,d4

		move.l	#1000000,d0
		jsr	_LVOSPFlt(a6)		;10^6
		move.l	d0,d1

		move.l	d4,d0
		jsr	_LVOSPDiv(a6)		;2
		move.l	d0,d5

		move.l	d6,d0
		jsr	_LVOSPFlt(a6)		;N
		move.l	d0,d1

		move.l	d5,d0
		jsr	_LVOSPDiv(a6)		;2/N
		move.l	d0,d5

		move.l	#2^FFT_SINBASE,d0	;256
		jsr	_LVOSPFlt(A6)
		move.l	d0,d6

		moveq	#0,d4
sincostab1$
		moveq	#0,d0
		move	(a2,d4.w*2),d0		;P=IBR(M)
		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;in FFP umwandeln
		move.l	d5,d1			;2/N
		jsr	_LVOSPMul(a6)		;2/N*P
		move.l	d0,d3
		move.l	a3,a6
		jsr	_LVOSPSin(a6)		;sin(2*P/N)
		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)		;256*sin(...)
		jsr	_LVOSPFix(a6)
		move.l	d0,(a1)+		;sin*256

		move.l	d3,d0
		move.l	a3,a6
		jsr	_LVOSPCos(a6)		;cos(2*P/GAMMA)
		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)		;256*cos(...)
		jsr	_LVOSPFix(a6)
		move.l	d0,(a1)+		;cos*256

		addq	#2,d4		
		dbf	d7,sincostab1$

		pop	d0-d7/a0-a6
		rts
	ELSE
;------------- Erzeugen der Sinus-und Cosinustabelle fr FPU-Operationen ------------------------
;-- die Werte werden gleich bitgespiegelt berechnet, so da die Bitspiegelung zur Adressierung --
;-- der Sinus-bzw. Cosinustabelle entfllt                                                     --
;-- weiterhin werden smtliche Werte gleich so berechnet, da der Adrepointer nur einmal      --
;-- gesetzt werden mu und smtliche Werte fr jeden Schritt sequentiell ausgelesen werden     --
;------------------------------------------------------------------------------------------------
MakeSinCostabsINT:
		lea	SinCostabINT,a0
		lea	Bitreversetab,a2

		move	#FFT_Gamma-2-1,d0	;Anzahl der Durchlufe (die ersten beiden FFT-Runs
						;werden gesondert behandelt, also brauchen wir auch
						;keine Koeffizienten dafr

		moveq	#2,d1		;Anzahl der zu berechnenden Koeffizienten in jedem Schritt,
					;verdoppelt sich bei jedem Durchlauf
		moveq	#4,d2		;Nummer des Sin/Cos Paares, verdoppelt sich bei jedem Durchlauf
loop$
		bsr	make$
		lsl	#1,d1
		lsl	#1,d2
		dbf	d0,loop$

		rts

make$
		move	d1,d4
		subq	#1,d4
		move	d2,d5
sincostab$
		move	(a2,d5.w*2),d3		;P=IBR(M)

		fmove.w	d3,fp1

	if	FFT_Gamma=6
		fmul.x	#6.283185/2^6,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
	if	FFT_Gamma=7
		fmul.x	#6.283185/2^7,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
	if	FFT_Gamma=9
		fmul.x	#6.283185/2^9,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
	if	FFT_Gamma=8
		fmul.x	#6.283185/2^8,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
		Fehler in Gamma !
	endc
	endc
	endc
	endc

		fmove.x	fp1,fp2
		fsin.x	fp1

	if	FFT_SinBase=8
		fmul.x	#256,fp1		;sinbase
	else
	if	FFT_SinBase=12
		fmul.x	#4096,fp1		;sinbase
	else
		Fehler in SinBase
	endc
	endc

		fcos.x	fp2

	if	FFT_SinBase=8
		fmul.x	#256,fp2		;sinbase
	else
	if	FFT_SinBase=12
		fmul.x	#4096,fp2		;sinbase
	else
		Fehler in SinBase
	endc
	endc

		fmove.l	fp1,d6
		move.l	d6,(a0)+		;sin
		fmove.l	fp2,d6
		move.l	d6,(a0)+		;cos

		addq	#2,d5
		dbf	d4,sincostab$
		rts
;------------- Erzeugen der Sinus-und Cosinustabelle fr Integer-Operationen --------------------
;-- die Werte werden gleich bitgespiegelt berechnet, so da die Bitspiegelung zur Adressierung --
;-- der Sinus-bzw. Cosinustabelle entfllt                                                     --
;------------------------------------------------------------------------------------------------
MakeSinCostabsFP:
		lea	SinCostabFP,a0
		lea	Bitreversetab,a2

		move	#FFT_N/2-1,d0		;nur die Hlfte der Sin/Cos Werte werden wirklich gebraucht, der Rest eh sonst bersprungen
		moveq	#0,d1
sincostab$
		move	(a2,d1.w*2),d3		;P=IBR(M)

		fmove.w	d3,fp1

	if	FFT_Gamma=6
		fmul.x	#6.283185/2^6,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
	if	FFT_Gamma=7
		fmul.x	#6.283185/2^7,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
	if	FFT_Gamma=9
		fmul.x	#6.283185/2^9,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
	if	FFT_Gamma=8
		fmul.x	#6.283185/2^8,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
		Fehler in Gamma !
	endc
	endc
	endc
	endc

		fmove.x	fp1,fp2
		fsin.x	fp1
		fmove.s	fp1,(a0)+		;sin

		fcos.x	fp2
		fmove.s	fp2,(a0)+		;cos

		addq	#2,d1		
		dbf	d0,sincostab$
		rts
	ENDC
;----------------------- Erzeugen der Sinus-und Cosinustabelle ----------------------------------
;-- die Werte werden gleich bitgespiegelt berechnet, so da die Bitspiegelung zur Adressierung --
;-- der Sinus-bzw. Cosinustabelle entfllt                                                     --
;-- Formel: SINBASE*sin(2*P/GAMMA); P=Bitspiegelung(I); 0<I<N                                 --
;------------------------------------------------------------------------------------------------
;Input:  d1 = Tiefe der FFT: (8 = 256 Punkt, 9 = 512 Punkt usw.)
;        Bitreversetab = Butterflytab (Bitspiegelungstabelle)
;Output: SinCostab = kombinierte Sinus/Cosinustabelle, jedem Wort der Sinuswerte folgt
;                    das Cos-Pendant
MakeSinCostabs2:
		push	d0-d7/a0-a6
		moveq	#FFT_Gamma,d1

		moveq	#1,d7			;1
		lsl	d1,d7			;2^Gamma
		move.l	d7,d6			;=N
		subq	#1,d7			;N-1 wg. dbf

		lea	Sintab2,a1
		lea	Costab2,a2

		move.l	mathtrans(a5),a3
		move.l	mathffp(a5),a4

		move.l	a4,a6
		move.l	#3141592,d0		;*10^6
		jsr	_LVOSPFlt(a6)
		move.l	d0,d4

		move.l	#1000000,d0
		jsr	_LVOSPFlt(a6)		;10^6
		move.l	d0,d1

		move.l	d4,d0
		jsr	_LVOSPDiv(a6)		;2
		move.l	d0,d5

		move.l	d6,d0
		jsr	_LVOSPFlt(a6)		;N
		move.l	d0,d1

		move.l	d5,d0
		jsr	_LVOSPDiv(a6)		;2/N
		move.l	d0,d5

		move.l	#2^FFT_SINBASE,d0	;256
		jsr	_LVOSPFlt(A6)
		move.l	d0,d6

		moveq	#0,d4
sincostab$
		moveq	#0,d0
		move	d4,d0

		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;in FFP umwandeln
		move.l	d5,d1			;2/N
		jsr	_LVOSPMul(a6)		;2/N*P
		move.l	d0,d3
		move.l	a3,a6
		jsr	_LVOSPSin(a6)		;sin(2*P/N)
		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)		;256*sin(...)
		jsr	_LVOSPFix(a6)
		move.l	d0,(a1)+		;sin*256

		move.l	d3,d0
		move.l	a3,a6
		jsr	_LVOSPCos(a6)		;cos(2*P/GAMMA)
		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)		;256*cos(...)
		jsr	_LVOSPFix(a6)
		move.l	d0,(a2)+		;cos*256

		addq	#1,d4		
		dbf	d7,sincostab$

		pop	d0-d7/a0-a6
		rts


	ifeq	Eagleplayer
;-------------------------- Testroutine ----------------------------------------
MakeIntab:	
		lea	Testtab1,a0
		lea	Testtab2,a1

		moveq	#83,d0			;Rechteckimpuls
.w1		move.b	#127,(a1)+
		dbf	d0,.w1

		move	#0,(a1)+

		moveq	#83,d0
.w2		move.b	#-128,(a1)+
		dbf	d0,.w2

		move	#0,(a1)+

		moveq	#84,d0
.w3		move.b	#127,(a1)+
		dbf	d0,.w3

		move	#256-1,d0
		moveq	#0,d1
		moveq	#0,d3
sincostab$					;3 Sinuswellen erzeugen
		fmove.w	d1,fp1
		fmul.x	#6.283185/2^3,fp1	;Frequenz
		fsin.x	fp1
		fmul.x	#128,fp1			;Amplitude

		fmove.w	d1,fp2
		fmul.x	#6.283185/2^5,fp2	;Frequenz
		fsin.x	fp2
		fmul.x	#32,fp2			;Amplitude
;		fadd.x	fp2,fp1

;		fmove.w	d1,fp2			;ein paar Sinuswellen versch.
;		fmul.x	#6.283185/2^4,fp2	;Frequenz zum rumspielen
;		fsin.x	fp2
;		fmul.x	#32,fp2
;		fadd.x	fp2,fp1

		fmove.w	d1,fp2			;nochn Sinus
		fmul.x	#6.283185/2^3,fp2	;
		fsin.x	fp2
		fmul.x	#64,fp2
		fadd.x	fp2,fp1

		fmove.w	fp1,d2
		add	d3,d2			;RechteckWelle maximaler Frequenz

		move.b	d2,(a0)+
;		move.b	d2,(a0)+

		neg.w	d3
		addq	#1,d1		
		dbf	d0,sincostab$
		rts
Testtab1		ds.w	1024		;fr Inputwerte bei Testroutine
Testtab2		ds.w	1024		;fr Inputwerte bei Testroutine
	endc

;****************************************************************************************
;*                   Blinkanzeige fr Laden/Speichern gepackter Mods                    *
;****************************************************************************************
InitCrunchDisplay:
		Push	d1-a6

		lea	Datas,a5

		moveq	#ID_LoadingLED,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a0
		clr.l	MOL_UserData(a0)

		Pop	d1-a6
		moveq	#0,d0
		rts
error$
		Pop	d1-a6
		moveq	#-1,d0
		rts
CrunchDisplay:
		Push	d1-a6

		lea	Datas,a5

		moveq	#ID_LoadingLED,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a0
		move.l	MOL_UserData(a0),d1
		eor.l	#1,d1
		move.l	d1,MOL_UserData(a0)

		bsr	DisableFXTask

		moveq	#ID_LoadingLED,d0
		bsr	ShowPrefsChange

		bsr	EnableFXTask
error$
		Pop	d1-a6
		moveq	#0,d0			;kein Fehler...
		rts
EndCrunchDisplay:
		Push	d1-a6

		lea	Datas,a5

		moveq	#0,d1
		moveq	#ID_LoadingLED,d0
		bsr	ShowPrefsChange

		Pop	d1-a6
		moveq	#0,d0			;kein Fehler...
		rts

;*************************************************************************************
;*                        Prefsnderungen                                            *
;*************************************************************************************

;--------------------------------------------------------------------------------------
;Input: d1 = 0 -> default Image darstellen, sonst 2. Image
;       d0 = ID des zu suchenden Images
ShowPrefsChange:
		Push	All
		
		bsr	FindObject		;Objekt in Liste finden
		beq	Error$		
		move.l	d0,a0
		move.l	MOL_Images(a0),d2
		beq	Error$

		tst.l	d1
		beq	nosecond$

		move.l	d2,a1
		move.l	IML_Next(a1),d2		;2. Image vorhanden ?
		beq	Error$
nosecond$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
Error$
		Pop	All
		rts

;------------ Input: A0 - Pointer auf Objekt --------------------------------
HandleAnalyzerMode:
;		moveq	#ID_AnalyzerMode,d0

		move.l	Prefsflags(pc),d0		;
		move.l	d0,d1
		move.l	d0,d2
		and.l	#~[PFlag_Monoscope!PFlag_Analyzer],d2
		and.l	#PFlag_Monoscope!PFlag_Analyzer,d1
		beq	analyzeron$
		and.l	#PFlag_Analyzer,d0
		bne.s	monoscopeon$

		moveq	#ID_Analyzeroff,d0
		bsr	FindObject
		beq	set$
		move.l	d0,a0
		move.l	MOL_Images(a0),d3
		beq	set$
		move.w	MOL_Left(a0),d0
		move.w	MOL_Top(a0),d1
		move.l	d3,a0
		suba.l	a1,a1
		bsr	ShowImage

		bra.s	set$
monoscopeon$
		or.l	#PFlag_Monoscope,d2
		bra.s	set$
analyzeron$
		or.l	#PFlag_Analyzer,d2
set$
		move.l	d2,Prefsflags

		move.l	#EPNr_FirstExternal,d0
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
ChangeRandom:
		moveq	#ID_Random,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_Images(a0),d0
		beq	noimg$
		move.l	d0,a2

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d1
	else
		move.l	#EGPRB_Randommodule,d1
	endc
		move.l	Prefsflags(pc),d3
		and.l	#~PFlag_Shuffle,d3

		moveq	#0,d2
		and.l	#EGPRB_Randommodule,d1
		beq.s	clr$
		moveq	#IMF_Inactive,d2

		or.l	#PFlag_Shuffle,d3
clr$
		move.l	d3,Prefsflags

		move.l	IML_Next(a2),d0
		beq	noimg$
		move.l	d0,a1
		tst.l	(a1)			;kein 3. Image -> also nicht die beiden ersten deaktivieren
		beq	noimg$
		move	d2,IML_Flags(a2)
		move	d2,IML_Flags(a1)

		Push	All
		moveq	#ID_Random,d0
		bsr	Findgadget
		tst.l	d0
		beq	no2$
		move.l	d0,a0
		move.l	WinHandle(A5),a1
		suba.l	a2,a2
		moveq	#1,d0
		IB
		CallSys	RefreshGList
no2$
		Pop	All
noimg$
	ifne	Eagleplayer
		moveq	#3,d2			;default: set random

		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d1
		and.l	#EGPRB_Randommodule,d1
		beq.s	setran$
		moveq	#2,d2			;if random -> set loadnext
setran$
		move.l	MOL_Command(a0),d0
		moveq	#0,d1
	endc
error$
		rts

;------------ Input: A0 - Pointer auf Objekt --------------------------------
ChangeSongend:
		moveq	#ID_Songend,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_Images(a0),d0
		beq	noimg$
		move.l	d0,a2

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d1
	else
		move.l	#EGPRB_Songend,d1
	endc
		move.l	Prefsflags(pc),d3
		or.l	#PFlag_Repeat,d3
		
		moveq	#0,d2
		and.l	#EGPRB_Songend,d1
		beq.s	clr$
		moveq	#IMF_Inactive,d2

		and.l	#~PFlag_Repeat,d3
clr$
		move.l	d3,Prefsflags

		move.l	IML_Next(a2),d0
		beq	noimg$
		move.l	d0,a1
		tst.l	(a1)			;kein 3. Image -> also nicht die beiden ersten deaktivieren
		beq	noimg$
		move	d2,IML_Flags(a2)
		move	d2,IML_Flags(a1)

		Push	All
		moveq	#ID_Songend,d0
		bsr	Findgadget
		tst.l	d0
		beq	no2$
		move.l	d0,a0
		move.l	WinHandle(A5),a1
		suba.l	a2,a2
		moveq	#1,d0
		IB
		CallSys	RefreshGList
no2$
		Pop	All
noimg$
		move.l	MOL_Command(a0),d0
		moveq	#0,d1
		move.l	MOL_CMDArg1(a0),d2
		move.l	MOL_CMDArg2(a0),d3
error$
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
ChangeTimeout:
	ifne	Eagleplayer
		moveq	#-1,d2

		move.l	myEPBase(pc),a1
		move.l	EPG_Timeout(a1),d1
		bgt	set0$

		move.l	MOL_UserData(a0),d2	;last timeout value
		bne	set0$
		move.l	#180,d2			;kein letzter Wert -> 180 sek. default
set0$
		move.l	MOL_Command(a0),d0
		moveq	#0,d1
	endc
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
HandleModname:
		Push	All

		tst.l	d0		;Kill Module ?
		bne	nix$		;

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		tst.l	EPG_PlayerTagList(a1)
		beq	nix$
		move.l	EPG_Songname(a1),d0
		beq.s	nix$
	else
		bra.s	nix$
	endc
			lea	Modnametmp(a5),a0
			move.l	d0,a1
			moveq	#31-1,d1
copy$
			move.b	(a1)+,(a0)+
			dbf	d1,copy$
			clr.b	(a0)
			bra	print$
nix$
			lea	Modnametmp(a5),a0
			lea	Defaultname(pc),a1
copy2$
			move.b	(a1)+,(a0)+
			bne	copy2$
print$
		lea	Modnametmp(a5),a0
		move.l	#ID_Textname1,d0
		bsr	PrintText

		Pop	All
		rts		
;------------ Input: A0 - Pointer auf Objekt --------------------------------
HandleBitRate:
		Push	All
		lea	bitratetmp(a5),a0
		clr.b	(a0)

		tst.l	d0		;Kill Module ?
		bne	keinebit$	;

		move.l	#MI_Bitrate,d0
		bsr	FindMITag
		beq.s	keinebit$

		lea	bitratetmp(a5),a0

		divu	#1000,d0		;durch 1000 dividieren
		cmp.l	#999,d0
		bhi	keinebit$

		divu	#100,d0
		add.b	#`0`,d0
		move.b	d0,(a0)+
		clr.w	d0
		swap	d0
		divu	#10,d0
		add.b	#`0`,d0
		move.b	d0,(a0)+
		swap	d0
		add.b	#`0`,d0
		move.b	d0,(a0)+
		clr.b	(a0)
keinebit$
		lea	bitratetmp(a5),a0
		moveq	#ID_Bitrate,d0
		bsr	PrintText
		Pop	All
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
HandleFrequency:
		Push	All

		lea	bitratetmp(a5),a0
		clr.b	(a0)

		tst.l	d0		;Kill Module ?
		bne	keinebit$	;

		move.l	#MI_PlayFrequency,d0
		bsr	FindMITag
		beq.s	keinebit$

		lea	bitratetmp(a5),a0

		divu	#1000,d0		;durch 1000 dividieren
		and.l	#$ffff,d0
		cmp.l	#99,d0
		bhi	keinebit$

		divu	#10,d0
		add.b	#`0`,d0
		move.b	d0,(a0)+
		swap	d0
		add.b	#`0`,d0
		move.b	d0,(a0)+
		clr.b	(a0)
keinebit$
		lea	bitratetmp(a5),a0
		moveq	#ID_Frequency,d0
		bsr	PrintText
		Pop	All
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
HandleStereo:
		Push	All

		move.l	MOL_Images(a0),d1
		beq.s	fail$
		move.l	d1,a1

		tst.l	d0		;Kill Module ?
		bne.s	off$		;

		move.l	#MI_Voices,d0
		bsr	FindMITag
		beq.s	on$			;default: Stereo
		cmp	#1,d0			;<= 1 ?
		ble	off$			;dann Mono
on$
		move.l	IML_Next(a1),d0
		beq.s	off$
		move.l	d0,a1
off$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	a1,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
fail$
		Pop	All
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
HandleMono:
		Push	All

		move.l	MOL_Images(a0),d1
		beq.s	fail$
		move.l	d1,a1

		tst.l	d0		;Kill Module ?
		bne.s	off$		;

		move.l	#MI_Voices,d0
		bsr	FindMITag
		beq.s	off$			;default: Stereo
		cmp	#1,d0			;<= 1 ?
		bgt	off$			;dann Mono
on$
		move.l	IML_Next(a1),d0
		beq.s	off$
		move.l	d0,a1
off$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	a1,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
fail$
		Pop	All
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
InitPatternDisp:
		tst	d0
		bne	keinepos2$

		move.l	#MI_Length,d0
		bsr	FindMITag
		beq.s	keinepos2$

		lea	PattTmp+3(a5),a0
		move.b	#`/`,(a0)+
		moveq	#3,d1
		bsr	HexDez
		clr.b	(a0)
		bra	PatternDisp
keinepos2$
		lea	PattTmp+3(a5),a0
		move.b	#`/`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		clr.b	(a0)
		bra	PatternDisp
;------------ Input: A0 - Pointer auf Objekt --------------------------------
PatternDisp:
		move.l	#EP_GetPositionNr,d0
		bsr	FindPlTag
		beq.s	keinepos$
		Push	d1-a6
		move.l	d0,a6
	ifne	Eagleplayer
		move.l	myEPBase(pc),a5
		moveq	#0,d0
		jsr	(a6)
	endc
		Pop	d1-a6

		lea	PattTmp(a5),a0
		moveq	#3,d1
		bsr	HexDez
		bra.s	disp$
keinepos$
		lea	PattTmp(a5),a0
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
disp$
		lea	PattTmp2(a5),a0
		lea	Patternname(pc),a1
copy1$
		move.b	(a1)+,(a0)+
		bne.s	copy1$
		subq.l	#1,a0
		
		lea	PattTmp(a5),a1
copy2$		move.b	(a1)+,(a0)+
		bne.s	copy2$

		lea	PattTmp2(a5),a0
		move.l	#ID_TextPattern1,d0
		bsr	PrintText
		rts
;--------- Input: A0 - Pointer auf Objekt --------------------------------
HandlePlayLED:
		move.l	MOL_Images(a0),d2		;Stop,Play,Pause,Leer
		beq	noimage$

		ifne	Eagleplayer
			move.l	myEPBase(pc),a1
			move.l	EPG_SomePrefs(a1),d1
			btst	#EGPRF_PausePlay,d1
			beq	nopause$

			move.l	d2,a1
			move.l	IML_Next(a1),d2
			beq	noimage$
			move.l	d2,a1			;Play
			move.l	IML_Next(a1),d2
			beq	noimage$
			move.l	d2,a1			;Pause

			move.l	MOL_UserData(a0),d0
			eor.l	#1,d0
			move.l	d0,MOL_UserData(a0)
;			beq	Show$			;Blink Leer
;			move.l	IML_Next(a1),d2		;Leer
;			beq	noimage$
			bra	Show$
nopause$
			btst	#EGPRF_NowPlay,d1
			beq	noplay$

			move.l	d2,a1
			move.l	IML_Next(a1),d2
			beq	noimage$
;			move.l	d2,a1			;Play

			clr.l	MOL_UserData(a0)
			bra	Show$
noplay$
			clr.l	MOL_UserData(a0)
		endc
Show$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
noimage$
		rts
;--------- Input: A0 - Pointer auf Objekt --------------------------------
;-- !! NumbersImage ist hardcoded, hier 32+0 = "0", 32+10 = " "
;
HandleShowTime:
		moveq	#0,d6				;

		moveq	#ID_PlayIndicator,d0
		bsr	FindObject
		beq	nodisable$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d6		;nichts darstellen ?
nodisable$
	;1. Minuszeichen anzeigen
		moveq	#ID_TimeMinus,d0
		bsr	FindObject
		beq	nominus$
		move.l	d0,a0
		move.l	MOL_Images(a0),a1

		tst.l	d6
		bne	normal$
	ifne	Eagleplayer
		move.l	EUS_Structure+EUS_EPBase(pc),a2
		tst.l	EPG_CurrentTime(a2)
		blt.s	normal$

		move.l	Prefsflags(pc),d1
		and.l	#PFlag_TimeBackwards,d1		;Zeit rckwrts laufen lassen ?
		beq.s	normal$

		move.l	EPG_Duration(a2),d1		;berechnete Spielzeit in sec.
		ble.s	normal$
	endc
		move.l	IML_Next(a1),d2
		beq	normal$
		move.l	d2,a1
normal$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	a1,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
nominus$
		tst.l	d6			;nichts darstellen ?
		bne	def$
	;2. Anzeige der Zeitangabe
	;2.1 Unterscheidung rckwrts<->vorwrts, Zeitwert holen
	ifne	Eagleplayer
		move.l	EPG_CurrentTime(a2),d7
		ble.w	def$

		move.l	Prefsflags(pc),d1
		and.l	#PFlag_TimeBackwards,d1		;Zeit rckwrts laufen lassen ?
		beq.s	normal2$

		move.l	EPG_Duration(a2),d1		;berechnete Spielzeit in sec.
		ble.s	normal2$
		move.l	d1,d7

		sub.l	EPG_CurrentTime(a2),d7		;- gespielte Zeit
		bge	normal2$
		moveq	#0,d7				;falls ber die berechnete Zeit gespielt, -0 anzeigen
normal2$
	else
		moveq	#100,d7
	endc
		move.l	d7,d1
	;2.2 Display
		lea	timetmp(a5),a0
		clr.b	1(a0)

		divu	#60,d1
		move	d1,d0			;Minutes
		swap	d1			;Seconds
		and.l	#$ff,d1
		and.l	#$ffff,d0

		divu	#10,d0
		cmp.w	#9,d0
		ble.s	lo$
		moveq	#9,d0
lo$
		add.b	#32,d0
		move.b	d0,(a0)

		moveq	#ID_TimeDisplay,d2
		bsr	print$

		swap	d0
		add.b	#32,d0
		move.b	d0,(a0)

		moveq	#ID_TimeDisplay2,d2
		bsr	print$

		divu	#10,d1
		add.b	#32,d1
		move.b	d1,(a0)

		moveq	#ID_TimeDisplay3,d2
		bsr	print$

		swap	d1
		add.b	#32,d1
		move.b	d1,(a0)

		moveq	#ID_TimeDisplay4,d2
		bsr	print$

		bra	show$
def$
		lea	timetmp(a5),a0
		move.b	#32+10,(a0)		;
		clr.b	1(a0)

		moveq	#ID_TimeDisplay,d2
		bsr	print$
		moveq	#ID_TimeDisplay2,d2
		bsr	print$
		moveq	#ID_TimeDisplay3,d2
		bsr	print$
		moveq	#ID_TimeDisplay4,d2
		bsr	print$
show$
		rts
print$
		Push	All
		lea	timetmp(A5),a0
		move	d2,d0
		bsr	PrintText
		Pop	All
		rts

;long$
;	Push	d0-d4/a1
;	moveq	#8,d1
;	lea	dectable(pc),a1
;	moveq	#0,d4
;loopl$
;	moveq	#-1,d3
;	move.l	-(a1),d2
;loop2l$
;	addq.b	#1,d3
;	sub.l	d2,d0
;	bcc.s	loop2l$
;	add.l	d2,d0
;	cmp.l	#1,d2
;	beq.s	okl$
;	tst.b	d4
;	bne.s	okl$
;	tst.b	d3
;	beq.s	nol$
;okl$
;	moveq	#1,d4
;	add.b	#`0`,d3
;	move.b	d3,(a0)+
;nol$
;	dbf	d1,loopl$
;	Pop	d0-d4/a1
;	rts
;-------------------------------------------------------------------------------
;- Input: d0 = Zahl
;-        d1 = Anzahl der Stellen, leading Zeroes nicht wegschneiden
;-        a0 = Puffer
;-------------------------------------------------------------------------------
HexDez:
	Push	d0-d7/a1
	lea	dectable2(pc),a1
	move	d1,d2
	lsl	#2,d2
	add.w	d2,a1			;Stelle raussuchen

	subq	#1,d1
loopl$
	moveq	#-1,d3
	move.l	-(a1),d2
loop2l$
	addq.b	#1,d3
	sub.l	d2,d0
	bcc.s	loop2l$
	add.l	d2,d0
	add.b	#`0`,d3
	move.b	d3,(a0)+
	dbf	d1,loopl$

	Pop	d0-d7/a1
	rts
dectable2:
	dc.l	1,10,100,1000,10000,100000,1000000,10000000,100000000
dectable:

;------------------------------------------------------------------------------------------------
;--------------- Restadresse, Restlnge, Lautstrke und Period-Wert aus der UPS-Struktur --------
;--------------- auslesen                                                                --------
;------------------------------------------------------------------------------------------------
;Input: d2 = DMA Mask (Bit 0 = dieser Kanal)
;       a3 = Zwischenspeicher fr Period und Spielzeit in 1/50 s des Samples des 
;            aktuellen Kanals (macht zwei Wrter)
;       a4 = UPS_Strukturanfang des aktuellen Kanals
;       a2 = Lautstrketabelle (Wrter, je eines pro Kanal, 0...64)
;            Wenn Mastervolumeuntersttzung nicht erwnscht, dann siehe unten
;
;Output:  d2 = DMA Mask fr nchsten Kanal (um 1 Bit gegenber Eingangswert nach rechts
;              geshiftet)
;         a2 = Pointer auf Lautstrke fr nchsten Kanal (Wort)
;         a3 (unverndert)
;         a4 (unverndert)
;         a0 = Adresse des Samples
;         d0 = Restlnge
;         d1 = Lautstrke
;         d3 = Period
GetADRLENVOLandPER:
		Push	d4
		suba.l	a0,a0

		lsr.w	#1,d2
		bcc.w	.no
		move.l	UPS_Voice1Adr(a4),d1
		beq.s	.null
		move.l	d1,A0
		move.w	UPS_Voice1Per(a4),d3
		beq.s	.ok
		move.w	d3,(a3)
		clr.w	2(a3)

		moveq	#0,d4
		moveq	#0,d0
		move.w	UPS_Voice1Len(a4),d0
		add.l	d0,d0		;Samplelnge Words -> Samplelnge Bytes
		bra.s	.cbm_ok		;bra.s	.copyto
.ok
		move	(a3),d3		;berhaupt keine Sampleperiod bergeben ?
		bne.s	.copyto
.null
		suba.l	a0,a0		;lea	nulls(a5),a0
		moveq	#0,d0		;move.w	#700,d0
		moveq	#0,d1
		bra.s	.no
.copyto
		moveq	#0,d0
		move.w	UPS_Voice1Len(a4),d0
		add.l	d0,d0		;Samplelnge Words -> Samplelnge Bytes

		moveq	#0,d4
		move.w	2(a3),d4
		cmp.w	#$180,d4	;nur zur Sicherheit
		blo.s	.hi1
		clr.w	2(A3)
		clr.w	d4
.hi1
		swap	d4		;=d4*65535
		lsr.l	#2,d4
		divu	(a3),d4		;durch Sampleperiod
		and.l	#$ffff,d4
		lsl.l	#2,d4
		cmp.l	d0,d4		;grer als Samplelnge ?
		blo.s	.cbm_ok

		tst.w	UPS_Voice1Repeat(a4)
		beq.s	.cbm_loop

		suba.l	a0,a0		;lea	nulls(a5),a0
		subq.w	#1,2(a3)
		clr.w	(a3)
		moveq	#0,d4
		moveq	#0,d0		;move.w	#700,d0
		bra.s	.cbm_ok
.cbm_loop
		tst.l	d0
		bne.s	.divu
		clr.w	2(a3)
		moveq	#0,d4
		move.w	#700,d0
		bra.s	.cbm_ok
.divu
		divu	d0,d4
		swap	d4
;		clr.w	2(a3)		;bloss raus lassen, dann sieht es
					;nochmal so gut aus !!
		and.l	#$ffff,d4
.cbm_ok
		add.l	d4,a0			;Sampleadr
						;D0: Samplelen
						;D3: SamplePer

		move.w	UPS_Voice1Vol(a4),d1	;

		mulu	(A2)+,d1		;Mastervolume
		lsr.w	#6,d1			;kann normalerweise auch rausgelassen werden

		cmp	#63,d1
		bls.s	.vol_ok
		moveq	#63,d1
.vol_ok
		addq.w	#1,2(a3)
.no
		Pop	d4
		rts
;********************************************************************************************
;*                                                                                          *
;*                                   Datenbereich                                           *
;*                                                                                          *
;********************************************************************************************
vol64	dc.w	64,64,64,64	;fr Behandlung der UPS Struktur (Analyzer, Levelmeter usw.)

;--------- Flags fr diese Engine und deren verschiedene Einstellungen  ---------------------

PFlag_Monoscope		EQU	1<<21	;1 - Monoscope an
PFlag_Shuffle		EQU	1<<22	;1 - EP hat Randommodule an
PFlag_Repeat		EQU	1<<23	;1 - EP hat Songend aus
PFlag_Analyzer		EQU	1<<24	;1 - Analyzer an
PFlag_Clutterbar	EQU	1<<25	;1 - Clutterbar immer anzeigen
PFlag_TitleOnly		EQU	1<<26	;1 - nur Name / Powerschalter
PFlag_Double		EQU	1<<27	;1 - Doppelte Gre
PFlag_TimeBackwards	EQU	1<<28	;1 - Zeit rckwrts laufen lassen
PFlag_AnalyzerPower	EQU	1<<29	;1 - Analyzer an
PFlag_PaletteMode	EQU	1<<30	;1 - Allozierung der Farben im "Exakt" Modus
PFlag_CommandBar	EQU	1<<31	;1 - Untere Klappe geffnet


myNR_ToggleFlag	EQU	EPNr_FirstExternal+1	;Prefsflag umkehren, in MOL_CMDArg1 Flag(s) als
                                                ;Langwort, in MOL_CMDArg2 Flags dazu, z.B.
                                                ;ob Windowrefresh (close/reopen) ntig

		BITDEF	TOGG,Winrefresh,0	;Winrefresh ja oder nein bei ToggleFlag
		BITDEF	TOGG,ChangeImages,1	;Palette ndern oder nicht

	*------ Menu -------*
GuiMenu:	dc.l	0			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$52
		dc.l	0
		dc.l	.IText
		ds.b	6
		dc.l	SubItem1
		dc.l	0		*Kick2.0+ ??
.IText:		dc.w	3,0,0,1
		dc.l	0
		dc.l	SubItem.MSG
		dc.l	0
		dc.w	0			;No Nummer

	*----- SubItem 1 -----*
SubItem1:	dc.l	EPM_Barlabel		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15b
		dc.l	0
		dc.l	.IText1
		ds.b	12
		dc.l	0			;*Kick2.0+ ??
.IText1:	dc.w	3,0,20,1
		dc.l	0
		dc.l	SubItem1.Msg
		dc.l	0	
		dc.w	MI_Precisionselect

	*------- Barlabel ------*
EPM_Barlabel:	dc.l	EPM_SetDouble		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	6			;Hight-Size
		dc.w	$c0
		dc.l	0
		dc.l	.BarlabelImage
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.BarlabelImage:	dc.b	0,2			*FronPen/BackPen
		dc.w	2,0			*DrawMode/KludgeFill // LeftEdge
		dc.w	2			*TopEdge
		dc.l	0			*Font
		dc.l	1			*ITIText
		dc.l	0			*NextText
		dc.w	0			*EPNr
		dc.w	0			*LocaleNr

	*------- Set/Clr Double Size ------*
EPM_SetDouble	dc.l	EPM_SetShade		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15b
		dc.l	0
		dc.l	.SetSkinIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.SetSkinIText:	dc.w	3,0,20,1
		dc.l	0
		dc.l	SubItem3.Msg
		dc.l	0	
		dc.w	MI_SetDouble

	*------- Set/Clr minimized mode ------*
EPM_SetShade:	dc.l	EPM_Barlabel2		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15b
		dc.l	0
		dc.l	.SetSkinIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.SetSkinIText:	dc.w	3,0,20,1
		dc.l	0
		dc.l	SubItem4.Msg
		dc.l	0
		dc.w	MI_SetShade

	*------- Barlabel ------*
EPM_Barlabel2:	dc.l	EPM_SetSkin		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	6			;Hight-Size
		dc.w	$c0
		dc.l	0
		dc.l	.BarlabelImage
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.BarlabelImage:	dc.b	0,2			*FronPen/BackPen
		dc.w	2,0			*DrawMode/KludgeFill // LeftEdge
		dc.w	2			*TopEdge
		dc.l	0			*Font
		dc.l	1			*ITIText
		dc.l	0			*NextText
		dc.w	0			*EPNr
		dc.w	0			*LocaleNr

	*------- Set Skin and Save Config ------*
EPM_SetSkin	dc.l	0			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$52
		dc.l	0
		dc.l	.SetSkinIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.SetSkinIText:	dc.w	3,0,20,1
		dc.l	0
		dc.l	SubItem2.Msg
		dc.l	0	
		dc.w	MI_SetSkin
	even
;---------------------------------------------------------------------------------------------
;-                         Tabelle fr Vblank-Messageverteiler                               -
;- 1. LW: ID des aufzurufenden Objekts (in `MOL_React` Pointer auf abzuarbeitende Routine)   -
;- 2. LW: Anzahl der abzuwartenden Ticks pro Aufruf                                          -
;---------------------------------------------------------------------------------------------
Interrupttable:
	ifeq	FXTask
		dc.l	ID_PlayIndicator,50
		dc.l	ID_TimeDisplay,10
		dc.l	ID_Levelmeter,1
		dc.l	ID_Volumeknob2,40
		dc.l	ID_AnalyzerMap,0
		dc.l	0,0
	else
		dc.l	ID_PlayIndicator,30
		dc.l	ID_TimeDisplay,10
		dc.l	ID_Levelmeter,0
		dc.l	ID_Volumeknob2,20
		dc.l	ID_AnalyzerMap,0
		dc.l	0,0
	endc
;---------------------------------------------------------------------------------------------
;-                  Tabelle fr Aktionen bei "NewModule"                                     -
;---------------------------------------------------------------------------------------------
NewModuletable:
	dc.l	ID_Textname1
	dc.l	ID_TextSoundsys1
	dc.l	ID_TextPatternInit1
	dc.l	ID_TextSubsong1
	dc.l	ID_TextTrack1
	dc.l	ID_TextTrack2
	dc.l	ID_TimeDisplay
	dc.l	ID_Speedknob
	dc.l	ID_PlayIndicator
	dc.l	ID_Bitrate
	dc.l	ID_Frequency
	dc.l	ID_Stereo
	dc.l	ID_Mono
	dc.l	0

;---------------------------------------------------------------------------------------------
;-                  Tabelle fr Aktionen bei "Changeprefs"                                   -
;- 1. LW: PrefsItem                                                                          -
;- 2. LW: aufzurufende Routine                                                               -
;---------------------------------------------------------------------------------------------
NewPrefstable:
	dc.l	EPNr_ProgramMode,ChangeRandom
	dc.l	EPNr_SongEnd,ChangeSongend
	dc.l	EPNr_SongName,HandleModname
	dc.l	EPNr_Prefix,HandleModname

	dc.l	EPNr_Volume,NewVolume
	dc.l	EPNr_Balance,NewBalance

	dc.l	EPNr_FirstExternal,HandleBitrate
	dc.l	EPNr_FirstExternal,HandleFrequency
	dc.l	EPNr_FirstExternal,HandleClutterbar
	dc.l	0,0

;---------------------------------------------------------------------------------------------
;-                  Tabelle fr Aktionen bei "Changegui"                                     -
;- 1. LW: EPNr                                                                               -
;- 2. LW: interne ID des Objektes                                                            -
;- 3. LW: momentaner Zustand, 0 = enabled                                                    -
;---------------------------------------------------------------------------------------------
NewGuitable:
	dc.l	EPNr_NextModule,ID_NextMod,0
	dc.l	EPNr_PrevModule,ID_PrevMod,0
	dc.l	0,0
;------------------------------------------------------------------------------------------
;------------------------- Tabellen der Messageclasses -----------------------------------------
; Aufruf der jeweiligen Funktionen:
; A5 - lokale Variablentabelle
; A1 - Pointer auf IntuiMessage
;
; alle Register drfen getrashed werden 
;
;--- Tabelle 1 fr die Aktionen vor dem Reply der Message
IDCMPtable1:
		dc.l	0,0
;--- Tabelle 2 fr die Aktionen nach dem Reply der Message
IDCMPtable2:
		dc.l	IDCMP_IDCMPUPDATE,HandleGadgets2
		dc.l	IDCMP_GADGETDOWN,HandleGadgets
		dc.l	IDCMP_GADGETUP,HandleGadgets
		dc.l	IDCMP_MOUSEMOVE,HandleGadgets3
		dc.l	IDCMP_CLOSEWINDOW,HandleWinClose
		dc.l	IDCMP_CHANGEWINDOW,HandleChangewin
		dc.l	IDCMP_REFRESHWINDOW,HandleWinRefresh
		dc.l	IDCMP_ACTIVEWINDOW,HandleActiveWindow
		dc.l	IDCMP_INACTIVEWINDOW,HandleInActiveWindow
		dc.l	0,0

;--------- ID Nummern der verschiedenen Objekte, anhand derer sie in der Liste ---------------
;--------- wiedergefunden werden knnen                                        ---------------
		rsreset
ID_None			rs.b	1
ID_Backdrop		rs.b	1	;StandardNummer, wird gesucht fr Backdrop Images, kann auch mehrfach auftreten
ID_Quit			rs.b	1	;Quit
ID_ActiveWindow		rs.b	1	;Image fr aktive Titelzeile
ID_InActiveWindow	rs.b	1	;Image fr inaktive Titelzeile
ID_Iconify		rs.b	1	;Iconify Eagleplayer
ID_Random		rs.b	1	;switch zwischen Nextmodule/RandomModule
ID_Play			rs.b	1	;
ID_Stop			rs.b	1	;
ID_NextMod		rs.b	1	;
ID_PrevMod		rs.b	1	;
ID_Pause		rs.b	1	;Pause
ID_Songend		rs.b	1	;Songend (wird invers dargestellt, wegen des Loop-Images)
ID_Numbers		rs.b	1	;Daten der Ziffern fr Zeitanzeige
ID_TimeDisplay		rs.b	1	;Spielzeitanzeige (1. Ziffer)
ID_TimeDisplay2		rs.b	1	;Spielzeitanzeige (2. Ziffer)
ID_TimeDisplay3		rs.b	1	;Spielzeitanzeige (3. Ziffer)
ID_TimeDisplay4		rs.b	1	;Spielzeitanzeige (4. Ziffer)
ID_TimeMinus		rs.b	1	;Minuszeichen fr Zeitanzeige
ID_Volume		rs.b	1	;Lautstrkeregler
ID_Volumeknob		rs.b	1	;LED fr den Lautstrkeregler
ID_Volumeknob2		rs.b	1	;LED fr den Lautstrkeregler (muted)
ID_Volumeanim		rs.b	1	;die beiden Zustnde der Lautstrkeregelung
ID_Balance		rs.b	1	;Balanceregler
ID_Balanceknob		rs.b	1	;LED fr den Balanceregler
ID_Balanceknob2		rs.b	1	;LED fr den Lautstrkeregler (muted)
ID_Balanceanim		rs.b	1	;die beiden Zustnde der Balanceregelung
ID_Textname1		rs.b	1	;Graphikobjekt fr Namensanzeige
ID_Font1		rs.b	1	;6*5 Font
ID_LoadingLED		rs.b	1	;blink-LED beim Laden/Speichern gepackter Mods
ID_Bitrate		rs.b	1	;Bitratenanzeige
ID_Frequency		rs.b	1	;Abspielfrequenz
ID_Clutterbar		rs.b	1	;
ID_ClutterbarAnim	rs.b	1	;
ID_Optionsmenu		rs.b	1	;
ID_Skinselect		rs.b	1	;Auswahl von Skins
ID_DoubleMode		rs.b	1	;Doublemode an/aus
ID_ToggleClutterbar	rs.b	1	;Clutterbar an/aus
ID_AnalyzerMap		rs.b	1	;temp. Array fr Analyzer-Imagedaten
ID_AnalyzerMode		rs.b	1	;Button fr Analyzer Modusumschaltung
ID_Analyzeroff		rs.b	1	;Image fr auscgeschalteten Analyer
ID_Stereo		rs.b	1	;Image fr StereoAnzeige an/aus
ID_Mono			rs.b	1	;Image fr MonoAnzeige an/aus

ID_PlayIndicator	rs.b	1	;BlinkAnzeige fr Play
ID_DiskButton		rs.b	1
ID_Record		rs.b	1	;save Module
ID_Font2		rs.b	1	;5*4 Font
ID_TextSoundsys1	rs.b	1	;Graphikobjekt fr SoundsystemAnzeige
ID_TextPattern1		rs.b	1	;Graphikobjekt fr PatternnummerAnzeige
ID_TextPatternInit1	rs.b	1	;Dummyobjekt fr PatternnummerAnzeige
ID_TextSubsong1		rs.b	1	;Graphikobjekt fr SubSongNummerAnzeige
ID_TextTrack1		rs.b	1	;Trackanzeige Teil 1 (grogeschrieben)
ID_TextTrack2		rs.b	1	;Trackanzeige Teil 2 (kleingeschrieben)
ID_AnalyzerOnOff	rs.b	1	;Analyzer ein/aus switch
ID_ZipWinOnOff		rs.b	1	;ZipWindow (minimized) ein/aus switch
ID_AnalyzerUp		rs.b	1	;Analyzer nach oben switch
ID_RemoteOnOff		rs.b	1	;Remote an/aus switch
ID_PrevSong		rs.b	1	;
ID_PrevPos		rs.b	1	;
ID_Filter		rs.b	1	;default Filter setting
ID_Timeout		rs.b	1	;setzt Max Playtime entweder auf vorgegebenen Wert oder 0
ID_Fadein		rs.b	1	;Fadein an/aus

ID_SongendLED		rs.b	1	;Indikator-LED`s fr verschiedene Prefszustnde
ID_FilterLED		rs.b	1	;
ID_RandomLED		rs.b	1	;
ID_TimeoutLED		rs.b	1	;
ID_FadeinLED		rs.b	1	;
ID_SetTimeout		rs.b	1	;
ID_Levelmeter		rs.b	1	;Aussteuerungsanzeige
ID_SetTimeBackwards	rs.b	1	;Zeitanzeige vorwrts/rckwrts
ID_RVolume		rs.b	1	;Lautstrkeregler fr Remote
ID_Mute			rs.b	1	;Mute an/aus
ID_Speed		rs.b	1	;Speedregler
ID_Speedanim		rs.b	1	;Anim fr Speedregler
ID_Speedknob		rs.b	1	;Knopf (Knpfe) fr Speedregler
ID_ShowActiveAmplifier	rs.b	1	;momentan aktiven Amplifier anzeigen
ID_ShowDLViewer		rs.b	1	;Dirlistviewer an/aus
ID_Analyzerstates	rs.b	1	;Bitmaps fr versch. Ausschlge des Analyzers
ID_AnalyzerPSW		rs.b	1	;Power Switch Analyzer
ID_AnalyzerPLED		rs.b	1	;LED Power Switch Analyzer
ID_ShowManager		rs.b	1	;Manager an/aus
ID_ShowAmpManager	rs.b	1	;Amplifiermanager an/aus
ID_ShowModinfo		rs.b	1	;Moduleinfo an/aus
ID_ShowFormatloader	rs.b	1	;Formatloader an/aus
ID_TrayAnim		rs.b	1	;Animation fr Schublade
ID_CommandBarAnim	rs.b	1	;Animation fr Kommandoklappe
ID_CommandBarOn		rs.b	1	;Klappe auf
ID_CommandBarOff	rs.b	1	;Klappe zu

;-------------------------- Beschreibungen des Fensters ----------------------------
;abhngig von aktuellen Prefs: Gre, Objekte, Fonts usw.
;momentan eine globale Farbpalette vorgesehen, aber auch das soll kein Prob. sein
;
;momentane Einschrnkungen: - es mssen jeweils die Modi mit GESETZTEN Flags zuerst stehen,
;                             da sonst auf andere Einstellungen zurckgegriffen wird, siehe
;                             bei "OpenWin:"
;                           - die Flags und IDCMP-Flags mssen in der momentanen Arbeitsweise
;                             grundstzlich gleich sein fr alle Modi, da beim Umschalten das
;                             Fenster NICHT mehr geschlossen wird, sondern lediglich die
;                             Gre angepat wird (wesentlich schneller)
;
;
Windowlist:

		dc.l	titleonlyd,PFlag_TitleOnly!PFlag_Double
		dc.l	titleonly,PFlag_TitleOnly

	ifeq	Eagleplayer
;		dc.l	withanalyzerUp,0	;testhalber
;		dc.l	minimized,0		;testhalber
	endc
		dc.l	normald,PFlag_Double
		dc.l	normal,0					;Flags=0 -> default
		dc.l	0,0						;Ende der Liste

;--------------------------------------------------------
titleonlyd:
	dc.w	100	;Left
	dc.w	100	;Top
	dc.w	550	;Width
	dc.w	26	;Height
	dc.l	WFLG_BORDERLESS!WFLG_SMART_REFRESH
	dc.l	IDCMP_INACTIVEWINDOW!IDCMP_ACTIVEWINDOW!IDCMP_IDCMPUPDATE!IDCMP_MOUSEMOVE!IDCMP_REFRESHWINDOW!IDCMP_CHANGEWINDOW!IDCMP_CLOSEWINDOW!IDCMP_VANILLAKEY!IDCMP_RAWKEY!IDCMP_MENUPICK!BUTTONIDCMP!IDCMP_GADGETDOWN
	dc.l	titleonlydobj

titleonlydobj:

PowerObject14D:
	MO_Object	ActiveWindowObject14D,GLA_WinClose,ID_Quit,0,12,6,18,18,PowerImage1D,GACT_RELVERIFY,0,EPNr_Quit,0,0,0
ActiveWindowObject14D:
	MO_Object	InActiveWindowObject14D,GLA_Image,ID_ActiveWindow,0,0,0,550,26,ActiveWindowImage2D,0,0,0,0,0,0
InActiveWindowObject14D:
	MO_Object	DragObject14D,GLA_Image,ID_InActiveWindow,0,0,0,550,26,InActiveWindowImage2D,0,0,0,0,0,0
DragObject14D:
	MO_Object	ZipWinObject14D,GLA_WinDrag,0,0,38,0,128,26,0,0,0,0,0,0,0
ZipWinObject14D:
	MO_Object	WinUpfrontObject14D,GLA_Button,ID_ZipWinOnOff,0,508,6,18,18,ZipWinImageT1D,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_TitleOnly,TOGGF_Winrefresh,0
WinUpfrontObject14D:
	MO_Object	IconifyObject14D,GLA_WinDepth,ID_None,0,528,6,18,18,WinUpfrontImage1D,0,0,0,0,0,0
IconifyObject14D:
	MO_Object	PauseObject14D,GLA_Button,ID_Iconify,0,488,6,18,18,IconifyImage1D,GACT_RELVERIFY,0,EPNr_Iconify,1,0,0
PauseObject14D:
	MO_Object	PlayObject14D,GLA_Button,ID_Pause,0,372,6,20,18,0,GACT_RELVERIFY,0,EPNr_Play,0,0,0
PlayObject14D:
	MO_Object	StopObject14D,GLA_Button,ID_Play,0,352,6,20,18,0,GACT_RELVERIFY,0,EPNr_Play,1,0,0
StopObject14D:
	MO_Object	NextModObject14D,GLA_Button,ID_Stop,0,392,6,18,18,0,GACT_RELVERIFY,0,EPNr_StopPlay,1,0,0
NextModObject14D:
	MO_Object	PrevModObject14D,GLA_Button,ID_NextMod,0,410,6,16,18,0,GACT_RELVERIFY,0,EPNr_NextModule,1,0,0
PrevModObject14D:
	MO_Object	DiskObject14D,GLA_Button,ID_PrevMod,0,336,6,16,18,0,GACT_RELVERIFY,0,EPNr_PrevModule,1,0,0
DiskObject14D:
	MO_Object	TimeDisplayObject14D,GLA_Button,ID_DiskButton,0,430,6,18,18,0,GACT_RELVERIFY,HandleLoadModule,EPNr_LoadModule,0,0,0
TimeDisplayObject14D:
	MO_Object	TimeDisplayObject24D,GLA_TextField,ID_TimeDisplay,0,270,8,10,12,TimeTempNImage14D,0,HandleShowTime,0,0,0,NumbersObject14D
TimeDisplayObject24D:
	MO_Object	TimeDisplayObject34D,GLA_TextField,ID_TimeDisplay2,0,280,8,10,12,TimeTempNImage14D,0,HandleShowTime,0,0,0,NumbersObject14D
TimeDisplayObject34D:
	MO_Object	TimeDisplayObject44D,GLA_TextField,ID_TimeDisplay3,0,294,8,10,12,TimeTempNImage14D,0,HandleShowTime,0,0,0,NumbersObject14D
TimeDisplayObject44D:
	MO_Object	TimeMinusObject14D,GLA_TextField,ID_TimeDisplay4,0,304,8,10,12,TimeTempNImage14D,0,HandleShowTime,0,0,0,NumbersObject14D
TimeMinusObject14D:
	MO_Object	NumbersObject14D,GLA_Image,ID_TimeMinus,0,260,8,10,12,TimeMinusImage14D,0,HandleShowTime,0,0,0,0
NumbersObject14D:
	MO_Object	LevelmeterMapObject14D,GLA_Image,ID_Numbers,0,0,0,100,12,NumbersImage14D,0,0,0,0,0,10
LevelmeterMapObject14D:
	MO_Object	0,GLA_Image,ID_Levelmeter,0,79*2,5*2,38*2,2*2,LevelmeterMapImageD,0,DoLevelmeter,0,0,0,0

;--------------------------------------------------------
titleonly:
	dc.w	100	;Left
	dc.w	100	;Top
	dc.w	275	;Width
	dc.w	13	;Height
	dc.l	WFLG_BORDERLESS!WFLG_SMART_REFRESH
	dc.l	IDCMP_INACTIVEWINDOW!IDCMP_ACTIVEWINDOW!IDCMP_IDCMPUPDATE!IDCMP_MOUSEMOVE!IDCMP_REFRESHWINDOW!IDCMP_CHANGEWINDOW!IDCMP_CLOSEWINDOW!IDCMP_VANILLAKEY!IDCMP_RAWKEY!IDCMP_MENUPICK!BUTTONIDCMP!IDCMP_GADGETDOWN
	dc.l	titleonlyobj

titleonlyobj:

PowerObject14:
	MO_Object	ActiveWindowObject14,GLA_WinClose,ID_Quit,0,6,3,9,9,PowerImage1,GACT_RELVERIFY,0,EPNr_Quit,0,0,0
ActiveWindowObject14:
	MO_Object	InActiveWindowObject14,GLA_Image,ID_ActiveWindow,0,0,0,275,13,ActiveWindowImage2,0,0,0,0,0,0
InActiveWindowObject14:
	MO_Object	DragObject14,GLA_Image,ID_InActiveWindow,0,0,0,275,13,InActiveWindowImage2,0,0,0,0,0,0
DragObject14:
	MO_Object	ZipWinObject14,GLA_WinDrag,0,0,19,0,64,13,0,0,0,0,0,0,0
ZipWinObject14:
	MO_Object	WinUpfrontObject14,GLA_Button,ID_ZipWinOnOff,0,254,3,9,9,ZipWinImageT1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_TitleOnly,TOGGF_Winrefresh,0
WinUpfrontObject14:
	MO_Object	IconifyObject14,GLA_WinDepth,ID_None,0,264,3,9,9,WinUpfrontImage1,0,0,0,0,0,0
IconifyObject14:
	MO_Object	PauseObject14,GLA_Button,ID_Iconify,0,244,3,9,9,IconifyImage1,GACT_RELVERIFY,0,EPNr_Iconify,1,0,0
PauseObject14:
	MO_Object	PlayObject14,GLA_Button,ID_Pause,0,186,3,10,9,0,GACT_RELVERIFY,0,EPNr_Play,0,0,0
PlayObject14:
	MO_Object	StopObject14,GLA_Button,ID_Play,0,176,3,10,9,0,GACT_RELVERIFY,0,EPNr_Play,1,0,0
StopObject14:
	MO_Object	NextModObject14,GLA_Button,ID_Stop,0,196,3,9,9,0,GACT_RELVERIFY,0,EPNr_StopPlay,1,0,0
NextModObject14:
	MO_Object	PrevModObject14,GLA_Button,ID_NextMod,0,205,3,8,9,0,GACT_RELVERIFY,0,EPNr_NextModule,1,0,0
PrevModObject14:
	MO_Object	DiskObject14,GLA_Button,ID_PrevMod,0,168,3,8,9,0,GACT_RELVERIFY,0,EPNr_PrevModule,1,0,0
DiskObject14:
	MO_Object	TimeDisplayObject14,GLA_Button,ID_DiskButton,0,215,3,9,9,0,GACT_RELVERIFY,HandleLoadModule,EPNr_LoadModule,0,0,0
TimeDisplayObject14:
	MO_Object	TimeDisplayObject24,GLA_TextField,ID_TimeDisplay,0,135,4,5,6,TimeTempNImage14,0,HandleShowTime,0,0,0,NumbersObject14
TimeDisplayObject24:
	MO_Object	TimeDisplayObject34,GLA_TextField,ID_TimeDisplay2,0,140,4,5,6,TimeTempNImage14,0,HandleShowTime,0,0,0,NumbersObject14
TimeDisplayObject34:
	MO_Object	TimeDisplayObject44,GLA_TextField,ID_TimeDisplay3,0,147,4,5,6,TimeTempNImage14,0,HandleShowTime,0,0,0,NumbersObject14
TimeDisplayObject44:
	MO_Object	TimeMinusObject14,GLA_TextField,ID_TimeDisplay4,0,152,4,5,6,TimeTempNImage14,0,HandleShowTime,0,0,0,NumbersObject14
TimeMinusObject14:
	MO_Object	NumbersObject14,GLA_Image,ID_TimeMinus,0,130,4,5,6,TimeMinusImage14,0,HandleShowTime,0,0,0,0
NumbersObject14:
	MO_Object	LevelmeterMapObject14,GLA_Image,ID_Numbers,0,0,0,50,6,NumbersImage14,0,0,0,0,0,5
LevelmeterMapObject14:
	MO_Object	0,GLA_Image,ID_Levelmeter,0,79,5,38,2,LevelmeterMapImage,0,DoLevelmeter,0,0,0,0

;-------------------------------------------------
normald:
	dc.w	100	;Left
	dc.w	100	;Top
	dc.w	550	;Width
	dc.w	232	;Height
	dc.l	WFLG_BORDERLESS!WFLG_SMART_REFRESH
	dc.l	IDCMP_INACTIVEWINDOW!IDCMP_ACTIVEWINDOW!IDCMP_IDCMPUPDATE!IDCMP_MOUSEMOVE!IDCMP_REFRESHWINDOW!IDCMP_CHANGEWINDOW!IDCMP_CLOSEWINDOW!IDCMP_VANILLAKEY!IDCMP_RAWKEY!IDCMP_MENUPICK!BUTTONIDCMP!IDCMP_GADGETDOWN
	dc.l	normaldobj

normaldobj:

Backobject12D:
	MO_Object	PowerObject12D,GLA_Image,ID_Backdrop,0,0,0,0,0,BackImage1D,0,0,0,0,0,0
PowerObject12D:
	MO_Object	ActiveWindowObject12D,GLA_WinClose,ID_Quit,0,12,6,18,18,PowerImage1D,GACT_RELVERIFY,0,EPNr_Quit,0,0,0
ActiveWindowObject12D:
	MO_Object	InActiveWindowObject12D,GLA_Image,ID_ActiveWindow,0,0,0,550,28,ActiveWindowImage1D,0,0,0,0,0,0
InActiveWindowObject12D:
	MO_Object	DragObject12D,GLA_Image,ID_InActiveWindow,0,0,0,550,28,InActiveWindowImage1D,0,0,0,0,0,0
DragObject12D:
	MO_Object	ZipWinObject12D,GLA_WinDrag,0,0,38,0,452,28,0,0,0,0,0,0,0
ZipWinObject12D:
	MO_Object	WinUpfrontObject12D,GLA_Button,ID_ZipWinOnOff,0,508,6,18,18,ZipWinImage1D,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_TitleOnly,TOGGF_Winrefresh,0
WinUpfrontObject12D:
	MO_Object	IconifyObject12D,GLA_WinDepth,ID_None,0,528,6,18,18,WinUpfrontImage1D,0,0,0,0,0,0
IconifyObject12D:
	MO_Object	PauseObject12D,GLA_Button,ID_Iconify,0,488,6,18,18,IconifyImage1D,GACT_RELVERIFY,0,EPNr_Iconify,1,0,0
PauseObject12D:
	MO_Object	PlayObject12D,GLA_Button,ID_Pause,0,126,176,46,36,PauseImage1D,GACT_RELVERIFY,0,EPNr_Play,0,0,0
PlayObject12D:
	MO_Object	StopObject12D,GLA_Button,ID_Play,0,78,176,46,36,PlayImage1D,GACT_RELVERIFY,0,EPNr_Play,1,0,0
StopObject12D:
	MO_Object	NextModObject12D,GLA_Button,ID_Stop,0,172,176,46,36,StopImage1D,GACT_RELVERIFY,0,EPNr_StopPlay,1,0,0
NextModObject12D:
	MO_Object	PrevModObject12D,GLA_Button,ID_NextMod,0,218,176,46,36,NextModImage1D,GACT_RELVERIFY,0,EPNr_NextModule,1,0,0
PrevModObject12D:
	MO_Object	DiskObject12D,GLA_Button,ID_PrevMod,0,32,176,46,36,PrevModImage1D,GACT_RELVERIFY,0,EPNr_PrevModule,1,0,0
DiskObject12D:
	MO_Object	RandomObject12D,GLA_Button,ID_DiskButton,0,272,178,44,32,DiskImage1D,GACT_RELVERIFY,HandleLoadModule,EPNr_LoadModule,0,0,0
RandomObject12D:
	MO_Object	SongendObject12D,GLA_Button,ID_Random,0,328,178,96,32,RandomImage1D,GACT_RELVERIFY,ChangeRandom,EPNr_ProgramMode,3,0,0
SongendObject12D:
	MO_Object	NumbersObject12D,GLA_Button,ID_Songend,0,422,178,56,32,SongendImage1D,GACT_RELVERIFY,ChangeSongend,EPNr_SongEnd,-1,0,0
NumbersObject12D:
	MO_Object	TimeDisplayObject12D,GLA_Image,ID_Numbers,0,0,0,198,26,NumbersImage1D,0,0,0,0,0,18
TimeDisplayObject12D:
	MO_Object	TimeDisplayObject22D,GLA_TextField,ID_TimeDisplay,0,96,52,18,26,TimeTempNImage1D,0,HandleShowTime,0,0,0,NumbersObject12D
TimeDisplayObject22D:
	MO_Object	TimeDisplayObject32D,GLA_TextField,ID_TimeDisplay2,0,120,52,18,26,TimeTempNImage1D,0,HandleShowTime,0,0,0,NumbersObject12D
TimeDisplayObject32D:
	MO_Object	TimeDisplayObject42D,GLA_TextField,ID_TimeDisplay3,0,156,52,18,26,TimeTempNImage1D,0,HandleShowTime,0,0,0,NumbersObject12D
TimeDisplayObject42D:
	MO_Object	TimeMinusObject12D,GLA_TextField,ID_TimeDisplay4,0,180,52,18,26,TimeTempNImage1D,0,HandleShowTime,0,0,0,NumbersObject12D
TimeMinusObject12D:
	MO_Object	SetTimeBackwardsObject12D,GLA_Image,ID_TimeMinus,0,84,64,10,2,TimeMinusImage1D,0,HandleShowTime,0,0,0,0
SetTimeBackwardsObject12D:
	MO_Object	PlayIndicatorObject12D,GLA_Button,ID_SetTimeBackwards,0,84,52,116,26,0,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_TimeBackwards,0,0
PlayIndicatorObject12D:
	MO_Object	LEDLoadingObject12D,GLA_Image,ID_PlayIndicator,0,52,56,18,18,PlayIndicatorImage1D,0,HandlePlayLED,0,0,0,0
LEDLoadingObject12D:
;	MO_Object	FontObject12D,GLA_Image,ID_LoadingLED,0,46,64,6,6,LEDLoadingImage1D,0,0,0,0,0,0
FontObject12D:		;bei Fontobjekten UserData.w = Breite pro Char; UserData<<16 = Tabelle fr Positionen in Quellmap, dort dann kein Autocheck auf Anzahl enthaltener Buchstaben
	MO_Object	NameTempObject12D,GLA_Image,ID_Font1,0,0,0,2688,12,FontImage1D,0,0,0,0,Font1D_Offsets,10
NameTempObject12D:	;bei Textdisplayobjekten UserData.l = Adresse des Fonts
	MO_Object	VolumeObject12D,GLA_TextField,ID_Textname1,0,222,54,31*10,12,NametempNImage1D,0,HandleModname,0,0,0,FontObject12D
VolumeObject12D:
	MO_Object	VolumeanimObject12D,GLA_Moused,ID_Volume,0,214,114,136,28,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleVolume,EPNr_Volume,0,0,VolumeReglerD
VolumeanimObject12D:
	MO_Object	VolumeknobObject12D,GLA_Image,ID_Volumeanim,0,214,114,136,28,VolumebackImage1D,0,0,0,0,0,0
VolumeknobObject12D:
	MO_Object	VolumeknobObject22D,GLA_Image,ID_Volumeknob,0,214,116,28,22,VolumeknobImage1D,0,0,0,0,0,0
VolumeknobObject22D:
	MO_Object	BalanceObject12D,GLA_Image,ID_Volumeknob2,0,214,116,28,22,VolumeknobImage2D,0,HandleMuting,0,0,0,0
BalanceObject12D:
	MO_Object	BalanceanimObject12D,GLA_Moused,ID_Balance,0,354,114,76,28,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleBalance,EPNr_Balance,0,0,BalanceReglerD
BalanceanimObject12D:
	MO_Object	BalanceknobObject12D,GLA_Image,ID_Balanceanim,0,354,114,76,28,BalancebackImage1D,0,0,0,0,0,0
BalanceknobObject12D:
	MO_Object	BalanceknobObject22D,GLA_Image,ID_Balanceknob,0,354,116,28,22,VolumeknobImage1D,0,0,0,0,0,0
BalanceknobObject22D:
	MO_Object	BitrateObject12D,GLA_Image,ID_Balanceknob2,0,354,116,28,22,VolumeknobImage2D,0,HandleMuting,0,0,0,0
BitrateObject12D:
	MO_Object	FrequencyObject12D,GLA_TextField,ID_Bitrate,0,220,86,30,10,BitratetempNImage1D,0,HandleBitrate,0,0,0,FontObject12D
FrequencyObject12D:
	MO_Object	ClutterBarObject12D,GLA_TextField,ID_Frequency,0,312,86,20,10,FrequencytempNImage1D,0,HandleFrequency,0,0,0,FontObject12D
ClutterBarObject12D:
	MO_Object	ClutterBaranimObject12D,GLA_Moused,ID_Clutterbar,0,20,44,16,86,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleClutterBar,0,0,0,ClutterReglerD
ClutterBaranimObject12D:
	MO_Object	OptionsMenuObject12D,GLA_Image,ID_ClutterbarAnim,0,20,44,16,86,OptionsBarImage1D,0,0,0,0,0,Clutterdefs
OptionsMenuObject12D:
	MO_Object	SkinselectObject12D,GLA_Dummy,ID_OptionsMenu,0,36,44,0,0,0,0,0,0,0,0,Popupdefs
SkinselectObject12D:
	MO_Object	DoubleModeObject12D,GLA_Dummy,ID_Skinselect,0,10,22,8,43,0,0,Skinselect,0,0,0,0
DoubleModeObject12D:
	MO_Object	ToggleClutterbarObject12D,GLA_Dummy,ID_DoubleMode,0,10,22,8,43,0,0,ToggleDoubleMode,0,0,0,0
ToggleClutterbarObject12D:
	MO_Object	AnalyzerMapObject12D,GLA_Dummy,ID_ToggleClutterbar,0,10,22,8,43,0,0,ToggleClutterbar,0,0,0,0
AnalyzerMapObject12D:
	MO_Object	AnalyzermodeObject12D,GLA_Image,ID_AnalyzerMap,0,48,86,FFT_Width*2,FFT_Height*2,AnalyzerMapImageD,0,HandleAnalyzer,0,0,0,0
AnalyzermodeObject12D:
	MO_Object	AnalyzerOffObject12D,GLA_Button,ID_AnalyzerMode,0,48,86,FFT_Width*2,FFT_Height*2,0,GACT_RELVERIFY,HandleAnalyzerMode,0,0,0,0
AnalyzerOffObject12D:
	MO_Object	StereoObject12D,GLA_Image,ID_Analyzeroff,0,48,86,FFT_Width*2,FFT_Height*2,AnalyzerOffImageD,0,0,0,0,0,0
StereoObject12D:
	MO_Object	MonoObject12D,GLA_Image,ID_Stereo,0,478,82,58,24,StereoImage1D,0,HandleStereo,0,0,0,0
MonoObject12D:
	MO_Object	0,GLA_Image,ID_Mono,0,424,82,54,24,MonoImage1D,0,HandleMono,0,0,0,0

;-------------------------------------------------
normal:
	dc.w	100	;Left
	dc.w	100	;Top
	dc.w	275	;Width
	dc.w	116	;Height
	dc.l	WFLG_BORDERLESS!WFLG_SMART_REFRESH
	dc.l	IDCMP_INACTIVEWINDOW!IDCMP_ACTIVEWINDOW!IDCMP_IDCMPUPDATE!IDCMP_MOUSEMOVE!IDCMP_REFRESHWINDOW!IDCMP_CHANGEWINDOW!IDCMP_CLOSEWINDOW!IDCMP_VANILLAKEY!IDCMP_RAWKEY!IDCMP_MENUPICK!BUTTONIDCMP!IDCMP_GADGETDOWN
	dc.l	normalobj

normalobj:
;MOL_Next,MOL_Type,MOL_ID,MOL_Initialized,MOL_Left,MOL_Top,MOL_Width
;MOL_Height,MOL_Images,MOL_Flags,MOL_React,MOL_Command,MOL_CMDArg1,MOL_CMDArg2,MOL_UserData
;Flags: GACT_Immediate, GACT_RELVERIFY, GACT_Toggleselect

Backobject12:
	MO_Object	PowerObject12,GLA_Image,ID_Backdrop,0,0,0,0,0,BackImage1,0,0,0,0,0,0
PowerObject12:
	MO_Object	ActiveWindowObject12,GLA_WinClose,ID_Quit,0,6,3,9,9,PowerImage1,GACT_RELVERIFY,0,EPNr_Quit,0,0,0
ActiveWindowObject12:
	MO_Object	InActiveWindowObject12,GLA_Image,ID_ActiveWindow,0,0,0,275,14,ActiveWindowImage1,0,0,0,0,0,0
InActiveWindowObject12:
	MO_Object	DragObject12,GLA_Image,ID_InActiveWindow,0,0,0,275,14,InActiveWindowImage1,0,0,0,0,0,0
DragObject12:
	MO_Object	ZipWinObject12,GLA_WinDrag,0,0,19,0,226,14,0,0,0,0,0,0,0
ZipWinObject12:
	MO_Object	WinUpfrontObject12,GLA_Button,ID_ZipWinOnOff,0,254,3,9,9,ZipWinImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_TitleOnly,TOGGF_Winrefresh,0
WinUpfrontObject12:
	MO_Object	IconifyObject12,GLA_WinDepth,ID_None,0,264,3,9,9,WinUpfrontImage1,0,0,0,0,0,0
IconifyObject12:
	MO_Object	PauseObject12,GLA_Button,ID_Iconify,0,244,3,9,9,IconifyImage1,GACT_RELVERIFY,0,EPNr_Iconify,1,0,0
PauseObject12:
	MO_Object	PlayObject12,GLA_Button,ID_Pause,0,63,88,23,18,PauseImage1,GACT_RELVERIFY,0,EPNr_Play,0,0,0
PlayObject12:
	MO_Object	StopObject12,GLA_Button,ID_Play,0,39,88,23,18,PlayImage1,GACT_RELVERIFY,0,EPNr_Play,1,0,0
StopObject12:
	MO_Object	NextModObject12,GLA_Button,ID_Stop,0,86,88,23,18,StopImage1,GACT_RELVERIFY,0,EPNr_StopPlay,1,0,0
NextModObject12:
	MO_Object	PrevModObject12,GLA_Button,ID_NextMod,0,109,88,23,18,NextModImage1,GACT_RELVERIFY,0,EPNr_NextModule,1,0,0
PrevModObject12:
	MO_Object	DiskObject12,GLA_Button,ID_PrevMod,0,16,88,23,18,PrevModImage1,GACT_RELVERIFY,0,EPNr_PrevModule,1,0,0
DiskObject12:
	MO_Object	RandomObject12,GLA_Button,ID_DiskButton,0,136,89,22,16,DiskImage1,GACT_RELVERIFY,HandleLoadModule,EPNr_LoadModule,0,0,0
RandomObject12:
	MO_Object	SongendObject12,GLA_Button,ID_Random,0,164,89,48,16,RandomImage1,GACT_RELVERIFY,ChangeRandom,EPNr_ProgramMode,3,0,0
SongendObject12:
	MO_Object	NumbersObject12,GLA_Button,ID_Songend,0,211,89,28,16,SongendImage1,GACT_RELVERIFY,ChangeSongend,EPNr_SongEnd,-1,0,0
NumbersObject12:
	MO_Object	TimeDisplayObject12,GLA_Image,ID_Numbers,0,0,0,99,13,NumbersImage1,0,0,0,0,0,9
TimeDisplayObject12:
	MO_Object	TimeDisplayObject22,GLA_TextField,ID_TimeDisplay,0,48,26,9,13,TimeTempNImage1,0,HandleShowTime,0,0,0,NumbersObject12
TimeDisplayObject22:
	MO_Object	TimeDisplayObject32,GLA_TextField,ID_TimeDisplay2,0,60,26,9,13,TimeTempNImage1,0,HandleShowTime,0,0,0,NumbersObject12
TimeDisplayObject32:
	MO_Object	TimeDisplayObject42,GLA_TextField,ID_TimeDisplay3,0,78,26,9,13,TimeTempNImage1,0,HandleShowTime,0,0,0,NumbersObject12
TimeDisplayObject42:
	MO_Object	TimeMinusObject12,GLA_TextField,ID_TimeDisplay4,0,90,26,9,13,TimeTempNImage1,0,HandleShowTime,0,0,0,NumbersObject12
TimeMinusObject12:
	MO_Object	SetTimeBackwardsObject12,GLA_Image,ID_TimeMinus,0,42,32,5,1,TimeMinusImage1,0,HandleShowTime,0,0,0,0
SetTimeBackwardsObject12:
	MO_Object	PlayIndicatorObject12,GLA_Button,ID_SetTimeBackwards,0,42,26,58,13,0,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_TimeBackwards,0,0
PlayIndicatorObject12:
	MO_Object	LEDLoadingObject12,GLA_Image,ID_PlayIndicator,0,26,28,9,9,PlayIndicatorImage1,0,HandlePlayLED,0,0,0,0
LEDLoadingObject12:
;	MO_Object	FontObject12,GLA_Image,ID_LoadingLED,0,23,32,3,3,LEDLoadingImage1,0,0,0,0,0,0
FontObject12:		;bei Fontobjekten UserData.w = Breite pro Char
			;MOL_CMDARG2 = Tabelle fr Positionen in Quellmap, dort dann kein Autocheck auf Anzahl enthaltener Buchstaben
	MO_Object	NameTempObject12,GLA_Image,ID_Font1,0,0,0,2688,6,FontImage1,0,0,0,0,Font1_Offsets,5
NameTempObject12:	;bei Textdisplayobjekten UserData.l = Adresse des Fonts
	MO_Object	VolumeObject12,GLA_TextField,ID_Textname1,0,111,27,31*5,6,NametempNImage1,0,HandleModname,0,0,0,FontObject12
VolumeObject12:
	MO_Object	VolumeanimObject12,GLA_Moused,ID_Volume,0,107,57,64,14,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleVolume,EPNr_Volume,0,0,VolumeRegler
VolumeanimObject12:
	MO_Object	VolumeknobObject12,GLA_Image,ID_Volumeanim,0,107,57,64,14,VolumebackImage1,0,0,0,0,0,0
VolumeknobObject12:
	MO_Object	VolumeknobObject22,GLA_Image,ID_Volumeknob,0,107,58,14,11,VolumeknobImage1,0,0,0,0,0,0
VolumeknobObject22:
	MO_Object	BalanceObject12,GLA_Image,ID_Volumeknob2,0,107,58,14,11,VolumeknobImage2,0,HandleMuting,0,0,0,0
BalanceObject12:
	MO_Object	BalanceanimObject12,GLA_Moused,ID_Balance,0,177,57,38,14,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleBalance,EPNr_Balance,0,0,BalanceRegler
BalanceanimObject12:
	MO_Object	BalanceknobObject12,GLA_Image,ID_Balanceanim,0,177,57,38,14,BalancebackImage1,0,0,0,0,0,0
BalanceknobObject12:
	MO_Object	BalanceknobObject22,GLA_Image,ID_Balanceknob,0,177,58,14,11,VolumeknobImage1,0,0,0,0,0,0
BalanceknobObject22:
	MO_Object	BitrateObject12,GLA_Image,ID_Balanceknob2,0,177,58,14,11,VolumeknobImage2,0,HandleMuting,0,0,0,0
BitrateObject12:
	MO_Object	FrequencyObject12,GLA_TextField,ID_Bitrate,0,110,43,15,5,BitratetempNImage1,0,HandleBitrate,0,0,0,FontObject12
FrequencyObject12:
	MO_Object	ClutterBarObject12,GLA_TextField,ID_Frequency,0,156,43,10,5,FrequencytempNImage1,0,HandleFrequency,0,0,0,FontObject12
ClutterBarObject12:
	MO_Object	ClutterBaranimObject12,GLA_Moused,ID_Clutterbar,0,10,22,8,43,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleClutterBar,0,0,0,ClutterRegler
ClutterBaranimObject12:
	MO_Object	OptionsMenuObject12,GLA_Image,ID_ClutterbarAnim,0,10,22,8,43,OptionsBarImage1,0,0,0,0,0,Clutterdefs
OptionsMenuObject12:
	MO_Object	SkinselectObject12,GLA_Dummy,ID_OptionsMenu,0,18,22,0,0,0,0,0,0,0,0,Popupdefs
SkinselectObject12:
	MO_Object	DoubleModeObject12,GLA_Dummy,ID_Skinselect,0,10,22,8,43,0,0,Skinselect,0,0,0,0
DoubleModeObject12:
	MO_Object	ToggleClutterbarObject12,GLA_Dummy,ID_DoubleMode,0,10,22,8,43,0,0,ToggleDoubleMode,0,0,0,0
ToggleClutterbarObject12:
	MO_Object	AnalyzerMapObject12,GLA_Dummy,ID_ToggleClutterbar,0,10,22,8,43,0,0,ToggleClutterbar,0,0,0,0
AnalyzerMapObject12:
	MO_Object	AnalyzermodeObject12,GLA_Image,ID_AnalyzerMap,0,24,43,FFT_Width,FFT_Height,AnalyzerMapImage,0,HandleAnalyzer,0,0,0,0
AnalyzermodeObject12:
	MO_Object	AnalyzerOffObject12,GLA_Button,ID_AnalyzerMode,0,24,43,FFT_Width,FFT_Height,0,GACT_RELVERIFY,HandleAnalyzerMode,0,0,0,0
AnalyzerOffObject12:
	MO_Object	StereoObject12,GLA_Image,ID_Analyzeroff,0,24,43,FFT_Width,FFT_Height,AnalyzerOffImage,0,0,0,0,0,0
StereoObject12:
	MO_Object	MonoObject12,GLA_Image,ID_Stereo,0,239,41,29,12,StereoImage1,0,HandleStereo,0,0,0,0
MonoObject12:
	MO_Object	0,GLA_Image,ID_Mono,0,212,41,27,12,MonoImage1,0,HandleMono,0,0,0,0

;---------------------------- Definitionen fr Regler -------------------------------
;REG_Type,REG_Enable,REG_XCenter,REG_YCenter,REG_MinRadius,REG_MaxRadius,REG_KnobRadius
;REG_PhiMin,REG_PhiTotal,REG_Minvalue,REG_Maxvalue,REG_PhiStore,REG_Value

VolumeRegler:		REG_Object	REGTYPE_Hori,0,106,0,2,65,7,0,0,0,64,0,0
VolumeReglerD:		REG_Object	REGTYPE_Hori,0,212,0,4,130,14,0,0,0,64,0,0
BalanceRegler:		REG_Object	REGTYPE_Hori,0,177,0,0,38,5,0,0,0,64,0,0
BalanceReglerD:		REG_Object	REGTYPE_Hori,0,354,0,0,76,10,0,0,0,64,0,0

;REG_Type = REGTYPE_Verti:
;REG_XCenter = xmin
;REG_YCenter = ymin
;REG_Minradius = Offset von ymin, ab dem Regler gezhlt wird
;REG_Maxradius = Offset von ymin, wie weit der Regler geschoben werden kann
;REG_Minvalue,REG_Maxvalue -> min und max Ausgabewert (beide >0)
;REG_Value = Ausgabewert
;REG_PhiMin = xmax
ClutterRegler:		REG_Object	REGTYPE_Verti,0,10,22,2,36,0,8,0,0,4,0,-1
ClutterReglerD:		REG_Object	REGTYPE_Verti,0,20,44,4,72,0,16,0,0,4,0,-1

;Was passiert bei Aktionen der Clutterbar
;1.LW: Image Nummer (longint)
;2.LW: Text fr Begleitanzeige (strptr)
;3.LW: Aktion bei "Release" (fptr) Achtung!! Die aufzurufenden Routinen erhalten weder
;                                            in A0, noch A1 valide Werte !!
Clutterdefs:
		dc.l	2,Optionstext,HandleOptions
		dc.l	3,Preferencestext,HandleManager
		dc.l	4,Infotext,HandleModuleinfo
		dc.l	5,Doubletext,ToggleDoubleMode
		dc.l	6,VText,HandleAMPManager

;---------------------------- Imagedefinitionen -------------------------------------
;
;nachfolgend bis END_IMAGES nur "IML_"-Imagestrukturen unterbringen, wichtig !!!
;
;IML_Next,IML_Rendered,IML_Width,IML_Height,IML_Type,IML_ColourMap,IML_Data
;IML_SourceX;IML_SourceY;IML_SourceWidth;IML_SourceHeight;IML_SourcePic
;
START_IMAGES:

;-------------- Images fr normalen Modus
BackImage1:		IM_Object	0,0,275,116,6,0,0,0,0,275,116,PID_Main,0
BackImage1D:		IM_Object	0,0,550,232,6,0,0,0,0,275,116,PID_Main,0

PowerImage1:		IM_Object	PowerImage2,0,9,9,6,0,0,0,0,9,9,PID_Titlebar,0
PowerImage2:		IM_Object	0,0,9,9,6,0,0,0,9,9,9,PID_Titlebar,0
PowerImage1D:		IM_Object	PowerImage2D,0,18,18,6,0,0,0,0,9,9,PID_Titlebar,0
PowerImage2D:		IM_Object	0,0,18,18,6,0,0,0,9,9,9,PID_Titlebar,0

ActiveWindowImage1:	IM_Object	0,0,275,14,6,0,0,27,0,275,14,PID_Titlebar,0
ActiveWindowImage1D:	IM_Object	0,0,550,28,6,0,0,27,0,275,14,PID_Titlebar,0
InActiveWindowImage1:	IM_Object	0,0,275,14,6,0,0,27,15,275,14,PID_Titlebar,0
InActiveWindowImage1D:	IM_Object	0,0,550,28,6,0,0,27,15,275,14,PID_Titlebar,0

ZipWinImage1:		IM_Object	ZipWinImage2,0,9,9,6,0,0,0,18,9,9,PID_Titlebar,0
ZipWinImage1D:		IM_Object	ZipWinImage2D,0,18,18,6,0,0,0,18,9,9,PID_Titlebar,0
ZipWinImage2:		IM_Object	0,0,9,9,6,0,0,9,18,9,9,PID_Titlebar,0
ZipWinImage2D:		IM_Object	0,0,18,18,6,0,0,9,18,9,9,PID_Titlebar,0

IconifyImage1:		IM_Object	IconifyImage2,0,9,9,6,0,0,9,0,9,9,PID_Titlebar,0
IconifyImage1D:		IM_Object	IconifyImage2D,0,18,18,6,0,0,9,0,9,9,PID_Titlebar,0
IconifyImage2:		IM_Object	0,0,9,9,6,0,0,9,9,9,9,PID_Titlebar,0
IconifyImage2D:		IM_Object	0,0,18,18,6,0,0,9,9,9,9,PID_Titlebar,0

WinUpfrontImage1:	IM_Object	WinUpfrontImage2,0,9,9,6,0,0,18,0,9,9,PID_Titlebar,0
WinUpfrontImage1D:	IM_Object	WinUpfrontImage2D,0,18,18,6,0,0,18,0,9,9,PID_Titlebar,0
WinUpfrontImage2:	IM_Object	0,0,9,9,6,0,0,18,9,9,9,PID_Titlebar,0
WinUpfrontImage2D:	IM_Object	0,0,18,18,6,0,0,18,9,9,9,PID_Titlebar,0

PrevModImage1:		IM_Object	PrevModImage2,0,23,18,6,0,0,0,0,23,18,PID_Buttons,0
PrevModImage1D:		IM_Object	PrevModImage2D,0,46,36,6,0,0,0,0,23,18,PID_Buttons,0
PrevModImage2:		IM_Object	0,0,23,18,6,0,0,0,18,23,18,PID_Buttons,0
PrevModImage2D:		IM_Object	0,0,46,36,6,0,0,0,18,23,18,PID_Buttons,0

PlayImage1:		IM_Object	PlayImage2,0,23,18,6,0,0,23,0,23,18,PID_Buttons,0
PlayImage1D:		IM_Object	PlayImage2D,0,46,36,6,0,0,23,0,23,18,PID_Buttons,0
PlayImage2:		IM_Object	0,0,23,18,6,0,0,23,18,23,18,PID_Buttons,0
PlayImage2D:		IM_Object	0,0,46,36,6,0,0,23,18,23,18,PID_Buttons,0

PauseImage1:		IM_Object	PauseImage2,0,23,18,6,0,0,46,0,23,18,PID_Buttons,0
PauseImage1D:		IM_Object	PauseImage2D,0,46,36,6,0,0,46,0,23,18,PID_Buttons,0
PauseImage2:		IM_Object	0,0,23,18,6,0,0,46,18,23,18,PID_Buttons,0
PauseImage2D:		IM_Object	0,0,46,36,6,0,0,46,18,23,18,PID_Buttons,0

StopImage1:		IM_Object	StopImage2,0,23,18,6,0,0,69,0,23,18,PID_Buttons,0
StopImage1D:		IM_Object	StopImage2D,0,46,36,6,0,0,69,0,23,18,PID_Buttons,0
StopImage2:		IM_Object	0,0,23,18,6,0,0,69,18,23,18,PID_Buttons,0
StopImage2D:		IM_Object	0,0,46,36,6,0,0,69,18,23,18,PID_Buttons,0

NextModImage1:		IM_Object	NextModImage2,0,22,18,6,0,0,92,0,22,18,PID_Buttons,0
NextModImage1D:		IM_Object	NextModImage2D,0,44,36,6,0,0,92,0,22,18,PID_Buttons,0
NextModImage2:		IM_Object	0,0,22,18,6,0,0,92,18,22,18,PID_Buttons,0
NextModImage2D:		IM_Object	0,0,44,36,6,0,0,92,18,22,18,PID_Buttons,0

DiskImage1:		IM_Object	DiskImage2,0,22,16,6,0,0,114,0,22,16,PID_Buttons,0
DiskImage1D:		IM_Object	DiskImage2D,0,44,32,6,0,0,114,0,22,16,PID_Buttons,0
DiskImage2:		IM_Object	0,0,22,16,6,0,0,114,16,22,16,PID_Buttons,0
DiskImage2D:		IM_Object	0,0,44,32,6,0,0,114,16,22,16,PID_Buttons,0

RandomImage1:		IM_Object	RandomImage2,0,46,15,6,0,0,28,0,46,15,PID_Shufrep,0
RandomImage1D:		IM_Object	RandomImage2D,0,92,30,6,0,0,28,0,46,15,PID_Shufrep,0
RandomImage2:		IM_Object	RandomImage3,0,46,15,6,0,0,28,15,46,15,PID_Shufrep,0
RandomImage2D:		IM_Object	RandomImage3D,0,92,30,6,0,0,28,15,46,15,PID_Shufrep,0
RandomImage3:		IM_Object	RandomImage4,0,46,15,6,0,0,28,30,46,15,PID_Shufrep,0
RandomImage3D:		IM_Object	RandomImage4D,0,92,30,6,0,0,28,30,46,15,PID_Shufrep,0
RandomImage4:		IM_Object	0,0,46,15,6,0,0,28,45,46,15,PID_Shufrep,0
RandomImage4D:		IM_Object	0,0,92,30,6,0,0,28,45,46,15,PID_Shufrep,0

SongendImage1:		IM_Object	SongendImage2,0,28,15,6,0,0,0,30,28,15,PID_Shufrep,0
SongendImage1D:		IM_Object	SongendImage2D,0,56,30,6,0,0,0,30,28,15,PID_Shufrep,0
SongendImage2:		IM_Object	SongendImage3,0,28,15,6,0,0,0,45,28,15,PID_Shufrep,0
SongendImage2D:		IM_Object	SongendImage3D,0,56,30,6,0,0,0,45,28,15,PID_Shufrep,0
SongendImage3:		IM_Object	SongendImage4,0,28,15,6,0,0,0,0,28,15,PID_Shufrep,0
SongendImage3D:		IM_Object	SongendImage4D,0,56,30,6,0,0,0,0,28,15,PID_Shufrep,0
SongendImage4:		IM_Object	0,0,28,15,6,0,0,0,15,28,15,PID_Shufrep,0
SongendImage4D:		IM_Object	0,0,56,30,6,0,0,0,15,28,15,PID_Shufrep,0

NumbersImage1:		IM_Object	0,0,99,13,6,0,0,0,0,99,13,PID_Numbers,0
NumbersImage1D:		IM_Object	0,0,198,26,6,0,0,0,0,99,13,PID_Numbers,0
TimeTempNImage1:	IM_Object	0,0,9,13,0,0,Data_TimetempN1,0,0,0,0,0,0
TimeTempNImage1D:	IM_Object	0,0,18,26,0,0,Data_TimetempN1,0,0,0,0,0,0
TimeMinusImage1:	IM_Object	TimeMinusImage2,0,5,1,6,0,0,9,6,5,1,PID_Numbers,0
TimeMinusImage1D:	IM_Object	TimeMinusImage2D,0,10,2,6,0,0,9,6,5,1,PID_Numbers,0
TimeMinusImage2:	IM_Object	0,0,5,1,6,0,0,18,6,5,1,PID_Numbers,0
TimeMinusImage2D:	IM_Object	0,0,10,2,6,0,0,18,6,5,1,PID_Numbers,0

NumbersImage14:		IM_Object	0,0,50,6,6,0,0,0,6,50,6,PID_Text,0
NumbersImage14D:	IM_Object	0,0,100,12,6,0,0,0,6,50,6,PID_Text,0
TimeTempNImage14:	IM_Object	0,0,5,6,0,0,Data_TimetempN1,0,0,0,0,0,0
TimeTempNImage14D:	IM_Object	0,0,10,12,0,0,Data_TimetempN1,0,0,0,0,0,0
TimeMinusImage14:	IM_Object	TimeMinusImage24,0,5,6,6,0,0,150,0,5,6,PID_Text,0
TimeMinusImage14D:	IM_Object	TimeMinusImage24D,0,10,12,6,0,0,150,0,5,6,PID_Text,0
TimeMinusImage24:	IM_Object	0,0,5,6,6,0,0,75,6,5,6,PID_Text,0
TimeMinusImage24D:	IM_Object	0,0,10,12,6,0,0,75,6,5,6,PID_Text,0

	;Stop,Play,Pause,Leer
PlayIndicatorImage1:	IM_Object	PlayIndicatorImage2,0,9,9,6,0,0,18,0,9,9,PID_PlayPause,0
PlayIndicatorImage2:	IM_Object	PlayIndicatorImage3,0,9,9,6,0,0,0,0,9,9,PID_PlayPause,0
PlayIndicatorImage3:	IM_Object	PlayIndicatorImage4,0,9,9,6,0,0,9,0,9,9,PID_PlayPause,0
PlayIndicatorImage4:	IM_Object	0,0,9,9,6,0,0,27,0,9,9,PID_PlayPause,0
PlayIndicatorImage1D:	IM_Object	PlayIndicatorImage2D,0,18,18,6,0,0,18,0,9,9,PID_PlayPause,0
PlayIndicatorImage2D:	IM_Object	PlayIndicatorImage3D,0,18,18,6,0,0,0,0,9,9,PID_PlayPause,0
PlayIndicatorImage3D:	IM_Object	PlayIndicatorImage4D,0,18,18,6,0,0,9,0,9,9,PID_PlayPause,0
PlayIndicatorImage4D:	IM_Object	0,0,18,18,6,0,0,27,0,9,9,PID_PlayPause,0

LEDLoadingImage1:	IM_Object	LEDLoadingImage2,0,3,3,6,0,0,36,6,3,3,PID_PlayPause,0
LEDLoadingImage2:	IM_Object	0,0,3,3,6,0,0,39,6,3,3,PID_PlayPause,0
LEDLoadingImage1D:	IM_Object	LEDLoadingImage2D,0,6,6,6,0,0,36,6,3,3,PID_PlayPause,0
LEDLoadingImage2D:	IM_Object	0,0,6,6,6,0,0,39,6,3,3,PID_PlayPause,0

FontImage1:		IM_Object	0,0,155,18,6,0,0,0,0,155,18,PID_Text,0
FontImage1D:		IM_Object	0,0,310,36,6,0,0,0,0,155,18,PID_Text,0
NametempNImage1:	IM_Object	0,0,31*5,6,0,0,Data_NametempN1,0,0,0,0,0,0
BitratetempNImage1:	IM_Object	0,0,3*5,6,0,0,Data_NametempN1,0,0,0,0,0,0
FrequencytempNImage1:	IM_Object	0,0,2*5,6,0,0,Data_NametempN1,0,0,0,0,0,0
NametempNImage1D:	IM_Object	0,0,31*10,12,0,0,Data_NametempN1,0,0,0,0,0,0
BitratetempNImage1D:	IM_Object	0,0,3*10,12,0,0,Data_NametempN1,0,0,0,0,0,0
FrequencytempNImage1D:	IM_Object	0,0,2*10,12,0,0,Data_NametempN1,0,0,0,0,0,0

VolumebackImage1:	IM_Object	VolumebackImage2,0,68,13,6,0,0,0,0,68,13,PID_Volume,0
VolumebackImage2:	IM_Object	VolumebackImage3,0,68,13,6,0,0,0,15,68,13,PID_Volume,0
VolumebackImage3:	IM_Object	VolumebackImage4,0,68,13,6,0,0,0,30,68,13,PID_Volume,0
VolumebackImage4:	IM_Object	VolumebackImage5,0,68,13,6,0,0,0,45,68,13,PID_Volume,0
VolumebackImage5:	IM_Object	VolumebackImage6,0,68,13,6,0,0,0,60,68,13,PID_Volume,0
VolumebackImage6:	IM_Object	VolumebackImage7,0,68,13,6,0,0,0,75,68,13,PID_Volume,0
VolumebackImage7:	IM_Object	VolumebackImage8,0,68,13,6,0,0,0,90,68,13,PID_Volume,0
VolumebackImage8:	IM_Object	VolumebackImage9,0,68,13,6,0,0,0,105,68,13,PID_Volume,0
VolumebackImage9:	IM_Object	VolumebackImage10,0,68,13,6,0,0,0,120,68,13,PID_Volume,0
VolumebackImage10:	IM_Object	VolumebackImage11,0,68,13,6,0,0,0,135,68,13,PID_Volume,0
VolumebackImage11:	IM_Object	VolumebackImage12,0,68,13,6,0,0,0,150,68,13,PID_Volume,0
VolumebackImage12:	IM_Object	VolumebackImage13,0,68,13,6,0,0,0,165,68,13,PID_Volume,0
VolumebackImage13:	IM_Object	VolumebackImage14,0,68,13,6,0,0,0,180,68,13,PID_Volume,0
VolumebackImage14:	IM_Object	VolumebackImage15,0,68,13,6,0,0,0,195,68,13,PID_Volume,0
VolumebackImage15:	IM_Object	VolumebackImage16,0,68,13,6,0,0,0,210,68,13,PID_Volume,0
VolumebackImage16:	IM_Object	VolumebackImage17,0,68,13,6,0,0,0,225,68,13,PID_Volume,0
VolumebackImage17:	IM_Object	VolumebackImage18,0,68,13,6,0,0,0,240,68,13,PID_Volume,0
VolumebackImage18:	IM_Object	VolumebackImage19,0,68,13,6,0,0,0,255,68,13,PID_Volume,0
VolumebackImage19:	IM_Object	VolumebackImage20,0,68,13,6,0,0,0,270,68,13,PID_Volume,0
VolumebackImage20:	IM_Object	VolumebackImage21,0,68,13,6,0,0,0,285,68,13,PID_Volume,0
VolumebackImage21:	IM_Object	VolumebackImage22,0,68,13,6,0,0,0,300,68,13,PID_Volume,0
VolumebackImage22:	IM_Object	VolumebackImage23,0,68,13,6,0,0,0,315,68,13,PID_Volume,0
VolumebackImage23:	IM_Object	VolumebackImage24,0,68,13,6,0,0,0,330,68,13,PID_Volume,0
VolumebackImage24:	IM_Object	VolumebackImage25,0,68,13,6,0,0,0,345,68,13,PID_Volume,0
VolumebackImage25:	IM_Object	VolumebackImage26,0,68,13,6,0,0,0,360,68,13,PID_Volume,0
VolumebackImage26:	IM_Object	VolumebackImage27,0,68,13,6,0,0,0,375,68,13,PID_Volume,0
VolumebackImage27:	IM_Object	VolumebackImage28,0,68,13,6,0,0,0,390,68,13,PID_Volume,0
VolumebackImage28:	IM_Object	0,0,68,13,6,0,0,0,405,68,13,PID_Volume,0

VolumeknobImage1:	IM_Object	0,0,14,11,6,0,0,15,422,14,11,PID_Volume,0
VolumeknobImage2:	IM_Object	0,0,14,11,6,0,0,0,422,14,11,PID_Volume,0

BalanceBackImage1:	IM_Object	BalanceBackImage2,0,38,13,6,0,0,4,405,38,13,PID_Volume,0
BalanceBackImage2:	IM_Object	BalanceBackImage3,0,38,13,6,0,0,4,360,38,13,PID_Volume,0
BalanceBackImage3:	IM_Object	BalanceBackImage4,0,38,13,6,0,0,4,330,38,13,PID_Volume,0
BalanceBackImage4:	IM_Object	BalanceBackImage5,0,38,13,6,0,0,4,300,38,13,PID_Volume,0
BalanceBackImage5:	IM_Object	BalanceBackImage6,0,38,13,6,0,0,4,270,38,13,PID_Volume,0
BalanceBackImage6:	IM_Object	BalanceBackImage7,0,38,13,6,0,0,4,240,38,13,PID_Volume,0
BalanceBackImage7:	IM_Object	BalanceBackImage8,0,38,13,6,0,0,4,210,38,13,PID_Volume,0
BalanceBackImage8:	IM_Object	BalanceBackImage9,0,38,13,6,0,0,4,180,38,13,PID_Volume,0
BalanceBackImage9:	IM_Object	BalanceBackImage10,0,38,13,6,0,0,4,150,38,13,PID_Volume,0
BalanceBackImage10:	IM_Object	BalanceBackImage11,0,38,13,6,0,0,4,120,38,13,PID_Volume,0
BalanceBackImage11:	IM_Object	BalanceBackImage12,0,38,13,6,0,0,4,90,38,13,PID_Volume,0
BalanceBackImage12:	IM_Object	BalanceBackImage13,0,38,13,6,0,0,4,60,38,13,PID_Volume,0
BalanceBackImage13:	IM_Object	BalanceBackImage14,0,38,13,6,0,0,4,30,38,13,PID_Volume,0
BalanceBackImage14:	IM_Object	BalanceBackImage15,0,38,13,6,0,0,4,0,38,13,PID_Volume,0
BalanceBackImage15:	IM_Object	BalanceBackImage16,0,38,13,6,0,0,4,0,38,13,PID_Volume,0
BalanceBackImage16:	IM_Object	BalanceBackImage17,0,38,13,6,0,0,4,30,38,13,PID_Volume,0
BalanceBackImage17:	IM_Object	BalanceBackImage18,0,38,13,6,0,0,4,60,38,13,PID_Volume,0
BalanceBackImage18:	IM_Object	BalanceBackImage19,0,38,13,6,0,0,4,90,38,13,PID_Volume,0
BalanceBackImage19:	IM_Object	BalanceBackImage20,0,38,13,6,0,0,4,120,38,13,PID_Volume,0
BalanceBackImage20:	IM_Object	BalanceBackImage21,0,38,13,6,0,0,4,150,38,13,PID_Volume,0
BalanceBackImage21:	IM_Object	BalanceBackImage22,0,38,13,6,0,0,4,180,38,13,PID_Volume,0
BalanceBackImage22:	IM_Object	BalanceBackImage23,0,38,13,6,0,0,4,210,38,13,PID_Volume,0
BalanceBackImage23:	IM_Object	BalanceBackImage24,0,38,13,6,0,0,4,240,38,13,PID_Volume,0
BalanceBackImage24:	IM_Object	BalanceBackImage25,0,38,13,6,0,0,4,270,38,13,PID_Volume,0
BalanceBackImage25:	IM_Object	BalanceBackImage26,0,38,13,6,0,0,4,300,38,13,PID_Volume,0
BalanceBackImage26:	IM_Object	BalanceBackImage27,0,38,13,6,0,0,4,330,38,13,PID_Volume,0
BalanceBackImage27:	IM_Object	BalanceBackImage28,0,38,13,6,0,0,4,360,38,13,PID_Volume,0
BalanceBackImage28:	IM_Object	0,0,38,13,6,0,0,4,405,38,13,PID_Volume,0

VolumebackImage1D:	IM_Object	VolumebackImage2D,0,136,26,6,0,0,0,0,68,13,PID_Volume,0
VolumebackImage2D:	IM_Object	VolumebackImage3D,0,136,26,6,0,0,0,15,68,13,PID_Volume,0
VolumebackImage3D:	IM_Object	VolumebackImage4D,0,136,26,6,0,0,0,30,68,13,PID_Volume,0
VolumebackImage4D:	IM_Object	VolumebackImage5D,0,136,26,6,0,0,0,45,68,13,PID_Volume,0
VolumebackImage5D:	IM_Object	VolumebackImage6D,0,136,26,6,0,0,0,60,68,13,PID_Volume,0
VolumebackImage6D:	IM_Object	VolumebackImage7D,0,136,26,6,0,0,0,75,68,13,PID_Volume,0
VolumebackImage7D:	IM_Object	VolumebackImage8D,0,136,26,6,0,0,0,90,68,13,PID_Volume,0
VolumebackImage8D:	IM_Object	VolumebackImage9D,0,136,26,6,0,0,0,105,68,13,PID_Volume,0
VolumebackImage9D:	IM_Object	VolumebackImage10D,0,136,26,6,0,0,0,120,68,13,PID_Volume,0
VolumebackImage10D:	IM_Object	VolumebackImage11D,0,136,26,6,0,0,0,135,68,13,PID_Volume,0
VolumebackImage11D:	IM_Object	VolumebackImage12D,0,136,26,6,0,0,0,150,68,13,PID_Volume,0
VolumebackImage12D:	IM_Object	VolumebackImage13D,0,136,26,6,0,0,0,165,68,13,PID_Volume,0
VolumebackImage13D:	IM_Object	VolumebackImage14D,0,136,26,6,0,0,0,180,68,13,PID_Volume,0
VolumebackImage14D:	IM_Object	VolumebackImage15D,0,136,26,6,0,0,0,195,68,13,PID_Volume,0
VolumebackImage15D:	IM_Object	VolumebackImage16D,0,136,26,6,0,0,0,210,68,13,PID_Volume,0
VolumebackImage16D:	IM_Object	VolumebackImage17D,0,136,26,6,0,0,0,225,68,13,PID_Volume,0
VolumebackImage17D:	IM_Object	VolumebackImage18D,0,136,26,6,0,0,0,240,68,13,PID_Volume,0
VolumebackImage18D:	IM_Object	VolumebackImage19D,0,136,26,6,0,0,0,255,68,13,PID_Volume,0
VolumebackImage19D:	IM_Object	VolumebackImage20D,0,136,26,6,0,0,0,270,68,13,PID_Volume,0
VolumebackImage20D:	IM_Object	VolumebackImage21D,0,136,26,6,0,0,0,285,68,13,PID_Volume,0
VolumebackImage21D:	IM_Object	VolumebackImage22D,0,136,26,6,0,0,0,300,68,13,PID_Volume,0
VolumebackImage22D:	IM_Object	VolumebackImage23D,0,136,26,6,0,0,0,315,68,13,PID_Volume,0
VolumebackImage23D:	IM_Object	VolumebackImage24D,0,136,26,6,0,0,0,330,68,13,PID_Volume,0
VolumebackImage24D:	IM_Object	VolumebackImage25D,0,136,26,6,0,0,0,345,68,13,PID_Volume,0
VolumebackImage25D:	IM_Object	VolumebackImage26D,0,136,26,6,0,0,0,360,68,13,PID_Volume,0
VolumebackImage26D:	IM_Object	VolumebackImage27D,0,136,26,6,0,0,0,375,68,13,PID_Volume,0
VolumebackImage27D:	IM_Object	VolumebackImage28D,0,136,26,6,0,0,0,390,68,13,PID_Volume,0
VolumebackImage28D:	IM_Object	0,0,136,26,6,0,0,0,405,68,13,PID_Volume,0

VolumeknobImage1D:	IM_Object	0,0,28,22,6,0,0,15,422,14,11,PID_Volume,0
VolumeknobImage2D:	IM_Object	0,0,28,22,6,0,0,0,422,14,11,PID_Volume,0

BalanceBackImage1D:	IM_Object	BalanceBackImage2D,0,76,26,6,0,0,4,405,38,13,PID_Volume,0
BalanceBackImage2D:	IM_Object	BalanceBackImage3D,0,76,26,6,0,0,4,360,38,13,PID_Volume,0
BalanceBackImage3D:	IM_Object	BalanceBackImage4D,0,76,26,6,0,0,4,330,38,13,PID_Volume,0
BalanceBackImage4D:	IM_Object	BalanceBackImage5D,0,76,26,6,0,0,4,300,38,13,PID_Volume,0
BalanceBackImage5D:	IM_Object	BalanceBackImage6D,0,76,26,6,0,0,4,270,38,13,PID_Volume,0
BalanceBackImage6D:	IM_Object	BalanceBackImage7D,0,76,26,6,0,0,4,240,38,13,PID_Volume,0
BalanceBackImage7D:	IM_Object	BalanceBackImage8D,0,76,26,6,0,0,4,210,38,13,PID_Volume,0
BalanceBackImage8D:	IM_Object	BalanceBackImage9D,0,76,26,6,0,0,4,180,38,13,PID_Volume,0
BalanceBackImage9D:	IM_Object	BalanceBackImage10D,0,76,26,6,0,0,4,150,38,13,PID_Volume,0
BalanceBackImage10D:	IM_Object	BalanceBackImage11D,0,76,26,6,0,0,4,120,38,13,PID_Volume,0
BalanceBackImage11D:	IM_Object	BalanceBackImage12D,0,76,26,6,0,0,4,90,38,13,PID_Volume,0
BalanceBackImage12D:	IM_Object	BalanceBackImage13D,0,76,26,6,0,0,4,60,38,13,PID_Volume,0
BalanceBackImage13D:	IM_Object	BalanceBackImage14D,0,76,26,6,0,0,4,30,38,13,PID_Volume,0
BalanceBackImage14D:	IM_Object	BalanceBackImage15D,0,76,26,6,0,0,4,0,38,13,PID_Volume,0
BalanceBackImage15D:	IM_Object	BalanceBackImage16D,0,76,26,6,0,0,4,0,38,13,PID_Volume,0
BalanceBackImage16D:	IM_Object	BalanceBackImage17D,0,76,26,6,0,0,4,30,38,13,PID_Volume,0
BalanceBackImage17D:	IM_Object	BalanceBackImage18D,0,76,26,6,0,0,4,60,38,13,PID_Volume,0
BalanceBackImage18D:	IM_Object	BalanceBackImage19D,0,76,26,6,0,0,4,90,38,13,PID_Volume,0
BalanceBackImage19D:	IM_Object	BalanceBackImage20D,0,76,26,6,0,0,4,120,38,13,PID_Volume,0
BalanceBackImage20D:	IM_Object	BalanceBackImage21D,0,76,26,6,0,0,4,150,38,13,PID_Volume,0
BalanceBackImage21D:	IM_Object	BalanceBackImage22D,0,76,26,6,0,0,4,180,38,13,PID_Volume,0
BalanceBackImage22D:	IM_Object	BalanceBackImage23D,0,76,26,6,0,0,4,210,38,13,PID_Volume,0
BalanceBackImage23D:	IM_Object	BalanceBackImage24D,0,76,26,6,0,0,4,240,38,13,PID_Volume,0
BalanceBackImage24D:	IM_Object	BalanceBackImage25D,0,76,26,6,0,0,4,270,38,13,PID_Volume,0
BalanceBackImage25D:	IM_Object	BalanceBackImage26D,0,76,26,6,0,0,4,300,38,13,PID_Volume,0
BalanceBackImage26D:	IM_Object	BalanceBackImage27D,0,76,26,6,0,0,4,330,38,13,PID_Volume,0
BalanceBackImage27D:	IM_Object	BalanceBackImage28D,0,76,26,6,0,0,4,360,38,13,PID_Volume,0
BalanceBackImage28D:	IM_Object	0,0,76,26,6,0,0,4,405,38,13,PID_Volume,0

OptionsBarImage1:	IM_Object	OptionsBarImage2,0,8,43,6,0,0,312,0,8,43,PID_Titlebar,0
OptionsBarImage2:	IM_Object	OptionsBarImage3,0,8,43,6,0,0,304,0,8,43,PID_Titlebar,0
OptionsBarImage3:	IM_Object	OptionsBarImage4,0,8,43,6,0,0,304,44,8,43,PID_Titlebar,0
OptionsBarImage4:	IM_Object	OptionsBarImage5,0,8,43,6,0,0,312,44,8,43,PID_Titlebar,0
OptionsBarImage5:	IM_Object	OptionsBarImage6,0,8,43,6,0,0,320,44,8,43,PID_Titlebar,0
OptionsBarImage6:	IM_Object	OptionsBarImage7,0,8,43,6,0,0,328,44,8,43,PID_Titlebar,0
OptionsBarImage7:	IM_Object	0,0,8,43,6,0,0,336,44,8,43,PID_Titlebar,0

OptionsBarImage1D:	IM_Object	OptionsBarImage2D,0,16,86,6,0,0,312,0,8,43,PID_Titlebar,0
OptionsBarImage2D:	IM_Object	OptionsBarImage3D,0,16,86,6,0,0,304,0,8,43,PID_Titlebar,0
OptionsBarImage3D:	IM_Object	OptionsBarImage4D,0,16,86,6,0,0,304,44,8,43,PID_Titlebar,0
OptionsBarImage4D:	IM_Object	OptionsBarImage5D,0,16,86,6,0,0,312,44,8,43,PID_Titlebar,0
OptionsBarImage5D:	IM_Object	OptionsBarImage6D,0,16,86,6,0,0,320,44,8,43,PID_Titlebar,0
OptionsBarImage6D:	IM_Object	OptionsBarImage7D,0,16,86,6,0,0,328,44,8,43,PID_Titlebar,0
OptionsBarImage7D:	IM_Object	0,0,16,86,6,0,0,336,44,8,43,PID_Titlebar,0

StereoImage1:		IM_Object	StereoImage2,0,29,12,6,0,0,0,12,29,12,PID_Monoster,0
StereoImage2:		IM_Object	0,0,29,12,6,0,0,0,0,29,12,PID_Monoster,0
StereoImage1D:		IM_Object	StereoImage2D,0,58,24,6,0,0,0,12,29,12,PID_Monoster,0
StereoImage2D:		IM_Object	0,0,58,24,6,0,0,0,0,29,12,PID_Monoster,0

MonoImage1:		IM_Object	MonoImage2,0,27,12,6,0,0,29,12,27,12,PID_Monoster,0
MonoImage2:		IM_Object	0,0,27,12,6,0,0,29,0,27,12,PID_Monoster,0
MonoImage1D:		IM_Object	MonoImage2D,0,54,24,6,0,0,29,12,27,12,PID_Monoster,0
MonoImage2D:		IM_Object	0,0,54,24,6,0,0,29,0,27,12,PID_Monoster,0

;-------------- Images fr Analyzer
AnalyzerMapImage:	IM_Object	0,0,FFT_Width,FFT_Height,5,0,FFT_TrueBuffer,0,0,FFT_Width,FFT_Height,0,0
AnalyzerMapImageD:	IM_Object	0,0,FFT_Width*2,FFT_Height*2,5,0,FFT_TrueBuffer,0,0,FFT_Width,FFT_Height,0,0

AnalyzerOffImage:	IM_Object	0,0,FFT_Width-1,FFT_Height,6,0,0,24,43,FFT_Width-1,FFT_Height,PID_Main,0
AnalyzerOffImageD:	IM_Object	0,0,FFT_Width*2-2,FFT_Height*2,6,0,0,24,43,FFT_Width-1,FFT_Height,PID_Main,0

;-------------- Images fr den Titelzeilen Modus
ZipWinImageT1:		IM_Object	ZipWinImageT2,0,9,9,6,0,0,0,27,9,9,PID_Titlebar,0
ZipWinImageT1D:		IM_Object	ZipWinImageT2D,0,18,18,6,0,0,0,27,9,9,PID_Titlebar,0
ZipWinImageT2:		IM_Object	0,0,9,9,6,0,0,9,27,9,9,PID_Titlebar,0
ZipWinImageT2D:		IM_Object	0,0,18,18,6,0,0,9,27,9,9,PID_Titlebar,0

ActiveWindowImage2:	IM_Object	0,0,275,13,6,0,0,27,29,275,13,PID_Titlebar,0
ActiveWindowImage2D:	IM_Object	0,0,550,26,6,0,0,27,29,275,13,PID_Titlebar,0
InActiveWindowImage2:	IM_Object	0,0,275,13,6,0,0,27,42,275,13,PID_Titlebar,0
InActiveWindowImage2D:	IM_Object	0,0,550,26,6,0,0,27,42,275,13,PID_Titlebar,0

;Levelmeter im Titelzeilen Modus !! selber Puffer wie beim Analyzer verwendet !! (da mutal exclusive)
LevelmeterMapImage:	IM_Object	0,0,38,2,5,0,FFT_TrueBuffer,0,0,38,2,0,0
LevelmeterMapImageD:	IM_Object	0,0,38*2,2*2,5,0,FFT_TrueBuffer,0,0,38,2,0,0

;Dummy Image fr Palette von Scope, Levelmeter und Analyzer
DummyImage1:		IM_Object	0,0,0,0,7,FFT_ColourMap,0,0,0,0,0,0,0,0

END_IMAGES:
;---------------------------------------------------------------------------------------------------
	
gfx:
	incdir	EP:src/Engines/EagleAMP/
;	incdir	sources:engines/EagleAMP/
;	incdir	eps:sources/engines/empytrue/
	include	EagleAMPGfx.s
Gfxsize=*-gfx

	section	2,bss
Datas:
Exec_base	ds.l	1
Int_base	ds.l	1
Dos_base	ds.l	1
Gfx_base	ds.l	1
Util_base	ds.l	1
asl_base	ds.l	1
mathffp		ds.l	1
mathtrans	ds.l	1
guigfx		ds.l	1
popupmenulib	ds.l	1

mytags:		ds.l	20*2		;temporres Tagarray, nur valid fr einen Aufruf, wird
					;von praktisch allen Routinen verwendet, also mglichst
					;direkt vor Aufruf der entsprechenden Systemfunktion
					;verwenden
; Fensterbezogene Daten
mywindowlist:	ds.l	1		;momentan benutzte Windowliste
WinHandle:	ds.l	1
mypubscreen:	ds.l	1
mycmap:		ds.l	1		;fr Farballozierung
myScreentitle:	ds.l	1
tmpIMsg		ds.b	im_SIZEOF
ScrollSignal	ds.l	1		;Signal fr z.B. Blinken der Playbesttigung, Analyzer etc.
LastMenu	ds.l	1		;letztes verwendetes Men, falls Window open/close von Engine selbst ausgelst
AcceptRefresh	ds.b	1
		ds.b	1
PattTime	ds.w	1		;Delay fr IDCMPUPDATE Requests


; EP bezogene Daten
NextSelect	ds.l	1		;falls mehrere Menitems selektiert wurden...

; Daten fr Image-Berechnungen 
defaultpath	ds.b	400		;wird bei Loadpicture generiert
Picturename	ds.b	50		;name des zu ladenden Bildes

psm		ds.l	1
drawhandle	ds.l	1

Colourmap:	ds.w	256		;maximal 256 Farben in der CLUT
Colourmapsize	equ	*-Colourmap
Renderdepth	ds.w	1		;max. Tiefe der allozierten Farben
CI_UsedWindowList	ds.l	1	;Windowlist, die beim Erzeugen der Images verwendet wurde
CI_ScreenDepth		ds.b	1	;Tiefe des Screens merken, damit nicht stndig GetBitmapattr aufgerufen werden muss
			ds.b	1
TempDataArray		ds.l	1	;temporres Array fr die umgerechneten Chunkies
TempDataArraySize	ds.l	1	;Gre
TempBitmap1:	ds.l	1		;temporrer Pointer fr allozierte Bitmap
TempBitmap2:	ds.l	1		;temporre Bitmap fr WritePixelarray8
TempRastport1	ds.b	rp_SIZEOF	;imaginrer Rastport fr WritePixelarray8
TempRastport2	ds.b	rp_SIZEOF	;tempRastport fr WritePixelarray8

TempRastport3	ds.b	rp_SIZEOF	;tempRastport fr Printtext
TempRastport4	ds.b	rp_SIZEOF	;tempRastport fr Remote Volume

; Daten fr Gadgets
GD_FirstGadget:	ds.l	1		;erstes erzeugtes Gadget
GD_Count:	ds.w	1		;Anzahl der Gadgets, die erzeugt wurden
GD_PreviousGad:	ds.l	1		;fr Verkettung der Boopsi-Gadgets
GD_MyClass:	ds.l	1		;Custom-Class fr Gadget-Images
GD_LastImage:	ds.l	1		;hier Custom-Image gesichert, falls Fehler beim allozieren des Button-Objektes
GD_GadgetsIn:	ds.b	1		;Flag, ob Gadgets im Hauptfenster eingebunden
TrayOpen	ds.b	1		;Flag, ob Schublade offen/geschlossen

;--------------Daten fr Error-Requester-------------
MY_Easystruct:	ds.l	1	;EASY-Request
		ds.l	1
		ds.l	1
		ds.l	1
		ds.l	1

; Daten des Interruptservers
Ticks:		ds.w	1		;rundlaufender Zhler

VisColorMem:	ds.b	1024		;viscolor.txt
; Daten fr diverse Unterroutinen
Modnametmp:	ds.b	32		;ASCII-Zwischenspeicher fr Namensanzeige
bitratetmp:	ds.b	4		;ASCII-Zwischenspeicher fr Soundsystemanzeige
timetmp:	ds.b	10		;ASCII-Zwischenspeicher fr Zeitanzeige
PattTmp2:	ds.b	20		;ASCII-Zwischenspeicher fr Patternnummeranzeige
PattTmp:	ds.b	10		;ASCII-Zwischenspeicher fr Patternnummeranzeige
SubsongTmp2:	ds.b	20		;ASCII-Zwischenspeicher fr Patternnummeranzeige
SubsongTmp:	ds.b	10		;ASCII-Zwischenspeicher fr Patternnummeranzeige
tracktmp1:	ds.b	6		;
tracktmp2:	ds.b	6
PermerkLevelmeter:	ds.l	4	;4 Kanle,je 2 Wrter fr Levelmeter
SlowIDLevel:		ds.b	1
MuteID:			ds.b	1	;Muting an: <>0
MuteTMP:		ds.b	1	;fr Blinken der LED des Lautstrkereglers
			ds.b	1

AN_StructAdr:		ds.l	1	;UPS Struktur zwischenspeichern
LM_LastValue		ds.w	1	;letzter Levelmeter-Wert fr Averaging

	ifne	FXTask
; Daten fr den FX Task
FX_Disable		ds.b	1	;Flag vom Hauptprozess ob FX erlaubt sind
FX_Enabled		ds.b	1	;Flag vom FX Task, ob aktiv
FX_Quit			ds.b	1	;Flag vom Hauptprozess, wenn FX Task zu beenden ist
			ds.b	1
	ifne	Semaphore
Image_Semaphore:	ds.b	SS_Size	;Semaphore zur Vermeidung gleichzeitigen Zugriffs auf
					;ShowImage Funktion bei Verwendung des FX Tasks
	endc
	endc

; Daten, die mit der Config gespeichert werden
ConfigDatas:
EAMP_ID		ds.b	8		;ID ("EAMP") und Version (1)
picturepath	ds.b	400		;Pfad fr Laden der Bilder, default siehe bei "PictureList:"
ConfigDatasLen = *-ConfigDatas

; Daten fr den FFT-Analyzer
PermerkFFT:		ds.l	4	;4 Kanle,je 2 Wrter fr Analyzer
FFT_NumDisplay:		ds.w	1	;Anzahl der angezeigten Frequenzen
FFT_CurrentMode:	ds.l	1	;Bearbeitungsroutine aktueller Modus
FFT_slowid:		ds.b	1
FFT_slowcount:		ds.b	1
FFT_Stopanalyzer:	ds.b	1
FFT_Stoptime:		ds.b	1
FFT_Permerk:		ds.l	4
FFT_Mixfrequency	ds.l	1
FFT_Current_Num		ds.w	1
SpecialUPS:		ds.b	1
			ds.b	1

FFT_RealTabAdr:		ds.l	1
FFT_ImgTabAdr:		ds.l	1

FFT_OutTable:		ds.w	FFT_N*2	;Tabelle der Ausgangswerte der FFT (momentan 32 verwendet)
FFT_OutTableI:		ds.w	FFT_N*2
FFT_FinalTable:		ds.w	FFT_N*2 ;Tabelle der tatschlichen Ausgangswerte, die dann zur Anzeige kommen
FFT_Realtab:		ds.l	FFT_N*2
FFT_Imgtab:		ds.l	FFT_N*2
Bitreversetab:		ds.w	FFT_N
	ifeq	USEFPU
SinCostab:		ds.l	FFT_N*2
	else
SinCostabInt:		ds.l	FFT_N*[FFT_Gamma-2]	;in Wahrheit [2+4+8+16+32+...+N/2]*2
SinCostabFP:		ds.l	FFT_N				;aus N/2 ld N folgt Hlfte der sin/cos Eintrge redundant, also N anstelle N*2
	endc

;------- Umrechnung der N Punkte Trafo auf ursprngliche 2 N Punkte Eingangswerte ---------
SinTab2:		ds.l	FFT_N
CosTab2:		ds.l	FFT_N
FFT_StructAdr:		ds.l	1	;UPS Struktur zwischenspeichern
FFT_MaxDisplaytab:	ds.l	FFT_N	;davon momentan lediglich 32 Werte verwendet

			ds.l	FFT_Width*2
FFT_TrueBuffer:		ds.l	FFT_Width*FFT_Height	;Breite*Hhe*4 Bytes pro Pixel
			ds.l	FFT_Width*2
FFT_Analyzertab:	ds.b	FFT_Analyzertabsize

datasize	EQU	*-Datas
