*****************************************************************************
**                                                                         **
** Engine: BifatGui                                                        **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

*************************************************************************
* Was noch gar nicht geht:
*--------------------------
* - StringGadget/AbortGadget/Yes-NoGadget/Retry-CancelGadget (AddAGadget)
*************************************************************************
*************************************************************************
*              B I F A T  - G U I    for   Eagleplayer 2.0              *
* (C) 1995 Henryk "Buggs" Richter & Jan "Eagleeye" Blumenthal		*
*    Thanx to Bifat/TeK for designing this amazing User interface !     *
*************************************************************************
*3.8.1998: richtiges Setzen der Pens beim Rahmenzeichnen, sowie Bordergadgets
*6.8.1998: richtiges Setzen des Halfshadow Pens fr Hintergrund 
*10.8.98: Scroller/Printtext funktioniert wieder
*
*************************************************************************

ver		macro
		dc.b	"1.5"
		endm
StructVer	macro
		dc.w	1,5
		endm
date		macro
		dc.b	"10-Aug-98"
		endm
StructDate	macro
		dc.b	10,08
		dc.w	1998
		endm

Test		= 0

	incdir	include:
	include	exec/exec_lib.i
	include	dos/dos_lib.i
	include	exec/libraries.i
	include	exec/interrupts.i
	include	libraries/diskfont_lib.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	misc/BuggsMacros.i
	include	misc/EagleplayerEngine.i
	include	libraries/asl_lib.i
	include	libraries/asl.i

	include "intuition/icclass.i"
	include "intuition/classes.i"
        include "intuition/classusr.i"
        include "intuition/imageclass.i"
	include	libraries/utility_lib.i

	include	libraries/datatypes_lib.i
	include	datatypes/datatypes.i
	include	datatypes/pictureclass.i

	include	libraries/reqtools.i
	include	libraries/reqtools_lib.i

;===========================================================================
;		Definitionen & Vereinbarungen 
;===========================================================================
Defheight	=	63	;def. Innerheight
Defwidth	=	329	;def. Innerwidth
Defminwidth	=	280
Defminheight	=	54
*VolumeSteps	=	255	;64
*BalanceSteps	=	255*2	;128

win_breite	=	DefWidth

EPNr_PlayerManager	equ	0
EPNr_EngineManager	equ	0

GD_Volmin		equ	EPNr_FirstExternal
GD_Volmax		equ	EPNr_FirstExternal+1
GD_BalLeft		equ	EPNr_FirstExternal+2
GD_BalRight		equ	EPNr_FirstExternal+3
GD_Moduleinfo		equ	EPNr_FirstExternal+4
GD_Manager		equ	EPNr_FirstExternal+5
GD_AmplifierManager	equ	EPNr_FirstExternal+6
GD_ActiveAmplifier	equ	EPNr_FirstExternal+7

MI_FilterGadget		equ	EPNr_FirstExternal+8
MI_PubJumpGadget	equ	EPNr_FirstExternal+9
MI_IconifyGadget	equ	EPNr_FirstExternal+10
MI_BackPic		equ	EPNr_FirstExternal+11
MI_SelectBackPic	equ	EPNr_FirstExternal+12
MyNr_PubScreenJump	equ	EPNr_FirstExternal+13

Scroller	=	1
SCR_DefXPos	=	33
SCR_DefYPos	=	47
SCR_DefHeight	=	14
SCR_DefWidth	=	214

Time		=	1
Time_DefYPos	=	47
Time_DefHeight	=	14
Time_DefXPos	=	250
Time_Defwidth	=	46

StopByte	=1		;definitiv aufhren
RandByte	=0		;Text bis zum linken Rand scroll
RandByte2	="|"		;nchstes Zeichen bis zum linken Rand scroll

CallSys	macro
	jsr	_LVO\1(a6)
	endm

AlignH	macro
	and	#$ff,\1
	mulu	d6,\1
	divu	#100,\1
	add	d4,\1
	endm

AlignV	macro
	and	#$ff,\1
	mulu	d7,\1
	divu	#100,\1
	add	d5,\1
	endm

EB	macro
	if	test
	move.l	4,a6
	else
	move.l	4,a6
	endc
	ENDM

;===========================================================================
	section	0,code
;===========================================================================

	if	Test
		rsreset
		rs.b	EPG_SizeOf
SurfaceWaitBits	rs.l	1
PrivatEnde	rs.b	0


	bsr	OpenDefaultLibs
	bsr	FirstInit
	moveq	#1,d0
	bsr	OpenAWindow
	lea	PrivatPuffer,a5
	jsr	GetWaitMask
	lea	PrivatPuffer,a5
	move.l	d0,SurfaceWaitBits(a5)
	lea	Aboutmessage(pc),a0		;zu Printendes Zeichen
	bsr	InitCrunchDisplay

	move	#300,d0
	bsr	CrunchDisplay

	bsr	PrintText
	lea	Aboutmessage(pc),a0		;zu Printendes Zeichen
	bsr	NewScrollText
	lea	PrivatPuffer,a5


Wait:
	lea	PrivatPuffer,a5
	move.l	SurfaceWaitBits(a5),d0	
	move.l	4,a6
;	jsr	_LVOWait(a6)
	move.l	SurfaceWaitBits(a5),d1		;No SurfaceBits
	move.l	d0,d2
	and.l	d1,d2
	beq.s	.NoSurface
	jsr	SignalReceived
	lea	PrivatPuffer,a5


.NoSurface:
	bsr	scrollen
	bsr	ShowTime
.lop
	jsr	GetMsg				;Output: d0=ActionNr
	lea	PrivatPuffer,a5
	cmp.w	#EPNR_Quit,d0
	beq.s	.Quit
	tst	d0
	bne	.lop
	bra.w	Wait

.Quit:	moveq	#1,d0
	jsr	CloseAWindow
	lea	PrivatPuffer,a5
	jsr	FreeUserPrg
	rts
	illegal

OpenDefaultLibs:
	lea	PrivatPuffer,a5
	lea	int(pc),a1
	moveq	#37,d0
	move.l	4,a6
	jsr	_LVOopenlibrary(a6)
	move.l	d0,DTG_Intuitionbase(a5)

	lea	dos(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,DTG_Dosbase(a5)

	lea	graf(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,DTG_GFXBase(a5)
	move.l	a5,EUS_Structure+EUS_EPBase

	rts

PrivatPuffer	ds.b	PrivatEnde
		even

*******************************************************************
		movem.l	d1-d7/a1-a6,-(a7)
		move.l	EUS_TagList(a1),-(a7)		;Tagliste auf Stack
*		move.l	LoadFileName(a5),a1	;Ist das Label richtig ?
		move.l	#EUT_CheckForPlayer,-(a7)	;Tag auf Stack
		jsr	UserCallUp
		addq.l	#8,a7
		movem.l	(a7)+,d1-d7/a1-a6
*		beq.s	.NextUPrg		;beq=kein Tag
*		tst.l	d0			;d0=Fehlernummer
*		bne.s	.NextUPrg
*		move.l	a0,d0
*		beq.s	.NextUPrg
*******************************************************************


UserCallUp2:	movem.l	d1-a6,-(a7)
		bsr	UserCallUp
		movem.l	(a7)+,d1-a6
		rts

	*------- Auf Stack in -8 liegt Tag und -12 die Tagliste --------*
UserCallUp:	subq.l	#8,a7
		movem.l	d0/d2/a6,-(a7)
		move.l	12+8+8(a7),d0		;Liste
		beq.s	.NoList
		move.l	d0,a6
		move.l	12+8+4(a7),d0		;Tag
		bsr	FindTag2
;	moveq	#1,d2
;	lea	CheckForPlayer,a6
		tst.l	d2
		bne.s	.TagDa
.NoList:	movem.l	(a7)+,d0/d2/a6
		addq.l	#8,a7
		tst.l	8(a7)			;Liste ist leer
		rts

.TagDa:		move.l	#.UserReturn,16(a7)
		move.l	a6,12(a7)
		movem.l	(a7)+,d0/d2/a6
		rts

.UserReturn:	tst.l	8(a7)			;Z-Flag setzen (Liste da)
		rts


	*-----------------------------------------------------*
	*----------- Find-Tag Used Register d0/d2/a6 ---------*
	*-----------------------------------------------------*
FindTag2:	move.l	d3,-(a7)
		move.l	a7,d3

	*--------- Recursive FindTag-Routine ----------*
FindTag3:	moveq	#0,d2
		cmp.l	a6,d2
		beq.s	.Empty
		move.l	(a6)+,d2			;Tag rauslesen
		bne.s	.NoEmpty
.Empty:		cmp.l	d3,a7				;ak. Stack vergleichen
		beq.s	.TagNoFound
		move.l	(a7)+,a6
		bra.b	.NoMore
.NoEmpty:	cmp.l	d2,d0
		beq.s	.TagFound

	*----- Tag-Skip gefunden ???? -----*
		cmp.l	#Tag_Skip,d2
		bne.s	.NoSkip
		addq.l	#8,a6				;Diesen und nchsten
		addq.l	#4,a6				;Tag berspringen
		bra.s	.NoMore

	*------ Tag-More gefunden ???? -----*
.NoSkip:	cmp.l	#Tag_More,d2
		bne.s	.NoMore

		move.l	a6,-(a7)		;Adr der Tagliste sichern
		move.l	(a6),a6			;Neue Tagliste setzen
		bra.b	FindTag3
.NoMore:	addq.l	#4,a6
		bra.s	FindTag3
.TagFound:	move.l	(a6),a6
		move.l	a6,d2
.TagNoFound:	move.l	d3,a7
		move.l	(a7)+,d3
		tst.l	d2
		bne.s	.NoNull
		sub.l	a6,a6
.NoNull:	tst.l	d2
		rts

	endc

*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
;UserStartPrg
EUS_Structure:	moveq	#-1,d0				;EUS_Jump
		rts
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
EPBase		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	EUIB_OnlyActive			;EUS_TickFlags
		dc.l	USMB_NewModule			;EUS_MsgFlags
		dc.l	MyProzessName			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	37				;EUS_Kickstart
		dc.l	10				;EUS_EPVersion
		structver				;EUS_Version,EUS_Revision
		dc.l	MyMenuName			;EUS_Username
		dc.w	0				;EUS_WinX
		dc.w	14				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
		dc.w	DefWidth		;EUS_Special  -> InnerWidth
		dc.w	Defheight		;EUS_Special+2 -> InnerHeigth

		dc.b	$7,0				;EUS_Special2
		dc.w	0				;EUS_Special2
Winflags	equ	EUS_Special2		;Byte Flags frs Window
Time_mode	equ	EUS_Special2+1		;Byte Modus der Zeitanzeige

		dc.l	0				;EUS_Special3
		structdate				;EUS_Creatordate
		dc.b	0				;EUS_Prioritt
		dc.b	EUTY_MainWindow			;EUS_Type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6
		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

	dc.b	`$VER: Eagleplayer BifatGUI `
	ver
	dc.b	` (`
	date
	dc.b	`)`
	dc.b	0
	even

*----------------------------------------------------------------------------*
TagListe:	dc.l	EUT_InitEngine,FirstInit
		dc.l	EUT_ExitEngine,FreeUserPrg
		dc.l	EUT_OpenAWindow,OpenAWindow
		dc.l	EUT_CloseAWindow,CloseAWindow
		dc.l	EUT_DeActivate,CloseAWindow
*		dc.l	EUT_SetMenuStrip,SetMenuStrip
*		dc.l	EUT_ClearMenuStrip,ClearMenuStrip
		dc.l	EUT_GetMsg,GetMsg
		dc.l	EUT_GetWaitMask,GetWaitMask
		dc.l	EUT_EnableAll,EnableAll
		dc.l	EUT_DisableAll,DisableAll
		dc.l	EUT_GetConfig,GetConfig
		dc.l	EUT_Saveconfig,Saveconfig
		dc.l	EUT_NewConfig,NewConfig
	*	dc.l	EUT_UpdateVER,UpdateEPText		;|| Was soll das noch ?
	ifne	Scroller
		dc.l	EUT_NewScrollText,NewScrollText
		dc.l	EUT_PrintText,PrintText
		dc.l	EUT_Interrupt,ScrollANDTime
		dc.l	EUT_ClearTextWindow,ClearTextWindow
	endc
		dc.l	EUT_SignalReceived,SignalReceived
		dc.l	EUT_GetWindowHandle,GetWindowHandle
		dc.l	EUT_GetInterruptMask,GetInterruptMask

	*	dc.l	EUT_AddGadget,AddAGadget
	*	dc.l	EUT_RemoveGadget,RemoveAGadget
		dc.l	EUT_GetAbortMsg,GetAbortMsg
		dc.l	EUT_ChangeGui,ChangeGui		;nur Zustnde
		dc.l	EUT_ChangePrefs,ChangePrefs	;Zustnde,Slider
							;mit Refresh
		dc.l	EUT_GetPrefs,GetPrefs
		dc.l	EUT_GetGuiMenuStrip,GetMenuStrip
		*dc.l	EUT_FreeGuiMenuStrip,FreeMenuStrip

		dc.l	EUT_InitDisplay,InitCrunchDisplay
		dc.l	EUT_FillDisplay,CrunchDisplay
		dc.l	EUT_RemoveDisplay,EndCrunchDisplay
		dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_BifatGui
		dc.l	0

*----------------------------------------------------------------------------*
FirstInit:	move.l	4,a6
		cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
		blo	Raus			;nein,raus

		cmp	#39,LIB_Version(a6)
		bge.s	.nokillBackPic
		clr.l	SubItem3
.nokillBackPic



		lea	Datas,a5		;BSS lschen
		move.l	a5,a0
		move.w	#Dataslen-1,d0
.clr		clr.b	(a0)+
		dbf	d0,.clr

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	DTG_Intuitionbase(a4),IntSave(a5)
		move.l	DTG_Dosbase(a4),DosSave(A5)

		move.l	DTG_GFXBase(a4),GrafSave(a5)

		move.l	#-1,mypen(A5)	;Halfshine Farbe fr Gadgets, zur Sicherheit -1 gesetzt
		move.l	#-1,LastAmplifier(a5)

		move	#10,SCR_font_max(A5) 
					;!! Wichtig: Inititalwert !!!!!!!!!
					;wegen Fontrequest immer einen
					;definierten Wert hier drin, wenn
					;zu gro fr die aktuelle Scroller-
					;gre, wird das eh abgefangen

		suba.l	a1,a1
		jsr	_LVOFindTask(a6)
		move.l	d0,Mytask(a5)

		lea	dt(pc),a1
		moveq	#39,d0
		jsr	_LVOopenlibrary(a6)
		move.l	d0,DTBase(a5)

		lea	reqto(pc),a1
		moveq	#38,d0
		jsr	_LVOopenlibrary(a6)
		move.l	d0,RTBase(a5)

		lea	Util(pc),a1
		moveq	#37,d0
		jsr	_LVOOpenlibrary(a6)
		move.l	d0,Utility(a5)
		tst.l	d0
		beq	NoUTL

		lea	Diskf(pc),a1
		moveq	#33,d0
		jsr	_LVOOpenlibrary(a6)
		move.l	d0,DiskFont(a5)
		tst.l	d0
		beq	NoDISKF

		bsr	LoadConfig

		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
FreeUserPrg:	lea	Datas,a5
		moveq	#EPST_MainWindow,d0
		bsr	closeAWindow

	ifne	Scroller
		sub.l	a0,a0
		bsr	SetNewText
	endc

		move.l	DTBase(a5),d0
		beq.s	.nodt
		move.l	d0,a1
		EB
		jsr	_LVOCloselibrary(a6)
		clr.l	DTBase(A5)
.nodt

		move.l	DiskFont(a5),d0
		beq	NoDiskF
		move.l	d0,a1
		EB
		jsr	_LVOcloselibrary(a6)

NoDISKF:	move.l	Utility(a5),d0
		beq	noUtl
		move.l	d0,a1
		EB
		jsr	_LVOcloselibrary(a6)

NoUtl:
Raus		moveq	#EPR_ErrorAddUserPrg,d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0.w=Type des windows
*	 a0  =WindowName
*	 a1  =ScreenName
* Output:d0 = Error oder NULL
*-----------------------------------------------------------------------------*
OpenAWindow:	lea	Datas,a5
		cmp.w	#EPST_MainWindow,d0
		bne.s	NoMainWindow
		move.l	a0,Eaglename(a5)
		move.l	a1,Eaglename+4(a5)
		lea	EUS_Structure(pc),a4
		tst.l	WinHandle(a5)
		bne.s	.Ok

		bsr.w	AllocSignal

.SignalDa:	bsr.w	OpenWin
		tst.l	WinHandle(a5)
		beq.s	.FreeSignal
.OK:		moveq	#0,d0
		rts

.FreeSignal:	bsr.w	FreeSignal
.NoSignal:	moveq	#EPR_CantOpenWin,d0
		rts

NoMainWindow:	moveq	#EPR_ErrorInArguments,d0
		rts

NoMem:		moveq	#EPR_NotEnoughMem,d0
		rts

*-----------------------------------------------------------------------------*
GetWindowHandle:move.l Datas+WinHandle,d0
		rts

GetMenuStrip:
		lea	GuiMenu,a0
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0 = Type des Windows
* Output: --
*-----------------------------------------------------------------------------*
CloseAWindow:	lea	Datas,a5
		cmp.w	#EPST_MainWindow,d0
		bne.s	NoMainWindow
		tst.l	WinHandle(a5)
		beq.s	.NoWindow
		bsr.w	GetConfig
		bsr.w	CloseWin
		bsr.w	FreeSignal
.NoWindow:	moveq	#0,d0
		rts


**-----------------------------------------------------------------------------*
** Input: a1 = MenuStrip
** Output --
**-----------------------------------------------------------------------------*
*SetMenuStrip:	lea	Datas,a5
*		tst.w	MenuOn(a5)
*		bne.s	.NoSet
*		tst.l	NextSelect(a5)		;Bei SetMenuStrip wird
*		bne.s	.NoSet			;PD-Multiselect gelscht
*		move.l	WinHandle(a5),d0
*		beq.s	MenuNoWindow
*		move.l	d0,a0
*		move.l	IntSave(a5),a6
*		move.l	a1,MenuStrip(a5)
*		jsr	_LVOSetMenuStrip(a6)
*		move.w	#1,MenuOn(a5)
*.NoSet:		moveq	#0,d0
*		rts

**-----------------------------------------------------------------------------*
** Input: --
** Output: --
**-----------------------------------------------------------------------------*
*ClearMenuStrip:	lea	Datas,a5
*		tst.w	MenuOn(a5)
*		beq.s	MenuNoWindow
*		move.l	WinHandle(a5),d0
*		beq.s	MenuNoWindow
*		move.l	d0,a0
*		move.l	IntSave(a5),a6
*		jsr	_LVOClearMenuStrip(a6)
*MenuNoWindow:	clr.w	MenuOn(a5)
*		rts
*

*-----------------------------------------------------------------------------*
* Input: --
* Output: d0 = AktionsNr oder Null
*-----------------------------------------------------------------------------*
GetMsg:		lea	Datas,a5
		suba.l	a1,a1
		move.l	NextSelect(a5),d0		;Multiselect bei PDMenus
		bne.s	.NextSelect

		*--- Msg holen ---*
		EB
		move.l	Port(a5),d0
		beq.w	.Return
		move.l	d0,a0
		jsr	_LVOGetMSG(a6)
		tst.l	d0
		beq	.return				;TestLastNummer

	*----------- Auswertung der Window-Message -----------*

		*----- Teste EP-Messages --------*
		* Die Message wird nicht replyed *
		* Closewindow,Vanillakey,Menupick*
		* werden abgefragt.		 *
		*--------------------------------*
		* Input: a0=Nextselect or NULL
		* 	 a1=Message oder NULL
		* Output:d0=EPNr oder NULL
		*	 d1=NextSelect
		*	 a1=Message oder NULL
		*	 d2/a2=Arg1
		*	 d3/a3=Arg2
		*-------------------------------*
		move.l	d0,a1				*Message
		moveq	#0,d0
.NextSelect:	move.l	d0,a0
		move.l	EPBase(pc),a4
	ifeq	test
		jsr	ENPP_GetEPNrfromMessage(a4)	* In: a1=Message
	else
		moveq	#0,d0
		moveq	#0,d1
	endc
		movem.l	d0/d2,-(a7)

		move.l	d1,NextSelect(a5)

		move.l	a1,d0
		beq.s	.NoMsg
		move.l	im_class(a1),d7
		move.w	im_code(a1),d5 		<-
		move.l	im_Iaddress(a1),d6 	<-
		move.w	im_qualifier(a1),a4

		cmp.l	#idcmp_newsize,d7
		bne.s	.nonewsize

		move.l	winhandle(A5),a0

		move	wd_width(a0),d0
		cmp	LastWinWidth(A5),d0
		bne	.resize
		move	wd_height(a0),d0
		cmp	LastWinHeight(A5),d0
		beq	.nonewsize
.resize
		move	wd_width(a0),LastWinWidth(A5)
		move	wd_height(a0),LastWinHeight(a5)
		bsr.w	ResizeWindow
.nonewsize
		EB
		jsr	_LVOReplyMsg(a6)
.NoMsg:		movem.l	(a7)+,d0/d2

	tst.l	d0
	beq.w	.msg
	cmp.w	#EPnr_FirstExternal,d0
	blo.w	.Rts
	cmp.w	#EPnr_LastExternal,d0
	bhi.w	.Rts

	bsr	MenueAuswertung
	bra	GetMsg
.msg

	ifne	test
		cmp.l	#IDCMP_Closewindow,d7
		bne.s	.noclose
		moveq	#EPNR_Quit,d0
		bra.w	.Rts
.noclose
	endc
		cmp.l	#idcmp_idcmpupdate,d7		;wg. Boopsi Bug mit Relverify
		bne.s	.noupgad

		move.l	Utility(A5),a6		; Fr die Sliders, Wert direkt auslesen
		move.l	#PGA_Top,d0		; the tag we want
		moveq	#0,d1			; default = NULL
		move.l	d6,a0			; tags to a0
		jsr	_LVOGetTagData(A6)	; look for the tag
		move.l	d0,d2

		move.l	Utility(A5),a6		; Gadget ID suchen
		move.l	#GA_ID,d0
		move.l	d6,a0			; taglist to a0
		jsr	_LVOFindTagItem(A6)	; look for the tag
		tst.l	d0
		beq	GETMSG
		move.l	d0,a0
		move.l	4(a0),d0		; Gadget ID (muss im .w Bereich liegen, sonst non EP)
		ble	GETMSG

		moveq	#EPRMB_DownGadget!EPRMB_NoGuiInfo,d1
	
		cmp.w	#EPNr_NextPattern,d0
		beq.s	.PattWait
		cmp.w	#EPNr_PrevPattern,d0
		beq.s	.PattWait

		cmp.w	#EPNr_Balance,d0
		bne.w	.Volrts1
		sub.l	#EP_MaxVolume,d2		;0..128 auf -64..64
.Volrts1:	bra.w	.VolReturn

.Pattwait
		move	PattTime(a5),d3
		addq	#1,d3
		cmp	#1,d3
		blt.s	.no3
		moveq	#0,d3
.no3		move	d3,PattTime(A5)
		beq	.rts
		bra	GetMSG
.noupgad

	*-------------- Refresh the Window --------------------*
	* kann wahrscheinlich raus, wegen Smartrefresh Fenster *
.TestRefreshWindow:
;		cmp.l	#idcmp_refreshwindow,d7
;		bne.s	.TestNewSize
;	ifne	Scroller
;		bsr	PrintScrolRahmen	;Rahmen+Position/Gre
;	endc
;	ifne	time
;		bsr	PrintTimeRahmen		;Rahmen fr Zeitanzeige + Werte merken
;	endc
;		bsr	PrintVolBalRahmen	;Rahmen fr Volume/Balance
;		bra.w	GetMsg

	*--------------- neue Windowgre ----------------*
.TestNewSize:	cmp.l	#idcmp_newsize,d7
		beq	GetMSG

	*-------------- Gadget losgelassen ? ---------------*
.TestGadget_Up:	cmp.l	#idcmp_gadgetup,d7
		bne.w	.TestGadgetDown

;		clr.l	LastNummer(a5)
;		clr.l	LastNummerBoopsAdr(a5)

		move.l	d6,a1
		move.w	GG_GadgetID(a1),d0
		beq.w	GetMsg

		cmp.w	#EPNr_Volume,d0			;Beim loslassen nochmal Volume/Balance holen
		beq.w	.TestDownVolume
		cmp.w	#EPNr_Balance,d0
		beq.w	.TestDownBalance

		cmp	#GD_Volmin,d0
		beq.w	.vol0
		cmp	#GD_Volmax,d0
		beq.w	.vol255

		cmp	#GD_BalRight,d0
		beq.w	.balright
		cmp	#GD_BalLeft,d0
		beq.w	.balleft

		cmp	#GD_Moduleinfo,d0
		beq.w	.moduleinfo

		cmp	#EPNr_ToggleFilter,d0
		beq.w	.toggleFilter

		cmp	#EPNr_Iconify,d0
		beq.w	.toggleFilter

		cmp.w	#EPNr_LockModule,d0
		beq.w	.toggleFilter

		cmp	#MyNr_PubScreenJump,d0
		beq.w	.NextPubscreen

		cmp	#GD_Manager,d0
		beq.s	.ActivateManager

		cmp	#GD_AmplifierManager,d0
		beq.s	.ActivateAmpManager

		cmp	#GD_ActiveAmplifier,d0
		beq.s	.ActivateAmplifier

		cmp	#EPNr_Play,d0
		beq.s	.PlayToggle

		bra	.rts

.PlayToggle:	moveq	#-1,d2
		bra	.rts

.ActivateAmplifier:
		move.w	#EPNR_HelpLink,d0
		move.l	#EPNr_FirstEngine,d2
		lea	Help_ActiveAmplifier(pc),a0
		move.l	a0,d3
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d1
		btst	#EGPRF_Help,d1
		bne.w	.rts


		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_ActiveAmplifier(a0),d0
		beq.w	GetMsg
		move.l	d0,a0
		moveq	#0,d2
		move.w	EUS_UserNr(a0),d2
		beq.w	GetMsg
		moveq	#-1,d3
		move.l	#EPNr_EngineShowState,d0
		bra.w	.Rts

.ActivateAmpManager
		lea	AmpManager(pc),a0
		bra.s	.SetEngine

.ActivateManager:
		lea	Manager(pc),a0

		*-- a0=Enginename
.SetEngine:	move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	EPG_FirstUserStruct(a4),a3
.NextEngine:	move.l	(a3),d0
		beq.s	.LoadIt
		move.l	d0,a3
		move.l	UPrgS_Name(a3),a1
		jsr	ENPP_StringCmp(a4)
		beq.s	.Enable
		bra.s	.NextEngine

.Enable:	moveq	#EPNr_Engine,d0
		move.l	UPrgS_EngineNr(a3),d2
		moveq	#-1,d3
		bra.w	.rts

.LoadIt:	move.l	a0,a2
		jsr	ENPP_CalcStringSize(a4)
		move.l	d0,d2
		moveq	#0,d3
		moveq	#EPNr_LoadEngine,d0
		bra.w	.rts		

.NextPubscreen
;		move.l	winhandle(a5),d3
;		move.l	wd_wscreen(A3),d3		;aktueller Screen
		move.l	EPBase(pc),a3
		move.l	EPG_Pubscreen(a3),a3

		move.l	IntSave(a5),a6
		jsr	_LVOLockPubScreenList(a6)
		move.l	d0,a4

		TSTLIST	a4
		beq.s	.unlock
		move.l	LH_Head(a4),a0			;1. Node
.NextScreen:
		move.l	a0,a2				;Node Eintrag

		move.l	LN_Name(a2),a0
		move.l	a3,a1
.loop
		move.b	(a0)+,d0
		beq.s	.end
		cmp.b	(a1)+,d0
		beq.s	.loop
		bra.s	.find_next
.end		cmp.b	(a1),d0
		bne.s	.find_next

;		cmp.l	psn_Screen(a2),d3		;ist dies der aktuelle ?
;		bne.s	.find_next
.next_such
		TSTNODE	a2,a0				;nchste Node vorhanden ?
		beq	.findfirst
		move.l	a0,a2
.first_test
		move	psn_flags(a2),d0

		bra	.takethis

		and	#PSNF_Private,d0
		beq	.takethis
		bra	.next_such
.findfirst					;am Ende angelangt, also ersten Screen nochmal testen
		move.l	LH_Head(a4),a2
;		cmp.l	psn_Screen(a2),d3		;aufgeben, sonst mglicherweise Endlos-Loop
;		beq.s	.unlock
		bra	.first_test

.find_next
		TSTNODE	a2,a0				;nchste Node vorhanden ?
		bne	.NextScreen			;ja, nchsten testen
		bra.s	.Unlock
.takethis
		move.l	LN_Name(a2),a2
		lea	PubNameBuff(a5),a1
		move.l	a1,d2
;		move.l	a1,0
		move	#MAXPUBSCREENNAME-2,d0
.cp
		move.b	(a2)+,(a1)+
		dbf	d0,.cp	
		bra.s	.unlock2
.UnLock:
		moveq	#0,d2
.unlock2
		move.l	IntSave(a5),a6
		jsr	_LVOUnLockPubScreenList(a6)
		moveq	#0,d0
		tst	d2
		beq	.rts
		move.l	d2,a2
		moveq	#0,d1
		moveq	#EPNr_PublicScreen,d0
		bra	.rts

;		move.l	(a0),0
;		lea	PubNameBuff(a5),a1
;		jsr	_LVONextPubScreen(A6)
;		move.l	d0,d2
;		beq	.rts

.toggleFilter
		moveq	#0,d1
		moveq	#-1,d2
		bra	.rts
.moduleinfo
		lea	Moduleinfo(pc),a0
		bra.w	.SetEngine
.vol0
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.w	EPG_Volume(a0),d0
		bne.s	.set_vol0

		move	Lastvolume(a5),d2
;		cmp	#EP_MaxVolume,d2
;		beq.s	.set_Vol0
		bra.s	.set_Vol
.set_vol0
		move	d0,Lastvolume(a5)
		moveq	#0,d2
.set_Vol
		move	#EPNr_Volume,d0
		moveq	#0,d1

		*bsr	ChangePrefs
		bra	.rts
.vol255
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.w	EPG_Volume(a0),d0
		cmp.w	#EP_MaxVolume,d0
		bne.s	.set_volmax

		move	Lastvolume(a5),d2
;		beq.s	.set_Volmax
		bra.s	.set_Vol
.set_volmax
		move	d0,Lastvolume(a5)
		move.l	#EP_MaxVolume,d2
		bra.s	.set_Vol
.balright	
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.w	EPG_Balance(a0),d0
		cmp	#EP_MaxVolume,d0
		bne.s	.bal_no255
		moveq	#0,d2
		bra.s	.set_Bal
.bal_no255
		move.l	#EP_MaxVolume,d2
.set_Bal
		move	#EPNr_Balance,d0
		moveq	#0,d1
		bra	.rts
.balleft
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.w	EPG_Balance(a0),d0

		cmp	#-EP_MaxVolume,d0
		bne.s	.bal2_no255
		moveq	#0,d2
		bra.s	.set_Bal
.bal2_no255
		move.l	#-EP_MaxVolume,d2
		bra.s	.set_Bal

	*------------- Gadget runtergedrckt -------------*
.TestGadgetDown:
		cmp.l	#idcmp_gadgetdown,d7
		bne.w	.Return

		move.l	d6,a1
		move.w	GG_GadgetID(a1),d0

		cmp.w	#EPNr_NextPattern,d0
		beq.s	.patt_2
		cmp.w	#EPNr_PrevPattern,d0
		bne	GetMSG
.patt_2
		move	#-10,PattTime(A5)
		bra.w	.rts

;		move.l	d6,a1
;		move.w	GG_GadgetID(a1),d0
;		move.l	d0,LastNummer(a5)
;		move.l	d6,LastNummerBoopsAdr(a5)
;		cmp.w	#EPNr_PlayFaster,d0
;		beq.w	.rts
;		cmp.w	#EPNr_NextPattern,d0
;		beq.w	.rts
;		cmp.w	#EPNr_PrevPattern,d0
;		beq.w	.rts

		;Posi des Sliders holen
.TestDownVolume:
		clr	Lastvolume(a5)
.TestDownBalance:
		push	d0
		move.l	intsave(A5),a6
		move.l	a1,a0
		lea	mytags(A5),a1
		move.l	#PGA_Top,d0
		jsr	_LVOgetAttr(a6)
		move.l	d0,d1
		pop	d0
		tst.l	d1
		beq	GetMSG
		move.l	mytags(A5),d2
		cmp.w	#EPNr_Volume,d0
		bne.s	.TestDownBal

	*-- Wenn Help gedrckt ist, dann wird neuer Wert nicht --*
	*-- akzeptiert. Auf alten Wert zurcksetzen
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d1
		btst	#EGPRF_Help,d1
		beq.s	.KeinVolHelp
		moveq	#0,d2
		move.w	EPG_Volume(a0),d2
		bsr	ChangePrefs
.KeinVolHelp:	bra.w	.Rts				*d2: Volume Wert

.TestDownBal:	cmp.w	#EPNr_Balance,d0
		bne.w	GetMsg
		sub.l	#EP_MaxVolume,d2		;0..128 auf -64..64

	*-- Wenn Help gedrckt ist, dann wird neuer Wert nicht --*
	*-- akzeptiert. Auf alten Wert zurcksetzen
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d1
		btst	#EGPRF_Help,d1
		beq.s	.KeinBalHelp
		moveq	#0,d2
		move.w	EPG_Balance(a0),d2
		bsr	ChangePrefs
.KeinBalHelp:	bra.w	.Rts				*d2: Balance Wert


;.TestLastNummer:
;		move.l	LastNummer(a5),d0
;		beq.w	.Return
;	ifeq	test
;		move.l	d0,-(a7)
;		move.l	EPBase(pc),a6
;		move.l	DTG_Dosbase(a6),a6
;		moveq	#1,d1
;		jsr	_LVODelay(a6)
;		move.l	(a7)+,d0
;	endc
;
;	moveq	#-1,d1
;.w2	move	d1,$dff180
;	dbf	d1,.w2
;
;		cmp.w	#EPNr_PlayFaster,d0
;		beq.w	.Rts
;		cmp.w	#EPNr_NextPattern,d0
;		beq.w	.Rts
;		cmp.w	#EPNr_PrevPattern,d0
;		beq.w	.Rts
;		move.l	LastNummerBoopsAdr(a5),a1
;		cmp.w	#EPNr_Volume,d0
;		beq.w	.TestDownVolume
;		cmp.w	#EPNr_Balance,d0
;		beq.w	.TestDownBalance

	*------------------ Keine Nummer -----------------*
.Return:	moveq	#0,d0
	*------------------ Nummer zurck ----------------*
.rts:		moveq	#0,d1			*Flags
.VolReturn:	rts


*-----------------------------------------------------------------------------*
* Testet, ob ESC gedrckt wurde.
* Alle anderen Messages werden erstmal ignoriert.
GetAbortMsg:	lea	Datas,a5

		*--- Msg holen ---*
		EB
		move.l	Port(a5),d0
		beq.w	.NoOne
		move.l	d0,a0
		jsr	_LVOGetMSG(a6)
		tst.l	d0
		beq	.NoOne

		*--------- Daten aus Message holen --------*
		move.l	d0,a1
		move.l	im_class(a1),d7
		move.w	im_code(a1),d5 		<-
		move.l	im_Iaddress(a1),d6 	<-
		move.w	im_qualifier(a1),d4
		EB
		jsr	_LVOReplyMsg(a6)

		cmp.l	#RAWKEY,d7			*VANILLAKEY
		bne	.NoOne
		cmp.w	#$63,d5
		bne.s	.NoOne
		moveq	#EPNr_Abort,d1
		bra.s	.Ok

.NoOne:		moveq	#0,d1
.Ok:		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
* Input:  --
* Output: d0 = SignalMask (ohne InterruptMask)
*-----------------------------------------------------------------------------*
GetWaitMask:	moveq	#0,d0
		lea	Datas,a5
		move.l	Port(a5),d1
		beq.s	.NoPort
		move.l	d1,a0
		move.b	mp_sigbit(a0),d1
		bset	d1,d0
.NoPort:	rts

;------------------------------------------------------------------------------
;Menitemauswertung:
;Input: D0 - EPNr
;       D2 - Zustand, wenn ToggleCheck
;------------------------------------------------------------------------------
MenueAuswertung:
	cmp	#MI_FilterGadget,d0
	bne.s	.noFilter

	move	d2,d0
	and	#1,d0
	lsl	#2,d0				;Bit 2 = Filtergad
	move.b	Winflags+EUS_Structure(pc),d1
	and.b	#~4,d1
	or.b	d0,d1
	move.b	d1,Winflags+EUS_Structure

	bra	.bordergads
.noFilter

	cmp	#MI_PubJumpGadget,d0
	bne.w	.noPubJump

	move	d2,d0				;Bit 1 = PubJumpgad
	and	#1,d0
	add	d0,d0

	move.b	Winflags+EUS_Structure(pc),d1
	and.b	#~2,d1
	or.b	d0,d1
	move.b	d1,Winflags+EUS_Structure

.bordergads
	*------------------ Bordergadgets freigeben ---------------------*
		moveq	#0,d2
		lea	MyGad1(A5),a2
.Gadlo1:	move.l	(a2),d0
		beq.s	.none
		move.l	Winhandle(A5),a0
		move.l	d0,a1
		move.l	Intsave(A5),a6
		jsr	_LVORemoveGadget(a6)

.none		move.l	(a2),d0
		clr.l	(A2)+
		bsr	FreeBorderGadget		;Safe to call
		addq	#1,d2
		cmp	#3,d2
		bne	.gadlo1

	*-------- Bordergadgets erzeugen und ins Fenster einbinden ------*
		moveq	#0,d2
		lea	MyGad1(a5),a2

		move.b	Winflags+EUS_Structure(pc),d3
		and.b	#7,d3				;eigendlich Bldsinn...
;		clr.l	0
.gadlo:
		moveq	#0,d0

		lsr.b	#1,d3
		bcc.s	.skip
		move.l	d2,d0
		bsr	MakeBorderGadget		;Bordergadget erzeugen

;		addq.l	#1,0
.skip
		move.l	d0,(a2)+
		beq	.g_error
		move.l	d0,a1
		move.l	WinHandle(A5),a0
		moveq	#0,d0
		move.l	IntSave(a5),a6
		jsr	_LVOAddgadget(A6)
.g_error:	addq	#1,d2
		cmp	#3,d2
		bne	.gadlo

		suba.l	a2,a2
	ifeq	test
	move.l	Eaglename(a5),a1
	else
	lea	mywinname(pc),a1
	endc
		move.l	WinHandle(A5),a0
		jsr	_LVOSetWindowTitles(A6)

		move.l	winhandle(A5),a0
		move.l	IntSave(a5),a6
		jsr	_LVORefreshWindowFrame(a6)	;weil manchmal was ber steht
		bra	.reddy
.noPubJump
	cmp	#MI_IconifyGadget,d0
	bne.s	.noIconify

	move	d2,d0					;Bit 0 = Iconifygad
	and	#1,d0
	move.b	Winflags+EUS_Structure(pc),d1
	and.b	#~1,d1
	or.b	d0,d1
	move.b	d1,Winflags+EUS_Structure

	bra	.bordergads
.noIconify

	cmp	#MI_BackPic,d0
	bne.w	.noBackPic

.setBackfill
	move	d2,d0					;Bit 3 = Back Pic
	and	#1,d0
	lsl	#3,d0	

	move.b	Winflags+EUS_Structure(pc),d1
	and.b	#~[1<<3],d1
	or.b	d0,d1
	move.b	d1,Winflags+EUS_Structure

	tst.b	d0
	beq.s	.skiptest1
	tst.b	DT_Picturename(A5)			;Test, ob schon Name vorliegt
	bne.s	.skiptest1
	bsr	DT_Filerequest
	bne	.skiptest1

	lea	Subitem4(pc),a0
	move	mi_Flags(a0),d0
	and	#~CHECKED,d0
	move	d0,mi_Flags(a0)				;bser,bser Hack...

	moveq	#0,d2
	bra	.setBackfill
.skiptest1
.setpic
	*-------- Bild freigeben (wenn vorhanden) -----------------------*
		bsr	DT_FreePicture
	*-------- Halfshine Pen fr Gadgets freigeben -------------------*
		move.l	grafsave(A5),a6
		cmp.w	#39,lib_version(A6)
		blo	.kick20
		move.l	mypen(A5),d0
		move.l	mycmap(A5),a0
		jsr	_LVOReleasepen(A6)
		move.l	#-1,mypen(A5)
.kick20
	*-------- Halfshine Pen fr Hintergrund anfordern oder Pic Init ----------------*
		move.l	#-1,mypen(A5)

		move.b	Winflags+EUS_Structure(pc),d0
		and.b	#1<<3,d0		;Bit 3 = Back Pic
		beq.s	.pen

		bsr	DT_OpenPicture		;Bild ffnen
		bne.s	.kick2			;bei Fehler dann doch Pen
.pen
		move.l	grafsave(A5),a6
		cmp.w	#39,lib_version(A6)
		blo	.kick2

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		moveq	#0,d0
		moveq	#1,d1
		lea	mytags(a5),a1
		jsr	_LVOGetRGB32(A6)

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		move.l	a0,mycmap(A5)
		moveq	#-1,d0			;Number

		move.l	mytags(a5),d1		;Red
		lsr.l	#1,d1
		move.l	mytags+4(a5),d2		;Green
		lsr.l	#1,d2
		move.l	mytags(a5),d3		;Blue
		lsr.l	#1,d3

;		move.l	#123<<24,d1		;Red
;		move.l	#123<<24,d2		;Green
;		move.l	#123<<24,d3		;Blue

		lea	mytags(A5),a1
		move.l	#OBP_Precision,(a1)
		move.l	#PRECISION_IMAGE,4(a1)
		clr.l	8(A1)
		jsr	_LVOObtainBestPenA(A6)
		move.l	d0,mypen(A5)
.kick2		bsr	Resizewindow
		bra	.reddy
.noBackPic
	cmp	#MI_SelectBackPic,d0
	bne.w	.noselBackPic

	bsr	DT_Filerequest
	beq	.reddy

	move.b	Winflags+EUS_Structure(pc),d0
	and.b	#1<<3,d0		;Bit 3 = Back Pic
	beq	.reddy

	bra	.setpic
.noselBackPic
.reddy
	rts
;------------------------------------------------------------------------------------------------



*-----------------------------------------------------------------------------*
* Input: --
* Output:d0 = Signalmask (ohne WaitMask)
*-----------------------------------------------------------------------------*
GetInterruptMask:
		moveq	#0,d0
		lea	Datas,a5
		move.l	ScrollSignal(a5),d3	;fr Interrupt
		bset	d3,d0
		rts

*-----------------------------------------------------------------------------*
* Input:	d0 = SignaleSet
* Output:	d0 = ActionNr oder Null
*-----------------------------------------------------------------------------*
SignalReceived:	lea	Datas,a5
		move.l	ScrollSignal(a5),d3	;fr Interrupt
		btst	d3,d0
		beq.w	.Return
	ifne	Scroller
		bsr	Scrollen
	endc
	ifne	time
		bsr	ShowTime
	endc
.Return:	rts				;GetMsg wird trotzdem
						;aufgerufen

ScrollANDTime:
	ifne	Scroller
		bsr	Scrollen
	endc
	ifne	Time
		bsr	ShowTime
	endc
		moveq	#0,d0	
		move.b	SCR_Enable(a5),d0		*Scroller erlaubt ?
		rts					*ReturnMsg fr EP
	ifne	time
Time_MakeRastport:


		rts
ShowTime:
		lea	Datas,a5
		move.l	WinHandle(a5),d0	;Window berhaupt offen ?
		beq	.Break
		move.l	d0,a0

		move	Timecount(a5),d0
		addq	#1,d0
		and	#15,d0
		move	d0,Timecount(a5)
		bne.w	.Break

		move.l	GrafSave(A5),a6

		move.l	wd_RPort(A0),a4
		move.l	a4,a1

		moveq	#0,d0
		jsr	_LVOSetAPen(A6)			; set the pen

		move	TimeX(A5),d0
		move	TimeY(a5),d1
		move	d0,d2
		add	TimeWx(a5),d2
		move	d1,d3
		add	TimeWy(a5),d3
		subq	#2,d2
		subq	#2,d3
		addq	#1,d0
		addq	#1,d1
		move.l	a4,a1
		jsr	_LVOrectfill(A6)		;Hintergrund killen

		moveq	#1,d0
		move.l	a4,a1
		jsr	_LVOSetAPen(A6)			; set the pen

		move.l	SCR_FontAdr(a5),d0
		bne.s	.ok
		move	SCR_Fontheight(A5),d0
		bsr	SC_OpenFont	;entsprechenden Font ffnen (D0:Hhe)
		move.l	SCR_FontAdr(a5),d0
		beq	.break
.ok		move.l	a4,a1
		move.l	d0,a0

		jsr	_LVOSetFont(a6)

		bsr	.createLine			;in A0 String zurck, in D0 Lnge
		move.l	d0,d6
		beq.s	.break
		move.l	a0,a3
.stringloop
		move.l	d6,d0
		move.l	a4,a1
		move.l	a3,a0
		jsr	_LVOTextLength(a6)
		sub	TimeWx(A5),d0
		ble.s	.take
		subq	#1,d6
		ble.s	.break
		bra.s	.stringloop
.take
		neg	d0				;Max. Breite - Breite des Texts
		lsr	#1,d0				;Differenz / 2 = Offset

		move.l	SCR_FontAdr(A5),a2
		move.w	TF_Baseline(a2),d1		;Char Baseline = Y-Posi
		move	TimeWY(A5),d2			;zentrieren des Zeichens
		sub	SCR_TextAttr+ta_ysize(a5),d2	;in vertikaler Richtung
		ble.s	.skip				;wenn Zeichen kleiner als
		moveq	#0,d3				;max. Wert
		lsr	#1,d2
		addx	d3,d2
		add	d2,d1

.skip:
		add	TimeX(A5),d0
		add	TimeY(A5),d1
		move.l	a4,a1
		jsr	_LVOMove(A6)

		move.l	d6,d0
		move.l	a3,a0
		move.l	a4,a1
		jsr	_LVOText(A6)
.break
		rts
.createline
	lea	TimeTMP(A5),a0
	clr.b	(a0)

	move.b	Time_mode+EUS_Structure(pc),d0
	beq.s	.EPTime

	move.l	#`00:00`,(a0)+
	clr.b	(A0)
.ret
	lea	TimeTMP(A5),a0
	bsr	BerechStringsize
	rts
.EPTime
	move.l	EUS_Structure+EUS_EPBase(pc),a1
	move.l	EPG_CurrentTime(a1),d1
	ble.s	.ret
	divu	#60,d1
	move	d1,d0			;Minutes
	swap	d1			;Seconds
	and.l	#$ff,d1
	and.l	#$ffff,d0
	bsr	.long
	move.b	#`:`,(a0)+
	divu	#10,d1
	add.b	#`0`,d1
	move.b	d1,(a0)+
	swap	d1
	add.b	#`0`,d1
	move.b	d1,(a0)+
	clr.b	(A0)
	bra.s	.ret
.Long
	push	d0-d4/a1
	moveq	#8,d1
	lea	dectable(pc),a1
	moveq	#0,d4
.loopl
	moveq	#-1,d3
	move.l	-(a1),d2
.loop2l
	addq.b	#1,d3
	sub.l	d2,d0
	bcc.s	.loop2l
	add.l	d2,d0
	cmp.l	#1,d2
	beq.s	.okl
	tst.b	d4
	bne.s	.okl
	tst.b	d3
	beq.s	.nol
.okl
	moveq	#1,d4
	add.b	#`0`,d3
	move.b	d3,(a0)+
.nol
	dbf	d1,.loopl
	pop	d0-d4/a1
	rts

	endc

	ifne	Scroller
*-----------------------------------------------------------------------------*
*                bergabe eines neuen ScrolTextes                  	      *
* Input: A0 - Text, der gescrollt werden soll                       	      *
*		0 - terminiert = Text im Kreis scrollen (automatisch	      *
*                                ein Space bei Restart eingefgt)  	      *
*               1 - terminiert = sofort stoppen                 	      *
*               2 - terminiert = Text bis zum vorderen Rand scrollen,	      *
*                                sollte im Text ein `|` auftauchen, wird das  *
*                                darauffolg.                                  *
*                                Zeichen bis links an den Rand gescrollt      *
*-----------------------------------------------------------------------------*
* Input:  A0 = Text
* Output: --
*-----------------------------------------------------------------------------*
NewScrollText:	lea	Datas,a5
		bsr	SetNewText
		beq.s	.NoAdr
	ifeq	test
		lea	EPT_String(a0),a0
	endc
;		move.l	a0,0
		sf	SCR_Enable(A5)	;Scroller stop
		bsr	ClearBM		;Bitmap komplett lschen
		move.l	a0,SCR_ScrolText(A5)
		move.l	a0,SCR_ScrolCurr(A5)	;Aktueller Text

	*-------------- (Re)Initialisierung des Scrollers -------------*
		clr	SCR_maxoff(A5)	;zur Behebung von Offsetnderungen
		clr.w	SCR_Offset0(a5)	;Offsets fr links/rechts Plazierung der Zeichen
		move	SCR_font_max(a5),d0
		add	d0,d0
		move.w	d0,SCR_Offset1(a5)	;min. 2 Zeichen Platz
		clr.w	SCR_StepsLeft(a5)	;wieviele Schritte noch bis zum nchsten Char
		clr.w	SCR_NumSteps(a5)	;vieviele Schritte schon gescrollt wurde
		move.w	SCR_Width(A5),SCR_StopSteps(A5) ;wieviele Schritte noch bis
						;Stop, nur, damit Feld <>0
		sf	SCR_StopID(A5)		;Stop aus
		st	SCR_Enable(A5)	;Scroller start
.NoAdr:		rts

*----------------------------------------------------------------------------*
* Die Scrollroutine wird vom Eagleplayer aufgerufen. Registersichern ist     *
* nicht erforderlich.							     *
*----------------------------------------------------------------------------*
Scrollen:	lea	Datas,a5

		tst.b	SCR_Enable(a5)			;Scroller erlaubt ?
		beq	.break				;n, raus

		move.l	WinHandle(a5),d0	;Window berhaupt offen ?
		beq	.Break
		move.l	d0,a0
		move.w	MyHoehe1(a5),d0		;Window im ZIP-Modus ?
		cmp.w	WD_height(a0),d0
		beq.w	.Break

	*------------------ Nun scrollen ------------*
	
		move.l	SCR_ScrolCurr(a5),d2		;ScrolText
		beq.w	.break

		tst.l	SCR_RastPort+rp_BitMap(a5)	;RastPort berhaupt valid ?
		beq	.break				;n, Abbruch	

		subq	#1,SCR_StepsLeft(A5)		;neues Zeichen ?
		bgt.w	.nonew				;n..
		clr	SCR_StepsLeft(A5)		;zur Sicherheit

	*-----------------  Overflow Check ---------------*
		move	SCR_Offset1(a5),d0
	*	cmp.w	#Scrol_Breite+SCR_font_max*2+SCR_font_max*2,d0	;ori !

		move	SCR_font_max(A5),d1

		move	d1,d3
		lsl	#2,d3			;mal 4
		add.w	SCR_Width(A5),d3
		cmp	d3,d0

		blo.s	.nores						;ori

	*	sub.w	#Scrol_Breite+SCR_font_max*2,d0			;ori

		sub.w	SCR_width(A5),d0
		sub.w	d1,d0
		sub.w	d1,d0

		sub	SCR_maxoff(A5),d0		;justify
		move	d0,SCR_Offset1(a5)		;reset Position rechts
	;	sub	#SCR_font_max*2,d0
		sub	d1,d0
		sub	d1,d0
		move	d0,SCR_maxoff(a5)		;justify
		clr.w	SCR_Offset0(a5)			;reset Position links

	*------------- Neues Zeichen holen --------------*
.nores:		move.l	d2,a0		;ScrolText
.nextChar:	move.b	(a0)+,d0
		*bne.s	.Char
		*move.l	SCR_ScrolText(a5),a0
		*move.b	#` `,d0		;automatisch ein Space einfgen, bevor
					;Restart
.Char:		cmp.b	#StopByte,d0	;1=Stop nach Ende
		bne.s	.nodis
.disable:	clr.b	SCR_Enable(a5)
		bra	.break
.nodis:		cmp.b	#RandByte,d0	;0=Bis an vorderen Rand scrollen ->STOP
		bne.s	.nobisvorn
		subq.l	#1,a0			;selbes Zeichen
		moveq	#` `,d0			;Leerzeichen
		st	SCR_StopID(A5)
		bra.s	.id

.nobisvorn:	cmp.b	#RandByte2,d0	;`|`=Kennung: nchstes Zeichen bis vorn
		bne.s	.nostopID	;           scrollen

		push	a0			;wir wollen jetzt rauskriegen
		lea	-1(a0),a1		;wie
		move.l	SCR_ScrolText(a5),a0	;breit
		sub.l	a0,a1			;der
		move.l	a1,d0			;Text
					;ist, der vor dem Rest am linken Rand
		lea.l	SCR_RastPort(a5),a1	;steht, sprich
		move.l	GrafSave(A5),a6		;z.B. "Playing ", der
		jsr	_LVOTextLength(A6)	;dann mit rausgescrollt
		add.w	SCR_width(A5),d0	;werden muss, bevor
		move	d0,SCR_StopSteps(a5)	;der Scroller stoppt
		pop	a0
		st	SCR_StopID(A5)
		bra.s	.nextChar

.noStopID:	move.l	a0,SCR_ScrolCurr(a5)

	*-------------- Zeichen printen --------------*
.id:		move	SCR_Offset0(a5),d1
		bsr	PrintChar		;Zeichen an linke Seite printen
		add	d2,SCR_Offset0(A5)	;Posi fr nchstes Zeichen

		move	SCR_Offset1(A5),d1
		add	SCR_Width(a5),d1
		bsr	PrintChar		;selbes Zeichen an Rechten Rand printen
		move	d2,SCR_StepsLeft(A5)	;Breite des Zeichens

	*--------------- Ins Fenster bertragen --------*
.nonew:		bsr	IntoWindow
		addq	#1,SCR_Offset1(A5)      ;Position, von der ins Fenster kopiert wird

	*----------------- Zhler erhhen -------------*
		addq	#1,SCR_NumSteps(a5)	;wieviele Pixels schon geprintet wurden

		tst.b	SCR_StopID(A5)		;Stoppen, wenn am vorderen Rand ?
		beq.s	.nostop			;n

		move.w	SCR_NumSteps(a5),d1	;Rand erreicht ?
		cmp.w	SCR_StopSteps(a5),d1	;
		blo.s	.nostop			;

		sf	SCR_Enable(a5)		;yup, Scroller aus

.nostop:
.break:		rts

*-----------------------------------------------------------------------------*
* Input: a0=New TextStructAdr (vom Eagleplayer bekommen)
* Output:d0=New StructAdr
*-----------------------------------------------------------------------------*
SetNewText:	push	a0/a1/d1/a4/a6
		move.l	SCR_TextStructAdr(a5),d0
		move.l	a0,SCR_TextStructAdr(a5)
	ifeq	test
		move.l	d0,a4
.NextStruct:	move.l	a4,d0
		beq.s	.Return
		move.l	d0,a1
		move.l	(a1),a4
		move.l	EPT_StringSize(a1),d0
		beq.s	.StructFree
		EB
		jsr	_LVOFreeMem(a6)
.StructFree:	bra.b	.NextStruct
	endc
.Return:	pop	a0/a1/d1/a4/a6
		move.l	SCR_TextStructAdr(a5),d0		;Flags setzen
		rts

**-----------------------------------------------------------------------------*
** Input: d1=Bytesize
**	 a0=SourcePuffer
**	 a0=TargetPuffer
**Output: --
**-----------------------------------------------------------------------------*
*StringCopy:	tst.l	d1
*		blt.s	.Err
*.StringCopy2:	move.b	(a0)+,(a1)+
*		dbf	d1,.StringCopy2
*		clr.b	(a1)			;Null terminieren
*.Err		rts

***********************************************************************************************
*                              Progress Display Routines                                      *
***********************************************************************************************
;A0: EP_Text Struct
InitCrunchDisplay:
		lea	Datas,a5
		clr.b	SCR_Enable(A5)	;Scroller stop
		clr.l	SCR_LastPrinted(a5)
		bsr	PrintText

		tst.l	WinHandle(a5)
		beq.s	.Return
		bsr	ClearBM
.return
		clr	lastcrunchpos(A5)
		moveq	#0,d0
		rts
;--------------------------- Promille (1/1000) - Wert in D0 -----------------------------------
CrunchDisplay:
		lea	Datas,a5

		tst.l	WinHandle(a5)
		beq.s	.Return
;		bsr	ClearBM

		push	d0

		moveq	#3,d0				;Background
		move.l	WinDrawInfo(a5),d1
		beq	old2$
		move.l	d1,a1
		move.l	dri_Pens(a1),d1
		beq	old2$
		move.l	d1,a1
		move.w	FILLPEN*2(a1),d0
old2$
		lea.l	SCR_RastPort(a5),a1
		move.l	GrafSave(a5),a6
		jsr	_LVOSetAPen(A6)			; set the pen
		pop	d0

		cmp	#1000,d0			;Zur Sicherheit
		blo.s	.lo
		move	#1000,d0
.lo
		move	SCR_Width(A5),d2
		mulu	d0,d2
		divu	#1000,d2		;X Max

		move	lastcrunchpos(A5),d0	;X Min
		move	d2,lastcrunchpos(a5)

		cmp	d2,d0
		bge.s	.print

;		moveq	#0,d0			;X Min
		moveq	#0,d1			;Y Min
		move	SCR_font_max(A5),d3	;Y Max
		lea.l	SCR_RastPort(a5),a1
		jsr	_LVOrectfill(A6)		;Hintergrund killen
.print
		move.l	SCR_LastPrinted(a5),d0
		beq.s	.Return
		move.l	d0,a0

		moveq	#1,d7
		bra	Printtext2
.Return
		moveq	#0,d0			;kein Fehler...
		rts
EndCrunchDisplay:
		lea	Datas,a5
		tst.l	WinHandle(a5)
		beq.s	.NoWindow
		bsr	ClearBM
		bsr	IntoWindow
.NoWindow	rts




*-----------------------------------------------------------------------------*
* Input: a0=TextStructAdr
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
PrintText:
		moveq	#0,d7
		lea	Datas,a5

		bsr	SetNewText
		beq.w	NoMem
		lea	EPT_String(a0),a0

* Input: D7=0 - Hintergrund killen, sonst nicht
PrintText2:
		move.l	a0,a4
		move.l	a0,SCR_LastPrinted(a5)

		tst.l	WinHandle(a5)
		beq.w	.NoWindow

		tst.w	d7
		bne.s	.noclear
		bsr	ClearBM
.noclear
		lea	SCR_RastPort(a5),a3

	*------------- Modus Jam1 wegen Crunchanzeige, damit Hintergrund bleibt ------*
		move.l	a3,a1
		moveq	#RP_JAM1,d0
		move.l	GrafSave(a5),a6
		jsr	_LVOsetDrMd(A6)

		moveq	#1,d0				;Foreground
		move.l	WinDrawInfo(a5),d1
		beq	old1$
		move.l	d1,a1
		move.l	dri_Pens(a1),d1
		beq	old1$
		move.l	d1,a1
		move.w	TEXTPEN*2(a1),d0
old1$
		move.l	a3,a1
		jsr	_LVOSetAPen(A6)

		moveq	#0,d0				;Background
		move.l	WinDrawInfo(a5),d1
		beq	old2$
		move.l	d1,a1
		move.l	dri_Pens(a1),d1
		beq	old2$
		move.l	d1,a1
		move.w	BACKGROUNDPEN*2(a1),d0
old2$
		move.l	a3,a1
		jsr	_LVOSetBPen(A6)

	*--------------- Position festlegen --------------*
		move.l	a3,a1
		moveq	#2,d0			;X-Posi
		move.l	SCR_FontAdr(a5),a2
		move.w	TF_Baseline(a2),d1	;Char Baseline = Y-Posi

		move	SCR_Font_Max(a5),d2		;zentrieren des Zeichens
		sub	SCR_TextAttr+Ta_YSize(a5),d2	;in vertikaler Richtung
		ble.s	.Skip				;wenn Zeichen kleiner als
		moveq	#0,d3				;max. Wert
		lsr	#1,d2
		addx	d3,d2
		add	d2,d1
.Skip:		jsr	_LVOMove(a6)

	*--------------- Textlnge berechnen ----------------*
		move.l	a4,a0
		bsr	BerechStringSize
		move.l	d0,d3
		bra.s	.jumpin
.RetryIt:
		subq.l	#1,d3
		move.l	d3,d0
.jumpin
		move.l	d0,d6
		move.l	a3,a1
		move.l	GrafSave(a5),a6
		move.l	a4,a0
		jsr	_LVOTextLength(a6)

		move.w	SCR_Width(a5),d4	;Breite <- !!!!
		sub	SCR_LimitWidth(a5),d4	;minus Limit
		subq.l	#4,d4			;kleiner Rand links/rechts
		ble.s	.NoWindow		;check!
		cmp.w	d0,d4
		blt.s	.RetryIt

		move.l	a3,a1
		move.l	a4,a0
		move.l	d6,d0
		jsr	_LVOText(a6)

		clr.w	SCR_Offset1(a5)
		bsr	IntoWindow

	*------------------- Scrollen verbieten ----------------*
		clr.b	SCR_Enable(a5)	;Scroller stop
.NoWindow:	moveq	#0,d0
		rts

.Error:		moveq	#EPR_UnknownError,d0
		rts


*-----------------------------------------------------------------------------*
* Input:  --
* Output: --
*-----------------------------------------------------------------------------*
ClearTextWindow:lea	Datas,a5
		clr.b	SCR_Enable(A5)	;Scroller stop
		clr.l	SCR_LastPrinted(a5)
		bsr	ClearBM				;Bitmap komplett lschen
		bsr	IntoWindow
		rts
	endc

*-----------------------------------------------------------------------------*
* Input: --
*Output: --
*-----------------------------------------------------------------------------*
EnableAll:	lea	Datas,a5
		tst.w	GadgetsDa(a5)
		bne.s	.None

		move.l	IntSave(a5),a6
		move.l	WinHandle(a5),d0
		beq.s	.None
		move.l	d0,a0
		move.l	GD_FirstGadget(a5),a1
		move.w	GD_Count(a5),d0
		beq.s	.None
		jsr	_LVOAddGList(a6)

		bsr	RefreshWindowframe

*		bsr	SetMenuStrip

		move.w	#1,GadgetsDa(a5)
.None:		rts

*******************************************************************************
*                    Rand und Bordergadgets refreshen                         *
*******************************************************************************
RefreshWindowframe:
		push	all

		move.l	winhandle(A5),d0
		beq.s	.error

		move.l	WinHandle(A5),a0
		jsr	_LVORefreshWindowFrame(a6)	;weil manchmal was ber steht

		lea	MyGad1(a5),a4
		moveq	#3-1,d5
.ref		move.l	(a4)+,d0
		beq.s	.next
		move.l	d0,a0
		moveq	#1,d0
		move.l	WinHandle(a5),a1
		suba.l	a2,a2
 		move.l	IntSave(A5),a6
		jsr	_LVORefreshglist(A6)
.next		dbf	d5,.ref
.error	
		pop	all
		rts

*-----------------------------------------------------------------------------*
* Input: --
*Output: --
*-----------------------------------------------------------------------------*
DisableAll:	lea	Datas,a5
		tst.w	GadgetsDa(a5)
		beq.s	.None
		move.l	IntSave(a5),a6
		move.l	WinHandle(a5),d0
		beq.s	.None
		move.l	d0,a0
		move.l	GD_FirstGadget(a5),a1
		move.w	GD_Count(a5),d0
		beq.s	.None
		jsr	_LVORemoveGList(a6)
.None:
*		bsr	ClearMenuStrip
		clr.w	GadgetsDa(a5)
		rts



*-----------------------------------------------------------------------------*
* Input:	d0 = 0 -> registriert
*		     1 -> nicht reg.
*		a0 = APtr auf ?.??	z.B 2.00
* Output: --
*-----------------------------------------------------------------------------*
;UpdateEPText:	lea	EPVer1(pc),a1
;		moveq	#3,d0
;.CopyIt:	move.b	(a0)+,(a1)+
;		dbf	d0,.CopyIt
;		rts

*-----------------------------------------------------------------------------*
* Input: in EUS
* Output: --
*-----------------------------------------------------------------------------*
NewConfig:	lea	Datas,a5
		bsr	CloseWin

		move.w	EUS_Structure+EUS_Flags(pc),d0
		btst	#EUSF_Openwin,d0
		bne.s	.NoOpen
		bsr	OpenWin
.NoOpen:	rts

*-----------------------------------------------------------------------------*
* Input: --
* Output: EUS_
*-----------------------------------------------------------------------------*
GetConfig:	lea	Datas,a5
		lea	EUS_Structure(pc),a4
		clr.w	EUS_Flags(a4)
		move.l	WinHandle(a5),d0
		beq.w	.NoWin
		move.w	#EUSB_Openwin,EUS_Flags(a4)
		move.l	d0,a0
		moveq	#0,d0
		move.w	Wd_LeftEdge(a0),d0
		move.w	d0,EUS_WinX(a4)
		move.w	Wd_TopEdge(a0),d0
		move.w	d0,EUS_WinY(a4)

		moveq	#0,d1
		move.w	Wd_Width(a0),d0
		move.b	WD_BorderLeft(a0),d1
		sub.w	d1,d0
		move.b	WD_BorderRight(a0),d1
		sub.w	d1,d0
		move.w	d0,EUS_Special(a4)

		move.w	Wd_Height(a0),d0
		move.b	WD_BorderTop(a0),d1
		sub.w	d1,d0
		move.b	WD_BorderBottom(a0),d1
		sub.w	d1,d0
		move.w	d0,EUS_Special+2(a4)

		lea	SubItem1(pc),a0		;muss eigentlich nicht sein, wird auch so erledigt...
		move	mi_Flags(a0),d0
		and	#CHECKED,d0
		lsr	#6,d0			;Bit 2 = Filtergad
		move	mi_Flags+Subitem2-Subitem1(a0),d1
		and	#CHECKED,d1
		lsr	#7,d1			;Bit 1 = PubJumpgad
		or.b	d1,d0
		move	mi_Flags+Subitem3-Subitem1(a0),d1
		and	#CHECKED,d1
		lsr	#8,d1			;Bit 0 = Iconifygad
		or.b	d1,d0
		move	mi_Flags+Subitem4-Subitem1(a0),d1
		and	#CHECKED,d1
		lsr	#8-3,d1			;Bit 3 = Back Pic
		or.b	d1,d0
		move.b	d0,Winflags(A4)

;	bsr	SaveConfig		;nach EUT_Saveconfig umbewegen (wenn im EP implementiert)

.NoWin:		moveq	#0,d0
		rts



*-----------------------------------------------------------------------------*
AllocSignal:	tst.l	ScrollSignal(a5)
		bne.s	.SignalDa
		moveq	#-1,d0
		EB
		jsr	_LVOAllocSignal(a6)	;2. Signal allokieren (fr Interrupt)
		tst.l	d0
		blt	.SignalDa
		move.l	d0,ScrollSignal(a5)
.SignalDa:	rts

*-----------------------------------------------------------------------------*
FreeSignal:	move.l	ScrollSignal(a5),d0
		beq.s	.NoSignal
		EB
		jsr	_LVOFreeSignal(a6)
.NoSignal:	clr.l	ScrollSignal(a5)
		rts


		
*-----------------------------------------------------------------------------*

;============= Save Player Config Routine ===========================
SaveConfig:
	movem.l	d0-a6,-(sp)
	lea	datas,a5
	
	move.l	DosSave(A5),a6

	move.l	EPBase(pc),a0
	move.l	EPG_ConfigDirArrayPtr(a0),d1
	moveq	#-2,d2			;access_read
	jsr	_LVOlock(a6)
	tst.l	d0
	beq	.nolock			;Path not found
	move.l	d0,d1
	jsr	_LVOcurrentdir(A6)
	move.l	d0,d7

	lea	savename(pc),a1
	move.l	a1,d1
	move.l	#1006,d2		;MODE_NEWFILE
	jsr	_LVOopen(A6)
	move.l	d0,d6
	beq.s	.fail

	move.l	d0,d1				;Handle
	lea	ConfigDatas(A5),a1
	move.l	a1,d2				;Adr
	move.l	#ConfigDatasEND-ConfigDatas,d3	;len
	jsr	_LVOwrite(a6)

	move.l	d6,d1
	jsr	_LVOclose(a6)
.fail
	move.l	d7,d1
	jsr	_LVOCurrentdir(A6)
	move.l	d0,d1
	jsr	_LVOUnlock(A6)
.nolock
.error
	movem.l	(Sp)+,d0-a6
	rts
;============= Load Player Config Routine ===========================
Loadconfig:
	movem.l	d0-a6,-(sp)

	move.l	dossave(a5),a6

	move.l	epbase(pc),a0
	move.l	EPG_ConfigDirArrayPtr(a0),d1
	moveq	#-2,d2			;access_read
	jsr	_LVOlock(a6)
	tst.l	d0
	beq	.nolock			;Path not found
	move.l	d0,d1
	jsr	_LVOcurrentdir(A6)
	move.l	d0,d7

	lea	savename(pc),a1
	move.l	a1,d1
	move.l	#MODE_Oldfile,d2		;MODE_NEWFILE
	jsr	_LVOopen(A6)
	move.l	d0,d6
	beq.s	.fail

	move.l	d0,d1				;Handle
	lea	ConfigDatas(A5),a1
	move.l	a1,d2				;Adr
	move.l	#ConfigDatasEND-ConfigDatas,d3	;len
	jsr	_LVOread(a6)

	move.l	d6,d1
	jsr	_LVOclose(a6)
.fail
	move.l	d7,d1
	jsr	_LVOCurrentdir(A6)
	move.l	d0,d1
	jsr	_LVOUnlock(A6)
.nolock
.error
	movem.l	(sp)+,d0-a6
	rts

savename:	dc.b	`BifatGUI.cfg`,0

	cnop	0,4

************************************************************************
*                   Fenster ffnen                                     *
************************************************************************
Openwin:
		tst.l	winhandle(a5)
		bne.w	.NoPub

	move.b	Winflags+EUS_Structure(pc),d1
	lea	SubItem1(pc),a0
	move.b	d1,d0
	lsl	#6,d0			;Bit 2 = Filtergad
	and	#CHECKED,d0
	move	mi_Flags(a0),d2
	and	#~Checked,d2
	or	d0,d2
	move	d2,mi_flags(A0)

	move.b	d1,d0
	lsl	#7,d0			;Bit 1 = PubJumpGad
	and	#CHECKED,d0
	move	mi_Flags+Subitem2-Subitem1(a0),d2
	and	#~Checked,d2
	or	d0,d2
	move	d2,mi_Flags+Subitem2-Subitem1(a0)

	move.b	d1,d0
	lsl	#8,d0			;Bit 0 = IconifyGad
	and	#CHECKED,d0
	move	mi_Flags+Subitem3-Subitem1(a0),d2
	and	#~Checked,d2
	or	d0,d2
	move	d2,mi_Flags+Subitem3-Subitem1(a0)

	move.b	d1,d0
	lsl	#8-3,d0			;Bit 3 = Back Pic
	and	#CHECKED,d0
	move	mi_Flags+Subitem4-Subitem1(a0),d2
	and	#~Checked,d2
	or	d0,d2
	move	d2,mi_Flags+Subitem4-Subitem1(a0)

	move.l	EPBase(pc),a0
	lea	VolExtra+4(pc),a1
	move.w	EPG_Volume(a0),d0
	move	d0,VolExtra+4
	move	d0,Lastvolume(a5)

	move.w	EPG_Balance(a0),d0
	add.w	#EP_MaxVolume,d0
	move.w	d0,BalExtra+4-(VolExtra+4)(a1)

		move.l	IntSave(a5),a6
		move.l	EPG_PubScreen(a0),a0
		jsr	_LVOlockpubscreen(a6)	;aktuellen Publicscreen rauskriegen
		move.l	d0,MyPubScreen(a5)	;fr UnLockpubscreen()
		beq	.Error			;sollte nicht auftreten
		move.l	d0,a1
		move.l	sc_font(a1),a0

		move.w	ta_ysize(a0),d0		;Hhe des Screenfonts
		move.w	d0,d1
		add.w	#3,d1			;Berechnen der Gre fr ZIPwindow()
		move.w	d1,myhoehe1(a5)		;und eintragen
	
		moveq	#0,d0
	*	lea	begin(pc),a0
		lea	MyTags(a5),a1		;WINDOW INIT

		move.l	#wa_top,(a1)+
	*	move.l	#00,(a1)+
	clr.w	(a1)+
	move.w	EUS_Structure+EUS_WinY(pc),(a1)+
		move.l	#wa_left,(a1)+
	*	move.l	#0,(a1)+
	clr.w	(a1)+
	move.w EUS_Structure+EUS_WinX(pc),(a1)+
		move.l	#wa_innerwidth,(a1)+	;Breite
	*	move.l	#win_breite,(a1)+	;20Spalten+15*8Pixel fr Gadgets+Rand
	clr.w	(a1)+
	move.w EUS_Structure+EUS_Special(pc),(a1)+ ;Width
		move.l	#wa_innerheight,(a1)+	;Hhe
	*	move.l	#defheight,d1
	moveq	#0,d1
	move.w EUS_Structure+EUS_Special+2(pc),d1

		move.l	d1,(a1)+
		move.w	d1,win_hoehe(a5)
		move.l	#wa_flags,(a1)+
	move.l	#Windowdrag!Windowdepth!Windowclose!nocarerefresh,(a1)+

;	move.l	#WA_TITLE,(a1)+
;
;	ifeq	test
;	move.l	Eaglename(a5),(a1)+
;	else
;	lea	mywinname(pc),a0
;	move.l	a0,(a1)+
;	endc

	move.l	#WA_ScreenTitle,(a1)+
	move.l	Eaglename+4(a5),(a1)+

	move.l	#WA_PubScreenName,(a1)+
	move.l	EPbase(pc),a0
	move.l	EPG_PubScreen(a0),(a1)+

	move.l	#WA_Newlookmenus,(a1)+
	move.l	#1,(a1)+

		move.l	#wa_idcmp,(a1)+
  move.l	#idcmp_idcmpupdate!idcmp_rawkey!idcmp_menupick!idcmp_newsize!gadgetup!gadgetdown!closewindow!vanillakey!refreshwindow,(a1)+
;  move.l	#idcmp_rawkey!idcmp_menupick!idcmp_newsize!gadgetup!gadgetdown!closewindow!vanillakey!refreshwindow,(a1)+
		move.l	#wa_autoadjust,(a1)+
		move.l	#1,(a1)+
		move.l	#wa_maxwidth,(A1)+
		move.l	#1400,(a1)+
		move.l	#wa_maxheight,(a1)+
		move.l	#450,(a1)+
		move.l	#wa_minwidth,(A1)+
		move.l	MyPubScreen(a5),a0

		move.b	sc_wborleft(a0),d0
		add.b	sc_wborright(a0),d0
		ext.w	d0
		ext.l	d0
		add.l	#Defminwidth,d0
		move.l	d0,(a1)+

		move.l	#wa_minheight,(A1)+

		move.b	sc_BarHeight(a0),d1
		add.b	sc_wborbottom(a0),d1
		ext.w	d1
		ext.l	d1
		add.l	#Defminheight+1,d1	;wg. sc_barheight
		move.l	d1,(a1)+

		move.l	#wa_zoom,(a1)+
		lea	MyZoom(a5),a0
		move.w	#0,(a0)
		move.w	#112,2(a0)
		move.w	d0,4(a0)		;Breite des Zip-Windows im SMALL-MODE
		move	d1,myhoehe2(a5)
		move.l	a0,(a1)+
		move.l	#TAG_DONE,(a1)+

		suba.l	a0,a0
		lea	MyTags(a5),a1
		move.l	IntSave(a5),a6
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,WinHandle(a5)
		tst.l	d0
		bne.s	.WinOpened

		lea	MyTags(a5),a1		;Fehler,nochmal auf Position 0/0
		move.l	#wa_top,(a1)+		;zu ffnen versuchen
		move.l	#0,(a1)+
		move.l	#wa_left,(a1)+
		move.l	#0,(a1)+

		suba.l	a0,a0
		lea	MyTags(a5),a1
		move.l	IntSave(a5),a6
		jsr	_LVOOpenWindowTagList(a6)	;wirst DU wohl aufgehen !
		move.l	d0,WinHandle(a5)
		tst.l	d0
		beq.w	.Error
.winopened:	move.l	d0,a0
		move.l	WD_UserPort(a0),a0	;User Port
		move.l	a0,Port(a5)

	*-------- Drawinfo vom Screen anfordern ----------------------------------------*
		move.l	WinHandle(a5),a0
		move.l	wd_WScreen(a0),a0
		move.l	IntSave(a5),a6
		jsr	_LVOGetScreenDrawInfo(a6)
		move.l	d0,WinDrawInfo(a5)

	*-------- Halfshine Pen fr Hintergrund anfordern oder Pic Init ----------------*
		move.l	#-1,mypen(A5)

		move.b	Winflags+EUS_Structure(pc),d0
		and.b	#1<<3,d0		;Bit 3 = Back Pic
		beq.s	.pen

		bsr	DT_OpenPicture		;Bild ffnen
		bne.s	.kick2			;bei Fehler dann doch Pen
.pen
		move.l	grafsave(A5),a6
		cmp.w	#39,lib_version(A6)
		blo	.kick2

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		moveq	#0,d0
		moveq	#1,d1
		lea	mytags(a5),a1
		jsr	_LVOGetRGB32(A6)

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		move.l	a0,mycmap(A5)
		moveq	#-1,d0			;Number

		move.l	mytags(a5),d1		;Red
		lsr.l	#1,d1
		move.l	mytags+4(a5),d2		;Green
		lsr.l	#1,d2
		move.l	mytags(a5),d3		;Blue
		lsr.l	#1,d3

;		move.l	#123<<24,d1		;Red
;		move.l	#123<<24,d2		;Green
;		move.l	#123<<24,d3		;Blue

		lea	mytags(A5),a1
		move.l	#OBP_Precision,(a1)
		move.l	#PRECISION_IMAGE,4(a1)
		clr.l	8(A1)
		jsr	_LVOObtainBestPenA(A6)
		move.l	d0,mypen(A5)
.kick2
	*-------- Bordergadgets erzeugen und ins Fenster einbinden ------*
		moveq	#0,d2
		lea	MyGad1(a5),a2

		move.b	Winflags+EUS_Structure(pc),d3
		and.b	#7,d3				;eigendlich Bldsinn...
.gadlo:	
		moveq	#0,d0

		lsr.b	#1,d3
		bcc.s	.skip
		move.l	d2,d0
		bsr	MakeBorderGadget		;Bordergadget erzeugen
.skip
		move.l	d0,(a2)+
		beq	.g_error
		move.l	d0,a1
		move.l	WinHandle(A5),a0
		moveq	#0,d0
		move.l	IntSave(a5),a6
		jsr	_LVOAddgadget(A6)
.g_error:	addq	#1,d2
		cmp	#3,d2
		bne	.gadlo

		suba.l	a2,a2
	ifeq	test
	move.l	Eaglename(a5),a1
	else
	lea	mywinname(pc),a1
	endc
		move.l	WinHandle(A5),a0
		move.l	IntSave(a5),a6
		jsr	_LVOSetWindowTitles(A6)

	*--------- Sizing Gadgets ans Ende der Liste anfgen ----------*
		lea	Sizer1(pc),a1
		move.l	WinHandle(A5),a0
		move.b	wd_borderbottom(a0),d0
		ext.w	d0
		addq.w	#2,d0
		move.w	d0,gg_height(A1)
		subq	#2,d0
		neg.w	d0
		move.w	d0,gg_topedge(A1)
		moveq	#-1,d0
		move.l	IntSave(a5),a6
		jsr	_LVOAddgadget(A6)

		lea	Sizer2(pc),a1
		move.l	WinHandle(A5),a0
		move.b	wd_borderright(a0),d0
		ext.w	d0
		addq.w	#2,d0
		move.w	d0,gg_width(A1)
		subq	#2,d0
		neg.w	d0
		move.w	d0,gg_leftedge(A1)
		moveq	#-1,d0
		jsr	_LVOAddgadget(A6)

	*------- restliche Gadgets erzeugen und ans Fenster anhngen -------*
		bsr	MakeMaingadgets
		tst.l	d0
		beq.w	.Error

		move.l	d0,a1
		moveq	#-1,d0
		moveq	#-1,d1
		suba.l	a2,a2
		move.l	WinHandle(A5),a0
		jsr	_LVOAddglist(A6)

	*----------------------------------------------------------------*
		move.w	#1,GadgetsDa(a5)		;Gadgets enabled

	*----------------------- Backfill -------------------------------*

		move.l	Winhandle(A5),a0
		move.l	IntSave(A5),a6
		jsr	_LVOBeginRefresh(A6)
		move.l	Winhandle(A5),a0
		jsr	_LVOEndRefresh(A6)

		bsr	BackFill

	*--------------------------------------------------------------------------*
	ifne	Scroller
		bsr	PrintScrolRahmen	;Rahmen+Position/Gre

		push	d2-d7
		addq	#1,d2
		addq	#1,d3
		subq	#2,d4
		subq	#2,d5
		lea	XenName(pc),a0				;Font Name
		moveq	#11,d0					;Hhe
		bsr	SC_MakeRastPort				;neuen Scrol
		pop	d2-d7
		tst.l	d0
		beq.s	.Error
	endc

	ifne	time
;		bsr	Time_MakeRastPort	;Rastport + Bitmap fr Zeitanzeige
		bsr	PrintTimeRahmen		;Rahmen fr Zeitanzeige + Werte merken
	endc

		bsr	PrintVolBalRahmen	;Rahmen fr Volume/Balance

	*----------------------------------------------------------------*

;		move.l	Winhandle(A5),a0
;		move.l	IntSave(A5),a6
;		jsr	_LVOBeginRefresh(A6)
;		move.l	Winhandle(A5),a0
;		jsr	_LVOEndRefresh(A6)

;	ifeq	test
;		move.l	d0,-(a7)
;		move.l	EPBase(pc),a6
;		move.l	DTG_Dosbase(a6),a6
;		moveq	#1,d1
;		jsr	_LVODelay(a6)
;		move.l	(a7)+,d0
;	endc

		move.l	WinHandle(a5),a1
		suba.l	a2,a2
		move.l	WD_FirstGadget(a1),a0
		move.l	IntSave(A5),a6
		jsr	_LVORefreshgadgets(A6)


		clr.w	LastWinWidth(A5)	;fr Check bei Resizewindow
		clr.w	LastWinHeight(a5)	;dito

*	bsr	UpdateActAmplGadget

;		bsr	Backfill
;		bsr	RefreshWindowframe

		bra	.noPub
.Error:
		move.l	IntSave(a5),a6
		suba.l	a0,a0
		move.l	MyPubScreen(a5),d0
		beq.s	.NoPub
		move.l	d0,a1
		clr.l	MyPubScreen(a5)
		jsr	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.NoPub:		rts


*******************************************************************
*                   Window schlieen                              *
*******************************************************************
Closewin:
	*-------- Drawinfo vom Screen freigeben ----------------------------------------*
		move.l	winhandle(A5),d0
		beq	nodraw$
		move.l	d0,a0

		move.l	WinDrawInfo(a5),d0
		beq.s	nodraw$

		move.l	d0,a1				;*DrawInfo
		move.l	wd_WScreen(a0),a0		;*Screen
		move.l	IntSave(a5),a6			;*IntuitionBase
		jsr	_LVOFreeScreenDrawInfo(a6)
nodraw$

		move.l	IntSave(a5),a6
		suba.l	a0,a0
		move.l	MyPubScreen(a5),d0
		beq.s	.NoPub
		move.l	d0,a1
		clr.l	MyPubScreen(a5)
		jsr	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.noPub
		tst.l	WinHandle(a5)
		beq.s	.nowin
*		bsr	ClearMenuStrip

		bsr	GetConfig

	*-------- Bild freigeben (wenn vorhanden) -----------------------*
		bsr	DT_FreePicture
	*-------- Halfshine Pen fr Gadgets freigeben -------------------*
		move.l	grafsave(A5),a6
		cmp.w	#39,lib_version(A6)
		blo	.kick2
		move.l	mypen(A5),d0
		move.l	mycmap(A5),a0
		jsr	_LVOReleasepen(A6)
		move.l	#-1,mypen(A5)
.kick2
	*----------------- Fenster schlieen ----------------------------*
		move.l	IntSave(a5),a6
		move.l	WinHandle(a5),a0
		clr.l	WinHandle(a5)
		clr.l	Port(a5)
		jsr	_LVOclosewindow(a6)

	*------------------ Bordergadgets freigeben ---------------------*
		moveq	#0,d2
		lea	MyGad1(A5),a2
.Gadlo:		move.l	(a2),d0
		clr.l	(A2)+
		bsr	FreeBorderGadget		;Safe to call
		addq	#1,d2
		cmp	#3,d2
		bne	.gadlo

	*----------------------------------------------------*
		bsr	FreeMaingadgets
		bsr	SC_FreeRastPort		;Scroller freigeben
.Nowin:		rts

BackFill:
		tst.l	DT_PicObject(A5)
		bne	DT_CopyTiledBitMap

		push	all
		move.l	WinHandle(A5),a4
		move.l	WD_RPort(a4),a1

		move.l	myPen(a5),d0
		bpl.s	.yup
		moveq	#0,d0
.yup
		move.l	GrafSave(A5),a6
		jsr	_LVOSetAPen(A6)			; set the pen

		move.l	wd_rPort(a4),a1
		move.b	wd_borderleft(a4),d0
		ext.w	d0
		move.b	wd_bordertop(a4),d1
		ext.w	d1
		move.b	wd_borderright(a4),d2
		ext.w	d2
		neg.w	d2
		move.b	wd_borderbottom(a4),d3
		ext.w	d3
		neg.w	d3
		subq	#1,d2
		subq	#1,d3
		add.w	wd_width(a4),d2
		add.w	wd_height(a4),d3

		move.l	GrafSave(A5),a6
		jsr	_LVOrectfill(A6)		;Hintergrund killen
		pop	all
		rts

;void CopyTiledBitMap(void)
;Slow but Mem-Saving routine
DT_CopyTiledBitMap
		push	d1-d7/a1/a3/a4/a6
		move.l	GrafSave(a5),a6

		move.l	Winhandle(A5),a0
		moveq	#0,d0
		moveq	#0,d1
		move.w	wd_width(a0),d0
		move.b	wd_borderleft(A0),d1
		add.b	wd_borderRight(A0),d1
		sub.l	d1,d0
		move.l	d0,DT_Breit2(A5)
		
		move.w	wd_height(a0),d0
		move.b	wd_bordertop(A0),d1
		add.b	wd_borderbottom(A0),d1
		sub.l	d1,d0
		move.l	d0,DT_Hoehe2(A5)

		moveq	#0,d0
		move.b	wd_borderleft(a0),d0
		move.l	d0,DT_XPos2(a5)

		move.b	wd_borderTop(a0),d0
		move.l	d0,DT_YPos2(a5)

		move.l	DT_MyBitMapheader(a5),a0
		moveq	#0,d0
		move.w	(a0)+,d0
		move.l	d0,a4			; SrcSizeX
		move.w	(a0),d0
		move.l	d0,a3			; SrcSizeY

		moveq	#256-$c0,d6
		neg.b	d6

		move.l	Winhandle(A5),a1
		move.l	WD_Rport(a1),a1
		move.l	a1,-(sp)

		moveq	#0,d2				; dest x
		moveq	#0,d3				; dest y
MainLoop$
		move.l	a4,d4				; SrcSizeX

		move.l	d2,d7				; dest x
		cmp.l	DT_Breit2(A5),d7		; Row copied ?
		blt.s	Xweit$
		add.l	a3,d3				; Yup, next Row
		moveq	#0,d2				; dest x
		moveq	#0,d7
XWeit$
		add.l	d4,d7				; pos x + SrcSizeX
		cmp.l	DT_Breit2(a5),d7		; dest x (left) < DestX+SrcSizeX ?
		blt.s	skip1$
		move.l	DT_Breit2(A5),d4		; DestSizeX
		sub.l	d2,d4				; - Dest X = Dest Left
skip1$		
		move.l	a3,d5
		move.l	d3,d7
		cmp.l	DT_Hoehe2(A5),d7
		bge.s	YReady$
		add.l	d5,d7				; pos y + SrcSizeY
		cmp.l	DT_Hoehe2(a5),d7		; dest y (left) < DestY+SrcSizeY ?
		blt.s	skip2$
		move.l	DT_Hoehe2(A5),d5		; DestSizeY
		sub.l	d3,d5				; - Dest Y = Dest Left
skip2$
		add.l	DT_XPos2(A5),d2			; Xpos + Winborder
		add.l	DT_YPos2(A5),d3			; YPos + Winborder
		move.l	(sp),a1
		move.l	DT_MyBitMap(a5),a0		; Source
		moveq	#0,d0
		moveq	#0,d1
		jsr	_LVOBltBitMapRastport(a6)
		sub.l	DT_XPos2(A5),d2			; del Border
		sub.l	DT_YPos2(A5),d3			; del Border
		add.l	a4,d2
		bra.s	Mainloop$
YReady$
		addq.l	#4,sp
		pop	d1-d7/a1/a3/a4/a6
		rts
DT_FreePicture:
	push	d0

	move.l	DT_PicObject(A5),d0
	beq.s	.fail
	move.l	DTBase(a5),a6
	move.l	d0,a0
	jsr	_LVODisposeDTObject(a6)
	clr.l	DT_PicObject(A5)
	clr.l	DT_MyBitMapheader(a5)
	clr.l	DT_MyBitMap(a5)
.fail	moveq	#0,d0

	pop	d0
	rts
DT_Filerequest:
	push	d1-a6

	move.l	RTBase(a5),d0
	beq.s	.fail
	move.l	d0,a6

	sub.l	a0,a0
	moveq	#RT_FILEREQ,d0				;Struktur-Type
	jsr	_LVORTAllocRequestA(a6)
	move.l	d0,d7
	beq.s	.fail

	lea	mytags(A5),a0
	move.l	#_RTFI_Dir,(A0)+
	lea	DT_Picturedir(a5),a2
	move.l	a2,(a0)+
	clr.l	(A0)	
	lea	mytags(A5),a0
	move.l	d7,a1
	jsr	_LVORTchangereqattrA(A6)

	lea	DT_Picturename(a5),a2
	lea	DT_Choosepic(pc),a3
	lea	mytags(A5),a0
	move.l	#_RT_Window,(a0)+
	move.l	winhandle(a5),(a0)+
;	move.l	#_RT_LockWindow,(a0)+
;	move.l	#1,(a0)+
	clr.l	(A0)
	lea	mytags(A5),a0
	move.l	d7,a1
	jsr	_LVORTFilerequestA(A6)
	move.l	d0,d6

	move.l	d7,a1
	move.l	rtfi_Dir(a1),a1
	lea	DT_Picturedir(a5),a0
.copy2	move.b	(a1)+,(a0)+
	bne.s	.copy2

	move.l	d7,a1
	jsr	_LVORTFreerequest(A6)

	move.l	d6,d0
.fail	pop	d1-a6
	tst.l	d0
	rts
DT_OpenPicture:
	push	all
	bsr	.openpic
	pop	all
	rts
.Openpic
	moveq	#0,d0
	move.l	DT_PicObject(a5),d1
	bne.w	.fail
	move.l	winhandle(a5),d0
	beq.w	.fail
	move.l	DTBase(a5),d0
	beq.w	.fail

	lea	DT_Picture(a5),a0
	lea	DT_Picturedir(a5),a1
.copy	move.b	(a1)+,(a0)+
	bne.s	.copy
	subq.l	#1,a1

	lea	DT_Picture(a5),a0
	move.l	a0,d1
	lea	DT_Picturename(a5),a0
	move.l	a0,d2
	move.l	#300,d3
	move.l	DosSave(A5),a6
	jsr	_LVOAddPart(A6)

	move.l	DTBase(a5),a6
	lea	mytags(A5),a0
	move.l	#DTA_Sourcetype,(a0)+
	move.l	#DTST_File,(a0)+
	move.l	#DTA_GroupID,(a0)+
	move.l	#GID_Picture,(a0)+
	move.l	#PDTA_Remap,(a0)+
	move.l	#1,(a0)+
	move.l	#PDTA_Screen,(a0)+
	move.l	winhandle(A5),a1
	move.l	wd_WScreen(a1),(a0)+
	move.l	#PDTA_FreeSourceBitMap,(a0)+
	move.l	#1,(a0)+
	move.l	#OBP_Precision,(a0)+
	move.l	#Precision_IMAGE,(A0)+
	clr.l	(a0)+
	lea	mytags(A5),a0

	ifne	test
	lea	DT_PicName(pc),a1
	else
	lea	DT_Picture(a5),a1
	endc
	move.l	a1,d0
	jsr	_LVONewDTObjectA(A6)
	move.l	d0,DT_PicObject(A5)
	beq.w	.fail

	move.l	#1,-(a7)		;Taglist ??
	move.l	#0,-(a7)		;
	move.l	#DTM_ProcLayout,-(a7)	;
	push	d0
	bsr	_DoMethod	
	add	#4*4,sp
	tst.l	d0
	beq	DT_FreePicture

	lea	mytags(A5),a2
	move.l	#PDTA_BitMapHeader,(a2)+
	lea	DT_MyBitMapheader(a5),a0
	move.l	a0,(a2)+
	move.l	#PDTA_DestBitMap,(a2)+
	lea	DT_MyBitMap(a5),a0
	move.l	a0,(A2)+
	clr.l	(A2)
	lea	mytags(A5),a2
	move.l	DT_PicObject(A5),a0
	move.l	DTBase(a5),a6
	jsr	_LVOGetDTAttrsA(A6)
	cmp.l	#1,d0
	blt	DT_FreePicture
	tst.l	DT_MyBitMap(A5)
	bne.s	.attrok

	lea	mytags(A5),a2
	move.l	#PDTA_BitMap,(a2)+
	lea	DT_MyBitMap(a5),a0
	move.l	a0,(A2)+
	clr.l	(A2)
	lea	mytags(A5),a2
	move.l	DT_PicObject(A5),a0
	jsr	_LVOGetDTAttrsA(A6)
	tst.l	DT_MyBitMap(A5)
	beq	DT_FreePicture
.attrok
	moveq	#1,d0
.fail	tst.l	d0
	rts
;ULONG DoMethod( Object *obj, unsigned long MethodID, ... ); from Amiga.lib
_DoMethod:
	MOVE.L	A2,-(SP)
	MOVEA.L	8(SP),A2		;*obj
	MOVE.L	A2,D0
	BEQ.S	.cmnullreturn
	LEA	12(SP),A1		;MethodID, ...
	MOVEA.L	-4(A2),A0
	PEA	.cmreturn(PC)
	MOVE.L	8(A0),-(SP)
	RTS
.cmnullreturn:
	MOVEQ	#0,D0
.cmreturn:
	MOVEA.L	(SP)+,A2
	RTS

;--------------------- Routinen des Scrollers --------------------------------
; Init:                         SC_MakeRastPort (Parameter beachten!)
; neuer Text:                   NewScroltext (a0 : Text als ASCII)
; Aufruf (einmal pro VBlank) :  ScrollNow
; End:                          SC_FreeRastPort
; Lschen: 			bsr ClearBM + bsr IntoWindow
;
;
; public Areas des Scrollers: (drfen auch vom EP verndert werden)
;
; SCR_Limitwidth.w              Anzahl der Pixels, um die die Breite kleiner
;                               geprintet werden soll
; sf	SCR_Enable(a5)		Scroller verboten (nur lschen!!,nicht setzen)
;
**************************************************************************
*                     Font des Scrollers ndern                          *
**************************************************************************
* Input: a0=Name
*	 d1=Height
SC_SetFont:	*lea	NameTemp(a5),a0
		*move.w	Hoehetemp(A5),d0
		move	d1,d6

		lea	SCR_Fontname(a5),a1
.Cop:		move.b	(a0)+,(a1)+
		bne.s	.Cop

		move.b	SCR_enable(a5),d7
		sf	SCR_Enable(a5)		;Scroller verboten

		tst.l	SCR_RastPort+rp_BitMap(a5) ;RastPort berhaupt valid ?
		beq	.Error1			;n, Abbruch	

		move.l	SCR_FontAdr(a5),d0
		beq.s	.OK1
		clr.l	SCR_FontAdr(a5)
		move.l	d0,a1
		move.l	GrafSave(a5),a6
		jsr	_LVOCloseFont(a6)
.Ok1:		move	d6,d0
		bsr	SC_OpenFont
		beq.s	.error1

		move.l	SCR_FontAdr(a5),a0
		lea	SCR_RastPort(a5),a1
		move.l	GrafSave(A5),a6
		jsr	_LVOSetFont(A6)

		bsr	ClearBM			;Bitmap komplett lschen
		move.b	d7,SCR_Enable(a5)
.Error1:	rts

**********************************************************************
*      angegebenen Font ffnen, bei Fehler Topaz 8 nehmen            *
* Input:  SCR_Fontname: Name des Fonts als ASCII-Text                *
*                   D0: Hhe des Fonts                               *
**********************************************************************
SC_OpenFont:	push	d1-a6
		move	d0,SCR_Fontheight(A5)
		beq.s	.topa
		cmp.w	SCR_font_max(a5),d0
		bhi.s	.topa
		move.l	SCR_FontAdr(a5),d1
		bne	.break

		lea	SCR_TextAttr(A5),a0
		clr.b	ta_Style(a0)
		move.b	#0,ta_Flags(a0)
		move.w	d0,ta_YSize(a0)
		lea	SCR_FontNAME(a5),a3
		move.l	a3,ta_name(A0)

		move.l	DiskFont(a5),d0
		beq.s	.topa
		move.l	d0,a6
		jsr	_LVOOpenDiskFont(A6)
		move.l	d0,SCR_FontAdr(a5)
		bne.s	.OK1
.topa:		lea	SCR_TextAttr(A5),a0
		lea	Topazname(pc),a3
		move.l	a3,ta_name(a0)
		move.w	#8,ta_ysize(A0)
		clr.b	ta_style(A0)
		clr.b	ta_Flags(A0)
		move.l	GrafSave(a5),a6
		jsr	_LVOOpenFont(A6)
		move.l	d0,SCR_FontAdr(a5)
.break
.OK1:		pop	d1-a6
		tst.l	d0
		rts

**********************************************************************
*           RastPortelemente (Font,Bitmap) freigeben                 *
**********************************************************************
SC_FreeRastPort:push	d0-a6

	*-------------------- Font -------------------------*
		move.l	SCR_FontAdr(a5),d0
		beq.s	.OK1
		clr.l	SCR_FontAdr(A5)
		move.l	d0,a1
		move.l	GrafSave(a5),a6
		jsr	_LVOCloseFont(A6)

	*-------------------- Bitmap -----------------------*
.OK1:
		move.l	SCR_BitmapAdr(A5),a0
		lea	SCR_Bitmap(A5),a3
		bsr	FreeBitmap
		clr.l	SCR_BitmapAdr(A5)

		lea	SCR_RastPort(A5),a0	;RastPort komplett killen
		move.w	#rp_sizeof-1,d0
.Clr:		clr.b	(a0)+
		dbf	d0,.clr

		clr.l	SCR_ScrolCurr(a5)
		sf	SCR_Enable(a5)
		pop	d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=String
*Output: d0=Size of String
*-----------------------------------------------------------------------------*
BerechStringSize:
		move.l	a0,-(a7)
		moveq	#-1,d0
.NextB:		addq.l	#1,d0			;Lnge in D0
		tst.b	(a0)+
		bne.s	.NextB
		move.l	(a7)+,a0
		tst.l	d0
		rts



	ifne	Scroller
*********************************************************************
*   RastPort fr den Scrolltext und zugehrige Bitmap erzeugen,     *
*   so da fr den Scroller Systemfonts verwendet werden knnen     *
*                                                                   *
* Input:   A0: Pointer auf String mit dem Fontnamen (0=letzter Font *
*          D0: Hhe des Fonts                                       *
*          D3: Xpos                                                 *
*          D2: Ypos                                                 *
*          D5: Breite der Zeile                                     *
*          D4: Maxhhe der Zeile                                    *
* Output:  D0: <> 0 ---> alles OK                                   *
*********************************************************************
SC_MakeRastPort:
		push	d1-a6
		cmp	#40,d5
		bgt.s	.okok
		move.w	#40,d5
.okok:		move	d5,SCR_Width(A5)

		cmp	#8,d4
		bgt.s	.hi
		moveq	#8,d4
.hi:		move	d4,SCR_font_max(A5)

		move	d3,SCR_xpos(A5)
		move	d2,SCR_ypos(A5)

		move.l	a0,d1
		beq.s	.oldfont		;letzten genutzten Font holen

		lea	SCR_FontNAME(a5),a1
.cop:		move.b	(a0)+,(a1)+
		bne.s	.cop
		bra.s	.font

.oldfont:	move	SCR_Fontheight(A5),d0
.font:		bsr	SC_OpenFont	;entsprechenden Font ffnen (D0:Hhe)
		beq.s	.error1

		lea	SCR_Bitmap(A5),a0	;Bitmap

		moveq	#0,d0
		move	SCR_font_max(A5),d0	;Zeichenhhe
		lsl	#3,d0			;mal 8 (zur Sicherheit)

		add	SCR_Width(A5),d0	;add.l #Scrol_Breite*2,d0
		add	SCR_Width(A5),d0	;Breite

						;(Doppelte Zeilenlnge + Space)
		move.w	SCR_font_max(A5),d1	;Hhe
		moveq	#2,d2			;Tiefe 2 (wg. Crunchanzeige)
		bsr	AllocBitMap
		beq.s	.Error1
		cmp.l	#-1,d0
		beq.s	.nosys
		move.l	d0,SCR_BitmapAdr(A5)
.nosys
		lea.l	SCR_RastPort(a5),a3
		move.l	a3,a1

		move.l	GrafSave(a5),a6
		jsr	_LVOInitRastPort(A6)

		move.l	SCR_BitmapAdr(A5),d0
		beq.s	.normal
		move.l	d0,a0
		bra.s	.kick3
.normal
		lea.l	SCR_Bitmap(a5),a0
.kick3
		move.l	a0,rp_BitMap(a3)

		move.l	SCR_FontAdr(a5),a0
		move.l	a3,a1
		jsr	_LVOSetFont(A6)

		move.l	a3,a1
		moveq	#1,d0				;Foreground
		jsr	_LVOSetAPen(A6)

		move.l	a3,a1
		moveq	#0,d0				;Background
		jsr	_LVOSetBPen(A6)

		move.l	a3,a1				;RastPort
		move.l	#RP_JAM2,d0
		jsr	_LVOsetDrMd(A6)

		st	d0
.error1:	pop	d1-a6
		tst	d0
		rts

*-----------------------------------------------------------------------------*
ClearBM:	push	d0-d1/a0-a1/a6
		lea.l	SCR_RastPort(a5),a1
		tst.l	RP_Bitmap(a1)		;RastPort initialisiert ?
		beq.s	.Skip
		moveq	#0,d0			;Fill Color = BG
		move.l	GrafSave(a5),a6
		jsr	_LVOSetRast(a6)		;RastPort komplett lschen
.Skip:		pop	d0-d1/a0-a1/a6
		rts
***********************************************************************
*     Bitmap fr den RastPort initialisieren und Bitplanes setzen     *
* Input:                                                              *
*   Breite: D0                                                        *
*   Hhe:   D1                                                        *
*   Tiefe:  D2                                                        *
*   BitMap: A0                                                        *
* Output: D0 = 0  -> Fehler                                           *
*         D0 = -1 -> bergebene Bitmap gefllt (Kick2)                *
*         D0 sonst: allozierte Bitmap                                 *
***********************************************************************
AllocBitMap:	push	d1-a6
		move.l	GrafSave(a5),a6
		cmp	#39,lib_Version(a6)
		bge.s	.kick3

		lea	(a0),a3
		lea	bm_planes(a3),a1
		moveq	#7,d5
.clr:		clr.l	(a1)+
		dbf	d5,.clr

		move.w	d0,d3		;Breite (Pix)
		add.w	#16,d3
		and.w	#~15,d3

		moveq	#0,d0
		move.b	d2,d0		;Tiefe (Bits)
		move	d2,-(sp)
		moveq	#0,d2
		move.w	d1,d2		;Hhe
		move.w	d1,d4
		moveq	#0,d1
		move.w	d3,d1		;Breite (Pix)
		jsr	_LVOInitBitmap(a6)
		move	(sp)+,d2

		move	bm_bytesperrow(A3),d3
		lsl.w	#3,d3
		move	bm_rows(a3),d4

		lea	bm_planes(A3),a3
		subq.w	#1,d2
.AllPlanes:	move.w	d3,d0
		move.w	d4,d1
		addq.w	#1,d1
		jsr	_LVOallocraster(A6)
		move.l	d0,(A3)+
		beq.s	.fail
		move.l	d0,a0	;;!!
		move.l	#1,(a0)
		dbf	d2,.allplanes
		pop	d1-a6
		moveq	#-1,d0
		rts
.kick3:
		move.l	mypubscreen(a5),d3
		beq	nofriend$
		move.l	d3,a0
		move.l	sc_RastPort+rp_BitMap(a0),a0

		Push	d0/d1/a0
		moveq	#BMA_DEPTH,d1
		jsr	_LVOGetBitMapAttr(A6)
		move.b	d0,d2
		Pop	d0/d1/a0
nofriend$
		and.l	#$ffff,d0
		and.l	#$ffff,d1
		and.l	#$ff,d2
		moveq	#BMF_Clear!BMF_MINPLANES,d3
		CallSys	AllocBitMap		;Zielbitmap

		pop	d1-a6
		tst.l	d0
		rts

.Fail:		pop	d1-a6
		moveq	#0,d0
		rts

**************************************************************
*                   Bitplane(s) freigeben                    *
* Inputs:                                                    *
*      A3 - Bitmap fr Kick 2.x                              *
*      A0 - Bitmap fr Kick 3+                               *
**************************************************************
FreeBitmap:	push	d0-a6
		move.l	GrafSave(A5),a6
		cmp	#39,lib_Version(a6)
		bge.s	.kick3

		moveq	#0,d2
		move.b	bm_depth(a3),d2
		subq.w	#1,d2

		move.w	bm_bytesperrow(a3),d3
		lsl.w	#3,d3
		lea	bm_planes(A3),a4
.allplanes:	move.w	d3,d0
		move.w	bm_rows(a3),d1
		move.l	(a4),d4
		beq.s	.noplane
		move.l	d4,a0
		addq.w	#1,d1
		jsr	_LVOfreeRaster(A6)
.noplane:	clr.l	(a4)+
		dbf	d2,.allplanes

		pop	d0-a6
		rts
.kick3
		tst.l	a0
		beq.s	.ret
		jsr	_LVOFreeBitMap(a6)
.ret
		pop	d0-a6
		rts
***************************************************************************
*                   Daten ins Fenster kopieren                            *
***************************************************************************
IntoWindow:	push	d0-a6			;in den RastPort kopieren
		move.l	WinHandle(a5),d0
		beq.s	.nowin
		move.l	d0,a1			;Fenster
		move.l	wd_rPort(a1),a1		;RastPort (Ziel)

		move.w	SCR_xpos(a5),d2		;X2 (Ziel-X-Position)
		move.w	SCR_ypos(A5),d3		;Y-Position im Window

		move.l	SCR_BitmapAdr(a5),d0
		bne	.this
		lea	SCR_Bitmap(a5),a0	;Bitmap (Quelle)
		move.l	a0,d0
.this
		move.l	d0,a0
		
		move.w	SCR_Offset1(a5),d0 ;X1 (abhngig von der Position des
					;Scrollers->nicht die Bitmap wird
					;gescrollt,es wird nur ein
					;anderer Ausschnitt gezeigt
		moveq	#0,d1		;Y1 - Position in der Bitmap

		move.w	SCR_width(A5),d4	;Breite <- !!!!
		sub	SCR_Limitwidth(A5),d4	;minus Limit
		ble.s	.nowin			;check!

		move.w	SCR_font_max(a5),d5	;Hhe

		move.b	#$c0,d6			;Miniterm (nur kopieren)

		move.l	GrafSave(a5),a6		;GRAPHICS Library
		jsr	_LVObltbitmapRastPort(a6)

.NoWin:		pop	d0-a6
		rts

*************************************************************
*  Text in Bitplane reinprinten ber RastPort               *
* Input:                                                    *
*    D0 : ASCII-Char                                        *
*    D1 : Position                                          *
* OutPut:                                                   *
*    D2 : Breite des Zeichens in Pixeln                     *
*************************************************************
PrintChar:	push	d0-d1/d3-a6

		lea.l	SCR_RastPort(a5),a3
		move.l	a3,a1
		lea	SCR_CharTMP(a5),a0
		move.b	d0,(A0)

		move.w	d1,d0			;X-Posi
		move.l	SCR_FontAdr(A5),a2
		move.w	tf_Baseline(a2),d1	;Char Baseline = Y-Posi

		move	SCR_font_max(A5),d2		;zentrieren des Zeichens
		sub	SCR_TextAttr+ta_ysize(a5),d2	;in vertikaler Richtung
		ble.s	.skip				;wenn Zeichen kleiner als
		moveq	#0,d3				;max. Wert
		lsr	#1,d2
		addx	d3,d2
		add	d2,d1

.skip:		move.l	GrafSave(A5),a6
		jsr	_LVOMove(A6)

		move.l	a3,a1
		moveq	#RP_Jam2,d0
		jsr	_LVOsetDrMd(A6)

		move.l	a3,a1
		lea	SCR_CharTMP(a5),a0
		moveq	#1,d0
		jsr	_LVOtext(A6)

		move.l	a3,a1
		lea	SCR_CharTMP(a5),a0
		moveq	#1,d0
		jsr	_LVOTextLength(A6)
		move	d0,d2

		pop	d0-d1/d3-a6
		rts
	endc

*-----------------------------------------------------------------------------*
*--------- Neue Gre, Gadgets neu erzeugen, Scroller update, Rahmen ziehen ---
*------------------------------------------------------------------------------
* Bei Windowmessage
ResizeWindow:
		push	all

		tst.w	GadgetsDa(a5)		;gerade disabled ?
		beq.s	.none

		move.l	IntSave(a5),a6
		move.l	WinHandle(a5),a0
		move.l	GD_FirstGadget(a5),a1
		move.w	GD_Count(a5),d0
		beq.s	.none
		jsr	_LVORemoveGList(a6)
.None:		bsr	FreeMaingadgets

	*------- Prefs fr die Slidergadgets setzen ----------------------*

		move.l	EPBase(pc),a0
		lea	VolExtra+4(pc),a1
		move.w	EPG_Volume(a0),d0
		move	d0,VolExtra+4
		move	d0,Lastvolume(a5)

		move.w	EPG_Balance(a0),d0
		add.w	#EP_MaxVolume,d0
		move.w	d0,BalExtra+4-(VolExtra+4)(a1)

	*------- restliche Gadgets erzeugen und ans Fenster anhngen -----*
		bsr	MakeMaingadgets
		tst.l	d0
		beq	.Return
		move.l	d0,a1
		moveq	#-1,d0
		moveq	#-1,d1
		suba.l	a2,a2
		move.l	WinHandle(A5),a0
		jsr	_LVOAddglist(A6)


		move.l	Winhandle(A5),a0
		move.l	IntSave(A5),a6
		jsr	_LVOBeginRefresh(A6)
		move.l	Winhandle(A5),a0
		jsr	_LVOEndRefresh(A6)

		bsr	BackFill

	*-----------------------------------------------------
		bsr	SC_FreeRastPort		;Scroller freigeben
	ifne	Scroller
		bsr	PrintScrolRahmen	;Rahmen+Position/Gre

		push	d2-d7
		addq	#1,d2
		addq	#1,d3
		subq	#2,d4
		subq	#2,d5
		sub.l	a0,a0				;kein neuer Font
		bsr	SC_MakeRastPort		;neuen Scrol
		pop	d2-d7
	endc

	ifne	time
		bsr	PrintTimeRahmen		;Rahmen fr Zeitanzeige + Werte merken
	endc

		bsr	PrintVolBalRahmen	 ;Rahmen fr Volume/Balance


	*	lea	Aboutmessage(pc),a0		;nur Testhalber, entfernen !!!
	*	bsr	NewScrolText			;

		move.l	IntSave(A5),a6
	*	move.l	WinHandle(a5),a1
	*	suba.l	a2,a2
	*	move.l	wd_firstgadget(a1),a0
	*	jsr	_LVORefreshgadgets(A6)		;Gadgets anzeigen

		bsr	RefreshWindowFrame

		move.w	#1,GadgetsDa(a5)		;gerade disabled ?

	ifne	Scroller
;		move.l	SCR_LastPrinted(a5),d0
;		beq.s	.Return
;		move.l	d0,a0
;		moveq	#0,d7
;		bsr	PrintText2
	endc
.Return:
		pop	all
		rts

**************************************************************************
* Input:  A0 : Window                                                    *
*         D2 : Pos Y (vom Scroller)                                      *
*         D4 : Hhe (vom Scroller)                                       *
*         D3 : Pos X (vom Scroller)                                      *
*         D5 : Breite (vom Scroller)                                     *
* Output: selbe Register, Rest gesichert                                 *
**************************************************************************
CalcCoords
		push	d0/d6-d7

		move.l	a0,d0
		beq.s	.fail

		moveq	#0,d0
		move.b	wd_bordertop(a0),d7	;Fonts > 120 ?? glaube ich kaum...
		move.b	d7,d0
		add.b	wd_borderbottom(a0),d7
		ext.w	d7
		neg.w	d7
		add.w	wd_height(a0),d7	;WA_Innerheight :)

		mulu	d7,d2			;top
		mulu	d7,d4			;height
		divu	#Defheight,d2		;def Wert
		divu	#Defheight,d4		;def Wert
		add	d0,d2			;Border dazu

		move.b	wd_borderleft(a0),d6
		move.b	d6,d0
		add.b	wd_borderright(a0),d6
		ext.w	d6
		neg.w	d6
		add.w	wd_width(a0),d6		;WA_Innerwidth :)

		mulu	d6,d3			;top
		mulu	d6,d5			;height
		divu	#DefWidth,d3		;def Wert
		divu	#DefWidth,d5		;def Wert
		add	d0,d3			;Border dazu
.fail
		pop	d0/d6-d7
		rts
	ifne	time
**************************************************************************
* Input:  -                                                              *
**************************************************************************
PrintTimeRahmen:
		push	all
		move.l	WinHandle(A5),d0
		beq.s	.End
		move.l	d0,a0

		move	#Time_DefYPos,d2	;Xpos Rahmen
		move	#Time_Defheight,d4	;Breite ....
		move	#Time_DefXPos,d3	;Xpos Rahmen
		move	#Time_Defwidth,d5	;Breite ....

		bsr	CalcCoords

		move.l	wd_rPort(a0),a4

		move.l	GrafSave(A5),a6
		move.l	a4,a1
		moveq	#0,d0
		jsr	_LVOsetAPEN(A6)

		push	d0-d4
		move.l	a4,a1
		move	d3,d0
		move	d2,d1

		move	d0,d2
		add	d5,d2

		move	d1,d3
		add	d4,d3
		subq	#1,d2
		subq	#1,d3
		jsr	_LVOrectfill(A6)		;Hintergrund killen
		pop	d0-d4

		bsr	Print2

		move	d2,TimeY(A5)
		move	d3,TimeX(A5)
		move	d4,TimeWy(A5)		;Hhe
		move	d5,TimeWx(A5)		;Breite

.End:		pop	all
		rts
	endc
**************************************************************************
*        Rahmen fr Volume/Balance Sliders neu zeichnen                  *
* Input:  D6 : Breite des Fensters (ohne Borders)                        *
*         D7 : Hhe des Fensters (ohne Borders)                          *
*                                                                        *
**************************************************************************
PrintVolBalrahmen:
		push	all
		lea	VolBalPre(pc),a2

		move.l	WinHandle(A5),d0
		beq.w	.end
		move.l	d0,a0
		move.l	wd_rPort(a0),a4

		move	2(A2),d2		;Ypos ScrolRahmen
		move	6(a2),d4		;Hhe ...
		move	(a2),d3			;XPos Gadget
		move	4(a2),d5		;Breite

		bsr	CalcCoords

		subq	#2,d2
		addq	#4,d4
		subq	#2,d3
		addq	#4,d5

		push	a0
		bsr	Print2
		pop	a0

		move	16+6(a2),d4		;Hhe ...
		move	16(a2),d3		;XPos Gadget
		move	16+4(a2),d5		;Breite
		move	16+2(A2),d2		;Ypos ScrolRahmen
		bsr	CalcCoords

		subq	#2,d2
		addq	#4,d4
		subq	#2,d3
		addq	#4,d5

		bsr	Print2
.end:		pop	all
		rts

**************************************************************************
* Position/Gre des Scrollers neu berechnen/anzeigen                    *
* Vorsicht: Alle Register knnten sich ndern, da jedemenge Parameter    *
*           zurckkommen                                                 *
*                                                                        *
* Output: D6 : Breite des Fensters (ohne Borders)                        *
*         D7 : Hhe des Fensters (ohne Borders)                          *
*                                                                        *
*         D2 : Scrolpos Y - 1                                            *
*         D3 : Scrolpos X - 1                                            *
*         D5 : Breite + 2                                                *
*         D4 : Hhe + 2                                                  *
*                                                                        *
**************************************************************************
	ifne	Scroller
PrintScrolrahmen:
		move.l	WinHandle(A5),d0
		beq.w	PSR_Return

		move.l	d0,a0
		move.l	wd_rPort(a0),a4

		moveq	#0,d0
		move.b	wd_bordertop(a0),d7	;Fonts > 120 ?? glaube ich kaum...
		move.b	d7,d0
		add.b	wd_borderbottom(a0),d7
		ext.w	d7
		neg.w	d7
		add.w	wd_height(a0),d7	;WA_Innerheight :)

		move	#SCR_DefYPos,d2		;Ypos ScrolRahmen
		move	#SCR_DefHeight,d4	;Hhe ...
		mulu	d7,d2			;top
		mulu	d7,d4			;height
		divu	#defheight,d2		;def Wert
		divu	#defheight,d4		;def Wert
		add	d0,d2			;Border dazu

		move.b	wd_borderleft(a0),d6
		move.b	d6,d0
		add.b	wd_borderright(a0),d6
		ext.w	d6
		neg.w	d6
		add.w	wd_width(a0),d6		;WA_Innerwidth :)

		move	#SCR_DefXPos,d3		;Xpos Scrolrahmen
		move	#SCR_DefWidth,d5	;Breite ....
		mulu	d6,d3			;top
		mulu	d6,d5			;height
		divu	#DefWidth,d3		;def Wert
		divu	#DefWidth,d5		;def Wert
		add	d0,d3			;Border dazu

		move.l	GrafSave(A5),a6
		move.l	a4,a1
		moveq	#0,d0
		jsr	_LVOsetAPEN(A6)

		push	d0-d4
		move.l	a4,a1
		move	d3,d0
		move	d2,d1

		move	d0,d2
		add	d5,d2

		move	d1,d3
		add	d4,d3
		subq	#1,d2
		subq	#1,d3
		jsr	_LVOrectfill(A6)		;Hintergrund killen
		pop	d0-d4
	endc

print2:	
		move.l	WinDrawInfo(a5),d0
		beq	old$
		move.l	d0,a3
		move.l	dri_Pens(a3),d0
		beq	old$
		move.l	d0,a3

		move.l	a4,a1			; rPort to a1
		move	d3,d0
		move	d2,d1
		add	d4,d1
		subq	#2,d1
		jsr	_LVOmove(A6)

		move.l	a4,a1

		move.w	Shadowpen*2(a3),d0	; dark edges
		jsr	_LVOsetAPEN(A6)

		move.l	a4,a1
		move	d3,d0
		move	d2,d1
		jsr	_LVODraw(A6)

		move.l	a4,a1
		move	d3,D0
		add	d5,D0
		subq	#1,D0
		move	d2,d1
		jsr	_LVODraw(A6)

		move.l	a4,a1
		move.w	Shinepen*2(a3),d0	; light edges
		jsr	_LVOsetAPEN(A6)

		move.l	a4,a1
		move	d3,D0
		add	d5,D0
		subq	#1,D0
		move	d2,d1
		add	d4,d1
		subq	#1,d1
		jsr	_LVODraw(A6)

		move.l	a4,a1
		move	d3,D0
		move	d2,d1
		add	d4,d1
		subq	#1,d1
		jsr	_LVODraw(A6)
		bra	PSR_Return
old$
		move.l	a4,a1			; rPort to a1
		move	d3,d0
		move	d2,d1
		add	d4,d1
		subq	#2,d1
		jsr	_LVOmove(A6)

		move.l	a4,a1
		moveq	#1,d0
		jsr	_LVOsetAPEN(A6)

		move.l	a4,a1
		move	d3,d0
		move	d2,d1
		jsr	_LVODraw(A6)

		move.l	a4,a1
		move	d3,D0
		add	d5,D0
		subq	#1,D0
		move	d2,d1
		jsr	_LVODraw(A6)

		move.l	a4,a1
		moveq	#2,d0
		jsr	_LVOsetAPEN(A6)

		move.l	a4,a1
		move	d3,D0
		add	d5,D0
		subq	#1,D0
		move	d2,d1
		add	d4,d1
		subq	#1,d1
		jsr	_LVODraw(A6)

		move.l	a4,a1
		move	d3,D0
		move	d2,d1
		add	d4,d1
		subq	#1,d1
		jsr	_LVODraw(A6)
PSR_Return:	rts

*---------------------------------------------------------------------------*
* Eine Einstellung im Eagleplayer wurde verndert. Das Enginewird informiert*
* Input: d0=Nummer							    *
*	 d2								    *
* Output:?								    *
*---------------------------------------------------------------------------*
* Die Menus werden bis auf die, der Engine intern verwaltet.
* Achtung: Auf Messages testen, die ankommen, weil der Regler im Window ver-*
*	   schoben wurde.						    *
*---------------------------------------------------------------------------*
ChangePrefs:
		push	all

		lea	Datas,a5
;		move.l	LastNummer(a5),d7
;		beq.s	.NoLast
*		cmp.w	#EPNr_PlayFaster,d7
*		beq.w	.Return
*		cmp.w	#EPNr_NextPattern,d7
*		beq.w	.Return
*		cmp.w	#EPNr_PrevPattern,d7
*		beq.w	.Return
;		cmp.w	#EPNr_Volume,d7
;		beq.s	.Return
;		cmp.w	#EPNr_Balance,d7
;		beq.s	.Return

		*--- Gadget in Liste finden ---*
.NoLast:	cmp.w	#EPNr_Volume,d0
		beq.s	.Ja
		cmp.w	#EPNr_Balance,d0
		bne.s	.TesteScrollFont
		add.w	#EP_MaxVolume,d2

.Ja		move.l	GD_FirstGadget(A5),d3
		beq.s	.Return
		move.l	d3,a0
		move	GD_Count(a5),d3
		subq	#1,d3
		blt.s	.Return
.findgad:	cmp.w	gg_gadgetid(a0),d0
		beq.s	.found2
		move.l	(a0),d3
		beq.s	.Return
		move.l	d3,a0
		dbf	d3,.findgad
		bra.s	.Return

.found2:	lea	Mytags(a5),a3
		move.l	#PGA_top,(a3)+
		move.l	d2,(a3)+
		clr.l	(a3)
		lea	Mytags(a5),a3
		move.l	Winhandle(A5),a1
		suba.l	a2,a2
		move.l	Intsave(a5),a6
		jsr	_LVOSetGadgetAttrsA(a6)
		bra.w	.Return
.TesteScrollFont:
		cmp.w	#EPNr_ScrollFont,d0
		bne.s	.Return
		bsr	SC_SetFont
.Return:
		pop	all
		rts

*-----------------------------------------------------------------------------*
* Der Eagleplayer fragt was ab.
*-----------------------------------------------------------------------------*
GetPrefs:	lea	Datas,a5

	ifne	Scroller
		cmp.w	#EPNr_ScrollFont,d0
		bne.s	.Error
		moveq	#0,d0
		moveq	#8,d1				;Min Height
		move.w	SCR_font_max(a5),d2		;Max Wert
		move.w	SCR_TextAttr+Ta_YSize(a5),d3	;eing. Wert
		move.w	#EPFB_Proportional,d4		;Flags (Pro)
	endc

.Error:		moveq	#EPR_FunctionAborted,d0
		rts

****************************************************************************
* angegebenes Gadget enable/disable (OHNE REFRESH !!)                      *
* Input D0.w = Gadget ID                                                   *
*       D1.l = State (0=enable,1=disable)		                   *
****************************************************************************
ChangeGui:

		*--- Zustand des ActAmplifiergadgets setzen ---*
		movem.l	d0/d1,-(a7)
		move.l	a5,a4
		lea	Datas,a5

		*move.l	EPG_SomePrefs(a4),d1
		*btst	#EGPRF_Help,d1
		*bne.w	.rts


		move.l	EPG_ActiveAmplifier(a4),d0
		cmp.l	LastAmplifier(a5),d0
		beq.s	.NoChange
		moveq	#1,d2
		move.l	d0,LastAmplifier(a5)
		tst.l	d0
		beq.s	.No
		move.l	d0,a0
		move.l	EUS_MsgFlags(a0),d0
		btst	#USMF_Configuration,d0
		bne.s	.Doch
		move.l	EUS_TagList(a0),a0
		move.l	#EUT_Config,d0
		jsr	ENPP_FindTag(a4)
		moveq	#1,d2
		tst.l	d0
		beq.s	.No
.Doch:		moveq	#0,d2
.No:		move.l	#GD_ActiveAmplifier,d0
		move.l	d2,d1
		bsr	.Normal
.NoChange:	movem.l	(a7)+,d0/d1


.Normal:
		cmp	#EPNr_Balance,d0
		beq.s	.setbalance
		cmp.w	#EPNr_Volume,d0
		bne.s	.changegadget

		bsr.s	.changegadget
		move	#GD_Volmin,d0
		bsr.s	.changegadget
		move	#GD_Volmax,d0
		bra.s	.changegadget
.setbalance
		bsr.s	.changegadget
		move	#GD_Balleft,d0
		bsr.s	.changegadget
		move	#GD_Balright,d0
		bra.s	.changegadget
		rts
.changegadget
		push	d0/d1
		lea	datas,a5
		and.w	#1,d1			;nur 0/1 erlaubt

		bsr	FindGadget
		beq.s	.End2


		tst.b	d4				;Prop Gadget ?
		bmi.s	.setstate
		move.l	gg_userdata(a0),d2		;Boopsi-Imagestruktur fr die
		beq.s	.setstate			;Borders
		move.l	d2,a1
		move.b	d1,ig_planepick(a1)

.setstate:	lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)
		move.l	d1,4(A3)
		clr.l	8(A3)
		suba.l	a2,a2
		move.l	WinHandle(A5),a1
		move.l	IntSave(A5),a6
		jsr	_LVOSetGadgetAttrsa(A6)

.end2:	
		pop	d0/d1
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Nummer
* Output: d0=0 Error
*	  a0=GadgetAdr
*-----------------------------------------------------------------------------*
FindGadget:	lea	MainGadsList(pc),a0	;erstmal fr spteres
						;Fensterffnen sichern
.loop1:		tst	(a0)+			;Strukt vorhanden ?
		beq.s	.end1
		cmp.w	6(a0),d0
		bne.s	.next1
		move.w	8(a0),d4
		and.w	#~1,d4
		or.w	d1,d4
		move.w	d4,8(a0)
		bra.s	.end1
.next1:		add.w	#14,a0
		bra.s	.loop1

.end1:	
		move.l	GD_FirstGadget(A5),d2
		beq.s	.end2
		move.l	d2,a0
		move	GD_Count(a5),d2
		subq	#1,d2
		blt.s	.end2
.findgad:	cmp.w	gg_gadgetid(a0),d0
		beq.s	.found2
		move.l	(a0),d3
		beq.s	.end2
		move.l	d3,a0
		dbf	d2,.findgad
		bra.w	.end2
.End2:		moveq	#0,d0
.Found2:	tst.l	d0
		rts


**-----------------------------------------------------------------------------*
*UpdateActAmplGadget:
*		movem.l	d0-a6,-(a7)
*		moveq	#1,d2				;Disabled
*
*		move.l	EUS_Structure+EUS_EPBase(pc),a4
*		move.l	EPG_ActiveAmplifier(a4),d0
*		beq.s	.No
*		move.l	d0,a0
*		move.l	EUS_MsgFlags(a0),d0
*		btst	#USMF_Configuration,d0
*		bne.s	.Doch
*		move.l	EUS_TagList(a0),a0
*		move.l	#EUT_Config,d0
*		jsr	ENPP_FindTag(a4)
*		moveq	#1,d2
*		tst.l	d0
*		beq.s	.No
*.Doch:		moveq	#0,d2
*.No:		move.l	#GD_ActiveAmplifier,d0
*		move.l	d2,d1
*		bsr	ChangeGui
*		movem.l	(a7)+,d0-a6
*		rts


*****************************************************************************
* Alle Gadgets, die bisher fr das Hauptfenster erstellt wurden, freigeben *
****************************************************************************
FreeMaingadgets:
		push	d0-a6
		move	GD_Count(a5),d6
		subq.w	#1,d6
		blt.s	.end
		move.l	GD_Firstgadget(a5),d0
.Loop:		beq.s	.End
		move.l	d0,a0
		move.l	(a0),d4				;next 

		move.l	GG_UserData(a0),d2		;Image Objekt
		move.l	IntSave(a5),a6
		jsr	_LVODisposeobject(a6)		;Gadget freigeben

		tst.l	d2
		beq.s	.noI
		move.l	d2,a0
		jsr	_LVODisposeobject(a6)		;zugehriges Image freigeben

.noI:		move.l	GD_MyClass(A5),d0
		beq.s	.noC
		move.l	d0,a0
		jsr	_LVOFreeClass(a6)		;Klasse lschen
		tst.l	d0				;noch in Benutzung ?
		beq.s	.noC				;yup, weiter
		clr.l	GD_MyClass(A5)		;Klasse lschen
.noC:		move.l	d4,d0
		dbf	d6,.loop

.end:		clr	GD_Count(A5)
		clr.l	GD_Firstgadget(A5)
		pop	d0-a6
		rts


*************************************************************************
*          Boopsi Gadgets fr das HauptFenster erstellen                *
*************************************************************************
MakeMaingadgets:
		push	d1-a6

		clr.l	GD_FirstGadget(A5)
		clr	GD_Count(A5)
		suba.l	a4,a4			;GA_Previous

		move.l	WinHandle(A5),d0
		beq	.ErrorinGads
		move.l	d0,a0
		move.b	wd_bordertop(a0),d0	;Fonts > 120 ?? glaube ich kaum...
		add.b	wd_borderbottom(a0),d0
		ext.w	d0
		neg.w	d0
		add.w	wd_height(a0),d0	;WA_Innerheight :)

		move.b	wd_borderleft(a0),d1
		add.b	wd_borderright(a0),d1
		ext.w	d1
		neg.w	d1
		add.w	wd_width(a0),d1		;WA_Innerwidth :)

		lea	MainGadsList(pc),a0
.gadgetsloop:	move	(a0)+,d1		;Leftedge
		beq.s	.end
		move	(a0)+,d2		;Topedge
		move	(a0)+,d3		;Width
		move	(a0)+,d4		;Height
		moveq	#0,d5
		move.w	(a0)+,d5		;GA_ID
		moveq	#0,d7
		move.w	(a0)+,d7		;Flags
		move.l	(a0)+,a3		;LabelImage
		bsr	.GetGadget
		beq.s	.erroringads
		tst.w	GD_Count(A5)
		bne.s	.notfirst
		move.l	d0,GD_FirstGadget(A5)
.notfirst:	addq	#1,GD_Count(A5)
		move.l	d0,a4			;GA_Previous
		bra.s	.gadgetsloop
.end:		pop	d1-a6
		move.l	GD_FirstGadget(A5),d0
		rts

.erroringads:	bsr	FreeMaingadgets
		pop	d1-a6
		moveq	#0,d0			;FALSE
		rts

.GetGadget:	push	d1-a6
		move.l	WinHandle(A5),a0	;Gadgetgre/Position anpassen
		move.b	wd_bordertop(a0),d6
		move.b	d6,d0
		add.b	wd_borderbottom(a0),d0
		ext.w	d0
		neg.w	d0
		add.w	wd_height(a0),d0	;WA_Innerheight :)
		mulu	d0,d2			;top
		mulu	d0,d4			;height
		divu	#Defheight,d2		;def Wert
		divu	#Defheight,d4		;def Wert
		ext.w	d6
		add	d6,d2			;ypos

		move.b	wd_borderleft(a0),d0
		move.b	d0,d6
		add.b	wd_borderright(a0),d0
		ext.w	d0
		neg.w	d0
		add.w	wd_width(a0),d0		;WA_Innerwidth :)
		mulu	d0,d1			;top
		mulu	d0,d3			;height
		divu	#Defwidth,d1		;def Wert
		divu	#Defwidth,d3		;def Wert
		ext.w	d6
		add	d6,d1

		tst.b	d7
		bmi.w	.makeProp

	*------------ Image zentrieren... ----------------*
		move	d3,d0			;Breite des Gadgets
		sub	ig_width(a3),d0		;minus Imagebreite
		lsr	#1,d0
		move	d0,ig_leftedge(a3)
		move	d4,d0			;Hhe des Gadgets
		sub	ig_height(a3),d0	;minus Imagehhe
		lsr	#1,d0
		move	d0,ig_topedge(a3)

		move.l	gd_myclass(A5),d0
		bne.s	.gotit
		lea	.Classdispatcher(pc),a1	; pointer to dispatcher
		bsr	initmyclass
		move.l	d0,gd_myclass(A5)
		beq	.err2
.gotit:		move.l	d0,a0
		lea	MyTags(a5),a2
		move.l	#IA_width,(a2)+
		move.l	d3,(A2)+
		move.l	#IA_height,(a2)+
		move.l	d4,(A2)+

		move.l	#SYSIA_Which,(a2)+		;Hier: 0=enabled,1=disabled
		move.l	d7,d0
		and.b	#1,d0
		move.l	d0,(A2)+

		move.l	#TAG_DONE,(A2)
		lea	MyTags(a5),a2
		suba.l	a1,a1
		move.l	IntSave(A5),a6
		push	d1-d5			;just to be sure...
		jsr	_LVONewObjectA(a6)
		pop	d1-d5
		move.l	d0,d6
		beq	.err2
		bra.w	.makegad

.makeProp:	push	d1-d5
		moveq	#0,d6
		move	(a3),d6
		mulu	d0,d6			;Breite
		divu	#defwidth,d6		;def Wert

		lea	MyTags(a5),a2			;Tags
		move.l	#IA_Width,(a2)+
		moveq	#0,d1
		move	(a3),d1
		mulu	d0,d1			;Breite
		divu	#defwidth,d1		;def Wert
		move.l	d1,(a2)+
		move.l	#IA_Height,(a2)+
		move.l	d4,(a2)+
		clr.l	(a2)
		suba.l	a0,a0				;Privclass keine
		lea	frameclass(pc),a1		;Frameiclass
		lea	MyTags(a5),a2			;Tags
		move.l	IntSave(A5),a6
		jsr	_LVOnewobjecta(a6)
		pop	d1-d5
		move.l	d0,d6
		beq	.err2

		lea	MyTags(a5),a2
		move.l	#PGA_freedom,(a2)+
		move.l	#freehoriz,(A2)+
		move.l	#PGA_visible,(A2)+
		move.l	#1,(a2)+
		move.l	#GA_Selectrender,(A2)+
		move.l	d6,(a2)+
		move.l	#PGA_total,(a2)+
		moveq	#0,d0
		move.w	2(a3),d0
		move.l	d0,(a2)+
		move.l	#PGA_top,(a2)+
		move	4(a3),d0
		move.l	d0,(a2)+
		move.l	#PGA_Newlook,(a2)+
		move.l	#1,(a2)+
		move.l	#PGA_Borderless,(a2)+
		move.l	#1,(a2)+
	;	move.l	#GA_Highlight,(A2)+
	;	move.l	#1,(a2)+

		move.l	d6,d0
		lea	propclass(pc),a1
		bra.s	.makegad.2

.makegad:	lea	MyTags(a5),a2
		lea	frbutclass(pc),a1		;ButtonClass
.makegad.2:	move.l	#GA_UserData,(A2)+
		move.l	d0,(A2)+
		move.l	#GA_Image,(a2)+
		move.l	d0,(A2)+
		move.l	#GA_Left,(A2)+
		ext.l	d1
		move.l	d1,(A2)+
		move.l	#GA_Top,(A2)+
		ext.l	d2
		move.l	d2,(A2)+
		move.l	#GA_Width,(A2)+
		ext.l	d3
		move.l	d3,(A2)+
		move.l	#GA_Height,(A2)+
		ext.l	d4
		move.l	d4,(A2)+
		move.l	#GA_id,(a2)+
		move.l	d5,(A2)+

		tst.b	d7
		bmi.s	.skipLabelimg	
		move.l	#GA_Labelimage,(A2)+
		move.l	a3,(a2)+
.skipLabelimg:
		move.l	a4,d0
		beq.s	.skip
		move.l	#GA_Previous,(A2)+
		move.l	a4,(a2)+
.skip
		move.l	#GA_ToggleSelect,(A2)+		;funktioniert (noch?) nicht
		move.l	d7,d0
		and.b	#8,d0
		lsr.b	#3,d0
		move.l	d0,(a2)+

		move.l	#GA_Immediate,(A2)+		;Flags.2
		move.l	d7,d0
		and.b	#2,d0
		lsr.b	#1,d0
		move.l	d0,(a2)+
		beq.s	.noIDCMPUpdate
		
		move.l	#ICA_Target,(a2)+
		move.l	#ICTARGET_IDCMP,(A2)+

.noIDCMPUpdate
		move.l	#GA_Relverify,(A2)+		;Flags.2
		move.l	d7,d0
		and.b	#4,d0
		lsr.b	#2,d0
		move.l	d0,(a2)+

		move.l	#GA_Disabled,(A2)+		;Flags.1
		and.b	#1,d7
		move.l	d7,(A2)+

		move.l	#TAG_DONE,(A2)

		suba.l	a0,a0				;Privclass keine
		lea	MyTags(a5),a2			;Tags
		move.l	IntSave(A5),a6
		jsr	_LVOnewobjecta(a6)
		tst.l	d0
		bne.s	.err2

;.... Fehlerfall

		tst.l	d6
		beq.s	.noI
		move.l	d6,a0
		jsr	_LVODisposeobject(a6)
.noI:		move.l	GD_myclass(A5),d0
		beq.s	.noC
		move.l	d0,a0
		jsr	_LVOFreeClass(a6)
		tst.l	d0
		beq.s	.noC
		clr.l	GD_myclass(A5)
.noC:		moveq	#0,d0

;......

.err2:		pop	d1-a6
		tst.l	d0
		rts

.ClassDispatcher:
		push	d2-d7/a2-a6		; save registers
		move.l	a0,a4			; class to a4
		move.l	a1,a3			; msg to a3
		lea	Datas,a5		; Data Pointer

		moveq	#8,d4			; Minwidth
		moveq	#8,d5			; Minheight
		cmp.l	#OM_NEW,(a3)		; user want a new object ?
		bne.s	.noNew
		bsr	MakeNew
		bra	.done
.noNew:
		cmp.l	#IM_DRAW,(A3)		;IM_DRAW,(a3)		; must we draw  ?
		bne	.default		; no!
.draw:		moveq	#0,d4			; left = 0
		moveq	#0,d5			; top = 0
		move.w	ig_width(A2),d6		; width  >= 24
		move.w	ig_height(A2),d7	; height >= 8
		move.b	ig_PlanePick(A2),d1	; set Type

		move.w	impd_OffsetX(a3),d4	; left = x offset
		move.w	impd_OffsetY(a3),d5	; top = y offset

		move.l	GrafSave(a5),a6
		move.l	impd_RPort(a3),a4	; rPort to a5

		move.l	impd_DrInfo(a3),a2	; drawinfo to a2
		move.l	dri_Pens(a2),a2		; drawinfo pens to a2

		clr.l	rp_AreaPtrn(a4)		; clear area pattern
		clr.b	rp_AreaPtSz(a4)

		tst.b	d1
		beq.s	.ok_pat
		move.b	#1,rp_areaptsz(a4)
		lea	patt1(pc),a0
		move.l	a0,rp_areaptrn(a4)

.ok_pat:	cmp.l	#IDS_SELECTED,impd_State(a3) ; selected text pen?
		bne	.DoUnSEL

;**********************  selected State *****************************
;------------------------ draw frame --------------------------------

		move.l	a4,a1			; rPort to a1
		move.w	Shadowpen*2(a2),d0	; dark edges
		jsr	_LVOSetAPen(a6)		; set the pen

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		move	d5,d1
		addq	#1,d1
		jsr	_LVOmove(A6)

		lea	-50(sp),sp
		lea	(sp),a0

		move	d4,(a0)+		;nach unten
		move	d5,d1
		add	d7,d1
		subq	#2,d1
		move	d1,(a0)+

		move	d4,d0			;1 Pkt nach rechts
		addq	#1,d0
		move	d0,(a0)+
		move	d1,(a0)+
	
		move	d0,(a0)+		;nach oben
		move	d5,(a0)+

		move	d4,d0			;nach rechts
		add	d6,d0
		subq	#2,d0
		move	d0,(A0)+
		move	d5,(a0)+

		move	d0,(a0)+		;1 Pkt nach unten
		move	d5,d1
		addq	#1,d1
		move	d1,(a0)+

		move	d4,(a0)+
		move	d1,(a0)+

		lea	(Sp),a0
		moveq	#6,d0
		move.l	a4,a1
		jsr	_LVOPolyDraw(A6)
		lea	50(sp),sp

		move.l	a4,a1			; rPort to a1
		move.w	Shinepen*2(a2),d0	; dark edges
		jsr	_LVOSetAPen(a6)		; set the pen

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		addq	#1,d0
		move	d5,d1
		add	d7,d1
		subq	#1,d1
		jsr	_LVOmove(A6)		; 1 nach rechts + ganz nach unten

		lea	-50(sp),sp
		lea	(sp),a0

		move	d4,d0
		add	d6,d0
		subq	#2,d0
		move	d0,(a0)+
		move	d5,d1
		add	d7,d1
		subq	#1,d1
		move	d1,(A0)+		; nach rechts

		move	d0,(a0)+
		move	d5,d1
		addq	#2,d1
		move	d1,(A0)+		; nach oben

		addq	#1,d0
		move	d0,(a0)+
		subq	#1,d1
		move	d1,(a0)+		;1 nach rechts + 1 nach oben

		move	d0,(a0)+
		move	d5,d1
		add	d7,d1
		subq	#2,d1
		move	d1,(A0)+		; nach unten

		move	d4,d0
		addq	#2,d0
		move	d0,(a0)+
		move	d1,(a0)+		; nach links

		lea	(Sp),a0
		moveq	#5,d0
		move.l	a4,a1
		jsr	_LVOPolyDraw(A6)
		lea	50(sp),sp

		moveq	#1,d0			; return TRUE
		bra	.Done

;******************** unselected State ******************************
;-------------------- clear Background  ---------------------------------

.DoUnSEL:	move.l	a4,a1			; rPort to a1
		move.w	backgroundPen*2(a2),d0	; BACKGROUNDPEN color
		tst.b	d1
		beq.s	.back
		move.w	Shadowpen*2(a2),d0	; dark edges
.back:		jsr	_LVOSetAPen(A6)		; set the pen

		move.l	a4,a1
		move.w	backgroundPen*2(a2),d0	; BACKGROUNDPEN color
		jsr	_LVOSetBPen(A6)		; set the pen

		move.l	a4,a1
		move.l	#RP_JAM2,d0
		jsr	_LVOsetDrMd(A6)

		move.l	a4,a1			; rPort to a1
		move.w	d4,d0			; left to d0
		addq	#2,d0
		move.w	d5,d1			; top to d1
		addq	#2,d1

		move.w	d4,d2
		add.w	d6,d2
		subq.w	#3,d2			; left + width - 1 to d2
		move.w	d5,d3
		add.w	d7,d3
		subq.w	#3,d3			; top + height - 1 to d3
		jsr	_LVOrectfill(A6)

;------------------------ draw frame --------------------------------
		move.l	a4,a1			; rPort to a1
		move.w	Shadowpen*2(a2),d0	; dark edges
		jsr	_LVOSetAPen(a6)		; set the pen

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		addq	#1,d0
		move	d5,d1
		add	d7,d1
		subq	#1,d1
		jsr	_LVOmove(A6)		; 1 nach rechts + ganz nach unten

		lea	-50(sp),sp
		lea	(sp),a0

		move	d4,d0
		add	d6,d0
		subq	#2,d0
		move	d0,(a0)+
		move	d5,d1
		add	d7,d1
		subq	#1,d1
		move	d1,(A0)+		; nach rechts

		addq	#1,d0
		move	d0,(a0)+
		subq	#1,d1
		move	d1,(A0)+		; 1 Pix nach rechts, einer nach oben

		move	d0,(A0)+
		move	d5,d1
		addq	#1,d1
		move	d1,(a0)+		; nach oben

		subq	#1,d0
		move	d0,(a0)+		; 1 Pix nach links, einer nach oben
		move	d5,(a0)+

		move	d4,d0
		addq	#1,d0
		move	d0,(a0)+		; nach links
		move	d5,(A0)+

		move	d4,(A0)+		; 1 nach links, 1 nach unten
		move	d1,(a0)+

		move	d4,(a0)+		; nach unten
		move	d5,d1
		add	d7,d1
		subq	#2,d1
		move	d1,(a0)+

		move	d4,d0
		add	d6,d0
		subq	#2,d0
		move	d0,(A0)+		; Nach rechts
		move	d1,(A0)+

		move	d0,(A0)+		; nach oben
		move	d5,(A0)+

		lea	(Sp),a0
		moveq	#9,d0
		move.l	a4,a1
		jsr	_LVOPolyDraw(A6)
		lea	50(sp),sp

		move.l	a4,a1			; rPort to a1
		move.w	Shinepen*2(a2),d0	; dark edges
		jsr	_LVOSetAPen(a6)		; set the pen

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		addq	#1,d0
		move	d5,d1
		add	d7,d1
		subq	#2,d1
		jsr	_LVOmove(A6)		; 1 nach rechts, nach unten-1

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		addq	#1,d0			; 1 nach rechts und 1. Zeile
		move	d5,d1
		addq	#1,d1
		jsr	_LVOdraw(A6)		; Line right

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		add	d6,d0
		subq	#2,d0

		move	d5,d1
		addq	#1,d1
		jsr	_LVOdraw(A6)		; Line up

		moveq	#1,d0			; return TRUE
		bra.s	.Done

.default:	move.l	a4,a0			; class to a0
		move.l	a3,a1			; msg to a1
		bsr	CallSuper		; call superclass
.Done:		pop	d2-d7/a2-a6		; restore registers
		rts

*************************************************************************
*             ber "MakeBorderGadget" erzeugte Gadgets freigeben        *
*************************************************************************
FreeBorderGadget:
		push	d0-a6
		tst.l	d0
		beq.s	.noG
		move.l	d0,a0
		move.l	gg_UserData(a0),d2		;Image Objekt
		move.l	IntSave(a5),a6
		jsr	_LVODisposeobject(a6)		;Gadget freigeben

		tst.l	d2
		beq.s	.noI
		move.l	d2,a0
		move.l	IntSave(a5),a6
		jsr	_LVODisposeobject(a6)		;zugehriges Image freigeben
.noI:		move.l	BD_myclass(A5),d0
		beq.s	.noC
		move.l	d0,a0
		jsr	_LVOFreeClass(a6)		;Klasse lschen
		tst.l	d0				;noch in Benutzung ?
		beq.s	.noC				;yup, weiter
		clr.l	BD_myclass(A5)			;Klasse lschen
.noC:
.noG:		pop	d0-a6
		rts

**************************************************************************
*          Bordergadgets fr Titelleiste erzeugen                        *
* Ntig:  Fenster   (WinHandle)                                          *
*         Pubscreen (mypubscreen)                                        *
*         D0        Nummer des Images (0=Iconify,1=Pubscreenjump,2=Filter*
* Return: D0        Gadget (gg_gadgetid=[Nummer]+10)                     *
**************************************************************************
MakeBorderGadget:
		push	d1-a6
		move.l	d0,d3				;Nummer des Gadgets

		moveq	#0,d6
		moveq	#0,d5		;Position des "rechtesten" Bordergadgets

		move.l	WinHandle(A5),d0
		beq	.err1
		move.l	d0,a0
		move.l	wd_firstgadget(A0),d0
.rechtsloop:	beq	.found
		move.l	d0,a0
		move.w	gg_flags(A0),d0
		and.w	#GFLG_RELRIGHT,d0
		beq.s	.skip
		tst.w	gg_topedge(a0)
		bne.s	.skip
		move.w	gg_leftedge(a0),d0
		cmp.w	d0,d5
		blt.s	.skip
		move.w	d0,d5
.skip:		move.l	(a0),d0
		bra.s	.rechtsloop

.found:		ext.l	d5
		move.l	BD_myclass(A5),d0
		bne.s	.gotit
		lea	.Classdispatcher(pc),a1	; pointer to dispatcher
		bsr	initmyclass
		move.l	d0,BD_myclass(A5)
		beq	.err2
		move.l	d0,a0
		move.l	#`EAGL`,cl_UserData(a0)	;damit die Patches besser klar kommen :-)

.gotit:		move.l	IntSave(A5),a6
		move.l	d0,a0

		lea	MyTags(a5),a2
		move.l	#SYSIA_Which,(A2)+	;Eigenheit meiner Klasse,
		move.l	d3,(A2)+		;hat nichts mit sysiclass zu
						;tun
						;0=Iconify, 1=Pubscreenjump,2=Filter
		move.l	#IA_width,(a2)+
		move.l	#23,(A2)+
		sub.l	#23,d5				;xpos

		move.l	#IA_height,(a2)+
		move.l	Winhandle(a5),a1
		moveq	#0,d0
		move.b	wd_bordertop(a1),d0
		move.l	d0,(A2)+

		move.l	#TAG_DONE,(A2)
		lea	MyTags(a5),a2

		suba.l	a1,a1
		jsr	_LVONewObjectA(a6)
		move.l  d0,d4
		beq	.err2
		move.l	d0,a0

		lea	MyTags(a5),a2
		move.l	#GA_UserData,(A2)+
		move.l	d0,(A2)+
		move.l	#GA_Image,(a2)+
		move.l	d0,(A2)+
		move.l	#GA_RelRight,(A2)+
		move.l	d5,(A2)+
		move.l	#GA_Top,(A2)+
		move.l	#0,(A2)+
		move.l	#GA_id,(a2)+

		moveq	#0,d0
		move.w	#EPNr_Iconify,d0
		tst.w	d3
		beq.s	.NimmIt
		move.w	#MyNr_PubScreenJump,d0		;EPNr_Pubscreenjump
		subq	#1,d3
		beq.s	.NimmIt
		move.w	#EPNr_ToggleFilter,d0	;hier Filter-TOGGLE Kommando einfgen
.NimmIt:
		move.l	d0,(A2)+
		move.l	#GA_TopBorder,(A2)+
		move.l	#1,(A2)+
		move.l	#GA_Relverify,(a2)+
		move.l	#1,(A2)+

;		move.l	#GA_Width,(a2)+
;		move.l	#23,(A2)+

		move.l	#TAG_DONE,(A2)

		suba.l	a0,a0				;Privclass keine
		lea	butclass(pc),a1			;ButtonClass
		lea	MyTags(a5),a2			;Tags
		move.l	IntSave(A5),a6
		jsr	_LVOnewobjecta(a6)
		tst.l	d0
		bne.s	.err2

;.... Fehlerfall

		tst.l	d4
		beq.s	.noI
		move.l	d4,a0
		jsr	_LVODisposeobject(a6)
.noI:		move.l	BD_myclass(A5),d0
		beq.s	.noC
		move.l	d0,a0
		jsr	_LVOFreeClass(a6)
		tst.l	d0
		beq.s	.noC
		clr.l	BD_myclass(A5)
.noC:		moveq	#0,d0

;......

.err2:		move.l	d0,d6
.err1:		move.l	d6,d0
		pop	d1-a6
		tst.l	d0
		rts

.ClassDispatcher:
		push	d2-d7/a2-a6		; save registers
		move.l	a0,a4			; class to a4
		move.l	a1,a3			; msg to a3
		lea	Datas,a5		; Data Pointer

		moveq	#23,d4			; Minwidth
		moveq	#8,d5			; Minheight
		cmp.l	#OM_NEW,(a3)		; user want a new object ?
		bne.s	.noNew
		bsr	MakeNew			; no!
		tst.l	d0
		beq	.done
		move.l	d0,a0

;		move.l	-4(a0),a1		;Class (kommt hin, aber ob`s wirklich so stimmt ??)
;		move.l	BD_myclass(A5),a1	;so is wohl besser ;-)
;		move.w	cl_instoffset(a1),d1

		move.w	cl_instoffset(a4),d1	;class->offset InstanceData

		lea	(a0,d1.w),a1		;Instance Data

		tst.l	d5
		beq.s	skipit$
		eor.w	#3,d5
skipit$
		move.l	d5,(a1)+		;Iconify=0,Pubscreen Jump=1, Filter=2
		move.l	#`EAGL`,(a1)+		;Ident. String (gut nicht ?)
		move.l	#`BIFG`,(a1)+		;Bifat GUI
						;das war`s mit den 12 Bytes Instsize
		bra	.done

.noNew:		cmp.l	#IM_DRAW,(a3)		; must we draw  ?
		bne	.default			; no!

.draw:		moveq	#0,d4				; left = 0
		moveq	#0,d5				; top = 0
		move.w	ig_width(A2),d6			; width  >= 24
		move.w	ig_height(A2),d7		; height >= 8
		move.b	ig_PlanePick(A2),d5		; set Type (0, 1 or 2)
		move.w	d5,-(Sp)

		move.w	impd_OffsetX(a3),d4		; left = x offset
		move.w	impd_OffsetY(a3),d5		; top = y offset

		move.l	GrafSave(a5),a6
		move.l	impd_RPort(a3),a4		; rPort to a5

		move.l	impd_DrInfo(a3),a2		; drawinfo to a2
		move.l	dri_Pens(a2),a2			; drawinfo pens to a2

		clr.l	rp_AreaPtrn(a4)			; clear area pattern
		clr.b	rp_AreaPtSz(a4)

		move.l	a4,a1				; rPort to a1

		move.w	backgroundPen*2(a2),d0		; BACKGROUNDPEN color
		cmp.l	#IDS_INACTIVENORMAL,impd_State(a3)	; draw selected ?
		beq.s	.penDone
		cmp.l	#IDS_INACTIVESELECTED,impd_State(a3)	; draw selected ?
		beq.s	.penDone

		move.w	fillPen*2(a2),d0		; FILLPEN color
.penDone:	jsr	_LVOSetAPen(A6)			; set the pen

		move.l	a4,a1			; rPort to a1
		move.w	d4,d0			; left to d0
		move.w	d5,d1			; top to d1
		addq	#1,d1
		move.w	d4,d2
		add.w	d6,d2
		subq.w	#1,d2			; left + width - 1 to d2
		move.w	d5,d3
		add.w	d7,d3
		subq.w	#1,d3			; top + height - 1 to d3
		jsr	_LVOrectfill(A6)

		cmp.l	#IDS_SELECTED,impd_State(a3) ; selected text pen?
		beq	.DoSEL

;********************  unselected State *****************************

;------------------------ draw frame --------------------------------
		move.l	a4,a1			; rPort to a1
		move.w	Shadowpen*2(a2),d0	; dark edges
		jsr	_LVOSetAPen(a6)		; set the pen

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		subq	#1,d0
		move	d5,d1			; (0,0)
		addq	#1,d1
		jsr	_LVOmove(A6)

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		subq	#1,d0
		move	d5,d1
		add	d7,d1
		subq	#1,d1
		jsr	_LVOdraw(A6)		; Line down

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		add	d6,d0
		subq	#1,d0
		move	d5,d1
		add	d7,d1
		subq	#1,d1
		jsr	_LVOdraw(A6)		; Line right

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		add	d6,d0
		subq	#1,d0
		move	d5,d1
		addq	#1,d1
		jsr	_LVOdraw(A6)		; Line up

		move.l	a4,a1			; rPort to a1
		move.w	Shinepen*2(a2),d0	; dark edges
		jsr	_LVOSetAPen(a6)		; set the pen

		move.l	a4,a1			; rPort to a1
		move	d4,d0
;		addq	#1,d0
		move	d5,d1
		add	d7,d1
		subq	#2,d1
		jsr	_LVOmove(A6)

		move.l	a4,a1			; rPort to a1
		move	d4,d0
;		addq	#1,d0
		move	d5,d1
		jsr	_LVOdraw(A6)		; Line up

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		add	d6,d0
		subq	#1,d0
		move	d5,d1
		jsr	_LVOdraw(A6)		; Line right

		lea	BP_Iconifyun(pc),a1	; Nummer 0 = IconifyImage
		move.w	(sp)+,d1
		beq.s	.render1
		lea	BP_JumpUN(pc),a1

		subq	#1,d1
		beq.s	.render1
		lea	BP_Filterun(pc),a1
.render1:	bsr	Renderimage

		moveq	#1,d0			; return TRUE
		bra	.Done

;********************  selected State *****************************
;------------------------ draw frame --------------------------------

.DoSEL:		move.l	a4,a1			; rPort to a1
		move.w	Shadowpen*2(a2),d0	; dark edges
		jsr	_LVOSetAPen(a6)		; set the pen

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		subq	#1,d0
		move	d5,d1
		addq	#1,d1
		jsr	_LVOmove(A6)

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		subq	#1,d0
		move	d5,d1
		add	d7,d1
		subq	#2,d1
		jsr	_LVOdraw(A6)		; Line down

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		move	d5,d1
		add	d7,d1
		subq	#2,d1
		jsr	_LVOdraw(A6)		; Line right

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		move	d5,d1
		jsr	_LVOdraw(A6)		; Line up

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		add	d6,d0
		subq	#1,d0
		move	d5,d1
		jsr	_LVOdraw(A6)		; Line right

		move.l	a4,a1			; rPort to a1
		move.w	Shinepen*2(a2),d0	; dark edges
		jsr	_LVOSetAPen(a6)		; set the pen

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		move	d5,d1
		add	d7,d1
		subq	#1,d1
		jsr	_LVOMove(a6)

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		add	d6,d0
		subq	#1,d0
		move	d5,d1
		add	d7,d1
		subq	#1,d1
		jsr	_LVODraw(a6)		; Line right

		move.l	a4,a1			; rPort to a1
		move	d4,d0
		add	d6,d0
		subq	#1,d0

		move	d5,d1
		addq	#1,d1
		jsr	_LVODraw(a6)		; Line up

		lea	BP_Iconifysel(pc),a1	; Nummer 0 = IconifyImage
		move.w	(sp)+,d1
		beq.s	.Render2
		lea	BP_JumpSel(pc),a1
		subq	#1,d1
		beq.s	.Render2
		lea	BP_Filtersel(pc),a1
.Render2:	bsr	Renderimage
		moveq	#1,d0			; return TRUE
		bra.s	.Done

.Default:	move.l	a4,a0			; class to a0
		move.l	a3,a1			; msg to a1
		bsr	CallSuper		; call superclass
.Done:		pop	d2-d7/a2-a6		; restore registers
		rts

*------------- Images darstellen durch normale RastPort-Befehle ------------*
Renderimage:	push	d0-a6
		lea	PenTransTable,a5		;ACHTUNG !! Basisregister verwendet
		move.l	a1,a3
.Renderloop:	move.b	(a3)+,d2			;Typ
		beq.w	.RenderEND

		moveq	#0,d0
		move.b	(a3)+,d0			;Farbe
		add.w	d0,d0
		move.w	(a5,d0.w),d0			;Translation tab
		move	(a2,d0.w),d0			;DrawInfo->Pens
		move.l	a4,a1
		jsr	_LVOSetAPen(A6)			;Foreground

		subq.b	#1,d2				;1=Linie
		bne.s	.noline
		move.b	(A3)+,d0			;x
		alignh	d0
		move.b	(A3)+,d1			;y
		alignv	d1
		move.l	a4,a1
		jsr	_LVOMove(A6)

		move.b	(a3)+,d0
		alignh	d0
		move.b	(A3)+,d1
		alignv	d1
		move.l	a4,a1
		jsr	_LVODraw(A6)
		bra.s	.RenderLoop
.noline:	subq.b	#1,d2
		bne.s	.nofill

		move.l	a4,a1				; rPort to a1
		move.b	(a3)+,d0
		alignh	d0
		move.b	(a3)+,d1
		alignv	d1
		move.b	(a3)+,d2
		alignh	d2
		move.b	(a3)+,d3
		alignv	d3
		jsr	_LVOrectfill(A6)
		bra.w	.RenderLoop
.nofill:	addq.l	#4,a3
		bra.w	.RenderLoop
.RenderEND:	pop	d0-a6
		rts

*-----------------------------------------------------------------------------*
MakeNew:	move.l	Utility(A5),a6
		move.l	#IA_Width,d0		; the tag we want
		moveq	#0,d1			; default = NULL
		move.l	ops_AttrList(a3),a0	; tags to a0
		jsr	_LVOGetTagData(A6)	; look for the tag
		cmp.w	d4,d0			; tag found ?
		bge.s	.defwidth		; no
		move	d4,d0			; Minwidth
.defwidth:	move	d0,d6

		move.l	#IA_Height,d0		; the tag we want
		moveq	#0,d1			; default = NULL
		move.l	ops_AttrList(a3),a0	; tags to a0
		jsr	_LVOGetTagData(A6)	; look for the tag
		cmp.w	d5,d0			; tag found ?
		bge.s	.defheight		; no
		move	d5,d0
.defheight:	move	d0,d7

		move.l	#SYSIA_Which,d0		;Tag to be found
		moveq	#0,d1			;default Return value
		move.l	ops_AttrList(a3),a0	;Taglist
		jsr	_LVOGetTagData(A6)	;Utility-LibCall
		move	d0,d5

		move.l	a4,a0			;class to a0
		move.l	a3,a1			;msg to a1
		push	d5-d7
		bsr	callSuper		;call the superclass
		pop	d5-d7
		move.l	d0,a0			;put object in a0
		tst.l	d0
		beq.s	.newErrorO		;failed!!!
		move	d6,ig_Width(a0)		;set width
		move	d7,ig_Height(a0)	;set height
		move.b	d5,ig_PlanePick(A0)	;set Type
		bra	.Done			;return Object
.newErrorO:	moveq	#0,d0			; 0 for error
.done:		rts
;		pop	d2-d7/a2-a6		; restore registers
;		rts

*--------------------- Call Superclass ---------------------------------*
CallSuper:	push	a2			; save a2
		move.l	cl_Super(a0),a0		; get superclass in a0
		pea.l	ourRet			; push return address
		move.l	h_Entry(a0),-(sp)	; push superclass dispatcher
		rts				; jump to super dispatcher
ourRet:		pop	a2			; restore a2
		rts

*----------------------------------------------------------------------------*
* --- Initialize our private class. It set's up a class
* --- with "imageclass" as superclass.
Initmyclass:	push	d1-d6/a0/a1/a2/a6	; save registers
		move.l	a1,d6
		move.l	IntSave(A5),a6
		suba.l	a0,a0			; class ID
		lea	imgclass(pc),a1		; points to "imageclass"
		suba.l	a2,a2			; no superclass pointer
		moveq	#12,d0			; 12 bytes instance data (MCP&UHack Sysipatches)
		moveq	#0,d1			; no flags
		jsr	_LVOmakeclass(A6)	; make the class
		move.l	d0,a0			; put class in a0
		tst.l	d0
		beq.s	.noClass		; failed!!!
		move.l	d6,h_Entry(a0)		; set our dispatcher
.noClass:	pop	d1-d6/a0/a1/a2/a6	; restore registers
		rts

*****************************************************************************
*                        Daten und Initialisierungen                        *
*****************************************************************************
	ifne	test
Int:		dc.b	"intuition.library",0
Graf:		dc.b	"graphics.library",0
aslnam:		dc.b	"asl.library",0
dos		dc.b	`dos.library`,0
	endc
util:		dc.b	"utility.library",0
diskf:		dc.b	"diskfont.library",0
dt		dc.b	`datatypes.library`,0
reqto		dc.b	`reqtools.library`,0

	ifne	test
MyWinName:	dc.b	"Eagleplayer Registered and Copyrighted V"
EPVer1		dc.b	"x.xx",0
	endc
MyMenuName:	dc.b	"Bifat Gui",0
MyProzessName:dc.b	"Bifat Gui.1",0
MyCreatorname:dc.b	"Buggs & Eagleeye of Defect Softworks",0
MySpecialInfo:	dc.b	`BifatGUI is one of the new user interfaces introduced in Eagleplayer 2.0. `
		dc.b	`It is free sizeable (using an invisible sizing gadget in the lower right `
		dc.b	`corner) and allows the usage of a background picture (OS 3.0+ only). `,10
		dc.b	`It was designed by Timm Mller (= CPT Bifat of TEK). `,0
	
TopazName:	dc.b	"topaz.font",0
DT_Choosepic	dc.b	`Select Background Picture`,0

XenName:
		dc.b	`XEN.font`,0
;		dc.b	`XENprop.font`,0
;		dc.b	`Buggs.font`,0
;		dc.b	`AsphaltNarrow.font`,0
;		dc.b	`Asphaltfixed.font`,0
;		dc.b	`Bcourier.font`,0
;		dc.b	`Helvetica.font`,0
;		dc.b	`XHelvetica.font`,0
;		dc.b	`Serpentine.font`,0
;		dc.b	`Scaiv.font`,0
;		dc.b	`DgSansserif.font`,0	
;		dc.b	`univershi.font`,0

	ifne	test
Aboutmessage:
	dc.b	`Playing |Mod.Welcome to Alzheim`,0

	dc.b	`......EaglePlayer Scroller  V2.00 `
	dc.b	`(C) 1995 Henryk "BUGGS" Richter ! `
	dc.b	`you can reach the Author at the following Address:`
	dc.b	` Henryk Richter  St.-Jantzen Ring 47`
	dc.b	` 18106 Rostock,`
	dc.b	` GERMANY........... `
	dc.b	`ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz`,0
	endc

	even
	dc.l	1,10,100,1000,10000,100000,1000000,10000000,100000000
dectable:

;------------- Liste zur Erzeugung der Inhalte der Boopsigadgets ------------
;Aufbau:
; 1.Byte: Typ        (0=Ende,1=Linie,2=Fill)
; 2.Byte: Farbnummer (0-3) 1=Schwatt,2=weiss
; 3.Byte: Leftedge start (Koordinaten auf Breite/Hhe 100 bezogen)
; 4.Byte: TopEdge start
; 5.Byte: Leftedge stop
; 6.Byte: TopEdge stop
	even
BP_Iconifyun	dc.b	01,01,24,22,24,78
		dc.b	01,01,24,22,79,22,01,01,79,22,79,78,01,01,24,78,79,78,02,02,33,45,42,63,01,01,33,45,42,45,01,01,33,45,33,63,01,01,33,63,42,63,01,01,42,45,42,63,00
BP_Iconifysel	dc.b	02,02,33,45,38,63
		dc.b	01,01,33,45,38,45,01,01,33,45,33,63,01,01,33,63,38,63,01,01,38,45,38,63,01,01,24,27,24,78,01,01,24,27,46,27,01,01,46,27,46,78,01,01,24,78,46,78,00

BP_Filterun	dc.b	02,01,17,27,83,73
		dc.b	02,00,48,27,52,73

		dc.b	02,02,28,36,37,64
		dc.b	02,02,26,40,39,59

		dc.b	02,02,61,36,70,64
		dc.b	02,02,67,40,74,59
		dc.b	00

BP_Filtersel
		dc.b	02,01,17,27,83,73
		dc.b	02,00,48,27,52,73

		dc.b	02,00,28,36,37,64
		dc.b	02,00,26,40,39,59

		dc.b	02,00,61,36,70,64
		dc.b	02,00,67,40,74,59
		dc.b	00

BP_Jumpun	dc.b	02,01,38,27,87,73
		dc.b	02,00,43,34,82,66,02,02,43,34,82,36,01,01,13,27,13,73,01,01,13,27,27,49,01,01,13,73,27,51,00
BP_Jumpsel	dc.b	02,01,38,27,87,73
		dc.b	02,00,43,34,82,66
		dc.b	02,02,43,34,82,36
		dc.b	01,01,23,27,23,73
		dc.b	01,01,23,27,36,49
		dc.b	01,01,23,73,36,51,00
	even
PenTransTable:	dc.w	BACKGROUNDPEN*2		;Umwandlung der angegebenen Pens fr Bordergads in Screenpens
		dc.w	SHADOWPEN*2
		dc.w	SHINEPEN*2
		dc.w	FILLPEN*2

sysclass:	dc.b	`sysiclass`,0
frbutclass:	dc.b	`frbuttonclass`,0
butclass:	dc.b	`buttongclass`,0
imgclass	dc.b	`imageclass`,0
frameclass	dc.b	`frameiclass`,0
propclass	dc.b	`propgclass`,0

	even
Sizer1
		dc.l	0
		dc.w	-16,-4	;Leftedge,Topedge
		dc.w	16,4
		dc.w	gflg_relright!GFLG_RELBOTTOM!GFLG_GADGHNONE
		dc.w	0
		dc.w	GTYP_SIZING
		dc.l	0		;GadgetRender
		dc.l	0		;SelectRender
		dc.l	0		;Text
		dc.l	0		;Mutalexclude
		dc.l	0		;Specialinfo
		dc.w	0		;ID
		dc.l	0		;Userdata
Sizer2
		dc.l	0
		dc.w	-4,-16	;Leftedge,Topedge
		dc.w	4,16
		dc.w	gflg_relright!GFLG_RELBOTTOM!GFLG_GADGHNONE
		dc.w	0
		dc.w	GTYP_SIZING
		dc.l	0		;GadgetRender
		dc.l	0		;SelectRender
		dc.l	0		;Text
		dc.l	0		;Mutalexclude
		dc.l	0		;Specialinfo
		dc.w	0		;ID
		dc.l	0		;Userdata

;----------------- Liste der Gadgets fr das Hauptfenster -------------------
;leftedge.w,topedge.w,width.w,height.w,gadgetid.w,flags.w,Special.l
;Flags: $80 -> Propgadget (Vol/Bal)
;       $01 -> Gadget disable
;       $02 -> Gadget immediate
;	$04 -> Relverify
;	$08 -> GadgetToggle
;
;Special: Normaler Button: Image-Struct fr Label
;         Prop:            Extrainfos
;Extrainfos:
;	0.w - def. Breite des Sliderbuttons
;	2.w - max. Anzahl der Eintrge (z.B. 64)
;	4.w - def. Wert (z.B. 32)
;	.
;	.
;	.

MainGadsList:
	dc.w	002,01,29,13
	dc.w	GD_Volmin,04			;Volmin
	dc.l	SpkIMG

	dc.w	002,15,29,13
	dc.w	GD_Balleft,4			;EPNR_BalanceLeft,4
	dc.l	BalleftIMG

	dc.w	002,29,29,17
	*dc.w	EPNr_EngineManager,04
	dc.w	GD_Manager,04
	dc.l	UprImg

	dc.w	299,01,29,13
	dc.w	GD_Volmax,4			; Volmax
	dc.l	SpkOnImg

	dc.w	002,47,14,14
	dc.w	GD_ActiveAmplifier,04
	dc.l	SpkbigIMG

	dc.w	017,47,14,14
	dc.w	GD_AmplifierManager,04
	dc.l	NotesmallIMG

	dc.w	314,47,14,14
	dc.w	EPNr_LockModule,4		;+8
	dc.l	LockImage

	dc.w	299,47,14,14
	dc.w	GD_Moduleinfo,04
	dc.l	IIMG

	dc.w	033,29,22,17
	dc.w	EPNr_PrevModule,04
	dc.l	BackModIMG

	dc.w	057,29,22,17
	dc.w	EPNr_PrevSong,04
	dc.l	BackSongIMG

	dc.w	081,29,27,17
	dc.w	EPNR_PrevPattern,02
	dc.l	BackPattIMG

	dc.w	110,29,27,17
	dc.w	EPNr_ReplaySong,04
	dc.l	RestartIMG

	dc.w	139,29,27,17
	dc.w	EPNr_Play,04
	dc.l	PlayPauseIMG

	dc.w	168,29,27,17
	dc.w	EPNr_PlayFaster,02
	dc.l	FFIMG

	dc.w	197,29,27,17
	dc.w	EPNr_NextPattern,02
	dc.l	NextPattIMG

	dc.w	226,29,22,17
	dc.w	EPNr_NextSong,04
	dc.l	NextSongIMG

	dc.w	250,29,22,17
	dc.w	EPNr_NextModule,4
	dc.l	NextModIMG

	dc.w	274,29,22,17
	dc.w	EPNr_EjectModule,4
	dc.l	EjectIMG

	dc.w	299,29,29,17
	dc.w	EPNr_LoadModule,4
	dc.l	DiskIMG

	dc.w	299,15,29,13
	dc.w	GD_BalRight,4				;EPNr_BalanceRight,4
	dc.l	RbalImg


;	0.w - def. Breite des Sliderbuttons
;	2.w - max. Anzahl der Eintrge (z.B. 64)
;	4.w - def. Wert (z.B. 32)
VolBalPre:
	dc.w	035,04,259,07		;diese beiden zusammen lassen wg. printen der Rahmen !
	dc.w	EPNr_Volume,$86
	dc.l	Volextra
	dc.w	035,18,259,07
	dc.w	EPNr_Balance,$86
	dc.l	Balextra

	dc.w	0
Volextra	dc.w	18,EP_MaxVolume+1,EP_DefVolume
Balextra	dc.w	18,EP_MaxVolume*2+1,EP_MaxVolume

*---------------------- Fllpattern fr "disabled"-Gadget --------------*
Patt1	dc.w	%1000100010001000
	dc.w	%0010001000100010

	*------ Menu -------*
GuiMenu:	dc.l	0			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$52
		dc.l	0
		dc.l	.IText
		ds.b	6
		dc.l	SubItem1
		dc.l	0		*Kick2.0+ ??
.IText:		dc.w	3,0,0,1
		dc.l	0
		dc.l	SubItem.MSG
		dc.l	0
		dc.w	0			;No Nummer

	*----- SubItem 1 -----*
SubItem1:	dc.l	SubItem2		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15b
		dc.l	0
		dc.l	.IText1
		ds.b	12
		dc.l	0			;*Kick2.0+ ??
.IText1:	dc.w	3,0,20,1
		dc.l	0
		dc.l	SubItem1.Msg
		dc.l	0	
IDNr		dc.w	MI_FilterGadget
MI_ItemID = IDNr-Subitem1

	*----- SubItem 2 ----*
SubItem2:	dc.l	SubItem3		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15b
		dc.l	0
		dc.l	.IText2
		ds.b	12
		dc.l	0		*Kick2.0+ ??
.IText2:	dc.w	3,0,20,1
		dc.l	0
		dc.l	SubItem2.MSG
		dc.l	0	
		dc.w	MI_PubJumpGadget

	*----- SubItem 3 ----*
SubItem3:	dc.l	SubItem4		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15b
		dc.l	0
		dc.l	.IText2
		ds.b	12
		dc.l	0		*Kick2.0+ ??
.IText2:	dc.w	3,0,20,1
		dc.l	0
		dc.l	SubItem3.MSG
		dc.l	0	
		dc.w	MI_IconifyGadget

	*----- SubItem 4 ----*
SubItem4:	dc.l	SubItem5		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15b
		dc.l	0
		dc.l	.IText2
		ds.b	12
		dc.l	0		*Kick2.0+ ??
.IText2:	dc.w	3,0,20,1
		dc.l	0
		dc.l	SubItem4.MSG
		dc.l	0	
		dc.w	MI_BackPic

	*----- SubItem 5 ----*
SubItem5:	dc.l	0			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	ITEMTEXT!ITEMENABLED!HIGHCOMP
		dc.l	0
		dc.l	.IText2
		ds.b	12
		dc.l	0		*Kick2.0+ ??
.IText2:	dc.w	3,0,20,1
		dc.l	0
		dc.l	SubItem5.MSG
		dc.l	0	
		dc.w	MI_SelectBackPic

SubItem.MSG:	dc.b	"Bifatgui-Prefs",0
SubItem1.MSG	dc.b	"Filter Gadget",0
SubItem2.MSG	dc.b	"PubScreen Jump Gadget",0
SubItem3.MSG	dc.b	"Iconify Gadget",0
SubItem4.MSG	dc.b	`Background Picture`,0
SubItem5.MSG	dc.b	`Select Background Picture`,0

AmpManager:	dc.b	"Amplifiermanager",0
Moduleinfo:	dc.b	"Moduleinfo",0
Manager:	dc.b	"Manager",0
Help_ActiveAmplifier: dc.b "BifatGui_ActiveAmplifier",0
DT_PicName
;	dc.b	`gfx:used/grn-blau`,0

	dc.b	`sys:prefs/patterns/backdrop/mybackdrop.iff`,0

;	dc.b	`gfx:used/11`,0

;*********** Leertabellen (spter im BSS-Hunk) ***********************
		section	1,BSS
		rsreset
Datas:
Utility		rs.l	1
IntSave:	rs.l	1
GrafSave:	rs.l	1
DosSave		rs.l	1
WinHandle:	rs.l	1
Port:		rs.l	1
WinDrawInfo	rs.l	1
mycmap:		rs.l	1
mypen:		rs.l	1
Handle:		rs.l	1
ScrollSignal:	rs.l	1
Mytask		rs.l	1
mypubscreen:	rs.l	1	;aktueller Publicscreen
Eaglename:	rs.l	2
LastAmplifier	rs.l	1
Win_Hoehe:	rs.w	1
LastWinWidth	rs.w	1
LastWinHeight	rs.w	1

mytags:		rs.l	30*2
myzoom:		rs.w	3
myhoehe2:	rs.w	1
myhoehe1:	rs.w	1	;Hhe der Titelzeile

Intmerk		rs.w	1
Intset		rs.w	1
inter:		rs.l	2
		rs.b	1	;2
		rs.b	1	;127
		rs.l	3

;------------------ Daten fr die Gadgets ----------------------------------
myGAD1:		rs.l	3		;zur Zeit max. 3 Bordergads
BD_myclass	rs.l	1		;fr Bordergadgets
GD_myclass	rs.l	1		;fr normale Gadgets

GD_FirstGadget rs.l	1	;erstes Gadget im Hauptfenster ohne Bordergads
GD_Count	rs.l	1	;Anzahl der Gadgets (Buttons und Prop)

NextSelect	rs.l	1
;LastNummer	rs.l	1
;LastNummerBoopsAdr rs.l	1
*MenuOn		rs.w	1
GadgetsDa	rs.w	1
WindowMSG	rs.l	1
MenuStrip	rs.l	1

PattTime	rs.w	1		;wie lange gewartet wird, bis "NextPattern" gesendet wird
Lastvolume	rs.w	1

;------------------------------------- Daten fr den Scroller ---------------------------
DiskFont	rs.l	1	;Diskfont Library (wenn nicht da -> TOPAZ 8)

	ifne	Scroller

Nametemp	rs.b	30	;Name des Fonts,der vom Requester/Konfig kommt
Hoehetemp	rs.w	1	;Hhe des ............................

SCR_xpos	rs.w	1	;X-Pos im Fenster
SCR_ypos	rs.w	1	;Y-Pos im Fenster
SCR_Width	rs.w	1	;Breite des sichtbaren Scrollerbereiches
SCR_font_max	rs.w	1	;Max. Hoehe des Scrolfonts

SCR_Enable	rs.b	1	;Scroller erlaubt (<>0) oder verboten (=0)
SCR_CharTMP	rs.b	1	;Zeichen Temp. wg. LVOText
SCR_StopID	rs.b	1	;Stop, wenn fertig ja/nein
		rs.b	1
SCR_maxoff	rs.w	1	;justify
SCR_StepsLeft	rs.w	1	;wieviel Schritte noch bis zum nchsten Zeichen
SCR_NumSteps	rs.w	1	;wieviele Schritte insgesamt beim Scrollen
SCR_StopSteps	rs.w	1	;vieviele Schritte maximal bis stop ?
SCR_Offset0	rs.w	1	;Posi an linker Seite
SCR_Offset1	rs.w	1	;Posi rechter Teil
SCR_ScrolCurr	rs.l	1	;Pointer auf aktuelle Position im ScrolText
SCR_ScrolText	rs.l	1	;SCR_ScrolText
SCR_TextAttr	rs.b	ta_sizeof+4*2;TextAttr fr Openfont calls + Text extent space 
SCR_FontAdr	rs.l	1	;allozierter Font
SCR_RastPort	rs.b	rp_SIZEOF;eigener RastPort
SCR_Limitwidth	rs.w	1	;wieviel weniger Pixel als normal printen ?
SCR_Bitmap:	rs.b	8	;eigene Bitmap fr den RastPort
		rs.l	8
SCR_BitmapAdr	rs.l	1	;eigene Bitmap fr den RastPort, Kick 3+
SCR_FontNAME	rs.b	30	;Name des Fonts (z.B. helvetica.font)
SCR_Fontheight	rs.w	1
SCR_LastPrinted rs.l	1	;Zuletzt ber Printtext ausgegeben
SCR_TextStructAdr rs.l	1	;Letzter Text, der vom EP kam
	endc
TimeTMP		rs.l	4	;sollte reichen fr Zeitanzeige

;------------------------ Daten fr die Zeitanzeige ---------------------------------------
	ifne	time
TimeY		rs.w	1	;fr Zeitanzeige
TimeX		rs.w	1
TimeWy		rs.w	1
TimeWx		rs.w	1
Timecount	rs.w	1
	endc
;----------------------- Daten fr Datatypes-Bild ----------------------------------------
DTBase			rs.l	1
DT_PicObject		rs.l	1
DT_MyBitMapheader	rs.l	1
DT_MyBitMap		rs.l	1
DT_Breit2:		rs.l	1
DT_Hoehe2:		rs.l	1
DT_XPos2:		rs.l	1
DT_YPos2:		rs.l	1
addi			rs.l	1
RTBase			rs.l	1		;Reqtools.library

DT_Picture		rs.b	300

;----------------------- Wird als eigenes Prefsfile abgespeichert -----------------------

ConfigDatas		rs.b	0

DT_Picturedir		rs.b	200
DT_Picturename		rs.b	108

ConfigDatasEND		rs.b	0
;---------------------------------------------------------------------------------------

;----------------------- Daten fr die Crunchanzeige -----------------------------------
lastcrunchpos		rs.w	1

;----------------------- Daten fr Pubscreen-Jump --------------------------------------
PubNameBuff	rs.b	MAXPUBSCREENNAME+1


DatasLen:	rs.w	0
		ds.b	DatasLen

		section	img,data_C
SpkIMG
	dc.w	0,0
	dc.w	8,7
	dc.w	2
	dc.l	.Imagespeaker
	dc.b	3,0
	dc.l	0
.ImageSpeaker	dc.w	$0F00,$1B00,$F300,$F300,$F300,$1B00,$0F00,$0000,$0400,$0C00,$0C00,$0C00,$0400,$0000
BalleftIMG:
	dc.w	$004B,$005E
	dc.w	$0010,$0005,$0002
	dc.l	.Balleft
	dc.b	$03,$00
	dc.l	0
.Balleft	dc.w	$E000,$FC00,$FF80,$FFF0,$FFFE,$0000,$0000,$0000,$0000,$0000
UprImg:
	dc.w	$004B,$0070
	dc.w	$000E,$0009,$0002
	dc.l	.Upr
	dc.b	$03,$00
	dc.l	0
.Upr	dc.w	$00C0,$C0C0,$C0CC,$C0CC,$CCCC,$CCCC,$CCCC,$CCCC,$FFFC,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
SpkbigIMG:
	dc.w	$0046,$0089
	dc.w	$0008,$0008,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$0F00,$1B00,$F300,$F300,$F300,$F300,$1B00,$0F00,$0000,$0400,$0C00,$0C00,$0C00,$0C00,$0400,$0000
NotesmallIMG
	dc.w	$0046,$009D
	dc.w	$0008,$0008,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$0800,$0C00,$0B00,$0800,$0800,$7800,$F800,$7000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

;ClockIMG
;	dc.w	$0046,$00C6
;	dc.w	$0008,$0007,$0002
;	dc.l	Imagedata
;	dc.b	$03,$00
;	dc.l	0
;Imagedata:	dc.w	$3C00,$6600,$E700,$E100,$FF00,$7E00,$3C00,$0000,$1800,$1800,$1E00,$0000,$0000,$0000

BackModIMG
	dc.w	$0074,$004C
	dc.w	$000A,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$80C0,$83C0,$8FC0,$BFC0,$8FC0,$83C0,$80C0,$0000,$0000,$0000,$0000,$0000,$0000,$0000

BackSongIMG
	dc.w	$0074,$0064
	dc.w	$000B,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$C060,$C1E0,$C780,$DE00,$C780,$C1E0,$C060,$0000,$0000,$0000,$0000,$0000,$0000,$0000
BackPattIMG
	dc.w	$0071,$007C
	dc.w	$0011,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$03C3,$8000,$0F0F,$8000,$3C3F,$8000,$F0FF,$8000,$3C3F,$8000,$0F0F,$8000,$03C3,$8000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
RestartIMG
	dc.w	$0074,$0094
	dc.w	$0010,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$CCC0,$CCF0,$CCFC,$CCFF,$CCFC,$CCF0,$CCC0,$0000,$0000,$0000,$0000,$0000,$0000,$0000
PlayPauseIMG
	dc.w	$0076,$00AD
	dc.w	$000D,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$C038,$F038,$FC38,$FF38,$FC38,$F038,$C038,$0000,$0000,$0000,$0000,$0000,$0000,$0000
FFIMG
	dc.w	$0073,$00C4
	dc.w	$0012,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$F0F0,$0000,$3C3C,$0000,$0F0F,$0000,$03C3,$C000,$0F0F,$0000,$3C3C,$0000,$F0F0,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
NextPattIMG
	dc.w	$0073,$00DD
	dc.w	$0011,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$E1E0,$0000,$F878,$0000,$FE1E,$0000,$FF87,$8000,$FE1E,$0000,$F878,$0000,$E1E0,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
NextSongIMG
	dc.w	$00A0,$004D
	dc.w	$000B,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$C060,$F060,$3C60,$0F60,$3C60,$F060,$C060,$0000,$0000,$0000,$0000,$0000,$0000,$0000
NextModIMG
	dc.w	$00A0,$0066
	dc.w	$000B,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$C060,$F060,$FC60,$FF60,$FC60,$F060,$C060,$0000,$0000,$0000,$0000,$0000,$0000,$0000
EjectIMG
	dc.w	$00A2,$007D
	dc.w	$0009,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$0800,$1C00,$3E00,$7F00,$FF80,$0000,$FF80,$0000,$0000,$0000,$0000,$0000,$0000,$0000
DiskIMG
	dc.w	$00A0,$0096
	dc.w	$000D,$0009,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$F1B0,$F1B8,$F038,$FFF8,$FFF8,$C018,$C018,$C018,$C018,$0E40,$0E40,$0FC0,$0000,$0000,$3FE0,$3FE0,$3FE0,$3FE0
SpkOnImg:
	dc.w	$00,$00
	dc.w	$000E,$0007,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$0F08,$1B24,$F314,$F314,$F314,$1B24,$0F08,$0000,$0400,$0C00,$0C00,$0C00,$0400,$0000

RbalImg:
	dc.w	$00A1,$00C5
	dc.w	$000F,$0005,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$000E,$007E,$03FE,$1FFE,$FFFE,$0000,$0000,$0000,$0000,$0000

NoteGImg:
	dc.w	$00A1,$00EA
	dc.w	$000A,$000B,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$0C00,$0F00,$0BC0,$08C0,$0840,$7840,$F840,$7040,$03C0,$07C0,$0380,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

LockImage:
	dc.w	0,0
	dc.w	$0006,$0009,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0

.Imagedata:
	dc.w	$3000,$4800,$4800,$FC00,$FC00,$FC00,$FC00,$FC00,$FC00,$0000,$3000,$3000,$0000,$0000,$0000,$0000,$0000,$0000


;"Info"
IIMG:	dc.w	$0046,$00B2
	dc.w	$0006,$0008,$0002
	dc.l	.Imagedata
	dc.b	$03,$00
	dc.l	0
.Imagedata:	dc.w	$3000,$3000,$0000,$F000,$3000,$3000,$3000,$FC00,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

