*****************************************************************************
**                                                                         **
** Engine: Analyzer                                                        **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

	;
	;strzt nach 3 Minuten ab, wenn der Eagleplayer modifiziert wurde
	;(zersgt Graphics.library "Bltbitmap" und "bltbitmaprastport")
	;
	incdir	Include:
	include	exec/exec_lib.i
	include	exec/libraries.i
	include	exec/interrupts.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	dos/dos_lib.i
	include	libraries/dos.i
	include	graphics/graphics_lib.i
	include	misc/eagleplayerengine.i

Test = 0	;auf 0 lassen zur Nutzung mit dem Eagleplayer !!!!!
		;(zu Testzwecken meldet sich sonst der Analyzer selbst ab !)
Points = 1	;auf 0 setzen,wenn Punkte links und rechts der Anzeigebalken
		;weg sollen
;===========================================================================
	section	0,code
;===========================================================================
an_num = 28			;Anzahl der Balken (gerade Zahl)
an_zeilen = 64
weiterrunter = AN_zeilen+7
	if	(an_num+4)*8<264
win_breite = 256
	else
win_breite = (an_num+4)*8
	endc
Peek_time = 25 		;1/2 Sekunde
Wait_time = 50		;1 Sekunden warten,bevor Bild erscheint,wenn STOP oder
			;Pause
extra_place = 36
;===========================================================================
BEGIN
	bra.w	fangan
	EUSN_Identifier
	dc.l	0		;eus_next
	dc.w	0		;eus_Usernr
	dc.l	0		;eus_EPBase
	dc.l	0
	dc.l	0
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;eus_unused3
	dc.l	Tagliste	;eus_unused4
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_Zipwin!USMB_ChangeConfig!USMB_ChangeInterrupt;eus_msgflags

	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	myinfo
	dc.w	37		;eus_Kickstart
	dc.l	8		;eus_EPVersion (1.10)
	dc.w	1,2		;eus_version,revision
	dc.l	MyUsername	;eus_username
	dc.w	0		;eus_winx
	dc.w	74		;eus_winy
	dc.w	EUSB_openwin	;EUS_Flags, Window offen

				;EUS_Special
	dc.b	01		;Scroller on
	dc.b	$e2		;Mode
	dc.b	0		;Peek off
	dc.b	01		;Picture on
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3

	dc.b	3,4,19,94	;EUS_Creatordate
	dc.b	-5		;EUS_Priority
	dc.b	EUTY_Analyzer
	dc.w	0
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

		ifne	(*-begin)-EUS_SizeOF
		Aber Hallo
		endc


Tagliste:	*dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Analyzer
		*dc.l	EUT_AttnFlags,1<<6!1<<3
		dc.l	0


fangan
	move.l	4.w,a6

	lea	datas,a5
	move.l	a5,a0
	move.w	#dataslen-1,d0
.clr	clr.b	(a0)+
	dbf	d0,.clr

	bsr	setcon1
	
	if	points=1

	lea	nulls(a5),a0
	move.b	#$80,(a0)
	move.b	#1,27(a0)

	endc

	lea	almostfulls(a5),a0
	lea	fulls(a5),a1
	moveq	#6,d0			;7 Langwrter
.full
	move.l	#$fefefefe,(a0)+
	move.l	#-1,(a1)+
	dbf	d0,.full

	lea	begin(pc),a0
	move.l	EUS_EPBase(a0),a0
	lea	EPG_someprefs(a0),a0
	move.l	a0,flagsadr(A5)

	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;Signal allokieren
	tst.l	d0
	blt	NoSignal
	move.l	d0,mysignal(a5)

	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;2. Signal allokieren (fr Interrupt)
	tst.l	d0
	blt	NoSignal2
	move.l	d0,my2ndsignal(a5)

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)
	move.l	d0,mytask(a5)

	lea	begin(pc),a1
	move.l	eus_epbase(a1),a1

	move.l	dtg_dosbase(a1),d0
	beq	nodos
	move.l	d0,_dos(a5)

	move.l	4.w,a6
	cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
	blt	nodos			;ja->Weiter
	
	jsr	_LVOcreatemsgport(a6)	;Messageport auf die schnelle Art
	tst.l	d0
	beq	NoPort
	move.l	d0,MSGport(a5)


	lea	begin(pc),a1
	move.l	eus_epbase(a1),a1

	move.l	dtg_intuitionbase(a1),d0
	beq	nolib
	move.l	d0,intsave(a5)

	move.l	dtg_gfxbase(a1),d0
	beq	nolib
	move.l	d0,grafsave(a5)

	move.l	dtg_gadtoolsbase(a1),d0
	beq	nolib
	move.l	d0,gadsave(a5)

	moveq	#0,d7

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse haben mchte
	blt	endme	;Fehler aufgetreten

	bsr	HandleActions		;Auf Usereingaben reagieren
endme
	move.l	d7,-(sp)

	bsr	closewin

	bsr	Remint			;Interrupt sicherheitshalber killen
	move.l	(sp)+,d7

	blt.s	Ende	;kein Fehler,sondern Aufruf zum frhlichen ENDE
			;vom Eagleplayer erhalten

	bsr	Sendlastmessage	;einige letzte Worte,falls eigenmchtige Ver-
				;abschiedung (darf aber nicht auftreten
Ende
	move.l	mypubscreen(a5),d0
	beq.s	.ok
	move.l	d0,a1
	suba.l	a0,a0
	jsr	_LVOunlockpubscreen(a6)
.ok
nolib
	move.l	4.w,a6
	move.l	MSGport(a5),a0
	jsr	_LVOdeletemsgport(a6)
NoPort
nodos
	move.l	my2ndsignal(a5),d0
	move.l	4.w,a6
	jsr	_LVOfreesignal(a6)
NoSignal2
	move.l	mysignal(a5),d0
	move.l	4.w,a6
	jsr	_LVOfreesignal(a6)
NoSignal
	moveq	#0,d0
	rts
************************************************************************
*                   Fenster ffnen                                     *
************************************************************************
Openwin
	tst.l	winhandle(a5)
	bne.w	.Error

	move.l	intsave(a5),a6

	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep2
	move.l	d0,a0
	move.l	EPG_Pubscreen(a0),d0
	move.w	EPG_Wordreserved8(A0),word8(A5)
.noep2
	move.l	d0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	bne	.pubok

	suba.l	a0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	beq	.error

.pubok
	move.l	d0,mypubscreen(a5);fr UnLockpubscreen()
	move.l	d0,a1
	move.b	sc_wborleft(a1),d0
	ext.w	d0
	move.w	d0,offx(A5)
	
	move.l	sc_font(a1),a0
	move.l	a0,fontatt(a5)

	bsr	getwinheight		;in D1 Windowhhe

	movem.l	d0-d6/a0-a6,-(sp)
	bsr	makemenus		;Mens basteln
	movem.l	(sp)+,d0-d6/a0-a6
	tst.l	d7

	blt.w	.Error

	moveq	#0,d0
	lea	begin(pc),a0
	lea	mytags(a5),a1		;WINDOW INIT

	move.l	#WA_Pubscreen,(a1)+
	move.l	myPubscreen(a5),(a1)+

	move.l	#WA_Newlookmenus,(a1)+
	move.l	#1,(a1)+

	move.l	#wa_Pubscreenfallback,(A1)+
	move.l	#1,(a1)+

	move.l	#wa_top,(a1)+
	move.w	eus_winy(a0),d0
	move.l	d0,(a1)+
	move.l	#wa_left,(a1)+
	move.w	eus_winx(a0),d0
	move.l	d0,(a1)+
	move.l	#wa_innerwidth,(a1)+	;Breite
	move.l	#win_breite-6,(a1)+	;20Spalten+15*8Pixel fr Gadgets+Rand
	move.l	#wa_innerheight,(a1)+	;Hhe
	move.l	#AN_zeilen+20+14+4,(a1)+
	move.l	#wa_flags,(a1)+
	move.l	#Windowdrag!Windowdepth!Windowclose,(a1)+
	move.l	#WA_TITLE,(a1)+
	lea	mywinname(pc),a0
	move.l	a0,(a1)+
	move.l	#wa_zoom,(a1)+
	lea	myzoom(a5),a0
	move.w	#0,(a0)
	move.w	#112,2(a0)
	move.w	#168,4(a0)		;Breite des Zip-Windows im SMALL-MODE
	move.w	myhoehe1(a5),myhoehe2(a5)
	move.l	a0,(a1)+
	move.l	#wa_idcmp,(a1)+
 move.l	#closewindow!vanillakey!gadgetup!menupick!refreshwindow,(a1)+
	move.l	#wa_autoadjust,(a1)+
	move.l	#1,(a1)+
	move.l	#TAG_DONE,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)
	move.l	d0,Winhandle(a5)
	tst.l	d0
	bne.s	.winopened

	lea	mytags(a5),a1		;Fehler,nochmal auf Position 0/0
	move.l	#wa_top,(a1)+		;zu ffnen versuchen
	move.l	#0,(a1)+
	move.l	#wa_left,(a1)+
	move.l	#0,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;wirst DU wohl aufgehen !
	move.l	d0,Winhandle(a5)
	tst.l	d0

	beq.w	.Error
.winopened
	move.l	d0,a0
	move.l	wd_userport(a0),a0	;User Port
	move.l	a0,port(a5)

	lea	my_bitmap(a5),a3
	bsr	makebitmap
	bge	.bitm

	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	clr.l	Winhandle(a5)
	clr.l	port(a5)
	jsr	_LVOclosewindow(a6)
	bra	.error
.bitm
	bsr	addmenus		;Men darstellen
	bsr	addgads
	bsr	refresh
.error
	move.l	intsave(a5),a6
	suba.l	a0,a0
	move.l	mypubscreen(a5),d0
	beq.s	.nopub
	move.l	d0,a1
	move.l	#0,mypubscreen(a5)
	jmp	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.nopub	rts
*******************************************************************
*                   Window schlieen                              *
*******************************************************************
Closewin
	tst.l	winhandle(a5)
	beq.s	.nowin

	bsr	freebitmap
	bsr	remgads
	bsr	freemenus
	
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0

	move.w	myhoehe1(a5),d1		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d1
	beq	.noxy			;ja , x und y nicht merken
	lea	begin(pc),a1
	move.w	wd_leftedge(a0),eus_winx(a1)
	move.w	wd_topedge(a0),eus_winy(a1)
.noxy
	clr.l	Winhandle(a5)
	clr.l	port(a5)

	clr.w	scrolpos(a5)
	clr.w	scroloffset(a5)

	jsr	_LVOclosewindow(a6)
.nowin	rts
******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
;NUR ZU TESTZWECKEN,KEIN USERPROGRAMM SOLLTE SICH EIGENMCHTIG VERABSCHIEDEN,
;DA DER PLAYER SONST VERGEBLICH AUF DAS RCKSENDEN DER NACHRICHTEN WARTET
Sendlastmessage:
	move.l	4.w,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),a1
	move.l	a1,d3			;Messageport

	lea	Mymessage(a5),a1		;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)	;Lnge
	clr.l	ln_succ(A1)
	clr.l	ln_pred(A1)
	move.b	#nt_message,ln_type(a1) 	;Typ: Message
	lea	begin(pc),a2			;Zeiger auf Struktur am Anfang
	move.w	EUS_Usernr(A2),UM_UserNr(a1)	;Usernummer
	move.l	#USM_Userprg,UM_Type(a1)	;Typ der Message

	move.l	d3,mn_replyport(a1)		;Portadresse,an die
						;zurckgesendet wird
	clr.l	UM_Userport(a1)		;Portadresse fr EaglePlayer
	clr.l	UM_TaskAdr(a1)		;Taskadresse
	clr.l	UM_Signal(a1)		;Signalnummer
	move.w	#Usclass_exit,UM_class(a1)	;Messageinhalt
				;z.B. USClass_Closewin,USclass_Newuserprg

	move.b	#1,messagesent(a5)		;merken,da Nachricht gesendet

	move.l	4.w,a6
	jsr	_LVOputmsg(a6)		;Nachricht losschicken
.wait					;auf Rckmeldung warten
	move.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	move.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
********************************************************************
*                  Init Message Struktur                           *
********************************************************************
Sendfirstmessage
	move.l	4.w,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	bne.s	.ok

	bsr	openwin
	lea	NoportMessage(pc),a0
	lea	my_easystruct(a5),a1
	move.l	a0,es_textformat(a1)
	lea	my_easygadget2(pc),a0
	move.l	a0,es_gadgetformat(a1)
	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),d0	;*Window
	beq.s	.error	;kann kein Window ffnen
	move.l	d0,a0
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	tst.l	d0
	beq.s	.error
	bra	SendFirstmessage
.ok
	move.l	d0,a0			;Portadresse

	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	mysignal(a5),d5
	move.w	#USclass_Newuserprg,d6

	bsr	sendmess

	moveq	#0,d7
	rts
.error
	moveq	#-1,d7
	rts
*******************************************************************************
sendmess:
	lea	Mymessage(a5),a1	;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	clr.l	ln_pred(a1)
	clr.l	ln_succ(a1)
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	move.l	#USM_USERPRG,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.b	#1,messagesent(a5)

	move.l	4.w,a6
	jmp	_LVOputmsg(a6)
******************************************************************************
*                        Gadgets anhngen                                    *
******************************************************************************
Addgads
	lea	Gadmode0(pc),a1		;Gadget-TopEdge an Windowtitelleiste
	lea	GLefts(pc),a3

	move.w	myhoehe1(a5),d0		;anpassen
	add.w	#10+weiterrunter,d0
.loop
	move.w	(A3)+,d1
	add.w	offx(a5),d1
	move.w	d1,gg_leftedge(a1)

	move.w	d0,gg_topedge(a1)
	move.l	(a1),d1
	beq.s	.endlist
	move.l	d1,a1
	bra.s	.loop
.endlist
	lea	Gadmode6(pc),a1
	clr.l	(a1)
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	lea	Gadmode0(pc),a1
	moveq	#0,d0
	moveq	#-1,d1
	moveq	#0,d2
	jsr	_LVOaddglist(a6)

	lea	Gadmode0(pc),a0
	move.l	winhandle(a5),a1
	suba.l	a2,a2
	moveq	#-1,d0
	jmp	_LVOrefreshglist(a6)
******************************************************************************
*                        Gadgets entfernen                                   *
******************************************************************************
RemGads
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	lea	Gadmode0(pc),a1
	moveq	#-1,d0
	jmp	_LVOremoveglist(a6)
*******************************************************************************
*                        Mens erstellen                                      *
*******************************************************************************
MakeMenus
	move.l	gadsave(a5),A6

	move.l	mypubscreen(a5),a0
	suba.l	a1,a1
	jsr	_LVOgetvisualinfoa(a6)	;Visual Info vom Screen anfordern
	move.l	d0,vi(a5)
	tst.l	d0
	beq	.nomen

	lea	mymenus(A5),a0
	move.b	#nm_title,gnm_type(a0)
	lea	mylabel1(pc),a1
	move.l	a1,gnm_Label(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof(a0)
	lea	mylabel2(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof(a0)
	lea	MYCOMM2(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof(a0)
	move.w	#commseq,gnm_Flags+gnm_sizeof(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*2(a0)
	lea	mylabel3(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*2(a0)
	lea	MYCOMM3(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*2(a0)
	move.w	#commseq,gnm_Flags+gnm_sizeof*2(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*3(a0)
	lea	mylabel5(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*3(a0)
	lea	MYCOMM5(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*3(a0)
	tst.w	scrolmerk(a5)
	bne.s	.other
	move.w	#checkit!checked!menutoggle,gnm_Flags+gnm_sizeof*3(a0)
	bra.s	.this
.other
	move.w	#checkit!menutoggle,gnm_Flags+gnm_sizeof*3(a0)
.this
	move.b	#nm_item,gnm_type+gnm_sizeof*4(a0)
	lea	mylabel6(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*4(a0)
	lea	MYCOMM6(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*4(a0)
	tst.w	picmerk(a5)
	bne.s	.other2
	move.w	#checkit!checked!menutoggle,gnm_Flags+gnm_sizeof*4(a0)
	bra.s	.this2
.other2
	move.w	#checkit!menutoggle,gnm_Flags+gnm_sizeof*4(a0)
.this2
	move.b	#nm_item,gnm_type+gnm_sizeof*5(a0)
	lea	myhidelabel(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*5(a0)
	lea	myhidecomm(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*5(a0)
	move.w	#commseq,gnm_Flags+gnm_sizeof*5(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*6(a0)
	lea	mylabel4(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*6(a0)
	lea	MYCOMM4(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*6(a0)
	move.w	#commseq,gnm_Flags+gnm_sizeof*6(a0)

	move.b	#nm_end,gnm_type+gnm_sizeof*7(a0)

	lea	mymenus(A5),a0
	move.l	gadsave(a5),a6
	lea	mytags(a5),a1
	move.l	#gtmn_fullmenu,(a1)+
	move.l	#1,(a1)+
	move.l	#GTMN_Newlookmenus,(A1)+
	move.l	#1,(a1)+
	move.l	#tag_done,(a1)+
	lea	mytags(a5),a1
	jsr	_LVOcreatemenusA(a6)
	move.l	d0,menuadr(a5)
	tst.l	d0
	beq.s	.nomen
	move.l	d0,a0
	move.l	vi(a5),a1
	lea	mytags(a5),a2
	move.l	#GTMN_Newlookmenus,(A2)+
	move.l	#1,(a2)+
	move.l	#tag_done,(a2)+
	lea	mytags(a5),a2
	jsr	_LVOLayoutMenusA(a6)
	tst.l	d0
	beq.s	.free
	
	moveq	#0,d7
	rts
.free
	move.l	menuadr(a5),a0
	jsr	_LVOfreemenus(a6)
.nomen
	moveq	#-1,d7
	rts
********************* Visual Info Freigeben ***********************************
Freevi:
	move.l	vi(a5),a0
	jmp	_LVOfreevisualinfo(a6)
*********************** Men wechschmeisen ************************************
Freemenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	jsr	_LVOclearmenustrip(A6)
	
	move.l	gadsave(a5),a6
	move.l	Menuadr(a5),d0
	beq.s	.end
	move.l	d0,a0
	jmp	_LVOfreemenus(a6)
.end
	bsr	Freevi	;Visual Info Wegschmeien
	rts
*****************************************************************************
* Hhe des Hauptfensters berechnen unter Anpassung an den eingestellten Font*
*****************************************************************************
getwinheight:
	move.w	ta_ysize(a0),d0		;Hhe des Screenfonts
	move.w	d0,d1
	move.w	d0,fonth(a5)
	move.b	sc_wbortop(a1),d0
	ext.w	d0
	add.w	d0,d1			;Berechnen der Gre fr ZIPwindow()
	move.w	d1,myhoehe1(a5)
	
	add.w	#AN_zeilen+20+14+7,d1	;32 Y-Stufen des Analyzers (2-zeilig)
					;+ Rand
	rts

********************* Men anhngen *************************

Addmenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	move.l	Menuadr(a5),a1
	jmp	_LVOsetmenustrip(a6)

*************************************************************
*Simuliert Herunterdrcken des Buttons =optische Quittierung*
* Input: A0-Gadgetadresse                                   *
*************************************************************
_Blinkbutton
	or.w	#GFLG_selected,gg_flags(a0)
	move.l	winhandle(a5),a1
	suba.l	a2,a2
	moveq	#1,d0
	move.l	intsave(a5),a6
	move.l	a0,-(SP)
	jsr	_LVOrefreshglist(a6)

	move.l	_dos(a5),a6
	moveq	#5,d1
	jsr	_LVOdelay(a6)

	move.l	(SP)+,a0
	and.w	#~GFLG_selected,gg_flags(a0)
	move.l	winhandle(a5),a1
	suba.l	a2,a2
	moveq	#1,d0
	move.l	intsave(a5),a6
	jsr	_LVOrefreshglist(a6)
	rts
*************************************************************
*     2. Bitmap erzeugen fr direkten Zugriff auf Bild      *
*       (per Blitter wird kopiert,Tiefe = 1)                *
*************************************************************
makebitmap
	move.l	grafsave(a5),a6

	move.w	#an_num,(a3)	;bm_BytesPerRow
	move.w	#an_zeilen+extra_place,bm_rows(a3)	;64 Zeilen +36 fr den Scroller

	cmp.b	#$e3,an_modenr(a5)
	beq.s	.modee3
	cmp.b	#6,an_modenr(a5)
	blt.s	.nomode6
.modee3
	move.b	#2,bm_depth(a3)
	bra.s	.wei
.nomode6
	move.b	#1,bm_depth(a3)		;auf 1 lassen (2 Bitplanes nur fr
					;Balken-Modus)
.wei
	move.w	#an_num*8,d0
	move.w	#[an_zeilen+extra_place]*8,d1	;36 Extra Zeilen
	jsr	_LVOallocraster(a6)
	tst.l	d0
	beq.s	.norast2
	move.l	d0,bm_planes(a3)

	move.l	d0,a0
	move.w	#an_num*[an_zeilen+extra_place]-1,d0 ;*8
.clr1
	clr.b	(a0)+
	dbf	d0,.clr1

; 2.Bitplane
	move.w	#an_num*8,d0
	move.w	#an_zeilen*8,d1
	jsr	_LVOallocraster(a6)
	tst.l	d0
	beq.s	.norast
	move.l	d0,bm_planes+4(a3)	;Planeptr[2]
	move.l	d0,a0

	move.w	#an_num*an_zeilen-1,d0		;*8
.clr2
	clr.b	(a0)+
	dbf	d0,.clr2

	moveq	#0,d7
	rts
.norast
	move.l	grafsave(a5),a6
	lea	my_bitmap(a5),a1
	move.l	bm_planes(a1),a0	;Planeptr[1]
	clr.l	bm_planes(a1)
	move.w	#an_num*8,d0
	move.w	#[an_zeilen+extra_place]*8,d1
	jsr	_LVOfreeraster(a6)		
	clr.l	bm_planes(a3)
.norast2
	moveq	#-1,d7
	rts
************** Setzt Scroller ein/aus bzw. Modi/Spitzenpegelmodus ************
setcon1
	moveq	#0,d0
	lea	begin(pc),a0
	move.b	EUS_special+0(a0),d0	;Scroller on/off
	seq	d0
	move.w	d0,scrolmerk(a5)

	move.b	EUS_special+3(a0),d0	;Bild an/aus
	seq	d0
	move.w	d0,picmerk(a5)

	move.b	EUS_special+2(a0),d1
	cmp.b	#2,d1
	bls.s	.pk_ok
	moveq	#0,d1
.pk_ok
	move.b	EUS_special+1(a0),d0
	tst.b	d0
	beq.s	.mo_ok1		;Mode0 (von oben nach unten)
	cmp.b	#3,d0
	beq.s	.mo_ok1		;Mode3 (wie0,unausgefllt)

	and.b	#1,d1

	cmp.b	#3,d0
	bls.s	.mo_ok1
	moveq	#0,d1
	cmp.b	#7,d0
	bls.s	.mo_ok1

	cmp.b	#$ef,d0
	beq.s	.mo_ok1

	cmp.b	#$f0,d0
	beq.s	.mo_ok1

	cmp.b	#$f1,d0
	beq.s	.mo_ok1

	cmp.b	#$e2,d0
	beq.s	.mo_ok1
	cmp.b	#$e3,d0
	beq.s	.mo_ok1
	cmp.b	#$e4,d0
	beq.s	.mo_ok1
	cmp.b	#$e5,d0
	beq.s	.mo_ok1

	moveq	#1,d0
.mo_ok1
	move.b	d0,an_modenr(a5)
	move.b	d1,an_peekaha(a5)
	rts
**************************************************************
*                   Bitplane(s) freigeben                    *
**************************************************************
freebitmap
	move.l	grafsave(a5),a6
	lea	my_bitmap(a5),a1
	move.l	bm_planes(a1),d0	;Planeptr[1]
	beq.s	.no1
	move.l	d0,a0
	move.w	#an_num*8,d0
	move.w	#[an_zeilen+extra_place]*8,d1
	jsr	_LVOfreeraster(a6)		
	lea	my_bitmap(a5),a1
	clr.l	bm_planes(a1)
.no1
	lea	my_bitmap(a5),a1
	move.l	bm_planes+4(a1),d0	;Planeptr[2]
	beq.s	.no2
	move.l	d0,a0
	move.w	#an_num*8,d0
	move.w	#an_zeilen*8,d1
	jsr	_LVOfreeraster(a6)
	lea	my_bitmap(a5),a1
	clr.l	bm_planes+4(a1)
.no2
	rts
*************************************************************
*           Windowrefresh und Detaildarstellung             *
*************************************************************
Refresh
	move.l	winhandle(a5),d0
	beq	.rts
	move.l	d0,a0

;	move.w	myhoehe1(a5),d1		;Window im ZIP-Modus ?
;	cmp.w	wd_height(a0),d1
;	bne.s	.ref			;ja,kein Refresh
;	move.l	a0,-(sp)
;	moveq	#1,d1
;	move.l	_Dos(a5),a6
;	jsr	_LVODelay(a6)
;	move.l	a0,(sp)+

	move.w	myhoehe1(a5),d1		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d1
	beq	.rts			;ja,kein Refresh
;.ref
	move.l	grafsave(a5),a6
	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0
	jsr	_LVOsetapen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	move.b	#1,rp_areaptsz(a1)
	lea	patt1(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	offx(a5),d0		;x1
	move.w	myhoehe1(A5),d1		;y1
	move.w	#win_breite-6,d2	;x2
	add.w	d0,d2
	move.w	#AN_zeilen+20+14+7-3,d3	;y2
	add.w	d1,d3
	movem.l	d4-d5,-(sp)
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	lea	patt2(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	offx(A5),d0
	add.w	#5,d0			 ;Left
	move.w	myhoehe1(a5),d1		;Top
	add.w	#7+weiterrunter,d1
	move.w	#239,d2
	move.w	#20,d3
	add.w	d0,d2
	add.w	d1,d3
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	move.w	offx(A5),d0
	add.w	#4,d0 ;Left
	move.w	myhoehe1(a5),d1	;Top
	add.w	#6,d1
	move.w	#[an_num+2]*8,d2
	move.w	#an_zeilen+4,d3
	add.w	d0,d2
	add.w	d1,d3
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	move.w	#3+8,d0
	move.w	myhoehe1(A5),d1		;y1
	addq.w	#4,d1
	jsr	_LVOmove(A6)

	movem.l	(Sp)+,d4-d5

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	move.b	d4,rp_areaptsz(a1)
	move.l	d5,rp_areaptrn(a1)

	move.l	gadsave(a5),a6

	move.l	winhandle(a5),a0
	move.l	wd_rport(a0),a0
	lea	mytags(a5),a3
	move.l	#GT_Visualinfo,(a3)+
	move.l	vi(a5),(a3)+
	move.l	#tag_done,(a3)+
	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
	move.l	a3,a1			;!!!!!
	move.w	offx(a5),d0
	add.w	#7,d0 ;Left
	move.w	myhoehe1(a5),d1	;Top
	add.w	#8+weiterrunter,d1
	move.w	#235,d2
	move.w	#18,d3
	jsr	_LVOdrawbevelboxa(a6)

	move.l	winhandle(a5),a0
	move.l	wd_rport(a0),a0
	lea	mytags(a5),a3
	move.l	#GT_Visualinfo,(a3)+
	move.l	vi(a5),(a3)+
	move.l	#GTBB_recessed,(a3)+
	move.l	#1,(a3)+
	move.l	#tag_done,(a3)+
	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
	move.l	a3,a1			;!!!!!
	move.w	offx(a5),d0
	add.w	#5,d0 ;Left
	move.w	myhoehe1(a5),d1	;Top
	add.w	#7+weiterrunter,d1
	move.w	#239,d2
	move.w	#20,d3
	jsr	_LVOdrawbevelboxa(a6)

;	move.l	winhandle(a5),a0
;	move.l	wd_rport(a0),a0
;	lea	mytags(a5),a3
;	move.l	#GT_Visualinfo,(a3)+
;	move.l	vi(a5),(a3)+
;	move.l	#tag_done,(a3)+
;	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
;	move.l	a3,a1			;!!!!!
;	move.w	#145,d0 ;Left
;	move.w	myhoehe1(a5),d1	;Top
;	add.w	#8+weiterrunter,d1
;	move.w	#106,d2
;	move.w	#18,d3
;	jsr	_LVOdrawbevelboxa(a6)

;	move.l	winhandle(a5),a0
;	move.l	wd_rport(a0),a0
;	lea	mytags(a5),a3
;	move.l	#GT_Visualinfo,(a3)+
;	move.l	vi(a5),(a3)+
;	move.l	#GTBB_recessed,(a3)+
;	move.l	#1,(a3)+
;	move.l	#tag_done,(a3)+
;	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
;	move.l	a3,a1			;!!!!!
;	move.w	#146,d0 ;Left
;	move.w	myhoehe1(a5),d1	;Top
;	add.w	#9+weiterrunter,d1
;	move.w	#104,d2
;	move.w	#16,d3
;	jsr	_LVOdrawbevelboxa(a6)

	move.l	winhandle(a5),a0
	move.l	wd_rport(a0),a0
	lea	mytags(a5),a3
	move.l	#GT_Visualinfo,(a3)+
	move.l	vi(a5),(a3)+
	move.l	#GTBB_recessed,(a3)+
	move.l	#1,(a3)+
	move.l	#tag_done,(a3)+
	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
	move.l	a3,a1
	move.w	offx(A5),d0
	add.w	#4,d0 ;Left
	move.w	myhoehe1(a5),d1	;Top
	add.w	#5,d1			;6
	move.w	#[an_num+2]*8,d2
	move.w	#an_zeilen+6,d3		;4
	jsr	_LVOdrawbevelboxa(a6)

	move.l	winhandle(a5),a0
	move.l	wd_rport(a0),a0
	lea	mytags(a5),a3
	move.l	#GT_Visualinfo,(a3)+
	move.l	vi(a5),(a3)+
	move.l	#tag_done,(a3)+
	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
	move.l	a3,a1
	move.w	offx(a5),d0
	add.w	#6,d0 ;Left
	move.w	myhoehe1(a5),d1	;Top
	add.w	#6,d1
	move.w	#[an_num+2]*8-3,d2
	move.w	#an_zeilen+4,d3
	jsr	_LVOdrawbevelboxa(a6)

	move.l	intsave(a5),a6
	lea	Gadmode0(pc),a0
	move.l	winhandle(a5),a1
	suba.l	a2,a2
	moveq	#-1,d0
	jsr	_LVOrefreshglist(a6)

	move.l	winhandle(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOrefreshwindowframe(A6)

	move.l	an_structadr(a5),d0
	tst.l	an_structadr(a5)
	beq	setpic
.rts	rts
***************************************************************
* ANALYZER , berechnet Positionen,zeichnet ein und stellt dar *
* 1. Variante,(von unten nach oben wachsend)                  *
***************************************************************
Analyze1
;=============== Kanle auswerten ============================================
	cmp.b	#6,an_modenr(a5)
	blt.s	.nomode6
;== Fr Modus 6 Bitplanes per Blitter lschen,nebenbei Analyzerwerte kpoieren =
	lea.l	my_bitmap(a5),a0
	move.l	bm_planes(a0),a4	;1.Bitplane
	move.l	bm_planes+4(a0),a2	;2.Bitplane
	move.l	grafsave(a5),a6
	move.l	a2,a1
	move.l	#an_num*an_zeilen,d0
	moveq	#0,d1
	jsr	_LVOBltclear(a6)
	move.l	a4,a1
	move.l	#an_num*an_zeilen,d0
	moveq	#0,d1
	jsr	_LVOBltclear(a6)
.nomode6
	lea	begin(pc),a3
	move.l	EUS_EPbase(A3),a3
	lea	EPG_Voice1Vol(a3),a3
	
	lea	anmerk(a5),a1	;Merkliste fr die Werte
	moveq	#3,d3	;4 Kanle
	lea	AN_Struct(a5),a0;Analyzer Struktur

	moveq	#-1,d5
	move.w	ups_flags(a0),d1
	and.w	#UPSB_Dmacon,d1			;Flag ob Kanle an/aus ?
	beq.s	.nodmacon
	move.w	UPS_Dmacon(a0),d5	;DMA Control Register
.nodmacon
anloo:
	move.l	#$358+$71,d2	;max. Wert der Sampleperiod + min. Wert

	asr.w	#1,d5	;einen Kanal rausrotieren
	bcc	.no	;wenn Bit nicht gesetzt,rausgehen
	tst.w	UPS_Voice1per(a0)
	beq.w	.no	;Sampleperiod=0->nichts Neues
	move.l	d2,d1
	sub.w	UPS_Voice1Per(a0),d1;Sampleperiod des jeweiligen Kanals
	bgt.s	.ok		;(je hher Period,desto tiefer der Ton)
	moveq	#0,d1	;gleich NULL (Tiefstpunkt)
.ok
	cmp.w	#$358,d1
	ble.s	.ok2
	move.w	#$358,d1
.ok2
	divu	#42,d1		;zwischen 0 und $358+$71 => 20 BALKEN
	asl.w	#1,d1		;mal 2 wegen Wortweiser Ablage
	move.w	UPS_Voice1Vol(a0),d0
	cmp.w	#64,d0
	blo.s	.mu_ok
	moveq	#64,d0
.mu_ok	lsr.w	#1,d0		;durch 2 wegen nur 32 Segmenten vertikal

	;****			Hier Abfrage auf Mastervolume	  ****
	;**** Bitte in Zukunft (!) EPG_Voice1-EPG_Voice4 benutzen ****

	move.l	flagsadr(A5),a2
	move.l	(a2),d6
	and.l	#EGPRB_MasterVolume,d6
	beq.s	.NoMaster

	mulu	(a3)+,d0
	lsr.w	#6,d0

.NoMaster:

	move.w	d1,d6

	cmp.b	#$e4,an_modenr(a5)
	beq.s	.schmal
	cmp.b	#$e5,an_modenr(a5)
	beq.w	.sehrschmal
	
	moveq	#15,d7
	moveq	#2,d2
	cmp.b	#$e3,an_modenr(a5)
	beq.s	.verybreitbalken

	cmp.b	#$f0,an_modenr(a5)
	blo.s	.breitbalken
.schmal
	moveq	#2,d7

	cmp.w	(a1,d1.w),d0	;neuer Wert grer als der alte ?
	ble.w	.nocc11
	move.w	d0,(a1,d1.w)
.nocc11
	subq.w	#8,d0
	bge.s	.noblt1
	moveq	#0,d0
.noblt1
	subq.w	#2,d1
	addq.w	#2,d6

	cmp.w	(a1,d1.w),d0	;Links davon weitermachen
	ble.w	.nocc21
	move.w	d0,(a1,d1.w)
.nocc21
	cmp.w	(a1,d6.w),d0	;Rechts davon weitermachen
	ble.w	.nocc31
	move.w	d0,(a1,d6.w)
.nocc31
	dbf	d7,.nocc11
	bra.s	.no
.breitbalken
	moveq	#5,d7
	moveq	#4,d2
.verybreitbalken
	cmp.w	(a1,d1.w),d0	;neuer Wert grer als der alte ?
	ble.w	.nocc1
	move.w	d0,(a1,d1.w)
.nocc1
	sub.w	d2,d0
	bge.s	.noblt
	moveq	#0,d0
.noblt
	subq.w	#2,d1
	addq.w	#2,d6

	cmp.w	(a1,d1.w),d0	;Links davon weitermachen
	ble.w	.nocc2
	move.w	d0,(a1,d1.w)
.nocc2
	cmp.w	(a1,d6.w),d0	;Rechts davon weitermachen
	ble.w	.nocc3
	move.w	d0,(a1,d6.w)
.nocc3
	dbf	d7,.nocc1
	bra.s	.no
.sehrschmal
	moveq	#2,d7
	cmp.w	(a1,d1.w),d0	;neuer Wert grer als der alte ?
	ble.w	.nocd1
	move.w	d0,(a1,d1.w)
.nocd1
	lsr.w	#1,d0
	subq.w	#2,d1
	addq.w	#2,d6

	cmp.w	(a1,d1.w),d0	;Links davon weitermachen
	ble.w	.nocd2
	move.w	d0,(a1,d1.w)
.nocd2
	cmp.w	(a1,d6.w),d0	;Rechts davon weitermachen
	ble.w	.nocd3
	move.w	d0,(a1,d6.w)
.nocd3
	dbf	d7,.nocd1
	bra.w	.no
.no
	move.w	#0,UPS_Voice1Vol(a0);bernommene Werte lschen,damit Doppelaus-
	move.w	#0,UPS_Voice1Per(a0);wertung entfllt

	add.l	#UPS_Modulo,a0	;nchsten Kanal
	dbf	d3,anloo

	cmp.b	#6,an_modenr(a5)
	beq	.domode6
	cmp.b	#7,an_modenr(a5)
	beq	.domode7
	cmp.b	#$e2,an_modenr(a5)
	beq	.domodeE2
	cmp.b	#$e4,an_modenr(a5)
	beq	.domodeE4
	cmp.b	#$e3,an_modenr(a5)
	beq	.domodeE3
	cmp.b	#$e5,an_modenr(a5)
	beq	.domodeE5
;====================== Bereich lschen ===================================
	if	an_num=28
;=============== Schnelle Lschroutine ==============================

	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row
	move.l	bm_planes(a0),a0	;1.Bitplane

	lea	Nulls(a5),a2
	movem.l	(a2),d1-d7
	add.w	d0,d0

	rept	an_zeilen/2
	movem.l	d1-d7,(a0)
	add.l	d0,a0
	endr

	else
;============== Normale Lschroutine ===========================
	lea.l	my_bitmap(a5),a0
	move.l	bm_planes(a0),a1	;1.Bitplane
	moveq	#0,d2
	move.w	(a0),d2			;Bytes per Row

	add.w	d2,d2		;mal 2

	moveq	#32-1,d4
	moveq	#0,d1
.loesch2
	move.l	a1,a2

	rept	an_num		;an_num mal den Befehl move.b d1,(a2)+ einfgen
	move.b	d1,(a2)+
	endr

	add.l	d2,a1
	dbf	d4,.loesch2

	endc
;============ Darstellen der Analyzerwerte =================================
	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row
	add.w	d0,d0			;mal 2,damit Zeile bersprungen wird
	move.l	bm_planes(a0),a0	;1.Bitplane

	move.w	d0,d1			;auf letzte Zeile setzen
	mulu	#an_zeilen/2-1,d1

	move.b	an_modenr(a5),d2
	beq.s	.updown			;Modus 0
	cmp.b	#$f0,d2
	beq.s	.main_ok
	cmp.b	#$f1,d2
	beq.s	.updown
	cmp.b	#5,d2
	beq.w	.DoMode5
	cmp.b	#$ef,d2
	beq	.domodeef
	cmp.b	#4,d2
	beq.w	.DoMode4

	cmp.b	#3,d2
	bne.s	.main_ok
.updown					;Modus 0 und 3 -> Analyzer von oben nach
					;unten
	moveq	#0,d1
	neg.l	d0
.main_ok
	add.l	d1,a0
	lea	anmerk(a5),a1		;Analyzer-Werte
	
	moveq	#an_num-1,d7		;Schleifenzhler Balkenanzahl
	
	cmp.b	#1,d2			;====== Modus 2 oder hher ? ==========
	bgt.w	.domode23
;================== Modus 0 und 1==============================================
.mainloop
	move.l	a0,a2

	move.w	(a1),d2
	subq.w	#1,d2			;"Zurckwandern" des Ausschlags
	bge.s	.nokleiner
	moveq	#0,d2
.nokleiner
	move.w	d2,(a1)+
.mainloop2
	move.b	#$fe,(a2)
	sub.l	d0,a2
	dbf	d2,.mainloop2

	addq.l	#1,a0
	dbf	d7,.mainloop
	bra	.copybitmap
;============= Modus 6 (Balkenmodus) ========================================
.domode6
	lea.l	my_bitmap(a5),a0
	move.w	(a0),d0
	move.l	bm_planes(a0),a4	;1.Bitplane
	move.l	bm_planes+4(a0),a2	;2.Bitplane
	lea	anmerk(a5),a1		;Analyzer-Werte
	move.w	d0,d1
	mulu	#an_zeilen-1,d1
	add.l	d1,a4
	add.l	d1,a2
	moveq	#an_num/2-1,d7		;Schleifenzhler Balkenanzahl

	move.l	grafsave(a5),a6		;Falls Blitter noch am Lschen
	jsr	_LVOwaitblit(A6)	;ist,warten (bei unausgelastetem
					;System garantiert der Fall)
	move.l	a5,-(sp)
.6mainloop
	move.l	a4,a3
	move.l	a2,a5

	move.w	(a1),d2
	subq.w	#1,d2			;"Zurckwandern" des Ausschlags
	bge.s	.6nokleiner
	addq.l	#2,a1
	bra.s	.skip61
.6nokleiner
	move.w	d2,(a1)+
.skip61
	move.w	(a1),d3
	subq.w	#1,d3
	bge.s	.6nokleiner2
	addq.l	#2,a1
	bra.s	.skip62
.6nokleiner2
	move.w	d3,(a1)+
.skip62
	add.w	d3,d2
	blt	.skip6
.6mainloop2
	move.w	#$7fff,(a3)
	move.w	#$fffe,(a5)
	sub.l	d0,a3
	sub.l	d0,a5
	dbf	d2,.6mainloop2
.skip6
	addq.l	#2,a4
	addq.l	#2,a2
	dbf	d7,.6mainloop
	move.l	(sp)+,a5
	bra	.copybitmap
;============= Modus 7 (wie Modus6,nur schmalere Balken) ==============
.domode7
	lea.l	my_bitmap(a5),a0
	move.w	(a0),d0
	move.l	bm_planes(a0),a4	;1.Bitplane
	move.l	bm_planes+4(a0),a2	;2.Bitplane
	lea	anmerk(a5),a1		;Analyzer-Werte
	move.w	d0,d1
	mulu	#an_zeilen-1,d1
	add.l	d1,a4
	add.l	d1,a2
	moveq	#an_num-1,d7		;Schleifenzhler Balkenanzahl

	move.l	grafsave(a5),a6		;Falls Blitter noch am Lschen
	jsr	_LVOwaitblit(A6)	;ist,warten (bei unausgelastetem
					;System garantiert der Fall)
	move.l	a5,-(sp)
.7mainloop
	move.l	a4,a3
	move.l	a2,a5

	move.w	(a1),d2
	subq.w	#1,d2			;"Zurckwandern" des Ausschlags
	bge.s	.7nokleiner
	addq.l	#2,a1
	bra.s	.skip7
.7nokleiner
	move.w	d2,(a1)+
	asl.w	#1,d2
.7mainloop2
	move.b	#$7f,(a3)
	move.b	#$fe,(a5)
	sub.l	d0,a3
	sub.l	d0,a5
	dbf	d2,.7mainloop2
.skip7
	addq.l	#1,a4
	addq.l	#1,a2
	dbf	d7,.7mainloop
	move.l	(sp)+,a5
	bra	.copybitmap
;===== Modus E5,dem Intuitracker nachempfunden =========================
.domodee5
	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row

	move.l	bm_planes+4(a0),a1	;2.Bitplane
	move.l	bm_planes(a0),a0	;1.Bitplane
	add.w	d0,d0
	move.w	d0,d1
	mulu	#an_zeilen/2-1,d1
	add.l	d1,a1

	lea	RealNulls(a5),a2	;1. Bitplane leer
	movem.l	(a2),d1-d7
	
	rept	an_zeilen/2
	movem.l	d1-d7,(a0)
	add.l	d0,a0
	endr

	lea	Fulls(a5),a2		;2. Bitplane fllen (wei)
	movem.l	(a2),d1-d7
	rept	an_zeilen
	movem.l	d1-d7,-(a1)
	endr

	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row
	move.l	bm_planes+4(a0),a1	;2.Bitplane
	move.l	bm_planes(a0),a0	;1.Bitplane
	add.w	d0,d0
	move.w	d0,d1			;auf letzte Zeile setzen
	mulu	#an_zeilen/2-1,d1
	add.l	d1,a0
	add.l	d1,a1
	moveq	#an_num-1,d7

	lea	anmerk(a5),a3		;Analyzer-Werte
.mainloope5
	move.l	a1,a4
	move.l	a0,a2

	move.w	(a3),d2
	subq.w	#1,d2			;"Zurckwandern" des Ausschlags
	bge.s	.nokleinere5
	moveq	#0,d2
.nokleinere5
	move.w	d2,(a3)+
	move.w	d2,d1
	addq.w	#1,d1
	cmp.w	#26,d1
	blo.s	.mainloop2e5
	moveq	#26,d1
.mainloop2e5
	subq.w	#1,d1
	blt.w	.noE5
	clr.b	(a4)
.noE5
	move.b	#$fe,(a2)
	sub.l	d0,a2
	sub.l	d0,a4
	dbf	d2,.mainloop2e5

	addq.l	#1,a0
	addq.l	#1,a1
	dbf	d7,.mainloope5
	bra	.copybitmap

;==== Modus E3,weier sehr breiter Balken auf schwarzem Hintergrund ====
.domodeE3
;================== Schnelle Lschroutine ==============================
	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row

	move.l	bm_planes+4(a0),a1	;2.Bitplane
	move.l	bm_planes(a0),a0	;1.Bitplane
	add.w	d0,d0

	lea	almostFulls(a5),a2		;1. Bitplane fllen
	movem.l	(a2),d1-d7
	
	rept	an_zeilen/2
	movem.l	d1-d7,(a0)
	add.l	d0,a0
	endr

	lea	RealNulls(a5),a2	;2. Bitplane leer
	movem.l	(a2),d1-d7

	rept	an_zeilen/2
	movem.l	d1-d7,(a1)
	add.l	d0,a1
	endr

	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row
	move.l	bm_planes+4(a0),a1	;2.Bitplane
	move.l	bm_planes(a0),a0	;1.Bitplane
	add.w	d0,d0
	move.w	d0,d1			;auf letzte Zeile setzen
	mulu	#an_zeilen/2-1,d1
	add.l	d1,a0
	add.l	d1,a1
	moveq	#an_num-1,d7

	lea	anmerk(a5),a3		;Analyzer-Werte
.mainloope3
	move.l	a1,a4
	move.l	a0,a2

	move.w	(a3),d2
	subq.w	#1,d2			;"Zurckwandern" des Ausschlags
	bge.s	.nokleinere3
	moveq	#0,d2
.nokleinere3
	move.w	d2,(a3)+
.mainloop2e3
	clr.b	(a2)
	move.b	#$fe,(a4)
	sub.l	d0,a2
	sub.l	d0,a4
	dbf	d2,.mainloop2e3

	addq.l	#1,a0
	addq.l	#1,a1
	dbf	d7,.mainloope3
	bra	.copybitmap
;====================== Modus 2 und 3,unausgefllt ==========================
.domode23

.mode23loop
	move.l	a0,a2

	move.w	(a1),d2
	subq.w	#1,d2			;"Zurckwandern" des Ausschlags
	bge.s	.nokleiner23
	moveq	#0,d2
.nokleiner23
	move.w	d2,(a1)+
	mulu	d0,d2
	ext.l	d2
	sub.l	d2,a2
	move.b	#$fe,(a2)

	addq.l	#1,a0
	dbf	d7,.mode23loop
	bra	.copybitmap
;================ "Linien"-Modus nach oben und unten ======================
.domodee4
	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row

	move.l	bm_planes(a0),a0	;1.Bitplane
	move.w	d0,d0			;auf letzte Zeile setzen
	mulu	#an_zeilen,d0
	add.l	d0,a0

	lea	RealNulls(a5),a2
	movem.l	(a2),d1-d7

	rept	an_zeilen
	movem.l	d1-d7,-(a0)
	endr

	lea	deltas(pc),a3
	
	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row
	move.l	bm_planes(a0),a0	;1.Bitplane
	move.w	d0,d1			;auf letzte Zeile setzen
	mulu	#an_zeilen/2-1,d1
	add.l	d1,a0
	lea	anmerk(a5),a1		;Analyzer-Werte
	moveq	#an_num-2,d7		;Schleifenzhler Balkenanzahl
.modee4loop
	move.l	d0,d5
	move.l	a0,-(sp)

	move.l	a0,a2			;Adresse in der Bitmap

	move.w	(a1),d2			;Analyzerwert
	subq.w	#1,d2			;"Zurckwandern" des Ausschlags
	bge.s	.nokleinere4		;kleiner als 0 ?
	moveq	#0,d2			;ja,0 setzen
.nokleinere4
	move.w	d2,(a1)+		;merken
	move.w	d2,d3			;sichern
	move.w	(a1),d4
	subq.w	#1,d4			;"Zurckwandern" des Ausschlags
	bge.s	.nokleinere24		;kleiner als 0 ?
	moveq	#0,d4			;ja,0 setzen
.nokleinere24
	sub.w	d4,d3			;nchsten Wert,Delta berechnen
	bge.s	.E4_ok			;kleiner 0 ?
	neg.w	d3			;"positiv" machen
	neg.l	d5
.E4_ok
;	add.w	d3,d3		;mal 2 - weil Werte fr Halb so groe
;	add.w	d2,d2		;mal 2 - Analyzerhhe kalkuliert

	move.w	d3,d4			;sichern fr Schleifenzhler
;	subq.w	#1,d4			;minus 1 fr DBF-Schleife
	bge.s	.E4_ok2
	moveq	#0,d4
.E4_ok2
	lsl.w	#7,d3			;Delta mal 128 (64*2)
	lea	(a3,d3.w),a4

	mulu	d0,d2
	ext.l	d2
	sub.l	d2,a2
	add.l	d2,a0
.schleif4
	move.b	(a4)+,d3
	or.b	d3,(a2)
	or.b	d3,(a0)
	move.b	(a4)+,d3
	or.b	d3,1(a2)
	or.b	d3,1(a0)
	add.l	d5,a2
	sub.l	d5,a0
	dbf	d4,.schleif4

	move.l	(sp)+,a0
	addq.l	#1,a0
	dbf	d7,.modee4loop


	lea.l	my_bitmap(a5),a0
	move.w	(A0),d1
	move.l	bm_planes(a0),a0	;1.Bitplane
	mulu	#an_zeilen/2,d1
	add.l	d1,a0
	and.w	#$f,(a0)
	bra	.copybitmap
;=================== "Linien-Modus" =======================================
.domodee2
	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row

	move.l	bm_planes(a0),a0	;1.Bitplane
	move.w	d0,d0			;auf letzte Zeile setzen
	mulu	#an_zeilen,d0
	add.l	d0,a0

	lea	RealNulls(a5),a2
	movem.l	(a2),d1-d7

	rept	an_zeilen
	movem.l	d1-d7,-(a0)
	endr

	lea	deltas(pc),a3
	
	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row
	move.l	bm_planes(a0),a0	;1.Bitplane
	move.w	d0,d1			;auf letzte Zeile setzen
	mulu	#an_zeilen-1,d1
	add.l	d1,a0
	lea	anmerk(a5),a1		;Analyzer-Werte

	moveq	#an_num-2,d7		;Schleifenzhler Balkenanzahl
.modee2loop
	move.l	d0,d5

	move.l	a0,a2			;Adresse in der Bitmap

	move.w	(a1),d2			;Analyzerwert
	subq.w	#1,d2			;"Zurckwandern" des Ausschlags
	bge.s	.nokleinere2		;kleiner als 0 ?
	moveq	#0,d2			;ja,0 setzen
.nokleinere2
	move.w	d2,(a1)+		;merken
	move.w	d2,d3			;sichern
	move.w	(a1),d4
	subq.w	#1,d4			;"Zurckwandern" des Ausschlags
	bge.s	.nokleinere22		;kleiner als 0 ?
	moveq	#0,d4			;ja,0 setzen
.nokleinere22
	sub.w	d4,d3			;nchsten Wert,Delta berechnen
	bge.s	.E2_ok			;kleiner 0 ?
	neg.w	d3			;"positiv" machen
	neg.l	d5
.E2_ok
	add.w	d3,d3		;mal 2 - weil Werte fr Halb so groe
	add.w	d2,d2		;mal 2 - Analyzerhhe kalkuliert

	move.w	d3,d4			;sichern fr Schleifenzhler
;	subq.w	#1,d4			;minus 1 fr DBF-Schleife
	bge.s	.E2_ok2
	moveq	#0,d4
.E2_ok2
	lsl.w	#7,d3			;Delta mal 128 (64*2)
	lea	(a3,d3.w),a4

	mulu	d0,d2
	ext.l	d2
	sub.l	d2,a2
.schleif
	move.b	(a4)+,d3
	or.b	d3,(a2)
	move.b	(a4)+,d3
	or.b	d3,1(a2)
	add.l	d5,a2
	dbf	d4,.schleif

	addq.l	#1,a0
	dbf	d7,.modee2loop
	bra	.copybitmap
.domodeef
;=== Modus 5.2,Ausschlag nach unten und oben ohne Mittellinie ===============
	move.w	d0,d1
	mulu	#an_zeilen/4-1,d1	;auf Mitte setzen
	add.l	d1,a0
	lea	anmerk(a5),a1		;Analyzer-Werte
	moveq	#an_num-1,d7		;Schleifenzhler Balkenanzahl
.m5loop
	move.l	a0,a2
	move.l	a0,a3

	move.w	(a1),d2
	subq.w	#1,d2			;"Zurckwandern" des Ausschlags
	bge.s	.nokleiner5
	moveq	#0,d2
	addq.l	#2,a1			;\ falls Mittelstreifen her soll,
	bra.s	.skip5			;/ Zeilen wieder lschen
.nokleiner5
	move.w	d2,(a1)+
	asr.w	#1,d2
.m5loop2
	move.b	#$fe,(a2)
	move.b	#$fe,(a3)
	sub.l	d0,a2
	add.l	d0,a3
	dbf	d2,.m5loop2
.skip5
	addq.l	#1,a0
	dbf	d7,.m5loop

	bra	.copybitmap
;==========Modus 5,Ausschlag nach unten und oben =========================
.domode5
	move.w	d0,d1
	mulu	#an_zeilen/4-1,d1	;auf Mitte setzen
	add.l	d1,a0
	lea	anmerk(a5),a1		;Analyzer-Werte
	moveq	#an_num-1,d7		;Schleifenzhler Balkenanzahl
.m52loop
	move.l	a0,a2
	move.l	a0,a3

	move.w	(a1),d2
	subq.w	#1,d2			;"Zurckwandern" des Ausschlags
	bge.s	.nokleiner52
	moveq	#0,d2
.nokleiner52
	move.w	d2,(a1)+
	asr.w	#1,d2
.m52loop2
	move.b	#$fe,(a2)
	move.b	#$fe,(a3)
	sub.l	d0,a2
	add.l	d0,a3
	dbf	d2,.m52loop2

	addq.l	#1,a0
	dbf	d7,.m52loop

	bra	.copybitmap
;========== Ausschlag nach links und rechts ==============================
.domode4
	lea	anmerk(a5),a1	;Analyzer-Werte

	if	an_zeilen/2>an_num

	moveq	#[AN_Zeilen/2-an_num]/2,d1	;Falls Anzahl der Zeilen grer
	mulu	d0,d1				;als Anzahl der eigentlichen
	add.l	d1,a0				;Balken,auf Mitte zentrieren

	else

	if	an_zeilen/2<an_num

	lea	anmerk(a5),a1
	add.l	#[An_num-AN_Zeilen/2]/4*2,a1

	endc
	
	endc

	add.w	#an_num/2,a0			;Mitte des Feldes
	moveq	#an_num-1,d7		;Schleifenzhler Balkenanzahl
.doloop5
	move.l	a0,a2
	move.l	a0,a3
	move.w	(a1),d2
	subq.w	#1,d2
	bge.s	.m4loop
	addq.l	#2,a1
	bra.s	.skip4
.m4loop
	move.w	d2,(a1)+
	asr.w	#1,d2
	cmp.w	#an_num/2-1,d2
	ble.s	.m4loop2
	moveq	#an_num/2-1,d2
.m4loop2
	move.b	#$fe,-(a2)
	move.b	#$fe,(a3)+

	dbf	d2,.m4loop2
.skip4	
	add.l	d0,a0
	dbf	d7,.doloop5

.copybitmap
	tst.b	an_peekaha(a5)
	beq.w	.nopeek
	cmp.b	#2,an_peekaha(a5)
	bne	.peek1
;================= Spitzenpegelanzeige,nach unten abfallend  ================
	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row
	add.w	d0,d0			;mal 2,damit Zeile bersprungen wird
	move.l	bm_planes(a0),a0	;1.Bitplane

	move.w	d0,d1			;auf letzte Zeile setzen
	mulu	#an_zeilen/2-1,d1

	tst.b	an_modenr(a5)
	beq.s	.peek2_OK
	cmp.b	#3,an_modenr(A5)
	beq.s	.peek2_OK

	add.l	d1,a0
	neg.l	d0
.peek2_ok
	lea	anmerk(a5),a1
	lea	anpeek(a5),a2
	moveq	#an_num-1,d7		;Schleifenzhler Balkenanzahl
.peek2_loop
	move.w	(a2),d3
	move.w	(a1)+,d1
	bge.s	.oh2
	moveq	#0,d1
.oh2
	cmp.w	d1,d3		;alter Wert kleiner oder gleich dem neuen ?
	ble.s	.peek2_yes
	subq.w	#1,2(a2)		;Timeout fr Peek-Anzeige
	bge.s	.notnull2
	addq.w	#1,d3
	cmp.w	#an_zeilen/2,d3
	ble.s	.peek2_ok2
	move.w	d1,d3
.peek2_ok2
	move.w	d3,(a2)
	move.w	#1,2(a2)
	bra.s	.notnull2
.peek2_yes
	move.w	d1,d3
	move.w	d3,(a2)
	move.w	#Peek_Time,2(a2)
.notnull2
	addq.l	#4,a2
	mulu	d0,d3
	move.b	#$fe,(a0,d3.w)
	addq.l	#1,a0
	dbf	d7,.peek2_loop
	bra	.nopeek
.peek1
;================= Spitzenpegelanzeige,normal ==============================
	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row
	add.w	d0,d0			;mal 2,damit Zeile bersprungen wird
	move.l	bm_planes(a0),a0	;1.Bitplane

	move.w	d0,d1			;auf letzte Zeile setzen
	mulu	#an_zeilen/2-1,d1

	tst.b	an_modenr(a5)
	beq.s	.peek_OK
	cmp.b	#3,an_modenr(A5)
	beq.s	.peek_OK

	add.l	d1,a0
	neg.l	d0
.peek_ok
	lea	anmerk(a5),a1
	lea	anpeek(a5),a2
	moveq	#an_num-1,d7		;Schleifenzhler Balkenanzahl
.peek_loop
	move.w	(a2),d3
	move.w	(a1)+,d1
	bge.s	.oh
	moveq	#0,d1
.oh
	cmp.w	d1,d3		;alter Wert kleiner oder gleich dem neuen ?
	ble.s	.peek_yes
	subq.w	#1,2(a2)		;Timeout fr Peek-Anzeige
	bge.s	.notnull
	sub.w	#1,d3
	bge.s	.peek_ok2
	moveq	#0,d3
.peek_ok2
	move.w	d3,(a2)
	move.w	#1,2(a2)
	bra.s	.notnull
.peek_yes
	move.w	d1,d3
	move.w	d3,(a2)
	move.w	#Peek_Time,2(a2)
.notnull
	addq.l	#4,a2
	mulu	d0,d3
	move.b	#$fe,(a0,d3.w)
	addq.l	#1,a0
	dbf	d7,.peek_loop

; ========= In das Window (dessen Rastport) kopieren =====================
.nopeek
	move.l	grafsave(a5),a6
	move.l	winhandle(a5),a1
	move.l	wd_rport(a1),a1		;Rastport (Ziel)

	move.w	offx(A5),d2
	add.w	#13,d2			;X2
	move.w	myhoehe1(a5),d3		;Y2
	addq.w	#8,d3

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	#an_num*8,d4	;Breite
	move.w	#an_zeilen,d5	;Hhe	
		
	move.b	#$c0,d6		;Miniterm

	jsr	_LVObltbitmaprastport(a6)
	rts
*******************************************************************
*    berprfen,ob Analyzerstruktur schon bergeben wurde und     *
* und ob der aktuelle Player Lautstrke und Sampleperiod bergibt *
*******************************************************************
AN_test
	move.l	winhandle(a5),d0	;Window berhaupt offen ?
	beq	.noanalyze
	move.l	d0,a0

	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq.s	.Noanalyze

	move.l	an_structadr(a5),d0	;keine Strukturadresse ->Scroller aktiv
	beq	scrolit

	move.l	d0,a0
.wait
	tst.w	UPS_enabled(a0)
	bne.s	.Noanalyze

	lea.l	an_struct(a5),a1

	move.w	UPS_Flags(a0),d0
	move.w	d0,UPS_Flags(a1)
	and.w	#UPSB_Per!UPSB_Vol,d0
	cmp.w	#UPSB_Per!UPSB_Vol,d0
	bne.s	.noanalyze

	move.w	UPS_Voice1Per(a0),UPS_Voice1Per(a1)
	move.w	UPS_Voice2Per(a0),UPS_Voice2Per(a1)
	move.w	UPS_Voice3Per(a0),UPS_Voice3Per(a1)
	move.w	UPS_Voice4Per(a0),UPS_Voice4Per(a1)

	move.w	UPS_Voice1Vol(a0),UPS_Voice1Vol(a1)
	move.w	UPS_Voice2Vol(a0),UPS_Voice2Vol(a1)
	move.w	UPS_Voice3Vol(a0),UPS_Voice3Vol(a1)
	move.w	UPS_Voice4Vol(a0),UPS_Voice4Vol(a1)

	move.w	ups_dmacon(a0),ups_dmacon(a1)

	bsr	Analyze1

.noanalyze
	rts
*************************************************************
*                  VBLANK Interrupt                         *
*************************************************************
INT_Prog
	movem.l	d0-a6,-(sp)
	lea	datas,a5
	addq.w	#1,counter(A5)
	move.w	word8(a5),d0		;irgendwas mit`m Eagleplayer nicht in
					;Ordnung ?
	beq.s	.ok			;alles klar
	move.w	counter(A5),d0
	cmp.w	#50*50*3,d0		;1sek*60*3 = 3 Minuten	
	blo.s	.ok

	move.l	grafsave(a5),a0
	addq.b	#1,_LVOBltBitMap+2+3(A0)		;genial bse !
	addq.b	#1,_LVOBltBitMapRastPort+2+3(A0)	;fies aber gut
.ok
	move.l	4.w,a6
	move.l	mytask(a5),a1
	move.l	my2ndsignal(A5),d1
	moveq	#0,d0
	bset	d1,d0
	jsr	_LVOsignal(a6)

	add.w	#1,intmerk+datas

	movem.l	(sp)+,d0-a6
	moveq	#0,d0
	rts
*************************************************************
*       Setzt Interrupt fr Scroller (VBlank)               *
*************************************************************
Setint
	tst.w	intset(a5)	;Interrupt schon gesetzt ?
	bne.s	.no		;ja->raus

	clr.w	intmerk(A5)

	move.l	4.w,a6
	lea	inter(a5),a1
	lea	INT_Prog(pc),a0
	move.l	a0,IS_code(a1)
	move.b	#nt_interrupt,ln_type(a1)
	move.b	#1,ln_pri(a1)
	moveq	#5,d0
	jsr	_LVOaddintserver(a6)
	move.w	#1,intset(a5)

	clr.w	scrolpos(A5)	;Anfang
	clr.w	scroloffset(a5)

	move.b	#1,bm_depth+my_bitmap(a5)
	move.w	#an_num*2+4,bm_BytesPerRow+my_bitmap(a5)

	move.l	mytask(A5),a1
	moveq	#5,d0
	jsr	_LVOsettaskpri(a6)
.no
	rts
*************************************************************
*         entfernt Scroller-Interrupt                       *
*************************************************************
Remint
	tst.w	intset(a5)
	beq.s	.no

	move.l	4.w,a6
	moveq	#5,d0
	clr.w	intset(a5)
	lea	inter(a5),a1
	jsr	_LVOremintserver(a6)

	move.w	#an_num,bm_BytesPerRow+my_bitmap(a5)
	cmp.b	#$e3,an_modenr(a5)
	beq.s	.doch
	cmp.b	#$e5,an_modenr(A5)
	beq.s	.doch
	cmp.b	#6,an_modenr(a5)
	blt.s	.not
.doch
	move.b	#2,bm_depth+my_bitmap(a5)
.not
	move.l	mytask(A5),a1
	moveq	#-5,d0
	jsr	_LVOsettaskpri(a6)

.no	rts
*************************************************************
*           Nachrichtenbearbeitung                          *
*************************************************************
HandleActions
	bsr	Setint
	bra.s	.ma
.ma2
	btst	d3,d0
	beq.s	.ma

	movem.l	d0/d3,-(sp)
	bsr	An_test
	movem.l	(sp)+,d0/d3

	bclr	d3,d0
	tst.l	d0
	beq.s	.nowinport
.ma
	move.l	4.w,a6
	move.l	port(a5),d0
	beq.s	.nowinport
	move.l	d0,a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.msg
.nowinport
	move.l	4.w,a6
	move.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.AN_msg
.wait	
	moveq	#0,d0
	move.l	4.w,a6

	move.l	port(a5),d1
	beq.s	.no
	move.l	d1,a0
	moveq	#0,d1
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
.no
	move.l	msgport(a5),a0
	moveq	#0,d1
	move.b	mp_sigbit(a0),d1
	bset	d1,d0

	moveq	#0,d3
	tst.l	port(a5)		;kein Win,kein Interrupt
	beq.s	.nowaitsignals
		
	tst.w	scrolmerk(a5)		;kein Scroller,kein Interrupt
	beq.s	.sign		;scroller -> int
	tst.w	picmerk(A5)		;kein Bild, kein Interrupt ntig
	bne.s	.nosign
	tst.b	picset(A5)		;bild fertig,kein int
	bne.s	.nosign
.sign
	move.l	my2ndsignal(a5),d3	;fr Interrupt
.nosign
	tst.l	an_structadr(a5)
	beq.s	.int

	move.l	mysignal(a5),d3
.int
	bset	d3,d0
.nowaitsignals
	jsr	_LVOwait(a6)
	bra	.ma2
.AN_msg
	move.l	d0,a1

	move.l	msgport(a5),UM_UserPort(a1)
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	move.l	mytask(a5),UM_TaskAdr(a1)
	move.l	mysignal(a5),d1
	move.l	d1,UM_Signal(a1)

	move.l	UM_Type(a1),d7
	move.l	UM_structadr(a1),d6 	<-
	move.w	UM_class(a1),d3	<-

	cmp.w	#USclass_exit,d3
	bne.s	.noexi
	clr.l	UM_Signal(a1)
	clr.l	UM_Taskadr(a1)
.noexi
	cmp.w	#USclass_getconfig,d3
	bne	.noprev
	moveq	#0,d0
	move.l	winhandle(A5),d1
	beq.s	.prnowin
	or.w	#eusb_openwin,d0

	move.l	d1,a0
	move.w	myhoehe1(a5),d1		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d1
	bne.s	.getxy

	or.w	#eusb_zipwin,d0
	bra.s	.prnowin
.getxy
	move.w	wd_leftedge(a0),eus_winx(a2)
	move.w	wd_topedge(a0),eus_winy(a2)
.prnowin
	move.w	d0,eus_flags(a2)

	tst.w	scrolmerk(A5)
	seq	d0
	and.b	#1,d0
	move.b	d0,eus_special(a2)

	tst.w	picmerk(a5)
	seq	d0
	and.b	#1,d0
	move.b	EUS_special+3(a2),d0		;Bild an/aus


	move.b	an_modenr(a5),eus_special+1(a2)
	move.b	an_peekaha(A5),eus_special+2(a2)
.noprev
	move.l	mn_replyport(a1),d0
	cmp.l	MSGport(a5),d0		 ;eine von uns abgeschickte Message ?
	beq.s	.noreply
	jsr	_LVOreplymsg(a6)
.noreply

	cmp.l	#USM_Userprg,d7		;Message zurckbekommen ?
	bne.s	.nomy
	move.b	#0,messagesent(a5)	;merken,da Message-Struktur frei
	bra	.mess	;eventl. Message vom Esagle auswerten
.nomy
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	bne	.noeagle	;n
.mess
	move.l	d6,an_structadr(a5)	;Analyzerstrukturadresse merken
	tst.l	d6
	beq.s	.clrpic2
	move.b	#1,merkstruct(A5)

	movem.l	d0-d7,-(sp)

	bsr	Remint
	bsr	.clearpic.3

	movem.l	(sp)+,d0-d7
	bra.s	.clrpcwei
.clrpic2
	tst.w	picmerk(a5)
	beq.w	.allesklo
	bsr	.clearpic.3
.allesklo
	clr.b	Picset(A5)
	bsr	.clearscrol
	bsr	setint
.clrpcwei
	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq.w	.ma			;adresse bekommen

	cmp.w	#USclass_zipwin,d3
	bne.s	.nozip
.setzip

	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.w	.ma		;Window schon klein
.zip
	move.w	d0,-(sp)

	move.l	intsave(a5),a6
	jsr	_LVOzipwindow(a6)

	move.w	(sp)+,d4

	move.l	winhandle(a5),a2
.Zipwait:
	moveq	#1,d1
	move.l	_Dos(a5),a6
	jsr	_LVODelay(a6)

	cmp.w	wd_height(a2),d4
	beq.s	.zipwait

	bra	.ma
.nozip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nounzip

.clearzip
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.s	.zip
	bra	.ma
.nounzip

	cmp.w	#USclass_exit,d3
	beq	.exit

	cmp.w	#USclass_Show,d3
	beq.s	.win
	cmp.w	#USclass_Activate,d3
	bne.w	.nowin
.win
		move.l	Begin+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Iconify,d0
		bne.w	.ma
	bsr	Openwin

	bra.w	.ma
.nowin
	cmp.w	#USclass_Hide,d3
	beq.s	.closewin
	cmp.w	#USclass_DeActivate,d3
	bne.s	.noclosewin
.closewin
	bsr	Closewin
.noclosewin
	cmp.w	#USclass_NewConfig,d3	;Neu angekommene Config setzen
	bne.w	.nonewcon
	bsr	setcon1		;Modus & Scroller an/aus
	bsr	.clearpic.2	;Bild lschen
	bsr	setpic		;oder den "HASEN" setzen

	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin	;ffnen
	bra.s	.weio
.nowino
	bsr	closewin ;schlieen
.weio
	lea	begin(pc),a0
	move.l	winhandle(a5),d0
	beq.s	.nothingtomove		;kein Window ???
	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;neue X-Position
	move.w	d0,d1			;sichern
	blt.s	.oldx		;kleiner 0 -> sofort aufhren

	add.w	wd_width(a1),d1		;neue Position + Windowbreite
	cmp.w	sc_width(a2),d1		;grer als Screenbreite ?
	bhi.s	.oldx

	sub.w	wd_leftedge(a1),d0	;neue - alte X-Position = Delta X
	bra.s	.gety
.oldx	moveq	#0,d0
.gety
	move.w	eus_winy(a0),d1		;neue Y-Position
	move.w	d1,d2			;sichern
	blt.s	.oldy		;kleiner 0 -> sofort aufhren

	add.w	wd_height(a1),d2	;neue Position + Windowhhe
	cmp.w	sc_height(a2),d2	;grer als Screenhhe ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;neue - alte Y-Position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1
.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove

	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	and.w	#eusb_zipwin,d0	;Zipwindow ?
	bne	.setzip		;yes
	bra	.clearzip	;no
.nonewcon
	bra	.ma
.noeagle
	bra	.ma
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<-
	move.l	im_Iaddress(a1),d6 	<-
	jsr	_LVOreplymsg(a6)

	cmp.l	#refreshwindow,d7
	bne.s	.testgads

	bsr	refresh
	bra	.ma
.testgads
	cmp.l	#Gadgetup,d7
	bne.w	.notgad

	cmp.b	#$e3,an_modenr(a5)
	beq.s	.yo1
	cmp.b	#$e2,an_modenr(a5)
	beq.s	.yo1
	cmp.b	#$e4,an_modenr(a5)
	beq.s	.yo1
	cmp.b	#$e5,an_modenr(a5)
	beq.s	.yo1
	cmp.b	#6,an_modenr(a5)
	blt.w	.noe
.yo1
	Pea.l	.noe(pc)
;======== Wenn Modus 6/7 eingestellt ist,ganze Bitmap lschen ================
.Clearpic:
	tst.l	an_structadr(a5)
	beq	.rts
	bra.s	.clearpic.3
.clearpic.2
	tst.w	picmerk(a5)
	beq.w	.rts
.clearpic.3
	tst.l	winhandle(a5)
	beq	.rts

	movem.l	d0-a6,-(sp)

	move.l	winhandle(a5),a0
	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq.s	.rts2

	move.l	grafsave(a5),a6

	lea.l	my_bitmap(a5),a0
	move.l	bm_planes(a0),a1	;1.Bitplane
	move.l	#an_num*an_zeilen,d0
	moveq	#1,d1
	jsr	_LVOBltclear(a6)

	lea.l	my_bitmap(a5),a0
	move.l	bm_planes+4(a0),a1	;2.Bitplane
	move.l	#an_num*an_zeilen,d0
	moveq	#1,d1
	jsr	_LVOBltclear(a6)

	move.l	winhandle(a5),a1
	move.l	wd_rport(a1),a1		;Rastport (Ziel)
	move.w	offx(A5),d2
	add.w	#13,d2			;X2
	move.w	myhoehe1(a5),d3		;Y2
	addq.w	#8,d3
	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	#an_num*8,d4	;Breite
	move.w	#an_zeilen,d5	;Hhe	
	move.b	#$c0,d6		;Miniterm

	move.b	bm_depth(a0),d7
	move.b	#2,bm_depth(a0)

	move.w	#an_num,(a0)	;bm_BytesPerRow

	move.l	d7,-(sp)
	jsr	_LVObltbitmaprastport(a6)	;gesamte Flche im Rastport
	move.l	(sp)+,d7

	move.b	d7,my_bitmap+bm_depth(a5)
.rts2
	movem.l	(sp)+,d0-a6			;lschen
.rts
	rts
;===========================================================================
.noe
	cmp.l	#Gadmode0,d6	;von oben nach unten,ausgefllt
	bne.s	.nomode0
.setmode0
	cmp.b	#0,an_modenr(a5)
	beq.s	.setpeek0
	move.b	#0,an_modenr(a5)
	move.b	#0,an_peekaha(a5)
	move.b	#1,bm_depth+my_bitmap(a5)
	bra	.ma
.setpeek0
	tst.b	an_peekaha(a5)
	beq	.setpeek
	cmp.b	#1,an_peekaha(a5)
	beq	.setpeek.2
	move.b	#$f1,an_modenr(A5)
	move.b	#0,an_peekaha(a5)
	bra	.ma
.nomode0
	cmp.l	#Gadmode1,d6
	bne.s	.nomode1
.setmode1
	cmp.b	#1,an_modenr(a5)
	beq.w	.setpeek1
	cmp.b	#$f0,an_modenr(a5)
	beq.s	.setmodee5
	move.b	#1,an_modenr(a5)
	move.b	#0,an_peekaha(a5)
	move.b	#1,bm_depth+my_bitmap(a5)
	bra	.ma
.setpeek1
	tst.b	an_peekaha(a5)
	beq	.setpeek
	move.b	#$f0,an_modenr(A5)
	move.b	#0,an_peekaha(a5)
	bra	.ma
.setmodee5
	move.b	#$e5,an_modenr(A5)
	move.b	#2,bm_depth+my_bitmap(a5)
	move.b	#0,an_peekaha(a5)
	bra	.ma
.nomode1
	cmp.l	#Gadmode2,d6
	bne.s	.nomode2
.setmode2
	cmp.b	#2,an_modenr(a5)
	beq.w	.setpeek
	move.b	#2,an_modenr(a5)
	move.b	#0,an_peekaha(a5)
	move.b	#1,bm_depth+my_bitmap(a5)
	bra	.ma
.nomode2
	cmp.l	#Gadmode3,d6
	bne.s	.nomode3
.setmode3
	cmp.b	#3,an_modenr(a5)
	beq.w	.setpeek3
	move.b	#3,an_modenr(a5)
	move.b	#0,an_peekaha(a5)
	move.b	#1,bm_depth+my_bitmap(a5)
	bra	.ma
.setpeek3
	cmp.b	#1,an_peekaha(a5)
	beq	.setpeek.2
	bra	.setpeek
.nomode3
	cmp.l	#Gadmode5,d6
	bne.s	.nomode5
.setmode4
	move.b	#0,an_peekaha(a5)
	move.b	#1,bm_depth+my_bitmap(a5)
	cmp.b	#5,an_modenr(a5)
	beq.s	.setmodeef
	cmp.b	#$ef,an_modenr(A5)
	beq.s	.setmodee4
	move.b	#5,an_modenr(a5)
	bra	.ma
.setmodeef
	move.b	#$ef,an_modenr(a5)
	bra	.ma
.setmodee4
	move.b	#$e4,an_modenr(a5)
	bra	.ma
.nomode5
	cmp.l	#Gadmode4,d6
	bne.s	.nomode4
.setmode5
	move.b	#0,an_peekaha(a5)
	move.b	#1,bm_depth+my_bitmap(a5)

	cmp.b	#4,an_modenr(A5)
	beq.s	.setmodee2
	move.b	#4,an_modenr(a5)
	bra	.ma
.setmodee2
	move.b	#$e2,an_modenr(a5)
	bra	.ma
.nomode4
	cmp.l	#Gadmode6,d6
	bne.s	.nogadmode6
.setmode6
	move.b	#0,an_peekaha(a5)
	move.b	#2,bm_depth+my_bitmap(a5)
	cmp.b	#7,an_modenr(a5)
	beq.s	.mode6
	cmp.b	#6,an_modenr(A5)
	beq.s	.modee3
	move.b	#7,an_modenr(a5)
	bra	.ma
.modee3	move.b	#$e3,an_modenr(A5)
	bra	.ma
.mode6	move.b	#6,an_modenr(a5)
	bra	.ma
.nogadmode6
	bra	.ma
.setpeek.2
	move.b	#2,an_peekaha(a5)
	bra	.ma
.setpeek
	tst.b	an_peekaha(a5)
	bne.s	.clrpeek
	move.b	#1,an_peekaha(a5)
	bra	.ma
.clrpeek
	move.b	#0,an_peekaha(a5)
	bra	.ma
.notgad:
	cmp.l	#menupick,d7
	bne.w	.nomenu
	cmp.w	#menunull,d5
	beq	.ma
	move.w	d5,addi(a5)
.menuloop
	moveq	#0,d0
	move.w	addi(A5),d0

	move.l	intsave(a5),a6
	move.l	Menuadr(a5),a0
	jsr	_LVOitemaddress(A6)
	tst.l	d0
	beq	.ma
	move.l	d0,a1
	move.w	addi(a5),d7
	move.w	mi_nextselect(a1),addi(a5)

	and.w	#$7e0,d7

	cmp.w	#32,d7
	bne.s	.nousage
	lea	Usagemessage(pc),a0	;Information
	bsr	Merror
	bra	.menuloop
.NoUsage
	cmp.w	#64,d7
	beq	.togglescrol

	cmp.w	#96,d7
	beq	.togglepic

	cmp.w	#128,d7		;5. Item ? (Hide)
	beq	.closewinny	;je nach Einstellung Window schlieen bzw. ENDE

	cmp.w	#160,d7		;6. Item (Quit)
	beq	.endme

	lea	Aboutmessage(pc),a0	;Information
	bsr	Merror
	bra	.menuloop
;----------------------- Scrol an/aus -----------------------------------
.togglescrol
	move.w	mi_flags(A1),d0
	and.w	#checked,d0
	bne.s	.clrscro

	move.w	#-1,scrolmerk(A5)	;wenn Ergebnis <> 0 ; Scroller aus
	bra.s	.scrowe
.clrscro
	clr.w	scrolpos(A5)	;Anfang
	clr.w	scroloffset(a5)
	clr.w	scrolmerk(a5)
	move.b	#1,merkstruct(A5)
	bsr	.clearscrol
.scrowe
	tst.w	picmerk(a5)
	bne.s	.realset
	bsr	setpic
	bra	.menuloop
.realset
	bsr	.clearpic.2
	bra	.menuloop
.clearscrol
	tst.b	merkstruct(A5)
	beq.s	.noclrbm
	lea	my_bitmap(a5),a0
	move.l	bm_planes(a0),d0
	beq.s	.noclrbm
	add.l	#an_num*an_zeilen,d0	;auf erste Zeile der Scrollerbitmap
					;setzen
	move.l	d0,a0

	move.w	#an_num*extra_place-1,d0
.clrscrbitm
	clr.b	(a0)+
	dbf	d0,.clrscrbitm

	clr.b	Merkstruct(A5)	;merken:keine Strucktur
.noclrbm
	rts
;-------------------- Bild an/aus -------------------------------
.togglepic
	move.w	mi_flags(A1),d0
	and.w	#checked,d0
	bne.s	.setpic

	move.w	#-1,picmerk(A5)
	bsr	.clearpic.2
	bra	.menuloop
.setpic
	clr.w	picmerk(A5)
	bsr	setpic
	bra	.menuloop
.nomenu
	cmp.l	#Vanillakey,d7
	bne	.nokey

	cmp.b	#$e2,an_modenr(a5)
	beq.s	.yo2
	cmp.b	#$e3,an_modenr(A5)
	beq.s	.yo2
	cmp.b	#$e4,an_modenr(A5)
	beq.s	.yo2
	cmp.b	#$e5,an_modenr(A5)
	beq.s	.yo2
	cmp.b	#6,an_modenr(a5)	;Modus 6 oder hher ?
	blt.s	.noe2
.yo2
	bsr.w	.clearpic	;ja-Bild lschen
.noe2
	cmp.b	#`2`,d5
	bne.s	.no1
	lea	gadmode0(pc),a0	;Gadget1
	bsr	_blinkbutton
	bra	.setmode0
.no1
	cmp.b	#`1`,d5
	bne.s	.no2
	lea	gadmode1(pc),a0	;Gadget2
	bsr	_blinkbutton
	bra	.setmode1
.no2
	cmp.b	#`3`,d5
	bne.s	.no3
	lea	gadmode2(pc),a0	;Gadget3
	bsr	_blinkbutton
	bra	.setmode2
.no3
	cmp.b	#`4`,d5
	bne.s	.no4
	lea	gadmode3(pc),a0	;Gadget4
	bsr	_blinkbutton
	bra	.setmode3
.no4
	cmp.b	#`5`,d5
	bne.s	.no5
	lea	gadmode4(pc),a0	;Gadget5
	bsr	_blinkbutton
	bra	.setmode5
.no5
	cmp.b	#`6`,d5
	bne.s	.no6
	lea	gadmode5(pc),a0	;Gadget6
	bsr	_blinkbutton
	bra	.setmode4
.no6
	cmp.b	#`7`,d5
	bne.w	.no7
	lea	gadmode6(pc),a0	;Gadget7
	bsr	_blinkbutton
	bra	.setmode6
	bra	.ma
.no7
.nodrawer
.nokey
	cmp.l	#CloseWindow,d7
	bne	.ma
.closewinny
	if	Test=0

	tst.b	messagesent(a5)		;Message zurck ?? (normalerweise ja)
	bne	.ma
	bsr	closewin
	move.l	4.w,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	mysignal(a5),d5
	move.w	#USclass_DeActivate,d6
	bsr	sendmess
	bra	.ma

	else

	bra.w	.endme

	endc
.endme
	moveq	#0,d7
	RTS
.exit	moveq	#-1,d7
	rts
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0-a6,-(sp)
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	lea	my_easygadget(pc),a0
	move.l	a0,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	movem.l	(sp)+,d0-a6	
	rts
************************* Scroller *******************************************
Scrolit
	tst.l	WinHandle(a5)
	beq	.no

	tst.b	picset(a5)		;Bild gesetzt ?
	bne.s	.setok
	tst.b	Merkstruct(a5)
;	beq.s	.takethisman
	cmp.w	#Wait_time,intmerk(a5)	;1 Sekunde warten,bevor Bild erscheint
	blo	.no
.takethisman
	bsr	SetPic
.setok
	tst.w	scrolmerk(a5)
	bne	.no		;nicht scrollen

	move.w	intmerk(a5),d1
	subq.w	#1,d1
	bge.s	.oops
	clr.w	d1
.oops
	clr.w	intmerk(a5)

	move.w	#an_num*2+4,bm_BytesPerRow+my_bitmap(a5)
	move.b	#1,bm_depth+my_bitmap(a5)	;zur Sicherheit

	move.l	my_bitmap+bm_planes(a5),a0
	add.l	#an_num*an_zeilen,a0	;auf erste Zeile der Scrollerbitmap
					;setzen
	move.w	scrolpos(a5),d0			;aktuelle Position
;	add.w	d1,scrolpos(a5)

	and.w	#15,d0			;wenn unteren 4 Bits = 0 => neuer Buch-
	beq	.newbuch		;stabe
	add.w	d1,d0
	cmp.w	#16,d0
	blt	.nonewbuch
	bra	.nonewbuch
.newbuch
	move.w	scrolpos(a5),d0		;aktuelle Position

	lsr.w	#3,d0
	addq.w	#2,d0		;1 Buchstabe Sicherheitsabstand
	and.w	#$fffe,d0
	add.w	d0,a0

	moveq	#0,d0
	move.w	scroloffset(a5),d1	;Buchstabenoffset
	lea	scroltext(pc),a1
	move.b	(a1,d1.w),d0
	bne.s	.add
	moveq	#-1,d1
	move.b	(a1),d0
.add
	addq.w	#1,d1
	move.w	d1,scroloffset(a5)
	lea	asciidaten(pc),a1

	cmp.b	#"A",d0
	blo.s	.noand
	and.l	#$5f,d0	;fr Grobuchstaben ausmaskieren und Rest lschen
.noand
	sub.b	#32,d0
	bgt.s	.ok
	moveq	#0,d0
.ok
	lsl.w	#5,d0	;mal 32
	add.l	d0,a1

	moveq	#0,d0
	move.l	a0,a2
	move.w	my_bitmap(a5),d0
	moveq	#15,d1
.loop	move.w	(a1),-2(a2)	;eine Position (1 Wort) vor sichtbarem Bereich
	move.w	(a1)+,an_num(a2);genau hinter sichtbarem Bereich
	add.l	d0,a2
	dbf	d1,.loop

.nonewbuch
	move.l	grafsave(a5),a6
	move.l	winhandle(a5),a1
	move.l	wd_rport(a1),a1		;Rastport (Ziel)
	move.w	offx(A5),d2
	add.w	#13,d2			;X2
	move.w	myhoehe1(a5),d3		;Y2
	addq.w	#8,d3			;8 Grundhhe

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	move.l	bm_planes(a0),d0
	move.l	d0,-(sp)
	add.l	#an_num*an_zeilen,d0
	move.l	d0,bm_planes(a0)

	move	scrolpos(a5),d0		;X1
	add.w	#16,d0
	moveq	#0,d1			;Y1

	move.w	#an_num*8,d4	;Breite
	move.w	#16,d5		;Hhe
		
	move.b	#$c0,d6		;Miniterm

	jsr	_LVObltbitmaprastport(a6)

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	move.l	(sp)+,bm_planes(a0)

	add.w	#2,scrolpos(a5)
	cmp.w	#15*16,scrolpos(a5)
	blt.s	.no
	clr.w	scrolpos(A5)	;Anfang
.no
	rts
;****************** Setzt Bild ins Hauptfenster ***************************
Setpic
	tst.l	winhandle(a5)
	beq	.rts
	tst.l	an_structadr(a5)
	bne	.rts

	movem.l	d0-a6,-(sp)
	move.l	winhandle(a5),a0
	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq	.noe2

	move.l	grafsave(a5),a6

	tst.w	picmerk(a5)	;kein Bild setzen,nur oberen Bildschrimteil
	bne	.clrscrolbm	;fr Scroller lschen

	lea.l	my_bitmap(a5),a0
	move.l	bm_planes(a0),a4	;1.Bitplane
	move.l	bm_planes+4(a0),a2	;2.Bitplane

	lea	picplane1(pc),a1
	lea	picplane2(pc),a3

	move.w	#28*64-1,d0
.copy
	move.b	(a1)+,(a4)+
	move.b	(a3)+,(a2)+
	dbf	d0,.copy

	move.l	winhandle(a5),a1
	move.l	wd_rport(a1),a1		;Rastport (Ziel)
	move.w	offx(A5),d2
	add.w	#13,d2			;X2
	move.w	myhoehe1(a5),d3		;Y2
	addq.w	#8,d3

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	move.w	(a0),-(sp)
	move.b	bm_depth(a0),d0
	move.w	d0,-(sp)

	move.b	#2,bm_depth(a0)
	move.w	#28,(a0)

	moveq	#0,d1			;Y1
	moveq	#0,d0			;X1
	move.w	#an_num*8,d4	;Breite
	move.w	#an_zeilen,d5;Hhe

	tst.w	scrolmerk(A5)	;Scroller erlaubt ?
	bne.s	.noe
	add.w	#16,d3
	moveq	#10,d1			;Y1
	move.w	#an_zeilen-16,d5;Hhe
.noe
	move.b	#$c0,d6		;Miniterm
	move.w	#an_num,(a0)	;bm_BytesPerRow
	jsr	_LVObltbitmaprastport(a6)	;gesamte Flche im Rastport

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	move.w	(sp)+,d0
	move.b	d0,bm_depth(a0)
	move.w	(sp)+,(a0)

.clrscrolbm
	tst.w	scrolmerk(A5)	;Scroller erlaubt ?
	bne.s	.noe2

	lea.l	my_bitmap(a5),a0
	move.l	bm_planes+4(a0),a2		;2.Bitplane
	move.l	bm_planes(a0),a3		;1.Bitplane

	move.w	#an_num*an_zeilen/2-2,d4	;Gre
	moveq	#0,d0
.loesch
	move.w	d0,(a3)+
	move.w	d0,(a2)+
	dbf	d4,.loesch

	move.l	winhandle(a5),a1
	move.l	wd_rport(a1),a1		;Rastport (Ziel)

	move.w	offx(A5),d2
	add.w	#13,d2			;X2
	move.w	myhoehe1(a5),d3		;Y2
	addq.w	#8,d3

	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	#an_num*8,d4	;Breite
	move.w	#16,d5		;Hhe
	move.b	#$c0,d6		;Miniterm
	move.b	bm_depth(a0),d7
	move.b	#2,bm_depth(a0)
	jsr	_LVObltbitmaprastport(a6)	;gesamte Flche im Rastport
	move.b	d7,my_bitmap+bm_depth(a5)
.noe2
	movem.l	(sp)+,d0-a6
	move.b	#1,Picset(A5)
.rts
	rts
;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************

int:	dc.b	`intuition.library`,0
gad:	dc.b	`gadtools.library`,0
graf:	dc.b	`graphics.library`,0
dos:	dc.b	`dos.library`,0
portname:	dc.b	`EAGLEPLAYERPORT`,0

MyWinName:	dc.b	`ANALYZER`,0
MyAnalyzername:	dc.b	`EAnalyzer.1`,0
MyUsername:	dc.b	`** Analyzer **`,0
my_easygadget:	dc.b	`   OK   `,0
my_easytitle:	dc.b	`Analyzer Message`,0
my_easygadget2:	dc.b	` Retry | Cancel `,0
	even
mybuggsname	dc.b	`Buggs of DEFECT`,0
myinfo		dc.b	`Standard Spectrum Analyzer with over 20 Modes`,0
Scroltext:
	dc.b	`       `
	dc.b	`Eagleplayer Spectrum Analyzer V1.29,copyright by Henryk`
	dc.b	` "BUGGS" Richter !`
	dc.b	` This piece of Software was written in`
	dc.b	` December 1993 using ASM-ONE,it belongs to the Eagleplayer`
	dc.b	` package and may not be spread alone. it was written`
	dc.b	` for non-profit purposes !!`
	dc.b	` distributors of the package must have got a written`
	dc.b	` permission`
	dc.b	` by the authors !! (Beside of this they will get the latest `
	dc.b	` version of these prgrams)`
	dc.b	` our group are: `
	dc.b	` eagleeye,crazy copper,M.U.D.U.,ramon,animal,cliff and myself-`
	dc.b	` buggs`
	dc.b	` datas: about 87k of sourcecode`
	dc.b	` including gfx,some weeks of hard work,internal interrupt,`
	dc.b	`own message system to correspond with eagleplayer,`
	dc.b	`21 Modes, OS 3.0 compatibility but not running under 1.3 (who`
	dc.b	` wants to work with a cool program has to own a cool system)`
	dc.b	` ..... `
	dc.b	` if you are intrested in swapping all kinds of soundmodules`
	dc.b	`,please write me (press right amiga + a for my address),i have`
	dc.b	` got at now about 220 disks only with sound-noise-`
	dc.b	`star-protrackermodules and 130 MB (packed) Modules on HD `
	dc.b	` i am awaiting your letters ..............................`,0

	even
Aboutmessage:
	dc.b	`        EaglePlayer Spectrum Analyzer V1.29`,$0a
	dc.b	`       1993 Henryk "BUGGS" Richter of DEFECT`,$0a
	dc.b	`   This piece belongs to the Shareware Version of`,10
	dc.b	`the Eagleplayer Package and may not be spread alone`,10,10
	dc.b	`you can reach the Author at the following Address:`,$0a
	dc.b	`              Henryk Richter`,$0a
	dc.b	`           St.-Jantzen Ring 47`,$0a
	dc.b	`              18106 Rostock`,$0a
	dc.b	`                 GERMANY`,0
	even
Usagemessage
	dc.b	`       Eagleplayer Analyzer Usage Help`,$0a,$0a
	dc.b	`Press Keys "1"-"7" or the Gadgets to change the`,$0a
	dc.b	`Modes,the rest does the player for you`,$0a
	dc.b	`At now there exist 21 Modes you may choose of,`,$0a
	dc.b	`please note that all keys (gadgets) switch more than`,$0a
	dc.b	`only one Mode (e.g. 4 Modes at key "4")`,10
	dc.b	`The Menuitem "SCROLLER" turns the Pause-Scroller on/off`,0
	dc.b	`The Menuitem "Picture" turns the Pause-Picture on/off`
	even
NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0
	even

Mylabel1:	dc.b	`Project`,0
Mylabel2:	dc.b	`About`,0
MYCOMM2:	dc.b	`A`,0
MyLabel3:	dc.b	`Usage`,0
Mycomm3:	dc.b	`U`,0
MyLabel4:	dc.b	`Quit`,0
mycomm4:	dc.b	`Q`,0
myhidelabel:	dc.b	`Hide`,0
Myhidecomm:	dc.b	`H`,0
MyLabel5:	dc.b	`Scroller`,0
mycomm5:	dc.b	`S`,0
MyLabel6:	dc.b	`Picture `,0
mycomm6:	dc.b	`P`,0
	even
myfontatt:
	dc.l	myfontname
	dc.w	8
	dc.w	0
myfontname:	dc.b	`topaz.font`,0
	even

GLefts	dc.w	12+33,15,12+33*2,12+33*3,12+33*4,12+33*5,12+33*6

GadMode0:
	dc.l	GadMode1
	dc.w	15+33,0
	dc.w	28,14
	dc.w	Gadgimage
	dc.w	relverify
	dc.w	boolgadget
	dc.l	Mode0Image
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0
GadMode1
	dc.l	GadMode2
	dc.w	15,0
	dc.w	28,14
	dc.w	Gadgimage
	dc.w	relverify
	dc.w	boolgadget
	dc.l	Mode1Image
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0
GadMode2:
	dc.l	GadMode3
	dc.w	15+33*2,0
	dc.w	29,14
	dc.w	Gadgimage
	dc.w	relverify
	dc.w	boolgadget
	dc.l	Mode2Image
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0
GadMode3:
	dc.l	GadMode4
	dc.w	15+33*3,0
	dc.w	28,14
	dc.w	Gadgimage
	dc.w	relverify
	dc.w	boolgadget
	dc.l	Mode3Image
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0
GadMode4
	dc.l	GadMode5
	dc.w	15+33*4,0
	dc.w	28,14
	dc.w	Gadgimage
	dc.w	relverify
	dc.w	boolgadget
	dc.l	Mode4Image
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0
GadMode5
	dc.l	GadMode6
	dc.w	15+33*5,0
	dc.w	28,14
	dc.w	Gadgimage
	dc.w	relverify
	dc.w	boolgadget
	dc.l	Mode5Image
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0
GadMode6
	dc.l	0
	dc.w	15+33*6,0
	dc.w	28,14
	dc.w	Gadgimage
	dc.w	relverify
	dc.w	boolgadget
	dc.l	Mode6Image
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0
Mode0Image
	dc.w	0,0
	dc.w	28,14,2
	dc.l	Mode0Planes
	dc.b	03,00
	dc.l	0
Mode1Image
	dc.w	0,0
	dc.w	28,14,2
	dc.l	mode1I1Data
	dc.b	03,00
	dc.l	0
Mode2Image
	dc.w	0,0
	dc.w	29,14,3
	dc.l	mode2I1Data
	dc.b	07,00
	dc.l	0
Mode3Image
	dc.w	0,0
	dc.w	29,14,3
	dc.l	mode3I1Data
	dc.b	7,0
	dc.l	0
Mode4Image
	dc.w	0,0
	dc.w	29,14,2
	dc.l	mode4I1Data
	dc.b	3,0
	dc.l	0
Mode5Image
	dc.w	0,0
	dc.w	29,14,2
	dc.l	mode5I1Data
	dc.b	3,0
	dc.l	0
Mode6Image
	dc.w	0,0
	dc.w	28,14,2
	dc.l	UntitledI1Data
	dc.b	3,0
	dc.l	0
Asciidaten
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$03F003F0,$03E003E0,$03C003C0,$03800380,$03000300,$00000300,$07000700,$00000000
 DC.L	$79E03CF0,$1E780F3C,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$01E003C0,$07800F00,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$00F001E0,$03C00780,$0F000E00,$0E000F00,$0F000780,$03C001E0,$00F00078,$00000000
 DC.L	$1E000F00,$078003C0,$01E000F0,$00700078,$00780078,$00F001E0,$03C00780,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$00000000,$00000000,$00000180,$018007E0,$07E00180,$01800000,$00000000,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00C001E0,$01E000E0,$006000E0,$00000000
 DC.L	$00000000,$00000000,$00000000,$000003F0,$03F00000,$00000000,$00000000,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$018003C0,$03C001C0,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$FFFCFFFC,$F03CF03C,$F03CF03C,$F03CF03C,$FC3CFC3C,$FC3CFC3C,$FFFCFFFC,$00000000
 DC.L	$0F000F00,$0F000F00,$0F000F00,$0FC00FC0,$0FC00FC0,$0FC00FC0,$0FC00FC0,$00000000
 DC.L	$FFFCFFFC,$FC3CFC3C,$003C003C,$FFFCFFFC,$F000F000,$FC00FC00,$FFFCFFFC,$00000000
 DC.L	$FFFCFFFC,$FC3CFC3C,$003C003C,$0FF00FF0,$003C003C,$FCFCFCFC,$FFFCFFFC,$00000000
 DC.L	$F000F000,$F000F000,$FC00FC00,$FCF0FCF0,$FFFCFFFC,$03F003F0,$03F003F0,$00000000
 DC.L	$FFFCFFFC,$F000F000,$FC00FC00,$FFFCFFFC,$003C003C,$FC3CFC3C,$FFFCFFFC,$00000000
 DC.L	$FFFCFFFC,$F0FCF0FC,$FC00FC00,$FFFCFFFC,$F03CF03C,$FC3CFC3C,$FFFCFFFC,$00000000
 DC.L	$FFFCFFFC,$FC3CFC3C,$003C003C,$003C003C,$00FC00FC,$00FC00FC,$00FC00FC,$00000000
 DC.L	$FFFCFFFC,$F03CF03C,$FC3CFC3C,$3FF03FF0,$F03CF03C,$FC3CFC3C,$FFFCFFFC,$00000000
 DC.L	$FFFCFFFC,$F03CF03C,$FC3CFC3C,$FFFCFFFC,$003C003C,$FC3CFC3C,$FFFCFFFC,$00000000
 DC.L	$00000000,$00000300,$07800780,$03800000,$000000C0,$01E001E0,$00E00000,$00000000
 DC.L	$00000000,$018003C0,$03C001C0,$00000000,$006000F0,$00F00070,$00300070,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$00000000,$00000000,$00000000,$07E007E0,$000007E0,$07E00000,$00000000,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$3FF87FFC,$F83CF03C,$003C007C,$01F803C0,$03800380,$03800000,$03800380,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
 DC.L	$E000F000,$F800FC00,$FE00FF00,$F780F3C0,$FFE0FFF0,$F078F03C,$F03CF01C,$00000000
 DC.L	$FC00FE00,$F700F380,$F1C0F1C0,$FFC0FFC0,$F1F0F078,$F038F03C,$FFFCFFF8,$00000000
 DC.L	$1C007F00,$7700F300,$F000F000,$F000F000,$F000F000,$F80C7C0C,$3FFC1FF8,$00000000
 DC.L	$F800FE00,$FF00F780,$F3C0F1E0,$F0F0F078,$F03CF03C,$F03CF03C,$FFFCFFF8,$00000000
 DC.L	$3F007F00,$F800F000,$F000F000,$FFC0FFC0,$F000F000,$F8007C00,$3FFC1FFC,$00000000
 DC.L	$07C01FC0,$1E003C00,$3C003C00,$3FF03FF0,$3C003C00,$3C003C00,$3C003C00,$00000000
 DC.L	$03000FC0,$1FC03CE0,$78007000,$F000F000,$F0F0F0FC,$F81C780C,$7FFC1FF8,$00000000
 DC.L	$F1C0F1E0,$F0E0F0F0,$F070F078,$FFF8FFFC,$F03CF03C,$F03CF03C,$F03CF03C,$00000000
 DC.L	$0F800F80,$0F800F80,$0F800FC0,$0FC00FC0,$0FC00FC0,$0FC00FC0,$0FC00FC0,$00000000
 DC.L	$FFF0FFF0,$0F000780,$03C001E0,$00F00078,$F03CF03C,$F03CF83C,$7FFC3FF8,$00000000
 DC.L	$F040F0C0,$F1C0F3C0,$F780FF00,$FE00FC00,$FF00FF80,$F7E0F1F0,$F0FCF03C,$00000000
 DC.L	$E000E000,$E000E000,$F000F000,$F000F000,$F000F000,$F800F800,$FFFCFFFC,$00000000
 DC.L	$E0C0F1E0,$F1E0FBF0,$FFF0FFF8,$FFF8F738,$F33CF33C,$F03CF03C,$F03CF03C,$00000000
 DC.L	$0380E3C0,$F1E0F0E0,$F8F0FC70,$FC78FE38,$FF3CF79C,$F3FCF1FC,$F0FCF03C,$00000000
 DC.L	$07801FC0,$3FE078F0,$7078F038,$F03CF01C,$F01CF81C,$F81C7C3C,$7FFC1FF8,$00000000
 DC.L	$3E003FC0,$3FE03DF0,$3C783C3C,$3C3C3C3C,$3FF83FF0,$3F803C00,$3C003C00,$00000000
 DC.L	$07001FC0,$3FE078F0,$7878F038,$F01CF01C,$F0CCF0EC,$F8747C38,$7FDC1FE8,$00000000
 DC.L	$FE00FF80,$F3C0F1E0,$F1E0F1E0,$F1C0FFC0,$FF80FF80,$F3C0F1E0,$F0F0F078,$00000000
 DC.L	$3C007F00,$FB00F380,$F000F800,$7FC03FF8,$007C003C,$F83CF83C,$7FFC3FF8,$00000000
 DC.L	$FFF0FFF0,$F780F380,$03C003C0,$03C003C0,$03C003C0,$03C001E0,$01E001E0,$00000000
 DC.L	$F300F380,$F380F3C0,$F3C0F1E0,$F0F0F0F0,$F078F838,$F83C7C3C,$7FF83FF8,$00000000
 DC.L	$F0F0F0F0,$F0F0F0F0,$F0F0F0F0,$F8F078F0,$3CF03EF0,$1FF00FF0,$07F003E0,$00000000
 DC.L	$F3C0F3E0,$F0F0F070,$F078F038,$F33CF33C,$F3BCFBBC,$FFFCFFFC,$7E7C3C38,$00000000
 DC.L	$F3C0F3C0,$F3C07BC0,$7F803F00,$3FC07FE0,$79F0F878,$F03CF03C,$F03CF03C,$00000000
 DC.L	$F0F0F0F0,$F0F0F0F0,$78F07CF0,$3FF01FE0,$0FC007C0,$03C003C0,$03C003C0,$00000000
 DC.L	$FFC0FFC0,$F3C0F3C0,$03C003C0,$07C00F80,$1F003E00,$7C00F800,$FFFCFFFC,$00000000
 DC.L	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Picplane1
 DC.L	0,0,0,0,0,0,0,0
 DC.L	0,0,0,0,0,0,0,$00037ED0
 DC.L	0,0,0,0,0,0,$0001BB48,0
 DC.L	0,0,0,0,0,$0000DDA4,0,0
 DC.L	0,0,0,0,$00002ED2,0,$00500000,0
 DC.L	0,0,0,$00000561,0,$00A80000,0,0
 DC.L	0,0,$00000A30,$80000000,$00540000,0,0,0
 DC.L	0,$00000158,$40000000,$002A0000,0,0,0,0
 DC.L	$0000029C,0,$00150000,0,0,0,0,$0000035E
 DC.L	$40000000,$000A8000,0,0,0,0,$000001BC,$60000000
 DC.L	$00054000,0,$00780000,0,0,$000000DE,$30000000,$00038000
 DC.L	0,$00FF07C0,0,0,$0000002C,$F8000000,$00015000,0
 DC.L	$00E384E0,0,0,$00000016,$69000000,$0000E100,0,$0061C470
 DC.L	0,0,$0000001B,$F4800000,$00007080,0,$0030E470,0
 DC.L	0,$0000000D,$FB400000,$00003840,0,$0030F478,0,0
 DC.L	$00000006,$FDA00000,$000018A0,0,$00187438,0,0,$00000003
 DC.L	$7EFF8000,$00000C70,0,$001C7C38,0,0,$00000001,$BFFFC000
 DC.L	$000000A8,0,$000E3E38,0,0,0,$DFFFA000,$00000118
 DC.L	0,$00063A38,0,0,0,$202FD000,$0000081C,0
 DC.L	$00031A38,0,0,0,$1017C800,$0000008C,0,$00019F38
 DC.L	0,0,0,$080BC400,$0000000E,0,$0001DD38,0
 DC.L	0,0,$0007C200,$00400087,0,$0000CFB8,0,0
 DC.L	0,$0202C100,$00000003,$80000000,$00006FB8,0,0,0
 DC.L	$01014080,$00000001,$C0000000,$00003CF0,0,0,0,$0000A040
 DC.L	$00400000,$E0000000,$00001DF0,0,0,0,$00404020,$00200000
 DC.L	$70000000,$00000BD0,0,0,0,$00002010,0,$38000000
 DC.L	$00000AF0,0,0,0,0,$00200000,$1C000000,$00003F58
 DC.L	0,0,0,0,$00100000,$0E000000,$00007E3C,0
 DC.L	0,0,0,$000A0000,$07000000,$0000BC3C,0,0
 DC.L	$00800000,0,0,$03800000,$00003C3C,0,0,$00400000
 DC.L	0,$00020000,$01C00000,$00001C3E,0,0,0,0
 DC.L	$00014000,$00C40000,$00001C3C,0,$01000000,$00100000,$40000000,$00001000
 DC.L	$00540000,$00011C20,0,$00800000,$00080000,$20000000,$00005800,$00700000
 DC.L	$00011C00,$00000200,$00400000,$00040000,$10000000,$00000C00,$001C0000,$00011C00
 DC.L	$00000F00,0,$000A0000,0,$00000600,$00380000,$00002400,$00007F80
 DC.L	$00100000,$00070000,$04000000,$00000300,$01C00000,$05800000,$0003FF00,$00080000
 DC.L	$00028000,$02000000,$00000180,$00A00000,$1F000000,$000FFC00,$00040000,$0001C000
 DC.L	$01000000,$000000C0,0,$1F800000,$007FF000,$000A0000,$0000E000,$02800000
 DC.L	$00000060,0,$3E000060,$03FF8000,$00070000,$00017000,$01C00000,$00000030
 DC.L	$00000001,$EC000040,$1FFE0000,$00028000,$0000B800,$00A00000,$00000018,$00000001
 DC.L	$F80001C0,$FFF00000,$0001C000,$00011C00,$00700000,$0000000C,$0000000F,$F0000007
 DC.L	$FFC00000,$0000E000,$0000AE00,$00380000,$02000006,$0000001F,$60000C0F,$FF000000
 DC.L	$00017000,$00005700,$005C0000,$00000003,$0000000D,$4000180F,$F8000000,$0000B800
 DC.L	0,0,$00000001,$80000001,$8000780F,$E0000000,$00011C00,0
 DC.L	0,0,$C0000000,$0801F80F,0,$0000AE00,0,0
 DC.L	0,$6000000C,$F807F00F,0,$00005700,0,0,0
 DC.L	$3000000E,$7C0FF00F,0,$00002B80,0,0,0,$1800000E
 DC.L	$3E1FE00F,0,$00001FC0,0,0,0,$0C00000E,$3F7FC00E
 DC.L	0,$00000FE0,0,0,0,$0600001F,$9FFF0006,0
 DC.L	$000007F0,0,0,0,$03000015,$5FFC0006,0,$000003F8
 DC.L	0,0,0,$0180003F,$4FF44006,0,$000001E0,0
 DC.L	0,0,$00C0001E,$43FFC006,0,$000000E0,0,0
 DC.L	0,$0060000F,$00BEC004,0,$00000040,0,0,0
 DC.L	$0028000A,$803DC004,0,0,0,0,0,$00000007
 DC.L	$003F8004,0,0,0,0,$00000070,0,$003F8004
 DC.L	0,0,0,0,$00000280,0,0,0
Picplane2
 DC.L	0,0,0,0,0,0,0,0
 DC.L	0,0,0,0,0,0,$80000000,$00037ED0
 DC.L	0,0,0,0,0,$40000000,$0001BB48,0
 DC.L	0,0,0,0,$20000000,$0000DDA4,0,0
 DC.L	0,0,0,0,$00002ED2,0,$00500000,0
 DC.L	0,0,$08000000,$00000561,0,$00A80000,0,0
 DC.L	0,$04000000,$00000A30,$80000000,$00540000,0,0,0
 DC.L	$02000000,$00000158,$40000000,$002A0000,0,0,0,$05000000
 DC.L	$0000029C,0,$00150000,0,0,0,$03800000,$0000035E
 DC.L	$40000000,$000A8000,0,0,0,$01400000,$000001BC,$60000000
 DC.L	$00054000,0,$00780000,0,$00E00000,$000000DE,$30000000,$00038000
 DC.L	0,$00FF07C0,0,$00700000,$0000002C,$F8000000,$00015000,0
 DC.L	$00FB87E0,0,$00B80000,$00000016,$69000000,$0000E100,0,$007DC7F0
 DC.L	0,$005C0000,$0000001B,$F4800000,$00007080,0,$003EE7F0,0
 DC.L	$008E0000,$0000000D,$FB400000,$00003840,0,$0037F7F8,0,$00570000
 DC.L	$00000006,$FDA00000,$000018A0,0,$001F77B8,0,$002B8000,$00000003
 DC.L	$7EFF8000,$00000C70,0,$001FFDB8,0,$0015C000,$00000001,$BFFFC000
 DC.L	$000000A8,0,$000FBFF8,0,$000FE000,0,$DFFFA000,$00000118
 DC.L	0,$0006FBF8,0,$0007F000,0,$202FD000,$0000081C,0
 DC.L	$0003DAF8,0,$0003F800,0,$1017C800,$0000008C,0,$0001FFF8
 DC.L	0,$0001FC00,0,$080BC400,$0000000E,0,$0001FD78,0
 DC.L	$0000F000,0,$0007C200,$00400087,0,$0000DFF8,0,$00007000
 DC.L	0,$0202C100,$00000003,$80000000,$00007FB8,$00000010,$00002000,0
 DC.L	$01014080,$00000001,$C0000000,$00003CF0,$0000001C,0,0,$0000A040
 DC.L	$00400000,$E0000000,$00001DF0,$0000005C,0,0,$00404020,$00200000
 DC.L	$70000000,$00000BD0,$0000007C,0,0,$00002010,0,$38000000
 DC.L	$00000AF0,$00000068,0,0,0,$00200000,$1C000000,$00003F58
 DC.L	$00000068,0,0,0,$00100000,$0E000000,$00007FBC,$00000078
 DC.L	0,0,0,$000A0000,$07000000,$0000FDBC,$00000078,0
 DC.L	$00800000,0,0,$03800000,$00007DFC,$000000FA,0,$00400000
 DC.L	0,$00020000,$01C00000,$0000DFBE,$000000FE,0,0,0
 DC.L	$00014000,$00C40000,$0000FF3C,$C000007E,$01000000,$00100000,$40000000,$00001000
 DC.L	$00540000,$00019F2E,$600001BC,$00800000,$00080000,$20000800,$00005800,$00700000
 DC.L	$00011F37,$F00003B8,$00400000,$00040000,$10000400,$00000C00,$001C0000,$00011D1F
 DC.L	$F0000F70,0,$000A0000,$00000400,$00000600,$0038000C,$0008E6F7,$F0007FC0
 DC.L	$00100000,$00070000,$04000200,$00000300,$01C0000C,$C5B3E607,$E003FF00,$00080000
 DC.L	$00028000,$02000300,$00000180,$00A0000F,$FF163E0F,$C00FFC00,$00040000,$0001C000
 DC.L	$01000300,$000000C0,$0000001F,$FF9F971F,$807FF000,$000A0000,$0000E000,$02800980
 DC.L	$00000060,$0000001C,$FE0FFF7E,$03FF8000,$00070000,$00017000,$01C001C0,$00000030
 DC.L	$0000000D,$ED80EF7C,$1FFE0000,$00028000,$0000B800,$00A005C0,$00000018,$00000009
 DC.L	$FF0001F0,$FFF00000,$0001C000,$00011C00,$00700CE0,$0000000C,$0000000F,$FC000257
 DC.L	$FFC00000,$0000E000,$0000AE00,$003800F0,$02000006,$0000001F,$78000E7F,$FF000000
 DC.L	$00017000,$00005700,$005C0278,$00000003,$0000000D,$78001BFF,$F8000000,$0000B800
 DC.L	$00400000,$00000078,$00000001,$80000001,$F8007FEF,$E0000000,$00011C00,$00200000
 DC.L	$0000007C,0,$C0000001,$F801FFEF,0,$0000AE00,$00100000,$0000013C
 DC.L	0,$6000000C,$F807FFFF,0,$00005700,$00280000,$0000003C,0
 DC.L	$3000000E,$7C0FFFFF,0,$00002B80,$001C0000,$0000009C,0,$1800000E
 DC.L	$3E1FEDFF,0,$00001FC0,$000A0000,$0000001C,0,$0C00000E,$3F7FDDFE
 DC.L	0,$00000FE0,$00060000,$0000001C,0,$0600001F,$9FFF1DF6,0
 DC.L	$000007F0,$00020000,$0000000C,0,$03000015,$5FFC1FFE,0,$000003F8
 DC.L	$00040000,$0000000C,0,$0180003F,$4FF45FFE,0,$000001E0,$00020000
 DC.L	$0000040C,0,$00C0001E,$43FFDFFE,0,$000000E0,$00040000,$00000004
 DC.L	0,$0060000F,$00FEDFFC,0,$00000040,$00020000,$00000004,0
 DC.L	$0028000A,$807DDFFC,0,0,0,$00000200,0,$00000007
 DC.L	$007FBFFC,0,0,0,0,$00000070,0,$007FBFFC
 DC.L	0,0,0,0,$00000280,0,0,0

Deltas:
	dc.w	%0000111111110000	;Delta 0
	dcb.w	63,0

	dc.w	%0000111100000000	;Delta 1
	dc.w	%0000000011110000
	dcb.w	62,0

	dc.w	%0000110000000000	;Delta 2
	dc.w	%0000001111000000
	dc.w	%0000000000110000
	dcb.w	61,0

	dc.w	%0000110000000000	;Delta 3
	dc.w	%0000001100000000
	dc.w	%0000000011000000
	dc.w	%0000000000110000
	dcb.w	60,0

	dc.w	%0000100000000000	;Delta 4
	dc.w	%0000011000000000
	dc.w	%0000000110000000
	dc.w	%0000000001100000
	dc.w	%0000000000010000
	dcb.w	59,0

	dc.w	%0000100000000000	;Delta 5
	dc.w	%0000011000000000
	dc.w	%0000000100000000
	dc.w	%0000000010000000
	dc.w	%0000000001100000
	dc.w	%0000000000010000
	dcb.w	58,0

	dc.w	%0000100000000000	;Delta 6
	dc.w	%0000010000000000
	dc.w	%0000001000000000
	dc.w	%0000000110000000
	dc.w	%0000000001000000
	dc.w	%0000000000100000
	dc.w	%0000000000010000
	dcb.w	57,0

	dc.w	%0000100000000000	;Delta 7
	dc.w	%0000010000000000
	dc.w	%0000001000000000
	dc.w	%0000000100000000
	dc.w	%0000000010000000
	dc.w	%0000000001000000
	dc.w	%0000000000100000
	dc.w	%0000000000010000
	dcb.w	56,0

	dc.w	%0000100000000000	;Delta 8
	dc.w	%0000010000000000
	dc.w	%0000001000000000
	dc.w	%0000000100000000
	dc.w	%0000000100000000
	dc.w	%0000000010000000
	dc.w	%0000000001000000
	dc.w	%0000000000100000
	dc.w	%0000000000010000
	dcb.w	55,0

	dc.w	%0000100000000000	;Delta 9
	dc.w	%0000010000000000
	dc.w	%0000001000000000
	dc.w	%0000000100000000
	dc.w	%0000000100000000
	dc.w	%0000000010000000
	dc.w	%0000000010000000
	dc.w	%0000000001000000
	dc.w	%0000000000100000
	dc.w	%0000000000010000
	dcb.w	54,0

	dc.w	%0000100000000000	;Delta 10
	dc.w	%0000010000000000
	dc.w	%0000001000000000
	dc.w	%0000001000000000
	dc.w	%0000000100000000
	dc.w	%0000000100000000
	dc.w	%0000000100000000
	dc.w	%0000000010000000
	dc.w	%0000000001000000
	dc.w	%0000000000100000
	dc.w	%0000000000010000
	dcb.w	53,0

	dc.w	%0000100000000000	;Delta 11
	dc.w	%0000010000000000
	dc.w	%0000010000000000
	dc.w	%0000001000000000
	dc.w	%0000001000000000
	dc.w	%0000000100000000
	dc.w	%0000000010000000
	dc.w	%0000000010000000
	dc.w	%0000000001000000
	dc.w	%0000000000100000
	dc.w	%0000000000100000
	dc.w	%0000000000010000
	dcb.w	52,0

	dc.w	%0000100000000000	;Delta 12
	dc.w	%0000010000000000
	dc.w	%0000010000000000
	dc.w	%0000001000000000
	dc.w	%0000001000000000
	dc.w	%0000000100000000
	dc.w	%0000000100000000
	dc.w	%0000000010000000
	dc.w	%0000000010000000
	dc.w	%0000000001000000
	dc.w	%0000000000100000
	dc.w	%0000000000100000
	dc.w	%0000000000010000
	dcb.w	51,0

	dc.w	%0000100000000000	;Delta 13
	dc.w	%0000010000000000
	dc.w	%0000010000000000
	dc.w	%0000001000000000
	dc.w	%0000001000000000
	dc.w	%0000000100000000
	dc.w	%0000000100000000
	dc.w	%0000000010000000
	dc.w	%0000000010000000
	dc.w	%0000000001000000
	dc.w	%0000000001000000
	dc.w	%0000000000100000
	dc.w	%0000000000100000
	dc.w	%0000000000010000
	dcb.w	50,0

	dc.w	%0000100000000000	;Delta 14
	dc.w	%0000100000000000
	dc.w	%0000010000000000
	dc.w	%0000010000000000
	dc.w	%0000001000000000
	dc.w	%0000001000000000
	dc.w	%0000000100000000
	dc.w	%0000000100000000
	dc.w	%0000000010000000
	dc.w	%0000000010000000
	dc.w	%0000000001000000
	dc.w	%0000000001000000
	dc.w	%0000000000100000
	dc.w	%0000000000100000
	dc.w	%0000000000010000
	dcb.w	49,0

	dc.w	%0000100000000000	;Delta 15
	dc.w	%0000100000000000
	dc.w	%0000010000000000
	dc.w	%0000010000000000
	dc.w	%0000001000000000
	dc.w	%0000001000000000
	dc.w	%0000000100000000
	dc.w	%0000000100000000
	dc.w	%0000000010000000
	dc.w	%0000000010000000
	dc.w	%0000000001000000
	dc.w	%0000000001000000
	dc.w	%0000000000100000
	dc.w	%0000000000100000
	dc.w	%0000000000010000
	dc.w	%0000000000010000
	dcb.w	48,0

patt1:
	dc.w	%1010101010101010
	dc.w	%0101010101010101
patt2:	dc.w	0,0
	
;*********** Leertabellen (spter im BSS-Hunk) ***********************
		section	1,BSS
datas:
intsave:	rs.l	1
gadsave:	rs.l	1
grafsave:	rs.l	1
_dos		rs.l	1
WinHandle:	rs.l	1
Port:		rs.l	1
MSGPort:	rs.l	1
AN_Structadr:	rs.l	1
Handle:		rs.l	1
Menuadr:	rs.l	1
Mysignal	rs.l	1
flagsadr	rs.l	1
My2ndsignal	rs.l	1
Mytask		rs.l	1
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
scrolmerk:	rs.w	1
addi		rs.w	1
word8		rs.w	1	;Wort fr Absturz bei Modifikation
counter		rs.w	1
fontatt:	rs.l	1	;Fontattr Strukturadresse (entweder die des
				;Screens oder die eigene,wenn Screenfont zu
				;gro)
vi:		rs.l	1	;Visualinfo

mytags:		rs.l	20*2
myzoom:		rs.w	3
myhoehe2:	rs.w	1
myhoehe1:	rs.w	1
bpr:		rs.w	1	;Bytes pro Zeile im Window

MY_Easystruct:	rs.l	1	;EASY-Request
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1
MY_Bitmap:	rs.b	8
map1:		rs.l	1
map2:		rs.l	1
		rs.l	6
Mymenus:	rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.l	1
Nulls:		rs.l	8
RealNulls:	rs.l	8
almostFulls:	rs.l	8
Fulls:		rs.l	8
		rs.w	18	;Freiraum (wichtig!)
Anmerk:		rs.w	An_num	;Anzahl der Balken
		rs.w	18	;Freiraum
Anpeek:		rs.l	An_num	;Spitzenpegelanzeigemerkfeld

Picmerk	rs.w	1
intmerk	rs.w	1
Intset	rs.w	1
inter:	rs.l	2
	rs.b	1	;2
	rs.b	1	;127
	rs.l	3

Mymessage:	rs.b	UM_sizeof	;Intuimessagestruktur
Scrolpos:	rs.w	1
Scroloffset:	rs.w	1
offx		rs.w	1
AN_Struct:	rs.b	UPS_sizeof
An_modenr	rs.b	1
Savemo:		rs.b	1
AN_Peekaha	rs.b	1
Messagesent:	rs.b	1
Picset		rs.b	1
Merkstruct	rs.b	1		;Struktur schon vorher nicht da ?
DatasLen:	rs.w	0
		ds.b	DatasLen

	section	3,data_c
mode0Planes
	dc.w	$0000,$0000,$0000,$0010,$0000,$0010,$2000,$8090
	dc.w	$1011,$4110,$082A,$2210,$0444,$1410,$0280,$0810
	dc.w	$0100,$0010,$0000,$0010,$0000,$0010,$0000,$0010
	dc.w	$0000,$0010,$FFFF,$FFF0
	dc.w	$FFFF,$FFF0,$8000,$0000,$8000,$0000,$9FFF,$7F00
	dc.w	$8FEE,$3E00,$87C4,$1C00,$8380,$0800,$8100,$0000
	dc.w	$8000,$0000,$8000,$0000,$8000,$0000,$8000,$0000
	dc.w	$8000,$0000,$0000,$0000
mode1I1Data
	dc.w	$0000,$0000,$0000,$0010,$0000,$0010,$0000,$0010
	dc.w	$0000,$0010,$0100,$0010,$0280,$0810,$0444,$1410
	dc.w	$082A,$2210,$1011,$4110,$2000,$8090,$0000,$0010
	dc.w	$0000,$0010,$FFFF,$FFF0
	dc.w	$FFFF,$FFF0,$8000,$0000,$8000,$0000,$8000,$0000
	dc.w	$8000,$0000,$8000,$0000,$8100,$0000,$8380,$0800
	dc.w	$87C4,$1C00,$8FEE,$3E00,$9FFF,$7F00,$8000,$0000
	dc.w	$8000,$0000,$0000,$0000
Mode2i1data
	dc.w	$0000,$0000,$0000,$0008,$0000,$0008,$0000,$0008
	dc.w	$0000,$0008,$0000,$0008,$0000,$0008,$0000,$0008
	dc.w	$0000,$0008,$0000,$0008,$0000,$0008,$0000,$0008
	dc.w	$0000,$0008,$FFFF,$FFF8
	dc.w	$FFFF,$FFF8,$8000,$0000,$8000,$0000,$8000,$0000
	dc.w	$8000,$0000,$8080,$0000,$81C0,$0400,$8362,$0E00
	dc.w	$8637,$1B00,$8C1D,$B180,$8808,$E0C0,$8000,$0000
	dc.w	$8000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0080,$0000,$0140,$0400,$0222,$0A00
	dc.w	$0415,$1100,$0808,$A080,$0000,$4040,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000
mode3I1Data
	dc.w	$0000,$0000,$0000,$0008,$0000,$0008,$0000,$0008
	dc.w	$0000,$0008,$0000,$0008,$0000,$0008,$0000,$0008
	dc.w	$0000,$0008,$0000,$0008,$0000,$0008,$0000,$0008
	dc.w	$0000,$0008,$FFFF,$FFF8
	dc.w	$FFFF,$FFF8,$8000,$0000,$8808,$E0C0,$8C1D,$B180
	dc.w	$8637,$1B00,$8362,$0E00,$81C0,$0400,$8080,$0000
	dc.w	$8000,$0000,$8000,$0000,$8000,$0000,$8000,$0000
	dc.w	$8000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$4040,$0808,$A080
	dc.w	$0415,$1100,$0222,$0A00,$0140,$0400,$0080,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000
mode4I1Data
	dc.w	$0000,$0000,$0000,$0008,$0000,$0008,$0010,$4008
	dc.w	$0100,$0408,$0800,$0088,$0100,$0408,$0008,$8008
	dc.w	$0020,$2008,$0200,$0208,$0020,$2008,$0000,$0008
	dc.w	$0000,$0008,$FFFF,$FFF8
	dc.w	$FFFF,$FFF8,$8000,$0000,$8000,$0000,$800F,$8000
	dc.w	$80FF,$F800,$87FF,$FF00,$80FF,$F800,$8007,$0000
	dc.w	$801F,$C000,$81FF,$FC00,$801F,$C000,$8000,$0000
	dc.w	$8000,$0000,$0000,$0000
mode5I1Data
	dc.w	$0000,$0000,$0000,$0008,$0080,$0008,$0140,$0408
	dc.w	$0222,$0A08,$0415,$1108,$0808,$A088,$0808,$A088
	dc.w	$0415,$1108,$0222,$0A08,$0140,$0408,$0080,$0008
	dc.w	$0000,$0008,$FFFF,$FFF8
	dc.w	$FFFF,$FFF8,$8000,$0000,$8000,$0000,$8080,$0000
	dc.w	$81C0,$0400,$83E2,$0E00,$87F7,$1F00,$87F7,$1F00
	dc.w	$83E2,$0E00,$81C0,$0400,$8080,$0000,$8000,$0000
	dc.w	$8000,$0000,$0000,$0000
UntitledI1Data:
	dc.w	$0000,$0000,$0000,$0010,$0000,$0010,$00E0,$0010
	dc.w	$00E0,$01D0,$07FC,$01D0,$07FC,$0FD0,$3FFF,$8FD0
	dc.w	$3FFF,$8FD0,$3FFF,$FFD0,$3FFF,$FFD0,$0000,$0010
	dc.w	$0000,$0010,$FFFF,$FFF0
	dc.w	$FFFF,$FFF0,$8000,$0000,$8000,$0000,$80E0,$0000
	dc.w	$80E0,$01C0,$87FC,$01C0,$87FC,$0FC0,$BFFF,$8FC0
	dc.w	$BFFF,$8FC0,$BFFF,$FFC0,$BFFF,$FFC0,$8000,$0000
	dc.w	$8000,$0000,$0000,$0000
	end
