*****************************************************************************
**                                                                         **
** Engine: Amplifiermanager                                                **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 
	;
	incdir	include:
	include	exec/exec_lib.i
	include	exec/libraries.i
	include	exec/lists.i
	include	exec/types.i
 	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	intuition/classusr.i
	include	intuition/imageclass.i
	include	intuition/gadgetclass.i
	include	graphics/displayinfo.i
	include	graphics/gfxbase.i
	include	graphics/graphics_lib.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	dos/dos_lib.i
	include	libraries/dos.i
;	include	libraries/reqtools.i
;	include	libraries/reqtools_lib.i
	include	libraries/xpk.i
	include	misc/eagleplayer.i
	include	misc/eagleplayerengine.i
	include	misc/BuggsMacros.i
	;
	section	0,code
	;
ver		macro
		dc.b	`0.95`
		endm
EngineVer	macro
		dc.w	0,95		;eus_version,revision
		endm
date		macro
		dc.b	`07-Dec-96`
		endm
EngineDate	macro
		dc.b	07,12
		dc.w	1996		;EUS_Creatordate
		endm


userprogram = 1
debug 	=	0
test	=	0

extra_info	=	48
Project0Width = 472+extra_info		;Windowbreite (default bei Topaz 8)
Project0Height = 108
Project0Left = 28
Project0Top = 29
ZoomWidth = 128+24*3+40

GD_Listview                            EQU    0
GD_Up                                  EQU    1
GD_Down                                EQU    2
GD_Del                                 EQU    3
GD_Info                                EQU    4
GD_Sort                                EQU    5
GD_Add                                 EQU    6
GD_exchg                               EQU    7
GD_Show                                EQU    8
GD_Hide                                EQU    9
Project0_CNT	EQU	10

Gadgets_InReihe		EQU	5	;Wieviele Gadgets horizontal nebeneinander
Gadget_Space		EQU	2	;2 Pixel Abstand zwischen den Gadgets


 structure	my_liststruct,0
	struct	ML_Node,ln_size
	struct	ML_Nodename,100
	Label	ML_Sizeof

 structure	my_Textstruct,0
	struct	TML_Node,ln_size
	LONG	TML_Size			;Size
	LABEL	TML_Text


begin
****************** Workbench Startup **********************************
	bra.w	fang
	EUSN_Identifier
	dc.l	0		;eus_next

	ifne	debug
	dc.w	-2
	else
	dc.w	0		;eus_Usernr
	endc
MyEPBase
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;eus_unused3
	dc.l	Tagliste	;eus_unused4
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	0		;eus_tickflags
	dc.l	USMB_WaitPointer!USMB_Ampliferschanged!USMB_KillModule!USMB_Zipwin!USMB_ChangeConfig!USMB_newsong!USMB_NewModule;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname	;eus_CName
	dc.l	myinfo
	dc.w	37		;eus_Kickstart
	dc.l	Eagleversion	;eus_EPVersion
	EngineVer
	dc.l	MyUsername	;eus_username
	dc.w	Project0left	;eus_winx
	dc.w	Project0top	;eus_winy
	dc.w	EUSB_openwin	;window opened
	dc.l	0		;EUS_Special
	dc.l	0		;EUS_Special2
ZoomX		equ	EUS_Special2
ZoomY		equ	EUS_Special2+2
ZoomONOFF	equ	EUS_Special
Sysfontonoff	equ	EUS_Special+1
	dc.l	0		;EUS_Special3
	EngineDate
	dc.b	0		;EUS_Priority
	dc.b	EUTY_Amplifiermanager	;EUS_Tyype
	dc.w	0
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

		ifne	(*-begin)-EUS_SizeOF
		Aber Hallo
		endc

	dc.b	`$VER: Eagleplayer Amplifier Manager `
	ver
	dc.b	` `
	date
	dc.b	0
	even


Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Amplifiermanager
		*dc.l	EUT_AttnFlags,1<<6!1<<3
		dc.l	0

Fang
	move.l	4.w,a6

	lea	datas,a5
	move.l	a5,a0
	move.w	#dataslen-1,d0
.clr	move.b	#0,(a0)+
	dbf	d0,.clr

	lea	begin(pc),a0
	move.b	Sysfontonoff(a0),d1
	and.b	#$10,d1
	move.b	d1,onsysfont(A5)
	move.b	ZoomONOFF(a0),ZoomState(A5)
	move	Eus_Winx(a0),WinPosX(A5)
	move	Eus_Winy(a0),WinPosY(a5)
	move	ZoomX(a0),ZoomPosx(a5)
	move	ZoomY(a0),Zoomposy(A5)

	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;Signal allokieren
	tst.l	d0
	blt	NoSignal
	move.l	d0,mysignal(a5)

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)
	move.l	d0,mytask(a5)

	lea	dos(pc),a1
	moveq	#33,d0			;Brauchen DOS V1.2,fr Message,falls
	jsr	_LVOopenlibrary(a6)	;Start von 1.2/1.3 aus
	tst.l	d0
	beq	NODOS
	move.l	d0,_dos(a5)

	lea	MsgPort1(a5),a4		;MSG Port Struktur initialisieren
	bsr	MakeMsgPort
	tst.l	d0
	blt	NoPort
	move.l	a4,MsgPort(A5)

	lea	MsgPort2(a5),a4		;MSG Port Struktur initialisieren
	bsr	MakeMsgPort
	tst.l	d0
	blt	NoPort2
	move.l	a4,AgainAPort(A5)

	lea	int(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)
	tst.l	d0
	beq	NOINT
	move.l	d0,intsave(a5)

	lea	graf(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)
	tst.l	d0
	beq	NOGraf
	move.l	d0,grafsave(a5)

	lea	gad(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,gadsave(a5)
	beq	NOGADTO

	moveq	#0,d7

	lea	list(a5),a0
	newlist	a0
	lea	list2(a5),a0
	newlist	a0

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse haben mchte
	blt	endme	;Fehler aufgetreten

	ifne	debug
	move	#2000,d7
.wart
	move.l	MyEPBase(pc),d1
	bne.s	.got

	moveq	#4,d1
	move.l	_Dos(a5),a6
	jsr	_LVODelay(a6)

	dbf	d7,.wart
.got
	endc

	bsr	UpdateNPList

	bsr	setint
	bsr	HandleActions		;Auf Usereingaben reagieren
	bsr	remint

	bsr	deletelist		;aktuelle Liste killen
	bsr	deletelist2		;Info Liste killen
lastmess
	tst.l	d7
	blt.s	endme
	bsr	sendlastmessage
endme
	bsr	closedownwin
	bsr	closedownscreen
nopubscreen
Nogadgets
nowin
	move.l	gadsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(A6)
	clr.l	gadsave(A5)
nogadto
	move.l	grafsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(a6)
NoGraf
	move.l	intsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(a6)
noint
	move.l	4,a6
	lea	msgport2(a5),a2
	move.b	mp_sigbit(a2),d0
	ext.w	d0
	ext.l	d0
	jsr	_LVOfreesignal(a6)
NoPort2
	move.l	4,a6
	lea	msgport1(a5),a2
	move.b	mp_sigbit(a2),d0
	ext.w	d0
	ext.l	d0
	jsr	_LVOfreesignal(a6)
NoPort
	move.l	4,a6
	move.l	_dos(a5),a1
	jsr	_LVOcloselibrary(a6)
nodos
Endprog
	move.l	mysignal(a5),d0
	move.l	4,a6
	jsr	_LVOfreesignal(a6)
NoSignal
	moveq	#0,d0
	rts

MakeMsgPort
					;Message Port initialisieren
	move.l	4.w,a6
	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;MSG Signal zuweisen lassen
	tst.l	d0
	blt	.nosignal2		;Fehler

	move.b	#nt_msgport,ln_type(a4)
	move.b	#0,ln_pri(a4)
	move.b	#pa_signal,mp_flags(a4)
	move.b	d0,mp_sigbit(a4)

	move.l	mytask(a5),mp_sigtask(a4);mp_SigTask

	lea	mp_msglist(a4),a1
	Newlist	a1			;macro in Lists.i

	moveq	#0,d0
.nosignal2				;Fehler
	rts
********************************************************************
*                  Init & Open Window                              *
********************************************************************
Openwin
	tst.l	winhandle(A5)
	bne.w	.endme

	bsr	UpdateNPList

	move.w	#checkit!menutoggle,d0
	move.b	onsysfont(A5),d1
	and.b	#$10,d1
	beq.s	.nosys
	or.w	#checked,d0
.nosys
	move.w	d0,Sysindicator

	clr.l	port(A5)

	move.l	intsave(a5),a6
	bsr	Setupscreen		;Public Screen holen
	bne	.Endme
	bsr	SetUpWin		;Fenster ffnen
	tst.l	d0
	bne	.Endme

	bsr	remlist

	*--- Jetzt auf laufenden Amplifier setzen --*
	move.w	#1,num_selected(A5)

	bsr	readdlist
	bsr	UpdateInfoGadget

	move.l	Winhandle(a5),a0
	move.l	wd_userport(a0),a0	;User Port
	move.l	a0,port(a5)
.endme
	rts
ClearWin:
	move.l	grafsave(a5),a6
	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#0,d0
	jsr	_LVOsetapen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5

	move.l	winhandle(A5),a1
	move.w	wd_width(A1),d2		;x2
	moveq	#0,d0
	move.b	wd_borderright(a1),d0
	sub.w	d0,d2

	move.w	wd_height(a1),d3
	moveq	#0,d0
	move.b	wd_borderbottom(a1),d0
	sub.w	d0,d3

	move.l	wd_rport(a1),a1

	move.w	offx(a5),d0		;x1
	move.w	offy(A5),d1		;y1
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOrefreshwindowframe(A6)
	rts
*************** Window & Screen freigeben *************************
Closewin
	push	all

	lea	begin(pc),a2
	move.w	WinPosX(a5),eus_winx(a2)	;Save Windowpostion
	move.w	WinPosY(a5),eus_winy(a2)

	move	ZoomposX(a5),Zoomx(A2)
	move	ZoomposY(A5),Zoomy(a2)

	move.b	Zoomstate(a5),ZoomONOFF(a2)
	move.b	Onsysfont(A5),Sysfontonoff(a2)

	bsr	closedownwin
	bsr	closedownscreen
	pop	all
	rts
********************************************************************
*                  Init Message Struktur                           *
********************************************************************
Sendfirstmessage
	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.error

	move.l	d0,a0			;Portadresse

	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	#-1,d5
	move.w	#USclass_Newuserprg,d6

	ifne	debug

	lea	Mymessage(a5),a1	;Messageadresse
	moveq	#um_sizeof>>1-1,d0
.clr
	clr.w	(a1)+
	dbf	d0,.clr

	lea	Mymessage(a5),a1	;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2
	move.l	a2,um_result(a1)
	move.w	#-2,UM_UserNr(a1)
	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jsr	_LVOputmsg(a6)

	else
	bsr	sendmess
	endc

	move.b	#1,messagesent(a5)

	moveq	#0,d7
	rts
.error
	moveq	#-1,d7
	rts
*******************************************************************************
sendmess:
	lea	Mymessage(a5),a1	;Messageadresse
	moveq	#um_sizeof>>1-1,d0
.clr
	clr.w	(a1)+
	dbf	d0,.clr

	lea	Mymessage(a5),a1	;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jmp	_LVOputmsg(a6)
******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
Sendlastmessage:
	move.l	4,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.w	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3

	lea	Mymessage(a5),a1	;Messageadresse
	moveq	#um_sizeof>>1-1,d0
.clr
	clr.w	(a1)+
	dbf	d0,.clr

	lea	Mymessage(a5),a1		;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)	;Lnge
	move.b	#nt_message,ln_type(a1) 	;Typ: Message
	clr.l	ln_pred(A1)
	clr.l	ln_succ(A1)

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)	;Typ der Message

	move.l	d3,mn_replyport(a1)		;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)		;Portadresse fr EaglePlayer
	clr.l	UM_TaskAdr(a1)		;Taskadresse
	clr.l	UM_Signal(a1)		;Signalnummer
	move.w	#Usclass_exit,UM_class(a1)	;Messageinhalt
				;z.B. USClass_Closewin,USclass_Newuserprg

	move.b	#1,messagesent(a5)		;merken,da Nachricht gesendet

	move.l	4,a6
	jsr	_LVOputmsg(a6)		;Nachricht losschicken
.wait					;auf Rckmeldung warten
	move.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	move.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
*******************************************************************
*      Public Screen ranholen und Visual Info anfordern           *
*******************************************************************
SetupScreen
	move.l	Intsave(a5),a6
	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep
	move.l	d0,a0
	move.l	EPG_Pubscreen(A0),d0
	move.w	EPG_Wordreserved7(A0),word7(A5)
.noep
	move.l	d0,a0
	jsr	_LVOLockPubScreen(a6)
	move.l	d0,MyPubscreen(A5)
	tst.l	d0
	beq.s	.error

	move.l	mypubscreen(A5),a0
	move.l	Gadsave(A5),a6
	suba.l	a1,a1
	jsr	_LVOGetVisualInfoA(a6)
	move.l	d0,Vi(A5)
	tst.l	d0
	beq.s	.error     
	moveq	#0,d0
	rts
.error
	moveq	#-1,d0
	rts
*******************************************************************
*      Public Screen ranholen und Visual Info anfordern           *
*******************************************************************
CloseDownScreen:
	move.l	Gadsave(a5),a6
	move.l	Vi(A5),d0
	beq.s	.novi
	move.l	d0,a0
	jsr	_LVOFreeVisualInfo(a6)
	clr.l	Vi(A5)
.novi
	move.l	Intsave(A5),a6

	suba.l	a0,a0
	move.l	Mypubscreen(A5),d0
	beq.s	.nopub
	move.l	d0,a1
	jsr	_LVOUnlockPubScreen(a6)

	clr.l	Mypubscreen(A5)
.nopub
	rts
GetFont
	tst.b	onsysfont(A5)
	beq.s	.stand

	move.l	grafsave(A5),a6
	lea.l	MyRastPort(a5),a3
	move.l	a3,a1
	jsr	_LVOInitrastport(A6)
	move.l	a3,a1
	lea.l	Attr(a5),a0
	jsr	_LVOAskFont(A6)
	lea.l	Attr(a5),a0
	jsr	_LVOopenfont(A6)
	move.l	d0,fontadr(A5)
	beq.s	.stand
	move.l	d0,a1
	rts
.stand
	move.l	mypubscreen(A5),a1
	lea.l	sc_RastPort(a1),a1
	move.l	rp_Font(a1),a1
	rts
ComputeFont:
	bsr	GetFont

	lea.l	Attr(a5),a0
	move.l	a0,Font(A5)

	move.l  LN_NAME(a1),ta_Name(a0)
	move.w  tf_YSize(a1),ta_YSize(a0)
	move.w  tf_XSize(a1),FontX(A5)
	move.w  tf_YSize(a1),FontY(A5)

	move.l	fontadr(A5),d0
	beq.s	.nofree
	move.l	d0,a1
	move.l	grafsave(A5),a6
	jsr	_LVOclosefont(A6)
.nofree
	move.l	mypubscreen(A5),a0
	move.b	sc_WBorLeft(a0),d0
	ext.w	d0
	move.w	d0,OffX(A5)

	move.l	sc_font(A0),a1
	move.w	ta_YSize(a1),d0

	addq.w	#1,d0
	move.b	sc_WBorTop(a0),d1
	ext.w	d1
	add.w	d1,d0
	move.w	d0,OffY(A5)

	tst.w	d2
	beq.s	CompDone
	tst.w	d3
	beq.s	CompDone
	move.w	d2,d0
	bsr	ComputeX

	add.w   OffX(A5),d0
	move.b	sc_WBorRight(a0),d1
	ext.w	d1
	add.w	d1,d0
	cmp.w	sc_Width(a0),d0
	bhi.s	UseTopaz
	move.w	d0,d2

	move.w	d3,d0
	bsr	ComputeY
	add.w	OffY(a5),d0
	move.b	sc_WBorBottom(a0),d1
	ext.w	d1
	add.w	d1,d0
	cmp.w	sc_Height(a0),d0
	bhi.s	UseTopaz
	move.w	d0,d3
CompDone:
	rts
UseTopaz:
	move.l	Font(A5),a0
	move.l	#TopazName,ta_Name(a0)
	move.w	#8,FontY(A5)
	move.w	#8,FontX(a5)
	move.w	#8,ta_YSize(a0)
	rts
ComputeX:
	move.l	d1,-(sp)
	move.w	FontX(a5),d1
	bra.s	ComputeItX
ComputeY:
	move.l	d1,-(sp)
	move.w	FontY(A5),d1
	mulu	d1,d0
	addq.w	#4,d0
	lsr.w	#3,d0
	move.l	(sp)+,d1
	rts
ComputeItX:
	mulu	d1,d0
	addq.w	#4,d0
	lsr.w	#3,d0
	move.l	(sp)+,d1
	rts

*--------- Hookfunktion, um aktuellen Amplifier  farblich hervorzuheben ------*
*---------------- derzeit noch kein Support fr "disabled"-Gadgets -----------*
*benutzte Globals:
* - grafsave+datas = Graphics Base
*
*Erkennung, ob Zeile hervorzuheben oder nicht:
* - EPG_ActiveAmplifier heranziehen und EUS_Creator vergleichen
*
	;a0:Hook
	;a1:Message
	;a2:Node
my_hook
	push	d1-a6

	move.l	lvdm_MethodID(a1),d1
	cmp.l	#LV_Draw,d1
	bne.w	.hi
	move.l	a1,a4
	move.l	lvdm_RastPort(a4),d7
	beq.w	.hi

	move.l	lvdm_DrawInfo(A4),d0
	beq.w	.hi
	move.l	d0,a1
	move.l	dri_Pens(a1),a1

	move.l	ln_name(A2),a5
	move.l	MyEPBase(pc),d0
	beq.s	.textpen
	move.l	d0,a0
	move.l	EPG_ActiveAmplifier(a0),d0
	beq.s	.textpen
	move.l	d0,a0
	move.l	EUS_username(a0),d0
	beq.s	.textpen
	move.l	d0,a0

	move.l	a5,a6
	cmp.b	#`(`,(a6)+
	beq.s	.lop
	subq.l	#1,a6
.lop
	move.b	(a6)+,d0
	cmp.b	#`)`,d0
	beq.s	.highpen
	cmp.b	(A0)+,d0
	bne.s	.textpen
	tst.b	d0
	bne.s	.lop
.highpen
	move	highlighttextpen*2(a1),d0
	bra.s	.high
.textpen
	move	textpen*2(a1),d0
.high
	move	backgroundpen*2(a1),d6

	cmp.l	#LVR_SELECTED,lvdm_State(a4)
	bne.s	.normalBG

	move	FILLPEN*2(a1),d6
;	move	Filltextpen*2(a1),d0
.normalBG
	move	d6,d1
	moveq	#RP_Jam1,d2
	move.l	d7,a1
	move.l	grafsave+datas,a6			;Graphics Base
	jsr	_LVOsetabpendrmd(A6)

	move.w	lvdm_bounds+ra_minx(a4),d0
	move.w	lvdm_bounds+ra_miny(a4),d1
	move.l	d7,a1
	add	rp_TxBaseline(a1),d1
	jsr	_LVOMove(A6)

	move.l	d7,a1
	moveq	#RP_Jam2,d0
	jsr	_LVOsetdrmd(A6)

	move.w	lvdm_bounds+ra_maxx(a4),d5		;Begrenzung des Textes
	sub	lvdm_bounds+ra_minx(a4),d5		;auf Breite des
	blt	.hi					;Listviews, solange

	move.l	a5,a0					;Text
	moveq	#-1,d3					;bis der Text passt
.lop1
	addq	#1,d3
	tst.b	(a0)+
	bne.s	.lop1
.charloop
	move.l	d7,a1
	move.l	a5,a0					;Text
	move.w	d3,d0
	jsr	_LVOtextlength(A6)
	cmp.w	d5,d0
	blt.s	.ok
	subq.w	#1,d3
	bra.s	.charloop
.ok
	move	d0,d4
	move.w	d3,d0
	move.l	a5,a0					;Text
	move.l	d7,a1
	jsr	_LVOtext(A6)

	move.l	d7,a1
	move	d6,d0
	move	d6,d1
	moveq	#0,d2
	jsr	_LVOsetabpendrmd(A6)

	move	lvdm_bounds+ra_minx(a4),d0
	add	d4,d0
	move	lvdm_bounds+ra_miny(a4),d1
	move	lvdm_bounds+ra_maxx(a4),d2
	move	lvdm_bounds+ra_maxy(a4),d3
	move.l	d7,a1
	jsr	_LVORectfill(a6)	;freien Platz nach dem Text lschen
	
	pop	d1-a6
	moveq	#LVCB_OK,d0
	rts
.hi
	pop	d1-a6
	moveq	#LVCB_Unknown,d0
	rts
CreateGadgets
	move.l	Gadsave(A5),a6
	lea.l	Project0GList(a5),a0
	jsr	_LVOCreateContext(a6)
	move.l	d0,a3
	tst.l	d0
	beq.w	.Project0CError

	moveq	#0,d3
	lea.l	Project0GTags(pc),a4
.Project0GL:
	move.l	4,a6
	lea.l	Project0NGads(pc),a0
	move.l	d3,d0
	mulu	#gng_SIZEOF,d0
	add.l	d0,a0
	lea.l	BufNewGad(a5),a1
	moveq	#gng_SIZEOF,d0
	jsr	_LVOCopyMem(a6)
	lea.l	BufNewGad(a5),a0
	move.l	Vi(a5),gng_VisualInfo(a0)
	move.l	Font(a5),gng_TextAttr(a0)

	move.w	gng_LeftEdge(a0),d0
	bsr	computex
	add.w	OffX(a5),d0
	move.w	d0,gng_LeftEdge(a0)

	move.w	gng_TopEdge(a0),d0
	bsr	computey
	add.w	OffY(a5),d0
	move.w	d0,gng_TopEdge(a0)

	move.w	gng_Width(a0),d0
	bsr	computex
	move.w	d0,gng_Width(a0)

	move.w	gng_Height(a0),d0
	bsr	computey
	move.w	d0,gng_Height(a0)

	move.l	Gadsave(a5),a6
	lea.l	Project0GTypes(pc),a0
	moveq	#0,d0
	move.l	d3,d1
	asl.l	#1,d1
	add.l	d1,a0
	move.w	(a0),d0
	move.l	a3,a0
	lea.l	BufNewGad(a5),a1
	move.l	a4,a2
	jsr	_LVOCreateGadgetA(a6)
	tst.l	d0
	bne.s	.Project0COK
	bra	.Project0CError
.Project0COK:
	move.l	d0,a3
	move.l	d3,d0
	asl.l	#2,d0
	lea.l	Project0Gadgets(a5),a0
	add.l	d0,a0
	move.l	a3,(a0)
.Project0TL:
	tst.l	(a4)
	beq.s	.Project0DN
	addq.w	#8,a4
	bra.s	.Project0TL
.Project0DN:
	addq.w	#4,a4
	addq.w	#1,d3
	cmp.w	#Project0_CNT,d3
	bmi	.Project0GL
.Project0CError
	rts
*************************************************************************
GetWidth:
	movem.l	d1-a6,-(sp)
	move.l	a1,a0

	moveq	#-1,d0
.len
	addq.w	#1,d0
	tst.b	(a1)+
	bne.s	.len

	tst.b	topazused(a5)
	bne.s	.top

	tst.b	onsysfont(a5)
	bne.s	.sys

	move.l	mypubscreen(A5),a1
	lea	sc_rastport(a1),a1

	move.l	grafsave(a5),a6
	jsr	_LVOtextlength(A6)
	bra.s	.end
.sys
	mulu	Fontx(A5),d0		;Anzahl mal Breite (Sysdef=>fixedwith)
	bra.s	.end
.top
	lsl.w	#3,d0			;8 Punkte mal Anzahl der Zeichen
.end
	movem.l	(sp)+,d1-a6
	rts
*************************************************************************
*            Fenster ffnen, Gadgets und Mens init                     *
*************************************************************************
SetUpWin:
	movem.l d1-d4/a0-a4/a6,-(sp)

	move.l	mypubscreen(a5),a0
	move.l  sc_Font(a0),a1
	move.w  ta_YSize(a1),d3
	addq.w  #1,d3
	move.b  sc_WBorTop(a0),d0
	ext.w   d0
	add.w	d3,d0
	move.w	d0,offy(a5)

	move.b  sc_WBorLeft(a0),d0
	ext.w   d0
	move.w	d0,offx(a5)

	move.w	#Project0Width,d2
	move.w	#Project0Height,d3

	bsr	ComputeFont
	move.l	mypubscreen(A5),a0

	move.l	d2,ahawidth
	move.l	d3,ahaheight

	move.l	d2,d0
	move.l	d0,d4

	moveq	#0,d2
	add.w	d2,d0
	add.w	OffX(a5),d0
	move.b	sc_WBorRight(a0),d1
	ext.w	d1
	add.w	d1,d0
	cmp.w	sc_Width(a0),d0
	bls.s	.Project0WOk
	move.w	sc_Width(a0),d0
	sub.w	d4,d0
	move.w	d0,d2
.Project0WOk:
	move.l	d3,d0
	move.l	d0,d4

;	lea	begin(pc),a1
;	move.w	eus_winy(a1),d3
;	add.w	d3,d0
;	add.w	OffY(A5),d0
;	move.b	sc_WBorBottom(a0),d1
;	ext.w	d1
;	add.w	d1,d0
;	cmp.w	sc_Height(a0),d0
;	bls.s	Project0HOk
;	move.w	sc_Height(a0),d0
;	sub.w	d4,d0
;	move.w	d0,d3

Project0HOk:
	move.l	Gadsave(A5),a6
	lea.l	Project0NewMenu0(pc),a0
	lea.l	MTags0(pc),a1
	jsr	_LVOCreateMenusA(a6)
	move.l	d0,Project0Menus(A5)
	tst.l	d0
	beq	Project0MError
	move.l	d0,a0
	move.l	Vi(A5),a1
	lea.l	mtags0(pc),a2
	jsr	_LVOLayoutMenusA(a6)

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d7
	move	WinPosX(A5),d0
	move	WinPosY(A5),d1
	move	ZoomPosX(A5),d2
	move	ZoomPosY(A5),d3
	move.l	ahawidth(pc),d4
	move.l	ahaheight(pc),d5
;	move.l	#ZoomWidth,d6

	move.l	mypubscreen(A5),a0
	lea.l	sc_RastPort(a0),a0
	move.l	rp_Font(a0),a0
	move.w  tf_XSize(a0),d6
	mulu	#ZoomWidth,d6
	addq	#4,d6
	lsr	#3,d6

	move	offy(A5),d7
	tst.b	ZoomState(A5)
	beq.s	.Normal
	exg.l	d0,d2
	exg.l	d1,d3
	exg.l	d4,d6
	exg.l	d5,d7
.normal
	lea.l	Project0WindowTags(pc),a1
	move.l	d0,Project0L+4-Project0WindowTags(A1)
	move.l	d1,Project0T+4-Project0WindowTags(A1)
	move.l	d4,Project0W+4-Project0WindowTags(A1)
	move.l	d5,Project0H+4-Project0WindowTags(A1)
	move.w	d2,ZoomStruct-Project0WindowTags(A1)
	move.w	d3,ZoomStruct+2-Project0WindowTags(A1)
	move	d6,ZoomStruct+4-Project0WindowTags(A1)
	move	d7,ZoomStruct+6-Project0WindowTags(A1)

	move.l	Intsave(A5),a6
	move.l	mypubscreen(a5),Pubadr-Project0WindowTags(a1)
	suba.l	a0,a0
	jsr	_LVOOpenWindowTagList(a6)
	move.l	d0,Winhandle(a5)
	tst.l	d0
	beq	Project0WError
.open13
	move.l	Winhandle(a5),a0
	move.l	Project0Menus(A5),a1
	jsr	_LVOSetMenuStrip(a6)

	bsr	createGadgets

	bsr	AddGads

	moveq	#0,d0
Project0Done:
	movem.l	(sp)+,d1-d4/a0-a4/a6
	rts
Project0CError:
	moveq	#1,d0
	bra.s	Project0Done
Project0GError:
	moveq	#2,d0
	bra.s	Project0Done
Project0MError:
	moveq	#3,d0
	bra.s	Project0Done
Project0WError:
	moveq	#4,d0
	bra.s	Project0Done

AddGads:
	movem.l	d0-a6,-(sp)
	move.l	Project0GList(a5),d0
	beq.s	.nogads
	move.l	d0,a1

	moveq	#0,d1
.count
	move.l	d0,a0

	addq.l	#1,d1

	move.l	(A0),d0
	bne.s	.count

	move.w	d1,RealNumGadgets(A5)

	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	moveq	#-1,d0
	moveq	#-1,d1
	suba.l	a2,a2
	jsr	_LVOaddglist(a6)

	move.l	Project0GList(a5),a0
	move.l	winhandle(a5),a1
	suba.l	a2,a2
	moveq	#-1,d0
	jsr	_LVOrefreshglist(a6)

	move.l	GadSave(a5),a6
	move.l	Winhandle(a5),a0
	suba.l	a1,a1
	jsr	_LVOGT_RefreshWindow(a6)
.nogads
	movem.l	(sp)+,d0-a6
	rts
*************************************************************************
*            Fenster schlieen, Gadgets und Mens free                  *
*************************************************************************
Closedownwin:
	movem.l d0-d1/a0-a2/a6,-(sp)
	move.l	Intsave(A5),a6
	move.l	Project0Menus(A5),a0
	cmpa.l	#0,a0
	beq	Project0NMenu
	move.l	Winhandle(a5),a0
	jsr	_LVOClearMenuStrip(a6)
	move.l	GadSave(a5),a6
	move.l	Project0Menus(A5),a0
	jsr	_LVOFreeMenus(a6)
	move.l	#0,Project0Menus(A5)
Project0NMenu:
	move.l	Intsave(A5),a6
	move.l	Winhandle(a5),d0
	beq.s	.nowin
	move.l	d0,a0
	jsr	_LVOCloseWindow(a6)
	clr.l	Winhandle(a5)
	clr.l	port(a5)
.nowin
	bsr	Freegadgets
	movem.l (sp)+,d0-d1/a0-a2/a6
	rts
FreeGadgets
	movem.l	d0-a6,-(sp)

	move.l	GadSave(a5),a6
	move.l	Project0GList(A5),a0
	cmpa.l	#0,a0
	beq	.nogad
	jsr	_LVOFreeGadgets(a6)
	clr.l	Project0GList(A5)
.nogad
	movem.l	(sp)+,d0-a6
	rts
***************** Liste vom Listview-Gadget entfernen ****************
Remlist:
	movem.l	d0-a6,-(sp)
	tst.l	winhandle(a5)
	beq.s	.err

	moveq	#GD_Listview,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTLV_Labels,(a3)+
	move.l	#-1,(a3)+
	clr.l	(A3)+
	lea	mytags(a5),a3

	move.l	winhandle(A5),a1
	suba.l	a2,a2
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)
.err
	movem.l	(sp)+,d0-a6
	rts
**************** Liste wieder an Gadget anhngen *********************
readdlist:
	movem.l	d0-a6,-(sp)
	tst.l	winhandle(A5)
	beq.s	.err

	moveq	#GD_Listview,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTLV_Labels,(a3)+
	lea	list(a5),a2
	move.l	a2,(a3)+

	tst.b	clicked(A5)
	beq.s	.nose
	move.l	#GTLV_Selected,(a3)+
	moveq	#0,d0
	move.w	num_selected(A5),d0
	move.l	d0,(a3)+
	clr.l	(a3)
.nose
	lea	mytags(a5),a3

	move.l	winhandle(A5),a1
	suba.l	a2,a2
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)

;	move.l	gadsave(A5),a6
;	move.l	winhandle(a5),a0
;	suba.l	a1,a1
;	jsr	_LVOGT_refreshwindow(A6)
.err
	movem.l	(sp)+,d0-a6
	rts
*************************************************************
*    Gadgetadresse ausrechnen                               *
* Input D0 - Gadgetnummer (0 < X < MAX)                     *
*************************************************************
_Gadr
	lea	Gadgetadrs(a5),a0
	asl.l	#2,d0
	move.l	(a0,d0),a0
	rts
*************************************************************
*       Setzt Interrupt fr Scroller (VBlank)               *
*************************************************************
Setint	
	tst.w	intset(a5)	;Interrupt schon gesetzt ?
	bne.s	.no	;ja->raus

	move.l	4,a6
	lea	inter(a5),a1
	lea	INT_Prog(pc),a0
	move.l	a0,IS_code(a1)
	move.b	#nt_interrupt,ln_type(a1)
	move.b	#0,ln_pri(a1)
	moveq	#5,d0
	jsr	_LVOaddintserver(a6)

	move.w	#1,intset(a5)
.no
	rts
*************************************************************
*         entfernt Scroller-Interrupt                       *
*************************************************************
Remint
	tst.w	intset(a5)
	beq.s	.no

	move.l	4,a6
	moveq	#5,d0
	clr.w	intset(a5)
	lea	inter(a5),a1
	jsr	_LVOremintserver(a6)
.no	rts
*************************************************************
*                  VBLANK Interrupt                         *
*************************************************************
INT_Prog
	movem.l	d0-a6,-(sp)
	lea	Datas,a5
	movem.l	(sp)+,d0-a6
	moveq	#0,d0
	rts
*************************************************************
*           Nachrichtenbearbeitung                          *
*************************************************************
HandleActions
.ma
	move.l	gadsave(a5),a6

	move.l	port(a5),d0
	beq.s	.nowinny
	move.l	d0,a0
	jsr	_LVOGT_getimsg(a6)
	tst.l	d0
	bne	.msg
.nowinny
	move.l	4,a6
	
	move.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.AN_msg

	move.l	againaport(A5),d0
	beq.s	.noex
	move.l	d0,a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.externalmsg
.noex
	moveq	#0,d0
	move.l	4,a6
	move.l	againaport(A5),d2
	beq.s	.schnauze
	move.l	d2,a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
.schnauze

	ifne	userprogram
	move.l	msgport(a5),a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
	endc

	move.l	Port(a5),d2
	beq.s	.nomain
	move.l	d2,a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
.nomain
	move.l	mysignal(a5),d3	;Signal fr Analyzer
	bset	d3,d0		;Signalbit fr Abarbeitung des Analyzers selbst
				;(Auswertungsroutine namens "ANALYZE1")
	jsr	_LVOwait(a6)
	bra	.ma
;=============== Zurckkommende Message vom Externen Port ==============
.externalmsg
;	clr.b	messagesent2(A5)

	move.l	d0,a1
	move.l	d0,d7

	clr.l	temp1(A5)
	clr.l	temp2(a5)
	move.l	UM_result(A1),d5

	move.l	UM_ArgString(A1),d0
	beq.s	.notanswered
	move.l	d0,a1
	move.l	EPT_Result1(a1),temp1(A5)
	move.l	EPT_Result2(a1),temp2(a5)
	moveq	#28,d1
	lea	EPT_String(a1),a3
	lea	Stringtemp(a5),a2
.copy
	move.b	(a3)+,(a2)+
	dbeq	d1,.copy

	move.l	a1,d6
.clrnext
	move.l	d6,a3
	move.l	EPT_Stringsize(A3),d0
	move.l	a3,a1
	move.l	EPT_Next(A3),d6
	move.l	4,a6
	jsr	_LVOfreemem(A6)
	tst.l	d6
	bne.s	.clrnext

	bra.w	.error2
.notanswered
.error2
	move.l	d7,a1
	bsr	freemsg

	move.l	jumpadr(A5),d0		;wohin, wenn Mess zurck ?
	beq	.getaha
	clr.l	jumpadr(A5)
	move.l	d0,a0
	jsr	(A0)
	bra	.ma
.getaha
	bra	.ma
;======================= Message an Hauptwindow ============================
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<- Fr Tastatur / Selnummer Listview
	move.l	im_Iaddress(a1),d6 	<- Fr Gadgetabfrage
	move.l	im_seconds(a1),d2	<- fr Doppelclick
	move.l	im_micros(a1),d3	<- auch f. Doppelclick
	jsr	_LVOGT_replyimsg(a6)

	cmp.l	#IDCMP_Changewindow,d7	;Refresh
	bne.s	.nochangewin

	move.l	winhandle(a5),a0
	move	OffY(A5),d0
	cmp	wd_height(a0),d0
	bne.s	.setposun
	move.w	wd_leftedge(a0),ZoomPosX(a5)
	move.w	wd_topedge(a0),ZoomPosY(a5)
	st	ZoomState(a5)
	bra	.ma
.setposun
	move.w	wd_leftedge(a0),WinPosX(a5)
	move.w	wd_topedge(a0),WinPosY(a5)
	sf	ZoomState(a5)
	bra	.ma
.nochangewin

	cmp.l	#refreshwindow,d7	;Refresh
	bne.s	.noref
	pea	.ma(pc)

	bsr	clearwin

	move.l	gadsave(a5),a6
	move.l	winhandle(a5),a0	;*Window
	jsr	_LVOGT_beginrefresh(A6)

	move.l	winhandle(a5),a0	;*Window
	moveq	#1,d0
	jsr	_LVOGT_Endrefresh(A6)	
	rts
	;------------------ Gadgets abfragen ------------------------
.noref
	cmp.l	#Gadgetup,d7
	bne.w	.notgad

	move.l	d6,a1

	move.w	gg_gadgetid(A1),d4	;ID Fr Gadgets

	bsr	TestGadgets
	bra	.ma
	;------------------------- Mens abfragen ----------------------------
.menuloop
	move.l	temp(A5),a1
	move.w	mi_nextselect(A1),d5
	bra.s	.menuwei
.notgad:
	cmp.l	#menupick,d7
	bne.w	.nomenu
.menuwei
	move.w	d5,d0
	cmp.w	#menunull,d0
	beq	.ma

	move.l	Project0Menus(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOitemaddress(a6)
	move.l	d0,a1
	tst.l	d0
	beq	.ma
	move.l	d0,temp(A5)

	move.w	d5,d0
	and.w	#$7e0,d0
	bne.s	.nootherfont

	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	lsr.w	#4,d0
	move.b	d0,OnSysFont(A5)
	move.b	begin+eus_special(pc),d1
	and.b	#~$10,d1
	or.b	d0,d1
	move.b	d1,begin+eus_special

	bsr	Closewin
	bsr	OpenWin
	bra	.ma
.nootherfont
	cmp.w	#64,d0
	bne.s	.noabout		;9. Item (About) ?
	lea	Aboutmessage(pc),a0
	bsr	Merror
	bra	.menuloop
.noabout
	cmp.w	#96,d0			;10. Item (Hide)
	beq.s	.quitit
	cmp.w	#128,d0			;11. Item (Quit)
	beq	.killit
	bra	.menuloop
.nomenu
	cmp.l	#rawkey,d7
	bne	.nokey
	cmp.b	#$45,d5			;ESC
	beq	.quitit
	bra	.ma
.nokey
	cmp.l	#CloseWindow,d7
	bne	.ma
.quitit
	ifne	userprogram

	bsr	closewin

	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
;	move.l	mysignal(a5),d5
	move.l	#-1,d5
	move.w	#USclass_DeActivate,d6
	bsr	sendmess
	bra	.ma

	endc
.endme
	moveq	#-1,d7
	rts
.killit
	moveq	#0,d7
	RTS
;===================== Message an Userprogramm Port =====================
	ifne	userprogram
.AN_msg
	move.l	d0,a1

	move.l	MSGPort(a5),UM_Userport(a1)

	lea	begin(pc),a2
	ifne	debug
	move.w	um_usernr(a1),saveusernr(A5)
	else
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	mytask(a5),UM_TaskAdr(a1)
;	move.l	mysignal(a5),d1
	move.l	#-1,d1
	move.l	d1,UM_Signal(a1)

	move.w	UM_class(a1),d3		<-
	cmp.w	#USclass_exit,d3
	bne.w	.noex1

	clr.l	um_signal(a1)
	clr.l	um_taskadr(a1)
	clr.l	um_userport(a1)
.noex1
	move.l	UM_Type(a1),d7
	move.l	UM_structadr(a1),d6 	<-

	clr.w	UM_class(A1)

	cmp.w	#USClass_exit,d3
	beq	.setprefs

	cmp.w	#USclass_getconfig,d3		;when this command comes,set
						;the actual preferences into
						;the Eagleuser-Structure
						;(EUS_-structure at the be-
						;ginning of the program)
	bne	.noprev
.setprefs
	moveq	#0,d0
	move.l	winhandle(A5),d1		;Window
	beq.s	.prnowin			;no Window opened,no change
						;of preferences
	or.w	#eusb_openwin,d0		;set Flag: window is open
.prnowin
	move.w	WinPosX(a5),eus_winx(a2)	;Save Windowpostion
	move.w	WinPosY(a5),eus_winy(a2)

	move	ZoomposX(a5),Zoomx(A2)
	move	ZoomposY(A5),Zoomy(a2)

	move.b	Zoomstate(a5),ZoomONOFF(a2)
	move.b	Onsysfont(A5),Sysfontonoff(a2)

	move.w	d0,eus_flags(a2)		;Save Flags
.noprev

	cmp.w	#USclass_Show,d3
	beq.s	.win
	cmp.w	#USclass_Activate,d3
	bne.w	.nowin
.win
	move.l	Begin+EUS_EPBase(pc),a0
	move.l	EPG_SomePrefs(a0),d0
	btst	#EGPRF_Iconify,d0
	bne.w	.noShow

	push	all
	bsr	Openwin
	pop	all
	tst.l	Winhandle(A5)
	beq.s	.noshow
	move	d3,UM_Class(a1)
.noshow
.nowin
	cmp.w	#USclass_Hide,d3
	beq.s	.closewin
	cmp.w	#USclass_DeActivate,d3
	bne.s	.noclosewin
.closewin
	bsr	Closewin
.noclosewin

	move.l	mn_replyport(a1),d0
	cmp.l	MSGport(a5),d0		 ;eine von uns abgeschickte Message ?
	beq.s	.noreply
	jsr	_LVOreplymsg(a6)
.noreply
	
	cmp.l	#USM_Userprg,d7	;Message zurckbekommen ?
	bne.s	.nomy

	move.b	#0,messagesent(a5)	;merken,da Message-Struktur frei
	bra	.mess	;eventl. Message vom Esagle auswerten

.nomy
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	bne.w	.noeagle		;n
.mess

;	lea	begin(pc),a0
;	move.l	eus_epbase(a0),a0
;	move.b	EPG_Wordreserved7(a0),d0
;	beq	.killit

	move.l	d6,an_structadr(a5)
.refre
	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq.w	.ma			;adresse bekommen

	cmp.w	#USClass_KillModule,d3
	beq.s	.chg
	cmp.w	#USClass_NewModule,d3
	beq.s	.chg
	cmp.w	#USClass_NewAmplifierlist,d3
	bne.s	.nochange
.chg
	bsr	UpdateNPList
	bra	.ma
.nochange
	cmp.w	#USclass_zipwin,d3
	bne.s	.nozip
.setzip
	move.l	4,a6

	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.w	.ma		;Window schon klein
.zip
	move.w	d0,-(sp)

	move.l	intsave(a5),a6
	jsr	_LVOzipwindow(a6)

	move.w	(sp)+,d4

	move.l	winhandle(a5),a2
.Zipwait:
	moveq	#1,d1
	move.l	_Dos(a5),a6
	jsr	_LVODelay(a6)

	cmp.w	wd_height(a2),d4
	beq.s	.zipwait

	bra	.ma
.nozip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nounzip

.clearzip
	move.l	4,a6

	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.s	.zip
	bra	.ma
.nounzip
	cmp.w	#USclass_exit,d3
	beq	.endme

;	cmp.w	#USclass_Show,d3
;	beq.s	.win
;	cmp.w	#USclass_Activate,d3
;	bne.w	.nowin
;.win
;		move.l	MYEpBase(pc),a0
;		move.l	EPG_SomePrefs(a0),d0
;		btst	#EGPRF_Iconify,d0
;		bne.w	.ma
;
;	bsr	Openwin
;	bra	.ma
;.nowin:
	cmp.w	#USClass_SetWaitPointer,d3
	bne.w	.NoWaitPointer
	bsr	WaitPointer
	bra	.ma

.NoWaitPointer:
	cmp.w	#USClass_ClearWaitPointer,d3
	bne.w	.NoClearPointer
	bsr	ClearPointer
	bra	.ma


.NoClearPointer:

	cmp.w	#USclass_NewConfig,d3	;is there a new config
	bne.w	.nonewcon		;no

	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.w	eus_flags(a0),d0	;get Flags
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin			;open it
	bra.s	.weio
.nowino
	bsr	closewin		;else close it
.weio
	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.l	winhandle(a5),d0	;windowaddress
	beq.s	.nothingtomove		;no Window , no movement

	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;new X-position
	move.w	d0,d1			;save
	blt.s	.oldx			;less than 0 -> stop

	add.w	wd_width(a1),d1		;new position + Window-width
	cmp.w	sc_width(a2),d1		;bigger than Screenwidth ?
	bhi.s	.oldx			;then old X-position (Delta = 0)

	sub.w	wd_leftedge(a1),d0	;new - old X-position = Delta X
	bra.s	.gety
.oldx
	moveq	#0,d0			;Delta X = 0
.gety
	move.w	eus_winy(a0),d1		;new Y-position

	move.w	d1,d2			;save
	blt.s	.oldy			;less than 0 -> stop and take old

	add.w	wd_height(a1),d2	;new position + window-height
	cmp.w	sc_height(a2),d2	;bigger than Screenheight ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;new - old Y-position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1

.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove
	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	btst	#eusf_zipwin,d0		;Zipwindow ?
	bne	.setzip			;yes
	bra	.clearzip		;no
.nonewcon
	bra	.ma
.noeagle
	bra	.ma
	endc

*-----------------------------------------------------------------------------*
WaitPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return
		tst.w	WindowDisabled(a5)
		bne.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	Begin+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	Project0Menus(A5),a1
		jsr	ENPP_SetWaitPointer(a4)

		move.w	#1,WindowDisabled(a5)

.Return:	movem.l	(sp)+,a0/a1/a4/d0
		rts


*-----------------------------------------------------------------------------*
ClearPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.w	WindowDisabled(a5)
		beq.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	Begin+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	Project0Menus(A5),a1
		jsr	ENPP_ClearWaitPointer(a4)


.Return:	clr.w	WindowDisabled(a5)
		movem.l	(sp)+,a0/a1/a4/d0
		rts

*********************** Finde Tag ber EP Funktion ***************************
FindTag
	movem.l	a1/a5,-(sp)
	move.l	myEPBase(pc),a5
	move.l	EPG_FindTag(a5),a1
	jsr	(a1)
	movem.l	(sp)+,a1/a5
	rts
*****************************************************************
allocmsg
	movem.l	d1-a6,-(sp)
	move.l	4,a6
	moveq	#UM_Sizeof,d0
	move.l	#$10001,d1
	jsr	_LVOallocmem(A6)
	movem.l	(sp)+,d1-a6
	tst.l	d0
	rts
*****************************************************************
freemsg
;	moveq	#UM_sizeof,d0

	moveq	#0,d0
	move.w	mn_length(a1),d0
	add.w	#20,d0
	move.l	4,a6
	jsr	_LVOfreemem(A6)
	rts
******************************************************************************
*                     Message an Eagleplayer senden                          *
******************************************************************************

;PlayEagle
;	lea.l	my_filename(a5),a3
Playmod:
	suba.l	a2,a2
	bra.s	Sendlist2
SendList
	clr.l	temp1(A5)
	clr.l	temp2(A5)
Sendlist2
	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)	;Eagleplayers Port finden
	tst.l	d0
	beq.w	.error			;Cancel->Ende des Programms
	move.l	d0,a4
	
	move.l	againaport(a5),d7

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)	;Task finden
	move.l	d0,d6

	bsr	allocmsg
	beq.w	.error
	move.l	d0,a1			;Messageadresse

;	lea	Mymess(a5),a1		;Messageadresse
;	moveq	#um_sizeof>>1-1,d0
;.clr
;	clr.w	(a1)+
;	dbf	d0,.clr
;	lea	mymess(a5),a1

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	move.w	#-1,UM_UserNr(a1)
	move.l	#USM_Externalprg,UM_Type(a1)
	move.l	d7,mn_replyport(a1)	;Portadresse,an die
					;zurckgesendet wird
	move.l	d7,UM_Userport(a1)
	move.l	d6,UM_TaskAdr(a1)
	move.l	#-1,UM_Signal(a1)
	move.w	#USClass_Command,UM_class(a1)
	move.l	#0,UM_Userwindow(A1)

	move.l	d5,UM_Command(A1)	;!!

	move.l	a2,d0
	bne.s	.noalloc

	tst.w	NoArgs(a5)	;bei Argumentenbergabe mit Strings, mu ent-
	bne.s	.NoAlloc	;weder der String gesetzt sein oder die Struc
				;ture darf nicht da sein, da der EP sonst denkt
				;es handelt sich um einen Bug in der Structure

	move.l	#EPT_String+132,d0
	movem.l	d1-a6,-(Sp)
	move.l	4,a6
	move.l	#$10001,d1
	jsr	_LVOallocmem(A6)
	movem.l	(sp)+,d1-a6
	tst.l	d0
	beq	.Error2

	move.l	d0,a2

	move.l	temp1(A5),ept_result1(a2)
	move.l	temp2(A5),ept_result2(a2)

	move.l	#EPT_String+132,EPT_Stringsize(A2)
	clr.l	EPT_Next(A2)

	move.w	#132,d1
	move.l	a2,-(sp)
	lea	EPT_string(A2),a2
.copyfilename
	move.b	(a3)+,(A2)+
	dbeq	d1,.copyfilename

	move.l	(sp)+,a2
.noalloc
	move.l	a2,UM_ArgString(A1)
	clr.l	UM_Result(A1)


	*--- added by Eagleeye ---*
	*####
	move.l	#EPT_String,d0
	movem.l	d1-a6,-(Sp)
	move.l	4,a6
	move.l	#$10001,d1
	jsr	_LVOallocmem(A6)
	movem.l	(sp)+,d1-a6
	move.l	d0,EPT_Next(a2)
	tst.l	d0
	beq	.NoStruct2
	move.l	d0,a2
	clr.l	EPT_Next(a2)
	move.l	#EPT_String,EPT_Stringsize(A2)
	move.l	temp3(A5),ept_result1(a2)
	move.l	temp4(A5),ept_result2(a2)
.NoStruct2:
	*####
	*--- added by Eagleeye ---*



	move.l	4,a6
	move.l	a4,a0
	jsr	_LVOputmsg(a6)

	clr.l	Jumpadr(A5)
.error
	rts
.error2
	clr.l	Jumpadr(A5)
	rts
******************************************************************************
*                     aktuelle Liste killen                                  *
******************************************************************************
deletelist
	bsr	Remlist
	bsr	deletelist1
	bsr	readdlist
	rts
deletelist1:
	movem.l	d0-a6,-(sp)
	lea	list(A5),a0
*	bra.s	del1
*deletelist2:
*	movem.l	d0-a6,-(sp)
*	lea	list2(A5),a0
del1
	move.l	a0,d4
.del
	move.l	d4,a0
;Macro remhead aus exec/lists.i 	A0-list A1-(destroyed) D0=node

	MOVE.L  (A0),A1
	MOVE.L  (A1),D0
	BEQ.S   .empty
	MOVE.L  D0,(A0)
	EXG.L   D0,A1
	MOVE.L  A0,LN_PRED(A1)

	move.l	d0,a1
	move.l	#ML_Sizeof,d0
	move.l	4,a6
	jsr	_LVOfreemem(A6)
	bra.s	.del
.empty
	movem.l	(sp)+,d0-a6
	rts

*-----------------------------------------------------------------------------*
deletelist2:
	movem.l	d0-a6,-(sp)


.del	lea	list2(A5),a0

	;Macro remhead aus exec/lists.i 	A0-list A1-(destroyed) D0=node
	MOVE.L  (A0),A1
	MOVE.L  (A1),D0
	BEQ.S   .empty
	MOVE.L  D0,(A0)
	EXG.L   D0,A1
	MOVE.L  A0,LN_PRED(A1)

	move.l	d0,a1
	move.l	TML_Size(a1),d0
	beq.s	.del
	move.l	4,a6
	jsr	_LVOfreemem(A6)
	bra.s	.del
.empty
	movem.l	(sp)+,d0-a6
	rts



******************************************************************************
* Speicher fr Node-Struktur + String anfordern, an Liste anhngen und init  *
******************************************************************************
*AllocNode2:
*	movem.l	d1-a6,-(sp)
*	lea	list2(A5),a4
*	bra.s	AllocIT
AllocNode:
	movem.l	d1-a6,-(sp)
	lea	list(A5),a4
AllocIT
	move.l	4,a6
	move.l	#$10000,d1
	move.l	#ML_Sizeof,d0
	jsr	_LVOallocmem(A6)
	tst.l	d0
	bne.s	.rts
	lea	msg_Additional(pc),a0
	bsr	merror
	bra.s	.err
.rts
	move.l	d0,a3

	move.l	a4,a0
	move.l	d0,a1			;(erspart Arbeit)
	addtail
	lea	ML_Nodename(a3),a1
	move.l	a1,ln_name(A3)
.err
	move.l	a3,d0
	movem.l	(sp)+,d1-a6
	tst.l	d0
	rts
******************************************************************************
*                   extra Speicher freigeben                                 *
*                        Adresse in A1                                       *
******************************************************************************
Freenode:
	movem.l	d0-a6,-(sp)
	move.l	4,a6
	move.l	a1,d0
	beq.s	.rts
	move.l	#ML_Sizeof,d0
	jsr	_LVOfreemem(A6)
.rts
	movem.l	(sp)+,d0-a6
	rts
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0/a2-a3,-(sp)
	suba.l	a3,a3			;*Arguments
	lea	my_easygadget(pc),a2
	bsr	Errorout
	movem.l	(sp)+,d0/a2-a3
	rts
Errorout
	movem.l	d1-a6,-(sp)
	move.l	Intsave(a5),a6

	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	move.l	a2,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	jsr	_LVOeasyrequestargs(a6)			;!! durch Reqtools
							;ersetzen
	movem.l	(sp)+,d1-a6	
	rts
******************************************************************************
*              Liste der Aplifier auf aktuellen Stand bringen                *
******************************************************************************
;;
UpdateNPList:
	ifne	test
	move.l	AmplifierList,a0
	else
	move.l	MyEPBase(pc),a0
	move.l	EPG_AmplifierList(a0),d0
	beq.s	.Error
	move.l	d0,a0
	endc

	bsr	remlist
	bsr	deletelist1

	;1. Amplifier in A0
.loop
	cmp.b	#EUTY_Amplifier,EUS_Type(a0)
	bne.s	.next
	move.l	eus_username(a0),d1
	beq.s	.next

	bsr	allocnode
	tst.l	d0
	beq	.readd			;kein Speicher mehr, aufhren
	move.l	d0,a1
	move.l	ln_name(a1),a1		;Name Adresse

	move.l	d1,a2

	move.w	eus_flags(a0),d2
	and.w	#EUSB_disable,d2
	beq.s	.skipklammer1
	move.b	#`(`,(a1)+
.skipklammer1

	moveq	#90-1,d0
.cpynam
	move.b	(a2)+,(a1)+
	dbeq	d0,.cpynam
	subq.l	#1,a1

	tst.w	d2
	beq.s	.skipklammer2
	move.b	#`)`,(a1)+
.skipklammer2
	clr.b	(a1)+
.next
	move.l	EUS_Identifier(a0),d0
	beq.s	.readd
	move.l	d0,a0
	bra.s	.loop
.readd
	bsr	readdlist
	bsr	UpdateInfoGadget
.Error
	rts
*****************************************************************************
*                        Gedrckte Gadgets abfragen                         *
* A1 - aktuelle Gadgetstruktur                                              *
* D4 - Gadget ID                                                            *
*****************************************************************************
TestGadgets
	cmp.w	#GD_Listview,d4				;Liste der Amplifier
	bne.w	.noidlv
	st	clicked(A5)
	move.w	num_selected(A5),d6	;aktuell angeclickter Amplifier
	move.w	d5,num_selected(A5)	;neuer angeklickter NP

	tst.b	exg(a5)
	beq.s	.noexchg
	clr.b	exg(A5)

	move.w	d6,d0
	move.w	d5,d1
	bsr	ExchangeAmplifiers

	bsr	UpdateNPList
	bsr	Setpriorities
	bra	.endit
.noexchg
	cmp.w	d5,d6			;kein Doppelklick
	beq	.testdoub

	move.l	d2,Seconds(a5)
	move.l	d3,Micros(a5)

	bsr	UpdateInfoGadget
	bra	.endit
.testdoub
	move.l	Seconds(a5),d0
	move.l	Micros(a5),d1
	move.l	d2,Seconds(a5)
	move.l	d3,Micros(a5)
	move.l	intsave(a5),a6
	jsr	_LVOdoubleclick(a6)
	cmp.l	#1,d0
	bne.w	.endit

	clr.l	seconds(a5)
	;-------------------- Amplifier enable/disable --------------------

	move.w	d5,d0
	bsr	GetAmplifierNr
	beq	.endit		;Fehler ?
	move.l	d0,a0
	move.w	eus_flags(a0),d0
	eor.w	#EUSB_disable,d0
	move.w	d0,eus_flags(a0)
	bsr	UpdateNPList

	bra.w	.endit
.noidlv
	cmp.w	#GD_Up,d4
	bne.w	.noUP

	move.w	num_selected(A5),d0	;aktuell angeclickter Amplifier-1
	subq.w	#1,d0
	blt	.endit			;schon der erste ?

	move.w	d0,d1
	addq.w	#1,d1
	bsr	ExchangeAmplifiers

	subq.w	#1,num_selected(A5)
 	bsr	UpdateNPList
	bsr	Setpriorities
	bra.w	.endit
.noUP
	cmp.w	#GD_Down,d4
	bne.w	.noDown

	move	num_selected(A5),d0	;aktuell angeclickter Amplifier+1
	addq	#1,d0
	move	d0,d1
	bsr	GetAmplifierNr		;aktueller NP+1
	beq	.endit			;Fehler ?

	move	num_selected(A5),d0
	bsr	ExchangeAmplifiers

	addq.w	#1,num_selected(A5)
	bsr	UpdateNPList
	bsr	Setpriorities
	bra	.endit
.nodown
	cmp.w	#GD_exchg,d4
	bne.w	.noexg
	st	exg(A5)
	bra	.endit
.noexg
	cmp.w	#GD_Sort,d4		;nach Namen sortieren
	bne.s	.nosort

	bsr	SortAmplifiers
	bsr	UpdateNPList
	bsr	Setpriorities
	bra	.endit
.nosort
	cmp.w	#GD_Show,d4
	bne.s	.noshow

	move	num_selected(A5),d0
	bsr	GetAmplifierNr
	beq	.endit		;Fehler ?
	move.l	d0,a0

	move.l	EUS_MsgFlags(a0),d0	;###
	btst	#USMF_Configuration,d0	;### added by Eagleeye
	beq.w	.endit			;###

	moveq	#0,d0
	move.w	eus_Usernr(a0),d0
	beq.w	.endit		;### added by Eagleeye interne Amplifier

	lea	StatusX(pc),a3
	*moveq	#EPNr_Engine,d5
	move.l	#EPNr_EngineShowState,d5	;### added by Eagleeye
	moveq	#0,d6

	move.l	d0,temp1(a5)

	*move.l	#1,temp2(A5)
	move.l	#1,temp3(A5)		;### added by Eagleeye

	clr.l	Jumpadr(A5)
	bsr	playmod
	bra	.endit
.noshow
	cmp.w	#GD_Hide,d4
	bne.s	.nohide

	move	num_selected(A5),d0
	bsr	GetAmplifierNr
	beq	.endit		;Fehler ?
	move.l	d0,a0

	move.l	EUS_MsgFlags(a0),d0	;###
	btst	#USMF_Configuration,d0	;### added by Eagleeye
	beq.w	.endit			;###

	moveq	#0,d0
	move.w	eus_Usernr(a0),d0
	beq.w	.endit		;### added by Eagleeye interne Amplifier

	lea	StatusX(pc),a3
	*moveq	#EPNr_Engine,d5
	move.l	#EPNr_EngineShowState,d5	;### added by Eagleeye
	moveq	#0,d6

	move.l	d0,temp1(a5)

	*move.l	#0,temp2(A5)
	clr.l	temp3(a5)		;### added by Eagleeye

	clr.l	Jumpadr(A5)
	bsr	playmod
	bra	.endit
.nohide
	cmp.w	#GD_Del,d4
	bne.s	.noDEL

	move	num_selected(A5),d0
	bsr	GetAmplifierNr
	beq	.endit		;Fehler ?
	move.l	d0,a0
	moveq	#0,d0
	move.w	eus_Usernr(a0),d0
	beq.w	.endit		;### added by Eagleeye interne Amplifier

	lea	StatusX(pc),a3
	moveq	#0,d5
	*move.w	#EPNr_Quit,d5
	move.w	#EPNr_Engine,d5			;### added by Eagleeye
	moveq	#0,d6

	move.l	d0,temp1(a5)

	*move.l	#0,temp2(A5)
	move.l	#0,temp3(A5)			;### added by Eagleeye

	clr.l	Jumpadr(A5)
	bsr	playmod
	bra	.endit
.noDEL
	cmp.w	#GD_Add,d4
	bne.s	.noadd

	lea	StatusX(pc),a3
	move.l	#EPNr_loadEngine,d5
	moveq	#0,d6

	clr.l	temp1(a5)
	clr.l	temp2(A5)

	move.w	#1,NoArgs(a5)
	clr.l	Jumpadr(A5)
	bsr	playmod
	clr.w	NoArgs(a5)

	bra	.endit
.Noadd:
.endit
	rts
***************************************************************************
*                     zwei Amplifier tauschen                            *
* Input:  D0,D1 -> die zu vertauschenden NP (Nummer 0..n)                 *
* Output: none                                                            *
***************************************************************************
ExchangeAmplifiers:
	movem.l	d0-a6,-(sp)
	
	cmp.w	d1,d0
	beq.w	.exit

	tst.w	d0
	beq.s	.special

	tst.w	d1
	bne.s	.normal
	exg.l	d0,d1
.special
	bsr	getAmplifierNr		:NP1
	beq	.exit			;Fehler ?
	move.l	d0,a0

	move.w	d1,d0			;d1 > 0 !!
	bsr	GetAmplifierNr		;NP2
	beq	.exit			;Fehler ?
	move.l	d0,a2

	subq.w	#1,d1
	move	d1,d0
	bsr	GetAmplifierNr		;NP2 - 1
	beq	.exit			;Fehler ?
	move.l	d0,a3

	move.l	a0,EUS_Identifier(a3)

	move.l	eus_identifier(a2),d0
	move.l	eus_identifier(a0),eus_identifier(a2)
	move.l	d0,eus_identifier(a0)

	ifne	test
	move.l	a2,AmplifierList
	else
	move.l	MyEPBase(pc),a3
	move.l	a2,EPG_AmplifierList(a3)
	endc

	bra	.exit
.normal
	move.w	d0,d2
	bsr	GetAmplifierNr		;NP1
	beq	.exit			;Fehler ?
	move.l	d0,a0

	subq.w	#1,d2
	move	d2,d0
	bsr	GetAmplifierNr		;NP1 - 1
	beq	.exit			;Fehler ?
	move.l	d0,a1

	move.w	d1,d0
	bsr	GetAmplifierNr		;NP2
	beq	.exit			;Fehler ?
	move.l	d0,a2

	subq.w	#1,d1
	move	d1,d0
	bsr	GetAmplifierNr		;NP2 - 1
	beq	.exit			;Fehler ?
	move.l	d0,a3

	move.l	a2,eus_identifier(a1)
	move.l	a0,eus_identifier(a3)
	move.l	eus_identifier(a2),d0
	move.l	eus_identifier(a0),eus_identifier(a2)
	move.l	d0,eus_identifier(a0)
.exit
	movem.l	(sp)+,d0-a6
	rts
***************************************************************************
*                  Amplifier Prioritten zuweisen                        *
* Input:  none                                                            *
* Output: none                                                            *
***************************************************************************
Setpriorities:
	ifne	test
	move.l	AmplifierList,a0
	else
	move.l	MyEPBase(pc),a0
	move.l	EPG_AmplifierList(a0),d0
	beq.s	.endit
	move.l	d0,a0
	endc

	moveq	#127,d0
	move.l	a0,d1
.loop
	move.l	d1,a0

	cmp.b	#EUTY_Amplifier,EUS_Type(a0)
	bne.s	.suchNP

	move.w	d0,EUS_AMPriority(A0)
	subq.w	#1,d0
.suchNP
	move.l	eus_identifier(a0),d1
	bne.s	.loop
.endit
	rts
***************************************************************************
*                  EUS_Struktur des Amplifiers suchen                    *
* Input: D0 = Nummer                                                      *
* Output: D0 = aktueller NP                                               *
***************************************************************************
GetAmplifierNr:
	movem.l	d1-a6,-(sp)
	move.w	d0,d5

	ifne	test
	move.l	AmplifierList,a0
	else
	move.l	MyEPBase(pc),a0
	move.l	EPG_AmplifierList(a0),d0
	beq.s	.endit
	move.l	d0,a0
	endc

	cmp.b	#EUTY_Amplifier,EUS_Type(a0)
	bne.s	.suchNP

	subq.w	#1,d5
	blt.s	.foundNP
.suchNP
	move.l	eus_identifier(a0),d0
	beq.s	.endit			;not found

	move.l	d0,a0
	cmp.b	#EUTY_Amplifier,EUS_Type(a0)
	bne.s	.suchNP
	dbf	d5,.suchNP
.foundNP
	move.l	a0,d0
	movem.l	(sp)+,d1-a6
	tst.l	d0
	rts
.endit
	movem.l	(sp)+,d1-a6
	moveq	#0,d0
	rts


***************************************************************************
*                 Die Namen zweier Amplifier vergleichen                 *
* Input:  D0.w, D1.w : zu vergleichende Amplifier                        *
* OutPut: D2 : <>0, wenn Amplifier1 < Amplifier0, also Tausch ntig     *
***************************************************************************
cmpNPnames:
	movem.l	d0-d1/d3-a6,-(sp)
	moveq	#0,d2

	bsr	GetAmplifierNr
	beq	.endit		;Fehler ?
	move.l	d0,a0

	move.w	d1,d0
	bsr	GetAmplifierNr
	beq	.endit		;Fehler ?
	move.l	d0,a1

	move.l	EUS_Creator(a0),d3
	beq.s	.endit
	move.l	d3,a0
	move.l	EUS_Creator(a1),d3
	beq.s	.endit
	move.l	d3,a1
.vergleich
	move.b	(a0)+,d3
	beq.s	.endit	;1. String krzer/gleich und Rest gleich ? -> no swap
	move.b	(a1)+,d4
	beq.s	.swap	;2. String krzer aber sonst gleich ? -> swap

	cmp.b	#`a`,d3
	blo.s	.no1
	cmp.b	#`z`,d3
	bhi.s	.no1
	and.b	#~32,d3
.no1
	cmp.b	#`a`,d4
	blo.s	.no2
	cmp.b	#`z`,d4
	bhi.s	.no2
	and.b	#~32,d4
.no2
	cmp.b	d3,d4
	bgt.s	.endit
	beq.s	.vergleich
.swap
	st	d2
.endit
	movem.l	(sp)+,d0-d1/d3-a6
	tst.w	d2
	rts
***************************************************************************
*                   Amplifier nach Namen sortieren                       *
* Input:  none                                                            *
* OutPut: none                                                            *
***************************************************************************
SortAmplifiers:
	ifne	test
	move.l	Amplifierlist,a0
	else
	move.l	MyEPBase(pc),a0
	move.l	EPG_AmplifierList(a0),d0
	beq.s	.exit
	move.l	d0,a0
	endc

	moveq	#0,d7
.countNP
	addq.w	#1,d7
	move.l	eus_identifier(a0),d1
	beq.s	.end
	move.l	d1,a0
	bra.s	.countNP
.end

	subq.w	#1,d7
.sortit
	moveq	#0,d5
	move.w	d7,d6

	moveq	#0,d0
	moveq	#1,d1
.sortloop
	bsr	cmpNPnames	;out: d2 = 0 : kein Tausch ntig
	beq.s	.next
	st	d5
	bsr	ExchangeAmplifiers
.next
	addq.w	#1,d0
	addq.w	#1,d1
	dbf	d6,.sortloop
	tst.w	d5
	bne.s	.sortit
.exit
	rts
***************************************************************************
*        Info Gadget mit Infos ber selektierten Amplifier fllen        *
* Input:  none                                                            *
* OutPut: none                                                            *
***************************************************************************
UpdateInfoGadget:
	movem.l	d0-a6,-(sp)
	tst.l	winhandle(a5)
	beq	.err

	;---------------------- Liste abhngen ----------------------
	moveq	#GD_Info,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTLV_Labels,(a3)+
	move.l	#-1,(a3)+
	clr.l	(A3)+
	lea	mytags(a5),a3

	move.l	winhandle(A5),a1
	suba.l	a2,a2
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)
	;---------------------- Mem freigeben ------------------------

	bsr	deletelist2

	;--------------- Hole Infoliste des aktuellen NP -------------

	move.w	num_selected(A5),d0
	bsr	GetAmplifierNr
	beq	.err		;Fehler ?
	move.l	d0,a0

	ifeq	test
	move.l	a0,-(a7)
	move.l	MyEPBase(pc),a4
	move.l	EUS_TagList(a0),a0
	move.l	#EUT_SpecialinfoLNr,d0
	jsr	ENPP_FindTag(a4)
	move.l	(a7)+,a0
	tst.l	d1
	beq.s	.NoLocale
	tst.l	d0
	beq.s	.NoLocale
	jsr	ENPP_GetLocaleString(a4)
	tst.l	d0
	bne.s	.LocaleDa

.NoLocale:
	move.w	num_selected(A5),d0
	bsr	GetAmplifierNr
	beq	.err		;Fehler ?
	move.l	d0,a0
	move.l	EUS_AboutUPRG(a0),d0
	beq	.err
.LocaleDa:

	move.l	d0,a0
	lea	list2(a5),a1
	bsr	TextToNodes
	

**-- removed by Eagleeye
*	move.l	d0,a3
*
*	;---------------------- Liste erzeugen -----------------------
*	bsr	allocnode2
*	tst.l	d0
*	beq	.readd			;kein Speicher mehr, aufhren
*	move.l	d0,a1
*	move.l	ln_name(a1),a1		;Name Adresse
*
*.stringloop
*	moveq	#100,d0
*.copystring2
*	move.b	(a3)+,d1
*	beq.s	.readd
*	cmp.b	#10,d1
*	bne.s	.sameline2
*
*	bsr	allocnode2		;Neue Zeile -> neue Node alloc
*	tst.l	d0
*	beq	.readd			;kein Speicher mehr, aufhren
*	move.l	d0,a1
*	move.l	ln_name(a1),a1		;Name Adresse
*	bra.s	.stringloop
*.sameline2
*	move.b	d1,(a1)+
*	dbf	d0,.copystring2
*.readd
*-- removed by Eagleeye

	moveq	#GD_Info,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTLV_Labels,(a3)+
	lea	list2(a5),a2
	move.l	a2,(a3)+
	clr.l	(a3)
	lea	mytags(a5),a3

	move.l	winhandle(A5),a1
	suba.l	a2,a2
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)



*##### added by Eagleeye
	lea	mytags(a5),a3
	move.w	num_selected(A5),d0
	moveq	#1,d1			;Def aus
	bsr	GetAmplifierNr
	beq.s	.NO
	move.l	d0,a0
	moveq	#1,d0
	move.l	EUS_MsgFlags(a0),d0
	btst	#USMF_Configuration,d0
	bne.s	.Doch

	move.l	Begin+EUS_EPBase(pc),a6
	move.l	EUS_TagList(a0),a0
	move.l	#EUT_Config,d0
	jsr	ENPP_FindTag(a6)
	moveq	#1,d1
	tst.l	d0
	beq.s	.No
.Doch:	moveq	#0,d1
.No:	move.l	#GA_Disabled,(a3)+
	move.l	d1,(a3)+
	clr.l	(a3)


	moveq	#GD_Show,d0
	bsr	_GADR			;Gadgetadresse in A0
	move.l	winhandle(A5),a1
	suba.l	a2,a2
	lea	mytags(a5),a3
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)

	moveq	#GD_Hide,d0
	bsr	_GADR			;Gadgetadresse in A0
	move.l	winhandle(A5),a1
	suba.l	a2,a2
	lea	mytags(a5),a3
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)

	moveq	#GD_Del,d0
	bsr	_GADR			;Gadgetadresse in A0
	move.l	winhandle(A5),a1
	suba.l	a2,a2
	lea	mytags(a5),a3
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)
*##### added by Eagleeye



	move.l	gadsave(A5),a6
	move.l	winhandle(a5),a0
	suba.l	a1,a1
	jsr	_LVOGT_refreshwindow(A6)
.err
	movem.l	(sp)+,d0-a6
	rts


*-- Added by Eagleeye ---*


*-----------------------------------------------------------------------------*
* a0=Text
* a1=Liste
* Output: d0=Error oder NULL
*-----------------------------------------------------------------------------*
TextToNodes:	movem.l	d1-a6,-(a7)
		move.l	a0,a4
		move.l	a1,d6



	*----------- Width des Listview rausfinden -----------*
	* Kleiner Trick, Gadget im ArchiveInfo ist immer das -*
	* grte					      *
	*-----------------------------------------------------*
		move.l	WinHandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		lea	WD_FirstGadget(a0),a2
		moveq	#0,d1
.FindIt:	move.l	(a2),d0
		beq.w	.AllesFound
		move.l	d0,a2
		move.w	GG_GadgetType(a2),d0		*GadgetID
		btst	#15,d0				*Systemgadget ?
		bne.s	.FindIt
		cmp.w	GG_Width(a2),d1
		bhi.s	.FindIt
		move.w	GG_Width(a2),d1
		bra.s	.FindIt

.AllesFound:	sub.w	#33,d1			*move.w	InfoWidth(a5),d0
		move.w	d1,InfoWidth2(a5)





	*---- Text nach Leerzeichen durchsuchen und dann Width testen ----*
.TextSchleife:	move.l	a4,a3
		moveq	#-1,d1
		moveq	#0,d3
.NextB:		addq.l	#1,d1
		move.b	(a3)+,d2
		beq.s	.Zeilenende
		*cmp.b	#"-",d2
		*beq.s	.TestTrennung
		*cmp.b	#",",d2
		*beq.s	.TestTrennung
		cmp.b	#" ",d2
		beq.s	.TestTrennung

		cmp.b	#10,d2
		bne.s	.NextB
.ZeilenEnde:	tst.l	d1
		blt.s	.DasWars
		bsr	.TesteString
		beq.s	.NimmThisString
		bra.s	.EinKurzer

.TestTrennung:	*subq.l	#1,d1
		*blt.s	.DasWars
		*subq.l	#1,a3
		bsr	.TesteString
		beq.s	.NextB		
		*---- String zu lang 1 Word krzer ----*
.EinKurzer:	move.l	d1,d3
		subq.l	#1,a3
.EinKurzer_2:	subq.l	#1,d1
		blt.s	.NimmThisString2
		move.b	-(a3),d2
		*cmp.b	#"-",d2
		*beq.s	.NimmThisString
		*cmp.b	#",",d2
		*beq.s	.NimmThisString
		cmp.b	#" ",d2
		bne.s	.EinKurzer_2
		bra.s	.NimmThisString

		*--- a4=Textstart d1=Size ---*
.NimmThisString2:move.l	d3,d1
.NimmThisString:bsr.s	.ThisStringToNode
		beq.s	.Return				*No Mem
		tst.b	(a4,d1.w)
		beq.s	.DasWars
		lea	1(a4,d1.w),a4
		bra.s	.TextSchleife


.DasWars:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*---------- Pat der String in a4 mit Size in d1 ins Listview ----------------*
.TesteString:	movem.l	d1-a6,-(a7)
		moveq	#EPR_ErrorInArguments,d0
		tst.l	d1
		blt.s	.TesteString_2
		move.b	(a4,d1.w),d2
		move.l	d2,-(a7)
		clr.b	(a4,d1.w)
		move.l	a4,a0
		bsr	GetTextlength
		move.l	(a7)+,d2
		move.b	d2,(a4,d1.w)
		move.l	d0,d1
		moveq	#0,d0
		cmp.w	InfoWidth2(a5),d1
		blt.s	.TesteString_2
		moveq	#EPR_ErrorInString,d0
.TesteString_2:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*------- der String ab a3 wird mit der Lnge von D1 in die Node gehngt ------*
.ThisStringToNode:
		movem.l	d1-a6,-(a7)
		moveq	#0,d0
		tst.l	d1
		blt.s	.ThisError
		move.b	(a4,d1.w),d2
		move.l	d2,-(a7)
		clr.b	(a4,d1.w)
		move.l	a4,a0
		move.l	a4,-(a7)
		move.l	d6,a4
		bsr	AllocTheNode
		move.l	(a7)+,a4
		move.l	(a7)+,d2
		move.b	d2,(a4,d1.w)
.ThisError:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*----------------------------------------------------------------------------*
* Speicher fr Node-Struktur + String anfordern, an Liste anhngen und init  *
*									     *
* Input: a0=StringAdr							     *
*	 a4=Liste							     *
* Output:d0=NUll=Error	L						     *
*----------------------------------------------------------------------------*
AllocTheNode:	movem.l	d1-a6,-(sp)
		move.l	a0,a2
		bsr	BerechStringSize
		move.l	4,a6
		move.l	#$10000,d1
		add.l	#TML_Text+10,d0
		move.l	d0,d3
		jsr	_LVOAllocmem(a6)
		tst.l	d0
		beq.s	.Error

		move.l	d0,a3
		move.l	a4,a0
		move.l	d0,a1			;(erspart Arbeit)
		addtail
		lea	TML_Text(a3),a1
		move.l	a1,LN_Name(a3)
		move.l	d3,TML_Size(a3)

		move.w	d3,d1
		sub.w	#TML_Text+10+1,d1
		move.l	a2,a0
		bsr	StringCopy

		move.l	a3,d0

.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

GetTextlength:	movem.l	d1-a6,-(a7)
GetTextlength3:	lea	MyIntuiText(pc),a2
		move.l	Font(a5),8(a2)
		move.l	a0,12(a2)
		move.l	a2,a0
		move.l	IntSave(a5),a6
		jsr	_LVOIntuiTextLength(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*----------------------------------------------------------------------------*
StringCopy:	moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return		moveq	#0,d0
		rts

*---------------- Berechnet die Gre des Strings in a0 ---------------------*
*------- >= a0=String							-----*
*------- => d0=Stringsize						-----*
*----------------------------------------------------------------------------*
BerechStringSize:move.l a0,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest
		moveq	#-1,d0
.NextB:		addq.l	#1,d0
		tst.b	(a0)+
		bne.s	.NextB
.NoTest:	move.l	(a7)+,a0
		tst.l	d0
		rts

MyIntuiText:	dc.w	0,0
		dc.w	0,0
		dc.l	0			*Font
		dc.l	0			*Text
		dc.l	0			*Next

*-- Added by Eagleeye ---*





;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************
dectable2:
	dc.l	1,10
Dectable6
	dc.l	100
Dectable4
	dc.l	1000
dectable3
	dc.l	10000
dectable5
	dc.l	100000,1000000,10000000,100000000
dectable:

int:	dc.b	`intuition.library`,0
gad:	dc.b	`gadtools.library`,0
dos:	dc.b	`dos.library`,0
graf	dc.b	`graphics.library`,0

Aboutmessage:	dc.b	`       Eagleplayer Amplifiermanager `
		ver
		dc.b	10
		dc.b	`           1995,1996 Buggs of DEFECT`,10,10
		dc.b	`Contact Me At :`,10
		dc.b	`                  Henryk Richter`,10
		dc.b	`             Stephan-Jantzen-Ring  47`,10
		dc.b	`                  18106  Rostock`,10
		dc.b	`                     Germany`,10,10
		dc.b	`             Phone:  +49-0381-1208867`,10,10,0

Msg_Additional	dc.b	`ALARM !! Cannot allocate needed extra Memory !!`,10
		dc.b	`Not even about 160 Bytes free !!!`,0

Confile:	dc.b	`CON:10/10/250/40/NP_Manager`,0
Conout:		dc.b	`Needs Amiga OS2.04 or higher to run`,0
Conlen = *-Conout

MyAnalyzername:	dc.b	`E_AMP_Manager.1`,0
MyUsername:	dc.b	`AMP_Manager`,0

mybuggsname	dc.b	`Buggs of DEFECT`,0
myinfo		dc.b	`no text yet`,0

StatusX		dc.b	`status m fil`,0

NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0
	even
portname:	dc.b	`EAGLEPLAYERPORT`,0

my_easygadget:	dc.b	`   OK   `,0
my_easygadget2	dc.b	`Retry|Cancel`,0
my_easytitle:	dc.b	`Amplifiermanager Message`,0

ListviewText:
    DC.B    'available Amplifiers',0

UpText:
    DC.B    '_Up',0

DownText:
    DC.B    '_Down',0

DelText:
    DC.B    'Del',0

InfoText:
    DC.B    'Info',0

SortText:
    DC.B    'So_rt',0

AddText:
    DC.B    '_Add',0

exchgText:
    DC.B    'E_xchg.',0

ShowText:
    DC.B    '_Show',0

HideText:
    DC.B    '_Hide',0

TopazName:
	DC.B	'topaz.font',0
	CNOP	0,2


	cnop	0,4
MTags0:
	DC.L	GTMN_Newlookmenus,1
;	DC.L	GTMN_Frontpen,1
	dc.l	TAG_DONE

Project0GTypes:
    DC.W    LISTVIEW_KIND
    DC.W    BUTTON_KIND
    DC.W    BUTTON_KIND
    DC.W    BUTTON_KIND
    DC.W    LISTVIEW_KIND
    DC.W    BUTTON_KIND
    DC.W    BUTTON_KIND
    DC.W    BUTTON_KIND
    DC.W    BUTTON_KIND
    DC.W    BUTTON_KIND

Project0NGads:
    DC.W    5,13,256,64
    DC.L    ListviewText,0
    DC.W    GD_Listview
    DC.L    PLACETEXT_ABOVE,0,0
    DC.W    5,79,62,12
    DC.L    UpText,0
    DC.W    GD_Up
    DC.L    PLACETEXT_IN,0,0
    DC.W    5,93,62,12
    DC.L    DownText,0
    DC.W    GD_Down
    DC.L    PLACETEXT_IN,0,0
    DC.W    198,93,62,12
    DC.L    DelText,0
    DC.W    GD_Del
    DC.L    PLACETEXT_IN,0,0
    DC.W    265,13,203+extra_info,96
    DC.L    InfoText,0
    DC.W    GD_Info
    DC.L    PLACETEXT_ABOVE,0,0
    DC.W    69,93,62,12
    DC.L    SortText,0
    DC.W    GD_Sort
    DC.L    PLACETEXT_IN,0,0
    DC.W    198,79,62,12
    DC.L    AddText,0
    DC.W    GD_Add
    DC.L    PLACETEXT_IN,0,0
    DC.W    69,79,62,12
    DC.L    exchgText,0
    DC.W    GD_exchg
    DC.L    PLACETEXT_IN,0,0
    DC.W    134,79,62,12
    DC.L    ShowText,0
    DC.W    GD_Show
    DC.L    PLACETEXT_IN,0,0
    DC.W    134,93,62,12
    DC.L    HideText,0
    DC.W    GD_Hide
    DC.L    PLACETEXT_IN,0,0

myhook					;Filterhook, um zu groe Fonts nicht
					;anzuzeigen
	dcb.b	mln_size,0
	dc.l	my_hook
	dc.l	0
	dc.l	0

Project0GTags:
	DC.L	GTLV_ShowSelected,0
	dc.l	GTLV_CallBack,myhook
	DC.L    TAG_DONE
	DC.L    GT_Underscore,'_'
	DC.L    TAG_DONE
	DC.L    GT_Underscore,'_'
	DC.L    TAG_DONE
	DC.L    TAG_DONE
	DC.L    GTLV_ReadOnly,1
	DC.L    TAG_DONE
	DC.L    GT_Underscore,'_'
	DC.L    TAG_DONE
	DC.L    GT_Underscore,'_'
	DC.L    TAG_DONE
	DC.L    GT_Underscore,'_'
	DC.L    TAG_DONE
	DC.L    GT_Underscore,'_'
	DC.L    TAG_DONE
	DC.L    GT_Underscore,'_'
	DC.L    TAG_DONE

	even
Project0WindowTags:
Project0L:
	DC.L	WA_Left,0
Project0T:
	DC.L	WA_Top,0
Project0W:
	DC.L	WA_Width,0
Project0H:
	DC.L	WA_Height,0

	DC.L	WA_IDCMP,IDCMP_Changewindow!IDCMP_RawKey!IDCMP_Menupick!LISTVIEWIDCMP!BUTTONIDCMP!IDCMP_CLOSEWINDOW!IDCMP_REFRESHWINDOW
	DC.L	WA_Flags,WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_SMART_REFRESH

	DC.L	WA_Title,Project0WTitle
	DC.L	WA_ScreenTitle,Project0STitle
	dc.l	wa_newlookmenus,1
	dc.l	wa_autoadjust,1

	dc.l	wa_pubscreen
Pubadr
	dc.l	0
	dc.l	WA_Zoom
	dc.l	ZoomStruct
	DC.L	TAG_DONE,0
ZoomStruct
	dc.w	0,0,150,0

Ahawidth
	dc.l	399
Ahaheight
	dc.l	80

Project0WTitle:
    DC.B    'Amplifiermanager',0

Project0STitle:
    DC.B    'Amplifiermanager /Eagleplayer),  DEFECT Softworks',0

	even
IR:
	DC.L	GT_VisualInfo,$00000000;,GTBB_recessed,0
	dc.l	TAG_DONE

Project0NewMenu0:
    DC.B    NM_TITLE,0
    DC.L    Project0MName0
    DC.L    0
    DC.W    0
    DC.L    0,0

	DC.B	NM_ITEM,0
	DC.L	Project0MSysFont
	DC.L	0;Project0MCommPerc
Sysindicator
	DC.W	CHECKED!CHECKIT!Menutoggle
	DC.L	0,0

	DC.B    NM_ITEM,0
	DC.L    NM_BARLABEL,0
	DC.W    0
	DC.L    0,0

    DC.B    NM_ITEM,0
    DC.L    Project0MName6
    DC.L    Project0MComm6
    DC.W    0
    DC.L    0,0

    DC.B    NM_ITEM,0
    DC.L    Project0MName7
    DC.L    Project0MComm7
    DC.W    0
    DC.L    0,0

    DC.B    NM_ITEM,0
    DC.L    Project0MName8
    DC.L    Project0MComm8
    DC.W    0
    DC.L    0,0

    DC.B    NM_END,0
    DC.L    0,0
    DC.W    0
    DC.L    0,0

Project0MSysFont	dc.b	`System Default Font`,0
Project0MName0:		DC.B    'Project',0
Project0MName6:		DC.B    'About',0
Project0MComm6:		DC.B    'A',0
Project0MName7:		DC.B    'Hide',0
Project0MComm7:		DC.B    'H',0
Project0MName8:		DC.B    'Quit',0
Project0MComm8:		DC.B    'Q',0
	even
TD:
    DC.L    TAG_DONE

	ifne	test

AmplifierList:
	dc.l	.first

.first
	dc.l	0		;bra.w
	dc.l	.second
	dc.l	0
	dc.w	0
	dc.l	0		;eus_next
	dc.w	0		;eus_Usernr
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;EUS_Specialjumptab
	dc.l	0		;EUS_Taglist
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_KillModule!USMB_Zipwin!USMB_ChangeConfig!USMB_newsong!USMB_NewModule;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	myinfo
	dc.w	33		;eus_Kickstart
	dc.l	8		;eus_EPVersion
	dc.w	1,25		;eus_version,revision
	dc.l	MyUsername	;eus_username
	dc.w	Project0left	;eus_winx
	dc.w	Project0top	;eus_winy
	dc.w	EUSB_disable	;Amplifier disabled ?
	dc.w	0		;EUS_AMPriority
	dc.w	ENPB_NoWindow	;EUS_AMFlags -> no show/hide gadgets
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	dc.b	24,02,19,95	;EUS_Creatordate
	dc.b	0		;EUS_Priority
	dc.b	EUTY_Amplifier	;EUS_Type
	dc.w	0		;EUS_Reserved2
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6
.second
	dc.l	0		;bra.w
	dc.l	.third
	dc.l	0
	dc.w	0
	dc.l	0		;eus_next
	dc.w	0		;eus_Usernr
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;EUS_Specialjumptab
	dc.l	0		;EUS_Taglist
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_KillModule!USMB_Zipwin!USMB_ChangeConfig!USMB_newsong!USMB_NewModule;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	myinfo
	dc.w	33		;eus_Kickstart
	dc.l	8		;eus_EPVersion
	dc.w	1,25		;eus_version,revision
	dc.l	MyUsername	;eus_username
	dc.w	Project0left	;eus_winx
	dc.w	Project0top	;eus_winy
	dc.w	EUSB_openwin	;window opened
	dc.w	0		;EUS_AMPriority
	dc.w	0		;EUS_AMFlags
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	dc.b	24,02,19,95	;EUS_Creatordate
	dc.b	0		;EUS_Priority
	dc.b	EUTY_Amplifier	;EUS_Type
	dc.w	0		;EUS_Reserved2
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6
.third
	dc.l	0		;bra.w
	dc.l	.fourth
	dc.l	0
	dc.w	0
	dc.l	0		;eus_next
	dc.w	0		;eus_Usernr
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;EUS_Specialjumptab
	dc.l	0		;EUS_Taglist
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_KillModule!USMB_Zipwin!USMB_ChangeConfig!USMB_newsong!USMB_NewModule;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	myinfo
	dc.w	33		;eus_Kickstart
	dc.l	8		;eus_EPVersion
	dc.w	1,25		;eus_version,revision
	dc.l	.name		;eus_username
	dc.w	Project0left	;eus_winx
	dc.w	Project0top	;eus_winy
	dc.w	EUSB_disable	;Amplifier disabled ?
	dc.w	0		;EUS_AMPriority
	dc.w	ENPB_NoWindow	;EUS_AMFlags -> no show/hide gadgets
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	dc.b	24,02,19,95	;EUS_Creatordate
	dc.b	0		;EUS_Priority
	dc.b	EUTY_Amplifier	;EUS_Type
	dc.w	0		;EUS_Reserved2
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6
.fourth
	dc.l	0		;bra.w
	dc.l	.fifth
	dc.l	0
	dc.w	0
	dc.l	0		;eus_next
	dc.w	0		;eus_Usernr
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;EUS_Specialjumptab
	dc.l	0		;EUS_Taglist
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_KillModule!USMB_Zipwin!USMB_ChangeConfig!USMB_newsong!USMB_NewModule;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	myinfo
	dc.w	33		;eus_Kickstart
	dc.l	8		;eus_EPVersion
	dc.w	1,25		;eus_version,revision
	dc.l	.name2		;eus_username
	dc.w	Project0left	;eus_winx
	dc.w	Project0top	;eus_winy
	dc.w	EUSB_disable	;Amplifier disabled ?
	dc.w	0		;EUS_AMPriority
	dc.w	ENPB_NoWindow	;EUS_AMFlags -> no show/hide gadgets
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	dc.b	24,02,19,95	;EUS_Creatordate
	dc.b	0		;EUS_Priority
	dc.b	EUTY_Amplifier	;EUS_Type
	dc.w	0		;EUS_Reserved2
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6
.fifth
	dc.l	0		;bra.w
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0		;eus_next
	dc.w	0		;eus_Usernr
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;EUS_Specialjumptab
	dc.l	0		;EUS_Taglist
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_KillModule!USMB_Zipwin!USMB_ChangeConfig!USMB_newsong!USMB_NewModule;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	.info
	dc.w	33		;eus_Kickstart
	dc.l	8		;eus_EPVersion
	dc.w	1,25		;eus_version,revision
	dc.l	.name3		;eus_username
	dc.w	Project0left	;eus_winx
	dc.w	Project0top	;eus_winy
	dc.w	EUSB_disable	;Amplifier disabled ?
	dc.w	0		;EUS_AMPriority
	dc.w	ENPB_NoWindow	;EUS_AMFlags -> no show/hide gadgets
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	dc.b	24,02,19,95	;EUS_Creatordate
	dc.b	0		;EUS_Priority
	dc.b	EUTY_Amplifier	;EUS_Type
	dc.w	0		;EUS_Reserved2
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

.name:	dc.b	`8 voices Amiga`,0
.name2:	dc.b	`32 voices Amiga`,0
.name3:	dc.b	`32 voices Amiga 14 Bit`,0
.info	dc.b	`dies ist ein Dummy`,10
	dc.b	`Amplifier, der nichts`,10
	dc.b	`weiter macht, als dazusein`,0
	endc

;*********** Leertabellen (spter im BSS-Hunk) ***********************
		section	1,BSS
		rsreset
datas:
RealNumGadgets	rs.w	1
MyVariable	rs.l	1
Attr		rs.l	2
msgport		rs.l	1
intsave:	rs.l	1
grafsave	rs.l	1
gadsave:	rs.l	1
_dos		rs.l	1
Port:		rs.l	1
AgainAPort	rs.l	1
Jumpadr		rs.l	1
num_selected	rs.w	1
seconds		rs.l	1
micros		rs.l	1
Menuadr:	rs.l	1
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
;fontatt:	rs.l	1	;Fontattr Strukturadresse (entweder die des
				;Screens oder die eigene,wenn Screenfont zu
				;gro)
vi:		rs.l	1	;Visualinfo

;Mymess:		rs.b	UM_Sizeof
Mymessage:	rs.b	UM_sizeof	;Intuimessagestruktur

mytags:		rs.l	10*2
mycontextgad:	rs.b	gg_sizeof	;CreateContext() braucht Zeiger auf
					;leere Gadgetstruktur !?

mygad:		rs.b	gng_sizeof	;Platz fr New Gadget Struktur


Project0Gadgets:	rs.l	21
Gadgetadrs=Project0Gadgets

BufNewGad:		rs.w	4
			rs.l	2
			rs.w	1
			rs.l	3

myhoehe2:	rs.w	1
myhoehe1:	equ	myhoehe2
winwidth:	rs.w	1

List:		rs.b	lh_size
List2:		rs.b	lh_size

Project0GList:	rs.l	1
Project0Menus:	rs.l	1
Winhandle	rs.l	1
WindowDisabled	rs.w	1
Font:		rs.l	1
FontX:		rs.w	1
FontY:		rs.w	1
OffX:		rs.w	1
OffY:		rs.w	1
		rs.w	2

MY_Easystruct:	rs.l	1	;EASY-Request
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1
temp1		rs.l	128
temp2		rs.l	128
Temp3		rs.l	1		;### added by Eagleeye
Temp4		rs.l	1		;### added by Eagleeye
NoArgs		rs.l	1		;### -++- keine ArgStruct in MSG
stringtemp	rs.b	40
TrackString	rs.b	10
SizeString	rs.b	10
PattsString	rs.b	10
PattsString2	rs.b	10
Adr_Filename:	rs.l	1
temp:		rs.l	1

Pattmerk	rs.w	1
Pattmerk2	rs.w	1		;fr Prozentanzeige
numpos		rs.w	1
refreshflag	rs.b	1
counter		rs.b	1		;Frei
topazused	rs.b	1
modeid		rs.b	1

Intset	rs.w	1
inter:	rs.l	2
	rs.b	1	;2
	rs.b	1	;127
	rs.l	3

GetPOSJumpadr	rs.l	1
an_structadr	rs.l	1
Mytask		rs.l	1
MySignal	rs.l	1
immernull	rs.l	1
myobject	rs.l	1
merkpos		rs.l	1
currpos		rs.l	1
visible		rs.l	1
myplayertaglist	rs.l	1
maxtextwidth	rs.w	1
maxvisible	rs.w	1
SaveString	rs.l	1
myfontatt:	rs.l	1
		rs.w	2

MsgPort1:	rs.b	mp_size	;extra Messageport
MsgPort2:	rs.b	mp_size	;extra Messageport


U_micros	rs.l	1
U_seconds	rs.l	1
merk_seconds	rs.l	1
lasttime	rs.l	1
messagesent	rs.b	1
messagesent2	rs.b	1
savemodnr	rs.l	1
word7		rs.w	1	;Wort fr Absturz bei Modifikation
counter2	rs.w	1
		rs.b	1	:unused!
		rs.b	1	:unused!
exg		rs.b	1
clicked		rs.b	1	;wurde schon ein Amplifier angeklickt ?

;---------------- Wird mit den Prefs abgespeichert --------------------
ConfigDatas	rs.l	0
WinPosX		rs.w	1	;fr Window Zoom
WinPosY		rs.w	1
ZoomPosX	rs.w	1
ZoomPosY	rs.w	1
ZoomState	rs.b	1
onsysfont	rs.b	1
ConfigDatasEND	rs.l	0
;----------------------------------------------------------------------

MyRastport	rs.b	rp_sizeof
fontadr		rs.l	1

	ifne	debug
saveusernr	rs.w	1
	endc
InfoWidth2	rs.w	1
DatasLen:	rs.w	0
		ds.b	DatasLen
	end

