*****************************************************************************
**                                                                         **
** Internal Player Modules                                                 **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
*****************************************************************************
FirstInternal:
		dc.l	AMBK
		dc.w	"DE"
		ds.b	6
		dc.l	AC1D_TagListe
AMBK
		dc.l	AudioSculp
		dc.w	"DE"
		ds.b	6
		dc.l	AmBk_TagListe
AudioSculp:
		dc.l	CustomPlayer
		dc.w	"DE"
		ds.b	6
		dc.l	AS_TagListe

CustomPlayer:	dc.l	DigitalIllusions
		dc.w	"DE"
		ds.b	6
		dc.l	CU_TagListe

DigitalIllusions:
		dc.l	Eureka
		dc.w	"DE"
		ds.b	6
		dc.l	DI_TagListe
Eureka:	
		dc.l	FCMPacker
		dc.w	"DE"
		ds.b	6
		dc.l	NBK_TagListe
FCMPacker
		dc.l	Fuzz
		dc.w	"DE"
		ds.b	6
		dc.l	FCM_TagListe
Fuzz
		dc.l	GMC
		dc.w	"DE"
		ds.b	6
		dc.l	Fuzz_TagListe

GMC:		dc.l	HeatSeeker
		dc.w	"DE"
		ds.b	6
		dc.l	GMC_TagListe

HeatSeeker	dc.l	MellicaPacker
		dc.w	"DE"
		ds.b	6
		dc.l	HS_TagListe

MellicaPacker
		dc.l	Kript
		dc.w	"DE"
		ds.b	6
		dc.l	ME_TagListe
Kript:
		dc.l	Moduleprotector
		dc.w	0
		ds.b	6
		dc.l	KR_TagListe

ModuleProtector:
		dc.l	Noisepacker2
		dc.w	"DE"
		ds.b	6
		dc.l	MP_TagListe

NoisePacker2:	dc.l	NoisePacker3
		dc.w	"DE"
		ds.b	6
		dc.l	NP2_TagListe

NoisePacker3:	dc.l	NoiseRunner
		dc.w	"DE"
		ds.b	6
		dc.l	NP3_TagListe

NoiseRunner:	dc.l	Noisetrackercom
		dc.w	"DE"
		ds.b	6
		dc.l	NR_TagListe

NoiseTrackerCom:dc.l	OldSoundTracker
		dc.w	"DE"
		ds.b	6
		dc.l	NTC_TagListe

OldSoundTracker:dc.l	Polka
		dc.w	"DE"
		ds.b	6
		dc.l	OLDS_TagListe

Polka:		dc.l	Powermusic
		dc.w	"DE"
		ds.b	6
		dc.l	PPK_TagListe

Powermusic:	dc.l	Promizer20
		dc.w	"DE"
		ds.b	6
		dc.l	PM_TagListe

ProMizer20:	dc.l	Propacker10
		dc.w	"DE"
		ds.b	6
		dc.l	PR20_TagListe

ProPacker10:	dc.l	ProPacker1
		dc.w	"DE"
		ds.b	6
		dc.l	PP10_TagListe

ProPacker1:	dc.l	ProPacker21
		dc.w	"DE"
		ds.b	6
		dc.l	PP1_TagListe

ProPacker21:	dc.l	ProPacker30
		dc.w	"DE"
		ds.b	6
		dc.l	PP21_TagListe

ProPacker30:	dc.l	ProRunner1
		dc.w	"DE"
		ds.b	6
		dc.l	PP30_TagListe

ProRunner1:	dc.l	ProRunner2
		dc.w	"DE"
		ds.b	6
		dc.l	PRun_TagListe

ProRunner2:	dc.l	Protracker
		dc.w	"DE"
		ds.b	6
		dc.l	PRun2_TagListe

ProTracker:	dc.l	Skyt
		dc.w	"DE"
		ds.b	6
		dc.l	PRO_TagListe

Skyt		dc.l	SoundTrackerPro
		dc.w	"DE"
		ds.b	6
		dc.l	SKYT_TagListe
SoundTrackerPro
		dc.l	Startrekker
		dc.w	"DE"
		ds.b	6
		dc.l	STPRO_TagListe

Startrekker:	dc.l	StartrekkerPak
		dc.w	"DE"
		ds.b	6
		dc.l	ST_TagListe

Startrekkerpak:	dc.l	ThePlayer
		dc.w	"DE"
		ds.b	6
		dc.l	STPA_TagListe

ThePlayer:	dc.l	ThePlayer56
		dc.w	"DE"
		ds.b	6
		dc.l	P4_TagListe

ThePlayer56:	dc.l	TrackerPacker1
		dc.w	"DE"
		ds.b	6
		dc.l	P56_TagListe

TrackerPacker1	dc.l	MexxPacker
		dc.w	"DE"
		ds.b	6
		dc.l	TP1_TagListe

MexxPacker:	dc.l	TPacker3
		dc.w	"DE"
		ds.b	6
		dc.l	Mexx_TagListe

TPacker3:	dc.l	UnicTracker
		dc.w	"DE"
		ds.b	6
		dc.l	TP3_TagListe

UnicTracker:	dc.l	UnicTracker2
		dc.w	"DE"
		ds.b	6
		dc.l	Unic_TagListe

UnicTracker2:	dc.l	Wantonpacker
		dc.w	"DE"
		ds.b	6
		dc.l	Unic2_TagListe

Wantonpacker:	dc.l	XannPacker
		dc.w	"DE"
		ds.b	6
		dc.l	Wanton_TagListe

Xannpacker:	dc.l	0
		dc.w	"DE"
		ds.b	6
		dc.l	XA_TagListe

*------------------------------------------------------------------------*
CU_TagListe:
*		dc.l	Tag_More
*CU_RealSubTagList:
*		dc.l	0
		dc.l	DTP_InternalPlayer,1
		dc.l	DTP_PlayerVersion,2<<16!0
		dc.l	DTP_Creator,CU_Creator
		dc.l	DTP_Check1,CU_Check		*fr Fileloading
		dc.l	EP_CheckSegment,CU_SegCheck	*fr Segmentloading
		dc.l	DTP_PlayerName,CU_Name
		dc.l	MI_About,CU_About
		dc.l	EP_Flags,EPB_Packable
		dc.l	EP_Date
		dc.b	CD_Tag,CD_Monat
		dc.w	CD_Jahr
		dc.l	0

*------------------------------------------------------------------------*
CU_Creator:	dc.b	"Internal Player for Custom-Sounds,",10
		dc.b	"adapted by DEFECT",0
CU_Name:	dc.b	"CustomPlay",0
CU_About:	dc.b	"Replayer for Songs located at fixed addresses.",10
		dc.b	"Playerheader, Replayer, Sounddata are in one",10
		dc.b	"executable file !",0
		even

*------------------------------------------------------------------------*
* EPG_ChkSegment = Ptr to Segment not BCPL
CU_SegCheck:	move.l	EPG_ChkSegment(a5),d0
		beq.s	.Error
		move.l	d0,a1
		lea	4(a1),a1
		cmp.l	#"EPPL",(a1)
		bne.s	.OldDeli
		cmp.l	#"AYER",4(a1)
		beq.s	.Yep

.OldDeli:	lea	Delirium.Msg+4,a0
		moveq	#1,d0
		cmpm.l	(a0)+,(a1)+
		bne.s	.Error
		cmpm.l	(a0)+,(a1)+
		bne.s	.Error
.Yep:		move.l	EPG_ChkSegment(a5),a4

		move.l	12(a4),a6
		move.l	#DTP_CustomPlayer,d0		*Testen, ob Custom
		jsr	A5FindTag2(a5)			*player
		beq.s	.Error

		move.l	12(a4),a0
		move.l	a0,LoadPlayerAdr(a5)
		*move.l	a0,CU_SubTagList(a5)
		moveq	#0,d0
.Error		rts

*------------------------------------------------------------------------*
* Customsong nur laden, wenn nicht gepackt und wahrscheinlich Customsong *
* sonst wird Module bei LoadSeg geladen und CU_SegCheck getestet.	 *
*------------------------------------------------------------------------*
CU_Check:	move.l	DTG_ChkData(a5),a4
		moveq	#$30,d4
.NextB:		move.l	a4,a1
		bsr	.TesteString
		beq.s	.Ja
		lea	2(a4),a4
		dbf	d4,.NextB
		bra.s	.ErrCustomCheck

		*--- wahrscheinlich Customsong ---*
.Ja:		lea	PathPuffer(a5),a2
		move.l	a2,d1
		move.w	#1,LoadPlayerKennung(a5)
		jsr	A5LoadPlayer2(a5)
		beq.w	.ErrCustomCheck
		clr.w	LoadPlayerKennung(a5)
		move.l	a4,File(a5)

		move.l	12(a4),a6
		move.l	a6,LoadPlayerAdr(a5)
		moveq	#-1,d0
		move.l	d0,FileSizeNeu(a5)
		moveq	#0,d0
		rts

.EjectCustom:	move.l	File(a5),d0
		asr.l	#2,d1
		subq.l	#1,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)
		clr.l	File(a5)
.ErrCustomCheck:clr.w	LoadPlayerKennung(a5)
		moveq	#EPR_UnknownFormat,d0
		rts


.TesteString:	cmp.l	#$70ff4e75,(a1)
		bne.s	.OldDeli
		cmp.l	#"EPPL",4(a1)
		bne.s	.OldDeli
		cmp.l	#"AYER",8(a1)
		beq.s	.Ok

.OldDeli:	lea	Delirium.Msg,a0
		moveq	#1,d0
		cmpm.l	(a0)+,(a1)+
		bne.s	.Error
		cmpm.l	(a0)+,(a1)+
		bne.s	.Error
		cmpm.w	(a0)+,(a1)+
		bne.s	.Error
.Ok:		moveq	#0,d0
.Error:		rts


************************************************************************
* D.O.C. Soundtracker 2.0 Playroutine for all old Soundtracker Modules *
*		          to use within Delitracker and Eagleplayer    *
************************************************************************
OLDS_TagListe:
		dc.l	Tag_More,TrackerTags
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,OLDS_Name
		dc.l	DTP_Creator,OLDS_CName
		dc.l	EP_Check5,OLDS_Check
		dc.l	DTP_InitPlayer,OLDS_InitPlayer
		dc.l	EP_newmoduleinfo,OLDS_infobuffer
		dc.l	DTP_Extload,OLDS_extload
		dc.l	0
*---------------------------------------------------------------------------*
OLDS_Name:	dc.b	"OLDSoundTracker",0
OLDS_CName:	dc.b	"Karsten Obarski & Michael Kleps,",10
		dc.b	"adapted by DEFECT",0
		even

*------------------------------ Init-Player --------------------------------*
OLDS_InitPlayer:
	jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

	lea	$1d8(a0),a1
	moveq	#$7f,d0
	moveq	#0,d6
.mt_patt1
	cmp.b	(a1)+,d6
	bge.s	.mt_high
	move.b	-1(a1),d6
.mt_high
	dbf	d0,.mt_patt1
	addq.w	#1,d6
	move.l	d6,d0

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn

	move.l	ori_data(a5),a0
	move.l	d1,a1

	move.w	#$1d6>>1-1,d0
	lea	(a1),a2		;Ziel
	lea	(a0),a3		;Quelle
.mt_copyfront
	move.w	(a3)+,(a2)+
	dbf	d0,.mt_copyfront

	moveq	#15,d0
.mt_rep
	move.w	#1,28(A2)
	lea	$1e(a2),a2
	dbf	d0,.mt_rep

	lea	$3b6(a1),a2
	lea	$1d6(a0),a3
	moveq	#$82>>1-1,d0
.copysinfo
	move.w	(a3)+,(a2)+
	dbf	d0,.copysinfo

;	move.l	#`M.K.`,$438(a1)
	
	lea	$43C(a1),a2
	lea	$258(a0),a3
	mulu	#1024/4,d6		;Patterns mal 1024/4 (wegen .l)
	subq.w	#1,d6
.copypatts
	move.l	(a3)+,(A2)+
	dbf	d6,.copypatts

	move.l	a3,SamplePointer(a5)	;Adr 1. Sample
;	subq.l	#4,a3
	move.l	Ori_Data(a5),d0
	sub.l	d0,a3
	move.l	a3,Pro_InfoBuffer+52	:Songsize setzen

	*--------- Zum ProTracker-InitPlayer hpfen --------*
	moveq	#2,d1
	tst.w	MT_LInstrKennung(a5)	;Wurden Instrumente geladen
	bne.s	.con
	moveq	#1,d1			;convertiertes Module geladen
.con
	bra.w	ProT_PackInd

*--------------------- OldTracker Check-Routine ------------------------*
OLDS_Check:	move.l	dtg_ChkData(a5),a0
	moveq	#0,d7			;Lnge der Samples
	cmp.l	#`SONG`,$3c(a0)
	beq	.nooldst
	cmp.l	#`M.K.`,$438(a0)
	beq	.nooldst
	cmp.l	#`FLT4`,$438(a0)
	beq	.nooldst
	cmp.l	#`M!K!`,$438(a0)
	beq	.nooldst

	cmp.b	#0,$1d6(A0)
	beq	.nooldst
	cmp.b	#$80,$1d6(A0)
	bhi	.nooldst

	moveq	#$7f,d0
	lea	$1d8(a0),a2
	moveq	#0,d6
.mt_testwas
	cmp.b	(a2)+,d6
	bhs.s	.mt_hi
	move.b	-1(A2),d6
.mt_hi
	dbf	d0,.mt_testwas
	addq.w	#1,d6
	cmp.w	#64,d6
	bhi.w	.nooldst

	lea	42(A0),a2		;Zeiger auf 1. Samplelnge
	moveq	#$e,d3
.mt_loop
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d4

	move.w	(a2),d1			;Lnge in Worten
	bne.s	.mt_takesam
	cmp.l	#1,4(a2)
	bhi	.nooldst
	tst.b	2(A2)
	bne.w	.nooldst
	bra.s	.mt_nextsam
.mt_takesam
	add.l	d1,d7
	add.l	d1,d7
	bne.s	.mt_ok
	moveq	#1,d1
.mt_ok
	addq.w	#4,d1			;zur Sicherheit
	bgt.s	.mt_ok1
	subq.w	#4,d1
.mt_ok1
	add.l	d1,d1

	move.w	4(a2),d2		;Repeatstart
	cmp.l	d2,d1
	blt.w	.nooldst

	move.w	6(a2),d4		;Repeatlnge
;	add.l	d4,d4
	cmp.l	d4,d1
	blt.w	.nooldst

	cmp.b	#64,3(A2)
	bhi.w	.nooldst

.mt_nextsam
	add.l	#30,a2
	dbf	d3,.mt_loop

	tst.l	d7
	beq	.nooldst

	lea	$258(a0),a1
	move	#64*4-1,d0
	bsr.s	.checkpat		;1. Pattern muss 100%ig stimmen
	cmp	d3,d4
	bne	.nooldst

	move.w	d6,d0
	subq	#1,d0			;minus 1 Patt
	ble.s	.found
	mulu	#64*4,d0
	subq.w	#1,d0
	bsr.s	.checkpat
	tst	d3
	beq.s	.nooldst
	mulu	#100,d4
	divu	d3,d4
	cmp	#40,d4			;40% aller Noten mssen korrekt
					;sein !!!
	blo.s	.nooldst
.found
	moveq	#0,d0
	rts
.checkpat
	moveq	#0,d3
	moveq	#0,d4
.test
	move.w	(a1)+,d1
	and.w	#$fff,d1
	beq.s	.wei
	lea	Pr_Periods,a2	;Periodentabelle
	addq	#1,d3		;Num Notes
.lop2	move.w	(a2)+,d2
	beq.s	.wei
	cmp.w	d1,d2
	bne.s	.lop2
	addq	#1,d4		;Num Valid
.wei:	lea	2(a1),a1
	dbf	d0,.test
	rts
.nooldst
	moveq	#-1,d0
	rts
*----------------------------------------------------------------------------*
OLDS_ExtLoad:
		clr.w	MT_LInstrKennung(a5)	;Wurden Instrumente geladen
		move.l	DTG_ChkData(a5),a0
		move.l	a0,a1	
		lea	$1d8(a0),a1		;Berechne Gre des Songs
		moveq	#$7F,d3
		moveq	#0,d2
.OLDS_check3:
		cmp.b	(a1)+,d2
		bge.s	.hi
		move.b	-1(A1),d2
.hi
		dbra	d3,.OLDS_check3
		addq.b	#1,d2
		mulu	#1024,d2
		add.l	#600,d2			;SongSize in d2
		cmp.l	dtg_chksize(A5),d2	;ist geladenes File grer als
						;der Song allein ??
		bne.s	OLDS_Ok			;nein,Fehler

	*----- Nun die einzelnen Intrumente laden -----*
		LA0	Lnr_LoadingInstruments
		jsr	A5PrintText(a5)
		moveq	#15-1,d7			;SampleAnz
		bra.w	LoadTrackerSamples
OLDS_OK		moveq	#0,d0
		rts

	****************************************************
	*         Anarchy - In the Kitchen Replay          *
	****************************************************
AC1D_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,AC1D_Name
		dc.l	DTP_Creator,AC1D_CName
		dc.l	EP_Check5,AC1D_Check
		dc.l	DTP_InitPlayer,AC1D_InitPlayer
		dc.l	EP_newmoduleinfo,AC1D_infobuffer
		dc.l	0

	****************************************************
	*            Amos Music Bank Replay                *
	****************************************************
AMBK_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,AMBK_Name
		dc.l	DTP_Creator,AMBK_CName
		dc.l	EP_Check5,AMBK_Check
		dc.l	DTP_InitPlayer,AMBK_InitPlayer
		dc.l	EP_newmoduleinfo,AMBK_infobuffer
		dc.l	0

	************************************************
	* NoiseRunner 1.0 Playroutine for Eagleplayer  *
	************************************************
NR_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,NR_Name
		dc.l	DTP_Creator,NR_CName
		dc.l	EP_Check5,NR_Check
		dc.l	DTP_InitPlayer,NR_InitPlayer
		dc.l	EP_newmoduleinfo,NR_infobuffer
		dc.l	0

	*****************************************************
	* Game Music Creator - Playroutine for Eagleplayer  *
	*****************************************************
GMC_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,GMC_Name
		dc.l	DTP_Creator,GMC_CName
		dc.l	EP_Check5,GMC_Check
		dc.l	DTP_InitPlayer,GMC_InitPlayer
		dc.l	EP_newmoduleinfo,GMC_infobuffer
		dc.l	0

	****************************************************
	* Digital Illusions - Playroutine for Eagleplayer  *
	****************************************************
DI_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,DI_Name
		dc.l	DTP_Creator,DI_CName
		dc.l	EP_Check5,DI_Check
		dc.l	DTP_InitPlayer,DI_InitPlayer
		dc.l	EP_newmoduleinfo,DI_infobuffer
		dc.l	0

	****************************************************
	* Digital Illusions - Playroutine for Eagleplayer  *
	****************************************************
NBK_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,NBK_Name
		dc.l	DTP_Creator,NBK_CName
		dc.l	EP_Check5,NBK_Check
		dc.l	DTP_InitPlayer,NBK_InitPlayer
		dc.l	EP_newmoduleinfo,NBK_infobuffer
		dc.l	0

	**********************************************
	* FC-M packer - Playroutine for Eagleplayer  *
	**********************************************
FCM_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,FCM_Name
		dc.l	DTP_Creator,FCM_CName
		dc.l	EP_Check5,FCM_Check
		dc.l	DTP_InitPlayer,FCM_InitPlayer
		dc.l	EP_newmoduleinfo,FCM_infobuffer
		dc.l	0

	************************************************
	* Fuzzac Packer - Playroutine for Eagleplayer  *
	************************************************
Fuzz_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,Fuzz_Name
		dc.l	DTP_Creator,Fuzz_CName
		dc.l	EP_Check5,Fuzz_Check
		dc.l	DTP_InitPlayer,Fuzz_InitPlayer
		dc.l	EP_newmoduleinfo,Fuzz_infobuffer
		dc.l	0

	***************************************************
	* Heatseeker MC1.0 - Playroutine for Eagleplayer  *
	***************************************************
HS_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,HS_Name
		dc.l	DTP_Creator,HS_CName
		dc.l	EP_Check5,HS_Check
		dc.l	DTP_InitPlayer,HS_InitPlayer
		dc.l	EP_newmoduleinfo,HS_infobuffer
		dc.l	0

	**********************************************
	* Skyt-Packer - Playroutine for Eagleplayer  *
	**********************************************
SKYT_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,SKYT_Name
		dc.l	DTP_Creator,SKYT_CName
		dc.l	EP_Check5,SKYT_Check
		dc.l	DTP_InitPlayer,SKYT_InitPlayer
		dc.l	EP_newmoduleinfo,SKYT_infobuffer
		dc.l	0

	**********************************************
	* Skyt-Packer - Playroutine for Eagleplayer  *
	**********************************************
STPRO_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,STPRO_Name
		dc.l	DTP_Creator,STPRO_CName
		dc.l	EP_Check5,STPRO_Check
		dc.l	DTP_InitPlayer,STPRO_InitPlayer
		dc.l	EP_newmoduleinfo,STPRO_infobuffer
		dc.l	0

	****************************************************
	* StartrekkerPacker - Playroutine for Eagleplayer  *
	****************************************************
STPA_TagListe
	dc.l	Tag_More,TrackerTags2
	;dc.l	Tag_More,Protrackertags
	dc.l	DTP_PlayerName,STPA_Name
	dc.l	DTP_Creator,STPA_CName
	dc.l	EP_Check5,STPA_Check
	dc.l	DTP_InitPlayer,STPA_InitPlayer
	dc.l	EP_newmoduleinfo,STPA_infobuffer
	dc.l	0


	**************************************************
	* TrackerPacker I - Playroutine for Eagleplayer  *
	**************************************************
TP1_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,TP1_Name
		dc.l	DTP_Creator,MEXX_CName
		dc.l	EP_Check5,TP1_Check
		dc.l	DTP_InitPlayer,TP1_InitPlayer
		dc.l	EP_newmoduleinfo,TP1_infobuffer
		dc.l	0

	***************************************************
	* TrackerPacker II - Playroutine for Eagleplayer  *
	***************************************************
Mexx_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,Mexx_Name
		dc.l	DTP_Creator,Mexx_CName
		dc.l	EP_Check5,Mexx_Check
		dc.l	DTP_InitPlayer,Mexx_InitPlayer
		dc.l	EP_newmoduleinfo,MEXX_infobuffer
		dc.l	0

	*************************************************
	* Trackerpacker3 - Playroutine for Eagleplayer  *
	*************************************************
TP3_TagListe
		dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,TP3_Name
		dc.l	DTP_Creator,TP3_CName
		dc.l	EP_Check5,TP3_Check
		dc.l	DTP_InitPlayer,TP3_InitPlayer
		dc.l	EP_newmoduleinfo,TP3_infobuffer
		dc.l	0


	**************************************************
	* Moduleprotector - Playroutine for Eagleplayer  *
	**************************************************
MP_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,MP_Name
		dc.l	DTP_Creator,MP_CName
		dc.l	EP_Check5,MP_Check
		dc.l	DTP_InitPlayer,MP_InitPlayer
		dc.l	EP_NewModuleInfo,MP_InfoBuffer
		dc.l	0


	************************************************
	** ProMizer 2.0  Playroutine for Eagleplayer  **
	************************************************
PR20_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,PR20_Name
		dc.l	DTP_Creator,PR20_CName
		dc.l	EP_Check5,PR20_Check
		dc.l	DTP_InitPlayer,PR20_InitPlayer
		dc.l	EP_newmoduleinfo,PR20_infobuffer
		dc.l	0

	************************************************
	** Propacker 1.0 Playroutine for Eagleplayer  **
	************************************************
PP10_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,PP10_Name
		dc.l	DTP_Creator,PP10_CName
		dc.l	EP_Check5,PP10_Check
		dc.l	DTP_InitPlayer,PP10_InitPlayer
		dc.l	EP_newmoduleinfo,PP10_infobuffer
		dc.l	0

	****************************************************************
	** Propacker 1.0 by Static Bytes Playroutine for Eagleplayer  **
	****************************************************************
PP1_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,PP1_Name
		dc.l	DTP_Creator,PP21_CName
		dc.l	EP_Check5,PP1_Check
		dc.l	DTP_InitPlayer,PP1_InitPlayer
		dc.l	EP_newmoduleinfo,PP1_infobuffer
		dc.l	0

	************************************************
	** Propacker 2.1 Playroutine for Eagleplayer  **
	************************************************
PP21_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,PP21_Name
		dc.l	DTP_Creator,PP21_CName
		dc.l	EP_Check5,PP21_Check
		dc.l	DTP_InitPlayer,PP21_InitPlayer
		dc.l	EP_newmoduleinfo,PP21_infobuffer
		dc.l	0

	************************************************
	** Propacker 3.0 Playroutine for Eagleplayer  **
	************************************************
PP30_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,PP30_Name
		dc.l	DTP_Creator,PP21_CName
		dc.l	EP_Check5,PP30_Check
		dc.l	DTP_InitPlayer,PP30_InitPlayer
		dc.l	EP_newmoduleinfo,PP30_infobuffer
		dc.l	0

	**********************************************
	** NoiseTracker Compressed for Eagleplayer  **
	**********************************************
ME_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,ME_Name
		dc.l	DTP_Creator,ME_CName
		dc.l	EP_NewModuleInfo,ME_InfoBuffer
		dc.l	EP_Check5,ME_Check
		dc.l	DTP_InitPlayer,ME_InitPlayer
		dc.l	0

;	**************************************************
;	** NoisePacker 2/3 Playroutine for Eagleplayer  **
;	**************************************************
NP2_TagListe:	dc.l	EP_Check5,NP2_Check
		dc.l	DTP_PlayerName,NP2_Name
		dc.l	EP_newmoduleinfo,NP2_infobuffer
NP3_TagListe:	dc.l	EP_Check5,NP3_Check
		dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_Creator,NP_CName
		dc.l	DTP_PlayerName,NP3_Name
		dc.l	DTP_InitPlayer,NP3_InitPlayer
		dc.l	EP_newmoduleinfo,NP3_infobuffer
		dc.l	0

	**********************************************
	** NoiseTracker Compressed for Eagleplayer  **
	**********************************************
NTC_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,NTC_Name
		dc.l	DTP_Creator,NTC_CName
		dc.l	EP_NewModuleInfo,NTC_InfoBuffer
		dc.l	EP_Check5,NTC_Check
		dc.l	DTP_InitPlayer,NTC_InitPlayer
		dc.l	0

	**********************************************
	** NoiseTracker Compressed for Eagleplayer  **
	**********************************************
PM_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,PM_Name
		dc.l	DTP_Creator,PM_CName
		dc.l	EP_NewModuleInfo,PM_InfoBuffer
		dc.l	EP_Check5,PM_Check
		dc.l	DTP_InitPlayer,PM_InitPlayer
		dc.l	0

	**********************************************
	**              PolkaPacker                 **
	**********************************************
PPK_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,PPK_Name
		dc.l	DTP_Creator,PPK_CName
		dc.l	EP_NewModuleInfo,PPK_InfoBuffer
		dc.l	EP_Check5,PPK_Check
		dc.l	DTP_InitPlayer,PPK_InitPlayer
		dc.l	0

	***********************************************
	** Unic-Tracker Playroutine for Eagleplayer  **
	***********************************************
Unic_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,Unic_Name
		dc.l	DTP_Creator,Unic_CName
		dc.l	EP_Check5,Unic_Check
		dc.l	DTP_InitPlayer,Unic_InitPlayer
		dc.l	EP_newmoduleinfo,Unic_infobuffer
		dc.l	0

	***********************************************
	** Unic-Tracker Playroutine for Eagleplayer  **
	***********************************************
Unic2_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,Unic2_Name
		dc.l	DTP_Creator,Unic_CName
		dc.l	EP_Check5,Unic2_Check
		dc.l	DTP_InitPlayer,Unic2_InitPlayer
		dc.l	EP_newmoduleinfo,Unic2_infobuffer
		dc.l	0

	*************************************************
	** The Player 4.x Playroutine for Eagleplayer  **
	*************************************************
P4_TagListe:
		dc.l	DTP_EndPlayer,P56_EndPlayer
		dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	EP_HelpNodeName,ThePlayerHNN
		dc.l	DTP_PlayerName,P4_Name
		dc.l	DTP_Creator,P4_CName
		dc.l	EP_Check5,P4_Check
		dc.l	DTP_InitPlayer,P4_InitPlayer
		dc.l	DTP_ExtLoad,P4_ExtLoad
		dc.l	EP_newmoduleinfo,P4_infobuffer
		dc.l	0

	*******************************************************
	** The Player 5.0a/6.0a Playroutine for Eagleplayer  **
	*******************************************************
P56_TagListe:
		dc.l	EP_HelpNodeName,ThePlayerHNN
		dc.l	EP_SaveAsPT,P56_SavePT
		dc.l	EP_Save,P56_Save
		dc.l	DTP_EndPlayer,P56_EndPlayer
		dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,P56_Name
		dc.l	DTP_Creator,P56_CName
		dc.l	DTP_ExtLoad,P56_ExtLoad
		dc.l	EP_newmoduleinfo,P56_infobuffer
		dc.l	DTP_InitPlayer,P56_InitPlayer
		dc.l	EP_Check5,P56_Check
		dc.l	0


	************************************************
	* Prorunner 1.0 Playroutine for Eagleplayer    *
	************************************************
PRun_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,PRun_Name
		dc.l	DTP_Creator,PRun_CName
		dc.l	EP_Check5,PRun_Check
		dc.l	DTP_InitPlayer,PRun_InitPlayer
		dc.l	EP_newmoduleinfo,PRun_infobuffer
		dc.l	0

	************************************************
	* Prorunner 2.0 Playroutine for Eagleplayer    *
	************************************************
PRun2_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,PRun2_Name
		dc.l	DTP_Creator,PRun_CName
		dc.l	EP_Check5,PRun2_Check
		dc.l	DTP_InitPlayer,PRun2_InitPlayer
		dc.l	EP_newmoduleinfo,PRun2_infobuffer
		dc.l	0


	***************************************************
	* Wantonpacker 1.0 Playroutine for Eagleplayer    *
	***************************************************
Wanton_TagListe:dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,WN_Name
		dc.l	DTP_Creator,WN_CName
		dc.l	EP_Check5,WN_Check
		dc.l	DTP_InitPlayer,WN_InitPlayer
		dc.l	EP_newmoduleinfo,WN_infobuffer
		dc.l	0

	***************************************************
	*      XANNpacker Playroutine for Eagleplayer     *
	***************************************************
XA_TagListe:	dc.l	Tag_More,TrackerTags2
		;dc.l	Tag_More,Protrackertags
		dc.l	DTP_PlayerName,XA_Name
		dc.l	DTP_Creator,XA_CName
		dc.l	EP_Check5,XA_Check
		dc.l	DTP_InitPlayer,XA_InitPlayer
		dc.l	EP_newmoduleinfo,XA_infobuffer
		dc.l	0


n_note		EQU	0  	;W
n_cmd		EQU	2  	;W
n_cmdlo		EQU	3  	;low B of cmd
n_start		EQU	4  	;L
n_length	EQU	8  	;W
n_loopstart	EQU	10 	;L
n_replen	EQU	14 	;W
n_period	EQU	16 	;W
n_finetune	EQU	18 	;B
n_volume	EQU	19 	;B
n_dmabit	EQU	20 	;W
n_toneportdirec	EQU	22 	;B
n_toneportspeed	EQU	23 	;B
n_wantedperiod	EQU	24 	;W
n_vibratocmd	EQU	26 	;B
n_vibratopos	EQU	27 	;B
n_tremolocmd	EQU	28 	;B
n_tremolopos	EQU	29 	;B
n_wavecontrol	EQU	30 	;B
n_glissfunk	EQU	31 	;B
n_sampleoffset	EQU	32 	;B
n_pattpos	EQU	33 	;B
n_loopcount	EQU	34 	;B
n_funkoffset	EQU	35 	;B
n_wavestart	EQU	36 	;L
n_reallength	EQU	40 	;W
n_trigger	EQU	42 	;B
n_samplenum	EQU	43 	;B
n_copyadrs	EQU	44	;L Adresse, von der ab weiterkopiert wird
n_copyadrd	EQU	48	;L Adresse, auf die weiterkopiert wird
n_copysize	EQU	52	;L Lnge, die noch zu kopieren ist
n_memstart	EQU	56	;L Adresse im Chipmem, wo das Sample hin soll
n_sampleadr	EQU	60	;L Adresse des Samples
n_copySoffset	EQU	64	;L Lnge der zu kopierenden Bytes bei
				;  Sampleoffset
n_SoffSource	EQU	68	;L SourceAdresse bei Sampleoffset
n_SoffDest	EQU	72	;L Zieladresse bei Sampleoffset
	

	***********************************************
	* Protracker Playroutine for Eagleplayer      *
	* (C) Amiga Freelancers / Adaption by Defect  *
	***********************************************
KR_TagListe:	dc.l	DTP_PlayerName,KR_Name
		dc.l	DTP_Creator,KR_CName
		dc.l	DTP_InitPlayer,KR_InitPlayer
		dc.l	DTP_UserConfig,KR_Config
		dc.l	EP_Check5,KR_Check

	***********************************************
	* Protracker Playroutine for Eagleplayer      *
	* (C) Amiga Freelancers / Adaption by Defect  *
	***********************************************
Pro_TagListe:	dc.l	Tag_More,TrackerTags
		dc.l	DTP_PlayerName,Pro_Name
		dc.l	DTP_Creator,Pro_CName
		dc.l	EP_Check5,Pro_Check
		dc.l	EP_Check8,Pro_Check2
		dc.l	DTP_InitPlayer,Pro_InitPlayer
		dc.l	EP_newmoduleinfo,Pro_infobuffer
		dc.l	DTP_ExtLoad,Pro_ExtLoad
		dc.l	0

TrackerTags:	dc.l	DTP_UserConfig,Pro_UserConfig
TrackerTags2:	dc.l	DTP_InternalPlayer,1
		dc.l	EP_PlayerVersion,Eagleversion
		dc.l	EP_InitAmplifier,InitAudstruct
		dc.l	DTP_PlayerVersion,2<<16!0
	;	dc.l	EP_Voices,Pr_SetVoices
	;	dc.l	DTP_Volume,Pr_SetVoices
	;	dc.l	DTP_Balance,Pr_SetVoices
	;	dc.l	EP_StructInit,Pro_GetStrucAdr
		dc.l	EP_Flags,EPB_EPAudioAlloc!EPB_VolBalVoi!EPB_InternalUPSStructure!EPB_Packable!EPB_VolVoices!EPB_Save!EPB_Restart!EPB_Songend!EPB_Volume!EPB_Balance!EPB_Voices!EPB_Analyzer!EPB_Moduleinfo!EPB_Prevpatt!EPB_Nextpatt!EPB_LoadFast
		dc.l	EP_SetSpeed,Pro_NewSpeed
		
		dc.l	EP_Date
		dc.b	CD_Tag,CD_Monat
		dc.w	CD_Jahr

;ProtrackerTags:
		dc.l	DTP_EndPlayer,Pro_EndPlayer

		dc.l	DTP_StartInt,Pro_Startint	
		dc.l	DTP_StopInt,Pro_Stopint
		dc.l	DTP_Interrupt,_Pro_Music

		dc.l	DTP_InitSound,Pro_Init
		dc.l	DTP_EndSound,Pro_End

		dc.l	DTP_NextPatt,Pro_NextPattern
		dc.l	DTP_PrevPatt,Pro_BackPattern
		dc.l	EP_GetPositionNr,Pro_GetPosNr
		dc.l	EP_SetSpeed,Pro_SetTimer
		dc.l	EP_Save,Pro_Save
		dc.l	EP_SaveAsPT,Pro_Save
		dc.l	EP_SampleInit,Pro_SampleInit
		dc.l	EP_Patterninit,Pro_Pattinit
		dc.l	0

MT_Data:	dc.l	0	
MT_Size:	dc.l	0
;MT_VolVoice1	dc.w	64
;MT_VolVoice2	dc.w	64
;MT_VolVoice3	dc.w	64
;MT_VolVoice4	dc.w	64
StructAdr:	dc.l	0			;Adr der UPS_Structure


*------------------------------------------------------------------------*

PRO_NamePuffer:	ds.b	21

Pro_Name:	dc.b	"Protracker",0
Pro_CName:	dc.b	"Lars `Zap` Hamre, adapted by DEFECT,",0

PRun2_Name:	dc.b	"ProRunner 2.0",0
PRun_Name:	dc.b	"ProRunner 1.0",0
PRun_CName:	dc.b	"Cosmos of Sanity,",10
		dc.b	"adapted by DEFECT",0

NP2_Name:	dc.b	"NoisePacker 2.x",0
NP3_Name:	dc.b	"NoisePacker 3.x",0
NP_CName:	dc.b	"The Twins of Phenomena,",10
		dc.b	"adapted by DEFECT",0

WN_Name:	dc.b	"Wantonpacker",0
WN_CName:	dc.b	"Wanton of Bloodsuckers,",10
		dc.b	"adapted by DEFECT",0

XA_Name:	dc.b	"XANN-Packer",0
XA_CName:	dc.b	"Xann of The Silents,",10
		dc.b	"adapted by DEFECT",0

GMC_Name:	dc.b	"Game Music Creator",0
GMC_CName:	dc.b	"Andreas Tadic,",10
		dc.b	"adapted by DEFECT",0

MP_Name:	dc.b	"ModuleProtector",0
MP_CName:	dc.b	"Matrix/LSD,",10
		dc.b	"adapted by DEFECT",0

STPA_Name:	dc.b	`Startrekker Packer`,0
STPA_CName:	dc.b	`Mr. Spiv of Cave`,10
		dc.b	`adapted by DEFECT`,0

TP1_Name:	dc.b	"Trackerpacker 1",0

Mexx_Name:	dc.b	"Trackerpacker 2",0

TP3_Name:	dc.b	"Trackerpacker 3",0


Mexx_CName:
TP3_CName:	dc.b	"Crazy Crack of Complex,",10
		dc.b	"adapted by DEFECT",0

KR_Name:	dc.b	"Kript",0
KR_CName:	dc.b	"Raster Master of Italian,",10
		dc.b	"adapted by DEFECT",0

NR_Name:	dc.b	"NoiseRunner",0
NR_CName:	dc.b	"Chaos of Sanity,",10
		dc.b	"adapted by DEFECT",0

DI_Name:	dc.b	"Digital Illusions",0
DI_CName:	dc.b	"Digital Illusions,",10
		dc.b	"adapted by DEFECT",0

AC1D_Name:	dc.b	"AC1D-DC1A-Packer",0
AC1D_CName:	dc.b	"Anarchy ??,",10
		dc.b	"adapted by DEFECT",0

AMBK_Name:	dc.b	"Amos Music Bank",0
AMBK_CName:	dc.b	"Franois Lionet,",10
		dc.b	"adapted by DEFECT",0

NBK_Name:	dc.b	"Eureka-Packer",0
NBK_CName:	dc.b	"Eureka of Concept,",10
		dc.b	"adapted by DEFECT",0

FCM_Name:	dc.b	"FC-M Packer",0
FCM_CName:	dc.b	"???,",10
		dc.b	"adapted by DEFECT",0

Fuzz_Name:	dc.b	"Fuzzac Packer",0
Fuzz_CName:	dc.b	"???,",10
		dc.b	"adapted by DEFECT",0

HS_Name:	dc.b	"Heatseeker MC1.0",0
HS_CName:	dc.b	"Heatseeker of Cryptoburners,",10
		dc.b	"adapted by DEFECT",0

SKYT_Name:	dc.b	"Skyt-Packer",0
SKYT_CName:	dc.b	"Skyt / The Drifters,",10
		dc.b	"adapted by DEFECT",0

STPRO_Name:	dc.b	"Soundtracker Pro 3.0",0
STPRO_CName:	dc.b	"marco@amiga.hs.nl,",10
		dc.b	"adapted by DEFECT",0

ME_Name:	dc.b	"Kefrens Sound Machine",0
ME_CName:	dc.b	"Razmo of Kefrens,",10
		dc.b	"adapted by DEFECT",0

NTC_Name:	dc.b	"NoiseTracker Compressed",0
NTC_CName:	dc.b	"United Forces / UFO,",10
		dc.b	"adapted by DEFECT",0

PM_Name:	dc.b	"Powermusic",0
PM_CName:	dc.b	"Joakim gren,",10
		dc.b	"adapted by DEFECT",0

PPK_Name:	dc.b	"Polkarunner",0
PPK_CName:	dc.b	"???,",10
		dc.b	"adapted by DEFECT",0
Unic2_Name:	dc.b	"Unic-Tracker 2",0
Unic_Name:	dc.b	"Unic-Tracker",0
Unic_CName:	dc.b	"Laxity of Kefrens,",10
		dc.b	"adapted by DEFECT",0

PP10_Name:	dc.b	"ProPacker_1.0",0
PP10_CName:	dc.b	"Azatoth of Phenomena,",10
		dc.b	"adapted by DEFECT",0

PR20_Name:	dc.b	"Promizer 2.0",0
PR20_CName:	dc.b	"Frank Hlsmann,",10
		dc.b	"adapted by DEFECT",0

PP1_Name:	dc.b	"ProPacker 1.0",0
PP21_Name:	dc.b	"ProPacker 2.1",0
PP30_Name:	dc.b	"ProPacker 3.0",0
PP21_CName:	dc.b	"C. Estrup (Static Bytes),",10
		dc.b	"adapted by DEFECT",0

ThePlayerHNN:	dc.b	"The Player",0
P4_Name:	dc.b	"The Player 4.x",0
P4_CName:	dc.b	"Jarno Paananen,",10
		dc.b	"adapted by DEFECT",0
P56_Name:	dc.b	"The Player 5.0a/6.0a/6.1a",0
P56_CName:	dc.b	"Jarno Paananen,",10
		dc.b	"adapted by DEFECT",0
P50_Name	dc.b	`The Player 5.0a`,0
P60_Name	dc.b	`The Player 6.0a`,0
P61_Name	dc.b	`The Player 6.1a`,0
P40_Name:	dc.b	"The Player 4."
P0ASign		dc.b	"0a",0

TKriptCode:	dc.b	"Kriptcode: ",0
PR_Prefix:	dc.b	"MOD.",0
PRun_Prefix:	dc.b	"PRun.",0
PRun2_Prefix:	dc.b	"PRun2.",0
NP2_Prefix:	dc.b	"NP2.",0
NP3_Prefix:	dc.b	"NP3.",0
WN_Prefix:	dc.b	"WP.",0
XA_Prefix:	dc.b	"XANN.",0
NR_Prefix:	dc.b	"NR.",0
Unic_Prefix:	dc.b	"Unic.",0
Unic2_Prefix:	dc.b	"Unic2.",0
PR20_Prefix:	dc.b	"PR20.",0
PP10_Prefix:	dc.b	"PP10.",0
PP21_Prefix:	dc.b	"PP21.",0
PP1_Prefix:	dc.b	"PP10.",0
PP30_Prefix:	dc.b	"PP30.",0
P4_Prefix:	dc.b	"P4x.",0
P56_Prefix:	dc.b	"P60.",0
GMC_Prefix:	dc.b	"GMC.",0
DI_Prefix:	dc.b	"DI.",0
AC1D_Prefix:	dc.b	"AC1D.",0
AMBK_Prefix:	dc.b	"ABK.",0
NBK_Prefix:	dc.b	"Eureka.",0
FCM_Prefix:	dc.b	"FC-M.",0
Fuzz_Prefix:	dc.b	"Fuzz.",0
HS_Prefix:	dc.b	"HS.",0
Skyt_Prefix:	dc.b	"Skyt.",0
Stpro_Prefix:	dc.b	"STP.",0
TP1_Prefix	dc.b	`TP1.`,0
Mexx_Prefix:	dc.b	"TP2.",0
TP3_Prefix:	dc.b	"TP3.",0
ME_Prefix:	dc.b	"KSM.",0
NTC_Prefix:	dc.b	"NTC.",0
PM_Prefix:	dc.b	"MOD.",0
PPK_Prefix:	dc.b	"PPK.",0
SMP_Name:	dc.b	"SMP.",0
MP_Prefix	dc.b	`MP`,0
STPA_Prefix	dc.b	`Star.`,0
		even 

*------------------ Tag-Item Struktur fr Module-Info ---------------------*
PRun_InfoBuffer:dc.l	MI_Prefix,PRun_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

PRun2_InfoBuffer:dc.l	MI_Prefix,PRun2_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

HS_InfoBuffer:	dc.l	MI_Prefix,HS_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

STPRO_InfoBuffer:
		dc.l	MI_Prefix,STPRO_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

Skyt_InfoBuffer	dc.l	MI_Prefix,Skyt_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

NP2_InfoBuffer:	dc.l	MI_Prefix,NP2_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

NP3_InfoBuffer:	dc.l	MI_Prefix,NP3_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

WN_InfoBuffer:	dc.l	MI_Prefix,WN_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

FCM_InfoBuffer:	dc.l	MI_Prefix,FCM_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

Fuzz_InfoBuffer	dc.l	MI_Prefix,Fuzz_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

STPA_InfoBuffer dc.l	MI_Prefix,STPA_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

XA_InfoBuffer:	dc.l	MI_Prefix,XA_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

Unic_InfoBuffer:dc.l	MI_Prefix,Unic_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

Unic2_InfoBuffer:dc.l	MI_Prefix,Unic2_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

PP10_InfoBuffer:dc.l	MI_Prefix,PP10_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

PR20_InfoBuffer:dc.l	MI_Prefix,PR20_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

PP21_InfoBuffer:dc.l	MI_Prefix,PP21_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

PP1_InfoBuffer:dc.l	MI_Prefix,PP1_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

PP30_InfoBuffer:dc.l	MI_Prefix,PP30_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

P4_InfoBuffer:
		dc.l	MI_Soundsystem,P40_Name
		dc.l	MI_Prefix,P4_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

P56_InfoBuffer:
		dc.l	MI_Soundsystem,0
		dc.l	MI_Prefix,P56_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

GMC_InfoBuffer:	dc.l	MI_Prefix,GMC_Prefix
		dc.l	MI_MaxSamples,15
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

DI_InfoBuffer:	dc.l	MI_Prefix,DI_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

AC1D_InfoBuffer:
		dc.l	MI_Prefix,AC1D_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

AMBK_InfoBuffer:
		dc.l	MI_Prefix,AMBK_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

NBK_InfoBuffer:	dc.l	MI_Prefix,NBK_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

TP1_InfoBuffer:dc.l	MI_Prefix,TP1_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

Mexx_InfoBuffer:dc.l	MI_Prefix,Mexx_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

TP3_InfoBuffer:dc.l	MI_Prefix,TP3_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0


MP_InfoBuffer:	dc.l	MI_Prefix,MP_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0


ME_InfoBuffer:	dc.l	MI_Prefix,ME_Prefix
		dc.l	MI_MaxSamples,15
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

NTC_InfoBuffer:	dc.l	MI_Prefix,NTC_Prefix
		dc.l	TAG_More,PackedTrackerInfo
		dc.l	0

PM_InfoBuffer:	dc.l	MI_Prefix,PM_Prefix
		dc.l	TAG_More,Pro_Infobuffer
		dc.l	0

PPK_InfoBuffer:	dc.l	MI_Prefix,PPK_Prefix
		dc.l	TAG_More,Pro_Infobuffer
		dc.l	0


OLDS_Infobuffer:dc.l	MI_MaxSamples,15		;fr OldSoundtracker !
		dc.l	TAG_More,Pro_InfoBuffer
		dc.l	0
NR_InfoBuffer:	dc.l	MI_Prefix,NR_Prefix
PackedTrackerInfo:dc.l	MI_UnpackedSystem,MIUS_ProTracker
		dc.l	MI_Unpacked,0			;-4
Pro_InfoBuffer:	dc.l	MI_SongName,PRO_NamePuffer	;0
		dc.l	MI_AuthorName,0			;8
		dc.l	MI_Samples,0			;16
		dc.l	MI_MaxSamples,31		;24
		dc.l	MI_Length,0			;32
		dc.l	MI_Pattern,0			;40
		dc.l	MI_SongSize,0			;48
		dc.l	MI_SamplesSize,0		;56
		dc.l	MI_CalcSize,0			;64
		dc.l	MI_MaxPattern,64		;72
		dc.l	MI_MaxLength,127		;80
		dc.l	MI_Prefix,PR_Prefix		;88
		dc.l	MI_LoadSize,0			;96
		dc.l	MI_Chipsize,0			;104
		dc.l	MI_Othersize,0			;112
		dc.l	MI_Specialinfo,0		;120
		dc.l	MI_UnpackedSongSize,0		;128
		dc.l	MI_Duration,-1
		dc.l	0

Pro_Startint	
;	move.b	FastLoad(pc),d1
;	beq.s	.ori
;
;	movem.l	d0-a6,-(sp)
;	bsr	startint		;Audio Interrupts init
;	movem.l	(sp)+,d0-a6
;	st	ForceSoftInt(A5)	;Unbedingt Soft Interrrupt
;.ori
	lea	_Pro_Music,a0
	move.l	a0,musicadr

	jsr	A5SetCiaBTimer(a5)

	rts
Pro_Stopint
;	sf	ForceSoftInt(A5)	;Kein unbedingter Softint 
;
;	bsr	stopsound		;Timer stoppen
;

	jsr	A5CloseCiaBTimer(A5)

;	move.b	FastLoad(pc),d1
;	beq.s	.ori
;	bsr	remint			;Audio Interrupts stop
;.ori

	rts

*------------------------- Stringgadget fr Mainwindow ----------------------*
*-----	d0 = Mode 0=Ziffern 1=Text !2=Invisible				-----*
*-----  d1 = MinValue (bei Ziffern)					-----*
*-----	d2 = max. Lnge des Strings oder MaxValue			-----*
*-----	a0 = Puffer fr Text oder ZellenAdr				-----*
*-----	a1 = TextFmT							-----*
*-----  a2 = TextFmtArgs						-----*
*-----	a3 = Requestertitle						-----*
*----- Output:								-----*
*-----	d0 = Ergebnis 0=Ok, sonst Error					-----*
*-----  d1 = Anzahl der eingebenen Zeichen oder Long			-----*
*----------------------------------------------------------------------------*
KR_Config:	moveq	#EPTRB_Zahl,d0			*Ziffern
		moveq	#0,d1				*MinValue
		moveq	#-1,d2				*MaxValue
		lea	KriptCode(a5),a0
		lea	TKriptCode(pc),a1
		sub.l	a2,a2
		sub.l	a3,a3
		jsr	A5GetStringGadget(a5)
		moveq	#0,d0
		rts

;=================== Moduleprotector Modul ===================================
MP_check
	move.l	dtg_chkdata(a5),a0
;------------------------ 1.Schritt-> Samples berprfen ---------------------
	moveq	#0,d4
	move.l	a0,a1
	moveq	#30,d0				;max. 31 Samples
.ppxx1erkinits
	cmp.b	#$40,3(a1)			;Lautstrke > 64 ?
	bhi	.NoPPxx1			;ja->Fehler
	moveq	#0,d1
	move.w	(a1),d1				;Lnge
	bne.s	.ppxx1erktest2			;<>0->Rest testen
	cmp.w	#1,6(a1)			;wenn kein Sample ->Repeatlnge
	bhi	.NoPPxx1			;>1 ??
	tst.w	4(a1)				;wenn kein Sample ->Repeatstart
	bne	.NoPPxx1			;<>0 ??
	bra.s	.ppxx1erktestend1		;alles klar,nchsten bitte
.ppxx1erktest2
	add.l	d1,d4				;nebenbei Sampleslnge
	add.l	d1,d4				;berechnen

	move.w	4(a1),d2			;Repeatstart
	cmp.w	d2,d1				;Lnge < Repeatstart ?
	blo	.NoPPxx1			;Ja->Fehler
	add.w	6(a1),d2			;Repeatlnge addieren
	cmp.w	d2,d1				;Repeat > Lnge ?
	blo	.NoPPxx1			;Ja->Fehler
.ppxx1erktestend1
	addq.l	#8,a1				;Zeiger auf nchstes Sample
	dbf	d0,.ppxx1erkinits		;nchstes Sample

	tst.l	d4
	beq	.noPPxx1
;------------------ 2.Schritt: Song selbst berprfen ------------------------

	lea	$FA(a0),a1			;Restart
	cmp.b	#$7f,-1(a1)			;grer 127 ?
	bhi	.NoPPxx1			;Fehler
	move.b	-2(a1),d0			;Songlnge
	cmp.b	#$7f,d0				;grer 127 ?
	bhi	.NoPPxx1			;Fehler

	moveq	#$7F,d0
	moveq	#0,d1
	moveq	#0,d2
.ppxx1erkloop1
	move.b	(a1)+,d1			;Patternnummer grer 127 ?
	blt	.NoPPxx1			;kann nicht sein 
	cmp.b	d2,d1				;Patternnummer grer als
						;aktuell hchste ?
	ble.s	.ppxx1nothigher1		;n
	move.l	d1,d2				;doch,neue setzen
.ppxx1nothigher1
	dbf	d0,.ppxx1erkloop1		;Loop

;---------------------- 3. Schritt : Patterns berprfen ----------------------
	addq.w	#1,d2		;Hchstes Pattern
	asl.l	#8,d2		;\ mal
;	asl.l	#2,d2		;/ 1024/4 (Langworttest)

	move.l	d2,d5		;Songsize
	asl.l	#2,d5		;

	lea	$17a(a0),a0
.ppxx1erkLoop3
	move.b	(a0),d0		;1.Byte holen
	and.b	#$f0,d0		;Samplenummer obere 4 Bits ausmaskieren
	cmp.b	#$10,d0		;grer 16 ?
	bhi.w	.NoPPxx1	;Fehler
	move.w	(a0),d0		;Sampleperiod holen
	and.w	#$fff,d0	;ausmaskieren
	beq.s	.ppxx1erkokwei
	lea	Pr_Periods,a1	;Periodentabelle
.ppxx1erkloop2
	move.w	(a1)+,d1		;Wert holen
	beq	.NoPPxx1		;Null->Tabelle durch->Fehler
	cmp.w	d1,d0			;Wert aus Tabelle = Periodenwert ?
	bne.s	.ppxx1erkLoop2		;nein,weitersuchen
.ppxx1erkokwei
	addq.l	#4,a0
	subq.l	#1,d2
	bne	.ppxx1erkLoop3

	moveq	#0,d0
	rts
.noppxx1
	moveq	#-1,d0
	rts
MP_InitPlayer
	jsr	A5ClrInfoBuffer(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	lea	$FA(a0),a1			;Restart
	moveq	#$7F,d0
	moveq	#0,d1
	moveq	#0,d2
.ppxx1erkloop1
	move.b	(a1)+,d1			;Patternnummer grer 127 ?
	cmp.b	d2,d1				;Patternnummer grer als
						;aktuell hchste ?
	ble.s	.ppxx1nothigher1		;n
	move.l	d1,d2				;doch,neue setzen
.ppxx1nothigher1
	dbf	d0,.ppxx1erkloop1		;Loop

	addq.w	#1,d2		;Hchstes Pattern

	move.l	d2,d5		;Songsize
	asl.l	#8,d5
	add.l	d5,d5

	move.l	d2,d0
	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn

	move.l	d1,a1
	move.l	ori_data(A5),a0
	lea	(a0),a3		;Sampleinfostrukturen wiederherstellen
	move.l	#`M.K.`,$438(a1)
	lea	$2a(a1),a2
	moveq	#31-1,d0
	moveq	#0,d6
	moveq	#0,d7
.ppxx1_sam
	move.l	(A3)+,(a2)
	move.l	(A3)+,4(a2)
	move.w	(a2),d6
	add.l	d6,d7
	add.l	d6,d7
	lea	$1e(a2),a2
	dbf	d0,.ppxx1_sam

	lea	$f8(A0),a3	;Songlnge,Restart usw. kopieren
	lea	$3b6(a1),a2
	moveq	#130/2-1,d0
.ppxx1_copyinfos
	move.w	(a3)+,(a2)+
	dbf	d0,.ppxx1_copyinfos

	lea	$43c(a1),a2
	lea	$17a(a0),a3
.ppxx1_copypattsnsam
	move.w	(a3)+,(a2)+
	subq.l	#1,d5
	bgt.s	.ppxx1_copypattsnsam

	move.l	a3,samplepointer(A5)
	sub.l	ori_data(A5),a3
	lea	pro_infobuffer(pc),a4
	move.l	a3,52(A4)			:Songsize setzen
	move.l	a3,68(A4)			:Calcsize setzen
	add.l	d7,68(A4)

	moveq	#1,d1
	bra	prot_packind
ME_Check:
	move.l	dtg_chkdata(a5),a0
	lea	$600(a0),a1

	cmp.w	#`M.`,(a0)
	bne	.MEL_fail

	move.w	#$c0-1,d0
.mel_check0
	cmp.b	#0,(a1)+
	bne	.MEL_fail
	dbf	d0,.mel_check0

	moveq	#64-1,d0
.mel_check1
	move.b	(a1)+,d1
	cmpi.b	#$24,d1
	bhi.w	.MEL_fail
	addq.w	#2,a1
	dbf	d0,.mel_check1

	lea	$200(a0),a1
	
	move.w	#64*4-1,d0
	moveq	#0,d1
	moveq	#0,d2
.mel_pattnum
	move.b	(a1)+,d1
	cmp.b	#$ff,d1
	beq.s	.melaha
	add.w	d1,d2
	dbf	d0,.mel_pattnum
.melaha
	tst.w	d2
	beq.w	.mel_fail

	lea	$30(a0),a1		;Offset 1. Sample
	moveq	#0,d1
	moveq	#0,d2
	moveq	#15-1,d0
.mel_checksam
	tst.l	(a1)
	beq.s	.mel_next
	tst.l	d1
	beq.s	.me_hol
	cmp.l	(a1),d1
	bne.w	.mel_fail
	move.w	4(a1),d2
	add.l	d2,d1
	bra.s	.mel_next
.me_hol
	move.l	(a1),d1
	move.w	4(a1),d2
	add.l	d2,d1
.mel_next
	add.l	#$20,a1
	dbf	d0,.mel_checksam

	tst.l	d1
	beq.w	.mel_fail
	cmp.l	#$6c0,d1
	blt.w	.mel_fail

	moveq	#0,d0
	rts
.mel_fail
	moveq	#-1,d0
	rts

ME_InitPlayer
	jsr	A5ClrInfoBuffer(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	lea	$600(a0),a1

	move.w	#$c0-1,d0
.mel_check0
	cmp.b	#0,(a1)+
	dbf	d0,.mel_check0

	moveq	#64-1,d0
.mel_check1
	move.b	(a1)+,d1
	addq.w	#2,a1
	dbf	d0,.mel_check1

	lea	$200(a0),a1
	
	move.w	#64*4-1,d0
	moveq	#0,d1
	moveq	#0,d2
.mel_pattnum
	move.b	(a1)+,d1
	cmp.b	#$ff,d1
	beq.s	.melaha
	add.w	d1,d2
	dbf	d0,.mel_pattnum
.melaha

	lea	$30(a0),a1		;Offset 1. Sample
	moveq	#0,d1
	moveq	#0,d2
	moveq	#15-1,d0
.mel_checksam
	tst.l	(a1)
	beq.s	.mel_next
	tst.l	d1
	beq.s	.me_hol
	cmp.l	(a1),d1
	move.w	4(a1),d2
	add.l	d2,d1
	bra.s	.mel_next
.me_hol
	move.l	(a1),d1
	move.w	4(a1),d2
	add.l	d2,d1
.mel_next
	add.l	#$20,a1
	dbf	d0,.mel_checksam

	lea	$20(a0),a2
	moveq	#0,d7
	moveq	#15-1,d0
	moveq	#0,d1
.MEL_samsize
	move.w	$14(A2),d1
	add.l	d1,d7
	add.w	#$20,a2
	dbf	d0,.MEL_samsize
					;A2 steht nun auf Songinfo Block
					;Aufbau:
					;4 Voices getrennt
	lea	Pro_Temp1(a5),a4
	moveq	#0,d2			;Aktuelle Patternnummer
	moveq	#0,d6
	moveq	#0,d5
.MEL_findpatts
	lea	Pro_Temp1(a5),a3
	move.w	d6,d4
.MEL_search
	move.l	(a3)+,d3
	cmp.l	(a2),d3
	beq.s	.MEL_found
	dbf	d4,.MEL_search
	move.l	(a2),(a4)+
	addq.w	#1,d6
.MEL_found
	addq.l	#4,a2
	move.b	(a2),d1

	addq.w	#1,d5

	cmp.b	#-1,d1
	bne.s	.MEL_findpatts

					;in D6 Anzahl der Patterns
					;Temp1 Patterns
	moveq	#0,d0
	move.w	d6,d0

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn

	move.l	d1,a1
	move.l	ori_data(A5),a0

	move.l	(a0),(a1)		;Namen kopieren
	move.l	4(a0),4(a1)		;Namen kopieren
	move.l	8(a0),8(a1)		;Namen kopieren
	move.l	12(a0),12(a1)		;Namen kopieren
	clr.b	15(a1)

	lea	$20(a0),a2		;Sampleinfostrukturen wiederherstellen
	lea	20(a1),a3
	moveq	#15-1,d0
	move.b	$f(a0),d3
.MEL_dosamples
	moveq	#22-7-1,d1
.MEL_name
	move.b	(a2)+,d2
	cmp.b	#$28,d2
	beq.s	.me_skip
	add.b	d3,d2
	bra.s	.mel2
.me_skip
	moveq	#0,d2
.mel2
	move.b	d2,(a3)+
	dbf	d1,.MEL_name
	addq.w	#1,a2
	addq.w	#7,a3

	moveq	#0,d1
	move.w	4(a2),d1		;Samplelnge
	lsr.w	#1,d1
	move.w	d1,(a3)+

	move.b	#0,(a3)+
	move.b	6(a2),(a3)+		;Lautstrke

	moveq	#0,d2
	move.w	8(A2),d2		;Repeatstart
	beq.s	.MEL_norep
	lsr.w	#1,d2
	move.w	d2,(a3)+		;Repeatstart
	sub.w	d2,d1			;samplelnge-repeatstart
	move.w	d1,(a3)+		;Repeatlnge
	bra.s	.MEL_rep
.MEL_norep
	move.l	#1,(a3)+
.MEL_rep
	lea	$10(a2),a2	
	dbf	d0,.MEL_dosamples

	move.b	d5,$3b6(a1)		;Songlnge

	lea	$3b8(A1),a3
					;in A1 immer noch Patternliste
	movem.l	a0/a1/a3,-(sp)

	subq.w	#1,d5			;Songlnge-1
	move.w	d5,-(sp)

.MEL_dosinfo
	lea	Pro_Temp1(a5),a0
	move.w	d6,d2
	moveq	#0,d3
.MEL_search2
	move.l	(a0)+,d4
	cmp.l	(a2),d4
	beq.s	.MEL_found2
.MEL_next2
	addq.w	#1,d3
	dbf	d2,.MEL_search2
	moveq	#0,d3			;sollte nicht vorkommen
.MEL_found2
	move.b	d3,(a3)+
	addq.l	#4,a2			;nchste Position
	dbf	d5,.MEL_dosinfo
	move.w	(sp)+,d5
	movem.l	(sp)+,a0/a1/a3

	move.l	#`M.K.`,$438(a1)
	move.l	a0,-(sp)

	lea	$600(a0),a2
	lea	$43c(a1),a3
	lea	my_periods,a6
	lea	Pro_Temp1(a5),a0
	subq.w	#1,d6
.MEL_dopatts
	moveq	#3,d0
.MEL_dostripes
	move.l	a3,-(sp)

	moveq	#0,d1
	move.b	(a0)+,d1
	mulu	#$c0,d1
	lea	(a2,d1.w),a4

	moveq	#63,d1
.MEL_dostripe
	moveq	#0,d2
	move.b	(a4)+,d2
	add.w	d2,d2
	move.w	(a6,d2.w),d2
	move.w	d2,(a3)
	move.b	(a4)+,d4
	move.b	d4,d5
	and.b	#$f0,d4
	and.b	#$f,d5
	cmp.b	#$d,d5
	bne.s	.mel_nod
	move.b	#$a,d5
.mel_nod
	or.b	d5,d4
	move.b	d4,2(a3)
	move.b	(a4)+,3(a3)
	lea	16(a3),a3
	dbf	d1,.MEL_dostripe

	move.l	(sp)+,a3
	addq.l	#4,a3
	dbf	d0,.MEL_dostripes

	add.l	#1024-16,a3
	dbf	d6,.MEL_dopatts
				;A3 zeigt nun auf 1. Sample Protracker
	move.l	(sp)+,a0
	add.l	$30(a0),a0	;A0 zeigt nun auf 1. Sample Mellicapacker

StandardGoPackind
	move.l	a0,samplepointer(A5)
	sub.l	ori_data(A5),a0
	lea	pro_infobuffer(pc),a4
	move.l	a0,52(A4)			:Songsize setzen

	moveq	#1,d1
	bra	prot_packind

NTC_Check:
	move.l	dtg_chkdata(a5),a0
	lea	$174(a0),a1
	moveq	#$7f,d1
.pak_check1
	tst.b	(a1)+
	blt.w	check_error
	dbf	d1,.pak_check1

	move.l	$1f6(a0),d0
	sub.l	#`PATT`,d0
	bne.w	check_error

	moveq	#0,d0
	rts

NTC_InitPlayer
	jsr	A5ClrInfoBuffer(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	lea	4(a0),a1
	moveq	#31-1,d0
	moveq	#0,d7
	moveq	#0,d1
	moveq	#12,d2
.PAK_samsize
	move.w	(a1),d1
	add.l	d1,d7
	add.l	d1,d7
	add.l	d2,a1
	dbf	d0,.PAK_samsize

	lea	$176(a0),a1
	moveq	#$7f,d0
	moveq	#0,d1
	moveq	#0,d6
.pak_seek
	move.b	(a1)+,d1
	cmp.b	d1,d6
	bge.s	.pak_nohi
	move.b	d1,d6
.pak_nohi
	dbf	d0,.pak_seek
	addq.l	#1,d6

	move.l	d6,d0

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3

	lea	42(a3),a1
	lea	(a0),a2
	moveq	#31-1,d0
	moveq	#0,d5
.pak_saminfo
	cmp.l	(a2)+,d5
	bge.s	.pak_hi2
	move.l	-4(a2),d5
.pak_hi2
	move.l	(a2)+,(a1)+
	move.l	(a2)+,(a1)+
	lea	22(a1),a1
	dbf	d0,.pak_saminfo

	lea	$174(a0),a2
	lea	$3b6(a3),a1
	move.w	#128+2-1,d0
.pak_copysonginfo
	move.b	(a2)+,(a1)+
	dbf	d0,.pak_copysonginfo

;	move.l	#`M.K.`,$438(A3)

	lea	$43c(a3),a3
	subq.w	#1,d6			;NUM_Patts
	move.l	a0,-(sp)
	lea	$1f6(a0),a0
.pak_dopatts
	move.w	#$5041,d0
	move.w	#$5454,d1
.pak_getPatt
	cmp.w	(a0)+,d0
	bne.s	.pak_getPatt
	cmp.w	(a0)+,d1
	bne.s	.pak_getPatt
					;in A0 Patternadr
	move.l	a3,-(sp)
	moveq	#3,d1
	move.l	a0,d2
	moveq	#6,d3
	bra.s	.pak_jumpin
.pak_3stripes
	moveq	#0,d3
	move.w	(A0)+,d3
.pak_jumpin
	add.l	d2,d3
	move.l	d3,a1

	movem.l	d2/a3,-(sp)
	moveq	#64-1,d0
	moveq	#0,d4
.pak_1stripe
	clr.l	(A3)

	tst.w	d4
	beq.s	.pak_nodelay
	subq.w	#1,d4
	bra.s	.pak_morevoice
.pak_nodelay
	moveq	#0,d2
	move.b	(a1),d2
	cmpi.b	#$ff,d2
	bne.s	.pak_nocrunch
	moveq	#0,d4
	move.b	1(a1),d4
	addq.l	#2,a1
	clr.l	(a3)
	bra.s	.pak_1stripe
.pak_nocrunch
	move.b	d2,d3
	andi.b	#$3f,d2
	beq.s	.pak_noset
	lsl.w	#1,d2
	lea	my_periods,a2
	move.w	-2(a2,d2.w),d2
.pak_noset
	btst	#7,d3
	beq.s	.pak_nohisamp
	bset	#12,d2
.pak_nohisamp
	move.w	d2,(a3)
	move.b	1(a1),2(a3)
	btst	#6,d3
	bne.s	.nocom
	move.b	2(a1),3(a3)
	addq.l	#1,a1
.nocom	addq.l	#2,a1

.pak_morevoice
	lea	16(a3),a3
	dbf	d0,.pak_1stripe
	movem.l	(sp)+,d2/a3
	addq.l	#4,a3
	dbf	d1,.pak_3stripes
	move.l	(Sp)+,a3
	add.l	#1024,a3
	dbf	d6,.pak_dopatts
	move.l	(sp)+,a0

				;in A3 Adresse, wo Samples hinsollen
.findoff
	tst.l	(a0)
	bne.s	.firstsam
	add.l	#12,a0
	bra.s	.findoff
.firstsam
	add.l	(a0),a0		;1. Sample
	bra	standardgopackind

	;===================================================================
PPK_Check:
	moveq	#-1,d0
	move.l	dtg_chkdata(a5),a0
	move.l	$438(a0),d1
	cmp.l	#`PWR.`,d1
	beq.s	.yespolka
	cmp.l	#`PSUX`,d1
	bne	.nopolka
.yespolka
	moveq	#0,d0
.nopolka
	rts
PPK_Initplayer
	jsr	A5ClrInfoBuffer(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)
	move.l	d0,d7			;Filelnge

	move.l	#`M.K.`,$438(a0)

	lea	$3b8(a0),a1
	moveq	#$7f,d0
	moveq	#0,d6
.ppk_loop
	cmp.b	(a1)+,d6
	bge.s	.ppk_hi
	move.b	-1(a1),d6
.ppk_hi	dbf	d0,.ppk_loop
	addq.w	#1,d6

	move.w	d6,d0

	bsr	AllocExtraST			;d0=Error|d1=Addi|d2=Size
	bne	Pro_CReturn
	move.l	d1,a1
	lea	(a1),a2

	move.w	d6,d7
	mulu	#1024/2,d7
	add.l	#$43c/2,d7
.ppk_copymod
	move.w	(a0)+,(a2)+
	subq.l	#1,d7
	bgt	.ppk_copymod

	lea	$438(a1),a1
	move.l	#`M.K.`,(a1)+
	mulu	#64*4,d6
	subq.w	#1,d6
	lea	my_periods,a3
.ppk_allpatts
	moveq	#0,d0
	move.b	(a1),d0
	move.b	1(a1),d1

	move.w	(a3,d0.w),d0
	move.w	d0,(a1)			;Note
	move.b	d1,d0
	lsl.b	#4,d0
	or.b	d0,2(a1)
	and.b	#$10,d1
	or.b	d1,(a1)
	addq.l	#4,a1
	dbf	d6,.ppk_allpatts	

	bra	standardgopackind

	;===================================================================
PM_Check:
	move.l	dtg_chkdata(a5),a0
	move.l	$438(a0),d0
	sub.l	#`!PM!`,d0
	rts

PM_Initplayer
	jsr	A5ClrInfoBuffer(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)
	move.l	d0,d7			;Filelnge

	move.l	#`M.K.`,$438(a0)

	lea	$3b8(a0),a1
	moveq	#0,d2
	moveq	#$7f,d1
.pm_highpatt
	cmp.b	(a1)+,d2
	bge.s	.pm_nohi
	move.b	-1(A1),d2
.pm_nohi
	dbf	d1,.pm_highpatt
	addq.w	#1,d2
	mulu	#1024,d2
	add.l	#$43c,d2

	lea	20+22(A0),a2
	moveq	#0,d0
	moveq	#$1e,d4
	moveq	#0,d1
	moveq	#0,d6
.pm_samsize
	move.w	(A2),d1
	add.l	d1,d6
	add.l	d1,d6
	lea	30(A2),a2
	dbf	d4,.pm_samsize

	add.l	d2,d6
	cmp.l	d6,d7			;File zu kurz ??
	bgt.s	.pm_fail

	add.l	a0,d2			;first Sample
	lea	20+22(A0),a2
	moveq	#0,d0
	moveq	#$1e,d4
.pm_loop
	move.l	d2,a3
	move.l	a3,a1
	moveq	#0,d1
	move.w	(a2),d1
	adda.l	#30,a2
	add.l	d1,d1
	add.l	d1,d2			;next sample
	tst.l	d1
	beq.s	.pm_next
.pm_wei1
	add.b	(a3),d0
	move.b	d0,(a3)+
	subq.l	#1,d1
	bne.s	.pm_wei1
	clr.l	(a1)
.pm_next
	dbra	d4,.pm_loop

	bra	Pro_InitPlayer
.pm_fail
	moveq	#EPR_Moduletooshort,d0
	rts

PR20_Check
	move.l	DTG_Chkdata(a5),a0
	move.l	(a0),d0
	cmp.l	#$60000016,d0
	bne.w	.nopr20
	move.l	4(a0),d0
	cmp.l	#$60000140,d0
	bne.w	.nopr20
	cmp.w	#$3f00,12(a0)
	bne.w	.nopr20

	moveq	#0,d0
	rts
.nopr20
	moveq	#-1,d0
	rts

PR20_Initplayer
	jsr	A5ClrInfoBuffer(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	LEA	$0144E(a0),A0

	move.w	(A0),d0				;Anzahl der Patterns
	bsr	AllocExtraST			;d0=Error|d1=Addi|d2=Size
	bne	Pro_CReturn
	move.l	d1,a3

	lea	$104(A0),a1
	lea	42(a3),a2
	moveq	#31,d0
.pm20_samp
	move.w	(a1)+,(a2)+
	move.b	(a1)+,d1
	lsr.b	#1,d1
	move.b	d1,(a2)+
	move.b	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	lea	30-8(a2),a2
	dbf	d0,.pm20_samp

	lea	$3b6(a3),a2
	move.w	2(a0),d0
	lsr.w	#1,d0
	move.b	d0,(A2)+
	move.b	#$7f,(a2)+
	lea	4(a0),a1
	subq.w	#1,d0

						;ZwischenSpeicher
	lea	Pro_Temp1(a5),a4
	move.l	#-1,(a4)
	movem.l	d0/a1,-(sp)
	moveq	#0,d2
.pm20_pos
	move.w	(a1)+,d3

	lea	Pro_temp1(A5),a4		;ZwischenSpeicher
	move.w	d2,d1
.pm20_such
	cmp.w	(A4)+,d3
	beq.s	.pm20_found
	dbf	d1,.pm20_such
	move.w	d3,(A4)
	addq.w	#1,d2
.pm20_found
	dbf	d0,.pm20_pos
	movem.l	(sp)+,d0/a1

	move.w	d2,d5
.pm20_pos2
	move.w	(a1)+,d3

	lea	pro_temp1+2(a5),a4		;ZwischenSpeicher
	moveq	#-1,d2
	move.w	d5,d1
.pm20_such2
	addq.w	#1,d2
	cmp.w	(A4)+,d3
	beq.s	.pm20_found2
	dbf	d1,.pm20_such2
	moveq	#0,d2
.pm20_found2
	move.b	d2,(A2)+
	dbf	d0,.pm20_pos2

	subq.w	#1,d5				;wegen DBF

	lea	(a0),a1
	add.l	$200(a0),a1			;1. Richtige Note
	lea	$43c(a3),a2
	movem.l	a3/a5,-(sp)
	lea	Pro_temp1+2(A5),a5
	lea	my_periods(pc),a3
.pm20_dopatts
	move.w	(a5)+,d0
	add.w	#$204,d0
	lea	(a0,d0.w),a4
	move.w	#64*4-1,d0			;1 Pattern
.pm20_patts
	move.w	(A4)+,d1
	add.w	d1,d1
	add.w	d1,d1
	move.w	2(a1,d1.w),2(a2)
	move.b	(a1,d1.w),d2			;Samplenummer
	lsr.b	#2,d2				;umrechnen
	move.b	d2,d3
	and.b	#$f0,d3
	lsl.b	#4,d2
	or.b	d2,2(a2)
	moveq	#0,d2
	move.b	1(a1,d1.w),d2
	and.b	#~1,d2
	move.w	(a3,d2.w),d2
	move.w	d2,(a2)
	or.b	d3,(A2)

	move.b	2(A2),d1
	and.b	#$f,d1
	cmp.b	#$b,d1
	beq.s	.pm20_reddy2

	addq.l	#4,a2
	dbf	d0,.pm20_patts
	bra.s	.pm20_reddy1
.pm20_reddy2
	addq.l	#4,a2
.pm20_reddy21
	clr.l	(a2)+
	dbf	d0,.pm20_reddy21
	subq.l	#4,a2
.pm20_reddy1
	dbf	d5,.pm20_dopatts
	movem.l	(sp)+,a3/a5

	add.l	$1fc(a0),a0			;1. Sample

	bra	standardgopackind
*-----------------------------------------------------------------------------*
NP2_Check:	moveq	#0,d7
		move.l	DTG_ChkData(a5),a0
		moveq	#-1,d0
		move.l	a0,a1

		move.w	(a0),d5		;Anzahl der Samples
		move.w	d5,d1		;merken
		and.w	#$f,d5		;jedes NP Modul beginnt mit
					;(Anzahl der Samples*16) OR 12
		cmp.w	#$c,d5		;ist die 12 vorhanden ?
		bne	.NP_Fail	;n
		lsr.w	#4,d1		;$c rausrotieren
		cmp.w	#$1f,d1		;Anzahl der Samples > 32 (0..31)
		bhi	.NP_Fail	;ja,Fehler

		move.w	4(a0),d2	;Offset Patterns
		btst	#0,d2		;Ungerade ?
		bne	.np_fail	;->Fehler
		add.w	(a0),a1		;auf Pointer addieren
		move.w	-4(a1),d5	;Hchste Patternnummer ist 2 mal eingetragen
		btst	#0,d5		;Ungerade ?
		bne	.np_fail	;->Fehler
		cmp.w	2(a0),d5	;Vergleich
		bne	.NP_fail	;Unstimmigkeit,Ende der Vorstellung

		move.l	a0,a1		;Pointer auf Modul saven
		add.w	(a1),a0		;Liste der Patterns fr jeweilige Songposition
		move.w	-4(a0),d1	;Lnge des Songs
		asr.w	#1,d1		;durch 2 dividieren
		subq.w	#1,d1
					;in A0 Zeiger auf Tabelle fr die
					;Zeiger auf die Patternnummer fr die
					;jeweilige Songposition

		moveq	#0,d5
		move.w	d1,d4		;brauchen wir noch
.Check2:	move.w	(a0)+,d3	;Patternnummer
		cmp.w	d5,d3		;mit derzeit hchster vergleichen
		bls.s	.Check1		;kleiner -> weiter
		move.w	d3,d5		;hchste Patternnr. merken
.Check1:	dbf	d1,.Check2	;alle Patterns
		addq.l	#8,d5		;+8
		cmp.w	d5,d2		;Gegenvergleich
		bne	.NP_Fail	;passt nicht -> Fehler
		and.w	#7,d5	;ausmaskieren (Patternnummer mu durch 8 
				;teilbar sein)
		bne	.NP_Fail ;nein->Fehler

				;A0 mu hier auf dem Anfang der Offsettabelle der
				;Patterns stehen

		moveq	#0,d5	;d5 killen
		move.w	(a1),d5	;Pointer auf Patternliste
		add.w	2(a1),a1 ;Lnge dieser Patternliste
		add.l	d5,a1	;zusammenaddieren = Pointer auf Patternoffsets

		cmp.l	a0,a1	;stimmt das ?
		bne	.np_fail ;wieso auch ?

			;an dieser Stelle kann als gesichert gelten,da
			;es sich um ein Noisepackermodul handelt,es bleibt
			;nur die Unterscheidung zum Noisepacker 3
		moveq	#1,d7
		move.w	#$c0,d1		;die Patternoffsets bei NP2.02 
					;sind Vielfache von 192
.Untersch:	moveq	#0,d5		;d5 lschen
		move.w	(a1)+,d5	;Offset holen
		divu	d1,d5		;durch 192 dividieren
		clr.w	d5		;Ergebnis lschen (unteres Wort)
		tst.l	d5		;Rest (oberes Wort) = 0 ,d.h. Offset durch 192
					;teilbar
		bne.s	.np_fail	;nein,ertappt
		dbf	d4,.Untersch	;alle testen
.NP_ok:		moveq	#0,d0		;alles klar
.NP_Fail:	tst.l	d0
		rts

NP3_Check:	bsr	NP2_Check ;einfach testen, ob es ein NoisepackerModul ist
				;wird es vom NP2 als NP2 erkannt, dann Fehler
		tst.l	d0
		beq.s	.np3_err
		tst.l	d7		;als Noisepackermodul erkannt ?
		beq.s	.np3_err	;nein
		moveq	#0,d0
		rts

.np3_err:	moveq	#-1,d0
		rts

*----------------------------------------------------------------------------*
NP2_InitPlayer:
NP3_InitPlayer:
		jsr	A5ClearProTemps(a5)
		jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

		move.l	a0,a2
		move.l	a0,a1
		add.w	(a0),a1		;auf Pointer addieren
		move.w	-4(a1),d0	;Hchste Patternnummer ist 2 mal eingetragen
		move.w	d0,d1
		lsr.w	#1,d1		;Lnge des Moduls in Patterns

		move.l	a0,a1		;Pointer auf Modul saven
		add.w	(a1),a0		;Liste der Patterns fr jeweilige Songposition
		move.w	-4(a0),d1	;Lnge des Songs
		lsr.w	#1,d1		;durch 2 dividieren
		subq.w	#1,d1
					;in A0 Zeiger auf Tabelle fr die
					;Zeiger auf die Patternnummer fr die
					;jeweilige Songposition

		move.w	d1,d4		;brauchen wir noch
.NP_Check2:	move.w	(a0)+,d3	;Patternnummer
		cmp.w	d0,d3		;mit derzeit hchster vergleichen
		bls.s	.NP_Check1	;kleiner -> weiter
		move.w	d3,d0		;hchste Patternnr. merken
.NP_Check1:	dbf	d1,.NP_Check2	;alle Patterns
		addq.l	#8,d0		;+8
		move.w	d0,d5			;numpatts(A5)

			;A0 mu hier auf dem Anfang der Offsettabelle der
			;Patterns stehen

		moveq	#0,d0		;D0 killen
		move.w	(a1),d0		;Pointer auf Patternliste
		add.w	2(a1),a1	;Lnge dieser Patternliste
		add.l	d0,a1		;zusammenaddieren = Pointer auf Patternoffsets

;Unterscheiden zwischen Noisepacker2 und Noisepacker3 nach der sicheren Methode

		moveq	#0,d0
		move.w	(a2),d0		;Anzahl der Sampeles
		lsr.w	#4,d0		;$c rausrotieren
		move.w	d0,d2		;fr spter aufheben
		subq.w	#1,d0		;minus 1 fr DBF-Schleife

		lea	8(a2),a0	;Zeiger auf SampleVolume (NP3)

		moveq	#0,d1		;Lnge NP3
		moveq	#0,d7		;...
.np_Getstuff:	moveq	#0,d6		;...

		move.w	6(a0),d6	;Lnge NP3
		add.l	d6,d1

		cmp.b	#$40,1(a0)	;Lautstrke NP3 berprfen
		bhi	.NP2		;grer 64 -> Fehler
		;^- Anmerkung:sollte es sich um ein NP2-Modul handeln,kommt
		;   es hierzu sowieso erst,wenn das Modul beim Rippen auerhalb
		;   der 4-Megabyte Chipmem Grenze lag
		cmp.b	#$f,(a0)	;Finetune testen
		bhi	.np2


		tst.l	2(a0)	;Sampleadresse schon mal initialisiert (Modul
				;gerippt oder NP2 - Modul) ?
		beq.s	.NP3_TestWei ;wenn also eine Null.l steht,heit das:
				;Noisepacker 3,weil bei NP2 in unteren Wort
				;die Lnge steht,die immer grer 0 ist

		tst.l	8(a0)	;Test,ob Repeatbeginn eingetragen ist,wenn
				;nicht,dann ist es kein NP3-Modul,weil bei Init
				;der Adresse auch Repeatbeginn gesetzt wird
		beq	.NP2	;Fehler

		move.w	14(a0),d6	;RepeatBeginn in Worten
		add.l	d6,d6		;mal 2 -> Repeatbeginn in Bytes
		move.l	2(a0),d7	;Samplestart
		add.l	d6,d7		;Samplestart+Repeatstart
		cmp.l	8(a0),d7	;Samplestart+Repeatstart = Repeatbeginn im
					;Modul
		bne	.NP2		;Fehler
.np3_testwei:	addq.l	#8,a0		;nchstes Sample ist 16 Bytes weiter
		addq.l	#8,a0		
		dbf	d0,.np_getstuff	;alle Samples durchgehen

		add.l	d1,d1		;in D1 steht nun die Lnge des gesamten
					;Sampleblockes !

		move.l	Ori_Data(A5),a0	;Moduladresse
		suba.l	a1,a1
		add.w	(a2)+,a1	;die ersten 4 Wrter reprsentieren
		add.w	(a2)+,a1	;die gesamte Lnge des
		add.w	(a2)+,a1	;Einfhrungsblockes und der Patterns
		add.w	(a2)+,a1	;Sampleadresse
		move.l	a1,Pro_InfoBuffer+52	:Songsize setzen
		add.l	a0,a1
		move.l	a1,SamplePointer(a5)

		moveq	#0,d0
		move.w	d5,d0
		lsr.w	#3,d0			;Anzahl der Patterns

		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a3

		move.l	ORI_Data(A5),a0		;sourceadresse

		lea	49(a3),a1
		moveq	#30,d0
.NP_Initnp3:	move.b	#1,(a1)
		add.w	#30,a1
		dbf	d0,.NP_InitNP3		;Repeatlen setzen

		move.w	(a0),d0			;Anzahl der Samples * $10 + $c
		sub.w	#12,d0			;$c sub
		asr.w	#4,d0			;/$10
		subq.w	#1,d0
		lea	8(a0),a1		;1.Sample NP3 Lautstrke
		lea	42(a3),a2		;1.Samplelnge NT
.NP3Samples:	move.w	6(a1),(a2)+	;Lnge
		move.w	(a1),(A2)+	;Lautstrke
		move.l	12(a1),d1
		swap	d1
		move.l	d1,(a2)+	;Repeatdaten

		add	#16,a1
		add	#30-8,a2
		dbf	d0,.np3samples

		move.l	a0,a1
		add	(a0),a1
		subq	#4,a1
		move.w	(a1)+,d0	;Lnge in Patterns * 2
		asr.w	#1,d0
		lea	$3b6(a3),a2
		move.b	d0,(a2)+	;eintragen
		move.w	(a1)+,d1	;Startpattern
		asr.w	#1,d1
		move.b	d1,(a2)+	;eintragen
		subq.w	#1,d0
.NP3_Patternloop:move.w	(a1)+,d1
		asr.w	#3,d1
		move.b	d1,(a2)+
		dbf	d0,.np3_Patternloop

		lea	$3b8(a3),a1
		moveq	#$7f,d0
		moveq	#0,d1
		moveq	#0,d2
.3lop2:		move.b	(a1)+,d1
		cmp.b	d2,d1
		ble.s	.3lop1
		move.l	d1,d2
.3lop1		dbf	d0,.3lop2
		move.w	d2,d5		;Anzahl der Patterns-1
		addq.w	#1,d2

		lea	$43c(a3),a1

		move.l	a0,a3
		clr.w	d1
		clr.w	d0

		add.w	(a3)+,a0
		add.w	(a3)+,a0
		move.l	a0,a2
		add.w	(a3)+,a2

		movem.l	a5/a6,-(sp)
		lea	Pro_Temp1(a5),a6
.3loop2:	clr.l	(A6)

		move.l	a2,-(a7)
		move.l	a2,a3
		move.l	a2,a4
		move.l	a2,a5

		add.w	(a0)+,a5	;Kanal 4
		add.w	(a0)+,a4	;Kanal 3
		add.w	(a0)+,a3	;Kanal 2
		add.w	(a0)+,a2	;Kanal 1

		move.w	#63,d4		;192/3
.3loop:		move.b	(a2)+,d0
		bpl.s	.okn3

		tst.b	(a6)
		bne.s	.np3_isok1
		move.b	-1(a2),(a6)
.np3_isok1:	cmp.b	#$ff,(a6)
		beq.s	.np3_yesok1
		addq.b	#1,(a6)
		subq.l	#1,a2
		bra.s	.np3_oopz1

.np3_yesok1:	clr.b	(A6)
.np3_oopz1:	moveq	#0,d0
		moveq	#0,d2
		moveq	#0,d3
		bra.s	.np3_non3

.okn3:		move.b	(a2)+,d2
		move.b	(a2)+,d3
.np3_non3:	bsr.w	.NP_Convert

		move.b	(a3)+,d0
		bpl.s	.okn32

		tst.b	1(a6)
		bne.s	.isok2
		move.b	-1(a3),1(a6)
.isok2:		cmp.b	#$ff,1(a6)
		beq.s	.yesok2
		addq.b	#1,1(a6)
		subq.l	#1,a3
		bra.s	.oopz12

.yesok2:	clr.b	1(a6)

.oopz12:	moveq	#0,d0
		moveq	#0,d2
		moveq	#0,d3
		bra.s	.non32
.okn32:		move.b	(a3)+,d2
		move.b	(a3)+,d3
.non32:		bsr.w	.NP_Convert
		move.b	(a4)+,d0
		bpl.s	.okn33

		tst.b	2(a6)
		bne.s	.isok3
		move.b	-1(a4),2(a6)
.isok3:		cmp.b	#$ff,2(a6)
		beq.s	.yesok3
		addq.b	#1,2(a6)
		subq.l	#1,a4
		bra.s	.oopz13
.yesok3:	clr.b	2(a6)

.oopz13:	moveq	#0,d0
		moveq	#0,d2
		moveq	#0,d3
		bra.s	.non33

.okn33:		move.b	(a4)+,d2
		move.b	(a4)+,d3
.non33:		bsr.w	.NP_Convert

		move.b	(a5)+,d0
		bpl.s	.okn34

		tst.b	3(a6)
		bne.s	.isok4
		move.b	-1(a5),3(a6)
.isok4:		cmp.b	#$ff,3(a6)
		beq.s	.yesok4
		addq.b	#1,3(a6)
		subq.l	#1,a5
		bra.s	.oopz14
.yesok4		clr.b	3(a6)

.oopz14:	moveq	#0,d0
		moveq	#0,d2
		moveq	#0,d3
		bra.s	.non34

.okn34:		move.b	(a5)+,d2
		move.b	(a5)+,d3
.non34:		bsr.w	.NP_Convert

		dbf	d4,.3loop
		move.l	(a7)+,a2
		dbf	d5,.3loop2

		movem.l	(sp)+,a5/a6
		bra	.NP_Fertig

.NP2:		move.l	Ori_Data(A5),a0
		move.w	(a0),d0
		move.l	a0,a1
		moveq	#0,d2
		move.w	4(a0),d2	;Hchste Patternnr.
		move.w	2(a0),d0

		move.w	d5,d0
		lsr.w	#3,d0			;Anzahl der Patterns

		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a3

		move.l	Ori_Data(A5),a0
		lea	49(a3),a1
		moveq	#30,d0
.init:		move.b	#1,(a1)
		add.w	#30,a1
		dbf	d0,.init		;Repeatlen setzen

		move.w	(a0),d0			;Anzahl der Samples * $10 + $c
		sub.w	#12,d0			;$c sub
		asr.w	#4,d0			;/$10
		subq.w	#1,d0
		lea	8+4(a0),a1		;1.Samplelnge NP
		lea	42(a3),a2		;1.Samplelnge NT
.Samples:	move.l	(a1),(a2)+
		move.l	8(a1),d1
		swap	d1
		move.l	d1,(a2)+

		add	#16,a1
		add	#30-8,a2
		dbf	d0,.samples

		move.l	a0,a1
		add	(a0),a1
		subq	#4,a1
		move.w	(a1)+,d0	;Lnge in Patterns * 2
		asr.w	#1,d0		
		lea	$3b6(a3),a2
		move.b	d0,(a2)+	;eintragen
		move.w	(A1)+,d1	;Startpattern
		asr.w	#1,d1
		move.b	d1,(a2)+	;eintragen
		subq.w	#1,d0
.np2Patternloop:move.w	(a1)+,d1
		asr.w	#3,d1
		move.b	d1,(a2)+
		dbf	d0,.np2Patternloop

		lea	$3b8(a3),a1
		moveq	#$7f,d0
		moveq	#0,d1
		moveq	#0,d2
.lop2:		move.b	(a1)+,d1
		cmp.b	d2,d1
		ble.s	.lop1
		move.l	d1,d2
.lop1:		dbf	d0,.lop2
		move.w	d2,d5		;Anzahl der Patterns-1
		addq.w	#1,d2

		lea	$43c(a3),a1

		move.l	a0,a3
		clr.w	d1
		clr.w	d0

		add.w	(a3)+,a0
		add.w	(a3)+,a0
		move.l	a0,a2
		add.w	(a3)+,a2

		move.l	a5,-(sp)
.loop2:		move.l	a2,-(a7)
		move.l	a2,a3
		move.l	a2,a4
		move.l	a2,a5

		moveq	#0,d0
		move.w	(a0)+,d0
		add.l	d0,a5		;Kanal 4
		move.w	(a0)+,d0
		add.l	d0,a4		;Kanal 3
		move.w	(a0)+,d0
		add.l	d0,a3		;Kanal 2
		move.w	(a0)+,d0
		add.l	d0,a2		;Kanal 1

		move.w	#63,d4		;192/3
.loop:		move.b	(a2)+,d0
		move.b	(a2)+,d2
		move.b	(a2)+,d3
		bsr.w	.NP_Convert
		move.b	(a3)+,d0
		move.b	(a3)+,d2
		move.b	(a3)+,d3
		bsr.w	.NP_Convert
		move.b	(a4)+,d0
		move.b	(a4)+,d2
		move.b	(a4)+,d3
		bsr.w	.NP_Convert
		move.b	(a5)+,d0
		move.b	(a5)+,d2
		move.b	(a5)+,d3
		bsr.w	.NP_Convert

		dbf	d4,.loop
		move.l	(a7)+,a2
		dbf	d5,.loop2

		move.l	(sp)+,a5
		move.l	Ori_Data(a5),a0

		suba.l	a2,a2
		move.l	a0,a3
		moveq	#0,d0
		add.w	(a0)+,a2
		add.w	(a0)+,a2
		add.w	(a0)+,a2
		move.w	(a0)+,d0
		add.l	d0,a2

		move.l	a2,Pro_InfoBuffer+52	:Songsize setzen
		add.l	a3,a2
		move.l	a2,SamplePointer(a5)

	*--------- Zum ProTracker-InitPlayer hpfen --------*
.NP_Fertig:	moveq	#1,d1			;convertiertes Module geladen
		bra.w	ProT_PackInd


.NP_Convert:	move.l	a0,-(Sp)
		move.w	#$ff,d1
		and.w	d1,d0
		and.w	d1,d2
		and.w	d1,d3
		moveq	#0,d1
		lea	Pr_Periods-2(pc),a0

		btst	#0,d0
		beq	.np_ok
		or.w	#$1000,d1
		and.b	#$fe,d0
.np_ok:		tst.w	d0
		beq.s	.np_no

		add	(a0,d0.w),d1
.np_no:		move.w	d1,(a1)+
		clr.w	d1
		move.b	d2,d1
		asl.w	#8,d1
		and.b	#$f,d2
		cmp.b	#6,d2
		beq	.np_also
		cmp.b	#5,d2
		beq	.np_also
		cmp.b	#$e,d2
		bne.s	.np_nofil
		lsr.b	#1,d3
		and.b	#1,d3
		bra	.np_ok2
.np_nofil
		cmp.b	#$b,d2
		bne.s	.nojum
		lsr.b	#1,d3
		addq.b	#1,d3
		bra.s	.np_ok2
.nojum
		cmp.b	#8,d2
		bne	.np_oko
		and.w	#$f000,d1
.np_oko:	cmp.b	#7,d2
		bne	.np_ok2
		and.w	#$f000,d1
		or.w	#$0a00,d1
.np_also:	tst.b	d3
		bge	.np_ok3
		neg.b	d3
		bra	.np_ok2
.np_ok3:	asl.b	#4,d3
.np_ok2:	or.b	d3,d1
		move.w	d1,(a1)+
		clr.w	d0
		clr.w	d1

		move.l	(sp)+,a0
		rts

NBK_Check
	move.l	DTG_ChkData(a5),a0

	lea	42(A0),a2		;Zeiger auf 1. Samplelnge
	moveq	#$1e,d3
.bkp_loop:
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d4

	move.w	(a2),d1			;Lnge
	beq.s	.bkp_next
	addq.w	#4,d1			;zur Sicherheit
	bhi.s	.bkp_ok1
	subq.w	#4,d1
.bkp_ok1:
	add.l	d1,d1

	move.w	4(a2),d2		;Repeatstart
	cmp.l	d2,d1
	blo.w	.nobkp

	move.w	6(a2),d4		;Repeatlnge
	cmp.w	#-1,d4
	beq.s	.bkp_TestVol
	cmp.l	d4,d1
	beq.s	.bkp_TestVol
	add.l	d4,d4
	cmp.l	d4,d1
	blo.w	.nobkp

	;add.l	d2,d4
	;cmp.l	d4,d1
	;blo.s	.nobkp

.bkp_TestVol:
	cmp.b	#64,3(A2)
	bhi.w	.nobkp
.bkp_next
	add.l	#30,a2
	dbf	d3,.bkp_loop

	move.l	$438(a0),d2
	beq	.nobkp
	cmp.l	#64*64*4*4,d2		;max. Patternsize
	bhi	.nobkp

	lea	$3b8(a0),a1
	moveq	#127,d1
	moveq	#0,d0
.eureka_lo
	cmp.b	(a1)+,d0
	bge.s	.eureka_hi
	move.b	-1(a1),d0
.eureka_hi
	dbf	d1,.eureka_lo

	addq.w	#1,d0
	lsl.w	#2,d0
	subq.w	#1,d0

	lea	$43c(a0),a1
	moveq	#0,d7
.bkp_checkoffs
	move.w	(a1)+,d1
	beq.s	.bkp_re
	moveq	#1,d7

	cmp.w	d2,d1
	bhi	.nobkp
	cmp.w	#$63c,d1
	blo	.nobkp
.bkp_re
	dbf	d0,.bkp_checkoffs

	tst.l	d7
	beq	.nobkp

	moveq	#0,d0
	rts
.nobkp
	moveq	#-1,d0
	rts

*---------------------------------------------------------------------------*
Skyt_Check
	moveq	#-1,d0
	move.l	dtg_chkdata(A5),a0
	cmp.l	#`SKYT`,$100(a0)
	bne.s	.noe
	clr.l	d0
.noe
	rts

*---------------------------------------------------------------------------*
Stpro_Check
	moveq	#-1,d0
	move.l	dtg_chkdata(A5),a0
	cmp.l	#`STP3`,(a0)
	bne	.noSTP
	cmp.w	#1,4(a0)
	bne	.noSTP
	cmp.w	#$52,$ca(A0)
	bne	.noSTP
	moveq	#0,d0
.nostp
	rts
*====================== Heatseeker MC1.0 Loader =============================*
HS_Check
	move.l	dtg_chkdata(A5),a0

;------------------------ 1.Schritt-> Samples berprfen ---------------------
	lea	(a0),a1
	bsr	StandardTrackerCheck
	bne	.nohs				;d0<>0 -> Fehler
	move.l	d1,d7
;------------------ 2.Schritt: Song selbst berprfen ------------------------

	lea	$FA(a0),a1			;Restart
	cmp.b	#$7f,-1(a1)			;grer 127 ?
	bhi	.noHS			;Fehler
	move.b	-2(a1),d0			;Songlnge
	beq	.noHS
	cmp.b	#$7f,d0				;grer 127 ?
	bhi	.noHS			;Fehler

	moveq	#$7F,d0
	moveq	#0,d1
	moveq	#0,d2
.HSerkloop1
	move.b	(a1)+,d1			;Patternnummer grer 127 ?
	blt	.noHS				;kann nicht sein 
	cmp.b	d2,d1				;Patternnummer grer als
						;aktuell hchste ?
	ble.s	.HSnothigher1			;n
	move.l	d1,d2				;doch,neue setzen
.HSnothigher1
	dbf	d0,.HSerkloop1			;Loop

;---------------------- 3. Schritt : Patterns berprfen ----------------------
	addq.w	#1,d2		;Hchstes Pattern
	asl.l	#8,d2		;\ mal
;	asl.l	#2,d2		;/ 1024/4 (Langworttest)

	move.l	d2,d5		;Songsize
	asl.l	#2,d5		;

	lea	$17a(a0),a0
	moveq	#0,d4
.HSerkLoop3
	move.b	(a0),d0		;1.Byte holen
	and.b	#$C0,d0
	beq.s	.norm

	st	d4

	cmp.b	#$80,d0
	bne.s	.doc0

	move.l	(A0),d1
	and.l	#~$80000000,d1
	cmp.l	#$100,d1
	bhi	.noHS

	moveq	#0,d0
	move.b	3(a0),d0
	sub.w	d0,d2
	bra.s	.HSerkokwei
.doc0
	move.l	(A0),d1
	and.l	#~$C0000000,d1
	cmp.l	#$10040,d1
	bhi	.noHS
	and.b	#3,d1
	bne	.noHS

	sub.w	#$40,d2	
	bra.s	.HSerkokwei2
.norm
	and.b	#$F0,d0		;Samplenummer obere 4 Bits ausmaskieren
	cmp.b	#$10,d0		;grer 16 ?
	bhi.w	.noHS	;Fehler
	move.w	(a0),d0		;Sampleperiod holen
	and.w	#$fff,d0	;ausmaskieren
	beq.s	.HSerkokwei
	lea	Pr_Periods,a1	;Periodentabelle
.HSerkloop2
	move.w	(a1)+,d1		;Wert holen
	beq	.noHS		;Null->Tabelle durch->Fehler
	cmp.w	d1,d0			;Wert aus Tabelle = Periodenwert ?
	bne.s	.HSerkLoop2		;nein,weitersuchen
.HSerkokwei
	subq.l	#1,d2
.HSerkokwei2
	addq.l	#4,a0
	bgt	.HSerkLoop3
					;A0 zeigt nun auf 1. Sample HS !!
	tst.w	d4
	beq.s	.noHS

	moveq	#0,d0
	rts
.noHS
	moveq	#-1,d0
	rts

*----------------------------------------------------------------------------*
Fuzz_Check:
	move.l	dtg_chkdata(A5),a0
	cmp.l	#`M1.0`,(a0)
	bne	.noFuzz

	moveq	#0,d0
	move.b	$842(a0),d0
	lsl.w	#2,d0
	subq.w	#1,d0

	moveq	#0,d1
	move.b	$843(A0),d1
	lsl.w	#8,d1
	move.b	$844(A0),d1

	lea	$844(a0),a1
.checkpatt
	move.l	(A1)+,d2
	and.l	#$3fffffff,d2
	cmp.l	d2,d1
	ble	.nofuzz
	and.w	#$3f,d2
	bne	.nofuzz
	dbf	d0,.checkpatt

	move.l	$842(a0),d0
	lsr.l	#8,d0
	sub.w	#$40-2,d0
	add.w	d0,a1
	cmp.l	#`SEnd`,(a1)
	bne	.nofuzz
	moveq	#0,d0
	rts
.nofuzz	
	moveq	#-1,d0
	rts

*----------------------------------------------------------------------------*
FCM_Check:
	move.l	dtg_chkdata(A5),a0
	moveq	#-1,d0
	cmp.l	#`FC-M`,(a0)
	bne.w	.noFCM
	cmp.l	#`NAME`,6(a0)
	bne.w	.noFCM
	cmp.l	#`INST`,$1e(a0)
	bne.w	.noFCM
	moveq	#0,d0
.nofcm
	rts

*----------------------------------------------------------------------------*

STPA_Check:
	move.l	dtg_chkdata(A5),a0
	lea.l	20(a0),a1

	bsr	StandardTrackerCheck
	bne	.endstar		;d0<>0 -> Fehler

	lea	$10c(A0),a3
	move.w	(a3)+,d0
	move.w	d0,d1
	and.b	#3,d1
	bne.w	.endstar
	cmp.w	#128<<2,d0
	bhi.w	.endstar
	lsr.w	#2,d0
	subq.w	#1,d0
	move.l	$310(a0),d2
	beq.w	.endstar
	cmp.l	#60000,d2
	bhi.w	.endstar

	moveq	#128-1,d1
	addq.l	#2,a3
	moveq	#0,d3
.star_checkpattlist
	move.l	(a3)+,d4
	cmp.l	d4,d2
	bls.w	.endstar
	subq.w	#1,d1
	dbf	d0,.star_checkpattlist
	tst.w	d1
	blt.s	.star_lo
	addq.w	#1,d1
.star_checkpattlist_2
	subq.w	#1,d1
.star_checkpattlist2
	tst.l	(a3)+
	bne.w	.endstar
	dbf	d1,.star_checkpattlist2
.star_lo
	lea	$314(a0),a1
	move.w	#64*4-1,d6
.star_checkfirstpatt
	moveq	#0,d1
	move.b	(a1)+,d1
	cmp.b	#$80,d1
	beq.s	.starc_empty
	tst.b	d1
	bmi	.endstar
	or.b	(a1)+,d1
	move.b	(a1)+,d0
	or.b	d0,d1
	or.b	(a1)+,d1
	and.b	#$30,d0
	bne.w	.endstar
	tst.b	d1
	beq.w	.endstar
.starc_empty
	dbf	d6,.star_checkfirstpatt

	moveq	#0,d0
	rts
.endstar
	moveq	#-1,d0
	rts

*----------------------------------------------------------------------------*
TP1_Check:
	move.l	DTG_ChkData(a5),a0
	moveq	#-1,d0
	cmp.l	#`MEXX`,(a0)
	bne.s	.nothis
	tst.b	4(a0)
	bne.s	.nothis

	move.w	28(a0),d1
	bne	.nothis
	moveq	#0,d0
.nothis
	rts

*----------------------------------------------------------------------------*
TP3_Check:	move.l	DTG_ChkData(a5),a0
		cmp.l	#`CPLX`,(a0)
		bne.s	.nothis
		cmp.l	#`_TP3`,4(a0)
		bne.s	.nothis
		moveq	#0,d0
		rts
.nothis		moveq	#-1,d0
		rts
*----------------------------------------------------------------------------*
Mexx_Check:	move.l	DTG_ChkData(a5),a0
		cmp.l	#`MEXX`,(a0)
		bne.s	.nothis
		cmp.l	#`_TP2`,4(a0)
		bne.s	.nothis
		lea	28(a0),a0
.nothis
		move.w	(a0)+,d1
		cmp.w	#$100,d1
		bhi.w	Check_Error
		lsr.w	#3,d1
		subq.w	#1,d1

	*------- SampleListe durchTesten -------*
.SampleLoop:	cmp.w	#$40,(A0)+
		bhi.w	Check_Error
		move.w	(a0)+,d0		;Length of Sample
		beq.w	Check_Error
		cmp.w	(a0)+,d0
		blo.w	Check_Error
		cmp.w	(a0)+,d0
		blo.w	Check_Error
		dbf	d1,.SampleLoop

		move.w	(a0)+,d1		;Length laden
		beq.w	Check_Error
		cmp.w	#128,d1
		bhi.w	Check_Error
		subq.w	#1,d1

	*----- Einzelnen Pattern durchtesten -----*
.PatternLoop:	move.w	(a0)+,d0
		cmp.w	#$200,d0		;max Pattern Nr
		bhi.w	Check_Error
		and.w	#$fff8,d0
		cmp.w	-2(a0),d0
		bne.w	Check_Error
		dbf	d1,.PatternLoop

	*------ Check OK -----*
		moveq	#0,d0
		rts

*----------------------------------------------------------------------------*
AMBK_Check
	move.l	DTG_Chkdata(a5),a0
	moveq	#-1,d0
	cmp.l	#`AmBk`,(a0)+
	beq.s	.musi1
	subq.l	#4,a0
;	cmp.w	#3,4(a0)
;	bne	.noAMBK
	cmp.b	#$c0,(a0)
	bne	.noAMBK
	bra.s	.check1
.musi1
;	cmp.w	#3,(a0)
;	bne	.noAMBK
	cmp.b	#$80,4(A0)
	bne	.noAMBK
.check1
	cmp.l	#`Musi`,8(a0)
	bne.s	.noAMBK
	cmp.l	#`c   `,12(a0)
	bne.s	.noAMBK

	lea.l	$14(A0),a1
	add.l	(a1),a1
	cmp.w	#6,(a1)+
	bne.s	.noAMBK

	add.w	2(A1),a1
	cmp.w	#-2,-2(a1)
	beq.s	.doAMBK

	tst.w	-2(A1)
	bne.s	.noAMBK		
.doAMBK
	moveq	#0,d0
.noAMBK
	rts

*----------------------------------------------------------------------------*
AC1D_Check
	move.l	DTG_ChkData(a5),a0
	move.w	2(a0),d0
	cmp.w	#$D1CA,d0
	beq.s	.ac
	cmp.w	#$AC1D,d0
	bne.w	.noac1d
.ac
	moveq	#0,d1
	move.b	(a0),d1
	ble	.noac1d
	tst.b	1(a0)
	blt	.noac1d

	lea	8(a0),a1
	moveq	#31-1,d0
	moveq	#0,d7
	moveq	#0,d2
.ac1d_samsize
	move.w	(a1),d2
	beq.s	.ac_nosam
	cmp.w	4(a1),d2
	blo	.noac1d
	cmp.w	6(a1),d2
	blo	.noac1d

	move.b	3(a1),d2
	cmp.b	#$40,d2
	bhi	.noac1d
	bra.s	.ac_nextsam
.ac_nosam
	tst.w	4(a1)
	bne	.noac1d
	cmp.w	#1,6(a1)
	bhi	.noac1d
.ac_nextsam
	addq.l	#8,a1

	dbf	d0,.ac1d_samsize

	moveq	#0,d0
	rts
.noac1d
	moveq	#-1,d0
	rts
*----------------------------------------------------------------------------*
DI_Check:
	move.l	DTG_ChkData(a5),a0
	moveq	#0,d0
	move.w	(A0),d0
	beq	check_error
	cmp.w	#$1e,d0
	bhi	check_error
	asl.w	#3,d0
	add.w	#14,d0
	lea	(a0,d0.w),a1
	move.l	2(A0),d1

	move.b	d1,d3
	and.b	#1,d3
	bne	check_error

	sub.l	d0,d1
	move.l	4(a0),d0		;Offset zum 1. Sample
	lsr.w	#1,d1
	subq.w	#1,d1
.di_checkpattoffs
	cmp.w	(a1)+,d0
	bhi	check_error
	dbf	d1,.di_checkpattoffs

	moveq	#0,d1
	moveq	#0,d2
	move.w	8(a0),d2		;valeur
	move.w	(A0),d1
	adda.l	#$10,a0
	subq.w	#1,d1
.DI_Testboucle:
	move.w	(a0),d0
	and.w	#$ff,d0
	cmp.w	#$40,d0
	bhi	Check_Error
	adda.l	#8,a0
	dbf	d1,.di_testboucle

	subq.l	#2,a0
	move.w	(a0),d1
	cmp.w	d2,d1		
	bne	Check_Error

	moveq	#0,d0
	rts

*----------------------------------------------------------------------------*
NBK_InitPlayer
	jsr	A5ClrInfoBuffer(a5)
	jsr	A5ClearProTemps(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	move.b	$3b6(a0),d0
	lea	$3b8(A0),a2
	moveq	#0,d1
	moveq	#0,d7
	moveq	#$7f,d0
.nbk_highpatt
	move.b	(a2)+,d1
	cmp.b	d1,d7
	bgt.s	.nohi
	move.b	d1,d7
.nohi
	dbf	d0,.nbk_highpatt
	addq.w	#1,d7			;Num Patts

	move.w	d7,d0
	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a1

	move.l	Ori_Data(a5),a0
	bsr	CopySTinfos

	lea	$43c(a1),a2			;1. Pattern
	lea	$43c(a0),a3			;1. Offset fr Pattern
	lea.l	Pro_Temp1(A5),a4
	move.l	d6,-(sp)
	subq.w	#1,d7				;wegen DBF
.nbk_allpatts
	moveq	#3,d5				;4 Patternstreifen
	move.l	a2,-(sp)
.nbk_1patt
	moveq	#0,d6
	move.w	(A3)+,d6			;Offset fr Patternstreifen
						;holen
	lea	(a0,d6.l),a1
	move.l	a2,-(sp)
	moveq	#63,d6
.nbk_1stripe
	bsr.s	.nbk_convertNote
	move.l	(a4),(a2)
	addq.l	#8,a2				;nchste
	addq.l	#8,a2				;Note
	dbf	d6,.nbk_1stripe
	move.l	(sp)+,a2
	addq.l	#4,a2				;nchster Streifen
	dbf	d5,.nbk_1patt
	move.l	(sp)+,a2
	add.l	#1024,a2			;nchstes Patt
	dbf	d7,.nbk_allpatts
	move.l	(sp)+,d6
						;a2 zeigt nun auf 1. Sample

	add.l	$438(A0),a0			;Source+Offset zum 1. Sample

	bra	StandardGoPackind

.nbk_convertnote
	MOVE.W	4(a4),D0
	BEQ.s	.nbk_wei1
	subq.w	#1,4(a4)
	clr.l	(A4)
	RTS
.nbk_wei1
	MOVE.B	(A1),D0
	BGE.L	.nbk_wei2
	BTST	#6,D0
	BEQ.L	.nbk_wei4
	addq.l	#1,a1
	ANDI.W	#$3F,D0
	MOVE.W	D0,4(a4)
	clr.l	(A4)
	RTS
.nbk_wei4
	MOVE.W	D0,D1
	ANDI.W	#$10,D0
	OR.B	1(A1),D0
	LSL.L	#8,D0
	MOVE.B	2(A1),D0
	LSL.L	#8,D0
	ANDI.W	#15,D1
	LSL.W	#4,D1
	MOVE.B	D1,D0
	LSL.L	#8,D0
	MOVE.B	#0,D0
	ADDI.L	#3,a1
	MOVE.L	D0,(A4)
	RTS
.nbk_wei2
	BTST	#6,D0
	BEQ.L	.nbk_wei3
	ANDI.W	#$3F,D0
	LSL.W	#8,D0
	MOVE.B	1(A1),D0
	ADDI.L	#2,a1
	EXT.L	D0
	MOVE.L	D0,(A4)
	RTS
.nbk_wei3
	LSL.L	#8,D0
	MOVE.B	1(A1),D0
	LSL.L	#8,D0
	MOVE.B	2(A1),D0
	LSL.L	#8,D0
	MOVE.B	3(A1),D0
	MOVE.L	D0,(A4)
	ADDI.L	#4,a1
	RTS
*----------------------------------------------------------------------------*
TP3_InitPlayer:jsr	A5ClrInfoBuffer(a5)
		jsr	A5ClearProTemps(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

		cmp.l	#`MEXX`,(a0)
		bne.s	.nothis
		lea	28(a0),a0
.nothis
	lea	28(a0),a0
	move	(a0)+,d0
	lea	(a0,d0.w),a1

	lea	2(a0),a3
	lsr.w	#3,d0
	subq.w	#1,d0
	moveq	#0,d1
	moveq	#0,d7
.TP3samsize
	move.w	(a3),d1
	add.l	d1,d7
	add.l	d1,d7
	addq.l	#8,a3
	dbf	d0,.TP3samsize

	move.w	(a1)+,d0
	moveq	#0,d1
	moveq	#0,d2
.TP3_hipatt
	move.w	(A1)+,d1
	cmp.w	d1,d2
	bgt.s	.TP3_nohi
	move.w	d1,d2
.TP3_nohi
	subq.w	#1,d0
	bne.s	.TP3_hipatt

	addq.w	#8,d2
	moveq	#0,d0
	move.w	d2,d0
	lsr.l	#3,d0	;Mal 1024/8, da sowieso schon mit 8 Multipliziert war
	move.l	d2,d3

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3

	move.l	d3,d2

	move.l	ori_data(a5),a0
	lea	8(a0),a1
	move.l	(a1)+,(a3)
	move.l	(a1)+,4(a3)
	move.l	(a1)+,8(a3)
	move.l	(a1)+,12(a3)
	move.l	(a1)+,16(a3)

	lea	28(a0),a0
	move.w	(a0)+,d0
	move.l	a0,a1
	add.w	d0,a1
	lsr.w	#3,d0
	subq.w	#1,d0
	lea	42(a3),a2
.TP3_sinfos
	move.w	(a0)+,d1		;Volume
	move.w	d1,2(a2)
	move.w	(a0)+,(a2)
	move.l	(a0)+,4(A2)
	lea	30(a2),a2
	dbf	d0,.TP3_sinfos
	
	lea	$3b6(a3),a2
	move.w	(a1)+,d0
	move.b	d0,(a2)+
	move.b	#$7f,(a2)+
	subq.w	#1,d0
.TP3_son
	move.w	(a1)+,d1
	lsr.w	#3,d1
	move.b	d1,(a2)+
	dbf	d0,.TP3_son

	move.l	#`M.K.`,$438(a3)
					;in A1 jetzt Pointer auf
					;Patternpositionen TP3
	lea	2(a1,d2.w),a2		;1. Patternstreifen TP3
	move.w	(a1,d2.w),d0
	lea	(a2,d0.w),a4		;1.Sample TP3

	movem.l	d2/d7/a3/a4,-(sp)
	lea	My_Periods(pc),a0

	lea	$43c(a3),a3			;Patterns ProT
	lsr.w	#3,d2
	subq.w	#1,d2
.TP3_allpatts:
	moveq	#3,d1
	move.l	a3,-(sp)
.TP3_1patt:
	moveq	#63,d0
	move.l	a3,-(sp)
	move.w	(a1)+,d3
	lea	(a2,d3.w),a4			;Pattstreifen, der bearbeitet
						;wird
	moveq	#0,d3
.TP3_1_Stripe:
	clr.l	(a3)				;vorher lschen

	addq.b	#1,d3
	bmi.w	.TP3_lo

	moveq	#0,d4
	move.b	(A4)+,d4
	bge.s	.TP3_normal			;Normale Note

	btst	#6,d4
	bne.s	.TP3_count

	andi.w	#$3E,d4				;Maske
	lsr.w	#1,d4				;rechts shiften
	cmp.b	#8,d4
	bne.s	.TP3_no8
	moveq	#0,d4
.TP3_no8
	move.b	d4,2(A3)			;Kommando

	cmp.b	#$a,d4
	bne.s	.TP3_NoVols
	move.b	(A4)+,d4
	bpl.s	.TP3_blabla
	neg.b	d4
	move.b	d4,3(A3)
	bra.w	.TP3_lo
.TP3_blabla:
	lsl.b	#4,d4
	move.b	d4,3(A3)
	bra.w	.TP3_lo
.TP3_NoVols:
	cmp.b	#$D,d4
	bne.s	.nod1
	moveq	#0,d7
	move.b	(a4)+,d7
	divu	#10,d7
	move.b	d7,d6
	lsl.b	#4,d6
	swap	d7
	add.b	d7,d6
	move.b	d6,3(A3)
	bra.s	.TP3_lo
.noD1
	move.b	(a4)+,3(A3)			;KommandoArgument
	bra.s	.TP3_lo

.TP3_Count:
	moveq	#0,d3
	move.b	d4,d3
	bra.s	.TP3_Lo
.TP3_Normal:
	moveq	#0,d5
	move.b	(a4)+,d5
	moveq	#15,d6
	and.b	d5,d6
	beq.s	.TP3_NoCommand

	cmp.b	#$a,d6
	bne.s	.TP3_NoVols2
	move.b	(a4)+,d7
	bpl.s	.TP3_blablabla
	neg.b	d7
	move.b	d7,3(a3)
	bra.s	.TP3_NoCommand
.TP3_Blablabla:
	lsl.b	#4,d7
	move.b	d7,3(a3)
	bra.s	.TP3_nocommand
.TP3_novols2:
	cmp.b	#8,d6
	bne.s	.TP3_no82
	and.b	#$f0,d5
.TP3_no82
	cmp.b	#$D,d6
	bne.s	.noD
	moveq	#0,d7
	move.b	(a4)+,d7
	divu	#10,d7
	move.b	d7,d6
	lsl.b	#4,d6
	swap	d7
	add.b	d7,d6
	move.b	d6,3(A3)
	bra.s	.TP3_nocommand
.noD
	move.b	(a4)+,3(a3)			;Kommandoargument sichern
.TP3_nocommand:
	moveq	#0,d7

	add.b	d4,d4
	bpl.s	.TP3_nohigher
	eor.b	#$fe,d4
	move.w	#$1000,d7
.TP3_nohigher
	move.b	d5,2(a3)			;Samplenummer lo Teil und
						;Kommando
	move.w	(a0,d4.w),d6
	or.w	d7,d6
	move.w	d6,(A3)
.TP3_lo:
	addq.l	#8,a3
	addq.l	#8,a3
	dbf	d0,.TP3_1_Stripe
	move.l	(sp)+,a3
	addq.l	#4,a3
	dbf	d1,.TP3_1Patt

	move.l	(sp)+,a3
	lea	1024(a3),a3			;nchstes Patt ProT
	dbf	d2,.TP3_allpatts

	movem.l	(sp)+,d2/d7/a3/a4		;A4 = 1.Sample TP3

	move.l	a4,a0
	bra	StandardGoPackind

*----------------------------------------------------------------------------*

Stpro_Initplayer
	jsr	A5ClrInfoBuffer(a5)
	jsr	A5ClearProTemps(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)
	move.l	d0,Unic_Temp(A5)

	lea	8(a0),a1
	moveq	#0,d0
	moveq	#$7f,d1
.numpatt
	cmp.b	(a1)+,d0
	bgt.s	.hi
	move.b	-1(a1),d0
.hi	dbf	d1,.numpatt
	addq.w	#1,d0
	move.l	d0,d6

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3			;Zieladresse

	lea	$3b6(a3),a1
	lea	8(a0),a2
	move.b	6(a0),(a1)+
	moveq	#$7f,d1
	move.b	d1,(a1)+
.copyinfoz
	move.b	(a2)+,(a1)+
	dbf	d1,.copyinfoz

	lea	42+6(a3),a1
	moveq	#31-1,d0
.set01	move.w	#1,(a1)
	add.w	#30,a1
	dbf	d0,.set01

	lea	$cc(a0),a1
	move.w	$c8(A0),d1
	subq.w	#1,d1
.stp_dosam
	move.w	(a1),d0
	subq.w	#1,d0
	mulu	#30,d0
	lea	20(a3,d0.w),a4

	lea	$22(a1),a1
	moveq	#21,d0
.stp_nam
	move.b	(a1)+,(a4)+
	dbf	d0,.stp_nam
	lea	8(a1),a1
	move.l	(A1)+,d0
	lsr.l	#1,d0
	move.w	d0,(a4)+
	clr.b	(a4)+
	move.b	(a1)+,(A4)+
	addq.l	#1,a1
	move.l	(a1)+,d0
	lsr.l	#1,d0
	move.w	d0,(a4)+
	move.l	(a1)+,d0
	bne.s	.do
	moveq	#2,d0
.do
	lsr.l	#1,d0
	move.w	d0,(a4)+
	addq.l	#8,a1
	dbf	d1,.stp_dosam

					;a1 zeigt nun auf erstes Pattern
	move.w	d6,d5
	subq.w	#1,d6
	lea	$438(a3),a2
	move.l	#`M.K.`,(a2)+
	lea	pr_periods(pc),a6
.stp_dopatterns
	move.w	(a1)+,d0
	bmi.w	.stp_found		;kein weiteres Pattern gefunden
	cmp.w	d5,d0
	ble.s	.stp_ok
	move.w	(a1)+,d0
	mulu	(a1)+,d0
	lsl.l	#2,d0
	add.l	d0,a1
	bra.w	.stp_nextpatt
.stp_ok
	mulu	#1024,d0
	lea	(A2,d0.l),a4		;zu bearbeitendes Pattern

	move.w	(a1)+,d0
	move.w	d0,d1
	lsl.w	#2,d0
	subq.w	#1,d0
	addq.l	#2,a1
	moveq	#0,d4
.stp_thispattern
	clr.w	d3
	move.b	(a1)+,d2
	move.b	(a1)+,d4
	beq.s	.stp_noe
	sub.w	#$18,d4
	bgt.s	.stp_high
	moveq	#0,d4
.stp_high
	add.w	d4,d4
	move.w	(a6,d4.w),d3
.stp_noe
	move.b	d2,d4
	and.b	#$10,d4
	lsl.w	#8,d4
	or.w	d4,d3
	move.w	d3,(a4)+
	lsl.b	#4,d2
	move.b	d2,(a4)
	move.b	(a1)+,d2		;Kommando
	move.b	(a1)+,d3		;Argument
	cmp.b	#3,d2
	blo.s	.stp_doit

	cmp.b	#$13,d2
	bne.s	.stp_no03
	move.b	#3,d2
	bra.s	.stp_doit
.stp_no03
	cmp.b	#$10,d2
	bne.s	.stp_no04
	move.b	#4,d2
	bra.s	.stp_doit
.stp_no04
	cmp.b	#$15,d2
	bne.s	.stp_no05
	move.b	#5,d2
	rol.b	#4,d3
	bra.s	.stp_doit
.stp_no05
	cmp.b	#$d,d2
	bne.s	.stp_no0A
	move.b	#$A,d2
	rol.b	#4,d3
	bra.s	.stp_doit
.stp_no0A
	cmp.b	#$11,d2
	bne.s	.stp_no07
	move.b	#7,d2
	bra.s	.stp_doit
.stp_no07
	cmp.b	#$14,d2
	bne.s	.stp_no0b
	move.b	#$b,d2
	bra.s	.stp_doit
.stp_no0b
	cmp.b	#$12,d2
	bne.s	.stp_no0d
	move.b	#$d,d2
	bra.s	.stp_doit
.stp_no0d
	cmp.b	#$f,d2
	bne.s	.stp_no0f
	lsr.b	#4,d3
.stp_no0f
	cmp.b	#$e,d2
	bne.s	.stp_no0e
	eor.b	#1,d3
.stp_no0e

.stp_doit
	or.b	d2,(a4)+
	move.b	d3,(A4)+
	dbf	d0,.stp_thispattern
	cmp.w	#$40,d1
	beq.s	.stp_nextpatt
	move.w	#$d00,-2(a4)
.stp_nextpatt
	dbf	d6,.stp_dopatterns

.stp_findsam
	move.w	(a1)+,d0
	blt.s	.stp_found
	move.w	(a1)+,d0
	mulu.w	(a1)+,d0
	lsl.w	#2,d0
	add.l	d0,a1
	bra.s	.stp_findsam
.stp_found
	cmp.b	#$ff,(a1)+
	bne.s	.stp_found
	add.w	#$22+1,a1

	move.l	a1,SamplePointer(a5)
	move.l	Ori_Data(a5),d0
	sub.l	d0,a1
	move.l	a1,d0
	move.l	d0,Pro_InfoBuffer+52	:Songsize setzen
	sub.l	Unic_Temp(A5),d0
	bne.s	.ok

	moveq	#EPR_ModuleTooShort,d0
	bra	Pro_EndPlayer
.ok
	*--------- Zum ProTracker-InitPlayer hpfen --------*
	moveq	#1,d1			;convertiertes Module geladen
	bra.w	ProT_PackInd

*----------------------------------------------------------------------------*

SKYT_InitPlayer
	jsr	A5ClrInfoBuffer(a5)
	jsr	A5ClearProTemps(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	lea	$104(a0),a1
	move.w	(A1)+,d0
	lsr.w	#8,d0			;Songlnge-1
	move.w	d0,d1

	lea	(a1),a2
	lea	Pro_temp1(a5),a4
	moveq	#0,d2			;Aktuelle Patternnummer
	moveq	#0,d6
.skyt_findpatts
	lea	Pro_temp1(a5),a3
	move.w	d6,d4
.skyt_search
	move.l	(a3)+,d5
	move.l	(a3)+,d3
	cmp.l	(a2),d5
	bne.w	.skyt_next
	cmp.l	4(a2),d3
	beq.s	.skyt_found
.skyt_next
	dbf	d4,.skyt_search

	move.l	(a2),(a4)+
	move.l	4(a2),(a4)+
	addq.w	#1,d6
.skyt_found
	addq.l	#8,a2
	dbf	d1,.skyt_findpatts

	move.l	d6,d0
	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3			;Zieladresse

	moveq	#31-1,d1
	lea	(a0),a4
	lea	20+22(a3),a2
.skyt_dosamples
	move.l	(a4)+,(a2)+
	move.w	(a4)+,d0
	add.w	d0,d0
	move.w	d0,(a2)+
	move.w	(a4)+,d0
	bne.s	.skyt_ok1
	moveq	#1,d0
.skyt_ok1
	move.w	d0,(a2)+
	add.l	#30-8,a2
	dbf	d1,.skyt_dosamples
					;in A1 immer noch Patternliste
	movem.l	a0/a1/a3,-(sp)
	move.w	-2(A1),d5
	lsr.w	#8,d5			;Songlnge-1
	move.w	d5,-(sp)

	move.b	d5,$3b6(a3)
	addq.b	#1,$3b6(a3)

	lea	$3b8(a3),a3		;1. Songpos
.skyt_dosinfo
	lea	Pro_temp1(a5),a0
	move.w	d6,d2
	moveq	#0,d3
.skyt_search2
	move.l	(a0)+,d4
	move.l	(a0)+,d1

	cmp.l	(a1),d4
	bne.s	.skyt_next2
	cmp.l	4(a1),d1
	beq.s	.skyt_found2
.skyt_next2
	addq.w	#1,d3
	dbf	d2,.skyt_search2
	moveq	#0,d3			;sollte nicht vorkommen
.skyt_found2
	move.b	d3,(a3)+
	addq.l	#8,a1
	dbf	d5,.skyt_dosinfo
	move.w	(sp)+,d5
	movem.l	(sp)+,a0/a1/a3

	addq.w	#1,d5
	LSL.W	#3,D5
	addq.l	#6,d5
	add.l	D5,A0			;1. Pattern SKYT - 256

	lea	$43c(A3),a3		;1. Pattern
	lea	Pro_temp1(a5),a2
	subq.w	#1,d6			;Anzahl Patterns
	lea	My_periods,a1
.skyt_dopatt
	moveq	#3,d5
	move.l	a3,-(sp)
.skyt_dostripes
	move.w	(a2)+,d0
	cmp.w	d0,d3
	bge.s	.skyt_hi
	move.w	d0,d3
.skyt_hi
	lea	(a0,d0.w),a4

	move.l	a3,-(sp)
	moveq	#64-1,d4
.skyt_stripe
	moveq	#0,d0
	move.b	(a4),d0
	add.w	d0,d0
	move.w	(a1,d0.w),d0
	move.w	d0,(a3)
	move.w	2(a4),2(a3)
	move.b	1(a4),d0
	lsl.b	#4,d0
	or.b	d0,2(a3)
	move.b	1(a4),d0
	and.b	#$f0,d0
	or.b	d0,(a3)
	addq.l	#4,a4			;nchste Note
	addq.l	#8,a3
	addq.l	#8,a3			;nchste Note
	dbf	d4,.skyt_stripe
	move.l	(sp)+,a3
	addq.l	#4,a3			;nchste Stimme
	dbf	d5,.skyt_dostripes
	move.l	(sp)+,a3
	add.l	#$400,a3		;nchstes Pattern
	dbf	d6,.skyt_dopatt	

	add.w	#$100,d3
	lea	(a0,d3.w),a0		;1. Sample Skyt

	bra	standardgopackind

*----------------------------------------------------------------------------*

HS_InitPlayer:
		jsr	A5ClrInfoBuffer(a5)
		jsr	A5ClearProTemps(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

	lea	$FA(a0),a1			;Restart
	moveq	#$7F,d0
	moveq	#0,d1
	moveq	#0,d5
.HSerkloop1
	move.b	(a1)+,d1			;Patternnummer grer 127 ?
	cmp.b	d5,d1				;Patternnummer grer als
						;aktuell hchste ?
	ble.s	.HSnothigher1			;n
	move.l	d1,d5				;doch,neue setzen
.HSnothigher1
	dbf	d0,.HSerkloop1			;Loop

	addq.w	#1,d5
	move.l	d5,d0			;Songsize

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a1			;Zieladresse

	movem.l	d1-a6,-(sp)
	move.l	#$10001,d1
	move.l	d5,d0			;c.a. 20-64 kBytes
	mulu	#1024,d0
	move.l	4.w,a6
	jsr	-198(a6)
	movem.l	(sp)+,d1-a6
	tst.l	d0
	beq	Pro_MemEndPlayer

	move.l	d0,a4
	move.l	ori_data(a5),a0		;Quelladresse

	lea	(a0),a3			;Sampleinfostrukturen wiederherstellen
	move.l	#`M.K.`,$438(a1)
	lea	$2a(a1),a2
	moveq	#31-1,d0
.HS_sam
	move.l	(A3)+,(a2)
	move.l	(A3)+,4(a2)
	lea	$1e(a2),a2
	dbf	d0,.HS_sam

	lea	$f8(A0),a3	;Songlnge,Restart usw. kopieren
	lea	$3b6(a1),a2
	moveq	#130/2-1,d0
.HS_copyinfos
	move.w	(a3)+,(a2)+
	dbf	d0,.HS_copyinfos

	lea	$43c(a1),a2
	lea	$17a(a0),a3
	move.l	d5,-(sp)
	subq.w	#1,d5
	moveq	#16,d2
	move.l	a4,-(sp)
.HS_WholeSong
	moveq	#4-1,d4
.HS_One_Pattern
	moveq	#64-1,d3
.HS_One_Stripe
	move.l	(a3)+,d0
	bpl.s	.HS_doNormal

	move.b	-4(a3),d1
	cmp.b	#$C0,d1
	beq.s	.HS_doC0
.HS_Clearloop
	clr.l	(a2)
	add.l	d2,a2
	clr.l	(a4)+
	subq.w	#1,d3
	dbf	d0,.HS_ClearLoop
	addq.w	#1,d3
	bra.s	.HS_NextNote
.HS_doC0
	lsl.l	#6,d0
	and.w	#~$ff,d0
	move.l	(sp),a0
	add.w	d0,a0

	moveq	#64-1,d1
.HS_C0Loop
	move.l	(a0)+,(a2)
	add.l	d2,a2
	dbf	d1,.HS_C0Loop
	moveq	#0,d3
	bra.s	.HS_NextNote
.HS_DoNormal
	move.l	d0,(a2)
	move.l	d0,(A4)+
	add.l	d2,a2
.HS_NextNote
	dbf	d3,.HS_One_Stripe
	lea	-$400+4(a2),a2		;Back in Pattern, next Track
	dbf	d4,.HS_One_Pattern
	lea	$400-16(a2),a2		;Next Pattern, first Track
	dbf	d5,.HS_WholeSong
	move.l	(sp)+,a4
	move.l	(sp)+,d0

	move.l	4.w,a6
	move.l	a4,a1
	mulu	#1024,d0
	jsr	_LVOfreemem(A6)

	move.l	a3,a0
	bra	standardgopackind

*----------------------------------------------------------------------------*

Fuzz_InitPlayer:
		jsr	A5ClrInfoBuffer(a5)
		jsr	A5ClearProTemps(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

;----------------------- Konverter ------------------------------------------
	
	lea	$846(a0),a1
	moveq	#0,d0
	move.b	$842(a0),d0
	move.w	d0,d3
	lsl.w	#2,d3

	subq.w	#1,d0

	lea	(a1,d3.w),a3	;2nd voc
	lea	(a3,d3.w),a4	;3rd voc
	lea	(a4,d3.w),a6	;4th voc
	lea	pro_temp1(A5),a2
.cp1
	move.w	(a1),(a2)+
	addq.l	#4,a1
	move.w	(a3),(a2)+
	addq.l	#4,a3
	move.w	(a4),(a2)+
	addq.l	#4,a4
	move.w	(a6),(a2)+
	addq.l	#4,a6
	dbf	d0,.cp1

	move.l	$842(a0),d0
	lsr.l	#8,d0
	sub.w	#$40-4,d0
	add.w	d0,a6			;1. Sample Fuzzac Packer

	moveq	#0,d1
	move.b	$842(a0),d1
	subq.w	#1,d1

	moveq	#-1,d0

	lea	Pro_temp1(A5),a1
	lea	Pro_temp2(A5),a2
	moveq	#8,d3
.fuzz_sortpatts
	move.w	(A1)+,d4
	move.w	(A1)+,d5
	move.w	(A1)+,d6
	move.w	(A1)+,d7

	move.w	d0,d2	
	blt.s	.fuzz_take

	lea	pro_temp2(A5),a3
.fuzz_find
	cmp.w	(a3),d4
	bne.s	.fuzz_next
	cmp.w	2(a3),d5
	bne.s	.fuzz_next
	cmp.w	4(a3),d6
	bne.s	.fuzz_next
	cmp.w	6(a3),d7
	beq.s	.fuzz_skip
.fuzz_next
	add.l	d3,a3
	dbf	d2,.fuzz_find
.fuzz_take
	move.w	d4,(a2)+
	move.w	d5,(a2)+
	move.w	d6,(a2)+
	move.w	d7,(a2)+
	addq.w	#1,d0
.fuzz_skip
	dbf	d1,.fuzz_sortpatts
	addq.w	#1,d0				;num Patts
	move.w	d0,d7

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3
	
	lea	$3b8(a3),a1

	moveq	#0,d0
	move.b	$842(a0),d0
	move.b	d0,$3b6(a3)
	subq.w	#1,d0

	move.w	d7,-(sp)

	lea	pro_temp1(A5),a2
.dosonginfos
	lea	pro_temp2(A5),a4
	move.w	(a2)+,d1
	move.w	(a2)+,d2
	move.w	(a2)+,d3
	move.w	(a2)+,d4

	move.w	(sp),d7
	subq.w	#1,d7
	moveq	#0,d5
.find
	cmp.w	(a4),d1
	bne.s	.next
	cmp.w	2(a4),d2
	bne.s	.next
	cmp.w	4(a4),d3
	bne.s	.next
	cmp.w	6(a4),d4
	beq.s	.found
.next
	addq.l	#8,a4

	addq.b	#1,d5
	dbf	d7,.find
.found
	move.b	d5,(a1)+
	dbf	d0,.dosonginfos

	move.w	(sp)+,d7

	lea	6(a0),a1
	lea	20(a3),a2
	moveq	#31-1,d0
.dosampleinfos
	moveq	#22-1,d1
.name
	move.b	(a1)+,(a2)+
	dbf	d1,.name	
	lea	$42-6-22(a1),a1
	move.w	(a1)+,(A2)+
	move.w	4(a1),(a2)+
	move.w	(a1)+,(a2)+
	move.w	(a1)+,d1
	bne.s	.noe
	moveq	#1,d1
.noe
	move.w	d1,(a2)+
	addq.l	#2,a1
	dbf	d0,.dosampleinfos

	lea	$438(A3),a2
	move.l	#`M.K.`,(a2)+
	subq.w	#1,d7
	lea	pro_temp2(A5),a1

	lea	$846(a0),a4
	moveq	#0,d0
	move.b	$842(a0),d0
	lsl.w	#4,d0
	lea	(a4,d0.w),a4

	movem.l	a0/a3-a6,-(sp)
.copypatts
	move.w	(a1)+,d0
	sub.w	#$40,d0
	lea	(A4,D0.W),a0
	move.w	(a1)+,d0
	sub.w	#$40,d0
	lea	(A4,D0.W),a3
	move.w	(a1)+,d0
	sub.w	#$40,d0
	lea	(A4,D0.W),a5
	move.w	(a1)+,d0
	sub.w	#$40,d0
	lea	(A4,D0.W),a6

	moveq	#64-1,d0
.cop
	move.l	(a0)+,(a2)+
	move.l	(a3)+,(a2)+
	move.l	(a5)+,(a2)+
	move.l	(a6)+,(a2)+
	dbf	d0,.cop

	dbf	d7,.copypatts
	movem.l	(sp)+,a0/a3-a6

	move.l	a6,a0
	bra	StandardGopackind

*----------------------------------------------------------------------------*

FCM_InitPlayer:
	jsr	A5ClrInfoBuffer(a5)
	jsr	A5ClearProTemps(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)
	move.l	d0,d5

	move.l	#`LONG`,d0
	bsr.w	.fcm_find
	moveq	#0,d2
	move.b	(a1),d2

	move.l	#`PATT`,d0
	bsr.w	.fcm_find

	subq.w	#1,d2
	moveq	#0,d6
.fcm_seek
	cmp.b	(a1)+,d6
	bge.s	.fcm_lo
	move.b	-1(A1),d6
.fcm_lo	dbf	d2,.fcm_seek
	addq.w	#1,d6			;Num Patts
	move.l	d6,d0
	mulu	#1024,d6

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3

	move.l	10(A0),(a3)
	move.l	14(A0),4(a3)
	move.l	18(A0),8(a3)
	move.l	22(A0),12(a3)
	move.l	26(A0),16(a3)

	lea	20+22(a3),a2
	lea	$22(a0),a1
	moveq	#31-1,d0
.fcm_dosam
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	lea	30-8(a2),a2
	dbf	d0,.fcm_dosam

	move.l	#`LONG`,d0
	bsr.s	.fcm_find
	move.w	(a1),$3b6(a3)
	moveq	#0,d2
	move.b	(a1),d2
	move.l	#`PATT`,d0
	bsr.s	.fcm_find

	lea	$3b8(A3),a2
	subq.w	#1,d2
.fcm_dosinfo
	move.b	(a1)+,(a2)+
	dbf	d2,.fcm_dosinfo

	move.l	#`SONG`,d0
	bsr.w	.fcm_find

	move.l	#`M.K.`,$438(A3)
	lea	$43c(a3),a3
.fcm_copypatt
	move.b	(a1)+,(a3)+
	subq.l	#1,d6
	bne.s	.fcm_copypatt

	addq.l	#4,a1				;Kennung "SAMP" berspringen
	move.l	a1,a0
	bra	StandardGopackind

.fcm_find
	movem.l	a0/d1,-(sp)

	;in A0 Modadresse bergeben, in A1 dann 1. Byte nach der zu suchenden
	;Kennung (D0)
	move.l	d5,d1
	add.l	a0,d1
.loop
	cmp.l	(a0),d0
	beq.w	.found
	addq.l	#2,a0
	cmp.l	a0,d1
	bgt.s	.loop
.found
	lea	4(a0),a1
	movem.l	(sp)+,a0/d1
	rts

*----------------------------------------------------------------------------*

STPA_InitPlayer:
	jsr	A5ClrInfoBuffer(a5)
	jsr	A5ClearProTemps(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	;nun geht`s los mit der Konvertierung, zuerst mal die Anzahl der
	;Patterns und Lnge der Samples berechnen

	lea	$110(a0),a1
	move.w	$10c(a0),d0
	lsr.w	#2,d0
	subq.w	#1,d0

	moveq	#0,d6			;=1
	move.w	2(a1),Pro_temp1(A5)
.star_sortpatts
	move.l	(A1)+,d2
	
	lea	Pro_temp1(A5),a2
	move.w	d6,d3
.star_sort2
	cmp.w	(a2)+,d2
	beq.s	.star_sortnext
	dbf	d3,.star_sort2
	move.w	d2,(a2)
	addq.w	#1,d6
.star_sortnext
	dbf	d0,.star_sortpatts

	addq.w	#1,d6				;Anzahl der Patterns

	move.l	d6,d0

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3

	lea	(a3),a2
	lea	(a0),a1
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	lea	22(a2),a2

	moveq	#31-1,d0
.star_dosaminfos
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	lea	30-8(a2),a2
	dbf	d0,.star_dosaminfos

	move.w	$10c(a0),d0
	lsr.w	#2,d0	
	move.b	d0,$3b6(a3)		;Songlnge
	
	subq.w	#1,d0

	move.w	d6,d1
	subq.w	#1,d1
	lea	$110(a0),a1
	lea	$3b8(a3),a4
.star_restorePositions
	move.l	(a1)+,d2

	move.w	d1,d3
	moveq	#0,d4
	lea	pro_temp1(A5),a2
.star_findpos
	cmp.w	(a2)+,d2
	beq.s	.star_foundpos
	addq.w	#1,d4
	dbf	d3,.star_findpos
.star_foundpos
	move.b	d4,(a4)+
	dbf	d0,.star_restorePositions

	lea	$438(a3),a2
	move.l	#`M.K.`,(A2)+
	lea	$314(A0),a1
	mulu	#64*4,d6
.star_patt
	clr.l	(a2)
	move.b	(a1)+,d0
	cmp.b	#$80,d0
	beq.s	.empty
	move.b	d0,d1
	and.b	#$f,d1
	move.b	d1,(a2)
	move.b	(a1)+,1(a2)		;unterer Teil Periode
	move.b	(a1)+,d1		;Samplenummer & Kommando
	move.b	(a1)+,3(a2)		;Kommando Argument
	move.b	d1,d2
	and.b	#$0f,d1
	and.b	#$f0,d2
	lsr.b	#2,d2
	and.w	#$f0,d0
	lsl.w	#2,d0
	or.w	d0,d2
	or.b	d2,d1
	move.b	d1,2(a2)
	lsr.w	#4,d0
	and.b	#$f0,d0
	or.b	d0,(a2)
.empty
	addq.l	#4,a2
	subq.l	#1,d6
	bne.s	.star_patt

	add.l	$310(a0),a0
	lea	$310(a0),a0

	move.l	a0,SamplePointer(A5)
	bra	StandardGopackind

*----------------------------------------------------------------------------*
TP1_InitPlayer:
	jsr	A5ClrInfoBuffer(a5)
	jsr	A5ClearProTemps(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	lea	28+4(a0),a0

	lea	250(a0),a3
	move.w	-2(a3),d0
	move.l	#$7fffffff,d1
.tp1_dereloc1
	move.l	(a3)+,d2
	cmp.l	d2,d1
	blt.s	.tp1_lower
	move.l	d2,d1
.tp1_lower
	dbf	d0,.tp1_dereloc1

	lea	250(a0),a3
	move.w	-2(a3),d0
	addq.w	#1,d0
	lsl.w	#2,d0
	lea	(a3,d0.w),a3
.tp1_find1
	tst.l	(a3)+
	beq.s	.tp1_find1

	move.l	a3,d0
	add.l	#32-4,d0
	sub.l	a0,d0			;d0=$31a
	sub.l	d0,d1

	lea	250(a0),a3
	move.w	-2(a3),d0
.tp1_dereloc2
	move.l	(A3),d2
	sub.l	d1,d2
	move.l	d2,(a3)+
	dbf	d0,.tp1_dereloc2

	lea	2(a0),a3
	moveq	#31-1,d0
	moveq	#0,d1
	moveq	#0,d7
.tp1_samsize
	move.w	(a3),d1
	add.l	d1,d7
	add.l	d1,d7
	addq.l	#8,a3
	dbf	d0,.tp1_samsize

	move.w	-2(a3),d1

	lea	(a3),a2
	lea	(a3),a1

	lea	pro_temp1(a5),a4
	clr.l	(A4)+
	moveq	#0,d2			;Aktuelle Patternnummer
	moveq	#0,d6			;Offset 0 mitzhlen
.tp1_findpatts
	lea	pro_temp1(a5),a3
	move.w	d6,d4
.tp1_search
	move.l	(a3)+,d5
	cmp.l	(a2),d5
	beq.s	.tp1_found
.tp1_next
	dbf	d4,.tp1_search

	move.l	(a2),(a4)+
	addq.w	#1,d6
.tp1_found
	addq.l	#4,a2
	dbf	d1,.tp1_findpatts

	move.w	d6,d0

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3

	move.l	ori_data(A5),a0
	lea	8(a0),a1
	lea	(a3),a2
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+

	lea	32(a0),a1
	moveq	#31-1,d0
	lea	42(a3),a2
.tp1_sinfos				;Sampleinfos zurck
	move.w	(a1)+,d1		;Volume
	move.w	d1,2(a2)
	move.w	(a1)+,(a2)
	move.l	(a1)+,4(A2)
	lea	30(a2),a2
	dbf	d0,.tp1_sinfos

	lea	34+31*8(a0),a1		;in A1 Patternliste

	movem.l	a0/a1/a3,-(sp)
	move.w	32+31*8(a0),d5
	addq.w	#1,d5
	move.b	d5,$3b6(a3)
	subq.w	#1,d5
	clr.b	$3b7(A3)

	lea	$3b8(a3),a3		;1. Songpos
.tp1_dosinfo
	lea	Pro_temp1+4(a5),a0
	move.w	d6,d2
	subq.w	#1,d2
	moveq	#0,d3
.tp1_search2
	move.l	(a0)+,d4
	cmp.l	(a1),d4
	beq.s	.tp1_found2
.tp1_next2
	addq.w	#1,d3
	dbf	d2,.tp1_search2
	moveq	#0,d3			;sollte nicht vorkommen
.tp1_found2
	move.b	d3,(a3)+
	addq.l	#4,a1
	dbf	d5,.tp1_dosinfo
	movem.l	(sp)+,a0/a1/a3

	move.l	#`M.K.`,$438(a3)

	lea	(a0),a2				;1. Pattern MEXX

						;in A1 jetzt Pointer auf
						;Patternpositionen MEXX
	move.w	(a1,d2.w),d0
	lea	(a2,d0.w),a4			;1.Sample MEXX

	move.w	d6,d2
	movem.l	d2/d7/a3/a4/a5,-(sp)
	lea	my_periods(pc),a6

	lea	pro_temp1(A5),a5

	lea	$43c(a3),a3			;Patterns ProT
	subq.w	#1,d2
.tp1_allpatts
	move.l	a3,-(sp)

	move.l	(a1)+,d3
	lea	(a2,d3.w),a4			;Pattern, das bearbeitet wird

	move.w	#64*4-1,d0
.tp1_1patt
	clr.l	(a3)				;vorher lschen

	moveq	#0,d4
	move.b	(A4)+,d4
	bpl.s	.tp1_normal			;Normale Note

	btst	#6,d4				;Leerstellen ?
	bne.s	.tp1_count			;ja

	andi.w	#$3C,d4				;Maske
	lsr.w	#2,d4				;rechts shiften
	move.b	d4,2(A3)			;Kommando
	cmp.b	#$a,d4
	bne.s	.tp1_novols
	move.b	(A4)+,d4
	bpl.s	.tp1_blabla
	neg.b	d4
	move.b	d4,3(A3)
	bra.s	.tp1_lo
.tp1_blabla
	lsl.b	#4,d4
	move.b	d4,3(A3)
	bra.s	.tp1_lo
.tp1_novols
	move.b	(a4)+,3(A3)			;KommandoArgument
	bra.s	.tp1_lo
.tp1_count
	bra.s	.tp1_lo
.tp1_normal
	moveq	#0,d5
	move.b	(a4)+,d5

	moveq	#15,d6
	and.b	d5,d6

	cmp.b	#$a,d6
	bne.s	.tp1_novols2
	move.b	(A4)+,d7
	bpl.s	.tp1_blablabla
	neg.b	d7
	move.b	d7,3(A3)
	bra.s	.tp1_nocommand
.tp1_blablabla
	lsl.b	#4,d7
	move.b	d7,3(A3)
	bra.s	.tp1_nocommand
.tp1_novols2
	move.b	(a4)+,3(a3)			;Kommandoargument sichern
.tp1_nocommand
	moveq	#0,d7

	btst	#0,d4
	beq.s	.tp1_nohigher			;Samplenummer grer $f ?
	bclr	#0,d4
	move.w	#$1000,d7
.tp1_nohigher
	move.b	d5,2(A3)			;Samplenummer lo Teil und
						;Kommando
	move.w	(a6,d4.w),d6		;move.w	my_periods(pc,d4.w),d6
	or.w	d7,d6
	move.w	d6,(A3)
.tp1_lo
	addq.l	#4,a3

	dbf	d0,.tp1_1patt
	move.l	(sp)+,a3
	lea	1024(a3),a3			;nchstes Patt ProT
	dbf	d2,.tp1_allpatts

	movem.l	(sp)+,d2/d7/a3/a4/a5		;A4 = 1.Sample MEXX
						;D7 = Samplessize MEXX
	add.w	$1e(a0),a0
	bra	StandardGopackind

*----------------------------------------------------------------------------*
Mexx_InitPlayer:jsr	A5ClrInfoBuffer(a5)
		jsr	A5ClearProTemps(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

		cmp.l	#`MEXX`,(a0)
		bne.s	.nothis
		lea	28(a0),a0
.nothis
		moveq	#0,d0
		move.w	(a0)+,d0
		add.l	d0,a0
		move.w	(a0)+,d0
		moveq	#0,d1
		moveq	#0,d2
.Mexx_hipatt:	move.w	(a0)+,d1
		cmp.w	d1,d2
		bgt.s	.Mexx_nohi
		move.w	d1,d2
.Mexx_nohi:	subq.w	#1,d0
		bne.s	.Mexx_hipatt
		addq.w	#8,d2
		move.w	d2,d0
		lsr.l	#3,d0	;Mal 1024/8, da sowieso schon mit 8 Multipliziert war
		move.l	d2,d3

		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a3

		move.l	d3,d2

		move.l	Ori_Data(a5),a0
		cmp.l	#`MEXX`,(a0)
		bne.s	.nothis2
		lea	28(a0),a0
.nothis2
		move.w	(a0)+,d0
		move.l	a0,a1
		add.w	d0,a1
		lsr.w	#3,d0
		subq.w	#1,d0
		lea	42(a3),a2
.Mexx_sinfos:	move.w	(a0)+,d1		;Volume
		move.w	d1,2(a2)
		move.w	(a0)+,(a2)
		move.l	(a0)+,4(A2)
		lea	30(a2),a2
		dbf	d0,.Mexx_sinfos

		lea	$3b6(a3),a2
		move.w	(a1)+,d0
		move.b	d0,(a2)+
		move.b	#$7f,(a2)+
		subq.w	#1,d0
.Mexx_son:	move.w	(a1)+,d1
		lsr.w	#3,d1
		move.b	d1,(a2)+
		dbf	d0,.Mexx_son

	;	move.l	#`M.K.`,$438(a3)

						;in A1 jetzt Pointer auf
						;Patternpositionen MEXX
		lea	2(a1,d2.w),a2		;1. Patternstreifen MEXX
		move.w	(a1,d2.w),d0
		lea	(a2,d0.w),a4		;1.Sample MEXX

		movem.l	d2/d7/a3/a4,-(sp)
		lea	Pro_MyPeriods(pc),a0

		lea	$43c(a3),a3			;Patterns ProT
		lsr.w	#3,d2
.Mexx_allpatts:	moveq	#3,d1
		move.l	a3,-(sp)
.Mexx_1patt:	moveq	#63,d0
		move.l	a3,-(sp)
		move.w	(a1)+,d3
		lea	(a2,d3.w),a4			;Pattstreifen, der bearbeitet
							;wird
		moveq	#0,d3
.Mexx_1_Stripe:	clr.l	(a3)				;vorher lschen

		addq.b	#1,d3
		bmi.w	.Mexx_lo

		moveq	#0,d4
		move.b	(A4)+,d4
		bpl.s	.Mexx_normal			;Normale Note

		btst	#6,d4				;Leerstellen ?
		bne.s	.Mexx_count			;ja

		andi.w	#$3C,d4				;Maske
		lsr.w	#2,d4				;rechts shiften
		cmp.b	#8,d4
		bne.s	.mexx_no8
		moveq	#0,d4
.mexx_no8
		move.b	d4,2(A3)			;Kommando

		cmp.b	#$a,d4
		bne.s	.Mexx_NoVols
		move.b	(A4)+,d4
		bpl.s	.Mexx_blabla
		neg.b	d4
		move.b	d4,3(A3)
		bra.s	.Mexx_lo
.Mexx_blabla:	lsl.b	#4,d4
		move.b	d4,3(A3)
		bra.s	.mexx_lo
.Mexx_NoVols:	move.b	(a4)+,3(A3)			;KommandoArgument
		bra.s	.Mexx_lo

.Mexx_Count:	move.b	d4,d3
		bra.s	.Mexx_Lo
.Mexx_Normal:	moveq	#0,d5
		move.b	(a4)+,d5
		moveq	#15,d6
		and.b	d5,d6
		beq.s	.Mexx_NoCommand

		cmp.b	#$a,d6
		bne.s	.Mexx_NoVols2
		move.b	(a4)+,d7
		bpl.s	.Mexx_blablabla
		neg.b	d7
		move.b	d7,3(a3)
		bra.s	.Mexx_NoCommand
.Mexx_Blablabla:lsl.b	#4,d7
		move.b	d7,3(a3)
		bra.s	.mexx_nocommand
.Mexx_novols2:
		cmp.b	#8,d6
		bne.s	.mexx_no82
		and.b	#$f0,d5
.mexx_no82
		move.b	(a4)+,3(a3)			;Kommandoargument sichern
.Mexx_nocommand:moveq	#0,d7
		btst	#0,d4
		beq.s	.Mexx_nohigher			;Samplenummer grer $f ?
		bclr	#0,d4
		move.w	#$1000,d7
.Mexx_nohigher:	move.b	d5,2(a3)			;Samplenummer lo Teil und
							;Kommando
		move.w	(a0,d4.w),d6
		or.w	d7,d6
		move.w	d6,(A3)
.Mexx_lo:	addq.l	#8,a3
		addq.l	#8,a3
		dbf	d0,.Mexx_1_Stripe
		move.l	(sp)+,a3
		addq.l	#4,a3
		dbf	d1,.Mexx_1Patt

		move.l	(sp)+,a3
		lea	1024(a3),a3			;nchstes Patt ProT
		dbf	d2,.Mexx_allpatts

		movem.l	(sp)+,d2/d7/a3/a4		;A4 = 1.Sample MEXX
						;D7 = Samplessize MEXX

		move.l	a4,a0
		bra	Standardgopackind

*-----------------------------------------------------------------------------*
AMBK_Initplayer
	jsr	A5ClearProTemps(a5)
	jsr	A5ClrInfoBuffer(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	;------------------------ Konverter ----------------------------------

	cmp.l	#`AmBk`,(a0)+
	beq.s	.musi
	subq.l	#4,a0
	move.l	(a0),d3
	and.l	#$ffffff,d3
	bra.s	.skipmusi
.musi
	move.l	4(a0),d3
	and.l	#$ffffff,d3
	addq.l	#4,d3
.skipmusi
	lea.l	$14(A0),a1
	add.l	(a1),a1

	addq.l	#2,a1
	add.w	6(a1),a1

	moveq	#0,d0
.such
	move.w	(a1)+,d1
	bmi.s	.found

	cmp.w	d0,d1
	ble.s	.such
	move.w	d1,d0
	bra.s	.such
.found
	move.w	d0,d5
	addq.w	#1,d0		;Num Patts

	tst.w	(a1)		;Num Patts=0 ?
	bne.s	.ok12
	addq.l	#2,a1		;aha, noch ein freies Wort bei GMC Modz
.ok12
				;A1 pointet jetzt auf Num Patts
;	move.w	(a1),d0	

	lea	$20(a0),a2
	move.w	(a2)+,d1
	subq.w	#1,d1

	add.w	#14,a2		;Lnge 1. Sam
	moveq	#0,d2
	moveq	#0,d7
.samsize
	move.w	(a2),d2
	bne.s	.ok
	move.w	-6(A2),d2
.ok	add.l	d2,d7
	add.l	d2,d7
	add.w	#$20,a2
	dbf	d1,.samsize
				;D7 = Size of Samples
	sub.l	d7,d3
	addq.l	#8,d3
	move.l	d3,Pro_InfoBuffer+52	;Songsize setzen

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3

	lea	42+6(a3),a2
	moveq	#31-1,d0
.set01
	move.w	#1,(a2)
	add.w	#30,a2
	dbf	d0,.set01

	;------------------ 1. Recover Sampleinfo Structures ----------------

	lea	$20(a0),a2
	lea	20(a3),a4
	move.w	(a2)+,d1
	subq.w	#1,d1
.saminfos
	move.w	12(a2),22+2(a4)		;Vol

	move.w	14(a2),d0
	bne.s	.siz
	move.w	8(a2),d0
	move.w	d0,22(a4)		;Size

	move.w	10(a2),d2		;Replen
	cmp.w	#2,d2
	ble.s	.norep
	move.w	d2,22+6(a4)
 
	move.l	4(A2),d0
	sub.l	(a2),d0
	move.w	d0,22+4(a4)
	bra.s	.norep
.siz
	move.w	d0,22(a4)		;Size
	move.w	10(a2),d0		;Replen
	cmp.w	#2,d0
	ble.s	.norep
	move.w	d0,22+6(a4)
	move.w	8(a2),d0
	add.w	d0,d0
	move.w	d0,22+4(a4)
.norep
	lea	16(a2),a2
	moveq	#16-1,d0
.nam
	move.b	(a2)+,(a4)+
	dbf	d0,.nam
	add.w	#30-16,a4
	dbf	d1,.saminfos

	;------------------ 2. Recover Songinfo Structure ------------------

	lea.l	$14(A0),a2
	add.l	(a2),a2
	lea	14(a2),a4
	move.l	(a4)+,(a3)
	move.l	(a4)+,4(a3)
	move.l	(a4)+,8(a3)
	move.l	(a4)+,12(a3)	;Songname
	addq.w	#2,a2
	add.w	(a2),a2		;Position List #1 (currently always the same)

	lea	$3b8(A3),a4
	moveq	#-1,d0
.songinfos
	addq.w	#1,d0
	move.w	(a2)+,d1
	bmi.s	.finished
	move.b	d1,(a4)+
	bra.s	.songinfos
.finished
	move.b	d0,$3b6(a3)	;Songlen

	lea	$438(A3),a2
	move.l	#`M.K.`,(a2)+
;	move.w	(a1),d5
;	subq.w	#1,d5
	moveq	#2,d0

	lea	(a1),a4
.allpatts
	lea	(a4),a1
	add.w	(a4,d0.w),a1
	addq.w	#2,d0
	bsr	.Convertpatt
	addq.l	#4,a2

	lea	(a4),a1
	add.w	(a4,d0.w),a1
	addq.w	#2,d0
	bsr	.Convertpatt
	addq.l	#4,a2

	lea	(a4),a1
	add.w	(a4,d0.w),a1
	addq.w	#2,d0
	bsr	.Convertpatt
	addq.l	#4,a2

	lea	(a4),a1
	add.w	(a4,d0.w),a1
	addq.w	#2,d0
	bsr	.Convertpatt
	addq.l	#4,a2

	add.w	#$400-16,a2
	dbf	d5,.allpatts
				;A2 = 1. Sample Protracker
	lea	$20(a0),a0
	move.w	(a0)+,d0
	lsl.w	#5,d0
	add.w	d0,a0		;A0 = 1. Sample AmBk

	move.l	a0,SamplePointer(a5)

	*--------- Zum ProTracker-InitPlayer hpfen --------*
	moveq	#1,d1			;convertiertes Module geladen
	bra.w	ProT_PackInd

.ConvertPatt			;aktueller Patternsteifen in A1
				;Pattern (richtige Note) in A0
	movem.l	d0-d5/a0-a2,-(sp)

	moveq	#$3f,d2
	moveq	#0,d3
	moveq	#0,d4
.dopattern
	clr.l	(a2)
	subq.b	#1,d3
	bgt.w	.warte

	move.w	d4,d5
.one_note_loop
	move.w	(A1)+,d0
	move.w	d0,d1
	bmi.s	.docmd

	and.w	#$7f00,d1
	cmp.w	#$7f00,d1
	beq	.dowait

	and.w	#$3000,d1
	cmp.w	#$3000,d1
	bne.w	.ignore
	and.w	#$fff,d0
	or.w	d0,(a2)		;Note	
	bra.w	.ignore
.doWait
	move.w	(a1),d1
	lsr.w	#8,d1
	lsr.w	#2,d1
	move.b	2(a2),d6
	lsr.b	#4,d6
	add.b	d6,d1
	move.b	(a2),d6
	and.b	#$10,d6
	add.b	d6,d1
	move.b	d1,d6
	and.b	#$10,d6
	clr.w	(a2)
	move.b	d6,(a2)
	lsl.b	#4,d1
	move.b	2(a2),d6
	and.b	#$f,d6
	or.b	d1,d6
	move.b	d6,2(A2)

	move.w	(a1)+,d1
	and.w	#$3ff,d1
	or.w	d1,(a2)		;Note
	move.w	d0,d3
	and.w	#$7f,d3
;	subq	#1,d3
	bra	.warte
.docmd
	and.w	#$FF00,d1
	cmp.w	#$9000,d1
	beq.w	.delay
	cmp.w	#$9100,d1
	bne.s	.nojmp
	move.b	#$B,d1
	bra.w	.dofx2
.nojmp
	cmp.w	#$8300,d1
	bne.s	.novol
	move.b	#$c,d1
	bra.w	.dofx2
.novol
	cmp.w	#$8400,d1
	bne.s	.nostop
	moveq	#0,d4
	bra.w	.ignore
.nostop
	cmp.w	#$8800,d1
	bne.s	.notempo
	moveq	#100,d3
	and.w	#$ff,d0
	beq	.ignore
	divu	d0,d3
	move.b	#$f,d1
	move.b	d3,d0
	bra.w	.dofx2
.notempo
	cmp.w	#$8A00,d1
	bne.s	.noarp
	clr.b	d1
	bra.w	.dofx
.noarp
	cmp.w	#$8B00,d1
	bne.s	.noport
	move.b	#3,d1
	bra.w	.dofx
.noport
	cmp.w	#$8C00,d1
	bne.s	.novib
	move.b	#4,d1
	bra.s	.dofx
.novib
	cmp.w	#$8D00,d1
	bne.s	.novsl
	move.b	#$A,d1
	bra.s	.dofx
.novsl
	cmp.w	#$8E00,d1
	bne.s	.noslup
	move.b	#$1,d1
	bra.s	.dofx
.noslup
	cmp.w	#$8F00,d1
	bne.s	.nosldwn
	move.b	#$2,d1
	bra.s	.dofx
.nosldwn
	cmp.w	#$8900,d1
	bne.s	.noinst
	addq.b	#1,d0
	move.b	d0,d3
	lsl.b	#4,d0
	or.b	d0,2(a2)
	and.b	#$10,d3
	or.b	d3,(a2)
	bra.w	.ignore
.noinst
	cmp.w	#$8000,d1
	bne.s	.nobreak
	clr.b	3-16(a2)
	move.b	2-16(a2),d3
	and.b	#$f0,d3
	or.b	#$0d,d3
	move.b	d3,2-16(a2)
	bra.s	.endpatt
.nobreak
	bra.s	.ignore
.dofx2
	move.b	d0,3(a2)
	move.b	2(a2),d3
	and.b	#$f0,d3
	or.b	d1,d3
	move.b	d3,2(a2)

	move.w	2(a2),d5
	bra.s	.ignore
.dofx
	move.b	d0,3(a2)
	move.b	2(a2),d3
	and.b	#$f0,d3
	or.b	d1,d3
	move.b	d3,2(a2)

	move.w	2(a2),d4
	move.w	d4,d5
	and.w	#$fff,d4	;cmd only
.ignore
	bra.w	.one_note_loop
.delay
	move.b	d0,d3
	move.w	2(A2),d0
	and.w	#$f000,d0
	or.w	d5,d0
	move.w	d0,2(a2)
	bra.s	.del2
.warte
	or.w	d4,2(a2)
.del2
	lea	16(a2),a2
	dbf	d2,.dopattern
.endpatt
	movem.l	(sp)+,d0-d5/a0-a2
	rts


*-----------------------------------------------------------------------------*
AC1D_InitPlayer:
		jsr	A5ClearProTemps(a5)
		jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

	move.w	2(a0),d0

	moveq	#0,d1
	move.b	(a0),d1

	lea	8(a0),a1
	moveq	#31-1,d0
	moveq	#0,d7
	moveq	#0,d2
.ac1d_samsize
	move.w	(a1),d2
	add.l	d2,d7
	add.l	d2,d7
	addq.l	#8,a1
	dbf	d0,.ac1d_samsize

	lea	$300(a0),a1
	subq.w	#1,d1
	move.w	d1,d4
	moveq	#0,d6			;Anzahl Patts
.ac_patt
	cmp.b	(a1)+,d6
	bge.s	.hi
	move.b	-1(A1),d6
.hi
	dbf	d1,.ac_patt

	moveq	#0,d0
	addq.w	#1,d6
	move.w	d6,d0

	*------- Speicher fr PT-Module laden | d0=Pattern --------*
	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3

	lea	42(a3),a2
	lea	8(a0),a1
	moveq	#30,d0
.ac_dosam
	move.l	(a1)+,(a2)+	
	move.l	(a1)+,(a2)+	
	lea	30-8(A2),a2
	dbf	d0,.ac_dosam

	move.b	(a0),$3b6(a3)
	lea	$300(a0),a1
	lea	$3b8(A3),a2
.ac_dosong
	move.b	(a1)+,(a2)+
	dbf	d4,.ac_dosong

	lea	$43c(a3),a2
	subq.w	#1,d6

	movem.l	a3/d7,-(sp)
	lea	$100(a0),a1			;Adressen der Patterns
	move.l	(a1),d7				;Grundadresse
	sub.l	#$380+12,d7			;+ Anfangsoffset zum 1.
						;Pattern
	lea	pr_periods(pc),a3
.ac_dopatts
	move.l	(a1)+,d0
	sub.l	d7,d0
	lea	(a0,d0.l),a4			;Patternadr

	moveq	#3,d5
.ac_1patt
	moveq	#$3f,d4
	move.l	a2,-(sp)
.ac_1stripe
	clr.l	(a2)

	moveq	#0,d0	
	move.b	(a4),d0
	blt.s	.ac_wait1
	move.b	d0,d1
	and.b	#$40,d1
	beq.s	.ac_no16
	move.b	#$10,(a2)
.ac_no16
	move.b	d0,d1
	and.w	#$3f,d1
	cmp.b	#$3f,d1				;keine Periode ?
	beq.s	.ac_noper			;n

	sub.w	#12,d1
	add.w	d1,d1
	move.w	(a3,d1.w),d1			;Periode holen
	or.w	d1,(a2)				;speichern

	move.b	1(a4),d0
	move.b	d0,d1
	and.w	#15,d1
	cmp.b	#7,d1
	beq.s	.ac_weissnich

	move.b	d0,2(A2)
	move.b	2(a4),3(A2)

	addq.l	#3,a4
	bra.s	.ac_nextnote
.ac_weissnich
	and.b	#$f0,d0
	move.b	d0,2(a2)
	addq.l	#2,a4
	bra.s	.ac_nextnote
.ac_noper
	move.b	1(a4),2(a2)
	move.b	2(a4),3(a2)
	addq.l	#3,a4
	bra.s	.ac_nextnote
.ac_wait1
	and.w	#$7f,d0
	subq.w	#1,d0
	addq.l	#1,a4
.ac_wait
	subq.w	#1,d4
	clr.l	(a2)
	addq.l	#8,a2
	addq.l	#8,a2
	dbf	d0,.ac_wait
	TST.W	D4
	blt.s	.ac_nextstripe
	addq.w	#1,d4
	lea	-16(a2),a2
.ac_nextnote
	lea	16(a2),a2
	
	dbf	d4,.ac_1stripe
.ac_nextstripe
	move.l	(sp)+,a2
	addq.l	#4,a2				;nchste Note
	dbf	d5,.ac_1patt
	lea	1024-16(a2),a2			;nchstes Patt
	dbf	d6,.ac_dopatts
	movem.l	(sp)+,a3/d7

	add.l	4(a0),a0	

	bra	Standardgopackind

*-----------------------------------------------------------------------------*
DI_InitPlayer:	jsr	A5ClearProTemps(a5)
		jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)


;		move.w	(a0),d0			;Sampleanzahl
;		lea	$e(a0),a1		;1.Sampleinfostruktur
;		subq.w	#1,d0
;		moveq	#0,d7
;.di_samsize:	moveq	#0,d1
;		move.w	(a1),d1			;Lnge holen
;		beq.s	.di_nosam
;		add.l	d1,d7			;in D7 Samplesize
;		add.l	d1,d7
;.di_nosam:	addq.l	#8,a1
;		dbf	d0,.di_samsize

		moveq	#0,d0
		move.l	2(a0),d0
		lea	(a0,d0.l),a1
		moveq	#0,d0
		moveq	#0,d1
.di_countpatts:	move.b	(a1)+,d1
		cmp.b	#$ff,d1
		beq.s	.di_countready
		cmp.b	d1,d0
		bgt.s	.di_countpatts
		move.b	d1,d0
		bra.s	.di_countpatts
.di_countready:
		move.l	d0,d6			;Anzahl der Patterns
		addq.w	#1,d0
;		lsl.l	#8,d0
;		lsl.l	#2,d0			;Patternsize
;		add.l	#$43c,d0		;Vorblock


	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a1

		lea	22+20(a1),a3		;Protracker 1.Samplelnge
		lea	$e(a0),a2		;DI 1. Samplelnge
		move.w	(a0),d0			;Anzahl der Samples
		move.w	#$1e,d1			;31-1 Samples
		sub.w	d0,d1
		subq.w	#1,d0
.di_convertsinfos:move.l (a2)+,(a3)+
		move.l	(a2)+,(a3)+
		lea	30-8(a3),a3
		dbf	d0,.di_convertsinfos

		tst.w	d1
		blt.s	.di_donothing
		addq.l	#7,a3
.di_setrep:	move.b	#1,(a3)
		lea	30(a3),a3
		dbf	d1,.di_setrep
.di_donothing:	lea	$3b8(a1),a3
		move.l	2(a0),d0
		lea	(a0,d0.l),a2
		moveq	#0,d2
.di_countlen:	move.b	(a2)+,d1
		cmp.b	#$ff,d1
		beq.s	.di_nomore
		move.b	d1,(a3)+
		addq.w	#1,d2
		bra.s	.di_countlen
.di_nomore:	move.b	d2,$3b6(a1)
		move.b	#$7f,$3b7(a1)
	;	move.l	#`M.K.`,$438(a1)

		lea	$43c(a1),a3		;1.Patt ProT
		move.w	(a0),d0
		lsl.w	#3,d0
		lea	$e(a0,d0.w),a2		;Zeiger Offset zum 1.Pattern DI

		movem.l	d6/a1,-(sp)
		lea	My_Periods(pc),a1
.di_dopatts:	move.w	(a2)+,d1		;Offset holen
		lea	(a0,d1.w),a4		;Patternadresse

		move.w	#64*4-1,d3
.di_dopatt:	moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d4

		move.b	(a4)+,d0
		cmp.b	#$ff,d0
		bne.s	.di_note
		clr.l	(a3)
		bra.s	.di_nonote
.di_note:	lsl.w	#8,d0
		move.b	(a4)+,d1
		bclr	#$f,d0
		beq.s	.di_no3rd
		move.b	(a4)+,d4
.di_no3rd:	move.b	d4,3(a3)
		move.b	d1,d4
		and.b	#$f,d4
		cmp.b	#$b,d4
		bne.s	.nojmp
		moveq	#0,d4
		clr.b	3(a3)
.nojmp
		move.b	d4,2(a3)
		or.b	d1,d0
		move.w	d0,d1
		lsr.w	#3,d1
		and.w	#$7e,d1			;Periodenzeiger
		move.w	(a1,d1.w),d1
		move.w	d1,(a3)			;Periode

		lsr.w	#6,d0			;Samplenummer
		move.w	d0,d1
		and.b	#$f0,d0
		and.w	#$100,d1
		beq.s	.di_noset
		or.b	#$10,(a3)
.di_noset:	or.b	d0,2(a3)
.di_nonote:	addq.l	#4,a3
		dbf	d3,.di_dopatt

		dbf	d6,.di_dopatts
		movem.l	(sp)+,d6/a1

	;	addq.w	#1,d6
	;	lsl.l	#8,d6
	;	lsl.l	#2,d6			;Patternsize
	;	add.l	#$43c,d6		;+Vorblock

	;	lsr.l	#1,d7
	;	lea	(a1,d6.l),a1		;Zeiger 1. Sample Protracker
		move.l	$a(a0),d0
		lea	(a0,d0.l),a0		;Zeiger 1. Sample DI

		bra	Standardgopackind

*---------------------------------------------------------------------------*
PP30_Check:	move.l	DTG_ChkData(a5),a0	;check
	lea	$f6(a0),a4
	move.l	(a4),d7

	cmp.w	#$0100,d7		;min. 1 pattern
	blt.w	Check_Error		;excludes pattern number > $7f ,too

	tst.w	$204(a4)	nur reinnehmen, wenn direkt auf PP21/PP30
	bne.w	Check_Error	gecheckt werden soll

	tst.b	d7		Restart should be 0 or $7f or $78
	beq.s	.testpp2x
	cmp.b	#$7f,d7	
	beq.s	.testpp2x
	cmp.b	#$78,d7	
	bne	Check_Error
.testpp2x
	move.l	-6(a4),d0
	bne.s	.usedsmpl
	moveq	#1,d1
	cmp.l	-2(a4),d1
	bne	Check_Error
	bra.s	.possPP21

.usedsmpl
	swap	d0
	tst.w	d0		;check zero sample
	beq	Check_Error
	swap	d0
	cmp.b	#$40,d0		;check last volume
	bhi	Check_Error
	tst.b	d0		;check zero volume
	beq	Check_Error
	and.w	#$ff00,d0
	cmp.w	#$0f00,d0		;check last finetune
	bhi	Check_Error

.possPP21
	lea	-$f6(a4),a1
	move.l	a1,a3
	moveq	#$1e,d4			;maxsamples-1
	moveq	#0,d3
	move.l	a1,a3
.SampleChkLoop
	move.w	(a3),d6
	beq.s	.GetNextSample
	st	d3			;min 1 sample da
	cmp.w	4(a3),d6		;Repeat<SampleLen
	blo	Check_Error		;JA!
	cmp.w	6(a3),d6		;Reapeatlen<SampleLen
	blo	Check_Error
	move.w	4(a3),d5		;Reapeatpoint
	move.w	6(a3),d2		;Repeatlen must be >=0		
	beq	Check_Error
	add.w	d2,d5		
	bvs	Check_Error		;RepeatPoint+RepeatLen > $ffff !
	cmp.w	d5,d6
	blo	Check_Error
	move.w	2(a3),d1
	cmp.b	#$40,d1		;vol>$40? (trollo du hast schon wieder gepennt!)
	bhi	Check_Error		;yes!
	;cmp.b	#$04,d1		;vol<$04 makes no sense
	;blo	Check_Error		;yes!
	and.w	#$ff00,d1
	cmp.w	#$0f00,d1
	bhi	Check_Error		;finetune<$10
.get_it	addq.l	#8,a3		;ptr->next sample
	dbra	d4,.SampleChkLoop
	tst.b	d3
	beq	Check_Error
	bra.s	.checklen

.GetNextSample
	tst.w	2(a3)		;check zero sample
	bne	Check_Error		;nonsense finetune/volume
	move.l	4(a3),d1
	subq.l	#1,d1		;nonsense repeatpoint/-length
	bne	Check_Error
	bra.s	.get_it
	
.checklen
	lea	$f8(a1),a2
	moveq	#0,d0
	move.b	(a2)+,d0		;pattern number
	cmp.b	#$7f,(a2)+
	bhi	Check_Error			;!

	move.w	#$1ff,d5
	moveq	#0,d0		;init max.pattern
.chkmxpat
	move.b	(a2)+,d1
	cmp.b	d1,d0
	bhs.s	.nomax1
	move.b	d1,d0
.nomax1
	dbf	d5,.chkmxpat

	move.w	d0,d6

	addq.w	#$01,d0
	ext.l	d0
	mulu	#$0080,d0
	lea	$02FA(a1),a2
	move.l	a2,a3
	add.l	d0,a3
	move.l	(a3),d1
	asr.l	#$02,d1
	subq.w	#$01,d1

	tst.w	(a2)
	bne	Check_Error			;<>0 -> weder PP21, noch PP30 !
.pp2x_12
	cmp.w	(a2)+,d1
	blt	.testpp30
	cmp.l	a3,a2
	blt.s	.pp2x_12
	;hier nun PP21 erkannt
	bra	Check_Error
.testpp30
	lea	$02FA(a1),a2
	move.l	(a3),d1
	subq.w	#$01,d1
.pp30_6	cmp.w	(a2)+,d1
	blt	Check_Error
	cmp.l	a3,a2
	blt.s	.pp30_6

		lea	$F8(a0),a2
		cmp.b	#$7f,(a2)
		bhi	Check_Error
		cmp.b	#$01,(a2)+
		blt	Check_Error
		cmp.b	#$7F,(a2)
		bhi	Check_Error

		lea	(a0),a2
		moveq	#$1E,d6

.PP30_1		move.w	2(a2),d0
		move.w	d0,d1
		and.w	#$F000,d1
		tst.w	d1
		bne	Check_Error
		and.w	#$ff,d0
		cmp.w	#$40,d0	;alles ber 64(ohne Vorzeichenbeachtung) Fehler
		bhi	Check_Error

		tst.w	(a2)
		beq.s	.PP30_2
		moveq	#0,d1
		moveq	#0,d2
		move.w	$4(a2),d1
		move.w	$6(a2),d2
		add.l	d2,d1
		moveq	#0,d2
		move.w	(a2),d2
		cmp.l	d2,d1
		bgt	Check_Error
.PP30_2:	lea	8(a2),a2
		dbra	d6,.PP30_1
		move.l	a0,a3

		lea	$F8(a0),a2
		moveq	#0,d0
		move.b	(a2),d0
		cmp.b	#1,(a2)+
		blt	Check_Error
		addq.l	#1,a2

		move.l	#$1ff,d6
		moveq	#0,d0
.PP30_4:	cmp.b	(a2),d0
		bhs.s	.PP30_5
		move.b	(a2),d0
.PP30_5		addq.l	#1,a2
		dbra	d6,.PP30_4

		move.w	d0,d6

		addq.w	#$01,d0
		ext.l	d0
		mulu	#$80,d0
		lea	$2FA(a0),a2
		add.l	d0,a2
		move.l	a2,a3
		move.l	(a2),d1
		subq.w	#1,d1
		lea	$2FA(a0),a2
.PP30_61	cmp.w	(a2)+,d1
		blt	Check_Error
		cmp.l	a3,a2
		blt.s	.PP30_61

		jsr	A5ClearProTemps(a5)

		move.l	a3,Unic_Temp(a5)
		moveq	#0,d0
		rts







*-------------------------------------------------------------------------*
PP21_Check:	move.l	DTG_ChkData(a5),a0
		lea	$F8(a0),a2
		cmp.b	#$7f,(a2)
		bhi	Check_Error
		cmp.b	#$01,(a2)+
		blt	Check_Error
		cmp.b	#$7F,(a2)
		bhi	Check_Error

		lea	(a0),a2
		moveq	#$1E,d6

.PP21_1		move.w	$2(a2),d0
		move.w	d0,d1
		and.w	#$F000,d1
		tst.w	d1
		bne	Check_Error
		and.w	#$00ff,d0
		cmp.w	#$0040,d0	;alles ber 64(ohne Vorzeichenbeachtung) Fehler
		bhi	Check_Error

		tst.w	(a2)
		beq.s	.pp21_2
		moveq	#0,d1
		moveq	#0,d2
		move.w	$4(a2),d1
		move.w	$6(a2),d2
		add.l	d2,d1
		moveq	#0,d2
		move.w	(a2),d2
		cmp.l	d2,d1
		bgt	Check_Error
.pp21_2:	lea	8(a2),a2
		dbra	d6,.pp21_1
		move.l	a0,a3

		lea	$F8(a0),a2
		moveq	#0,d0
		move.b	(a2),d0
		cmp.b	#1,(a2)+
		blt	Check_Error
		addq.l	#1,a2

		move.l	#$1ff,d6
		moveq	#0,d0
.pp21_4:	cmp.b	(a2),d0
		bhs.s	.pp21_5
		move.b	(a2),d0
.pp21_5		addq.l	#$01,a2
		dbra	d6,.pp21_4

		move.w	d0,d6

		addq.w	#1,d0
		ext.l	d0
		mulu	#$80,d0
		lea	$2FA(a0),a2
		add.l	d0,a2
		move.l	a2,a3
		move.l	(a2),d1
		asr.l	#$02,d1
		subq.w	#$01,d1
		lea	$02FA(a0),a2
.pp21_6		cmp.w	(a2)+,d1
		blt	Check_Error
		cmp.l	a3,a2
		blt.s	.pp21_6

		jsr	A5ClearProTemps(a5)
		move.l	a3,Unic_Temp(a5)
		moveq	#0,d0
		rts

;===========================================================================
; Routine, die den "normalen" Sampleinfoblock der blichen Tracker checkt
; 0.w Lnge,2.w Lautstrke/Finetune,4.w RepeatStart,6.w RepeatEnd
; A1 -> Basisadresse des Blocks; D0 -> Result (0=OK)
StandardTrackerCheck:
	movem.l	d2-a1,-(Sp)

	moveq	#$1e,d4			;maxsamples-1
	moveq	#0,d3
	moveq	#0,d1
.star_SampleChkLoop
	move.w	(a1),d6
	beq.s	.star_GetNextSample
	move.w	d6,d3
	add.l	d3,d1
	add.l	d3,d1

	cmp.w	4(a1),d6		;Repeat<SampleLen
	blo.s	.endstar		;JA!
	cmp.w	6(a1),d6		;Reapeatlen<SampleLen
	blo.s	.endstar
	move.w	4(a1),d5		;Reapeatpoint
	move.w	6(a1),d2		;Repeatlen must be >=0		
	beq.s	.endstar
	add.w	d2,d5		
	bvs.s	.endstar		;RepeatPoint+RepeatLen > $ffff !
	cmp.w	d5,d6
	blo.s	.endstar
	move.w	2(a1),d2
	cmp.b	#$40,d2		;vol>$40? (trollo du hast schon wieder gepennt!)
	bhi.s	.endstar		;yes!
	;cmp.b	#$04,d2		;vol<$04 makes no sense
	;blo	.endstar		;yes!
	and.w	#$ff00,d2
	cmp.w	#$0f00,d2
	bhi.s	.endstar		;finetune<$10
.star_get_it
	addq.l	#8,a1		;ptr->next sample
	dbra	d4,.star_SampleChkLoop
	tst.l	d1
	beq.s	.endstar
	moveq	#0,d0
	bra.s	.star_wei
.star_GetNextSample
	tst.w	2(a1)		;check zero sample
	bne.s	.endstar		;nonsense finetune/volume
	move.l	4(a1),d2
	subq.l	#1,d2		;nonsense repeatpoint/-length
	bne.s	.endstar
	bra.s	.star_get_it
.endstar
	moveq	#-1,d0
.star_wei
	movem.l	(sp)+,d2-a1
	rts

PP1_check:
;====================== Propacker xx #2 (SKR) ================================
	move.l	DTG_ChkData(a5),a0
PP1_Check_2:
;------------------- 1.Schritt-> Samples berprfen --------------------------
	lea	(a0),a1
	bsr	StandardTrackerCheck
	bne	.noppxx2			;d0<>0 -> Fehler

;---------------- 2.Schritt: Hchstes Pattern suchen ------------------------

	lea	$FA(a0),a1			;Restart
	cmp.b	#$7f,-1(a1)			;grer 127 ?
	bhi	.noPPxx2			;Fehler
	move.b	-2(a1),d0			;Songlnge
	cmp.b	#$7f,d0				;grer 127 ?
	bhi	.noPPxx2			;Fehler

	move.w	#$1FF,d0			;80*4 Werte mglich
	moveq	#0,d2
.ppxx2_loop1
	cmp.b	(a1)+,d2			;Patternnummer holen
	bhs.s	.ppxx2_nothigher1		;n
	move.b	-1(a1),d2			;doch,neue setzen
.ppxx2_nothigher1
	dbf	d0,.ppxx2_loop1		;Loop

;---------------------- 3. Schritt : Patterns berprfen --------------------
	addq.w	#1,d2		;Hchstes Pattern
	lsl.l	#6,d2		;mal 256/4 (Langworttest)
	move.l	d2,d5
	lsl.l	#2,d5		;mal 4 (siehe oben)
	add.l	#$2fa,d5	;Offset zu Patterns
	lea	(a0),a3		;Moduladresse
	add.l	d5,a3		;Zeiger auf 1.Sample
	lea	$2FA(a0),a0

.ppxx2_Loop3
	move.b	(a0),d0		;1.Byte holen
	and.b	#$f0,d0		;Samplenummer obere 4 Bits ausmaskieren
	cmp.b	#$10,d0		;grer 16 ?
	bhi.w	.noPPxx2	;Fehler
	move.w	(a0),d0		;Sampleperiod holen
	and.w	#$fff,d0	;ausmaskieren
	beq.s	.ppxx2_okwei
	lea	Pr_Periods,a1	;Periodentabelle
.ppxx2_loop2
	move.w	(a1)+,d1		;Wert holen
	beq	.noPPxx2		;Null->Tabelle durch->Fehler
	cmp.w	d1,d0			;Wert aus Tabelle = Periodenwert ?
	bne.s	.ppxx2_Loop2		;nein,weitersuchen
.ppxx2_okwei
	addq.l	#4,a0
	subq.l	#1,d2
	bne	.ppxx2_Loop3

	moveq	#0,d0
	rts
.noPPxx2
	moveq	#-1,d0
	rts
PP1_InitPlayer
	jsr	A5ClearProTemps(a5)
	jsr	A5ClrInfoBuffer(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	bsr	PP1_check

	move.l	a3,-(sp)
	move.l	Ori_Data(a5),a0		;Songadresse

				;Umbauroutine,sucht fr die entsprechenden
				;Songpositionen raus,wo die Kombination der
				;Patternstreifen zum ersten Mal bereinstimmt
	lea	Pro_temp1(A5),a2

	lea	$fa(a0),a1		;1. Pattlist $80 Bytes lang
	lea	$fa+$080(a0),a3		;2. Pattlist
	lea	$fa+$100(a0),a4		;3. Pattlist
	lea	$fa+$180(a0),a6		;4. Pattlist

	moveq	#0,d0
	move.b	$f8(A0),d0		;Lnge des Modules in Patterns
	subq.w	#1,d0

	moveq	#0,d1			;aktuelle Songpos
	move.w	d0,d2			;fr spter sichern
.ppxx2_numpatts1
	moveq	#0,d3
.ppxx2_dotest
	move.b	(a1,d1.w),d4
	cmp.b	(a1,d3.w),d4
	bne.s	.ppxx2_testno
	move.b	(a3,d1.w),d4
	cmp.b	(a3,d3.w),d4
	bne.s	.ppxx2_testno
	move.b	(a4,d1.w),d4
	cmp.b	(a4,d3.w),d4
	bne.s	.ppxx2_testno
	move.b	(a6,d1.w),d4
	cmp.b	(a6,d3.w),d4
	bne.s	.ppxx2_testno
	move.w	d3,d5
	bra.s	.ppxx2_testrts
.ppxx2_testno
	addq.w	#1,d3
	cmp.w	d1,d3
	ble.s	.ppxx2_dotest
	move.w	d1,d5
.ppxx2_testrts
	move.b	d5,(a2)+
	add.w	#1,d1
	dbf	d0,.ppxx2_numpatts1

	lea	Pro_Temp2(A5),a4	;Zieladresse
	lea	Pro_temp1(A5),a2
	move.w	d2,d3
.ppxx2_copy
	move.b	(a2)+,(a4)+
	dbf	d3,.ppxx2_copy

	lea	Pro_temp2(A5),a2;Zieladresse, bearbeiten, damit Patternnummern
				;hinterher Stimmen

	moveq	#0,d0		;aktuelle Patternnummer (als ST)

	moveq	#0,d1
	move.w	d2,d3
.ppxx2_uebertrage
	lea	(a2),a3
				;jeweils kleinste Patternnummer suchen,D0
	move.w	d3,d4		;gibt an, welche Nummern schon bearbeitet sind
	moveq	#$7f,d1		;z.B. im ersten Durchlauf ist D0 = 0
.ppxx2_calc			;d.h. im 2. Durchlauf ist dann D0 = 1 und
	cmp.b	(a3),d1		;somit ist die kleinste erlaubte Patternnummer
	ble.s	.ppxx2_notthis	;1 !
	cmp.b	(a3),d0
	bgt.s	.ppxx2_notthis
	move.b	(a3),d1
.ppxx2_notthis
	addq.l	#1,a3
	dbf	d4,.ppxx2_calc


	lea	(a2),a3		;ersetzt die jeweils kleinste Patternnummer,
	move.w	d3,d4		;die vorkommt durch den richtigen Wert, da
.ppxx2_calc2			;die vorkommende Nummer sonstwiehoch sein kann
	cmp.b	(a3)+,d1	;(das enstprechende Pattern kann theoretisch
	bne.s	.ppxx2_wei	;an einer tierisch weit entfernten Pos stehen)
	move.b	d0,-1(A3)
.ppxx2_wei
	dbf	d4,.ppxx2_calc2	

	addq.w	#1,d0
	dbf	d2,.ppxx2_uebertrage

	lea	Pro_temp1(A5),a2;Sourceadr
	move.w	d3,d4		;fr Spter
	move.w	d3,d0
	moveq	#0,d2
.ppxx2_cleardoub
	move.b	(a2)+,d1
	blt.s	.ppxx2_next

	addq.w	#1,d2

	move.w	d0,d3
	move.l	a2,a3
.ppxx2_loop_3
	cmp.b	(a3)+,d1
	bne.s	.ppxx2_not
	move.b	#-1,-1(a3)
.ppxx2_not
	dbf	d3,.ppxx2_loop_3

.ppxx2_next
	dbf	d0,.ppxx2_cleardoub
				;in D2 Anzahl der Patterns,so nebenbei mit
				;berechnet
	movem.l	d1-a6,-(Sp)
	moveq	#0,d0
	move.w	d2,d0
	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	move.l	d1,d0
	movem.l	(sp)+,d1-a6
	tst.l	d0
	beq	Pro_CReturn

	move.l	d0,a1
	move.w	#$43c>>2-1,d2
.ppxx2_clr2
	clr.l	(a1)+
	dbf	d2,.ppxx2_clr2

	move.l	d0,a1

	move.l	a5,-(sp)

	lea	Pro_temp2(A5),a4
	lea	$3b8(a1),a6
	move.w	d4,d0
.ppxx2_positions
	move.b	(a4)+,(a6)+
	dbf	d0,.ppxx2_positions

	lea	PRO_temp1+BSSMERKPuffer,a4	;Welche Patterns rbergeholt werden mssen
	lea	PRO_temp2+BSSMERKPuffer,a6	;was als Soundtracker rauskommt
.ppxx2_dopatts
	moveq	#0,d2
	move.b	(A4)+,d2
	blt.s	.ppxx2_donethis
	moveq	#0,d5
	move.b	(A6),d5
	lea	$43c(a1),a5
	lsl.l	#8,d5	
	lsl.l	#2,d5
	add.l	d5,a5

	lea	$fa(a0),a3
	moveq	#0,d0
	move.b	(a3,d2.w),d0
	bsr	.ppxx2_dostripe

	lea	4(a5),a5
	lea	$fa+$080(a0),a3
	moveq	#0,d0
	move.b	(a3,d2.w),d0
	bsr	.ppxx2_dostripe

	lea	4(a5),a5
	lea	$fa+$100(a0),a3
	moveq	#0,d0
	move.b	(a3,d2.w),d0
	bsr	.ppxx2_dostripe

	lea	4(a5),a5
	lea	$fa+$180(a0),a3
	moveq	#0,d0
	move.b	(a3,d2.w),d0
	bsr	.ppxx2_dostripe

.ppxx2_donethis
	addq.l	#1,a6
	dbf	d4,.ppxx2_dopatts

	move.l	(sp)+,a5

	lea	(a0),a3		;Sampleinfostrukturen wiederherstellen
	move.w	$f8(a0),$3b6(a1);Songlnge,Restart kopieren
	lea	$2a(a1),a2
	moveq	#31-1,d0
.ppxx2_sam
	move.l	(A3)+,(a2)
	move.l	(A3)+,4(a2)
	lea	$1e(a2),a2
	dbf	d0,.ppxx2_sam

	move.l	(sp)+,a3	;Zeiger auf 1.Sample Propacker 2.1
	move.l	a3,SamplePointer(a5)

	move.l	a3,a0
	bra	Standardgopackind

.ppxx2_dostripe
	lea	$2fa(a0),a3
	lsl.w	#8,d0
	lea	(a3,d0.l),a3
	moveq	#63,d0

	move.l	a6,-(sp)

	lea	(A5),a6
.ppxx2_doit
	move.l	(a3)+,(a6)
	lea	16(a6),a6
	dbf	d0,.ppxx2_doit

	move.l	(sp)+,a6
	rts

*--------------------------------------------------------------------------*
WN_Check:	move.l	DTG_ChkData(a5),a0
		moveq	#-1,d0
		move.w	$438(a0),d1
		cmpi.w	#"WN",d1		;"WN" da ?
		bne.s	.NoWn

		lea	$3b8(A0),a1
		moveq	#$7f,d1
		moveq	#0,d2
.Wn_Calc:	cmp.b	(A1)+,d2
		bge.s	.WN_NoThis
		move.b	-1(A1),d2
.Wn_Nothis:	dbf	d1,.wn_calc
		addq.b	#1,d2
		cmp.w	$43a(A0),d2
		bne.s	.nown
		moveq	#0,d0
.NoWn:		rts


*--------------------------------------------------------------------------*
XA_Check:
	move.l	DTG_ChkData(a5),a0
	move.w	#128,d0
	lea	(a0),a1
	moveq	#0,d2
	move.l	#$ffffff,d3
.xa_checkpat
	move.l	(a1)+,d1
	beq.s	.xa_lo2

	cmp.l	d1,d3
	blt.s	.xa_lo1
	move.l	d1,d3
.xa_lo1
	
	cmp.l	d1,d2
	bgt.s	.xa_hi1
	move.l	d1,d2
.xa_hi1
	sub.l	#$43c,d1
	blt.w	.xa_fail
	and.l	#$3ff,d1
	bne.s	.xa_fail
.xa_lo2
	dbf	d0,.xa_checkpat

	cmp.l	#$43c,d2
	blo.s	.xa_fail				;in D3 kleinstes
						;in D2 grtes Pattern
	move.l	d2,d4
	sub.l	d3,d4

	moveq	#31-1,d0
	moveq	#0,d1
	moveq	#0,d7				;Samplessize
.xa_sam
	move.b	3(A1),d1
	cmp.b	#$40,d1
	bhi.w	.xa_fail
	move.w	14(a1),d1
	add.l	d1,d7
	add.l	d1,d7
	lea	16(A1),a1
	dbf	d0,.xa_sam

	tst.l	d7
	beq.s	.xa_fail
	moveq	#0,d0
	rts
.xa_fail
	moveq	#-1,d0
	rts

*--------------------------------------------------------------------------*
PRun_Check:	move.l	DTG_ChkData(a5),a0
		move.l	$438(a0),d0
		subi.l	#"SNT.",d0		;SNT. da ?
		rts

*--------------------------------------------------------------------------*
KR_Check:	move.l	DTG_ChkData(a5),a0
		move.l	$438(a0),d0
		subi.l	#"M.K.",d0		;M.K. da ?
		rts

*--------------------------------------------------------------------------*
PRun2_Check:	move.l	DTG_ChkData(a5),a0
		move.l	(a0),d0
		subi.l	#"SNT!",d0		;SNT. da ?
		rts

*--------------------------------------------------------------------------*
GMC_Check:
		jsr	A5ClearProTemps(a5)
		move.l	DTG_ChkData(a5),a0
		move.l	DTG_ChkSize(a5),d5
		cmp.l	#$400+444,d5		;min. Lnge 1Pattern + Vorblock
		blt.w	Check_Error
		cmp.l	#100,240(a0)		;Songlnge > 100
		bhi.w	Check_Error

		lea	(a0),a1
		moveq	#14,d4
		moveq	#0,d7
.GMC_ChkSam:	cmp.w	#2,12(A1)
		beq.s	.gmc_noloop
		move.l  (a1),d0
		move.l  8(a1),d1
		sub.l	d0,d1				;repeat
		blt.w	Check_Error
.GMC_NoLoop:	cmp.w	#$40,6(a1)			;Lautstrke
		bhi.w	Check_Error
		moveq	#0,d0
		move.w	4(a1),d0			;Samplelnge
		add.l	d0,d7
		add.l	d0,d7			;in D7 Lnge der Samples
		sub.w	12(a1),d0			;minus Repeatlnge
		blt.w	Check_Error
		lea	16(a1),a1
		dbf	d4,.GMC_ChkSam

		move.l	d7,Pro_Temp1+4(A5)

		lea	244(a0),a1
		move.l	240(a0),d0
		beq.w	Check_Error
		subq.w	#1,d0
		moveq	#0,d3
.GMC_Patts:	move.w	(a1)+,d1
		cmp.w	d3,d1
		ble.s	.GMC_Ok
		move.w	d1,d3
.GMC_Ok:	and.w	#$3ff,d1
		bne.w	Check_Error
		dbf	d0,.GMC_Patts

		cmp.w	#$400,d3
		blo.w	Check_Error
		move.l	d3,Pro_Temp1(A5)
		moveq	#0,d0
		rts


*--------------------------------------------------------------------------*
P4_Check:
		move.l	DTG_ChkData(a5),a0
		move.l	(a0),d0
		cmp.l	#`P40A`,d0
		beq.s	.P4_Yes
		cmp.l	#`P41A`,d0
		beq.s	.P4_Yes
		cmp.l	#`P40B`,d0
		bne	Check_Error
.P4_Yes:	moveq	#0,d0
		rts

*--------------------------------------------------------------------------*
Unic_Check:	move.l	DTG_ChkData(a5),a0
		cmp.l	#`MTN`<<8,$5b8(A0)
		beq.w	Check_Error

		move.l	$438(a0),d0
		cmp.l	#"UNIC",d0
		beq	.Okunic

		cmp.l	#`SNT.`,d0
		beq.w	Check_Error

		swap	d0
		cmp.w	#`WN`,d0
		beq	Check_Error

		lea	20+22(a0),a2
	
		moveq	#$1e,d3
		moveq	#0,d5
		moveq	#0,d6

.Loop:		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d4

		cmp.w	#8*6,-2(a2)		;Quant / Finetune ????
		bgt.w	Check_Error		;bei Bedarf entfernen
		cmp.w	#-8*6,-2(a2)		;Quant / Finetune ??
		blt.w	Check_Error		;bei Bedarf entfernen

		move.w	(a2),d1			;Lnge
		bne.s	.ok
		moveq	#1,d1
		bra.s	.unic_oo
.Ok:
		moveq	#1,d5
.unic_oo
		addq.w	#4,d1			;zur Sicherheit
		bgt.s	.ok1
		subq.w	#4,d1
.Ok1:		add.l	d1,d1

		move.w	4(a2),d2		;Repeatstart
		cmp.l	d2,d1
		blt.w	Check_Error

		move.w	6(a2),d4		;Repeatlnge
		add.l	d4,d4
		cmp.l	d4,d1
		blt.w	Check_Error

		add.l	d2,d4
		cmp.l	d4,d1
		blt.w	Check_Error

		tst.b	3(a2)
		beq.s	.noadd
		addq.w	#1,d6
.noadd
		cmp.b	#64,3(A2)
		bhi.w	Check_Error

		add.l	#30,a2
		dbf	d3,.Loop

		tst.w	d5
		beq	Check_error

		cmp.w	#$1f,d6
		beq	Check_error

		lea	$43c(a0),a2		;Soundtracker ausschlieen
		move.w	#64*4*4-1,d2
.CheckPatt2:	move.b	(a2),d0
		and.b	#$f0,d0
		cmp.b	#$10,d0
		bhi.s	.Nost

		move.w	(a2),d0
		and.w	#$fff,d0
		beq.s	.Wei
		lea	Pr_Periods(pc),a1
.Check:		move.w	(a1)+,d1
		beq.s	.Nost
		cmp.w	d0,d1
		bne.s	.Check
.Wei:		addq.l	#4,a2

		dbf	d2,.Checkpatt2	
		bra	Check_Error

.Nost:		lea	$43c(a0),a2
		move.w	#64*3*4-1,d0		;$300=Patternlnge
.Checkpatt:	move.b	(a2),d1
		lsr.b	#2,d1			;>>6 <<4
		and.b	#$f0,d1

		move.b	2(a2),d2
		lsr.b	#4,d2
		or.b	d2,d1
		cmp.b	#$1f,d1
		bhi.w	Check_Error

		addq.l	#3,a2
		dbf	d0,.CheckPatt

.OkUnic:	moveq	#0,d0
		rts



*--------------------------------------------------------------------------*
Unic2_Check:	move.l	DTG_ChkData(a5),a1
		cmp.l	#`MTN`<<8,$5b8(A1)
		beq.w	Check_Error
		move.l	$438(a1),d0
		cmp.l	#"M.K.",d0
		beq.w	Check_Error
		cmp.l	#"FLT4",d0
		beq.w	Check_Error
		cmp.l	#"FLT8",d0
		beq.w	Check_Error
		cmp.l	#"EXO4",d0
		beq.w	Check_Error
		cmp.l	#"UNIC",d0
		beq.w	Check_Error
		swap	d0
		cmp.w	#"WN",d0
		beq.w	Check_Error
		cmp.l	#"IT10",$5b8(a1)
		beq.w	Check_Error

		moveq	#0,d1
		move.l	DTG_ChkSize(a5),d0
		cmp.l	#$3a4,d0
		blo.w	Check_Error
		move.l	#$3a3-1,d0
.SizeOk:	move.l	a1,a0
.TestAufZero:	move.b	(a0)+,d2
		bne.s	.D0Ok
		addq.l	#1,d1
.D0Ok:		dbf	d0,.TestAufZero
		cmp.l	#$3a3,d1
		beq.w	Check_Error

		tst.b	$3a2(a1)		;Length testen
		beq.w	Check_Error

		lea	22(a1),a2
		moveq	#0,d6			;Anzahl der Samples
		moveq	#0,d5

		moveq	#$1e,d3
.Un2_Loop:	moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d4

		cmp.w	#8,-2(a2)		;Quant / Finetune ????
		bgt.w	Check_Error		;bei Bedarf entfernen
		cmp.w	#-8,-2(a2)		;Quant / Finetune ??
		blt.w	Check_Error		;bei Bedarf entfernen

		move.w	(a2),d1			;Lnge
		bne.s	.un2_ok
		moveq	#1,d1
		addq.l	#1,d6
.Un2_Ok:	addq.w	#4,d1			;zur Sicherheit
		bgt.s	.un2_ok1
		subq.w	#4,d1
.Un2_Ok1:	add.l	d1,d1

		move.w	4(a2),d2		;Repeatstart
		cmp.l	d2,d1
		blt.w	Check_Error

		move.w	6(a2),d4		;Repeatlnge
		add.l	d4,d4
		cmp.l	d4,d1
		blt.w	Check_Error

	;	add.l	d2,d4
	;	cmp.l	d4,d1
	;	blt.s	Check_Error

		tst.b	3(a2)
		bne.s	.NoZeroVol
		addq.l	#1,d5
.NoZeroVol:	cmp.b	#64,3(A2)
		bhi.w	Check_Error

		add.l	#30,a2
		dbf	d3,.un2_loop

		cmp.w	#$1f,d6
		beq.w	Check_Error
		cmp.w	#$1f,d5
		beq.w	Check_Error

		moveq	#0,d0
		rts




*-------------------- Check auf Propacker 1.0 Modul laden --------------------*
PP10_Check:	move.l	DTG_ChkData(a5),a0
		move.l	DTG_ChkSize(a5),d7

		move.l	a0,a1

		move.l	#$3c0,d3	Offset des 1. Samples
		cmp.l	d3,d7		wenigstens 960 Bytes Lnge ?
		blt	Check_Error	nein,gleich ohne Diskussion raus

		cmp.w	10(a1),d3	Offset des ersten Samples in Ordnung ?
		bne	Check_Error	Fehler,raus

		moveq	#30,d0		31 mgliche Samples
		moveq	#0,D1

		moveq	#0,d4	
		moveq	#0,d5		Lnge der Samples,die noch fehlen,falls Modul

	jsr	A5ClearProTemps(a5)

;				zu kurz

.PP10_Test1:	move.w	(a1),d1		Samplelnge
		beq.s	.PP10_NoSam
		move.w	4(a1),d2	Repeatstart
		cmp.w	d2,d1
		blo.w	Check_Error
		add.w	6(a1),d2	Repeatlnge
		cmp.w	d2,d1
		blo.w	Check_Error
		cmp.b	#64,3(a1)	Lautstrke
		bhi.w	Check_Error
		add.l	d1,d1
.PP10_NoSam:	cmp.l	8(a1),d3	Stimmt das Offset ?
		bne	Check_Error

		add.l	d1,d3
		add.l	d1,d4		Sampleslnge
		cmp.l	d3,d7		Offset kleiner als Modullnge ?
		bgt.s	.PP10_Ok	nein,in Ordnung

		move.l	d3,d6		erstmal Offset sichern
		sub.l	d7,d6		minus Lnge = Differenz

		cmp.l	d1,d6		Differenz grer Samplelnge ?
		bgt.s	.PP10_AddThis	ja,weiter

		move.l	d6,d1		nur die Lnge addieren,um die das Sample
	;				zu kurz ist

.PP10_addthis:	add.l	d1,d5		wenn Fehler,Lnge des Samples aufaddieren
					;am Ende in D5 Lnge aller fehlenden Samples
.PP10_ok:	addq.l	#8,a1
		addq.l	#6,a1
		dbf	d0,.PP10_Test1

		lea	(a0),a1		Moduladresse

		move.l	d4,Pro_Temp1+4(A5)
		bsr	.PP10_GetLen	Infos ermitteln,nebenbei Lnge rauskriegen
		blt.w	Check_Error	Fehler aufgetreten ?
		cmp.l	DTG_ChkSize(a5),d7	;Stimmmt Lnge ?
		blt.w	Check_Error
;		move.l	d7,pro_temp1+20(A5)
		moveq	#0,d0
		rts


.PP10_Getlen:	moveq	#0,d0
		move.w	$1b4(A1),d0		pm_SongLength(a1),d0
		lsr.w	#2,d0
	;	move.l	d0,20(a0)

		lea	$1c0(a1),a3		pm_PattPoses(a1),a3
		lea	pro_temp2+bssmerkpuffer,a2	dorthin Patternoffsets kopieren (BSS)
		moveq	#127,d0
		moveq	#0,d2

		move.l	#$7fffffff,d6		Zeiger auf das erste defekte Pattern
						;als Offset

		move.l	d6,d3		;grtmgliche Hexzahl (um kleinstes
;					;Pattern rauszukriegen)
.PP10_CopyPatts:move.l	(a3)+,d1
		cmp.l	d1,d7		Pattern unvollstndig ?
		bgt.s	.pp10_NoFehler

		cmp.l	d1,d6		defektes (unvollstndiges Pattern)
					;kleiner als letztes unvollstndig ge-
					;merktes Pattern ?
		blt.s	.PP10_NoFehler		nein,weiter
		move.l	d1,d6			erstes defektes Pattern
.PP10_NoFehler:	move.l	d1,(a2)+		Offset sichern

		cmp.l	d1,d2
		bgt.s	.PP10_Ok.1
		move.l	d1,d2			hchstes Pattern
.PP10_Ok.1:	cmp.l	d1,d3
		blt.s	.PP10_Ok2
		move.l	d1,d3			kleinstes Pattern
.PP10_Ok2:	dbf	d0,.PP10_CopyPatts ;in D2 hchstes Patternoffset
						;in D3 kleinstes    -""-

		cmp.l	d2,d7			hchstes Patternoffset ok ?
		ble.s	.PP10_Skip		keine Chance

		movem.l	d2/d3,-(sp)

		lea	(a1,d2.l),a3		hchstes Pattern durchleuchten,um
		moveq	#0,d1			Lnge desselben zu ermitteln
		moveq	#0,d2			(Playvoiceroutine simulieren)
		moveq	#0,d3
		moveq	#0,d4
		move.w	#64-1,d0
.PP10_scanpatt:	addq.w	#1,d1
		blt.s	.PP10_weit1
		addq.l	#4,a3
		move.w	(a3),d1
		bge.s	.PP10_weit1
		addq.l	#2,a3
.PP10_weit1:	addq.w	#1,d2
		blt.s	.PP10_weit2
		addq.l	#4,a3
		move.w	(a3),d2
		bge.s	.PP10_weit2
		addq.l	#2,a3
.PP10_weit2:	addq.w	#1,d3
		blt.s	.PP10_weit3
		addq.l	#4,a3
		move.w	(a3),d3
		bge.s	.PP10_weit3
		addq.l	#2,a3
.PP10_weit3:	addq.w	#1,d4
		blt.s	.PP10_weit4
		addq.l	#4,a3
		move.w	(a3),d4
		bge.s	.PP10_weit4
		addq.l	#2,a3
.PP10_weit4:	dbf	d0,.PP10_Scanpatt

		tst.w	d4
		bge.s	.pp10_okok
		subq.l	#2,a3
.PP10_okok:	movem.l	(Sp)+,d2/d3	;In A3 nun Zeiger auf Ende des Moduls

.PP10_skip:	cmp.l	#$7fffffff,d6	kein defektes Pattern ?
		beq.s	.PP10_allesklar	korrekt , weitermachen
	
		sub.l	d2,d6		erstes kaputtes Pattern - hchstes Pattern

		neg.l	d6		damit wieder positiv

		add.l	#1024,d6	was drauf (max. Lnge des zerstrten Patterns)
.PP10_dochfehler:add.l	#1024,d6	max. Lnge des hchsten Patterns
		add.l	d5,d6		Lnge der defekten Samples (siehe Checkroutine)
					;wieviel mehr gesaved werden muss

	*------------ Warning - Requester, zu wenig Samples -------------*
		moveq	#0,d7
		bra.w	Check_Error

.PP10_AllesKlar:moveq	#0,d6
		sub.l	a1,a3

	;	move.l	a3,52(a0)		;Gesamtlnge
		cmp.l	a3,d7			Gesamtlnge nochmal mit tatschlicher
		blt.s	.PP10_DochFehler	Lnge vergleichen

		move.l	d3,d2
		sub.l	#$3c0,d2		;Vorblock abziehen
		move.l	d2,d4			;Sampleslnge !!
		addq.l	#2,d4
		and.l	#$fffffffc,d4

		move.l	a3,d2
		sub.l	d3,d2
		add.l	#$3c0,d2		;Lnge des Vorblocks auf Songlnge add
		move.l	d2,pro_temp1+20(a5)
		;36(a0)

		lea	pro_temp2+bssmerkpuffer,a2	kopierte Patternoffsets
;					(damit sie verndert werden drfen)
		moveq	#128-1,d0
		moveq	#0,d2
.PP10_Numpatts:	move.l	(a2)+,d1
		beq.s	.pp10_next

		addq.w	#1,d2

		move.w	d0,d3
		move.l	a2,a3
.PP10_Loop2:	cmp.l	(a3),d1
		bne.s	.pp10_not
		clr.l	(a3)
.PP10_not:	addq.l	#4,a3
		dbf	d3,.PP10_loop2
.PP10_next:	dbf	d0,.PP10_numpatts
		move.l	d2,pro_temp1+bssmerkpuffer
		mulu	#1024,d2
		add.l	#$43c,d2
	move.l	pro_temp1+bssmerkpuffer+4,pro_temp1+bssmerkpuffer+8
		add.l	d2,pro_temp1+bssmerkpuffer+8	;ungepackte Lnge

		moveq	#14,d0
		rts

*-------------------------------------------------------------------------*
PP10_InitPlayer:
		jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

		move.l	pro_temp1+4(a5),d0	;Samplessize
		lea	Pro_InfoBuffer(pc),a4
		move.l	pro_temp1+20(a5),68(a4)	;Songsize fr Calcsize
		add.l	d0,68(a4)		;+ Samplesize = Calcsize
		move.l	pro_temp1+20(a5),52(a4)	;SongSize
		move.l	d0,60(a4)		;SampleSize

	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		move.l	pro_temp1(a5),d0		;Pattern laden
		addq.l	#1,d0
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a1			;Zieladresse



;	move.l	temp1+4(pc),d0
;	bsr	Allocextra
;	beq	.id_err
;	move.l	d0,a1

		move.l	Ori_Data(a5),a0
;		move.w	$1b4(a0),d2		;PM_Songlength
;		lsr.w	#2,d2
;		subq.w	#1,d2
		moveq	#127,d2

		lea	pro_temp2(a5),a3
		lea	$1c0(a0),a2		;PM_Pattposes
		move.l	#$7ffffff,d5
		moveq	#0,d1
		move.w	d2,d4
.PP10_LowestPatt:move.l	a2,-(sp)
		move.l	d5,d6
		move.w	d2,d3
.PP10_Lowestpatt2:cmp.l	(a2),d1
		bge.s	.PP10_nolow
		cmp.l	(a2),d6
		blt.s	.PP10_nolow
		move.l	(a2),d6
.PP10_NoLow:	addq.l	#4,a2
		dbf	d3,.PP10_LowestPatt2
		move.l	d6,(a3)+
		move.l	d6,d1

		move.l	(sp)+,a2
		dbf	d4,.PP10_LowestPatt

		lea	$1c0(a0),a3		;PM_Pattposes
		lea	$3b8(a1),a2
		moveq	#127,d0
.PP10_PattPoses:move.l	(a3)+,d1
		moveq	#-1,d2
		lea	pro_temp2(A5),a4
.PP10_Findpatt:	addq.b	#1,d2
		cmp.l	(a4)+,d1
		bne.s	.PP10_FindPatt

		move.b	d2,(a2)+

		dbf	d0,.PP10_PattPoses

		move.w	$1b4(a0),d0
		lsr.w	#2,d0
		move.b	d0,$3b6(a1)
	;	move.l	#"M.K.",$438(a1)

		lea	$2a(a1),a2
		lea	(a0),a3

		moveq	#30,d0
.PP10_SamInf:	move.w	(a3)+,(a2)+
		moveq	#0,d1
		move.w	12-2(a3),d1
		divu	#72,d1
		move.b	d1,(a2)+
		addq.l	#1,a3
		move.b	(a3)+,(a2)+
		move.l	(a3)+,(a2)+

		addq.l	#14-8,a3
		add.w	#$1e-8,a2
		dbf	d0,.PP10_SamInf


		lea	$43c(a1),a2
		lea	pro_temp2(A5),a4		;Temp2
		lea	PR_Periods(pc),a6
		move.l	pro_temp1(A5),d6		;Temp1
		subq.w	#1,d6
.PP10_DoPatts:	move.l	(a4)+,d2
		lea	(a0,d2.l),a3		hchstes Pattern durchleuchten,um
		moveq	#0,d1			Lnge desselben zu ermitteln
		moveq	#0,d2			(Playvoiceroutine simulieren)
		moveq	#0,d3
		moveq	#0,d4
		move.w	#64-1,d0
.PP10_scanpatt2:addq.w	#1,d1
		blt.s	.PP10_weit12

		bsr.w	.PP10_dovoice
		addq.l	#4,a3
		move.w	(a3),d1
		bge.s	.PP10_weit122
		addq.l	#2,a3
		bra.s	.PP10_weit122
.PP10_weit12:	move.l	-16(a2),(a2)+
.PP10_weit122:	addq.w	#1,d2
		blt.s	.PP10_weit22
		bsr.w	.PP10_dovoice
		addq.l	#4,a3
		move.w	(a3),d2
		bge.s	.PP10_weit222
		addq.l	#2,a3
		bra.s	.PP10_weit222
.PP10_weit22:	move.l	-16(a2),(a2)+
.PP10_weit222	addq.w	#1,d3
		blt.s	.PP10_weit32

		bsr.s	.PP10_dovoice
		addq.l	#4,a3

		move.w	(a3),d3
		bge.s	.PP10_weit322
		addq.l	#2,a3
		bra.s	.PP10_weit322
.PP10_weit32:	move.l	-16(a2),(a2)+
.PP10_weit322:	addq.w	#1,d4
		blt.s	.PP10_weit42

		bsr.s	.PP10_DoVoice
		addq.l	#4,a3
		move.w	(a3),d4
		bge.s	.PP10_weit422
		addq.l	#2,a3
		bra.s	.PP10_weit422
.PP10_weit42:	move.l	-16(a2),(a2)+
.PP10_weit422:	dbf	d0,.PP10_scanpatt2
		dbf	d6,.PP10_dopatts

		lea	$3c0(a0),a3
		move.l	a3,SamplePointer(a5)

	*--------- Zum ProTracker-InitPlayer hpfen --------*
		moveq	#1,d1			;convertiertes Module geladen
		bra.w	ProT_PackInd

;		move.l	pro_temp2+bssmerkpuffer,d0		;Temp

	*----------- ProPacker 1.0 Hilfsroutine ------------*
.PP10_DoVoice:	clr.l	(a2)

;		move.b	(a3),d5
;		beq.s	.PP10_Comm

		moveq	#0,d5
		move.b	1(a3),d5
		beq.s	.pp10_nonote
		move.w	-2(A6,d5.w),d5
		move.w	d5,(a2)
.pp10_nonote
		move.b	(a3),d5
		beq.s	.PP10_Comm
		and.b	#$f,d5
		lsl.b	#4,d5
		move.b	d5,2(a2)
		move.b	(a3),d5
		and.b	#$f0,d5
		or.b	d5,(A2)
.PP10_Comm:	move.b	2(a3),d5
		and.b	#$f,d5
		or.b	d5,2(a2)
		move.b	3(a3),3(A2)	
		addq.l	#4,a2
		rts




*-------------------------- NoiseRunner-Check ------------------------------*
NR_Check:	move.l	DTG_ChkData(a5),a0
		cmp.l	#"M.K.",$438(A0)
		bne.w	Check_Error

		move.l	a0,a2			;Sampleoffset = 0
		moveq	#$1e,d3			;31 Samples
		moveq	#0,d6
		moveq	#0,d5
.NR_Loop:	tst.b	1(a2)
		bne.s	.VolNotZero
		addq.l	#1,d5
.VolNotZero:	cmp.b	#64,1(a2)		;Lautstrke > 64 ??
		bhi.w	Check_Error
		move.w	6(a2),d1		;Samplelnge
		bne.s	.NR_Ok
		addq.l	#1,d6
		moveq	#1,d1
.NR_Ok:		cmp.w	12(a2),d1		;Repeatlnge grer Samplelnge
		blt.w	Check_Error
		move.l	2(a2),d1
		cmp.l	8(a2),d1		;Repeatbeginn grer Samplestart ?
		bhi.w	Check_Error

		addq.l	#8,a2			;nchstes Sample
		addq.l	#8,a2
		dbf	d3,.NR_Loop
		cmp.w	#$1f,d6
		beq.w	Check_Error
		cmp.w	#$1f,d5
		beq.w	Check_Error
		moveq	#0,d0
		rts



*-------------- Allociert einen Speicherbereich fr ST-Patches --------------*
*----- Input:	d0=Anzahl der Pattern (im Protrackerformat)		-----*
*----- OutPut:	d0=Fehlernummer						-----*
*-----		d1=Adresse des Speicherbereiches			-----*
*-----		d2=Size des Speicherbereiches				-----*
*----------------------------------------------------------------------------*
AllocExtraST:	movem.l	d3-a6,-(a7)
		moveq	#EPR_NotEnoughMem,d7
		moveq	#0,d2
		move.l	PufferAdr2,a5
		tst.l	d0
		beq.s	.IstDa
		move.l	d0,d1
		move.l	STExtraMem(a5),d0
		bne.s	.IstDa
		move.l	4.w,a6
		and.l	#$ffff,d1
		mulu	#1024,d1
		add.l	#1048+MemDrauf,d1
		move.l	d1,d0
		move.l	d1,d6
		move.l	#$10001,d1
		jsr	_LVOAllocMem(a6)
.IstDa:		move.l	d0,STExtraMem(a5)
		beq.s	.Ok
		moveq	#0,d7				;Kein Fehler
		move.l	d6,ConvertedSize(a5)
		move.l	d6,d2				;MemSize
.Ok:		move.l	d0,d1				;Speicheradresse
		move.l	d7,d0				;Error nach d0
		movem.l	(a7)+,d3-a6
		tst.l	d0
		rts

**----------------------------------------------------------------------------*
;*------------- Nur hinspringen, wenn DTG_ChkData<>TextPuffer ist ------------*
;*-- ---> nur bei EP_Check5 !!!!! --------------------------------------------*
;Pro_Fast_Check:	move.l	4.w,a6
;		move.l	DTG_ChkData(a5),a1
;		jsr	_LVOTypeOfMem(a6)
;		btst	#1,d0
;		bne.w	Check_Error
;
;	*------------- Das Module liegt also nicht im ChipRam ---------------*
;		bsr	Pro_Check
;		tst.l	d0
;		bne	Check_Error
;
;		move.l	DTG_ChkData(a5),a0
;		lea	$3b8(A0),a1
;		moveq	#$7f-1,d0
;		moveq	#0,d3
;.BigPatt:	cmp.b	(A1)+,d3
;		bgt.s	.Ok
;		move.b	-1(A1),d3
;.Ok		dbf	d0,.BigPatt
;		mulu	#1024,d3
;		add.l	#$43c,d3
;
;		lea	42(a0),a0
;		moveq	#30,d0
;		moveq	#0,d5
;.BigSam:	moveq	#0,d4
;		move.w	(a0),d4
;		add.l	d4,d4
;		add.l	d4,d3		;gesamte Samplelnge
;
;		cmp.l	d4,d5
;		bgt.s	.hi
;		move.l	d4,d5
;.Hi:		lea	30(a0),a0
;		dbf	d0,.BigSam
;
;		add.l	#2000,d5	;2 KBytes zur Sicherheit (SpeedUp)
;		add.l	d5,d5		;4 mal die Lnge des lngsten
;		add.l	d5,d5		;Samples
;
;
;		cmp.l	d3,d5
;		bgt.w	Check_Error
;		moveq	#0,d0
;		rts

*--------------------------------------------------------------------------*
Pro_Check:
;		lea	mod,a0
		move.l	DTG_ChkData(a5),a0
		move.l	$438(a0),d0
		
		cmp.l	#"M!K!",d0		;M.K. da ?
		beq.s	.pro_checkwei
		cmp.l	#"M&K!",d0		;M.K. da ?
		beq.s	.pro_checkwei
		cmp.l	#"M.K.",d0		;M.K. da ?
		bne.w	Check_Error		;n,Fehler
.pro_checkwei
		moveq	#-1,d0
		lea	$3B8(a0),a1		;Berechne Gre des Songs

		moveq	#$80-1,d3
		moveq	#0,d1
		moveq	#0,d2

.Pro_Check3:	move.b	(a1)+,d1
		cmp.b	d1,d2
		bgt.s	.Pro_Check2
		move.b	d1,d2
.Pro_Check2:	dbf	d3,.Pro_Check3

		addq.b	#1,d2
		asl.l	#8,d2
		move	d2,d3
		asl.l	#2,d3
		add.l	#$43C,d3

	move.l	DTG_ChkSize(a5),d1
	cmp.l	DTG_ChkSize(a5),d3	;ist geladenes File grer als der Song
					;allein ??
	bhi.w	Check_Error		;nein,Fehler

		lea	$43c(a0),a1
		moveq	#0,d3
		moveq	#0,d4
;		move.w	#64*4,d2
		subq	#1,d2
.Testfirstpatt:	move.w	(a1)+,d1
		and.w	#$fff,d1
		beq.s	.wei
		lea	ProPC_Periods,a2	;Periodentabelle
		addq	#1,d3			;Num Notes
.lop2		move.w	(a2)+,d0
		beq.s	.wei
		cmp.w	d1,d0
		bne.s	.lop2
		addq	#1,d4		;Num Valid
.wei:
		addq.l	#2,a1
		dbf	d2,.testfirstpatt
		tst	d3
		beq.s	Pro_CheckRet

		moveq	#-1,d0
		mulu	#100,d4
		divu	d3,d4
		cmp	#40,d4			;40% aller Noten mssen korrekt
						;sein !!!
		blo.s	Pro_CheckRet
		bra.s	checkvolsnlengths
Pro_CheckRet:	rts


Checkvolsnlengths:
		lea	42(A0),a2		;Zeiger auf 1. Samplelnge
		moveq	#$1e,d3
.loop:		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d4

		move.w	(a2),d1			;Lnge
		beq.s	.next
		addq.w	#8,d1			;zur Sicherheit
		bhi.s	.ok1
		subq.w	#8,d1
.ok1:		add.l	d1,d1

		move.w	4(a2),d2		;Repeatstart
		cmp.l	d2,d1
		blo.s	Check_Error

		move.w	6(a2),d4		;Repeatlnge
		cmp.w	#-1,d4
		beq.s	.TestVol
		cmp.l	d4,d1
		beq.s	.TestVol
		add.l	d4,d4
		cmp.l	d4,d1
		blo.s	Check_Error

	;	add.l	d2,d4
	;	cmp.l	d4,d1
	;	blo.s	Check_Error

.TestVol:	cmp.b	#64,3(A2)
		bhi.s	Check_Error

		move.b	2(A2),d1
		and.b	#$f0,d1
		cmp.b	#$80,d1
		beq	Check_Error
.next
		add.l	#30,a2
		dbf	d3,.loop

Pro_Check2:	moveq	#0,d0
		rts

Check_Error:	moveq	#-1,d0
		rts
*----------------------------------------------------------------------------*
Pro_ExtLoad:	clr.w	MT_LInstrKennung(a5)	;Wurden Instrumente geladen
		move.l	DTG_ChkData(a5),a0
		move.l	a0,a1	
		lea	$3B8(a0),a0		;Berechne Gre des Songs
		moveq	#$7F,d3
		moveq	#0,d1
.Pro_check2:	move.l	d1,d2
		subq.w	#1,d3
.Pro_check3:	move.b	(a0)+,d1
		cmp.b	d2,d1
		bgt.s	.Pro_check2
		dbra	d3,.Pro_check3
		addq.b	#1,d2
		asl.l	#8,d2
		asl.l	#2,d2
		add.l	#$43C,d2		;SongSize in d2
		cmp.l	DTG_ChkSize(A5),d2	;ist geladenes File grer als
						;der Song allein ??
		bne.w	LoadNoSamplesLoad	;nein,Fehler

	*----- Testen, ob die einzelnen Samples -----*
		moveq	#0,d0
		move.l	DTG_ChkData(a5),a2
		lea	$14(a2),a2		;Offset zur SampleTable
		moveq	#31,d7
.TestSample:	tst.b	(a2)
		beq.s	.NoSample
		move.w	22(a2),d1
		beq.s	.NoSample		;Testen ob hier ein Sample ist
		addq.l	#1,d0
.NoSample:	lea	30(a2),a2
		dbf	d7,.TestSample
		tst.l	d0
		beq.w	LoadNoSamplesLoad

	*----- Nun die einzelnen Intrumente laden -----*
		LA0	Lnr_LoadingInstruments
		jsr	A5PrintText(a5)
		moveq	#31-1,d7		;SampleAnz

LoadTrackerSamples:
		move.l	DTG_ChkData(a5),a2
		lea	$14(a2),a2		;Offset zur SampleTable

	*---- Schleife zum Laden der Instrumente ------*
.NextSample:
		move.w	22(a2),d0
		beq.w	.Next			;Testen ob hier ein Sample ist

		tst.b	(a2)
		beq.w	.Next			;kein Name->weiter

		move.w	(a2),d0
		and.w	#$dfdf,d0		;gro/kleinschreibung
		cmp.w	#`ST`,d0
		bne.s	.take
		cmp.b	#`-`,2(a2)
		bne.s	.take
		cmp.b	#`:`,5(a2)
		bne.s	.take
		tst.b	6(a2)
		beq.w	.next

		move.l	DTG_PathArrayPtr(a5),a0	;Sample im voreingestellten
		clr.b	(a0)			;Instruments-Dir suchen 
		lea	InstrDir(a5),a0
		move.l	LoadFilePath(a5),-(a7)
		move.l	a0,LoadFilePath(a5)
		move.l	a2,-(a7)
		lea	6(a2),a2		;"ST-00:" berspringen
		jsr	CreateLoadPath
		move.l	DTG_LoadFile(a5),a0
		jsr	(a0)
		move.l	(a7)+,a2
		move.l	(a7)+,LoadFilePath(a5)
		tst.l	d0
		beq.w	.next			;ok, nchstes Sample laden


		move.l	DTG_PathArrayPtr(a5),a0	;Sample in "ST-xx:" suchen
		clr.b	(a0)
		move.l	a2,a0
		jsr	ENPP_CopyString(a5)
		move.l	DTG_LoadFile(a5),a0
		jsr	(a0)
		tst.l	d0
		beq.w	.next
.take
	*----- Sample nochmal im angegebenen Pfad suchen -----*
*---------------------------------------------------------------------------*
*------------------------- 	Pfad aufbauen	----------------------------*
*----- Input:	LoadFilePath=Diradresse, ungleich Pathpuffer		----*
*-----		a2=Filename						----*
*----- Output:	Pathpuffer=creierter Path				----*
*---------------------------------------------------------------------------*
		move.l	DTG_PathArrayPtr(a5),a0
		clr.b	(a0)
		lea	InstrDir(a5),a0
		move.l	LoadFilePath(a5),-(a7)
		move.l	a0,LoadFilePath(a5)
		move.l	a2,-(a7)
		jsr	A5CreateLoadPath(a5)
		move.l	DTG_LoadFile(a5),a0
		jsr	(a0)
		move.l	(a7)+,a2
		move.l	(a7)+,LoadFilePath(a5)
		tst.l	d0
		beq.w	.next

		movem.l	d1-a6,-(sp)

		LA0	LNr_TR_ErrorLoadingInstruments
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_RetrySkipCancel
		move.l	a0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		lea	ScrollArgs(a5),a0
		move.l	a2,(a0)
		move.l	a0,EPG_Arg6(a5)
		clr.l	EPG_Arg8(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		jsr	A5TextRequest(a5)

*		lea	LoadInsterr(pc),a0
*		move.l	a0,EPG_Arg1(a5)			;Textadr nach Arg1
*		lea	LoadInsterrG(pc),a0
*		move.l	a0,EPG_Arg4(a5)			;Gadgets
*		clr.l	EPG_Arg5(a5)			;Requestername
*		lea	Argadr(pc),a0
*		move.l	a2,(A0)
*		move.l	a0,EPG_Arg6(a5)			;Adr Samplename
*
*		moveq	#7,d0
*		move.l	d0,EPG_Argn(a5)
*		moveq	#-1,d0
*		move.l	d0,EPG_Arg3(a5)			;Position
*		clr.l	EPG_Arg7(a5)
*		lea	PubScreenName(a5),a0
*		move.l	a0,EPG_Arg2(a5)			;PubScreen
*		clr.l	EPG_Arg8(a5)
*		jsr	A5TextRequest(a5)

		movem.l	(sp)+,d1-a6

		move.l	epg_arg1(a5),d0
		subq.l	#1,d0
		beq.w	.NextSample			;Retry
		subq.l	#1,d0
		beq.s	.skipsample
		bra	Pro_LoadError
.skipsample
		move.l	#`Samp`,(A2)
		move.l	#`le w`,4(A2)
		move.l	#`as n`,8(A2)
		move.l	#`ot f`,12(A2)
		move.l	#`ound`,16(A2)
		move.w	#` !`,20(A2)
		clr.l	22(A2)			;Sample killen
		clr.l	22+4(A2)		;hehe !

.Next:		lea	30(a2),a2
		dbf	d7,.NextSample
		move.w	#1,MT_LInstrKennung(a5)
LoadNoSamplesLoad:moveq	#0,d0
		rts

Pro_LoadError:	moveq	#EPR_ErrorLoadingInstruments,d0
		rts

*--------------------------------------------------------------------------*
Pro_UserConfig:	moveq	#0,d2
SetInstrumentsDir:
		LA0	LNr_SW_InstrumentDir
		jsr	A5PrintText(a5)

		tst.l	d2
		beq.s	.FileRequest
		move.l	a2,a1
		move.l	d2,d3
		subq.l	#1,d3
		lea	InstrDir(a5),a0		;A0=Wohin mit Players.
		jsr	A5CreateDirAusPath(a5)	;A1=Path d3=Lnge
		bra.s	.Ok


	;**** a0 = FileRequester-Title		    ****
	;**** a1 = Directorypath		    ****
	;**** a2 = Filename	 		    ****
	;**** a3 = Window	 		    ****
	;**** d0 = 1  SelectDir			    ****
	;****	   0  SelectFile		    ****
.FileRequest:	LA0	LNr_Fr_InstrumentDir		;TitleName
		lea	InstrDir(a5),a1			;Dir-Ptr
		sub.l	a2,a2				;Keine Filename
		*jsr	A5GetPlWindowHandle(a5)
		*bne.s	.NoMain
		jsr	A5GetMainWindowHandle(a5)
.NoMain:	move.l	d0,a3				;WinHandle --> a3
		moveq	#1,d0				;Kennung Dir laden
		jsr	A5FileRequest2(a5)
.Ok:		moveq	#0,d0
		rts

*----------------------------------------------------------------------------*
Pro_SetTimer:	move.w	Pro_Tempo(pc),d0
Pro_SetzeTimer:	cmp.w	#$20,d0
		bcc.s	Pro_ErrPara
		moveq	#$20,d0
Pro_ErrPara:	movem.l	d0-a6,-(a7)
		lea	Pro_Tempo(pc),a4
		move.w	d0,(a4)

		move.l	PufferAdr2,a5
		move.l	dtg_GfxBase(a5),a1
		btst	#2,$cf(a1)			Test auf Pal/NTSC Maschine
		bne.s	.pal
		move.l	#1789773,d2			CIA Clock fr NTSC
		bra.s	.div
.pal:		move.l	#1773447,d2			Tempo clock fr PAL
.div:		divu	d0,d2

	;	add.w	MT_Speed(pc),d2
		cmp.w	#$700,d2
		bhi.s	.wei
		move.w	#$700,d2
.wei:
;	tst.w	MT_TimerOn
;	beq.s	.ret
;	lea	$bfd000,a4
;	move.b	d2,$400(a4)
;	lsr.w	#8,d2
;	move.b	d2,$500(a4)
;.ret
		move.w	d2,DTG_Timer(a5)
		jsr	A5SetTimer(a5)
		movem.l	(a7)+,d0-a6
Pro_CReturn:	rts
*---------------------------------------------------------------------------*
P4_ExtLoad:	move.l	DTG_PathArrayPtr(a5),a0
		clr.b	(a0)			; clear Path
		move.l	DTG_CopyDir(a5),a0	; copy dir into patharray
		jsr	(a0)

		lea	SMP_Name(pc),a0	; join '.NT'
		move.l	DTG_CopyString(a5),a1
		jsr	(a1)

		move.l	DTG_FileArrayPtr(a5),a0
		moveq	#31,d0
.FindIt:	cmp.b	#".",(a0)+
		beq.s	.Found
		dbf	d0,.FindIt

		move.l	DTG_FileArrayPtr(a5),a0

.Found:		jsr	ENPP_CopyString(a5)
		jsr	ENPP_CutSuffix(a5)
		jsr	ENPP_LoadFile(a5)

		moveq	#0,d0
		rts

*---------------------------------------------------------------------------*
P56_SavePT
	move.l	P56_Samplesize(pc),d0
	beq.s	.fail
	move.l	pro_infobuffer+60(pc),-(sp)
	move.l	d0,pro_infobuffer+60
	
	bsr	Pro_Save

	move.l	(sp)+,pro_infobuffer+60
.fail
	moveq	#-1,d0
	rts

P56_Save
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,a1
	cmp.w	#`0A`,2(a1)
	bne.s	.no
	addq.l	#4,a1
.no	
	moveq	#0,d1
	move.w	(a1),d1
	cmp.l	d1,d0				;FileSizeNeu = Songsize ?
	beq.s	.ext				;2. File

	add.l	P56_orisamsize(pc),d1

	move.l	a0,EPG_Arg1(a5)			;adr
	move.l	d1,EPG_Arg2(a5)			;len

	move.l	DTG_PathArrayPtr(a5),EPG_Arg3(a5)
	moveq	#-1,d0
	move.l	d0,EPG_Arg4(a5)
	clr.l	EPG_Arg5(a5)
	moveq	#5,d0
	move.l	d0,EPG_Argn(a5)
	jmp	A5SaveMem(a5)
.ext
	move.l	a0,EPG_Arg1(a5)			;adr
	move.l	d1,EPG_Arg2(a5)			;len

	move.l	DTG_PathArrayPtr(a5),EPG_Arg3(a5)
	moveq	#-1,d0
	move.l	d0,EPG_Arg4(a5)
	clr.l	EPG_Arg5(a5)
	moveq	#5,d0
	move.l	d0,EPG_Argn(a5)
	jsr	A5SaveMem(a5)			;1. File saven

		move.l	DTG_PathArrayPtr(a5),a0
		clr.b	(a0)			; clear Path
		move.l	DTG_CopyDir(a5),a0	; copy dir into patharray
		jsr	(a0)

	lea	SMP_Name(pc),a0	; join '.NT'
	move.l	DTG_CopyString(a5),a1
	jsr	(a1)

	move.l	DTG_FileArrayPtr(a5),a0
	moveq	#31,d0
.FindIt:
	cmp.b	#".",(a0)+
	beq.s	.Found
	dbf	d0,.FindIt

	move.l	DTG_FileArrayPtr(a5),a0

.Found:
	jsr	ENPP_CopyString(a5)

	moveq	#1,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,EPG_Arg1(a5)			;adr
	move.l	P56_orisamsize(pc),EPG_Arg2(a5)	;len

	move.l	DTG_PathArrayPtr(a5),EPG_Arg3(a5) 	;path
	moveq	#-1,d0
	move.l	d0,EPG_Arg4(a5)
	clr.l	EPG_Arg5(a5)
	moveq	#5,d0
	move.l	d0,EPG_Argn(a5)
	jsr	A5SaveMem(a5)			;1. File saven
	rts
*---------------------------------------------------------------------------*
P56_ExtLoad:
	move.l	dtg_chkdata(a5),a0
	move.l	dtg_chksize(a5),d0
	cmp.w	#`0A`,2(a0)			;<- von P50A / P60A / P61A
	bne.s	.lo
	addq.l	#4,a0
.lo
	moveq	#0,d1
	move.w	(a0),d1
	cmp.l	d1,d0				;FileSizeNeu = Songsize ?
	beq.s	.ext
	moveq	#0,d0				;n->kein Extload
	rts
.ext
		move.l	DTG_PathArrayPtr(a5),a0
		clr.b	(a0)			; clear Path
		move.l	DTG_CopyDir(a5),a0	; copy dir into patharray
		jsr	(a0)

		lea	SMP_Name(pc),a0	; join '.SMP'
		move.l	DTG_CopyString(a5),a1
		jsr	(a1)

		move.l	DTG_FileArrayPtr(a5),a0
		moveq	#31,d0
.FindIt:	cmp.b	#".",(a0)+
		beq.s	.Found
		dbf	d0,.FindIt

		move.l	DTG_FileArrayPtr(a5),a0

.Found:		jsr	ENPP_CopyString(a5)
		jsr	ENPP_CutSuffix(a5)

		move.l	#1,EPG_ArgN(a5)
		move.l	#$10000,EPG_Arg1(a5)
		move.l	EPG_NewLoadFile(a5),a0
		jmp	(a0)			; returncode is already set !
*-----------------------------------------------------------------------------*
PP21_InitPlayer:jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)


	*----- Erstmal in aller Ruhe die Patternanzahl berechnen -----*
		move.l	Unic_Temp(a5),a3
		lea	4(a3),a2	;Zeiger auf 1.Note
		add.l	(a3)+,a3	;Zeiger auf 1.Sample

		move.l	a3,SamplePointer(a5)

		lea	Pro_InfoBuffer(pc),a4
		move.l	a3,52(a4)	;Songsize setzen
		move.l	a0,d0
		sub.l	d0,52(a4)
	;	move.l	a3,-(Sp)	;sichern fr Spter
		move.l	a2,-(Sp)	;sichern fr Spter


				;Umbauroutine,sucht fr die entsprechenden
				;Songpositionen raus,wo die Kombination der
				;Patternstreifen zum ersten Mal bereinstimmt

		lea	pro_temp1(a5),a2		;Temp1
		move.l	a2,a1
		moveq	#256>>2-1,d0
.pp21_clrtemp:	clr.l	(a1)+
		dbf	d0,.pp21_clrtemp

		lea	$fa(a0),a1		;1. Pattlist $80 Bytes lang
		lea	$fa+$080(a0),a3		;2. Pattlist
		lea	$fa+$100(a0),a4		;3. Pattlist
		lea	$fa+$180(a0),a6		;4. Pattlist

		moveq	#0,d0
		move.b	$f8(A0),d0		;Lnge des Modules in Patterns
		subq.w	#1,d0

		moveq	#0,d1			;aktuelle Songpos
		move.w	d0,d2			;fr spter sichern
.numpatts1:	moveq	#0,d3
.dotest:	move.b	(a1,d1.w),d4
		cmp.b	(a1,d3.w),d4
		bne.s	.testno
		move.b	(a3,d1.w),d4
		cmp.b	(a3,d3.w),d4
		bne.s	.testno
		move.b	(a4,d1.w),d4
		cmp.b	(a4,d3.w),d4
		bne.s	.testno
		move.b	(a6,d1.w),d4
		cmp.b	(a6,d3.w),d4
		bne.s	.testno
		move.w	d3,d5
		bra.s	.testrts
.testno:	addq.w	#1,d3
		cmp.w	d1,d3
		ble.s	.dotest
		move.w	d1,d5
.testrts:	move.b	d5,(a2)+
		add.w	#1,d1
		dbf	d0,.numpatts1

		lea	pro_temp2+bssmerkpuffer,a4	;Zieladresse (Temp2)
		lea	pro_temp1+bssmerkpuffer,a2		;Temp1
		move.w	d2,d3
.PP21_copy:	move.b	(a2)+,(a4)+
		dbf	d3,.pp21_copy

		lea	pro_temp2+bssmerkpuffer,a2	;Zieladresse, bearbeiten, damit Patternnummern
					;hinterher Stimmen

		moveq	#0,d0		;aktuelle Patternnummer (als ST)

		moveq	#0,d1
		move.w	d2,d3
.uebertrage:	lea	(a2),a3
				;jeweils kleinste Patternnummer suchen,D0
		move.w	d3,d4		;gibt an, welche Nummern schon bearbeitet sind
		moveq	#$7f,d1		;z.B. im ersten Durchlauf ist D0 = 0
.pp21_calc				;d.h. im 2. Durchlauf ist dann D0 = 1 und
		cmp.b	(a3),d1		;somit ist die kleinste erlaubte Patternnummer
		ble.s	.pp21_notthis	;1 !
		cmp.b	(a3),d0
		bgt.s	.pp21_notthis
		move.b	(a3),d1
.pp21_notthis:	addq.l	#1,a3
		dbf	d4,.pp21_calc


		lea	(a2),a3		;ersetzt die jeweils kleinste Patternnummer,
		move.w	d3,d4		;die vorkommt durch den richtigen Wert, da
.pp21_calc2				;die vorkommende Nummer sonstwiehoch sein kann
		cmp.b	(a3)+,d1	;(das enstprechende Pattern kann theoretisch
		bne.s	.pp21_wei	;an einer tierisch weit entfernten Pos stehen)
		move.b	d0,-1(A3)
.pp21_wei:	dbf	d4,.pp21_calc2	

		addq.w	#1,d0
		dbf	d2,.uebertrage

		lea	pro_temp1+bssmerkpuffer,a2	;Sourceadr	(Temp1)
		move.w	d3,d4		;fr Spter
		move.w	d3,d0
		moveq	#0,d2
.pp21_cleardoub:move.b	(a2)+,d1
		blt.s	.pp21_next

		addq.w	#1,d2

		move.w	d0,d3
		move.l	a2,a3
.pp21_loop2:	cmp.b	(a3)+,d1
		bne.s	.pp21_not
		move.b	#-1,-1(a3)
.pp21_not:	dbf	d3,.pp21_loop2

.pp21_next:	dbf	d0,.pp21_cleardoub
				;in D2 Anzahl der Patterns,so nebenbei mit
				;berechnet

		
	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		moveq	#0,d0
		move.w	d2,d0
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	.PP21_Error
		move.l	d1,a1
	
		move.l	(sp)+,A2	;Zeiger auf 1.Note
		move.l	a5,-(sp)

		lea	pro_temp2(A5),a4		;Temp2
		lea	$3b8(a1),a6
		move.w	d4,d0
.pp21_positions:move.b	(a4)+,(a6)+
		dbf	d0,.pp21_positions

		lea	pro_temp1(a5),a4	;Welche Patterns rbergeholt werden mssen
		lea	pro_temp2(A5),a6 ;was als Soundtracker rauskommt
.dopatts:	moveq	#0,d2
		move.b	(A4)+,d2
		blt.s	.pp21_donethis
		moveq	#0,d5
		move.b	(A6),d5
		lea	$43c(a1),a5
		lsl.l	#8,d5	
		lsl.l	#2,d5
		add.l	d5,a5

		lea	$fa(a0),a3
		moveq	#0,d0
		move.b	(a3,d2.w),d0
		bsr	.pp21_dostripe

		lea	4(a5),a5
		lea	$fa+$080(a0),a3
		moveq	#0,d0
		move.b	(a3,d2.w),d0
		bsr	.pp21_dostripe

		lea	4(a5),a5
		lea	$fa+$100(a0),a3
		moveq	#0,d0
		move.b	(a3,d2.w),d0
		bsr	.pp21_dostripe

		lea	4(a5),a5
		lea	$fa+$180(a0),a3
		moveq	#0,d0
		move.b	(a3,d2.w),d0
		bsr	.pp21_dostripe

.PP21_DoneThis:	addq.l	#1,a6
		dbf	d4,.DoPatts

		move.l	(sp)+,a5

		lea	(a0),a3		;Sampleinfostrukturen wiederherstellen
		move.w	$f8(a0),$3b6(a1);Songlnge,Restart kopieren
	;	move.l	#`M.K.`,$438(a1)
		lea	$2a(a1),a2
		moveq	#31-1,d0
.PP21_Sam:	move.l	(A3)+,(a2)
		move.l	(A3)+,4(a2)
		lea	$1e(a2),a2
		dbf	d0,.pp21_sam


	*--------- Zum ProTracker-InitPlayer hpfen --------*
		moveq	#1,d1			;convertiertes Module geladen
		bra.w	ProT_PackInd



.PP21_DoStripe:	lea	$2fa(a0),a3
		lsl.w	#7,d0
		lea	(a3,d0.w),a3
		moveq	#63,d0
		move.l	a6,-(sp)
		lea	(A5),a6
.pp21_doit:	move.w	(a3)+,d1
		add.w	d1,d1
		add.w	d1,d1
		move.l	(a2,d1.w),(a6)
		lea	16(a6),a6
		dbf	d0,.pp21_doit
		move.l	(sp)+,a6
		rts

.PP21_Error:	addq.l	#4,a7			;a2 vom Stack holen
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
PP30_InitPlayer:jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

	*----- Erstmal in aller Ruhe die Patternanzahl berechnen -----*
		move.l	Unic_Temp(a5),a3
		lea	4(a3),a2	;Zeiger auf 1.Note
		add.l	(a3)+,a3	;Zeiger auf 1.Sample

		move.l	a3,SamplePointer(a5)
		lea	Pro_InfoBuffer(pc),a4
		move.l	a3,52(a4)	;Songsize setzen
		move.l	a0,d0
		sub.l	d0,52(a4)
	;	move.l	a3,-(Sp)	;sichern fr Spter
		move.l	a2,-(Sp)	;sichern fr Spter


				;Umbauroutine,sucht fr die entsprechenden
				;Songpositionen raus,wo die Kombination der
				;Patternstreifen zum ersten Mal bereinstimmt

		lea	pro_temp1(A5),a2
		lea	(a2),a1
		moveq	#256>>2-1,d0
.PP30_clrtemp:	clr.l	(a1)+
		dbf	d0,.PP30_clrtemp

		lea	$fa(a0),a1		;1. Pattlist $80 Bytes lang
		lea	$fa+$080(a0),a3		;2. Pattlist
		lea	$fa+$100(a0),a4		;3. Pattlist
		lea	$fa+$180(a0),a6		;4. Pattlist

		moveq	#0,d0
		move.b	$f8(A0),d0		;Lnge des Modules in Patterns
		subq.w	#1,d0

		moveq	#0,d1			;aktuelle Songpos
		move.w	d0,d2			;fr spter sichern
.PP30_numpatts1:moveq	#0,d3
.PP30_dotest:	move.b	(a1,d1.w),d4
		cmp.b	(a1,d3.w),d4
		bne.s	.PP30_testno
		move.b	(a3,d1.w),d4
		cmp.b	(a3,d3.w),d4
		bne.s	.PP30_testno
		move.b	(a4,d1.w),d4
		cmp.b	(a4,d3.w),d4
		bne.s	.PP30_testno
		move.b	(a6,d1.w),d4
		cmp.b	(a6,d3.w),d4
		bne.s	.PP30_testno
		move.w	d3,d5
		bra.s	.PP30_testrts
.PP30_testno:	addq.w	#1,d3
		cmp.w	d1,d3
		ble.s	.PP30_dotest
		move.w	d1,d5
.PP30_testrts:	move.b	d5,(a2)+
		add.w	#1,d1
		dbf	d0,.PP30_numpatts1

		lea	pro_temp2(A5),a4	;Zieladresse
		lea	pro_temp1(A5),a2
		move.w	d2,d3
.PP30_copy:	move.b	(a2)+,(a4)+
		dbf	d3,.PP30_copy

		lea	pro_temp2(A5),a2;Zieladresse, bearbeiten, damit Patternnummern
					;hinterher Stimmen

		moveq	#0,d0		;aktuelle Patternnummer (als ST)

		moveq	#0,d1
		move.w	d2,d3
.PP30_uebertrage:lea	(a2),a3
					;jeweils kleinste Patternnummer suchen,D0
		move.w	d3,d4		;gibt an, welche Nummern schon bearbeitet sind
		moveq	#$7f,d1		;z.B. im ersten Durchlauf ist D0 = 0
.PP30_calc:				;d.h. im 2. Durchlauf ist dann D0 = 1 und
		cmp.b	(a3),d1		;somit ist die kleinste erlaubte Patternnummer
		ble.s	.PP30_notthis	;1 !
		cmp.b	(a3),d0
		bgt.s	.PP30_notthis
		move.b	(a3),d1
.PP30_notthis:	addq.l	#1,a3
		dbf	d4,.PP30_calc


		lea	(a2),a3		;ersetzt die jeweils kleinste Patternnummer,
		move.w	d3,d4		;die vorkommt durch den richtigen Wert, da
.PP30_calc2:				;die vorkommende Nummer sonstwiehoch sein kann
		cmp.b	(a3)+,d1	;(das enstprechende Pattern kann theoretisch
		bne.s	.PP30_wei	;an einer tierisch weit entfernten Pos stehen)
		move.b	d0,-1(A3)
.PP30_wei:	dbf	d4,.PP30_calc2	

		addq.w	#1,d0
		dbf	d2,.PP30_uebertrage

		lea	pro_temp1(A5),a2	;Sourceadr
		move.w	d3,d4		;fr Spter
		move.w	d3,d0
		moveq	#0,d2
.PP30_cleardoub:move.b	(a2)+,d1
		blt.s	.PP30_next

		addq.w	#1,d2

		move.w	d0,d3
		move.l	a2,a3
.PP30_loop2:	cmp.b	(a3)+,d1
		bne.s	.PP30_not
		move.b	#-1,-1(a3)
.PP30_not:	dbf	d3,.PP30_loop2
.PP30_next:	dbf	d0,.PP30_cleardoub
					;in D2 Anzahl der Patterns,so nebenbei mit
					;berechnet

	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		moveq	#0,d0
		move.w	d2,d0
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	.PP30_Error
		move.l	d1,a1

	
		move.l	(sp)+,A2	;Zeiger auf 1.Note
		move.l	a5,-(sp)

		lea	pro_temp2(A5),a4
		lea	$3b8(a1),a6
		move.w	d4,d0
.PP30_positions:move.b	(a4)+,(a6)+
		dbf	d0,.PP30_positions

		lea	pro_temp1(A5),a4 ;Welche Patterns rbergeholt werden mssen
		lea	pro_temp2(A5),a6 ;was als Soundtracker rauskommt
.PP30_dopatts:	moveq	#0,d2
		move.b	(A4)+,d2
		blt.s	.PP30_donethis
		moveq	#0,d5
		move.b	(A6),d5
		lea	$43c(a1),a5
		lsl.l	#8,d5	
		lsl.l	#2,d5
		add.l	d5,a5

		lea	$fa(a0),a3
		moveq	#0,d0
		move.b	(a3,d2.w),d0
		bsr	.PP30_dostripe

		lea	4(a5),a5
		lea	$fa+$080(a0),a3
		moveq	#0,d0
		move.b	(a3,d2.w),d0
		bsr	.PP30_dostripe

		lea	4(a5),a5
		lea	$fa+$100(a0),a3
		moveq	#0,d0
		move.b	(a3,d2.w),d0
		bsr	.PP30_dostripe

		lea	4(a5),a5
		lea	$fa+$180(a0),a3
		moveq	#0,d0
		move.b	(a3,d2.w),d0
		bsr	.PP30_dostripe

.PP30_donethis:	addq.l	#1,a6
		dbf	d4,.PP30_dopatts

		move.l	(sp)+,a5

		lea	(a0),a3		;Sampleinfostrukturen wiederherstellen
		move.w	$f8(a0),$3b6(a1);Songlnge,Restart kopieren
	;	move.l	#`M.K.`,$438(a1)
		lea	$2a(a1),a2
		moveq	#31-1,d0
.PP30_sam:	move.l	(A3)+,(a2)
		move.l	(A3)+,4(a2)
		lea	$1e(a2),a2
		dbf	d0,.PP30_sam

	*--------- Zum ProTracker-InitPlayer hpfen --------*
		moveq	#1,d1			;convertiertes Module geladen
		bra.w	ProT_PackInd


.PP30_Error:	addq.l	#4,a7
		tst.l	d0
		rts

.PP30_dostripe:	lea	$2fa(a0),a3
		lsl.w	#7,d0
		lea	(a3,d0.w),a3
		moveq	#63,d0

		move.l	a6,-(sp)
		lea	(A5),a6
.PP30_doit:	move.w	(a3)+,d1
		move.l	(a2,d1.w),(a6)
		lea	16(a6),a6
		dbf	d0,.PP30_doit

		move.l	(sp)+,a6
		rts


*------------------------------------------------------------------------*
P4_InitPlayer:	jsr	A5ClearProTemps(a5)
		clr.l	P56_Sampleadr
		clr.l	P56_Samplesize
		jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)
		move.l	d0,MT_Size

		lea	P0ASign(pc),a1
		move.b	2(a0),(a1)+
		move.b	3(a0),d0
		or.b	#32,d0
		move.b	d0,(a1)+

		clr.l	SampleData(a5)
		clr.l	SampleDataSize(a5)
		moveq	#1,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		tst.l	d0
		beq.s	.OkNoSamp
		move.l	a0,SampleData(a5)
		move.l	d0,SampleDataSize(a5)

.OkNoSamp:	move.l	Ori_Data(a5),a0
		move.l	a0,-(sp)
		addq.l	#4,a0
		moveq	#0,d1
		moveq	#16,d2
		move.b	2(a0),d1
		rol.l	#4,d1
		add.l	d2,d1
		move.l	8(a0),d0
		sub.l	d1,d0				;Ori.Adr in a0
		beq.s	.P40A_NoDecrypt
		sub.l	d0,4(a0)
		sub.l	d0,8(a0)
		move.l	12(a0),d2
		moveq	#0,d1
		move.b	2(a0),d1
		subq.w	#1,d1
		lea	$10(a0),a1
.P40A_32:	sub.l	d2,(a1)
		sub.l	d2,6(a1)
		lea	$10(a1),a1
		dbra	d1,.P40A_32
		sub.l	d0,12(a0)
.P40A_NoDecrypt:move.l	(sp)+,a0

		moveq	#0,d1
		move.b	4+2(a0),d1
		subq.w	#1,d1
		lea	20+4(a0),a1
		moveq	#0,d0
		moveq	#0,d2
		moveq	#0,d7			;Samplessize als Protracker

		moveq	#-1,d6

		lea	(a1),a2
.P40A_Sampsize:	move.w	(a1),d2
		move.l	-4(a1),d4		;Sampleadr (Offset zum)

		move.w	d6,d5			;1. Durchlauf -> weiter
		blt.s	.ok
		lea	(a2),a3			;Lnge 1. Sample
.seek
		cmp.l	-4(a3),d4
		beq.s	.skip
		lea	$10(a3),a3
		dbf	d5,.seek
.ok
		add.l	d2,d0
		add.l	d2,d0
.skip
		add.l	d2,d7			;Samplessize konvertiert
		add.l	d2,d7

		lea	$10(a1),a1
		addq.w	#1,d6
		dbf	d1,.P40A_Sampsize

		lea	Pro_InfoBuffer(pc),a4
		move.l	d0,60(a4)			;SampleSize merken
		move.l	Ori_Data(a5),a2
		move.l	16(a2),a1
		addq.l	#4,a1				;Dateiheader
		move.l	a1,52(a4)			;Songsize
		move.l	a1,68(a4)			;Calcsize (Song)
		add.l	d0,68(a4)			;Calcsize (Sample)

	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		moveq	#0,d0
		move.b	4+1(a0),d0		;Pattern laden
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn

		move.l	d1,a1
		lea	20+22(a1),a3
		lea	20+4(a0),a2		;Samplessize 1. Sample
		moveq	#0,d0
		move.b	4+2(a0),d0
		subq.b	#1,d0

		moveq	#11,d4			;fr Lautstrke
		moveq	#8,d5			;fr Finetune
		cmp.l	#`P41A`,(a0)
		bne.s	.P40A_DoSam
		moveq	#9,d4		;fr Lautstrke P41A
		moveq	#10,d5		;fr Finetune P41A
.P40A_DoSam:	move.w	(a2),(a3)+		;Samplelnge
		moveq	#0,d1
		move.w	(a2,d5.w),d1
		divu	#74,d1
		move.b	d1,(a3)+		;Finetune
		move.b	(a2,d4.w),(a3)+		;Lautstrke
		move.l	2(a2),d1
		sub.l	-4(A2),d1
		lsr.w	#1,d1
		move.w	d1,(a3)+		;Repeatstart
		move.w	6(a2),(a3)+		;Repeatlnge
		lea	30-8(a3),a3
		lea	16(a2),a2
		dbf	d0,.P40A_DoSam

					;rausfinden, welche Kombination
					;welches Pattern
					;(1. Kombination=1.Patt usw.)
		lea	pro_temp1+bssmerkpuffer,a4
		move.l	12(a0),d0
		lea	4(a0,d0.l),a2		;1. Songinfo
		moveq	#0,d0
		moveq	#0,d1			;Aktuelle Pattanz -1
		moveq	#0,d2

		move.w	(a2)+,(a4)
		move.w	(a2)+,2(a4)
		move.w	(a2)+,4(a4)
		move.w	(a2)+,6(a4)
		move.b	4(a0),d1		;Patternanzahl
		subq.w	#1,d1		;weil besser is wegen die Offsets (siehe D0)

		move.b	5(a0),d2		;Songlnge
		move.b	d2,$3b6(a1)		;eintragen
		move.b	#$7f,$3b7(a1)		;Songrestart eintragen

.Patts1:					;Test ob Patternkombination
		lea	(a4),a6			;schon vorgemerkt
		move.w	d0,d3
.P40A_CheckIf:	move.w	(a6),d4
		cmp.w	(a2),d4
		bne.s	.P40a_Next
		move.w	2(a6),d4
		cmp.w	2(a2),d4
		bne.s	.P40A_Next
		move.w	4(a6),d4
		cmp.w	4(a2),d4
		bne.s	.P40A_Next
		move.w	6(a6),d4
		cmp.w	6(a2),d4
		beq.s	.P40A_NextPos	;Pattern in Liste gefunden, also nchstes,
					;was wir noch nicht haben, suchen
.P40A_Next:	addq.l	#8,a6
		dbf	d3,.P40A_CheckIf
		move.w	(a2),(a6)
		move.w	2(a2),2(a6)
		move.w	4(a2),4(a6)
		move.w	6(a2),6(a6)
		addq.w	#1,d0
.P40A_NextPos:	addq.l	#8,a2
		cmp.b	d0,d1			;Anzahl der Patterns ok ?
		dbeq	d2,.patts1

.P40A_Sehrkurz:					;nun Songinfos P40 -> Protracker
		lea	$3b8(a1),a3		;Zeiger auf 1. Pattpos Protracker
		move.l	12(a0),d0
		lea	4(a0,d0.l),a2		;1. Songinfo
		moveq	#0,d2
		move.b	5(a0),d2		;Songlnge
		subq.w	#1,d2
		moveq	#0,d5
		move.b	4(A0),d5		;Patternanz
.dosinfo:	lea	pro_temp1+bssmerkpuffer,a4		;Patternliste (---->Temp1)
		moveq	#0,d0

		move.b	d5,d3
.p40a_checkright:move.w	(a4),d4
		cmp.w	(a2),d4
		bne.s	.p40a_nextposi
		move.w	2(a4),d4
		cmp.w	2(a2),d4
		bne.s	.p40a_nextposi
		move.w	4(a4),d4
		cmp.w	4(a2),d4
		bne.s	.p40a_nextposi
		move.w	6(a4),d4
		cmp.w	6(a2),d4
		beq.s	.p40a_rightpos	;Pattern in Liste gefunden, also nchstes,
					;was wir noch nicht haben, suchen
.p40a_nextposi:	addq.l	#8,a4
		addq.b	#1,d0
		dbf	d3,.p40a_checkright
.p40a_rightpos:	move.b	d0,(A3)+
		addq.l	#8,a2
		dbf	d2,.dosinfo

		move.l	a5,-(sp)		;sichern
		lea	$43c(A1),a2		;Zeiger auf 1.Patt ProT
		lea	pro_temp1+bssmerkpuffer,a4	;--->Temp1
		move.l	8(a0),d0
		lea	4(a0,d0.l),a5		;Zeiger auf 1.Patt P40
		moveq	#0,d5
		move.b	4(A0),d5		;Patternanz
		subq.w	#1,d5
		lea	pro_temp2+bssmerkpuffer,a6 ;---->Temp 2
		clr.l	(A6)
		clr.l	4(A6)
		clr.l	8(A6)
.convertpatts:	move.w	(A4)+,d0
		cmp.w	#$ffff,d0
		beq.s	.p40a_endpatt
		lea	(a5,d0.w),a3
		bsr	.p40a_dostripe
		addq.l	#4,a2
		move.w	(A4)+,d0
		lea	(a5,d0.w),a3
		bsr	.p40a_dostripe
		addq.l	#4,a2
		move.w	(A4)+,d0
		lea	(a5,d0.w),a3
		bsr	.p40a_dostripe
		addq.l	#4,a2
		move.w	(a4)+,d0
		lea	(a5,d0.w),a3
		bsr	.p40a_dostripe
		add.l	#1024-12,a2		;Zeiger auf nchstes Patt ProT
		dbf	d5,.convertpatts
.p40a_endpatt:	move.l	(sp)+,a5

		move.l	a2,a1			;1. Sample Protracker

		move.l	16(A0),d0
		lea	4(a0,d0.l),a0		;1. Sample P40a

		move.l	a0,SamplePointer(a5)
		move.l	SampleData(a5),d0
		beq.s	.NoSampleData
		move.l	d0,SamplePointer(a5)
.NoSampleData:

		lea	Pro_Infobuffer(pc),a0
		cmp.l	60(a0),d7	;Samplesize Pro = Samplesize P4 ?
		beq.s	.go

		movem.l	d1-a6,-(sp)
		move.l	d7,d0
		moveq	#3,d1			;Chip
		addq.l	#8,d0
		move.l	4,a6
		jsr	_LVOallocmem(a6)
		movem.l	(sp)+,d1-a6
		move.l	d0,d1
		beq	Pro_MemEndPlayer	;No Mem, Ende, aber vorher
						;ExtraMem freigeben
		move.l	d1,P56_Sampleadr
		move.l	d1,a1			;1. Sample Protracker
		move.l	d7,P56_Samplesize

		move.l	ori_data(a5),a0
		moveq	#0,d3
		move.b	4+2(a0),d3
		subq.w	#1,d3
		move.l	16(A0),d0		;Offset 1. Sample
		lea	20(a0),a2
		addq.l	#4,d0			;+4
		add.l	a0,d0			;1. Sample P40a
.p40a_copy1samples
		moveq	#0,d1
		move.w	4(a2),d1
		beq.s	.skip1
		move.l	(a2),a0
		add.l	d0,a0

		add.l	d1,d1
.p40a_copy1sample
		move.b	(a0)+,(a1)+
		subq.l	#1,d1
		bne.s	.p40a_copy1sample
.skip1
		lea	16(a2),a2
		dbf	d3,.p40a_copy1samples

		move.l	P56_Sampleadr(pc),SamplePointer(A5)
		moveq	#3,d1			;convertiertes Module geladen
		bra	ProT_PackInd
.go
	*--------- Zum ProTracker-InitPlayer hpfen --------*
		moveq	#1,d1			;convertiertes Module geladen
		bra	ProT_PackInd

	*-------------- P4xx Hilfsroutine --------------*
.P40A_DoStripe:	movem.l	d3/a0/a2,-(sp)
		lea	Pro_MyPeriods(pc),a0
		moveq	#63,d4
.P40A_Stripe:	moveq	#0,d1
		tst.b	3(a6)
		beq.s	.P40A_new
		bmi.s	.P40A_old
		subq.b	#1,3(a6)
		bra.w	.P40A_nextnote
.P40A_Old:	addq.b	#1,3(a6)
		bra.s	.P40A_convert
.P40A_New:	tst.b	5(A6)
		beq.s	.getnote
		move.l	(A3)+,(A6)
		subq.b	#1,5(A6)	
		bne.s	.P40A_convert
		move.l	6(A6),a3
		bra.s	.P40A_convert
.GetNote:	move.l	(a3)+,(a6)
		bge.s	.P40A_convert
		move.w	(a6),4(A6)
		move.w	2(a6),d0
		move.l	a3,6(a6)
		and.b	#~1,d0		;sonst Absturz auf 68000 mglich
		lea	(a5,d0.w),a3
		move.l	(a3)+,(a6)
.p40a_convert
	moveq	#0,d1
	move.b	(a6),d2

	and.w	#$7e,d2		;bei Bedarf reinnehmen !
	beq.s	.p40a_noper	

	move.w	(a0,d2.w),d1
.p40a_noper

	move.w	(A6),d2
	and.w	#$1F0,d2
	beq.s	.p40a_nonote
	move.b	(a6),d2
	and.b	#1,d2		;Samplenummer > 15 ?
	beq.s	.p40a_nohi
	or.w	#$1000,d1
.p40a_nohi
.p40a_nonote
	swap	d1		;Periode nach oben

	move.b	1(a6),d2
	and.b	#$f,d2
	cmp.b	#8,d2
	bne.s	.p4_noarp
	moveq	#0,d2
	bra.s	.p4_nocom
.p4_noarp
	cmp.b	#$e,d2
	bne.s	.p4_noe
	move.b	2(a6),d1
	cmp.b	#$10,d1
	bhs.s	.p4_nocom
	lsr.b	#1,d1
	move.b	d1,2(A6)
	bra.s	.p4_nocom
.p4_noe
	cmp.b	#$a,d2
	beq.s	.p4_aha

	cmp.b	#5,d2
	bne.s	.p4_novib
.p4_aha
	move.b	2(a6),d1
	bgt.s	.p4_nocom
	neg.b	d1
	lsl.b	#4,d1
	move.b	d1,2(A6)
	bra.w	.p4_nocom
.p4_novib
.p4_nocom
	move.b	1(a6),d3
	and.b	#$f0,d3
	or.b	d3,d2
	lsl.w	#8,d2
	move.w	d2,d1		;Snummer und Kommando
	or.b	2(a6),d1	;Argument
.p40a_nextnote
		move.l	d1,(a2)
		lea	16(a2),a2
		dbf	d4,.P40A_stripe
		clr.l	(A6)
		clr.l	4(A6)
		clr.l	8(A6)
		movem.l	(sp)+,d3/a0/a2
		rts

*-------------- Check auf P50A/P60A Modul --------------------------------*
P56_check
	move.l	DTG_ChkData(a5),a0
	cmp.l	#`P60A`,(a0)+
	beq.w	.p60_checkit
	cmp.l	#`P50A`,-4(a0)
	beq.w	.p60_checkit
	cmp.l	#`P61A`,-4(a0)
	beq.w	.p60_checkit

	subq.l	#4,a0
.p60_checkit
	moveq	#0,d1
	move.w	(a0),d1		Offset zu den Samples = 0 ?
	beq	.nop60

	moveq	#0,d0
	move.b	2(a0),d0
	cmp.b	#100,d0
	bhi	.nop60		Offset zu den Samples > Songsize als PT ?
	mulu	#1024,d0
	cmp.l	d1,d0
	blt	.nop60		kann nicht sein !

	lea	4(a0),a2		;1. Samplelnge
	moveq	#0,d0
	move.b	3(a0),d0		;Anzahl der Samples
	move.b	d0,d1
	and.b	#64,d1
	beq.s	.p60_nodelta
	lea	8(a0),a2
.p60_nodelta
	lea	(a2),a1
	and.b	#~64+128,d0
	cmp.b	#$1f,d0
	bhi	.nop60
	subq.w	#1,d0

	moveq	#0,d2
.p60_checksaminfos
	moveq	#0,d1
	move.w	(a1),d1
	bmi.s	.notadd

	add.l	d1,d2			;einfache Lnge fr gepackte Samples

	tst.b	2(a1)
	bmi.s	.notadd

	add.l	d1,d2			;doppelte Lnge fr normale Samples
.notadd
	move.b	2(a1),d1
	and.b	#$70,d1
	bne	.nop60	
	cmp.b	#64,3(a1)
	bhi	.nop60
	tst.w	4(a1)			;darf nur >0 oder -1 sein
	blt.s	.p60_test
	move.w	(A1),d1
	blt.s	.p60_losize
	cmp.w	4(a1),d1
	blt	.nop60
	bra.s	.p60_test
.p60_losize
	tst.w	4(a1)
	blt	.nop60
.p60_test
	addq.l	#6,a1
	dbf	d0,.p60_checksaminfos
	move.l	d2,p56_orisamsize

	move.l	-4(a0),d0
	cmp.l	#`P60A`,d0
	beq	.p60_found
	cmp.l	#`P50A`,d0
	beq	.p50_found
	cmp.l	#`P61A`,d0
	beq	.dop61

	move.w	(a0),d1			;Offset zum 1. Sample
	move.b	3(a0),d0
	and.w	#$3f,d0
	mulu	#6,d0
	lea	(a2,d0.w),a1
	moveq	#0,d0
	move.b	2(a0),d0
	lsl.w	#3,d0
	lea	(a1,d0.w),a2		;Songinfos
	lsr.w	#1,d0
	subq.w	#1,d0

	move.l	a1,d5
	move.w	d0,d7
.p60_nextcheck
	cmp.w	(a1)+,d1		;Patternoffsets mssen kleiner sein
					;als Offset zum 1. Sample
	blo	.nop60
	dbf	d0,.p60_nextcheck

	move.b	2(a0),d1		;Anzahl Patterns
	subq.b	#1,d1
	moveq	#0,d2
	move.w	#130,d4			max Checklnge
	move.l	a2,a3
.p60_oh
	move.b	(A2)+,d0
	cmp.b	#$ff,d0
	beq	.p60_lastcheck

	or.b	d0,d3
	and.b	#1,d3	;!!	wenn alle durch 2 teilbar, dann
				;ist es P50 !!
	cmp.b	d1,d0
	bhi	.checkp50

	bne	.p60_oh2
	moveq	#1,d2
.p60_oh2
	dbf	d4,.p60_oh
	bra	.nop60
.p60_lastcheck
	tst.w	d3		alle durch 2 teilbar -> wahrscheinlich P50
	bne.s	.p60_check_last
	move.b	3(a0),d0
	and.b	#~$1f,d0
	bne.s	.p60_check_last

	move.l	a5,-(sp)
	bsr	.CheckP61	;Vorsicht, die Routine braucht die Register, 
				;wie sie hier sind !!
	move.l	(sp)+,a5
	bne	.doP61
	bra	.p50_found
.p60_check_last
	tst.w	d2		Hchstes Pattern nicht gefunden -> Fehler
	beq	.nop60

	move.l	a5,-(sp)
	bsr	.CheckP61	;Vorsicht, die Routine braucht die Register, 
				;wie sie hier sind !!
	move.l	(sp)+,a5
	bne	.doP61

	bra.s	.p60_found
.checkP50
	move.b	2(a0),d1		;Anzahl Patterns
	subq.b	#1,d1
	moveq	#0,d2
	move.w	#130,d4
.p50_oh
	move.b	(A3)+,d0
	cmp.b	#$ff,d0
	beq	.p50_lastcheck

	lsr.b	#1,d0			;wenn nicht durch 2 teilbar, dann
	bcs	.noP60			;ist es P60 !!!
	cmp.b	d1,d0
	bhi	.noP60
	bne	.p50_ohoh
	moveq	#1,d2
.p50_ohoh
	dbf	d4,.p50_oh
.p50_lastcheck
	tst.w	d2
	beq	.noP60
.p50_found
	move.l	#1,pro_temp1(A5)
.rts
	moveq	#0,d0
	rts
.p60_found			;Ende der Checkroutine
	clr.l	pro_temp1(A5)
	bra.s	.rts
.dop61
	move.l	#2,pro_temp1(A5)
	bra.s	.rts
.nop60
	moveq	#-1,d0
	rts

.CheckP61
	lea	pro_temp2(a5),a6
	clr.l	(A6)
	clr.l	4(A6)
	clr.l	8(A6)
	clr.l	12(A6)
	clr.l	16(A6)

	move.l	d5,a4

	move.l	a2,a5
	move.l	a6,d3

	tst	d7
	ble.s	.loa
	subq	#1,d7
.loa
	move.l	d3,a6
	move.w	(A4)+,d0
	lea	(a5,d0.w),a3
	moveq	#0,d6
	bsr	.p61check_dostripe
	bne.s	.ille
	dbf	d7,.loa
	moveq	#0,d0
.ille
	rts
.p61check_dostripe
	movem.l	a0/a2/a5,-(sp)
	lea	pr_periods,a0
	moveq	#63,d4
	move.l	a3,p50_chapos(a6)
.p61check_stripe
	moveq	#0,d1
	tst.b	p50_pack(a6)
	beq.s	.p61check_new
	bmi.s	.p61check_old
	subq.b	#1,p50_pack(a6)
	bra.w	.p61check_nextnote
.p61check_old
	addq.b	#1,p50_pack(a6)
	bra.s	.p61check_convert
.p61check_new
	tst.b	P50_TempLen+1(a6)
	beq.w	.p61check_takenorm

	subq.b	#1,P50_TempLen+1(a6)

	move.l	P50_TempPos(a6),a5
.p61check_jedi
	move.l	(a6),P50_TData(a6)
	move.b	(a5)+,(a6)
	bpl.b	.p61check_normal
	not.b	(a6)+
	move.b	(a5)+,(a6)+
	move.b	(a5)+,(a6)+
	move.b	(a5)+,(a6)+
	subq.l	#4,a6
	move.l	a5,P50_TempPos(a6)
	bra.b	.p61check_dko
	
.p61check_normal
	move.b	(a5)+,1(a6)
	move.b	(a5)+,2(a6)
	move.l	a5,P50_TempPos(a6)
	bra.b	.p61check_dko

.p61check_takenorm
	move.l	P50_ChaPos(a6),a5
	move.b	(a5)+,(a6)
	bmi.b	.p61check_packed
	move.b	(a5)+,1(a6)
	move.b	(a5)+,2(a6)
	move.l	a5,P50_ChaPos(a6)
	bra.b	.p61check_dko

.p61check_kuiskus
	move.b	(a5)+,P50_TempLen+1(a6)
	moveq	#0,d0
	move.b	(a5)+,d0
	lsl	#8,d0
	move.b	(a5)+,d0

	move.l	a5,P50_ChaPos(a6)
	sub.l	d0,a5
	bra.b	.p61check_jedi

.p61check_packed
	cmp.b	#$80,(a6)
	beq.b	.p61check_kuiskus
	not.b	(a6)+
	move.b	(a5)+,(a6)+
	move.b	(a5)+,(a6)+
	move.b	(a5)+,(a6)+
	subq.l	#4,a6
	move.l	a5,P50_ChaPos(a6)
.p61check_dko
.p61check_convert
	moveq	#0,d1
	move.b	(a6),d2

	and.w	#$7e,d2

	cmp.w	#37*2,d2
	bhi.s	.p61check_err
.p61check_nextnote
	cmp.w	d4,d6
	beq.s	.p61check_endstripe
	dbf	d4,.p61check_stripe
.p61check_endstripe
	clr.l	(A6)
	clr.l	4(A6)
	clr.l	8(A6)
	clr.l	12(A6)
	clr.l	16(A6)
	movem.l	(sp)+,a0/a2/a5
	moveq	#0,d0
	rts
.p61check_err
	movem.l	(sp)+,a0/a2/a5
	moveq	#-1,d0
	rts

p50_pack	equ	3
p50_templen	equ	4
P50_TempPos	equ	8
P50_TData	equ	12
P50_ChaPos	equ	16

P56_Sampleadr	dc.l	0
P56_Samplesize	dc.l	0
P56_Loadsize	dc.l	0
P56_orisamsize	dc.l	0
*--------------------- P50A / P60A Samples freigeben ----------------------*
P56_EndPlayer:
	move.l	P56_sampleadr(pc),d0
	beq.s	.nofree
	clr.l	p56_sampleadr
	move.l	d0,a1
	move.l	P56_Samplesize(pc),d0
	addq.l	#8,d0
	move.l	4.w,a6
	jsr	_LVOfreemem(A6)
.nofree
	bra	Pro_EndPlayer
*------------------------- P50A / P60A Initplay ---------------------------*
P56_InitPlayer:
	jsr	A5ClrInfoBuffer(a5)
	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)
	move.l	d0,Unic_Temp(a5)	;Size
	clr.l	p56_loadsize

	lea	P56_InfoBuffer(pc),a4

	cmp.l	#`P50A`,(a0)
	bne.s	.stan
	move.w	#`P6`,(a0)		;nur P60 wird gesaved !

	*addq.l	#4,a0
.stan

	cmp.w	#"P6",(a0)
	bne.s	.Geh
	addq.l	#4,a0

.Geh:

	lea	P60_Name(pc),a3

	move.l	pro_temp1(a5),d0
	beq.s	.p60_goon
	cmp.l	#2,d0
	beq	dop61

	lea	P50_Name(pc),a3
					;P50 auf P60 umbauen
	move.b	3(a0),d0
	and.w	#$3f,d0
	mulu	#6,d0
	lea	(a0,d0.w),a1
	moveq	#0,d0
	move.b	2(a0),d0
	lsl.w	#3,d0
	lea	4(a1,d0.w),a2		;Songinfos
.P50_2_P60
	move.b	(A2),d0
	cmp.b	#$ff,d0
	beq.s	.p60_goon
	lsr.b	#1,d0
	move.b	d0,(A2)+
	bra.s	.P50_2_P60
.p60_goon
	move.l	a3,4(a4)

;******************** Konverter P60 -> Protracker ****************************

	lea	8(a0),a2
	moveq	#$40,d0
	and.b	3(a0),d0
	bne	.p60_buffer

;-------------------- Standard Routine wie bei P50 ---------------------------
	subq.l	#4,a2

	lea	pro_temp1(a5),a4
	moveq	#0,d1
	move.b	3(a0),d1
	and.b	#$3f,d1
	subq	#1,d1
	moveq	#0,d4
	move.l	a2,-(sp)			sichern
	suba.l	a1,a1
.p60_lopos
	move.l	a1,(a4)+			;Adresse eintragen
	move	(a2)+,d4			;Lnge

	bpl.b	.p60_kook
	neg	d4
	mulu	#12,d4
	lea	Pro_Temp1-12(a5),a3
	move.l	(a3,d4),d6
	move.l	d6,-4(a4)			;neue Adresse eintragen
	move	4(a3,d4),d4
	sub.l	d4,a1
	sub.l	d4,a1
	bra.b	.p60_jatk
.p60_kook

	move.l	a1,d6
.p60_jatk
	move.w	d4,(a4)+		;Lnge eintragen
	move.w	(a2)+,(A4)+
	moveq	#0,d0
	move	(a2)+,d0
	bmi.b	.p60__norepeat

	move	d4,d5
	sub	d0,d5
	move.w	d0,(a4)+		;Repeatstart eintragen
	move.w	d5,(a4)+		;Repeatlnge eintragen
	bra.b	.p60_gene
.p60__norepeat
	move.l	#1,(a4)+		;Repeatstart
.p60_gene
	add.l	d4,a1
	add.l	d4,a1
	dbf	d1,.p60_lopos
	move.l	(sp)+,a4		statt a2 -> a4 zurck

	lea	pro_temp1+4(a5),a1
	move.b	3(a0),d0
	and.w	#$3f,d0
	subq.w	#1,d0
	moveq	#0,d7
	moveq	#0,d1
.p60_samsize
	move.w	(a1)+,d1
	add.l	d1,d7
	add.l	d1,d7
	addq.l	#8,a1
	addq.l	#2,a1
	dbf	d0,.p60_samsize

	movem.l	d1-a6,-(sp)
	move.l	d7,d0
	moveq	#3,d1			;Chip
	addq.l	#8,d0
	move.l	4,a6
	jsr	_LVOallocmem(a6)
	movem.l	(sp)+,d1-a6
	move.l	d0,d1
	bne.s	.sammem
	moveq	#EPR_NotEnoughMem,d0
	bra.w	Pro_CReturn
.sammem
	move.l	d1,P56_Sampleadr
	move.l	d7,P56_Samplesize

	moveq	#0,d0
	move.b	2(a0),d0

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn

	move.l	d1,a1

	moveq	#0,d0
	move.w	(A0),d0
	cmp.l	unic_temp(a5),d0
	bne.s	.p60_intern2

	move.l	a0,-(sp)
	bsr	p60_loadsamples
	move.l	a0,d1			Samplefile Adr
	move.l	(sp)+,a0

	bra.s	.p60_wei2
.p60_intern2
	moveq	#0,d1
	move.w	(a0),d1
	add.l	a0,d1
.p60_wei2
	move.b	3(a0),d0
	and.w	#$1f,d0
	subq.w	#1,d0

	move.l	a4,-(sp)

	lea	pro_Temp1(a5),a4
.p60_samadr
	add.l	d1,(a4)+
	addq.l	#8,a4
	dbf	d0,.p60_samadr

	move.l	(sp)+,a4

	bra	.p60_endbuffer
.p60_buffer
;------------ Spezialroutine zum Entpacken der Samples --------------------
	move.l	4(a0),d7
	movem.l	d1-a6,-(sp)
	move.l	d7,d0
	moveq	#3,d1			;Chip
	addq.l	#8,d0
	move.l	4.w,a6
	jsr	_LVOallocmem(a6)
	movem.l	(sp)+,d1-a6
	move.l	d0,d1
	bne.s	.samMem2
	moveq	#EPR_NotEnoughMem,d0
	bra.w	Pro_CReturn
.samMem2
	move.l	d1,P56_Sampleadr
	move.l	d7,P56_Samplesize

	moveq	#0,d0
	move.b	2(a0),d0

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn

	move.l	d1,a1

					;1. Sample Protracker
	move.l	P56_Sampleadr(pc),a6
	moveq	#$1f,d1
	and.b	3(a0),d1
	movem.l	a0-a6,-(sp)

	moveq	#0,d0
	move.w	(A0),d0
	cmp.l	unic_temp(a5),d0
	bne.s	.p60_intern

	move.l	a0,-(sp)
	bsr	p60_loadsamples
	move.l	a0,a1			Samplefile Adr
	move.l	(sp)+,a0

	bra.s	.p60_wei
.p60_intern
	lea	(a0),a1
	add.w	(a0),a1			1. Sample P60
.p60_wei
	lea	pro_Temp1(a5),a4
	subq	#1,d1
.P60__lopos
	move.l	a6,(a4)+
	moveq	#0,d4
	move	(a2)+,d4
	bpl.b	.P60__kook
	neg	d4

	mulu	#12,d4
	move.l	a3,-(sp)
	lea	pro_Temp1-12(A5),a3
	move.l	(a3,d4),d6
	move.l	d6,-4(a4)
	move	4(a3,d4),d4
	move.l	(sp)+,a3
	sub.l	d4,a6
	sub.l	d4,a6
	bra.b	.P60__jatk
.P60__kook
	move.l	a6,d6
	tst.b	3(a0)
	bpl.b	.P60__jatk

	move.l	d4,d0
	subq.l	#2,d0
	bmi.b	.P60__jatk

	move.l	a5,-(Sp)
	move.l	a6,a5
	move.b	(a5)+,d2
	sub.b	(a5),d2
	move.b	d2,(a5)+
.p60__loop
	sub.b	(a5),d2
	move.b	d2,(a5)+
	sub.b	(a5),d2
	move.b	d2,(a5)+
	dbf	d0,.p60__loop
	move.l	(sp)+,a5

.P60__jatk
	move	d4,(a4)+			Lnge
	moveq	#0,d2
	move.b	(a2)+,d2
	move.b	d2,(a4)+			Finetune
	moveq	#0,d3
	move.b	(a2)+,d3
	move.b	d3,(a4)+			Volume

	moveq	#0,d0
	move	(a2)+,d0
	bmi.w	.p60__norepeat2

	move	d4,d5
	sub	d0,d5

	add.l	d0,d0
	move.w	d0,(a4)+			Repeatstart
	move	d5,(a4)+			RepeatLnge
	bra.b	.P60__gene
.p60__norepeat2
	move.l	#1,(a4)+
.P60__gene
	tst	-6(a2)
	bmi.b	.p60__nobuffer

	moveq	#$40,d0
	and.b	3(a0),d0
	beq.b	.p60__nobuffer

	move	d4,d7
	tst.b	d2
	bpl.b	.p60__copy

	subq	#1,d7
	moveq	#0,d5
	moveq	#0,d4
.p60__lo
	move.b	(a1)+,d4
	moveq	#$f,d3
	and	d4,d3
	lsr	#4,d4

	sub.b	.p60__table(pc,d4),d5
	move.b	d5,(a6)+
	sub.b	.p60__table(pc,d3),d5
	move.b	d5,(a6)+
	dbf	d7,.p60__lo

	bra.b	.p60__kop
.p60__copy
	add	d7,d7
	subq	#1,d7
.p60__cob
	move.b	(a1)+,(a6)+
	dbf	d7,.p60__cob
	bra.b	.p60__kop

.p60__table
	 dc.b	0,1,2,4,8,16,32,64,128,-64,-32,-16,-8,-4,-2,-1

.p60__nobuffer
	add.l	d4,a6
	add.l	d4,a6
.p60__kop
	dbf	d1,.P60__lopos
	movem.l	(sp)+,a0-a6
	move.l	a2,a4

.p60_endbuffer
	lea	20+22(A1),a3		;Sampleinfos zurckkonvertieren
	move.b	3(a0),d0
	and.w	#$3f,d0
	lea	pro_temp1+4(A5),a2
	subq.w	#1,d0
	moveq	#0,d1
.p60_dosam
	and.l	#~$8000,(a2)
	move.l	(a2)+,(a3)+
	move.l	(a2)+,(a3)+
	addq.l	#4,a2
	lea	30-8(A3),a3
	dbf	d0,.p60_dosam

					;nun Songpositionen eintragen
	move.b	3(a0),d0
	and.w	#$1f,d0
	mulu	#6,d0
	lea	(a4,d0.w),a2
	moveq	#0,d0
	move.b	2(a0),d0
	lsl.w	#3,d0
	lea	(A2,d0.w),a2
	moveq	#0,d0
	lea	$3b8(a1),a3
	moveq	#0,d1
.p60_song
	move.b	(a2)+,d1
	cmp.b	#$ff,d1
	beq.s	.p60_songend
	move.b	d1,(a3)+
	addq.w	#1,d0
	bra.s	.p60_song
.p60_songend
	move.b	d0,$3b6(a1)

	move.l	#`M.K.`,$438(a1)

	move.l	a5,-(sp)		;sichern
	lea	pro_temp2(a5),a6

	lea	$43c(A1),a2		;Zeiger auf 1.Patt ProT
	move.b	3(a0),d0
	and.w	#$1f,d0
	mulu	#6,d0
	lea	(a4,d0.w),a4		;Zeiger auf 1.Patternstreifenoffset P50
	moveq	#0,d0
	move.b	2(a0),d0
	lsl.w	#3,d0
	lea	(a4,d0.w),a5
.p60_suchff
	cmp.b	#$ff,(A5)+
	bne.s	.p60_suchff
					;in A5 nun 1. Pattern P50
	moveq	#0,d5
	move.b	2(A0),d5		;Patternanz
	subq.w	#1,d5

	clr.l	(A6)
	clr.l	4(A6)
	clr.l	8(A6)
	clr.l	12(A6)
	clr.l	16(A6)
.p60_convertpatts
	move.w	(A4)+,d0
	lea	(a5,d0.w),a3
	moveq	#0,d6
	bsr	p50_dostripe
	addq.l	#4,a2
	move.w	(A4)+,d0
	lea	(a5,d0.w),a3
	bsr	p50_dostripe
	addq.l	#4,a2
	move.w	(A4)+,d0
	lea	(a5,d0.w),a3
	bsr	p50_dostripe
	addq.l	#4,a2
	move.w	(A4)+,d0
	lea	(a5,d0.w),a3
	bsr	p50_dostripe
	add.l	#1024-12,a2		;Zeiger auf nchstes Patt ProT

	dbf	d5,.p60_convertpatts
.p60_endpatt
	move.l	(sp)+,a5
					;A2 = 1. Sample Protracker
					;A0 immer noch Source
	lea	pro_temp1(a5),a1
	move.b	3(a0),d0
	move.b	d0,d1
	and.b	#64,d1
	bne.s	p60_reddy		;Delta-Modul -> weiter

	move.b	d0,d1

	move.l	P56_Sampleadr(pc),a2
	and.w	#$3f,d0
	subq.w	#1,d0
.p60_copysamples
	move.l	(a1)+,a0
	moveq	#0,d7
	move.w	(A1)+,d7
	move.l	d7,d6
	add.l	d7,d7
	move.l	a2,a6
.p60_copy1sample
	move.b	(a0)+,(a2)+
	subq.l	#1,d7
	bne.s	.p60_copy1sample

	tst.b	d1
	bpl.s	.p60_copy1Sampleend

	subq.l	#2,d6
	bmi.b	.p60_copy1Sampleend
	
	move.b	(a6)+,d2
	sub.b	(a6),d2
	move.b	d2,(a6)+
.loop	sub.b	(a6),d2
	move.b	d2,(a6)+
	sub.b	(a6),d2
	move.b	d2,(a6)+
	dbf	d6,.loop

.p60_copy1Sampleend
	addq.l	#6,a1
	dbf	d0,.p60_copysamples
p60_reddy:
	lea	Pro_InfoBuffer(pc),a4
	move.l	P56_orisamsize(pc),60(a4)	;SampleSize merken
	move.l	P56_orisamsize(pc),68(a4)	;Calcsize (Sample)
	move.l	P56_Samplesize(pc),108(a4)	;Chipsize (Samples)

	move.l	Ori_Data(a5),a2
	moveq	#0,d0
	cmp.w	#`P6`,(A2)
	bne.s	.ori
	addq.l	#4,a2
	addq.w	#4,d0
.ori	add.w	(A2),d0
	move.l	d0,52(A4)
	add.l	d0,68(A4)
	add.l	P56_orisamsize(pc),d0
	move.l	d0,116(A4)

	*--------- Zum ProTracker-InitPlayer hpfen --------*

	move.l	P56_Sampleadr(pc),SamplePointer(A5)
	moveq	#3,d1			;convertiertes Module geladen
	bra.w	ProT_PackInd

p60_loadsamples
	movem.l	d1-d7/a1-a6,-(sp)
	moveq	#1,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	d0,p56_loadsize
	movem.l	(sp)+,d1-d7/a1-a6
	rts
p50_dostripe
	movem.l	a0/a2/a5,-(sp)
	lea	my_periods,a0
	moveq	#63,d4
	move.l	a3,p50_chapos(a6)
.p50_stripe
	moveq	#0,d1
	tst.b	p50_pack(a6)
	beq.s	.p50_new
	bmi.s	.p50_old
	subq.b	#1,p50_pack(a6)
	bra.w	.p50_nextnote
.p50_old
	addq.b	#1,p50_pack(a6)
	bra.s	.p50_convert
.P50_new
	tst.b	P50_TempLen+1(a6)
	beq.b	.P50_takenorm

	subq.b	#1,P50_TempLen+1(a6)

	move.l	P50_TempPos(a6),a5
.P50_jedi
	move.l	(a6),P50_TData(a6)
	move.b	(a5)+,(a6)
	bpl.b	.P50_normal
	not.b	(a6)+
	move.b	(a5)+,(a6)+
	move.b	(a5)+,(a6)+
	move.b	(a5)+,(a6)+
	subq.l	#4,a6
	move.l	a5,P50_TempPos(a6)
	bra.b	.P50_dko
	
.P50_normal
	move.b	(a5)+,1(a6)
	move.b	(a5)+,2(a6)
	move.l	a5,P50_TempPos(a6)
	bra.b	.P50_dko

.P50_takenorm
	move.l	P50_ChaPos(a6),a5
	move.b	(a5)+,(a6)
	bmi.b	.P50_packed
	move.b	(a5)+,1(a6)
	move.b	(a5)+,2(a6)
	move.l	a5,P50_ChaPos(a6)
	bra.b	.P50_dko

.P50_kuiskus
	move.b	(a5)+,P50_TempLen+1(a6)
	moveq	#0,d0
	move.b	(a5)+,d0
	lsl	#8,d0
	move.b	(a5)+,d0

	move.l	a5,P50_ChaPos(a6)
	sub.l	d0,a5
	bra.b	.P50_jedi

.P50_packed
	cmp.b	#$80,(a6)
	beq.b	.P50_kuiskus
	not.b	(a6)+
	move.b	(a5)+,(a6)+
	move.b	(a5)+,(a6)+
	move.b	(a5)+,(a6)+
	subq.l	#4,a6
	move.l	a5,P50_ChaPos(a6)
.P50_dko
	move	(a6),d0			(Samplenummer -> 4 nach rechts shiften)
	and	#$1f0,d0

.p50_convert
	moveq	#0,d1
	move.b	(a6),d2

	and.w	#$7e,d2		;bei Bedarf reinnehmen !
	beq.s	.p50_noper	

	move.w	(a0,d2.w),d1
.p50_noper
	move.w	(A6),d2

	and.w	#$1F0,d2
	beq.s	.p50_nonote
	move.b	(a6),d2
	and.b	#1,d2		;Samplenummer > 15 ?
	beq.s	.p50_nohi
	or.w	#$1000,d1
.p50_nohi
.p50_nonote
	swap	d1		;Periode nach oben

	move.b	1(a6),d2
	and.b	#$f,d2
	cmp.b	#8,d2
	bne.w	.p50_noarp
	moveq	#0,d2
	bra.w	.p50_nocom
.p50_noarp
	cmp.b	#$e,d2
	bne.s	.p50_noe
	move.b	2(a6),d1
	cmp.b	#$10,d1
	bhs.s	.p50_nocom
	lsr.b	#1,d1
	move.b	d1,2(A6)
	bra.s	.p50_nocom
.p50_noe
	cmp.b	#$a,d2
	beq.s	.p50_aha

	cmp.b	#5,d2
	bne.s	.p50_novib
.p50_aha
	move.b	2(a6),d1
	bgt.s	.p50_nocom
	neg.b	d1
	lsl.b	#4,d1
	move.b	d1,2(A6)
	bra.s	.p50_nocom
.p50_novib
	cmp.b	#$d,d2
	bne.s	.p50_nobreak
	move.w	d4,d6
.p50_nobreak
.p50_nocom
	move.b	1(a6),d3
	and.b	#$f0,d3
	or.b	d3,d2
	lsl.w	#8,d2
	move.w	d2,d1		;Snummer und Kommando
	or.b	2(a6),d1	;Argument
.p50_nextnote
	move.l	d1,(a2)
	lea	16(a2),a2
	cmp.w	d4,d6
	beq.s	.p50_endstripe
	dbf	d4,.p50_stripe
.p50_endstripe
	clr.l	(A6)
	clr.l	4(A6)
	clr.l	8(A6)
	clr.l	12(A6)
	clr.l	16(A6)
	movem.l	(sp)+,a0/a2/a5
	rts

;************************ Konverter P61 -> Protracker *************************
doP61:
	cmp.l	#`P61A`,(a0)+
	beq.s	.p61sign
	subq.l	#4,a0
.p61sign
	lea	P61_Name(pc),a3
	move.l	a3,4(a4)

	lea	8(a0),a2
	moveq	#$40,d0
	and.b	3(a0),d0
	bne	.p61_buffer

;-------------------- Lnge Samples berechnen ---------------------------

	subq.l	#4,a2
	lea	(a2),a1
	moveq	#$1f,d1
	and.b	3(a0),d1
	subq.w	#1,d1

	moveq	#0,d0
.p61_lopos1
	moveq	#0,d2
	move.w	(A2)+,d2
	bpl.s	.p61_count	
	neg.w	d2
	mulu	#6,d2
	move.w	-6(a1,d2.w),d2
.p61_count
	add.l	d2,d0
	add.l	d2,d0

	addq.l	#4,a2
	dbf	d1,.p61_lopos1

	bra.s	.p61_nobuf
.p61_buffer
	move.l	4(a0),d0			;Lnge Samples
.p61_nobuf
	move.l	d0,d7
	movem.l	d1-a6,-(sp)
	moveq	#3,d1			;Chip|Public
	addq.l	#8,d0			;zur Sicherheit
	move.l	4.w,a6
	jsr	_LVOallocmem(a6)
	movem.l	(sp)+,d1-a6
	move.l	d0,d1
	bne.s	.samMem2
	moveq	#EPR_NotEnoughMem,d0
	bra.w	Pro_CReturn
.samMem2
	move.l	d1,P56_Sampleadr
	move.l	d7,P56_Samplesize

	moveq	#0,d0
	move.b	2(a0),d0

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3			;Patts

	move.l	P56_Sampleadr(pc),a6	;1. Sample Protracker

;------------------------- Samples in Originalzustand bringen -----------------

	move	(a0),d0
	lea	(a0,d0.w),a1			;1. Sample P61

	moveq	#0,d0
	move.w	(A0),d0
	cmp.l	unic_temp(a5),d0
	bne.s	.p61_intern2

	move.l	a0,-(sp)
	bsr	p60_loadsamples
	move.l	a0,a1			Samplefile Adr
	move.l	(sp)+,a0
.p61_intern2
	lea	8(a0),a2
	moveq	#$40,d0
	and.b	3(a0),d0
	bne.b	.buffer
	subq.l	#4,a2
.buffer
	moveq	#$1f,d1
	and.b	3(a0),d1

	subq	#1,d1
	moveq	#0,d4

	movem.l	a3/a5,-(sp)
	lea	pro_temp1(a5),a4		;P61_Samples(pc),a4
	lea	pro_temp1-16(a5),a3		;P61_Samples-16(pc),a3

.P61_lopos
	move.l	a6,(a4)+			;Adresse des Samples
	move	(a2)+,d4
	bpl.b	.P61_kook
	neg	d4

;	lea	P61_Samples-16(pc),a5
	move.l	a3,a5

	asl	#4,d4
	move.l	(a5,d4),d6
	move.l	d6,-4(a4)		;Adresse des anderen Samples = Quelle

	move	4(a5,d4),d4			;Lnge des anderen Samples

	move	d4,(a4)+
	move.b	(a2)+,d2		;Finetune/Indikator
	and.w	#$f,d2			;for security, set to "copy"

	bra.b	.P61_jatk_2		;bloss kopieren
.P61_kook
	move.l	a1,d6			;Quelle normal

	tst.b	3(a0)
	bpl.b	.P61_jatk

	tst.b	(a2)
	bmi.b	.P61_jatk

	move	d4,d0
	subq	#2,d0
	bmi.b	.P61_jatk
	move.l	a1,a5
	move.b	(a5)+,d2
	sub.b	(a5),d2
	move.b	d2,(a5)+
.loop1	sub.b	(a5),d2
	move.b	d2,(a5)+
	sub.b	(a5),d2
	move.b	d2,(a5)+
	dbf	d0,.loop1

.P61_jatk
	move	d4,(a4)+
	moveq	#0,d2
	move.b	(a2)+,d2		;Finetune/Indikator
.p61_jatk_2
	moveq	#0,d3
	move.b	(a2)+,d3

	moveq	#0,d0
	move	(a2)+,d0
	bmi.b	.norepeat

	move	d4,d5
	sub	d0,d5

	move.l	a6,a5			;Adr des aktuellen Samples (Ziel)

	add.l	d0,a5
	add.l	d0,a5

	move.l	a5,(a4)+		;Repstart
	move	d5,(a4)+		;Replen
	bra.b	.P61_gene
.norepeat
	move.l	a6,(a4)+		;RepeatStart
	move	#1,(a4)+		;Replen
.P61_gene
	move	d3,(a4)+		;Volume
	moveq	#$0,d0
	move.b	d2,d0
	move	d0,(a4)+		;Finetune

	move	d4,d7
	tst.b	d2
	bpl.b	.copy

	tst	-6(a2)
	bmi.s	.noadd1
	add.l	d4,a1
.noadd1

	move.l	a1,-(sp)
	move.l	d6,a1

	subq	#1,d7
	moveq	#0,d5
	moveq	#0,d4
.lo	move.b	(a1)+,d4
	moveq	#$f,d3
	and	d4,d3
	lsr	#4,d4

	sub.b	.table(pc,d4),d5
	move.b	d5,(a6)+
	sub.b	.table(pc,d3),d5
	move.b	d5,(a6)+
	dbf	d7,.lo

	move.l	(sp)+,a1
	bra.b	.kop

.copy
	tst	-6(a2)
	bmi.s	.noadd2
	add.l	d4,a1
	add.l	d4,a1
.noadd2
	move.l	a1,-(sp)
	move.l	d6,a1
	
	add	d7,d7
	subq	#1,d7
.cob	move.b	(a1)+,(a6)+
	dbf	d7,.cob

	move.l	(sp)+,a1
	bra.s	.kop

.table dc.b	0,1,2,4,8,16,32,64,128,-64,-32,-16,-8,-4,-2,-1

.kop	dbf	d1,.P61_lopos

	movem.l	(sp)+,a3/a5
;------------------------ Sampleinfostrukturen wiederherstellen ---------------

	lea	pro_temp1(a5),a4		;P61_Samples(pc),a4

	lea	20+22(a3),a1
	moveq	#31-1,d1
.p61_saminfos
	move.w	4(a4),(a1)+		;Size (words)
	move.b	15(a4),d0		;Finetune
	lsl.w	#8,d0
	move.b	13(a4),d0		;Volume
	move.w	d0,(A1)+		;Ftu/Vol
	move.l	6(A4),d0
	sub.l	(A4),d0			;Repeatstart (Offset.b)
	lsr.w	#1,d0			;-> Repeatstart in words
	move.w	d0,(a1)+		;Repeatstart
	move.w	10(a4),(a1)+
	lea	30-8(a1),a1
	lea	16(a4),a4
	dbf	d1,.p61_saminfos

;--------------------------- Songpositionen eintragen --------------------------
	lea	8(a0),a4
	move.b	3(a0),d0
	btst	#6,d0
	bne	.p61_mi
	subq.l	#4,a4
.p61_mi
	and.w	#$3f,d0
	mulu	#6,d0
	lea	(a4,d0.w),a2
	moveq	#0,d0
	move.b	2(a0),d0
	lsl.w	#3,d0
	lea	(A2,d0.w),a2
	moveq	#0,d0
	lea	$3b8(a3),a1
	moveq	#0,d1
.p61_song
	move.b	(a2)+,d1
	cmp.b	#$ff,d1
	beq.s	.p61_songend
	move.b	d1,(a1)+
	addq.w	#1,d0
	bra.s	.p61_song
.p61_songend
	move.b	d0,$3b6(a3)

	move.l	#`M.K.`,$438(a3)

;--------------------------- Patterns umbauen ---------------------------------

	lea	$43c(A3),a2		;Zeiger auf 1.Patt ProT
	movem.l	a3/a5,-(sp)		;Prot Adr sichern

	move.b	3(a0),d0
	and.w	#$1f,d0			;num Sam
	mulu	#6,d0
	lea	(a4,d0.w),a4	;Pointer to 1.Patternstripeoffset P50/60/61

	lea	pro_temp2(a5),a6
	move.l	a6,d7
	clr.l	(A6)
	clr.l	4(A6)
	clr.l	8(A6)
	clr.l	12(A6)
	clr.l	16(A6)

	moveq	#0,d0
	move.b	2(a0),d0
	lsl.w	#3,d0
	lea	(a4,d0.w),a5
.p61_suchff
	cmp.b	#$ff,(A5)+
	bne.s	.p61_suchff	;in A5 now 1. Patterndata P50/60/61

	moveq	#0,d5
	move.b	2(A0),d5		;Patternanz
	subq.w	#1,d5
.p61_convertpatts
	move.l	d7,a6

	move.w	(A4)+,d0		;Offset to actual Patt
	lea	(a5,d0.w),a3		;Adr actual Patt
	moveq	#0,d6			;no Pattbreak (yet)
	bsr	.p61_dostripe

	addq.l	#4,a2			;next note ProTracker
	move.w	(A4)+,d0
	lea	(a5,d0.w),a3
	bsr	.p61_dostripe

	addq.l	#4,a2
	move.w	(A4)+,d0
	lea	(a5,d0.w),a3
	bsr	.p61_dostripe

	addq.l	#4,a2
	move.w	(A4)+,d0
	lea	(a5,d0.w),a3
	bsr	.p61_dostripe

	add.l	#1024-12,a2		;Next Patt ProTracker
	dbf	d5,.p61_convertpatts

	movem.l	(sp)+,a3/A5

	bra	p60_reddy

.p61_dostripe:
	movem.l	a0/a2/a5,-(sp)
	lea	my_periods,a0
	moveq	#63,d4
	move.l	a3,p50_chapos(a6)
.p61_stripe
	move.b	P50_Pack(a6),d0
	and.b	#$3f,d0
	beq.b	.P61_takeone

	tst.b	P50_Pack(A6)
	bmi.b	.p61_keepsame

	subq.b	#1,P50_Pack(A6)
	clr.w	(A6)
	clr.b	2(A6)
	bra	.P61_dko		;Empty Note
.p61_keepsame
	subq.b	#1,P50_Pack(A6)
	bra	.P61_dko		;take last Note
.P61_takeone
	tst.b	P50_TempLen+1(a6)
	beq	.P61_takenorm

	subq.b	#1,P50_TempLen+1(a6)
	move.l	P50_TempPos(A6),a3
.P61_jedi
	move.b	(a3)+,d0
	moveq	#%01100000,d1
	and.b	d0,d1
	cmp.b	#%01100000,d1
	bne.b	.p61_all

	moveq	#%01110000,d1
	and.b	d0,d1
	cmp.b	#%01110000,d1
	bne.b	.p61_cmd

	moveq	#%01111000,d1
	and.b	d0,d1
	cmp.b	#%01111000,d1
	bne.b	.p61_note

.p61_empty
	clr	(a6)+
	clr.b	(a6)+
	tst.b	d0
	bpl.b	.p61_ex
	move.b	(a3)+,(a6)			; Compression info
	bra.b	.p61_ex

.p61_all
	move.b	d0,(a6)+
	move.b	(a3)+,(a6)+
	move.b	(a3)+,(a6)+
	tst.b	d0
	bpl.b	.p61_ex
	move.b	(a3)+,(a6)			; Compression info
	bra.b	.p61_ex

.p61_cmd
	moveq	#$f,d1
	and	d0,d1
	move	d1,(a6)+			; cmd
	move.b	(a3)+,(a6)+			; info
	tst.b	d0
	bpl.b	.p61_ex
	move.b	(a3)+,(a6)			; Compression info
	bra.b	.p61_ex

.p61_note
	moveq	#7,d1
	and	d0,d1
	lsl	#8,d1
	move.b	(a3)+,d1
	lsl	#4,d1
	move	d1,(a6)+
	clr.b	(a6)+	
	tst.b	d0
	bpl.b	.p61_ex
	move.b	(a3)+,(a6)			; Compression info
.p61_ex	subq.l	#3,a6
	move.l	a3,P50_TempPos(A6)
	bra	.P61_dko

.P61_takenorm
	move.l	P50_ChaPos(A6),a3

	move.b	(a3)+,d0
	moveq	#%01100000,d1
	and.b	d0,d1
	cmp.b	#%01100000,d1
	bne.b	.P61_all2

	moveq	#%01110000,d1
	and.b	d0,d1
	cmp.b	#%01110000,d1
	bne.b	.p61_cmd2

	moveq	#%01111000,d1
	and.b	d0,d1
	cmp.b	#%01111000,d1
	bne.b	.p61_note2

.p61_empty2
	clr	(a6)+
	clr.b	(a6)+
	tst.b	d0
	bpl.b	.p61_proccomp
	move.b	(a3)+,(a6)			; Compression info
	bra.b	.p61_proccomp

.p61_all2
	move.b	d0,(a6)+
	move.b	(a3)+,(a6)+
	move.b	(a3)+,(a6)+
	tst.b	d0
	bpl.b	.p61_proccomp
	move.b	(a3)+,(a6)			; Compression info
	bra.b	.p61_proccomp

.p61_cmd2
	moveq	#$f,d1
	and	d0,d1
	move	d1,(a6)+			; cmd
	move.b	(a3)+,(a6)+			; info
	tst.b	d0
	bpl.b	.p61_proccomp
	move.b	(a3)+,(a6)			; Compression info
	bra.b	.p61_proccomp

.p61_note2
	moveq	#7,d1
	and	d0,d1
	lsl	#8,d1
	move.b	(a3)+,d1
	lsl	#4,d1
	move	d1,(a6)+
	clr.b	(a6)+	
	tst.b	d0
	bpl.b	.p61_proccomp
	move.b	(a3)+,(a6)			; Compression info

.p61_proccomp
	subq.l	#3,a6
	move.l	a3,P50_ChaPos(A6)

	tst.b	d0
	bpl.b	.P61_dko

	move.b	3(a6),d0
	move.b	d0,d1
	and	#%11000000,d1
	beq.b	.P61_dko				; Empty datas
	cmp.b	#%10000000,d1
	beq.b	.P61_dko				; Same datas

	clr.b	3(a6)
	and	#$3f,d0
	move.b	d0,P50_TempLen+1(a6)

	cmp.b	#%11000000,d1
	beq.b	.p61_bit16				; 16-bit

	moveq	#0,d0					; 8-bit
	move.b	(a3)+,d0
	move.l	a3,P50_ChaPos(A6)
	sub.l	d0,a3
	bra	.P61_jedi

.p61_bit16
	moveq	#0,d0
	move.b	(a3)+,d0
	lsl	#8,d0
	move.b	(a3)+,d0

	move.l	a3,P50_ChaPos(A6)
	sub.l	d0,a3
	bra	.P61_jedi
.P61_dko
	move	(a6),d0			(Samplenummer -> 4 nach rechts shiften)
	and	#$1f0,d0

.p61_convert
	moveq	#0,d1
	move.b	(a6),d2

	and.w	#$7e,d2		;bei Bedarf reinnehmen !
	beq.s	.p61_noper	

	move.w	(a0,d2.w),d1
.p61_noper
	move.w	(A6),d2

	and.w	#$1F0,d2
	beq.s	.p61_nonote
	move.b	(a6),d2
	and.b	#1,d2		;Samplenummer > 15 ?
	beq.s	.p61_nohi
	or.w	#$1000,d1
.p61_nohi
.p61_nonote
	swap	d1		;Periode nach oben

	move.b	1(a6),d2
	and.b	#$f,d2
	cmp.b	#8,d2
	bne.s	.p61_noarp
	moveq	#0,d2
	bra.s	.p61_nocom
.p61_noarp
	cmp.b	#$e,d2
	bne.s	.p61_noe
	move.b	2(a6),d1
	cmp.b	#$10,d1
	bhs.s	.p61_nocom
	lsr.b	#1,d1
	move.b	d1,2(A6)
	bra.s	.p61_nocom
.p61_noe
	cmp.b	#$a,d2
	beq.s	.p61_aha

	cmp.b	#5,d2
	bne.s	.p61_novib
.p61_aha
	move.b	2(a6),d1
	bgt.s	.p61_nocom
	neg.b	d1
	lsl.b	#4,d1
	move.b	d1,2(A6)
	bra.s	.p61_nocom
.p61_novib
	cmp.b	#$d,d2
	bne.s	.p61_nobreak
	move.w	d4,d6
.p61_nobreak
.p61_nocom
	move.b	1(a6),d3
	and.b	#$f0,d3
	or.b	d3,d2
	lsl.w	#8,d2
	move.w	d2,d1		;Snummer und Kommando
	or.b	2(a6),d1	;Argument
.p61_nextnote
	move.l	d1,(a2)
	lea	16(a2),a2

	cmp.w	d4,d6
	beq.s	.p61_endstripe
	dbf	d4,.p61_stripe
.p61_endstripe
	clr.l	(A6)
	clr.l	4(A6)
	clr.l	8(A6)
	clr.l	12(A6)
	clr.l	16(A6)
	movem.l	(sp)+,a0/a2/a5
	rts

*-------------------------------------------------------------------------*
GMC_InitPlayer:	jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

		move.l	pro_temp1+4(A5),d0
		move.l	pro_temp1(a5),d3
		add.l	#1024+444,d3		;in D3 Songlnge
		lea	Pro_InfoBuffer(pc),a4
		move.l	d3,68(a4)		;Songsize fr Calcsize
		add.l	d0,68(a4)		;Samplesize fr Calcsize
		move.l	d3,52(a4)		;SongSize
		move.l	d0,60(a4)		;SampleSize


	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		move.l	pro_temp1(A5),d0	;Pattern laden
		lsr.w	#8,d0
		lsr.w	#2,d0
		addq.w	#1,d0
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a1			;Zieladresse



		move.l	pro_temp1(A5),d7	;SongSize
		add.l	#1024,d7

		lea	20+22(a1),a2		;Ziel
		lea	(a0),a3
		moveq	#15-1,d0
.GMC_Dopre:	move.l	4(a3),(a2)+		;Lnge,Lautstrke
		cmp.w	#2,12(a3)
		bhi.s	.GMC_YesRep
		clr.w	(a2)+
		bra.s	.GMC_noRep
.GMC_yesrep:	move.l	8(a3),d1
		sub.l	(a3),d1
		asr.l	#1,d1
		move.w	d1,(a2)+		;Repeatbeginn
.GMC_NoRep:	move.w	12(A3),(a2)+		;Repeatlnge
		lea	22(A2),a2
		addq.l	#8,a3
		addq.l	#8,a3
		dbf	d0,.GMC_Dopre

		moveq	#15,d0
.GMC_Rep:	move.w	#1,6(A2)
		lea	$1e(a2),a2
		dbf	d0,.gmc_rep

		move.b	$f3(a0),$3b6(a1)
		lea	$3b8(a1),a2
		lea	$f4(a0),a3
		move.w	$f2(a0),d0
		subq.w	#1,d0
.GMC_CopysInfo:	move.w	(a3)+,d1
		cmp.w	#$fc00,d1
		beq.s	.gmc_sinfofertig
		rol.w	#6,d1			;wie  lsr.w #8,d1,lsr.w #2,d1
		move.b	d1,(a2)+
		dbf	d0,.GMC_Copysinfo
.gmc_sinfofertig
	;	move.l	#`M.K.`,$438(a1)

		lea	444(a0),a3
		lea	$43c(a1),a2

		lsr.l	#2,d7
.GMC_dopatts:	move.l	(a3)+,d0
		moveq	#0,d1
		move.w	d0,d2
		and.w	#$f000,d0
		move.w	d2,d1
		and.w	#$ff,d1
		and.w	#$f00,d2
		beq.s	.gmc_noteok
	
		cmp.w	#$200,d2
		bls.s	.gmc_noteok

		cmp.w	#$300,d2
		bne.s	.gmc_novol
		move.w	#$c00,d2
		bra.s	.gmc_noteok
.GMC_novol:	cmp.w	#$400,d2
		bne.s	.gmc_nobreak
		moveq	#0,d1
		move.w	#$d00,d2
		bra.s	.gmc_noteok
.GMC_nobreak:	cmp.w	#$500,d2
		bne.s	.gmc_nojump
		move.w	#$b00,d2
		bra.s	.gmc_noteok
.gmc_nojump:	cmp.w	#$700,d2	;LED on
		bne.s	.noled

		move.w	#$e00,d2
		move.w	#0,d1
		bra.s	.gmc_noteok
.noled:		cmp.w	#$600,d2	;LED off
		bne.s	.noled2

		move.w	#$e00,d2
		move.w	#1,d1
		bra.s	.gmc_noteok
.noled2:	cmp.w	#$800,d2
		bne.s	.gmc_nospeed
		move.w	#$f00,d2
		bra.w	.gmc_noteok
.gmc_nospeed:
.gmc_noteok:	or.w	d1,d2
		or.w	d2,d0
		move.l	d0,(a2)+
		subq.l	#1,d7
		bge.s	.gmc_dopatts

		move.l	a3,SamplePointer(a5)
	*--------- Zum ProTracker-InitPlayer hpfen --------*
		moveq	#1,d1			;convertiertes Module geladen
		bra.w	ProT_PackInd

*-------------------------------------------------------------------------*
PRun2_InitPlayer:jsr	A5ClearProTemps(a5)
		jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)


		lea	8(a0),a1
		moveq	#31-1,d0
		moveq	#0,d5
		moveq	#0,d2
.PR20_Countsam:	move.w	(a1)+,d2
		add.l	d2,d5
		add.l	d2,d5
		addq.l	#6,a1
		dbf	d0,.PR20_CountSam

		lea	258(a0),a1
		moveq	#$7e,d1
		moveq	#0,d0
.PR20_CountPat:	cmp.b	(a1)+,d0
		bge.s	.pr20_hi
		move.b	-1(a1),d0
.PR20_Hi:	dbf	d1,.PR20_CountPat

		move.l	d0,d7			;Anzahl der Patterns -1
		addq.w	#1,d0
		lea	Pro_InfoBuffer(pc),a4
		move.l	d5,68(a4)		;Calcsize setzen

	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a1			;Zieladresse

		movem.l	a4/a5,-(a7)

;		move.w	#$43c>>2,d1
;.PR20_Clr:	clr.l	(a1)+
;		dbf	d1,.pr20_clr
;
;		move.l	d1,a1
		lea	20+22(a1),a2
		lea	8(a0),a3
		moveq	#31-1,d0
.PR20_Sam:	move.l	(a3)+,(a2)+
		move.l	(a3)+,(a2)+
		lea	30-8(a2),a2
		dbf	d0,.pr20_sam

		lea	$3b6(a1),a2
		lea	256(a0),a3
		move.w	#$82-1,d0
.PR20_Copysinfos:move.b	(a3)+,(a2)+
		dbf	d0,.pr20_copysinfos

	;	move.l	#`M.K.`,$438(a1)

		lea	$43c(a1),a2
		lea	770(a0),a3	;1. Pattern
		lea	642(a0),a4	;1. Patternoffset

		movem.l	d7/a0/a5,-(sp)
		lea	My_Periods(pc),a0
.PR20_ConvertPatts:move.w (a4)+,d0
		lea	(a3,d0.w),a6
		moveq	#64-1,d0
.PR20_ConvertPatt:lea	pro_temp1+bssmerkpuffer,a5
		bsr	.PR20_Conv
		bsr	.PR20_Conv
		bsr	.PR20_Conv
		bsr	.PR20_Conv
		dbf	d0,.PR20_ConvertPatt
		dbf	d7,.PR20_ConvertPatts
		movem.l	(sp)+,d7/a0/a5

		add.l	4(a0),a0
	;	addq.w	#1,d7
	;	mulu	#1024,d7
	;	add.l	#$43c,d7
	;	lea	(a1,d7.l),a1
		movem.l	(a7)+,a4/a5
		move.l	a0,SamplePointer(a5)
		move.l	Ori_data(a5),a1
		sub.l	a1,a0
		move.l	a0,d0
		add.l	d0,68(a4)		;Calcsize setzen
		move.l	d0,52(a4)		;Songsize setzen

	*--------- Zum ProTracker-InitPlayer hpfen --------*
		moveq	#1,d1			;convertiertes Module geladen
		bra.w	ProT_PackInd


	*----------- Jetzt beginnt das Convertieren ------------*
.PR20_Conv:	moveq	#0,d1
		moveq	#0,d2

		move.b	(a6)+,d1
		bpl.s	.PR20_DoChan

		btst	#6,d1
		beq.s	.PR20_ChanReady

		move.l	(a5),d2
		bra.s	.PR20_ChanReady

.PR20_DoChan:	moveq	#0,d3
		clr.l	(a5)
	
		lsr.b	#1,d1
		bcc.s	.NoSet0
		moveq	#1,d3
.NoSet0:	move.b	(a6),d4
		lsr.b	#3,d4
		bclr	#0,d4
		or.b	d4,d3
		lsl.b	#4,d3
		bcc.s	.No10			;samplenummer ber $10 ?
		move.b	#$10,(a5)		;Samplenummer Hi Teil
.No10:		move.b	d3,2(a5)		;Samplenummer low Teil
		move.b	(a6)+,d3
		and.b	#$f,d3
		or.b	d3,2(a5)		;Kommando

		move.b	(a6)+,3(a5)		;Arg
		add.w	d1,d1
		move.w	(a0,d1.w),d1		;Periode holen
		or.w	d1,(a5)			;Periode
	
		move.l	(a5),d2
.PR20_ChanReady:move.l	d2,(a2)+
		addq.l	#4,a5
		rts




*--------------------------------------------------------------------------*
UNIC_InitPlayer:jsr	A5ClearProTemps(a5)
		jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)
		move.l	a0,a1

	*---------- Anzahl der Pattern berechnen ----------*
		lea	$3B8(a0),a2		;Berechne Gre des Songs
		moveq	#$7F,d3			;Anzahl Patterns/Patterngesamtlnge
		moveq	#0,d1
.Unic_Patt2:	move.l	d1,d0
		subq.w	#1,d3
.Unic_Patt3:	move.b	(a2)+,d1
		cmp.b	d0,d1
		bgt.s	.Unic_Patt2
		dbra	d3,.Unic_Patt3
		addq.w	#1,d0				;num Patts
		move.l	d0,d5

	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn

		move.l	a1,a0
		move.l	d1,a1			;Zieladresse
		bsr	copystinfos

		move.l	d1,a0

		lea	22+2+20(a0),a2
		moveq	#31-1,d0
.unic_finetune
		move.b	-3(A2),d1
		neg.b	d1
		and.b	#$f,d1
		move.b	d1,(a2)
		clr.w	-4(A2)
		lea	30(a2),a2
		dbf	d0,.unic_finetune

		move.l	Ori_Data(a5),a1
		lea	$43c(a0),a0		;Dest
		lea	$43c(a1),a1		;Source
		lea	Unic_Temp(a5),a2
		lea	My_Periods(pc),a3
		asl.l	#8,d5			;mal 64*4

Unic_MakePatts: move.b	(a1)+,(a2)
		move.b	(a1)+,1(a2)
		move.b	(a1)+,2(a2)

		move.b	1(a2),d0		;Kommando & Samplenummer Low Teil
		lsl.w	#8,d0
		or.b	2(a2),d0		;Kommando-Argument

		move.w	d0,2(a0)

		move.b	(a2),d0			;Periodenzeiger
						;mit 2 multiplizieren = Offset
						;zu My_Periods2
		and.w	#$3F,d0			;ausmaskieren,da Bit 6 Samplenummer
						;ber 15 anzeight 
		add.w	d0,d0
		move.w	(a3,d0.w),d0
		move.w	d0,(a0)			;Periode

		move.b	(a2),d0			;Samplenummer Hi-Teil
		and.b	#$40,d0
		lsr.b	#2,d0
		or.b	d0,(a0)

		move.b	2(a0),d0		;Kommando holen
		and.b	#$f,d0
		beq.s	.NoBreak
		cmp.b	#$d,d0
		bne.s	.NoBreak
		moveq	#0,d0
		move.b	3(a0),d0
		divu	#10,d0
		move.w	d0,d1
		lsl.w	#4,d1
		swap	d0
		add.w	d0,d1
		move.b	d1,3(a0)
.NoBreak:	add.l	#4,a0
		subq.l	#1,d5
		bne	Unic_MakePatts

		move.l	a1,a0

		bra	Standardgopackind

*--------------------------------------------------------------------------*
UNIC2_InitPlayer:jsr	A5ClearProTemps(a5)
		jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)
		move.l	a0,a1

		lea	Pro_InfoBuffer(pc),a4

		lea	$3A4(a1),a2		;Berechne Gre des Songs
		moveq	#$7F,d3			;Anzahl Patterns/Patterngesamtlnge
		moveq	#0,d1
.Unic2_Check2:	move.l	d1,d5
		subq.w	#1,d3
.Unic2_Check3:	move.b	(a2)+,d1
		cmp.b	d5,d1
		bgt.s	.Unic2_Check2
		dbra	d3,.Unic2_Check3
		addq.w	#1,d5				;num Patts

		lea	$16(a1),a2
		moveq	#30,d2
		;moveq	#0,d3
.Unic2_AddSample:
		;moveq	#0,d0
		;move.w	(a2),d0
		;beq.s	.Unic2_NoSample
		;add.l	d0,d3
		;add.l	d0,d3
.Unic2_NoSample:move.w	4(a2),d0
		add.w	d0,d0
		move.w	d0,4(a2)
		lea	$1e(a2),a2
		dbf	d2,.Unic2_AddSample
						;d3 = Samplesize
;		move.l	d3,68(a4)		;Calcsize setzen


	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		move.l	d5,d0
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a3			;----------->


	;	move.w	#1024,d0
	;	mulu	d5,d0
	;	add.l	#$43C,d0
	;	add.l	d3,d0
	;	move.l	a1,-(sp)
	;	bsr	Allocextra
	;	move.l	(sp)+,a1

	;	tst.l	d0
	;	beq.w	.id_err

		move.l	d1,a0			;Zieladresse
		lea	(a1),a3
		move.l	a0,a2

		move.l	(a3)+,(a2)+		;20 Zeichen
		move.l	(a3)+,(a2)+
		move.l	(a3)+,(a2)+
		move.l	(a3)+,(a2)+
		move.l	(a3)+,(a2)+
		clr.b	-1(a2)

		lea	(a1),a3
		move.w	#$424>>2,d0
.Unic2_Copy:	move.l	(a3)+,(a2)+
		dbf	d0,.Unic2_Copy

		lea	22+2+20(a0),a2
		moveq	#31-1,d0
.unic_finetune
		move.b	-3(A2),d1
		neg.b	d1
		and.b	#$f,d1
		move.b	d1,(a2)
		clr.w	-4(A2)
		lea	30(a2),a2
		dbf	d0,.unic_finetune

		lea	$43c(a0),a0		;Dest
		lea	$424(a1),a1		;Source
		lea	Unic_Temp(a5),a2
		lea	My_Periods(pc),a3
		asl.l	#8,d5			;mal 64*4
		bra	Unic_Makepatts

*--------------------------------------------------------------------------*
NR_InitPlayer:	jsr	A5ClearProTemps(a5)
		jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

		bsr.w	BerechPattern


	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a3			;----------->

		move.l	Ori_Data(a5),a0
		lea	$3ae(a3),a4		;last Sample MT		
		lea	$1e0(a0),a2		;letztes Sample Sanity
		moveq	#$1e,d1
.NR_Loop1:	move.w	12(a2),6(a4)	;Rplen
		move.w	(a2),2(a4)	;Lautstrke
		move.w	6(a2),(a4)	;Lnge
		move.l	8(a2),d0
		sub.l	2(a2),d0
		lsr.w	#1,d0
		move.w	d0,4(a4)	;Rpstart
		sub.l	#$1e,a4
		subq.l	#8,a2
		subq.l	#8,a2
		dbf	d1,.NR_Loop1

	move.w	$3b6(a0),$3b6(a3)
	lea	$3B8(a0),a1		;Patternnummern
	lea	$3B8(a3),a4		;Patternnummern
	moveq	#$7F,d0
	moveq	#0,d1
.NR_InitP2:
	move.l	d1,d2
	subq.w	#1,d0
.NR_InitP3:
	move.b	(a1)+,d1
	move.b	d1,(a4)+
	cmp.b	d2,d1
	bgt.s	.NR_InitP2
	dbra	d0,.NR_InitP3
	addq.b	#1,d2
	asl.l	#8,d2
	asl.l	#2,d2			;In Bytes
	lea	$43c(a0),a0		;Zeiger auf Patterns
	lea	$43c(a3),a3		;Zeiger auf Patterns
	lea	My_Periods(pc),a1
.NR_ConLoop:
	move.l	(a0),d3

	swap	d3
	move.w	d3,d0

	and.w	#$3c00,d0
	lsr.w	#2,d0

	cmp.w	#$300,d0
	bne.s	.no3
	moveq	#0,d0
	bra.s	.com
.no3
	cmp.w	#0,d0
	bne.s	.com
	move.w	#$300,d0
.com
	or.b	d3,d0
	move.w	d0,d3

	move.w	d3,2(A3)
	swap	d3

	move.b	d3,d0		;Samplenummer*8
	lsr.b	#3,d0		;durch 8

	lsr.w	#8,d3		;Sampleperiode holen (als Offset)
	and.w	#$ff,d3
	beq.s	.none
	move.w	(A1,d3.w),d3	;echte Periode (als Wert holen)
.none
	move.w	d3,(a3)		;Sichern
	move.b	d0,d3
	and.b	#$f0,d0
	or.b	d0,(a3)
	and.b	#$f,d3
	lsl.b	#4,d3
	or.b	d3,2(a3)

	addq.l	#4,a0
	addq.l	#4,a3
	subq.l	#4,d2
	bgt	.NR_Conloop

	move.l	a0,SamplePointer(a5)
	bra	Standardgopackind

*--------------------------- Wantonpacker-InitPlayer -------------------------*
WN_Initplayer:	jsr	A5ClearProTemps(a5)
		jsr	A5ClrInfoBuffer(a5)

		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

		bsr.w	BerechPattern
		move.l	d0,d6

	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a4			;----------->

		move.l	d1,a1
		bsr.w	CopySTInfos		;Copy Infos

		lea	$43c(a0),a1
		lea	$43c(a4),a4
		lsl.l	#8,d6		;mal 64*4
		lea	My_Periods(pc),a3
		lea	Unic_Temp(a5),a2

.WN_DoPatts:	move.l	(a1)+,(a2)

		move.b	1(a2),d2		;Samplenummer
		moveq	#0,d3
		move.b	(a2),d3			;Nummer des Period-Wertes
		move.w	(a3,d3.w),d3		;Periode holen
		move.w	d3,(a2)			;sichern
		move.b	d2,d3
		and.b	#$f0,d2
		or.b	d2,(a2)
		lsl.b	#4,d3
		and.b	#$f0,d3
		or.b	d3,2(a2)
		move.l	(a2),(a4)+
		dbf	d6,.wn_dopatts
	
		move.l	a1,a0
		bra	Standardgopackind

*----------------------- XANN-Packer-InitPlayer -----------------------------*
XA_Initplayer:
	jsr	A5ClearProTemps(a5)
	jsr	A5ClrInfoBuffer(a5)

	moveq	#0,d0
	move.l	dtg_GetListData(a5),a0	; Function
	jsr	(a0)
	move.l	a0,Ori_Data(a5)

	move.w	#128,d0
	lea	(a0),a1
	moveq	#0,d2
	move.l	#$ffffff,d3
.xa_checkpat
	move.l	(a1)+,d1
	beq.s	.xa_lo2

	cmp.l	d1,d3
	blt.s	.xa_lo1
	move.l	d1,d3
.xa_lo1

	cmp.l	d1,d2
	bgt.s	.xa_hi1
	move.l	d1,d2
.xa_hi1
.xa_lo2
	dbf	d0,.xa_checkpat

					;in D3 kleinstes
					;in D2 grtes Pattern
	and.l	#~$fff,d3
	or.w	#$43c,d3

	move.l	d2,d4
	sub.l	d3,d4

	lsl.l	#6,d4				;durch $400
	swap	d4				;dividieren
						;= Anz Patterns
	addq.w	#1,d4
	move.l	d4,d0				;Lnge der Patterns

	bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
	bne.w	Pro_CReturn
	move.l	d1,a3

	lea	$204(a0),a1			;1. Sampleinfo
	lea	42(a3),a2
	moveq	#30,d0
.xa_dosam
	move.w	2(a1),d1
	move.w	d1,2(a2)			;Vol
	move.w	14(a1),(a2)			;Size
	move.w	8(a1),6(A2)			;Repeatlength
	move.l	4(a1),d1
	sub.l	10(a1),d1
	lsr.l	#1,d1
	move.w	d1,4(a2)
	lea	30(a2),a2
	lea	16(A1),a1
	dbf	d0,.xa_dosam

	lea	$3b6(a3),a2			;Songlnge
	lea	(A0),a1
	moveq	#-1,d0
.xa_length
	addq.w	#1,d0
	tst.l	(a1)+
	bne.s	.xa_length	

	move.b	d0,(a2)+
	clr.b	(a2)+	

	lea	(a0),a1
	subq.w	#1,d0
.xa_dosong
	move.l	(A1)+,d1
	sub.l	d3,d1
	divu	#$400,d1
	move.b	d1,(a2)+
	dbf	d0,.xa_dosong

	move.l	#`M.K.`,$438(a3)
	lea	$43c(a3),a2
	lea	$43c(a0),a1

	mulu	#64*4,d4			;1 Patt
	subq.w	#1,d4				;wegen DBF
	lea	my_periods(pc),a4
.xa_dopatts
	clr.l	(a2)
	move.b	(a1),d1				;Samplenummer
	move.b	d1,d2
	lsl.b	#1,d1
	lsr.b	#3,d2
	and.b	#$f0,d1
	move.b	d1,2(a2)			;lo-Teil
	and.b	#$f0,d2
	move.b	d2,(a2)				;hi-Teil

	moveq	#0,d1
	moveq	#0,d2
	move.b	1(a1),d1
	move.w	(a4,d1.w),d2
	or.w	d2,(a2)				;Periode

	moveq	#0,d3
	move.b	3(a1),d2			;Argument
	move.b	2(a1),d1			;Kommando
	beq.w	.xa_com

	cmp.b	#$48,d1				;0c
	bne.s	.xa_no01
	moveq	#$0c,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no01
	cmp.b	#$8,d1				;1
	bne.s	.xa_no1
	moveq	#1,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no1
	cmp.b	#$c,d1				;2
	bne.s	.xa_no2
	moveq	#2,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no2
	cmp.b	#$10,d1				;3
	bne.s	.xa_no3
	moveq	#3,d1
	bra.w	.xa_com
.xa_no3
	cmp.b	#$14,d1				;3
	bne.s	.xa_no4
	moveq	#3,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no4
	cmp.b	#$18,d1				;4
	bne.s	.xa_no5
	moveq	#4,d1
	bra.w	.xa_com
.xa_no5
	cmp.b	#$1c,d1				;4
	bne.s	.xa_no6
	moveq	#4,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no6
	cmp.b	#$20,d1				;5
	bne.s	.xa_no7
	moveq	#5,d1
	asl.w	#4,d2
	move.b	d2,d3
	bra.w	.xa_com
.xa_no7
	cmp.b	#$24,d1				;5
	bne.s	.xa_no8
	moveq	#5,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no8
	cmp.b	#$28,d1				;6
	bne.s	.xa_no9
	moveq	#6,d1
	asl.w	#4,d2
	move.b	d2,d3
	bra.w	.xa_com
.xa_no9
	cmp.b	#$2c,d1				;6
	bne.s	.xa_no10
	moveq	#6,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no10
	cmp.b	#$38,d1				;9
	bne.s	.xa_no11
	moveq	#9,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no11
	cmp.b	#$3c,d1				;0a
	bne.s	.xa_no12
	moveq	#$0a,d1
	asl.w	#4,d3
	move.b	d2,d3
	bra.w	.xa_com
.xa_no12
	cmp.b	#$40,d1				;0a
	bne.s	.xa_no13
	moveq	#$0a,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no13
	cmp.b	#$44,d1				;0b
	bne.s	.xa_no14
	moveq	#$0b,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no14
	cmp.b	#$4c,d1				;0d
	bne.s	.xa_no15
	moveq	#$0d,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no15
	cmp.b	#$50,d1				;0f
	bne.s	.xa_no16
	moveq	#$f,d1
	move.b	d2,d3
	bra.w	.xa_com
.xa_no16
	cmp.b	#$54,d1				;e00
	bne.s	.xa_no17_1
	moveq	#$0e,d1
	bra.w	.xa_com
.xa_no17_1
	cmp.b	#$58,d1				;e01
	bne.s	.xa_no17
	moveq	#$0e,d1
	moveq	#1,d3
	bra.w	.xa_com
.xa_no17
	cmp.b	#$5c,d1				;e10
	bne.s	.xa_no18
	moveq	#$0e,d1
	move.b	d2,d3
	and.b	#$f,d3
	or.b	#$10,d3
	bra.w	.xa_com
.xa_no18
	cmp.b	#$60,d1				;e20
	bne.s	.xa_no19
	moveq	#$0e,d1
	move.b	d2,d3
	and.b	#$f,d3
	or.b	#$20,d3
	bra.s	.xa_com
.xa_no19
	cmp.b	#$84,d1				;e90
	bne.s	.xa_no20
	moveq	#$0e,d1
	move.b	d2,d3
	and.b	#$f,d3
	or.b	#$90,d3
	bra.s	.xa_com
.xa_no20
	cmp.b	#$88,d1				;ea0
	bne.s	.xa_no21
	moveq	#$0e,d1
	move.b	d2,d3
	and.b	#$f,d3
	or.b	#$A0,d3
	bra.s	.xa_com
.xa_no21
	cmp.b	#$8c,d1				;eb0
	bne.s	.xa_no22
	moveq	#$0e,d1
	move.b	d2,d3
	and.b	#$f,d3
	or.b	#$B0,d3
	bra.s	.xa_com
.xa_no22
	cmp.b	#$8c,d1				;ec0
	bne.s	.xa_no28
	moveq	#$0e,d1
	move.b	d2,d3
	and.b	#$f,d3
	or.b	#$C0,d3
	bra.s	.xa_com
.xa_no28
	cmp.b	#$94,d1				;ed0
	bne.s	.xa_no23
	moveq	#$0e,d1
	move.b	d2,d3
	and.b	#$f,d3
	or.b	#$D0,d3
	bra.s	.xa_com
.xa_no23
	cmp.b	#$98,d1				;ee0
	bne.s	.xa_no24
	moveq	#$0e,d1
	move.b	d2,d3
	and.b	#$f,d3
	or.b	#$E0,d3
	bra.w	.xa_com
.xa_no24

.xa_com
	or.b	d1,2(a2)
	move.b	d3,3(a2)

	addq.l	#4,a2
	addq.l	#4,a1
	dbf	d4,.xa_dopatts
						;A1 = 1. Sample XANN
						;A2 = 1. Sample Protracker
	move.l	a1,a0
	bra	Standardgopackind

*----------------------------- ProRunner-InitPlayer --------------------------*
PRun_Initplayer:jsr	A5ClearProTemps(a5)
		jsr	A5ClrInfoBuffer(a5)

		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

		bsr.w	BerechPattern
		move.l	d0,d6

	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a4			;----------->

		move.l	d1,a1
		bsr.w	CopySTInfos		;Copy Infos

		move.l	#1024/4,d4		;are Longwords)
		mulu	d6,d4
		subq.l	#1,d4
		lea	$43c(a0),a1
		lea	$43c(a4),a4
		lea	Unic_Temp(a5),a2
		lea	My_Periods(pc),a3
.Prun_Change:	move.l	(a1)+,(a2)
		move.b	(a2),d2			;Samplenummer
		moveq	#0,d3
		move.b	1(a2),d3		;Nummer des Period-Wertes
		add.w	d3,d3			;da Worte
		move.w	(a3,d3.w),d3		;Periode holen
		move.w	d3,(a2)			;sichern
		move.b	d2,d3
		and.b	#$f0,d2
		or.b	d2,(a2)
		lsl.b	#4,d3
		and.b	#$f0,d3
		or.b	d3,2(a2)
		move.l	(a2),(a4)+
		dbf	d4,.Prun_Change

		move.l	a1,a0
		bra	Standardgopackind

*------------------------------- Kript-InitPlayer ----------------------------*
KR_InitPlayer:	jsr	A5ClrInfoBuffer(a5)

		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		move.l	a0,Ori_Data(a5)

		bsr.w	BerechPattern
		move.l	d0,d6

	*------- Speicher fr PT-Module laden | d0=Pattern --------*
		bsr.w	AllocExtraST		;d0=Error|d1=Addi|d2=Size
		bne.w	Pro_CReturn
		move.l	d1,a4			;----------->

		move.l	d1,a1
		bsr.w	CopySTInfos		;Copy Infos

		move.l	d6,d0
		move.l	#1024/4,d4		;are Longwords)
		mulu	d0,d4
		subq.l	#1,d4
		lea	$43c(a0),a1
		lea	$43c(a4),a4
.KR_Change:	move.l	(a1)+,d0
		sub.l	KriptCode(a5),d0
		move.l	d0,(a4)+
		dbf	d4,.KR_Change

		move.l	a1,a0
		bra	Standardgopackind

*---------------------------- ProTracker-InitPlayer --------------------------*
Pro_InitPlayer:	jsr	A5ClrInfoBuffer(a5)
		moveq	#0,d1			;reines Module geladen
ProT_PackInd:
		move.l	d1,savepackind(a5)
		
		move.l	PufferAdr2,a5
		jsr	A5ClearProTemps(a5)
		move.w	MT_LInstrKennung(a5),MT_InstrKennung(a5)
		moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		lea	MT_Data(pc),a1
		move.l	a0,Ori_Data(a5)		;max Speicheradr

		tst.l	d1
		beq.s	.NoConverted

		cmp.w	#2,d1
		beq.s	.no
		move.w	#2,MT_InstrKennung(a5)	;simuliere Instr.Loading
.no
		lea	Pro_InfoBuffer(pc),a4
		move.l	STExtraMem(a5),d2	;convertiertes Modules
		beq.w	Pro_EndPlayer
		move.l	d2,a0
		move.l	d0,100(a4)		;LoadSize setzen

		cmp.b	#3,d1
		bne.s	.noconverted

		add.l	P56_Loadsize(pc),d0
		move.l	d0,100(a4)

.NoConverted:	move.l	a0,(a1)
		move.l	d0,MT_Size-MT_Data(a1)
		move.l	#"M.K.",$438(a0)	;Kennung setzen

	*--------------- FastRamReplayer initialisieren ----------------*
		lea	FastLoad(pc),a2
		clr.b	(a2)

		cmp.b	#3,d1
		beq.w	.BleibtImChip

		move.l	Ori_Data(a5),a1
		move.l	4,a6
		jsr	_LVOTypeOfMem(a6)
		btst	#1,d0
		bne.w	.BleibtImChip

*--- Module wurde in FastRam geladen. Nun testen, ob Module im ChipRam ----*
*--- liegen mu, weil es mit der Kopierroutine noch mehr Speicher      ----*
*--- brauchen wrde							---*
		tst.b	OnLoadFast(a5)		;was soll das ?
		beq.w	.BleibtImChip		;Wenn Modul im Fast liegt
						;und OnLoadFast off ist
						;kommt es sowieso zu shit !

		cmp.w	#1,MT_InstrKennung(a5)	;Handelt es sich um einen
		beq.w	.BleibtImChip		;ST-Song

	*------- Module liegt im FASTMem -------*
.BleibtImFast:	lea	FastLoad(pc),a2
		move.b	#1,(a2)

		lea	pro_infobuffer(pc),a0
		move.l	#1024,108(a0)			;Chipsize
		move.l	MT_Size(pc),116(a0)		;other Size

		LA1	LNr_ModulImFastMem
		move.l	a1,124(a0)

	*----- Module eventuell reparieren ------*
.BleibtImChip:	move.l	MT_Data(pc),a0		;wegens die Sicherheit
		bsr	FixMod

	*------ Protracker GetInfo-Routine ------*
		move.l	STExtraMem(a5),d0
		beq.s	.NoConvertedSize
		move.l	d0,a1
		Execbase
		jsr	_LVOTypeOfMem(a6)
		lea	Pro_InfoBuffer(pc),a0
		move.l	ConvertedSize(a5),d1
		move.l	d1,132(a0)		;MI_ConvertedSongSize
		sub.l	#1048+MemDrauf,132(a0)	;-zustzlich allocierten mem
		btst	#1,d0
		bne.w	.ConvertedInChip

		add.l	d1,116(a0)			;other Size
		moveq	#0,d1
.ConvertedInChip:add.l	d1,108(a0)			;ChipSize
.NoConvertedSize:lea	Pro_InfoBuffer(pc),a0
		move.l	MT_Data(pc),a1
		move.w	#31,28+2(a0)		;max Samples

		lea	MyPRO_Songname(pc),a2
		move.l	a2,4(a0)		;Songname setzen
		move.l	(A1),(a2)
		move.l	4(A1),4(a2)
		move.l	8(A1),8(a2)
		move.l	12(A1),12(a2)
		move.l	16(A1),16(a2)

		move.l	a1,a2
		lea	$2a(a1),a1
	*------------- SampleSize berechnen ----------*
;		tst.l	20(a0)
;		bne.s	.SetNoSampleAnz
		moveq	#30,d2
		moveq	#0,d3
.AddSample:	moveq	#0,d0
		move.w	(a1),d0
		beq.s	.NoAddSample
		addq.l	#1,20(a0)		;zur sampleanz dazuaddieren
		add.l	d0,d3
		add.l	d0,d3
.NoAddSample:	add.l	#$1e,a1
		dbf	d2,.AddSample

.SetNoSampleAnz:moveq	#0,d4
		move.l	d3,-4(a0)		;Unpackedsize (Samplesize)
		tst.l	68(a0)
		bne.s	.SetNoGesamtSize
		move.l	d3,d4		;68(a0)		;Gesamtgre
.SetNoGesamtSize:tst.l	60(a0)
		bne.s	.SetNoSampleSize
		move.l	d3,60(a0)		;Samplesize
.SetNoSampleSize:move.l	MT_Size(pc),d2

	*----------------- Loadsize setzen ----------------*
		move.w	MT_InstrKennung(a5),d0
		beq.s	.NoSong
		cmp.w	#2,d0
		beq.s	.nosong
		tst.l	STExtraMem(a5)
		beq.s	.weihier
		add.l	d3,100(a0)
		bra.s	.setnoloadsize
.weihier
		add.l	d3,d2
.NoSong:
		tst.l	100(a0)
		bne.s	.setnoloadsize
		move.l	d2,100(a0)		;SampleSize fr Loadsize

	*-------------- Highest Pattern berechnen ---------*
.SetNoLoadSize:	tst.l	36(a0)
		bne.s	.SetNoLength
		move.l	MT_data(pc),a1
		move.b	$3b6(a1),39(a0)		;Length setzen
.SetNoLength:	move.l	44(a0),d0
		bne.s	.SetNoPattern
		bsr.w	BerechPattern2
		move.l	d0,44(a0)		;PatternAnz setzen

	*---------------- Songsize berechnen ---------------*
.SetNoPattern:	move.l	#1024,d2		;d0-PatternSize
		mulu	d0,d2

		move.l	#1084,d1
		add.l	d2,d1
		tst.l	52(a0)
		bne.s	.SetNoSongSize
		move.l	d1,52(a0)		;Zur SongSize dazuaddieren
.SetNoSongSize:	add.l	d1,-4(a0)		;Unpackedsize (Songsize)

	;	add.l	d4,d1

		tst.l	68(a0)
		bne.w	.SetNoGesamtSize2

	;	add.l	d1,68(a0)		;Gesamtgre

		move.l	52(a0),d1
		add.l	60(a0),d1
		move.l	d1,68(a0)

.SetNoGesamtSize2:
		move.l a2,a0
		jsr	A5BerechStringSize(a5)
		tst.l	d0
		bne.s	.SongNameDa
		moveq	#31,d1
		lea	TitlenamePuffer(a5),a0
.FindPoint:	subq.l	#1,d1
		move.b	(a0)+,d0
		beq.s	.SongNameDa
		cmp.b	#".",d0
		bne.s	.FindPoint
		cmp.w	#19,d1
		blo.s	.Stringsizeok
		moveq	#19,d1
.Stringsizeok:	move.l	a2,a1
		jsr	A5StringCopy2(a5)

.SongNameDa:	lea	Pro_InfoBuffer(pc),a0
		moveq	#4,d0
		lea	Pro_NamePuffer(pc),a1
.CopyName:	move.l	(a2)+,(a1)+
		dbf	d0,.CopyName

*--------------------------------------------------------------------*
*------------------ Composer eines Musicstckes finden --------------*
*---- ARG1 = Start des Samples					-----*
*---- ARG2 = Offset to next Samples				-----*
*---- ARG3 = Length of Samplename				-----*
*---- ARG4 = Sampleanzahl					-----*
*---- Ergebnis = Arg1 = Pointer to Author			-----*
*---- Ergebnis = Arg2 = Size of Authorname			-----*
*--------------------------------------------------------------------*
		move.l	MT_Data(pc),a1
		lea	20(a1),a1
		move.l	a1,EPG_Arg1(a5)
		moveq	#30,d0
		move.l	d0,EPG_Arg2(a5)
		moveq	#20,d0
		move.l	d0,EPG_Arg3(a5)
		moveq	#31,d0
		move.l	d0,EPG_Arg4(a5)
		moveq	#4,d0
		move.l	d0,EPG_ArgN(a5)
		move.l	EPG_FindAuthor(a5),a1
		jsr	(a1)
		move.l	EPG_Arg1(a5),12(a0)		;AuthorAdr lschen

		lea	AllocMenuMem-10,a0
		move.w	16+10(a0),d0
		sub.w	#$2c79,d0		 ;move.l #??,a6
		add.w	d0,EPG_Wordreserved8(a5) ;+-+- Check 1 !!

	*------ Audio-Kanle allocieren -----*
;		jsr	ENPP_AllocAudio(a5)	; returncode is already set !
;		bne.s	Pro_EndPlayer
		rts

*---------------------- Protracker & Clones EndPlayer ----------------------*
Pro_MemEndPlayer:moveq	#EPR_NotEnoughMem,d0
Pro_EndPlayer:	move.l	d0,-(a7)
;		move.l	dtg_AudioFree(a5),a0	; Function
;		jsr	(a0)			; returncode is already set !
		move.l	STExtraMem(a5),d0
		beq.s	.NoMem
		Execbase
		move.l	d0,a1
		move.l	ConvertedSize(a5),d0
		beq.s	.NoMem
		jsr	_LVOFreeMem(a6)
.NoMem:		clr.l	STExtraMem(a5)
		clr.l	ConvertedSize(a5)

		bsr.s	ClearPatternInfo

		lea	FastLoad(pc),a2
		clr.b	(a2)

		move.l	(a7)+,d0
		rts
MyPRO_Songname	ds.b	20
		dc.b	0
		even
*----------- Clear PatternInfo + Merkzellen (MT_Data/MT_Size) ---------------*
ClearPatternInfo:move.l	a0,-(a7)
		jsr	A5ClrInfoBuffer(A5)
		lea	MyPattinfo(pc),a0
		clr.l	MT_Data-MyPattinfo(a0)	;bei Bedarf wegnehmen
						;immer !! Adr lschen
		clr.l	MT_Size-MyPattinfo(a0)	;bei Bedarf wegnehmen
						;immer !! Adr lschen
		clr.w	Pi_NumPatts(a0)
		clr.w	Pi_Pattern(a0)
		clr.w	Pi_PattPos(a0)
		clr.l	Pi_Stripes(a0)
		clr.l	Pi_Stripes+4(a0)
		clr.l	Pi_Stripes+8(a0)
		clr.l	Pi_Stripes+12(a0)
		move.l	(a7)+,a0
		rts

*--------------------------------------------------------------------------*
*-------- a0=Moduledata						-----------*
*-------- d0=Patternanz						-----------*
*--------------------------------------------------------------------------*
BerechPattern2:	movem.l	d1-a6,-(a7)
		move.l	MT_Data(pc),a0
		bra.s	BerechPattern3
BerechPattern:	movem.l	d1-a6,-(a7)
BerechPattern3:	lea	$3B8(a0),a1		;Patternnummern
		moveq	#$7F,d2
		moveq	#0,d0
.NR_Check2:
		cmp.b	(A1)+,d0
		bge.s	.hi
		move.b	-1(a1),d0
.hi		dbf	d2,.NR_Check2
		addq.w	#1,d0
		movem.l	(a7)+,d1-a6
		rts


*-------- Copiert die Sample & ModuleInfos nach Converted Data ----------*
*------ a0 = Original-Data		a1=ProtrackerData	---------*
*------------------------------------------------------------------------*
CopySTInfos:	movem.l	d0-a6,-(a7)
		move.w	#($43c/4)-1,d0
.CopyInfos:	move.l	(a0)+,(a1)+
		dbf	d0,.CopyInfos
		movem.l	(a7)+,d0-a6
		rts

*------------------------------------------------------------------------*
*-------------------------- Moduladresse in A1 --------------------------*
*------------------------------------------------------------------------*
FixMod:		movem.l	d0-d4/a0/a2,-(sp)
		lea	42(A0),a2		;Zeiger auf 1. Samplelnge

		moveq	#$1e,d3			;31 Samples
.Loop:		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d4

		and	#$f7f,2(A2)		;Finetune max setzen

		move.w	(a2),d1			;Lnge
		beq.s	.ok
		add.l	d1,d1

		move.w	4(a2),d2		;Repeatstart
		add.l	d2,d2
		move.w	6(a2),d4		;Repeatlnge
		add.l	d4,d4
		add.l	d2,d4
		cmp.l	d4,d1
		bge.s	.ok
		move.w	4(a2),d2
		lsr.w	#1,d2
		move.w	d2,4(a2)
.Ok:		add.l	#30,a2
		dbf	d3,.loop

		movem.l	(sp)+,d0-d4/a0/a2
		rts

*-----------------------------------------------------------------------*
Pro_Save:	moveq	#EPR_NotEnoughMem,d7
		clr.l	Pro_SaveAdr(a5)
		clr.l	Pro_SaveSize(a5)
		move.w	MT_InstrKennung(a5),d0
		beq.w	.SaveProTracker

		subq.w	#2,d0				;2=Converted Kennung
		beq.s	.ModuleLoaded

	*------ Song als Modules saven/Memory zum Saven allocieren ------*
		move.l	Pro_InfoBuffer+68(pc),d0	;Calcsize
		move.l	d0,Pro_SaveSize(a5)
		add.l	#32,d0
		jsr	A5AllocMem(a5)
		move.l	d0,a4			;Speicheradresse
		move.l	d0,a3
		move.l	d0,Pro_SaveAdr(a5)
		tst.l	d0
		beq.w	.Return
		move.l	EPG_LoadedFiles(a5),d5
		subq.l	#2,d5			;Hauptfile & DBF-
		ble.w	.Return
		add.l	Pro_InfoBuffer+68(pc),a3 ;Endadresse
		moveq	#0,d4
		move.l	MT_Data(pc),a2
		move.l	MT_Size(pc),d3		;Size des aktuellen Songs/Samples
		lea	-10(a2),a2
.NextData:	moveq	#EPR_SaveError,d7
		move.l	d4,d0
		move.l	DTG_GetListData(a5),a0
		jsr	(a0)
		tst.l	d0
		blt.w	.Return
		move.l	d3,d0			;Copiersize
.CopyNextByte:	cmp.l	a4,a3
		beq.w	.Return
		move.b	(a0)+,(a4)+
		subq.l	#1,d0
		bne.s	.CopyNextByte
		addq.l	#1,d4

	*---------- Lnge fr nchstes Sample laden --------*
		moveq	#31,d6
		sub.l	d4,d6
.NextSample:	lea	30(a2),a2
		moveq	#0,d3
		move.w	22(a2),d3
		add.l	d3,d3
		bne.s	.SampleLenOk
		dbf	d6,.NextSample
		bra.w	.Return

.SamplelenOk:	dbf	d5,.NextData
		bra.s	.SaveProTracker



	*---------- Es wird ein Module geladen ------------*
.ModuleLoaded:	tst.b	OnSaveAsProT(a5)		;normales Saven
		beq.s	.SaveOriginal

	*--------- Speicher fr Protracker(Convertiert) holen ---------*
	* an dieser Stelle kein Calcsize nehmen, weil mit Songsize und *
	* Samplesize copiert wird. Ist Calcsize ungleich mit diesen,   *
	* kann es Probleme geben				       *

		move.l	Pro_InfoBuffer+44(pc),d0	;Num Patts
		mulu	#1024,d0			;PatternSize
		add.l	#1084,d0			;d0--> Songsize
		move.l	d0,d6
		add.l	Pro_InfoBuffer+60(pc),d0	;Samplesize
		move.l	d0,Pro_SaveSize(a5)
		add.l	#32,d0
		jsr	A5AllocMem(a5)
		move.l	d0,a1				;Speicheradresse
		move.l	d0,Pro_SaveAdr(a5)
		tst.l	d0
		beq.w	.Return

	*---- Nun convertiertes Module zusammensetzen -----*
		move.l	MT_Data(pc),a0
		move.l	d6,d0				;Songsize
	movem.l	d6/a1,-(sp)
		jsr	A5CopyMemQuick(a5)
	movem.l	(sp)+,d6/a1
	add.l	d6,a1

		move.l	SamplePointer(a5),a0		;SampleStart
		move.l	Pro_InfoBuffer+60(pc),d0	;Samplesize
		jsr	A5CopyMemQuick(a5)
		bra.s	.SaveProTracker

.SaveOriginal:	move.l	Ori_Data(a5),a0
		bra.s	.SaveOri2

	*---------------- Nun wird das Module abgespeichert ----------------*
.SaveProTracker:move.l 	Pro_SaveAdr(a5),a0		;Adr
		move.l	Pro_SaveSize(a5),d1		;Size
		bne.s	.SongLoaded
		move.l	MT_Data(pc),a0			;Adr
.SaveOri2:	move.l	MT_Size(pc),d1			;Size
		move.l	Pro_InfoBuffer+68(pc),d2
		cmp.l	d2,d1
		blo.s	.SongLoaded
		move.l	d2,d1
.SongLoaded:
		move.l	a0,EPG_Arg1(a5)
		move.l	d1,EPG_Arg2(a5)
		lea	PathPuffer(a5),a0
		move.l	a0,EPG_Arg3(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		moveq	#5,d0
		move.l	d0,EPG_Argn(a5)
		jsr	A5SaveMem(a5)
		move.l	d0,d7				;Error merken


	*------------------- Hilfsmem freigeben -----------------*
.Return:	move.l	Pro_SaveAdr(a5),d0
		beq.s	.NoHilfsMod
		move.l	d0,a1
		move.l	Pro_SaveSize(a5),d0
		beq.s	.NoHilfsMod
		add.l	#32,d0
		move.l	4.w,a6
		jsr	_LVOFreeMem(a6)
		clr.l	Pro_SaveAdr(a5)
		clr.l	Pro_SaveSize(a5)
.NoHilfsMod:	move.l	d7,d0
		tst.l	d0			;ReturnMeldung
		rts

*--------------------- Initialisiere Patterninfo Struktur -------------------*
Pro_Pattinit	suba.l	a0,a0
		move.l	MT_Data(pc),d0
		beq	.rts
		move.l	d0,a1

		lea	MyPattInfo(pc),a0
		move.b	$3b6(a1),pi_maxsongpos+1(a0)
		lea	$3b8(A1),a2
		moveq	#0,d1
		moveq	#$7f,d0
.hipatt:	cmp.b	(A2)+,d1
		bge.s	.ok
		move.b	-1(a2),d1
.ok		dbf	d0,.hipatt
		addq.w	#1,d1
		move.w	d1,pi_numpatts(A0)

		lea	pattconv(pc),a1
		move.l	a1,PI_Convert(A0)

		move.w	#64,PI_Pattlength(a0)
		move.w	#4,PI_Voices(a0)
		move.l	#16,PI_Modulo(a0)
.rts:		rts

*----------------------------------------------------------------------------*
Pattconv:	moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3

		move.b	(a0),d0			;Pointer to Note
		and.b	#$10,d0
		move.b	2(a0),d1
		lsr.b	#4,d1
		or.b	d0,d1			;Samplenumber
		move.w	(A0),d0
		and.w	#$fff,d0		;Period
		move.b	2(A0),d2
		and.w	#$0f,d2
		move.b	3(a0),d3		;Argument
		rts

MyPattinfo:	ds.b	PI_stripes+4*4		;Struktur


*-----------------------------------------------------------------------------*
Sampleinit	moveq	#15-1,d6
		bra.s	Samplein
Pro_SampleInit:
		moveq	#30,d6			;max Samples
Samplein:
		moveq	#EPR_NotEnoughMem,d7

		move.l	MT_Data(pc),d0
		beq.s	.Return
		move.l	d0,a4
		lea	20(a4),a4

	*----------- SampleInfo-Struktur anlegen ----------*
		lea	Pro_Samplestarts(pc),a2

		lea	PRO_FirstSInfo(pc),a3
.NextSample:	jsr	EPP_AllocSampleStruct	;Frischer leerer Speicher !!!
		move.l	d0,(a3)
		beq.s	.Return
		move.l	d0,a3

		move.l	a4,EPS_SampleName(a3)
		move.l	(a2),EPS_Adr(a3)

		moveq	#0,d0			;Samplelength setzen
		move.w	22(a4),d0
		add.l	d0,d0
		move.l	d0,EPS_Length(a3)

		moveq	#0,d0
		move.b	24(a4),d0
		sub.b	#16,d0
		ext.w	d0
		move.w	d0,EPS_Finetune(a3)

		moveq	#0,d0
		move.b	25(a4),d0
		move.l	d0,EPS_Volume(a3)

		moveq	#0,d0			;Samplereplen setzen
		move.w	26(a4),d0
		add.l	d0,d0
		move.w	d0,EPS_Replen+2(a3)

		moveq	#0,d0			;Samplerepeat setzen
		move.w	26(a4),d0
		add.l	d0,d0
		move.w	d0,EPS_Repeat+2(a3)

		move.w	#3!USIB_8Bit,EPS_Flags(a3)
		move.w	#22,EPS_MaxNameLen(a3)


		addq.l	#4,a2			;SamplePointer erhhen
		lea	30(a4),a4
		dbf	d6,.NextSample

		moveq	#0,d7			;Kein Error
.Return:	move.l	d7,d0
		move.l	Pro_FirstSInfo(pc),EPG_SampleInfoStructure(a5)
		rts
;*-----------------------------------------------------------------------*
;*		d0 Bit 0-3 = Set Voices Bit=1 Voice on			*
;PR_SetVoices:	move.l	StructAdr(pc),a0
;		move.w	EPG_Voices(a5),UPS_DmaCon(a0)
;		lea	MT_VolVoice1(pc),a1
;		move.l	EPG_Voice1Vol(a5),(a1)
;		move.l	EPG_Voice3Vol(a5),4(a1)
;
;		move.l	StructAdr(pc),a0
;		lea	$dff0a0,a5
;		moveq	#3,d1
;.SetNew		moveq	#0,d0
;		move.w	UPS_Voice1Vol(a0),d0
;		bsr.s	Pro_SetVoices
;		moveq	#UPS_Modulo,d0
;		add.l	d0,a0
;		addq.l	#8,a5
;		addq.l	#8,a5
;		dbf	d1,.SetNew
;		rts

*-----------------------------------------------------------------------*
Pro_SetVoices:	movem.l	a0/d0/d1/a4,-(a7)
		move.l	PufferAdr2,a4
		move.w	EPG_Voices(a4),d1

		and.w	#$7f,d0
		cmp.w	#$40,d0
		blo.s	.NoBiggest
		moveq	#$40,d0
.NoBiggest:
		move.l	StructAdr(pc),a0
		cmp.l	#$dff0a0,a5			;Left Volume
		bne.s	.NoVoice1
		move.w	d0,UPS_Voice1Vol(a0)

		btst	#0,d1
		bne.s	.setit
		clr.w	d0
		bra.b	.SetIt

.NoVoice1:	cmp.l	#$dff0b0,a5			;Right Volume
		bne.s	.NoVoice2
		move.w	d0,UPS_Voice2Vol(a0)

		btst	#1,d1
		bne.s	.setit
		clr.w	d0
		bra.b	.SetIt

.NoVoice2:	cmp.l	#$dff0c0,a5			;Right Volume
		bne.s	.NoVoice3
		move.w	d0,UPS_Voice3Vol(a0)

		btst	#2,d1
		bne.s	.setit
		clr.w	d0
		bra.b	.SetIt

.NoVoice3:	move.w	d0,UPS_Voice4Vol(a0)

		btst	#3,d1
		bne.s	.setit
		clr.w	d0

.SetIt:
		move.l	EPG_ActiveAmplifier+BSSMerkPuffer,d1
		bne.s	.poke
		move.w	d0,8(a5)
		bra.s	.Return
.poke		bsr	pokevol				;move.w	d0,8(a5)
.Return:	movem.l	(a7)+,a4/a0/d0/d1
		rts

*----------------------------------------------------------------------------*
PRO_GetVoice:	movem.l	d0/d1/a1,-(a7)
;		move.b	FastLoad(pc),d1
;		bne.s	.ori

		move.l	Structadr(pc),a1	;1.Kanal
		cmp.l	#$dff0a0,a5
		beq.s	.yes
		lea	UPS_Modulo(a1),a1	;2.Kanal
		cmp.l	#$dff0b0,a5
		beq.s	.yes
		lea	UPS_Modulo(a1),a1	;3.Kanal
		cmp.l	#$dff0c0,a5
		beq.s	.yes
		lea	UPS_Modulo(a1),a1	;4.Kanal
.Yes:		move.w	$10(a6),d0
		move.w	d0,UPS_Voice1Per(a1)
		move.l	4(a6),UPS_Voice1Adr(a1)		;Sampleadresse
		moveq	#1,d1
		cmp.w	#2,14(a6)		;Repeat ?
		blo.s	.Ok
		moveq	#0,d1			;ja,Repeat "on" setzen
.Ok:		move.w	d1,UPS_Voice1Repeat(a1)
		move.w	8(a6),UPS_Voice1len(a1)	;Lnge
;.ori
		movem.l	(a7)+,d0/d1/a1
		rts

*--------------------------------------------------------------------------*
Pro_NextPattern:lea	Pro_SongPos(pc),a0
		moveq	#0,d0
		move.l	MT_Data(pc),a3
		move.b	950(a3),d0
		subq.b	#1,d0
		cmp.b	(a0),d0
		bne.s	.NormalAdd

		jsr	DT_SongEnd		;End of Song for Playerprogram

		move.b	#-1,(a0)			;Pos=FF		
.NormalAdd:	addq.b	#1,(a0)
Pro_Set:	move.b	(a0),d0				;SongPos lesen

		clr.b	pro_counter-Pro_songpos(a0)	;Counter clearen
		clr.w	Pro_Patternpos-pro_songpos(a0)	;PattPos clearen
		rts

*--------------------------------------------------------------------------*
Pro_BackPattern:lea	Pro_SongPos(pc),a0
		move.b	(a0),d0
		bne.s	.NormalSub
		move.l	MT_Data(pc),a3
		move.b	950(a3),(a0)			;Max.Pos nach SongPos
.NormalSub:	subq.b	#1,(a0)
		bra.s	Pro_Set

*--------------------------------------------------------------------------*
Pro_GetPosNr:	moveq	#0,d0
		move.b	Pro_SongPos(pc),d0
		rts

*--------------------------------------------------------------------------*
Pro_Init:
		move.l	PufferAdr2,a5
		lea	Pro_Speed(pc),a0
		move.w	#Pro_VoiceEnd-Pro_Speed-1,d0
.ClearVoices:	clr.b	(a0)+
		dbf	d0,.ClearVoices

	lea	pro_voice1(pc),a1
	move.w	#1,n_dmabit(a1)
	lea	pro_voice2(pc),a1
	move.w	#2,n_dmabit(a1)
	lea	pro_voice3(pc),a1
	move.w	#4,n_dmabit(a1)
	lea	pro_voice4(pc),a1
	move.w	#8,n_dmabit(a1)

;		addq.w	#1,20(a1)
;		addq.w	#2,20+Pro_Voice2-Pro_Voice1(a1)
;		addq.w	#4,20+Pro_Voice3-Pro_Voice1(a1)
;		addq.w	#8,20+Pro_Voice4-Pro_Voice1(a1)

		move.l	MT_Data(pc),a0
		move.l	a0,a1
		lea	$3B8(a1),a1
		moveq	#127,d0
		moveq	#0,d2
Pro_Init3:	cmp.b	(a1)+,d2
		bge.s	.hi
		move.b	-1(a1),d2
.hi		dbf	d0,Pro_Init3

		lea	PRO_Samplestarts(pc),a1
		tst.w	MT_InstrKennung(a5)
		beq.w	.Module
		cmp.w	#2,MT_Instrkennung(a5)
		beq.s	.Converted

		move.l	MT_Data(pc),a2
		moveq	#1,d7			;Zahler fr GetListData
		moveq	#31,d6
		lea	$14(a2),a2
.NextSample:	tst.w	22(a2)			;Scheissfehler !
		beq.s	.NoSample
		clr.l	(A1)

		move.l	d7,d0
		move.l	DTG_GetListData(a5),a0
		jsr	(a0)
		beq.s	.NoSample
		clr.l	(a0)
		addq.l	#1,d7
		move.l	a0,(a1)				;SampleAdr merken

		lsr.w	#1,d0
		move.w	22(a2),d1
		cmp.w	d1,d0
		bhs.s	.NoSample
		move.w	d0,22(a2)	;tatschliche Lnge des Samples merken

		cmp.w	#2,28(a2)
		bls.s	.NoSample
		sub.w	d0,d1
		sub.w	d1,28(a2)
.NoSample:
		addq.l	#4,a1
		lea	$1e(a2),a2
		dbf	d6,.NextSample		
		bra.w	.SamplesOk

	*------ Es wird ein convertiertes Module abgespielt -----*
.Converted:
	move.l	P56_sampleadr(pc),d0
	beq.s	.normalSM
	move.l	d0,a2
	move.l	d0,d3
	add.l	P56_Samplesize(pc),d3
	bra.s	.p56SM
.normalSM
		move.l	SamplePointer(a5),a2	;SamplePointer
		move.l	MT_Size(pc),d3
		add.l	Ori_Data(a5),d3		;max Speicheradr
.p56SM
		move.l	d3,d4
		addq.l	#8,d4
		move.l	a2,d2

		moveq	#$1E,d0
		moveq	#0,d1
.Convert:
		cmp.l	a2,d3
		ble.s	.Con_Adr

		cmp.w	#2,$2a(a0)		;Lnge <= 4 ?
		bls.s	.Con_adr		;ja, also Adr nicht lschen

		clr.l	(a2)
.Con_Adr:
		move.w	$2A(a0),d1		;Samplelnge holen
		add.l	d1,d2
		add.l	d1,d2

		cmp.l	d2,d4	;Adr nchstes Sample > Adr Ende des Moduls+8 ?
		bge.s	.ok_sample_spielbar2 ;nein, aktuelles Sample komplett

		clr.l	(A1)+		    ;ja, also Sample ignorieren
		bra.s	.skip2
.ok_sample_spielbar2
		move.l	a2,(a1)+		;sampleStart nach Puffer
.skip2
		move.l	d2,a2
		add.l	#$1E,a0
		dbf	d0,.Convert
		bra.b	.SamplesOk

	*------ Es wurde ein Module geladen -----*
.Module:	addq.b	#1,d2
		asl.l	#8,d2
		asl.l	#2,d2
		add.l	#$43C,d2
		add.l	a0,d2				;FirstSample
		move.l	d2,a2
		moveq	#$1E,d0
		move.l	MT_Size(pc),d3
		add.l	a0,d3

		moveq	#0,d1
		move.l	a2,d2
		move.l	d3,d4
		addq.l	#8,d4
		subq.l	#4,d3
.Pro_Init4:
		move.w	$2A(a0),d1
		add.l	d1,d2
		add.l	d1,d2			;nchstes Sample

		cmp.l	a2,d3
		ble.s	.Noe

		cmp.w	#2,$2a(a0)		;Lnge <= 4 ?
		bls.s	.Noe			;ja, also Adr nicht lschen

		clr.l	(a2)
.Noe:

		cmp.l	d2,d4	;Adr nchstes Sample > Adr Ende des Moduls+8 ?
		bge.s	.ok_sample_spielbar ;nein, aktuelles Sample komplett

		clr.l	(A1)+		    ;ja, also Sample ignorieren
		bra.s	.skip
.ok_sample_spielbar
		move.l	a2,(a1)+		;sampleStart nach Puffer
.skip
		move.l	d2,a2
		add.l	#$1E,a0
		dbf	d0,.Pro_Init4

		clr.w	pro_tempo
.SamplesOk:
Pro_Reinit:	lea	Pro_Speed(pc),a0
		move.b	#6,(a0)
		move.b	#6,Pro_Counter-Pro_Speed(a0)
		clr.b	Pro_SongPos-Pro_Speed(a0)
		clr.w	Pro_PatternPos-Pro_Speed(a0)
		cmp.w	#125,pro_tempo-Pro_Speed(a0)
		bne.s	.newval
		rts
.newval
		move.w	#125,Pro_Tempo-Pro_Speed(a0)
		bra	Pro_SetTimer
Pro_End:
	movem.l	d0-a6,-(Sp)
	MOVEQ	#0,D0
	LEA	$DFF0a0,A5
	bsr	pokevol
	LEA	$DFF0b0,A5
	bsr	pokevol
	LEA	$DFF0c0,A5
	bsr	pokevol
	LEA	$DFF0d0,A5
	bsr	pokevol

	MOVE.W	#$000F,d0
	bsr	pokedma
	movem.l	(sp)+,d0-a6
	rts
*----------------------------------------------------------------------------*
_Pro_Music:	movem.l	d1-a6,-(a7)

		move.l	StructAdr(pc),a1
		move.w	#-1,UPS_Enabled(a1)
	;	move.w	#UPSB_Adr!UPSB_LEN!UPSB_Per!UPSB_Vol!UPSB_DMACON,d0
	;	move.w	d0,UPS_Flags(a1)

;		move.w	#$f00,$dff180
		move.w	UPS_Voice1per(A1),d0
		add.w	UPS_Voice2per(A1),d0
		add.w	UPS_Voice3per(A1),d0
		add.w	UPS_Voice4per(A1),d0
		beq.s	.skip

		move.b	.wait(pc),d0
		addq.b	#1,d0
		and.b	#1,d0
		bne.s	.skip

;		move.w	#$0f,$dff180
	
		clr.w	UPS_Voice1Per(a1)
		clr.w	UPS_Voice2Per(a1)
		clr.w	UPS_Voice3Per(a1)
		clr.w	UPS_Voice4Per(a1)
.skip
		move.b	d0,.wait

		bsr.s	Pro_Music

		move.l	StructAdr(pc),a1
		clr.w	UPS_Enabled(a1)
		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts
.wait		dc.b	0,0

Pro_Music:	lea	Pro_Counter(pc),a0
		addq.b	#1,(a0)				Pro_Counter
		move.b	(a0),d0
		cmp.b	Pro_Speed(pc),d0
		bcs.s	Pro_Nonewnote
		clr.b	(a0)				Pro_Counter
		tst.b	Pro_Pattdeltime2
		beq.w	Pro_Getnewnote
		bsr.s	Pro_NoNewallchannels

		bra	Pro_Dskip
Pro_Nonewnote:	bsr.s	Pro_NoNewallchannels
		bra	Pro_Nonewposyet
Pro_NoNewallchannels:
		lea	$DFF0A0,a5
		lea	Pro_Voice1(pc),a6
		bsr	Pro_DoFx
		lea	$DFF0B0,a5
		lea	Pro_Voice2(pc),a6
		bsr	Pro_DoFx
		lea	$DFF0C0,a5
		lea	Pro_Voice3(pc),a6
		bsr	Pro_DoFx
		lea	$DFF0D0,a5
		lea	Pro_Voice4(pc),a6
		bra	Pro_DoFx

Pro_Getnewnote:	move.l	mt_data(pc),a0
		lea	12(a0),a3
		lea	$3B8(a0),a2
		lea	$43C(a0),a0
		moveq	#0,d0
		moveq	#0,d1
		move.b	Pro_SongPos(pc),d0
		move.b	0(a2,d0.w),d1
		asl.l	#8,d1
		asl.l	#2,d1
		add.w	Pro_PatternPos(pc),d1

		clr.w	Pro_Dmacon

		lea	$DFF0A0,a5
		lea	Pro_Voice1(pc),a6
		bsr.s	Pro_Playvoice
		lea	$DFF0B0,a5
		lea	Pro_Voice2(pc),a6
		bsr.s	Pro_Playvoice
		lea	$DFF0C0,a5
		lea	Pro_Voice3(pc),a6
		bsr.s	Pro_Playvoice
		lea	$DFF0D0,a5
		lea	Pro_Voice4(pc),a6
		bsr.s	Pro_Playvoice

		bra	Pro_Setdma
Pro_Playvoice:
		tst.l	(a6)
		bne.s	Pro_DoCommand
		bsr	Pro_Pernop
*----------------------------- PlayVoice -----------------------------------*
Pro_Docommand:	move.l	0(a0,d1.l),(a6)
		addq.l	#4,d1

		moveq	#0,d2
		move.b	2(a6),d2
		and.b	#$F0,d2
		lsr.b	#4,d2
		move.b	(a6),d0
		and.b	#$F0,d0
		or.b	d0,d2
		tst.b	d2
		beq	Pro_Nonew

		cmp.b	#$1f,d2			;Test auf fehlerhafte Mods !!!
		bhi.w	Pro_KReturn		;Pro_NoNew

		moveq	#0,d3
		lea	PRO_Samplestarts(pc),a1
		move.w	d2,d4
		MOVE.B	D2,n_samplenum(A6)
		subq.l	#1,d2
		asl.l	#2,d2
		mulu	#$1E,d4
		tst.l	0(a1,d2.l)		;Sampleadresse (orig. Routine)
		bne.s	.yosam
						;kein Sample, also wird
						;auch nichts gespielt
		clr.w	(a6)
		move.b	2(a6),d0
		and.w	#$f,d0
		move.b	d0,2(A6)
		clr.l	4(a6)
		clr.w	8(a6)
		clr.w	$28(A6)
		clr.w	$12(a6)
		clr.l	10(A6)
		clr.l	$24(A6)
		clr.w	14(A6)
		clr.b	$1F(a6)
		clr.b	n_samplenum(A6)

		moveq	#0,d0
		bsr.w	Pro_SetVoices
		bra.s	PRO_Nonew
.yosam
		move.l	0(a1,d2.l),4(a6)	;Sampleadresse (orig. Routine)
		move.w	0(a3,d4.l),8(a6)	;Lnge         (orig. Routine)
		move.w	0(a3,d4.l),$28(a6)
		move.b	2(a3,d4.l),$12(a6)
		move.b	3(a3,d4.l),$13(a6)	;Samplevolume
		move.w	4(a3,d4.l),d3		;Loopstart
		tst.w	d3
		beq.s	PRO_NoLoop
		move.l	4(a6),d2
		asl.w	#1,d3
		add.l	d3,d2
		move.l	d2,10(a6)		;Repeatbeginn
		move.l	d2,$24(a6)		;WaveStart
		move.w	4(a3,d4.l),d0		;Loopstart
		add.w	6(a3,d4.l),d0		;Looplen
		move.w	d0,8(a6)
		move.w	6(a3,d4.l),14(a6)
	;	moveq	#0,d0
		move.b	$13(a6),d0

		bsr.w	Pro_SetVoices
		bra.s	PRO_Nonew
PRO_NoLoop:	move.l	4(a6),d2
		add.l	d3,d2
		move.l	d2,10(a6)
		move.l	d2,$24(a6)
		move.w	6(a3,d4.l),14(a6)
	;	moveq	#0,d0
		move.b	$13(a6),d0

		bsr.w	Pro_SetVoices

PRO_Nonew:	move.w	(a6),d0
		and.w	#$FFF,d0
		beq	Pro_CheckmoreEfx
		move.w	2(a6),d0
		and.w	#$FF0,d0
		cmp.w	#$E50,d0
		beq.s	Pro_Dosetfinetune
		move.b	2(a6),d0

		and.b	#15,d0
		cmp.b	#3,d0
		beq.s	Pro_CheckTonePorta
		cmp.b	#5,d0
		beq.s	Pro_CheckTonePorta
		cmp.b	#9,d0
		bne.s	Pro_Setperiod
		bsr	Pro_CheckmoreEfx
		bra.s	Pro_Setperiod
Pro_Dosetfinetune:
		bsr	Pro_Setfinetune
		bra.s	Pro_Setperiod

Pro_CheckTonePorta:
		bsr	Pro_Settoneporta
		bra	Pro_CheckmoreEfx

Pro_Setperiod:	movem.l	d0/d1/a0/a1,-(sp)
		move.w	(a6),d1
		and.w	#$FFF,d1
		lea	Pro_Periodtable(pc),a1
		moveq	#0,d0
		moveq	#$24,d2
Pro_Setperiod2:	cmp.w	(a1,d0.w),d1
		bcc.s	Pro_FtuFound
		addq.l	#2,d0
		dbra	d2,Pro_Setperiod2
Pro_FtuFound:	moveq	#0,d1
		move.b	$12(a6),d1
		mulu	#37*2,d1			;$48,d1
		add.l	d1,a1
		move.w	0(a1,d0.w),$10(a6)

		bsr	PRO_getvoice

		movem.l	(sp)+,d0/d1/a0/a1
		move.w	2(a6),d0
		and.w	#$FF0,d0
		cmp.w	#$ED0,d0
		beq	Pro_CheckmoreEfx

	move.w	d0,-(sp)
	move.w	$14(a6),d0
	bsr	pokedma		;move.w	d0,$DFF096
	move.w	(Sp)+,d0

		btst	#2,$1E(a6)
		bne.s	Pro_Vibnoc
		clr.b	$1B(a6)
Pro_Vibnoc:	btst	#6,$1E(a6)
		bne.s	Pro_Trenoc
		clr.b	$1D(a6)
Pro_Trenoc:
	move.w	8(a6),d0
	bsr	pokelen			;move.w	d0,4(a5)
	move.l	4(a6),d0
	bsr	pokeadr			;move.l	d0,(a5)
	tst.l	d0
	bne.s	pro_sdmaskp

	CLR.L	$a(A6)
	MOVEQ	#1,D0
	MOVE.W	D0,$e(A6)

	bsr	pokelen			;MOVE.W	D0,4(A5)
pro_sdmaskp
	move.w	$10(a6),d0
	bsr	pokeper			;move.w	d0,6(a5)

	move.w	$14(a6),d0
	or.w	d0,Pro_Dmacon
	bra	Pro_CheckmoreEfx
	rts
Pro_Setdma:
	;*************** Standard Routine zum DMA setzen *****************
;	move.b	FastLoad(pc),d1
;	bne.s	.nowait1
;		jsr	DTWaitAudioDma
;.nowait1
		move.w	Pro_Dmacon(pc),d0
		or.w	#$8000,d0
		bsr	pokedma			;move.w	d0,$DFF096

;	move.b	FastLoad(pc),d1
;	bne.s	.nowait2
;		jsr	DTWaitAudioDma
;.nowait2

		lea	$DFF0d0,a5
		lea	Pro_Voice4(pc),a6
		move.l	10(a6),d0
		bsr	pokeadr		;move.l	d0,(a5)	;VoiceAdr

		cmp.l	4(a6),d0
		bne.s	.Repeat1_on
		move.w	14(a6),d0
		bsr	pokelen		;move.l	d0,4(a5);VoiceLen
		bra.s	.Repeat1_off
.Repeat1_on
		move.w	14(a6),d0
		bsr	PokeLen_2
.Repeat1_off

		subq.l	#8,a5
		subq.l	#8,a5
		lea	Pro_Voice3(pc),a6
		move.l	10(a6),d0
		bsr	pokeadr		;move.l	d0,(a5)	;VoiceAdr

		cmp.l	4(a6),d0
		bne.s	.Repeat2_on
		move.w	14(a6),d0
		bsr	pokelen		;move.l	d0,4(a5);VoiceLen
		bra.s	.Repeat2_off
.Repeat2_on
		move.w	14(a6),d0
		bsr	PokeLen_2
.Repeat2_off

		subq.l	#8,a5
		subq.l	#8,a5
		lea	Pro_Voice2(pc),a6
		move.l	10(a6),d0
		bsr	pokeadr		;move.l	d0,(a5)	;VoiceAdr

		cmp.l	4(a6),d0
		bne.s	.Repeat3_on
		move.w	14(a6),d0
		bsr	pokelen		;move.l	d0,4(a5);VoiceLen
		bra.s	.Repeat3_off
.Repeat3_on
		move.w	14(a6),d0
		bsr	PokeLen_2
.Repeat3_off

		subq.l	#8,a5
		subq.l	#8,a5
		lea	Pro_Voice1(pc),a6
		move.l	10(a6),d0
		bsr	pokeadr		;move.l	d0,(a5)	;VoiceAdr

		cmp.l	4(a6),d0
		bne.s	.Repeat4_on
		move.w	14(a6),d0
		bsr	pokelen		;move.l	d0,4(a5);VoiceLen
		bra.s	.Repeat4_off
.Repeat4_on
		move.w	14(a6),d0
		bsr	PokeLen_2
.Repeat4_off

		lea	$dff000,a5
Pro_Dskip:	add.w	#$10,Pro_PatternPos
		move.b	Pro_Pattdeltime(pc),d0

		beq.s	Pro_Dsc
		move.b	d0,Pro_Pattdeltime2
		clr.b	Pro_Pattdeltime
Pro_Dsc:	tst.b	Pro_Pattdeltime2
		beq.s	Pro_dska
		subq.b	#1,Pro_Pattdeltime2
		beq.s	Pro_dska
		sub.w	#$10,Pro_PatternPos

Pro_dska:	tst.b	Pro_PBreakflag
		beq.s	Pro_nnpysk
		sf	Pro_PBreakflag
		moveq	#0,d0
		move.b	Pro_PBreakpos(pc),d0
		clr.b	Pro_PBreakpos
		lsl.w	#4,d0
		move.w	d0,Pro_PatternPos

Pro_nnpysk:	cmp.w	#$400,Pro_PatternPos
		bcs.s	Pro_Nonewposyet
Pro_Nextposition:
		moveq	#0,d0
		move.b	Pro_PBreakpos(pc),d0
		lsl.w	#4,d0
		move.w	d0,Pro_PatternPos
		clr.b	Pro_PBreakpos
		clr.b	Pro_Posjumpflag

		lea	Pro_SongPos(pc),a0
		addq.b	#1,(a0)
		and.b	#$7f,(a0)
		move.b	(a0),d1

		move.l	mt_data(pc),a0

		cmp.b	$3B6(a0),d1
		bcs.s	Pro_Nonewposyet
		jsr	DT_SongEnd		;End of Song for Playerprogram

		movem.l	d0-a6,-(a7)
		bsr.w	Pro_ReInit
		movem.l	(a7)+,d0-a6

		clr.b	Pro_Counter
		tst.b	BSSMerkPuffer+OnSongEnd
		beq.s	pro_Nonewposyet
		move.b	#10,pro_counter

pro_Nonewposyet:tst.b	Pro_Posjumpflag
		bne.s	Pro_Nextposition

	lea	mypattinfo(pc),a0
	move.w	pro_patternpos(pc),d0
	lsr.w	#4,d0
	move.w	d0,pi_pattpos(a0)
	move.b	pro_songpos(pc),d0
	move.w	d0,PI_Songpos(a0)

	move.l	mt_data(pc),a1
	add.w	#$3b8,d0
	move.b	(a1,d0.w),d0			;Patternnumber
	and.w	#$ff,d0
	move.w	d0,pi_pattern(A0)		;save
	mulu	#1024,d0			;mulu 1024
	add.l	#$43c,d0			;add Infoblock
	lea	(a1,d0.l),a1			;Patternadr
	move.l	a1,pi_Stripes(a0)
	addq.l	#4,a1
	move.l	a1,pi_Stripes+4(a0)
	addq.l	#4,a1
	move.l	a1,pi_Stripes+8(a0)
	addq.l	#4,a1
	move.l	a1,pi_Stripes+12(a0)
	move.w	pro_tempo(pc),pi_bpm(a0)	;set Tempo
	move.b	pro_speed(pc),pi_speed+1(a0)	;set Speed

Pro_KReturn:	rts

Pro_DoFx:	bsr	Pro_Updatefunk
		move.w	2(a6),d0
		and.w	#$FFF,d0
		beq.s	Pro_Pernop
		move.b	2(a6),d0
		and.b	#15,d0
		beq.s	Pro_Arpeggio
		cmp.b	#1,d0
		beq	Pro_PortUp
		cmp.b	#2,d0
		beq	Pro_Portdown
		cmp.b	#3,d0
		beq	Pro_Toneportamento
		cmp.b	#4,d0
		beq	Pro_Vibrato
		cmp.b	#5,d0
		beq	Pro_TonePlusVolslide
		cmp.b	#6,d0
		beq	Pro_VibratoPlusVolSlide
		cmp.b	#14,d0
		beq	Pro_E_Commands
	move.w	d0,-(sp)
	move.w	$10(a6),d0
	bsr	pokeper			;move.w	d0,6(a5)	;VoicePer
	move.w	(sp)+,d0
		cmp.b	#7,d0
		beq	Pro_Tremolo
		cmp.b	#10,d0
		beq	Pro_Volumeslide
Pro_Return2:	rts

Pro_Pernop:
	move.w	d0,-(sp)
	move.w	$10(a6),d0
	beq.s	.none
	bsr	pokeper			;move.w	d0,6(a5)	;VoicePer
.none
	move.w	(sp)+,d0
	rts


Pro_Arpeggio:
	MOVEQ	#0,D0
	MOVE.b	pro_Counter(PC),D0
	DIVS	#3,D0
	SWAP	D0
	CMP.W	#1,D0
	BEQ.B	pt_Arpeggio1
	CMP.W	#2,D0
	BEQ.B	pt_Arpeggio2
pt_Arpeggio0
	MOVE.W	$10(A6),D2
	BRA.B	pt_ArpeggioSet
pt_Arpeggio1
	MOVEQ	#0,D0
	MOVE.B	3(A6),D0
	LSR.B	#4,D0
	BRA.B	pt_ArpeggioFind
pt_Arpeggio2
	MOVEQ	#0,D0
	MOVE.B	3(A6),D0
	AND.B	#15,D0
pt_ArpeggioFind
	ASL.W	#1,D0
	MOVEQ	#0,D1
	MOVE.B	$12(A6),D1
	MULU	#37*2,D1
	LEA	pro_PeriodTable(PC),A0
	ADD.L	D1,A0
	MOVEQ	#0,D1
	MOVE.W	$10(A6),D1
	MOVEQ	#$24,D7
pt_arploop
	MOVE.W	0(a0,D0.W),D2
	CMP.W	(A0),D1
	BHS.B	pt_ArpeggioSet
	ADDQ.L	#2,A0
	DBRA	D7,pt_arploop
	RTS
pt_ArpeggioSet
	move.w	d0,-(sp)
	move.w	d2,d0
	bsr	pokeper			;move.w	d0,6(a5)	;VoicePer
	move.w	(sp)+,d0
	RTS

Pro_FinePortaUp:
		tst.b	Pro_Counter
		bne.w	Pro_Return2
		move.b	#15,Pro_Lowmask
Pro_PortUp:	moveq	#0,d0
		move.b	3(a6),d0
		and.b	Pro_Lowmask(pc),d0
		move.b	#$FF,Pro_Lowmask
		sub.w	d0,$10(a6)
		move.w	$10(a6),d0
		and.w	#$FFF,d0
		cmp.w	#$71,d0
		bpl.s	Pro_PortaUskip
		and.w	#$F000,$10(a6)
		or.w	#$71,$10(a6)
Pro_PortaUskip:	move.w	$10(a6),d0
		and.w	#$FFF,d0
		bsr	pokeper			;move.w	d0,6(a5)
		rts

Pro_FinePortaDown:tst.b	Pro_Counter
		bne	Pro_Return2
		move.b	#15,Pro_Lowmask
Pro_Portdown:	clr.w	d0
		move.b	3(a6),d0
		and.b	Pro_Lowmask(pc),d0
		move.b	#$FF,Pro_Lowmask
		add.w	d0,$10(a6)
		move.w	$10(a6),d0
		and.w	#$FFF,d0
		cmp.w	#$358,d0
		bmi.s	Pro_PortaDskip
		and.w	#$F000,$10(a6)
		or.w	#$358,$10(a6)
Pro_PortaDskip:	move.w	$10(a6),d0
		and.w	#$FFF,d0
					;move.w	d0,6(a5)
		bsr	pokeper
		rts

Pro_Settoneporta:
		move.l	a0,-(sp)
		move.w	(a6),d2
		and.w	#$FFF,d2
		moveq	#0,d0
		move.b	$12(a6),d0
		mulu	#37*2,d0			;$4a,d0
		lea	Pro_Periodtable(pc),a0
		add.l	d0,a0
		moveq	#0,d0
Pro_Stploop:	cmp.w	(a0,d0.w),d2
		bhs.s	Pro_Stpfound
		addq.w	#2,d0
		cmp.w	#37*2,d0			;$4A,d0
		bcs.s	Pro_Stploop
		moveq	#$46,d0
Pro_Stpfound:	move.b	$12(a6),d2
		and.b	#8,d2
		beq.s	Pro_Stpgoss
		tst.w	d0
		beq.s	Pro_Stpgoss
		subq.w	#2,d0
Pro_Stpgoss:	move.w	(a0,d0.w),d2
		move.l	(sp)+,a0
		move.w	d2,$18(a6)
		move.w	$10(a6),d0
		clr.b	$16(a6)
		cmp.w	d0,d2
		beq.s	Pro_ClearTonePorta
		bge	Pro_Return2
		move.b	#1,$16(a6)
		rts

Pro_ClearTonePorta:
		clr.w	$18(a6)
		rts

Pro_Toneportamento:
		move.b	3(a6),d0
		beq.s	Pro_Toneportnochange
		move.b	d0,$17(a6)
		clr.b	3(a6)
Pro_Toneportnochange:
		tst.w	$18(a6)
		beq	Pro_Return2
		moveq	#0,d0
		move.b	$17(a6),d0
		tst.b	$16(a6)
		bne.s	Pro_Toneportaup

		add.w	d0,$10(a6)
		move.w	$18(a6),d0
		cmp.w	$10(a6),d0
		bgt.s	Pro_Toneportasetper

		move.w	$18(a6),$10(a6)
		clr.w	$18(a6)
		bra.s	Pro_Toneportasetper

Pro_Toneportaup:sub.w	d0,$10(a6)
		move.w	$18(a6),d0
		cmp.w	$10(a6),d0
		blt.s	Pro_Toneportasetper
		move.w	$18(a6),$10(a6)
		clr.w	$18(a6)
Pro_Toneportasetper:
		move.w	$10(a6),d2
		move.b	$1F(a6),d0
		and.b	#15,d0
		beq.s	Pro_Glissskip
		moveq	#0,d0
		move.b	$12(a6),d0
		mulu	#37*2,d0			;$48,d0
		lea	Pro_Periodtable(pc),a0
		add.l	d0,a0
		moveq	#0,d0
Pro_Glissloop:	cmp.w	(a0,d0.w),d2
		bhs.s	Pro_Glissfound
		addq.w	#2,d0
		cmp.w	#37*2,d0			;$48,d0
		bcs.s	Pro_Glissloop
		moveq	#35*2,d0			;$46,d0
Pro_Glissfound:	move.w	(a0,d0.w),d2
Pro_Glissskip:
	move.w	d0,-(sp)
	move.w	d2,d0
	bsr	pokeper			;move.w	d0,6(a5)	;VoicePer
	move.w	(sp)+,d0
	rts

pro_Vibrato
	MOVE.B	n_cmdlo(A6),D0
	BEQ.B	pro_Vibrato2
	MOVE.B	n_vibratocmd(A6),D2
	AND.B	#$0F,D0
	BEQ.B	pt_vibskip
	AND.B	#$F0,D2
	OR.B	D0,D2
pt_vibskip
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$F0,D0
	BEQ.B	pt_vibskip2
	AND.B	#$0F,D2
	OR.B	D0,D2
pt_vibskip2
	MOVE.B	D2,n_vibratocmd(A6)
pro_Vibrato2
	MOVE.L	A4,-(SP)
	MOVE.B	n_vibratopos(A6),D0
	LEA	pro_VibratoTable(PC),A4
	LSR.W	#2,D0
	AND.W	#$001F,D0
	MOVEQ	#0,D2
	MOVE.B	n_wavecontrol(A6),D2
	AND.B	#$03,D2
	BEQ.B	pt_vib_sine
	LSL.B	#3,D0
	CMP.B	#1,D2
	BEQ.B	pt_vib_rampdown
	MOVE.B	#255,D2
	BRA.B	pt_vib_set
pt_vib_rampdown
	TST.B	n_vibratopos(A6)
	BPL.B	pt_vib_rampdown2
	MOVE.B	#255,D2
	SUB.B	D0,D2
	BRA.B	pt_vib_set
pt_vib_rampdown2
	MOVE.B	D0,D2
	BRA.B	pt_vib_set
pt_vib_sine
	MOVE.B	0(A4,D0.W),D2
pt_vib_set
	MOVE.B	n_vibratocmd(A6),D0
	AND.W	#15,D0
	MULU	D0,D2
	LSR.W	#7,D2
	MOVE.W	n_period(A6),D0
	TST.B	n_vibratopos(A6)
	BMI.B	pt_VibratoNeg
	ADD.W	D2,D0
	BRA.B	pt_Vibrato3
pt_VibratoNeg
	SUB.W	D2,D0
pt_Vibrato3
	bsr	pokeper			;MOVE.W	D0,6(A5)
	MOVE.B	n_vibratocmd(A6),D0
	LSR.W	#2,D0
	AND.W	#$003C,D0
	ADD.B	D0,n_vibratopos(A6)
	MOVE.L	(SP)+,A4
	RTS

Pro_TonePlusVolslide:
		bsr	Pro_Toneportnochange
		bra	Pro_Volumeslide

Pro_VibratoPlusVolSlide:
		bsr.s	Pro_Vibrato2
		bra	Pro_Volumeslide

Pro_Tremolo:	move.b	3(a6),d0
		beq.s	Pro_Tremolo2
		move.b	$1C(a6),d2
		and.b	#15,d0
		beq.s	Pro_Treskip
		and.b	#$F0,d2
		or.b	d0,d2
Pro_Treskip:	move.b	3(a6),d0
		and.b	#$F0,d0
		beq.s	Pro_treskip2
		and.b	#15,d2
		or.b	d0,d2
Pro_treskip2:	move.b	d2,$1C(a6)
Pro_Tremolo2:	move.b	$1D(a6),d0
		lea	Pro_Vibratotable(pc),a4
		lsr.w	#2,d0
		and.w	#$1F,d0
		moveq	#0,d2
		move.b	$1E(a6),d2
		lsr.b	#4,d2
		and.b	#3,d2
		beq.s	Pro_tre_sine
		lsl.b	#3,d0
		cmp.b	#1,d2
		beq.s	Pro_tre_rampdown
		move.b	#$FF,d2
		bra.s	Pro_tre_set

Pro_tre_rampdown:tst.b	$1B(a6)
		bpl.s	Pro_tre_rampdown2
		move.b	#$FF,d2
		sub.b	d0,d2
		bra.s	Pro_tre_set

Pro_tre_rampdown2:
		move.b	d0,d2
		bra.s	Pro_tre_set
Pro_tre_sine:	move.b	0(a4,d0.w),d2
Pro_tre_set:	move.b	$1C(a6),d0
		and.w	#15,d0
		mulu	d0,d2
		lsr.w	#6,d2
		moveq	#0,d0
		move.b	$13(a6),d0
		tst.b	$1D(a6)
		bmi.s	Pro_Tremoloneg
		add.w	d2,d0
		bra.s	Pro_Tremolo3
Pro_Tremoloneg:	sub.w	d2,d0
Pro_Tremolo3:	bpl.s	Pro_tremoloskip
		clr.w	d0
Pro_tremoloskip:cmp.w	#$40,d0
		bls.s	Pro_TremoloOK
		move.w	#$40,d0
Pro_TremoloOK:	bsr.w	Pro_SetVoices

		move.b	$1C(a6),d0
		lsr.w	#2,d0
		and.w	#$3C,d0
		add.b	d0,$1D(a6)
		rts

Pro_Sampleoffset:
		moveq	#0,d0
		move.b	3(a6),d0
		beq.s	Pro_SOnonew
		move.b	d0,$20(a6)

Pro_SOnonew:	move.b	$20(a6),d0
		lsl.w	#7,d0

		cmp.w	8(a6),d0
		bgt.w	Pro_SOFskip

		sub.w	d0,8(a6)
		lsl.w	#1,d0
		add.l	d0,4(a6)
.rts:		rts


Pro_SOFskip:	move.w	#1,8(a6)
		rts

Pro_Volumeslide:moveq	#0,d0
		move.b	3(a6),d0
		lsr.b	#4,d0
		tst.b	d0
		beq.s	Pro_Volslidedown
Pro_Volslideup:	add.b	d0,$13(a6)
		cmp.b	#$40,$13(a6)
		bmi.s	Pro_VDskip
		move.b	#$40,$13(a6)
Pro_VDskip:	move.b	$13(a6),d0
		bra.w	Pro_SetVoices
	
Pro_Volslidedown:moveq	#0,d0
		move.b	3(a6),d0
		and.b	#15,d0
Pro_Volslidedown2:sub.b	d0,$13(a6)
		bpl.s	Pro_E7C
		clr.b	$13(a6)
Pro_E7C:	move.b	$13(a6),d0
		bra.w	Pro_SetVoices
	
Pro_positionjump:
	movem.l	d1/d2/a0,-(Sp)

		move.b	3(a6),d0
		cmp.b	Pro_SongPos(pc),d0
		bhi.s	.Ok
		bne.s	.lo

		move.b	pro_songpos(pc),d1
		move.l	mt_data(pc),a0
		move.b	$3b6(a0),d2
		subq.b	#1,d2
		cmp.b	d1,d2
		bne.s	.ok
.lo
		jsr	DT_SongEnd
.Ok
		subq.b	#1,d0
		move.b	d0,Pro_SongPos

	movem.l	(sp)+,d1/d2/a0

Pro_otherflag:	clr.b	Pro_PBreakpos
		st 	Pro_Posjumpflag
		rts

Pro_Volumechange:moveq	#0,d0
		move.b	3(a6),d0
		cmp.b	#$40,d0
		bls.s	Pro_Volok
		moveq	#$40,d0
Pro_Volok:	move.b	d0,$13(a6)
		bra.w	Pro_SetVoices
	
Pro_Patternbreak:
		moveq	#0,d0
		move.b	3(a6),d0
		move.l	d0,d2
		lsr.b	#4,d0
		mulu	#10,d0
		and.b	#15,d2
		add.b	d2,d0
		cmp.b	#$3F,d0
		bhi.s	Pro_otherflag
		move.b	d0,Pro_PBreakpos
		st 	Pro_Posjumpflag
		rts

Pro_SetSpeed:	moveq	#0,d0
		move.b	3(a6),d0
		beq	.rts

	;	bne.s	.pro_ok		;raus damit, wird nie benutzt und
	;	jmp	DT_SongEnd	;macht nur rger !
	;	bra	Pro_Init			;SongEnde
	;	moveq	#6,d0
;.pro_ok:

		cmp.b	#32,d0
;		cmp.b	#40,d0				;erweitert wegen
;							;inkompatibler Module
		bcc	Pro_SetzeTimer
		clr.b	Pro_Counter
		move.b	d0,Pro_Speed
.rts
		rts
Pro_NewSpeed:
		move.l	EPG_AudioStruct(A5),d1
		beq.s	.aus
		move.l	d1,a0

		move	AS_Period(a0),d0
		lsr	#2,d0
		lea	$dff0a0,a5
		bsr	PokePer
		move	AS_Period+AS_Sizeof(a0),d0
		lsr	#2,d0
		lea	$10(a5),a5
		bsr	PokePer
		move	AS_Period+AS_Sizeof*2(a0),d0
		lsr	#2,d0
		lea	$10(a5),a5
		bsr	PokePer
		move	AS_Period+AS_Sizeof*3(a0),d0
		lsr	#2,d0
		lea	$10(a5),a5
		bsr	PokePer
.aus		rts


Pro_CheckmoreEfx:
		bsr	Pro_Updatefunk

		move.b	2(a6),d0
		and.b	#15,d0
		cmp.b	#9,d0
		beq	Pro_Sampleoffset
		cmp.b	#11,d0
		beq	Pro_positionjump
		cmp.b	#13,d0
		beq.w	Pro_Patternbreak
		cmp.b	#14,d0
		beq.s	Pro_E_Commands
		cmp.b	#15,d0
		beq.w	Pro_SetSpeed
		cmp.b	#12,d0
		beq	Pro_Volumechange
		bra	Pro_Pernop

Pro_E_Commands:	move.b	3(a6),d0
		and.b	#$F0,d0
		lsr.b	#4,d0
		beq.s	Pro_Filter
		cmp.b	#1,d0
		beq	Pro_FinePortaup
		cmp.b	#2,d0
		beq	Pro_FinePortaDown
		cmp.b	#3,d0
		beq.w	Pro_Setglisscontrol
		cmp.b	#4,d0
		beq	Pro_Setvibratocontrol
		cmp.b	#5,d0
		beq	Pro_Setfinetune
		cmp.b	#6,d0
		beq	Pro_Jumploop
		cmp.b	#7,d0
		beq	Pro_SetTremoloControl
		CMP.B	#8,D0
		BEQ.W	pro_KarplusStrong
		cmp.b	#9,d0
		beq	Pro_Retrignote
		cmp.b	#10,d0
		beq	Pro_Volumefineup
		cmp.b	#11,d0
		beq	Pro_Volumefinedown
		cmp.b	#12,d0
		beq	Pro_Notecut
		cmp.b	#13,d0
		beq	Pro_Notedelay
		cmp.b	#14,d0
		beq	Pro_Patterndelay
		cmp.b	#15,d0
		beq	Pro_Funkit
		rts

Pro_Filter:
	move.b	3(a6),d0
	and.b	#1,d0
	asl.b	#1,d0
;	and.b	#$FD,$BFE001
;	or.b	d0,$BFE001
	rts

pro_KarplusStrong
	MOVEM.L	D1-D2/A0-A1,-(SP)
	MOVE.L	n_loopstart(A6),d0
	beq.s	.no
	move.l	d0,A0
	MOVE.L	A0,A1
	MOVE.W	n_replen(A6),D0
	ADD.W	D0,D0
	SUBQ.W	#2,D0
	blt.s	.no
.pt_karplop
	MOVE.B	(A0),D1
	EXT.W	D1
	MOVE.B	1(A0),D2
	EXT.W	D2
	ADD.W	D1,D2
	ASR.W	#1,D2
	MOVE.B	D2,(A0)+
	DBRA	D0,.pt_karplop
	MOVE.B	(A0),D1
	EXT.W	D1
	MOVE.B	(A1),D2
	EXT.W	D2
	ADD.W	D1,D2
	ASR.W	#1,D2
	MOVE.B	D2,(A0)
.no
	MOVEM.L	(SP)+,D1-D2/A0-A1
	RTS


Pro_Setglisscontrol:
		move.b	3(a6),d0
		and.b	#15,d0
		and.b	#$F0,$1F(a6)
		or.b	d0,$1F(a6)
		rts

Pro_Setvibratocontrol:
		move.b	3(a6),d0
		and.b	#15,d0
		and.b	#$F0,$1E(a6)
		or.b	d0,$1E(a6)
		rts

Pro_Setfinetune:move.b	3(a6),d0
		and.b	#15,d0
		move.b	d0,$12(a6)
		rts

Pro_Jumploop:	tst.b	Pro_Counter
		bne	Pro_Return2
		move.b	3(a6),d0
		and.b	#15,d0
		beq.s	Pro_Setloop
		tst.b	$22(a6)
		beq.s	Pro_JmpCount
		subq.b	#1,$22(a6)
		beq	Pro_Return2
Pro_Jmploop:	move.b	$21(a6),Pro_PBreakpos
		st 	Pro_PBreakflag
		rts

Pro_JmpCount:	move.b	d0,$22(a6)
		bra.s	Pro_Jmploop

Pro_Setloop:
	move.w	Pro_PatternPos(pc),d0
	lsr.w	#4,d0
	and.b	#63,d0
	move.b	d0,$21(a6)
	rts

Pro_SetTremoloControl:
	move.b	3(a6),d0
	and.b	#15,d0
	lsl.b	#4,d0
	and.b	#15,$1E(a6)
	or.b	d0,$1E(a6)
	rts

Pro_Retrignote:
	move.l	d1,-(sp)
	moveq	#0,d0
	move.b	3(a6),d0
	and.b	#15,d0
	beq.s	Pro_Rtnend
	moveq	#0,d1
	move.b	Pro_Counter(pc),d1
	bne.s	Pro_Rtnskp
	move.w	(a6),d1
	and.w	#$FFF,d1
	bne.s	Pro_Rtnend
	moveq	#0,d1
	move.b	Pro_Counter(pc),d1
Pro_Rtnskp:
	divu	d0,d1
	swap	d1
	tst.w	d1
	bne.s	Pro_Rtnend
Pro_Doretrig:
	move.w	$14(a6),d0
	bsr	pokedma			;move.w	d0,$DFF096

	move.l	4(a6),d0
	bsr	pokeadr			;move.l	d0,(a5)	;VoiceAdr
	move.w	8(a6),d0
	bsr	pokelen			;move.w	d0,4(a5);VoiceLen

;	jsr	DTWaitAudioDma

	move.w	$14(a6),d0
	bset	#15,d0
	bsr	pokedma			;move.w	d0,$DFF096

;	jsr	DTWaitAudioDma

	move.l	10(a6),d0
	bsr	pokeadr			;move.l	d0,(a5)	;VoiceAdr
	move.w	14(a6),d0
	bsr	pokelen			;move.w	d0,4(a5);VoiceLen
	move.w	16(a6),d0
	bsr	pokeper			;move.w	d0,6(a5);VoicePer
Pro_Rtnend:
	move.l	(sp)+,d1
	rts

Pro_Volumefineup:tst.b	Pro_Counter
		bne	Pro_Return2
		moveq	#0,d0
		move.b	3(a6),d0
		and.b	#15,d0
		bra	Pro_Volslideup

Pro_Volumefinedown:
		tst.b Pro_Counter
		bne	Pro_Return2
		moveq	#0,d0
		move.b	3(a6),d0
		and.b	#15,d0
		bra	Pro_Volslidedown2

Pro_Notecut:	moveq	#0,d0
		move.b	3(a6),d0
		and.b	#15,d0
		cmp.b	Pro_Counter(pc),d0
		bne	Pro_Return2
		clr.b	$13(a6)
		moveq	#0,d0
		bsr	pokevol		;clr.w	8(a5)	;Set Volume 7
		rts

Pro_Notedelay:	moveq	#0,d0
		move.b	3(a6),d0
		and.b	#15,d0
		cmp.b	Pro_Counter(pc),d0
		bne	Pro_Return2
		move.w	(a6),d0
		and.w	#$fff,d0
		beq	Pro_Return2
		move.l	d1,-(sp)
		bra	Pro_Doretrig

Pro_Patterndelay:
		tst.b	Pro_Counter
		bne	Pro_Return2
		moveq	#0,d0
		move.b	3(a6),d0
		and.b	#15,d0
		tst.b	Pro_Pattdeltime2
		bne	Pro_Return2
		addq.b	#1,d0
		move.b	d0,Pro_Pattdeltime
		rts

Pro_Funkit:	tst.b	Pro_Counter
		bne	Pro_Return2
		move.b	3(a6),d0
		and.b	#15,d0
		lsl.b	#4,d0
		and.b	#15,$1F(a6)
		or.b	d0,$1F(a6)
		tst.b	d0
		beq	Pro_Return2
Pro_Updatefunk:	movem.l	d1/a0,-(sp)
		moveq	#0,d0
		move.b	$1F(a6),d0
		lsr.b	#4,d0
		beq.s	Pro_Funkend
		lea	Pro_Funktable(pc),a0
		move.b	0(a0,d0.w),d0
		add.b	d0,$23(a6)
		btst	#7,$23(a6)
		beq.s	Pro_Funkend
		clr.b	$23(a6)
		move.l	10(a6),d0
		moveq	#0,d1
		move.w	14(a6),d1
		add.l	d1,d0
		add.l	d1,d0
		move.l	$24(a6),a0
		addq.l	#1,a0
		cmp.l	d0,a0
		bcs.s	Pro_Funkok
		move.l	10(a6),a0
Pro_Funkok:	move.l	a0,$24(a6)
		cmp.l	#0,a0
		beq.s	Pro_Funkend
		moveq	#-$1,d0
		sub.b	(a0),d0
		move.b	d0,(a0)
Pro_Funkend:	movem.l	(sp)+,d1/a0
		rts

PokeVol:			;in D0 Lautstrke
	movem.l	d1/a5,-(sp)
	move.w	a5,d1		;Dff0a0/b0/c0/d0
	sub.w	#$f0a0,d1
	lsr.w	#4,d1		;Nummer der Stimme von 0-3
	and.w	#3,d1

	move.l	PufferAdr,a5
	jsr	ENPP_Pokevol(a5)

	movem.l	(sp)+,d1/a5
	rts
PokePer:			;in D0 Periodenwert
	movem.l	d1/d2/a5,-(sp)
	move.w	a5,d1		;Dff0a0/b0/c0/d0
	sub.w	#$f0a0,d1
	lsr.w	#4,d1		;Nummer der Stimme von 0-3
	and.w	#3,d1

	move.l	PufferAdr,a5
	move	EPG_Speed(a5),d2
	beq.s	.speed0
	bmi.s	.slower
	mulu	#20,d0
	add	#20,d2
	divu	d2,d0
	bra.s	.speed0
.slower
	neg	d2
	add	#20,d2
	mulu	d2,d0
	divu	#20,d0
.speed0
	jsr	ENPP_PokePer(a5)

	movem.l	(sp)+,d1/d2/a5
	rts
PokeLen:			;in D0 Lnge in Worten
	movem.l	d1/a5,-(sp)
	move.w	a5,d1		;Dff0a0/b0/c0/d0
	sub.w	#$f0a0,d1
	lsr.w	#4,d1		;Nummer der Stimme von 0-3
	and.w	#3,d1

	cmp.w	#1,d0
	bne.s	.no1
	moveq	#0,d0
.no1
	and.l	#$ffff,d0

	move.l	PufferAdr,a5
	jsr	ENPP_PokeLen(a5)

	movem.l	(sp)+,d1/a5
	rts
PokeLen_2:			;in D0 Lnge in Worten
	movem.l	d1/a5,-(sp)
	move.w	a5,d1		;Dff0a0/b0/c0/d0
	sub.w	#$f0a0,d1
	lsr.w	#4,d1		;Nummer der Stimme von 0-3
	and.w	#3,d1

	and.l	#$ffff,d0

	move.l	PufferAdr,a5
	jsr	ENPP_PokeLen(a5)

	movem.l	(sp)+,d1/a5
	rts
PokeAdr:			;in D0 Adresse
	movem.l	d1/a5,-(sp)
	move.w	a5,d1		;Dff0a0/b0/c0/d0
	sub.w	#$f0a0,d1
	lsr.w	#4,d1		;Nummer der Stimme von 0-3
	and.w	#3,d1

	move.l	PufferAdr,a5
	jsr	ENPP_PokeAdr(a5)

	movem.l	(sp)+,d1/a5
	rts
PokeDMA:
	movem.l	d1/d2/a5,-(sp)
	move.l	PufferAdr,a5

	move.w	d0,d1
	and.w	#$8000,d0	;D0.w neg=enable ; 0/pos=disable
	and.l	#15,d1		;D1 = Maske (LONG !!)

	jsr	ENPP_DmaMask(a5)

	movem.l	(sp)+,d1/d2/a5
	rts

Pro_Funktable:	dc.l	$50607,$80A0B0D,$1013161A,$202B4080
Pro_Vibratotable:dc.l	$18314A,$61788DA1,$B4C5D4E0,$EBF4FAFD,$FFFDFAF4
		dc.l	$EBE0D4C5,$B4A18D78,$614A3118

My_Periods:
Pro_Myperiods	dc.w	0

ProPC_Periods
	dc.w	856,808,762,720,678,640,604,570,538,508,480,453
	dc.w	428,404,381,360,339,320,302,285,269,254,240,226
	dc.w	214,202,190,180,170,160,151,143,135,127,120,113
	dc.w	$6b,$5f,$55,$50,$47,$477,$2fb,$23b,$11e,0
Pr_Periods:
ST_Periods:
Pro_Periodtable:
; -> Tuning 0
	dc.w	856,808,762,720,678,640,604,570,538,508,480,453
	dc.w	428,404,381,360,339,320,302,285,269,254,240,226
	dc.w	214,202,190,180,170,160,151,143,135,127,120,113,0
; -> Tuning 1
	dc.w	850,802,757,715,674,637,601,567,535,505,477,450
	dc.w	425,401,379,357,337,318,300,284,268,253,239,225
	dc.w	213,201,189,179,169,159,150,142,134,126,119,113,0
; -> Tuning 2
	dc.w	844,796,752,709,670,632,597,563,532,502,474,447
	dc.w	422,398,376,355,335,316,298,282,266,251,237,224
	dc.w	211,199,188,177,167,158,149,141,133,125,118,112,0
; -> Tuning 3
	dc.w	838,791,746,704,665,628,592,559,528,498,470,444
	dc.w	419,395,373,352,332,314,296,280,264,249,235,222
	dc.w	209,198,187,176,166,157,148,140,132,125,118,111,0
; -> Tuning 4
	dc.w	832,785,741,699,660,623,588,555,524,495,467,441
	dc.w	416,392,370,350,330,312,294,278,262,247,233,220
	dc.w	208,196,185,175,165,156,147,139,131,124,117,110,0
; -> Tuning 5
	dc.w	826,779,736,694,655,619,584,551,520,491,463,437
	dc.w	413,390,368,347,328,309,292,276,260,245,232,219
	dc.w	206,195,184,174,164,155,146,138,130,123,116,109,0
; -> Tuning 6
	dc.w	820,774,730,689,651,614,580,547,516,487,460,434
	dc.w	410,387,365,345,325,307,290,274,258,244,230,217
	dc.w	205,193,183,172,163,154,145,137,129,122,115,109,0
; -> Tuning 7
	dc.w	814,768,725,684,646,610,575,543,513,484,457,431
	dc.w	407,384,363,342,323,305,288,272,256,242,228,216
	dc.w	204,192,181,171,161,152,144,136,128,121,114,108,0
; -> Tuning -8
	dc.w	907,856,808,762,720,678,640,604,570,538,508,480
	dc.w	453,428,404,381,360,339,320,302,285,269,254,240
	dc.w	226,214,202,190,180,170,160,151,143,135,127,120,0
; -> Tuning -7
	dc.w	900,850,802,757,715,675,636,601,567,535,505,477
	dc.w	450,425,401,379,357,337,318,300,284,268,253,238
	dc.w	225,212,200,189,179,169,159,150,142,134,126,119,0
; -> Tuning -6
	dc.w	894,844,796,752,709,670,632,597,563,532,502,474
	dc.w	447,422,398,376,355,335,316,298,282,266,251,237
	dc.w	223,211,199,188,177,167,158,149,141,133,125,118,0
; -> Tuning -5
	dc.w	887,838,791,746,704,665,628,592,559,528,498,470
	dc.w	444,419,395,373,352,332,314,296,280,264,249,235
	dc.w	222,209,198,187,176,166,157,148,140,132,125,118,0
; -> Tuning -4
	dc.w	881,832,785,741,699,660,623,588,555,524,494,467
	dc.w	441,416,392,370,350,330,312,294,278,262,247,233
	dc.w	220,208,196,185,175,165,156,147,139,131,123,117,0
; -> Tuning -3
	dc.w	875,826,779,736,694,655,619,584,551,520,491,463
	dc.w	437,413,390,368,347,328,309,292,276,260,245,232
	dc.w	219,206,195,184,174,164,155,146,138,130,123,116,0
; -> Tuning -2
	dc.w	868,820,774,730,689,651,614,580,547,516,487,460
	dc.w	434,410,387,365,345,325,307,290,274,258,244,230
	dc.w	217,205,193,183,172,163,154,145,137,129,122,115,0
; -> Tuning -1
	dc.w	862,814,768,725,684,646,610,575,543,513,484,457
	dc.w	431,407,384,363,342,323,305,288,272,256,242,228
	dc.w	216,203,192,181,171,161,152,144,136,128,121,114,0

;Pro_Voice1:	dc.l	0,0,0,0,0,$10000,0,0,0,0,0,0,0,0,0,0,0,0,0 ;8 Zeroes added
;Pro_Voice2:	dc.l	0,0,0,0,0,$20000,0,0,0,0,0,0,0,0,0,0,0,0,0
;Pro_Voice3:	dc.l	0,0,0,0,0,$40000,0,0,0,0,0,0,0,0,0,0,0,0,0
;Pro_Voice4:	dc.l	0,0,0,0,0,$80000,0,0,0,0,0,0,0,0,0,0,0,0,0
;Pro_Samplestarts:ds.l	31
;Pro_Tempo:	dc.w	125
;Pro_Speed:	dc.b	6
;Pro_Counter:	dc.b	0
;Pro_SongPos:	dc.b	0
;Pro_PBreakpos:	dc.b	0
;Pro_Posjumpflag:dc.b	0
;Pro_PBreakflag:	dc.b	0
;Pro_Lowmask:	dc.b	0
;Pro_Pattdeltime:dc.b	0
;Pro_Pattdeltime2:dc.b	0,0
;Pro_PatternPos:	dc.w	0
;Pro_Dmacon:	dc.w	0
;Pro_Timer:	dc.l	0
;Pro_VoiceEnd

;fastload:	dc.b	0
;AudIntset	dc.b	0
;PRO_Firstsinfo:	dc.l	0


ST_Speed:
Pro_Speed:	dc.b	6
ST_Counter:
Pro_Counter:	dc.b	0
ST_Pattpos:
Pro_PatternPos:	dc.w	0
ST_Songpos:
Pro_SongPos:	dc.b	0
ST_Break:
Pro_PBreakpos:	dc.b	0
ST_Dmacon:
Pro_Dmacon:	dc.w	0

Pro_Samplestarts: 
ST_Samplestarts:
		ds.l	31
ST_Voice1:
Pro_Voice1:	dc.l	0,0,0,0,0,$10000,0,0,0,0,0,0,0,0,0,0,0,0,0 ;8 Zeroes added
ST_Voice2:
Pro_Voice2:	dc.l	0,0,0,0,0,$20000,0,0,0,0,0,0,0,0,0,0,0,0,0
ST_Voice3:
Pro_Voice3:	dc.l	0,0,0,0,0,$40000,0,0,0,0,0,0,0,0,0,0,0,0,0
ST_Voice4:
Pro_Voice4:	dc.l	0,0,0,0,0,$80000,0,0,0,0,0,0,0,0,0,0,0,0,0

ST_VoiceEnd:

Pro_Tempo:	dc.w	125
Pro_Posjumpflag:dc.b	0
Pro_PBreakflag:	dc.b	0
Pro_Lowmask:	dc.b	0
Pro_Pattdeltime:dc.b	0
Pro_Pattdeltime2:dc.b	0,0
Pro_Timer:	dc.l	0
Pro_VoiceEnd

fastload:	dc.b	0
AudIntset	dc.b	0
PRO_Firstsinfo:	dc.l	0

;Pro_VoiceEnd:

;============================================================
;= Startrekker AM/FM playroutine for Eagleplayer            =
;= doesn`t need ".nt"-File for Standard FM-Modules          =
;= Playroutine by EXOLON of Fairlight                       =
;= Adapted by Eagleeye & Buggs of DEFECT                    =
;============================================================
as_TagListe:	dc.l	Tag_More,STas_Tags
		dc.l	DTP_PlayerName,as_Name
		dc.l	0

ST_TagListe:	dc.l	Tag_More,STas_Tags
		dc.l	DTP_PlayerName,ST_Name
		dc.l	0

STas_Tags:
		dc.l	EP_InitAmplifier,InitAudstructST
		dc.l	DTP_InternalPlayer,1
		dc.l	DTP_PlayerVersion,2<<16!0
		dc.l	DTP_Creator,ST_CName
		dc.l	EP_Check5,ST_Check
		dc.l	DTP_ExtLoad,ST_ExtLoad
		dc.l	DTP_Interrupt,ST_Music
		dc.l	DTP_InitPlayer,ST_InitPlay
		dc.l	DTP_EndPlayer,ClearPatternInfo
		dc.l	DTP_InitSound,ST_Init
		dc.l	DTP_NextPatt,ST_NextPattern
		dc.l	DTP_PrevPatt,ST_PrevPattern
	;	dc.l	DTP_Volume,Pr_SetVoices
	;	dc.l	DTP_Balance,Pr_SetVoices

		dc.l	DTP_UserConfig,Pro_UserConfig
		dc.l	EP_NewModuleInfo,Pro_InfoBuffer
	;	dc.l	EP_Voices,PR_SetVoices
		dc.l	EP_GetPositionNr,ST_GetPosNr
		dc.l	EP_Save,ST_Save
		dc.l	EP_SaveAsPT,ST_SaveAsPt
		dc.l	EP_Sampleinit,ST_Sampleinit
		dc.l	EP_Patterninit,Pro_Pattinit
		dc.l	EP_Flags,EPB_EPAudioAlloc!EPB_VolBalVoi!EPB_InternalUPSStructure!EPB_Restart!EPB_Songend!EPB_VolVoices!EPB_Packable!EPB_Volume!EPB_Balance!EPB_Voices!EPB_Analyzer!EPB_Moduleinfo!EPB_Prevpatt!EPB_Nextpatt
		dc.l	EP_Date
		dc.b	CD_Tag,CD_Monat
		dc.w	CD_Jahr

		dc.l	0

AM_Data:	dc.l	0	
AM_Size:	dc.l	0	
LNTASFile	dc.w	0
NTASFile	dc.w	0

*-----------------------------------------------------------------------*
ST_Name:	dc.b	"Startrekker",0
as_Name:	dc.b	"Audio Sculpture",0
ST_CName:	dc.b	"Bjoern Wesen / Exolon of Fairlight,",10
		dc.b	"adapted by DEFECT",0
ST_NTName:	dc.b	".NT",0
ST_ASName:	dc.b	".AS",0
		even

*--------------------------------------------------------------------------*
ST_ExtLoad:	move.l	dtg_PathArrayPtr(a5),a0
		clr.b	(a0)			; clear Path
		move.l	dtg_CopyDir(a5),a0	; copy dir into patharray
		jsr	(a0)
		move.l	dtg_CopyFile(a5),a0	; append filename
		jsr	(a0)
		move.l	dtg_CutSuffix(a5),a0	; remove '.pp' suffix if necessary
		jsr	(a0)
		lea	ST_NTName(pc),a0	; join '.NT'
		clr.w	LNTASFile-ST_NTname(a0)
		move.l	dtg_CopyString(a5),a1
		jsr	(a1)

	*-------- NT-File laden -------*
		move.l	DTG_Dosbase(a5),a6
		move.l	DTG_PathArrayPtr(a5),d1
		moveq	#-2,d2			;ACCESS_READ
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoLock
		jsr	_LVOUnLock(a6)
		bra.b	.NTFile

	*-------- AS-File laden --------*
.NoLock:	move.l	dtg_PathArrayPtr(a5),a0
		clr.b	(a0)			; clear Path
		move.l	dtg_CopyDir(a5),a0	; copy dir into patharray
		jsr	(a0)
		move.l	dtg_CopyFile(a5),a0	; append filename
		jsr	(a0)
		move.l	dtg_CutSuffix(a5),a0	; remove '.pp' suffix if necessary
		jsr	(a0)
		lea	ST_ASName(pc),a0	; join '.AS'
		move.l	dtg_CopyString(a5),a1
		jsr	(a1)

		move.l	DTG_Dosbase(a5),a6
		move.l	DTG_PathArrayPtr(a5),d1
		moveq	#-2,d2			;ACCESS_READ
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoNTFile
		jsr	_LVOUnLock(a6)
.NTFile:	move.l	DTG_CutSuffix(a5),a0	; remove '.pp' suffix if necessary
		jsr	(a0)
		move.l	DTG_LoadFile(a5),a0
		jsr	(a0)			; returncode is already set !
		tst.l	d0
		bne.w	ST_Ret
.LoadSamples:	move.w	d0,LNTASFile
		bra.w	Pro_ExtLoad

.NoNTFile	moveq	#-1,d0
		bra.b	.LoadSamples



*---------------------- Save Startrekker als Protracker ----------------*
ST_SaveAsPT:	moveq	#EPR_SaveError,d0
		move.l	MT_Data,a0
		move.l	#"M.K.",$438(a0)
		lea	NTASFile(pc),a0
		tst.w	(a0)
		bne.w	Pro_Save
		tst.l	d0
		rts

	*------------------- Save Mem to Disk ----------------------*
	*---- ARG1 = StartAdr					----*
	*---- ARG2 = Lnge					----*
	*---- ARG3 = PathAdr					----*
	*---- ARG4 = CrunchMode					----*
	*---- ARG5 = Flags					----*
	*----	Bit 0 = Soll ein Anzeige in Playerswindow 0=ja  ----*
	*----	Bit 1 = Immer deprotecten			----*
	*-----------------------------------------------------------*
*-----------------------------------------------------------------------*
ST_Save:	tst.w	MT_InstrKennung(a5)
		beq.s	.SaveSTModule

	*------ Song als Modules saven/Memory zum Saven allocieren ------*
		move.l	Pro_InfoBuffer+68(pc),d0
		move.l	d0,Pro_SaveSize(a5)
		jsr	A5AllocMem(a5)
		move.l	d0,a4			;Speicheradresse
		move.l	d0,a3
		move.l	d0,Pro_SaveAdr(a5)
		tst.l	d0
		beq.w	.Return
		move.l	EPG_LoadedFiles(a5),d5
		subq.l	#2,d5
		ble.w	.Return
		add.l	Pro_InfoBuffer+68(pc),a3 ;Endadresse
		moveq	#0,d4
		move.l	MT_Data,a2
		move.l	MT_Size,d3		;Size des aktuellen Songs/Samples
		lea	-10(a2),a2
.NextData:	moveq	#EPR_SaveError,d7
		move.l	d4,d0
		move.l	DTG_GetListData(a5),a0
		jsr	(a0)
		tst.l	d0
		blt.w	.Return
		move.l	d3,d0			;Copiersize
.CopyNextByte:	cmp.l	a4,a3
		beq.w	.Return
		move.b	(a0)+,(a4)+
		subq.l	#1,d0
		bne.s	.CopyNextByte
		addq.l	#1,d4

	*---------- Lnge fr nchstes Sample laden --------*
		moveq	#31,d6
		sub.l	d4,d6
.NextSample:	lea	30(a2),a2
		moveq	#0,d3
		move.w	22(a2),d3
		add.l	d3,d3
		bne.s	.SampleLenOk
		dbf	d6,.NextSample
		bra.w	.Return

.SamplelenOk:	dbf	d5,.NextData




	*------------------ Module-saven ------------------*
.SaveSTModule:	move.l	Pro_SaveAdr(a5),a0		;Adr
		move.l	Pro_SaveSize(a5),d1		;Size
		bne.s	.SongLoaded
		move.l	MT_Data,a0			;Adr
		move.l	MT_Size,d1			;Size
.SongLoaded:	move.l	#"FLT4",$438(a0)		;Kennung setzen
		move.l	a0,EPG_Arg1(a5)
		move.l	d1,EPG_Arg2(a5)
		lea	PathPuffer(a5),a0
		move.l	a0,EPG_Arg3(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		moveq	#5,d0
		move.l	d0,EPG_Argn(a5)
		jsr	A5SaveMem(a5)
		move.l	d0,d7				;Error merken


	*------------------- Hilfsmem freigeben -----------------*
.Return:	move.l	Pro_SaveAdr(a5),d0
		beq.s	.NoHilfsMod
		move.l	d0,a1
		move.l	Pro_SaveSize(a5),d0
		beq.s	.NoHilfsMod
		move.l	4.w,a6
		jsr	_LVOFreeMem(a6)
		clr.l	Pro_SaveAdr(a5)
		clr.l	Pro_SaveSize(a5)

	*------------------ NT-File-Saven ------------------*
.NoHilfsMod:	tst.l	d7
		bne.s	.Error


		lea	NTASFile(pc),a0
		tst.w	(a0)
		bne.s	.Error

		lea	ST_NTName(pc),a0
		lea	as_TagListe(pc),a1
		cmp.l	PlayerAdr(a5),a1
		bne.s	.NameOk
		lea	ST_ASName(pc),a0
.NameOk:	move.l	DTG_CopyString(a5),a1
		jsr	(a1)
		lea	PathPuffer(a5),a0
		move.l	a0,EPG_Arg3(a5)
		move.l	AM_Data(pc),EPG_Arg1(a5)
		move.l	AM_Size(pc),EPG_Arg2(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		moveq	#5,d0
		move.l	d0,EPG_ArgN(A5)
		jsr	A5SaveMem(a5)
		move.l	d0,d7			;Error
.Error:		move.l	d7,d0
		tst.l	d0			;ReturnMeldung
		rts






*-----------------------------------------------------------------------*
ST_NextPattern:	lea	ST_SongPos(pc),a0
		moveq	#0,d0
		move.l	MT_Data,a3
		move.b	950(a3),d0
		subq.b	#1,d0
		cmp.b	(a0),d0
		bne.s	.NormalAdd			-> Restart
		move.b	#-1,(a0)			;Pos=FF		

		jsr	DT_SongEnd		;End of Song for Playerprogram
		bsr.w	ST_Reinit

.NormalAdd:	addq.b	#1,(a0)
ST_Set:		move.b	(a0),d0				;PatternNr read
		clr.b	-3(a0)				;Counter clear
		clr.b	1(a0)				;Break clear
		clr.w	-2(a0)				;PattPos clear
ST_Ret:		rts

*-----------------------------------------------------------------------*
ST_PrevPattern:	moveq	#0,d0
		lea	ST_SongPos(pc),a0
		move.b	(a0),d0
		bne.s	.NormalSub
		move.l	MT_Data,a3
		move.b	950(a3),(a0)			;Max.Pos nach SongPos
.NormalSub:	subq.b	#1,(a0)
		bra.s	ST_Set


*------------------------ StarTrekker Check-Routine ------------------------*
ST_Check:	move.l	DTG_ChkData(a5),a0
		cmp.l	#"FLT4",$438(a0)
		beq.s	.CheckOk
		cmp.l	#"EXO4",$438(a0)
		bne.s	.ST_CheckRet
.CheckOk:	moveq	#0,d0
.ST_CheckRet:	rts

*----------------------------------------------------------------------------*
ST_InitPlay:	moveq	#0,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)

		lea	MyNtFile,a3
		lea	ST_TagListe(pc),a2
		lea	AM_Size(pc),a1
		clr.l	(a1)

		move.w	MT_LInstrKennung(a5),MT_InstrKennung(a5)

		move.l	a0,MT_Data
		move.l	d0,MT_Size
		moveq	#0,d1				;AMSize
		move.w	LNTASFile-AM_Size(a1),NTASFile-AM_Size(a1)
		tst.w	NTASFile-AM_Size(a1)
		bne.s	.NoOwn

		moveq	#1,d0
		move.l	dtg_GetListData(a5),a0	; Function
		jsr	(a0)
		moveq	#0,d1
		lea	NTASFile(pc),a2
		addq.w	#1,(a2)
		cmp.l	#93,d0		; altes NT-File ???
		blo.s	.NoOwn
		subq.w	#1,(a2)
		move.l	a0,a3
		move.l	d0,d1

	;**** Test auf Startrekker ****
		addq.l	#8,a0
		move.l	a0,a1
		lea	ST_TagListe(pc),a2
		cmp.l	#"dule",(A0)+
		bne.s	.TestAudioS
		cmp.l	#"INFO",(a0)
		beq.s	.NoOwn

	;**** Test auf AudioSculpture ****
.TestAudioS:	lea	-2(a1),a0
		lea	as_TagListe(pc),a2
		cmp.l	#"culp",(a0)+
		bne.w	.InitError
		cmp.l	#"ture",(a0)
		bne.w	.InitError

	*-------- Wirkliche PlayerAdr merken ---------*
.NoOwn:		move.l	a2,PlayerAdr(a5)
		lea	AM_Data(pc),a1
		move.l	a3,(a1)
		move.l	d1,AM_Size-AM_Data(a1)


	;**** Module-Infotagliste fllen ****
		lea	Pro_InfoBuffer(pc),a0
		move.l	MT_Data,a1
		move.l	a1,a2
		move.l	a1,4(a0)
		clr.l	20(a0)			;sampleanz clearen
		clr.l	60(a0)			;samplesize clearen
		move.w	#31,28+2(a0)		;max Samples

		move.l	a1,4(a0)		;songname setzen
		add.l	#42,a1

		moveq	#31-1,d2
		moveq	#0,d3
.addsample:	moveq	#0,d0
		move.w	(a1),d0
		beq.s	.NoAddSample
		addq.l	#1,20(a0)		;zur sampleanz dazuaddieren
		add.l	d0,d3
		add.l	d0,d3
.NoAddSample:	add.l	#$1e,a1
		dbf	d2,.addsample

		add.l	AM_Size(pc),d3
		move.l	d3,68(a0)		;Gesamtgre
		move.l	d3,60(a0)		;Samplesize
		move.l	MT_Size,d2
		add.l	AM_Size(pc),d2

		tst.w	MT_InstrKennung(a5)
		beq.s	.NoSong
		add.l	d3,d2
.NoSong:	move.l	d2,100(a0)		;SampleSize fr Loadsize

		lea	$3B8(A2),A1
		moveq	#0,d2
		move.b	-2(a1),d2
		move.l	d2,36(a0)		;LengthAnz setzen

		moveq	#$7f,d2
		moveq	#0,d0
.NoHigher:	cmp.b	(a1)+,d0
		bgt.s	.SchleifHigher
		move.b	-1(a1),d0
.SchleifHigher:	dbf	d2,.NoHigher
		addq.l	#1,d0
		move.l	d0,44(a0)		;PatternAnz setzen

		move.l	#1024,d2
		mulu	d0,d2

		move.l	#1084,d1
		add.l	d2,d1
		move.l	d1,52(a0)		;Zur SongSize dazuaddieren
		add.l	d1,68(a0)		;Gesamtgre

		moveq	#4,d0
		lea	PRO_NamePuffer,a1
		lea.l	20(a2),a3
.CopyName:	move.l	(a2)+,(a1)+
		dbf	d0,.CopyName

*--------------------------------------------------------------------*
*------------------ Composer eines Musicstckes finden --------------*
*---- ARG1 = Start des Samples					-----*
*---- ARG2 = Offset to next Samples				-----*
*---- ARG3 = Length of Samplename				-----*
*---- ARG4 = Sampleanzahl					-----*
*---- Ergebnis = Arg1 = Pointer to Author			-----*
*---- Ergebnis = Arg2 = Size of Authorname			-----*
*--------------------------------------------------------------------*
		move.l	MT_Data,a1
		lea	20(a1),a1
		move.l	a1,EPG_Arg1(a5)
		moveq	#30,d0
		move.l	d0,EPG_Arg2(a5)
		moveq	#20,d0
		move.l	d0,EPG_Arg3(a5)
		moveq	#31,d0
		move.l	d0,EPG_Arg4(a5)
		moveq	#4,d0
		move.l	d0,EPG_ArgN(a5)
		jsr	ENPP_FindAuthor(a5)
		move.l	EPG_Arg1(a5),12(a0)		;AuthorAdr lschen

	*--------------- FastRamReplayer initialisieren ----------------*
		lea	FastLoad(pc),a2
		clr.b	(a2)

		move.l	MT_Data,a1
		move.l	4,a6
		jsr	_LVOTypeOfMem(a6)
		btst	#1,d0
		bne.s	.chip

	*------- Module liegt im FASTMem -------*
		st	(a2)
.chip
		moveq	#0,d0
		rts
;	*-------- Audio-Kanle allocieren ----------*
;		jmp	ENPP_AllocAudio(a5)	; returncode is already set !

.InitError:	moveq	#-1,d0
		rts



;===================== SAMPLEINIT ======================================
ST_SampleInit:	moveq	#30,d6			;max Samples

		move.l	MT_Data,a4
		lea	20(a4),a4

	*----------- SampleInfo-Struktur anlegen ----------*
		moveq	#EPR_NotEnoughMem,d7
		lea	Pro_Samplestarts(pc),a2

		lea	PRO_FirstSInfo,a3
.NextSample:
		jsr	EPP_AllocSampleStruct	;Frischer leerer Speicher !!!
		move.l	d0,(a3)
		beq.s	.Return
		move.l	d0,a3

		move.l	a4,EPS_SampleName(a3)
		move.l	(a2),EPS_Adr(a3)

		moveq	#0,d0			;Samplelength setzen
		move.w	22(a4),d0
		add.l	d0,d0
		move.l	d0,EPS_Length(a3)

		moveq	#0,d0
		move.b	24(a4),d0
		sub.b	#16,d0
		ext.w	d0
		move.w	d0,EPS_Finetune(a3)

		moveq	#0,d0
		move.b	25(a4),d0
		move.l	d0,EPS_Volume(a3)

		moveq	#0,d0			;Samplereplen setzen
		move.w	26(a4),d0
		add.l	d0,d0
		move.w	d0,EPS_Replen+2(a3)

		moveq	#0,d0			;Samplerepeat setzen
		move.w	26(a4),d0
		add.l	d0,d0
		move.w	d0,EPS_Repeat+2(a3)

		move.w	#3!USIB_8Bit,EPS_Flags(a3)
		tst.w	22(a4)
		bne.s	.noAM
		cmp.b	#$40,25(a4)
		bne.s	.noAM

		clr.w	EPS_Flags(a3)
		move.w	#USITY_AMSynth,EPS_Type(A3)
.noAM
		move.w	#22,EPS_MaxNameLen(a3)

		addq.l	#4,a2			;SamplePointer erhhen
		lea	30(a4),a4
		dbf	d6,.NextSample

		moveq	#0,d7			;Kein Error
.Return:	move.l	d7,d0
		move.l	Pro_FirstSInfo,EPG_SampleInfoStructure(a5)
		rts

*----------- Daten des aktuell angespielten Samples kopieren ----------*
ST_GetAMVoice:	move.l	a1,-(sp)
		move.l	StructAdr,a1		;1.Kanal
		cmp.l	#$dff0a0,a5
		beq.s	.yes
		lea	UPS_Modulo(a1),a1		;2.Kanal
		cmp.l	#$dff0b0,a5
		beq.s	.yes
		lea	UPS_Modulo(a1),a1		;3.Kanal
		cmp.l	#$dff0c0,a5
		beq.s	.yes
		lea	UPS_Modulo(a1),a1		;4.Kanal
.yes:		move.w	$10(a4),UPS_Voice1Per(a1)		;Periode
		move.l	$a(a4),UPS_Voice1Adr(a1)		;Adresse
		clr.w	UPS_Voice1Repeat(a1)			;Repeat = on
		move.w	10(a4),UPS_Voice1len(a1)		;Lnge
		move.l	(sp)+,a1
		rts

*-----------------------------------------------------------------------*
ST_GetPosNr:	moveq	#0,d0
		move.b	ST_SongPos(pc),d0
		rts

; Audio Sculpture Amiga ---* REPLAY ROUTINE *---
; 
; Call ST_init, then ST_music each frame, call ST_end to stop
; NOTE! The ST_amwaveforms have to reside in CHIPMEM!
 
ST_Init:	lea	ST_Speed(pc),a0
		move.l	a0,a1
		move.w	#ST_VoiceEnd-ST_Speed-1,d0
.ClearVoices:	clr.b	(a0)+
		dbf	d0,.ClearVoices

		addq.w	#1,$1a+ST_Voice1-ST_Speed(a1)
		addq.w	#2,$1a+ST_Voice2-ST_Speed(a1)
		addq.w	#4,$1a+ST_Voice3-ST_Speed(a1)
		addq.w	#8,$1a+ST_Voice4-ST_Speed(a1)

		move.l	MT_Data,a0
		lea	$3b8(a0),a1
		moveq	#$7f,d0
		moveq	#0,d2
		moveq	#0,d1
ST_lop2:	move.b	(a1)+,d1
		cmp.b	d2,d1
		ble.s	ST_lop
		move.l	d1,d2
ST_lop:		dbf	d0,ST_lop2


		lea	ST_Samplestarts(pc),a1

		tst.w	MT_InstrKennung(a5)
		beq.s	.Module

		moveq	#2,d7			;Zahler fr GetListData
		tst.w	NTASFile-ST_SampleStarts(a1)
		beq.b	.NTFile
		moveq	#1,d7
.NTFile:	move.l	MT_Data,a2
		moveq	#31,d6
		lea	$14(a2),a2
.NextSample:	tst.w	24(a2)
		beq.s	.NoSample
		move.l	d7,d0
		move.l	DTG_GetListData(a5),a0
		jsr	(a0)
		beq.s	.NoSample
		clr.l	(a0)
		addq.l	#1,d7
		move.l	a0,(a1)				;SampleAdr merken
.NoSample:	addq.l	#4,a1
		lea	$1e(a2),a2
		dbf	d6,.NextSample		
		bra.b	.SamplesOk

	*--------- Es wurde ein Module geladen ---------*
.Module:	addq.b	#1,d2
		asl.l	#8,d2
		asl.l	#2,d2
		add.l	#$43C,d2
		add.l	a0,d2				;FirstSample
		move.l	d2,a2
		moveq	#$1E,d0
		move.l	MT_Size,d3
		add.l	a0,d3
.ST_Init4:	cmp.l	a2,d3
		ble.s	.noe
		clr.l	(a2)
.noe:		move.l	a2,(a1)+		;sampleStart nach Puffer
		moveq	#0,d1
		move.w	$2A(a0),d1
		asl.l	#1,d1
		add.l	d1,a2
		add.l	#$1E,a0
		dbf	d0,.ST_Init4

.SamplesOk:
ST_Reinit:	lea	ST_SongPos(pc),a1
		clr.b	(a1)
		clr.b	ST_Counter-ST_SongPos(a1)
		clr.w	ST_PattPos-ST_SongPos(a1)
		move.b	#6,ST_Speed-ST_SongPos(a1)
		rts

ST_SetVoices:	move.l	a5,-(a7)
		move.l	a3,a5
		bsr.w	Pro_SetVoices
		move.l	(a7)+,a5
		rts

*-----------------------------------------------------------------------*
ST_Music:	movem.l	d1-a6,-(a7)

		move.l	StructAdr,a1
		move.w	#1,UPS_Enabled(a1)
	;	move.w	#UPSB_Adr!UPSB_LEN!UPSB_Per!UPSB_Vol!UPSB_DMACON,d0
	;	move.w	d0,UPS_Flags(a1)
		clr.w	UPS_Voice1Per(a1)
		clr.w	UPS_Voice2Per(a1)
		clr.w	UPS_Voice3Per(a1)
		clr.w	UPS_Voice4Per(a1)

		bsr.s	ST_Music2

		move.l	StructAdr,a1
		clr.w	UPS_Enabled(a1)
		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts

ST_Music2:	move.l	MT_Data,a0
		lea	ST_Counter(pc),a1
		addq.b	#1,(a1)
		move.b	(a1),d0
		cmp.b	ST_speed(pc),d0
		blt.w	ST_NoNew
		clr.b	(a1)
		move.l	MT_Data,a0
		lea	$c(a0),a3
		lea	$3b8(a0),a2
		lea	$43c(a0),a0

		moveq	#0,d0
		moveq	#0,d1
		move.b	ST_songpos(pc),d0
		move.b	(a2,d0),d1
		mulu	#1024,d1
		add	ST_pattpos(pc),d1

		clr.w	ST_dmacon-ST_Counter(a1)

		lea	$dff0a0,a5
		lea	ST_voice1(pc),a4
		bsr	ST_playvoice
		addq.l	#4,d1
		addq.l	#8,a5
		addq.l	#8,a5
		lea	ST_voice2(pc),a4
		bsr	ST_playvoice
		addq.l	#4,d1
		addq.l	#8,a5
		addq.l	#8,a5
		lea	ST_voice3(pc),a4
		bsr	ST_playvoice
		addq.l	#4,d1
		addq.l	#8,a5
		addq.l	#8,a5
		lea	ST_voice4(pc),a4
		bsr	ST_playvoice

;		jsr	DTWaitAudioDma

		move	ST_dmacon(pc),d0
		or	#$8000,d0
		bsr	PokeDMA

;		move	d0,$dff096
;		jsr	DTWaitAudioDma


	move.l	a5,-(sp)
		lea	$dff0a0,a5
		lea	ST_voice1(pc),a4
		move.l	$a(a4),d0
		bsr	PokeAdr			;(a5)
		move	$e(a4),d0		;4(a5)
		bsr	PokeLen

		tst	30(a4)
		bne.s	.ST_nov1
		move	$12(a4),d0		;8(a5)
		bsr.w	Pro_SetVoices
.ST_nov1:	lea	ST_voice2(pc),a4
		lea	$dff0b0,a5
		move.l	$a(a4),d0
		bsr	PokeAdr			;(a5)
		move	$e(a4),d0		;4(a5)
		bsr	PokeLen

		tst	30(a4)
		bne.s	.ST_nov2
		move	$12(a4),d0		;8(a5)
		bsr.w	Pro_SetVoices
.ST_nov2:	lea	ST_voice3(pc),a4
		lea	$dff0c0,a5
		move.l	$a(a4),d0
		bsr	PokeAdr			;(a5)
		move	$e(a4),d0		;4(a5)
		bsr	PokeLen

		tst	30(a4)
		bne.s	.ST_nov3
		move	$12(a4),d0		;8(a5)
		bsr.w	Pro_SetVoices
.ST_nov3:	lea	ST_voice4(pc),a4
		lea	$dff0d0,a5
		move.l	$a(a4),d0
		bsr	PokeAdr			;(a5)
		move	$e(a4),d0		;4(a5)
		bsr	PokeLen

		tst	30(a4)
		bne.s	.ST_nov4
		move	$12(a4),d0		;8(a5)
		bsr.w	Pro_SetVoices
.ST_nov4:
		lea	$dff000,a3
	move.l	(sp)+,a5

		lea	ST_PattPos(pc),a0
		add.w	#$10,(a0)		;ST_pattpos
		cmp.w	#$400,(a0)		;ST_pattpos
		bne.s	ST_exit
ST_next:	clr	ST_pattpos
ST_nxt2:	lea	ST_SongPos(pc),a0
		;clr.b	ST_break
		;addq.b	#1,ST_songpos
		;and.b	#$7f,ST_songpos
		clr.b	ST_Break-ST_SongPos(a0)
		addq.b	#1,(a0)
		and.b	#$7f,(a0)

		move.l	MT_Data,a0
		move.b	$3b6(a0),d0

		cmp.b	ST_songpos(pc),d0
		bne.s	ST_exit

		bsr.w	ST_Reinit
		move.b	$3b7(a0),ST_songpos
		jsr	DT_SongEnd

ST_exit:	lea	ST_Break(pc),a1
	;	tst.b	ST_break
		tst.b	(a1)
		beq	ST_amhandler

	;	clr	ST_pattpos
		clr.w	ST_PattPos-ST_Break(a1)
		bra.s	ST_nxt2

ST_nonew:	lea	ST_voice1(pc),a4
		lea	$dff0a0,a5
		bsr	ST_com
		lea	ST_voice2(pc),a4
		lea	$dff0b0,a5
		bsr	ST_com
		lea	ST_voice3(pc),a4
		lea	$dff0c0,a5
		bsr	ST_com
		lea	ST_voice4(pc),a4
		lea	$dff0d0,a5
		bsr	ST_com
		bra	ST_exit

		;rts

;ST_mulu:	dc	0,$1e,$3c,$5a,$78,$96,$b4,$d2,$f0,$10e,$12c,$14a
;		dc	$168,$186,$1a4,$1c2,$1e0,$1fe,$21c,$23a,$258,$276
;		dc	$294,$2b2,$2d0,$2ee,$30c,$32a,$348,$366,$384,$3a2

ST_playvoice:	move.l	(a0,d1.l),(a4)
		moveq	#0,d2
		move.b	2(a4),d2
		lsr.b	#4,d2
		move.b	(a4),d0
		and.b	#$f0,d0
		or.b	d0,d2
		beq	ST_oldinstr

		lea	ST_samplestarts-4(pc),a1
		move	d2,34(a4)
		move	d2,d0
		mulu	#120,d0
		move.l	a0,-(sp)
		move.l	AM_Data(pc),a0
		lea	24(a0,d0.l),a0
		clr	30(a4)
		moveq	#64,d0
		cmp	#"AM",(a0)
		bne.s	ST_noa9
		move	6(a0),d0
		lsr	#2,d0
		st	30(a4)
ST_noa9:	move.l	(sp)+,a0
		asl	#2,d2
		move.l	(a1,d2.l),4(a4)
		lsr	#2,d2
		mulu	#30,d2
		move	(a3,d2),8(a4)
		move	2(a3,d2),$12(a4)
		moveq	#0,d3
		move	4(a3,d2),d3
		move	d0,-(sp)
		tst	d3
		beq.s	ST_noloop
		move.l	4(a4),d0
		asl	#1,d3
		add.l	d3,d0
		move.l	d0,$a(a4)
		move	4(a3,d2),d0
		add	6(a3,d2),d0
		move	d0,8(a4)
		bra.s	ST_hejaSverige
ST_noloop:	move.l	4(a4),d0
		add.l	d3,d0
		move.l	d0,$a(a4)
ST_hejaSverige:	move	6(a3,d2),$e(a4)
		move	(sp)+,d0
		mulu	$12(a4),d0
		lsr	#6,d0
	;	move	d0,8(a5)
	bsr.w	PRO_SetVoices

ST_oldinstr:	move	(a4),d0
		and	#$fff,d0
		beq	ST_com2
		tst	30(a4)
		bne.s	ST_rambo
		tst	8(a4)
		beq	ST_stopsound
		tst.b	$12(a4)
		bne	ST_stopsound
		move.b	2(a4),d0
		and.b	#$f,d0
		cmp.b	#5,d0
		beq	ST_setport
		cmp.b	#3,d0
		beq	ST_setport
ST_rambo:	move	(a4),$10(a4)
		and	#$fff,$10(a4)

		move	$1a(a4),d0	;$dff096
		bsr	Pokedma

		clr.b	$19(a4)

	tst	30(a4)
	beq.s	ST_noaminst

		move.l	a0,-(sp)
		move	34(a4),d0
		mulu	#120,d0
		move.l	AM_Data(pc),a0
		lea	24(a0,d0.l),a0
		moveq	#0,d0
		move	26(a0),d0
		lsl	#5,d0
		add.l	#ST_amwaveforms,d0

	bsr	pokeadr			;move.l	d0,(a5)
		move.l	d0,$a(a4)

	moveq	#16,d0
	bsr	pokelen			;move.w	#16,4(a5)
		move	d0,$e(a4)

		move	6(a0),32(a4)
		move.l	#1,36(a4)
		move	34(a0),d0
		move	d1,-(sp)
		move	$10(a4),d1
		lsl	d0,d1
		move	d1,$10(a4)
		move	d1,74(a4)

	move.w	d0,-(sp)
	move	d1,d0
	bsr	PokePer	;move	d1,6(a5)
	move.w	(sp)+,d0

	bsr.w	ST_GetAMVoice

		move	(sp)+,d1
		move.l	(sp)+,a0

	bra.s	ST_juck

ST_noaminst:
	move.l	4(a4),d0
	bsr	PokeAdr		;move.l	d0,(a5)

	move	8(a4),d0
	bsr	PokeLen		;move.w	d0,4(a5)

	move	$10(a4),d0	
	bsr	PokePer		;move.w	d0,6(a5)

	move.l	a6,-(a7)
	move.l	a4,a6
	bsr.w	Pro_GetVoice
	move.l	(a7)+,a6

ST_juck:	move	$1a(a4),d0
		or	d0,ST_dmacon
		bra	ST_com2

ST_stopsound:	move	$1a(a4),d0		;$dff096
		bsr	Pokedma
		bra	ST_com2

ST_setport:	move	(a4),d2
		and	#$fff,d2
		move	d2,$16(a4)
		move	$10(a4),d0
		clr.b	$14(a4)
		cmp	d0,d2
		beq.s	ST_clrport
		bge	ST_com2
		move.b	#1,$14(a4)
		bra	ST_com2
ST_clrport:	clr	$16(a4)
		rts

ST_port:	move.b	3(a4),d0
		beq.s	ST_port2
		move.b	d0,$15(a4)
		clr.b	3(a4)
ST_port2:	tst	$16(a4)
		beq.s	ST_rts
		moveq	#0,d0
		move.b	$15(a4),d0
		tst.b	$14(a4)
		bne.s	ST_sub
		add	d0,$10(a4)
		move	$16(a4),d0
		cmp	$10(a4),d0
		bgt.s	ST_portok
		move	$16(a4),$10(a4)
		clr	$16(a4)
ST_portok:
		move	$10(a4),d0
		bsr	Pokeper		;6(a5)
		move	$10(a4),74(a4)
ST_rts:		rts

ST_sub:		sub	d0,$10(a4)
		move	$16(a4),d0
		cmp	$10(a4),d0
		blt.s	ST_portok
		move	$16(a4),$10(a4)
		clr	$16(a4)
		move	$10(a4),d0
		bsr	PokePer		;move.w	d0,6(a5)
		move	$10(a4),74(a4)
		rts

ST_sin:		dc.b	0,$18,$31,$4a,$61,$78,$8d,$a1,$b4,$c5,$d4,$e0,$eb,$f4
		dc.b	$fa,$fd
		dc.b	$ff,$fd,$fa,$f4,$eb,$e0,$d4,$c5,$b4,$a1,$8d,$78,$61
		dc.b	$4a,$31,$18

ST_vib:		move.b	$3(a4),d0
		beq.s	ST_vib2
		move.b	d0,$18(a4)

ST_vib2:	move.b	$19(a4),d0
		lsr	#2,d0
		and	#$1f,d0
		moveq	#0,d2
		move.b	ST_sin(pc,d0),d2
		move.b	$18(a4),d0
		and	#$f,d0
		mulu	d0,d2
		lsr	#7,d2
		move	$10(a4),d0
		tst.b	$19(a4)
		bmi.s	ST_vibsub
		add	d2,d0
		bra.s	ST_vib3

ST_vibsub:	sub	d2,d0
ST_vib3:	
		bsr	PokePer		;move	d0,6(a5)
		move	d0,74(a4)
		move.b	$18(a4),d0
		lsr	#2,d0
		and	#$3c,d0
		add.b	d0,$19(a4)
		rts

ST_arplist:	dc.b	0,1,2,0,1,2,0,1,2,0,1,2,0
		dc.b	1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1
ST_arp:		moveq	#0,d0
		move.b	ST_counter(pc),d0
		move.b	ST_arplist(pc,d0),d0
		beq.s	ST_arp0
		cmp.b	#2,d0
		beq.s	ST_arp2
ST_arp1:	moveq	#0,d0
		move.b	3(a4),d0
		lsr.b	#4,d0
		bra.s	ST_arpdo

ST_arp2:	moveq	#0,d0
		move.b	3(a4),d0
		and.b	#$f,d0
ST_arpdo:	asl	#1,d0
		move	$10(a4),d1
		and	#$fff,d1
		lea	ST_periods(pc),a0
		moveq	#$24,d2
ST_arp3:	cmp	(a0)+,d1
		bge.s	ST_arpfound
		dbf	d2,ST_arp3
ST_arp0:	move	$10(a4),d0
		bsr	PokePer			;6(a5)
		move	$10(a4),74(a4)
		rts

ST_arpfound:
		move	-2(a0,d0),74(a4)
		move	-2(a0,d0),d0
		bsr	PokePer			;move.w	d0,6(a5)
		rts

ST_normper:	move	$10(a4),d0
		bsr	PokePer			;6(a5)
		move	$10(a4),74(a4)
		rts

ST_com:		move	2(a4),d0
		and	#$fff,d0
		beq.s	ST_normper
		move.b	2(a4),d0
		and.b	#$f,d0
		tst.b	d0
		beq.w	ST_arp
		cmp.b	#1,d0
		beq	ST_portup
		cmp.b	#2,d0
		beq	ST_portdown
		cmp.b	#$e,d0
		beq.s	ST_playmacro
		cmp.b	#3,d0
		beq	ST_port
		cmp.b	#4,d0
		beq	ST_vib
		cmp.b	#5,d0
		beq	ST_volport
		cmp.b	#6,d0
		beq	ST_volvib
		tst	30(a4)
		bne.s	ST_jug
	move	d0,-(Sp)
		move	$10(a4),d0
		bsr	PokePer			;6(a5)
	move	(sp)+,d0

ST_jug:		cmp.b	#$a,d0
		beq	ST_volslide
		rts

ST_playmacro:	tst.w	NTASFile
		bne.s	ST_NoMacroq
		tst.l	42(a4)
		beq.s	ST_nomacroq
		movem.l	d0-d4/a0-a4/a6,-(sp)
		lea	(a4),a6
		move.l	42(a6),a3
		lea	ST_macrocall(pc),a4
		moveq	#0,d0
		move.b	3(a6),d0
		and.b	#$f,d0
		movem.l	46(a6),d1-d4/a0-a2
 **** Test, da EP bei "ST.Muppet-Synthetical" mit korruptem NRFile abgurut
	tst.w	(a3)
	beq.s	.Error
		jsr	(a3)
.Error		movem.l	d1-d4/a0-a2,46(a6)
		movem.l	(sp)+,d0-d4/a0-a4/a6
ST_nomacroq:	rts

ST_macrocall:	bra.s	ST_Mstopdma
		bra.s	ST_Mstartdma
		bra.s	ST_Mgetperiod
		bra.s	ST_Mgetnote
		rts	
		nop

ST_Mstopdma:
		move	d0,-(sp)
		move	26(a6),d0		;$dff096
		bsr	Pokedma

;		jmp	DTWaitAudioDma
;		move	#400,d0
;ST_mw1:	dbf	d0,ST_mw1

		move	(sp)+,d0
		rts

ST_Mstartdma:	move	d0,-(sp)
		move	26(a6),d0
		or	#$8000,d0
		bsr	PokeDMA
;		move	d0,$dff096
		move	(sp)+,d0
		rts

;		jmp	DTWaitAudioDma
;		move	#400,d0
;ST_mw2:	dbf	d0,ST_mw2
;		rts

ST_Mgetperiod:	move.l	a0,-(sp)
		lea	ST_periods(pc),a0
		add	d0,d0
		move	(a0,d0),d0
		move.l	(sp)+,a0
		rts

ST_Mgetnote:	movem.l	d1-d2/a0,-(sp)
		lea	ST_periods(pc),a0
		moveq	#$37,d2
		moveq	#0,d1
ST_mtl:		cmp	(a0)+,d0
		bge.s	ST_Mgotnote
		addq	#1,d1
		dbf	d2,ST_mtl
ST_Mgotnote:	move	d1,d0
		movem.l	(sp)+,d1-d2/a0
		rts

ST_portup:	moveq	#0,d0
		move.b	3(a4),d0
		sub	d0,$10(a4)
		move	$10(a4),d0
		cmp	#$71,d0
		bpl.s	ST_portup2
		move	#$71,$10(a4)
ST_portup2:
		move	$10(a4),d0
		bsr	PokePer		;move.w	d0,6(a5)
		move	$10(a4),74(a4)
		rts

ST_portdown:	moveq	#0,d0
		move.b	3(a4),d0
		add	d0,$10(a4)
		move	$10(a4),d0
		cmp	#$358,d0
		bmi.s	ST_portdown2
		move	#$358,$10(a4)
ST_portdown2:	
		move	$10(a4),d0		;6(a5)
		bsr	PokePer
		move	$10(a4),74(a4)
		rts

ST_volvib:	 bsr	ST_vib2
	 	bra.s	ST_volslide

ST_volport:	 bsr	ST_port2

ST_volslide:	moveq	#0,d0
		move.b	3(a4),d0
		lsr.b	#4,d0
		beq.s	ST_vol3
		add.b	d0,$13(a4)
		cmp.b	#$40,$13(a4)
		bmi.s	ST_vol2
		move.b	#$40,$13(a4)
ST_vol2:	tst	30(a4)
		bne.s	ST_zex
	;	moveq	#0,d0				;neu alt ???
		move.b	$13(a4),d0
	;	move	d0,8(a5)
	bsr.w	PRO_SetVoices
ST_zex:		rts

ST_vol3:	move.b	3(a4),d0
		and.b	#$f,d0
		sub.b	d0,$13(a4)
		bpl.s	ST_vol4
		clr.b	$13(a4)
ST_vol4:	tst	30(a4)
		bne.s	ST_zeq
	;	moveq	#0,d0				; neu alt ???
		move.b	$13(a4),d0
	;	move	d0,8(a5)
	bsr.w	PRO_SetVoices
ST_zeq:		rts

ST_com2:	move.b	$2(a4),d0
		and.b	#$f,d0
		cmp.b	#$e,d0
		beq.s	ST_startmacro
		cmp.b	#$d,d0
		beq.s	ST_pattbreak
		cmp.b	#$b,d0
		beq.s	ST_songjmp
		cmp.b	#$c,d0
		beq	ST_setvol
		cmp.b	#$f,d0
		beq	ST_setspeed
		rts

ST_startmacro:	movem.l	d0-d4/a0-a4/a6,-(sp)
		lea	(a4),a6
		move.b	3(a6),d0
		and	#$f0,d0
		lsr.b	#4,d0
		mulu	#272,d0
		add.l	#32*120+144+16,d0
		add.l	AM_Data,d0
		move.l	d0,a0
		cmp	#$ABCD,(a0)
		beq.s	ST_skipmac
		move.l	42(a6),d1
		move.l	d0,42(a6)
		cmp.l	d0,d1
		bne.s	ST_resetM
		move	(a6),d0
		and	#$fff,d0
		beq.s	ST_skipmac
ST_resetM:	clr.l	46(a6)
		clr.l	50(a6)
		clr.l	54(a6)
		clr.l	58(a6)
		clr.l	62(a6)
		clr.l	66(a6)
		clr.l	70(a6)
		bsr	ST_playmacro
ST_skipmac:	movem.l	(sp)+,d0-d4/a0-a4/a6
		rts

ST_pattbreak:	move.b	#1,ST_break
		rts

ST_songjmp:	move.b	#1,ST_break
		move.b	3(a4),d0
	;	subq.b	#1,d0
		cmp.b	ST_songpos(pc),d0
		bhi.s	.Ok
		jsr	DT_SongEnd
.Ok		move.b	d0,ST_songpos
		rts

ST_setvol:	cmp.b	#$40,3(a4)
		bls.s	ST_sv2
		move.b	#$40,3(a4)
ST_sv2:	;	moveq	#0,d0			;neu alt ????
		move.b	3(a4),d0
		move.b	d0,$13(a4)
	;	move	d0,8(a5)
	bra.w	PRO_SetVoices
	;	rts

ST_setspeed:	moveq	#0,d0
		move.b	3(a4),d0
		cmp.b	#$1f,d0
		bls.s	ST_sp2
		moveq	#$1f,d0
ST_sp2:		tst	d0
		bne.s	ST_sp3

		jsr	DT_SongEnd

		moveq	#1,d0
ST_sp3:		move.b	d0,ST_speed
		rts

ST_amhandler:
	movem.l	d0-a6,-(sp)

	lea	mypattinfo(pc),a0
	move.w	st_pattpos(pc),d0
	lsr.w	#4,d0
	move.w	d0,pi_pattpos(a0)
	move.b	st_songpos(pc),d0
	move.w	d0,PI_Songpos(A0)

	move.l	mt_data,a1
	add.w	#$3b8,d0
	move.b	(a1,d0.w),d0			;Patternnumber
	and.w	#$ff,d0
	move.w	d0,pi_pattern(A0)		;save
	mulu	#1024,d0			;mulu 1024
	add.l	#$43c,d0			;add Infoblock
	lea	(a1,d0.l),a1			;Patternadr
	move.l	a1,pi_Stripes(a0)
	addq.l	#4,a1
	move.l	a1,pi_Stripes+4(a0)
	addq.l	#4,a1
	move.l	a1,pi_Stripes+8(a0)
	addq.l	#4,a1
	move.l	a1,pi_Stripes+12(a0)
	move.w	#125,pi_bpm(a0)			;set Tempo
	move.b	st_speed(pc),pi_speed+1(a0)	;set Speed

	movem.l	(sp)+,d0-a6

		moveq	#3,d7
		lea	ST_voice1(pc),a6
		lea	$dff0a0,a5
ST_amloop:	tst	30(a6)
		beq	ST_anrp
		move	34(a6),d0
		mulu	#120,d0
		move.l	AM_Data(pc),a0
		lea	24(a0,d0.l),a0
		tst	38(a6)
		beq	ST_anrp
		cmp	#1,38(a6)
		bne.s	ST_anat
		move	32(a6),d0
		cmp	8(a0),d0
		beq.s	ST_aaeq
		cmp	8(a0),d0
		blt.s	ST_aaad
		move	10(a0),d0
		sub	d0,32(a6)
		move	32(a6),d0
		cmp	8(a0),d0
		bgt	ST_anxt
		move	8(a0),32(a6)
ST_aaeq:	move	#2,38(a6)
		bra	ST_anxt
ST_aaad:	move	10(a0),d0
		add	d0,32(a6)
		move	32(a6),d0
		cmp	8(a0),d0
		blt	ST_anxt
		move	8(a0),32(a6)
		bra.s	ST_aaeq

ST_anat:	cmp	#2,38(a6)
		bne.s	ST_ana2
		move	32(a6),d0
		cmp	12(a0),d0
		beq.s	ST_a2eq
		cmp	12(a0),d0
		blt.s	ST_a2ad
		move	14(a0),d0
		sub	d0,32(a6)
		move	32(a6),d0
		cmp	12(a0),d0
		bgt	ST_anxt
		move	12(a0),32(a6)
ST_a2eq:	move	#3,38(a6)
		bra	ST_anxt

ST_a2ad:	move	14(a0),d0
		add	d0,32(a6)
		move	32(a6),d0
		cmp	12(a0),d0
		blt	ST_anxt
		move	12(a0),32(a6)
		bra.s	ST_a2eq

ST_ana2:	cmp	#3,38(a6)
		bne.s	ST_andc
		move	32(a6),d0
		cmp	16(a0),d0
		beq.s	ST_adeq
		cmp	16(a0),d0
		blt.s	ST_adad
		move	18(a0),d0
		sub	d0,32(a6)
		move	32(a6),d0
		cmp	16(a0),d0
		bgt.s	ST_anxt
		move	16(a0),32(a6)
ST_adeq:	move	#4,38(a6)
		move	20(a0),40(a6)
		bra.s	ST_anxt

ST_adad:	move	18(a0),d0
		add	d0,32(a6)
		move	32(a6),d0
		cmp	16(a0),d0
		blt.s	ST_anxt
		move	16(a0),32(a6)
		bra.s	ST_adeq

ST_andc:	cmp	#4,38(a6)
		bne.s	ST_anst
		subq	#1,40(a6)
		bpl.s	ST_anxt
		move	#5,38(a6)
		bra.s	ST_anxt

ST_anst:	move	24(a0),d0
		sub	d0,32(a6)
		bpl.s	ST_anxt
		clr.l	30(a6)
		clr	38(a6)
		move	26(a6),d0	;$dff096
		bsr	PokeDMA

ST_anxt:	move	32(a6),d0
		lsr	#2,d0
		move	$12(a6),d1
		mulu	d1,d0
		lsr	#6,d0
	;	move	d0,8(a5)
	bsr.w	PRO_SetVoices

		move	28(a0),d0
		add	d0,74(a6)
		add	d0,$10(a6)

		move	30(a0),d1
		beq.s	ST_nvib
		move	36(a6),d2
		moveq	#0,d3
		cmp	#360,d2
		blt.s	ST_vibq
		sub	#360,d2
		moveq	#1,d3
ST_vibq:	lea	ST_amsinus,a2
		muls	(a2,d2),d1
		asr	#7,d1
		tst	d3
		beq.s	ST_nvib
		neg	d1
ST_nvib:	add	74(a6),d1

	move.w	d1,d0
	bsr	PokePer	;move	d1,6(a5)

		move	32(a0),d0
		add	d0,d0
		add	d0,36(a6)
		cmp	#720,36(a6)
		blt.s	ST_anrp
		sub	#720,36(a6)
ST_anrp:	lea	$10(a5),a5
		lea	76(a6),a6
		dbf	d7,ST_amloop

		lea	ST_noisewave,a0
		move	#$7327,d0
		moveq	#31,d1
ST_nlop:	move.b	d0,(a0)+
	tst.b	BSSMerkPuffer+DracoOn
	bne.s	.skip
		add.b	$dff007,d0
.skip:
		eor	#124,d0
		rol	#3,d0
		dbf	d1,ST_nlop

	rts

*-------- Tagliste fr bergabe der Amplifierstrukturen vorbereiten ---------*
*---------------- und in EPG_AmplifierTagList ablegen -----------------------*
InitAudstructST:
	bsr	InitAudstruct
	rts
InitAudstruct:
	move.l	#EPAMB_Direct!EPAMB_8Bit,d0
	move.b	FastLoad(pc),d1
	bne.s	.yesfast
	or.l	#EPAMB_ChipRam,d0
.yesfast
	move.l	d0,Pro_NPFlags

	lea	Audstruct0,a0		;Audio Struktur vorbereiten

	lea	(a0),a1
	move.w	#as_sizeof*4-1,d0
.clr
	clr.b	(a1)+
	dbf	d0,.clr

	move.w	#01,AS_Leftright(a0)			;1. Kanal links
	move.w	#-1,AS_Leftright+as_sizeof*1(a0)	;2. Kanal rechts
	move.w	#-1,AS_Leftright+as_sizeof*2(a0)	;3. Kanal rechts
	move.w	#01,AS_Leftright+as_sizeof*3(a0)	;4. Kanal links

	lea	AudTagliste(pc),a0
	move.l	a0,EPG_AmplifierTagList(a5)

	moveq	#0,d0
	rts
AudTagliste
	dc.l	EPAMT_Numstructs,4
	dc.l	EPAMT_Audiostructs,Audstruct0
	dc.l	EPAMT_Flags
Pro_NPFlags
	dc.l	0
	dc.l	0



