  
  Dc  Dc  m    Dc  Dc  Dc  Dc  Dc
	incdir	sd0:asm/
	include	includes/exec.i
	include	includes/dos.i
	include	includes/intuition.i
	include	includes/midi.i
	include	includes/cia.i
	include	includes/timer.i
	include	includes/devices.i


mc68020		equ 1	; 0 = 68000+ version, 1 = 68020+ version
executable	equ 0

animation_flag	equ 0	; enable/disable gadget animation
keyfile_active	equ 0

taskpri = 80

closewb = 0

midilib = 1
tbeirq  = 0
ciairq  = 1


	incdir	sd0:asm/
	include	miditracker/mt-equs.s


serialsize SET $800


s
	bsr	init_everything
	beq.s	.normit


	bsr	load_song
	beq.s	.nosong

	IFNE	closewb
	move.l	intbas(a5),a6
	jsr	CloseWorkbench(a6)
	tst.l	d0
	beq.s	.wberror
	ENDC

	bsr	replay
;	IFNE	tbeirq
;	move.l	tbecount(a5),count2(a5)
;	ELSE
;	move.l	count(a5),count2(a5)
;	ENDC
	bsr	ResetNotesAndControllers

	IFNE	closewb
	move.l	intbas(a5),a6
	jsr	OpenWorkbench(a6)
.wberror
	ENDC

.nosong
	bsr	unload_song

.normit

n	bsr	free_everything

	moveq	#0,d0
	rts






;==============================================================
;
;  Routine zum Abspielen
;
;==============================================================


replay


;=== send optional Sequencer-Startcode
	tst.b	sequencer_sysex(a5)
	beq.s	.nosysex
	move.b	#MS_START,d0
	bsr	send_1_byte
.nosysex



	IFEQ	ciairq



.timerloop

;=== Formel zur Umrechnung BPM -> Mikrosekunden
	move.l	#2500000,d0
	moveq	#0,d1
	move.w	playtempo(a5),d1
	addq.l	#4,d1
	LONGDIVU

	move.l	timerio(a5),a1
	move.w	#9,$1c(a1)		; TR_ADDREQUEST
	clr.l	$20(a1)
	move.l	d0,$24(a1)
	move.l	(a5),a6
	jsr	SendIO(a6)



;=== See if mainprog wants midiplayer to halt for a short moment;
;=== Check if STOP-signal is set

	moveq	#0,d0
	move.l	#$1000,d1
	jsr	SetSignal(a6)
	btst	#12,d0
	bne	.stopped

	bsr	createmidi
	beq	.stopped

	tst.l	d1
	beq.s	.nodata
	move.l	serialpufferD(a5),a1	; d1 is length
	bsr	send_stream
.nodata


;	moveq	#0,d0
;	move.b	player2moutsig(a5),d1
;	bset	d1,d0
;	move.l	midioutprocess(a5),a1
;	move.l	(a5),a6
;	jsr	Signal(a6)


	move.l	timerio(a5),a1
	move.l	(a5),a6
	jsr	WaitIO(a6)

.notim	bra	.timerloop



.stopped
	bsr	AbortTimer



	ELSE



; CIA timer interrupt

	lea	cianam(pc),a1
	move.l	(a5),a6
	jsr	OpenResource(a6)
	move.l	d0,ciares(a5)
	beq	.nocia
	move.l	d0,a6

;=== set interrupt code

	lea	.cia_irq(pc),a1
	moveq	#0,d0			; Timer A
	jsr	AddICRVector(a6)
	tst.l	d0
	bne	.busy


;=== stop timer
	move.l	ciares(a5),a0
	move.l	$22(a0),a0
	and.b	#%11100010,ciacra(a0)


;=== read cia clock value, calc tempo
	lea	eclockval(a5),a0
	move.l	timerio(a5),a6
	move.l	$14(a6),a6
	jsr	ReadEClock(a6)
	divu	#50,d0
	ext.l	d0
	mulu	#125,d0
	divu	playtempo(a5),d0
	move.l	ciares(a5),a0
	move.l	$22(a0),a0
	move.b	d0,ciatalo(a0)
	lsr.w	#8,d0
	move.b	d0,ciatahi(a0)


;=== start timer
	or.b	#$01,ciacra(a0)		; start cia



	IFNE	tbeirq


	move.l	#$1000,d0
	move.b	autostopsig(a5),d2
	bset	d2,d0
	move.l	(a5),a6
	jsr	Wait(a6)


	ENDC



	IFNE	midilib

	moveq	#-1,d0
	move.l	(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,ciasignal(a5)
	bmi	.nosig



.timerloop

;=== See if mainprog wants midiplayer to halt for a short moment;
;=== Check if STOP-signal is set

	move.l	#$1000,d0
	move.b	autostopsig(a5),d3
	bset	d3,d0
	move.b	ciasignal(a5),d2
	bset	d2,d0
	move.l	(a5),a6
	jsr	Wait(a6)
	btst	d2,d0
	beq.s	.stopped
	btst	d3,d0
	bne.s	.stopped

	bsr	createmidi
	beq.s	.stopped

	tst.l	d1
	beq.s	.nodata
	move.l	serialpufferD(a5),a1	; d1 is length
	bsr	send_stream
.nodata


	bra	.timerloop

.stopped

	move.b	ciasignal(a5),d0
	move.l	(a5),a6
	jsr	FreeSignal(a6)

.nosig



	ENDC


	lea	.cia_irq(pc),a1
	moveq	#0,d0			; Timer A
	move.l	ciares(a5),a6
	jsr	RemICRVector(a6)


.busy
.nocia


	ENDC



;=== Send a realtime sysex: Sequencer-Stop
	tst.b	sequencer_sysex(a5)
	beq.s	.nosysex2
	move.b	#MS_STOP,d0
	bsr	send_1_byte
.nosysex2

	rts




.cia_irq
	dc.l	0,0
	dc.b	2,1
	dc.l	.irqname
	dc.l	varbase
	dc.l	.irqcode


.irqname
	dc.b	'MT replay timer',0
	even


.irqcode
	movem.l	d0-d1/a0-a1/a6,-(sp)



	IFNE	tbeirq

	move.l	(a1),a6
	lea	.replay_irq(pc),a1
	move.b	#2,8(a1)
	jsr	Cause(a6)

	ENDC



	IFNE	midilib

	move.l	(a1),a6
	moveq	#0,d0
	move.b	ciasignal(a1),d1
	bset	d1,d0
	move.l	mytask(a1),a1
	jsr	Signal(a6)

	ENDC



	movem.l	(sp)+,d0-d1/a0-a1/a6
	moveq	#0,d0
	rts




.replay_irq
	dc.l	0,0
	dc.b	2,0
	dc.l	.replayname
	dc.l	varbase
	dc.l	.replayirqcode


.replayname
	dc.b	'MT replay irq',0
	even


.replayirqcode
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	a1,a5

	bsr	createmidi
	bne.s	.continue

	moveq	#0,d0
	move.b	autostopsig(a5),d1
	bset	d1,d0
	move.l	mytask(a5),a1
	move.l	(a5),a6
	jsr	Signal(a6)
	bra.s	.nodata2
.continue

	tst.l	d1
	beq.s	.nodata2
	move.l	serialpufferD(a5),a1	; d1 is length
	bsr	send_stream
.nodata2

	movem.l	(sp)+,d0-d7/a0-a6
	moveq	#0,d0
	rts











AbortTimer
	move.l	timerio(a5),a1

AbortDevice	; a1=^iorequest
;=== Nach dieser Routine ist das SigBit im Task gelscht.
	move.l	a1,-(sp)
	move.l	(a5),a6
	jsr	CheckIO(a6)
	tst.l	d0
	bne.s	.ready
	move.l	(sp),a1
	jsr	AbortIO(a6)	; Nachher ist msg->node_type = 7 !!!
.ready
	move.l	(sp)+,a1
	jmp	WaitIO(a6)






init_everything
	lea	varbase,a5
	move.l	$4.w,(a5)
	move.l	#serialpuffer,serialpufferD(a5)
	move.l	#irqpuffer,irqpufferD(a5)
	move.l	irqpufferD(a5),readpointer(a5)
	move.l	irqpufferD(a5),writepointer(a5)
	move.l	#irqpuffer+serialsize,irqpufferlimitD(a5)
;	move.l	#irqpuffer2,irqpointer(a5)
	st	oldtaskpri(a5)

	lea	dosnam(pc),a1
	moveq	#37,d0
	move.l	(a5),a6
	jsr	OpenLibrary(a6)
	move.l	d0,dosbas(a5)
	beq.s	.neg

	lea	intnam(pc),a1
	moveq	#37,d0
	jsr	OpenLibrary(a6)
	move.l	d0,intbas(a5)
	beq.s	.neg


	bsr	OpenTimer
	beq.s	.neg



	IFNE	executable

	lea	template(pc),a0
	move.l	a0,d1
	lea	argarray(a5),a0
	move.l	a0,d2
	moveq	#0,d3
	move.l	dosbas(a5),a6
	jsr	ReadArgs(a6)
	move.l	d0,rdargs(a5)
	beq.s	.neg

	ELSE

	lea	.songname(pc),a0
	move.l	a0,songname(a5)
	bra.s	.cont1

.songname
	dc.b	'dh0:miditracker/firehawk.mt',0
	even

.cont1

	ENDC


	moveq	#-1,d0
	move.l	(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,autostopsig(a5)
	bmi	.neg


	IFNE	midilib
	bsr	OpenMainMidi
	beq.s	.neg
	ENDC


	IFNE	tbeirq
	bsr	SetIRQ
	beq.s	.neg
	ENDC



	bsr	InitControlsourcesData
	beq.s	.neg


	suba.l	a1,a1
	move.l	(a5),a6
	jsr	FindTask(a6)
	move.l	d0,mytask(a5)
	move.l	d0,a1
	moveq	#taskpri,d0
	jsr	SetTaskPri(a6)
	move.b	d0,oldtaskpri(a5)



	POSITIV
.neg	NEGATIV







free_everything

	suba.l	a1,a1
	move.l	(a5),a6
	jsr	FindTask(a6)
	move.l	d0,a1
	move.b	oldtaskpri(a5),d0
	bmi.s	.notaskpri
	jsr	SetTaskPri(a6)
.notaskpri

	tst.l	dosbas(a5)
	beq	.hardcrash
	tst.l	intbas(a5)
	beq	.hardcrash


	IFNE	tbeirq
	bsr	RemIRQ
	ENDC


	IFNE	midilib
	bsr	CloseMainMidi
	ENDC


	move.b	autostopsig(a5),d0
	move.l	(a5),a6
	jsr	FreeSignal(a6)



	IFNE	executable

	move.l	rdargs(a5),d1
	beq.s	.noargs
	clr.l	rdargs(a5)
	move.l	dosbas(a5),a6
	jsr	FreeArgs(a6)
.noargs

	ENDC

	bsr	CloseTimer

.hardcrash
	move.l	dosbas(a5),d0
	beq.s	.nodos
	move.l	d0,a1
	move.l	(a5),a6
	jsr	CloseLibrary(a6)
.nodos

	move.l	intbas(a5),d0
	beq.s	.nodos
	move.l	d0,a1
	move.l	(a5),a6
	jsr	CloseLibrary(a6)
.noint

	rts





;==============================================================
;
;  Build Midi-Library structures
;
;==============================================================

OpenMainMIDI

	lea	midinam(pc),a1
	moveq	#7,d0
	move.l	(a5),a6
	jsr	OpenLibrary(a6)
	move.l	d0,midibas(a5)
	beq.s	.neg


	suba.l	a0,a0
	suba.l	a1,a1
	move.l	midibas(a5),a6
	jsr	CreateMSource(a6)
	move.l	d0,player_msource(a5)
	beq.s	.neg

	move.l	d0,a0
	lea	.midioutname(pc),a1
	suba.l	a2,a2
	jsr	MRouteSource(a6)
	move.l	d0,player_sourceroute(a5)
	beq.s	.neg


	POSITIV
.neg	NEGATIV



.midioutname	dc.b	'MidiOut',0
		even






;==============================================================
;
;  Release Midi-Library resources
;
;==============================================================

CloseMainMidi

	move.l	midibas(a5),d0
	beq.s	.nomidi
	move.l	d0,a6

	move.l	player_sourceroute(a5),d0
	beq.s	.nosroute
	move.l	d0,a0
	jsr	DeleteMRoute(a6)
	clr.l	player_sourceroute(a5)
.nosroute

	move.l	player_msource(a5),d0
	beq.s	.nosource
	move.l	d0,a0
	jsr	DeleteMSource(a6)
	clr.l	player_msource(a5)
.nosource

	move.l	midibas(a5),d0
	beq.s	.nomidi
	move.l	d0,a1
	move.l	(a5),a6
	jsr	CloseLibrary(a6)
	clr.l	midibas(a5)
.nomidi

	rts











load_song

	move.l	songname(a5),d1
	move.l	#1005,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d7
	beq	.loaderror_open

;	bsr	load_xpk
;	beq	.loaderror_open

	move.l	d7,-(sp)
;	bsr	InitNewData
	move.l	(sp)+,d7


	move.l	d7,d1
	moveq	#8,d3
	suba.l	d3,sp
	move.l	sp,d2
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	move.l	(sp)+,d1
	move.l	(sp)+,d4
	tst.l	d0
	ble	.loaderror_earlyeof

	cmpi.l	#'MTSO',d1
	bne	.loaderror_nosong
	swap	d4
	cmpi.w	#'NG',d4
	bne	.loaderror_nosong
	swap	d4

	move.w	d4,song_version(a5)
	cmp.w	#current_song_version+1,d4
	bcc	.loaderror_version

	move.l	d7,d1				; prepare Read()
	lea	songheader(a5),a2		;
	move.l	a2,d2				;
	IFEQ	mc68020
	lsl.w	#2,d4
	jmp	.loadertab(pc,d4.w)
	ELSE
	jmp	.loadertab(pc,d4.w*4)
	ENDC

.loadertab
	bra	.load_v0
	bra	.load_v1
	bra	.load_v2
	bra	.load_v3
	bra	.load_v4
	bra	.load_v5


.load_v0
	moveq	#so0_sizeof,d3
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

	bsr.s	.default_from_v1
.new_with_v0
	bra	.continue_load
.default_from_v1
;	bsr	reset_channelnames
	bra.s	.default_from_v2



;=== V1 changes:
;===   - channelnames, 24 chars long each (including 0-byte)

.load_v1
	moveq	#so1_sizeof,d3
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

	bsr.s	.default_from_v2
.new_with_v1

;	lea	channelnames(a5),a0
;	move.l	d7,d1
;	move.l	a0,d2
;	moveq	#channelname_len,d3
;	lsl.l	#4,d3
;	move.l	dosbas(a5),a6
;	jsr	Read(a6)
;	tst.l	d0
;	ble	.loaderror_earlyeof

	move.l	d7,d1
	moveq	#channelname_len,d2
	lsl.l	#4,d2
	moveq	#0,d3
	move.l	dosbas(a5),a6
	jsr	Seek(a6)


	bra.s	.new_with_v0

.default_from_v2
	move.w	#24,so_maxtracks(a2)
	bra.s	.default_from_v3



;=== V2 changes:
;===   - maxtracks

.load_v2
	moveq	#so2_sizeof,d3
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

	bsr.s	.default_from_v3
.new_with_v2
	bra.s	.new_with_v1

.default_from_v3
	clr.b	songheader+so_author(a5)
	bra.s	.default_from_v4



;=== V3 changes:
;===   - author

.load_v3
	moveq	#so3_sizeof,d3
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

	bsr.s	.default_from_v4
.new_with_v3
	bra.s	.new_with_v2



;=== V4 changes:
;===   - channelsliders
;===   - mastervolume

.load_v4
	moveq	#so4_sizeof,d3
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

	bsr.s	.default_from_v5
.new_with_v4
;=== Channel sliders are copied here. They will get not-ed at RefreshEverything.
	lea	so_chansliders(a2),a0
	lea	channelsliders(a5),a1
	moveq	#15,d0
.sliderloop
	move.b	(a0)+,(a1)+
	dbf	d0,.sliderloop
	move.w	so_mastervolume(a2),mastervolume(a5)
	bra.s	.new_with_v3

.default_from_v4
	rts




.load_v5
	moveq	#so_sizeof,d3
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

;	bsr.s	.default_from_v6
.new_with_v5
	bra.s	.new_with_v4

.default_from_v5
	rts






.continue_load
	move.w	so_bpm(a2),playtempo(a5)
	moveq	#0,d0
	move.w	so_maxtracks(a2),d0
	bsr	PutMaxtracks
	move.l	so_length(a2),d0

	IFNE	keyfile_active
	move.l	keybas(a5),d1
	bne.s	.keyf
	moveq	#def_length,d1
	cmp.l	d0,d1
	bcc.s	.keyf
	move.l	d1,d0
.keyf
	ENDC

	move.l	d0,length(a5)
;	move.l	so_positions(a2),positions(a5)
	bsr	AllocPosNPatts
	beq	.loaderror_nomem
	move.l	a0,positionsA(a5)
	move.l	a1,patterntab(a5)

	move.l	d7,d1
	move.l	a0,d2
	move.l	length(a5),d3
	add.l	d3,d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

	cmp.w	#5,song_version(a5)
	bcc.s	.skipseek
	move.l	d7,d1
	move.l	so_positions(a2),d2
	sub.l	length(a5),d2
	add.l	d2,d2
	moveq	#0,d3
	jsr	Seek(a6)
	tst.l	d0
	ble	.loaderror_earlyeof
.skipseek



;=== Note:
;=== Patterns are saved backwards, i.e. last pattern is saved first.
;=== Same with channels (see inner loop).

.patternread
	move.l	d7,d1
	lea	disk_pattern(a5),a0
	move.l	a0,d2
	moveq	#pts_sizeof,d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	beq	.eof
	bmi	.loaderror_earlyeof

	move.w	disk_pattern+pts_pattnum(a5),d0
	bsr	AllocPattern
	beq	.err
	move.l	a0,a4
	move.l	disk_pattern+pts_events(a5),pt_events(a4)
	move.w	disk_pattern+pts_chanmask(a5),pt_chanmask(a4)

;=== evtl. bpmtrack laden
	move.l	disk_pattern+pts_bpmsize(a5),d0
	beq.s	.nobpm
	move.l	d0,d3	;fr Read()
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,pt_bpmtrack(a4)
	beq	.err
	move.l	d0,d2
	move.l	d7,d1
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof
.nobpm

	moveq	#15,d6
.channelread
;=== Channel laden
	move.w	disk_pattern+pts_channels(a5),d0
	btst	d6,d0
	beq	.nochan

	bsr	AllocChannel
	beq	.err
	move.l	a0,a3
	move.w	d6,d0
	lsl.w	#2,d0
	move.l	a3,pt_channels(a4,d0.w)
	move.l	d7,d1
	lea	disk_channel(a5),a0
	move.l	a0,d2
	moveq	#chs_sizeof,d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof
	move.w	disk_channel+chs_scale(a5),ch_scale(a3)
	move.w	disk_channel+chs_numcs(a5),ch_numcs(a3)
	move.b	disk_channel+chs_pb_onoff(a5),ch_pb_onoff(a3)
	move.b	disk_channel+chs_mp_onoff(a5),ch_mp_onoff(a3)
	move.w	disk_channel+chs_numtracks(a5),ch_numtracks(a3)

;=== ptrack laden
	move.l	disk_channel+chs_ptracksize(a5),d0
	beq.s	.noptrk
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,ch_ptrack(a3)
	beq	.err
	move.l	d7,d1
	move.l	d0,d2
	move.l	disk_channel+chs_ptracksize(a5),d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	ble	.err
.noptrk

;=== pbtrack laden
	move.l	disk_channel+chs_pbtracksize(a5),d0
	beq.s	.nopbtrk
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,ch_pbtrack(a3)
	beq	.err
	move.l	d7,d1
	move.l	d0,d2
	move.l	disk_channel+chs_pbtracksize(a5),d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof
.nopbtrk

;=== mptrack laden
	move.l	disk_channel+chs_mptracksize(a5),d0
	beq.s	.nomptrk
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,ch_mptrack(a3)
	beq	.err
	move.l	d7,d1
	move.l	d0,d2
	move.l	disk_channel+chs_mptracksize(a5),d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof
.nomptrk


;=== csources Tracks laden
	move.w	ch_numcs(a3),d5
	beq	.noctracks
	lea	ch_csources(a3),a2
.ctrackread
	move.l	d7,d1
	lea	disk_csource(a5),a0
	move.l	a0,d2
	moveq	#css_sizeof,d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

	move.l	disk_csource+css_datasize(a5),d0
	moveq	#cs_sizeof,d1
	add.l	d1,d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,(a2)
	beq	.err
	move.l	d0,a0
	move.b	disk_csource+css_parameter(a5),cs_parameter(a0)
	move.b	disk_csource+css_onoff(a5),cs_onoff(a0)
	move.l	disk_csource+css_datasize(a5),cs_datasize(a0)

;=== add controlsource if not already allocated

	move.l	cs_codetab(a5),a1
	move.b	cs_parameter(a0),d0
	move.l	active_csources_m1(a5),d1
.paramloop
	cmp.b	(a1)+,d0
	dbeq	d1,.paramloop
	beq.s	.itshere

	movem.l	d5-d7/a0/a2-a4,-(sp)
	move.l	d2,a0
	moveq	#0,d1
	bsr	AddControlsource
	movem.l	(sp)+,d5-d7/a0/a2-a4
.itshere


	move.l	a0,d2
	moveq	#cs_sizeof,d1
	add.l	d1,d2
	move.l	d7,d1
	move.l	cs_datasize(a0),d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

	move.l	(a2),a2
	subq.w	#1,d5
	bne	.ctrackread
	clr.l	(a2)
.noctracks


;=== Normale Tracks laden
	move.w	ch_numtracks(a3),d5
	beq.s	.notracks
	lea	ch_tracks(a3),a2
.trackread
	move.l	d7,d1
	lea	disk_track(a5),a0
	move.l	a0,d2
	moveq	#trs_sizeof,d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

;	move.w	disk_track+trs_number(a5),d0
;	cmp.w	maxtracks+2(a5),d0
;	bcc	.too_much_tracks

	move.l	disk_track+trs_datasize(a5),d0
	moveq	#tr_sizeof,d1
	add.l	d1,d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,(a2)
	beq	.err
	move.l	d0,a0
	move.w	disk_track+trs_number(a5),tr_number(a0)
	move.b	disk_track+trs_onoff(a5),tr_onoff(a0)
	move.l	disk_track+trs_datasize(a5),tr_datasize(a0)

	move.l	a0,d2
	moveq	#tr_sizeof,d1
	add.l	d1,d2
	move.l	d7,d1
	move.l	tr_datasize(a0),d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	ble	.loaderror_earlyeof

	move.l	(a2),a2
	subq.w	#1,d5
	bne.s	.trackread
	clr.l	(a2)
.notracks



.nochan	dbf	d6,.channelread
	bra	.patternread

.eof

	move.l	d7,d1
	move.l	dosbas(a5),a6
	jsr	Close(a6)

;	tst.b	was_xpk_packed(a5)
;	beq.s	.notpacked
;	bsr	delete_temp		; kill tempfile
;.notpacked


	move.l	maxtracks(a5),d0
	bsr	AllocMaxtracksData	; this will also allocate worktracks(a5)
	beq	.loaderror_nomem2



;=== set statusmessage, then refresh lots of gadgets

	clr.l	currentpattern(a5)
	clr.l	currentpos(a5)
	move.l	#-1,eventpos(a5)
	bsr	CorrectPattern
	bsr	CorrectChannel

	bsr	clear_playcounters


	POSITIV




.err	bra.s	.closefile



.loaderror_nomem2
	bra.s	.closefile2

.loaderror_nomem
	bra.s	.closefile

.loaderror_earlyeof
	bra.s	.closefile

.loaderror_nosong
	bra.w	.closefile

.loaderror_version

.closefile
	move.l	d7,d1
	move.l	dosbas(a5),a6
	jsr	Close(a6)
.closefile2
	bsr	FreePatternData
	bsr	FreeMaxtracksData
	bra.w	.more_error

.loaderror_open

.more_error
;	tst.b	xpkonoff(a5)
;	beq.s	.notpacked2
;	bsr	delete_temp
;.notpacked2

	NEGATIV



.earlyeof_body	dc.b	'Song data is corrupt.',0
.nosong_body	dc.b	'This is no MidiTracker Song.',0
.ver_body	dc.b	'This is a wrong version',10
		dc.b	'of a MidiTracker Songfile.',0
.ver_gadfmt	dc.b	'_I will update',0
.loaded_txt	dc.b	'New Song loaded.',0
;.toomuch_body	dc.b	'Too much tracks in this song -',10
;		dc.b	'Please change MAXTRACKS.',10
;		dc.b	'(tooltype/shell-parameter)',0

overload_body	dc.b	'Your Song has been changed.',10
		dc.b	'You really want to overload it?',0
howtrue_gadfmt	dc.b	'_How true',0
saved_txt	dc.b	'Song saved to file.',0
		even







PutMaxtracks	; d0 = maxtracks
	move.l	d0,maxtracks(a5)
	subq.l	#1,d0
	move.l	d0,maxtracks_m1(a5)
	rts





;=== allocate anything that deals with MAXTRACKS
;=== In order to do so, ensure that maxtracks(a5) still holds the old maxtracks
;=== value.

AllocMaxtracksData	; d0=new maxtracks value

			rsreset
.sp_newmaxtracks	rs.l	1
.sp_chanc		rs.w	1
.sp_playcounters	rs.l	1

.sp_sizeof		rs.w	0


	lea	-.sp_sizeof(sp),sp
	move.l	d0,.sp_newmaxtracks(sp)


;=== playcounters
	moveq	#prec3,d0
	move.l	active_csources(a5),d1
	mulu	#pcc_sizeof,d1
	add.l	d1,d0
	move.w	d0,csc(a5)

	move.l	.sp_newmaxtracks(sp),d1
	mulu	#pc_sizeof,d1
	add.l	d1,d0
	move.w	d0,.sp_chanc(sp)

	lsl.l	#4,d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,.sp_playcounters(sp)
	beq	.nomem7


;=== we have allocated all what we wanted. Now let's release the old stuff
;=== and move all addresses to the right place.

	bsr	FreeMaxtracksData


;=== copy all required data

	move.l	.sp_playcounters(sp),playcounters(a5)
	move.w	.sp_chanc(sp),chanc(a5)
	move.l	.sp_newmaxtracks(sp),d0
	bsr	PutMaxtracks

	lea	.sp_sizeof(sp),sp
	POSITIV


.nomem8	lea	.sp_playcounters(sp),a0
	bsr	FreeVector

.nomem7
	lea	.sp_sizeof(sp),sp
	NEGATIV






FreeMaxtracksData


	lea	playcounters(a5),a0
	bra	FreeVector




FreeVector	; a0=^Memoryaddress
	move.l	(a0),d0
	beq.s	.rts
	clr.l	(a0)
	move.l	d0,a1
	move.l	(a5),a6
	jmp	FreeVec(a6)
.rts	rts






;==============================================================
;
;  Positions + Patterntab allocaten
;
;==============================================================

AllocPosNPatts	; Positions und Patterntab allocaten
		; zurck: a0=^positions, a1=^patterntab

	subq.w	#8,sp
	move.l	length(a5),d0
	add.l	d0,d0
	move.l	#$10001,d1
	move.l	(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,(sp)
	beq.s	.neg
;=== patterntab
	move.l	length(a5),d0
	lsl.l	#2,d0
	move.l	#$10001,d1
	jsr	AllocVec(a6)
	move.l	d0,4(sp)
	beq.s	.neg2

	movem.l	(sp)+,a0-a1
	POSITIV
.neg2	move.l	(sp),a1
	jsr	FreeVec(a6)
.neg	addq.w	#8,sp
	NEGATIV




;==============================================================
;
;  Positions + Patterntab freigeben
;
;==============================================================

FreePosNPatts
;=== gibt die Positions und die Patterntab frei.
;=== positions
	lea	positionsA(a5),a0
	bsr	FreeVector
;=== patterntab
	lea	patterntab(a5),a0
	bra	FreeVector






AllocPattern	; d0.w=newpattern
		; zurck: d0=pos/neg, a0=^NewPattern
	move.w	d0,-(sp)
	bsr.s	AllocPatternDry
	beq.s	.fail
	move.w	(sp)+,d0
	move.l	patterntab(a5),a1	; in patterntab schreiben
	IFEQ	mc68020
	lsl.w	#2,d0
	move.l	a0,(a1,d0.w)
	ELSE
	move.l	a0,(a1,d0.w*4)
	ENDC
	POSITIV
.fail	addq.w	#2,sp
	NEGATIV

AllocPatternDry	; zurck: a0=^pattern (schreibt aber nicht in patterntab)
	moveq	#pt_sizeof,d0
	move.l	#$10001,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a0			; einiges initialisieren

	move.l	events(a5),pt_events(a0)
	not.w	pt_chanmask(a0)		; $ffff
	POSITIV
.neg	NEGATIV




;=== wird von FreeSomething, project_clear und load_mt aufgerufen!
FreePatternData
;=== gibt alle Patterns frei, und Positions + Patterntab
	tst.l	patterntab(a5)
	beq.s	.rts
	move.l	length(a5),-(sp)
.loop	subq.l	#1,(sp)
	bcs.s	.out
	move.l	(sp),d0
	bsr	FreePattern	; patterns freigeben
	bra.s	.loop
.out	addq.w	#4,sp

	bsr	FreePosNPatts	; patterntab und positions freigeben
.rts	rts





;==============================================================
;
;  Channel allocaten
;
;==============================================================

AllocChannel	; zurck: a0=^channel (NICHT IN D0!!!)
;=== gibt Channel zurck, wird aber nicht ins Pattern eingetragen
	moveq	#ch_sizeof,d0
	move.l	#$10001,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a0
	POSITIV
.neg	NEGATIV





FreeMemory	; a0=^address, d0=size
	move.l	(a0),d1
	beq.s	.rts
	move.l	d1,a1
	clr.l	(a0)
	move.l	(a5),a6
	jsr	FreeMem(a6)
.rts	rts


FreePattern	; d0.w=pattern
	move.l	patterntab(a5),a0
	lsl.w	#2,d0
	adda.w	d0,a0

FreePatternAddr	; a0=^Patternaddress
	move.l	a0,-(sp)
	bsr.s	FreePattChannels
	move.l	(sp)+,a0

FreePatternHead	; a0=^Patternaddress
	moveq	#pt_sizeof,d0
	bra.s	FreeMemory


FreePattChannels	; a0=^Patternaddress
;=== gibt alle Channels und BPMTrack eines Patterns frei
	move.l	(a0),d0
	beq.s	.rts
	move.l	a3,-(sp)
	move.l	d0,a3
	move.l	a3,a0
	bsr.s	FreeBPMTrack

	lea	pt_channels(a3),a3
	moveq	#15,d4		;16 midi channels
.loop2	move.l	a3,a0		;^channeladr
	bsr.s	FreeChannel
	addq.w	#4,a3
	dbf	d4,.loop2
.out	move.l	(sp)+,a3
.rts	rts



;=== bpmtrack freigeben
FreeBPMTrack	; a0=^pattern
	lea	pt_bpmtrack(a0),a0
	bra	FreeVector



;=== gibt den ctrack, die anderen tracks und sich selbst frei
FreeChannel	; a0=^channeladdress
	move.l	(a0),d0
	bne.s	.free
	rts
.free	clr.l	(a0)
	move.l	d0,-(sp)
	bsr.s	FreeInChannel
	move.l	(sp)+,a1
	moveq	#ch_sizeof,d0
	move.l	(a5),a6
	jmp	FreeMem(a6)



;=== gibt nur den ctrack und die tracks frei, nicht den channel selbst!
FreeInChannel	; d0=^channel
	move.l	a2,-(sp)
	move.l	d0,a2
	move.l	a2,a0
	bsr.s	FreeCTracks
	move.l	a2,a0
	bsr.s	FreePTrack
	move.l	a2,a0
	bsr.s	FreePBTrack
	move.l	a2,a0
	bsr.s	FreeMPTrack
	lea	ch_tracks(a2),a0
	bsr	FreeListVecs
	move.l	(sp)+,a2
	rts



;=== gibt den pbtrack eines Channels frei
FreePBTrack	; a0=^Channel
	lea	ch_pbtrack(a0),a0
	bra	FreeVector



;=== gibt den presettrack eines Channels frei
FreePTrack	; a0=^Channel
	lea	ch_ptrack(a0),a0
	bra	FreeVector



;=== gibt den mptrack eines Channels frei
FreeMPTrack	; a0=^Channel
	lea	ch_mptrack(a0),a0
	bra	FreeVector



;=== gibt die cstracks eines Channels frei
FreeCTracks	; a0=^channel
	lea	ch_csources(a0),a0
;	bra	FreeListVecs



FreeListVecs	; a0=^List-Root
	move.l	(a0),d0
	beq.s	.rts
	move.l	a2,-(sp)
	move.l	(a5),a6
	clr.l	(a0)
.loop3	move.l	d0,a1
	move.l	(a1),a2			; successor
	jsr	FreeVec(a6)
	move.l	a2,d0
	bne.s	.loop3
	move.l	(sp)+,a2
.rts	rts







InitControlsourcesData

;=== allocate one default controlsource: modwheel

	moveq	#1,d0
	moveq	#0,d1
;	bra.s	AddControlSource


AddControlSource	; d0=parameter number, d1=panic value
			; returns: pos/neg

;=== Be sure the new csource is not yet in the list!

			rsreset
.sp_new_codetab		rs.l	1
.sp_new_codepanic	rs.l	1
.sp_new_active		rs.l	1
.sp_new_code		rs.b	1
.sp_new_panic		rs.b	1
.sp_csc			rs.w	1
.sp_chanc		rs.w	1
.sp_playcounters	rs.l	1
.sp_sizeof		rs.w	0


	lea	-.sp_sizeof(sp),sp

	move.b	d0,.sp_new_code(sp)
	move.b	d1,.sp_new_panic(sp)


	move.l	active_csources(a5),d0
	addq.l	#1,d0
	move.l	d0,.sp_new_active(sp)


;=== allocate new codetable for parameter-values
	move.l	.sp_new_active(sp),d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,.sp_new_codetab(sp)
	beq	.nomem2


;=== allocate new codepanic-table for panic-values
	move.l	.sp_new_active(sp),d0
	moveq	#1,d1
	jsr	AllocVec(a6)
	move.l	d0,.sp_new_codepanic(sp)
	beq	.nomem3



;=== allocate playcounters
	moveq	#prec3,d0
	move.l	.sp_new_active(sp),d1
	mulu	#pcc_sizeof,d1
	add.l	d1,d0
	move.w	d0,.sp_csc(sp)

	move.l	maxtracks(a5),d1
	mulu	#pc_sizeof,d1
	add.l	d1,d0
	move.w	d0,.sp_chanc(sp)

	lsl.l	#4,d0				; 16 channels
	moveq	#1,d1
	jsr	AllocVec(a6)
	move.l	d0,.sp_playcounters(sp)
	beq	.nomemC





;=== Now we want to copy the old values into the new tables.
;=== At this place, we insert the new value.

	moveq	#0,d4				; offset for old tables
	moveq	#0,d5				; offset for new tables
	move.b	.sp_new_code(sp),d2		; new parameter value

.insertloop
	move.l	active_csources(a5),d0
;	beq.s	.first_cs1
	cmp.l	d0,d4
	beq.s	.first_cs1
	move.l	cs_codetab(a5),a0
	cmp.b	(a0,d4.l),d2
	bcc.s	.notyet

	cmp.l	d4,d5
	bne.s	.notyet


.first_cs1
	move.l	.sp_new_codetab(sp),a1
	move.b	d2,(a1,d5.l)

	move.l	.sp_new_codepanic(sp),a1
	move.b	.sp_new_panic(sp),(a1,d5.l)

	bra.s	.newadd

.notyet
	move.l	.sp_new_codetab(sp),a1
	move.b	(a0,d4.l),(a1,d5.l)

	move.l	cs_codepanic(a5),a0
	move.l	.sp_new_codepanic(sp),a1
	move.b	(a0,d4.l),(a1,d5.l)

	addq.l	#1,d4

.newadd	addq.l	#1,d5
	cmp.l	.sp_new_active(sp),d5
	bne	.insertloop



;=== make new pointers public

	bsr	FreeControlSourcesData

.first_cs2
	move.l	.sp_new_codetab(sp),cs_codetab(a5)
	move.l	.sp_new_codepanic(sp),cs_codepanic(a5)

	move.w	.sp_csc(sp),csc(a5)
	move.w	.sp_chanc(sp),chanc(a5)
	move.l	.sp_playcounters(sp),playcounters(a5)

	move.l	.sp_new_active(sp),d0
	bsr.s	PutActiveCsources

	lea	.sp_sizeof(sp),sp
	POSITIV


;.nomemD	lea	.sp_playcouners(sp),a0
;	bsr	FreeVector

.nomemC

.nomemB

.nomemA

.nomem9

.nomem8

.nomem7

.nomem6

.nomem5

.nomem4	lea	.sp_new_codepanic(sp),a0
	bsr	FreeVector

.nomem3	lea	.sp_new_codetab(sp),a0
	bsr	FreeVector

.nomem2

.nomem1	lea	.sp_sizeof(sp),sp
	NEGATIV




PutActiveCsources	; d0.l=number of active csources
	move.l	d0,active_csources(a5)
	subq.l	#1,d0
	move.l	d0,active_csources_m1(a5)
	rts



FreeControlsourcesData

	lea	playcounters(a5),a0
	bsr	FreeVector

	lea	cs_codetab(a5),a0
	bsr	FreeVector

	lea	cs_codepanic(a5),a0
	bsr	FreeVector

	moveq	#0,d0
	bra.s	PutActiveCsources




FreeCSStrings	; a0=^strings array
	move.l	(a0),d0
	beq.s	.done
	move.l	a2,-(sp)
	move.l	d0,a2

	move.l	active_csources(a5),d2
.freeloop
	move.l	a2,a0
	bsr	FreeVector
	addq.w	#4,a2
	subq.l	#1,d2
	bne.s	.freeloop

	move.l	(sp)+,a2
.done	rts






unload_song

	bsr	FreePatternData
	bsr	FreeMaxtracksData
	bsr	FreeControlsourcesData

	rts






;==============================================================
;
;  Timer Device ffnen
;
;==============================================================

OpenTimer
;=== Replyport fr Timer initiieren
	move.l	(a5),a6
	jsr	CreateMsgPort(a6)
	move.l	d0,TimerReply(a5)
	beq.s	.neg

	move.l	d0,a0
	moveq	#$22,d0
	jsr	CreateIORequest(a6)
	move.l	d0,timerio(a5)
	beq.s	.neg

	move.l	d0,a1
	move.b	#$05,$9(a1)		; Pri


;=== Timer ffnen
	lea	timnam(pc),a0
	move.l	a0,$a(a1)
	moveq	#0,d0			; unit_MICROHZ
	moveq	#0,d1
	jsr	OpenDevice(a6)
	tst.b	d0
	bne.s	.neg

	POSITIV
.neg	NEGATIV




;==============================================================
;
;  Timer Device schlieen
;
;==============================================================

CloseTimer
	move.l	(a5),a6


;=== Device schlieen
	move.l	timerio(a5),d0
	beq.s	.noio
	tst.l	$14(a5)
	beq.s	.nodev
	move.l	d0,a1
	jsr	CloseDevice(a6)
.nodev

	move.l	timerio(a5),d0
	beq.s	.noio
	move.l	d0,a0
	jsr	DeleteIORequest(a6)
	clr.l	Timerio(a5)
.noio

;=== Replyport freigeben
	move.l	TimerReply(a5),d0
	beq.s	.noport
	move.l	d0,a0
	jsr	DeleteMsgPort(a6)
	clr.l	TimerReply(a5)
.noport

	rts






;==============================================================
;
;  MIDI Daten erzeugen
;
;==============================================================

createmidi	; zurck: d0=puffersize

	move.l	serialpufferD(a5),a4
	bra	.inpatt


;=== Get hold of a free buffer to write into

	lea	mout_ser_root(a5),a4
.allocloop
	move.l	(a4),d0
	beq.s	.allocate
	move.l	d0,a4
	tst.b	sw_free(a4)
	beq.s	.allocloop


;=== re-use this existing buffer

	lea	midiout_semaphore(a5),a0
	move.l	(a5),a6
	jsr	ObtainSemaphore(a6)

.take_this
	sf	sw_free(a4)
	sf	sw_ready2send(a4)

	lea	midiout_semaphore(a5),a0
	jsr	ReleaseSemaphore(a6)

	lea	sw_sizeof(a4),a4
	move.l	a4,current_serbuf(a5)
	bra	.inpatt


;=== allocate a new buffer

.allocate
	moveq	#sw_sizeof,d0
	add.l	#serialsize,d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocVec(a6)
	tst.l	d0
	beq	.neg
	move.l	d0,a2

	lea	midiout_semaphore(a5),a0
	jsr	ObtainSemaphore(a6)

	move.l	a2,(a4)
	move.l	a2,a4
	clr.l	(a4)
	bra.s	.take_this




;=== music routine

.inpatt



;=== pattern am ende?
	move.l	currentpatternA(a5),a0
	move.l	eventpos(a5),d0
	addq.l	#1,d0
	cmp.l	pt_events(a0),d0
	bcc.s	.nextpt
	move.l	d0,eventpos(a5)
	bra.s	.notend

.nextpt
;=== pattern an den Anfang bringen
	clr.l	eventpos(a5)
	bsr	clear_counters

;	bra	.neg


.songmode
;=== playsong-mode: nchstes pattern
	move.l	currentpos(a5),d0
	addq.l	#1,d0
	cmp.l	length(a5),d0
	bcs.s	.insong
	moveq	#0,d0
.insong	move.l	d0,currentpos(a5)
	move.l	positionsA(a5),a0
	moveq	#0,d1
	IFEQ	mc68020
	add.l	d0,d0
	move.w	(a0,d0.l),d1
	ELSE
	move.w	(a0,d0.l*2),d1
	ENDC
	move.l	d1,currentpattern(a5)
	bsr	CorrectPattern




;=== Hier fngt die MIDI Verarbeitung an!

.notend
	move.l	currentpatternA(a5),a3


;=== BPM Track
	lea	bpmplaycounter(a5),a6
	move.l	pt_bpmtrack(a3),d0
	beq.s	.nobpm
	tst.w	(a6)		; pcbpm_counter(a6)
	bne.s	.bpm1
	move.l	d0,a0
	adda.w	pcbpm_offset(a6),a0
	addq.w	#2,pcbpm_offset(a6)
	move.w	(a0),d0
	bpl.s	.newbpm
	move.w	d0,(a6)		; pcbpm_counter(a6)
	bra.s	.bpm1
.newbpm	move.w	d0,playtempo(a5)
	bra.s	.nobpm
.bpm1	addq.w	#1,(a6) 	; pcbpm_counter(a6)
.nobpm



;=== Die Channels werden von hinten nach vorne durchgegangen.

	move.l	playcounters(a5),a6
	move.w	chanc(a5),d0
	move.w	d0,d1		; = mulu #15,d0
	lsl.w	#4,d0		;
	sub.w	d1,d0		;
	adda.w	d0,a6
	moveq	#15,d6
.channelloop
	IFEQ	mc68020
	move.w	d6,d0
	lsl.w	#2,d0
	move.l	pt_channels(a3,d0.w),d0
	ELSE
	move.l	pt_channels(a3,d6.w*4),d0
	ENDC
	bne.s	.chanexists

	bsr	mixdown
	bra	.nochan


.chanexists
	move.l	d0,a2				; channel to a2

	tst.b	playdisabled(a5)		; Play-disabled-tracks active?
	bne.s	.playit				; yes, play even if chan is off

	move.w	pt_chanmask(a3),d0		; the channelquiet flag decides
	btst	d6,d0				; for each channel, if the replay
	seq	channelquiet(a5)		; routine should send notes on it
; Note: channelquiet is a temporary flag (only used here)

; If channel is quiet, we still have to run the following routines, because
; all counters must continue counting, in case user re-enables the channel.

.playit


;=== Preset Track MIDI
	move.l	ch_ptrack(a2),d0
	beq.s	.no0
	tst.w	(a6)		; pcp_counter(a6)
	bne.s	.trk0
	move.l	d0,a0
	adda.w	pcp_offset(a6),a0
	addq.w	#2,pcp_offset(a6)
	move.w	(a0),d0
	bpl.s	.new0
	move.w	d0,(a6)		; pcp_counter(a6)
.trk0	addq.w	#1,(a6) 	; pcp_counter(a6)
	bra.s	.no0
.new0

	; d0=preset, d6=channel, a4=^buffer
	bsr	make_preset_message
.no0


;=== Pitchbend Track MIDI
	move.l	ch_pbtrack(a2),d0
	beq.s	.no1
	tst.b	playdisabled(a5)
	bne.s	.pbon
	tst.b	ch_pb_onoff(a2)
	beq.s	.no1
.pbon	tst.w	prec1+pcpb_counter(a6)
	bne.s	.trk1
	move.l	d0,a0
	adda.w	prec1+pcpb_offset(a6),a0
	addq.w	#2,prec1+pcpb_offset(a6)
	move.w	(a0),d0
	bpl.s	.new1
	move.w	d0,prec1+pcpb_counter(a6)
.trk1	addq.w	#1,prec1+pcpb_counter(a6)
	bra.s	.no1
.new1
	tst.b	channelquiet(a5)
	bne.s	.no1
	moveq	#-$20,d1	; d1.b=$e0
	or.b	d6,d1
	move.b	d1,(a4)+
	move.b	d0,d1
	andi.b	#$7f,d1
	move.b	d1,(a4)+
	lsr.w	#7,d0
	move.b	d0,(a4)+
.no1


;=== MPress Track MIDI
	move.l	ch_mptrack(a2),d0
	beq.s	.no2
	tst.b	playdisabled(a5)
	bne.s	.mpon
	tst.b	ch_mp_onoff(a2)
	beq.s	.no2
.mpon	tst.b	prec2+pcmp_counter(a6)
	bne.s	.trk2
	move.l	d0,a0
	adda.w	prec2+pcmp_offset(a6),a0
	addq.w	#1,prec2+pcmp_offset(a6)
	move.b	(a0),d0
	bpl.s	.new2
	move.b	d0,prec2+pcmp_counter(a6)
.trk2	addq.b	#1,prec2+pcmp_counter(a6)
	bra.s	.no2
.new2
	tst.b	channelquiet(a5)
	bne.s	.no2
	moveq	#-$30,d1	; d1.b=$d0
	or.b	d6,d1
	move.b	d1,(a4)+
	move.b	d0,(a4)+
.no2




;=== Alle Controlsources, die mit $B0 (Parameter) einzustellen sind

	lea	ch_csources(a2),a1
	moveq	#-$50,d5	; d5.b=$b0
	or.b	d6,d5
	moveq	#-pcc_sizeof,d2
	move.l	active_csources_m1(a5),d3

.paramloop
	move.l	(a1),d0
	beq.s	.nomorecs
	move.l	d0,a1
	tst.b	playdisabled(a5)
	bne.s	.cson
	tst.b	cs_onoff(a1)
	beq.s	.stay
.cson



;=== zur Controlsource spulen, um den richtigen Offset in d2 zu bekommen
	move.l	cs_codetab(a5),a0
	move.b	cs_parameter(a1),d4
.codeloop
	addq.w	#pcc_sizeof,d2
	cmp.b	(a0)+,d4
	dbeq	d3,.codeloop
	bne.s	.nomorecs


	tst.b	prec3+pcc_counter(a6,d2.w)
	bne.s	.trkc
	move.w	prec3+pcc_offset(a6,d2.w),d1
	addq.w	#1,prec3+pcc_offset(a6,d2.w)
	move.b	cs_data(a1,d1.w),d0
	bpl.s	.newc
	move.b	d0,prec3+pcc_counter(a6,d2.w)
.trkc	addq.b	#1,prec3+pcc_counter(a6,d2.w)
	bra.s	.stay
.newc
	tst.b	channelquiet(a5)
	bne.s	.stay

	cmpi.b	#7,d4			; Volume-Parameter ?
	bne.s	.notvol
;=== Volume-Byte merken fr Mixdown
	lea	channelvolumes(a5),a0
	not.b	d0
	move.b	d0,(a0,d6.w)
	bra.s	.stay
.notvol	move.b	d5,(a4)+
	move.b	d4,(a4)+
	move.b	d0,(a4)+
.stay	bra.s	.paramloop

.nomorecs


	bsr	mixdown



;=== Now we're going to manage all note-tracks !

	tst.b	channelquiet(a5)
	beq.s	.not_quiet

;=== By now, all held notes in this channel have to be silenced, i.e. Note-OFFed.

	move.l	a2,a0				; save to a0
	lea	ch_tracks(a2),a2
.silenceloop
	move.l	(a2),d0
	beq.s	.silence_ready
	move.l	d0,a2

	move.w	tr_number(a2),d4
	IFEQ	pc_sizeof-6
	move.w	d4,d0
	add.w	d0,d0
	add.w	d0,d4
	add.w	d4,d4
	ELSE
	mulu	#pc_sizeof,d4
	ENDC
	add.w	csc(a5),d4

	move.b	pc_oldnote(a6,d4.w),d0
	bmi.s	.skipt				; note is off, no panic necessary
	st	pc_oldnote(a6,d4.w)		; set note to OFF

	moveq	#-$80,d2			; send the Note-OFF
	or.b	d6,d2
	move.b	d2,(a4)+
	move.b	d0,(a4)+			; pitch
	move.b	pc_oldvel(a6,d4.w),(a4)+	; velocity

.skipt	bra.s	.silenceloop

.silence_ready
	move.l	a0,a2				; restore channelpointer

;=== We still have to progress all counters, that's why we don't skip the
;=== ".not_quiet"-section.



;=== Play all channels regularly.

.not_quiet
	lea	ch_tracks(a2),a2
.trackloop
	move.l	(a2),d0
	beq	.nomoretracks
	move.l	d0,a2

	move.w	tr_number(a2),d4
	move.w	d4,d3				; hold d4 in d3
	IFEQ	pc_sizeof-6
	add.w	d3,d4
	add.w	d3,d4
	add.w	d4,d4				; use d4 as structure-offset
	ELSE
	mulu	#pc_sizeof,d4
	ENDC
	add.w	csc(a5),d4


	tst.w	pc_counter(a6,d4.w)
	bne.s	.sub2
	lea	tr_data(a2),a1
	adda.w	pc_offset(a6,d4.w),a1		; track-offset
	move.w	(a1),d1				; datenword oder counterword ?
	bpl.s	.midi2
;=== counterword
	move.w	d1,pc_counter(a6,d4.w)
	addq.w	#2,pc_offset(a6,d4.w)		; track-offset hochzhlen
.sub2	addq.w	#1,pc_counter(a6,d4.w)
	bra	.nextrk
;=== midi-daten
.midi2	addq.w	#wd_sizeof,pc_offset(a6,d4.w)
	tst.b	playdisabled(a5)
	bne.s	.active

;=== use these three lines in MidiTracker replay code !!
;	move.l	current_onoffs(a5),a0
;	tst.b	(a0,d3.w)
;	bne.s	.active
;=== silence current track
;	bra.s	.off


;=== use these two lines in executable player's code !!!
	tst.b	tr_onoff(a2)
	beq.s	.off


.active
	tst.b	channelquiet(a5)
	bne.s	.nextrk


	move.b	wd_pitch(a1),d1
	bmi.s	.off				; -1 means Note OFF specified
	IFNE	Pitch_clear
	cmp.b	#Pitch_clear,d1
	ENDC
	beq.s	.pp				; 0 means no note specified


;=== play a note on event
	move.b	pc_oldnote(a6,d4.w),d2		; $ff=Note ist schon off
	bmi.s	.skip_force

;=== force Note-OFF if previous note has not been released
	moveq	#-$80,d0
	or.b	d6,d0
	move.b	d0,(a4)+
	move.b	d2,(a4)+
	move.b	pc_oldvel(a6,d4.w),(a4)+

.skip_force
	move.b	wd_vel(a1),d2			; Velocity = 0 means a Note-OFF,
	beq.s	.nextrk				; in MIDI standard

	move.b	d1,pc_oldnote(a6,d4.w)		; d1 = the new note
	move.b	d2,pc_oldvel(a6,d4.w)

	moveq	#-$70,d0
	or.b	d6,d0
	move.b	d0,(a4)+
	move.b	d1,(a4)+			; new note
	move.b	d2,(a4)+			; new velocity

;=== trigger channelscope-level, which is maintained by scoper-process
;	lea	channellevels(a5),a0
;	IFEQ	mc68020
;	move.w	d6,d0
;	lsl.w	#2,d0
;	st	2(a0,d0.w)
;	ELSE
;	st	2(a0,d6.w*4)
;	ENDC
	bra.s	.pp


;=== here is jumped to, if a Note-OFF event came up

.off	move.b	pc_oldnote(a6,d4.w),d1
	bmi.s	.pp				; already off
	st	pc_oldnote(a6,d4.w)		; set note to OFF

	move.b	wd_vel(a1),d2
	bne.s	.no_fake_noteoff
	moveq	#-$70,d0			; play fake note-off
	bra.s	.fake_cont
.no_fake_noteoff
	moveq	#-$80,d0			; play real note-off
.fake_cont
	or.b	d6,d0
	move.b	d0,(a4)+
	move.b	d1,(a4)+
	move.b	d2,(a4)+
	bra.s	.nextrk


;=== check poly pressure byte

.pp	move.b	wd_pp(a1),d1
	cmpi.b	#cs_stay,d1
	beq.s	.nextrk				; no new pp-value
	move.b	pc_oldnote(a6,d4.w),d2		; check if there is a note
	bmi.s	.nextrk				; pending (-1 = no note)

	moveq	#-$60,d0
	or.b	d6,d0
	move.b	d0,(a4)+
	move.b	d2,(a4)+
	move.b	d1,(a4)+


.nextrk	bra	.trackloop

.nomoretracks




.nochan	suba.w	chanc(a5),a6			; next channel
	dbf	d6,.channelloop



;=== set mastervolume to positive if it's not-ed. A not-ed value means,
;=== all volumes must be recalculated. This has been done up to here, that's
;=== the reason why we reset it here.
	tst.w	mastervolume(a5)
	bpl.s	.clear
	not.w	mastervolume(a5)


.clear	move.b	#MS_CLOCK,(a4)+			; Realtime-Clock is ALWAYS sent
.nodata
	bsr.s	.optimize

	move.l	a4,d1				; now returning: d1 = serial
;	move.l	current_serbuf(a5),a0
;	sub.l	a0,d1				; data length
	sub.l	serialpufferD(a5),d1
;	move.l	d1,-sw_sizeof+sw_size(a0)
;	st	-sw_sizeof+sw_ready2send(a0)
	POSITIV

.neg	NEGATIV




;=== Put all Note-OFFs in front of all Note-ONs

.optimize	; a4=^end of buffer

	move.l	serialpufferD(a5),a0
	moveq	#9,d3
.optloop
	cmpa.l	a4,a0
	bcc.s	.optout

; search for next Note-ON event
	move.b	(a0)+,d0
	lsr.b	#4,d0
	cmp.b	d3,d0
	bne.s	.optloop

	lea	2(a0),a2
.optloop2
	cmpa.l	a4,a2
	bcc.s	.optout

; search for next Note-OFF event
	move.b	(a2)+,d0
	lsr.b	#4,d0
	subq.b	#8,d0
	bne.s	.optloop2

; if there is one, exchange it with the Note-ON event
	move.b	-(a0),d2
	move.b	-(a2),(a0)+
	move.b	d2,(a2)+
	move.b	(a0),d2
	move.b	(a2),(a0)+
	move.b	d2,(a2)+
	move.b	(a0),d2
	move.b	(a2),(a0)+
	move.b	d2,(a2)+

	bra.s	.optloop

.optout	rts






;==============================================================
;
;  Playcounters initialisieren
;
;==============================================================

clear_counters
	moveq	#0,d1
	move.l	d1,bpmplaycounter(a5)
;	move.w	d1,bpmplaycounter+pcbpm_counter(a5)
;	move.w	d1,bpmplaycounter+pcbpm_offset(a5)

	move.l	playcounters(a5),a0
	moveq	#15,d3
.clearloop
	move.l	d1,(a0)+	; preset
	move.l	d1,(a0)+	; pitch
	move.l	d1,(a0)+	; mpress

;	move.w	d1,pcp_counter(a0)
;	move.w	d1,pcp_offset(a0)
;	addq.w	#pcp_sizeof,a0

;	move.w	d1,pcpb_counter(a0)
;	move.w	d1,pcpb_offset(a0)
;	addq.w	#pcpb_sizeof,a0

;	move.b	d1,pcmp_counter(a0)
;	move.w	d1,pcmp_offset(a0)
;	addq.w	#pcmp_sizeof,a0

	move.w	active_csources_m1+2(a5),d2
.csclearloop
	move.b	d1,pcc_counter(a0)
	move.w	d1,pcc_offset(a0)
	addq.w	#pcc_sizeof,a0
	dbf	d2,.csclearloop

	move.w	maxtracks_m1+2(a5),d2
.trclearloop
	move.w	d1,pc_counter(a0)
	move.w	d1,pc_offset(a0)
	addq.w	#pc_sizeof,a0
	dbf	d2,.trclearloop

	dbf	d3,.clearloop

	rts






;==============================================================
;
;  Mixer Routine
;
;==============================================================

;=== Mix mastervolume/channel-sliders/channel-volumes all together

mixdown		; a4=^dest-data, d6=channel ($0-$f)

	moveq	#127,d3
	moveq	#0,d5			; changed-flag

	lea	channelvolumes(a5),a1
	moveq	#0,d1
	move.b	(a1,d6.w),d1		; get volume-parameter
	bpl.s	.volumes_ok
	not.b	d1
	move.b	d1,(a1,d6.w)
	moveq	#-1,d5
.volumes_ok

	lea	channelsliders(a5),a1
	moveq	#0,d2
	move.b	(a1,d6.w),d2		; get channelscope-slider's value
	bpl.s	.sliders_ok
	not.b	d2
	move.b	d2,(a1,d6.w)
	moveq	#-1,d5
.sliders_ok

	move.w	mastervolume(a5),d4
	bpl.s	.mastervolume_ok
	not.w	d4
	moveq	#-1,d5
.mastervolume_ok

	tst.b	d5
	beq.s	.rts

	cmp.w	d3,d2
	beq.s	.skip1
	mulu	d2,d1
	divu	d3,d1			; norm it to channelscope-sliders
	ext.l	d1
.skip1

	cmp.w	d3,d4
	beq.s	.skip2
	mulu	d4,d1
	divu	d3,d1			; norm it to mastervolume
	ext.l	d1
.skip2

	moveq	#-$50,d0	; d0.b=$b0
	or.b	d6,d0
	move.b	d0,(a4)+
	move.b	#7,(a4)+
	move.b	d1,(a4)+

;	lea	channellevels(a5),a1
;	IFEQ	mc68020
;	move.w	d6,d0
;	lsl.w	#2,d0
;	move.b	d2,3(a1,d0.w)
;	ELSE
;	move.b	d2,3(a1,d6.w*4)
;	ENDC

.rts	rts





;=== Playcounter-Struktur initialisieren
clear_playcounters
	bsr	clear_counters

	move.l	playcounters(a5),a0
	moveq	#15,d2
.chanloop
	adda.w	csc(a5),a0

	move.w	maxtracks_m1+2(a5),d3
.trackloop
	st	pc_oldnote(a0)
	clr.b	pc_oldvel(a0)
	addq.w	#pc_sizeof,a0
	dbf	d3,.trackloop

	dbf	d2,.chanloop
	rts







PutMidi_player_3bytes	; d0-d2=bytes
	move.l	a0,-(sp)
	move.l	player_msource(a5),a0
	bsr.s	PutMidi_3bytes
	move.l	(sp)+,a0
	rts

PutMidi_3bytes	; d0-d2=bytes, a0=^msource

	movem.l	d0-d2/a0-a1/a6,-(sp)
	lsl.l	#8,d0
	add.b	d1,d0
	lsl.l	#8,d0
	add.b	d2,d0
	lsl.l	#8,d0
	move.l	d0,-(sp)
	move.l	sp,a1
	move.l	midibas(a5),a6
	jsr	PutMidiMsg(a6)
;	addq.l	#3,count(a5)
	addq.w	#4,sp
	movem.l	(sp)+,d0-d2/a0-a1/a6
	rts





PutMidi_player_2bytes	; d0-d1=bytes
	move.l	a0,-(sp)
	move.l	player_msource(a5),a0
	bsr.s	PutMidi_2bytes
	move.l	(sp)+,a0
	rts

PutMidi_2bytes	; d0-d1=bytes, a0=^msource

	movem.l	d0-d1/a0-a1/a6,-(sp)
	lsl.l	#8,d0
	add.b	d1,d0
	swap	d0
	move.l	d0,-(sp)
	move.l	sp,a1
	move.l	midibas(a5),a6
	jsr	PutMidiMsg(a6)
;	addq.l	#2,count(a5)
	addq.w	#4,sp
	movem.l	(sp)+,d0-d1/a0-a1/a6
	rts






PutMidi_player_1byte	; d0=byte
	move.l	a0,-(sp)
	move.l	player_msource(a5),a0
	bsr.s	PutMidi_1byte
	move.l	(sp)+,a0
	rts

PutMidi_1byte	; d0=byte, a0=^msource

	movem.l	d0-d1/a0-a1/a6,-(sp)
	ror.l	#8,d0
	move.l	d0,-(sp)
	move.l	sp,a1
	move.l	midibas(a5),a6
	jsr	PutMidiMsg(a6)
;	addq.l	#1,count(a5)
	addq.w	#4,sp
	movem.l	(sp)+,d0-d1/a0-a1/a6
	rts





;PutMStream_mout		; a1=^buffer, d1=length
;	move.l	a0,-(sp)
;	move.l	mout_msource(a5),a0
;	bsr.s	PutMStream
;	move.l	(sp)+,a0
;	rts

PutMStream_player	; a1=^buffer, d1=length
	move.l	a0,-(sp)
	move.l	player_msource(a5),a0
	bsr.s	PutMStream
	move.l	(sp)+,a0
	rts

PutMStream	; a1=^buffer, a0=^msource, d1=length
	movem.l	d0-d1/a1-a2/a6,-(sp)
;	add.l	d1,count(a5)
	move.l	a1,a2
	suba.l	a1,a1
	move.l	d1,d0
	move.l	midibas(a5),a6
	jsr	PutMidiStream(a6)
	movem.l	(sp)+,d0-d1/a1-a2/a6
	rts




CorrectPattern
	move.l	patterntab(a5),a0
	move.l	currentpattern(a5),d0
	IFEQ	mc68020
	lsl.l	#2,d0
	move.l	(a0,d0.l),currentpatternA(a5)
	ELSE
	move.l	(a0,d0.l*4),currentpatternA(a5)
	ENDC
	rts

CorrectChannel
	move.l	currentpatternA(a5),a0
	move.w	currentchannel(a5),d0
	IFEQ	mc68020
	lsl.w	#2,d0
	move.l	pt_channels-4(a0,d0.w),currentchannelA(a5)
	ELSE
	move.l	pt_channels-4(a0,d0.w*4),currentchannelA(a5)
	ENDC
	rts



make_preset_message	; d0=preset, a4=^buffer, d6=channel (0-15)
	tst.b	pchgtype(a5)
	beq.s	.extended

	moveq	#-$40,d1	; d1.b=$c0
	or.b	d6,d1		; Channel eintragen
	move.b	d1,(a4)+
	move.w	d0,d1		; LSB von d0 ist Program,
	lsr.w	#8,d1		; MSB von d0 ist Bank.
	mulu	#100,d1		;
	ext.w	d0		;
	add.w	d1,d0		;
	andi.b	#$7f,d0		; d0 = LSB + MSB*100 (<128)
	move.b	d0,(a4)+
	rts

.extended
	moveq	#-$50,d1	; $b0
	or.b	d6,d1
	move.b	d1,(a4)+
	move.b	#$20,(a4)+	; BANK parameter
	ror.w	#8,d0
	move.b	d0,(a4)+	; bank number

	moveq	#-$40,d1	; d1.b=$c0
	or.b	d6,d1
	move.b	d1,(a4)+
	ror.w	#8,d0
	move.b	d0,(a4)+	; preset number
	rts







ResetNotesAndControllers

;=== reset all note-ons

	move.l	playcounters(a5),a3
	move.w	chanc(a5),d0
	move.w	d0,d1		; = mulu #15,d0
	lsl.w	#4,d0		;
	sub.w	d1,d0		;
	adda.w	csc(a5),a3
	adda.w	d0,a3
	moveq	#15,d6
.channelloop2
	cmp.w	#$f,d6
	bne.s	.t1
	move.l	$dff01c,d0
	move.l	$dff01c,d0
.t1

	move.l	maxtracks_m1(a5),d3
	mulu	#pc_sizeof,d3
.trackloop2
	move.b	pc_oldnote(a3,d3.w),d1
	bmi.s	.next

	st	pc_oldnote(a3,d3.w)		; set note to OFF
	moveq	#-$80,d0
	or.b	d6,d0
	move.b	pc_oldvel(a3,d3.w),d2
	bsr	send_3_bytes

.next	subq.w	#pc_sizeof,d3
	bcc.s	.trackloop2

	bsr.s	ResetControllers

	suba.w	chanc(a5),a3
	dbf	d6,.channelloop2

	rts




ResetControllers	; d6=channel

;=== reset all Controllers

	moveq	#-$50,d0
	or.b	d6,d0
	lea	channelsliders(a5),a0
	move.l	cs_codetab(a5),a1
	move.l	cs_codepanic(a5),a2
	move.l	active_csources_m1(a5),d7
.controllerloop
	move.b	(a1,d7.w),d1
	cmp.b	#7,d1
	bne.s	.novol
	move.b	(a0,d6.w),d2
	bpl.s	.posi
	not.b	d2
.posi	bra.s	.next
.novol	move.b	(a2,d7.w),d2
.next
	bsr	send_3_bytes
	dbf	d7,.controllerloop


;=== Pitchbend reset

	moveq	#-$20,d0
	or.b	d6,d0
	moveq	#0,d1
	moveq	#$40,d2
	bsr	send_3_bytes


;=== MPress reset

	moveq	#-$30,d0
	or.b	d6,d0
	moveq	#0,d1
	bra	send_2_bytes






	IFNE	tbeirq

SetIRQ
	moveq	#-1,d0
	move.l	(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,serialreadysig(a5)
	bmi.s	.neg


;=== expunge serial.device
	jsr	Forbid(a6)
	jsr	Disable(a6)

	lea	sernam(pc),a1
	lea	350(a6),a0
	jsr	FindName(a6)
	move.l	d0,-(sp)

	jsr	Enable(a6)
	jsr	Permit(a6)

	move.l	(sp)+,d0
	beq.s	.nodev
	move.l	d0,a6
	jsr	ExpungeDevice(a6)
.nodev


	moveq	#0,d0
	lea	.tbe_irq(pc),a1
	move.l	(a5),a6
	jsr	SetIntVector(a6)
	tst.l	d0
	bne.s	.reset

	move.w	#114,$dff032
	st	irq_set(a5)
	move.w	#$8001,$dff09a
	POSITIV

.reset
	move.l	d0,a1
	moveq	#0,d0
	jsr	SetIntVector(a6)

.neg	NEGATIV



.tbe_irq
	dc.l	0,0
	dc.b	2,1
	dc.l	.irqname
	dc.l	varbase
	dc.l	.irqcode


.irqname
	dc.b	'MT serial out',0
	even


.irqcode
;	move.w	#$4000,$9a(a0)
	move.w	#$0001,$9c(a0)

	move.l	readpointer(a1),a5
	cmpa.l	writepointer(a1),a5
	beq.s	.ready

	move.w	#$0100,d0
	move.b	(a5)+,d0
	cmpa.l	irqpufferlimitD(a1),a5
	bcs.s	.put
	move.l	irqpufferD(a1),a5
.put	move.l	a5,readpointer(a1)
	move.w	d0,$30(a0)

;	addq.l	#1,tbecount(a1)
;	move.l	irqpointer(a1),a5
;	move.b	d0,(a5)+
;	move.l	a5,irqpointer(a1)
	bra.s	.done

.ready
	moveq	#0,d0
	move.b	serialreadysig(a1),d1
	bset	d1,d0
	move.l	mytask(a1),a1
	jsr	Signal(a6)

.done
;	move.w	#$c000,$9a(a0)
	rts




RemIRQ
	tst.b	irq_set(a5)
	beq.s	.not_set

	move.l	readpointer(a5),a0
	cmpa.l	writepointer(a5),a0
	beq.s	.dontwait

	moveq	#0,d0
	moveq	#0,d1
	move.b	serialreadysig(a5),d2
	bset	d2,d1
	move.l	(a5),a6
	jsr	SetSignal(a6)

	moveq	#0,d0
	bset	d2,d0
	jsr	Wait(a6)
.dontwait

	move.w	#$0001,$dff09a

	moveq	#0,d0
	suba.l	a1,a1
	move.l	(a5),a6
	jsr	SetIntVector(a6)

.not_set

	move.b	serialreadysig(a5),d0
	move.l	(a5),a6
	jsr	FreeSignal(a6)

	rts








send_1_byte
	movem.l	d0/a0,-(sp)
	subq.w	#4,sp
	move.b	d0,(sp)
	move.l	sp,a0
	moveq	#1,d0
	bsr.s	get_irq_buffer
	addq.w	#4,sp
	movem.l	(sp)+,d0/a0
	rts


send_2_bytes
	movem.l	d0-d1/a0,-(sp)
	subq.w	#4,sp
	move.b	d0,(sp)
	move.b	d1,1(sp)
	move.l	sp,a0
	moveq	#2,d0
	bsr.s	get_irq_buffer
	addq.w	#4,sp
	movem.l	(sp)+,d0-d1/a0
	rts


send_3_bytes
	movem.l	d0-d2/a0,-(sp)
	subq.w	#4,sp
	move.b	d0,(sp)
	move.b	d1,1(sp)
	move.b	d2,2(sp)
	move.l	sp,a0
	moveq	#3,d0
	bsr.s	get_irq_buffer
	addq.w	#4,sp
	movem.l	(sp)+,d0-d2/a0
	rts



send_stream
	movem.l	d0-d1/a0-a1,-(sp)
	move.l	d1,d0
	move.l	a1,a0

	bsr.s	get_irq_buffer
;	beq.s	.rts


	movem.l	(sp)+,d0-d1/a0-a1
	rts


get_irq_buffer	; d0=size, a0=^data

	tst.l	d0
	beq.s	.neg

;	add.l	d0,count(a5)

	movem.l	d0-d2/a0-a2/a6,-(sp)

;	move.l	(a5),a6
;	jsr	Disable(a6)
;	move.w	#$4000,$dff09a

	move.l	(sp),d0
	move.l	12(sp),a0
	move.l	writepointer(a5),a1
;	cmpa.l	readpointer(a5),a1
;	seq	d2
	move.l	irqpufferlimitD(a5),a2
.copy	cmpa.l	a2,a1
	bcs.s	.ok
	move.l	irqpufferD(a5),a1
.ok	move.b	(a0)+,(a1)+
	subq.l	#1,d0
	bne.s	.copy
	move.l	a1,writepointer(a5)
.nocopy

	move.w	$dff018,d0

;	move.l	adr,a0
;	move.w	d0,(a0)+
;	move.w	d2,(a0)+
;	clr.l	(a0)+
;	move.l	readpointer(a5),(a0)+
;	move.l	writepointer(a5),(a0)+
;	move.l	a0,adr

;	tst.b	d2
;	bne.s	.trig
;	bra.s	.notbe


	btst	#13,d0
	beq.s	.notbe
.trig	move.w	#$8001,$dff09c
.notbe

;	move.w	#$c000,$dff09a
;	jsr	Enable(a6)

.pos	movem.l	(sp)+,d0-d2/a0-a2/a6
	POSITIV

.neg	NEGATIV


	ENDC






	IFNE	midilib

send_1_byte
	bra	PutMidi_player_1byte

send_2_bytes
	bra	PutMidi_player_2bytes

send_3_bytes
	bra	PutMidi_player_3bytes

send_stream
	bra	PutMStream_player

	ENDC



;adr	dc.l	puf



template	dc.b	'SONG/A,',0

dosnam		dc.b	'dos.library',0
intnam		dc.b	'intuition.library',0
midinam		dc.b	'midi.library',0
timnam		dc.b	'timer.device',0
cianam		dc.b	'ciaa.resource',0
sernam		dc.b	'serial.device',0

		even




;============================================================
		rsreset
		rs.l	1
dosbas		rs.l	1
intbas		rs.l	1
midibas		rs.l	1
ciares		rs.l	1
rdargs		rs.l	1
mytask		rs.l	1
eclockval	rs.l	2
TimerReply	rs.l	1	; Replyport fr timer
TimerIO		rs.l	1	; Timer-IORequest
argarray	rs.l	0
songname	rs.l	1
playcounters	rs.l	1
chanc		rs.w	1
csc		rs.w	1
song_version	rs.w	1
channelsliders	rs.b	16	; 0-127=volume, from channelscope-sliders
channelvolumes	rs.b	16	; 0-127=volume, from Volume-parameter in replay
;tempo		rs.w	1	; bpm
playtempo	rs.w	1	; tempo whrend des Spielens
mastervolume	rs.w	1	; master volume
length		rs.l	1
positionsA	rs.l	1
displaypos	rs.l	1	; die noch dargestellt ist
currentpos	rs.l	1	; aktuelle Song-position
patterntab	rs.l	1

events		rs.l	1	; events*pattscale
eventpos	rs.l	1
currentpattern	rs.l	1	; aktuelles pattern (gadget)
currentpatternA	rs.l	1	; ^aktuelles pattern
currentchannel	rs.w	1	; aktueller channel (slider)
currentchannelA	rs.l	1	; ^aktueller channel

disk_track	rs.b	trs_sizeof	; Temp-Puffer fr Tracksaver
disk_pattern	rs.b	pts_sizeof	; Temp-Puffer fr Patternsaver
disk_channel	rs.b	chs_sizeof	; Temp-Puffer fr Channelsaver
disk_csource	rs.b	css_sizeof	; Temp-Puffer fr Controlsource
songheader	rs.b	so_sizeof

bpmplaycounter	rs.b	pcbpm_sizeof


cs_codetab	rs.l	1	; ^parameter-codes currently in use
cs_codepanic	rs.l	1	; ^panic (reset) values
active_csources	rs.l	1	; number of active controlsources
active_csources_m1 rs.l	1	; number of active controlsources, -1

maxtracks	rs.l	1
maxtracks_m1	rs.l	1

sequencer_sysex	rs.b	1
playdisabled	rs.b	1
channelquiet	rs.b	1
pchgtype	rs.b	1
oldtaskpri	rs.b	1
irq_set		rs.b	1
ciasignal	rs.b	1
autostopsig	rs.b	1
serialreadysig	rs.b	1
		rs.b	1

serialpufferD	rs.l	1
readpointer	rs.l	1
writepointer	rs.l	1
irqpufferD	rs.l	1
irqpufferlimitD	rs.l	1
;irqpointer	rs.l	1
;count		rs.l	1
;count2		rs.l	1
;tbecount	rs.l	1
;irqcount	rs.l	1

mout_ser_root	rs.l	1
current_serbuf	rs.l	1
midiout_semaphore rs.b	$2e

player_msource		rs.l	1
player_sourceroute	rs.l	1

irqmem_root	rs.l	1



varsize		rs.b	0



prec1 = pcp_sizeof		; preset
prec2 = prec1+pcpb_sizeof	; pitchbend
prec3 = prec2+pcmp_sizeof	; mpress







;===============================================================
	section	bss_1,bss
varbase	ds.b	varsize

serialpuffer	ds.b	serialsize
irqpuffer	ds.b	serialsize
;irqpuffer2	ds.b	serialsize

;puf		ds.b	$8000

