


newstart
	lea	varbase,a5

	suba.l	a1,a1
	move.l	(a5),a6
	jsr	FindTask(a6)
	move.l	d0,playerprocess(a5)

;=== Signal fr den Play-Trigger allocaten
	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,playsignal(a5)
	bmi	crash

;=== Signal fr Short-Pause allocaten
	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,pausesig_player(a5)
	bmi	crash

	bsr	OpenTimer
	beq	crash

	bsr	OpenPlayerMidi
	beq	crash

	bsr	LaunchMidiOut
	beq	crash


;=== der Init hat geklappt
	bsr	reply_signal


playmain
	move.l	#$1000,d0		; Ctrl-C
	move.b	playsignal(a5),d1
	bset	d1,d0

	move.l	player_mdest(a5),a0
	move.l	$1e(a0),a0
	move.b	$f(a0),d2
;	tst.b	autorec_active(a5)
;	bne.s	.onl
;	tst.b	is_online(a5)
;	beq.s	.notonl
.onl	bset	d2,d0
.notonl
	move.l	(a5),a6
	jsr	Wait(a6)

	btst	#12,d0
	bne.s	playnormit


;=== is there an Online-Message from MIDI ?
	btst	d2,d0
	beq.s	.noserial
	move.l	d0,-(sp)
	bsr	DoOnline
	move.l	(sp)+,d0
.noserial


;=== Some routines may be triggered which need serious access to the
;=== serial device.
	move.b	playsignal(a5),d1
	btst	d1,d0
	beq.s	.skipit

	tst.b	playflag(a5)		; jump into replay-loop if playflag is
	bne	replay			; set to play/record

	moveq	#0,d0			; if playflag is set to STOP, mainprocess
	move.b	serialaction(a5),d0	; wants to trigger one of the implemented
	add.w	d0,d0			; routines.
	lea	.actiontab(pc,d0.w),a0
	adda.w	(a0),a0
	jsr	(a0)
	move.b	d0,player_rc(a5)
	bsr	reply_signal
.skipit

	bra	playmain



.actiontab
;	dr.w	writeserial2
;	dr.w	clear_serial
	dr.w	readhandshake
;	dr.w	readheadershake
	dr.w	readheader
	dr.w	Free_Midi_Packet
	dr.w	readdatapacket
;	dr.w	OpenSerial
;	dr.w	CloseSerial
;	dr.w	BeginOnline
;	dr.w	AbortOnline
	dr.w	WaitForSerial
	dr.w	ReadK2kBanks
	dr.w	ReadQuadraBanks
	dr.w	ReadQuadraMixes
	dr.w	ReadQuadraSingles


playnormit

crash	sf	processonline(a5)

	bsr	FreeSerialBuffers
	bsr	KillMidiOut

	bsr	ClosePlayerMidi
	bsr	CloseTimer


	move.b	playsignal(a5),d0
	move.l	(a5),a6
	jsr	FreeSignal(a6)
	move.b	pausesig_player(a5),d0
	jsr	FreeSignal(a6)

	bsr	reply_signal	; signal to maintask that it's done

	moveq	#0,d0
	rts




OpenPlayerMidi
	suba.l	a0,a0
	suba.l	a1,a1
	move.l	midibas(a5),a6
	jsr	CreateMSource(a6)
	move.l	d0,player_msource(a5)
	beq.s	.neg

	move.l	d0,a0
	lea	.midioutname(pc),a1
	suba.l	a2,a2
	jsr	MRouteSource(a6)
	move.l	d0,player_sourceroute(a5)
	beq.s	.neg


	suba.l	a0,a0
	suba.l	a1,a1
	jsr	CreateMDest(a6)
	move.l	d0,player_mdest(a5)
	beq.s	.neg

	lea	.midiinname(pc),a0
	move.l	d0,a1
	suba.l	a2,a2
	jsr	MRouteDest(a6)
	move.l	d0,player_destroute(a5)
	beq.s	.neg


.pos	POSITIV
.neg	NEGATIV



.midioutname	dc.b	'MidiOut',0
.midiinname	dc.b	'MidiIn',0
		even



ClosePlayerMidi
	move.l	midibas(a5),d0
	beq.s	.nomidi
	move.l	d0,a6

	move.l	player_sourceroute(a5),d0
	beq.s	.nosroute
	move.l	d0,a0
	jsr	DeleteMRoute(a6)
	clr.l	player_sourceroute(a5)
.nosroute

	move.l	player_msource(a5),d0
	beq.s	.nosource
	move.l	d0,a0
	jsr	DeleteMSource(a6)
	clr.l	player_msource(a5)
.nosource


	move.l	player_destroute(a5),d0
	beq.s	.nodroute
	move.l	d0,a0
	jsr	DeleteMRoute(a6)
	clr.l	player_destroute(a5)
.nodroute

	move.l	player_mdest(a5),d0
	beq.s	.nodest
	move.l	d0,a0
	jsr	DeleteMDest(a6)
	clr.l	player_mdest(a5)
.nodest

.nomidi	rts








;==============================================================
;
;  Routine zum Abspielen
;
;==============================================================


replay

;=== Pause-signal lschen
	moveq	#0,d0
	moveq	#0,d1
	move.b	pausesig_player(a5),d2
	bset	d2,d1
	move.l	(a5),a6
	jsr	SetSignal(a6)

	bsr	reply_signal


;=== send optional Sequencer-Startcode
	tst.b	sequencer_sysex(a5)
	beq.s	.nosysex
	tst.b	metromusic(a5)		; metronome handles this by itself
	beq.s	.nosysex
	move.b	#$fa,d0
	jsr	PutMidi_player_1byteJ(a5)
.nosysex


;=== SysTime merken -> Timer-Display Init
	lea	timervalinit(a5),a0
	move.l	timerio+$14(a5),a6
	jsr	GetSysTime(a6)



.timerloop

;=== Formel zur Umrechnung BPM -> Mikrosekunden
	move.l	#2500000,d0
	moveq	#0,d1
	move.w	playtempo(a5),d1
	addq.l	#4,d1
	LONGDIVU
	move.l	d0,d4

	cmp.b	#1,tapedeck(a5)		; Slow Forward ?
	bne.s	.noforw
	tst.b	playflag(a5)
	bpl.s	.noforw
	tst.b	forward_pressed(a5)	; activated by menuitem?
	beq.s	.fw_ok
	subq.b	#1,forward_counter(a5)	; if so, count down
	bne.s	.fw_ok
	move.l	forward_buttonJ+2(a5),playertomain(a5)
	bsr	reply_signal		; trigger function
.fw_ok	lsr.l	#2,d4			; Faktor 4 schneller
.noforw

	lea	timerio(a5),a1
	move.w	#9,$1c(a1)		; TR_ADDREQUEST
	clr.l	$20(a1)
	move.l	d4,$24(a1)
	move.l	(a5),a6
	jsr	SendIO(a6)



;=== See if mainprog wants midiplayer to halt for a short moment;
;=== Check if STOP-signal is set

	moveq	#0,d0
	moveq	#0,d1
	move.b	playsignal(a5),d2
	bset	d2,d1
	move.b	pausesig_player(a5),d3
	bset	d3,d1
	jsr	SetSignal(a6)
	btst	d2,d0
	bne	.stopped
	btst	d3,d0
	beq.s	.nopause
	bsr	.shortpause
.nopause

	bsr	createmidi
	beq	.stopped

;	tst.l	d1
;	beq.s	.nodata
;	move.l	serialpufferD(a5),a1	; d1 is length
;	jsr	PutMStream_playerJ(a5)
;.nodata


	moveq	#0,d0
	move.b	player2moutsig(a5),d1
	bset	d1,d0
	move.l	midioutprocess(a5),a1
	move.l	(a5),a6
	jsr	Signal(a6)


	bsr	recorder
	beq.s	.stopped

	bsr	playoutput


	lea	timerio(a5),a1
	move.l	(a5),a6
	jsr	WaitIO(a6)

.notim	bra	.timerloop



.shortpause
	move.l	mytask(a5),a1			; signal mainprog
	moveq	#0,d0				; to continue
	move.b	pausesig_main(a5),d1
	bset	d1,d0
	jsr	Signal(a6)

	moveq	#0,d0				; wait for mainprog
	move.b	pausesig_player(a5),d1		; to complete its action
	bset	d1,d0
	jmp	Wait(a6)




.stopped
	bsr	AbortTimer

;=== Send a realtime sysex: Sequencer-Stop
	tst.b	sequencer_sysex(a5)
	beq.s	.nosysex2
	move.b	#$fc,d0
	bsr	send_1_byte ;J(a5)
.nosysex2

	tst.b	song_halted(a5)
	beq.s	.skiph
	bsr	WaitForMain
.skiph
	bsr	reply_signal

	bra	playmain





;==============================================================
;
;  MidiOut-process launchen
;
;==============================================================

LaunchMidiOut

	lea	midiout_semaphore(a5),a0
	move.l	(a5),a6
	jsr	InitSemaphore(a6)

;=== allocate general-use signal
	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,mout2playersig(a5)
	bmi.s	.neg

;=== kick up new process
	st	midioutonline(a5)
	lea	.proctags(pc),a0
	move.l	a0,d1
	move.l	newstart-4(pc),$4(a0)
	move.l	dosbas(a5),a6
	jsr	CreateNewProc(a6)
	tst.l	d0
	beq.s	.neg

;=== wait for midiout to initialize itself
	moveq	#0,d0
	move.b	mout2playersig(a5),d1
	bset	d1,d0
	move.l	(a5),a6
	jsr	Wait(a6)
	tst.b	midioutonline(a5)
	beq.s	.neg


	POSITIV
.neg	NEGATIV


.proctags
	dc.l	$800003e8+1,0		; Seglist
	dc.l	$800003e8+11,1024	; Stacksize
	dc.l	$800003e8+12,midioutname	; Name
	dc.l	$800003e8+13,30		; Priority
	dc.l	0


midioutname
	dc.b	'MT Midi Out',0
	even



;==============================================================
;
;  MidiOut-process entfernen
;
;==============================================================

KillMidiOut
	tst.l	midioutprocess(a5)
	beq.s	.notask

	lea	midioutname(pc),a1
	move.l	(a5),a6
	jsr	FindTask(a6)
	tst.l	d0
	beq.s	.notask

;=== dem Playerprocess Bescheid geben, da er sich beenden soll
	move.l	d0,a1
	move.l	#$1000,d0
	jsr	Signal(a6)

	moveq	#0,d0
	move.b	mout2playersig(a5),d1
	bset	d1,d0
	jsr	Wait(a6)

	clr.l	midioutprocess(a5)


.notask
;=== Signale freigeben
	move.b	mout2playersig(a5),d0
	move.l	(a5),a6
	jmp	FreeSignal(a6)




FreeSerialBuffers
	move.l	mout_ser_root(a5),a2
	move.l	(a5),a6
.freeloop
	move.l	a2,d0
	beq.s	.out
	move.l	d0,a1
	move.l	(a1),a2
	jsr	FreeVec(a6)
	bra.s	.freeloop
.out	rts





;==============================================================
;
;  Play Output
;
;==============================================================

;=== Einige Gadgets refreshen und die aktuelle Position ausgeben
playoutput
	tst.b	metromusic(a5)
	beq.s	.noout

;=== von timervalinit subtrahieren -> Timer-Display
	lea	timerval(a5),a0
	move.l	timerio+$14(a5),a6
	jsr	GetSysTime(a6)
	lea	timervalinit(a5),a1
	jsr	SubTime(a6)

	move.l	playpos(a5),eventpos(a5)
	move.l	#player_update,playertomain(a5)
	bra	reply_signal

.noout	rts




;==============================================================
;
;  Seriellen Puffer schreiben
;
;==============================================================

;adr	dc.l	puf
;adr2	dc.l	0

;writeserial2
;	move.l	puffersize(a5),d1
;writeserialpuffer			; d1=puffersize
;	move.l	serialpufferD(a5),a0
;writeserial3				; d1=length, a0=^puffer to write

;=== Testroutine: kopiert die seriellen Daten in einen puffer
;	addq.l	#1,adr2
;	movem.l	d1/a0,-(sp)
;	move.l	adr,a0
;	move.l	serialpufferD(a5),a1
;.wloop	move.b	(a1)+,(a0)+
;	subq.l	#1,d1
;	bne.s	.wloop
;	move.l	a0,adr
;	movem.l	(sp)+,d1/a0

;	move.l	a0,a2
;	move.l	msource(a5),a0
;	suba.l	a1,a1
;	move.l	d1,d0
;	move.l	midibas(a5),a6
;	jmp	PutMidiStream(a6)


;	move.l	serialwrite(a5),a1
;	jmp	writeserialJ(a5)



;==============================================================
;
;  Serial-device initialisieren
;
;==============================================================

;clear_serial
;	rts



;==============================================================
;
;  Signal an Mainprocess schicken
;
;==============================================================

reply_signal
	move.b	procsignal(a5),d1

reply_sig	; d1=sigbit
	move.l	mytask(a5),a1
	moveq	#0,d0
	bset	d1,d0
	move.l	(a5),a6
	jmp	Signal(a6)





;==============================================================
;
;  Read Handshake (=ACK/NACK/CANCEL)
;
;==============================================================

readhandshake

;=== gibt zurck: POSITIV, wenn Handshake angekommen ist,
;===              NEGATIV, wenn Timeout



.waitloop
	bsr	BeginTimer2secs

.readyloop
;=== Auf eins der beiden SigBits warten
	bsr	WaitTimerAndSerial
	beq.s	.timerbit


.getmidiloop
	bsr	get_midi_packet
	beq.s	.readyloop

	cmp.b	#MS_SYSEX,(a2)
	bne.s	.reloop

	cmp.b	#$7e,sdsh_sdsid(a2)
	bne.s	.reloop

	move.b	sdumpchannel(a5),d0
	cmp.b	sdsh_channel(a2),d0
	bne.s	.reloop

	cmp.b	#MS_EOX,sdsh_eox(a2)
	bne.s	.reloop
	bra.s	.outloop

.reloop	jsr	FreeMidiPacket(a6)
	bra.s	.getmidiloop
.outloop

	move.b	sdsh_type(a2),sds_handshake_rc(a5)
	jsr	FreeMidiPacket(a6)
	bsr	AbortTimer

	cmp.b	#$7c,sds_handshake_rc(a5)	; WAIT-Packet
	beq.s	.waitloop

	POSITIV

.timerbit
	NEGATIV




BeginTimer1sec
	moveq	#1,d0
	bra.s	BeginTimer

BeginTimer2secs
	moveq	#2,d0

;=== Post request to wait <d0> seconds
BeginTimer	; d0 = number of seconds to wait
	move.l	d0,-(sp)

	moveq	#0,d1
	move.b	timersignal(a5),d0
	bset	d0,d1
	moveq	#0,d0
	move.l	(a5),a6
	jsr	SetSignal(a6)

	lea	timerio(a5),a1
	move.w	#9,$1c(a1)
	move.l	(sp)+,$20(a1)
	clr.l	$24(a1)
	jmp	SendIO(a6)



;=== Wait for timer sigbit and serialread-sigbit.

WaitTimerAndSerial	; returns: positive = serial data has arrived,
			;          negative = timeout.

	moveq	#0,d0
	move.l	player_mdest(a5),a0
	move.l	$1e(a0),a0
	move.b	$f(a0),d2
	bset	d2,d0
	move.b	timersignal(a5),d1
	bset	d1,d0
	move.l	(a5),a6
	jsr	Wait(a6)
	btst	d2,d0
	beq.s	.timer

	POSITIV

.timer	lea	timerio(a5),a1
	jsr	WaitIO(a6)		; remove iorequest
	NEGATIV





get_midi_packet	; returns: a2=^midimsg, a0=^midipacket,
		;          pos=packet arrived, neg=no packet arrived

	move.l	player_mdest(a5),a0
	move.l	midibas(a5),a6
	jsr	GetMidiPacket(a6)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a0
	move.w	$16(a0),d0
	add.w	d0,current_activity_rec(a5)	; add to activity counter
	lea	$1c(a0),a2

	POSITIV
.neg	NEGATIV





;==============================================================
;
;  Read Headerpacket (oder auch nicht, falls z.B. kein Sample vorhanden)
;
;==============================================================

readheader

	bsr	BeginTimer2secs


.readyloop

;=== Header lesen (Background)
	bsr	WaitTimerAndSerial
	beq	.timerbit

.getmidiloop
	bsr	get_midi_packet
	beq.s	.readyloop

	cmp.b	#MS_SYSEX,(a2)
	bne.s	.reloop

	cmp.b	#$7e,sds_sdsid(a2)
	bne.s	.reloop

	cmp.b	#$01,sds_type(a2)
	bne.s	.reloop

	move.b	sdumpchannel(a5),d0
	cmp.b	sds_channel(a2),d0
	bne.s	.reloop

	cmp.b	#MS_EOX,sds_eox(a2)
	bne.s	.reloop
	bra.s	.outloop

.reloop	jsr	FreeMidiPacket(a6)
	bra.s	.getmidiloop
.outloop

;=== bits checken (im Moment nur 16bit mglich!)
	move.b	sds_bits(a2),synthe_bits(a5)
	cmp.b	#$10,synthe_bits(a5)
	bne.s	.cancelheader

	move.l	a0,midipacket(a5)
	bsr	AbortTimer
	POSITIV



;=== Header canceln und so tun, als ob kein Header angekommen sei
.cancelheader
	lea	sds_packet(a5),a2
	move.b	#$f0,(a2)
	move.b	#$7e,sds_sdsid(a2)
	move.b	sdumpchannel(a5),sds_channel(a2)
	move.b	#$7d,sds_type(a2)
	move.b	#$00,sds_packet(a2)
	move.b	#$f7,sds_eox(a2)
	move.l	main_msource(a5),a0
	move.l	a2,a1
	move.l	midibas(a5),a6
	jsr	PutMidiMsg(a6)


;=== Timeout

.timerbit
	NEGATIV



Free_Midi_Packet
	move.l	midipacket(a5),a0
	move.l	midibas(a5),a6
	jmp	FreeMidiPacket(a6)




;==============================================================
;
;  Read Data-Packet or Handshake-Packet
;
;==============================================================

readdatapacket

.waitloop
	bsr	BeginTimer2secs


.readyloop

;=== Header lesen (Background)
	bsr	WaitTimerAndSerial
	beq	.timerbit

.getmidiloop
	bsr	get_midi_packet
	beq.s	.readyloop

	cmp.b	#MS_SYSEX,(a2)
	bne.s	.reloop

	cmp.b	#$7e,sdsp_sdsid(a2)
	bne.s	.reloop

	move.b	sdumpchannel(a5),d0
	cmp.b	sdsp_channel(a2),d0
	bne.s	.reloop

	cmp.b	#$02,sdsp_type(a2)
	beq.s	.packet_arrived

	move.b	sdsh_type(a2),d0
	sub.b	#$7c,d0			; WAIT
	beq.s	.wait
	subq.b	#1,d0			; CANCEL
	beq.s	.handshake
	subq.b	#1,d0			; NACK
	beq.s	.handshake
	subq.b	#1,d0			; ACK
	beq.s	.handshake

.reloop	jsr	FreeMidiPacket(a6)
	bra.s	.getmidiloop


.packet_arrived
	cmp.b	#MS_EOX,sdsp_eox(a2)
	bne.s	.reloop
	sf	sds_handshake_rc(a5)
	move.l	a0,midipacket(a5)

.done	bsr	AbortTimer
	POSITIV

.handshake
	move.b	sdsh_type(a2),sds_handshake_rc(a5)
	jsr	FreeMidiPacket(a6)
	bra.s	.done

.wait	jsr	FreeMidiPacket(a6)
	bsr	AbortTimer
	bra.s	.waitloop


.timerbit
	NEGATIV





;==============================================================
;
;  Record routine
;
;==============================================================

recorder
	tst.b	autorec_active(a5)
	beq.s	.noarec
	sf	autorec_active(a5)
	bra.s	.rec

.noarec
	tst.b	playflag(a5)
	bmi	.playmode
.rec
	tst.b	metromusic(a5)
	beq	.playmode

	move.l	recbuf(a5),a2
	move.l	recbufpos(a5),d7
	adda.l	d7,a2

.getmidiloop
	move.l	player_mdest(a5),a0
	move.l	midibas(a5),a6
	jsr	GetMidiPacket(a6)
	tst.l	d0
	beq.s	.outloop
	move.l	d0,a0

	move.w	$16(a0),d0		; Length
	ext.l	d0
	lea	$1c(a0),a1
	add.l	d0,d7
	cmp.l	recbufsizebytes(a5),d7
	bcs.s	.do
	sub.l	d0,d7
	jsr	FreeMidiPacket(a6)
	bra.s	.overflow
.do	add.w	d0,current_activity_rec(a5)	; add to activity counter
	subq.w	#1,d0
.copydata
	move.b	(a1)+,(a2)+
	dbf	d0,.copydata

	jsr	FreeMidiPacket(a6)
	bra.s	.getmidiloop
.outloop

	tst.b	externalclock(a5)
	bne.s	.xclk1
	addq.l	#1,d7
	cmp.l	recbufsizebytes(a5),d7
	bcs.s	.xclk2
	subq.l	#1,d7
	bra.s	.overflow
.xclk2	move.b	#MS_CLOCK,(a2)+
.xclk1

	move.l	d7,recbufpos(a5)
.pos	POSITIV


.overflow
	move.l	d7,recbufpos(a5)

;	move.l	stop_buttonJ+2(a5),playertomain(a5)
;	bsr	reply_signal

	NEGATIV




.playmode
	move.l	midibas(a5),a6
.getmidiloop2
	move.l	player_mdest(a5),a0
	jsr	GetMidiPacket(a6)
	tst.l	d0
	beq.s	.outloop2
	move.l	d0,a0
	move.w	$16(a0),d0			; Length
	add.w	d0,current_activity_rec(a5)	; add to activity counter
	jsr	FreeMidiPacket(a6)
	bra.s	.getmidiloop2
.outloop2
	bra.s	.pos






;==============================================================
;
;  Begin Online Receive
;
;==============================================================

BeginOnline
	st	is_online(a5)
	rts




;==============================================================
;
;  Online Receive Verarbeitung
;
;==============================================================

DoOnline


.onlineloop
	move.l	player_mdest(a5),a0
	move.l	midibas(a5),a6
	jsr	GetMidiPacket(a6)
	move.l	d0,midipacket(a5)
	beq	.ready
	move.l	d0,a0
	move.w	$16(a0),d1
	add.w	d1,current_activity_rec(a5)	; add to activity counter

	tst.b	autorec_active(a5)
	beq.s	.normal_online

	move.w	$14(a0),d0
	and.w	#$700,d0
	bne	.reloop			; sysex data should not start autorec

	ext.l	d1
	add.l	d1,recbufpos(a5)
	lea	$1c(a0),a1
	move.l	recbuf(a5),a2
	subq.w	#1,d0
.copydata
	move.b	(a1)+,(a2)+
	dbf	d0,.copydata

	jsr	FreeMidiPacket(a6)
	bra	reply_signal		; start Auto-Recording
					; (1st valid midimsg has arrived)


.normal_online
	move.w	$14(a0),d0
	and.w	#$700,d0
	bne	.reloop			; sysex data should not start autorec



;=== Bei MIDI-thru die Daten an die Serielle weiterschicken
	tst.b	midithru_global(a5)
	beq.s	.nomidithru

	lea	$1c(a0),a1
	move.b	(a1),d0
	and.w	#$0f,d0
	move.w	midithru_chans(a5),d1
	btst	d0,d1
	beq.s	.nomidithru

	move.l	player_msource(a5),a0
	jsr	PutMidiMsg(a6)
.nomidithru



	tst.b	editmode(a5)
	beq.s	.noeditmode

;=== let the maintask do some work
	move.l	#MakeOnline,playertomain(a5)
	bsr	reply_signal
	bsr.s	WaitForMain

.noeditmode



;=== trigger channelscope-level
	move.l	midipacket(a5),a0
	move.b	$1c(a0),d0
	move.b	d0,d1
	lsr.b	#4,d1
	cmp.b	#$09,d1
	bne.s	.no_noteon
	tst.b	$1c+2(a0)		; velocity value
	beq.s	.no_noteon		; velocity=0 means note-off
	lea	channellevels(a5),a0
	and.w	#$0f,d0
	IFEQ	mc68020
	lsl.w	#2,d0
	st	2(a0,d0.w)
	ELSE
	st	2(a0,d0.w*4)
	ENDC
.no_noteon



.reloop	move.l	midipacket(a5),a0
	move.l	midibas(a5),a6
	jsr	FreeMidiPacket(a6)
	bra	.onlineloop
.ready

	bra	BeginOnline



;=== Warten, bis die Verarbeitung fertig ist

WaitForMain
	moveq	#0,d0
	move.b	playsignal(a5),d1
	bset	d1,d0
	move.l	(a5),a6
	jmp	Wait(a6)




;==============================================================
;
;  Abort Online Receive
;
;==============================================================

;AbortOnline
;	sf	is_online(a5)
;	rts


AbortTimer
	lea	timerio(a5),a1
	jmp	AbortDeviceJ(a5)





;==============================================================
;
;  Wait For Serial
;
;==============================================================

WaitForSerial
	st	autorec_active(a5)
	rts

;	move.l	recbuf(a5),a0


;BeginSerialRead	; a0=^buffer
;	move.l	a0,-(sp)

;=== clear serial-read signal
;	moveq	#0,d1
;	move.b	SerReadSignal(a5),d0
;	bset	d0,d1
;	moveq	#0,d0
;	move.l	(a5),a6
;	jsr	SetSignal(a6)

;=== post a request to read 1 byte asyncronously
;	move.l	serialread(a5),a1
;	move.w	#2,$1c(a1)
;	moveq	#1,d0
;	move.l	d0,$24(a1)
;	move.l	(sp)+,$28(a1)
;	jmp	SendIO(a6)




;==============================================================
;
;  Retrieve all programs from the K2000
;
;==============================================================


ReadK2kBanks

	clr.l	k2knumprogs(a5)
	move.l	sysex_serbuf(a5),a3
	moveq	#0,d7			; bank counter
.bankloop


;=== request a bank

	lea	.dirbank_data(pc),a2
	move.b	k2kdevid(a5),2(a2)
	move.b	d7,7(a2)
	add.w	#.dirbank_len,current_activity_play(a5)	; add to activity counter
	jsr	putmidimsg_player_a2J(a5)

.readloop
	bsr	BeginTimer1sec

	bsr	WaitTimerAndSerial
	beq	.timerbit

	bsr	AbortTimer

.getmidiloop
	move.l	player_mdest(a5),a0
	move.l	midibas(a5),a6
	jsr	GetMidiPacket(a6)
	tst.l	d0
	beq.s	.readloop
	move.l	d0,a0
	move.w	$16(a0),d1
	add.w	d1,current_activity_rec(a5)	; add to activity counter
	lea	$1c(a0),a1

	cmp.b	#MS_SYSEX,(a1)
	bne.s	.reloop

	cmp.b	#MID_KURZWEIL,1(a1)
	bne.s	.reloop
	move.b	k2kdevid(a5),d0
	cmp.b	2(a1),d0
	bne.s	.reloop
	cmp.b	#$78,3(a1)
	bne.s	.reloop
	cmp.b	#MS_EOX,3(a1)
	bne.s	.reloop

	move.b	4(a1),d0
	cmp.b	#$0d,d0
	beq.s	.outloop
	cmp.b	#$05,d0
	bne.s	.reloop

	cmp.b	#$01,5(a1)		; type PROGRAM only
	bne.s	.reloop
	cmp.b	#$04,6(a1)
	bne.s	.reloop
	addq.l	#1,k2knumprogs(a5)

	subq.w	#1,d1
.copyloop
	move.b	(a1)+,(a3)+
	dbf	d1,.copyloop

.reloop	jsr	FreeMidiPacket(a6)
	bra.s	.getmidiloop

.outloop
	jsr	FreeMidiPacket(a6)

	addq.b	#1,d7
	cmp.b	#10,d7
	bcs	.bankloop
	clr.b	(a3)			; zero byte = end of stream

	POSITIV


.timerbit	; timeout (synthe has been turned off ???)
	NEGATIV



.dirbank_data
	dc.b	$f0,$07,0,$78,$0c,1,4,0,0,$f7
.dirbank_len = *-.dirbank_data

	even






;==============================================================
;
;  Retrieve all Mixes from the Quadrasynth in a specified range
;
;==============================================================

ReadQuadraMixes
	moveq	#5,d0
	bra.s	QuadraFromTo



;==============================================================
;
;  Retrieve all Singles from the Quadrasynth in a specified range
;
;==============================================================

ReadQuadraSingles
	moveq	#1,d0
QuadraFromTo
	move.b	quadrafrom(a5),d1
	move.b	quadrato(a5),d2
	bra.s	ReadQuadraDump



;==============================================================
;
;  Retrieve all programs from the Quadrasynth
;
;==============================================================


ReadQuadraBanks
	moveq	#1,d0
	moveq	#0,d1
	moveq	#127,d2
;	bra.s	ReadQuadraDump


ReadQuadraDump	; a0=^dumprequest-data, d0.b=type (5=mix, 1=single)
		; d1.b=from-number, d2.b=to-number

	movem.l	d1-d2/a0,-(sp)
	move.b	d0,5(a0)
	subq.b	#1,d0
	beq.s	.single
	move.l	#149-1,d5		; total length of a mix-dump minus 1
	bra.s	.scont
.single	move.l	#408-1,d5		; total length of a single-dump minus 1
.scont

	move.l	sysex_serbuf(a5),a2
	moveq	#0,d6			; puffer-offset in bytes
	move.b	3(sp),d7		; program-number counter
.programloop

	lea	.quadradump_request(pc),a0
	move.b	d7,6(a0)

;	move.l	serialwrite(a5),a1
	move.w	#3,$1c(a1)
	moveq	#.dump_len,d0
	move.l	d0,$24(a1)
	add.w	d0,current_activity_play(a5)	; add to activity counter
	move.l	a0,$28(a1)
	move.l	(a5),a6
	jsr	DoIO(a6)


.readloop
	bsr	BeginTimer1sec


;=== Programm holen  (Background)

	bsr	WaitTimerAndSerial
	beq	.timerbit

.out
;=== timer canceln
	bsr	AbortTimer

	addq.l	#1,d6
	cmpi.b	#$f0,-1(a2,d6.l)		; begin sysex ?
	bne.s	.readloop


;=== Rest einlesen
	lea	(a2,d6.l),a0
	add.l	d5,d6
	cmpi.l	#quadraserbufsize,d6
	bcc.s	.overflow

;	move.l	serialread(a5),a1
	move.w	#2,$1c(a1)
	move.l	d5,$24(a1)			; read outstanding dumpdata
	add.w	d5,current_activity_rec(a5)	; add to activity counter
	move.l	a0,$28(a1)
	jsr	DoIO(a6)


	addq.b	#1,d7
	cmp.b	7(sp),d7
	bls	.programloop

	moveq	#0,d0
.fixstack
	move.l	d6,recbufpos(a5)
	movem.l	(sp)+,d1-d2/a0
	rts

.overflow
	sub.l	d5,d6
	moveq	#1,d0
	bra.s	.fixstack


.timerbit	; timeout ist eingetreten (synthe ausgeschaltet???)

	moveq	#2,d0
	bra.s	.fixstack



.quadradump_request	dc.b	$f0,$00,$00,$0e,$0e,1,0,$f7
.dump_len = *-.quadradump_request
			even


	ENDC	; cia timing



