                                      
	include	includes/exec.i
	include	includes/dos.i
	include	includes/icon.i
	include	includes/miditracker.i



VERSION_STRING	MACRO
		dc.b	'1.0'
		ENDM

RELEASE_DATE_STRING	MACRO
		dc.b	'03-Oct-1997'
		ENDM






NEGATIV	MACRO
	moveq	#0,d0
	rts
	ENDM

POSITIV	MACRO
	moveq	#1,d0
	rts
	ENDM


s	lea	varbase,a5

	bsr	InitAll
	beq.s	.normit


	move.l	filename(a5),a2
	lea	songdata(a5),a3
	bsr	loadfile_public
	beq.s	.nofile

	move.l	(a3),a0
	move.l	mtbas(a5),a6
;	jsr	mtInit(a6)
;	beq.s	.noinit


	tst.l	waitflag(a5)
	beq.s	.nowait
	move.l	#$3000,d0
	move.l	(a5),a6
	jsr	Wait(a6)
	btst	#12,d0
	bne.s	.noplay
.nowait


	suba.l	a1,a1
	move.l	mtbas(a5),a6
;	jsr	mtPlay(a6)
;	tst.l	d0
;	beq.s	.noplay


	move.l	#$1000,d0
	move.l	(a5),a6
	jsr	Wait(a6)


	move.l	mtbas(a5),a6
;	jsr	mtStop(a6)

.noplay
	move.l	mtbas(a5),a6
;	jsr	mtFree(a6)

.noinit
	lea	songdata(a5),a3
	bsr	unloadfile
.nofile


.normit	bsr	FreeAll

	moveq	#0,d0
	rts







loadfile_public
	moveq	#1,d0

loadfile	; a2=^filename, a3=^struktur (adr,len)
		; d0=Alloc-Flags
		; zurueck: d0: success/fail

	move.l	d0,-(sp)

	bsr	unloadfile

	move.l	a2,d1
	move.l	#1005,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d7
	beq.s	.neg

	move.l	d7,d1
	move.l	fib(a5),d2
	jsr	ExamineFH(a6)
	tst.l	d0
	beq.s	.neg2

; allocate
	move.l	d2,a0
	move.l	$7c(a0),d0
	move.l	d0,4(a3)
	move.l	(sp),d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	move.l	d0,(a3)
	beq.s	.neg2

; read + close
	move.l	d7,d1
	move.l	d0,d2
	move.l	4(a3),d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	tst.l	d0
	bmi.s	.neg3

	move.l	d7,d1
	jsr	Close(a6)

	addq.w	#4,sp
	POSITIV

.neg3	bsr.s	unloadfile

.neg2	move.l	d7,d1
	move.l	dosbas(a5),a6
	jsr	Close(a6)

.neg	clr.l	(a3)
	addq.w	#4,sp
	NEGATIV




;==============================================================
;
;  File Unload
;
;==============================================================

unloadfile	; a3=^struktur (adr,len)

	move.l	(a3),d0
	beq.s	.nofree
	clr.l	(a3)
	move.l	d0,a1
	move.l	4(a3),d0
	move.l	(a5),a6
	jsr	FreeMem(a6)
.nofree	rts







InitAll
	move.l	$4.w,(a5)

	suba.l	a1,a1
	move.l	(a5),a6
	jsr	FindTask(a6)
	move.l	d0,mytask(a5)

	move.l	d0,a0
	tst.l	$ac(a0)
	bne.s	.fromcli
	lea	$5c(a0),a0
	move.l	a0,-(sp)
	move.l	(a5),a6
	jsr	WaitPort(a6)
	move.l	(sp)+,a0
	jsr	GetMsg(a6)
	move.l	d0,wbenchmsg(a5)
.fromcli



	lea	dosnam,a1
	moveq	#0,d0
	move.l	(a5),a6
	jsr	OpenLibrary(a6)
	move.l	d0,dosbas(a5)
	beq.s	.neg



	tst.l	wbenchmsg(a5)
	beq.s	.noicon
	lea	iconnam,a1
	moveq	#36,d0
	jsr	OpenLibrary(a6)
	move.l	d0,iconbas(a5)
	beq.s	.neg
.noicon



	lea	mtnam,a1
	moveq	#0,d0
	jsr	OpenLibrary(a6)
	move.l	d0,mtbas(a5)
	beq.s	.nomt



;=== allocate fib
	moveq	#2,d1
	move.l	dosbas(a5),a6
	jsr	AllocDosObject(a6)
	move.l	d0,fib(a5)
	beq.s	.neg


	bsr.s	get_arguments
	beq.s	.neg



	POSITIV
.neg	NEGATIV


.nomt	tst.l	wbenchmsg(a5)
	bne.s	.neg
	move.l	#liberror,d1
	move.l	dosbas(a5),a6
	jsr	PutStr(a6)
	bra.s	.neg





get_arguments
	move.l	wbenchmsg(a5),d0
	bne.s	.fromwb

	lea	shell_template,a0
	move.l	a0,d1
	lea	argarray(a5),a0
	move.l	a0,d2
	moveq	#0,d3
	jsr	ReadArgs(a6)
	move.l	d0,rdargs(a5)
	beq.s	.neg
	bra.s	.pos


.fromwb
	move.l	d0,a0
	move.l	$1c(a0),d4	; sm_NumArgs
	moveq	#2,d0
	cmp.l	d0,d4
	bcs.s	.neg

	move.l	$24(a0),d0	; sm_ArgList
	beq.s	.neg
	move.l	d0,a4

	move.l	(a4),d1
	move.l	d1,startcd(a5)
	move.l	dosbas(a5),a6
	jsr	DupLock(a6)
	move.l	d0,d1
	beq.s	.neg
	move.l	d1,currentlock(a5)
	jsr	CurrentDir(a6)

	bsr.s	.get_tooltypes

	addq.w	#8,a4

	move.l	(a4),d1
	bsr	DoCD
	move.l	4(a4),filename(a5)
	bsr.s	.get_tooltypes


.pos	POSITIV
.neg	NEGATIV





.get_tooltypes	; a4 = ^WBArg structure

;=== load program's icon
	move.l	4(a4),a0	; wa_Name
	move.l	iconbas(a5),a6
	jsr	GetDiskObjectNew(a6)
	move.l	d0,d5
	beq.s	.noicon

	move.l	d0,a0
	cmp.b	#3,$30(a0)			; do_Type ?= WBTOOL
	bne.s	.zero

;=== Retrieve tooltypes
	move.l	$36(a0),a3			; do_Tooltypes
	lea	tooltypes,a2
.tooltypeloop
	move.l	(a2)+,d0
	beq.s	.ttout
	move.l	d0,a1
	move.l	a3,a0
	jsr	FindToolType(a6)
	move.l	(a2)+,d1
	move.l	d0,(a5,d1.l)			; may be NULL
	bra.s	.tooltypeloop
.ttout

.zero	move.l	d5,a0
	jsr	FreeDiskObject(a6)
.noicon

	rts




FreeAll

	move.l	dosbas(a5),d0
	beq.s	.nodos
	move.l	d0,a6

	move.l	rdargs(a5),d1
	beq.s	.noargs
	clr.l	rdargs(a5)
	jsr	FreeArgs(a6)
.noargs

	move.l	fib(a5),d2
	beq.s	.nofib
	moveq	#2,d1
	jsr	FreeDosObject(a6)
.nofib

	move.l	startcd(a5),d1
	beq.s	.nocd
	jsr	CurrentDir(a6)
.nocd

	move.l	currentlock(a5),d1
	beq.s	.noccd
	jsr	UnLock(a6)
.noccd


	lea	mtbas(a5),a0
	bsr.s	FreeLib

	lea	iconbas(a5),a0
	bsr.s	FreeLib

	lea	dosbas(a5),a0
	bsr.s	FreeLib

.nodos

	move.l	wbenchmsg(a5),d0
	beq.s	.fromcli
	move.l	(a5),a6
	jsr	Forbid(a6)	; so wb cant unloadseg() us
	move.l	wbenchmsg(a5),a1
	jsr	ReplyMsg(a6)
.fromcli

	rts



FreeLib	; a0 = ^libbase
	move.l	(a0),d0
	beq.s	.nolib
	move.l	d0,a1
	clr.l	(a0)
	move.l	(a5),a6
	jmp	CloseLibrary(a6)
.nolib	rts






;==============================================================
;
;  CD Directory
;
;==============================================================

DoCD	; d1 = new lock
	; returns: pos/neg

;	move.l	a0,d1
;	moveq	#-2,d2			; Shared lock
	move.l	dosbas(a5),a6
;	jsr	Lock(a6)
;	move.l	d0,d1
;	beq.s	.neg
	move.l	d1,-(sp)
	jsr	CurrentDir(a6)
	move.l	currentlock(a5),d1
	beq.s	.nolock
	jsr	UnLock(a6)
.nolock	move.l	(sp)+,currentlock(a5)
	POSITIV
;.neg	NEGATIV






;=================================================================
	section	dat,data


tooltypes
	dc.l	tt_wait
	dc.l	waitflag

	dc.l	0



		dc.b	'$VER: MTPlay '
		VERSION_STRING
		dc.b	' ('
		RELEASE_DATE_STRING
		dc.b	')',13,10,0


mtnam		dc.b	'miditracker.library',0
dosnam		dc.b	'dos.library',0
iconnam		dc.b	'icon.library',0

liberror	dc.b	'Need miditracker.library V1+',10,0


shell_template	dc.b	'FILE/A,WAIT/S',0

tt_wait		dc.b	'WAIT',0

; FILE     - the filename of a MT song
; WAIT     - don't play the song automatically. start it with ctrl-D

		even






;===========================================================

		rsreset
		rs.l	1
dosbas		rs.l	1
mtbas		rs.l	1
iconbas		rs.l	1
fib		rs.l	1
rdargs		rs.l	1
mytask		rs.l	1
wbenchmsg	rs.l	1
currentlock	rs.l	1
startcd		rs.l	1

argarray	rs.l	0
filename	rs.l	1
waitflag	rs.l	1

songdata	rs.l	2

varsize		rs.b	0





;===========================================================
	section	bss_1,bss
varbase	ds.b	varsize

