;APS00000000000000000000000000000000000000000000000000000000000000000000000000000000
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;
;
;
;
;          C H A N N E L S C O P E   (Scoper-Process)
;
;
;
;
;
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================

;=== In diesem Process wird auch die Sample-Trace-Line gezeichnet,
;=== an der man erkennen kann, an welcher Stelle gerade das Sample abgespielt
;=== wird.



hifi_peak_hold = 80



;=== Each level is exactly 4 bytes wide (32 pixels) and 32 pixels high.



scoperstart
	lea	varbase,a5

	st	scoper_startstop_sig(a5)
;	st	scoper_resetflag_sig(a5)
	st	chanmodesignal(a5)

	moveq	#-1,d0
	move.l	(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,chanmodesignal(a5)
	bmi	.error

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,scoper_startstop_sig(a5)
	bmi	.error

;	moveq	#-1,d0
;	jsr	AllocSignal(a6)
;	move.b	d0,scoper_resetflag_sig(a5)
;	bmi	.error

	suba.l	a1,a1
	jsr	FindTask(a6)
	move.l	d0,scoperprocess(a5)

;	bsr	.open_timer
;	beq	.error

	bsr	.signal_ctrl_f		; init was successful

.mainloop
;	move.l	ScoperTimerIO(a5),a1
;	move.w	#9,$1c(a1)
;	clr.l	$20(a1)
;	move.l	#1000000/100,$24(a1)
;	move.l	(a5),a6
;	jsr	DoIO(a6)


	move.l	gfxbas(a5),a6
	jsr	WaitTOF(a6)

	moveq	#0,d0			; clear all signals
	move.l	#$8000,d1
	move.b	chanmodesignal(a5),d2
	bset	d2,d1
	move.b	scoper_startstop_sig(a5),d3
	bset	d3,d1
;	move.b	scoper_resetflag_sig(a5),d4
;	bset	d4,d1
	move.l	(a5),a6
	jsr	SetSignal(a6)


	btst	d3,d0
	beq.s	.nostartstopsig
	bsr	.signal_ctrl_f
.nostartstopsig


	IFEQ	1

;=== Set a flag

	btst	d3,d0			; main process wants scoper to toggle
	beq.s	.no_main_sig		; a flag (offset is in flag_address)

	move.w	flag_address(a5),d1
	st	(a5,d1.w)
.contflag
	move.l	d0,-(sp)

	moveq	#0,d0
	move.b	scoper2main_sig(a5),d1
	bset	d1,d0
	move.l	mytask(a5),a1
	jsr	Signal(a6)
	move.l	(sp)+,d0
	bra.s	.skipflag
.no_main_sig

;=== Reset (clear) a flag

	btst	d4,d0
	beq.s	.skipflag
	move.w	flag_address(a5),d1
	sf	(a5,d1.w)
	bra.s	.contflag

.skipflag

	ENDC


;=== Change channelscope spectrum mode

	btst	d2,d0
	beq.s	.nochange
	move.l	d0,-(sp)
	bsr	change_mode
	move.l	(sp)+,d0
.nochange

	btst	#15,d0			; check ctrl-f
	bne.s	.normit

	bsr	draw_channelscope

;=== Sample-Line zeichnen
;	tst.l	MTsprocStruct+wd_Wnd(a5)
;	beq.s	.nosproc
;	tst.b	sp_playmode(a5)
;	beq.s	.nosproc
;
;	bsr	.draw_sample_line
;.nosproc

	bra	.mainloop



.error	; scoperprocess(a5) remains zero


.normit
;	bsr.s	.close_timer

	move.b	chanmodesignal(a5),d0
	bmi.s	.nosig1
	jsr	FreeSignal(a6)
.nosig1

	move.b	scoper_startstop_sig(a5),d0
	bmi.s	.nosig2
	jsr	FreeSignal(a6)
.nosig2

;	move.b	scoper_resetflag_sig(a5),d0
;	jsr	FreeSignal(a6)

	bsr.s	.signal_ctrl_f	; it is done

	moveq	#0,d0
	rts


.signal_ctrl_f
	move.l	#$8000,d0
	move.l	mytask(a5),a1
	move.l	(a5),a6
	jmp	Signal(a6)






;==============================================================
;
;  Wechsel von 3D <-> HiFi
;
;==============================================================

change_mode
	lea	channellevels(a5),a0
	moveq	#15*4,d0
	moveq	#127,d1
.toploop
	move.b	d1,1(a0,d0.w)		; Velocity
	st	2(a0,d0.w)		; Trigger
	move.b	d1,3(a0,d0.w)		; Maximum-Level
	subq.w	#4,d0
	bcc.s	.toploop

	move.w	display_type(a5),current_display(a5)


	rts




;==============================================================
;
;  Channel Scope Routine
;
;==============================================================

draw_channelscope
	tst.b	chanscope_active(a5)
;	tst.l	MTchanStruct+wd_wnd(a5)
	beq	.notopen

	sf	scopebitmap_changed(a5)

	move.l	chanscopebitmap(a5),d0
	beq	.notopen
	move.l	d0,a4

	move.l	a4,a0
	jsr	get_bitmap_widthJ(a5)
	move.l	d0,d4
	moveq	#15*4,d5		; x-offset in bytes

	tst.b	cgx_bitmaps(a5)
	beq.s	.nocgx
	lea	.locktags(pc),a1
	lea	cgx_cscope_baseaddress(a5),a0
	move.l	a0,4(a1)
	move.l	a4,a0
	move.l	cgxbas(a5),a6
	jsr	LockBitMapTagList(a6)
	move.l	d0,cgx_cscope_lock(a5)
	beq	.notopen
;	lsl.l	#3,d5
;	bra.s	.ccont2
.nocgx
;.ccont2

;	move.w	#32*16/8,d4		; bytes per row
	lea	channellevels(a5),a6
	moveq	#15*4,d6		; offset zu channellevels

.channelloop
	tst.b	2(a6,d6.w)
	bne.s	.full
	move.b	(a6,d6.w),d7
	bmi.s	.next
;=== Level einen runterzeichnen
	ext.w	d7
	lea	.scopedowntab(pc),a0
	bra.s	.jsr

;=== voller Ausschlag
.full	sf	2(a6,d6.w)
	moveq	#1,d7
	add.b	3(a6,d6.w),d7		; $00-$7f (final volume)
	moveq	#1,d0
	add.b	1(a6,d6.w),d0		; $00-$7f (velocity)
	mulu	d0,d7
	lsr.w	#7,d7
	lsr.w	#2,d7			; $00-$20
	move.b	d7,(a6,d6.w)
	lea	.scopefulltab(pc),a0

.jsr	tst.b	cgx_bitmaps(a5)
	bne.s	.cgx
	move.l	8(a4),a1
	move.l	12(a4),a2
	move.l	16(a4),a3
	adda.l	d5,a1
	adda.l	d5,a2
	adda.l	d5,a3
	bra.s	.ccont
.cgx	move.l	cgx_cscope_baseaddress(a5),a1
	IFEQ	mc68020
	move.l	d5,d0
	lsl.l	#3,d0
	adda.l	d0,a1
	ELSE
	lea	(a1,d5.l*8),a1
	ENDC
.ccont

	move.w	current_display(a5),d0
	IFEQ	mc68020
	add.w	d0,d0
	adda.w	d0,a0
	adda.w	(a0),a0
	jsr	(a0)
	ELSE
	adda.w	(a0,d0.w*2),a0
	jsr	(a0,d0.w*2)
	ENDC
	subq.b	#1,(a6,d6.w)
	st	scopebitmap_changed(a5)
.next
	subq.w	#4,d5
	subq.w	#4,d6
	bcc.s	.channelloop


	move.l	cgx_cscope_lock(a5),d0
	beq.s	.nocgx2
	move.l	d0,a0
	move.l	cgxbas(a5),a6
	jsr	UnLockBitMap(a6)
	clr.l	cgx_cscope_lock(a5)
.nocgx2



	tst.b	scopebitmap_changed(a5)
	beq.s	.notopen
	sf	scopebitmap_changed(a5)

;=== Lock the semaphore (see solochannel gadget routine!)
	jsr	LockChannelscopeJ(a5)
	beq.s	.nolock

;=== blit the whole bitmap into channelscope-window's rp

;=== Set new writemask
;	move.l	MTchanStruct+wd_Wnd(a5),a1
;	move.l	$32(a1),a0
;	move.b	$18(a0),d7
;	moveq	#7,d0
;	jsr	PutWriteMaskJ(a5)

;=== source bitmap
	move.l	chanscopebitmap(a5),d0
	beq.s	.nobitmap
	move.l	d0,a0
	moveq	#0,d0
	moveq	#0,d1

;=== dest rastport
	move.l	MTchanStruct+wd_Wnd(a5),a1
	move.l	$32(a1),a1
	move.w	changad_left(a5),d2
	move.w	changad_top(a5),d3
	subq.w	#1,d2
	sub.w	#19+chanbitmap_ysize-1,d3

	move.w	#32*16,d4
	moveq	#chanbitmap_ysize,d5
	moveq	#-$40,d6		; $c0.b
	move.l	gfxbas(a5),a6
	jsr	BltBitmapRastport(a6)
.nobitmap

;=== Release the semaphore
	jsr	UnlockChannelscopeJ(a5)
.nolock

;=== Restore old writemask
;	move.l	MTchanStruct+wd_Wnd(a5),a1
;	move.l	$32(a1),a0
;	move.b	d7,d0
;	jsr	PutWriteMaskJ(a5)


.notopen
	rts



;=== d4.w=x-pos, d5.w=y-pos
;=== d7.w=maxlevel ($00-$20)
;=== a2=rp

.scopefulltab
	dr.w	scope_3d_full
	dr.w	scope_hifi_full


.scopedowntab
	dr.w	scope_3d_down
	dr.w	scope_hifi_down



.locktags
	dc.l	$84001007,0	; LBMI_BASEADDRESS
	dc.l	0




;==============================================================
;
;  3D Vollausschlag
;
;==============================================================

scope_3d_full	; d7 = level ($00-$20)

	move.w	chan_multtab+[chanbitmap_ysize-1]*2(a5),d0

	tst.b	cgx_bitmaps(a5)
	bne	.cgx

	adda.w	d0,a1
	adda.w	d0,a2
	adda.w	d0,a3


;=== Balken zeichnen
	move.l	#$03fffff0,d0
	move.l	#$0fffffc0,d1
	moveq	#0,d2

	subq.w	#2,d7		; -2,-1,$00,..,$1e
	bcc.s	.fill
	moveq	#0,d7		; $00,..,$1e
.fill	move.w	d7,d3
	bra.s	.fullin
.fullloop

	move.l	d0,(a1)
	move.l	d1,(a2)
	move.l	d2,(a3)
	suba.w	d4,a1
	suba.w	d4,a2
	suba.w	d4,a3

.fullin	subq.w	#1,d3
	bcc.s	.fullloop


;=== Obere Abdeck-Linie zeichnen (in wei)
	move.l	d2,(a1)
	move.l	#$0ffffff0,(a2)
	move.l	d2,(a3)



;=== clear gfx above level

	moveq	#chanbitmap_ysize-2,d3
	sub.w	d7,d3
	bra.s	.3din
.clrloop
	suba.w	d4,a1
	suba.w	d4,a2
	suba.w	d4,a3
	clr.l	(a1)
	clr.l	(a2)
	clr.l	(a3)
.3din	dbf	d3,.clrloop

	rts


.cgx
	adda.w	d0,a1


;=== Balken zeichnen
;	move.l	#$03fffff0,d0
;	move.l	#$0fffffc0,d1
;	moveq	#0,d2

	subq.w	#2,d7		; -2,-1,$00,..,$1e
	bcc.s	.cfill
	moveq	#0,d7		; $00,..,$1e
.cfill	move.w	d7,d3
	bra.s	.cfullin
.cfullloop

	move.l	a1,a0
	clr.l	(a0)+
	move.l	#$02020303,(a0)+
	move.l	#$03030303,(a0)+
	move.l	#$03030303,(a0)+
	move.l	#$03030303,(a0)+
	move.l	#$03030303,(a0)+
	move.l	#$03030101,(a0)+
	clr.l	(a0)+

	suba.w	d4,a1

.cfullin
	subq.w	#1,d3
	bcc.s	.cfullloop


;=== Obere Abdeck-Linie zeichnen (in wei)
;	move.l	d2,(a1)
;	move.l	#$0ffffff0,(a2)
;	move.l	d2,(a3)

	move.l	a1,a0
	clr.l	(a0)+
	move.l	#$02020202,d0
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	clr.l	(a0)+




;=== clear gfx above level

	moveq	#chanbitmap_ysize-2,d3
	sub.w	d7,d3
	bra.s	.c3din
.cclrloop
	suba.w	d4,a1
	move.l	a1,a0
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
.c3din	dbf	d3,.cclrloop

	rts




;==============================================================
;
;  3D Level-Dekrementierung
;
;==============================================================

scope_3d_down	; d7.w=currentlevel ($00-$1f)

	tst.w	d7
	beq.s	.nonew

	moveq	#chanbitmap_ysize-1,d0
	sub.w	d7,d0

	lea	chan_multtab(a5),a0
	IFEQ	mc68020
	add.w	d0,d0
	move.w	(a0,d0.w),d0
	ELSE
	move.w	(a0,d0.w*2),d0
	ENDC

	tst.b	cgx_bitmaps(a5)
	bne.s	.cgx


;=== clear top line
	clr.l	(a1,d0.w)
	clr.l	(a2,d0.w)
	clr.l	(a3,d0.w)


;=== new bright edge
	add.w	d4,d0
	clr.l	(a1,d0.w)
	move.l	#$0ffffff0,(a2,d0.w)
	clr.l	(a3,d0.w)

.nonew
	rts


.cgx
	adda.w	d0,a1

;=== clear top line
	move.l	a1,a0
	REPT	8
	clr.l	(a0)+
	ENDR


;=== new bright edge
	add.w	d4,a1
	move.l	a1,a0
	clr.l	(a0)+
	move.l	#$02020202,d0
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	clr.l	(a0)+

	rts



;==============================================================
;
;  HiFi Vollausschlag
;
;==============================================================

scope_hifi_full	; d7 = level ($00-$20)

	lea	hifidata(a5),a0
	lsr.w	#1,d7			; $00,$01,...,$10
	cmp.w	2(a0,d6.w),d7
	bmi.s	.nohold
	move.w	d7,2(a0,d6.w)
	move.w	#hifi_peak_hold,(a0,d6.w)
.nohold

	tst.b	cgx_bitmaps(a5)
	bne	.cgx

	move.w	chan_multtab+[chanbitmap_ysize-1]*2(a5),d0
	adda.w	d0,a1
	adda.w	d0,a2
	adda.w	d0,a3

	movem.l	hifi_lower_colour(a5),d0-d2

	moveq	#0,d3
	bra.s	.hifiin
.fullhifiloop

	cmp.w	#9,d3
	bne.s	.not_mid
	movem.l	hifi_mid_colour(a5),d0-d2
	bra.s	.drawhifi
.not_mid

	cmp.w	#12,d3
	bne.s	.not_upper
	movem.l	hifi_upper_colour(a5),d0-d2
.not_upper

.drawhifi
	move.l	hifi_clear_colour(a5),(a1)
	move.l	hifi_clear_colour+4(a5),(a2)
	move.l	hifi_clear_colour+8(a5),(a3)
	suba.w	d4,a1
	suba.w	d4,a2
	suba.w	d4,a3
	move.l	d0,(a1)
	move.l	d1,(a2)
	move.l	d2,(a3)
	suba.w	d4,a1
	suba.w	d4,a2
	suba.w	d4,a3

	addq.w	#1,d3
.hifiin	cmp.w	d7,d3
	bcs.s	.fullhifiloop




;=== clear gfx above level

	lea	hifidata(a5),a0
	move.w	2(a0,d6.w),d7

	movem.l	hifi_clear_colour(a5),d0-d2
	bra.s	.afterin

.afterloop

	move.l	d0,(a1)
	move.l	d1,(a2)
	move.l	d2,(a3)
	suba.w	d4,a1
	suba.w	d4,a2
	suba.w	d4,a3
	move.l	d0,(a1)
	move.l	d1,(a2)
	move.l	d2,(a3)
	suba.w	d4,a1
	suba.w	d4,a2
	suba.w	d4,a3

.afterin
	addq.w	#1,d3
	cmp.w	d7,d3
	bcs.s	.afterloop


	rts


.cgx

	adda.w	chan_multtab+[chanbitmap_ysize-1]*2(a5),a1

	move.l	hifi_clear_colour(a5),a2
	movem.l	hifi_lower_colour(a5),d0-d2

	moveq	#0,d3
	bra.s	.chifiin
.cfullhifiloop

	cmp.w	#9,d3
	bne.s	.cnot_mid
	movem.l	hifi_mid_colour(a5),d0-d2
	bra.s	.cdrawhifi
.cnot_mid

	cmp.w	#12,d3
	bne.s	.cnot_upper
	movem.l	hifi_upper_colour(a5),d0-d2
.cnot_upper

.cdrawhifi
	move.l	a1,a0
	REPT	8
	move.l	a2,(a0)+
	ENDR
	suba.w	d4,a1

	move.l	a1,a0
	move.l	a2,(a0)+
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	move.l	d1,(a0)+
	move.l	d1,(a0)+
	move.l	d1,(a0)+
	move.l	d2,(a0)+
	move.l	a2,(a0)+
	suba.w	d4,a1

	addq.w	#1,d3
.chifiin
	cmp.w	d7,d3
	bcs.s	.cfullhifiloop




;=== clear gfx above level

	lea	hifidata(a5),a0
	move.w	2(a0,d6.w),d7
	bra.s	.cafterin

.cafterloop
	move.l	a1,a0
	REPT	8
	move.l	a2,(a0)+
	ENDR
	suba.w	d4,a1

	move.l	a1,a0
	REPT	8
	move.l	a2,(a0)+
	ENDR
	suba.w	d4,a1

.cafterin
	addq.w	#1,d3
	cmp.w	d7,d3
	bcs.s	.cafterloop


	rts





;==============================================================
;
;  HiFi Level-Dekrementierung
;
;==============================================================

scope_hifi_down	; d7 = level ($00-$1f)

	lea	hifidata(a5),a0
	tst.w	(a0,d6.w)
	beq.s	.nopeak
	subq.w	#1,(a0,d6.w)
	bne.s	.nopeak

	move.w	2(a0,d6.w),d0
	beq.s	.nodraw
	add.w	d0,d0
	clr.w	2(a0,d6.w)
	lea	chan_multtab(a5),a0
	moveq	#chanbitmap_ysize,d3
	sub.w	d0,d3
	IFEQ	mc68020
	add.w	d3,d3
	move.w	(a0,d3.w),d3
	ELSE
	move.w	(a0,d3.w*2),d3
	ENDC

	tst.b	cgx_bitmaps(a5)
	bne.s	.cgx1
	movem.l	hifi_clear_colour(a5),d0-d2
	move.l	d0,(a1,d3.w)
	move.l	d1,(a2,d3.w)
	move.l	d2,(a3,d3.w)
	bra.s	.nodraw
.cgx1	lea	(a1,d3.w),a0
	move.l	hifi_clear_colour(a5),d0
	REPT	8
	move.l	d0,(a0)+
	ENDR
.nodraw

	cmp.b	#$7e,d7
	bne.s	.nopeak
	clr.b	(a6,d6.w)
	bra.s	.skip
.nopeak

	tst.b	d7
	bne.s	.notop
	move.b	#$7f,(a6,d6.w)
.notop
	cmp.b	#$7e,d7
	bne.s	.notop2
	addq.b	#1,(a6,d6.w)
	bra.s	.skip
.notop2


	lsr.w	#1,d7
	bcs.s	.skip

	addq.w	#1,d7
	lea	hifidata(a5),a0
	cmp.w	2(a0,d6.w),d7
	beq.s	.skip

	add.w	d7,d7
	lea	chan_multtab(a5),a0
	moveq	#chanbitmap_ysize,d3
	sub.w	d7,d3
	IFEQ	mc68020
	add.w	d3,d3
	move.w	(a0,d3.w),d3
	ELSE
	move.w	(a0,d3.w*2),d3
	ENDC

	tst.b	cgx_bitmaps(a5)
	bne.s	.cgx2
	movem.l	hifi_clear_colour(a5),d0-d2
	move.l	d0,(a1,d3.w)
	move.l	d1,(a2,d3.w)
	move.l	d2,(a3,d3.w)
	bra.s	.skip
.cgx2	lea	(a1,d3.w),a0
	move.l	hifi_clear_colour(a5),d0
	REPT	8
	move.l	d0,(a0)+
	ENDR
.skip
	rts


