;APS00000000000000000000000000000000000000000000000000000000000000000000000000000000
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;
;
;
;
;          Q U A D R A S Y N T H    -    D I A L O G
;
;
;
;
;
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================


quadra_test	equ 0	; 1 = file von platte laden, 0 = dump anfordern


quadra_dialog
	move.l	MTquadraStruct+wd_Wnd(a5),d0
	bne.s	.window_activation

;=== Fenster ffnen
	lea	MTquadraStruct(a5),a4
	bsr.s	.Refreshquadra
	jsr	OpenWDJ(a5)
	bne.s	.norm

	POSITIV
.norm	NEGATIV

.window_activation
	jmp	window_activationJ(a5)


.Refreshquadra
	move.l	MTquadraStruct+wd_GTags(a5),a0

	move.l	quadraprograms(a5),d0
	bne.s	.progs
	moveq	#-1,d0
	bra.s	.setlv
.progs	lea	quadrainitlist(a5),a1
	move.l	a1,d0
.setlv	move.l	d0,MTquadraGTlist(a0)

	rts





quadraIDCMP
	dc.w	.count-1
	dc.l	$00000004
	dr.l	window_refresh
	dc.l	$00000040
	dr.l	quadragadgetup
	dc.l	$00000100
	dr.l	mainmenupick
	dc.l	$00000200
	dr.l	quadrawdclosegad
	dc.l	$00000400
	dr.l	mainrawkey
	dc.l	$00400000
	dr.l	Generalintuiticks
	dc.l	$04000000
	dr.l	quadragadgethelp
.count = (*-quadraIDCMP-2)/8



;==============================================================
;
;  WINDOWCLOSE Event
;
;==============================================================

quadrawdclosegad
quadrawdclose
	lea	MTquadraStruct(a5),a4
	jmp	CloseWDJ(a5)



;==============================================================
;
;  GADGETHELP Event
;
;==============================================================

quadragadgethelp
;	lea	.helpoffsets(pc),a0
	lea	.loc_helpoffsets(pc),a1
	lea	MTquadraStruct(a5),a2
	jmp	gadgethelpJ(a5)


;.helpoffsets
;	dr.l	k2k_instrH
;	dr.l	k2k_refreshH


.loc_helpoffsets
	dc.w	loc_k2k_instrH
	dc.w	loc_k2k_refreshH


;==============================================================
;
;  GADGETUP + GADGETDOWN Event
;
;==============================================================

quadragadgetup
	lea	.quadraGadgetTab(pc),a0
	jmp	gadgetjsrJ(a5)

.quadraGadgetTab
	dr.w	quadra_instrument
	dr.w	quadra_refresh
;	dr.w	load_dumpfile
;	dr.w	quadra_startobject
;	dr.w	quadra_stopobject
;	dr.w	save_mixes
;	dr.w	save_singles





quadra_instrument
	bsr	GetListviewquadra
	bra	insert_instrument	; see k2000-includefile





quadraserbufsize = 128*408+1	; plus one nullbyte

quadra_refresh
	tst.b	playflag(a5)
	bne	.no_refresh


	bsr	AllocQuadraBuffer
	beq	.nomem


;=== make windowtitle
	move.w	#loc_readbanks,d0
	jsr	getcatstringJ(a5)
	bsr	set_wdtitle_quadra

	bsr	quadraBusyPointer


	IFEQ	quadra_test


	bsr	read_quadra_presets
	beq.s	.timeout


	ELSE


	move.l	#.quadra_file,d1
	move.l	#1005,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d7
	beq.s	.timeout
	move.l	d7,d1
	move.l	sysex_serbuf(a5),d2
	move.l	#128*408,d3
	move.l	d2,a0
	clr.b	(a0,d3.l)
	jsr	Read(a6)
	move.l	d7,d1
	jsr	Close(a6)
	bra.s	.doit

.quadra_file
	dc.b	'sys:miditracker/quadra-programs',0
	even

.doit

	ENDC


	bsr.s	.process_buffer

.done	bra	quadra_ready

.no_refresh
	rts


.nomem	jmp	nomemoryJ(a5)

.timeout
	bsr	sysex_timeout
	bra.s	.done





.process_buffer

		rsreset
.quad_node	rs.b	$e	; node
.quad_number	rs.b	3	; ascii-number of preset
.quad_name	rs.b	11	; namestring, including 0-byte
.quad_sizeof	rs.b	0



;=== detach listview
	moveq	#GD_quadrainstr,d1
	bsr	ResetListviewQuadra


	move.l	#128*.quad_sizeof+1,d0	; for 128 singles
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq	.neg
	move.l	d0,-(sp)
	move.l	d0,a0

	lea	-$c(sp),sp

	move.l	sysex_serbuf(a5),a3
;	tst.l	(a2)
;	bne.s	.atleastone
;	clr.l	(sp)
;	clr.l	4(sp)
;	clr.l	8(sp)
;	bra	.veryempty
;.atleastone

;==================================
.fillloop
	tst.b	(a3)
	beq	.lastprog

	lea	.quad_sizeof(a0),a1		; ^next
	move.l	a1,(a0)
	lea	-.quad_sizeof(a0),a1		; ^prev
	move.l	a1,4(a0)
	lea	.quad_number(a0),a1		; ^name of list-entry
	move.l	a1,$a(a0)


;=== copy preset-name
	lea	quadraname(a5),a1
	lea	8(a3),a4
	moveq	#10-1,d0
	moveq	#1,d2
	moveq	#6,d5
.nameloop
	move.b	(a4)+,d1
	move.b	(a4),d3
	lsr.b	d2,d1
	lsl.b	d5,d3
	add.b	d3,d1
	move.b	d1,(a1)+

	addq.w	#1,d2
	subq.w	#1,d5
	bne.s	.noskip
	addq.w	#1,a4
	addq.w	#1,d2
	subq.w	#1,d5
.noskip
	and.w	#7,d2
	and.w	#7,d5

	dbf	d0,.nameloop

	lea	.quad_name(a0),a1
	move.b	#' ',(a1)+		; separate number from name with a space
	lea	quadraname(a5),a4
	moveq	#10-1,d0
	moveq	#1,d2
	moveq	#7,d5
.packedloop
	move.b	(a4)+,d1
	addq.w	#1,d5
	subq.w	#1,d2
	and.w	#7,d5
	and.w	#7,d2
	bne.s	.noskip2
	subq.w	#1,a4
	and.b	#$7f,d1
	bra.s	.skipit
.noskip2

	move.b	(a4),d3
	lsr.b	d2,d1
	lsl.b	d5,d3
	and.b	#$7f,d3
	add.b	d3,d1
.skipit
	add.b	#$20,d1
	move.b	d1,(a1)+

	dbf	d0,.packedloop
	clr.b	(a1)

	movem.l	a0/a3,-(sp)
	lea	.quad_number(a0),a0
	moveq	#0,d0
	move.b	6(a3),d0
	moveq	#2,d1
	bsr	decout_nolead
	movem.l	(sp)+,a0/a3

	lea	.quad_sizeof(a0),a0
	lea	408(a3),a3
	bra	.fillloop

;=======================================


.lastprog


;=== init last listentry
	lea	-.quad_sizeof(a0),a0
	move.l	a0,8(sp)
	lea	quadrainitlist+4(a5),a1
	move.l	a1,(a0)


;=== init first listentry
	move.l	$c(sp),a0
	move.l	a0,(sp)
	clr.l	4(sp)
	lea	quadrainitlist(a5),a1
	move.l	a1,4(a0)


;.veryempty
	movem.l	(sp)+,d0-d2
	lea	quadrainitlist(a5),a0
	movem.l	d0-d2,(a0)
	moveq	#0,d0
	moveq	#GD_quadrainstr,d1
	bsr	SetListviewquadra


	move.l	quadraprograms(a5),a1
	jsr	MyFreeVecJ(a5)
	move.l	(sp)+,quadraprograms(a5)

	POSITIV

.neg	NEGATIV



quadra_ready
	bsr.s	FreeQuadraBuffer
	lea	MTquadraWtitle(pc),a1
	bsr	set_wdtitle_quadra
	bra	quadraActivePointer




;=== Allocate serial input buffer
AllocQuadraBuffer
	move.l	#quadraserbufsize,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,sysex_serbuf(a5)
	rts



FreeQuadraBuffer
	lea	sysex_serbuf(a5),a0
	jmp	MyFreeVectorJ(a5)





;==============================================================
;
;  Object to start with
;
;==============================================================

	IFEQ	1

quadra_startobject
	bsr	GetIntegerQuadra

	moveq	#127,d1
	cmp.l	d1,d0
	bls.s	.ok
	move.b	d1,quadrafrom(a5)
	move.l	d1,d0
	moveq	#GD_quadrafrom,d1
	bsr	SetIntegerQuadra
	move.b	quadrafrom(a5),d0
.ok
	move.b	d0,quadrafrom(a5)
	cmp.b	quadrato(a5),d0
	bhi.s	swap_from_and_to
	rts


;=== swap to and from values
swap_from_and_to
	moveq	#0,d0
	move.b	quadrato(a5),d0
	move.b	quadrafrom(a5),quadrato(a5)
	move.b	d0,quadrafrom(a5)
	moveq	#GD_quadrafrom,d1
	bsr	SetIntegerQuadra
	moveq	#0,d0
	move.b	quadrato(a5),d0
	moveq	#GD_quadrato,d1
	bra	SetIntegerQuadra



;==============================================================
;
;  Object to stop at
;
;==============================================================

quadra_stopobject
	bsr	GetIntegerQuadra

	moveq	#127,d1
	cmp.l	d1,d0
	bls.s	.ok
	move.b	d1,quadrato(a5)
	move.l	d1,d0
	moveq	#GD_quadrato,d1
	bsr	SetIntegerQuadra
	move.b	quadrato(a5),d0
.ok
	move.b	d0,quadrato(a5)
	cmp.b	quadrafrom(a5),d0
	bcs.s	swap_from_and_to
	rts





;==============================================================
;
;  load mixes or singles
;
;==============================================================

load_dumpfile

	lea	rt_loaddump_struct(pc),a4
	bsr	FileRequester
	beq.s	.cancel

;=== load the dumpfile
	lea	rt_quadra_name(a5),a2
	lea	quadrafile(a5),a3
	bsr	loadfile_public
	beq.s	.cantload

	lea	loading_dumpfile(pc),a1
	move.w	#loc_loadingdump,d0
	jsr	getcatstringJ(a5)	; set the window's title
	bsr	set_wdtitle_quadra	; to something meaningful

	move.l	(a3),a0			; make some check to be sure we don't
	lea	quadrasave_head(pc),a1	; send crap to the quadrasynth
	cmpm.l	(a1)+,(a0)+		;
	bne.s	.no_dumpfile		;
	cmpm.l	(a1)+,(a0)+		;
	bne.s	.no_dumpfile		;

	tst.b	playflag(a5)		; stop replay
	beq.s	.stoped			;
	bsr	stop_routine		;
.stoped

	lea	dumping_file(pc),a1
	move.w	#loc_dumpingfile,d0
	jsr	getcatstringJ(a5)	; set the window's title
	bsr	set_wdtitle_quadra	; to something meaningful


	bsr	QuadraBusyPointer


;=== dump it to Midi
	movem.l	quadrafile(a5),d1/a1
	exg	d1,a1
	addq.w	#8,a1			; skip Miditracker's header
	subq.l	#8,d1
	jsr	send_streamJ(a5)



	lea	quadrafile(a5),a3
	bsr	unloadfile
	bra	quadra_ready

.rts	rts

.cancel	bra	load_cancelled


.cantload
	bsr.s	cannot_load_file
.title	lea	MTquadraWtitle(pc),a1
	bra	set_wdtitle_quadra


.no_dumpfile
	bsr	unloadfile
	lea	nodumpfile_body(pc),a1
	lea	letmesee_gadfmt(pc),a2
	move.w	#loc_nodumpfile,d0
	move.w	#loc_letmesee,d1
	bsr	EZrequest
	bra.s	.title


cannot_load_file
	lea	cannotload_body(pc),a1
	move.l	ohno_gadfmtD(a5),a2
	move.w	#loc_cannotload,d0
	move.w	#loc_ohno,d1
	bra	EZrequest






rt_loaddump_struct
	dc.w	rt_quadra_fr
	dc.w	MTquadraStruct
	dr.w	rt_quadra_pat
	dr.w	loaddump_title
	dc.w	loc_loadingdump
	dc.w	rt_quadra_name
	dc.w	rt_quadra_path
	dc.l	rt_load_flags


rt_savemixes_struct
	dc.w	rt_quadra_fr
	dc.w	MTquadraStruct
	dr.w	rt_mix_pat
	dr.w	savemix_title
	dc.w	loc_savingmix
	dc.w	rt_quadra_name
	dc.w	rt_quadra_path
	dc.l	rt_save_flags


rt_savesingles_struct
	dc.w	rt_quadra_fr
	dc.w	MTquadraStruct
	dr.w	rt_single_pat
	dr.w	savesingle_title
	dc.w	loc_savingsing
	dc.w	rt_quadra_name
	dc.w	rt_quadra_path
	dc.l	rt_save_flags


loaddump_title	dc.b	'Load quadrasynth dumpfile',0
savemix_title	dc.b	'Save mixes-dumpfile',0
savesingle_title dc.b	'Save singles-dumpfile',0
rt_quadra_pat	dc.b	'#?.(mixes|singles)',0
rt_mix_pat	dc.b	'#?.mixes',0
rt_single_pat	dc.b	'#?.singles',0

loading_dumpfile dc.b	'Loading dumpfile...',0
saving_mixes	dc.b	'Saving mixes...',0
saving_singles	dc.b	'Saving singles...',0
dumping_file	dc.b	'Dumping file...',0

nodumpfile_body	dc.b	'This file is not a Quadrasynth dumpfile.',0
cannotload_body	dc.b	'Cannot load this file',0
cannotsave_body	dc.b	'Cannot save to this file',0
number2high_body dc.b	'Selected values are not valid for saving',10
		dc.b	'mixes. A range from 0 to 99 is possible.',0

quadrasave_head	dc.b	'MTQUADRA'

		even





;==============================================================
;
;  save mixes
;
;==============================================================

save_mixes
	tst.b	dumping(a5)
	bne.s	.rts

	cmp.b	#99,quadrato(a5)
	bhi	.number_too_high

	lea	rt_savemixes_struct(pc),a4
	bsr	FileRequester
	beq.s	.cancel


;	tst.b	playflag(a5)
;	beq.s	.stoped
	bsr	stop_routine
;.stoped

	bsr	AllocQuadraBuffer	; allocate serial buffer
	beq.s	.nomem

	bsr	quadraBusyPointer

	lea	saving_mixes(pc),a1
	move.w	#loc_savingmix,d0
	jsr	getcatstringJ(a5)	; set the window's title
	bsr	set_wdtitle_quadra	; to something meaningful

	bsr	ReadQuadraMixes
	beq.s	.timeout


;=== Now we are going to save all income sysex to disk

	lea	rt_quadra_name(a5),a0
	move.l	a0,d1
	move.l	#1006,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d1
	beq.s	.cantsave
	move.l	d1,-(sp)

	lea	quadrasave_head(pc),a0		; save header text
	move.l	a0,d2
	moveq	#8,d3
	jsr	Write(a6)
	tst.l	d0
	bmi.s	.write_error

	move.l	(sp),d1
	bsr.s	save_quadra_sysex
	beq.s	.write_error

	move.l	(sp)+,d1
	jsr	Close(a6)

.done	bra	quadra_ready

.rts	rts

.cancel	bra	save_cancelled

.number_too_high
	lea	number2high_body(pc),a1
	lea	alright_gadfmt(pc),a2
	move.w	#loc_number2high,d0
	move.w	#loc_alright,d1
	bra	EZrequest


.write_error
	move.l	(sp)+,d1
	jsr	Close(a6)
.cantsave
	bsr.s	cannot_save_file
	bra.s	.done

.nomem	jmp	nomemoryJ(a5)

.timeout
	bsr	sysex_timeout
	bra.s	.done





save_quadra_sysex	; d1=fh
	move.l	sysex_serbuf(a5),a0
	move.l	a0,d2

;=== find the end of our sysex stream
.eoxloop
	cmp.b	#$f7,(a0)+
	bne.s	.eoxloop
	tst.b	(a0)+
	bne.s	.eoxloop
	subq.w	#1,a0

	move.l	a0,d3
	sub.l	d2,d3
	jsr	Write(a6)
	tst.l	d0
	bmi.s	.neg

	POSITIV
.neg	NEGATIV





cannot_save_file
	lea	cannotsave_body(pc),a1
	move.l	ohno_gadfmtD(a5),a2
	move.w	#loc_cannotsave,d0
	move.w	#loc_ohno,d1
	bra	EZrequest






;==============================================================
;
;  save singles
;
;==============================================================

save_singles
	tst.b	dumping(a5)
	bne.s	.rts

	lea	rt_savesingles_struct(pc),a4
	bsr	FileRequester
	beq.s	.cancel


;	tst.b	playflag(a5)
;	beq.s	.stoped
	bsr	stop_routine
;.stoped

	bsr	AllocQuadraBuffer	; allocate serial buffer
	beq.s	.nomem

	bsr	QuadraBusyPointer

	lea	saving_singles(pc),a1
	move.w	#loc_savingsing,d0
	jsr	getcatstringJ(a5)	; set the window's title
	bsr	set_wdtitle_quadra	; to something meaningful

	bsr	ReadQuadraSingles
	beq.s	.timeout


;=== Now we are going to save all income sysex to disk

	lea	rt_quadra_name(a5),a0
	move.l	a0,d1
	move.l	#1006,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d1
	beq.s	.cantsave
	move.l	d1,-(sp)

	lea	quadrasave_head(pc),a0		; save header text
	move.l	a0,d2
	moveq	#8,d3
	jsr	Write(a6)
	tst.l	d0
	bmi.s	.write_error


	move.l	(sp),d1
	bsr	save_quadra_sysex
	beq.s	.write_error

	move.l	(sp)+,d1
	jsr	Close(a6)

.done	bra	quadra_ready

.rts	rts

.cancel	bra	save_cancelled


.write_error
	move.l	(sp)+,d1
	jsr	Close(a6)
.cantsave
	bsr	cannot_save_file
	bra.s	.done

.nomem	jmp	nomemoryJ(a5)

.timeout
	bsr	sysex_timeout
	bra.s	.done






;==============================================================
;
;  Retrieve all Mixes from the Quadrasynth in a specified range
;
;==============================================================

ReadQuadraMixes
	moveq	#1,d0
	bra.s	QuadraFromTo



;==============================================================
;
;  Retrieve all Singles from the Quadrasynth in a specified range
;
;==============================================================

ReadQuadraSingles
	moveq	#0,d0
QuadraFromTo
	move.b	quadrafrom(a5),d1
	move.b	quadrato(a5),d2
	bra.s	ReadQuadraDump


	ENDC





	IFNE	keyfile_active

decode_number_of_bits
	lea	20(a5),a0
	move.l	keybas-20(a0),d0
	beq.s	.nokey

	move.l	checksums_start(a5),a0
	move.w	number_of_bits_checksum(a0),d2
	move.l	keycode_start(a5),a0
	moveq	#0,d4
	moveq	#keycode_length/4-1,d0
.outerloop
	move.l	(a0)+,d3
	moveq	#31,d1
.innerloop
	move.b	d3,d4
	lsr.l	#1,d3
	subx.l	d4,d2
	dbf	d1,.innerloop
	dbf	d0,.outerloop
	jmp	word_checksum_testJ(a5)
.nokey	rts

	ENDC





;==============================================================
;
;  Retrieve all programs from the Quadrasynth
;
;==============================================================


read_quadra_presets
	moveq	#0,d0
	moveq	#0,d1
	moveq	#127,d2
;	bra.s	ReadQuadraDump



ReadQuadraDump	; d0.b=type (1=mixes, 0=singles)
		; d1.b=from-number, d2.b=to-number
		; returns: pos=successful, neg=timeout

	movem.l	d0-d2,-(sp)

	move.l	sysex_serbuf(a5),a3
	moveq	#0,d6			; puffer-offset in bytes
	move.l	4(sp),d7		; start-#
.programloop

	lea	.quadradump_request(pc),a1
	move.b	d7,6(a1)
	tst.l	(sp)
	bne.s	.sing1
	move.b	#1,5(a1)
	bra.s	.cont1
.sing1	move.b	#5,5(a1)
.cont1
	moveq	#.quadradump_sizeof,d1
	jsr	send_stream_mainJ(a5)

.readloop
	jsr	BeginTimer2secsJ(a5)

	jsr	WaitTimerAndSerialJ(a5)
	beq	.timerbit

	jsr	AbortTimerJ(a5)


.getmidiloop
	jsr	get_next_midimsgJ(a5)
	beq.s	.readloop

	cmp.b	#$f0,(a2)
	bne.s	.reloop

	tst.l	(sp)
	bne.s	.sing2
	moveq	#0,d4
	bra.s	.cont2
.sing2	moveq	#4,d4
.cont2	cmp.b	5(a2),d4
	bne.s	.reloop

	cmp.b	6(a2),d7
	bne.s	.reloop

	subq.w	#1,d1
.copyloop
	move.b	(a2)+,(a3)+
	dbf	d1,.copyloop

	addq.l	#1,d7
	cmp.l	8(sp),d7
	bhi.s	.outloop

.reloop	jsr	free_last_midimsgJ(a5)
	bra.s	.getmidiloop

.outloop
	jsr	free_last_midimsgJ(a5)

	clr.b	(a3)			; zero byte = end of stream

	movem.l	(sp)+,d0-d2
	POSITIV


.timerbit	; timeout (synthe has been turned off ???)
	movem.l	(sp)+,d0-d2
	NEGATIV





.quadradump_request	dc.b	$f0,$00,$00,$0e,$0e,1,0,$f7
.quadradump_sizeof = *-.quadradump_request
			even








;===================================================================

		rsreset
GD_quadrainstr	rs.b	1
GD_quadrafresh	rs.b	1

MTquadra_CNT	rs.b	1


MTquadraNGads
	NEWGAD	3,20,148,120,*,-1,GD_quadrainstr,$0000
	NEWGAD	40,2,77,16,*,loc_k2krefresh,GD_quadrafresh,$0010



MTquadraGTags
MTquadraGTlist = *+4-MTquadraGTags
	DC.L	$80080006,0
	DC.L	$80080008,24
	dc.l	$8008004f,9			; GTLV_ItemHeight
	DC.L	$00000000
	DC.L	$00000000



MTquadraGTypes	DC.b	4,1 ;,1,3,3,1,1


MTquadraWTitle	DC.B	'Quadrasynth',0

		even




MTquadraWindowTags
	DC.L	$80000064,0
	DC.L	$80000065,0
	DC.L	$80000066,0
	DC.L	$80000067,0
	DC.L	$8000006B,quadraWFlags
MTquadraWG = *+4-MTquadraWindowTags
	DC.L	$8000006C,0
MTquadraWT = *+4-MTquadraWindowTags
	DC.L	$8000006E,MTquadraWTitle
MTquadraST = *+4-MTquadraWindowTags
	DC.L	$8000006F,0
MTquadraSC = *+4-MTquadraWindowTags
	DC.L	$80000079,0
	DC.L	$80000090,1
MTquadraHG = *+4-MTquadraWindowTags
	dc.l	$8000009b,0		; Help Group (V39)
	DC.L	$00000000

