;APS00004AA100008DE100008E4100000000000000000000000000000000000000000000000000000000
;==============================================================
;
;  playerprocess.s
;
;==============================================================


playerprocess_Start

	lea	varbase,a5

	st	shutdown_player_sig(a5)
	st	playsignal(a5)
	st	stopsignal(a5)
	st	cia_trigger_sig(a5)

	moveq	#-1,d0
	move.l	(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,shutdown_player_sig(a5)
	bmi	.normit

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,playsignal(a5)
	bmi	.normit

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,stopsignal(a5)
	bmi	.normit

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,cia_trigger_sig(a5)
	bmi	.normit


	jsr	CreateMsgPort(a6)
	move.l	d0,midi_replyport_player(a5)
	beq	.normit

	jsr	CreateMsgPort(a6)
	move.l	d0,midiin_port_player(a5)
	beq	.normit

	jsr	CreateMsgPort(a6)
	move.l	d0,todo_replyport_player(a5)
	beq	.normit


	bsr	.OpenTimer
	beq	.normit


	suba.l	a1,a1
	jsr	FindTask(a6)
	move.l	d0,playerprocess(a5)


	jsr	signal2mainJ(a5)


.mainloop
	moveq	#0,d0

	move.b	shutdown_player_sig(a5),d1
	bset	d1,d0

	move.b	playsignal(a5),d2
	bset	d2,d0

	move.l	midiin_port_player(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0

	move.l	todo_replyport_player(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0

	move.l	(a5),a6
	jsr	Wait(a6)

	move.l	midiin_port_player(a5),a0
	move.b	$f(a0),d1
	btst	d1,d0
	beq.s	.noinmsg
	move.l	d0,-(sp)
	bsr	.handle_incoming_midi
	move.l	(sp)+,d0
.noinmsg

	move.l	todo_replyport_player(a5),a0
	move.b	$f(a0),d1
	btst	d1,d0
	beq.s	.notodomsg
	move.l	d0,-(sp)
	bsr	todo_reply_player
	move.l	(sp)+,d0
.notodomsg

	btst	d2,d0
	beq.s	.nosig
	bsr	.do_replay
	bra.s	.mainloop
.nosig

	move.b	shutdown_player_sig(a5),d1
	btst	d1,d0
	beq	.mainloop



.normit

	bsr	.CloseTimer

	move.l	(a5),a6

	move.b	stopsignal(a5),d0
	bmi.s	.nosig1
	jsr	FreeSignal(a6)
.nosig1

	move.b	playsignal(a5),d0
	bmi.s	.nosig2
	jsr	FreeSignal(a6)
.nosig2

	move.l	midi_replyport_player(a5),d0
	beq.s	.noport
;	bsr	playerprocess_reply
;	move.l	midi_replyport_player(a5),a0
	move.l	d0,a0
	clr.l	midi_replyport_player(a5)
	jsr	DeleteMsgPort(a6)
.noport

	move.l	midiin_port_player(a5),d0
	beq.s	.noport2
;	bsr	playerprocess_reply
;	move.l	midi_replyport_player(a5),a0
	move.l	d0,a0
	clr.l	midiin_port_player(a5)
	jsr	DeleteMsgPort(a6)
.noport2

	move.l	todo_replyport_player(a5),d0
	beq.s	.noport3
	bsr	todo_reply_player
	move.l	todo_replyport_player(a5),a0
	jsr	DeleteMsgPort(a6)
.noport3

	move.b	cia_trigger_sig(a5),d0
	bmi.s	.nosig4
	jsr	FreeSignal(a6)
.nosig4

	move.b	shutdown_player_sig(a5),d0
	bmi.s	.nosig3
	jsr	FreeSignal(a6)
.nosig3

	jsr	signal2mainJ(a5)

	moveq	#0,d0
	rts




.OpenTimer
	lea	PlayerTimerReply(a5),a0
	lea	PlayerTimerIO(a5),a1
	jmp	OpenTimer_routineJ(a5)

.CloseTimer
	lea	PlayerTimerReply(a5),a0
	lea	PlayerTimerIO(a5),a1
	jmp	CloseTimer_routineJ(a5)




.handle_incoming_midi
	move.l	(a5),a6
	bra.s	.injin
.incomingloop
	move.l	d0,a1
	jsr	ReplyMsg(a6)
.injin	move.l	midiin_port_player(a5),a0
	jsr	GetMsg(a6)
	tst.l	d0
	bne.s	.incomingloop
	rts




.do_replay

	moveq	#0,d1
	move.b	stopsignal(a5),d2
	bset	d2,d1
	move.b	cia_trigger_sig(a5),d2
	bset	d2,d1
	moveq	#0,d0
	move.l	(a5),a6
	jsr	SetSignal(a6)

	st	mtc_frameflag(a5)	; initialize midi time code frame

	bsr	put_main_replysig

.replay_loop

	bsr	check_external_clock
	bne.s	.external

	move.l	(a5),a6
	move.b	stopsignal(a5),d2

;	move.l	cia_trigger_count(a5),d0
;	bne.s	.is_triggered

	moveq	#0,d0
	move.b	cia_trigger_sig(a5),d1
	bset	d1,d0
	bset	d2,d0
	jsr	Wait(a6)

;	bra.s	.checksigs

;.is_triggered

;	moveq	#0,d1
;	bset	d2,d1
;	moveq	#0,d0
;	jsr	SetSignal(a6)

;.checksigs

	move.b	stopsignal(a5),d2
	btst	d2,d0
	bne	.userstop

	bsr	.midi_recorder
	beq.s	.autostop


;.triggercont
;	subq.l	#1,cia_trigger_count(a5)

	bra.s	.replay_cont

.external

.extloop

	moveq	#0,d0

	move.l	midiin_port_player(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0

	move.b	stopsignal(a5),d2
	bset	d2,d0

	move.l	(a5),a6
	jsr	Wait(a6)

	btst	d2,d0
	bne.s	.userstop_flush

	bsr.s	.make_external_clock
	beq.s	.autostop
	bpl.s	.extloop

; clock received


.replay_cont

	bsr	createmidi
	beq.s	.autostop

	bsr.s	.replay_playoutput


;.replay_out

;	tst.b	playflag(a5)
	bra	.replay_loop

.userstop
	bra	put_main_replysig


.userstop_flush
	bra.s	.fjin
.flushloop
	move.l	d0,a1
	jsr	ReplyMsg(a6)
.fjin	move.l	midiin_port_player(a5),a0
	jsr	GetMsg(a6)
	tst.l	d0
	bne.s	.flushloop
	bra.s	.userstop


.autostop
	st	autostopped(a5)
	moveq	#TODO_stop_button,d0
	bsr	main_todo_from_player
	bra.s	.userstop_flush



.replay_playoutput
	tst.b	metromusic(a5)
	beq.s	.noout

;	jsr	GetChannelResolutionJ(a5)
;	move.l	playpos(a5),d1
;	divu	d0,d1
;	swap	d1
;	tst.w	d1
;	bne.s	.noout

	move.l	playpos(a5),eventpos(a5)

	moveq	#0,d0
	move.b	replayoutput_sig(a5),d1
	bset	d1,d0
	move.l	mytask(a5),a1
	move.l	(a5),a6
	jmp	Signal(a6)

.noout	rts




.make_external_clock	; returns: -1 = clock received, 0 = buffer full (autostop), 1 else

	move.l	recbuf(a5),a3
	move.l	recbufpos(a5),d7
	adda.l	d7,a3

.inloop
	move.l	midiin_port_player(a5),a0
	move.l	(a5),a6
	jsr	GetMsg(a6)
	tst.l	d0
	beq	.nomore

	move.l	d0,a1

;	move.l	player_mdest(a5),a0
;	move.l	midibas(a5),a6
;	jsr	GetMidiPacket(a6)
;	tst.l	d0
;	beq.s	.nomore
;	move.l	d0,a0

;	move.w	$16(a0),d0
;	add.w	d0,current_activity_rec(a5)

;	lea	$1c(a0),a1
;	cmp.b	#$f8,(a1)
;	bne.s	.int
;	jsr	FreeMidiPacket(a6)
;	moveq	#-1,d0
;	bra.s	.cont
;.int


	cmp.b	#$f8,sp_status(a1)
	beq.s	.clock


	tst.b	playflag(a5)
	ble.s	.skipmsg


	tst.b	metromusic(a5)
	beq.s	.skipmsg

	lea	sp_status(a1),a0
	cmp.b	#$f0,(a0)
	bcc.s	.skipmsg

	move.l	sp_bodylength(a0),d0
	add.l	d0,d7
	cmp.l	recbufsizebytes(a5),d7
	bcc.s	.full

.copy	move.b	(a0)+,(a3)+
	subq.l	#1,d0
	bne.s	.copy
.skipmsg

	jsr	ReplyMsg(a6)
	bra.s	.inloop

.full
	jsr	ReplyMsg(a6)

.overflow
	moveq	#0,d0
	rts

.clock	jsr	ReplyMsg(a6)
	moveq	#-1,d0
	bra.s	.cont
.nomore
	moveq	#1,d0

.cont
	tst.b	playflag(a5)
	bmi.s	.noclock

; check audition mode: if pattern is in audition pass, don't write clocks
	tst.w	audpasses_togo(a5)
	bne.s	.noclock

	tst.b	metromusic(a5)
	beq.s	.noclock

	addq.l	#1,d7
	cmp.l	recbufsizebytes(a5),d7
	bcc.s	.overflow
	move.b	#$f8,(a3)+
.noclock

	move.l	d7,recbufpos(a5)
	tst.l	d0
	rts






.midi_recorder
	tst.b	playflag(a5)
	ble.s	.playing

	move.l	recbuf(a5),a3
	move.l	recbufpos(a5),d7
	adda.l	d7,a3

	move.l	(a5),a6
	bra.s	.midjin

.inloop2
	move.l	d0,a1

	tst.b	metromusic(a5)
	beq.s	.skipmsg2

	lea	sp_status(a1),a0
	cmp.b	#$f0,(a0)
	bcc.s	.skipmsg2

	move.l	sp_bodylength(a1),d0
	add.l	d0,d7
	cmp.l	recbufsizebytes(a5),d7
	bcc.s	.full2

.copy2	move.b	(a0)+,(a3)+
	subq.l	#1,d0
	bne.s	.copy2
.skipmsg2

	move.l	d7,recbufpos(a5)

	jsr	ReplyMsg(a6)

.midjin	move.l	midiin_port_player(a5),a0
	jsr	GetMsg(a6)
	tst.l	d0
	bne.s	.inloop2




; check audition mode: if pattern is in audition pass, don't write clocks
	tst.w	audpasses_togo(a5)
	bne.s	.noclock2

	tst.b	metromusic(a5)
	beq.s	.noclock2

	addq.l	#1,d7
	cmp.l	recbufsizebytes(a5),d7
	bcc.s	.overflow2
	move.b	#$f8,(a3)+
	move.l	d7,recbufpos(a5)
.noclock2

.playing
	POSITIV


.full2	jsr	ReplyMsg(a6)
.overflow2
	NEGATIV





	IFEQ	1

send_samples_msg	; a2 = midimsg

	tst.b	samples_active(a5)
	beq.s	.nosamples
	move.l	msource(a5),d0
	beq.s	.nosamples
	move.l	d0,a0
	move.l	a2,a1
	move.b	(a1),d0
	lsr.b	#4,d0
	cmp.b	#9,d0
	beq.s	.put
	cmp.b	#8,d0
	bne.s	.nosamples
.put	move.l	midibas(a5),a6
	jmp	PutMidiMsg(a6)
.nosamples

	rts


send_samples_stream	; a2 = midistream, d2 = length

	tst.b	samples_active(a5)
	beq.s	.nosamples
	move.l	msource(a5),d0
	beq.s	.nosamples
	move.l	d0,a0
	move.l	d2,d1
	move.l	d1,d0
	suba.l	a1,a1
	move.l	midibas(a5),a6
	jmp	PutMidiStream(a6)
.nosamples

	rts


	ENDC







;=== this routine initializes the cia timer interrupt

InitCIA		; d0=playflag which is to be setup

	tst.b	d0
	bmi.s	.playmode

	tst.b	record_extclock(a5)
	bne.s	.noirq
	bra.s	.go

.playmode
	tst.b	play_extclock(a5)
	bne.s	.noirq


.go

;=== set interrupt code
	lea	cia_irq(pc),a1
	IFEQ	use_timer_b
	moveq	#0,d0			; Timer A
	ELSE
	moveq	#1,d0			; Timer B
	ENDC
	move.l	ciares(a5),a6
	jsr	AddICRVector(a6)
	tst.l	d0
	bne.s	.busy

	st	cia_set(a5)


;=== stop timer
	move.l	ciares(a5),a0
	move.l	$22(a0),a0
	IFEQ	use_timer_b
	move.b	#%00000000,ciacra(a0)
	ELSE
	move.b	#%00000000,ciacrb(a0)
	ENDC


;=== read cia clock value, calc tempo
	subq.w	#8,sp
	move.l	sp,a0
	move.l	timerio(a5),a6
	move.l	$14(a6),a6
	jsr	ReadEClock(a6)
	addq.w	#8,sp
	divu	#50,d0
	mulu	#125*100,d0
	move.l	d0,ciafreq(a5)
	move.w	playtempo(a5),d1
	bsr	calc_tempo


.noirq
	POSITIV

.busy
	bsr.s	.nociatimer
	NEGATIV




.nociatimer
	move.w	#loc_nocia,d0
	move.w	#loc_illfix,d1
	jmp	EZrequestJ(a5)




cia_irq
	dc.l	0,0
	dc.b	2,1
	dc.l	ciairqname
	dc.l	varbase
	dc.l	.irqcode




.irqcode
	movem.l	d1/a0-a1/a6,-(sp)

	move.l	(a1),a6
	lea	replay_irq(pc),a1
	jsr	Cause(a6)

	movem.l	(sp)+,d1/a0-a1/a6
	moveq	#0,d0
	rts




replay_irq
	dc.l	0,0
	dc.b	2,0
	dc.l	replayname
	dc.l	varbase
	dc.l	.replayirqcode



.replayirqcode
	tst.b	playflag(a1)
	beq.s	.notrigger
	tst.b	autostopped(a1)
	bne.s	.notrigger

	movem.l	d1/a0-a1/a5-a6,-(sp)
	move.l	a1,a5

	subq.w	#1,ciacount(a5)
	bne.s	.irqout
	move.w	ciacountinit(a5),ciacount(a5)

;	addq.l	#1,cia_trigger_count(a5)

	moveq	#0,d0
	move.b	cia_trigger_sig(a5),d1
	bset	d1,d0
	move.l	playerprocess(a5),a1
	move.l	(a5),a6
	jsr	Signal(a6)

.irqout
	movem.l	(sp)+,d1/a0-a1/a5-a6
.notrigger
	moveq	#0,d0
	rts




FreeCIA
	tst.b	cia_set(a5)
	beq.s	.nocia

	move.l	ciares(a5),a6
	move.l	$22(a6),a0
	move.b	#%00000000,ciacra(a0)	; stop timer

	lea	cia_irq(pc),a1
	IFEQ	use_timer_b
	moveq	#0,d0			; Timer A
	ELSE
	moveq	#1,d0			; Timer B
	ENDC
	jsr	RemICRVector(a6)
	sf	cia_set(a5)

.nocia
	rts






ciairqname	dc.b	'MT replay timer',0
replayname	dc.b	'MT replay irq',0
		even




calc_tempo	; d1=new tempo in bpm
	bsr.s	check_external_clock
	bne.s	.skip_cia

	moveq	#1,d0
.multiloop
	cmp.w	#2800,d1
	bcc.s	.ok
	add.w	d1,d1
	add.w	d0,d0
	bra.s	.multiloop
.ok
	move.w	d0,ciacount(a5)
	move.w	d0,ciacountinit(a5)

	move.l	ciafreq(a5),d0
	divu	d1,d0
	move.l	ciares(a5),a0
	move.l	$22(a0),a0

	IFEQ	use_cia_b
	move.w	#$0008,$dff09a
	ELSE
	move.w	#$2000,$dff09a
	ENDC

	IFEQ	use_timer_b
	move.b	d0,ciatalo(a0)
	lsr.w	#8,d0
	move.b	d0,ciatahi(a0)
	and.b	#%11010001,ciacra(a0)
	or.b	#%00010001,ciacra(a0)
	move.b	#$81,ciaicr(a0)
	ELSE
	move.b	d0,ciatblo(a0)
	lsr.w	#8,d0
	move.b	d0,ciatbhi(a0)
	move.b	#%00010001,ciacrb(a0)
	move.b	#$82,ciaicr(a0)
	ENDC

	IFEQ	use_cia_b
	move.w	#$8008,$dff09a
	ELSE
	move.w	#$a000,$dff09a
	ENDC

.skip_cia
	rts





check_external_clock	; returns: pos=external clock is enabled,
			;          neg=internal clock is enabled
			; STOP-mode is treated as internal clock.

	tst.b	playflag(a5)
	beq.s	.stoped
.check	bmi.s	.playing
	tst.b	record_extclock(a5)
	bne.s	.do_clock
.neg	NEGATIV
.stoped	tst.b	last_playflag(a5)
	bra.s	.check
.playing
	tst.b	play_extclock(a5)
	beq.s	.neg
.do_clock
	POSITIV






send_1_byte	; d0 is the byte to write

	movem.l	d0-d1/a0-a2,-(sp)

;	moveq	#1,d0
;	bsr	prepare_serial_write
;	beq.s	.dontwrite

;	move.l	(sp),d0

;	tst.b	serial_type(a5)
;	bne.s	.mlib


;	tst.b	from_irq(a5)
;	beq.s	.noirq


;	move.l	writeptr_out(a5),a1
;	move.l	upperlimit_out(a5),a0

;	move.b	(sp),(a1)+
;	cmpa.l	a0,a1
;	bcs.s	.ok1
;	move.l	serialoutpufferD(a5),a1
;.ok1

;	bsr	finish_serial_write

;.noirq
	subq.l	#4,sp

	move.l	sp,a0
	move.b	d0,(a0)

	moveq	#1,d0
	lea	midi_message_main(a5),a1
	move.l	midi_replyport_main(a5),a2
	bsr.s	make_midimsg



;	bsr	prepare_serial_write
;	bsr	start_serial_write
;	bsr	wait_serial_write
.back2	addq.l	#4,sp
.back	movem.l	(sp)+,d0-d1/a0-a2
	rts

;.mlib
;	subq.l	#4,sp
;	move.b	d0,(sp)

;	suba.l	a1,a1
;	move.l	(a5),a6
;	jsr	FindTask(a6)
;	cmp.l	playerprocess(a5),d0
;	beq.s	.itself

;	move.l	sp,midi_address(a5)
;	clr.l	midi_length(a5)
;	move.b	midimsg_signal(a5),d1
;	bsr	put_player_signal
;	bra.s	.back2

;.itself	move.l	sp,a2
;	bsr	send_midimsg
;	bra.s	.back2




make_midimsg	; d0 = length, a0 = ^midi-data,
		; a1 = ^message, a2 = ^replyport

	clr.l	(a1)
	clr.l	4(a1)
	move.b	#7,8(a1)
	clr.b	9(a1)
	clr.l	$a(a1)
	move.l	a2,$e(a1)
	move.w	#$14+8,$12(a1)
	move.l	d0,$14(a1)
	move.l	a0,$18(a1)

	move.l	sendmidi_port(a5),a0
	move.l	(a5),a6
	jsr	PutMsg(a6)

	move.l	a2,a0
	jsr	WaitPort(a6)
	move.l	a2,a0
	jmp	GetMsg(a6)



send_2_bytes	; d0-d1 are bytes to write

	movem.l	d0-d1/a0-a2,-(sp)



;	moveq	#2,d0
;	bsr	prepare_serial_write
;	beq.s	.dontwrite


;	movem.l	(sp),d0-d1

;	tst.b	cia_or_midilib(a5)
;	bne.s	.mlib


;	tst.b	from_irq(a5)
;	beq.s	.noirq


;	movem.l	(sp),d0-d1
;	move.l	writeptr_out(a5),a1
;	move.l	upperlimit_out(a5),a0

;	move.b	d0,(a1)+
;	cmpa.l	a0,a1
;	bcs.s	.ok1
;	move.l	serialoutpufferD(a5),a1
;.ok1
;	move.b	d1,(a1)+
;	cmpa.l	a0,a1
;	bcs.s	.ok2
;	move.l	serialoutpufferD(a5),a1
;.ok2

;	bsr	finish_serial_write


;.noirq
	subq.l	#4,sp
	move.l	sp,a0
	move.b	d0,(a0)+
	move.b	d1,(a0)+

	moveq	#2,d0
	move.l	sp,a0
	lea	midi_message_main(a5),a1
	move.l	midi_replyport_main(a5),a2
	bsr.s	make_midimsg


;	move.l	sp,serialwrite_ptr(a5)
;	move.l	d0,serialwrite_length(a5)

;	bsr	prepare_serial_write
;	bsr	start_serial_write
;	bsr	wait_serial_write
.back2	addq.l	#4,sp
;	bra.s	.back

.back	movem.l	(sp)+,d0-d1/a0-a2
	rts

;.mlib
;	subq.w	#4,sp
;	move.l	sp,a0
;	move.b	d0,(a0)+
;	move.b	d1,(a0)+

;	suba.l	a1,a1
;	move.l	(a5),a6
;	jsr	FindTask(a6)
;	cmp.l	playerprocess(a5),d0
;	beq.s	.itself

;	move.l	sp,midi_address(a5)
;	clr.l	midi_length(a5)
;	move.b	midimsg_signal(a5),d1
;	bsr	put_player_signal
;	bra.s	.back2

;.itself	move.l	sp,a2
;	bsr	send_midimsg
;	bra.s	.back2





send_3_bytes	; d0-d2 are bytes to write

	movem.l	d0-d2/a0-a2,-(sp)



;	moveq	#3,d0
;	bsr	prepare_serial_write
;	beq.s	.back

;	movem.l	(sp),d0-d2

;	tst.b	cia_or_midilib(a5)
;	bne.s	.mlib


;	tst.b	from_irq(a5)
;	beq.s	.noirq


;	move.l	writeptr_out(a5),a1
;	move.l	upperlimit_out(a5),a0

;	move.b	d0,(a1)+
;	cmpa.l	a0,a1
;	bcs.s	.ok1
;	move.l	serialoutpufferD(a5),a1
;.ok1
;	move.b	d1,(a1)+
;	cmpa.l	a0,a1
;	bcs.s	.ok2
;	move.l	serialoutpufferD(a5),a1
;.ok2
;	move.b	d2,(a1)+
;	cmpa.l	a0,a1
;	bcs.s	.ok3
;	move.l	serialoutpufferD(a5),a1
;.ok3

;	bsr	finish_serial_write



;=== raise channelscope level
;.setscope

	subq.l	#4,sp
	move.l	sp,a0
	move.b	d0,(a0)+
	move.b	d1,(a0)+
	move.b	d2,(a0)+


	move.b	d0,d1
	lsr.b	#4,d1
	cmp.b	#9,d1
	bne.s	.nonote
	tst.b	d2
	beq.s	.nonote

	lea	channellevels(a5),a0
	and.w	#$0f,d0
	IFEQ	mc68020
	lsl.w	#2,d0
	move.b	d2,1(a0,d0.w)
	st	2(a0,d0.w)
	ELSE
	move.b	d2,1(a0,d0.w*4)
	st	2(a0,d0.w*4)
	ENDC
.nonote



;.noirq
	moveq	#3,d0
	move.l	sp,a0
	lea	midi_message_main(a5),a1
	move.l	midi_replyport_main(a5),a2
	bsr	make_midimsg

;	move.l	sp,serialwrite_ptr(a5)
;	move.l	d0,serialwrite_length(a5)

;	bsr	prepare_serial_write
;	bsr	start_serial_write
;	bsr	wait_serial_write

;.back2
	addq.l	#4,sp
;	movem.l	(sp),d0-d2
;	bra.s	.setscope

;.back
	movem.l	(sp)+,d0-d2/a0-a2
	rts


;.mlib
;	subq.w	#4,sp
;	move.l	sp,a0
;	move.b	d0,(a0)+
;	move.b	d1,(a0)+
;	move.b	d2,(a0)+

;	suba.l	a1,a1
;	move.l	(a5),a6
;	jsr	FindTask(a6)
;	cmp.l	playerprocess(a5),d0
;	beq.s	.itself

;	move.l	sp,midi_address(a5)
;	clr.l	midi_length(a5)
;	move.b	midimsg_signal(a5),d1
;	bsr	put_player_signal
;	bra.s	.back2

;.itself	move.l	sp,a2
;	bsr	send_midimsg
;	bra.s	.back2





send_stream_main	; d1=length, a1=^data

	lea	midi_message_main(a5),a0
	move.l	midi_replyport_main(a5),a2
	bra.s	send_stream_routine


send_stream_player	; d1=length, a1=^data

	lea	midi_message_player(a5),a0
	move.l	midi_replyport_player(a5),a2


send_stream_routine	; d1=length, a1=^data, a0 = ^message, a2 = ^replyport

	tst.l	d1
	beq.s	.rts

	movem.l	d0-d1/a0-a2,-(sp)

	exg	a1,a0
	move.l	d1,d0
	neg.l	d0

;	tst.b	cia_or_midilib(a5)
;	bne.s	.mlib


;	tst.b	from_irq(a5)
;	beq.s	.noirq


;	move.l	4(sp),d2
;	move.l	16(sp),a0
;	move.l	writeptr_out(a5),a1
;	move.l	upperlimit_out(a5),a2
;	move.l	irqptr_out(a5),a3
;	subq.w	#1,a3
;	cmp.l	serialoutpufferD(a5),a3
;	bcc.s	.regok1
;	lea	serialoutsize(a3),a3
;.regok1

;.copy	move.b	(a0)+,(a1)+
;	cmpa.l	a2,a1
;	bcs.s	.ok
;	move.l	serialoutpufferD(a5),a1
;.ok
;	cmpa.l	a3,a1		; buffer overflow ?
;	beq.s	.done
;	subq.l	#1,d2
;	bne.s	.copy
;.done
;	bsr.s	finish_serial_write


;.noirq
;	move.l	a1,serialwrite_ptr(a5)
;	move.l	d1,serialwrite_length(a5)

;	bsr.s	prepare_serial_write
;	bsr.s	start_serial_write
;	bsr.s	wait_serial_write
;	bra.s	.back

	bsr	make_midimsg

;.back
	movem.l	(sp)+,d0-d1/a0-a2
.rts	rts


;.mlib
;	move.l	a1,a2
;	move.l	d1,d2

;	suba.l	a1,a1
;	move.l	(a5),a6
;	jsr	FindTask(a6)
;	cmp.l	playerprocess(a5),d0
;	beq.s	.itself

;	move.l	a2,midi_address(a5)
;	move.l	d2,midi_length(a5)

;	move.b	midimsg_signal(a5),d1
;	bsr	put_player_signal
;	bra.s	.back

;.itself	bsr	send_midistream
;	bra.s	.back






	IFEQ	1

prepare_serial_write	; d0 = length to write
			; returns: pos=buffer ok, neg=not enough space
	moveq	#0,d1
	move.b	serialoutreadysig(a5),d0
	bset	d0,d1
	moveq	#0,d0
	move.l	(a5),a6
	jmp	SetSignal(a6)

	ENDC


	IFEQ	1

.again	move.w	#$0009,$dff09a
	move.l	irqptr_out(a5),d1
	move.l	writeptr_out(a5),d2
	move.w	#$8009,$dff09a
	sub.l	d2,d1
	beq.s	.room
	bgt.s	.inside
	add.l	#serialoutsize,d1
.inside
	; d1 is the number of free bytes in the output-puffer
	cmp.l	d1,d0
	bcs.s	.room
	tst.b	from_irq(a5)
	bne.s	.neg

	move.l	d0,-(sp)
	bsr.s	wait_serial_write
	move.l	(sp)+,d0
	bra.s	.again

.room	POSITIV
.neg	NEGATIV

	ENDC



	IFEQ	1

finish_serial_write	; a1 = new end of buffer

	move.l	a1,writeptr_out(a5)

start_serial_write
	move.w	$dff018,d1
	btst	#13,d1
	beq.s	.notbe
	move.w	#$8001,$dff09c
.notbe
	rts



; wait for serial irq to finish output

wait_serial_write
	moveq	#0,d0
	move.b	serialoutreadysig(a5),d1
	bset	d1,d0
	move.l	(a5),a6
	jmp	Wait(a6)

	ENDC






;==============================================================
;
;  Record routine
;
;==============================================================

	IFEQ	1

recorder	; returns: pos = ok,
		;          neg = buffer overflow

	tst.b	playflag(a5)
	bmi.s	.pos

	tst.b	metromusic(a5)
	beq.s	.playmode

	move.l	recbuf(a5),a3
	move.l	recbufpos(a5),d7
	adda.l	d7,a3
	move.l	readptr_in(a5),a2

.getmidiloop
	cmpa.l	irqptr_in(a5),a2
	beq.s	.out

	addq.l	#1,d7
	cmp.l	recbufsizebytes(a5),d7
	bcc.s	.overflow

	bsr	get_next_byte
	move.b	d0,(a3)+
	bra.s	.getmidiloop
.out

	move.l	a2,readptr_in(a5)



	tst.w	audpasses_togo(a5)
	bne.s	.nointernalclock

	tst.b	record_extclock(a5)
	bne.s	.nointernalclock

	addq.l	#1,d7
	cmp.l	recbufsizebytes(a5),d7
	bcc.s	.overflow
	move.b	#$f8,(a3)+
.nointernalclock

	move.l	d7,recbufpos(a5)

.playmode
.pos	POSITIV

.overflow
	move.l	d7,recbufpos(a5)
	NEGATIV

	ENDC



;==============================================================
;
;  MIDI Daten erzeugen
;
;==============================================================

createmidi	; zurck: d0=puffersize

	move.l	replaypufferD(a5),a4
	bra	.metrohandler



;=== music routine

.inpatt

;=== no tapedeck functions in recordmode
	tst.b	playflag(a5)
	bpl	.notape

	move.b	tapedeck(a5),d5
	beq	.notape
	cmp.b	#1,d5
	beq	.forw

;=== either fastrewind or fastforward or jump-pattern
	clr.b	tapedeck(a5)


;=== silence all channels to prevent notes from sustaining

	move.l	note_tracking(a5),a6
	moveq	#0,d6
.makequietloop

;=== d7 carries the channel-mapping flags
	lea	channels_maps(a5),a0
	IFEQ	mc68020
	move.w	d6,d0
	add.w	d0,d0
	move.w	(a0,d0.w),d7
	ELSE
	move.w	(a0,d6.w*2),d7
	ENDC

	bsr	silence_channel

	move.l	maxtracks(a5),d0
	IFEQ	mc68020
	add.l	d0,d0
	adda.l	d0,a6
	ELSE
	lea	(a6,d0.l*2),a6
	ENDC

	addq.w	#1,d6
	cmp.w	#16,d6
	bcs.s	.makequietloop



	cmp.b	#-1,playflag(a5)
	bne.s	.playsong

;=== play pattern:

	cmp.b	#3,d5
	bne.s	.njump1
	move.l	patternjump(a5),d1
	bmi.s	.dopos
	jsr	GetNewPatternJ(a5)
	beq.s	.nextpt
	move.l	a0,playingpatternA(a5)
	move.l	d1,playingpattern(a5)
	bra.s	.nextpt

.njump1
	cmp.b	#2,d5
	bne.s	.nffw
	move.l	currentpos(a5),d0
	addq.l	#1,d0
	cmp.l	length(a5),d0
	bcc.s	.nextpt
	bra.s	.dopatt
.nffw
;=== must be fast rewind
	move.l	currentpos(a5),d0
	subq.l	#1,d0
	bcs.s	.nextpt
.dopatt	bsr	.newpattern
	bra.s	.nextpt


.playsong

;=== play song:

	cmp.b	#2,d5
	beq.s	.nextpt

	cmp.b	#3,d5
	bne.s	.njump2
.dopos	move.l	positionjump(a5),d0
	subq.l	#1,d0
	bra.s	.gopos
.njump2

;=== tapedeck must be fastrewind
	subq.l	#2,currentpos(a5)
	bcc.s	.nextpt
	moveq	#-1,d0
.gopos	move.l	d0,currentpos(a5)
	bra.s	.nextpt

;=== slow forward
.forw

.notape





;=== In recordmode, stop replay if song is at its end, but continue
;=== recording.
	tst.b	songready(a5)
	bne	.record_ready


;=== pattern am ende?
	move.l	playingpatternA(a5),a0
	move.l	playpos(a5),d0
	addq.l	#1,d0
	cmp.l	pt_events(a0),d0
	bcc.s	.nextpt
	move.l	d0,playpos(a5)
	bra	.notend

.nextpt
;=== pattern an den Anfang bringen
	clr.l	playpos(a5)
	cmp.b	#-2,playflag(a5)
	beq.s	.songmode
	cmp.b	#2,playflag(a5)
	beq.s	.songmode


;=== handle pattern-audition mode
	cmp.b	#1,playflag(a5)
	bne.s	.nopattrec
	cmp.b	#2,recordmode(a5)
	bne.s	.nopattrec
	tst.w	audpasses_togo(a5)
	beq.s	.nopattrec
	subq.w	#1,audpasses_togo(a5)
	bra.s	.notend
.nopattrec


;=== bei Pattern-Play/-Rec evtl. am Patternende anhalten
	tst.b	haltpatt(a5)
	beq.s	.notend
	bra	.neg			; auto-stop


.newpattern	; d0 = position
	move.l	d0,d1
	jsr	GetPatternAtPositionJ(a5)
	beq.s	.nopatt
	move.l	a0,playingpatternA(a5)
	move.l	d1,playingpattern(a5)
.nopatt	rts



.songmode
;=== playsong-mode: next pattern
	move.l	currentpos(a5),d0
	addq.l	#1,d0
	cmp.l	length(a5),d0
	bcs.s	.insong
	cmp.b	#-2,playflag(a5)
	beq.s	.psong
;=== record mode: stop playback, but continue recording
	st	songready(a5)
	bra	.record_ready

.psong
;=== playmode: loop back or stop
	tst.b	loopsong(a5)
	beq	.neg
	move.l	looppos(a5),d0

.insong	move.l	d0,currentpos(a5)
	bsr.s	.newpattern



;=== Hier fngt die MIDI Verarbeitung an!

.notend

	bsr	generate_note_offs


	move.l	playingpatternA(a5),a3
	move.l	playpos(a5),d5


;=== BPM Track
;	lea	bpmplaycounter(a5),a6
	move.l	pt_bpmtrack(a3),d0
	beq.s	.nobpm
	move.l	d0,a0
	IFEQ	mc68020
	move.l	d5,d0
	add.l	d0,d0
	move.w	(a0,d0.l),d0
	ELSE
	move.w	(a0,d5.l*2),d0
	ENDC
	beq.s	.nobpm
;	tst.w	(a6)		; pcbpm_counter(a6)
;	bne.s	.bpm1
;	move.l	d0,a0
;	adda.w	pcbpm_offset(a6),a0
;	addq.w	#2,pcbpm_offset(a6)
;	move.w	(a0),d1
;	bpl.s	.newbpm
;	move.w	d1,(a6)		; pcbpm_counter(a6)
;	bra.s	.bpm1
;.newbpm
	move.w	d1,playtempo(a5)
	bsr	calc_tempo
;	bra.s	.nobpm
;.bpm1	addq.w	#1,(a6) 	; pcbpm_counter(a6)
.nobpm



	move.l	note_tracking(a5),a6
	moveq	#0,d6
.channelloop

	move.w	channelglobalstates(a5),d0
	btst	d6,d0
	bne	.nextchan


	tst.b	solomode(a5)
	beq.s	.nosolo
	move.w	currentchannel(a5),d0
	subq.w	#1,d0
	cmp.w	d6,d0
	bne	.nextchan
;	st	channelquiet(a5)
;	bra.s	.pcont
.nosolo

	move.l	playingpatternA(a5),a3
	IFEQ	mc68020
	move.l	d6,d0
	lsl.l	#2,d0
	move.l	pt_channels(a3,d0.l),d1
	ELSE
	move.l	pt_channels(a3,d6.l*4),d1
	ENDC
	beq	.nextchan
	move.l	d1,a3


	tst.b	playdisabled(a5)
	bne.s	.playalltracks
	tst.b	ch_onoff(a3)
	beq	.nextchan
;	bra.s	.pcont

.playalltracks
;	sf	channelquiet(a5)

;.pcont



;=== d7 carries the channel-mapping flags
	lea	channels_maps(a5),a0
	IFEQ	mc68020
	move.w	d6,d0
	add.w	d0,d0
	move.w	(a0,d0.w),d7
	ELSE
	move.w	(a0,d6.w*2),d7
	ENDC




;=== Preset Track MIDI
	move.l	ch_ptrack(a3),d0
	beq.s	.no0
	move.l	d0,a0
	IFEQ	mc68020
	move.l	d5,d0
	add.l	d0,d0
	move.w	(a0,d0.l),d0
	ELSE
	move.w	(a0,d5.l*2),d0
	ENDC
	beq.s	.no0
;	tst.w	(a6)		; pcp_counter(a6)
;	bne.s	.trk0
;	adda.w	pcp_offset(a6),a0
;	addq.w	#2,pcp_offset(a6)
;	move.w	(a0),d0
;	bpl.s	.new0
;	move.w	d0,(a6)		; pcp_counter(a6)
;.trk0	addq.w	#1,(a6) 	; pcp_counter(a6)
;	bra.s	.no0
;.new0
	; d0=preset, d6=channel, a4=^buffer
	jsr	make_preset_messageJ(a5)
.no0





;=== Pitchbend Track MIDI
	move.l	ch_pbtrack(a3),d0
	beq.s	.no1
	move.l	d0,a0
	IFEQ	mc68020
	move.l	d5,d0
	add.l	d0,d0
	move.w	(a0,d0.l),d0
	ELSE
	move.w	(a0,d5.l*2),d0
	ENDC
	cmp.w	#PB_stay,d0
	beq.s	.no1

;	tst.w	prec1+pcpb_counter(a6)
;	bne.s	.trk1
;	adda.w	prec1+pcpb_offset(a6),a0
;	addq.w	#2,prec1+pcpb_offset(a6)
;	move.w	(a0),d4
;	bpl.s	.new1
;	move.w	d4,prec1+pcpb_counter(a6)
;.trk1	addq.w	#1,prec1+pcpb_counter(a6)
;	bra.s	.no1
;.new1
	tst.b	playdisabled(a5)
	bne.s	.pbon
	tst.b	ch_pb_onoff(a3)
	beq.s	.no1
;	tst.b	channelquiet(a5)
;	bne.s	.no1
.pbon

	move.w	pibe_ofilter(a5),d2

	moveq	#15,d3
.pbmaploop
	btst	d3,d7
	beq.s	.pbnomap

	tst.b	global_outfilters(a5)
	beq.s	.pbnofilter
	btst	d3,d2
	bne.s	.pbnomap
.pbnofilter

	moveq	#-$20,d1	; d1.b=$e0
	or.b	d3,d1
	move.b	d1,(a4)+
	move.b	d0,d1
	and.b	#$7f,d1
	move.b	d1,(a4)+
	move.w	d0,d1
	lsr.w	#7,d1
	move.b	d1,(a4)+
.pbnomap
	dbf	d3,.pbmaploop

.no1





;=== Alle Controlsources, die mit $B0 (Parameter) einzustellen sind

	lea	ch_cstracks(a3),a1
;	lea	codetab(a5),a2
;	moveq	#0,d4

.paramloop
	move.l	(a1),d0
	beq	.nomorecs
	move.l	d0,a1

	move.b	cs_data(a1,d5.l),d0
	bmi	.stay

;=== zur Controlsource spulen, um den richtigen Offset in d2 zu bekommen
;	moveq	#-pcc_sizeof,d2
;	move.b	cs_parameter(a1),d0
;.codeloop
;	addq.w	#pcc_sizeof,d2
;	cmp.b	(a2)+,d0
;	beq.s	.foundcs
;	addq.l	#1,d4
;	cmp.l	active_csources(a5),d4
;	bcs.s	.codeloop
;	bra	.nomorecs
;.foundcs

;	tst.b	prec3+pcc_counter(a6,d2.w)
;	bne.s	.trkc
;	move.w	prec3+pcc_offset(a6,d2.w),d1
;	addq.w	#1,prec3+pcc_offset(a6,d2.w)
;	bpl.s	.newc
;	move.b	d0,prec3+pcc_counter(a6,d2.w)
;.trkc	addq.b	#1,prec3+pcc_counter(a6,d2.w)
;	bra.s	.stay
;.newc
	tst.b	playdisabled(a5)
	bne.s	.cson
	tst.b	cs_onoff(a1)
	beq	.stay
;	tst.b	channelquiet(a5)
;	bne	.stay
.cson

	moveq	#15,d3

	cmp.b	#$80,cs_parameter(a1)
	beq.s	.is_mp


;	sub.l	active_csources_m1(a5),d3
;	neg.l	d3
	lea	cs_ofilters(a5),a0
	moveq	#0,d0
	move.b	cs_parameter(a1),d0
	IFEQ	mc68020
	move.l	d0,d1
	add.l	d1,d1
	move.w	(a0,d1.l),d4
	ELSE
	move.w	(a0,d0.l*2),d4
	ENDC


	cmp.b	#7,d0
	beq.s	.is_vol


;=== routine for other controlsources than volume
.csmaploop
	btst	d3,d7
	beq.s	.csnomap

	tst.b	global_outfilters(a5)
	beq.s	.csnofilter
	btst	d3,d4
	bne.s	.csnomap
.csnofilter

	moveq	#-$50,d1
	or.b	d3,d1
	move.b	d1,(a4)+
	move.b	d0,(a4)+
	move.b	cs_data(a1,d5.l),(a4)+
.csnomap
	dbf	d3,.csmaploop
	bra.s	.stay


;=== volume mixdown

.is_vol
	lea	channelvolumes(a5),a0
.volloop
	btst	d3,d7
	beq.s	.volnomap

	tst.b	global_outfilters(a5)
	beq.s	.volnofilter
	btst	d3,d4
	bne.s	.volnomap
.volnofilter

	move.b	cs_data(a1,d5.l),d2
	move.b	d2,(a0,d3.w)
	moveq	#-$50,d1
	or.b	d3,d1
	move.b	d1,(a4)+
	move.b	d0,(a4)+
	move.b	d2,(a4)+
	jsr	volume_mixdownJ(a5)
.volnomap
	dbf	d3,.volloop
	bra.s	.stay


;=== MPress Track MIDI

.is_mp
	move.w	mpress_ofilter(a5),d4
.mpmaploop
	btst	d3,d7
	beq.s	.mpnomap

	tst.b	global_outfilters(a5)
	beq.s	.mpnofilter
	btst	d3,d4
	bne.s	.mpnomap
.mpnofilter

	moveq	#-$30,d1
	or.b	d3,d1
	move.b	d1,(a4)+
	move.b	cs_data(a1,d5.l),(a4)+
.mpnomap
	dbf	d3,.mpmaploop



.stay
	bra	.paramloop

.nomorecs





;=== Now we're going to manage all note-tracks !





	clr.b	highest_vel(a5)


;=== now process the note-tracks

	lea	ch_tracks(a3),a2
.trackloop
	move.l	(a2),d0
	beq	.nomoretracks
	move.l	d0,a2

	move.w	tr_number(a2),d4
	add.w	d4,d4


	tst.b	playdisabled(a5)
	bne.s	.playtrk

;	tst.b	channelquiet(a5)
;	bne	.nextrk

	tst.b	tr_onoff(a2)
	bne.s	.playtrk
;	bsr	.note_off
	bra	.nextrk

.playtrk

	IFEQ	mc68020
	move.l	d5,d2
	lsl.l	#2,d2
	move.b	tr_data+wd_pitch(a2,d2.l),d1
	ELSE
	move.b	tr_data+wd_pitch(a2,d5.l*4),d1
	ENDC
	ble.s	.pp			; 0 means no note specified, -1 means Note OFF specified

	move.b	d1,pc_oldnote(a6,d4.w)		; d1 = the new note

	IFEQ	mc68020
	move.b	tr_data+wd_vel(a2,d2.l),d0
	ELSE
	move.b	tr_data+wd_vel(a2,d5.l*4),d0
	ENDC
	bgt.s	.vel_ok
	move.b	firstautovel(a5),d0
.vel_ok	move.b	d0,pc_oldvel(a6,d4.w)


; collect highest channelscope level

	cmp.b	highest_vel(a5),d0
	bls.s	.skipv
	move.b	d0,highest_vel(a5)
.skipv



;=== play a note-on event

	move.w	note_ofilter(a5),d2
	lea	desttranss(a5),a0
	moveq	#15,d3
.onmaploop
	btst	d3,d7
	beq.s	.onnomap

	tst.b	global_outfilters(a5)
	beq.s	.onnofilter
	btst	d3,d2
	bne.s	.onnomap
.onnofilter

	moveq	#-$70,d0
	or.b	d3,d0
	move.b	d0,(a4)+

	move.b	pc_oldnote(a6,d4.w),d1
	bsr	dest_transpose
	move.b	d1,(a4)+			; new note
	move.b	pc_oldvel(a6,d4.w),(a4)+	; new velocity
.onnomap
	dbf	d3,.onmaploop



;=== check poly pressure byte

.pp
	IFEQ	mc68020
	move.l	d5,d1
	lsl.l	#2,d1
	move.b	tr_data+wd_pp(a2,d1.l),d1
	ELSE
	move.b	tr_data+wd_pp(a2,d5.l*4),d1
	ENDC
	cmp.b	#cs_stay,d1
	beq.s	.nextrk			; no new pp-value
	tst.b	pc_oldnote(a6,d4.w)	; check if there is a note
	bmi.s	.nextrk			; pending (-1 = note is off)

	move.w	ppress_ofilter(a5),d2

	moveq	#15,d3
.ppmaploop
	btst	d3,d7
	beq.s	.ppnomap

	tst.b	global_outfilters(a5)
	beq.s	.ppnofilter
	btst	d3,d2
	bne.s	.ppnomap
.ppnofilter

	moveq	#-$60,d0
	or.b	d3,d0
	move.b	d0,(a4)+
	move.b	pc_oldnote(a6,d4.w),(a4)+
	move.b	d1,(a4)+
.ppnomap

	dbf	d3,.ppmaploop


.nextrk	bra	.trackloop
.nomoretracks






;=== take highest velocity into channelscope levels
	move.b	highest_vel(a5),d1
	beq.s	.skipvel

	tst.b	global_outfilters(a5)
	beq.s	.skipfilter
	move.w	note_ofilter(a5),d0
	btst	d6,d0
	bne.s	.skipvel
.skipfilter

	lea	channellevels(a5),a0
	moveq	#15,d3
.maxvelloop
	btst	d3,d7
	beq.s	.nomaxvelmap

	IFEQ	mc68020
	move.w	d3,d0
	lsl.w	#2,d0
	move.b	d1,1(a0,d0.w)
	st	2(a0,d0.w)
	ELSE
	move.b	d1,1(a0,d3.w*4)
	st	2(a0,d3.w*4)
	ENDC

.nomaxvelmap
	dbf	d3,.maxvelloop

.skipvel




.nextchan
	move.l	maxtracks(a5),d0
	IFEQ	mc68020
	add.l	d0,d0
	adda.l	d0,a6
	ELSE
	lea	(a6,d0.l*2),a6
	ENDC

	addq.w	#1,d6
	cmp.w	#16,d6
	bcs	.channelloop



;=== set mastervolume to positive if it's not-ed. A not-ed value means,
;=== all volumes must be recalculated. This has been done up to here, that's
;=== the reason why we reset it here.
;	tst.w	mastervolume(a5)
;	bpl.s	.mposi
;	not.w	mastervolume(a5)
;.mposi



.record_ready
.send_data

	bsr	midi_time_code


	bsr	check_external_clock
	bne.s	.noclock
	move.b	#$f8,(a4)+			; Realtime-Clock
.noclock


.metro_alone


;	bsr.s	.optimize

	move.l	a4,d1
	move.l	replaypufferD(a5),a1
	sub.l	a1,d1
	beq.s	.nosend

	bsr	send_stream_player
.nosend

	POSITIV

.neg	bsr.s	.send_data
.neg2	NEGATIV






	IFEQ	1


;=== Put all Note-OFFs in front of all Note-ONs

.optimize	; a4=^end of buffer
		; returns: a1=beginning of buffer, d1=length

	move.l	replaypufferD(a5),a0
	move.l	replaypufferoptD(a5),a1

;	move.l	a4,d1
;	sub.l	a0,d1
;	move.l	a0,a1
;	rts


; First, collect all note-offs.

.optloop1
	cmpa.l	a4,a0
	bcc.s	.optout1

	move.b	(a0),d0
	lsr.b	#4,d0
.reloop1
	subq.b	#8,d0
	beq.s	.3move1
	subq.b	#1,d0		; note on
	beq.s	.non1
	subq.b	#1,d0		; ppress
	beq.s	.3move1
	subq.b	#1,d0		; parameter
	beq.s	.3byte1
	subq.b	#2,d0		; program + mpress
	bls.s	.2byte1
	subq.b	#1,d0		; pitchbend
	beq.s	.3byte1
	move.b	(a0),d0		; check for sysex
	and.b	#$0f,d0
	beq.s	.sysex1
	subq.b	#1,d0		; $f1 mtc
	beq.s	.2byte1
	subq.b	#7,d0		; $f8 clock
	beq.s	.1byte1
	subq.b	#2,d0		; $fa start
	beq.s	.1byte1
	subq.b	#2,d0		; $fc stop
	beq.s	.1byte1

.sysex1	addq.w	#1,a0
.sexl1	move.b	(a0)+,d0
	bpl.s	.sexl1
	bra.s	.optloop1

.1byte1	addq.w	#1,a0
	bra.s	.optloop1

.2byte1	addq.w	#2,a0
	bra.s	.optloop1

.3byte1	addq.w	#3,a0
	bra.s	.optloop1

.3move1	move.b	(a0),(a1)+
	sf	(a0)+
	move.b	(a0),(a1)+
	sf	(a0)+
	move.b	(a0),(a1)+
	sf	(a0)+
	bra.s	.optloop1

.non1	addq.w	#3,a0
	cmpa.l	a4,a0
	bcc.s	.optout1
	move.b	(a0),d0
	lsr.b	#4,d0
	cmp.b	#$a,d0
	beq.s	.3byte1
	bra.s	.reloop1
.optout1



; Now, take over all other midi data.

	move.l	replaypufferD(a5),a0
.optloop2
	cmpa.l	a4,a0
	bcc.s	.optout2

	move.b	(a0)+,d0
	beq.s	.optloop2
	move.b	d0,d1
	lsr.b	#4,d0
	sub.b	#$b,d0
	bls.s	.3move2
	subq.b	#2,d0		; program + mpress
	bls.s	.2move2
	subq.b	#1,d0		; pitchbend
	beq.s	.3move2
	move.b	d1,d0		; check for sysex
	and.b	#$0f,d0
	beq.s	.sysex2
	subq.b	#1,d0		; $f1 mtc
	beq.s	.2move2
	subq.b	#6,d0		; $f7 eox
	beq.s	.1move2
	subq.b	#1,d0		; $f8 clock
	beq.s	.1move2
	subq.b	#2,d0		; $fa start
	beq.s	.1move2
	subq.b	#2,d0		; $fc stop
	beq.s	.1move2

.sysex2	move.b	d1,(a1)+
.sexl2	move.b	(a0)+,d0
	bmi.s	.optloop2
	move.b	d0,(a1)+
	bra.s	.sexl2

.1move2	move.b	d1,(a1)+
	bra.s	.optloop2

.2move2	move.b	d1,(a1)+
	move.b	(a0)+,(a1)+
	bra.s	.optloop2

.3move2	move.b	d1,(a1)+
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	bra.s	.optloop2


.optout2
	move.l	a1,d1
	move.l	replaypufferoptD(a5),a1
	sub.l	a1,d1
	rts


	ENDC






.mraus	cmp.b	#-3,playflag(a5)
	beq	.metro_alone
	tst.b	metromusic(a5)
	beq	.metro_alone
.back	bra	.inpatt

.metrohandler
	cmp.b	#-3,playflag(a5)
	beq.s	.mtest

	tst.b	playflag(a5)			; recording enabled?
	bmi.s	.back				; no
	tst.b	metroflag(a5)			; metronome enabled?
	beq.s	.back				; no

.mtest
	subq.w	#1,metrostepcnt(a5)		; are we between two clicks?
	bne.s	.mraus				; yes
	move.w	metrostep(a5),metrostepcnt(a5)

	moveq	#0,d3
	move.b	metrovel(a5),d3			; get volume in d3
	subq.w	#1,metrobeatscnt(a5)		; is it the first beat (in bar)?
	beq.s	.1st
	mulu	metrootherbeats(a5),d3		; let the other beats sound
	divu	#100,d3				; more quiet
	bra.s	.mcont

.1st	move.w	metrobeats(a5),metrobeatscnt(a5)
	tst.w	metrobarcnt(a5)			; are we already done?
	bmi.s	.mcont				; yes
	subq.w	#1,metrobarcnt(a5)		; next bar
	bcc.s	.mcont


	cmp.b	#-3,playflag(a5)
	beq	.neg2


;=== metronome is done, the song is starting to play
	st	metromusic(a5)
	tst.b	sequencer_sysex(a5)		; send Sequencer-Start optionally
	beq.s	.nosysex
	move.b	#$fa,(a4)+
.nosysex

;=== SysTime merken fr Timer-Display
	lea	timervalinit(a5),a0
	move.l	playertimerio(a5),a6
	move.l	$14(a6),a6
	jsr	GetSysTime(a6)

.mcont

	tst.b	metromusic(a5)
	beq.s	.beforesong
	tst.b	countinonly(a5)
	bne.s	.back
.beforesong


;=== send Note-ON
	move.b	metrochannel(a5),d1
	subq.b	#1,d1
	moveq	#-$70,d0	; d0.b=$90
	or.b	d1,d0
	move.b	d0,(a4)+
	move.b	metronote(a5),d2
	move.b	d2,(a4)+
	move.b	d3,(a4)+

;=== directly followed by a Note-OFF
	moveq	#-$80,d0
	or.b	d1,d0
	move.b	d0,(a4)+
	move.b	d2,(a4)+
	move.b	d3,(a4)+
	bra	.mraus






generate_note_offs

	move.l	note_tracking(a5),a6
	moveq	#0,d6
.channelloop

;=== d7 carries the channel-mapping flags
	lea	channels_maps(a5),a0
	IFEQ	mc68020
	move.w	d6,d0
	add.w	d0,d0
	move.w	(a0,d0.w),d7
	ELSE
	move.w	(a0,d6.w*2),d7
	ENDC

	move.w	channelglobalstates(a5),d0
	btst	d6,d0
	bne.s	.silence


	tst.b	solomode(a5)
	beq.s	.nosolo
	move.w	currentchannel(a5),d0
	subq.w	#1,d0
	cmp.w	d6,d0
	bne.s	.silence
;	st	channelquiet(a5)
;	bra.s	.pcont
.nosolo


	move.l	playingpatternA(a5),a3
	IFEQ	mc68020
	move.l	d6,d0
	lsl.l	#2,d0
	move.l	pt_channels(a3,d0.l),d1
	ELSE
	move.l	pt_channels(a3,d6.l*4),d1
	ENDC
	beq	.nextchan
	move.l	d1,a3

	tst.b	playdisabled(a5)
	bne.s	.playalltracks
	tst.b	ch_onoff(a3)
	bne.s	.playalltracks

.silence
	bsr	silence_channel
	bra	.nextchan

;	seq	channelquiet(a5)
;	bra.s	.pcont
.playalltracks
;	sf	channelquiet(a5)

;.pcont



;	tst.b	channelquiet(a5)
;	beq.s	.not_quiet

;.not_quiet



;=== Check if a remapped channel is turned to a not-remapped channel.

	lea	noteoff_maps(a5),a0
	IFEQ	mc68020
	move.w	d6,d0
	add.w	d0,d0
	move.w	(a0,d0.w),d4
	beq.s	.silenceremap_ready
	clr.w	(a0,d0.w)
	ELSE
	move.w	(a0,d6.w*2),d4
	beq.s	.silenceremap_ready
	clr.w	(a0,d6.w*2)
	ENDC

	move.w	d4,d7

	move.l	maxtracks_m1(a5),d4
	add.l	d4,d4
.silenceloop

	tst.b	pc_oldnote(a6,d4.w)
	bmi.s	.isoff

	move.w	note_ofilter(a5),d2

	lea	desttranss(a5),a0
	moveq	#15,d3
.offmaploop
	btst	d3,d7
	beq.s	.offnomap

	tst.b	global_outfilters(a5)
	beq.s	.offnofilter
	btst	d3,d2
	bne.s	.offnomap
.offnofilter

	moveq	#-$80,d0			; play real note-off
	or.b	d3,d0
	move.b	d0,(a4)+
	move.b	pc_oldnote(a6,d4.w),d1
	bsr	dest_transpose
	move.b	d1,(a4)+
	move.b	pc_oldvel(a6,d4.w),(a4)+
.offnomap

	dbf	d3,.offmaploop

.isoff
	subq.l	#pc_sizeof,d4
	bcc.s	.silenceloop

	bra.s	.nextchan

.silenceremap_ready




; play regular note offs

	move.l	playpos(a5),d5

	lea	ch_tracks(a3),a2
.trackloop
	move.l	(a2),d0
	beq.s	.nomoretracks
	move.l	d0,a2

	move.w	tr_number(a2),d4
	add.w	d4,d4

	tst.b	playdisabled(a5)
	bne.s	.playtrk
	tst.b	tr_onoff(a2)
	beq.s	.on
.playtrk

	IFEQ	mc68020
	move.l	d5,d0
	lsl.l	#2,d0
	move.b	tr_data+wd_pitch(a2,d0.l),d1
	ELSE
	move.b	tr_data+wd_pitch(a2,d5.l*4),d1
	ENDC
	beq.s	.nextrk
	bpl.s	.on

	IFEQ	mc68020
	move.b	tr_data+wd_vel(a2,d0.l),d0
	ELSE
	move.b	tr_data+wd_vel(a2,d5.l*4),d0
	ENDC
	ble.s	.novel2
	move.b	d0,pc_oldvel(a6,d4.w)
.novel2

.on
	bsr.s	note_off

.nextrk
	bra.s	.trackloop


.nomoretracks

.nextchan
	move.l	maxtracks(a5),d0
	IFEQ	mc68020
	add.l	d0,d0
	adda.l	d0,a6
	ELSE
	lea	(a6,d0.l*2),a6
	ENDC

	addq.w	#1,d6
	cmp.w	#16,d6
	bcs	.channelloop

	rts





note_off	; d4 = offset to notetrackings, d7 = remapping bits
		; a6 = ^notetrackings for the channel

	tst.b	pc_oldnote(a6,d4.w)
	bmi.s	.back1				; already off

	move.w	note_ofilter(a5),d2

	lea	desttranss(a5),a0
	moveq	#15,d3
.offmaploop
	btst	d3,d7
	beq.s	.offnomap

	tst.b	global_outfilters(a5)
	beq.s	.offnofilter
	btst	d3,d2
	bne.s	.offnomap
.offnofilter

	moveq	#-$80,d0			; play real note-off
	or.b	d3,d0
	move.b	d0,(a4)+
	move.b	pc_oldnote(a6,d4.w),d1
	bsr	dest_transpose
	move.b	d1,(a4)+
	move.b	pc_oldvel(a6,d4.w),(a4)+
.offnomap

	dbf	d3,.offmaploop

	st	pc_oldnote(a6,d4.w)		; set note to OFF

.back1	rts



silence_channel	; d7 = channel-mapping-word, d6 = channel (0-15)
		; a6 = ^notetrackings for the channel

;=== All held notes in this channel have to be silenced, ie Note-OFFed.

	move.l	maxtracks_m1(a5),d4
	add.l	d4,d4
.silenceloop
	bsr.s	note_off
	subq.l	#pc_sizeof,d4
	bcc.s	.silenceloop

	rts






midi_time_code

; the time is always being calculated, for mtc and for refreshing the timer gadget

	lea	timerval(a5),a0
	move.l	playertimerio(a5),a6
	move.l	$14(a6),a6
	jsr	GetSysTime(a6)
	lea	timervalinit(a5),a1
	jsr	SubTime(a6)

	tst.b	send_mtc(a5)
	bne.s	.toggleframe

	tst.b	mtc_frameflag(a5)
	bne.s	.rts


.toggleframe

	moveq	#-$f,d4			; $f1
	moveq	#$0f,d5

	not.b	mtc_frameflag(a5)
	bne.s	.2nd_frame


; frames in 1/25 per second
	move.l	4(a0),d0
	divu	#10000*4,d0
	move.b	d0,d2
	and.b	d5,d2
	move.b	d4,(a4)+
	move.b	d2,(a4)+		; LS nibble
	lsr.b	#4,d0
	add.b	#$10,d0
	move.b	d4,(a4)+
	move.b	d0,(a4)+		; MS nibble

; seconds
	move.l	(a0),d0
	divu	#60,d0
	move.w	d0,mtc_minutes(a5)
	swap	d0
	move.b	d0,d2
	and.b	d5,d2
	add.b	#$20,d2
	move.b	d4,(a4)+
	move.b	d2,(a4)+
	lsr.b	#4,d0
	add.b	#$30,d0
	move.b	d4,(a4)+
	move.b	d0,(a4)+

.rts	rts


.2nd_frame

; minutes
	move.w	mtc_minutes(a5),d0
	divu	#60,d0
	swap	d0			; hours in MSW
	move.b	d0,d2
	and.b	d5,d2
	add.b	#$40,d2
	move.b	d4,(a4)+
	move.b	d2,(a4)+
	lsr.b	#4,d0
	add.b	#$50,d0
	move.b	d4,(a4)+
	move.b	d0,(a4)+

; hours
	swap	d0
	move.b	d0,d2
	and.b	d5,d2
	add.b	#$60,d2
	move.b	d4,(a4)+
	move.b	d2,(a4)+
	lsr.b	#4,d0
	add.b	#$72,d0			; 1/25 frames/second
	move.b	d4,(a4)+
	move.b	d0,(a4)+

	rts





; consider destination transpose from the remapper window

dest_transpose	; d1=old note, a0=pointer to transpose table, d3=channel (0-15)
		; returns: d1=new note after transpose

	move.b	(a0,d3.w),d0
	beq.s	.rts
	bpl.s	.posn
	add.b	d0,d1
	cmp.b	#12,d1
	bgt.s	.noteok
	moveq	#12,d1
	rts

.posn	add.b	d0,d1
	bvc.s	.noteok
	moveq	#127,d1
.noteok
.rts	rts


