;APS0000208900001FE400004D4000000000000000000000000000000000000000000000000000000000
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;
;
;
;
;              M I D I     P R O C E S S
;
;
;
;
;
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================


midiprocess_start
	lea	varbase,a5

	st	shutdown_midi_sig(a5)
	st	changeserial_sig(a5)
	st	sysex_sig(a5)
	st	opensmp_sig(a5)
	st	closesmp_sig(a5)
	st	tbe2midi_sig(a5)
	st	rbf2midi_sig(a5)
	st	camd_sig(a5)


	moveq	#-1,d0
	move.l	(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,shutdown_midi_sig(a5)
	bmi	.error

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,changeserial_sig(a5)
	bmi	.error


; signals for the midilib sample option

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,opensmp_sig(a5)
	bmi	.error

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,closesmp_sig(a5)
	bmi	.error




	jsr	CreateMsgPort(a6)
	move.l	d0,sendmidi_port(a5)
	beq	.error

	jsr	CreateMsgPort(a6)
	move.l	d0,midiin_replyport(a5)
	beq	.error

	jsr	CreateMsgPort(a6)
	move.l	d0,todo_replyport_midi(a5)
	beq	.error


	moveq	#1,d0
	move.l	#16*1024,d1
	move.l	d1,d2
	jsr	CreatePool(a6)
	move.l	d0,midipoolheader(a5)
	beq	.error


	suba.l	a1,a1
	jsr	FindTask(a6)
	move.l	d0,midiprocess(a5)

	bsr	signal2main


.mainloop
	moveq	#0,d0


; serial irq signals

	move.b	rbf2midi_sig(a5),d1
	bmi.s	.norbf
	bset	d1,d0
.norbf

;	move.b	tbe2midi_sig(a5),d1
;	bmi.s	.notbe
;	bset	d1,d0
;.notbe

	move.b	sysex_sig(a5),d1
	bmi.s	.nosysex
	bset	d1,d0
.nosysex



; midilib signals

	moveq	#-1,d2
	move.l	midi_mdest(a5),d1
	beq.s	.nodest
	move.l	d1,a0
	move.l	$1e(a0),a0
	move.b	$f(a0),d2
	bset	d2,d0
.nodest



; camd signals

	move.b	camd_sig(a5),d1
	bmi.s	.nocamd
	bset	d1,d0
.nocamd


; serial device signals

	tst.b	serial_read_pending(a5)
	beq.s	.noser
	move.l	SerialReply_read(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0
.noser


; misc signals

	move.b	changeserial_sig(a5),d1
	bset	d1,d0

	move.b	shutdown_midi_sig(a5),d1
	bset	d1,d0

	move.b	opensmp_sig(a5),d1
	bset	d1,d0

	move.b	closesmp_sig(a5),d1
	bset	d1,d0

	move.l	midiin_replyport(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0

	move.l	todo_replyport_midi(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0

	move.l	sendmidi_port(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0

; wait

	move.l	(a5),a6
	jsr	Wait(a6)

	move.l	midiin_replyport(a5),a0
	move.b	$f(a0),d1
	btst	d1,d0
	beq.s	.noreply
	move.l	d0,-(sp)
	bsr	midiprocess_reply
	move.l	(sp)+,d0
.noreply

	move.l	sendmidi_port(a5),a0
	move.b	$f(a0),d1
	btst	d1,d0
	beq.s	.nomidimsg
	move.l	d0,-(sp)
	bsr	manage_midimsg
	move.l	(sp)+,d0
.nomidimsg

	move.l	todo_replyport_midi(a5),a0
	move.b	$f(a0),d1
	btst	d1,d0
	beq.s	.notodomsg
	move.l	d0,-(sp)
	bsr	todo_reply_midi
	move.l	(sp)+,d0
.notodomsg


; test midilib signals

	move.l	midi_mdest(a5),d1
	beq.s	.nodestmsg
	move.l	d1,a0
	move.l	$1e(a0),a0
	move.b	$f(a0),d1
	btst	d1,d0
	beq.s	.nodestmsg
	move.l	d0,-(sp)
	bsr	incoming_midi_mlib
	move.l	(sp)+,d0
.nodestmsg


; test serial device signals

	tst.b	serial_read_pending(a5)
	beq.s	.nosermsg
	move.l	SerialReply_read(a5),a0
	move.b	$f(a0),d1
	btst	d1,d0
	beq.s	.nosermsg
	move.l	d0,-(sp)
	bsr	incoming_midi_serdev
	move.l	(sp)+,d0
.nosermsg


; test camd signals

	move.b	camd_sig(a5),d1
	bmi.s	.nocamdmsg
	btst	d1,d0
	beq.s	.nocamdmsg
	move.l	d0,-(sp)
	bsr	incoming_midi_camd
	move.l	(sp)+,d0
.nocamdmsg


; test serial irq signals

	move.b	rbf2midi_sig(a5),d1
	bmi.s	.norbfsig
	btst	d1,d0
	beq.s	.norbfsig
	move.l	d0,-(sp)
	bsr	incoming_midi_irq
	move.l	(sp)+,d0
.norbfsig

;	move.b	tbe2midi_sig(a5),d1
;	bmi.s	.notbesig
;	btst	d1,d0
;	beq.s	.notbesig
;	move.l	d0,-(sp)
;	move.l	(sp)+,d0
;.notbesig

	move.b	sysex_sig(a5),d1
	bmi.s	.nosysexsig
	btst	d1,d0
	beq.s	.nosysexsig
	move.l	d0,-(sp)
	bsr	process_sysex
	move.l	(sp)+,d0
.nosysexsig



; test misc signals

	move.b	opensmp_sig(a5),d1
	btst	d1,d0
	beq.s	.noopensmp2
	move.l	d0,-(sp)
	bsr	open_samples
	move.b	d0,midiprocess_rc(a5)
	bsr	put_main_replysig
	move.l	(sp)+,d0
.noopensmp2

	move.b	closesmp_sig(a5),d1
	btst	d1,d0
	beq.s	.noclosesmp2
	move.l	d0,-(sp)
	bsr	close_samples
	bsr	put_main_replysig
	move.l	(sp)+,d0
.noclosesmp2

	move.b	changeserial_sig(a5),d1
	btst	d1,d0
	beq.s	.nochangeserialsig
	move.l	d0,-(sp)
	bsr	ChangeSerial
	move.b	d0,midiprocess_rc(a5)
	bsr	put_main_replysig
	move.l	(sp)+,d0
.nochangeserialsig

	move.b	shutdown_midi_sig(a5),d1
	btst	d1,d0
	bne.s	.normit
	bra	.mainloop


.error	; midiprocess(a5) remains zero

.normit
	move.l	(a5),a6

	move.b	shutdown_midi_sig(a5),d0
	bmi.s	.skipfree4
	jsr	FreeSignal(a6)
.skipfree4

	move.b	changeserial_sig(a5),d0
	bmi.s	.skipfree5
	jsr	FreeSignal(a6)
.skipfree5

	move.b	opensmp_sig(a5),d0
	bmi.s	.skipfree2
	jsr	FreeSignal(a6)
.skipfree2

	move.b	closesmp_sig(a5),d0
	bmi.s	.skipfree3
	jsr	FreeSignal(a6)
.skipfree3

	move.l	midipoolheader(a5),d0
	beq.s	.nopool
	move.l	d0,a0
	jsr	DeletePool(a6)
.nopool

	move.l	midiin_replyport(a5),d0
	beq.s	.noport
	bsr	midiprocess_reply
	move.l	midiin_replyport(a5),a0
	jsr	DeleteMsgPort(a6)
.noport

	move.l	sendmidi_port(a5),d0
	beq.s	.noport2
	move.l	d0,a0
	jsr	DeleteMsgPort(a6)
.noport2

	move.l	todo_replyport_midi(a5),d0
	beq.s	.noport3
	bsr	todo_reply_midi
	move.l	todo_replyport_midi(a5),a0
	jsr	DeleteMsgPort(a6)
.noport3

	bsr	CloseSerial
	bsr	close_samples

	bsr.s	signal2main

	moveq	#0,d0
	rts


signal2main
	move.l	#$8000,d0
	move.l	mytask(a5),a1
	move.l	(a5),a6
	jmp	Signal(a6)




put_main_replysig
	moveq	#0,d0
	move.b	reply_sig(a5),d1
	bset	d1,d0
	move.l	mytask(a5),a1
	move.l	(a5),a6
	jmp	Signal(a6)





incoming_midi_serdev

	addq.w	#1,current_activity_rec(a5)
	bsr	finish_serial_read

	move.l	Serialio_write(a5),a1
	move.w	#9,$1c(a1)		; SDCMD_QUERY
	move.l	(a5),a6
	jsr	DoIO(a6)
	tst.b	d0
	bne	.error1

	move.l	Serialio_write(a5),a1
	move.l	$20(a1),d2
	beq.s	.emptyread

	moveq	#1,d0
	add.l	d2,d0
	move.l	midipoolheader(a5),a0
	jsr	AllocPooled(a6)
	tst.l	d0
	beq	.error1
	move.l	d0,a3

	movem.l	d2/a3,-(sp)

	move.b	serial_read_char(a5),(a3)

	lea	1(a3),a0
	move.l	d2,d0
	bsr	.read_serial
	tst.b	d0
	bne	.error2
	bra.s	.readcont

.emptyread
	lea	serial_read_char(a5),a3
	clr.l	-(sp)
	clr.l	-(sp)

.readcont
	lea	1(a3,d2.l),a4

.byteloop
	cmpa.l	a4,a3
	bcc	.done

	move.b	(a3)+,d2
	bmi.s	.status

;=== check for sysex
.new	cmp.b	#$f0,lastmidistatus(a5)
	beq	.sysex_cont

;=== databyte has arrived
.again	subq.b	#1,mbytes2read(a5)
	beq.s	.complete
	bcc.s	.not_complete

;.running_status
	tst.b	lastmidistatus(a5)
	bpl.s	.ignore
	move.b	mbytes2readinit(a5),mbytes2read(a5)
	beq.s	.ignore
	bra.s	.again

.ignore	cmpa.l	a4,a3
	bcc	.done
	move.b	(a3)+,d2
	bpl.s	.ignore
	bra.s	.new


;=== midimsg is not yet complete, 2nd byte from 3-byte-msgs is read
.not_complete
	move.b	d2,lastdata1(a5)
	bra.s	.byteloop

.complete
;=== write data to output-buffer
	cmp.b	#1,mbytes2readinit(a5)
	beq.s	.2b_out

	move.b	d2,d4
	move.b	lastmidistatus(a5),d2
	move.b	lastdata1(a5),d3
	bsr	make_3byte_midimsg
	bra.s	.byteloop

.2b_out	move.b	d2,d3
	move.b	lastmidistatus(a5),d2
	bsr	make_2byte_midimsg
	bra.s	.byteloop


.status
	cmp.b	#$f0,lastmidistatus(a5)
	beq	.sysex_eox

	move.b	d2,lastmidistatus(a5)

	move.b	d2,d0
	lsr.b	#4,d0
	sub.b	#$c,d0
	bcs.s	.3_bytes
	subq.b	#2,d0
	bcs.s	.2_bytes
	beq.s	.3_bytes

; sysex
	cmp.b	#$f0,d2
	beq.s	.sysex_data
	cmp.b	#$f1,d2
	beq.s	.3_bytes
	cmp.b	#$f2,d2
	beq.s	.3_bytes
	cmp.b	#$f3,d2
	beq.s	.2_bytes

; all other ones ($F4-$F7) are one-byte
	bsr	make_1byte_midimsg
	bra	.byteloop

.3_bytes
	moveq	#2,d1
	bra.s	.n_bytes
.2_bytes
	moveq	#1,d1
.n_bytes
	move.b	d1,mbytes2read(a5)
	move.b	d1,mbytes2readinit(a5)
	bra	.byteloop

.done

.error2
	movem.l	(sp)+,d0/a1
	tst.l	d0
	beq.s	.nofree
	addq.l	#1,d0
	move.l	midipoolheader(a5),a0
	move.l	(a5),a6
	jsr	FreePooled(a6)
.nofree

.error1
	bra	init_serial_read



.sysex_cont
	move.l	sysexbuffers(a5),a2
	move.l	(a2),d3
	bra.s	.sjin

.sysex_data
	move.l	sysexbuffers(a5),a2
	moveq	#0,d3
	bra.s	.sjin

.sysexloop
	move.b	(a3)+,d2
	bmi.s	.sstatus

.sjin	move.b	d2,4(a2,d3.l)
	addq.l	#1,d3
	move.l	d3,(a2)
	cmp.l	#sysexbuffersize,d3
	bcs.s	.putok
	bsr	swap_sysex_buffers
	bsr	process_sysex
	beq.s	.skip

	move.l	midiin_replyport(a5),a0
	move.l	(a5),a6
	jsr	WaitPort(a6)
	bsr	midiprocess_reply
.skip
	move.l	sysexbuffers(a5),a2
	moveq	#0,d3
.putok
	cmpa.l	a4,a3
	bcs.s	.sysexloop

	bra.s	.done


.sysex_eox
	move.l	sysexbuffers(a5),a2
	move.l	(a2),d3

.sstatus
	move.b	d2,lastmidistatus(a5)

	move.b	#$f7,4(a2,d3.l)
	addq.l	#1,d3
	move.l	d3,(a2)

	bsr	swap_sysex_buffers
	bsr	process_sysex
	beq.s	.skips

	move.l	midiin_replyport(a5),a0
	move.l	(a5),a6
	jsr	WaitPort(a6)
	bsr	midiprocess_reply
.skips
	moveq	#0,d1
	bra	.n_bytes




.read_serial	; d0.l = number of bytes to read, a0 = ^dest
		; returns: d0.b = doio return value

	add.w	d0,current_activity_rec(a5)

	move.l	serialio_read(a5),a1
	move.w	#2,$1c(a1)
	move.l	d0,$24(a1)
	move.l	a0,$28(a1)
	jmp	DoIO(a6)




incoming_midi_mlib

	bra	.next

.incomingloop

	move.l	d0,a3
	moveq	#0,d2
	move.w	$16(a3),d2
	lea	$1c(a3),a2

	add.w	d2,current_activity_rec(a5)

	move.b	(a2),lastmidistatus(a5)

	subq.w	#1,d2
	bne.s	.not1
	move.b	(a2)+,d2
	bsr	make_1byte_midimsg
	bra.s	.free
.not1
	subq.w	#1,d2
	bne.s	.not2
	move.b	(a2)+,d2
	move.b	(a2)+,d3
	bsr	make_2byte_midimsg
	bra.s	.free
.not2
	subq.w	#1,d2
	bne.s	.not3
	move.b	(a2)+,d2
	move.b	(a2)+,d3
	move.b	(a2)+,d4
	bsr	make_3byte_midimsg
	bra.s	.free
.not3
; must be sysex
	moveq	#sp_sysex_sizeof,d0
	bsr	alloc_message
	beq.s	.nomem

	addq.l	#3,d2
	move.l	d2,sp_bodylength(a1)
	move.l	a2,sp_packetaddr(a1)
	move.b	#$f0,sp_status(a1)

	tst.b	playflag(a5)
	bne.s	.player
	move.l	midiin_port_main(a5),a0
	bra.s	.putmsg
.player	move.l	midiin_port_player(a5),a0
.putmsg	move.l	(a5),a6
	jsr	PutMsg(a6)

	move.l	midiin_replyport(a5),a0
	jsr	WaitPort(a6)
	bsr	midiprocess_reply
.nomem

.free	move.l	a3,a0
	move.l	midibas(a5),a6
	jsr	FreeMidiPacket(a6)


.next	move.l	midi_mdest(a5),a0
	move.l	midibas(a5),a6
	jsr	GetMidiPacket(a6)
	tst.l	d0
	bne	.incomingloop

	rts



incoming_midi_camd

	subq.l	#8,sp
	bra	.next

.incomingloop

	move.l	sp,a0
	move.b	(a0)+,d2
	move.b	d2,lastmidistatus(a5)
	move.b	d2,d0
	lsr.b	#4,d0
	sub.b	#$c,d0
	bcs.s	.3_bytes
	subq.b	#2,d0
	bcs.s	.2_bytes
	beq.s	.3_bytes

	cmp.b	#$f0,d2
	beq.s	.sysex
	cmp.b	#$f1,d2
	beq.s	.3_bytes
	cmp.b	#$f2,d2
	beq.s	.3_bytes
	cmp.b	#$f3,d2
	beq.s	.2_bytes

	addq.w	#1,current_activity_rec(a5)
	bsr	make_1byte_midimsg
	bra.s	.next

.2_bytes
	addq.w	#2,current_activity_rec(a5)
	move.b	(a0)+,d3
	bsr	make_2byte_midimsg
	bra.s	.next

.3_bytes
	addq.w	#3,current_activity_rec(a5)
	move.b	(a0)+,d3
	move.b	(a0)+,d4
	bsr	make_3byte_midimsg
	bra.s	.next

.sysex
	bra.s	.sjin
.sysexloop

	move.l	sysexbuffers(a5),a0
	move.l	d0,(a0)
	bsr	swap_sysex_buffers
	bsr	process_sysex
	beq.s	.skips

	move.l	midiin_replyport(a5),a0
	move.l	(a5),a6
	jsr	WaitPort(a6)
	bsr	midiprocess_reply
.skips

.sjin	move.l	sysexbuffers(a5),a1
	addq.l	#4,a1
	move.l	#sysexbuffersize,d0
	move.l	camd_midinode(a5),a0
	move.l	camdbas(a5),a6
	jsr	GetSysEx(a6)
	tst.l	d0
	bne.s	.sysexloop


.next	move.l	camd_midinode(a5),a0
	move.l	sp,a1
	move.l	camdbas(a5),a6
	jsr	GetMidi(a6)
	tst.l	d0
	bne	.incomingloop

	addq.l	#8,sp
	rts






GET_NEXT_BYTE	MACRO

	cmpa.l	upperlimit_in(a5),a2
	bcs.s	.nowrap\@
	move.l	serialinpufferD(a5),a2
.nowrap\@
	move.b	(a2)+,d0

	ENDM



incoming_midi_irq

	move.l	readptr_in(a5),a2
	move.l	irqptr_in(a5),d7
	sub.l	a2,d7
	bcc.s	.ok
	add.l	#serialinsize,d7
.ok	; d7 = number of bytes in buffer

.byteloop
	subq.l	#1,d7
	bmi	.outloop

	GET_NEXT_BYTE
	bpl.s	.byteloop

.status
	move.b	d0,d2
	lsr.b	#4,d0
	sub.b	#$c,d0
	bcs.s	.3_bytes
	subq.b	#2,d0
	bcs.s	.2_bytes
	beq.s	.3_bytes

; sysex
;	cmp.b	#$f8,d2
;	bcc.s	.next
	cmp.b	#$f0,d2
	beq.s	.unknown_sysex
	cmp.b	#$f1,d2
	beq.s	.3_bytes
	cmp.b	#$f2,d2
	beq.s	.3_bytes
	cmp.b	#$f3,d2
	beq.s	.2_bytes

; all other ones ($F4-$F7) are one-byte
.one_byte_sysex
	bsr.s	make_1byte_midimsg
	bra.s	.next


.3_bytes
	subq.l	#2,d7
	GET_NEXT_BYTE
	move.b	d0,d3
	GET_NEXT_BYTE
	move.b	d0,d4
	bsr.s	make_3byte_midimsg
	bra.s	.next

.2_bytes
	subq.l	#1,d7
	GET_NEXT_BYTE
	move.b	d0,d3
	bsr.s	make_2byte_midimsg


.next	bra	.byteloop
.outloop

.finished
	move.l	a2,readptr_in(a5)

.unknown_sysex
	rts





make_1byte_midimsg	; d2=midi-byte

	cmp.b	#$fe,d2
	beq.s	.rts

	moveq	#1+sp_midi_sizeof,d0
	bsr.s	alloc_message
	beq.s	.rts

	move.b	d2,sp_status(a1)
	bra.s	put_midi_msg
.rts	rts



make_2byte_midimsg	; d2-d3=midi-byte

	bsr	filter_incoming_midimsg
	beq.s	.rts

	moveq	#2+sp_midi_sizeof,d0
	bsr.s	alloc_message
	beq.s	.rts

	lea	sp_status(a1),a0
	move.b	d2,(a0)+
	move.b	d3,(a0)+
	bra.s	put_midi_msg
.rts	rts

put_midi_msg
	move.l	(a5),a6
	tst.b	playflag(a5)
	bne.s	.to_player
	move.l	midiin_port_main(a5),a0
	jmp	PutMsg(a6)
.to_player
	move.l	midiin_port_player(a5),a0
	jmp	PutMsg(a6)



make_3byte_midimsg	; d2-d4=midi-byte

	bsr	filter_incoming_midimsg
	beq.s	.rts

	moveq	#3+sp_midi_sizeof,d0
	bsr.s	alloc_message
	beq.s	.rts

	lea	sp_status(a1),a0
	move.b	d2,(a0)+
	move.b	d3,(a0)+
	move.b	d4,(a0)+
	bra.s	put_midi_msg
.rts	rts





alloc_message	; d0 = total length of message
		; returns: a1 = ^message, pos/neg

	move.l	d0,-(sp)
	move.l	midipoolheader(a5),a0
	move.l	(a5),a6
	jsr	AllocPooled(a6)
	move.l	(sp)+,d1
	tst.l	d0
	beq.s	.noalloc

	move.l	d0,a1
	clr.l	(a1)
	clr.l	4(a1)
	move.b	#7,8(a1)
	clr.b	9(a1)
	clr.l	$a(a1)
	move.l	midiin_replyport(a5),$e(a1)
	move.w	d1,$12(a1)
	moveq	#sp_midi_sizeof,d0
	sub.l	d0,d1
	move.l	d1,sp_bodylength(a1)

	POSITIV
.noalloc
	NEGATIV




midiprocess_reply
	move.l	midiin_replyport(a5),a2
	move.l	(a5),a6
	bra.s	.jin

.replyloop

	move.l	d0,a1
	moveq	#0,d0
	move.w	$12(a1),d0
	move.l	midipoolheader(a5),a0
	jsr	FreePooled(a6)

.jin	move.l	a2,a0
	jsr	GetMsg(a6)
	tst.l	d0
	bne.s	.replyloop

	rts




process_sysex	; returns: pos/neg

	moveq	#sp_sysex_sizeof,d0
	bsr	alloc_message
	beq.s	.nomem

	move.l	sysexbuffers+4(a5),a0
	move.l	(a0)+,sp_bodylength(a1)
	move.b	#$f0,sp_status(a1)
	move.l	a0,sp_packetaddr(a1)

	tst.b	playflag(a5)
	bne.s	.player
	move.l	midiin_port_main(a5),a0
	bra.s	.putmsg
.player	move.l	midiin_port_player(a5),a0
.putmsg	move.l	(a5),a6
	jsr	PutMsg(a6)

	POSITIV

.nomem
	NEGATIV




;==============================================================
;
;  Setup serial port
;
;==============================================================

ChangeSerial

	bsr	CloseSerial

;=== expunge serial devices
	bsr	.expunge_devices

	move.b	serial_type(a5),d0
	beq	.OpenHardwareSerial
	subq.b	#1,d0
	beq	.OpenMidilibSerial
	subq.b	#1,d0
	beq	.OpenSerialDevice


;.OpenCAMD

	moveq	#-1,d0
	move.l	(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,camd_sig(a5)
	bmi	.neg

	lea	camdnam(pc),a1
	moveq	#37,d0
	jsr	OpenLibrary(a6)
	move.l	d0,camdbas(a5)
	beq	.neg

	move.l	d0,a6
	lea	.camdtags(pc),a0
	move.b	camd_sig(a5),.camd_sig(a0)
	jsr	CreateMidiA(a6)
	move.l	d0,camd_midinode(a5)
	beq	.neg

	move.l	d0,a0
	moveq	#0,d0			; MLTYPE_Receiver
	lea	.in_tags(pc),a1
	jsr	AddMidiLinkA(a6)
	move.l	d0,camd_midilink_in(a5)
	beq	.neg

	move.l	camd_midinode(a5),a0
	moveq	#1,d0			; MLTYPE_Sender
	lea	.out_tags(pc),a1
	jsr	AddMidiLinkA(a6)
	move.l	d0,camd_midilink_out(a5)
	beq	.neg

	bra	.okay



.camdtags
	dc.l	$80000041,pubname
.camd_sig = *+7-.camdtags
	dc.l	$80000041+4,0		; MIDI_RecvSignal
	dc.l	$80000041+6,256		; MIDI_MsgQueue
	dc.l	$80000041+7,128*1024	; MIDI_SysExSize
	dc.l	0


.in_tags
	dc.l	$80000041,camd_inname	; MLINK_Location
	dc.l	$80000041+13,rbfname	; MLINK_Name
	dc.l	0

.out_tags
	dc.l	$80000041,camd_outname	; MLINK_Location
	dc.l	$80000041+13,tbename	; MLINK_Name
	dc.l	0




.OpenSerialDevice

	move.l	(a5),a6

; prepare read io

	jsr	CreateMsgPort(a6)
	move.l	d0,SerialReply_read(a5)
	beq	.neg

	move.l	d0,a0
	moveq	#$52,d0
	jsr	CreateIORequest(a6)
	move.l	d0,Serialio_read(a5)
	beq	.neg

; prepare write io

	jsr	CreateMsgPort(a6)
	move.l	d0,SerialReply_write(a5)
	beq	.neg

	move.l	d0,a0
	moveq	#$52,d0
	jsr	CreateIORequest(a6)
	move.l	d0,Serialio_write(a5)
	beq	.neg

	move.l	d0,a1
	move.b	#1,$9(a1)		; Pri

	lea	serial_device(a5),a0
	move.l	a0,$a(a1)
	moveq	#0,d0
	move.b	serial_unit(a5),d0
	moveq	#0,d1
	jsr	OpenDevice(a6)
	tst.b	d0
	bne	.neg

	st	serialdevice_open(a5)

	move.l	Serialio_write(a5),a0
	move.l	Serialio_read(a5),a1
	moveq	#$52,d0
	jsr	CopyMem(a6)

	move.l	Serialio_read(a5),a1
	move.l	SerialReply_read(a5),$e(a1)

;=== SERPARAMS
	move.l	Serialio_write(a5),a1
	move.w	#11,$1c(a1)
	move.l	#16000,$34(a1)
	move.l	#31250,$3c(a1)
	move.b	#$b0,$4f(a1)
	jsr	DoIO(a6)
	tst.b	d0
	bne	.neg

	bsr	init_serial_read

	bra	.okay



.OpenHardwareSerial

;=== allocate some signals

	moveq	#-1,d0
	move.l	(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,tbe2midi_sig(a5)
	bmi	.neg

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,rbf2midi_sig(a5)
	bmi	.neg

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,sysex_sig(a5)
	bmi	.neg


;=== alloc misc-resource
	lea	miscnam(pc),a1
	move.l	(a5),a6
	jsr	OpenResource(a6)
	move.l	d0,miscres(a5)
	beq	.free_serial
	move.l	d0,a6

	move.l	pubnameD(a5),a1
	moveq	#0,d0				; MR_SERIALPORT
	jsr	AllocMiscResource(a6)
	tst.l	d0
	beq.s	.misc_ok
	clr.l	miscres(a5)
	bra.s	.neg
.misc_ok

;=== activate serial-out irq
	moveq	#0,d0
	lea	.tbe_irq(pc),a1
	move.l	(a5),a6
	jsr	SetIntVector(a6)
	tst.l	d0
	bne.s	.reset_tbe
	st	tbe_set(a5)


;=== activate serial-in irq
	moveq	#11,d0
	lea	.rbf_irq(pc),a1
	jsr	SetIntVector(a6)
	tst.l	d0
	bne.s	.reset_rbf
	st	rbf_set(a5)


	move.w	#114,$dff032		; rate 31250 bps
	move.w	#$8801,$dff09a



.okay
	POSITIV


.reset_rbf
;	move.l	d0,a1
;	moveq	#11,d0
;	jsr	SetIntVector(a6)
;	moveq	#0,d0
;	sf	rbf_set(a5)

.reset_tbe
;	move.l	d0,a1
;	moveq	#0,d0
;	jsr	SetIntVector(a6)
;	sf	tbe_set(a5)


.free_serial
.neg	bsr	CloseSerial
	NEGATIV





.expunge_devices

	move.l	sernamD(a5),a1
	bsr.s	.expunge
	lea	serial_device(a5),a1

.expunge	; a1 = ^devicename

	move.l	a1,a2
	move.l	(a5),a6
	jsr	Forbid(a6)
	move.l	a2,a1
	lea	350(a6),a0
	jsr	FindName(a6)
	move.l	d0,-(sp)
	jsr	Permit(a6)
	move.l	(sp)+,d0
	beq.s	.nodev
	move.l	d0,a6
	jsr	ExpungeDevice(a6)
.nodev
	rts




; Open midi library stuff

.OpenMidilibSerial

	bsr	OpenMidiLibrary
	beq.s	.neg


	move.l	midibas(a5),a6

	suba.l	a0,a0
	suba.l	a1,a1
	jsr	CreateMSource(a6)
	move.l	d0,midi_msource(a5)
	beq.s	.neg

	move.l	d0,a0
	lea	midioutname(pc),a1
	suba.l	a2,a2
	jsr	MRouteSource(a6)
	move.l	d0,midi_sourceroute(a5)
	beq.s	.neg


	suba.l	a0,a0
	suba.l	a1,a1
	jsr	CreateMDest(a6)
	move.l	d0,midi_mdest(a5)
	beq.s	.neg

	lea	midiinname(pc),a0
	move.l	d0,a1
	suba.l	a2,a2
	jsr	MRouteDest(a6)
	move.l	d0,midi_destroute(a5)
	beq	.neg

	bra	.okay



.tbe_irq
	dc.l	0,0
	dc.b	2,1
	dc.l	tbename
	dc.l	varbase
	dc.l	.tbecode

.rbf_irq
	dc.l	0,0
	dc.b	2,1
	dc.l	rbfname
	dc.l	varbase
	dc.l	.rbfcode



.tbecode
	move.w	#$0001,$dff09c
	movem.l	a5-a6,-(sp)
	move.l	a1,a5

;	move.l	irqptr_out(a5),a1
;	cmpa.l	writeptr_out(a5),a1
;	beq.s	.irqready

;	bra.s	.irqready

;	move.w	#$0100,d0
;	move.b	(a1)+,d0

;	cmpa.l	upperlimit_out(a5),a1
;	bcs.s	.put
;	move.l	serialoutpufferD(a5),a1
;.put	move.l	a1,irqptr_out(a5)


;.irqready
	move.l	serialwrite_ptr(a5),d0
	beq.s	.back
	move.l	d0,a1
	subq.l	#1,serialwrite_length(a5)
	bcc.s	.more

	clr.l	serialwrite_ptr(a5)
	moveq	#0,d0
	move.b	tbe2midi_sig(a5),d1
	bset	d1,d0
	move.l	midiprocess(a5),a1
	move.l	(a5),a6
	jsr	Signal(a6)
	bra.s	.back

.more	move.w	#$0100,d0
	move.b	(a1)+,d0
	move.l	a1,serialwrite_ptr(a5)
;	bra.s	.put2

;.put2
	move.w	d0,$dff030

.back	movem.l	(sp)+,a5-a6
	rts





.rbfcode
	move.w	$dff018,d0
	move.w	#$0800,$dff09c

	movem.l	d2-d6/a0/a5-a6,-(sp)
	move.l	a1,a5
	addq.w	#1,current_activity_rec(a5)

	move.b	d0,d2
	bmi	.statusbyte

;=== check for sysex
	cmp.b	#$f0,lastmidistatus(a5)
	beq.s	.sysexdata

;=== databyte has arrived
.again	subq.b	#1,mbytes2read(a5)
	beq.s	.complete
	bcs.s	.running_status

;=== midimsg is not yet complete, 2nd byte from 3-byte-msgs is read
.notcomplete
	move.b	d2,lastdata1(a5)
	bra	.rbfout


.running_status
	tst.b	lastmidistatus(a5)
	bpl	.rbfout
	move.b	mbytes2readinit(a5),mbytes2read(a5)
	beq	.rbfout
	bra.s	.again

.sysexdata
	move.l	sysexbuffers(a5),a0
	move.l	(a0),d1
	move.b	d2,4(a0,d1.l)
	addq.l	#1,d1
	move.l	d1,(a0)
	cmp.l	#sysexbuffersize,d1
	bcs.s	.putok
	bsr	.swap_sysex
.putok
.noput	bra	.rbfout


.complete
;=== write data to output-buffer
	move.b	lastmidistatus(a5),d0
	cmp.b	#1,mbytes2readinit(a5)
	beq.s	.2b_out
	bsr	.put_byte
	move.b	lastdata1(a5),d0
.2b_out	bsr	.put_byte
	move.b	d2,d0
	bsr	.put_byte
	bra.s	.signal




.statusbyte
	cmp.b	#$f0,lastmidistatus(a5)
	beq.s	.endofsysex

.newstatus
	move.b	d2,lastmidistatus(a5)

;=== process new statusbyte
	move.b	d2,d0
	lsr.b	#4,d0
	sub.b	#$c,d0
	bcs.s	.2_bytes	; keypress, parameter
	subq.b	#2,d0
	bcs.s	.1_byte		; program, monopress
	beq.s	.2_bytes	; pitchbend

; sysex
	cmp.b	#$fe,d2		; ignore active sensing
	beq.s	.rbfout
	cmp.b	#$f8,d2
	bcc.s	.0_bytes
	cmp.b	#$f0,d2
	beq.s	.sysex
	cmp.b	#$f1,d2
	beq.s	.1_byte		; timecode
	cmp.b	#$f2,d2
	beq.s	.2_bytes	; songpos
	cmp.b	#$f3,d2
	beq.s	.1_byte		; songselect
	cmp.b	#$f7,d2
	bne.s	.0_bytes

	bsr.s	.eox
	bra.s	.rbfout

.endofsysex
	bsr.s	.eox
	cmp.b	#$f7,d2
	bne.s	.newstatus
	bra.s	.rbfout


.sysex	move.l	sysexbuffers(a5),a0
	move.b	d2,4(a0)
	moveq	#1,d0
	move.l	d0,(a0)
	moveq	#0,d1
	bra.s	.n_bytes

.0_bytes
	move.b	d2,d0
	bsr.s	.put_byte

.signal
;	tst.b	playflag(a5)
;	bgt.s	.rbfout


;	tst.b	autorec_active(a5)
;	beq.s	.noarec
;	tst.b	autorec_done(a5)
;	bne.s	.rbfout
;	cmp.b	#$f0,lastmidistatus(a5)
;	bcc.s	.noarec
;	st	autorec_done(a5)
;.noarec

	moveq	#0,d0
	move.b	rbf2midi_sig(a5),d1
	bset	d1,d0
	move.l	midiprocess(a5),a1
	move.l	(a5),a6
	jsr	Signal(a6)
	bra.s	.rbfout

.1_byte
	moveq	#1,d1
	bra.s	.n_bytes

.2_bytes
	moveq	#2,d1
.n_bytes
	move.b	d1,mbytes2read(a5)
	move.b	d1,mbytes2readinit(a5)

.rbfout
	movem.l	(sp)+,d2-d6/a0/a5-a6
	rts



.put_byte	; d0 = midi byte
	move.l	irqptr_in(a5),a1
	move.b	d0,(a1)+
	cmpa.l	upperlimit_in(a5),a1
	bcs.s	.get
	move.l	serialinpufferD(a5),a1
.get	move.l	a1,irqptr_in(a5)
	rts


.eox	move.l	sysexbuffers(a5),a0
	move.l	(a0),d1
	moveq	#-9,d0	; $f7
	move.b	d0,4(a0,d1.l)
	move.b	d0,lastmidistatus(a5)
	addq.l	#1,d1
	move.l	d1,(a0)

.swap_sysex
	bsr.s	swap_sysex_buffers

	moveq	#0,d0
	move.b	sysex_sig(a5),d1
	bset	d1,d0
	move.l	midiprocess(a5),a1
	move.l	(a5),a6
	jmp	Signal(a6)


swap_sysex_buffers
	lea	sysexbuffers(a5),a0
	move.l	(a0)+,a1
	move.l	(a0),-(a0)
	move.l	a1,4(a0)
	move.l	(a0),a0
	clr.l	(a0)
	rts



tbename		dc.b	'MT Midi out',0
rbfname		dc.b	'MT Midi in',0

midioutname	dc.b	'MidiOut',0
midiinname	dc.b	'MidiIn',0

camd_inname	dc.b	'in.0',0
camd_outname	dc.b	'out.0',0

midinam		dc.b	'midi.library',0
camdnam		dc.b	'camd.library',0
miscnam		dc.b	'misc.resource',0

		even





filter_incoming_midimsg	; d2-d4 = midibytes
			; returns: pos = msg is ok and is useable
			;          neg = msg must be skipped

;===   - check midi-in filters
;===   - check keyboard actions
;===   - check midithru
;===   - rise channelscope level

	movem.l	d2-d4,-(sp)


;=== check keyboard actions

	bsr	.test_keyboard_actions
	beq.s	.no_action

	moveq	#TODO_rec_patt,d0
	add.w	d1,d0
	bsr	main_todo_from_player

	bra	.suppress
.no_action



;=== invoke midi-in filters

	movem.l	(sp),d2-d3
	bsr	.in_filter
	beq	.suppress



;=== check midi-thru

	move.l	(sp),d2

; skip program changes
	move.b	d2,d0
	lsr.b	#4,d0
	cmp.b	#$c,d0
	beq	.nomidithru

	bsr	.check_midithru
	beq	.nomidithru

;=== map midimsg to midi-out

	lea	channels_maps(a5),a0
	move.b	omnimode(a5),d1
	subq.b	#2,d1
	beq.s	.channel_omni1
	move.b	d2,d0
	and.w	#$0f,d0
	bra.s	.omni_done1
.channel_omni1
	move.w	currentchannel(a5),d0
	subq.w	#1,d0
.omni_done1
	IFEQ	mc68020
	add.w	d0,d0
	move.w	(a0,d0.w),d4
	ELSE
	move.w	(a0,d0.w*2),d4
	ENDC

	moveq	#15,d3

	move.b	d2,d5
	and.b	#$f0,d5

	movem.l	4(sp),d0-d1
	subq.l	#4,sp
	move.l	sp,a2
	move.b	d0,1(a2)
	move.b	d1,2(a2)

	move.b	d2,d0
	lsr.b	#4,d0
	sub.b	#$c,d0
	bcs.s	.3_byte_msg
	subq.b	#2,d0
	bcs.s	.2_byte_msg
	beq.s	.3_byte_msg

	addq.l	#4,sp
	bra	.filter_ok


.3_byte_msg

	moveq	#3,d2

	cmp.b	#$90,d5
	beq.s	.mapnote
	cmp.b	#$80,d5
	beq.s	.mapnote

.maploop
	btst	d3,d4
	beq.s	.nomap
	move.b	d5,d0
	or.b	d3,d0
	move.b	d0,(a2)
	bsr	sendmidi_routine
.nomap	dbf	d3,.maploop

	bra.s	.thru_done


.mapnote
	lea	desttranss(a5),a0
	move.b	1(a2),d6
.mapnoteloop
	btst	d3,d4
	beq.s	.nomapn
	move.b	d6,d1
	bsr	dest_transpose
	move.b	d1,1(a2)
	move.b	d5,d0
	or.b	d3,d0
	move.b	d0,(a2)
	bsr	sendmidi_routine
.nomapn	dbf	d3,.mapnoteloop

	bra.s	.thru_done


.2_byte_msg

	moveq	#2,d2

.map2loop
	btst	d3,d4
	beq.s	.nomap2
	move.b	d5,d0
	or.b	d3,d0
	move.b	d0,(a2)
	bsr	sendmidi_routine
.nomap2	dbf	d3,.map2loop

.thru_done
	addq.l	#4,sp

.nomidithru



;=== trigger channelscope level
	move.l	(sp),d1
	lsr.b	#4,d1
	cmp.b	#9,d1
	bne.s	.no_note
	move.l	8(sp),d4
	tst.b	d4			; velocity value
	beq.s	.no_note		; velocity=0 means note-off
	lea	channellevels(a5),a1
	move.l	(sp),d1
	and.w	#$0f,d1
	IFEQ	mc68020
	lsl.w	#2,d1
	st	2(a1,d1.w)
	move.b	d4,1(a1,d1.w)
	ELSE
	st	2(a1,d1.w*4)
	move.b	d4,1(a1,d1.w*4)
	ENDC
.no_note


.filter_ok
	movem.l	(sp)+,d2-d4
	POSITIV

.suppress
	movem.l	(sp)+,d2-d4
	NEGATIV



.check_midithru	; d2 = midi status
		; returns: pos/neg for midithru enabled/disabled

	tst.b	midithru_global(a5)
	beq.s	.nothru
	move.b	omnimode(a5),d0
	subq.b	#2,d0
	bne.s	.omni3
	move.w	currentchannel(a5),d0
	subq.w	#1,d0
	bra.s	.omni4
.omni3	move.b	d2,d0
	and.w	#$0f,d0
.omni4	move.w	midithru_chans(a5),d1
	btst	d0,d1
	beq.s	.nothru
	POSITIV
.nothru	NEGATIV




.test_keyboard_actions	; d2=midi status, d3=midi note
			; returns: pos=event hit in d1, or neg=no action

	tst.b	actions_enable(a5)
	beq.s	.nonoteon

	move.b	d2,d0
	lsr.b	#4,d0
	cmp.b	#9,d0
	bne.s	.nonoteon

	lea	actions_switches(a5),a0
	lea	actions_mnotes(a5),a1
	moveq	#6,d1
.actionloop
	tst.b	(a0,d1.w)
	beq.s	.skipa
	cmp.b	(a1,d1.w),d3
	beq.s	.take_action
.skipa	dbf	d1,.actionloop

.nonoteon
	NEGATIV

.take_action
	POSITIV





.in_filter	; d2 = midi status, d3 = first databyte

	tst.b	global_infilters(a5)
	beq.s	.pass

	move.b	d2,d1
	move.b	d1,d0
	lsr.b	#4,d1
	and.w	#$0f,d0
	subq.b	#8,d1
	beq.s	.notefilter
	subq.b	#1,d1
	beq.s	.notefilter
	subq.b	#1,d1
	beq.s	.ppfilter
	subq.b	#1,d1
	beq.s	.csfilter
	subq.b	#1,d1
	beq.s	.pchgfilter
	subq.b	#1,d1
	beq.s	.mpfilter
	subq.b	#1,d1
	beq.s	.pibefilter
	bra.s	.pass

.pibefilter
	move.w	pibe_ifilter(a5),d1
	bra.s	.fcheck

.notefilter
	move.w	note_ifilter(a5),d1
.fcheck	btst	d0,d1
	bne.s	.do_filter

.pass
	POSITIV
.do_filter
	NEGATIV

.ppfilter
	move.w	ppress_ifilter(a5),d1
	bra.s	.fcheck

.pchgfilter
	move.w	pchg_ifilter(a5),d1
	bra.s	.fcheck

.mpfilter
	move.w	mpress_ifilter(a5),d1
	bra.s	.fcheck

.csfilter
	lea	codetab(a5),a0
	move.l	active_csources_m1(a5),d1
.findloop
	cmp.b	(a0)+,d3
	dbeq	d1,.findloop
	bne.s	.pass
	sub.l	active_csources_m1(a5),d1
	neg.l	d1
	lea	cs_ifilters(a5),a0
	IFEQ	mc68020
	adda.w	d1,d1
	move.w	(a0,d1.w),d1
	ELSE
	move.w	(a0,d1.w*2),d1
	ENDC
	bra.s	.fcheck





;==============================================================
;
;  Release serial resources
;
;==============================================================

CloseSerial

	move.l	(a5),a6



;=== Hardware Serial


; free serial-out irq

	tst.b	tbe_set(a5)
	beq.s	.no_tbe

;	move.l	irqptr_out(a5),a0
;	cmpa.l	writeptr_out(a5),a0
;	beq.s	.dontwait

;	moveq	#0,d0
;	moveq	#0,d1
;	move.b	serialoutreadysig(a5),d2
;	bset	d2,d1
;	jsr	SetSignal(a6)

;	IFEQ	executable
;	move.w	#$8001,$dff09a
;	ENDC

;	moveq	#0,d0
;	bset	d2,d0
;	jsr	Wait(a6)
;.dontwait

	move.w	#$0001,$dff09a
	moveq	#0,d0
	suba.l	a1,a1
	jsr	SetIntVector(a6)
	sf	tbe_set(a5)
.no_tbe



; free serial-in irq

	tst.b	rbf_set(a5)
	beq.s	.no_rbf

	move.w	#$0800,$dff09a
	moveq	#11,d0
	suba.l	a1,a1
	jsr	SetIntVector(a6)
	sf	rbf_set(a5)
.no_rbf



; free misc-resource
	move.l	miscres(a5),d0
	beq.s	.nomisc
	move.l	d0,a6
	moveq	#0,d0				; MR_SERIALPORT
	jsr	FreeMiscResource(a6)
	clr.l	miscres(a5)
.nomisc


	move.l	(a5),a6

; free signals

	move.b	tbe2midi_sig(a5),d0
	bmi.s	.notbesig
	jsr	FreeSignal(a6)
	st	tbe2midi_sig(a5)
.notbesig

	move.b	rbf2midi_sig(a5),d0
	bmi.s	.norbfsig
	jsr	FreeSignal(a6)
	st	rbf2midi_sig(a5)
.norbfsig

	move.b	sysex_sig(a5),d0
	bmi.s	.skipfree1
	jsr	FreeSignal(a6)
	st	sysex_sig(a5)
.skipfree1





;=== release midi.library

	move.l	midibas(a5),d0
	beq.s	.nomidi
	move.l	d0,a6

	move.l	midi_sourceroute(a5),d0
	beq.s	.nosroute
	move.l	d0,a0
	jsr	DeleteMRoute(a6)
	clr.l	midi_sourceroute(a5)
.nosroute

	move.l	midi_msource(a5),d0
	beq.s	.nosource
	move.l	d0,a0
	jsr	DeleteMSource(a6)
	clr.l	midi_msource(a5)
.nosource


	move.l	midi_destroute(a5),d0
	beq.s	.nodroute
	move.l	d0,a0
	jsr	DeleteMRoute(a6)
	clr.l	midi_destroute(a5)
.nodroute

	move.l	midi_mdest(a5),d0
	beq.s	.nodest
	move.l	d0,a0
	jsr	DeleteMDest(a6)
	clr.l	midi_mdest(a5)
.nodest

	bsr	CloseMidiLibrary

.nomidi




; close serial device

	bsr	finish_serial_read

	move.l	(a5),a6

;=== Device schlieen
	tst.b	serialdevice_open(a5)
	beq.s	.nodev
	move.l	Serialio_write(a5),a1
	jsr	CloseDevice(a6)
	sf	serialdevice_open(a5)
.nodev


; free write io
	move.l	Serialio_write(a5),d0
	beq.s	.noio_w
	move.l	d0,a0
	jsr	DeleteIORequest(a6)
	clr.l	Serialio_write(a5)
.noio_w
	move.l	SerialReply_write(a5),d0
	beq.s	.noport_w
	move.l	d0,a0
	jsr	DeleteMsgPort(a6)
	clr.l	SerialReply_write(a5)
.noport_w


; free read io
	move.l	Serialio_read(a5),d0
	beq.s	.noio_r
	move.l	d0,a0
	jsr	DeleteIORequest(a6)
	clr.l	Serialio_read(a5)
.noio_r
	move.l	SerialReply_read(a5),d0
	beq.s	.noport_r
	move.l	d0,a0
	jsr	DeleteMsgPort(a6)
	clr.l	SerialReply_read(a5)
.noport_r




; close camd resources

	move.l	camdbas(a5),d0
	beq.s	.nocamd
	move.l	d0,a6

	move.l	camd_midilink_in(a5),d0
	beq.s	.noin
	move.l	d0,a0
	jsr	RemoveMidiLink(a6)
	clr.l	camd_midilink_in(a5)
.noin

	move.l	camd_midilink_out(a5),d0
	beq.s	.noout
	move.l	d0,a0
	jsr	RemoveMidiLink(a6)
	clr.l	camd_midilink_out(a5)
.noout

	move.l	camd_midinode(a5),d0
	beq.s	.nonode
	move.l	d0,a0
	jsr	DeleteMidi(a6)
	clr.l	camd_midinode(a5)
.nonode

	move.l	a6,a1
	move.l	(a5),a6
	jsr	CloseLibrary(a6)
	clr.l	camdbas(a5)
.nocamd

	move.b	camd_sig(a5),d0
	bmi.s	.skipfree2
	jsr	FreeSignal(a6)
	st	camd_sig(a5)
.skipfree2


	rts



init_serial_read
	st	serial_read_pending(a5)

	move.l	serialio_read(a5),a1
	move.w	#2,$1c(a1)
	moveq	#1,d0
	move.l	d0,$24(a1)
	lea	serial_read_char(a5),a0
	move.l	a0,$28(a1)
	jmp	SendIO(a6)



finish_serial_read
	tst.b	serial_read_pending(a5)
	beq.s	.no
	sf	serial_read_pending(a5)

	move.l	serialio_read(a5),a1
	jmp	AbortDeviceJ(a5)

.no	rts





OpenMidiLibrary
	tst.l	midibas(a5)
	bne.s	.pos

	lea	midinam(pc),a1
	moveq	#0,d0
	move.l	(a5),a6
	jsr	OpenLibrary(a6)
	move.l	d0,midibas(a5)
	beq.s	.neg

.pos	POSITIV
.neg	NEGATIV



CloseMidiLibrary
;	tst.b	use_samples(a5)
;	bne.s	.nomidi
;	cmp.b	#1,serial_type(a5)
;	beq.s	.nomidi

	tst.l	midi_mdest(a5)
	bne.s	.nomidi
	tst.l	sample_msource(a5)
	bne.s	.nomidi

	move.l	midibas(a5),d0
	beq.s	.nomidi
	move.l	d0,a1
	move.l	(a5),a6
	jsr	CloseLibrary(a6)
	clr.l	midibas(a5)
.nomidi
	rts







open_samples
	bsr	OpenMidiLibrary
	beq.s	.neg

	move.l	midibas(a5),d1
	beq.s	.neg
	move.l	d1,a6
	move.l	pubnameD(a5),a0
	suba.l	a1,a1
	jsr	CreateMSource(a6)
	move.l	d0,sample_msource(a5)
	beq.s	.neg

	POSITIV
.neg	NEGATIV







close_samples
	move.l	midibas(a5),d1
	beq.s	.nosource
	move.l	sample_msource(a5),d0
	beq.s	.nosource
	move.l	d0,a0
	move.l	d1,a6
	jsr	DeleteMSource(a6)
	clr.l	sample_msource(a5)
.nosource

	bra	CloseMidiLibrary





manage_midimsg

	bra.s	.mjin

.msgloop
	move.l	d0,a1
	move.l	$18(a1),a2
	move.l	$14(a1),d2

	move.l	a1,-(sp)
	bsr	sendmidi_routine
	move.l	(sp)+,a1

	move.l	(a5),a6
.replymsg
	jsr	ReplyMsg(a6)

.mjin	move.l	sendmidi_port(a5),a0
	move.l	(a5),a6
	jsr	GetMsg(a6)
	tst.l	d0
	bne.s	.msgloop

	rts




sendmidi_routine	; a2 = ^midimsg, d2 = length (or negative length for a stream)

	tst.l	d2
	bmi.s	.is_stream
	beq.s	.rts
	bsr	.filtering
	beq.s	.rts
	bra.s	.sendcont
.is_stream
	neg.l	d2

.sendcont
	add.w	d2,current_activity_play(a5)

	move.b	serial_type(a5),d1
	beq.s	.irq
	subq.b	#1,d1
	beq.s	.midilib
	subq.b	#1,d1
	beq.s	.serial_device
	bra	.camd

.rts	rts

;.adr	dc.l	puf

.irq
	tst.b	tbe_set(a5)
	beq.s	.rts

	move.l	a2,serialwrite_ptr(a5)
	move.l	d2,serialwrite_length(a5)

;	move.l	.adr,a0
;	move.l	a2,a1
;.copy	move.b	(a1)+,(a0)+
;	subq.l	#1,d2
;	bne.s	.copy
;	move.l	a0,.adr
;	move.b	#-1,(a0)

; prepare signal

	moveq	#0,d1
	move.b	tbe2midi_sig(a5),d2
	bset	d2,d1
	moveq	#0,d0
	move.l	(a5),a6
	jsr	SetSignal(a6)

; start transfer

	move.w	$dff018,d1
	btst	#13,d1
	beq.s	.notbe
	move.w	#$8001,$dff09c
.notbe

	moveq	#0,d0
	bset	d2,d0
	jmp	Wait(a6)



.midilib

	move.l	midibas(a5),a6
	move.l	midi_msource(a5),d0
	beq.s	.rts
	move.l	d0,a0

	moveq	#3,d0
	cmp.l	d0,d2
	bhi.s	.stream

	move.l	a2,a1
	jmp	PutMidiMsg(a6)

.stream
	move.l	d2,d1
	move.l	d1,d0
	suba.l	a1,a1
	jmp	PutMidiStream(a6)



.serial_device

	move.l	serialio_write(a5),d0
	beq.s	.rts
	move.l	d0,a1
	move.w	#3,$1c(a1)
	move.l	d2,$24(a1)
	move.l	a2,$28(a1)
	move.l	(a5),a6
	jmp	DoIO(a6)




.camd
	move.l	camdbas(a5),d0
	beq.s	.rts
	move.l	d0,a6
	lea	(a2,d2.l),a3

.camdloop
	moveq	#0,d0
	move.b	(a2)+,d0
	move.b	d0,d1
	lsr.b	#4,d1
	sub.b	#$c,d1
	bcs.s	.3_bytes	; keypress, parameter
	subq.b	#2,d1
	bcs.s	.2_bytes	; program, monopress
	beq.s	.3_bytes	; pitchbend

; sysex
;	cmp.b	#$f8,d0
;	bcc.s	.1_byte
	cmp.b	#$f0,d0
	beq.s	.sysex
	cmp.b	#$f1,d0
	beq.s	.2_bytes	; timecode
	cmp.b	#$f2,d0
	beq.s	.3_bytes	; songpos
	cmp.b	#$f3,d0
	beq.s	.2_bytes	; songselect

.1_byte
	ror.l	#8,d0
	bra.s	.putm

.2_bytes
	rol.l	#8,d0
	move.b	(a2)+,d0
	swap	d0
	bra.s	.putm

.3_bytes
	rol.l	#8,d0
	move.b	(a2)+,d0
	rol.l	#8,d0
	move.b	(a2)+,d0
	rol.l	#8,d0

.putm	move.l	camd_midilink_out(a5),a0
	jsr	PutMidi(a6)

.nextcamd
	cmpa.l	a3,a2
	bcs.s	.camdloop

	rts


.sysex
	lea	-1(a2),a1
	move.l	camd_midilink_out(a5),a0
	jsr	PutSysEx(a6)

.sysexloop
	cmp.b	#$f7,(a2)+
	beq.s	.sysexout
	cmp.l	a3,a2
	bcs.s	.sysexloop
.sysexout

	bra.s	.nextcamd




.filtering	; a2 = ^midimsg
		; returns: pos = data is passed, neg = data is filtered

	tst.b	global_outfilters(a5)
	beq.s	.no_filtering

	move.b	(a2),d0
	move.b	d0,d1
	and.w	#$0f,d0
	lsr.b	#4,d1
	subq.b	#8,d1
	beq.s	.notefilter
	subq.b	#1,d1
	beq.s	.notefilter
	subq.b	#1,d1
	beq.s	.ppfilter
	subq.b	#1,d1
	beq.s	.csfilter
	subq.b	#1,d1
	beq.s	.pchgfilter
	subq.b	#1,d1
	beq.s	.mpfilter
	subq.b	#1,d1
	beq.s	.pibefilter
	bra.s	.no_filtering

.mpfilter
	move.w	mpress_ofilter(a5),d1
	bra.s	.fcheck

.pchgfilter
	move.w	pchg_ofilter(a5),d1
.fcheck	btst	d0,d1
	bne.s	.back
.no_filtering
.not_3_bytes
	POSITIV
.back	NEGATIV


.pibefilter
	move.w	pibe_ofilter(a5),d1
	bra.s	.fcheck

.notefilter
	move.w	note_ofilter(a5),d1
	bra.s	.fcheck

.ppfilter
	move.w	ppress_ofilter(a5),d1
	bra.s	.fcheck

.csfilter
	moveq	#0,d1
	move.b	1(a2),d1
;	lea	codetab(a5),a0
;	move.l	active_csources_m1(a5),d0
;.findloop
;	cmp.b	(a0)+,d1
;	dbeq	d0,.findloop
;	bne.s	.no_filtering
;	sub.l	active_csources_m1(a5),d0
;	neg.l	d0
	lea	cs_ofilters(a5),a0
	IFEQ	mc68020
	add.l	d1,d1
	move.w	(a0,d1.l),d1
	ELSE
	move.w	(a0,d1.l*2),d1
	ENDC
	bra.s	.fcheck





main_todo_from_midi

	move.l	todo_replyport_midi(a5),a2
	bra.s	main_todo

main_todo_from_player

	move.l	todo_replyport_player(a5),a2

main_todo	; d0 = todo value, a2 = replyport

	move.l	d0,d2

	moveq	#$14+4,d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a1

	move.l	a1,a0
	clr.l	(a0)+
	clr.l	(a0)+
	move.b	#7,(a0)+
	clr.b	(a0)+
	clr.l	(a0)+
	move.l	a2,(a0)+
	move.w	#$14+4,(a0)+
	move.l	d2,(a0)

	move.l	todo_port(a5),a0
	jmp	PutMsg(a6)

.neg	rts



todo_reply_midi

	move.l	todo_replyport_midi(a5),a2
	bra.s	todo_reply

todo_reply_player

	move.l	todo_replyport_player(a5),a2

todo_reply	; a2 = replyport to clear

	bra.s	.jin
.loop
	move.l	d0,a1
	moveq	#0,d0
	move.w	$12(a1),d0
	jsr	FreeMem(a6)
.jin	move.l	a2,a0
	move.l	(a5),a6
	jsr	GetMsg(a6)
	tst.l	d0
	bne.s	.loop
	rts



