;APS000091AE00018D890000000000000000000000000000000000000000000000000000000000000000
;==============================================================
;
;
;               K E R N   R O U T I N E N
;
;
;==============================================================


CorrectPattern
	move.l	patterntab(a5),a0
	move.l	currentpattern(a5),d0
	IFEQ	mc68020
	lsl.l	#2,d0
	move.l	(a0,d0.l),a0
	ELSE
	move.l	(a0,d0.l*4),a0
	ENDC
	move.l	a0,currentpatternA(a5)
	move.l	pt_events(a0),events(a5)
	rts


CorrectChannel
;	move.l	currentpatternA(a5),a0
;	move.w	currentchannel(a5),d0
;	IFEQ	mc68020
;	lsl.w	#2,d0
;	move.l	pt_channels-4(a0,d0.w),currentchannelA(a5)
;	ELSE
;	move.l	pt_channels-4(a0,d0.w*4),currentchannelA(a5)
;	ENDC
	rts


GetPatternAtPosition	; d1.l = position
			; returns: a0 = pattern-addr at the given position,
			;          d1 = pattern-number
			;          pos/neg

	move.l	positionsA(a5),a0
	moveq	#0,d0
	IFEQ	mc68020
	add.l	d1,d1
	move.w	(a0,d1.l),d0
	ELSE
	move.w	(a0,d1.l*2),d0
	ENDIF
	move.l	d0,d1
	bsr.s	GetNewPattern
	beq.s	.neg
	POSITIV
.neg	NEGATIV



;GetPattern	; zurck in a0: patternA, d0=a0
;	move.l	currentpattern(a5),d0


GetNewPattern	; d0.l=pattern
		; returns: a0=PatternA, pos=found, neg=not found
	bsr.s	GetPatternAddr
	beq.s	.neg
	move.l	(a0),d0
	beq.s	.neg
	move.l	d0,a0
	POSITIV
.neg	NEGATIV


GetPatternAddr	; d0.l=pattern
		; returns: a0=^PatternA, pos/neg
	cmp.l	patterntablen(a5),d0
	bcc.s	.neg
	move.l	patterntab(a5),a0
	IFEQ	mc68020
	lsl.l	#2,d0
	adda.l	d0,a0
	ELSE
	lea	(a0,d0.l*4),a0
	ENDC
	POSITIV
.neg	NEGATIV


GetCurrentChannelAddr	; zurck: a0=^Channel (in Pattern)
	move.w	currentchannel(a5),d0

GetChannelAddr	; d0.w = channel
		; zurck: a0=^Channel (in Pattern)

	move.l	currentpatternA(a5),a0
	IFEQ	mc68020
	lsl.w	#2,d0
	lea	pt_channels-4(a0,d0.w),a0
	ELSE
	lea	pt_channels-4(a0,d0.w*4),a0
	ENDC
	rts



GetChannelResolution	; [d0 = channel]
			; returns: d0.l = resolution

	move.w	currentchannel(a5),d0

GetAnyChannelResolution
	bsr.s	GetAnyChannel
	beq.s	.nochan
	moveq	#0,d0
	move.w	ch_scale(a0),d0
	bra.s	.ccont
.nochan	move.l	defreso(a5),d0
.ccont	rts



GetChannel	; [d0.w = channel]
		; returns: a0,d0 = ^channel or NULL

	move.w	currentchannel(a5),d0

GetAnyChannel
	bsr.s	GetChannelAddr
	move.l	(a0),a0
	move.l	a0,d0
	rts



GetOrAllocChannel	; [d0.w = channel]
			; returns: a0 = ^channel
			;          pos/neg

	movem.l	d0/a2,-(sp)

	move.w	currentchannel(a5),d0
	bsr.s	GetChannelAddr
	move.l	a0,a2
	move.l	(a2),d0
	bne.s	.exists

	bsr	AllocChannel
	beq.s	.neg

	move.l	a0,(a2)
	bra.s	.pos

.exists
	move.l	d0,a0

.pos	movem.l	(sp)+,d0/a2
	POSITIV

.neg	suba.l	a0,a0
	movem.l	(sp)+,d0/a2
	NEGATIV






GetBPMTrack	; returns: a0,d0 = ^bpmtrack or NULL

	move.l	currentpatternA(a5),a0
	move.l	pt_bpmtrack(a0),a0
	move.l	a0,d0
	rts




GetOrAllocBPMTrack	; returns: a0 = ^track
			;          pos/neg

	movem.l	d2/a2,-(sp)

	move.l	currentpatternA(a5),a2
	move.l	pt_bpmtrack(a2),d0
	bne.s	.exists

	move.l	pt_events(a2),d0
	add.l	d0,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,a0
	move.l	d0,pt_bpmtrack(a2)
	beq.s	.neg

	move.l	pt_events(a2),d1
	move.w	#BPM_stay,d2
.fillloop
	move.w	d2,(a0)+
	subq.l	#1,d1
	bne.s	.fillloop

.exists
	move.l	d0,a0

.pos	movem.l	(sp)+,d2/a2
	POSITIV

.neg	movem.l	(sp)+,d2/a2
	NEGATIV






GetOrAllocPresetTrack	; [d0.w = channel]
			; returns: a0 = ^presettrack
			;          pos/neg

	movem.l	d0/a2,-(sp)

	bsr	GetOrAllocChannel
	beq.s	.neg
	move.l	a0,a2

	move.l	ch_ptrack(a2),d0
	bne.s	.exists

	move.l	currentpatternA(a5),a0
	move.l	pt_events(a0),d0
	add.l	d0,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,a0
	move.l	d0,ch_ptrack(a2)
	beq.s	.neg

	move.l	a0,a1
	move.l	currentpatternA(a5),a2
	move.l	pt_events(a2),d0
	move.w	#Preset_stay,d1
.fillloop
	move.w	d1,(a1)+
	subq.l	#1,d0
	bne.s	.fillloop
	bra.s	.pos

.exists
	move.l	d0,a0

.pos	movem.l	(sp)+,d0/a2
	POSITIV

.neg	movem.l	(sp)+,d0/a2
	NEGATIV




GetPresetTrack	; [d0.w = channel]
		; returns: a0,d0 = ^presettrack or NULL

	bsr	GetChannel
	beq.s	.neg
	move.l	ch_ptrack(a0),a0
	move.l	a0,d0
	rts
.neg	NEGATIV






GetOrAllocCSourceTrackParameterData	; d0.w = cs parameter number
					; returns: a0,d0 = ^track structure or NULL

	bsr.s	GetOrAllocCSourceTrackParameter
	beq.s	.neg
	lea	cs_data(a0),a0
	move.l	a0,d0
	rts
.neg	NEGATIV



GetOrAllocCSourceTrackData	; d0.w = cs order number
				; returns: a0,d0 = ^track structure or NULL

	bsr.s	GetOrAllocCSourceTrack
	beq.s	.neg
	lea	cs_data(a0),a0
	move.l	a0,d0
	rts
.neg	NEGATIV



GetOrAllocCSourceTrack	; d0.w = cs order number
			; returns: a0 = ^track structure
			;          pos/neg

	lea	codetab(a5),a0
	move.b	(a0,d0.w),d0


GetOrAllocCSourceTrackParameter	; d0.l = cs number (0...128) (128 = mptrack)
				;        (the parameter number)
				; returns: a0 = ^track structure
				;          pos/neg

	movem.l	d0/a2,-(sp)

	bsr	GetOrAllocChannel
	beq.s	.neg

	move.l	(sp),d0
	lea	ch_cstracks(a0),a0
	bra.s	.jin
.findloop
	move.l	d1,a0
	cmp.b	cs_parameter(a0),d0
	beq.s	.found
	bcs.s	.newtrack
.jin	move.l	a0,a2		; previous track
	move.l	(a0),d1
	bne.s	.findloop

.newtrack
	move.l	currentpatternA(a5),a0
	moveq	#cs_sizeof,d0
	add.l	pt_events(a0),d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,a0
	tst.l	d0
	beq.s	.neg

	move.l	(a2),a1
	move.l	a1,(a0)
	move.l	a0,(a2)
	move.l	a2,4(a0)
	move.l	a1,d0		; next track
	beq.s	.nonext
	move.l	a0,4(a1)
.nonext

	st	cs_onoff(a0)
	move.l	(sp),d1
	move.b	d1,cs_parameter(a0)

	lea	cs_data(a0),a1
	move.l	currentpatternA(a5),a2
	move.l	pt_events(a2),d0
	move.b	#CS_stay,d1
.fillloop
	move.b	d1,(a1)+
	subq.l	#1,d0
	bne.s	.fillloop


.found	movem.l	(sp)+,d0/a2
	POSITIV

.neg	movem.l	(sp)+,d0/a2
	NEGATIV






GetCSourceTrackData	; d0.w = cs order number
			;        (NOT the parameter number but the order number)
			; returns: a0,d0 = ^track structure or NULL

	bsr.s	GetCSourceTrack
	beq.s	.neg
	lea	cs_data(a0),a0
	move.l	a0,d0
	rts
.neg	NEGATIV

GetCSourceTrackParameterData	; d0.w = cs parameter number
				; returns: a0,d0 = ^track structure or NULL

	bsr.s	GetCSourceTrackParameter
	beq.s	.neg
	lea	cs_data(a0),a0
	move.l	a0,d0
	rts
.neg	NEGATIV



GetCSourceTrack	; d0.w = cs order number
		;        (NOT the parameter number but the order number)
		; returns: a0,d0 = ^track structure or NULL

	lea	codetab(a5),a0
	move.b	(a0,d0.w),d0


GetCSourceTrackParameter	; d0.l = cs number (0...128) (128 = mptrack)
				;        (the parameter number)

	movem.l	d0,-(sp)

	bsr	GetChannel
	beq.s	.neg

	move.l	(sp),d0
	lea	ch_cstracks(a0),a0
	bra.s	.jin
.findloop
	move.l	d1,a0
	cmp.b	cs_parameter(a0),d0
	beq.s	.found
	bcs.s	.neg
.jin	move.l	(a0),d1
	bne.s	.findloop

.neg	move.l	(sp)+,d0
	suba.l	a0,a0
	NEGATIV

.found	move.l	(sp)+,d1
	move.l	a0,d0
	rts





GetOrAllocPibeTrack	; [d0.w = channel]
			; returns: a0 = ^presettrack
			;          pos/neg

	movem.l	d0/a2,-(sp)

	bsr	GetOrAllocChannel
	beq.s	.neg
	move.l	a0,a2

	move.l	ch_pbtrack(a2),d0
	bne.s	.exists

	move.l	currentpatternA(a5),a0
	move.l	pt_events(a0),d0
	add.l	d0,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,a0
	move.l	d0,ch_pbtrack(a2)
	beq.s	.neg

	st	ch_pb_onoff(a2)

	move.l	a0,a1
	move.l	currentpatternA(a5),a2
	move.l	pt_events(a2),d0
	move.w	#PB_stay,d1
.fillloop
	move.w	d1,(a1)+
	subq.l	#1,d0
	bne.s	.fillloop
	bra.s	.pos

.exists
	move.l	d0,a0

.pos	movem.l	(sp)+,d0/a2
	POSITIV

.neg	movem.l	(sp)+,d0/a2
	NEGATIV




GetPibeTrack	; [d0.w = channel]
		; returns: a0,d0 = ^presettrack or NULL

	bsr	GetChannel
	beq.s	.neg
	move.l	ch_pbtrack(a0),a0
	move.l	a0,d0
	rts
.neg	NEGATIV






GetOrAllocTrackData	; d0.l = track number (0...)
			; returns: a0 = ^track data
			;          pos/neg

	bsr.s	GetOrAllocTrack
	beq.s	.neg
	lea	tr_data(a0),a0
	move.l	a0,d0
	rts
.neg	NEGATIV


GetOrAllocTrack	; d0.l = track number (0...)
		; returns: a0 = ^track structure
		;          pos/neg

	movem.l	d0/a2,-(sp)

	bsr	GetOrAllocChannel
	beq.s	.neg

	move.l	(sp),d0
	lea	ch_tracks(a0),a0
	bra.s	.jin
.findloop
	move.l	d1,a0
	cmp.w	tr_number(a0),d0
	beq.s	.found
	bcs.s	.newtrack
.jin	move.l	a0,a2		; previous track
	move.l	(a0),d1
	bne.s	.findloop

.newtrack
	move.l	currentpatternA(a5),a0
	move.l	pt_events(a0),d0
	lsl.l	#2,d0
	moveq	#tr_sizeof,d1
	add.l	d1,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,a0
	tst.l	d0
	beq.s	.neg

	move.l	(a2),a1
	move.l	a1,(a0)
	move.l	a0,(a2)
	move.l	a2,4(a0)
	move.l	a1,d0		; next track
	beq.s	.nonext
	move.l	a0,4(a1)
.nonext

	st	tr_onoff(a0)
	move.l	(sp),d1
	move.w	d1,tr_number(a0)

	lea	tr_data(a0),a1
	move.l	currentpatternA(a5),a2
	move.l	pt_events(a2),d0
	move.l	#track_def_entry,d1
.fillloop
	move.l	d1,(a1)+
	subq.l	#1,d0
	bne.s	.fillloop


.found	movem.l	(sp)+,d0/a2
	POSITIV

.neg	movem.l	(sp)+,d0/a2
	NEGATIV





GetTrackData	; d0.l = track number (0...)
		; returns: a0,d0 = ^track data or NULL

	bsr.s	GetTrack
	beq.s	.neg
	lea	tr_data(a0),a0
	move.l	a0,d0
	rts
.neg	NEGATIV


GetTrack	; d0.l = track number (0...)
		; returns: a0,d0 = ^track structure or NULL

	move.l	d0,-(sp)

	bsr	GetChannel
	beq.s	.neg

	move.l	(sp),d1
	lea	ch_tracks(a0),a0
	bra.s	.jin
.findloop
	move.l	d0,a0
	cmp.w	tr_number(a0),d1
	beq.s	.found
	bcs.s	.neg
.jin	move.l	(a0),d0
	bne.s	.findloop

.neg	move.l	(sp)+,d0
	suba.l	a0,a0
	NEGATIV

.found	move.l	(sp)+,d1
	move.l	a0,d0
	rts







;==============================================================
;
;  Pack Channel
;
;==============================================================

;ACHTUNG: die Routine packt IN die Worktracks!!!!!
;         und kopiert dann alles in neuen Speicher!!!!!!!!!
;         die Worktracks sind danach also berschrieben!!!!!!
packchannel

	rts


	IFEQ	1

;======================================= Zuerst der BPM Track

	tst.b	bpmtrackchanged(a5)
	beq	.emptyb
	sf	bpmtrackchanged(a5)

;	bsr	recalc_bpm

	move.l	currentpatternA(a5),a3
;=== BPMTrack freigeben
	move.l	a3,a0
	jsr	FreeBPMTrackJ(a5)

	move.l	bpmworktrack(a5),a4
	move.l	a4,a0		; a0=^source
	move.l	a4,a1		; a1=^destination
	moveq	#0,d2		; d2=running-word
	moveq	#BPM_stay,d3
	move.l	events(a5),d1
.bpmloop
	cmp.w	(a0)+,d3
	bne.s	.nozero
	subq.w	#1,d2
	bra.s	.weiter
.nozero	tst.w	d2
	beq.s	.nopak
	move.w	d2,(a1)+
	moveq	#0,d2
.nopak	move.w	-2(a0),(a1)+
.weiter	subq.l	#1,d1
	bne.s	.bpmloop
;=== leerer Track ?
	cmpa.l	a4,a1
	beq.s	.emptyb
	tst.w	d2
	beq.s	.lastb
	move.w	d2,(a1)+
;=== track allocaten
.lastb	move.l	a1,d0
	sub.l	a4,d0
	move.l	d0,d2
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,pt_bpmtrack(a3)
	beq	.all_done
	move.l	d0,a1
	move.l	a4,a0
.cloopb	move.w	(a0)+,(a1)+
	subq.l	#2,d2
	bne.s	.cloopb

.emptyb






;================================ Channelvorbereitung:
;=== Falls der Channel leer ist, wird ein leerer Channel allocated.
	move.l	currentchannelA(a5),d0
	bne.s	.weita
	bsr	AllocChannel
	move.l	a0,-(sp)
	bsr	GetCurrentChannelAddr
	move.l	(sp)+,d0
	move.l	d0,(a0)
	move.l	d0,currentchannelA(a5)

.weita
	move.l	d0,a3	; Channel

	tst.b	ptrackchanged(a5)
	beq	.empty1
	sf	ptrackchanged(a5)
;================================ presettrack wird freigegeben.
	move.l	a3,a0
	jsr	FreePTrackJ(a5)

;	bsr	recalc_preset

;================================ pworktrack packen
	move.l	pworktrack(a5),a0	; source
	move.l	a0,a1			; destination
	moveq	#0,d2
	moveq	#Preset_stay,d3
	move.l	events(a5),d1
.chanloop0
	cmp.w	(a0)+,d3
	bne.s	.ne0
	subq.w	#1,d2
	bra.s	.check0
.ne0	tst.w	d2
	beq.s	.not0
	move.w	d2,(a1)+
	moveq	#0,d2
.not0	move.w	-2(a0),(a1)+
.check0	subq.l	#1,d1
	bne.s	.chanloop0
;=== leerer ctrack ?
	cmpa.l	pworktrack(a5),a1
	beq.s	.empty1
;=== Track besitzt mindestens einen Event
	tst.w	d2
	beq.s	.last0
	move.w	d2,(a1)+
;================================ ptrack allocaten
.last0	move.l	a1,d0
	sub.l	pworktrack(a5),d0
	move.l	d0,d2
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,ch_ptrack(a3)
	beq	.all_done
;=== kopieren
	move.l	d0,a1
	move.l	pworktrack(a5),a0
	move.l	d2,d0
	jsr	CopyMem(a6)

.empty1

	tst.b	pbtrackchanged(a5)
	beq	.empty2
	sf	pbtrackchanged(a5)
;================================ pitch track wird freigegeben.
	move.l	a3,a0
	jsr	FreePBTrackJ(a5)

;	bsr	recalc_pitchbend

;================================ pbworktrack packen
	move.l	pbworktrack(a5),a0	; source
	move.l	a0,a1			; destination
	moveq	#0,d2
	move.w	#PB_stay,d3
	move.l	events(a5),d1
.chanloop1
	cmp.w	(a0)+,d3
	bne.s	.ne1
	subq.w	#1,d2
	bra.s	.check1
.ne1	tst.w	d2
	beq.s	.not1
	move.w	d2,(a1)+
	moveq	#0,d2
.not1	move.w	-2(a0),(a1)+
.check1	subq.l	#1,d1
	bne.s	.chanloop1
;=== leerer ctrack ?
	cmpa.l	pbworktrack(a5),a1
	beq.s	.empty2
;=== Track besitzt mindestens einen Event
	tst.w	d2
	beq.s	.last1
	move.w	d2,(a1)+
;================================ mptrack allocaten
.last1	move.l	a1,d0
	sub.l	pbworktrack(a5),d0
	move.l	d0,d2
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,ch_pbtrack(a3)
	beq	.all_done
;=== kopieren
	move.l	d0,a1
	move.l	pbworktrack(a5),a0
	move.l	d2,d0
	jsr	CopyMem(a6)

	move.b	currentpb_onoff(a5),ch_pb_onoff(a3)

.empty2

	tst.b	mptrackchanged(a5)
	beq	.empty3
	sf	mptrackchanged(a5)
;================================ mptrack wird freigegeben.
	move.l	a3,a0
	jsr	FreeMPTrackJ(a5)

;	bsr	recalc_mpress

;================================ mpworktrack packen
	move.l	mpworktrack(a5),a0	; source
	move.l	a0,a1			; destination
	moveq	#0,d2
	move.b	#cs_stay,d3
	move.l	events(a5),d1
.chanloop2
	cmp.b	(a0),d3
	bne.s	.ne2
	addq.w	#1,a0
	subq.b	#1,d2
	bmi.s	.check2
	addq.b	#1,d2
	move.b	d2,(a1)+
	moveq	#-1,d2
	bra.s	.check2
.ne2	tst.b	d2
	beq.s	.not2
	move.b	d2,(a1)+
	moveq	#0,d2
.not2	move.b	(a0)+,(a1)+
.check2	subq.l	#1,d1
	bne.s	.chanloop2
;=== leerer ctrack ?
	move.l	mpworktrack(a5),a0
.tloop2	cmpa.l	a0,a1
	beq.s	.empty2
	tst.b	(a0)+
	bmi.s	.tloop2
;=== Track besitzt mindestens einen Event
	tst.b	d2
	beq.s	.last2
	move.b	d2,(a1)+
;================================ mptrack allocaten
.last2	move.l	a1,d0
	sub.l	mpworktrack(a5),d0
	move.l	d0,d2
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,ch_mptrack(a3)
	beq	.all_done
;=== kopieren
	move.l	d0,a1
	move.l	mpworktrack(a5),a0
	move.l	d2,d0
	jsr	CopyMem(a6)

	move.b	currentmp_onoff(a5),ch_mp_onoff(a3)

.empty3

;============================== controltracks packen
	clr.w	ch_numcs(a3)
	lea	ch_csources(a3),a3
	move.l	cworktracks(a5),a4
	move.l	(a5),a6
	moveq	#0,d7
.outerchanloopc
	move.l	ctrackchanged(a5),a0
	tst.b	(a0,d7.l)
	beq	.notchangedc
	sf	(a0,d7.l)

;	move.l	a4,a0
;	bsr	recalc_csource

	move.l	(a3),d0
	beq.s	.nomorec
	move.l	d0,a0
	lea	codetab(a5),a1
	move.b	(a1,d7.l),d0
	cmp.b	cs_parameter(a0),d0
	bne.s	.nofreec

;=== Track aus Liste entfernen und freigeben
;=== a3 zeigt auf das vorige Element !!!
	move.l	(a3),a1
	move.l	(a1),(a3)
	jsr	MyFreeVecJ(a5)

.nomorec
.nofreec
;=== Packen
	move.b	#cs_stay,d3
	move.l	a4,a0	; source
	move.l	a4,a1	; destination
	moveq	#0,d2
	move.l	events(a5),d1
.innerchanloopc
	cmp.b	(a0)+,d3
	bne.s	.nec
	subq.b	#1,d2
	bmi.s	.checkc
	addq.b	#1,d2
	move.b	d2,(a1)+
	moveq	#-1,d2
	bra.s	.checkc
.nec	tst.b	d2
	beq.s	.nopc
	move.b	d2,(a1)+
	moveq	#0,d2
.nopc	move.b	-1(a0),(a1)+
.checkc	subq.l	#1,d1
	bne.s	.innerchanloopc
;=== Ende der Packschleife
	move.l	a4,a0
.tloopc	cmpa.l	a0,a1
	beq.s	.nodatac
	tst.b	(a0)+
	bmi.s	.tloopc

	tst.b	d2
	beq.s	.lastc
	move.b	d2,(a1)+
;=== track allocaten
.lastc	move.l	a1,d0
	sub.l	a4,d0
	move.l	d0,d2
	moveq	#cs_sizeof,d1
	add.l	d1,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq	.all_done
	move.l	d0,a1

	move.l	(a3),(a1)	;  Track in die Liste einfgen
	move.l	a1,(a3)

	lea	codetab(a5),a0
	move.b	(a0,d7.l),cs_parameter(a1)
	lea	cs_onoffs(a5),a0
	move.b	(a0,d7.l),cs_onoff(a1)
	move.l	d2,cs_datasize(a1)
	move.l	a4,a0
	lea	cs_data(a1),a1
	move.l	d2,d0
	jsr	CopyMem(a6)
.nodatac

.notchangedc
	adda.l	events(a5),a4

	move.l	(a3),d0
	beq.s	.lasttrc
	move.l	d0,a0
	lea	codetab(a5),a1
	move.b	(a1,d7.l),d0
	cmp.b	cs_parameter(a0),d0
	bne.s	.lasttrc
	move.l	a0,a3
	move.l	currentchannelA(a5),a0
	addq.w	#1,ch_numcs(a0)

.lasttrc
	addq.l	#1,d7
	cmp.l	active_csources(a5),d7
	bcs	.outerchanloopc




;==== Die brigen Ctrack-Daten bernehmen
	move.l	currentchannelA(a5),a3

;	tst.b	globalresoflag(a5)
;	bne.s	.global
	move.w	pattscale+2(a5),ch_scale(a3)
;.global



;============================== tracks packen
	clr.w	ch_numtracks(a3)
	lea	ch_tracks(a3),a3
	move.l	worktracks(a5),a4
	move.l	(a5),a6
	moveq	#0,d7
.outerchanloop
	move.l	trackchanged(a5),a0
	tst.b	(a0,d7.w)
	beq	.notchanged
	sf	(a0,d7.w)

	move.l	(a3),d0
	beq.s	.nomore
	move.l	d0,a0
	cmp.w	tr_number(a0),d7
	bne.s	.nofree

;=== Track aus Liste entfernen und freigeben
;=== a3 zeigt auf das vorige Element !!!
	move.l	(a3),a1
	move.l	(a1),(a3)
	jsr	MyFreeVecJ(a5)

.nomore
.nofree
;=== Packen
	move.l	a4,a0	; source
	move.l	a4,a1	; destination
	move.l	#track_def_entry,d3
	moveq	#0,d2
	move.l	events(a5),d1
.innerchanloop
	cmp.l	(a0),d3
	bne.s	.neb
	subq.w	#1,d2
	addq.w	#wd_sizeof,a0
	bra.s	.checkb
.neb	tst.w	d2
	beq.s	.nopa
	move.w	d2,(a1)+
	moveq	#0,d2
.nopa	move.l	(a0)+,(a1)+
.checkb	subq.l	#1,d1
	bne.s	.innerchanloop
;=== Ende der Packschleife
	cmpa.l	a4,a1
	beq.s	.nodata
	tst.w	d2
	beq.s	.last
	move.w	d2,(a1)+
;=== track allocaten
.last	move.l	a1,d0
	sub.l	a4,d0
	move.l	d0,d2
	moveq	#tr_sizeof,d1
	add.l	d1,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq	.all_done
	move.l	d0,a1

	move.l	(a3),(a1)	; Track in die Liste einfgen
	move.l	a1,(a3)

	move.w	d7,tr_number(a1)
	move.l	current_onoffs(a5),a0
	move.b	(a0,d7.w),tr_onoff(a1)
	move.l	d2,tr_datasize(a1)
	move.l	a4,a0
	lea	tr_data(a1),a1
.cloop1	move.w	(a0)+,(a1)+
	subq.l	#2,d2
	bne.s	.cloop1
.nodata

.notchanged
	move.l	events(a5),d0
	lsl.l	#2,d0	; =mulu #wd_sizeof,d0
	adda.l	d0,a4

	move.l	(a3),d0
	beq.s	.lasttr
	move.l	d0,a0
	cmp.w	tr_number(a0),d7
	bne.s	.lasttr
	move.l	a0,a3
	move.l	currentchannelA(a5),a0
	addq.w	#1,ch_numtracks(a0)

.lasttr	addq.w	#1,d7
	cmp.w	maxtracks+2(a5),d7
	bcs	.outerchanloop


.all_done

;=== jetzt checken, ob alle Tracks samt Controltracks leer sind!
;=== wenn ja -> Channel freigeben
	move.l	currentchannelA(a5),a1
	bsr.s	channel_is_filled
	bne.s	.rts

	move.l	defreso(a5),d0
	cmp.w	ch_scale(a1),d0
	bne.s	.rts

;	move.l	currentpatternA(a5),a0
;	move.l	defpatternsize(a5),d0
;	cmp.l	pt_events(a0),d0
;	bne.s	.rts

;=== channel freigeben
	moveq	#ch_sizeof,d0
	move.l	(a5),a6
	jsr	FreeMem(a6)
	bsr	GetCurrentChannelAddr
	clr.l	(a0)
	clr.l	currentchannelA(a5)

.rts	rts




	ENDC




;==============================================================
;
;  Compression Recalculation (doppelte Werte auf STAY setzen)
;
;==============================================================

;=== MPress
;recalc_mpress
;	move.l	mpworktrack(a5),a0

;	bra.s	recalc_1byte



;=== Controlsource
recalc_csource	; a0=^cworktrack

recalc_1byte
	move.l	a0,a1
	adda.l	events(a5),a1

	move.b	#cs_Stay,d2
.nextcs	move.b	(a0)+,d1
	cmp.b	d2,d1
	bne.s	.csloop
	cmpa.l	a1,a0
	bcs.s	.nextcs
.csout	rts
.csloop
	cmpa.l	a1,a0
	bcc.s	.csout
	cmp.b	(a0),d1
	bne.s	.grabcs
	move.b	d2,(a0)+
	bra.s	.csloop
.grabcs	move.b	(a0)+,d0
	cmp.b	d0,d2
	beq.s	.csloop
	move.b	d0,d1
	bra.s	.csloop



;=== BPM Track
recalc_bpm
	bsr	GetBPMTrack
	beq.s	.rts
	moveq	#BPM_Stay,d2
	bra.s	recalc_2byte

.rts	rts


;=== Preset Track
;recalc_preset
;	move.l	pworktrack(a5),a0
;	moveq	#Preset_Stay,d2
;	bra.s	recalc_2byte



;=== Pitchbend
recalc_pitchbend
	jsr	GetPibeTrackJ(a5)
	beq.s	.rts
	move.w	#PB_Stay,d2
	bra.s	recalc_2byte
.rts	rts

recalc_2byte
	move.l	events(a5),d0
	add.l	d0,d0
	lea	(a0,d0.l),a1

.nextpb	move.w	(a0)+,d1
	cmp.w	d2,d1
	bne.s	.pbloop
	cmpa.l	a1,a0
	bcs.s	.nextpb
.pbout	rts
.pbloop
	cmpa.l	a1,a0
	bcc.s	.pbout
	cmp.w	(a0),d1
	bne.s	.grabpb
	move.w	d2,(a0)+
	bra.s	.pbloop
.grabpb	move.w	(a0)+,d0
	cmp.w	d0,d2
	beq.s	.pbloop
	move.w	d0,d1
	bra.s	.pbloop







;==============================================================
;
;  Depack Channel
;
;==============================================================

;=== ACHTUNG!!!!!!!!!!!!!!!!!!!!!!!1
; die depackroutine prft, ob die events(a5) sich verndert
; haben!!!! und allocated entsprechen die worktracks neu!


depackchannel

	rts


	IFEQ	1

	move.l	currentpatternA(a5),-(sp)


	move.l	(sp),a0
	move.l	pt_events(a0),d0
	cmp.l	events(a5),d0
	beq.s	.nochange
;	move.l	d0,-(sp)
;=== Alte Worktracks freigeben
;	jsr	FreeAllWorkTracksJ(a5)
;=== Neue Worktracks
;	move.l	(sp)+,events(a5)
	move.l	d0,events(a5)
	jsr	ReAllocWorktracksJ(a5)

.nochange


;=== Zuerst der BPM-Track
	move.l	(sp)+,a0
	move.l	pt_bpmtrack(a0),d0
	bne.s	.fillbpmtrack

	bsr	defaultbpmtrack
	bra.s	.afterbpm

.fillbpmtrack
	st	bpm_state(a5)
;=== entpacken
	move.l	d0,a0			; source
	move.l	bpmworktrack(a5),a1	; destination
	moveq	#BPM_stay,d3
	move.l	a0,a2
	adda.l	-(a2),a2		; compare-dest
.depackloopb
	move.w	(a0)+,d0
	bpl.s	.asisb
.putb	move.w	d3,(a1)+
	addq.w	#1,d0
	bne.s	.putb
	bra.s	.relopb
.asisb	move.w	d0,(a1)+
.relopb	cmpa.l	a2,a0
	bcs.s	.depackloopb


.afterbpm
	move.l	currentchannelA(a5),d0
	beq	.defaultchannel
	move.l	d0,a4

;	tst.b	globalresoflag(a5)
;	bne.s	.global
	move.w	ch_scale(a4),pattscale+2(a5)
;	bra.s	.gcont
;.global	move.l	defreso(a5),pattscale(a5)
;.gcont

	jsr	check_eventposJ(a5)


;======================================== Presettrack depacken
	move.l	ch_ptrack(a4),d0
	bne.s	.itis0

	bsr	defaultptrack
	bra.s	.notis1

;=== entpacken
.itis0	st	preset_state(a5)

	move.l	pworktrack(a5),a1	; destination
	move.l	d0,a0			; source
	move.l	a0,a2
	adda.l	-(a2),a2		; compare-dest
	moveq	#Preset_stay,d2
.depackloop0
	move.w	(a0)+,d0
	bpl.s	.asis0
.put0	move.w	d2,(a1)+
	addq.w	#1,d0
	bne.s	.put0
	bra.s	.relop0
.asis0	move.w	d0,(a1)+
.relop0	cmpa.l	a2,a0
	bcs.s	.depackloop0
.notis1


;======================================== Pitchbendtrack depacken
	move.l	ch_pbtrack(a4),d0
	bne.s	.itis1

	bsr	defaultpbtrack
	bra.s	.notis2

;=== entpacken
.itis1	st	currentpb_state(a5)

	move.l	pbworktrack(a5),a1	; destination
	move.l	d0,a0			; source
	move.l	a0,a2
	adda.l	-(a2),a2		; compare-dest
	move.w	#PB_stay,d2
.depackloop1
	move.w	(a0)+,d0
	bpl.s	.asis1
.put1	move.w	d2,(a1)+
	addq.w	#1,d0
	bne.s	.put1
	bra.s	.relop1
.asis1	move.w	d0,(a1)+
.relop1	cmpa.l	a2,a0
	bcs.s	.depackloop1

	move.b	ch_pb_onoff(a4),currentpb_onoff(a5)

.notis2

;======================================== MPress track depacken
	move.l	ch_mptrack(a4),d0
	bne.s	.itis2

	bsr	defaultmptrack
	bra.s	.notis3
;=== entpacken
.itis2	st	currentmp_state(a5)

	move.l	mpworktrack(a5),a1	; destination
	move.l	d0,a0			; source
	move.l	a0,a2
	adda.l	-(a2),a2		; compare-dest
	move.b	#cs_stay,d2
.depackloop2
	move.b	(a0)+,d0
	bpl.s	.asis2
.put2	move.b	d2,(a1)+
	addq.b	#1,d0
	bne.s	.put2
	bra.s	.relop2
.asis2	move.b	d0,(a1)+
.relop2	cmpa.l	a2,a0
	bcs.s	.depackloop2

	move.b	ch_mp_onoff(a4),currentmp_onoff(a5)

.notis3



;======================================== csource-tracks depacken
	lea	ch_csources(a4),a4
	moveq	#0,d7
;=================== Beginn der Schleife
.outerloopc
	move.l	d7,d0
	bsr	GetCSTrack
	move.l	a0,a1		; Destination

;=== keine Tracks mehr?
	move.l	(a4),d0
	bne.s	.existsc

.skipc	lea	cs_onoffs(a5),a0
	st	(a0,d7.l)
	move.l	d7,d0
	bsr	defaultctrack
	bra.s	.next2c

.existsc
	move.l	d0,a0
;=== wird ein Track bersprungen?
	lea	codetab(a5),a2
	move.b	(a2,d7.l),d0
	cmp.b	cs_parameter(a0),d0
	bne.s	.skipc
	move.l	a0,a4

	lea	cs_states(a5),a0
	st	(a0,d7.l)

;=== ctrack entpacken
	move.b	#cs_stay,d3
	move.l	cs_datasize(a4),d1
	lea	cs_data(a4),a0
	lea	(a0,d1.l),a2	; compare-dest
.depackloopc
	move.b	(a0)+,d0
	bpl.s	.asisc
.putc	move.b	d3,(a1)+
	addq.b	#1,d0
	bne.s	.putc
	bra.s	.relopc
.asisc	move.b	d0,(a1)+
.relopc	cmpa.l	a2,a0
	bcs.s	.depackloopc
.nextc	lea	cs_onoffs(a5),a0
	move.b	cs_onoff(a4),(a0,d7.l)
.next2c	addq.l	#1,d7
	cmp.l	active_csources(a5),d7
	bcs.s	.outerloopc


;======================================== normale tracks depacken
	move.l	currentchannelA(a5),a4
	lea	ch_tracks(a4),a4
	move.l	#track_def_entry,d3
	moveq	#0,d7
;=================== Beginn der Schleife
.outerloop
	move.l	d7,d0
	bsr	GetWTrack
	move.l	a0,a1		; Destination

;=== keine Tracks mehr?
	move.l	(a4),d0
	bne.s	.exists

.skip
	move.l	current_onoffs(a5),a0
	st	(a0,d7.w)
	move.l	d7,d0
	bsr	defaulttrack
	bra.s	.next2n

.exists	move.l	d0,a0
;=== wird ein Track bersprungen?
	cmp.w	tr_number(a0),d7
	bne.s	.skip
	move.l	a0,a4

	move.l	current_states(a5),a0
	st	(a0,d7.w)

;=== track entpacken
	move.l	tr_datasize(a4),d1
	lea	tr_data(a4),a0
	lea	(a0,d1.l),a2	; compare-dest
.depackloopn
	move.w	(a0)+,d0
	bpl.s	.asisn
.putn	move.l	d3,(a1)+
	addq.w	#1,d0
	bne.s	.putn
	bra.s	.relopn
.asisn	move.w	d0,(a1)+
	move.w	(a0)+,(a1)+
.relopn	cmpa.l	a2,a0
	bcs.s	.depackloopn

	move.l	current_onoffs(a5),a0
	move.b	tr_onoff(a4),(a0,d7.w)
.next2n	addq.w	#1,d7
	cmp.w	maxtracks+2(a5),d7
	bcs.s	.outerloop




;=== change-bits lschen

.changebits_chan

	move.l	ctrackchanged(a5),a0
	move.l	active_csources_m1(a5),d0
.clearloopc
	sf	(a0)+
	dbf	d0,.clearloopc

	move.l	trackchanged(a5),a0
	move.l	maxtracks_m1(a5),d0
.clearloop
	sf	(a0)+
	dbf	d0,.clearloop

	sf	bpmtrackchanged(a5)
	sf	ptrackchanged(a5)
	sf	pbtrackchanged(a5)
	sf	mptrackchanged(a5)


	rts



.defaultchannel
	move.l	defreso(a5),pattscale(a5)

	jsr	check_eventposJ(a5)

	bsr.s	defaulttracks
	bsr.s	defaultctracks
	bsr.s	defaultptrack
	bsr	defaultpbtrack
	bsr	defaultmptrack
	bra.s	.changebits_chan


;======== default controltracks
defaultctracks
	move.l	active_csources_m1(a5),-(sp)
.dloop1	move.l	(sp),d0
	bsr.s	defaultctrack
	subq.l	#1,(sp)
	bcc.s	.dloop1
	addq.w	#4,sp
	rts


;======== default cworktrack
defaultctrack	; d0.l=Nummer des CWorktracks
	lea	cs_states(a5),a1
	sf	(a1,d0.l)

erasectrack
	lea	cs_onoffs(a5),a1
	st	(a1,d0.l)
	bsr	GetCSTrack
	move.b	#cs_stay,d0
	move.l	events(a5),d1
.dloop	move.b	d0,(a0)+
	subq.l	#1,d1
	bne.s	.dloop
	rts


;======== default worktracks
defaulttracks
	move.l	maxtracks_m1(a5),-(sp)
.dloop1	move.l	(sp),d0
	bsr.s	defaulttrack
	subq.l	#1,(sp)
	bcc.s	.dloop1
	addq.w	#4,sp
	rts


;======== default worktrack
defaulttrack	; d0=tracknumber
	move.l	current_states(a5),a0
	sf	(a0,d0.w)

erasetrack	; d0=tracknumber
	move.l	current_onoffs(a5),a0
	st	(a0,d0.w)
	bsr	GetWTrack
	move.l	events(a5),d1
	move.l	#track_def_entry,d3
.iloop2	move.l	d3,(a0)+
	subq.l	#1,d1
	bne.s	.iloop2
	rts



defaultptrack
	sf	preset_state(a5)

eraseptrack
	move.l	pworktrack(a5),a1
	move.l	events(a5),d1
	moveq	#Preset_stay,d3
.iloop2	move.w	d3,(a1)+
	subq.l	#1,d1
	bne.s	.iloop2
	rts



defaultpbtrack
	sf	currentpb_state(a5)

erasepbtrack
	st	currentpb_onoff(a5)
	move.l	pbworktrack(a5),a1
	move.l	events(a5),d1
	move.w	#PB_stay,d3
.iloop	move.w	d3,(a1)+
	subq.l	#1,d1
	bne.s	.iloop
	rts



defaultmptrack
	sf	currentmp_state(a5)

erasemptrack
	st	currentmp_onoff(a5)
	move.l	mpworktrack(a5),a1
	move.l	events(a5),d1
	move.b	#cs_stay,d3
.iloop	move.b	d3,(a1)+
	subq.l	#1,d1
	bne.s	.iloop
	rts



defaultbpmtrack
	sf	bpm_state(a5)

erasebpmtrack
	move.l	bpmworktrack(a5),a1
	move.l	events(a5),d1
	moveq	#BPM_stay,d3
.dloop1	move.w	d3,(a1)+
	subq.l	#1,d1
	bne.s	.dloop1
	rts


	ENDC





AllocPattern	; d0.w=newpattern
		; zurck: d0=pos/neg, a0=^NewPattern

	ext.l	d0
	move.l	d0,-(sp)

	addq.l	#1,d0
	cmp.l	patterntablen(a5),d0
	bls.s	.nonewtab
	bsr	AllocPatterntab
	beq.s	.fail
.nonewtab

	bsr.s	AllocPatternDry
	beq.s	.fail

	move.l	patterntab(a5),a1	; in patterntab schreiben
	move.l	(sp)+,d0
	IFEQ	mc68020
	lsl.l	#2,d0
	move.l	a0,(a1,d0.l)
	ELSE
	move.l	a0,(a1,d0.l*4)
	ENDC
	POSITIV

.fail	addq.w	#4,sp
	NEGATIV




AllocPatternDry	; zurck: a0=^pattern (schreibt aber nicht in patterntab)
	moveq	#pt_sizeof,d0
	move.l	#$10001,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a0			; einiges initialisieren

	move.l	defpatternsize(a5),d0
	move.l	defreso(a5),d1
	LONGMULU
	move.l	d0,pt_events(a0)
;	not.w	pt_chanmask(a0)		; $ffff
	POSITIV
.neg	NEGATIV




;==============================================================
;
;  Channel allocaten
;
;==============================================================

AllocChannel	; zurck: a0=^channel (NICHT IN D0!!!)
;=== gibt Channel zurck, wird aber nicht ins Pattern eingetragen
	moveq	#ch_sizeof,d0
	move.l	#$10001,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a0

;	tst.b	globalresoflag(a5)
;	bne.s	.global
;	move.w	pattscale+2(a5),ch_scale(a2)
;	bra.s	.gcont
.global
	move.l	defreso(a5),d0
	move.w	d0,ch_scale(a0)

;.gcont

;	st	ch_mp_onoff(a0)
	st	ch_pb_onoff(a0)
	st	ch_onoff(a0)

	POSITIV
.neg	NEGATIV



;==============================================================
;
;  Positions + Patterntab allocaten
;
;==============================================================

AllocPositions	; d0.l=new positions
		; zurck: pos/neg

	movem.l	d2-d3/a2,-(sp)

	move.l	d0,d2
	add.l	d0,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a2

	move.l	positionsA(a5),d1
	bne.s	.old_positions
	move.l	a2,a0
	move.l	d2,d0
.cloop	clr.w	(a0)+
	subq.l	#1,d0
	bne.s	.cloop
	bra.s	.done


.old_positions
	move.l	d1,a0
	move.l	a2,a1
	move.l	length(a5),d1
	move.l	d2,d0
	move.l	d0,d3
	sub.l	d1,d3
	bls.s	.copy

	move.l	d1,d0
;=== fill the new fields with the pattern of the last position
	add.l	d1,d1
	adda.l	d1,a1
	move.w	-2(a0,d1.l),d1
.floop	move.w	d1,(a1)+
	subq.l	#1,d3
	bne.s	.floop
	move.l	a2,a1

.copy	add.l	d0,d0
	jsr	CopyMem(a6)

	lea	positionsA(a5),a0
	jsr	MyFreeVectorJ(a5)

.done	move.l	a2,positionsA(a5)
	move.l	d2,length(a5)

.fix	movem.l	(sp)+,d2-d3/a2
	POSITIV

.neg	movem.l	(sp)+,d2-d3/a2
	NEGATIV





AllocPatterntab	; d0=new size
		; zurck: pos/neg

	movem.l	d2/a2,-(sp)

	move.l	d0,d2
	lsl.l	#2,d0
	move.l	#$10001,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a2

	move.l	patterntab(a5),d1
	beq.s	.no_old_tab
	move.l	d1,a0
	move.l	d0,a1
	move.l	patterntablen(a5),d0
	cmp.l	d2,d0
	bls.s	.nochange
	move.l	d2,d0
.nochange
	lsl.l	#2,d0
	jsr	CopyMemQuick(a6)
	lea	patterntab(a5),a0
	jsr	MyFreeVectorJ(a5)
.no_old_tab

	move.l	a2,patterntab(a5)
	move.l	d2,patterntablen(a5)

	movem.l	(sp)+,d2/a2
	POSITIV

.neg	movem.l	(sp)+,d2/a2
	NEGATIV





;==============================================================
;
;  Positions + Patterntab freigeben
;
;==============================================================

FreePosNPatts
;=== gibt die Positions und die Patterntab frei.
;=== positions
	lea	positionsA(a5),a0
	jsr	MyFreeVectorJ(a5)
	clr.l	length(a5)
;=== patterntab
	clr.l	patterntablen(a5)
	lea	patterntab(a5),a0
	jmp	MyFreeVectorJ(a5)





;==============================================================
;
;  Set Cursor
;
;==============================================================

set_cursor
	tst.b	editmode(a5)
	beq.s	.rts

	tst.b	cursorset(a5)
	bne.s	.rts
	st	cursorset(a5)

	lea	current_channelblock(a5),a0
	bsr.s	calc_cursor
	bra.s	printcursor
.rts	rts



clear_cursor
	tst.b	cursorset(a5)
	beq.s	.rts
	sf	cursorset(a5)

	lea	current_channelblock(a5),a0
	bsr.s	calc_cursor
	bra.s	printcursor
.rts	rts


printcursor	; d0-d3 = ltwh coords from calc_cursor

	move.l	active_channelwindow(a5),d4
	bmi.s	.rts

	movem.l	d0-d3,-(sp)

	move.l	d4,d0
	jsr	get_inst_structJ(a5)
	movem.l	wd_LeftTop(a0),d4-d5
	move.l	wd_Wnd(a0),a0
	move.l	50(a0),a2

	moveq	#3,d0
	moveq	#2,d2
	move.l	a2,a1
	jsr	set_apen_and_drmdJ(a5)


;=== Set new writemask
	move.b	$18(a2),old_writemask(a5)
	moveq	#3,d0
	move.l	a2,a0
	bsr	PutWriteMask


	movem.l	(sp)+,d0-d3
	add.w	d4,d0
	add.w	d5,d1
	add.w	#tdbegin_x,d0
	add.w	#tdbegin_y,d1
	add.w	d0,d2
	add.w	d1,d3
	subq.w	#1,d2
	subq.w	#1,d3

	move.l	a2,a1
	move.l	gfxbas(a5),a6
	jsr	RectFill(a6)


;=== Restore old writemask
	move.b	old_writemask(a5),d0
	move.l	a2,a0
	bra	PutWriteMask

.rts	rts



calc_cursor	; a0 = ^channelblock
		; returns: d0-d3 = ltwh from trackdisplay box

	move.w	chan_cursorpos(a0),d1
	move.l	chan_currenttrack(a0),d0
	bpl.s	.normaltrack
	addq.l	#1,d0
	beq.s	.ctrack
	addq.l	#1,d0
	beq.s	.ptrack

;=== bpmworktrack
	moveq	#bpmtextx*8,d0
	cmp.w	#3,d1
	bcs.s	.decp
	addq.w	#8,d0
.decp	bra.s	.under2

;=== preset-worktrack
.ptrack
	moveq	#presettextx*8,d0
	cmp.w	#3,d1
	bcs.s	.skipb
	addq.w	#8,d0
.skipb	bra.s	.under2

;=== control-worktrack
.ctrack
	move.w	#cstextx*8,d0
	tst.w	chan_pgfx_active(a0)
	beq.s	.PB
	addq.w	#8,d0
.PB	bra.s	.under2

;=== normaler worktrack
.normaltrack
	sub.l	chan_displaytrack(a0),d0
	bcc.s	.oki
	move.l	chan_displaytrack(a0),chan_currenttrack(a0)
	moveq	#0,d0
	bra.s	.doit
.oki	move.l	chan_displayed_tracks(a0),d2
	cmp.l	d2,d0
	bcs.s	.oki2
	move.l	chan_displaytrack(a0),d0
	add.l	d2,d0
	subq.l	#1,d0
	move.l	d0,chan_currenttrack(a0)
	move.l	d2,d0
	subq.l	#1,d0
.oki2	mulu	#tracksgad_d,d0
.doit	add.w	#tracktextx*8,d0
	cmp.w	#2,d1
	bcs.s	.under2
	bhi.s	.above2
	moveq	#3*8,d2
	bra.s	.put

.above2	addq.w	#2,d1
.under2
	moveq	#8,d2

.put	lsl.w	#3,d1
	add.w	d1,d0

	move.l	chan_lines_in_td_half(a0),d1
	move.w	d1,d4	; = mulu #10,d1
	add.w	d4,d4	;
	lsl.w	#3,d1	;
	add.w	d4,d1	;
	addq.w	#2+2+1,d1 	; +2 = top offset, +2+1 = middle offset

	moveq	#8,d3
	rts






;========================================== Get Routinen

;GetAbleSds	; d1=GadgetID
;	lea	MTsdsStruct(a5),a1
;GetAble		; zurck: 0=enabled, 1=disabled
;	bsr	GetGadget
;	move.w	$c(a0),d0		; Gadget.Flags
;	and.w	#$0100,d0
;	lsr.w	#8,d0
;	rts





GetNumberRemap
	lea	MTremapStruct(a5),a1
GetNumber	; zurck: a0=^string
	bsr	GetGadget

	move.l	$22(a0),a0		; SpecialInfo
	move.l	$1c(a0),d0		; LongInt
	rts






;GetStringRemap
;	lea	MTremapStruct(a5),a1
;	bra.s	GetString
GetStringSys
	lea	MTsysStruct(a5),a1
	bra.s	GetString
GetStringMain
	lea	MTmainStruct(a5),a1
	bra.s	GetString
GetStringMetro
	lea	MTmetroStruct(a5),a1
;	bra.s	GetString
;GetStringSds
;	lea	MTsdsStruct(a5),a1
;	bra.s	GetString
;GetStringSproc
;	lea	MTsprocStruct(a5),a1
GetString	; zurck: a0=^string
	bsr	GetGadget
;	bsr.s	forcefirstchar

	move.l	$22(a0),a0		; SpecialInfo
	move.l	(a0),a0			; retrieve String-pointer
	rts


forcefirstchar	; a0=^gadget, a1=^windowstruct
;=== force text-display beginning at first char

	movem.l	a0-a1,-(sp)
	move.l	wd_Wnd(a1),a2

	move.l	a0,a1
	move.l	a2,a0
	move.l	intbas(a5),a6
	jsr	RemoveGadget(a6)
;	move.w	d0,d4

	move.l	(sp),a1
	move.l	$22(a1),a0		; SpecialInfo
	clr.w	$8(a0)			; text begins at first char

;=== add the gadget to window's GList
	move.l	a2,a0
;	move.w	d4,d0
	jsr	AddGadget(a6)

	move.l	(sp),a0
	move.l	a2,a1
	suba.l	a2,a2
	moveq	#1,d0
	jsr	RefreshGList(a6)

	movem.l	(sp)+,a0-a1
	rts





GetIntegerScore
	lea	MTscoreStruct(a5),a1
	bra.s	GetInteger
GetIntegerSysex
	lea	MTsysexStruct(a5),a1
	bra.s	GetInteger
GetIntegerRemap
	lea	MTremapStruct(a5),a1
	bra.s	GetInteger
;GetIntegerSproc
;	lea	MTsprocStruct(a5),a1
;	bra.s	GetInteger
GetIntegerQuadra
	lea	MTquadraStruct(a5),a1
	bra.s	GetInteger
GetIntegerK2k
	lea	MTk2kStruct(a5),a1
	bra.s	GetInteger
GetIntegerEdit
	lea	MTeditStruct(a5),a1
	bra.s	GetInteger
GetIntegerSys
	lea	MTsysStruct(a5),a1
	bra.s	GetInteger
GetIntegerMidi
	lea	MTmidiStruct(a5),a1
	bra.s	GetInteger
GetIntegerMain
	lea	MTmainStruct(a5),a1
	bra.s	GetInteger
GetIntegerMetro
	lea	MTmetroStruct(a5),a1
;	bra.s	GetInteger
;GetIntegerSds
;	lea	MTsdsStruct(a5),a1
GetInteger	; d1=GadgetID
	bsr.s	GetGadget
	bsr.s	forcefirstchar

	move.l	$22(a0),a0		; SpecialInfo
	move.l	$1c(a0),d0		; LongInt
	rts


gadtemp	dc.l	0


GetGadget	; d1=GadgetID, a1=^windowstruct
		; zurck: a0=^gadget
	move.w	wd_Gadgets(a1),d0
	ext.l	d0
	lsl.w	#2,d1
	ext.l	d1
	add.l	d1,d0
	move.l	(a5,d0.l),a0
	rts




;GetMXmain
;	lea	MTmainStruct(a5),a1
;GetMX	; der Code aus der IDCMP Message mu noch erhalten sein!
;	bra.s	GetCode



GetCycleInst
;	lea	MTinstStruct(a5),a1
;	bra.s	GetCycle
GetCycleMetro
;	lea	MTmetroStruct(a5),a1
;	bra.s	GetCycle
GetCycleFilt
;	lea	MTfiltStruct(a5),a1
;	bra.s	GetCycle
GetCycleChan
;	lea	MTchanStruct(a5),a1
;	bra.s	GetCycle
GetCyclePgfx
;	lea	MTpgfxStruct(a5),a1
;	bra.s	GetCycle
GetCycleEdit
;	lea	MTeditStruct(a5),a1
;	bra.s	GetCycle
GetCycleMidi
;	lea	MTmidiStruct(a5),a1
;	bra.s	GetCycle
GetCycleSys
;	lea	MTsysStruct(a5),a1
;	bra.s	GetCycle
;GetCycleSproc
;	lea	MTsprocStruct(a5),a1
;	bra.s	GetCycle
;GetCycleSds
;	lea	MTsdsStruct(a5),a1
;	bra.s	GetCycle
GetCycleMain
;	lea	MTmainStruct(a5),a1
GetCycle
;	bra	GetCode




GetListviewCs1x
;	lea	MTcs1xStruct(a5),a1
;	bra.s	GetListview
GetListviewQuasar
;	lea	MTquasarStruct(a5),a1
;	bra.s	GetListview
GetListviewYamxg
;	lea	MTyamxgStruct(a5),a1
;	bra.s	GetListview
GetListviewMc303
;	lea	MTmc303Struct(a5),a1
;	bra.s	GetListview
GetListviewSysex
;	lea	MTSysexStruct(a5),a1
;	bra.s	GetListview
GetListviewMidi
;	lea	MTmidiStruct(a5),a1
;	bra.s	GetListview
GetListviewQuadra
;	lea	MTquadraStruct(a5),a1
;	bra.s	GetListview
GetListviewK2k
;	lea	MTk2kStruct(a5),a1
;	bra.s	GetListview
GetListviewBoehm
;	lea	MTboehmStruct(a5),a1
;	bra.s	GetListview
GetListviewPgfx
;	lea	MTpgfxStruct(a5),a1
;	bra.s	GetListview
GetListviewSys
;	lea	MTsysStruct(a5),a1
GetListview
;	bra	GetCode




GetSliderRemap
;	lea	MTremapStruct(a5),a1
;	bra.s	GetSlider
GetSliderActi
;	lea	MTactiStruct(a5),a1
;	bra.s	GetSlider
GetSliderScore
;	lea	MTscoreStruct(a5),a1
;	bra.s	GetSlider
GetSliderChan
;	lea	MTchanStruct(a5),a1
;	bra.s	GetSlider
GetSliderMain
;	lea	MTmainStruct(a5),a1

GetSlider	; der Code aus der IDCMP Message mu noch erhalten sein!
;	bra.s	GetCode


GetScrollerInst
;	lea	MTpgfxStruct(a5),a1
;	bra.s	GetScroller
GetScrollerPgfx
;	lea	MTpgfxStruct(a5),a1
;	bra.s	GetScroller
GetScrollerScore
;	lea	MTscoreStruct(a5),a1
;	bra.s	GetScroller
;GetScrollerSproc
;	lea	MTsprocStruct(a5),a1
;	bra.s	GetScroller
GetScrollerMain
;	lea	MTmainStruct(a5),a1
GetScroller	; d1=GadgetID, zurck: d0=Top
		; der Code aus der IDCMP Message mu noch erhalten sein!
		; (scroller ist in etwa ein slider)
GetCode	move.w	d5,d0
	ext.l	d0
	rts



GetCheckboxInst
	move.l	active_channelwindow(a5),d0
	bsr	get_inst_struct
	move.l	a0,a1
	bra.s	GetCheckbox
GetCheckboxSysex
	lea	MTsysexStruct(a5),a1
	bra.s	GetCheckbox
GetCheckboxFilt
	lea	MTfiltStruct(a5),a1
	bra.s	GetCheckbox
GetCheckboxKact
	lea	MTkactStruct(a5),a1
	bra.s	GetCheckbox
GetCheckboxRemap
	lea	MTremapStruct(a5),a1
	bra.s	GetCheckbox
;GetCheckboxSds
;	lea	MTsdsStruct(a5),a1
;	bra.s	GetCheckbox
GetCheckboxEdit
	lea	MTeditStruct(a5),a1
	bra.s	GetCheckbox
GetCheckboxMidi
	lea	MTmidiStruct(a5),a1
	bra.s	GetCheckbox
GetCheckboxSys
	lea	MTsysStruct(a5),a1
	bra.s	GetCheckbox
GetCheckboxScore
	lea	MTscoreStruct(a5),a1
	bra.s	GetCheckbox
GetCheckboxChan
	lea	MTchanStruct(a5),a1
	bra.s	GetCheckbox
GetCheckboxMain
	lea	MTmainStruct(a5),a1
	bra.s	GetCheckbox
GetCheckboxMetro
	lea	MTmetroStruct(a5),a1
GetCheckbox	; d1=GadgetID
		; zurck: d0=0 oder $ff (und Z-Flag)
	bsr	GetGadget
	move.w	$c(a0),d0
	and.w	#$0080,d0
	lsr.w	#7,d0
	tst.w	d0
	sne	d0
	rts




;==================================== Set Routinen



;DisableGetfileSds
;	lea	MTsdsStruct(a5),a1
;DisableGetfile	; d1=ID, a1=^Struct
;	move.w	wd_Gadgets(a1),d0
;	lea	(a5,d0.w),a0
;	IFEQ	mc68020
;	lsl.w	#2,d1
;	move.l	(a0,d1.w),a0
;	ELSE
;	move.l	(a0,d1.w*4),a0
;	ENDC
;	move.l	wd_Wnd(a1),a1
;	suba.l	a2,a2
;	move.l	intbas(a5),a6
;	jmp	OffGadget(a6)



DisableGadChan
	lea	MTchanStruct(a5),a1
	bra.s	DisableGad
DisableGadSys
	lea	MTsysStruct(a5),a1
	bra.s	DisableGad
DisableGadEdit
	lea	MTeditStruct(a5),a1
	bra.s	DisableGad
DisableGadMain
	lea	MTmainStruct(a5),a1
;	bra.s	DisableGad
;DisableGadSds
;	lea	MTsdsStruct(a5),a1
DisableGad	; d1=ID, a1=^Struct
	lea	.tags(pc),a3
	bra	SetAttrs2
.tags	dc.l	$8003000e,1		; Disabled
	dc.l	0



;EnableGetfileSds
;	lea	MTsdsStruct(a5),a1
;EnableGetfile	; d1=ID, a1=^Struct
;	move.w	wd_Gadgets(a1),d0
;	lea	(a5,d0.w),a0
;	IFEQ	mc68020
;	lsl.w	#2,d1
;	move.l	(a0,d1.w),a0
;	ELSE
;	move.l	(a0,d1.w*4),a0
;	ENDC
;	move.l	wd_Wnd(a1),a1
;	suba.l	a2,a2
;	move.l	intbas(a5),a6
;	jmp	OnGadget(a6)



EnableGadChan
	lea	MTchanStruct(a5),a1
	bra.s	EnableGad
EnableGadSys
	lea	MTsysStruct(a5),a1
	bra.s	EnableGad
EnableGadEdit
	lea	MTeditStruct(a5),a1
	bra.s	EnableGad
EnableGadMain
	lea	MTmainStruct(a5),a1
;	bra.s	EnableGad
;EnableGadSds
;	lea	MTsdsStruct(a5),a1
EnableGad	; d1=ID, a1=^Struct
	lea	.tags(pc),a3
	bra	SetAttrs2
.tags	dc.l	$8003000e,0		; Enabled
	dc.l	0



ActivateGadSys
	lea	MTsysStruct(a5),a1
;	bra.s	ActivateGad
;ActivateGadSds
;	lea	MTsdsStruct(a5),a1
ActivateGad	; d1=ID, a1=^Struct
	move.w	wd_Gadgets(a1),d0
	lea	(a5,d0.w),a0
	IFEQ	mc68020
	lsl.w	#2,d1
	move.l	(a0,d1.w),a0
	ELSE
	move.l	(a0,d1.w*4),a0
	ENDC
	move.l	wd_Wnd(a1),a1
	suba.l	a2,a2
	move.l	intbas(a5),a6
	jmp	ActivateGadget(a6)






;SelectButtonChan	; d1=gadget-id
;	lea	MTchanStruct(a5),a4
;	bra.s	SelectButton

SelectButtonMain	; d1=gadget-id
	lea	MTmainStruct(a5),a4

SelectButton	; a4=^windowstruct, d1=gadget-id

	move.l	wd_Wnd(a4),d0
	beq.s	.dont

	bsr.s	Button_Remove
	or.w	#$80,12(a3)
	bra.s	Button_Add

.dont	rts


Button_Remove	; d0 = window
	move.l	d0,a0

	move.w	wd_Gadgets(a4),d0
	lea	(a5,d0.w),a1
	IFEQ	mc68020
	lsl.w	#2,d1
	move.l	(a1,d1.w),a3
	ELSE
	move.l	(a1,d1.w*4),a3
	ENDC

	move.l	a3,a1
	move.l	intbas(a5),a6
	jmp	RemoveGadget(a6)

Button_Add
	move.l	wd_Wnd(a4),a0
	move.l	a3,a1
	jsr	AddGadget(a6)

	move.l	a3,a0
	move.l	wd_Wnd(a4),a1
	suba.l	a2,a2
	moveq	#1,d0
	jmp	RefreshGList(a6)




;UnselectButtonChan	; d1=gadget-id
;	lea	MTchanStruct(a5),a4
;	bra.s	UnselectButton

UnselectButtonMain	; d1=gadget-id
	lea	MTmainStruct(a5),a4

UnselectButton	; a4=^windowstruct, d1=gadget-id

	move.l	wd_Wnd(a4),d0
	beq.s	.dont

	bsr.s	Button_Remove
	and.w	#~$80,12(a3)
	bra.s	Button_Add

.dont	rts




ToggleButtonChan	; d1=gadget-id
	lea	MTchanStruct(a5),a4

ToggleButton	; a4=^windowstruct, d1=gadget-id

	move.l	wd_Wnd(a4),d0
	beq.s	.dont

	bsr.s	Button_Remove
	eor.w	#$80,12(a3)
	bra.s	Button_Add

.dont	rts





SetNumberInst	; d0=wert, d1=GadgetID, d2 = fg-pen, d4 = active chanwindow
	move.l	d0,d3
	move.l	d4,d0
	bmi.s	.no
	bsr	get_inst_struct
	move.l	a0,a1
	move.l	d3,d0
	bra.s	SetNumber
.no	rts
SetNumberMain
	lea	MTmainStruct(a5),a1
SetNumber
	lea	.tags(pc),a3
	move.l	d2,$c(a3)
	bra	SetAttrs
.tags	dc.l	$8008000d,0
	dc.l	$80080000+72,0		; V39+
	dc.l	0





SetLVActiveMidi
	lea	MTmidiStruct(a5),a1
	bra.s	SetLVActive
SetLVActivePgfx
	lea	MTpgfxStruct(a5),a1
SetLVActive	; a1=^windowstruct, d1=GadgetID, d0=active
	lea	.tags(pc),a3
	move.l	d0,$c(a3)
	tst.b	kick30(a5)
	beq.s	.v37
	move.l	#$80080000+78,d2
.set	move.l	d2,$8(a3)
	bra	SetAttrs
.v37	move.l	#$80080000+5,d2
	bra.s	.set

.tags	dc.l	$80080000+54,0		; selected
	dc.l	$80080000+78,0		; make visible (V39), or Top (V37)
	dc.l	0



SetLVListMidi
	lea	MTmidiStruct(a5),a1
SetLVList	; a1=^windowstruct, a0=^list, d1=GadgetID
	lea	.tags(pc),a3
	move.l	a0,d0
	bra	SetAttrs

.tags	dc.l	$80080000+6,0
	dc.l	0




SetListViewSysex
	lea	MTsysexStruct(a5),a1
	bra.s	SetListview
SetListviewPgfx
	lea	MTpgfxStruct(a5),a1
	bra.s	SetListview
SetListviewQuadra
	lea	MTquadraStruct(a5),a1
	bra.s	SetListview
SetListviewK2k
	lea	MTK2kStruct(a5),a1
SetListview	; a1=^windowstruct, a0=^list, d1=GadgetID, d0=top
	lea	.tags(pc),a3
	move.l	a0,$c(a3)
	move.l	d0,$14(a3)
	tst.b	kick30(a5)
	beq.s	.v37
	move.l	#$80080000+78,d2
.set	move.l	d2,$10(a3)
	bra	SetAttrs
.v37	move.l	#$80080000+5,d2
	bra.s	.set


.tags	dc.l	$80080000+54,0		; selected
	dc.l	$80080000+6,0
	dc.l	$80080000+78,0		; make visible for V39, Top for V37
	dc.l	0




ResetListviewSysEx
	lea	MTsysexStruct(a5),a1
	bra.s	ResetListview
ResetListviewMidi
	lea	MTmidiStruct(a5),a1
	bra.s	ResetListview
ResetListviewPgfx
	lea	MTpgfxStruct(a5),a1
	bra.s	ResetListview
ResetListviewQuadra
	lea	MTquadraStruct(a5),a1
	bra.s	ResetListview
ResetListviewK2k
	lea	MTK2kStruct(a5),a1
ResetListview	; a1=^windowstruct, d1=GadgetID
	lea	.detach(pc),a3
	bra	SetAttrs2
.detach	dc.l	$80080000+6,-1		; labels-list
	dc.l	0





SetIntegerSysex
	lea	MTsysexStruct(a5),a1
	bra.s	SetInteger
SetIntegerRemap
	lea	MTremapStruct(a5),a1
	bra.s	SetInteger
;SetIntegerSproc
;	lea	MTsprocStruct(a5),a1
;	bra.s	SetInteger
SetIntegerK2K
	lea	MTK2kStruct(a5),a1
	bra.s	SetInteger
SetIntegerQuadra
	lea	MTquadraStruct(a5),a1
	bra.s	SetInteger
SetIntegerEdit
	lea	MTeditStruct(a5),a1
	bra.s	SetInteger
SetIntegerSys
	lea	MTsysStruct(a5),a1
	bra.s	SetInteger
SetIntegerMidi
	lea	MTmidiStruct(a5),a1
	bra.s	SetInteger
SetIntegerMain
	lea	MTmainStruct(a5),a1
	bra.s	SetInteger
SetIntegerMetro
	lea	MTmetroStruct(a5),a1
;	bra.s	SetInteger
;SetIntegerSds
;	lea	MTsdsStruct(a5),a1
SetInteger	; d0=wert, d1=GadgetID, a1=^windowstruct
	lea	.tags(pc),a3
	bra.s	SetAttrs
.tags	dc.l	$80080000+47,0
	dc.l	0



;SetStringRemap
;	lea	MTremapStruct(a5),a1
;	bra.s	SetString
SetStringSys
	lea	MTsysStruct(a5),a1
	bra.s	SetString
;SetStringSproc
;	lea	MTsprocStruct(a5),a1
;	bra.s	SetString
SetStringMetro
	lea	MTmetroStruct(a5),a1
	bra.s	SetString
SetStringMain
	lea	MTmainStruct(a5),a1
;	bra.s	SetString
;SetStringSds
;	lea	MTsdsStruct(a5),a1
SetString	; a0=^String, d1=GadgetID, a1=^windowstruct
	move.l	a0,d0
	lea	.tags(pc),a3
	bra.s	SetAttrs
.tags	dc.l	$80080000+45,0
	dc.l	0



SetAttrs	; a1=^WindowStruct, d0=data, d1.w=GadgetID, a3=^Tags
	move.l	d0,4(a3)
SetAttrs2	; Tags sind schon gefllt
	move.l	wd_Wnd(a1),d0
	beq.s	.dont

	move.l	a5,a0
	adda.w	wd_Gadgets(a1),a0
	IFEQ	mc68020
	lsl.w	#2,d1
	move.l	(a0,d1.w),a0
	ELSE
	move.l	(a0,d1.w*4),a0
	ENDC
	move.l	d0,a1
	suba.l	a2,a2
	move.l	gadbas(a5),a6
	jmp	GT_SetGadgetAttrsA(a6)	

.dont	rts




;SetCheckboxInst	; d4 = channelwindow
;	move.l	d0,d3
;	move.l	d4,d0
;	bmi.s	.no
;	bsr	get_inst_struct
;	move.l	a0,a1
;	move.l	d3,d0
;	bra.s	SetCheckbox
;.no	rts
SetCheckboxSys
	lea	MTsysStruct(a5),a1
	bra.s	SetCheckbox
SetCheckboxFilt
	lea	MTfiltStruct(a5),a1
	bra.s	SetCheckbox
SetCheckboxKact
	lea	MTkactStruct(a5),a1
	bra.s	SetCheckbox
SetCheckboxMidi
	lea	MTmidiStruct(a5),a1
	bra.s	SetCheckbox
SetCheckboxRemap
	lea	MTremapStruct(a5),a1
	bra.s	SetCheckbox
SetCheckboxEdit
	lea	MTeditStruct(a5),a1
	bra.s	SetCheckbox
;SetCheckboxSds
;	lea	MTsdsStruct(a5),a1
;	bra.s	SetCheckbox
SetCheckboxChan
	lea	MTchanStruct(a5),a1
	bra.s	SetCheckbox
SetCheckboxMain
	lea	MTmainStruct(a5),a1
	bra.s	SetCheckbox
SetCheckboxMetro
	lea	MTmetroStruct(a5),a1
SetCheckbox	; d0.l=state of checkbox (0/1), d1.w=GadgetID
	lea	.tags(pc),a3
	IFEQ	mc68020
	ext.w	d0
	ext.l	d0
	ELSE
	extb.l	d0
	ENDC
	bra.s	SetAttrs
.tags	dc.l	$80080000+4,0
	dc.l	0





;=== Text-Gadget mit gadtools refreshen

SetTextInst	; d4 = active channelwindow
	move.l	d0,d3
	move.l	a0,a1
	move.l	d4,d0
	bmi.s	.no
	bsr	get_inst_struct
	exg	a0,a1
	move.l	d3,d0
	bra.s	SetText
.no	rts
SetTextScore
	lea	MTscoreStruct(a5),a1
	bra.s	SetText
SetTextKact
	lea	MTkactStruct(a5),a1
	bra.s	SetText
SetTextRemap
	lea	MTremapStruct(a5),a1
	bra.s	SetText
;SetTextSproc
;	lea	MTsprocStruct(a5),a1
;	bra.s	SetText
;SetTextSds
;	lea	MTsdsStruct(a5),a1
;	bra.s	SetText
SetTextMain
	lea	MTmainStruct(a5),a1
SetText		; d0=FrontPen, d1=GadgetID, a0=^Text, a1=^windowstruct

	tst.b	kick30(a5)
	beq.s	SetTextv37

	lea	.tags(pc),a3
	move.l	a0,$c(a3)
	bra	SetAttrs

.tags	DC.L	$80080000+72,0		; FrontPen
	DC.L	$80080000+11,0		; ^Text
	dc.l	0


SetTextV37		; d0=FrontPen, d1=GadgetID, a0=^Text, a1=^windowstruct

	movem.l	d1/a0/a2,-(sp)
	move.l	a1,a2

	move.l	wd_Wnd(a2),a1
	move.l	$32(a1),a1
	move.l	a1,-(sp)
	move.l	gfxbas(a5),a6
	jsr	SetAPen(a6)

	moveq	#1,d0
	move.l	(sp),a1
	jsr	SetDrMd(a6)

	move.l  4(sp),d0
	lsl.w   #2,d0
	add.w   wd_Gadgets(a2),d0
	move.l  (a5,d0.w),a0

	movem.l	wd_LeftTop(a2),d0-d1
	add.w	4(a0),d0
	add.w	6(a0),d1
	subq.w	#3,d1
	move.l	(sp),a1
	jsr	Move(a6)

	move.l	8(sp),a0
	bsr	stringlength
	move.l	8(sp),a0
	move.l	(sp)+,a1
	jsr	Text(a6)

	movem.l	(sp)+,d1/a0/a2
	rts





SetSliderRemap
	lea	MTremapStruct(a5),a1
	bra.s	SetSlider
SetSliderChan
	lea	MTchanStruct(a5),a1
	bra.s	SetSlider
SetSliderMain
	lea	MTmainStruct(a5),a1
SetSlider	; d0=Level, d1=GadgetID
	lea	.tags(pc),a3
	bra	SetAttrs
.tags	dc.l	$80080000+40,0
	dc.l	0



SetCyclelabFilt
	lea	MTfiltStruct(a5),a1
SetCyclelab	; d0=Wert, d1=GadgetID, a0=^Label-Array
	lea	.tags(pc),a3
	move.l	a0,$c(a3)
	bra	SetAttrs
.tags	dc.l	$80080000+15,0
	dc.l	$80080000+14,0
	dc.l	0


SetCycleInst	; d4 = active channelwindow
	move.l	d0,d3
	move.l	d4,d0
	bmi.s	.no
	bsr	get_inst_struct
	move.l	a0,a1
	move.l	d3,d0
	bra.s	SetCycle
.no	rts
SetCycleSys
	lea	MTsysStruct(a5),a1
	bra.s	SetCycle
;SetCycleSproc
;	lea	MTsprocStruct(a5),a1
;	bra.s	SetCycle
SetCycleMain
	lea	MTmainStruct(a5),a1
;	bra.s	SetCycle
;SetCycleSds
;	lea	MTsdsStruct(a5),a1
SetCycle	; d0=Wert, d1=GadgetID
	lea	.tags(pc),a3
	bra	SetAttrs
.tags	dc.l	$80080000+15,0
	dc.l	0



;SetMXpgfx	; d0=neuer Wert
;	lea	MTpgfxStruct(a5),a1
;SetMX
;	lea	.tags(pc),a3
;	bra	SetAttrs
;.tags	dc.l	$80080000+10,0
;	dc.l	0



SetScrollerInst	; d4 = active channelwindow
	move.l	d0,a3
	move.l	d4,d0
	bmi.s	.no
	bsr	get_inst_struct
	move.l	a0,a1
	move.l	a3,d0
	bra.s	SetScroller
.no	rts
SetScrollerPgfx
	lea	MTpgfxStruct(a5),a1
	bra.s	SetScroller
SetScrollerScore
	lea	MTscoreStruct(a5),a1
	bra.s	SetScroller
;SetScrollerSproc
;	lea	MTsprocStruct(a5),a1
;	bra.s	SetScroller
SetScrollerMain
	lea	MTmainStruct(a5),a1
SetScroller	; d0=Top, d1=GadgetID, d2=Total, d3=Visible
		; a1 = ^struct
	lea	.tags(pc),a3
	move.l	d2,$c(a3)
	move.l	d3,$14(a3)
	bra	SetAttrs
.tags	dc.l	$80080000+21,0		; Top
	dc.l	$80080000+22,0		; Total
	dc.l	$80080000+23,0		; Visible
	dc.l	0




SetActiveNumberRemap
	lea	MTremapStruct(a5),a1
SetActiveNumber	; d1=GadgetID

	tst.b	kick30(a5)
	beq.s	.v37

	lea	.39tags(pc),a3
	bra	SetAttrs2

.39tags	DC.L	$80080000+72,2		; FrontPen
	dc.l	0

.v37	moveq	#2,d0


SetV37NumberPen		; d1=gadgetid, d0=pen, a1=^windowstruct
	move.l	a1,a2
	move.l	wd_Wnd(a2),a1
	move.l	$32(a1),a1
	movem.l	d1/a1,-(sp)
	move.l	gfxbas(a5),a6
	jsr	SetAPen(a6)

	move.l	(sp),d0
	lsl.w   #2,d0
	add.w   wd_Gadgets(a2),d0
	move.l	(a5,d0.w),a0
	movem.l	wd_LeftTop(a2),d0-d1
	add.w	4(a0),d0
	add.w	6(a0),d1
	subq.w	#1,d1
	move.l	4(sp),a1
	jsr	Move(a6)

	lea	.two_byte_number(pc),a0
	move.l	(sp),d0
	and.w	#$0f,d0
	ext.l	d0
	addq.l	#1,d0
	moveq	#1,d1
	bsr	decout_nolead

	lea	.two_byte_number(pc),a0
	moveq	#2,d0
	move.l	4(sp),a1
	jsr	Text(a6)

	addq.w	#8,sp
	rts


.two_byte_number
	dc.b	0,0





SetInactiveNumberRemap
	lea	MTremapStruct(a5),a1
SetInactiveNumber	; d1=GadgetID

	tst.b	kick30(a5)
	beq.s	.v37

	lea	.39tags(pc),a3
	bra	SetAttrs2

.39tags	DC.L	$80080000+72,1		; FrontPen
	dc.l	0

.v37	moveq	#1,d0
	bra	SetV37NumberPen






;==============================================================
;
;  Reqtools String Requester ffnen
;
;==============================================================

rtString	; a2=^buffer, d1=size(ohne $00),
		; d0=locale-number of ReqTitle
		; zurck: d0=pos/neg
	movem.l	d1/a2,-(sp)

	jsr	getcatstringJ(a5)
	move.l	a1,a2

	move.l	a2,a0
	bsr	stringlength
	move.l	a2,a0
	move.l	Scr(a5),a1
	lea	$54(a1),a1		; Rastport
	move.l	gfxbas(a5),a6
	jsr	TextLength(a6)
	moveq	#30,d1
	add.l	d1,d0

	lea	.rtStringTags(pc),a0
	move.l	d0,.rt_width(a0)
	movem.l	(sp)+,d0/a1
	suba.l	a3,a3
	move.l	rtbas(a5),a6
	jsr	rtGetStringA(a6)
	tst.l	d0
	beq.s	.neg
	POSITIV
.neg	NEGATIV


.rtStringTags
	dc.l	$80000006,pubname	; RT_PubScrName
.rt_width = *+4-.rtStringTags
	dc.l	$80000020,280		; RTGL_Width
	dc.l	0





;==============================================================
;
;  Reqtools Long-Integer Requester ffnen
;
;==============================================================

	IFEQ	1

rtLong_body_minmax	; d1=defaultwert, d0=ReqTitle locale-number
			; d2=min-value, d3=max-value
			; d4=body-locale
			; zurck: d0=success, d1.l=Integer

	movem.l	d0-d1,-(sp)

	lea	.moretags(pc),a0

	move.w	d4,d0
	jsr	getcatstringJ(a5)
	move.l	a1,.more_text(a0)

	lea	rtLongTags+rtL_end(pc),a1
	moveq	#2,d0
	move.l	d0,(a1)+
	move.l	a0,(a1)

	movem.l	(sp)+,d0-d1
	bra.s	rtLong_minmax


.moretags
.more_text = *+4-.moreTags
	dc.l	$80000026,0		; RTGL_TextFmt
	dc.l	$80000016,4		; RTGL_Flags (CENTERTEXT)
	dc.l	0

	ENDC



rtLong_minmax	; d1=defaultwert, d0=ReqTitle locale-number
		; d2=min-value, d3=max-value
		; zurck: d0=success, d1.l=Integer

	move.l	d0,-(sp)

	lea	rtLongTags+rtL_end(pc),a0
	lea	.moretags(pc),a1
	moveq	#2,d0

	tst.l	(a0)
	beq.s	.isend
	move.l	4(a0),.more_more+4(a1)
	move.l	d0,.more_more(a1)
	bra.s	.set
.isend	clr.l	.more_more(a1)
.set
	move.l	d0,(a0)+
	move.l	a1,(a0)

	move.l	d2,.more_min(a1)
	move.l	d3,.more_max(a1)

	move.l	(sp)+,d0
	bra.s	rtLong_kern


.moretags
.more_min = *+4-.moreTags
	dc.l	$8000001e,0		; RTGL_Min
.more_max = *+4-.moreTags
	dc.l	$8000001f,0		; RTGL_Max
.more_more = *-.moreTags
	dc.l	0,0



rtLong	; d1=defaultwert, d0=ReqTitle locale-number
	; zurck: d0=success, d1.l=Integer

;	lea	rtLongTags(pc),a0
;	clr.l	rtL_end(a0)		; no more tags there


rtLong_kern	; d1=defaultwert, d0=ReqTitle locale-number
		; zurck: d0=success, d1.l=Integer

	move.l	d1,-(sp)

	jsr	getcatstringJ(a5)
	move.l	a1,a2

	move.l	a2,a0
	bsr	stringlength
	move.l	a2,a0
	move.l	Scr(a5),a1
	lea	$54(a1),a1		; Rastport
	move.l	gfxbas(a5),a6
	jsr	TextLength(a6)
	moveq	#30,d1
	add.l	d1,d0

	suba.l	a3,a3
	lea	rtLongTags(pc),a0
	move.l	d0,rtL_width(a0)
	lea	.puffer(pc),a1
	move.l	(sp)+,(a1)
	move.l	rtbas(a5),a6
	jsr	rtGetLongA(a6)

	lea	rtLongTags+rtL_end(pc),a0
	clr.l	(a0)

	tst.l	d0
	beq.s	.nonum
	move.l	.puffer(pc),d1
	POSITIV
.nonum	NEGATIV


.puffer	dc.l	0


rtLongTags
	dc.l	$80000006,pubname	; RT_PubScrName
rtL_width = *+4-rtLongTags
	dc.l	$80000020,280		; RTGL_Width
	dc.l	$80000021,1		; RTGL_ShowDefault
rtL_end = *-rtLongTags
	dc.l	0,0





SingleChoice	; a0 = ^array of strings, NULL-terminated
		; d0 = windowtitle locale
		; d2/d3 = left-top window-coords relative to screen
		; d4.l = active listview entry number
		; d5.l = userdata option:
		;        0 = pgfx autodetect controlsource
		; returns: d1=choice, starting with 0; pos/neg


	move.l	d5,singlechoice_options(a5)


;=== open our window, with a listview gadget in it
	lea	MTsingStruct(a5),a4
	bsr	.RefreshSC
	beq	.cancelled
	bsr	OpenWD
	bne	.cancelled

.singevent
	moveq	#0,d0
	move.l	MTsingStruct+wd_Wnd(a5),a0
	move.l	$56(a0),a0
	move.b	$f(a0),d1
	bset	d1,d0

	tst.l	singlechoice_options(a5)
	bne.s	.nopgfx
	move.l	midiin_port_main(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0
.nopgfx
	move.l	(a5),a6
	jsr	Wait(a6)


	tst.l	singlechoice_options(a5)
	bne.s	.nextmsg

.midiloop
	move.l	midiin_port_main(a5),a0
	jsr	GetMsg(a6)
	tst.l	d0
	beq.s	.nomidi
	move.l	d0,a1

	lea	$16(a1),a0
	move.b	(a0)+,d0
	and.b	#$f0,d0
	cmp.b	#$b0,d0
	bne.s	.donttake

	move.b	(a0),d0			; received controller
	move.l	array_codes(a5),a0
	move.l	a0,d1
	move.l	csources_array(a5),a2
.findloop
	tst.l	(a2)+
	beq.s	.donttake
	cmp.b	(a0)+,d0
	bne.s	.findloop
	sub.l	a0,d1
	not.l	d1
	bra.s	.found

.donttake
	jsr	ReplyMsg(a6)
	bra.s	.midiloop

.found	move.l	d1,-(sp)
	jsr	ReplyMsg(a6)
	bsr	.closed
	move.l	(sp)+,d1
	POSITIV

.nomidi




.nextmsg
	move.l	MTsingStruct+wd_Wnd(a5),a0
	move.l	$56(a0),a0
	move.l	gadbas(a5),a6
	jsr	GT_GetIMsg(a6)
	tst.l	d0
	beq	.singevent
	move.l	d0,a1

	move.l	$14(a1),d4	; im_Class
	move.w	$18(a1),d5	; im_Code
	move.l	$2c(a1),a4	; im_Window
	jsr	GT_ReplyIMsg(a6)

	subq.l	#4,d4
	beq.s	.wdrefresh
	sub.l	#$40-4,d4
	beq	.singgadgetup
	sub.l	#$200-$40,d4
	beq.s	.closed
	sub.l	#$400000-$200,d4
	beq.s	.intuiticks

.next	bra	.nextmsg


.wdrefresh
	jsr	window_refreshJ(a5)
	bra.s	.nextmsg

.intuiticks
	bsr	Generalintuiticks
	bra.s	.nextmsg

.cancelled
.closed
	lea	MTsingStruct(a5),a4
	bsr	CloseWD
	lea	s_choice_nodes(a5),a0
	jsr	MyFreeVectorJ(a5)
	NEGATIV


.singgadgetup
	move.l	d5,-(sp)
	bsr.s	.cancelled
	move.l	(sp)+,d1
	ext.l	d1
	POSITIV





.RefreshSC

;=== construct listview structure
	movem.l	d0/d2-d3,-(sp)
	bsr.s	.setup_listview
	movem.l	(sp)+,d0/d2-d3
	beq.s	.nega

;=== localize windowtitle
	jsr	getcatstringJ(a5)
	lea	MTsingWindowTags(pc),a0
	move.l	a1,MTsingWT(a0)

;=== locate window under mouse-pointer
	move.l	$14(a0),d0			; dx
	lsr.l	#1,d0
	sub.l	d0,d2
	bpl.s	.x_ok
	moveq	#0,d2
.x_ok	move.l	d2,$4(a0)

	move.l	$1c(a0),d1			; dy
	lsr.l	#1,d1
	sub.l	d1,d3
	bpl.s	.y_ok
	moveq	#0,d3
.y_ok	move.l	d3,$c(a0)



	POSITIV
.nega	NEGATIV




.setup_listview	; a0=^array of strings (maximum is 65535 strings)

	lea	s_choice_nodes(a5),a1
	lea	s_choice_root(a5),a2
	bsr.s	generate_lv_nodes
	beq.s	.neg

	lea	MTsingGTags(pc),a0
	move.l	a2,MTsingGTcslist(a0)
	move.l	d4,MTsingGTactive(a0)
	move.l	d4,MTsingGTvis(a0)
	move.w	fontheight(a5),d0
	addq.w	#1,d0
	move.w	d0,MTsingGTfheight(a0)

	mulu	d0,d1
	add.w	#9,d1
.subloop
	cmp.w	#150,d1
	bls.s	.subout
	sub.w	d0,d1
	bra.s	.subloop
.subout
	lea	MTsingNGads(pc),a0
	move.w	d1,GD_singchoice*ng_sizeof+ng_height(a0)
	add.w	#10,d1
	lea	MTsingWindowTags(pc),a0
	move.w	d1,MTsingYsize(a0)

	POSITIV
.neg	NEGATIV




generate_lv_nodes	; a0=^array of strings (maximum is 65535 strings)
			; a1=pointer to address of nodes
			; a2=^root listhead
			; returns: pos/neg, d1.l=#nodes added

	movem.l	a0-a4,-(sp)

	move.l	a1,a0
	jsr	MyFreeVectorJ(a5)

	move.l	(sp),a0
	moveq	#-1,d0
.count_them
	tst.l	(a0)+
	dbeq	d0,.count_them
	not.l	d0
	beq.s	.error

	move.l	d0,d2
	mulu	#$e,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	4(sp),a0
	move.l	d0,(a0)
	beq.s	.error

	move.l	d0,a0
	move.l	a2,a3
	move.l	a0,(a3)
	clr.l	4(a3)
	move.l	a3,a1
	lea	$e(a0),a2
	move.l	(sp),a4

	move.l	d2,d1			; set returnvalue in d1
.nodeloop
	subq.l	#1,d2
	beq.s	.nomore

	move.l	a2,(a0)
	move.l	a1,4(a0)
	clr.w	8(a0)
	move.l	(a4)+,10(a0)

	move.l	a0,a1
	move.l	a2,a0
	lea	$e(a2),a2
	bra.s	.nodeloop
.nomore

	move.l	a0,8(a3)
	lea	4(a3),a2
	move.l	a2,(a0)
	move.l	a1,4(a0)
	clr.w	8(a0)
	move.l	(a4)+,10(a0)


	movem.l	(sp)+,a0-a4
	POSITIV

.error	movem.l	(sp)+,a0-a4
	NEGATIV





		rsreset
GD_singchoice	rs.b	1

MTsing_CNT	rs.b	1



MTsingNGads
	NEWGAD	2,1,188,90,*,-1,GD_singchoice,$0008



MTsingGTags
MTsingGTcslist = *+4-MTsingGTags
	DC.L	$80080006,0		; ^Listroot
	DC.L	$80080008,24		; width of scrollbar
MTsingGTfheight = *+6-MTsingGTags
	DC.L	$8008004f,9		; item height (V39)
MTsingGTactive = *+4-MTsingGTags
	DC.L	$80080036,0		; selected
MTsingGTvis = *+4-MTsingGTags
	dc.l	$8008004e,0		; make visible (v39)
	DC.L	$80080035,0		; show selected
	DC.L	$00000000



MTsingWindowTags
	DC.L	$80000064,0		; x/y coords are calculated relative
	DC.L	$80000065,0		; to mouse-pointer
	DC.L	$80000066,200
MTsingYsize = *+6-MTsingWindowTags
	DC.L	$80000067,100
	DC.L	$8000006A,singWIDCMP
	DC.L	$8000006B,singWFlags
MTsingWG = *+4-MTsingWindowTags
	DC.L	$8000006C,0
MTsingWT = *+4-MTsingWindowTags
	DC.L	$8000006E,0
MTsingST = *+4-MTsingWindowTags
	DC.L	$8000006F,0
MTsingSC = *+4-MTsingWindowTags
	DC.L	$80000079,0
	DC.L	$80000090,1		; AutoAdjust
	DC.L	$00000000


MTsingGTypes	DC.b	4


		even






;==============================================================
;
;  CD Directory
;
;==============================================================

	IFEQ	1

GoStartCD

	move.l	startcdnameD(a5),a0
;	bra.s	DoCD

;	move.l	startcd(a5),d1
;	beq.s	.neg
;	move.l	dosbas(a5),a6
;	jsr	DupLock(a6)
;	move.l	d0,d1
;	beq.s	.neg

;	bsr.s	DoCDLock
;	beq.s	.neg

;	POSITIV
;.neg	NEGATIV



DoCD	; a0 = ^Dirname
	; returns: pos/neg

	move.l	a0,d1
;	move.l	a0,d2
;	move.l	dosbas(a5),a6
;	jsr	SetCurrentDirName(a6)
;	tst.l	d0
;	beq.s	.neg

;	move.l	d2,d1
	moveq	#-2,d2			; Shared lock
	jsr	Lock(a6)
	move.l	d0,d1
	beq.s	.neg

	move.l	d1,d2
	jsr	CurrentDir(a6)
	move.l	currentlock(a5),d1
	beq.s	.nolock
	jsr	UnLock(a6)
.nolock	move.l	d2,currentlock(a5)

	POSITIV
.neg	NEGATIV

	ENDC



OpenFileFromFR		; a0 = ^filereq-structure
			; d2 = openflags
			; returns: d0 = fh

	move.w	fr_name(a0),d0
	lea	(a5,d0.w),a1
	move.w	fr_path(a0),d0
	lea	(a5,d0.w),a0
	bsr.s	CompleteFilename

	move.l	dosbas(a5),a6
	jsr	Open(a6)
	tst.l	d0
	rts



CompleteFilename	; a0 = ^path or NULL for startup directory, a1 = ^filename
			; returns: d1 = ^full filename

	movem.l	d2-d3/a0-a1,-(sp)

	move.l	a0,d0
	bne.s	.ispath
	move.l	startcdnameD(a5),a0
.ispath
	move.l	complete_filenameD(a5),a1
	COPYTILLZERO

	move.l	12(sp),d2
	move.l	complete_filenameD(a5),d1
	move.l	#256,d3
	move.l	dosbas(a5),a6
	jsr	AddPart(a6)
	tst.l	d0
	bne.s	.ok
	move.l	12(sp),d1
	bra.s	.cont
.ok	move.l	complete_filenameD(a5),d1
.cont
	movem.l	(sp)+,d2-d3/a0-a1
	rts



;==============================================================
;
;  EZ Requester von Reqtools
;
;==============================================================

EZrequest_async
		; a1=^body, a2=^gadgets (werden hier localized!)
		; d0=locale-number body, d1=locale-number gadfmt
		; a4=^argarray (falls 1. char von (a1) = '!')

	lea	rt_ez_tags+rt_ez_reqhandler(pc),a0
	move.l	#$80000008,(a0)+
	move.l	a1,d2
	lea	ez_handlerinfo(a5),a1
	move.l	a1,(a0)+
	move.l	d2,a1

	moveq	#2,d2		; REQPOS_CENTERSCR
	bra.s	EZrequest_routine2

EZrequest_centerscr
		; a1=^body, a2=^gadgets (werden hier localized!)
		; d0=locale-number body, d1=locale-number gadfmt
		; a4=^argarray (falls 1. char von (a1) = '!')

	moveq	#2,d2		; REQPOS_CENTERSCR
	bra.s	EZrequest_routine


EZrequest	; 
		; d0=locale-number body, d1=locale-number gadfmt
		; a4=^argarray (falls 1. char von body = '!')
		; returns: d0=0 for negative answer, 1 or more for positive

	moveq	#0,d2		; REQPOS_POINTER


EZrequest_routine	; d2=reqpos

	lea	rt_ez_tags+rt_ez_reqhandler(pc),a0
	moveq	#1,d3		; TAG_IGNORE
	move.l	d3,(a0)

EZrequest_routine2	; d2=reqpos


;
; Ein einleitendes '!' bedeutet, da im Body %-Begriffe
; vorkommen (knnen).
;
; Speziell:
; Wenn im BODY der erste Character ein '!' ist, bedeutet das, da
; im Body ein oder zwei %s vorkommen, die die Version und das
; Release-Date reprsentieren.
; In diesem Fall darf a4 also nicht auf NULL gesetzt werden.
;


	movem.l	d0-d2/a3-a4,-(sp)

; get gadfmt-string
	move.l	d1,d0
	jsr	getcatstringJ(a5)
	move.l	a1,-(sp)

; get body-string
	move.l	0+4(sp),d0
	jsr	getcatstringJ(a5)
	move.l	a1,-(sp)


	move.l	rtbas(a5),a6
	move.l	rt_ezreq(a5),d0
	bne.s	.alreadyhere
;=== Requesterstruktur allocaten
	moveq	#1,d0			; RT_REQINFO
	suba.l	a0,a0
	jsr	rtAllocRequestA(a6)
	move.l	d0,rt_ezreq(a5)
	beq.s	.neg
.alreadyhere
	move.l	d0,a3

	lea	rt_ez_tags(pc),a0
	move.l	8+8(sp),rt_ez_reqpos(a0)
	move.l	MTmainStruct+wd_Wnd(a5),rt_ez_window(a0)
	bne.s	.wcont
	move.l	iconifyWnd(a5),rt_ez_window(a0)
	bne.s	.wcont
	addq.w	#8,a0			; skip RT_Window tag
.wcont	movem.l	(sp)+,a1-a2
	cmpi.b	#'!',(a1)+
	beq.s	.jsr
	subq.w	#1,a1
	suba.l	a4,a4
.jsr	jsr	rtEZRequestA(a6)
.out	addq.w	#4,sp
	movem.l	(sp)+,d1-d2/a3-a4
	tst.l	d0
	rts

.neg	addq.w	#8,sp
	moveq	#0,d0			; "NO" simulieren (cancel)
	bra.s	.out


rt_ez_tags
rt_ez_window = *+4-rt_ez_tags
	dc.l	$80000000+1,0		; RT_Window
rt_ez_reqpos = *+4-rt_ez_tags
	dc.l	$80000000+3,0		; RT_ReqPos
	dc.l	$80000000+20,ez_title	; RTEZ_Title
	dc.l	$80000000+22,4		; RTEZ_Flags
	dc.l	$80000000+11,'_'	; RT_Underscore
	dc.l	$80000000+13,1		; RT_LockWindow
rt_ez_reqhandler = *-rt_ez_tags
	dc.l	$80000000+8,0
	dc.l	0

ez_title
	dc.b	'MidiTracker Request',0
	even





;==============================================================
;
;  Auto Requester (ohne reqtools)
;
;==============================================================

SysRequest	; a1=^bodyText, a2=^posText, a3=^NegText
	lea	.body_itext(pc),a0
	move.l	a1,$c(a0)
	lea	.pos_itext(pc),a0
	move.l	a2,$c(a0)
	lea	.neg_itext(pc),a0
	move.l	a3,$c(a0)

	suba.l	a0,a0
	lea	.body_itext(pc),a1
	lea	.pos_itext(pc),a2
	tst.l	$c(a2)
	bne.s	.pos
	suba.l	a2,a2
.pos	lea	.neg_itext(pc),a3
	moveq	#0,d0
	moveq	#0,d1
	move.l	intbas(a5),a6
	jsr	AutoRequest(a6)
	tst.l	d0
	rts

.body_itext
	DC.B	1,0
	DC.B	$01
	DC.B	0
	DC.W	100,50
	DC.L	0	; default font
	DC.L	0	; text
	DC.L	0
.pos_itext
	DC.B	1,0
	DC.B	$01
	DC.B	0
	DC.W	0,0
	DC.L	0	; default font
	DC.L	0	; text
	DC.L	0
.neg_itext
	DC.B	1,0
	DC.B	$01
	DC.B	0
	DC.W	0,0
	DC.L	0	; default font
	DC.L	0	; text
	DC.L	0





;==============================================================
;
;  Statuszeile im Sample Processor Window setzen
;
;==============================================================

;=== Spezialfall: Alright-Text setzen

;sproc_alright
;	move.w	#loc_allright,d0


;sproc_status	; a1=^Status Msg (default-locale), d0=locale number
;	pea	set_wdtitle_sproc(pc)

;	jsr	getcatstringJ(a5)
;	move.l	a1,a0
;	move.l	sprocTitle(a5),a1
;	moveq	#sproctitle_len-1,d0
;	bra.s	copytitle


;==============================================================
;
;  Statuszeile im Mainwindow setzen
;
;==============================================================

;status_display_noloc	; a1=^Status Msg (ohne localize)
;	bsr.s	status_fill2
;	bra	set_wdtitle_main

cancel_status
	move.w	#loc_op_cancel,d0
	bra.s	status_display

allright_status
	move.w	#loc_allright,d0
	bsr.s	status_display
	clr.b	allright_count(a5)
	rts

status_display	; d0=Status Msg locale-number
	bsr.s	status_fill
	bra	set_wdtitle_main


status_fill	; d0=Status Msg locale-number
	jsr	getcatstringJ(a5)
;status_fill2	; ohne localize
	move.b	#okstatus_time,allright_count(a5)
	move.l	a1,a0
	lea	MTmainWTitle(pc),a1
	moveq	#status_size-1,d0



;=== Kopieren von (d0-1) Bytes von (a0) nach (a1)
;=== Dabei werden restliche Bytes mit Spaces aufgefllt.

copytitle	;  a0=^Msg (source), a1=^Windowtitle (dest)
		; d0.w=maxlen-1

.copy	move.b	(a0)+,(a1)+
	dbeq	d0,.copy
	bne.s	.nofill
	subq.w	#1,a1
	moveq	#' ',d1
.fill	move.b	d1,(a1)+
	dbf	d0,.fill
.nofill	rts




MTmainWTitle
	dcb.b	status_size+1,' '	; plus one extra space
;cutbufpos = *-MTmainWTitle
;	dc.b	' '			; "B" Buffered cutting
;joindomipos = *-MTmainWTitle
;	dc.b	' '			; "J" dominant joining
;delb4recpos = *-MTmainWTitle
;	dc.b	' '			; "C" cut chan before recording
;autovelpos = *-MTmainWTitle
;	dc.b	' '			; "V" auto velocity enabled
ignorepos = *-MTmainWTitle
	dc.b	' '			; "I" Ignore Note-OFFs
playdispos = *-MTmainWTitle
	dc.b	' '			; "D" Play disabled Tracks
;extclockpos = *-MTmainWTitle
;	dc.b	' '			; "X" External Clock
seqsysexpos = *-MTmainWTitle
	dc.b	' '			; "S" send Sequencer Sysex
haltpattpos = *-MTmainWTitle
	dc.b	' '			; "H" Halt record when patt ends
mtcpos = *-MTmainWTitle
	dc.b	' '			; "M" sending MTC
;omnipos = *-MTmainWTitle
;	dc.b	' '			; "O" omni-mode enabled
kactpos = *-MTmainWTitle
	dc.b	' '			; "K" Keyboard actions enabled
	dc.b	' Oct='
octavepos = *-MTmainWTitle
	dc.b	' '			; "1" - "9" current keyboard octave
	dc.b	' '
;blockpos = *-MTmainWTitle
;	dc.b	'         '		; '0000-0000' block start/stop
;	dc.b	' '
changedpos = *-MTmainWTitle
	dc.b	' '			; "*" Song Changed Flag
	dc.b	' '
songnamepos = *-MTmainWTitle
	dcb.b	songnamesize+2,' '	; 2 bytes leading/trailing quotes
	dc.b	0

	even



nomemory
	move.w	#loc_nomemory,d0
	move.w	#loc_ohmygod,d1
	jmp	EZrequestJ(a5)




;==============================================================
;
;  WindowTitle neu setzen
;
;==============================================================

set_wdtitle_inst	; d0 = active window (0-15)
	move.l	d0,d2
	bsr.s	get_inst_struct
	move.l	d2,d0
	bsr	get_inst_wdtitle
	bra.s	setwdtitle
set_wdtitle_sysex
	lea	MTsysexStruct(a5),a0
	bra.s	setwdtitle
;set_wdtitle_sds
;	lea	MTsdsStruct(a5),a0
;	bra.s	setwdtitle
set_wdtitle_k2k
	lea	MTk2kStruct(a5),a0
	bra.s	setwdtitle
set_wdtitle_quadra
	lea	MTquadraStruct(a5),a0
	bra.s	setwdtitle
set_wdtitle_chan
	move.l	chanTitle(a5),a1
	lea	MTchanStruct(a5),a0
	bra.s	setwdtitle
set_wdtitle_pgfx
	move.l	pgfxTitle(a5),a1
	lea	MTpgfxStruct(a5),a0
	bra.s	setwdtitle
;set_wdtitle_sproc
;	move.l	sprocTitle(a5),a1
;	lea	MTsprocStruct(a5),a0
;	bra.s	setwdtitle
set_wdtitle_main
	lea	MTmainWTitle(pc),a1
	lea	MTmainStruct(a5),a0
setwdtitle	; a1=^windowtitle, a0=windowstruct
	move.l	wd_Wnd(a0),d0		; Miditracker iconified ?
	beq.s	.rts
	move.l	d0,a0
	lea	-1.w,a2
	move.l	intbas(a5),a6
	jmp	SetWindowTitles(a6)
.rts	rts





get_inst_struct	; d0.l = number (0-15)
		; returns: a0 = ^windowstruct

	lea	MTinst1struct(a5),a0
	mulu	#wd_structsize,d0
	adda.l	d0,a0
	rts






;==============================================================
;
;  Windowtitle refreshen
;
;==============================================================

set_songname
	lea	songheader+so_songname(a5),a0
	tst.b	(a0)
	bne.s	.nodef
	move.w	#loc_nosongname,d0
	jsr	getcatstringJ(a5)
	move.l	a1,a0
	lea	MTmainWTitle+songnamepos(pc),a1
	moveq	#songnamesize+2-1,d0		; +2 is for quotes
	bsr	copytitle
	bra.s	set_wdtitle_main


;=== real songnames are surrounded by quotes

.nodef	lea	MTmainWTitle+songnamepos(pc),a1
	move.b	#'"',(a1)+			; leading quote
	moveq	#songnamesize-1,d0
	bsr	copytitle

;=== find the last char which does not equal to space, and put a quote there

	lea	MTmainWTitle+songnamepos+songnamesize+2(pc),a0
	moveq	#songnamesize+2-1,d0
	moveq	#' ',d2
.findloop
	move.b	-(a0),d1
	cmp.b	d2,d1
	dbne	d0,.findloop
	move.b	#'"',1(a0)			; trailing quote

	bra.s	set_wdtitle_main







allright_timer
	tst.b	playflag(a5)
	bne.s	.rts

	tst.b	allright_count(a5)
	beq.s	.rts
	subq.b	#1,allright_count(a5)
	bne.s	.rts
	bra	allright_status

.rts	rts




;==============================================================
;
;  This routine is called on INTUITICKS events in every window!
;
;==============================================================

GeneralIntuiticks
	move.l	a4,a0


all_purpose_intuiticks	; a0=^window
	move.l	a0,-(sp)
	bsr.s	allright_timer
	move.l	(sp)+,a0
	bsr.s	screentitledisplay		; a0 is input for this
	bsr	perform_midi_activity		; refresh midi activity display
	bra	record_status			; show how much recbuf is filled



;==============================================================
;
;  Speicher in Screentitle refreshen
;
;==============================================================

freememory_routine
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AvailMem(a6)
	cmp.l	oldmemory(a5),d0
	beq.s	.out
	move.l	d0,oldmemory(a5)

	move.l	screentitle(a5),a0
	adda.w	availmempos(a5),a0
	moveq	#freemembytes-1,d1
	bsr	decout_nolead

	moveq	#1,d7
.out
	rts



screentitledisplay	; a0=^Window

	tst.b	gadgethelp_open(a5)
	bne.s	.rts


	moveq	#0,d7		; wenn nachher !=0 -> neuer Screentitle

	tst.b	ghelp_released(a5)
	beq.s	.skipt
	sf	ghelp_released(a5)
	moveq	#1,d7
	bra.s	.go
.skipt


; refresh each 5th intuitick

	subq.b	#1,intuiticks_count(a5)
	bpl.s	.rts
.go	move.b	#4,intuiticks_count(a5)


	move.l	a0,-(sp)

	bsr.s	freememory_routine


	IFEQ	1

	tst.b	titleclock(a5)
	bne.s	.doclock

	tst.b	titleclockoff(a5)
	beq	.noclock
	sf	titleclockoff(a5)

	move.l	screentitle(a5),a0
	adda.w	clockpos(a5),a0
	moveq	#' ',d1
	moveq	#clockbytes-1,d0
.spaceloop
	move.b	d1,(a0)+
	dbf	d0,.spaceloop

	moveq	#1,d7
	bra	.noclock

.doclock
	lea	-$c-$10(sp),sp
	move.l	sp,d1
	move.l	dosbas(a5),a6
	jsr	DateStamp(a6)
	move.l	8(sp),d0
	divu	#50,d0
	cmp.w	oldseconds(a5),d0
	beq	.nonewclock
	move.w	d0,oldseconds(a5)


	move.l	locbas(a5),d1
	beq.s	.noloc

	move.l	locale(a5),d0
	beq.s	.noloc
	move.l	d0,a0

	move.l	d1,a6
	move.l	sp,a2			; date stamp

	lea	-$14(sp),sp
	move.l	sp,a3			; hook
	clr.l	(a3)
	clr.l	4(a3)
	lea	.datehook(pc),a1
	move.l	a1,$8(a3)
	move.l	screentitle(a5),a1
	adda.w	clockpos(a5),a1
	move.l	a1,$10(a3)

	move.l	$50(a0),a1		; (long) time format
	jsr	FormatDate(a6)
	lea	$14(sp),sp
	bra.s	.cont

.datehook
	move.l	a1,d0
	tst.b	d0
	beq.s	.rts
	move.l	$10(a0),a2
	move.b	d0,(a2)+
	move.l	a2,$10(a0)
	rts



;=== if locale is not available

.noloc
	move.l	sp,d1
	clr.w	$c(sp)
	clr.l	$e(sp)
	clr.l	$12(sp)
	move.l	screentitle(a5),a0
	adda.w	clockpos(a5),a0
	move.l	a0,$16(sp)
	jsr	DateToStr(a6)
	move.l	$16(sp),a0
	move.b	#' ',8(a0)	; Nullbyte durch Space ersetzen

.cont	moveq	#1,d7

.nonewclock
	lea	$c+$10(sp),sp


.noclock

	ENDC



	tst.l	d7
	beq.s	.nochange

	move.l	(sp),a0
	moveq	#-1,d0
	move.l	d0,a1
	move.l	screentitle(a5),a2
	move.l	intbas(a5),a6
	jsr	SetWindowTitles(a6)
.nochange

	move.l	(sp)+,a0

.rts	rts






;==============================================================
;
;  Refresh mainwindow-title, show how much recbuf is filled in percent
;
;==============================================================

record_status
	tst.b	playflag(a5)
	ble.s	.nochange

	tst.w	audpasses_togo(a5)
	bne.s	.nochange

;=== Bei Record soll der Pufferverbrauch im Windowtitle gezeigt werden.
	move.l	recbufpos(a5),d0

; d0 = d0*100
	move.l	d0,d1
	lsl.l	#4,d1
	move.l	d0,d2
	lsl.l	#3,d2
	add.l	d2,d1
	add.l	d1,d0
	lsl.l	#2,d0

	move.l	recbufsizebytes(a5),d1
	LONGDIVU
	cmp.b	lastrecbuf_full(a5),d0
	beq.s	.nochange

	move.b	d0,lastrecbuf_full(a5)
	move.l	d0,-(sp)


	move.w	#loc_recstatus,d0
	move.l	sp,a0
	bsr.s	status_display_rawdo
	addq.w	#4,sp

.nochange
	rts





status_display_rawdo	; d0 = locale-number, a0 = data

	move.l	a0,-(sp)
	jsr	getcatstringJ(a5)
	move.l	a1,a0
	move.l	(sp)+,a1
	bsr.s	rawdo_status

	move.b	#okstatus_time,allright_count(a5)
	jmp	set_wdtitle_mainJ(a5)




;=== Status display with %-commands

rawdo_status	; a0=^string, a1=datastream

	lea	.count(pc),a2
	clr.w	(a2)

	lea	.stuffchar(pc),a2
	move.l	MTmainWTitleD(a5),a3
	move.l	(a5),a6
	jmp	RawDoFmt(a6)


.count	dc.w	0

.stuffchar
	movem.l	a0/d1,-(sp)
	lea	.count(pc),a0
	addq.w	#1,(a0)
	cmpi.w	#status_size,(a0)
	bhi.s	.dont
	tst.b	d0
	bne.s	.nozero
	moveq	#' ',d0
	moveq	#status_size-1,d1
	sub.w	(a0),d1
	bcs.s	.skip
.spaceloop
	move.b	d0,(a3)+
	dbf	d1,.spaceloop
.skip	bra.s	.dont

.nozero	move.b	d0,(a3)+
.dont	movem.l	(sp)+,a0/d1
	rts






;==============================================================
;
;  Hexadezimaler Output von d0
;
;==============================================================

hexout	; a0=^puf, d0=value, d1.w=len-1
	; verbraucht d2

	lea	1(a0,d1.w),a0
	move.l	a0,a1
.loop	move.b	d0,d2
	and.w	#$000f,d2
	move.b	hexlist(pc,d2.w),-(a1)
	lsr.l	#4,d0
	dbf	d1,.loop
	rts

hexlist	dc.b	'0123456789ABCDEF'





;==============================================================
;
;  Dezimalzahl ausgeben, linksbndig
;
;==============================================================

decout_ljustified	; a0=^puffer, d0=wert, d1=#stellen-1
			; verbraucht d2,d3,a1,a2
			; a0 steht nachher hinter der letzten Ziffer

	move.l	a0,a1
	move.w	d1,d3
	bsr.s	decout
	move.l	a1,a0
	moveq	#'0',d0
	move.w	d3,d1
.tloop	cmp.b	(a1)+,d0
	dbne	d1,.tloop
	beq.s	.out1
	cmp.w	d1,d3
	beq.s	.out2

	sub.w	d1,d3
	subq.w	#1,a1
.cloop	move.b	(a1)+,(a0)+
	dbf	d1,.cloop

.in1	subq.w	#1,d3
	moveq	#' ',d0
.sloop	move.b	d0,-(a1)
	dbf	d3,.sloop
	rts

.out2	lea	1(a0,d3.w),a0
	rts

.out1	addq.w	#1,a0
	bra.s	.in1





;==============================================================
;
;  Dezimalzahl ausgeben ohne fhrende Nullen
;
;==============================================================

decout_nolead	; a0=^puffer, d0=wert, d1=#stellen-1
		; verbraucht d2,d3,a1,a2
		; a0 steht nachher hinter dem letzten Zeichen

	move.l	a0,a1
	move.w	d1,d3
	bsr.s	decout
	moveq	#'0',d0
	moveq	#' ',d1
.tloop	cmp.b	(a1),d0
	bne.s	.out
	move.b	d1,(a1)+
	dbf	d3,.tloop
	addq.w	#1,d3
	bne.s	.out
	move.b	d0,-(a1)	; Damit bei wert=0 eine Null da steht
.out	rts



;==============================================================
;
;  Dezimalzahl ausgeben (mit fhrenden Nullen)
;
;==============================================================

decout	; a0=^puffer, d0=wert, d1=#stellen-1
	; verbraucht d2, a2
	; a0 steht nachher hinter dem letzten Zeichen

	move.w	d1,d2
	IFEQ	mc68020
	lsl.w	#2,d2
	lea	.dectab(pc,d2.w),a2
	ELSE
	lea	.dectab(pc,d2.w*4),a2
	ENDC
.loop	move.l	-(a2),d1
	beq.s	.rts
	moveq	#-1,d2
.inloop	addq.b	#1,d2
	sub.l	d1,d0
	bcc.s	.inloop
	add.l	d1,d0
	addi.b	#'0',d2
	move.b	d2,(a0)+
	bra.s	.loop
.rts	rts

	dc.l	0
	dc.l	1
.dectab
	dc.l	10
	dc.l	100
	dc.l	1000
	dc.l	10000
	dc.l	100000
	dc.l	1000000
	dc.l	10000000
	dc.l	100000000
	dc.l	1000000000
	dc.l	10000000000





;==============================================================
;
;  Get decimal value from string
;
;==============================================================

getdec		; a0 = ^source string (0-terminated)
		; 
		; returns: d1 = LONG, pos/neg, a0 = behind numberstring

	moveq	#0,d1

.spaceloop
	cmp.b	#' ',(a0)+
	beq.s	.spaceloop
	subq.w	#1,a0

.getloop
	moveq	#0,d2
	move.b	(a0)+,d2
	beq.s	.out
	sub.b	#'0',d2
	bcs.s	.error
	cmp.b	#9,d2
	bhi.s	.error
	move.l	d1,d0	; = mulu.l #10,d1
	lsl.l	#3,d0	;
	add.l	d1,d1	;
	add.l	d0,d1	;
	add.l	d2,d1
.skipspace
	bra.s	.getloop

.out	subq.w	#1,a0
	POSITIV
.error	NEGATIV



;==============================================================
;
;  Get hexadecimal value from string
;
;==============================================================

gethex		; a0=^source string (0-terminated)
		; zurck: d1=LONG, pos/neg

	moveq	#0,d1
.getloop
	moveq	#0,d2
	move.b	(a0)+,d2
	beq.s	.out

	cmp.b	#'A',d2
	bcc.s	.char
	subi.b	#'0',d2
	bcs.s	.error
	cmp.b	#9,d2
	bhi.s	.error
	bra.s	.ok

.char	and.b	#$df,d2
	sub.b	#'A'-$a,d2
	cmp.b	#$a,d2
	bcs.s	.error
	cmp.b	#$f,d2
	bhi.s	.error
.ok	lsl.l	#4,d1
	add.l	d2,d1
	bra.s	.getloop

.out	POSITIV
.error	NEGATIV





;==============================================================
;
;  Mousepointer busy
;
;==============================================================

SysexBusyPointer
	lea	MTsysexStruct(a5),a0
	bra.s	BusyPointer
K2kBusyPointer
	lea	MTk2kStruct(a5),a0
	bra.s	BusyPointer
QuadraBusyPointer
	lea	MTquadraStruct(a5),a0
	bra.s	BusyPointer
MainBusyPointer
	lea	MTmainStruct(a5),a0
;	bra.s	BusyPointer
;SprocBusyPointer
;	lea	MTsprocStruct(a5),a0
BusyPointer	; a0=^Windowstruct
	move.l	wd_Wnd(a0),d0
	beq.s	.nowindow		; e.g. if iconified
	move.l	d0,a0

	tst.b	kick30(a5)
	bne.s	.ks30

	lea	BusyImage,a1
	moveq	#16,d0
	moveq	#16,d1
	moveq	#-6,d2
	moveq	#0,d3

	move.l	intbas(a5),a6
	jmp	SetPointer(a6)

.nowindow
	rts


;=== V39 Routine

.ks30	lea	.busytags(pc),a1
	move.l	intbas(a5),a6
	jmp	SetWindowPointerA(a6)	; V39
.busytags
	dc.l	$80000063+$35,1		; WA_BusyPointer
;	dc.l	$80000063+$36,1		; WA_PointerDelay
	dc.l	0



;==============================================================
;
;  Mousepointer active
;
;==============================================================

SysexActivePointer
	lea	MTsysexStruct(a5),a0
	bra.s	ActivePointer
K2kActivePointer
	lea	MTk2kStruct(a5),a0
	bra.s	ActivePointer
QuadraActivePointer
	lea	MTquadraStruct(a5),a0
	bra.s	ActivePointer
MainActivePointer
	lea	MTmainStruct(a5),a0
;	bra.s	ActivePointer
;SprocActivePointer
;	lea	MTsprocStruct(a5),a0
ActivePointer	; a0=^Windowstruct
	move.l	wd_Wnd(a0),d0
	beq.s	.nowindow		; e.g. if iconified
	move.l	d0,a0

	tst.b	kick30(a5)
	bne.s	.ks30

	move.l	intbas(a5),a6
	jmp	ClearPointer(a6)

.nowindow
	rts


;=== V39 Routine

.ks30	lea	.activetags(pc),a1
	move.l	intbas(a5),a6
	jmp	SetWindowPointerA(a6)	; V39
.activetags
	dc.l	0	; <no tags> = clear pointer



;==============================================================
;
;  Adjust tracks in the right way, refresh them
;
;==============================================================

RefreshTracks
	move.l	currenttrack(a5),d0
	bmi.s	.fresh

	cmp.l	displaytrack(a5),d0
	bcc.s	.above

;=== currenttrack ist links vom displaytrack
	move.l	d0,displaytrack(a5)
	bra.s	.redraw

.above	sub.l	displaytrack(a5),d0
	cmp.l	displayed_tracks(a5),d0
	bmi.s	.fresh

;=== currenttrack ist rechts neben den tracks
	move.l	currenttrack(a5),d0
	sub.l	displayed_tracks(a5),d0
	addq.l	#1,d0
	move.l	d0,displaytrack(a5)

.redraw	bsr.s	RefreshNums
.fresh	bra	RedrawPatternOhneScr




;==============================================================
;
;  Track-Gadgets refreshen
;
;==============================================================

RefreshTrackSel

;=== Track-scroller updaten

	move.l	displaytrack(a5),d0
	move.l	maxtracks(a5),d2
	move.l	displayed_tracks(a5),d3
	move.l	d2,d1
	sub.l	d3,d1
	cmp.l	d1,d0
	bls.s	.ok
	move.l	d1,displaytrack(a5)	; fix displaytrack(a5) if
	move.l	d1,d0			; necessary
.ok
	moveq	#GD_tracksel,d1
	move.l	active_channelwindow(a5),d4
	bra	SetScrollerInst



RefreshNums
	bsr.s	RefreshTrackSel


RefreshNumsOhneTS

	move.l	displayed_tracks(a5),d7
	bra.s	.jin
.refreshloop

	move.l	d7,d0
	add.l	displaytrack(a5),d0
	bsr	CalcTrackStringNumber

;=== Flag fr den Track holen (on/off)
;	move.l	displaytrack(a5),d0
;	add.l	d7,d0
;	bsr.s	state_of_track
;	beq.s	.empty

	move.l	displaytrack(a5),d0
	add.l	d7,d0
	jsr	GetTrackJ(a5)
	beq.s	.empty

	tst.b	tr_onoff(a0)
	bne.s	.on
	moveq	#text_muted_pen,d0		; track inactive, filled
	bra.s	.set
.on	moveq	#text_active_pen,d0		; track active, filled
	bra.s	.set

.empty	moveq	#text_empty_pen,d0		; track empty

.set	move.l	trackStringD(a5),a0
	moveq	#GD_track0,d1
	add.l	d7,d1
	move.l	active_channelwindow(a5),d4
	bsr	SetTextInst

.jin	dbf	d7,.refreshloop

	rts




CalcTrackStringNumber	; d0.l = tracknumber (0,1,...)

	move.l	trackStringD(a5),a0
	addq.l	#3,a0			; add offset to number in string
	addq.l	#1,d0
	moveq	#1,d1
	bra	decout_nolead





	IFEQ	1

state_of_track		; d0=number of track to check,
			; returns: pos=track is filled, neg=track is empty

	move.l	d0,d2
	bsr	GetTrack
	beq.s	.empty

	move.l	events(a5),d0		; must be a 16bit value
	subq.l	#1,d0
	move.l	#track_def_entry,d1
.checkloop
	cmp.l	(a0)+,d1
	dbne	d0,.checkloop

	move.l	current_states(a5),a0
	sne	(a0,d2.l)
	rts
.empty	move.l	current_states(a5),a0
	sf	(a0,d2.l)
	rts


state_of_BPM	; returns: pos=pbtrack is filled, neg=pbtrack is empty

	bsr	GetBPMTrack
	beq.s	.empty
	moveq	#BPM_stay,d1
	bsr.s	state_of_2b
	sne	bpm_state(a5)
	rts
.empty	sf	bpm_state(a5)
	rts


state_of_2b
	move.l	events(a5),d0		; must be a 16bit value
	subq.l	#1,d0
.checkloop
	cmp.w	(a0)+,d1
	dbne	d0,.checkloop
	rts



state_of_PB	; returns: pos=pbtrack is filled, neg=pbtrack is empty

	jsr	GetPibeTrackJ(a5)
	move.w	#PB_stay,d1
	bsr.s	state_of_2b
	sne	currentpb_state(a5)
	rts
.empty	sf	currentpb_state(a5)
	rts


state_of_Pre	; returns: pos=pbtrack is filled, neg=pbtrack is empty

	jsr	GetPresetTrackJ(a5)
	beq.s	.empty
	moveq	#Preset_stay,d1
	bsr.s	state_of_2b
	sne	preset_state(a5)
	rts
.empty	sf	preset_state(a5)
	rts



;state_of_MP	; returns: pos=mptrack is filled, neg=mptrack is empty

;	move.l	mpworktrack(a5),a0
;	bsr.s	state_of_1b
;	sne	currentmp_state(a5)
;	rts


state_of_1b
	move.l	events(a5),d0		; must be a 16bit value
	subq.l	#1,d0
	move.b	#cs_stay,d1
.checkloop
	cmp.b	(a0)+,d1
	dbne	d0,.checkloop
	rts



state_of_cs	; returns: pos=pbtrack is filled, neg=pbtrack is empty
; call this routine ONLY if a controlsource other than pitchbend, mpress is
; the current one!

	move.w	pgfx_active(a5),d0
	subq.w	#1,d0
	move.w	d0,d2
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.empty
	bsr.s	state_of_1b
	lea	cs_states(a5),a0
	sne	(a0,d2.w)
	rts
.empty	lea	cs_states(a5),a0
	sf	(a0,d2.w)
	rts


	ENDC


	IFEQ	1

state_of_current_channel

	move.w	currentchannel(a5),d0

state_of_any_channel	; d0.w = channelnumber (1-16)
			; returns: pos = channel is filled,
			;          neg = channel is empty

	bsr	GetAnyChannel
	beq.s	.empty

	move.l	a0,a1
	bsr	channel_is_filled
	bne.s	.filled

.empty	NEGATIV
.filled	POSITIV

	ENDC



	IFEQ	1

state_of_current_channel
		; returns: pos=channel is filled, neg=channel is empty

	tst.b	preset_state(a5)
	bne.s	.filled
	tst.b	currentpb_state(a5)
	bne.s	.filled
;	tst.b	currentmp_state(a5)
;	bne.s	.filled

	lea	cs_states(a5),a0
	move.l	active_csources_m1(a5),d0
.csloop
	tst.b	(a0)+
	dbne	d0,.csloop
	bne.s	.filled

	move.l	current_states(a5),a0
	move.l	maxtracks_m1(a5),d0
.trkloop
	tst.b	(a0)+
	dbne	d0,.trkloop
	bne.s	.filled

	NEGATIV
.filled	POSITIV




check_currenttrack_state

	move.l	currenttrack(a5),d0
	bpl	RefreshCurrenttrack

	addq.l	#1,d0
	beq.s	RefreshCSMode

	addq.l	#1,d0
	beq	RefreshPresettrack

	bra	RefreshBPMtrack


	ENDC





;==============================================================
;
;  CS-Gadget refreshen (enabled/disabled)
;
;==============================================================

RefreshCSMode

	jsr	build_cs_gadgetJ(a5)

	move.w	pgfx_active(a5),d0
	bne.s	.noPB

;=== Pitchbend
;	lea	currentpb_state(a5),a2
;	move.b	(a2),d3

;	bsr	state_of_PB
;	beq.s	.empty

	jsr	GetChannelJ(a5)
	beq.s	.empty
	tst.l	ch_pbtrack(a0)
	beq.s	.empty

	move.b	ch_pb_onoff(a0),d0

.check	tst.b	d0
	bne.s	.on
	moveq	#text_muted_pen,d0
	bra.s	.set
.on	moveq	#text_active_pen,d0
	bra.s	.set

.empty	moveq	#text_empty_pen,d0
.set
;	cmp.b	(a2),d3
;	beq.s	.same

	move.l	csStringD(a5),a0
	moveq	#GD_cstrack,d1
	move.l	active_channelwindow(a5),d4
	bsr	SetTextInst
	bra	Refresh_pgfx_lv

;.same	rts

.noPB	subq.w	#1,d0
;	bne.s	.noMP


;=== Mono Pressure
;	lea	currentmp_state(a5),a2
;	move.b	(a2),d3
;	bsr	state_of_MP
;	beq.s	.empty
;	tst.b	currentmp_onoff(a5)
;	bra.s	.check


;=== Controlsource
;.noMP
;	lea	cs_states(a5),a2
;	adda.w	d2,a2
;	move.b	(a2),d3
;	bsr	state_of_cs

	jsr	GetCSourceTrackJ(a5)
	beq.s	.empty
	move.b	cs_onoff(a0),d0
	bra.s	.check




RefreshCurrenttrack
	move.l	currenttrack(a5),d0
	move.l	d0,d4
;	move.l	current_states(a5),a0
;	move.b	(a0,d0.l),d3
;	bsr	state_of_track
;	beq.s	.empty

;	move.l	current_onoffs(a5),a0
;	tst.b	(a0,d4.l)

	jsr	GetTrackJ(a5)
	beq.s	.empty

	tst.b	tr_onoff(a0)
	bne.s	.on
	moveq	#text_muted_pen,d0
	bra.s	.cont
.on	moveq	#text_active_pen,d0
	bra.s	.cont

.empty	moveq	#text_empty_pen,d0
.cont
;	move.l	current_states(a5),a0
;	cmp.b	(a0,d4.l),d3
;	beq.s	.same

	move.l	d0,d5
	move.l	d4,d0
	bsr	CalcTrackStringNumber

	sub.l	displaytrack(a5),d4
	moveq	#GD_track0,d1
	add.l	d4,d1

	move.l	trackStringD(a5),a0
	move.l	d5,d0
	move.l	active_channelwindow(a5),d4
	bra	SetTextInst

.same	rts



RefreshBPMTrack
;	move.b	bpm_state(a5),d3
	jsr	GetBPMTrackJ(a5)
;	bsr	state_of_BPM
	beq.s	.empty
	moveq	#text_active_pen,d0
	bra.s	.cont
.empty	moveq	#text_empty_pen,d0
.cont
;	cmp.b	bpm_state(a5),d3
;	beq.s	.same

	move.l	bpmtrackStringD(a5),a0
	moveq	#GD_bpmtrack,d1
	move.l	active_channelwindow(a5),d4
	bsr	SetTextInst

	tst.b	alltrackdisplays(a5)
	beq.s	.noall

;	jsr	packchannelJ(a5)
;	jsr	depackchannelJ(a5)

	lea	chanselect_mappings+32(a5),a0
	moveq	#15,d7
.windowloop
	move.w	-(a0),d0
	beq.s	.nochan
	cmp.l	active_channelwindow(a5),d7
	beq.s	.nochan

	move.l	a0,-(sp)
	move.l	d7,d0
	bsr	RefreshBPMtrack_2
	move.l	(sp)+,a0

.nochan	dbf	d7,.windowloop
.noall

.same	rts



RefreshPresettrack
;	move.b	preset_state(a5),d3
;	bsr	state_of_Pre
	jsr	GetPresetTrackJ(a5)
	beq.s	.empty
	moveq	#text_active_pen,d0
	bra.s	.cont
.empty	moveq	#text_empty_pen,d0
.cont
;	cmp.b	preset_state(a5),d3
;	beq.s	.same

	move.l	preStringD(a5),a0
	moveq	#GD_pre,d1
	move.l	active_channelwindow(a5),d4
	bra	SetTextInst

.same	rts




;==============================================================
;
;  Pattern neu zeichnen (mit/ohne Scroller-Update)
;
;==============================================================

RedrawPattern

	move.l	active_channelwindow(a5),d0

RedrawPackedPattern	; d0.l = channelwindow

	move.l	d0,d4
	bmi.s	.rts
	jsr	get_current_channelblockJ(a5)
	tst.w	d0
	beq.s	.rts
	move.l	a0,a1

;	lea	chanselect_mappings(a5),a0
;	IFEQ	mc68020
;	move.l	d4,d0
;	add.l	d0,d0
;	move.w	(a0,d0.l),d0
;	ELSE
;	move.w	(a0,d4.l*2),d0
;	ENDC
;	beq.s	.rts

	bsr	GetAnyChannelResolution
	move.l	d0,d1

	move.l	chan_lines_in_td_half(a1),d3
	bsr.s	UpdatePatternscroller_routine

	move.l	d4,d0
	bra.s	RedrawPattern_routine

.rts	rts


;RedrawPattern

;	bsr	GetChannelResolution
;	move.l	d0,d1
;	move.l	active_channelwindow(a5),d4
;	lea	current_channelblock(a5),a1
;	bsr.s	UpdatePatternscroller_routine
;	bra.s	RedrawPatternOhneScr


UpdatePatternscroller_routine	; d4 = channelwindow, a1 = ^channelblock
				; d1 = pattscale

	move.l	chan_eventpos(a1),d0
	divu	d1,d0
	ext.l	d0
; d0 = top

	move.l	events(a5),d2
	divu	d1,d2
	ext.l	d2
; d2 = total

	move.l	chan_lines_in_td_half(a1),d3
	add.l	d3,d3
	add.l	d3,d2
	addq.l	#1,d3
; d3 = visible

	moveq	#GD_pattscroller,d1
	bra	SetScrollerInst



RedrawPatternOhneScr

	move.l	active_channelwindow(a5),d0


RedrawPattern_routine	; d0 = channelwindow

	tst.l	iconify(a5)
	bne	.iconified
	tst.l	MTmainStruct+wd_Wnd(a5)
	beq	.iconified

	move.l	d0,-(sp)
	bmi	.fix1




	lea	tdbitmap_chans(a5),a0
	IFEQ	mc68020
	move.l	d0,d2
	lsl.l	#2,d2
	move.l	(a0,d2.l),tdbitmap(a5)
	ELSE
	move.l	(a0,d0.l*4),tdbitmap(a5)
	ENDC
	beq	.fix1		; we have no bitmap due to errors



	lea	tdbitmap_height_chans(a5),a0
	IFEQ	mc68020
	move.l	(a0,d2.l),tdbitmap_height(a5)
	ELSE
	move.l	(a0,d0.l*4),tdbitmap_height(a5)
	ENDC

	lea	tdbitmap_bpr_chans(a5),a0
	IFEQ	mc68020
	move.l	(a0,d2.l),tdbitmap_bpr(a5)
	ELSE
	move.l	(a0,d0.l*4),tdbitmap_bpr(a5)
	ENDC

	lea	tdbitmap_width_chans(a5),a0
	IFEQ	mc68020
	move.l	(a0,d2.l),tdbitmap_width(a5)
	ELSE
	move.l	(a0,d0.l*4),tdbitmap_width(a5)
	ENDC

	lea	tdbitmap_multtab_chans(a5),a0
	IFEQ	mc68020
	move.l	(a0,d2.l),tdbitmap_multtab(a5)
	ELSE
	move.l	(a0,d0.l*4),tdbitmap_multtab(a5)
	ENDC

	lea	emptybitmap_chans(a5),a0
	IFEQ	mc68020
	move.l	(a0,d2.l),emptybitmap(a5)
	ELSE
	move.l	(a0,d0.l*4),emptybitmap(a5)
	ENDC
	beq	.fix1


	tst.b	playflag(a5)
	beq.s	.normal

	tst.b	pattout(a5)
	beq	.slow_amiga

.normal

;	cmp.l	active_channelwindow(a5),d0
;	beq.s	.active
;	bsr	CreatePatterntextPacked
;	beq	.fix1
;	bra.s	.acont
.active
	bsr	CreatePatterntext
	beq	.fix1
;.acont


	move.l	a0,-(sp)		; ^postext



;=== Copy original bitmap into work-bitmap

;=== source bitmap
	move.l	emptybitmap(a5),a0
	moveq	#0,d0
	moveq	#0,d1

;=== dest bitmap
	move.l	tdbitmap(a5),a1
	moveq	#0,d2
	moveq	#0,d3

	move.l	tdbitmap_width(a5),d4
	move.l	tdbitmap_height(a5),d5
	move.b	#$c0,d6				; Minterm (vanilla copy)
	moveq	#$03,d7
	suba.l	a2,a2

	move.l	gfxbas(a5),a6
	jsr	BltBitMap(a6)
	jsr	WaitBlit(a6)	; BltBitmap does NOT wait for the blitter!




;=== Put all those chars into our work-bitmap manually

	move.l	(sp)+,a0

	bsr	.get_td_chunkybuffer
	beq.s	.notd

	bsr	.get_patternfont_bitplane
	beq.s	.nofont

	move.l	tdbitmap_multtab(a5),a2
	move.l	tdbitmap_bpr(a5),d4



; the position setter will calculate the bitplanes by itself.
	lea	.pos_setter(pc),a4
	bsr	.make_column


	tst.b	cgx_bitmaps(a5)
	bne.s	.cgx4
	move.l	tdbitmap(a5),a1
	move.l	8(a1),d7			; ^1st bitplane
.cgx4

	lea	.bpm_setter(pc),a4
	bsr	.make_column
	lea	.pre_setter(pc),a4
	bsr	.make_column
	lea	.cs_setter(pc),a4
	bsr	.make_column

	move.l	dtracks_temp(a5),-(sp)
	move.w	#tracktextx,tracksetter_x(a5)
.maketrackloop
	lea	.track_setter(pc),a4
	bsr	.make_column
	addq.w	#tracktextd,tracksetter_x(a5)
	subq.l	#1,(sp)
	bne.s	.maketrackloop

	addq.l	#4,sp

	bsr	.free_patternfont_lock

.nofont

	move.l	(sp),d0
	jsr	get_current_channelblockJ(a5)
	move.l	a0,a4
	; d0 = channel
	move.l	(sp),d1
	bsr	poke_block

	; a4 = channelblock
	bsr	poke_cursor

	bsr	.free_tdbitmap_lock

.notd

;=== Set new writemask
;	move.l	MTmainStruct+wd_Wnd(a5),a1
;	move.l	$32(a1),a0
;	move.b	$18(a0),old_writemask(a5)
;	moveq	#3,d0
;	bsr	PutWriteMask


;=== dest rastport
	move.l	(sp),d0
	bsr	get_inst_struct
	move.l	wd_Wnd(a0),a1
	move.l	$32(a1),a1
	movem.l	wd_LeftTop(a0),d2-d3
;	add.w	#tdbegin_x+tdbitmap_srcx,d2
	add.w	#tdbegin_x,d2
	add.w	#tdbegin_y,d3

;=== source bitmap
	move.l	tdbitmap(a5),a0
;	moveq	#tdbitmap_srcx,d0
	moveq	#0,d0
	moveq	#0,d1

	move.l	tdbitmap_width(a5),d4
;	sub.l	d0,d4
	move.l	tdbitmap_height(a5),d5
	move.b	#$c0,d6
	move.l	gfxbas(a5),a6
	jsr	BltBitmapRastport(a6)


;=== Restore old writemask
;	move.l	MTmainStruct+wd_Wnd(a5),a1
;	move.l	$32(a1),a0
;	move.b	old_writemask(a5),d0
;	bsr	PutWriteMask



	bsr	songchange



.fix1
	move.l	(sp)+,d0

.iconified
	rts





.get_patternfont_bitplane	; returns: a6 = ^bitplane or chunky buffer
				; preserves a0

	move.l	patternfont_rp(a5),a6		; rastport
	move.l	4(a6),a6			; bitmap

	tst.b	cgx_bitmaps(a5)
	bne.s	.cgx2
	move.l	8(a6),a6			; the only bitplane
	bra.s	.pos
.cgx2
	move.l	a0,-(sp)

	lea	.locktags(pc),a1
	subq.l	#4,sp
	move.l	sp,4(a1)
	move.l	a6,a0
	move.l	cgxbas(a5),a6
	jsr	LockBitMapTagList(a6)
	move.l	(sp)+,a6
	move.l	(sp)+,a0
	move.l	d0,cgx_pfont_lock(a5)
	beq.s	.neg

.pos	POSITIV
.neg	NEGATIV


.free_patternfont_lock
	move.l	cgx_pfont_lock(a5),d0
	beq.s	.nocgx2
	move.l	d0,a0
	move.l	cgxbas(a5),a6
	jsr	UnLockBitMap(a6)
	clr.l	cgx_pfont_lock(a5)
.nocgx2	rts


.get_td_chunkybuffer	; returns: d7 = ^chunky buffer
			; preserves a0

	tst.b	cgx_bitmaps(a5)
	beq.s	.pos

	move.l	a0,-(sp)

	lea	.locktags(pc),a1
	subq.l	#4,sp
	move.l	sp,4(a1)
	move.l	tdbitmap(a5),a0
	move.l	cgxbas(a5),a6
	jsr	LockBitMapTagList(a6)
	move.l	(sp)+,d7
	move.l	(sp)+,a0
	move.l	d0,cgx_tdbitmap_lock(a5)
	beq.s	.neg
	bra.s	.pos


.free_tdbitmap_lock
	move.l	cgx_tdbitmap_lock(a5),d0
	beq.s	.nocgx3
	move.l	d0,a0
	move.l	cgxbas(a5),a6
	jsr	UnLockBitMap(a6)
	clr.l	cgx_tdbitmap_lock(a5)
.nocgx3	rts





.locktags
	dc.l	$84001007,0	; LBMI_BASEADDRESS
	dc.l	0




.slow_amiga	; d0 = channelwindow

	move.l	d0,d4

	bsr	get_postext
	beq	.fix1
	move.l	a0,a3

;	cmp.l	active_channelwindow(a5),d4
;	beq.s	.active2

	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	add.l	d4,d4
	move.w	(a0,d4.l),d0
	ELSE
	move.w	(a0,d4.l*2),d0
	ENDC
	beq	.fix1
	bsr	GetAnyChannelResolution
	move.l	d0,d1

	move.l	eventpos(a5),d0
	divu	d1,d0
;	swap	d0
;	tst.w	d0
;	bne.s	.fix1

;	swap	d0
	ext.l	d0
	moveq	#2,d1
	move.l	a3,a0
	move.b	#1,(a0)+	; black pen
	bsr	decout



;=== Put all chars into our work-bitmap manually

	move.l	a3,a0

	bsr	.get_td_chunkybuffer
	beq.s	.notd2

	bsr	.get_patternfont_bitplane
	beq.s	.nofont2

	move.l	tdbitmap_multtab(a5),a2
	move.l	tdbitmap_bpr(a5),d4

	tst.b	cgx_bitmaps(a5)
	bne.s	.cgx5

	move.l	tdbitmap(a5),a1
	move.l	8(a1),d7

; clear 2nd bitmap
	move.l	12(a1),a3
	moveq	#0,d0
	move.l	d0,(a3)
	move.l	d0,(a3,d4.w)
	move.w	d4,d1
	add.w	d1,d1

	REPT	3
	adda.w	d1,a3
	move.l	d0,(a3)
	move.l	d0,(a3,d4.w)
	ENDR

.cgx5


	moveq	#0,d1		; y
	moveq	#0,d3		; x position in bytes
	moveq	#1,d2		; black
	bsr	.3_setter

	bsr	.free_patternfont_lock

.nofont2

	bsr	.free_tdbitmap_lock

.notd2

;=== Set new writemask
;	move.l	MTmainStruct+wd_Wnd(a5),a1
;	move.l	$32(a1),a0
;	move.b	$18(a0),old_writemask(a5)
;	moveq	#3,d0
;	bsr	PutWriteMask


;=== dest rastport
	move.l	(sp),d0
	jsr	get_current_channelblockJ(a5)
	move.l	chan_lines_in_td_half(a0),d3
	move.w	d3,d4	; = mulu #10,d1
	add.w	d4,d4	;
	lsl.w	#3,d3	;
	add.w	d4,d3	;
	add.w	#tdbegin_y+3+3,d3 ; +3 = top offset, +3 = middle offset

	move.l	(sp),d0
	bsr	get_inst_struct
	move.l	wd_Wnd(a0),a1
	move.l	$32(a1),a1

	movem.l	wd_LeftTop(a0),d2/d4
	add.w	#tdbegin_x+postextx*8,d2
	add.w	d4,d3


;=== source bitmap
	move.l	tdbitmap(a5),a0
	moveq	#0,d0
	moveq	#0,d1

	moveq	#3*8,d4
	moveq	#8,d5
	move.b	#$c0,d6
	move.l	gfxbas(a5),a6
	jsr	BltBitmapRastport(a6)


;=== Restore old writemask
;	move.l	MTmainStruct+wd_Wnd(a5),a1
;	move.l	$32(a1),a0
;	move.b	old_writemask(a5),d0
;	bsr	PutWriteMask

	bra	.fix1








.make_column
	moveq	#2+1,d1
	move.l	litdh_temp(a5),d6
	subq.l	#1,d6
.upperhalf_loop
	jsr	(a4)
	add.w	#10,d1
	dbf	d6,.upperhalf_loop

	addq.w	#2,d1
	jsr	(a4)
	addq.w	#2,d1

	move.l	litdh_temp(a5),d6
	subq.l	#1,d6
.lowerhalf_loop
	add.w	#10,d1
	jsr	(a4)
	dbf	d6,.lowerhalf_loop

.rts	rts




.pos_setter
	move.b	(a0)+,d0
	beq.s	.skip_pos

	tst.b	cgx_bitmaps(a5)
	bne.s	.cgx3

	subq.b	#1,d0
	beq.s	.blackpos
	subq.b	#1,d0
	beq.s	.whitepos
	subq.b	#1,d0
	bne.s	.skip_pos
; blue pen
	bsr.s	.blackpos
	subq.l	#3,a0
.whitepos
	move.l	tdbitmap(a5),a1
	move.l	12(a1),d7
	bra.s	.dopos
.blackpos
	move.l	tdbitmap(a5),a1
	move.l	8(a1),d7
.cgx3
.dopos	moveq	#postextx,d3
	bra.s	.3_setter

.skip_pos
	addq.l	#3,a0
	rts





.bpm_setter
	moveq	#bpmtextx,d3
	moveq	#1,d0
	bra.s	.6_setter

.pre_setter
	moveq	#presettextx,d3
	moveq	#1,d0
	bra.s	.7_setter

.cs_setter
	moveq	#cstextx,d3
	moveq	#1,d0
	bra.s	.4_setter

.track_setter
	move.w	tracksetter_x(a5),d3
	moveq	#1,d0
	bra.s	.5_setter

.7_setter
	bsr.s	.charout
	addq.w	#1,d3
.6_setter
	bsr.s	.charout
	addq.w	#1,d3
.5_setter
	bsr.s	.charout
	addq.w	#1,d3
.4_setter
	bsr.s	.charout
	addq.w	#1,d3
.3_setter
	bsr.s	.charout
	addq.w	#1,d3
	bsr.s	.charout
	addq.w	#1,d3

;=== es geht weiter!



.charout	; a0=^char, d3=x (planar-bytes), d1=y, d7 = ^bitplane

		; for cgx bitmaps: d0 = colour, d7 = ^chunky buffer

;=== a0 steht nachher ein Zeichen weiter
;=== d0/d1/d3 werden nicht verndert

	move.l	d7,a1			; ^bitmap
	IFEQ	mc68020
	move.w	d1,d2
	lsl.w	#2,d2
	adda.l	(a2,d2.w),a1
	ELSE
	adda.l	(a2,d1.w*4),a1
	ENDC

	moveq	#0,d2
	move.b	(a0)+,d2

	tst.b	cgx_bitmaps(a5)
	bne	.cgx

; calc offset to font
	lea	-' '(a6,d2.l),a3

; calc bitmap offset
	adda.w	d3,a1			; add x-offset in bytes

	move.l	pfont_width(a5),d0

; poke character

	IFEQ	mc68020

	move.l	d0,d2
	add.l	d2,d2

	REPT	3
	move.b	(a3),(a1)
	move.b	(a3,d0.l),(a1,d4.l)
	adda.l	d2,a3
	adda.l	d4,a1
	adda.l	d4,a1
	ENDR
	move.b	(a3),(a1)
	move.b	(a3,d0.l),(a1,d4.l)

	ELSE

	move.b	(a3),(a1)			; row 0
	move.b	(a3,d0.l),(a1,d4.l)		; row 1
	move.b	(a3,d0.l*2),(a1,d4.l*2)		; row 2
	move.b	(a3,d0.l*4),(a1,d4.l*4)		; row 4

	lea	(a1,d4.l*4),a1
	lea	(a3,d0.l*4),a3
	move.b	(a3,d0.l*2),(a1,d4.l*2)		; row 6
	suba.l	d4,a1
	suba.l	d0,a3
	move.b	(a3),(a1)			; row 3
	move.b	(a3,d0.l*2),(a1,d4.l*2)		; row 5
	move.b	(a3,d0.l*4),(a1,d4.l*4)		; row 7

	ENDC

	rts

.cgx

; routine must preserve d0

; calc offset to font
	sub.b	#' ',d2
	IFEQ	mc68020
	lsl.l	#3,d2
	lea	(a6,d2.l),a3
	ELSE
	lea	(a6,d2.l*8),a3
	ENDC

; calc bitmap offset
	IFEQ	mc68020
	move.w	d3,d2
	lsl.w	#3,d2
	adda.w	d2,a1			; add x-offset in bytes
	ELSE
	lea	(a1,d3.w*8),a1
	ENDC


; poke character

	move.b	d0,d2
	lsl.l	#8,d2
	move.b	d0,d2
	lsl.l	#8,d2
	move.b	d0,d2
	lsl.l	#8,d2
	move.b	d0,d2

	moveq	#7,d5
.charloop
	move.l	(a3),(a1)
	and.l	d2,(a1)
	move.l	4(a3),4(a1)
	and.l	d2,4(a1)
	adda.l	pfont_width(a5),a3
	adda.l	d4,a1
	dbf	d5,.charloop

	rts





;=== Replacement for SetWriteMask(): takes care of correct kickstart

PutWriteMask	; a0=^rp, d0.b=writemask
	tst.b	kick30(a5)
	bne.s	.kick30
	move.b	d0,$18(a0)
	rts
.kick30	move.l	gfxbas(a5),a6
	jmp	SetWriteMask(a6)





notetable
	dc.b	'C-0C#0D-0D#0E-0F-0F#0G-0G#0A-0A#0B-0'
	dc.b	'C-1C#1D-1D#1E-1F-1F#1G-1G#1A-1A#1B-1'
	dc.b	'C-2C#2D-2D#2E-2F-2F#2G-2G#2A-2A#2B-2'
	dc.b	'C-3C#3D-3D#3E-3F-3F#3G-3G#3A-3A#3B-3'
	dc.b	'C-4C#4D-4D#4E-4F-4F#4G-4G#4A-4A#4B-4'
	dc.b	'C-5C#5D-5D#5E-5F-5F#5G-5G#5A-5A#5B-5'
	dc.b	'C-6C#6D-6D#6E-6F-6F#6G-6G#6A-6A#6B-6'
	dc.b	'C-7C#7D-7D#7E-7F-7F#7G-7G#7A-7A#7B-7'
	dc.b	'C-8C#8D-8D#8E-8F-8F#8G-8G#8A-8A#8B-8'
	dc.b	'C-9C#9D-9D#9E-9F-9F#9G-9G#9A-9A#9B-9'
	even





;=== Block farblich in wei einfrben  (von Hand in Bitmap schreiben)

poke_block	; a4 = ^channelblock, d0.w = channel, d1 = channelwindow

	tst.b	chan_blockmarked(a4)
	beq.s	.rts
	tst.b	playflag(a5)
	bne.s	.rts

	move.l	d0,d2
	move.b	chan_blockmarktype(a4),d0
	bgt	.mark_channel

	bsr	.poke_routine

	move.b	chan_blockmarktype(a4),d1
	beq	.mark_track
	addq.b	#1,d1
	beq.s	.mark_csource
	addq.b	#1,d1
	beq.s	.mark_preset

;=== mark BPM

.poke_bpm
	moveq	#bpmtextx,d4
	tst.b	cgx_bitmaps(a5)
	bne.s	.poke_6b_cgx

	adda.l	d4,a1
	subq.w	#6,d5
.pokeloop_6b
	st	(a1)+
	st	(a1)+
	st	(a1)+
	st	(a1)+
	st	(a1)+
	st	(a1)+
	adda.w	d5,a1
	dbf	d3,.pokeloop_6b
.rts	rts

.poke_6b_cgx
	moveq	#6*8,d1
	bra.s	.poke_cgx



.mark_preset

.poke_pre
	moveq	#presettextx,d4

	tst.b	cgx_bitmaps(a5)
	bne.s	.poke_7b_cgx

	adda.l	d4,a1
	subq.w	#7,d5
.pokeloop_7b
	st	(a1)+
	st	(a1)+
	st	(a1)+
	st	(a1)+
	st	(a1)+
	st	(a1)+
	st	(a1)+
	adda.w	d5,a1
	dbf	d3,.pokeloop_7b
	rts

.poke_7b_cgx
	moveq	#7*8,d1
.poke_cgx
	IFEQ	mc68020
	lsl.l	#3,d4
	adda.l	d4,a1
	ELSE
	lea	(a1,d4.l*8),a1
	ENDC
	sub.l	d1,d5
	subq.l	#1,d1
	move.l	d1,d2
	moveq	#2,d0
.pokeloop_cgx
	move.l	d2,d1
.inner_ploop
	or.b	d0,(a1)+
	dbf	d1,.inner_ploop
	adda.l	d5,a1
	dbf	d3,.pokeloop_cgx
	rts




.mark_csource

.poke_CS
	tst.w	chan_pgfx_active(a4)
	bne.s	.noPB
	moveq	#cstextx,d4

	tst.b	cgx_bitmaps(a5)
	bne.s	.poke_4b_cgx

	adda.l	d4,a1
	subq.w	#4,d5
.pokeloop_4b
	st	(a1)+
	st	(a1)+
	st	(a1)+
	st	(a1)+
	adda.w	d5,a1
	dbf	d3,.pokeloop_4b
	rts

.poke_4b_cgx
	moveq	#4*8,d1
	bra.s	.poke_cgx

.noPB	moveq	#cstextx+1,d4

	tst.b	cgx_bitmaps(a5)
	bne.s	.poke_2b_cgx

	adda.l	d4,a1
	subq.w	#2,d5
.pokeloop_2b
	st	(a1)+
	st	(a1)+
	adda.w	d5,a1
	dbf	d3,.pokeloop_2b
	rts

.poke_2b_cgx
	moveq	#2*8,d1
	bra.s	.poke_cgx






.mark_track
	move.l	chan_blocktrack(a4),d4
	move.l	chan_displaytrack(a4),d0
	cmp.l	d0,d4
	bcs.s	.outrange
	add.l	chan_displayed_tracks(a4),d0
	cmp.l	d0,d4
	bcc.s	.outrange
	sub.l	chan_displayed_tracks(a4),d0
	sub.l	d0,d4
	mulu	#tracktextd,d4
	add.w	#tracktextx,d4

.poke_track	; d4 = track-xoffset in planar-bytes

	tst.b	cgx_bitmaps(a5)
	bne.s	.poke_track_cgx

	adda.l	d4,a1
	subq.w	#tracktextd-1,d5
.pokeloop
	REPT	tracktextd-1
	st	(a1)+
	ENDR
	adda.w	d5,a1
	dbf	d3,.pokeloop
.outrange
	rts

.poke_track_cgx
	moveq	#(tracktextd-1)*8,d1
	bra	.poke_cgx




.poke_routine	; d2 = channel
		; returns: d5 = bytes per row, a1 = ^bitplane mit x-offset,
		;          d3 = # lines-1

	move.l	d2,d0
	bsr	GetAnyChannelResolution

	tst.b	cgx_bitmaps(a5)
	bne.s	.cgx_block
	move.l	tdbitmap(a5),a1
	move.l	12(a1),a1			; ^bitplane #2
	bra.s	.cgxc
.cgx_block
	move.l	d7,a1
.cgxc


	move.l	chan_blockstart(a4),d2
	move.l	chan_blockstop(a4),d3



; The startrow and stoprow (d2/d3) are given in the range
; from 0 to (lines_in_td_half*2) .

;            blockstart - (eventpos - lines_in_td_half*pattscale)
; startrow = ----------------------------------------------------
;                             pattscale

	move.l	chan_eventpos(a4),d1
	move.l	d0,d4
	mulu	chan_lines_in_td_half+2(a4),d0
	sub.l	d0,d1
	sub.l	d1,d2
	bpl.s	.y_ok1
	moveq	#0,d2
	bra.s	.y_ok2
.y_ok1	divu	d4,d2
	ext.l	d2
	move.l	d2,d5
	mulu	#10,d2		; rows are now in pixels
;=== fix the mid-row
	cmp.l	chan_lines_in_td_half(a4),d5
	bcs.s	.noadd1
	addq.w	#2,d2
.noadd1
.y_ok2
	addq.l	#2+1,d2		; top offset



;           blockstop - (eventpos - lines_in_td_half*pattscale)
; stoprow = ---------------------------------------------------
;                            pattscale

	sub.l	d1,d3
	add.l	d0,d0
	cmp.l	d0,d3
	ble.s	.mul
	move.l	d0,d3
.mul	divu	d4,d3
	ext.l	d3
	move.l	d3,d5
	mulu	#10,d3		; rows are now in pixels

	move.l	chan_lines_in_td_half(a4),d0
	cmp.l	d0,d5
	bcs.s	.noadd2
	addq.w	#2,d3
	addq.l	#1,d0
	cmp.l	d0,d5
	bcs.s	.noadd2
	addq.w	#2,d3
.noadd2

	add.w	#2+1+8-1,d3	; top offset, inline offset, midrow ysize, -1 because of dbf
	sub.l	d2,d3


	move.l	tdbitmap_multtab(a5),a0
	IFEQ	mc68020
	lsl.w	#2,d2
	adda.l	(a0,d2.w),a1
	ELSE
	adda.l	(a0,d2.w*4),a1
	ENDC

	move.l	tdbitmap_bpr(a5),d5		; bytes per row
	rts






.mark_channel
	bsr	.poke_routine

;=== BPM
	movem.l	d3/d5/a1,-(sp)
;	addq.w	#bpmtextx,a1
;	bsr	.poke_bpm

;=== Preset
;	movem.l	(sp),d3/d5/a1
	bsr	.poke_pre

;=== Controlsource
	movem.l	(sp),d3/d5/a1
	bsr	.poke_CS

;=== Tracks
	moveq	#tracktextx,d4
	move.l	chan_displayed_tracks(a4),d6
	subq.l	#1,d6
.trackloop
	movem.l	(sp),d3/d5/a1
	move.l	d4,a2
	bsr	.poke_track
	move.l	a2,d4
	addq.l	#tracktextd,d4
	dbf	d6,.trackloop

	lea	$c(sp),sp
	rts







poke_cursor	; a4 = ^channelblock

	tst.b	editmode(a5)
	beq.s	.nocursor

	st	chan_cursorset(a4)

	move.l	a4,a0
	bsr	calc_cursor

	move.l	tdbitmap_multtab(a5),a0
	IFEQ	mc68020
	lsl.w	#2,d1
	move.l	(a0,d1.w),d1
	ELSE
	move.l	(a0,d1.w*4),d1
	ENDC

	move.l	tdbitmap_bpr(a5),d5

	tst.b	cgx_bitmaps(a5)
	bne.s	.cgx

	move.l	tdbitmap(a5),a1
	move.l	12(a1),a2			; ^bitplane #2
	move.l	8(a1),a1			; ^bitplane #1

	lsr.w	#3,d0
	ext.l	d0
	add.l	d1,d0
	adda.l	d0,a1
	adda.l	d0,a2

	subq.w	#1,d3
	cmp.w	#8,d2
	beq.s	.onespace
	bra.s	.threespaces

.nocursor
	sf	chan_cursorset(a4)
	rts


.onespace
.oneloop
	not.b	(a1)
	not.b	(a2)
	adda.w	d5,a1
	adda.w	d5,a2
	dbf	d3,.oneloop
	rts


.threespaces
	subq.w	#3,d5
.threeloop
	not.b	(a1)+
	not.b	(a1)+
	not.b	(a1)+
	not.b	(a2)+
	not.b	(a2)+
	not.b	(a2)+
	adda.w	d5,a1
	adda.w	d5,a2
	dbf	d3,.threeloop
	rts

.cgx
	move.l	d7,a1
	ext.l	d0
	add.l	d1,d0
	adda.l	d0,a1

	moveq	#$03,d0
	subq.w	#1,d3
	sub.l	d2,d5
	subq.w	#1,d2
	move.w	d2,d1

.cursorloop_cgx
	move.w	d2,d1
.xloop	eor.b	d0,(a1)+
	dbf	d1,.xloop
	adda.l	d5,a1
	dbf	d3,.cursorloop_cgx
	rts






CreatePatterntext	; d0 = channelwindow

			rsreset
.sp_events		rs.l	1
.sp_start_event		rs.l	1
.sp_stop_event		rs.l	1
.sp_pattscale		rs.l	1
.sp_fkeys		rs.l	5
.sp_postext		rs.l	1
.sp_channel		rs.w	1
.sp_oldchannel		rs.w	1
.sp_channelwindow	rs.l	1

.sp_sizeof		rs.l	0


	lea	-.sp_sizeof(sp),sp

	move.l	d0,.sp_channelwindow(sp)


	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	add.l	d0,d0
	move.w	(a0,d0.l),d0
	ELSE
	move.w	(a0,d0.l*2),d0
	ENDC
	beq	.neg
	move.w	d0,.sp_channel(sp)
	bsr	GetAnyChannelResolution
	move.l	d0,d4
	move.l	d4,.sp_pattscale(sp)

	move.l	events(a5),d5
	move.l	d5,.sp_events(sp)

;	move.l	eventpos(a5),d7
;	move.l	lines_in_td_half(a5),d0
;	mulu	d0,d4
;	move.l	d7,d6
;	add.l	d4,d6
;	sub.l	d4,d7
;	move.l	d6,.sp_stop_event(sp)
;	move.l	d7,.sp_start_event(sp)

;	move.l	d0,litdh_temp(a5)
;	move.l	displayed_tracks(a5),dtracks_temp(a5)

	move.l	.sp_channelwindow(sp),d0
	jsr	get_current_channelblockJ(a5)
	move.l	a0,a4
	move.l	chan_lines_in_td_half(a4),d0
	move.l	chan_eventpos(a4),d7
	mulu	d0,d4
	move.l	d7,d6
	add.l	d4,d6
	sub.l	d4,d7
	move.l	d6,.sp_stop_event(sp)
	move.l	d7,.sp_start_event(sp)

	move.l	d0,litdh_temp(a5)
	move.l	chan_displayed_tracks(a4),dtracks_temp(a5)





	lea	.sp_fkeys+20(sp),a2
	moveq	#4,d4
.funcloop
	move.l	d4,d0
	move.w	.sp_channel(sp),d1
	jsr	get_function_keyJ(a5)
	move.l	d0,-(a2)
	dbf	d4,.funcloop


	move.l	.sp_channelwindow(sp),d0
	bsr	get_postext
	beq	.neg
	move.l	a0,.sp_postext(sp)

	move.w	currentchannel(a5),.sp_oldchannel(sp)
	move.w	.sp_channel(sp),currentchannel(a5)


;=== event position column


	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7

	bpl.s	.POS_posi

	moveq	#' ',d0
.POS_underloop
	clr.b	(a0)+
	REPT	postextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.POS_underloop
	moveq	#0,d7


.POS_posi
.POS_loop

;=== check for highlighting
	moveq	#1,d0

;=== if a functionkey-position appears, draw it in blue
	lea	.sp_fkeys(sp),a1
	moveq	#4,d1
.funcloop2
	cmp.l	(a1)+,d7
	dbeq	d1,.funcloop2
	bne.s	.nofunc
	moveq	#3,d0
	bra.s	.nohigh

.nofunc
;=== if a highlight-position appears, draw it in white
	tst.b	highresoflag(a5)
	beq.s	.nohigh
	move.l	d7,d1
	divu	highresoint+2(a5),d1
	swap	d1
	tst.w	d1
	bne.s	.nohigh
	moveq	#2,d0
.nohigh
	move.b	d0,(a0)+	; 1 = black, 2 = white, 3 = blue

	move.l	d7,d0
	divu	defreso+2(a5),d0
	move.l	d0,d1
	swap	d1
	tst.w	d1
	bne.s	.dashes

;=== put the number
	ext.l	d0
	moveq	#postextd-2,d1
	bsr	decout
	bra.s	.dcont

.dashes	moveq	#'-',d0
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
.dcont

;=== have we reached the display's end?
	add.l	d4,d7
	cmp.l	d6,d7
	bgt.s	.POS_out
	cmp.l	d5,d7
	bmi.s	.POS_loop


	moveq	#' ',d0
.POS_overloop
	cmp.l	d6,d7
	bgt.s	.POS_out
	clr.b	(a0)+
	REPT	postextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.POS_overloop

.POS_out








;=== BPM column

	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7

	add.l	d4,d4
	add.l	d5,d5
	add.l	d6,d6
	add.l	d7,d7
	bpl.s	.BPM_posi

	moveq	#' ',d0
.BPM_underloop
	REPT	bpmtextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.BPM_underloop

.BPM_posi
	move.l	a0,a3
	bsr	GetBPMTrack
	exg	a0,a3
.BPM_loop
	move.l	a3,d0
	beq.s	.BPM_stay
	move.w	(a3,d7.l),d0
	beq.s	.BPM_stay

	ext.l	d0
	moveq	#bpmtextd-3,d1
	bsr	decout
	move.b	-(a0),1(a0)
	move.b	-(a0),1(a0)
	move.b	#'.',(a0)
	addq.w	#3,a0
	bra.s	.BPM_cont
.BPM_stay
	moveq	#'-',d0
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	#'.',(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+

.BPM_cont
	add.l	d4,d7
	cmp.l	d6,d7
	bgt.s	.BPM_out
	cmp.l	d5,d7
	bmi.s	.BPM_loop

	moveq	#' ',d0
.BPM_overloop
	cmp.l	d6,d7
	bgt.s	.BPM_out
	REPT	bpmtextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.BPM_overloop

.BPM_out





;=== Preset column

	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7

	add.l	d4,d4
	add.l	d5,d5
	add.l	d6,d6
	add.l	d7,d7
	bpl.s	.Pre_posi

	moveq	#' ',d0
.Pre_underloop
	REPT	presettextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.Pre_underloop

.Pre_posi
	move.l	a0,a3
	jsr	GetPresetTrackJ(a5)
	exg	a3,a0
.Pre_loop
	move.l	a3,d0
	beq.s	.Pre_stay

	moveq	#0,d0
	tst.w	(a3,d7.l)
	beq.s	.Pre_stay
	moveq	#0,d0
	move.b	(a3,d7.l),d0
	moveq	#2,d1
	bsr	decout

	move.b	#'.',(a0)+

	moveq	#0,d0
	move.b	1(a3,d7.l),d0
	moveq	#2,d1
	bsr	decout
	bra.s	.Pre_cont
.Pre_stay
	moveq	#'-',d0
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	#'.',(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+

.Pre_cont
	add.l	d4,d7
	cmp.l	d6,d7
	bgt.s	.Pre_out
	cmp.l	d5,d7
	bmi.s	.Pre_loop

	moveq	#' ',d0
.Pre_overloop
	cmp.l	d6,d7
	bgt.s	.Pre_out
	REPT	presettextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.Pre_overloop

.Pre_out







;=== Controlsource column

	move.w	chan_pgfx_active(a4),d0
	beq	.PB

	subq.w	#1,d0
	move.l	a0,a3
	jsr	GetCSourceTrackDataJ(a5)
	exg	a0,a3

;	bra.s	.CS_do


;.MP	move.l	mpworktrack(a5),a3


.CS_do

	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7

	bpl.s	.CS_loop

	moveq	#' ',d0
.CS_underloop
	REPT	cstextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.CS_underloop

.CS_loop
	move.b	#' ',(a0)+

	move.l	a3,d0
	beq.s	.CS_stay
	move.b	(a3,d7.l),d0
	bmi.s	.CS_stay

	moveq	#1,d1
	bsr	hexout
	bra.s	.CS_cont
.CS_stay
	moveq	#'-',d0
	move.b	d0,(a0)+
	move.b	d0,(a0)+

.CS_cont
	move.b	#' ',(a0)+
	add.l	d4,d7
	cmp.l	d6,d7
	bgt.s	.CS_out
	cmp.l	d5,d7
	bmi.s	.CS_loop

	moveq	#' ',d0
.CS_overloop
	cmp.l	d6,d7
	bgt.s	.CS_out
	REPT	cstextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.CS_overloop

.CS_out
	bra	.PB_out




.PB
	move.l	a0,a3
	jsr	GetPibeTrackJ(a5)
	exg	a0,a3

	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7

	add.l	d4,d4
	add.l	d5,d5
	add.l	d6,d6
	add.l	d7,d7
	bpl.s	.PB_posi

	moveq	#' ',d0
.PB_underloop
	REPT	cstextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.PB_underloop

.PB_posi
	move.w	#PB_stay,d3
.PB_loop
	move.l	a3,d0
	beq.s	.PB_stay
	move.w	(a3,d7.l),d0
	cmp.w	d3,d0
	beq.s	.PB_stay

	moveq	#3,d1
	bsr	hexout
	bra.s	.PB_cont
.PB_stay
	moveq	#'-',d0
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+

.PB_cont
	add.l	d4,d7
	cmp.l	d6,d7
	bgt.s	.PB_out
	cmp.l	d5,d7
	bmi.s	.PB_loop

	moveq	#' ',d0
.PB_overloop
	cmp.l	d6,d7
	bgt.s	.PB_out
	REPT	cstextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.PB_overloop

.PB_out





;=== Normale Tracks

	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7

	lsl.l	#2,d4
	lsl.l	#2,d5
	lsl.l	#2,d6
	lsl.l	#2,d7
	movem.l	d6-d7,-(sp)

	moveq	#0,d3
.trackloop
	move.l	chan_displaytrack(a4),d0
	add.l	d3,d0
	move.l	a0,a3
	jsr	GetTrackDataJ(a5)
	exg	a0,a3

	move.l	(sp),d6
	move.l	4(sp),d7
	bpl.s	.TRK_loop

	moveq	#' ',d0
.TRK_underloop
	REPT	tracktextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.TRK_underloop

.TRK_loop
	move.l	a3,d0
	beq.s	.Vel_stay

	tst.b	chan_vel_or_pp(a4)
	bne.s	.usepp
	move.b	wd_Vel(a3,d7.l),d0
	bmi.s	.Vel_stay
	bra.s	.putvel
.usepp	move.b	wd_pp(a3,d7.l),d0
	bmi.s	.Vel_stay
.putvel	moveq	#1,d1
	bsr	hexout
	bra.s	.Vel_cont
.Vel_stay
	move.b	#'-',(a0)+
	move.b	#'-',(a0)+
.Vel_cont

	move.l	a3,d0
	beq.s	.Pitch_stay

	move.b	wd_Pitch(a3,d7.l),d0
	beq.s	.Pitch_stay
	bmi.s	.note_off
	sub.b	#12,d0	; C-0 ist 12
	ext.w	d0
	move.w	d0,d1	; =mulu #3,d0
	add.w	d1,d1	;
	add.w	d1,d0	;
	lea	notetable(pc),a1
	adda.w	d0,a1
	move.b	(a1)+,(a0)+
	move.b	(a1)+,(a0)+
	move.b	(a1)+,(a0)+
	bra.s	.Pitch_cont
.note_off
	move.b	#'O',(a0)+
	move.b	#'F',(a0)+
	move.b	#'F',(a0)+
	bra.s	.Pitch_cont
.Pitch_stay
	moveq	#'-',d0
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
.Pitch_cont

	add.l	d4,d7
	cmp.l	d6,d7
	bgt.s	.TRK_out
	cmp.l	d5,d7
	bmi.s	.TRK_loop

	moveq	#' ',d0
.TRK_overloop
	cmp.l	d6,d7
	bgt.s	.TRK_out
	REPT	tracktextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.TRK_overloop

.TRK_out
	addq.l	#1,d3
	cmp.l	chan_displayed_tracks(a4),d3
	bcs	.trackloop

	movem.l	(sp)+,d6-d7


	move.w	.sp_oldchannel(sp),currentchannel(a5)
	move.l	.sp_postext(sp),a0
	lea	.sp_sizeof(sp),sp
	POSITIV

.neg	lea	.sp_sizeof(sp),sp
	NEGATIV






get_postext	; d0 = channelwindow
		; returns: a0 = ^postext

	move.l	d0,d4
	jsr	get_current_channelblockJ(a5)
	move.l	a0,a1

	move.l	chan_lines_in_td_half(a1),d2
	move.l	chan_displayed_tracks(a1),d3

	lea	postext_chans(a5),a2
	lea	postext_litdh_dtracks(a5),a3

	IFEQ	mc68020
	move.l	d4,d0
	lsl.l	#2,d0
	tst.l	(a2,d0.l)
	ELSE
	tst.l	(a2,d4.l*4)
	ENDC
	beq.s	.new

	IFEQ	mc68020
	move.l	d4,d0
	lsl.l	#3,d0
	cmp.l	(a3,d0.l),d2
	bne.s	.new
	cmp.l	4(a3,d0.l),d3
	beq.s	.same
	ELSE
	cmp.l	(a3,d4.l*8),d2
	bne.s	.new
	cmp.l	4(a3,d4.l*8),d3
	beq.s	.same
	ENDC

.new
	bsr.s	.NewRedrawAsciiBuffer
	beq.s	.nonew

	IFEQ	mc68020
	move.l	d4,d0
	lsl.l	#3,d0
	move.l	d2,(a3,d0.l)
	move.l	d3,4(a3,d0.l)
	ELSE
	move.l	d2,(a3,d4.l*8)
	move.l	d3,4(a3,d4.l*8)
	ENDC

	move.l	a0,-(sp)
	move.l	d4,d0
	bsr.s	FreeRedrawAsciiBuffer
	move.l	(sp)+,a0

	IFEQ	mc68020
	lsl.l	#2,d4
	move.l	a0,(a2,d4.l)
	ELSE
	move.l	a0,(a2,d4.l*4)
	ENDC
	bra.s	.pos

.same
	IFEQ	mc68020
	lsl.l	#2,d4
	move.l	(a2,d4.l),a0
	ELSE
	move.l	(a2,d4.l*4),a0
	ENDC

.pos	POSITIV

.nonew	NEGATIV



.NewRedrawAsciiBuffer	; a1 = ^channelblock
			; returns: a0 = ^new postext

;postext0	rs.b	9*4			; event positions
; first byte: 0=black pen, 1=white pen, -1=blue pen

;		rs.b	9*6			; BPM track
;		rs.b	9*7			; preset track
;		rs.b	9*4			; controlsource track
;		rs.b	9*5*displayed_tracks	; note-tracks follow


	move.l	chan_displayed_tracks(a1),d0
	mulu	#tracktextd-1,d0
	moveq	#postextd+bpmtextd+presettextd+cstextd-3,d1
	add.l	d1,d0

	move.l	chan_lines_in_td_half(a1),d1
	add.l	d1,d1
	addq.l	#1,d1
	mulu	d1,d0

	moveq	#1,d1
	move.l	a1,-(sp)
	jsr	MyAllocVecJ(a5)
	move.l	(sp)+,a1
	tst.l	d0
	beq.s	.neg

	move.l	d0,a0
	POSITIV
.neg	NEGATIV



FreeRedrawAsciiBuffer	; d0 = channelwindow

	lea	postext_chans(a5),a1
	IFEQ	mc68020
	lsl.l	#2,d0
	lea	(a1,d0.l),a0
	ELSE
	lea	(a1,d0.l*4),a0
	ENDC
	jmp	MyFreeVectorJ(a5)





	IFEQ	1

CreatePatterntextPacked	; d0 = channelwindow

			rsreset
.sp_events		rs.l	1
.sp_start_event		rs.l	1
.sp_stop_event		rs.l	1
.sp_pattscale		rs.l	1
.sp_channel		rs.l	1
.sp_fkeys		rs.l	5
.sp_channelwindow	rs.l	1
.sp_postext		rs.l	1

.sp_sizeof		rs.l	0


	lea	-.sp_sizeof(sp),sp

	move.l	d0,.sp_channelwindow(sp)


	move.l	events(a5),d5
	move.l	d5,.sp_events(sp)

	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	add.l	d0,d0
	move.w	(a0,d0.l),d0
	ELSE
	move.w	(a0,d0.l*2),d0
	ENDC
	beq	.back
	bsr	GetChannelAddr
	move.l	(a0),d0
	move.l	d0,.sp_channel(sp)
	beq.s	.nochan
	move.l	d0,a0
	moveq	#0,d4
	move.w	ch_scale(a0),d4
	bra.s	.ccont
.nochan	move.l	defreso(a5),d4
.ccont	move.l	d4,.sp_pattscale(sp)

	move.l	.sp_channelwindow(sp),d0
	jsr	get_channelblock_winJ(a5)
	move.l	a0,a4
	move.l	chan_lines_in_td_half(a4),d0
	move.l	chan_eventpos(a4),d7
	mulu	d0,d4
	move.l	d7,d6
	add.l	d4,d6
	sub.l	d4,d7
	move.l	d6,.sp_stop_event(sp)
	move.l	d7,.sp_start_event(sp)


	move.l	d0,litdh_temp(a5)
	move.l	chan_displayed_tracks(a4),dtracks_temp(a5)



	lea	.sp_fkeys+20(sp),a2
	moveq	#4,d4
.funcloop
	move.l	d4,d0
	jsr	get_function_keyJ(a5)
	move.l	d0,-(a2)
	dbf	d4,.funcloop



	move.l	.sp_channelwindow(sp),d0
	bsr	get_postext
	move.l	a0,.sp_postext(sp)



;=== event position column

	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7
	bpl.s	.POS_posi

	moveq	#' ',d0
.POS_underloop
	sf	(a0)+
	REPT	postextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.POS_underloop
	moveq	#0,d7


.POS_posi
.POS_loop

;=== check for highlighting
	moveq	#0,d0

;=== if a functionkey-position appears, draw it in blue
	lea	.sp_fkeys(sp),a1
	moveq	#4,d1
.funcloop2
	cmp.l	(a1)+,d7
	dbeq	d1,.funcloop2
	bne.s	.nofunc
	moveq	#-1,d0
	bra.s	.nohigh

.nofunc
;=== if a highlight-position appears, draw it in white
	tst.b	highresoflag(a5)
	beq.s	.nohigh
	move.l	d7,d1
	divu	highresoint+2(a5),d1
	swap	d1
	tst.w	d1
	bne.s	.nohigh
	moveq	#1,d0
.nohigh
	move.b	d0,(a0)+	; 0 = black, 1 = white, -1 = blue

	move.l	d7,d0
	divu	defreso+2(a5),d0
	move.l	d0,d1
	swap	d1
	tst.w	d1
	bne.s	.dashes

;=== put the number
	ext.l	d0
	moveq	#postextd-2,d1
	bsr	decout
	bra.s	.dcont

.dashes	moveq	#'-',d0
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
.dcont

;=== have we reached the display's end?
	add.l	d4,d7
	cmp.l	d6,d7
	bgt.s	.POS_out
	cmp.l	d5,d7
	bmi.s	.POS_loop


	moveq	#' ',d0
.POS_overloop
	cmp.l	d6,d7
	bgt.s	.POS_out
	sf	(a0)+
	REPT	postextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.POS_overloop

.POS_out








;=== BPM column

	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7
	bpl.s	.BPM_posi

	moveq	#' ',d0
.BPM_underloop
	REPT	bpmtextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.BPM_underloop

.BPM_posi
	move.l	currentpatternA(a5),a3
	move.l	pt_bpmtrack(a3),d0
	bne.s	.BPM_good
	move.l	d5,d3
	bra.s	.BPM_posa
.BPM_good
	move.l	d0,a3
	moveq	#0,d3

.BPM_loop
	move.w	(a3)+,d0
	ext.l	d0
	bmi.s	.BPM_nega
	cmp.l	d7,d3
	bne.s	.BPM_noput
	moveq	#bpmtextd-3,d1
	bsr	decout
	move.b	-(a0),1(a0)
	move.b	-(a0),1(a0)
	move.b	#'.',(a0)
	addq.l	#3,a0
	add.l	d4,d7
.BPM_noput
	moveq	#-1,d0
.BPM_nega
	sub.l	d0,d3
.BPM_posa
	moveq	#'-',d0
	bra.s	.BPM_jin
.BPM_stayloop
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	#'.',(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	add.l	d4,d7
.BPM_jin
	cmp.l	d6,d7
	bgt.s	.BPM_out
	cmp.l	d5,d7
	bpl.s	.BPM_eop
	cmp.l	d3,d7
	bmi.s	.BPM_stayloop
	bra.s	.BPM_loop

.BPM_eop
	moveq	#' ',d0
.BPM_overloop
	cmp.l	d6,d7
	bgt.s	.BPM_out
	REPT	bpmtextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.BPM_overloop

.BPM_out




;=== Preset column

	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7
	bpl.s	.Pre_posi

	moveq	#' ',d0
.Pre_underloop
	REPT	presettextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.Pre_underloop

.Pre_posi
	move.l	.sp_channel(sp),d0
	beq.s	.Pre_empty
	move.l	d0,a3
	move.l	ch_ptrack(a3),d0
	bne.s	.Pre_good
.Pre_empty
	move.l	d5,d3
	bra.s	.Pre_posa
.Pre_good
	move.l	d0,a3
	moveq	#0,d3

.Pre_loop
	move.w	(a3)+,d0
	ext.l	d0
	bmi.s	.Pre_nega
	cmp.l	d7,d3
	bne.s	.Pre_noput
	lsr.w	#8,d0
	moveq	#2,d1
	bsr	decout
	move.b	#'.',(a0)+
	moveq	#0,d0
	move.b	-1(a3),d0
	moveq	#2,d1
	bsr	decout
	add.l	d4,d7
.Pre_noput
	moveq	#-1,d0
.Pre_nega
	sub.l	d0,d3
.Pre_posa
	moveq	#'-',d0
	bra.s	.Pre_jin
.Pre_stayloop
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	#'.',(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	add.l	d4,d7
.Pre_jin
	cmp.l	d6,d7
	bgt.s	.Pre_out
	cmp.l	d5,d7
	bpl.s	.Pre_eop
	cmp.l	d3,d7
	bmi.s	.Pre_stayloop
	bra.s	.Pre_loop

.Pre_eop
	moveq	#' ',d0
.Pre_overloop
	cmp.l	d6,d7
	bgt.s	.Pre_out
	REPT	presettextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.Pre_overloop

.Pre_out







;=== Controlsource column

	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7
	bpl.s	.CS_posi

	moveq	#' ',d0
.CS_underloop
	REPT	cstextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.CS_underloop

.CS_posi
	move.l	.sp_channel(sp),d0
	beq.s	.CS_empty
	move.l	d0,a3

	move.w	chan_pgfx_active(a4),d0
	beq	.PB
	subq.w	#1,d0
	beq.s	.MP

	lea	codetab(a5),a1
	move.b	-1(a1,d0.w),d1
	lea	ch_csources(a3),a1
.CS_codeloop
	move.l	(a1),d0
	beq.s	.CS_empty
	move.l	d0,a1
	cmp.b	cs_parameter(a1),d1
	bne.s	.CS_codeloop
	lea	cs_data(a1),a3
	bra.s	.CS_good2

.MP	move.l	ch_mptrack(a3),d0
	bne.s	.CS_good
.CS_empty
	move.l	d5,d3
	bra.s	.CS_posa
.CS_good
	move.l	d0,a3
.CS_good2
	moveq	#0,d3

.CS_loop
	move.b	(a3)+,d0
	IFEQ	mc68020
	ext.w	d0
	ext.l	d0
	ELSE
	extb.l	d0
	ENDC
	bmi.s	.CS_nega
	cmp.l	d7,d3
	bne.s	.CS_noput
	move.b	#' ',(a0)+
	moveq	#1,d1
	bsr	hexout
	move.b	#' ',(a0)+
	add.l	d4,d7
.CS_noput
	moveq	#-1,d0
.CS_nega
	sub.l	d0,d3
.CS_posa
	moveq	#'-',d0
	bra.s	.CS_jin
.CS_stayloop
	move.b	#' ',(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	#' ',(a0)+
	add.l	d4,d7
.CS_jin
	cmp.l	d6,d7
	bgt.s	.PB_out
	cmp.l	d5,d7
	bpl.s	.PB_eop
	cmp.l	d3,d7
	bmi.s	.CS_stayloop
	bra.s	.CS_loop



.PB	move.l	ch_pbtrack(a3),d0
	bne.s	.PB_good
.PB_empty
	move.l	d5,d3
	bra.s	.PB_posa
.PB_good
	move.l	d0,a3
	moveq	#0,d3

.PB_loop
	move.w	(a3)+,d0
	ext.l	d0
	bmi.s	.PB_nega
	cmp.l	d7,d3
	bne.s	.PB_noput
	moveq	#3,d1
	bsr	hexout
	add.l	d4,d7
.PB_noput
	moveq	#-1,d0
.PB_nega
	sub.l	d0,d3
.PB_posa
	moveq	#'-',d0
	bra.s	.PB_jin
.PB_stayloop
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	add.l	d4,d7
.PB_jin
	cmp.l	d6,d7
	bgt.s	.PB_out
	cmp.l	d5,d7
	bpl.s	.PB_eop
	cmp.l	d3,d7
	bmi.s	.PB_stayloop
	bra.s	.PB_loop

.PB_eop
	moveq	#' ',d0
.PB_overloop
	cmp.l	d6,d7
	bgt.s	.PB_out
	REPT	cstextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.PB_overloop
.PB_out





;=== Normale Tracks

	move.l	.sp_pattscale(sp),d4
	move.l	.sp_events(sp),d5
	move.l	.sp_stop_event(sp),d6
	move.l	.sp_start_event(sp),d7

	movem.l	d6-d7,-(sp)

	clr.l	-(sp)
.trackloop

	move.l	4(sp),d6
	move.l	8(sp),d7
	bpl.s	.TRK_posi

	moveq	#' ',d0
.TRK_underloop
	REPT	tracktextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bmi.s	.TRK_underloop

.TRK_posi
	move.l	.sp_channel+12(sp),d0
	beq.s	.TRK_empty
	move.l	d0,a3

	move.l	chan_displaytrack(a4),d1
	add.l	(sp),d1
	lea	ch_tracks(a3),a1
.TRK_findloop
	move.l	(a1),d0
	beq.s	.TRK_empty
	move.l	d0,a1
	cmp.w	tr_number(a1),d1
	bcs.s	.TRK_findloop
	beq.s	.TRK_good
.TRK_empty
	move.l	d5,d3
	bra.s	.TRK_posa

.TRK_good
	lea	tr_data(a1),a3
	moveq	#0,d3

.TRK_loop
	move.w	(a3)+,d0
	ext.l	d0
	bmi.s	.TRK_nega
	addq.l	#2,a3
	cmp.l	d7,d3
	bne.s	.TRK_noput

	tst.b	chan_vel_or_pp(a4)
	bne.s	.usepp
	move.b	wd_Vel-wd_sizeof(a3),d0
	bmi.s	.Vel_stay
	bra.s	.putvel
.usepp	move.b	wd_pp-wd_sizeof(a3),d0
	bmi.s	.Vel_stay
.putvel	moveq	#1,d1
	bsr	hexout
	bra.s	.Vel_cont
.Vel_stay
	move.b	#'-',(a0)+
	move.b	#'-',(a0)+
.Vel_cont
	move.b	wd_Pitch-wd_sizeof(a3),d0
	beq.s	.Pitch_stay
	bmi.s	.note_off
	sub.b	#12,d0	; C-0 ist 12
	ext.w	d0
	move.w	d0,d1	; =mulu #3,d0
	add.w	d1,d1	;
	add.w	d1,d0	;
	lea	notetable(pc),a1
	adda.w	d0,a1
	move.b	(a1)+,(a0)+
	move.b	(a1)+,(a0)+
	move.b	(a1)+,(a0)+
	bra.s	.Pitch_cont
.note_off
	move.b	#'O',(a0)+
	move.b	#'F',(a0)+
	move.b	#'F',(a0)+
	bra.s	.Pitch_cont
.Pitch_stay
	moveq	#'-',d0
	move.b	d0,(a0)+
	move.b	d0,(a0)+
	move.b	d0,(a0)+
.Pitch_cont
	add.l	d4,d7

.TRK_noput
	moveq	#-1,d0
.TRK_nega
	sub.l	d0,d3
.TRK_posa
	moveq	#'-',d0
	bra.s	.TRK_jin
.TRK_stayloop
	REPT	tracktextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
.TRK_jin
	cmp.l	d6,d7
	bgt.s	.TRK_out
	cmp.l	d5,d7
	bpl.s	.TRK_eop
	cmp.l	d3,d7
	bmi.s	.TRK_stayloop
	bra	.TRK_loop

.TRK_eop
	moveq	#' ',d0
.TRK_overloop
	cmp.l	d6,d7
	bgt.s	.TRK_out
	REPT	tracktextd-1
	move.b	d0,(a0)+
	ENDR
	add.l	d4,d7
	bra.s	.TRK_overloop
.TRK_out

	addq.l	#1,(sp)
	move.l	(sp),d0
	cmp.l	chan_displayed_tracks(a4),d0
	bcs	.trackloop

	movem.l	(sp)+,d3/d6-d7


.back	move.l	.sp_postext(sp),a0
	lea	.sp_sizeof(sp),sp
	POSITIV

.neg	lea	.sp_sizeof(sp),sp
	NEGATIV


	ENDC





;==============================================================
;
;  Stern in Mainwindow-Title bei Bedarf ndern
;
;==============================================================

songchange
	bsr.s	check_songchange
	beq.s	.rts
	bra	set_wdtitle_main
.rts	rts


check_songchange	; zurck: d0=pos: Title-Refresh ntig
			;	  d0=neg: nicht ntig

;=== Zeichen fr Song-Changed setzen
	lea	MTmainWTitle(pc),a0
	tst.b	songchanged(a5)
	beq.s	.notc
	moveq	#'*',d0
	bra.s	.testit
.notc	moveq	#' ',d0

.testit	cmp.b	changedpos(a0),d0
	beq.s	.already
.change	move.b	d0,changedpos(a0)
	POSITIV
.already
	NEGATIV




;==============================================================
;
;  Den aktuellen Worktrack holen (normale Tracks)
;
;==============================================================

	IFEQ	1

GetCurrentWTrack	; returns: a0=^zugehriger Track

	move.l	currenttrack(a5),d0

GetWTrack		; d0.w=track
			; returns: a0=^zugehriger Track

	move.l	worktracks(a5),a0
	tst.w	d0
	beq.s	.zero
	move.l	d1,-(sp)
	move.l	events(a5),d1
	lsl.l	#2,d1		; =mulu #wd_sizeof,d1
	mulu	d0,d1		; d1=track*events*wd_sizeof
	adda.l	d1,a0
	move.l	(sp)+,d1
.zero	rts

	ENDC


;==============================================================
;
;  Den aktuellen Controlsource-Worktrack holen
;
;==============================================================

	IFEQ	1

GetCurrentCSTrack	; returns: a0=^current CS-Track

	move.w	pgfx_active(a5),d0
	subq.w	#2,d0


GetCSTrack		; d0.w=csource-track (nicht PB oder MP!)
			; returns: a0=^CS-Track, d0=csource (pgfx_active-2)

	move.l	cworktracks(a5),a0
	tst.w	d0
	beq.s	.zero
	move.l	d1,-(sp)
	move.l	events(a5),d1
	mulu	d0,d1
	adda.l	d1,a0
	move.l	(sp)+,d1
.zero	rts

	ENDC


;==============================================================
;
;  File Requester
;
;==============================================================

FileRequester	; a4=^fr_Struct
		; zurck: d0=Ok/Cancel

	move.l	d7,-(sp)

	move.w	fr_reqstruct(a4),d7
	tst.l	(a5,d7.w)
	bne.s	.allocated

;=== Requesterstruktur allocaten
	moveq	#0,d0			; RT_FILEREQ
	suba.l	a0,a0
	move.l	rtbas(a5),a6
	jsr	rtAllocRequestA(a6)
	move.l	d0,(a5,d7.w)
	beq	.neg

	move.l	d0,a1
;=== Pattern setzen
	move.w	fr_pattern(a4),d0
	beq.s	.nopat
	lea	fr_pattern(a4,d0.w),a2
	lea	.rt_change2_tags(pc),a0
	move.l	a2,$4(a0)
	jsr	rtChangeReqAttrA(a6)
.nopat

.allocated


;=== do we have an old path already?

	move.w	fr_path(a4),d0
	lea	(a5,d0.w),a2
	tst.b	(a2)
	bne.s	.wehave


;=== if there is no previous path, use startup-path

	move.l	startcdnameD(a5),a0
	move.l	a2,a1
	COPYTILLZERO

;	move.l	startcd(a5),d1
;	move.l	a2,d2
;	moveq	#108,d3
;	move.l	dosbas(a5),a6
;	jsr	NameFromLock(a6)
;	tst.l	d0
;	bne.s	.wehave
;	lea	.empty_path(pc),a2
.wehave

	lea	.rt_change1_tags(pc),a0
	move.l	a2,$4(a0)


;=== Change directory

	move.l	(a5,d7.w),a1
	move.l	rtbas(a5),a6
	jsr	rtChangeReqAttrA(a6)



;=== Filerequester

	lea	.rt_tags(pc),a0
	move.l	fr_flags(a4),$c(a0)	; Flags eintragen

;	lea	fr_title(a4),a1		; a3=^Windowtitle
;	adda.w	(a1),a1
	move.w	fr_title_locale(a4),d0	; localizen
	jsr	getcatstringJ(a5)	; sichert alle register
	move.l	a1,a3

	move.w	fr_window(a4),d0	; Windowpointer eintragen
	move.l	wd_Wnd(a5,d0.w),.rt_fr_window(a0)
	bne.s	.wcont
	move.l	iconifyWnd(a5),.rt_fr_window(a0)
	beq.s	.neg
.wcont
	move.l	a5,a2
	adda.w	fr_name(a4),a2		; a2=^Filename-buffer
	move.l	(a5,d7.w),a1
	jsr	rtFileRequestA(a6)
	tst.l	d0
	beq.s	.neg


;=== copy new directory to our puffer

	move.l	(a5,d7.w),a0
	move.l	16(a0),a0
	move.w	fr_path(a4),d0
	lea	(a5,d0.w),a1
	moveq	#107-1,d0
.copydir
	move.b	(a0)+,(a1)+
	dbeq	d0,.copydir
	clr.b	(a1)+


;=== change current dir to the new one
;	move.l	(a5,d7.w),a0
;	move.l	16(a0),a0		; ^Pathname
;	bsr	DoCD
;	beq.s	.neg

	move.l	(sp)+,d7
	POSITIV

.neg	move.l	(sp)+,d7
	NEGATIV


.rt_change1_tags
	dc.l	$80000000+50,0		; RTFI_Dir
	dc.l	0
.rt_change2_tags
	dc.l	$80000000+51,0		; RTFI_MatchPat
	dc.l	0
.empty_path
	dc.l	0
.rt_tags
.rt_fr_window = *+4-.rt_tags
	dc.l	$80000000+1,0		; RT_Window
	dc.l	$80000000+40,$10	; RTFI_Flags (PATGAD)
	dc.l	$80000000+11,'_'	; RT_Underscore
	dc.l	$80000000+13,1		; RT_LockWindow
	dc.l	0




;==============================================================
;
;  Font Requester
;
;==============================================================

FontRequester	; a0 = ^Window, d0 = Flags, d1 = MinHeight, d2 = MaxHeight
		; a1 = filterfunc-hook or NULL
		; returns: d0 = Ok/Cancel, a0 = ^TextAttr

	move.l	rtbas(a5),a6

	lea	.rt_tags(pc),a2
	move.l	a0,.rt_wnd(a2)
	move.l	d0,.rt_flags(a2)
	move.l	d1,.rt_minh(a2)
	move.l	d2,.rt_maxh(a2)

	move.l	.rt_filterfunc(a2),d2
	move.l	a1,.rt_filterfunc(a2)
	beq.s	.skiphook
	move.l	#$80000000+44,.rt_filterfunc-4(a2)
	bra.s	.hcont
.skiphook
	moveq	#1,d0
	move.l	d0,.rt_filterfunc-4(a2)
.hcont
	cmp.l	.rt_filterfunc(a2),d2
	beq.s	.nofree
	move.l	rt_fontreq(a5),d0
	beq.s	.nofree
	move.l	d0,a1
	jsr	rtFreeReqBuffer(a6)
.nofree


	tst.l	rt_fontreq(a5)
	bne.s	.allocated

;=== Requesterstruktur allocaten
	moveq	#2,d0			; RT_FONTREQ
	suba.l	a0,a0
	jsr	rtAllocRequestA(a6)
	move.l	d0,rt_fontreq(a5)
	beq.s	.neg
.allocated

	move.w	#loc_fonttitle,d0
	jsr	getcatstringJ(a5)
	move.l	a1,a3

	lea	.rt_tags(pc),a0
	move.l	rt_fontreq(a5),a1
	jsr	rtFontRequestA(a6)
	tst.l	d0
	beq.s	.neg

	move.l	rt_fontreq(a5),a0
	lea	$10(a0),a0
	POSITIV

.neg
	NEGATIV


.rt_tags
.rt_wnd = *+4-.rt_tags
	dc.l	$80000000+1,0		; RT_Window
	dc.l	$80000000+13,1		; RT_LockWindow
.rt_flags = *+4-.rt_tags
	dc.l	$80000000+40,$60	; RTFO_Flags
.rt_minh = *+4-.rt_tags
	dc.l	$80000000+61,8		; RTFO_MinHeight
.rt_maxh = *+4-.rt_tags
	dc.l	$80000000+62,12		; RTFO_MaxHeight
.rt_filterfunc = *+4-.rt_tags
	dc.l	$80000000+44,0		; RTFO_FilterFunc
	dc.l	0




;==============================================================
;
;  File Load
;
;==============================================================

;loadfile_chip
;	moveq	#2,d0
;	bra.s	loadfile

loadfile_public
	moveq	#1,d0


loadfile	; a2=^filename, a3=^struktur (adr,len)
		; d0=Alloc-Flags
		; zurueck: d0: success/fail

	move.l	d0,-(sp)

	bsr	unloadfile

	move.l	a2,d1
	move.l	#1005,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d7
	beq.s	.neg

	move.l	d7,d1
	move.l	fib(a5),d2
	jsr	ExamineFH(a6)
	tst.l	d0
	beq.s	.neg2

; allocate
	move.l	d2,a0
	move.l	$7c(a0),d0
	move.l	d0,4(a3)
	move.l	(sp),d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	move.l	d0,(a3)
	beq.s	.neg2

; read + close
	move.l	d7,d1
	move.l	d0,d2
	move.l	4(a3),d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	cmp.l	d3,d0
	bne.s	.neg3

	move.l	d7,d1
	jsr	Close(a6)

	addq.w	#4,sp
	POSITIV

.neg3	bsr.s	unloadfile

.neg2	move.l	d7,d1
	move.l	dosbas(a5),a6
	jsr	Close(a6)

.neg	clr.l	(a3)
	addq.w	#4,sp
	NEGATIV




;==============================================================
;
;  File Unload
;
;==============================================================

unloadfile	; a3=^struktur (adr,len)

	move.l	(a3),d0
	beq.s	.nofree
	clr.l	(a3)
	move.l	d0,a1
	move.l	4(a3),d0
	move.l	(a5),a6
	jsr	FreeMem(a6)
.nofree	rts



;==============================================================
;
;  Checkmark-Menpunkt abfragen
;
;==============================================================

;ScoreCheckmark	; d0=Menunumber
;	move.l	MTscoreMenus(a5),a0
;	bra.s	Checkmark

;SprocCheckmark	; d0=Menunumber
;	move.l	MTsprocStruct+wd_Menus(a5),a0
;	bra.s	Checkmark

MainCheckmark	; d0=Menunumber
; zurck: d0.b=0: Checkmark nicht gesetzt, d0.b=-1: Checkmark gesetzt
	move.l	MTmainStruct+wd_Menus(a5),a0
Checkmark
	move.l	intbas(a5),a6
	jsr	ItemAddress(a6)
	tst.l	d0
	beq.s	.err
	move.l	d0,a0
	btst	#0,$c(a0)
	sne	d0
.err	rts



;==============================================================
;
;  Checkmark in Men setzen
;
;==============================================================

SetMainCheckmark	; d0.w=menu-word, d1 = 0/1 set/reset

	movem.l	d0-d1,-(sp)

	move.l	intbas(a5),a6

;=== first detach menus

	move.l	windowtableD(a5),a3
	bra.s	.min
.menuloop

	lea	(a5,d0.w),a4
	move.l	wd_Wnd(a4),d2
	beq.s	.nextwindow

	move.l	wd_Menus(a4),d0
	moveq	#-1,d1
	cmp.l	d1,d0
	beq.s	.nextwindow
	cmp.l	mainmenus(a5),d0
	bne.s	.nextwindow

	move.l	wd_Wnd(a4),a0
	jsr	ClearMenuStrip(a6)

.nextwindow
	lea	windowtable_entry_sizeof(a3),a3
.min	move.w	(a3),d0
	bne.s	.menuloop




;=== set or reset the checkmark flag

	movem.l	(sp)+,d0/d2
	move.l	mainmenus(a5),a0
	jsr	ItemAddress(a6)
	tst.l	d0
	beq.s	.noitem
	move.l	d0,a0
	lsl.w	#8,d2
	and.w	#~$100,$c(a0)
	or.w	d2,$c(a0)
.noitem




;=== re-attach menus

	move.l	windowtableD(a5),a3
	bra.s	.ain
.attachloop

	lea	(a5,d0.w),a4
	move.l	wd_Wnd(a4),d2
	beq.s	.nextwin

	move.l	wd_Menus(a4),d0
	moveq	#-1,d1
	cmp.l	d1,d0
	beq.s	.nextwin

	move.l	wd_NewMenu0(a4),d0
	beq.s	.takewin
	cmp.l	MTmainNewMenu0D(a5),d0
	bne.s	.nextwin

.takewin
	move.l	wd_Wnd(a4),a0
	move.l	wd_Menus(a4),a1
	jsr	ResetMenuStrip(a6)

.nextwin
	lea	windowtable_entry_sizeof(a3),a3
.ain	move.w	(a3),d0
	bne.s	.attachloop

	rts









	IFEQ	1

	move.l	MTmainNewMenu0D(a5),a0

; find menu
	move.w	d0,d2
	and.w	#$1f,d0
	moveq	#1,d3
	bsr.s	.findmenu
	beq.s	.neg

; find menu-item
	move.w	d2,d0
	lsr.w	#5,d0
	and.w	#$3f,d0
	moveq	#2,d3
	bsr.s	.findmenu
	beq.s	.neg

; find menu-subitem
	move.w	d2,d0
	lsr.w	#5,d0
	lsr.w	#6,d0
	and.w	#$1f,d0
	moveq	#3,d3
	bsr.s	.findmenu
	beq.s	.neg



.findmenu	; a0 = ^newmenus, d0.w = number of item, d3.b = type
.menuloop
	move.b	(a0),d4
	beq.s	.notfound
	cmp.b	d4,d3
	bne.s	.nextentry
	subq.w	#1,d0
	bcc.s	.nextentry
	POSITIV
.nextentry
	lea	20(a0),a0
	bra.s	.menuloop
.notfound
	NEGATIV



ToggleCheckmark	; a1=^windowstruct
	move.l	a1,-(sp)
	move.w	d0,-(sp)

	move.l	wd_Wnd(a1),a0
	move.l	intbas(a5),a6
	jsr	ClearMenuStrip(a6)

	move.w	(sp)+,d0
	move.l	(sp),a0
	move.l	wd_Menus(a0),a0
	jsr	ItemAddress(a6)
	move.l	d0,a0
	eori.w	#$100,$c(a0)

	move.l	(sp)+,a1
	move.l	wd_Wnd(a1),a0
	move.l	wd_Menus(a1),a1
	jmp	ResetMenuStrip(a6)


	ENDC




;==============================================================
;
;  Merkt sich das letzte Statusbyte in einem MIDI-Stream
;
;==============================================================

;check_midistream
;=== a2=^neu gelesener MIDI Stream, d6=size
;=== letztes Statusbyte des erhaltenen Streams sichern
;	move.l	a2,a0
;	lea	(a0,d6.l),a1
;.readloop
;	cmpa.l	a1,a0
;	bcc.s	.rts
;	move.b	(a0)+,d0
;	bpl.s	.readloop
;	move.b	d0,lastbyte(a5)
;	bra.s	.readloop
;.rts	rts





;==============================================================
;
;  Playcounters initialisieren
;
;==============================================================



;=== Playcounter-Struktur initialisieren

init_playcounters

;	bsr.s	clear_playcounters

	move.l	note_tracking(a5),a0
	moveq	#15,d2
.chanloop

	move.l	maxtracks_m1(a5),d1
.trackloop
	st	(a0)+		; note off
	clr.b	(a0)+		; empty velocity
	dbf	d1,.trackloop

	dbf	d2,.chanloop
	rts




; do not merge these two routines together. clear_playcounters() is called
; from within replaycode, init_playcounters() is called from player.


	IFEQ	1

clear_playcounters
	moveq	#0,d1
	move.l	d1,bpmplaycounter(a5)
;	move.w	d1,bpmplaycounter+pcbpm_counter(a5)
;	move.w	d1,bpmplaycounter+pcbpm_offset(a5)

	move.l	playcounters(a5),a0
	moveq	#15,d3
.clearloop
	move.l	d1,(a0)+	; preset
	move.l	d1,(a0)+	; pitch
	move.l	d1,(a0)+	; mpress

;	move.w	d1,pcp_counter(a0)
;	move.w	d1,pcp_offset(a0)
;	addq.w	#pcp_sizeof,a0

;	move.w	d1,pcpb_counter(a0)
;	move.w	d1,pcpb_offset(a0)
;	addq.w	#pcpb_sizeof,a0

;	move.b	d1,pcmp_counter(a0)
;	move.w	d1,pcmp_offset(a0)
;	addq.w	#pcmp_sizeof,a0

	move.w	active_csources_m1+2(a5),d2
.csclearloop
	move.b	d1,pcc_counter(a0)
	move.w	d1,pcc_offset(a0)
	addq.w	#pcc_sizeof,a0
	dbf	d2,.csclearloop

	move.w	maxtracks_m1+2(a5),d2
.trclearloop
	move.w	d1,pc_counter(a0)
	move.w	d1,pc_offset(a0)
	addq.w	#pc_sizeof,a0
	dbf	d2,.trclearloop

	dbf	d3,.clearloop

	rts

	ENDC




;==============================================================
;
;  Mixer Routine
;
;==============================================================

volume_mixdown	; d6.w = channel (0-15)
		; returns: d2.b = volume byte

	movem.l	d0-d2/a1,-(sp)

	lea	channelvolumes(a5),a1
	moveq	#0,d1
	move.b	(a1,d6.w),d1		; get volume-parameter

	lea	channelsliders(a5),a1
	moveq	#0,d0
	move.b	(a1,d6.w),d0		; get channelscope-slider's value

	move.w	mastervolume(a5),d2

	mulu	d1,d0
	mulu	d0,d2
	divu	#127*127,d2

	lea	channellevels(a5),a1
	IFEQ	mc68020
	move.w	d6,d0
	lsl.w	#2,d0
	move.b	d2,3(a1,d0.w)
	ELSE
	move.b	d2,3(a1,d6.w*4)
	ENDC

	movem.l	(sp)+,d0-d2/a1
	rts




;==============================================================
;
;  String abzhlen (bis Nullbyte)
;
;==============================================================

stringlength	; a0=^string
		; zurck: d0.l=length of string (ohne Nullbyte)

	move.l	a0,d0
.loop	tst.b	(a0)+
	bne.s	.loop
	sub.l	a0,d0
	neg.l	d0
	subq.l	#1,d0
	rts



;==============================================================
;
;  Datei kopieren
;
;==============================================================

copy_file	; a0=^sourcefilename, a1=^destfilename
		; zurck: d0=success

	movem.l	d6-d7/a0-a1,-(sp)

;=== Inputfile ffnen
	move.l	a0,d1
	move.l	#1005,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d6
	beq	.err1

;=== Outputfile ffnen
	move.l	12(sp),d1
	move.l	#1006,d2
	jsr	Open(a6)
	move.l	d0,d7
	beq.s	.err2

;=== Filesize holen
	move.l	d6,d1
	move.l	fib(a5),d2
	jsr	ExamineFH(a6)
	tst.l	d0
	beq.s	.err3

;=== Speicher fr Input allocaten
	move.l	d2,a0
	move.l	$7c(a0),d0
	move.l	d0,d3
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	move.l	d0,d2
	beq.s	.err3

;=== Input lesen
	move.l	d6,d1
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	cmp.l	d3,d0
	bne.s	.err5

;=== Output schreiben
	move.l	d7,d1
	jsr	Write(a6)
	cmp.l	d3,d0
	bne.s	.err5

;=== Files schliessen
	move.l	d7,d1
	jsr	Close(a6)
	move.l	d6,d1
	jsr	Close(a6)

	bsr.s	.freemem

	movem.l	(sp)+,d6-d7/a0-a1
	POSITIV

.freemem
	move.l	d2,a1
	move.l	d3,d0
	move.l	(a5),a6
	jmp	FreeMem(a6)

.err5	bsr.s	.freemem

.err3	move.l	d7,d1
	move.l	dosbas(a5),a6
	jsr	Close(a6)
	move.l	12(sp),d1
	jsr	DeleteFile(a6)

.err2	move.l	d6,d1
	jsr	Close(a6)

.err1	movem.l	(sp)+,d6-d7/a0-a1
	NEGATIV







	IFNE	keyfile_active

decode_add_bitchange
	lea	200(a5),a1
	move.l	keybas-200(a1),d0
	beq.s	.nokey

	move.l	keycode_start(a5),a0
	lea	keycode_length(a0),a0
	move.l	add_bitchange_checksum(a0),d2
	moveq	#0,d0
.calcloop
	rol.l	d0,d2
	bchg	d0,d2
	sub.l	-(a0),d2
	addq.w	#1,d0
	cmp.w	#keycode_length/4,d0
	bcs.s	.calcloop
	jmp	long_checksum_testJ(a5)
.nokey	rts

	ENDC


