;APS00003182000000000000000000000000000000000000000000000000000000000000000000000000
;==============================================================
;
;                   E D I T     M E N U
;
;==============================================================


;==============================================================
;
;  Track CUT
;
;==============================================================

edit_cuttrack
	tst.b	playflag(a5)
	bne.s	.rts

	tst.b	editmode(a5)
	beq	edit_noeditmode

	tst.b	cuttobuf(a5)
	beq.s	.cut
	bsr	copytrack
	beq	track_nomem
.cut

;	jsr	check_state_beforeJ(a5)

	move.l	currenttrack(a5),d0
	bpl.s	.normal
	addq.l	#1,d0
	beq.s	.controlsource
	addq.l	#1,d0
	beq.s	.presettrack


;=== BPM Track
;	st	bpmtrackchanged(a5)
;	jsr	erasebpmtrackJ(a5)
	move.l	currentpatternA(a5),a0
	jsr	FreeBPMTrackJ(a5)
	bra.s	.out

.rts	rts


;=== normaler worktrack
.normal
;	move.l	trackchanged(a5),a0
;	st	(a0,d0.w)
;	jsr	erasetrackJ(a5)

	bsr	FreeTrack


.out	st	songchanged(a5)
	bsr	refresh_the_track


.status
	move.w	#loc_t_cut,d0
	jmp	status_displayJ(a5)


.presettrack
;	st	ptrackchanged(a5)
;	jsr	eraseptrackJ(a5)

	jsr	GetChannelJ(a5)
	beq.s	.out
	bsr	FreePTrack
	bra.s	.out


.controlsource
	bsr.s	clear_controlsource
	bra.s	.status





clear_controlsource
	move.w	pgfx_active(a5),d0
	beq.s	.PB
	subq.w	#1,d0
;	beq.s	.MP

;	subq.w	#1,d0
;	ext.l	d0
;	move.l	ctrackchanged(a5),a0
;	st	(a0,d0.l)
;	jsr	erasectrackJ(a5)

	bsr	FreeCSourceTrack

.csout
	st	songchanged(a5)
	bra	refresh_the_track

.PB
;	jsr	erasepbtrackJ(a5)
;	st	pbtrackchanged(a5)

	jsr	GetChannelJ(a5)
	beq.s	.csout
	bsr	FreePBTrack
	bra.s	.csout

;.MP	jsr	erasemptrackJ(a5)
;	st	mptrackchanged(a5)
;	bra.s	.csout






FreeTrack	; d0 = tracknumber

	movem.l	d0/a2,-(sp)

	jsr	GetTrackJ(a5)
	beq.s	.neg

;	jsr	GetChannelJ(a5)
;	beq.s	.neg

;	move.l	(sp),d0
;	lea	ch_tracks(a0),a0
;	bra.s	.jin
;.findloop
;	move.l	d1,a0
;	cmp.w	tr_number(a0),d0
;	beq.s	.found
;	bcs.s	.neg
;.jin	move.l	(a0),d1
;	bne.s	.findloop
;	bra.s	.neg

;.found
	move.l	(a0),a2
	move.l	4(a0),a1
	move.l	a2,(a1)
	move.l	a2,d0
	beq.s	.nonext
	move.l	a1,4(a2)
.nonext
	move.l	a0,a1
	jsr	MyFreeVecJ(a5)

.neg	movem.l	(sp)+,d0/a2
	rts





FreeCSourceTrack	; d0 = cs order number

	movem.l	d0/a2,-(sp)

	jsr	GetCSourceTrackJ(a5)
	beq.s	.neg

;	lea	codetab(a5),a0
;	move.b	(a0,d0.w),d0


;	jsr	GetChannelJ(a5)
;	beq.s	.neg

;	move.l	(sp),d0
;	lea	ch_cstracks(a0),a0
;	bra.s	.jin
;.findloop
;	move.l	d1,a0
;	cmp.b	cs_parameter(a0),d0
;	beq.s	.found
;	bcs.s	.neg
;.jin	move.l	a0,a2		; previous track
;	move.l	(a0),d1
;	bne.s	.findloop
;	bra.s	.neg

;.found
	move.l	(a0),a2
	move.l	4(a0),a1
	move.l	a2,(a1)
	move.l	a2,d0
	beq.s	.nonext
	move.l	a1,4(a2)
.nonext
	move.l	a0,a1
	jsr	MyFreeVecJ(a5)

.neg	movem.l	(sp)+,d0/a2
	rts






edit_noeditmode
	move.w	#loc_editmode,d0
	move.w	#loc_ok,d1
	jmp	EZrequestJ(a5)





;==============================================================
;
;  Track COPY
;
;==============================================================

edit_copytrack
	tst.b	editmode(a5)
	beq	edit_noeditmode

	bsr.s	copytrack
	beq.s	.err
	move.w	#loc_t_copied,d0
	jmp	status_displayJ(a5)
.err	rts

copytrack
	move.l	currenttrack(a5),d0
	bpl	.normal
	addq.l	#1,d0
	beq.s	.cstrack
	addq.l	#1,d0
	beq.s	.ptrack

;=== BPM-Track
	move.l	events(a5),d0
	move.l	d0,BPMbuf_events(a5)
	add.l	d0,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq	track_nomem

	move.l	d0,a2
	bsr	FreeBPMbuffer
	move.l	a2,BPMbuf_addr(a5)

	jsr	GetBPMTrackJ(a5)
	beq.s	.def_bpm
.copybytes2
	move.l	events(a5),d0
	add.l	d0,d0
	bra.s	.begincopy

.def_bpm
	move.w	#BPM_stay,d1
.def_2	move.l	events(a5),d0
.bpm_initloop
	move.w	d1,(a2)+
	subq.l	#1,d0
	bne.s	.bpm_initloop
	bra.s	.pos


;=== Preset Track
.ptrack
	move.l	events(a5),d0
	move.l	d0,PRbuf_events(a5)
	add.l	d0,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq	track_nomem

	move.l	d0,a2
	bsr	FreePRbuffer
	move.l	a2,PRbuf_addr(a5)

	jsr	GetPresetTrackJ(a5)
	beq.s	.def_pre
	bra.s	.copybytes2
.def_pre
	move.w	#Preset_stay,d1
	bra.s	.def_2



;=== Controlsource Track

.cstrack
	move.w	pgfx_active(a5),d2
	beq.s	.PB
	subq.w	#1,d2
;	beq.s	.MP

;== Controlsource
	move.l	events(a5),d0
	move.l	d0,CSbuf_events(a5)
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq	track_nomem

	move.l	d0,a2
	bsr	FreeCSbuffer
	move.l	a2,CSbuf_addr(a5)

	move.b	d2,d0
	jsr	GetCSourceTrackJ(a5)
	beq.s	.def_cs
	move.b	cs_onoff(a0),CSbuf_onoff(a5)
	lea	tr_data(a0),a0

.copybytes1
	move.l	events(a5),d0
.begincopy
	move.l	a2,a1
	move.l	(a5),a6
	jsr	CopyMem(a6)
.pos	POSITIV

.def_cs
	move.b	#CS_stay,d1
	move.l	events(a5),d0
.cs_initloop
	move.b	d1,(a2)+
	subq.l	#1,d0
	bne.s	.cs_initloop
	bra.s	.pos



;== Pitchbend Track
.PB	move.l	events(a5),d0
	move.l	d0,PBbuf_events(a5)
	add.l	d0,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq	track_nomem

	move.l	d0,a2
	bsr	FreePBbuffer
	move.l	a2,PBbuf_addr(a5)

	jsr	GetChannelJ(a5)
	beq.s	.def_pibe
	move.b	ch_pb_onoff(a0),PBbuf_onoff(a5)

	jsr	GetPibeTrackJ(a5)
	beq.s	.def_pibe

	bra	.copybytes2

.def_pibe
	st	PBbuf_onoff(a5)
	move.w	#PB_stay,d1
	bra	.def_2




;== MPress
;.MP	move.l	events(a5),d0
;	move.l	d0,CSbuf_events(a5)
;	moveq	#1,d1
;	jsr	MyAllocVecJ(a5)
;	tst.l	d0
;	beq.s	track_nomem

;	move.l	d0,-(sp)
;	bsr	FreeCSbuffer
;	move.l	(sp)+,a1
;	move.l	a1,CSbuf_addr(a5)
;	move.b	currentmp_onoff(a5),CSbuf_onoff(a5)

;	move.l	mpworktrack(a5),a0
;	bra.s	.copybytes1



;=== Trackbuffer allocaten

.normal
	move.l	events(a5),d0
	move.l	d0,trackbuf_events(a5)
	lsl.l	#2,d0	;=mulu #wd_sizeof,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq.s	track_nomem

	move.l	d0,a2
	bsr	FreeTrackbuffer
	move.l	a2,trackbuf_addr(a5)

	move.l	currenttrack(a5),d0
	jsr	GetTrackJ(a5)
	beq.s	.def_track

	move.b	tr_onoff(a0),trackbuf_onoff(a5)
	lea	tr_data(a0),a0

	move.l	events(a5),d0
	lsl.l	#2,d0
	bra	.begincopy

.def_track
	st	trackbuf_onoff(a5)
	move.l	#track_def_entry,d1
	move.l	events(a5),d0
.trk_initloop
	move.l	d1,(a2)+
	subq.l	#1,d0
	bne.s	.trk_initloop
	bra	.pos




;track_nomem_unpause
;	bsr	unpause_player
track_nomem
	jsr	nomemoryJ(a5)
	NEGATIV







;==============================================================
;
;  Track PASTE
;
;==============================================================

edit_pastetrack
	tst.b	playflag(a5)
	bne.s	.rts

	tst.b	editmode(a5)
	beq	edit_noeditmode

;	jsr	check_state_beforeJ(a5)

	move.l	currenttrack(a5),d0
	bpl	.normal
	addq.l	#1,d0
	beq.s	.cstrack
	addq.l	#1,d0
	beq.s	.ptrack

;=== BPM Track
	move.l	BPMbuf_addr(a5),d2
	beq	nothingtopaste

	move.l	BPMbuf_events(a5),d3
	cmp.l	events(a5),d3
	bne	track_events_dont_match

;	st	bpmtrackchanged(a5)
	jsr	GetOrAllocBPMTrackJ(a5)
	beq.s	.out
	bra.s	.copy2

.rts	rts


;=== Preset Track
.ptrack
	move.l	PRbuf_addr(a5),d2
	beq	nothingtopaste

	move.l	PRbuf_events(a5),d3
	cmp.l	events(a5),d3
	bne	track_events_dont_match

;	st	ptrackchanged(a5)
	jsr	GetOrAllocPresetTrackJ(a5)
	beq.s	.out
.copy2	add.l	d3,d3
	bra.s	.copy


;=== Controlsource Track
.cstrack
	move.w	pgfx_active(a5),d0
	beq.s	.PB
	subq.w	#1,d0
;	beq.s	.MP
;	subq.w	#1,d0

;=== normale Csource
	move.l	CSbuf_addr(a5),d2
	beq	nothingtopaste

	move.l	CSbuf_events(a5),d3
	cmp.l	events(a5),d3
	bne	track_events_dont_match

;	move.l	ctrackchanged(a5),a0
;	st	(a0,d0.w)

	jsr	GetOrAllocCSourceTrackJ(a5)
	beq.s	.out
	move.b	CSbuf_onoff(a5),cs_onoff(a0)
	lea	cs_data(a0),a0


.copy	move.l	a0,a1
	move.l	d2,a0
	move.l	d3,d0
	move.l	(a5),a6
	jsr	CopyMem(a6)

.out
	st	songchanged(a5)
	bsr	refresh_the_track

	move.w	#loc_t_pasted,d0
	jmp	status_displayJ(a5)


.PB
;=== Pitchbend
	move.l	PBbuf_addr(a5),d2
	beq	nothingtopaste

	move.l	PBbuf_events(a5),d3
	cmp.l	events(a5),d3
	bne.s	track_events_dont_match

	jsr	GetOrAllocChannelJ(a5)
	beq.s	.out
	move.b	PBbuf_onoff(a5),ch_pb_onoff(a0)

;	st	pbtrackchanged(a5)
	jsr	GetOrAllocPibeTrackJ(a5)
	beq.s	.out
	bra.s	.copy2


;.MP
;=== MPress
;	move.l	CSbuf_addr(a5),d1
;	beq	nothingtopaste

;	move.l	CSbuf_events(a5),d0
;	cmp.l	events(a5),d0
;	bne.s	track_events_dont_match

;	st	mptrackchanged(a5)
;	move.b	CSbuf_onoff(a5),currentmp_onoff(a5)
;	move.l	d1,a0
;	move.l	mpworktrack(a5),a1
;	bra.s	.copy



;=== normaler Track
.normal
	move.l	trackbuf_addr(a5),d2
	beq	nothingtopaste

	move.l	trackbuf_events(a5),d3
	cmp.l	events(a5),d3
	bne.s	track_events_dont_match

	move.l	currenttrack(a5),d0
;	move.l	trackchanged(a5),a0
;	st	(a0,d0.l)
	jsr	GetOrAllocTrackJ(a5)
	beq.s	.out
	move.b	trackbuf_onoff(a5),tr_onoff(a0)
	lea	tr_data(a0),a0

	lsl.l	#2,d3
	bra.s	.copy




track_events_dont_match
	move.w	#loc_cantpastetrk,d0
	move.w	#loc_well,d1
	jmp	EZrequestJ(a5)




;==============================================================
;
;  Track JOIN
;
;==============================================================

edit_jointrack
	tst.b	playflag(a5)
	bne.s	.rts

	tst.b	editmode(a5)
	beq	edit_noeditmode

;	jsr	check_state_beforeJ(a5)

	move.l	currenttrack(a5),d0
	bpl	.normal
	addq.l	#1,d0
	beq	.csource
	addq.l	#1,d0
	beq.s	.preset

;=== BPM
	move.l	BPMbuf_addr(a5),d2
	beq	nothingtopaste

	move.l	BPMbuf_events(a5),d3
	cmp.l	events(a5),d3
	bne	track_events_dont_match

;	st	bpmtrackchanged(a5)
	jsr	GetOrAllocBPMTrackJ(a5)
	beq.s	.fail
	moveq	#BPM_stay,d4

.two	move.l	d2,a1
	move.l	eventpos(a5),-(sp)
	clr.l	eventpos(a5)
	bsr	join_2b
	move.l	(sp)+,eventpos(a5)
	bra	.out

.fail
.rts	rts

.preset	move.l	PRbuf_addr(a5),d2
	beq	nothingtopaste

	move.l	PRbuf_events(a5),d3
	cmp.l	events(a5),d3
	bne	track_events_dont_match

;	st	ptrackchanged(a5)
	jsr	GetOrAllocPresetTrackJ(a5)
	beq.s	.fail
	moveq	#Preset_stay,d4
	bra.s	.two


.PB	move.l	PBbuf_addr(a5),d2
	beq	nothingtopaste

	move.l	PBbuf_events(a5),d3
	cmp.l	events(a5),d3
	bne	track_events_dont_match

;	st	pbtrackchanged(a5)
	jsr	GetOrAllocPibeTrackJ(a5)
	beq.s	.fail
	move.l	PBbuf_events(a5),d3
	move.w	#PB_stay,d4
	bra.s	.two



;.MP	move.l	CSbuf_addr(a5),d0
;	beq	nothingtopaste
;	move.l	d0,a1

;	move.l	CSbuf_events(a5),d3
;	cmp.l	events(a5),d3
;	bne	track_events_dont_match

;	st	mptrackchanged(a5)
;	move.l	mpworktrack(a5),a0
;	bra.s	.one



.csource
	move.w	pgfx_active(a5),d0
	beq.s	.PB
	subq.w	#1,d0
;	beq.s	.MP

	move.l	CSbuf_addr(a5),d2
	beq	nothingtopaste

	move.l	CSbuf_events(a5),d3
	cmp.l	events(a5),d3
	bne	track_events_dont_match

;	move.l	ctrackchanged(a5),a0
;	subq.w	#1,d0
;	st	(a0,d0.w)
	jsr	GetOrAllocCSourceTrackDataJ(a5)
	beq.s	.fail
	move.b	#cs_stay,d4

	move.l	d2,a1
	move.l	eventpos(a5),-(sp)
	clr.l	eventpos(a5)
	bsr	join_1b
	move.l	(sp)+,eventpos(a5)


.out
	st	songchanged(a5)
	bsr	refresh_the_track

	move.w	#loc_t_joined,d0
	jmp	status_displayJ(a5)



.normal	move.l	trackbuf_addr(a5),d2
	beq	nothingtopaste

	move.l	trackbuf_events(a5),d3
	cmp.l	events(a5),d3
	bne	track_events_dont_match

;	move.l	trackchanged(a5),a0
;	st	(a0,d0.w)
	jsr	GetOrAllocTrackDataJ(a5)
	beq	.fail
	move.l	#track_def_entry,d4

	move.l	d2,a1
	move.l	eventpos(a5),-(sp)
	clr.l	eventpos(a5)		; join_4b will need this
	bsr	join_4b
	move.l	(sp)+,eventpos(a5)
	bra.s	.out








current_channel_update

	bsr	checkfree_track_and_channel

	bsr	refreshpatt

	jsr	RedrawPatternJ(a5)
	jsr	RefreshPgfxScrJ(a5)
	jsr	RefreshNumsJ(a5)
	jsr	RefreshPresettrackJ(a5)
	jsr	RefreshBPMtrackJ(a5)
	jsr	RefreshCSModeJ(a5)
	jsr	RefreshVelOrPPJ(a5)

	bsr	RefreshBlock

	jsr	RefreshCurrentChannelEnableJ(a5)
	jsr	RefreshCurrentGlobalChannelStateJ(a5)
	jmp	score_refreshJ(a5)



refresh_the_track

	bsr	checkfree_track_and_channel

	move.l	currenttrack(a5),d0
	bpl.s	.normal
	addq.l	#1,d0
	beq.s	.cs
	addq.l	#1,d0
	beq.s	.preset

	jsr	RefreshBPMtrackJ(a5)
	jmp	RedrawPatternJ(a5)

.preset	jsr	RefreshPresettrackJ(a5)
	bra.s	.out

.normal	jsr	RefreshCurrenttrackJ(a5)
	bra.s	.out

.cs
	jsr	RefreshCSModeJ(a5)
	jsr	Refresh_pgfx_areaJ(a5)

.out
	jsr	RedrawPatternJ(a5)
	bsr	RefreshBlock

	jsr	RefreshCurrentChannelEnableJ(a5)
	jsr	RefreshCurrentGlobalChannelStateJ(a5)
	jsr	score_refreshJ(a5)

	bra	refreshpatt



	IFEQ	1


.get_cs_state
	move.w	pgfx_active(a5),d0
	beq.s	.pb
;	subq.w	#1,d0
;	beq.s	.mp
	lea	cs_states(a5),a0
	move.b	-1(a0,d0.w),d0
	rts
.pb	move.b	currentpb_state(a5),d0
	rts
;.mp	move.b	currentmp_state(a5),d0
;	rts




.state_of_current_channel
				; returns: pos = channel is filled,
				;          neg = channel is empty

	tst.b	preset_state(a5)
	bne.s	.filled

	tst.b	currentpb_state(a5)
	bne.s	.filled

;	tst.b	currentmp_state(a5)
;	bne.s	.filled

	tst.b	preset_state(a5)
	bne.s	.filled

	move.l	current_states(a5),a0
	move.l	maxtracks_m1(a5),d0
.trackloop
	tst.b	(a0)+
	dbne	d0,.trackloop
	bne.s	.filled

	lea	cs_states(a5),a0
	move.l	active_csources_m1(a5),d0
.csloop
	tst.b	(a0)+
	dbne	d0,.csloop
	bne.s	.filled


	NEGATIV
.filled	POSITIV


	ENDC






checkfree_track_and_channel

	jsr	GetChannelJ(a5)
	beq	.done
	move.l	a0,a2


	tst.b	editmode(a5)
	beq	.noeditmode

	move.l	currenttrack(a5),d0
	bpl.s	.note_track
	addq.l	#1,d0
	beq.s	.cstrack
	addq.l	#1,d0
	beq.s	.ptrack

; bpm track
	jsr	GetBPMTrackJ(a5)
	beq	.bpm_nofree
	moveq	#BPM_stay,d1
	bsr	.state_of_2b
	bne	.bpm_nofree
	move.l	currentpatternA(a5),a0
	bsr	FreeBPMTrack
.bpm_nofree
	bra.s	.check_channel

.ptrack
	jsr	GetPresetTrackJ(a5)
	beq.s	.pre_nofree
	moveq	#Preset_stay,d1
	bsr.s	.state_of_2b
	bne.s	.pre_nofree
	move.l	a2,a0
	bsr	FreePTrack
.pre_nofree
	bra.s	.check_channel

.cstrack
	move.w	pgfx_active(a5),d0
	beq.s	.pb
	subq.w	#1,d0
	move.w	d0,d2
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.cs_nofree
	bsr.s	.state_of_1b
	bne.s	.cs_nofree
	move.w	d2,d0
	jsr	GetCSourceTrackJ(a5)
	bsr	FreeCSourceTrack
.cs_nofree
	bra.s	.check_channel

.pb	jsr	GetPibeTrackJ(a5)
	beq.s	.pb_nofree
	move.w	#PB_stay,d1
	bsr.s	.state_of_2b
	bne.s	.pb_nofree
	move.l	a2,a0
	bsr	FreePBTrack
.pb_nofree
	bra.s	.check_channel

.note_track
	move.l	d0,d2
	jsr	GetTrackDataJ(a5)
	beq.s	.note_nofree

	move.l	events(a5),d0
	subq.l	#1,d0
	move.l	#track_def_entry,d1
.checkloop
	cmp.l	(a0)+,d1
	dbne	d0,.checkloop
	bne.s	.note_nofree

	move.l	d2,d0
	bsr	FreeTrack
.note_nofree
;	bra.s	.check_channel


.noeditmode

.check_channel
	move.l	a2,a1
	bsr.s	.channel_is_filled
	bne.s	.nofreechan
	jsr	GetCurrentChannelAddrJ(a5)
	bsr	FreeChannel
.nofreechan

.done
	rts



.state_of_2b	; returns: pos = track is filled, neg = track is empty
	move.l	events(a5),d0
	subq.l	#1,d0
.checkloop2
	cmp.w	(a0)+,d1
	dbne	d0,.checkloop2
	rts


.state_of_1b	; returns: pos = track is filled, neg = track is empty
	move.l	events(a5),d0
	subq.l	#1,d0
	move.b	#cs_stay,d1
.checkloop1
	cmp.b	(a0)+,d1
	dbne	d0,.checkloop1
	rts






.channel_is_filled	; a1 = ^channel
			; returns: neg = channel is empty, pos = filled

	tst.l	ch_cstracks(a1)
	bne.s	.filled
	tst.l	ch_pbtrack(a1)
	bne.s	.filled
	tst.l	ch_ptrack(a1)
	bne.s	.filled
;	tst.l	ch_mptrack(a1)
;	bne.s	.filled
	tst.l	ch_tracks(a1)
	bne.s	.filled

	move.l	defreso(a5),d0
	cmp.w	ch_scale(a1),d0
	bne.s	.filled

	NEGATIV
.filled	POSITIV






;==============================================================
;
;  Channel CUT
;
;==============================================================

edit_cutchannel
	tst.b	playflag(a5)
	bne.s	.rts

	bsr.s	cutchannel_routine
	bsr	current_channel_update

	move.w	#loc_c_cut,d0
	jmp	status_displayJ(a5)

.rts	rts




cutchannel_routine	; cut current channel silently
	tst.b	cuttobuf(a5)
	beq.s	.cut
	bsr	FreeChannelbuffer
;	jsr	packchannelJ(a5)

	jsr	GetChannelJ(a5)
	move.l	a0,chanbuf_addr(a5)
	move.l	events(a5),chanbuf_events(a5)
;	clr.l	currentchannelA(a5)

	jsr	GetCurrentChannelAddrJ(a5)
	clr.l	(a0)

	bra.s	.free

.cut
	jsr	GetCurrentChannelAddrJ(a5)
	bsr	FreeChannel

.free

; enable channel
;	move.l	currentpatternA(a5),a0
;	move.w	currentchannel(a5),d0
;	move.w	pt_chanmask(a0),d1
;	subq.w	#1,d0
;	bset	d0,d1
;	move.w	d1,pt_chanmask(a0)

; clear channel from pattern
;	jsr	GetCurrentChannelAddrJ(a5)
;	clr.l	(a0)

	st	songchanged(a5)
	rts




;pack_while_play
;	tst.b	playflag(a5)
;	beq.s	.stoped

;	bsr.s	pause_player
;	jsr	packchannelJ(a5)
;	jsr	depackchannelJ(a5)
;	bra.s	unpause_player

;.stoped	jsr	packchannelJ(a5)
;	jmp	depackchannelJ(a5)





;pause_player
;	tst.b	playflag(a5)
;	beq.s	.stoped

;	bsr.s	unpause_player

;	moveq	#0,d0
;	move.b	pausesig_main(a5),d1
;	bset	d1,d0
;	jmp	Wait(a6)

;	st	replay_paused(a5)

;.stoped	rts






;unpause_player
;	tst.b	playflag(a5)
;	beq.s	.stoped

;	move.l	playerprocess(a5),a1
;	moveq	#0,d0
;	move.b	pausesig_player(a5),d1
;	bset	d1,d0
;	move.l	(a5),a6
;	jmp	Signal(a6)

;	sf	replay_paused(a5)

;.stoped	rts




;==============================================================
;
;  Channel COPY
;
;==============================================================

edit_copychannel
;	tst.b	playflag(a5)
;	bne.s	.playing
;	jsr	packchannelJ(a5)
;	jsr	depackchannelJ(a5)
;.playing

	jsr	GetCurrentChannelAddrJ(a5)
	lea	chanbuf_addr(a5),a1
	bsr.s	copychannel
	beq.s	.fail

	move.l	events(a5),chanbuf_events(a5)

	move.w	#loc_c_copied,d0
	jmp	status_displayJ(a5)

.fail	clr.l	chanbuf_events(a5)	; nothing to paste
	bra	track_nomem




copychannel	; a0=^sourcechanneladr, a1=^destchanneladr

	movem.l	a0-a1,-(sp)

	tst.l	(a0)
	beq	.copy_empty
	move.l	a1,a0
	bsr	FreeChannel
	jsr	AllocChannelJ(a5)
	beq	.error
	move.l	4(sp),a1
	move.l	a0,(a1)
	move.l	a0,a3
	move.l	(sp),a0
	move.l	(a0),a2


;=== ptrack kopieren
	move.l	ch_ptrack(a2),d0
	beq.s	.nptrk
	move.l	d0,a0
	move.l	-(a0),d0
	subq.l	#4,d0
	move.l	d0,d2
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,ch_ptrack(a3)
	beq	.error
	move.l	d0,a1
	move.l	ch_ptrack(a2),a0
	move.l	d2,d0
	move.l	(a5),a6
	jsr	CopyMem(a6)
.nptrk

;=== pbtrack kopieren
	move.l	ch_pbtrack(a2),d0
	beq.s	.npbtrk
	move.l	d0,a0
	move.l	-(a0),d0
	subq.l	#4,d0
	move.l	d0,d2
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,ch_pbtrack(a3)
	beq	.error
	move.l	d0,a1
	move.l	ch_pbtrack(a2),a0
	move.l	d2,d0
	move.l	(a5),a6
	jsr	CopyMem(a6)
.npbtrk

;=== mptrack kopieren
;	move.l	ch_mptrack(a2),d0
;	beq.s	.nmptrk
;	move.l	d0,a0
;	move.l	-(a0),d0
;	subq.l	#4,d0
;	move.l	d0,d2
;	moveq	#1,d1
;	jsr	MyAllocVecJ(a5)
;	move.l	d0,ch_mptrack(a3)
;	beq	.error
;	move.l	d0,a1
;	move.l	ch_mptrack(a2),a0
;	move.l	d2,d0
;	jsr	CopyMem(a6)
;.nmptrk

	move.b	ch_pb_onoff(a2),ch_pb_onoff(a3)
	move.b	ch_onoff(a2),ch_onoff(a3)
;	move.b	ch_mp_onoff(a2),ch_mp_onoff(a3)
;	move.w	ch_numcs(a2),ch_numcs(a3)
;	move.w	ch_numtracks(a2),ch_numtracks(a3)
	move.w	ch_scale(a2),ch_scale(a3)


;=== csource tracks kopieren
	movem.l	a2-a3,-(sp)

	lea	ch_cstracks(a2),a2
	lea	ch_cstracks(a3),a3
.csloop
	move.l	(a2),d0
	beq.s	.outc
	move.l	d0,a2

	move.l	-4(a2),d0
	subq.l	#4,d0
	move.l	d0,d2
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,(a3)
	beq	.error2

	move.l	d0,a1
	move.l	a2,a0
	move.l	d2,d0
	move.l	(a5),a6
	jsr	CopyMem(a6)
	move.l	(a3),a0
	move.l	a3,4(a0)
	move.l	a0,a3
	bra.s	.csloop
.outc	clr.l	(a3)

	movem.l	(sp)+,a2-a3




;=== normale tracks kopieren
	lea	ch_tracks(a2),a2
	lea	ch_tracks(a3),a3
.chanloop
	move.l	(a2),d0
	beq.s	.out
	move.l	d0,a2

	move.l	-4(a2),d0
	subq.l	#4,d0
	move.l	d0,d2
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,(a3)
	beq.s	.error

	move.l	d0,a1
	move.l	a2,a0
	move.l	d2,d0
	move.l	(a5),a6
	jsr	CopyMem(a6)
	move.l	(a3),a0
	move.l	a3,4(a0)
	move.l	a0,a3
	bra.s	.chanloop
.out	clr.l	(a3)


.fixstack
	movem.l	(sp)+,a0-a1
	POSITIV

.copy_empty
	clr.l	(a1)
	bra.s	.fixstack

.error2	movem.l	(sp)+,a2-a3

.error	move.l	4(sp),a0
	bsr	FreeChannel
	movem.l	(sp)+,a0-a1
	NEGATIV





;==============================================================
;
;  Channel PASTE
;
;==============================================================

edit_pastechannel
	tst.b	playflag(a5)
	bne.s	.rts

	move.l	chanbuf_events(a5),d0
	beq	nothingtopaste
	cmp.l	events(a5),d0
	bne.s	.events_dont_match

	jsr	GetCurrentChannelAddrJ(a5)
	move.l	a0,a1
	lea	chanbuf_addr(a5),a0
	bsr	copychannel
	beq	track_nomem
	jsr	CorrectChannelJ(a5)

	move.w	#loc_c_pasted,d0
	jsr	status_displayJ(a5)

	st	songchanged(a5)
	bra	current_channel_update

.rts	rts




.events_dont_match
	move.w	#loc_cantpaste,d0
	move.w	#loc_well,d1
	jmp	EZrequestJ(a5)




nothingtopaste
	move.w	#loc_nopaste,d0
	move.w	#loc_pardon,d1
	jmp	EZrequestJ(a5)




;==============================================================
;
;  Pattern CUT
;
;==============================================================

edit_cutpattern
	tst.b	playflag(a5)
	bne.s	.rts

	tst.b	cuttobuf(a5)
	beq.s	.cut

;	jsr	packchannelJ(a5)
	lea	currentpatternA(a5),a0
	lea	pattbuf_addr(a5),a1
	bsr.s	copypattern
	beq.s	.nomem

.cut	lea	currentpatternA(a5),a0
	bsr	FreePattChannels
;	jsr	CorrectChannelJ(a5)
;	jsr	depackchannelJ(a5)

	bsr	new_pattern_refresh

	st	songchanged(a5)

	move.w	#loc_p_cut,d0
	jmp	status_displayJ(a5)

.nomem
;	jsr	depackchannelJ(a5)
	bra	track_nomem

.rts	rts




;==============================================================
;
;  Pattern COPY
;
;==============================================================

edit_copypattern

	tst.b	playflag(a5)
	bne.s	.play
	jsr	packchannelJ(a5)
	jsr	depackchannelJ(a5)
.play

	lea	currentpatternA(a5),a0
	lea	pattbuf_addr(a5),a1
	bsr.s	copypattern
	beq	track_nomem

	tst.b	playflag(a5)
	bne.s	.play2
	jsr	depackchannelJ(a5)
.play2

	move.w	#loc_p_copied,d0
	jmp	status_displayJ(a5)



;=== copy one pattern to another.
;=== if there is already a pattern in dest, free it first.

copypattern	; a0=^sourcepatternadr, a1=^destpatternadr
		; returns: pos/neg for success/failure

	movem.l	a0-a1,-(sp)

	move.l	a1,a0
	bsr	FreePatternAddr

	jsr	AllocPatternDryJ(a5)
	beq.s	.error

	move.l	4(sp),a1
	move.l	a0,(a1)

	lea	pt_channels(a0),a1	; dest
	move.l	(sp),a0
	move.l	(a0),a0
	lea	pt_channels(a0),a0	; source
	moveq	#15,d0
	move.l	d0,-(sp)
.chanloop

	movem.l	a0-a1,-(sp)
	bsr	copychannel
	movem.l	(sp)+,a0-a1
	beq.s	.error

	addq.w	#4,a0
	addq.w	#4,a1
	subq.l	#1,(sp)
	bcc.s	.chanloop
	addq.l	#4,sp

	movem.l	(sp),a2-a3
	move.l	(a2),a2
	move.l	(a3),a3
	move.l	pt_events(a2),pt_events(a3)
;	move.w	pt_chanmask(a2),pt_chanmask(a3)

;=== bpmtrack kopieren
	move.l	pt_bpmtrack(a2),d0
	beq.s	.nobpm
	move.l	d0,a0
	move.l	-(a0),d0
	subq.l	#4,d0
	move.l	d0,d2
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,pt_bpmtrack(a3)
	beq.s	.error
	move.l	d0,a1
	move.l	pt_bpmtrack(a2),a0
.bcopy	move.w	(a0)+,(a1)+
	subq.l	#2,d2
	bne.s	.bcopy
.nobpm

	movem.l	(sp)+,a0-a1
	POSITIV

.error	movem.l	(sp)+,a0-a1
	move.l	a1,a0
	bsr	FreePatternAddr
	NEGATIV





;==============================================================
;
;  Pattern PASTE
;
;==============================================================

edit_pastepattern
	tst.b	playflag(a5)
	bne.s	.rts

	move.l	pattbuf_addr(a5),d0
	beq	nothingtopaste

	move.l	currentpattern(a5),d0
	jsr	GetPatternAddrJ(a5)
	beq.s	.rts
	move.l	a0,a1
	lea	pattbuf_addr(a5),a0
	bsr	copypattern
	beq	track_nomem

	bsr	new_pattern_refresh

	st	songchanged(a5)

	move.w	#loc_p_pasted,d0
	jmp	status_displayJ(a5)

.rts	rts





;==============================================================
;
;  Delete to End Of Track
;
;==============================================================

del_eot
	tst.b	editmode(a5)
	beq	edit_noeditmode

	jsr	check_state_beforeJ(a5)

	move.l	currenttrack(a5),d0
	bpl	.normaltrack
	addq.l	#1,d0
	beq.s	.controltrack
	addq.l	#1,d0
	beq.s	.presettrack

;=== BPM Track
;	st	bpmtrackchanged(a5)
	jsr	GetBPMTrackJ(a5)
	beq.s	.out
	moveq	#BPM_stay,d2
	bsr	.deleot_2byte
	bra.s	.out



;=== Controlsource Track
.controltrack
	move.w	pgfx_active(a5),d0
	beq.s	.pb
	subq.w	#1,d0
;	beq.s	.mp

;=== normale Controlsource
;	move.l	ctrackchanged(a5),a0
;	st	-1(a0,d0.w)
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.out
	move.b	#cs_stay,d2
	bsr.s	.deleot_1byte
	bra.s	.out


.pb
;=== Pitchbender
;	st	pbtrackchanged(a5)
	jsr	GetPibeTrackJ(a5)
	move.w	#PB_stay,d2
	bsr.s	.deleot_2byte
;	bra.s	.out


;.mp
;=== Mono Press
;	st	mptrackchanged(a5)
;	move.l	mpworktrack(a5),a0
;	move.b	#cs_stay,d2
;	bsr.s	.deleot_1byte

.out
	st	songchanged(a5)
	bsr	refresh_the_track

	moveq	#loc_deleot,d0
	jmp	status_displayJ(a5)



;=== Preset Track
.presettrack
;	st	ptrackchanged(a5)
	jsr	GetPresetTrackJ(a5)
	beq.s	.out
	moveq	#Preset_stay,d2
	bsr.s	.deleot_2byte
	bra.s	.out



;=== Noten-Worktrack
.normaltrack
;	move.l	trackchanged(a5),a0
;	st	(a0,d0.w)
	jsr	GetTrackDataJ(a5)
	beq.s	.out
	move.l	#track_def_entry,d2

	move.l	events(a5),d1
	move.l	eventpos(a5),d0
	sub.l	d0,d1
	lsl.l	#2,d0
	adda.l	d0,a0
.nclear
	move.l	d2,(a0)+
	subq.l	#1,d1
	bne.s	.nclear
	bra.s	.out




.deleot_1byte	;a0=^worktrack, d2=stay
	move.l	events(a5),d1
	move.l	eventpos(a5),d0
	sub.l	d0,d1
	adda.l	d0,a0
.csclear
	move.b	d2,(a0)+
	subq.l	#1,d1
	bne.s	.csclear
	rts



.deleot_2byte	;a0=^worktrack, d2=stay
	move.l	events(a5),d1
	move.l	eventpos(a5),d0
	sub.l	d0,d1
	add.l	d0,d0
	adda.l	d0,a0
.pbclear
	move.w	d2,(a0)+
	subq.l	#1,d1
	bne.s	.pbclear
	rts






;==============================================================
;
;  Fix Velocity
;
;==============================================================

fixvelocity
	lea	.fvtab(pc),a0
	jmp	subitem_activatorJ(a5)
.fvtab
	dr.w	.fixvel_track
	dr.w	.fixvel_channel


;==============================================================
;
;  Fix Velocity on current track
;
;==============================================================

.fixvel_track
	tst.b	shiftpressed(a5)
	bne	.fixvel_channel

	tst.b	editmode(a5)
	beq	edit_noeditmode

	move.l	currenttrack(a5),d0
	bmi.s	.notrack

	bsr.s	.fixvel_entry
	beq.s	.cancelled
	move.b	d1,d2

	move.l	currenttrack(a5),d0
	bsr.s	.fix_routine

.redraw
	jmp	RedrawPatternOhneScrJ(a5)

.cancelled
	rts



.fix_routine	; d0.w=tracknumber
		; d2 = fix value

;	move.l	trackchanged(a5),a0
;	st	(a0,d0.w)
	st	songchanged(a5)
	jsr	GetTrackDataJ(a5)
	beq.s	.rts

	move.l	events(a5),d0
.trackloop
	tst.b	wd_pitch(a0)
	beq.s	.nonote
	move.b	d2,wd_vel(a0)
.nonote	addq.w	#wd_sizeof,a0
	subq.l	#1,d0
	bne.s	.trackloop
.rts	rts


.notrack
	move.w	#loc_fvtrack,d0
	move.w	#loc_ok,d1
	jmp	EZrequestJ(a5)


.fixvel_entry	; zurck: success, d1=value

;=== put default value
	lea	.vel_puffer(pc),a0
	move.b	oldfixvelocity(a5),d0
	moveq	#1,d1
	jsr	hexoutJ(a5)

;=== get string from user
	move.w	#loc_fixmsg,d0
	moveq	#2,d1
	lea	.vel_puffer(pc),a2
	jsr	rtStringJ(a5)
	beq.s	.neg

;=== convert hex-string to integer
	lea	.vel_puffer(pc),a0
	jsr	gethexJ(a5)
	beq.s	.neg

	moveq	#127,d0
	cmp.l	d1,d0
	bcs.s	.neg
	move.b	d1,oldfixvelocity(a5)

	POSITIV
.neg	NEGATIV


.vel_puffer	dc.b	'40',0

		even


;==============================================================
;
;  Fix Velocity on current channel
;
;==============================================================

.fixvel_channel
	tst.b	playflag(a5)
	bne.s	.neg

	bsr.s	.fixvel_entry
	beq	.cancelled
	move.b	d1,d2

	move.l	maxtracks_m1(a5),d3
.chanloop
	move.l	d3,d0
	bsr	.fix_routine
	subq.l	#1,d3
	bcc.s	.chanloop

	bra	.redraw





;==============================================================
;
;  Add Integer value to current controlsource (except PB)
;
;==============================================================

add_to_controlsource

	tst.b	amigapressed(a5)
	beq.s	.frommenu
	tst.b	shiftpressed(a5)
	beq	block_copy
.frommenu

	move.w	pgfx_active(a5),d0
	bne.s	.notPB

	move.w	#loc_notPB,d0
	move.w	#loc_itsokman,d1
	jmp	EZrequestJ(a5)


.notPB	subq.w	#1,d0
;	bne.s	.other
;	move.l	mpworktrack(a5),a0
;	st	mptrackchanged(a5)
;	bra.s	.cont


;.other
;	move.l	ctrackchanged(a5),a0
;	st	-1(a0,d0.w)
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.done
;.cont
	move.l	a0,-(sp)

	move.w	#loc_addvalue,d0
	move.l	last_addvalue(a5),d1
	bne.s	.notempty
	moveq	#8,d1
.notempty
	moveq	#-127,d2
	moveq	#127,d3
	jsr	rtLong_minmaxJ(a5)
	move.l	(sp)+,a0
	beq.s	.cancel
	tst.l	d1
	beq.s	.cancel
	move.l	d1,last_addvalue(a5)


	move.l	events(a5),d0
	move.b	#cs_stay,d3
.eventloop
	move.b	(a0)+,d2
	cmp.b	d3,d2
	beq.s	.stay
	add.b	d1,d2
	bpl.s	.ok
	bvs.s	.over
	moveq	#0,d2
	bra.s	.ok
.over	moveq	#127,d2

.ok	move.b	d2,-1(a0)
.stay
	subq.l	#1,d0
	bne.s	.eventloop


	st	songchanged(a5)
.done
	jsr	RedrawPatternOhneScrJ(a5)
	jmp	Refresh_pgfx_areaJ(a5)
;	bra	refresh_the_track

.cancel
	rts






edit_flushchannel

	tst.b	playflag(a5)
	bne.s	.rts

	move.w	#loc_flushbody,d0
	move.w	#loc_surenoway,d1
	jsr	EZrequestJ(a5)
	beq.s	.rts



	jsr	MainBusyPointerJ(a5)

	jsr	check_state_beforeJ(a5)


;=== clear channel in all patterns

	move.w	currentchannel(a5),d6
	subq.w	#1,d6
	move.l	patterntab(a5),a3
	move.l	patterntablen(a5),d7
.patternloop

	move.l	(a3)+,d0
	beq.s	.empty
	move.l	d0,a0
;	move.w	pt_chanmask(a0),d0
;	bset	d6,d0
;	move.w	d0,pt_chanmask(a0)
	IFEQ	mc68020
	move.w	d6,d0
	lsl.w	#2,d0
	lea	pt_channels(a0,d0.w),a0
	ELSE
	lea	pt_channels(a0,d6.w*4),a0
	ENDC
	bsr	FreeChannel

.empty	subq.l	#1,d7
	bne.s	.patternloop


	jsr	CorrectChannelJ(a5)

	st	songchanged(a5)
	bsr	current_channel_update


;=== clear channelname

	lea	.zeroname(pc),a0
	jsr	new_channelnameJ(a5)


	jmp	MainActivePointerJ(a5)


.rts	rts


.zeroname	dc.b	0

		even
