;APS00002185000025F50000000000002F15000000000000000000000000000000000000000000000000
;=============================================================
;
;  mt-channelselect.S
;
;
;=============================================================




; this function is called when a window is selected via menu.

channel_selector

	lsr.w	#6,d5
	ext.l	d5
	addq.l	#1,d5
; d5.l = 1-16 (channel number)

	lea	chanselect_mappings+16*2(a5),a0
	move.l	d5,d1
	moveq	#15,d4
.findloop
	cmp.w	-(a0),d1
	dbeq	d4,.findloop
	ext.l	d4

; d4.l = channelwindow (0-15) to the channel, or -1


	move.l	d5,d0
	subq.l	#1,d0
	lsl.l	#8,d0
	lsl.l	#3,d0
	add.w	#channel1_menu,d0
	jsr	MainCheckmarkJ(a5)
	beq.s	.closewindow


	tst.l	d4
	bpl.s	.switch


;=== open the window

	move.l	d5,d0
	bra.s	OpenChannel

.closewindow
	move.l	d4,d0
	bmi.s	.rts
	jsr	get_inst_structJ(a5)
	move.l	wd_Wnd(a0),d0
	beq.s	.rts
	move.l	d0,a4
	bra	instwdclosegad

.rts	rts

.switch
	move.l	d5,d0
	jmp	SelectChannelJ(a5)

;	move.l	d4,d0
;	jsr	get_inst_structJ(a5)
;	move.l	wd_Wnd(a0),d0
;	beq.s	.rts
;	move.l	d0,a4
;	bra.s	instactivewindow




OpenChannel	; d0 = channel number

; find the first unused (closed) window

	lea	chanselect_mappings(a5),a0
	moveq	#15,d1
.getloop
	tst.w	(a0)+
	dbeq	d1,.getloop
	bne.s	.neg		; all channelwindows used

	sub.w	#15,d1
	neg.w	d1
	move.l	d1,-(sp)
	; d0 is parameter
	bsr	OpenChannelOnWindow
	beq.s	.openfailed

	move.l	(sp)+,d1

	POSITIV

.openfailed
	move.l	(sp)+,d0
	jsr	get_inst_structJ(a5)
	move.l	wd_Wnd(a0),d0
	beq.s	.neg
	move.l	d0,a4
	bsr	instwdclosegad
.neg	NEGATIV





instactivewindow	; a4 = ^window

	bsr	find_inst_struct
	beq.s	.rts

	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	add.l	d1,d1
	move.w	(a0,d1.l),d0
	ELSE
	move.w	(a0,d1.l*2),d0
	ENDC
;	cmp.w	currentchannel(a5),d0
;	beq.s	.rts

	jsr	SwitchChannelJ(a5)
	jmp	RefreshMainChannelJ(a5)

.rts	rts





replace_channelvalues	; d0.l = channelwindow (0-15)

	move.l	d0,d2
	bmi.s	.rts

	lea	chanselect_mappings(a5),a0
	move.w	currentchannel(a5),d1
	IFEQ	mc68020
	add.l	d0,d0
	tst.w	(a0,d0.l)
	beq.s	.rts
	move.w	d1,(a0,d0.l)
	ELSE
	tst.w	(a0,d0.l*2)
	beq.s	.rts
	move.w	d1,(a0,d0.l*2)
	ENDC


;	move.l	d2,d0
;	jsr	get_inst_structJ(a5)
;	move.l	wd_Wnd(a0),a0
;	move.l	4(a0),channel_lefttop(a5)

	move.w	d1,d0
	ext.l	d0
	bsr	get_channelblock_chan

	move.l	displaytrack(a5),chan_displaytrack(a0)
	move.l	currenttrack(a5),chan_currenttrack(a0)
	move.l	eventpos(a5),chan_eventpos(a0)
	move.b	vel_or_pp(a5),chan_vel_or_pp(a0)
	move.b	cursorset(a5),chan_cursorset(a0)
	move.w	pgfx_active(a5),chan_pgfx_active(a0)
	move.l	displayed_tracks(a5),chan_displayed_tracks(a0)
	move.l	lines_in_td_half(a5),chan_lines_in_td_half(a0)
	move.w	cursorpos(a5),chan_cursorpos(a0)
	move.b	blockmarked(a5),chan_blockmarked(a0)
	move.b	blockmarktype(a5),chan_blockmarktype(a0)
	move.l	blocktrack(a5),chan_blocktrack(a0)
	move.l	blockstart(a5),chan_blockstart(a0)
	move.l	blockstop(a5),chan_blockstop(a0)
	move.l	blockfirst(a5),chan_blockfirst(a0)


;	lea	current_channelblock(a5),a0
;	moveq	#chan_sizeof,d0
;	move.l	(a5),a6
;	jsr	CopyMem(a6)


;	move.l	currentpatternA(a5),a0
;	IFEQ	mc68020
;	move.l	d2,d1
;	lsl.w	#2,d1
;	move.l	pt_channels(a0,d1.l),d1
;	ELSE
;	move.l	pt_channels(a0,d2.l*4),d1
;	ENDC
;	beq.s	.defchancont
;	move.l	d1,a0
;	move.l	pattscale(a5),d0
;	move.w	d0,ch_scale(a0)
;.defchancont


.rts	rts



retrieve_channelvalues	; d0.l = channelwindow (0-15), d1.w = new channel

	tst.l	d0
	bmi.s	.rts

	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	add.l	d0,d0
	move.w	(a0,d0.l),d2
	move.w	d1,(a0,d0.l)
	ELSE
	move.w	(a0,d0.l*2),d2
	move.w	d1,(a0,d0.l*2)
	ENDC
;	subq.w	#1,d1
;	move.w	d1,d3
	tst.w	d2
	beq.s	.default

	move.w	d1,d0
	ext.l	d0
	bsr	get_channelblock_chan

	move.l	chan_displaytrack(a0),displaytrack(a5)
	move.l	chan_currenttrack(a0),currenttrack(a5)
	move.l	chan_eventpos(a0),eventpos(a5)
	move.b	chan_vel_or_pp(a0),vel_or_pp(a5)
	move.b	chan_cursorset(a0),cursorset(a5)
	move.w	chan_pgfx_active(a0),pgfx_active(a5)
	move.l	chan_displayed_tracks(a0),displayed_tracks(a5)
	move.l	chan_lines_in_td_half(a0),lines_in_td_half(a5)
	move.w	chan_cursorpos(a0),cursorpos(a5)
	move.b	chan_blockmarked(a0),blockmarked(a5)
	move.b	chan_blockmarktype(a0),blockmarktype(a5)
	move.l	chan_blocktrack(a0),blocktrack(a5)
	move.l	chan_blockstart(a0),blockstart(a5)
	move.l	chan_blockstop(a0),blockstop(a5)
	move.l	chan_blockfirst(a0),blockfirst(a5)

;	lea	chanselect_channels(a5),a0
;	moveq	#chan_sizeof,d0
;	mulu	d0,d1
;	adda.l	d1,a0
;	lea	current_channelblock(a5),a1
;	move.l	(a5),a6
;	jsr	CopyMem(a6)

;.further

.rts	rts

.default
	lea	current_channelblock(a5),a0
	jmp	default_channelvaluesJ(a5)






instwdopen	; a4 = ^windowstruct, d0.w = channel (1-16)
	tst.l	wd_Wnd(a4)
	bne.s	.norm

;=== Fenster ffnen
	bsr.s	RefreshInstWindow
	beq.s	.norm
	jsr	OpenWDJ(a5)
	bne.s	.norm

	POSITIV
.norm	NEGATIV







RefreshInstWindow	; a4 = ^windowstruct, d0.w = channel (1-16)

	move.w	wd_wdnumber(a4),d1
	sub.w	#inst_wdnumber_offset,d1
	ext.l	d1

	movem.l	d0-d1/a4,-(sp)

;=== create bitmaps
	; d0 and d1 are parameters
	jsr	PrepareTrackdisplayBitmapJ(a5)
	beq	.neg



	move.l	8(sp),a4



;=== init gadget-tags
	move.l	wd_GTags(a4),a2

; calculate pattern-scroller
;	move.l	eventpos(a5),d0
;	move.l	pattscale(a5),d1
;	divu	d1,d0
;	ext.l	d0
;	move.l	d0,MTinstGTscrolltop(a0)
;	move.l	events(a5),d2
;	divu	d1,d2
;	ext.l	d2
;	move.l	d2,MTinstGTpattsize(a0)
;	addq.l	#lines_in_td_half*2,d2
;	move.l	d2,MTinstGTscrolltotal(a0)

;	move.b	vel_or_pp(a5),MTinstGTvelorpp(a0)
	move.l	maxtracks(a5),MTinstGTmaxtr(a2)

	move.l	currentpattern(a5),d0
	addq.l	#1,d0
	move.l	d0,MTinstGTpattnum(a2)

;	st	MTinstGTstate(a2)
;	move.l	(sp),d0
;	jsr	GetAnyChannelJ(a5)
;	beq.s	.nochan
;	tst.b	ch_onoff(a0)
;	seq	MTinstGTstate(a2)
;.nochan


	move.l	(sp),d0
	bsr	get_channelblock_chan
	move.l	a0,a2



;=== calculate newgad structures

	move.l	wd_NGads(a4),a0

	lea	tdbitmap_height_chans(a5),a1
	move.l	4(sp),d0
	IFEQ	mc68020
	lsl.l	#2,d0
	move.l	(a1,d0.l),d4
	ELSE
	move.l	(a1,d0.l*4),d4
	ENDC
	move.w	d4,GD_pattscroller*ng_sizeof+ng_height(a0)



; calculate xsize of the trackselector scroller

	move.l	chan_displayed_tracks(a2),d0
	move.l	d0,d2
	subq.l	#2,d0
	mulu	#tracksgad_d,d0
	move.w	d0,GD_tracksel*ng_sizeof+ng_width(a0)



; calculate xpos and xsize of the velorpp-gadget

	add.w	GD_tracksel*ng_sizeof+ng_left(a0),d0
	move.w	d0,GD_velorpp*ng_sizeof+ng_left(a0)




;=== calculate window height
	add.w	#tdbegin_y+3+4,d4	; + borderbottom + bordertop
	add.w	fontheight(a5),d4
; d4 = height



;=== calculate window width
	move.l	chan_displayed_tracks(a2),d3
	mulu	#tracksgad_d,d3
	add.w	#tracksgad_x+2*5+16,d3	; plus left/right boundaries
; d3 = width


;=== window left/top
;	lea	inst_ltwh(a5),a0
;	move.l	4(sp),d0
;	IFEQ	mc68020
;	lsl.l	#3,d0
;	move.l	(a0,d0.l),d1
;	ELSE
;	move.l	(a0,d0.l*8),d1
;	ENDC
	move.l	chan_ltwh(a2),d1
	bmi.s	.oldlefttop

	move.w	d1,d2
	swap	d1
	bra.s	.ltcont

.oldlefttop
	move.l	active_channelwindow(a5),d0	; previous window
	bmi.s	.firstwin

;	IFEQ	mc68020
;	lsl.l	#3,d1
;	move.l	(a0,d1.l),d1
;	ELSE
;	move.l	(a0,d1.l*8),d1
;	ENDC
	bsr	get_channelblock_win
	move.l	chan_ltwh(a0),d1
	bmi.s	.firstwin

	move.w	d1,d2
	swap	d1
	add.w	#20,d1
	add.w	#10,d2
	bra.s	.ltcont

.firstwin
; position the window right below the main window
	move.l	MTmainStruct+wd_Wnd(a5),a0
	move.w	4(a0),d1
	move.w	6(a0),d2
	add.w	10(a0),d2
.ltcont
; d1 = left, d2 = top

	lea	MTinstWindowTags(pc),a0
	move.w	d1,$4+2(a0)
	move.w	d2,$c+2(a0)
	move.w	d3,$14+2(a0)
	move.w	d4,$1c+2(a0)

;	IFEQ	mc68020
;	movem.w	d1-d4,(a0,d0.l)
;	ELSE
;	movem.l	d1-d4,(a0,d0.l*8)
;	ENDC

	movem.w	d1-d4,chan_ltwh(a2)




; update the number of gadgets in this window

	move.l	chan_displayed_tracks(a2),d0
	moveq	#GD_track0,d1
	add.l	d1,d0
	move.w	d0,wd_CNT(a4)



; calculate the minimum/maximum height of the window

	lea	MTinstWindowTags(pc),a0

	moveq	#(min_lines_in_td_half*10+1)*2+17+tdbegin_y+7,d0
	add.w	fontheight(a5),d0
	move.w	d0,MTinstWTminheight(a0)

	move.w	#(max_lines_in_td_half*10+1)*2+17+tdbegin_y+7,d0
	add.w	fontheight(a5),d0
	move.w	d0,MTinstWTmaxheight(a0)



; update windowtitle

	move.l	4(sp),d0
	move.l	active_channelwindow(a5),d1
	bmi.s	.inactive
	cmp.l	d1,d0
	bne.s	.inactive
	bsr	make_active_channeltitle
	bra.s	.acont
.inactive
	bsr	make_inactive_channeltitle
.acont
	move.l	4(sp),d0
	bsr.s	get_inst_wdtitle
	lea	MTinstWindowTags(pc),a0
	move.l	a1,MTinstWT(a0)


	movem.l	(sp)+,d0-d1/a4
	POSITIV
.neg	movem.l	(sp)+,d0-d1/a4
	NEGATIV




get_inst_wdtitle	; d0.l = channelwindow
			; returns: a1 = ^windowtitle
			; leaves a0 unchanged

	move.l	MTinstWTitlesD(a5),a1
	mulu	#MTinstWTitle_len,d0
	adda.l	d0,a1
	rts



;=== build windowtitle for active channel

make_active_channeltitle	; d0 = channel window number (0-15)

	move.l	d0,-(sp)

; copy localized "active" string

	move.w	#loc_channelactive,d0
	jsr	getcatstringJ(a5)
	move.l	a1,a0
	move.l	(sp),d0
	bsr.s	get_inst_wdtitle
	move.l	a1,a2
	COPYMAXWITHOUTZERO 10

	move.b	#':',(a1)+
	move.b	#' ',(a1)+

	move.l	(sp)+,d0
	bra.s	make_channeltitle_routine




make_inactive_channeltitle	; d0.l = channelwindow (0-15)

	move.l	d0,d2

	bsr	get_inst_wdtitle
	move.l	a1,a2

	move.l	d2,d0




make_channeltitle_routine	; d0 = channelwindow, a1 = ^dest-string, a2 = ^windowtitle

	move.l	d0,-(sp)

; copy the instrument name

	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	add.l	d0,d0
	move.w	(a0,d0.l),d1
	ELSE
	move.w	(a0,d0.l*2),d1
	ENDC
	beq.s	.nochannel

	move.w	d1,d0
	subq.w	#1,d0
	mulu	#channelmenu_len,d0
	move.l	MTmainMchan1D(a5),a0
	adda.l	d0,a0
	COPYWITHOUTZERO

	move.l	a1,d1
	sub.l	a2,d1
	moveq	#blockrange_offset-1,d0
	sub.l	d1,d0
.zloop	move.b	#' ',(a1)+
	dbf	d0,.zloop

	clr.b	9(a1)

; create block boundaries, if a block is marked

	move.l	(sp),d0
	jsr	RecalcBlockJ(a5)

.nochannel

	move.l	(sp)+,d0
	rts





OpenChannelOnWindow	; d0.w = new channel (1-16),
			; d1.l = active window (0-15)
			; returns: pos/neg

	movem.l	d0-d1,-(sp)

	move.l	d1,d0
	jsr	get_inst_structJ(a5)
	move.l	a0,a4
	move.l	(sp),d0
	bsr	instwdopen
	beq.s	.wrong


	move.l	(sp),d1
	move.l	4(sp),d0
	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	move.l	d0,d2
	add.l	d2,d2
	move.w	d1,(a0,d2.l)
	ELSE
	move.w	d1,(a0,d0.l*2)
	ENDC


;=== set and activate the new window

	move.l	(sp)+,d0
	addq.l	#4,sp
	jsr	SelectChannelJ(a5)

	POSITIV

.wrong	movem.l	(sp)+,d0-d1
	NEGATIV





SetActiveChannel	; d0.w = new channel (1-16)

	ext.l	d0
	move.l	d0,d3
	move.l	active_channelwindow(a5),d0
	move.l	d0,-(sp)

; d0 = active (old) channelwindow, d3 = new channel

	lea	chanselect_mappings+16*2(a5),a0
	moveq	#15,d2
.chanselectloop
	cmp.w	-(a0),d3
	dbeq	d2,.chanselectloop
	beq.s	.windowfound

	tst.l	d0
	bmi.s	.back
	bra.s	.samewin


.back	move.l	(sp)+,d0
	rts


; the new channel is in one of the currently open channelwindows
.windowfound

	tst.l	d0
	bmi.s	.otherwin

	cmp.w	d0,d2
	bne.s	.otherwin

; the new channel is to be in the same window
.samewin
	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	add.l	d0,d0
	move.w	(a0,d0.l),d1
	ELSE
	move.w	(a0,d0.l*2),d1
	ENDC
	beq.s	.noprevchan

	move.w	d1,d0
	subq.w	#1,d0
	lsl.w	#8,d0
	lsl.w	#3,d0
	add.w	#channel1_menu,d0
	moveq	#0,d1
	jsr	SetMainCheckmarkJ(a5)
.noprevchan

	move.l	d3,d0
	subq.w	#1,d0
	lsl.w	#8,d0
	lsl.w	#3,d0
	add.w	#channel1_menu,d0
	moveq	#1,d1
	jsr	SetMainCheckmarkJ(a5)

	lea	chanselect_mappings(a5),a0
	move.l	(sp),d0
	IFEQ	mc68020
	add.l	d0,d0
	move.w	d3,(a0,d0.l)
	ELSE
	move.w	d3,(a0,d0.l*2)
	ENDC

	bra.s	.setchan


; the new channel is already on another window
.otherwin	; d2 = other (new) channelwindow
		; d0 = old channelwindow (may be -1)
		; d3 = new channel

	move.l	d2,-(sp)
	move.l	d3,-(sp)

	tst.l	d0
	bmi.s	.nooldwin
	bsr	make_inactive_channeltitle
	move.l	8(sp),d0
	jsr	set_wdtitle_instJ(a5)
.nooldwin

	move.l	4(sp),d0
	jsr	get_inst_structJ(a5)
	move.l	wd_Wnd(a0),d0
;	jsr	window_activationJ(a5)
	move.l	d0,a0
	move.l	intbas(a5),a6
	jsr	WindowToFront(a6)

	move.l	(sp)+,d3
	move.l	(sp)+,(sp)

	move.l	(sp),d0
	move.l	d3,d1
	bsr	retrieve_channelvalues

.setchan

	move.l	(sp),d0
	move.l	d0,active_channelwindow(a5)
	bsr	make_active_channeltitle
	move.l	(sp)+,d0
	jmp	set_wdtitle_instJ(a5)





instIDCMP
	dc.w	.count-1
;	dc.l	$00000002
;	dr.l	inst_newsize
	dc.l	$00000004
	dr.l	window_refresh
	dc.l	$00000008
	dr.l	instmousebuttons
	dc.l	$00000010
	dr.l	instmousemove
	dc.l	$00000040
	dr.l	instgadgetup
	dc.l	$00000100
	dr.l	mainmenupick
	dc.l	$00000200
	dr.l	instwdclosegad
	dc.l	$00000400
	dr.l	mainrawkey
	dc.l	$00040000
	dr.l	instactivewindow
	dc.l	$00400000
	dr.l	Generalintuiticks
	dc.l	$02000000
	dr.l	instchangewindow
	dc.l	$04000000
	dr.l	instgadgethelp
.count = (*-instIDCMP-2)/8






find_inst_struct	; a4 = ^window
			; returns: a4 = windowstruct to the window
			;          d1.l = channelwindow number (0-15)
			;          pos/neg

	move.l	a4,a0
	lea	MTinst1Struct(a5),a4
	moveq	#15,d1
	bra.s	.jin
.findloop
	lea	wd_structsize(a4),a4
.jin	cmpa.l	wd_Wnd(a4),a0
	dbeq	d1,.findloop
	bne.s	.rts
	sub.w	#15,d1
	neg.w	d1
	ext.l	d1
	POSITIV
.rts	NEGATIV




;==============================================================
;
;  WINDOWCLOSE Event
;
;==============================================================

instwdclose	; a4 = ^struct

	move.w	wd_wdnumber(a4),d0
	sub.w	#inst_wdnumber_offset,d0
	ext.l	d0
	move.l	d0,-(sp)
	jsr	FreeTrackdisplayBitmapJ(a5)

	move.l	(sp)+,d0
	bsr	FreeRedrawAsciiBuffer

	jmp	CloseWDJ(a5)




instwdclosegad	; a4 = ^window

	move.l	a4,d0
	beq.s	.rts

	bsr	find_inst_struct
	beq.s	.rts

	bsr.s	SwitchBackChannel
	move.l	d1,d0
	beq.s	.lastwin

	move.l	a4,-(sp)
	jsr	SelectChannelJ(a5)
	move.l	(sp)+,a4

.lastwin
	bra.s	instwdclose

.rts	rts




SwitchBackChannel	; a4 = ^windowstruct
			; returns: d1.l = new active displayed channel
			;                 or 0 if the last window is closed

	move.l	a4,-(sp)

	move.w	wd_wdnumber(a4),d2
	sub.w	#inst_wdnumber_offset,d2
	ext.l	d2
	move.l	d2,-(sp)


	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	move.l	d2,d1
	add.l	d1,d1
	move.w	(a0,d1.l),d0
	ELSE
	move.w	(a0,d2.l*2),d0
	ENDC
	subq.w	#1,d0

	lsl.w	#8,d0
	lsl.w	#3,d0
	add.w	#channel1_menu,d0
	moveq	#0,d1
	jsr	SetMainCheckmarkJ(a5)


; find the first open channelwindow
	lea	chanselect_mappings(a5),a0
	moveq	#0,d1
.checkloop
	tst.w	(a0)+
	bgt.s	.atleast1open
.nextcheck
	addq.w	#1,d1
	cmp.w	#16,d1
	bcs.s	.checkloop

; The last window is being closed now.
	move.l	(sp),d0
	bsr	replace_channelvalues
	moveq	#-1,d2
	move.l	d2,active_channelwindow(a5)
	moveq	#0,d1
	bra.s	.opencont

; At least 1 window is still open.
.atleast1open
	cmp.l	(sp),d1
	beq.s	.nextcheck
	move.w	-(a0),d1

.opencont


	lea	chanselect_mappings(a5),a0
	move.l	(sp)+,d2
	IFEQ	mc68020
	add.l	d2,d2
	clr.w	(a0,d2.l)
	ELSE
	clr.w	(a0,d2.l*2)
	ENDC


	move.l	(sp)+,a4
	rts




instchangewindow

	bsr	find_inst_struct
	beq	.rts

	move.w	newsize_refresh_chansel(a5),d0
	btst	d1,d0
	beq.s	.user_newsize
	bclr	d1,d0
	move.w	d0,newsize_refresh_chansel(a5)

	; a4 is ^windowstruct
	jsr	RefreshWindowGadgetsJ(a5)

	move.l	wd_Wnd(a4),a0
	move.l	intbas(a5),a6
	jsr	RefreshWindowFrame(a6)

	jsr	RefreshNumsJ(a5)
	jsr	RefreshPresettrackJ(a5)
	jsr	RefreshCSModeJ(a5)
	bsr	RefreshVelOrPP

	jmp	RedrawPatternJ(a5)

.user_newsize

;=== activate channelwindow, if not yet activated

;	move.l	a4,-(sp)
;	bsr	instactivewindow
;	move.l	(sp)+,a4


; d1.l = channelwindow number

	movem.l	d1/a4,-(sp)

	move.l	d1,d0
	bsr	get_channelblock_win
	move.l	a0,-(sp)

	move.l	wd_Wnd(a4),a1
	movem.w	8(a1),d6-d7		; width, height in pixels

	move.l	4(a1),chan_ltwh(a0)

;	lea	inst_ltwh(a5),a0
;	IFEQ	mc68020
;	move.l	d1,d0
;	lsl.l	#3,d0
;	movem.w	4(a0,d0.w),d2-d3
;	ELSE
;	movem.w	4(a0,d1.w*8),d2-d3
;	ENDC
	movem.w	chan_ltwh+4(a0),d2-d3
	cmp.w	d2,d6
	bne.s	.changed
	cmp.w	d3,d7
	bne.s	.changed
	bra	.nonewsize
.changed


;=== calculate new displayed rows

	sub.w	fontheight(a5),d7
	sub.w	#tdbegin_y+3+4,d7	; borderbottom, bordertop
	sub.w	#17,d7
	lsr.w	#1,d7
	subq.w	#1,d7
	ext.l	d7
	divu	#10,d7
	ext.l	d7

	moveq	#max_lines_in_td_half,d0
	cmp.l	d0,d7
	bls.s	.rows_ok
	move.l	d0,d7
.rows_ok




;=== calculate new displayed tracks

	sub.w	#tracksgad_x+2*5+16,d6	; left/right boundaries
	ext.l	d6
	divu	#tracksgad_d,d6
	ext.l	d6

	moveq	#max_displayed_tracks,d0
	cmp.l	d0,d6
	bls.s	.tracks_ok
	move.l	d0,d6
.tracks_ok
	move.l	maxtracks(a5),d0
	cmp.l	d0,d6
	bls.s	.tracks_ok2
	move.l	d0,d6
.tracks_ok2


	move.l	d7,lines_in_td_half(a5)
	move.l	d6,displayed_tracks(a5)
	move.l	4(sp),d0
	bsr	replace_channelvalues


	move.w	wd_wdnumber(a4),d0
	sub.w	#inst_wdnumber_offset,d0
	ext.l	d0
	jsr	FreeTrackdisplayBitmapJ(a5)

	move.w	currentchannel(a5),d0
	bsr	RefreshInstWindow
	beq.s	.nonewsize

	move.l	4(sp),d1
	move.w	newsize_refresh_chansel(a5),d0
	bset	d1,d0
	move.w	d0,newsize_refresh_chansel(a5)

;	lea	inst_ltwh(a5),a0
;	move.l	(sp),d0
;	IFEQ	mc68020
;	lsl.l	#3,d0
;	movem.w	(a0,d0.l),d0-d3
;	ELSE
;	movem.w	(a0,d0.l*8),d0-d3
;	ENDC
	move.l	(sp),a0
	movem.w	chan_ltwh(a0),d0-d3
	move.l	wd_Wnd(a4),a0
	move.l	intbas(a5),a6
	jsr	ChangeWindowBox(a6)

.nonewsize

	movem.l	(sp)+,d0-d1/a4
.rts	rts





;==============================================================
;
;  GADGETHELP Event
;
;==============================================================

instgadgethelp
	bsr	find_inst_struct
	beq.s	.rts

;	lea	.helpoffsets(pc),a0
	lea	.loc_helpoffsets(pc),a1
	move.l	a4,a2
	jmp	gadgethelpJ(a5)

.rts	rts

	IFEQ	1

.helpoffsets
	dr.l	scroller_buttonH
	dr.l	patternposH
	dr.l	BPM_buttonH
	dr.l	Pre_buttonH
	dr.l	cs_buttonH
	dr.l	velorppH
	dr.l	src_gadgetH
	dr.l	trackselH
	dr.l	pattern_numberH
	dr.l	channelstateH
	REPT	max_displayed_tracks
	dr.l	track0_buttonH
	ENDR

	ENDC

.loc_helpoffsets
	dc.w	loc_scroller_buttonH
	dc.w	loc_patternposH
	dc.w	loc_BPM_buttonH
	dc.w	loc_Pre_buttonH
	dc.w	loc_cs_buttonH
	dc.w	loc_velorppH
	dc.w	loc_src_gadgetH
	dc.w	loc_trackselH
	dc.w	loc_pattnumH
	dc.w	loc_channelstateH
	REPT	max_displayed_tracks
	dc.w	loc_track0_buttonH
	ENDR





;==============================================================
;
;  GADGETUP Event
;
;==============================================================

instgadgetup
	lea	.instGadgetTab(pc),a0
	jmp	gadgetjsrJ(a5)
.instGadgetTab
	dr.w	.nop_gadget	; scroller_button
	dr.w	*
	dr.w	* ;BPM_button
	dr.w	* ;Pre_button
	dr.w	* ;cs_button
	dr.w	velocity_or_ppress
	dr.w	src_gadget
	dr.w	.nop_gadget	; track_selector
	dr.w	*
	dr.w	channelstate_gadget

	REPT	max_displayed_tracks
	dr.w	*		;track0_button
	ENDR



.nop_gadget
	rts




;==============================================================
;
;  MOUSEMOVE Message
;
;==============================================================

instmousemove
	bsr	find_inst_struct
	beq.s	.rts
	move.l	a4,a1
	lea	.mmovetab(pc),a0
	jmp	mousemoverJ(a5)
.rts	rts
.mmovetab
	dc.w	.mmovesize-1

	bra	scroller_button
	dc.w	GD_pattscroller

	bra	track_selector
	dc.w	GD_tracksel

.mmovesize = (*-.mmovetab-2)/6







instmousebuttons

	bsr	find_inst_struct
	beq.s	.rts
	move.l	a4,a1
	lea	.TextGadgets(pc),a0
	jmp	gadgethandlerJ(a5)
.rts	rts

.TextGadgets
	dc.w	GD_track0
	bra	mb_tracks
	dc.w	GD_track1
	bra	mb_tracks
	dc.w	GD_track2
	bra	mb_tracks
	dc.w	GD_track3
	bra	mb_tracks
	dc.w	GD_track4
	bra	mb_tracks
	dc.w	GD_track5
	bra	mb_tracks
	dc.w	GD_track6
	bra	mb_tracks
	dc.w	GD_track7
	bra	mb_tracks
	dc.w	GD_track8
	bra	mb_tracks
	dc.w	GD_track9
	bra	mb_tracks
	dc.w	GD_track10
	bra	mb_tracks
	dc.w	GD_track11
	bra	mb_tracks

	dc.w	GD_cstrack
	bra	mb_cstrack

	dc.w	-1




mb_tracks
	move.l	d1,d0		; keep gadget-id in d1
	sub.w	#GD_track0,d0
	ext.l	d0

;	move.l	current_states(a5),a1
	add.l	displaytrack(a5),d0
;	tst.b	(a1,d0.l)
;	beq.s	.empty

;	move.l	trackchanged(a5),a1
;	st	(a1,d0.l)

; toggle flag in packed structure
	jsr	GetTrackJ(a5)
	beq.s	.empty
	not.b	tr_onoff(a1)

	movem.l	d1/a1,-(sp)
	jsr	CalcTrackStringNumberJ(a5)
	movem.l	(sp)+,d1/a1
	move.l	trackStringD(a5),a0
	move.b	tr_onoff(a1),d0

; toggle flag in current structure
;	move.l	current_onoffs(a5),a2
;	not.b	(a2,d0.l)
	bra.s	mb_check

.empty	rts


mb_check	; d0 = onoff-status, d1 = gadgetid, a0 = ^string
	tst.b	d0
	bne.s	.on
.off	moveq	#text_muted_pen,d0	; track muted, filled
	bra.s	.chng
.on	moveq	#text_active_pen,d0	; track active, filled
.chng
	move.l	active_channelwindow(a5),d4
	bsr	SetTextInst

	st	songchanged(a5)
	jmp	songchangeJ(a5)



mb_cstrack
	move.w	pgfx_active(a5),d0
	beq.s	.PB
	subq.w	#1,d0
;	beq.s	.MP

;=== Controlsource
;	lea	cs_states(a5),a1
;	move.w	pgfx_active(a5),d0
;	tst.b	-2(a1,d0.w)
;	beq.s	.empty2

; toggle flag in packed structure
	jsr	GetCSourceTrackJ(a5)
	beq.s	.empty2
	not.b	cs_onoff(a0)
	move.b	cs_onoff(a0),d0

.do_cs	move.l	csStringD(a5),a0
	moveq	#GD_cstrack,d1

	bsr.s	mb_check
	jmp	Refresh_pgfx_lvJ(a5)

.empty2	rts


;=== Pitchbend
.PB
;	tst.b	currentpb_state(a5)
;	beq.s	.empty2

	jsr	GetChannelJ(a5)
	beq.s	.empty2
	not.b	ch_pb_onoff(a0)
	move.b	ch_pb_onoff(a0),d0

;	not.b	currentpb_onoff(a5)
	bra.s	.do_cs



;=== MPress
;.MP
;	tst.b	currentmp_state(a5)
;	beq.s	.empty2

;	move.l	currentchannelA(a5),d0
;	beq.s	.nocMP
;	move.l	d0,a0
;	not.b	ch_mp_onoff(a0)
;.nocMP
;	move.l	csStringD(a5),a0
;	moveq	#GD_cstrack,d1
;	not.b	currentmp_onoff(a5)
;	bra.s	.cs_check







;==============================================================
;
;  Browse controlsources
;
;==============================================================

src_gadget
	move.w	pgfx_active(a5),d0
	addq.w	#1,d0

	move.l	active_csources(a5),d1
	addq.l	#1,d1
	cmp.w	d1,d0
	bcs.s	.push
	moveq	#0,d0
.push	move.w	d0,pgfx_active(a5)

	jmp	csource_refreshJ(a5)



;==============================================================
;
;  Track Selector Scroller
;
;==============================================================

track_selector
	jsr	GetScrollerInstJ(a5)
	move.l	d0,displaytrack(a5)

	jsr	RefreshNumsOhneTSJ(a5)
	jmp	RedrawPatternOhneScrJ(a5)






;==============================================================
;
;  Scroller links neben dem Pattern
;
;==============================================================

scroller_button
	tst.b	playflag(a5)
	bne.s	.rts

	jsr	GetScrollerInstJ(a5)
	move.l	d0,-(sp)
	jsr	GetChannelResolutionJ(a5)
	move.l	(sp)+,d1
	mulu	d1,d0
	move.l	d0,eventpos(a5)
	jmp	key_afterJ(a5)
.rts	rts





velocity_or_ppress
	jsr	GetCycleInstJ(a5)
	move.b	d0,vel_or_pp(a5)
	jmp	redrawpatternohnescrJ(a5)




RefreshVelOrPP
	moveq	#0,d0
	move.b	vel_or_pp(a5),d0
	moveq	#GD_velorpp,d1
	move.l	active_channelwindow(a5),d4
	jmp	SetCycleInstJ(a5)







RefreshChannelwindows

;	move.l	active_channelwindow(a5),d0
;	bmi.s	.rts

	lea	chanselect_mappings+32(a5),a2
	moveq	#15,d0
.windowloop

	tst.w	-(a2)
	beq.s	.nowin

;	bsr	get_channelblock_chan

;	move.l	chan_displayed_tracks(a0),d1
;	move.l	chan_displaytrack(a0),d0
;	add.l	d0,d1
;	cmp.l	maxtracks(a5),d1
;	ble.s	.win_ok
;	move.l	d0,chan_displaytrack(a0)
;.win_ok

	movem.l	d0/a2,-(sp)

	bsr.s	RefreshChannelwindowPacked

	movem.l	(sp)+,d0/a2

.nowin	dbf	d0,.windowloop

.rts	rts





RefreshChannelwindowPacked	; d0 = channelwindow
	move.l	d0,-(sp)
	bsr	RefreshNums_2
	move.l	(sp),d0
	bsr	RefreshPresettrack_2
	move.l	(sp),d0
	bsr	RefreshBPMtrack_2
	move.l	(sp),d0
	bsr	RefreshCSMode_2

	move.l	(sp),d0
	bsr	RefreshChannelEnable_routine

	move.l	(sp)+,d0
	bra	RedrawPackedPattern





get_current_channelblock	; d0 = channelwindow
				; returns: a0 = current channelblock or
				;               saved channelblock
				;          d0 = channel #

	cmp.l	active_channelwindow(a5),d0
	bne.s	get_channelblock_win
	lea	current_channelblock(a5),a0
	move.w	currentchannel(a5),d0
	rts


get_channelblock_win	; d0.l = channelwindow
			; returns: a0 = ^channelblock from a window
			;          d0.w = channel number

	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	add.l	d0,d0
	move.w	(a0,d0.l),d0
	ELSE
	move.w	(a0,d0.l*2),d0
	ENDC

get_channelblock_chan	; d0.w = channel (1-16)
			; returns: a0 = ^channelblock from a channel

	lea	chanselect_channels-chan_sizeof(a5),a0
	move.l	d0,d1
	mulu	#chan_sizeof,d1
	adda.l	d1,a0
	rts




RefreshNums_2	; d0.l = channelwindow number (0-15)

	move.l	d0,d5

	bsr.s	get_channelblock_win
	move.l	d0,d6
	move.l	a0,a4


;=== Track-scroller updaten
	move.l	chan_displaytrack(a4),d0
	move.l	maxtracks(a5),d2
	move.l	chan_displayed_tracks(a4),d3
	moveq	#GD_tracksel,d1
	move.l	d5,d4
	bsr	SetScrollerInst



;=== update track-gadgets
	move.w	currentchannel(a5),d1
	move.l	d1,-(sp)
	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	move.l	d5,d0
	add.l	d0,d0
	move.w	(a0,d0.l),currentchannel(a5)
	ELSE
	move.w	(a0,d5.l*2),currentchannel(a5)
	ENDC

	move.l	chan_displayed_tracks(a4),d7
	subq.l	#1,d7
.refreshloop

	move.l	d7,d0
	add.l	chan_displaytrack(a4),d0
	jsr	CalcTrackStringNumberJ(a5)

;=== Flag fr den Track holen (on/off)
	move.l	chan_displaytrack(a4),d0
	add.l	d7,d0
	jsr	GetTrackJ(a5)
	beq.s	.empty

	tst.b	tr_onoff(a0)
	bne.s	.on

	moveq	#text_muted_pen,d0		; track inactive, filled
	bra.s	.set

.on	moveq	#text_active_pen,d0		; track active, filled
	bra.s	.set

.empty	moveq	#text_empty_pen,d0		; track empty

.set	move.l	trackStringD(a5),a0
	moveq	#GD_track0,d1
	add.w	d7,d1
	move.l	d5,d4
	bsr	SetTextInst

	dbf	d7,.refreshloop

	move.l	(sp)+,d1
	move.w	d1,currentchannel(a5)

	rts





RefreshCSMode_2	; d0.l = channelwindow number

	move.l	d0,d4

	bsr	get_channelblock_win
	move.l	d0,d6
	move.l	a0,a4

	jsr	build_cs_gadgetJ(a5)

	move.w	chan_pgfx_active(a4),d0
	bne.s	.noPB

	move.l	d6,d0
	jsr	GetAnyChannelJ(a5)
	beq.s	.empty

;=== Pitchbend
	tst.l	ch_pbtrack(a0)
	beq.s	.empty
	tst.b	ch_pb_onoff(a0)
	bne.s	.on

.muted	moveq	#text_muted_pen,d0
	bra.s	.set
.on	moveq	#text_active_pen,d0
	bra.s	.set

.empty	moveq	#text_empty_pen,d0
.set	move.l	csStringD(a5),a0
	moveq	#GD_cstrack,d1
	bra	SetTextInst


.noPB	subq.w	#1,d0
;	bne.s	.noMP

;=== Mono Pressure
;	tst.l	ch_mptrack(a0)
;	beq.s	.empty
;	tst.b	ch_mp_onoff(a0)
;	beq.s	.muted
;	bra.s	.on


;.noMP
;=== Controlsource
	jsr	GetCSourceTrackJ(a5)
	beq.s	.empty

	tst.b	cs_onoff(a0)
	beq.s	.muted
	bra.s	.on





RefreshBPMtrack_2	; d0 = channelwindow

	move.l	d0,d4

	jsr	GetBPMTrackJ(a5)
	beq.s	.empty
	moveq	#text_active_pen,d0
	bra.s	.cont
.empty	moveq	#text_empty_pen,d0

.cont	move.l	bpmtrackStringD(a5),a0
	moveq	#GD_bpmtrack,d1
	bra	SetTextInst





RefreshPresettrack_2

	move.l	d0,d4

	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	add.l	d0,d0
	move.w	(a0,d0.l),d0
	ELSE
	move.w	(a0,d0.l*2),d0
	ENDC
	jsr	GetAnyChannelJ(a5)
	beq.s	.empty

	tst.l	ch_ptrack(a0)
	beq.s	.empty

	moveq	#text_active_pen,d0
	bra.s	.cont
.empty	moveq	#text_empty_pen,d0

.cont	move.l	preStringD(a5),a0
	moveq	#GD_pre,d1
	bra	SetTextInst




channelstate_gadget
	jsr	GetCheckboxInstJ(a5)
	move.l	d0,d2

	jsr	GetChannelJ(a5)
	beq.s	.rts

	tst.b	d2
	seq	ch_onoff(a0)

	jmp	score_refreshJ(a5)

.rts	rts





;===================================================================

		rsreset
GD_pattscroller		rs.b	1
GD_pos			rs.b	1
GD_bpmtrack		rs.b	1
GD_pre			rs.b	1
GD_cstrack		rs.b	1
GD_velorpp		rs.b	1
GD_src			rs.b	1
GD_tracksel		rs.b	1
GD_pattnumber		rs.b	1
GD_channelstate		rs.b	1

GD_track0		rs.b	1
GD_track1		rs.b	1
GD_track2		rs.b	1
GD_track3		rs.b	1
GD_track4		rs.b	1
GD_track5		rs.b	1
GD_track6		rs.b	1
GD_track7		rs.b	1
GD_track8		rs.b	1
GD_track9		rs.b	1
GD_track10		rs.b	1
GD_track11		rs.b	1

MTinst_CNT		rs.b	1




	IFNE	max_displayed_tracks-(MTinst_CNT-GD_track0)
	PRINTT	"<max_displayed_tracks> stimmt nicht berein"
	PRINTT	"Bitte ndern:"
	PRINTT	"  - GD_track#?"
	PRINTT	"  - Anzahl der Aufrufe des Macros TRACK_NGAD"
	PRINTT	"  - mousebuttons-Jumptable"
	FAIL
	ENDC




TRACK_NGAD MACRO
 NEWGAD	tracksgad_x+tracksgad_d*\1-1,tdgadgets2_y,tracksgad_d-tdgads_pad+2,tdgadgets_dy,*,-1,GD_track\1,$0000
	ENDM


MTinstNGads

;=== Pattern Scroller
; y-size is calculated
 NEWGAD	posscroller+3,tdbegin_y,25,99,*,-1,GD_pattscroller,$0000

 NEWGAD	posgad_x,tdgadgets2_y,bpmgad_x-posgad_x-tdgads_pad,tdgadgets_dy,*,-1,GD_pos,$0000
 NEWGAD	bpmgad_x,tdgadgets2_y,presetgad_x-bpmgad_x-tdgads_pad-2,tdgadgets_dy,*,-1,GD_bpmtrack,$0000
 NEWGAD	presetgad_x-2,tdgadgets2_y,csgad_x-presetgad_x-tdgads_pad+2,tdgadgets_dy,*,-1,GD_Pre,$0000
 NEWGAD	csgad_x-2,tdgadgets2_y,tracksgad_x-csgad_x-tdgads_pad+2,tdgadgets_dy,*,-1,GD_cstrack,$0000

;=== velocity or ppress
 NEWGAD	tracksgad_x+tracksgad_d*4,tdgadgets1_y,tracksgad_d*2-tdgads_pad,tdgadgets_dy,*,-1,GD_velorpp,$0002

;=== "Src" gadget (cycle controlsources)
 NEWGAD	csgad_x,tdgadgets1_y,tracksgad_x-csgad_x-tdgads_pad,tdgadgets_dy,srcText,-1,GD_src,$0010

;=== track selector scroller
 NEWGAD	tracksgad_x,tdgadgets1_y,tracksgad_d*4,tdgadgets_dy,*,-1,GD_tracksel,$0000

;=== extra pattern number
 NEWGAD	posscroller,tdgadgets2_y,tdgadgets2_x-posscroller-tdgads_pad,tdgadgets_dy,*,-1,GD_pattnumber,$0000

; channel state (on or off)
 NEWGAD	posscroller,tdgadgets1_y-1,26,13,*,-1,GD_channelstate,$0000


;=== Track-columns

 TRACK_NGAD 0
 TRACK_NGAD 1
 TRACK_NGAD 2
 TRACK_NGAD 3
 TRACK_NGAD 4
 TRACK_NGAD 5
 TRACK_NGAD 6
 TRACK_NGAD 7
 TRACK_NGAD 8
 TRACK_NGAD 9
 TRACK_NGAD 10
 TRACK_NGAD 11





MTinstGTags
MTinstGTscrolltop = *+4-MTinstGTags
	DC.L	$80080015,0
MTinstGTscrolltotal = *+4-MTinstGTags
	DC.L	$80080016,64+8
	DC.L	$80080017,9
	DC.L	$8008003B,12		; arrow size
	DC.L	$80031001,$00000002
	DC.L	$80030016,1
	DC.L	$00000000
	DC.L	$8008000B,posgadtext
	DC.L	$80080039,1
	dc.l	$80080000+74,1
	DC.L	$00000000
	DC.L	$8008000B,bpmtrackString
	DC.L	$80080039,1
	DC.L	$00000000
	DC.L	$8008000B,PreString
	DC.L	$80080039,1
	DC.L	$00000000
	DC.L	$8008000B,CSString
	DC.L	$80080039,1
	DC.L	$00000000

	DC.L	$8008000e,velorppLabels
MTinstGTvelorpp = *+7-MTinstGTags
	DC.L	$8008000f,0
	DC.L	$00000000

	DC.L	$00000000		; "src" gadget

MTinstGTmaxtr = *+4-MTinstGTags
	DC.L	$80080016,24
	DC.L	$80080017,displayed_tracks
	DC.L	$8008003B,18
	DC.L	$80031001,$00000001
	DC.L	$80030016,1
	DC.L	$00000000

MTinstGTpattnum = *+4-MTinstGTags
	DC.L	$8008000d,0
	DC.L	$8008003a,1		; border
	dc.l	$80080000+74,1		; right
	dc.l	$80080000+77,1		; GTBB_FrameType
	DC.L	$00000000

;MTinstGTstate = *+7-MTinstGTags
;	DC.L	$80080004,1
	DC.L	$00000000

	REPT	max_displayed_tracks
	DC.L	$8008000B,trackString
;	dc.l	$8008000c,1		; GTTX_CopyText
	DC.L	$80080039,1
	DC.L	$00000000
	ENDR





velorppLabels
	dc.w	1,loc_metroveloc

	dc.w	-1
	dr.w	velorppLab1

	dc.l	0




MTinstGTypes	DC.b	9,13,13,13,13,7,1,9,6,0
		dcb.b	max_displayed_tracks,13



velorppLab1		dc.b	'PPress',0

csstring		DC.B	'ModW',0
prestring		DC.B	'Bnk.Pre',0
bpmtrackString		DC.B	'Tempo',0
trackString		DC.B	'Trk 1',0
srcText			dc.b	'Src',0

			even




MTinstWindowTags
	DC.L	$80000064,0
	DC.L	$80000065,0
	DC.L	$80000066,0
	DC.L	$80000067,0

	dc.l	$80000072				; minwidth
	dc.l	tracksgad_x+tracksgad_d*min_displayed_tracks+2*5+16
MTinstWTminheight = *+6-MTinstWindowTags
	dc.l	$80000073				; minheight
	dc.l	0		; this value is calculated
	dc.l	$80000074				; maxwidth
	dc.l	tracksgad_x+tracksgad_d*max_displayed_tracks+2*5+16
MTinstWTmaxheight = *+6-MTinstWindowTags
	dc.l	$80000075				; maxheight
	dc.l	0		; this value is calculated

	DC.L	$8000006B,instWFlags
MTinstWG = *+4-MTinstWindowTags
	DC.L	$8000006C,0
MTinstWT = *+4-MTinstWindowTags
	DC.L	$8000006E,0
MTinstST = *+4-MTinstWindowTags
	DC.L	$8000006F,0
MTinstSC = *+4-MTinstWindowTags
	DC.L	$80000079,0
	DC.L	$80000090,1
MTinstHG = *+4-MTinstWindowTags
	dc.l	$8000009b,0		; Help Group (V39)
	DC.L	$00000000


