;APS00000000000000000000000000000000000000000000000000000000000000000000000000000000

;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;
;
;
;
;                B L O C K    -    M e n 
;
;
;
;
;
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================



;==============================================================
;
;  Block Spread
;
;==============================================================

block_spread
	tst.b	blockmarked(a5)
	beq	noblockmarked

	move.b	blockmarktype(a5),d0
	cmp.b	#-2,d0			; Presettrack ?
	beq.s	.notsuit
	cmp.b	#1,d0			; channel ?
	beq.s	.notsuit

	bra.s	.spread_linear

.notsuit
	bsr	notsuitable
	bra	block_unmark

.rts	rts



;===  Linear Spread

.spread_linear	; d0=blockmarktype

	move.l	blockstop(a5),d4
	sub.l	blockstart(a5),d4
	beq	larger_block
	subq.l	#1,d4
	beq	larger_block
	addq.l	#1,d4

	tst.b	d0
	beq	.spread_track
	addq.b	#1,d0
	beq.s	.spread_csource


;=== BPM Track
;.BPM
	jsr	GetBPMTrackJ(a5)
	beq	nobeginvalue
	move.w	#BPM_stay,d0
	bsr	get_values_2b
	beq	nobeginvalue

	jsr	check_state_beforeJ(a5)

;	st	bpmtrackchanged(a5)
	jsr	GetBPMTrackJ(a5)
	beq	nobeginvalue
	bsr	block_spread_2b

	jsr	recalc_bpmJ(a5)

	bra.s	.okay




.spread_csource	; d4=blockrange

	jsr	check_state_beforeJ(a5)

	bsr	spread_csource
	beq	nobeginvalue

.okay
	st	songchanged(a5)

	bsr	blockrefresh_track

	move.w	#loc_b_spread,d0
	jmp	status_displayJ(a5)




.spread_track
	tst.b	vel_or_pp(a5)
	beq.s	.velocity

	move.b	#PP_stay,d6
	moveq	#wd_pp,d5
	bra.s	.ppcont

.velocity
	move.b	#Vel_clear,d6
	moveq	#wd_vel,d5
.ppcont

	move.l	blocktrack(a5),d0
	jsr	GetTrackDataJ(a5)
	beq	nobeginvalue
	bsr	get_values_vel
	beq	nobeginvalue

	jsr	check_state_beforeJ(a5)

	move.l	blocktrack(a5),d0
	jsr	GetTrackDataJ(a5)
	beq	nobeginvalue
;	move.l	trackchanged(a5),a1
;	st	(a1,d0.w)
	bsr.s	.spread_vel
	bra.s	.okay




.spread_vel	; a0=worktrack, d2=startwert, d3=endwert,
		; d4=blockrange, d5.l=wd-offset to velocity or ppress

	move.l	d5,a3

	move.l	blockstart(a5),d0
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	lsl.l	#2,d0
	lsl.l	#2,d1
	lea	wd_sizeof(a0,d0.l),a2
	lea	(a0,d1.l),a1
	ELSE
	lea	wd_sizeof(a0,d0.l*4),a2
	lea	(a0,d1.l*4),a1
	ENDC
	move.b	d2,-wd_sizeof(a2,a3.l)
	move.b	d3,(a1,a3.l)

;=== Vorberechnung der Parameter
	ext.w	d2
	ext.w	d3
	moveq	#1,d7
	sub.w	d2,d3
	bpl.s	.plus4B
	neg.w	d3
	neg.w	d7
.plus4B

	move.w	d3,d6
	ext.l	d3
	divs	d4,d3
	bne.s	.over4B
	move.w	d4,d6
.over4B	move.w	d3,d5		; wird immer dazuaddiert
	swap	d3
	tst.w	d7
	bpl.s	.pos4B
	neg.w	d5
.pos4B

;=== Berechnungsschleife
	moveq	#0,d0
.spread4B
	add.w	d5,d2
	add.w	d3,d0
	cmp.w	d6,d0
	bmi.s	.noa4B
	sub.w	d6,d0
	add.w	d7,d2
.noa4B	cmpa.w	#wd_vel,a3
	bne.s	.novel
	tst.b	wd_pitch(a2)
	beq.s	.skip
.novel	move.b	d2,(a2,a3.l)
.skip	addq.w	#wd_sizeof,a2
	cmpa.l	a1,a2
	bcs.s	.spread4B
	rts




block_spread_1b	; a0=worktrack, d2.b=startwert, d3.b=endwert,
		; d4=blockrange (stop-start)

	move.l	a0,a2
	adda.l	blockstart(a5),a2
	move.b	d2,(a2)+
	move.l	a0,a1
	adda.l	blockstop(a5),a1
	move.b	d3,(a1)

;=== Vorberechnung der Parameter
	ext.w	d2
	ext.w	d3
	moveq	#1,d7
	sub.w	d2,d3
	bpl.s	.plusMP
	neg.w	d3
	neg.w	d7
.plusMP

	move.w	d3,d6
	ext.l	d3
	divs	d4,d3
	bne.s	.overMP
	move.w	d4,d6
.overMP	move.w	d3,d5
	swap	d3
	tst.w	d7
	bpl.s	.posMP
	neg.w	d5
.posMP

;=== Berechnungsschleife
	moveq	#0,d0
.spreadMP
	add.w	d5,d2
	add.w	d3,d0
	cmp.w	d6,d0
	bmi.s	.noaMP
	sub.w	d6,d0
	add.w	d7,d2
.noaMP	move.b	d2,(a2)+
	cmpa.l	a1,a2
	bcs.s	.spreadMP
	rts





block_spread_2b	; a0=worktrack, d2=startwert, d3=endwert,
		; d4=blockrange

	move.l	blockstart(a5),d0
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	add.l	d0,d0
	add.l	d1,d1
	lea	(a0,d0.l),a2
	lea	(a0,d1.l),a1
	ELSE
	lea	(a0,d0.l*2),a2
	lea	(a0,d1.l*2),a1
	ENDC
	move.w	d2,(a2)+
	move.w	d3,(a1)

;=== Vorberechnung der Parameter
	moveq	#1,d7
	sub.w	d2,d3
	bpl.s	.plusPB
	neg.w	d3
	neg.w	d7
.plusPB

	move.w	d3,d6
	ext.l	d3
	divs	d4,d3
	bne.s	.overPB
	move.w	d4,d6
.overPB	move.w	d3,d5		; wird immer dazuaddiert
	swap	d3
	tst.w	d7
	bpl.s	.posPB
	neg.w	d5
.posPB

;=== Berechnungsschleife
	moveq	#0,d0
.spreadPB
	add.w	d5,d2
	add.w	d3,d0
	cmp.w	d6,d0
	bmi.s	.noaPB
	sub.w	d6,d0
	add.w	d7,d2
.noaPB	move.w	d2,(a2)+
	cmpa.l	a1,a2
	bcs.s	.spreadPB
	rts






get_values_vel	; a0=^Worktrack, d6=stay-value, d5=velocity or ppress offset
		; returns: d0=pos/neg, d2=startwert, d3=endwert

	move.l	blockstart(a5),d1
	IFEQ	mc68020
	lsl.l	#2,d1
	lea	(a0,d1.l),a1
	ELSE
	lea	(a0,d1.l*4),a1
	ENDC
.pre4B1	move.b	(a1,d5.w),d2			; Startwert
	cmp.b	d6,d2
	bne.s	.gotit4B1
	subq.w	#wd_sizeof,a1
	cmpa.l	a0,a1
	bcc.s	.pre4B1
	bra.s	.neg4b
.gotit4B1

;== Endwert herausfinden
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	lsl.l	#2,d1
	lea	(a0,d1.l),a1
	ELSE
	lea	(a0,d1.l*4),a1
	ENDC
.pre4B2	move.b	(a1,d5.w),d3			; Endwert
	cmp.b	d6,d3
	bne.s	.gotit4B2
	subq.w	#wd_sizeof,a1
	cmpa.l	a0,a1
	bcc.s	.pre4B2
.neg4b	NEGATIV
.gotit4B2
	POSITIV








get_values_2b	; a0=^Worktrack, d0=stay
		; zurck: d0=pos/neg, d2=startwert, d3=endwert

	move.l	blockstart(a5),d1
	IFEQ	mc68020
	add.l	d1,d1
	lea	(a0,d1.l),a1
	ELSE
	lea	(a0,d1.l*2),a1
	ENDC
.pre1PB	move.w	(a1),d2			; Startwert
	cmp.w	d0,d2
	bne.s	.gotit1PB
	subq.w	#2,a1
	cmpa.l	a0,a1
	bcc.s	.pre1PB
	bra.s	.neg2b
.gotit1PB

;== Endwert herausfinden
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	add.l	d1,d1
	lea	(a0,d1.l),a1
	ELSE
	lea	(a0,d1.l*2),a1
	ENDC
.pre2PB	move.w	(a1),d3			; Endwert
	cmp.w	d0,d3
	bne.s	.gotit2PB
	subq.w	#2,a1
	cmpa.l	a0,a1
	bcc.s	.pre2PB
.neg2b	NEGATIV
.gotit2PB
	POSITIV







get_values_1b	; a0=^Worktrack, d0=stay
		; zurck: d0=pos/neg, d2=startwert, d3=endwert

	move.l	blockstart(a5),a1
	adda.l	a0,a1
.pre1CS	move.b	(a1),d2			; Startwert
	cmp.b	d0,d2
	bne.s	.gotit1CS
	subq.w	#1,a1
	cmpa.l	a0,a1
	bcc.s	.pre1CS
	bra.s	.neg
.gotit1CS

;== Endwert herausfinden
	move.l	blockstop(a5),a1
	adda.l	a0,a1
.pre2CS	move.b	(a1),d3			; Endwert
	cmp.b	d0,d3
	bne.s	.gotit2CS
	subq.w	#1,a1
	cmpa.l	a0,a1
	bcc.s	.pre2CS
.neg	NEGATIV
.gotit2CS
	POSITIV







;=== This routine is also called from pgfx.s for drawing lines.

spread_csource	; d4=blockrange

	move.w	pgfx_active(a5),d0
	beq.s	.PB
	subq.w	#1,d0
;	beq.s	.MP


;=== Controlsource
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.nega
	move.b	#CS_stay,d0
	bsr	get_values_1b
	beq.s	.nega

	move.w	pgfx_active(a5),d0
	subq.w	#1,d0
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.nega
;	move.l	ctrackchanged(a5),a1
;	st	(a1,d0.w)			; d0 is from GetCurrentCSTrack()
	st	songchanged(a5)
	bsr	block_spread_1b

	move.w	pgfx_active(a5),d0
	subq.w	#1,d0
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.nega
	jsr	recalc_csourceJ(a5)
	bra.s	.posi


.PB
;=== Pitchbend
	jsr	GetPibeTrackJ(a5)
	beq.s	.nega
	move.w	#PB_stay,d0
	bsr	get_values_2b
	beq.s	.nega

;	st	pbtrackchanged(a5)
	st	songchanged(a5)
	jsr	GetPibeTrackJ(a5)
	beq.s	.nega
	bsr	block_spread_2b
	jsr	recalc_pitchbendJ(a5)

.posi	POSITIV
.nega	NEGATIV



;=== MPress
;.MP
;	move.l	mpworktrack(a5),a0
;	move.b	#CS_stay,d0
;	bsr	get_values_1b
;	beq.s	.nega

;	st	mptrackchanged(a5)
;	st	songchanged(a5)
;	move.l	mpworktrack(a5),a0
;	bsr	block_spread_1b
;	jsr	recalc_mpressJ(a5)
;	bra.s	.posi






nobeginvalue
	move.w	#loc_nobegin,d0
	move.w	#loc_oh,d1
	jmp	EZrequestJ(a5)




larger_block
	move.w	#loc_notspread,d0
	move.w	#loc_copythat,d1
	jmp	EZrequestJ(a5)



notsuitable
	move.w	#loc_notcstrack,d0
	move.w	#loc_forgiveme,d1
	jmp	EZrequestJ(a5)



noblockmarked
	move.w	#loc_noblock,d0
	move.w	#loc_copythat,d1
	jmp	EZrequestJ(a5)




;==============================================================
;
;  Block MARK (Channel)
;
;==============================================================

block_mark_channel
	tst.b	blockmarked(a5)
	bne.s	block_unmark

	move.b	#1,blockmarktype(a5)
	bra.s	block_mark


.rts	rts






;==============================================================
;
;  Block MARK (Track)
;
;==============================================================

block_mark_track
	tst.b	shiftpressed(a5)
	bne.s	block_mark_channel

;	tst.b	playflag(a5)
;	bne.s	.rts
;	tst.l	active_channelwindow(a5)
;	bmi.s	.rts

	tst.b	blockmarked(a5)
	bne.s	block_unmark

	tst.b	editmode(a5)
	beq	edit_noeditmode

	move.l	currenttrack(a5),d0
	bmi.s	.notrack
	move.l	d0,blocktrack(a5)
	clr.b	blockmarktype(a5)
	bra.s	.bcont
.notrack
	move.b	d0,blockmarktype(a5)
.bcont
	bra.s	block_mark


.rts	rts





block_mark
;=== Blockanfang markieren
	st	blockmarked(a5)

	move.l	eventpos(a5),d0
	move.l	d0,blockstart(a5)
	move.l	d0,blockstop(a5)
	move.l	d0,blockfirst(a5)

	bsr.s	RefreshBlock
	jmp	RedrawPatternJ(a5)



block_unmark
	tst.b	blockmarked(a5)
	beq.s	.notmarked
	bsr.s	block_unmark_title
	jmp	RedrawPatternOhneScrJ(a5)

.notmarked
	rts



block_unmark_title
	sf	blockmarked(a5)
	move.l	active_channelwindow(a5),d0
	bra.s	RedrawBlock



RefreshBlock
	move.l	active_channelwindow(a5),d0

RefreshBlock_cwin	; d0 = channelwindow

	move.l	d0,d4
	jsr	get_current_channelblockJ(a5)

	tst.b	chan_blockmarked(a0)
	beq.s	.notmarked

	move.l	chan_eventpos(a0),d0
	move.l	chan_blockstart(a0),d1
	move.l	chan_blockstop(a0),d2
	cmp.l	chan_blockfirst(a0),d2
	beq.s	.stopisfirst

;=== Blockstart = ursprnglicher Start
	cmp.l	d1,d0
	bcc.s	.okay2
	exg	d1,d0
.okay2	move.l	d1,chan_blockstart(a0)
	move.l	d0,chan_blockstop(a0)
	bra.s	.draw

;=== Blockstop = ursprnglicher Start
.stopisfirst
	cmp.l	d0,d2
	bcc.s	.okay1
	exg	d0,d2
.okay1	move.l	d0,chan_blockstart(a0)
	move.l	d2,chan_blockstop(a0)

.draw	move.l	d4,d0
	bra.s	RedrawBlock

.notmarked
	rts


;=== Blockanzeige im Main-windowtitle und im Pattern refreshen

RedrawBlock	; d0 = channelwindow
	move.l	d0,-(sp)
	bsr.s	RecalcBlock
	move.l	(sp)+,d0
	jmp	set_wdtitle_instJ(a5)



RecalcBlock	; d0 = channelwindow (0-15)

	move.l	d0,d3
	bmi.s	.nowin
	jsr	get_channelblock_winJ(a5)
	move.l	a0,a3
;	move.w	chan_blockpos(a0),d2
	move.l	d3,d0
	jsr	get_inst_wdtitleJ(a5)
	lea	blockrange_offset(a1),a0

	tst.b	chan_blockmarked(a3)
	bne.s	.marked

	moveq	#' ',d0
	REPT	9
	move.b	d0,(a0)+
	ENDR

	bra.s	.back

.marked

	move.l	a0,a2
	lea	chanselect_mappings(a5),a0
	IFEQ	mc68020
	add.l	d3,d3
	move.w	(a0,d3.l),d7
	ELSE
	move.w	(a0,d3.l*2),d7
	ENDC
	beq.s	.nowin
	move.w	d7,d0
	jsr	GetAnyChannelResolutionJ(a5)
	move.l	d0,d6
	move.l	a2,a0

	move.l	chan_blockstart(a3),d0
	divu	d6,d0
	ext.l	d0
	moveq	#3,d1
	jsr	decout_noleadJ(a5)

	move.b	#'-',(a0)+

	move.l	chan_blockstop(a3),d0
	divu	d6,d0
	ext.l	d0
	moveq	#3,d1
	jsr	decout_ljustifiedJ(a5)

.back
.nowin	rts





;==============================================================
;
;  Block Randomize
;
;==============================================================

block_random
;	tst.b	playflag(a5)
;	bne.s	.rts
;	tst.l	active_channelwindow(a5)
;	bmi.s	.rts

	tst.b	blockmarked(a5)
	beq	noblockmarked

	move.b	blockmarktype(a5),d0
	cmp.b	#-2,d0			; Presettrack ?
	beq.s	.notsuit
	cmp.b	#1,d0			; channel ?
	beq.s	.notsuit

	bra.s	.randomize

.notsuit
	bsr	notsuitable
	bra	block_unmark

.rts	rts



.randomize	; d0=blockmarktype

	move.l	blockstop(a5),d4
	sub.l	blockstart(a5),d4
	beq	larger_block
	subq.l	#1,d4
	beq	larger_block
;	addq.l	#1,d4

	tst.b	d0
	beq	.random_track
	addq.b	#1,d0
	beq	.random_csource


.BPM
;=== BPM Track
	jsr	GetBPMTrackJ(a5)
	beq	nobeginvalue
	move.w	#BPM_stay,d0
	bsr	get_values_2b
	beq	nobeginvalue

	jsr	check_state_beforeJ(a5)

;	st	bpmtrackchanged(a5)
	st	songchanged(a5)
	jsr	GetBPMTrackJ(a5)
	beq	nobeginvalue
	bsr	.random_2b
	bra.s	.out




.random_csource

	move.w	pgfx_active(a5),d0
	beq.s	.PB
	subq.w	#1,d0
;	beq.s	.MP


;=== Controlsource
	jsr	GetCSourceTrackDataJ(a5)
	beq	nobeginvalue
	move.b	#CS_stay,d0
	bsr	get_values_1b
	beq	nobeginvalue

	jsr	check_state_beforeJ(a5)

	move.w	pgfx_active(a5),d0
	subq.w	#1,d0
	jsr	GetCSourceTrackDataJ(a5)
	beq	nobeginvalue
;	move.l	ctrackchanged(a5),a1
;	st	(a1,d0.w)			; d0 is from GetCurrentCSTrack()
	st	songchanged(a5)
	bsr	.random_1b

	bra.s	.out


.PB
;=== Pitchbend
	jsr	GetPibeTrackJ(a5)
	beq	nobeginvalue
	move.w	#PB_stay,d0
	bsr	get_values_2b
	beq	nobeginvalue

	jsr	check_state_beforeJ(a5)

;	st	pbtrackchanged(a5)
	st	songchanged(a5)
	jsr	GetPibeTrackJ(a5)
	beq	nobeginvalue
	bsr	.random_2b

.out
	bsr	blockrefresh_track

	move.w	#loc_b_random,d0
	jmp	status_displayJ(a5)




;=== MPress
;.MP
;	move.l	mpworktrack(a5),a0
;	move.b	#CS_stay,d0
;	bsr	get_values_1b
;	beq.s	.nega

;	st	mptrackchanged(a5)
;	st	songchanged(a5)
;	move.l	mpworktrack(a5),a0
;	bsr	.random_1b
;	bra.s	.out





.random_track
	tst.b	vel_or_pp(a5)
	beq.s	.velocity

	move.b	#PP_stay,d6
	moveq	#wd_pp,d5
	bra.s	.ppcont

.velocity
	move.b	#Vel_clear,d6
	moveq	#wd_vel,d5
.ppcont

	move.l	blocktrack(a5),d0
	jsr	GetTrackDataJ(a5)
	beq	nobeginvalue
	bsr	get_values_vel
	beq	nobeginvalue

	jsr	check_state_beforeJ(a5)

	move.l	blocktrack(a5),d0
	jsr	GetTrackDataJ(a5)
	beq	nobeginvalue
;	move.l	trackchanged(a5),a1
;	st	(a1,d0.w)
	bsr.s	.random_vel
	st	songchanged(a5)
	bra	.out




.random_vel	; a0=worktrack, d2=startwert, d3=endwert,
		; d5.l=wd-offset to velocity or ppress

	move.l	d5,a3

	move.l	blockstart(a5),d0
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	lsl.l	#2,d0
	lea	(a0,d0.l),a2
	lsl.l	#2,d1
	lea	(a0,d1.l),a1
	ELSE
	lea	(a0,d0.l*4),a2
	lea	(a0,d1.l*4),a1
	ENDC

	jsr	GetChannelResolutionJ(a5)
	move.l	d0,d4
	lsl.l	#2,d4

;=== make sure d2 <= d3
	cmp.b	d2,d3
	bcc.s	.leave4b
	exg	d2,d3
.leave4b

.rndloop_4b
	bsr	.get_byte
	and.b	#$7f,d0

.retry4	cmp.b	d2,d0
	bcs.s	.under4
	cmp.b	d3,d0
	bls.s	.ok4

	sub.b	d3,d0
	add.b	d2,d0
	subq.b	#1,d0
	bra.s	.retry4

.under4	add.b	d3,d0
	sub.b	d2,d0
	addq.b	#1,d0
	bra.s	.retry4

.ok4	cmpa.w	#wd_vel,a3
	bne.s	.novel
	tst.b	wd_pitch(a2)
	beq.s	.skip
.novel	move.b	d0,(a2,a3.l)
.skip	adda.l	d4,a2
	cmpa.l	a1,a2
	bls.s	.rndloop_4b
	rts




.random_2b	; a0=worktrack, d2=startwert, d3=endwert

	move.l	blockstart(a5),d0
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	add.l	d0,d0
	add.l	d1,d1
	lea	(a0,d0.l),a2
	lea	(a0,d1.l),a1
	ELSE
	lea	(a0,d0.l*2),a2
	lea	(a0,d1.l*2),a1
	ENDC

	jsr	GetChannelResolutionJ(a5)
	move.l	d0,d4
	add.l	d4,d4

;=== make sure d2 <= d3
	cmp.w	d2,d3
	bcc.s	.leave2b
	exg	d2,d3
.leave2b

.rndloop_2b
	bsr.s	.get_byte
	lsl.w	#8,d0
	bsr.s	.get_byte
	and.w	#$3fff,d0

.retry2	cmp.w	d2,d0
	bcs.s	.under2
	cmp.w	d3,d0
	bls.s	.ok2

	sub.w	d3,d0
	add.w	d2,d0
	subq.w	#1,d0
	bra.s	.retry2

.under2	add.w	d3,d0
	sub.w	d2,d0
	addq.w	#1,d0
	bra.s	.retry2

.ok2	move.w	d0,(a2)
	adda.l	d4,a2
	cmpa.l	a1,a2
	bls.s	.rndloop_2b
	rts


.get_byte
	move.b	$dff007,d0
	move.b	$bfd800,d1
	ror.b	d0,d1
	add.b	d1,d5
	ror.b	d1,d5
	add.b	d5,d0
	add.b	d4,d0
	rts


.random_1b	; a0=worktrack, d2.b=startwert, d3.b=endwert

	move.l	a0,a2
	adda.l	blockstart(a5),a2
	move.l	a0,a1
	adda.l	blockstop(a5),a1

	jsr	GetChannelResolutionJ(a5)
	move.l	d0,d4

;=== make sure d2 <= d3
	cmp.b	d2,d3
	bcc.s	.leave1b
	exg	d2,d3
.leave1b

.rndloop_1b
	bsr.s	.get_byte
	and.b	#$7f,d0

.retry1	cmp.b	d2,d0
	bcs.s	.under1
	cmp.b	d3,d0
	bls.s	.ok1

	sub.b	d3,d0
	add.b	d2,d0
	subq.b	#1,d0
	bra.s	.retry1

.under1	add.b	d3,d0
	sub.b	d2,d0
	addq.b	#1,d0
	bra.s	.retry1

.ok1	move.b	d0,(a2)
	adda.l	d4,a2
	cmpa.l	a1,a2
	bls.s	.rndloop_1b
	rts






;==============================================================
;
;  Block CUT
;
;==============================================================

block_cut
;	tst.b	playflag(a5)
;	bne.s	.rts
	tst.b	blockmarked(a5)
	beq	noblockmarked

	tst.b	cuttobuf(a5)
	beq.s	.nocopy
	bsr	blockcopy_routine
	beq.s	.rts

.nocopy
	st	songchanged(a5)

	jsr	check_state_beforeJ(a5)

	move.b	blockmarktype(a5),d0
	beq	.cut_track
	bpl	.cut_channel
	addq.b	#1,d0
	beq.s	.cut_csource
	addq.b	#1,d0
	bne.s	.cut_bpmtrack

;=== cut preset track
	bsr.s	.cut_Pre
	bra.s	.out
.cut_Pre
;	st	ptrackchanged(a5)
	jsr	GetPresetTrackJ(a5)
	beq.s	.rts
	move.w	#Preset_stay,d2
	bra	.cut_block_2b


.rts	rts


.cut_bpmtrack
	bsr.s	.cut_BPM
	bra.s	.out
.cut_BPM
;	st	bpmtrackchanged(a5)
	jsr	GetBPMTrackJ(a5)
	beq.s	.rts
	move.w	#BPM_stay,d2
	bra	.cut_block_2b



.Cut_csource
	move.w	pgfx_active(a5),d0
	beq.s	.PB
	subq.w	#1,d0
;	beq.s	.MP

;=== Controlsource
;	move.l	ctrackchanged(a5),a0
;	st	-1(a0,d0.w)
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.rts
	move.b	#cs_stay,d2
	bsr.s	.cut_block_1b


.out
	bsr.s	.block_cut_status
	bra	blockrefresh_track


.block_cut_status
	move.l	blockstart(a5),eventpos(a5)

	move.w	#loc_b_cut,d0
	jmp	status_displayJ(a5)



;.MP
;=== Mono Press
;	bsr.s	.cut_mp
;	bra.s	.out
;.cut_MP
;	st	mptrackchanged(a5)
;	move.l	mpworktrack(a5),a0
;	move.b	#cs_stay,d2
;	bra.s	.cut_block_1b


.PB
;=== Pitchbend
	bsr.s	.cut_PB
	bra.s	.out
.cut_PB
;	st	pbtrackchanged(a5)
	jsr	GetPibeTrackJ(a5)
	beq.s	.rts
	move.w	#PB_stay,d2
	bra	.cut_block_2b




.cut_block_1b	; d2=stay-value, a0=^worktrack
	move.l	a0,-(sp)
	jsr	GetChannelResolutionJ(a5)
	move.l	(sp)+,a0

	move.l	events(a5),d1
	lea	(a0,d1.l),a2
	add.l	blockstop(a5),d0
	sub.l	d0,d1
	lea	(a0,d0.l),a1
	adda.l	blockstart(a5),a0
.copyCS	subq.l	#1,d1
	bcs.s	.outCS
	move.b	(a1)+,(a0)+
	bra.s	.copyCS
.outCS
.fillCS	move.b	d2,(a0)+
	cmpa.l	a2,a0
	bcs.s	.fillCS
	rts


.cut_block_2b	; d2=stay-value, a0=^worktrack
	move.l	a0,-(sp)
	jsr	GetChannelResolutionJ(a5)
	move.l	(sp)+,a0

	move.l	events(a5),d1
	add.l	d1,d1
	lea	(a0,d1.l),a2
	add.l	blockstop(a5),d0
	add.l	d0,d0
	sub.l	d0,d1
	lea	(a0,d0.l),a1
	move.l	blockstart(a5),d0
	add.l	d0,d0
	adda.l	d0,a0
.copyPB	subq.l	#2,d1
	bcs.s	.outPB
	move.w	(a1)+,(a0)+
	bra.s	.copyPB
.outPB
.fillPB	move.w	d2,(a0)+
	cmpa.l	a2,a0
	bcs.s	.fillPB
	rts


.cut_block_4b	; d2=stay-value, a0=^worktrack
	move.l	a0,-(sp)
	jsr	GetChannelResolutionJ(a5)
	move.l	(sp)+,a0

	move.l	events(a5),d1
	lsl.l	#2,d1
	lea	(a0,d1.l),a2
	add.l	blockstop(a5),d0
	lsl.l	#2,d0
	sub.l	d0,d1
	lea	(a0,d0.l),a1
	move.l	blockstart(a5),d0
	lsl.l	#2,d0
	adda.l	d0,a0
.copy4B	subq.l	#4,d1
	bcs.s	.out4B
	move.l	(a1)+,(a0)+
	bra.s	.copy4B
.out4B
.fill4B	move.l	d2,(a0)+
	cmpa.l	a2,a0
	bcs.s	.fill4B
	rts



.cut_track
	move.l	blocktrack(a5),d0
	bsr.s	.cut_track_routine
	bra	.out

.cut_track_routine	; d0=track
;	move.l	trackchanged(a5),a0
;	st	(a0,d0.w)
	jsr	GetTrackDataJ(a5)
	beq	.rts
	move.l	#track_def_entry,d2
	bra.s	.cut_block_4b



.cut_channel
;	bsr	.cut_MP
	bsr	.cut_PB
	bsr	.cut_Pre

;	move.l	trackchanged(a5),a3
	move.l	#track_def_entry,d2
	move.l	maxtracks_m1(a5),d7
.trackloop
;	st	(a3,d7.w)
	move.l	d7,d0
	jsr	GetTrackDataJ(a5)
	beq.s	.notrack
	bsr.s	.cut_block_4b
.notrack
	dbf	d7,.trackloop

;	move.l	ctrackchanged(a5),a3
	move.l	active_csources_m1(a5),d7
.csloop
;	st	(a3,d7.w)
	move.l	d7,d0
	jsr	GetCSourceTrackDataJ(a5)
	move.b	#cs_stay,d2
	bsr	.cut_block_1b
	dbf	d7,.csloop

	bsr	.block_cut_status
	bra	blockrefresh_channel








;==============================================================
;
;  Block COPY
;
;==============================================================

block_copy
;	tst.b	playflag(a5)
;	bne.s	.rts
	tst.b	blockmarked(a5)
	beq	noblockmarked

	bsr.s	blockcopy_routine
	beq.s	.rts

	move.w	#loc_b_copied,d0
	jsr	status_displayJ(a5)
	bra	block_unmark

.rts	rts


blockcopy_routine

	jsr	GetChannelResolutionJ(a5)
	move.l	blockstop(a5),d6
	sub.l	blockstart(a5),d6
	add.l	d0,d6

	move.b	blockmarktype(a5),d0
	beq	.copy_track
	bpl	.copy_channel
	addq.b	#1,d0
	beq.s	.copy_csource
	addq.b	#1,d0
	bne	.copy_bpmtrack


.copy_Pre
;=== preset track
	bsr	FreeBlockPre

	jsr	GetPresetTrackJ(a5)
	beq.s	.empty_pre
	move.l	a0,a2

	bsr	.alloc_2b
	beq.s	.nomem
	move.l	d0,a1
	move.l	a1,block_Pre_addr(a5)
	move.l	a2,a0
	bsr.s	.copy_2b
.empty_pre
	move.l	d6,block_Pre_events(a5)
	bra.s	.pos



.copy_csource
	move.w	pgfx_active(a5),d0
	beq	.copy_PB
	subq.w	#1,d0
;	beq	.copy_MP

;=== Controlsource
	move.l	d0,d2
	bsr	FreeBlockCS

	move.l	d2,d0
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.empty_cs
	move.l	a0,a2

	bsr.s	.alloc_1b
	beq.s	.nomem
	move.l	d0,a1
	move.l	a1,block_CS_addr(a5)
	move.l	a2,a0
	bsr.s	.copy_1b
.empty_cs
	move.l	d6,block_CS_events(a5)

.pos	POSITIV

.nomem	jsr	nomemoryJ(a5)
	NEGATIV





.copy_1b	; a0=^source, a1=^dest

	adda.l	blockstart(a5),a0
	move.l	d6,d1
.copyCS	move.b	(a0)+,(a1)+
	subq.l	#1,d1
	bne.s	.copyCS
	rts


.copy_2b
	move.l	blockstart(a5),d0
	add.l	d0,d0
	adda.l	d0,a0
	move.l	d6,d1
.copyPB	move.w	(a0)+,(a1)+
	subq.l	#1,d1
	bne.s	.copyPB
	rts


.alloc_1b
	move.l	d6,d0
.alloc	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	rts


.alloc_2b
	move.l	d6,d0
	add.l	d0,d0
	bra.s	.alloc


.alloc_4b
	move.l	d6,d0
	lsl.l	#2,d0
	bra.s	.alloc



;=== Pitchbend
.copy_PB
	bsr	FreeBlockPB

	jsr	GetPibeTrackJ(a5)
	beq.s	.empty_pb
	move.l	a0,a2

	bsr.s	.alloc_2b
	beq.s	.nomem
	move.l	d0,a1
	move.l	a1,block_PB_addr(a5)
	move.l	a2,a0
	bsr.s	.copy_2b
.empty_pb
	move.l	d6,block_PB_events(a5)
	bra	.pos



;=== MPress
;.copy_MP
;	bsr.s	.alloc_1b
;	beq	.nomem

;	move.l	d0,-(sp)
;	bsr	FreeBlockCS
;	move.l	(sp)+,a1
;	move.l	a1,block_CS_addr(a5)
;	move.l	mpworktrack(a5),a0
;	bsr	.copy_1b
;	move.l	d2,block_CS_events(a5)
;	bra	.pos



.copy_bpmtrack
	bsr	FreeBlockBPM

	jsr	GetBPMTrackJ(a5)
	beq.s	.empty_bpm
	move.l	a2,a0

	bsr.s	.alloc_2b
	beq	.nomem
	move.l	d0,a1
	move.l	a1,block_BPM_addr(a5)
	move.l	a2,a0
	bsr	.copy_2b
.empty_bpm
	move.l	d6,block_BPM_events(a5)
	bra	.pos




.copy_track
	bsr	FreeBlockTrack

	move.l	blocktrack(a5),d0
	jsr	GetTrackDataJ(a5)
	beq.s	.empty_trk
	move.l	a0,a2

	bsr.s	.alloc_4b
	beq	.nomem
	move.l	d0,a1
	move.l	a1,block_trk_addr(a5)
	move.l	a2,a0
	bsr.s	.copy_4b
.empty_trk
	move.l	d6,block_trk_events(a5)
	bra	.pos


.copy_4b
	move.l	blockstart(a5),d0
	lsl.l	#2,d0
	adda.l	d0,a0
	move.l	d6,d1
.copy4B	move.l	(a0)+,(a1)+
	subq.l	#1,d1
	bne.s	.copy4B
	rts




.copy_channel
	bsr	FreeBlockChan

	bsr	.copy_PB
	beq	.neg
;	bsr	.copy_MP
;	beq	.neg
	bsr	.copy_Pre
	beq	.neg



;=== copy controlsources

	move.l	active_csources(a5),d0
	mulu	d6,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,block_chcs_addr(a5)
	beq	.neg
	move.l	d0,a3

;	move.l	cworktracks(a5),a2
	lea	codetab(a5),a2
	lea	block_chcs_params(a5),a4
	move.l	active_csources_m1(a5),d7
.csourceloop
	move.b	(a2)+,d0
	move.b	d0,(a4)+
	jsr	GetCSourceTrackParameterDataJ(a5)
	beq.s	.empty_chcs
;	move.l	a0,a2

;	bsr	.alloc_1b
;	beq	.neg
;	move.l	d0,(a3)+
	move.l	a3,a1
;	move.l	a2,a0
	bsr	.copy_1b
	adda.l	d6,a3
	bra.s	.nextcs

.empty_chcs
	move.b	#CS_stay,d0
	move.l	d6,d1
.empty_csloop
	move.b	d0,(a3)+
	subq.l	#1,d1
	bne.s	.empty_csloop

.nextcs	dbf	d7,.csourceloop

	move.l	active_csources(a5),block_chcs_num(a5)



;=== copy note tracks

	move.l	maxtracks(a5),d0
	lsl.l	#2,d0			; = mulu #wd_sizeof,d0
	mulu	d6,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,block_chtrk_addr(a5)
	beq.s	.neg
	move.l	d0,a3

;	move.l	maxtracks(a5),d0
;	lsl.l	#2,d0
;	moveq	#1,d1
;	jsr	MyAllocVecJ(a5)
;	move.l	d0,block_chtrk_numbers(a5)
;	beq.s	.neg
;	move.l	d0,a4

	move.l	maxtracks(a5),block_chtrk_num(a5)

	moveq	#0,d7
.trackloop
;	move.l	d7,(a4)+
	move.l	d7,d0
	jsr	GetTrackDataJ(a5)
	beq.s	.empty_chtrk
;	move.l	a0,a2

;	bsr	.alloc_4b
;	beq	.neg
;	move.l	d0,(a3)+
	move.l	a3,a1
;	move.l	a2,a0
	bsr	.copy_4b
	move.l	d6,d0
	IFEQ	mc68020
	lsl.l	#2,d0
	adda.l	d0,a3
	ELSE
	lea	(a3,d0.l*4),a3
	ENDC
	bra.s	.nexttrk

.empty_chtrk
	move.l	#track_def_entry,d0
	move.l	d6,d1
.empty_trkloop
	move.l	d0,(a3)+
	subq.l	#1,d1
	bne.s	.empty_trkloop

.nexttrk
	addq.l	#1,d7
	cmp.l	maxtracks(a5),d7
	bcs.s	.trackloop

	move.l	d6,block_chan_events(a5)
	bra	.pos


.neg
	bsr.s	FreeBlockChan

	bsr	.nomem
	NEGATIV








FreeBlockPB
	clr.l	block_PB_events(a5)
	lea	block_PB_addr(a5),a0
	jmp	MyFreeVectorJ(a5)

FreeBlockCS
	clr.l	block_CS_events(a5)
	lea	block_CS_addr(a5),a0
	jmp	MyFreeVectorJ(a5)

FreeBlockBPM
	clr.l	block_BPM_events(a5)
	lea	block_BPM_addr(a5),a0
	jmp	MyFreeVectorJ(a5)

FreeBlockPre
	clr.l	block_Pre_events(a5)
	lea	block_Pre_addr(a5),a0
	jmp	MyFreeVectorJ(a5)

FreeBlockChan
	bsr.s	FreeBlockPB
	bsr.s	FreeBlockBPM
	bsr.s	FreeBlockPre

	clr.l	block_chan_events(a5)


;=== clear controlsources

	move.l	block_chcs_num(a5),d2
	beq.s	.nocs
	clr.l	block_chcs_num(a5)
;	subq.w	#1,d2
;	move.l	block_chcs_addrs(a5),a2
;.csloop
;	move.l	a2,a0
;	jsr	MyFreeVectorJ(a5)
;	addq.l	#4,a2
;	dbf	d2,.csloop

	lea	block_chcs_addr(a5),a0
	jsr	MyFreeVectorJ(a5)
.nocs


;=== clear note tracks

	move.l	block_chtrk_num(a5),d2
	beq.s	.notrk
	clr.l	block_chtrk_num(a5)
;	subq.w	#1,d2
;	move.l	block_chtrk_addrs(a5),a2
;.trkloop
;	move.l	a2,a0
;	jsr	MyFreeVectorJ(a5)
;	addq.l	#4,a2
;	dbf	d2,.trkloop

	lea	block_chtrk_addr(a5),a0
	jsr	MyFreeVectorJ(a5)
;	lea	block_chtrk_numbers(a5),a0
;	jsr	MyFreeVectorJ(a5)
.notrk

	rts




FreeBlockTrack
	clr.l	block_trk_events(a5)
	lea	block_trk_addr(a5),a0
	jmp	MyFreeVectorJ(a5)




;==============================================================
;
;  Block CLEAR
;
;==============================================================

block_clear
;	tst.b	playflag(a5)
;	bne	.rts
	tst.b	blockmarked(a5)
	beq	noblockmarked

	jsr	check_state_beforeJ(a5)

	st	songchanged(a5)
;=== Vorberechnen des Offsets und der Lnge
	move.l	blockstart(a5),d3
	move.l	blockstop(a5),d4
	sub.l	d3,d4

	move.b	blockmarktype(a5),d2
	beq	.clear_trk
	bpl	.clear_channel
	addq.b	#1,d2
	beq.s	.clear_cs
	addq.b	#1,d2
	bne.s	.clear_bpm

;.clear_Pre
	bsr.s	.Pre
	bra	block_cleared

.Pre
;	st	ptrackchanged(a5)
	jsr	GetPresetTrackJ(a5)
	beq.s	.rts
	move.w	#Preset_stay,d2
	bra	.block_clear_2b


.clear_BPM
	bsr.s	.BPM
	bra	block_cleared

.BPM
;	st	bpmtrackchanged(a5)
	jsr	GetBPMTrackJ(a5)
	beq.s	.rts
	move.w	#BPM_stay,d2
	bra	.block_clear_2b


.clear_cs
	move.w	pgfx_active(a5),d0
	bsr	.clear_csource
	bra	block_cleared



.clear_trk
	move.l	blocktrack(a5),d0
	bsr.s	.clear_track
	bra	block_cleared

.clear_track
;	move.l	trackchanged(a5),a0
;	st	(a0,d2.w)
	jsr	GetTrackDataJ(a5)
	beq.s	.rts
	move.l	#track_def_entry,d2

;.clear_4b
	IFEQ	mc68020
	move.l	d3,d0
	lsl.l	#2,d0
	adda.l	d0,a0
	ELSE
	lea	(a0,d3.l*4),a0
	ENDC
	move.l	d4,d1
.clr4B	move.l	d2,(a0)+
	subq.l	#1,d1
	bcc.s	.clr4B
.rts	rts





.block_clear_PB
;	st	pbtrackchanged(a5)
	jsr	GetPibeTrackJ(a5)
	beq.s	.rts
	move.w	#PB_stay,d2
;	bra.s	.block_clear_2b

.block_clear_2b
	IFEQ	mc68020
	adda.l	d3,a0
	adda.l	d3,a0
	ELSE
	lea	(a0,d3.l*2),a0
	ENDC
	move.l	d4,d1
.clrPB	move.w	d2,(a0)+
	subq.l	#1,d1
	bcc.s	.clrPB
	rts


;block_clear_MP
;	st	mptrackchanged(a5)
;	move.l	mpworktrack(a5),a0
;	move.b	#cs_stay,d2



;=== this routine is also called by the parameter-graphics (pgfx) MOUSEBUTTONS
;=== routine, to clear a csource-block before it is spreaded.

.clear_csource	; d3=start-event, d4=length-1
	tst.w	d0
	beq.s	.block_clear_PB
	subq.w	#1,d0
;	beq.s	block_clear_MP

;	move.l	ctrackchanged(a5),a0
;	st	-1(a0,d2.w)
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.rts
	move.b	#cs_stay,d2
;	bra.s	.block_clear_1b


.block_clear_1b	; d3=offset, d4=length in events, d2=stay, a0=^worktrack
	adda.l	d3,a0
	move.l	d4,d1
.clrCS	move.b	d2,(a0)+
	subq.l	#1,d1
	bcc.s	.clrCS
	rts



.clear_channel
	bsr.s	.block_clear_PB
;	bsr	block_clear_MP
	bsr	.Pre

;	move.l	ctrackchanged(a5),a1
	move.b	#cs_stay,d2
	move.l	active_csources_m1(a5),d7
.csourceloop
;	st	(a1,d7.w)
	move.l	d7,d0
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.nextcs
	bsr.s	.block_clear_1b
.nextcs	dbf	d7,.csourceloop

;	move.l	trackchanged(a5),a1
	move.l	#track_def_entry,d2
	move.l	maxtracks_m1(a5),d7
.trackloop
;	st	(a1,d7.w)
	move.l	d7,d0
	jsr	GetTrackDataJ(a5)
	beq.s	.nexttrk
	bsr	.clear_track
.nexttrk
	dbf	d7,.trackloop

	bsr.s	block_cleared_status
	bra.s	blockrefresh_channel




block_cleared
	bsr	blockrefresh_track


block_cleared_status
	move.w	#loc_b_cleared,d0
	jmp	status_displayJ(a5)



blockrefresh_track
	bsr	block_unmark_title
	bra	refresh_the_track



blockrefresh_channel
	bsr	block_unmark_title
	jsr	packchannelJ(a5)
	bra	current_channel_update






;==============================================================
;
;  Block INSERT
;
;==============================================================

block_insert_track
	tst.b	pastemode(a5)
	bne	block_paste_track

	tst.b	amigapressed(a5)
	beq.s	.frommenu
	tst.b	shiftpressed(a5)
	bne	block_insert_chan
.frommenu

	lea	block_insert_struct(pc),a4
	bra.s	blocktrack_routine


block_insert_struct
	dc.w	loc_b_instrk
	dc.w	loc_b_inschan
	bra	insert_1b
	bra	insert_2b
	bra	insert_4b




		rsreset
bf_trackmsgloc	rs.w	1
bf_chanmsgloc	rs.w	1
bf_routine_1b	rs.l	1
bf_routine_2b	rs.l	1
bf_routine_4b	rs.l	1


blocktrack_routine	; a4=^blocktrack-struct

	tst.b	playflag(a5)
	beq.s	.do
	rts

.do
	jsr	check_state_beforeJ(a5)

	move.l	currenttrack(a5),d0
	bpl	.insert_track
	addq.l	#1,d0
	beq	.insert_csource
	addq.l	#1,d0
	beq	.insert_Pre


;=== BPM track
	bsr	ins_BPM
	beq	nothingtopaste
	move.l	block_BPM_events(a5),d3


.inserted
	move.l	a4,-(sp)
	bsr	offset_after_op
	bsr	blockrefresh_track
	move.l	(sp)+,a4

	move.w	bf_trackmsgloc(a4),d0
	jmp	status_displayJ(a5)




.insert_Pre
	bsr	ins_Pre
	beq	nothingtopaste
	move.l	block_Pre_events(a5),d3
	bra.s	.inserted



.insert_csource
	move.w	pgfx_active(a5),d0
	beq.s	.insert_PB
	subq.w	#1,d0
;	beq.s	.insert_MP
;	subq.w	#1,d0

	move.l	block_CS_events(a5),d3
	beq	nothingtopaste
	move.l	block_CS_addr(a5),a1
	bsr	ins_CS
	move.l	block_CS_events(a5),d3
	bra.s	.inserted


.insert_PB
	bsr.s	ins_PB
	beq	nothingtopaste
	move.l	block_PB_events(a5),d3
	bra.s	.inserted


;.insert_MP
;	bsr.s	ins_MP
;	beq	nothingtopaste
;	move.l	block_CS_events(a5),d3
;	bra.s	.inserted


.insert_track
	move.l	block_trk_events(a5),d3
	beq	nothingtopaste
	move.l	block_trk_addr(a5),a1
	bsr	ins_track
	move.l	block_trk_events(a5),d3
	bra	.inserted




ins_PB
	move.l	block_PB_events(a5),d3
	beq.s	.neg
;	st	pbtrackchanged(a5)
	st	songchanged(a5)
	jsr	GetOrAllocPibeTrackJ(a5)
	beq.s	.neg
	move.l	block_PB_addr(a5),a1
	move.w	#PB_stay,d4
	jsr	bf_routine_2b(a4)
	POSITIV
.neg	NEGATIV


;ins_MP
;	move.l	block_CS_events(a5),d3
;	beq.s	.neg
;	st	mptrackchanged(a5)
;	st	songchanged(a5)
;	move.l	mpworktrack(a5),a0
;	move.l	block_CS_addr(a5),a1
;	move.b	#CS_stay,d4
;	jsr	bf_routine_1b(a4)
;	POSITIV
;.neg	NEGATIV



ins_BPM
	move.l	block_BPM_events(a5),d3
	beq.s	.neg
;	st	bpmtrackchanged(a5)
	st	songchanged(a5)
	jsr	GetOrAllocBPMTrackJ(a5)
	beq.s	.neg
	move.l	block_BPM_addr(a5),a1
	move.w	#BPM_stay,d4
	jsr	bf_routine_2b(a4)
	POSITIV
.neg	NEGATIV



ins_Pre
	move.l	block_Pre_events(a5),d3
	beq.s	.neg
;	st	ptrackchanged(a5)
	st	songchanged(a5)
	jsr	GetOrAllocPresetTrackJ(a5)
	beq.s	.neg
	move.l	block_Pre_addr(a5),a1
	move.w	#Preset_stay,d4
	jsr	bf_routine_2b(a4)
	POSITIV
.neg	NEGATIV




ins_CS	; d0.w=csource, a1=^sourcebuffer, d3=source-events
;	move.l	ctrackchanged(a5),a0
;	st	(a0,d0.w)
	st	songchanged(a5)
	jsr	GetOrAllocCSourceTrackDataJ(a5)
	beq.s	.neg
	move.b	#cs_stay,d4
	jsr	bf_routine_1b(a4)
	POSITIV
.neg	NEGATIV


ins_track	; d0.l=track, a1=^sourcebuffer, d3=source-events
;	move.l	trackchanged(a5),a0
;	st	(a0,d0.w)
	st	songchanged(a5)
	jsr	GetOrAllocTrackDataJ(a5)
	beq.s	.neg
	move.l	#track_def_entry,d4
	jsr	bf_routine_4b(a4)
	POSITIV
.neg	NEGATIV





insert_1b	; a0=^worktrack, a1=copybuffer-addr,
		; d3=copybuffer-events
	move.l	a1,-(sp)

	move.l	eventpos(a5),d0
	move.l	d0,d1
	add.l	d3,d1
	move.l	events(a5),d2
	lea	(a0,d2.l),a3
	cmp.l	d2,d1
	bcc.s	.noshiftup_1b

	lea	(a0,d0.l),a1
	sub.l	d3,d2
	lea	(a0,d2.l),a2

.shiftloop_1b
	move.b	-(a2),-(a3)
	cmpa.l	a2,a1
	bcs.s	.shiftloop_1b
	bra.s	.shifted_1b

.noshiftup_1b
	move.l	d2,d3
	sub.l	d0,d3

.shifted_1b
	move.l	(sp)+,a2
	move.l	a2,a1
	adda.l	d3,a2

.copyloop_1b
	move.b	-(a2),-(a3)
	cmpa.l	a2,a1
	bcs.s	.copyloop_1b

	rts





insert_2b	; a0=^worktrack, a1=copybuffer-addr,
		; d3=copybuffer-events
	move.l	a1,-(sp)

	move.l	eventpos(a5),d0
	move.l	d0,d1
	add.l	d3,d1
	move.l	events(a5),d2
	IFEQ	mc68020
	move.l	d2,d4
	add.l	d4,d4
	lea	(a0,d4.l),a3
	ELSE
	lea	(a0,d2.l*2),a3
	ENDC
	cmp.l	d2,d1
	bcc.s	.noshiftup_2b

	IFEQ	mc68020
	add.l	d0,d0
	lea	(a0,d0.l),a1
	add.l	d2,d2
	add.l	d3,d3
	sub.l	d3,d2
	lea	(a0,d2.l),a2
	ELSE
	lea	(a0,d0.l*2),a1
	sub.l	d3,d2
	lea	(a0,d2.l*2),a2
	ENDC

.shiftloop_2b
	move.w	-(a2),-(a3)
	cmpa.l	a2,a1
	bcs.s	.shiftloop_2b
	bra.s	.shifted_2b

.noshiftup_2b
	move.l	d2,d3
	sub.l	d0,d3

.shifted_2b
	move.l	(sp)+,a2
	move.l	a2,a1
	IFEQ	mc68020
	add.l	d3,d3
	adda.l	d3,a2
	ELSE
	lea	(a2,d3.l*2),a2
	ENDC

.copyloop_2b
	move.w	-(a2),-(a3)
	cmpa.l	a2,a1
	bcs.s	.copyloop_2b

	rts





insert_4b	; a0=^worktrack, a1=copybuffer-addr,
		; d3=copybuffer-events
	move.l	a1,-(sp)

	move.l	eventpos(a5),d0
	move.l	d0,d1
	add.l	d3,d1
	move.l	events(a5),d2
	IFEQ	mc68020
	move.l	d2,d4
	lsl.l	#2,d4
	lea	(a0,d4.l),a3
	ELSE
	lea	(a0,d2.l*4),a3
	ENDC
	cmp.l	d2,d1
	bcc.s	.noshiftup_4b

	IFEQ	mc68020
	lsl.l	#2,d0
	lea	(a0,d0.l),a1
	lsl.l	#2,d2
	move.l	d3,d0
	lsl.l	#2,d0
	sub.l	d0,d2
	lea	(a0,d2.l),a2
	ELSE
	lea	(a0,d0.l*4),a1
	sub.l	d3,d2
	lea	(a0,d2.l*4),a2
	ENDC

.shiftloop_4b
	move.l	-(a2),-(a3)
	cmpa.l	a2,a1
	bcs.s	.shiftloop_4b
	bra.s	.shifted_4b

.noshiftup_4b
	move.l	d2,d3
	sub.l	d0,d3

.shifted_4b
	move.l	(sp)+,a2
	move.l	a2,a1
	IFEQ	mc68020
	lsl.l	#2,d3
	adda.l	d3,a2
	ELSE
	lea	(a2,d3.l*4),a2
	ENDC

.copyloop_4b
	move.l	-(a2),-(a3)
	cmpa.l	a2,a1
	bcs.s	.copyloop_4b

	rts








block_insert_chan
	tst.b	pastemode(a5)
	bne	block_paste_chan

	lea	block_insert_struct(pc),a4
;	bra.s	blockchan_routine


blockchan_routine	; a4=^blocktrack-struct

	tst.b	playflag(a5)
	beq.s	.do
	rts

.do	tst.l	block_chan_events(a5)
	beq	nothingtopaste

	bsr	ins_Pre
	bsr	ins_PB

	move.l	block_chtrk_addr(a5),-(sp)
	moveq	#0,d7
.trackloop
	move.l	(sp),a1
	move.l	block_chan_events(a5),d3
	move.l	d7,d0
	bsr	ins_track
	move.l	block_chan_events(a5),d0
	lsl.l	#2,d0
	add.l	d0,(sp)

	addq.l	#1,d7
	cmp.l	maxtracks(a5),d7
	bcs.s	.trackloop



	move.l	block_chcs_addr(a5),(sp)
	moveq	#0,d7
.csloop
	move.l	(sp),a1
	move.l	block_chan_events(a5),d3
	move.l	d7,d0
	bsr	ins_CS
	move.l	block_chan_events(a5),d0
	add.l	d0,(sp)

	addq.l	#1,d7
	cmp.l	active_csources(a5),d7
	bcs.s	.csloop

	move.l	a4,(sp)

	move.l	block_chan_events(a5),d3
	bsr.s	offset_after_op
	bsr	blockrefresh_channel

	move.l	(sp)+,a4
	move.w	bf_chanmsgloc(a4),d0
	jmp	status_displayJ(a5)






offset_after_op	; d3=events der operation

	move.l	eventpos(a5),d0
	add.l	d3,d0
	move.l	events(a5),d2
	cmp.l	d2,d0
	bcs.s	.inside
	clr.l	eventpos(a5)
	rts
.inside	move.l	d0,eventpos(a5)
	rts






;==============================================================
;
;  Block PASTE MODE
;
;==============================================================

block_pastemode
	lea	.subitemtab(pc),a0
	jmp	subitem_activatorJ(a5)
.subitemtab
	dr.w	block_insertmode
	dr.w	block_overwritemode


block_insertmode
	clr.b	pastemode(a5)
	rts

block_overwritemode
	move.b	#1,pastemode(a5)
	rts





;==============================================================
;
;  Block PASTE (overwrite)
;
;==============================================================

block_paste_track
	tst.b	amigapressed(a5)
	beq.s	.frommenu
	tst.b	shiftpressed(a5)
	bne	block_paste_chan
.frommenu

	tst.b	blockmarked(a5)
	beq.s	.notmarked
	bsr	block_copy
.notmarked

	lea	block_paste_struct(pc),a4
	bra	blocktrack_routine


block_paste_struct
	dc.w	loc_b_instrk
	dc.w	loc_b_inschan
	bra	paste_1b
	bra	paste_2b
	bra	paste_4b




paste_1b	; a0=^worktrack, a1=copybuffer-addr,
		; d3=copybuffer-events

	move.l	eventpos(a5),d0
	move.l	d0,d1
	adda.l	d0,a0
	add.l	d3,d0
	move.l	events(a5),d2
	cmp.l	d2,d0
	bcs.s	.inside
	move.l	d2,d3
	sub.l	d1,d3
.inside
.copyloop
	move.b	(a1)+,(a0)+
	subq.l	#1,d3
	bne.s	.copyloop

	rts



paste_2b	; a0=^worktrack, a1=copybuffer-addr,
		; d3=copybuffer-events

	move.l	eventpos(a5),d0
	move.l	d0,d1
	IFEQ	mc68020
	adda.l	d0,a0
	adda.l	d0,a0
	ELSE
	lea	(a0,d0.l*2),a0
	ENDC
	add.l	d3,d0
	move.l	events(a5),d2
	cmp.l	d2,d0
	bcs.s	.inside
	move.l	d2,d3
	sub.l	d1,d3
.inside
.copyloop
	move.w	(a1)+,(a0)+
	subq.l	#1,d3
	bne.s	.copyloop

	rts





paste_4b	; a0=^worktrack, a1=copybuffer-addr,
		; d3=copybuffer-events

	move.l	eventpos(a5),d0
	move.l	d0,d1
	IFEQ	mc68020
	move.l	d0,d2
	lsl.l	#2,d2
	adda.l	d2,a0
	ELSE
	lea	(a0,d0.l*4),a0
	ENDC
	add.l	d3,d0
	move.l	events(a5),d2
	cmp.l	d2,d0
	bcs.s	.inside
	move.l	d2,d3
	sub.l	d1,d3
.inside
.copyloop
	move.l	(a1)+,(a0)+
	subq.l	#1,d3
	bne.s	.copyloop

	rts





block_paste_chan
	tst.b	blockmarked(a5)
	beq.s	.notmarked
	bsr	block_copy
.notmarked

	lea	block_paste_struct(pc),a4
	bra	blockchan_routine





;==============================================================
;
;  Block JOIN
;
;==============================================================

block_join_track
	tst.b	amigapressed(a5)
	beq.s	.frommenu
	tst.b	shiftpressed(a5)
	bne	block_join_chan
.frommenu

	tst.b	blockmarked(a5)
	beq.s	.notmarked
	bsr	block_mark_track
.notmarked

	lea	block_join_struct(pc),a4
	bra	blocktrack_routine


block_join_struct
	dc.w	loc_b_jointrk
	dc.w	loc_b_joinchan
	bra	join_1b
	bra	join_2b
	bra	join_4b



join_1b		; a0=^worktrack, a1=copybuffer-addr,
		; d3=copybuffer-events, d4=stay

	move.l	eventpos(a5),d0
	move.l	d0,d1
	adda.l	d0,a0
	add.l	d3,d0
	move.l	events(a5),d2
	cmp.l	d2,d0
	bcs.s	.inside
	move.l	d2,d3
	sub.l	d1,d3
.inside
	tst.b	joindomi(a5)
	bne.s	.copydominant

.copyrecessive
	move.b	(a0),d0
	move.b	(a1)+,d1
	cmp.b	d4,d0
	beq.s	.recnew
	move.b	d0,d1
.recnew	move.b	d1,(a0)+
	subq.l	#1,d3
	bne.s	.copyrecessive
	rts

.copydominant
	move.b	(a0),d0
	move.b	(a1)+,d1
	cmp.b	d4,d1
	beq.s	.domnew
	move.b	d1,d0
.domnew	move.b	d0,(a0)+
	subq.l	#1,d3
	bne.s	.copydominant
	rts





join_2b		; a0=^worktrack, a1=copybuffer-addr,
		; d3=copybuffer-events, d4=stay

	move.l	eventpos(a5),d0
	move.l	d0,d1
	IFEQ	mc68020
	adda.l	d0,a0
	adda.l	d0,a0
	ELSE
	lea	(a0,d0.l*2),a0
	ENDC
	add.l	d3,d0
	move.l	events(a5),d2
	cmp.l	d2,d0
	bcs.s	.inside
	move.l	d2,d3
	sub.l	d1,d3
.inside
	tst.b	joindomi(a5)
	bne.s	.copydominant

.copyrecessive
	move.w	(a0),d0
	move.w	(a1)+,d1
	cmp.w	d4,d0
	beq.s	.recnew
	move.w	d0,d1
.recnew	move.w	d1,(a0)+
	subq.l	#1,d3
	bne.s	.copyrecessive
	rts

.copydominant
	move.w	(a0),d0
	move.w	(a1)+,d1
	cmp.w	d4,d1
	beq.s	.domnew
	move.w	d1,d0
.domnew	move.w	d0,(a0)+
	subq.l	#1,d3
	bne.s	.copydominant
	rts






join_4b		; a0=^worktrack, a1=copybuffer-addr,
		; d3=copybuffer-events, d4=stay

	move.l	eventpos(a5),d0
	move.l	d0,d1
	IFEQ	mc68020
	move.l	d0,d2
	lsl.l	#2,d2
	adda.l	d2,a0
	ELSE
	lea	(a0,d0.l*4),a0
	ENDC
	add.l	d3,d0
	move.l	events(a5),d2
	cmp.l	d2,d0
	bcs.s	.inside
	move.l	d2,d3
	sub.l	d1,d3
.inside
	tst.b	joindomi(a5)
	bne.s	.copydominant

.copyrecessive
	move.l	(a0),d0
	move.l	(a1)+,d1
	cmp.l	d4,d0
	beq.s	.recnew
	move.l	d0,d1
.recnew	move.l	d1,(a0)+
	subq.l	#1,d3
	bne.s	.copyrecessive
	rts

.copydominant
	move.l	(a0),d0
	move.l	(a1)+,d1
	cmp.l	d4,d1
	beq.s	.domnew
	move.l	d1,d0
.domnew	move.l	d0,(a0)+
	subq.l	#1,d3
	bne.s	.copydominant
	rts






block_join_chan
	lea	block_join_struct(pc),a4
	bra	blockchan_routine





block_flip
;	tst.b	playflag(a5)
;	bne.s	.rts
	tst.b	blockmarked(a5)
	beq	noblockmarked

	move.b	blockmarktype(a5),d0
	cmp.b	#-2,d0			; Presettrack ?
	beq.s	.notsuit
	cmp.b	#1,d0			; channel ?
	beq.s	.notsuit

	bra.s	.go

.notsuit
	bsr	notsuitable
	bra	block_unmark

.rts	rts





.go	; d0=blockmarktype

	move.l	blockstop(a5),d4
	sub.l	blockstart(a5),d4
	beq	larger_block

	tst.b	d0
	beq	.flip_track
	addq.b	#1,d0
	beq	.flip_csource


.BPM
;=== BPM Track
;	st	bpmtrackchanged(a5)
;	move.l	bpmworktrack(a5),a0
	jsr	GetBPMTrackJ(a5)
	beq.s	.out
	bsr	.flip_2b
	bra.s	.out




.flip_csource	; d4=blockrange

	move.w	pgfx_active(a5),d0
	beq.s	.PB
	subq.w	#1,d0
;	beq.s	.MP


;=== Controlsource
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.out
;	move.l	ctrackchanged(a5),a1
;	st	(a1,d0.w)			; d0 is from GetCurrentCSTrack()
	bsr	.flip_1b
	bra.s	.out


.PB
;=== Pitchbend
;	st	pbtrackchanged(a5)
	jsr	GetPibeTrackJ(a5)
	beq.s	.out
	bsr	.flip_2b

.out
	move.w	#loc_b_flip,d0
	jsr	status_displayJ(a5)

	bra	blockrefresh_track



;.MP
;=== MPress
;	st	mptrackchanged(a5)
;	st	songchanged(a5)
;	move.l	mpworktrack(a5),a0
;	bsr	.flip_1b
;	bra.s	.out





.flip_track
	tst.b	vel_or_pp(a5)
	beq.s	.velocity

	move.w	#loc_blockop_body,d0
	move.w	#loc_ppnotesbothcancel,d1
	jsr	EZrequestJ(a5)
	subq.l	#1,d0
	beq.s	.ppress
.vcont	bcs	.rts
	subq.l	#1,d0
	beq.s	.notes
;=== both
	moveq	#-1,d5
	bra.s	.ppcont

.ppress	moveq	#wd_pp,d5
	bra.s	.ppcont
.notes	moveq	#wd_pitch,d5
	bra.s	.ppcont

.velocity
	move.w	#loc_blockop_body,d0
	move.w	#loc_velnotesbothcancel,d1
	jsr	EZrequestJ(a5)
	subq.l	#1,d0
	beq.s	.vel
	bra.s	.vcont

.vel	moveq	#wd_vel,d5
.ppcont

	move.l	blocktrack(a5),d0
	jsr	GetTrackDataJ(a5)
	beq	.out
;	move.l	trackchanged(a5),a1
;	st	(a1,d0.w)
	bsr.s	.flip_vel
	bra	.out




.flip_vel	; a0=worktrack,
		; d5.l=wd-offset to velocity or ppress

	st	songchanged(a5)

	move.l	d5,a3

	move.l	blockstart(a5),d0
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	lsl.l	#2,d0
	lsl.l	#2,d1
	lea	(a0,d0.l),a2
	lea	4(a0,d1.l),a1
	ELSE
	lea	(a0,d0.l*4),a2
	lea	4(a0,d1.l*4),a1
	ENDC

	tst.l	d5
	bmi.s	.fliploop_4b2

.fliploop_4b
	move.b	(a2,d5.l),d0
	move.b	-4(a1,d5.l),(a2,d5.l)
	move.b	d0,-4(a1,d5.l)

	addq.l	#wd_sizeof,a2
	subq.l	#wd_sizeof,a1
	cmpa.l	a1,a2
	bcs.s	.fliploop_4b
	rts

.fliploop_4b2
	move.l	(a2),d0
	move.l	-(a1),(a2)+
	move.l	d0,(a1)

	cmpa.l	a1,a2
	bcs.s	.fliploop_4b2
	rts




.flip_2b	; a0=worktrack

	move.l	blockstart(a5),d0
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	add.l	d0,d0
	add.l	d1,d1
	lea	(a0,d0.l),a2
	lea	2(a0,d1.l),a1
	ELSE
	lea	(a0,d0.l*2),a2
	lea	2(a0,d1.l*2),a1
	ENDC

.fliploop_2b
	move.w	(a2),d0
	move.w	-(a1),(a2)+
	move.w	d0,(a1)

	cmpa.l	a1,a2
	bcs.s	.fliploop_2b

	st	songchanged(a5)
	rts




.flip_1b	; a0=worktrack

	move.l	a0,a2
	adda.l	blockstart(a5),a2
	move.l	a0,a1
	adda.l	blockstop(a5),a1
	addq.l	#1,a1

.fliploop_1b
	move.b	(a2),d0
	move.b	-(a1),(a2)+
	move.b	d0,(a1)

	cmpa.l	a1,a2
	bcs.s	.fliploop_1b

	st	songchanged(a5)
	rts







block_invert
	tst.b	playflag(a5)
	bne.s	.rts
	tst.b	blockmarked(a5)
	beq	noblockmarked

	move.b	blockmarktype(a5),d0
	cmp.b	#-3,d0			; bpmtrack ?
	beq.s	.notsuit
	cmp.b	#-2,d0			; Presettrack ?
	beq.s	.notsuit
	cmp.b	#1,d0			; channel ?
	beq.s	.notsuit

	bra.s	.go

.notsuit
	bsr	notsuitable
	bra	block_unmark

.rts	rts





.go	; d0=blockmarktype

	move.l	blockstop(a5),d4
	sub.l	blockstart(a5),d4
	beq	larger_block

	tst.b	d0
	beq	.invert_track

; must be controlsource

;.invert_csource	; d4=blockrange

	move.w	pgfx_active(a5),d0
	beq.s	.PB
	subq.w	#1,d0
;	beq.s	.MP


;=== Controlsource
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.out
;	move.l	ctrackchanged(a5),a1
;	st	(a1,d0.w)		; d0 is from GetCurrentCSTrack()
	bsr	.invert_1b
	bra.s	.out


.PB
;=== Pitchbend
;	st	pbtrackchanged(a5)
	jsr	GetPibeTrackJ(a5)
	beq.s	.out
	bsr	.invert_2b

.out	bsr	blockrefresh_track

	move.w	#loc_b_invert,d0
	jmp	status_displayJ(a5)



;.MP
;=== MPress
;	st	mptrackchanged(a5)
;	st	songchanged(a5)
;	move.l	mpworktrack(a5),a0
;	bsr	.invert_1b
;	bra.s	.out





.invert_track
	tst.b	vel_or_pp(a5)
	beq.s	.vel
	moveq	#wd_pp,d5
	move.b	#PP_stay,d3
	bra.s	.ppcont
.vel	moveq	#wd_vel,d5
	move.b	#Vel_clear,d3
.ppcont
	move.l	blocktrack(a5),d0
	jsr	GetTrackDataJ(a5)
	beq.s	.out
;	move.l	trackchanged(a5),a1
;	st	(a1,d0.w)
	bsr.s	.invert_vel
	bra.s	.out




.invert_vel	; a0=worktrack,
		; d5.l=wd-offset to velocity or ppress
		; d3.b=stay value

	move.l	blockstart(a5),d0
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	lsl.l	#2,d0
	lsl.l	#2,d1
	lea	(a0,d1.l),a1
	adda.l	d0,a0
	ELSE
	lea	(a0,d1.l*4),a1
	lea	(a0,d0.l*4),a0
	ENDC

.invertloop_4b
	move.b	(a0,d5.l),d0
	cmp.b	d3,d0
	beq.s	.no4b

	moveq	#-$80,d1
	sub.b	d0,d1
	move.b	d1,(a0,d5.l)

.no4b	addq.w	#wd_sizeof,a0
	cmpa.l	a1,a0
	bls.s	.invertloop_4b

	st	songchanged(a5)
	rts




.invert_2b	; a0=worktrack (pitchbend)

	move.l	blockstart(a5),d0
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	add.l	d0,d0
	add.l	d1,d1
	lea	(a0,d1.l),a1
	adda.l	d0,a0
	ELSE
	lea	(a0,d1.l*2),a1
	lea	(a0,d0.l*2),a0
	ENDC

	move.w	#$4000,d2

.invertloop_2b
	move.w	(a0)+,d0
	cmp.w	#PB_stay,d0
	beq.s	.no2b

	move.w	d2,d1
	sub.w	d0,d1
	move.w	d1,-2(a0)

.no2b	cmpa.l	a1,a0
	bls.s	.invertloop_2b

	st	songchanged(a5)
	rts




.invert_1b	; a0=worktrack

	move.l	a0,a1
	adda.l	blockstart(a5),a0
	adda.l	blockstop(a5),a1

.invertloop_1b
	move.b	(a0)+,d0
	cmp.b	#cs_stay,d0
	beq.s	.no1b

	moveq	#-128,d1
	sub.b	d0,d1
	move.b	d1,-1(a0)

.no1b	cmpa.l	a1,a0
	bls.s	.invertloop_1b

	st	songchanged(a5)
	rts







block_shift
;	tst.b	playflag(a5)
;	bne.s	.rts
	tst.b	blockmarked(a5)
	beq	noblockmarked

	move.b	blockmarktype(a5),d0
	cmp.b	#-3,d0			; bpmtrack ?
	beq.s	.notsuit
	cmp.b	#-2,d0			; Presettrack ?
	beq.s	.notsuit
	cmp.b	#1,d0			; channel ?
	beq.s	.notsuit

	cmp.b	#-1,d0
	bne.s	.nocs
	tst.w	pgfx_active(a5)
	beq.s	.notsuit		; pitchbend ?
.nocs	bra.s	.go

.notsuit
	bsr	notsuitable
	bra	block_unmark


.cancel	addq.w	#4,sp
.rts	rts





.go	; d0=blockmarktype

	move.l	d0,-(sp)

	move.w	#loc_addvalue,d0
	move.l	last_addvalue(a5),d1
	bne.s	.notempty
	moveq	#8,d1
.notempty
	moveq	#-127,d2
	moveq	#127,d3
	jsr	rtLong_minmaxJ(a5)
	beq.s	.cancel
	move.l	d1,d6
	beq.s	.cancel
	move.l	d1,last_addvalue(a5)

	move.l	(sp)+,d0

	move.l	blockstop(a5),d4
	sub.l	blockstart(a5),d4
	beq	larger_block

	tst.b	d0
	beq	.shift_track

; must be controlsource

;.shift_csource	; d4=blockrange

	move.w	pgfx_active(a5),d0
	subq.w	#1,d0
;	beq.s	.MP


;=== Controlsource
	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.out
;	move.l	ctrackchanged(a5),a1
;	st	(a1,d0.w)		; d0 is from GetCurrentCSTrack()
	bsr	.shift_1b
;	bra.s	.out


;.MP
;=== MPress
;	st	mptrackchanged(a5)
;	st	songchanged(a5)
;	move.l	mpworktrack(a5),a0
;	bsr	.shift_1b

.out	bsr	blockrefresh_track

	move.w	#loc_b_shift,d0
	jmp	status_displayJ(a5)




.shift_track
	move.l	blocktrack(a5),d0
	jsr	GetTrackDataJ(a5)
	beq.s	.out
;	move.l	trackchanged(a5),a1
;	st	(a1,d0.w)

	move.l	blockstart(a5),d0
	move.l	blockstop(a5),d1
	IFEQ	mc68020
	lsl.l	#2,d0
	lsl.l	#2,d1
	lea	(a0,d1.l),a1
	adda.l	d0,a0
	ELSE
	lea	(a0,d1.l*4),a1
	lea	(a0,d0.l*4),a0
	ENDC

	tst.b	vel_or_pp(a5)
	beq.s	.vel
	bsr.s	.shift_pp
	bra.s	.ppcont
.vel	bsr.s	.shift_vel
.ppcont
	bra.s	.out


.shift_vel	; a0=worktrack

	addq.l	#wd_vel,a0
	addq.l	#wd_vel,a1
	move.b	#Vel_clear,d3

.shiftloop_4b
	move.b	(a0),d0
	cmp.b	d3,d0
	beq.s	.no4b

	add.b	d6,d0
	ble.s	.lo4b
	bvc.s	.ok4b
	moveq	#127,d0
	bra.s	.ok4b
.lo4b	moveq	#1,d0
.ok4b	move.b	d0,(a0)

.no4b	addq.w	#wd_sizeof,a0
	cmpa.l	a1,a0
	bls.s	.shiftloop_4b

	st	songchanged(a5)
	rts


.shift_pp	; a0=worktrack

	addq.w	#wd_pp,a0
	addq.w	#wd_pp,a1
	move.b	#PP_stay,d3

.shiftloop_4b2
	move.b	(a0),d0
	cmp.b	d3,d0
	beq.s	.no4b2

	add.b	d6,d0
	bmi.s	.lo4b2
	bvc.s	.ok4b2
	moveq	#127,d0
	bra.s	.ok4b2
.lo4b2	moveq	#1,d0
.ok4b2	move.b	d0,(a0)

.no4b2	addq.w	#wd_sizeof,a0
	cmpa.l	a1,a0
	bls.s	.shiftloop_4b2

	st	songchanged(a5)
	rts




.shift_1b	; a0=worktrack

	move.l	a0,a1
	adda.l	blockstart(a5),a0
	adda.l	blockstop(a5),a1

.shiftloop_1b
	move.b	(a0)+,d0
	cmp.b	#cs_stay,d0
	beq.s	.no1b

	add.b	d6,d0
	bpl.s	.ok1b
	bvs.s	.hi1b
	moveq	#0,d0
	bra.s	.ok1b
.hi1b	moveq	#127,d0
.ok1b	move.b	d0,-1(a0)

.no1b	cmpa.l	a1,a0
	bls.s	.shiftloop_1b

	st	songchanged(a5)
	rts










;==============================================================
;
;  Block transpose (called from main window transpose-gadget's routine)
;
;==============================================================

transpose_block
	tst.b	playflag(a5)
	bne.s	.rts
	tst.l	active_channelwindow(a5)
	bmi.s	.rts

	tst.b	blockmarked(a5)
	beq	noblockmarked

	move.b	blockmarktype(a5),d0
	beq.s	.trans_track
	bpl.s	.trans_channel
	bra	notsuitable


.trans_track
	move.l	blocktrack(a5),d7
;	bra.s	.trans_4b


.trans_4b	; d7 = tracknumber
	jsr	GetChannelResolutionJ(a5)
	move.l	blockstart(a5),d2
	move.l	blockstop(a5),d1
	sub.l	d2,d1
	add.l	d0,d1

	move.l	d7,d0
	jsr	GetTrackDataJ(a5)
	beq.s	.rts
	IFEQ	mc68020
	lsl.l	#2,d2
	lea	(a0,d2.l),a0
	ELSE
	lea	(a0,d2.l*4),a0
	ENDC
	jmp	(a3)




.trans_channel

	move.l	maxtracks_m1(a5),d7
.trackloop
	bsr.s	.trans_4b
	dbf	d7,.trackloop

.rts	rts

