                    
	include	includes/exec.i
	include	includes/dos.i
	include	includes/intuition.i
	include	miditracker/keyfile-includes.i



NEGATIV	MACRO
	moveq	#0,d0
	rts
	ENDM

POSITIV	MACRO
	moveq	#1,d0
	rts
	ENDM





s	lea	varbase,a5
	move.l	$4.w,(a5)

	lea	dosnam(pc),a1
	moveq	#37,d0
	move.l	(a5),a6
	jsr	OpenLibrary(a6)
	move.l	d0,dosbas(a5)
	beq	.nodos

	lea	intnam(pc),a1
	moveq	#0,d0
	jsr	OpenLibrary(a6)
	move.l	d0,intbas(a5)
	beq	.noint


	bsr	decode_everything

	lea	keyfile_start+checksums_offset(pc),a4
	moveq	#0,d7

	bsr	decode_two_way
	beq.s	.wrong
	bsr	decode_8byte
	beq.s	.wrong
	bsr	decode_swap_bitchange
	beq.s	.wrong
	bsr	decalc_sub_intel
	beq.s	.wrong
	bsr	decalc_swap_add
	beq.s	.wrong
	bsr	decalc_addror1
	beq.s	.wrong
	bsr	decalc_add_b_w_l
	beq.s	.wrong
	bsr	decode_add_eor_64bit
	beq.s	.wrong
	bsr	decode_crazy_bytes
	beq.s	.wrong
	bsr	decode_add_nibbles
	beq.s	.wrong
; V1.2
	bsr	decode_number_of_bits
	beq.s	.wrong
	bsr	decode_add_bitchange
	beq.s	.wrong
; V1.1
	bsr	decode_complex_eor
	beq.s	.wrong
	bsr	decode_rotate_add
	beq.s	.wrong
; V1.0
	bsr	decode_add_sub
	beq.s	.wrong
	bsr	decode_simple_eor
	beq.s	.wrong


	bsr	retrieve_username
	bsr	save_key_decoded
	moveq	#0,d6
	bra.s	.norm

.wrong	moveq	#-1,d6


.norm	move.l	intbas(a5),a1
	move.l	(a5),a6
	jsr	CloseLibrary(a6)

.noint	move.l	dosbas(a5),a1
	move.l	(a5),a6
	jsr	CloseLibrary(a6)

.nodos	moveq	#0,d0
	rts





decode_everything
	lea	keyfile_start+keycode_offset(pc),a0
	move.w	#keycode_length+checksums_sizeof-1,d3
.decodeloop
	move.b	(a0),d0
	sub.b	d3,d0
	eor.b	d3,d0
	rol.b	d3,d0
	move.b	d0,(a0)+
	dbf	d3,.decodeloop
	rts



retrieve_username
	lea	keyfile_start+username_offset(pc),a0
	lea	username(pc),a1
	moveq	#username_maxlen-1,d3
.codeloop
	move.b	(a0)+,(a1)+
	dbf	d3,.codeloop
	rts






save_key_decoded
	lea	destfile(pc),a0
	move.l	a0,d1
	move.l	#1006,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d4
	beq.s	.error

	move.l	d4,d1
	lea	keyfile_start(pc),a0
	move.l	a0,d2
	move.l	#keyfile_stop-keyfile_start,d3
	jsr	Write(a6)

	move.l	d4,d1
	jmp	Close(a6)

.error	rts




decode_simple_eor
	lea	keyfile_start+keycode_offset(pc),a0
	move.l	simple_eor_checksum(a4),d2
	moveq	#keycode_length/4-1,d0
.calcloop
	move.l	(a0)+,d1
	eor.l	d1,d2
	dbf	d0,.calcloop
	bra	long_checksum_test





decode_add_sub
	lea	keyfile_start+keycode_offset(pc),a0
	move.w	addsub_checksum(a4),d2
	moveq	#keycode_length/4-1,d0
.calcloop
	sub.w	(a0)+,d2
	add.w	(a0)+,d2
	dbf	d0,.calcloop
word_checksum_test
	ext.l	d2
long_checksum_test
	tst.l	d2
	bne.s	.wrong
	addq.l	#1,d7
	POSITIV
.wrong	NEGATIV





decode_rotate_add
	lea	keyfile_start+keycode_offset+keycode_length(pc),a0
	move.w	rotate_add_checksum(a4),d2
	moveq	#keycode_length/4-1,d0
.calcloop
	move.w	-(a0),d1
	move.w	-(a0),d3
	rol.w	d1,d3
	sub.w	d1,d2
	sub.w	d3,d2
	add.w	d0,d2
	dbf	d0,.calcloop
	bra	word_checksum_test




decode_complex_eor
	lea	keyfile_start+keycode_offset+keycode_length(pc),a0
	move.l	complex_eor_checksum(a4),d2
	moveq	#0,d0
.calcloop
	move.l	-(a0),d1
	rol.l	d0,d1
	sub.l	d1,d2
	ror.l	d0,d1
	eor.l	d1,d2
	addq.w	#1,d0
	cmp.w	#keycode_length/4,d0
	bcs.s	.calcloop
	bra	long_checksum_test




decode_add_bitchange
	lea	keyfile_start+keycode_offset+keycode_length(pc),a0
	move.l	add_bitchange_checksum(a4),d2
	moveq	#0,d0
.calcloop
	rol.l	d0,d2
	bchg	d0,d2
	sub.l	-(a0),d2
	addq.w	#1,d0
	cmp.w	#keycode_length/4,d0
	bcs.s	.calcloop
	bra	long_checksum_test



decode_number_of_bits
	lea	keyfile_start+keycode_offset(pc),a0
	move.w	number_of_bits_checksum(a4),d2
	moveq	#0,d4
	moveq	#keycode_length/4-1,d0
.outerloop
	move.l	(a0)+,d3
	moveq	#31,d1
.innerloop
	move.b	d3,d4
	lsr.l	#1,d3
	subx.l	d4,d2
	dbf	d1,.innerloop
	dbf	d0,.outerloop
	bra	word_checksum_test



decode_add_nibbles
	lea	keyfile_start+keycode_offset(pc),a0
	move.w	add_nibbles_checksum(a4),d2
	moveq	#$f,d5
	moveq	#keycode_length/4-1,d0
.outerloop
	move.l	(a0)+,d3
	moveq	#7,d1
.innerloop
	move.w	d3,d4
	and.w	d5,d4
	sub.w	d4,d2
	lsr.l	#4,d3
	dbf	d1,.innerloop
	dbf	d0,.outerloop
	bra	word_checksum_test



decode_crazy_bytes
	lea	keyfile_start+keycode_offset+keycode_length(pc),a0
	move.w	crazy_bytes_checksum(a4),d2
	moveq	#keycode_length/4-1,d0
.calcloop
	move.b	-(a0),d1
	ror.w	d1,d2
	move.b	-(a0),d1
	eor.b	d1,d2
	add.b	-(a0),d2
	sub.b	-(a0),d2
	dbf	d0,.calcloop
	bra	word_checksum_test



decode_add_eor_64bit
	lea	keyfile_start+keycode_offset(pc),a0
	move.l	add_eor_64bit_checksum(a4),d2
	moveq	#keycode_length/8-1,d0
.calcloop
	move.l	(a0)+,d1
	add.l	(a0)+,d1
	eor.l	d1,d2
	dbf	d0,.calcloop
	bra	long_checksum_test



decalc_add_b_w_l
	lea	keyfile_start+keycode_offset+keycode_length(pc),a0
	move.l	add_b_w_l_checksum(a4),d2
	moveq	#keycode_length/4-1,d0
.calcloop
	move.l	-(a0),d1
	sub.b	d1,d2
	sub.w	d1,d2
	sub.l	d1,d2
	dbf	d0,.calcloop
	bra	long_checksum_test



decalc_addror1
	lea	keyfile_start+keycode_offset+keycode_length(pc),a0
	move.l	addror1_checksum(a4),d2
	moveq	#keycode_length/4-1,d0
.calcloop
	rol.l	#1,d2
	move.l	-(a0),d1
	sub.l	d1,d2
	dbf	d0,.calcloop
	bra	long_checksum_test




decalc_swap_add
	lea	keyfile_start+keycode_offset(pc),a0
	move.l	swap_add_checksum(a4),d2
	moveq	#keycode_length/4-1,d0
	moveq	#0,d3
.calcloop
	move.l	(a0)+,d1
	not.l	d3
	beq.s	.noswap
	swap	d1
.noswap	sub.l	d1,d2
	dbf	d0,.calcloop
	bra	long_checksum_test



decalc_sub_intel
	lea	keyfile_start+keycode_offset(pc),a0
	move.l	sub_intel_checksum(a4),d2
	moveq	#keycode_length/4-1,d0
.calcloop
	move.l	(a0)+,d1
	ror.w	#8,d1
	swap	d1
	ror.w	#8,d1
	add.l	d1,d2
	dbf	d0,.calcloop
	bra	long_checksum_test




decode_swap_bitchange
	lea	keyfile_start+keycode_offset+keycode_length(pc),a0
	move.l	swap_bitchange_checksum(a4),d2
	moveq	#keycode_length-1,d0
.calcloop
	swap	d2
	move.b	-(a0),d1
	bchg	d1,d2
	dbf	d0,.calcloop
	bra	long_checksum_test





decode_8byte
	lea	keyfile_start+keycode_offset(pc),a0
	clr.l	-(sp)
	clr.l	-(sp)
	move.l	addup_8byte_checksum(a4),d2
	moveq	#keycode_length/8-1,d0
.calcloop
	moveq	#7,d3
.innerloop
	move.b	(a0)+,d1
	sub.b	d3,d1
	add.b	d1,(sp,d3.w)
	dbf	d3,.innerloop
	sub.l	(sp),d2
	add.l	4(sp),d2
	dbf	d0,.calcloop
	addq.w	#8,sp
	bra	long_checksum_test




decode_two_way
	lea	keyfile_start+keycode_offset(pc),a0
	lea	keycode_length(a0),a1
	move.l	two_way_checksum(a4),d2
	moveq	#keycode_length/8-1,d0
.calcloop
	move.l	(a0)+,d1
	move.l	-(a1),d3
	sub.l	d1,d3
	sub.l	d3,d2
	dbf	d0,.calcloop
	bra	long_checksum_test









username	ds.b	username_maxlen

intnam		dc.b	'intuition.library',0
dosnam		dc.b	'dos.library',0

destfile	dc.b	'ram:miditracker-key-decoded',0
		even




;============================================================
		rsreset
		rs.l	1
dosbas		rs.l	1
intbas		rs.l	1

varsize		rs.b	0



keyfile_start
	incbin	ram:miditracker-key
keyfile_stop


;===============================================================
	section	bss_1,bss
varbase	ds.b	varsize



