const int
  inst_max=12,
  perc_max=8,
  subdiv=6,
  eHi=1,eLo=2;
enum {
  e1_4=1,e2_4,e3_4,
  e1_2,e2_2,e3_2
};

struct InstrCtrlData {
  int ampl,
      midi_ampl,
      pan;
  bool custom,
       add_chords,
       slashed_notes;
  InstrCtrlData();
}; 

struct InstProperty { // don't modify var's order
  const char *name,
             *shortname;
  int transpose,transpose2,
      clef,clef2,
      lo,hi,
      patch_nr,
      midi_nr,
      midi_pan;
};

struct PercProperty { // don't modify var's order
  const char *name;
  int perc_nr,
      midi_pan;
  const char *abc_sym;
  char abc_stem;  // note duration at abc output
};

struct Info {
  char annot; // annotation char
  const char *chord,*chord2;
  Info();
  bool occ();
  void clear();
};

extern InstProperty iprop[inst_max];
extern PercProperty pprop[perc_max];
extern InstrCtrlData ctr_data[inst_max];

extern bool debug,
            report_values;

extern int 
  abc_key,
  meter,
  nupq,   // note units per quarter note
  mv_key_nr;

extern const char *abc_outfile;
extern const float amp_arr[8];
extern struct BgrWin *help_win;

struct BgrWin* help_window(struct WinBase *topw);
void alert(const char *form,...);
void say(const char *form,...);
void insert_midi_note(int time,int time_end,int lnr,int col);
void insert_midi_perc(int time,int col);
int lnr_to_midinr(int lnr);
int midinr_to_lnr(int mnr);
Info *inform(int ind);
