#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>
#include <clib/exec_protos.h>

#include <pragma/all_lib.h>

#include <string.h>

#include </WaveTracer/WTIncl.h>
#include <QT.h>

extern WTStdMsg *MyWTStdMsg;

extern void SENDERROR(char *Fehler);

struct Handler 
   {
   UBYTE Version,Flags[3];
   char  Type[4]; // mhlr
   char  SubType[4]; //vide oder soun
   };
struct SampleDescription //stsd
   {
   UBYTE Version,Flags[3];
   LONG  NumberOfEntries ;
   LONG  Size;
   char  DataFormat[4];
   UBYTE Reserved[6];
   WORD  DRIndex;
   };
struct VideoDescription
   {
   WORD Version,Revision;
   char Vendor[4];
   LONG TemporalQuality,SpatialQuality;
   WORD Width,Height;
   LONG HorizRes,VertRes,DataSize;
   WORD FrameCount;
   char CompressorName[32];
   WORD Depth,ColorTableID;
   };
struct QTCh
   {
   LONG ChunkLength;
   char ChunkName[5];
   };
struct SampleHeader
   {
   UBYTE Version,Flags[3];
   ULONG NumberOfEntries;
   };

#define MODEsoun 1
#define MODEvide 2

#define GFXcine 1
#define GFXrpza 2

#define SOUNDraw 1

DPANHeader        DPAN;
QTCh              QTChunk;
MovieHeader       mvhd;
Handler           hdlr;
SampleDescription stsd;
VideoDescription  VideoDescr;
AudioDescription  AudioDescr;
SampleHeader      stsc,stco;
TimeToSamples     stts,*sttsMem;
LONG  MoovSize,SoundFrameNum=0,GfxFrameNum=0,l,i,LastPosition;
LONG  MyMode=MD_MONO,MyChannels=CH_CENTER;
UBYTE mdiaMode=0,SoundDataFormat=0,GFXDataFormat=0;
APTR  SoundLengthMemA=NULL,SoundOffsetMemA=NULL,GfxLengthMemA=NULL,GfxOffsetMemA=NULL;
APTR  GfxTimeMemA=NULL;
LONG  SoundLengthMemL,SoundOffsetMemL,GfxLengthMemL,GfxOffsetMemL;
LONG  SampleBeginOffset,SampleEndOffset;



void FINDOFFSETS(LONG StartFrame, LONG EndFrame)

{
FLOAT FrameSoundSize,LengthCtr,SingleSoundSize;
LONG  FrameCtr,TimeCtr;
LONG  LengthAddr,TimeAddr;
SampleLengthTable *SLTable1;
TimeToSamples     *TTSamples1;


SampleBeginOffset=0; SampleEndOffset=0; LastPosition=0;
if (SoundLengthMemA)
   {
   FrameCtr=1;
   FrameSoundSize=0;
   LengthAddr=(LONG)SoundLengthMemA;
   SLTable1=(SampleLengthTable*)LengthAddr; LengthAddr=LengthAddr+sizeof(SampleLengthTable);
   LengthCtr=SLTable1->SamplesPerChunk;

   TimeAddr=(LONG)GfxTimeMemA;
   TTSamples1=(TimeToSamples*)TimeAddr; TimeAddr=TimeAddr+sizeof(TimeToSamples);
   TimeCtr=TTSamples1->SampleCount;
   do
      {
      if (StartFrame==FrameCtr) SampleBeginOffset=(LONG)FrameSoundSize;
      SingleSoundSize=((FLOAT)TTSamples1->SampleDuration/(FLOAT)mvhd.TimeScale)*AudioDescr.SampleRate;
      FrameSoundSize=FrameSoundSize+SingleSoundSize;
      FrameCtr++;
      if (EndFrame==FrameCtr) SampleEndOffset=(LONG)FrameSoundSize;
      LengthCtr=LengthCtr-SingleSoundSize;
      if (LengthCtr<=0)
         {
         SLTable1=(SampleLengthTable*)LengthAddr; LengthAddr=LengthAddr+sizeof(SampleLengthTable);
         LengthCtr=SLTable1->SamplesPerChunk+LengthCtr;        
         }
      TimeCtr--;
      if (TimeCtr<=0)
         {
         TTSamples1=(TimeToSamples*)TimeAddr; TimeAddr=TimeAddr+sizeof(TimeToSamples);
         TimeCtr=TTSamples1->SampleCount;
         }
      }
   while (FrameCtr<=GfxFrameNum);
   if (SampleEndOffset==0) SampleEndOffset=(LONG)FrameSoundSize;
   LastPosition=SampleEndOffset-SampleBeginOffset;
   }
}



void SCANANIM(LONG StartFrame, LONG EndFrame)

{
LastPosition=0;
DPAN.Frames=0;  DPAN.FPS=0;
GfxFrameNum=0;  SoundFrameNum=0;
Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
if (GfxLengthMemA) FreeVec(GfxLengthMemA);     GfxLengthMemA=NULL;
if (GfxOffsetMemA) FreeVec(GfxOffsetMemA);     GfxOffsetMemA=NULL;
if (GfxTimeMemA) FreeVec(GfxTimeMemA);         GfxTimeMemA=NULL;
if (SoundLengthMemA) FreeVec(SoundLengthMemA); SoundLengthMemA=NULL;
if (SoundOffsetMemA) FreeVec(SoundOffsetMemA); SoundOffsetMemA=NULL;
do
   {
   l=Read(MyWTStdMsg->ActFHandle,&QTChunk,8);
   if (strncmp(QTChunk.ChunkName,"moov",4))
      {
      if (QTChunk.ChunkLength<=8)
         {
         MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
         return;
         }
      Seek(MyWTStdMsg->ActFHandle,QTChunk.ChunkLength-8,OFFSET_CURRENT);                  
      }
   }
while ((l==8) && (strncmp(QTChunk.ChunkName,"moov",4)));
if (l==8)
   {
   MoovSize=QTChunk.ChunkLength;
   do
      {
      l=Read(MyWTStdMsg->ActFHandle,&QTChunk,8);                                       
      MoovSize=MoovSize-QTChunk.ChunkLength;
      if (l==8)
         {
         if (!strncmp(QTChunk.ChunkName,"mvhd",4))
            {
            QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,&mvhd,sizeof(MovieHeader));
            }
         else if (!strncmp(QTChunk.ChunkName,"trak",4)) // ???
            {
            MoovSize=MoovSize+QTChunk.ChunkLength-8;
            QTChunk.ChunkLength=8;
            }
         else if (!strncmp(QTChunk.ChunkName,"mdia",4))
            {
            MoovSize=MoovSize+QTChunk.ChunkLength-8;
            QTChunk.ChunkLength=8;
            }
         else if (!strncmp(QTChunk.ChunkName,"hdlr",4))
            {                     
            QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,&hdlr,sizeof(Handler));
            if (!strncmp(hdlr.Type,"mhlr",4))
               {
               if (!strncmp(hdlr.SubType,"vide",4)) mdiaMode=MODEvide
               else if (!strncmp(hdlr.SubType,"soun",4)) mdiaMode=MODEsoun
               else mdiaMode=0;
               } 
            }
         else if (!strncmp(QTChunk.ChunkName,"minf",4))
            {
            MoovSize=MoovSize+QTChunk.ChunkLength-8;
            QTChunk.ChunkLength=8;
            }
         else if (!strncmp(QTChunk.ChunkName,"stbl",4))
            {
            MoovSize=MoovSize+QTChunk.ChunkLength-8;
            QTChunk.ChunkLength=8;
            }
         else if (!strncmp(QTChunk.ChunkName,"stsc",4))
            {
            QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,&stsc,sizeof(SampleHeader));
            if (mdiaMode==MODEsoun)
               {
               SoundLengthMemA=AllocVec(stsc.NumberOfEntries*12,0);
               SoundLengthMemL=stsc.NumberOfEntries*12;
               if (SoundLengthMemA) QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,SoundLengthMemA,stsc.NumberOfEntries*12)
               else 
                  {
                  MyWTStdMsg->Flags=MDE_NO_MEMORY;
                  return;
                  }
               }
            else if (mdiaMode==MODEvide)
               {
               GfxLengthMemA=AllocVec(stsc.NumberOfEntries*12,0);
               GfxLengthMemL=stsc.NumberOfEntries*12;
               if (GfxLengthMemA) QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,GfxLengthMemA,stsc.NumberOfEntries*12)
               else
                  {
                  MyWTStdMsg->Flags=MDE_NO_MEMORY;
                  return;
                  }
               }
            }
         else if (!strncmp(QTChunk.ChunkName,"stco",4))
            {
            QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,&stco,sizeof(SampleHeader));
            if (mdiaMode==MODEsoun)
               {          
               SoundOffsetMemA=AllocVec(stco.NumberOfEntries*4,0);
               SoundOffsetMemL=stco.NumberOfEntries*4;
               if (SoundOffsetMemA) QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,SoundOffsetMemA,stco.NumberOfEntries*4)
               else
                  {
                  MyWTStdMsg->Flags=MDE_NO_MEMORY;
                  return;
                  }                  
               }
            else if (mdiaMode==MODEvide)
               {
               GfxOffsetMemA=AllocVec(stco.NumberOfEntries*4,0);
               GfxOffsetMemL=stco.NumberOfEntries*4;
               if (GfxOffsetMemA) QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,GfxOffsetMemA,stco.NumberOfEntries*4)
               else
                  {
                  MyWTStdMsg->Flags=MDE_NO_MEMORY;
                  return;
                  }
               }
            }                         
         else if (!strncmp(QTChunk.ChunkName,"stsd",4))
            {
            QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,&stsd,sizeof(SampleDescription));
            if (mdiaMode==MODEsoun)
               {
               if (!strncmp(stsd.DataFormat,"raw ",4)) SoundDataFormat=SOUNDraw
               else
                  {
                  SENDERROR("Unknown audiodata-format!");
                  MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
                  return;
                  }
               QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,&AudioDescr,sizeof(AudioDescription));
               if (AudioDescr.ChannelNum==1)
                  {
                  MyChannels=CH_CENTER;
                  MyMode=MD_MONO;
                  }
               else if (AudioDescr.ChannelNum==2)
                  {
                  MyChannels=CH_LEFT+CH_RIGHT;
                  MyMode=MD_STEREO;
                  }
               else
                  {
                  SENDERROR("Too much audiochannels!");
                  MyWTStdMsg->Flags=MDE_ERROR;               
                  return;
                  }
               if (AudioDescr.SampleSize>8)
                  {
                  SENDERROR("Unknown sampleresolution!");
                  MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
                  return;
                  }
               }
            else if (mdiaMode==MODEvide)
               {
               if (!strncmp(stsd.DataFormat,"cine",4)) SoundDataFormat=GFXcine
               else if (!strncmp(stsd.DataFormat,"rpza",4)) SoundDataFormat=GFXrpza;
               QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,&VideoDescr,sizeof(VideoDescription));
               }
            }                     
         else if (!strncmp(QTChunk.ChunkName,"stts",4))
            {
            QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,&stsc,sizeof(SampleHeader));
            if (mdiaMode==MODEvide)
               {
               GfxTimeMemA=AllocVec((stsc.NumberOfEntries+2)*sizeof(TimeToSamples),0);
               if (!GfxTimeMemA)
                  {
                  MyWTStdMsg->Flags=MDE_NO_MEMORY;
                  return;
                  }
               }
            for (i=1; i<=stsc.NumberOfEntries; i++)
               {                           
               QTChunk.ChunkLength=QTChunk.ChunkLength-Read(MyWTStdMsg->ActFHandle,&stts,sizeof(TimeToSamples));
               if (mdiaMode==MODEsoun) SoundFrameNum=SoundFrameNum+stts.SampleCount
               else if (mdiaMode==MODEvide)
                  {
                  GfxFrameNum=GfxFrameNum+stts.SampleCount;
                  sttsMem=(TimeToSamples*)((LONG)GfxTimeMemA+((i-1)*sizeof(TimeToSamples)));
                  *sttsMem=stts;
                  }
               }
            }                                                           
         if (l==8) Seek(MyWTStdMsg->ActFHandle,QTChunk.ChunkLength-8,OFFSET_CURRENT);                  
         }
      }
   while ((l==8) && (MoovSize>0));
   DPAN.Frames=GfxFrameNum;
   if (LastPosition==0) LastPosition=SoundFrameNum;
   if (SoundFrameNum==0)
      {
      SENDERROR("No sounddata found!");
      MyWTStdMsg->Flags=MDE_ERROR;
      return;
      }
   MyWTStdMsg->Flags=MDE_READY;
   FINDOFFSETS(StartFrame,EndFrame);   
   }
else MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
};

