type Plane =Array[1..128] of long;
type Plane2=Array[1..84] of long;
type KnopfPlane=Array[1..30] of long;
type ButtonPlane=Array[1..24] of long;
type CalcPlane=Array[1..26] of long;
type KnobPlane=Array[1..22] of long;


var KnobImg,CalcImg                             :Image;
var GImg                                        :array[1..6] of Image;
var ButtonImg                                   :array[1..4] of Image;
var KnobMem,CalcMem                             :long;
var GMem                                        :array[1..6] of long;
var ButtonMem                                   :array[1..4] of long;
var IDt                                         :^Plane;
var KnopfIDt                                    :^KnopfPlane;
var ButtonIDt                                   :^ButtonPlane;
var CalcIDt                                     :^CalcPlane;
var KnobIDt                                     :^KnobPlane;
var Notes                                       :BlueNote;

var FRTit,PathFR,FRShow,DirFR,FileFR            :string[90];



procedure ERRORMSG(Tx1,Tx2 :str);

var f           :Text;

begin
   DisplayBeep(NIL);
   reset(f,'CON:0/20/640/100/WaveTracer & DigitalSongStudio');
   if IOResult<>0 then exit;
   writeln(f,Tx1);
   writeln(f,Tx2);
   delay(300);
   close(f);
end;



function INITIMG:boolean;


begin;
   INITIMG:=false;
   for i:=1 to 6 do begin
      GMem[i]:=AllocMem(sizeof(Plane),MEMF_CHIP+MEMF_CLEAR);
      if GMem[i]=0 then exit;
   end;

   IDt:=ptr(GMem[1]);
   IDt^:=Plane(%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %01111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,

               %11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %10000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000);
   GImg[1]:=Image(0,0,128,16,2,IDt,3,1,NIL);
   IDt:=ptr(GMem[2]);
   IDt^:=Plane(%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000011000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000011000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000011000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000001111111111111000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %01111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,

               %11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000011111111111111000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000011000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000011000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000011000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000010000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %10000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000);
   GImg[2]:=Image(0,0,128,16,2,IDt,3,1,NIL);
   IDt:=ptr(GMem[3]);
   IDt^:=Plane2(%00000000000000000000000000000000,%00000000000000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000011111111111111111111111111,%11100000011000000000000000000000,
                %00000011111111111111111111111111,%11110000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011110000000000000000000000,%01111000011000000000000000000000,
                %00000011110000000000000111100000,%01111000011000000000000000000000,
                %00000011110000000000011000011000,%01111000011000000000000000000000,
                %00000011110000111111100000011000,%01111000011000000000000000000000,
                %00000011110000111000011111111000,%01111000011000000000000000000000,
                %00000011110000111000000000011000,%01111000011000000000000000000000,
                %00000011110000111111111111111000,%01111000011000000000000000000000,
                %00000011110000000000000000000000,%01111000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %01111111111111111111111111111111,%11111111111000000000000000000000,

                %11111111111111111111111111111111,%11111111111000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000011111111000000000000000001,%11100000000000000000000000000000,
                %11000011111111000000000001111001,%11110000000000000000000000000000,
                %11000011111111000000000001111001,%11111000000000000000000000000000,
                %11000011111111000000000001111001,%11111000000000000000000000000000,
                %11000011111111000000000001111001,%11111000000000000000000000000000,
                %11000011111111000000000000000001,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111000011111,%11111000000000000000000000000000,
                %11000011111111111111100111100111,%11111000000000000000000000000000,
                %11000011111111000000011111100111,%11111000000000000000000000000000,
                %11000011111111000111100000000111,%11111000000000000000000000000000,
                %11000010011111000111111111100111,%11001000000000000000000000000000,
                %11000010011111000000000000000111,%11001000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %10000000000000000000000000000000,%00000000000000000000000000000000);
   GImg[3]:=Image(0,0,64,21,2,IDt,3,1,NIL);
   IDt:=ptr(GMem[4]);
   IDt^:=Plane2(%11111111111111111111111111111111,%11111111111000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000011111111111111111111111111,%11100000000000000000000000000000,
                %11000011111111111111111111111111,%11110000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011111111111111111111111111,%11111000000000000000000000000000,
                %11000011110000000000000000000000,%01111000000000000000000000000000,
                %11000011110000000000000111100000,%01111000000000000000000000000000,
                %11000011110000000000011000011000,%01111000000000000000000000000000,
                %11000011110000111111100000011000,%01111000000000000000000000000000,
                %11000011110000111000011111111000,%01111000000000000000000000000000,
                %11000011110000111000000000011000,%01111000000000000000000000000000,
                %11000011110000111111111111111000,%01111000000000000000000000000000,
                %11000011110000000000000000000000,%01111000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %10000000000000000000000000000000,%00000000000000000000000000000000,

                %00000000000000000000000000000000,%00000000000000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000011110000000000000000011111,%11100000011000000000000000000000,
                %00000011110000000000011110011111,%11110000011000000000000000000000,
                %00000011110000000000011110011111,%11111000011000000000000000000000,
                %00000011110000000000011110011111,%11111000011000000000000000000000,
                %00000011110000000000011110011111,%11111000011000000000000000000000,
                %00000011110000000000000000011111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000011111111111111111000011111,%11111000011000000000000000000000,
                %00000011111111111111100111100111,%11111000011000000000000000000000,
                %00000011111111000000011111100111,%11111000011000000000000000000000,
                %00000011111111000111100000000111,%11111000011000000000000000000000,
                %00000010011111000111111111100111,%11001000011000000000000000000000,
                %00000010011111000000000000000111,%11001000011000000000000000000000,
                %00000011111111111111111111111111,%11111000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %00000000000000000000000000000000,%00000000011000000000000000000000,
                %01111111111111111111111111111111,%11111111111000000000000000000000);
   GImg[4]:=Image(0,0,64,21,2,IDt,3,1,NIL);
   IDt:=ptr(GMem[5]);
   IDt^:=Plane(%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000100000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000001100000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000011111111111110000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000110000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000001100000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000110000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000011000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000001100000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000100000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000011,
               %01111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,

               %11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,%11111111111111111111111111111111,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000001000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000011000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000011000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000011000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000111111111111000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %11000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,
               %10000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000,%00000000000000000000000000000000);
   GImg[5]:=Image(0,0,128,16,2,IDt,3,1,NIL);
   IDt:=ptr(GMem[6]);
   IDt^:=Plane2(%00000000000000000000000000000000,%00000000000000000000000000000000,
                %00110000000000000000000000000000,%00000000000000000000000000000000,
                %00110000000001010100000000000000,%00000000000000000000000000000000,
                %00110000000101010101000000000000,%00000000000000000000000000000000,
                %00110000010101010101010000000000,%00000000000000000000000000000000,
                %00110000010101010101010000000000,%00000000000000000000000000000000,
                %00110001010101010101010100000000,%00000000000000000101010000000000,
                %00110001010101010101010100000000,%00000000000000010101010100000000,
                %00110101010101010101010101000000,%00000000000000010101010100000000,
                %00110101010101010101010101000000,%00000000000001010101010101000000,
                %00111111111111111111111111111111,%11111111111111111111111111111111,
                %00110000000000000000000000010101,%01010101010100000000000000000000,
                %00110000000000000000000000010101,%01010101010100000000000000000000,
                %00110000000000000000000000010101,%01010101010100000000000000000000,
                %00110000000000000000000000000101,%01010101010000000000000000000000,
                %00110000000000000000000000000101,%01010101010000000000000000000000,
                %00110000000000000000000000000001,%01010101000000000000000000000000,
                %00110000000000000000000000000000,%01010100000000000000000000000000,
                %00110000000000000000000000000000,%00000000000000000000000000000000,
                %00110000000000000000000000000000,%00000000000000000000000000000000,
                %11110000000000000000000000000000,%00000000000000000000000000000000,

                %11110000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000001010100000000000000,%00000000000000000000000000000000,
                %11000000000101010101000000000000,%00000000000000000000000000000000,
                %11000000010101010101010000000000,%00000000000000000000000000000000,
                %11000000010101010101010000000000,%00000000000000000000000000000000,
                %11000001010101010101010100000000,%00000000000000000101010000000000,
                %11000001010101010101010100000000,%00000000000000010101010100000000,
                %11000101010101010101010101000000,%00000000000000010101010100000000,
                %11000101010101010101010101000000,%00000000000001010101010101000000,
                %11000101010101010101010101000000,%00000000000001010101010101000000,
                %11001111111111111111111111111111,%11111111111111111111111111111111,
                %11000000000000000000000000010101,%01010101010100000000000000000000,
                %11000000000000000000000000010101,%01010101010100000000000000000000,
                %11000000000000000000000000000101,%01010101010000000000000000000000,
                %11000000000000000000000000000101,%01010101010000000000000000000000,
                %11000000000000000000000000000001,%01010101000000000000000000000000,
                %11000000000000000000000000000000,%01010100000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %11000000000000000000000000000000,%00000000000000000000000000000000,
                %00000000000000000000000000000000,%00000000000000000000000000000000);
   GImg[6]:=Image(0,0,64,21,2,IDt,3,1,NIL);
   for i:=1 to 4 do begin
      ButtonMem[i]:=AllocMem(sizeof(ButtonPlane),MEMF_CHIP+MEMF_CLEAR);
      if ButtonMem[i]=0 then exit;
   end;
   ButtonIDt:=ptr(ButtonMem[1]);
   ButtonIDt^:=ButtonPlane(%00000000000000000000000000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %01111111111111111111100000000000,

                           %11111111111111111111100000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %10000000000000000000000000000000);
   ButtonImg[1]:=Image(0,0,21,12,2,ButtonIDt,3,1,NIL);
   ButtonIDt:=ptr(ButtonMem[2]);
   ButtonIDt^:=ButtonPlane(%00000000000000000000000000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000000000000010001100000000000,
                           %00000000000000100001100000000000,
                           %00000000000001000001100000000000,
                           %00000001000010000001100000000000,
                           %00000000100100000001100000000000,
                           %00000000001000000001100000000000,
                           %00000000010000000001100000000000,
                           %00000000000000000001100000000000,
                           %01111111111111111111100000000000,

                           %11111111111111111111100000000000,
                           %11000000000000000000000000000000,
                           %11000000000000110000000000000000,
                           %11000000000001100000000000000000,
                           %11000000000011000000000000000000,
                           %11000000000110000000000000000000,
                           %11001100001100000000000000000000,
                           %11000110011000000000000000000000,
                           %11000011110000000000000000000000,
                           %11000001100000000000000000000000,
                           %11000000000000000000000000000000,
                           %10000000000000000000000000000000);
   ButtonImg[2]:=Image(0,0,21,12,2,ButtonIDt,3,1,NIL);
   ButtonIDt:=ptr(ButtonMem[3]);
   ButtonIDt^:=ButtonPlane(%00000000000000000000000000000000,
                           %00000000000000000001100000000000,
                           %00000000000100000001100000000000,
                           %00000000000111000001100000000000,
                           %00000000000110110001100000000000,
                           %00000000000110011001100000000000,
                           %00000000000110001101100000000000,
                           %00000011111110001101100000000000,
                           %00000111111110000001100000000000,
                           %00000011111100000001100000000000,
                           %00000000000000000001100000000000,
                           %01111111111111111111100000000000,

                           %11111111111111111111100000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %11011000000001100000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %10000000000000000000000000000000);
   ButtonImg[3]:=Image(0,0,21,12,2,ButtonIDt,3,1,NIL);
   ButtonIDt:=ptr(ButtonMem[4]);
   ButtonIDt^:=ButtonPlane(%11111111111111111111100000000000,
                           %11000000000000000000000000000000,
                           %11000001111111000000000000000000,
                           %11000111111111000000000000000000,
                           %11001111111111110000000000000000,
                           %11001111111111110000000000000000,
                           %11001111111111110000000000000000,
                           %11001111111111110000000000000000,
                           %11000111111111000000000000000000,
                           %11000000000000000000000000000000,
                           %11000000000000000000000000000000,
                           %10000000000000000000000000000000,

                           %00000000000000000000000000000000,
                           %00000000000000000001100000000000,
                           %00000000000000000001100000000000,
                           %00000001111111110001100000000000,
                           %00000011111111111001100000000000,
                           %00000011111111111001100000000000,
                           %00000011111111111001100000000000,
                           %00000011111111111001100000000000,
                           %00000001111111110001100000000000,
                           %00000001111111000001100000000000,
                           %00000000000000000001100000000000,
                           %01111111111111111111100000000000);
   ButtonImg[4]:=Image(0,0,21,12,2,ButtonIDt,3,1,NIL);

   KnobMem:=AllocMem(sizeof(KnobPlane),MEMF_CHIP+MEMF_CLEAR);
   if KnobMem=0 then exit;
   KnobIDt:=ptr(KnobMem);
   KnobIDt^:=KnobPlane(%00000000000000000000000000000001,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %00000000000000001000000000000111,
                       %01111111111111111111111111111111,

                       %11111111111111111111111111111111,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11100000000000010000000000000000,
                       %11000000000000010000000000000000);
   KnobImg:=Image(0,0,32,11,2,KnobIDt,3,0,NIL);
   CalcMem:=AllocMem(sizeof(CalcPlane),MEMF_CHIP+MEMF_CLEAR);
   if CalcMem=0 then exit;
   CalcIDt:=ptr(CalcMem);
   CalcIDt^:=CalcPlane(%00000000000000000000000000000000,
                       %00000000000000000000000000000011,
                       %00000000001110001000000001110011,
                       %00000000000001001000000000001011,
                       %00000100000001001010001000001011,
                       %00000000000001001001010000001011,
                       %00011111001110001000100001110011,
                       %00000000010000001001010010000011,
                       %00000100010000001010001010000011,
                       %00000000010000001000000010000011,
                       %00000000001110001000000001110011,
                       %00000000000000000000000000000011,
                       %01111111111111111111111111111111,

                       %11111111111111111111111111111111,
                       %11000000000000000000000000000000,
                       %11000000001110010000000001110000,
                       %11000000000001010000000000001000,
                       %11000100000001010010001000001000,
                       %11000000000001010001010000001000,
                       %11011111001110010000100001110000,
                       %11000000010000010001010010000000,
                       %11000100010000010010001010000000,
                       %11000000010000010000000010000000,
                       %11000000001110010000000001110000,
                       %11000000000000000000000000000000,
                       %10000000000000000000000000000000);
   CalcImg:=Image(0,0,32,13,2,CalcIDt,3,0,NIL);
   MyWTImg:=WTImages(true,Share,NIL,^KnobImg,^CalcImg,^GImg[1],^GImg[2],^GImg[3],^GImg[4],
                     ^GImg[5],NIL,^ButtonImg[1],^ButtonImg[2],^ButtonImg[3],NIL,NIL,NIL,^Notes,
                     ^OKKnopfTx,^CKnopfTx);

   INITIMG:=true;
end;



procedure DRAWLINE(Wind :Window; Left,Top,Right,Bottom,Color :word);

begin
   SetAPen(Wind.RPort,Color);
   Move(Wind.RPort,Left,Top); Draw(Wind.RPort,Right,Bottom);
end;



procedure WRITE(LEdge,TEdge :word; Stpen,DMode :byte; Wind :Window; txt :str);

var IT1         :IntuiText;

begin
   IT1:=IntuiText(StPen  ,0,0,LEdge  ,TEdge  ,^CustomTA,txt,NIL);
   if DMode=3 then begin
      IT1.LeftEdge:=LEdge-IntuiTextLength(^IT1) div 2;
   end else if DMode=4 then begin
      IT1.LeftEdge:=LEdge-IntuiTextLength(^IT1);
   end;
   PrintIText(Wind.RPort,^IT1,0,0);
end;



procedure MAKEBORDER(Wind :Window; LEdge,TEdge,REdge,BEdge :word; Color :byte);

begin
   SetAPen(Wind.RPort,abs(Color-2));
   Move(Wind.RPort,LEdge+1,TEdge); Draw(Wind.RPort,LEdge+1,BEdge-1);
   Draw(Wind.RPort,LEdge,BEdge);   Draw(Wind.RPort,LEdge,TEdge);
   Draw(Wind.RPort,REdge,TEdge);
   SetAPen(Wind.RPort,abs(Color-1));
   Move(Wind.RPort,LEdge+1,BEdge); Draw(Wind.RPort,REdge,BEdge);
   Draw(Wind.RPort,REdge,TEdge+1); Draw(Wind.RPort,REdge-1,TEdge+1);
   Draw(Wind.RPort,REdge-1,BEdge);
end;



procedure TASKMESSAGE(TXT :str);

begin
   SetAPen(MyWindow^.RPort,3); RectFill(MyWindow^.RPort,220,40,420,58);
   MAKEBORDER(MyWindow^,220,40,420,58,POSITIVE);
   WRITE(320,43,1,3,MyWindow^,Txt);
end;



function TASKREQUEST(Text1,Text2 :str; Gad1,Gad2,Gad3 :str):byte;

var TRWindow                    :^Window;
var x,y,GadCode,RawCode,i,j     :byte;
var TRKnopf                     :array[1..3] of Gadget;
var TRKnopfTx                   :array[1..3] of IntuiText;
var Gad                         :array[1..3] of str;
var TEdge                       :integer;

begin
   TASKREQUEST:=3;
   TEdge:=MyScreen^.MouseY-80;
   if TEdge+100>MyScreen^.Height then TEdge:=MyScreen^.Height-100;
   if TEdge<20 then TEdge:=20;
   NeuWindow:=NewWindow(100,TEdge,440,87,1,0,RAWKEY+GADGETUP,ACTIVATE+WINDOWDRAG+
                        WINDOWDEPTH+SIMPLE_REFRESH,NIL,NIL,WTVersion,MyScreen,Nil,440,87,
                        440,87,CUSTOMSCREEN);
   TRWindow:=OpenWindow(^Neuwindow);
   If TRWindow=Nil Then begin
      DisplayBeep(NIL);
      exit;
   end;
   SetAPen(TRWindow^.RPort,3);
   RectFill(TRWindow^.RPort,10,20,430,60);
   MAKEBORDER(TRWindow^,10,20,430,60,POSITIVE);
   WRITE(220,26,1,3,TRWindow^,Text1);
   WRITE(220,43,1,3,TRWindow^,Text2);
   Gad[1]:=Gad1; Gad[2]:=Gad2; Gad[3]:=Gad3;
   for i:=1 to 3 do begin
      TRKnopf[i]:=Gadget(NIL,i*145-134,65,128,17,GADGHCOMP+GADGIMAGE,
                         $1,BOOLGADGET,^GImg[1],NIL,^TRKnopfTx[i],0,Nil,i,0);
      TRKnopfTx[i]:=IntuiText(3,0,0,2,2,^CustomTA,Gad[i],NIL);
      l:=64-(IntuiTextLength(^TRKnopfTx[i]) div 2);
      TRKnopfTX[i].LeftEdge:=l;
      if Gad[i]<>'' then AddGadget(TRWindow,^TRKnopf[i],NIL);
   end;
   RefreshGadgets(TRWindow^.FirstGadget,TRWindow,NIL);
   RefreshWindowFrame(TRWindow);
   ScreenToFront(MyScreen);
   repeat
      GadCode:=0; RawCode:=0;
      IMsg:=Wait_Port(TRWindow^.UserPort);
      If IMsg<>Nil Then begin
         IMsg:=Get_Msg(TRWindow^.UserPort);
         if IMsg^.class=GADGETUP then begin
            XGadget:=IMsg^.IAddress;
            GadCode:=XGadget^.GadgetID;
         end;
         if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
         Reply_Msg(IMsg)
      End;

      case RawCode of
         69: if Gad[1]='' then RawCode:=0;
         64: if Gad[2]='' then RawCode:=0;
         68: if Gad[3]='' then RawCode:=0;
         otherwise RawCode:=0;
      end;

   until (GadCode in [1..3]) or (RawCode>0);
   if RawCode>0 then begin
      case RawCode of
         69: begin
                TRKnopf[1].flags:=TRKnopf[1].flags+SELECTED;
                TASKREQUEST:=1;
             end;
         64: begin
                TRKnopf[2].flags:=TRKnopf[2].flags+SELECTED;
                TASKREQUEST:=2;
             end;
         68: TRKnopf[3].flags:=TRKnopf[3].flags+SELECTED;
      end;
      RefreshGadgets(TRWindow^.FirstGadget,TRWindow,NIL);
      delay(5);
   end else TASKREQUEST:=GadCode;
   CloseWindow(TRWindow);
   GadCode:=0;
end;



function OPENDWIN(Height,TopEdge :word; var DWindow :p_Window; WTitle :str;):boolean;

var x,y                 :byte;

begin
   if TopEdge=0 then TopEdge:=MyScreen^.Height-Height;
   NeuWindow:=NewWindow(0,TopEdge,640,Height,3,1,RAWKEY+GADGETDOWN+GADGETUP+MOUSEMOVE+
                        MOUSEBUTTONS,SMART_REFRESH+ACTIVATE+_REPORTMOUSE+WINDOWDRAG,
                        Nil,NIL,WTVersion,MyScreen,Nil,640,Height,640,Height,CUSTOMSCREEN);
   DWindow:=OpenWindow(^NeuWindow);
   If DWindow=Nil Then begin
      OPENDWIN:=false; DisplayBeep(NIL); exit;
   end else OPENDWIN:=true;
   WRITE(320,19,2,3,DWindow^,WTitle);
   RefreshWindowFrame(DWindow);
end;



function LEAVEDEF(RawCode,GadCode,OKGad,EscGad :byte):boolean;

begin
   LEAVEDEF:=true;
   if RawCode=69 then begin
      DKnopf[EscGad].flags:=DKnopf[EscGad].flags+SELECTED;
      if Opos>1 then Opos:=OPos-1;
      LEAVEDEF:=false;
   end else if RawCode=68 then DKnopf[OKGad].flags:=DKnopf[OKGad].flags+SELECTED;
   RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
   if RawCode in [68,69] then repeat
      IMsg:=Get_Msg(DWindow^.UserPort);
      if IMsg<>NIL then begin
         if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
         Reply_Msg(IMsg)
      end;
   until RawCode in [196,197];
   CloseWindow(DWindow);
   if GadCode=EscGad then LEAVEDEF:=False;
end;



function SELECTLIST(StDKnopfText,Gads,SelectedGad :byte; LEdge,TEdge :word; CGad :Gadget):byte;

var CWindow             :^Window;
var CKnopf              :array [1..8] of Gadget;

begin
   SELECTLIST:=SelectedGad;
   TEdge:=DWindow^.TopEdge+TEdge;
   if TEdge+(CGad.Height*Gads)>MyScreen^.Height then TEdge:=MyScreen^.Height-(CGad.Height*Gads);
   NeuWindow:=NewWindow(LEdge,TEdge,CGad.Width,CGad.Height*Gads,3,1,GADGETDOWN+GADGETUP,
                        SMART_REFRESH+ACTIVATE+BORDERLESS,Nil,Nil,'',MyScreen,Nil,
                        CGad.Width,CGad.Height*Gads,CGad.Width,CGad.Height*Gads,CUSTOMSCREEN);
   CWindow:=OpenWindow(^Neuwindow);
   If CWindow=Nil Then begin
      DisplayBeep(NIL);
      exit;
   end;
   for i:=1 to Gads do begin
      CKnopf[i]:=Gadget(NIL,0,pred(i)*16,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,
                        ^GImg[1],NIL,^DKnopfTx[StDKnopfText+pred(i)],0,Nil,i,0);
      AddGadget(CWindow,^CKnopf[i],NIL);
   end;
   RefreshGadgets(CWindow^.FirstGadget,CWindow,NIL);
   IMsg:=Wait_Port(CWindow^.UserPort);
   If IMsg<>Nil Then begin
      IMsg:=Get_Msg(CWindow^.UserPort);
      if IMsg^.class=GADGETUP then begin
         XGadget:=IMsg^.IAddress;
         SELECTLIST:=XGadget^.GadgetID;
      end;
      Reply_Msg(IMsg)
   End;
   CloseWindow(CWindow);
end;



procedure CLEARPORT(PortName :str);

var BadPort     :^MsgPort;

begin
   BadPort:=FindPort(PortName);
   while BadPort<>NIL do begin
      RemPort(BadPort);
      BadPort:=FindPort(PortName);
   end;
end;



function PORTACTIVE(PortName :str):boolean;

var BadPort     :^MsgPort;

begin
   BadPort:=FindPort(PortName);
   if BadPort=NIL then PORTACTIVE:=false else PORTACTIVE:=true;
end;



function ALLOCPORT(PortName,ModulName :str):ptr;

var MyMsgPort   :^MsgPort;

begin
   ALLOCPORT:=NIL;   CLEARPORT(PortName);
   case dark of
      0: s:='run >NIL: "'+ModulName+'" >NIL:';
      1: s:='run '+ModulName+' >PRT:';
      2: s:='run "'+ModulName+'"';
   end;
   i:=Execute(s,0,0); i:=0;
   delay(5);
   repeat
     MyMsgPort:=FindPort(PortName);
     i:=i+1; delay(1);
   until (MyMsgPort<>NIL) or (i=550);
   ALLOCPORT:=MyMsgPort;
end;



function FILEREQ:boolean;

var Freq                               :FileRequester;
var DStamp                             :DateStamp;
var fontkeks1fr,fontkeks2fr            :word;
var longfr                             :long;

begin
   Freq:=FileRequester(0,FRTit,DirFR,FileFR,PathFR,MyWindow,1,MyScreen^.Height div 20,35,15,
                       FRQHIDEWILDS+FRQABSOLUTEXY,
                       2,1,3,0,0,0,0,3,0,0,0,0,2,'0',DStamp,20,10,fontkeks1fr,
                       fontkeks2fr,NIL,'*.p|*.backup|*.data',FRShow,0,0,0,0,0,0,0,0,NIL,NIL,NIL,
                       '',NIL,0,0,0,0);
   longfr:=FileRequest(^Freq);
   if (longfr=1) then FileReq:=true
   else begin
      FileReq:=false;
      PathFR:='';
   end;
end;



function GETNOTEFREQ(XWindow :p_Window):word;

var NWindow             :^Window;
var NKnopf              :array[0..6,1..12] of Gadget;
var NKnopfTx            :array[0..6,1..12] of IntuiText;
var TEdge,LEdge         :word;

begin
   GETNOTEFREQ:=0;
   TEdge:=MyScreen^.MouseY-55;
   if TEdge+100>MyScreen^.Height then TEdge:=MyScreen^.Height-100;
   if TEdge<1 then TEdge:=1;
   LEdge:=MyScreen^.MouseX-160;
   if LEdge+330>635 then LEdge:=635-330;
   if LEdge<1 then LEdge:=1;
   NeuWindow:=NewWindow(LEdge,TEdge,327,100,0,0,GADGETUP,SMART_REFRESH+ACTIVATE+BORDERLESS,
                        NIL,NIL,'',MyScreen,NIL,1,1,640,256,CUSTOMSCREEN);
   NWindow:=OpenWindow(^NeuWindow);
   if NWindow=NIL then begin
      DisplayBeep(NIL); exit;
   end;
   NWindow^.BorderTop:=0;
   SetAPen(NWindow^.RPort,0); RectFill(NWindow^.RPort,0,0,327,101);
   MAKEBORDER(NWindow^,0,0,326,99,POSITIVE);
   for j:=0 to 6 do for i:=1 to 12 do begin
      NKnopf[j,i]:=Gadget(NIL,pred(i)*27+2,j*14+1,26,14,GADGHCOMP,$1,BOOLGADGET,NIL,NIL,
                          ^NKnopfTx[j,i],0,NIL,pred(i)+12*j,0);
      NKnopfTx[j,i]:=IntuiText(2,0,0,2,2,^CustomTA,Notes.bn_NoteName[j,i],NIL);
      if Notes.bn_NoteName[j,i][3] in ['b','#'] then NKnopfTx[j,i].FrontPen:=1;
      AddGadget(NWindow,^NKnopf[j,i],NIL);
   end;
   RefreshGadgets(NWindow^.FirstGadget,NWindow,NIL);
   repeat
      GadCode:=100;
      IMsg:=Wait_Port(NWindow^.UserPort);
      If IMsg<>Nil Then begin
         IMsg:=Get_Msg(NWindow^.UserPort);
         if IMsg^.Class=GADGETUP then begin
            XGadget:=IMsg^.IAddress;
            GadCode:=XGadget^.GadgetID;
         end;
         if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
         Reply_Msg(IMsg)
      End;
   until Gadcode<>100;
   GETNOTEFREQ:=round(Notes.bn_SampleFreq[GadCode div 12,succ(GadCode)-(GadCode div 12 * 12)]);
   Notes.bn_PosX:=GadCode div 12; Notes.bn_PosY:=succ(GadCode)-(GadCode div 12 * 12);
   while NWindow^.FirstGadget<>NIL do RemoveGadgets(NWindow,NWindow^.FirstGadget);
   CloseWindow(NWindow);
end;



procedure UNPACK(UnPackedD,PackedD,Laenge :long);

var Anfang              :long;
var Anz,Inh,Dest        :^byte;
var i                   :integer;

begin
   Anfang:=UnPackedD;
   repeat
      Anz:=ptr(PackedD);   PackedD:=PackedD+1;
      if Anz^>127 then begin
         Anz^:=Anz^-127;
         CopyMem(PackedD,UnPackedD,Anz^);
         PackedD:=PackedD+Anz^;
         UnPackedD:=UnPackedD+Anz^;
      end else begin
         Inh:=ptr(PackedD);   PackedD:=PackedD+1;
         for i:=1 to Anz^ do begin
            Dest:=Ptr(UnPackedD); UnPackedD:=UnPackedD+1;
            Dest^:=Inh^;
         end;
      end;
   until (UnPackedD>=PackedD) or (UnPackedD>=Anfang+Laenge);
end;
