#ifndef WTINCL_MOD
#define WTINCL_MOD

#define TEXTS=400;

            /*** MDC_ MoDuleCommands ***/
#define MDC_ASKREADY 1
#define MDC_DEFINEIT 2
#define MDC_CONFIG   3
#define MDC_DOIT     8

           /*** MDE_ MoDuleErrors ***/
#define MDE_READY                1
#define MDE_CANCELLED            2
#define MDE_FILEERROR            3
#define MDE_ERROR                4
#define MDE_NOTMYFORMAT          8
#define MDE_WRONG_MODULEVERSION 16
#define MDE_NO_MEMORY           32
#define MDE_BREAK               64
#define MDE_CHANNELERROR       128
#define MDE_NICE_SOFTMOD       512

            /*** WTM_ WaveTracerMessage ***/
#define WTM_TASKREQ             0x0001
#define WTM_FILEREQ             0x0002
#define WTM_GETABORTINFO        0x0003
#define WTM_TASKMSG             0x0004
#define WTM_WORKINFO            0x0005
#define WTM_HANDLEMOD           0x0006
#define WTM_AUTODWIN            0x0007
#define WTM_OPENDWIN            0x0008
#define WTM_GETMARKADDR         0x0009
#define WTM_LEAVEWIN            0x000A
#define WTM_SETCHANNELGADS      0x000B
#define WTM_GETCHANNELGADS      0x000C
#define WTM_ALLOCALPHA          0x000D
#define WTM_GETMARKOFFSET       0x000E
#define WTM_RESTOREALPHA        0x000F
#define WTM_PREFSPROCESS        0x0010
#define WTM_ALLOCUNDO           0x0011
#define WTM_FREEUNDO            0x0012
#define WTM_FREEPLAYLIST        0x0013
#define WTM_ADDPATTERN          0x0014
#define WTM_ADDENTRY            0x0015
#define WTM_GETCHANNELBITS      0x0016
#define WTM_GETSOUNDMODE        0x0017
#define WTM_DOSELECTLIST        0x0018
#define WTM_LONGREQ             0x0019
#define WTM_DRAWTIMEPATTERNLIST 0x001A
#define WTM_ADDANIMPATH         0x001B
#define WTM_ALLOCCHANNEL        0x001C
#define WTM_FREECHANNEL         0x001D
#define WTM_ALLOC_SPECIAL_DATA  0x001E
#define WTM_FINDNUMBER          0x001F
#define WTM_PLAYKEYS            0x0020
#define WTM_SPECIAL_DATA_FOUND  0x0040
#define WTM_PLAY                0x0080
#define WTM_STOPPLAY            0x0100
#define WTM_CHANNELREQ          0x0200
#define WTM_GETNOTEFREQ         0x0800
#define WTM_CALCWAVE            0x1000
#define WTM_WORK_BACKGROUND 0x80000000

            /*** CH_ CHannel ***/
#define CH_LEFT    1
#define CH_RIGHT   2
#define CH_CENTER  4
#define CH_SLEFT   8
#define CH_SRIGHT 16
#define CH_SUB    32

            /*** MD_ MoDe ***/
#define MD_MONO     1
#define MD_STEREO   2
#define MD_3CH      3
#define MD_QUADRO   4
#define MD_SURROUND 5
#define MD_AC3_Sub  6
#define MD_AC3      7

            /*** Portnames ***/
#define PORT_WT        "WaveTracerPort"
#define PORT_EFFECTMOD "WTEffectModPort"
#define PORT_LOADER    "WTLoaderPort"
#define PORT_SAVER     "WTSaverPort"

            /*** Portversions ***/
#define VERSION_WT        2
#define VERSION_EFFECTMOD 5
#define VERSION_LOADER    3
#define VERSION_SAVER     4

            /*** Samplekompressions ***/
#define COMPRESSION_FIBONACCI_DELTA 0x1
#define COMPRESSION_3BYTE           0x2
#define COMPRESSION_DELTA           0x4
#define COMPRESSION_DELTA_2         0x8
#define COMPRESSION_INTERLEAVED    0x10


#define EFF_DEFWIN 0x1
#define EFF_NOCALC 0x2


#define MAX24 8388600
#define MAXSIZE 50000000

            /*** SpecialData-Typen ***/
#define SD_SHORT_TEXT     0x1
#define SD_TEXT           0x2
#define SD_ANIMINFO       0x3
#define SD_IMAGE          0x4
#define SD_LOOP           0x5
#define SD_MARKER_ARRAY   0x8
#define SD_PLAYLIST      0x10
#define SD_ALPHA_CHANNEL 0x20
#define SD_SCENE         0x40


struct SDHeader
   {
   SDHeader *NextSpecialData;
   LONG sdh_Size,sdh_Type;
   };

struct SDBodyShortText
   {
   SDHeader sdb_SDHeader;
   char sdb_TextString[100];
   };

struct SDBodyAnim
   {
   SDHeader sdb_SDHeader;
   LONG  sdb_Frames;
   UBYTE sdb_FPS,sdb_Flags;
   UWORD sdb_pad;
   };

struct SDBodyScene
   {
   SDHeader sdb_SDHeader;
   char  sdb_Name[200];
   ULONG sdb_StartFrame,sdb_EndFrame;
   };
     
struct SDBodyLoop
   {
   SDHeader sdb_SDHeader;
   UWORD sdb_Loop,sdb_pad;    
   };

struct BlueNote
   {
   char  bn_NoteName[7][12][4]; // string[4];
   FLOAT bn_SampleFreq[7][12];  // Can't be usew with C/C++ because Pascal's REAL
                                // (original) aren't compatible with C/C++'s FLOAT!!!
   UWORD bn_PlayRate[7][12];
   BYTE  bn_PosX,bn_PosY;
   };

struct WaveOp
   {
   UBYTE ChunkSize,SoundMode;
   WORD  Operation,OpType,Channels,Flags;
   LONG  Operator[6];
   LONG  WAreaA,WAreaE;                   //  -  42
   char  OpString[81];                   //  - 123
   ULONG MemLData;
   APTR  MemAData;                        //  - 131
   };

struct SelectListGad
   {
   Window *GadWindow;
   Gadget *SGad;
   UBYTE  SelectedGad,pad1,pad2,pad3;
   IntuiText *ITextTag[15];
   };


#define WOP_SMALL 42
#define WOP_NORM 123
#define WOP_BIG  131


struct WTImages
   {
   UBYTE HiSys,Share;  // BOOL = 16 Bit!!!
   Image *None0,*KnobImg,*CalcImg;
   Image *GImg1,*GImg2,*GImg3,*GImg4,*GImg5,*GImg6;
   Image *ButtonImg1,*ButtonImg2,*ButtonImg3;
   Image *None1,*None2,*None3;
   BlueNote *Notes;
   IntuiText *OKIText,*CIText;
   Image *ButtonImg4,*ButtonImg5,*ButtonImg6;
   };
     
struct MsgPrc
   {
   LONG  PRC_Flags;
   char  PRC_Str1[200],PRC_Str2[200],PRC_Str3[200],PRC_Str4[200],PRC_Str5[200];
   LONG  PRC_Long1,PRC_Long2,PRC_Long3,PRC_Long4,PRC_Long5;
   void  *PRC_NewPtr; // ptr
   };
     
struct ChCoords
   {
   BYTE ChX[6],ChY[6];
   };

struct PlayListEntry           // ^r_ wurde gendert
   {
   LONG  BeginOffset,EndOffset;
   LONG  Rate,Delay,Time;
   WORD  Loop,VolumeL,VolumeR;
   char  Name[30];
   PlayListEntry *BeforeEntry,*NextEntry;
   };
     
struct PlayListPattern         // ^r_ wurde gendert
   {
   LONG  BeginOffset,EndOffset;
   char  Name[30];
   PlayListPattern *BeforePattern,*NextPattern;
   };

struct WTStdMsg
   {
   Message  wt_Node;
   UBYTE    UNDOPossible;
   LONG     Flags,Version;
   Screen   *WTScreen;
   Window   *WTWindow;
   LONG     ActiveChannels,ActiveMode;
   LONG     MemA16[6],MemA24[6],MemAUndo[6];
   LONG     MemL24,PlayL24,SRate;
   LONG     Attack,Decay,Sustain,Release;
   WaveOp   *ActWaveOp;
   LONG     OPos,OEnd,AreaA,AreaE;
   BPTR     ActFHandle;
   WTImages *WTImg;
   MsgPrc   *WTMsgPrc;
   ChCoords *PosSurround,*PosQuadro,*PosAC3;
   LONG     UsedChannels;
   LONG     MemAAlpha[6],AlphaUNDO[6];
   LONG     DataValid;
   PlayListPattern *FirstPlayListPattern;
   PlayListEntry *FirstPlayListEntry;
   SDHeader *SpecialData;
   char     *AnimPath;
   APTR      Bits;      // Private
   LONG      BitSize;   // Private
   APTR      Free1,Free2,Free3,Free4,Free5,Free6,Free7,Free8;
   char     *PText[TEXTS];
   Gadget   *g3,*g4,*g5,*g6,*g7,*g8;
   };

#endif
