Program Effectmod;

USES Intuition,Graphics,ExecIO;

{$incl "exec/memory.h"}
{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod"}

const NEGATIVE=3;
const POSITIVE=0;

var MyPort,WTPort       :^MsgPort;
var MyMsg               :^Message;
var MyWTStdMsg          :^WTStdMsg;

var DWindow                             :^Window;

var XGadget                             :^Gadget;
var DKnopf                              :array [1..2] of Gadget;
var Schieber,Textgad                    :Gadget;
var SchieberInfo                        :PropInfo;
var TextInfo                            :StringInfo;
var Buffer,UndoBuffer                   :string[20];

var IMsg                                :^IntuiMessage;
var Addr1,Addr2,Addr3,Addr4             :long;
var Data1,Data2,Data3,Data4             :^long;
var RawCode,GadCode,ChCnt               :byte;
var i                                   :integer;
var l,MemAPer,MemLPer                   :long;
var Valid                               :boolean;



procedure WRITE(LEdge,TEdge :word; Stpen,DMode :byte; Wind :Window; txt :str);

var IT1,IT2,IT3             :IntuiText;

begin
   IT1:=IntuiText(StPen  ,0,0,LEdge  ,TEdge  ,NIL ,txt,^IT2);
   IT2:=IntuiText(StPen+1,0,0,LEdge+2,TEdge+1,NIL ,txt,NIL);
   if DMode=1 then begin
      SetAPen(Wind.RPort,0);
      RectFill(Wind.RPort,LEdge,TEdge,LEdge+IntuiTextLength(^IT2)+8,TEdge+12);
   end else if DMode=2 then begin
      l:=LEdge-(IntuiTextLength(^IT2) div 2);
      IT1.LeftEdge:=l;   IT1.NextText:=NIL;
   end else if DMode=3 then begin
      IT1.LeftEdge:=320-IntuiTextLength(^IT1) div 2;
      IT2.LeftEdge:=IT1.LeftEdge+2;
   end;
   PrintIText(Wind.RPort,^IT1,0,0);
end;



procedure MAKEBORDER(Wind :Window; LEdge,TEdge,REdge,BEdge :word; Color :byte);

begin
   SetAPen(Wind.RPort,abs(Color-2));
   Move(Wind.RPort,LEdge+1,TEdge); Draw(Wind.RPort,LEdge+1,BEdge-1);
   Draw(Wind.RPort,LEdge,BEdge);   Draw(Wind.RPort,LEdge,TEdge);
   Draw(Wind.RPort,REdge,TEdge);
   SetAPen(Wind.RPort,abs(Color-1));
   Move(Wind.RPort,LEdge+1,BEdge); Draw(Wind.RPort,REdge,BEdge);
   Draw(Wind.RPort,REdge,TEdge+1); Draw(Wind.RPort,REdge-1,TEdge+1);
   Draw(Wind.RPort,REdge-1,BEdge);
end;



procedure MESSAGEHANDLE;

begin
   MyMsg^:=Message(MyPort^.mp_Node,MyPort,sizeof(MyWTStdMsg));
   PutMsg(WTPort,MyMsg);
   MyMsg:=WaitPort(MyPort);
   MyMsg:=GetMsg(MyPort);
   MyWTStdMsg:=ptr(long(MyMsg)+sizeof(Message));
end;



procedure CLOSEWIN;

begin
   while DWindow^.FirstGadget<>NIL do RemoveGadgets(Dwindow,DWindow^.FirstGadget);
   CloseWindow(DWindow);
end;



procedure DOSUSTAIN(SAddr :long; Step :byte);

var Stepsize,Offset                                             :real;
var PeriodSize,LastSample,LastPeriod,PeriodSizeOld,Addr2Old,
    Addr1Old                                                    :long;
var HalvePeriod                                                 :byte;



procedure CREATEWAVE;

var Divi        :long;

begin
   Stepsize:=PeriodSize/MemLPer;
   Offset:=Stepsize;
   Addr3:=Addr2; Addr4:=MemAPer;
   repeat
      Data3:=ptr(Addr3); Addr3:=Addr2+round(Offset)*4;
      Data4:=ptr(Addr4); Addr4:=Addr4+4;
      Divi:=Addr1-Addr3 div 4;
      Data4^:=(Data4^+Data4^+Data3^) div Divi;
      Offset:=Offset+Stepsize;
   until (Addr3>=Addr1) or (Addr4>=MemAPer+MemLPer);
end;


procedure GETAMPLITUDE;

begin
   LastPeriod:=0;
   Stepsize:=PeriodSize/MemLPer;
   Offset:=Stepsize;
   Addr3:=Addr2; Addr4:=MemAPer;
   repeat
      Data3:=ptr(Addr3); Addr3:=Addr2+round(Offset)*4;
      Data4:=ptr(Addr4); Addr4:=Addr4+4;
      Data4^:=(Data4^+Data4^+Data3^) div 3;
      if abs(Data3^)>LastPeriod then LastPeriod:=abs(Data3^);
      Offset:=Offset+Stepsize;
   until (Addr3>=Addr1) or (Addr4>=MemAPer+MemLPer);
end;


procedure VOLUMEUP;

begin
   Addr1:=MemAPer; LastSample:=0;
   if Lastperiod<850000 then LastPeriod:=850000;
   repeat
      Data1:=ptr(Addr1); Addr1:=Addr1+4;
      if abs(Data1^)>LastSample then LastSample:=abs(Data1^);
   until Addr1>=MemAPer+MemLPer;
   Offset:=LastPeriod/LastSample;
   Addr1:=MemAPer;
   repeat
      Data1:=ptr(Addr1); Addr1:=Addr1+4;
      Data1^:=-round(Data1^*Offset);
   until Addr1>=MemAPer+MemLPer;
end;


begin
   if SAddr=0 then exit;
   with MyWTStdMsg^ do begin
      PRC_Str1:='SUSTAIN-CREATOR  by QXC';
      PRC_Long2:=20;
      PRC_Long1:=pred(Step)*4;
      MESSAGEHANDLE;
      if PRC_Long1=-1 then begin
         Valid:=false; exit;
      end;


      Addr1:=MemAPer;
      repeat
         Data1:=ptr(Addr1); Addr1:=Addr1+4;
         Data1^:=0;
      until Addr1>=MemAPer+MemLPer;

      Addr1:=SAddr;
      repeat
         Addr2:=Addr1;
         HalvePeriod:=0; PeriodSize:=0;
         Data1:=ptr(Addr1); Addr1:=Addr1+4;
         LastSample:=Data1^;
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            if ((Data1^>0) and (LastSample<=0)) or ((Data1^<0) and (LastSample>=0)) then begin
               LastSample:=Data1^; HalvePeriod:=HalvePeriod+1;
            end;
         until (HalvePeriod=2) or (Addr1>=SAddr+PlayL24);
         PeriodSize:=Addr1-Addr2;
         if HalvePeriod=2 then begin
            PeriodSizeOld:=PeriodSize; Addr1Old:=Addr1; Addr2Old:=Addr2;
            CREATEWAVE;
         end;
      until Addr1>=SAddr+PlayL24;
      if Addr2<Addr1 then repeat
         Data2:=ptr(Addr2); Addr2:=Addr2+4;
         Data2^:=0;
      until Addr2>=Addr1;

      PeriodSize:=PeriodSizeOld; Addr1:=Addr1Old; Addr2:=Addr2Old;
      PRC_Long1:=1+pred(Step)*4;
      MESSAGEHANDLE;
      if PRC_Long1=-1 then begin
         Valid:=false; exit;
      end;
      CREATEWAVE;
      PRC_Long1:=2+pred(Step)*4;
      MESSAGEHANDLE;
      if PRC_Long1=-1 then begin
         Valid:=false; exit;
      end;
      GETAMPLITUDE;
      PRC_Long1:=3+pred(Step)*4;
      MESSAGEHANDLE;
      if PRC_Long1=-1 then begin
         Valid:=false; exit;
      end;
      VOLUMEUP;
      PRC_Long1:=4+pred(Step)*4;
      MESSAGEHANDLE;
      if PRC_Long1=-1 then begin
         Valid:=false; exit;
      end;

      Addr1:=SAddr; Addr2:=MemAPer;
      Stepsize:=4/PlayL24;
      Offset:=Stepsize;
      repeat
         Data1:=ptr(Addr1); Addr1:=Addr1+4;
         Data2:=ptr(Addr2); Addr2:=Addr2+4;
            if Addr2>=MemAPer+MemLPer then Addr2:=MemAPer;
         Data1^:=round((Data1^+Data1^+(Data2^*Offset))/3);
            Offset:=Offset+Stepsize
      until Addr1>=SAddr+PlayL24;
      repeat
         Data1:=ptr(Addr1); Addr1:=Addr1+4;
         Data2:=ptr(Addr2); Addr2:=Addr2+4;
            if Addr2>=MemAPer+MemLPer then Addr2:=MemAPer;
         Data1^:=Data2^ div 3;
      until Addr1>=SAddr+PlayL24+(ActWaveOp^.Operator[1]*4);

      Addr2:=SAddr+PlayL24;
      repeat
         Data2:=ptr(Addr2); Addr2:=Addr2+4;
      until (Addr2>=SAddr+PlayL24+(ActWaveOp^.Operator[1]*4)) or (Data2^ in [(Data1^-4000)..(Data1^+4000)]);
      if Addr2>=SAddr+MemL24 then Sustain:=PlayL24-(ActWaveOp^.Operator[1]*4) else Sustain:=Addr2-SAddr;
      Attack:=0; Decay:=0;
      PRC_Long1:=5+pred(Step)*4;
      MESSAGEHANDLE;
      if PRC_Long1=-1 then begin
         Valid:=false; exit;
      end;
   end;
end;



function READCHANNELS:boolean;

var Periods,LastSample  :long;
var Stepsize,Offset     :real;

procedure READPERIODS(SAddr :long);

begin
   if SAddr=0 then exit;
   ChCnt:=ChCnt+1;
   Addr1:=SAddr;
   Data1:=ptr(Addr1); Addr1:=Addr1+4;
   LastSample:=Data1^;
   repeat
      Data1:=ptr(Addr1); Addr1:=Addr1+4;
      if ((Data1^>0) and (LastSample<=0)) or ((Data1^<0) and (LastSample>=0)) then begin
         LastSample:=Data1^; Periods:=Periods+1;
      end;
   until Addr1>=SAddr+(MyWTStdMsg^.PlayL24);
   Periods:=Periods-1;
end;


procedure SCALEDOWN(SAddr :long);

begin
   if SAddr=0 then exit;
   with MyWTStdMsg^ do begin
      Stepsize:=PlayL24 / (MemL24-(ActWaveOp^.Operator[1]*4));
      Offset:=Stepsize;
      Addr1:=SAddr; Addr2:=Saddr;
      repeat
         Data1:=ptr(Addr1); Addr1:=Addr1+4;
         Data2:=ptr(Addr2); Addr2:=SAddr+round(Offset)*4;
         Offset:=Offset+Stepsize;
         Data1^:=Data2^;
      until round(Offset)*4>=PlayL24
   end;
end;


begin
   READCHANNELS:=false;
   with MyWTStdMsg^ do begin
      if MemL24-(ActWaveOp^.Operator[1]*4)<PlayL24 then begin
         SCALEDOWN(MemA24[1]); SCALEDOWN(MemA24[2]);
         SCALEDOWN(MemA24[3]); SCALEDOWN(MemA24[4]);
         PlayL24:=MemL24-(ActWaveOp^.Operator[1]*4)-4;
      end;
      Periods:=0; ChCnt:=0;
      if not (ActiveChannels and CH_LEFT=0) then READPERIODS(MemA24[1]);
      if not (ActiveChannels and CH_RIGHT=0) then READPERIODS(MemA24[2]);
      if not (ActiveChannels and CH_FG=0) then READPERIODS(MemA24[3]);
      if not (ActiveChannels and CH_BG=0) then READPERIODS(MemA24[4]);
      Periods:=Periods div 2;
      MemLPer:=(ChCnt*PlayL24) div Periods;
      MemAPer:=AllocMem(MemLPer,MEMF_CLEAR);
      if MemAPer=0 then begin
         PRC_Flags:=MDE_NO_MEMORY; exit;
      end;
   end;
   READCHANNELS:=true;
end;



procedure DEFINESUSTAIN;

begin
   with MyWTStdMsg^ do begin
      Flags:=0; PRC_Flags:=WTM_OPENDWIN; PRC_Long1:=75; PRC_Long2:=0;
      MESSAGEHANDLE;
      if (PRC_Long1=-1) or (PRC_NewPtr=NIL) then begin
         PRC_Flags:=WTM_TASKREQ; PRC_Str1:='Kann kein Fenster ffnen!';
         PRC_Str2:='Operation abgebrochen';
         PRC_Str3:=''; PRC_Str4:='OK'; PRC_Str5:='';
         MESSAGEHANDLE;
         Flags:=MDE_ERROR; exit;
      end;
      DWindow:=PRC_NewPtr;
      ActWaveOp^.Operator[1]:=PlayL24 div 16;
      DKnopf[1]:=Gadget(NIL,500,35,96,14,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,WTImg^.GImg5,NIL,WTImg^.OKIText,0,Nil,1,0);
      DKnopf[2]:=Gadget(NIL,500,50,96,14,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,WTImg^.GImg5,NIL,WTImg^.CIText,0,Nil,2,0);
         { OK / CANCEL }
      Schieber:=Gadget(NIL,30,41 ,320,13,GADGHCOMP+GADGIMAGE,$83,PROPGADGET,WTImg^.KnobImg,NIL,Nil,0,^SchieberInfo,3,0);
      SchieberInfo:=Propinfo(FREEHORIZ,ActWaveOp^.Operator[1] div 2,0,2,0,0,0,0,0,0,0);
      TextGad:=Gadget(Nil,362,42,42,12,GADGHCOMP,_LONGINT+STRINGCENTER+$1,STRGADGET,NIL,Nil,Nil,0,^TextInfo,4,0);
      MAKEBORDER(DWindow^,360,41,405,53,NEGATIVE);
      TextInfo:=StringInfo(^Buffer,^Undobuffer,0,7,0,0,0,0,0,0,Nil,0,Nil);
      Buffer:=intstr(ActWaveOp^.Operator[1]); UndoBuffer:='';

      WRITE(190,55,1,0,DWindow^,'Sustain-Lnge');
      WRITE(0,22,1,3,DWindow^,'Definition QUADRO-SUSTAIN-CREATOR ( by QXC)');
      AddGadget(DWindow,^TextGad,NIL);
      AddGadget(DWindow,^Schieber,NIL);
      for i:=1 to 2 do AddGadget(DWindow,^DKnopf[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         if (GadCode=3) or not (Schieber.flags and SELECTED=0) then begin
            ActWaveOp^.Operator[1]:=SchieberInfo.HorizPot*2;
            if ActWaveOp^.Operator[1]<8 then ActWaveOp^.Operator[1]:=8;
            if ActWaveOp^.Operator[1]>MemL24 div 8 then ActWaveOp^.Operator[1]:=MemL24 div 8;
            Buffer:=intstr(ActWaveOp^.Operator[1]);
            RefreshGadgets(^TextGad,DWindow,NIL);
         end;
         if GadCode=4 then begin
            val(Buffer,ActWaveOp^.Operator[1],i);
            if ActWaveOp^.Operator[1]<8 then ActWaveOp^.Operator[1]:=8;
            if ActWaveOp^.Operator[1]>MemL24 div 8 then ActWaveOp^.Operator[1]:=MemL24 div 8;
            Buffer:=intstr(ActWaveOp^.Operator[1]);
            SchieberInfo.HorizPot:=ActWaveOp^.Operator[1] div 2;
            RefreshGadgets(^Schieber,DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      if (RawCode=69) or (GadCode=2) then begin
         if RawCode=69 then begin
            DKnopf[2].flags:=DKnopf[2].flags+SELECTED;
            RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
            delay(5);
         end;
         CLOSEWIN; Flags:=MDE_CANCELLED; exit;
      end;
      if RawCode=68 then begin
         DKnopf[1].flags:=DKnopf[1].flags+SELECTED;
         RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
         delay(5);
      end;
      CLOSEWIN; Flags:=MDE_READY;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   MyPort:=CreatePort(PORT_EFFECTMOD,0);
   if MyPort<>NIL then begin
      MyMsg:=WaitPort(MyPort);
      MyMsg:=GetMsg(MyPort);
      WTPort:=MyMsg^.mn_ReplyPort;
      MyWTStdMsg:=ptr(long(MyMsg)+sizeof(Message));
      with MyWTStdMsg^ do if Version=3 then begin
         if Flags=MDC_DEFINEIT then begin
            DEFINESUSTAIN; MESSAGEHANDLE;
         end;
         if Flags=MDC_DOIT then begin
            Flags:=0;
            PRC_Flags:=WTM_TASKMSG;
            if READCHANNELS then begin
               Valid:=true;
               if not (ActiveChannels and CH_LEFT=0) then DOSUSTAIN(MemA24[1],1);
               if not (ActiveChannels and CH_RIGHT=0) and Valid then DOSUSTAIN(MemA24[2],2);
               if not (ActiveChannels and CH_FG=0) and Valid then DOSUSTAIN(MemA24[3],3);
               if not (ActiveChannels and CH_BG=0) and Valid then DOSUSTAIN(MemA24[4],4);
               PlayL24:=PlayL24+(ActWaveOp^.Operator[1]*4);
               Release:=PlayL24;
               if Sustain=Release then Sustain:=Release-(ActWaveOp^.Operator[1]*4);
               FreeMem(MemAPer,MemLPer);
               Flags:=MDE_READY;
            end else Flags:=MDE_ERROR;
            MESSAGEHANDLE;
         end;
      end else begin
         Flags:=MDE_WRONG_MODULEVERSION; MESSAGEHANDLE;
      end;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.



