#include <exec/types.h>
#include <libraries/dos.h>
#include <intuition/intuitionbase.h>

#ifndef __PPC__
   #include <pragma/all_lib.h>
#endif

#include <WaveTracer/WTincl.h>
#include <WTProcessWave.h>

#include <stdlib.h>

extern PMsg *MyPMsg;
extern UBYTE ChBit,ChID;



void CALCCHANNELS(LONG BeginOffset, LONG Length, UBYTE MyUsedChans)

{
LONG   SideDiv,CentDiv,SurrDiv,SubDiv,ABDiv,CDDiv,Addr1,Addr2,Addr3,l;
LONG   MemE,AddrA;
LONG  *Data3,*Data4;
WORD  *DataW1,*DataW2;
BYTE  *DataS1,*DataS2;
UBYTE *DataL,*DataH,*DataA;
UBYTE  DataB,i,j,ChBit,ChNum,Factor,ACtr,MemID1,MemID2,CalcCtr,UsedChans;
LONG   MemA8[6];



if (((!MyPMsg->MemA16[0]) || (!MyPMsg->MemA16[1])) && 
    ((!MyPMsg->MemA16[2]) || (MyPMsg->MemA16[3]))) return;
if (MyPMsg->ActiveMode==MD_AC3) MyUsedChans=MyUsedChans | CH_SUB;
MyUsedChans=MyUsedChans & (MyPMsg->PlayCh[0] | MyPMsg->PlayCh[1]);
if (((MyPMsg->PlayType[0]==1) || (MyPMsg->PlayType[0]==3)) && 
    ((MyPMsg->PlayType[1]==1) || (MyPMsg->PlayType[1]==3)))
   {
   for (CalcCtr=0; CalcCtr<2; CalcCtr++)
      {
      UsedChans=MyUsedChans & MyPMsg->PlayCh[CalcCtr];
      Factor=0;
      ChBit=1; ChNum=0;
      for (i=0; i<6; i++)
         {
         if ((UsedChans & ChBit)==ChBit)
            {
            Factor++;
            ChNum++;
            }
         ChBit=ChBit*2;
         }
      if ((MyUsedChans & (CH_LEFT+CH_RIGHT))==(CH_LEFT+CH_RIGHT)) Factor--;      
      SideDiv=(LONG)((MAX24/16386.0)*Factor/2.0);
      CentDiv=(LONG)((MAX24/16386.0)*Factor);
      SurrDiv=(LONG)((MAX24/16386.0)*Factor);
      if (MyPMsg->PlayMethod==11) SurrDiv=(LONG)((MAX24/16386.0)*Factor/2.0);
      SubDiv=(LONG)((MAX24/16386.0)*Factor);
      if ((MyPMsg->ActiveMode==MD_STEREO) || (MyPMsg->ActiveMode==MD_QUADRO)) SideDiv=(LONG)((MAX24/16386.0)*Factor);
      if ((MyPMsg->PlayType[CalcCtr]==1) && (MyPMsg->PlayCh[CalcCtr]!=0))
         { 
         // *** Amiga 2 x 16 Bit *** 
         if (CalcCtr==0)
            {
            MemID1=0; MemID2=1;
            }
         else
            {
            MemID1=2; MemID2=3;
            }
         MemA8[0]=MyPMsg->MemA16[MemID1]; MemA8[1]=MyPMsg->MemA16[MemID1]+(MyPMsg->MemL24 / 4);
         MemA8[2]=MyPMsg->MemA16[MemID2]; MemA8[3]=MyPMsg->MemA16[MemID2]+(MyPMsg->MemL24 / 4);

         AddrA=MyPMsg->MemAAlpha[0] | MyPMsg->MemAAlpha[2];
         // LEFT & RIGHT
         for (i=1; i<=2; i++) if (((UsedChans & i)==i) && (MyPMsg->MemA24[i-1]))
            {
            Addr1=MyPMsg->MemA8[i*2-2]+(BeginOffset / 4);
            Addr3=MyPMsg->MemA24[0,i-1]+BeginOffset+4;
            if (AddrA) AddrA=MyPMsg->MemAAlpha[i-1]+((BeginOffset+4) / 80);
            for (j=1; j<=2; j++)
               {
               ACtr=10;
               do
                  {
                  DataW1=(WORD*)Addr1; Addr1=Addr1+2;
                  Data3=(LONG*)Addr3;  Addr3=Addr3+8;
                  if (!AddrA) *DataW1=*Data3 / SideDiv else
                     {
                     if (ACtr>=10)
                        {
                        ACtr=0;
                        DataA=(UBYTE*)(AddrA); AddrA++;
                        }
                     ACtr++;
                     *DataW1=(WORD)(*Data3/SideDiv/255.0*(*DataA));
                     }
                  }
               while (Addr3<MyPMsg->MemA24[i-1]+Length);
               Addr1=MyPMsg->MemA8[i*2-1]+(BeginOffset / 4);
               Addr3=MyPMsg->MemA24[i-1]+BeginOffset;
               if (AddrA) AddrA=MyPMsg->MemAAlpha[i-1]+(BeginOffset / 80);
               }
            }
         else
            {
            Addr1=MyPMsg->MemA8[i*2-2]+(BeginOffset / 4);
            Addr2=MyPMsg->MemA8[i*2-1]+  (BeginOffset / 4);
            MemE=MyPMsg->MemA8[i*2-2]+ (Length / 4);
            do
               {
               Data3=(LONG*)Addr1; Addr1=Addr1+4; *Data3=0;
               Data4=(LONG*)Addr2; Addr2=Addr2+4; *Data4=0;
               }
            while (Addr1<MemE);
            }

         // CENTER
         if ((UsedChans & CH_CENTER)==CH_CENTER)
            {
            Addr1=MemA8[0]+(BeginOffset / 4);
            Addr2=MemA8[2]+(BeginOffset / 4);
            Addr3=MyPMsg->MemA24[2]+BeginOffset+4;
            if (AddrA) AddrA=MyPMsg->MemAAlpha[2]+((BeginOffset+4) / 80);
            for (j=1; j<=2; j++) if (MyPMsg->MemA24[2])
               {
               ACtr=10;
               do
                  {
                  DataW1=(WORD*)Addr1; Addr1=Addr1+2;
                  DataW2=(WORD*)Addr2; Addr2=Addr2+2;
                  Data3=(LONG*)Addr3;  Addr3=Addr3+8;
                  if (MyPMsg->ActiveMode==MD_MONO)
                     {
                     if (!AddrA)
                        {
                        *DataW1=*Data3 / CentDiv;
                        *DataW2=*Data3 / CentDiv;
                        }
                     else
                        {
                        if (ACtr>=10)
                           {
                           ACtr=0;
                           DataA=(UBYTE*)(AddrA); AddrA++;
                           }
                        ACtr++;
                        *DataW1=(WORD)(*Data3/CentDiv/255.0*(*DataA));
                        *DataW2=(WORD)(*Data3/CentDiv/255.0*(*DataA));
                        }
                     }
                  else
                     {
                     if (!AddrA)
                        {
                        *DataW1=*DataW1+(*Data3 / CentDiv);
                        *DataW2=*DataW2+(*Data3 / CentDiv);
                        }
                     else
                        {
                        if (ACtr>=10)
                           {
                           ACtr=0;
                           DataA=(UBYTE*)(AddrA); AddrA++;
                           }
                        ACtr++;
                        *DataW1=(WORD)(*DataW1+(*Data3/CentDiv/255.0*(*DataA)));
                        *DataW2=(WORD)(*DataW1+(*Data3/CentDiv/255.0*(*DataA)));
                        }
                     }
                  }
               while (Addr3<MyPMsg->MemA24[2]+Length);
               Addr1=MemA8[1]+(BeginOffset / 4);
               Addr2=MemA8[3]+(BeginOffset / 4);
               Addr3=MyPMsg->MemA24[2]+BeginOffset;
               if (AddrA) AddrA=MyPMsg->MemAAlpha[2]+(BeginOffset / 80);
               }
            }
         if ((MyPMsg->PlayMethod==1) || (MyPMsg->PlayMethod==11))
            {
            // SURROUND LEFT/RIGHT
            for (i=1; i<=2; i++) if (((UsedChans & (i*8))==(i*8)) && (MyPMsg->MemA24[i+2]))
               {
               Addr1=MemA8[0]+(BeginOffset / 4);
               Addr2=MemA8[2]+(BeginOffset / 4);
               Addr3=MyPMsg->MemA24[i+2]+BeginOffset+804;
               if (AddrA) AddrA=MyPMsg->MemAAlpha[i+2]+((BeginOffset+804) / 80);
               for (j=1; j<=2; j++)
                  {
                  if (Addr3<MyPMsg->MemA24[i+2]+Length) do
                     {
                     DataW1=(WORD*)Addr1; Addr1=Addr1+2;
                     DataW2=(WORD*)Addr2; Addr2=Addr2+2;
                     Data3=(LONG*)Addr3;  Addr3=Addr3+8;
                     if (!AddrA)
                        {
                        if (MyPMsg->PlayMethod!=11) *DataW1=*DataW1-(*Data3 / SurrDiv)
                        else if (i==1) *DataW1=*DataW1+(*Data3 / SurrDiv);
                        if ((MyPMsg->PlayMethod!=11) || (i==2)) *DataW2=*DataW2+(*Data3 / SurrDiv);
                        }
                     else
                        {
                        if (ACtr>=10)
                           {
                           ACtr=0;
                           DataA=(UBYTE*)(AddrA); AddrA++;
                           }
                        ACtr++;
                        if (MyPMsg->PlayMethod!=11) *DataW1=(WORD)(*DataW1-(*Data3/SurrDiv/255.0*(*DataA)))
                        else if (i==1) *DataW1=(WORD)(*DataW1+(*Data3/SurrDiv/255.0*(*DataA)));
                        if ((MyPMsg->PlayMethod!=11) || (i==2)) *DataW2=(WORD)(*DataW2+(*Data3/SurrDiv/255.0*(*DataA)));
                        }
                     }
                  while (Addr3<MyPMsg->MemA24[i+2]+Length);
                  Addr1=MemA8[1]+(BeginOffset / 4);
                  Addr2=MemA8[3]+(BeginOffset / 4);
                  Addr3=MyPMsg->MemA24[i+2]+BeginOffset+800;
                  if (AddrA) AddrA=MyPMsg->MemAAlpha[i+2]+((BeginOffset+800) / 80);
                  }
               }
            }

         // SUBWOOFER
         if ((MyPMsg->MemA24[5]) && ((UsedChans & CH_SUB)==CH_SUB))
            {
            Addr1=MemA8[0]+(BeginOffset / 4);
            Addr2=MemA8[2]+(BeginOffset / 4);
            Addr3=MyPMsg->MemA24[5]+BeginOffset+4;
            if (AddrA) AddrA=MyPMsg->MemAAlpha[5]+((BeginOffset+4) / 80);
            ACtr=10;
            for (j=1; j<=2; j++) do
               {
               DataW1=(WORD*)Addr1; Addr1=Addr1+2;
               DataW2=(WORD*)Addr2; Addr2=Addr2+2;
               Data3=(LONG*)Addr3;  Addr3=Addr3+8;
               if (!AddrA)
                  {
                  if ((MyPMsg->PlayMethod==1) || (MyPMsg->PlayMethod==11))
                     {
                     *DataW1=*DataW1+(*Data3 / SubDiv);
                     *DataW2=*DataW2+(*Data3 / SubDiv)
                     }
                  else
                     {
                     l=*DataW1+(*Data3 / SubDiv);
                     if (l>32767) l=32767 else if (l<-32767) l=-32767;
                     *DataW1=l;
                     l=*DataW2+(*Data3 / SubDiv);
                     if (l>32767) l=32767 else if (l<-32767) l=-32767;
                     *DataW2=l;
                     }
                  }
               else
                  {
                  if (ACtr>=10)
                     {
                     ACtr=0;
                     DataA=(UBYTE*)(AddrA); AddrA++;
                     }
                  ACtr++;
                  if ((MyPMsg->PlayMethod==1) || (MyPMsg->PlayMethod==11))
                     {
                     *DataW1=(WORD)(*DataW1+(*Data3/SubDiv/255.0*(*DataA)));
                     *DataW2=(WORD)(*DataW2+(*Data3/SubDiv/255.0*(*DataA)));
                     }
                  else
                     {
                     l=(LONG)(*DataW1+(*Data3/SubDiv/255.0*(*DataA)));
                     if (l>32767) l=32767 else if (l<-32767) l=-32767;
                     *DataW1=l;
                     l=(LONG)(*DataW2+(*Data3/SubDiv/255.0*(*DataA)));
                     if (l>32767) l=32767 else if (l<-32767) l=-32767;
                     *DataW2=l;
                     }
                  }
               }
            while (Addr3<MyPMsg->MemA24[5]+Length);
            Addr1=MemA8[1]+(BeginOffset / 4);
            Addr2=MemA8[3]+(BeginOffset / 4);
            Addr3=MyPMsg->MemA24[5]+BeginOffset;
            if (AddrA) AddrA=MyPMsg->MemAAlpha[5]+(BeginOffset / 80);
            }

         for (i=1; i<=2; i++)
            {
            Addr1=MemA8[2*i-2]+(BeginOffset / 4);
            Addr2=MemA8[2*i-1]+1+(BeginOffset / 4);
            MemE=MemA8[2*i-1]+(Length / 4);
            if (MemE>MyPMsg->MemA16[i-1]+(MyPMsg->MemL24 / 2)) MemE=MyPMsg->MemA16[i-1]+(MyPMsg->MemL24 / 2);
            do
               {
               DataL=(UBYTE*)Addr1; Addr1=Addr1+2;
               DataH=(UBYTE*)Addr2; Addr2=Addr2+2;
               DataB=*DataL; *DataL=*DataH; *DataH=DataB;
               }
            while (Addr2<MemE);
            }
         }
      else if ((MyPMsg->PlayType[CalcCtr]==3) && (MyPMsg->PlayCh[CalcCtr]!=0))
         { 
         // *** AHI ***
         if (CalcCtr==0) MemID1=0 else MemID1=2;
         AddrA=MyPMsg->MemAAlpha[0]+MyPMsg->MemAAlpha[2];
         // LEFT & RIGHT
         for (i=1; i<=2; i++) if ((UsedChans & i)==i)
            {
            Addr1=MyPMsg->MemA16[MemID1]+BeginOffset+((i-1)*2);
            Addr3=MyPMsg->MemA24[i-1]+BeginOffset;
            if (AddrA) AddrA=MyPMsg->MemAAlpha[i-1]+((BeginOffset+4) / 80);
            ACtr=20;
            do
               {
               DataW1=(WORD*)(Addr1); Addr1=Addr1+4;
               Data3=(LONG*)(Addr3);  Addr3=Addr3+4;
               if (!AddrA) *DataW1=*Data3 / SideDiv else
                  {
                  if (ACtr>=20)
                     {
                     ACtr=0;
                     DataA=(UBYTE*)(AddrA); AddrA++;
                     }
                  ACtr++;
                  *DataW1=(WORD)(*Data3/SideDiv/255.0*(*DataA));
                  }
               }
            while (Addr3<MyPMsg->MemA24[i-1]+Length);
            if (AddrA) AddrA=MyPMsg->MemAAlpha[i-1]+(BeginOffset / 80);
            }
         else
            {
            Addr1=MyPMsg->MemA16[MemID1]+BeginOffset+((i-1)*2);
            MemE=MyPMsg->MemA16[MemID1]+Length;
            do
               {
               DataW1=(WORD*)(Addr1); Addr1=Addr1+4;          
               *DataW1=0;
               }
            while (Addr1<MemE);
            }

         // CENTER
         if ((MyPMsg->UsedChans & CH_CENTER)==CH_CENTER)
            {
            Addr1=MyPMsg->MemA16[MemID1]+BeginOffset;
            Addr3=MyPMsg->MemA24[2]+BeginOffset;
            if (AddrA) AddrA=MyPMsg->MemAAlpha[2]+((BeginOffset+4) / 80);
            ACtr=20;
            do
               {
               DataW1=(WORD*)(Addr1); Addr1=Addr1+2;          
               DataW2=(WORD*)(Addr1); Addr1=Addr1+2;          
               Data3=(LONG*)(Addr3);  Addr3=Addr3+4;
               if (MyPMsg->ActiveMode==MD_MONO)
                  {
                  if (!AddrA)
                     {
                     *DataW1=*Data3 / CentDiv;
                     *DataW2=*Data3 / CentDiv;
                     }
                  else
                     {
                     if (ACtr>=10)
                        {
                        ACtr=0;
                        DataA=(UBYTE*)(AddrA); AddrA++;
                        }
                     ACtr++;
                     *DataW1=(WORD)(*Data3/CentDiv/255.0*(*DataA));
                     *DataW2=(WORD)(*Data3/CentDiv/255.0*(*DataA));
                     }
                  }
               else
                  {
                  if (!AddrA)
                     {
                     *DataW1=*DataW1+(*Data3 / CentDiv);
                     *DataW2=*DataW2+(*Data3 / CentDiv);
                     }
                  else
                     {
                     if (ACtr>=20)
                        {
                        ACtr=0;
                        DataA=(UBYTE*)(AddrA); AddrA++;
                        }
                     ACtr++;
                     *DataW1=(WORD)(*DataW1+(*Data3/CentDiv/255.0*(*DataA)));
                     *DataW2=(WORD)(*DataW2+(*Data3/CentDiv/255.0*(*DataA)));
                     }
                  }
               }
            while (Addr3<MyPMsg->MemA24[2]+Length);
            }

         if ((MyPMsg->PlayMethod==1) || (MyPMsg->PlayMethod==11))
            {
            // SURROUND LEFT/RIGHT
            for (i=1; i<=2; i++) 
             if (((MyPMsg->UsedChans & (i*8))==(i*8)) && (MyPMsg->MemA24[0,i+2]))
               {
               Addr1=MyPMsg->MemA16[MemID1]+BeginOffset;
               Addr3=MyPMsg->MemA24[i+2]+BeginOffset+800;
               if (AddrA) AddrA=MyPMsg->MemAAlpha[i+2]+((BeginOffset+804) / 80);
               ACtr=20;
               if (Addr3<MyPMsg->MemA24[i+2]+Length) do
                  {
                  DataW1=(WORD*)(Addr1); Addr1=Addr1+2;          
                  DataW2=(WORD*)(Addr1); Addr1=Addr1+2;          
                  Data3=(LONG*)(Addr3);  Addr3=Addr3+4;
                  if (!AddrA)
                     {
                     if (MyPMsg->PlayMethod!=11) *DataW1=*DataW1-(*Data3 / SurrDiv)
                     else if (i==1) *DataW1=*DataW1+(*Data3 / SurrDiv);
                     if ((MyPMsg->PlayMethod!=11) || (i==2)) *DataW2=*DataW2+(*Data3 / SurrDiv)
                     }
                  else
                     {
                     if (ACtr>=20)
                        {
                        ACtr=0;
                        DataA=(UBYTE*)(AddrA); AddrA++;
                        }
                     ACtr++;
                     if (MyPMsg->PlayMethod!=11) *DataW1=(WORD)(*DataW1-(*Data3/SurrDiv/255.0*(*DataA)))
                     else if (i==1) *DataW1=(WORD)(*DataW1+(*Data3/SurrDiv/255.0*(*DataA)));
//                     *DataW1=*DataW1-(*Data3 / SurrDiv / 255 * (*DataA));
                     if ((MyPMsg->PlayMethod!=11) || (i==2)) *DataW2=(WORD)(*DataW2+(*Data3/SurrDiv/255.0*(*DataA)));
                     }
                  }
               while (Addr3<MyPMsg->MemA24[i+2]+Length);
               }
            }

         // SUBWOOFER
         if ((MyPMsg->MemA24[5]) && ((MyPMsg->UsedChans & CH_SUB)==CH_SUB))
            {
            Addr1=MyPMsg->MemA16[MemID1]+BeginOffset;
            Addr3=MyPMsg->MemA24[5]+BeginOffset+4;
            if (AddrA) AddrA=MyPMsg->MemAAlpha[5]+(BeginOffset+4) / 80;
            ACtr=20;
            do
               {
               DataW1=(WORD*)(Addr1); Addr1=Addr1+2;          
               DataW2=(WORD*)(Addr1); Addr1=Addr1+2;          
               Data3=(LONG*)(Addr3);  Addr3=Addr3+4;
               if (!AddrA)
                  {
                  if ((MyPMsg->PlayMethod==1) || (MyPMsg->PlayMethod==11))
                     {
                     *DataW1=*DataW1+(*Data3 / SubDiv);
                     *DataW2=*DataW2+(*Data3 / SubDiv);
                     }
                  else
                     {
                     l=*DataW1+(*Data3 / SubDiv);
                     if (l>32767) l=32767 else if (l<-32767) l=-32767;
                     *DataW1=l;
                     l=*DataW2+(*Data3 / SubDiv);
                     if (l>32767) l=32767 else if (l<-32767) l=-32767;
                     *DataW2=l;
                     }
                  }
               else
                  {
                  if (ACtr>=20)
                     {
                     ACtr=0;
                     DataA=(UBYTE*)(AddrA); AddrA++;
                     }
                  ACtr++;
                  if ((MyPMsg->PlayMethod==1) || (MyPMsg->PlayMethod==11))
                     {
                     *DataW1=(WORD)(*DataW1+(*Data3/SubDiv/255.0*(*DataA)));
                     *DataW2=(WORD)(*DataW2+(*Data3/SubDiv/255.0*(*DataA)));
                     }
                  else
                     {
                     l=(LONG)(*DataW1+(*Data3/SubDiv/255.0*(*DataA)));
                     if (l>32767) l=32767 else if (l<-32767) l=-32767;
                     *DataW1=l;
                     l=(LONG)(*DataW2+(*Data3/SubDiv/255.0*(*DataA)));
                     if (l>32767) l=32767 else if (l<-32767) l=-32767;
                     *DataW2=l;
                     }
                  }
               }
            while (Addr3<MyPMsg->MemA24[5]+Length);
            }
         }
      }
   return;
   }
   
if ((MyPMsg->PlayType[0]==2) || (MyPMsg->PlayType[1]==2))
   {
   // Amiga 4 x 8 Bit
   l=0;
   if (MyPMsg->PlayType[0]==2) l=MyPMsg->PlayCh[0];
   if (MyPMsg->PlayType[1]==2) l=l | MyPMsg->PlayCh[1];
   MemA8[0]=MyPMsg->MemA16[0]; MemA8[1]=MyPMsg->MemA16[0]+(MyPMsg->MemL24 / 4);
   MemA8[2]=MyPMsg->MemA16[1]; MemA8[3]=MyPMsg->MemA16[1]+(MyPMsg->MemL24 / 4);
   UsedChans=MyUsedChans & l;
   Factor=0; ABDiv=0; CDDiv=0;
   ChBit=1; ChNum=0;
   for (i=1; i<=6; i++)
      {
      if ((UsedChans & ChBit)==ChBit)
         {
         Factor++;
         ChNum++;
         }
      if ((MyPMsg->PlayCh[0] & ChBit)==ChBit) ABDiv++;
      if ((MyPMsg->PlayCh[1] & ChBit)==ChBit) CDDiv++;
      ChBit=ChBit*2;
      }
   if ((MyPMsg->PlayCh[0] & CH_LEFT)==CH_LEFT) SideDiv=(LONG)((MAX24/65.0)*ABDiv/2.0)
    else SideDiv=(LONG)((MAX24/65.0)*CDDiv/2.0);
   if ((MyPMsg->PlayCh[0] & CH_CENTER)==CH_CENTER) CentDiv=(LONG)((MAX24/65.0)*ABDiv)
    else CentDiv=(LONG)((MAX24/65.0)*CDDiv);
   if ((MyPMsg->PlayCh[0] & CH_SLEFT)==CH_SLEFT) SurrDiv=(LONG)((MAX24/65.0)*ABDiv)
    else SurrDiv=(LONG)((MAX24/65.0)*CDDiv);
   if (MyPMsg->PlayMethod==11)
      {
      if ((MyPMsg->PlayCh[0] & CH_SLEFT)==CH_SLEFT) SurrDiv=(LONG)((MAX24/65.0)*ABDiv/2.0)
       else SurrDiv=(LONG)((MAX24/65.0)*CDDiv/2.0);
      }
   if ((MyPMsg->PlayCh[0] & CH_SUB)==CH_SUB) SubDiv=(LONG)((MAX24/65.0)*ABDiv)
    else SubDiv=(LONG)((MAX24/65.0)*CDDiv);
   if ((MyPMsg->ActiveMode==MD_STEREO) || (MyPMsg->ActiveMode==MD_QUADRO))
      {
      if ((MyPMsg->PlayCh[0] & CH_LEFT)==CH_LEFT) SideDiv=(LONG)((MAX24/65.0)*ABDiv)
      else SideDiv=(LONG)((MAX24/65.0)*CDDiv);
      }
   AddrA=MyPMsg->MemAAlpha[0]+MyPMsg->MemAAlpha[2];

   // LEFT & RIGHT
   for (i=1; i<=4; i++)
      {
      switch (i)
         {
         case 1:
            if ((MyPMsg->PlayCh[0] & UsedChans & CH_LEFT)==0)
               {
               Addr1=MemA8[0]+(BeginOffset / 4);
               MemE =MemA8[0]+(Length / 4);
               }
            else Addr1=0;
            break;
         case 2:
            if ((MyPMsg->PlayCh[0] & UsedChans & CH_RIGHT)==0)
               {
               Addr1=MemA8[1]+(BeginOffset / 4);
               MemE =MemA8[1]+(Length / 4);
               }
            else Addr1=0;
            break;
         case 3:
            if ((MyPMsg->PlayCh[1] & UsedChans & CH_RIGHT)==0)
               {
               Addr1=MemA8[2]+(BeginOffset / 4);
               MemE =MemA8[2]+(Length / 4);
               }
            else Addr1=0;
            break;
         case 4:
            if ((MyPMsg->PlayCh[1] & UsedChans & CH_LEFT)==0)
               {
               Addr1=MemA8[3]+(BeginOffset / 4);
               MemE =MemA8[3]+(Length / 4);
               }
            else Addr1=0;
            break;
         }
      if (Addr1) do
         {
         Data3=(LONG*)Addr1; Addr1=Addr1+4;
         *Data3=0;
         }
      while (Addr1<MemE);
      }

   for (i=1; i<=2; i++)
      {
      if (((UsedChans & i)==i) && (MyPMsg->MemA24[i-1]))
         {
         if (((MyPMsg->PlayCh[0] & CH_LEFT)==CH_LEFT) && (i==1)) Addr1=MemA8[0]+(BeginOffset / 4)
         else if (((MyPMsg->PlayCh[0] & CH_LEFT)==CH_LEFT) && (i==2)) Addr1=MemA8[1]+(BeginOffset / 4);
         if (((MyPMsg->PlayCh[1] & CH_LEFT)==CH_LEFT) && (i==2)) Addr1=MemA8[2]+(BeginOffset / 4);
         if (((MyPMsg->PlayCh[1] & CH_LEFT)==CH_LEFT) && (i==1)) Addr1=MemA8[3]+(BeginOffset / 4);
         Addr3=MyPMsg->MemA24[i-1]+BeginOffset+4;
         if (AddrA) AddrA=MyPMsg->MemAAlpha[i-1]+((BeginOffset+4) / 80);
         ACtr=20;
         do
            {
            DataS1=(BYTE*)(Addr1); Addr1++;
            Data3=(LONG*)(Addr3);  Addr3=Addr3+4;
            if (!AddrA) *DataS1=*Data3 / SideDiv else
               {
               if (ACtr>=20)
                  {
                  ACtr=0;
                  DataA=(UBYTE*)(AddrA); AddrA++;
                  }
               ACtr++;
               *DataS1=(BYTE)(*Data3 / SideDiv / 255.0 * (*DataA));
               }
            }
         while (Addr3<MyPMsg->MemA24[i-1]+Length);
         }
      }

   // CENTER
   if ((UsedChans & CH_CENTER)==CH_CENTER)
      {
      if ((MyPMsg->PlayCh[0] & CH_CENTER)==CH_CENTER)
         {
         Addr1=MemA8[0]+(BeginOffset / 4);
         Addr2=MemA8[1]+(BeginOffset / 4);
         }
      else
         {
         Addr1=MemA8[3]+(BeginOffset / 4);
         Addr2=MemA8[2]+(BeginOffset / 4);
         }
      Addr3=MyPMsg->MemA24[2]+BeginOffset+4;
      if (AddrA) AddrA=MyPMsg->MemAAlpha[2]+((BeginOffset+4) / 80);
      ACtr=20;
      do
         {
         DataS1=(BYTE*)(Addr1); Addr1++;
         DataS2=(BYTE*)(Addr2); Addr2++;
         Data3=(LONG*)(Addr3);  Addr3=Addr3+4;
         if (MyPMsg->ActiveMode==MD_MONO)
            {
            if (!AddrA)
               {
               *DataS1=*Data3 / CentDiv;
               *DataS2=*Data3 / CentDiv;
               }
            else
               {
               if (ACtr>=20)
                  {
                  ACtr=0;
                  DataA=(UBYTE*)(AddrA); AddrA++;
                  }
               ACtr++;
               *DataS1=(BYTE)(*Data3/CentDiv/255.0*(*DataA));
               *DataS2=(BYTE)(*Data3/CentDiv/255.0*(*DataA));
               }
            }
         else
            {
            if (!AddrA)
               {
               *DataS1=*DataS1 +((*Data3)/CentDiv);
               *DataS2=*DataS2 +((*Data3)/CentDiv);
               }
            else
               {
               if (ACtr>=20)
                  {
                  ACtr=0;
                  DataA=(UBYTE*)(AddrA); AddrA++;
                  }
               ACtr++;
               *DataS1=(BYTE)(*DataS1+(*Data3/CentDiv/255.0*(*DataA)));
               *DataS2=(BYTE)(*DataS2+(*Data3/CentDiv/255.0*(*DataA)));
               }
            }
         }
      while (Addr3<MyPMsg->MemA24[2]+Length);
      }

   if ((MyPMsg->PlayMethod==1) || (MyPMsg->PlayMethod==11))
      {
      // SURROUND LEFT/RIGHT
      for (i=1; i<=2; i++) if (((UsedChans & (i*8))==(i*8)) && (MyPMsg->MemA24[i+2]))
         {
         if ((MyPMsg->PlayCh[0] & CH_SLEFT)==CH_SLEFT)
            {
            Addr1=MemA8[0]+(BeginOffset / 4);
            Addr2=MemA8[1]+(BeginOffset / 4);
            }
         else
            {
            Addr1=MemA8[3]+(BeginOffset / 4);
            Addr2=MemA8[2]+(BeginOffset / 4);
            }
         Addr3=MyPMsg->MemA24[i+2]+BeginOffset+800;
         if (AddrA) AddrA=MyPMsg->MemAAlpha[i+2]+((BeginOffset+804) / 80);
         ACtr=20;
         if (Addr3<MyPMsg->MemA24[i+2]+Length) do
            {
            DataS1=(BYTE*)(Addr1); Addr1++;
            DataS2=(BYTE*)(Addr2); Addr2++;
            Data3=(LONG*)(Addr3);  Addr3=Addr3+4;
            if (!AddrA)
               {
               if (MyPMsg->PlayMethod!=11) *DataS1=*DataS1-(*Data3 / SurrDiv)
               else if (i==1) *DataS1=*DataS1+(*Data3 / SurrDiv);
               if ((MyPMsg->PlayMethod!=11) || (i==2)) *DataS2=*DataS2+(*Data3 / SurrDiv)
               }
            else
               {
               if (ACtr>=20)
                  {
                  ACtr=0;
                  DataA=(UBYTE*)(AddrA); AddrA++;
                  }
               ACtr++;
               if (MyPMsg->PlayMethod!=11) *DataS1=(BYTE)(*DataS1-(*Data3 / SurrDiv / 255.0 * (*DataA)))
               else if (i==1) *DataS1=(BYTE)(*DataS1+(*Data3 / SurrDiv / 255.0 * (*DataA)));
               if ((MyPMsg->PlayMethod!=11) || (i==2)) *DataS2=(BYTE)(*DataS2+(*Data3 / SurrDiv / 255.0 * (*DataA)))
               }
            }
         while (Addr3<MyPMsg->MemA24[i+2]+Length);
         }
      }

   // SUBWOOFER
   if (MyPMsg->MemA24[5])
      {
      if ((MyPMsg->PlayCh[0] & CH_SUB)==CH_SUB)
         {
         Addr1=MemA8[0]+(BeginOffset / 4);
         Addr2=MemA8[1]+(BeginOffset / 4);
         }
      else
         {
         Addr1=MemA8[3]+(BeginOffset / 4);
         Addr2=MemA8[2]+(BeginOffset / 4);
         }
      Addr3=MyPMsg->MemA24[5]+BeginOffset+4;
      if (AddrA) AddrA=MyPMsg->MemAAlpha[5]+((BeginOffset+4)/80);
      ACtr=20;
      do
         {
         DataS1=(BYTE*)(Addr1); Addr1++;
         DataS2=(BYTE*)(Addr2); Addr2++;
         Data3=(LONG*)(Addr3);  Addr3=Addr3+4;
         if (!AddrA)
            {
            if ((MyPMsg->PlayMethod==1) || (MyPMsg->PlayMethod==11))
               {
               *DataS1=*DataS1+(*Data3/SubDiv);
               *DataS2=*DataS2+(*Data3/SubDiv)
               }
            else
               {
               l=*DataS1+(*Data3/SubDiv);
               if (l>128) l=128 else if (l<-127) l=-127;
               *DataS1=l;
               l=*DataS2+(*Data3/SubDiv);
               if (l>128) l=128 else if (l<-127) l=-127;
               *DataS2=l;
               }
            }
         else
            {
            if (ACtr>=20)
               {
               ACtr=0;
               DataA=(UBYTE*)(AddrA); AddrA++;
               }
            ACtr++;
            if ((MyPMsg->PlayMethod==1) || (MyPMsg->PlayMethod==11))
               {
               *DataS1=(BYTE)(*DataS1+(*Data3/SubDiv/255.0*(*DataA)));
               *DataS2=(BYTE)(*DataS2+(*Data3/SubDiv/255.0*(*DataA)));
               }
            else
               {
               l=(LONG)(*DataS1+(*Data3/SubDiv/255.0*(*DataA)));
               if (l>128) l=128 else if (l<-127) l=-127;
               *DataS1=l;
               l=(LONG)(*DataS2+(*Data3/SubDiv/255.0*(*DataA)));
               if (l>128) l=128 else if (l<-127) l=-127;
               *DataS2=l;
               }
            }
         }
      while (Addr3<MyPMsg->MemA24[5]+Length);
      }
   }
}

