#include <exec/types.h>
#include <libraries/dos.h>
#include <intuition/intuitionbase.h>

#ifndef __PPC__
   #include <pragma/all_lib.h>
#endif

#include <WaveTracer/WTincl.h>
#include <WTProcessWave.h>

#include <stdlib.h>


extern PMsg *MyPMsg;

UBYTE ChBit,ChID;

extern void CALCCHANNELS(LONG BeginOffset, LONG EndOffset, UBYTE MyUsedChans);
 


void SCANWAVE(LONG SAddr, LONG AlphaSAddr, LONG *WaveMaxAmp, LONG *AlphaMaxAmp)

{
LONG   Addr1;
LONG  *Data1;
UBYTE *DataA;

*WaveMaxAmp=1; 
*AlphaMaxAmp=1;

if (!SAddr) return;
Addr1=SAddr+MyPMsg->PlayL24;
do
   {
   Addr1=Addr1-4; Data1=(LONG*)Addr1;
   if (labs(*Data1)>*WaveMaxAmp) *WaveMaxAmp=labs(*Data1);
   }
while (Addr1>SAddr);

if (!AlphaSAddr) return;
Addr1=AlphaSAddr+(LONG)(MyPMsg->PlayL24/80.0+0.5);
do
   {
   Addr1--; DataA=(UBYTE*)Addr1;
   if (*DataA>*AlphaMaxAmp) *AlphaMaxAmp=*DataA;
   if (*DataA==0) *DataA=1;
   }
while (Addr1>AlphaSAddr);
}



void PUSHWAVE(LONG SAddr, LONG WaveMaxAmp)

{
FLOAT  WaveAmpFactor;
LONG   Addr1;
LONG  *Data1;

if (!SAddr) return;
WaveAmpFactor=(FLOAT)MAX24/WaveMaxAmp;
if ((WaveAmpFactor==1) || (WaveAmpFactor==0)) return;
Addr1=SAddr+MyPMsg->PlayL24;
do
   {
   Addr1=Addr1-4; Data1=(LONG*)(Addr1);
   *Data1=(LONG)(WaveAmpFactor*(*Data1));
   if (*Data1>MAX24) *Data1=MAX24 else if (*Data1<-MAX24) *Data1=-MAX24;
   }
while (Addr1>SAddr);
}



void PUSHALPHA(LONG AlphaSAddr, LONG AlphaMaxAmp)

{
LONG   Addr1;
UBYTE *DataA;
FLOAT  AmpFactor;

if (!AlphaSAddr) return;
AmpFactor=255.0/AlphaMaxAmp;
if (AmpFactor<=1) return;
Addr1=AlphaSAddr+(LONG)(MyPMsg->PlayL24/80.0+0.5);
do
   {
   Addr1--; DataA=(UBYTE*)Addr1;
   *DataA=(UBYTE)(AmpFactor*(*DataA));
   }
while (Addr1>AlphaSAddr);
}



void CREATESUBWOOFER(UBYTE UsedChans)

{
LONG   Addr1,Addr2,IntData,Check,TFreq,/*OldTFreq,*/RemoveOffset,SubOffsetCtr,l;
LONG  *Data1,*Data2;
UBYTE *DataA1,*DataA2;
UBYTE  i,ChBit;
FLOAT  SampleFreq;

if ((UsedChans==0) || (!MyPMsg->MemA24[5])) return;
ChBit=1;
for (i=0; i<5; i++)
   {
   if (((UsedChans & ChBit)==ChBit) && (MyPMsg->MemA24[i]))
      {
      Addr1=MyPMsg->MemA24[i]+MyPMsg->PlayL24;
      Addr2=MyPMsg->MemA24[5]+MyPMsg->PlayL24;
      do
         {
         Addr1=Addr1-4; Data1=(LONG*)Addr1;
         Addr2=Addr2-4; Data2=(LONG*)Addr2;
         *Data2=*Data2+(*Data1/20)
         }
      while (Addr1>MyPMsg->MemA24[i]);
      if (MyPMsg->MemAAlpha[i])
         {
         Addr1=MyPMsg->MemAAlpha[i]+(LONG)(MyPMsg->MemL24/80.0+0.5);
         Addr2=MyPMsg->MemAAlpha[5]+(LONG)(MyPMsg->MemL24/80.0+0.5);
         do
            {
            Addr1--; DataA1=(UBYTE*)Addr1;
            Addr2--; DataA2=(UBYTE*)Addr2;
            Check=*DataA2+(*DataA1 / 20);
            if (Check>255) Check=255;
            *DataA2=(UBYTE)Check;
            }
         while (Addr1>MyPMsg->MemAAlpha[i]);
         }
      }
   ChBit=ChBit*2;
   }
Addr1=MyPMsg->MemA24[5];
SampleFreq=10000000.0/(MyPMsg->SRate*2.79365);
TFreq=(LONG)(((MAX24*2)/SampleFreq)*(MyPMsg->SubCFreq));
IntData=0;
MyPMsg->WaveMaxAmp=1;
if (MyPMsg->SubOffset!=0) RemoveOffset=MyPMsg->SubOffset else RemoveOffset=0;
MyPMsg->SubOffset=0;
SubOffsetCtr=0;
do
   {
   Data1=(LONG*)Addr1; Addr1=Addr1+4;
   if (labs(*Data1-IntData)>TFreq)
      {
      l=(IntData+(*Data1)) / 80;
      if (*Data1<IntData) *Data1=(LONG)((l+IntData-TFreq)/1.025)
      else *Data1=(LONG)((l+IntData+TFreq)/1.025);
      }
   IntData=*Data1;
   *Data1=*Data1-RemoveOffset;
   MyPMsg->SubOffset=MyPMsg->SubOffset+(LONG)(*Data1/256);
   SubOffsetCtr=SubOffsetCtr+1;
   if (labs(*Data1)>MyPMsg->WaveMaxAmp) MyPMsg->WaveMaxAmp=labs(*Data1);
   }
while (Addr1<MyPMsg->MemA24[5]+MyPMsg->PlayL24);
MyPMsg->SubOffset=(LONG)((MyPMsg->SubOffset/SubOffsetCtr)*256);
if (MyPMsg->WaveMaxAmp>MAX24) PUSHWAVE(MyPMsg->MemA24[5],MyPMsg->WaveMaxAmp);
}



void DOUBLESIZE(LONG SAddr, LONG AlphaSAddr)

{
LONG   Addr1,Addr2,DataH;
LONG  *Data1,*Data2;
UBYTE *DataA1,*DataA2;
UBYTE  DataAH;

if (!SAddr) return;
Addr1=SAddr+MyPMsg->PlayL24;
Addr2=SAddr+(MyPMsg->PlayL24*2);
Data1=(LONG*)Addr1;
do
   {
   Addr2=Addr2-4;    Data2=(LONG*)Addr2;
   *Data2=*Data1;    DataH=*Data1;
   Addr2=Addr2-4;    Data2=(LONG*)Addr2;
   Addr1=Addr1-4;    Data1=(LONG*)Addr1;
   *Data2=(*Data1+DataH)/2;
   }
while ((Addr2>SAddr+4) && (Addr1>SAddr));

if (!AlphaSAddr) return;
Addr1=AlphaSAddr+MyPMsg->PlayL24/80;
Addr2=AlphaSAddr+MyPMsg->PlayL24/40;
DataA1=(UBYTE*)Addr1;
do
   {
   Addr2--;         DataA2=(UBYTE*)Addr2;
   *DataA2=*DataA1; DataAH=*DataA1;
   if (Addr2>AlphaSAddr)
      {
      Addr2--;      DataA2=(UBYTE*)Addr2;
      Addr1--;      DataA1=(UBYTE*)Addr1;
      *DataA2=(UBYTE)(*DataA1/2+DataAH/2);
      }
   }
while ((Addr2>AlphaSAddr) && (Addr1>AlphaSAddr));
}



LONG FINDZERO(LONG SAddr)

{
LONG   Addr1;
LONG  *Data1;   
   
if (!SAddr) return 0;
Addr1=SAddr+MyPMsg->PlayL24;
do
   {
   Addr1=Addr1-4; Data1=(LONG*)Addr1;
   }
while ((Addr1>=SAddr) && (labs(*Data1)<=32));
return Addr1-SAddr+4;
}



void OPTIMIZE(void)

{
UBYTE  i,DataB;
LONG   Addr1,l,PlayLH;
LONG  *Data1;
UBYTE *DataA1;

if (MyPMsg->PlayL24>MyPMsg->MemL24) MyPMsg->PlayL24=MyPMsg->MemL24;
if (MyPMsg->PlayL24<MyPMsg->MemL24)
   {
   for (i=0; i<6; i++) if (MyPMsg->MemA24[i])
      {
      Addr1=MyPMsg->MemA24[i]+MyPMsg->PlayL24;
      do
         {
         Data1=(LONG*)Addr1; Addr1=Addr1+4;
         *Data1=0;
         }
      while (Addr1<MyPMsg->MemA24[i]+MyPMsg->MemL24);
      }
   }
PlayLH=4;
for (i=0; i<6; i++)
   {
   l=FINDZERO(MyPMsg->MemA24[i]);
   if (l>PlayLH) PlayLH=l;
   }
if (PlayLH>4) MyPMsg->PlayL24=(PlayLH/8)*8;
if (MyPMsg->AreaA>=MyPMsg->PlayL24)
   {
   MyPMsg->AreaA=0;
   MyPMsg->AreaE=0;
   }
if (MyPMsg->PlayL24<MyPMsg->MemL24) for (i=0; i<6; i++) if (MyPMsg->MemAAlpha[i])
   {
   Addr1=MyPMsg->MemAAlpha[i]+(MyPMsg->PlayL24/80)-1;
   DataA1=(UBYTE*)Addr1; Addr1++;
   DataB=*DataA1;
   while (Addr1<MyPMsg->MemAAlpha[i]+(LONG)(MyPMsg->MemL24/80.0+0.5))
      {
      DataA1=(UBYTE*)Addr1; Addr1++;
      *DataA1=DataB;
      }
   }
}



void PROCESSWAVE(WORD Action)

{
WORD  i;
LONG  l,b;

switch (Action)
   {
   case 1:
      {
      if (Action==1) OPTIMIZE();
      break;
      }
   case 2:
      {
      ChBit=1;   MyPMsg->UsedChans=0;
      for (i=0; i<5; i++)
         {
         DOUBLESIZE(MyPMsg->MemA24[i],MyPMsg->MemAAlpha[i]);
         if (l>1) MyPMsg->UsedChans=MyPMsg->UsedChans | ChBit;
         ChBit=ChBit*2;
         }
      DOUBLESIZE(MyPMsg->MemA24[5],MyPMsg->MemAAlpha[5]);
      break;
      }
   case 3:
      {
      ChBit=1;   MyPMsg->UsedChans=0;
      for (i=0; i<5; i++)
         {
         SCANWAVE(MyPMsg->MemA24[i],MyPMsg->MemAAlpha[i],&l,&b);
         if (l>1)                   MyPMsg->UsedChans=(MyPMsg->UsedChans | ChBit);
         if (l>MyPMsg->WaveMaxAmp)  MyPMsg->WaveMaxAmp=l;
         if (b>MyPMsg->AlphaMaxAmp) MyPMsg->AlphaMaxAmp=b;
         ChBit=ChBit*2;
         }
      break;
      }
   case 4:
      {
      for (i=0; i<5; i++) PUSHWAVE(MyPMsg->MemA24[i],MyPMsg->WaveMaxAmp);
      break;
      }
   case 5:
      {
      for (i=0; i<5; i++) PUSHALPHA(MyPMsg->MemAAlpha[i],MyPMsg->AlphaMaxAmp);
      break;
      }
   case 6:
      {
      CREATESUBWOOFER(MyPMsg->UsedChans);
      break;
      }
   case 7:
      {
      CALCCHANNELS(MyPMsg->cc_BeginOffset,MyPMsg->cc_EndOffset,MyPMsg->cc_MyUsedChans);
      break;
      }
   }
}

