program animplay;

Uses ExecIO,Intuition;

{$incl "libraries/dos.h"}
{$path "WaveTracer/"; incl "WTIncl.mod"}

const PORT_PROCESS='WTProcessPort';

type p_PMsg=^PMsg;
type PMsg=record
        wt_Node                                 :Message;
        Action                                  :WORD;
        MemA24,MemAAlpha                        :array[1..6] of LONG;
        MemL24,PlayL24,SRate,SubCFreq,SubOffset :LONG;
        AreaA,AreaE,WaveMaxAmp,AlphaMaxAmp      :LONG;
        UsedChans                               :BYTE;
     end;

var ProcessPort                 :^MsgPort;
var MyPMsg                      :^PMsg;
var Leave                       :boolean;
var l,Addr1,DataH               :LONG;
var Data1                       :^LONG;
var ChBit,ChID                  :BYTE;



procedure SCANWAVE(SAddr,AlphaSAddr :long; var WaveMaxAmp :long; var AlphaMaxAmp :byte);

var Addr1       :long;
var Data1       :^long;
var DataA       :^byte;

begin
   WaveMaxAmp:=1; AlphaMaxAmp:=1;
   if SAddr=0 then exit;
   Addr1:=SAddr+MyPMsg^.PlayL24;
   repeat
      Addr1:=Addr1-4; Data1:=ptr(Addr1);
      if abs(Data1^)>WaveMaxAmp then WaveMaxAmp:=abs(Data1^);
   until Addr1<=SAddr;
   if AlphaSAddr<>0 then begin
      Addr1:=AlphaSAddr+round(MyPMsg^.PlayL24/80+0.5);
      repeat
         Addr1:=Addr1-1; DataA:=ptr(Addr1);
         if DataA^>AlphaMaxAmp then AlphaMaxAmp:=DataA^;
         if DataA^=0 then DataA^:=1;
      until Addr1<=AlphaSAddr;
   end;
end;



procedure PUSHWAVE(SAddr,WaveMaxAmp :long);

var WaveAmpFactor       :real;

begin
   if SAddr=0 then exit;
   WaveAmpFactor:=MAX24 / WaveMaxAmp;
   Addr1:=SAddr+MyPMsg^.PlayL24;
   repeat
      Addr1:=Addr1-4; Data1:=ptr(Addr1);
      Data1^:=round(WaveAmpFactor*Data1^);
      if Data1^>MAX24 then Data1^:=MAX24 else if Data1^<-MAX24 then Data1^:=-MAX24;
   until Addr1<=SAddr;
end;



procedure PUSHALPHA(AlphaSAddr,AlphaMaxAmp :long);

var AmpFactor   :real;
var DataA       :^byte;

begin
   if AlphaSAddr=0 then exit;
   AmpFactor:=255 / AlphaMaxAmp;
   Addr1:=AlphaSAddr+round(MyPMsg^.PlayL24/80+0.5);
   repeat
      Addr1:=Addr1-1; DataA:=ptr(Addr1);
      DataA^:=round(AmpFactor*DataA^);
   until Addr1<=AlphaSAddr;
end;



procedure CREATESUBWOOFER(UsedChans :byte);

var Addr1,Addr2,IntData,Check,TFreq,
    OldTFreq,RemoveOffset,SubOffsetCtr  :long;
var Data1,Data2                         :^long;
var DataA1,DataA2                       :^Byte;
var i,ChBit                             :byte;
var SampleFreq                          :real;
var First                               :boolean;

begin
   if (UsedChans=0) then exit;
   ChBit:=1; First:=true;
   for i:=1 to 5 do begin
      if ((UsedChans and ChBit)=ChBit) then begin
         Addr1:=MyPMsg^.MemA24[i]+MyPMsg^.PlayL24;
         Addr2:=MyPMsg^.MemA24[6]+MyPMsg^.PlayL24;
         repeat
            Addr1:=Addr1-4; Data1:=ptr(Addr1);
            Addr2:=Addr2-4; Data2:=ptr(Addr2);
            Data2^:=Data2^+(Data1^ div 20)
         until Addr1<=MyPMsg^.MemA24[i];

         if MyPMsg^.MemAAlpha[i]<>0 then begin
            Addr1:=MyPMsg^.MemAAlpha[i]+round(MyPMsg^.MemL24/80+0.5);
            Addr2:=MyPMsg^.MemAAlpha[6]+round(MyPMsg^.MemL24/80+0.5);
            repeat
               Addr1:=Addr1-1; DataA1:=ptr(Addr1);
               Addr2:=Addr2-1; DataA2:=ptr(Addr2);
               Check:=DataA2^+(DataA1^ div 20);
               if Check>255 then Check:=255; DataA2^:=Check;
            until Addr1<=MyPMsg^.MemAAlpha[i];
         end;
         First:=False;
      end;
      ChBit:=ChBit*2;
   end;
   Addr1:=MyPMsg^.MemA24[6];
   SampleFreq:=10000000/(MyPMsg^.SRate*2.79365);
   TFreq:=round(((MAX24*2)/SampleFreq)*(MyPMsg^.SubCFreq));
   IntData:=0;
   MyPMsg^.WaveMaxAmp:=1;
   if (MyPMsg^.SubOffset<>0) then RemoveOffset:=MyPMsg^.SubOffset else RemoveOffset:=0;
   MyPMsg^.SubOffset:=0; SubOffsetCtr:=0;
   repeat
      Data1:=ptr(Addr1); Addr1:=Addr1+4;
      if ((IntData>0) and (Data1^<=0))
      or ((IntData<0) and (Data1^>=0)) then begin
         if abs(Data1^-IntData)>TFreq then begin
            if OldTFreq*5>TFreq then TFreq:=round(TFreq*1.1)
         end else TFreq:=OldTFreq;
      end;
      if abs(Data1^-IntData)>TFreq then begin
         l:=(IntData+Data1^) div 80;
         if Data1^<IntData then Data1^:=round((l+IntData-TFreq)/1.025)
         else Data1^:=round((l+IntData+TFreq)/1.025);
      end;
      IntData:=Data1^;
      Data1^:=Data1^-RemoveOffset;
      MyPMsg^.SubOffset:=MyPMsg^.SubOffset+round(Data1^/256);
      SubOffsetCtr:=SubOffsetCtr+1;
      if abs(Data1^)>MyPMsg^.WaveMaxAmp then MyPMsg^.WaveMaxAmp:=abs(Data1^);
   until Addr1>=MyPMsg^.MemA24[6]+MyPMsg^.PlayL24;
   MyPMsg^.SubOffset:=round((MyPMsg^.SubOffset/SubOffsetCtr)*256);
   Data2^:=0;
   if MyPMsg^.WaveMaxAmp>MAX24 then PUSHWAVE(MyPMsg^.MemA24[6],MyPMsg^.WaveMaxAmp);
end;



procedure DOUBLESIZE(SAddr,AlphaSAddr :long;);

var Addr1,Addr2         :long;
var Data1,Data2         :^long;
var DataA1,DataA2       :^byte;
var DataAH              :byte;

begin
   if SAddr=0 then exit;
   Addr1:=SAddr+MyPMsg^.PlayL24; Addr2:=SAddr+(MyPMsg^.PlayL24*2);
   Data1:=ptr(Addr1);
   repeat
      Addr2:=Addr2-4;    Data2:=ptr(Addr2);
      Data2^:=Data1^;    DataH:=Data1^;
      Addr2:=Addr2-4;    Data2:=ptr(Addr2);
      Addr1:=Addr1-4;    Data1:=ptr(Addr1);
      Data2^:=(Data1^+DataH) div 2;
   until (Addr2<=SAddr+4) or (Addr1<=SAddr);
   if AlphaSAddr<>0 then begin
      Addr1:=AlphaSAddr+MyPMsg^.PlayL24 div 80;
      Addr2:=AlphaSAddr+MyPMsg^.PlayL24 div 40;
      DataA1:=ptr(Addr1);
      repeat
         Addr2:=Addr2-1;    DataA2:=ptr(Addr2);
         DataA2^:=DataA1^;  DataAH:=DataA1^;
         if Addr2>AlphaSAddr then begin
            Addr2:=Addr2-1;    DataA2:=ptr(Addr2);
            Addr1:=Addr1-1;    DataA1:=ptr(Addr1);
            DataA2^:=round(DataA1^/2+DataAH/2);
         end;
      until (Addr2<=AlphaSAddr) or (Addr1<=AlphaSAddr);
   end;
end;



procedure OPTIMIZE;

var i,DataB             :byte;
var Addr1,l,PlayLH      :long;
var Data1               :^long;
var DataA1              :^byte;


function FINDZERO(SAddr :long):long;

begin
   FINDZERO:=0;
   if SAddr=0 then exit;
   Addr1:=SAddr+MyPMsg^.PlayL24;
   repeat
      Addr1:=Addr1-4; Data1:=ptr(Addr1);
   until ((Addr1<SAddr) or (abs(Data1^)>32));
   FINDZERO:=Addr1-SAddr+4;
end;


begin
   if (MyPMsg^.PlayL24>MyPMsg^.MemL24) then MyPMsg^.PlayL24:=MyPMsg^.MemL24;
   if MyPMsg^.PlayL24<MyPMsg^.MemL24 then begin
      for i:=1 to 6 do if MyPMsg^.MemA24[i]<>0 then begin
         Addr1:=MyPMsg^.MemA24[i]+MyPMsg^.PlayL24;
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data1^:=0;
         until Addr1>=MyPMsg^.MemA24[i]+MyPMsg^.MemL24;
      end;
   end;
   PlayLH:=4;
   for i:=1 to 6 do begin
      l:=FINDZERO(MyPMsg^.MemA24[i]);
      if l>PlayLH then PlayLH:=l;
   end;
   if PlayLH>4 then MyPMsg^.PlayL24:=(PlayLH div 8) * 8;
   if MyPMsg^.AreaA>=MyPMsg^.PlayL24 then begin
      MyPMsg^.AreaA:=0;
      MyPMsg^.AreaE:=0;
   end;
   if MyPMsg^.PlayL24<MyPMsg^.MemL24 then for i:=1 to 6 do if MyPMsg^.MemAAlpha[i]<>0 then begin
      Addr1:=MyPMsg^.MemAAlpha[i]+(MyPMsg^.PlayL24 div 80)-1;
      DataA1:=ptr(Addr1); Addr1:=Addr1+1;
      DataB:=DataA1^;
      while Addr1<MyPMsg^.MemAAlpha[i]+round(MyPMsg^.MemL24/80+0.5) do begin
         DataA1:=ptr(Addr1); Addr1:=Addr1+1;
         DataA1^:=DataB
      end;
   end;
end;



procedure CLEARPORT(PortName :str);

var BadPort     :^MsgPort;
var BadMsg      :^Message;

begin
   BadPort:=FindPort(PortName);
   Forbid;
   while BadPort<>NIL do begin
      BadMsg:=Get_Msg(BadPort);
      while BadMsg<>NIL do begin
         Reply_Msg(BadMsg);
         BadMsg:=Get_Msg(BadPort);
      end;
      RemPort(BadPort);
      BadPort:=FindPort(PortName);
   end;
   Permit;
end;


procedure PROCESSWAVE(Action :WORD);

var i   :integer;
var l   :long;
var b   :byte;

begin

{WaveMaxAmp und AlphaMaxAmp zurckgeben!}
writeln('Working: ',Action);
   if (Action=1) then OPTIMIZE
   else if (Action=2) then begin
      ChBit:=1;   MyPMsg^.UsedChans:=0;
      for i:=1 to 5 do begin
         DOUBLESIZE(MyPMsg^.MemA24[i],MyPMsg^.MemAAlpha[i]);
         if l>1 then MyPMsg^.UsedChans:=MyPMsg^.UsedChans or ChBit;
         ChBit:=ChBit*2;
      end;
      DOUBLESIZE(MyPMsg^.MemA24[6],MyPMsg^.MemAAlpha[6]);
   end else if (Action=3) then begin
      ChBit:=1;   MyPMsg^.UsedChans:=0;
      for i:=1 to 5 do begin
         SCANWAVE(MyPMsg^.MemA24[i],MyPMsg^.MemAAlpha[i],l,b);
         if l>1 then MyPMsg^.UsedChans:=MyPMsg^.UsedChans or ChBit;
         if l>MyPMsg^.WaveMaxAmp then MyPMsg^.WaveMaxAmp:=l;
         if b>MyPMsg^.AlphaMaxAmp then MyPMsg^.AlphaMaxAmp:=b;
         ChBit:=ChBit*2;
      end;
   end else if (Action=4) then begin
      for i:=1 to 5 do PUSHWAVE(MyPMsg^.MemA24[i],MyPMsg^.WaveMaxAmp);
   end else if (Action=5) then begin
      for i:=1 to 5 do PUSHALPHA(MyPMsg^.MemAAlpha[i],MyPMsg^.AlphaMaxAmp);
   end else if (Action=6) then begin
      CREATESUBWOOFER(MyPMsg^.UsedChans);
   end;
writeln('Done!');
end;



Begin
   CLEARPORT(PORT_PROCESS);
   ProcessPort:=CreatePort(PORT_PROCESS,0);
   Leave:=TRUE;
   if ProcessPort<>NIL then repeat
      repeat
         MyPMsg:=p_PMsg(WaitPort(ProcessPort));
         MyPMsg:=p_PMsg(GetMsg(ProcessPort));
      until MyPMsg<>NIL;
      if (MyPMsg^.Action<100) then PROCESSWAVE(MyPMsg^.Action)
      else Leave:=TRUE;
      ReplyMsg(p_Message(MyPMsg));
   until Leave;
   CLEARPORT(PORT_PROCESS);
end;






