#include <exec/types.h>
#include <exec/ports.h>
#include <intuition/intuitionbase.h>

#include <pragma/all_lib.h>

#include <clib/graphics_protos.h>
#include <clib/exec_protos.h>

struct DataArr        
   {
   LONG DataAddr[16];
   };
struct AnimMsg
   {
   Message   wt_Node;
   Window   *IntuiWindow3;
   UBYTE     NewColorR[32],NewColorG[32],NewColorB[32];
   UBYTE     ColorR[256],ColorG[256],ColorB[256];
   Screen   *MyScreen,*MyScreen3;
   BitMap   *MyAnimBitMap[2];
   UBYTE     AnimAScr,Depth;
   UWORD     Width,Height;
   BOOL      HAMAnim;
   APTR      DeltaMemA;
   BOOL      Kompressed;
   };

extern AnimMsg *MyAMsg;   
extern LONG     BPRow,ColumnTarget,RowOffset;
extern UBYTE    NewColorPos;
extern BYTE     Col2Col[256],LastR,LastG,LastB;
extern WORD     PixX,PixY,LastPixX;

DataArr *DArr;



void READBITMAP(UBYTE AScr)

{
LONG  Size;
WORD  ii,j,Zeile,Plane;
BYTE  *Head,*Body,*Mem;
LONG Adr;

for (Zeile=0; Zeile<MyAMsg->Height; Zeile++)
 for (Plane=0; Plane<MyAMsg->Depth; Plane++)
   {
   Adr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[Plane])+((Zeile)*BPRow);
   Size=(MyAMsg->Width+7)/8;
   if (!MyAMsg->Kompressed)
      {
      CopyMem(MyAMsg->DeltaMemA,(APTR)Adr,Size);
      MyAMsg->DeltaMemA=(APTR)((LONG)MyAMsg->DeltaMemA+Size);
      }
   else
      {
      ii=0;
      while (ii<Size)
         {
         Head=(BYTE*)MyAMsg->DeltaMemA; 
         MyAMsg->DeltaMemA=(APTR)((LONG)MyAMsg->DeltaMemA+1);
         if (*Head>=0)
            {
            CopyMem(MyAMsg->DeltaMemA,(APTR)(Adr+ii),(LONG)(*Head+1));
            MyAMsg->DeltaMemA=(APTR)((LONG)MyAMsg->DeltaMemA+*Head+1);
            ii=(WORD)(ii+*Head+1);
            }
         else
            {
            Body=(BYTE*)MyAMsg->DeltaMemA; 
            MyAMsg->DeltaMemA=(APTR)((LONG)MyAMsg->DeltaMemA+1);
            for (j=1; j<=(1-*Head); j++)
               {
               Mem=(BYTE*)(Adr+ii);
               *Mem=*Body;
               ii=(ii+1);
               }
            }
         }
      }
   }
}



void ANIM8_32(UBYTE AScr)

{
WORD   ii,j;
LONG   Addr,PlaneAddr,ColumnCtr,OpCtr;
ULONG *OpCode,*Data1,*Data2;
BOOL   NewVert;

DArr=(DataArr*)MyAMsg->DeltaMemA;
for (ii=0; ii<=15; ii++) if (DArr->DataAddr[ii])
   {
   if (ii>=MyAMsg->Depth) return;
   Addr=DArr->DataAddr[ii]+(LONG)MyAMsg->DeltaMemA;
   ColumnCtr=-4;
   OpCtr=0;
   PlaneAddr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii])+RowOffset;
   while (ColumnCtr<ColumnTarget)
      {
      OpCode=(ULONG*)Addr; Addr=Addr+4;
      if (!OpCtr) NewVert=TRUE;
      if (NewVert)
         {
         ColumnCtr=ColumnCtr+4;
         PlaneAddr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii])+ColumnCtr+RowOffset;
         OpCtr=*OpCode;
         if (OpCtr)
            {
            OpCtr=*OpCode;
            NewVert=FALSE;
            OpCode=(ULONG*)Addr; Addr=Addr+4;
            }
         }
      if ((ColumnCtr<ColumnTarget) && (!NewVert))
         {
         if ((*OpCode & 0x80000000)==0x80000000)
            {
            for (j=1; j<=(*OpCode & 0x7FFFFFFF); j++)
               {
               Data1=(ULONG*)Addr;      Addr=Addr+4;
               Data2=(ULONG*)PlaneAddr; PlaneAddr=PlaneAddr+BPRow;
               *Data2=*Data1;
               }
            OpCtr=OpCtr-1;
            }
         else if (!*OpCode)
            {
            OpCode=(ULONG*)Addr; Addr=Addr+4;
            Data1=(ULONG*)Addr;  Addr=Addr+4;
            for (j=1; j<=*OpCode; j++)
               {
               Data2=(ULONG*)PlaneAddr; PlaneAddr=PlaneAddr+BPRow;
               *Data2=*Data1;
               }
            OpCtr=OpCtr-1;
            }
         else if ((*OpCode & 0x80000000)==0x00000000)
            {
            PlaneAddr=PlaneAddr+(BPRow*(*OpCode));
            OpCtr=OpCtr-1;
            }
         }
      }
   }
}



void ANIM8_16(UBYTE AScr)

{
WORD  ii,j;
LONG  Addr,PlaneAddr,ColumnCtr,OpCtr;
UWORD *OpCode,*Data1,*Data2;
BOOL  NewVert;

DArr=(DataArr*)MyAMsg->DeltaMemA;
for (ii=0; ii<=15; ii++) if (DArr->DataAddr[ii]==0)
   {
   if (ii>=MyAMsg->Depth) return;
   Addr=DArr->DataAddr[ii]+(LONG)MyAMsg->DeltaMemA;
   ColumnCtr=-2;
   OpCtr=0;
   PlaneAddr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii])+RowOffset;
   while (ColumnCtr<ColumnTarget)
      {
      OpCode=(UWORD*)Addr; Addr=Addr+2;
      if (!OpCtr) NewVert=TRUE;
      if (NewVert)
         {
         ColumnCtr=ColumnCtr+2;
         PlaneAddr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii])+ColumnCtr+RowOffset;
         OpCtr=*OpCode;
         if (OpCtr)
            {
            OpCtr=*OpCode;
            NewVert=FALSE;
            OpCode=(UWORD*)Addr; Addr=Addr+2;
            }
         }
      if ((ColumnCtr<ColumnTarget) && (!NewVert))
         {
         if ((*OpCode & 0x8000)==0x8000)
            {
            for (j=1; j<=(*OpCode & 0x7FFF); j++)
               {
               Data1=(UWORD*)Addr;      Addr=Addr+2;
               Data2=(UWORD*)PlaneAddr; PlaneAddr=PlaneAddr+BPRow;
               *Data2=*Data1;
               }
            OpCtr=OpCtr-1;
            }
         else if (!*OpCode)
            {
            OpCode=(UWORD*)Addr; Addr=Addr+2;
            Data1=(UWORD*)Addr;  Addr=Addr+2;
            for (j=1; j<=*OpCode; j++)
               {
               Data2=(UWORD*)PlaneAddr; PlaneAddr=PlaneAddr+BPRow;
               *Data2=*Data1;
               }
            OpCtr=OpCtr-1;
            }
         else if ((*OpCode & 0x8000)==0x0000)
            {
            PlaneAddr=PlaneAddr+(BPRow*(*OpCode));
            OpCtr=OpCtr-1;
            }            
         }
      }
   }
}



void ANIM7_32(UBYTE AScr)

{
WORD  ii,j;
LONG  OpAddr,DAddr,PlaneAddr,ColumnCtr;
ULONG *DataL1,*DataL2;
UBYTE *OpCode;
UBYTE OpCtr;
BOOL  NewVert;

DArr=(DataArr*)MyAMsg->DeltaMemA;
for (ii=0; ii<=7; ii++) if (!(DArr->DataAddr[ii]==0))
   {
   if (ii>=MyAMsg->Depth) return;
   OpAddr=(DArr->DataAddr[ii])+(LONG)MyAMsg->DeltaMemA;
   DAddr=(DArr->DataAddr[ii+8])+(LONG)MyAMsg->DeltaMemA;
   ColumnCtr=-4;
   OpCtr=0;
   PlaneAddr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii])+RowOffset;
   while (ColumnCtr<ColumnTarget)
      {
      OpCode=(UBYTE*)OpAddr; OpAddr=OpAddr+1;
      if (!OpCtr) NewVert=TRUE;
      if (NewVert)
         {
         ColumnCtr=ColumnCtr+4;
         PlaneAddr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii])+ColumnCtr+RowOffset;
         OpCtr=*OpCode;
         if (OpCtr)
            {
            OpCtr=*OpCode;
            NewVert=FALSE;
            OpCode=(UBYTE*)OpAddr; OpAddr=OpAddr+1;
            }
         }
      if ((ColumnCtr<ColumnTarget) && (!(NewVert)))
         {
         if (((*OpCode) & 0x80)==0x80)
            {
            for (j=1; j<=(WORD)((*OpCode) & 0x7F); j++)
               {
               DataL1=(ULONG*)DAddr;     DAddr=DAddr+4;
               DataL2=(ULONG*)PlaneAddr; PlaneAddr=PlaneAddr+BPRow;
               *DataL2=*DataL1;
               }
            OpCtr=OpCtr-1;
            }
         else if (!*OpCode)
            {
            OpCode=(UBYTE*)OpAddr; OpAddr=OpAddr+1;
            DataL1=(ULONG*)DAddr;  DAddr=DAddr+4;
            for (j=1; j<=(WORD)(*OpCode); j++)
               {
               DataL2=(ULONG*)PlaneAddr; PlaneAddr=PlaneAddr+BPRow;
               *DataL2=*DataL1;
               }
            OpCtr=OpCtr-1;
            }
         else if (((*OpCode) & 0x80)==0)
            {
            PlaneAddr=PlaneAddr+(BPRow*(*OpCode));
            OpCtr=OpCtr-1;
            }
         }
      }
   }
}



void ANIM7_16(UBYTE AScr)

{
WORD  ii,j;
LONG  OpAddr,DAddr,PlaneAddr,ColumnCtr;
UWORD *DataW1,*DataW2;
UBYTE *OpCode;
UBYTE OpCtr;
BOOL  NewVert;

DArr=(DataArr*)MyAMsg->DeltaMemA;
for (ii=0; ii<=7; ii++) if (!(DArr->DataAddr[ii]==0))
   {
   if (ii>=MyAMsg->Depth) return;
   OpAddr=(DArr->DataAddr[ii])+(LONG)MyAMsg->DeltaMemA;
   DAddr=(DArr->DataAddr[ii+8])+(LONG)MyAMsg->DeltaMemA;
   ColumnCtr=-2;
   OpCtr=0;
   PlaneAddr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii])+RowOffset;
   while (ColumnCtr<ColumnTarget)
      {
      OpCode=(UBYTE*)OpAddr; OpAddr=OpAddr+1;
      if (!OpCtr) NewVert=TRUE;
      if (NewVert)
         {
         ColumnCtr=ColumnCtr+2;
         PlaneAddr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii])+ColumnCtr+RowOffset;
         OpCtr=*OpCode;
         if (OpCtr)
            {
            OpCtr=*OpCode;
            NewVert=FALSE;
            OpCode=(UBYTE*)OpAddr; OpAddr=OpAddr+1;
            }
         }
      if ((ColumnCtr<ColumnTarget) && (!(NewVert)))
         {
         if ((*OpCode & 0x80)==0x80)
            {
            for (j=1; j<=(WORD)((*OpCode) & 0x7F); j++)
               {
               DataW1=(UWORD*)DAddr;     DAddr=DAddr+2;
               DataW2=(UWORD*)PlaneAddr; PlaneAddr=PlaneAddr+BPRow;
               *DataW2=*DataW1;
               }
            OpCtr=OpCtr-1;
            }
         else if (!*OpCode)
            {
            OpCode=(UBYTE*)OpAddr; OpAddr=OpAddr+1;
            DataW1=(UWORD*)DAddr;  DAddr=DAddr+2;
            for (j=1; j<=(WORD)(*OpCode); j++)
               {
               DataW2=(UWORD*)PlaneAddr; PlaneAddr=PlaneAddr+BPRow;
               *DataW2=*DataW1;
               }
            OpCtr=OpCtr-1;
            }
         else if ((*OpCode & 0x80)==0)
            {
            PlaneAddr=PlaneAddr+(BPRow*(*OpCode));
            OpCtr=OpCtr-1;
            }
         }
      }
   }
}



void ANIM5(UBYTE AScr)

{
UBYTE  ii,OpCtr;
WORD   j;
ULONG  Addr,PlaneAddr,EndAddr;
LONG   ColumnCtr; 
UBYTE *OpCode,*Data1,*Data2;
BOOL   NewVert;


DArr=(DataArr*)MyAMsg->DeltaMemA;
for (ii=0; ii<=15; ii++) if (DArr->DataAddr[ii])
   {
   if (ii>=MyAMsg->Depth) return;
   EndAddr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii])+(BPRow*(LONG)(MyAMsg->MyAnimBitMap[AScr]->Rows));
   Addr=(DArr->DataAddr[ii])+(LONG)MyAMsg->DeltaMemA;
   ColumnCtr=-1;
   OpCtr=0;
   PlaneAddr=(LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii])+RowOffset;
   NewVert=TRUE;
   while (ColumnCtr<ColumnTarget)
      {
      OpCode=(UBYTE*)Addr; Addr++;
      if (!OpCtr) NewVert=TRUE;
      if (NewVert)
         {
         ColumnCtr++;
         PlaneAddr=((LONG)(MyAMsg->MyAnimBitMap[AScr]->Planes[ii]))+ColumnCtr+RowOffset;
         OpCtr=*OpCode;
         if (OpCtr)
            {
            OpCtr=*OpCode;
            NewVert=FALSE;
            OpCode=(UBYTE*)Addr; Addr++;
            }
         }
      if ((ColumnCtr<ColumnTarget) && (!NewVert))
         {
         if ((*OpCode & 0x80)==0x80)
            {
            for (j=1; j<=(WORD)((*OpCode) & 0x7F); j++) if (PlaneAddr<EndAddr)
               {
               Data1=(UBYTE*)Addr;      Addr++;
               Data2=(UBYTE*)PlaneAddr;
               *Data2=*Data1;
               PlaneAddr=PlaneAddr+BPRow;
               }
            OpCtr--;
            }
         else if (!*OpCode)
            {
            OpCode=(UBYTE*)Addr; Addr++;
            Data1=(UBYTE*)Addr;  Addr++;
            for (j=1; j<=(WORD)(*OpCode); j++) if (PlaneAddr<EndAddr)
               {
               Data2=(UBYTE*)PlaneAddr; PlaneAddr=PlaneAddr+BPRow;
               *Data2=*Data1;
               };
            OpCtr--;
            }
         else if ((*OpCode & 0x80)==0x00)
            {
            PlaneAddr=PlaneAddr+(BPRow*(*OpCode));
            OpCtr--;
            }
         }
      }
   }
}

