program animplay;

Uses ExecIO,Graphics,Intuition;

{$incl "AGA.lib"}

{path "WaveTracer/"; incl "WTIncl.mod"}

const PORT_ANIM='WTAnimPort';

type BArr32=array[0..31] of byte;
type BArr256=array[0..255] of byte;
type RPArr2=array[1..2] of RastPort;

type p_AnimMsg=^AnimMsg;
type AnimMsg=Record
        wt_Node                       :Message;
        IntuiWindow3                  :^Window;
        NewColorR,NewColorG,NewColorB :BArr32;
        ColorR,ColorG,ColorB          :BArr256;
        MyScreen                      :^Screen;
        MyAnimRastPort                :RPArr2;
        AnimAScr                      :byte;
        Depth                         :byte;
        Width,Height                  :word;
        Test                          :string[6];
     end;

var MyAMsg                      :^AnimMsg;
var NewColorPos                 :byte;
var Col2Col                     :array[0..255] of short;

var HAMAnim,Leave       :boolean;
var AnimPort            :^MsgPort;


procedure SCALEDOWNIMAGE(AnimAScr :byte);

var x,y,i,PixX,PixY,BPixX,BPixY,
    BeforeColor                 :integer;
var MyColor                     :byte;
var ColorFound,DoHAM            :boolean;
var MinDifference,MinPos,w      :word;
var FactorX,FactorY             :real;
var WinX,WinY                   :word;



procedure FINDREALCOLOR;

var XR,XG,XB                    :integer;
var XColor                      :byte;

begin
   XR:=-1;   XG:=-1;   XB:=-1;
   repeat
      XColor:=ReadPixel(^MyAMsg^.MyAnimRastPort[AnimAScr],PixX,PixY);
      if MyAMsg^.Depth=6 then begin
         case (XColor and $30) of
            $00: begin
                    if XR<0 then XR:=MyAMsg^.ColorR[XColor];
                    if XG<0 then XG:=MyAMsg^.ColorG[XColor];
                    if XB<0 then XB:=MyAMsg^.ColorB[XColor];
                 end;
            $20: if XR<0 then XR:=((XColor and $F)*17);
            $30: if XG<0 then XG:=((XColor and $F)*17);
            $10: if XB<0 then XB:=((XColor and $F)*17);
         end;
      end else begin
         case (XColor and $C0) of
            $00: begin
                    if XR<0 then XR:=MyAMsg^.ColorR[XColor];
                    if XG<0 then XG:=MyAMsg^.ColorG[XColor];
                    if XB<0 then XB:=MyAMsg^.ColorB[XColor];
                 end;
            $80: if XR<0 then XR:=(XColor and $3F*4);
            $C0: if XG<0 then XG:=(XColor and $3F*4);
            $40: if XB<0 then XB:=(XColor and $3F*4);
         end;
      end;
      PixX:=PixX-1;
   until (XR>=0) and (XG>=0) and (XB>=0);
   MyAMsg^.ColorR[255]:=XR;
   MyAMsg^.ColorG[255]:=XG;
   MyAMsg^.ColorB[255]:=XB;
end;



begin
   AnimAScr:=3-AnimAScr;
   if not (AnimAScr in [1,2]) then exit;
   for i:=8 to 23 do begin
      MyAMsg^.NewColorR[i]:=0;
      MyAMsg^.NewColorG[i]:=0;
      MyAMsg^.NewColorB[i]:=0;
   end;
   NewColorPos:=8;
   for i:=0 to 255 do Col2Col[i]:=-1;
   WinX:=(MyAMsg^.IntuiWindow3^.Width-24);
   WinY:=(MyAMsg^.IntuiWindow3^.Height-20);
   FactorX:=MyAMsg^.Width/WinX;
   FactorY:=MyAMsg^.Height/WinY;
   BPixX:=0;
   BPixY:=0;
   BeforeColor:=1000;
   for y:=0 to pred(WinY) do for x:=0 to pred(WinX) do begin
      PixX:=round(x*FactorX); PixY:=round(y*FactorY);
      if (PixX=BPixX) and (PixY=BPixY) and (BPixX>0) and (BPixY>0) then
       WritePixel(MyAMsg^.IntuiWindow3^.RPort,x+5,y+17) else begin
         BPixX:=PixX; BPixY:=PixY;
         MyColor:=ReadPixel(^MyAMsg^.MyAnimRastPort[AnimAScr],PixX,PixY);
         if HAMAnim and
         (((MyAMsg^.Depth=8) and (MyColor>63)) or
         ((MyAMsg^.Depth=6) and (MyColor>15))) then begin
            MyColor:=255;
            Col2Col[255]:=-1;
            FINDREALCOLOR;
         end;
         if (BeforeColor=MyColor) and (MyAMsg^.IntuiWindow3<>NIL) and
            (x+5<=MyAMsg^.IntuiWindow3^.Width-19) and (y+17<=MyAMsg^.IntuiWindow3^.Height-3)
            then WritePixel(MyAMsg^.IntuiWindow3^.RPort,x+5,y+17)
         else begin
            BeforeColor:=MyColor;
            if Col2Col[MyColor]=-1 then begin
               ColorFound:=false;
               for i:=0 to 31 do if not (ColorFound)
                and ((i<NewColorPos) or (i>23))
                and (MyAMsg^.NewColorR[i]=MyAMsg^.ColorR[MyColor])
                and (MyAMsg^.NewColorG[i]=MyAMsg^.ColorG[MyColor])
                and (MyAMsg^.NewColorB[i]=MyAMsg^.ColorB[MyColor]) then begin
                  ColorFound:=true;
                  Col2Col[MyColor]:=i;
               end;
               if not ColorFound then begin
                  MinDifference:=64000;
                  for i:=0 to 31 do
                  if (i<NewColorPos) or (i>23) then begin
                     w:=abs(MyAMsg^.NewColorR[i]-MyAMsg^.ColorR[MyColor])
                       +abs(MyAMsg^.NewColorG[i]-MyAMsg^.ColorG[MyColor])
                       +abs(MyAMsg^.NewColorB[i]-MyAMsg^.ColorB[MyColor]);
                     if w<MinDifference then begin
                        MinPos:=i;
                        MinDifference:=w;
                     end;
                  end;
                  if (NewColorPos>23) or (MinDifference<24) then begin
                     ColorFound:=true;
                     Col2Col[MyColor]:=MinPos;
                  end;
               end;
               if not ColorFound and (NewColorPos<24) then begin
                  Col2Col[MyColor]:=NewColorPos;
                  MyAMsg^.NewColorR[NewColorPos]:=MyAMsg^.ColorR[MyColor];
                  MyAMsg^.NewColorG[NewColorPos]:=MyAMsg^.ColorG[MyColor];
                  MyAMsg^.NewColorB[NewColorPos]:=MyAMsg^.ColorB[MyColor];
                  SetRGB32(^MyAMsg^.MyScreen^.ViewPort,NewColorPos,MyAMsg^.NewColorR[NewColorPos]*$1000000,MyAMsg^.NewColorG[NewColorPos]*$1000000,MyAMsg^.NewColorB[NewColorPos]*$1000000);
                  NewColorPos:=NewColorPos+1;
                  ColorFound:=true;
               end;
            end;
            if (MyAMsg^.IntuiWindow3<>NIL) and
            (x+5<=MyAMsg^.IntuiWindow3^.Width-19) and (y+17<=MyAMsg^.IntuiWindow3^.Height-3) then begin
               SetAPen(MyAMsg^.IntuiWindow3^.RPort,Col2Col[MyColor]);
               WritePixel(MyAMsg^.IntuiWindow3^.RPort,x+5,y+17);
            end;
         end;
      end;
   end;
end;



procedure CLEARPORT(PortName :str);

var BadPort     :^MsgPort;
var BadMsg      :^Message;

begin
   BadPort:=FindPort(PortName);
   Forbid;
   while BadPort<>NIL do begin
      BadMsg:=Get_Msg(BadPort);
      while BadMsg<>NIL do begin
         Reply_Msg(BadMsg);
         BadMsg:=Get_Msg(BadPort);
      end;
      RemPort(BadPort);
      BadPort:=FindPort(PortName);
   end;
   Permit;
end;


Begin {*** ANIMPLAY ***}
   OpenLib(IntBase,'intuition.library',39);
   OpenLib(GfxBase,'graphics.library',39);
   CLEARPORT(PORT_ANIM);
   AnimPort:=CreatePort(PORT_ANIM,0);
   Leave:=TRUE;
   if AnimPort<>NIL then repeat
      repeat
         MyAMsg:=p_AnimMsg(WaitPort(AnimPort));
         MyAMsg:=p_AnimMsg(GetMsg(AnimPort));
      until MyAMsg<>NIL;
writeln(MyAMsg^.Width,' x ',MyAMsg^.Height);
      if (MyAMsg^.AnimAScr=10) then Leave:=TRUE else SCALEDOWNIMAGE(MyAMsg^.AnimAScr);
      PutMsg(MyAMsg^.wt_Node.mn_ReplyPort,^MyAMsg^.wt_Node);
   until Leave;
   CLEARPORT(PORT_ANIM);
   CloseLib(GfxBase);
   CloseLib(IntBase);
end;


