#include <exec/types.h>
#include <intuition/intuitionbase.h>
#include <intuition/screens.h>

#include <pragma/all_lib.h>

#include <clib/exec_protos.h>
#include <clib/graphics_protos.h>

#include <stdlib.h>
#include <iostream.h>

#define PORT_ANIM "WTAnimPort"

extern void READBITMAP(UBYTE AScr);
extern void ANIM5(UBYTE AScr);
extern void ANIM7_16(UBYTE AScr);
extern void ANIM7_32(UBYTE AScr);
extern void ANIM8_16(UBYTE AScr);
extern void ANIM8_32(UBYTE AScr);

struct AnimMsg
   {
   Message   wt_Node;
   Window   *IntuiWindow3;
   UBYTE     NewColorR[32],NewColorG[32],NewColorB[32];
   UBYTE     ColorR[256],ColorG[256],ColorB[256];
   Screen   *MyScreen,*MyScreen3;
   BitMap   *MyAnimBitMap[2];
   UBYTE     AnimAScr,Depth;
   UWORD     Width,Height;
   BOOL      HAMAnim;
   APTR      DeltaMemA;
   BOOL      Kompressed;
   };


struct IntuitionBase *IntuitionBase;
struct GfxBase       *GfxBase;

AnimMsg *MyAMsg;
UBYTE    NewColorPos;
BYTE     Col2Col[256],LastR,LastG,LastB;
BOOL     Leave;
MsgPort *AnimPort;
WORD     PixX,PixY,LastPixX;
LONG     BPRow,ColumnTarget,RowOffset;



UBYTE GetPixel(BitMap *MyBitMap, WORD PosX, WORD PosY)

{
LONG   AddrOffset;
UBYTE *Data1;
UBYTE  Bits[8]={0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};
UBYTE  d,BitNum,BitMask,Color;

Color=0; BitNum=1; Color=0;
AddrOffset=(MyBitMap->BytesPerRow*PosY)+(PosX/8);
BitMask=Bits[PosX%8];
for (d=0; d<MyBitMap->Depth; d++)
   {
   Data1=(UBYTE*)((LONG)MyBitMap->Planes[d]+AddrOffset);
   if ((*Data1 & BitMask)==BitMask) Color=Color+BitNum;
   BitNum=BitNum<<1;
   }
return Color;
}



void FINDREALCOLOR(UBYTE AnimAScr)

{
WORD  XR,XG,XB,BakPixX;
UBYTE XColor;


BakPixX=PixX;
XR=-1;   XG=-1;   XB=-1;
MyAMsg->ColorR[255]=0;
MyAMsg->ColorG[255]=0;
MyAMsg->ColorB[255]=0;
do
   {
   XColor=GetPixel(MyAMsg->MyAnimBitMap[AnimAScr],PixX,PixY);
   if (MyAMsg->Depth==6) switch (XColor & 0x30)
      {
      case 0x00:
         if (XR<0) XR=MyAMsg->ColorR[XColor];
         if (XG<0) XG=MyAMsg->ColorG[XColor];
         if (XB<0) XB=MyAMsg->ColorB[XColor];
         break;
      case 0x20:
         if (XR<0) XR=((XColor & 0xF)*17);
         break;
      case 0x30:
         if (XG<0) XG=((XColor & 0xF)*17);
         break;
      case 0x10:
         if (XB<0) XB=((XColor & 0xF)*17);
         break;
      }
   else switch (XColor & 0xC0)
      {
      case (0x00):
         if (XR<0) XR=MyAMsg->ColorR[XColor];
         if (XG<0) XG=MyAMsg->ColorG[XColor];
         if (XB<0) XB=MyAMsg->ColorB[XColor];
         break;
      case (0x80):
         if (XR<0) XR=((XColor & 0x3F)*4);
         break;
      case (0xC0):
         if (XG<0) XG=((XColor & 0x3F)*4);
         break;
      case (0x40):
         if (XB<0) XB=((XColor & 0x3F)*4);
         break;
      }
   PixX--;
   if (PixX==LastPixX)
      {
      if (XR<0) XR=LastR;
      if (XG<0) XG=LastG;
      if (XB<0) XB=LastB;
      }
   if (PixX==-1)
      {
      if (XR>0) MyAMsg->ColorR[255]=XR; LastR=MyAMsg->ColorR[255];
      if (XG>0) MyAMsg->ColorG[255]=XG; LastG=MyAMsg->ColorG[255];
      if (XB>0) MyAMsg->ColorB[255]=XB; LastB=MyAMsg->ColorB[255];
      LastPixX=BakPixX;
      return;
      }
   }
while ((XR<0) || (XG<0) || (XB<0));
MyAMsg->ColorR[255]=XR; LastR=XR;
MyAMsg->ColorG[255]=XG; LastG=XG;
MyAMsg->ColorB[255]=XB; LastB=XB;
LastPixX=BakPixX;
}



void SCALEDOWNIMAGE(UBYTE AnimAScr)

{
WORD  x,y,i,BPixX,BPixY,BeforeColor,OffsetX,OffsetY,ColNum;
UBYTE MyColor;
BOOL  ColorFound;
UWORD MinDifference,MinPos,w,WinX,WinY;
FLOAT FactorX,FactorY;
ViewPort *MyView;


if (MyAMsg->MyScreen3)
   {
   ColNum=1<<MyAMsg->Depth;
   for (i=0; i<ColNum; i++) SetRGB32(&MyAMsg->MyScreen3->ViewPort,i,MyAMsg->ColorR[i]*0x1000000,MyAMsg->ColorG[i]*0x1000000,MyAMsg->ColorB[i]*0x1000000);
   return;
   }
AnimAScr=(3-AnimAScr)-1;
if ((AnimAScr>1) || (AnimAScr<0)) return;
for (i=8; i<=23; i++)
   {
   MyAMsg->NewColorR[i]=0;
   MyAMsg->NewColorG[i]=0;
   MyAMsg->NewColorB[i]=0;
   }
NewColorPos=8;
for (i=0; i<=255; i++) Col2Col[i]=-1;
WinX=MyAMsg->IntuiWindow3->Width-MyAMsg->IntuiWindow3->BorderLeft-MyAMsg->IntuiWindow3->BorderRight+2;
WinY=MyAMsg->IntuiWindow3->Height-MyAMsg->IntuiWindow3->BorderTop-MyAMsg->IntuiWindow3->BorderBottom+2;
OffsetX=MyAMsg->IntuiWindow3->BorderLeft+1 -4;
OffsetY=MyAMsg->IntuiWindow3->BorderTop+1 -16;
FactorX=(FLOAT)(MyAMsg->Width)/WinX;   FactorY=(FLOAT)(MyAMsg->Height)/WinY;
BPixX=0;                               BPixY=0;
BeforeColor=1000;
for (y=0; y<WinY; y++) for (x=0; x<WinX; x++)
   {
   PixX=(WORD)(x*FactorX);
   PixY=(WORD)(y*FactorY);
   if ((PixX==BPixX) && (PixY==BPixY) && (BPixX>0))
      {
      WritePixel(MyAMsg->IntuiWindow3->RPort,x+OffsetX,y+OffsetY);
      }
   else
      {
      BPixX=PixX; BPixY=PixY;
      MyColor=GetPixel(MyAMsg->MyAnimBitMap[AnimAScr],PixX,PixY);
      if ((MyAMsg->HAMAnim) &&
          (((MyAMsg->Depth==8) && (MyColor>63)) ||
           ((MyAMsg->Depth==6) && (MyColor>15))))
         {
         MyColor=255;
         Col2Col[255]=-1;
         MyAMsg->ColorR[255]=(MyAMsg->ColorR[255]/16)*16;
         MyAMsg->ColorG[255]=(MyAMsg->ColorG[255]/16)*16;
         MyAMsg->ColorB[255]=(MyAMsg->ColorB[255]/16)*16;
         FINDREALCOLOR(AnimAScr);
         }
      if (((BeforeColor==MyColor) && (MyAMsg->IntuiWindow3)) &&
          (x+5<=MyAMsg->IntuiWindow3->Width-19) && (y+17<=MyAMsg->IntuiWindow3->Height-3))
         {
         WritePixel(MyAMsg->IntuiWindow3->RPort,x+OffsetX,y+OffsetY);
         }
      else
         {
         BeforeColor=MyColor;
         if (Col2Col[MyColor]==-1)
            {
            ColorFound=FALSE;
            for (i=0; i<=31; i++) if (!ColorFound)
               {
               if (((i<NewColorPos) || (i>23)) &&
                   (MyAMsg->NewColorR[i]==MyAMsg->ColorR[MyColor]) &&
                   (MyAMsg->NewColorG[i]==MyAMsg->ColorG[MyColor]) &&
                   (MyAMsg->NewColorB[i]==MyAMsg->ColorB[MyColor]))
                  {
                  ColorFound=TRUE;
                  Col2Col[MyColor]=i;
                  }
               }
            if (!ColorFound)
               {
               MinDifference=64000;
               for (i=0; i<=31; i++) if ((i<NewColorPos) || (i>23))
                  {
                  w=labs(MyAMsg->NewColorR[i]-MyAMsg->ColorR[MyColor])+
                    labs(MyAMsg->NewColorG[i]-MyAMsg->ColorG[MyColor])+
                    labs(MyAMsg->NewColorB[i]-MyAMsg->ColorB[MyColor]);
                  if (w<MinDifference)
                     {
                     MinPos=i;
                     MinDifference=w;
                     }
                  }
               if ((NewColorPos>23) || 
                   ((MinDifference<24) && (!MyAMsg->HAMAnim)) ||
                   ((MinDifference<=32) && (MyAMsg->HAMAnim)))
                  {
                  ColorFound=TRUE;
                  Col2Col[MyColor]=MinPos;
                  }
               }
            if ((!ColorFound) && (NewColorPos<24))
               {
               Col2Col[MyColor]=NewColorPos;
               MyAMsg->NewColorR[NewColorPos]=MyAMsg->ColorR[MyColor];
               MyAMsg->NewColorG[NewColorPos]=MyAMsg->ColorG[MyColor];
               MyAMsg->NewColorB[NewColorPos]=MyAMsg->ColorB[MyColor];
               MyView=&MyAMsg->MyScreen->ViewPort;
               SetRGB32(MyView,NewColorPos,MyAMsg->NewColorR[NewColorPos]*0x1000000,MyAMsg->NewColorG[NewColorPos]*0x1000000,MyAMsg->NewColorB[NewColorPos]*0x1000000);
               NewColorPos++;
               ColorFound=TRUE;
               }
            }
         if ((MyAMsg->IntuiWindow3) &&
             (x+5<=MyAMsg->IntuiWindow3->Width-19) && (y+17<=MyAMsg->IntuiWindow3->Height-3))
            {
            SetAPen(MyAMsg->IntuiWindow3->RPort,Col2Col[MyColor]);
            WritePixel(MyAMsg->IntuiWindow3->RPort,x+OffsetX,y+OffsetY);
            }
         }
      }
   }
};



void CLEARPORT(char *PortName)

{
MsgPort *BadPort;
Message *BadMsg;


BadPort=FindPort(PortName);
Forbid();
while (BadPort)
   {
   BadMsg=GetMsg(BadPort);
   while (BadMsg)
      {
      ReplyMsg(BadMsg);
      BadMsg=GetMsg(BadPort);
      }
   RemPort(BadPort);
   DeleteMsgPort(BadPort);
   BadPort=FindPort(PortName);
   }
Permit();
}



void main(void)

{
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
#ifdef __PPC__
   PowerPCBase=OpenLibrary("powerpc.library",14)
   if (!PowerPCBase) return;
#endif
if ((IntuitionBase) && (GfxBase))
   {
   CLEARPORT(PORT_ANIM);
   AnimPort=CreateMsgPort();
   AnimPort->mp_Node.ln_Pri=0;
   AnimPort->mp_Node.ln_Name=PORT_ANIM;
   if (AnimPort)
      {
      AddPort(AnimPort);
      Leave=FALSE;
      if (AnimPort) do
         {
         do
            {
            MyAMsg=(AnimMsg*)WaitPort(AnimPort);
            MyAMsg=(AnimMsg*)GetMsg(AnimPort);
            }
         while (!MyAMsg);         
         if (MyAMsg->AnimAScr>=0x10)
            {
            BPRow=(MyAMsg->MyAnimBitMap[(MyAMsg->AnimAScr & 0x0F)]->BytesPerRow);
            ColumnTarget=MyAMsg->Width/8;
            RowOffset=0;
            switch  (MyAMsg->AnimAScr & 0xF0)
               {
               case 0x10:
                  READBITMAP(MyAMsg->AnimAScr & 0x0F);
                  break;
               case 0x20:
                  ANIM5(MyAMsg->AnimAScr & 0x0F);
                  break;
               case 0x30:
                  ANIM7_16(MyAMsg->AnimAScr & 0x0F);
                  break;
               case 0x40:
                  ANIM7_32(MyAMsg->AnimAScr & 0x0F);
                  break;
               case 0x50:
                  ANIM8_16(MyAMsg->AnimAScr & 0x0F);
                  break;
               case 0x60:
                  ANIM8_32(MyAMsg->AnimAScr & 0x0F);
                  break;
               default:
                  break;
               }
            }
         else if (MyAMsg->AnimAScr==10) Leave=TRUE
         else SCALEDOWNIMAGE(MyAMsg->AnimAScr);
         ReplyMsg((Message*)MyAMsg);         
         }
      while (!Leave);
      CLEARPORT(PORT_ANIM);
      }
   }
if (GfxBase) CloseLibrary((Library*)GfxBase);
if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
#ifdef __PPC__
   CloseLibrary(PoerPCBase);
#endif
}
