Program IFF;


Label 98,99;

{$incl"libraries/dos.h","intuition.lib","graphics.lib","exec/memory.h"}

Type
 BitMapHeader=Record
   Width,Height:Word;
   dX,dY:Integer;
   Depth,Mask:Byte;
   Kompr,pad:Boolean;
   transcolor:Word;
   XAspect,YAspect:Byte;
   SWidth,SHeight:integer
 End;

Var Fhandle,Breite,Hhe,l                         :Long;
var MyScreen                                      :p_Screen;
var MyView                                        :p_ViewPort;
var FName                                         :string[100];
var Hunkname:string[5];
var LongWord,Anz,LineSize:Long;
var ErrorFlag,HeadFlag,BodyFlag,NoFE              :Boolean;
var BMHD:BitMapHeader;
var BMap,ScrMode:Long;
var i,Zeile,Plane,Count:integer;
var RGB: array [0..63] of Record r,g,b                             :Byte End;


Procedure FileError;

Begin
   writeln('File Error!');
   ErrorFlag:=true;
   NoFE:=false;
End;

Procedure OverRead(L:Long);
  Var buf:String[50]; Anz:Long;
  Begin
    While (L>50) and not ErrorFlag Do
      Begin
        Anz:=DosRead(Fhandle,^buf,50);
        L:=L-50;
        If Anz<>50 Then FileError
      End;
    Anz:=DosRead(FHandle,^Buf,L mod 50)
  End;

Procedure ReadHunkName;
  Var Anz:Long;
  Begin
    If not ErrorFlag Then
      Begin
        Hunkname[5]:=chr(0);
        Anz:=DosRead(FHandle,^Hunkname,4);
        If Anz<>4 Then FileError
      End
  End;

Procedure ReadLong;
  Var Anz:Long;
  Begin
    If not ErrorFlag Then
      Begin
        Anz:=DosRead(FHandle,^Longword,4);
        If Anz<>4 Then FileError
      End
  End;


Procedure LiesZeile(Adr:Long);

var Anz,Count,Size      :Long;
var i,j                 :integer;
var Head,Body           :Short;
var Mem                 :^Short;
  Begin
    If Not ErrorFlag Then
      Begin
        Size:=(BMHD.Width+7)div 8;
        If not BMHD.Kompr Then
          Begin
            Anz:=DosRead(FHandle,ptr(Adr),Size);
            If Anz<>Size Then FileError
          End
        Else
          Begin
            i:=0;
            While (i<Size) and not ErrorFlag Do
              Begin
                Anz:=DosRead(FHandle,^Head,1);
                If Head>=0 Then
                  Begin
                    Anz:=DosRead(FHandle,Ptr(Adr+i),Head+1);
                    If Anz<>Head+1 Then FileError;
                    i:=i+Head+1
                  End
                Else
                  Begin
                    Anz:=DosRead(FHandle,^Body,1);
                    If Anz<>1 Then FileError;
                    For j:=1 to 1-Head Do
                      Begin
                        Mem:=Ptr(Adr+i);
                        Mem^:=Body;
                        i:=i+1
                      End
                  End
              End
          End;
    End
  End;



procedure SAVEILBM;

var s                   :string;
var l,Pos               :long;
var d,x,y               :word;
var PlaneAddr           :array [0..5] of long;
var CrMemA,CrMemL,SizeX :long;
var Inh1,Inh2,Dat,Head  :^Short;
var Addr1,Addr2,AddrD   :long;

begin
   CrMemL:=MyScreen^.Width;
   CrMemA:=AllocFastFirst(CrMemL,MEMF_CLEAR);
   if CrMemA=0 then exit;
   FName:=FName+'2';
   FHandle:=DosOpen(FName,MODE_NEWFILE);
   if Fhandle=0 then exit;

   s:='FORM    ILBMBMHD';
   l:=DosWrite(FHandle,^s,16);
   l:=sizeof(BitMapHeader);
   l:=DosWrite(FHandle,^l,4);         {Kompr}
   BMHD:=BitMapHeader(320,256,0,0,5,0,true,false,0,0,0,320,256);
   l:=DosWrite(FHandle,^BMHD,sizeof(BitMapHeader));

   s:='CMAP';
   l:=DosWrite(FHandle,^s,4);
   l:=96;
   l:=DosWrite(FHandle,^l,4);
   for i:=0 to 31 do l:=DosWrite(FHandle,^RGB[i],3);

   s:='BODY    ';
   l:=DosWrite(FHandle,^s,8);
   Pos:=DosSeek(FHandle,0,OFFSET_CURRENT);
   l:=MyScreen^.Height*MyScreen^.Width*6 div 8;
   for i:=0 to 4 do PlaneAddr[i]:=long(MyScreen^.BitMap.Planes[i]);
   for y:=1 to MyScreen^.Height do begin
      for d:=0 to 4 do begin
         Addr1:=PlaneAddr[d];
         Addr2:=PlaneAddr[d]+1;
         AddrD:=CrMemA;

         Head:=ptr(AddrD); AddrD:=AddrD+1;
         Inh1:=ptr(Addr1); Addr1:=Addr1+1;
         Inh2:=ptr(Addr2); Addr2:=Addr2+1;
         repeat
            {if Inh1^=Inh2^ then begin}
               Head^:=1;
               Dat:=ptr(AddrD); AddrD:=AddrD+1;
               Dat^:=Inh1^;
               repeat
                  Inh1:=ptr(Addr1); Addr1:=Addr1+1;
                  Head^:=Head^-1
               until (Dat^<>Inh1^) or (Addr1>PlaneAddr[d]+40);
               if Addr1>PlaneAddr[d]+40 then Head^:=Head^-1;
               Head:=ptr(AddrD); AddrD:=AddrD+1;
               Addr2:=Addr1+1;
               Inh1:=ptr(Addr1-1);
               Inh2:=ptr(Addr2-1);
            {end else begin
               Head^:=-1;
               repeat
                  Dat:=ptr(AddrD); AddrD:=AddrD+1;
                  Dat^:=Inh1^;
                  Inh1:=ptr(Addr1); Addr1:=Addr1+1;
                  Inh2:=ptr(Addr2); Addr2:=Addr2+1;
                  Head^:=Head^+1;
               until (Inh1^=Inh2^) or (Addr1>PlaneAddr[d]+40);
               Head:=ptr(AddrD); AddrD:=AddrD+1;
               Inh1:=ptr(Addr1-1);
               Inh2:=Ptr(Addr2-1);
            end;    }
         until Addr1>PlaneAddr[d]+40-1;
         SizeX:=AddrD-CrMemA-1;
         l:=DosWrite(FHandle,ptr(CrMemA),SizeX);
         PlaneAddr[d]:=PlaneAddr[d]+MyScreen^.BitMap.BytesPerRow;
      end;
   end;
   SizeX:=DosSeek(FHandle,0,OFFSET_CURRENT)-Pos;
   l:=DosSeek(FHandle,Pos-4,OFFSET_BEGINNING);
   l:=DosWrite(FHandle,^SizeX,4);
   l:=DosSeek(FHandle,0,OFFSET_END);

   l:=DosSeek(FHandle,4,OFFSET_BEGINNING);
   l:=l-8;
   l:=DosWrite(FHandle,^l,4);
   DosClose(FHandle);
   FreeMem(CrMemA,CrMemL);
End;



Begin
  NoFE:=true;
  OpenLib(intbase,'intuition.library',0);
  OpenLib(gfxbase,'graphics.library' ,0);
  FName:='HD2:Artemis.pic';
  If FName='' then Goto 99;
  ErrorFlag:=false; HeadFlag:=false; Bodyflag:=false;
  Fhandle:=DosOpen(FName,MODE_OLDFILE);
  If FHandle=0 Then
    Begin writeln('Datei konnte nicht geffnet werden.');
      Goto 99 End;
   ReadHunkName;
   If HunkName<>'FORM' Then
     Begin writeln('Kein IFF-Format.'); Goto 98 End;
   ReadLong; ReadHunkName;
   If HunkName<>'ILBM' Then
     Begin writeln('Kein ILBM-File.'); Goto 98 End;
   ReadHunkName;
   While Not Errorflag Do
     Begin
       ReadLong;
       If not FromWB Then writeln(HunkName,LongWord:8);
       If HunkName='BMHD' Then
         Begin
           Anz:=DosRead(fhandle,^BMHD,SizeOf(BitMapHeader));
           OverRead(LongWord-SizeOf(BitMapHeader));
           If not FromWB Then With BMHD Do
             Begin
               writeln('Breite:  ',Width);
               writeln('Hhe:    ',Height);
               writeln('Screen:  ',SWidth,'x',SHeight);
               writeln('Tiefe:   ',Depth);
               writeln('Maske:   ',Mask);
               If Kompr Then writeln('Komprimiert')
             End;
           With BMHD Do
             Begin
               ScrMode:=GENLOCK_VIDEO;
               If SWidth>320 Then
                 ScrMode:=ScrMode+HIRES;
               If SHeight>256 Then ScrMode:=ScrMode+LACE;
               Breite:=round(BMHD.Width);
               MyScreen:=Open_Screen(0,0,Breite,Height,Depth,0,1,ScrMode,FName);
             End;
           MyView:=^MyScreen^.ViewPort;
           HeadFlag:=true
         End
       Else
       If HunkName='CMAP' Then Begin
          If not Headflag Then FileError;
          For i:=0 to LongWord div 3-1 Do Begin
             Anz:=DosRead(FHandle,^RGB[i],3);
             If Anz<>3 Then FileError;
             SetRGB4(MyView,i,RGB[i].r div 16,RGB[i].g div 16,RGB[i].b div 16);
          End;
       End
       Else
       if HunkName='CAMG' then begin
          l:=DosRead(FHandle,^ScrMode,4);
       end else
       If HunkName='BODY' Then
         Begin
           If Bodyflag or not HeadFlag Then FileError;
           BMap:=Long(^MyScreen^.BitMap);
           LineSize:=(MyScreen^.Width+7) div 8;
           For Zeile:=0 to BMHD.Height-1 Do
             For Plane:=0 to pred(BMHD.Depth) Do
               LiesZeile(Long(MyScreen^.BitMap.Planes[Plane])+Zeile*MyScreen^.BitMap.BytesPerRow);
           BodyFlag:=true;
         End
       Else
         OverRead(LongWord);
       If not ErrorFlag Then
         Begin
           Hunkname[5]:=chr(0);
           Anz:=DosRead(FHandle,^Hunkname,4);
           ErrorFlag:=Anz<>4
         End
     End;

  Hhe:=BMHD.Height;
  98:DosClose(FHandle);
  SAVEILBM;
  delay(100);
  If HeadFlag Then Close_Screen(MyScreen);
  99:
End.


