#include <exec/types.h>
#include <stdlib.h>
#include "common.h"
#include "encoder.h"
#include "l3psy.h"
#include "mdct.h"
#include "loop.h"
#include "l3bitstream.h"
//#include <assert.h>

extern WTStdMsg *MyWTStdMsg;

layer        info;
frame_params fr_ps;
LONG         Addr1,Addr2,AddrE;

Bit_stream_struc   bs;
char               *programName;



void obtain_parameters(frame_params *fr_ps, int *psy, unsigned long *num_samples)

{
int j;
long int freq;
int model, brt;
char t[50];
layer *info = fr_ps->header;
long soundPosition;

open_bit_stream_w(&bs,BUFFER_SIZE);
/*if ((soundPosition = aiff_read_headers(musicin, &pcm_aiff_data)) != -1) 
   {
   aiff_check(original_file_name, &pcm_aiff_data, &info->version);
   if (fseek(musicin, soundPosition, SEEK_SET) != 0) 
      {
      printf("Could not seek to PCM sound data in \"%s\".\n",original_file_name);
      exit(1);
      }
   info->sampling_frequency=SmpFrqIndex((long)pcm_aiff_data.sampleRate, &info->version);
   printf(">>> %f Hz sampling frequency selected\n",pcm_aiff_data.sampleRate);
   *num_samples = (long)(pcm_aiff_data.numChannels) *(long)(pcm_aiff_data.numSampleFrames);
   }
else exit(-1);*/
if ((MyWTStdMsg->ActiveChannels & CH_LEFT+CH_RIGHT)==CH_LEFT+CH_RIGHT)
   {
   info->mode=MPG_MD_STEREO;
   Addr1=MyWTStdMsg->MemA24[0];
   Addr2=MyWTStdMsg->MemA24[1];
   *num_samples=MyWTStdMsg->PlayL24;
   /*
   MPG_MD_JOINT_STEREO;
   MPG_MD_DUAL_CHANNEL;
   MPG_MD_MONO;
   */
   }
else
   {
   info->mode=MPG_MD_MONO;
   Addr1=MyWTStdMsg->MemA24[2];
   *num_samples=MyWTStdMsg->PlayL24/2;
   }
AddrE=Addr1+MyWTStdMsg->PlayL24;
info->sampling_frequency=2;
if ((info->sampling_frequency==0) || (info->sampling_frequency==1) ||
    (info->sampling_frequency==2)) *psy=2
else
   {
   *psy=1;
   if (info->lay==3)
      {
      printf("Illegal samplefrequency for layer III\n");
      //ErrorFlag=TRUE;
      return;
      }
   }     
info->emphasis=0;
//DeEmphasis 0 - keine   1 - 1/50 mysec   3 - citt

info->extension = 0;
// Private-Bit

info->error_protection = TRUE;
info->copyright = 0;
info->original = 0;
}



int frameNum=0;

BOOL SAVEMPEG(void)

{
    typedef double SBS[2][3][SCALE_BLOCK][SBLIMIT];
    SBS  FAR        *sb_sample;
    L3SBS  FAR        *l3_sb_sample;
    typedef double JSBS[3][SCALE_BLOCK][SBLIMIT];
    JSBS FAR        *j_sample;
    typedef double IN[2][HAN_SIZE];
    IN   FAR        *win_que;
    typedef unsigned int SUB[2][3][SCALE_BLOCK][SBLIMIT];
    SUB  FAR        *subband;
    
    char original_file_name[MAX_NAME_SIZE];
    char encoded_file_name[MAX_NAME_SIZE];
    short FAR **win_buf;
    static short FAR buffer[2][1152];
    static unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT];
    static unsigned int scalar[2][3][SBLIMIT], j_scale[3][SBLIMIT];
    static double FAR ltmin[2][SBLIMIT], lgmin[2][SBLIMIT], max_sc[2][SBLIMIT];
    FLOAT snr32[32];
    short sam[2][1344]; /* was [1056]; */
    int whole_SpF, extra_slot = 0;
    double avg_slots_per_frame, frac_SpF, slot_lag;
    int model, stereo, error_protection;
    static unsigned int crc;
    int i, j, k, adb;
    unsigned long bitsPerSlot, samplesPerFrame;
    unsigned long frameBits, sentBits = 0;
    unsigned long num_samples;
    
    sb_sample = (SBS FAR *) mem_alloc(sizeof(SBS), "sb_sample");
    l3_sb_sample = (L3SBS FAR *) mem_alloc(sizeof(SBS), "l3_sb_sample");
    j_sample = (JSBS FAR *) mem_alloc(sizeof(JSBS), "j_sample");
    win_que = (IN FAR *) mem_alloc(sizeof(IN), "Win_que");
    subband = (SUB FAR *) mem_alloc(sizeof(SUB),"subband");
    win_buf = (short FAR **) mem_alloc(sizeof(short *)*2, "win_buf");
 
    /* clear buffers */
    memset((char *) buffer, 0, sizeof(buffer));
    memset((char *) bit_alloc, 0, sizeof(bit_alloc));
    memset((char *) scalar, 0, sizeof(scalar));
    memset((char *) j_scale, 0, sizeof(j_scale));
    memset((char *) scfsi, 0, sizeof(scfsi));
    memset((char *) ltmin, 0, sizeof(ltmin));
    memset((char *) lgmin, 0, sizeof(lgmin));
    memset((char *) max_sc, 0, sizeof(max_sc));
    memset((char *) snr32, 0, sizeof(snr32));
    memset((char *) sam, 0, sizeof(sam));
    obtain_parameters(&fr_ps, &model, &num_samples);
    hdr_to_frps(&fr_ps);
    stereo = fr_ps.stereo;
    error_protection = info.error_protection;
    
    if (info.lay == 1)
    { bitsPerSlot = 32; samplesPerFrame = 384;  }
    else 
	if ( info.lay == 2 )
	{ bitsPerSlot = 8;  samplesPerFrame = 1152; }
	else	
	{  /* layer 3 */
	    bitsPerSlot = 8;
	    samplesPerFrame = info.version == 1 ? 1152 : 576;
	    
	    /* Apologize for missing features */
	    if ( info.mode == MPG_MD_JOINT_STEREO )
	    {
		fprintf( stderr, "Sorry, joint stereo not yet available for layer3\n" );
		exit( 1 );
	    }
#if 0
	    if ( info.version != MPEG_AUDIO_ID )
	    {
		fprintf( stderr, "Sorry, MPEG2-LSF not yet available for layer3\n" );
		exit( 1 );
	    }
#endif
	    if ( model != 2 )
	    {
		fprintf( stderr, "Sorry, psycho model 1 not available for layer3\n" );
		exit( 1 );
	    }
	}

    /* Figure average number of 'slots' per frame. */
    /* Bitrate means TOTAL for both channels, not per side. */
    avg_slots_per_frame = ((double)samplesPerFrame /
                           s_freq[info.version][info.sampling_frequency]) *
			   ((double)bitrate[info.version][info.lay-1][info.bitrate_index] /
			    (double)bitsPerSlot);
    whole_SpF = (int) avg_slots_per_frame;
    printf("slots/frame = %d\n",whole_SpF);
    frac_SpF  = avg_slots_per_frame - (double)whole_SpF;
    slot_lag  = -frac_SpF;
    printf("frac SpF=%.3f, tot bitrate=%d kbps, s freq=%.1f kHz\n",
           frac_SpF, bitrate[info.version][info.lay-1][info.bitrate_index],
           s_freq[info.version][info.sampling_frequency]);
    
    if (frac_SpF != 0)
	printf("Fractional number of slots, padding required\n");
    else info.padding = 0;
    while ( get_audio(buffer, num_samples, stereo, &info) > 0 )
    {
    printf("{%4lu}", frameNum++);
	win_buf[0] = &buffer[0][0];
	win_buf[1] = &buffer[1][0];
	if (frac_SpF != 0) {
	    if (slot_lag > (frac_SpF-1.0) ) {
		slot_lag -= frac_SpF;
		extra_slot = 0;
		info.padding = 0;
		/*  printf("No padding for this frame\n"); */
	    }
	    else {
		extra_slot = 1;
		info.padding = 1;
		slot_lag += (1-frac_SpF);
		/*  printf("Padding for this frame\n");    */
	    }
	}
	adb = (whole_SpF+extra_slot) * bitsPerSlot;
	switch (info.lay)
	{
	    
/***************************** Layer I **********************************/
	    
          case 1 :
	    for (j=0;j<SCALE_BLOCK;j++)
		for (k=0;k<stereo;k++) {
		    window_subband(&win_buf[k], &(*win_que)[k][0], k);
		    filter_subband(&(*win_que)[k][0], &(*sb_sample)[k][0][j][0]);
		}
	    
	    I_scale_factor_calc(*sb_sample, scalar, stereo);
	    if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {
                I_combine_LR(*sb_sample, *j_sample);
                I_scale_factor_calc(j_sample, &j_scale, 1);
	    }
	    
	    put_scale(scalar, &fr_ps, max_sc);
	    
	    if (model == 1) I_Psycho_One(buffer, max_sc, ltmin, &fr_ps);
	    else {
                for (k=0;k<stereo;k++) {
		    psycho_anal(&buffer[k][0],&sam[k][0], k, info.lay, snr32,
				(double)s_freq[info.version][info.sampling_frequency]*1000);
		    for (i=0;i<SBLIMIT;i++) ltmin[k][i] = (double) snr32[i];
                }
	    }
	    
	    I_main_bit_allocation(ltmin, bit_alloc, &adb, &fr_ps);
	    
	    if (error_protection) I_CRC_calc(&fr_ps, bit_alloc, &crc);
	    
	    encode_info(&fr_ps, &bs);
	    
	    if (error_protection) encode_CRC(crc, &bs);
	    
	    I_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
	    I_encode_scale(scalar, bit_alloc, &fr_ps, &bs);
	    I_subband_quantization(scalar, *sb_sample, j_scale, *j_sample,
				   bit_alloc, *subband, &fr_ps);
	    I_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);
	    for (i=0;i<adb;i++) put1bit(&bs, 0);
	    break;
	    
/***************************** Layer 2 **********************************/
	    
          case 2 :
	    for (i=0;i<3;i++) for (j=0;j<SCALE_BLOCK;j++)
                for (k=0;k<stereo;k++) {
		    window_subband(&win_buf[k], &(*win_que)[k][0], k);
		    filter_subband(&(*win_que)[k][0], &(*sb_sample)[k][i][j][0]);
                }
	    II_scale_factor_calc(*sb_sample, scalar, stereo, fr_ps.sblimit);
	    pick_scale(scalar, &fr_ps, max_sc);
	    if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {
		II_combine_LR(*sb_sample, *j_sample, fr_ps.sblimit);
		II_scale_factor_calc(j_sample, &j_scale, 1, fr_ps.sblimit);
	    }       /* this way we calculate more mono than we need */
	    /* but it is cheap */
printf("%d Hz\n",s_freq[info.version][info.sampling_frequency]*1000);
	    if (model == 1) II_Psycho_One(buffer, max_sc, ltmin, &fr_ps);
	    else {
		for (k=0;k<stereo;k++) {
		    psycho_anal(&buffer[k][0],&sam[k][0], k,info.lay, snr32,
				(double)s_freq[info.version][info.sampling_frequency]*1000);
		    for (i=0;i<SBLIMIT;i++) ltmin[k][i] = (double) snr32[i];
		}
	    }
	    II_transmission_pattern(scalar, scfsi, &fr_ps);
	    II_main_bit_allocation(ltmin, scfsi, bit_alloc, &adb, &fr_ps);
	    
	    if (error_protection)
		II_CRC_calc(&fr_ps, bit_alloc, scfsi, &crc);
	    encode_info(&fr_ps, &bs);
	    
	    if (error_protection) encode_CRC(crc, &bs);
	    
	    II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
	    II_encode_scale(bit_alloc, scfsi, scalar, &fr_ps, &bs);
	    II_subband_quantization(scalar, *sb_sample, j_scale,
				    *j_sample, bit_alloc, *subband, &fr_ps);
	    II_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);
	    for (i=0;i<adb;i++) put1bit(&bs, 0);
	    break;
	    
/***************************** Layer 3 **********************************/

	  case 3:
	  {
	      /*
		large "auto" vars are static due to the Macintosh linker
	      */ 
	      static double xr[2][2][576];
	      static double xr_dec[2][2][576];
	      static double pe[2][2];
	      static int l3_enc[2][2][576];
	      static III_psy_ratio ratio;
	      static III_side_info_t l3_side;
	      static III_scalefac_t  scalefac;
	      int gr, mode_gr, ch;
	      int mean_bits, sideinfo_len;
	      
	      int bitsPerFrame = 8 * whole_SpF + (info.padding * 8);
	      mode_gr = (info.version == 1) ? 2 : 1;

	      /*
		determine the mean bitrate for main data
	      */
	      sideinfo_len = 32;
	      if ( info.version == 1 )
	      {   /* MPEG 1 */
		  if ( stereo == 1 )
		      sideinfo_len += 136;
		  else
		      sideinfo_len += 256;
	      }
	      else
	      {   /* MPEG 2 */
		  if ( stereo == 1 )
		      sideinfo_len += 72;
		  else
		      sideinfo_len += 136;
	      }
	      if ( info.error_protection )
		  sideinfo_len += 16;
	      mean_bits = (bitsPerFrame - sideinfo_len) / mode_gr;

	      /*
		psychoacoustic model
	      */
	      for ( gr = 0; gr < mode_gr; gr++ )
		  for ( ch = 0; ch < stereo; ch++ )
		  {
		      L3psycho_anal( &buffer[ch][gr*576], &sam[ch][0], ch, info.lay,
				     snr32, s_freq[info.version][info.sampling_frequency] * 1000.0,
				     &ratio.l[gr][ch][0], &ratio.s[gr][ch][0],
				     &pe[gr][ch], &l3_side.gr[gr].ch[ch].tt );
		  }

	      /*
		polyphase filtering
	      */
	      for( gr = 0; gr < mode_gr; gr++ )
		  for ( ch = 0; ch < stereo; ch++ )
		      for ( j = 0; j < 18; j++ )
		      {
			  window_subband( &win_buf[ch], &(*win_que)[ch][0], ch );
			  filter_subband( &(*win_que)[ch][0],  &(*l3_sb_sample)[ch][gr+1][j][0] );
		      };

	      /*
		apply mdct to the polyphase outputs
	      */
	      mdct_sub( l3_sb_sample, xr, stereo, &l3_side, mode_gr );
#if 0
	      delay( xr, stereo );
#endif
	      /*
		bit and noise allocation
	      */
	      iteration_loop( pe, xr, &ratio, &l3_side, l3_enc, mean_bits,
			      stereo, xr_dec, &scalefac, &fr_ps, 0, bitsPerFrame );

	      /*
		write the frame to the bitstream
	      */
	      III_format_bitstream( bitsPerFrame, &fr_ps, l3_enc, &l3_side, &scalefac, &bs,
				    xr, NULL, 0 );
	  }
	    break;  /* end of layer 3 */
	    

	} /* end switch  */
	
	frameBits = sstell( &bs ) - sentBits;
	if ( frameBits % bitsPerSlot )   /* a program failure */
	    fprintf( stderr, "Sent %ld bits = %ld slots plus %ld\n",
		     frameBits, frameBits/bitsPerSlot,
		     frameBits%bitsPerSlot );
	sentBits += frameBits;

    }    

    if ( info.lay == 3 )
	III_FlushBitstream();

    close_bit_stream_w( &bs );

    printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",
           (FLOAT) sentBits / (frameNum * bitsPerSlot),
           (FLOAT) sentBits / (frameNum * samplesPerFrame),
           (FLOAT) sentBits / (frameNum * samplesPerFrame) *
           s_freq[info.version][info.sampling_frequency]);
printf("%d",info.version);           
return TRUE;
}
