#include <exec/types.h>

#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>


extern struct DOSBase *DOSBase;

struct VoiceHeader
   {
   UWORD DataOffset,Version,VersionKompl;
   };
struct NewVoiceBlock
   {
   UBYTE ID,b1,b2,b3,SampleRate,Compression;
   };
struct ModeBlock
   {
   UBYTE ID,b1,b2,b3,d1,d2,d3,d4;
   };


VoiceHeader   VoiceHD={0x1A00,2561,10513};
NewVoiceBlock NVBlk;
//MessageBlock  MsgBlk;
ModeBlock     MdBlk;

LONG  l,m,MemLLoad;
APTR  MemALoad=NULL;
UBYTE b1,b2,b3;


void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



void MAKEMURX(LONG a)

{
b3=(a & 0x00FF0000)/0x10000;
b2=(a & 0x0000FF00)/0x100;
b1=(a & 0x000000FF);
}



BOOL GETSAVEMEM(void)

{
MemLLoad=100032;
MemALoad=AllocVec(MemLLoad,MEMF_FAST);
if (!MemALoad)
   {
   MemLLoad=AvailMem(MEMF_LARGEST)-640;
   if (MemLLoad>=640)
      {
      MemALoad=AllocVec(MemLLoad,MEMF_FAST);
      if (!MemALoad) return FALSE;
      }
   else return FALSE;
   }
return TRUE;
}



BOOL SAVEVOC(void)

{
UBYTE  ChCnt,b1,Chan1,Chan2;
LONG   Addr1,Addr2,Addr8;
LONG  *Data1;
UBYTE *Data8;
char   s[100];


if (!GETSAVEMEM())
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return FALSE;
   }
MyWTStdMsg->Flags=0;
strncpy(s,"Creative Voice File",20);
Write(MyWTStdMsg->ActFHandle,&s,19);
b1=0x1A;
Write(MyWTStdMsg->ActFHandle,&b1,1);

Write(MyWTStdMsg->ActFHandle,&VoiceHD,sizeof(VoiceHeader));
if ((MyWTStdMsg->ActiveChannels==CH_CENTER) || (MyWTStdMsg->ActiveChannels==CH_LEFT))
   {
   ChCnt=1;
   if ((MyWTStdMsg->ActiveChannels & CH_LEFT)==CH_LEFT) Chan1=1 else Chan1=3;
   Chan2=0;
   }
else
   {
   ChCnt=2;
   Chan1=1; Chan2=2;
   }
MdBlk.ID=8;
MdBlk.b1=4; MdBlk.b2=0; MdBlk.b3=0;
if (Chan2==0)
   {
   MdBlk.d1=0xA3; MdBlk.d2=0xD2; 
   MdBlk.d3=0x00; MdBlk.d4=0x01;
   }
else
   {
   MdBlk.d1=0x54; MdBlk.d2=0xE9; 
   MdBlk.d3=0x00; MdBlk.d4=0x01;
   }
Write(MyWTStdMsg->ActFHandle,&MdBlk,sizeof(ModeBlock));

MAKEMURX((MyWTStdMsg->PlayL24/4)*ChCnt+2);
NVBlk.ID=1;
NVBlk.b1=b1; NVBlk.b2=b2; NVBlk.b3=b3;
NVBlk.SampleRate=(UBYTE)(256-0.28*MyWTStdMsg->SRate);
NVBlk.Compression=0;
Write(MyWTStdMsg->ActFHandle,&NVBlk,sizeof(NewVoiceBlock));
   // Voc=256-0,28*SRate  
   //
   //           Voc-256   
   // SRate= - ---------
   //             0,28

Addr1=MyWTStdMsg->MemA24[Chan1-1]; Addr2=MyWTStdMsg->MemA24[Chan2-1];
do
   {
   Addr8=(LONG)MemALoad;
   do
      {
      Data8=(UBYTE*)Addr8; Addr8++;
      Data1=(LONG*)Addr1;  Addr1=Addr1+4;
      *Data8=(*Data1/65536)+127;
      if (Addr2)
         {
         Data8=(UBYTE*)Addr8; Addr8++;         
         Data1=(LONG*)Addr2;  Addr2=Addr2+4;
         *Data8=(*Data1/65536)+127;
         }
      }
   while ((Addr8<(LONG)MemALoad+MemLLoad) && (Addr1<MyWTStdMsg->MemA24[Chan1-1]+MyWTStdMsg->PlayL24));
   l=Write(MyWTStdMsg->ActFHandle,MemALoad,Addr8-(LONG)MemALoad);
   if (l<Addr8-(LONG)MemALoad)
      {
      FreeVec(MemALoad);
      MyWTStdMsg->Flags=MDE_FILEERROR;
      return FALSE;
      }
   }
while (Addr1<MyWTStdMsg->MemA24[Chan1-1]+MyWTStdMsg->PlayL24);
FreeVec(MemALoad);
b1=0;
Write(MyWTStdMsg->ActFHandle,&b1,1);
MyWTStdMsg->Flags=MDE_READY;
return TRUE;
}



void main (void)

{
if (CREATEPORTS(PORT_SAVER))
   {
   if (MyWTStdMsg->Version==VERSION_SAVER)
      {
      DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
      if (DOSBase)
         {            
         if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (SAVEVOC())
                  {
                  MyWTStdMsg->Flags=0;
                  MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Creative Voice 8 Bit 2.0 Saver, ");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
                  MESSAGEHANDLE();
                  MyWTStdMsg->Flags=MDE_READY
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         CloseLibrary((Library*)DOSBase);
         }
      else
         {
         SENDERROR("Can't open dos.library!");
         MyWTStdMsg->Flags=MDE_READY;         
         }
      }
   else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
   MESSAGEHANDLE();
   RemPort(MyPort);
   DeleteMsgPort(MyPort)
   }
}
