#include <exec/types.h>

#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include <string.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

extern struct DOSBase *DOSBase;

struct fmtHeader
   {
   UWORD formatTag,nChannels;
   LONG  nSamplesPerSec,nAvgBytesPerSec;
   UWORD nBlockAlign;
   UWORD nBitsPerSample;
   };

struct IFFHeader
   {
   char  IFFID[4];
   ULONG IFFLength;
   char  IFFType[4];
   };
   
struct IFFChunk
   {
   char  ChunkID[4];
   ULONG ChunkLength;
   };

IFFHeader IFFHd;
IFFChunk  IFFCh;
fmtHeader fmtHd;

LONG  l,m,MemLLoad;
APTR  MemALoad;
BOOL  SaveCopyright;
UBYTE i;



UWORD SWAP16(UWORD w1)

{
UWORD w2;

w2=((w1 & 0xFF00)/256)+((w1 & 0x00FF)*256);
return w2;
}



ULONG SWAP32(ULONG l1)

{
ULONG l2;


l2=((l1 & 0xFF000000)/0x1000000) +
   ((l1 & 0x00FF0000)/0x100) +
   ((l1 & 0x0000FF00)*0x100) +
   ((l1 & 0x000000FF)*0x1000000);
return l2;
}



BOOL GETSAVEMEM(void)

{
MemLLoad=100032;
MemALoad=AllocVec(MemLLoad,MEMF_FAST);
if (!MemALoad)
   {
   MemLLoad=AvailMem(MEMF_LARGEST)-640;
   if (MemLLoad>=640)
      {
      MemALoad=AllocVec(MemLLoad,MEMF_FAST);
      if (!MemALoad) return FALSE;
      }
   else return FALSE;
   }
return TRUE;
}



BOOL SAVEWAVE(void)

{
UBYTE  ChID;
BOOL   b;
LONG   Addr1,Addr2,Addr8;
LONG  *Data1;
UBYTE *Data8;
BYTE   CChannel=-1;
BYTE  *C8;
ULONG  CCtr=0;



if (((MyWTStdMsg->ActiveChannels & (CH_LEFT+CH_RIGHT+CH_CENTER))==CH_LEFT) ||
    ((MyWTStdMsg->ActiveChannels & (CH_LEFT+CH_RIGHT+CH_CENTER))==CH_CENTER))
   {
   fmtHd.nChannels=SWAP16(1);
   fmtHd.nBlockAlign=SWAP16(1);
   if ((MyWTStdMsg->ActiveChannels & (CH_LEFT+CH_CENTER))==CH_CENTER) ChID=3 else ChID=1;
   }
else if ((MyWTStdMsg->ActiveChannels & (CH_LEFT+CH_RIGHT))==(CH_LEFT+CH_RIGHT))
   {
   fmtHd.nChannels=SWAP16(2);
   fmtHd.nBlockAlign=SWAP16(2);
   ChID=1;
   }
else
   {
   SENDERROR("Only Mono (L or C) and Stereo (L and R) supported!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return FALSE;
   }
fmtHd.formatTag=SWAP16(1);
if (MyWTStdMsg->SRate>320)
   {
   fmtHd.nSamplesPerSec=0x112B0000;
   if (SWAP16(fmtHd.nBlockAlign)==1) fmtHd.nAvgBytesPerSec=0x112B0000 else fmtHd.nAvgBytesPerSec=0x22560000;
   }
else if (MyWTStdMsg->SRate>160)
   {
   fmtHd.nSamplesPerSec=0x22560000;
   if (SWAP16(fmtHd.nBlockAlign)==1) fmtHd.nAvgBytesPerSec=0x22560000 else fmtHd.nAvgBytesPerSec=0x44AC0000;
   }
else if (MyWTStdMsg->SRate>80)
   {
   fmtHd.nSamplesPerSec=0x44AC0000;
   if (SWAP16(fmtHd.nBlockAlign)==1) fmtHd.nAvgBytesPerSec=0x44AC0000 else fmtHd.nAvgBytesPerSec=0x88580100;
   }
else
   {
   fmtHd.nSamplesPerSec=0x80BB0000;
   if (SWAP16(fmtHd.nBlockAlign)==1) fmtHd.nAvgBytesPerSec=0x80BB0000 else fmtHd.nAvgBytesPerSec=0x00770100;
   }

fmtHd.nBitsPerSample=SWAP16(8);

if (!GETSAVEMEM())
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return FALSE;
   }
strncpy(IFFHd.IFFID,"RIFF",4);
strncpy(IFFHd.IFFType,"WAVE",4);
Write(MyWTStdMsg->ActFHandle,&IFFHd,sizeof(IFFHeader)); // RIFF____WAVE

strncpy(IFFCh.ChunkID,"fmt ",4);
IFFCh.ChunkLength=SWAP32(sizeof(fmtHeader));
Write(MyWTStdMsg->ActFHandle,&IFFCh,8);
Write(MyWTStdMsg->ActFHandle,&fmtHd,sizeof(fmtHeader));

strncpy(IFFCh.ChunkID,"data",4);
IFFCh.ChunkLength=SWAP32(SWAP16(fmtHd.nChannels)*(MyWTStdMsg->PlayL24/4));
Write(MyWTStdMsg->ActFHandle,&IFFCh,8);

Addr1=MyWTStdMsg->MemA24[ChID-1]; Addr2=MyWTStdMsg->MemA24[1];
if (SWAP16(fmtHd.nChannels)==2) b=TRUE else b=FALSE;
do
   {
   Addr8=(LONG)MemALoad;
   do
      {
      Data1=(LONG*)Addr1;  Addr1=Addr1+4;
      Data8=(UBYTE*)Addr8; Addr8++;
      *Data8=(*Data1/65536)+127;
      if ((SaveCopyright) && ((CChannel==i) || (CChannel<0)) && (CCtr<MyWTStdMsg->BitSize))
         {
         if (CChannel<0) CChannel=i;
         C8=(BYTE*)((LONG)(MyWTStdMsg->Bits)+CCtr);
         *Data8=((*Data8 & 0xFE) + (*C8 & 0x01));
         CCtr++;                     
         }
      if (b)
         {
         Data1=(LONG*)Addr2;   Addr2=Addr2+4;
         Data8=(UBYTE*)Addr8;  Addr8++;
         *Data8=(*Data1/65536)+127;
         }
      }
   while ((Addr1<MyWTStdMsg->MemA24[ChID-1]+MyWTStdMsg->PlayL24) && (Addr8<((LONG)MemALoad)+MemLLoad));
   l=Write(MyWTStdMsg->ActFHandle,MemALoad,Addr8-(LONG)MemALoad);
   if (l<Addr8-(LONG)MemALoad)
      {
      FreeVec(MemALoad);
      MyWTStdMsg->Flags=MDE_FILEERROR;
      return FALSE;
      }
   }
while (Addr1<(MyWTStdMsg->MemA24[ChID-1]+MyWTStdMsg->PlayL24));
l=Seek(MyWTStdMsg->ActFHandle,4,OFFSET_BEGINNING)-8;
m=SWAP32(l);
Write(MyWTStdMsg->ActFHandle,&m,4);
FreeVec(MemALoad);
MyWTStdMsg->Flags=MDE_READY;
return TRUE;
}



void main (void)

{
if (CREATEPORTS(PORT_SAVER))
   {
   if (MyWTStdMsg->Version==VERSION_SAVER)
      {
      DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
      if (DOSBase)
         {            
         if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (MyWTStdMsg->Bits) SaveCopyright=TRUE else SaveCopyright=FALSE;
               if (SAVEWAVE())
                  {
                  MyWTStdMsg->Flags=0;
                  MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"RIFF-WAVE 8 Bit 2.0 Saver, ");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
                  MESSAGEHANDLE();
                  MyWTStdMsg->Flags=MDE_READY
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         CloseLibrary((Library*)DOSBase);
         }
      else
         {
         SENDERROR("Can't open dos.library!");
         MyWTStdMsg->Flags=MDE_READY;         
         }
      }
   else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
   MESSAGEHANDLE();
   RemPort(MyPort);
   DeleteMsgPort(MyPort)
   }
}
