#include <exec/types.h>

#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include <string.h>
#include <math.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>
#include </common/QT.h>

extern DPANHeader DPAN;
extern AudioDescription AudioDescr;
extern LONG MyMode,MyChannels,LastPosition;
extern APTR SoundLengthMemA,SoundOffsetMemA,GfxLengthMemA,GfxOffsetMemA;
extern APTR GfxTimeMemA;
extern LONG SoundLengthMemL,SoundOffsetMemL,SampleBeginOffset,SampleEndOffset;
extern LONG SoundFrameNum;

extern void SCANANIM(LONG StartFrame, LONG EndFrame);

extern struct DOSBase *DOSBase;

char  s[25],AnimName[25],ChunkName[5];
BPTR  FHandle2;
LONG  StartFrame,EndFrame,SaveOffset;
BOOL  SaveCopyright;

SDHeader    *MySDHeader;
SDBodyAnim  *MySDBodyAnim;
SDBodyScene *MySDBodyScene;



BOOL WRITEDATA(LONG Size)

{
LONG   SaveMemL,Addr1,Addr2,Addr3;
LONG  *Data1,*Data2;
UBYTE *Data3;
APTR   SaveMemA;


SaveMemL=Size;
SaveMemA=AllocVec(SaveMemL,0);
if (!SaveMemA)
   {
   SaveMemL=Size/2;
   while ((SaveMemL>=320) && (!SaveMemA))
      {
      AllocVec(SaveMemL,0);
      SaveMemL=SaveMemL/2;
      }
   }
if (!SaveMemA) return FALSE;
while (Size>0)
   {
   if (MyMode==MD_MONO)
      {
      Addr3=(LONG)SaveMemA; Addr1=MyWTStdMsg->MemA24[2]+SaveOffset;
      do
         {
         Data1=(LONG*)Addr1;  Addr1=Addr1+4;
         Data3=(UBYTE*)Addr3; Addr3++;
         *Data3=(*Data1/65536)+128;
         }
      while ((Addr1<MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24) &&
             (Addr3<(LONG)SaveMemA+SaveMemL) && (Addr3<(LONG)SaveMemA+Size));
      }
/*   else if (MyMode==MD_STEREO)
      {
      Addr3=OldLoadAddr; 
      Addr1=MyWTStdMsg->MemA24[0];
      Addr2=MyWTStdMsg->MemA24[1];
      do
         {
         Data1=(LONG*)Addr1;  Addr1=Addr1+4;
         Data3=(UBYTE*)Addr3; Addr3++;
         *Data1=(*Data3-128)*65535;
         Data2=(LONG*)Addr2;  Addr2=Addr2+4;
         Data3=(UBYTE*)Addr3; Addr3++;
         *Data2=(*Data3-128)*65535;      
         }
      while ((Addr1<MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24) &&
             (Addr3<MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24));
      while (Addr1<MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24)
         {
         Data1=(LONG*)Addr1; Addr1=Addr1+4; *Data1=0;
         Data2=(LONG*)Addr2; Addr2=Addr2+4; *Data2=0;
         }
      }*/
      if (Size>SaveMemL) 
         {
         Write(MyWTStdMsg->ActFHandle,SaveMemA,SaveMemL);
         Size=Size-SaveMemL;
         }
      else
         {
         Write(MyWTStdMsg->ActFHandle,SaveMemA,Size);
         Size=0;
         }
   }
FreeVec(SaveMemA);
return TRUE;
}


void SAVEQTDATA(void)

{
SampleLengthTable *SLTable;
LONG              *Offset;
LONG               OffsetAddr,LengthAddr,Length;
LONG               Ctr;
LONG               MaxSaveSize,SaveSize,SaveLength;


MaxSaveSize=SoundFrameNum;
SaveSize=SampleEndOffset-SampleBeginOffset;
if (AudioDescr.ChannelNum==2) SaveSize=SaveSize*2;
if (SaveSize>MaxSaveSize) SaveSize=MaxSaveSize;
SaveOffset=0;
OffsetAddr=(LONG)SoundOffsetMemA;
LengthAddr=(LONG)SoundLengthMemA;
SLTable=(SampleLengthTable*)LengthAddr; LengthAddr=LengthAddr+12;
Length=SLTable->SamplesPerChunk;
SLTable=(SampleLengthTable*)LengthAddr;
Ctr=0;
do
   {
   if (OffsetAddr<(LONG)SoundOffsetMemA+SoundOffsetMemL)
      {
      Offset=(LONG*)OffsetAddr; OffsetAddr=OffsetAddr+4; Ctr++;
      }
   if ((LengthAddr<(LONG)SoundLengthMemA+SoundLengthMemL) && (Ctr>=SLTable->FirstChunk))
      {
      SLTable=(SampleLengthTable*)LengthAddr; LengthAddr=LengthAddr+12;
      Length=SLTable->SamplesPerChunk;
      }
   SampleBeginOffset=SampleBeginOffset-Length;
   if (SampleBeginOffset<0)
      {
      if (Length>-SampleBeginOffset)
         {
         Seek(MyWTStdMsg->ActFHandle,*Offset+Length+SampleBeginOffset,OFFSET_BEGINNING);
         SaveLength=-SampleBeginOffset;
         }
      else
         {
         Seek(MyWTStdMsg->ActFHandle,*Offset,OFFSET_BEGINNING);
         SaveLength=Length;
         }
      if (SaveSize<SaveLength) SaveLength=SaveSize;
      if (!WRITEDATA(SaveLength))
         {
         MyWTStdMsg->Flags=MDE_READY;
         return;
         }
      SaveOffset=SaveOffset+(SaveLength*4);
      SaveSize=SaveSize-SaveLength;
      
      }
   }
while ((SaveSize>0) && (Ctr>0));
MyWTStdMsg->Flags=MDE_READY;
}





/*
BOOL WRITESAMPLEDATA(LONG SaveMemL, LONG RestMemL)

{
APTR   SMemA;
LONG   SMemL;
UBYTE  ChBit;
LONG   AddrE,AddrS,RestL;
LONG  *DataL;
BYTE  *DataS,*C8;


SMemL=SaveMemL;
do
   {
   SMemA=AllocVec(SMemL,MEMF_FAST);
   if (SMemA==0) SMemL=SMemL/2;
   }
while ((!SMemA) && (SMemL>=1000));
if (!SMemA)
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return FALSE;
   }
ChBit=1;
for (i=0; i<3; i++)
   {
   if ((MyWTStdMsg->MemA24[i]) && ((SXHD.UsedChannels & ChBit)==ChBit))
      {
      AddrE=Addr[i]+SaveMemL*4;
      AddrS=(LONG)SMemA;
      do
         {
         do
            {
            DataL=(LONG*)Addr[i]; Addr[i]=Addr[i]+4;
            DataS=(BYTE*)AddrS;   AddrS++;
            *DataS=*DataL/65536;
            if ((SaveCopyright) && ((CChannel==i) || (CChannel<0)) && (CCtr<MyWTStdMsg->BitSize))
               {
               if (CChannel<0) CChannel=i;
               C8=(BYTE*)((LONG)(MyWTStdMsg->Bits)+CCtr);
               *DataS=((*DataS & 0xFE) + (*C8 & 0x01));
               CCtr++;
               }
            }
         while ((Addr[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24) &&
         //             <= ???
                (Addr[i]<AddrE) && (AddrS<(LONG)SMemA+SMemL));
         l=Write(MyWTStdMsg->ActFHandle,SMemA,AddrS-(LONG)SMemA);
         }
      while ((Addr[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24) && (Addr[i]<AddrE));
      //             <= ???
      if (RestMemL)
         {
         AddrS=(LONG)SMemA;
         do
            {
            DataS=(BYTE*)AddrS; AddrS++;
            *DataS=0;
            }
         while (AddrS<(LONG)SMemA+SMemL);
         RestL=RestMemL;
         do
            {
            l=SMemL;
            if (l>RestL) l=RestL;
            RestL=RestL-l;
            l=Write(MyWTStdMsg->ActFHandle,SMemA,l);
            }
         while (RestL>0);
         }
      }
   ChBit=ChBit*2;
   }
DataSaved=DataSaved+SaveMemL*4;
FreeVec(SMemA);
return TRUE;
}*/


BOOL COPYANIM(void)

{
APTR CopyMemA=NULL;
LONG CopyMemL,l;

CopyMemL=AvailMem(0);
while ((!CopyMemA) && (CopyMemL>1000))
   {
   CopyMemA=AllocVec(CopyMemL,0);
   if (!CopyMemA) CopyMemL=CopyMemL/2;
   }
if (!CopyMemA)
   {
   MyWTStdMsg->Flags=MDE_READY;
   return FALSE;
   }
do
   {
   l=Read(FHandle2,CopyMemA,CopyMemL);
   l=Write(MyWTStdMsg->ActFHandle,CopyMemA,l);
   }
while (l>0);   
FreeVec(CopyMemA);
return TRUE;
}



BOOL SAVEQT(void)

{
MyWTStdMsg->Flags=0;
strcpy(s,MyWTStdMsg->AnimPath);
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_FILEREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,s);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"LOAD QuickTime-file");
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
   {
   MyWTStdMsg->Flags=MDE_ERROR;
   return FALSE;
   }
else strcpy(AnimName,MyWTStdMsg->WTMsgPrc->PRC_Str1);

FHandle2=Open(AnimName,MODE_OLDFILE);
if (!FHandle2)
   {
   SENDERROR("Can't find source-QuickTime-file!");
   MyWTStdMsg->Flags=MDE_FILEERROR;
   return FALSE;
   }
StartFrame=1; EndFrame=2000000000; //Frames=0;
MySDHeader=MyWTStdMsg->SpecialData;
while ((MySDHeader) && (MySDHeader->sdh_Type!=SD_SCENE)) MySDHeader=MySDHeader->NextSpecialData;
if ((MySDHeader) && (MySDHeader->sdh_Type==SD_SCENE))
   {
   MySDBodyScene=(SDBodyScene*)MySDHeader;
   StartFrame=MySDBodyScene->sdb_StartFrame;
   EndFrame=MySDBodyScene->sdb_EndFrame;
   }
MySDHeader=MyWTStdMsg->SpecialData;
if (COPYANIM())
   {
   SCANANIM(StartFrame,EndFrame);
   MyWTStdMsg->Flags=0;
   if ((MyWTStdMsg->ActiveChannels!=CH_CENTER) && (AudioDescr.ChannelNum==1))
      {
      SENDERROR("QuickTime-file needs center-channel!");
      MyWTStdMsg->Flags=MDE_ERROR;
      return FALSE;
      }
   if ((MyWTStdMsg->ActiveChannels!=CH_LEFT+CH_RIGHT) && (AudioDescr.ChannelNum==2))
      {
      SENDERROR("QuickTime-file needs left and right channels!");
      MyWTStdMsg->Flags=MDE_ERROR;
      return FALSE;
      }   
   SAVEQTDATA();
   Close(FHandle2);
   return TRUE;
   }
else return FALSE;
}



void main (void)

{
if (CREATEPORTS(PORT_SAVER))
   {
   if (MyWTStdMsg->Version==VERSION_SAVER)
      {
      DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
      if (DOSBase)
         {            
         if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DOIT)
               {
            if (MyWTStdMsg->Bits) SaveCopyright=TRUE else SaveCopyright=FALSE;
               if (SAVEQT())
                  {
                  MyWTStdMsg->Flags=0;
                  MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"QuickTime 2.0 Stereo Saver, ");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
                  MESSAGEHANDLE();
                  MyWTStdMsg->Flags=MDE_READY
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         CloseLibrary((Library*)DOSBase);
         }
      else
         {
         SENDERROR("Can't open dos.library!");
         MyWTStdMsg->Flags=MDE_READY;         
         }
      }
   else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
   MESSAGEHANDLE();
   RemPort(MyPort);
   DeleteMsgPort(MyPort)
   }
}
