#include <exec/types.h>

#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>
//#include <math.h>

extern struct DOSBase *DOSBase;

LONG  l,m,MemLLoad;
APTR  MemALoad=NULL;
UBYTE b1,b2,b3;


void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



BOOL SAVEMOD(void)

{
LONG   l,Addr1,Addr16;
WORD   i;
UBYTE  ChCnt,XChannels,ChID,ChBit;
APTR   MemALoad;
LONG  *Data1;
UWORD *Data16;
FLOAT  Steps,Stepsize,Divider;


XChannels=MyWTStdMsg->ActiveChannels;
do
   {
   ChCnt=0; ChBit=1;
   for (i=1; i<=6; i++)
      {
      if ((XChannels & ChBit)==ChBit)
         {
         ChCnt++;
         ChID=i;
         }
      ChBit=ChBit*2;
      }
   if (ChCnt!=1)
      {
      MyWTStdMsg->Flags=0;
      MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_CHANNELREQ;
      strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Please select only one channel!");
      MyWTStdMsg->WTMsgPrc->PRC_Long1=MyWTStdMsg->ActiveChannels;
      MyWTStdMsg->WTMsgPrc->PRC_Long2=MyWTStdMsg->UsedChannels;
      MyWTStdMsg->WTMsgPrc->PRC_Long3=0;
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_Long1!=-1) XChannels=MyWTStdMsg->WTMsgPrc->PRC_Long1
      else
         {
         MyWTStdMsg->Flags=MDE_ERROR;
         return FALSE;
         }
      }
   }
while (ChCnt!=1);
MemALoad=AllocVec(5000,MEMF_FAST);
if (!MemALoad)
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return FALSE;
   }
Stepsize=MyWTStdMsg->PlayL24/10000.0;
Steps=Stepsize;
Addr1=MyWTStdMsg->MemA24[ChID-1];
Addr16=(LONG)MemALoad;
l=MyWTStdMsg->PlayL24/4;
Divider=MAX24/32767;
do
   {
   Data1=(LONG*)Addr1;    Addr1=MyWTStdMsg->MemA24[ChID-1]+(LONG)(Steps)*4;
                          Steps=Steps+Stepsize;
   Data16=(UWORD*)Addr16; Addr16=Addr16+2;
   *Data16=(UWORD)(32767-(*Data1/Divider));
   }
while ((Addr16<(LONG)MemALoad+5000) && (Steps<l));
Write(MyWTStdMsg->ActFHandle,MemALoad,5000);
FreeVec(MemALoad);
if (l<5000)
   {
   MyWTStdMsg->Flags=MDE_FILEERROR;
   return FALSE;
   };
MyWTStdMsg->Flags=MDE_READY;
return TRUE;
}



void main (void)

{
if (CREATEPORTS(PORT_SAVER))
   {
   if (MyWTStdMsg->Version==VERSION_SAVER)
      {
      DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
      if (DOSBase)
         {            
         if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (SAVEMOD())
                  {
                  MyWTStdMsg->Flags=0;
                  MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Module direct Saver (FREQ, HLKV, WAVE), ");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
                  MESSAGEHANDLE();
                  MyWTStdMsg->Flags=MDE_READY
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         CloseLibrary((Library*)DOSBase);
         }
      else
         {
         SENDERROR("Can't open dos.library!");
         MyWTStdMsg->Flags=MDE_READY;         
         }
      }
   else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
   MESSAGEHANDLE();
   RemPort(MyPort);
   DeleteMsgPort(MyPort)
   }
}
