#include <exec/types.h>

#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include <string.h>
#include <stdlib.h>
#include <inttostr.h>
#include <stdio.h>
#include <mp3enc/src/common.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/EffIncl.c>

#define NEGATIVE 3
#define POSITIVE 0

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;

extern int bitrate[2][3][15];
extern frame_params fr_ps;
extern layer        info;
//extern double       s_freq[2][4];

double s_freq[2][4]={{22.05,24,16,0},{44.1,48,32,0}};
int    bitrate[2][3][15]=
          {{{0,32,48,56,64,80,96,112,128,144,160,176,192,224,256},
            {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160},
            {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}},
           {{0,32,64,96,128,160,192,224,256,288,320,352,384,416,448},
            {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384},
            {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}}};
double multiple[64] = 
          {2.00000000000000, 1.58740105196820, 1.25992104989487,
           1.00000000000000, 0.79370052598410, 0.62996052494744, 0.50000000000000,
           0.39685026299205, 0.31498026247372, 0.25000000000000, 0.19842513149602,
           0.15749013123686, 0.12500000000000, 0.09921256574801, 0.07874506561843,
           0.06250000000000, 0.04960628287401, 0.03937253280921, 0.03125000000000,
           0.02480314143700, 0.01968626640461, 0.01562500000000, 0.01240157071850,
           0.00984313320230, 0.00781250000000, 0.00620078535925, 0.00492156660115,
           0.00390625000000, 0.00310039267963, 0.00246078330058, 0.00195312500000,
           0.00155019633981, 0.00123039165029, 0.00097656250000, 0.00077509816991,
           0.00061519582514, 0.00048828125000, 0.00038754908495, 0.00030759791257,
           0.00024414062500, 0.00019377454248, 0.00015379895629, 0.00012207031250,
           0.00009688727124, 0.00007689947814, 0.00006103515625, 0.00004844363562,
           0.00003844973907, 0.00003051757813, 0.00002422181781, 0.00001922486954,
           0.00001525878906, 0.00001211090890, 0.00000961243477, 0.00000762939453,
           0.00000605545445, 0.00000480621738, 0.00000381469727, 0.00000302772723,
           0.00000240310869, 0.00000190734863, 0.00000151386361, 0.00000120155435,
           1E-20};        

extern void WRITE(UWORD LEdge, UWORD TEdge, UBYTE StPen, UBYTE DMode, Window *Wind, char *txt);
extern void MAKEBORDER(Window *Wind, UWORD LEdge, UWORD TEdge, UWORD REdge, UWORD BEdge, UBYTE Color);
extern void DOTHRESHOLD(LONG SAddr);
extern BOOL SAVEMPEG(void);

LONG MemLLoad,l,m;
APTR MemALoad;

PropInfo   SchieberInfo[1]={FREEHORIZ,0,0,0,0,0,0,0,0,0,0};
Image      SImage[2];
char       Buffer[2][20],UndoBuffer[2][20];
StringInfo TextInfo[2]={(UBYTE*)Buffer[0],(UBYTE*)UndoBuffer[0],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[1],(UBYTE*)UndoBuffer[1],0,9,0,0,0,0,0,0,NULL,0,NULL};
Gadget     Schieber[2]={NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[0],NULL,NULL,0,&SchieberInfo[0],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[1],NULL,NULL,0,&SchieberInfo[1],0,0};
Gadget     TextGad[2]={NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[0],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[1],0,0};
IntuiText  DKnopfTx[3]={2,0,0,3,2,NULL,NULL,NULL,
                        2,0,0,3,2,NULL,NULL,NULL,
                        2,0,0,3,2,NULL,NULL,NULL};
Gadget     DKnopf={NULL,10,40,128,16,GADGHCOMP+GADGIMAGE,0x1,BOOLGADGET,NULL,NULL,&DKnopfTx[1],0,NULL,11,0};
LONG       BeginOffset,EndOffset;
UBYTE      ChBit,ChID;
BOOL       Valid;                   



int refill_buffer(Bit_stream_struc *bs)

{
register int i=bs->buf_size-2-bs->buf_byte_idx;
register unsigned long n=1;
register int index=0;
char val[2];

printf("\n!!!!!!!!!! ReadBuffer!!!!!!!!!!\n");
while ((i>=0) && (!bs->eob)) n=Read(bs->pt,&bs->buf[i--],sizeof(short));
if (!n)
   {
   bs->eob= i+1;
   }
return 0;
}



void empty_buffer(Bit_stream_struc *bs,int minimum)

{
register int i;

for (i=bs->buf_size-1;i>=minimum;i--) Write(bs->pt,&bs->buf[i],sizeof(unsigned char));
printf("\n Saving %d Bytes",bs->buf_size-1-minimum);
for (i=minimum-1; i>=0; i--) bs->buf[bs->buf_size-minimum+i]=bs->buf[i];
bs->buf_byte_idx=bs->buf_size-1-minimum;
bs->buf_bit_idx=8;
}



void LEAVEERROR(char *Txt)

{
SENDERROR(Txt);
MyWTStdMsg->Flags=MDE_ERROR;
MESSAGEHANDLE();
if (DOSBase) CloseLibrary((Library*)DOSBase);
if (GfxBase) CloseLibrary((Library*)GfxBase);
if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
RemPort(MyPort);
DeleteMsgPort(MyPort);
exit(0);
}


void CREATEPROPGAD(WORD LEdge, WORD TEdge, WORD XSet, WORD XJump, WORD GadNum,
                   WORD IDOffset, Window *XWindow)

{
SImage[GadNum]=*MyWTStdMsg->WTImg->KnobImg;
Schieber[GadNum].LeftEdge=LEdge;
Schieber[GadNum].TopEdge=TEdge;
Schieber[GadNum].GadgetID=IDOffset+(GadNum+1)*2-1,0;
SchieberInfo[GadNum].HorizPot=XSet;
SchieberInfo[GadNum].HorizBody=XJump;
TextGad[GadNum].LeftEdge=LEdge+332;
TextGad[GadNum].TopEdge=TEdge+1;
TextGad[GadNum].GadgetID=IDOffset+(GadNum+1)*2,0;
strcpy(UndoBuffer[GadNum],"");
MAKEBORDER(XWindow,LEdge+330,TEdge,LEdge+394,TEdge+14,NEGATIVE);
}



BOOL DEFINEMPEG(void)

{
Window       *DWindow;
UBYTE         RawCode,GadCode;
IntuiMessage *IMsg;
Gadget       *XGadget;
LONG          BrtIndex,Brt,BrtDiff;
BYTE          i;
SelectListGad MySList1={NULL,&DKnopf,2,0,0,0,{&DKnopfTx[0],&DKnopfTx[1],&DKnopfTx[2],
                                              NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
                                              NULL,NULL,NULL,NULL}};
//LONG LegalFreq[6]={16000,22050,24000,32000,44100,48000};

printf("%d  %d  %d\n",bitrate[0][0][14],(LONG)multiple[0],(LONG)s_freq[0][0]);
fr_ps.header = &info;
fr_ps.tab_num=-1;
fr_ps.alloc=NULL;
info.version = MPEG_AUDIO_ID;
info.lay=2;
info.bitrate_index=14;

MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Definition MPEG Saver");
MyWTStdMsg->WTMsgPrc->PRC_Long1=100;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=1;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   SENDERROR("Couldn't open window!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return FALSE;
   }
DWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
DKnopf.GadgetRender=MyWTStdMsg->WTImg->GImg2;
DKnopfTx[0].ITextFont=MyWTStdMsg->WTScreen->Font;
DKnopfTx[1].ITextFont=MyWTStdMsg->WTScreen->Font;
DKnopfTx[2].ITextFont=MyWTStdMsg->WTScreen->Font;
DKnopfTx[0].IText="Layer I";
DKnopfTx[1].IText="Layer II";
DKnopfTx[2].IText="Layer III";
MySList1.GadWindow=DWindow;                             
for (i=0; i<1; i++)
   {
   CREATEPROPGAD(10,76+i*17,13*5041,5041,0,8,DWindow);
   AddGadget(DWindow,&TextGad[i],NULL);
   AddGadget(DWindow,&Schieber[i],NULL);
   }
inttostring(bitrate[1][1][14],Buffer[0]);
WRITE(410,77,2,0,DWindow,"kBit / sec");
AddGadget(DWindow,&DKnopf,NULL);

RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(DWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);

   if ((GadCode==9) || ((Schieber[0].Flags & SELECTED)==SELECTED))
      {
      BrtIndex=(SchieberInfo[0].HorizPot/5041)+1;
      if (BrtIndex<1) BrtIndex=1; if (BrtIndex>14) BrtIndex=14;
      inttostring(bitrate[1][1][BrtIndex],Buffer[0]);
      RefreshGadgets(&TextGad[0],DWindow,NULL);
      }
   if (GadCode==10)
      {
      Brt=strtol(Buffer[0],NULL,0);
      BrtDiff=1000000000;
      for (i=1; i<=14; i++) if (labs(Brt-bitrate[1][1][i])<BrtDiff)
         {
         BrtDiff=labs(Brt-bitrate[1][1][i]);
         BrtIndex=i;
         }
      if (BrtIndex<1) BrtIndex=1; if (BrtIndex>14) BrtIndex=14;
      inttostring(bitrate[1][1][BrtIndex],Buffer[0]);
      SchieberInfo[0].HorizPot=(BrtIndex-1)*5041;
      RefreshGadgets(&Schieber[0],DWindow,NULL);
      }
   if (GadCode==11)
      {
      MyWTStdMsg->Flags=0;
      MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_DOSELECTLIST;
      MyWTStdMsg->WTMsgPrc->PRC_NewPtr=&MySList1;
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_Long1!=-1) info.lay=MyWTStdMsg->WTMsgPrc->PRC_Long1;
      RefreshGadgets(&DKnopf,DWindow,NULL);
      }

   }
while (!((GadCode==1) || (GadCode==2) || (RawCode==68) || (RawCode==69)));
MyWTStdMsg->ActWaveOp->Channels=MyWTStdMsg->WTMsgPrc->PRC_Long1;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_LEAVEWIN;
MyWTStdMsg->WTMsgPrc->PRC_Long1=RawCode;
MyWTStdMsg->WTMsgPrc->PRC_Long2=GadCode;
MyWTStdMsg->WTMsgPrc->PRC_NewPtr=DWindow;
MESSAGEHANDLE();
info.bitrate_index=BrtIndex;
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==1) return TRUE else return FALSE;
}



void main (void)

{
if (CREATEPORTS(PORT_SAVER))
   {
   if (MyWTStdMsg->Version==VERSION_SAVER)
      {
      DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
      GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
      IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
      if ((DOSBase) && (GfxBase) && (IntuitionBase))
         {            
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {

            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (DEFINEMPEG())
                  {
                  if (SAVEMPEG())
                     {
                     MyWTStdMsg->Flags=0;
                     MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
                     strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"MPEG I & II 2.0 Stereo Saver,");
                     strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
                     strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
                     strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
                     strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
                     MESSAGEHANDLE();
                     MyWTStdMsg->Flags=MDE_READY
                     }
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         if (DOSBase) CloseLibrary((Library*)DOSBase);
         if (GfxBase) CloseLibrary((Library*)GfxBase);
         if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
         }
      else
         {
         SENDERROR("Can't open dos.library!");
         MyWTStdMsg->Flags=MDE_READY;         
         }
      }
   else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
   MESSAGEHANDLE();
   RemPort(MyPort);
   DeleteMsgPort(MyPort)
   }
}
