#include <exec/types.h>

#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>
#include <math.h>



extern struct DOSBase *DOSBase;

struct IFFChunk
   {
   char  ChunkID[4];
   ULONG ChunkLength;
   };

struct DPANChunk
   {
   UWORD Version,Frames;
   UBYTE FPS,pad1,pad2,pad3;
   };

struct ANHDChunk
   {
   UBYTE Operation,Mask;
   UWORD w,h,x,y;
   LONG  AbsTime,RelTime;
   UBYTE Interleave,pad0;
   LONG  Bits;
   UBYTE pad[16];
   };

struct SXHeader
   {
   UBYTE SampleDepth,FixedVolume;
   LONG  Length,PlayRate,CompressionMethod;
   UBYTE UsedChannels,UsedMode;
   LONG  PlayFreq;
   UWORD Loop;
   };

IFFChunk  IFFCh;
ANHDChunk ANHD;
DPANChunk DPAN;
SXHeader  SXHD;

char  s[25],AnimName[25],ChunkName[5];
BPTR  FHandle2;
BOOL  ILBMFound,SXHDWritten,SBDYDone,GoodANHD,SaveCopyright;
LONG  l,m,n,MyLastPos,LastSavePos,SXHDSize,SBDYSize,DPANSize,SaveSize,RestSize;
LONG  Addr[3],CCtr=0;
LONG  ChunkLength,LastFORMPos,DataSaved,StartFrame,EndFrame,Frames,LastFORMSize;
UBYTE i;
BYTE  CChannel=-1;

SDHeader    *MySDHeader;
SDBodyAnim  *MySDBodyAnim;
SDBodyScene *MySDBodyScene;
SDBodyLoop  *MySDBodyLoop;



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



void SAVEOTHERDATA(void)

{
LONG SMemL;
APTR SMemA;
char s[50];


MyLastPos=Seek(FHandle2,LastSavePos,OFFSET_BEGINNING);

inttostr(LastSavePos,s);
strncat(s," Bytes saved",13);
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,s);
MyWTStdMsg->WTMsgPrc->PRC_Long1=7;
MESSAGEHANDLE();

SMemL=MyLastPos-LastSavePos;
do
   {
   SMemA=AllocVec(SMemL,MEMF_FAST);
   if (!SMemA) SMemL=SMemL/2;
   }
while ((!SMemA) && (SMemL>1000));
do
   {
   m=MyLastPos-LastSavePos;
   if (m>SMemL) m=SMemL;
   l=Read(FHandle2,SMemA,m);
   if (l>0)
      {
      LastSavePos=LastSavePos+l;
      l=Write(MyWTStdMsg->ActFHandle,SMemA,m);
      }
   }
while (LastSavePos!=MyLastPos);
FreeVec(SMemA);
}



BOOL WRITESAMPLEDATA(LONG SaveMemL, LONG RestMemL)

{
APTR   SMemA;
LONG   SMemL;
UBYTE  ChBit;
LONG   AddrE,AddrS,RestL;
LONG  *DataL;
BYTE  *DataS,*C8;


SMemL=SaveMemL;
do
   {
   SMemA=AllocVec(SMemL,MEMF_FAST);
   if (SMemA==0) SMemL=SMemL/2;
   }
while ((!SMemA) && (SMemL>=1000));
if (!SMemA)
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return FALSE;
   }
ChBit=1;
for (i=0; i<3; i++)
   {
   if ((MyWTStdMsg->MemA24[i]) && ((SXHD.UsedChannels & ChBit)==ChBit))
      {
      AddrE=Addr[i]+SaveMemL*4;
      AddrS=(LONG)SMemA;
      do
         {
         do
            {
            DataL=(LONG*)Addr[i]; Addr[i]=Addr[i]+4;
            DataS=(BYTE*)AddrS;   AddrS++;
            *DataS=*DataL/65536;
            if ((SaveCopyright) && ((CChannel==i) || (CChannel<0)) && (CCtr<MyWTStdMsg->BitSize))
               {
               if (CChannel<0) CChannel=i;
               C8=(BYTE*)((LONG)(MyWTStdMsg->Bits)+CCtr);
               *DataS=((*DataS & 0xFE) + (*C8 & 0x01));
               CCtr++;
               }
            }
         while ((Addr[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24) &&
         //             <= ???
                (Addr[i]<AddrE) && (AddrS<(LONG)SMemA+SMemL));
         l=Write(MyWTStdMsg->ActFHandle,SMemA,AddrS-(LONG)SMemA);
         }
      while ((Addr[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24) && (Addr[i]<AddrE));
      //             <= ???
      if (RestMemL)
         {
         AddrS=(LONG)SMemA;
         do
            {
            DataS=(BYTE*)AddrS; AddrS++;
            *DataS=0;
            }
         while (AddrS<(LONG)SMemA+SMemL);
         RestL=RestMemL;
         do
            {
            l=SMemL;
            if (l>RestL) l=RestL;
            RestL=RestL-l;
            l=Write(MyWTStdMsg->ActFHandle,SMemA,l);
            }
         while (RestL>0);
         }
      }
   ChBit=ChBit*2;
   }
DataSaved=DataSaved+SaveMemL*4;
FreeVec(SMemA);
return TRUE;
}



BOOL SAVEANIM(void)

{
while ((MyWTStdMsg->ActiveChannels!=CH_LEFT) &&
       (MyWTStdMsg->ActiveChannels!=CH_RIGHT) &&
       (MyWTStdMsg->ActiveChannels!=(CH_LEFT+CH_RIGHT)) &&
       (MyWTStdMsg->ActiveChannels!=CH_CENTER))
   {
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_CHANNELREQ;
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Please select only Mono- (L, R or C) or Stereo-channels (L and R)!");
   MyWTStdMsg->WTMsgPrc->PRC_Long1=((CH_LEFT+CH_RIGHT+CH_CENTER) & MyWTStdMsg->ActiveChannels);
   MyWTStdMsg->WTMsgPrc->PRC_Long2=((CH_LEFT+CH_RIGHT+CH_CENTER) & MyWTStdMsg->ActiveChannels);
   MyWTStdMsg->WTMsgPrc->PRC_Long3=0;
   MESSAGEHANDLE();
   if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
      {
      MyWTStdMsg->Flags=MDE_ERROR;
      return FALSE;
      }
   else MyWTStdMsg->ActiveChannels=MyWTStdMsg->WTMsgPrc->PRC_Long1;
   }
MyWTStdMsg->Flags=0;
strcpy(s,MyWTStdMsg->AnimPath);
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_FILEREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,s);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"LOAD ANIM-file");
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
   {
   MyWTStdMsg->Flags=MDE_ERROR;
   return FALSE;
   }
else strcpy(AnimName,MyWTStdMsg->WTMsgPrc->PRC_Str1);

FHandle2=Open(AnimName,MODE_OLDFILE);
if (!FHandle2)
   {
   SENDERROR("Can't find source-ANIM-file!");
   MyWTStdMsg->Flags=MDE_FILEERROR;
   return FALSE;
   }
StartFrame=1; EndFrame=2000000000; Frames=0;
MySDHeader=MyWTStdMsg->SpecialData;
while ((MySDHeader) && (MySDHeader->sdh_Type!=SD_SCENE)) MySDHeader=MySDHeader->NextSpecialData;
if ((MySDHeader) && (MySDHeader->sdh_Type==SD_SCENE))
   {
   MySDBodyScene=(SDBodyScene*)MySDHeader;
   StartFrame=MySDBodyScene->sdb_StartFrame;
   EndFrame=MySDBodyScene->sdb_EndFrame;
   }

MySDHeader=MyWTStdMsg->SpecialData;
while ((MySDHeader) && (MySDHeader->sdh_Type!=SD_LOOP)) MySDHeader=MySDHeader->NextSpecialData;
if ((MySDHeader) && (MySDHeader->sdh_Type==SD_LOOP)) MySDBodyLoop=(SDBodyLoop*)MySDHeader else MySDBodyLoop=NULL;

ChunkName[5]=(char)0;
Seek(FHandle2,8,OFFSET_BEGINNING);
Read(FHandle2,&ChunkName,4);
if (strncmp(ChunkName,"ANIM",4))
   {
   Close(FHandle2);
   strcpy(s,"No IFF-ANIM-format (");
   strncat(s,ChunkName,4);
   strncat(s,") !",4);
   SENDERROR(s);
   MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   return FALSE;
   }
Seek(FHandle2,12,OFFSET_CURRENT);
GoodANHD=FALSE;
DPAN.FPS=0;
do
   {
   l=Read(FHandle2,&ChunkName,4);
   l=l+Read(FHandle2,&ChunkLength,4);
   if (!(strncmp(ChunkName,"DPAN",4))) l=Read(FHandle2,&DPAN,ChunkLength)
   else
      {
      if (!(strncmp(ChunkName,"ANHD",4))) GoodANHD=TRUE;
      if (ChunkLength%2==1) ChunkLength++;
      m=Seek(FHandle2,ChunkLength,OFFSET_CURRENT);
      }
   }
while ((strncmp(ChunkName,"BODY",4)) && (strncmp(ChunkName,"DLTA",4)) &&
       (strncmp(ChunkName,"DPAN",4)) && (l>0));
DPANSize=0;

DPANSize=sizeof(DPANChunk)+8;
MySDHeader=MyWTStdMsg->SpecialData;
while ((MySDHeader) && (MySDHeader->sdh_Type!=SD_ANIMINFO)) MySDHeader=MySDHeader->NextSpecialData;
if ((MySDHeader) && (MySDHeader->sdh_Type==SD_ANIMINFO))
   {
   MySDBodyAnim=(SDBodyAnim*)MySDHeader;
   DPAN.Frames=MySDBodyAnim->sdb_Frames;
   DPAN.FPS=MySDBodyAnim->sdb_FPS;
   }
Seek(FHandle2,8,OFFSET_BEGINNING);
Read(FHandle2,&ChunkName,4);
ILBMFound=FALSE; SXHDWritten=FALSE;
LastSavePos=0;   DataSaved=0;
LastFORMPos=16;
if (DPAN.FPS>0) SBDYSize=(LONG)((10000000.0/(MyWTStdMsg->SRate*2.79365))/DPAN.FPS) else SBDYSize=0;

SXHD.SampleDepth=8;
SXHD.FixedVolume=64;
SXHD.Length=SBDYSize;
SXHD.PlayRate=MyWTStdMsg->SRate;
SXHD.CompressionMethod=0;
SXHD.UsedChannels=MyWTStdMsg->ActiveChannels;
SXHD.PlayFreq=(LONG)(10000000.0/(MyWTStdMsg->SRate*2.79365));
SXHD.Loop=0;
if (MySDBodyLoop) SXHD.Loop=MySDBodyLoop->sdb_Loop;
if (MyWTStdMsg->ActiveChannels==CH_LEFT+CH_RIGHT) SXHD.UsedMode=MD_STEREO else SXHD.UsedMode=MD_MONO;
if (SXHD.UsedMode==MD_STEREO) SBDYSize=SBDYSize*2;
SXHDSize=sizeof(SXHeader)+8;
if (SBDYSize>0) SBDYSize=SBDYSize+8 else DPANSize=0;
for (i=0; i<3; i++) Addr[i]=MyWTStdMsg->MemA24[i];
do
   {
   l=Read(FHandle2,&ChunkName,4);
   l=l+Read(FHandle2,&ChunkLength,4);
   if (l==8)
      {
      if (!(strncmp(ChunkName,"FORM",4)))
         {
         SAVEOTHERDATA();
         if ((Frames>=StartFrame) && (Frames<=EndFrame))
            {
            l=Seek(MyWTStdMsg->ActFHandle,LastFORMPos,OFFSET_BEGINNING);
            LastFORMSize=l-LastFORMPos-12;
            LastFORMPos=l-4;
            m=Write(MyWTStdMsg->ActFHandle,&LastFORMSize,4);
            l=Seek(MyWTStdMsg->ActFHandle,0,OFFSET_END);
            }
         else LastFORMPos=Seek(MyWTStdMsg->ActFHandle,0,OFFSET_CURRENT)-4;
         Frames++;
         if (DataSaved<MyWTStdMsg->PlayL24) SBDYDone=FALSE;
         l=Read(FHandle2,&ChunkName,4);
         if (!(strncmp(ChunkName,"ILBM",4))) ILBMFound=TRUE;
         }
      else if ((!strncmp(ChunkName,"SBDY",4)) && (Frames>=StartFrame) && (Frames<=EndFrame))
         {
         l=Seek(FHandle2,-8,OFFSET_CURRENT);
         SAVEOTHERDATA();
         l=Seek(FHandle2,ChunkLength+8,OFFSET_CURRENT);
         ChunkLength=ChunkLength+8;
         if (ChunkLength%2==1) ChunkLength++;
         LastSavePos=LastSavePos+ChunkLength;
         }
      else if (!strncmp(ChunkName,"SXHD",4))
         {
         l=Seek(FHandle2,-8,OFFSET_CURRENT);
         SAVEOTHERDATA();
         l=Seek(FHandle2,ChunkLength+8,OFFSET_CURRENT);
         ChunkLength=ChunkLength+8;
         if (ChunkLength%2==1) ChunkLength++;
         LastSavePos=LastSavePos+ChunkLength;
         }
      else if ((ILBMFound) &&
               (((!strncmp(ChunkName,"BMHD",4)) && (!GoodANHD)) ||
                ((!strncmp(ChunkName,"ANHD",4)) && (!SBDYDone))) &&
               (Frames>=StartFrame) && (Frames<=EndFrame))
         {
         if (!strncmp(ChunkName,"ANHD",4)) ChunkLength=ChunkLength-Read(FHandle2,&ANHD,sizeof(ANHDChunk));
         l=Seek(FHandle2,ChunkLength,OFFSET_CURRENT);
         SAVEOTHERDATA();
         if ( ( (!strncmp(ChunkName,"BMHD",4)) || (!strncmp(ChunkName,"ANHD",4)) ) &&
             (DPANSize))
            {
            strncpy(IFFCh.ChunkID,"DPAN",4);
            IFFCh.ChunkLength=sizeof(DPANChunk);
            Write(MyWTStdMsg->ActFHandle,&IFFCh,sizeof(IFFChunk));
            l=Write(MyWTStdMsg->ActFHandle,&DPAN,sizeof(DPANChunk));
            DPANSize=0;
            }
         if (( (!strncmp(ChunkName,"BMHD",4)) || (!strncmp(ChunkName,"ANHD",4)) ) &&
             (Frames==1) && (!SXHDWritten))
            {
            strncpy(IFFCh.ChunkID,"SXHD",4);
            IFFCh.ChunkLength=sizeof(SXHeader);
            Write(MyWTStdMsg->ActFHandle,&IFFCh,sizeof(IFFChunk));
            l=Write(MyWTStdMsg->ActFHandle,&SXHD,sizeof(SXHeader));
            }
         if (((Frames>=StartFrame) && (Frames<=EndFrame)) && (!SBDYDone))
            {
            if (DPAN.FPS) SaveSize=(LONG)((10000000.0/(MyWTStdMsg->SRate*2.79365))/DPAN.FPS)
            else
               {
               if (ANHD.RelTime==0) ANHD.RelTime=1;
               SaveSize=(LONG)((10000000.0/(MyWTStdMsg->SRate*2.79365))*ANHD.RelTime/60.0);
               }
            if (SaveSize*4>MyWTStdMsg->PlayL24-DataSaved)
               {
               RestSize=SaveSize-((MyWTStdMsg->PlayL24-DataSaved)/4);
               SaveSize=(MyWTStdMsg->PlayL24-DataSaved)/4;
               }
            else RestSize=0;
            if (SXHD.UsedMode==MD_STEREO) SBDYSize=((SaveSize+RestSize)*2)+8 else SBDYSize=SaveSize+RestSize+8;

            strncpy(IFFCh.ChunkID,"SBDY",4);
            IFFCh.ChunkLength=SBDYSize-8;
            Write(MyWTStdMsg->ActFHandle,&IFFCh,sizeof(IFFChunk));
            if (!WRITESAMPLEDATA(SaveSize,RestSize))
               {
               Close(FHandle2);
               return FALSE;
               }
            if (SBDYSize%2==1) m=Write(MyWTStdMsg->ActFHandle,&m,1);
            if (DPAN.FPS==0) SBDYSize=0;
            SBDYDone=TRUE;
            }
         ILBMFound=FALSE; SXHDWritten=TRUE;
         }
      else l=Seek(FHandle2,ChunkLength,OFFSET_CURRENT);
      if (ChunkLength%2==1) l=Seek(FHandle2,1,OFFSET_CURRENT);
      }
   }
while ((l>0) && (Frames<=EndFrame));

if ((DataSaved<MyWTStdMsg->PlayL24) && (Frames<=EndFrame))
   {
   SBDYSize=((MyWTStdMsg->PlayL24-DataSaved)/4);
   if (SXHD.UsedMode==MD_STEREO) SBDYSize=SBDYSize*2;
   SBDYSize=SBDYSize+8;
   strncpy(IFFCh.ChunkID,"SBDY",4);
   IFFCh.ChunkLength=SBDYSize-8;
   Write(MyWTStdMsg->ActFHandle,&IFFCh,sizeof(IFFChunk));     
   if (!WRITESAMPLEDATA((MyWTStdMsg->PlayL24-DataSaved)/4,0))
      {
      Close(FHandle2);
      return FALSE;
      }
   }

/*{l:=DosSeek(ActFHandle,LastFORMPos,OFFSET_BEGINNING);
LastFORMSize:=l-LastFORMPos-12;
LastFORMPos:=l-4;
m:=DosWrite(ActFHandle,^LastFORMSize,4);
l:=DosSeek(ActFHandle,0,OFFSET_END); }*/

l=Seek(FHandle2,0,OFFSET_END);
SAVEOTHERDATA();
l=Seek(MyWTStdMsg->ActFHandle,4,OFFSET_BEGINNING)-8;
l=Write(MyWTStdMsg->ActFHandle,&l,4);
Close(FHandle2);

MyWTStdMsg->Flags=MDE_READY;
return TRUE;
}



void main (void)

{
if (CREATEPORTS(PORT_SAVER))
   {
   if (MyWTStdMsg->Version==VERSION_SAVER)
      {
      DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
      if (DOSBase)
         {            
         if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DOIT)
               {
            if (MyWTStdMsg->Bits) SaveCopyright=TRUE else SaveCopyright=FALSE;
               if (SAVEANIM())
                  {
                  MyWTStdMsg->Flags=0;
                  MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"IFF-SoundANIM 8 Bit 2.0 Saver, ");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
                  MESSAGEHANDLE();
                  MyWTStdMsg->Flags=MDE_READY
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         CloseLibrary((Library*)DOSBase);
         }
      else
         {
         SENDERROR("Can't open dos.library!");
         MyWTStdMsg->Flags=MDE_READY;         
         }
      }
   else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
   MESSAGEHANDLE();
   RemPort(MyPort);
   DeleteMsgPort(MyPort)
   }
}
